/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.group.OptionGroup;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import lombok.Generated;

public class BooleanOptionEdit
extends OptionEdit
implements ItemListener,
ActionListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.BooleanOptionEdit");
    protected JCheckBox check;
    protected String subjectName;
    protected OptionEdit subjectEdit;
    protected boolean subjectInverse;
    protected boolean askForActivate;
    protected boolean askForDeactivate;

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.check = new JCheckBox(Option.getResources().getString("option." + this.option.getName() + ".label", "Missing: " + this.option.getName())){

            @Override
            public void updateUI() {
                SwingUtil.cleanupKeyHandlers(this);
                this.setBackground(null);
                super.updateUI();
                BooleanOptionEdit.this.origBackgroundColor = this.getBackground();
            }
        };
        this.check.setName("CheckBox-" + this.option.getName());
        String string = this.getString("mnemonic", null);
        if (string != null && string.length() > 0) {
            this.check.setMnemonic(string.charAt(0));
        }
        this.check.addActionListener(this);
        this.add((Component)this.check, "West");
        Boolean bl = (Boolean)this.option.getValue();
        if (bl != null) {
            this.check.setSelected(bl);
        }
        this.disabled = this.getBoolean("disabled", false);
        if (this.disabled) {
            this.setEnabled(false);
        }
        boolean bl2 = this.getBoolean("visible", true);
        this.check.setVisible(bl2);
        this.subjectName = this.getString("subject", null);
        this.subjectInverse = this.getBoolean("inverse", false);
        if (this.subjectName != null && this.subjectName.length() > 0) {
            this.check.addItemListener(this);
        }
        this.askForActivate = Option.getResources().getString("option." + this.option.getName() + ".activate.message", null) != null;
        this.askForDeactivate = Option.getResources().getString("option." + this.option.getName() + ".deactivate.message", null) != null;
        String string2 = this.getString("tooltip", null);
        if (string2 != null) {
            this.check.setToolTipText(string2);
        }
    }

    @Override
    public void updateUI() {
        if (BooleanOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "updateUI()", 221).log();
        }
        super.updateUI();
        if (this.check != null) {
            this.check.updateUI();
        }
    }

    @Override
    public boolean isModified() {
        boolean bl;
        boolean bl2 = bl = !(this.option.getValue() instanceof Boolean) || this.check.isSelected() != ((Boolean)this.option.getValue()).booleanValue();
        if (bl && BooleanOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 248).add("Modified - edit", this)).add("option", this.option)).log();
        }
        return bl;
    }

    @Override
    public boolean checkValue() {
        Boolean bl;
        if (BooleanOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "checkValue()", 263).log();
        }
        if (!this.option.checkValue(this, bl = Boolean.valueOf(this.check.isSelected()))) {
            if (!OptionEdit.isHighlightOnCheckOnly()) {
                this.check.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public void readValue() {
        if (BooleanOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "readValue()", 282).log();
        }
        Boolean bl = this.check.isSelected();
        this.option.setValue(bl);
    }

    @Override
    public void update(Option option) {
        if (BooleanOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(Option)", 297).addDetail("option", option)).log();
        }
        this.option = option;
        Boolean bl = (Boolean)option.getValue();
        if (bl != null) {
            this.check.setSelected(bl);
        }
    }

    public boolean isSelected() {
        return this.check.isSelected();
    }

    public void setSelected(boolean bl) {
        this.check.setSelected(bl);
    }

    public JCheckBox getCheckBox() {
        return this.check;
    }

    @Override
    public void highlight(int n, int n2, int n3) {
        if (BooleanOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "highlight(int,int,int)", 364).addDetail("start", n)).addDetail("end", n2)).addDetail("messageType", n3)).log();
        }
        if (this.check != null) {
            this.check.setBackground(this.getHighlightingColorNonTransparent(n3));
        }
    }

    @Override
    public void dehighlight() {
        if (BooleanOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "dehighlight()", 379).log();
        }
        if (this.check != null && this.origBackgroundColor != null) {
            this.check.setBackground(this.origBackgroundColor);
        }
        super.dehighlight();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.disabled) {
            bl = false;
        }
        this.check.setEnabled(bl);
    }

    @Override
    public boolean isEnabled() {
        return this.check.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.check.requestFocus();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (BooleanOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "actionPerformed(ActionEvent)", 448).addDetail("e", actionEvent)).log();
        }
        if (BooleanOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "actionPerformed(ActionEvent)", 450).add("check.isSelected()", this.check.isSelected())).log();
        }
        String string = null;
        if (this.askForActivate && this.check.isSelected()) {
            string = "activate";
        } else if (this.askForDeactivate && !this.check.isSelected()) {
            string = "deactivate";
        }
        if (string != null) {
            int n = Message.showMessage(this.check, "option." + this.option.getName() + "." + string);
            if (BooleanOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "actionPerformed(ActionEvent)", 461).add("ret", n)).log();
            }
            if (n != 0) {
                this.check.setSelected(!this.check.isSelected());
                return;
            }
        }
        this.fireUndoableEditHappened();
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (BooleanOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "itemStateChanged(ItemEvent)", 483).addDetail("e", itemEvent)).log();
        }
        OptionGroup optionGroup = this.getOptionGroup();
        if (this.subjectName != null && this.subjectName.length() > 0) {
            if (this.subjectEdit == null) {
                while (optionGroup.getParentGroup() != null) {
                    optionGroup = optionGroup.getParentGroup();
                }
                if (BooleanOptionEdit.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "itemStateChanged(ItemEvent)", 494).add("ParentGroup found", optionGroup)).log();
                }
                this.subjectEdit = optionGroup.findEdit(this.subjectName);
            }
            if (this.subjectEdit != null) {
                if (BooleanOptionEdit.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "itemStateChanged(ItemEvent)", 498).add("subjectEdit found", this.subjectEdit)).log();
                }
                if (this.subjectInverse) {
                    this.subjectEdit.setEnabled(itemEvent.getStateChange() == 2);
                } else {
                    this.subjectEdit.setEnabled(itemEvent.getStateChange() == 1);
                }
            }
        }
    }

    public void fireUndoableEditHappened() {
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableSelection(this.check, this.check.isSelected())));
    }

    public static class UndoableSelection
    extends AbstractUndoableEdit {
        private JCheckBox checkbox;
        private boolean selected;
        protected boolean canUndo;

        public UndoableSelection(JCheckBox jCheckBox, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableSelection.UndoableSelection(JCheckBox,boolean)", 559).addDetail("checkbox", jCheckBox)).addDetail("selected", bl)).log();
            }
            this.checkbox = jCheckBox;
            this.selected = bl;
            this.canUndo = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableSelection.undo()", 579).log();
            }
            if (!this.canUndo) {
                throw new CannotUndoException();
            }
            this.checkbox.setSelected(!this.selected);
            this.checkbox.requestFocus();
            this.canUndo = false;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableSelection.redo()", 599).log();
            }
            if (this.canUndo) {
                throw new CannotRedoException();
            }
            this.checkbox.setSelected(this.selected);
            this.checkbox.requestFocus();
            this.canUndo = true;
        }

        @Override
        public boolean canUndo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableSelection.canUndo()", 619).log();
            }
            return this.canUndo;
        }

        @Override
        public boolean canRedo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableSelection.canRedo()", 633).log();
            }
            return !this.canUndo;
        }
    }
}

