/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.ChoiceOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.FocusingUndoableEdit;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.function.Predicate;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import lombok.Generated;

public class ChoiceOptionEdit
extends OptionEdit
implements UndoableEditListener,
ActionListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.ChoiceOptionEdit");
    protected JLabel label;
    protected JComboBox combo;
    protected JTextComponent text;
    protected volatile Object[] choices;
    protected Object lastChoice;
    protected Color origEditorBackgroundColor;
    protected boolean suppressOutdatedKeyboardShortcuts = true;
    protected transient boolean internalUpdate;

    public ChoiceOptionEdit() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "ChoiceOptionEdit()", 181).log();
        }
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.label = new JLabel(this.getString("label", "Missing: " + this.option.getName())){

            @Override
            public void updateUI() {
                super.updateUI();
                if (ChoiceOptionEdit.this.combo != null) {
                    this.setForeground(UIManager.getColor(ChoiceOptionEdit.this.combo.isEnabled() ? "textText" : "textInactiveText"));
                }
            }
        };
        this.label.setName("Label-" + this.option.getName());
        String string = this.getString("mnemonic", null);
        if (string != null && string.length() > 0) {
            this.label.setDisplayedMnemonic(string.charAt(0));
        }
        this.add((Component)this.label, "North");
        this.getInitialChoices();
        this.combo = new JComboBox(this.choices == null ? new Object[]{} : this.choices){

            @Override
            public void updateUI() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "init().JComboBox.updateUI()", 223).dumpStack();
                }
                if (ChoiceOptionEdit.this.text != null) {
                    ChoiceOptionEdit.this.text.setBackground(null);
                    ChoiceOptionEdit.this.text.getDocument().removeUndoableEditListener(ChoiceOptionEdit.this);
                }
                this.setBackground(null);
                super.updateUI();
                ChoiceOptionEdit.this.origBackgroundColor = this.getBackground();
                this.fetchText();
                if (ChoiceOptionEdit.this.text != null) {
                    ChoiceOptionEdit.this.origEditorBackgroundColor = ChoiceOptionEdit.this.text.getBackground();
                }
                ChoiceOptionEdit.this.addListeners();
                if (!ChoiceOptionEdit.this.isValid) {
                    ChoiceOptionEdit.this.highlight(0, 0, 0);
                }
            }

            @Override
            public void setUI(ComboBoxUI comboBoxUI) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "init().JComboBox.setUI(ComboBoxUI)", 245).addDetail("newUI", comboBoxUI)).dumpStack();
                }
                super.setUI(comboBoxUI);
                this.fetchText();
            }

            private void fetchText() {
                if (this.isEditable() && this.getEditor().getEditorComponent() instanceof JTextComponent) {
                    ChoiceOptionEdit.this.text = (JTextComponent)this.getEditor().getEditorComponent();
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "init().JComboBox.fetchText()", 255).add("text", ChoiceOptionEdit.this.text)).log();
                    }
                    ChoiceOptionEdit.this.text.getDocument().addUndoableEditListener(ChoiceOptionEdit.this);
                    if (Misc.OS_IS_MAC_OS_X) {
                        ChoiceOptionEdit.this.text.setAutoscrolls(false);
                    }
                    if (ChoiceOptionEdit.this.suppressOutdatedKeyboardShortcuts) {
                        ChoiceOptionEdit.this.ignoreDefaultShortcuts(ChoiceOptionEdit.this.text);
                    }
                }
            }
        };
        this.label.setLabelFor(this.combo);
        this.combo.setName("ComboBox-" + this.option.getName());
        this.combo.setEditable(this.isEditable());
        this.combo.addActionListener(this);
        this.combo.setMaximumRowCount(this.getInt("maximumRowCount", 8));
        this.add((Component)this.combo, "Center");
        this.update(this.option);
        this.disabled = this.getBoolean("disabled", false);
        this.setEnabled(!this.disabled);
        this.suppressOutdatedKeyboardShortcuts = this.getBoolean("suppressOutdatedKeyboardShortcuts", true);
        if (this.combo.isEditable()) {
            if (this.combo.getEditor().getEditorComponent() instanceof JTextComponent) {
                this.text = (JTextComponent)this.combo.getEditor().getEditorComponent();
            }
            this.combo.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void focusLost(FocusEvent focusEvent) {
                    Object object;
                    Object object2 = focusEvent.getSource();
                    String string = null;
                    if (object2 != null && (object = ChoiceOptionEdit.this.combo.getEditor().getItem()) != null && !Misc.emptyOrNull(string = object.toString())) {
                        ChoiceOptionEdit.this.combo.setSelectedItem(object);
                    }
                    if (!focusEvent.isTemporary()) {
                        boolean bl = OptionEdit.highlightOnCheckOnly;
                        try {
                            OptionEdit.highlightOnCheckOnly = true;
                            ChoiceOptionEdit.this.option.checkValue(ChoiceOptionEdit.this, "".equals(string) ? null : string);
                        }
                        finally {
                            OptionEdit.highlightOnCheckOnly = bl;
                        }
                    }
                }

                @Override
                public void focusGained(FocusEvent focusEvent) {
                }
            });
        }
        this.postInit();
    }

    @Override
    protected void finishInit() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "finishInit()", 333).log();
        }
        super.finishInit();
        this.fetchColors();
    }

    @Override
    public void updateUI() {
        super.updateUI();
    }

    private void fetchColors() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "fetchColors()", 350).log();
        }
        if (this.combo != null) {
            this.origBackgroundColor = this.combo.getBackground();
            if (this.text != null) {
                this.origEditorBackgroundColor = this.text.getBackground();
            }
        }
    }

    private void addListeners() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "addListeners()", 363).log();
        }
        if (this.text != null) {
            final Runnable runnable = () -> {
                if (highlightWhileEditing) {
                    this.checkValue(true);
                } else if (!this.internalUpdate) {
                    this.dehighlight();
                }
            };
            this.text.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent documentEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "addListeners().DocumentListener.insertUpdate(DocumentEvent)", 375).addDetail("e", documentEvent)).log();
                    }
                    SwingUtilities.invokeLater(runnable);
                }

                @Override
                public void removeUpdate(DocumentEvent documentEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "addListeners().DocumentListener.removeUpdate(DocumentEvent)", 381).addDetail("e", documentEvent)).log();
                    }
                    SwingUtilities.invokeLater(runnable);
                }

                @Override
                public void changedUpdate(DocumentEvent documentEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "addListeners().DocumentListener.changedUpdate(DocumentEvent)", 387).addDetail("e", documentEvent)).log();
                    }
                    SwingUtilities.invokeLater(runnable);
                }
            });
        }
    }

    protected boolean isEditable() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isEditable()", 398).log();
        }
        return this.getBoolean("editable", false);
    }

    public void postInit() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "postInit()", 409).log();
        }
        if (this.text != null) {
            assert (this.combo.isEditable());
            assert (this.combo.getEditor().getEditorComponent() instanceof JTextComponent);
        }
    }

    @Override
    public boolean isModified() {
        Object object;
        boolean bl;
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isModified()", 429).log();
        }
        if (this.option instanceof ChoiceOption && ((ChoiceOption)this.option).isIntBased()) {
            int n = this.combo.getSelectedIndex();
            bl = n < 0 ? this.option.getValue() != null : !Integer.valueOf(n + 1).equals(this.option.getValue());
            object = n;
        } else {
            Object object2 = ChoiceOptionEdit.getComboBoxValue(this.combo);
            Object object3 = this.option.getValue();
            if (ChoiceOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 442).add("val", object2)).add("optionValue", object3)).log();
            }
            boolean bl2 = bl = !Misc.equalOrNull(object2, object3);
            if (bl && "".equals(object2) && (object3 == null || this.option.isNullOK())) {
                object2 = null;
                boolean bl3 = bl = !Misc.equalOrNull(object2, object3);
                if (ChoiceOptionEdit.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 451).add("Null conversion")).log();
                }
            }
            object = object2;
        }
        if (bl && ChoiceOptionEdit.logger.level >= 5) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "isModified()", 456).add("Modified - edit", this)).add("option", this.option)).add("myValue", object)).log();
        }
        return bl;
    }

    @Override
    public boolean checkValue() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "checkValue()", 472).log();
        }
        if (this.option instanceof ChoiceOption && ((ChoiceOption)this.option).isIntBased()) {
            int n = this.combo.getSelectedIndex();
            this.isValid = this.option.checkValue(this, n < 0 ? null : Integer.valueOf(n + 1));
            if (!this.isValid) {
                if (!OptionEdit.isHighlightOnCheckOnly()) {
                    this.combo.requestFocus();
                }
                return false;
            }
        } else {
            Object object = ChoiceOptionEdit.getComboBoxValue(this.combo);
            this.isValid = this.option.checkValue(this, object);
            if (!this.isValid) {
                if (!OptionEdit.isHighlightOnCheckOnly()) {
                    this.combo.requestFocus();
                }
                return false;
            }
        }
        this.dehighlight();
        return true;
    }

    @Override
    public void readValue() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "readValue()", 505).log();
        }
        if (this.option instanceof ChoiceOption && ((ChoiceOption)this.option).isIntBased()) {
            int n = this.combo.getSelectedIndex();
            this.option.setValue(n < 0 ? null : Integer.valueOf(n + 1));
        } else {
            Object object = ChoiceOptionEdit.getComboBoxValue(this.combo);
            if ("".equals(object) && (this.option.isNullOK() || this.option.getValue() == null)) {
                object = null;
                if (ChoiceOptionEdit.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "readValue()", 516).add("Null conversion")).log();
                }
            }
            this.option.setValue(object);
        }
    }

    public static Object getComboBoxValue(JComboBox jComboBox) {
        Object object = jComboBox.getSelectedItem();
        if (jComboBox.isEditable()) {
            object = jComboBox.getEditor().getItem();
        }
        if (ChoiceOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getComboBoxValue(JComboBox)", 538).add("val", object)).log();
        }
        return object;
    }

    @Override
    public void update(Option option) {
        boolean bl;
        if (ChoiceOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(Option)", 551).addDetail("option", option)).log();
        }
        this.option = option;
        boolean bl2 = option instanceof ChoiceOption && ((ChoiceOption)option).isIntBased();
        boolean bl3 = bl = this.combo.getItemCount() > 0;
        if (bl2) {
            if (bl) {
                if (option.getValue() == null) {
                    this.combo.setSelectedIndex(0);
                } else {
                    this.combo.setSelectedIndex(Math.min(Math.max(0, (Integer)option.getValue() - 1), this.combo.getItemCount() - 1));
                }
            }
        } else if (this.combo.isEditable() || option.getValue() != null) {
            this.combo.setSelectedItem(option.getValue());
            if (this.combo.isEditable()) {
                this.internalUpdate = true;
                this.combo.getEditor().setItem(option.getValue());
                SwingUtilities.invokeLater(() -> {
                    this.internalUpdate = false;
                });
            }
        } else if (bl) {
            this.combo.setSelectedIndex(0);
        }
        this.lastChoice = ChoiceOptionEdit.getComboBoxValue(this.combo);
        if (option.isNullOK() && "".equals(this.lastChoice)) {
            this.lastChoice = null;
            if (ChoiceOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "update(Option)", 583).add("Null conversion")).log();
            }
        }
    }

    public JComboBox getComboBox() {
        return this.combo;
    }

    public Highlighter getHighlighter() {
        if (this.text != null) {
            return this.text.getHighlighter();
        }
        return null;
    }

    public void setHighlighter(Highlighter highlighter) {
        if (this.text != null) {
            this.text.setHighlighter(highlighter);
        }
    }

    @Override
    public void highlight(int n, int n2, int n3) {
        block9: {
            if (ChoiceOptionEdit.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "highlight(int,int,int)", 655).addDetail("start", n)).addDetail("end", n2)).addDetail("highlightType", n3)).log();
            }
            if (!this.combo.isEditable()) {
                this.combo.setBackground(this.getHighlightingColorNonTransparent(n3));
            } else if (n == 0 && n2 == 0) {
                if (this.text != null) {
                    this.text.setBackground(this.getHighlightingColorNonTransparent(n3));
                }
            } else {
                Highlighter highlighter = this.getHighlighter();
                if (highlighter instanceof DefaultHighlighter) {
                    try {
                        Object object = highlighter.addHighlight(n, n2, new DefaultHighlighter.DefaultHighlightPainter(this.getHighlightingColor()));
                    }
                    catch (BadLocationException badLocationException) {
                        if (ChoiceOptionEdit.logger.level < 3) break block9;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "highlight(int,int,int)", 673).add("ex", badLocationException)).log();
                    }
                }
            }
        }
    }

    @Override
    public void dehighlight() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "dehighlight()", 687).log();
        }
        if (this.combo.isEditable()) {
            if (this.getHighlighter() != null) {
                this.getHighlighter().removeAllHighlights();
            }
            if (this.text != null && this.origEditorBackgroundColor != null) {
                this.text.setBackground(this.origEditorBackgroundColor);
                this.text.repaint();
            }
        } else if (this.combo != null && this.origBackgroundColor != null) {
            this.combo.setBackground(this.origBackgroundColor);
            this.combo.repaint();
        }
        super.dehighlight();
    }

    @Override
    public boolean matchesFilterText(Predicate<String> predicate) {
        if (ChoiceOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "matchesFilterText(Predicate<String>)", 718).addDetail("matcher", predicate)).log();
        }
        if (predicate == null) {
            return true;
        }
        for (Object object : this.choices) {
            if (!(object instanceof String) || !predicate.test((String)object)) continue;
            return true;
        }
        return super.matchesFilterText(predicate);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.disabled) {
            bl = false;
        }
        this.combo.setEnabled(bl);
        Color color = UIManager.getColor(bl ? "textText" : "textInactiveText");
        if (ChoiceOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "setEnabled(boolean)", 755).add("this", this)).add("color", color)).log();
        }
        this.label.setForeground(color);
        this.label.repaint();
    }

    @Override
    public boolean isEnabled() {
        return this.combo.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.combo.requestFocus();
    }

    public void resetToDefault() {
        this.combo.setSelectedIndex(0);
    }

    public void fireUndoableEditHappened() {
        Object object = ChoiceOptionEdit.getComboBoxValue(this.combo);
        if (this.option.isNullOK() && "".equals(object)) {
            object = null;
            if (ChoiceOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "fireUndoableEditHappened()", 816).add("Null conversion")).log();
            }
        }
        if (!Misc.equalOrNull(object, this.lastChoice)) {
            this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableSelection(this.combo, this.lastChoice)));
            this.lastChoice = object;
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (ChoiceOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "undoableEditHappened(UndoableEditEvent)", 834).addDetail("edit", undoableEditEvent)).log();
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new FocusingUndoableEdit(this.text, this, undoableEditEvent.getEdit())));
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (ChoiceOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addUndoableEditListener(UndoableEditListener)", 850).addDetail("listener", undoableEditListener)).log();
        }
        super.addUndoableEditListener(undoableEditListener);
        if (this.text != null) {
            this.text.getDocument().removeUndoableEditListener(this);
            this.text.getDocument().addUndoableEditListener(this);
        }
    }

    @Override
    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        if (ChoiceOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeUndoableEditListener(UndoableEditListener)", 869).addDetail("listener", undoableEditListener)).log();
        }
        super.removeUndoableEditListener(undoableEditListener);
        if (this.text != null) {
            this.text.getDocument().removeUndoableEditListener(this);
        }
    }

    @Override
    public void cleanup() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "cleanup()", 881).log();
        }
        if (this.combo.isEditable()) {
            Component component = this.combo.getEditor().getEditorComponent();
            for (int i = component.getFocusListeners().length - 1; i >= 0; --i) {
                component.removeFocusListener(component.getFocusListeners()[i]);
            }
        }
        for (int i = this.combo.getActionListeners().length - 1; i >= 0; --i) {
            this.combo.removeActionListener(this.combo.getActionListeners()[i]);
        }
        super.cleanup();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.getBoolean("autoupdate", false);
        if (bl) {
            this.readValue();
            this.option.notifyObservers(this);
        }
        this.fireUndoableEditHappened();
    }

    protected void getInitialChoices() {
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getInitialChoices()", 1041).log();
        }
        this.getChoices();
    }

    protected void getChoices() {
        int n;
        if (ChoiceOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getChoices()", 1053).log();
        }
        if (this.option instanceof ChoiceOption && ((ChoiceOption)this.option).getNumchoices() > 0) {
            n = ((ChoiceOption)this.option).getNumchoices();
        } else {
            n = this.getInt("numchoices", -1);
            if (n < 0) {
                if (ChoiceOptionEdit.logger.level >= 5) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "getChoices()", 1061).add("No numchoices for ChoiceOptionEdit ")).add(this.option.getName())).log();
                }
                return;
            }
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 1; i <= n; ++i) {
            String string = this.getString("choice" + i + ".label", null);
            if (string == null) {
                if (ChoiceOptionEdit.logger.level < 1) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getChoices()", 1070).add("No label for choice ")).add(i)).add(" in ChoiceOptionEdit ")).add(this.option.getName())).log();
                continue;
            }
            arrayList.add(string);
        }
        this.choices = arrayList.toArray(new Object[0]);
    }

    public static class UndoableSelection
    extends AbstractUndoableEdit {
        private JComboBox combo;
        private Object selected;
        protected boolean canUndo;

        public UndoableSelection(JComboBox jComboBox, Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableSelection.UndoableSelection(JComboBox,Object)", 947).addDetail("combo", jComboBox)).addDetail("selected", object)).log();
            }
            this.combo = jComboBox;
            this.selected = object;
            this.canUndo = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableSelection.undo()", 967).log();
            }
            if (!this.canUndo) {
                throw new CannotUndoException();
            }
            Object object = ChoiceOptionEdit.getComboBoxValue(this.combo);
            this.combo.setSelectedItem(this.selected);
            this.selected = object;
            this.combo.requestFocus();
            this.canUndo = false;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableSelection.redo()", 989).log();
            }
            if (this.canUndo) {
                throw new CannotRedoException();
            }
            Object object = ChoiceOptionEdit.getComboBoxValue(this.combo);
            this.combo.setSelectedItem(this.selected);
            this.selected = object;
            this.combo.requestFocus();
            this.canUndo = true;
        }

        @Override
        public boolean canUndo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableSelection.canUndo()", 1011).log();
            }
            return this.canUndo;
        }

        @Override
        public boolean canRedo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableSelection.canRedo()", 1025).log();
            }
            return !this.canUndo;
        }
    }
}

