/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.gui.ThemeSupport;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.notifications.DefaultNotificationCenter;
import de.qfs.lib.notifications.Observer;
import de.qfs.lib.option.edit.IncrementalSearch;
import de.qfs.lib.option.edit.RegexEscaper;
import de.qfs.lib.option.edit.SimpleOptionEdit;
import de.qfs.lib.util.Reflector;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import lombok.Generated;

public class EditorOptionEdit
extends SimpleOptionEdit {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.EditorOptionEdit");
    private double weight;
    protected JScrollPane scroll;
    private IncrementalSearch isearch;
    private RegexEscaper regexEscaper;
    protected boolean isHtml;
    final Observer themeUpdateObserver = notification -> {
        if ((this.disabled || this.readonly) && this.isHtml) {
            this.text.setText(this.getTextFromOption());
        }
    };

    @Override
    public void init() {
        block20: {
            Object object;
            int n;
            String[] stringArray;
            super.init();
            String string = this.getString("type", "text/plain");
            String string2 = (String)this.option.getValue();
            this.isHtml = "text/html".equals(string);
            String string3 = this.getTextFromOption();
            if (string3 != null && !string3.equals(string2)) {
                string2 = string3;
                DefaultNotificationCenter.instance().addWeakObserver(this.themeUpdateObserver, "user.theme.updatedUI");
            }
            this.text = new JEditorPane(string, string2){

                @Override
                public boolean isFocusTraversable() {
                    return this.isEditable() && this.isEnabled();
                }

                @Override
                public boolean isFocusable() {
                    return true;
                }

                @Override
                public boolean isFocusCycleRoot() {
                    return false;
                }

                @Override
                public void setText(String string) {
                    super.setText(string);
                }
            };
            this.label.setLabelFor(this.text);
            this.text.setName("Editor-" + this.option.getName());
            if (this.selectOnFocus && !this.disabled) {
                this.text.addFocusListener(this);
            }
            if (this.getBoolean("withborder", true)) {
                this.text.setBorder(UIManager.getBorder("TextArea.scrollPaneBorder"));
            }
            this.text.setFont(UIManager.getFont("TextField.font"));
            boolean bl = false;
            String string4 = this.getString("font", null);
            if (string4 != null && (stringArray = (String[])Reflector.safeCall(this.text.getToolkit(), "getFontList")) != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].equals(string4)) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                stringArray = this.text.getFont();
                this.text.setFont(new Font(string4, stringArray.getStyle(), stringArray.getSize()));
            }
            if (string2 != null) {
                this.text.setCaretPosition(0);
            }
            int n2 = this.getInt("width", -1);
            n = this.getInt("height", -1);
            boolean bl2 = this.getBoolean("scroll", true);
            if (bl2) {
                this.scroll = new JScrollPane(this.text);
                this.scroll.setName("ScrollPane-" + this.option.getName());
                this.scroll.setBorder(this.text.getBorder());
                this.text.setBorder(null);
                this.scroll.setPreferredSize(new Dimension(Math.max(10, n2), Math.max(10, n)));
                this.add((Component)this.scroll, "Center");
            } else {
                this.scroll = null;
                object = this.text.getSize();
                this.text.setPreferredSize(new Dimension(Math.max(((Dimension)object).width, n2), Math.max(((Dimension)object).height, n)));
                this.add((Component)this.text, "Center");
            }
            object = this.getString("weight", null);
            if (object != null) {
                try {
                    this.weight = Double.parseDouble((String)object);
                }
                catch (NumberFormatException numberFormatException) {
                    if (EditorOptionEdit.logger.level < 3) break block20;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "init()", 304).add("ex", numberFormatException)).log();
                }
            }
        }
        if (this.disabled) {
            this.setEnabled(false);
        }
        if (this.readonly) {
            this.setEditable(false);
        }
        if (!this.getBoolean("withbackground", true)) {
            this.text.setForeground(UIManager.getColor("OptionPane.messageForeground"));
            this.text.setBackground(UIManager.getColor("OptionPane.messageBackground"));
        }
        if (this.canIsearch) {
            this.isearch = new IncrementalSearch(this.text);
        }
        if (this.canEscapeRegex) {
            this.regexEscaper = new RegexEscaper(this, this.text);
        }
        if (this.canPopup) {
            PopupManager.instance().registerPopupHandler(PopupManager.instance(), this.text);
            if (this.canIsearch) {
                PopupManager.instance().registerPopupHandler(this.isearch, this.text);
            }
            if (this.canEscapeRegex) {
                PopupManager.instance().registerPopupHandler(this.regexEscaper, this.text);
            }
        }
        this.maybeCommonPostInitSteps();
    }

    @Override
    public double getWeight() {
        return this.weight;
    }

    @Override
    protected String getTextFromOption() {
        Object object;
        if (EditorOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getTextFromOption()", 359).log();
        }
        String string = (object = this.option.getValue()) == null ? "" : object.toString();
        return this.isHtml ? ThemeSupport.prefixHtml("option." + this.option.getName(), string) : string;
    }

    @Generated
    public boolean isHtml() {
        if (EditorOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isHtml()", 158).log();
        }
        return this.isHtml;
    }
}

