/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.util.Enum;
import de.qfs.lib.util.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.UIManager;
import lombok.Generated;

public class EnumOptionEdit
extends OptionEdit {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.EnumOptionEdit");
    protected JLabel label;
    protected JComboBox combo;
    protected String type;
    protected Object[] choices;
    protected int[] values;

    public EnumOptionEdit() {
        if (EnumOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "EnumOptionEdit()", 141).log();
        }
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.label = new JLabel(this.getString("label", "Missing: " + this.option.getName()));
        this.label.setName("Label-" + this.option.getName());
        String string = this.getString("mnemonic", null);
        if (string != null && string.length() > 0) {
            this.label.setDisplayedMnemonic(string.charAt(0));
        }
        this.add((Component)this.label, "North");
        this.type = this.getString("type", null);
        if (this.type == null) {
            if (EnumOptionEdit.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "init()", 171).add("No type for EnumOptionEdit ")).add(this.option.getName())).log();
            }
            this.type = "";
        }
        this.getChoices();
        this.combo = new JComboBox<Object>(this.choices);
        this.label.setLabelFor(this.combo);
        this.combo.setName("ComboBox-" + this.option.getName());
        this.combo.setEditable(false);
        this.add((Component)this.combo, "Center");
        this.update(this.option);
        this.disabled = this.getBoolean("disabled", false);
        this.setEnabled(!this.disabled);
    }

    @Override
    public boolean isModified() {
        boolean bl = Misc.equalOrNull(this.option.getValue(), this.getCurrentValue());
        if (bl && EnumOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 204).add("Modified - edit", this)).add("option", this.option)).log();
        }
        return bl;
    }

    @Override
    public boolean checkValue() {
        if (EnumOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "checkValue()", 219).log();
        }
        if (!this.option.checkValue(this, this.getCurrentValue())) {
            if (!OptionEdit.isHighlightOnCheckOnly()) {
                this.combo.requestFocus();
            }
            return false;
        }
        return true;
    }

    @Override
    public void readValue() {
        if (EnumOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "readValue()", 237).log();
        }
        this.option.setValue(this.getCurrentValue());
    }

    @Override
    public void update(Option option) {
        if (EnumOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(Option)", 251).addDetail("option", option)).log();
        }
        this.option = option;
        if (!(option.getValue() instanceof Enum)) {
            this.combo.setSelectedIndex(0);
        } else {
            int n = ((Enum)option.getValue()).getValue();
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] != n) continue;
                this.combo.setSelectedIndex(i);
                break;
            }
        }
    }

    public JComboBox getComboBox() {
        return this.combo;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.disabled) {
            bl = false;
        }
        this.combo.setEnabled(bl);
        this.label.setForeground(UIManager.getColor(bl ? "textText" : "textInactiveText"));
    }

    @Override
    public boolean isEnabled() {
        return this.combo.isEnabled();
    }

    @Override
    public void requestFocus() {
        this.combo.requestFocus();
    }

    protected void getChoices() {
        int n;
        if (EnumOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getChoices()", 348).log();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        int n2 = this.getInt("numchoices", -1);
        if (n2 < 0 && EnumOptionEdit.logger.level >= 1) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getChoices()", 355).add("No numchoices for EnumOptionEdit ")).add(this.option.getName())).log();
        }
        for (n = 1; n <= n2; ++n) {
            String string = this.getString("choice" + n + ".label", null);
            if (string == null) {
                if (EnumOptionEdit.logger.level < 1) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getChoices()", 361).add("No label for choice ")).add(n)).add(" in EnumOptionEdit ")).add(this.option.getName())).log();
                continue;
            }
            arrayList.add(string);
            String string2 = this.getString("choice" + n + ".value", "" + n);
            try {
                arrayList2.add(Integer.valueOf(string2));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                if (EnumOptionEdit.logger.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "getChoices()", 369).add("Bad value for choice ")).add(n)).add(" in EnumOptionEdit ")).add(this.option.getName())).log();
                }
                arrayList2.add(n);
            }
        }
        this.choices = arrayList.toArray(new Object[0]);
        this.values = new int[arrayList2.size()];
        for (n = 0; n < this.values.length; ++n) {
            this.values[n] = (Integer)arrayList2.get(n);
        }
    }

    protected Enum getCurrentValue() {
        int n = this.combo.getSelectedIndex();
        if (n < 0 || n >= this.values.length) {
            return null;
        }
        return Enum.lookup(this.type, this.values[n]);
    }
}

