/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.FileOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.SelectorOptionEdit;
import de.qfs.lib.util.ExtensionFileFilter;
import de.qfs.lib.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import lombok.Generated;

public class FileOptionEdit
extends SelectorOptionEdit {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.FileOptionEdit");

    @Override
    public void init() {
        this.text = new JTextField(){

            @Override
            public boolean isFocusTraversable() {
                return this.isEditable() && this.isEnabled();
            }

            @Override
            public boolean isFocusable() {
                return true;
            }
        };
        super.init();
        this.label.setLabelFor(this.text);
        this.text.setName("Text-" + this.option.getName());
        this.add((Component)this.text, "Center");
        if (this.selectOnFocus && !this.disabled) {
            this.text.addFocusListener(this);
        }
        if (this.option.getValue() != null) {
            this.text.setText(this.option instanceof FileOption ? ((File)this.option.getValue()).getPath() : this.option.getValue().toString());
            this.text.setCaretPosition(this.text.getDocument().getLength());
        }
        this.text.setPreferredSize(new Dimension(10, this.text.getPreferredSize().height));
    }

    @Override
    public boolean checkValue() {
        String string = this.text.getText();
        File file = null;
        if (!string.equals("")) {
            file = new File(string);
            if (this.option instanceof FileOption) {
                if (((FileOption)this.option).isMustExist() && !file.exists()) {
                    Message.showMessageAndHighlight(this, "option.error.noSuchFile");
                    if (!highlightOnCheckOnly) {
                        this.text.requestFocus();
                    }
                    return false;
                }
                if (((FileOption)this.option).getFileType() == 2 && file.exists() && !file.isDirectory()) {
                    Message.showMessageAndHighlight(this, "option.error.notADirectory");
                    if (!highlightOnCheckOnly) {
                        this.text.requestFocus();
                    }
                    return false;
                }
                if (((FileOption)this.option).getFileType() == 1 && file.exists() && !file.isFile()) {
                    Message.showMessageAndHighlight(this, "option.error.notAFile");
                    if (!highlightOnCheckOnly) {
                        this.text.requestFocus();
                    }
                    return false;
                }
            }
            if (file.exists() && !highlightOnCheckOnly && this.getBoolean("askoverwrite", "save".equals(this.getString("action", "open")))) {
                String string2;
                String string3 = string2 = this.getString("askoverwrite.message", null) == null ? "option.error.askOverwrite" : "option." + this.option.getName() + ".askoverwrite";
                if (Message.showMessage(this, string2, new Object[]{file.getPath()}) != 0) {
                    this.text.requestFocus();
                    return false;
                }
            }
        }
        if (!this.option.checkValue(this, this.option instanceof FileOption ? file : string)) {
            if (!highlightOnCheckOnly) {
                this.text.requestFocus();
            }
            return false;
        }
        this.dehighlight();
        return true;
    }

    @Override
    public void readValue() {
        String string;
        if (FileOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "readValue()", 282).log();
        }
        this.option.setValue((string = this.text.getText()).equals("") ? null : (this.option instanceof FileOption ? new File(string) : string));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        File file = this.showFileDialog(this.getText());
        if (file != null) {
            this.setText(file.getPath());
        }
        this.text.requestFocus();
    }

    protected JFileChooser createFileChooser() {
        return new JFileChooser();
    }

    protected void setFileSelectionMode(JFileChooser jFileChooser) {
        boolean bl = this.getBoolean("selectfiles", true);
        boolean bl2 = this.getBoolean("selectdirs", false);
        if (bl && bl2) {
            jFileChooser.setFileSelectionMode(2);
        } else if (bl2) {
            jFileChooser.setFileSelectionMode(1);
        } else {
            jFileChooser.setFileSelectionMode(0);
        }
    }

    protected void setFileFilters(JFileChooser jFileChooser) {
        int n = this.getInt("numfilters", 0);
        if (n > 0) {
            Object object = null;
            for (int i = 1; i <= n; ++i) {
                String string = this.getString("filter" + i + ".desc", null);
                String string2 = this.getString("filter" + i + ".extensions", null);
                boolean bl = this.getBoolean("filter" + i + ".default", false);
                if (string == null || string2 == null) break;
                int n2 = 0;
                String[] stringArray = new StringTokenizer(string2, " \t");
                while (stringArray.hasMoreElements()) {
                    stringArray.nextElement();
                    ++n2;
                }
                if (n2 == 0) break;
                stringArray = new String[n2];
                n2 = 0;
                Object object2 = new StringTokenizer(string2, " \t");
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    stringArray[n2++] = ((StringTokenizer)object2).nextToken();
                }
                object2 = new ExtensionFileFilter(string, stringArray, true, Misc.OS_IS_WINDOWS);
                if (object == null) {
                    object = object2;
                }
                jFileChooser.addChoosableFileFilter((FileFilter)object2);
                if (!bl) continue;
                jFileChooser.setFileFilter((FileFilter)object2);
            }
            if (object != null && !this.getBoolean("allfilter", true)) {
                jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
                jFileChooser.setFileFilter((FileFilter)object);
            }
        }
    }

    protected void setFileAndDirectory(File file, JFileChooser jFileChooser) {
        if (FileOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setFileAndDirectory(File,JFileChooser)", 415).addDetail("file", file)).addDetail("chooser", jFileChooser)).log();
        }
        jFileChooser.setCurrentDirectory(file == null ? new File(new File(new File(".").getAbsolutePath()).getParent()) : file);
        if (file != null) {
            jFileChooser.setSelectedFile(file);
        }
    }

    protected File showFileDialog(String string) {
        File file;
        int n;
        File file2 = null;
        if (string != null && string.length() > 0) {
            file2 = new File(string);
        }
        JFileChooser jFileChooser = this.createFileChooser();
        if (FileOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "showFileDialog(String)", 451).add("chooser", jFileChooser)).log();
        }
        this.setFileFilters(jFileChooser);
        String string2 = this.getString("title", null);
        if (string2 != null) {
            jFileChooser.setDialogTitle(string2);
        }
        this.setFileAndDirectory(file2, jFileChooser);
        if (this.option instanceof FileOption && ((FileOption)this.option).getFileType() == 2) {
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.removeChoosableFileFilter(jFileChooser.getAcceptAllFileFilter());
            jFileChooser.setFileFilter(new DirectoryFileFilter());
        } else if (this.option instanceof FileOption && ((FileOption)this.option).getFileType() == 0) {
            jFileChooser.setFileSelectionMode(2);
        }
        String string3 = this.getString("action", "open");
        if (FileOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "showFileDialog(String)", 494).add("action", string3)).log();
        }
        if ((n = "open".equals(string3) ? jFileChooser.showOpenDialog(this) : ("save".equals(string3) ? jFileChooser.showSaveDialog(this) : jFileChooser.showDialog(this, string3))) != 0) {
            return null;
        }
        file2 = jFileChooser.getSelectedFile();
        if (file2 == null) {
            if (FileOptionEdit.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "showFileDialog(String)", 509).add("File chooser returned null file")).log();
            }
            return null;
        }
        if (this.option instanceof FileOption && ((FileOption)this.option).getFileType() == 2 && !file2.exists()) {
            file2 = jFileChooser.getCurrentDirectory();
        }
        FileFilter fileFilter = jFileChooser.getFileFilter();
        if (file2.getName().indexOf(".") < 0 && fileFilter instanceof ExtensionFileFilter && (file = ((ExtensionFileFilter)fileFilter).forceExtension(file2)).exists()) {
            file2 = file;
        }
        return file2;
    }

    public static class DirectoryFileFilter
    extends FileFilter {
        public DirectoryFileFilter() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "DirectoryFileFilter.DirectoryFileFilter()", 542).log();
            }
        }

        @Override
        public boolean accept(File file) {
            return file.isDirectory();
        }

        @Override
        public String getDescription() {
            return Option.getResources().getString("option.fileoption.directoryfilter.desc", "Directories");
        }
    }
}

