/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.BadLocationException;
import lombok.Generated;

class Gutter
extends JLabel
implements DocumentListener,
CaretListener,
MouseListener,
FocusListener,
ListSelectionListener,
TableModelListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.Gutter");
    private static final int INITIAL_WIDTH_NUMBER = 99;
    private static final String COLLAPSED_WIDTH_STRING = "";
    private static final int HORIZ_SPACE_WIDTH = 1;
    private final JComponent comp;
    private int lineCount = 0;
    private Dimension gutterSize = new Dimension(0, 0);
    private boolean hidden = false;
    private int currentLine = -1;
    private int numberingBase;
    private boolean horizontalSpace;

    public Gutter(JTextArea jTextArea) {
        this(jTextArea, 1);
    }

    public Gutter(JTextArea jTextArea, int n) {
        this.comp = jTextArea;
        this.numberingBase = n;
        this.init();
        this.numberingBase = 1;
        this.horizontalSpace = true;
        jTextArea.getDocument().addDocumentListener(this);
        jTextArea.addCaretListener(this);
    }

    public Gutter(JTable jTable) {
        this(jTable, 1);
    }

    public Gutter(JTable jTable, int n) {
        this.comp = jTable;
        this.numberingBase = n;
        this.init();
        this.horizontalSpace = true;
        jTable.getSelectionModel().addListSelectionListener(this);
    }

    protected void init() {
        this.setAutoscrolls(true);
        this.setOpaque(true);
        this.setRequestFocusEnabled(false);
        this.gutterSize.height = Short.MAX_VALUE;
        FontMetrics fontMetrics = this.comp.getFontMetrics(this.comp.getFont());
        this.gutterSize.width = fontMetrics.stringWidth("99");
        this.setPreferredSize(this.gutterSize);
        this.addMouseListener(this);
        this.comp.addFocusListener(this);
        Font font = this.getFont();
        this.setFont(new Font("Monospaced", font.getStyle(), font.getSize()));
    }

    @Override
    public void hide() {
        if (Gutter.logger.level >= 7) {
            logger.lvlBuild(7, "hide()", 261).log();
        }
        this.hidden = true;
        FontMetrics fontMetrics = this.comp.getFontMetrics(this.comp.getFont());
        this.gutterSize.width = fontMetrics.stringWidth(COLLAPSED_WIDTH_STRING);
        this.setSize(this.gutterSize);
        this.revalidate();
        this.repaint();
    }

    public void unhide() {
        if (Gutter.logger.level >= 7) {
            logger.lvlBuild(7, "unhide()", 277).log();
        }
        this.hidden = false;
        this.revalidate();
        this.repaintOnLineNumberChange();
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (Gutter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEnabled(boolean)", 300).addDetail("enabled", bl)).log();
        }
        super.setEnabled(bl);
        this.repaintOnLineNumberChange();
    }

    @Override
    public void paintComponent(Graphics graphics) {
        int n;
        if (Gutter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "paintComponent(Graphics)", 318).addDetail("gfx", graphics)).log();
        }
        Rectangle rectangle = graphics.getClipBounds();
        if (this.hidden) {
            graphics.setColor(new Color(222, 194, 194));
        } else {
            graphics.setColor(this.getBackground());
        }
        if (Gutter.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "paintComponent(Graphics)", 328).add("gutterSize", this.gutterSize)).log();
        }
        if (Gutter.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "paintComponent(Graphics)", 329).add("clip", rectangle)).log();
        }
        if (this.horizontalSpace) {
            n = 6;
            graphics.fillRect(0, 0, this.gutterSize.width, Math.max(this.gutterSize.height, rectangle.y + rectangle.height));
        } else {
            n = 3;
            graphics.fillRect(0, 0, rectangle.width + rectangle.x, rectangle.height + rectangle.y);
        }
        int n2 = this.comp.getBorder() != null ? this.comp.getBorder().getBorderInsets((Component)this.comp).top : 0;
        Font font = this.getFont();
        if (Gutter.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "paintComponent(Graphics)", 346).add("font", font)).log();
        }
        FontMetrics fontMetrics = this.comp.getFontMetrics(font);
        int n3 = this.getLineHeight(0);
        int n4 = fontMetrics.getAscent() + (n3 - fontMetrics.getHeight()) / 2;
        boolean bl = this.comp.hasFocus();
        if (n3 > 0 && !this.hidden) {
            int n5 = 0;
            int n6 = this.getLineCount() - 1;
            int n7 = n2 + n5 * n3;
            if (graphics instanceof Graphics2D) {
                ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
            }
            graphics.setFont(font);
            Color color = UIManager.getColor("Label.foreground");
            int n8 = n5;
            while (n8 <= n6) {
                String string = Integer.toString(n8 + this.numberingBase);
                int n9 = this.gutterSize.width - (fontMetrics.stringWidth(string) - 1) - n - 1;
                if (bl && n8 == this.getCurrentLine()) {
                    graphics.setColor(color);
                    graphics.setFont(this.getFont().deriveFont(1));
                } else {
                    graphics.setColor(color);
                    graphics.setFont(this.getFont().deriveFont(0));
                }
                graphics.drawString(string, n9, n4 + n7);
                if (Gutter.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "paintComponent(Graphics)", 377).add("line= ")).add(n8)).add("number", string)).add("offset", n9)).add(", y=")).add(n7)).add(", lineHeight=")).add(n3)).add("baseline", n4)).add(", height=")).add(this.getHeight())).log();
                }
                n7 += this.getLineHeight(++n8);
            }
        }
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.getLineCount() != this.lineCount) {
            this.repaintOnLineNumberChange();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.getLineCount() != this.lineCount) {
            this.repaintOnLineNumberChange();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        if (this.getLineCount() != this.lineCount) {
            this.repaintOnLineNumberChange();
        }
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (Gutter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "caretUpdate(CaretEvent)", 451).addDetail("e", caretEvent)).log();
        }
        this.repaintOnLineSelectionChange();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            if (this.hidden) {
                this.unhide();
            } else {
                this.hide();
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        this.invalidate();
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        this.invalidate();
        this.repaint();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (Gutter.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "valueChanged(ListSelectionEvent)", 581).addDetail("e", listSelectionEvent)).log();
        }
        this.repaintOnLineSelectionChange();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.getLineCount() != this.lineCount) {
            this.repaintOnLineNumberChange();
        }
    }

    protected void repaintOnLineNumberChange() {
        if (Gutter.logger.level >= 7) {
            logger.lvlBuild(7, "repaintOnLineNumberChange()", 612).log();
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = this.getParent() instanceof JViewport ? 9 : 6;
        this.lineCount = this.getLineCount();
        if (!this.hidden) {
            int n2 = Math.max(this.lineCount, 100 - this.numberingBase);
            this.gutterSize.width = fontMetrics.stringWidth(COLLAPSED_WIDTH_STRING + n2) + n;
            this.setSize(this.gutterSize);
            this.revalidate();
            this.repaint();
        }
    }

    protected void repaintOnLineSelectionChange() {
        if (Gutter.logger.level >= 7) {
            logger.lvlBuild(7, "repaintOnLineSelectionChange()", 632).log();
        }
        if (!(this.hidden || this.currentLine >= 0 && this.currentLine == this.getCurrentLine())) {
            this.invalidate();
            this.repaint();
            this.currentLine = this.getCurrentLine();
        }
    }

    public int getCurrentLine() {
        if (this.comp instanceof JTextArea) {
            String string;
            block5: {
                string = COLLAPSED_WIDTH_STRING;
                try {
                    string = ((JTextArea)this.comp).getText(0, ((JTextArea)this.comp).getCaretPosition() + 1);
                }
                catch (BadLocationException badLocationException) {
                    if (Gutter.logger.level < 3) break block5;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "getCurrentLine()", 658).add("ex", badLocationException)).log();
                }
            }
            return Math.max(0, Misc.countLines(string) - 1);
        }
        if (this.comp instanceof JTable) {
            return ((JTable)this.comp).getSelectionModel().getLeadSelectionIndex();
        }
        if (Gutter.logger.level >= 3) {
            ((LevelAwareLogBuilder)logger.lvlBuild(3, "getCurrentLine()", 665).add("Invalid gutter class")).log();
        }
        return -1;
    }

    public int getLineCount() {
        if (this.comp instanceof JTextArea) {
            return ((JTextArea)this.comp).getLineCount();
        }
        if (this.comp instanceof JTable) {
            return ((JTable)this.comp).getRowCount();
        }
        if (Gutter.logger.level >= 3) {
            ((LevelAwareLogBuilder)logger.lvlBuild(3, "getLineCount()", 687).add("Invalid gutter class")).log();
        }
        return 0;
    }

    public int getLineHeight(int n) {
        if (this.comp instanceof JTextArea) {
            FontMetrics fontMetrics = this.comp.getFontMetrics(this.comp.getFont());
            return fontMetrics.getHeight();
        }
        if (this.comp instanceof JTable) {
            return ((JTable)this.comp).getRowHeight(n);
        }
        if (Gutter.logger.level >= 3) {
            ((LevelAwareLogBuilder)logger.lvlBuild(3, "getLineHeight(int)", 709).add("Invalid gutter class")).log();
        }
        return 0;
    }
}

