/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.OptionEdit;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.UIManager;
import lombok.Generated;

public class LabelOptionEdit
extends OptionEdit {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.LabelOptionEdit");

    public LabelOptionEdit() {
        if (LabelOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "LabelOptionEdit()", 65).log();
        }
    }

    @Override
    protected void init() {
        if (LabelOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "init()", 81).log();
        }
        this.setLayout(new BoxLayout(this, 1));
        this.disabled = this.getBoolean("disabled", false);
        this.update(this.option);
    }

    @Override
    public void update(Option option) {
        if (LabelOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(Option)", 100).addDetail("option", option)).log();
        }
        this.option = option;
        this.removeAll();
        Object[] objectArray = null;
        String string = null;
        if (option.getValue() instanceof String[]) {
            objectArray = (String[])option.getValue();
        } else if (option.getValue() instanceof String) {
            string = (String)option.getValue();
        } else if (option.getValue() != null) {
            return;
        }
        if (string == null) {
            string = this.getString("label", null);
            if (objectArray != null) {
                string = Message.formatString(string, objectArray);
            }
        }
        while (string != null) {
            JLabel jLabel;
            int n = string.indexOf("\n");
            if (n >= 0) {
                if (n == 0) {
                    this.add(new Empty());
                } else {
                    jLabel = this.createLabel(string.substring(0, n));
                    this.add(jLabel);
                }
                string = n == string.length() - 1 ? null : string.substring(n + 1);
                continue;
            }
            if ("".equals(string)) {
                this.add(new Empty());
            } else {
                jLabel = this.createLabel(string);
                this.add(jLabel);
                this.updateUI();
            }
            string = null;
        }
        this.invalidate();
    }

    @Override
    public boolean isModified() {
        return false;
    }

    @Override
    public boolean checkValue() {
        return true;
    }

    @Override
    public void readValue() {
    }

    protected JLabel createLabel(String string) {
        if (LabelOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createLabel(String)", 198).addDetail("text", string)).log();
        }
        return new OptionEdit.OptionJLabel(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.disabled) {
            bl = false;
        }
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof JLabel)) continue;
            ((JLabel)componentArray[i]).setForeground(UIManager.getColor(bl ? "textText" : "textInactiveText"));
        }
    }

    private static class Empty
    extends Component {
        private int height;

        public Empty() {
            JLabel jLabel = new JLabel("Xyz");
            this.height = jLabel.getPreferredSize().height;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(1, this.height);
        }
    }
}

