/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.edit.IncrementalSearch;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.option.edit.RegexEscaper;
import de.qfs.lib.option.edit.SimpleOptionEdit;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import lombok.Generated;

public abstract class SelectorOptionEdit
extends SimpleOptionEdit
implements ActionListener {
    protected AbstractButton select;
    private IncrementalSearch isearch;
    private RegexEscaper regexEscaper;

    @Override
    public void init() {
        this.select = this.createButton();
        this.select.addActionListener(this);
        super.init();
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(this.select);
        this.add((Component)box, "East");
        this.text.registerKeyboardAction(this, KeyOptionEdit.getKeyStrokeForResource("keystroke.edit2"), 0);
        this.text.registerKeyboardAction(this, KeyOptionEdit.getKeyStrokeForResource("keystroke.edit"), 0);
        if (this.canIsearch) {
            this.isearch = new IncrementalSearch(this.text);
        }
        if (this.canEscapeRegex) {
            this.regexEscaper = new RegexEscaper(this, this.text);
        }
        if (this.canPopup) {
            PopupManager.instance().registerPopupHandler(PopupManager.instance(), this.text);
            if (this.canIsearch) {
                PopupManager.instance().registerPopupHandler(this.isearch, this.text);
            }
            if (this.canEscapeRegex) {
                PopupManager.instance().registerPopupHandler(this.regexEscaper, this.text);
            }
        }
        this.maybeCommonPostInitSteps();
    }

    @Override
    public void setEnabled(boolean bl) {
        if (this.disabled) {
            bl = false;
        }
        super.setEnabled(bl);
        this.select.setEnabled(bl);
    }

    protected AbstractButton createButton() {
        String string;
        JButton jButton = new JButton(){};
        jButton.setName("Selector-" + this.option.getName());
        jButton.setRequestFocusEnabled(false);
        String string2 = this.getString("select.label", "...");
        String string3 = this.fontFactor != null ? "@1.25x" : "";
        Icon icon = Option.getResources().getIcon("option." + this.option.getName() + ".select.icon" + this.themeSuffix + string3, null);
        if (icon != null) {
            jButton.setText(null);
            jButton.setIcon(icon);
            jButton.setMargin(new Insets(0, 0, 0, 0));
        } else {
            jButton.setText(string2);
            string = this.getString("select.mnemonic", null);
            if (string != null && string.length() > 0) {
                jButton.setMnemonic(string.charAt(0));
            }
            Insets insets = jButton.getMargin();
            jButton.setMargin(new Insets(0, insets.left, 0, insets.right));
        }
        string = this.getString("select.tooltip", null);
        if (string != null) {
            jButton.setToolTipText(string);
        }
        return jButton;
    }

    @Generated
    public AbstractButton getSelect() {
        return this.select;
    }
}

