/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.gui.PlaceholderTextField;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.edit.IncrementalSearch;
import de.qfs.lib.option.edit.RegexEscaper;
import de.qfs.lib.option.edit.SimpleOptionEdit;
import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.plaf.TextUI;
import javax.swing.text.Caret;
import lombok.Generated;

public class StringOptionEdit
extends SimpleOptionEdit {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.StringOptionEdit");
    private IncrementalSearch isearch;
    private RegexEscaper regexEscaper;

    @Override
    public void init() {
        Object object;
        if (StringOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "init()", 141).log();
        }
        super.init();
        String string = this.getString("placeholder", null);
        if (this.getBoolean("password", false)) {
            this.text = new JPasswordField(){

                @Override
                public boolean isFocusTraversable() {
                    return this.isEditable() && this.isEnabled();
                }

                @Override
                public boolean isFocusable() {
                    return true;
                }
            };
        } else if (!Misc.emptyOrNull(string)) {
            object = new PlaceholderTextField(){

                @Override
                protected void paintComponent(Graphics graphics) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "init().PlaceholderTextField.paintComponent(Graphics)", 162).addDetail("pG", graphics)).log();
                    }
                    super.paintComponent(graphics);
                    if (UIManager.getColor("TextField.background") != null) {
                        this.setBackground(UIManager.getColor("TextField.background"));
                    }
                }
            };
            ((PlaceholderTextField)object).setPlaceholder(string);
            this.text = object;
        } else {
            this.text = new JTextField(){

                @Override
                public boolean isFocusTraversable() {
                    return this.isEditable() && this.isEnabled();
                }

                @Override
                public boolean isFocusable() {
                    return true;
                }

                @Override
                public void updateUI() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "init().JTextField.updateUI()", 192).dumpStack();
                    }
                    Caret caret = this.getCaret();
                    int n = 0;
                    int n2 = 0;
                    if (caret != null) {
                        n = caret.getDot();
                        n2 = caret.getMark();
                    }
                    super.updateUI();
                    if (caret != null) {
                        this.setCaret(caret);
                        caret.setDot(n);
                        caret.moveDot(n2);
                    }
                }

                @Override
                public void setUI(TextUI textUI) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "init().JTextField.setUI(TextUI)", 212).addDetail("newUI", textUI)).dumpStack();
                    }
                    super.setUI(textUI);
                }

                @Override
                public void setBackground(Color color) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "init().JTextField.setBackground(Color)", 220).addDetail("c", color)).dumpStack();
                    }
                    super.setBackground(color);
                }
            };
        }
        this.label.setLabelFor(this.text);
        this.text.setName("Text-" + this.option.getName());
        this.add((Component)this.text, "Center");
        if ((this.selectOnFocus || this.highlightOnFocus) && !this.disabled) {
            this.text.addFocusListener(this);
        }
        if (this.option.getValue() != null) {
            this.text.setText((String)this.option.getValue());
            this.text.setCaretPosition(0);
        }
        this.text.setPreferredSize(new Dimension(10, this.text.getPreferredSize().height));
        if (this.disabled) {
            this.setEnabled(false);
        }
        if (this.readonly) {
            this.setEditable(false);
        }
        if (this.canIsearch) {
            this.isearch = new IncrementalSearch(this.text);
        }
        if (this.canEscapeRegex) {
            this.createRegexEscaper();
        }
        if (this.canPopup) {
            PopupManager.instance().registerPopupHandler(PopupManager.instance(), this.text);
            if (this.canIsearch) {
                PopupManager.instance().registerPopupHandler(this.isearch, this.text);
            }
            if (this.canEscapeRegex) {
                PopupManager.instance().registerPopupHandler(this.regexEscaper, this.text);
            }
        }
        if ((object = this.getString("tooltip", null)) != null) {
            this.text.setToolTipText((String)object);
        }
        this.maybeCommonPostInitSteps();
    }

    public void createRegexEscaper() {
        if (StringOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "createRegexEscaper()", 278).log();
        }
        this.regexEscaper = new RegexEscaper(this, this.text);
    }

    @Generated
    public RegexEscaper getRegexEscaper() {
        if (StringOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getRegexEscaper()", 110).log();
        }
        return this.regexEscaper;
    }

    @Generated
    public StringOptionEdit setRegexEscaper(RegexEscaper regexEscaper) {
        if (StringOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setRegexEscaper(RegexEscaper)", 111).addDetail("regexEscaper", regexEscaper)).log();
        }
        this.regexEscaper = regexEscaper;
        return this;
    }
}

