/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.edit;

import de.qfs.lib.config.ConfigWrapper;
import de.qfs.lib.config.Configuration;
import de.qfs.lib.gui.BetterScrollPane;
import de.qfs.lib.gui.ImageButton;
import de.qfs.lib.gui.Message;
import de.qfs.lib.gui.PopupHandler;
import de.qfs.lib.gui.PopupManager;
import de.qfs.lib.gui.SwingUtil;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.BooleanOption;
import de.qfs.lib.option.ChoiceOption;
import de.qfs.lib.option.IntegerOption;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionDialog;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.StringOption;
import de.qfs.lib.option.TextOption;
import de.qfs.lib.option.edit.Gutter;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.edit.RegexEscaper;
import de.qfs.lib.util.CSVUtil;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.Reflector;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputMethodEvent;
import java.awt.event.InputMethodListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.annotation.Nullable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;

public class TableOptionEdit
extends OptionEdit
implements PopupHandler {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.edit.TableOptionEdit");
    private static final String[] columnProps = new String[]{"name", "type", "cwidth", "nullok", "negativeok", "default", "disabled", "directedit", "canescaperegex", "height", "weight", "wrap"};
    protected static Icon LINEBREAK_ICON;
    protected static Icon TAB_ICON;
    private static HashSet forwardKeys;
    private static HashSet backwardKeys;
    protected JLabel label;
    protected Table table;
    protected JScrollPane scroll;
    private Gutter gutter;
    protected TableFocusListener tableFocusListener = new TableFocusListener();
    protected TableDoubleClickListener tableDoubleClickListener = new TableDoubleClickListener();
    protected Border defaultBorder;
    protected Border focusBorder;
    protected ConfigWrapper wrapper;
    protected Column[] columns;
    protected int colidx;
    protected boolean enabled = true;
    protected boolean canedit;
    protected boolean caninsert;
    protected boolean canremove;
    protected boolean canmove;
    protected boolean directinsert;
    protected boolean insertondoubleclick;
    protected boolean directedit;
    protected boolean selectrow;
    protected boolean multirow;
    protected boolean cutpaste;
    protected boolean canpopup;
    protected boolean cancopy;
    protected boolean canmark;
    protected boolean canclipboard;
    protected double weight = 1.0;
    protected boolean caneditcolumn;
    protected int autoResizeLimit;
    protected boolean canlinenumbers;
    private static String columnTextSeparator;
    private int minPrefHeight;
    private int maxPrefHeight;
    private int maxEditorRows;
    private int tableRows;

    public TableOptionEdit() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "TableOptionEdit()", 617).log();
        }
    }

    @Override
    protected void init() {
        block45: {
            String string;
            Box box;
            Object object;
            Object object2;
            String string2;
            if (TableOptionEdit.logger.level >= 7) {
                logger.lvlBuild(7, "init()", 632).log();
            }
            if ((string2 = this.getString("columns", null)) == null) {
                if (TableOptionEdit.logger.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "init()", 636).add("No columns for TableOptionEdit ")).add(this.option.getName())).log();
                }
                return;
            }
            this.directedit = this.getBoolean("directedit", true);
            this.canedit = this.getBoolean("canedit", true);
            this.caninsert = this.getBoolean("caninsert", true);
            this.canremove = this.getBoolean("canremove", true);
            this.canmove = this.getBoolean("canmove", true);
            this.cancopy = this.getBoolean("cancopy", true);
            this.canmark = this.getBoolean("canmark", true);
            this.directinsert = this.getBoolean("directinsert", !this.canedit);
            this.insertondoubleclick = this.getBoolean("insertondoubleclick", this.canedit);
            this.selectrow = this.getBoolean("selectrow", false);
            this.multirow = this.selectrow && this.getBoolean("multirow", false);
            this.cutpaste = this.getBoolean("cutpaste", false);
            this.canpopup = this.getBoolean("canpopup", false);
            this.canclipboard = this.getBoolean("canclipboard", true);
            this.caneditcolumn = this.getBoolean("caneditcolumn", false);
            this.autoResizeLimit = this.getInt("autoresizelimit", 4);
            String string3 = this.getString("buttonpos", "below");
            this.canlinenumbers = this.getBoolean("canlinenumbers", true);
            this.minPrefHeight = this.getInt("minheight", 0);
            this.maxPrefHeight = this.getInt("maxheight", 0);
            this.maxEditorRows = this.getInt("maxeditorrows", 3);
            int n = 0;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                ++n;
                stringTokenizer.nextToken();
            }
            this.columns = this.createColumnArray(n);
            n = 0;
            stringTokenizer = new StringTokenizer(string2);
            while (stringTokenizer.hasMoreTokens()) {
                this.columns[n++] = this.createTableColumn(stringTokenizer.nextToken());
            }
            this.setLayout(new BorderLayout());
            this.disabled = this.getBoolean("disabled", false);
            this.table = this.createTable();
            this.initTable(this.table);
            if (this.minPrefHeight > 0 || this.maxPrefHeight != 0) {
                this.scroll = new BetterScrollPane(this.table){

                    @Override
                    public boolean isValidateRoot() {
                        if (logger.level >= 7) {
                            logger.lvlBuild(7, "init().BetterScrollPane.isValidateRoot()", 687).log();
                        }
                        return false;
                    }
                };
                this.putClientProperty("BetterScrollPane.Parent", Boolean.TRUE);
            } else {
                this.scroll = new JScrollPane(this.table);
            }
            if (this.canlinenumbers) {
                int n2 = this.getInt("linenumbersbase", 1);
                this.gutter = new Gutter(this.table, n2);
                this.scroll.setRowHeaderView(this.gutter);
                this.scroll.getRowHeader().setSize(this.gutter.getSize());
            }
            this.scroll.setName("ScrollPane-" + this.option.getName());
            Color color = UIManager.getColor("Table.background");
            if (color != null) {
                this.scroll.getViewport().setBackground(color);
            } else {
                this.scroll.getViewport().setBackground(Color.white);
            }
            this.defaultBorder = this.scroll.getBorder();
            this.focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");
            this.scroll.setBorder(this.defaultBorder);
            this.table.addFocusListener(this.tableFocusListener);
            this.table.getTableHeader().addMouseListener(this.tableFocusListener);
            this.scroll.getViewport().addMouseListener(this.tableFocusListener);
            if (this.canpopup) {
                PopupManager.instance().registerPopupHandler(this, this.scroll.getViewport());
                PopupManager.instance().registerPopupHandler(this, this.table);
                PopupManager.instance().registerPopupHandler(this, this.table.getTableHeader());
            }
            if (this.canclipboard) {
                this.clipboardButton = new ImageButton();
                this.initClipboardButton();
                this.clipboardButton.addActionListener(actionEvent -> this.onButtonPressed());
            }
            if (this.insertondoubleclick) {
                object2 = new TableDoubleClickListener();
                this.table.addMouseListener((MouseListener)object2);
            }
            if ((object2 = this.getString("label", null)) != null) {
                this.label = new OptionEdit.OptionJLabel((String)object2);
                this.label.setName("Label-" + this.option.getName());
                this.label.setLabelFor(this.table);
                object = this.getString("mnemonic", null);
                if (object != null && ((String)object).length() > 0) {
                    this.label.setDisplayedMnemonic(((String)object).charAt(0));
                }
            }
            object = this.table.getButtons();
            if (((Component)object).getPreferredSize().width < 10) {
                if (this.canclipboard && this.clipboardButton != null) {
                    box = Box.createVerticalBox();
                    if (object2 != null) {
                        box.add(this.label);
                        box.add(Box.createHorizontalGlue());
                        box.add(this.clipboardButton);
                    }
                } else if (object2 != null) {
                    this.add((Component)this.label, "North");
                }
                this.add((Component)this.scroll, "Center");
            } else if ("left".equals(string3)) {
                box = Box.createHorizontalBox();
                box.add((Component)object);
                if (object2 != null) {
                    box.add(Box.createHorizontalStrut(2));
                    box.add(this.label);
                }
                if (this.canclipboard && this.clipboardButton != null) {
                    box.add(Box.createHorizontalGlue());
                    box.add(this.clipboardButton);
                }
                this.add((Component)box, "North");
                this.add((Component)this.scroll, "Center");
            } else if ("right".equals(string3)) {
                box = Box.createHorizontalBox();
                if (object2 != null) {
                    box.add(this.label);
                    box.add(Box.createHorizontalStrut(2));
                }
                box.add((Component)object);
                if (this.canclipboard && this.clipboardButton != null) {
                    box.add(Box.createHorizontalGlue());
                    box.add(this.clipboardButton);
                }
                this.add((Component)box, "North");
                this.add((Component)this.scroll, "Center");
            } else if ("rightalign".equals(string3)) {
                box = Box.createHorizontalBox();
                if (object2 != null) {
                    box.add(this.label);
                }
                box.add(Box.createHorizontalGlue());
                box.add((Component)object);
                if (this.canclipboard && this.clipboardButton != null) {
                    box.add(Box.createHorizontalGlue());
                    box.add(this.clipboardButton);
                }
                this.add((Component)box, "North");
                this.add((Component)this.scroll, "Center");
            } else {
                if (object2 != null) {
                    this.add((Component)this.label, "North");
                }
                ((Box)object).add(Box.createHorizontalGlue());
                box = Box.createVerticalBox();
                box.add((Component)object);
                if (this.canclipboard && this.clipboardButton != null) {
                    box.add(Box.createHorizontalGlue());
                    box.add(this.clipboardButton);
                }
                box.add(this.scroll);
                this.add((Component)box, "Center");
            }
            this.setValue(this.option.getValue());
            this.table.setName("Table-" + this.option.getName());
            this.table.getTableHeader().setName("TableHeader-" + this.option.getName());
            int n3 = this.getInt("width", 50);
            int n4 = this.getInt("height", 100);
            this.setPreferredSize(new Dimension(n3, n4));
            if (this.getBoolean("configure", false)) {
                this.wrapper = ConfigWrapper.makeWrapper(this.table, this.option.getName() + ".table");
                Configuration.instance().register(this.wrapper);
            }
            if ((string = this.getString("weight", null)) != null) {
                try {
                    this.weight = Double.valueOf(string);
                }
                catch (NumberFormatException numberFormatException) {
                    if (TableOptionEdit.logger.level < 3) break block45;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "init()", 834).add("ex", numberFormatException)).log();
                }
            }
        }
        if (this.canlinenumbers) {
            if (this.getTableModel() != null) {
                this.getTableModel().addTableModelListener(this.gutter);
            }
            this.table.getSelectionModel().addListSelectionListener(this.gutter);
            if (this.getBoolean("linenumbersinitialon", false)) {
                this.gutter.unhide();
            } else {
                this.gutter.hide();
            }
        }
        if (this.canclipboard && this.clipboardButton != null) {
            this.addTableClipboardState();
        }
        if (this.disabled) {
            this.setEnabled(false);
        }
    }

    public Column createTableColumn(String string) {
        return new Column(string);
    }

    public Column[] createColumnArray(int n) {
        return new Column[n];
    }

    @Override
    public void update(Option option) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(Option)", 888).addDetail("option", option)).log();
        }
        this.option = option;
        Object object = option.getValue();
        if (this.wrapper != null) {
            Configuration.instance().unregister(this.wrapper, true);
        }
        this.setValue(object);
        if (this.getBoolean("configure", false)) {
            this.wrapper = ConfigWrapper.makeWrapper(this.table, option.getName() + ".table");
            Configuration.instance().register(this.wrapper);
        }
        if (this.canlinenumbers) {
            this.getTableModel().removeTableModelListener(this.gutter);
            this.getTableModel().addTableModelListener(this.gutter);
            this.gutter.repaintOnLineNumberChange();
        }
    }

    @Override
    public boolean isModified() {
        boolean bl;
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "isModified()", 921).log();
        }
        int n = this.table.getRowCount();
        int n2 = this.table.getColumnModel().getColumnCount();
        if (TableOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 925).add("rows: ")).add("rows", n)).add(", columns: ")).add("columns", this.columns)).log();
        }
        if ((n > 0 || this.caneditcolumn) && n2 > 0) {
            if (!(this.option.getValue() instanceof Object[][])) {
                if (TableOptionEdit.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "isModified()", 930).add("Wring format")).log();
                }
                return true;
            }
            Object[][] objectArray = (Object[][])this.option.getValue();
            if (TableOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 934).add("old", objectArray)).log();
            }
            if (objectArray.length != n + (this.caneditcolumn ? 1 : 0)) {
                if (TableOptionEdit.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "isModified()", 936).add("Row num difference")).log();
                }
                return true;
            }
            if (objectArray.length > 0 && objectArray[0].length != this.columns.length) {
                if (TableOptionEdit.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "isModified()", 940).add("Column num difference")).log();
                }
                return true;
            }
            Object[][] objectArray2 = this.fetchValue();
            if (TableOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 944).add("current", objectArray2)).log();
            }
            if (objectArray2 == null || objectArray2.length != objectArray.length) {
                if (TableOptionEdit.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "isModified()", 946).add("Length difference")).log();
                }
                return true;
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i].length != objectArray2[i].length) {
                    if (TableOptionEdit.logger.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "isModified()", 951).add("Column size difference at row ")).add(i)).log();
                    }
                    return true;
                }
                for (int j = 0; j < objectArray[i].length; ++j) {
                    boolean bl2 = false;
                    if (i == 0 && this.caneditcolumn) {
                        bl2 = Misc.equalOrNull(objectArray[i][j], objectArray2[i][j]);
                        if (!bl2 && objectArray[i][j] instanceof String && objectArray2[i][j] instanceof String) {
                            int n3 = ((String)objectArray[i][j]).lastIndexOf(".");
                            int n4 = ((String)objectArray2[i][j]).lastIndexOf(".");
                            if (n3 >= 0 && n4 == n3 && ((String)objectArray[i][j]).substring(0, n3).equals(((String)objectArray2[i][j]).substring(0, n4))) {
                                bl2 = true;
                            }
                        }
                    } else {
                        bl2 = Misc.equalOrNull(objectArray[i][j], objectArray2[i][j]);
                    }
                    if (bl2) continue;
                    if (TableOptionEdit.logger.level >= 5) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "isModified()", 977).add("Cell difference at row ")).add(i)).add(" column ")).add(j)).log();
                    }
                    return true;
                }
            }
            return false;
        }
        boolean bl3 = bl = this.option.getValue() != null && (!(this.option.getValue() instanceof Object[][]) || ((Object[][])this.option.getValue()).length > 0);
        if (bl && TableOptionEdit.logger.level >= 5) {
            ((LevelAwareLogBuilder)logger.lvlBuild(5, "isModified()", 988).add("Null/non-null difference")).log();
        }
        return bl;
    }

    @Override
    public boolean checkValue() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "checkValue()", 1004).log();
        }
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        return true;
    }

    @Override
    public void readValue() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "readValue()", 1019).log();
        }
        if (this.table.isEditing()) {
            this.table.getCellEditor().stopCellEditing();
        }
        this.option.setValue(this.fetchValue());
    }

    @Override
    public double getWeight() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getWeight()", 1036).log();
        }
        return this.weight;
    }

    @Override
    public void setEnabled(boolean bl) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEnabled(boolean)", 1051).addDetail("enabled", bl)).log();
        }
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEnabled(boolean)", 1053).add("disabled", this.disabled)).log();
        }
        if (this.disabled) {
            bl = false;
        }
        this.enabled = bl;
        if (this.table != null) {
            this.table.setEnabled(bl);
        }
        if (this.label != null) {
            if (bl) {
                this.label.setForeground(UIManager.getColor("textText"));
            } else {
                this.label.setForeground(UIManager.getColor("textInactiveText"));
            }
            this.label.setEnabled(bl);
        }
        if (this.gutter != null) {
            this.gutter.setEnabled(bl);
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void requestFocus() {
        this.table.requestFocus();
    }

    public void setTitle(String string) {
        if (this.label != null) {
            this.label.setText(string);
        }
    }

    public final Table getTable() {
        return this.table;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = null;
        Dimension dimension2 = null;
        if (this.table != null) {
            dimension = this.table.getPreferredSize();
            dimension2 = this.scroll.getViewport().getSize();
            if (TableOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getPreferredSize()", 1154).add("tsize", dimension)).add("vpsize", dimension2)).log();
            }
        }
        Dimension dimension3 = this.adjustPreferredSize(this.table, dimension, dimension2, this.minPrefHeight, this.maxPrefHeight);
        if (TableOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "getPreferredSize()", 1157).add("ret", dimension3)).log();
        }
        return dimension3;
    }

    @Override
    public void reshape(int n, int n2, int n3, int n4) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "reshape(int,int,int,int)", 1169).addDetail("x", n)).addDetail("y", n2)).addDetail("w", n3)).addDetail("h", n4)).log();
        }
        super.reshape(n, n2, n3, n4);
        if (this.table != null) {
            int n5 = this.table.getRowCount();
            if (TableOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "reshape(int,int,int,int)", 1174).add("newLineCount", n5)).log();
            }
            if (n5 > this.tableRows && this.table.isFocusOwner()) {
                this.tableRows = n5;
                if (TableOptionEdit.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "reshape(int,int,int,int)", 1177).add("Scrolling...")).log();
                }
                Dimension dimension = this.getSize();
                this.scrollRectToVisible(new Rectangle(0, 0, dimension.width, dimension.height));
            } else {
                this.tableRows = n5;
            }
        }
    }

    public void highlight(int n, int n2, int n3, int n4, String string, int n5) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "highlight(int,int,int,int,String,int)", 1203).addDetail("mrow", n)).addDetail("mcol", n2)).addDetail("start", n3)).addDetail("end", n4)).addDetail("value", string)).addDetail("messageType", n5)).log();
        }
        this.getTableModel().addHighlightData(n, n2, n3, n4, string, n5);
    }

    @Override
    public void dehighlight() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "dehighlight()", 1219).log();
        }
        this.table.dehighlightTable();
        super.dehighlight();
    }

    @Override
    public boolean matchesFilterText(Predicate<String> predicate) {
        int n;
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "matchesFilterText(Predicate<String>)", 1240).addDetail("matcher", predicate)).log();
        }
        if (predicate == null) {
            return true;
        }
        String string = this.getString("label", null);
        if (string != null && predicate.test(string)) {
            return true;
        }
        for (n = 0; n < this.table.getRowCount(); ++n) {
            for (int i = 0; i < this.table.getColumnCount(); ++i) {
                Object object = this.table.getModel().getValueAt(n, i);
                if (!(object instanceof String) || !predicate.test((String)object)) continue;
                return true;
            }
        }
        for (n = 0; n < this.table.getColumnCount(); ++n) {
            Object object = this.table.getColumnModel().getColumn(n).getHeaderValue();
            if (!(object instanceof String) || !predicate.test((String)object)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean fillPopup(PopupManager popupManager, Component component, JPopupMenu jPopupMenu, MapResourceBundle mapResourceBundle, int n, int n2, boolean bl) {
        if (this.canpopup && (component instanceof Table || component instanceof JViewport || component instanceof JTableHeader)) {
            Cloneable cloneable;
            Object object;
            int n3;
            Object object2;
            if (this.table.getRowCount() > 0) {
                int n4 = this.table.getColumnModel().getColumnIndexAtX(n);
                int n5 = this.table.rowAtPoint(new Point(n, n2));
                object2 = this.table.getSelectedRows();
                if (object2 != null && n5 != -1) {
                    boolean bl2 = false;
                    for (int i = 0; i < ((int[])object2).length; ++i) {
                        if (object2[i] != n5) continue;
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        if (TableOptionEdit.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fillPopup(PopupManager,Component,JPopupMenu,MapResourceBundle,int,int,boolean)", 1323).add("fix selection")).log();
                        }
                        this.table.setRowSelectionInterval(n5, n5);
                    }
                }
            }
            if (this.canremove) {
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.cut();
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.row.cut");
                this.pmiCut = popupManager.createMenuItem("cut", mapResourceBundle, "popup.table.row.cut", (ActionListener)abstractAction, false);
                KeyStroke keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.cut");
                if (keyStroke != null) {
                    this.pmiCut.setAccelerator(keyStroke);
                }
                popupManager.addMenuItem(this.pmiCut, -1, "");
            }
            if (this.cancopy) {
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.copy();
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.row.copy");
                this.pmiCopy = popupManager.createMenuItem("copy", mapResourceBundle, "popup.table.row.copy", (ActionListener)abstractAction, false);
                KeyStroke keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.copy");
                if (keyStroke != null) {
                    this.pmiCopy.setAccelerator(keyStroke);
                }
                popupManager.addMenuItem(this.pmiCopy, -1, "");
            }
            if (this.caninsert) {
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.paste();
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.row.paste");
                this.pmiPaste = popupManager.createMenuItem("paste", mapResourceBundle, "popup.table.row.paste", (ActionListener)abstractAction, false);
                KeyStroke keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.paste");
                if (keyStroke != null) {
                    this.pmiPaste.setAccelerator(keyStroke);
                }
                popupManager.addMenuItem(this.pmiPaste, -1, "");
            }
            if (this.canremove) {
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.delete();
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.row.delete");
                this.pmiDelete = popupManager.createMenuItem("delete", mapResourceBundle, "popup.table.row.delete", (ActionListener)abstractAction, false);
                this.pmiDelete.setAccelerator(KeyOptionEdit.getKeyStrokeForResource("keystroke.remove"));
                popupManager.addMenuItem(this.pmiDelete, -1, "");
            }
            JMenuItem jMenuItem = null;
            if (this.canedit) {
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.editRow();
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.row.edit");
                jMenuItem = popupManager.createMenuItem("edit", mapResourceBundle, "popup.table.row.edit", (ActionListener)abstractAction, false);
                jMenuItem.setAccelerator(KeyOptionEdit.getKeyStrokeForResource("keystroke.edit"));
                popupManager.addMenuItem(jMenuItem, -1, "");
            }
            object2 = null;
            JMenuItem jMenuItem2 = null;
            JMenuItem jMenuItem3 = null;
            if (this.caneditcolumn) {
                popupManager.addSeparator(-1, "");
                int n6 = -1;
                if (component instanceof JTable || component instanceof JTableHeader) {
                    n6 = this.table.getColumnModel().getColumnIndexAtX(n);
                }
                n3 = n6;
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.insertColumn(n3, null);
                    }
                };
                object = n6 < 0 ? "add" : "insert";
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.column." + (String)object);
                object2 = popupManager.createMenuItem("edit", mapResourceBundle, "popup.table.column." + (String)object, (ActionListener)abstractAction, false);
                popupManager.addMenuItem((JMenuItem)object2, -1, "");
                abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.removeColumn(n3);
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.column.remove");
                jMenuItem2 = popupManager.createMenuItem("edit", mapResourceBundle, "popup.table.column.remove", (ActionListener)abstractAction, false);
                popupManager.addMenuItem(jMenuItem2, -1, "");
                jMenuItem2.setEnabled(n3 >= 0);
                abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.editColumn(n3);
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.column.edit");
                jMenuItem3 = popupManager.createMenuItem("edit", mapResourceBundle, "popup.table.column.edit", (ActionListener)abstractAction, false);
                popupManager.addMenuItem(jMenuItem3, -1, "");
                jMenuItem3.setEnabled(n3 >= 0);
            }
            if (this.canremove || this.caneditcolumn || this.canedit || this.caninsert || this.cancopy) {
                popupManager.addSeparator(-1, "");
            }
            if (this.canmark) {
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        TableOptionEdit.this.table.selectAll();
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.table.row.selectall");
                this.pmiSelectAll = popupManager.createMenuItem("selectall", mapResourceBundle, "popup.table.row.selectall", (ActionListener)abstractAction, false);
                KeyStroke keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.selectall");
                if (keyStroke != null) {
                    this.pmiSelectAll.setAccelerator(keyStroke);
                }
                popupManager.addMenuItem(this.pmiSelectAll, -1, "");
            }
            int n7 = -1;
            if (component instanceof JTable || component instanceof JTableHeader) {
                n7 = this.table.getColumnModel().getColumnIndexAtX(n);
            }
            if (n7 >= 0) {
                n3 = this.columns[n7].canescaperegex ? 1 : '\u0000';
                final int n8 = n7;
                if (n3 != 0) {
                    cloneable = new AbstractAction(){

                        @Override
                        public void actionPerformed(ActionEvent actionEvent) {
                            TableOptionEdit.this.table.escapeRegex(n8);
                        }
                    };
                    popupManager.setupAction((Action)((Object)cloneable), mapResourceBundle, "popup.regexescaper");
                    JMenuItem jMenuItem4 = popupManager.createMenuItem("regexescaper", mapResourceBundle, "popup.regexescaper", (ActionListener)((Object)cloneable), true);
                    popupManager.addSeparator(-1, "");
                    if (!this.isEnabled()) {
                        jMenuItem4.setEnabled(false);
                    }
                    popupManager.addMenuItem(jMenuItem4, -1, "");
                }
            }
            if (this.canlinenumbers) {
                AbstractAction abstractAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
                            if (((JCheckBoxMenuItem)actionEvent.getSource()).getState()) {
                                TableOptionEdit.this.gutter.unhide();
                            } else {
                                TableOptionEdit.this.gutter.hide();
                            }
                        }
                    }
                };
                popupManager.setupAction(abstractAction, mapResourceBundle, "popup.linenumbers");
                object = popupManager.createMenuItem("linenumbers", mapResourceBundle, "popup.linenumbers", (ActionListener)abstractAction, true);
                ((JCheckBoxMenuItem)object).setState(!this.gutter.isHidden());
                popupManager.addSeparator(-1, "");
                popupManager.addMenuItem((JMenuItem)object, -1, "");
            }
            if (this.pmiPaste != null) {
                Object[][] objectArray = this.table.getRowsForPaste();
                if (objectArray != null) {
                    this.pmiPaste.setEnabled(true);
                } else {
                    this.pmiPaste.setEnabled(false);
                }
            }
            if (this.table.getRowCount() > 0 && this.table.getSelectionModel().getMinSelectionIndex() >= 0) {
                if (this.pmiCut != null) {
                    this.pmiCut.setEnabled(true);
                }
                if (this.pmiCopy != null) {
                    this.pmiCopy.setEnabled(true);
                }
                if (this.pmiDelete != null) {
                    this.pmiDelete.setEnabled(true);
                }
                if (jMenuItem != null) {
                    jMenuItem.setEnabled(true);
                }
                if (!bl) {
                    int n9 = this.table.getSelectionModel().getMinSelectionIndex();
                    int n10 = this.table.getColumnModel().getSelectionModel().getMinSelectionIndex();
                    cloneable = n9 >= 0 && n10 >= 0 ? this.table.getCellRect(n9, n10, true) : this.table.getVisibleRect();
                    PopupManager.instance().setPopupPosition(new Point(((Rectangle)cloneable).x + ((Rectangle)cloneable).width / 2, ((Rectangle)cloneable).y + ((Rectangle)cloneable).height / 2));
                }
            } else {
                if (this.pmiCut != null) {
                    this.pmiCut.setEnabled(false);
                }
                if (this.pmiCopy != null) {
                    this.pmiCopy.setEnabled(false);
                }
                if (this.pmiDelete != null) {
                    this.pmiDelete.setEnabled(false);
                }
                if (jMenuItem != null) {
                    jMenuItem.setEnabled(false);
                }
            }
            if (this.table.getRowCount() > 0) {
                this.pmiSelectAll.setEnabled(true);
            } else {
                this.pmiSelectAll.setEnabled(false);
            }
            if (!this.isEnabled()) {
                if (this.pmiCut != null) {
                    this.pmiCut.setEnabled(false);
                }
                if (this.pmiPaste != null) {
                    this.pmiPaste.setEnabled(false);
                }
                if (this.pmiDelete != null) {
                    this.pmiDelete.setEnabled(false);
                }
                if (jMenuItem != null) {
                    jMenuItem.setEnabled(false);
                }
                if (this.caneditcolumn) {
                    object2.setEnabled(false);
                    jMenuItem2.setEnabled(false);
                    jMenuItem3.setEnabled(false);
                }
            }
            return true;
        }
        return false;
    }

    public static void setColumnTextSeparator(String string) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setColumnTextSeparator(String)", 1642).addDetail("separator", string)).log();
        }
        columnTextSeparator = string;
    }

    public static String getColumnTextSeparator() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getColumnTextSeparator()", 1655).log();
        }
        return columnTextSeparator;
    }

    protected Object[][] fetchValue() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "fetchValue()", 1672).log();
        }
        int n = this.table.getRowCount();
        if (TableOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchValue()", 1675).add("rows", n)).log();
        }
        int n2 = this.table.getColumnModel().getColumnCount();
        if (TableOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchValue()", 1677).add("cols", n2)).log();
        }
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        if (this.table.isEditing()) {
            n3 = this.table.getEditingRow();
            n4 = this.table.getEditingColumn();
            n5 = this.table.convertColumnIndexToModel(n4);
        }
        if ((n > 0 || this.caneditcolumn) && n2 > 0) {
            Object[][] objectArray = new Object[n + (this.caneditcolumn ? 1 : 0)][];
            int n6 = 0;
            if (this.caneditcolumn) {
                int n7;
                int n8;
                n6 = 1;
                objectArray[0] = new Object[n2];
                for (n8 = 0; n8 < n2; ++n8) {
                    n7 = this.table.getColumnModel().getColumn(n8).getWidth();
                    objectArray[0][n8] = this.columns[this.table.convertColumnIndexToModel((int)n8)].name + "." + n7;
                }
                for (n8 = 0; n8 < n; ++n8) {
                    objectArray[n6 + n8] = new Object[n2];
                    for (n7 = 0; n7 < n2; ++n7) {
                        objectArray[n6 + n8][n7] = this.table.getValueAt(n8, n7);
                        if (n8 != n3 || n7 != n4) continue;
                        try {
                            objectArray[n6 + n8][n7] = this.getEditedValueFromString(this.table.getValueOfEditorComponent(), objectArray[n6 + n8][n7], n6 + n8, n7, true);
                            continue;
                        }
                        catch (CancelEditException cancelEditException) {
                            if (TableOptionEdit.logger.level < 9) continue;
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchValue()", 1706).add("Storage of edited data cancelled")).log();
                        }
                    }
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    objectArray[n6 + i] = new Object[n2];
                    if (this.getTableModel() == null) {
                        if (TableOptionEdit.logger.level < 9) break;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchValue()", 1715).add("No table model.")).log();
                        break;
                    }
                    for (int j = 0; j < n2; ++j) {
                        objectArray[n6 + i][j] = this.getTableModel().getValueAt(i, j);
                        if (i != n3 || j != n5) continue;
                        try {
                            objectArray[n6 + i][j] = this.getEditedValueFromString(this.table.getValueOfEditorComponent(), objectArray[n6 + i][j], n6 + i, j, true);
                            continue;
                        }
                        catch (CancelEditException cancelEditException) {
                            if (TableOptionEdit.logger.level < 9) continue;
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchValue()", 1724).add("Storage of edited data cancelled")).log();
                        }
                    }
                }
            }
            if (TableOptionEdit.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "fetchValue()", 1730).add("val", objectArray)).log();
            }
            return objectArray;
        }
        return null;
    }

    public void setValue(Object object) {
        Object[][] objectArray;
        boolean bl;
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setValue(Object)", 1746).addDetail("value", object)).log();
        }
        SwingUtil.verifyDispatchThread(logger, "TableOptionEdit.createModel()");
        if (this.caneditcolumn) {
            bl = true;
            if (object == null || ((Object[])object).length < 2) {
                objectArray = new Object[][]{};
            } else {
                objectArray = new Object[((Object[])object).length - 1][];
                System.arraycopy(object, 1, objectArray, 0, ((Object[])object).length - 1);
            }
            if (object != null && ((Object[])object).length > 0) {
                Object[] objectArray2 = ((Object[][])object)[0];
                this.columns = this.createColumnArray(objectArray2.length);
                this.colidx = 0;
                for (int i = 0; i < objectArray2.length; ++i) {
                    this.columns[i] = this.createDefaultColumn(this.colidx++);
                    this.columns[i].width = -1;
                    String string = objectArray2[i] == null ? "" : objectArray2[i].toString();
                    int n = string.lastIndexOf(".");
                    if (n > 0) {
                        this.columns[i].name = string.substring(0, n);
                        try {
                            this.columns[i].width = Integer.parseInt(string.substring(n + 1));
                        }
                        catch (NumberFormatException numberFormatException) {
                            if (TableOptionEdit.logger.level < 3) continue;
                            ((LevelAwareLogBuilder)logger.lvlBuild(3, "setValue(Object)", 1774).add("ex", numberFormatException)).log();
                        }
                        continue;
                    }
                    this.columns[i].name = string;
                }
            } else {
                this.columns = this.createColumnArray(0);
            }
        } else {
            bl = this.table.getColumnCount() == 0;
            objectArray = object == null ? new Object[][]{} : (Object[][])object;
        }
        this.createModel(objectArray);
        if (bl) {
            for (int i = 0; i < this.columns.length; ++i) {
                if (this.columns[i].width <= 0) continue;
                this.table.getColumnModel().getColumn(i).setPreferredWidth(this.columns[i].width);
            }
        }
        this.table.clearSelection();
        for (int i = 0; i < this.columns.length; ++i) {
            this.table.getColumnModel().getColumn(i).setIdentifier(this.columns[i].id);
            this.table.getColumnModel().getColumn(i).setCellRenderer(this.columns[i].renderer);
            this.table.getColumnModel().getColumn(i).setCellEditor(this.columns[i].editor);
        }
        if (this.columns.length > this.autoResizeLimit) {
            this.table.setAutoResizeMode(0);
        } else {
            this.table.setAutoResizeMode(2);
        }
    }

    protected void createModel(Object[][] objectArray) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createModel(Object[][])", 1821).addDetail("data", objectArray)).log();
        }
        SwingUtil.verifyDispatchThread(logger, "TableOptionEdit.createModel()");
        this.table.setModel(new Model(objectArray, this.columns.length));
    }

    @NonNull
    protected SelectedRowsAndColumn getSelectedRowsAndColumn(Component component, int n) {
        boolean bl;
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getSelectedRowsAndColumn(Component,int)", 1831).addDetail("parent", component)).addDetail("x", n)).log();
        }
        int[] nArray = this.table.getSelectedRows();
        int n2 = this.table.getColumnModel().getColumnIndexAtX(n);
        boolean bl2 = bl = this.table.getTableHeader() == component;
        if (TableOptionEdit.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getSelectedRowsAndColumn(Component,int)", 1836).add("selRows", nArray)).add("clickCol", n2)).add("allRows", bl)).log();
        }
        if (bl) {
            int n3 = this.table.getRowCount();
            nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = i;
            }
        }
        SelectedRowsAndColumn selectedRowsAndColumn = new SelectedRowsAndColumn(nArray, n2);
        return selectedRowsAndColumn;
    }

    protected Table createTable() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "createTable()", 1872).log();
        }
        return new Table();
    }

    protected void initTable(Table table) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "initTable(Table)", 1883).addDetail("table", table)).log();
        }
    }

    public Model getTableModel() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getTableModel()", 1896).log();
        }
        if (this.table.getModel() instanceof Model) {
            return (Model)this.table.getModel();
        }
        return null;
    }

    private Column createDefaultColumn(int n) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "createDefaultColumn(int)", 1914).addDetail("idx", n)).log();
        }
        Properties properties = new Properties();
        String string = this.option.getName();
        for (int i = 0; i < columnProps.length; ++i) {
            String string2 = this.getString("column.default." + columnProps[i], null);
            if (string2 == null) continue;
            properties.put("option." + string + ".column.default" + n + "." + columnProps[i], string2);
        }
        Option.getResources().addResources(properties);
        return this.createTableColumn("default" + n);
    }

    public boolean doShowWhitespaces() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "doShowWhitespaces()", 1937).log();
        }
        return this.getBoolean("showwhitespacesincells", false);
    }

    public void performCustomModification(int n, int n2) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "performCustomModification(int,int)", 1951).addDetail("currentRow", n)).addDetail("column", n2)).log();
        }
    }

    public String escapeValue(String string) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "escapeValue(String)", 1964).addDetail("valueToEscape", string)).log();
        }
        RegexEscaper regexEscaper = new RegexEscaper(null, null);
        return regexEscaper.escapeString(string, string, -1, -1);
    }

    protected Color getInactiveBackgroundColor() {
        Color color;
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "getInactiveBackgroundColor()", 1973).log();
        }
        if ((color = UIManager.getColor("Table.unfocusedSelectionBackground")) == null) {
            color = UIManager.getColor("TextField.inactiveBackground");
        }
        return color;
    }

    public Object getCleanModelValueAt(int n, int n2) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getCleanModelValueAt(int,int)", 1988).addDetail("row", n)).addDetail("column", n2)).log();
        }
        return this.getTableModel().getValueAt(n, n2);
    }

    public void setCleanModelValueAt(Object object, int n, int n2) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setCleanModelValueAt(Object,int,int)", 1998).addDetail("value", object)).addDetail("row", n)).addDetail("column", n2)).log();
        }
        this.getTableModel().setValueAt(object, n, n2);
    }

    private void addTableClipboardState() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "addTableClipboardState()", 2005).log();
        }
        if (!this.canclipboard || this.clipboardButton == null || this.table == null) {
            return;
        }
        this.updateClipboardButtonState();
        this.table.getModel().addTableModelListener(tableModelEvent -> this.updateClipboardButtonState());
        this.table.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.updateClipboardButtonState();
            }
        });
        this.table.addPropertyChangeListener("model", propertyChangeEvent -> {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof TableModel) {
                ((TableModel)object).addTableModelListener(tableModelEvent -> this.updateClipboardButtonState());
                this.updateClipboardButtonState();
            }
        });
    }

    private void updateClipboardButtonState() {
        if (TableOptionEdit.logger.level >= 7) {
            logger.lvlBuild(7, "updateClipboardButtonState()", 2028).log();
        }
        if (this.clipboardButton == null || this.table == null) {
            return;
        }
        boolean bl = this.table.getRowCount() > 0;
        this.clipboardButton.setEnabled(bl && !this.disabled);
    }

    @Override
    public void onButtonPressed() {
        int n;
        if (this.table == null) {
            return;
        }
        TableModel tableModel = this.table.getModel();
        int n2 = tableModel.getColumnCount();
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.option != null && this.option.getName() != null ? this.option.getName() : "";
        int[] nArray = this.table.getSelectedRows();
        if (nArray.length == 0) {
            nArray = new int[this.table.getRowCount()];
            for (n = 0; n < this.table.getRowCount(); ++n) {
                nArray[n] = n;
            }
        }
        for (n = 0; n < nArray.length; ++n) {
            String string2;
            Object object;
            int n3 = this.table.convertRowIndexToModel(nArray[n]);
            if (n2 == 1) {
                Object object2 = tableModel.getValueAt(n3, 0);
                if (object2 != null) {
                    stringBuilder.append(object2.toString().trim());
                }
            } else if ("headers".equals(string)) {
                String string3;
                Object object3 = tableModel.getValueAt(n3, 0);
                object = n2 > 1 ? tableModel.getValueAt(n3, 1) : null;
                string2 = object3 == null ? "" : object3.toString().trim();
                String string4 = string3 = object == null ? "" : object.toString().trim();
                if (!string2.isEmpty()) {
                    stringBuilder.append(string2).append(": ").append(string3);
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    object = tableModel.getValueAt(n3, i);
                    String string5 = string2 = object == null ? "" : object.toString().trim();
                    if (i > 0) {
                        stringBuilder.append("\t");
                    }
                    stringBuilder.append(string2);
                }
            }
            if (n >= nArray.length - 1) continue;
            stringBuilder.append(System.lineSeparator());
        }
        if (stringBuilder.length() > 0) {
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(stringSelection, null);
            super.onButtonPressed();
        }
    }

    protected boolean canPasteData(Object[] objectArray, int n) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "canPasteData(Object[],int)", 2680).addDetail("data", objectArray)).addDetail("columnIndex", n)).log();
        }
        return this.columns[n].clazz.isAssignableFrom(objectArray[n].getClass());
    }

    @Nullable
    protected String getStringValueForEdit(@Nullable Object object, int n, int n2) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getStringValueForEdit(Object,int,int)", 5328).addDetail("value", object)).addDetail("row", n)).addDetail("col", n2)).log();
        }
        return Misc.toStringOrNull(object);
    }

    @Nullable
    protected String getStringValueForTextCopy(@Nullable Object object, int n, int n2) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getStringValueForTextCopy(Object,int,int)", 5340).addDetail("value", object)).addDetail("row", n)).addDetail("col", n2)).log();
        }
        return this.getStringValueForEdit(object, n, n2);
    }

    @Nullable
    public Object getEditedValueFromString(@Nullable String string, @Nullable Object object, int n, int n2, boolean bl) throws CancelEditException {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getEditedValueFromString(String,Object,int,int,boolean)", 5352).addDetail("string", string)).addDetail("valueBefore", object)).addDetail("row", n)).addDetail("col", n2)).addDetail("interactive", bl)).log();
        }
        return string;
    }

    public void fireUndoableMoveRowHappened(Table table, int n, int n2) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableMoveRowHappened(Table,int,int)", 8128).addDetail("table", table)).addDetail("row", n)).addDetail("target", n2)).log();
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableMoveRow(table, n, n2)));
    }

    public void fireUndoableDeleteRowHappened(Table table, int n, Object[] objectArray) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableDeleteRowHappened(Table,int,Object[])", 8140).addDetail("table", table)).addDetail("row", n)).addDetail("data", objectArray)).log();
        }
        ArrayList<Pair<Integer, Object[]>> arrayList = new ArrayList<Pair<Integer, Object[]>>();
        arrayList.add(new Pair<Integer, Object[]>(n, objectArray));
        this.fireUndoableDeleteRowsHappened(table, arrayList);
    }

    public void fireUndoableDeleteRowsHappened(Table table, ArrayList arrayList) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableDeleteRowsHappened(Table,ArrayList)", 8153).addDetail("table", table)).addDetail("data", arrayList)).log();
        }
        String[] stringArray = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            stringArray[i] = this.columns[i].id;
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableDeleteRows(table, arrayList, stringArray, false)));
    }

    public void fireUndoableInsertRowHappened(Table table, int n, Object[] objectArray) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableInsertRowHappened(Table,int,Object[])", 8169).addDetail("table", table)).addDetail("row", n)).addDetail("data", objectArray)).log();
        }
        ArrayList<Pair<Integer, Object[]>> arrayList = new ArrayList<Pair<Integer, Object[]>>();
        arrayList.add(new Pair<Integer, Object[]>(n, objectArray));
        this.fireUndoableInsertRowsHappened(table, arrayList);
    }

    public void fireUndoableInsertRowsHappened(Table table, ArrayList arrayList) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableInsertRowsHappened(Table,ArrayList)", 8182).addDetail("table", table)).addDetail("data", arrayList)).log();
        }
        String[] stringArray = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            stringArray[i] = this.columns[i].id;
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableDeleteRows(table, arrayList, stringArray, true)));
    }

    public void fireUndoableRowChangeHappened(Table table, int n, Object[] objectArray) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableRowChangeHappened(Table,int,Object[])", 8198).addDetail("table", table)).addDetail("row", n)).addDetail("data", objectArray)).log();
        }
        ArrayList<Pair<Integer, Object[]>> arrayList = new ArrayList<Pair<Integer, Object[]>>();
        arrayList.add(new Pair<Integer, Object[]>(n, objectArray));
        this.fireUndoableRowsChangeHappened(table, arrayList);
    }

    public void fireUndoableRowsChangeHappened(Table table, ArrayList<Pair<Integer, Object[]>> arrayList) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableRowsChangeHappened(Table,ArrayList<Pair<Integer, Object[]>>)", 8211).addDetail("table", table)).addDetail("data", arrayList)).log();
        }
        String[] stringArray = new String[this.columns.length];
        for (int i = 0; i < this.columns.length; ++i) {
            stringArray[i] = this.columns[i].id;
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableRowsChange(table, arrayList, stringArray)));
    }

    public void fireUndoableMoveColumnHappened(Table table, int n, int n2) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableMoveColumnHappened(Table,int,int)", 8227).addDetail("table", table)).addDetail("column", n)).addDetail("target", n2)).log();
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableMoveColumn(table, n, n2)));
    }

    public void fireUndoableDeleteColumnHappened(Table table, Object[] objectArray, boolean bl) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableDeleteColumnHappened(Table,Object[],boolean)", 8239).addDetail("table", table)).addDetail("data", objectArray)).addDetail("reverse", bl)).log();
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableDeleteColumn(table, objectArray, bl)));
    }

    public void fireUndoableColumnChangeHappened(Table table, String string, String string2) {
        if (TableOptionEdit.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireUndoableColumnChangeHappened(Table,String,String)", 8251).addDetail("table", table)).addDetail("id", string)).addDetail("title", string2)).log();
        }
        this.fireUndoableEditHappened(new UndoableEditEvent(this, new UndoableColumnChange(table, string, string2)));
    }

    static {
        forwardKeys = new HashSet();
        forwardKeys.add(KeyStroke.getKeyStroke(9, 0));
        forwardKeys.add(KeyStroke.getKeyStroke(9, 2));
        backwardKeys = new HashSet();
        backwardKeys.add(KeyStroke.getKeyStroke(9, 1));
        backwardKeys.add(KeyStroke.getKeyStroke(9, 3));
        columnTextSeparator = "\t";
    }

    public static class CancelEditException
    extends Exception {
        public CancelEditException() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "CancelEditException.CancelEditException()", 9409).log();
            }
        }
    }

    public class UndoableColumnChange
    extends AbstractUndoableEdit {
        private Table table;
        private String id;
        private String title;
        protected boolean canUndo;

        public UndoableColumnChange(Table table, String string, String string2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableColumnChange.UndoableColumnChange(Table,String,String)", 9279).addDetail("table", table)).addDetail("id", string)).addDetail("title", string2)).log();
            }
            this.table = table;
            this.id = string;
            this.title = string2;
            this.canUndo = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableColumnChange.undo()", 9300).log();
            }
            if (!this.canUndo) {
                throw new CannotUndoException();
            }
            this.swap();
            this.canUndo = false;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableColumnChange.redo()", 9319).log();
            }
            if (this.canUndo) {
                throw new CannotRedoException();
            }
            this.swap();
            this.canUndo = true;
        }

        @Override
        public boolean canUndo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableColumnChange.canUndo()", 9338).log();
            }
            return this.canUndo;
        }

        @Override
        public boolean canRedo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableColumnChange.canRedo()", 9352).log();
            }
            return !this.canUndo;
        }

        public void swap() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableColumnChange.swap()", 9367).log();
            }
            if (logger.level >= 8) {
                ((LevelAwareLogBuilder)logger.lvlBuild(8, "UndoableColumnChange.swap()", 9369).add("table", this.table)).log();
            }
            if (logger.level >= 8) {
                ((LevelAwareLogBuilder)logger.lvlBuild(8, "UndoableColumnChange.swap()", 9370).add("id", this.id)).log();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            int n = -1;
            for (int i = 0; i < TableOptionEdit.this.columns.length; ++i) {
                if (!TableOptionEdit.this.columns[i].id.equals(this.id)) continue;
                n = i;
                break;
            }
            if (n < 0) {
                if (logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "UndoableColumnChange.swap()", 9385).add("Couldn't find column")).log();
                }
                return;
            }
            String string = TableOptionEdit.this.columns[n].name;
            TableOptionEdit.this.columns[n].name = this.title;
            this.title = string;
            int n2 = this.table.convertColumnIndexToView(n);
            this.table.getColumnModel().getColumn(n2).setHeaderValue(TableOptionEdit.this.columns[n].name);
            this.table.getTableHeader().invalidate();
            this.table.getTableHeader().repaint();
            this.table.setColumnSelectionInterval(n2, n2);
            this.table.requestFocus();
        }
    }

    public class UndoableDeleteColumn
    extends AbstractUndoableEdit {
        private Table table;
        private Object[] data;
        protected boolean canUndo;
        protected boolean reverse;

        public UndoableDeleteColumn(Table table, Object[] objectArray, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableDeleteColumn.UndoableDeleteColumn(Table,Object[],boolean)", 9017).addDetail("table", table)).addDetail("data", objectArray)).addDetail("reverse", bl)).log();
            }
            this.table = table;
            this.data = objectArray;
            this.reverse = bl;
            this.canUndo = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteColumn.undo()", 9038).log();
            }
            if (!this.canUndo) {
                throw new CannotUndoException();
            }
            if (this.reverse) {
                this.doRedo();
            } else {
                this.doUndo();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteColumn.redo()", 9061).log();
            }
            if (this.canUndo) {
                throw new CannotRedoException();
            }
            if (this.reverse) {
                this.doUndo();
            } else {
                this.doRedo();
            }
        }

        @Override
        public boolean canUndo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteColumn.canUndo()", 9084).log();
            }
            return this.canUndo;
        }

        @Override
        public boolean canRedo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteColumn.canRedo()", 9098).log();
            }
            return !this.canUndo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doUndo() throws CannotUndoException {
            int n;
            int n2;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteColumn.doUndo()", 9115).log();
            }
            if (this.data.length != (n2 = this.table.getRowCount()) + 3) {
                throw new CannotUndoException();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            ConfigWrapper configWrapper = TableOptionEdit.this.wrapper == null ? ConfigWrapper.makeWrapper(this.table) : TableOptionEdit.this.wrapper;
            int n3 = this.table.getAnchorRow();
            int n4 = TableOptionEdit.this.columns.length;
            Column column = TableOptionEdit.this.createDefaultColumn(TableOptionEdit.this.colidx++);
            column.name = (String)this.data[n2 + 1];
            column.id = (String)this.data[n2 + 2];
            Column[] columnArray = TableOptionEdit.this.createColumnArray(n4 + 1);
            System.arraycopy(TableOptionEdit.this.columns, 0, columnArray, 0, n4);
            columnArray[n4] = column;
            TableOptionEdit.this.columns = columnArray;
            TableOptionEdit.this.getTableModel().addColumn(this.data[n2 + 1]);
            if (TableOptionEdit.this.columns.length > TableOptionEdit.this.autoResizeLimit) {
                this.table.setAutoResizeMode(0);
            }
            try {
                ++this.table.blockUndo;
                configWrapper.setConfigurableState((Properties)this.data[n2]);
            }
            finally {
                --this.table.blockUndo;
            }
            for (n = 0; n < n2; ++n) {
                TableOptionEdit.this.getTableModel().setValueAt(this.data[n], n, n4);
            }
            if (n3 >= 0 && n2 > 0) {
                this.table.setRowSelectionInterval(n3, n3);
            }
            n = this.table.convertColumnIndexToView(n4);
            this.table.setColumnSelectionInterval(n, n);
            this.table.requestFocus();
            this.canUndo = !this.canUndo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRedo() throws CannotRedoException {
            int n;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteColumn.doRedo()", 9174).log();
            }
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableDeleteColumn.doRedo()", 9177).add("")).dumpStack();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            int n2 = this.table.getAnchorRow();
            int n3 = TableOptionEdit.this.columns.length;
            ConfigWrapper configWrapper = TableOptionEdit.this.wrapper == null ? ConfigWrapper.makeWrapper(this.table) : TableOptionEdit.this.wrapper;
            int n4 = -1;
            for (n = 0; n < TableOptionEdit.this.columns.length; ++n) {
                if (!TableOptionEdit.this.columns[n].id.equals(this.data[this.data.length - 1])) continue;
                n4 = n;
                break;
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableDeleteColumn.doRedo()", 9198).add("modelIndex", n4)).log();
            }
            if (n4 < 0) {
                throw new CannotRedoException();
            }
            n = this.table.convertColumnIndexToView(n4);
            Column[] columnArray = TableOptionEdit.this.createColumnArray(n3 - 1);
            if (n4 > 0) {
                System.arraycopy(TableOptionEdit.this.columns, 0, columnArray, 0, n4);
            }
            if (n4 < n3 - 1) {
                System.arraycopy(TableOptionEdit.this.columns, n4 + 1, columnArray, n4, n3 - n4 - 1);
            }
            TableOptionEdit.this.columns = columnArray;
            Properties properties = configWrapper.getConfigurableState();
            TableOptionEdit.this.getTableModel().removeColumn(n4);
            if (TableOptionEdit.this.columns.length <= TableOptionEdit.this.autoResizeLimit) {
                this.table.setAutoResizeMode(2);
            }
            try {
                ++this.table.blockUndo;
                configWrapper.setConfigurableState(properties);
            }
            finally {
                --this.table.blockUndo;
            }
            if (this.table.getColumnCount() > 0) {
                if (n2 >= 0 && this.table.getRowCount() > 0) {
                    this.table.setRowSelectionInterval(n2, n2);
                }
                n = Math.min(n, this.table.getColumnCount() - 1);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableDeleteColumn.doRedo()", 9230).add("selcol", n)).log();
                }
                this.table.setColumnSelectionInterval(n, n);
            }
            this.table.requestFocus();
            this.canUndo = !this.canUndo;
        }
    }

    public class UndoableMoveColumn
    extends AbstractUndoableEdit {
        private Table table;
        private int column;
        private int target;
        protected boolean canUndo;

        public UndoableMoveColumn(Table table, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableMoveColumn.UndoableMoveColumn(Table,int,int)", 8866).addDetail("table", table)).addDetail("column", n)).addDetail("target", n2)).log();
            }
            this.table = table;
            this.column = n;
            this.target = n2;
            this.canUndo = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveColumn.undo()", 8887).log();
            }
            if (!this.canUndo) {
                throw new CannotUndoException();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            this.table.moveColumn(this.target, this.column);
            this.table.setColumnSelectionInterval(this.column, this.column);
            this.table.requestFocus();
            this.canUndo = false;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveColumn.redo()", 8913).log();
            }
            if (this.canUndo) {
                throw new CannotRedoException();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            this.table.moveColumn(this.column, this.target);
            this.table.setColumnSelectionInterval(this.target, this.target);
            this.table.requestFocus();
            this.canUndo = true;
        }

        @Override
        public boolean canUndo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveColumn.canUndo()", 8939).log();
            }
            return this.canUndo;
        }

        @Override
        public boolean canRedo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveColumn.canRedo()", 8953).log();
            }
            return !this.canUndo;
        }

        @Override
        public boolean addEdit(UndoableEdit undoableEdit) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableMoveColumn.addEdit(UndoableEdit)", 8960).addDetail("edit", undoableEdit)).log();
            }
            if (undoableEdit instanceof UndoableMoveColumn && ((UndoableMoveColumn)undoableEdit).table == this.table && this.target == ((UndoableMoveColumn)undoableEdit).column) {
                this.target = ((UndoableMoveColumn)undoableEdit).target;
                undoableEdit.die();
                return true;
            }
            return false;
        }

        @Override
        public boolean isSignificant() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveColumn.isSignificant()", 8973).log();
            }
            return this.column != this.target;
        }
    }

    public class UndoableRowsChange
    extends AbstractUndoableEdit {
        private final Table table;
        private ArrayList<Pair<Integer, Object[]>> data;
        private final String[] columnIds;
        protected boolean canUndo;

        public UndoableRowsChange(Table table, ArrayList<Pair<Integer, Object[]>> arrayList, String[] stringArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableRowsChange.UndoableRowsChange(Table,ArrayList<Pair<Integer, Object[]>>,String[])", 8675).addDetail("table", table)).addDetail("data", arrayList)).addDetail("columnIds", stringArray)).log();
            }
            this.table = table;
            this.data = arrayList;
            this.columnIds = stringArray;
            this.canUndo = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableRowsChange.undo()", 8696).log();
            }
            if (!this.canUndo) {
                throw new CannotUndoException();
            }
            this.swap();
            this.canUndo = false;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableRowsChange.redo()", 8715).log();
            }
            if (this.canUndo) {
                throw new CannotRedoException();
            }
            this.swap();
            this.canUndo = true;
        }

        @Override
        public boolean canUndo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableRowsChange.canUndo()", 8734).log();
            }
            return this.canUndo;
        }

        @Override
        public boolean canRedo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableRowsChange.canRedo()", 8748).log();
            }
            return !this.canUndo;
        }

        public void swap() {
            int n;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableRowsChange.swap()", 8763).log();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            int n2 = this.table.getAnchorColumn();
            int n3 = this.table.getAnchorRow();
            boolean bl = true;
            ArrayList<Pair<Integer, Object[]>> arrayList = new ArrayList<Pair<Integer, Object[]>>();
            for (n = this.data.size() - 1; n >= 0; --n) {
                Pair<Integer, Object[]> pair = this.data.get(n);
                int n4 = pair.getFirst();
                Object[] objectArray = pair.getSecond();
                if (objectArray.length != TableOptionEdit.this.columns.length || objectArray.length != this.columnIds.length) {
                    if (logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "UndoableRowsChange.swap()", 8782).add("Inconsistent undo information")).log();
                    }
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableRowsChange.swap()", 8783).add("data", objectArray)).log();
                    }
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableRowsChange.swap()", 8784).add("columns", TableOptionEdit.this.columns)).log();
                    }
                    if (logger.level < 9) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableRowsChange.swap()", 8785).add("columnIds", this.columnIds)).log();
                    continue;
                }
                Object[] objectArray2 = this.table.copyRow(n4);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableRowsChange.swap()", 8789).add("data", objectArray)).log();
                }
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableRowsChange.swap()", 8790).add("columnIds", this.columnIds)).log();
                }
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableRowsChange.swap()", 8791).add("tmp", objectArray2)).log();
                }
                block1: for (int i = 0; i < objectArray.length; ++i) {
                    for (int j = 0; j < TableOptionEdit.this.columns.length; ++j) {
                        if (!TableOptionEdit.this.columns[i].id.equals(this.columnIds[j])) continue;
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableRowsChange.swap()", 8795).add("k", i)).add("columns[k].id", TableOptionEdit.this.columns[i].id)).add("j", j)).add("data[j]", objectArray[j])).log();
                        }
                        TableOptionEdit.this.getTableModel().setValueAt(objectArray[j], n4, i);
                        continue block1;
                    }
                }
                arrayList.add(new Pair<Integer, Object[]>(n4, objectArray2));
                if (bl) {
                    this.table.setRowSelectionInterval(n4, n4);
                    bl = false;
                    continue;
                }
                this.table.addRowSelectionInterval(n4, n4);
            }
            this.data = arrayList;
            for (n = 0; n < TableOptionEdit.this.columns.length; ++n) {
                this.columnIds[n] = TableOptionEdit.this.columns[n].id;
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableRowsChange.swap()", 8816).add("columnIds", this.columnIds)).log();
            }
            this.table.setAnchorRow(n3);
            if (n2 >= 0 && n2 <= this.table.getColumnCount()) {
                this.table.setAnchorColumn(n2);
            }
            this.table.requestFocus();
        }
    }

    public class UndoableDeleteRows
    extends AbstractUndoableEdit {
        private Table table;
        private ArrayList data;
        private String[] columnIds;
        protected boolean canUndo;
        protected boolean reverse;

        public UndoableDeleteRows(Table table, ArrayList arrayList, String[] stringArray, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableDeleteRows.UndoableDeleteRows(Table,ArrayList,String[],boolean)", 8441).addDetail("table", table)).addDetail("data", arrayList)).addDetail("columnIds", stringArray)).addDetail("reverse", bl)).log();
            }
            this.table = table;
            this.data = arrayList;
            this.columnIds = stringArray;
            this.reverse = bl;
            this.canUndo = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteRows.undo()", 8464).log();
            }
            if (!this.canUndo) {
                throw new CannotUndoException();
            }
            if (this.reverse) {
                this.doRedo();
            } else {
                this.doUndo();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteRows.redo()", 8487).log();
            }
            if (this.canUndo) {
                throw new CannotRedoException();
            }
            if (this.reverse) {
                this.doUndo();
            } else {
                this.doRedo();
            }
        }

        @Override
        public boolean canUndo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteRows.canUndo()", 8510).log();
            }
            return this.canUndo;
        }

        @Override
        public boolean canRedo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteRows.canRedo()", 8524).log();
            }
            return !this.canUndo;
        }

        public void doUndo() throws CannotUndoException {
            int n;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteRows.doUndo()", 8541).log();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            boolean bl = true;
            for (n = this.data.size() - 1; n >= 0; --n) {
                Pair pair = (Pair)this.data.get(n);
                int n2 = (Integer)pair.getFirst();
                Object[] objectArray = (Object[])pair.getSecond();
                if (objectArray.length != TableOptionEdit.this.columns.length || objectArray.length != this.columnIds.length) {
                    if (logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "UndoableDeleteRows.doUndo()", 8557).add("Inconsistent undo information")).log();
                    }
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableDeleteRows.doUndo()", 8558).add("data", objectArray)).log();
                    }
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableDeleteRows.doUndo()", 8559).add("columns", TableOptionEdit.this.columns)).log();
                    }
                    if (logger.level < 9) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "UndoableDeleteRows.doUndo()", 8560).add("columnIds", this.columnIds)).log();
                    continue;
                }
                Object[] objectArray2 = new Object[objectArray.length];
                block1: for (int i = 0; i < this.columnIds.length; ++i) {
                    for (int j = 0; j < TableOptionEdit.this.columns.length; ++j) {
                        if (!this.columnIds[i].equals(TableOptionEdit.this.columns[j].id)) continue;
                        objectArray2[j] = objectArray[i];
                        continue block1;
                    }
                }
                TableOptionEdit.this.getTableModel().insertRow(n2, objectArray2);
                if (bl) {
                    this.table.setRowSelectionInterval(n2, n2);
                    bl = false;
                    continue;
                }
                this.table.addRowSelectionInterval(n2, n2);
            }
            n = this.table.getAnchorColumn();
            if (n < 0 && this.table.getColumnCount() > 0) {
                this.table.setColumnSelectionInterval(0, 0);
            }
            n = Math.max(0, n);
            this.table.requestFocus();
            this.canUndo = !this.canUndo;
        }

        public void doRedo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableDeleteRows.doRedo()", 8599).log();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            int n = -1;
            for (int i = 0; i < this.data.size(); ++i) {
                Pair pair = (Pair)this.data.get(i);
                n = (Integer)pair.getFirst();
                Model model = TableOptionEdit.this.getTableModel();
                if (model.getRowCount() <= n) continue;
                model.removeRow(n);
            }
            if (this.table.getRowCount() <= 0 || n < 0) {
                this.table.clearSelection();
            } else if (n < this.table.getRowCount()) {
                if (n == this.table.getRowCount()) {
                    this.table.setRowSelectionInterval(n - 1, n - 1);
                } else {
                    this.table.setRowSelectionInterval(n, n);
                }
            } else {
                this.table.clearSelection();
            }
            this.table.requestFocus();
            this.canUndo = !this.canUndo;
        }
    }

    public class UndoableMoveRow
    extends AbstractUndoableEdit {
        private Table table;
        private int row;
        private int target;
        protected boolean canUndo;

        public UndoableMoveRow(Table table, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "UndoableMoveRow.UndoableMoveRow(Table,int,int)", 8295).addDetail("table", table)).addDetail("row", n)).addDetail("target", n2)).log();
            }
            this.table = table;
            this.row = n;
            this.target = n2;
            this.canUndo = true;
        }

        @Override
        public void undo() throws CannotUndoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveRow.undo()", 8316).log();
            }
            if (!this.canUndo) {
                throw new CannotUndoException();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            int n = this.table.getAnchorColumn();
            TableOptionEdit.this.getTableModel().moveRow(this.target, this.target, this.row);
            this.table.setRowSelectionInterval(this.row, this.row);
            if (n >= 0 && n <= this.table.getColumnCount()) {
                this.table.setAnchorColumn(n);
            }
            this.table.requestFocus();
            this.canUndo = false;
        }

        @Override
        public void redo() throws CannotRedoException {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveRow.redo()", 8346).log();
            }
            if (this.canUndo) {
                throw new CannotRedoException();
            }
            if (this.table.isEditing() && this.table.getCellEditor() != null) {
                this.table.getCellEditor().cancelCellEditing();
            }
            int n = this.table.getAnchorColumn();
            TableOptionEdit.this.getTableModel().moveRow(this.row, this.row, this.target);
            this.table.setRowSelectionInterval(this.target, this.target);
            if (n >= 0 && n <= this.table.getColumnCount()) {
                this.table.setAnchorColumn(n);
            }
            this.table.requestFocus();
            this.canUndo = true;
        }

        @Override
        public boolean canUndo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveRow.canUndo()", 8376).log();
            }
            return this.canUndo;
        }

        @Override
        public boolean canRedo() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "UndoableMoveRow.canRedo()", 8390).log();
            }
            return !this.canUndo;
        }
    }

    public static class RowSelection
    extends StringSelection
    implements Transferable,
    ClipboardOwner {
        private static DataFlavor flavor = new DataFlavor(RowSelection.class, "qflib row selection");
        private Object[] data;

        public RowSelection(Object[][] objectArray, String string) {
            super(string);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RowSelection.RowSelection(Object[][],String)", 8041).addDetail("data", objectArray)).addDetail("fallback", string)).log();
            }
            this.data = objectArray;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws IOException, UnsupportedFlavorException {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RowSelection.getTransferData(DataFlavor)", 8062).addDetail("flavor", dataFlavor)).log();
            }
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RowSelection.getTransferData(DataFlavor)", 8065).add("[")).add(dataFlavor.getHumanPresentableName())).add(",mime=")).add(dataFlavor.getMimeType())).add("]")).log();
            }
            if (flavor.equals(dataFlavor)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "RowSelection.getTransferData(DataFlavor)", 8069).add("flavor is RowSelection.flavor")).log();
                }
                return this.data;
            }
            return super.getTransferData(dataFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RowSelection.getTransferDataFlavors()", 8085).log();
            }
            if (this.data == null) {
                return super.getTransferDataFlavors();
            }
            DataFlavor[] dataFlavorArray = super.getTransferDataFlavors();
            DataFlavor[] dataFlavorArray2 = new DataFlavor[dataFlavorArray.length + 1];
            System.arraycopy(dataFlavorArray, 0, dataFlavorArray2, 0, dataFlavorArray.length);
            dataFlavorArray2[dataFlavorArray.length] = flavor;
            return dataFlavorArray2;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RowSelection.isDataFlavorSupported(DataFlavor)", 8109).addDetail("flavor", dataFlavor)).log();
            }
            return this.data != null && flavor.equals(dataFlavor) || super.isDataFlavorSupported(dataFlavor);
        }
    }

    protected class ChoiceEditor
    extends Editor {
        private boolean isIntType;
        private Object value;

        public ChoiceEditor(boolean bl, Object[] objectArray) {
            super(new JComboBox<Object>(objectArray));
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceEditor.ChoiceEditor(boolean,Object[])", 7926).addDetail("isIntType", bl)).addDetail("values", objectArray)).log();
            }
            this.isIntType = bl;
            JComboBox jComboBox = (JComboBox)this.editorComponent;
            jComboBox.setName("ChoiceEditor-" + TableOptionEdit.this.option.getName());
            PopupMenuListener popupMenuListener = new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceEditor.ChoiceEditor(boolean,Object[]).PopupMenuListener.popupMenuCanceled(PopupMenuEvent)", 7935).addDetail("e", popupMenuEvent)).log();
                    }
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceEditor.ChoiceEditor(boolean,Object[]).PopupMenuListener.popupMenuWillBecomeInvisible(PopupMenuEvent)", 7938).addDetail("e", popupMenuEvent)).log();
                    }
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceEditor.ChoiceEditor(boolean,Object[]).PopupMenuListener.popupMenuWillBecomeVisible(PopupMenuEvent)", 7941).addDetail("e", popupMenuEvent)).log();
                    }
                }
            };
            Reflector.safeCall((Object)jComboBox, "addPopupMenuListener", PopupMenuListener.class, (Object)popupMenuListener);
        }

        @Override
        public boolean stopCellEditing() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ChoiceEditor.stopCellEditing()", 7960).log();
            }
            this.value = this.isIntType ? Integer.valueOf(((JComboBox)this.editorComponent).getSelectedIndex() + 1) : ((JComboBox)this.editorComponent).getSelectedItem();
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ChoiceEditor.getTableCellEditorComponent(JTable,Object,boolean,int,int)", 7985).addDetail("table", jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("row", n)).addDetail("column", n2)).log();
            }
            this.value = object;
            if (this.isIntType) {
                ((JComboBox)this.editorComponent).setSelectedIndex((Integer)object - 1);
            } else {
                ((JComboBox)this.editorComponent).setSelectedItem(object);
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ChoiceEditor.getCellEditorValue()", 8003).log();
            }
            return this.value;
        }
    }

    public class NumberEditor
    extends Editor {
        Class[] argTypes;
        Constructor constructor;
        Object value;

        public NumberEditor() {
            super(new JTextField(){

                @Override
                public boolean isManagingFocus() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "NumberEditor.NumberEditor().JTextField.isManagingFocus()", 7785).log();
                    }
                    return true;
                }
            });
            this.argTypes = new Class[]{String.class};
            if (logger.level >= 7) {
                logger.lvlBuild(7, "NumberEditor.NumberEditor()", 7781).log();
            }
            JTextField jTextField = (JTextField)this.editorComponent;
            if (Misc.OS_IS_MAC_OS_X && jTextField != null) {
                jTextField.setAutoscrolls(false);
            }
            jTextField.setName("NumberEditor-" + TableOptionEdit.this.option.getName());
            jTextField.setHorizontalAlignment(4);
            jTextField.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "NumberEditor.NumberEditor().ActionListener.actionPerformed(ActionEvent)", 7801).addDetail("e", actionEvent)).log();
                    }
                    NumberEditor.this.cancelCellEditing();
                }
            }, KeyStroke.getKeyStroke(27, 0), 0);
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl;
            block4: {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "NumberEditor.stopCellEditing()", 7818).log();
                }
                String string = (String)super.getCellEditorValue();
                bl = false;
                try {
                    this.value = "".equals(string) ? null : this.constructor.newInstance(string);
                    bl = this.column.option.checkValue(null, this.value);
                }
                catch (Exception exception) {
                    if (logger.level < 9) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "NumberEditor.stopCellEditing()", 7827).add("e", exception)).log();
                }
            }
            if (!bl) {
                ((JComponent)this.getComponent()).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), BorderFactory.createEmptyBorder(0, 1, 0, 1)));
                return false;
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "NumberEditor.getTableCellEditorComponent(JTable,Object,boolean,int,int)", 7854).addDetail("table", jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("row", n)).addDetail("column", n2)).log();
            }
            this.value = null;
            this.column = TableOptionEdit.this.columns[n2];
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("Table.focusCellHighlightBorder"), BorderFactory.createEmptyBorder(0, 1, 0, 1)));
            try {
                Class<Object> clazz = jTable.getColumnClass(n2);
                if (clazz == Object.class) {
                    clazz = String.class;
                }
                this.constructor = clazz.getConstructor(this.argTypes);
            }
            catch (Exception exception) {
                return null;
            }
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "NumberEditor.getCellEditorValue()", 7886).log();
            }
            return this.value;
        }
    }

    protected class ResizableMultiLineTextArea
    extends JTextArea {
        protected DocumentListener listener = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.DocumentListener.insertUpdate(DocumentEvent)", 7262).addDetail("e", documentEvent)).log();
                }
                ResizableMultiLineTextArea.this.updateBounds();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.DocumentListener.removeUpdate(DocumentEvent)", 7268).addDetail("e", documentEvent)).log();
                }
                ResizableMultiLineTextArea.this.updateBounds();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.DocumentListener.changedUpdate(DocumentEvent)", 7274).addDetail("e", documentEvent)).log();
                }
                ResizableMultiLineTextArea.this.updateBounds();
            }
        };

        protected ResizableMultiLineTextArea() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineTextArea.ResizableMultiLineTextArea()", 7251).log();
            }
        }

        @Override
        public boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.processKeyBinding(KeyStroke,KeyEvent,int,boolean)", 7291).addDetail("ks", keyStroke)).addDetail("e", keyEvent)).addDetail("condition", n)).addDetail("pressed", bl)).log();
            }
            return super.processKeyBinding(keyStroke, keyEvent, n, bl);
        }

        @Override
        public void setCaretPosition(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.setCaretPosition(int)", 7306).addDetail("position", n)).log();
            }
            String string = this.getText();
            int n2 = n;
            if (string == null || n2 > string.length()) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.setCaretPosition(int)", 7311).add("Text too short, set caret position to 0.")).log();
                }
                n2 = 0;
            }
            if (n2 < 0) {
                n2 = 0;
            }
            super.setCaretPosition(n2);
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }

        @Override
        public void addNotify() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineTextArea.addNotify()", 7335).log();
            }
            super.addNotify();
            this.getDocument().addDocumentListener(this.listener);
        }

        @Override
        public void removeNotify() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineTextArea.removeNotify()", 7345).log();
            }
            this.getDocument().removeDocumentListener(this.listener);
            super.removeNotify();
        }

        private void updateBounds() {
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.updateBounds()", 7357).add("Try to set correct bounds of multi-line textarea.")).log();
            }
            if (TableOptionEdit.this.table.isEditing()) {
                ResizableMultiLineScrollPane resizableMultiLineScrollPane = (ResizableMultiLineScrollPane)this.getParent().getParent();
                TableOptionEdit.this.table.updateMultiLineRowHeight(resizableMultiLineScrollPane, this, TableOptionEdit.this.table.getEditingRow(), TableOptionEdit.this.table.getEditingColumn());
            }
        }

        @Override
        public int getRowHeight() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineTextArea.getRowHeight()", 7376).log();
            }
            return super.getRowHeight();
        }

        public int getCurrentLine() {
            int n;
            block4: {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "ResizableMultiLineTextArea.getCurrentLine()", 7389).log();
                }
                n = -1;
                try {
                    int n2 = this.getCaretPosition();
                    n = this.getLineOfOffset(n2);
                }
                catch (BadLocationException badLocationException) {
                    if (logger.level < 1) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "ResizableMultiLineTextArea.getCurrentLine()", 7397).add("ex", badLocationException)).log();
                }
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.getCurrentLine()", 7400).add("current line is: ")).add("line", n)).log();
            }
            return n;
        }

        public void scrollUp() {
            block5: {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "ResizableMultiLineTextArea.scrollUp()", 7410).log();
                }
                try {
                    int n = this.getCaretPosition();
                    int n2 = this.getLineOfOffset(n);
                    int n3 = this.getLineStartOffset(n2);
                    int n4 = this.getLineStartOffset(n2 - 1);
                    int n5 = this.getLineEndOffset(n2 - 1);
                    int n6 = n4 + (n - n3);
                    if (n6 >= n5) {
                        n6 = n5 - 1;
                    }
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.scrollUp()", 7423).add("set new caret position to:")).add("newPos", n6)).log();
                    }
                    this.setCaretPosition(n6);
                }
                catch (BadLocationException badLocationException) {
                    if (logger.level < 1) break block5;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "ResizableMultiLineTextArea.scrollUp()", 7429).add("ex", badLocationException)).log();
                }
            }
        }

        public void scrollDown() {
            block7: {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "ResizableMultiLineTextArea.scrollDown()", 7439).log();
                }
                try {
                    int n = this.getCaretPosition();
                    int n2 = this.getLineOfOffset(n);
                    int n3 = this.getLineStartOffset(n2);
                    int n4 = this.getLineStartOffset(n2 + 1);
                    int n5 = this.getLineEndOffset(n2 + 1);
                    int n6 = n4 + (n - n3);
                    if (n6 >= n5) {
                        if (n2 + 2 < this.getLineCount()) {
                            int n7 = this.getLineStartOffset(n2 + 2);
                            n6 = n7 - 1;
                        } else {
                            n6 = n5;
                        }
                    }
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.scrollDown()", 7459).add("set new caret position to:")).add("newPos", n6)).log();
                    }
                    this.setCaretPosition(n6);
                }
                catch (BadLocationException badLocationException) {
                    if (logger.level < 1) break block7;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "ResizableMultiLineTextArea.scrollDown()", 7464).add("ex", badLocationException)).log();
                }
            }
        }

        public void insertEnter() {
            int n = this.getCaretPosition();
            this.insert("\n", n);
        }

        public int getLongestLineWidth() {
            if (!(this.getUI().getRootView(this).getView(0) instanceof TabExpander)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.getLongestLineWidth()", 7495).add("Text document isn't supported.")).log();
                }
                return -1;
            }
            int n = -1;
            String string = this.getText();
            for (int i = 0; i < this.getLineCount(); ++i) {
                int n2;
                String string2 = "";
                try {
                    string2 = string.substring(this.getLineStartOffset(i), this.getLineEndOffset(i));
                }
                catch (BadLocationException badLocationException) {
                    break;
                }
                if (Misc.emptyOrNull(string2) || (n2 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), this.getFontMetrics(this.getFont()), 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0)) <= n) continue;
                n = n2;
            }
            return n;
        }

        public int getClosestCharacterToPos(int n) {
            if (!(this.getUI().getRootView(this).getView(0) instanceof TabExpander)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.getClosestCharacterToPos(int)", 7541).add("Text document isn't supported.")).log();
                }
                return -1;
            }
            if (n < 0) {
                return 0;
            }
            String string = this.getText();
            String string2 = "";
            int n2 = 0;
            if (this.getLineCount() > 1) {
                n2 = 1;
            }
            try {
                string2 = string.substring(this.getLineStartOffset(0), this.getLineEndOffset(0));
            }
            catch (BadLocationException badLocationException) {
                return 0;
            }
            if (Misc.emptyOrNull(string2)) {
                return 0;
            }
            int n3 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), this.getFontMetrics(this.getFont()), 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
            if (n3 <= n) {
                return string2.length() - n2;
            }
            int n4 = 0;
            int n5 = 0;
            while (n5 < string2.length()) {
                String string3 = string2.substring(0, n5);
                int n6 = Utilities.getTabbedTextWidth(new Segment(string3.toCharArray(), 0, string3.length()), this.getFontMetrics(this.getFont()), 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                if (n6 > n) {
                    return n4;
                }
                n4 = n5++;
            }
            return string2.length() - n2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.paintComponent(Graphics)", 7601).addDetail("g", graphics)).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.paintComponent(Graphics)", 7603).add("Overridden for painting special characters, if configured.")).log();
            }
            super.paintComponent(graphics);
            this.paintBorder(graphics);
            if (!(this.getUI().getRootView(this).getView(0) instanceof TabExpander)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineTextArea.paintComponent(Graphics)", 7609).add("Text document isn't supported.")).log();
                }
                return;
            }
            String string = this.getText();
            if (string == null) {
                return;
            }
            if (TableOptionEdit.this.doShowWhitespaces() && (string.indexOf("\n") >= 0 || string.indexOf("\t") >= 0)) {
                Graphics graphics2 = graphics;
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                try {
                    Border border;
                    int n = this.getRowHeight();
                    int n2 = Utilities.getTabbedTextWidth(new Segment(new char[]{'\t'}, 0, 1), fontMetrics, 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                    for (int i = 0; i < this.getLineCount(); ++i) {
                        int n3;
                        String string2;
                        String string3 = "";
                        try {
                            string3 = string.substring(this.getLineStartOffset(i), this.getLineEndOffset(i));
                        }
                        catch (BadLocationException badLocationException) {
                            break;
                        }
                        if (Misc.emptyOrNull(string3)) continue;
                        String[] stringArray = null;
                        if (string3.endsWith("\t")) {
                            string3 = string3 + " ";
                        }
                        if ((stringArray = string3.split("\t")) != null) {
                            string2 = "";
                            for (n3 = 0; n3 < stringArray.length && (n3 != stringArray.length - 1 || Misc.emptyOrNull(stringArray[n3])); ++n3) {
                                string2 = string2 + stringArray[n3];
                                int n4 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), fontMetrics, 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                                string2 = string2 + "\t";
                                int n5 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), fontMetrics, 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                                int n6 = n5 - n4;
                                int n7 = n4 + n6 / 2;
                                if (n4 == -1) break;
                                if (TAB_ICON == null) continue;
                                if (TAB_ICON == null) break;
                                if (TAB_ICON.getIconWidth() > n6) continue;
                                TAB_ICON.paintIcon(this, graphics2, n7 + 1, n * i + this.getIconY(TAB_ICON, fontMetrics) - 1);
                            }
                        }
                        if (!string3.endsWith("\n")) continue;
                        string2 = string3.substring(0, string3.length() - 1);
                        n3 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), fontMetrics, 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                        if (n3 == -1) break;
                        if (LINEBREAK_ICON == null) continue;
                        LINEBREAK_ICON.paintIcon(this, graphics2, n3 + 1, n * i + this.getIconY(LINEBREAK_ICON, fontMetrics) - 1);
                    }
                    if ((border = this.getBorder()) != null) {
                        border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
                    }
                }
                finally {
                    if (graphics2 != null) {
                        graphics2.dispose();
                    }
                }
            }
        }

        int getIconY(Icon icon, FontMetrics fontMetrics) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.getIconY(Icon,FontMetrics)", 7736).addDetail("icon", icon)).addDetail("fontMetrics", fontMetrics)).log();
            }
            return 2 + fontMetrics.getMaxAscent() - (fontMetrics.getAscent() - 3) / 2 - icon.getIconHeight() / 2;
        }

        @Override
        public void setSize(Dimension dimension) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.setSize(Dimension)", 7745).addDetail("size", dimension)).log();
            }
            super.setSize(dimension);
        }

        @Override
        public void setSize(int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineTextArea.setSize(int,int)", 7750).addDetail("width", n)).addDetail("height", n2)).log();
            }
            super.setSize(n, n2);
        }
    }

    protected class ResizableMultiLineScrollPane
    extends JScrollPane {
        public ResizableMultiLineTextArea rmta;
        public int startCaretPosition = 0;

        public ResizableMultiLineScrollPane() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.ResizableMultiLineScrollPane()", 6935).log();
            }
            this.rmta = new ResizableMultiLineTextArea();
            this.rmta.setFont(UIManager.getFont("TextField.font"));
            this.setAutoscrolls(true);
            this.setHorizontalScrollBarPolicy(30);
            this.setVerticalScrollBarPolicy(20);
            this.setViewportView(this.rmta);
            this.setBorder(null);
            this.rmta.setMargin(new Insets(0, 2, 0, 2));
            this.rmta.setBorder(new BasicBorders.MarginBorder());
        }

        @Override
        public boolean isManagingFocus() {
            return true;
        }

        public void setText(String string) {
            this.rmta.setText(string);
        }

        public String getText() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.getText()", 6977).log();
            }
            return this.rmta.getText();
        }

        public JTextArea getTextComponent() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.getTextComponent()", 6988).log();
            }
            return this.rmta;
        }

        public int getTextLineCount() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.getTextLineCount()", 6999).log();
            }
            return this.rmta.getLineCount();
        }

        public int getAllowedLines() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.getAllowedLines()", 7010).log();
            }
            return TableOptionEdit.this.maxEditorRows;
        }

        public void setStartCaretPosition(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineScrollPane.setStartCaretPosition(int)", 7018).addDetail("caretPosition", n)).log();
            }
            this.startCaretPosition = n;
        }

        public int getStartCaretPosition() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.getStartCaretPosition()", 7026).log();
            }
            return this.startCaretPosition;
        }

        public void requestFocusAndFixCursor() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.requestFocusAndFixCursor()", 7037).log();
            }
            this.requestFocusInWindow();
            this.rmta.setCaretPosition(this.getStartCaretPosition());
            this.rmta.requestFocusInWindow();
        }

        public void bindKeystrokes() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.bindKeystrokes()", 7050).log();
            }
            this.rmta.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineScrollPane.bindKeystrokes().ActionListener.actionPerformed(ActionEvent)", 7056).addDetail("e", actionEvent)).log();
                    }
                    ResizableMultiLineScrollPane.this.rmta.insertEnter();
                }
            }, "shift+return", KeyOptionEdit.getKeyStrokeForResource("keystroke.edit2"), 0);
            this.rmta.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineScrollPane.bindKeystrokes().ActionListener.actionPerformed(ActionEvent)", 7066).addDetail("e", actionEvent)).log();
                    }
                    if ((n = ResizableMultiLineScrollPane.this.rmta.getCurrentLine()) == 0) {
                        if (ResizableMultiLineScrollPane.this.rmta.getLineCount() == 1) {
                            ResizableMultiLineScrollPane.this.setNextRow();
                        }
                    } else {
                        ResizableMultiLineScrollPane.this.rmta.scrollUp();
                    }
                }
            }, "cursorup", KeyStroke.getKeyStroke(38, 0), 0);
            this.rmta.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineScrollPane.bindKeystrokes().ActionListener.actionPerformed(ActionEvent)", 7085).addDetail("e", actionEvent)).log();
                    }
                    ResizableMultiLineScrollPane.this.setNextRow();
                }
            }, "alt_cursorup", KeyStroke.getKeyStroke(38, 8), 0);
            this.rmta.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n;
                    int n2;
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineScrollPane.bindKeystrokes().ActionListener.actionPerformed(ActionEvent)", 7097).addDetail("e", actionEvent)).log();
                    }
                    if ((n2 = ResizableMultiLineScrollPane.this.rmta.getCurrentLine()) == (n = ResizableMultiLineScrollPane.this.rmta.getLineCount()) - 1) {
                        if (n == 1) {
                            ResizableMultiLineScrollPane.this.setPrevRow();
                        }
                    } else {
                        ResizableMultiLineScrollPane.this.rmta.scrollDown();
                    }
                }
            }, "cursordown", KeyStroke.getKeyStroke(40, 0), 0);
            this.rmta.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineScrollPane.bindKeystrokes().ActionListener.actionPerformed(ActionEvent)", 7117).addDetail("e", actionEvent)).log();
                    }
                    ResizableMultiLineScrollPane.this.setPrevRow();
                }
            }, "alt_cursordown", KeyStroke.getKeyStroke(40, 8), 0);
            this.rmta.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineScrollPane.bindKeystrokes().ActionListener.actionPerformed(ActionEvent)", 7130).addDetail("e", actionEvent)).log();
                    }
                    int n = TableOptionEdit.this.table.getEditingRow();
                    int n2 = TableOptionEdit.this.table.getEditingColumn();
                    TableOptionEdit.this.table.getCellEditor().cancelCellEditing();
                    TableOptionEdit.this.table.getSelectionModel().setSelectionInterval(n, n);
                    TableOptionEdit.this.table.getSelectionModel().setAnchorSelectionIndex(n);
                    TableOptionEdit.this.table.getSelectionModel().setLeadSelectionIndex(n);
                    TableOptionEdit.this.table.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n2);
                    TableOptionEdit.this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
                    TableOptionEdit.this.table.requestFocusInWindow();
                }
            }, "escape", KeyStroke.getKeyStroke(27, 0), 0);
        }

        protected void setNextRow() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ResizableMultiLineScrollPane.setNextRow()", 7160).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineScrollPane.setNextRow()", 7162).add("Try to select next row in tableoption.")).log();
            }
            int n = TableOptionEdit.this.table.getEditingRow();
            int n2 = TableOptionEdit.this.table.getEditingColumn();
            if (TableOptionEdit.this.table.getCellEditor().stopCellEditing()) {
                int n3 = n - 1;
                if (n3 == -1) {
                    n3 = 0;
                }
                TableOptionEdit.this.table.getSelectionModel().setSelectionInterval(n3, n3);
                TableOptionEdit.this.table.getSelectionModel().setAnchorSelectionIndex(n3);
                TableOptionEdit.this.table.getSelectionModel().setLeadSelectionIndex(n3);
                TableOptionEdit.this.table.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n2);
                TableOptionEdit.this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
            }
            TableOptionEdit.this.table.requestFocusInWindow();
        }

        protected void setPrevRow() {
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "ResizableMultiLineScrollPane.setPrevRow()", 7197).add("Try to select previous row in tableoption.")).log();
            }
            int n = TableOptionEdit.this.table.getEditingRow();
            int n2 = TableOptionEdit.this.table.getEditingColumn();
            if (TableOptionEdit.this.table.getCellEditor().stopCellEditing()) {
                int n3 = n + 1;
                if (n3 == TableOptionEdit.this.table.getRowCount()) {
                    n3 = n;
                }
                TableOptionEdit.this.table.getSelectionModel().setSelectionInterval(n3, n3);
                TableOptionEdit.this.table.getSelectionModel().setAnchorSelectionIndex(n3);
                TableOptionEdit.this.table.getSelectionModel().setLeadSelectionIndex(n3);
                TableOptionEdit.this.table.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n2);
                TableOptionEdit.this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
            }
            TableOptionEdit.this.table.requestFocusInWindow();
        }

        @Override
        protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ResizableMultiLineScrollPane.processKeyBinding(KeyStroke,KeyEvent,int,boolean)", 7235).addDetail("ks", keyStroke)).addDetail("e", keyEvent)).addDetail("condition", n)).addDetail("pressed", bl)).log();
            }
            return this.rmta.processKeyBinding(keyStroke, keyEvent, n, bl);
        }
    }

    protected class MultiLineTableCellEditor
    extends StringEditor {
        protected boolean isInStopCellEditing;

        public MultiLineTableCellEditor() {
            this.isInStopCellEditing = false;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "MultiLineTableCellEditor.MultiLineTableCellEditor()", 6694).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "MultiLineTableCellEditor.MultiLineTableCellEditor()", 6696).add("Create.")).log();
            }
            this.clickCountToStart = 2;
            ResizableMultiLineScrollPane resizableMultiLineScrollPane = new ResizableMultiLineScrollPane();
            this.editorComponent = resizableMultiLineScrollPane;
            this.setupEditor();
            if (TableOptionEdit.this.canpopup) {
                PopupManager.instance().registerPopupHandler(PopupManager.instance(), ((ResizableMultiLineScrollPane)this.editorComponent).getTextComponent());
            }
            this.bindTabAndReturn();
            ((ResizableMultiLineScrollPane)this.editorComponent).bindKeystrokes();
            this.setupUndoForTextComponents(((ResizableMultiLineScrollPane)this.editorComponent).getTextComponent());
        }

        @Override
        public void requestFocusAndFixCursor() {
            ((ResizableMultiLineScrollPane)this.editorComponent).requestFocusAndFixCursor();
        }

        public ResizableMultiLineScrollPane getScrollPane() {
            return (ResizableMultiLineScrollPane)this.editorComponent;
        }

        @Override
        public JTextComponent getTextEditorComponent() {
            return ((ResizableMultiLineScrollPane)this.editorComponent).getTextComponent();
        }

        @Override
        public Object getCellEditorValue() {
            this.value = this.getTextEditorComponent().getText();
            return this.value;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "MultiLineTableCellEditor.shouldSelectCell(EventObject)", 6781).addDetail("anEvent", eventObject)).log();
            }
            try {
                char n;
                ++this.blockUndo;
                if (eventObject instanceof MouseEvent) {
                    char n2;
                    n = TableOptionEdit.this.table.getEditingColumn();
                    int n3 = 0;
                    for (n2 = '\u0000'; n2 < n; ++n2) {
                        n3 += TableOptionEdit.this.table.getColumnModel().getColumn(n2).getWidth();
                    }
                    n2 = ((MouseEvent)eventObject).getX();
                    int n4 = n2 - n3;
                    int n5 = ((ResizableMultiLineTextArea)this.getScrollPane().getTextComponent()).getClosestCharacterToPos(n4);
                    this.getTextEditorComponent().setCaretPosition(n5);
                }
                n = super.shouldSelectCell(eventObject);
                return n != '\u0000';
            }
            finally {
                --this.blockUndo;
            }
        }

        @Override
        protected Component getCustomTableCellRendererComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            String string = TableOptionEdit.this.getStringValueForEdit(object, n, n2);
            String string2 = string == null ? "" : string;
            Dimension dimension = ((ResizableMultiLineScrollPane)this.editorComponent).getSize();
            ((ResizableMultiLineScrollPane)this.editorComponent).setSize(dimension.width, ((Table)jTable).getDefaultRowHeight());
            ((ResizableMultiLineScrollPane)this.editorComponent).setText(string2);
            ((Table)jTable).updateMultiLineRowHeight((ResizableMultiLineScrollPane)this.editorComponent, ((ResizableMultiLineScrollPane)this.editorComponent).getTextComponent(), n, n2);
            return this.editorComponent;
        }

        @Override
        protected Object getCurrentCellEditorValue() {
            return this.getCellEditorValue();
        }

        @Override
        public JComponent getEditorComponentForBindings() {
            if (this.editorComponent instanceof JTextComponent) {
                return this.editorComponent;
            }
            return this.getTextEditorComponent();
        }

        @Override
        public void cancelCellEditing() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "MultiLineTableCellEditor.cancelCellEditing()", 6870).log();
            }
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "MultiLineTableCellEditor.cancelCellEditing()", 6872).add("")).dumpStack();
            }
            if (this.isInStopCellEditing) {
                return;
            }
            super.cancelCellEditing();
            TableOptionEdit.this.table.setRowHeightTime = 0L;
            TableOptionEdit.this.table.setRowHeight(TableOptionEdit.this.table.getDefaultRowHeight());
            TableOptionEdit.this.table.scrollToVisibleReset();
            TableOptionEdit.this.table.repaint();
        }

        @Override
        public boolean stopCellEditing() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "MultiLineTableCellEditor.stopCellEditing()", 6890).log();
            }
            try {
                this.isInStopCellEditing = true;
                boolean bl = super.stopCellEditing();
                TableOptionEdit.this.table.setRowHeightTime = 0L;
                TableOptionEdit.this.table.setRowHeight(TableOptionEdit.this.table.getDefaultRowHeight());
                TableOptionEdit.this.table.scrollToVisibleReset();
                TableOptionEdit.this.table.repaint();
                boolean bl2 = bl;
                return bl2;
            }
            finally {
                this.isInStopCellEditing = false;
            }
        }
    }

    public class StringEditor
    extends Editor {
        protected Object value;

        public StringEditor() {
            super(new JTextField(){

                @Override
                public boolean isManagingFocus() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "StringEditor.StringEditor().JTextField.isManagingFocus()", 6535).log();
                    }
                    return true;
                }
            });
            if (logger.level >= 7) {
                logger.lvlBuild(7, "StringEditor.StringEditor()", 6530).log();
            }
            this.setupEditor();
        }

        protected void setupEditor() {
            JTextComponent jTextComponent;
            if (this.editorComponent instanceof ResizableMultiLineScrollPane) {
                jTextComponent = ((ResizableMultiLineScrollPane)this.editorComponent).getTextComponent();
            } else {
                jTextComponent = (JTextComponent)this.editorComponent;
                jTextComponent.setMargin(new Insets(1, 2, 1, 2));
                jTextComponent.setBorder(new BasicBorders.MarginBorder());
            }
            if (Misc.OS_IS_MAC_OS_X && jTextComponent != null) {
                jTextComponent.setAutoscrolls(false);
            }
            jTextComponent.setName("StringEditor-" + TableOptionEdit.this.option.getName());
            jTextComponent.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StringEditor.this.cancelCellEditing();
                }
            }, KeyStroke.getKeyStroke(27, 0), 0);
        }

        protected Object getCurrentCellEditorValue() {
            return super.getCellEditorValue();
        }

        @Override
        public boolean stopCellEditing() {
            this.value = this.getCurrentCellEditorValue();
            if (!this.column.option.checkValue(null, "".equals(this.value) ? null : this.value)) {
                ((JComponent)this.getComponent()).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.red), BorderFactory.createEmptyBorder(0, 1, 0, 1)));
                return false;
            }
            if (super.stopCellEditing()) {
                TableOptionEdit.this.dehighlight();
                return true;
            }
            return false;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.value = null;
            this.column = TableOptionEdit.this.columns[n2];
            ((JComponent)this.getComponent()).setBorder(BorderFactory.createCompoundBorder(UIManager.getBorder("Table.focusCellHighlightBorder"), BorderFactory.createEmptyBorder(0, 1, 0, 1)));
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }

        public JTextComponent getTextEditorComponent() {
            return (JTextComponent)this.editorComponent;
        }
    }

    protected class BooleanEditor
    extends Editor {
        public BooleanEditor(JTable jTable) {
            super(new JCheckBox(){

                @Override
                public void updateUI() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "BooleanEditor.BooleanEditor(JTable).JCheckBox.updateUI()", 6489).log();
                    }
                    SwingUtil.cleanupKeyHandlers(this);
                    super.updateUI();
                }
            });
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "BooleanEditor.BooleanEditor(JTable)", 6485).addDetail("table", jTable)).log();
            }
            JCheckBox jCheckBox = (JCheckBox)this.editorComponent;
            jCheckBox.setName("BooleanEditor-" + TableOptionEdit.this.option.getName());
            if (jTable != null) {
                jCheckBox.setForeground(jTable.getForeground());
                jCheckBox.setBackground(jTable.getBackground());
            }
            jCheckBox.setHorizontalAlignment(0);
        }
    }

    protected class Editor
    extends DefaultCellEditor {
        protected Column column;
        protected ArrayList edits;
        protected boolean hasEdits;
        protected int blockUndo;
        protected long startEditTime;

        public Editor(JTextField jTextField) {
            super(jTextField);
            this.edits = new ArrayList();
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Editor.Editor(JTextField)", 6125).addDetail("com", jTextField)).log();
            }
            if (TableOptionEdit.this.canpopup) {
                PopupManager.instance().registerPopupHandler(PopupManager.instance(), jTextField);
            }
            this.bindTabAndReturn();
            this.setupUndoForTextComponents(jTextField);
        }

        public Editor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.edits = new ArrayList();
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Editor.Editor(JCheckBox)", 6144).addDetail("com", jCheckBox)).log();
            }
            this.bindTabAndReturn();
        }

        public Editor(JComboBox jComboBox) {
            super(jComboBox);
            this.edits = new ArrayList();
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Editor.Editor(JComboBox)", 6158).addDetail("com", jComboBox)).log();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Editor.getTableCellEditorComponent(JTable,Object,boolean,int,int)", 6182).addDetail("table", jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("row", n)).addDetail("column", n2)).log();
            }
            this.hasEdits = false;
            try {
                ++this.blockUndo;
                this.column = TableOptionEdit.this.columns[jTable.convertColumnIndexToModel(n2)];
                Component component = this.getCustomTableCellRendererComponent(jTable, object, bl, n, n2);
                return component;
            }
            finally {
                --this.blockUndo;
            }
        }

        @Override
        public boolean isCellEditable(EventObject eventObject) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Editor.isCellEditable(EventObject)", 6208).addDetail("anEvent", eventObject)).log();
            }
            if (eventObject == null) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Editor.isCellEditable(EventObject)", 6212).add("isCellEditable: ignore")).log();
                }
                return false;
            }
            if (eventObject instanceof KeyEvent && ((KeyEvent)eventObject).getKeyCode() == 27) {
                return false;
            }
            return super.isCellEditable(eventObject);
        }

        @Override
        public boolean shouldSelectCell(EventObject eventObject) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Editor.shouldSelectCell(EventObject)", 6234).addDetail("anEvent", eventObject)).log();
            }
            try {
                char c;
                ++this.blockUndo;
                if (eventObject instanceof KeyEvent) {
                    if (this.editorComponent instanceof JTextComponent) {
                        ((JTextComponent)this.editorComponent).setText(null);
                    } else if (this.editorComponent instanceof ResizableMultiLineScrollPane) {
                        c = ((KeyEvent)eventObject).getKeyChar();
                        ((ResizableMultiLineScrollPane)this.editorComponent).getTextComponent().setText(null);
                        ((ResizableMultiLineScrollPane)this.editorComponent).setStartCaretPosition(1);
                        ((ResizableMultiLineScrollPane)this.editorComponent).requestFocusAndFixCursor();
                        ((ResizableMultiLineScrollPane)this.editorComponent).setStartCaretPosition(0);
                    } else if (this.editorComponent instanceof JComboBox) {
                        ((JComboBox)this.editorComponent).showPopup();
                    }
                }
                c = super.shouldSelectCell(eventObject);
                return c != '\u0000';
            }
            finally {
                --this.blockUndo;
            }
        }

        @Override
        public boolean stopCellEditing() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Editor.stopCellEditing()", 6267).log();
            }
            for (int i = 0; i < this.edits.size(); ++i) {
                ((UndoableEdit)this.edits.get(i)).die();
            }
            this.edits.clear();
            if (this.hasEdits) {
                TableOptionEdit.this.fireUndoableEditHappened(new UndoableEditEvent(this, new OptionEdit.UndoContextSwitch(false)));
                this.hasEdits = false;
            }
            return super.stopCellEditing();
        }

        @Override
        public void cancelCellEditing() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Editor.cancelCellEditing()", 6286).log();
            }
            for (int i = 0; i < this.edits.size(); ++i) {
                ((UndoableEdit)this.edits.get(i)).die();
            }
            this.edits.clear();
            if (this.hasEdits) {
                TableOptionEdit.this.fireUndoableEditHappened(new UndoableEditEvent(this, new OptionEdit.UndoContextSwitch(false)));
                this.hasEdits = false;
            }
            super.cancelCellEditing();
        }

        public void requestFocusAndFixCursor() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Editor.requestFocusAndFixCursor()", 6307).log();
            }
            this.getEditorComponentForBindings().requestFocusInWindow();
        }

        public void insertChar(char c) {
            block5: {
                Component component;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "Editor.insertChar(char)", 6328).addDetail("c", c)).log();
                }
                if ((component = this.getComponent()) instanceof ResizableMultiLineScrollPane) {
                    component = ((ResizableMultiLineScrollPane)this.editorComponent).getTextComponent();
                }
                if (!Character.isISOControl(c) && component instanceof JTextComponent) {
                    JTextComponent jTextComponent = (JTextComponent)component;
                    try {
                        jTextComponent.getDocument().insertString(jTextComponent.getCaretPosition(), "" + c, null);
                    }
                    catch (Exception exception) {
                        if (logger.level < 9) break block5;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Editor.insertChar(char)", 6343).add("ex", exception)).log();
                    }
                }
            }
        }

        public JComponent getEditorComponentForBindings() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Editor.getEditorComponentForBindings()", 6358).log();
            }
            return this.editorComponent;
        }

        protected void bindTabAndReturn() {
            this.getEditorComponentForBindings().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TableOptionEdit.this.table.getEditingRow();
                    int n2 = TableOptionEdit.this.table.getEditingColumn();
                    if (Editor.this.stopCellEditing()) {
                        if (n2 < TableOptionEdit.this.table.getColumnCount() - 1) {
                            TableOptionEdit.this.table.getColumnModel().getSelectionModel().setSelectionInterval(n2 + 1, n2 + 1);
                        } else if (n < TableOptionEdit.this.table.getRowCount() - 1) {
                            TableOptionEdit.this.table.getSelectionModel().setSelectionInterval(n + 1, n + 1);
                            TableOptionEdit.this.table.getColumnModel().getSelectionModel().setSelectionInterval(0, 0);
                        }
                        TableOptionEdit.this.table.requestFocusInWindow();
                    }
                }
            }, "tab", KeyStroke.getKeyStroke(9, 0), 0);
            this.getEditorComponentForBindings().registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    int n = TableOptionEdit.this.table.getEditingRow();
                    int n2 = TableOptionEdit.this.table.getEditingColumn();
                    if (Editor.this.stopCellEditing()) {
                        int n3 = n + (n == TableOptionEdit.this.table.getRowCount() - 1 ? 0 : 1);
                        if (n3 <= TableOptionEdit.this.table.getRowCount() - 1) {
                            TableOptionEdit.this.table.getSelectionModel().setSelectionInterval(n3, n3);
                            TableOptionEdit.this.table.getSelectionModel().setAnchorSelectionIndex(n3);
                            TableOptionEdit.this.table.getSelectionModel().setLeadSelectionIndex(n3);
                            TableOptionEdit.this.table.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n2);
                            TableOptionEdit.this.table.getColumnModel().getSelectionModel().setLeadSelectionIndex(n2);
                        }
                        TableOptionEdit.this.table.requestFocusInWindow();
                    }
                }
            }, "return", KeyStroke.getKeyStroke(10, 0), 0);
        }

        protected void setupUndoForTextComponents(JTextComponent jTextComponent) {
            jTextComponent.getDocument().addUndoableEditListener(new UndoableEditListener(){

                @Override
                public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Editor.setupUndoForTextComponents(JTextComponent).UndoableEditListener.undoableEditHappened(UndoableEditEvent)", 6433).add("blockUndo > 0 ? \" - blocked\" : \"\"", Editor.this.blockUndo > 0 ? " - blocked" : "")).dumpStack();
                    }
                    if (Editor.this.blockUndo == 0) {
                        Editor.this.edits.add(undoableEditEvent.getEdit());
                        if (!Editor.this.hasEdits) {
                            Editor.this.hasEdits = true;
                            TableOptionEdit.this.fireUndoableEditHappened(new UndoableEditEvent(this, new OptionEdit.UndoContextSwitch(true)));
                        }
                        TableOptionEdit.this.fireUndoableEditHappened(undoableEditEvent);
                    }
                }
            });
        }

        protected Component getCustomTableCellRendererComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Editor.getCustomTableCellRendererComponent(JTable,Object,boolean,int,int)", 6456).addDetail("table", jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("row", n)).addDetail("column", n2)).log();
            }
            this.startEditTime = System.currentTimeMillis();
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    public class HeaderRenderer
    implements TableCellRenderer {
        public HeaderRenderer() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "HeaderRenderer.HeaderRenderer()", 6019).log();
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "HeaderRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 6039).addDetail("table", jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("hasFocus", bl2)).addDetail("row", n)).addDetail("column", n2)).log();
            }
            JTextField jTextField = null;
            if (((Table)jTable).isCellHighlighted(n, n2)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "HeaderRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 6047).add("Highlighted cell available")).log();
                }
                jTextField = (JTextField)((Table)jTable).getHighlightedCell(n, n2);
                if (object != null && !object.toString().equals(jTextField.getText())) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "HeaderRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 6051).add("Value of cell changed: ")).add(object)).add(" != ")).add(jTextField.getText())).add(". Discard highlight info")).log();
                    }
                    jTextField = null;
                }
            }
            if (jTextField == null) {
                jTextField = object != null ? new JTextField(object.toString()) : new JTextField("");
            }
            jTextField.setHorizontalAlignment(0);
            jTextField.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            JTableHeader jTableHeader = jTable.getTableHeader();
            jTextField.setForeground(jTableHeader.getForeground());
            jTextField.setBackground(jTableHeader.getBackground());
            jTextField.setFont(jTableHeader.getFont());
            jTextField.getAccessibleContext().setAccessibleName(jTextField.getText());
            return jTextField;
        }
    }

    private class ChoiceRenderer
    extends JPanel
    implements TableCellRenderer {
        private JComboBox cb;

        public ChoiceRenderer(Object[] objectArray) {
            this.setLayout(new BorderLayout());
            this.cb = new JComboBox<Object>(objectArray);
            this.add((Component)this.cb, "Center");
            this.setBorder(BorderFactory.createLineBorder(Color.black));
            this.cb.setBorder(null);
            this.setBorder(null);
            this.cb.setFont(UIManager.getFont("Table.font"));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                if (jTable.hasFocus()) {
                    this.cb.setBackground(jTable.getSelectionBackground());
                } else {
                    this.cb.setBackground(TableOptionEdit.this.getInactiveBackgroundColor());
                }
                this.cb.setForeground(jTable.getSelectionForeground());
            } else {
                this.cb.setForeground(jTable.getForeground());
                this.cb.setBackground(jTable.getBackground());
            }
            if (object instanceof Integer) {
                this.cb.setSelectedIndex((Integer)object - 1);
            } else {
                this.cb.setSelectedItem(object);
            }
            this.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : null);
            if (((Table)jTable).isCellHighlighted(n, n2)) {
                int n3;
                JTextField jTextField;
                block13: {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "ChoiceRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5982).add("Highlighted cell avaiable")).log();
                    }
                    jTextField = (JTextField)((Table)jTable).getHighlightedCell(n, n2);
                    n3 = -1;
                    try {
                        n3 = Integer.parseInt(jTextField.getText());
                    }
                    catch (Throwable throwable) {
                        if (logger.level < 3) break block13;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "ChoiceRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5988).add("ex", throwable)).log();
                    }
                }
                if (n3 > 0 && this.cb.getSelectedIndex() != n3 - 1) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "ChoiceRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5991).add("Value of cell changed: ")).add(object)).add(" != ")).add(jTextField.getText())).add(". Discard highlight info")).log();
                    }
                } else {
                    this.cb.setBackground(TableOptionEdit.this.getHighlightingColor());
                }
            }
            this.getAccessibleContext().setAccessibleName(this.cb.getSelectedItem().toString());
            return this;
        }
    }

    public class TextRenderer
    implements TableCellRenderer {
        private int textAlignment = 2;
        private RendererTextField textField = new RendererTextField("");

        public TextRenderer() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "TextRenderer.TextRenderer()", 5807).log();
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            boolean bl3;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "TextRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5829).addDetail("table", jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("hasFocus", bl2)).addDetail("row", n)).addDetail("column", n2)).log();
            }
            RendererTextField rendererTextField = this.textField;
            boolean bl4 = false;
            if (TableOptionEdit.this.doShowWhitespaces() && object != null) {
                String string = object.toString();
                int n3 = object.toString().indexOf("\n");
                if (n3 >= 0) {
                    string = object.toString().substring(0, n3);
                    string = string + "   ...";
                    bl4 = true;
                }
                object = string;
            }
            if (bl3 = ((Table)jTable).isCellHighlighted(n, n2)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "TextRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5850).add("Highlighted cell avaiable")).log();
                }
                rendererTextField = (RendererTextField)((Table)jTable).getHighlightedCell(n, n2);
                if (object != null && !object.toString().equals(rendererTextField.getText()) && logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "TextRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5855).add("Value of cell changed: ")).add(object)).add(" != ")).add(rendererTextField.getText())).add(". Discard highlight info")).log();
                }
            } else {
                rendererTextField.setText(object == null ? "" : object.toString());
            }
            rendererTextField.setContainsLinebreak(bl4);
            rendererTextField.setCaretPosition(0);
            rendererTextField.setAlignmentX(2.0f);
            rendererTextField.setHorizontalAlignment(this.getTextAlignment());
            rendererTextField.setFont(jTable.getFont());
            rendererTextField.setBorder(bl2 ? BorderFactory.createCompoundBorder(UIManager.getBorder("Table.focusCellHighlightBorder"), BorderFactory.createEmptyBorder(0, 1, 0, 1)) : new BasicBorders.MarginBorder());
            if (bl) {
                if (jTable.hasFocus()) {
                    if (!bl3) {
                        rendererTextField.setBackground(jTable.getSelectionBackground());
                    }
                } else if (!bl3) {
                    rendererTextField.setBackground(TableOptionEdit.this.getInactiveBackgroundColor());
                }
                rendererTextField.setForeground(jTable.getSelectionForeground());
            } else {
                rendererTextField.setForeground(jTable.getForeground());
                if (!bl3) {
                    rendererTextField.setBackground(jTable.getBackground());
                }
            }
            rendererTextField.getAccessibleContext().setAccessibleName(rendererTextField.getText());
            return rendererTextField;
        }

        @Generated
        public int getTextAlignment() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "TextRenderer.getTextAlignment()", 5795).log();
            }
            return this.textAlignment;
        }

        @Generated
        public TextRenderer setTextAlignment(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "TextRenderer.setTextAlignment(int)", 5796).addDetail("textAlignment", n)).log();
            }
            this.textAlignment = n;
            return this;
        }
    }

    private class RendererTextField
    extends JTextField {
        private String origText;
        private boolean containsLinebreak;
        public static final String RENDERER_STRING = "   ...";

        public RendererTextField(String string) {
            this(string, false);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RendererTextField.RendererTextField(String)", 5603).addDetail("text", string)).log();
            }
        }

        public RendererTextField(String string, boolean bl) {
            super(string);
            this.origText = null;
            this.containsLinebreak = false;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RendererTextField.RendererTextField(String,boolean)", 5611).addDetail("text", string)).addDetail("containsLinebreak", bl)).log();
            }
            this.origText = string;
            this.containsLinebreak = bl;
            this.setMargin(new Insets(1, 2, 1, 2));
            this.setBorder(new BasicBorders.MarginBorder());
        }

        public void setContainsLinebreak(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RendererTextField.setContainsLinebreak(boolean)", 5624).addDetail("containsLinebreak", bl)).log();
            }
            this.containsLinebreak = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paintComponent(Graphics graphics) {
            block19: {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "RendererTextField.paintComponent(Graphics)", 5637).addDetail("g", graphics)).log();
                }
                super.paintComponent(graphics);
                this.paintBorder(graphics);
                if (this.origText == null) {
                    return;
                }
                if (!(this.getUI().getRootView(this).getView(0) instanceof TabExpander)) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "RendererTextField.paintComponent(Graphics)", 5647).add("Text document isn't supported.")).log();
                    }
                    return;
                }
                if (TableOptionEdit.this.doShowWhitespaces() && (this.containsLinebreak || this.origText.indexOf("\t") >= 0)) {
                    Graphics graphics2 = graphics;
                    FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                    try {
                        String string = this.origText;
                        if (!string.equals(this.getText()) && logger.level >= 3) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "RendererTextField.paintComponent(Graphics)", 5658).add("origText", this.origText)).add("getText()", this.getText())).log();
                        }
                        int n = 0;
                        int n2 = this.getHeight();
                        if (this.containsLinebreak && string != null) {
                            n = Utilities.getTabbedTextWidth(new Segment(string.toCharArray(), 0, string.length()), fontMetrics, 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                            if (string.endsWith(RENDERER_STRING)) {
                                n -= Utilities.getTabbedTextWidth(new Segment(RENDERER_STRING.toCharArray(), 0, RENDERER_STRING.length()), fontMetrics, 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                            }
                            if (n <= 0) {
                                return;
                            }
                            if (LINEBREAK_ICON != null) {
                                LINEBREAK_ICON.paintIcon(this, graphics2, n + 2, this.getIconY(LINEBREAK_ICON, fontMetrics));
                            }
                        }
                        String[] stringArray = null;
                        if (string.endsWith("\t")) {
                            string = string + " ";
                        }
                        if ((stringArray = string.split("\t")) == null) break block19;
                        String string2 = "";
                        for (int i = 0; i < stringArray.length - 1; ++i) {
                            if (i == stringArray.length - 1 && !Misc.emptyOrNull(stringArray[i])) {
                                break;
                            }
                            string2 = string2 + stringArray[i];
                            int n3 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), fontMetrics, 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                            string2 = string2 + "\t";
                            int n4 = Utilities.getTabbedTextWidth(new Segment(string2.toCharArray(), 0, string2.length()), fontMetrics, 0, (TabExpander)((Object)this.getUI().getRootView(this).getView(0)), 0);
                            int n5 = n4 - n3;
                            int n6 = n3 + n5 / 2;
                            if (n3 == -1) {
                                break;
                            }
                            if (TAB_ICON == null || TAB_ICON.getIconWidth() > n5) continue;
                            TAB_ICON.paintIcon(this, graphics2, n6 + 1, this.getIconY(TAB_ICON, fontMetrics));
                        }
                    }
                    finally {
                        if (graphics2 != null) {
                            graphics2.dispose();
                        }
                    }
                }
            }
        }

        @Override
        public void setText(String string) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RendererTextField.setText(String)", 5745).addDetail("text", string)).log();
            }
            this.origText = string;
            super.setText(string);
        }

        int getIconY(Icon icon, FontMetrics fontMetrics) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RendererTextField.getIconY(Icon,FontMetrics)", 5754).addDetail("icon", icon)).addDetail("fontMetrics", fontMetrics)).log();
            }
            return 2 + fontMetrics.getMaxAscent() - (fontMetrics.getAscent() - 3) / 2 - icon.getIconHeight() / 2;
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RendererTextField.getAccessibleContext()", 5764).log();
            }
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleRendererTextField();
            }
            return this.accessibleContext;
        }

        protected class AccessibleRendererTextField
        extends JTextField.AccessibleJTextField {
            protected AccessibleRendererTextField() {
                super(RendererTextField.this);
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "RendererTextField.AccessibleRendererTextField.AccessibleRendererTextField()", 5771).log();
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "RendererTextField.AccessibleRendererTextField.getAccessibleRole()", 5773).log();
                }
                return AccessibleRole.PANEL;
            }
        }
    }

    public class BooleanRenderer
    extends JPanel
    implements TableCellRenderer {
        private JCheckBox cb;

        public BooleanRenderer() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "BooleanRenderer.BooleanRenderer()", 5504).log();
            }
            this.setLayout(new BorderLayout());
            this.cb = new JCheckBox(){

                @Override
                public void updateUI() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "BooleanRenderer.BooleanRenderer().JCheckBox.updateUI()", 5509).log();
                    }
                    SwingUtil.cleanupKeyHandlers(this);
                    super.updateUI();
                }
            };
            this.cb.setHorizontalAlignment(0);
            this.add((Component)this.cb, "Center");
            this.setBorder(BorderFactory.createLineBorder(Color.black));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "BooleanRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5536).addDetail("table", jTable)).addDetail("value", object)).addDetail("isSelected", bl)).addDetail("hasFocus", bl2)).addDetail("row", n)).addDetail("column", n2)).log();
            }
            if (bl) {
                if (jTable.hasFocus()) {
                    this.cb.setBackground(jTable.getSelectionBackground());
                } else {
                    this.cb.setBackground(TableOptionEdit.this.getInactiveBackgroundColor());
                }
                this.cb.setForeground(jTable.getSelectionForeground());
            } else {
                this.cb.setForeground(jTable.getForeground());
                this.cb.setBackground(jTable.getBackground());
            }
            this.cb.setSelected(object instanceof Boolean && (Boolean)object != false);
            this.setBorder(bl2 ? UIManager.getBorder("Table.focusCellHighlightBorder") : null);
            if (((Table)jTable).isCellHighlighted(n, n2)) {
                if (logger.level >= 8) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(8, "BooleanRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5559).add("Highlighted cell avaiable")).log();
                }
                Boolean bl3 = (Boolean)((Table)jTable).getHighlightedCell(n, n2);
                if (object != null && !object.toString().equals(bl3.toString())) {
                    if (logger.level >= 8) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "BooleanRenderer.getTableCellRendererComponent(JTable,Object,boolean,boolean,int,int)", 5563).add("Value of cell changed: ")).add(object)).add(" != ")).add(bl3.toString())).add(". Discard highlight info")).log();
                    }
                } else {
                    this.cb.setBackground(TableOptionEdit.this.getHighlightingColor());
                }
            }
            boolean bl4 = this.cb.isSelected();
            String string = Boolean.valueOf(bl4).toString();
            if ("de".equals(System.getProperty("user.language"))) {
                string = bl4 ? "wahr" : "falsch";
            }
            this.getAccessibleContext().setAccessibleName(string);
            return this;
        }
    }

    private class TableDoubleClickListener
    extends MouseAdapter {
        private TableDoubleClickListener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "TableDoubleClickListener.TableDoubleClickListener()", 5445).log();
            }
        }

        protected void maybeShowInsertionDialog(MouseEvent mouseEvent) {
            int n;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "TableDoubleClickListener.maybeShowInsertionDialog(MouseEvent)", 5456).addDetail("e", mouseEvent)).log();
            }
            int n2 = TableOptionEdit.this.table.getRowCount();
            int n3 = TableOptionEdit.this.table.getRowHeight() * n2;
            if (n3 < (n = mouseEvent.getY())) {
                TableOptionEdit.this.table.insertRow();
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "TableDoubleClickListener.mouseClicked(MouseEvent)", 5470).addDetail("e", mouseEvent)).log();
            }
            if (mouseEvent.getClickCount() == 2) {
                this.maybeShowInsertionDialog(mouseEvent);
            }
        }
    }

    private class TableFocusListener
    extends MouseAdapter
    implements FocusListener {
        private TableFocusListener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "TableFocusListener.TableFocusListener()", 5364).log();
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "TableFocusListener.focusGained(FocusEvent)", 5378).addDetail("e", focusEvent)).log();
            }
            if (TableOptionEdit.this.table.getRowCount() > 0 && TableOptionEdit.this.columns.length > 0) {
                if (TableOptionEdit.this.table.getSelectionModel().getMinSelectionIndex() < 0) {
                    TableOptionEdit.this.table.setRowSelectionInterval(0, 0);
                    TableOptionEdit.this.table.setColumnSelectionInterval(0, 0);
                } else {
                    TableOptionEdit.this.table.repaint();
                }
            } else {
                TableOptionEdit.this.scroll.setBorder(TableOptionEdit.this.focusBorder);
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "TableFocusListener.focusLost(FocusEvent)", 5404).addDetail("e", focusEvent)).log();
            }
            TableOptionEdit.this.scroll.setBorder(TableOptionEdit.this.defaultBorder);
            if (!TableOptionEdit.this.table.isEditing()) {
                TableOptionEdit.this.table.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "TableFocusListener.mousePressed(MouseEvent)", 5426).addDetail("e", mouseEvent)).log();
            }
            if (!mouseEvent.isPopupTrigger()) {
                TableOptionEdit.this.table.requestFocus();
            }
        }
    }

    public class Table
    extends JTable {
        protected ActionHandler handler;
        protected JButton editButton;
        protected JButton newButton;
        protected JButton removeButton;
        protected JButton upButton;
        protected JButton downButton;
        protected JButton addcolButton;
        protected JButton removecolButton;
        protected JButton editcolButton;
        protected Box buttonBox;
        protected OptionDialog editDialog;
        protected OptionSet rowOptions;
        protected OptionDialog editColumnDialog;
        protected OptionSet columnOptions;
        protected boolean modelChanged;
        protected boolean scrolledToVisible;
        protected int blockUndo;
        protected long setRowHeightTime;
        protected boolean inMousePress;

        public Table() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.Table()", 2799).log();
            }
            JTableHeader jTableHeader = new JTableHeader(this.getColumnModel()){

                @Override
                public boolean isFocusTraversable() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "Table.Table().JTableHeader.isFocusTraversable()", 2803).log();
                    }
                    return false;
                }

                @Override
                public void updateUI() {
                    if (logger.level >= 7) {
                        logger.lvlBuild(7, "Table.Table().JTableHeader.updateUI()", 2809).log();
                    }
                    SwingUtil.cleanupFocusListeners(this);
                    super.updateUI();
                    if (TableOptionEdit.this.clipboardButton != null) {
                        TableOptionEdit.this.initClipboardButton();
                        TableOptionEdit.this.updateClipboardButtonState();
                    }
                }
            };
            jTableHeader.setRequestFocusEnabled(false);
            this.setTableHeader(jTableHeader);
            this.setRowSelectionAllowed(TableOptionEdit.this.selectrow);
            this.setRowHeight(this.getDefaultRowHeight());
            TextRenderer textRenderer = new TextRenderer();
            this.setDefaultRenderer(String.class, textRenderer);
            this.setDefaultRenderer(Integer.class, textRenderer);
            this.setDefaultRenderer(Boolean.class, new BooleanRenderer());
            jTableHeader.setDefaultRenderer(new HeaderRenderer());
            this.setDefaultEditor(String.class, new StringEditor());
            this.setDefaultEditor(Integer.class, new NumberEditor());
            this.setDefaultEditor(Boolean.class, new BooleanEditor(this));
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.Table().ActionListener.actionPerformed(ActionEvent)", 2842).addDetail("e", actionEvent)).log();
                    }
                    int n = Table.this.getAnchorRow();
                    int n2 = Table.this.getAnchorColumn();
                    if (n2 >= 0 && n2 < Table.this.getColumnModel().getColumnCount() && (Table.this.getColumnClass(n2) == String.class || Table.this.getColumnClass(n2) == Integer.class) && Table.this.editCellAt(n, n2, actionEvent)) {
                        Component component;
                        Component component2 = component = Table.this.hasFocus() ? Table.this.getEditorComponent() : Table.this;
                        if (component != null) {
                            if (component instanceof ResizableMultiLineScrollPane) {
                                ((ResizableMultiLineScrollPane)component).setStartCaretPosition(((ResizableMultiLineScrollPane)component).getText().length());
                                ((ResizableMultiLineScrollPane)component).requestFocusAndFixCursor();
                                ((ResizableMultiLineScrollPane)component).setStartCaretPosition(0);
                            } else {
                                component.requestFocus();
                            }
                        }
                    }
                }
            }, "F2", KeyOptionEdit.getKeyStrokeForResource("keystroke.rename"), 1);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    int n;
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.Table().KeyAdapter.keyPressed(KeyEvent)", 2874).add("e", keyEvent)).log();
                    }
                    if ((n = Table.this.getAnchorRow()) < 0 || n >= Table.this.getRowCount()) {
                        return;
                    }
                    int n2 = Table.this.getAnchorColumn();
                    if (n2 < 0 || n2 >= TableOptionEdit.this.columns.length) {
                        return;
                    }
                    if (TableOptionEdit.this.columns[n2].directedit && keyEvent.getKeyChar() != '\u0000' && keyEvent.getKeyChar() != '\uffff' && !Character.isISOControl(keyEvent.getKeyChar()) && keyEvent.getKeyCode() != 10 && keyEvent.getKeyCode() != 27 && (keyEvent.getModifiers() & 0xE) == 0 && (Table.this.getColumnClass(n2) == String.class || Table.this.getColumnClass(n2) == Integer.class) && Table.this.editCellAt(n, n2, keyEvent)) {
                        Component component;
                        Component component2 = component = Table.this.hasFocus() ? Table.this.getEditorComponent() : Table.this;
                        if (component != null) {
                            component.requestFocus();
                        }
                        if (Table.this.getCellEditor() != null) {
                            Table.this.getCellEditor().shouldSelectCell(keyEvent);
                        }
                    } else if ("choice".equals(TableOptionEdit.this.columns[n2].type) && keyEvent.getKeyCode() == 40 && (keyEvent.getModifiers() & 0xE) == 8 && Table.this.editCellAt(n, n2, keyEvent)) {
                        Component component;
                        Component component3 = component = Table.this.hasFocus() ? Table.this.getEditorComponent() : Table.this;
                        if (component != null) {
                            component.requestFocus();
                        }
                        if (Table.this.getCellEditor() != null) {
                            Table.this.getCellEditor().shouldSelectCell(keyEvent);
                        }
                    }
                }
            });
            this.addInputMethodListener(new InputMethodListener(){

                @Override
                public void inputMethodTextChanged(InputMethodEvent inputMethodEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.Table().InputMethodListener.inputMethodTextChanged(InputMethodEvent)", 2927).addDetail("e", inputMethodEvent)).log();
                    }
                    if (Table.this.isEditing() && Table.this.getCellEditor() instanceof Editor) {
                        for (int i = 0; i < inputMethodEvent.getCommittedCharacterCount(); ++i) {
                            if (logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.Table().InputMethodListener.inputMethodTextChanged(InputMethodEvent)", 2933).add("Insert char.")).log();
                            }
                            ((Editor)Table.this.getCellEditor()).insertChar(inputMethodEvent.getText().next());
                        }
                    }
                }

                @Override
                public void caretPositionChanged(InputMethodEvent inputMethodEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.Table().InputMethodListener.caretPositionChanged(InputMethodEvent)", 2942).addDetail("e", inputMethodEvent)).log();
                    }
                }
            });
            this.registerKeyboardAction(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (logger.level >= 7) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.Table().ActionListener.actionPerformed(ActionEvent)", 2951).addDetail("e", actionEvent)).log();
                    }
                    int n = Table.this.getAnchorRow();
                    int n2 = Table.this.getAnchorColumn();
                    if (n2 >= 0 && n2 < Table.this.getColumnModel().getColumnCount() && Table.this.getColumnClass(n2) == Boolean.class && Table.this.editCellAt(n, n2, actionEvent)) {
                        JCheckBox jCheckBox;
                        BooleanEditor booleanEditor = (BooleanEditor)Table.this.getCellEditor();
                        jCheckBox.setSelected(!(jCheckBox = (JCheckBox)booleanEditor.getComponent()).isSelected());
                        booleanEditor.stopCellEditing();
                    }
                }
            }, "space", KeyStroke.getKeyStroke(32, 0), 1);
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0));
            this.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            Object object = Reflector.safeCall((Object)this, "getInputMap", Integer.TYPE, (Object)1);
            if (object != null) {
                Reflector.safeCall(object, "put", new Class[]{KeyStroke.class, Object.class}, new Object[]{KeyStroke.getKeyStroke(27, 0), "dummy"});
                Reflector.safeCall(object, "put", new Class[]{KeyStroke.class, Object.class}, new Object[]{KeyStroke.getKeyStroke(10, 0), "dummy"});
            }
            Reflector.safeCall((Object)this, "setFocusTraversalKeys", new Class[]{Integer.TYPE, Set.class}, new Object[]{0, forwardKeys});
            Reflector.safeCall((Object)this, "setFocusTraversalKeys", new Class[]{Integer.TYPE, Set.class}, new Object[]{1, backwardKeys});
            this.handler = new ActionHandler();
            if (TableOptionEdit.this.canedit) {
                this.registerKeyboardAction(this.handler, "edit", KeyOptionEdit.getKeyStrokeForResource("keystroke.edit2"), 1);
                this.registerKeyboardAction(this.handler, "edit", KeyOptionEdit.getKeyStrokeForResource("keystroke.edit"), 1);
            }
            if (TableOptionEdit.this.caninsert) {
                this.registerKeyboardAction(this.handler, "insert", KeyOptionEdit.getKeyStrokeForResource("keystroke.insert"), 1);
            }
            if (TableOptionEdit.this.canremove) {
                this.registerKeyboardAction(this.handler, "remove", KeyOptionEdit.getKeyStrokeForResource("keystroke.remove"), 1);
            }
            if (TableOptionEdit.this.canmove) {
                if (TableOptionEdit.this.multirow) {
                    this.registerKeyboardAction(this.handler, "up", KeyStroke.getKeyStroke(38, 3), 1);
                    this.registerKeyboardAction(this.handler, "down", KeyStroke.getKeyStroke(40, 3), 1);
                } else {
                    this.registerKeyboardAction(this.handler, "up", KeyStroke.getKeyStroke(38, 1), 1);
                    this.registerKeyboardAction(this.handler, "down", KeyStroke.getKeyStroke(40, 1), 1);
                }
            }
            if (TableOptionEdit.this.multirow) {
                this.registerKeyboardAction(this.handler, "ctrl-up", KeyStroke.getKeyStroke(38, 2), 1);
                this.registerKeyboardAction(this.handler, "ctrl-down", KeyStroke.getKeyStroke(40, 2), 1);
                this.registerKeyboardAction(this.handler, "ctrl-left", KeyStroke.getKeyStroke(37, 2), 1);
                this.registerKeyboardAction(this.handler, "ctrl-right", KeyStroke.getKeyStroke(39, 2), 1);
                this.registerKeyboardAction(this.handler, "toggle", KeyStroke.getKeyStroke(32, 2), 1);
            }
            if (TableOptionEdit.this.cutpaste) {
                KeyStroke keyStroke;
                KeyStroke keyStroke2;
                KeyStroke keyStroke3 = KeyOptionEdit.getKeyStrokeForResource("popup.cut");
                if (keyStroke3 != null) {
                    this.registerKeyboardAction(this.handler, "cut", keyStroke3, 1);
                }
                if ((keyStroke2 = KeyOptionEdit.getKeyStrokeForResource("popup.copy")) != null) {
                    this.registerKeyboardAction(this.handler, "copy", keyStroke2, 1);
                }
                if ((keyStroke = KeyOptionEdit.getKeyStrokeForResource("popup.paste")) != null) {
                    this.registerKeyboardAction(this.handler, "paste", keyStroke, 1);
                }
            }
            if (TableOptionEdit.this.getBoolean("autosize", true) || TableOptionEdit.this.caneditcolumn) {
                this.getTableHeader().addMouseListener(new HeaderListener());
            }
            this.setAnchorColumn(0);
        }

        public Component getButtons() {
            if (this.buttonBox == null) {
                this.buttonBox = Box.createHorizontalBox();
                if (TableOptionEdit.this.caneditcolumn) {
                    this.addcolButton = new ImageButton();
                    this.addcolButton.setName("AddColumnButton-" + TableOptionEdit.this.option.getName());
                    this.addcolButton.setRequestFocusEnabled(false);
                    this.addcolButton.setMargin(new Insets(0, 0, 0, 0));
                    this.addcolButton.setIcon(UIManager.getIcon("TableOptionEdit.colAddIcon"));
                    this.addcolButton.setToolTipText(Option.getResources().getString("option.table.column.add.tooltip", null));
                    this.addcolButton.setActionCommand("addcolumn");
                    this.addcolButton.addActionListener(this.handler);
                    this.addcolButton.addMouseListener(TableOptionEdit.this.tableFocusListener);
                    this.buttonBox.add(this.addcolButton);
                    this.editcolButton = new ImageButton();
                    this.editcolButton.setName("EditColumnButton-" + TableOptionEdit.this.option.getName());
                    this.editcolButton.setRequestFocusEnabled(false);
                    this.editcolButton.setMargin(new Insets(0, 0, 0, 0));
                    this.editcolButton.setIcon(UIManager.getIcon("TableOptionEdit.colEditIcon"));
                    this.editcolButton.setToolTipText(Option.getResources().getString("option.table.column.edit.tooltip", null));
                    this.editcolButton.setActionCommand("editcolumn");
                    this.editcolButton.addActionListener(this.handler);
                    this.editcolButton.addMouseListener(TableOptionEdit.this.tableFocusListener);
                    this.buttonBox.add(this.editcolButton);
                    this.removecolButton = new ImageButton();
                    this.removecolButton.setName("RemoveColumnButton-" + TableOptionEdit.this.option.getName());
                    this.removecolButton.setRequestFocusEnabled(false);
                    this.removecolButton.setMargin(new Insets(0, 0, 0, 0));
                    this.removecolButton.setIcon(UIManager.getIcon("TableOptionEdit.colRemoveIcon"));
                    this.removecolButton.setToolTipText(Option.getResources().getString("option.table.column.remove.tooltip", null));
                    this.removecolButton.setActionCommand("removecolumn");
                    this.removecolButton.addActionListener(this.handler);
                    this.removecolButton.addMouseListener(TableOptionEdit.this.tableFocusListener);
                    this.buttonBox.add(this.removecolButton);
                    this.buttonBox.add(Box.createHorizontalStrut(5));
                }
                if (TableOptionEdit.this.caninsert) {
                    this.newButton = new ImageButton();
                    this.newButton.setName("NewButton-" + TableOptionEdit.this.option.getName());
                    this.newButton.setRequestFocusEnabled(false);
                    this.newButton.setMargin(new Insets(0, 0, 0, 0));
                    this.newButton.setIcon(UIManager.getIcon("TableOptionEdit.rowNewIcon"));
                    this.newButton.setToolTipText(Option.getResources().getString("option.table.row.new.tooltip", null));
                    this.newButton.setActionCommand("insert");
                    this.newButton.addActionListener(this.handler);
                    this.newButton.addMouseListener(TableOptionEdit.this.tableFocusListener);
                    this.buttonBox.add(this.newButton);
                }
                if (TableOptionEdit.this.canedit) {
                    this.editButton = new ImageButton();
                    this.editButton.setName("EditButton-" + TableOptionEdit.this.option.getName());
                    this.editButton.setRequestFocusEnabled(false);
                    this.editButton.setMargin(new Insets(0, 0, 0, 0));
                    this.editButton.setIcon(UIManager.getIcon("TableOptionEdit.rowEditIcon"));
                    this.editButton.setToolTipText(Option.getResources().getString("option.table.row.edit.tooltip", null));
                    this.editButton.setActionCommand("edit");
                    this.editButton.addActionListener(this.handler);
                    this.editButton.addMouseListener(TableOptionEdit.this.tableFocusListener);
                    this.buttonBox.add(this.editButton);
                }
                if (TableOptionEdit.this.canremove) {
                    this.removeButton = new ImageButton();
                    this.removeButton.setName("RemoveButton-" + TableOptionEdit.this.option.getName());
                    this.removeButton.setRequestFocusEnabled(false);
                    this.removeButton.setMargin(new Insets(0, 0, 0, 0));
                    this.removeButton.setIcon(UIManager.getIcon("TableOptionEdit.rowRemoveIcon"));
                    this.removeButton.setToolTipText(Option.getResources().getString("option.table.row.remove.tooltip", null));
                    this.removeButton.setActionCommand("remove");
                    this.removeButton.addActionListener(this.handler);
                    this.removeButton.addMouseListener(TableOptionEdit.this.tableFocusListener);
                    this.buttonBox.add(this.removeButton);
                }
                if (TableOptionEdit.this.canmove) {
                    if (TableOptionEdit.this.caneditcolumn || TableOptionEdit.this.caninsert || TableOptionEdit.this.canedit || TableOptionEdit.this.canremove) {
                        this.buttonBox.add(Box.createHorizontalStrut(5));
                    }
                    this.upButton = new ImageButton();
                    this.upButton.setName("UpButton-" + TableOptionEdit.this.option.getName());
                    this.upButton.setRequestFocusEnabled(false);
                    this.upButton.setMargin(new Insets(0, 0, 0, 0));
                    this.upButton.setIcon(UIManager.getIcon("TableOptionEdit.rowUpIcon"));
                    this.upButton.setToolTipText(Option.getResources().getString(TableOptionEdit.this.multirow ? "option.table.row.upmulti.tooltip" : "option.table.row.up.tooltip", null));
                    this.upButton.setActionCommand("up");
                    this.upButton.addActionListener(this.handler);
                    this.upButton.addMouseListener(TableOptionEdit.this.tableFocusListener);
                    this.buttonBox.add(this.upButton);
                    this.downButton = new ImageButton();
                    this.downButton.setName("DownButton-" + TableOptionEdit.this.option.getName());
                    this.downButton.setRequestFocusEnabled(false);
                    this.downButton.setMargin(new Insets(0, 0, 0, 0));
                    this.downButton.setIcon(UIManager.getIcon("TableOptionEdit.rowDownIcon"));
                    this.downButton.setToolTipText(Option.getResources().getString(TableOptionEdit.this.multirow ? "option.table.row.downmulti.tooltip" : "option.table.row.down.tooltip", null));
                    this.downButton.setActionCommand("down");
                    this.downButton.addActionListener(this.handler);
                    this.downButton.addMouseListener(TableOptionEdit.this.tableFocusListener);
                    this.buttonBox.add(this.downButton);
                }
            }
            return this.buttonBox;
        }

        public void updateButtons() {
            if (this.buttonBox != null) {
                if (TableOptionEdit.this.caneditcolumn) {
                    this.addcolButton.setIcon(UIManager.getIcon("TableOptionEdit.colAddIcon"));
                    this.editcolButton.setIcon(UIManager.getIcon("TableOptionEdit.colEditIcon"));
                    this.removecolButton.setIcon(UIManager.getIcon("TableOptionEdit.colRemoveIcon"));
                }
                if (TableOptionEdit.this.caninsert) {
                    this.newButton.setIcon(UIManager.getIcon("TableOptionEdit.rowNewIcon"));
                }
                if (TableOptionEdit.this.canedit) {
                    this.editButton.setIcon(UIManager.getIcon("TableOptionEdit.rowEditIcon"));
                }
                if (TableOptionEdit.this.canremove) {
                    this.removeButton.setIcon(UIManager.getIcon("TableOptionEdit.rowRemoveIcon"));
                }
                if (TableOptionEdit.this.canmove) {
                    this.upButton.setIcon(UIManager.getIcon("TableOptionEdit.rowUpIcon"));
                    this.downButton.setIcon(UIManager.getIcon("TableOptionEdit.rowDownIcon"));
                }
            }
        }

        protected void moveUp() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.moveUp()", 3286).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            int n = this.getAnchorRow();
            if (n > 0) {
                if (!this.editingStopped()) {
                    return;
                }
                int n2 = this.getAnchorColumn();
                if (n2 < 0) {
                    n2 = 0;
                }
                TableOptionEdit.this.getTableModel().moveRow(n, n, n - 1);
                this.setRowSelectionInterval(n - 1, n - 1);
                this.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
                TableOptionEdit.this.fireUndoableMoveRowHappened(this, n, n - 1);
            }
        }

        protected boolean editingStopped() {
            boolean bl;
            if (this.isEditing() && this.getCellEditor() != null && !(bl = this.getCellEditor().stopCellEditing())) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editingStopped()", 3328).add("Cell editing stopped, but validation error, interrupt operation.")).log();
                }
                return false;
            }
            return true;
        }

        protected void moveDown() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.moveDown()", 3342).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            int n = this.getAnchorRow();
            if (n >= 0 && n < this.getRowCount() - 1) {
                if (!this.editingStopped()) {
                    return;
                }
                int n2 = this.getAnchorColumn();
                if (n2 < 0) {
                    n2 = 0;
                }
                TableOptionEdit.this.getTableModel().moveRow(n, n, n + 1);
                this.setRowSelectionInterval(n + 1, n + 1);
                this.getColumnModel().getSelectionModel().setSelectionInterval(n2, n2);
                TableOptionEdit.this.fireUndoableMoveRowHappened(this, n, n + 1);
            }
        }

        protected void insertRow() {
            Object[] objectArray;
            int n;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.insertRow()", 3374).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            if (this.getColumnCount() == 0) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.insertRow()", 3380).add("No columns")).log();
                }
                return;
            }
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
            int n2 = Math.min(this.getRowCount(), this.getAnchorRow() + 1);
            if (TableOptionEdit.this.canedit && !TableOptionEdit.this.directinsert) {
                this.initDialog(-1);
                n = this.editDialog.doModal(SwingUtilities.windowForComponent(this), true);
                SwingUtil.focusLater(this);
                if (n != 0) {
                    return;
                }
                objectArray = new Object[TableOptionEdit.this.columns.length];
                this.dialogConfirmed(n2, true);
                for (int i = 0; i < TableOptionEdit.this.columns.length; ++i) {
                    Object object;
                    block14: {
                        object = this.rowOptions.getValue(TableOptionEdit.this.option.getName() + ".column." + TableOptionEdit.this.columns[i].id, null);
                        try {
                            if (object instanceof String) {
                                object = TableOptionEdit.this.getEditedValueFromString((String)object, null, n2, i, true);
                            }
                        }
                        catch (CancelEditException cancelEditException) {
                            if (logger.level < 9) break block14;
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.insertRow()", 3410).add("Conversion of edited value cancelled")).log();
                        }
                    }
                    objectArray[i] = object;
                }
            } else {
                objectArray = new Object[TableOptionEdit.this.columns.length];
                for (n = 0; n < TableOptionEdit.this.columns.length; ++n) {
                    objectArray[n] = TableOptionEdit.this.columns[n].dflt;
                }
                SwingUtil.focusLater(this);
            }
            TableOptionEdit.this.getTableModel().insertRow(n2, objectArray);
            this.setRowSelectionInterval(n2, n2);
            this.setAnchorRow(n2);
            n = this.getAnchorColumn();
            if (n < 0 && this.getColumnCount() > 0) {
                this.setColumnSelectionInterval(0, 0);
            }
            n = Math.max(0, n);
            this.scrollRectToVisible(this.getCellRect(n2, n, true));
            TableOptionEdit.this.fireUndoableInsertRowHappened(this, n2, objectArray);
        }

        protected void editRow() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.editRow()", 3441).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            int n = this.getAnchorRow();
            if (n >= 0 && n < this.getRowCount()) {
                if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                    this.getCellEditor().cancelCellEditing();
                }
                this.initDialog(n);
                if (this.editDialog.doModal(SwingUtilities.windowForComponent(this), true) == 0) {
                    Object[] objectArray = this.copyRow(n);
                    this.dialogConfirmed(n, false);
                    for (int i = 0; i < TableOptionEdit.this.columns.length; ++i) {
                        try {
                            Object object = this.rowOptions.getValue(TableOptionEdit.this.option.getName() + ".column." + TableOptionEdit.this.columns[i].id, null);
                            if (object instanceof String) {
                                object = TableOptionEdit.this.getEditedValueFromString((String)object, TableOptionEdit.this.getTableModel().getValueAt(n, i), n, i, true);
                            }
                            TableOptionEdit.this.getTableModel().setValueAt(object, n, i);
                            continue;
                        }
                        catch (CancelEditException cancelEditException) {
                            if (logger.level < 9) continue;
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editRow()", 3469).add("Conversion of edited value cancelled")).log();
                        }
                    }
                    TableOptionEdit.this.fireUndoableRowChangeHappened(this, n, objectArray);
                }
                SwingUtil.focusLater(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void insertColumn(int n, String string) {
            Object[] objectArray;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.insertColumn(int,String)", 3487).addDetail("idx", n)).addDetail("title", string)).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
            int n2 = this.getAnchorRow();
            int n3 = TableOptionEdit.this.columns.length;
            if (n < 0 || n > n3) {
                n = n3;
            }
            Column column = TableOptionEdit.this.createDefaultColumn(TableOptionEdit.this.colidx++);
            column.name = string == null ? "" : string;
            Column[] columnArray = TableOptionEdit.this.createColumnArray(n3 + 1);
            System.arraycopy(TableOptionEdit.this.columns, 0, columnArray, 0, n3);
            columnArray[n3] = column;
            TableOptionEdit.this.columns = columnArray;
            ConfigWrapper configWrapper = TableOptionEdit.this.wrapper == null ? ConfigWrapper.makeWrapper(this) : TableOptionEdit.this.wrapper;
            Properties properties = configWrapper.getConfigurableState();
            TableOptionEdit.this.getTableModel().addColumn(string);
            if (Misc.emptyOrNull(string)) {
                objectArray = this.getColumnModel().getColumn(TableOptionEdit.this.columns.length - 1);
                objectArray.setHeaderValue(" ");
            }
            if (TableOptionEdit.this.columns.length > TableOptionEdit.this.autoResizeLimit) {
                TableOptionEdit.this.table.setAutoResizeMode(0);
            }
            try {
                ++this.blockUndo;
                configWrapper.setConfigurableState(properties);
                if (n != n3) {
                    this.getColumnModel().moveColumn(n3, n);
                }
                if (n2 >= 0 && this.getRowCount() > 0) {
                    this.setRowSelectionInterval(n2, n2);
                }
                this.setColumnSelectionInterval(n, n);
                if (!this.editColumn(n)) {
                    this.removeColumn(n);
                    if (n > 0) {
                        this.setColumnSelectionInterval(n - 1, n - 1);
                    }
                    return;
                }
            }
            finally {
                --this.blockUndo;
            }
            objectArray = new Object[this.getRowCount() + 3];
            objectArray[this.getRowCount()] = configWrapper.getConfigurableState();
            objectArray[this.getRowCount() + 1] = TableOptionEdit.this.columns[n3].name;
            objectArray[this.getRowCount() + 2] = TableOptionEdit.this.columns[n3].id;
            TableOptionEdit.this.fireUndoableDeleteColumnHappened(this, objectArray, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeColumn(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.removeColumn(int)", 3566).addDetail("idx", n)).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
            int n2 = this.getAnchorRow();
            int n3 = TableOptionEdit.this.columns.length;
            if (n < 0) {
                n = this.getAnchorColumn();
            }
            if (n < 0 || n >= n3) {
                return;
            }
            ConfigWrapper configWrapper = TableOptionEdit.this.wrapper == null ? ConfigWrapper.makeWrapper(this) : TableOptionEdit.this.wrapper;
            int n4 = this.convertColumnIndexToModel(n);
            Object[] objectArray = new Object[this.getRowCount() + 3];
            objectArray[this.getRowCount()] = configWrapper.getConfigurableState();
            objectArray[this.getRowCount() + 1] = TableOptionEdit.this.columns[n4].name;
            objectArray[this.getRowCount() + 2] = TableOptionEdit.this.columns[n4].id;
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                objectArray[i] = TableOptionEdit.this.getTableModel().getValueAt(i, n4);
            }
            Column[] columnArray = TableOptionEdit.this.createColumnArray(n3 - 1);
            if (n4 > 0) {
                System.arraycopy(TableOptionEdit.this.columns, 0, columnArray, 0, n4);
            }
            if (n4 < n3 - 1) {
                System.arraycopy(TableOptionEdit.this.columns, n4 + 1, columnArray, n4, n3 - n4 - 1);
            }
            TableOptionEdit.this.columns = columnArray;
            Properties properties = configWrapper.getConfigurableState();
            TableOptionEdit.this.getTableModel().removeColumn(n4);
            if (TableOptionEdit.this.columns.length <= TableOptionEdit.this.autoResizeLimit) {
                TableOptionEdit.this.table.setAutoResizeMode(2);
            }
            try {
                ++this.blockUndo;
                configWrapper.setConfigurableState(properties);
            }
            finally {
                --this.blockUndo;
            }
            if (this.getColumnCount() > 0) {
                if (n2 >= 0 && this.getRowCount() > 0) {
                    this.setRowSelectionInterval(n2, n2);
                }
                int n5 = Math.min(n, this.getColumnCount() - 1);
                this.setColumnSelectionInterval(n5, n5);
            }
            if (this.blockUndo == 0) {
                TableOptionEdit.this.fireUndoableDeleteColumnHappened(this, objectArray, false);
            }
        }

        @Override
        public void removeEditor() {
            TableCellEditor tableCellEditor;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.removeEditor()", 3640).log();
            }
            if ((tableCellEditor = this.getCellEditor()) != null) {
                tableCellEditor.removeCellEditorListener(this);
                Rectangle rectangle = this.getCellRect(this.editingRow, this.editingColumn, false);
                if (this.editorComp != null) {
                    rectangle = rectangle.union(this.editorComp.getBounds());
                    this.remove(this.editorComp);
                }
                this.setCellEditor(null);
                this.setEditingColumn(-1);
                this.setEditingRow(-1);
                this.editorComp = null;
                this.repaint(rectangle);
            }
        }

        protected boolean editColumn(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.editColumn(int)", 3670).addDetail("idx", n)).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return false;
            }
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
            int n2 = TableOptionEdit.this.columns.length;
            if (n < 0) {
                n = this.getAnchorColumn();
            }
            if (n < 0 || n >= n2) {
                return false;
            }
            int n3 = this.convertColumnIndexToModel(n);
            String string = TableOptionEdit.this.columns[n3].id;
            String string2 = TableOptionEdit.this.columns[n3].name;
            this.initColumnDialog(n3);
            int n4 = this.editColumnDialog.doModal(SwingUtilities.windowForComponent(this), true);
            if (n4 == 0) {
                TableOptionEdit.this.columns[n3].name = this.columnOptions.getString("option.table.column.title", "UNDEFINED");
                this.getColumnModel().getColumn(n).setHeaderValue(TableOptionEdit.this.columns[n3].name);
                this.getTableHeader().invalidate();
                this.getTableHeader().repaint();
                if (this.blockUndo == 0) {
                    TableOptionEdit.this.fireUndoableColumnChangeHappened(this, string, string2);
                }
            }
            this.setColumnSelectionInterval(n, n);
            SwingUtil.focusLater(this);
            return n4 == 0;
        }

        protected void ctrlUp() {
            int n = this.getAnchorRow();
            if (n > 0) {
                this.setAnchorRow(n - 1);
            }
        }

        protected void ctrlDown() {
            int n = this.getAnchorRow();
            if (n < this.getRowCount() - 1) {
                this.setAnchorRow(n + 1);
            }
        }

        protected void ctrlLeft() {
            int n = this.getAnchorColumn();
            if (n > 0) {
                this.getColumnModel().getSelectionModel().setSelectionInterval(n - 1, n - 1);
            }
        }

        protected void ctrlRight() {
            int n = this.getAnchorColumn();
            if (n < this.getColumnCount() - 1) {
                this.getColumnModel().getSelectionModel().setSelectionInterval(n + 1, n + 1);
            }
        }

        protected void toggleSelection() {
            int n = this.getAnchorRow();
            if (this.getSelectionModel().isSelectedIndex(n)) {
                this.getSelectionModel().removeSelectionInterval(n, n);
            } else {
                this.getSelectionModel().addSelectionInterval(n, n);
            }
        }

        protected void cut() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.cut()", 3807).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            this.copy();
            this.delete();
        }

        protected void copy() {
            int n;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.copy()", 3824).log();
            }
            int n2 = this.getColumnCount();
            int n3 = this.getRowCount();
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.copy()", 3829).add("columns", n2)).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.copy()", 3830).add("rows", n3)).log();
            }
            if (n3 <= 0 || n2 <= 0) {
                return;
            }
            ListSelectionModel listSelectionModel = this.getSelectionModel();
            int n4 = 0;
            for (int i = 0; i < n3; ++i) {
                if (!listSelectionModel.isSelectedIndex(i)) continue;
                ++n4;
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.copy()", 3845).add("srows", n4)).log();
            }
            Object[][] objectArray = null;
            if (n4 > 0) {
                objectArray = new Object[n4][];
                int n5 = 0;
                for (n = 0; n < n3 && n5 < n4; ++n) {
                    if (!listSelectionModel.isSelectedIndex(n)) continue;
                    objectArray[n5] = this.copyRow(n);
                    ++n5;
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (n4 > 0) {
                n = 0;
                int n6 = 0;
                for (int i = 0; i < n3 && n < n4; ++i) {
                    if (!listSelectionModel.isSelectedIndex(i)) continue;
                    if (n6 > 0) {
                        stringBuilder.append("\n");
                    }
                    int n7 = 0;
                    for (int j = 0; j < n2; ++j) {
                        Object object;
                        if (n7 > 0) {
                            stringBuilder.append(columnTextSeparator);
                        }
                        if ((object = this.getValueAt(i, j)) != null) {
                            stringBuilder.append(TableOptionEdit.this.getStringValueForTextCopy(object, i, j));
                        }
                        ++n7;
                    }
                    ++n6;
                    ++n;
                }
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.copy()", 3891).add("sel:", stringBuilder.toString())).log();
            }
            RowSelection rowSelection = new RowSelection(objectArray, stringBuilder.toString());
            SwingUtil.safeSetClipboard(null, rowSelection, rowSelection);
        }

        protected void paste() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.paste()", 3905).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            Object[][] objectArray = this.getRowsForPaste();
            if (objectArray != null) {
                ArrayList<Pair<Integer, Object[]>> arrayList = new ArrayList<Pair<Integer, Object[]>>();
                if (this.isEditing() && this.getCellEditor() != null) {
                    this.getCellEditor().cancelCellEditing();
                }
                int n = this.getAnchorRow();
                int n2 = Math.min(this.getRowCount(), n + 1);
                boolean bl = true;
                for (int i = 0; i < objectArray.length; ++i) {
                    Object[] objectArray2;
                    if (TableOptionEdit.this.columns.length != objectArray[i].length || (objectArray2 = this.pasteRow(objectArray[i])) == null) continue;
                    if (bl) {
                        this.getSelectionModel().clearSelection();
                        bl = false;
                    }
                    TableOptionEdit.this.getTableModel().insertRow(n2, objectArray2);
                    this.getSelectionModel().addSelectionInterval(n2, n2);
                    arrayList.add(0, new Pair<Integer, Object[]>(n2, objectArray2));
                    ++n2;
                }
                this.setAnchorRow(n2 - 1);
                TableOptionEdit.this.fireUndoableInsertRowsHappened(this, arrayList);
            }
        }

        protected void delete() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.delete()", 3950).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
            ArrayList<Pair<Integer, Object[]>> arrayList = new ArrayList<Pair<Integer, Object[]>>();
            int n = this.getAnchorRow();
            int n2 = this.getRowCount();
            int n3 = this.getAnchorColumn();
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.delete()", 3966).add("row", n)).add("rows", n2)).add("column", n3)).log();
            }
            int[] nArray = TableOptionEdit.this.getTable().getSelectedRows();
            Arrays.sort(nArray);
            for (int i = nArray.length - 1; i >= 0; --i) {
                int n4 = nArray[i];
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.delete()", 3972).add("currentRow", n4)).log();
                }
                arrayList.add(new Pair<Integer, Object[]>(n4, this.copyRow(n4)));
                TableOptionEdit.this.getTableModel().removeRow(n4);
                if (n4 < n) {
                    --n;
                }
                if (logger.level < 9) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.delete()", 3979).add("row for ")).add("i", i)).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.delete()", 3982).add("final row: ")).add("row", n)).log();
            }
            this.getSelectionModel().clearSelection();
            n2 = this.getRowCount();
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.delete()", 3985).add("rows now: ")).add("rows", n2)).log();
            }
            if (n2 > 0) {
                if (n >= n2) {
                    n = n2 - 1;
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.delete()", 3989).add("adjusted row: ")).add("row", n)).log();
                    }
                }
                this.getSelectionModel().setSelectionInterval(n, n);
            }
            TableOptionEdit.this.fireUndoableDeleteRowsHappened(this, arrayList);
            if (n >= 0 && n < n2) {
                this.setAnchorRow(n);
            }
            if (n3 >= 0 && n3 < this.getColumnCount()) {
                this.setAnchorColumn(n3);
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.delete()", 4000).add("focus: ")).add("isFocusOwner()", this.isFocusOwner())).add(", leadRow: ")).add("getAnchorRow()", this.getAnchorRow())).add(", leadColumn: ")).add("getAnchorColumn()", this.getAnchorColumn())).log();
            }
        }

        public void escapeRegex(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.escapeRegex(int)", 4014).addDetail("column", n)).log();
            }
            if (!TableOptionEdit.this.enabled) {
                return;
            }
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
            int n2 = this.getAnchorRow();
            int n3 = this.getRowCount();
            if (n == -1) {
                n = this.getAnchorColumn();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.escapeRegex(int)", 4035).add("rows", n3)).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.escapeRegex(int)", 4036).add("column", n)).log();
            }
            int[] nArray = TableOptionEdit.this.getTable().getSelectedRows();
            ArrayList<Pair<Integer, Object[]>> arrayList = new ArrayList<Pair<Integer, Object[]>>();
            for (int i = 0; i <= nArray.length - 1; ++i) {
                int n4 = nArray[i];
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.escapeRegex(int)", 4042).add("currentRow", n4)).log();
                }
                Object[] objectArray = this.copyRow(n4);
                Object object = TableOptionEdit.this.getTableModel().getValueAt(n4, n);
                if (object == null) {
                    object = "";
                }
                if (object instanceof String) {
                    String string = TableOptionEdit.this.escapeValue((String)object);
                    TableOptionEdit.this.getTableModel().setValueAt(string, n4, n);
                    TableOptionEdit.this.performCustomModification(n4, n);
                }
                arrayList.add(0, new Pair<Integer, Object[]>(nArray[i], objectArray));
            }
            TableOptionEdit.this.fireUndoableRowsChangeHappened(TableOptionEdit.this.table, arrayList);
        }

        @Override
        public boolean isManagingFocus() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.isManagingFocus()", 4068).log();
            }
            return false;
        }

        @Override
        public boolean isFocusTraversable() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.isFocusTraversable()", 4077).log();
            }
            return this.isEnabled();
        }

        @Override
        public boolean isRequestFocusEnabled() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.isRequestFocusEnabled()", 4086).log();
            }
            return this.isEnabled();
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.isCellEditable(int,int)", 4095).addDetail("row", n)).addDetail("column", n2)).log();
            }
            boolean bl = this.isEnabled() && TableOptionEdit.this.enabled && !TableOptionEdit.this.columns[n2].disabled && super.isCellEditable(n, n2);
            return bl;
        }

        @Override
        public void editingStopped(ChangeEvent changeEvent) {
            Object object;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.editingStopped(ChangeEvent)", 4113).addDetail("e", changeEvent)).log();
            }
            int n = this.getEditingRow();
            int n2 = this.getEditingColumn();
            Object[] objectArray = this.copyRow(n);
            int n3 = this.convertColumnIndexToModel(n2);
            Object object2 = null;
            boolean bl = true;
            try {
                object2 = TableOptionEdit.this.getEditedValueFromString(this.getValueOfEditorComponent(), objectArray[n3], n, n2, true);
            }
            catch (CancelEditException cancelEditException) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editingStopped(ChangeEvent)", 4125).add("Conversion of edited data cancelled")).log();
                }
                bl = false;
            }
            if (Misc.equalOrNull(object2, objectArray[n3])) {
                bl = false;
            }
            if (bl && object2 instanceof String && !Misc.emptyOrNull(object2) && !object2.equals(" ") && !TableOptionEdit.this.columns[n2].mayContainBlanks) {
                int n4;
                object = (String)object2;
                Pattern pattern = Pattern.compile("\\s");
                Matcher matcher = pattern.matcher((CharSequence)object);
                boolean bl2 = matcher.find();
                if (bl2 && (n4 = Message.showMessage(this, "columnBlanks", new String[]{TableOptionEdit.this.columns[n2].name})) == 1) {
                    String[] stringArray = ((String)object).split("\\s");
                    super.editingStopped(changeEvent);
                    TableOptionEdit.this.getTableModel().setValueAt(stringArray[0], n, n2);
                    TableOptionEdit.this.fireUndoableRowChangeHappened(this, n, objectArray);
                    ArrayList<Pair<Integer, Object[]>> arrayList = new ArrayList<Pair<Integer, Object[]>>();
                    int n5 = 1;
                    for (int i = 1; i < stringArray.length; ++i) {
                        Object[] objectArray2 = new Object[objectArray.length];
                        objectArray2[n2] = stringArray[i];
                        TableOptionEdit.this.getTableModel().insertRow(n + n5, objectArray2);
                        arrayList.add(new Pair<Integer, Object[]>(n + n5, objectArray2));
                        ++n5;
                    }
                    TableOptionEdit.this.fireUndoableInsertRowsHappened(this, arrayList);
                    return;
                }
            }
            if ((object = this.getCellEditor()) != null) {
                block16: {
                    if (bl) {
                        object2 = object.getCellEditorValue();
                        try {
                            if (object2 instanceof String) {
                                object2 = TableOptionEdit.this.getEditedValueFromString((String)object2, objectArray[n3], n, n2, false);
                            }
                            this.setValueAt(object2, n, n2);
                        }
                        catch (CancelEditException cancelEditException) {
                            if (logger.level < 9) break block16;
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editingStopped(ChangeEvent)", 4181).add("Conversion of edited value cancelled")).log();
                        }
                    }
                }
                this.removeEditor();
            }
            if (bl) {
                TableOptionEdit.this.fireUndoableRowChangeHappened(this, n, objectArray);
            } else if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.editingStopped(ChangeEvent)", 4190).add("Value didn't change, so don't fire any undos.")).log();
            }
        }

        @NonNull
        public String getValueOfEditorComponent() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.getValueOfEditorComponent()", 4203).log();
            }
            String string = null;
            Component component = this.getEditorComponent();
            if (component instanceof JTextComponent) {
                string = ((JTextComponent)component).getText();
            } else if (component instanceof ResizableMultiLineScrollPane) {
                string = ((ResizableMultiLineScrollPane)component).getText();
            }
            return string == null ? "" : string;
        }

        @Override
        public void setEnabled(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.setEnabled(boolean)", 4226).addDetail("enabled", bl)).log();
            }
            if (this.buttonBox != null) {
                if (this.editButton != null) {
                    this.editButton.setEnabled(bl);
                }
                if (this.newButton != null) {
                    this.newButton.setEnabled(bl);
                }
                if (this.removeButton != null) {
                    this.removeButton.setEnabled(bl);
                }
                if (this.upButton != null) {
                    this.upButton.setEnabled(bl);
                }
                if (this.downButton != null) {
                    this.downButton.setEnabled(bl);
                }
                if (this.addcolButton != null) {
                    this.addcolButton.setEnabled(bl);
                }
                if (this.removecolButton != null) {
                    this.removecolButton.setEnabled(bl);
                }
                if (this.editcolButton != null) {
                    this.editcolButton.setEnabled(bl);
                }
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.columnMoved(TableColumnModelEvent)", 4264).addDetail("e", tableColumnModelEvent)).log();
            }
            if (this.isEditing() && this.getCellEditor() != null && !this.getCellEditor().stopCellEditing()) {
                this.getCellEditor().cancelCellEditing();
            }
            super.columnMoved(tableColumnModelEvent);
            if (this.blockUndo == 0 && tableColumnModelEvent.getFromIndex() != tableColumnModelEvent.getToIndex()) {
                TableOptionEdit.this.fireUndoableMoveColumnHappened(this, tableColumnModelEvent.getFromIndex(), tableColumnModelEvent.getToIndex());
            }
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.columnMarginChanged(ChangeEvent)", 4284).addDetail("e", changeEvent)).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.columnMarginChanged(ChangeEvent)", 4286).add("")).dumpStack();
            }
            if (this.isEditing()) {
                TableCellEditor tableCellEditor = this.getCellEditor();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.columnMarginChanged(ChangeEvent)", 4289).add("editor", tableCellEditor)).log();
                }
                if (tableCellEditor instanceof Editor && ((Editor)tableCellEditor).startEditTime > 0L && System.currentTimeMillis() - ((Editor)tableCellEditor).startEditTime < 100L) {
                    return;
                }
                if (tableCellEditor instanceof MultiLineTableCellEditor && this.setRowHeightTime != 0L && System.currentTimeMillis() - this.setRowHeightTime < 300L) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.columnMarginChanged(ChangeEvent)", 4303).add("Ignored")).log();
                    }
                    return;
                }
            }
            super.columnMarginChanged(changeEvent);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.valueChanged(ListSelectionEvent)", 4326).addDetail("e", listSelectionEvent)).log();
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.valueChanged(ListSelectionEvent)", 4327).add("")).dumpStack();
            }
            super.valueChanged(listSelectionEvent);
            if (!listSelectionEvent.getValueIsAdjusting()) {
                final int n = listSelectionEvent.getFirstIndex();
                final int n2 = listSelectionEvent.getLastIndex();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.valueChanged(ListSelectionEvent)", 4333).add("from", n)).log();
                }
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.valueChanged(ListSelectionEvent)", 4334).add("to", n2)).log();
                }
                if (!this.inMousePress) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (logger.level >= 7) {
                                logger.lvlBuild(7, "Table.valueChanged(ListSelectionEvent).Runnable.run()", 4338).log();
                            }
                            if (logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.valueChanged(ListSelectionEvent).Runnable.run()", 4339).add("from", n)).log();
                            }
                            if (logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.valueChanged(ListSelectionEvent).Runnable.run()", 4340).add("to", n2)).log();
                            }
                            if (n >= 0 && n2 >= 0) {
                                Rectangle rectangle = Table.this.getCellRect(Math.min(n, n2), 0, true);
                                Rectangle rectangle2 = Table.this.getCellRect(Math.max(n, n2), Table.this.getColumnCount() - 1, true);
                                SwingUtilities.computeUnion(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle2);
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.valueChanged(ListSelectionEvent).Runnable.run()", 4348).add("unionRect", rectangle2)).log();
                                }
                                Rectangle rectangle3 = Table.this.getVisibleRect();
                                SwingUtilities.computeIntersection(rectangle.x, rectangle2.y, rectangle.width, rectangle2.height, rectangle2);
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.valueChanged(ListSelectionEvent).Runnable.run()", 4353).add("intersectionRect", rectangle3)).log();
                                }
                                Table.this.scrollRectToVisible(rectangle2);
                            }
                        }
                    });
                }
            }
        }

        @Override
        public void scrollRectToVisible(Rectangle rectangle) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.scrollRectToVisible(Rectangle)", 4372).addDetail("aRect", rectangle)).log();
            }
            super.scrollRectToVisible(rectangle);
            if (TableOptionEdit.this.maxPrefHeight != 0 && !this.inMousePress && this.hasFocus()) {
                Container container = SwingUtilities.getAncestorOfClass(JScrollPane.class, this);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.scrollRectToVisible(Rectangle)", 4382).add("parentPane", container)).log();
                }
                if (container != null) {
                    Rectangle rectangle2 = SwingUtilities.convertRectangle(this, rectangle, container);
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.scrollRectToVisible(Rectangle)", 4386).add("rect", rectangle2)).log();
                    }
                    ((JScrollPane)container).scrollRectToVisible(rectangle2);
                }
            }
        }

        @Override
        public boolean editCellAt(int n, int n2, EventObject eventObject) {
            if (this.cellEditor != null && !this.cellEditor.stopCellEditing()) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4405).add("No editor, return false.")).log();
                }
                return false;
            }
            if (eventObject instanceof KeyEvent && ((KeyEvent)eventObject).getID() == 401) {
                if ((((KeyEvent)eventObject).getModifiers() & 0xA) != 0) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4414).add("KEY_PRESSED with ALT or CTRL")).log();
                    }
                    return false;
                }
                char c = ((KeyEvent)eventObject).getKeyChar();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4418).add("(int)c", (int)c)).log();
                }
                if (c == '\uffff') {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4420).add("KEY_PRESSED with undefined char")).log();
                    }
                    return false;
                }
            }
            if (n < 0 || n >= this.getRowCount() || n2 < 0 || n2 >= this.getColumnCount()) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4427).add("No rows or columns.")).log();
                }
                return false;
            }
            if (!this.isCellEditable(n, n2)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4433).add("Row not editable.")).log();
                }
                return false;
            }
            TableCellEditor tableCellEditor = this.getCellEditor(n, n2);
            if (tableCellEditor != null && tableCellEditor.isCellEditable(eventObject)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4440).add("Got editor:")).add("editor", tableCellEditor)).log();
                }
                this.editorComp = this.prepareEditor(tableCellEditor, n, n2);
                if (this.editorComp == null) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4444).add("No editor component, leave.")).log();
                    }
                    this.removeEditor();
                    return false;
                }
                Rectangle rectangle = this.getCellRect(n, n2, false);
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4450).add("Got cellRect:")).add("cellRect", rectangle)).log();
                }
                if (!(tableCellEditor instanceof MultiLineTableCellEditor)) {
                    this.editorComp.setBounds(rectangle);
                }
                this.add(this.editorComp);
                this.editorComp.validate();
                this.editorComp.repaint();
                this.setCellEditor(tableCellEditor);
                this.setEditingRow(n);
                this.setEditingColumn(n2);
                tableCellEditor.addCellEditorListener(this);
                if (tableCellEditor instanceof Editor) {
                    ((Editor)tableCellEditor).requestFocusAndFixCursor();
                }
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4476).add("Editor added and painted.")).log();
                }
                return true;
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.editCellAt(int,int,EventObject)", 4481).add("No cell editor.")).log();
            }
            return false;
        }

        @Override
        protected void processMouseEvent(MouseEvent mouseEvent) {
            if (mouseEvent.getID() == 501 || mouseEvent.getID() == 502) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.processMouseEvent(MouseEvent)", 4500).add("event", mouseEvent)).log();
                }
                this.inMousePress = true;
                try {
                    super.processMouseEvent(mouseEvent);
                }
                finally {
                    this.inMousePress = false;
                }
            } else {
                super.processMouseEvent(mouseEvent);
            }
        }

        protected void initDialog(int n) {
            CharSequence charSequence;
            int n2;
            String string = TableOptionEdit.this.option.getName() + ".row";
            if (this.rowOptions == null || TableOptionEdit.this.caneditcolumn) {
                this.rowOptions = new OptionSet(string);
                for (n2 = 0; n2 < TableOptionEdit.this.columns.length; ++n2) {
                    this.rowOptions.add(TableOptionEdit.this.columns[n2].option);
                }
            }
            for (n2 = 0; n2 < TableOptionEdit.this.columns.length; ++n2) {
                charSequence = TableOptionEdit.this.option.getName();
                String string2 = TableOptionEdit.this.columns[n2].id;
                String string3 = charSequence + ".column." + string2;
                Option option = this.rowOptions.getOption(string3);
                if (option == null) {
                    option = TableOptionEdit.this.columns[n2].option;
                    this.rowOptions.add(option);
                }
                if (n >= 0) {
                    option.setValue(this.getCleanValueForColumn(n, n2));
                    continue;
                }
                option.setValue(TableOptionEdit.this.columns[n2].dflt);
            }
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.initDialog(int)", 4544).add("rowOptions.listOptions()", this.rowOptions.listOptions())).log();
            }
            if (this.editDialog == null || TableOptionEdit.this.caneditcolumn) {
                Properties properties = new Properties();
                properties.put("option.group." + string + ".type", "plain");
                charSequence = new StringBuilder();
                for (int i = 0; i < TableOptionEdit.this.columns.length; ++i) {
                    int n3 = this.convertColumnIndexToModel(i);
                    if (i > 0) {
                        ((StringBuilder)charSequence).append(' ');
                    }
                    ((StringBuilder)charSequence).append(TableOptionEdit.this.option.getName());
                    ((StringBuilder)charSequence).append(".column.");
                    ((StringBuilder)charSequence).append(TableOptionEdit.this.columns[n3].id);
                    properties.put("option." + TableOptionEdit.this.option.getName() + ".column." + TableOptionEdit.this.columns[n3].id + ".label", TableOptionEdit.this.columns[n3].name);
                    properties.put("option." + TableOptionEdit.this.option.getName() + ".column." + TableOptionEdit.this.columns[n3].id + ".showwhitespaces", "" + TableOptionEdit.this.doShowWhitespaces());
                    if (!"choice".equals(TableOptionEdit.this.columns[n3].type) && !"stringchoice".equals(TableOptionEdit.this.columns[n3].type)) continue;
                    int n4 = Integer.parseInt(TableOptionEdit.this.getString("column." + TableOptionEdit.this.columns[n3].id + ".numchoices", "1"));
                    properties.put("option." + TableOptionEdit.this.option.getName() + ".column." + TableOptionEdit.this.columns[n3].id + ".numchoices", "" + n4);
                    for (int j = 0; j < n4; ++j) {
                        properties.put("option." + TableOptionEdit.this.option.getName() + ".column." + TableOptionEdit.this.columns[n3].id + ".choice" + (j + 1) + ".label", TableOptionEdit.this.getString("column." + TableOptionEdit.this.columns[n3].id + ".choice" + (j + 1), "string"));
                    }
                }
                properties.put("dialog." + string + ".title", Option.getResources().getString("option.table.row.dialog.title", "Edit table row"));
                this.extendRowOptions(this.rowOptions, n, properties, (StringBuilder)charSequence);
                properties.put("option.group." + string + ".members", ((StringBuilder)charSequence).toString());
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.initDialog(int)", 4585).add("props", properties)).log();
                }
                Option.getResources().addResources(properties);
                Window window = SwingUtilities.windowForComponent(this);
                this.editDialog = window instanceof Frame ? this.getEditDialog(string, (Frame)window) : (window instanceof Dialog ? this.getEditDialog(string, (Dialog)window) : this.getEditDialog(string, (Frame)null));
                this.editDialog.setReusable(true);
                SwingUtil.closeOnEscape(this.editDialog);
            } else {
                Properties properties = new Properties();
                for (int i = 0; i < TableOptionEdit.this.columns.length; ++i) {
                    int n5 = this.convertColumnIndexToModel(i);
                    properties.put("option." + TableOptionEdit.this.option.getName() + ".column." + TableOptionEdit.this.columns[n5].id + ".showwhitespaces", "" + TableOptionEdit.this.doShowWhitespaces());
                }
                Option.getResources().addResources(properties);
                this.editDialog.update(this.rowOptions);
            }
        }

        @NonNull
        protected OptionDialog getEditDialog(String string, Frame frame) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.getEditDialog(String,Frame)", 4617).addDetail("name", string)).addDetail("win", frame)).log();
            }
            return new OptionDialog(string, frame, this.rowOptions, string);
        }

        @NonNull
        protected OptionDialog getEditDialog(String string, Dialog dialog) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.getEditDialog(String,Dialog)", 4623).addDetail("name", string)).addDetail("win", dialog)).log();
            }
            return new OptionDialog(string, dialog, this.rowOptions, string);
        }

        protected void extendRowOptions(OptionSet optionSet, int n, Properties properties, StringBuilder stringBuilder) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.extendRowOptions(OptionSet,int,Properties,StringBuilder)", 4640).addDetail("rowOptions", optionSet)).addDetail("row", n)).addDetail("props", properties)).addDetail("membersStringBuilder", stringBuilder)).log();
            }
        }

        protected void dialogConfirmed(int n, boolean bl) {
        }

        protected Object getCleanValueForColumn(int n, int n2) {
            String string;
            block4: {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.getCleanValueForColumn(int,int)", 4662).addDetail("row", n)).addDetail("col", n2)).log();
                }
                Object object = TableOptionEdit.this.getTableModel().getValueAt(n, n2);
                string = TableOptionEdit.this.getStringValueForEdit(object, n, n2);
                if (TableOptionEdit.this.columns[n2].clazz == Integer.class) {
                    try {
                        return Integer.valueOf(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (logger.level < 5) break block4;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(5, "Table.getCleanValueForColumn(int,int)", 4670).add("Not a number: ", string)).add("ex", numberFormatException)).log();
                    }
                }
            }
            return string;
        }

        protected void initColumnDialog(int n) {
            String string = TableOptionEdit.this.option.getName() + ".row";
            if (this.columnOptions == null) {
                this.columnOptions = new OptionSet("option.table.column");
                this.columnOptions.add(new StringOption("option.table.column.title", TableOptionEdit.this.columns[n].name));
            } else {
                this.columnOptions.getOption("option.table.column.title").setValue(TableOptionEdit.this.columns[n].name);
            }
            if (this.editColumnDialog == null) {
                Window window = SwingUtilities.windowForComponent(this);
                this.editColumnDialog = window instanceof Frame ? new OptionDialog("option.table.column", (Frame)window, this.columnOptions, "option.table.column") : (window instanceof Dialog ? new OptionDialog("option.table.column", (Dialog)window, this.columnOptions, "option.table.column") : new OptionDialog("option.table.column", (Frame)null, this.rowOptions, "option.table.column"));
                this.editColumnDialog.setReusable(true);
                SwingUtil.closeOnEscape(this.editColumnDialog);
            } else {
                this.editColumnDialog.update(this.columnOptions);
            }
        }

        public int getAnchorRow() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.getAnchorRow()", 4724).log();
            }
            return this.getSelectionModel().getLeadSelectionIndex();
        }

        protected int getDefaultRowHeight() {
            Font font = this.getFont();
            FontMetrics fontMetrics = this.getFontMetrics(font);
            float f = fontMetrics.getHeight();
            int n = Math.max(Misc.OS_IS_LINUX ? 18 : 16, (int)f + (Misc.OS_IS_MAC_OS_X ? 3 : 2));
            if (TableOptionEdit.this.columns != null) {
                for (Column column : TableOptionEdit.this.columns) {
                    if (!"choice".equals(column.type)) continue;
                    n += 3;
                    break;
                }
            }
            return n;
        }

        public void updateMultiLineRowHeight(ResizableMultiLineScrollPane resizableMultiLineScrollPane, Component component, int n, int n2) {
            int n3 = resizableMultiLineScrollPane.getTextLineCount();
            int n4 = ((ResizableMultiLineTextArea)resizableMultiLineScrollPane.getTextComponent()).getLongestLineWidth();
            int n5 = resizableMultiLineScrollPane.getAllowedLines();
            if (n3 < n5) {
                n5 = n3;
            }
            int n6 = resizableMultiLineScrollPane.getHorizontalScrollBar().getPreferredSize().height;
            int n7 = resizableMultiLineScrollPane.getVerticalScrollBar().getWidth();
            int n8 = TableOptionEdit.this.table.getColumnModel().getColumn(n2).getWidth();
            boolean bl = false;
            if (n8 <= n4 + n7 + 6) {
                bl = true;
                resizableMultiLineScrollPane.setHorizontalScrollBarPolicy(32);
            } else {
                resizableMultiLineScrollPane.setHorizontalScrollBarPolicy(31);
            }
            if (n3 <= n5) {
                resizableMultiLineScrollPane.setVerticalScrollBarPolicy(21);
            } else {
                resizableMultiLineScrollPane.setVerticalScrollBarPolicy(20);
            }
            int n9 = n3 * TableOptionEdit.this.table.getDefaultRowHeight();
            int n10 = TableOptionEdit.this.table.getDefaultRowHeight() * n5;
            int n11 = Math.max(TableOptionEdit.this.table.getDefaultRowHeight(), n10) + n6;
            ((ResizableMultiLineTextArea)resizableMultiLineScrollPane.getTextComponent()).setRows(n5);
            if (bl) {
                n9 += n6;
            }
            this.setRowHeightTime = System.currentTimeMillis();
            if (n9 > TableOptionEdit.this.table.getRowHeight(n)) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.updateMultiLineRowHeight(ResizableMultiLineScrollPane,Component,int,int)", 4817).add("Update row height as it's a multi line value.")).log();
                }
                this.setRowHeight(n, n11 + 1);
            } else {
                this.setRowHeight(n, n9 + 0);
            }
        }

        public void setAnchorRow(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.setAnchorRow(int)", 4834).addDetail("idx", n)).log();
            }
            int n2 = this.getAnchorRow();
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.setAnchorRow(int)", 4837).add("crow", n2)).log();
            }
            if (n2 < 0 || n2 >= this.getRowCount()) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.setAnchorRow(int)", 4839).add("Setting anchor index as well")).log();
                }
                this.getSelectionModel().setAnchorSelectionIndex(n);
            }
            this.getSelectionModel().setLeadSelectionIndex(n);
        }

        public int getAnchorColumn() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.getAnchorColumn()", 4855).log();
            }
            return this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        }

        public void setAnchorColumn(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.setAnchorColumn(int)", 4868).addDetail("idx", n)).log();
            }
            int n2 = this.getAnchorColumn();
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.setAnchorColumn(int)", 4871).add("ccol", n2)).log();
            }
            if (n2 < 0 || n2 >= this.getColumnCount()) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.setAnchorColumn(int)", 4873).add("Setting anchor index as well")).log();
                }
                this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(n);
            }
            this.getColumnModel().getSelectionModel().setLeadSelectionIndex(n);
        }

        public Object[] copyRow(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.copyRow(int)", 4891).addDetail("row", n)).log();
            }
            int n2 = this.getColumnCount();
            Object[] objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                Object object = TableOptionEdit.this.getTableModel().getValueAt(n, i);
                try {
                    objectArray[i] = Reflector.call(object, "clone");
                }
                catch (Exception exception) {
                    objectArray[i] = object;
                }
                if (logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.copyRow(int)", 4902).add("ret[i]", objectArray[i])).log();
            }
            return objectArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object[][] getRowsForPaste() {
            Object[][] objectArray;
            block20: {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "Table.getRowsForPaste()", 4918).log();
                }
                objectArray = null;
                try {
                    boolean bl;
                    Transferable transferable;
                    block19: {
                        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                        transferable = null;
                        try {
                            transferable = clipboard.getContents(null);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            if (logger.level < 9) break block19;
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.getRowsForPaste()", 4931).add("ex", illegalArgumentException)).log();
                        }
                    }
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.getRowsForPaste()", 4933).add("transfer", transferable)).log();
                    }
                    if (transferable == null) break block20;
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.getRowsForPaste()", 4935).add("transfer", transferable)).log();
                    }
                    if (transferable.isDataFlavorSupported(RowSelection.flavor)) {
                        objectArray = (Object[][])transferable.getTransferData(RowSelection.flavor);
                        break block20;
                    }
                    if (!transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) break block20;
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    boolean bl2 = bl = (string = Misc.lineSepToLineFeed(string)).indexOf(10) < 0;
                    if (bl) {
                        string = Misc.quote(string, "\"");
                    }
                    StringReader stringReader = new StringReader(string);
                    CSVParser cSVParser = new CSVParser((Reader)stringReader, CSVFormat.TDF);
                    try {
                        objectArray = CSVUtil.getAllValues(cSVParser);
                        if (bl && objectArray != null) {
                            for (int i = 0; i < objectArray.length; ++i) {
                                for (int j = 0; j < objectArray[i].length; ++j) {
                                    objectArray[i][j] = Misc.unquote(objectArray[i][j].toString(), "\"");
                                }
                            }
                        }
                    }
                    finally {
                        ((Reader)stringReader).close();
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.getRowsForPaste()", 4979).add("ex", unsupportedFlavorException)).log();
                    }
                }
                catch (IOException iOException) {
                    if (logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "Table.getRowsForPaste()", 4981).add("ex", iOException)).log();
                    }
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                    if (logger.level < 1) break block20;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "Table.getRowsForPaste()", 4983).add("ex", noClassDefFoundError)).log();
                }
            }
            return objectArray;
        }

        protected Object[] pasteRow(Object[] objectArray) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.pasteRow(Object[])", 5002).addDetail("data", objectArray)).log();
            }
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] == null || TableOptionEdit.this.columns[i].type.equals("boolean") && objectArray[i] instanceof String || TableOptionEdit.this.canPasteData(objectArray, i)) continue;
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.pasteRow(Object[])", 5011).add("Incompatible rows, data[")).add(i)).add("]: ")).add(objectArray[i])).log();
                }
                return null;
            }
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                this.pasteRowData(objectArray2, objectArray, i);
            }
            return objectArray2;
        }

        protected void pasteRowData(Object[] objectArray, Object[] objectArray2, int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.pasteRowData(Object[],Object[],int)", 5036).addDetail("rowdata", objectArray)).addDetail("data", objectArray2)).addDetail("col", n)).log();
            }
            if (TableOptionEdit.this.columns[n].type.equals("boolean") && objectArray2[n] instanceof String) {
                objectArray[n] = Boolean.valueOf((String)objectArray2[n]);
            } else {
                try {
                    objectArray[n] = Reflector.call(objectArray2[n], "clone");
                }
                catch (Exception exception) {
                    objectArray[n] = objectArray2[n];
                }
            }
        }

        protected void scrollToVisible(int n, int n2, boolean bl, boolean bl2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.scrollToVisible(int,int,boolean,boolean)", 5062).addDetail("row", n)).addDetail("col", n2)).addDetail("includeSpacing", bl)).addDetail("onlyOnce", bl2)).log();
            }
            Rectangle rectangle = this.getCellRect(n, n2, bl);
            if (bl2) {
                if (!this.scrolledToVisible) {
                    this.scrollRectToVisible(rectangle);
                    this.scrolledToVisible = true;
                }
            } else {
                this.scrollRectToVisible(rectangle);
            }
        }

        protected void scrollToVisibleReset() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.scrollToVisibleReset()", 5082).log();
            }
            this.scrolledToVisible = false;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.getScrollableTracksViewportHeight()", 5091).log();
            }
            if (this.getParent() instanceof JViewport) {
                return this.getParent().getHeight() > this.getPreferredSize().height;
            }
            return false;
        }

        public void dehighlightTable() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Table.dehighlightTable()", 5107).log();
            }
            if (TableOptionEdit.this.getTableModel() != null) {
                TableOptionEdit.this.getTableModel().clearHighlightData();
                this.scrollToVisibleReset();
                this.repaint();
            }
        }

        protected boolean isCellHighlighted(int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.isCellHighlighted(int,int)", 5127).addDetail("row", n)).addDetail("column", n2)).log();
            }
            int n3 = n + (TableOptionEdit.this.caneditcolumn ? 1 : 0);
            int n4 = this.convertColumnIndexToModel(n2);
            return TableOptionEdit.this.getTableModel() == null ? false : TableOptionEdit.this.getTableModel().isHighlightDataAvailable(n3, n4);
        }

        protected Object getHighlightedCell(int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.getHighlightedCell(int,int)", 5146).addDetail("row", n)).addDetail("column", n2)).log();
            }
            int n3 = n + (TableOptionEdit.this.caneditcolumn ? 1 : 0);
            int n4 = this.convertColumnIndexToModel(n2);
            return TableOptionEdit.this.getTableModel().getHighlightData(n3, n4);
        }

        private class HeaderListener
        extends MouseAdapter {
            private HeaderListener() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "Table.HeaderListener.HeaderListener()", 5283).log();
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.HeaderListener.mouseClicked(MouseEvent)", 5298).addDetail("e", mouseEvent)).log();
                }
                if (mouseEvent.getClickCount() == 2 && (n = Table.this.getColumnModel().getColumnIndexAtX(mouseEvent.getX())) != -1) {
                    Rectangle rectangle = Table.this.getCellRect(-1, n, true);
                    if (n > 0 && mouseEvent.getX() - rectangle.x <= 5) {
                        SwingUtil.autoSizeTableColumn(Table.this, n - 1);
                    } else if (rectangle.x + rectangle.width - mouseEvent.getX() <= 5) {
                        SwingUtil.autoSizeTableColumn(Table.this, n);
                    } else if (TableOptionEdit.this.caneditcolumn) {
                        Table.this.editColumn(n);
                    }
                }
            }
        }

        protected class ActionHandler
        implements ActionListener {
            protected ActionHandler() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "Table.ActionHandler.ActionHandler()", 5223).log();
                }
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.ActionHandler.actionPerformed(ActionEvent)", 5234).addDetail("e", actionEvent)).log();
                }
                String string = actionEvent.getActionCommand();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.ActionHandler.actionPerformed(ActionEvent)", 5237).add("name", string)).log();
                }
                if ("up".equals(string)) {
                    Table.this.moveUp();
                } else if ("down".equals(string)) {
                    Table.this.moveDown();
                } else if ("insert".equals(string)) {
                    Table.this.insertRow();
                } else if ("remove".equals(string)) {
                    Table.this.delete();
                } else if ("edit".equals(string)) {
                    Table.this.editRow();
                } else if ("ctrl-up".equals(string)) {
                    Table.this.ctrlUp();
                } else if ("ctrl-down".equals(string)) {
                    Table.this.ctrlDown();
                } else if ("ctrl-left".equals(string)) {
                    Table.this.ctrlLeft();
                } else if ("ctrl-right".equals(string)) {
                    Table.this.ctrlRight();
                } else if ("toggle".equals(string)) {
                    Table.this.toggleSelection();
                } else if ("cut".equals(string)) {
                    Table.this.cut();
                } else if ("copy".equals(string)) {
                    Table.this.copy();
                } else if ("paste".equals(string)) {
                    Table.this.paste();
                } else if ("addcolumn".equals(string)) {
                    int n = Table.this.getColumnModel().getSelectionModel().getMinSelectionIndex();
                    Table.this.insertColumn(n < 0 ? n : n + 1, null);
                } else if ("removecolumn".equals(string)) {
                    Table.this.removeColumn(-1);
                } else if ("editcolumn".equals(string)) {
                    Table.this.editColumn(-1);
                }
            }
        }

        protected class CellEditorRemover
        implements PropertyChangeListener {
            private KeyboardFocusManager focusManager;

            public CellEditorRemover(KeyboardFocusManager keyboardFocusManager) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.CellEditorRemover.CellEditorRemover(KeyboardFocusManager)", 5175).addDetail("fm", keyboardFocusManager)).log();
                }
                this.focusManager = keyboardFocusManager;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "Table.CellEditorRemover.propertyChange(PropertyChangeEvent)", 5184).addDetail("ev", propertyChangeEvent)).log();
                }
                if (!Table.this.isEditing() || Table.this.getClientProperty("terminateEditOnFocusLost") != Boolean.TRUE) {
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.CellEditorRemover.propertyChange(PropertyChangeEvent)", 5189).add("Not required - no edit.")).log();
                    }
                    return;
                }
                for (Component component = this.focusManager.getPermanentFocusOwner(); component != null; component = component.getParent()) {
                    if (component == Table.this) {
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.CellEditorRemover.propertyChange(PropertyChangeEvent)", 5198).add("Table reached, leave.")).log();
                        }
                        return;
                    }
                    if (!(component instanceof Window)) continue;
                    if (component != SwingUtilities.getRoot(Table.this) || Table.this.getCellEditor().stopCellEditing()) break;
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Table.CellEditorRemover.propertyChange(PropertyChangeEvent)", 5204).add("Cancel editor, if possible.")).log();
                    }
                    Table.this.getCellEditor().cancelCellEditing();
                    break;
                }
            }
        }
    }

    protected class Model
    extends DefaultTableModel {
        protected HashMap highlightMap;
        private boolean customBooleanHighlighting;

        public Model(Object[][] objectArray, int n) {
            super(objectArray, new Object[n]);
            this.highlightMap = new HashMap();
            this.customBooleanHighlighting = false;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.Model(Object[][],int)", 2350).addDetail("data", objectArray)).addDetail("col", n)).log();
            }
            Vector<String> vector = new Vector<String>();
            for (int i = 0; i < TableOptionEdit.this.columns.length; ++i) {
                vector.addElement(TableOptionEdit.this.columns[i].id);
            }
            this.setColumnIdentifiers(vector);
        }

        public Class getColumnClass(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.getColumnClass(int)", 2376).addDetail("column", n)).log();
            }
            if (n >= TableOptionEdit.this.columns.length) {
                return super.getColumnClass(n);
            }
            return TableOptionEdit.this.columns[n].clazz;
        }

        @Override
        public String getColumnName(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.getColumnName(int)", 2396).addDetail("column", n)).log();
            }
            if (n > TableOptionEdit.this.columns.length) {
                return "";
            }
            return TableOptionEdit.this.columns[n].name;
        }

        @Override
        public void addColumn(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.addColumn(Object)", 2415).addDetail("identifier", object)).log();
            }
            super.addColumn(object);
            this.setIdentifiers();
        }

        public void removeColumn(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.removeColumn(int)", 2429).addDetail("idx", n)).log();
            }
            if (n < 0 || n >= this.columnIdentifiers.size()) {
                return;
            }
            this.columnIdentifiers.remove(n);
            Iterator iterator = this.dataVector.iterator();
            while (iterator.hasNext()) {
                ((Vector)iterator.next()).remove(n);
            }
            this.fireTableStructureChanged();
            this.setIdentifiers();
        }

        public void setIdentifiers() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Model.setIdentifiers()", 2448).log();
            }
            SwingUtil.verifyDispatchThread(logger, "TableOptionEdit.setIdentifiers()");
            for (int i = 0; i < TableOptionEdit.this.columns.length; ++i) {
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Model.setIdentifiers()", 2453).add("id: ")).add("columns[i].id", TableOptionEdit.this.columns[i].id)).log();
                }
                TableOptionEdit.this.table.getColumnModel().getColumn(i).setIdentifier(TableOptionEdit.this.columns[i].id);
                TableOptionEdit.this.table.getColumnModel().getColumn(i).setCellRenderer(TableOptionEdit.this.columns[i].renderer);
                TableOptionEdit.this.table.getColumnModel().getColumn(i).setCellEditor(TableOptionEdit.this.columns[i].editor);
            }
        }

        public boolean isAnyHighlightDataAvailable() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Model.isAnyHighlightDataAvailable()", 2471).log();
            }
            return !this.highlightMap.isEmpty();
        }

        public boolean isHighlightDataAvailable(int n, int n2) {
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>(n, n2);
            return this.highlightMap.containsKey(pair);
        }

        public Object getHighlightData(int n, int n2) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.getHighlightData(int,int)", 2503).addDetail("row", n)).addDetail("column", n2)).log();
            }
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>(n, n2);
            return this.highlightMap.get(pair);
        }

        public void addHighlightData(int n, int n2, int n3, int n4, String string, int n5) {
            JTextComponent jTextComponent;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.addHighlightData(int,int,int,int,String,int)", 2522).addDetail("row", n)).addDetail("column", n2)).addDetail("start", n3)).addDetail("end", n4)).addDetail("value", string)).addDetail("messageType", n5)).log();
            }
            Pair<Integer, Integer> pair = new Pair<Integer, Integer>(n, n2);
            if (TableOptionEdit.this.caneditcolumn && n == 0) {
                string = TableOptionEdit.this.table.getColumnModel().getColumn(TableOptionEdit.this.table.convertColumnIndexToView(n2)).getHeaderValue().toString();
            }
            if (this.highlightMap.containsKey(pair)) {
                Object object = this.highlightMap.get(pair);
                if (object != null && object instanceof ResizableMultiLineScrollPane) {
                    object = ((ResizableMultiLineScrollPane)object).getTextComponent();
                }
                if (object instanceof JTextComponent) {
                    jTextComponent = (JTextComponent)object;
                    if (Misc.emptyOrNull(string) && !Misc.emptyOrNull(jTextComponent.getText())) {
                        if (logger.level >= 8) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "Model.addHighlightData(int,int,int,int,String,int)", 2547).add("Value of highlighted cell changed: ")).add(string)).add(" != ")).add(jTextComponent.getText())).add(". Discard highlight info")).log();
                        }
                        this.highlightMap.remove(pair);
                    } else if (!jTextComponent.getText().equals(string.toString())) {
                        if (logger.level >= 8) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "Model.addHighlightData(int,int,int,int,String,int)", 2551).add("Value of highlighted cell changed: ")).add(string)).add(" != ")).add(jTextComponent.getText())).add(". Discard highlight info")).log();
                        }
                        this.highlightMap.remove(pair);
                    } else {
                        this.highlightText(jTextComponent, n3, n4);
                        this.highlightMap.put(pair, jTextComponent);
                        if (logger.level >= 8) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "Model.addHighlightData(int,int,int,int,String,int)", 2557).add("Highlight added to cell: ")).add(string)).log();
                        }
                        this.repaintCellAndScrollVisibleOnce(n, n2);
                        return;
                    }
                }
            }
            if (this.isColumnClassHighlightingTextField(string, n, n2) || TableOptionEdit.this.caneditcolumn && n == 0) {
                jTextComponent = null;
                jTextComponent = TableOptionEdit.this.caneditcolumn && n == 0 ? new JTextField("") : new RendererTextField("");
                if (Misc.emptyOrNull(string)) {
                    jTextComponent.setBackground(TableOptionEdit.this.getHighlightingColorNonTransparent(n5));
                } else {
                    jTextComponent.setText(string.toString());
                    this.highlightText(jTextComponent, n3, n4);
                }
                this.highlightMap.put(pair, jTextComponent);
            } else if (this.getColumnClass(n2) == Boolean.class || this.isCustomBooleanHighlighting()) {
                this.highlightMap.put(pair, Boolean.valueOf(string.toString()));
            }
            if (logger.level >= 8) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(8, "Model.addHighlightData(int,int,int,int,String,int)", 2586).add("Highlight created in cell: ")).add(string)).log();
            }
            this.repaintCellAndScrollVisibleOnce(n, n2);
        }

        protected boolean isColumnClassHighlightingTextField(String string, int n, int n2) {
            return this.getColumnClass(n2) == String.class || this.getColumnClass(n2) == Integer.class;
        }

        public void clearHighlightData() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Model.clearHighlightData()", 2615).log();
            }
            this.highlightMap.clear();
        }

        protected void highlightText(JTextComponent jTextComponent, int n, int n2) {
            block4: {
                Highlighter highlighter;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.highlightText(JTextComponent,int,int)", 2634).addDetail("text", jTextComponent)).addDetail("start", n)).addDetail("end", n2)).log();
                }
                if ((highlighter = jTextComponent.getHighlighter()) != null && highlighter instanceof DefaultHighlighter) {
                    try {
                        Object object = highlighter.addHighlight(n, n2, new DefaultHighlighter.DefaultHighlightPainter(TableOptionEdit.this.getHighlightingColor()));
                    }
                    catch (BadLocationException badLocationException) {
                        if (logger.level < 3) break block4;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "Model.highlightText(JTextComponent,int,int)", 2644).add("ex", badLocationException)).log();
                    }
                }
            }
        }

        protected void repaintCellAndScrollVisibleOnce(int n, int n2) {
            int n3 = TableOptionEdit.this.table.convertColumnIndexToView(n2);
            if (TableOptionEdit.this.caneditcolumn && n == 0) {
                JTableHeader jTableHeader = TableOptionEdit.this.table.getTableHeader();
                jTableHeader.repaint(jTableHeader.getHeaderRect(TableOptionEdit.this.table.convertColumnIndexToView(n2)));
                TableOptionEdit.this.table.scrollToVisible(n, n3, true, true);
            } else {
                int n4 = n - (TableOptionEdit.this.caneditcolumn ? 1 : 0);
                TableOptionEdit.this.table.repaint(TableOptionEdit.this.table.getCellRect(n4, n3, true));
                TableOptionEdit.this.table.scrollToVisible(n4, n3, true, true);
            }
        }

        @Generated
        public boolean isCustomBooleanHighlighting() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Model.isCustomBooleanHighlighting()", 2332).log();
            }
            return this.customBooleanHighlighting;
        }

        @Generated
        public Model setCustomBooleanHighlighting(boolean bl) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "Model.setCustomBooleanHighlighting(boolean)", 2333).addDetail("customBooleanHighlighting", bl)).log();
            }
            this.customBooleanHighlighting = bl;
            return this;
        }
    }

    protected class Column {
        public String id;
        public String name;
        public String type;
        public Class clazz;
        public Object dflt;
        public Option option;
        public boolean disabled;
        public boolean directedit;
        public boolean canescaperegex;
        public int width;
        public TableCellRenderer renderer;
        public TableCellEditor editor;
        public boolean mayContainBlanks;

        public Column(String string) {
            block5: {
                this.width = -1;
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "Column.Column(String)", 2184).addDetail("id", string)).log();
                }
                String string2 = TableOptionEdit.this.option.getName() + ".column." + string;
                this.id = string;
                this.name = TableOptionEdit.this.getString("column." + string + ".name", string);
                this.type = TableOptionEdit.this.getString("column." + string + ".type", "string");
                this.canescaperegex = TableOptionEdit.this.getBoolean("column." + string + ".canescaperegex", false);
                this.initializeColumnTypes(string2);
                String string3 = TableOptionEdit.this.getString("column." + string + ".default", null);
                if (string3 != null) {
                    try {
                        this.dflt = this.clazz.getConstructor(String.class).newInstance(string3);
                    }
                    catch (Exception exception) {
                        if (logger.level < 1) break block5;
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "Column.Column(String)", 2202).add("ex", exception)).log();
                    }
                }
            }
            this.disabled = TableOptionEdit.this.getBoolean("column." + string + ".disabled", false);
            this.width = TableOptionEdit.this.getInt("column." + string + ".cwidth", -1);
            this.directedit = TableOptionEdit.this.getBoolean("column." + string + ".directedit", TableOptionEdit.this.directedit);
            this.mayContainBlanks = TableOptionEdit.this.getBoolean("column." + string + ".maycontainblanks", true);
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "Column.Column(String)", 2214).add("New column: ")).add(this)).log();
            }
        }

        public void initializeColumnTypes(String string) {
            block19: {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "Column.initializeColumnTypes(String)", 2226).addDetail("col", string)).log();
                }
                if ("string".equals(this.type)) {
                    this.clazz = String.class;
                    this.option = new StringOption(string, null, TableOptionEdit.this.getBoolean("column." + this.id + ".nullok", false));
                } else if ("text".equals(this.type)) {
                    this.clazz = String.class;
                    this.option = new TextOption(string, null, TableOptionEdit.this.getBoolean("column." + this.id + ".nullok", true));
                    if (logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "Column.initializeColumnTypes(String)", 2238).add("option", this.option)).log();
                    }
                    this.editor = new MultiLineTableCellEditor();
                } else if ("int".equals(this.type)) {
                    this.clazz = Integer.class;
                    this.option = new IntegerOption(string, 0, TableOptionEdit.this.getBoolean("column." + this.id + ".nullok", false), TableOptionEdit.this.getBoolean("column." + this.id + ".negativeok", false));
                } else if ("boolean".equals(this.type)) {
                    this.clazz = Boolean.class;
                    this.option = new BooleanOption(string, false);
                } else {
                    if ("choice".equals(this.type)) {
                        this.clazz = Integer.class;
                        this.option = new ChoiceOption(string, 0);
                        try {
                            int n = Integer.parseInt(TableOptionEdit.this.getString("column." + this.id + ".numchoices", "string"));
                            Object[] objectArray = new String[n];
                            for (int i = 0; i < n; ++i) {
                                objectArray[i] = TableOptionEdit.this.getString("column." + this.id + ".choice" + (i + 1), "string");
                            }
                            this.renderer = new ChoiceRenderer(objectArray);
                            this.editor = new ChoiceEditor(true, objectArray);
                        }
                        catch (Throwable throwable) {
                            if (logger.level >= 1) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(1, "Column.initializeColumnTypes(String)", 2264).add("ex", throwable)).log();
                            }
                            break block19;
                        }
                    }
                    if ("stringchoice".equals(this.type)) {
                        this.clazz = String.class;
                        this.option = new ChoiceOption(string, "");
                        try {
                            int n = Integer.parseInt(TableOptionEdit.this.getString("column." + this.id + ".numchoices", "string"));
                            Object[] objectArray = new String[n];
                            for (int i = 0; i < n; ++i) {
                                objectArray[i] = TableOptionEdit.this.getString("column." + this.id + ".choice" + (i + 1), "string");
                            }
                            this.renderer = new ChoiceRenderer(objectArray);
                            this.editor = new ChoiceEditor(false, objectArray);
                        }
                        catch (Throwable throwable) {
                            if (logger.level < 1) break block19;
                            ((LevelAwareLogBuilder)logger.lvlBuild(1, "Column.initializeColumnTypes(String)", 2279).add("ex", throwable)).log();
                        }
                    }
                }
            }
        }

        public String toString() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "Column.toString()", 2296).log();
            }
            return super.toString() + "[id=" + this.id + ",name=" + this.name + ",clazz=" + this.clazz + ",dflt=" + this.dflt + ",disabled=" + this.disabled + ",directedit=" + this.directedit + "]";
        }
    }

    public static class SelectedRowsAndColumn {
        final int[] rows;
        int column;

        public boolean isValid() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "SelectedRowsAndColumn.isValid()", 1856).log();
            }
            return !Misc.emptyOrNull((Object)this.rows);
        }

        @Generated
        public int[] getRows() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "SelectedRowsAndColumn.getRows()", 1853).log();
            }
            return this.rows;
        }

        @Generated
        public int getColumn() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "SelectedRowsAndColumn.getColumn()", 1854).log();
            }
            return this.column;
        }

        @Generated
        public SelectedRowsAndColumn setColumn(int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "SelectedRowsAndColumn.setColumn(int)", 1849).addDetail("column", n)).log();
            }
            this.column = n;
            return this;
        }

        @Generated
        public boolean equals(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "SelectedRowsAndColumn.equals(Object)", 1849).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof SelectedRowsAndColumn)) {
                return false;
            }
            SelectedRowsAndColumn selectedRowsAndColumn = (SelectedRowsAndColumn)object;
            if (!selectedRowsAndColumn.canEqual(this)) {
                return false;
            }
            if (this.getColumn() != selectedRowsAndColumn.getColumn()) {
                return false;
            }
            return Arrays.equals(this.getRows(), selectedRowsAndColumn.getRows());
        }

        @Generated
        protected boolean canEqual(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "SelectedRowsAndColumn.canEqual(Object)", 1849).addDetail("other", object)).log();
            }
            return object instanceof SelectedRowsAndColumn;
        }

        @Generated
        public int hashCode() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "SelectedRowsAndColumn.hashCode()", 1849).log();
            }
            int n = 1;
            n = n * 59 + this.getColumn();
            n = n * 59 + Arrays.hashCode(this.getRows());
            return n;
        }

        @Generated
        public String toString() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "SelectedRowsAndColumn.toString()", 1849).log();
            }
            return "TableOptionEdit.SelectedRowsAndColumn(rows=" + Arrays.toString(this.getRows()) + ", column=" + this.getColumn() + ")";
        }

        @Generated
        public SelectedRowsAndColumn(int[] nArray, int n) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "SelectedRowsAndColumn.SelectedRowsAndColumn(int[],int)", 1850).addDetail("rows", nArray)).addDetail("column", n)).log();
            }
            this.rows = nArray;
            this.column = n;
        }
    }
}

