/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.group;

import de.qfs.lib.gui.Grid;
import de.qfs.lib.gui.Message;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.KeyOption;
import de.qfs.lib.option.KeyOptionsState;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionGroupTreeAdapter;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.edit.DynamicChangingEdit;
import de.qfs.lib.option.edit.KeyOptionEdit;
import de.qfs.lib.option.edit.OptionEdit;
import de.qfs.lib.option.edit.OptionEditCallbacks;
import de.qfs.lib.option.group.NestedOptionGroup;
import de.qfs.lib.option.group.PlainOptionGroup;
import de.qfs.lib.option.group.RadioOptionGroup;
import de.qfs.lib.option.group.TabbedOptionGroup;
import de.qfs.lib.option.group.TreeOptionGroup;
import de.qfs.lib.option.group.WeightedOptionGroup;
import de.qfs.lib.option.group.WizardOptionGroup;
import de.qfs.lib.tree.Traversal;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeUtil;
import de.qfs.lib.util.MapResourceBundle;
import de.qfs.lib.util.Misc;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import lombok.Generated;

public abstract class OptionGroup {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.group.OptionGroup");
    public static final Color DEFAULT_SEARCH_MARK_COLOR = OptionEdit.DEFAULT_SEARCH_MARK_COLOR;
    protected static int editHorizontalDistance = 5;
    protected static int editVerticalDistance = 5;
    protected OptionGroup parent;
    protected List members;
    protected String name;
    protected OptionSet options;
    protected TitledBorder titleBorder;
    protected String title;
    protected boolean disabled;
    protected boolean enabled;
    protected double weight;
    private static Map groups = new HashMap();
    protected boolean isMarked;

    protected OptionGroup() {
        this.enabled = true;
        this.weight = 0.0;
        this.isMarked = false;
    }

    public OptionGroup(String string, OptionSet optionSet) {
        block4: {
            this.enabled = true;
            this.weight = 0.0;
            this.isMarked = false;
            if (OptionGroup.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "OptionGroup(String,OptionSet)", 203).addDetail("name", string)).addDetail("options", optionSet)).log();
            }
            this.name = string;
            this.options = optionSet;
            this.members = new ArrayList();
            this.disabled = this.getBoolean("disabled", false);
            String string2 = this.getString("weight", null);
            if (string2 != null) {
                try {
                    this.weight = Double.valueOf(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (OptionGroup.logger.level < 3) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "OptionGroup(String,OptionSet)", 214).add("ex", numberFormatException)).log();
                }
            }
        }
    }

    public static OptionGroup getGroup(String string, OptionSet optionSet) {
        OptionGroup optionGroup;
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getGroup(String,OptionSet)", 236).addDetail("name", string)).addDetail("options", optionSet)).log();
        }
        if ((optionGroup = (OptionGroup)groups.get(string)) == null) {
            optionGroup = OptionGroup.makeGroup(string, optionSet);
            if (optionGroup != null) {
                groups.put(string, optionGroup);
            }
        } else {
            optionGroup.update(optionSet);
        }
        return optionGroup;
    }

    public static OptionGroup makeGroup(String string, OptionSet optionSet) {
        Predicate<String> predicate;
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "makeGroup(String,OptionSet)", 271).addDetail("name", string)).addDetail("options", optionSet)).log();
        }
        if ((predicate = OptionEditCallbacks.getMakeOptionEditFilter()) != null && !predicate.test("option.group." + string)) {
            return null;
        }
        String string2 = Option.getResources().getString("option.group." + string + ".type", null);
        if (string2 == null) {
            if (OptionGroup.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "makeGroup(String,OptionSet)", 283).add("No type for OptionGroup ")).add(string)).log();
            }
            return null;
        }
        if (string2.equals("plain")) {
            return new PlainOptionGroup(string, optionSet);
        }
        if (string2.equals("weighted")) {
            return new WeightedOptionGroup(string, optionSet);
        }
        if (string2.equals("nested")) {
            return new NestedOptionGroup(string, optionSet);
        }
        if (string2.equals("radio")) {
            return new RadioOptionGroup(string, optionSet);
        }
        if (string2.equals("tab")) {
            return new TabbedOptionGroup(string, optionSet);
        }
        if (string2.equals("tree")) {
            return new TreeOptionGroup(string, optionSet);
        }
        if (string2.equals("wizard")) {
            return new WizardOptionGroup(string, optionSet);
        }
        if (string2.equals("custom")) {
            String string3 = Option.getResources().getString("option.group." + string + ".class", null);
            if (string3 == null) {
                if (OptionGroup.logger.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "makeGroup(String,OptionSet)", 311).add("No class for custom OptionGroup ")).add(string)).log();
                }
                return null;
            }
            try {
                ClassLoader classLoader = OptionGroup.class.getClassLoader();
                Class<?> clazz = classLoader == null ? Class.forName(string3) : classLoader.loadClass(string3);
                Constructor<?> constructor = clazz.getConstructor(String.class, OptionSet.class);
                return (OptionGroup)constructor.newInstance(string, optionSet);
            }
            catch (InvocationTargetException invocationTargetException) {
                if (OptionGroup.logger.level >= 1) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "makeGroup(String,OptionSet)", 327).add("ex.getTargetException()", invocationTargetException.getTargetException())).log();
                }
                return null;
            }
            catch (Exception exception) {
                if (OptionGroup.logger.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "makeGroup(String,OptionSet)", 330).add("ex", exception)).add("name", string)).add("class", string3)).log();
                }
                return null;
            }
        }
        if (OptionGroup.logger.level >= 1) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "makeGroup(String,OptionSet)", 334).add("Unknown OptionType ")).add(string2)).add(" for OptionGroup ")).add(string)).log();
        }
        return null;
    }

    public static final int getEditVerticalDistance() {
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getEditVerticalDistance()", 351).log();
        }
        return editVerticalDistance;
    }

    public static final void setEditHorizontalDistance(int n) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEditHorizontalDistance(int)", 364).addDetail("_editHorizontalDistance", n)).log();
        }
        editHorizontalDistance = n;
    }

    public static final void setEditVerticalDistance(int n) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEditVerticalDistance(int)", 377).addDetail("_editVerticalDistance", n)).log();
        }
        editVerticalDistance = n;
    }

    public static void fixSpacingOfHierarchy(OptionGroup optionGroup, boolean bl) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fixSpacingOfHierarchy(OptionGroup,boolean)", 391).addDetail("root", optionGroup)).addDetail("findRoot", bl)).log();
        }
        OptionGroupTreeAdapter optionGroupTreeAdapter = new OptionGroupTreeAdapter();
        if (bl) {
            optionGroup = (OptionGroup)TreeUtil.getRoot(optionGroupTreeAdapter, optionGroup);
            if (OptionGroup.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "fixSpacingOfHierarchy(OptionGroup,boolean)", 396).add("root", optionGroup)).log();
            }
        }
        TreeUtil.traverse(optionGroupTreeAdapter, optionGroup, new TraversalCallback(){

            @Override
            public boolean nodeEntered(Traversal traversal) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "fixSpacingOfHierarchy(OptionGroup,boolean).TraversalCallback.nodeEntered(Traversal)", 399).addDetail("traversal", traversal)).log();
                }
                if (traversal.getNode() instanceof OptionGroup) {
                    ((OptionGroup)traversal.getNode()).fixSpacing();
                }
                return !(traversal.getNode() instanceof TreeOptionGroup);
            }

            @Override
            public void nodeExited(Traversal traversal) {
                if (logger.level >= 7) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(7, "fixSpacingOfHierarchy(OptionGroup,boolean).TraversalCallback.nodeExited(Traversal)", 406).addDetail("traversal", traversal)).log();
                }
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public boolean isModified() {
        for (int i = 0; i < this.getMemberCount(); ++i) {
            Object object = this.getMember(i);
            if (object instanceof OptionGroup && ((OptionGroup)object).isModified()) {
                if (OptionGroup.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 446).add("modified member", object)).log();
                }
                return true;
            }
            if (!(object instanceof OptionEdit) || !((OptionEdit)object).isModified()) continue;
            if (OptionGroup.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "isModified()", 451).add("modified member", object)).log();
            }
            return true;
        }
        return false;
    }

    public boolean isSuspect() {
        for (int i = 0; i < this.getMemberCount(); ++i) {
            Object object = this.getMember(i);
            if (object instanceof OptionGroup && ((OptionGroup)object).isSuspect()) {
                return true;
            }
            if (!(object instanceof OptionEdit) || !((OptionEdit)object).isSuspect()) continue;
            return true;
        }
        return false;
    }

    public boolean checkValues() {
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "checkValues()", 493).log();
        }
        if (this.isDisabled()) {
            return true;
        }
        for (Object e : this.members) {
            if (!(e instanceof OptionGroup ? !((OptionGroup)e).checkValues() : !((OptionEdit)e).isDisabled() && !((OptionEdit)e).checkValue())) continue;
            return false;
        }
        for (Object e : this.members) {
            KeyOption keyOption;
            KeyOptionsState keyOptionsState;
            String string;
            if (!(e instanceof KeyOptionEdit)) continue;
            KeyOptionEdit keyOptionEdit = (KeyOptionEdit)e;
            KeyOption.Data data = keyOptionEdit.getHotkey();
            if (!data.isUndefined() && (string = (keyOptionsState = KeyOptionsState.instance()).getOptionNameHotkeyPotentiallyInUseFor(keyOption = new KeyOption(keyOptionEdit.getOption().getName(), data))) != null) {
                String string2 = this.getOptionNameForMessageParameter(string);
                Message.showMessageAndHighlight(keyOptionEdit, "option.error.hotkeyInUse", new Object[]{string2});
                keyOptionEdit.requestKeyFocus();
                return false;
            }
            keyOptionEdit.dehighlight();
        }
        return true;
    }

    private String getOptionNameForMessageParameter(String string) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getOptionNameForMessageParameter(String)", 537).addDetail("optionHotkeyPotentiallyInUseFor", string)).log();
        }
        String string2 = String.format("option.%s.label", string);
        MapResourceBundle mapResourceBundle = new MapResourceBundle();
        mapResourceBundle.fetchProperties("/de/qfs/lib/resources/properties/qflib", OptionGroup.class);
        return mapResourceBundle.getString(string2);
    }

    public void readValues() {
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "readValues()", 552).log();
        }
        for (Object e : this.members) {
            if (e instanceof OptionGroup) {
                ((OptionGroup)e).readValues();
                continue;
            }
            ((OptionEdit)e).readValue();
        }
    }

    public void notifyOptionObservers() {
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "notifyOptionObservers()", 570).log();
        }
        for (Object e : this.members) {
            if (e instanceof OptionGroup) {
                ((OptionGroup)e).notifyOptionObservers();
                continue;
            }
            ((OptionEdit)e).getOption().notifyObservers();
        }
    }

    public final OptionSet getOptions() {
        return this.options;
    }

    public void update(OptionSet optionSet) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "update(OptionSet)", 605).addDetail("options", optionSet)).log();
        }
        this.options = optionSet;
        for (Object e : this.members) {
            if (e instanceof OptionGroup) {
                ((OptionGroup)e).update(optionSet);
                continue;
            }
            ((OptionEdit)e).update(optionSet);
        }
    }

    public void setEnabled(boolean bl) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEnabled(boolean)", 626).addDetail("enabled", bl)).log();
        }
        if (this.disabled) {
            bl = false;
        }
        this.enabled = bl;
        if (this.members != null) {
            for (Object e : this.members) {
                if (e instanceof OptionGroup) {
                    ((OptionGroup)e).setEnabled(bl);
                    continue;
                }
                ((OptionEdit)e).setEnabled(bl);
            }
        }
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean bl) {
        this.disabled = bl;
        if (bl) {
            this.setEnabled(false);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
        if (this.titleBorder != null) {
            this.titleBorder.setTitle(string);
        }
    }

    public final double getWeight() {
        return this.weight;
    }

    public final void setWeight(double d) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setWeight(double)", 735).addDetail("weight", d)).log();
        }
        this.weight = d;
    }

    public void setVisible(boolean bl) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setVisible(boolean)", 748).addDetail("visibility", bl)).log();
        }
        this.getComponent().setVisible(bl);
    }

    public void setVisible(boolean bl, boolean bl2) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setVisible(boolean,boolean)", 765).addDetail("visibility", bl)).addDetail("checkNeighborFillers", bl2)).log();
        }
        this.getComponent().setVisible(bl);
        if (bl2) {
            OptionGroup.fixSpacingOfHierarchy(this, true);
        }
    }

    public boolean isVisible() {
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "isVisible()", 777).log();
        }
        return this.getComponent().isVisible();
    }

    public void fixSpacing() {
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "fixSpacing()", 790).log();
        }
        if (!(this.getComponent() instanceof Grid)) {
            return;
        }
        Grid grid = (Grid)this.getComponent();
        Component[] componentArray = grid.getComponents();
        if (componentArray != null) {
            boolean bl = true;
            for (Component component : componentArray) {
                if (OptionGroup.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "fixSpacing()", 800).add("com", component)).log();
                }
                if (component instanceof Box.Filler) {
                    bl |= component.getMaximumSize().height > 30000;
                    if (OptionGroup.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "fixSpacing()", 804).add("Filler visibility", bl)).log();
                    }
                    component.setVisible(bl);
                    bl = false;
                    continue;
                }
                boolean bl2 = bl = component.isVisible() && component.getPreferredSize().width > 0 && component.getPreferredSize().height > 0;
                if (OptionGroup.logger.level < 9) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "fixSpacing()", 809).add("Member visibility", bl)).log();
            }
        }
    }

    public boolean matchesFilterText(Predicate<String> predicate) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "matchesFilterText(Predicate<String>)", 826).addDetail("matcher", predicate)).log();
        }
        if (predicate == null) {
            return true;
        }
        String string = this.getString("title", null);
        if (string != null && predicate.test(string)) {
            this.markSearchHit(true);
            return true;
        }
        String string2 = this.getString("aliases", null);
        if (string2 != null) {
            for (String string3 : Misc.fastSplit(string2, ',')) {
                if (!predicate.test(string3)) continue;
                this.markSearchHit(true);
                return true;
            }
        }
        if (this.isMarked) {
            this.markSearchHit(false);
        }
        return false;
    }

    public void markSearchHit(boolean bl) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "markSearchHit(boolean)", 864).addDetail("doMark", bl)).log();
        }
        if (bl == this.isMarked) {
            return;
        }
        this.isMarked = bl;
        if (this.titleBorder != null) {
            this.getComponent().repaint();
        }
    }

    public OptionGroup getParentGroup() {
        return this.parent;
    }

    public void setParentGroup(OptionGroup optionGroup) {
        if (OptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setParentGroup(OptionGroup)", 903).addDetail("parent", optionGroup)).log();
        }
        this.parent = optionGroup;
    }

    public int getMemberCount() {
        return this.members.size();
    }

    public List getMembers() {
        return this.members;
    }

    public Object getMember(int n) {
        return this.members.get(n);
    }

    public int getIndexOfMember(Object object) {
        return this.members.indexOf(object);
    }

    public OptionGroup findGroup(String string) {
        int n = this.getMemberCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getMember(i);
            if (!(object instanceof OptionGroup)) continue;
            if (string.equals(((OptionGroup)object).getName())) {
                return (OptionGroup)object;
            }
            OptionGroup optionGroup = ((OptionGroup)object).findGroup(string);
            if (optionGroup == null) continue;
            return optionGroup;
        }
        return null;
    }

    public OptionEdit findEdit(String string) {
        int n = this.getMemberCount();
        for (int i = 0; i < n; ++i) {
            Object object = this.getMember(i);
            if (object instanceof OptionGroup) {
                OptionEdit optionEdit = ((OptionGroup)object).findEdit(string);
                if (optionEdit == null) continue;
                return optionEdit;
            }
            if (!(object instanceof OptionEdit) || !string.equals(((OptionEdit)object).getOption().getName())) continue;
            return (OptionEdit)object;
        }
        return null;
    }

    public abstract Component getComponent();

    public String getResourceName() {
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getResourceName()", 1053).log();
        }
        return "option.group." + this.name;
    }

    protected String getString(String string, String string2) {
        return Option.getResources().getString(this.getResourceName() + "." + string, string2);
    }

    protected boolean getBoolean(String string, boolean bl) {
        return Option.getResources().getBoolean(this.getResourceName() + "." + string, bl);
    }

    protected int getInt(String string, int n) {
        return Option.getResources().getInt(this.getResourceName() + "." + string, n);
    }

    protected void createMembers() {
        Object object;
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "createMembers()", 1129).log();
        }
        this.members = new ArrayList();
        String string = this.getString("members", null);
        if (string == null) {
            if (OptionGroup.logger.level >= 1) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "createMembers()", 1134).add("No Members for OptionGroup ")).add(this.name)).log();
            }
            return;
        }
        if (string.startsWith("sameas.")) {
            object = string.substring("sameas.".length());
            string = Option.getResources().getString("option.group." + (String)object + ".members", null);
            if (string == null) {
                if (OptionGroup.logger.level >= 1) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "createMembers()", 1143).add("No Members for referenced group ")).add((String)object)).log();
                }
                return;
            }
        }
        if (OptionGroup.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "createMembers()", 1147).add("this", this)).add("elems", string)).log();
        }
        object = new StringTokenizer(string, " ");
        while (((StringTokenizer)object).hasMoreTokens()) {
            Object object2;
            String string2 = ((StringTokenizer)object).nextToken();
            if (OptionGroup.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "createMembers()", 1152).add("elem", string2)).log();
            }
            if (string2.startsWith("group.")) {
                object2 = OptionGroup.makeGroup(string2 = string2.substring("group.".length()), this.options);
                if (object2 == null) continue;
                ((OptionGroup)object2).setParentGroup(this);
                boolean bl = this.getBoolean(string2 + ".enabled", true);
                if (!bl) {
                    ((OptionGroup)object2).setEnabled(false);
                }
                this.members.add(object2);
                continue;
            }
            object2 = this.options.getOption(string2);
            if (OptionGroup.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "createMembers()", 1166).add("option", object2)).log();
            }
            if (object2 == null) {
                if (OptionGroup.logger.level < 1) continue;
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "createMembers()", 1168).add("unknown Option", string2)).log();
                continue;
            }
            if (!OptionEdit.filterOption((Option)object2)) continue;
            OptionEdit optionEdit = OptionEdit.makeEdit((Option)object2);
            if (optionEdit == null) {
                if (OptionGroup.logger.level < 1) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "createMembers()", 1172).add("Cannot create option edit for Option ")).add(((Option)object2).getName())).log();
                continue;
            }
            optionEdit.setOptionGroup(this);
            boolean bl = this.getBoolean(string2 + ".enabled", true);
            if (!bl) {
                ((Component)optionEdit).setEnabled(false);
            }
            this.members.add(optionEdit);
        }
        this.updateDynamicMembers();
    }

    private void updateDynamicMembers() {
        if (OptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "updateDynamicMembers()", 1193).log();
        }
        for (Object e : this.members) {
            if (!(e instanceof DynamicChangingEdit)) continue;
            ((DynamicChangingEdit)e).updateOptions();
        }
    }

    protected void makeBorder(JComponent jComponent) {
        if (!this.getBoolean("frame", false)) {
            this.titleBorder = null;
            return;
        }
        this.titleBorder = new GroupBorder();
        this.titleBorder.setTitleFont(UIManager.getFont("Label.font"));
        int n = editHorizontalDistance * 3 / 5;
        int n2 = editVerticalDistance * 3 / 5;
        jComponent.setBorder(BorderFactory.createCompoundBorder(this.titleBorder, BorderFactory.createEmptyBorder(n2 - 3, n, n2, n)));
        if (this.title == null) {
            this.title = this.getString("title", null);
        }
        if (this.title != null) {
            this.titleBorder.setTitle(this.title);
        }
    }

    public class GroupBorder
    extends TitledBorder {
        public GroupBorder() {
            super(UIManager.getBorder("OptionGroup.lineBorder"));
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GroupBorder.GroupBorder()", 1249).log();
            }
        }

        @Override
        public Color getTitleColor() {
            Color color;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GroupBorder.getTitleColor()", 1259).log();
            }
            if ((color = UIManager.getColor(OptionGroup.this.enabled ? "OptionGroup.titleColor" : "OptionGroup.inactiveTitleColor")) == null) {
                color = UIManager.getColor(OptionGroup.this.enabled ? "Label.foreground" : "textInactiveText");
            }
            return color;
        }

        @Override
        public Border getBorder() {
            Border border;
            if (logger.level >= 7) {
                logger.lvlBuild(7, "GroupBorder.getBorder()", 1274).log();
            }
            if ((border = UIManager.getBorder(OptionGroup.this.isMarked ? "OptionGroup.markBorder" : (OptionGroup.this.enabled ? "OptionGroup.border" : "OptionGroup.inactiveBorder"))) == null) {
                border = BorderFactory.createLineBorder(OptionGroup.this.isMarked ? DEFAULT_SEARCH_MARK_COLOR : UIManager.getColor(OptionGroup.this.enabled ? "unifiedControlShadow" : "textInactiveText"));
            }
            return border;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "GroupBorder.paintBorder(Component,Graphics,int,int,int,int)", 1291).addDetail("c", component)).addDetail("g", graphics)).addDetail("x", n)).addDetail("y", n2)).addDetail("width", n3)).addDetail("height", n4)).log();
            }
            super.paintBorder(component, graphics, n - 2, n2, n3 + 2 + 2, n4);
        }
    }
}

