/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.option.group;

import de.qfs.lib.gui.Grid;
import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.option.Option;
import de.qfs.lib.option.OptionSet;
import de.qfs.lib.option.group.OptionGroup;
import de.qfs.lib.util.MapResourceBundle;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import lombok.Generated;

public class WizardOptionGroup
extends OptionGroup {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.option.group.WizardOptionGroup");
    protected JPanel pane;
    protected CardLayout layout;
    protected int numpanes;
    protected int current;

    public WizardOptionGroup() {
    }

    public WizardOptionGroup(String string, OptionSet optionSet) {
        super(string, optionSet);
        if (WizardOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "WizardOptionGroup(String,OptionSet)", 161).addDetail("name", string)).addDetail("options", optionSet)).log();
        }
        this.createMembers();
    }

    @Override
    public Component getComponent() {
        if (this.pane == null) {
            this.makePane();
        }
        return this.pane;
    }

    public boolean nextPane() {
        OptionGroup optionGroup = (OptionGroup)this.members.get(this.current);
        boolean bl = optionGroup.checkValues();
        if (!bl) {
            return false;
        }
        optionGroup.readValues();
        if (this.current < this.numpanes - 1) {
            ++this.current;
            ((OptionGroup)this.members.get(this.current)).update(this.options);
            this.layout.next(this.pane);
            this.resetFocus();
        }
        return true;
    }

    public boolean previousPane() {
        if (this.current > 0) {
            --this.current;
            ((OptionGroup)this.members.get(this.current)).update(this.options);
            this.layout.previous(this.pane);
            this.resetFocus();
            return true;
        }
        return false;
    }

    public boolean isFirst() {
        return this.current == 0;
    }

    public boolean isLast() {
        return this.current == this.numpanes - 1;
    }

    @Override
    protected void createMembers() {
        if (WizardOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "createMembers()", 277).log();
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        this.members = new ArrayList();
        this.numpanes = this.getInt("numpanes", -1);
        if (this.numpanes < 0 && WizardOptionGroup.logger.level >= 1) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "createMembers()", 284).add("No numpanes for WizardOptionGroup ")).add(this.name)).log();
        }
        for (int i = 1; i <= this.numpanes; ++i) {
            String string = this.getString("pane" + i + ".group", null);
            if (string == null) {
                if (WizardOptionGroup.logger.level < 1) continue;
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "createMembers()", 290).add("No group for pane ")).add(i)).add(" in WizardOptionGroup ")).add(this.name)).log();
                continue;
            }
            OptionGroup optionGroup = OptionGroup.makeGroup(string, this.options);
            if (optionGroup == null) continue;
            optionGroup.setParentGroup(this);
            this.members.add(optionGroup);
        }
    }

    protected void makePane() {
        if (WizardOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "makePane()", 307).log();
        }
        MapResourceBundle mapResourceBundle = Option.getResources();
        this.pane = new JPanel();
        this.pane.setName("OptionGroup-" + this.name + "-" + this.options.getConfigurableName());
        this.layout = new CardLayout();
        this.pane.setLayout(this.layout);
        for (int i = 0; i < this.members.size(); ++i) {
            OptionGroup optionGroup = (OptionGroup)this.members.get(i);
            Component component = optionGroup.getComponent();
            if (component instanceof Grid && ((Grid)component).needGlue()) {
                ((Grid)component).addGlue();
            }
            if (!(component instanceof JComponent) || ((JComponent)component).getBorder() != null) {
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BorderLayout());
                jPanel.add(component, "Center");
                component = jPanel;
            }
            ((JComponent)component).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.pane.add(component, optionGroup.getName());
        }
        if (this.disabled) {
            this.setEnabled(false);
        }
        this.makeBorder(this.pane);
    }

    protected void resetFocus() {
        FocusManager.getCurrentManager().focusNextComponent(this.pane);
    }

    @Generated
    public int getCurrent() {
        if (WizardOptionGroup.logger.level >= 7) {
            logger.lvlBuild(7, "getCurrent()", 133).log();
        }
        return this.current;
    }

    @Generated
    public WizardOptionGroup setCurrent(int n) {
        if (WizardOptionGroup.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCurrent(int)", 134).addDetail("current", n)).log();
        }
        this.current = n;
        return this;
    }
}

