/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.tree;

import de.qfs.lib.tree.TreeAdapter;
import java.util.Enumeration;

public abstract class IndexBasedTreeAdapter
implements TreeAdapter {
    @Override
    public boolean isIndexBased() {
        return true;
    }

    @Override
    public Object[] getChildren(Object object) {
        Object[] objectArray = new Object[this.getChildCount(object)];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = this.getChildNode(object, i);
        }
        return objectArray;
    }

    @Override
    public boolean isLinkBased() {
        return false;
    }

    @Override
    public Object getFirstChildNode(Object object) {
        return this.getChildNode(object, 0);
    }

    @Override
    public Object getLastChildNode(Object object) {
        return this.getChildNode(object, this.getChildCount(object) - 1);
    }

    @Override
    public Object getPreviousSibling(Object object) {
        Object object2 = this.getParentNode(object);
        if (object2 == null) {
            return null;
        }
        int n = this.getIndexOfChildNode(object2, object);
        if (n <= 0) {
            return null;
        }
        return this.getChildNode(object2, n - 1);
    }

    @Override
    public Object getNextSibling(Object object) {
        Object object2 = this.getParentNode(object);
        if (object2 == null) {
            return null;
        }
        int n = this.getIndexOfChildNode(object2, object);
        if (n < 0 || n >= this.getChildCount(object2) - 1) {
            return null;
        }
        return this.getChildNode(object2, n + 1);
    }

    @Override
    public boolean isEnumerationBased() {
        return false;
    }

    @Override
    public Enumeration enumerateChildren(Object object) {
        return new ChildEnumeration(object);
    }

    protected class ChildEnumeration
    implements Enumeration {
        private Object parent;
        private int index;

        public ChildEnumeration(Object object) {
            this.parent = object;
        }

        @Override
        public synchronized boolean hasMoreElements() {
            return this.index < IndexBasedTreeAdapter.this.getChildCount(this.parent);
        }

        public synchronized Object nextElement() {
            return IndexBasedTreeAdapter.this.getChildNode(this.parent, this.index++);
        }
    }
}

