/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.tree;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.AbstractTraversal;
import de.qfs.lib.tree.BreakTraversalException;
import de.qfs.lib.tree.MutableTraversal;
import de.qfs.lib.tree.MutableTreeAdapter;
import de.qfs.lib.tree.ReturnFromTraversalException;
import de.qfs.lib.tree.TraversalCallback;
import de.qfs.lib.tree.TreeAdapter;
import de.qfs.lib.tree.ValidatingTreeAdapter;
import java.util.HashMap;
import lombok.Generated;

public class IndexTraversal
extends AbstractTraversal
implements MutableTraversal {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.tree.IndexTraversal");
    boolean finished;
    boolean removed;
    private HashMap<Object, Integer> visitedNodes;
    private final boolean preValidate;
    public static boolean checkVisitedNodes = false;

    public IndexTraversal(TreeAdapter treeAdapter, Object object) {
        super(treeAdapter, object);
        if (IndexTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "IndexTraversal(TreeAdapter,Object)", 71).addDetail("adapter", treeAdapter)).addDetail("root", object)).log();
        }
        this.preValidate = treeAdapter instanceof ValidatingTreeAdapter;
        if (IndexTraversal.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "IndexTraversal(TreeAdapter,Object)", 75).add("preValidate", this.preValidate)).log();
        }
        if (checkVisitedNodes) {
            this.visitedNodes = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverse(TraversalCallback traversalCallback) throws ReturnFromTraversalException {
        block24: {
            if (IndexTraversal.logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "traverse(TraversalCallback)", 96).addDetail("callback", traversalCallback)).log();
            }
            try {
                boolean bl;
                Object object = this.getNode();
                if (checkVisitedNodes) {
                    if (this.visitedNodes.containsKey(object)) {
                        if (IndexTraversal.logger.level >= 1) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "traverse(TraversalCallback)", 103).add("node ")).add(object)).add(" already encountered")).log();
                        }
                        throw new ReturnFromTraversalException(object);
                    }
                    this.visitedNodes.put(object, 1);
                }
                if (this.preValidate && !(bl = ((ValidatingTreeAdapter)((Object)this.adapter)).isValid(object))) {
                    if (IndexTraversal.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "traverse(TraversalCallback)", 112).add("Skipping invalid node", object)).log();
                    }
                    return;
                }
                this.removed = false;
                bl = traversalCallback.nodeEntered(this);
                if (IndexTraversal.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "traverse(TraversalCallback)", 119).add("ret", bl)).log();
                }
                if (this.finished || this.removed) {
                    this.removed = false;
                    return;
                }
                if (!bl) {
                    traversalCallback.nodeExited(this);
                    return;
                }
                Object[] objectArray = this.adapter.getChildren(object);
                if (IndexTraversal.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "traverse(TraversalCallback)", 130).add("children", objectArray)).log();
                }
                if (!this.adapter.isLeaf(object) && objectArray.length > 0) {
                    try {
                        AbstractTraversal.Level level = this.currentLevel;
                        this.levels.push(level);
                        Object var6_7 = null;
                        this.currentLevel = new AbstractTraversal.Level(null);
                        this.currentLevel.index = -1;
                        for (Object object2 : objectArray) {
                            this.currentLevel.previous = this.currentLevel.node;
                            this.currentLevel.node = object2;
                            int n = ++this.currentLevel.index;
                            this.traverse(traversalCallback);
                            if (this.currentLevel.index < n) {
                                if (IndexTraversal.logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "traverse(TraversalCallback)", 146).add("Current node got removed")).log();
                                }
                                this.currentLevel.node = this.currentLevel.previous;
                            }
                            if (!this.finished) continue;
                            return;
                        }
                    }
                    finally {
                        this.currentLevel = (AbstractTraversal.Level)this.levels.pop();
                    }
                }
                if (IndexTraversal.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "traverse(TraversalCallback)", 158).add("Calling nodeExited")).log();
                }
                traversalCallback.nodeExited(this);
                this.removed = false;
            }
            catch (BreakTraversalException breakTraversalException) {
                if (IndexTraversal.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "traverse(TraversalCallback)", 162).add("ex", breakTraversalException)).log();
                }
                if (breakTraversalException.getLevels() > 0) {
                    breakTraversalException.setLevels(breakTraversalException.getLevels() - 1);
                    throw breakTraversalException;
                }
                if (breakTraversalException.getLevels() >= 0) break block24;
                throw breakTraversalException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void traverseFrom(TraversalCallback traversalCallback, Object[] objectArray) throws ReturnFromTraversalException {
        if (IndexTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "traverseFrom(TraversalCallback,Object[])", 185).addDetail("callback", traversalCallback)).addDetail("path", objectArray)).log();
        }
        Object object = this.getNode();
        if (IndexTraversal.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "traverseFrom(TraversalCallback,Object[])", 189).add("node", object)).log();
        }
        if (objectArray == null || objectArray[0] == object) {
            Object[] objectArray2;
            boolean bl;
            if (objectArray.length == 1) {
                if (this.preValidate && !(bl = ((ValidatingTreeAdapter)((Object)this.adapter)).isValid(object))) {
                    if (IndexTraversal.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "traverseFrom(TraversalCallback,Object[])", 197).add("Skipping invalid node", object)).log();
                    }
                    return;
                }
                bl = traversalCallback.nodeEntered(this);
                if (this.finished) {
                    return;
                }
                if (!bl) {
                    traversalCallback.nodeExited(this);
                    return;
                }
            }
            bl = true;
            if (objectArray != null && objectArray.length > 1) {
                objectArray2 = new Object[objectArray.length - 1];
                System.arraycopy(objectArray, 1, objectArray2, 0, objectArray2.length);
                objectArray = objectArray2;
            } else {
                bl = false;
                objectArray = null;
            }
            objectArray2 = this.adapter.getChildren(object);
            if (!this.adapter.isLeaf(object) && objectArray2.length > 0) {
                try {
                    AbstractTraversal.Level level = this.currentLevel;
                    this.levels.push(level);
                    Object object2 = null;
                    for (int i = 0; i < objectArray2.length; ++i) {
                        this.currentLevel = new AbstractTraversal.Level(objectArray2[i], object2, i);
                        object2 = this.currentLevel.node;
                        if (bl) {
                            this.traverseFrom(traversalCallback, objectArray);
                            if (object2 == objectArray[0]) {
                                bl = false;
                            }
                        } else {
                            this.traverse(traversalCallback);
                        }
                        if (!this.finished) continue;
                        return;
                    }
                }
                finally {
                    this.currentLevel = (AbstractTraversal.Level)this.levels.pop();
                }
            }
            traversalCallback.nodeExited(this);
        }
    }

    @Override
    public void finish() {
        if (IndexTraversal.logger.level >= 7) {
            logger.lvlBuild(7, "finish()", 264).log();
        }
        this.finished = true;
    }

    @Override
    public boolean removeNode() {
        Object object;
        if (IndexTraversal.logger.level >= 7) {
            logger.lvlBuild(7, "removeNode()", 282).log();
        }
        if (this.getParent() != null && this.adapter instanceof MutableTreeAdapter && (object = ((MutableTreeAdapter)this.adapter).removeNode(this.getParent(), this.currentLevel.index)) != null) {
            this.nodeRemoved();
            return true;
        }
        return false;
    }

    @Override
    public void nodeRemoved() {
        if (IndexTraversal.logger.level >= 7) {
            logger.lvlBuild(7, "nodeRemoved()", 304).log();
        }
        this.removed = true;
        this.currentLevel.node = this.currentLevel.previous;
        --this.currentLevel.index;
    }

    @Override
    public boolean insertNodeBefore(Object object) {
        boolean bl;
        if (IndexTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "insertNodeBefore(Object)", 322).addDetail("node", object)).log();
        }
        if (this.getParent() != null && this.adapter instanceof MutableTreeAdapter && (bl = ((MutableTreeAdapter)this.adapter).insertNodeBefore(this.getParent(), object, this.getNode()))) {
            this.nodeInsertedBefore(object);
            return true;
        }
        return false;
    }

    @Override
    public void nodeInsertedBefore(Object object) {
        if (IndexTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "nodeInsertedBefore(Object)", 348).addDetail("node", object)).log();
        }
        this.currentLevel.previous = object;
        ++this.currentLevel.index;
    }

    @Override
    public boolean insertNodeAfter(Object object) {
        boolean bl;
        if (IndexTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "insertNodeAfter(Object)", 365).addDetail("node", object)).log();
        }
        if (this.getParent() != null && this.adapter instanceof MutableTreeAdapter && (bl = ((MutableTreeAdapter)this.adapter).insertNodeAfter(this.getParent(), object, this.getNode()))) {
            this.nodeInsertedAfter(object);
            return true;
        }
        return false;
    }

    @Override
    public void nodeInsertedAfter(Object object) {
        if (IndexTraversal.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "nodeInsertedAfter(Object)", 390).addDetail("node", object)).log();
        }
    }
}

