/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.tree;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.tree.MutableTreeAdapter;
import de.qfs.lib.tree.NodeFactory;
import java.util.Vector;
import lombok.Generated;

public class TreeBuilder {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.tree.TreeBuilder");
    protected static final Object dummy = new Object();
    protected boolean first = true;
    protected MutableTreeAdapter adapter;
    protected NodeFactory factory;
    protected Object root;
    protected Object currentNode;
    protected Vector path = new Vector();

    public TreeBuilder(MutableTreeAdapter mutableTreeAdapter, NodeFactory nodeFactory) {
        if (TreeBuilder.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "TreeBuilder(MutableTreeAdapter,NodeFactory)", 80).addDetail("adapter", mutableTreeAdapter)).addDetail("factory", nodeFactory)).log();
        }
        this.adapter = mutableTreeAdapter;
        this.factory = nodeFactory;
    }

    public Object openNode(Object object) {
        if (TreeBuilder.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "openNode(Object)", 97).addDetail("data", object)).log();
        }
        Object object2 = this.factory.createNode(object);
        if (this.first) {
            this.root = object2;
            this.first = false;
        } else if (this.currentNode != null) {
            if (object2 != null) {
                this.adapter.addNode(this.currentNode, object2);
                this.adapter.setParentNode(object2, this.currentNode);
            }
            this.path.addElement(this.currentNode);
        } else {
            this.path.addElement(dummy);
        }
        this.currentNode = object2;
        return object2;
    }

    public Object closeNode() {
        int n;
        if (TreeBuilder.logger.level >= 7) {
            logger.lvlBuild(7, "closeNode()", 126).log();
        }
        if (this.currentNode != null) {
            this.factory.finishNode(this.currentNode);
        }
        if ((n = this.path.size()) > 0) {
            this.currentNode = this.path.elementAt(n - 1);
            this.path.removeElementAt(n - 1);
            if (this.currentNode == dummy) {
                this.currentNode = null;
            }
        } else {
            this.currentNode = null;
        }
        return this.currentNode;
    }

    public Object getRoot() {
        return this.root;
    }

    public void reset() {
        this.root = null;
        this.first = true;
    }
}

