/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.StreamInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ArchiveClassLoader
extends ClassLoader {
    private static final Logger logger = new Logger("de.qfs.lib.util.ArchiveClassLoader");
    protected Hashtable classes = new Hashtable();
    protected ZipFile zip;
    protected File dir;
    private Vector packages;

    public ArchiveClassLoader(ZipFile zipFile) {
        if (ArchiveClassLoader.logger.level >= 7) {
            logger.log(7, "ArchiveClassLoader(ZipFile)", ArchiveClassLoader.logger.level < 8 ? "" : "zip: " + zipFile);
        }
        this.zip = zipFile;
    }

    public ArchiveClassLoader(File file) {
        if (ArchiveClassLoader.logger.level >= 7) {
            logger.log(7, "ArchiveClassLoader(File)", ArchiveClassLoader.logger.level < 8 ? "" : "dir: " + file);
        }
        this.dir = file;
    }

    public void restrict(String string) {
        if (this.packages == null) {
            this.packages = new Vector();
        }
        this.packages.addElement(string);
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        if (ArchiveClassLoader.logger.level >= 7) {
            logger.log(7, "loadClass(String)", ArchiveClassLoader.logger.level < 8 ? "" : "name: " + string);
        }
        return this.loadClass(string, true);
    }

    public Class loadSystemClass(String string) throws ClassNotFoundException {
        if (ArchiveClassLoader.logger.level >= 7) {
            logger.log(7, "loadSystemClass(String)", ArchiveClassLoader.logger.level < 8 ? "" : "name: " + string);
        }
        return this.makeSystemClass(string, true);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        if (ArchiveClassLoader.logger.level >= 7) {
            logger.log(7, "getResourceAsStream(String)", ArchiveClassLoader.logger.level < 8 ? "" : "name: " + string);
        }
        if (this.dir != null) {
            String string2 = string;
            if (File.separatorChar != '/') {
                string2 = string.replace('/', File.separator.charAt(0));
            }
            try {
                File file = new File(this.dir.getCanonicalPath() + File.separator + string2);
                if (!file.exists()) {
                    if (ArchiveClassLoader.logger.level >= 9) {
                        logger.log(9, "getResourceAsStream(String)", file.toString() + "Not Found");
                    }
                    return null;
                }
                return new FileInputStream(file);
            }
            catch (IOException iOException) {
                if (ArchiveClassLoader.logger.level >= 1) {
                    logger.log("getResourceAsStream(String)", iOException);
                }
                return null;
            }
        }
        if (this.zip != null) {
            try {
                ZipEntry zipEntry = this.zip.getEntry(string);
                if (zipEntry == null) {
                    if (ArchiveClassLoader.logger.level >= 9) {
                        logger.log(9, "getResourceAsStream(String)", "Not Found");
                    }
                    return null;
                }
                return this.zip.getInputStream(zipEntry);
            }
            catch (ZipException zipException) {
                if (ArchiveClassLoader.logger.level >= 1) {
                    logger.log("getResourceAsStream(String)", zipException);
                }
                return null;
            }
            catch (IOException iOException) {
                if (ArchiveClassLoader.logger.level >= 1) {
                    logger.log("getResourceAsStream(String)", iOException);
                }
                return null;
            }
        }
        return null;
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        byte[] byArray;
        InputStream inputStream;
        Class clazz;
        if (ArchiveClassLoader.logger.level >= 7) {
            logger.log(7, "loadClass(String,boolean)", ArchiveClassLoader.logger.level < 8 ? "" : "name: " + string + ", resolve: " + bl);
        }
        if ((clazz = (Class)this.classes.get(string)) != null) {
            if (ArchiveClassLoader.logger.level >= 9) {
                logger.log(9, "loadClass(String,boolean)", "Cache hit for " + string);
            }
            return clazz;
        }
        if (this.isOutsideRestricted(string)) {
            return this.makeSystemClass(string, bl);
        }
        String string2 = string.replace('.', '/') + ".class";
        if (ArchiveClassLoader.logger.level >= 9) {
            logger.log(9, "loadClass(String,boolean)", "Converted name is " + string2);
        }
        if ((inputStream = this.getResourceAsStream(string2)) == null) {
            if (ArchiveClassLoader.logger.level >= 9) {
                logger.log(9, "loadClass(String,boolean)", "Null resource for " + string2);
            }
            return this.makeSystemClass(string, bl);
        }
        try {
            byArray = StreamInput.read(inputStream);
            if (ArchiveClassLoader.logger.level >= 9) {
                logger.log(9, "loadClass(String,boolean)", "class " + string + " has " + byArray.length + " bytes");
            }
        }
        catch (IOException iOException) {
            if (ArchiveClassLoader.logger.level >= 1) {
                logger.log("loadClass(String,boolean)", iOException);
            }
            return this.makeSystemClass(string, bl);
        }
        Class<?> clazz2 = null;
        try {
            if (ArchiveClassLoader.logger.level >= 9) {
                logger.log(9, "loadClass(String,boolean)", "defining " + string);
            }
            clazz2 = this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (Throwable throwable) {
            if (ArchiveClassLoader.logger.level >= 1) {
                logger.log("loadClass(String,boolean) " + string, throwable);
            }
            return this.makeSystemClass(string, bl);
        }
        this.classes.put(string, clazz2);
        if (ArchiveClassLoader.logger.level >= 9) {
            logger.log(9, "loadClass(String,boolean)", string + " defined");
        }
        if (bl) {
            this.resolveClass(clazz2);
            if (ArchiveClassLoader.logger.level >= 9) {
                logger.log(9, "loadClass(String,boolean)", string + " resolved");
            }
        }
        return clazz2;
    }

    protected Class makeSystemClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz;
        if (ArchiveClassLoader.logger.level >= 7) {
            logger.log(7, "makeSystemClass(String,boolean)", ArchiveClassLoader.logger.level < 8 ? "" : "name: " + string + ", resolve: " + bl);
        }
        if ((clazz = this.findSystemClass(string)) == null) {
            if (ArchiveClassLoader.logger.level >= 1) {
                logger.log(1, "makeSystemClass(String,boolean)", "Cannot fing system class " + string);
            }
            throw new ClassNotFoundException(string);
        }
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean isOutsideRestricted(String string) {
        if (this.packages == null) {
            return false;
        }
        for (int i = 0; i < this.packages.size(); ++i) {
            String string2 = (String)this.packages.elementAt(i);
            if (!string.startsWith(string2)) continue;
            if (string2.endsWith(".")) {
                return false;
            }
            int n = string2.length();
            if (string.length() != n && (string.length() <= n || string.charAt(n) != '.' || string.indexOf(46, n + 1) >= 0)) continue;
            return false;
        }
        return true;
    }
}

