/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.ClassWrapperAware;
import de.qfs.lib.util.DynamicClassLoader;
import java.util.Hashtable;
import java.util.Vector;

public class ClassWrapper {
    private static Logger logger = new Logger("de.qfs.lib.util.ClassWrapper");
    private Vector packagenames = new Vector();
    private String suffix;
    private boolean dynamic;
    private Hashtable cache;

    public ClassWrapper(String string, String string2) {
        if (ClassWrapper.logger.level >= 7) {
            logger.log(7, "ClassWrapper(String,String)", ClassWrapper.logger.level < 8 ? "" : "packagename: " + string + ", suffix: " + string2);
        }
        this.packagenames.addElement(string);
        this.suffix = string2;
        this.cache = new Hashtable();
    }

    public ClassWrapper(String string, String string2, boolean bl) {
        if (ClassWrapper.logger.level >= 7) {
            logger.log(7, "ClassWrapper(String,String,boolean)", ClassWrapper.logger.level < 8 ? "" : "packagename: " + string + ", suffix: " + string2 + ", dynamic: " + bl);
        }
        this.packagenames.addElement(string);
        this.suffix = string2;
        this.dynamic = bl;
        if (!bl) {
            this.cache = new Hashtable();
        }
    }

    public final boolean isDynamic() {
        return this.dynamic;
    }

    public final synchronized void setDynamic(boolean bl) {
        this.dynamic = bl;
        if (bl && this.cache == null) {
            this.cache = new Hashtable();
        }
    }

    public synchronized Object makeWrapper(Object object) {
        block25: {
            if (ClassWrapper.logger.level >= 7) {
                logger.log(7, "makeWrapper(Object)", ClassWrapper.logger.level < 8 ? "" : "client: " + object);
            }
            Class clazz = object.getClass();
            if (ClassWrapper.logger.level >= 9) {
                logger.build("makeWrapper(Object)").add("clientClass: ").add(clazz).log(9);
            }
            try {
                String string;
                Class clazz2;
                Class<?> clazz3 = null;
                if (!this.dynamic) {
                    clazz3 = (Class<?>)this.cache.get(clazz);
                    if (ClassWrapper.logger.level >= 9) {
                        logger.build("makeWrapper(Object)").add("cached targetClass: ").add(clazz3).log(9);
                    }
                }
                if (clazz3 == null && object instanceof ClassWrapperAware) {
                    clazz2 = ((ClassWrapperAware)object).getWrapperClass(this.suffix);
                    if (this.dynamic && clazz2 != null) {
                        string = clazz2.getName();
                        if (string != null) {
                            try {
                                clazz3 = DynamicClassLoader.loadDynamicClass(string);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                if (ClassWrapper.logger.level >= 1) {
                                    logger.log(1, "makeWrapper(Object)", "ClassWrapperAware returned class not found: " + string);
                                    logger.log("makeWrapper(Object)", classNotFoundException);
                                }
                                return null;
                            }
                        }
                    } else if (clazz2 != null) {
                        clazz3 = clazz2;
                        this.cache.put(clazz, clazz3);
                    }
                }
                block8: for (clazz2 = clazz; clazz3 == null && clazz2 != Object.class; clazz2 = clazz2.getSuperclass()) {
                    string = clazz2.getName();
                    int n = string.lastIndexOf(".");
                    if (n >= 0) {
                        string = string.substring(n + 1);
                    }
                    for (int i = 0; i < this.packagenames.size(); ++i) {
                        String string2 = (String)this.packagenames.elementAt(i) + "." + string + this.suffix;
                        if (ClassWrapper.logger.level >= 9) {
                            logger.build("makeWrapper(Object)").add("target: ").add(string2).log(9);
                        }
                        try {
                            if (this.dynamic) {
                                clazz3 = DynamicClassLoader.loadDynamicClass(string2);
                                continue block8;
                            }
                            ClassLoader classLoader = this.getClass().getClassLoader();
                            clazz3 = classLoader == null ? Class.forName(string2) : classLoader.loadClass(string2);
                            this.cache.put(clazz2, clazz3);
                            this.cache.put(clazz, clazz3);
                            continue block8;
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            continue;
                        }
                        catch (Error error) {
                            if (ClassWrapper.logger.level < 1) continue;
                            logger.log("makeWrapper(Object)", error);
                        }
                    }
                }
                if (clazz3 != null) {
                    return clazz3.newInstance();
                }
            }
            catch (InstantiationException instantiationException) {
                if (ClassWrapper.logger.level >= 1) {
                    logger.log("makeWrapper(Object)", instantiationException);
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (ClassWrapper.logger.level < 1) break block25;
                logger.log("makeWrapper(Object)", illegalAccessException);
            }
        }
        return null;
    }

    public synchronized void addPackage(String string) {
        if (ClassWrapper.logger.level >= 7) {
            logger.log(7, "addPackage(String)", ClassWrapper.logger.level < 8 ? "" : "packagename: " + string);
        }
        this.packagenames.insertElementAt(string, 0);
    }
}

