/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.CountEvent;
import de.qfs.lib.util.CountListener;
import de.qfs.lib.util.InputStreamAdapter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class CountingInputStream
extends InputStreamAdapter {
    private static final Logger logger = new Logger("de.qfs.lib.util.CountingInputStream");
    protected long count;
    protected long mark = -1L;
    protected Vector listeners = new Vector();

    public CountingInputStream(InputStream inputStream) {
        super(inputStream);
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "CountingInputStream(InputStream)", CountingInputStream.logger.level < 8 ? "" : "stream: " + inputStream);
        }
    }

    @Override
    public void mark(int n) {
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "mark(int)", CountingInputStream.logger.level < 8 ? "" : "readlimit: " + n);
        }
        if (this.markSupported()) {
            this.mark = this.count;
        }
        super.mark(n);
    }

    @Override
    public int read() throws IOException {
        int n;
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "read()", "");
        }
        if ((n = super.read()) >= 0) {
            ++this.count;
            this.fireCountChanged(this.count);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        int n;
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "read(byte[])", CountingInputStream.logger.level < 8 ? "" : "b: " + byArray);
        }
        if ((n = super.read(byArray)) > 0) {
            this.count += (long)n;
            this.fireCountChanged(this.count);
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "read(byte[],int,int)", CountingInputStream.logger.level < 8 ? "" : "b: " + byArray + ", off: " + n + ", len: " + n2);
        }
        if ((n3 = super.read(byArray, n, n2)) > 0) {
            this.count += (long)n3;
            this.fireCountChanged(this.count);
        }
        return n3;
    }

    @Override
    public void reset() throws IOException {
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "reset()", "");
        }
        if (this.markSupported() && this.mark >= 0L && this.mark != this.count) {
            this.count = this.mark;
            this.fireCountChanged(this.count);
        }
        super.reset();
    }

    @Override
    public long skip(long l) throws IOException {
        long l2;
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "skip(long)", CountingInputStream.logger.level < 8 ? "" : "n: " + l);
        }
        if ((l2 = super.skip(l)) > 0L) {
            this.count += l2;
            this.fireCountChanged(this.count);
        }
        return l2;
    }

    public synchronized void addCountListener(CountListener countListener) {
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "addCountListener(CountListener)", CountingInputStream.logger.level < 8 ? "" : "listener: " + countListener);
        }
        this.listeners.removeElement(countListener);
        this.listeners.addElement(countListener);
    }

    public synchronized void removeCountListener(CountListener countListener) {
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "removeCountListener(CountListener)", CountingInputStream.logger.level < 8 ? "" : "listener: " + countListener);
        }
        this.listeners.removeElement(countListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireCountChanged(long l) {
        Vector vector;
        if (CountingInputStream.logger.level >= 7) {
            logger.log(7, "fireCountChanged()", "");
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.listeners.clone();
        }
        object = new CountEvent(this, l);
        for (int i = 0; i < vector.size(); ++i) {
            ((CountListener)vector.elementAt(i)).countChanged((CountEvent)object);
        }
    }
}

