/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import lombok.NonNull;

public class Environment {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.Environment");
    private static final boolean OS_IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    private static Environment instance = new Environment();
    private Properties environment;

    public Environment() {
        if (Environment.logger.level >= 7) {
            logger.lvlBuild(7, "Environment()", 88).log();
        }
        this.initEnvironment();
    }

    public Environment(Properties properties) {
        if (Environment.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "Environment(Properties)", 101).addDetail("environment", properties)).log();
        }
        this.environment = properties == null ? new Properties() : (Properties)properties.clone();
    }

    public Environment(@NonNull File file) throws IOException {
        if (Environment.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "Environment(File)", 121).addDetail("extraEnvironment", file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("extraEnvironment is marked non-null but is null");
        }
        this.initEnvironment();
        this.readFromFile(file);
    }

    @NonNull
    public static Environment instance() {
        if (Environment.logger.level >= 7) {
            logger.lvlBuild(7, "instance()", 138).log();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static final String[] asArray(Properties properties) {
        if (Environment.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "asArray(Properties)", 153).addDetail("env", properties)).log();
        }
        if (properties == null) {
            return new String[0];
        }
        Properties properties2 = properties;
        synchronized (properties2) {
            String[] stringArray = new String[properties.size()];
            int n = 0;
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                stringArray[n++] = (String)entry.getKey() + "=" + entry.getValue();
            }
            return stringArray;
        }
    }

    public final boolean isAvailable() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Properties getEnvironment() {
        if (Environment.logger.level >= 7) {
            logger.lvlBuild(7, "getEnvironment()", 198).log();
        }
        Environment environment = this;
        synchronized (environment) {
            if (this.environment == null) {
                this.initEnvironment();
            }
        }
        return this.environment;
    }

    public final void setEnvironment(Properties properties) {
        if (Environment.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEnvironment(Properties)", 216).addDetail("environment", properties)).log();
        }
        this.environment = properties;
    }

    public String getEnv(String string) {
        if (Environment.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getEnv(String)", 233).addDetail("name", string)).log();
        }
        String string2 = this.getEnvironment().getProperty(this.transformName(string));
        return string2;
    }

    public void setEnv(String string, String string2) {
        if (Environment.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setEnv(String,String)", 248).addDetail("name", string)).addDetail("value", string2)).log();
        }
        if (string2 == null) {
            if (Environment.logger.level >= 3) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "setEnv(String,String)", 251).add("Setting null value for ")).add(string)).log();
            }
            string2 = "";
        }
        this.getEnvironment().put(this.transformName(string), string2);
    }

    public void unsetEnv(String string) {
        if (Environment.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "unsetEnv(String)", 264).addDetail("name", string)).log();
        }
        this.getEnvironment().remove(this.transformName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile(@NonNull File file) throws IOException {
        if (Environment.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "readFromFile(File)", 279).addDetail("extraEnvironment", file)).log();
        }
        if (file == null) {
            throw new IllegalArgumentException("extraEnvironment is marked non-null but is null");
        }
        BufferedReader bufferedReader = null;
        bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Misc.UTF8_CHARSET));
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                int n = string.indexOf("=");
                if (n > 0) {
                    this.environment.setProperty(string.substring(0, n), string.substring(n + 1));
                }
                string = bufferedReader.readLine();
            }
        }
        finally {
            block13: {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable) {
                        if (Environment.logger.level < 9) break block13;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "readFromFile(File)", 299).add("t", throwable)).log();
                    }
                }
            }
        }
    }

    @NonNull
    public String[] asArray() {
        if (Environment.logger.level >= 7) {
            logger.lvlBuild(7, "asArray()", 313).log();
        }
        return Environment.asArray(this.environment);
    }

    private final void initEnvironment() {
        if (Environment.logger.level >= 7) {
            logger.lvlBuild(7, "initEnvironment()", 328).log();
        }
        this.environment = new Properties();
        Map<String, String> map = System.getenv();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.environment.put(this.transformName(entry.getKey()), entry.getValue());
        }
    }

    @NonNull
    private final String transformName(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("name is marked non-null but is null");
        }
        return OS_IS_WINDOWS ? string.toUpperCase() : string;
    }
}

