/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public class ExecutorWithTimeout
extends ThreadPoolExecutor {
    private static final long keepAliveTime = Integer.MAX_VALUE;
    private static final TimeUnit unit = TimeUnit.DAYS;
    private static final RejectedExecutionHandler defaultHandler = new ThreadPoolExecutor.AbortPolicy();
    private final ScheduledExecutorService timeoutExecutor = Executors.newSingleThreadScheduledExecutor();
    private final ConcurrentMap<Future, TimeoutData> timeoutDatas = new ConcurrentHashMap<Future, TimeoutData>();
    private final ConcurrentMap<Runnable, ScheduledFuture> runningTasks = new ConcurrentHashMap<Runnable, ScheduledFuture>();

    public ExecutorWithTimeout(int n, int n2) {
        this(n, n2, Executors.defaultThreadFactory(), defaultHandler);
    }

    public ExecutorWithTimeout(int n, int n2, RejectedExecutionHandler rejectedExecutionHandler) {
        this(n, n2, Executors.defaultThreadFactory(), rejectedExecutionHandler);
    }

    public ExecutorWithTimeout(int n, int n2, ThreadFactory threadFactory) {
        this(n, n2, threadFactory, defaultHandler);
    }

    public ExecutorWithTimeout(int n, int n2, ThreadFactory threadFactory, RejectedExecutionHandler rejectedExecutionHandler) {
        super(n, n2, Integer.MAX_VALUE, unit, new LinkedBlockingQueue<Runnable>(), threadFactory, rejectedExecutionHandler);
    }

    public Future<?> submit(Runnable runnable, long l, TimeUnit timeUnit) {
        return this.submit(runnable, l, timeUnit, null);
    }

    public Future<?> submit(Runnable runnable, long l, TimeUnit timeUnit, Runnable runnable2) {
        Future<?> future = super.submit(runnable);
        this.timeoutDatas.put(future, new TimeoutData(l, timeUnit, runnable2));
        return future;
    }

    @Override
    public void shutdown() {
        this.timeoutExecutor.shutdown();
        super.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.timeoutExecutor.shutdownNow();
        return super.shutdownNow();
    }

    @Override
    protected void beforeExecute(Thread thread, Runnable runnable) {
        TimeoutData timeoutData = (TimeoutData)this.timeoutDatas.remove(runnable);
        if (timeoutData != null && timeoutData.timeout > 0L) {
            ScheduledFuture<?> scheduledFuture = this.timeoutExecutor.schedule(new TimeoutTask(thread, timeoutData.timeoutHandler), timeoutData.timeout, timeoutData.timeoutUnit);
            this.runningTasks.put(runnable, scheduledFuture);
        }
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        ScheduledFuture scheduledFuture = (ScheduledFuture)this.runningTasks.remove(runnable);
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
        }
    }

    class TimeoutTask
    implements Runnable {
        final Thread thread;
        final Runnable timeoutHandler;

        @Override
        public void run() {
            boolean bl = this.thread.isAlive();
            this.thread.interrupt();
            if (bl && this.timeoutHandler != null) {
                this.timeoutHandler.run();
            }
        }

        @Generated
        public TimeoutTask(Thread thread, Runnable runnable) {
            this.thread = thread;
            this.timeoutHandler = runnable;
        }
    }

    class TimeoutData {
        final long timeout;
        final TimeUnit timeoutUnit;
        final Runnable timeoutHandler;

        @Generated
        public TimeoutData(long l, TimeUnit timeUnit, Runnable runnable) {
            this.timeout = l;
            this.timeoutUnit = timeUnit;
            this.timeoutHandler = runnable;
        }
    }
}

