/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import javax.swing.filechooser.FileFilter;

public class ExtensionFileFilter
extends FileFilter
implements FilenameFilter {
    private static final Logger logger = new Logger("de.qfs.lib.util.ExtensionFileFilter");
    private String desc;
    private String[] ext;
    private boolean acceptDirectories;
    private boolean ignoreCase;

    public ExtensionFileFilter(String string, String string2, boolean bl, boolean bl2) {
        if (ExtensionFileFilter.logger.level >= 7) {
            Logger.Builder builder = logger.build("ExtensionFileFilter(String,String,boolean,boolean)");
            (ExtensionFileFilter.logger.level < 8 ? builder : builder.add("desc: ").add(string).add(", ext: ").add(string2).add(", acceptDirectories: ").add(bl).add(", ignoreCase: ").add(bl2)).log(7);
        }
        this.ext = new String[]{string2};
        this.desc = string;
        this.acceptDirectories = bl;
        this.ignoreCase = bl2;
    }

    public ExtensionFileFilter(String string, String[] stringArray, boolean bl, boolean bl2) {
        if (ExtensionFileFilter.logger.level >= 7) {
            Logger.Builder builder = logger.build("ExtensionFileFilter(String,String[],boolean,boolean)");
            (ExtensionFileFilter.logger.level < 8 ? builder : builder.add("desc: ").add(string).add(", ext: ").add(stringArray).add(", acceptDirectories: ").add(bl).add(", ignoreCase: ").add(bl2)).log(7);
        }
        this.ext = (String[])stringArray.clone();
        this.desc = string;
        this.acceptDirectories = bl;
        this.ignoreCase = bl2;
    }

    @Override
    public boolean accept(File file) {
        if (this.acceptDirectories && file.isDirectory()) {
            return true;
        }
        return this.checkExt(file.getName());
    }

    @Override
    public boolean accept(File file, String string) {
        if (this.checkExt(string)) {
            return true;
        }
        return this.acceptDirectories && new File(file, string).isDirectory();
    }

    public final String getExtension() {
        return this.ext[0];
    }

    public final String[] getExtensions() {
        return this.ext;
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    public File forceExtension(File file) {
        Object object;
        if (ExtensionFileFilter.logger.level >= 7) {
            object = logger.build("forceExtension(File)");
            ((Logger.Builder)(ExtensionFileFilter.logger.level < 8 ? object : ((Logger.Builder)object).add("file: ").add(file))).log(7);
        }
        object = file.getPath();
        for (int i = 0; i < this.ext.length; ++i) {
            if (this.ignoreCase) {
                if (((String)object).length() < this.ext[i].length() || !((String)object).substring(((String)object).length() - this.ext[i].length()).equalsIgnoreCase(this.ext[i])) continue;
                File file2 = new File(((String)object).substring(0, ((String)object).length() - this.ext[i].length()) + this.ext[i]);
                if (ExtensionFileFilter.logger.level >= 9) {
                    logger.build("forceExtension(File)").add("got match: ").add(this.ext[i]).add(", ret: ").add(file2).log(9);
                }
                return file2;
            }
            if (!((String)object).endsWith(this.ext[i])) continue;
            if (ExtensionFileFilter.logger.level >= 9) {
                logger.build("forceExtension(File)").add("got match: ").add(this.ext[i]).log(9);
            }
            return file;
        }
        return new File((String)object + this.ext[0]);
    }

    private boolean checkExt(String string) {
        if (ExtensionFileFilter.logger.level >= 7) {
            Logger.Builder builder = logger.build("checkExt(String)");
            (ExtensionFileFilter.logger.level < 8 ? builder : builder.add("name: ").add(string)).log(7);
        }
        for (int i = 0; i < this.ext.length; ++i) {
            if (this.ignoreCase) {
                if (string.length() < this.ext[i].length() || !string.substring(string.length() - this.ext[i].length()).equalsIgnoreCase(this.ext[i])) continue;
                if (ExtensionFileFilter.logger.level >= 9) {
                    logger.build("checkExt(String)").add("got match: ").add(this.ext[i]).log(9);
                }
                return true;
            }
            if (!string.endsWith(this.ext[i])) continue;
            if (ExtensionFileFilter.logger.level >= 9) {
                logger.build("checkExt(String)").add("got match: ").add(this.ext[i]).log(9);
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[" + this.desc + "]";
    }
}

