/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.Reflector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.Random;
import lombok.Generated;

public class LockFile {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.LockFile");
    private String fileName;
    private boolean addUser;
    private String id;
    private FileOutputStream lockFile;
    private Object lockChannel;
    private Object lock;

    public LockFile(String string) {
        this(string, false);
        if (LockFile.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "LockFile(String)", 100).addDetail("fileName", string)).log();
        }
    }

    public LockFile(String string, boolean bl) {
        if (LockFile.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "LockFile(String,boolean)", 114).addDetail("fileName", string)).addDetail("addUser", bl)).log();
        }
        this.fileName = string;
        this.addUser = bl;
        this.id = this.genID();
    }

    public boolean lock(boolean bl) {
        File file;
        if (LockFile.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "lock(boolean)", 136).addDetail("steal", bl)).log();
        }
        if ((file = new File(this.fileName)).exists()) {
            if (LockFile.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "lock(boolean)", 141).add("Lockfile exists.")).log();
            }
            if (bl) {
                if (!file.delete() && LockFile.logger.level >= 3) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(3, "lock(boolean)", 144).add("Cannot delete file ")).add(this.fileName)).log();
                }
            } else {
                return false;
            }
        }
        try {
            this.lockFile = new FileOutputStream(this.fileName);
            Properties properties = new Properties();
            if (this.addUser) {
                properties.put("user", System.getProperty("user.name"));
            }
            properties.put("key", this.id);
            properties.save(this.lockFile, "");
            this.lockFile.flush();
        }
        catch (IOException iOException) {
            if (LockFile.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "lock(boolean)", 161).add("ex", iOException)).log();
            }
            return false;
        }
        if (LockFile.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "lock(boolean)", 164).add("lockFile", this.lockFile)).log();
        }
        this.lockChannel = Reflector.safeCall(this.lockFile, "getChannel");
        if (LockFile.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "lock(boolean)", 167).add("lockChannel", this.lockChannel)).log();
        }
        if (this.lockChannel == null && !bl) {
            this.unlock();
            return false;
        }
        this.lock = Reflector.safeCall(this.lockChannel, "tryLock");
        if (LockFile.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "lock(boolean)", 176).add("lock", this.lock)).log();
        }
        if (this.lock == null && !bl) {
            this.unlock();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        if (LockFile.logger.level >= 7) {
            logger.lvlBuild(7, "unlock()", 192).log();
        }
        if (this.lock != null) {
            Reflector.safeCall(this.lock, "release");
            this.lock = null;
        }
        if (this.lockChannel != null) {
            Reflector.safeCall(this.lockChannel, "close");
            this.lockChannel = null;
        }
        if (this.lockFile != null) {
            block19: {
                try {
                    this.lockFile.close();
                }
                catch (IOException iOException) {
                    if (LockFile.logger.level < 3) break block19;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "unlock()", 206).add("ex", iOException)).log();
                }
            }
            this.lockFile = null;
            try {
                Properties properties = new Properties();
                FileInputStream fileInputStream = new FileInputStream(this.fileName);
                try {
                    properties.load(fileInputStream);
                }
                finally {
                    block21: {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable) {
                            if (LockFile.logger.level < 9) break block21;
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "unlock()", 218).add("t", throwable)).log();
                        }
                    }
                }
                if (LockFile.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "unlock()", 221).add("props", properties)).log();
                }
                if (!this.id.equals(properties.get("key"))) {
                    return;
                }
            }
            catch (IOException iOException) {
                if (LockFile.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "unlock()", 227).add("ex", iOException)).log();
                }
                return;
            }
            if (!new File(this.fileName).delete() && LockFile.logger.level >= 5 && LockFile.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "unlock()", 232).add("Can't delete lock file")).log();
            }
        }
    }

    private String genID() {
        byte[] byArray = new byte[32];
        new Random().nextBytes(byArray);
        return Misc.toHex(byArray);
    }
}

