/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Log;
import java.util.ArrayList;
import java.util.List;

public class MessageCollector
implements Cloneable {
    public static final int NO_ERROR = 0;
    public static final int WARNING = 1;
    public static final int ERROR = 2;
    public static final int FATAL_ERROR = 3;
    private static final Object classlock = new Object();
    private static final String LINESEP = System.getProperty("line.separator", "\n");
    private static ThreadLocal collectors = new ThreadLocal(){

        protected Object initialValue() {
            return new MessageCollector();
        }
    };
    private List messages = new ArrayList();
    private int limit = -1;
    private int dropped;
    private int warnings;
    private int errors;
    private int fatalErrors;
    private String firstWarning;
    private String lastWarning;
    private String firstError;
    private String lastError;
    private String firstFatalError;
    private String lastFatalError;
    private int errorOverride = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessageCollector instance() {
        Object object = classlock;
        synchronized (object) {
            return (MessageCollector)collectors.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void release() {
        Object object = classlock;
        synchronized (object) {
            ((MessageCollector)collectors.get()).reset();
        }
    }

    public Object clone() {
        try {
            MessageCollector messageCollector = (MessageCollector)super.clone();
            if (this.messages != null) {
                messageCollector.messages = (List)((ArrayList)this.messages).clone();
            }
            return messageCollector;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return this;
        }
    }

    public final int getLimit() {
        return this.limit;
    }

    public final void setLimit(int n) {
        this.limit = n;
    }

    public synchronized void addMessage(int n, String string) {
        if (n >= 1 || this.limit <= 0 || this.messages.size() < this.limit) {
            this.messages.add(string);
        } else {
            ++this.dropped;
        }
        switch (n) {
            case 1: {
                ++this.warnings;
                if (this.firstWarning == null) {
                    this.firstWarning = string;
                }
                this.lastWarning = string;
                break;
            }
            case 2: {
                ++this.errors;
                if (this.firstError == null) {
                    this.firstError = string;
                }
                this.lastError = string;
                break;
            }
            case 3: {
                ++this.fatalErrors;
                if (this.firstFatalError == null) {
                    this.firstFatalError = string;
                }
                this.lastFatalError = string;
            }
        }
    }

    public synchronized void addFoldableMessage(int n, String string, String string2) {
        string = string == null ? "" : " " + string.trim();
        string2 = "{{{" + string + "\n" + string2 + "\n}}}";
        this.addMessage(n, string2);
    }

    public synchronized void addMessageInFront(int n, String string) {
        if (n >= 1 || this.limit <= 0 || this.messages.size() < this.limit) {
            this.messages.add(0, string);
        } else {
            ++this.dropped;
        }
        switch (n) {
            case 1: {
                ++this.warnings;
                this.firstWarning = string;
                if (this.lastWarning != null) break;
                this.lastWarning = string;
                break;
            }
            case 2: {
                ++this.errors;
                this.firstError = string;
                if (this.lastError != null) break;
                this.lastError = string;
                break;
            }
            case 3: {
                ++this.fatalErrors;
                this.firstFatalError = string;
                if (this.lastFatalError != null) break;
                this.lastFatalError = string;
            }
        }
    }

    public void copyMessages(MessageCollector messageCollector) {
        String[] stringArray = messageCollector.getMessages();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.limit <= 0 || this.messages.size() < this.limit) {
                this.messages.add(stringArray[i]);
                continue;
            }
            ++this.dropped;
        }
        this.warnings += messageCollector.getWarningCount();
        this.errors += messageCollector.getErrorCount();
        this.fatalErrors += messageCollector.getFatalErrorCount();
        if (this.firstWarning == null && messageCollector.firstWarning != null) {
            this.firstWarning = messageCollector.firstWarning;
        }
        if (this.firstError == null && messageCollector.firstError != null) {
            this.firstError = messageCollector.firstError;
        }
        if (this.firstFatalError == null && messageCollector.firstFatalError != null) {
            this.firstFatalError = messageCollector.firstFatalError;
        }
        if (messageCollector.lastWarning != null) {
            this.lastWarning = messageCollector.lastWarning;
        }
        if (messageCollector.lastError != null) {
            this.lastError = messageCollector.lastError;
        }
        if (messageCollector.lastFatalError != null) {
            this.lastFatalError = messageCollector.lastFatalError;
        }
    }

    public synchronized String[] getMessages() {
        if (this.dropped > 0) {
            this.messages.add("Message limit exceeded, " + this.dropped + " messages dropped");
        }
        String[] stringArray = this.messages.toArray(new String[0]);
        if (this.dropped > 0) {
            this.messages.remove(this.messages.size() - 1);
        }
        return stringArray;
    }

    public synchronized String getJoinedMessages() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.messages.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(LINESEP);
            }
            stringBuilder.append((String)this.messages.get(i));
        }
        if (this.dropped > 0) {
            stringBuilder.append(LINESEP);
            stringBuilder.append("Message limit exceeded, " + this.dropped + " messages dropped");
        }
        return stringBuilder.toString();
    }

    public int getWarningCount() {
        return this.warnings;
    }

    public int getErrorCount() {
        return this.errors;
    }

    public int getFatalErrorCount() {
        return this.fatalErrors;
    }

    public void overrideWorstCase(int n) {
        this.errorOverride = n;
    }

    public synchronized int getWorstCase() {
        if (this.errorOverride >= 0) {
            return this.errorOverride;
        }
        if (this.fatalErrors > 0) {
            return 3;
        }
        if (this.errors > 0) {
            return 2;
        }
        if (this.warnings > 0) {
            return 1;
        }
        return 0;
    }

    public final String getFirstWarning() {
        return this.firstWarning;
    }

    public final String getLastWarning() {
        return this.lastWarning;
    }

    public final String getFirstError() {
        return this.firstError;
    }

    public final String getLastError() {
        return this.lastError;
    }

    public final String getFirstFatalError() {
        return this.firstFatalError;
    }

    public final String getLastFatalError() {
        return this.lastFatalError;
    }

    public synchronized void reset() {
        this.warnings = 0;
        this.errors = 0;
        this.fatalErrors = 0;
        this.messages.clear();
        this.dropped = 0;
        this.firstWarning = null;
        this.lastWarning = null;
        this.firstError = null;
        this.lastError = null;
        this.firstFatalError = null;
        this.lastFatalError = null;
    }

    public void resetTo(MessageCollector messageCollector) {
        this.warnings = messageCollector.warnings;
        this.errors = messageCollector.errors;
        this.fatalErrors = messageCollector.fatalErrors;
        this.messages = messageCollector.messages;
        this.dropped = messageCollector.dropped;
        this.firstWarning = messageCollector.firstWarning;
        this.lastWarning = messageCollector.lastWarning;
        this.firstError = messageCollector.firstError;
        this.lastError = messageCollector.lastError;
        this.firstFatalError = messageCollector.firstFatalError;
        this.lastFatalError = messageCollector.lastFatalError;
    }

    public final void logMessage(String string) {
        this.addMessage(0, string);
    }

    public final void logWarning(String string) {
        this.addMessage(1, string);
    }

    public final void logError(String string) {
        this.addMessage(2, string);
    }

    public final void logFatalError(String string) {
        this.addMessage(3, string);
    }

    public final void logMessage(Object ... objectArray) {
        this.logMessage(this.safeToString(objectArray));
    }

    public final void logWarning(Object ... objectArray) {
        this.logWarning(this.safeToString(objectArray));
    }

    public final void logError(Object ... objectArray) {
        this.logError(this.safeToString(objectArray));
    }

    public final void logFatalError(Object ... objectArray) {
        this.logFatalError(this.safeToString(objectArray));
    }

    public final void logFoldableMessage(String string, String string2) {
        this.addFoldableMessage(0, string, string2);
    }

    public final void logFoldableWarning(String string, String string2) {
        this.addFoldableMessage(1, string, string2);
    }

    public final void logFoldableError(String string, String string2) {
        this.addFoldableMessage(2, string, string2);
    }

    public final void logFoldableFatalError(String string, String string2) {
        this.addFoldableMessage(3, string, string2);
    }

    public final void logFoldableMessage(String string, Object ... objectArray) {
        this.logFoldableMessage(string, this.safeToString(objectArray));
    }

    public final void logFoldableWarning(String string, Object ... objectArray) {
        this.logFoldableWarning(string, this.safeToString(objectArray));
    }

    public final void logFoldableError(String string, Object ... objectArray) {
        this.logFoldableError(string, this.safeToString(objectArray));
    }

    public final void logFoldableFatalError(String string, Object ... objectArray) {
        this.logFoldableFatalError(string, this.safeToString(objectArray));
    }

    protected String safeToString(Object[] objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object : objectArray) {
            this.safeAppend(stringBuilder, object);
        }
        return stringBuilder.toString();
    }

    protected void safeAppend(StringBuilder stringBuilder, Object object) {
        try {
            stringBuilder.append(object);
        }
        catch (Throwable throwable) {
            String string = Log.getStackTrace(throwable);
            stringBuilder.append("Instance of " + object.getClass() + ": " + string);
        }
    }
}

