/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.Logger;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.Pair;
import de.qfs.lib.util.ProcessManager;
import de.qfs.lib.util.Reflector;
import java.awt.Color;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;

public abstract class Misc {
    @Generated
    private static final QFLogger logger;
    protected static final Pattern ESCAPE_CHAR_PATTERN;
    private static final Object classlock;
    private static final char[] nibbles;
    private static final char[] nibblesLowerCase;
    static String javaVersionString;
    static int majorVersion;
    static int mediumVersion;
    static int minorVersion;
    static int subVersion;
    static String extVersion;
    public static final boolean IS_JAVA_VERSION_6;
    public static final boolean IS_JAVA_VERSION_7;
    public static final boolean IS_JAVA_VERSION_8;
    public static final boolean IS_JAVA_VERSION_9;
    public static final boolean IS_JAVA_VERSION_10;
    public static final boolean IS_JAVA_VERSION_11;
    public static final boolean IS_JAVA_VERSION_12;
    public static final boolean IS_JAVA_VERSION_13;
    public static final boolean IS_JAVA_VERSION_14;
    public static final boolean IS_JAVA_VERSION_15;
    public static final boolean IS_JAVA_VERSION_16;
    public static final boolean IS_JAVA_VERSION_17;
    public static final boolean IS_JAVA_VERSION_21;
    public static final boolean IS_JAVA_VERSION_25;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_7;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_8;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_9;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_10;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_11;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_12;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_13;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_14;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_15;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_16;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_17;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_21;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_24;
    public static final boolean IS_JAVA_VERSION_AT_LEAST_25;
    public static final boolean OS_IS_WINDOWS;
    public static final boolean OS_IS_LINUX;
    public static final boolean OS_IS_MAC_OS_X;
    public static final boolean JAVA_IS_ARM;
    public static final boolean JAVA_IS_64_BIT;
    private static final AtomicReference<Object> systemWith64Bit;
    private static final AtomicReference<Object> macOsAppleSilicon;
    public static final String NATIVE_LINEBREAK;
    public static final String STR_ELLIPSIS = "\u2026";
    public static final char CHAR_ELLIPSIS = '\u2026';
    public static final String STR_RIGHT_ARROW = "\u279d";
    public static final char CHAR_RIGHT_ARROW = '\u279d';
    public static final String STR_DOUBLE_RIGHT_ARROW = "\u21d2";
    public static final char CHAR_DOUBLE_RIGHT_ARROW = '\u21d2';
    public static final String STR_COLON_EQUALS = "=";
    public static final char CHAR_COLON_EQUALS = '=';
    public static final String STR_BLACK_RIGHT_POINTING_TRIANGLE = "\u25b6";
    public static final char CHAR_BLACK_RIGHT_POINTING_TRIANGLE = '\u25b6';
    public static final String STR_BLACK_RIGHT_POINTING_SMALL_TRIANGLE = "\u25b8";
    public static final char CHAR_BLACK_RIGHT_POINTING_SMALL_TRIANGLE = '\u25b8';
    private static Map<File, Pair<String, Long>> pathMap;
    private static long fileKeepTime;
    private static int fileGCCount;
    public static final Charset LATIN1_CHARSET;
    public static final Charset UTF8_CHARSET;
    public static final Charset UTF16_CHARSET;
    public static final Charset IBM437_CHARSET;
    public static final Charset US_ASCII_CHARSET;
    public static final Charset DEFAULT_CHARSET;
    public static final Charset NATIVE_CHARSET;
    public static final Charset STDOUT_CHARSET;
    public static final Charset STDERR_CHARSET;

    public static boolean equalOrNull(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static boolean arrayEqualOrNull(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return object2 == null || object2.getClass().isArray() && Array.getLength(object2) == 0;
        }
        if (object2 == null) {
            return object.getClass().isArray() && Array.getLength(object) == 0;
        }
        if (object.getClass().isArray()) {
            if (!object2.getClass().isArray()) {
                return false;
            }
            int n = Array.getLength(object);
            if (Array.getLength(object2) != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (Misc.arrayEqualOrNull(Array.get(object, i), Array.get(object2, i))) continue;
                return false;
            }
            return true;
        }
        return object.equals(object2);
    }

    public static boolean equalOrEmpty(String string, String string2) {
        return Misc.equalOrNull("".equals(string) ? null : string, "".equals(string2) ? null : string2);
    }

    public static boolean emptyOrNull(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            return Misc.emptyOrNull((String)object);
        }
        if (object instanceof Object[]) {
            return Misc.emptyOrNull((Object[])object);
        }
        if (object instanceof Map) {
            return Misc.emptyOrNull((Map)object);
        }
        if (object instanceof Collection) {
            return Misc.emptyOrNull((Collection)object);
        }
        if (object.getClass().isArray()) {
            return Misc.arrayEmptyOrNull(object);
        }
        return false;
    }

    public static boolean emptyOrNull(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean emptyOrNull(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    private static boolean arrayEmptyOrNull(Object object) {
        if (object == null) {
            return true;
        }
        return Array.getLength(object) == 0;
    }

    public static boolean emptyOrNull(Collection collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean emptyOrNull(Map map) {
        return map == null || map.isEmpty();
    }

    public static boolean testStringOnlyWhitespaces(String string) {
        if (Misc.emptyOrNull(string)) {
            return true;
        }
        for (char c : string.toCharArray()) {
            if (Character.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static String[] fastSplit(String string, char c, int n) {
        int n2 = string.length();
        if (n2 == 0 || n == 1) {
            return new String[]{string};
        }
        String[] stringArray = new String[n > 0 ? n : n2 + 1];
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = string.indexOf(c);
        for (int i = 0; i < stringArray.length - 1 && n6 >= 0; ++i) {
            stringArray[n3++] = string.substring(n5, n6);
            if (n5 != n6) {
                n4 = n3;
            }
            n5 = n6 + 1;
            n6 = string.indexOf(c, n5);
        }
        stringArray[n3++] = string.substring(n5);
        if (n5 < n2 || n != 0) {
            n4 = n3;
        }
        String[] stringArray2 = new String[n4];
        System.arraycopy(stringArray, 0, stringArray2, 0, n4);
        return stringArray2;
    }

    public static String[] fastSplit(String string, char c) {
        return Misc.fastSplit(string, c, 0);
    }

    public static String removeExtensionFromFileName(String string) {
        if (Misc.emptyOrNull(string)) {
            return string;
        }
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String lineSepToLineFeed(String string) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        boolean bl = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("\r".equals(string2)) {
                if (bl) {
                    stringBuilder.append('\n');
                }
                bl = true;
                continue;
            }
            if ("\n".equals(string2)) {
                stringBuilder.append('\n');
                bl = false;
                continue;
            }
            if (bl) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string2);
            bl = false;
        }
        if (bl) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static String lineSepToLineFeed(char[] cArray) {
        if (cArray == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(cArray.length);
        boolean bl = false;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] == '\n') {
                stringBuilder.append('\n');
                bl = false;
                continue;
            }
            if (cArray[i] == '\r') {
                if (bl) {
                    stringBuilder.append('\n');
                }
                bl = true;
                continue;
            }
            if (bl) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(cArray[i]);
            bl = false;
        }
        if (bl) {
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    public static int countLines(String string) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "countLines(String)", 889).addDetail("text", string)).log();
        }
        if (string == null) {
            return 0;
        }
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "countLines(String)", 900).add("token", string2)).log();
            }
            if ("\r".equals(string2)) {
                if (bl || bl2 || bl3) {
                    ++n;
                    if (Misc.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "countLines(String)", 905).add("lines", n)).log();
                    }
                }
                bl = true;
                bl2 = false;
            } else if ("\n".equals(string2)) {
                if (bl2 || bl3) {
                    ++n;
                    if (Misc.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "countLines(String)", 912).add("lines", n)).log();
                    }
                }
                bl2 = true;
                bl = false;
            } else {
                ++n;
                if (Misc.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "countLines(String)", 918).add("lines", n)).log();
                }
                bl = false;
                bl2 = false;
            }
            bl3 = false;
        }
        return n;
    }

    public static String[] splitLines(String string) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "splitLines(String)", 942).addDetail("text", string)).log();
        }
        if (string == null) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n", true);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "splitLines(String)", 953).add("token", string2)).log();
            }
            if ("\r".equals(string2)) {
                if (bl || bl2 || bl3) {
                    arrayList.add("");
                    if (Misc.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "splitLines(String)", 957).add("added: \"\"")).log();
                    }
                }
                bl = true;
                bl2 = false;
            } else if ("\n".equals(string2)) {
                if (bl2 || bl3) {
                    arrayList.add("");
                    if (Misc.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "splitLines(String)", 964).add("added: \"\"")).log();
                    }
                }
                bl2 = true;
                bl = false;
            } else {
                arrayList.add(string2);
                if (Misc.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "splitLines(String)", 970).add("added: ")).add(string2)).log();
                }
                bl2 = false;
                bl = false;
            }
            bl3 = false;
        }
        return arrayList.toArray(new String[0]);
    }

    public static long count(String string, char c) {
        if (string == null) {
            return 0L;
        }
        int n = 0;
        for (char c2 : string.toCharArray()) {
            if (c2 != c) continue;
            ++n;
        }
        return n;
    }

    public static List<Integer> indexes(String string, char c) {
        if (string == null) {
            return null;
        }
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != c) continue;
            linkedList.add(i);
        }
        return linkedList;
    }

    public static String quote(String string, String string2) {
        return Misc.quote(string, string2, '\\');
    }

    public static String quote(String string, String string2, char c) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "quote(String,String,char)", 1060).addDetail("data", string)).addDetail("toQuote", string2)).addDetail("quote", c)).log();
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (string2.indexOf(c2) >= 0) {
                stringBuilder.append(c);
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String quoteRegex(String string) {
        return Misc.quote(string, "|$[]{}().*+^?\\");
    }

    public static String unquoteRegex(String string) {
        return Misc.unquote(string, "|$[]{}().*+^?/\\");
    }

    public static String unquote(String string, String string2) {
        return Misc.unquote(string, string2, '\\');
    }

    public static String unquote(String string, String string2, char c) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unquote(String,String,char)", 1143).addDetail("data", string)).addDetail("toQuote", string2)).addDetail("quote", c)).log();
        }
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "unquote(String,String,char)", 1156).add("i", i)).add("c", c2)).log();
            }
            if (c2 == c && i < string.length() - 1) {
                char c3 = string.charAt(i + 1);
                if (Misc.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "unquote(String,String,char)", 1160).add("c2", c3)).log();
                }
                if (string2.indexOf(c3) >= 0) {
                    stringBuilder.append(c3);
                    ++i;
                    continue;
                }
                stringBuilder.append(c2);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static int unquotedIndexOf(String string, String string2, int n) {
        return Misc.unquotedIndexOf(string, string2, n, '\\');
    }

    public static int unquotedIndexOf(String string, String string2, int n, char c) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "unquotedIndexOf(String,String,int,char)", 1209).addDetail("data", string)).addDetail("chars", string2)).addDetail("start", n)).addDetail("quote", c)).log();
        }
        if (n < 0 || string != null && n > string.length()) {
            throw new IllegalArgumentException("start " + n + " out of range");
        }
        if (string == null || string2 == null) {
            return -1;
        }
        boolean bl = false;
        for (int i = n; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "unquotedIndexOf(String,String,int,char)", 1222).add("i", i)).add("c", c2)).add("quoted", bl)).log();
            }
            if (c2 == c) {
                bl = !bl;
                continue;
            }
            if (bl) {
                bl = false;
                continue;
            }
            if (string2.indexOf(c2) < 0) continue;
            return i;
        }
        return -1;
    }

    public static String removeChar(String string, char c) {
        if (string == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) continue;
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static String replaceSpecialWhitespaceCharactersByStandardWhitespace(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '\u00a0') {
                stringBuilder.append(" ");
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    public static String normalizeCharacters(String string) {
        if (string == null) {
            return null;
        }
        return string.replaceAll("[\u200b\\ufeff]", "").replaceAll("[\\s\u00a0\u2000\u2002\u2003\u2004\u2005\u2006\u2007\u2008\u2009\u200a\u3000\u202f\u205f\u205f]+", " ").replaceAll("[\u2010\u2011\u2012\u2013\u2014\u2015\u2e3a\u2e3b\ufe58\ufe63\uff0d]", "-").trim();
    }

    public static String toHex(byte[] byArray) {
        return Misc.toHex(byArray, 0, byArray.length);
    }

    public static String toHex(byte[] byArray, int n, int n2) {
        return Misc.toHex(byArray, n, n2, false);
    }

    public static String toHex(byte[] byArray, int n, int n2, boolean bl) {
        char[] cArray = bl ? nibblesLowerCase : nibbles;
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < n + n2; ++i) {
            byte by = byArray[i];
            stringBuilder.append(cArray[by >>> 4 & 0xF]);
            stringBuilder.append(cArray[by & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String toHex(int n) {
        return Integer.toHexString(n);
    }

    public static String toHex(long l) {
        return Long.toHexString(l);
    }

    public static byte[] fromHex(String string) throws IllegalArgumentException {
        int n = string.length();
        byte[] byArray = new byte[(n + 1) / 2];
        int n2 = 0;
        int n3 = 0;
        if (n % 2 != 0) {
            byArray[n3++] = (byte)Misc.hexVal(string.charAt(n2++));
        }
        while (n2 < n) {
            byArray[n3++] = (byte)(Misc.hexVal(string.charAt(n2++)) << 4 | Misc.hexVal(string.charAt(n2++)));
        }
        return byArray;
    }

    public static Color colorFromString(String string, Color color) {
        Color color2;
        block4: {
            color2 = color;
            if (string != null) {
                try {
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    if (stringTokenizer.countTokens() == 3) {
                        int n = Integer.parseInt(stringTokenizer.nextToken());
                        int n2 = Integer.parseInt(stringTokenizer.nextToken());
                        int n3 = Integer.parseInt(stringTokenizer.nextToken());
                        color2 = new Color(n, n2, n3);
                    }
                }
                catch (Exception exception) {
                    if (Misc.logger.level < 3) break block4;
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "colorFromString(String,Color)", 1441).add("ex", exception)).log();
                }
            }
        }
        return color2;
    }

    public static String arrayToString(Object object) {
        return Misc.arrayToString(object, ",");
    }

    public static String arrayToString(Object object, String string) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Object[]) {
            return Misc.arrayToString((Object[])object, string);
        }
        if (object instanceof int[]) {
            return Misc.arrayToString((int[])object, string);
        }
        if (object instanceof long[]) {
            return Misc.arrayToString((long[])object, string);
        }
        return object.toString();
    }

    public static String arrayToString(Object[] objectArray) {
        return Misc.arrayToString(objectArray, ",");
    }

    public static String arrayToString(Object[] objectArray, String string) {
        if (objectArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < objectArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(Misc.arrayToString(objectArray[i], string));
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String arrayToString(int[] nArray) {
        return Misc.arrayToString(nArray, ",");
    }

    public static String arrayToString(int[] nArray, String string) {
        if (nArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(nArray[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public static String arrayToString(long[] lArray) {
        return Misc.arrayToString(lArray, ",");
    }

    public static String arrayToString(long[] lArray, String string) {
        if (lArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder("[");
        for (int i = 0; i < lArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(lArray[i]);
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    private static String join(Iterator<? extends Object> iterator, String string) {
        return Misc.join(iterator, string, null);
    }

    private static String join(Iterator<?> iterator, String string, Function<Object, Object> function) {
        if (iterator == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        while (iterator.hasNext()) {
            Object obj = iterator.next();
            if (n > 0) {
                stringBuilder.append(string);
            }
            try {
                stringBuilder.append(function == null ? obj : function.apply(obj));
            }
            catch (Exception exception) {
                if (Misc.logger.level >= 3) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(3, "join(Iterator<?>,String,Function<Object, Object>)", 1659).add("e", exception)).log();
                }
                stringBuilder.append("<Excepted>");
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String join(Iterable<?> iterable, String string) {
        if (iterable == null) {
            return "null";
        }
        return Misc.join(iterable.iterator(), string, null);
    }

    public static String join(Iterable<?> iterable, String string, Function<Object, Object> function) {
        if (iterable == null) {
            return "null";
        }
        return Misc.join(iterable.iterator(), string, function);
    }

    public static String join(final Object[] objectArray, String string) {
        if (objectArray == null) {
            return "null";
        }
        return Misc.join((Iterator<? extends Object>)new Iterator<Object>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return objectArray.length > this.pos;
            }

            @Override
            public Object next() {
                return objectArray[this.pos++];
            }
        }, string);
    }

    public static String join(final Object object, String string) {
        if (object == null) {
            return "null";
        }
        if (object instanceof Iterable) {
            return Misc.join(((Iterable)object).iterator(), string);
        }
        if (object.getClass().isArray()) {
            final int n = Array.getLength(object);
            return Misc.join((Iterator<? extends Object>)new Iterator<Object>(){
                private int pos = 0;

                @Override
                public boolean hasNext() {
                    return n > this.pos;
                }

                @Override
                public Object next() {
                    return Array.get(object, this.pos++);
                }
            }, string);
        }
        try {
            return object.toString();
        }
        catch (Exception exception) {
            if (Misc.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "join(Object,String)", 1762).add("e", exception)).log();
            }
            return "<Excepted>";
        }
    }

    public static String join(int[] nArray, String string) {
        if (nArray == null) {
            return "null";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int n2 : nArray) {
            if (n > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(n2);
            ++n;
        }
        return stringBuilder.toString();
    }

    public static String safeTrim(String string) {
        return string == null ? null : string.trim();
    }

    public static boolean isTrimmedEmptyOrNull(String string) {
        return string == null ? true : string.trim().isEmpty();
    }

    public static String safeTrimToNull(String string) {
        if (string == null) {
            return null;
        }
        return (string = string.trim()).length() == 0 ? null : string;
    }

    @Nullable
    public static String toStringOrNull(Object object) {
        if (object == null) {
            return null;
        }
        return object.toString();
    }

    public static String[] filterEmpty(String[] stringArray) {
        if (Misc.emptyOrNull(stringArray)) {
            return stringArray;
        }
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (Misc.emptyOrNull(stringArray[i])) continue;
            ++n;
        }
        if (n == stringArray.length) {
            return stringArray;
        }
        String[] stringArray2 = new String[n];
        int n2 = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            if (Misc.emptyOrNull(stringArray[i])) continue;
            stringArray2[n2++] = stringArray[i];
        }
        return stringArray;
    }

    public static Charset getCharsetByJavaProperty(String string, Charset charset) {
        String string2;
        block7: {
            if (Misc.logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "getCharsetByJavaProperty(String,Charset)", 1910).addDetail("javaproperty", string)).addDetail("fallback", charset)).dumpStack();
            }
            if (Misc.emptyOrNull(string)) {
                return charset != null ? charset : DEFAULT_CHARSET;
            }
            string2 = null;
            try {
                string2 = System.getProperty(string);
            }
            catch (Exception exception) {
                if (Misc.logger.level < 9) break block7;
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getCharsetByJavaProperty(String,Charset)", 1922).add("e", exception)).log();
            }
        }
        try {
            return Charset.forName(string2);
        }
        catch (Exception exception) {
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getCharsetByJavaProperty(String,Charset)", 1928).add("e", exception)).log();
            }
            return charset != null ? charset : DEFAULT_CHARSET;
        }
    }

    public static String quoteSpecialCharsByUnicodeRepresentation(String string) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "quoteSpecialCharsByUnicodeRepresentation(String)", 1944).addDetail("str", string)).dumpStack();
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            char c2 = c;
            if (c2 <= '\u007f') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(String.format("\\u%04x", c));
        }
        return stringBuilder.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String getBestPath(File file) {
        String string;
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getBestPath(File)", 1975).addDetail("file", file)).dumpStack();
        }
        if (file == null) {
            return null;
        }
        if (++fileGCCount > 1000) {
            Misc.gcFileCache();
        }
        long l = System.currentTimeMillis();
        Pair<String, Long> pair = pathMap.get(file);
        if (pair != null) {
            if (l - pair.getSecond() <= fileKeepTime) return pair.getFirst();
            pathMap.remove(file);
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getBestPath(File)", 1990).add("Outdated entry for ")).add(file)).log();
            }
        } else if (Misc.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getBestPath(File)", 1995).add("No entry for ")).add(file)).log();
        }
        try {
            string = file.getCanonicalPath();
        }
        catch (Exception exception) {
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getBestPath(File)", 2002).add("ex", exception)).log();
            }
            string = file.getAbsolutePath();
        }
        pathMap.put(file, new Pair<String, Long>(string, l));
        return string;
    }

    public static String getBestPath(String string) {
        if (string == null) {
            return null;
        }
        return Misc.getBestPath(new File(string));
    }

    public static String getBestParentPath(File file) {
        if (file == null) {
            return null;
        }
        File file2 = new File(Misc.getBestPath(file));
        return file2.getParent();
    }

    public static String getBestParentPath(String string) {
        if (string == null) {
            return null;
        }
        return Misc.getBestParentPath(new File(string));
    }

    public static boolean fileOrReferenceExists(@NonNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("file is marked non-null but is null");
        }
        if (file.exists()) {
            return true;
        }
        final String string = OS_IS_WINDOWS ? file.getName().toUpperCase() : file.getName();
        String[] stringArray = file.getParentFile().list(new FilenameFilter(){

            @Override
            public boolean accept(File file, String string2) {
                return string.equals(OS_IS_WINDOWS ? string2.toUpperCase() : string2);
            }
        });
        if (Misc.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "fileOrReferenceExists(File)", 2089).add("expectedFilename", string)).add("list", stringArray)).log();
        }
        return stringArray != null && stringArray.length > 0;
    }

    public static String replaceIllegalCharacters(String string, char c) {
        return Misc.replaceIllegalCharacters(string, c, null);
    }

    public static String replaceIllegalCharacters(String string, char c, Charset charset) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "replaceIllegalCharacters(String,char,Charset)", 2129).addDetail("path", string)).addDetail("replace", c)).addDetail("charset", charset)).log();
        }
        CharsetEncoder charsetEncoder = charset == null ? null : charset.newEncoder();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            char c2 = string.charAt(i);
            if (charsetEncoder != null && !charsetEncoder.canEncode(c2)) {
                stringBuilder.append(c);
                continue;
            }
            if (c2 < ' ' || c2 == '!' || c2 == '\"' || c2 == '#' || c2 == '$' || c2 == '%' || c2 == '&' || c2 == '*' || c2 == '+' || c2 == ',' || c2 == ':' || c2 == ';' || c2 == '<' || c2 == '=' || c2 == '>' || c2 == '?' || c2 == '[' || c2 == '\'' || c2 == ']' || c2 == '^' || c2 == '|') {
                stringBuilder.append(c);
                continue;
            }
            stringBuilder.append(c2);
        }
        return stringBuilder.toString();
    }

    public static int getMajorJavaVersion() {
        Misc.parseVersion();
        return majorVersion;
    }

    public static int getMediumJavaVersion() {
        Misc.parseVersion();
        return mediumVersion;
    }

    public static int getMinorJavaVersion() {
        Misc.parseVersion();
        return minorVersion;
    }

    public static int getSubJavaVersion() {
        Misc.parseVersion();
        return subVersion;
    }

    public static final String getExtJavaVersion() {
        return extVersion;
    }

    public static int getJavaMainVersion() {
        return IS_JAVA_VERSION_AT_LEAST_9 ? Misc.getMajorJavaVersion() : Misc.getMediumJavaVersion();
    }

    public static String getJavaSubVersion() {
        return IS_JAVA_VERSION_AT_LEAST_9 ? "" + Misc.getMinorJavaVersion() : Misc.getExtJavaVersion();
    }

    public static boolean isJavaVersion(int n, int n2, int n3) {
        return Misc.isJavaVersion(n, n2, n3, -1);
    }

    public static boolean isJavaVersion(int n, int n2, int n3, int n4) {
        Misc.parseVersion();
        return !(n >= 0 && n != majorVersion || n2 >= 0 && n2 != mediumVersion || n3 >= 0 && n3 != minorVersion || n4 >= 0 && n4 != minorVersion);
    }

    public static boolean isJavaVersionAtLeast(int n, int n2, int n3) {
        return Misc.isJavaVersionAtLeast(n, n2, n3, -1);
    }

    public static boolean isJavaVersionAtLeast(int n, int n2, int n3, int n4) {
        Misc.parseVersion();
        if (n >= 0 && n < majorVersion) {
            return true;
        }
        if (n > majorVersion) {
            return false;
        }
        if (n2 >= 0 && n2 < mediumVersion) {
            return true;
        }
        if (n2 > mediumVersion) {
            return false;
        }
        if (n3 >= 0 && n3 > minorVersion) {
            return false;
        }
        return n4 < 0 || n4 <= subVersion;
    }

    public static String makeJavaIdentifier(String string) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "makeJavaIdentifier(String)", 2380).addDetail("identifier", string)).log();
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            boolean bl = i == 0 ? Character.isJavaIdentifierStart(c) : Character.isJavaIdentifierPart(c);
            if (bl) continue;
            stringBuilder.setCharAt(i, '_');
        }
        return stringBuilder.toString();
    }

    public static String getCurrentStackTrace() {
        try {
            throw new Exception("Stack dump");
        }
        catch (Exception exception) {
            return Log.getStackTrace(exception);
        }
    }

    @Deprecated
    public static String getStackTrace(Throwable throwable) {
        return Log.getStackTrace(throwable);
    }

    public static boolean toBoolean(Object object) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "toBoolean(Object)", 2443).addDetail("object", object)).log();
        }
        if (object == null) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object != 0;
        }
        String string = object.toString();
        if (string.length() == 0) {
            return false;
        }
        try {
            return Integer.parseInt(string) != 0;
        }
        catch (NumberFormatException numberFormatException) {
            return !"false".equalsIgnoreCase(string) && !"no".equalsIgnoreCase(string) && !"nein".equalsIgnoreCase(string);
        }
    }

    public static boolean toBoolean(Object object, boolean bl) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "toBoolean(Object,boolean)", 2484).addDetail("object", object)).addDetail("dflt", bl)).log();
        }
        return object == null ? bl : Misc.toBoolean(object);
    }

    public static boolean isBooleanDescriptor(String string) {
        return "true".equalsIgnoreCase(string) || "false".equalsIgnoreCase(string) || "yes".equalsIgnoreCase(string) || "ja".equalsIgnoreCase(string) || "no".equalsIgnoreCase(string) || "nein".equalsIgnoreCase(string);
    }

    public static boolean containsOnlyDigits(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    public static Object[] mergeObjectArrays(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == null) {
            return objectArray2;
        }
        if (objectArray2 == null) {
            return objectArray;
        }
        Object[] objectArray3 = new String[objectArray.length + objectArray2.length];
        System.arraycopy(objectArray, 0, objectArray3, 0, objectArray.length);
        System.arraycopy(objectArray2, 0, objectArray3, objectArray.length, objectArray2.length);
        return objectArray3;
    }

    public static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        if (stringArray == null) {
            return stringArray2;
        }
        if (stringArray2 == null) {
            return stringArray;
        }
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        System.arraycopy(stringArray, 0, stringArray3, 0, stringArray.length);
        System.arraycopy(stringArray2, 0, stringArray3, stringArray.length, stringArray2.length);
        return stringArray3;
    }

    public static <T> boolean isObjectInIterable(@Nullable T t, @Nullable Iterable<T> iterable) {
        if (t == null || iterable == null) {
            return false;
        }
        for (T t2 : iterable) {
            if (!t.equals(t2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDesktopActionSupported(Desktop.Action action) {
        return Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesWithEncoding(String string, String string2) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            FileInputStream fileInputStream2;
            fileInputStream = fileInputStream2 = new FileInputStream(string);
            Properties properties = Misc.loadPropertiesWithEncoding(fileInputStream2, string2);
            return properties;
        }
        finally {
            block8: {
                if (fileInputStream != null) {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {
                        if (Misc.logger.level < 3) break block8;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "loadPropertiesWithEncoding(String,String)", 2624).add("ex", iOException)).log();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertiesWithEncoding(InputStream inputStream, String string) throws IOException {
        InputStream inputStream2 = null;
        Properties properties = new Properties();
        try {
            Object object;
            if (!"ISO-8859-1".equals(string)) {
                object = new InputStreamReader(inputStream, string);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                CharsetEncoder charsetEncoder = UTF8_CHARSET.newEncoder();
                int n = ((InputStreamReader)object).read();
                while (n >= 0) {
                    if (n <= 255 && charsetEncoder.canEncode((char)n)) {
                        byteArrayOutputStream.write(n);
                    } else {
                        if (Misc.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadPropertiesWithEncoding(InputStream,String)", 2648).add("c", n)).log();
                        }
                        byteArrayOutputStream.write(92);
                        byteArrayOutputStream.write(117);
                        byteArrayOutputStream.write(String.format("%04X", n).getBytes("ISO-8859-1"));
                    }
                    n = ((InputStreamReader)object).read();
                }
                ((InputStreamReader)object).close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                if (Misc.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadPropertiesWithEncoding(InputStream,String)", 2657).add("data", new String(byArray, "ISO-8859-1"))).log();
                }
                inputStream2 = inputStream = new ByteArrayInputStream(byArray);
            }
            properties.load(inputStream);
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "loadPropertiesWithEncoding(InputStream,String)", 2662).add("props", properties)).log();
            }
            inputStream.close();
            object = properties;
            return object;
        }
        finally {
            block15: {
                if (inputStream2 != null) {
                    try {
                        inputStream2.close();
                    }
                    catch (IOException iOException) {
                        if (Misc.logger.level < 3) break block15;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "loadPropertiesWithEncoding(InputStream,String)", 2670).add("ex", iOException)).log();
                    }
                }
            }
        }
    }

    public static Charset getInternalEncoding(PrintStream printStream) {
        try {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)Reflector.get(printStream, "charOut", true);
            String string = outputStreamWriter.getEncoding();
            return Charset.forName(string);
        }
        catch (Throwable throwable) {
            if (Misc.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getInternalEncoding(PrintStream)", 2695).add("ex", throwable)).log();
            }
            return null;
        }
    }

    public static PrintStream createCompatibleStream(OutputStream outputStream, PrintStream printStream) {
        try {
            OutputStreamWriter outputStreamWriter = (OutputStreamWriter)Reflector.get(printStream, "charOut", true);
            String string = outputStreamWriter.getEncoding();
            boolean bl = (Boolean)Reflector.get(printStream, "autoFlush", true);
            return new PrintStream(outputStream, bl, string);
        }
        catch (Throwable throwable) {
            if (Misc.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "createCompatibleStream(OutputStream,PrintStream)", 2720).add("ex", throwable)).log();
            }
            return new PrintStream(outputStream);
        }
    }

    private static int hexVal(char c) throws IllegalArgumentException {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 55;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 87;
            }
        }
        throw new IllegalArgumentException("Not a hex digit: " + c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void parseVersion() {
        Object object = classlock;
        synchronized (object) {
            int n;
            int n2;
            if (majorVersion >= 0) {
                return;
            }
            if (Misc.logger.level >= 7) {
                logger.lvlBuild(7, "parseVersion()", 2789).log();
            }
            majorVersion = 0;
            mediumVersion = 0;
            minorVersion = 0;
            subVersion = 0;
            extVersion = null;
            String string = javaVersionString;
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "parseVersion()", 2798).add("version", string)).log();
            }
            int n3 = string.length();
            for (n2 = 0; n2 < n3 && ((n = (int)string.charAt(n2)) == 46 || Character.isDigit((char)n)); ++n2) {
            }
            n = -1;
            boolean bl = false;
            for (int i = 0; i < 4; ++i) {
                String string2;
                int n4 = string.indexOf(46, n + '\u0001');
                if (n4 > n) {
                    string2 = string.substring(n + 1, n4);
                } else if (n2 < n3) {
                    string2 = string.substring(n + 1, n2);
                    if (n2 < n3 - 1) {
                        extVersion = string.substring(n2 + 1);
                        if (Misc.logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "parseVersion()", 2820).add("extVersion", extVersion)).log();
                        }
                    }
                    bl = true;
                } else {
                    string2 = string.substring(n + 1);
                    bl = true;
                }
                n = n4;
                int n5 = 0;
                try {
                    n5 = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (Misc.logger.level >= 3) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "parseVersion()", 2832).add("ex", numberFormatException)).log();
                    }
                    return;
                }
                switch (i) {
                    case 0: {
                        majorVersion = n5;
                        if (Misc.logger.level < 9) break;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "parseVersion()", 2838).add("majorVersion", majorVersion)).log();
                        break;
                    }
                    case 1: {
                        mediumVersion = n5;
                        if (Misc.logger.level < 9) break;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "parseVersion()", 2842).add("mediumVersion", mediumVersion)).log();
                        break;
                    }
                    case 2: {
                        minorVersion = n5;
                        if (Misc.logger.level < 9) break;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "parseVersion()", 2846).add("minorVersion", minorVersion)).log();
                        break;
                    }
                    case 3: {
                        subVersion = n5;
                        if (Misc.logger.level < 9) break;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "parseVersion()", 2850).add("subVersion", subVersion)).log();
                    }
                }
                if (bl) break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void gcFileCache() {
        if (Misc.logger.level >= 7) {
            logger.lvlBuild(7, "gcFileCache()", 2868).log();
        }
        fileGCCount = 0;
        long l = System.currentTimeMillis();
        Map<File, Pair<String, Long>> map = pathMap;
        synchronized (map) {
            Iterator<Map.Entry<File, Pair<String, Long>>> iterator = pathMap.entrySet().iterator();
            while (iterator.hasNext()) {
                if (l - iterator.next().getValue().getSecond() <= fileKeepTime) continue;
                iterator.remove();
            }
        }
    }

    public static boolean hasModifier(@NonNull ActionEvent actionEvent, int n) {
        if (actionEvent == null) {
            throw new IllegalArgumentException("event is marked non-null but is null");
        }
        int n2 = actionEvent.getModifiers();
        return (n2 & n) == n;
    }

    public static boolean altPressed(@NonNull ActionEvent actionEvent) {
        if (actionEvent == null) {
            throw new IllegalArgumentException("event is marked non-null but is null");
        }
        return Misc.hasModifier(actionEvent, 8);
    }

    public static boolean ctrlPressed(@NonNull ActionEvent actionEvent) {
        if (actionEvent == null) {
            throw new IllegalArgumentException("event is marked non-null but is null");
        }
        return Misc.hasModifier(actionEvent, 2);
    }

    public static boolean metaPressed(@NonNull ActionEvent actionEvent) {
        if (actionEvent == null) {
            throw new IllegalArgumentException("event is marked non-null but is null");
        }
        return Misc.hasModifier(actionEvent, 4);
    }

    public static boolean shiftPressed(@NonNull ActionEvent actionEvent) {
        if (actionEvent == null) {
            throw new IllegalArgumentException("event is marked non-null but is null");
        }
        return Misc.hasModifier(actionEvent, 1);
    }

    private static boolean getSystemIs64Bit() {
        if (JAVA_IS_64_BIT) {
            return true;
        }
        if (OS_IS_WINDOWS) {
            return System.getenv("ProgramFiles(x86)") != null;
        }
        try {
            boolean bl;
            int n;
            ProcessManager processManager = new ProcessManager("uname", new String[]{"uname", "-a"});
            processManager.setCollect(true, false);
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSystemIs64Bit()", 2958).add("Starting process")).log();
            }
            processManager.startProcess();
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSystemIs64Bit()", 2961).add("Waiting for process")).log();
            }
            boolean bl2 = processManager.waitFor(3000L);
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSystemIs64Bit()", 2963).add("ret", bl2)).log();
            }
            if (bl2) {
                n = processManager.getExitCode();
            } else {
                processManager.terminateProcess(1);
                n = 1;
            }
            String string = processManager.getProcessOutputString();
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "getSystemIs64Bit()", 2973).add("exitCode", n)).add("out", string)).log();
            }
            boolean bl3 = bl = n == 0 && string != null && string.indexOf("64") > -1;
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getSystemIs64Bit()", 2976).add("is64bit", bl)).log();
            }
            return bl;
        }
        catch (Exception exception) {
            if (Misc.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "getSystemIs64Bit()", 2980).add("e", exception)).log();
            }
            return false;
        }
    }

    public static void safeSleep(long l) {
        Misc.safeSleep(l, 0);
    }

    public static void safeSleep(long l, int n) {
        block5: {
            if (l <= 0L) {
                return;
            }
            try {
                if (Misc.logger.level >= 10) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(10, "safeSleep(long,int)", 3006).add("Sleeping for ")).add(l)).add(" ms, ")).add(n)).add(" nanos")).log();
                }
                Thread.sleep(l, n);
                if (Misc.logger.level >= 10) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(10, "safeSleep(long,int)", 3008).add("Wakeup")).log();
                }
            }
            catch (InterruptedException interruptedException) {
                if (Misc.logger.level < 5) break block5;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "safeSleep(long,int)", 3010).add("e", interruptedException)).log();
            }
        }
    }

    public static <T, R extends List<T>> R fillList(@NonNull R r, T ... TArray) {
        if (r == null) {
            throw new IllegalArgumentException("list is marked non-null but is null");
        }
        Collections.addAll(r, TArray);
        return r;
    }

    public static <T> List<T> listOf(T ... TArray) {
        return Misc.fillList(new ArrayList(TArray.length), TArray);
    }

    public static <T, R extends Set<T>> R fillSet(@NonNull R r, T ... TArray) {
        if (r == null) {
            throw new IllegalArgumentException("set is marked non-null but is null");
        }
        Collections.addAll(r, TArray);
        return r;
    }

    public static <T> Set<T> setOf(T ... TArray) {
        return Misc.fillSet(new HashSet(TArray.length), TArray);
    }

    public static <S, T, R extends Map<S, T>> R fillMap(@NonNull R r, Object ... objectArray) {
        if (r == null) {
            throw new IllegalArgumentException("map is marked non-null but is null");
        }
        for (int i = 0; i < objectArray.length; i += 2) {
            Object object = objectArray[i];
            Object object2 = objectArray.length > i + 1 ? objectArray[i + 1] : null;
            r.put((Object)object, (Object)object2);
        }
        return r;
    }

    public static <S, T> Map<S, T> mapOf(Object ... objectArray) {
        return Misc.fillMap(new HashMap((objectArray.length + 1) / 2), objectArray);
    }

    @Nullable
    public static String truncatedString(@Nullable String string, int n) {
        return Misc.truncatedString(string, n, false, true);
    }

    @Nullable
    public static String truncatedString(@Nullable String string, int n, boolean bl, boolean bl2) {
        int n2;
        if (string == null) {
            return null;
        }
        if (n <= 0) {
            return "";
        }
        int n3 = string.length();
        if (n >= n3) {
            return string;
        }
        if (!bl && n <= 3) {
            return string.substring(0, n);
        }
        int n4 = n2 = bl ? 1 : 3;
        if (bl2) {
            return string.substring(0, n - n2) + (bl ? STR_ELLIPSIS : "...");
        }
        return (bl ? STR_ELLIPSIS : "...") + string.substring(n3 - n + n2);
    }

    @Nullable
    public static String getFilenameOfClass(@NonNull Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("theClass is marked non-null but is null");
        }
        try {
            String string = clazz.getProtectionDomain().getCodeSource().getLocation().toURI().toString();
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getFilenameOfClass(Class<?>)", 3167).add("uri", string)).log();
            }
            string = string.replaceFirst("^file://", "file:////");
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getFilenameOfClass(Class<?>)", 3169).add("uri", string)).log();
            }
            String string2 = new File(new URI(string)).getAbsolutePath();
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "getFilenameOfClass(Class<?>)", 3171).add("fileName", string2)).log();
            }
            return string2;
        }
        catch (Exception exception) {
            if (Misc.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "getFilenameOfClass(Class<?>)", 3174).add("e", exception)).log();
            }
            return null;
        }
    }

    @Nullable
    public static String sendGETRequest(@NonNull String string) {
        if (string == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        return Misc.sendGETRequest(string, null);
    }

    @Nullable
    public static String sendGETRequest(@NonNull String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        try {
            return Misc.sendGETRequest(new URL(string), string2);
        }
        catch (MalformedURLException malformedURLException) {
            if (Misc.logger.level >= 3) {
                ((LevelAwareLogBuilder)logger.lvlBuild(3, "sendGETRequest(String,String)", 3196).add("e", malformedURLException)).log();
            }
            return null;
        }
    }

    @Nullable
    public static String sendGETRequest(@NonNull URL uRL) {
        if (uRL == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        return Misc.sendGETRequest(uRL, null);
    }

    @Nullable
    public static String sendGETRequest(@NonNull URL uRL, String string) {
        if (uRL == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        return Misc.sendGETRequest(uRL, string, 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String sendGETRequest(@NonNull URL uRL, String string, int n) {
        int n2;
        if (uRL == null) {
            throw new IllegalArgumentException("url is marked non-null but is null");
        }
        if (string == null) {
            string = "UTF8";
        }
        StringBuilder stringBuilder = null;
        BufferedReader bufferedReader = null;
        try {
            String string2;
            URLConnection uRLConnection = uRL.openConnection();
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream(), string));
            stringBuilder = new StringBuilder();
            while ((string2 = bufferedReader.readLine()) != null) {
                stringBuilder.append(string2);
            }
        }
        catch (IOException iOException) {
            n2 = n;
            if (Misc.logger.level >= n2) {
                ((LevelAwareLogBuilder)logger.lvlBuild(n2, "sendGETRequest(URL,String,int)", 3239).add("e", iOException)).log();
            }
        }
        finally {
            block18: {
                if (bufferedReader != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        n2 = n;
                        if (Misc.logger.level < n2) break block18;
                        ((LevelAwareLogBuilder)logger.lvlBuild(n2, "sendGETRequest(URL,String,int)", 3245).add("ex", iOException)).log();
                    }
                }
            }
        }
        if (stringBuilder != null) {
            return stringBuilder.toString();
        }
        return null;
    }

    public static String hashString(String string, @NonNull String string2) {
        if (string2 == null) {
            throw new IllegalArgumentException("algorithm is marked non-null but is null");
        }
        if (string == null) {
            return null;
        }
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(string2);
            messageDigest.update(string.getBytes());
            byte[] byArray = messageDigest.digest();
            return Misc.toHex(byArray);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            if (Misc.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "hashString(String,String)", 3275).add("e", noSuchAlgorithmException)).log();
            }
            return null;
        }
    }

    @Nullable
    public static <T> T waitFor(@NonNull Callable<T> callable, long l, long l2) throws Exception {
        if (callable == null) {
            throw new IllegalArgumentException("proc is marked non-null but is null");
        }
        long l3 = System.currentTimeMillis();
        long l4 = l3 + l;
        if (Misc.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "waitFor(Callable<T>,long,long)", 3292).add("until", l4)).log();
        }
        while (true) {
            T t = callable.call();
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "waitFor(Callable<T>,long,long)", 3295).add("ret", t)).log();
            }
            if (t != null) {
                return t;
            }
            long l5 = l4 - System.currentTimeMillis();
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "waitFor(Callable<T>,long,long)", 3301).add("rest", l5)).log();
            }
            if (l5 <= 0L) {
                return null;
            }
            Thread.sleep(Math.min(l5, l2));
        }
    }

    public static boolean atomicDecrement(AtomicInteger atomicInteger, int n) {
        int n2 = atomicInteger.get();
        boolean bl = false;
        while (n2 > n && !bl) {
            bl = atomicInteger.compareAndSet(n2, n2 - 1);
            if (bl) continue;
            n2 = atomicInteger.get();
        }
        return bl;
    }

    public static boolean atomicDecrement(AtomicLong atomicLong, long l) {
        long l2 = atomicLong.get();
        boolean bl = false;
        while (l2 > l && !bl) {
            bl = atomicLong.compareAndSet(l2, l2 - 1L);
            if (bl) continue;
            l2 = atomicLong.get();
        }
        return bl;
    }

    public static void atomicIncrement(AtomicInteger atomicInteger, int n) {
        int n2 = atomicInteger.get();
        boolean bl = false;
        while (n2 < n && !bl) {
            bl = atomicInteger.compareAndSet(n2, n2 + 1);
            if (bl) continue;
            n2 = atomicInteger.get();
        }
    }

    public static void atomicIncrement(AtomicLong atomicLong, long l) {
        long l2 = atomicLong.get();
        boolean bl = false;
        while (l2 < l && !bl) {
            bl = atomicLong.compareAndSet(l2, l2 + 1L);
            if (bl) continue;
            l2 = atomicLong.get();
        }
    }

    public static int getFreeTcpPort() {
        return Misc.getFreeTcpPorts(1)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getFreeTcpPorts(int n) {
        int n2;
        int[] nArray = new int[n];
        ServerSocket[] serverSocketArray = new ServerSocket[n];
        try {
            for (n2 = 0; n2 < n; ++n2) {
                try {
                    serverSocketArray[n2] = new ServerSocket(0);
                    nArray[n2] = serverSocketArray[n2].getLocalPort();
                    continue;
                }
                catch (IOException iOException) {
                    if (Misc.logger.level < 5) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "getFreeTcpPorts(int)", 3416).add("e", iOException)).log();
                }
            }
        }
        finally {
            for (n2 = 0; n2 < n; ++n2) {
                if (serverSocketArray[n2] == null) continue;
                try {
                    serverSocketArray[n2].close();
                    continue;
                }
                catch (Exception exception) {
                    if (Misc.logger.level < 1) continue;
                    ((LevelAwareLogBuilder)logger.lvlBuild(1, "getFreeTcpPorts(int)", 3425).add("e", exception)).log();
                }
            }
        }
        return nArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPortInUse(int n) {
        try {
            try (ServerSocket serverSocket = new ServerSocket(n);){
                boolean bl = false;
                return bl;
            }
            catch (IOException iOException) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <T> T valueOrDefault(@Nullable T t, T t2) {
        if (t == null) {
            return t2;
        }
        return t;
    }

    public static String appendDirectoryToPath(@NonNull String string, @Nullable String string2) {
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "appendDirectoryToPath(String,String)", 3475).addDetail("directory", string)).addDetail("path", string2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("directory is marked non-null but is null");
        }
        if (Misc.emptyOrNull(string)) {
            return string2;
        }
        String string3 = Misc.getBestPath(string);
        if (Misc.emptyOrNull(string2)) {
            return string3;
        }
        for (String string4 : string2.split(File.pathSeparator)) {
            if (string4.length() <= 0 || !Misc.getBestPath(string4).equals(string3)) continue;
            if (Misc.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "appendDirectoryToPath(String,String)", 3486).add("directory", string)).add("already on path", string2)).log();
            }
            return string2;
        }
        String string5 = string2 + File.pathSeparator + string3;
        if (Misc.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "appendDirectoryToPath(String,String)", 3491).add("ret", string5)).log();
        }
        return string5;
    }

    @Nullable
    public static String removeDirectoryFromPath(@NonNull String string, @Nullable String string2) {
        String string3;
        if (Misc.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "removeDirectoryFromPath(String,String)", 3510).addDetail("directory", string)).addDetail("path", string2)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("directory is marked non-null but is null");
        }
        if (Misc.emptyOrNull(string2)) {
            return string2;
        }
        String string4 = Misc.getBestPath(string);
        LinkedHashSet linkedHashSet = Misc.fillSet(new LinkedHashSet(), string2.split(File.pathSeparator));
        Iterator iterator = linkedHashSet.iterator();
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            if (!Misc.emptyOrNull(string3) && !Misc.getBestPath(string3).equals(string4)) continue;
            iterator.remove();
        }
        string3 = Misc.join(linkedHashSet, File.pathSeparator);
        if (Misc.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "removeDirectoryFromPath(String,String)", 3527).add("ret", string3)).log();
        }
        return string3;
    }

    public static String[] removeElementFromArray(int n, String[] stringArray) {
        int n2 = stringArray.length;
        if (n2 == 0) {
            return stringArray;
        }
        if (n < 0 || n > n2 - 1) {
            return stringArray;
        }
        String[] stringArray2 = new String[n2 - 1];
        System.arraycopy(stringArray, 0, stringArray2, 0, n);
        System.arraycopy(stringArray, n + 1, stringArray2, n, stringArray2.length - n);
        return stringArray2;
    }

    public static String getFullClassName(Class<?> clazz) {
        try {
            Field field = null;
            try {
                field = clazz.getDeclaredField("logger");
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (field == null) {
                Field[] fieldArray;
                for (Field field2 : fieldArray = clazz.getDeclaredFields()) {
                    if (!Logger.class.isAssignableFrom(field2.getType())) continue;
                    field = field2;
                    break;
                }
            }
            return ((Logger)Reflector.safeGet(clazz, field.getName(), true)).getOwnerName();
        }
        catch (Exception exception) {
            return clazz.getName();
        }
    }

    public static String getSimpleClassName(Class<?> clazz) {
        String string = Misc.getFullClassName(clazz);
        String[] stringArray = Misc.fastSplit(string, '.');
        return stringArray[stringArray.length - 1];
    }

    public static void tryNTimes(int n, final Runnable runnable) {
        Misc.tryNTimes(n, new Supplier<Void>(){

            @Override
            public Void get() {
                runnable.run();
                return null;
            }
        });
    }

    @Nullable
    public static <T> T tryNTimes(int n, @NonNull Supplier<T> supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is marked non-null but is null");
        }
        for (int i = 0; i < Math.max(1, n); ++i) {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                if (Misc.logger.level >= 5) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(5, "tryNTimes(int,Supplier<T>)", 3635).add("ex", exception)).log();
                }
                Misc.safeSleep(Math.max(1, 100 * i));
                continue;
            }
        }
        return null;
    }

    public static void tryThreeTimes(Runnable runnable) {
        Misc.tryNTimes(3, runnable);
    }

    @Nullable
    public static <T> T tryThreeTimes(@NonNull Supplier<T> supplier) {
        if (supplier == null) {
            throw new IllegalArgumentException("supplier is marked non-null but is null");
        }
        return Misc.tryNTimes(3, supplier);
    }

    public static String getOsShortName() {
        if (OS_IS_WINDOWS) {
            return "win";
        }
        if (OS_IS_LINUX) {
            return "linux";
        }
        return "mac";
    }

    public static String getOsLongName() {
        if (OS_IS_WINDOWS) {
            return "Windows";
        }
        if (OS_IS_LINUX) {
            return "Linux";
        }
        return "macOS";
    }

    public static String commonPath(String ... stringArray) {
        int n;
        String string = "";
        String[][] stringArrayArray = new String[stringArray.length][];
        for (n = 0; n < stringArray.length; ++n) {
            stringArrayArray[n] = Misc.fastSplit(stringArray[n], File.separatorChar);
        }
        for (n = 0; n < stringArrayArray[0].length; ++n) {
            String string2 = stringArrayArray[0][n];
            for (int i = 1; i < stringArray.length; ++i) {
                if (string2.equals(stringArrayArray[i][n])) continue;
                return string;
            }
            string = string + string2 + File.separatorChar;
        }
        return string;
    }

    private static boolean getIsMacOSWithArm64Architecture() {
        block4: {
            if (!OS_IS_MAC_OS_X) {
                return false;
            }
            try {
                String string = ProcessManager.runProcess("uname -a");
                if (string != null && string.contains("ARM64")) {
                    return true;
                }
            }
            catch (ProcessManager.RunProcessException runProcessException) {
                if (Misc.logger.level < 5) break block4;
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "getIsMacOSWithArm64Architecture()", 3727).add("Could not determine macOS processor architecture", runProcessException)).log();
            }
        }
        return false;
    }

    public static int findMatchingClose(String string, int n, char c, char c2) {
        int n2 = string.length();
        int n3 = 1;
        for (int i = n; i < n2; ++i) {
            char c3 = string.charAt(i);
            if (c3 == c2 && --n3 == 0) {
                return i;
            }
            if (c3 != c) continue;
            ++n3;
        }
        return -1;
    }

    public static boolean containsEscapeCharacters(String string) {
        if (string == null) {
            return false;
        }
        Matcher matcher = ESCAPE_CHAR_PATTERN.matcher(string);
        if (matcher.matches()) {
            System.out.println(matcher.group(1));
            return matcher.group(1).length() % 2 == 1;
        }
        return false;
    }

    public static String replaceMatches(String string, Pattern pattern, Function<Matcher, String> function) {
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = function.apply(matcher);
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string2));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String applyEngineAliases(String string) {
        if (!Misc.emptyOrNull(string)) {
            String string2 = string.toLowerCase();
            if (string2.startsWith("swing")) {
                string = "awt" + string.substring(5);
            }
            if (string2.startsWith("pdf")) {
                string = "awt" + string.substring(3);
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static boolean isSystemWith64Bit() {
        Object object = systemWith64Bit.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = systemWith64Bit;
            synchronized (atomicReference) {
                object = systemWith64Bit.get();
                if (object == null) {
                    boolean bl = Misc.getSystemIs64Bit();
                    object = bl;
                    systemWith64Bit.set(object);
                }
            }
        }
        return (Boolean)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static boolean isMacOsAppleSilicon() {
        Object object = macOsAppleSilicon.get();
        if (object == null) {
            AtomicReference<Object> atomicReference = macOsAppleSilicon;
            synchronized (atomicReference) {
                object = macOsAppleSilicon.get();
                if (object == null) {
                    boolean bl = Misc.getIsMacOSWithArm64Architecture();
                    object = bl;
                    macOsAppleSilicon.set(object);
                }
            }
        }
        return (Boolean)object;
    }

    static {
        Charset charset;
        logger = new QFLogger("de.qfs.lib.util.Misc");
        ESCAPE_CHAR_PATTERN = Pattern.compile(".*?(\\\\+)[nNrtbfoxuU].*");
        classlock = new Object();
        nibbles = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        nibblesLowerCase = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        javaVersionString = System.getProperty("java.version");
        majorVersion = -1;
        mediumVersion = -1;
        minorVersion = -1;
        subVersion = -1;
        extVersion = null;
        IS_JAVA_VERSION_6 = Misc.isJavaVersion(1, 6, -1);
        IS_JAVA_VERSION_7 = Misc.isJavaVersion(1, 7, -1);
        IS_JAVA_VERSION_8 = Misc.isJavaVersion(1, 8, -1);
        IS_JAVA_VERSION_9 = Misc.isJavaVersion(9, -1, -1);
        IS_JAVA_VERSION_10 = Misc.isJavaVersion(10, -1, -1);
        IS_JAVA_VERSION_11 = Misc.isJavaVersion(11, -1, -1);
        IS_JAVA_VERSION_12 = Misc.isJavaVersion(12, -1, -1);
        IS_JAVA_VERSION_13 = Misc.isJavaVersion(13, -1, -1);
        IS_JAVA_VERSION_14 = Misc.isJavaVersion(14, -1, -1);
        IS_JAVA_VERSION_15 = Misc.isJavaVersion(15, -1, -1);
        IS_JAVA_VERSION_16 = Misc.isJavaVersion(16, -1, -1);
        IS_JAVA_VERSION_17 = Misc.isJavaVersion(17, -1, -1);
        IS_JAVA_VERSION_21 = Misc.isJavaVersion(21, -1, -1);
        IS_JAVA_VERSION_25 = Misc.isJavaVersion(25, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_7 = Misc.isJavaVersionAtLeast(1, 7, -1);
        IS_JAVA_VERSION_AT_LEAST_8 = Misc.isJavaVersionAtLeast(1, 8, -1);
        IS_JAVA_VERSION_AT_LEAST_9 = Misc.isJavaVersionAtLeast(9, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_10 = Misc.isJavaVersionAtLeast(10, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_11 = Misc.isJavaVersionAtLeast(11, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_12 = Misc.isJavaVersionAtLeast(12, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_13 = Misc.isJavaVersionAtLeast(13, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_14 = Misc.isJavaVersionAtLeast(14, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_15 = Misc.isJavaVersionAtLeast(15, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_16 = Misc.isJavaVersionAtLeast(16, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_17 = Misc.isJavaVersionAtLeast(17, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_21 = Misc.isJavaVersionAtLeast(21, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_24 = Misc.isJavaVersionAtLeast(24, -1, -1);
        IS_JAVA_VERSION_AT_LEAST_25 = Misc.isJavaVersionAtLeast(25, -1, -1);
        OS_IS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
        OS_IS_LINUX = System.getProperty("os.name").indexOf("Linux") >= 0;
        OS_IS_MAC_OS_X = System.getProperty("os.name").toUpperCase().indexOf("MAC OS X") >= 0;
        JAVA_IS_ARM = System.getProperty("os.arch") != null && (System.getProperty("os.arch").indexOf("arm") >= 0 || System.getProperty("os.arch").indexOf("aarch") >= 0);
        JAVA_IS_64_BIT = System.getProperty("os.arch") != null && System.getProperty("os.arch").indexOf("64") >= 0;
        systemWith64Bit = new AtomicReference();
        macOsAppleSilicon = new AtomicReference();
        NATIVE_LINEBREAK = OS_IS_WINDOWS ? "\r\n" : "\n";
        pathMap = Collections.synchronizedMap(new HashMap());
        fileKeepTime = 1000L;
        LATIN1_CHARSET = StandardCharsets.ISO_8859_1;
        UTF8_CHARSET = StandardCharsets.UTF_8;
        UTF16_CHARSET = StandardCharsets.UTF_16;
        IBM437_CHARSET = Charset.forName("IBM437");
        US_ASCII_CHARSET = Charset.forName("US-ASCII");
        DEFAULT_CHARSET = Charset.defaultCharset();
        Charset charset2 = NATIVE_CHARSET = System.getProperty("native.encoding") == null ? DEFAULT_CHARSET : Charset.forName(System.getProperty("native.encoding"));
        STDOUT_CHARSET = System.getProperty("stdout.encoding") != null ? Charset.forName(System.getProperty("stdout.encoding")) : (System.getProperty("sun.stdout.encoding") != null ? Charset.forName(System.getProperty("sun.stdout.encoding")) : ((charset = Misc.getInternalEncoding(System.out)) != null ? charset : NATIVE_CHARSET));
        STDERR_CHARSET = System.getProperty("stderr.encoding") != null ? Charset.forName(System.getProperty("stderr.encoding")) : (System.getProperty("sun.stderr.encoding") != null ? Charset.forName(System.getProperty("sun.stderr.encoding")) : ((charset = Misc.getInternalEncoding(System.err)) != null ? charset : NATIVE_CHARSET));
    }

    public static class DebugInputStream
    extends InputStream {
        private final InputStream delegate;

        public DebugInputStream(InputStream inputStream) {
            this.delegate = inputStream;
        }

        @Override
        public int read() throws IOException {
            int n = this.delegate.read();
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "DebugInputStream.read()", 3879).add("ret", n)).add("this", this)).dumpStack();
            }
            return n;
        }
    }

    public static class DebugOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        public DebugOutputStream(OutputStream outputStream) {
            this.delegate = outputStream;
        }

        @Override
        public void write(int n) throws IOException {
            if (logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "DebugOutputStream.write(int)", 3843).add("b", n)).add("this", this)).dumpStack();
            }
            this.delegate.write(n);
        }
    }
}

