/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.Misc;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class MultiMap
implements Map,
Cloneable,
Serializable {
    static final long serialVersionUID = 5827101685390117257L;
    private static final Logger logger = new Logger("de.qfs.lib.util.MultiMap");
    protected static final int KEYS = 0;
    protected static final int VALUES = 1;
    protected static final int ENTRIES = 2;
    private Map delegate;
    protected int valCount;
    protected transient Set keySet;
    protected transient Collection values;
    protected transient Set entrySet;
    protected transient int modCounter = 0;

    public MultiMap() {
        this.delegate = this.createDelegate(16);
    }

    public MultiMap(int n) {
        this.delegate = this.createDelegate(n);
    }

    public MultiMap(Map map) {
        this.delegate = this.createDelegate(map.size());
        this.putAll(map);
    }

    @Override
    public boolean isEmpty() {
        return this.valCount == 0;
    }

    @Override
    public int size() {
        return this.valCount;
    }

    public Object get(Object object) {
        Object v = this.delegate.get(object);
        if (v instanceof ValueSet) {
            if (((ValueSet)v).size() == 0) {
                return null;
            }
            return ((ValueSet)v).iterator().next();
        }
        return v;
    }

    @Override
    public boolean containsKey(Object object) {
        if (this.delegate.containsKey(object)) {
            Object v = this.delegate.get(object);
            return !(v instanceof ValueSet) || ((ValueSet)v).size() != 0;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        for (Object e : this.values()) {
            if (!(e instanceof ValueSet ? ((ValueSet)e).contains(object) : Misc.equalOrNull(e, object))) continue;
            return true;
        }
        return false;
    }

    public Object put(Object object, Object object2) {
        if (MultiMap.logger.level >= 7) {
            logger.log(7, "put(Object,Object)", MultiMap.logger.level < 8 ? "" : "key: " + object + ", hash: " + (object == null ? 0 : object.hashCode()) + ", value: " + object2);
        }
        if (!this.delegate.containsKey(object)) {
            this.delegate.put(object, object2);
            ++this.valCount;
            ++this.modCounter;
            return null;
        }
        Object v = this.delegate.get(object);
        if (v instanceof ValueSet) {
            if (((ValueSet)v).add(object2)) {
                ++this.valCount;
                ++this.modCounter;
            }
        } else if (!Misc.equalOrNull(v, object2)) {
            ValueSet valueSet = this.createValueSet();
            valueSet.add(v);
            valueSet.add(object2);
            ++this.valCount;
            ++this.modCounter;
            this.delegate.put(object, valueSet);
        }
        return null;
    }

    public void putAll(Map map) {
        if (MultiMap.logger.level >= 7) {
            logger.log(7, "putAll(Map)", MultiMap.logger.level < 8 ? "" : "map: " + map);
        }
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object remove(Object object) {
        if (MultiMap.logger.level >= 7) {
            logger.log(7, "remove(Object)", MultiMap.logger.level < 8 ? "" : "key: " + object + ", hash: " + (object == null ? 0 : object.hashCode()));
        }
        if (!this.delegate.containsKey(object)) {
            return null;
        }
        Object v = this.delegate.get(object);
        if (v instanceof ValueSet) {
            this.delegate.remove(object);
            if (((ValueSet)v).size() > 0) {
                this.valCount -= ((ValueSet)v).size();
                ++this.modCounter;
                Object e = ((ValueSet)v).iterator().next();
                return e;
            }
            return null;
        }
        --this.valCount;
        ++this.modCounter;
        return this.delegate.remove(object);
    }

    @Override
    public void clear() {
        if (MultiMap.logger.level >= 7) {
            logger.log(7, "clear()", "");
        }
        this.delegate.clear();
        this.valCount = 0;
        ++this.modCounter;
    }

    public Set keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new MapIterator(0);
                }

                @Override
                public int size() {
                    return MultiMap.this.delegate.size();
                }

                @Override
                public boolean contains(Object object) {
                    return MultiMap.this.delegate.containsKey(object);
                }

                @Override
                public boolean remove(Object object) {
                    return MultiMap.this.remove(object) != null;
                }

                @Override
                public void clear() {
                    MultiMap.this.clear();
                }
            };
        }
        return this.keySet;
    }

    public Collection values() {
        if (this.values == null) {
            this.values = new AbstractCollection(){

                @Override
                public Iterator iterator() {
                    return new MapIterator(1);
                }

                @Override
                public int size() {
                    return MultiMap.this.valCount;
                }

                @Override
                public boolean contains(Object object) {
                    return MultiMap.this.containsValue(object);
                }

                @Override
                public void clear() {
                    MultiMap.this.clear();
                }
            };
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet(){

                @Override
                public Iterator iterator() {
                    return new MapIterator(2);
                }

                @Override
                public boolean contains(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    Object k = entry.getKey();
                    if (!MultiMap.this.delegate.containsKey(k)) {
                        return false;
                    }
                    Object v = MultiMap.this.delegate.get(k);
                    if (v instanceof ValueSet) {
                        return ((ValueSet)v).contains(entry.getValue());
                    }
                    return Misc.equalOrNull(v, entry.getValue());
                }

                @Override
                public boolean remove(Object object) {
                    if (!(object instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)object;
                    return MultiMap.this._remove(entry.getKey(), entry.getValue());
                }

                @Override
                public int size() {
                    return MultiMap.this.valCount;
                }

                @Override
                public void clear() {
                    MultiMap.this.clear();
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)object).entrySet());
    }

    @Override
    public int hashCode() {
        return this.entrySet().hashCode();
    }

    public String toString() {
        return super.toString() + this.delegate;
    }

    public Object clone() throws ClassCastException {
        try {
            MultiMap multiMap = (MultiMap)super.clone();
            multiMap.delegate = this.cloneDelegate();
            multiMap.keySet = null;
            multiMap.values = null;
            multiMap.entrySet = null;
            multiMap.modCounter = 0;
            return multiMap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public boolean contains(Object object, Object object2) {
        if (!this.delegate.containsKey(object)) {
            return false;
        }
        Object v = this.delegate.get(object);
        if (v instanceof ValueSet) {
            return ((ValueSet)v).contains(object2);
        }
        return Misc.equalOrNull(v, object2);
    }

    @Override
    public boolean remove(Object object, Object object2) {
        if (MultiMap.logger.level >= 7) {
            logger.log(7, "remove(Object,Object)", MultiMap.logger.level < 8 ? "" : "key: " + object + ", hash: " + (object == null ? 0 : object.hashCode()) + ", value: " + object2);
        }
        return this._remove(object, object2);
    }

    public boolean mapsToMany(Object object) {
        Object v = this.delegate.get(object);
        return v instanceof ValueSet && ((ValueSet)v).size() > 1;
    }

    public int getCount(Object object) {
        Object v = this.delegate.get(object);
        return v == null ? 0 : (v instanceof ValueSet ? ((ValueSet)v).size() : 1);
    }

    public Set getAll(Object object) {
        if (MultiMap.logger.level >= 7) {
            logger.log(7, "getAll(Object)", MultiMap.logger.level < 8 ? "" : "key: " + object + ", hash: " + (object == null ? 0 : object.hashCode()));
        }
        if (!this.delegate.containsKey(object)) {
            if (MultiMap.logger.level >= 9) {
                logger.log(9, "getAll(Object)", "No mapping");
            }
            return null;
        }
        Object v = this.delegate.get(object);
        if (v instanceof ValueSet) {
            if (((ValueSet)v).size() == 0) {
                if (MultiMap.logger.level >= 9) {
                    logger.log(9, "getAll(Object)", "Empty mapping");
                }
                return null;
            }
            return this.copyResultSet((ValueSet)v);
        }
        return this.createResultSet(v);
    }

    protected Map createDelegate(int n) {
        return new HashMap(n);
    }

    protected ValueSet createValueSet() {
        return new NestedSet();
    }

    protected Set copyResultSet(ValueSet valueSet) {
        return new HashSet(valueSet);
    }

    protected Set createResultSet(Object object) {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.add(object);
        return hashSet;
    }

    protected Map cloneDelegate() throws ClassCastException {
        if (this.delegate instanceof HashMap) {
            return (Map)((HashMap)this.delegate).clone();
        }
        Map map = this.createDelegate(this.delegate.size());
        map.putAll(this.delegate);
        return map;
    }

    protected boolean _remove(Object object, Object object2) {
        if (!this.delegate.containsKey(object)) {
            return false;
        }
        Object v = this.delegate.get(object);
        if (v instanceof ValueSet) {
            boolean bl = ((ValueSet)v).remove(object2);
            if (bl) {
                --this.valCount;
                ++this.modCounter;
            }
            if (((ValueSet)v).size() == 0) {
                this.delegate.remove(object);
            }
            return bl;
        }
        if (Misc.equalOrNull(v, object2)) {
            this.delegate.remove(object);
            --this.valCount;
            ++this.modCounter;
            return true;
        }
        return false;
    }

    private class NestedSet
    extends HashSet
    implements ValueSet {
    }

    protected static interface ValueSet
    extends Set {
    }

    protected class MapEntry
    implements Map.Entry {
        protected Object key;
        protected Object value;

        public MapEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            Object object2 = this.value;
            this.value = object;
            if (!Misc.equalOrNull(object2, object)) {
                MultiMap.this.remove(this.key, object2);
                MultiMap.this.put(this.key, object);
            }
            return object2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            return Misc.equalOrNull(this.key, ((Map.Entry)object).getKey()) && Misc.equalOrNull(this.value, ((Map.Entry)object).getValue());
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        public String toString() {
            return super.toString() + "[" + this.key + "=" + this.value + "]";
        }
    }

    protected class MapIterator
    implements Iterator {
        protected int type;
        protected Iterator entries;
        protected Iterator inner;
        protected ValueSet current;
        protected int expectedModCounter;
        protected Map.Entry lastEntry;
        protected Object lastValue;

        public MapIterator(int n) {
            this.type = n;
            this.entries = MultiMap.this.delegate.entrySet().iterator();
            this.inner = null;
            this.expectedModCounter = MultiMap.this.modCounter;
        }

        @Override
        public boolean hasNext() {
            if (this.inner != null && this.inner.hasNext()) {
                return true;
            }
            return this.entries.hasNext();
        }

        public Object next() {
            if (this.expectedModCounter != MultiMap.this.modCounter) {
                throw new ConcurrentModificationException();
            }
            while (true) {
                if (this.inner != null) {
                    try {
                        this.lastValue = this.inner.next();
                        if (this.type == 1) {
                            return this.lastValue;
                        }
                        return new MapEntry(this.lastEntry.getKey(), this.lastValue);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        this.inner = null;
                        this.current = null;
                    }
                }
                this.lastEntry = (Map.Entry)this.entries.next();
                if (this.type == 0) {
                    this.lastValue = this.lastEntry.getKey();
                    return this.lastValue;
                }
                if (!(this.lastEntry.getValue() instanceof ValueSet)) break;
                this.current = (ValueSet)this.lastEntry.getValue();
                this.inner = this.current.iterator();
            }
            this.lastValue = this.lastEntry.getValue();
            if (this.type == 1) {
                return this.lastValue;
            }
            return new MapEntry(this.lastEntry.getKey(), this.lastValue);
        }

        @Override
        public void remove() {
            if (this.lastValue == null) {
                throw new IllegalStateException();
            }
            if (this.expectedModCounter != MultiMap.this.modCounter) {
                throw new ConcurrentModificationException();
            }
            if (this.inner != null) {
                this.inner.remove();
                this.lastValue = null;
                if (this.current.size() == 0) {
                    this.entries.remove();
                }
                --MultiMap.this.valCount;
                ++MultiMap.this.modCounter;
                ++this.expectedModCounter;
            } else {
                MultiMap.this.valCount = this.type == 0 && this.lastEntry.getValue() instanceof ValueSet ? (MultiMap.this.valCount -= ((ValueSet)this.lastEntry.getValue()).size()) : --MultiMap.this.valCount;
                this.entries.remove();
                this.lastValue = null;
                ++MultiMap.this.modCounter;
                ++this.expectedModCounter;
            }
        }
    }
}

