/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;

public class Poller {
    private static final Logger logger = new Logger("de.qfs.lib.util.Poller");
    private PollMethod method;
    private int timeout;
    private int interval;

    public Poller(int n, int n2, PollMethod pollMethod) {
        if (Poller.logger.level >= 7) {
            Logger.Builder builder = logger.build("Poller(int,int,PollMethod)");
            (Poller.logger.level < 8 ? builder : builder.add("timeout: ").add(n).add(", interval: ").add(n2).add(", method: ").add(pollMethod)).log(7);
        }
        this.timeout = n;
        this.interval = n2;
        this.method = pollMethod;
    }

    public boolean poll() {
        if (Poller.logger.level >= 7) {
            logger.log(7, "poll()", "");
        }
        long l = System.currentTimeMillis() + (long)this.timeout;
        boolean bl = false;
        while (true) {
            if (Poller.logger.level >= 9) {
                logger.log(9, "poll()", "Polling...");
            }
            if (this.method.run()) {
                if (Poller.logger.level >= 9) {
                    logger.log(9, "poll()", "Polling...successful");
                }
                return true;
            }
            if (Poller.logger.level >= 9) {
                logger.log(9, "poll()", "Polling...failed");
            }
            if (bl) {
                if (Poller.logger.level >= 9) {
                    logger.log(9, "poll()", "Giving up");
                }
                return false;
            }
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                if (Poller.logger.level >= 9) {
                    logger.log(9, "poll()", "Interrupted");
                }
                return false;
            }
            if (System.currentTimeMillis() < l) continue;
            bl = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean poll(Object object) {
        if (Poller.logger.level >= 7) {
            logger.log(7, "poll()", "");
        }
        long l = System.currentTimeMillis() + (long)this.timeout;
        boolean bl = false;
        while (true) {
            if (Poller.logger.level >= 9) {
                logger.log(9, "poll()", "Polling...");
            }
            if (this.method.run()) {
                if (Poller.logger.level >= 9) {
                    logger.log(9, "poll()", "Polling...successful");
                }
                return true;
            }
            if (Poller.logger.level >= 9) {
                logger.log(9, "poll()", "Polling...failed");
            }
            if (bl) {
                if (Poller.logger.level >= 9) {
                    logger.log(9, "poll()", "Giving up");
                }
                return false;
            }
            Object object2 = object;
            synchronized (object2) {
                try {
                    object.wait(this.interval);
                }
                catch (InterruptedException interruptedException) {
                    if (Poller.logger.level >= 9) {
                        logger.log(9, "poll()", "Interrupted");
                    }
                    return false;
                }
            }
            if (System.currentTimeMillis() < l) continue;
            bl = true;
        }
    }

    public static interface PollMethod {
        public boolean run();
    }
}

