/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.Environment;
import de.qfs.lib.util.Misc;
import de.qfs.lib.util.ProcessEvent;
import de.qfs.lib.util.ProcessListener;
import de.qfs.lib.util.StreamEvent;
import de.qfs.lib.util.StreamListener;
import de.qfs.lib.util.StreamMultiplexer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.swing.SwingUtilities;
import lombok.Generated;
import lombok.NonNull;
import proguard.annotation.KeepClassAndPublicMembers;

public class ProcessManager
implements StreamListener {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.ProcessManager");
    private static final Pattern ENV_PATTERN = Pattern.compile("([a-zA-Z_][a-zA-Z0-9_]*)=(.*)");
    private String name;
    private String command;
    private String[] args;
    private Process process;
    private Environment environment;
    private ArrayList listeners = new ArrayList();
    private boolean onDispatchThread;
    private int streamsClosed;
    private ProcessWaitThread waiter;
    private StreamMultiplexer multiOut;
    private StreamMultiplexer multiErr;
    private Integer exitCode;
    private long startTime;
    private long stopTime;
    private boolean collectOut;
    private boolean collectErr;
    private ArrayList<char[]> processOutput;

    public ProcessManager(String string) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "ProcessManager(String)", 169).addDetail("name", string)).log();
        }
        this.name = string;
    }

    public ProcessManager(String string, String string2) {
        this(string);
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ProcessManager(String,String)", 185).addDetail("name", string)).addDetail("command", string2)).log();
        }
        this.setCommand(string2);
        if (Misc.OS_IS_LINUX || Misc.OS_IS_MAC_OS_X) {
            this.setArgs(ProcessManager.translateCommandline(string2));
        }
    }

    public ProcessManager(String string, String[] stringArray) {
        this(string);
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ProcessManager(String,String[])", 204).addDetail("name", string)).addDetail("args", stringArray)).log();
        }
        this.setArgs(stringArray);
    }

    public final void setArgs(String[] stringArray) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setArgs(String[])", 223).addDetail("args", stringArray)).log();
        }
        this.args = stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) {
                stringArray[i] = "";
            }
            if (Misc.OS_IS_WINDOWS && (stringArray[i].startsWith("\"") || stringArray[i].endsWith("\""))) {
                stringArray[i] = "\"" + stringArray[i] + "\"";
            }
            if (i > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[i]);
        }
        this.command = stringBuffer.toString();
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "setArgs(String[])", 247).add("command", this.command)).log();
        }
    }

    public final void setCollect(boolean bl, boolean bl2) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "setCollect(boolean,boolean)", 259).addDetail("collectOut", bl)).addDetail("collectErr", bl2)).log();
        }
        this.collectOut = bl;
        this.collectErr = bl2;
        if ((bl || bl2) && this.processOutput == null) {
            this.processOutput = new ArrayList();
        }
    }

    public List<char[]> getProcessOutput() {
        this.maybeWaitForStreamsToClose();
        return this.processOutput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public String getProcessOutputString() {
        this.maybeWaitForStreamsToClose();
        if (this.processOutput == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100000);
        ProcessManager processManager = this;
        synchronized (processManager) {
            ArrayList<char[]> arrayList = this.processOutput;
            synchronized (arrayList) {
                for (char[] cArray : this.processOutput) {
                    stringBuffer.append(cArray);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void maybeWaitForStreamsToClose() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "maybeWaitForStreamsToClose()", 318).log();
        }
        if (this.waiter.isTerminated()) {
            if (this.streamsClosed >= 2) {
                return;
            }
            long l = System.currentTimeMillis() + 3000L;
            ProcessManager processManager = this;
            synchronized (processManager) {
                do {
                    long l2 = l - System.currentTimeMillis();
                    if (ProcessManager.logger.level >= 9) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "maybeWaitForStreamsToClose()", 329).add("rest", l2)).log();
                    }
                    if (l2 <= 0L) {
                        return;
                    }
                    try {
                        this.wait(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (ProcessManager.logger.level < 9) continue;
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "maybeWaitForStreamsToClose()", 337).add("wakeup - streamsClosed: ")).add(this.streamsClosed)).log();
                } while (this.streamsClosed < 2);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProcess() throws IOException, IllegalStateException {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "startProcess()", 361).log();
        }
        ProcessManager processManager = this;
        synchronized (processManager) {
            if (this.process != null) {
                throw new IllegalStateException("The process was already started.");
            }
            if (this.command == null) {
                throw new IllegalStateException("No command was specified for the process.");
            }
            String[] stringArray = null;
            if (this.environment != null) {
                stringArray = Environment.asArray(this.environment.getEnvironment());
            }
            if (ProcessManager.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "startProcess()", 375).add("environ", stringArray)).log();
            }
            this.process = this.args == null ? (stringArray == null ? Runtime.getRuntime().exec(this.command) : Runtime.getRuntime().exec(this.command, stringArray)) : (stringArray == null ? Runtime.getRuntime().exec(this.args) : Runtime.getRuntime().exec(this.args, stringArray));
            this.startTime = System.currentTimeMillis();
            this.waiter = new ProcessWaitThread(this.process);
            this.waiter.start();
            this.multiOut = new StreamMultiplexer(this.process.getInputStream(), Misc.STDOUT_CHARSET, (Object)("process:" + this.name + ":stdout"));
            this.multiOut.addStreamListener(this);
            this.multiOut.start();
            this.multiErr = new StreamMultiplexer(this.process.getErrorStream(), Misc.STDERR_CHARSET, (Object)("process:" + this.name + ":stderr"));
            this.multiErr.addStreamListener(this);
            this.multiErr.start();
        }
        this.fireProcessStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execProcess() throws IOException, IllegalStateException {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "execProcess()", 419).log();
        }
        ProcessManager processManager = this;
        synchronized (processManager) {
            if (this.command == null) {
                throw new IllegalStateException("No command was specified for the process.");
            }
            String[] stringArray = null;
            if (this.environment != null) {
                stringArray = Environment.asArray(this.environment.getEnvironment());
            }
            this.process = this.args == null ? (stringArray == null ? Runtime.getRuntime().exec(this.command) : Runtime.getRuntime().exec(this.command, stringArray)) : (stringArray == null ? Runtime.getRuntime().exec(this.args) : Runtime.getRuntime().exec(this.args, stringArray));
            this.startTime = System.currentTimeMillis();
        }
        this.fireProcessStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminateProcess(int n) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "terminateProcess(int)", 459).addDetail("exitCode", n)).log();
        }
        ProcessManager processManager = this;
        synchronized (processManager) {
            if (this.process == null || this.waiter == null) {
                throw new IllegalStateException("The process has not been started yet.");
            }
            if (this.waiter.isTerminated()) {
                throw new IllegalStateException("The process has already terminated.");
            }
            this.exitCode = n;
        }
        this.process.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detachFromProcess() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "detachFromProcess()", 484).log();
        }
        ProcessManager processManager = this;
        synchronized (processManager) {
            if (this.process == null || this.waiter == null) {
                throw new IllegalStateException("The process has not been started yet.");
            }
            if (this.waiter.isTerminated()) {
                throw new IllegalStateException("The process has already terminated.");
            }
            this.waiter.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAlive() {
        ProcessManager processManager = this;
        synchronized (processManager) {
            return this.process != null && this.waiter != null && !this.waiter.isTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getExitCode() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "getExitCode()", 538).log();
        }
        ProcessManager processManager = this;
        synchronized (processManager) {
            if (this.process == null || this.waiter == null) {
                throw new IllegalStateException("The process has not been started yet.");
            }
            if (!this.waiter.isTerminated()) {
                throw new IllegalStateException("The process has not terminated yet.");
            }
            if (this.exitCode != null) {
                return this.exitCode;
            }
            return this.waiter.getExitCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean waitFor(long l) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "waitFor(long)", 566).addDetail("timeout", l)).log();
        }
        ProcessManager processManager = this;
        synchronized (processManager) {
            if (this.process == null || this.waiter == null) {
                throw new IllegalStateException("The process has not been started yet.");
            }
        }
        boolean bl = this.waiter.waitFor(l);
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "waitFor(long)", 574).add("ret", bl)).log();
        }
        if (bl && (this.collectOut || this.collectErr)) {
            ProcessManager processManager2 = this;
            synchronized (processManager2) {
                if (ProcessManager.logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "waitFor(long)", 578).add("streamsClosed", this.streamsClosed)).log();
                }
                long l2 = System.currentTimeMillis() + 300L;
                while (this.streamsClosed < 2) {
                    long l3 = Math.max(1L, l2 - System.currentTimeMillis());
                    try {
                        if (ProcessManager.logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "waitFor(long)", 583).add("waiting for: ")).add(l3)).log();
                        }
                        this.wait(l3);
                        if (ProcessManager.logger.level < 9) continue;
                        ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "waitFor(long)", 585).add("wakeup - streamsClosed: ")).add(this.streamsClosed)).log();
                    }
                    catch (InterruptedException interruptedException) {
                        if (ProcessManager.logger.level < 9) continue;
                        ((LevelAwareLogBuilder)logger.lvlBuild(9, "waitFor(long)", 587).add("Interrupted")).log();
                    }
                }
            }
        }
        return bl;
    }

    public synchronized void addProcessListener(ProcessListener processListener) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "addProcessListener(ProcessListener)", 607).addDetail("listener", processListener)).log();
        }
        this.listeners.remove(processListener);
        this.listeners.add(processListener);
    }

    public synchronized void removeProcessListener(ProcessListener processListener) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "removeProcessListener(ProcessListener)", 622).addDetail("listener", processListener)).log();
        }
        this.listeners.remove(processListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProcessStarted() {
        ProcessListener[] processListenerArray;
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "fireProcessStarted()", 633).log();
        }
        final ProcessEvent processEvent = new ProcessEvent(this.process);
        Object object = this;
        synchronized (object) {
            processListenerArray = this.listeners.toArray(new ProcessListener[0]);
        }
        object = new Runnable(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "fireProcessStarted().Runnable.run()", 642).log();
                }
                for (int i = 0; i < processListenerArray.length; ++i) {
                    try {
                        processListenerArray[i].processStarted(processEvent);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (logger.level < 3) continue;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "fireProcessStarted().Runnable.run()", 647).add("ex", throwable)).log();
                    }
                }
            }
        };
        if (this.onDispatchThread) {
            SwingUtilities.invokeLater((Runnable)object);
        } else {
            object.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireProcessTerminated() {
        ProcessListener[] processListenerArray;
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "fireProcessTerminated()", 665).log();
        }
        final ProcessEvent processEvent = new ProcessEvent(this.process);
        Object object = this;
        synchronized (object) {
            processListenerArray = this.listeners.toArray(new ProcessListener[0]);
        }
        object = new Runnable(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "fireProcessTerminated().Runnable.run()", 674).log();
                }
                for (int i = 0; i < processListenerArray.length; ++i) {
                    try {
                        processListenerArray[i].processTerminated(processEvent);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (logger.level < 3) continue;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "fireProcessTerminated().Runnable.run()", 679).add("ex", throwable)).log();
                    }
                }
            }
        };
        if (this.onDispatchThread) {
            SwingUtilities.invokeLater((Runnable)object);
        } else {
            object.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNewInput(char[] cArray, boolean bl) {
        ProcessListener[] processListenerArray;
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "fireNewInput(char[],boolean)", 700).addDetail("data", cArray)).addDetail("stderr", bl)).log();
        }
        final ProcessEvent processEvent = new ProcessEvent(this.process, cArray, bl);
        Object object = this;
        synchronized (object) {
            processListenerArray = this.listeners.toArray(new ProcessListener[0]);
        }
        object = new Runnable(){

            @Override
            public void run() {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "fireNewInput(char[],boolean).Runnable.run()", 709).log();
                }
                for (int i = 0; i < processListenerArray.length; ++i) {
                    try {
                        processListenerArray[i].inputReceived(processEvent);
                        continue;
                    }
                    catch (Throwable throwable) {
                        if (logger.level < 3) continue;
                        ((LevelAwareLogBuilder)logger.lvlBuild(3, "fireNewInput(char[],boolean).Runnable.run()", 714).add("ex", throwable)).log();
                    }
                }
            }
        };
        if (this.onDispatchThread) {
            SwingUtilities.invokeLater((Runnable)object);
        } else {
            object.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void newInput(StreamEvent streamEvent) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "newInput(StreamEvent)", 739).addDetail("event", streamEvent)).log();
        }
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "newInput(StreamEvent)", 741).add("data: ")).add(new String(streamEvent.getData()))).log();
        }
        boolean bl = ("process:" + this.name + ":stderr").equals(streamEvent.getSource());
        if (this.collectOut && !bl || this.collectErr && bl) {
            ProcessManager processManager = this;
            synchronized (processManager) {
                this.processOutput.add(streamEvent.getData());
            }
        }
        this.fireNewInput(streamEvent.getData(), bl);
    }

    @Override
    public synchronized void inputClosed(StreamEvent streamEvent) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "inputClosed(StreamEvent)", 761).addDetail("event", streamEvent)).log();
        }
        ++this.streamsClosed;
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "inputClosed(StreamEvent)", 764).add("streamsClosed", this.streamsClosed)).log();
        }
        if (this.streamsClosed == 2) {
            this.notifyAll();
        }
    }

    public static String runProcess(@NonNull String string) throws RunProcessException {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "runProcess(String)", 777).addDetail("commandLine", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        return ProcessManager.runProcess(string, 0);
    }

    public static String runProcess(@NonNull String string, int n) throws RunProcessException {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "runProcess(String,int)", 787).addDetail("commandLine", string)).addDetail("timeout", n)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        return ProcessManager.runProcess(string, n, null);
    }

    public static String runProcess(@NonNull String string, int n, ProcessListener processListener) throws RunProcessException {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "runProcess(String,int,ProcessListener)", 798).addDetail("commandLine", string)).addDetail("timeout", n)).addDetail("processListener", processListener)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        assert (!"".equals(string));
        String[] stringArray = ProcessManager.translateCommandline(string);
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "runProcess(String,int,ProcessListener)", 803).add("translatedCommandLine", stringArray)).log();
        }
        return ProcessManager.runProcess(stringArray, n, processListener);
    }

    public static String runProcess(@NonNull String[] stringArray, int n) throws RunProcessException {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "runProcess(String[],int)", 820).addDetail("commandLine", stringArray)).addDetail("timeout", n)).log();
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        return ProcessManager.runProcess(stringArray, n, null);
    }

    public static String runProcess(@NonNull String[] stringArray, int n, ProcessListener processListener) throws RunProcessException {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "runProcess(String[],int,ProcessListener)", 828).addDetail("commandLine", stringArray)).addDetail("timeout", n)).addDetail("processListener", processListener)).log();
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        assert (stringArray.length >= 1);
        int n2 = Integer.MIN_VALUE;
        ProcessManager processManager = null;
        String string = null;
        try {
            processManager = ProcessManager.startProcess(stringArray, processListener);
            if (ProcessManager.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "runProcess(String[],int,ProcessListener)", 839).add("Waiting for process")).log();
            }
            boolean bl = processManager.waitFor(n);
            if (ProcessManager.logger.level >= 9) {
                ((LevelAwareLogBuilder)logger.lvlBuild(9, "runProcess(String[],int,ProcessListener)", 841).add("ret", bl)).log();
            }
            if (bl) {
                n2 = processManager.getExitCode();
            } else {
                processManager.terminateProcess(1);
                n2 = 1;
            }
            string = processManager.getProcessOutputString();
            if (ProcessManager.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "runProcess(String[],int,ProcessListener)", 850).add("exitCode", n2)).add("out", string)).log();
            }
        }
        catch (Exception exception) {
            if (ProcessManager.logger.level >= 5) {
                ((LevelAwareLogBuilder)logger.lvlBuild(5, "runProcess(String[],int,ProcessListener)", 853).add("ex", exception)).log();
            }
            throw new RunProcessException(n2, string, processManager, exception);
        }
        if (n2 != 0) {
            throw new RunProcessException(n2, string, processManager);
        }
        return string;
    }

    public static ProcessManager startProcess(@NonNull String string) throws IOException {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "startProcess(String)", 869).addDetail("commandLine", string)).log();
        }
        if (string == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        assert (!"".equals(string));
        String[] stringArray = ProcessManager.translateCommandline(string);
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "startProcess(String)", 874).add("translatedCommandLine", stringArray)).log();
        }
        return ProcessManager.startProcess(stringArray);
    }

    public static ProcessManager startProcess(@NonNull String[] stringArray) throws IOException {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "startProcess(String[])", 889).addDetail("commandLine", stringArray)).log();
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        return ProcessManager.startProcess(stringArray, null);
    }

    public static ProcessManager startProcess(@NonNull String[] stringArray, ProcessListener processListener) throws IOException {
        String[] stringArray2;
        Object object;
        int n;
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "startProcess(String[],ProcessListener)", 897).addDetail("commandLine", stringArray)).addDetail("processListener", processListener)).log();
        }
        if (stringArray == null) {
            throw new IllegalArgumentException("commandLine is marked non-null but is null");
        }
        assert (stringArray.length >= 1);
        Environment environment = new Environment();
        for (n = 0; n < stringArray.length && ((Matcher)(object = ENV_PATTERN.matcher((CharSequence)(stringArray2 = stringArray[n])))).matches(); ++n) {
            environment.setEnv(((Matcher)object).group(1), ((Matcher)object).group(2));
        }
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "startProcess(String[],ProcessListener)", 915).add("envVariables", n)).add("env", environment)).log();
        }
        stringArray2 = stringArray;
        if (n > 0) {
            stringArray2 = new String[stringArray.length - n];
            System.arraycopy(stringArray, n, stringArray2, 0, stringArray2.length);
        }
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "startProcess(String[],ProcessListener)", 922).add("cleanedCommandLine", stringArray2)).log();
        }
        object = stringArray2[0];
        ProcessManager processManager = new ProcessManager((String)object, stringArray2);
        if (processListener != null) {
            processManager.addProcessListener(processListener);
        }
        processManager.setCollect(true, true);
        if (n > 0) {
            processManager.setEnvironment(environment);
        }
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "startProcess(String[],ProcessListener)", 936).add("Starting process")).log();
        }
        processManager.startProcess();
        return processManager;
    }

    public static String[] translateCommandline(String string) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "translateCommandline(String)", 983).addDetail("toProcess", string)).log();
        }
        return ProcessManager.translateCommandline(string, false);
    }

    public static String[] translateCommandline(String string, boolean bl) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "translateCommandline(String,boolean)", 991).addDetail("toProcess", string)).addDetail("legacy", bl)).log();
        }
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        CommandLine commandLine = ProcessManager.parseCommandLine(string, bl);
        if (ProcessManager.logger.level >= 9) {
            ((LevelAwareLogBuilder)logger.lvlBuild(9, "translateCommandline(String,boolean)", 999).add("list", commandLine)).log();
        }
        String[] stringArray = new String[commandLine.size()];
        return commandLine.toArray(stringArray);
    }

    public static CommandLine parseCommandLine(String string, boolean bl) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "parseCommandLine(String,boolean)", 1010).addDetail("toProcess", string)).addDetail("legacyMode", bl)).log();
        }
        boolean bl2 = false;
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\"'\\ ", true);
        CommandLine commandLine = new CommandLine();
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if ("\\".equals(string2)) {
                if (bl2) {
                    stringBuilder.append('\\');
                    if (bl) {
                        stringBuilder.append('\\');
                    }
                    bl2 = false;
                    continue;
                }
                bl2 = true;
                continue;
            }
            switch (n) {
                case 1: {
                    if ("'".equals(string2)) {
                        if (bl2) {
                            stringBuilder.append(string2);
                            break;
                        }
                        bl3 = true;
                        n = 0;
                        break;
                    }
                    if (bl2) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(string2);
                    break;
                }
                case 2: {
                    if ("\"".equals(string2)) {
                        if (bl2) {
                            stringBuilder.append(string2);
                            break;
                        }
                        bl3 = true;
                        n = 0;
                        break;
                    }
                    if (bl2) {
                        stringBuilder.append('\\');
                    }
                    stringBuilder.append(string2);
                    break;
                }
                default: {
                    if ("'".equals(string2)) {
                        if (bl2) {
                            stringBuilder.append(string2);
                        } else {
                            n = 1;
                        }
                    } else if ("\"".equals(string2)) {
                        if (bl2) {
                            stringBuilder.append(string2);
                        } else {
                            n = 2;
                        }
                    } else if (" ".equals(string2)) {
                        if (bl2) {
                            stringBuilder.append(string2);
                        } else if (bl3 || stringBuilder.length() != 0) {
                            commandLine.add(stringBuilder.toString());
                            stringBuilder = new StringBuilder();
                        }
                    } else {
                        if (bl2) {
                            stringBuilder.append('\\');
                        }
                        stringBuilder.append(string2);
                    }
                    bl3 = false;
                }
            }
            bl2 = false;
        }
        if (bl3 || stringBuilder.length() != 0) {
            commandLine.add(stringBuilder.toString());
        }
        if (n == 1 || n == 2) {
            throw new IllegalArgumentException("Unbalanced quotes in " + string);
        }
        return commandLine;
    }

    public static String escapeCommandlineArgument(String string) {
        boolean bl;
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "escapeCommandlineArgument(String)", 1123).addDetail("cmdParam", string)).log();
        }
        string = string.replace("\\", "\\\\");
        boolean bl2 = bl = (string = string.replace("\"", "\\\"")).indexOf(" ") != -1;
        if (bl) {
            return '\"' + string + '\"';
        }
        return string;
    }

    @Generated
    public String getName() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "getName()", 75).log();
        }
        return this.name;
    }

    @Generated
    public String getCommand() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "getCommand()", 80).log();
        }
        return this.command;
    }

    @Generated
    public ProcessManager setCommand(String string) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setCommand(String)", 80).addDetail("command", string)).log();
        }
        this.command = string;
        return this;
    }

    @Generated
    public String[] getArgs() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "getArgs()", 85).log();
        }
        return this.args;
    }

    @Generated
    public Process getProcess() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "getProcess()", 90).log();
        }
        return this.process;
    }

    @Generated
    public Environment getEnvironment() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "getEnvironment()", 95).log();
        }
        return this.environment;
    }

    @Generated
    public ProcessManager setEnvironment(Environment environment) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setEnvironment(Environment)", 95).addDetail("environment", environment)).log();
        }
        this.environment = environment;
        return this;
    }

    @Generated
    public boolean isOnDispatchThread() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "isOnDispatchThread()", 105).log();
        }
        return this.onDispatchThread;
    }

    @Generated
    public ProcessManager setOnDispatchThread(boolean bl) {
        if (ProcessManager.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setOnDispatchThread(boolean)", 105).addDetail("onDispatchThread", bl)).log();
        }
        this.onDispatchThread = bl;
        return this;
    }

    @Generated
    public long getStartTime() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "getStartTime()", 135).log();
        }
        return this.startTime;
    }

    @Generated
    public long getStopTime() {
        if (ProcessManager.logger.level >= 7) {
            logger.lvlBuild(7, "getStopTime()", 140).log();
        }
        return this.stopTime;
    }

    @KeepClassAndPublicMembers
    public static class CommandLine
    extends ArrayList<String> {
        public CommandLine() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "CommandLine.CommandLine()", 1300).log();
            }
        }

        @Override
        public String toString() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "CommandLine.toString()", 1302).log();
            }
            StringBuilder stringBuilder = new StringBuilder();
            for (String string : this) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(" ");
                }
                String string2 = ProcessManager.escapeCommandlineArgument(string);
                stringBuilder.append(string2);
            }
            return stringBuilder.toString();
        }

        @Override
        @Generated
        public boolean equals(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "CommandLine.equals(Object)", 1299).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof CommandLine)) {
                return false;
            }
            CommandLine commandLine = (CommandLine)object;
            if (!commandLine.canEqual(this)) {
                return false;
            }
            return super.equals(object);
        }

        @Generated
        protected boolean canEqual(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "CommandLine.canEqual(Object)", 1299).addDetail("other", object)).log();
            }
            return object instanceof CommandLine;
        }

        @Override
        @Generated
        public int hashCode() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "CommandLine.hashCode()", 1299).log();
            }
            int n = super.hashCode();
            return n;
        }
    }

    private class ProcessWaitThread
    extends DaemonThread {
        private boolean done;
        private Process process;
        private boolean terminated;
        private int exitCode;

        public ProcessWaitThread(Process process) {
            super("WaitForProcess-" + ProcessManager.this.name);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ProcessWaitThread.ProcessWaitThread(Process)", 1175).addDetail("process", process)).log();
            }
            this.process = process;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block16: {
                if (logger.level >= 7) {
                    logger.lvlBuild(7, "ProcessWaitThread.run()", 1190).log();
                }
                try {
                    if (this.done) break block16;
                    this.process.waitFor();
                    ProcessManager.this.stopTime = System.currentTimeMillis();
                    Object object = this;
                    synchronized (object) {
                        this.exitCode = this.process.exitValue();
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.run()", 1198).add("exitCode", this.exitCode)).log();
                        }
                        if (Misc.OS_IS_WINDOWS && this.exitCode >= 256 && (this.exitCode & 0xFFF00FF) == 0) {
                            this.exitCode /= 256;
                        }
                        this.terminated = true;
                        this.notifyAll();
                    }
                    object = ProcessManager.this;
                    synchronized (object) {
                        long l = System.currentTimeMillis() + 1000L;
                        while (ProcessManager.this.streamsClosed < 2) {
                            long l2 = l - System.currentTimeMillis();
                            if (l2 < 0L) {
                                if (logger.level < 5) break;
                                ((LevelAwareLogBuilder)logger.lvlBuild(5, "ProcessWaitThread.run()", 1214).add("Not all streams closed", ProcessManager.this.streamsClosed)).log();
                                break;
                            }
                            try {
                                if (logger.level >= 9) {
                                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.run()", 1218).add("rest", l2)).log();
                                }
                                ProcessManager.this.wait(l2);
                                if (logger.level < 9) continue;
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.run()", 1220).add("wakeup - streamsClosed: ")).add(ProcessManager.this.streamsClosed)).log();
                            }
                            catch (InterruptedException interruptedException) {
                                if (logger.level < 9) continue;
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.run()", 1222).add("Interrupted")).log();
                            }
                        }
                    }
                    ProcessManager.this.fireProcessTerminated();
                }
                catch (InterruptedException interruptedException) {
                    if (logger.level < 9) break block16;
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.run()", 1230).add("ex", interruptedException)).log();
                }
            }
        }

        public synchronized boolean waitFor(long l) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "ProcessWaitThread.waitFor(long)", 1244).addDetail("timeout", l)).log();
            }
            if (this.terminated) {
                return true;
            }
            long l2 = System.currentTimeMillis() + l;
            while (true) {
                block14: {
                    try {
                        if (l > 0L) {
                            if (logger.level >= 9) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.waitFor(long)", 1253).add("Waiting for ")).add(l)).add(" ms")).log();
                            }
                            this.wait(l);
                        } else {
                            if (logger.level >= 9) {
                                ((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.waitFor(long)", 1256).add("waiting")).log();
                            }
                            this.wait();
                        }
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.waitFor(long)", 1259).add("wakeup - terminated: ")).add(this.terminated)).log();
                        }
                        if (this.terminated) {
                            return true;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.waitFor(long)", 1264).add("ex", interruptedException)).log();
                        }
                        if (logger.level >= 9) {
                            ((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.waitFor(long)", 1265).add("Interrupted")).log();
                        }
                        if (!this.terminated) break block14;
                        return true;
                    }
                }
                if (l <= 0L) continue;
                l = l2 - System.currentTimeMillis();
                if (logger.level >= 9) {
                    ((LevelAwareLogBuilder)logger.lvlBuild(9, "ProcessWaitThread.waitFor(long)", 1272).add("timeout", l)).log();
                }
                if (l <= 0L) break;
            }
            return false;
        }

        public void abort() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ProcessWaitThread.abort()", 1286).log();
            }
            this.done = true;
            this.interrupt();
        }

        @Generated
        public boolean isTerminated() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ProcessWaitThread.isTerminated()", 1158).log();
            }
            return this.terminated;
        }

        @Generated
        public int getExitCode() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "ProcessWaitThread.getExitCode()", 1163).log();
            }
            return this.exitCode;
        }
    }

    public static class RunProcessException
    extends Exception {
        final int exitCode;
        @Nullable
        final String output;
        @Nullable
        final ProcessManager processManager;

        public RunProcessException(int n, String string, ProcessManager processManager, Throwable throwable) {
            super(throwable);
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RunProcessException.RunProcessException(int,String,ProcessManager,Throwable)", 959).addDetail("exitCode", n)).addDetail("output", string)).addDetail("processManager", processManager)).addDetail("cause", throwable)).log();
            }
            this.exitCode = n;
            this.output = string;
            this.processManager = processManager;
        }

        @Generated
        public int getExitCode() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RunProcessException.getExitCode()", 955).log();
            }
            return this.exitCode;
        }

        @Nullable
        @Generated
        public String getOutput() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RunProcessException.getOutput()", 956).log();
            }
            return this.output;
        }

        @Nullable
        @Generated
        public ProcessManager getProcessManager() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RunProcessException.getProcessManager()", 957).log();
            }
            return this.processManager;
        }

        @Override
        @Generated
        public String toString() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RunProcessException.toString()", 951).log();
            }
            return "ProcessManager.RunProcessException(exitCode=" + this.getExitCode() + ", output=" + this.getOutput() + ", processManager=" + this.getProcessManager() + ")";
        }

        @Generated
        public boolean equals(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RunProcessException.equals(Object)", 952).addDetail("o", object)).log();
            }
            if (object == this) {
                return true;
            }
            if (!(object instanceof RunProcessException)) {
                return false;
            }
            RunProcessException runProcessException = (RunProcessException)object;
            if (!runProcessException.canEqual(this)) {
                return false;
            }
            if (this.getExitCode() != runProcessException.getExitCode()) {
                return false;
            }
            String string = this.getOutput();
            String string2 = runProcessException.getOutput();
            if (string == null ? string2 != null : !string.equals(string2)) {
                return false;
            }
            ProcessManager processManager = this.getProcessManager();
            ProcessManager processManager2 = runProcessException.getProcessManager();
            return !(processManager == null ? processManager2 != null : !processManager.equals(processManager2));
        }

        @Generated
        protected boolean canEqual(Object object) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "RunProcessException.canEqual(Object)", 952).addDetail("other", object)).log();
            }
            return object instanceof RunProcessException;
        }

        @Generated
        public int hashCode() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "RunProcessException.hashCode()", 952).log();
            }
            int n = 1;
            n = n * 59 + this.getExitCode();
            String string = this.getOutput();
            n = n * 59 + (string == null ? 43 : string.hashCode());
            ProcessManager processManager = this.getProcessManager();
            n = n * 59 + (processManager == null ? 43 : processManager.hashCode());
            return n;
        }

        @Generated
        public RunProcessException(int n, @Nullable String string, @Nullable ProcessManager processManager) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "RunProcessException.RunProcessException(int,String,ProcessManager)", 953).addDetail("exitCode", n)).addDetail("output", string)).addDetail("processManager", processManager)).log();
            }
            this.exitCode = n;
            this.output = string;
            this.processManager = processManager;
        }
    }
}

