/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import lombok.Generated;
import lombok.NonNull;

public class ReplacingInputStream
extends FilterInputStream {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.ReplacingInputStream");
    protected boolean replacingEnabled = true;
    final byte[] search;
    final int[] readBuffer;
    int readBufferPos = 0;
    int readBufferLength = 0;
    final byte[] replacement;
    int replacementPos = 0;

    public ReplacingInputStream(@NonNull InputStream inputStream, @NonNull String string, @NonNull String string2, @NonNull String string3) throws UnsupportedEncodingException {
        super(inputStream);
        if (ReplacingInputStream.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "ReplacingInputStream(InputStream,String,String,String)", 44).addDetail("in", inputStream)).addDetail("search", string)).addDetail("replacement", string2)).addDetail("encoding", string3)).log();
        }
        if (inputStream == null) {
            throw new IllegalArgumentException("in is marked non-null but is null");
        }
        if (string == null) {
            throw new IllegalArgumentException("search is marked non-null but is null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("replacement is marked non-null but is null");
        }
        if (string3 == null) {
            throw new IllegalArgumentException("encoding is marked non-null but is null");
        }
        this.search = string.getBytes(string3);
        this.replacement = string2.getBytes(string3);
        this.readBuffer = new int[this.search.length];
    }

    @Override
    public int read() throws IOException {
        if (ReplacingInputStream.logger.level >= 7) {
            logger.lvlBuild(7, "read()", 57).log();
        }
        if (!this.replacingEnabled || this.search.length == 0) {
            return this.in.read();
        }
        return this.readWithReplace();
    }

    private int readWithReplace() throws IOException {
        block4: {
            if (ReplacingInputStream.logger.level >= 7) {
                logger.lvlBuild(7, "readWithReplace()", 68).log();
            }
            if (this.replacementPos > 0) {
                return this.nextFromReplacementBuffer();
            }
            if (this.readBufferLength > 0) {
                return this.nextFromReadBuffer();
            }
            int n = 0;
            do {
                int n2;
                this.readBuffer[this.readBufferLength] = n2 = this.in.read();
                ++this.readBufferLength;
                if (n2 == -1 || n2 != this.search[n]) break block4;
            } while (++n != this.search.length);
            this.readBufferLength = 0;
            return this.nextFromReplacementBuffer();
        }
        return this.nextFromReadBuffer();
    }

    private int nextFromReplacementBuffer() throws IOException {
        if (ReplacingInputStream.logger.level >= 7) {
            logger.lvlBuild(7, "nextFromReplacementBuffer()", 103).log();
        }
        if (this.replacement.length == 0) {
            return this.readWithReplace();
        }
        byte by = this.replacement[this.replacementPos];
        ++this.replacementPos;
        if (this.replacementPos == this.replacement.length) {
            this.replacementPos = 0;
        }
        return by;
    }

    private int nextFromReadBuffer() {
        if (ReplacingInputStream.logger.level >= 7) {
            logger.lvlBuild(7, "nextFromReadBuffer()", 119).log();
        }
        int n = this.readBuffer[this.readBufferPos];
        ++this.readBufferPos;
        if (this.readBufferPos == this.readBufferLength) {
            this.readBufferLength = 0;
            this.readBufferPos = 0;
        }
        return n;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (ReplacingInputStream.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "read(byte[],int,int)", 133).addDetail("b", byArray)).addDetail("off", n)).addDetail("len", n2)).log();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void mark(int n) {
        if (ReplacingInputStream.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "mark(int)", 141).addDetail("readlimit", n)).log();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (ReplacingInputStream.logger.level >= 7) {
            logger.lvlBuild(7, "reset()", 149).log();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean markSupported() {
        if (ReplacingInputStream.logger.level >= 7) {
            logger.lvlBuild(7, "markSupported()", 157).log();
        }
        return false;
    }

    @Generated
    public boolean isReplacingEnabled() {
        if (ReplacingInputStream.logger.level >= 7) {
            logger.lvlBuild(7, "isReplacingEnabled()", 31).log();
        }
        return this.replacingEnabled;
    }

    @Generated
    public ReplacingInputStream setReplacingEnabled(boolean bl) {
        if (ReplacingInputStream.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "setReplacingEnabled(boolean)", 31).addDetail("replacingEnabled", bl)).log();
        }
        this.replacingEnabled = bl;
        return this;
    }
}

