/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.QFLogger;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Vector;
import lombok.Generated;

public class StreamInput {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.util.StreamInput");
    private static final int BLOCKSIZE = 4096;

    public StreamInput() {
        if (StreamInput.logger.level >= 7) {
            logger.lvlBuild(7, "StreamInput.StreamInput()", 53).log();
        }
    }

    public static byte[] read(InputStream inputStream) throws IOException {
        byte[] byArray;
        int n;
        if (StreamInput.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "read(InputStream)", 76).addDetail("in", inputStream)).log();
        }
        Vector<byte[]> vector = new Vector<byte[]>();
        Vector<Integer> vector2 = new Vector<Integer>();
        int n2 = 0;
        while ((n = inputStream.read(byArray = new byte[4096])) >= 0) {
            if (n <= 0) continue;
            n2 += n;
            vector.addElement(byArray);
            vector2.addElement(n);
        }
        byArray = new byte[n2];
        n = 0;
        for (int i = 0; i < vector.size(); ++i) {
            byte[] byArray2 = (byte[])vector.elementAt(i);
            int n3 = (Integer)vector2.elementAt(i);
            System.arraycopy(byArray2, 0, byArray, n, n3);
            n += n3;
        }
        return byArray;
    }

    public static String loadText(FileInputStream fileInputStream, Charset charset) throws IOException {
        if (StreamInput.logger.level >= 7) {
            ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "loadText(FileInputStream,Charset)", 119).addDetail("in", fileInputStream)).addDetail("charset", charset)).log();
        }
        return new String(StreamInput.read(fileInputStream), charset);
    }

    public static String loadText(Reader reader) {
        if (StreamInput.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "loadText(Reader)", 135).addDetail("reader", reader)).log();
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(reader);
            char[] cArray = new char[4096];
            StringBuilder stringBuilder = new StringBuilder();
            int n = bufferedReader.read(cArray);
            while (n >= 0) {
                stringBuilder.append(cArray, 0, n);
                n = bufferedReader.read(cArray);
            }
            bufferedReader.close();
            return stringBuilder.toString();
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

