/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.util;

import de.qfs.lib.log.Logger;
import de.qfs.lib.util.DaemonThread;
import de.qfs.lib.util.ResourceWaiter;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ThreadPool {
    private static final Logger logger = new Logger("de.qfs.lib.util.ThreadPool");
    private static final Logger ptLogger = new Logger("de.qfs.lib.util.ThreadPool.PoolThread");
    private static final Logger wdLogger = new Logger("de.qfs.lib.util.ThreadPool.WatchDog");
    private List available = new ArrayList();
    private LinkedList waiters = new LinkedList();
    private int minThreads;
    private int avgThreads;
    private int maxThreads;
    private int currentThreads;
    private ThreadGroup threadGroup;
    private static int count;

    public ThreadPool(int n, int n2, int n3) {
        this(n, n2, n3, null);
    }

    public ThreadPool(int n, int n2, int n3, ThreadGroup threadGroup) {
        if (ThreadPool.logger.level >= 7) {
            logger.log(7, "ThreadPool(int,int,int,ThreadGroup)", ThreadPool.logger.level < 8 ? "" : "min: " + n + ", avg: " + n2 + ", max: " + n3 + ", group: " + threadGroup);
        }
        this.minThreads = n;
        this.avgThreads = n2;
        this.maxThreads = n3;
        this.threadGroup = threadGroup;
        if (this.minThreads > this.avgThreads || this.avgThreads > this.maxThreads || this.maxThreads <= 0) {
            throw new IllegalArgumentException("Min, avg and max values don't make sense.");
        }
        this.currentThreads = 0;
        while (this.currentThreads < this.minThreads) {
            PoolThread poolThread = new PoolThread(this.threadGroup);
            poolThread.start();
            this.available.add(poolThread);
            ++this.currentThreads;
        }
    }

    public static boolean isPoolThread() {
        return Thread.currentThread() instanceof PoolThread;
    }

    public void execute(Runnable runnable) {
        if (ThreadPool.logger.level >= 7) {
            logger.log(7, "execute(Runnable)", ThreadPool.logger.level < 8 ? "" : "run: " + runnable);
        }
        this.allocate().execute(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeWatched(UnsafeRunnable unsafeRunnable, long l, long l2) throws Throwable {
        if (ThreadPool.logger.level >= 7) {
            logger.log(7, "executeWatched(UnsafeRunnable,long,long)", ThreadPool.logger.level < 8 ? "" : "run: " + unsafeRunnable + ", timeout: " + l + ", callid: " + l2);
        }
        PoolThread poolThread = this.allocate();
        Object object = null;
        Throwable throwable = null;
        poolThread.execute(unsafeRunnable);
        PoolThread poolThread2 = poolThread;
        synchronized (poolThread2) {
            try {
                boolean[] blArray = new boolean[]{false};
                WatchDog.add(Thread.currentThread(), l, l2, blArray);
                while (poolThread.runner != null) {
                    try {
                        if (ThreadPool.logger.level >= 9) {
                            logger.log(9, "executeWatched(UnsafeRunnable,long,long)", "Blocking...");
                        }
                        poolThread.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (ThreadPool.logger.level >= 9) {
                            logger.log(9, "executeWatched(UnsafeRunnable,long,long)", "Interrupted");
                        }
                        poolThread.interrupt();
                        if (blArray[0]) {
                            throw new TimedOutException("Call " + l2 + " timed out after " + l + " milliseconds");
                        }
                        throw new CancelledException("Call " + l2 + " was cancelled");
                    }
                }
                if (ThreadPool.logger.level >= 9) {
                    logger.log(9, "executeWatched(UnsafeRunnable,long,long)", "Done");
                }
            }
            finally {
                WatchDog.remove(l2);
                if (ThreadPool.logger.level >= 9) {
                    logger.log(9, "executeWatched(UnsafeRunnable,long,long)", "Unblocking thread");
                }
                object = poolThread.retval;
                poolThread.retval = null;
                throwable = poolThread.exception;
                poolThread.exception = null;
                poolThread.block = false;
                poolThread.notifyAll();
            }
        }
        if (ThreadPool.logger.level >= 9) {
            logger.build("executeWatched(UnsafeRunnable,long,long)").add("ret: ").add(object).add(", exception: ").add(throwable).log(9);
        }
        if (throwable != null) {
            throw throwable;
        }
        return object;
    }

    public void cancelCall(long l) {
        WatchDog.cancel(l);
    }

    public synchronized boolean belongsTo(Thread thread) {
        return this.available.contains(thread);
    }

    public final ThreadGroup getThreadGroup() {
        return this.threadGroup;
    }

    private synchronized PoolThread allocate() {
        if (ThreadPool.logger.level >= 7) {
            logger.log(7, "allocate()", "");
        }
        this.checkLive();
        if (this.available.size() > 0) {
            if (ThreadPool.logger.level >= 9) {
                logger.log(9, "allocate()", "Thread available: " + this.available.get(0));
            }
            return (PoolThread)this.available.remove(0);
        }
        if (this.currentThreads < this.maxThreads) {
            if (ThreadPool.logger.level >= 9) {
                logger.log(9, "allocate()", "Must create new Thread");
            }
            ++this.currentThreads;
            PoolThread poolThread = new PoolThread(this.threadGroup);
            poolThread.start();
            return poolThread;
        }
        if (ThreadPool.logger.level >= 9) {
            logger.log(9, "allocate()", "Waiting for Thread");
        }
        ResourceWaiter resourceWaiter = new ResourceWaiter(this);
        this.waiters.add(resourceWaiter);
        PoolThread poolThread = (PoolThread)resourceWaiter.waitFor(-1L);
        if (ThreadPool.logger.level >= 9) {
            logger.log(9, "allocate()", "got it: " + poolThread);
        }
        return poolThread;
    }

    private synchronized void release(PoolThread poolThread) {
        if (ThreadPool.logger.level >= 7) {
            logger.log(7, "release(PoolThread)", ThreadPool.logger.level < 8 ? "" : "thread: " + poolThread);
        }
        if (poolThread.isAlive() && this.waiters.size() > 0) {
            ((ResourceWaiter)this.waiters.remove(0)).handResource(poolThread);
        } else if (!poolThread.isAlive() || this.currentThreads > this.avgThreads && this.available.size() >= this.minThreads) {
            if (ThreadPool.logger.level >= 9) {
                logger.log(9, "release(PoolThread)", "Terminating Thread " + poolThread);
            }
            poolThread.terminate();
            --this.currentThreads;
        } else {
            this.available.add(poolThread);
        }
    }

    private synchronized void checkLive() {
        if (ThreadPool.logger.level >= 7) {
            logger.log(7, "checkLive()", "");
        }
        Iterator iterator = this.available.iterator();
        while (iterator.hasNext()) {
            PoolThread poolThread = (PoolThread)iterator.next();
            if (poolThread.isAlive()) continue;
            if (ThreadPool.logger.level >= 9) {
                logger.build("checkLive()").add("Dead thread: ").add(poolThread).log(9);
            }
            iterator.remove();
            --this.currentThreads;
        }
    }

    public static class CancelledException
    extends Exception {
        public CancelledException(String string) {
            super(string);
        }
    }

    public static class TimedOutException
    extends Exception {
        public TimedOutException(String string) {
            super(string);
        }
    }

    private static class WatchDog
    extends DaemonThread {
        private static int id = 0;
        private Hashtable threads = new Hashtable();
        private Hashtable timedOuts = new Hashtable();
        private List timeouts = new ArrayList();
        private List callids = new ArrayList();
        private static Object lock = new Object();
        private static WatchDog instance;
        private boolean stop = false;

        private WatchDog() {
            super("WatchDog-" + id++);
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "WatchDog()", "");
            }
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void add(Thread thread, long l, long l2, boolean[] blArray) {
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "add(Thread,long,long)", wdLogger.level < 8 ? "" : "thread: " + thread + ", timeout: " + l + ", callid: " + l2);
            }
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new WatchDog();
                }
                instance.addThread(thread, l, l2, blArray);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void remove(long l) {
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "remove(long)", wdLogger.level < 8 ? "" : "callid: " + l);
            }
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    return;
                }
                instance.removeThread(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void cancel(long l) {
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "cancel(long)", wdLogger.level < 8 ? "" : "callid: " + l);
            }
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    return;
                }
                instance.cancelThread(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "run()", "");
            }
            WatchDog watchDog = this;
            synchronized (watchDog) {
                while (!this.stop) {
                    while (this.timeouts.size() == 0) {
                        try {
                            if (wdLogger.level >= 9) {
                                wdLogger.log(9, "run()", "Waiting for threads...");
                            }
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (wdLogger.level < 9) break;
                            wdLogger.log(9, "run()", "Interrupted");
                            break;
                        }
                    }
                    if (this.stop) break;
                    if (wdLogger.level >= 9) {
                        wdLogger.log(9, "run()", "Got threads, checking timeouts");
                    }
                    long l = -1L;
                    long l2 = System.currentTimeMillis();
                    while (this.timeouts.size() > 0 && (l = (Long)this.timeouts.get(0) - l2) <= 0L) {
                        this.timeouts.remove(0);
                        long l3 = (Long)this.callids.remove(0);
                        this.timeout(l3);
                    }
                    if (this.stop) break;
                    if (this.timeouts.size() > 0 && l > 0L) {
                        if (wdLogger.level >= 9) {
                            wdLogger.log(9, "run()", "Waiting for next timeout");
                        }
                        try {
                            this.wait(l);
                        }
                        catch (InterruptedException interruptedException) {
                            if (wdLogger.level < 9) break;
                            wdLogger.log(9, "run()", "Interrupted");
                            break;
                        }
                    }
                    if (!this.stop) continue;
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addThread(Thread thread, long l, long l2, boolean[] blArray) {
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "addThread(Thread,long,long)", wdLogger.level < 8 ? "" : "thread: " + thread + ", timeout: " + l + ", callid: " + l2);
            }
            WatchDog watchDog = this;
            synchronized (watchDog) {
                this.threads.put(l2, thread);
                this.timedOuts.put(l2, blArray);
                if (l > 0L) {
                    int n;
                    long l3 = System.currentTimeMillis() + l;
                    for (n = 0; n < this.timeouts.size() && (Long)this.timeouts.get(n) <= l3; ++n) {
                    }
                    this.timeouts.add(n, l3);
                    this.callids.add(n, l2);
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeThread(long l) {
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "removeThread(long)", wdLogger.level < 8 ? "" : "callid: " + l);
            }
            WatchDog watchDog = this;
            synchronized (watchDog) {
                this.threads.remove(l);
                this.timedOuts.remove(l);
                for (int i = 0; i < this.callids.size(); ++i) {
                    if ((Long)this.callids.get(i) != l) continue;
                    this.callids.remove(i);
                    this.timeouts.remove(i);
                    break;
                }
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void cancelThread(long l) {
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "cancelThread(long)", wdLogger.level < 8 ? "" : "callid: " + l);
            }
            WatchDog watchDog = this;
            synchronized (watchDog) {
                Thread thread = (Thread)this.threads.get(l);
                this.threads.remove(l);
                this.timedOuts.remove(l);
                for (int i = 0; i < this.callids.size(); ++i) {
                    if ((Long)this.callids.get(i) != l) continue;
                    this.callids.remove(i);
                    this.timeouts.remove(i);
                    break;
                }
                if (thread != null) {
                    thread.interrupt();
                }
                this.notifyAll();
            }
        }

        private synchronized void timeout(long l) {
            if (wdLogger.level >= 7) {
                wdLogger.log(7, "timeout(long)", wdLogger.level < 8 ? "" : "callid: " + l);
            }
            Long l2 = l;
            Thread thread = (Thread)this.threads.get(l2);
            this.threads.remove(l2);
            boolean[] blArray = (boolean[])this.timedOuts.get(l2);
            this.timedOuts.remove(l2);
            if (thread == null) {
                if (wdLogger.level >= 1) {
                    wdLogger.log(1, "timeout(long)", "internal error, lost thread for " + l);
                }
            } else {
                blArray[0] = true;
                thread.interrupt();
            }
            this.notifyAll();
        }
    }

    private class PoolThread
    extends DaemonThread {
        private Object runner;
        private boolean quit;
        private boolean block;
        private Object retval;
        private Throwable exception;

        public PoolThread(ThreadGroup threadGroup) {
            super(threadGroup, "PoolThread-" + count++);
            if (ptLogger.level >= 7) {
                ptLogger.log(7, "PoolThread()", "count: " + count++);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (ptLogger.level >= 7) {
                ptLogger.log(7, "run()", "");
            }
            while (true) {
                PoolThread poolThread;
                Object object;
                Object object2 = this;
                synchronized (object2) {
                    while (this.runner == null && !this.quit) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    object = this.runner;
                    this.exception = null;
                    if (this.quit) {
                        this.runner = null;
                        this.notifyAll();
                        break;
                    }
                    if (object instanceof UnsafeRunnable) {
                        this.block = true;
                    }
                }
                object2 = null;
                try {
                    if (ptLogger.level >= 9) {
                        ptLogger.log(9, "run()", "Executing " + object);
                    }
                    this.retval = null;
                    if (object instanceof Runnable) {
                        ((Runnable)object).run();
                    } else {
                        this.retval = ((UnsafeRunnable)object).run();
                    }
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    if (object instanceof Runnable) {
                        if (ptLogger.level >= 1) {
                            ptLogger.log(1, "run()", throwable);
                        }
                    } else if (logger.level >= 9) {
                        logger.log(9, "run()", throwable);
                    }
                }
                finally {
                    poolThread = this;
                    synchronized (poolThread) {
                        this.runner = null;
                        this.exception = object2;
                        this.notifyAll();
                    }
                }
                poolThread = this;
                synchronized (poolThread) {
                    while (this.block) {
                        if (logger.level >= 9) {
                            ptLogger.log(9, "run()", "Waiting to unblock");
                        }
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (this.block || logger.level < 9) continue;
                        ptLogger.log(9, "run()", "Unblocked");
                    }
                }
                ThreadPool.this.release(this);
            }
        }

        public synchronized void execute(Runnable runnable) {
            this._execute(runnable);
        }

        public synchronized void execute(UnsafeRunnable unsafeRunnable) {
            this._execute(unsafeRunnable);
        }

        public synchronized void terminate() {
            if (ptLogger.level >= 7) {
                ptLogger.log(7, "terminate()", "this: " + this);
            }
            this.quit = true;
            this.notifyAll();
        }

        private synchronized void _execute(Object object) {
            if (ptLogger.level >= 7) {
                ptLogger.log(7, "_execute(Object)", ptLogger.level < 8 ? "" : "this: " + this + ", runnable: " + object);
            }
            while (this.runner != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.runner = object;
            this.notifyAll();
        }
    }

    public static interface UnsafeRunnable {
        public Object run() throws Exception;
    }
}

