/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.xml;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Log;
import de.qfs.lib.log.QFLogger;
import de.qfs.lib.util.ArgsParser;
import de.qfs.lib.util.LogSetup;
import de.qfs.lib.util.Reflector;
import java.util.HashMap;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import lombok.Generated;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class Transform {
    @Generated
    private static final QFLogger logger = new QFLogger("de.qfs.lib.xml.Transform");
    public static final int EXIT_TRANSFORMATION_ERROR = 1;
    public static final int EXIT_OK = 0;
    public static final int EXIT_COMMAND_LINE_ARGUMENTS = -1;
    public static final int EXIT_TRANSFORMATION_EXCEPTION = -2;
    private boolean idsUnique = true;

    private Transform() {
        if (Transform.logger.level >= 7) {
            logger.lvlBuild(7, "Transform()", 69).log();
        }
    }

    public static void main(String[] stringArray) {
        System.setProperty("jdk.xml.enableExtensionFunctions", "true");
        Log.setOutputLevel(2);
        LogSetup.instance().setupInitialLogging("transform");
        ArgsParser argsParser = new ArgsParser(Transform.getOfficialParameters());
        LogSetup.instance().addOptions(argsParser);
        try {
            argsParser.parse(stringArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        LogSetup.instance().setupLogging("transform", argsParser);
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (Transform.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "main(String[])", 102).addDetail("args", stringArray)).log();
        }
        int n = new Transform().run(argsParser);
        System.exit(n);
    }

    public static String[] getOfficialParameters() {
        if (Transform.logger.level >= 7) {
            logger.lvlBuild(7, "getOfficialParameters()", 121).log();
        }
        return new String[]{"+lang", "+in", "+out", "=checkEntities", "=checkIds", "m+param", "m+param1", "m+param2", "m+param3", "m+stylesheet", "+target", "+version"};
    }

    public int run(ArgsParser argsParser) {
        if (Transform.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "run(ArgsParser)", 151).addDetail("ap", argsParser)).log();
        }
        try {
            Object object;
            int n;
            String[] stringArray;
            String string;
            Object object2;
            boolean bl;
            TransformerHandler[] transformerHandlerArray;
            StreamSource[] streamSourceArray;
            SAXTransformerFactory sAXTransformerFactory;
            String[] stringArray2;
            String string2;
            String string3;
            String[][] stringArrayArray;
            String[] stringArray3;
            String string4;
            String string5;
            String string6;
            block28: {
                string6 = argsParser.getString("lang", null);
                string5 = argsParser.getString("target", null);
                string4 = argsParser.getString("version", null);
                stringArray3 = argsParser.getStrings("param", null);
                stringArrayArray = new String[][]{argsParser.getStrings("param1", null), argsParser.getStrings("param2", null), argsParser.getStrings("param3", null)};
                string3 = argsParser.getString("in", null);
                string2 = argsParser.getString("out", null);
                stringArray2 = argsParser.getStrings("stylesheet", null);
                if (stringArray2 == null) {
                    if (Transform.logger.level >= 1) {
                        ((LevelAwareLogBuilder)logger.lvlBuild(1, "run(ArgsParser)", 168).add("No stylesheets")).log();
                    }
                    System.err.println("Missing XSLT stylesheet parameter -stylesheet");
                    return -1;
                }
                sAXTransformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
                streamSourceArray = new StreamSource[stringArray2.length];
                transformerHandlerArray = new TransformerHandler[stringArray2.length];
                String string7 = argsParser.getString("checkEntities", null);
                boolean bl2 = string7 != null;
                bl = "fail".equalsIgnoreCase(string7);
                if (Transform.logger.level >= 9) {
                    ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "run(ArgsParser)", 180).add("checkEntitiesArg", string7)).add("checkEntities", bl2)).add("failOnFailedCheckEntities", bl)).log();
                }
                object2 = null;
                if (bl2) {
                    try {
                        object2 = Reflector.createInstance(Class.forName("de.qfs.apps.qftest.xml.TransformTracker"));
                        Reflector.call(object2, "failOnEntityErrors");
                    }
                    catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
                        System.err.println("ERROR: Could not initialize TransformTracker. connector.jar must be on classpath. (" + reflectiveOperationException + ")");
                        if (!bl) break block28;
                        System.exit(1);
                    }
                }
            }
            boolean bl3 = (string = argsParser.getString("checkIds", null)) != null;
            boolean bl4 = "fail".equalsIgnoreCase(string);
            if (Transform.logger.level >= 9) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(9, "run(ArgsParser)", 198).add("checkIdsArg", string)).add("checkIds", bl3)).add("failOnFailedCheckIds", bl4)).log();
            }
            for (int i = 0; i < stringArray2.length; ++i) {
                int n2;
                int n3;
                streamSourceArray[i] = new StreamSource(stringArray2[i]);
                transformerHandlerArray[i] = sAXTransformerFactory.newTransformerHandler(streamSourceArray[i]);
                if (bl3 && i == stringArray2.length - 1) {
                    transformerHandlerArray[i] = new IDCheckingTransformerHandler(transformerHandlerArray[i]);
                }
                if (string6 != null) {
                    transformerHandlerArray[i].getTransformer().setParameter("lang", string6);
                }
                if (string5 != null) {
                    transformerHandlerArray[i].getTransformer().setParameter("target", string5);
                }
                if (string4 != null) {
                    transformerHandlerArray[i].getTransformer().setParameter("version", string4);
                }
                if (stringArray3 != null) {
                    stringArray = stringArray3;
                    n3 = stringArray.length;
                    for (n = 0; n < n3; ++n) {
                        object = stringArray[n];
                        n2 = ((String)object).indexOf("=");
                        if (n2 <= 0) {
                            if (Transform.logger.level >= 1) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "run(ArgsParser)", 219).add("Bad argument to -param: ")).add((String)object)).log();
                            }
                            System.err.println("Bad argument to -param: " + (String)object);
                            return -1;
                        }
                        transformerHandlerArray[i].getTransformer().setParameter(((String)object).substring(0, n2), ((String)object).substring(n2 + 1));
                    }
                }
                if (i < 4 && stringArrayArray[i] != null) {
                    stringArray = stringArrayArray[i];
                    n3 = stringArray.length;
                    for (n = 0; n < n3; ++n) {
                        object = stringArray[n];
                        n2 = ((String)object).indexOf("=");
                        if (n2 <= 0) {
                            if (Transform.logger.level >= 1) {
                                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(1, "run(ArgsParser)", 230).add("Bad argument to -param")).add(i + 1)).add(": ")).add((String)object)).log();
                            }
                            System.err.println("Bad argument to -param" + (i + 1) + ": " + (String)object);
                            return -1;
                        }
                        transformerHandlerArray[i].getTransformer().setParameter(((String)object).substring(0, n2), ((String)object).substring(n2 + 1));
                    }
                }
                transformerHandlerArray[i].getTransformer().setErrorListener(new PrintWarningErrorListener());
            }
            StreamSource streamSource = string3 == null ? new StreamSource(System.in) : new StreamSource(string3);
            Object object3 = stringArray = string2 == null ? new StreamResult(System.out) : new StreamResult(string2);
            for (n = transformerHandlerArray.length - 2; n >= 0; --n) {
                object = new SAXResult(transformerHandlerArray[n + 1]);
                transformerHandlerArray[n].setResult((Result)object);
                object3 = object;
            }
            transformerHandlerArray[transformerHandlerArray.length - 1].setResult((Result)stringArray);
            transformerHandlerArray[0].getTransformer().transform(streamSource, (Result)object3);
            if (bl && object2 != null && ((Boolean)Reflector.safeGet(object2, "errorsRaised")).booleanValue()) {
                System.exit(1);
            }
            if (bl4 && !this.idsUnique) {
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            if (Transform.logger.level >= 1) {
                ((LevelAwareLogBuilder)logger.lvlBuild(1, "run(ArgsParser)", 287).add("ex", throwable)).log();
            }
            while (throwable2 != null) {
                System.err.println("  -> " + throwable2);
                throwable2 = this.getCause(throwable2);
            }
            return -1;
        }
        return 0;
    }

    Throwable getCause(Throwable throwable) {
        Throwable throwable2;
        if (Transform.logger.level >= 7) {
            ((LevelAwareLogBuilder)logger.lvlBuild(7, "getCause(Throwable)", 303).addDetail("t", throwable)).log();
        }
        if ((throwable2 = (Throwable)Reflector.safeCall(throwable, "getException")) != null && throwable2 != throwable) {
            return throwable2;
        }
        throwable2 = throwable.getCause();
        if (throwable2 != null && throwable2 != throwable) {
            return throwable2;
        }
        throwable2 = (Throwable)Reflector.safeGet(throwable, "cause", true);
        if (throwable2 != null && throwable2 != throwable) {
            return throwable2;
        }
        return null;
    }

    private class IDCheckingTransformerHandler
    implements TransformerHandler {
        final TransformerHandler delegate;
        final HashMap<String, String> usedIds = new HashMap();

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            String string5;
            String string6;
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)((LevelAwareLogBuilder)logger.lvlBuild(7, "IDCheckingTransformerHandler.startElement(String,String,String,Attributes)", 346).addDetail("uri", string)).addDetail("localName", string2)).addDetail("qName", string3)).addDetail("atts", attributes)).log();
            }
            if ((string6 = attributes.getValue("id")) != null && !string6.isEmpty() && (string5 = this.usedIds.put(string6, string4 = string2)) != null) {
                System.err.println(String.format("ERROR: id=\"%s\" used multiple times. Seen in: %s element, now in %s element.", string6, string5, string4));
                Transform.this.idsUnique = false;
            }
            this.delegate.startElement(string, string2, string3, attributes);
        }

        @Generated
        public IDCheckingTransformerHandler(TransformerHandler transformerHandler) {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "IDCheckingTransformerHandler.IDCheckingTransformerHandler(TransformerHandler)", 338).addDetail("delegate", transformerHandler)).log();
            }
            this.delegate = transformerHandler;
        }

        @Override
        @Generated
        public void setResult(Result result) throws IllegalArgumentException {
            this.delegate.setResult(result);
        }

        @Override
        @Generated
        public void setSystemId(String string) {
            this.delegate.setSystemId(string);
        }

        @Override
        @Generated
        public String getSystemId() {
            return this.delegate.getSystemId();
        }

        @Override
        @Generated
        public Transformer getTransformer() {
            return this.delegate.getTransformer();
        }

        @Override
        @Generated
        public void setDocumentLocator(Locator locator) {
            this.delegate.setDocumentLocator(locator);
        }

        @Override
        @Generated
        public void startDocument() throws SAXException {
            this.delegate.startDocument();
        }

        @Override
        @Generated
        public void endDocument() throws SAXException {
            this.delegate.endDocument();
        }

        @Override
        @Generated
        public void startPrefixMapping(String string, String string2) throws SAXException {
            this.delegate.startPrefixMapping(string, string2);
        }

        @Override
        @Generated
        public void endPrefixMapping(String string) throws SAXException {
            this.delegate.endPrefixMapping(string);
        }

        @Override
        @Generated
        public void endElement(String string, String string2, String string3) throws SAXException {
            this.delegate.endElement(string, string2, string3);
        }

        @Override
        @Generated
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            this.delegate.characters(cArray, n, n2);
        }

        @Override
        @Generated
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
            this.delegate.ignorableWhitespace(cArray, n, n2);
        }

        @Override
        @Generated
        public void processingInstruction(String string, String string2) throws SAXException {
            this.delegate.processingInstruction(string, string2);
        }

        @Override
        @Generated
        public void skippedEntity(String string) throws SAXException {
            this.delegate.skippedEntity(string);
        }

        @Override
        @Generated
        public void startDTD(String string, String string2, String string3) throws SAXException {
            this.delegate.startDTD(string, string2, string3);
        }

        @Override
        @Generated
        public void endDTD() throws SAXException {
            this.delegate.endDTD();
        }

        @Override
        @Generated
        public void startEntity(String string) throws SAXException {
            this.delegate.startEntity(string);
        }

        @Override
        @Generated
        public void endEntity(String string) throws SAXException {
            this.delegate.endEntity(string);
        }

        @Override
        @Generated
        public void startCDATA() throws SAXException {
            this.delegate.startCDATA();
        }

        @Override
        @Generated
        public void endCDATA() throws SAXException {
            this.delegate.endCDATA();
        }

        @Override
        @Generated
        public void comment(char[] cArray, int n, int n2) throws SAXException {
            this.delegate.comment(cArray, n, n2);
        }

        @Override
        @Generated
        public void notationDecl(String string, String string2, String string3) throws SAXException {
            this.delegate.notationDecl(string, string2, string3);
        }

        @Override
        @Generated
        public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
            this.delegate.unparsedEntityDecl(string, string2, string3, string4);
        }
    }

    private static class PrintWarningErrorListener
    implements ErrorListener {
        private PrintWarningErrorListener() {
            if (logger.level >= 7) {
                logger.lvlBuild(7, "PrintWarningErrorListener.PrintWarningErrorListener()", 317).log();
            }
        }

        @Override
        public void warning(TransformerException transformerException) throws TransformerException {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "PrintWarningErrorListener.warning(TransformerException)", 320).addDetail("exception", transformerException)).log();
            }
            System.out.println(transformerException.getMessage());
        }

        @Override
        public void error(TransformerException transformerException) throws TransformerException {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "PrintWarningErrorListener.error(TransformerException)", 326).addDetail("exception", transformerException)).log();
            }
            throw transformerException;
        }

        @Override
        public void fatalError(TransformerException transformerException) throws TransformerException {
            if (logger.level >= 7) {
                ((LevelAwareLogBuilder)logger.lvlBuild(7, "PrintWarningErrorListener.fatalError(TransformerException)", 332).addDetail("exception", transformerException)).log();
            }
            throw transformerException;
        }
    }
}

