/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LogEntry;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class LogQueue {
    private boolean queueing = true;
    private LogEntry cubby;
    private int maxSize = 3000;
    private boolean drop = false;
    private boolean mustPop;
    private LogEntry[] array = new LogEntry[this.maxSize];
    private int head;
    private int tail;
    private int size = 0;
    private boolean waitFlush;
    private int flushCount;
    private static int xxx = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void push(LogEntry logEntry) {
        while (true) {
            block14: {
                if (this.waitFlush && this.flushCount > 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                if (this.queueing) {
                    if (this.size == this.maxSize) {
                        if (this.drop) {
                            if (++this.tail == this.maxSize) {
                                this.tail = 0;
                            }
                            this.array[this.head++] = logEntry;
                            if (this.head == this.maxSize) {
                                this.head = 0;
                            }
                            this.notifyAll();
                            return;
                        }
                        break block14;
                    } else {
                        this.array[this.head++] = logEntry;
                        if (this.head == this.maxSize) {
                            this.head = 0;
                        }
                        ++this.size;
                        this.notifyAll();
                        return;
                    }
                }
                if (this.cubby == null) {
                    this.cubby = logEntry;
                    this.notifyAll();
                    return;
                }
            }
            try {
                this.mustPop = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mustPop = false;
        }
    }

    public synchronized LogEntry pop() {
        while (this.queueing ? this.size == 0 : this.cubby == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.queueing) {
            LogEntry logEntry = this.array[this.tail];
            this.array[this.tail++] = null;
            if (this.tail == this.maxSize) {
                this.tail = 0;
            }
            --this.size;
            ++this.flushCount;
            return logEntry;
        }
        LogEntry logEntry = this.cubby;
        this.cubby = null;
        ++this.flushCount;
        return logEntry;
    }

    public synchronized LogEntry[] popAll() {
        LogEntry[] logEntryArray;
        while (this.queueing ? this.size == 0 : this.cubby == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.queueing) {
            logEntryArray = new LogEntry[this.size];
            if (this.head > this.tail) {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.size);
            } else {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.maxSize - this.tail);
                if (this.head > 0) {
                    System.arraycopy(this.array, 0, logEntryArray, this.maxSize - this.tail, this.head);
                }
            }
            this.array = new LogEntry[this.maxSize];
            this.size = 0;
            this.tail = 0;
            this.head = 0;
        } else {
            logEntryArray = new LogEntry[]{this.cubby};
            this.cubby = null;
        }
        ++this.flushCount;
        return logEntryArray;
    }

    public synchronized void entriesProcessed() {
        --this.flushCount;
        this.notifyAll();
    }

    public final boolean isQueueing() {
        return this.queueing;
    }

    public final synchronized void setQueueing(boolean bl) {
        if (this.queueing != bl) {
            while (this.queueing ? this.size != 0 : this.cubby != null) {
                this.waitFlush = true;
                try {
                    this.mustPop = true;
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.mustPop = false;
            }
            this.queueing = bl;
            this.notifyAll();
            while (this.waitFlush && this.flushCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.waitFlush = false;
        }
    }

    public final int getQueueSize() {
        return this.maxSize;
    }

    public synchronized void setQueueSize(int n) {
        if (n == this.maxSize) {
            return;
        }
        while (this.queueing && this.size > n) {
            if (this.drop) {
                this.tail += this.size - n;
                if (this.tail > this.maxSize) {
                    this.tail -= this.maxSize;
                }
                this.size = n;
                continue;
            }
            try {
                this.mustPop = true;
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mustPop = false;
        }
        LogEntry[] logEntryArray = new LogEntry[n];
        if (this.queueing && this.size > 0) {
            if (this.head > this.tail) {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.size);
            } else {
                System.arraycopy(this.array, this.tail, logEntryArray, 0, this.maxSize - this.tail);
                if (this.head > 0) {
                    System.arraycopy(this.array, this.tail, logEntryArray, this.maxSize - this.tail, this.head);
                }
            }
        }
        this.maxSize = n;
        this.array = logEntryArray;
        this.head = this.size;
        this.tail = 0;
        this.notifyAll();
    }

    public final boolean isDropOnOverflow() {
        return this.drop;
    }

    public synchronized void setDropOnOverflow(boolean bl) {
        this.drop = bl;
        this.notifyAll();
    }

    public static class UnitTest
    extends TestCase {
        private LogQueue queue;
        private Popper popper;
        private int num;

        public UnitTest(String string) {
            super(string);
        }

        protected void setUp() {
            this.queue = new LogQueue();
            this.queue.setQueueSize(5);
            this.popper = new Popper();
            this.popper.setPriority(1);
            this.popper.start();
            this.num = 0;
            this.fill(4);
        }

        public static Test suite() {
            return new TestSuite(UnitTest.class);
        }

        public void testFlush() {
            UnitTest.assertNull((Object)this.popper.entries);
            this.fill(3);
            UnitTest.assertTrue((this.popper.called == 1 ? 1 : 0) != 0);
            UnitTest.assertNotNull((Object)this.popper.entries);
            UnitTest.assertTrue((this.popper.entries.length == 5 ? 1 : 0) != 0);
            UnitTest.assertTrue((this.popper.entries[0].getLevel() == 0 ? 1 : 0) != 0);
            UnitTest.assertTrue((this.popper.entries[4].getTimestamp() == 4L ? 1 : 0) != 0);
            this.done();
        }

        public void testCubby() {
            UnitTest.assertNull((Object)this.popper.entries);
            this.queue.setQueueing(false);
            UnitTest.assertTrue((this.popper.called == 1 ? 1 : 0) != 0);
            UnitTest.assertNotNull((Object)this.popper.entries);
            UnitTest.assertTrue((this.popper.entries.length == 4 ? 1 : 0) != 0);
            UnitTest.assertTrue((this.popper.entries[0].getLevel() == 0 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)this.popper.entries[3].getThread().equals("thread3"));
            this.fill(4);
            UnitTest.assertTrue((this.popper.called == 4 ? 1 : 0) != 0);
            UnitTest.assertNotNull((Object)this.popper.entries);
            UnitTest.assertTrue((this.popper.entries.length == 1 ? 1 : 0) != 0);
            UnitTest.assertTrue((this.popper.entries[0].getLevel() == 6 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)this.popper.entries[0].getClazz().equals("class6"));
            this.done();
        }

        public void testDrop() {
            UnitTest.assertNull((Object)this.popper.entries);
            this.queue.setDropOnOverflow(true);
            this.fill(100);
            UnitTest.assertTrue((this.popper.called == 0 ? 1 : 0) != 0);
            this.done();
        }

        public void testResize() {
            UnitTest.assertNull((Object)this.popper.entries);
            this.queue.setQueueSize(10);
            this.fill(5);
            UnitTest.assertTrue((this.popper.called == 0 ? 1 : 0) != 0);
            this.fill(5);
            UnitTest.assertTrue((this.popper.called == 1 ? 1 : 0) != 0);
            UnitTest.assertNotNull((Object)this.popper.entries);
            UnitTest.assertTrue((this.popper.entries.length == 10 ? 1 : 0) != 0);
            UnitTest.assertTrue((this.popper.entries[0].getLevel() == 0 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)this.popper.entries[9].getMethod().equals("method9"));
            this.queue.setQueueSize(3);
            this.fill(1);
            UnitTest.assertTrue((this.popper.called == 2 ? 1 : 0) != 0);
            UnitTest.assertNotNull((Object)this.popper.entries);
            UnitTest.assertTrue((this.popper.entries.length == 4 ? 1 : 0) != 0);
            UnitTest.assertTrue((this.popper.entries[0].getLevel() == 10 ? 1 : 0) != 0);
            UnitTest.assertTrue((boolean)this.popper.entries[3].getMessage().equals("message13"));
            this.done();
        }

        private void fill(int n) {
            for (int i = 0; i < n; ++i) {
                this.queue.push(new LogEntry(this.num, this.num, "thread" + this.num, "class" + this.num, "method" + this.num, "message" + this.num));
                ++this.num;
            }
        }

        private void done() {
            this.popper.done = true;
            try {
                Thread.sleep(120L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            UnitTest.assertFalse((boolean)this.popper.isAlive());
        }

        class Popper
        extends Thread {
            public LogEntry[] entries;
            public int called;
            public boolean done;

            Popper() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                do {
                    LogQueue logQueue = UnitTest.this.queue;
                    synchronized (logQueue) {
                        if (UnitTest.this.queue.mustPop) {
                            this.pop();
                        }
                    }
                    try {
                        Popper.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                } while (!this.done);
            }

            public void pop() {
                this.entries = UnitTest.this.queue.popAll();
                ++this.called;
                UnitTest.this.queue.entriesProcessed();
            }
        }
    }
}

