/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import de.qfs.lib.log.Logger;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.GdkRGBA;
import org.eclipse.swt.internal.gtk.GdkRectangle;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tracker
extends Widget {
    private static final Logger logger = new Logger("org.eclipse.swt.widgets.Tracker");
    Composite parent;
    Cursor cursor;
    long lastCursor;
    long window;
    long overlay;
    boolean tracking;
    boolean cancelled;
    boolean grabbed;
    boolean stippled;
    Rectangle[] rectangles = new Rectangle[0];
    Rectangle[] proportions = this.rectangles;
    Rectangle bounds;
    int cursorOrientation = 0;
    int oldX;
    int oldY;
    static final int STEPSIZE_SMALL = 1;
    static final int STEPSIZE_LARGE = 9;

    public Tracker(Composite composite, int n) {
        super(composite, Tracker.checkStyle(n));
        this.parent = composite;
    }

    public Tracker(Display display, int n) {
        if (display == null) {
            display = Display.getCurrent();
        }
        if (display == null) {
            display = Display.getDefault();
        }
        if (!display.isValidThread()) {
            this.error(22);
        }
        this.style = Tracker.checkStyle(n);
        this.display = display;
        this.reskinWidget();
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(keyListener);
        this.addListener(2, typedListener);
        this.addListener(1, typedListener);
    }

    Point adjustMoveCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = this.bounds.x + this.bounds.width / 2;
        int n2 = this.bounds.y;
        Point point = this.display.map(this.parent, null, n, n2);
        this.display.setCursorLocation(point);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.gdk_window_get_device_position(this.window, nArray, nArray2, nArray3);
        return new Point(nArray[0], nArray2[0]);
    }

    Point adjustResizeCursor() {
        if (this.bounds == null) {
            return null;
        }
        int n = (this.cursorOrientation & 0x4000) != 0 ? this.bounds.x : ((this.cursorOrientation & 0x20000) != 0 ? this.bounds.x + this.bounds.width : this.bounds.x + this.bounds.width / 2);
        int n2 = (this.cursorOrientation & 0x80) != 0 ? this.bounds.y : ((this.cursorOrientation & 0x400) != 0 ? this.bounds.y + this.bounds.height : this.bounds.y + this.bounds.height / 2);
        Point point = this.display.map(this.parent, null, n, n2);
        this.display.setCursorLocation(point);
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        this.gdk_window_get_device_position(this.window, nArray, nArray2, nArray3);
        return new Point(nArray[0], nArray2[0]);
    }

    public void close() {
        this.checkWidget();
        this.tracking = false;
    }

    static int checkStyle(int n) {
        if ((n & 0x24480) == 0) {
            n |= 0x24480;
        }
        return n;
    }

    Rectangle computeBounds() {
        if (this.rectangles.length == 0) {
            return null;
        }
        int n = this.rectangles[0].x;
        int n2 = this.rectangles[0].y;
        int n3 = this.rectangles[0].x + this.rectangles[0].width;
        int n4 = this.rectangles[0].y + this.rectangles[0].height;
        for (int i = 1; i < this.rectangles.length; ++i) {
            int n5;
            int n6;
            if (this.rectangles[i].x < n) {
                n = this.rectangles[i].x;
            }
            if (this.rectangles[i].y < n2) {
                n2 = this.rectangles[i].y;
            }
            if ((n6 = this.rectangles[i].x + this.rectangles[i].width) > n3) {
                n3 = n6;
            }
            if ((n5 = this.rectangles[i].y + this.rectangles[i].height) <= n4) continue;
            n4 = n5;
        }
        return new Rectangle(n, n2, n3 - n, n4 - n2);
    }

    Rectangle[] computeProportions(Rectangle[] rectangleArray) {
        Rectangle[] rectangleArray2 = new Rectangle[rectangleArray.length];
        this.bounds = this.computeBounds();
        if (this.bounds != null) {
            for (int i = 0; i < rectangleArray.length; ++i) {
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                int n4 = 0;
                if (this.bounds.width != 0) {
                    n = (rectangleArray[i].x - this.bounds.x) * 100 / this.bounds.width;
                    n3 = rectangleArray[i].width * 100 / this.bounds.width;
                } else {
                    n3 = 100;
                }
                if (this.bounds.height != 0) {
                    n2 = (rectangleArray[i].y - this.bounds.y) * 100 / this.bounds.height;
                    n4 = rectangleArray[i].height * 100 / this.bounds.height;
                } else {
                    n4 = 100;
                }
                rectangleArray2[i] = new Rectangle(n, n2, n3, n4);
            }
        }
        return rectangleArray2;
    }

    void drawRectangles(Rectangle[] rectangleArray) {
        long l = OS.gdk_get_default_root_window();
        if (this.parent != null) {
            l = this.gtk_widget_get_window(this.parent.paintHandle());
        }
        if (l == 0L) {
            return;
        }
        if (OS.GTK3) {
            if (this.overlay == 0L) {
                return;
            }
            OS.gtk_widget_shape_combine_region(this.overlay, 0L);
            long l2 = OS.gdk_region_new();
            GdkRectangle gdkRectangle = new GdkRectangle();
            for (int i = 0; i < rectangleArray.length; ++i) {
                Rectangle rectangle = this.parent != null ? this.display.map((Control)this.parent, null, rectangleArray[i]) : rectangleArray[i];
                gdkRectangle.x = rectangle.x;
                gdkRectangle.y = rectangle.y;
                gdkRectangle.width = rectangle.width + 1;
                gdkRectangle.height = 1;
                OS.gdk_region_union_with_rect(l2, gdkRectangle);
                gdkRectangle.width = 1;
                gdkRectangle.height = rectangle.height + 1;
                OS.gdk_region_union_with_rect(l2, gdkRectangle);
                gdkRectangle.x = rectangle.x + rectangle.width;
                OS.gdk_region_union_with_rect(l2, gdkRectangle);
                gdkRectangle.x = rectangle.x;
                gdkRectangle.y = rectangle.y + rectangle.height;
                gdkRectangle.width = rectangle.width + 1;
                gdkRectangle.height = 1;
                OS.gdk_region_union_with_rect(l2, gdkRectangle);
            }
            OS.gtk_widget_shape_combine_region(this.overlay, l2);
            OS.gdk_region_destroy(l2);
            long l3 = OS.gtk_widget_get_window(this.overlay);
            OS.gdk_window_hide(l3);
            OS.gdk_window_show(l3);
            return;
        }
        long l4 = OS.gdk_gc_new(l);
        if (l4 == 0L) {
            return;
        }
        long l5 = OS.gdk_colormap_get_system();
        GdkColor gdkColor = new GdkColor();
        OS.gdk_color_white(l5, gdkColor);
        OS.gdk_gc_set_foreground(l4, gdkColor);
        OS.gdk_gc_set_subwindow(l4, 1L);
        OS.gdk_gc_set_function(l4, 2L);
        for (int i = 0; i < rectangleArray.length; ++i) {
            Rectangle rectangle = rectangleArray[i];
            int n = rectangle.x;
            if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
                n = this.parent.getClientWidth() - rectangle.width - n;
            }
            OS.gdk_draw_rectangle(l, l4, 0, n, rectangle.y, rectangle.width, rectangle.height);
        }
        OS.g_object_unref(l4);
    }

    public Rectangle[] getRectangles() {
        this.checkWidget();
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i = 0; i < this.rectangles.length; ++i) {
            Rectangle rectangle = this.rectangles[i];
            rectangleArray[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        return rectangleArray;
    }

    public boolean getStippled() {
        this.checkWidget();
        return this.stippled;
    }

    boolean grab() {
        long l = this.cursor != null ? this.cursor.handle : 0L;
        int n = this.gdk_pointer_grab(this.window, 0, false, 516, this.window, l, 0);
        return n == 0;
    }

    long gtk_button_release_event(long l, long l2) {
        return this.gtk_mouse(7, l, l2);
    }

    long gtk_key_press_event(long l, long l2) {
        long l3 = super.gtk_key_press_event(l, l2);
        if (l3 != 0L) {
            return l3;
        }
        GdkEventKey gdkEventKey = new GdkEventKey();
        OS.memmove(gdkEventKey, l2, (long)GdkEventKey.sizeof);
        int n = (gdkEventKey.state & 4) != 0 ? 1 : 9;
        int n2 = 0;
        int n3 = 0;
        switch (gdkEventKey.keyval) {
            case 65307: {
                this.cancelled = true;
            }
            case 65293: {
                this.tracking = false;
                break;
            }
            case 65361: {
                n2 = -n;
                break;
            }
            case 65363: {
                n2 = n;
                break;
            }
            case 65362: {
                n3 = -n;
                break;
            }
            case 65364: {
                n3 = n;
            }
        }
        if (n2 != 0 || n3 != 0) {
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i = 0; i < this.rectangles.length; ++i) {
                Rectangle rectangle = this.rectangles[i];
                rectangleArray2[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            Event event = new Event();
            event.x = this.oldX + n2;
            event.y = this.oldY + n3;
            if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
                event.x = this.parent.getClientWidth() - event.width - event.x;
            }
            if ((this.style & 0x10) != 0) {
                Point point;
                this.resizeRectangles(n2, n3);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n4 = this.rectangles.length;
                    if (n4 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n4; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    if (!OS.GTK3) {
                        this.drawRectangles(rectangleArray2);
                        this.update();
                    }
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
            } else {
                Point point;
                this.moveRectangles(n2, n3);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n5 = this.rectangles.length;
                    if (n5 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n5; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    this.drawRectangles(rectangleArray2);
                    this.update();
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustMoveCursor()) != null) {
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
            }
        }
        return l3;
    }

    long gtk_motion_notify_event(long l, long l2) {
        long l3;
        long l4 = l3 = this.cursor != null ? this.cursor.handle : 0L;
        if (l3 != this.lastCursor) {
            this.ungrab();
            this.grabbed = this.grab();
            this.lastCursor = l3;
        }
        return this.gtk_mouse(3, l, l2);
    }

    long gtk_mouse(int n, long l, long l2) {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        this.gdk_window_get_device_position(this.window, nArray, nArray2, null);
        if (this.oldX != nArray[0] || this.oldY != nArray2[0]) {
            SerializableCompatibility serializableCompatibility;
            Rectangle[] rectangleArray = this.rectangles;
            Rectangle[] rectangleArray2 = new Rectangle[this.rectangles.length];
            for (int i = 0; i < this.rectangles.length; ++i) {
                serializableCompatibility = this.rectangles[i];
                rectangleArray2[i] = new Rectangle(serializableCompatibility.x, serializableCompatibility.y, serializableCompatibility.width, serializableCompatibility.height);
            }
            Event event = new Event();
            if (this.parent == null) {
                event.x = nArray[0];
                event.y = nArray2[0];
            } else {
                serializableCompatibility = this.display.map(this.parent, null, nArray[0], nArray2[0]);
                event.x = ((Point)serializableCompatibility).x;
                event.y = ((Point)serializableCompatibility).y;
            }
            if ((this.style & 0x10) != 0) {
                Point point;
                this.resizeRectangles(nArray[0] - this.oldX, nArray2[0] - this.oldY);
                this.sendEvent(11, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n2 = this.rectangles.length;
                    if (n2 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n2; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    if (!OS.GTK3) {
                        this.drawRectangles(rectangleArray2);
                        this.update();
                    }
                    this.drawRectangles(this.rectangles);
                }
                if ((point = this.adjustResizeCursor()) != null) {
                    nArray[0] = point.x;
                    nArray2[0] = point.y;
                }
            } else {
                this.moveRectangles(nArray[0] - this.oldX, nArray2[0] - this.oldY);
                this.sendEvent(10, event);
                if (this.isDisposed()) {
                    this.cancelled = true;
                    return 1L;
                }
                boolean bl = false;
                if (this.rectangles != rectangleArray) {
                    int n3 = this.rectangles.length;
                    if (n3 != rectangleArray2.length) {
                        bl = true;
                    } else {
                        for (int i = 0; i < n3; ++i) {
                            if (this.rectangles[i].equals(rectangleArray2[i])) continue;
                            bl = true;
                            break;
                        }
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    if (!OS.GTK3) {
                        this.drawRectangles(rectangleArray2);
                        this.update();
                    }
                    this.drawRectangles(this.rectangles);
                }
            }
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
        }
        this.tracking = n != 7;
        return 0L;
    }

    void moveRectangles(int n, int n2) {
        if (this.bounds == null) {
            return;
        }
        if (n < 0 && (this.style & 0x4000) == 0) {
            n = 0;
        }
        if (n > 0 && (this.style & 0x20000) == 0) {
            n = 0;
        }
        if (n2 < 0 && (this.style & 0x80) == 0) {
            n2 = 0;
        }
        if (n2 > 0 && (this.style & 0x400) == 0) {
            n2 = 0;
        }
        if (n == 0 && n2 == 0) {
            return;
        }
        if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
            n *= -1;
        }
        this.bounds.x += n;
        this.bounds.y += n2;
        for (int i = 0; i < this.rectangles.length; ++i) {
            this.rectangles[i].x += n;
            this.rectangles[i].y += n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean open() {
        if (Tracker.logger.level >= 7) {
            logger.dumpStack(7, "open()", "");
        }
        this.checkWidget();
        this.window = OS.gdk_get_default_root_window();
        if (this.parent != null) {
            this.window = this.gtk_widget_get_window(this.parent.paintHandle());
        }
        if (this.window == 0L) {
            return false;
        }
        this.cancelled = false;
        this.tracking = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            int n;
            boolean bl;
            int n2;
            boolean bl2;
            exception.printStackTrace(printWriter);
            printWriter.close();
            String string = byteArrayOutputStream.toString();
            boolean bl3 = bl2 = string.indexOf("org.eclipse.e4.ui.workbench.addons.dndaddon.DnDManager.startDrag") > 0 || string.indexOf("org.eclipse.ui.internal.dnd.DragUtil.performDrag") > 0;
            if (Tracker.logger.level >= 9) {
                logger.build("open()").add("insideDnD: ").add(bl2).log(9);
            }
            if (bl2) {
                this.display.runDNDTrackerHooks(true, false);
            }
            if (!OS.GTK3) {
                this.update();
                this.drawRectangles(this.rectangles);
            }
            int[] nArray = new int[1];
            int[] nArray2 = new int[1];
            int[] nArray3 = new int[1];
            this.gdk_window_get_device_position(this.window, nArray, nArray2, nArray3);
            int n3 = this.style & 0x480;
            if (n3 == 128 || n3 == 1024) {
                this.cursorOrientation |= n3;
            }
            if ((n2 = this.style & 0x24000) == 16384 || n2 == 131072) {
                this.cursorOrientation |= n2;
            }
            boolean bl4 = bl = (nArray3[0] & (n = 1792)) != 0;
            if (!bl) {
                Point point = null;
                point = (this.style & 0x10) != 0 ? this.adjustResizeCursor() : this.adjustMoveCursor();
                if (point != null) {
                    nArray[0] = point.x;
                    nArray2[0] = point.y;
                }
            }
            this.oldX = nArray[0];
            this.oldY = nArray2[0];
            this.grabbed = this.grab();
            long l = this.lastCursor = this.cursor != null ? this.cursor.handle : 0L;
            if (OS.GTK3) {
                this.overlay = OS.gtk_window_new(1);
                OS.gtk_window_set_skip_taskbar_hint(this.overlay, true);
                OS.gtk_window_set_title(this.overlay, new byte[1]);
                OS.gtk_widget_realize(this.overlay);
                long l2 = OS.gtk_widget_get_window(this.overlay);
                OS.gdk_window_set_override_redirect(l2, true);
                OS.gtk_widget_override_background_color(this.overlay, 0, new GdkRGBA());
                long l3 = OS.gdk_region_new();
                OS.gtk_widget_shape_combine_region(this.overlay, l3);
                OS.gtk_widget_input_shape_combine_region(this.overlay, l3);
                OS.gdk_region_destroy(l3);
                Rectangle rectangle = this.display.getBounds();
                OS.gtk_window_move(this.overlay, rectangle.x, rectangle.y);
                OS.gtk_window_resize(this.overlay, rectangle.width, rectangle.height);
                OS.gtk_widget_show(this.overlay);
            }
            Display display = this.display;
            Tracker tracker = display.tracker;
            display.tracker = this;
            try {
                while (this.tracking && (this.parent == null || !this.parent.isDisposed())) {
                    display.runSkin();
                    display.runDeferredLayouts();
                    OS.gdk_threads_leave();
                    OS.g_main_context_iteration(0L, true);
                    display.runAsyncMessages(false);
                }
                Object var18_19 = null;
                display.tracker = tracker;
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                display.tracker = tracker;
                throw throwable;
            }
            if (!this.isDisposed() && !OS.GTK3) {
                this.update();
                this.drawRectangles(this.rectangles);
            }
            this.ungrab();
            if (this.overlay != 0L) {
                OS.gtk_widget_destroy(this.overlay);
                this.overlay = 0L;
            }
            this.window = 0L;
            if (bl2) {
                display.runDNDTrackerHooks(false, this.cancelled);
            }
            return !this.cancelled;
        }
    }

    boolean processEvent(long l) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, l, (long)GdkEvent.sizeof);
        long l2 = OS.gtk_get_event_widget(l);
        switch (gdkEvent.type) {
            case 3: {
                this.gtk_motion_notify_event(l2, l);
                break;
            }
            case 7: {
                this.gtk_button_release_event(l2, l);
                break;
            }
            case 8: {
                this.gtk_key_press_event(l2, l);
                break;
            }
            case 9: {
                this.gtk_key_release_event(l2, l);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 10: 
            case 11: {
                break;
            }
            case 2: {
                this.update();
                if (!OS.GTK3) {
                    this.drawRectangles(this.rectangles);
                }
                OS.gtk_main_do_event(l);
                if (OS.GTK3) break;
                this.drawRectangles(this.rectangles);
                break;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.proportions = null;
        this.rectangles = null;
        this.bounds = null;
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(11, controlListener);
        this.eventTable.unhook(10, controlListener);
    }

    public void removeKeyListener(KeyListener keyListener) {
        this.checkWidget();
        if (keyListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(2, keyListener);
        this.eventTable.unhook(1, keyListener);
    }

    void resizeRectangles(int n, int n2) {
        Rectangle rectangle;
        int n3;
        if (this.bounds == null) {
            return;
        }
        if (this.parent != null && (this.parent.style & 0x8000000) != 0) {
            n *= -1;
        }
        if (n < 0 && (this.style & 0x4000) != 0 && (this.cursorOrientation & 0x20000) == 0) {
            this.cursorOrientation |= 0x4000;
        }
        if (n > 0 && (this.style & 0x20000) != 0 && (this.cursorOrientation & 0x4000) == 0) {
            this.cursorOrientation |= 0x20000;
        }
        if (n2 < 0 && (this.style & 0x80) != 0 && (this.cursorOrientation & 0x400) == 0) {
            this.cursorOrientation |= 0x80;
        }
        if (n2 > 0 && (this.style & 0x400) != 0 && (this.cursorOrientation & 0x80) == 0) {
            this.cursorOrientation |= 0x400;
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            if (n > this.bounds.width) {
                if ((this.style & 0x20000) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x20000;
                this.cursorOrientation &= 0xFFFFBFFF;
                this.bounds.x += this.bounds.width;
                n -= this.bounds.width;
                this.bounds.width = 0;
                if (this.proportions.length > 1) {
                    for (n3 = 0; n3 < this.proportions.length; ++n3) {
                        rectangle = this.proportions[n3];
                        rectangle.x = 100 - rectangle.x - rectangle.width;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x20000) != 0 && this.bounds.width < -n) {
            if ((this.style & 0x4000) == 0) {
                return;
            }
            this.cursorOrientation |= 0x4000;
            this.cursorOrientation &= 0xFFFDFFFF;
            n += this.bounds.width;
            this.bounds.width = 0;
            if (this.proportions.length > 1) {
                for (n3 = 0; n3 < this.proportions.length; ++n3) {
                    rectangle = this.proportions[n3];
                    rectangle.x = 100 - rectangle.x - rectangle.width;
                }
            }
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            if (n2 > this.bounds.height) {
                if ((this.style & 0x400) == 0) {
                    return;
                }
                this.cursorOrientation |= 0x400;
                this.cursorOrientation &= 0xFFFFFF7F;
                this.bounds.y += this.bounds.height;
                n2 -= this.bounds.height;
                this.bounds.height = 0;
                if (this.proportions.length > 1) {
                    for (n3 = 0; n3 < this.proportions.length; ++n3) {
                        rectangle = this.proportions[n3];
                        rectangle.y = 100 - rectangle.y - rectangle.height;
                    }
                }
            }
        } else if ((this.cursorOrientation & 0x400) != 0 && this.bounds.height < -n2) {
            if ((this.style & 0x80) == 0) {
                return;
            }
            this.cursorOrientation |= 0x80;
            this.cursorOrientation &= 0xFFFFFBFF;
            n2 += this.bounds.height;
            this.bounds.height = 0;
            if (this.proportions.length > 1) {
                for (n3 = 0; n3 < this.proportions.length; ++n3) {
                    rectangle = this.proportions[n3];
                    rectangle.y = 100 - rectangle.y - rectangle.height;
                }
            }
        }
        if ((this.cursorOrientation & 0x4000) != 0) {
            this.bounds.x += n;
            this.bounds.width -= n;
        } else if ((this.cursorOrientation & 0x20000) != 0) {
            this.bounds.width += n;
        }
        if ((this.cursorOrientation & 0x80) != 0) {
            this.bounds.y += n2;
            this.bounds.height -= n2;
        } else if ((this.cursorOrientation & 0x400) != 0) {
            this.bounds.height += n2;
        }
        Rectangle[] rectangleArray = new Rectangle[this.rectangles.length];
        for (int i = 0; i < this.rectangles.length; ++i) {
            Rectangle rectangle2 = this.proportions[i];
            rectangleArray[i] = new Rectangle(rectangle2.x * this.bounds.width / 100 + this.bounds.x, rectangle2.y * this.bounds.height / 100 + this.bounds.y, rectangle2.width * this.bounds.width / 100, rectangle2.height * this.bounds.height / 100);
        }
        this.rectangles = rectangleArray;
    }

    public void setCursor(Cursor cursor) {
        this.checkWidget();
        this.cursor = cursor;
    }

    public void setRectangles(Rectangle[] rectangleArray) {
        this.checkWidget();
        if (rectangleArray == null) {
            this.error(4);
        }
        int n = rectangleArray.length;
        this.rectangles = new Rectangle[n];
        for (int i = 0; i < n; ++i) {
            Rectangle rectangle = rectangleArray[i];
            if (rectangle == null) {
                this.error(4);
            }
            this.rectangles[i] = new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.proportions = this.computeProportions(rectangleArray);
    }

    public void setStippled(boolean bl) {
        this.checkWidget();
        this.stippled = bl;
    }

    void ungrab() {
        if (this.grabbed) {
            this.gdk_pointer_ungrab(this.window, 0);
        }
    }

    void update() {
        if (this.parent != null) {
            if (this.parent.isDisposed()) {
                return;
            }
            this.parent.getShell().update();
        } else {
            this.display.update();
        }
    }
}

