/*
 * Decompiled with CFR 0.152.
 */
package de.qfs.lib.log;

import de.qfs.lib.log.LevelAwareLogBuilder;
import de.qfs.lib.log.Logger;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QFLogger
extends Logger {
    private boolean initialized = true;
    private boolean checkMethod = false;
    private Map<String, Logger> methodLoggers;

    public QFLogger(Class<?> clazz) {
        this(clazz.getName(), false);
    }

    public QFLogger(Object object) {
        this(object.getClass().getName(), false);
    }

    public QFLogger(String string) {
        this(string, false);
    }

    public QFLogger(String string, boolean bl) {
        super(string);
        this.setCheckMethod(bl);
    }

    public void setCheckMethod(boolean bl) {
        this.checkMethod = bl;
        this.setLevel(this.level);
    }

    public LevelAwareLogBuilder lvlBuild(int n, String string) {
        return this.lvlBuild(n, string, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LevelAwareLogBuilder lvlBuild(int n, String string, int n2) {
        boolean bl = false;
        boolean bl2 = false;
        if (this.checkMethod) {
            QFLogger qFLogger = this;
            synchronized (qFLogger) {
                int n3;
                if (this.methodLoggers == null) {
                    this.methodLoggers = new HashMap<String, Logger>();
                }
                Logger logger = this.methodLoggers.get(string);
                String string2 = null;
                if (logger == null) {
                    string2 = string;
                    n3 = string2.indexOf("(");
                    if (n3 > 0) {
                        string2 = string2.substring(0, n3);
                    }
                    if ((logger = this.methodLoggers.get(string2)) == null) {
                        logger = new Logger(this.getOwnerName() + "_mtd." + string2);
                        this.methodLoggers.put(string2, logger);
                    }
                    this.methodLoggers.put(string, logger);
                }
                boolean bl3 = bl = QFLogger.getLogLevel(logger) < n;
                if (!bl) {
                    logger = this.methodLoggers.get("_dmp." + string);
                    if (logger == null) {
                        if (string2 == null && (n3 = (string2 = string).indexOf("(")) > 0) {
                            string2 = string2.substring(0, n3);
                        }
                        if ((logger = this.methodLoggers.get("_dmp." + string2)) == null) {
                            logger = new Logger(this.getOwnerName() + "_dmp." + string2);
                            this.methodLoggers.put("_dmp." + string2, logger);
                        }
                        this.methodLoggers.put("_dmp." + string, logger);
                    }
                    bl2 = QFLogger.getLogLevel(logger) >= n;
                }
            }
        }
        return new LevelAwareLogBuilder(this, n, string, n2, bl, bl2);
    }

    @Override
    public void setLevel(int n) {
        super.setLevel(n);
        if (!this.initialized) {
            return;
        }
        String string = this.getOwnerName() + "_mtd.";
        boolean bl = false;
        Object[] objectArray = QFLogger.getLogLevels();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (!string.equals(objectArray[i])) continue;
            bl = true;
            break;
        }
        if (this.checkMethod) {
            if (!bl) {
                QFLogger.setLogLevel(string, 10);
            }
        } else if (bl) {
            this.checkMethod = true;
        }
    }

    public QFLogger setMethodLevel(String string, int n) {
        int n2;
        if (!this.checkMethod) {
            this.setCheckMethod(true);
        }
        if ((n2 = string.lastIndexOf("(")) > 0) {
            string = string.substring(0, n2);
        }
        QFLogger.setLogLevel(this.getOwnerName() + "_mtd." + string, n);
        return this;
    }
}

