package de.qfs.apps.qftest.demo;

//{{{ copyright

/********************************************************************
*
* Copyright (C) 2004 Gregor Schmid, Quality First Software
* All rights reserved
*
*******************************************************************/

//}}}

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCParams;

/**
* Sample JUnit Tests for CarConfigurator - Swing.
*
* @author QFS, mm, dr
*/
public class CarConfiguratorTests
{

    public static String buggyMode = null;

    @Test
    public void isStandardUser()
    {
        CCModel model = CCModel.getInstance();
        CCControllerSwing c = new CCControllerSwing(model);
        model.setM_params(CCParams.builder().build());

        model.getM_params().setUser("tester");
        assertTrue(c.isStandardUser());
    }

    @Test
    public void isNoStandardUser()
    {
        CCModel model = CCModel.getInstance();
        CCControllerSwing c = new CCControllerSwing(model);
        model.setM_params(CCParams.builder().build());

        model.getM_params().setUser("myuser");
        assertFalse(c.isStandardUser());
    }

    @Test
    public void calculatePriceOk()
    {
        CCModel model = CCModel.getInstance();
        CCControllerSwing c = new CCControllerSwing(model);
        model.setM_params(CCParams.builder().build());

        model.getM_params().setBuggy(buggyMode == null ? false : Boolean.parseBoolean(buggyMode));
        double result_price = c.calculatePriceOk(29000, 500, 250, 0, 0, 0);
        double expected_price = 29750.0;
        assertEquals(expected_price, result_price, 0);
    }

}
