// {{{ copyright

/********************************************************************
 *
 * Copyright (C) 2004 Gregor Schmid, Quality First Software
 * All rights reserved
 *
 *******************************************************************/

// }}}

package de.qfs.apps.qftest.demo.fx.carconfig.liveunittests;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerFX;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCParams;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel.CCVehicle;

import javafx.scene.control.TableView;

/**
 * Sample Live JUnit Tests for CarConfigurator - JavaFX.
 * You need to set the table, the expected price and the desired discount from QF-Test using injections.
 *
 * @author QFS, mm
 */
public class LiveTestsCarConfigFX
{

    static TableView<CCVehicle> vehiclesView;

    static String expectedPrice;

    static String discount;

    static String buggyMode = null;

    @Test
    public void testCalculatePriceOk()
    {
        CCModel model = CCModel.getInstance();
        CCControllerFX c = new CCControllerFX(model);
        model.setM_params(CCParams.builder().build());
        
        CCVehicle testVehicle = vehiclesView.getSelectionModel().getSelectedItem();
        Double vehiclePrice = testVehicle.getPrice();
        model.getM_params().setBuggy(buggyMode == null ? false : Boolean.parseBoolean(buggyMode));

        double result_price = c.calculatePriceOk(vehiclePrice, 0, 0, 0, 0, Double.parseDouble(discount));       

        assertEquals(Double.parseDouble(expectedPrice), result_price, 0);
    }

}
