//{{{ copyright

/********************************************************************
*
* Copyright (C) 2004 Gregor Schmid, Quality First Software
* All rights reserved
*
*******************************************************************/

//}}}

package de.qfs.apps.qftest.demo.liveunit;

import static org.junit.Assert.assertEquals;

import javax.swing.JTable;

import org.junit.Test;

import de.qfs.apps.qftest.demo.multi.carconfigurator.controller.CCControllerSwing;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCModel;
import de.qfs.apps.qftest.demo.multi.carconfigurator.model.CCParams;

/**
* Sample Live JUnit Tests for CarConfigurator - Swing.
* You need to set the table, the expected price and the desired discount from QF-Test using injections.
*
* @author QFS, mm, dr
*/

public class LiveTestsCarConfig
{

    static JTable vehiclesTable;

    static String expectedPrice;

    static String discount;

    static String buggyMode = null;

    @Test
    public void testCalculatePriceOk()
    {
        CCModel model = CCModel.getInstance();
        CCControllerSwing c = new CCControllerSwing(model);
        model.setM_params(CCParams.builder().build());
        
        model.getM_params().setBuggy(buggyMode == null ? false : Boolean.parseBoolean(buggyMode));

        int selRow = vehiclesTable.getSelectedRow();
        Double vehiclePrice = (Double) vehiclesTable.getValueAt(selRow, 2);

        double result_price = c.calculatePriceOk(vehiclePrice, 0, 0, 0, 0, Double.parseDouble(discount));

        assertEquals(Double.parseDouble(expectedPrice), result_price, 0);
    }

}
