<?xml version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
		version="1.0">
  <!--
  Identity transformation for XML documents
  -->

  <xsl:output method="xml" encoding="ISO-8859-1" indent="yes"/>

  <!--  Default for non-nodes: copy everything -->
  <xsl:template match="@* | comment() | processing-instruction()">
    <xsl:copy/>
  </xsl:template>

  <!--  Default for nodes: do nothing -->
  <!-- <xsl:template match="*"/> -->

  <!-- {{{ root element -->

  <!--  Copy the DOCTYPE comment into a DOCTYPE declaration (XSLT FAQ) -->
  <xsl:template match="/">
    <RootStep name="root" version="1.7.0">
      <PackageRoot id="_2">
	<xsl:apply-templates select="@*|*|processing-instruction()|comment()"/>
      </PackageRoot>
      <ExtraSequence/>
      <WindowList/>
    </RootStep>
  </xsl:template>

  <!--  Copy the DOCTYPE comment into a DOCTYPE declaration (XSLT FAQ) -->
  <xsl:template match="//comment()[contains(.,'DOCTYPE')
		                   and (contains(.,'PUBLIC ')
		                        or contains(.,'SYSTEM '))][1]"
		mode="doctype">
    <xsl:value-of disable-output-escaping="yes" select="."/>
  </xsl:template>

  <!-- }}} -->

  <xsl:template match="element[@type='subdivision']">
    <Package>
      <xsl:attribute name="name">
	<xsl:value-of select="name"/>
      </xsl:attribute>
      <xsl:apply-templates select="element"/>
    </Package>
  </xsl:template>

  <xsl:template match="element[@type='interaction']">
    <Procedure>
      <xsl:attribute name="name">
		<xsl:value-of select="name"/>
      </xsl:attribute>
      <comment>
	<xsl:apply-templates select="description" mode="comment"/>
	<xsl:if test="parameters/parameter">
	  <xsl:text>&#x0a;</xsl:text>
	  <xsl:apply-templates select="parameters/parameter" mode="comment"/>
	</xsl:if>

      </comment>

      <xsl:apply-templates select="parameters/parameter"/>
      <xsl:apply-templates select="call-sequence/interaction-call"/>
    </Procedure>
  </xsl:template>

  <xsl:template match="parameter">
    <variable name="{name}">
    </variable>
  </xsl:template>
 

  <xsl:template match="interaction-call">
    <xsl:variable name="pk" select="interaction-ref/@pk" />
	<xsl:variable name="ia" select="//element[@type='interaction' and pk=$pk]" />
	<xsl:variable name="fullname">
		<xsl:for-each select="$ia/ancestor::element[@type='subdivision']"><xsl:value-of select="name" />.</xsl:for-each><xsl:value-of select="interaction-name" />
	</xsl:variable>
    <ProcedureCall>
  	  <xsl:attribute name="procedure">
	    <xsl:value-of select="$fullname" />
	  </xsl:attribute>
	  <xsl:apply-templates select="parameter-values/call-parameter"/>
	</ProcedureCall>
  </xsl:template>

<xsl:template match="call-parameter">
    <variable name="{parent-parameter-name}">    
    </variable>
  </xsl:template>

  <xsl:template match="description" mode="comment">
    <xsl:apply-templates select="."/>
  </xsl:template>

  <xsl:template match="parameter" mode="comment">
    <xsl:text>&#x0a;@param&#x09;</xsl:text>
    <xsl:apply-templates select="name"/>
    <xsl:text>&#x09;</xsl:text>
    <xsl:apply-templates select="datatype-name"/>
  </xsl:template>

</xsl:stylesheet>
