/********************************************************************
 *
 * $Id: CarConfigurator, v 2.0 2023/08/02
 *
 * Copyright (C) 2023 Quality First Software
 * All rights reserved
 *
 * Author: Beata Pazmany
 *******************************************************************/

/*
 * general methods
 */

function getUrlParam(key, defaultValue, uristring) {
        var keyUppercase = key.toUpperCase();
        var uristringUppercase = uristring.toUpperCase();
        var index = uristringUppercase.indexOf("&" + keyUppercase + "=");
        if (index == -1) {
                index = uristringUppercase.indexOf("?" + keyUppercase + "=");
        }
        if (index == -1) {
                return defaultValue;
        }
        // We have to start from the index, first "&" or "?", then the key and then the "=".
        // Means we have to skip keylength + 2 to get behind the "=".
        var value = uristring.substring(index + key.length + 2);
        if (value.indexOf("&") != -1) {
                // We have other parameters -> Use everything before it.
                console.log(key + " - Return &-> " + value.substring(0, value.indexOf("&")));
                return value.substring(0, value.indexOf("&"));
        } else {
                console.log(key + " - Return value-> " + value);
                return value;
        }
}

function getCurrentBrowserUrlParam(key, defaultValue) {
        var uristring = decodeURI(window.location.search);
        return getUrlParam(key, defaultValue, uristring);
}

function initVehicleNames() {
        // @var languagepointer from language.js
        var lang = languagepointer == 1 ? "de" : "en"

        var vehicles_data = carconfig_data.data.vehicles;
        vehicleNames = vehicles_data.map(function(i) {return i.name});
        vehicleID = vehicles_data.map(function(i) {return i.id});
        vehicle_price = vehicles_data.map(function(i) {return i.price});

        var accessories_data = carconfig_data.data.accessories;
        accessory_name = accessories_data.map(function(i) {return i["name_" + lang]});
        accessory_price = accessories_data.map(function(i) {return i.price});
        accessory_id = accessories_data.map(function(i) {return i.id});

        var specials_data = carconfig_data.data.specials;
        vehicle_specialmodel_name = specials_data.map(function(i) {return i["name_" + lang]});
        vehicle_specialmodel_desc = specials_data.map(function(i) {return i["desc_" + lang]});
        vehicle_specialmodel_price = specials_data.map(function(i) {return i.price});
        vehicle_specialmodel_extra = specials_data.map(function(el) {
            // transform data to legacy format like
            // ["", "xS1xxS3xxS5x", "xS2x", "xS1xxS2xxS7x"]
            if (el.acs === "") { return ""; }
            var result = "";
            for (let i = 0; i < el.acs.length; i++) {
                if (el.acs[i] === " ") {
                    result += "xx";
                } else if (/\d/.test(el.acs[i])) {
                    result += Number(el.acs[i]) - 1;
                } else {
                    result += el.acs[i];
                }
            }
            return "x" + result + "x";
        });
}
