/********************************************************************
 *
 * $Id: CarConfigurator, v 1.1 2012/03/20 16:01:28
 *                       v 2.0 2023/08/02
 *
 * Copyright (C) 2012 Quality First Software
 * All rights reserved
 *
 * Author: Yann Spoeri, Beata Pazmany
 *******************************************************************/

/*
 * Logic Calculations for Prices etc.
 */

// {{{ vars for the selectable data as vehicle, accessory etc.

// standard Vehicl, Special and Accessory cossts



  var vehicleNames = Array();
  var vehicleID = Array();
  var vehicle_price = Array();
  var vehicle_specialmodel_name = Array();
  var vehicle_specialmodel_desc = Array();
  var vehicle_specialmodel_extra = Array();
  var vehicle_specialmodel_price = Array();
  var accessory_name = Array();
  var accessory_price = Array();
  var accessory_id = Array();

initVehicleNames()

// }}}

// {{{ vars that specificate the selected items

// input data
var selectedvehicle = 0, selectedspecial = 0, selectedaccesso = "", thecar_discount = 0;

// }}}

// {{{ price calcing function

// calcint the cars price
var price_vehicle, price_special, price_extra, extra_count, price_total;

// calc the price of the car
function calc_price_vars() {
  price_vehicle = (selectedvehicle - 1 == -1) ? 0 : vehicle_price[selectedvehicle - 1];
  //BUG: In buggy mode any price smaller 29000 will be ignored
  if (buggyVersion == true && price_vehicle <= 29000) {
      price_vehicle = 0;
  }

  price_special = vehicle_specialmodel_price[selectedspecial];
  price_extra = 0;
  extra_count = 0;
  // some accessory may be contained in the selected model
  for (var i = 0; i < accessory_price.length && document.getElementById('AddAccessoryPriceChkbox').checked == true; i++) {
    if (selectedaccesso.indexOf("xS" + i + "x") != -1) {
      if (vehicle_specialmodel_extra[selectedspecial].indexOf("xS" + i + "x") == -1) {
        if (buggyVersion == true && parseInt(accessory_id[i].substring(1)) % 3 == 0) {
          extra_count--;
        }
        extra_count++;
        price_extra += accessory_price[i];
      }
    }
  }
  // calc total price
  price_total = (price_vehicle + price_special + price_extra) / 100 * (100 - thecar_discount);
}

// }}}

// {{{ format outputing

// for outputing in the dddd.dd -format
function round(nr) {
  // if(nr == undefined) return "0.00";

  var dummy = nr.toFixed(2);
  //
  var beforeDot = Math.floor(nr);
  var beforeDotString = beforeDot.toString();
  //
  var dummyString = dummy.toString();
  var afterDot = dummyString.substr(dummyString.lastIndexOf(".") + dummyString.lastIndexOf(",") + 2);
  //
  var beforeDotFormatString = "";
  while (beforeDotString.length != 0) {
    var dump = beforeDotString.substr((beforeDotString.length - 3 > 0) ? beforeDotString.length - 3 : 0);
    beforeDotString = beforeDotString.substr(0, beforeDotString.length - 3);
    if (setlanguage == "EN") {
      beforeDotFormatString = "," + dump + beforeDotFormatString;
    } else {
      beforeDotFormatString = "." + dump + beforeDotFormatString;
    }
  }
  beforeDotFormatString = beforeDotFormatString.substr(1);
  //
  if (setlanguage == "EN") {
    return beforeDotFormatString + "." + afterDot;
  }
  return beforeDotFormatString + "," + afterDot;
}

// }}}

// {{{ updating

// this function updates all elements when something is changed by the user
function updateCalculatorPane() {
  if (startup) return;
  calc_price_vars();
  document.getElementById('BasePrice_input').innerHTML = formatPriceForLanguage(round(price_vehicle));
  document.getElementById('DiscountValue_input').value = thecar_discount;
  document.getElementById('SpecialPrice_input').innerHTML = formatPriceForLanguage(round(price_special));
  document.getElementById('AccessoryPrice_input').innerHTML = formatPriceForLanguage(round(price_extra));
  document.getElementById('CalculatedPrice_input').innerHTML = formatPriceForLanguage(round(price_total));
}

function updateAllPanels() {
  printVehicleTable();
  SpecialComboUpdate();
  document.getElementById('SpecialsCombo').selectedIndex = selectedspecial;
  change_special();
  AccessoryTableUpdate();
  updateCalculatorPane();
  updateAboutVersion();
}

function updateAboutVersion() {
 var srcPath = "include/carConfigNew.png"
 if (buggyVersion) {
    srcPath = "include/carConfigAbout_faulty_a11y.png"
 }
 document.getElementById("InfoIcon").setAttribute("src", srcPath);
}
// }}}

// {{{useful functions

// is the number an Integer
function isNr(nr) {
  return !isNaN(parseFloat(nr));
}

// useful array functions
function deleteElement(arr, index) {              // arr is the array, index is the pointer to the element that is to be removed
  var dummy = Array();
  for (var i = 0; i < arr.length; i++) {
    if (i != index) {
      dummy.push(arr[i]);
    }
  }
  return dummy;
}

// useful delete accesso function
function deleteAccessoIndex(str, index) {
  var dummy = "";
  var splitstr = str.split("x");
  for (var i = 0; i < splitstr.length; i++) {
    if (splitstr[i].charAt(0) == "S") {
      var nr = parseFloat(splitstr[i].substr(1));
      if (nr == index) continue;
      if (index < nr) {
        nr--;
      }
      dummy += "xS" + nr + "x";
    }
  }
  return dummy;
}

function cloneObj(obj) {
  return obj;
}

function cloneArray(arr) {
  var newArr = new Array();
  for (var i = 0; i < arr.length; i++) {
    newArr.push(cloneObj(arr[i]));
  }
  return newArr;
}

   // }}}