/********************************************************************
 *
 * $Id: CarConfigurator, v 1.1 2012/03/20 16:01:28
 *                       v.2.0 2023/08/02
 *
 * Copyright (C) 2012 Quality First Software
 * All rights reserved
 *
 * Author: Yann Spoeri, Beata Pazmany
 *******************************************************************/

/*
 * Methods for the menubar
 */

// {{{ menubar open and closing function

function closeAllMenuBars() {
    mFileClose();
    mOptionsClose();
    mOrderClose();
    mHelpClose();
}

var dummyvarformyFileClick = false;
function mFileClick() {
    if (dummyvarformyFileClick) {
        mFileClose();
    } else {
        mFileOpen();
    }
}
function mFileOpen() {
    dummyvarformyFileClick = true;
    document.getElementById('mFile').getElementsByTagName('ul')[0].style.display = "block";
    mOptionsClose();
    mOrderClose();
    mHelpClose();
}
function mFileClose() {
    dummyvarformyFileClick = false;
    document.getElementById('mFile').getElementsByTagName('ul')[0].style.display = "none";
}
function mFileMove() {
    if (dummyvarformyFileClick || dummyvarformyOptionsClick || dummyvarformyOrderClick || dummyvarformyHelpClick) {
        mFileOpen();
    }
}

function miResetClick() {
    initVehicleNames()
    closeAllMenuBars();
    selectedvehicle = 0; selectedspecial = 0; selectedaccesso = ""; thecar_discount = 0;
    updateAllPanels();
}


login = getCurrentBrowserUrlParam("LOGIN", false);
if (login == 1 || login == "true") {
    login = true;
}
console.log("Loginergebnis -> " + login)



function miLogoutClick() {
    miResetClick(); //reset everything
    $(function () {
        $('#LoginPanel').dialog('open');
    });
}

var dummyvarformyOptionsClick = false;
function mOptionsClick() {
    if (dummyvarformyOptionsClick) {
        mOptionsClose();
    } else {
        mOptionsOpen();
    }
}
function mOptionsOpen() {
    dummyvarformyOptionsClick = true;
    document.getElementById('mOptions').getElementsByTagName('ul')[0].style.display = "block";
    mFileClose();
    mOrderClose();
    mHelpClose();
}
function mOptionsClose() {
    dummyvarformyOptionsClick = false;
    document.getElementById('mOptions').getElementsByTagName('ul')[0].style.display = "none";
}
function mOptionsMove() {
    if (dummyvarformyFileClick || dummyvarformyOptionsClick || dummyvarformyOrderClick || dummyvarformyHelpClick) {
        mOptionsOpen();
    }
}

function miVehiclesClick() {
    closeAllMenuBars();
    $(function () {
        $('#VehiclesDialogPanel').dialog('open');
    });
}

function miSpecialsClick() {
    closeAllMenuBars();
    $(function () {
        $('#SpecialsTablePanel').dialog('open');
    });
}

function miAccessoriesClick() {
    closeAllMenuBars();
    $(function () {
        $('#AccessoryDialogPanel').dialog('open');
    });
}

var dummyvarformyOrderClick = false;
function mOrderClick() {
    if (dummyvarformyOrderClick) {
        mOrderClose();
    } else {
        mOrderOpen();
    }
}
function mOrderOpen() {
    dummyvarformyOrderClick = true;
    document.getElementById('mOrder').getElementsByTagName('ul')[0].style.display = "block";
    mFileClose();
    mOptionsClose();
    mHelpClose();
}
function mOrderClose() {
    dummyvarformyOrderClick = false;
    document.getElementById('mOrder').getElementsByTagName('ul')[0].style.display = "none";
}
function mOrderMove() {
    if (dummyvarformyFileClick || dummyvarformyOptionsClick || dummyvarformyOrderClick || dummyvarformyHelpClick) {
        mOrderOpen();
    }
}

function miViewOrderClick() {
    closeAllMenuBars();
    $(function () {
        $('#ViewPurchaseOrderPanel').dialog('open');
    });
}

function miSendOrderClick() {
    closeAllMenuBars();
    $(function () {
        $('#SendPurchaseOrderPanel').dialog('open');
    });
}

var dummyvarformyHelpClick = false;
function mHelpClick() {
    if (dummyvarformyHelpClick) {
        mHelpClose();
    } else {
        mHelpOpen();
    }
}
function mHelpOpen() {
    dummyvarformyHelpClick = true;
    document.getElementById('mHelp').getElementsByTagName('ul')[0].style.display = "block";
    mFileClose();
    mOptionsClose();
    mOrderClose();
}
function mHelpClose() {
    dummyvarformyHelpClick = false;
    document.getElementById('mHelp').getElementsByTagName('ul')[0].style.display = "none";
}
function mHelpMove() {
    if (dummyvarformyFileClick || dummyvarformyOptionsClick || dummyvarformyOrderClick || dummyvarformyHelpClick) {
        mHelpOpen();
    }
}

function miInfoClick() {
    closeAllMenuBars();
    $(function () {
        $('#InfoPanel').dialog('open');
    });
}


var buggyVersion = getCurrentBrowserUrlParam("BUGGY", false);
if (buggyVersion == "1" || String.prototype.toUpperCase.call(buggyVersion) == "TRUE") {
    buggyVersion = true;
}

function miBuggyClick() {
    closeAllMenuBars();
    if (buggyVersion) {
        document.getElementById('miBuggy_menu').innerHTML = getLanguageStringbyIdStr("miBuggy");
    } else {
        document.getElementById('miBuggy_menu').innerHTML = "&check; " + getLanguageStringbyIdStr("miBuggy");
    }
    buggyVersion = !buggyVersion;
    updateAllPanels();
}

var loadTestVersion = getCurrentBrowserUrlParam("LOADTEST", false);
if (loadTestVersion == "1" || String.prototype.toUpperCase.call(loadTestVersion) == "TRUE") {
    loadTestVersion = true;
}

function miLoadtestClick() {
    closeAllMenuBars();
    if (loadTestVersion == true) {
        document.getElementById('miLoadtest_menu').innerHTML = getLanguageStringbyIdStr("miLoadtest");
    } else {
        document.getElementById('miLoadtest_menu').innerHTML = "&check; " + getLanguageStringbyIdStr("miLoadtest");
    }
    loadTestVersion = !loadTestVersion;
    updateAllPanels();
}

var currentUser = getCurrentBrowserUrlParam("USER", "tester");
console.log("user: " + currentUser)


function showOrderMenu() {
    if (currentUser == "USER") {
        document.getElementById('mOrder').style.display = "none";
    }
}
 // }}}