sidx_dump={"version":"0.9.5","fields":["content","h-1","h0","h1","h2","h3","hash"],"ref":"id","documentStore":{"docs":{"0":{"id":0,"content":"Pro License Server","hash":"","h0":"Quickstart | QF‑Test License Server"},"1":{"id":1,"content":"Pro License Server","hash":"home-link","h0":"Quickstart | QF‑Test License Server"},"2":{"id":2,"content":"Quickstart This chapter provides short explanations and examples for quickly setting up a typical QF‑Test license server. The next two explain the usage of the command line interface in more detail and can be used as a reference. The last chapter shows you how to administer the license server via the graphical user interface. Inform Quality First Software GmbH about server data for license generation Define a dedicated host for the license server and a dedicated port on that machine for this service. Provide this information to Quality First Software GmbH for setting up the license files and make sure that firewalls are configured so that client machines can reach the host under the given name or IP address at the given port (\"License files\"). Install QF‑Test Unpack the QF‑Test archive (.tar.gz for Linux or -sfx.exe for Windows) in a convenient location. The directory named qftest is called QF‑Test's root directory. It contains a version-specific directory named qftest-x.y.z. QF‑Test needs write access to its root directory to store version-independent files there. When upgrading to a newer version, install to the same place in order to reuse those files (\"Prerequisites\"). License files Save the server and client license files named license.server and license, provided by Quality First Software GmbH, to QF‑Test's root directory (\"License files\"). Set the license server's password The default password for the QF‑Test license server is secret. It is a good idea to change it before starting the license server for the first time by defining a password for the license server administrator named admin and setting the administrator password by executing qftest -batch -licenseserver -licenseserver-setpwd <user>=<password> for <user> admin. You can always run QF‑Test directly from its bin directory by specifying the full path instead of just qftest. Start the license server Then you can then run the license server via qftest -batch -licenseserver Distribute the client license Provide the client license file called license to QF‑Test users that should get their license from the license server. The file should be saved in QF‑Test's root directory on the client. Measure license usage Current license usage can be monitored on the server machine or any client machine with a QF‑Test installation and the client license. Either start the license server admin GUI described in \"Interactive license server administration\" with qftest -licenseserver-admin and login as user admin with the password you defined or dump the current license use to stdout with one of the following commands: qftest -batch [-licenseserver-password <password>] -licenseserver-dump qftest -batch [-licenseserver-password <password>] -licenseserver-dumptotal Save the license server's password You can omit specifying -licenseserver-password <password> in the above commands by logging in once via the admin GUI and checking \"Remember password\" or by saving the administrator password for client side use via qftest -batch -licenseserver-setpwd <user>=<password> Stop the license server To stop the license server, either kill its process or run qftest -batch -licenseserver-shutdown","hash":"ls_quickstart","h0":"Quickstart"},"3":{"id":3,"content":"Pro License Server","hash":"","h0":"License server installation | QF‑Test License Server"},"4":{"id":4,"content":"Pro License Server","hash":"home-link","h0":"License server installation | QF‑Test License Server"},"5":{"id":5,"content":"License server installation","hash":"ls_installation","h0":"License server installation"},"6":{"id":6,"content":"Prerequisites Please always run the QF‑Test license server with its own Java. If you need to minimize space, e.g. for running the server inside a Docker container together with other applications, a current version of Java 21 should also work. The QF‑Test license server functionality is currently part of the main QF‑Test installation and not available as a separate package. Thus the installation is identical to the installation of QF‑Test itself, documented in the QF‑Test manual, chapter 1. It is possible, but not strictly necessary, to run the license server under a dedicated user account. For security reasons the \"root\" or \"Administrator\" accounts should not be used.","hash":"ls_preconditions","h1":"Prerequisites"},"7":{"id":7,"content":"License files Besides the usual information about numbers and kinds of licenses and GUI engines, two additional parameters are required for server and client licenses: The hostname or IP address of the license server and a dedicated port number reserved for the license server on this host. These must be provided to QFS for creating the server and client license files, and the server will be limited to running on the specified host and port. The QF‑Test license server requires a special server license that should be saved under the name \"license.server\" in the system directory of QF‑Test. On Windows, depending on the type of installation, this is %PROGRAMDATA%\\QFS\\QF‑Test or the root directory of your QF‑Test installation as it is on Linux. This license cannot be used on any other machine. A matching client license is needed to administrate the server. The client license is similar to a normal QF‑Test license and should be saved in the QF‑Test system directory and named license with no extension. QF‑Test instances that need to get their license from the server should use the client license in place of their normal license. One of the great advantages of the license server is that the client license is constant and does not need to be updated when the QF‑Test version changes or additional instances are added to the license. It is always possible to use a specific license via the command line argument -license <file>.","hash":"ls_licensefiles","h1":"License files"},"8":{"id":8,"content":"Pro License Server","hash":"","h0":"QF‑Test startup options for running or administrating the license server | QF‑Test License Server"},"9":{"id":9,"content":"Pro License Server","hash":"home-link","h0":"QF‑Test startup options for running or administrating the license server | QF‑Test License Server"},"10":{"id":10,"content":"QF‑Test startup options for running or administrating the license server For maximum flexibility the names of all QF‑Test arguments are case-insensitive and embedded '-', '_', '.' and ':' characters are ignored, so -licenseserver.logfile is equivalent to --licenseserverLogfile or -licenseserver-logfile. The latter is the officially documented form because it avoids conflicts with Windows PowerShell. The program qftest.exe is a Windows GUI application. When started from a command shell, it will not wait for QF‑Test to terminate but return immediately and you won't see any output from QF‑Test in the console window. For running the QF‑Test license server as a Windows service or autostart program this is fine. For running the license server from a Windows command shell you may prefer to utilize the qftestc.exe console application. It waits for QF‑Test to terminate and output will be displayed in the console window. Apart from that, everything said about qftest.exe in this chapter holds true for qftestc.exe too.","hash":"ls_startoptions","h0":"QF‑Test startup options for running or administrating the license server"},"11":{"id":11,"content":"Call syntax","hash":"sec_callsyntax","h1":"Call syntax"},"12":{"id":12,"content":"Server side operations The following commands apply to the license server. They must be run on the license server machine and require a server license. Starting the license server The license server is started as follows: qftest -batch [-dbg] [-java <executable>] [-noconsole] [-J<java argument>]* [-license <file>] [-licenseserver-logfile <file>] [-licenseserver-verbose <level>] [-option <name>=<value>] [-options <file>] -licenseserver Setting the administrator password for the license server To set the administrator password for the license server on the server side, use the following syntax for <user> admin: qftest -batch [-dbg] [-java <executable>] [-noconsole] [-J<java argument>]* [-license <file>] [-licenseserver-logfile <file>] [-licenseserver-verbose <level>] [-option <name>=<value>] [-options <file>] -licenseserver -licenseserver-setpwd <user>=<password>","hash":"sec_server_side_operations","h2":"Server side operations"},"13":{"id":13,"content":"Client side operations The following commands can be executed with QF‑Test on either the license server machine or a client machine. They require a client license matching the server. Stopping the license server To cleanly shut down the license server, use the following syntax: qftest -batch [-dbg] [-java <executable>] [-noconsole] [-J<java argument>]* [-license <file>] [-option <name>=<value>] [-options <file>] [-licenseserver-password <password>] -licenseserver-shutdown Saving the user's password for the license server By running this command once, the administrator password will be saved for the current user so that the command line argument -licenseserver-password <password> can be omitted in future calls: qftest -batch [-dbg] [-java <executable>] [-noconsole] [-J<java argument>]* [-license <file>] [-option <name>=<value>] [-options <file>] -licenseserver-setpwd <user>=<password> Currently the only username supported is admin. Getting detailed information about the current license usage You can get a list of all currently used licenses with the following command: qftest -batch [-dbg] [-java <executable>] [-noconsole] [-J<java argument>]* [-license <file>] [-option <name>=<value>] [-options <file>] [-licenseserver-password <password>] -licenseserver-dump The result is printed to standard output in comma-separated values (CSV) format including a header line. Getting summary information about the current license usage You can get a summary of the currently used licenses with the following command: qftest -batch [-dbg] [-java <executable>] [-noconsole] [-J<java argument>]* [-license <file>] [-option <name>=<value>] [-options <file>] [-licenseserver-password <password>] -licenseserver-dumptotal The result is printed to standard output in comma-separated values (CSV) format including a header line. The lines of data show the current license usage, the remaining unused licenses and the total available licenses. Getting summary information about peak license usage The QF‑Test license server internally tracks peak usage. You can get the values with the following command: qftest -batch [-dbg] [-java <executable>] [-noconsole] [-J<java argument>]* [-license <file>] [-option <name>=<value>] [-options <file>] [-licenseserver-password <password>] [-licenseserver-verbose <level>] -licenseserver-dumppeak The result is printed to standard output. If the log level -licenseserver-verbose <level> is VERBOSE or higher, the time at which the peak was reached is printed. If it is DETAIL, the individual leases causing the peak are listed as well. Interactive license server administration This command launches a dedicated license server administration GUI for interactive use. You can also open this window from an interactive QF‑Test instance via the menu »Extras«-»Administrate license server«. qftest [-dbg] [-java <executable>] [-J<java argument>]* [-license <file>] [-option <name>=<value>] [-options <file>] -licenseserver-admin","hash":"sec_client_side_operations","h2":"Client side operations"},"14":{"id":14,"content":"Command line arguments Command line arguments for QF‑Test fall in three categories.","hash":"sec_commandline","h1":"Command line arguments"},"15":{"id":15,"content":"Arguments for the starter script These arguments are evaluated directly by the qftest shell script or executable and override settings determined during installation. Under Linux these settings are stored in the file launcher.cfg in QF‑Test's root directory, under Windows they are stored in the registry.","hash":"sec_arguments_for_the_starter_script","h2":"Arguments for the starter script"},"16":{"id":16,"content":"-batch Run QF‑Test in batch mode. This is a required argument for the license server.","hash":"arg_batch","hp":"Arguments for the starter script","h4":"-batch"},"17":{"id":17,"content":"-dbg Turn on debugging output for the starter script. The same effect is achieved by setting the environment variable QFTEST_DEBUG to a non-empty value. On Windows this causes QF‑Test to open a console window to display the output that would otherwise be invisible unless the argument -noconsole is also given.","hash":"arg_dbg","hp":"Arguments for the starter script","h4":"-dbg"},"18":{"id":18,"content":"-java <executable> The Java executable used to run QF‑Test. The default is java on Linux and javaw.exe on Windows, unless a different value was set during installation.","hash":"arg_java","hp":"Arguments for the starter script","h4":"-java <executable>"},"19":{"id":19,"content":"-noconsole (Windows only) On Windows this argument suppresses the console window that would otherwise be opened in case -dbg is specified.","hash":"arg_noconsole","hp":"Arguments for the starter script","h4":"-noconsole (Windows only)"},"20":{"id":20,"content":"Arguments for the Java VM You can pass arguments to the Java VM through the starter script by prepending them with -J, e.g. -J-Duser.language=en to set a system property.","hash":"sec_arguments_for_the_java_vm","h2":"Arguments for the Java VM"},"21":{"id":21,"content":"Arguments for QF‑Test The rest of the arguments are handled by QF‑Test itself when it is executed by the Java virtual machine. These arguments can also be placed in a file using the syntax <name>=<value> for arguments with parameters or <name>=true or <name>=false to turn a simple argument on or off. By default this file is called qftest.options, located in the bin directory of QF‑Test and used only for internal logging purposes. If you change anything in this file, you can move it to QF‑Test's root directory so your changes will still apply after upgrading. Alternatively you can use the -options <file> argument to specify a different file. Arguments given on the command line override arguments from an option file except for those which can be given multiple times. In the latter case the arguments are merged.","hash":"sec_arguments_for_qf_test","h2":"Arguments for QF‑Test"},"22":{"id":22,"content":"-license <file> Set the location of the license file.","hash":"arg_license","hp":"Arguments for QF‑Test","h4":"-license <file>"},"23":{"id":23,"content":"-licenseserver Start QF‑Test in license server mode.","hash":"arg_licenseserver","hp":"Arguments for QF‑Test","h4":"-licenseserver"},"24":{"id":24,"content":"-licenseserver-admin Open the license server administration GUI.","hash":"arg_licenseserver.admin","hp":"Arguments for QF‑Test","h4":"-licenseserver-admin"},"25":{"id":25,"content":"-licenseserver-dump Print detailed information about the currently used licenses.","hash":"arg_licenseserver.dump","hp":"Arguments for QF‑Test","h4":"-licenseserver-dump"},"26":{"id":26,"content":"-licenseserver-dumptotal Print summary information about the currently used licenses.","hash":"arg_licenseserver.dumptotal","hp":"Arguments for QF‑Test","h4":"-licenseserver-dumptotal"},"27":{"id":27,"content":"-licenseserver-dumppeak Print information about peak license usage. If the log level defined with -licenseserver-verbose <level> is DETAIL, also print the individual leases that caused the peak usage.","hash":"arg_licenseserver.dumppeak","hp":"Arguments for QF‑Test","h4":"-licenseserver-dumppeak"},"28":{"id":28,"content":"-licenseserver-logfile <file> Write log messages to the specified file. The default log file is licenseserver.log in the log directory of QF‑Test, either under QF‑Test's system directory or the user directory. To suppress logging, use the argument with an empty value in the form -licenseserver.logfile=.","hash":"arg_licenseserver.logfile","hp":"Arguments for QF‑Test","h4":"-licenseserver-logfile <file>"},"29":{"id":29,"content":"-licenseserver-password <password> The password for connecting to the license server as the user admin. Can be omitted if the password was previously saved for the current user during interactive use or via the command line argument -licenseserver-setpwd <user>=<password>.","hash":"arg_licenseserver.password","hp":"Arguments for QF‑Test","h4":"-licenseserver-password <password>"},"30":{"id":30,"content":"-licenseserver-setpwd <user>=<password> Set a password for license server administration. Currently only one user named admin is supported. When run in license server mode, i.e. in combination with -licenseserver the command changes the password for the license server. In client mode it saves the password for the current user so that no login is required when opening the license server administration window and no password must be specified via -licenseserver-password <password> when performing client-side batch operations.","hash":"arg_licenseserver.setpwd","hp":"Arguments for QF‑Test","h4":"-licenseserver-setpwd <user>=<password>"},"31":{"id":31,"content":"-licenseserver-shutdown Cleanly shut down the license server.","hash":"arg_licenseserver.shutdown","hp":"Arguments for QF‑Test","h4":"-licenseserver-shutdown"},"32":{"id":32,"content":"-licenseserver-verbose <level> Set the log level for the license server. On the server side it determines how much detail is written to the log file specified with -licenseserver-logfile <file>. On the client side it determines how much detail to print for commands like -licenseserver-dumppeak. Supported values are numbers form 0 to 4 or the respective constants NOTHING, ERRORS, TERSE, VERBOSE, DETAIL. The default value is TERSE.","hash":"arg_licenseserver.verbose","hp":"Arguments for QF‑Test","h4":"-licenseserver-verbose <level>"},"33":{"id":33,"content":"-nomessagewindow In case of a fatal error in batch mode QF‑Test prints an error message to the console and for improved visibility also brings up an error dialog for about 30 seconds. That dialog can be suppressed with the help of this argument.","hash":"arg_nomessagewindow","hp":"Arguments for QF‑Test","h4":"-nomessagewindow"},"34":{"id":34,"content":"-option <name>=<value> Specifies options. -option <name>=<value> sets a value of the option with a name <name> to <value>. This argument can be given more than once to set several options.","hash":"arg_option","hp":"Arguments for QF‑Test","h4":"-option <name>=<value>"},"35":{"id":35,"content":"-options <file> Override the location of the file used to specify additional command line arguments. This argument can be given more than once to use several sources of command line arguments.","hash":"arg_options","hp":"Arguments for QF‑Test","h4":"-options <file>"},"36":{"id":36,"content":"-version Print version information and exit.","hash":"arg_version","hp":"Arguments for QF‑Test","h4":"-version"},"37":{"id":37,"content":"Pro License Server","hash":"","h0":"Interactive license server administration | QF‑Test License Server"},"38":{"id":38,"content":"Pro License Server","hash":"home-link","h0":"Interactive license server administration | QF‑Test License Server"},"39":{"id":39,"content":"Interactive license server administration","hash":"ls_gui","h0":"Interactive license server administration"},"40":{"id":40,"content":"Opening the administration window You can open the administration window in one of the two ways: Start via command line qftest -licenseserver-admin Start via QF‑Test client You can start the GUI admininstration at a client that gets its license from the license server via the menu item »Extras«-»License server administration...«. When the login dialog appears you can enter the user name (currently 'admin' only) and the password. Additionally you can check the box whether the password should be saved so that the login dialog will not appear again next time.","hash":"ls_start_gui","h1":"Opening the administration window"},"41":{"id":41,"content":"Figure 4.1: Login dialog The administration windows consists of a menu bar, an overview and a table showing the individual current or peak license usage. You can configure the GUI to show a status line as well.","hash":"figure_4.1","h4":"Figure 4.1: Login dialog"},"42":{"id":42,"content":"Figure 4.2: Administration window","hash":"figure_4.2","h4":"Figure 4.2: Administration window"},"43":{"id":43,"content":"Components of the administration window","hash":"ls_guihandling","h1":"Components of the administration window"},"44":{"id":44,"content":"Menu 'File' Menu item 'Close window' Closes the administration window.","hash":"ls_filemenu","h2":"Menu 'File'"},"45":{"id":45,"content":"Menu 'View' Menu item 'Show status line' You can activate or deactivate the menu item by clicking it. When it is ticked, i.e. activated, you will see an additional line for status information at the bottom part of the window. Menu item 'Update' »View«-»Update« requests the current license usage from the license server and updates the display. Alternatively you could press the button. Menu item 'Show engines' You can activate or deactivate the menu item by clicking it. When »View«-»Show engines« is not ticked, i.e. deactivated, only the sums of the developer and runtime licenses are displayed. When »View«-»Show engines« is ticked, the licenses shown in the overview and individual licenses tables are also listed per engine. This comes in handy when you have a server license valid for different numbers of licenses for the different types of engines. The image Current license usage with 'Show engines' activated at the beginning of the chapter Tables shows an example.","hash":"ls_displaymenu","h2":"Menu 'View'"},"46":{"id":46,"content":"Menu 'Extras' Menu item 'Update server license' You can update the server license currently in use via this menu item. The update process is described in detail in \"Update license server\".","hash":"ls_extrasmenu","h2":"Menu 'Extras'"},"47":{"id":47,"content":"Update every ... In the drop down list you can specify the interval (from 5 sec to 5 min) for requesting license usage data from the license server and an update of the display.","hash":"ls_UpdateAllButton","h2":"Update every ..."},"48":{"id":48,"content":"'Update' button requests the current license usage from the license server and updates the display.","hash":"ls_UpdateButton","h2":"'Update' button"},"49":{"id":49,"content":"Individual license data Above the table Individual license usage you will find a drop down list, where you can choose which data the table should display. Current usage Data showing the license usage of the individual QF‑Test clients currently started. Peak usage (development) Data showing the license usage of the individual clients at the time of maximum use of developer licenses since the license server was started last. Peak usage (runtime) Data showing the license usage of the individual clients at the time of maximus use of runtime licenses since the license server was started last.","hash":"ls_selectindividualdata","h2":"Individual license data"},"50":{"id":50,"content":"Tables","hash":"ls_gui_tables","h1":"Tables"},"51":{"id":51,"content":"Figure 4.3: Current license usage with 'Show engines' activated","hash":"ls_engines_shown_table","h4":"Figure 4.3: Current license usage with 'Show engines' activated"},"52":{"id":52,"content":"Overview In use Number of licenses of the respective type (development/runtime) currently in use by QF‑Test clients. Available This table row shows the number of development and runtime licenses currently available, including engine information if the menu option is set accordingly. The image above shows an example with two developer licenses, one of which is assigned to a QF‑Test client making use of all the engines availabe and the other to a QF‑Test client using all engines except Java FX. The license structure of the example allows only one instance of QF‑Test to work with a Java FX engine. The license structure for the runtime licenses is the same. However, the two runtime licenses are used by a daemon running two QF‑Test instances using only the web engine. Total This table row shows the total number of development and runtime licenses available. When the menu option is set accordingly it also show the respective numbers for the single engines. Peak usage (development) Total license usage at the time of maximum usage of development licenses since the last restart of the license server. Peak (runtime) Total license usage at the time of maximum usage of runtime licenses since the last restart of the license server.","hash":"ls_overviewtable","h2":"Overview"},"53":{"id":53,"content":"Individual license usage You can specify the kind of individual license data shown by selecting the respective option from the drop-down list Individual license data above the table. The table columns provide the following information: Development / Runtime The number of used development, respectively runtime licenses used by each connected QF‑Test client. User The name of the user running the QF‑Test client. Host The name of the host on which the QF‑Test client was started. IP Address The client's IP address. Started The time when the QF‑Test Client was started. AWT / JavaFX / SWT / Web Number of development licenses used for the respective engine by the QF‑Test client. You can show / hide these columns via the menu item »View«-»Show engines«. AWT/Rt / JavaFX/Rt / SWT/Rt / Web/Rt Number of runtime licenses used for the respective engine by the QF‑Test client. You can show / hide these columns via the menu item »View«-»Show engines«.","hash":"ls_individualtable","h2":"Individual license usage"},"54":{"id":54,"content":"Update license server The server license can be updated interactively via the administration window. This is done by selecting »Extras«-»Update server license«. The following dialog appears:","hash":"ls_update_server_license","h1":"Update license server"},"55":{"id":55,"content":"Figure 4.4: Update dialog The top part of the dialog shows the server license currently in use. In the bottom text field you can either paste the text of the license provided by Quality First Software GmbH or enter it automatically by selecting the license (update) file via the \"Select file\" button.","hash":"ls_updatedialog","h4":"Figure 4.4: Update dialog"},"56":{"id":56,"content":"Figure 4.5: Update dialog with new license When the license data has been entered into the bottom text field you can press the \"Update\" button. A message will come up informing you that the license update was successful. The license server is updated while it is running. It does not have to be restarted for the new license to become active. QF‑Test clients already connected are not affected by the license update. Newly started clients will run with the updated license.","hash":"figure_4.5","h4":"Figure 4.5: Update dialog with new license"},"57":{"id":57,"content":"Figure 4.6: License update confirmation The old license file gets backed up with the ending '.old' before the update is performed. The new license data are written to the current license file specified via -license <file>. After the update the license update file provided by Quality First Software GmbH is no longer needed.","hash":"figure_4.6","h4":"Figure 4.6: License update confirmation"},"58":{"id":58,"content":"Pro License Server","hash":"","h0":"Third party software | QF‑Test License Server"},"59":{"id":59,"content":"Pro License Server","hash":"home-link","h0":"Third party software | QF‑Test License Server"},"60":{"id":60,"content":"Third party software QF‑Test license server makes use of the following software: Bean Scripting Framework (BSF) Copyright © 1999 International Business Machines Corporation Distributed under the IBM Bean Scripting Framework (BSF) Distribution License (see doc/licenses/BSF). URL: https://commons.apache.org/proper/commons-bsf/ Cryptix Copyright © 1995, 1996, 1997, 1998, 1999, 2000 The Cryptix Foundation Limited. All rights reserved. Distributed under the Cryptix General License (see doc/licenses/Cryptix). URL: http://www.cryptix.org Eclipse Temurin Distributed under the GNU General Public License version 2 with Classpath Exception (see doc/licenses/GPL-2.0-with-classpath-exception). URL: https://adoptium.net/de/temurin/releases JIDE Common Layer Copyright © 2002 - 2009 JIDE Software, Inc, all rights reserved Distributed under the GNU General Public License version 2 with Classpath Exception (see doc/licenses/GPL-2.0-with-classpath-exception). URL: http://www.jidesoft.com/products/oss.htm Netty (Pepperdata fork) Copyright © 2011 The Netty Project Distributed under the Apache License, Version 2.0 (see doc/licenses/Apache-2.0). URL: https://github.com/pepperdata/netty TrueZIP Virtual File System API Copyright © 2005-2007 Schlichtherle IT Services Distributed under the Eclipse Public License - v 1.0 (see doc/licenses/EPL-1.0). URL: https://christian-schlichtherle.bitbucket.io/truezip","hash":"app_software","h0":"Third party software"}},"docInfo":{"0":{"content":3,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"1":{"content":3,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"2":{"content":352,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"3":{"content":3,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"4":{"content":3,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"5":{"content":3,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"6":{"content":69,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"7":{"content":139,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"8":{"content":3,"h-1":0,"h0":12,"h1":0,"h2":0,"h3":0,"hash":0},"9":{"content":3,"h-1":0,"h0":12,"h1":0,"h2":0,"h3":0,"hash":2},"10":{"content":103,"h-1":0,"h0":9,"h1":0,"h2":0,"h3":0,"hash":1},"11":{"content":2,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"12":{"content":87,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"13":{"content":301,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"14":{"content":12,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"15":{"content":33,"h-1":0,"h0":0,"h1":0,"h2":4,"h3":0,"hash":1},"16":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"17":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"18":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"19":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"20":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":4,"h3":0,"hash":1},"21":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"22":{"content":6,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"23":{"content":7,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"24":{"content":7,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"25":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"26":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"27":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"28":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"29":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"30":{"content":56,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"31":{"content":7,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"32":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"33":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"34":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"35":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"36":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"37":{"content":3,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"38":{"content":3,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"39":{"content":4,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"40":{"content":58,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"41":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"42":{"content":4,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"43":{"content":3,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"44":{"content":9,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"45":{"content":103,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"46":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"47":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"48":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"49":{"content":65,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"50":{"content":1,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"51":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"52":{"content":135,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"53":{"content":105,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"54":{"content":19,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"55":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"56":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"57":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"58":{"content":3,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"59":{"content":3,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"60":{"content":146,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1}},"length":61,"save":true},"index":{"content":{"root":{"0":{"docs":{"32":{"tf":1}},"df":1},"1":{"9":{"9":{"5":{"docs":{"60":{"tf":1}},"df":1},"6":{"docs":{"60":{"tf":1}},"df":1},"7":{"docs":{"60":{"tf":1}},"df":1},"8":{"docs":{"60":{"tf":1}},"df":1},"9":{"docs":{"60":{"tf":1.4142135623730951}},"df":1},"docs":{},"df":0},"docs":{},"df":0},"docs":{"6":{"tf":1}},"df":1,".":{"0":{"docs":{"60":{"tf":1.4142135623730951}},"df":1},"docs":{},"df":0}},"2":{"0":{"0":{"0":{"docs":{"60":{"tf":1}},"df":1},"2":{"docs":{"60":{"tf":1}},"df":1},"5":{"docs":{"60":{"tf":1}},"df":1},"7":{"docs":{"60":{"tf":1}},"df":1},"9":{"docs":{"60":{"tf":1}},"df":1},"docs":{},"df":0},"1":{"1":{"docs":{"60":{"tf":1}},"df":1},"docs":{},"df":0},"docs":{},"df":0},"1":{"docs":{"6":{"tf":1}},"df":1},"docs":{"60":{"tf":1.4142135623730951}},"df":1,".":{"0":{"docs":{"60":{"tf":2}},"df":1},"docs":{},"df":0}},"3":{"0":{"docs":{"33":{"tf":1}},"df":1},"docs":{},"df":0},"4":{"docs":{"32":{"tf":1}},"df":1,".":{"1":{"docs":{"41":{"tf":1}},"df":1},"2":{"docs":{"42":{"tf":1}},"df":1},"3":{"docs":{"51":{"tf":1}},"df":1},"4":{"docs":{"55":{"tf":1}},"df":1},"5":{"docs":{"56":{"tf":1}},"df":1},"6":{"docs":{"57":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"docs":{"47":{"tf":1.4142135623730951}},"df":1},"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{"0":{"tf":1},"1":{"tf":1},"3":{"tf":1},"4":{"tf":1},"8":{"tf":1},"9":{"tf":1},"37":{"tf":1},"38":{"tf":1},"58":{"tf":1},"59":{"tf":1}},"df":10,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":2},"7":{"tf":1},"53":{"tf":1},"55":{"tf":1},"57":{"tf":1}},"df":5}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"2":{"tf":1},"46":{"tf":1}},"df":2}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"10":{"tf":1.4142135623730951}},"df":1,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"%":{"docs":{},"df":0,"\\":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"s":{"docs":{},"df":0,"\\":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"20":{"tf":1}},"df":1}}}}},"j":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"60":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"6":{"tf":1}},"df":2}}}}}}}},"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"10":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"20":{"tf":1}},"df":1}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{"29":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"s":{"docs":{"45":{"tf":1},"56":{"tf":1}},"df":2}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"13":{"tf":2},"25":{"tf":1},"26":{"tf":1},"27":{"tf":1.4142135623730951},"32":{"tf":1},"33":{"tf":1},"36":{"tf":1}},"df":7}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951}},"df":2}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"6":{"tf":1},"7":{"tf":1}},"df":2}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1}},"df":1}}}}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"7":{"tf":1},"21":{"tf":1}},"df":3}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{"6":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"20":{"tf":1}},"df":1,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":3.7416573867739413},"12":{"tf":1.4142135623730951},"13":{"tf":3.4641016151377544},"29":{"tf":2},"30":{"tf":2.449489742783178},"40":{"tf":1.4142135623730951}},"df":6}}}}},"t":{"docs":{"55":{"tf":1}},"df":1}},"t":{"docs":{},"df":0,"h":{"docs":{"2":{"tf":1}},"df":1}},"r":{"docs":{},"df":0,"t":{"docs":{"6":{"tf":1},"45":{"tf":1},"55":{"tf":1}},"df":3,"i":{"docs":{"60":{"tf":1}},"df":1}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1},"21":{"tf":1}},"df":2}}}}},"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"6":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{"13":{"tf":2},"27":{"tf":1.4142135623730951},"41":{"tf":1},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}},"df":5}},"r":{"docs":{"45":{"tf":1}},"df":1,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"30":{"tf":1},"57":{"tf":1}},"df":2}}}}},"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"21":{"tf":1}},"df":1}}}},"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"60":{"tf":1.7320508075688772}},"df":1}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"0":{"tf":1},"1":{"tf":1},"2":{"tf":5.477225575051661},"3":{"tf":1},"4":{"tf":1},"5":{"tf":1},"6":{"tf":1.7320508075688772},"7":{"tf":4.58257569495584},"8":{"tf":1},"9":{"tf":1},"10":{"tf":1.7320508075688772},"12":{"tf":3},"13":{"tf":4.795831523312719},"16":{"tf":1},"22":{"tf":1.4142135623730951},"23":{"tf":1},"24":{"tf":1},"25":{"tf":1},"26":{"tf":1},"27":{"tf":1},"29":{"tf":1},"30":{"tf":2},"31":{"tf":1},"32":{"tf":1},"37":{"tf":1},"38":{"tf":1},"39":{"tf":1},"40":{"tf":1.7320508075688772},"41":{"tf":1},"45":{"tf":2.8284271247461903},"46":{"tf":1.7320508075688772},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"49":{"tf":3},"51":{"tf":1},"52":{"tf":3.7416573867739413},"53":{"tf":2.449489742783178},"54":{"tf":1.7320508075688772},"55":{"tf":1.7320508075688772},"56":{"tf":2.6457513110645907},"57":{"tf":2.449489742783178},"58":{"tf":1},"59":{"tf":1},"60":{"tf":2.6457513110645907}},"df":44,"e":{"docs":{},"df":0,".":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{"2":{"tf":1},"7":{"tf":1}},"df":2}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{"2":{"tf":3.3166247903554},"10":{"tf":1},"12":{"tf":2.6457513110645907},"13":{"tf":3.605551275463989},"23":{"tf":1},"24":{"tf":1},"25":{"tf":1},"26":{"tf":1},"27":{"tf":1.4142135623730951},"28":{"tf":1},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"31":{"tf":1},"32":{"tf":1.7320508075688772},"40":{"tf":1}},"df":15,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"28":{"tf":1}},"df":1,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1},"28":{"tf":1}},"df":2}}}}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1}},"df":1}}}}}}}}}}}}}}}}},"n":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"7":{"tf":1},"13":{"tf":2},"14":{"tf":1.4142135623730951},"21":{"tf":1},"29":{"tf":1},"35":{"tf":1.4142135623730951},"40":{"tf":1},"41":{"tf":1},"45":{"tf":1.4142135623730951}},"df":10},"u":{"docs":{},"df":0,"x":{"docs":{"2":{"tf":1},"7":{"tf":1},"15":{"tf":1},"18":{"tf":1}},"df":4}}},"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1},"60":{"tf":1}},"df":2}}},"s":{"docs":{},"df":0,"t":{"docs":{"13":{"tf":1.4142135623730951},"45":{"tf":1},"47":{"tf":1},"49":{"tf":1},"53":{"tf":1}},"df":5}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}},"df":3}},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"10":{"tf":1},"21":{"tf":1}},"df":2}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"13":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"f":{"docs":{},"df":0,"g":{"docs":{"15":{"tf":1}},"df":1}}}}}}}}}},"y":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"60":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"21":{"tf":1},"22":{"tf":1},"35":{"tf":1}},"df":4}}},"g":{"docs":{"2":{"tf":1},"13":{"tf":1},"21":{"tf":1},"27":{"tf":1},"28":{"tf":2},"32":{"tf":1.4142135623730951}},"df":6,"i":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1},"30":{"tf":1},"40":{"tf":1.4142135623730951},"41":{"tf":1}},"df":4}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1},"12":{"tf":1.4142135623730951},"28":{"tf":1},"32":{"tf":1}},"df":4}}}},"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"57":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951}},"df":4}}},"a":{"docs":{},"df":0,"s":{"docs":{"13":{"tf":1},"27":{"tf":1}},"df":2}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"0":{"tf":1},"1":{"tf":1},"2":{"tf":4},"3":{"tf":1},"4":{"tf":1},"5":{"tf":1},"6":{"tf":2},"7":{"tf":3.1622776601683795},"8":{"tf":1},"9":{"tf":1},"10":{"tf":1.7320508075688772},"12":{"tf":3},"13":{"tf":3},"16":{"tf":1},"23":{"tf":1},"24":{"tf":1},"29":{"tf":1},"30":{"tf":2},"31":{"tf":1},"32":{"tf":1.4142135623730951},"37":{"tf":1},"38":{"tf":1},"39":{"tf":1},"40":{"tf":1.4142135623730951},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1},"48":{"tf":1},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"55":{"tf":1},"56":{"tf":1},"58":{"tf":1},"59":{"tf":1},"60":{"tf":1}},"df":36,"'":{"docs":{"2":{"tf":1.4142135623730951}},"df":1}}},"i":{"docs":{},"df":0,"c":{"docs":{"2":{"tf":1},"10":{"tf":1},"60":{"tf":1}},"df":3}}}},"t":{"docs":{"2":{"tf":2},"12":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"17":{"tf":1},"18":{"tf":1},"20":{"tf":1},"22":{"tf":1},"30":{"tf":1},"32":{"tf":1},"34":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}},"df":11,"p":{"docs":{},"df":0,"w":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":1.4142135623730951},"12":{"tf":1},"13":{"tf":1},"29":{"tf":1},"30":{"tf":1}},"df":5}}}},"c":{"docs":{"47":{"tf":1}},"df":1,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"r":{"docs":{"6":{"tf":1}},"df":1}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"33":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"6":{"tf":1},"13":{"tf":1.4142135623730951}},"df":2}}},"e":{"docs":{"10":{"tf":1},"45":{"tf":1},"60":{"tf":2.449489742783178}},"df":3},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"34":{"tf":1},"35":{"tf":1}},"df":2}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"53":{"tf":1},"54":{"tf":1},"55":{"tf":1.4142135623730951}},"df":3}}}}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1}},"df":1}},"w":{"docs":{"2":{"tf":1},"13":{"tf":1},"41":{"tf":1.4142135623730951},"45":{"tf":2.449489742783178},"49":{"tf":1.7320508075688772},"51":{"tf":1},"52":{"tf":2},"53":{"tf":2},"55":{"tf":1}},"df":9,"n":{"docs":{"45":{"tf":1},"53":{"tf":1}},"df":2}}},"u":{"docs":{},"df":0,"t":{"docs":{"13":{"tf":1},"31":{"tf":1}},"df":2,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1},"13":{"tf":1},"31":{"tf":1}},"df":3}}}}}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1.4142135623730951},"15":{"tf":1}},"df":2}}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1.7320508075688772},"55":{"tf":1},"57":{"tf":1},"60":{"tf":1.7320508075688772}},"df":4}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{"35":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1}},"df":1}},"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"13":{"tf":1},"30":{"tf":1},"32":{"tf":1}},"df":3}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"19":{"tf":1},"28":{"tf":1},"33":{"tf":1}},"df":3}}}}}},"m":{"docs":{"45":{"tf":1}},"df":1,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"13":{"tf":1.7320508075688772},"26":{"tf":1}},"df":2}}}}},"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"56":{"tf":1}},"df":1}}}}}},"f":{"docs":{},"df":0,"x":{"docs":{},"df":0,".":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{"2":{"tf":1}},"df":1}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{"2":{"tf":1},"7":{"tf":1}},"df":2,"i":{"docs":{"2":{"tf":1.4142135623730951},"7":{"tf":1},"19":{"tf":1},"21":{"tf":1},"28":{"tf":1},"30":{"tf":1},"32":{"tf":1},"34":{"tf":1},"35":{"tf":1},"47":{"tf":1},"53":{"tf":1},"57":{"tf":1}},"df":12}},"a":{"docs":{},"df":0,"l":{"docs":{"7":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{"6":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"15":{"tf":1.4142135623730951}},"df":2}},"p":{"docs":{"2":{"tf":1.4142135623730951},"13":{"tf":1}},"df":2}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1.7320508075688772},"10":{"tf":1},"12":{"tf":1.4142135623730951},"23":{"tf":1},"40":{"tf":1.7320508075688772},"49":{"tf":1.7320508075688772},"53":{"tf":1.7320508075688772},"56":{"tf":1}},"df":8,"u":{"docs":{},"df":0,"p":{"docs":{"10":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1},"17":{"tf":1},"20":{"tf":1}},"df":3}}}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"13":{"tf":1.7320508075688772}},"df":1}}}}},"t":{"docs":{},"df":0,"u":{"docs":{"41":{"tf":1},"45":{"tf":1.4142135623730951}},"df":2}}},"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1}},"df":1}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"6":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"52":{"tf":1.4142135623730951}},"df":1}}}}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"17":{"tf":1},"52":{"tf":1}},"df":3}},"v":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":2},"7":{"tf":1.4142135623730951},"13":{"tf":1.4142135623730951},"29":{"tf":1},"30":{"tf":1},"40":{"tf":1}},"df":6}}},"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"12":{"tf":1.4142135623730951},"13":{"tf":1},"30":{"tf":1},"32":{"tf":1.4142135623730951}},"df":5}},"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"7":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1}},"df":1}}},"n":{"docs":{},"df":0,"c":{"docs":{"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951}},"df":2},"g":{"docs":{},"df":0,"l":{"docs":{"52":{"tf":1}},"df":1}}}},"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"7":{"tf":1.4142135623730951},"20":{"tf":1},"28":{"tf":1},"60":{"tf":1}},"df":4}}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"x":{"docs":{"11":{"tf":1},"12":{"tf":1},"13":{"tf":1},"21":{"tf":1}},"df":4}}}}},"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1.4142135623730951},"17":{"tf":1},"20":{"tf":1},"60":{"tf":1.4142135623730951}},"df":4}}}},"h":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"l":{"docs":{"60":{"tf":1}},"df":1,"e":{"docs":{},"df":0,".":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"w":{"docs":{},"df":0,"t":{"docs":{"53":{"tf":1}},"df":1,"/":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"53":{"tf":1}},"df":1}}}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"i":{"docs":{"2":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"2":{"tf":1.7320508075688772},"55":{"tf":1},"57":{"tf":1}},"df":3}}}}}},"f":{"docs":{"7":{"tf":1}},"df":1,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":2.8284271247461903},"6":{"tf":2.23606797749979},"7":{"tf":2.6457513110645907},"10":{"tf":2.449489742783178},"13":{"tf":1.7320508075688772},"14":{"tf":1},"16":{"tf":1},"17":{"tf":1},"18":{"tf":1},"21":{"tf":1.7320508075688772},"23":{"tf":1},"28":{"tf":1},"33":{"tf":1},"40":{"tf":1},"49":{"tf":1},"52":{"tf":2.23606797749979},"53":{"tf":2.449489742783178},"56":{"tf":1},"60":{"tf":1}},"df":19,"'":{"docs":{"2":{"tf":1.7320508075688772},"15":{"tf":1},"21":{"tf":1},"28":{"tf":1}},"df":4}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":3.1622776601683795},"12":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"15":{"tf":1},"40":{"tf":1}},"df":5,".":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{"10":{"tf":1.4142135623730951}},"df":1}},"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1}},"df":1}}}},"c":{"docs":{},"df":0,".":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{"10":{"tf":1.4142135623730951}},"df":1}}}},"_":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{"17":{"tf":1}},"df":1}}}}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1.4142135623730951},"6":{"tf":1},"10":{"tf":1},"45":{"tf":1}},"df":4}}}},"n":{"docs":{},"df":0,"g":{"docs":{"2":{"tf":1},"7":{"tf":1},"21":{"tf":1.4142135623730951},"30":{"tf":1}},"df":4}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"2":{"tf":1},"40":{"tf":1}},"df":2}}},"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"49":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{"13":{"tf":1.4142135623730951}},"df":1,"n":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":1.7320508075688772},"7":{"tf":1},"10":{"tf":1.4142135623730951},"12":{"tf":1},"13":{"tf":2.6457513110645907},"14":{"tf":1.4142135623730951},"21":{"tf":1},"29":{"tf":1},"30":{"tf":1},"32":{"tf":1},"35":{"tf":1.4142135623730951},"40":{"tf":1}},"df":12}}},"o":{"docs":{},"df":0,"n":{"docs":{"60":{"tf":1}},"df":1}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"30":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"43":{"tf":1}},"df":1}}},"e":{"docs":{"45":{"tf":1},"56":{"tf":1}},"df":2}},"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1},"41":{"tf":1}},"df":2}}},"r":{"docs":{},"df":0,"m":{"docs":{"57":{"tf":1}},"df":1}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1}},"df":1}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{"2":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1},"6":{"tf":1}},"df":2}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1},"32":{"tf":1}},"df":2}}}},"o":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1.7320508075688772},"17":{"tf":1},"19":{"tf":1},"33":{"tf":1}},"df":4}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"41":{"tf":1}},"df":1}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"29":{"tf":1},"53":{"tf":1},"56":{"tf":1}},"df":3}}}}},"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"n":{"docs":{"53":{"tf":1.7320508075688772}},"df":1}}}},"p":{"docs":{},"df":0,"y":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"60":{"tf":2.23606797749979}},"df":1}}}}}}},"r":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"60":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":2.8284271247461903},"7":{"tf":2.449489742783178},"13":{"tf":1.7320508075688772},"30":{"tf":1.4142135623730951},"32":{"tf":1},"40":{"tf":1.4142135623730951},"49":{"tf":1.7320508075688772},"52":{"tf":1.7320508075688772},"53":{"tf":2.449489742783178},"56":{"tf":1.4142135623730951}},"df":10,"'":{"docs":{"53":{"tf":1}},"df":1}}}},"c":{"docs":{},"df":0,"k":{"docs":{"45":{"tf":1.4142135623730951}},"df":1}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"13":{"tf":1},"31":{"tf":1}},"df":2}}}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"44":{"tf":1.4142135623730951}},"df":1}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"60":{"tf":2}},"df":1}}}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"2":{"tf":1.4142135623730951},"11":{"tf":1},"13":{"tf":1},"21":{"tf":1}},"df":4}},"s":{"docs":{},"df":0,"e":{"docs":{"10":{"tf":1},"19":{"tf":1},"21":{"tf":1},"33":{"tf":1}},"df":4}},"u":{"docs":{},"df":0,"s":{"docs":{"13":{"tf":1},"17":{"tf":1},"27":{"tf":1}},"df":3}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"14":{"tf":1}},"df":1}}}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1.4142135623730951},"6":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"25":{"tf":1},"26":{"tf":1},"29":{"tf":1},"30":{"tf":1.4142135623730951},"40":{"tf":1},"41":{"tf":1},"45":{"tf":1.4142135623730951},"46":{"tf":1},"48":{"tf":1},"49":{"tf":1.4142135623730951},"51":{"tf":1},"52":{"tf":1.4142135623730951},"55":{"tf":1},"57":{"tf":1}},"df":17}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1}},"df":1}}},"y":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"x":{"docs":{"60":{"tf":1.7320508075688772}},"df":1}}}}}},"s":{"docs":{},"df":0,"v":{"docs":{"13":{"tf":1.4142135623730951}},"df":1}}},"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1}},"df":1},"i":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"2":{"tf":1},"45":{"tf":1},"52":{"tf":1.4142135623730951}},"df":3}}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"12":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"15":{"tf":1},"18":{"tf":1.4142135623730951},"21":{"tf":1}},"df":6}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"7":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"a":{"docs":{"13":{"tf":1},"40":{"tf":1},"46":{"tf":1},"54":{"tf":1}},"df":4}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"52":{"tf":1},"60":{"tf":2}},"df":3}}}},"i":{"docs":{},"df":0,"t":{"docs":{"36":{"tf":1}},"df":1}}},".":{"docs":{},"df":0,"g":{"docs":{"6":{"tf":1},"20":{"tf":1}},"df":2}},"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"7":{"tf":1},"45":{"tf":2.449489742783178},"51":{"tf":1},"52":{"tf":2.449489742783178},"53":{"tf":2}},"df":5}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"17":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1},"55":{"tf":1},"56":{"tf":1}},"df":3}}},"d":{"docs":{"57":{"tf":1}},"df":1}},"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{"10":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"17":{"tf":1},"28":{"tf":1}},"df":2}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1}},"df":1}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"y":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"10":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"15":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"17":{"tf":1}},"df":1}}}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"32":{"tf":1},"33":{"tf":1.7320508075688772}},"df":2}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"53":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{"60":{"tf":1.4142135623730951}},"df":1}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":3.4641016151377544},"6":{"tf":1.4142135623730951},"7":{"tf":1.7320508075688772},"10":{"tf":2.6457513110645907},"12":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":1},"15":{"tf":1},"16":{"tf":1},"17":{"tf":1},"20":{"tf":1},"21":{"tf":2},"29":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.4142135623730951},"45":{"tf":1.7320508075688772},"47":{"tf":1},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951},"56":{"tf":1}},"df":21,"m":{"docs":{"10":{"tf":1},"28":{"tf":1},"32":{"tf":1}},"df":3,"a":{"docs":{},"df":0,"t":{"docs":{"13":{"tf":1.4142135623730951}},"df":1}}},"k":{"docs":{"60":{"tf":1}},"df":1}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"2":{"tf":1},"12":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"53":{"tf":1},"54":{"tf":1},"60":{"tf":1}},"df":6}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"60":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":2},"55":{"tf":1},"57":{"tf":1}},"df":3}},"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"2":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":3},"7":{"tf":1.7320508075688772},"12":{"tf":2.449489742783178},"13":{"tf":3.4641016151377544},"15":{"tf":1},"21":{"tf":2.449489742783178},"22":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"35":{"tf":1.4142135623730951},"44":{"tf":1},"55":{"tf":1.4142135623730951},"57":{"tf":2},"60":{"tf":1}},"df":14}},"n":{"docs":{},"df":0,"e":{"docs":{"10":{"tf":1}},"df":1},"d":{"docs":{"49":{"tf":1}},"df":1}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"41":{"tf":1},"42":{"tf":1},"51":{"tf":1},"55":{"tf":1},"56":{"tf":1},"57":{"tf":1}},"df":6}}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"55":{"tf":1},"56":{"tf":1}},"df":2}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"2":{"tf":1.4142135623730951},"7":{"tf":1},"10":{"tf":2},"13":{"tf":1},"21":{"tf":1},"40":{"tf":1},"45":{"tf":1},"47":{"tf":1.4142135623730951},"48":{"tf":1},"53":{"tf":1}},"df":10}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"60":{"tf":1.4142135623730951}},"df":1}}}}}}}},"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"2":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"6":{"tf":1}},"df":1}}}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"13":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1}},"df":1}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1}},"df":1}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"33":{"tf":1}},"df":1}}}},"x":{"docs":{"52":{"tf":1.4142135623730951}},"df":1}},"u":{"docs":{},"df":0,"p":{"docs":{"2":{"tf":1.4142135623730951},"33":{"tf":1},"56":{"tf":1},"57":{"tf":1}},"df":4,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":1},"21":{"tf":1}},"df":2}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1},"45":{"tf":1.7320508075688772},"46":{"tf":2},"47":{"tf":1.4142135623730951},"48":{"tf":1.4142135623730951},"54":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":2.449489742783178},"57":{"tf":2}},"df":9}}}},"s":{"docs":{"2":{"tf":1.7320508075688772},"6":{"tf":1},"7":{"tf":1.7320508075688772},"12":{"tf":1},"13":{"tf":2},"18":{"tf":1},"21":{"tf":1.7320508075688772},"25":{"tf":1},"26":{"tf":1},"28":{"tf":1},"29":{"tf":1},"35":{"tf":1.4142135623730951},"46":{"tf":1},"49":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"53":{"tf":2},"55":{"tf":1},"60":{"tf":1}},"df":18,"a":{"docs":{},"df":0,"g":{"docs":{"2":{"tf":1.7320508075688772},"13":{"tf":2.23606797749979},"27":{"tf":1.4142135623730951},"41":{"tf":1},"45":{"tf":1.4142135623730951},"47":{"tf":1},"48":{"tf":1},"49":{"tf":2.6457513110645907},"51":{"tf":1},"52":{"tf":2.23606797749979},"53":{"tf":1}},"df":11}},"e":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":2},"6":{"tf":1},"12":{"tf":1},"13":{"tf":1},"28":{"tf":1},"29":{"tf":1.4142135623730951},"30":{"tf":1.4142135623730951},"40":{"tf":1},"53":{"tf":1.4142135623730951}},"df":9,">":{"docs":{},"df":0,"=":{"docs":{},"df":0,"<":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":1.4142135623730951},"12":{"tf":1},"13":{"tf":1},"29":{"tf":1},"30":{"tf":1}},"df":5}}}}}}}}}}},"'":{"docs":{"13":{"tf":1}},"df":1},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"13":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"7":{"tf":1}},"df":1}}}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1},"6":{"tf":1},"7":{"tf":1},"15":{"tf":1.4142135623730951},"28":{"tf":1},"60":{"tf":2.449489742783178}},"df":6}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"2":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"s":{"docs":{"13":{"tf":1}},"df":1}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"17":{"tf":1},"18":{"tf":1}},"df":2}}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"10":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"l":{"docs":{"60":{"tf":2.449489742783178}},"df":1}}},"t":{"docs":{},"df":0,"y":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"2":{"tf":1}},"df":1}},"e":{"docs":{"7":{"tf":1},"45":{"tf":1},"52":{"tf":1}},"df":3}}},"w":{"docs":{},"df":0,"o":{"docs":{"2":{"tf":1},"7":{"tf":1},"40":{"tf":1},"52":{"tf":1.7320508075688772}},"df":4}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"g":{"docs":{},"df":0,"z":{"docs":{"2":{"tf":1}},"df":1}}}},"b":{"docs":{},"df":0,"l":{"docs":{"41":{"tf":1},"45":{"tf":1.4142135623730951},"49":{"tf":1.4142135623730951},"50":{"tf":1},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}},"df":6}}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"21":{"tf":1}},"df":2}}},"u":{"docs":{"6":{"tf":1}},"df":1},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{"14":{"tf":1}},"df":1}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"20":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"60":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"13":{"tf":1},"21":{"tf":1},"40":{"tf":1},"49":{"tf":1.4142135623730951},"52":{"tf":1.4142135623730951},"53":{"tf":1}},"df":7}},"c":{"docs":{},"df":0,"k":{"docs":{"45":{"tf":1.7320508075688772}},"df":1}}},"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"6":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"13":{"tf":1},"52":{"tf":2}},"df":2}}},"p":{"docs":{"55":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"10":{"tf":1.4142135623730951}},"df":1}}},"s":{"docs":{"32":{"tf":1.4142135623730951}},"df":1}},"x":{"docs":{},"df":0,"t":{"docs":{"55":{"tf":1.4142135623730951},"56":{"tf":1}},"df":2}},"m":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"60":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{"10":{"tf":1}},"df":1,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"60":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"13":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{"17":{"tf":1},"21":{"tf":1}},"df":2}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"40":{"tf":1}},"df":2}},"e":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":1},"6":{"tf":1},"7":{"tf":1.7320508075688772},"57":{"tf":1}},"df":4}},"w":{"docs":{"56":{"tf":1.4142135623730951},"57":{"tf":1}},"df":2,"e":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1}},"df":1}},"l":{"docs":{},"df":0,"i":{"docs":{"56":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"6":{"tf":1}},"df":1}}}}}}},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"60":{"tf":1.4142135623730951}},"df":1}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":2.23606797749979},"7":{"tf":1.4142135623730951},"10":{"tf":1},"30":{"tf":1},"34":{"tf":1.4142135623730951},"40":{"tf":1},"53":{"tf":1.4142135623730951}},"df":7,">":{"docs":{},"df":0,"=":{"docs":{},"df":0,"<":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"21":{"tf":1},"34":{"tf":1.4142135623730951}},"df":4}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{"21":{"tf":1}},"df":1}}},"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{"21":{"tf":1}},"df":1}}}}}}}}},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"7":{"tf":1.4142135623730951},"32":{"tf":1},"45":{"tf":1},"52":{"tf":2},"53":{"tf":1.7320508075688772}},"df":5}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"7":{"tf":1.4142135623730951}},"df":1}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"17":{"tf":1},"19":{"tf":1}},"df":4}}}}}},"n":{"docs":{"17":{"tf":1}},"df":1},"t":{"docs":{},"df":0,"h":{"docs":{"32":{"tf":1}},"df":1}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"33":{"tf":1}},"df":1}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":2.6457513110645907},"6":{"tf":1},"7":{"tf":1.7320508075688772},"10":{"tf":1.7320508075688772},"13":{"tf":1.7320508075688772},"14":{"tf":1},"15":{"tf":1.7320508075688772},"16":{"tf":1},"19":{"tf":1},"21":{"tf":2},"23":{"tf":1},"28":{"tf":1.4142135623730951},"30":{"tf":1.7320508075688772},"33":{"tf":1.4142135623730951},"40":{"tf":1},"45":{"tf":1.4142135623730951},"46":{"tf":1.7320508075688772},"47":{"tf":1},"52":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951}},"df":20,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"2":{"tf":1.4142135623730951}},"df":1}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"13":{"tf":1.7320508075688772},"29":{"tf":1},"39":{"tf":1},"54":{"tf":1}},"df":5}}},"n":{"docs":{"13":{"tf":1},"21":{"tf":1},"60":{"tf":1}},"df":3},"v":{"docs":{"47":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"2":{"tf":1.4142135623730951},"7":{"tf":1},"13":{"tf":1.7320508075688772},"25":{"tf":1},"26":{"tf":1},"27":{"tf":1},"36":{"tf":1},"45":{"tf":1},"52":{"tf":1},"53":{"tf":1},"56":{"tf":1}},"df":11}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"2":{"tf":1.7320508075688772},"5":{"tf":1},"6":{"tf":1.7320508075688772},"7":{"tf":1.4142135623730951},"15":{"tf":1},"18":{"tf":1}},"df":6},"n":{"docs":{},"df":0,"c":{"docs":{"7":{"tf":1.4142135623730951},"13":{"tf":1},"52":{"tf":1.4142135623730951}},"df":3}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"d":{"docs":{"6":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1}},"df":1}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{"13":{"tf":1},"27":{"tf":1},"41":{"tf":1},"45":{"tf":1},"49":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772}},"df":6}}}}}},"c":{"docs":{"60":{"tf":1}},"df":1,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{"13":{"tf":1.4142135623730951},"52":{"tf":1}},"df":2}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"17":{"tf":1}},"df":1}}}},"p":{"docs":{"2":{"tf":1},"7":{"tf":1},"53":{"tf":1.4142135623730951}},"df":3},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{"2":{"tf":1}},"df":1},"n":{"docs":{},"df":0,"t":{"docs":{"6":{"tf":1}},"df":1}}}},"f":{"docs":{"6":{"tf":1},"13":{"tf":1.4142135623730951},"21":{"tf":1},"27":{"tf":1},"29":{"tf":1},"52":{"tf":1}},"df":6},"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"f":{"docs":{"6":{"tf":1},"21":{"tf":1}},"df":2}}}},"e":{"docs":{},"df":0,"m":{"docs":{"40":{"tf":1},"44":{"tf":1},"45":{"tf":2.23606797749979},"46":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}},"df":5}}},"g":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"10":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"10":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{"33":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"g":{"docs":{"45":{"tf":1},"52":{"tf":1}},"df":2}}},".":{"docs":{"30":{"tf":1},"45":{"tf":1.4142135623730951}},"df":2},"b":{"docs":{},"df":0,"m":{"docs":{"60":{"tf":1}},"df":1}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"34":{"tf":1},"35":{"tf":1}},"df":3}},"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1}},"df":1}}}}},"d":{"docs":{},"df":0,"e":{"docs":{"16":{"tf":1},"23":{"tf":1},"30":{"tf":1.4142135623730951},"33":{"tf":1}},"df":4}},"v":{"docs":{},"df":0,"e":{"docs":{"21":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":2},"7":{"tf":1},"12":{"tf":1},"13":{"tf":1.4142135623730951},"21":{"tf":1},"60":{"tf":1}},"df":6}}}},"k":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"52":{"tf":1},"60":{"tf":1}},"df":3}},"i":{"docs":{},"df":0,"n":{"docs":{"6":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"6":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"7":{"tf":1},"13":{"tf":1}},"df":2}}},"x":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"u":{"docs":{"49":{"tf":1}},"df":1,"m":{"docs":{"10":{"tf":1},"49":{"tf":1},"52":{"tf":1.4142135623730951}},"df":3}}}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1}},"df":1}}}},"n":{"docs":{},"df":0,"u":{"docs":{"13":{"tf":1},"40":{"tf":1},"41":{"tf":1},"44":{"tf":1.4142135623730951},"45":{"tf":2.449489742783178},"46":{"tf":1.7320508075688772},"52":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}},"df":8}},"r":{"docs":{},"df":0,"g":{"docs":{"21":{"tf":1}},"df":1}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"28":{"tf":1},"33":{"tf":1},"56":{"tf":1}},"df":3}}}}},"i":{"docs":{},"df":0,"n":{"docs":{"47":{"tf":1}},"df":1,"i":{"docs":{},"df":0,"m":{"docs":{"6":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"h":{"docs":{"32":{"tf":1.4142135623730951}},"df":1}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"2":{"tf":1},"13":{"tf":1.4142135623730951},"25":{"tf":1},"27":{"tf":1},"32":{"tf":1.7320508075688772},"46":{"tf":1}},"df":6}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"15":{"tf":1},"32":{"tf":1.4142135623730951}},"df":2}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1.7320508075688772},"27":{"tf":1}},"df":2}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"18":{"tf":1},"21":{"tf":1},"28":{"tf":1},"32":{"tf":1}},"df":5}}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"2":{"tf":1.4142135623730951},"6":{"tf":1},"7":{"tf":1},"13":{"tf":1}},"df":4}}},"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{"2":{"tf":1},"46":{"tf":1}},"df":2}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"7":{"tf":1}},"df":1}}}},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{"17":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"45":{"tf":1.7320508075688772}},"df":1}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{"45":{"tf":1},"49":{"tf":1.4142135623730951},"52":{"tf":2.23606797749979},"53":{"tf":1.7320508075688772}},"df":4,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"/":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"52":{"tf":1}},"df":1}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{"2":{"tf":1},"13":{"tf":1},"47":{"tf":1},"49":{"tf":2.23606797749979},"53":{"tf":1.4142135623730951},"56":{"tf":1},"57":{"tf":1}},"df":7}},"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"52":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"2":{"tf":2.6457513110645907},"7":{"tf":1.7320508075688772},"15":{"tf":1},"21":{"tf":1.4142135623730951},"28":{"tf":1.7320508075688772}},"df":5}}},"l":{"docs":{},"df":0,"i":{"docs":{"2":{"tf":1},"15":{"tf":1}},"df":2}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"60":{"tf":2.6457513110645907}},"df":2}}}}}},"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"y":{"docs":{"10":{"tf":1},"17":{"tf":1},"45":{"tf":1.4142135623730951},"47":{"tf":1},"48":{"tf":1},"49":{"tf":1}},"df":6}}}}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"18":{"tf":1},"21":{"tf":1},"45":{"tf":1.4142135623730951}},"df":3}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"33":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"41":{"tf":1},"54":{"tf":1},"55":{"tf":1.4142135623730951},"56":{"tf":1}},"df":6}}}}},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{"2":{"tf":1.4142135623730951},"13":{"tf":1},"25":{"tf":1}},"df":3,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"13":{"tf":1},"26":{"tf":1}},"df":3}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{"13":{"tf":1},"27":{"tf":1},"32":{"tf":1}},"df":3}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{"15":{"tf":1},"18":{"tf":1},"29":{"tf":1}},"df":3}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"=":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"20":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"6":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"6":{"tf":1},"10":{"tf":1}},"df":2}}}}},"/":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"/":{"docs":{},"df":0,"b":{"docs":{},"df":0,"s":{"docs":{},"df":0,"f":{"docs":{"60":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"y":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"x":{"docs":{"60":{"tf":1}},"df":1}}}}}}},"g":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"60":{"tf":1.4142135623730951}},"df":1}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"60":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}}}}}}},"w":{"docs":{},"df":0,"n":{"docs":{"13":{"tf":1},"31":{"tf":1},"47":{"tf":1},"49":{"tf":1},"53":{"tf":1}},"df":5}},"n":{"docs":{},"df":0,"e":{"docs":{"54":{"tf":1}},"df":1}}},"b":{"docs":{},"df":0,"g":{"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"17":{"tf":1},"19":{"tf":1}},"df":4}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{"47":{"tf":1},"49":{"tf":1},"53":{"tf":1}},"df":3}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"2":{"tf":1},"13":{"tf":1}},"df":2}},"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"6":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"s":{"docs":{"2":{"tf":1}},"df":1}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{"2":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"13":{"tf":1}},"df":1}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{"7":{"tf":1.4142135623730951},"12":{"tf":1},"13":{"tf":1},"16":{"tf":1},"30":{"tf":1}},"df":5}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"45":{"tf":1},"47":{"tf":1},"48":{"tf":1}},"df":3}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{"7":{"tf":1},"60":{"tf":1.4142135623730951}},"df":2}}},"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"13":{"tf":1.7320508075688772}},"df":1}}},"t":{"docs":{"21":{"tf":1}},"df":1,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"52":{"tf":1.4142135623730951},"56":{"tf":1}},"df":2}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"52":{"tf":1.4142135623730951},"53":{"tf":2}},"df":3}}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{"10":{"tf":1}},"df":1}}}},"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"15":{"tf":1}},"df":1}}}}}}},"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":2},"6":{"tf":1},"7":{"tf":1},"15":{"tf":1},"21":{"tf":1}},"df":5}},"w":{"docs":{"52":{"tf":1.4142135623730951}},"df":1}},"u":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1.7320508075688772},"6":{"tf":1.7320508075688772},"7":{"tf":1},"10":{"tf":1.7320508075688772},"12":{"tf":1},"13":{"tf":1},"16":{"tf":1},"18":{"tf":1},"30":{"tf":1},"52":{"tf":1},"53":{"tf":1},"56":{"tf":1.4142135623730951}},"df":12,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"45":{"tf":1},"49":{"tf":1.4142135623730951},"52":{"tf":2.449489742783178},"53":{"tf":1.7320508075688772}},"df":4}}}}},"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"60":{"tf":1.4142135623730951}},"df":1}}}}},"a":{"docs":{},"df":0,"d":{"docs":{"7":{"tf":1}},"df":1,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":2.449489742783178},"12":{"tf":1},"13":{"tf":1.4142135623730951},"24":{"tf":1},"29":{"tf":1},"30":{"tf":1},"40":{"tf":1.4142135623730951}},"df":7,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1}},"df":1,"r":{"docs":{"2":{"tf":2},"6":{"tf":1},"7":{"tf":1},"10":{"tf":1},"12":{"tf":1.4142135623730951},"13":{"tf":2},"24":{"tf":1},"30":{"tf":1.4142135623730951},"39":{"tf":1},"40":{"tf":1.7320508075688772},"41":{"tf":1},"42":{"tf":1},"43":{"tf":1},"44":{"tf":1},"54":{"tf":1}},"df":15}}},"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1}},"df":1}}}}}}}},"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"2":{"tf":1},"7":{"tf":1},"53":{"tf":1.4142135623730951}},"df":3}}}},"i":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1.4142135623730951},"35":{"tf":1},"45":{"tf":1}},"df":3,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"40":{"tf":1}},"df":1}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"7":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"2":{"tf":1}},"df":1}}}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1},"10":{"tf":1},"12":{"tf":1.4142135623730951},"13":{"tf":2.6457513110645907},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"16":{"tf":1},"17":{"tf":1},"19":{"tf":1},"20":{"tf":1.4142135623730951},"21":{"tf":3},"28":{"tf":1},"29":{"tf":1},"33":{"tf":1},"34":{"tf":1},"35":{"tf":1.7320508075688772}},"df":16}}}}}}},"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"2":{"tf":1}},"df":1}}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"6":{"tf":1.4142135623730951}},"df":1}}},"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"52":{"tf":1.4142135623730951}},"df":1}}}}}}}}},"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"v":{"docs":{"17":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"45":{"tf":2},"51":{"tf":1},"56":{"tf":1}},"df":3}}}},"l":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"y":{"docs":{"2":{"tf":1},"6":{"tf":1},"7":{"tf":1}},"df":3}}},"l":{"docs":{"10":{"tf":1},"13":{"tf":1},"52":{"tf":1.4142135623730951},"60":{"tf":1.4142135623730951}},"df":4,"o":{"docs":{},"df":0,"w":{"docs":{"52":{"tf":1}},"df":1}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{"21":{"tf":1},"45":{"tf":1}},"df":2}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"56":{"tf":1}},"df":1}}}}}},"n":{"docs":{},"df":0,"i":{"docs":{"2":{"tf":1},"7":{"tf":1},"10":{"tf":1}},"df":3},"y":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"21":{"tf":1}},"df":1}}}},"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{"2":{"tf":1},"49":{"tf":1},"52":{"tf":1},"53":{"tf":1}},"df":4}}},"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"12":{"tf":1},"21":{"tf":1}},"df":2,"c":{"docs":{"6":{"tf":1},"10":{"tf":1.4142135623730951}},"df":2}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1.4142135623730951},"54":{"tf":1}},"df":2}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1}},"df":1}},"c":{"docs":{},"df":0,"h":{"docs":{"60":{"tf":1}},"df":1}}},"i":{"docs":{"60":{"tf":1}},"df":1}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"6":{"tf":1},"13":{"tf":1},"52":{"tf":1.7320508075688772}},"df":3,"a":{"docs":{},"df":0,"b":{"docs":{"52":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"10":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1}},"df":1}}}}},"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"55":{"tf":1}},"df":1}}}}}},"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"40":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"n":{"docs":{"52":{"tf":1}},"df":1}}}}},"w":{"docs":{},"df":0,"t":{"docs":{"53":{"tf":1}},"df":1,"/":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"53":{"tf":1}},"df":1}}}}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"56":{"tf":1}},"df":1}}}}}},"v":{"docs":{"60":{"tf":1}},"df":1,"i":{"docs":{},"df":0,"a":{"docs":{"2":{"tf":2},"7":{"tf":1},"13":{"tf":1},"29":{"tf":1},"30":{"tf":1},"40":{"tf":1.7320508075688772},"46":{"tf":1},"53":{"tf":1.4142135623730951},"54":{"tf":1},"55":{"tf":1},"57":{"tf":1}},"df":11},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1},"60":{"tf":1}},"df":2}}}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"33":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"w":{"docs":{"45":{"tf":2},"53":{"tf":1.4142135623730951}},"df":2}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1.7320508075688772},"6":{"tf":1},"7":{"tf":1},"36":{"tf":1.4142135623730951},"60":{"tf":1.7320508075688772}},"df":5}}}},"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"27":{"tf":1},"32":{"tf":1.4142135623730951}},"df":4}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"13":{"tf":1.7320508075688772},"17":{"tf":1},"18":{"tf":1},"28":{"tf":1},"32":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951}},"df":6},"i":{"docs":{},"df":0,"d":{"docs":{"45":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"17":{"tf":1}},"df":1}}}}}},"m":{"docs":{"20":{"tf":1.4142135623730951}},"df":1}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"2":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"7":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"h":{"docs":{"2":{"tf":1.7320508075688772},"55":{"tf":1},"57":{"tf":1}},"df":3}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1},"60":{"tf":1.7320508075688772}},"df":2}}},"t":{"docs":{"2":{"tf":1},"7":{"tf":1},"13":{"tf":2.449489742783178},"40":{"tf":1},"57":{"tf":1}},"df":5}},"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1.4142135623730951},"17":{"tf":1},"21":{"tf":1.4142135623730951},"34":{"tf":1},"35":{"tf":1}},"df":5}}}},"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{"2":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"i":{"docs":{"2":{"tf":1.4142135623730951},"7":{"tf":1},"10":{"tf":1},"13":{"tf":1},"24":{"tf":1},"40":{"tf":1},"41":{"tf":1}},"df":7}},"n":{"docs":{},"df":0,"u":{"docs":{"60":{"tf":1.4142135623730951}},"df":1}}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1.4142135623730951},"7":{"tf":1.4142135623730951},"53":{"tf":1.4142135623730951}},"df":3,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"7":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"d":{"docs":{"10":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"13":{"tf":1.4142135623730951}},"df":1}}}},"l":{"docs":{},"df":0,"p":{"docs":{"33":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"13":{"tf":1}},"df":1}}}},"d":{"docs":{},"df":0,"e":{"docs":{"53":{"tf":1.4142135623730951}},"df":1}}},"a":{"docs":{"56":{"tf":1}},"df":1,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1}},"df":1},"i":{"docs":{"45":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{},"df":0,":":{"docs":{},"df":0,"/":{"docs":{},"df":0,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,".":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"/":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}},"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,".":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"/":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"/":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"u":{"docs":{},"df":0,"b":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"/":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"/":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},":":{"docs":{},"df":0,"/":{"docs":{},"df":0,"/":{"docs":{},"df":0,"w":{"docs":{},"df":0,"w":{"docs":{},"df":0,"w":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"y":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"x":{"docs":{},"df":0,".":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}}}},"j":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"/":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"/":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":2.449489742783178},"6":{"tf":1},"7":{"tf":1.7320508075688772},"10":{"tf":1.7320508075688772},"13":{"tf":1.4142135623730951},"15":{"tf":1},"21":{"tf":1.7320508075688772},"28":{"tf":1},"29":{"tf":1},"32":{"tf":1},"41":{"tf":1},"45":{"tf":1.4142135623730951},"55":{"tf":1}},"df":13,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1}},"df":1}}}},"n":{"docs":{"2":{"tf":1},"7":{"tf":1},"30":{"tf":1},"40":{"tf":1},"52":{"tf":1.4142135623730951}},"df":5,"c":{"docs":{"2":{"tf":1},"13":{"tf":1},"34":{"tf":1},"35":{"tf":1}},"df":4}},"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1},"13":{"tf":1},"29":{"tf":1}},"df":3}}},"w":{"docs":{},"df":0,"n":{"docs":{"6":{"tf":1}},"df":1}},"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"10":{"tf":1},"12":{"tf":2},"13":{"tf":3.4641016151377544},"21":{"tf":1.4142135623730951},"34":{"tf":2.23606797749979},"35":{"tf":1},"52":{"tf":1.4142135623730951},"53":{"tf":1}},"df":8}}}},"e":{"docs":{},"df":0,"r":{"docs":{"12":{"tf":1},"13":{"tf":1},"30":{"tf":1}},"df":3},"n":{"docs":{"13":{"tf":1},"17":{"tf":1},"19":{"tf":1},"24":{"tf":1},"30":{"tf":1},"40":{"tf":1.4142135623730951}},"df":6}}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"10":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"p":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1.4142135623730951},"13":{"tf":1.7320508075688772},"17":{"tf":1.4142135623730951}},"df":3}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"15":{"tf":1},"21":{"tf":1},"35":{"tf":1}},"df":3}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{"41":{"tf":1},"45":{"tf":1},"52":{"tf":1}},"df":3}}}}}}},"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"17":{"tf":1},"19":{"tf":1}},"df":2}}}}}}},"l":{"docs":{},"df":0,"d":{"docs":{"57":{"tf":1.4142135623730951}},"df":1}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"2":{"tf":1},"7":{"tf":1},"10":{"tf":2.449489742783178},"13":{"tf":1},"15":{"tf":1},"17":{"tf":1.4142135623730951},"18":{"tf":1},"19":{"tf":1.7320508075688772},"30":{"tf":1},"40":{"tf":1.4142135623730951},"41":{"tf":1},"42":{"tf":1},"43":{"tf":1},"44":{"tf":1.4142135623730951},"45":{"tf":1},"54":{"tf":1}},"df":16}}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{"2":{"tf":1},"28":{"tf":1}},"df":2},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"32":{"tf":1},"57":{"tf":1}},"df":2}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"6":{"tf":1},"52":{"tf":1}},"df":2}},"n":{"docs":{},"df":0,"'":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1.4142135623730951}},"df":1}},"y":{"docs":{"40":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"13":{"tf":1},"41":{"tf":1}},"df":2}},"b":{"docs":{"52":{"tf":1},"53":{"tf":1}},"df":2,"/":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"53":{"tf":1}},"df":1}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{"56":{"tf":1}},"df":1}}}}},"x":{"docs":{},"df":0,".":{"docs":{},"df":0,"y":{"docs":{},"df":0,".":{"docs":{},"df":0,"z":{"docs":{"2":{"tf":1}},"df":1}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"2":{"tf":1},"57":{"tf":1}},"df":2}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"7":{"tf":1}},"df":1}}},"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"45":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"56":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"n":{"docs":{"60":{"tf":1.4142135623730951}},"df":1}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"2":{"tf":2.449489742783178},"12":{"tf":1.4142135623730951},"13":{"tf":2.23606797749979},"16":{"tf":1.4142135623730951},"30":{"tf":1},"33":{"tf":1}},"df":6}}},"r":{"docs":{"41":{"tf":1}},"df":1},"c":{"docs":{},"df":0,"k":{"docs":{"57":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"n":{"docs":{"2":{"tf":1},"21":{"tf":1}},"df":2}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"33":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"x":{"docs":{"40":{"tf":1}},"df":1},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"45":{"tf":1},"55":{"tf":1},"56":{"tf":1}},"df":3}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"45":{"tf":1},"48":{"tf":1},"55":{"tf":1},"56":{"tf":1}},"df":4}}}},"s":{"docs":{},"df":0,"i":{"docs":{"60":{"tf":1}},"df":1}}},"s":{"docs":{},"df":0,"f":{"docs":{"60":{"tf":1.7320508075688772}},"df":1}}},"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"2":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"d":{"docs":{"7":{"tf":1},"53":{"tf":1}},"df":2}}}},"j":{"docs":{"20":{"tf":1.4142135623730951}},"df":1,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{"6":{"tf":1.4142135623730951},"12":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178},"18":{"tf":1.7320508075688772},"20":{"tf":1.4142135623730951},"21":{"tf":1},"52":{"tf":1.4142135623730951}},"df":7,"w":{"docs":{},"df":0,".":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{"18":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"x":{"docs":{"53":{"tf":1}},"df":1,"/":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"53":{"tf":1}},"df":1}}}}}}}},"<":{"docs":{},"df":0,"j":{"docs":{},"df":0,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{"12":{"tf":1.4142135623730951},"13":{"tf":2.449489742783178}},"df":2}}}}},"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{"60":{"tf":1.4142135623730951}},"df":1}}}},"_":{"docs":{"10":{"tf":1}},"df":1}}},"h-1":{"root":{"docs":{},"df":0}},"h0":{"root":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"0":{"tf":1},"1":{"tf":1},"2":{"tf":1}},"df":3}}}}}}}}},"f":{"docs":{},"df":0,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"0":{"tf":1},"1":{"tf":1},"3":{"tf":1},"4":{"tf":1},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"10":{"tf":1},"37":{"tf":1},"38":{"tf":1},"58":{"tf":1},"59":{"tf":1}},"df":11}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"0":{"tf":1},"1":{"tf":1},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"10":{"tf":1},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1},"58":{"tf":1},"59":{"tf":1}},"df":13}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"0":{"tf":1},"1":{"tf":1},"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"5":{"tf":1},"8":{"tf":1.4142135623730951},"9":{"tf":1.4142135623730951},"10":{"tf":1},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1},"58":{"tf":1},"59":{"tf":1}},"df":13}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"8":{"tf":1},"9":{"tf":1},"10":{"tf":1}},"df":3}}}}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"58":{"tf":1},"59":{"tf":1},"60":{"tf":1}},"df":3}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"4":{"tf":1},"5":{"tf":1}},"df":3}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"37":{"tf":1},"38":{"tf":1},"39":{"tf":1}},"df":3}}}}}}}},"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"8":{"tf":1},"9":{"tf":1},"10":{"tf":1}},"df":3}}}}},"r":{"docs":{"8":{"tf":1},"9":{"tf":1},"10":{"tf":1}},"df":3}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"8":{"tf":1},"9":{"tf":1},"10":{"tf":1}},"df":3}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{"8":{"tf":1},"9":{"tf":1},"10":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{"8":{"tf":1},"9":{"tf":1},"10":{"tf":1},"37":{"tf":1},"38":{"tf":1},"39":{"tf":1}},"df":6}}}}}}}}},"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"58":{"tf":1},"59":{"tf":1},"60":{"tf":1}},"df":3}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"58":{"tf":1},"59":{"tf":1},"60":{"tf":1}},"df":3}}}}}}},"h1":{"root":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"6":{"tf":1}},"df":1}}}}}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"7":{"tf":1},"54":{"tf":1}},"df":2}}}},"n":{"docs":{},"df":0,"e":{"docs":{"14":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{"7":{"tf":1}},"df":1}}}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"11":{"tf":1}},"df":1}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"14":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"43":{"tf":1}},"df":1}}}}}},"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"x":{"docs":{"11":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"54":{"tf":1}},"df":1}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1}},"df":1}}}}}}},"d":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1},"43":{"tf":1}},"df":2}}}}}}}}},"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"40":{"tf":1}},"df":1}}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"40":{"tf":1},"43":{"tf":1}},"df":2}}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"50":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"54":{"tf":1}},"df":1}}}}}}},"h2":{"root":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"12":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{"12":{"tf":1},"13":{"tf":1}},"df":2}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1}},"df":1}}}}}},"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1}},"df":1}}}}}},"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"12":{"tf":1},"13":{"tf":1}},"df":2}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{"52":{"tf":1}},"df":1}}}}}}}},"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"13":{"tf":1}},"df":1}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1},"20":{"tf":1},"21":{"tf":1}},"df":3}}}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1},"20":{"tf":1},"21":{"tf":1}},"df":3}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{"44":{"tf":1}},"df":1}}}},"j":{"docs":{},"df":0,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{"20":{"tf":1}},"df":1}}}},"v":{"docs":{},"df":0,"m":{"docs":{"20":{"tf":1}},"df":1},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{"45":{"tf":1}},"df":1}}}},"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1}},"df":1}}}}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"44":{"tf":1},"45":{"tf":1},"46":{"tf":1}},"df":3}}}},"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{"46":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"47":{"tf":1},"48":{"tf":1}},"df":2}}}},"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"53":{"tf":1}},"df":1}}}},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"48":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{"49":{"tf":1},"53":{"tf":1}},"df":2}}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"49":{"tf":1},"53":{"tf":1}},"df":2}}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{"49":{"tf":1}},"df":1}}}}}},"h3":{"root":{"docs":{},"df":0}},"hash":{"root":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"1":{"tf":1},"4":{"tf":1},"9":{"tf":1},"38":{"tf":1},"59":{"tf":1}},"df":5}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{"1":{"tf":1},"4":{"tf":1},"9":{"tf":1},"38":{"tf":1},"59":{"tf":1}},"df":5}}},"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1}},"df":1}}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"5":{"tf":1}},"df":1}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"53":{"tf":1}},"df":1}}}}}}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"6":{"tf":1}},"df":1}}}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"7":{"tf":1}},"df":1}}}}}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"10":{"tf":1}},"df":1}}},"_":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{"40":{"tf":1}},"df":1}}}}}}}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{"49":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{"39":{"tf":1}},"df":1,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{"43":{"tf":1}},"df":1}}}}},"_":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"50":{"tf":1}},"df":1}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"44":{"tf":1}},"df":1}}}}}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"y":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"45":{"tf":1}},"df":1}}}}}}}}}}},"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"46":{"tf":1}},"df":1}}}}}}}}},"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{},"df":0,"_":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1}},"df":1}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"47":{"tf":1}},"df":1}}}}}}}}},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"48":{"tf":1}},"df":1}}}}}},"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"54":{"tf":1}},"df":1}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"55":{"tf":1}},"df":1}}}}}}}}}}}},"o":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"t":{"docs":{"52":{"tf":1}},"df":1}}}}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"_":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"x":{"docs":{"11":{"tf":1}},"df":1}}}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"13":{"tf":1}},"df":1}}}}}}}}}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"14":{"tf":1}},"df":1}}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"12":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1}},"df":1}}}}}}}}}}}}}},"j":{"docs":{},"df":0,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"_":{"docs":{},"df":0,"v":{"docs":{},"df":0,"m":{"docs":{"20":{"tf":1}},"df":1}}}}}}}}}}},"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"_":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"16":{"tf":1}},"df":1}}}}},"d":{"docs":{},"df":0,"b":{"docs":{},"df":0,"g":{"docs":{"17":{"tf":1}},"df":1}}},"j":{"docs":{},"df":0,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{"18":{"tf":1}},"df":1}}}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"19":{"tf":1}},"df":1}}}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"33":{"tf":1}},"df":1}}}}}}}}}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"22":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{"23":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"24":{"tf":1}},"df":1}}}}},"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{"25":{"tf":1}},"df":1,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{"27":{"tf":1}},"df":1}}}}}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"28":{"tf":1}},"df":1}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"29":{"tf":1}},"df":1}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"p":{"docs":{},"df":0,"w":{"docs":{},"df":0,"d":{"docs":{"30":{"tf":1}},"df":1}}}}},"h":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"31":{"tf":1}},"df":1}}}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"32":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"34":{"tf":1},"35":{"tf":1}},"df":2}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{"36":{"tf":1}},"df":1}}}}}}},"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"60":{"tf":1}},"df":1}}}}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"_":{"4":{"docs":{},"df":0,".":{"1":{"docs":{"41":{"tf":1}},"df":1},"2":{"docs":{"42":{"tf":1}},"df":1},"5":{"docs":{"56":{"tf":1}},"df":1},"6":{"docs":{"57":{"tf":1}},"df":1},"docs":{},"df":0}},"docs":{},"df":0}}}}}}}}}},"pipeline":["trimmer","stopWordFilter","stemmer"]};sidx_href=["quickstart.html","quickstart.html#home-link","quickstart.html#ls_quickstart","installation.html","installation.html#home-link","installation.html#ls_installation","installation.html#ls_preconditions","installation.html#ls_licensefiles","running.html","running.html#home-link","running.html#ls_startoptions","running.html#sec_callsyntax","running.html#sec_server_side_operations","running.html#sec_client_side_operations","running.html#sec_commandline","running.html#sec_arguments_for_the_starter_script","running.html#arg_batch","running.html#arg_dbg","running.html#arg_java","running.html#arg_noconsole","running.html#sec_arguments_for_the_java_vm","running.html#sec_arguments_for_qf_test","running.html#arg_license","running.html#arg_licenseserver","running.html#arg_licenseserver.admin","running.html#arg_licenseserver.dump","running.html#arg_licenseserver.dumptotal","running.html#arg_licenseserver.dumppeak","running.html#arg_licenseserver.logfile","running.html#arg_licenseserver.password","running.html#arg_licenseserver.setpwd","running.html#arg_licenseserver.shutdown","running.html#arg_licenseserver.verbose","running.html#arg_nomessagewindow","running.html#arg_option","running.html#arg_options","running.html#arg_version","administration.html","administration.html#home-link","administration.html#ls_gui","administration.html#ls_start_gui","administration.html#figure_4.1","administration.html#figure_4.2","administration.html#ls_guihandling","administration.html#ls_filemenu","administration.html#ls_displaymenu","administration.html#ls_extrasmenu","administration.html#ls_UpdateAllButton","administration.html#ls_UpdateButton","administration.html#ls_selectindividualdata","administration.html#ls_gui_tables","administration.html#ls_engines_shown_table","administration.html#ls_overviewtable","administration.html#ls_individualtable","administration.html#ls_update_server_license","administration.html#ls_updatedialog","administration.html#figure_4.5","administration.html#figure_4.6","thirdparty.html","thirdparty.html#home-link","thirdparty.html#app_software"];sidx_stops=["","a","able","about","across","after","almost","also","am","among","an","and","are","as","at","be","because","been","but","by","can","cannot","could","dear","did","do","does","either","ever","every","got","had","have","he","her","hers","him","his","how","however","i","into","is","it","its","just","least","like","likely","may","me","might","most","must","my","neither","no","nor","not","of","off","often","on","only","other","our","rather","said","say","says","she","should","so","some","than","that","the","their","them","then","there","these","they","this","tis","to","too","twas","us","wants","was","we","were","what","when","where","which","who","whom","why","will","with","would","yet","you","your"];if(window.sidx_load_callback){sidx_load_callback(sidx_dump,sidx_href,sidx_stops)}