sidx_dump={"version":"0.9.5","fields":["content","h-1","h0","h1","h2","h3","hash"],"ref":"id","documentStore":{"docs":{"0":{"id":0,"content":"Pro Handbuch","hash":"","h0":"Vorwort | QF‑Test Handbuch"},"1":{"id":1,"content":"Pro Handbuch","hash":"home-link","h0":"Vorwort | QF‑Test Handbuch"},"2":{"id":2,"content":"Vorwort Wie unser Firmenname unschwer erkennen lässt, hat sich die Quality First Software GmbH dem Thema Qualität in der Softwareentwicklung verschrieben. Unser Beitrag hierzu ist das Programm QF‑Test, dessen Handbuch Sie gerade lesen. Mit Hilfe von QF‑Test können Funktionalitätstests von Java-Programmen oder Webseiten automatisiert werden, sofern diese eine grafische Benutzeroberfläche aufweisen. Die undankbare Aufgabe des Testens fällt je nach Größe und Struktur einer Firma und ihrer Projekte mal einem eigenen Team zur Qualitätssicherung zu, mal wird sie von den Entwicklern nebenbei erledigt und manchmal fällt sie ganz unter den Tisch, dann testet eben der Kunde. Anwender von QF‑Test sind daher sowohl Entwickler als auch Tester, die zum Teil sehr unterschiedliche Vorkenntnisse in Bezug auf Java oder Web GUIs mitbringen. Das Video 'Überblick' bietet eine allgemeine Übersicht über QF‑Test. Im Video 'Technische Einführung' erhalten Sie einen technischen Einblick in QF‑Test. Wir versuchen in diesem Handbuch sowohl Entwicklern als auch Testern gerecht zu werden und die erforderlichen Grundlagen über den Aufbau einer grafischen Benutzeroberfläche und die Handhabung von Ereignissen unter Java zu vermitteln. Sollten dabei Fragen offen bleiben, wenden Sie sich als Tester am besten an Ihre Entwickler, die Ihnen sicherlich weiterhelfen können. Die Entwickler unter Ihnen werden wir hoffentlich nicht zu sehr langweilen. Sie können die entsprechenden Stellen gegebenenfalls einfach überspringen. Ursprünglich unterstützte QF‑Test nur Java-Swing-GUIs, mit Version 2.0 kam Eclipse/SWT hinzu mit Version 3.0 die Unterstützung für das Testen von Web-Anwendungen. Teile von QF‑Test und dieses Handbuch wurden entsprechend geprägt, so dass die Dinge aus Sicht des Testens von Swing GUIs erklärt sind. In den meisten Fällen sind die Konzepte universell für alle GUIs anwendbar. Wo sie sich unterscheiden werden mit speziellen Hinweisen die Eigenheiten von SWT oder Web GUIs erklärt. Und noch ein Wort zur Sprache: Deutsche Bücher zu Computerthemen leiden fast immer unter dem Problem, dass viele Begriffe aus dem Englischen kommen. Diese haben im technischen Zusammenhang oft eine spezielle Bedeutung, die von der normalsprachlichen abweicht. Die Übersetzung solcher Begriffe ist schwierig, führt zu eigenartigen Wortkonstruktionen und verschleiert schlimmstenfalls die eigentliche Bedeutung. Belässt man sie dagegen in ihrer englischen Form, ergibt sich ein etwas holpriger Satzbau. Wir werden in diesem Handbuch beide Wege gehen und von Fall zu Fall entscheiden.","hash":"sec_preface","h0":"Vorwort"},"3":{"id":3,"content":"Hinweise zur Benutzung dieses Handbuchs Ein Webbrowser für das Handbuch kann direkt aus QF‑Test heraus gestartet werden. Der Menüeintrag »Hilfe«-»Handbuch...« führt Sie zur Einstiegsseite, »Hilfe«-»Neuigkeiten...« zur Dokumentation der Änderungen seit der letzten Version. Kontextsensitive Hilfe wird ebenfalls auf diesem Weg geboten. Klicken Sie dazu mit der rechten Maustaste auf einen beliebigen Baumknoten, ein Attribut oder eine Option und wählen Sie »Was ist das?« im Popupmenü. Das alles funktioniert nur, wenn der Browser des Systems für QF‑Test zugänglich ist. Das Handbuch besteht aus drei Teilen. Bei diesen Teilen handelt es sich um: Anwenderhandbuch Dieser Teil erklärt, wie QF‑Test installiert und gestartet wird und wie die Benutzeroberfläche zu bedienen ist. Er zeigt, wie Tests erstellt und aufgebaut werden und widmet sich dann fortgeschrittenen Themen. Um doppelte Erklärungen zu vermeiden bezieht sich das Anwenderhandbuch an vielen Stellen auf den Referenzteil, der den jeweiligen Punkt ausführlich erläutert. Es wird dringend empfohlen, diesen Verweisen zu folgen. Referenzteil Dies ist eine vollständige Referenz, die sämtliche einstellbaren Optionen, alle Bestandteile einer Testsuite und vieles weitere abdeckt. Wenn Sie spezielle Information zu einem Thema suchen, ist dies der richtige Ort zum Nachschlagen. Die kontextsensitive Hilfe führt ebenfalls zum Referenzteil. Technische Referenz Die Technische Referenz enthält Hintergrundinformationen über die Funktionsweise von QF‑Test sowie eine umfassende API Referenz der Skript Schnittstelle. Für Einsteiger ist dieser Teil weniger geeignet, für fortgeschrittene und technisch interessierte Anwender dagegen eine wertvolle Informationsquelle. Ein \"learning-by-doing\" Tutorial ist ebenfalls verfügbar und kann direkt mittels »Hilfe«-»Tutorial...« aufgerufen werden. Es befindet sich unter qftest-10.0.2-pro/doc/tutorial/de/tutorial.html. Das Handbuch folgt folgenden Konventionen: »Menü«-»Untermenü« stellt ein Menü oder einen Menüeintrag dar. Modifier⁠+⁠Taste steht für einen Tastendruck. Mögliche Modifier sind Shift/⇧ (Hochstellen), Strg/⌃, Alt/⌥, ⌘ oder eine Kombination daraus. Der Schrifttyp Courier wird für Datei- und Verzeichnisnamen, Programmein- und -ausgaben verwendet. Im Handbuch stehen folgende Tastaturkürzel zur Verfügung: →: Zur nächste Seite springen ←: Zur vorherigen Seite springen L: Zu Übersetzung der aktuellen Seite springen T: Zum Inhaltsverzeichnis springen S: Navigation ein/ausklappen F: Suchfeld fokussieren Während einer Suche sind außerdem folgende Tastaturkürzel aktiv: ↓: Zum nächsten Suchtreffer springen ↑: Zum vorherigen Suchtreffer springen Escape: Suche abbrechen Suchtreffer bei der lokalen Suche enthalten immer alle eingegebenen Begriffe im gleichen Abschnitt. Dabei werden, nach Möglichkeit, auch Wörter mit dem gleichen Wortstamm einbezogen und Teilwörter vervollständigt. Möchte man nach exakten Begriffen suchen, so sind diese in doppelte Anführungszeichen (\"…\") einzuschließen.","hash":"sec_howtouse","h1":"Hinweise zur Benutzung dieses Handbuchs"},"4":{"id":4,"content":"Pro Handbuch","hash":"","h0":"Anwenderhandbuch | QF‑Test Handbuch"},"5":{"id":5,"content":"Pro Handbuch","hash":"home-link","h0":"Anwenderhandbuch | QF‑Test Handbuch"},"6":{"id":6,"content":"Anwenderhandbuch","hash":"sec_user","h1":"Anwenderhandbuch"},"7":{"id":7,"content":"Pro Handbuch","hash":"","h0":"Installation und Start | QF‑Test Handbuch"},"8":{"id":8,"content":"Pro Handbuch","hash":"home-link","h0":"Installation und Start | QF‑Test Handbuch"},"9":{"id":9,"content":"Installation und Start Die Installation von QF‑Test auf den unterstützten Betriebssystemen wird in den folgenden Abschnitten ausführlich beschrieben. Zum Download stehen folgende Paketvarianten zur Verfügung: Windows (\"Windows Installation\") Normalerweise sollten Sie unter Windows QF‑Test über das Setup-Programm QF‑Test-10.0.2-pro.exe installieren. Dieses benötigt Administratorrechten, um in die gängigen Windows Verzeichnisse schreiben zu können. Für eine lokale Installation ohne besondere Rechte entpacken Sie stattdessen das selbst extrahierende Archiv QF‑Test-10.0.2-pro-sfx.exe. Linux (\"Linux Installation\") Für Linux entpacken Sie bitte das Archiv QF‑Test-10.0.2-pro.tar.gz. macOS (\"macOS Installation\") Für die Installation unter macOS dient das Disk-Image QF‑Test-10.0.2-pro.dmg. Generell kann man Versionen mit unterschiedlichen Versionsnummern von QF‑Test parallel installiert haben. Bei der Installation werden vorhandene Konfigurationsdateien nicht überschrieben. Im \"Speicherorte\" finden Sie Best Practices für die Installation von QF‑Test.","hash":"usec_installation","h0":"Installation und Start"},"10":{"id":10,"content":"Systemvoraussetzungen","hash":"usec_install_system","h1":"Systemvoraussetzungen"},"11":{"id":11,"content":"Hard- und Software QF‑Test selbst startet mit Java 21. Das 64 Bit Java Runtime Environment (JRE) wird dabei mit QF‑Test bereitgestellt, sodass Java nicht auf Ihrem System installiert sein muss, sofern dies nicht für das SUT erforderlich ist. Wenn Ihr zu testendes System (SUT) auf Java basiert, sollte es normalerweise sein eigenes JRE nutzen, nicht das von QF‑Test. Das Java-Kommando für das SUT wird getrennt beim Erstellen der Startsequenz für das SUT festgelegt. Unterstützte Java-Versionen für das SUT werden im Folgenden aufgelistet. Eine QF‑Test Installation belegt etwa 1 GB auf der Festplatte. Bei der Arbeit mit QF‑Test wird etwa ebenso viel an Arbeitsspeicher benötigt, aber das hängt auch von der Größe der Testsuiten und der Länge eines Testlaufs ab, siehe \"Mein Test läuft über lange Zeit und QF‑Test geht der Speicher aus. Wie kann ich das verhindern?\". Denken Sie auch daran, dass die für das SUT benötigten Ressourcen noch hinzu kommen.","hash":"sec_hard_und_software","h2":"Hard- und Software"},"12":{"id":12,"content":"Unterstützte Technologien - QF‑Test Die folgende Tabelle fasst die offiziell unterstützten Versionen von Betriebssystemen und erforderlicher Software für diese QF‑Test Version 10.0.2-pro zusammen. Unterstützung für zusätzliche Systeme und Versionen können auf Anfrage verfügbar sein, jedoch ohne Gewähr. Eine weitere Möglichkeit, um Unterstützung für ältere Software zu erlangen, kann die Nutzung einer der älteren QF‑Test Versionen sein, die herunterladbar sind über die Seite www.qftest.com/produkt/download.html. Die Unterstützung für 32 Bit Software wurde in QF‑Test Version 7.0 abgekündigt und in Version 8.0 entfernt. Das Testen von nativen 32 Bit Windows-Anwendungen bleibt aber weiterhin unterstützt.","hash":"usec_techversions_qftest","h2":"Unterstützte Technologien - QF‑Test"},"13":{"id":13,"content":"Technologie Versionseinschränkungen Einschränkungen bei SUT-Technologie Windows10, 11, Server 2016, Server 2019, Server 2022kein iOS Linux kein Windows und iOS macOSmacOS 12 und höherkein Windows und SWT Tabelle 1.1: Unterstützte Betriebssysteme für QF‑Test","hash":"usec_techversion_qftest_table","h2":"Unterstützte Technologien - QF‑Test"},"14":{"id":14,"content":"Unterstützte Technologien - zu testende Systeme Die folgenden Tabellen fassen die offiziell unterstützte Software zusammen, auf welcher eine mit QF‑Test zu testende Applikation (SUT) basieren kann. Unterstützung für zusätzliche Versionen kann auf Anfrage verfügbar sein, jedoch ohne Gewähr. Eine weitere Möglichkeit, Unterstützung für ältere Software zu erlangen, kann die Nutzung einer der älteren QF‑Test Versionen sein, die herunterladbar sind über die Seite www.qftest.com/produkt/download.html. Die zu testende Software kann auf den gleichen Betriebssystemen wie QF‑Test ausgeführt werden, hinsichtlich Einschränkungen siehe Unterstützte Betriebssysteme für QF‑Test In QF‑Test Version 7.0 wurde die Unterstützung für 32-Bit-Software abgekündigt und in Version 8.0 entfernt. Nicht betroffen hiervon ist das Testen von nativen 32-Bit-Windows-Anwendungen, das weiterhin unterstützt bleibt.","hash":"usec_techversions_sut","h2":"Unterstützte Technologien - zu testende Systeme"},"15":{"id":15,"content":"Technologie Versionseinschränkungen Bemerkung JDK/JRE 8 - 26 für das SUT Swing Alle Plattformen. JavaFX8 und höherAlle Plattformen. SWT3.7 - 4.38 bzw. 2025-1264 Bit x86, nur Windows und Linux GTK, GTK3 ab SWT 4.6. Für 32 Bit Eclipse/SWT Versionen verwenden Sie bitte QF‑Test 7.1 oder älter. Für Eclipse/SWT 3.5 - 3.6 können Sie https://archive.qfs.de/pub/qftest/swt_legacy.zip herunterladen und in das swt Verzeichnis Ihrer QF‑Test Installation entpacken. Tabelle 1.2: Unterstützte Java-Technologien","hash":"table_1.2","h2":"Unterstützte Technologien - zu testende Systeme"},"16":{"id":16,"content":"Technologie Versionseinschränkungen Bemerkung Chrome Version 131 mit QF-Driver, aktuelle Versionen über das Chrome DevTools Protokoll (CDP-Driver) und automatischen ChromeDriver-Download (WebDriver). Inkl. Headless Chrome. Siehe auch Browser Verbindungsmodus Firefox (WebDriver)Wie vom enthaltenen GeckoDriver unterstützt, aktuell 128esr und höher Inkl. Headless Firefox. Siehe auch Browser Verbindungsmodus Microsoft Edge Aktuelle Versionen über das Chrome DevTools Protokoll (CDP-Driver) und automatischen MSEdgeDriver-Download (WebDriver). Inkl. Headless Edge. Opera Aktuelle Versionen über das Chrome DevTools Protokoll (CDP-Driver). Safari WebDriver mit Safari JxBrowserVersion 6, 7 and 8, eingebettet in Swing, JavaFX oder SWT Electron 1.7 und neuer Web-Komponentenbibliotheken Detaillierte Aufstellung der unterstützten Toolkits in \"Besondere Unterstützung für verschiedene Web-Komponentenbibliotheken\" Tabelle 1.3: Unterstützte Web-Browser und Toolkits","hash":"table_1.3","h2":"Unterstützte Technologien - zu testende Systeme"},"17":{"id":17,"content":"Technologie Versionseinschränkungen Bemerkung Native Windows-Applikationen Es können Anwendungen getestet werden, die die Microsoft UI Automation oder die Microsoft Active Accessibility (MSAA) Schnittstellen unterstützen. Weitere Informationen siehe \"Einstieg\" Android Android API 24 oder höher. Dies entspricht der Android Version 7 Nougat oder neuer. Weitere Informationen siehe Voraussetzungen und bekannte Einschränkungen iOS iOS 15 oder neuer - Systembedingte Einschränkungen aufgrund der installierten Xcode-Version sind möglich. iOS-Anwendungen können nur auf einem macOS-System getestet werden, worauf die Entwicklungsumgebung Xcode mindestens in Version 13 installiert sein muss. Weitere Informationen siehe Voraussetzungen und bekannte Einschränkungen PDF Allgemeine Informationen siehe PDF-Dokumente testen Tabelle 1.4: Weitere unterstützte Software","hash":"table_1.4","h2":"Unterstützte Technologien - zu testende Systeme"},"18":{"id":18,"content":"Windows Installation Die Installation von QF‑Test für Windows kann auf zwei Arten erfolgen:","hash":"usec_install_windows","h1":"Windows Installation"},"19":{"id":19,"content":"Installation mit dem Windows Setup-Programm QF‑Test-10.0.2-pro.exe Dieses Installationsprogramm erfordert Administratorrechte und folgt den Standardvorgaben von Windows, die eine Trennung von nur lesbaren Programmdateien und beschreibbaren Konfigurationsdateien vorsehen. Besteht bereits eine ältere QF‑Test Installation, kann QF‑Test inklusive Systemkonfiguration optional auch am Windows-Standard vorbei komplett zur vorhandenen Installation geschrieben werden. Installation gemäß Windows Richtlinien Die Programmdateien werden in C:\\Programme\\QFS\\QF‑Test bzw. einem frei wählbaren Zielverzeichnis abgelegt. Die Systemkonfiguration mit beschreibbaren Dateien wird unabhängig vom Zielverzeichnis nach %PROGRAMDATA%\\QFS\\QF‑Test geschrieben. Das Verzeichnis %PROGRAMDATA% kann je nach Windows Version anders heißen, üblich ist C:\\ProgramData. Im Windows Explorer ist es standardmäßig ausgeblendet. Ein einfacher Weg, in dieses Verzeichnis zu navigieren, ist die Eingabe von %PROGRAMDATA% in der Adresszeile des Windows Explorers. In der PowerShell verwenden Sie cd $env:PROGRAMDATA, in einem cmd Konsolenfenster (\"Eingabeaufforderung\") cd /d %PROGRAMDATA%, um in das Verzeichnis und auf das zugehörige Laufwerk zu wechseln. Installation zusammen mit bereits vorhandener QF‑Test Version Falls eine ältere QF‑Test Installation gefunden wird und noch keine Systemkonfiguration in %PROGRAMDATA%\\QFS\\QF‑Test vorliegt, können Sie wählen, ob Sie die Installation gemäß den Windows Richtlinien mit %PROGRAMDATA% vorziehen oder QF‑Test weiterhin in der alten Struktur installieren möchten. In ersterem Fall wird nach Auswahl des Zielverzeichnisses die Systemkonfiguration von der alten Installation einmalig übernommen und nach %PROGRAMDATA%\\QFS\\QF‑Test kopiert. Wollen Sie die alte Struktur beibehalten, wird QF‑Test in dieses Verzeichnis installiert und nutzt die dort vorliegende Systemkonfiguration. In beiden Fällen wird %PROGRAMDATA%\\QFS\\QF‑Test\\qftestpath in den Systempfad aufgenommen und die beiden Programme qftest.exe und qftestc.exe dorthin kopiert. Dies ermöglicht den Start von QF‑Test von einem beliebigen Ort aus. Unabhängig von der Wahl der Installation können die alte und neue QF‑Test Version parallel betrieben werden. Bei der Installation gemäß Windows Richtlinien mit %PROGRAMDATA% sind die alte und neue Systemkonfiguration voneinander unabhängig. Wird die alte Struktur beibehalten, teilen sich alle Versionen die gemeinsame Systemkonfiguration. Perspektivisch raten wir zum Übergang zu %PROGRAMDATA%, da die für die alte Struktur notwendige Änderung von Zugriffsrechten im Programmverzeichnis kritisch zu sehen ist. In der Übergangsphase von QF‑Test 4.1 zu 4.2 kann es aber einfacher sein, beide Versionen gemeinsam vorzuhalten. Der Wechsel zur Installation gemäß Windows Richtlinien mit %PROGRAMDATA% kann auch im Zuge einer späteren Installation erfolgen. Unbeaufsichtigte (Silent) Installation Für die automatische Verteilung auf Testsystemen kann es gewünscht sein, dass QF‑Test unbeaufsichtigt installiert werden kann. QF‑Test unterstützt diese Art der Installation, da das Installationsprogramm von QF‑Test Inno Setup verwendet. Damit sind fast alle unter https://jrsoftware.org/ishelp/index.php?topic=setupcmdline beschriebenen Parameter auch beim Installationsprogramm von QF‑Test verwendbar. Eine Standardinstallation kann einfach mittels QF‑Test-10.0.2-pro.exe /VERYSILENT durchgeführt werden. Um zum Beispiel kein Desktop-Icon anzulegen, können Sie QF‑Test-10.0.2-pro.exe /VERYSILENT /MERGETASKS=\"!desktopicon\" ausführen. Damit wird eine Standardinstallation ohne den Task \"desktopicon\" ausgeführt. Auch die beiden minisetup-admin.exe und minisetup-noadmin.exe lassen sich so unbeaufsichtigt installieren. Zum Beispiel mittels minisetup-admin.exe /VERYSILENT. Beachten Sie bitte, dass die Installation für alle Benutzer erhöhte administrative Rechte benötigt. Um also auch den Windows UAC-Dialog nicht anzuzeigen muss bereits der aufrufende Prozess erhöhte Rechte besitzen. Der Parameter /CURRENTUSER ändert daran nichts, da die Installation immer erhöhte Rechte benötigt. Eine Ausnahme davon ist explizit minisetup-noadmin.exe, das die Konfiguration eines bereits installierten QF‑Test für den aktuellen Benutzer ohne administrative Rechte erlaubt. Eine Alternative für die unbeaufsichtigte Installation ist das portable selbstentpackende Archiv QF‑Test-10.0.2-pro-sfx.exe.","hash":"sec_installation_mit_dem_windows_setup_programm_qf_test_exe","h2":"Installation mit dem Windows Setup-Programm QF‑Test-10.0.2-pro.exe"},"20":{"id":20,"content":"Auspacken des selbstextrahierenden Archivs QF‑Test-10.0.2-pro-sfx.exe Wenn Sie nicht über Administratorrechte verfügen oder alle Dateien von QF‑Test zusammen an einer Stelle haben möchten, packen Sie das Archiv QF‑Test-10.0.2-pro-sfx.exe zunächst an einem geeigneten Ort aus. Hierzu kopieren Sie es an die gewünschte Stelle und führen es dort aus. Falls 7-Zip auf Ihrem System installiert ist können sie das Archiv alternativ per Rechtsklick mit 7-Zip öffnen und dann damit extrahieren. Am Zielort wird das Verzeichnis qftest erstellt, das im Weiteren als Wurzelverzeichnis von QF‑Test bezeichnet wird und gleichzeitig die Systemkonfiguration beinhaltet. Anschließend können Sie das Programm minisetup-noadmin.exe im Unterverzeichnis qftest-10.0.2-pro ausführen, um Verknüpfungen für die zu QF‑Test gehörenden Dateiendungen und einen Eintrag im Windows Startmenü sowie optional ein Desktop Icon zu erstellen. Falls Sie über Administratorrechte verfügen, können Sie stattdessen minisetup-admin.exe ausführen, um diese Einstellungen für alle Anwender vorzunehmen und zusätzlich das Verzeichnis %PROGRAMDATA%\\QFS\\QF‑Test\\qftestpath in den Systempfad aufzunehmen und die beiden Programme qftest.exe und qftestc.exe dorthin zu kopieren. Wenn Sie stattdessen eine vollständig portable Installation bevorzugen, können Sie im Verzeichnis qftest einen neuen Ordner namens userdir anlegen. Dieser wird dann anstelle von %APPDATA%\\QFS\\QF‑Test als benutzerspezifisches Konfigurationsverzeichnis verwendet, so dass wirklich alle zu QF‑Test gehörenden Dateien an einem Ort zusammen liegen und keine Änderungen am System vorgenommen werden.","hash":"sec_auspacken_des_selbstextrahierenden_archivs_qf_test_sfx_exe","h2":"Auspacken des selbstextrahierenden Archivs QF‑Test-10.0.2-pro-sfx.exe"},"21":{"id":21,"content":"Abschluss der Installation und Java-Konfiguration Zum Abschluss der Installation bietet jedes der Setup-Programme an, den für QF‑Test verwendeten Speicher sowie die Anzeigesprache zu konfigurieren. Dies geschieht mit Hilfe eines kleinen Dialogs, in dem Sie diese Einstellung vornehmen können. Bei einer portablen Installation kann der Dialog durch Ausführen von qftest\\qftest-10.0.2-pro\\bin\\qfconfig.exe aufgerufen werden. QF‑Test wird mit einem 64 Bit Java 21 Runtime Environment ausgeliefert. Dieses befindet sich im Installationsverzeichnis von QF‑Test. Es wird empfohlen, dieses zu verwenden. Der Dialog enthält eine Einstellmöglichkeit des maximal für QF‑Test zur Verfügung stehenden Speichers. Als Vorgabe werden 1024 MB verwendet. Weiterhin können Sie die Sprache für QF‑Test festlegen. Normalerweise richtet sich diese nach den Systemeinstellungen, Sie können aber auch gezielt die deutsche oder die englische Version auswählen. Diese Einstellungen werden in der Datei launcherwin.cfg in QF‑Test's Verzeichnis für die Systemkonfiguration gespeichert und von dort durch das qftest.exe Startprogramm gelesen. Sie können das Konfigurationsprogramm jederzeit aus dem System Menü heraus aufrufen, um diese Einstellungen zu ändern.","hash":"sec_abschluss_der_installation_und_java_konfiguration","h2":"Abschluss der Installation und Java-Konfiguration"},"22":{"id":22,"content":"Linux Installation Wählen Sie zunächst ein geeignetes Verzeichnis aus, das diese und zukünftige Versionen von QF‑Test beherbergen wird, z.B. /opt oder /usr/local. Wechseln Sie in dieses Verzeichnis und stellen Sie sicher, dass Sie Schreibzugriff darauf haben. Wenn Sie auf eine neue Version von QF‑Test aufrüsten, verwenden Sie das selbe Verzeichnis wieder. Packen Sie das .tar.gz Archiv mittels tar xfzv QF‑Test-10.0.2-pro.tar.gz aus. Dabei wird das Verzeichnis qftest erstellt, das im Weiteren als Wurzelverzeichnis von QF‑Test bezeichnet wird. Unter Linux ist dies gleichzeitig das Systemverzeichnis, das die Systemkonfiguration von QF‑Test enthält. Nach der ersten Installation von QF‑Test enthält das Wurzelverzeichnis nur das versionsspezifische Unterverzeichnis qftest-10.0.2-pro. Bei einem Update wird ein neues Unterverzeichnis für die aktuelle Version hinzugefügt. Um die Installation abzuschließen, wechseln Sie mittels cd qftest/qftest-10.0.2-pro in das Unterverzeichnis für die aktuelle QF‑Test Version und führen dort das Shell-Skript setup.sh aus. Dieses Setup Skript erzeugt die Verzeichnisse log, jython, groovy und javascript im QF‑Test Wurzelverzeichnis, sofern diese noch nicht vorhanden sind. Anschließend wird auf Wunsch ein symbolischer Link vom Verzeichnis /usr/local/bin (oder /usr/bin, falls es kein /usr/local/bin gibt) zum Startskript für den qftest Befehl erstellt. Sie benötigen Schreiberlaubnis für /usr/local/bin, um diesen Link zu erstellen. Unter Linux sollte QF‑Test normalerweise sein mitgebrachtes JRE verwenden. Alternativ kann nun das java Programm festgelegt werden, mit dem QF‑Test gestartet wird, sofern nicht mittels -java <Programm> (abgekündigt) ein anderes Java-Programm angegeben wird. Das setup Skript durchsucht hierzu den PATH und schlägt das erste gefundene java Programm vor. Befindet sich kein java Programm im PATH oder wollen Sie ein anderes verwenden, können Sie ein java Programm angeben. Das Skript ermittelt dann selbstständig die JDK Version. Als nächstes steht die Angabe des maximal für QF‑Test zur Verfügung stehenden Speichers an, vorgegeben sind 1024 MB. Alternativ kann QF‑Test mit der Kommandozeilenoption -J-XmxZZZm gestartet werden, wobei ZZZ den Speicher in MB definiert. Zuletzt haben Sie die Möglichkeit, die Sprache für QF‑Test auszuwählen. Diese richtet sich normalerweise nach den Systemeinstellungen, kann aber auch gezielt auf Deutsch oder Englisch eingestellt werden. Allerdings gilt diese Einstellung dann für alle Anwender. Alternativ können Sie QF‑Test mit der Option -J-Duser.language=XX aufrufen, mit XX gleich de für Deutsch oder en für Englisch. Sofern oben genannte Werte vom Standard abweichen, werden sie in die Datei launcher.cfg in QF‑Tests Wurzelverzeichnis geschrieben. Diese Datei wird vom qftest Startskript ausgewertet und auch bei einem Update von QF‑Test herangezogen.","hash":"usec_install_linux","h1":"Linux Installation"},"23":{"id":23,"content":"macOS Installation Zur Installation von QF‑Test als macOS-Anwendung aktivieren Sie das Disk-Image QF‑Test-10.0.2-pro.dmg und kopieren Sie die QF‑Test Anwendung in den Ordner Programme (oder einen anderen Ordner nach Wahl) und starten Sie QF‑Test von dort. Um eine spezielle Konfiguration wie zum Beispiel den für QF‑Test zur Verfügung stehenden Speicher oder die Sprache anzupassen gibt es für QF‑Test unter macOS einen speziellen Unterpunkt in den QF‑Test Optionen (Allgemein->Programmstart). Hier können die gewünschten Einstellungen gesetzt werden, welche dann beim Neustart von QF‑Test gesetzt werden.","hash":"usec_install_macos","h1":"macOS Installation"},"24":{"id":24,"content":"Lizenzdatei Zum Start benötigt QF‑Test eine Lizenzdatei, die Sie von Quality First Software GmbH erhalten. Seit QF‑Test 4.0 ist der empfohlene Weg, Lizenzen direkt über das Menü »Hilfe«-»Lizenz aktivieren...« zu aktivieren oder zu aktualisieren. Alternativ funktioniert auch noch der folgende traditionelle Weg: Stellen Sie die Lizenzdatei in das Systemverzeichnis von QF‑Test. Unter Windows ist dies je nach Installationsvariante %PROGRAMDATA%\\QFS\\QF‑Test (vgl. \"Windows Installation\") oder, wie unter Linux, das Wurzelverzeichnis von QF‑Test. Achten Sie darauf, dass die Datei den Namen license ohne Erweiterungen erhält. Manche Mailprogramme versuchen den Dateityp zu erraten und hängen eigenständig eine Erweiterung an. Wenn Sie auf eine neue QF‑Test Version aufrüsten, können Sie die Lizenzdatei einfach beibehalten, sofern diese für die neue Version gültig ist. Für eine Aufstellung der für QF‑Test relevanten Verzeichnisse öffnen Sie den Info-Dialog über das Menü »Hilfe«-»Info« und wählen den Reiter \"Systeminfo\". Im Video 'Lizenzupdate' wird die Vorgehensweise bei einem Lizenzupdate gezeigt. Wenn Sie Ihre Lizenz erweitern, z.B. auf eine größere Benutzerzahl oder eine neue Version von QF‑Test, erhalten Sie von Quality First Software GmbH dazu eine Datei namens license.new. Diese Datei ist normalerweise selbst keine gültige Lizenz, sondern muss mit Ihrer aktuellen Lizenz kombiniert werden. Gehen Sie dazu wie folgt vor: Speichern Sie die Datei license.new in das selbe Verzeichnis, in dem Ihre aktuelle Lizenz liegt. Stellen Sie sicher, dass dieses Verzeichnis und die alte Lizenzdatei namens license von Ihnen beschreibbar sind. Starten Sie QF‑Test im interaktiven Modus. QF‑Test erkennt selbstständig die neue Datei, überprüft sie auf Gültigkeit und bietet Ihnen an, Ihre Lizenz zu aktualisieren. Wenn Sie zustimmen, wird die aktuelle Lizenz in license.old umbenannt und die neue, kombinierte Lizenz in license geschrieben. Wenn Sie sich vergewissert haben, dass alles in Ordnung ist, können Sie die Dateien license.old und license.new löschen. Sollte QF‑Test das Update nicht erkennen, überprüfen Sie, ob der Zeitstempel der Datei license.new neuer ist als der von license. Achten Sie auch darauf, dass nicht bereits eine Instanz von QF‑Test auf Ihrem Rechner läuft. Wenn Sie einen besonderen Namen oder Pfad für die Lizenzdatei verwenden oder mit mehr als einer Lizenzdatei arbeiten möchten, so lässt sich dies durch Verwendung des Kommandozeilenarguments -license <Datei> erreichen, das in \"Kommandozeilenargumente und Rückgabewerte\" beschrieben wird.","hash":"usec_licensefile","h1":"Lizenzdatei"},"25":{"id":25,"content":"Konfigurationsdateien In der Standardeinstellung verwenden alle QF‑Test Installationen die gleichen Konfigurationsdateien, so dass Sie einfach zwischen verschiedenen QF‑Test Versionen und Editionen hin und herwechseln können. Für eine Aufstellung der für QF‑Test relevanten Verzeichnisse öffnen Sie den Info-Dialog über das Menü »Hilfe«-»Info« und wählen den Reiter \"Systeminfo\". Beim Beenden speichert QF‑Test die Fensterpositionen und persönliche Einstellungen in einer Datei namens config im benutzerspezifischen Konfigurationsverzeichnis von QF‑Test, welches außerdem die Protokolle von Tests enthält, die im interaktiven Modus durchgeführt werden sowie Profil-Verzeichnisse für das Testen von Web-Anwendungen und temporäre Dateien zur Bearbeitung und Ausführung von Skripten. Unter Windows ist das benutzerspezifische Konfigurationsverzeichnis normalerweise %APPDATA%\\QFS\\QF‑Test für neue Installationen. Falls dieses Verzeichnis nicht existiert und Sie bereits eine QF‑Test Version älter als 4.2 auf diesem System genutzt haben, welches das Verzeichnis .qftest in Ihrem Anwenderverzeichnis erstellt hat, nutzt QF‑Test dieses Verzeichnis weiter. Sie können manuell den Inhalt des Verzeichnisses .qftest nach %APPDATA%\\QFS\\QF‑Test verschieben und anschließend .qftest entfernen. QF‑Test ab Version 4.2.0 nutzt dann nur noch dieses Verzeichnis. Sie sollten diesen Vorgang aber nur durchführen, wenn Sie keine Version älter als 4.2.0 mehr verwenden möchten! Unter Linux ist das benutzerspezifische Konfigurationsverzeichnis immer ~/.qftest. Unter macOS befindet es sich unter /Users/<username>/Library/Application Support/de.qfs.apps.qftest. Die persönliche Konfigurationsdatei wird nicht gelesen, wenn QF‑Test im Batchmodus ausgeführt wird (vgl. \"Aufruf von QF‑Test\"). Unabhängig von den Systemvorgaben können Sie das benutzerspezifische Konfigurationsverzeichnis jederzeit über das Kommandozeilenargument -userdir <Verzeichnis> festlegen oder nur die Konfigurationsdatei mittels -usercfg <Datei>. Systemeinstellungen, die von mehreren Anwendern gemeinsam genutzt werden, speichert QF‑Test in der Datei qftest.cfg im systemspezifischen Konfigurationsverzeichnis, welches auch die Lizenzdatei, Module für Skripte, Java-Plugins und andere Dateien beinhaltet. Unter Windows hängt der Ort des Systemverzeichnisses von der Installations-Variante ab (vgl. \"Windows Installation\"). Es befindet sich entweder in %PROGRAMDATA%\\QFS\\QF‑Test oder im Wurzelverzeichnis von QF‑Test. Unter Linux und macOS ist das Systemverzeichnis normalerweise identisch zum Wurzelverzeichnis von QF‑Test. Den Ort der System-Konfigurationsdatei können Sie über das Kommandozeilenargument -systemcfg <Datei> ändern, das gesamte Systemverzeichnis via -systemdir <Verzeichnis>.","hash":"usec_configfile","h1":"Konfigurationsdateien"},"26":{"id":26,"content":"Aufruf von QF‑Test Es gibt zwei Modi, in denen QF‑Test ausgeführt werden kann. Im normalen Modus ist QF‑Test der Editor für Testsuiten und Protokolle und das Kontrollzentrum zum Starten von Programmen, Aufzeichnen von Events und Ausführen von Tests. Wird QF‑Test mit dem Argument -batch aufgerufen, geht es in den Batchmodus. Anstatt ein Editor Fenster zu öffnen, lädt es die auf der Kommandozeile angegebenen Testsuiten und führt sie automatisch aus, ohne dass es weiterer Eingriffe bedarf. Das Ergebnis des Testlaufs wird durch den Rückgabewert von QF‑Test sowie den optionalen Protokollen (siehe \"Das Protokoll\") und Reports (siehe \"Das Protokoll\") ausgedrückt. Das Setup Skript für Linux erstellt auf Wunsch einen symbolischen Link von /usr/local/bin zum qftest Startskript im Verzeichnis qftest-10.0.2-pro/bin unter QF‑Tests Wurzelverzeichnis. Damit können Sie QF‑Test einfach durch Eingabe von qftest starten. Unter Windows wird ein Menüeintrag und auf Wunsch auch ein Desktopicon für QF‑Test erstellt. Sie können QF‑Test entweder darüber, oder durch einen Doppelklick auf eine Testsuite oder ein Protokoll aufrufen, da diese Dateien mit QF‑Test verknüpft sind. Um QF‑Test von der Konsole zu starten, geben Sie einfach qftest ein. Für den Aufruf von der Kommandozeile stehen diverse Argumente, wie z.B. die zu verwendende Java-VM, zur Verfügung, die ausführlich in \"Kommandozeilenargumente und Rückgabewerte\" beschrieben werden. Wenn gleichzeitig unterschiedliche Versionen von QF‑Test installiert sind, kann eine bestimmte Version durch den gezielten Aufruf des qftest Programms direkt aus dem jeweiligen qftest-X.Y.Z/bin Verzeichnis gestartet werden. Wenn QF‑Test aufgrund von inkorrekten Einstellungen unter Optionen->Allgemein->Programmstart nicht mehr korrekt startet, können die Standard Einstellung wieder hergestellt werden. Dazu müssen in einem macOS Terminal folgende zwei Kommandos ausgeführt werden. defaults write de.qfs.qftest /de/qfs/qftest/ \\ -dict-add JVMOptions/ '{\"Xmx\"=\"-Xmx1024m\";\"Xms\"=\"-Xms16m\";}' defaults write de.qfs.qftest /de/qfs/qftest/ \\ -dict-add JVMArguments/ '{\"args\"=\"\";}' Beispiel 1.1: Zurücksetzen der Programmstart Optionen unter macOS","hash":"usec_execution","h1":"Aufruf von QF‑Test"},"27":{"id":27,"content":"Pro Handbuch","hash":"","h0":"Bedienung von QF‑Test | QF‑Test Handbuch"},"28":{"id":28,"content":"Pro Handbuch","hash":"home-link","h0":"Bedienung von QF‑Test | QF‑Test Handbuch"},"29":{"id":29,"content":"Bedienung von QF‑Test Dieses Kapitel beschreibt den Aufbau des QF‑Test Hauptfensters und wie Sie sich darin zurechtfinden. Spätestens nach diesem Kapitel ist es an der Zeit, QF‑Test zu starten und verschiedene Dinge auszuprobieren. Über den Menüeintrag »Hilfe«-»Tutorial« können Sie Ihren Browser mit dem QF‑Test \"learning-by-doing\" Tutorial starten. Sollte das mit Ihrer Systemkonfiguration nicht klappen, finden Sie das Tutorial im Verzeichnis qftest-10.0.2-pro/doc/tutorial. Dort gibt es auch eine PDF Variante. Der erste Teil des Videos 'Das Hauptfenster und das System under Test' befasst sich mit den Bestandteilen des QF‑Test Hauptfensters.","hash":"usec_gui","h0":"Bedienung von QF‑Test"},"30":{"id":30,"content":"Die Testsuite Zum Automatisieren von GUI Tests benötigt man zwei Dinge: Kontrollstrukturen und Daten. Die Kontrollstrukturen legen fest, was zu tun ist und wann es zu tun ist. Die Daten für die Tests setzen sich aus den Informationen über die GUI-Komponenten des SUT (System under test), den zu simulierenden Events und den erwarteten Ergebnissen zusammen. QF‑Test vereint alles zusammen in einer hierarchischen Baumstruktur, die wir als Testsuite bezeichnen. Die Elemente des Baums werden Knoten genannt. Knoten können weitere Knoten enthalten, in bestem \"Denglish\" Childknoten (oder kurz Children) genannt. Beim übergeordneten Knoten reden wir vom Parentknoten (kurz Parent). Der Wurzelknoten des Baums repräsentiert die Testsuite als Ganzes. Es gibt mehr als 60 verschiedene Arten von Knoten, die alle im Detail im Referenzteil beschrieben werden. Manche Knoten fungieren nur als Datencontainer, während andere den Ablauf von Tests steuern. Alle haben ihre speziellen Eigenschaften in Form von Attributen. Die jeweiligen Attribute des gerade selektierten Knotens werden zur Rechten des Baums in der Detailansicht dargestellt. Diese ist über das Menü »Ansicht«-»Details« ein- oder ausschaltbar.","hash":"usec_gui_suite","h1":"Die Testsuite"},"31":{"id":31,"content":"Abbildung 2.1: Struktur einer Testsuite Die obige Abbildung zeigt ein einfaches Beispiel einer Testsuite. Die Attribute des Knotens \"Einfacher Test\" können rechts in der Detailansicht bearbeitet werden. Eine Testsuite - und damit der Testsuite Wurzelknoten - besitzt die folgende Grundstruktur: Eine beliebige Anzahl von Testfallsatz oder Testfall Knoten, gefolgt von den Prozeduren, Extrasequenzen und Fenster und Komponenten Knoten. Der Prozeduren Knoten enthält die Packages und Prozeduren, die in \"Prozeduren und Packages\" beschrieben werden. Der Extrasequenzen Knoten ist eine Art Spielwiese oder Clipboard, wo alle Arten von Knoten für Experimente oder zur Zwischenlagerung abgelegt werden können. Die Fenster und Komponenten, die die Oberfläche des SUT bilden, werden durch Fenster und Komponente Knoten repräsentiert und sind unterhalb des Fenster und Komponenten Knotens angesiedelt. Um detaillierte Informationen zu einem Knoten oder einem seiner Attribute zu bekommen, klicken Sie darauf mit der rechten Maustaste und wählen Sie im Kontextmenü »Was ist das?«. Dies öffnet einen HTML-Browser mit dem entsprechenden Abschnitt des Handbuchs.","hash":"figure_2.1","h4":"Abbildung 2.1: Struktur einer Testsuite"},"32":{"id":32,"content":"Bearbeiten einer Testsuite Das Bearbeiten einer Testsuite lässt sich in zwei Kategorien einteilen: Operationen wie Ausschneiden/Kopieren/Einfügen auf den Knoten des Baums und das Ändern der Attribute eines Knotens. Es gibt überraschend viele Möglichkeiten, diese Aktionen auszuführen, und die Meinungen über die beste Vorgehensweise gehen auseinander. Daher bietet QF‑Test mehrere zentrale Optionen, die dieses Verhalten beeinflussen.","hash":"usec_gui_editing","h1":"Bearbeiten einer Testsuite"},"33":{"id":33,"content":"Überprüfen der Gültigkeit von Attributwerten Eine wichtige Entscheidung besteht darin, ob QF‑Test verhindern soll, dass Benutzer ungültige Werte bestätigen. Dies kann nützlich sein, bedeutet aber, dass Benutzer eingeschränkt werden und gezwungen sind, die Attribute eines Knotens fertig zu bearbeiten, bevor sie zu einem anderen wechseln. Die Alternative besteht darin, illegale Werte zuzulassen, sodass Benutzer frei zwischen Knoten oder Testsuiten navigieren können, um Werte an einer Stelle nachzuschlagen oder zu kopieren und an anderer Stelle zu verwenden. Der Nachteil bei dieser Variante ist, dass illegale Werte später Probleme verursachen können, wenn Tests aus diesem Grund nicht fortgesetzt werden können. Seit QF‑Test Version 10 ist die Standardeinstellung der weniger restriktive Ansatz des nicht-modalen Editierens, bei dem die Kontrolle - aber auch alle Verantwortung - beim Anwender liegt. Mit der Option Vor dem impliziten Akzeptieren von Detailänderungen nachfragen in der Einstellung \"Niemals\" werden Attributänderungen implizit übernommen, sobald der Fokus den aktuellen Knoten verlässt, und der Einsatz modaler Dialoge zur Durchsetzung der Konsistenz wird minimiert. Neue Knoten werden sofort in den Baum eingefügt, wobei der Fokus auf dem ersten Detailattribut liegt. Ungültige Attribute werden mit einem rötlichen Hintergrund hervorgehoben. Die Option \"Ungültige Attribute währdend der Eingabe hervorheben\" legt fest, ob die Hervorhebung bei jedem Tastendruck kontinuierlich aktualisiert wird oder nur, wenn der Fokus das Feld verlässt. Um eine strikte Gültigkeit der Attribute durchzusetzen, setzen Sie die Option Vor dem impliziten Akzeptieren von Detailänderungen nachfragen auf \"Nur wenn Werte ungültig oder suspekt sind \" oder sogar auf \"Immer\". Beim Einfügen eines neuen Knotens öffnet sich dann zuerst ein Dialog, um die Details des neu eingefügten Knotens zu bearbeiten, bevor er in den Baum eingefügt wird. Wenn Sie von einem Knoten mit geänderten, aber noch nicht übernommenen Attributen weg navigieren, werden die Attribute in einen modalen Dialog \"herausgezogen\", um eine Entscheidung darüber zu erzwingen, ob die Änderungen übernommen werden sollen, bevor fortgefahren werden kann. In beiden Fällen sind die Buttons \"OK\" und \"Abbrechen\" in den Details nicht mehr notwendig und können über die Option \"OK\" und \"Abbrechen\" Buttons anzeigen aus der Benutzeroberfläche entfernt werden. Sie können Änderungen explizit übernehmen, indem Sie Strg⁠+⁠Eingabe drücken und mit Escape abbrechen. Unabhängig von den Optionen können Sie einen Dialog zum Bearbeiten der Details des ausgewählten Knotens explizit über »Berabeiten«-»Eigenschaften« oder Alt⁠+⁠Eingabe öffnen. Weitere nützliche Tastenkombinationen können beim Bearbeiten mehrzeiliger Textattribute hilfreich sein: Strg⁠+⁠TAB und Shift⁠+⁠Strg⁠+⁠TAB bewegen den Fokus aus dem Textfeld zum nächsten bzw. vorherigen Feld. Eine äußerst nützliche Funktion ist »Bearbeiten«-»Rückgängig machen« (Strg⁠+⁠Z), auch Undo genannt. Sie macht jede Art von Änderung an der Testsuite rückgängig, inklusive Aufnahmen oder Änderungen mit Hilfe des Suchen/Ersetzen Dialogs. Änderungen werden dabei Schritt für Schritt aufgehoben. Die Anzahl der verfügbaren Schritte ist in der Option Anzahl der zurücknehmbaren Änderungen pro Suite einstellbar, Standard ist 30. Sollten Sie zu viele Schritte rückgängig gemacht haben, können Sie diese mittels »Bearbeiten«-»Wiederherstellen« (Strg⁠+⁠Y) wieder herstellen.","hash":"sec_uberprufen_der_gultigkeit_von_attributwerten","h2":"Überprüfen der Gültigkeit von Attributwerten"},"34":{"id":34,"content":"Navigation im Baum Auch wenn die Tastaturkürzel für die Navigation im Baum den üblichen Konventionen entsprechen, sollen sie hier noch einmal genannt werden. Darüber hinaus bietet QF‑Test einige hilfreiche Zusatzfunktionen. Die Pfeiltasten dienen zur grundlegenden Navigation. Hoch und Runter sind offensichtlich, Rechts expandiert entweder einen geschlossenen Knoten, oder geht zum nächsten Knoten, während Links entweder einen geöffneten Knoten schließt, oder zu seinem Parentknoten springt. Bäume in QF‑Test erlauben eine spezielle Variante von Mehrfachselektion. Es können mehrere nicht zusammenhängende Regionen selektiert werden, aber nur unter den Knoten eines gemeinsamen Parentknotens. Wäre Mehrfachselektion über den ganzen Baum erlaubt, würde Ausschneiden und wieder Einfügen in totalem Chaos enden. Tastaturkürzel zum Ausprobieren sind Shift⁠+⁠Hoch und Shift⁠+⁠Runter um die Selektion zu erweitern, Strg⁠+⁠Hoch und Strg⁠+⁠Runter für Bewegungen ohne Änderung der Selektion und Leertaste zum Umschalten der Selektion des aktuellen Knotens. Analog erweitern Mausklicks in Kombination mit der Shift Taste die Selektion, während Klicks mit Strg die Selektion des angeklickten Knotens umschalten. Spezielle Kürzel sind Alt⁠+⁠Rechts und Alt⁠+⁠Links, welche rekursiv einen Knoten mit all seinen Childknoten aus- oder einklappen,. Alt⁠+⁠Runter und Alt⁠+⁠Hoch navigieren zum nächsten oder vorhergehenden Knoten auf der selben Ebene, dazwischen liegende Childknoten werden übersprungen. Intern merkt sich QF‑Test die zuletzt angesprungenen Knoten. Strg⁠+⁠Backspace navigiert zum zuletzt selektierten Knoten, auch mehrere Schritte zurück. Zu guter Letzt sollten noch Strg⁠+⁠Rechts und Strg⁠+⁠Links erwähnt werden, mit deren Hilfe der Baum horizontal gescrollt werden kann, wenn er zu groß für seinen Rahmen geworden ist.","hash":"sec_navigation_im_baum","h2":"Navigation im Baum"},"35":{"id":35,"content":"Einfügemarkierung Wenn Sie neue Knoten anlegen oder eine Aufnahme oder kopierte Knoten in die Testsuite einfügen, zeigt Ihnen die Einfügemarkierung an, wo die neuen Knoten landen werden.","hash":"usec_insert","h2":"Einfügemarkierung"},"36":{"id":36,"content":"Abbildung 2.2: Einfügemarkierung Knoten werden immer nach dem selektierten Knoten eingefügt. Ist der selektierte Knoten geöffnet, werden der oder die neuen Knoten Children des selektierten Knotens, andernfalls landen sie auf der gleichen Ebene. Im Beispiel der obigen \"Einfügemarkierung\" würde ein neuer Knoten als erstes Child der Sequenz \"Events\" vor dem Mausevent eingefügt.","hash":"fig_insertmark","h4":"Abbildung 2.2: Einfügemarkierung"},"37":{"id":37,"content":"Knoten verschieben Knoten können kopiert und eingefügt werden oder innerhalb einer Testsuite oder über Testsuite Grenzen hinweg verschoben werden. Die üblichen Tastaturkürzel Strg⁠+⁠X, Strg⁠+⁠C und Strg⁠+⁠V werden dazu ebenso unterstützt wie entsprechende Einträge im Kontextmenü. Alternativ können Knoten auch durch Ziehen mit der Maus, genannt Drag&Drop, verschoben werden. Normalerweise werden der oder die markierten Knoten bei dieser Operation verschoben. Durch Drücken der Strg Taste während des Loslassens können die Knoten stattdessen kopiert werden. Während die Maus über den Baum einer Testsuite gezogen wird zeigt die Einfügemarkierung an, wo die Knoten beim Loslassen der Maus eingefügt werden und ob die Operation so erlaubt ist. Eine grüne Markierung signalisiert erwartungsgemäß eine gültige Operation, eine rote Markierung eine ungültige. In letzterem Fall passiert beim Loslassen der Maus gar nichts. Während des Ziehens können Sie Knoten im Baum auf- oder zuklappen indem Sie mit dem Mauszeiger über den entsprechenden Schalter fahren und dort kurz verharren. Auf diesem Weg können Sie einfach zur Zielposition navigieren, ohne die Drag&Drop Operation abbrechen und neu starten zu müssen. Die Drag&Drop Operation kann jeder Zeit durch Drücken der Esc Taste abgebrochen werden.","hash":"usec_copy_paste","h2":"Knoten verschieben"},"38":{"id":38,"content":"Knoten konvertieren Manche Knoten können in einen anderen Knotentyp konvertiert werden, was wesentlich bequemer ist als erst den gewünschten Knoten anzulegen und dann die benötigten Attribute zu kopieren. Beispiele von austauschbaren Knoten sind Sequenz und Testschritt oder Server-Skript und SUT-Skript. Die Konvertierung eines Knotens ist nur dann möglich, wenn seine Childknoten und seine aktuelle Position im Baum auch für den gewünschten Zielknoten gültig sind. Mögliche Ziele der Konvertierung können unter dem Eintrag »Knoten konvertieren in« im Kontextmenü ausgewählt werden. Ist dieser Eintrag nicht verfügbar, gibt es keine gültigen Zielknoten. In diesem Fall kann es hilfreich sein, den Ausgangsknoten zunächst unter die Extrasequenzen zu verschieben. Sie finden weitere Details über den Konvertierungsmechanismus unter Details zu Knotenkonvertierungen.","hash":"usec_transform_nodes","h2":"Knoten konvertieren"},"39":{"id":39,"content":"Tabellen An verschiedenen Stellen verwendet QF‑Test Tabellen zur Darstellung und Bearbeitung von Werten, z.B. um Variablen zu definieren oder für Checks von mehreren Elementen.","hash":"usec_tables","h2":"Tabellen"},"40":{"id":40,"content":"Abbildung 2.3: Beispieltabelle Die Buttons oberhalb der Tabelle haben folgende Tastaturkürzel und Bedeutung: Shift⁠+⁠Einfg Zeile einfügen. Legt eine neue Zeile an. Shift⁠+⁠Return, Alt⁠+⁠Return Zeile bearbeiten. Öffnet einen Dialog mit Eingabefeldern für alle Zellen der aktuellen Zeile. Shift⁠+⁠Entf Zeile löschen. Entfernt die aktuelle Zeile. Shift⁠+⁠Strg⁠+⁠Hoch Zeile nach oben verschieben. Verschiebt die aktuelle Zeile um eine Position nach oben. Shift⁠+⁠Strg⁠+⁠Runter Zeile nach unten verschieben. Verschiebt die aktuelle Zeile um eine Position nach unten. Manche Tabellen bieten zusätzlich die Möglichkeit, Spalten anzulegen und zu löschen, sowie die Überschriften der Spalten zu bearbeiten und stellen dazu die folgenden Buttons bereit: Spalte einfügen. Fügt eine neue Spalte ein. Spalte löschen. Löscht die selektierte Spalte. Spalte bearbeiten. Öffnet einen Dialog zum Bearbeiten der Spaltenüberschrift. Um einen Wert direkt in der Tabelle zu editieren, können Sie einfach losschreiben. Dabei wird der aktuelle Wert überschrieben. Um den vorhandenen Wert zu verändern, drücken Sie zunächst F2 oder selektieren Sie die Zelle mit einem Doppelklick. Zum Abschluss der Bearbeitung drücken Sie Return, abbrechen können Sie mit Escape. Wenn Sie versuchen, einen unzulässigen Wert einzugeben, färbt sich der Rand der Zelle rot und Sie können die Eingabe nicht übernehmen. Die Tabellen unterstützen Mehrfachselektion der Zeilen (Mausklicks mit Shift/Strg, Shift/Strg⁠+⁠Hoch/Runter) sowie Ausschneiden, Kopieren und Einfügen von ganzen Zeilen (Strg⁠+⁠X/C/V). Das Einfügen ist dabei auf Tabellen mit gleichartigen Spalten beschränkt. Im Kontextmenü der Tabelle können noch weitere Aktionen verfügbar sein, z.B. Anzeigen von Zeilennummern, Komponente finden, etc. Ein Mausklick auf die Spaltenüberschrift aktiviert die Sortierung der Zeilen. Ein Doppelklick auf die Spaltenüberschrift passt die Spaltenbreite automatisch an den breitesten Wert innerhalb der Spalte an oder erlaubt das Editieren des der Spaltenüberschrift (bei Datentabelle).","hash":"expl_table","h4":"Abbildung 2.3: Beispieltabelle"},"41":{"id":41,"content":"Packen und Entpacken Während der Entwicklung von Tests ist es ab und zu notwendig, mehrere Knoten unter einen neuen Elternknoten zu verschieben. Eine typische Situation hierfür ist das Refactoring von Prozeduren bzw. das Reorganisieren dieser Knoten in Packages oder einen Ablauf in einen Try/Catch Block zu packen. Für solche Anforderungen erlaubt QF‑Test dem Benutzer Knoten zu packen. Dies kann mittels Rechtsklick auf die entsprechenden Knoten und Auswahl von »Knoten einpacken« und des gewünschten neuen Elternknotens erreicht werden. QF‑Test erlaubt ebenfalls Knoten wieder zu entpacken und deren Elternknoten zu löschen. Diesen Ansatz kann man z.B. verwenden, um Test unnötige Packages bzw. Testfallsätze zu löschen oder einen Try/Catch Block wieder zu entfernen. Um Knoten zu entpacken selektieren Sie den entsprechenden Knoten und wählen im Kontextmenü »Knoten entpacken« aus. Die Pack- und Entpackaktionen werden nur dann im Kontextmenü angezeigt, wenn das Einfügen der Kindknoten in der aktuellen Struktur erlaubt ist.","hash":"usec_basicEditPack","h2":"Packen und Entpacken"},"42":{"id":42,"content":"Sortieren von Knoten QF‑Test gibt Ihnen die Möglichkeit Knoten einer Testsuite zu sortieren. Dies erreichen Sie mittels Rechtsklick auf den entsprechenden Knoten und Auswahl von »Knoten rekursiv sortieren«. Alternativ können Sie auch mehrere Knoten markieren und mittels »Knoten sortieren« nur die markierten Knoten in eine geordnete Reihenfolge bringen. Der Algorithmus sortiert zur Zeit Ziffern vor Großbuchstaben und diese vor Kleinbuchstaben. Neben der bestehenden Grundstruktur von QF‑Test, die eingehalten werden muss, besteht noch die Regel, dass Package Knoten immer vor Abhängigkeit Knoten und diese vor Prozedur Knoten einsortiert werden. Die Grundstruktur einer Testsuite wird vom Sortieren nicht verändert. In einer Testsuite können Sie zwar Testfälle und Prozeduren sortieren, allerdings wird der Prozeduren Knoten immer vor dem Fenster und Komponenten Knoten sein.","hash":"usec_basicEditSort","h2":"Sortieren von Knoten"},"43":{"id":43,"content":"Erweiterte Bearbeitungsmöglichkeiten Dieser Abschnitt erläutert die etwas komplexeren Bearbeitungsmöglichkeiten wie Suchen/Ersetzen oder die Arbeit mit mehreren Ansichten der selben Testsuite.","hash":"usec_gui_advanced_editing","h1":"Erweiterte Bearbeitungsmöglichkeiten"},"44":{"id":44,"content":"Suchen QF‑Test bietet zwei Arten von Suchoperationen, eine allgemeine Suche durch alle Knoten und deren Attribute in Testsuiten und Protokollen sowie eine inkrementelle Suche in Textfeldern, darunter auch Script-Konsolen und Programmausgaben.","hash":"usec_searching","h2":"Suchen"},"45":{"id":45,"content":"Allgemeine Suche Obwohl die Funktionen zum Suchen und Ersetzen vieles gemeinsam haben, gibt es signifikante Unterschiede, vor allem in der Reichweite der Operation. Eine Suche startet normalerweise beim selektierten Knoten und geht von dort den Baum bis zum Ende durch. Nach einer entsprechenden Rückfrage wird die Suche am Anfang des Baums fortgesetzt und endet spätestens beim ursprünglichen Startknoten, so dass jeder Knoten des Baums genau einmal durchlaufen wird. Dieses Vorgehen ist analog zur Suchfunktion in gängigen Textverarbeitungen und sollte intuitiv zu benutzen sein.","hash":"usec_gensearch","h2":"Allgemeine Suche"},"46":{"id":46,"content":"Anfangs öffnet QF‑Test die 'einfache' Suche. Diese erlaubt Ihnen nach einen bestimmten Text zu suchen.","hash":"parameter_search_text","h2":"Allgemeine Suche"},"47":{"id":47,"content":"Abbildung 2.4: Der Dialog für die einfache Suche Für eine spezifischere Suche, z.B. nach Attributen, Knotentypen oder bestimmten Zuständen von Knoten können Sie in den 'Fortgeschrittenen' Suchmodus wechseln. Hierfür klicken Sie auf den 'Suchmodus wechseln' Knopf in der Werkzeugleiste.","hash":"figure_2.4","h4":"Abbildung 2.4: Der Dialog für die einfache Suche"},"48":{"id":48,"content":"Abbildung 2.5: Der fortgeschrittene Suchdialog Normalerweise durchsucht QF‑Test alle Attribute in allen Arten von Knoten nach dem gewünschten Text.","hash":"figure_2.5","h4":"Abbildung 2.5: Der fortgeschrittene Suchdialog"},"49":{"id":49,"content":"Mit Hilfe der Option \"Im Attribut\" lässt sich die Suche auf ein spezielles Attribut einschränken.","hash":"parameter_search_attribute","h4":"Abbildung 2.5: Der fortgeschrittene Suchdialog"},"50":{"id":50,"content":"Über die Option \"Knotentyp\" kann man die Suche auf eine spezielle Art von Knoten einschränken.","hash":"parameter_search_nodetype","h4":"Abbildung 2.5: Der fortgeschrittene Suchdialog"},"51":{"id":51,"content":"Die Option \"Reichweite der Such-Operation\" setzt fest, wo nach dem angegebenen Ausdruck gesucht werden soll. Dies kann entweder in den aktuell selektierten Knoten, in der gesamten Testsuite oder in allen offenen Testsuiten geschehen.","hash":"parameter_search_range","h4":"Abbildung 2.5: Der fortgeschrittene Suchdialog"},"52":{"id":52,"content":"Wenn Sie die Option \"Nur Knoten mit den folgenden Zuständen\" auswählen, wird nur nach Knoten gesucht, welche den angegebenen Status besitzen, z.B. einer grünen Marke oder einen Breakpoint.","hash":"parameter_search_nodestates","h4":"Abbildung 2.5: Der fortgeschrittene Suchdialog"},"53":{"id":53,"content":"Ist \"Gesamtes Attribut vergleichen\" aktiviert, muss der gesuchte Text genau einem Wert entsprechen, andernfalls genügt es, wenn der Suchtext im Attribut enthalten ist.","hash":"parameter_search_whole","h4":"Abbildung 2.5: Der fortgeschrittene Suchdialog"},"54":{"id":54,"content":"Reguläre Ausdrücke werden in \"Reguläre Ausdrücke - Regexps\" erklärt. Um nach Werten von Booleschen Attributen wie Als \"harten\" Event wiedergeben zu suchen, verwenden Sie \"true\" oder \"false\" (ohne Anführungsstriche) als Suchtext. Falls Sie nach leeren Werten suchen möchten, müssen Sie \"Gesamtes Attribut vergleichen\" anhaken. Wenn die Suche erfolgreich ist, wird der gefundene Knoten markiert und eine Meldung in der Statuszeile ausgegeben, die den Namen des gefundenen Attributs angibt. Wie bereits erwähnt, startet die Suche normalerweise vom gerade selektierten Knoten. Falls Sie allerdings während des Suchprozesses die Selektion ändern möchten und trotzdem die vorherige Suche fortsetzen wollen, dann können Sie dies mit dem Button \"Suche fortsetzen\" erreichen. Wenn der Suchdialog geschlossen wurde, können Sie die Suche immer noch fortsetzen, in dem Sie F3 drücken. Mittels Ctrl⁠+⁠G können Sie sogar die selbe Suche von einem neuen Knoten aus starten. Ein sehr nützliches Feature ist die Fähigkeit nach allen Prozeduraufruf Knoten zu suchen, die eine bestimmte Prozedur aufrufen, oder nach allen Events, die eine bestimmte Komponente benötigen. Wählen Sie hierzu einfach den Menüeintrag »Referenzen finden...« im Kontextmenü des Knotens, der aufgerufen oder referenziert wird. Danach wird ein neues Fenster mit allen Referenzen auf den ausgewählten Knoten angezeigt. In diesem Fenster können Sie mittels Doppelklick auf einen Eintrag zur jeweiligen Stelle in der Testsuite springen.","hash":"parameter_search_regexp","h4":"Abbildung 2.5: Der fortgeschrittene Suchdialog"},"55":{"id":55,"content":"Abbildung 2.6: Resultatsliste von 'Referenzen finden' Es ist ebenso möglich alle gefundenen Knoten aus dem Suchdialog mittels Klick auf \"Ergebnisliste anzeigen\" zu erreichen. Von diesem Fenster aus, können Sie auch wiederum jeden einzelnen Knoten der Testsuite erreichen.","hash":"figure_2.6","h4":"Abbildung 2.6: Resultatsliste von 'Referenzen finden'"},"56":{"id":56,"content":"Inkrementelle Textsuche Zusätzlich zur Suche im Baum gibt es die Möglichkeit für inkrementelles Suchen in Komponenten, die Text enthalten, wie z.B. das Terminal oder entsprechende Attribute in der Detailansicht. Diese Features kann über den »Suchen...« Eintrag im Kontextmenü der Komponente aktiviert werden oder durch Drücken von Strg⁠+⁠F, wenn die Komponente ausgewählt ist und den Tastaturfokus besitzt. Dann erscheint das Eingabefenster für die inkrementelle Suche am rechten oberen Rand der entsprechenden Komponente. Die folgende Abbildung zeigt eine inkrementelle Suche für das Terminal mit hervorgehobenen Suchtreffern.","hash":"usec_incsearch","h2":"Inkrementelle Textsuche"},"57":{"id":57,"content":"Abbildung 2.7: Die inkrementelle Suche Die Suche kann auf einen bestimmten Teil des enthaltenen Textes beschränkt werden, in dem man den gewünschten Bereich selektiert und den »Suchen in Auswahl...« Eintrag im Kontextmenü der Komponente wählt oder Strg⁠+⁠Umschalt⁠+⁠F drückt. Ansonsten sollte die inkrementelle Suche und auch die verfügbaren Optionen selbsterklärend sein.","hash":"figure_2.7","h4":"Abbildung 2.7: Die inkrementelle Suche"},"58":{"id":58,"content":"Ersetzen","hash":"usec_replace","h2":"Ersetzen"},"59":{"id":59,"content":"Wenn man einmal die Besonderheiten beim Gültigkeitsbereich verinnerlicht hat, ist der Ersetzen Dialog ebenso intuitiv zu benutzen wie der Suchdialog. Beim Ersetzen haben Sie die Möglichkeit, einen Treffer nach dem anderen zu ersetzen, oder alle auf einmal. Um bei Letzterem unerwartete Resultate zu vermeiden bedarf es einer Möglichkeit, den Bereich für das Ersetzen einzuschränken. Daher werden beim Ersetzen nur die selektierten Knoten sowie deren direkte oder indirekte Childknoten durchsucht. Um Ersetzungen im gesamten Baum durchzuführen, selektieren Sie den Wurzelknoten oder wählen Sie im Ersetzen Dialog die entsprechende Einstellung unter \"Reichweite der Ersetzen-Operation\".","hash":"parameter_search_replace","h2":"Ersetzen"},"60":{"id":60,"content":"Abbildung 2.8: Der Ersetzen Dialog Die Optionen entsprechen denen im Suchdialog. Ist \"Gesamtes Attribut vergleichen\" ausgeschaltet, sind mehrere Ersetzungen innerhalb eines Attributs möglich. Zum Beispiel würde das Ersetzen von \"a\" durch \"b\" im Wort \"ananas\" zu \"bnbnbs\" führen. Für den Einsatz von regulären Ausdrücken lesen Sie bitte \"Reguläre Ausdrücke - Regexps\". Ist die Suche erfolgreich, wird der gefundene Knoten selektiert und ein Dialog geöffnet, der das gefundene Attribut mit dem alten und neuen Wert anzeigt.","hash":"figure_2.8","h4":"Abbildung 2.8: Der Ersetzen Dialog"},"61":{"id":61,"content":"Abbildung 2.9: Der Rückfrage Dialog beim Ersetzen Sie haben folgende Möglichkeiten: Ein Klick auf Ersetzen ändert das Attribut und setzt die Suche nach dem nächsten Wert fort. Alle ersetzen ändert dieses Attribut sowie alle weiteren Treffer ohne nochmalige Rückfrage. Überspringen lässt dieses Attribut unverändert und setzt die Suche fort. Erwartungsgemäß beendet Abbrechen den gesamten Vorgang. Wenn Sie sich bei den Eingaben sicher sind, können Sie gleich im Ersetzen Dialog Alle ersetzen wählen und damit die Rückfrage überspringen. Nachdem die Attribute geändert wurden, wird die Anzahl der betroffenen Knoten in einem Meldungsdialog ausgegeben. Nach dem Ersetzen wird von QF‑Test ein Ergebnisfenster mit allen angepassten Knoten angezeigt. Sie können dieses Fenster auch vor der eigentlichen Aktion mittels Klick auf \"Ergebnisliste anzeigen\" im Ersetzen Dialog erreichen. Ob Werte einzeln oder in einem Rutsch ersetzt werden, beeinflusst das anschließende Verhalten der Undo Funktion. Sämtliche durch Alle ersetzen ausgelösten Änderungen werden in einem Schritt zurückgenommen, Änderungen in Einzelschritten werden einzeln rückgängig gemacht.","hash":"figure_2.9","h4":"Abbildung 2.9: Der Rückfrage Dialog beim Ersetzen"},"62":{"id":62,"content":"Kompliziertere Such- und Ersetzungsvorgänge Manchmal ist eine einfache Suchoperation nicht ausreichend. Stellen Sie sich zum Beispiel vor, Sie wollen eine Wartezeit von 3000 Millisekunden für alle Check Text Knoten einer bestimmten Komponente setzen. Sie kennen die QF‑Test ID der Komponente, aber wenn Sie danach suchen erhalten Sie auch alle anderen Events und Checks für diese. Wenn Sie nach dem Knotentext 'Check Text' suchen, finden Sie dagegen die Check Text Knoten für alle Komponenten, nicht nur die für die gesuchte Komponente. Anstelle mehrerer kombinierbarer Ebenen von Suchkriterien bietet QF‑Test durch seine Marken völlige Flexibilität. Führen Sie zunächst eine Suche nach Ihrem ersten Kriterium durch, z.B. dem Knotentext und wählen Sie 'Ergebnisliste anzeigen'. Im folgenden Ergebnisdialog selektieren Sie durch drücken von Ctrl⁠+⁠A sämtliche Einträge in der Tabelle, wählen dann 'Setze Marke' um allen gefundenen Knoten die blaue Marke zuzuweisen und schließen den Dialog. Sie können nun eine weitere Suche oder einen Ersetzungsvorgang durchführen, dessen Gültigkeitsbereich auf Knoten mit einer bestimmten Marke beschränkt ist. In unserem Beispiel würden Sie nun den leeren Text durch '3000' ersetzen, und zwar auf alle Wartezeit Attribute von Knoten mit blauer Marke im gesamten Baum.","hash":"usec_tunesearch","h2":"Kompliziertere Such- und Ersetzungsvorgänge"},"63":{"id":63,"content":"Mehrere Ansichten Es können mehrere Fenster geöffnet werden, die verschiedene Teile der selben Baumstruktur gleichzeitig anzeigen. Dies kann beim Umgang mit großen Testsuiten oder zum Vergleichen von Attributen mehrerer Knoten nützlich sein. Zusätzliche Ansichten werden mittels »Ansicht«-»Neues Fenster...« geöffnet. Der aktuelle Knoten wird dabei zum Wurzelknoten für die neue Ansicht. Die Zusatzfenster sind analog zu den Hauptfenstern, jedoch mit eingeschränktem Funktionsumfang.","hash":"sec_mehrere_ansichten","h2":"Mehrere Ansichten"},"64":{"id":64,"content":"Toolbar-Buttons ausblenden Sie können die Zahl der angezeigten Knöpfe in der Werkzeugleiste reduzieren, indem Sie den Knopf, den Sie ausblenden wollen, mit der rechten Maustaste anklicken und im Kontextmenü »Aus Werkzeugleiste entfernen« auswählen. Um die ursprüngliche Ansicht wiederherzustellen, klicken Sie eine beliebige Stelle in der Werkzeugleiste und wählen »Ganze Werkzeugleiste anzeigen«. Wenn Sie alle Buttons ausgeblendet haben, wählen Sie unter »Anzeigen«-»Werkzeugleiste anzeigen«.","hash":"sec_toolbar_buttons_ausblenden","h2":"Toolbar-Buttons ausblenden"},"65":{"id":65,"content":"Pro Handbuch","hash":"","h0":"Schnellstart Ihrer Anwendung | QF‑Test Handbuch"},"66":{"id":66,"content":"Pro Handbuch","hash":"home-link","h0":"Schnellstart Ihrer Anwendung | QF‑Test Handbuch"},"67":{"id":67,"content":"Schnellstart Ihrer Anwendung Dieses Kapitel enthält eine Anleitung, wie Sie auf kürzestem Weg Ihre Anwendung als SUT (System Under Test) einrichten. Video-Anleitung für Java-Anwendungen: 'Der Schnellstart Assistent Java' Video-Anleitung für Web-Anwendungen: 'Der Schnellstart Assistent Web' Anleitung für Android-Anwendungen: Eine QF‑Test Startsequenz für Android Tests erzeugen. Anleitung für iOS-Anwendungen: QF‑Test Vorbereitung Sequenz für iOS Tests. Damit Ihre Anwendung von QF‑Test als SUT wahrgenommen wird, muss sie im einfachen Fall aus QF‑Test heraus gestartet werden. Es gibt eine Anzahl von speziellen Prozessknoten unter »Einfügen«-»Prozess Knoten«, um diese Aufgabe zu erfüllen. Der empfohlene, komfortablere und sichere Weg ist jedoch die Benutzung des Schnellstart-Assistenten, der gleich im Anschlusskapitel beschrieben wird. Wer jedoch eine strikte Abneigung gegen Assistentendialoge hat, für den wird der händische Weg in \"Verschiedene Methoden zum Starten des SUT\" beschrieben. Eine Voraussetzung für das Testen von Java basierten SUTs ist, dass sich QF‑Test in das GUI-Toolkit einklinken kann: Für reine Swing-Anwendungen oder Kombinationen aus Swing und SWT hängt sich QF‑Test in die JVM Tools Schnittstelle von Java ein. QF‑Test kann dies normalerweise direkt, nur für spezielle JDKs kann es nötig sein, diese zunächst zu instrumentieren. Details dazu finden Sie in Deinstrumentieren eines JRE. Für JavaFX und entsprechende Kombinationen wird die Verbindung über den QF‑Test Agent hergestellt. Bitte stellen Sie sicher, dass die Option Über QF‑Test Agent verbinden aktiviert ist. Für das Testen von SWT oder Eclipse basierten Anwendungen kann eine Instrumentierung der SWT Bibliothek erforderlich sein. Der im folgenden beschriebene Schnellstart-Assistent baut bei Bedarf einen entsprechenden Schritt in die Startsequenz ein. Detaillierte technisch Informationen hierzu finden Sie in \"SWT-Instrumentierung\". Das Testen von Web-Anwendungen erfordert keine Instrumentierung, jedoch gibt es Einschränkungen zu beachten, die in \"Webseiten testen\" näher beschrieben sind.","hash":"usec_quickstart","h0":"Schnellstart Ihrer Anwendung"},"68":{"id":68,"content":"Erzeugung der Startsequenz - Schnellstart-Assistent QF‑Test bietet Ihnen mit dem Schnellstart-Assistenten einen komfortablen Weg zum Erzeugen einer Startsequenz, um Ihre Applikation als SUT zu betreiben. Den Schnellstart-Assistenten können Sie über den Menüeintrag »Extras«-»Schnellstart-Assistent...« oder den Knopf in der Werkzeugleiste aufrufen. Er führt Sie Schritt für Schritt durch die Erstellungsprozedur der Startsequenz und sollte selbsterklärend sein.","hash":"usec_quickstart_wizard","h1":"Erzeugung der Startsequenz - Schnellstart-Assistent"},"69":{"id":69,"content":"Abbildung 3.1: Der Schnellstart-Assistent Als Resultat liefert der Assistent unter dem Knoten \"Extrasequenzen\" eine Sequenz \"Vorbereitung\" zum Starten Ihrer Anwendung, ähnlich der, wie sie im folgenden Bild gezeigt wird:","hash":"figure_3.1","h4":"Abbildung 3.1: Der Schnellstart-Assistent"},"70":{"id":70,"content":"Abbildung 3.2: Startsequenz als Resultat des Schnellstart-Assistenten Die erstellte Vorbereitungssequenz sieht je nach Typ der Applikation unterschiedlich aus, sie folgen aber alle einen gewissen Aufbau. Zuerst finden Sie einen Variable setzen Knoten, der den Namen des SUT-Clients für QF‑Test festlegt. Danach wird ein Warten auf Client Knoten erstellt, der prüft, ob das SUT bereits läuft. Dessen Ergebnis wird im darauf folgenden If Knoten verwendet, in dem das SUT gestartet wird. Der Start erfolgt mittels eines Startknotens, dessen Typ und Attribute von der Art Ihrer Applikation abhängen, gefolgt wiederum von einem Warten auf Client Knoten, welcher überprüft, dass während des Startvorgangs eine Verbindung zwischen Ihrer Applikation und QF‑Test zustande kommt. (Details zu den Startknoten für die verschiedenen Anwendungstypen finden Sie in \"Verschiedene Methoden zum Starten des SUT\".) Bei SWT basierten Anwendungen wird zusätzlich ein Prozeduraufruf für die SWT-Instrumentierung eingefügt. Die Startsequenz für Web enthält zusätzliche Knoten zum Setzen von Variablen, zur Initialisierung des Browser-Cache und der Einstellungen für Cookies und ggf. zur Installation eines Toolkit-Resolvers. Weitere Information finden Sie in \"Webseiten testen\".","hash":"figure_3.2","h4":"Abbildung 3.2: Startsequenz als Resultat des Schnellstart-Assistenten"},"71":{"id":71,"content":"Ausführen der Startsequenz Die Startsequenz kann nun direkt von Ihnen gestartet werden, in dem Sie den grünen Vorbereitungsknoten im Baum auswählen und den Knopf \"Wiedergabe starten\" in der Werkzeugleiste drücken. Ihre Applikation sollte dabei ordnungsgemäß gestartet und der rote \"Aufnahme starten\" Knopf in der QF‑Test Werkzeugleiste aktiv werden. Letzteres zeigt an, dass QF‑Test erfolgreich die Verbindung zum SUT hergestellt hat. Nun sind Sie bereit, Ihre ersten Testsequenzen aufzunehmen und wieder ablaufen zu lassen, so wie es in \"Aufnahme und Wiedergabe\" beschrieben ist. Im Hilfemenü finden Sie das sehr empfehlenswerte Learning-by-doing Tutorial, welches Sie Schritt für Schritt durch die Anwendungskonzepte von QF‑Test führt. Sollten Sie wider Erwarten eine Fehlermeldung bekommen oder der rote \"Aufnahme starten\" Knopf inaktiv bleiben, dann gehen Sie bitte zum folgenden Abschnitt.","hash":"sec_ausfuhren_der_startsequenz","h1":"Ausführen der Startsequenz"},"72":{"id":72,"content":"Wenn sich der Client nicht verbindet ... Falls Ihre Anwendung (oder das Browser-Fenster im Falle des Testens von Web-Anwendungen) nicht erscheint: Der Fehlerdialog, den QF‑Test im Regelfall anzeigt, sollte eine erste Beschreibung liefern. Suchen Sie bitte im Terminal-Fenster nach Fehlermeldungen. Wenn das Terminal nicht im unteren Bildbereich von QF‑Test sichtbar ist, können Sie es über das Menü »Ansicht«-»Terminal«-»Anzeigen« aktivieren. Weitere Informationen zur Programmausgabe finden Sie auch in \"Programmausgaben und das Clients Menü\". Überprüfen Sie die Attribute der Knoten in der Startsequenz nochmals auf Korrektheit. Vielleicht hat sich irgendwo ein Tippfehler eingeschlichen. Details zu den Startknoten für die verschiedenen Anwendungstypen finden Sie in \"Verschiedene Methoden zum Starten des SUT\". Da die Entwicklungszyklen von Browsern, besonders bei Firefox, immer kürzer werden, stellen Sie sicher, dass der installierte Browser von der von Ihnen genutzten QF‑Test Version unterstützt wird. Die Ausgabe im Terminal-Fenster sollte eine entsprechende Fehlermeldung zeigen. Siehe \"Unterstützte Technologien - zu testende Systeme\" für den letzten Stand der unterstützten Browser Versionen. Ggf. müssen Sie QF‑Test auf einen neuere Version updaten oder temporär mit einem anderen Browser arbeiten. Weitere Informationen finden Sie in \"Webseiten testen\". Falls das SUT erscheint, aber der Aufnahmeknopf inaktiv bleibt: Überprüfen Sie bitte die Ausgabe im Terminal (siehe oben) auf mögliche Fehlermeldungen. Sollte der rote Aufnahmeknopf nach Erscheinen des Fehlerdialogs \"Keine Verbindung zum Client\" doch noch aktiv werden, muss ggf. der Timeout Wert im Warten auf Client Knoten erhöht werden. Für eine Eclipse/SWT-Anwendung stellen Sie zunächst sicher, dass Sie das korrekte Verzeichnis für die Anwendung angegeben haben. Eventuell hilft ein Blick auf das Protokoll (siehe \"Das Protokoll\") um zu sehen, ob bei der Ausführung der Prozedur qfs.swt.instrument.setup Fehler oder Warnungen ausgegeben wurden. Überprüfen Sie das allgemein das Protokoll auf mögliche Fehlerindikatoren (siehe \"Das Protokoll\"). Nach möglichen Anpassungen an Testsuite oder Einstellungen können Sie ein erneutes Ausführen der Startsequenz probieren. Sollten Sie mit den hier gegebenen Hinweisen nicht weiter kommen, können Sie ggf. die Beispiel-Testsuite aus dem Tutorial ausprobieren oder Sie kontaktieren unseren Support.","hash":"troubleshooting","h1":"Wenn sich der Client nicht verbindet ..."},"73":{"id":73,"content":"Programmausgaben und das Clients Menü Die Ausgaben aller von QF‑Test gestarteten Prozesse werden von QF‑Test umgeleitet und im Protokoll unter dem Knoten gespeichert, der den Prozess gestartet hat. Dabei macht QF‑Test keinen Unterschied zwischen SUT Clients und sonstigen Prozessen oder Shellskripten, die mittels eines Programm starten oder Shell-Kommando ausführen Knotens gestartet wurden. Das Hauptfenster enthält ein gemeinsames Terminal für die Ausgaben aller Prozesse, die von einem Test aus diesem Fenster gestartet wurden. Das Untermenü »Ansicht«-»Terminal« enthält einige Menüeinträge, mit deren Hilfe Sie das Terminal ein- und ausschalten oder festlegen können, ob Baum oder Terminal den Bereich links unten nutzen sollen, ob lange Zeilen umgebrochen werden und ob automatisch an das Ende gescrollt werden soll, wenn neue Ausgaben eintreffen. Außerdem können Sie das Terminal löschen oder seinen Inhalt in eine Datei speichern. Die maximale Größe des Terminals wird über die Option Maximalgröße des gemeinsamen Terminals (kB) festgelegt. Zusätzlich zum gemeinsamen Terminal gibt es für jeden aktiven Prozess und die letzten beendeten Prozesse ein individuelles Terminalfenster, das ebenfalls die Ausgaben des Prozesses anzeigt. Terminalfenster sind über das »Clients« Menü zugänglich. Das gemeinsame Terminal dient hauptsächlich dazu, auf das Eintreffen neuer Ausgaben aufmerksam zu machen, während die individuellen Terminalfenster besser zum gründlichen Studieren der Ausgaben geeignet sind. Über das »Clients« Menü können Prozesse auch beendet werden, entweder einzeln oder alle auf einmal mittels »Clients«-»Alle Clients beenden«. Die Anzahl der beendeten Prozesse, die im »Clients« Menü verfügbar sind, wird über die Option Wie viele beendete Clients im Menü festgelegt (Standard ist 4). Wenn Ihre Prozesse sehr viele Ausgaben erzeugen, kann es sinnvoll sein, diese Zahl zu reduzieren um Speicher zu sparen. Das »Clients« Menü ist auch hilfreich, wenn man nicht sicher ist, welches spezifische QF‑Test Produkt man kaufen soll. Die von Ihrer Anwendung genutzten GUI-Technologien werden neben dem aktiven Client-Namen in '[ ]' dargestellt. Das Beispiel unten zeigt zwei Clients, die Java Swing bzw. Web benutzen, was nahelegt eine QF‑Test/swing+web Lizenz zu erwerben.","hash":"usec_clientterminal","h1":"Programmausgaben und das Clients Menü"},"74":{"id":74,"content":"Abbildung 3.3: Information zu genutzten GUI-Technologien","hash":"figure_3.3","h4":"Abbildung 3.3: Information zu genutzten GUI-Technologien"},"75":{"id":75,"content":"Indirektes Starten eines zweiten SUT als Kindprozess eines bereits verbundenen SUT Wird eine zweite Java-VM aus einem bereits verbundenen SUT gestartet, erkennt QF‑Test beim Verbindungsaufbau, dass es sich um einen Kindprozess des ersten SUT handelt und vergibt automatisch einen neuen Client-Namen. Hierzu wird dem Namen des ersten SUT ':2' angefügt, was betont, dass es sich um den zweiten Prozess für diesen Client handelt. Einem weiteren derart gestarteten SUT wird ':3' an den Namen angefügt, es sei denn, das zweite SUT ist bereits beendet, so dass ':2' wieder verfügbar ist. Eine Sequenz zum indirekten Start eines SUT besteht also üblicherweise aus einem Event Knoten der z.B. einen Buttonklick oder eine Menüauswahl auslöst und das erste SUT zum Start des zweiten SUT veranlasst, gefolgt von einem Warten auf Client Knoten für den um ':2' erweiterten Client-Namen.","hash":"usec_startindirect","h1":"Indirektes Starten eines zweiten SUT als Kindprozess eines bereits verbundenen SUT"},"76":{"id":76,"content":"Pro Handbuch","hash":"","h0":"Aufnahme und Wiedergabe | QF‑Test Handbuch"},"77":{"id":77,"content":"Pro Handbuch","hash":"home-link","h0":"Aufnahme und Wiedergabe | QF‑Test Handbuch"},"78":{"id":78,"content":"Aufnahme und Wiedergabe Wenn das SUT erst einmal unter QF‑Test läuft, ist der nächste Schritt, Testsequenzen aufzunehmen und wieder abzuspielen. Die Aufnahme und das Abspielen von Sequenzen ist auch in dem Video 'Capture und Replay' erläutert. Im Video 'Erstellung eines Testfalls' sehen Sie wie ein Testfall erstellt wird. Bei Android- und iOS-Applikationen läuft die Aufnahme über ein spezielles Aufnahmefenster. Wenn im Folgenden Aktionen im SUT erwähnt werden, beziehen sich diese bei Android und iOS auf das Aufnahmefenster. Weitere Informationen zum Aufnahmefenster finden Sie für Android in \"Aktionen und Checks auf der Android-App aufnehmen\", für iOS in \"Aufnamen und Checks bei iOS\".","hash":"usec_capturereplay","h0":"Aufnahme und Wiedergabe"},"79":{"id":79,"content":"Aufnahme von Testsequenzen Um eine Sequenz von Events im SUT aufnehmen zu können, muss das SUT aus QF‑Test heraus gestartet worden sein (vgl.\"Starten einer Applikation aus QF‑Test\") und die Verbindung zum SUT muss bestehen. Letzteres ist an Hand des Aufnahmeknopfs zu erkennen, der rot dargestellt wird, wenn er aktivierbar ist.","hash":"usec_recording","h1":"Aufnahme von Testsequenzen"},"80":{"id":80,"content":"Abbildung 4.1: Gesperrter und aktivierbarer Aufnahmeknopf Um eine Sequenz aufzunehmen, starten Sie die Aufnahme einfach mittels des Aufnahmeknopfs oder »Aufnahme«-»Start«. Wechseln Sie dann zum SUT und führen Sie einige Kommandos aus. Schalten Sie dann zurück zu QF‑Test und beenden Sie die Aufnahme mit dem Stopknopf oder »Aufnahme«-»Stop«. Die aufgezeichneten Events werden in die Testsuite eingefügt, entweder direkt an der Einfügemarkierung, oder als neue Sequenz unterhalb des Extrasequenzen Knotens, je nach Einstellung der Option Aufnahme bei aktueller Selektion einfügen. Sie können die Aufnahme mit »Aufnahme«-»Pause« oder dem Pausenknopf unterbrechen, wenn Sie einige Schritte im SUT ausführen wollen, die nicht aufgezeichnet werden sollen. Der Aufnahmemodus kann auch direkt im SUT über den Hotkey für Aufnahme gestartet und gestoppt werden. Standardmäßig ist diese Taste F11. Alle Komponenten, auf die sich die aufgezeichneten Events beziehen, werden automatisch unterhalb des Fenster und Komponenten Knotens in die Testsuite integriert, falls sie dort noch nicht vorhanden sind. Es gibt viele Optionen, die die Aufnahme von Events und die Verwaltung von GUI-Komponenten beeinflussen. Diese werden ausführlich in \"Aufnahme\" des Referenzteils erläutert. Wenn Sie sich mit QF‑Test vertraut gemacht haben, sollten Sie sich die Zeit nehmen und sich zumindest einen Überblick über diese Optionen verschaffen. Es folgen einige allgemeine Tipps zum Aufnehmen: Nehmen Sie nur kurze Sequenzen am Stück auf. Sehen Sie sich jede neu aufgenommene Sequenz an, versuchen Sie zu verstehen, was Sie erhalten haben und ob es Ihren Aktionen im SUT entspricht. Bearbeiten Sie die Sequenz, um überflüssige Events zu entfernen, insbesondere solche, die von den Wechseln zwischen dem SUT und QF‑Test stammen. QF‑Test hat ausgezeichnete Filter für solche Events. Dennoch können einzelne Events übrigbleiben, die von Hand entfernt werden müssen. Schließlich sollten Sie ausprobieren, ob die neue Sequenz korrekt abgespielt wird. Anschließend können Sie diese weiterbearbeiten und zu größeren Tests zusammensetzen. Für SUTs, die auf Mac OS X laufen, wird die Benutzung der Bildschirm-Menüleiste unterdrückt und die normale Menüleiste aktiviert, äquivalent wie auf anderen Plattformen. Grund dafür ist, dass QF‑Test die Bildschirm-Menüleiste nicht vollständig ansprechen kann, was sauberes Aufnehmen/Wiedergeben von Menüaktionen verhindert. Falls das typische Mac Verhalten der Bildschirm-Menüleiste aus irgendwelchen Gründen erforderlich sein sollte, kann es durch das Hinzufügen der Zeile qfs.apple.noScreenMenuBar=false in der Datei qfconnect.properties, die sich im Wurzelverzeichnis von QF‑Test befindet, erzwungen werden. Nach einem Neustart zeigt das SUT dann das für den Mac übliche Verhalten. Bitte beachten Sie bei nativen Windows-Applikationen auch \"Aufnahme\".","hash":"figure_4.1","h4":"Abbildung 4.1: Gesperrter und aktivierbarer Aufnahmeknopf"},"81":{"id":81,"content":"Abspielen von Tests Um einen oder mehrere Test abzuspielen, markieren Sie den oder die entsprechenden Knoten und drücken Sie Return oder den Start Knopf oder wählen Sie »Wiedergabe«-»Start«. QF‑Test hebt Knoten, die gerade ausgeführt werden, durch einen kleinen Pfeil hervor. Außerdem werden Meldungen über den Fortschritt des Tests in der Statuszeile ausgegeben. Beides kann die Geschwindigkeit der Testausführung leicht verringern und ist über die Optionen Aktive Schritte markieren und Aktive Schritte in der Statuszeile anzeigen abschaltbar. Nach dem Ende des Tests wird das Ergebnis in der Statuszeile angezeigt. Im Idealfall steht dort \"Wiedergabe beendet - keine Fehler\". Andernfalls wird die Zahl der Warnungen, Fehler und Exceptions angezeigt. Im Fehlerfall wird zusätzlich ein entsprechender Meldungsdialog geöffnet. Auch das Abspielen von Tests wird von zahlreichen Optionen gesteuert. Einige dienen lediglich zur Anpassung an persönliche Vorlieben, während andere starken Einfluss auf den Ausgang von Tests haben. Bitte lesen Sie \"Wiedergabe\", um sich mit diesen Optionen vertraut zu machen. Um einen Testlauf vorzeitig Abzubrechen, drücken Sie den Stop Button oder wählen Sie »Wiedergabe«-»Stop«. Sie können den Test auch mittels des Pause Buttons oder »Wiedergabe«-»Pause« vorübergehend unterbrechen, wodurch auch der Debugger aktiviert wird (vgl. Problemanalyse und Debugging). Zum Fortsetzen drücken Sie erneut den Pause Button. Wenn ein Test in vollem Tempo abläuft, kann es schwierig werden ihn anzuhalten, insbesondere wenn der Mauszeiger über den Bildschirm mitbewegt wird oder die Fenster des SUT ständig nach vorne gebracht werden. Mit Hilfe der Hotkey für Wiedergabe unterbrechen (\"Keine Panik\"-Taste) (Standard ist Alt⁠+⁠F12) können Sie die Kontrolle wiedererlangen. Alle laufenden Tests werden sofort unterbrochen. Zum Fortsetzen drücken Sie die selbe Kombination ein weiteres mal. Beim Zusammenstellen einer Testsuite müssen immer wieder Teile von Tests ausgeführt werden, um das SUT in den richtigen Zustand für die nächste Aufnahme zu bringen. Dabei können andere Teile eher hinderlich sein. Ebenso gibt es oft langwierige Sequenzen, die beim Ausprobieren eher im Weg sind. Mittels »Bearbeiten«-»Ein-/Ausschalten« können Sie solche Knoten deaktivieren und später für den eigentlichen Testlauf wieder einschalten. Den aktuellen Fehlerstatus während des Ablaufs eines Tests wie auch das abschließende Resultat zeigt QF‑Test in der Statusleiste am unteren Rand des Hauptfensters an. Letztere kann über das Menü »Ansicht«-»Statuszeile anzeigen« ein- bzw. ausgeblendet werden. Bei der Wiedergabe von Testfallsatz oder Testfall Knoten, deren Bedeutung in \"Testfallsatz und Testfall Knoten\" erklärt wird, enthält die Statuszeile auch relevante Ergebniswerte aus folgender Liste:","hash":"usec_executing","h1":"Abspielen von Tests"},"82":{"id":82,"content":"Zählersymbol Beschreibung Anzahl der Testfälle insgesamt. Diese Zählerwert beginnt mit einem '>'-Zeichen im Fall von übersprungenen Testfallsätzen. Anzahl Testfälle mit Exceptions. Anzahl Testfälle mit Fehlern. Anzahl Testfälle mit erwarteten Fehlern. Fehlschlagen erwartet wenn... markiert einen Testfall als erwartet fehlerhaft. Anzahl erfolgreicher Testfälle. Anzahl übersprungene Testfälle. Ein Testfall wird übersprungen, wenn seine (optionale) Bedingung fehlschlägt. Diese Zählerwert beginnt mit einem '>'-Zeichen im Fall von übersprungenen Testfallsätzen. Anzahl übersprungene Testfallsätze. Ein Testfallsatz wird übersprungen, wenn seine (optionale) Bedingung fehlschlägt. Anzahl nicht implementierter Testfälle. Ein Testfall gilt als nicht implementiert, wenn er keine Knoten enthält, die während des Testlaufs aufgeführt wurden. Anzahl ausgeführter Testfälle. Prozent Testfälle erfolgreich. Tabelle 4.1: Testresultate in der Statusleiste Die finalen Zählerstände finden sich auch im Report wieder, der für jeden Testlauf generiert werden kann. Reports sind Thema von \"Reports und Testdokumentation\". Die Zählerwerte von oben stehen auch als Variablen während dem Testlauf zur Verfügung. Ein TestRunListener kann hilfreich sein, um die Zählerwerte während des Testlaufs auszuwerten und entsprechende Aktionen anzustoßen.","hash":"table_4.1","h1":"Abspielen von Tests"},"83":{"id":83,"content":"Aufnehmen von Checks Auch wenn es ganz unterhaltsam sein kann, Sequenzen aufzuzeichnen und dem Spiel der Fenster des SUT beim Wiederabspielen zuzusehen, geht es doch eigentlich darum herauszufinden, ob sich das SUT dabei auch korrekt verhält. Diese Aufgabe übernehmen Checks. Der Check Text Knoten zum Beispiel, liest den Text aus einer Komponente aus und vergleicht ihn mit einem vorgegebenen Wert. Stimmen diese nicht überein, wird ein Fehler signalisiert. Eine Aufstellung aller möglichen Checks und ihrer Funktionsweisen findet sich im Referenzteil. Die Palette reicht vom einfachen Text-Check bis zum mächtigen Check Abbild mit Suchalgorithmen bis hin zur Möglichkeit eigene Check-Typen zu implementieren. Im Weiteren werden wir uns darauf konzentrieren, wie man Checks am einfachsten erstellt, nämlich indem man sie aufnimmt. Während der Aufnahme befindet sich das SUT im Aufnahmemodus, in dem alle Events gesammelt und an QF‑Test geschickt werden. Über den Check Button oder mittels »Aufnahme«-»Check« schalten Sie das SUT in den Checkmodus, zu erkennen am geänderten Mauszeiger. In diesem Modus werden Events nicht weiter aufgezeichnet. Stattdessen wird die Komponente unter dem Mauszeiger hervorgehoben. Wenn Sie auf eine Komponente klicken, wird ein Check für diese aufgezeichnet. Der aktuelle Wert der Komponente wird dabei als Maßgabe verwendet. Um zurück in den Aufnahmemodus zu gelangen, verwenden Sie ebenfalls den Check Button oder den Menüeintrag. Es gibt verschiedene Arten von Checks, die man für eine Komponente vornehmen kann. Welche davon in Frage kommen, hängt von der jeweiligen Komponente ab. So stellen manche Komponenten keinen Text dar, so dass z.B. ein Check Text Knoten für einen Scrollbar keinen Sinn ergibt. Wenn Sie im Checkmodus mit der rechten Maustaste auf eine Komponente klicken, erhalten Sie ein Menü mit allen für diese Komponente zur Verfügung stehenden Arten von Checks. In diesem können Sie den gewünschten Check auswählen. Ein Klick mit der linken Maustaste zeichnet dagegen direkt den ersten Check aus dieser Liste auf. Wenn Sie die Shift oder Strg Taste gedrückt halten, während Sie mit der rechten Maustaste klicken, bleibt das Auswahlmenü für die Checks auch nach einer Selektion offen. Dadurch können Sie sehr einfach mehrere verschiedene Checks für die selbe Komponente aufnehmen. Checks und Events lassen sich sehr gut mischen und Sie werden bald einen Aufnahmestil ala klick, klick, tipp, check, klick, klick, check... entwickeln. Dabei ständig zwischen dem SUT und QF‑Test hin- und herzuschalten um den Checkmodus zu (de)aktivieren, ist mehr als mühsam. Stattdessen können Sie mittels einer Tastenkombination direkt im SUT zwischen Aufnahmemodus und Checkmodus hin- und herzuschalten. Standardmäßig ist diese Taste F12. Ist diese Taste anderweitig belegt, oder lässt Ihr Windowmanager diese gar nicht erst bis zur Applikation durch, können Sie über die Option Hotkey für Checks eine beliebige andere Tastenkombination dafür wählen. Um eine Sequenz mit eingestreuten Checks aufzunehmen, müssen Sie nun nur noch die Aufnahme starten, zum SUT wechseln und die Sequenz aufnehmen. Wann immer Sie einen Check einbauen wollen, drücken Sie F12 (oder was immer Sie konfiguriert haben) und nehmen Sie den Check (oder die Checks) auf. Schalten Sie dann mit F12 wieder zurück, um mit der Aufnahme fortzufahren. Auf diese Weise können Sie komplett im SUT arbeiten und müssen lediglich zu QF‑Test zurückschalten, um die Aufnahme zu beenden. Achtung: Lassen Sie sich durch diese Annehmlichkeiten nicht dazu verführen, allzu lange Sequenzen aufzunehmen. Wenn sich am SUT etwas ändert, das dazu führt dass eine solche Sequenz nicht mehr durchläuft, kann es sehr mühsam werden, herauszufinden was schiefgegangen ist und die Sequenz entsprechend anzupassen.","hash":"usec_recordchecks","h1":"Aufnehmen von Checks"},"84":{"id":84,"content":"Daten aus der GUI auslesen Oft ist es notwendig, einen Wert aus der Oberfläche des SUT auszulesen, um diese als Eingabe für den Test zu verwenden. QF‑Test bietet für diese Aufgabe einen speziellen Satz von Abfrageknoten, verfügbar unter »Einfügen«-»Verschieden Knoten«: Text auslesen zum Auslesen des Komponenten- oder Elementtextes, Index auslesen zum Auslesen des Elementindex, Geometrie auslesen zum Auslesen des Komponenten- oder Elementgeometrie. Die ermittelten Werte werden lokalen oder globalen Variablen zugewiesen, die im Abfragekonten deklariert werden können. Anstatt einen Abfrageknoten per Hand einzufügen, kann ein solcher leichter erzeugt werden, indem man erst einen Mausklick-Knoten auf die gewünschte Komponente aufzeichnet und diesen dann mit Hilfe der Konvertierungsoperation in den gewünschten Abfrageknoten umwandelt.","hash":"usec_fetching_data","h1":"Daten aus der GUI auslesen"},"85":{"id":85,"content":"Komponenten aufnehmen Wie bereits erwähnt wird Komponenteninformation automatisch mitgespeichert wenn Events oder Checks aufgenommen werden. Trotzdem gibt es Situationen in denen die Aufnahme von Komponenten alleine hilfreich ist. Um den Modus zum Komponentenaufnehmen zu starten, braucht nur der Komponentenaufnahme-Knopf gedrückt oder »Aufnahme«-»Komponenten aufnehmen« gewählt werden. Bei dem anschließenden Wechsel zum Fenster des SUT zeigt sich dort ein besonderes Verhalten, in welchem die Komponente unter dem Mauszeiger hervorgehoben wird. Ein Klick mit der linken Maustaste auf eine Komponente zeichnet diese auf, während bei einem Klick mit der rechten Maustaste ein Menü mit weiteren Möglichkeiten geöffnet wird, z.B. um eine Komponente mit seinen Kinder oder auch alle Komponenten eines Fensters aufzunehmen. In dieser Weise können mehrere Komponenten erfasst werden. Als nächstes wechselt man zurück zu QF‑Test und deaktiviert den Komponentenaufnahme-Knopf oder den »Aufnahme«-»Komponenten aufnehmen« Menüeintrag. Nun werden die gespeicherten Komponenteninformationen in Form von Komponente Knoten unter dem Fenster und Komponenten Knoten abgelegt. Die Aufnahme von Komponenten kann alternativ mit einer konfigurierbaren Tastenkombination gesteuert werden. Durch Drücken von Shift⁠+⁠F11 (Standardeinstellung) im Fenster des SUTs wird die Komponentenaufnahme aktiviert. Weitere Informationen finden Sie in der Dokumentation zur Option Hotkey für Komponenten. Nur jeweils eine Testsuite kann die aufgezeichneten Komponenten in Empfang nehmen. Haben Sie mehrere Testsuiten in individuellen Fenster geöffnet, wenn also die Workbench-Ansicht deaktiviert ist, so erhält die Suite die Komponenten, in der die Komponentenaufnahme (mittels Knopf oder Menü) gestoppt wird oder - falls Shift⁠+⁠F11 verwendet wurde, die Suite, die über den Menüeintrag »Aufnahme«-»Suite ist Empfänger für Aufnahmen« festgelegt werden kann. Das Feature der Komponentenaufnahme kann auch dazu verwendet werden, schnell eine Komponente aufzufinden, egal ob sie schon aufgezeichnet wurde oder nicht. Beim Anlegen von Event- oder Checkknoten von Hand oder beim Ändern der Zielkomponente, muss diese im Attribut QF‑Test ID der Komponente angegeben werden. Wird eine Komponente aufgezeichnet, steht ihre QF‑Test ID anschließend im Clipboard und kann mittels Strg⁠+⁠V direkt in das Feld für die QF‑Test ID der Komponente eingefügt werden. Außerdem können Sie mittels Strg⁠+⁠Umschalt⁠+⁠Backspace oder über den Menüeintrag »Bearbeiten«-»Nächsten Knoten anwählen« oder den entsprechenden Button in der Werkzeugleiste direkt zum aufgenommenen Komponente Knoten springen. Das Popup-Menü, das erscheint, wenn man mit der rechten Maustaste auf eine Komponente klickt, enthält auch einen Eintrag »Im Inspektor anzeigen«, der es erlaubt, Komponenten zu untersuchen, sowie einen Eintrag »Methoden anzeigen«, mit dem man eine Übersicht der Methoden des GUI-Elements erhält, (siehe \"Komponenten untersuchen\"). Komponenten spielen in der Struktur einer Testsuite eine zentrale Rolle, auf die in \"Komponenten\" näher eingegangen wird.","hash":"usec_componentrecording","h1":"Komponenten aufnehmen"},"86":{"id":86,"content":"HTTP-Requests aufnehmen (GET/POST) Um einen vom SUT gesendeten (GET/POST) Request aufnehmen zu können, muss das SUT aus QF‑Test heraus gestartet worden sein (vgl.\"Starten einer Applikation aus QF‑Test\") und die Verbindung zum SUT muss bestehen. Während der Aufnahme befindet sich das SUT im Aufnahmemodus, in dem alle Events gesammelt und an QF‑Test geschickt werden. Über »Aufnahme«-»HTTP-Requests aufnehmen« schalten Sie das SUT in den Request Aufnahme Modus. In diesem speziellen Aufnahme-Modus werden im Gegensatz zum bereits beschriebenen Aufnehmen von Testsequenzen alle vom Webbrowser gesendeten GET bzw. POST Request als spezielle Knoten gespeichert. Um zurück in den Aufnahmemodus zu gelangen, verwenden Sie ebenfalls den Menüeintrag. Im Abschnitt Web-Optionen wird beschrieben wie der Typ des aufgenommenen Requests beeinflusst werden kann. Standardmäßig wird ein Browser-HTTP-Request erzeugt. Dieser eignet sich zum Automatisieren größerer Formulareingaben, da keine separaten Eingabeknoten verwendet werden müssen. Die Formulardaten werden direkt im Browser abgesendet und der erhaltene Response dargestellt. An dieser Stelle kann der Testablauf direkt im Browser weitergeführt werden. Der Server-HTTP-Request wird hingegen direkt durch QF‑Test abgesendet. Der Response steht nur in QF‑Test zur Verfügung und beeinflusst den Browser nicht. Die Attribute eines entsprechend aufgezeichneten HTTP-Request Knotens oder auch die Parametrisierung von Requests sind ausführlich im Abschnitt HTTP-Requests des Referenzteils erläutert.","hash":"usec_requestrecording","h1":"HTTP-Requests aufnehmen (GET/POST)"},"87":{"id":87,"content":"Pro Handbuch","hash":"","h0":"Komponenten | QF‑Test Handbuch"},"88":{"id":88,"content":"Pro Handbuch","hash":"home-link","h0":"Komponenten | QF‑Test Handbuch"},"89":{"id":89,"content":"Komponenten Auch wenn man sie oft gar nicht bemerkt - zumindest bis die erste ComponentNotFoundException auftritt - sind die Komponenten das Herz einer Testsuite, denn die stabile Erkennung von Komponenten ist die zentrale Herausforderung an ein gutes GUI Testtool. Um das meiste kümmert sich QF‑Test automatisch selbst, jedoch erfordern manche Situationen manuelle Definitionen oder Eingriffe. Deshalb ist das Verständnis von Komponenten und deren Abbildung und Behandlung in QF‑Test sehr wichtig. Die Grundlagen sollen in diesem Kapitel erläutert werden. Videos Das Video 'Komponentenerkennung' erläutert zunächst die Wiedererkennungskriterien für Komponenten. Danach (ab Minute 13:07) werden generische Komponenten erläutert, zuerst solche mit regulären Ausdrücken, danach solche mit Variablen für die Wiedererkennungsmerkmale. Es gibt zwei Videos, die die Behandlung einer ComponentNotFoundException ausführlich erklären: 'ComponentNotFoundException - einfacher Fall' 'ComponentNotFoundException - komplexer Fall' Das Video 'Die Explosion der Komplexität in der Web Testautomatisierung eindämmen' zeigt eindrucksvoll den Umgang von QF‑Test mit tief geschachtelten DOM-Strukturen. Video-Mitschnitt des Spezialwebinars 'Komponentenerkennung'. Aktionen im GUI und Komponenten Aktionen, die der Anwender auf den Komponenten eines GUI ausführt, werden von QF‑Test in Events umgewandelt. Jeder Event hat eine Zielkomponente. Für einen Mausklick ist das die Komponente unter dem Mauszeiger, für einen Tastendruck die Komponente, die den Tastaturfokus (keyboard focus) besitzt. Wenn QF‑Test einen Event aufzeichnet, nimmt es zusätzlich Informationen über die Zielkomponente auf, so dass der Event später wieder für die gleiche Komponente abgespielt werden kann. Wiedererkennung Die Wiedererkennung von Komponenten ist einer der komplexesten Teile von QF‑Test. Der Grund dafür liegt in der Notwendigkeit, mit einem gewissen Grad an Veränderungen zurechtzukommen. QF‑Test ist als Werkzeug für die Durchführung von Regressionstests ausgelegt. Wird eine neue Version des SUT getestet, sollten bestehende Tests idealerweise unverändert durchlaufen. Folglich muss sich QF‑Test an ein möglicherweise geändertes GUI anpassen können. Würden z.B. die \"OK\" und \"Abbrechen\" Knöpfe vom unteren Rand der Detailansicht nach oben verschoben, würde QF‑Test Events für diese Knöpfe immer noch korrekt wiedergeben. Das Ausmaß an Änderungen, an die sich QF‑Test anpassen kann, hängt von den zur Verfügung stehenden Wiedererkennungskriterien ab. An dieser Stelle kann die Entwicklung häufig mit relativ geringem Aufwand einen großen Beitrag zur Erstellung robuster Regressionstests leisten.","hash":"usec_components","h0":"Komponenten"},"90":{"id":90,"content":"Die Wiedererkennung von Komponenten ist einer der komplexesten Teile von QF‑Test. Der Grund dafür liegt in der Notwendigkeit, mit einem gewissen Grad an Veränderungen zurechtzukommen. QF‑Test ist als Werkzeug für die Durchführung von Regressionstests ausgelegt. Wird eine neue Version des SUT getestet, sollten bestehende Tests idealerweise unverändert durchlaufen. Folglich muss sich QF‑Test an ein möglicherweise geändertes GUI anpassen können. Würden z.B. die \"OK\" und \"Abbrechen\" Knöpfe vom unteren Rand der Detailansicht nach oben verschoben, würde QF‑Test Events für diese Knöpfe immer noch korrekt wiedergeben. Das Ausmaß an Änderungen, an die sich QF‑Test anpassen kann, hängt von den zur Verfügung stehenden Wiedererkennungskriterien ab. An dieser Stelle kann die Entwicklung häufig mit relativ geringem Aufwand einen großen Beitrag zur Erstellung robuster Regressionstests leisten. Für die Komponentenerkennung stehen die folgenden Kriterien zur Verfügung: Klasse, korreliert mit der Funktion der Komponente Name, basierend auf dem Komponentenbezeichner Merkmal, ein der Komponente zugeordneter Text Weitere Merkmale, weitere Erkennungsmerkmale, zum Beispiel Beschriftung oder Tooltip Index Geometrie Komponentenhierarchie Die Kriterien fließen mit unterschiedlicher Gewichtung in die Wiedererkennung ein. Herausragende Bedeutung haben die Klasse und der Komponentenbezeichner. Bei letzteren kann die Entwicklung einen großen Beitrag zur Teststabilität beitragen (siehe Wie erreicht man eine robuste Komponentenerkennung?). Weitere Informationen siehe Gewichtung der Wiedererkennungsmerkmale bei aufgenommenen Komponenten. Bitte beachten Sie bei nativen Windows-Applikationen auch \"Komponenten\". Speicherung der Erkennungsinformationen Die Wiedererkennungsinformationen werden von QF‑Test entweder in Komponente-Knoten abgespeichert oder direkt in den Eventknoten als SmartID eingetragen. In Komponente-Knoten versus SmartID erfahren Sie, was für welches Anwendungsgebiet besser geeignet ist. Standardmäßig zeichnet QF‑Test Komponente-Knoten auf. Unterelemente und geschachtelte Komponenten Es gibt auch Komponenten, die QF‑Test relativ zu einer übergeordneten Komponente adressiert. Dazu gehören zum Beispiel Tabellenzellen, Listeneinträge, Baumknoten, Icons in Buttons oder eine Checkbox in einer Tabellenzelle. Dafür verwendet QF‑Test besondere Adressierungsformen. In Unterelemente: Adressierung relativ zur übergeordneten Komponente wird dieses Thema ausführlich behandelt. Außerdem bietet QF‑Test die Möglichkeit Geltungsbereich (Scope) zu definieren, um Aktionen (Mausklick, Eingabe, Check) auf darin enthaltene Komponenten zu beschränken.","hash":"usec_components_criteria","h1":"Komponenten"},"91":{"id":91,"content":"Pro Handbuch","hash":"","h0":"Komponenten eines GUI | QF‑Test Handbuch"},"92":{"id":92,"content":"Pro Handbuch","hash":"home-link","h0":"Komponenten eines GUI | QF‑Test Handbuch"},"93":{"id":93,"content":"Komponenten eines GUI Die grafische Oberfläche (Graphical User Interface, kurz GUI) einer Applikation besteht aus einem oder mehreren Fenstern, die verschiedene Komponenten beinhalten. Diese Komponenten sind ineinander verschachtelt und bilden eine hierarchische Struktur. Komponenten, die andere Komponenten enthalten, heißen Container. Da QF‑Test selbst eine komplexe Applikation mit grafischer Oberfläche ist, kann das Hauptfenster gut als Beispiel dienen:","hash":"usec_components_gui","h0":"Komponenten eines GUI"},"94":{"id":94,"content":"Abbildung 5.1: Komponenten eines GUI Das Fenster (window) enthält eine Menüleiste (menu bar), welche wiederum die Menüs (menu) für QF‑Test enthält. Darunter befindet sich die Werkzeugleiste (toolbar) mit den Knöpfen (toolbar buttons). Der Hauptteil bedient sich einer split pane um die Baumansicht und die Detailansicht zu trennen. Die Baumansicht besteht aus einer Beschriftung (label) \"Testsuite\" und dem Baum (tree). Die Detailansicht enthält selbst wieder eine komplexe Hierarchie von verschiedenen Komponenten wie Textfeldern (text field), Knöpfen (button), einer Tabelle (table), etc. Dabei gibt es noch eine ganze Reihe von Komponenten, welche man nicht auf den ersten Blick erkennt. So steckt der Baum z.B. in einer scroll pane, die scroll bars anzeigt, wenn der Baum zu groß für seinen Bereich wird. Verschiedene panes dienen lediglich als Container und Hintergrund für andere Komponenten, z.B. der Bereich, der die \"OK\" und \"Abbrechen\" Knöpfe enthält. Sofern nicht explizit anders angegeben bezieht sich der Begriff \"Komponente\" in diesem Handbuch auf die Elemente eines GUI, egal, wie die einzelnen Komponenten in der jeweiligen GUI Technologie genannt werden.","hash":"figure_5.1","h4":"Abbildung 5.1: Komponenten eines GUI"},"95":{"id":95,"content":"Pro Handbuch","hash":"","h0":"Komponente-Knoten versus SmartID | QF‑Test Handbuch"},"96":{"id":96,"content":"Pro Handbuch","hash":"home-link","h0":"Komponente-Knoten versus SmartID | QF‑Test Handbuch"},"97":{"id":97,"content":"Komponente-Knoten versus SmartID Die Wiedererkennungskriterien können auf zwei unterschiedliche Arten mit den Events in den Tests verknüpft werden. Bei der klassischen Methode werden die Wiedererkennungsmerkmale als Attribute eines Komponente-Knotens abgespeichert (siehe auch Komponente-Knoten). In den Tests wird darauf über die QF‑Test ID der Komponente referenziert. Alternativ können GUI-Elemente mittels SmartID direkt über die Wiedererkennungskriterien adressiert werden. Komponente-Knoten werden dann keine aufgezeichnet. SmartIDs und die klassische Methode mit aufgenommenen Komponente-Knoten können alternativ verwendet, im Bedarfsfall aber auch kombiniert, werden. Die folgenden Punkte können Ihnen bei der Überlegung, ob Sie SmartIDs verwenden oder die Komponenten aufnehmen wollen, helfen: Verbesserte Lesbarkeit eines Tests Testgesteuerte Entwicklung Schlüsselwort-basierende Tests Wiedererkennungsstabilität Wartbarkeit Performanz","hash":"usec_components_step_vs_smartid","h0":"Komponente-Knoten versus SmartID"},"98":{"id":98,"content":"Verbesserte Lesbarkeit eines Tests SmartIDs bieten in der folgenden Situation Vorteile gegenüber den aufgenommenen Komponente-Knoten: Die angesprochenen GUI-Komponenten sollen bei Event und Check-Knoten direkt erkennbar sein. Falls die Komponentenbezeichner der Komponenten kryptisch, aber brauchbare Beschriftungen vorhanden sind, haben SmartIDs Vorteile:","hash":"component_step_vs_smartid_readability","h1":"Verbesserte Lesbarkeit eines Tests"},"99":{"id":99,"content":"Abbildung 5.2: Lesbarkeit von SmartIDs","hash":"figure_5.2","h4":"Abbildung 5.2: Lesbarkeit von SmartIDs"},"100":{"id":100,"content":"Abbildung 5.3: Lesbarkeit von Bezeichnern Auch bei Prozeduren kann die Lesbarkeit eines Tests verbessert werden, wenn statt kryptischer Bezeichner auf Beschriftung basierende SmartIDs verwendet werden können. SmartIDs können auch bei Feldern, die die gleichen Wiedererkennungsmerkmale haben, aber in unterschiedlich beschrifteten Panels liegen, die Lesbarkeit erhöhen. Für nachfolgendes Beispiel könnte man zum Beispiel die SmartIDs #Kundenadresse@#Nachname und #Rechnungsadresse@#Nachname verwenden.","hash":"figure_5.3","h4":"Abbildung 5.3: Lesbarkeit von Bezeichnern"},"101":{"id":101,"content":"Abbildung 5.4: Lesbarkeit von SmartIDs in Panels mit Beschriftung","hash":"figure_5.4","h4":"Abbildung 5.4: Lesbarkeit von SmartIDs in Panels mit Beschriftung"},"102":{"id":102,"content":"Testgesteuerte Entwicklung Bei testgesteuerter Entwicklung bieten SmartIDs den großen Vorteil, dass keine Komponente-Knoten angelegt werden müssen. Außerdem werden bei testgesteuerter Entwicklung häufig die Komponentenbezeichner im technischen Design festgelegt, die dann für die Testerstellung genutzt werden können. Wenn der Komponentenbezeichner zum Beispiel btnOK lautet, kann die Komponente über die SmartID #btnOK referenziert werden.","hash":"component_step_vs_smartid_tdd","h1":"Testgesteuerte Entwicklung"},"103":{"id":103,"content":"Schlüsselwort-basierende Tests Schlüsselwort-basierende Tests werden technisch über Prozeduraufrufe und Parameter implementiert. Der Testersteller nimmt somit keine Komponenten auf und ist für die Identifikation der Komponenten auf visuelle Informationen aus dem GUI angewiesen. Dies kann die Beschriftung der Komponente oder deren Funktion (Klasse) sein. In der SmartID können die Erkennungsmöglichkeiten auch kombiniert und mit einem Index versehen werden.","hash":"component_step_vs_smartid_keyword_driven_testing","h1":"Schlüsselwort-basierende Tests"},"104":{"id":104,"content":"Wiedererkennungsstabilität Die Stabilität der Wiedererkennung ist bei aufgenommenen Komponenten und SmartIDs gleich gut, wenn für die SmartID der Name, gegebenenfalls in Verbindung mit der Klasse, verwendet wird. Grundsätzlich hängt die Wiedererkennungsstabilität von der Änderungswahrscheinlichkeit der verwendeten Kriterien ab. Wenn zum Beispiel die Beschriftung einer Komponente in einer Applikation über die Versionen hinweg stabil bleibt, wird auch die Wiedererkennung über eine SmartID mittels Beschriftung (Merkmal bzw. qfs:label*-Varianten) stabil sein. Aufgenommene Komponente-Knoten verwenden für die Wiedererkennung einen vorgegebenen Algorithmus, der den einzelnen Wiedererkennungskriterien unterschiedliche Wichtigkeit beimisst. Klasse, Name und Hierarchie haben hierbei Top-Priorität. Wenn kein Name vorhanden ist, wird aus Hierarchie, Beschriftung, Index und Geometrie (in absteigender Wichtigkeit) eine Wahrscheinlichkeit berechnet, an Hand derer entschieden wird, ob es sich bei einem GUI-Element um die gesuchte Komponente handelt. Dieser Algorithmus hat sich für die meisten Anwendungsfälle als sehr gut erwiesen. Es gibt jedoch auch Fälle, in denen untergeordnete Wiedererkennungskriterien (z.B. die Beschriftung) eine bessere Stabilität bieten als die höher gewichteten Kriterien. Bei aufgenommenen Komponente-Knoten kann man in diesem Fall mittels Resolver eingreifen, siehe Das resolvers-Modul. Hier kommt jedoch die Stärke der SmartIDs zum tragen, dass gezielt ein stabiles Wiedererkennungskriterium (oder eine Kombination mehrerer Kriterien) angegeben werden kann. Dies ist zum Beispiel der Fall, wenn die Beschriftung stabiler ist als der Komponentenbezeichner. SmartIDs haben auch Vorteile, wenn die Wahrscheinlichkeit groß ist, dass sich bei Versionswechseln (manchmal sogar bei jedem Programmstart) die Komponentenhierarchie verändert oder sich die Erkennungsmerkmale übergeordneter Komponenten ändern. SmartIDs berücksichtigen die Komponentenhierarchie standardmäßig nicht.","hash":"component_step_vs_smartid_stability","h1":"Wiedererkennungsstabilität"},"105":{"id":105,"content":"Wartbarkeit Hinsichtlich Wartbarkeit haben die aufgenommenen Komponente-Knoten die Nase vorn, da die Wiedererkennungskriterien zentral im 'Komponente'-Knoten abgespeichert werden und Änderungen nur an dieser Stelle nachgepflegt werden müssen. Bei SmartIDs hingegen sind die Wiedererkennungskriterien dezentral hinterlegt. Änderungen können aber auch hier über die mächtige Suchen-Ersetzen-Funktion gut nachgepflegt werden. Bei SmartIDs mit gleichen Wiedererkennungskriterien für unterschiedliche Komponenten muss gegebenenfalls manuell eingegriffen werden.","hash":"component_step_vs_smartid_maintainability","h1":"Wartbarkeit"},"106":{"id":106,"content":"Performanz Wenn für SmartIDs die Komponentenbezeichner genutzt werden, können sie performanzmäßig mit aufgenommenen Komponente-Knoten mithalten, da für die erkannten Namen ein Index verwendet wird. Wenn die SmartID jedoch die Beschriftung (Merkmal bzw. qfs:label*-Varianten) oder andere Weitere Merkmale nutzt, reicht die Performanz nicht an die von aufgenommenen Komponente-Knoten heran. Sie kann durch explizite Angabe der Klasse deutlich verbessert werden, da dann die GUI-Elemente bereits danach gefiltert werden, bevor die Merkmale ermittelt werden.","hash":"component_step_vs_smartid_performance","h1":"Performanz"},"107":{"id":107,"content":"Kombination von Komponente-Knoten und SmartIDs Aufgenommene Komponente-Knoten können mit SmartIDs kombiniert werden. Details hierzu finden Sie in Unterelemente: Adressierung relativ zur übergeordneten Komponente und QF‑Test ID der Komponente als SmartID. Aufgenommene Komponenten können genutzt werden, um die SmartID-Syntax zu überlagern, in dem man ihre QF‑Test ID auf eine SmartID inklusive Präfix \"#\" setzt. Dies ermöglicht einfache, datengetriebene oder im Vorfeld generierte Tests mit SmartID zu erstellen und nur an neuralgischen Punkten einzelne Komponenten spezifischer zu definieren, ohne die Tests oder Prozeduren dafür anpassen zu müssen.","hash":"sec_kombination_von_komponente_knoten_und_smartids","h1":"Kombination von Komponente-Knoten und SmartIDs"},"108":{"id":108,"content":"Pro Handbuch","hash":"","h0":"Wie erreicht man eine robuste Komponentenerkennung? | QF‑Test Handbuch"},"109":{"id":109,"content":"Pro Handbuch","hash":"home-link","h0":"Wie erreicht man eine robuste Komponentenerkennung? | QF‑Test Handbuch"},"110":{"id":110,"content":"Wie erreicht man eine robuste Komponentenerkennung? Die zentrale Funktionalität eines GUI Testwerkzeuges ist die Wiedererkennung der grafischen Komponenten. QF‑Test bietet hierfür eine Vielzahl an Konfigurationsmöglichkeiten. Dieser Abschnitt gibt einen Überblick über die gebräuchlichsten Strategien und Einstellungen, um die Komponentenerkennung so stabil wie möglich zu gestalten. Sie sollten die Strategie zur Komponentenerkennung vor dem breiten Einsatz von QF‑Test in Ihrem Projekt festlegen. Andernfalls kann die Wartung von Tests größere Aufwände verursachen. Die Wiedererkennung von Komponenten im SUT beim Abspielen eines Tests ist sehr komplex. Die Herausforderung ist, dass sich die Oberfläche des SUT schon bei normaler Bedienung ständig verändern kann. Fenster werden geöffnet und geschlossen oder in der Größe variiert, wodurch sich die Position und Größe der darin enthaltenen Komponenten ändert. Menüs und Comboboxen werden auf- und zugeklappt, Komponenten werden hinzugefügt oder entfernt, sichtbar oder unsichtbar, aktiviert oder gesperrt. Darüber hinaus wird sich die zu testende Anwendung selbst im Lauf der Zeit weiterentwickeln, was sich auch in Veränderungen an der Oberfläche widerspiegelt. Auf all diese Änderungen muss QF‑Test flexibel reagieren und Komponenten so zuverlässig wie möglich zuordnen können. Dies gelingt QF‑Test bereits in vielen Fällen mit den Standardeinstellungen. QF‑Test verwendet einen intelligenten, auf Wahrscheinlichkeiten basierenden Algorithmus um eine möglichst stabile und fehlertolerante Komponentenerkennung zu erreichen. Es wertet die in \"Für die Komponentenerkennung stehen die folgenden Kriterien zur Verfügung:\" genannten Attribute aus und gewichtet sie. Sind jedoch keine guten Erkennungsattribute vorhanden, tut sich der beste Algorithmus schwer. Für diesen Fall gibt es Konfigurations- und Optimierungsmöglichkeiten, die im Welche Optimierungsmöglichkeiten gibt es? erläutert werden. Die erste Frage ist, ob die Standardeinstellungen bereits ausreichen, also:","hash":"sec_bpComponentRecognition","h0":"Wie erreicht man eine robuste Komponentenerkennung?"},"111":{"id":111,"content":"Woran erkennt man eine robuste Komponentenerkennung? Dieser Abschnitt soll Sie in die Lage versetzen zu beurteilen, ob die aktuelle Komponentenerkennung aller Voraussicht nach robust sein wird. Wichtige Elemente einer robusten Komponentenerkennung sind: Klasse der Komponente Name Beschriftung (Merkmal oder qfs:label*-Varianten) moderate Hierarchietiefe des Komponentenbaums In den meisten Fällen sind die Klasse und der Name die robustesten Kriterien für die Wiedererkennung. (In selteneren Fällen ändern sie sich aber von einer Version der Anwendung zur nächsten. Diesen unschönen Fall betrachten wir in Welche Optimierungsmöglichkeiten gibt es?, Punkt 2.) Erfahrungsgemäß ändert sich die Beschriftung der Komponente ebenfalls selten und ist somit auch gut geeignet. Ausführliche Informationen zu allen Erkennungsmerkmalen finden Sie in Wiedererkennungskriterien. Bei der Klasse versucht QF‑Test aus der vom Entwickler verwendeten Klasse abzuleiten, welche Funktionalität eine Komponente besitzt. Basierend auf dieser generischen Klasse optimiert QF‑Test die Aufnahme und bietet funktionsspezifische Checks (zum Beispiel den Check einer ganzen Zeile für eine Tabelle) an. Als erstes wollen wir Ihnen zeigen wie Sie an Hand der aufgenommenen Komponente Knoten schnell erkennen, ob generische Klassen erkannt wurden und ob Namen oder Beschriftungen vorhanden sind.","hash":"components_robust_recognition_judge","h1":"Woran erkennt man eine robuste Komponentenerkennung?"},"112":{"id":112,"content":"Abbildung 5.5: Komponentenbaum 1 Die Klasse ist der schwarze Text der Komponente-Knoten. Wenn die Klasse mit einem Großbuchstaben, gefolgt von einem Kleinbuchstaben beginnt, handelt es sich im Allgemeinen um eine der Generische Klassen, zum Beispiel Button. Wenn die Klasse bei Browser-Elementen nur aus Großbuchstaben besteht, konnte QF‑Test die Funktionalität nicht ermitteln. Im Beispiel HTML und BODY. Ob Namen oder Beschriftungen vorhanden sind, lässt sich an den braunen Texten ablesen. Hierbei handelt es sich um die QF‑Test ID der Komponente, die folgende Rückschlüsse zulässt: Wenn die Klasse in der QF‑Test ID nicht auftaucht, bedeutet dies, dass entweder ein Name vorhanden ist (im Beispiel CalculatorPanel und CalculatedPrice) oder, wenn keine generische Klasse erkannt wurde, dass eine Beschriftung (Merkmal oder qfs:label*-Varianten) vorhanden ist. Im Beispiel CarConfigWeb. Wenn die QF‑Test ID mit der Klasse beginnt, konnte kein Name ermittelt werden und der darauf folgende Teil ist die Beschriftung der Komponente (Merkmal oder qfs:label*-Varianten). Im Beispiel labelEndpreis und buttonOK. Falls weder Name noch Beschriftung gefunden werden, wiederholt die QF‑Test ID die Klasse, nur in Kleinbuchstaben. Im Beispiel html. Falls mehrere Komponenten mit dem beschriebenen Algorithmus die gleiche QF‑Test ID erhalten würden, wird eine laufende Zahl angehängt. Im Beispiel \"buttonOK2\" Dieser Algorithmus ist auch in \"Generierung der QF‑Test ID der Komponente\" beschrieben. Eine gewisse Hierarchie bei den Komponenten ist bei der Wiedererkennung hilfreich. Problematisch sind nur tiefe Verschachtelungen. Für die Komponentenerkennung sind nur wenige Hierarchieebenen tatsächlich relevant. Die anderen können ignoriert werden. Das Video 'Die Explosion der Komplexität in der Web Testautomatisierung eindämmen' zeigt die Problematik von tiefen Verschachtelungen sehr anschaulich - und auch Lösungen dazu. Obiges Beispiel hat nur eine geringe Hierarchietiefe. Dies ist optimal. Für die Erstellung des Komponentenbaums im obigen Beispiel waren folgende Optionen in der Rubrik »Aufnahme«-»Komponenten« gesetzt: QF‑Test ID des Fensterknotens vor QF‑Test ID der Komponente setzen war ausgeschaltet, was der Standardeinstellung entspricht. QF‑Test ID des Parentknotens vor QF‑Test ID der Komponente setzen stand auf Niemals, was ebenfalls der Standardeinstellung entspricht. Die Optionen öffnen Sie über den Menüpunkt »Bearbeiten«-»Optionen« Alternativ zur Auswertung der QF‑Test ID im Komponentenbaum können Sie sich über die QF‑Test Suche alle Komponenten mit Namen auflisten lassen. Setzen Sie hierzu im Suchdialog Im Attribut auf Name sowie Knotentyp auf Komponente und klicken Sie dann Ergebnisliste anzeigen. Wenn Sie eine Aufnahme ausführen, werden die Komponenten, mit denen Sie interagieren, automatisch aufgenommen. Um jedoch alle Komponenten für die Analyse auf einmal aufzunehmen, wählen Sie »Aufnahme«-»Komponenten aufnehmen«. Dann im GUI einen Rechtsklick ausführen und Ganzes Fenster wählen. (Nach der Analyse sinnvollerweise wieder löschen, um nicht unnötig Ballast herumzuschleppen.) Hier noch zwei Beispielkomponentenbäume mit Bewertung wie robust die Komponentenerkennung ist.","hash":"figure_5.5","h4":"Abbildung 5.5: Komponentenbaum 1"},"113":{"id":113,"content":"Beispiel 1","hash":"sec_beispiel_1","h1":"Beispiel 1"},"114":{"id":114,"content":"Abbildung 5.6: Stabile Komponentenerkennung - Beispiel 1 Positiv: Generische Klassen werden erkannt: MenuBar, TabPanel, Panel, Label und TextField. Positiv: Für die grün markierten TextFields konnten Namen ermittelt werden, erkennbar daran, dass die QF‑Test ID (brauner Text) nicht mit der Klasse beginnt, zum Beispiel BasePrice. Positiv: Für die gelb markierten TextFields und Buttons konnten zwar keine Namen ermittelt werden, erkennbar daran, dass die QF‑Test ID (brauner Text) mit der Klasse (textfield, button) beginnt. Aber der zweite Teil der QF‑Test ID zeigt, dass zumindest eine Beschriftung gefunden wurde. Unwichtig: Die Label haben keine Namen. Sie sind aber selten testrelevant. Unwichtig: die Container 'HTML' und 'BODY' haben keine generische Klasse. Man könnte sie auf Panel mappen. In diesem Fall würde das aber weder die Wiedererkennung verbessern noch zusätzliche Funktionalität seitens QF‑Test (z.B. zusätzliche Checks für die Check-Aufnahme) bringen. Positiv: Außer BODY keine überflüssigen Container.","hash":"figure_5.6","h4":"Abbildung 5.6: Stabile Komponentenerkennung - Beispiel 1"},"115":{"id":115,"content":"Beispiel 2","hash":"sec_beispiel_2","h1":"Beispiel 2"},"116":{"id":116,"content":"Abbildung 5.7: Stabile Komponentenerkennung - Beispiel 2 Positiv: Für die die testrelevanten Komponenten konnte Name oder Beschriftung ermittelt werden, erkennbar daran, dass die QF‑Test ID (brauner Text) nicht mit der Klasse beginnt, zum Beispiel BasePrice und DiscountValue_input. Negativ: es werden nur für wenige Komponenten generischen Klassen erkannt. Hier fehlt ein Komponenten-Mapping mit dem CustomWebResolver, siehe Verbesserte Komponentenerkennung mittels CustomWebResolver. Negativ: Überflüssige Hierarchieebenen. Die DIV, TR TD, CENTER und TABLE Komponenten sollten als Panel gemappt (siehe Der CustomWebResolver installieren Knoten) oder ignoriert werden (siehe Der CustomWebResolver installieren Knoten, Konfigurationskategorie ignoreTags).","hash":"figure_5.7","h4":"Abbildung 5.7: Stabile Komponentenerkennung - Beispiel 2"},"117":{"id":117,"content":"Welche Optimierungsmöglichkeiten gibt es? Wenn für die relevanten Komponenten generische Klassen und Namen vorhanden sind, können Sie in den allermeisten Fällen davon ausgehen, dass die Komponentenerkennung robust ist, und den Rest dieses Abschnitts überspringen. Wenn es Probleme bei der Wiedererkennung gibt, gilt es zwei grundsätzlich unterschiedliche Fälle zu betrachten: Wird die Komponente (rechtzeitig) angezeigt? Dieser Fall hat mit der Komponentenerkennung selbst gar nichts zu tun. Er tritt auf, wenn QF‑Test sozusagen zu schnell für die Anwendung ist. In diesem Fall sollten Sie im Testfall explizit auf das Erscheinen der Komponente warten. Weitere Informationen finden Sie in Zeitliche Synchronisierung. Wird die angezeigte Komponente erkannt? Hier gibt es mehrere Möglichkeiten: Web: Zuweisung von generischen Klassen zu GUI-Element-Klassen Bei Web-Anwendungen bitte zuerst die Komponentenzuweisung, wie in Der CustomWebResolver installieren Knoten beschrieben, durchführen. Wenn dies nicht zu ausreichender Stabilität führt, dann in diesem Abschnitt weiterlesen. Instabile Komponentenbezeichner Es wurden Komponentenbezeichner vergeben, diese sind aber über die Anwendungsversionen hinweg nicht stabil. In diesem Fall ist es besser, die Bezeichner mittels Resolver zu entfernen und mit den übrigen Erkennungskriterien zu arbeiten, wenn durch die Entwickler keine stabilen Bezeichner gesetzt werden können. Bei Web-Anwendungen kann eine entsprechende Einstellung in der Konfigurationskategorie 'customIdAttributes' (siehe Der CustomWebResolver installieren Knoten) weiterhelfen. Keine Komponentenbezeichner Es wurden keine Komponentenbezeichner vergeben und die übrigen Kriterien sind nicht ausreichend stabil. Hier lohnt es sich auch oft, mit der Entwicklung Kontakt aufzunehmen und ihnen die Relevanz von Komponentenbezeichnern für Regressionstests zu erläutern - beziehungsweise denjenigen, der budgetmäßig für Entwicklung und Testung verantwortlich ist, zu überzeugen, dass ein geringer Mehraufwand in der Entwicklung für das Einpflegen der Bezeichner eine deutliche Aufwandsreduzierung in der Testabteilung bedeuten kann. Wenn dies nicht möglich ist, gibt es manchmal stabile Wiedererkennungskriterien, die QF‑Test aber nicht standardmäßig nutzt, die man über einen Namenresolver (siehe \"Das NameResolver Interface\") bekannt geben kann. Die Komponentenbezeichner enthalten stabile Teile Nur Teile der Komponentenbezeichner sind stabil. Wenn ein Schema vorliegt, das programmtechnisch ausgewertet werden kann, ist dies auch ein Fall für einen Namenresolver (siehe \"Das NameResolver Interface\"). Bei Web kann dies auch über die Konfigurationskategorie 'autoIdPatterns' (siehe Der CustomWebResolver installieren Knoten) eingestellt werden. Für die Komponenten gibt es Beschriftungen, die QF‑Test nicht standardmäßig erkennt Es gibt keinen Namen und der Standardalgorithmus von QF‑Test erkennt kein Merkmal und keine qfs:label*-Varianten, obwohl Kandidaten dafür vorhanden wären. Hier können Sie die Beschriftungen mittels FeatureResolver (siehe \"Das FeatureResolver Interface\") bzw. ExtraFeaturesResolver (siehe \"Das ExtraFeatureResolver Interface\") bekannt geben. Web-Komponenten verfügen manchmal über ein Attribut, das als Beschriftung genutzt werden kann. Dies kann im CustomWebResolver in der Konfigurationskategorie attributesToQftFeature bekannt gegeben werden (siehe Der CustomWebResolver installieren Knoten). Teile des Merkmals oder der qfs:label*-Varianten sind stabil Hier können entweder reguläre Ausdrücke direkt im 'Komponente'-Knoten bzw. in der SmartID genutzt werden. Die Lösung kann aber auch ein FeatureResolver (siehe \"Das FeatureResolver Interface\") bzw. ExtraFeaturesResolver (siehe \"Das ExtraFeatureResolver Interface\")sein. Übergeordnete Komponenten werden nicht stabil erkannt Die Komponente an sich ist stabil, aber einer der Container, in denen sie liegt, ist nicht stabil. Hier können reguläre Ausdrücke oder Resolver für die betroffenen Containern Abhilfe schaffen. Wenn alle testrelevanten Komponenten Namen besitzen, kann auch die Option Gewichtung von Namen (Aufnahme) in der Rubrik »Aufnahme«-»Komponenten«-»Gewichtung von Namen« auf \"Name übertrifft alles\" gesetzt werden. Hier bietet sich auch der Einsatz von SmartIDs an. Zusätzliche oder fehlende übergeordnete Komponenten Die Komponente an sich ist stabil, aber die Hierarchie, in der sie liegt, ist nicht stabil, weil Container verschwinden oder hinzukommen. Wenn alle Komponenten, die testrelevant sind, Namen besitzen, kann auch hier die Option Gewichtung von Namen (Aufnahme) in der Rubrik »Aufnahme«-»Komponenten«-»Gewichtung von Namen« auf \"Name übertrifft alles\" gesetzt werden. Alternativ kann im Komponentenbaum die Komponente in der Hierarchie weiter nach oben gebracht werden, so dass die instabilen Container keinen Einfluss mehr haben. Auch hier bietet sich der Einsatz von SmartIDs an. Komponentenstruktur/Index Das Attribut Index spielt eine untergeordnete Rolle, kommt aber zum Tragen, wenn die Komponentenerkennung ohne Name, Merkmal oder qfs:label*-Varianten auskommen muss. Wenn dann auch noch der Index instabil ist, kann man diesen auch löschen, so dass die Geometrie zum Tragen kommt. In diesem Fall sollte nach dem Start die Größe der zu testenden Applikation immer auf den gleichen Wert (siehe Komponentenevent) gesetzt werden.","hash":"usec_components_optimization","h1":"Welche Optimierungsmöglichkeiten gibt es?"},"118":{"id":118,"content":"Pro Handbuch","hash":"","h0":"Wiedererkennungskriterien | QF‑Test Handbuch"},"119":{"id":119,"content":"Pro Handbuch","hash":"home-link","h0":"Wiedererkennungskriterien | QF‑Test Handbuch"},"120":{"id":120,"content":"Wiedererkennungskriterien","hash":"usec_component_recognition_criteria","h1":"Wiedererkennungskriterien"},"121":{"id":121,"content":"Pro Handbuch","hash":"","h0":"Klasse | QF‑Test Handbuch"},"122":{"id":122,"content":"Pro Handbuch","hash":"home-link","h0":"Klasse | QF‑Test Handbuch"},"123":{"id":123,"content":"Klasse Die Klasse einer Komponente steht für den Typ der jeweiligen Komponente und ist daher sehr wichtig. Vereinfacht gesagt: Wenn QF‑Test einen Button aufnimmt, sucht es bei der Wiedergabe auch nur nach einem Button und nicht nach einer Tabelle oder einem Baum. Dies verbessert Performanz und Stabilität der Wiedererkennung und hilft Ihnen außerdem, die von QF‑Test aufgezeichnete Information zu einer Komponente mit der tatsächlichen Komponente im GUI zu korrelieren. Neben ihrer Rolle bei der Identifikation von Komponenten ist die Klasse auch wichtig für die Registrierung verschiedener Arten von Resolvern, die großen Einfluss darauf nehmen können, wie QF‑Test Komponenten behandelt. Resolver werden in \"Das NameResolver Interface\" detailliert erläutert. Der Name wird für die Generierung der QF‑Test ID der Komponente verwendet. Beispiele hierzu finden Sie in Woran erkennt man eine robuste Komponentenerkennung?. Komponenten können in einer SmartID auch direkt über den Namen adressiert werden, ohne Aufnahme eines Komponente-Knotens. Der Einfluss der Klasse auf die QF‑Test ID der Komponente ist in Generierung der QF‑Test ID der Komponente beschrieben. Die Verwendung als SmartID in \"SmartID\".","hash":"usec_componentclass","h0":"Klasse"},"124":{"id":124,"content":"Generische Klassen Normalerweise gibt es in jeder UI-Technologie systemspezifische Klassen, die einen Button, eine Tabelle oder anderen Typ kennzeichnen. Für einen Button kann diese Repräsentation z.B. ein javax.swing.JButton in Java Swing, ein org.eclipse.swt.widgets.Button in Java SWT, ein javafx.scene.control.ButtonBase in JavaFX oder ein INPUT:SUBMIT in Web-Anwendungen sein. Um ein technologieübergreifendes Testen zu ermöglichen, vereinheitlicht QF‑Test nun diese spezifischen Klassen und arbeitet mit sogenannten generischen Klassen, z.B. Button für alle zuvor genannten Button-Beispiele. Sie finden eine Beschreibung der generischen Klassen in \"Generische Klassen\". Zusätzlich zu der generischen Klasse werden systemspezifische Klassen als Weitere Merkmale aufgenommen, allerdings mit dem Status \"Ignorieren\". Im Fall von Erkennungsproblemen aufgrund zu vieler ähnlicher Komponenten können diese aktiviert werden, um die Erkennung zu schärfen, wenn auch auf Kosten der Flexibilität. Sogar dann, wenn von der Klasse abgeleitet wurde, wird die generische Klasse aufgenommen. Zusätzlich sei erwähnt, dass dieses Konzept QF‑Test erlaubt, problemlos Tests mit obfuskierten Klassen zu erstellen, ohne dass Sie die Standardeinstellungen ändern müssen. Während der Wiedergabe vergleicht QF‑Test das aufgezeichnete Klasse Attribut der Komponente mit jeder Klasse des Objektes im SUT. Deshalb kann QF‑Test auch mit Änderungen von Klassennamen umgehen, solange der Basistyp der selbe bleibt. HTML ist eine sehr flexible Sprache, um den Inhalt und Aufbau einer Webseite zu beschreiben. Es gibt nur ein Minimum an Quasi-Standards wie zum Beispiel \"INPUT:SUBMIT\", bei denen immer die selbe Funktionalität zu erwarten ist und die somit einer QF‑Test Klasse standardmäßig zugewiesen werden können. Die Entwicklung von Web-Applikationen erfolgt im Normalfall mit Toolkits, die ihre eigenen Standards haben. In QF‑Test wurden für eine Reihe gängiger Toolkits die Klassenzuordnungen vorgenommen, siehe Besondere Unterstützung für verschiedene Web-Komponentenbibliotheken. Wenn die Anwendung mit einem erweiterten Toolkit erstellt wurde oder ganz mit einem eigenen gearbeitet wurde, wird es notwendig sein, QF‑Test die Klassenzuordnungen bekanntzugeben. Dies ist in Verbesserte Komponentenerkennung mittels CustomWebResolver beschrieben. Wenn QF‑Test einer Komponente eine generische Klasse zuordnen kann, bietet das für die Testerstellung und Ausführung folgende Vorteile: Unabhängigkeit von den konkreten technischen Klassen Mit den generischen Klassen wird eine gewisse Unabhängigkeit von den konkreten technischen Klassen hergestellt. Dieses Konzept ermöglicht es Ihnen, Tests unabhängig von der konkreten Technologie zu erstellen. Verbesserte Komponentenerkennung Wenn die Funktionalität der Komponente bekannt ist, können die für die Erkennung am besten geeigneten Kriterien abgespeichert werden. Beispiel Button: Hier ist die Beschriftung des Buttons erste Wahl für das 'Merkmal' und das weitere Merkmal 'qfs:labelText'. Beispiel Textfeld: Bei einem Textfeld hingegen macht es keinen Sinn, den eigenen Text für die Wiedererkennung zu verwenden. Hier sucht QF‑Test nach einer Beschriftung in der Nähe und speichert diese im weiteren Merkmal in einer der qfs:label*-Varianten, zum Beispiel in 'qfs:labelLeft', wenn sich die Beschriftung links des Textfelds befindet. Auch die generische Klasse an sich ist ein Unterscheidungskriterium. Dies wird besonders bei Web-Anwendungen deutlich, bei denen es vorkommen kann, dass die meisten Komponenten mit der Klasse DIV, entsprechend ihres HTML-Tags, aufgenommen werden. Optimale Mausposition bei der Wiedergabe Die generische Klasse hat auch Einfluss auf die optimale Mausposition beim Abspielen der Events. Beispiel Button: Ein Mausklick wird am besten mittig auf den Button abgespielt. Beispiel Textfeld: Der Mausklick sollte die gleiche Stelle abgespielt werden, auf die der Tester bei der Aufnahme geklickt hat, damit bei Bedarf anschließend Text genau dort eingefügt werden kann. Klassenspezifische Checks Außerdem bietet QF‑Test bei der Checkaufnahme klassenspezifische Checks an. Bei Textfeldern kann zum Beispiel zusätzlich geprüft werden, ob sie editierbar sind. Check Elemente ist hingegen nur bei Listen, Tabellen oder Bäume sinnvoll.","hash":"usec_componentclassgeneric","h0":"Generische Klassen"},"125":{"id":125,"content":"Pro Handbuch","hash":"","h0":"Name | QF‑Test Handbuch"},"126":{"id":126,"content":"Pro Handbuch","hash":"home-link","h0":"Name | QF‑Test Handbuch"},"127":{"id":127,"content":"Name Falls die Entwickler für eine Komponente einen Komponentenbezeichner vergeben haben, erkennt QF‑Test dies und verwendet diesen, wenn geeignet, für das Attribut Name. Wenn ein Wert für Name gefunden wurde, wird dieser auch für die Generierung der QF‑Test ID der Komponente verwendet. Weitere Informationen finden Sie in \"Generierung der QF‑Test ID der Komponente\", Beispiele hierzu in Wie erreicht man eine robuste Komponentenerkennung?. Auch bei der Aufnahme von SmartIDs ist der Name im Standard die erste Wahl. Der Grund für den gewaltigen Einfluss eines guten Komponentenbezeichners ist die Tatsache, dass dieser die Wiedererkennung von Komponenten über lange Zeit und viele Änderungen hinweg zuverlässig ermöglicht. Eine Komponente zu finden, die einen eindeutigen Bezeichner besitzt, ist offensichtlich trivial. Ohne diese Hilfe verwendet QF‑Test viele verschiedene Arten von Informationen, um eine Komponente zu lokalisieren. Der Algorithmus ist fehlertolerant und wurde fein abgestimmt, so dass er ausgezeichnete Ergebnisse erzielt. Und dennoch: Mit Ausnahme des Bezeichners kann sich jede Information zu einer Komponente ändern, wenn sich das SUT weiterentwickelt. Irgendwann, wenn größere Änderungen vorgenommen wurden oder sich mehrere kleinere Änderungen summiert haben, wird eine Komponente nicht mehr erkannt werden und ein manueller Eingriff vonnöten sein, um die Testsuite anzupassen. Ein weiterer wichtiger Aspekt von Bezeichnern ist, dass sie das Testen von Applikationen, deren Oberfläche in verschiedene Sprachen übersetzt wird, von der aktuell eingestellten Sprache unabhängig macht, da der Bezeichner nur intern vergeben wird und nie übersetzt werden muss. Die Automatisierung von Tests kann deutlich verbessert werden, wenn die Entwickler des SUT vorausgeplant haben oder bereit sind, durch Vergabe von Bezeichnern für zumindest einen Teil der Komponenten des SUT mitzuhelfen. Außerdem haben Bezeichner in der Testsuite eine sehr hohe Sichtbarkeit, da sie als Basis für die QF‑Test ID Attribute der Komponenten dienen. Letzteres sollte nicht unterschätzt werden, speziell für Komponenten ohne besondere Merkmale. Knoten, die Text in Felder namens \"textName\", \"textAddress\" oder \"textAccount\" einfügen, sind wesentlich leichter zu verstehen und zu warten als solche für die Felder \"text\", \"text2\" oder \"text3\". Der koordinierte Einsatz von Bezeichnern ist einer der entscheidenden Faktoren für die Effizienz der Automatisierung und für die mit QF‑Test erzielbaren Einsparungen. Sollte sich die Entwicklungsabteilung oder die Projektleitung trotz des minimalen Aufwands nicht mit der Vergabe von Bezeichnern anfreunden können, geben Sie ihnen einfach dieses Kapitel des Handbuchs zu lesen. Falls Entwickler ein anderes, konsistentes Schema zur Vergabe von Bezeichnern eingesetzt haben, das QF‑Test jedoch standardmäßig nicht erkennt, werfen Sie bitte einen Blick in Beeinflussen des Name-Attributs mittels NameResolver. Wenn eindeutige Namen ermittelt werden, können die Optionen Gewichtung von Namen (Wiedergabe) und Gewichtung von Namen (Aufnahme) auf \"Name übertrifft alles\" gesetzt werden, wodurch die Komponentenerkennung von der Komponentenhierarchie unabhängig und auf Grund des Name-Cachings maximale Performanz erreicht wird. Um die Vergabe von Bezeichnern zu vereinfachen, bietet QF‑Test eine Funktion, um Bezeichner für die Komponenten vorzuschlagen, für die ein Bezeichner das Testen verbessert. Näheres dazu finden Sie bei der Option Hotkey für Komponenten. Änderungen von Bezeichnern in der zu testenden Applikation sollten möglichst vermieden werden, da dies die Komponentenerkennung aushebelt und eine Menge Nacharbeit in den Tests bedeuten kann. Bitte beachten Sie, wenn dennoch Änderungen vorkommen werden, dass diese im Name Attribut der Komponente nachgezogen werden und nicht im QF‑Test ID Attribut, das nur der Referenzierung der Komponente in den Tests dient! Eine weitere mögliche Schwierigkeit kann sein, dass die Namensänderung direkt im Test in der Referenz auf die Komponente erfolgt, zum Beispiel bei einem Mausklick im Attribut QF‑Test ID der Komponente. Der Test schlägt dann mit einer UnresolvedComponentIdException fehl.","hash":"usec_components_name","h0":"Name"},"128":{"id":128,"content":"Komponentenbezeichner Komponentenbezeichner werden in den unterschiedlichen UI-Technologien unterschiedlich genannt. Im Handbuch wird für sie auch der Begriff 'Name' verwendet. Außerdem sind die Kriterien, ob und wie die Bezeichner in das Attribut 'Name' übernommen werden, je nach Technologie leicht unterschiedlich. Die folgenden Ausführungen gelten für die Standardeinstellungen der Optionen, insbesondere von Gewichtung von Namen (Wiedergabe) und Gewichtung von Namen (Aufnahme) (Standardwert: \"Hierarchie von Namen\"). Auch die Nutzung von Resolvern kann das beschriebene Verhalten verändern. Java Swing/AWT Der Komponentenbezeichner heißt hier ebenfalls 'Name'. Falls er gesetzt wurde, wird er in das Attribut 'Name' übernommen. Wenn innerhalb eines Containers Komponenten gleiche Bezeichner haben, legt QF‑Test das Weiteres Merkmal qfs:matchindex mit einem entsprechenden Index für die Duplikate an. Alle AWT und Swing Komponenten sind von der AWT Klasse Component abgeleitet. Deren setName Methode ist daher der Standard für Swing SUTs. Dank dieses Standards machen viele Entwickler auch unabhängig von Plänen für eine Testautomatisierung davon Gebrauch, was eine große Hilfe ist. JavaFX Der Komponentenbezeichner heißt hier 'ID'. Falls er gesetzt wurde, wird er in das Name Attribut übernommen. Wenn innerhalb eines Containers Komponenten gleiche IDs haben, legt QF‑Test das Weiteres Merkmal qfs:matchindex mit einem entsprechenden Index für die Duplikate an. Für JavaFx wird setId verwendet, um Namen für Komponenten (hier \"Node\" genannt) zu vergeben. Alternativ können IDs mittels FXML über das Attribut fx:id gesetzt werden. Obwohl IDs von Knoten eindeutig sein sollen, wird dies nicht erzwungen. Java SWT Der Komponentenbezeichner heißt hier ebenfalls 'Name'. Falls er gesetzt wurde, wird er in das Name Attribut übernommen. Wenn innerhalb eines Containers Komponenten gleiche Bezeichner haben, legt QF‑Test das Weiteres Merkmal qfs:matchindex mit einem entsprechenden Index für die Duplikate an. Leider hat SWT kein eigenes Konzept für die Vergabe von Namen. Eine akzeptierte Konvention ist der Gebrauch der Methode setData(String key, Object value) mit dem String \"name\" als Schlüssel und dem gewünschten Namen als Wert. QF‑Test wertet diese Daten - falls vorhanden - aus und verwendet sie als Namen für die Komponenten. Mangels eines echten Standards für die Vergabe von Namen kommen diese in SWT-Anwendungen inklusive Eclipse nur in Ausnahmefällen zum Einsatz. Glücklicherweise kann QF‑Test Namen für die Hauptkomponenten von Eclipse/RCP-Anwendungen aus den zugrunde liegenden Modellen ableiten, was zu guten Ergebnissen führt, vorausgesetzt es wurden IDs für diese Modelle vergeben. Weitere Details finden Sie bei der Beschreibung der Option Automatische Namen für Komponenten in Eclipse/RCP-Anwendungen. Web Der naheliegende Kandidat für den Bezeichner eines DOM-Knotens ist sein 'id' Attribut, nicht zu verwechseln mit dem QF‑Test ID Attribut von QF‑Test's Komponente Knoten. Leider erzwingt der HTML-Standard keine Eindeutigkeit von IDs. Außerdem sind 'id' Attribute ein zweischneidiges Schwert, da sie eine wichtige Rolle bei den internen JavaScript Operationen einer Web-Anwendung spielen können. Daher ist es zwar nicht unwahrscheinlich, dass 'id'-Attribute vergeben wurden, sie können aber nicht so frei definiert werden wie Bezeichner in anderen Technologien. Zu allem Übel müssen viele DHTML und Ajax Frameworks IDs automatisch generieren, was diese als Namen ungeeignet macht. Glücklicherweise können Komponentenbezeichner über unterschiedliche Attribute des GUI-Elements realisiert werden. Meist ist es das Attribut 'id', manchmal auch 'name' - aber auch andere Attribute können genutzt werden. Die Option ID-Attribut als Name verwenden bestimmt, ob QF‑Test 'id'-Attribute als Namen verwendet oder nicht. Bitte beachten Sie, dass die Option Alle Ziffern aus 'ID'-Attributen eliminieren bewirken kann, dass ursprünglich eindeutige Bezeichner nach Löschung der Ziffern nicht mehr eindeutig sind. Bei der Prüfung, ob der ermittelte Name eindeutig genug ist, wird die Hierarchie, in der die Komponente liegt, für die Bestimmung der Eindeutigkeit mit herangezogen, wenn für die Optionen Gewichtung von Namen (Wiedergabe) und Gewichtung von Namen (Aufnahme) der Standardwert \"Hierarchie von Namen\" gesetzt. Die automatisch generierten 'id'-Attribute enthalten manchmal einen statischen Teil, der als Bezeichner genutzt werden kann. Dies kann über die Konfigurationskategorie autoIdPatterns, siehe Der CustomWebResolver installieren Knoten, konfiguriert werden. Außerdem kann in dieser Prozedur über die Kategorie customIdAttributes auch jedes andere HTML-Attribut als Komponentenbezeichner genutzt werden. Im Falle einer Webapplikation, welche ein von QF‑Test unterstütztes Komponentenbibliothek verwendet, können Sie einen Blick in \"Eindeutige Bezeichner setzen\" werfen, um mehr über das Setzen eindeutiger Bezeichner für das jeweilige Toolkit zu erfahren. Win Der Komponentenbezeichner heißt hier 'AutomationId'. Falls er gesetzt wurde, wird er in das Name Attribut übernommen. Wenn innerhalb eines Containers Komponenten gleiche Bezeichner haben, legt QF‑Test ein Weiteres Merkmal mit dem Namen qfs:matchindex und einem entsprechenden Index für die Duplikate an. Android Der Komponentenbezeichner heißt hier 'ID'. Er wird nur dann in das Name Attribut übernommen, wenn es sich nicht um einen trivialen Klassennamen (vgl. Android - Liste der trivialen Komponentenbezeichner) handelt. Wenn innerhalb eines Containers Komponenten gleiche Bezeichner haben, legt QF‑Test ein Weiteres Merkmal mit dem Namen qfs:matchindex und einem entsprechenden Wert für die Duplikate an.","hash":"usec_components_identifier","h0":"Komponentenbezeichner"},"129":{"id":129,"content":"Über die Vergabe von Bezeichnern Es gibt eine kritische Anforderung für Bezeichner: Sie dürfen sich nicht im Lauf der Zeit ändern, nicht von einer Version der SUT zur nächsten, nicht von einem Aufruf zum anderen und nicht während der Ausführung des SUT, z.B. wenn eine Komponente zerstört und später neu erstellt wird. Ist ein Bezeichner einmal vergeben, muss er Bestand haben. Leider gibt es kein automatisches Schema zur Vergabe von Bezeichnern, das diese Anforderungen erfüllt. Solche Systeme erstellen Bezeichnern meist aus dem Bezeichner der jeweiligen Klasse und einem laufenden Index, was unweigerlich fehlschlägt, da der Bezeichner dann von der Reihenfolge der Erstellung der Komponenten abhängt. Da Bezeichner eine so zentrale Rolle bei der Erkennung von Komponenten spielen, können unzuverlässige Bezeichner, insbesondere automatisch generierte, sehr negative Effekte haben. Falls die Entwickler nicht überzeugt werden können, derartige Bezeichner durch eindeutige, stabile zu ersetzen, oder sie zumindest wegzulassen, können solche Bezeichner mit Hilfe eines NameResolver unterdrückt werden. Weitere Informationen hierzu finden Sie in \"Das NameResolver Interface\". Es ist für die Arbeit mit QF‑Test nicht nötig, Bezeichner flächendeckend zu vergeben. Allzu ausgiebiger Gebrauch kann sogar kontraproduktiv sein, da QF‑Test ein eigenes Konzept dafür hat, ob eine Komponente \"interessant\" ist oder nicht. Uninteressante Komponenten werden wegabstrahiert und können so bei einer Änderung keine Probleme verursachen. Typische Beispiele für solche Komponenten sind Panels, die nur für Layout-Zwecke eingebaut werden. Eine Komponente mit nicht trivialem Bezeichner gilt für QF‑Test immer als interessant, so dass die Benamung von unwichtigen Komponenten zu Problemen führen kann, wenn diese in einer späteren Version aus der Hierarchie entfernt werden. Auch müssen Bezeichner nicht global eindeutig vergeben werden. Jede Klasse von Komponenten bildet einen eigenen Namensraum, so dass es keinen Konflikt gibt, wenn ein Textfeld und ein Button den selben Bezeichner haben. Außerdem genügt es, wenn die Bezeichner innerhalb einer Anzeige eindeutig sein - sie brauchen also nicht applikationsweit eindeutig zu sein (außer bei Web-Applikationen). Andererseits ist der Optimalfall hinsichtlich stabiler Komponentenerkennung in den Regressionstests, wenn die Bezeichner applikationsweit eindeutig sind. Dann können Sie die Optionen Gewichtung von Namen (Wiedergabe) und Gewichtung von Namen (Aufnahme) auf \"Name übertrifft alles\" setzen, die flexibelste Einstellung zur Wiedererkennung von Komponenten. Zwei Fragen sind noch offen: Welche Komponenten sollten Bezeichner erhalten und was sind eigentlich gute Bezeichner? Eine gute Daumenregel ist es, allen Komponenten, mit denen ein Anwender direkt interagieren kann, einen Bezeichner zu geben, also Knöpfen, Textfeldern, etc. Komponenten, die nicht direkt erzeugt werden, sondern automatisch als Elemente von komplexen Komponenten, brauchen keinen Bezeichner. Dies sind z.B. die Listenelemente einer ComboBox. Die komplexe Komponente selbst (im Beispiel also die ComboBox) sollte dagegen sehr wohl einen Bezeichner haben. Falls Bezeichner für Komponenten nicht von Anfang an vergeben wurden und die Entwickler nur den geringstmöglichen Aufwand spendieren wollen, diese zur Verbesserung der Testautomatisierung nachzuziehen, hat sich folgende Strategie als guter Kompromiss erwiesen: Fenster, komplexe Komponenten wie Bäume und Tabellen, sowie Panels, die eine Anzahl von Komponenten zu einer Art Formular zusammenfassen, sollten einen Bezeichner erhalten. So lange Struktur und Geometrie der Komponenten in solchen Formularen einigermaßen konstant sind, führt dies zu einer guten Wiedererkennung und brauchbaren QF‑Test ID Attributen. Probleme durch individuelle Komponenten mit wechselnden Eigenschaften können von Fall zu Fall behandelt werden, entweder indem entwicklungsseitig nachträglich ein Bezeichner vergeben wird, oder mit Hilfe eines NameResolver.","hash":"usec_howtosetname","h0":"Über die Vergabe von Bezeichnern"},"130":{"id":130,"content":"Beeinflussen des Name-Attributs mittels NameResolver In unterschiedlichen Applikationen kommen unterschiedlichste Namenskonzepte für Komponenten zum Einsatz. Nicht in allen Fällen liefern sie stabile Bezeichner, die für Regressionstests sinnvoll genutzt werden können: beispielsweise, wenn die Komponenten keine Bezeichner haben oder Bezeichner existieren, die sich aber von Zeit zu Zeit ändern, z.B. zeichnen Sie einen 'button1' beim ersten Mal auf und beim nächsten Mal heißt dieser Button plötzlich 'button2'. Eine andere Variante könnte sein, dass die aktuelle Versionsnummer des SUT im Bezeichner des Hauptfensters steckt. Manchmal kennen die Tester jedoch einen Algorithmus, um eindeutige Namen zu setzen. In solchen Fällen sollten Sie sich Das NameResolver Interface im Kapitel Das resolvers-Modul genauer anschauen. Ein NameResolver kann verwendet werden, um Bezeichner aus der QF‑Test Sicht zu ändern oder zu löschen. Diese Änderungen treffen dann nur für die QF‑Test Sicht zu und ändern nichts am aktuellen Sourcecode. Sie sollten über den Einsatz von NameResolver nachdenken, wenn: das SUT dynamische Bezeichner besitzt. Sie einen Algorithmus kennen, um eindeutige Bezeichner zu vergeben. Sie entwicklungsseitige Änderungen von Bezeichnern \"neutralisieren\" wollen, z.B. bei einer neuen Version. Sie die Namensgebung der Komponenten optimieren wollen, z.B. einige Teile ausschneiden, um lesbarere QF‑Test IDs für Komponenten in QF‑Test zu erhalten. Wenn Sie eine Eindeutigkeit pro Fenster erreichen (bei Web für alle Seiten), können Sie darüber nachdenken die Optionen Gewichtung von Namen (Wiedergabe) und Gewichtung von Namen (Aufnahme) auf \"Name übertrifft alles\" zu setzen. Wenn es möglich ist, dass die Entwickler eindeutige und stabile Bezeichner direkt vergeben, dann sollten es diese im Quellcode tun, da die Entwickler am besten wissen, welche Komponenten angelegt werden. Das Implementieren eines NameResolvers kann eine sehr aufwendige und mühsame Aufgabe sein, besonders wenn sich das GUI stark ändert. NameResolver sind in \"Das NameResolver Interface\" beschrieben.","hash":"sec_bpCRNameRes","h0":"Beeinflussen des Name-Attributs mittels NameResolver"},"131":{"id":131,"content":"Pro Handbuch","hash":"","h0":"Merkmal | QF‑Test Handbuch"},"132":{"id":132,"content":"Pro Handbuch","hash":"home-link","h0":"Merkmal | QF‑Test Handbuch"},"133":{"id":133,"content":"Merkmal Im Merkmal Attribut wird, grob gesagt, ein Text abgelegt, der für die Wiedererkennung nützlich ist und direkt mit der Komponente selbst in Verbindung steht. Dies kann entweder der Text der Komponente sein (z.B. Beschriftung auf einem Button), eine programmtechnisch zugeordnete Beschriftung/Label der Komponente (z.B. CheckBox, RadioButton, TextField) oder ein Titel (Fenster, Dialog, TitledPanel). Bei einer Webseite die URL. Die konkreten Werte, die in Frage kommen, sind klassen- und technologiespezifisch. Für alle Engines außer Web siehe Generische Klassen. Für Web gelten die in Merkmal bei Web-Komponenten beschriebenen Zuordnungen. Häufig ist der Wert des Merkmal mit dem in Weiteres Merkmal qfs:labelBest identisch. Dies liegt daran, dass die Beste Beschriftung für die Komponente in einer der qfs:label*-Variantenabgespeichert wird und dies meist der Text ist, der direkt mit der Komponente in Verbindung steht. Die Redundanz macht dennoch Sinn, da für das weitere Merkmal der Status gesetzt werden kann: 'Ignorieren', 'Sollte übereinstimmen' oder 'Muss übereinstimmen'. Für das Merkmal gilt implizit immer der Status 'Sollte übereinstimmen'. Es kann aber aus Gründen der Rückwärtskompatibilität nicht von den qfs:label*-Varianten abgelöst werden. Der Einfluss des Merkmal bei der Generierung der QF‑Test ID ist in Generierung der QF‑Test ID der Komponente beschrieben. Beispiele hierzu finden Sie in Woran erkennt man eine robuste Komponentenerkennung?. Komponenten können in einer SmartID auch direkt über das Merkmal adressiert werden, ohne Aufnahme eines Komponente-Knoten.","hash":"usec_components_feature","h0":"Merkmal"},"134":{"id":134,"content":"Verwendung von regulären Ausdrücken oder Arbeiten mit dynamischen Fenstertiteln Im Video 'Komponentenerkennung' wird die Verwendung von regulären Ausdrücken in Fenstertiteln ab Minute 13:07 erläutert. In vielen Applikationen werden Sie auf die Situation treffen, dass keine eindeutigen Namen seitens der Entwicklung vergeben wurden und QF‑Test dieselben Komponenten immer wieder an unterschiedlichen Stellen aufzeichnet. Die Wiedergabe dieser aufgezeichneten Komponenten funktioniert dann meistens solange sich die Geometrie des Fensters nicht drastisch verändert. In diesem Fall ist es wahrscheinlich, dass der Titel des Hauptfensters sich immer wieder ändert, z.B. kann der Titel die aktuelle Versionsnummer, den gerade eingeloggten Benutzer oder einen Dateinamen beinhalten. Wenn Sie Ihre Tests stabil halten wollen und die unterschiedlich aufgezeichneten Fenster als einen Fenster Knoten unter dem Fenster und Komponenten Knoten behandeln wollen, dann selektieren Sie den Fenster Knoten und editieren Sie dessen Merkmal Attribut. Dort ersetzen Sie den dynamischen Teil durch einen regulären Ausdruck und haken dabei die Checkbox 'Als Regexp' an. Nun sollten Ihre Tests wieder funktionieren. Hier sehen Sie ein Beispiel für einen regulären Ausdruck für eine Komponente des CarConfigurators, deren Merkmal mit dem Wort 'Fahrzeuge' beginnt, aber danach einen beliebigen dynamischen Teil enthalten kann:","hash":"sec_bpCRRegex","h0":"Verwendung von regulären Ausdrücken oder Arbeiten mit dynamischen Fenstertiteln"},"135":{"id":135,"content":"Abbildung 5.8: Ein regulärer Ausdruck im Merkmal Attribut Reguläre Ausdrücke finden bei QF‑Test an vielen Stellen Verwendung. Im \"Reguläre Ausdrücke - Regexps\" finden Sie detaillierte Informationen zu ihrer Verwendung.","hash":"fig_advBpCrRegexps","h4":"Abbildung 5.8: Ein regulärer Ausdruck im Merkmal Attribut"},"136":{"id":136,"content":"Merkmal bei Web-Komponenten Das Merkmal für Web-Komponenten wird gemäß der folgenden Logik ermittelt: Bei HTML-Elementen, die ein Frame oder Document sind, wird die URL in das Merkmal Attribut eingetragen. Falls keine der speziellen nachfolgenden Zuordnung zutrifft, wird das id-Attribut des HTML-Elements verwendet, soweit vorhanden und eindeutig genug. Falls nicht, wird der Text des HTML-Elements, bei Bedarf gekürzt, im Merkmal Attribut eingetragen. Spezielle Zuordnungen:","hash":"usec_components_feature_web","h0":"Merkmal bei Web-Komponenten"},"137":{"id":137,"content":"Bei HTML-Elementen, die ein Frame oder Document sind, wird die URL in das Merkmal Attribut eingetragen. Falls keine der speziellen nachfolgenden Zuordnung zutrifft, wird das id-Attribut des HTML-Elements verwendet, soweit vorhanden und eindeutig genug. Falls nicht, wird der Text des HTML-Elements, bei Bedarf gekürzt, im Merkmal Attribut eingetragen. Spezielle Zuordnungen: Tag-Name des HTML-Elements Wert des Merkmal Attributs TEXTText des HTML-Elements, bei Bedarf gekürzt AText des HTML-Elements (bei Bedarf gekürzt), sonst Fenstertitel, sonst URL FIELDSETText eines darin enthaltenen HTML-Elements mit dem Tag \"LEGEND\" FORMWert des Attributs \"name\" IMGWert des Attributs \"alt\", sonst \"src\", sonst Teil der URL INPUTWert des Attributs \"name\" Bei RadioButtons mit identischen Namen -> Wert des Attributs \"name\" mit angehängtem Wert des Attributs \"value\" BUTTONWert des Attributs \"name\", sonst Text des HTML-Elements, bei Bedarf gekürzt LABELText des HTML-Elements, bei Bedarf gekürzt SELECTWert des Attributs \"name\" OPTIONWenn die Option OPT_WEB_USE_OPTION_LABEL gesetzt ist, Wert des Attributs \"label\", ansonsten der Text des HTML-Elements, bei Bedarf gekürzt OPTGROUPWert des Attributs \"label\" IFRAMEWert des Attributs \"id\", sonst \"name\", sonst \"src\" Tabelle 5.1: Merkmal Attribut für Web-Komponenten Bei sehr speziellen Konstellation kann das Merkmal Attribut auch einen Wert erhalten, der von obiger Logik abweicht.","hash":"table_5.1","h0":"Merkmal bei Web-Komponenten"},"138":{"id":138,"content":"Pro Handbuch","hash":"","h0":"Weitere Merkmale | QF‑Test Handbuch"},"139":{"id":139,"content":"Pro Handbuch","hash":"home-link","h0":"Weitere Merkmale | QF‑Test Handbuch"},"140":{"id":140,"content":"Weitere Merkmale In der Tabelle Weitere Merkmale werden unterschiedliche Informationen, die für die Wiedererkennung der Komponente nützlich sein können, abgespeichert. Unter Weitere Merkmale finden Sie eine Aufstellung der standardmäßig erzeugten Einträge. Sie können aber auch eigene über einen ExtraFeatureResolver (siehe \"Das ExtraFeatureResolver Interface\") hinzufügen. Einige der weiteren Merkmale werden prophylaktisch aufgezeichnet und im Normalfall gar nicht für die Komponentenerkennung genutzt. Dies betrifft hauptsächlich Informationen zur Komponentenklasse, die QF‑Test für die Ableitung der Generische Klassen nutzt. Sie erhalten standardmäßig den Status 'Ignorieren'. Dieser kann umgestellt werden, wenn in Spezialfällen der Originalwert von Interesse ist. Für die Wiedererkennung ist die Beschriftung einer Komponente relevant, für die unterschiedliche qfs:label*-Varianten zur Verfügung stehen.","hash":"usec_components_extrafeatures","h0":"Weitere Merkmale"},"141":{"id":141,"content":"qfs:label*-Varianten Beschriftungen sind nach dem Komponentenbezeichner, der von den Entwicklern vergeben und von QF‑Test im Attribut Name gespeichert wird, das nächstbeste Kriterium für die Komponentenerkennung. Beschriftungen können über unterschiedliche Arten dargestellt werden. Bei einem Button ist dies meist der eigene Text, bei einem Textfeld hingegen ein Text, der häufig links oder oberhalb des Eingabefeldes steht. Es gibt programmtechnisch zugeordnete Beschriftungen. Auch der Tooltip, der Name eines Images oder der Titel der Komponente können als Beschriftung genutzt werden. QF‑Test speichert Informationen zur Beschriftung in den weiteren Merkmalen ab. Bis QF‑Test Version 6 wurde nach einem bestimmten Algorithmus die am besten passende Beschriftung ermittelt und im weiteren Merkmal qfs:label abgespeichert. Ab QF‑Test Version 7.0 werden in Frage kommende Beschriftungen in weiteren Merkmalen abgespeichert, die mit qfs:label beginnen und einen spezifischen Zusatz für den Fundort der Beschriftung erhalten, zum Beispiel qfs:labelText für den Text des Buttons oder qfs:labelLeft für die Beschriftung links des Eingabefeldes. Der Vorteil einer spezifischen Beschriftung ist einerseits die Performanz bei der Wiedergabe, da direkt nach der entsprechenden Beschriftung gesucht werden kann, andererseits die Flexibilität. Wenn Sie in vorhandenen Komponentenknoten das weitere Merkmal qfs:label auf den neuen Algorithmus umstellen wollen, ändern Sie bitte den Namen des weiteren Merkmals auf qfs:labelBest. In diesem Fall wird, wie bisher, aus allen in Frage kommenden Beschriftungen die beste Beschriftung ermittelt. Weitere Informationen zur Umstellung finden Sie im Kapitel Das ExtraFeatureResolver Interface. Für Beschriftungen, die über die Position gefunden werden, gibt die folgende Grafik Auskunft:","hash":"usec_components_qfslabel","h0":"qfs:label*-Varianten"},"142":{"id":142,"content":"qfs:labelTopleftqfs:labelTop- qfs:labelLeftbetrachtete Komponenteqfs:labelRight -qfs:labelBottom- Tabelle 5.2: qfs:label*-Varianten mit Position Nachfolgend finden Sie eine Auflistung aller zur Verfügung stehenden qfs:label*-Varianten, im Anschluss daran die Beschreibungen. Außerdem wird die Syntax für die direkte Adressierung in einer SmartID aufgelistet. Die Angabe unter \"Kategorie\" entspricht den Begriffen, die bei der Beschreibung für Generische Klassen in der Rubrik \"qfs:label*\" verwendet werden.","hash":"table_5.2","h0":"qfs:label*-Varianten"},"143":{"id":143,"content":"qfs:label*-Varianten SmartID-Kennzeichner Kategorie qfs:labelTitle #title= Titel qfs:labelFor #for= Zugeordnetes Label qfs:labelText #text= Eigener Text qfs:labelLeft #left= Label in der Nähe qfs:labelTop #top= Label in der Nähe qfs:labelRight #right= Label in der Nähe qfs:labelBottom #bottom= Label in der Nähe qfs:labelTopleft #topleft= Label in der Nähe qfs:labelInherited #inherited= Label in der Nähe qfs:labelTooltip #tooltip= Tooltip qfs:labelImage #image= Icon-Beschreibung qfs:labelPlaceholder #placeholder= Prompt Tabelle 5.3: qfs:label*-Varianten qfs:labelTitle Die Überschrift einer Komponente, zum Beispiel eines Fensters (Komponentenklasse \"Window\") oder einer Kachel mit Titel, also der Komponentenklasse \"Panel:titledPanel\". qfs:labelFor Text, der im Programmcode der Komponente als Beschriftung zugewiesen wird. Bei Web-Anwendungen zum Beispiel über das HTML-Attribut labelFor. qfs:labelText Der Text der Komponente selbst. qfs:labelLeft Der Text einer Komponente der Klasse 'Label' links der betrachteten Komponente. qfs:labelTop Der Text einer Komponente der Klasse 'Label' über der betrachteten Komponente. qfs:labelRight Der Text einer Komponente der Klasse 'Label' rechts der betrachteten Komponente. qfs:labelBottom Der Text einer Komponente der Klasse 'Label' unter der betrachteten Komponente. qfs:labelTopleft Der Text einer Komponente der Klasse 'Label' oben links der betrachteten Komponente. qfs:labelInherited Die Beschriftung einer anderen Komponente. Beispiel: \"Straße: Hauptstraße 11\", wobei der Straßenname und die Hausnummer in eigenen Eingabefeldern stehen. Das Eingabefelder für die Hausnummer erhält hier \"qfs:labelInherited\" mit dem Wert \"Straße:\". qfs:labelTooltip Der Tooltip der Komponente selbst. qfs:labelImage Der Name eines der Komponente zugeordneten Images. qfs:labelPlaceholder Nur bei Web-Anwendungen. Der Prompt, der für die Komponente angezeigt wird, wenn sie keine Eingabe des Benutzers enthält. Der Einfluss auf die QF‑Test ID der Komponente der qfs:label*-Variante, die die Beste Beschriftung darstellt, ist in Generierung der QF‑Test ID der Komponente beschrieben. Informationen zum Übergang vom alten auf den neuen Algorithmus finden Sie in Das ExtraFeatureResolver Interface.","hash":"qfslabels_overview_table","h0":"qfs:label*-Varianten"},"144":{"id":144,"content":"Beste Beschriftung Bei der Komponentenanalyse werden die in Frage kommenden Beschriftungen nach bestimmten Kriterien bewertet und als in den Weiteren Merkmalen abgespeichert, wobei die Namen der Einträge qfs:label anfangen (siehe \"qfs:label*-Varianten\"). Die qfs:label*-Variante mit der besten Bewertung (beste Beschriftung) erhält den Status \"Sollte übereinstimmen\", die anderen \"Ignorieren\". Die Reihenfolge der Einträge in obiger Tabelle entspricht grob der Gewichtung. Sie ist aber auch von der Komponentenklasse abhängig. Dokumentiert ist dies in der Rubrik \"qfs:label*\" in den Eigenschaften der einzelnen Generische Klassen. Bei den qfs:label*-Varianten der Kategorie \"Label in der Nähe\" spielen auch die Entfernung des Labels und der Überlappungsgrad eine Rolle. Die beste Beschriftung wird zusätzlich in dem weiteren Merkmal mit dem Namen qfs:labelBest abgespeichert. In einer SmartID kann dieses Merkmal über den Kennzeichner qlabel angesprochen werden. Siehe auch SmartID-Syntax für Weitere Merkmale.","hash":"usec_components_qfslabelbest","h0":"Beste Beschriftung"},"145":{"id":145,"content":"qfs:text qfs:text enthält den Textinhalt der Komponente. Dies dient als Zusatzinformation für Textfelder oder PDF-Komponenten. Es wird nicht aufgenommen, kann aber seit QF‑Test Version 5.3 ohne zusätzlichen Resolver für die Komponentenerkennung genutzt werden.","hash":"usec_components_qfstext","h0":"qfs:text"},"146":{"id":146,"content":"value value enthält bei bestimmten HTML-Komponenten wie Checkboxen und Radiobuttons den Wert des gleichnamigen HTML-Attributs, sofern dieser Aussagekräftig ist. Dabei spiegelt value nicht den aktuell ausgewählten Wert oder gar den Selektionsstatus des Elements wider, sondern den statischen Wert, der übertragen wird, wenn das Element ausgewählt ist.","hash":"usec_components_value","h0":"value"},"147":{"id":147,"content":"Pro Handbuch","hash":"","h0":"Index | QF‑Test Handbuch"},"148":{"id":148,"content":"Pro Handbuch","hash":"home-link","h0":"Index | QF‑Test Handbuch"},"149":{"id":149,"content":"Index Der Index einer Komponente kann ebenfalls zur Wiedererkennung verwendet werden. Allerdings ist zwischen dem Index eines Komponente-Knoten und dem in einer SmartID verwendeten Index zu unterscheiden: Ersterer bezieht sich immer auf GUI-Elemente dieser Klasse bezogen auf die Parent-Komponente. Bei der SmartID bezieht sich der Index auf die in Frage kommenden Komponenten mit der angegeben SmartID (siehe SmartID mit Index).","hash":"usec_components_index","h0":"Index"},"150":{"id":150,"content":"Pro Handbuch","hash":"","h0":"Geometrie | QF‑Test Handbuch"},"151":{"id":151,"content":"Pro Handbuch","hash":"home-link","h0":"Geometrie | QF‑Test Handbuch"},"152":{"id":152,"content":"Geometrie Die Geometrie trägt nur einen geringen Teil zur Komponentenerkennung bei, wenn andere Kriterien vorhanden sind. Es kann aber auch vorkommen, dass Komponenten weder einen Namen noch eine Beschriftung noch brauchbare weitere Merkmale noch einen brauchbaren Index vorweisen. Wenn dann auch über anwendungsspezifische Resolver (siehe \"Das resolvers-Modul\") keine Wiedererkennungsmerkmale bereitgestellt werden können, stützt sich Wiedererkennung auf die Komponentenklasse, die immer vorhanden ist, die Komponentenhierarchie sowie Position und Größe der Komponente. Wenn in diesem Fall darauf geachtet wird, dass die Größe der Fenster bei der Wiedergabe die gleiche Größe wie bei der Aufnahme haben (siehe Komponentenevent), sollte die Komponentenerkennung stabil sein. Der Änderungsaufwand bei Versionswechseln der Applikation kann aber etwas höher sein, da Positionsänderungen von Komponenten explizit nachgezogen werden müssen.","hash":"usec_components_geometry","h0":"Geometrie"},"153":{"id":153,"content":"Pro Handbuch","hash":"","h0":"Komponentenhierarchie | QF‑Test Handbuch"},"154":{"id":154,"content":"Pro Handbuch","hash":"home-link","h0":"Komponentenhierarchie | QF‑Test Handbuch"},"155":{"id":155,"content":"Komponentenhierarchie Die Verschachtelung wird bei Komponentenevent ebenfalls für das Wiederauffinden genutzt. Bei Komponente-Knoten werden die Container, in denen eine Komponente liegt, bei der Aufnahme aufgezeichnet. Ob sie bei vorhandenem Name Attribut für die Wiedererkennung genutzt werden sollen, kann über die Optionen Gewichtung von Namen (Wiedergabe) und Gewichtung von Namen (Aufnahme) gesteuert werden. Die jeweils günstige Einstellung wird in Über die Vergabe von Bezeichnern beschrieben. Komponente-Knoten können im Komponentenbaum aus tiefen Verschachtelungen in übergeordnete Knoten verschoben werden, solange diese Verflachung der Komponentenhierarchie die Erkennung nicht beeinträchtigt. Manchmal kann diese Vorgehensweise sogar zu besserer Stabilität der Erkennung führen, insbesondere, wenn die Wiedererkennungskriterien für die übergeordneten Knoten instabil sind. Oder wenn übergeordnete Komponenten nicht immer existieren, zum Beispiel Scroll-Panels, die nur nach Bedarf in die GUI-Hierarchie eingefügt werden. Bei einer SmartID kann die Komponentenhierarchie ebenfalls für die Wiedererkennung genutzt werden. Hier wird die zu verwendende übergeordnete Komponente (oder auch mehrere) explizit in der SmartID angegeben. Nähere Informationen finden Sie in SmartID-Syntax für Komponentenhierarchien. Über Geltungsbereich (Scope) kann der Suchbereich für Komponenten bei der Wiedergabe auf eine bestimmte Hierarchieebene eingeschränkt werden.","hash":"usec_components_hierarchy","h0":"Komponentenhierarchie"},"156":{"id":156,"content":"Pro Handbuch","hash":"","h0":"Komponente-Knoten | QF‑Test Handbuch"},"157":{"id":157,"content":"Pro Handbuch","hash":"home-link","h0":"Komponente-Knoten | QF‑Test Handbuch"},"158":{"id":158,"content":"Komponente-Knoten Wenn Komponente Knoten an Stelle von SmartIDs verwendet werden, speichert QF‑Test die Wiedererkennungskriterien der aufgezeichneten Komponenten in Fenster und Komponente Knoten ab, deren hierarchische Anordnung der Struktur des GUI im SUT entspricht. Diese Knoten befinden sich unterhalb des Fenster und Komponenten Knotens. Das folgende Bild zeigt einen Ausschnitt der Komponente-Knoten, die zum QF‑Test Hauptfenster gehören:","hash":"usec_componentstep","h0":"Komponente-Knoten"},"159":{"id":159,"content":"Abbildung 5.9: Komponentenhierarchie eines Swing SUT Im Detailbereich eines Komponente Knotens werden die Wiedererkennungskriterien abgespeichert. Zusätzlich befindet sich darin das QF‑Test ID Attribut. Dieses ist die Referenz-ID für alle Knoten in den Tests, die sich auf eine Komponente beziehen.","hash":"figure_5.9","h4":"Abbildung 5.9: Komponentenhierarchie eines Swing SUT"},"160":{"id":160,"content":"Abbildung 5.10: Komponentenknoten Jeder Knoten einer Testsuite besitzt ein QF‑Test ID Attribut, welches für die meisten Knoten keine besondere Bedeutung hat und automatisch verwaltet wird. Für Komponenten Knoten hat die QF‑Test ID dagegen eine wichtige Funktion. Andere Knoten mit einer Zielkomponente, wie Events oder Checks, haben das Attribut QF‑Test ID der Komponente, welches sich auf die QF‑Test ID des Komponente-Knotens bezieht. Diese indirekte Referenzierung der GUI-Elemente ist sehr nützlich: wenn sich die Oberfläche des SUT auf eine Weise ändert, die QF‑Test nicht automatisch kompensieren kann, müssen lediglich die Komponenten Knoten der nicht erkannten Komponenten angepasst werden und der Test läuft wieder. Es ist sehr wichtig sich klarzumachen, dass die QF‑Test ID einer Komponente nur ein künstliches Konzept für den internen Gebrauch innerhalb von QF‑Test ist, nicht zu verwechseln mit dem Attribut Name welches zur Identifikation der Komponente im SUT dient, worauf wir im folgenden Abschnitt genau eingehen werden. Der eigentliche Wert der QF‑Test ID ist vollkommen irrelevant und steht in keinem Bezug zum GUI des SUT. Entscheidend ist nur, dass die QF‑Test ID eindeutig ist und dass andere Knoten sich korrekt darauf beziehen. Andererseits wird die QF‑Test ID des Komponente-Knotens in der Baumansicht angezeigt, und zwar nicht nur für die Komponente selbst, sondern auch für Events und andere Knoten, die sich darauf beziehen. Folglich sollten Komponenten aussagekräftige QF‑Test IDs besitzen, die auf die eigentliche Komponente im GUI hinweisen. Wenn QF‑Test einen Komponente-Knoten anlegt, muss es ihm automatisch eine QF‑Test ID zuweisen. Es tut sein Bestes, einen aussagekräftigen Bezeichner aus den verfügbaren Informationen zu konstruieren. Details hierzu finden Sie in Generierung der QF‑Test ID der Komponente. Sollte Ihnen eine generierte QF‑Test ID nicht zusagen, können Sie diese ändern. Wenn Sie dabei einen Wert wählen, der schon vergeben ist, gibt QF‑Test eine Warnung aus. Haben Sie bereits Events aufgezeichnet, die sich auf diese Komponente beziehen, bietet QF‑Test an, deren QF‑Test ID der Komponente Attribute automatisch anzupassen. Diese Automatik funktioniert nicht bei Referenzen mit Variablen im QF‑Test ID der Komponente Attribut. Ein häufig gemachter Fehler ist es, das Attribut QF‑Test ID der Komponente eines Events anstelle der QF‑Test ID selbst zu ändern. Dadurch wird die Verbindung zwischen dem Event und seiner Zielkomponente zerstört, was zu einer UnresolvedComponentIdException führt. Sie sollten das also nur dann tun, wenn Sie tatsächlich die Zielkomponente ändern wollen. Häufig werden Tests aus vorhandenen Prozeduren zusammengestellt. Dann ist es oft hilfreich, dass in Abschnitt Komponenten aufnehmen beschriebene Verfahren zum direkten Aufzeichnen von Komponenten zu verwenden. Die QF‑Test ID der so aufgenommenen Komponente wird in der Zwischenablage des Betriebssystems gespeichert und kann somit einfach im entsprechenden Prozedurparameter eingefügt werden. Man kann mittels Komponenten aufnehmen auch zunächst die gesamte Struktur der Komponenten des SUT erstellen, um einen Überblick zu erhalten und sinnvolle QF‑Test IDs zu vergeben. Bei Aufnahmen werden dann diese QF‑Test IDs verwendet.","hash":"figure_5.10","h4":"Abbildung 5.10: Komponentenknoten"},"161":{"id":161,"content":"Pro Handbuch","hash":"","h0":"SmartID | QF‑Test Handbuch"},"162":{"id":162,"content":"Pro Handbuch","hash":"home-link","h0":"SmartID | QF‑Test Handbuch"},"163":{"id":163,"content":"SmartID SmartIDs ermöglichen eine einfache und flexible Wiedererkennung von Komponenten direkt auf Basis der ID, ohne dass die Wiedererkennungskriterien an anderer Stelle abgespeichert werden. Dies verschlankt den aufgenommenen Komponentenbaum in \"Fenster und Komponenten\" deutlich. Bei ausschließlicher Verwendung von SmartIDs wird der Komponentenbaum überhaupt nicht mehr benötigt. Es ist allerdings zu berücksichtigen, dass diese Flexibilität und Vereinfachung ihren Preis hat und - je nach Situation - die Performanz und Wartbarkeit beeinträchtigen kann. Im Februar 2024 fand ein Spezialwebinar zum Thema statt. Hier geht es zum Videomitschnitt des Spezialwebinars auf unserem QF‑Test YouTube-Kanal. SmartIDs verwenden die gleichen Wiedererkennungsmerkmale, die bei der klassischen Komponentenerkennung in den Komponente-Knoten abgespeichert werden. Der Unterschied ist, dass aus den möglichen Wiedererkennungsmerkmalen eines oder mehrere explizit ausgewählt und an Stelle der Referenz zur aufgenommenen Komponente eingetragen werden. Zum Beispiel direkt im Attribut QF‑Test ID der Komponente eines Mausklick-Knotens. Ziel der SmartIDs ist eine Verschlankung des Komponentenbaums - so weit sinnvoll, aber nicht um jeden Preis. Einfaches soll möglichst einfach genutzt werden können, aber wenn es schwierig ist, eine Komponente anzusprechen, sind Komponente Knoten besser geeignet. Die Themen \"Eindeutigkeit\" und \"Performanz\" können alternativ über das Scope-Konzept adressiert werden, siehe Geltungsbereich (Scope). Die SmartID wird durch ein führendes # gekennzeichnet. Die einfachste Version der SmartID ist entweder der Name oder die Beschriftung der Komponente mit einem vorangestellten #. Zum Beispiel #username, um eine Komponente mit dem Namen username anzusprechen oder #Anwendername, wenn Anwendername die Beschriftung des Feldes ist. Typischerweise besteht die SmartID jedoch aus #, gefolgt von der Klasse der Komponente, die mit einem Doppelpunkt abgeschlossen wird. Bei Beschriftungen folgt nun ein optionaler Kennzeichner mit Gleichheitszeichen. Dahinter steht der Wert der SmartID, zum Beispiel #TextField:left=Anwendername. Der Kennzeichner gibt an, worauf sich der SmartID-Wert bezieht. Bei der Wiedergabe ohne Kennzeichner greift die Option Priorität bei Aufnahme von SmartIDs mit Kennzeichner. Bei der Aufzeichnung wird je nach dem wie die Option Für SmartID immer den Kennzeichner aufnehmen gesetzt ist, entweder kein Kennzeichner oder der nach dieser Priorisierung als erster gefundener Kennzeichner aufgezeichnet. Es stehen folgende Kennzeichner zur Verfügung: name: Name, siehe auch SmartID-Syntax für Name. feature: Merkmal, siehe auch SmartID-Syntax für Merkmal. label: Merkmal ist eine Sonderform, die feature oder eine der qfs:label*-Varianten für die Übereinstimmung akzeptiert. Die Namen der Weitere Merkmale, beziehungsweise Kurzformen davon, zum Beispiel qlabel für die Beste Beschriftung. Siehe auch SmartID-Syntax für Weitere Merkmale. Die Angabe der Klasse und des Kennzeichners dienen der besseren Lesbarkeit und der Performanz. Ob die Klasse aufgenommen wird, kann über die Option Für SmartID immer die Klasse aufnehmen gesteuert werden. Dies gilt jedoch nur für Komponenten, deren Klasse zu den Generische Klassen gehört. Für andere Klassen muss der Klassenname auf jeden Fall spezifiziert werden, zum Beispiel #DIV:compid. Die SmartID wird im Attribut QF‑Test ID der Komponente eingetragen, zum Beispiel im Attribut QF‑Test ID der Komponente von Event- oder Check-Knoten. Sie kann genauso wie die QF‑Test ID der Komponente in Variablen gespeichert, in Parametern übergeben oder in Skripten genutzt werden. Bei komplexen Komponenten wie Tabellen, Listen oder Bäumen kann die SmartID ebenfalls die QF‑Test ID der Komponente ersetzen. Der Index, der das Unterelement bezeichnet, bleibt unverändert. Im Anschluss an eine SmartID kann eine darin enthaltene Komponente entweder über eine weitere SmartID oder mittels XPath (Adressierung mit XPath und/oder CSS-Selektoren) adressiert werden. SmartID-spezifische Sonderzeichen und Trenner für Unterelemente (\":\", \"@\", \"&\" und \"%\", siehe auch \"SmartIDs: Sonderzeichen\") müssen mit einem vorangestellten \\ geschützt werden, wenn sie im Wert der SmartID oder in der Klasse vorkommen. SmartIDs können für alle Client-Technologien genutzt werden. Wie bei SmartIDs ist zu berücksichtigen, dass die Aktualisierung nicht so komfortabel ist wie bei Komponente-Knoten Knoten. Allerdings steht in QF‑Test eine mächtige \"Suchen und Ersetzen\" Funktionalität zur Verfügung, um SmartIDs suiteübergreifend anzupassen. Für eine kleine Einführung in SmartID lesen Sie auch unseren Blogartikel SmartID - Die nächste Generation der Komponentenerkennung .","hash":"usec_smartid","h0":"SmartID"},"164":{"id":164,"content":"Anwendungsbereiche für SmartIDs Die Anwendungsbereiche sind die gleichen, in denen bisher Generische Komponenten zum Einsatz kamen. SmartIDs ersetzen generische Komponenten weitgehend und sind einfacher zu nutzen als diese. Lesbarkeit Bei der direkten Aufnahme von Testfällen kann der Einsatz von SmartIDs die aufgenommenen Event- und Checkknoten lesbarer machen. Insbesondere, wenn die aufgenommenen Namen der Komponenten kryptisch sind und stabile Beschriftungen vorhanden sind. In diesem Fall macht es Sinn, die Reihenfolge für die Aufnahme der Wiedererkennungskriterien auf \"zuerst Beschriftung, dann Name\" zu ändern. Stellen Sie hierzu die Option Priorität bei Aufnahme von SmartIDs mit Kennzeichner auf label,name. Ignorieren der Komponentenhierarchie Manche Anwendungen haben tief verschachtelte Komponentenhierarchien. SmartIDs machen es einfach, den Komponentenbaum zu reduzieren, was insbesondere dann hilfreich ist, wenn die Komponentenhierarchie über die Versionen hinweg nicht stabil bleibt. (Bisher wurden zu diesem Zweck Generische Komponenten eingesetzt. Dies ist auch weiterhin möglich, auch parallel zu SmartIDs.) Testgetriebene Entwicklung Bei testgesteuerter Entwicklung bieten SmartIDs den großen Vorteil, dass keine Komponente-Knoten Knoten angelegt werden müssen. Außerdem werden bei testgesteuerter Entwicklung häufig die Komponentenbezeichner im technischen Design festgelegt, die dann für die Testerstellung genutzt werden können. Schlüsselwort-basierende Tests Schlüsselwort-basierende Tests werden technisch über Prozeduraufrufe und Parameter implementiert. Der Testersteller nimmt somit keine Komponenten auf und ist für die Identifikation der Komponenten auf visuelle Informationen aus dem GUI angewiesen. Dies kann die Beschriftung der Komponente oder deren Funktion (Klasse) sein. Weitere Informationen finden Sie in Schlüsselwortgetriebenes bzw. Keyword-Driven Testing mit QF‑Test. Integration mit anderen Test-Tools Bei der Steuerung der Testausführung seitens QF‑Test über andere Test-Tools wie Robot Framework können die Wiedererkennungskriterien direkt über SmartIDs spezifiziert werden.","hash":"sec_anwendungsbereiche_fur_smartids","h1":"Anwendungsbereiche für SmartIDs"},"165":{"id":165,"content":"SmartID-Syntax für Klasse Die Klasse wird in der SmartID direkt nach dem # angegeben und mit einem : abgeschlossen, zum Beispiel #Button:. Für Komponentenklassen, mit denen der Anwender typischerweise interagiert, muss die Klasse nicht explizit in der SmartID angegeben werden. Bei diesen Klassen kann die SmartID auch einfach nur den Komponentenbezeichner oder die Komponentenbeschriftung (entweder das Merkmal oder eine der qfs:label*-Varianten) umfassen, zum Beispiel #btnOK, wenn der Name des Buttons \"btnOK\" ist, oder #Speichern, wenn die Beschriftung des Buttons \"Speichern\" lautet. Dies macht eine SmartID einfacher in der Handhabung, allerdings in gewissem Maß auf Kosten der Performance, da ohne Angabe der Klasse mehr Kandidaten auf Übereinstimmung mit der SmartID geprüft werden müssen. Auf Grund der besseren Performance wird bei der Aufnahme einer SmartID standardmäßig die Klasse mit aufgenommen. Falls dies nicht erwünscht ist, können Sie dies über die Option Für SmartID immer die Klasse aufnehmen deaktivieren. Im \"Generische Klassen\" ist in den Klasseneigenschaften vermerkt, wenn die Klasse in der SmartID angegeben werden muss. Alle Klassen, die nicht in dem Kapitel genannt werden, müssen immer in der SmartID spezifiziert werden. Beispiel: #DIV:addresses wobei \"addresses\" hier der Name des DIV-Elements in einer Web-Anwendungen ist. Panels sind insofern ein Sonderfall, da sich Panels mit Beschriftung für geschachtelte SmartIDs (siehe \"SmartID-Syntax für Komponentenhierarchien\") oder Scopes (siehe \"Geltungsbereich (Scope)\") anbieten. Daher gehört der Klassentyp Panel:TitledPanel zu den SmartID-Klassen und muss nicht separat angegeben werden. Wenn Sie zusätzlich zur generischen Klasse einen vordefinierten Klassentyp verwenden, können Sie diese Kombination wie gewohnt schreiben, zum Beispiel #Button:ComboBoxButton:. Die vordefinierten Klassentypen finden Sie in Generische Klassen. Bei eigenen Klassentypen muss der innere Doppelpunkt mittels \\ geschützt werden, zum Beispiel #Panel\\:myPanel:. Auch die Indextypkennzeichner \"@\", \"&\" und \"%\" müssen mit einem vorangestellten \\ geschützt werden (siehe \"SmartIDs: Sonderzeichen\"). Informationen zu Kombinationsmöglichkeiten finden Sie in \"SmartIDs - allgemeine Syntax\".","hash":"usec_smartid_class","h1":"SmartID-Syntax für Klasse"},"166":{"id":166,"content":"SmartID-Syntax für Name Ein Name kann in der SmartID direkt nach dem # angegeben werden, z.B. #txtUsername. Wenn die Klasse der Komponente zu den Generische Klassen gehört, reicht die einfache Angabe des Namens. Ansonsten muss die Klasse vorangestellt werden, zum Beispiel #DIV:txtUsername. Der verwendete Name kann SmartID-spezifische Sonderzeichen enthalten \":\", \"@\", \"&\" und \"%\" (siehe auch \"SmartIDs: Sonderzeichen\"), diese müssen jedoch mit einem vorangestellten \\ geschützt werden. Um zu erzwingen, dass der Name für die Komponentenerkennung verwendet wird, kann in der SmartID Name= vorangestellt werden, zum Beispiel #Name=txtUsername. Die Groß-/Kleinschreibung muss beim Präfix Name= nicht beachtet werden. Weitere Informationen zu Kombinationsmöglichkeiten finden Sie in \"SmartIDs - allgemeine Syntax\".","hash":"usec_smartid_name","h1":"SmartID-Syntax für Name"},"167":{"id":167,"content":"SmartID-Syntax für Merkmal Das Wiedererkennungskriterium Merkmal kann in der SmartID direkt nach dem # angegeben werden, zum Beispiel #Anwendername. Wenn die Klasse der Komponente zu den Generische Klassen gehört, reicht die einfache Angabe des Merkmals. Ansonsten muss die Klasse vorangestellt werden, zum Beispiel #DIV:Anwendername. Das verwendete Merkmal kann SmartID-spezifische Sonderzeichen enthalten, diese müssen jedoch mit einem vorangestellten \\ geschützt werden. Um zu erzwingen, dass das Merkmal für die Komponentenerkennung verwendet wird, kann dem Merkmal Feature= vorangestellt werden, zum Beispiel #Feature=Anwendername. Wenn es unwichtig ist, ob das Merkmal oder das weitere Merkmal qfs:label*-Varianten verwendet wird, kann Label= vorangestellt werden, zum Beispiel #Label=Anwendername. Die Groß-/Kleinschreibung muss bei den Präfixen Feature= und Label= nicht beachtet werden. Weitere Informationen zu Kombinationsmöglichkeiten finden Sie in \"SmartIDs - allgemeine Syntax\".","hash":"usec_smartid_feature","h1":"SmartID-Syntax für Merkmal"},"168":{"id":168,"content":"SmartID-Syntax für Weitere Merkmale Wiedererkennungskriterien aus der Gruppe der Weitere Merkmale stehen ebenfalls für die SmartID zur Verfügung. Diese können über den Kennzeichner, der vor den SmartID-Wert gesetzt wird, angesprochen werden. Zwischen Kennzeichner und SmartID steht ein =. Für alle Weiteren Merkmals entspricht der Kennzeichner dem Namen des weiteren Merkmals. Die Groß- und Kleinschreibung muss berücksichtigt werden. Der SmartID-Wert entspricht dem Wert des weiteren Merkmals. Auch hier ist die Groß- und Kleinschreibung relevant. Beispiele: Die SmartID #module=Modul1 referenziert eine Komponente mit einem weiteren Merkmal mit dem Namen module und dem Wert Modul1. Die SmartID #my\\:foo=Irgend\\&etwas referenziert eine Komponente mit einem weiteren Merkmal mit dem Namen my:foo und dem Wert Irgend&etwas. Für die qfs:label*-Varianten gibt es Kurzformen für den Kennzeichner. Diese werden weiter unten in diesem Kapitel erläutert. SmartID-spezifische Sonderzeichen \":\", \"@\", \"&\" und \"%\" (siehe auch \"SmartIDs: Sonderzeichen\") müssen mit einem vorangestellten \\ geschützt werden, wenn sie im Wert der SmartID, Bezeichner oder in der Klasse vorkommen. Informationen zu Kombinationsmöglichkeiten finden Sie in \"SmartIDs - allgemeine Syntax\". qfs:label*-Varianten Eine herausragende Stellung haben die qfs:label*-Varianten, die Beschriftungen für eine Komponente enthalten. Wenn für eine Komponente Beschriftungen existieren, kann in der SmartID entweder die Beste Beschriftung oder eine spezifische Beschriftung genutzt werden. Der Vorteil einer spezifischen Beschriftung ist neben der präziseren Angabe auch die Performanz bei der Wiedergabe, da direkt nach der entsprechenden Beschriftung gesucht werden kann. Andernfalls wird aus allen in Frage kommenden Beschriftungen die beste Beschriftung ermittelt, dieser Vorgang ist zeitintensiver. Um eine spezifische Beschriftung zu nutzen, starten Sie mit # dann ein Bezeichner, das heißt, der Kurzform des weiteren Merkmalnamens (siehe qfs:label*-Varianten), gefolgt von \"=\" und dem SmartID-Wert an, zum Beispiel #left=Vorname. Die beste Beschriftung können Sie direkt nach dem # angeben oder mit #qlabel= spezifizieren. Wenn Sie #label= verwenden, kann sich der Wert auf das Merkmal oder eine der qfs:label*-Varianten beziehen. Die Groß- und Kleinschreibung muss bei diesen Kennzeichnerkurzformen nicht beachtet werden. Die Beschriftung kann in der SmartID auch ohne Kennzeichner verwendet werden, zum Beispiel #Anwendername. Dann gilt die in der Option Priorität bei Aufnahme von SmartIDs mit Kennzeichner eingestellte Reihenfolge. Standardmäßig ist dies: Name - beste Beschriftung - Merkmal. Beispiele: #left=Vorname - Die Beschriftung links der Komponente muss \"Vorname\" lauten. #qlabel=Vorname - Die Beste Beschriftung für die Komponente muss \"Vorname\" lauten. #label=Vorname - Entweder muss das Merkmal oder die beste Beschriftung für die Komponente \"Vorname\" lauten. #Vorname - Entweder muss der Name der Komponente oder das Merkmal oder die beste Beschriftung für die Komponente \"Vorname\" lauten. Weitere Merkmale qfs:text und text Auch die weiteren Merkmale qfs:text und text haben eine Sonderstellung. Beide können über den Kennzeichner text= vor dem eigentlichen Wert angesprochen werden. Wenn dediziert qfs:text verwendet werden soll, können Sie qtext= verwenden. Beispiele: #text=Anna, #qtext=Benno Genaugenommen wird bei vorangestelltem #text= zuerst nach dem weiteren Merkmal #qfs:labelText= gesucht und dann nach qfs:text und text. Da jedoch die beiden letzteren speziell für Textkomponenten gedacht sind, für die #qfs:labelText= nicht aufgenommen wird, ergibt sich hier kaum Konfliktpotenzial. Die weiteren Merkmale qfs:text und text können auch ohne vorangestelltem #text= genutzt werden. Hierzu können Sie die Option Priorität bei Aufnahme von SmartIDs mit Kennzeichner entsprechend ergänzen, zum Beispiel \"name,feature,qlabel,text\". Weiteres Merkmal qfs:type Das weitere Merkmal qfs:type gibt den Typ einer Klasse an. Wenn nicht einer der von QF‑Test vordefinierten Typen (siehe Generische Klassen) verwendet wird, müssen die darin enthaltenen Doppelpunkte mit \\ geschützt werden.","hash":"usec_smartid_extrafeatures","h1":"SmartID-Syntax für Weitere Merkmale"},"169":{"id":169,"content":"SmartID mit Index Alle SmartIDs können mit einem Index versehen werden, wenn mehrere Komponenten für die gleiche SmartID in Frage kommen. Dabei zählt die technische Reihenfolge der Komponenten in der Hierarchie. Diese muss nicht der visuellen Reihenfolge entsprechen. Die Zählung des Index beginnt bei 0. Der Index wird in spitzen Klammern angegeben. Wird kein Index angegeben, wird implizit der Index 0 verwendet. Beispiele: #Name<2>, #TextField:<2>","hash":"usec_smartid_index","h1":"SmartID mit Index"},"170":{"id":170,"content":"Sonderfälle Bei Komponenten der Klasse Label gilt diese Reihenfolge nicht. Da sie in den meisten Fällen als Beschriftung anderer Komponentenklassen genutzt werden und dort im Merkmal oder als qfs:label*-Varianten abgespeichert werden, werden die Komponenten der Klasse Label nachrangig behandelt. Label Komponenten müssen daher explizit mit vorangestellter Klasse Label: angesprochen, zum Beispiel #Label:Vorname werden. Informationen zur allgemeinen SmartID-Syntax finden Sie in \"SmartIDs - allgemeine Syntax\".","hash":"usec_smartid_specialcases","h1":"Sonderfälle"},"171":{"id":171,"content":"SmartID-Syntax für Komponentenhierarchien Die Komponentenhierarchie kann auch mit SmartIDs für die Wiedererkennung genutzt werden. Als Trennzeichen zwischen den Hierarchieebenen dient @. Beispiele: Komponente in Container Die SmartID #Kundeninformationen@#Name referenziert eine Komponente mit der SmartID #Name in einer übergeordneten Komponente (zum Beispiel einem TitledPanel) mit der SmartID #Kundeninformationen. Komponente in \"normaler\" Komponente Manchmal werden Komponenten wie zum Beispiel ein Button keine guten eigenen Wiedererkennungsmerkmale besitzen, über die Komponente, in der sie liegen, sehr gut angesprochen werden können. Ein typisches Beispiel ist hier der Button zum Aufklappen der Liste in einer ComboBox: #ComboBoxSmartID@#Button: Komponente in Unterelement Links oder Buttons in Listen- oder Tabellenelementen können mit verschachtelten SmartIDs adressiert werden: #ListenSmartID&22@#Link:<1> Hierbei adressiert der Teil vor \"@\" ein Listenelement, #Link:<1> adressiert den zweiten Link darin.","hash":"usec_smartid_hierarchy","h1":"SmartID-Syntax für Komponentenhierarchien"},"172":{"id":172,"content":"Aufnehmen und Abspielen von SmartIDs Wenn Sie SmartIDs aufnehmen wollen, aktivieren Sie die Option Aufnahme von SmartIDs oder haken Sie einfach den Menüpunkt »Aufnahme«-»Aufnahme von SmartIDs« an. Bei der Aufnahme von SmartIDs prüft QF‑Test standardmäßig zunächst, ob ein Name vorhanden ist. Falls ja, wird dieser für die SmartID verwendet. Wenn nicht, wird nach einer Beschriftung gesucht (Merkmal oder Weitere Merkmale.) Mit der Option Priorität bei Aufnahme von SmartIDs mit Kennzeichner können die Kriterien und deren Reihenfolge umgestellt werden. Wenn die ermittelte SmartID für mehrere Komponenten gültig ist, wird erst versucht die Komponentenhierarchie zusätzlich vor der SmartID hinzuzufügen, ansonsten wird ein Index angefügt. Normalerweise ist die Aufnahme von SmartIDs relativ einfach. Anhängig von der Zielkomponente und den vorhandenen Informationen kann es aber vorkommen, dass keine SmartID aufgenommenen werden kann, so dass ganz klassisch ein Komponente-Knoten Knoten aufgenommen wird. Dies ist zum Beispiel der Fall, wenn dem GUI-Element keine generische Klasse zugewiesen werden kann oder wenn QF‑Test für das GUI-Element weder Name, noch Merkmal noch das weitere Merkmal qfs:label*-Varianten ermitteln kann. Standardmäßig wird die generische Klasse der SmartID vorangestellt. Dies erhöht nicht nur die Lesbarkeit sondern kann auch die Performanz bei der Wiedergabe deutlich verbessern. Über die Option Für SmartID immer die Klasse aufnehmen kann das Voranstellen der Klasse deaktiviert werden. Dabei ist zu beachten, dass die Klassen 'Label' und 'Panel' trotzdem vorangestellt werden, um die korrekte Wiedergabe zu gewährleisten. Das Abspielen von Knoten mit SmartIDs unterscheidet sich nicht von dem mit aufgenommenen Komponenten. Es können beide Varianten innerhalb eines Testfalls verwendet werden. SmartIDs können auch bei aufgenommenen Komponenten zur Adressierung untergeordneter Komponenten verwendet werden. Das Beispiel aufgenommeneListe&10@#Button: zeigt Kombination der QF‑Test ID einer aufgenommenen Liste mit Index und der SmartID des in dem Listenelement liegenden Buttons.","hash":"usec_smartid_recordreplay","h1":"Aufnehmen und Abspielen von SmartIDs"},"173":{"id":173,"content":"QF‑Test ID der Komponente als SmartID Es ist möglich, die QF‑Test ID einer aufgenommenen Komponente auf eine SmartID inklusive vorangestelltem # Kennzeichen zu setzen. Dies kann genutzt werden, um die SmartID quasi umzuleiten und die Komponentenerkennung klassisch über die Wiedererkennungsmerkmale der aufgenommenen Komponente durchzuführen. Einzelne Komponenten aufzunehmen macht insbesondere dann Sinn, wenn die SmartID lang und umständlich wird, schlechte Performance hat oder schwer eindeutig zu machen ist. Das SmartID-Kennzeichen # kann dann der Einheitlichkeit halber genutzt werden, muss aber nicht.","hash":"usec_components_qftestid_as_smartid","h1":"QF‑Test ID der Komponente als SmartID"},"174":{"id":174,"content":"Pro Handbuch","hash":"","h0":"Geltungsbereich (Scope) | QF‑Test Handbuch"},"175":{"id":175,"content":"Pro Handbuch","hash":"home-link","h0":"Geltungsbereich (Scope) | QF‑Test Handbuch"},"176":{"id":176,"content":"Geltungsbereich (Scope) Mit einem Geltungsbereich kann der Suchbereich für Komponenten eingegrenzt werden. Das ist nützlich, um eine Eindeutigkeit von Komponentenreferenzen herzustellen oder die Lesbarkeit eines Tests zu verbessern. Beispiel: Es gibt drei Panels mit Adressdaten mit identisch beschrifteten Textfeldern. Der Geltungsbereich kann nun auf eines der Panels gesetzt werden. Nun beziehen sich die angegebenen SmartIDs ausschließlich auf die Felder in diesem Panel. Der Geltungsbereich kann unter gewissen Umständen auch zur Beschleunigung der Komponentenerkennung genutzt werden, insbesondere bei Fenstern oder Webseiten, die sehr viele Komponenten enthalten. Ein Beispiel hierzu sind Web-Anwendungen, die von Anfang an alle GUI-Elemente mit dem Status \"unsichtbar\" laden, und nur die jeweils relevanten sichtbar schalten. Hierbei kann es nützlich sein, über den Geltungsbereich die Komponentenerkennung zumindest auf das sichtbare Fenster einzugrenzen. Der Geltungsbereich wird in der Bemerkung eines Knotens, über die SmartID oder auch die QF‑Test ID der aufgenommenen Komponente mit vorangestelltem @scope gesetzt, zum Beispiel @scope #myDialog. Wenn der Scope für mehrere Event- oder Check-Knoten gelten soll, wird der Geltungsbereich in der Bemerkung eines Knotens (zum Beispiel Sequenz, Testschritt oder Testfall) gesetzt, der diese Knoten direkt oder indirekt über Prozeduraufrufe enthält. Der aktive Geltungsbereich kann vereinfacht über eine SmartID referenziert werden, die nur aus der Raute # besteht. Wenn eine Komponente nicht innerhalb des Geltungsbereichs liegt, kommt es zu einer ComponentNotFoundException. Geltungsbereiche können bei Bedarf umgangen werden, indem das Doctag @noscope in der Bemerkung des entsprechenden Event- oder Checkknotens eingefügt wird oder noscope: an den Anfang der SmartID gesetzt wird. Zum Beispiel ist es über die SmartID #noscope:Speichern möglich, den Button \"Speichern\" anzuklicken, der eigentlich außerhalb des Geltungsbereich liegt, der für die Sequenz gesetzt ist, in der sich das Klick-Event befindet (siehe \"SmartIDs - allgemeine Syntax\"). Geltungsbereiche können geschachtelt werden, wobei der innere Geltungsbereich im äußeren liegen muss und diesen weiter einschränkt. Auch hier kann mit dem Doctag @noscope eine Ausnahme erreicht werden. Hierzu werden in der Bemerkung des Knotens, dessen Komponenten in einem Geltungsbereich außerhalb des aktuell gültigen liegen, die Doctags @noscope und @scope NEWSCOPE angegeben (NEWSCOPE ist ein Platzhalter für den neuen Geltungsbereich). Die Reihenfolge der Doctags ist beliebig. Der Geltungsbereich bezieht sich immer nur auf den jeweiligen Knoten und die darin ausgeführten Knoten. Die Komponenten einer im Geltungsbereich gerufenen Prozedur müssen somit im Geltungsbereich liegen oder mit #noscope:... oder Doctag @noscope) gekennzeichnet werden. Geltungsbereiche können über SmartIDs, aber auch über die QF‑Test ID von aufgenommenen Komponenten festgelegt werden. Trotzdem werden Sie nur bei der Referenzierung einer Komponente via SmartID berücksichtigt. Beim Referenzieren einer aufgenommenen Komponente wird der aktuelle Geltungsbereich immer ignoriert.","hash":"usec_scope","h0":"Geltungsbereich (Scope)"},"177":{"id":177,"content":"Pro Handbuch","hash":"","h0":"Generische Komponenten | QF‑Test Handbuch"},"178":{"id":178,"content":"Pro Handbuch","hash":"home-link","h0":"Generische Komponenten | QF‑Test Handbuch"},"179":{"id":179,"content":"Generische Komponenten Bevor mit QF‑Test Version 6.0 SmartIDs zur Verfügung standen, waren generische Komponenten das Mittel der Wahl, um Komponentenaufnahmen zu vermeiden. Mit SmartIDs kann dieses Ziel einfacher und flexibler erreicht werden. Die bisherige Beschreibung der generischen Komponenten bleibt aber aus Gründen der Rückwärtskompatibilität hier erhalten. Ein typischer Anwendungsfall hierfür ist das Testen von lokalisierten Anwendungen. Eine andere Situation könnte der Einsatz eines GUI Frameworks bei der Entwicklung sein. Dieser Einsatz generiert jede Menge ähnlicher Dialoge, wo sich nur ein paar Komponenten unterscheiden. Aber Sie müssen jedes Mal jeden Bereich neu aufzeichnen, auch wenn Sie dies schon einmal gemacht haben, z.B. globale Navigationsbuttons, weil es sich immer um ein neues Fenster handelt. Für generische Komponenten benutzen Sie Variablen in den Komponenteneigenschaften oder löschen einfach nicht-dynamische Teile daraus. Ein allgemeiner Ansatz für das Generalisieren von Komponenten ist folgender: Zeichnen Sie einige Komponenten, die Sie generalisieren wollen, auf und vergleichen Sie diese. Erstellen Sie eine generische Komponente, die in der QF‑Test ID 'generisch' enthält, damit Sie diese wiederfinden. Entfernen Sie alle Attribute, die Sie nicht für die Wiedererkennung verwenden wollen, aus dieser generischen Komponente. Legen Sie die Wiedererkennungseigenschaft fest, z.B: 'Name', 'Merkmal' oder 'Index'. Setzen Sie in diesem Attribut eine Variable, z.B. $(name). Um falsche Treffer zu vermeiden, deaktivieren Sie die Geometrieerkennung, indem Sie in den 'X'- und 'Y'-Attributen ein '-' setzen. Spezifizieren Sie '@generic' im Attribut Bemerkung, damit diese Komponenten nicht unbeabsichtigt von der 'Ungenutzte Komponenten entfernen' Aktion gelöscht wird. Erstellen Sie eine Prozedur, um auf diese generische Komponente zuzugreifen und verwenden Sie die Variable von vorhin als Parameter der Prozedur. Generische Komponenten sind sehr nützlich für das Abspielen von Tests, aber QF‑Test verwendet diese nicht für die Aufzeichnung. Sie werden immer die konkreten Komponenten aufgezeichnet bekommen. Sie müssen daher nachträglich die konkreten Komponenten durch die generische ersetzen.","hash":"sec_bpCRGeneric","h0":"Generische Komponenten"},"180":{"id":180,"content":"Pro Handbuch","hash":"","h0":"Unterelemente: Adressierung relativ zur übergeordneten Komponente | QF‑Test Handbuch"},"181":{"id":181,"content":"Pro Handbuch","hash":"home-link","h0":"Unterelemente: Adressierung relativ zur übergeordneten Komponente | QF‑Test Handbuch"},"182":{"id":182,"content":"Unterelemente: Adressierung relativ zur übergeordneten Komponente In QF‑Test ist es möglich, Komponenten relativ zu einer übergeordneten Komponente zu adressieren. Dies ist besonders dann interessant, wenn die untergeordnete Komponente nur im Zusammenspiel mit der übergeordneten eindeutig angesprochen werden kann. Hier gibt es verschiedenste Anwendungsfälle und auch unterschiedliche Möglichkeiten der Implementierung. Adressierung über Index Bei Tabellen, Listen und Bäumen macht es Sinn, für die Unterelemente einen Index zu verwenden. Die Hauptkomponente wird über die QF‑Test ID der Komponente oder eine SmartID spezifiziert. Der Index für das Unterelement wird daran angehängt. Beispiele: listid@Eintrag, #Table@Spaltenüberschrift&5. Siehe Adressierung mittels Index. Wenn die Hauptkomponente über eine SmartID adressiert wird, können Reiter in TabPanels oder Listeneinträge einer ComboBox vereinfacht referenziert werden, zum Beispiel #Tab:Tab1 oder #Item:EintragX. Siehe Adressierung mittels Index. Adressierung des Unterelements mittels SmartID SmartIDs können an die QF‑Test ID der Komponente oder die SmartID, die eine übergeordnete Komponente identifiziert, angehängt werden. Als Trennzeichen zwischen über- und untergeordneter Komponente wird @ verwendet. Die Verschachtelung kann auch mehrstufig sein. Die einzelnen Komponenten können auch mit einem Index versehen werden. Beispiele: #Dialog:@#OK, comboboxid@#Button:, #Table:&0&0@#CheckBox:. Adressierung des Unterelements mittels QPath Der QPath kann ähnlich wie die angehängte SmartID verwendet werden, ist aber lang nicht so mächtig wie diese. Ein QPath kann an eine QF‑Test ID der Komponente angehängt werden. Als Trennzeichen dient @:. Die QF‑Test ID der Komponente kann auch mit einem Index versehen sein. Beispiele: buttonid@:Icon, tableid&0&0@:CheckBox Weitere Informationen finden Sie in Adressierung mit QPath. Adressierung des Unterelements mittels XPath und CSS-Selektoren Bei Web-Anwendungen kann auch ein XPath und/oder ein CSS-Selektor an eine QF‑Test ID der Komponente oder eine SmartID angehängt werden. Als Trennzeichen dient @:xpath= beziehungsweise @:css=. Die QF‑Test ID der Komponente kann auch mit einem Index versehen sein. Beispiele: genericDocument@:xpath=${quoteitem:$(xpath)}. Weitere Informationen finden Sie in Adressierung mit XPath und/oder CSS-Selektoren. Geltungsbereich Auch über einen Geltungsbereich kann die übergeordnete Komponente spezifiziert werden. Siehe Geltungsbereich (Scope). Aufnahme von Unterelementen als Knoten Bei Tabellen, Listen und Bäumen kann es auch Sinn machen, das Unterelement als Element aufzunehmen. Es hängt von der jeweiligen Situation ab, ob ein Unterelement über Index angesprochen wird oder es sinnvoller ist, es aufzunehmen. Sie können beide Methoden nach Belieben verwenden und auch mischen. Als Faustregel gilt, dass Element Knoten besser für Komponenten mit wenigen, konstanten Elementen geeignet sind, wie z.B. die Spalten einer Tabelle oder die Reiter eines TabPanel. Die Syntax ist vorzuziehen, wenn QF‑Test Variablen in Indizes verwendet werden oder wenn die Namen von Elementen variieren oder editierbar sind. Die Option Art der Unterelemente legt fest, ob QF‑Test beim Aufzeichnen Element Knoten anlegt oder die QF‑Test ID-Syntax verwendet. Mit der Standardeinstellung \"Intelligent\" folgt QF‑Test obigen Regeln. Weitere Informationen zur Aufnahme von Unterelementen finden Sie in Adressierung mit Elemente Knoten. Mögliche Kombinationen Hinweis: In der nachfolgenden Aufstellung kann die SmartID der übergeordneten Komponente bereits aus geschachtelten Referenzierungen besteht.","hash":"usec_subitems","h0":"Unterelemente: Adressierung relativ zur übergeordneten Komponente"},"183":{"id":183,"content":"Hinweis: In der nachfolgenden Aufstellung kann die SmartID der übergeordneten Komponente bereits aus geschachtelten Referenzierungen besteht. Referenzierung der übergeordneten Komponente Referenzierung der Unterkomponente Beispiel QF‑Test ID der Komponente Index Listenelement mit Textindex: listid@Eintrag SmartID Index Tabellenzelle mit numerischen Indizes: #Table:&0&2 QF‑Test ID der Komponente SmartID Icon in Button: buttonid@#Icon: SmartID SmartID Textfeld in Dialog: #Dialog:@#TextField: SmartID mit Index SmartID Button in Tabellenzelle: #Table:&0&2@#Button: QF‑Test ID der Komponente mit Index SmartID Button in Tabellenzelle: tableID&0&2@#Button: QF‑Test ID der Komponente mit Index QPath Button in Tabellenzelle: tableID&0&2@:Button QF‑Test ID der Komponente mit oder ohne Index XPath und/oder CSS-Selektor genericHtml@:css=${quoteitem:$(css)} SmartID mit oder ohne Index XPath und/oder CSS-Selektor #genericDocument@:xpath=${quoteitem:$(xpath)} Geltungsbereich SmartID Geltungsbereich als Doctag in einem Testschritt, SmartID im Check-Knoten Tabelle 5.4: Adressierung von Unterelementen","hash":"table_5.4","h0":"Unterelemente: Adressierung relativ zur übergeordneten Komponente"},"184":{"id":184,"content":"Adressierung mittels Index Das Unterelement wird über eine entsprechende Zeichenkettenfolge mithilfe einer speziellen Syntax beschrieben. Die QF‑Test ID der Komponente, die im Test verwendet wird, setzt sich hierbei aus der QF‑Test ID oder der SmartID der komplexen Komponente (Baum, Tabelle etc.), gefolgt von einem speziellen Trennzeichen, und dem Index des Unterelements zusammen. Das Trennzeichen legt dabei fest, ob es sich um einen numerischen Index, einen Textindex oder einen regulären Ausdruck (vgl. \"Reguläre Ausdrücke - Regexps\") handelt:","hash":"sec_directsubitemeasy","h1":"Adressierung mittels Index"},"185":{"id":185,"content":"Trennzeichen Index Format @ Textindex & Numerischer Index % Regulärer Ausdruck Tabelle 5.5: Trennzeichen und Indexformat für den Zugriff auf Unterelemente Um auf eine Zelle in einer Tabelle mit Primärindex und Sekundärindex zuzugreifen, hängen Sie einfach ein weiteres Trennzeichen an, gefolgt vom Sekundärindex. Die beiden Indizes dürfen dabei durchaus verschiedenen Formaten angehören. Bei Bäumen setzt sich der Index aus den einzelnen Baumknoten zusammen, die den Pfad zum adressierten Knoten bilden. Die einzelnen Knoten werden im Pfad durch das für den Knoten gültige Trennzeichen, gefolgt von einem \"/\", getrennt. Falls ein Trennzeichen für mehrere Knoten hintereinander gilt, muss es nicht vor jedem \"/\" stehen. Die besondere Bedeutung der Trennzeichen '@', '&' und '%' macht diese zu Sonderzeichen, die geschützt werden müssen, wenn sie selbst in einem Namen auftauchen. Näheres zu diesem Thema finden Sie in Schützen von Sonderzeichen (quoting). Negativer Index Es ist fast immer möglich mit negativem Index die Zählung von hinten beginnen zu lassen. SmartIDs: Einfache Indizes für TabPanels und Listen Reiter in TabPanels müssten bei SmartIDs gemäß der obigen Syntax zum Beispiel über #TabPanel:@Tab1 angesprochen werden, wobei Tab1 der Name des Reiters ist. Alternativ kann hier die Abkürzung #Tab:Tab1 verwendet werden. Wenn keine andere Komponente die SmartID #Tab1 hat, kann der Reiter sogar einfach über #Tab1 adressiert werden. In Listen können die Listeneinträge gemäß obiger Syntax mit #List:@EintragX angesprochen werden. Als Abkürzung ist auch #Item:EintragX möglich. Dies gilt auch für Dropdown-Listen von ComboBoxen. Wenn keine andere Komponente die SmartID #EintragX hat, kann der Listeneintrag wie bei den Tab-Reitern einfach über #EintragX adressiert werden. Beide Abkürzungen sind komfortabel, die hohe Flexibilität hat aber ihren Preis bei der Performance. Wie hoch dieser ausfällt, hängt von vielen Faktoren ab, so dass die Abwägung Komfort/Performance im Einzelfall getroffen werden muss. Beispiele","hash":"table_5.5","h1":"Adressierung mittels Index"},"186":{"id":186,"content":"Komponente Index Beschreibung Tabelle @Name&5 Tabellenzelle in der sechsten Zeile und in der Spalte mit der Überschrift \"Name\". Komplette QF‑Test ID der Komponente: tableid@Name&5 Liste &0 Numerischer Index: erster Eintrag in einer Liste. Komplette SmartID: #List:&0 Liste @Europa Textindex: Listeneintrag mit dem Text \"Europa\". Komplette SmartID: Standardsyntax: #List:@Europa Verkürzte Syntax 1 (alternativ): #Item:Europa Verkürzte Syntax 2 (alternativ): wenn keine andere Komponente die SmartID Europa hat: #Europa Baum @/Wurzel/A1/A1-2/B Textindex: Baumpfad, der alle Knoten über ihre Texte spezifiziert. Komplette QF‑Test ID der Komponente: treeid@/Wurzel/A1/A1-2/B Baum &/0/5/1/3/ Numerischer Index: Baumpfad, der alle Knoten über ihnen numerischen Index spezifiziert. Komplette SmartID: #Tree:&/0/5/1/3/ Baum %/W.*/A.* Reguläre Ausdrücke für die Baumknoten. Baum &/0@/Ast1%/B.* Gemischte Indizes: numerischer Index für den ersten, Textindex für den zweiten und regulärer Ausdruck für den dritten Knoten. Tabelle &-1&-1 Negative Indizes: unterste Zelle in der rechten Tabellenspalte. TabPanel @Tab1 Textindex: Adressierung über Reiterbeschriftung. Komplette SmartID: Standardsyntax: #TabPanel:@Tab1 Verkürzte Syntax 1 (alternativ): #Tab:@Tab1 Verkürzte Syntax 2 (alternativ), wenn keine andere Komponente die SmartID: Tab1 hat: #Tab1 Tabelle 5.6: Indizes von Unterelementen","hash":"table_5.6","h1":"Adressierung mittels Index"},"187":{"id":187,"content":"Adressierung mit QPath Jedem QF‑Test ID der Komponente Attribut (mit oder ohne Unterelement) in einem Event oder Check Knoten können ein oder mehrere Indizes der Form @:ClassName<idx> angehängt werden, wobei <idx> optional ist. Dies weist QF‑Test an, zunächst die Zielkomponente (und ggf. das Unterelement) für den Teil des QF‑Test ID der Komponente Attributs vor dem @: zu ermitteln und anschließend darin nach sichtbaren Komponenten der Klasse ClassName zu suchen. Ist <idx> angegeben, wird dies als 0-basierter Index in die Liste der sichtbaren Kandidaten interpretiert. Kein <idx> ist äquivalent zu <0>. Die QPath-Syntax erwartet nach dem @: eine generische Klasse. Eine Übersicht der generischen Klassen finden Sie im \"Generische Klassen\". Falls sich die Komponente nicht mit einer generischen Klasse aufzeichnen lässt, muss man im QPath die vollständige Klassname angeben. Für JavaFX lauten einige davon zum Beispiel ImageView, VBox, GridPane oder BorderPane. Das folgende Beispiel bezeichnet den zweiten ImageView auf der dritten Position einer Liste. panelSecond.list&2@:javafx.scene.image.ImageView<1>","hash":"usec_multilevelsubitemsqpath","h1":"Adressierung mit QPath"},"188":{"id":188,"content":"Adressierung mit XPath und/oder CSS-Selektoren XPath und CSS-Selektoren sind standardisierte Beschreibungen, um Komponenten in Webbrowsern anzusprechen. (Offizielle Spezifikationen: https://www.w3.org/TR/xpath/ und https://www.w3.org/TR/css3-selectors/). QF‑Test unterstützt die Komponentenbeschreibung via XPaths und CSS-Selektoren für HTML-Elemente, um eine leichtere Migration bestehender Web-Tests anderer Tools nach QF‑Test zu ermöglichen. Das Internet bietet bereits eine Vielzahl von Tutorials an, die die Komponentenerkennung mithilfe von CSS-Selektoren (z.B.: https://www.w3schools.com/cssref/css_selectors.asp) sowie die Komponentenerkennung mithilfe von XPaths (z.B.: https://www.w3schools.com/xml/xpath_syntax.asp) beschreiben. Insofern wird auf die Eigenheiten dieser Komponentenerkennung hier nicht mehr explizit eingegangen. Verwendung in der QF‑Test ID Angenommen in QF‑Test soll eine Web-Komponente anhand des XPath \"$(xpath)\" oder eines CSS-Selektors \"$(css)\" erkannt werden, so kann dies prinzipiell über mehrere Wege geschehen. Am einfachsten/schnellsten ist es meist, den XPath bzw. den CSS-Selektor im QF‑Test ID der Komponente Attribut eines beliebigen Event-Knotens zu spezifizieren. Hierzu wird die folgende Syntax benutzt: genericHtml@:xpath=${quoteitem:$(xpath)} genericHtml@:css=${quoteitem:$(css)} bzw. gleichwertig: genericDocument@:xpath=${quoteitem:$(xpath)} genericDocument@:css=${quoteitem:$(css)} Die Syntax kann hierbei beliebig verschachtelt werden. Zum Beispiel kann man mithilfe von: genericDocument@:xpath=${quoteitem:$(xpath)}@:css=${quoteitem:$(css)} QF‑Test dazu anweisen zuerst mithilfe eines XPath nach einer Komponente zu suchen und dann anschließend mithilfe eines CSS-Selektors nach einer Unterkomponente. Bitte beachten Sie, dass die @:xpath/@:css aus nachvollziehbaren Gründen erwartet, dass die verwendete XPath-/CSS-Anweisung eine einzelne Komponente zurückliefert. Die Verwendung einer XPath-Anweisung die keine einzelne Komponente, sondern eine Zahl (Beispiel: count(.//input[@id!='Google'])) oder einen Boolean (Beispiel: nilled($in-xml//child[1])) zurückliefert, kann deshalb unter Umständen zu unerwartetem Verhalten führen. Verwendung in Skripten Das rc-Modul erlaubt in SUT-Skripten ebenfalls Web-Komponenten via XPath bzw. CSS-Selektoren zu finden.","hash":"usec_xpath","h1":"Adressierung mit XPath und/oder CSS-Selektoren"},"189":{"id":189,"content":"com = rc.getComponent(\"genericHtml\") # or rc.getComponent(\"genericDocument\") res = com.getByXPath(rc.getStr(\"xpath\")) # find subcomponent via xpath res = com.getByCSS(rc.getStr(\"css\")) # find subcomponent via css res = com.getAllByXPath(rc.getStr(\"xpath\")) # find all subcomponent via xpath res = com.getAllByCSS(rc.getStr(\"css\")) # find all subcomponent via css Beispiel 5.1: Finden von Komponenten anhand von XPath / CSS-Selektoren in Skripten Und um einen XPath zu benutzen, der keine Komponente(n) zurückliefert benutzen Sie bitte die callJS-Funktion:","hash":"ex_xpath_css_sut_find","h1":"Adressierung mit XPath und/oder CSS-Selektoren"},"190":{"id":190,"content":"node = rc.getComponent('genericDocument') print node.callJS(\"\"\"return document.evaluate(\"count(.//input[@id='Google'])\", document, null, 0, null).numberValue;\"\"\") Beispiel 5.2: Beispiel für den Aufruf eines XPath-Selektors, der keine Komponente zurückliefert Verwendung in Komponentenknoten Innerhalb eines Komponente-Knotens kann QF‑Test des Weiteren ebenfalls angewiesen werden, dass für die Komponentenerkennung ein XPath bzw. CSS-Selektor verwendet werden soll. Hierzu spezifiziert man ein wie folgt aussehendes Erkennungsmerkmal unter \"Weitere Merkmale\":","hash":"ex_xpath_no_components","h1":"Adressierung mit XPath und/oder CSS-Selektoren"},"191":{"id":191,"content":"StatusMuss übereinstimmen RegexpNein NegierenNein Nameqfs:item Wert@:xpath=${quoteitem:$(xpath)} oder @:css=${quoteitem:$(css)} Abbildung 5.11: \"Weitere Merkmale\"-Attribute für die Komponentenerkennung anhand von XPath oder CSS-Selektoren.","hash":"figure_5.11","h1":"Adressierung mit XPath und/oder CSS-Selektoren"},"192":{"id":192,"content":"Adressierung mit Elemente Knoten Ein Element wird durch zwei Dinge definiert: die Komponente, zu der es gehört, sowie einen Index innerhalb dieser Komponente. Der Parentknoten des Elements legt die Komponente fest. Der Index kann entweder eine Zahl sein oder ein Text. Numerische Indizes starten mit 0. So entspricht z.B. in einer JList Komponente das Element mit Index 1 dem zweiten Listeneintrag. Für Bäume sind einfache numerische Indizes nahezu unbrauchbar, da durch das Ein- und Ausklappen von Ästen die Indizes aller darunter liegenden Knoten verändert werden. Ein Textindex definiert ein Element durch den Text, den es in der Oberfläche anzeigt. Ein Listenelement namens \"Eintrag1\" in einer JList Komponente würde z.B. mit dem Textindex \"Eintrag1\" aufgezeichnet. Die Textform ist flexibler als die numerische, kann aber Probleme bereiten, wenn die angezeigten Texte der Elemente in einer Komponente nicht eindeutig sind. In diesem Fall wird das erste passende Element angesprochen. Ein Textindex kann auch als regulärer Ausdruck (vgl. \"Reguläre Ausdrücke - Regexps\") angegeben werden. Auch in diesem Fall ist das Ziel das erste Element, das auf den regulären Ausdruck passt. Die Option Format für Unterelemente legt fest, welches Format beim Aufzeichnen von Elementen verwendet wird. Beinahe alle Arten von Element haben nur einen Index. Dies reicht für die Zelle einer JTable Komponente nicht, da Tabellen zweidimensionale Strukturen sind. Entsprechend sind zwei Indizes nötig, um eine Zelle exakt zu beschreiben. Der erste, der Primärindex, legt die Tabellenspalte fest, der Sekundärindex die Zeile.","hash":"usec_subitems_node","h1":"Adressierung mit Elemente Knoten"},"193":{"id":193,"content":"Abbildung 5.12: Ein Element für ein Tabellenfeld Auch Baumknoten nehmen eine Sonderstellung ein. Wie oben beschrieben lässt sich die hierarchische Struktur nicht so leicht auf eine lineare Struktur abbilden. Außerdem treten in Bäumen oft Baumknoten mit den gleichen Namen auf. Wenn man dagegen die direkten und indirekten Parentknoten mit in den Namen einbezieht, lässt sich meistens Eindeutigkeit erreichen. QF‑Test verwendet eine besondere Syntax um Baumknoten darzustellen. Ein Index, der mit einem '/'-Zeichen beginnt, wird als Pfadindex interpretiert. Denken Sie dabei einfach an ein Dateisystem: Die Datei namens \"/tmp/file1\" kann entweder flach als \"file1\" dargestellt werden, was zu Konflikten mit anderen Dateien namens \"file1\" in anderen Verzeichnissen führen kann. Alternativ kann der volle und eindeutige Pfad \"/tmp/file1\" verwendet werden. QF‑Test unterstützt auch numerische Indizes mit dieser Syntax: Ein numerischer Index der Form \"/2/3\" bezeichnet den vierten Kindknoten des dritten Kindknotens des Wurzelknotens. Eine kombinierte Form um z.B. mittels \"/tmp/2\" den dritten Knoten im \"tmp\" Knoten anzusprechen, ist derzeit nicht möglich. Diese spezielle Syntax macht das '/'-Zeichen zu einem Sonderzeichen für Elemente in einer Baumkomponente. Taucht dieses Zeichen selbst in einem Namen auf, muss es daher geschützt werden. Näheres zu diesem Thema finden Sie in \"Schützen von Sonderzeichen (quoting)\". Alles was in \"Komponente-Knoten\" zum QF‑Test ID Attribut von Komponenten gesagt wurde, trifft auch auf das QF‑Test ID Attribut eines Elements zu. Dieses Attribut muss eindeutig sein und wird von Events und Checks referenziert. Wenn QF‑Test die QF‑Test ID eines Elements automatisch zuweist, erzeugt es diese, indem es die QF‑Test ID der Komponente des Parentknotens nimmt und den Index (oder die Indizes) anhängt. Diese Art von QF‑Test ID ist normalerweise gut zu lesen und zu verstehen. Leider ist sie aber auch die Quelle eines häufigen Missverständnisses: Wenn Sie den Index eines aufgezeichneten Elements ändern wollen, um auf ein anderes Element zu verweisen, dürfen Sie nicht das Attribut QF‑Test ID der Komponente des Knotens ändern, der darauf verweist. Stattdessen müssen Sie den Primärindex des Element Knotens ändern.","hash":"figure_5.12","h4":"Abbildung 5.12: Ein Element für ein Tabellenfeld"},"194":{"id":194,"content":"Pro Handbuch","hash":"","h0":"Lösung von Problemen bei der Wiedererkennung | QF‑Test Handbuch"},"195":{"id":195,"content":"Pro Handbuch","hash":"home-link","h0":"Lösung von Problemen bei der Wiedererkennung | QF‑Test Handbuch"},"196":{"id":196,"content":"Lösung von Problemen bei der Wiedererkennung","hash":"usec_troubleshooting","h0":"Lösung von Problemen bei der Wiedererkennung"},"197":{"id":197,"content":"Zeitliche Synchronisierung Wenn Sie Exceptions erhalten, weil eine Komponente nicht gefunden wurde, kann einer der Gründe sein, dass nicht lang genug auf die Komponente gewartet wurde. Ein Mausklick hat zwar eine gewisse Standardwartezeit, diese ist aber nicht immer ausreichend. Daher sollten Sie prüfen, ob es genügend Synchronisationspunkte gibt, wie Warten auf Komponente oder Check Knoten mit Wartezeiten, um die Testschritte nur dann auszuführen, wenn das SUT wirklich bereit dazu ist. Ein Warten auf Komponente Knoten kann genutzt werden, wenn eine Komponente neu auftaucht. Die maximale Wartezeit (in Millisekunden) wird im Attribut Wartezeit angegeben. Mittels Check Knoten kann auf eine Zustandsänderung von Komponenten gewartet werden. Geben Sie hier ebenfalls die maximale Wartezeit (in Millisekunden) im Attribut Wartezeit an. Manchmal ist es auch eine Schleife notwendig, in der auf die Zustandsänderung gewartet wird und, wenn noch nicht erfolgt, eine Aktion, zum Beispiel der Klick auf einen \"Aktualisieren\" Button, ausgeführt wird. Auch auf die Änderung der Anzahl der Zeilen in einer Tabelle kann in einer Schleife gewartet werden. Viele Anwendungen verwenden Anzeigen, die Wartezeiten symbolisieren, zum Beispiel Fortschrittsbalken oder \"Eieruhren\". Hier kann zunächst auf das Erscheinen und dann auf das Verschwinden der Komponente gewartet werden. Die Wartezeit Attribute geben eine maximale Wartezeit an. Sobald der gewünschte Zustand in der Anwendung erreicht ist, fährt QF‑Test mit der Ausführung fort. Diese Wartezeiten können daher großzügig gewählt werden. Eine Änderung der Optionen für Standardwartezeiten (\"Automatische Timeouts\") sollte nur erfolgen, wenn generell längere Wartezeiten anwendungsweit Sinn machen. Als letzte Möglichkeit können Sie auch mit einer festen Verzögerung arbeiten. Bei Angaben im Attribut Verzögerung vorher/nachher wartet QF‑Test die komplette angegebene Zeit. Verzögerung vorher/nachher sollten daher nur genutzt werden, wenn es gar keine für QF‑Test erkennbare Zustandsänderung in der zu testenden Anwendung gibt, auf die gewartet werden kann.","hash":"usec_components_sync","h1":"Zeitliche Synchronisierung"},"198":{"id":198,"content":"Wiedererkennung Wenn sich Ihr SUT in einer Weise verändert, die es QF‑Test unmöglich macht, eine Komponente wiederzufinden, schlägt Ihr Test mit einer ComponentNotFoundException fehl. Diese sollte nicht mit einer UnresolvedComponentIdException verwechselt werden, welche durch Entfernen eines Komponente-Knotens aus der Testsuite oder dem Ändern des Attributs QF‑Test ID der Komponente eines Event Knotens zu einer nicht vorhandenen QF‑Test ID ausgelöst werden kann. Es gibt zwei Videos, die die Behandlung einer ComponentNotFoundException ausführlich erklären: 'ComponentNotFoundException - einfacher Fall' 'ComponentNotFoundException - komplexer Fall' Wenn Sie eine ComponentNotFoundException erhalten, führen Sie den Test erneut mit aktiviertem Test-Debugger aus, so dass der Test angehalten wird und Sie den Knoten, der das Problem verursacht hat, untersuchen können. Hier zahlt es sich aus, wenn QF‑Test ID Attribute aussagekräftig sind, da Sie verstehen müssen, welche Komponente der Test anzusprechen versucht hat. Falls Sie sich gar keinen Reim darauf machen können, was der Sinn des betreffenden Knotens sein soll, deaktivieren Sie ihn und versuchen Sie, ob der Test ohne diesen Knoten durchläuft. Es könnte sich um einen Störeffekt handeln, der bei der Aufnahme nicht gefiltert wurde, und der gar nichts zum eigentlichen Test beiträgt. Grundsätzlich sollten Ihre Tests immer auf das Minimum an Knoten reduziert werden, mit denen sich der gewünschte Effekt erzielen lässt. Falls der Knoten erhalten bleiben muss, werfen Sie als nächstes einen Blick auf das SUT, um zu sehen, ob die Zielkomponente aktuell sichtbar ist. Wenn nicht, müssen Sie Ihren Test entsprechend anpassen, um diese Situation zu behandeln. Ist die Komponente sichtbar, überprüfen Sie anhand des Bildschirmabbilds im Protokoll, ob das auch zum Zeitpunkt des Fehlers der Fall war, und versuchen Sie, den fehlgeschlagenen Knoten noch einmal als Einzelschritt auszuführen. Wenn die Ausführung nun klappt, haben Sie ein Problem mit dem Timing, das Sie durch den Einbau eines Warten auf Komponente Knotens, eines Check Knotens mit Wartezeit oder einer anderen Warteaktion (siehe Zeitliche Synchronisierung) lösen können. Falls die Komponente sichtbar ist und die Wiedergabe kontinuierlich fehlschlägt, ist die Ursache eine Änderung an der Komponente oder einer ihrer Parent-Komponenten. Nun gilt es festzustellen, was sich geändert hat und wo. Nehmen Sie hierzu einen neuen Klick auf die Komponente auf und vergleichen Sie dann den alten und neuen Komponente-Knoten in der Hierarchie unterhalb von Fenster und Komponenten. Sie können vom Event Knoten direkt zum zugehörigen Komponente Knoten springen, indem Sie Strg⁠+⁠W drücken oder rechts-klicken und im Popup-Menü »Komponente finden« wählen. Sie können mittels Strg⁠+⁠Backspace oder »Bearbeiten«-»Vorherigen Knoten anwählen« wieder zurückspringen. Ein schlauer Trick ist, die zu vergleichenden Komponente Knoten durch Setzen von Marken zu kennzeichnen »Bearbeiten«-»Marken«, um sie leichter wiederzufinden. Der Knackpunkt ist die Stelle, an der die Hierarchie der beiden Knoten verzweigt. Wenn sie unter verschiedenen Fenster Knoten angesiedelt sind, liegt der Unterschied in den betreffenden Fenstern selbst. Andernfalls gibt es einen gemeinsamen Vorgänger direkt oberhalb der Verzweigung. Der entscheidende Unterschied ist dann in den jeweiligen Knoten direkt unterhalb dieses gemeinsamen Vorgängers zu finden. Wenn Sie die Stelle mit der Unterscheidung gefunden haben, vergleichen Sie die Attribute der betreffenden Knoten von oben nach unten und suchen Sie nach Abweichungen. Sie können mittels »Ansicht«-»Neues Fenster...« ein weiteres QF‑Test Fenster öffnen und damit die Detailansichten der beiden Knoten nebeneinander platzieren. Die einzigen Unterschiede, die immer zu einem Fehler bei der Wiedererkennung führen, sind Änderungen der Attribute Klasse oder Name. Abweichungen bei Merkmal, Struktur oder Geometrie können üblicherweise kompensiert werden, sofern sie sich nicht häufen. Eine Änderung der Klasse sollte bei der Verwendung von Generische Klassen kaum vorkommen. Die Verwendung von generischen Klassen bietet einige Vorteile, wird bei Web-Anwendungen aber manchmal erst nach der Erstellung erster Tests eingeführt (siehe Verbesserte Komponentenerkennung mittels CustomWebResolver). In diesem Fall müssen Sie das Klasse Attribut der bereits vorhandenen Komponente-Knoten an diese Änderung anpassen. Auch der Komponentenbezeichner kann sich ändern. Falls die Änderung beabsichtigt zu sein scheint, z.B. die Korrektur eines Rechtschreibfehlers, können Sie das Name Attribut entsprechend anpassen. Wahrscheinlicher ist, dass es sich um einen automatisch generierten Komponentenbezeichner handelt, der sich jederzeit wieder ändern kann. Auch hier kann es Sinn machen, das Problem mit den Entwicklern diskutieren und entwicklungsseitig eine Lösung zu finden. Ansonsten kann bei Web-Anwendungen der Name über den Der CustomWebResolver installieren Knoten beeinflusst werden, speziell über die Kategorien autoIdPatterns und customIdAttributes. Bei allen Technologien kann der Name mit Hilfe eines NameResolvers, wie in \"Das NameResolver Interface\" beschrieben, beeinflusst werden. Er kann ganz unterdrückt oder auf relevante Teile reduziert werden. Änderungen am Attribut Merkmal sind insbesondere für Fenster Knoten nicht ungewöhnlich. Dort entspricht das Merkmal dem Titel des Fensters. Kombiniert mit einer signifikanten Änderung der Geometrie kann das zum Scheitern der Wiedererkennung führen. Dies kann durch Anpassen des Merkmal Attributs an die neuen Gegebenheiten, oder - bevorzugt - durch Verwendung eines regulären Ausdrucks (vgl. \"Reguläre Ausdrücke - Regexps\"), der alle Varianten abdeckt, behoben werden. Abhängig von Art und Umfang der Änderungen gibt es zwei grundsätzliche Möglichkeiten zur Korrektur: Passen Sie die Attribute des alten Knoten an und entfernen Sie die neu aufgenommenen Knoten. Wenn die Änderungen im SUT nicht zu groß waren und die Komponentenerkennung noch funktioniert, können Änderungen auch über die QF‑Test Funktion Komponenten aktualisieren automatisiert durchgeführt werden. Behalten Sie die neuen Knoten und entfernen Sie den alten. Hierzu müssen Sie zunächst sicherstellen, dass alle Knoten, die auf die alte Komponente verweisen, auf die neue QF‑Test ID geändert werden. Dies lässt sich durch einen kleinen Trick erreichen: Ändern Sie die QF‑Test ID des alten Komponente-Knotens auf die QF‑Test ID des neuen. QF‑Test beschwert sich zunächst, dass die QF‑Test ID nicht eindeutig ist, was Sie ignorieren können, und bietet dann an, alle Verweise zu aktualisieren, was Sie mit \"Ja\" bestätigen müssen. Anschließend können Sie den alten Knoten entfernen. Die automatische Anpassung der Verweise in anderen Testsuiten funktioniert nur, wenn diese zum selben Projekt gehören oder das Attribut Abhängige Dateien (umgekehrte Includes) des Testsuite Knotens korrekt gesetzt ist.","hash":"sec_wiedererkennung","h1":"Wiedererkennung"},"199":{"id":199,"content":"Pro Handbuch","hash":"","h0":"Bereinigung und Wartung des Komponentenbaums | QF‑Test Handbuch"},"200":{"id":200,"content":"Pro Handbuch","hash":"home-link","h0":"Bereinigung und Wartung des Komponentenbaums | QF‑Test Handbuch"},"201":{"id":201,"content":"Bereinigung und Wartung des Komponentenbaums Im Laufe der Testerstellung können sich zum einen ungenutzte Komponenten im Komponentenbaum ansammeln. Hier können Sie ab und zu den Komponentenbaum bereinigen. Zum anderen können sich die Wiedererkennungsmerkmale durch Änderungen in der Applikationsoberfläche ändern. Bevor die Änderungen nach mehreren Oberflächenänderungen so stark werden, dass die Wiedererkennung bricht, macht es Sinn, in den betroffenen Fenstern und Dialogen Komponenten aktualisieren durchzuführen.","hash":"usec_component_maintenance","h0":"Bereinigung und Wartung des Komponentenbaums"},"202":{"id":202,"content":"Komponentenbaum bereinigen Immer wenn eine Sequenz aufgezeichnet wird, werden für die Komponenten, die noch nicht in der Testsuite vorhanden sind, neue Knoten angelegt. Wird die Sequenz später gelöscht, bleiben die Komponenten erhalten, daher haben Komponenten eine gewisse Tendenz sich anzusammeln. Das Kontextmenü für Fenster und Komponente-Knoten hat zwei Einträge namens »Ungenutzte Komponenten markieren...« und »Ungenutzte Komponenten entfernen«, die jene Komponenten markieren oder ganz entfernen, auf die sich kein anderer Knoten in dieser Testsuite mehr bezieht. Vorsicht ist geboten, falls Sie Variablen in QF‑Test ID der Komponente Attributen verwenden, da die Automatik diese nicht erkennt. Werden Komponenten aus anderen Testsuiten referenziert, sollte diese zum selben Projekt gehören oder das Attribut Abhängige Dateien (umgekehrte Includes) des Testsuite Wurzelknotens korrekt gesetzt sein.","hash":"usec_cleancomponenttree","h1":"Komponentenbaum bereinigen"},"203":{"id":203,"content":"Komponenten aktualisieren Es ist kaum zu vermeiden, dass sich die Komponenten des SUT im Lauf der Zeit verändern. Wie beschrieben stellt dies kein großes Problem dar, sofern Bezeichner konsequent eingesetzt werden, da QF‑Test dann mit fast jeder Art von Veränderung zurechtkommt. Ohne Bezeichner summieren sich Änderungen mit der Zeit und können einen Punkt erreichen, an dem die Wiedererkennung fehlschlägt. Um dieses Problem zu umgehen, sollten Sie die Komponenten in QF‑Test von Zeit zu Zeit an den aktuellen Stand des SUT anpassen. Dies kann mit Hilfe des Menüeintrags »Komponente(n) aktualisieren« in dem Kontextmenü geschehen, das Sie nach einem Klick mit der rechten Maustaste auf einen beliebigen Knoten unterhalb des Fenster und Komponenten Knotens erhalten. Diese Funktion kann sehr viel Information auf einmal ändern, daher ist es schwierig zu beurteilen, ob alles wie erwartet funktioniert hat oder ob eine Komponente falsch erkannt wurde. Erstellen Sie daher immer eine Sicherheitskopie, bevor Sie viele Komponenten aktualisieren. Außerdem sollten Sie Fenster für Fenster vorgehen und darauf achten, dass die Komponenten, die Sie aktualisieren wollen, im SUT sichtbar sind (mit Ausnahme der Menüeinträge). Stellen Sie nach jedem Schritt sicher, dass die Tests immer noch sauber laufen. Vorausgesetzt, dass eine Verbindung zum SUT besteht, erscheint bei Aufruf dieser Funktion folgender Dialog:","hash":"usec_update_components","h1":"Komponenten aktualisieren"},"204":{"id":204,"content":"Abbildung 5.13: Komponenten aktualisieren Dialog Sind Sie mit mehreren SUT Clients verbunden, müssen Sie zunächst einen für die Aktualisierung auswählen. Legen Sie fest, ob Sie nur den/die selektierten Komponente Knoten selbst oder auch dessen/deren Kindknoten aktualisieren wollen. Sie können auch Komponenten einbeziehen, die im SUT momentan nicht sichtbar sind. Dies ist vor allem für Menüeinträge hilfreich. Die QF‑Test ID eines aktualisierten Knotens wird beibehalten, wenn \"QF‑Test ID des ursprünglichen Knotens übernehmen\" gewählt ist. Andernfalls erhält der Knoten eine von QF‑Test generierte QF‑Test ID, sofern sinnvolle Informationen zur Verfügung stehen. Andere Knoten, die sich auf diese QF‑Test ID beziehen, werden automatisch angepasst. QF‑Test prüft dabei auch Abhängigkeiten in den Testsuiten, die zum selben Projekt gehören oder die im Attribut Abhängige Dateien (umgekehrte Includes) des Testsuite Knotens aufgeführt sind. Diese Testsuiten werden automatisch geladen und indirekte Abhängigkeiten ebenfalls aufgelöst. In diesem Fall werden die geänderten Testsuiten automatisch geöffnet, damit die Änderungen gespeichert oder rückgängig gemacht werden können. Nach der Bestätigung mit \"OK\" wird QF‑Test versuchen, die betreffenden Komponenten im SUT zu lokalisieren und aktuelle Informationen einzuholen. Komponenten, die nicht gefunden werden können, werden übersprungen. Anschließend werden die Komponente-Knoten an die aktuelle Struktur des GUI im SUT angepasst, was auch zur Folge haben kann, dass Knoten verschoben werden. Für große Hierarchien von Komponenten kann diese äußerst komplexe Operation einige Zeit in Anspruch nehmen, in extremen Fällen sogar einige Minuten. Diese Funktion ist besonders nützlich, wenn Bezeichner zum ersten Mal im SUT verwendet werden. Wenn Sie bereits einige Tests erstellt haben, bevor Sie die Entwickler überzeugen konnten, Bezeichner zu vergeben, können Sie hiermit die Bezeichner in Ihre Komponenten einbinden und gleichzeitig die QF‑Test IDs anpassen. Dies funktioniert am besten, wenn Sie eine SUT Version bekommen können, die bis auf die Bezeichner mit der vorherigen Version übereinstimmt. Sehr wichtiger Hinweis: Das Aktualisieren von ganzen Fenstern oder Hierarchien von Komponenten ab einer gewissen Größe führt oft zu dem Versuch, Komponenten zu aktualisieren, die im Moment nicht vorhanden oder unsichtbar sind. In so einem Fall ist es sehr wichtig, falsch-positive Treffer für diese Komponenten zu verhindern. Sie können dies erreichen, indem Sie vorübergehend die 'Bonus' und 'Herabsetzung...' Optionen zur Wiedererkennung (\"Wiedererkennung\") verändern. Setzen Sie insbesondere die 'Herabsetzung für Merkmal' auf einen Wert unterhalb des Wertes der 'Mindestwahrscheinlichkeit', also z.B. auf 49, sofern Sie ansonsten die Standardwerte verwenden. Vergessen Sie nicht, die ursprünglichen Werte hinterher wiederherzustellen. Wenn Sie die Einstellung der Optionen Gewichtung von Namen (Wiedergabe) und Gewichtung von Namen (Aufnahme) ändern müssen, zum Beispiel weil sich Bezeichner von Komponenten wider Erwarten als nicht eindeutig herausgestellt haben, ändern Sie zunächst nur die Option für die Aufnahme. Wenn die Aktualisierung beendet ist, ziehen Sie die Option für die Wiedergabe entsprechend nach.","hash":"figure_5.13","h4":"Abbildung 5.13: Komponenten aktualisieren Dialog"},"205":{"id":205,"content":"Pro Handbuch","hash":"","h0":"Komponenten untersuchen | QF‑Test Handbuch"},"206":{"id":206,"content":"Pro Handbuch","hash":"home-link","h0":"Komponenten untersuchen | QF‑Test Handbuch"},"207":{"id":207,"content":"Komponenten untersuchen In bestimmten Fällen ist es hilfreich, zusätzliche Informationen über Komponenten zu erhalten, neben den in der Sektion Fenster und Komponenten abgespeicherten, oder die dort abgespeicherten Informationen direkt im Zusammenspiel mit der Applikation zu betrachten. Besonders wichtig ist dies während des \"Einlernens von Komponenten\" bei Web-Anwendungen. Dieser Vorgang sollte vor der Erstellung von Tests erfolgen. Er ist in Verbesserte Komponentenerkennung mittels CustomWebResolver beschrieben. Hierzu steht der UI-Inspektor zur Verfügung. Bei der Arbeit mit Skripten ist es manchmal hilfreich, wenn man sich eine Liste der Methoden eines GUI-Elements anzeigen lassen kann.","hash":"usec_componentinspection","h0":"Komponenten untersuchen"},"208":{"id":208,"content":"Methoden anzeigen Jedes GUI-Objekt besitzt bestimmte (öffentliche) Methoden und Felder die man im einem SUT-Skript verwenden kann, sobald man Zugriff auf ein Objekt hat (siehe \"Zugriff auf die GUI-Komponenten des SUT\"). Um sie anzuzeigen wählt man entweder den Eintrag »Methoden für Komponente anzeigen...« aus dem Kontextmenü eines Knotens unterhalb des Fenster und Komponenten Zweigs oder klickt im Komponentenaufnahme-Modus mit der rechten Maustaste auf die Komponente (siehe auch \"Komponenten aufnehmen\"). Die Methoden und Felder, die für HTML-Elemente in einem Browser angezeigt werden, können nicht direkt mit dem von rc.getComponent() zurückgelieferten Objekt verwendet werden. Es sind JavaScript-Methoden und -Eigenschaften, die in callJS eingebettet werden müssen (vgl. \"Pseudo DOM API für Web-Anwendungen\").","hash":"usec_show_methods","h1":"Methoden anzeigen"},"209":{"id":209,"content":"UI-Inspektor Der UI-Inspektor zeigt die Hierarchie der Komponenten im Client und deren Eigenschaften an. Neben der Nachverfolgung von Problemen bei der Komponentenaufnahme oder der Wiedererkennung erleichtert er durch die in der Detailansicht dargestellten Informationen auch die Erstellung von Resolvern. Im April 2024 fand ein Spezialwebinar zum Thema statt. Hier geht es zum Videomitschnitt des Spezialwebinars auf unserem QF‑Test YouTube-Kanal. Der UI-Inspektor steht für Android und Web zur Verfügung. Ab QF‑Test Version 7.1 wird zusätzlich noch Windows und Swing/AWT unterstützt, und ab Version 7.1.3 wird ebenfalls FX unterstützt. Die Darstellung der Knoten im Komponentenbaum bietet bereits einen Überblick über die wichtigsten Informationen. Wird die Klasse in blauer Schrift dargestellt, so wird diese Komponente als interessant betrachtet. Dies wiederum legt fest, ob für diese Komponente ein Komponente Knoten angelegt wird. Kann eine generische Klasse (siehe Generische Klassen) bestimmt werden, so wird zuerst die generische Klasse zusätzlich fett visualisiert und dann die ursprüngliche Klasse dahinter in Klammern gesetzt. Standardmäßig werden alle generischen Klassen als interessant betrachtet. Ist eine Komponente unsichtbar, so wird diese in einem Grauton dargestellt.","hash":"usec_inspector","h1":"UI-Inspektor"},"210":{"id":210,"content":"Abbildung 5.14: Beispiel für Allgemeine Informationen UI-Inspektor öffnen Um den UI-Inspektor zu öffnen, haben Sie folgende Möglichkeiten: Über den Menüeintrag »Clients«-»Inspektor anzeigen«. Über den Menüeintrag »Im Inspektor anzeigen« aus dem Kontextmenü bei der Komponentenaufnahme. Über das Kontextmenü »Im Inspektor anzeigen« eines Komponente-Knotens oder eines Knotens, welcher eine QF‑Test ID der Komponente oder eine SmartID enthält. Direkt vom SUT aus über (konfigurierbare) Tastaturkürzel. Standardmäßig Umschalt⁠+⁠Strg⁠+⁠F11 für Windows/Linux bzw. ⌃⇧⁠+⁠F11 für Mac. Siehe \"UI-Inspektor\". Über den Button »Inspektor« im CustomWebResolver installieren Knoten. Im Aufnahmefenster mithilfe des Fadenkreuz-Buttons in der Toolbar, siehe QF‑Test Android-Aufnahmefenster. Toolbar Die Buttons in der Toolbar haben folgende Bedeutung: Komponente auswählen, um sie zu untersuchen. Während der Komponentenauswahl sind Aufnahme- und Check-Funktion deaktiviert, Aktionen werden nicht an das SUT weitergegeben. So können Komponenten im SUT per Mausklick mithilfe der im UI-Inspektor dargestellten Informationen untersucht werden. Navigieren im Komponentenbaum. Zusammen mit dem Inspektor-Modus wird auch die Historienfunktion aktiviert. Diese speichert die Selektionen in UI-Inspektor und Client und man kann rückwärts und vorwärts in diesen navigieren. Komponentenbaum aktualisieren. Ein Aktualisieren ist erforderlich, wenn sich Komponenten geändert haben oder Resolver installiert wurden. Unsichtbare Komponenten im Komponentenbaum anzeigen. Komponenten mit sichtbaren Kindern werden immer angezeigt. Geometrie-Informationen im Komponentenbaum anzeigen. UI-Inspektor-Detailansicht Die Detailansicht gibt einen Überblick über die wichtigsten Eigenschaften einer Komponente. Die Ansicht ist in drei Teilbereiche untergliedert: Allgemein Dieser Bereich umfasst die grundlegenden Eigenschaften einer Komponente, etwa ihre Klasse.","hash":"figure_5.14","h4":"Abbildung 5.14: Beispiel für Allgemeine Informationen"},"211":{"id":211,"content":"Dieser Bereich umfasst die grundlegenden Eigenschaften einer Komponente, etwa ihre Klasse. Abbildung 5.15: Allgemeine Informationen Engine-spezifisch Die Engine-spezifischen Details umfassen eher technische Informationen zu einer Komponente. Die zur Verfügung stehenden Information unterscheiden sich je nach verwendeter Technologie. Bei Web-Anwendungen sind es Informationen über das DOM-Element, etwa dessen HTML-Tag, die HTML-Attribute und der auslesbare Text.","hash":"figure_5.15","h4":"Abbildung 5.14: Beispiel für Allgemeine Informationen"},"212":{"id":212,"content":"Die Engine-spezifischen Details umfassen eher technische Informationen zu einer Komponente. Die zur Verfügung stehenden Information unterscheiden sich je nach verwendeter Technologie. Bei Web-Anwendungen sind es Informationen über das DOM-Element, etwa dessen HTML-Tag, die HTML-Attribute und der auslesbare Text. Abbildung 5.16: Web-spezifische Informationen In Android sind es Informationen über die Android-Komponente und beinhalten die inhaltliche Beschreibung, Ressourcen-ID, Paketname sowie Informationen über den Fenster-Typ und dessen Anordnung.","hash":"figure_5.16","h4":"Abbildung 5.14: Beispiel für Allgemeine Informationen"},"213":{"id":213,"content":"Abbildung 5.17: Android-spezifische Informationen In Windows-Anwendungen sind es Informationen über das Automation Element und beinhalten die wichtigsten UI Automation-Eigenschaften. Detaillierte Beschreibungen dieser Informationen finden Sie in \"Die WinControl Klasse\".","hash":"figure_5.17","h4":"Abbildung 5.17: Android-spezifische Informationen"},"214":{"id":214,"content":"Abbildung 5.18: Windows-spezifische Informationen In Swing-Anwendungen enthält der UI-Inspektor Informationen über die Swing-Komponente und die wichtigsten Accessible Properties sowie den Namen, Tooltip und die Clientproperties.","hash":"figure_5.18","h4":"Abbildung 5.18: Windows-spezifische Informationen"},"215":{"id":215,"content":"Abbildung 5.19: Swing-spezifische Informationen In FX-Anwendungen enthält der UI-Inspektor Informationen über die FX-Komponente und die wichtigsten Accessible Properties sowie den Style, ID, Tooltip und die Clientproperties.","hash":"figure_5.19","h4":"Abbildung 5.19: Swing-spezifische Informationen"},"216":{"id":216,"content":"Abbildung 5.20: FX-spezifische Informationen In SWT-Anwendungen enthält der UI-Inspektor Informationen über das SWT-Widget, wie benutzerdefinierte Daten, Tooltip, Schriftart, Sichtbarkeit und Aktivierungsstatus.","hash":"figure_5.20","h4":"Abbildung 5.20: FX-spezifische Informationen"},"217":{"id":217,"content":"Abbildung 5.21: SWT-spezifische Informationen QF‑Test spezifisch Diese Informationen sind an den bekannten Komponente-Knoten Knoten angelehnt. Sie eignen sich gut, um zu überprüfen, ob ein erstellter Resolver wie gewünscht funktioniert.","hash":"figure_5.21","h4":"Abbildung 5.21: SWT-spezifische Informationen"},"218":{"id":218,"content":"Diese Informationen sind an den bekannten Komponente-Knoten Knoten angelehnt. Sie eignen sich gut, um zu überprüfen, ob ein erstellter Resolver wie gewünscht funktioniert. Abbildung 5.22: QF‑Test spezifische Informationen Die Detailansicht kann zusätzlich die Informationen zu zwei verschiedenen Komponenten nebeneinander darstellen, so dass man diese leicht vergleichen kann. Dazu klickt man mit der rechten Maustaste auf einen anderen Knoten im Komponentenbaum und wählt »Vergleichen« aus dem Kontextmenü. Über »Vergleichsknoten zurücksetzen« aus dem Kontextmenü oder mithilfe des Schließen-Buttons der Detailansicht wird man die Vergleichsansicht wieder los.","hash":"figure_5.22","h4":"Abbildung 5.21: SWT-spezifische Informationen"},"219":{"id":219,"content":"Pro Handbuch","hash":"","h0":"Variablen | QF‑Test Handbuch"},"220":{"id":220,"content":"Pro Handbuch","hash":"home-link","h0":"Variablen | QF‑Test Handbuch"},"221":{"id":221,"content":"Variablen Es gibt ein kurzes Überblicksvideo zu Variablen, welches die wichtigsten Punkte dieses Kapitels abdeckt. Variablen sind von zentraler Bedeutung, wenn es darum geht, die Wiederverwendbarkeit einer Testsuite zu steigern. Zum Einsatz kommen sie vor allem beim Aufruf von Prozeduren. Variablen sind aber auch in vielen anderen Situationen hilfreich. Variablen können in allen Attributen mit Eingabefeldern verwendet werden. Viele Checkboxen können über den links davor stehenden Button in Eingabefelder umgewandelt werden, dann können dort Wahrheitswerte entweder direkt oder als Variablen eingetragen werden.","hash":"usec_variables","h0":"Variablen"},"222":{"id":222,"content":"Variablenreferenzen Es gibt mehrere Möglichkeiten Variablen zu referenzieren:","hash":"usec_var_references","h1":"Variablenreferenzen"},"223":{"id":223,"content":"Referenzierung einfacher Variablen $(Variablenname) gibt den Wert einer Variablen zurück. Ist der Wert keine Zeichenkette, wird aber als Teil einer Zeichenkette ausgewertet oder das Ergebnis als Text genutzt, so wird automatisch die Text-Darstellung des Wertes verwendet.","hash":"usec_var_references_single_var","h2":"Referenzierung einfacher Variablen"},"224":{"id":224,"content":"Referenzierung von Gruppenvariablen ${Gruppe:Name} greift auf eine Variable in einer Variablengruppe zu. Damit können zum Beispiel Variablen in einer Gruppe angesprochen werden, in die Daten aus einer externen Quelle (siehe Externe Daten) geladen wurden. Einige Gruppen, zum Beispiel qftest, env und system, sind immer definiert und haben besondere Bedeutungen (vgl. Spezielle Gruppen). Auch hier wird kontextabhängig automatisch die Text-Darstellung des Wertes zurückgegeben.","hash":"usec_var_references_group","h2":"Referenzierung von Gruppenvariablen"},"225":{"id":225,"content":"Referenzierung von Variablen in Skripten und Skriptausdrücken Für Skripte und Skriptausdrücke (zum Beispiel $[Jython-Ausdruck] oder die Bedingung eines If-Knotens), ist der Zugriff auf Variablen, die über QF‑Test Knoten angelegt wurden, in Variablen beschrieben. Die Runcontext-Methoden rc.get* Es gibt viele Methoden im Runcontext-Modul, mit denen auf Variablen zugegriffen werden kann, zum Beispiel rc.getStr, rc.getInt, rc.getNum, rc.getBool oder rc.getObj. Eine detaillierte Beschreibung dieser Methoden finden Sie in Das rc-Modul: Die API des Runcontexts. Das Runcontext-Feld rc.vars Der Runcontext ermöglicht mit dem Map-änlichen Objekt rc.vars einen einfachen Zugriff auf die aktuellen Werte der QF‑Test Variablen: Als Alternative für rc.getObj('Variablenname') kann im Script direkt rc.vars.Variablenname verwendet werden. Wird über diesen Ausdruck ein Wert zugewiesen, so entspricht dies dem Setzen einer lokalen Variable, analog zu rc.setLocal. Das Runcontext-Feld rc.groups Analog zu rc.vars ist es möglich, mit rc.groups auf Gruppenvariablen zuzugreifen: Anstelle von rc.getObj('Gruppe','Name') oder rc.getObj('qftest','dir.version') kann rc.groups.Gruppe.Name bzw. rc.groups.qftest.dir.version genutzt werden. Wird diesem Ausdruck ein Wert zugewiesen, so entspricht dies dem Setzen eines Wertes in einer Gruppe, analog zu rc.setGroupObject. Dabei ist zu beachten, dass Elementen in speziellen Gruppen unter Umständen kein Wert zugewiesen werden kann. In diesem Fall wird dann eine ReadOnlyPropertyException geworfen. $(Variablenname) und ${Gruppe:Name} in Jython-Skripten In Jython-Skripten und -Skriptausdrücken können QF‑Test Variablen mit der gleichen Syntax wie in normalen Knoten referenziert werden. Da das Jython-Skript technisch eine Zeichenkette ist, wird bei der Expansion der Textwert der jeweiligen Variable in den Jython-Code eingefügt. Diese diese Referenzierungsart wird nicht empfohlen. Wenn der Variablenwert Zeichen wie Rückstriche (\\) oder Zeilenumbrüche enthält, kann dies zu unerwünschten Effekten führen.","hash":"usec_var_references_script","h2":"Referenzierung von Variablen in Skripten und Skriptausdrücken"},"226":{"id":226,"content":"Ermittlung des Wertes einer Variablen Um zu erklären, wie und warum Variablen an verschiedenen Stellen definiert werden, müssen wir zunächst darauf eingehen, wie der Wert einer Variablen ermittelt wird, wenn diese bei einem Testlauf referenziert wird. Jede Variablendefinition wird auf einem von zwei Stapeln abgelegt. Der primäre Stapel ist für direkte Zuordnungen bestimmt, während der sekundäre Stapel Definitionen von Rückfallwerten aufnimmt. Wenn der Wert einer Variable zum Beispiel mittels $(...) angefordert wird, durchsucht QF‑Test zunächst den primären Stapel von oben nach unten nach einer passenden Definition. Wird keine solche gefunden, wird die Suche im sekundären Stapel fortgesetzt, ebenfalls von oben nach unten. Bleibt auch diese Suche erfolglos, wird eine UnboundVariableException geworfen, sofern Sie nicht mittels der speziellen Syntax ${default:varname:defaultvalue} bzw. im Skript über rc.withDefault('defaultvalue').getStr('varname') einen Defaultwert angegeben haben (vgl. Spezielle Gruppen).","hash":"usec_var_lookup","h1":"Ermittlung des Wertes einer Variablen"},"227":{"id":227,"content":"Oberste Definitionen (höchste Bindungskraft) ... Unterste Definitionen (niedrigste Bindungskraft) Oberste Definitionen (höchste Bindungskraft) ... Unterste Definitionen (niedrigste Bindungskraft) Primärstapel (direkte Zuordnungen) Sekundärstapel (Defaultwerte) Abbildung 6.1: Direkte Zuordnungen und Defaultwerte Der Mechanismus unterstützt rekursive bzw. selbstbezogene Variablendefinitionen. Zum Beispiel bewirkt das Setzen der Variable classpath auf den Wert irgendein/pfad/archiv.jar:$(classpath) eine Erweiterung des Wertes einer Definition von classpath mit geringerer Bindungskraft. Existiert keine solche Definition, wird eine RecursiveVariableException ausgelöst.","hash":"figure_6.1","h1":"Ermittlung des Wertes einer Variablen"},"228":{"id":228,"content":"Definition von Variablen Variablen können an verschiedenen Stellen definiert werden. Variablendefinitionstabellen Zweispaltige Tabellen werden zum Beispiel im Prozeduraufruf verwendet, um die zu übergebenden Parameternamen und -werte zu definieren oder in einem Prozedur-Knoten, um die Rückfallwerte zu setzen. In jeder Zeile kann eine Variable mit Name und Wert angegeben werden. In vielen weiteren Knoten wie zum Beispiel Testsuite, Testfallsatz und Testfall können Variablen ebenfalls in Tabellen definiert werden. Rückgabewert einer Prozedur Bei Prozeduraufrufen kann die gerufene Prozedur einen Wert zurückliefern. Dieser wird dann der Variablen mit dem in Variable für Rückgabewert eingetragenen Namen im Prozeduraufruf-Knoten zugewiesen. In der gerufenen Prozedur kann dabei der Typ des zurückgegebenen Objektes mit dem Attribut Expliziter Objekttyp des Return-Knotens festgelegt werden. Ergebnis eines Checks Eine der möglichen Ergebnisbehandlungen in einem Check-Knoten ist die Zuweisung des Ergebnisses an eine Variable, deren Namen im Attribut Variable für Ergebnis angegeben wurde, zum Beispiel bei einem Check Boolean-Knoten. Rückgabewert eines Auslesen-Knotens Die Auslesen-Knoten, zum Beispiel Text auslesen, weisen den erhaltenen Wert einer Variablen zu, deren Name im Attribut Variablenname angegeben ist. Variable setzen-Knoten Über den Variable setzen-Knoten können Variablen ebenfalls definiert werden. Mit dem Attribut Expliziter Objekttyp kann dabei der Typ des zurückgegebenen Objektes festgelegt werden. Skript-Knoten In Skripten können über die Methoden rc.setLocal, rc.setGlobal, rc.setLocalJson etc. Variablen gesetzt werden, die dann in QF‑Test Knoten verwendet werden können. setGroupObject kann genutzt werden, um Variablen in einer Variablengruppe zu setzen. Für weitere Informationen siehe Skripting oder auch Das rc-Modul: Die API des Runcontexts. Optionendialog Im Optionendialog können Variablen in der Rubrik \"Variablen\" gesetzt und geändert werden (vgl. Variablen). Dies ist besonders für globale, System- und Kommandozeilen-Variablen interessant.","hash":"sec_definition_von_variablen","h1":"Definition von Variablen"},"229":{"id":229,"content":"Im Optionendialog können Variablen in der Rubrik \"Variablen\" gesetzt und geändert werden (vgl. Variablen). Dies ist besonders für globale, System- und Kommandozeilen-Variablen interessant. Abbildung 6.2: Definition von Systemvariablen im Optionendialog","hash":"figure_6.2","h1":"Definition von Variablen"},"230":{"id":230,"content":"Variablenebenen Variablen können auf unterschiedlichen Ebenen definiert werden. Wie bereits beschrieben gibt es die grundlegende Unterscheidung bei der Auswertungsreihenfolge der Variablendefinitionen zwischen Primär- und Sekundärstapel. In beiden Stapeln gibt es weitere festgelegte Ebenen.","hash":"usec_variable_levels","h1":"Variablenebenen"},"231":{"id":231,"content":"Primärstapel Für den Primärstapel gilt folgende Reihenfolge:","hash":"sec_primarstapel","h2":"Primärstapel"},"232":{"id":232,"content":"Lokale Testfall-Variablen Lokale Testfall-Variablen liegen im oberen Teil des Primärstapels. Während der Testausführung werden für jeden Knoten, der betreten wird, die definierten Variablen (aber nicht die Rückfallwerte!) oben auf den Stapel gelegt und beim Verlassen desselben wieder entfernt. Für jeden Knoten, der eine Variablendefinitionstabelle besitzt, wird auf dem Primärstapel eine eigene Ebene angelegt, in der die in der Tabelle definierten Variablen liegen. Variable aus lokalen (nicht globalen!) Variablenzuweisungen werden in einer der vorhandenen Ebenen hinzugefügt beziehungsweise aktualisiert, zum Beispiel der Rückgabewert einer Prozedur, die Ergebnisvariable eines Check- beziehungsweise Auslesen-Knotens oder Variablen, die über Variable setzen oder Skript-Knoten erstellt werden. Die Variable wird der Ebene des obersten Prozedurknotens, oder wenn nicht vorhanden, des Testfallknotens hinzugefügt beziehungsweise aktualisiert - falls die Variable nicht in einer darüber liegenden Ebene (zum Beispiel Sequenz-, Testschritt-, Schleife-, If-Knoten) bereits existiert. In diesem Fall wird der Wert der Variable in dieser höheren Ebene aktualisiert. Um lokale Variablen anzulegen, muss bei den entsprechenden Knoten das Attribut Lokale Variable aktiviert sein. Dies kann in den Optionen voreingestellt werden (siehe Variablen). Aus Skripten heraus werden lokale Variablen mit den Methoden rc.setLocal oder rc.setLocalJson angelegt (siehe Das rc-Modul: Die API des Runcontexts).","hash":"sec_lokale_testfall_variablen","h2":"Lokale Testfall-Variablen"},"233":{"id":233,"content":"Globale Variablen Wenn in Knoten, die Variablen definieren können, das Attribut Lokale Variable nicht aktiviert ist, wird die Variable auf der Ebene der globalen Variablen angelegt. Aus Skripten heraus werden Variablen auf dieser Ebene mit den Methoden rc.setGlobal oder rc.setGlobalJson (siehe Das rc-Modul: Die API des Runcontexts), angelegt. Eine globale Variable kann auch trotz Lokale Variable erzeugt werden, wenn kein Kontext für lokale Variablen verfügbar ist. Dies ist zum Beispiel der Fall, wenn ein Knoten direkt aus den 'Extrasequenzen' ausgeführt wird. Eine globale Variable bleibt unverändert bestehen, bis sie explizit aktualisiert, gelöscht oder QF‑Test beendet wird. Die globalen Variablen \"überleben\" also einzelne Testläufe. Sie dienen dazu, Werte zwischen voneinander unabhängigen Testfällen oder Prozeduren auszutauschen. Sie sollten aber im Hinterkopf behalten, dass diese Variablen zunächst durch den Ablauf des Tests definiert werden müssen, bevor sie referenziert werden können. Falls Sie globale Variablen bearbeiten wollen, ist dies entweder im Debug-Modus möglich (siehe Anzeige der Variablen im Debug-Modus – Beispiel) oder im Optionendialog in der Rubrik \"Variablen\". Um vor einem Testlauf die vorhandenen globalen Variablen zu löschen, nutzen Sie den Menüeintrag »Wiedergabe«-»Globale Variablen löschen«. Läuft QF‑Test im Batchmodus (vgl. Aufruf von QF‑Test), werden die globalen Variablen vor der Ausführung jedes mit dem Kommandozeilenargument -test <Index>|<ID> angegebenen Tests gelöscht.","hash":"usec_variable_levels_globals","h2":"Globale Variablen"},"234":{"id":234,"content":"Kommandozeilen-Variablen Beim Start von QF‑Test können über Kommandozeilenargumente Variablen definiert werden. Diese rangieren über den Variablen, die im Testsuite-Knoten spezifiziert sind. In der Kommandozeile werden die Variablen über das Argument -variable <Name>=<Wert> gesetzt, siehe auch Kommandozeilenargumente und Rückgabewerte.","hash":"sec_kommandozeilen_variablen","h2":"Kommandozeilen-Variablen"},"235":{"id":235,"content":"Variablen des Testsuite-Knotens Auf dieser Ebene des Stapels liegen die Variablen, die im Testsuite-Knoten der aktuellen Testsuite definiert sind. Hier werden typischerweise Variablen angelegt, die für alle Tests der Testsuite gelten und bei Bedarf in einem Batch-Lauf per Kommandozeile überschrieben werden können sollen. Ein typisches Beispiel hierfür ist die Wahl des Browsers, in dem eine Webapplikation ausgeführt werden soll. Diese kann sich dann zwischen interaktiver Testentwicklung und Batch-Ausführung unterscheiden.","hash":"sec_variablen_des_testsuite_knotens","h2":"Variablen des Testsuite-Knotens"},"236":{"id":236,"content":"Sekundärstapel Für den Sekundärstapel gilt folgende Reihenfolge:","hash":"sec_sekundarstapel","h2":"Sekundärstapel"},"237":{"id":237,"content":"Rückfallwerte Beim Betreten eines Knotens, für den Rückfallwerte definiert wurden, werden diese oben auf den Sekundärstapel gelegt. Wenn ein Knoten aus einer anderen Testsuite aufgerufen wird, werden auch die Variablen des Testsuite-Knotens der verlassenen Testsuite vom Primärstapel genommen und oben auf den Sekundärstapel gelegt. Beim Verlassen des Knotens beziehungsweise der Testsuite werden die Variablen wieder vom Sekundärstapel entfernt und im Falle der Testsuite auf den Primärstapel in die entsprechende Ebene verschoben. Auf dem Sekundärstapel werden nur dann Einträge angelegt, wenn für die entsprechenden Knoten Rückfallwerte definiert wurden oder rufende Testsuiten Variablendefinitionen im Testsuite-Knoten enthalten.","hash":"sec_ruckfallwerte","h2":"Rückfallwerte"},"238":{"id":238,"content":"Systemspezifische Variablen Hier können Pfadnamen, JDK- oder Betriebssystem-spezifische Werte etc. festgelegt werden. Dieser Satz von Definitionen befindet sich immer ganz unten im sekundären Stapel und hat damit die geringste Bindungskraft. Sie können im Optionendialog in der Rubrik \"Variablen\" gesetzt werden. Die Variablen werden zusammen mit anderen Systemoptionen in der System-Konfigurationsdatei gespeichert.","hash":"sec_systemspezifische_variablen","h2":"Systemspezifische Variablen"},"239":{"id":239,"content":"Anzeige der Variablen im Debug-Modus – Beispiel Betrachten wir folgendes Beispiel:","hash":"usec_variables_debug","h1":"Anzeige der Variablen im Debug-Modus – Beispiel"},"240":{"id":240,"content":"Abbildung 6.3: Variablen Beispiel Die Sequenz \"Login\" enthält einen Prozeduraufruf der Prozedur \"login\", die zwei Parameter erwartet: user und password. Die Standardwerte für Parameter der Prozedur sind user=username und password=pwd. Der Prozeduraufruf überschreibt diese mit user=myname und password=mypassword. Die \"login\" Prozedur enthält selbst Prozeduraufrufe von weiteren Prozeduren. Hier werden keine Parameter übergeben. Die Prozeduren \"setUser\" und \"setPassword\" haben in Standardwerte für Parameter jeweils einen Eintrag. Die folgende Abbildung zeigt die Übersicht der Variablendefinitionen zum Zeitpunkt der Ausführung der Prozedur \"setUser\".","hash":"figure_6.3","h4":"Abbildung 6.3: Variablen Beispiel"},"241":{"id":241,"content":"Abbildung 6.4: Variablendefinitionen Lassen Sie uns einen genaueren Blick auf die einzelnen Zeilen der Tabelle werfen: Prozedur setUser: Keine Variable definiert. Prozeduraufruf setUser: Hier werden keine Variablen übergeben. Dies ist nicht notwendig (wie zum Beispiel bei Java). Bei der Auswertung der Variablendefinitionen sucht QF‑Test die Tabelle Zeile für Zeile von oben nach unten durch - unabhängig von Prozedur- oder Testfallgrenzen. Sobald eine Variable mit dem passenden Namen gefunden wird, wird der zugehörige Wert verwendet. Prozedur login: Keine Variable definiert. Prozeduraufruf login: Hier werden zwei Variablen im Prozeduraufruf definiert. Die Zeile wurde selektiert. Somit sind auf der rechten Seite die definierten Variablen mit ihren Werten zu sehen. Beim aktuellen Ausführungsstand des Tests wird als nächstes die Variable \"name\" verwendet. Da in dieser Zeile das erste Vorkommen einer Variablen mit diesem Namen ist, wird der zugehörige Wert, \"myName\", verwendet. Sequenz Login: Keine Variable definiert. Testfall Test: Keine Variable definiert. Globale Variablen: Im Abhängigkeit-Knoten wurde die Variable \"client\" definiert, da sie in allen Testfällen, die mit der zu testenden Applikation interagieren, benötigt wird. Globale Variablen bleiben unverändert bestehen, bis sie explizit geändert oder gelöscht werden. Kommandozeile: Es wurden drei Variablen in der Kommandozeile definiert. Eine davon ist der Name des Browsers, der für den aktuellen Testlauf verwendet werden soll. Testsuite: Hier ist der Name des Browsers hinterlegt, der verwendet wird, wenn kein anderer Browser in einer der Zeilen darüber definiert ist. Sekundärstapel: Kennzeichnung, dass hier der Primärstapel endet und darunter der Sekundärstapel beginnt. Prozedur setUser: Es ist ein Standardwert für die Variable \"name\" hinterlegt, der verwendet würde, wenn es in keiner der Zeilen darüber eine Variable mit diesem Namen gäbe. Prozedur login: Auch hier sind Standardwerte für die Variablen \"name\" und \"password\" hinterlegt, die verwendet würden, wenn es in keiner der Zeilen darüber eine Variable mit dem entsprechenden Namen gäbe. System: Keine Variable definiert.","hash":"figure_6.4","h4":"Abbildung 6.4: Variablendefinitionen"},"242":{"id":242,"content":"Datentypen von Variablen Die Attributfelder der QF‑Test Knoten interpretieren bis auf wenige Ausnahmen die eingegebenen Werte als Text. Bei den Ausnahmen handelt es sich um die Bedingungen von If-, Testfall- und Testfallsatz-Knoten sowie Code-Attribute, die gültige Ausdrücke einer bestimmten Syntax erwarten. Da die Attribute im Normalfall als Text interpretiert werden, ist eine spezielle Syntax für den Zugriff auf Variablen oder für die Durchführung von Berechnungen oder Textmanipulationen notwendig. Siehe Variablenreferenzen beziehungsweise Skriptausdrücke. In Skript-Knoten können alle Datentypen genutzt werden, die die jeweilige Skriptsprache zur Verfügung stellt. Innerhalb der Skriptinterpreter können die Datenobjekte von beliebigen Skripten genutzt werden (siehe Variablen). Sie tauchen jedoch nicht auf dem Variablenstapel von QF‑Test auf und werden daher weder im Debug-Modus in der Tabelle der Variablendefinitionen angezeigt noch im Protokoll dokumentiert. Um Variablen aus Skripten auf den Variablenstapel von QF‑Test zu legen, stehen die Runcontext-Methoden rc.setLocal und rc.setGlobal zur Verfügung. Hiermit können QF‑Test Variablen Textwerte, aber auch Werte mit anderen Datentypen zugewiesen werden. Um in Variable setzen Knoten Werte zu setzen, die keine Texte darstellen, können im Attribut Defaultwert Skriptausdrücke genutzt werden; oder Sie können die Text-Darstellung des Wertes darin eintragen und über das Attribut Expliziter Objekttyp den gewünschten Objekttyp angeben. Für den Zugriff auf diese Variablen stehen je nach Bedarf unterschiedliche Methoden zur Verfügung. Für QF‑Test Knoten sind sie in Variablenreferenzen beschrieben, für Skripte und Skriptausdrücke in Variablen, speziell für Jython-Skripte in Jython-Variablen. Eine detaillierte Beschreibung der Methoden finden Sie in Das rc-Modul: Die API des Runcontexts.","hash":"usec_var_datatypes","h1":"Datentypen von Variablen"},"243":{"id":243,"content":"JSON-Daten Bei der Arbeit mit HTTP-Requests werden die Daten oft als JSON-Objekt bereitgestellt. Wenn Sie das Objekt serialisieren, also in eine JSON-Zeichenkette umwandeln und einer QF‑Test Variablen zuweisen wollen, können Sie die Methoden rc.setLocalJson() und rc.setGlobalJson() des Runcontexts (siehe Das rc-Modul: Die API des Runcontexts) in einem Skript-Knoten verwenden. Wenn Sie eine JSON-Zeichenkette in ein JSON-Objekt umwandeln wollen, steht Ihnen in einem Skript-Knoten rc.getJson() im Runcontext (siehe Das rc-Modul: Die API des Runcontexts) zur Verfügung. JSON-Objekte können mit den in Das JSON-Modul beschriebenen Methoden bearbeitet werden.","hash":"usec_var_json","h2":"JSON-Daten"},"244":{"id":244,"content":"Externe Daten Auf externe Daten kann mit Hilfe von Properties laden, Excel-Datei, Datenbank, CSV-Datei und Ressourcen laden Knoten zugegriffen werden. Diese weisen einem Satz von Definitionen einen Gruppennamen zu. Den Wert einer Ressource oder Property mit der Bezeichnung Name erhalten Sie mit der Syntax ${Gruppe:Name}. In einem Datentreiber kann ebenfalls über Excel-Datei, Datenbank und CSV-Datei auf externe Daten zugegriffen werden. In diesem Fall wird jedoch keine Gruppe erstellt, sondern je Datenzeile eine Schleifeniteration generiert, in der die Werte des Datensatzes an einfache Variablen gebunden, deren Name der Titel der entsprechenden Datenspalte ist und auf die über die Syntax $(Spaltentitel) zugegriffen werden kann. Wird ein Test im Batchmodus ausgeführt (vgl. Aufruf von QF‑Test), löscht QF‑Test die Ressourcen und Properties vor der Ausführung jedes mit dem Kommandozeilenargument -test <Index>|<ID> angegebenen Tests. Im interaktiven Modus werden diese aufgehoben, um das Erstellen einer Testsuite zu vereinfachen. Vor einem kompletten Testlauf sollten Sie allerdings mittels »Wiedergabe«-»Ressourcen und Properties löschen« für eine saubere Ausgangsbasis sorgen.","hash":"usec_externaldata","h1":"Externe Daten"},"245":{"id":245,"content":"Spezielle Gruppen Folgende Variablengruppen sind immer vorhanden. Auf die Werte kann über die Syntax ${Gruppenname:Variablenname} zugeriffen werden. system Über die Gruppe system haben Sie Zugriff auf die System Properties der laufenden Java-VM (für Programmierer: System.getProperties()). Es handelt sich dabei immer um die VM, mit der QF‑Test gestartet wurde, da die Variablen-Expansion dort stattfindet. So liefert etwa ${system:java.class.path} den Klassenpfad, mit dem QF‑Test gestartet wurde oder ${system:user.home} das Heimatverzeichnis des Benutzers. Welche Namen in der system Gruppe definiert sind, hängt vom verwendeten JDK ab. env Falls das Betriebssystem Umgebungsvariablen wie PATH, TMP oder JAVA_HOME unterstützt (was auf praktisch allen Systemen der Fall ist, auf denen QF‑Test läuft), kann über die Gruppe env auf diese Variablen zugegriffen werden. decrypt Über die Gruppe decrypt können Sie eine Zeichenkette für die weitere Verarbeitung in QF‑Test (zum Beispiel für eine Eingabe in Textfelder, ein Token für einen API-Zugriff oder ein Datenbankpasswort) temporär entschlüsseln. QF‑Test ersetzt dabei im Protokoll die Expansion eines entschlüsselten Wertes durch den Platzhalter ***. Zum Verschlüsseln eines Wertes markieren Sie diesen im Variable setzen Knoten und wählen Sie nach einem Rechts-Klick »Text verschlüsseln« aus dem resultierenden Popupmenü. Hinweis: Bei einigen Werten in QF‑Test Knoten wird grundsätzlich der endgültige Expansionswert im Protokoll ausgegeben. Begutachten Sie daher im Zweifelsfall die Werte im Protokoll, bevor Sie dieses weitergeben. Beachten Sie darüber hinaus die Hinweise zur Option Salt für Verschlüsselung von Kennwörtern. default Sie können über die Gruppe default einen Defaultwert für eine Variable angeben. Die Syntax hierfür ist ${default:varname:defaultvalue}, in Skripten rc.withDefault('defaultvalue').getStr('varname') oder auch rc.getStr('default', 'varname:defaultvalue'). Dies ist sehr nützlich für Dinge wie generische Komponenten und nahezu überall, wo es einen sinnvollen Defaultwert für eine Variable gibt, da der Defaultwert dann eng mit der Anwendung der Variablen verbunden ist und nicht auf Sequenz oder Testsuite-Ebene definiert werden muss. Natürlich sollten Sie diese Syntax nur verwenden, wenn die Variable nur an einer oder sehr wenigen Stellen benutzt wird. Wenn Sie dieselbe Variable mit dem selben Defaultwert an verschiedenen Stellen verwenden, ist es besser, die normale $(...) Syntax zu verwenden und den Defaultwert explizit festzulegen, da dieser dann bei Bedarf an einer einzigen Stelle geändert werden kann. as Über die Gruppe as lässt sich - ähnlich wie in einem Variable setzen oder Return Schritt - der Typ eines Objektes ändern. Die Syntax hierfür ist ${as:type:value}, wobei in value über $(...) auch Werte in Variablen referenziert werden können. Gültige Werte für type sind: string, str, boolean, number, object, pattern, integer, int, long, float, double, cmdline und json. id Die Gruppe id dient dazu, QF‑Test IDs von Komponenten zu referenzieren. Die Werte in dieser Gruppe expandieren einfach zu sich selbst, d.h. \"${id:wasauchimmer}\" wird zu \"wasauchimmer\"code>. Man kann QF‑Test IDs von Komponenten zwar auch ohne diese Gruppe ansprechen, allerdings verbessert die Referenzierung über diese Gruppe die Lesbarkeit der Tests. Vor allem aber werden diese QF‑Test IDs auch beim Verschieben der referenzierten Komponente oder Änderungen an ihrer QF‑Test ID angepasst. idlocal Die Gruppe idlocal ist analog zur Gruppe id, enthält aber zusätzlich den Pfad der aktuellen Testsuite, d.h. aus \"${idlocal:x}\" wird \"pfad/zur/aktuellen/suite/suite.qft#x\". Damit lässt sich erzwingen, dass eine Komponente nur aus der Testsuite genommen wird, die zum Zeitpunkt der Expansion aktuell ist, selbst wenn es eine Komponente mit derselben QF‑Test ID in der Zieltestsuite für den Prozeduraufruf gibt. quoteitem Mit Hilfe der Gruppe quoteitem können Sie bequem Sonderzeichen wie '@', '&' und '%' im textuellen Index eines Unterelements schützen, um zu verhindern, dass dieses als mehrere Unterelemente interpretiert wird. Aus \"${quoteitem:user@host.org}\" wird zum Beispiel \"user\\@host.org\". quoteregex, quoteregexp Die Gruppe quoteregex mit ihrem Alias quoteregexp kann zum Schützen von Sonderzeichen mit spezieller Bedeutung in Reguläre Ausdrücke - Regexps verwendet werden. Dies ist hilfreich, wenn reguläre Ausdrücke dynamisch zusammengebaut werden. quotesmartid Die Gruppe quotesmartid schützt analog zu quoteitem die Zeichen für Unterelemente '@', '&' und '%', außerdem die Zeichen ':', '=', '<' und '>' mit spezieller Bedeutung für SmartIDs. Aus \"${quotesmartid:Name: A & B}\" wird zum Beispiel \"Name\\: A \\& B\". qftest Die Gruppe namens qftest stellt verschiedene Werte zur Verfügung, die beim Ablauf eines Tests von Bedeutung sein können. Die bisher definierten Werte können Sie den folgenden Tabellen entnehmen.","hash":"usec_special_groups","h1":"Spezielle Gruppen"},"246":{"id":246,"content":"Die Gruppe namens qftest stellt verschiedene Werte zur Verfügung, die beim Ablauf eines Tests von Bedeutung sein können. Die bisher definierten Werte können Sie den folgenden Tabellen entnehmen. Name Bedeutung 32 oder 32bit Nicht mehr relevant, da die Unterstützung von 32 Bit Java für QF‑Test mit Version 8.0 eingestellt wurde. true wenn QF‑Test in einer 32-Bit-Java-VM läuft - was nicht bedeutet, dass dies auf einem 32 Bit Betriebssystem erfolgt - andernfalls false. 64 oder 64bit Nicht mehr relevant, da die Unterstützung von 32 Bit Java für QF‑Test mit Version 8.0 eingestellt wurde. true wenn QF‑Test in einer 64 Bit Java-VM läuft, andernfalls false. batch true falls QF‑Test im Batch Modus läuft, false im interaktiven Modus. client.baseEngineName.<name> Der Basisname der primären Engine des Clients, der mit <name> als Client Attribut gestartet wurde, z.B. fx. client.browser.<name> Der Name bzw. Typ des Browsers des Clients, der mit <name> als Client Attribut gestartet wurde, z.B. safari. Steht nur für Web-Clients zur Verfügung. client.deviceName.<name> Ein Name für das (emulierte) Gerät des Clients, der mit <name> als Client Attribut gestartet wurde, z.B. Pixel_3. Steht nur zur Verfügung für Android-Clients nach der Instrumentierung und entspricht dort bei emulierten Geräten dem AVD-Namen. client.deviceType.<name> Der Typ des (emulierten) Geräts des Clients, der mit <name> als Client Attribut gestartet wurde. Kann die Werte emulator (für ein emuliertes Gerät) und device (für ein real angeschlossenes Gerät) annehmen. Steht nur zur Verfügung für Android-Clients nach der Instrumentierung. client.connectionMode.<name> Der Name des Verbindungsmodus des Clients, der mit <name> als Client Attribut gestartet wurde. Gültige Werte sind qfdriver, cdpdriver, webdriver und embedded. Steht nur für Web-Clients zur Verfügung. client.engine.<name> Die primäre Engine des Clients, der mit <name> als Client Attribut gestartet wurde. Das Ergebnis besteht dabei aus dem Basisnamen der Engine und einem numerischen Index, z.B. fx0. client.engineNames.<name> Eine Liste aller verbundenen Engines des Clients, der mit <name> als Client Attribut gestartet wurde, z.B. [fx0, web_fx0]. client.exitCode.<name> Der Rückgabewert des letzten Prozesses, der mit <name> als Client Attribut gestartet wurde. Ist der Prozess noch aktiv, ist das Ergebnis leer. client.mainVersion.<name> Der Hauptversion des Browsers bzw. des Geräte-Betriebssystems des Clients, der mit <name> als Client Attribut gestartet wurde, z.B. 121. Steht nur zur Verfügung für Web-Clients, nachdem das erste Browserfenster geöffnet wurde, und für Android-Clients nach der Instrumentierung. client.output.<name> Die Ausgaben des letzten Prozesses, der mit <name> als Client Attribut gestartet wurde. Das Maximum an gespeichertem Text wird durch die Option Maximalgröße des Terminals für einen Client (kB) bestimmt. client.SDKVersion.<name> Der SDK-Version des Geräte-Betriebssystems des Clients, der mit <name> als Client Attribut gestartet wurde, z.B. 29. Steht nur zur Verfügung für Android-Clients nach der Instrumentierung. client.stdOut.<name> Die vom letzten Prozesses, der mit <name> als Client Attribut gestartet wurde, auf den Standardausgabestream (stdout) geschriebenen Ausgaben. Das Maximum an gespeichertem Text wird durch die Option Maximalgröße des Terminals für einen Client (kB) bestimmt. client.stdErr.<name> Die vom letzten Prozesses, der mit <name> als Client Attribut gestartet wurde, auf den Fehlerausgabestream (stderr) geschriebenen Ausgaben. Das Maximum an gespeichertem Text wird durch die Option Maximalgröße des Terminals für einen Client (kB) bestimmt. client.version.<name> Der Browserversion bzw. die Version des Geräte-Betriebssystems des Clients, der mit <name> als Client Attribut gestartet wurde, z.B. 121.10.2967.10. Steht nur zur Verfügung für Web-Clients, nachdem das erste Browserfenster geöffnet wurde, und für Android-Clients nach der Instrumentierung. clients Eine Liste der Namen der aktiven Client-Prozesse, mit Zeilentrennern getrennt. clients.all Eine Liste der Namen aller Client-Prozesse, mit Zeilentrennern getrennt. Die Liste enthält aktive Prozesse ebenso wie kürzlich beendete, analog zum \"Clients\" Menü. count.exceptions Anzahl der Exceptions im aktuellen Testlauf. count.errors Anzahl der Fehler im aktuellen Testlauf. count.warnings Anzahl der Warnungen im aktuellen Testlauf. count.testCases Gesamtanzahl der Testfälle (ausgeführt und übersprungen) im aktuellen Testlauf. count.testCases.exception Anzahl der Testfälle mit Exceptions im aktuellen Testlauf. count.testCases.error Anzahl der Testfälle mit Fehlern im aktuellen Testlauf. count.testCases.expectedToFail Anzahl der erwartet fehlgeschlagenen Testfälle im aktuellen Testlauf. count.testCases.ok Anzahl der erfolgreichen Testfälle im aktuellen Testlauf. count.testCases.ok.percentage Prozentsatz der erfolgreichen Testfälle im aktuellen Testlauf. count.testCases.skipped Anzahl der übersprungenen Testfälle im aktuellen Testlauf. count.testcases.notImplemented Anzahl der nicht implementierten Testfälle im aktuellen Testlauf. count.testCases.run Anzahl der ausgeführten Testfälle im aktuellen Testlauf. count.testSets.skipped Anzahl der übersprungenen Testfallsätze im aktuellen Testlauf. dir.cache Das Cache-Verzeichnis von QF‑Test dir.groovy Verzeichnis von Groovy dir.javascript Verzeichnis von JavaScript dir.jython Verzeichnis von Jython dir.log Das Logverzeichnis von QF‑Test dir.plugin Das Pluginverzeichnis von QF‑Test dir.root Wurzelverzeichnis von QF‑Test dir.runlog Protokollverzeichnis von QF‑Test dir.system Das systemspezifische Konfigurationsverzeichnis von QF‑Test. dir.user Das anwenderspezifische Konfigurationsverzeichnis von QF‑Test dir.version Versionsspezifisches Verzeichnis von QF‑Test engine.<componentId> Ermittelt die GUI-Engine, die für die angegebene Komponente zuständig ist (vgl. GUI-Engines). language Die Sprache in welcher QF‑Test seine graphische Oberfläche darstellt. license Der Pfad der Lizenzdatei systemCfg Der Pfad der Systemkonfigurationsdatei userCfg Der Pfad der benutzerspezifischen Konfigurationsdatei executable Die ausführbare qftest Programmdatei passend zur aktuell laufenden QF‑Test Version, inklusive vollem Pfad zu deren bin Verzeichnis und mit .exe Anhang unter Windows. Dies ist hilfreich, falls Sie QF‑Test aus QF‑Test starten wollen, z.B. um einen Daemon-Aufruf auszuführen oder Reports zu generieren. isInRerun \"true\", wenn aktuelle Ausführung nochmals ausgeführt wird, sonst \"false\", Details siehe Fehlerhafte Knoten sofort wiederholen. isInRerunFromLog \"true\", wenn Testlauf aus dem Protokoll nochmals gestartet wurde, sonst \"false\", Details siehe Erneute Ausführung aus dem Protokoll. java Standard Java-Programm (javaw unter Windows, java unter Linux) oder das explizit mittels -java <Programm> (abgekündigt) angegebene Java-Programm. java.mainVersion Die Hauptversion des JRE mit dem QF‑Test aktuell läuft, wobei 8 für Java 1.8 genommen wird, also z.B. 8, 11 oder 17. java.subVersion Die Unterversion des JRE mit dem QF‑Test aktuell läuft. Für Java 8 wird die Unterversion nach dem '_ genommen, was z.B. für java.version 1.8.0_302 zu 302 führt. Für Java 9 oder höher ist dies die normale Unterversion, also z.B. 9 in Fall von java.version 11.0.9. linux \"true\" unter Linux, andernfalls \"false\" macOS \"true\" unter macOS, andernfalls \"false\" os.fullVersion Die vollständige Version des Betriebssystems os.mainVersion Die Hauptversion des Betriebssystems, z.B. \"10\" für Windows 10 os.name Der Name des Betriebssystems os.version Die konkrete Version des Betriebssystems. Unter Windows kann diese ggf. nicht vollständig sein. In diesem Fall sollten Sie auf os.fullversion zurückgreifen. project.dir Das Verzeichnis des aktuellen Projektes. Die Variable ist nicht definiert, wenn die aktuelle Test suite sich nicht in einem Projekt befindet. rerunCounter Nummer des aktuellen Versuchs der Neuausführung, sonst immer 0 (siehe Fehlerhafte Knoten sofort wiederholen). return Der letzte mittels eines Return Knotens aus einer Prozedur zurückgegebene Wert. runID Die Run-ID des aktuellen Testlaufs. Nähere Informationen zur Run-ID finden Sie in \"Reports\". screen.height Bildschirmhöhe in Pixel screen.width Bildschirmbreite in Pixel skipNode Dieser spezielle Wert ist nur für erfahrene Anwender. Er weist QF‑Test an, die Ausführung des aktuellen Knotens zu überspringen. Sein primärer Nutzen ist als Wert für eine Variable im Attribut Text eines Texteingabe Knotens, dessen Attribute Zielkomponente zunächst leeren gesetzt ist. Ein leerer Wert würde hier zu einem Löschen des Textfeldes führen, $_{qftest:skipnode} hingegen das Feld unverändert lassen. Weiterhin kann skipnode für besondere Fälle der Ablaufsteuerung eingesetzt werden, indem z.B. eine Variable im Kommentar eines Knotens definiert und ihr selektiv der Wert $_{qftest:skipnode} übergeben wird. Beachten Sie bitte, dass hierfür praktisch immer die Lazy Binding Syntax '$_' verwendet werden sollte, da ansonsten die Expansion im Parameter eines Prozeduraufruf Knotens zum Überspringen des gesamten Aufrufs führen würde. suite.dir Verzeichnis der aktuellen Suite suite.file Beim String-Zugriff der Dateiname der aktuellen Suite ohne Verzeichnis. Beim Objekt-Zugriff das File-Objekt der aktuellen Suite. suite.path Dateiname der aktuellen Suite mit Verzeichnis suite.name Der Name der aktuellen Testsuite. testCase.name Der Name des aktuellen Testfalls, leer falls im Moment kein Testfall ausgeführt wird. testCase.id Die QF‑Test ID des aktuellen Testfalls, leer falls im Moment kein Testfall ausgeführt wird. testCase.qName Der qualifizierte Name des aktuellen Testfalls, inklusive der Namen seiner Testfallsatz Parentknoten. Leer falls im Moment kein Testfall ausgeführt wird. testCase.reportName Der expandierte Report-Name des aktuellen Testfalls, leer falls im Moment kein Testfall ausgeführt wird. testCase.splitLogName Der qualifizierte Name des aktuellen Testfalls als Dateiname, inklusive der Namen seiner Testfallsatz Parentknoten als Verzeichnisse. Leer falls im Moment kein Testfall ausgeführt wird. testSet.name Der Name des aktuellen Testfallsatzes, leer falls im Moment kein Testfallsatz ausgeführt wird. testSet.id Die QF‑Test ID des aktuellen Testfallsatzes, leer falls im Moment kein Testfallsatz ausgeführt wird. testSet.qName Der qualifizierte Name des aktuellen Testfallsatzes, inklusive der Namen seiner Testfallsatz Parentknoten. Leer falls im Moment kein Testfallsatz ausgeführt wird. testSet.reportName Der expandierte Report-Name des aktuellen Testfallsatzes, leer falls im Moment kein Testfallsatz ausgeführt wird. testSet.splitLogName Der qualifizierte Name des aktuellen Testfallsatzes als Dateiname, inklusive der Namen seiner Testfallsatz Parentknoten als Verzeichnisse. Leer falls im Moment kein Testfallsatz ausgeführt wird. testStep.name Der Name des aktuellen Testschritts (inkl. @teststep doctag), leer falls im Moment kein Testschritt ausgeführt wird. testStep.qName Der qualifizierte Reportname des aktuellen Testschritts (inkl. @teststep doctag), inklusive der Reportnamen seiner Testschritt Parentknoten aber ohne Testfall und Testfallsatz Parentknoten. Leer falls im Moment kein Testschritt ausgeführt wird. testStep.reportName Der expandierte Report-Name des aktuellen Testschritts (inkl. @teststep doctag), leer falls im Moment kein Testschritt ausgeführt wird. thread Der Index des aktuellen Threads. Immer 0, es sei denn QF‑Test wird mit dem Kommandozeilenargument -threads <Anzahl> gestartet. threads Die Anzahl der parallelen Threads. Immer 1, es sei denn QF‑Test wird mit dem Kommandozeilenargument -threads <Anzahl> gestartet. version QF‑Test Version version.build QF‑Test Buildnummer name Der Name der QF‑Test Edition windows \"true\" unter Windows, andernfalls \"false\" Tabelle 6.1: Definitionen in der Gruppe qftest","hash":"table_6.1","h1":"Spezielle Gruppen"},"247":{"id":247,"content":"Immediate und Lazy Binding Es gibt einen sehr subtilen Aspekt bei der Verwendung von QF‑Test Variablen auf den wir noch genauer eingehen müssen: Wenn ein Satz von Variablendefinitionen auf einen der beiden Stapel gelegt wird gibt es zwei Möglichkeiten zur Behandlung von Referenzen auf Variablen im Wert einer Definition. Hat z.B. die Variable namens 'x' den Wert '$(y)', kann dieser Wert wortwörtlich gespeichert werden, so dass der Wert von '$(y)' erst zu einem späteren Zeitpunkt ermittelt wird, wenn irgendwo '$(x)' referenziert wird. Alternativ kann der Wert von '$(y)' schon beim Binden der Variablen 'x' ermittelt und als Wert von x abgelegt werden. Der erste Ansatz wird als \"Lazy Binding\" oder \"Late Binding\" bezeichnet, der zweite als \"Immediate Binding\". Der Unterschied zwischen beiden ist natürlich der Zeitpunkt der Expansion und damit der Kontext in dem eine Variable expandiert wird. In den allermeisten Fällen ist das Ergebnis das gleiche, aber es gibt Situationen in denen es von großer Bedeutung ist, Lazy oder Immediate Binding zu verwenden. Betrachten wir die folgenden zwei Beispiele: Eine Testsuite-Bibliothek stellt eine Prozedur zum Start des SUT mit verschiedenen JDK Versionen bereit. Die Variable 'jdk' wird als Parameter an diese Prozedur übergeben. Zur einfacheren Nutzung definiert der Autor der Bibliothek weitere hilfreiche Variablen auf Testsuite-Ebene, z.B. 'javabin' für das ausführbare Java-Programm mit dem Wert '/opt/java/$(jdk)/bin/java'. Zu dem Zeitpunkt, zu dem 'javabin' in den Testsuite Variablen gebunden wird, könnte 'jdk' noch undefiniert sein, so dass Immediate Binding zu einem Fehler führen würde. Doch selbst wenn 'jdk' mit einem Standardwert belegt ist hat Immediate Binding nicht den gewünschten Effekt, da sich der Wert von 'javabin' durch Übergabe eines anderen Wertes für 'jdk' an die Prozedur nicht mehr ändert. Lazy Binding ist hier also die Methode der Wahl. Betrachten wir eine andere Bibliothek mit einer Prozedur zum Kopieren einer Datei. Die zwei Parameter namens 'source' und 'dest' legen die Ausgangsdatei und das Zielverzeichnis fest. Der Aufrufer der Prozedur möchte die Datei 'data.csv' aus dem Verzeichnis seiner Testsuite an einen anderen Ort kopieren. Die nahe liegende Idee ist, für den Parameter 'source' den Wert '${qftest:suite.dir}/data.csv' an die Prozedur zu übergeben. Mit Immediate Binding liefert '${qftest:suite.dir}' in der Tat das Verzeichnis der aufrufenden Suite. Wird allerdings Lazy Binding verwendet, findet die Expansion erst innerhalb der Prozedur statt, so dass '${qftest:suite.dir}' das Verzeichnis der Bibliotheks-Suite liefert, was im Allgemeinen nicht den gewünschten Effekt hat. In QF‑Test Versionen bis einschließlich 2.2 wurde ausschließlich Lazy Binding unterstützt. Wie die obigen Beispiele zeigen, sind aber beide Varianten sinnvoll und notwendig. Immediate Binding ist aber intuitiver und leichter nachzuvollziehen und daher inzwischen die Standard-Methode (dies kann aber mittels der Option Werte von Variablen beim Binden sofort expandieren geändert werden). Die Option Lazy Binding verwenden falls sofortiges Expandieren scheitert ergänzt diese und ermöglicht eine einfache Migration von älteren Testsuiten zum Gebrauch von Immediate Binding. Die Warnungen, die in diesem Zusammenhang ausgegeben werden, helfen Ihnen, die wenigen Stellen zu lokalisieren, an denen Sie wie unten beschrieben explizit Lazy Binding verwenden sollten. Bis auf die äußerst seltenen Fälle, in denen Lazy Binding benötigt wird, Immediate Binding aber auch funktioniert, so dass kein Rückgriff auf Lazy Binding gemacht wird, sollten alle Tests ohne Änderungen lauffähig sein. In den wenigen Fällen, in denen es einen Unterschied macht, ob eine Variable mittels Immediate oder Lazy Binding definiert wird, kann dies unabhängig von der Voreinstellung durch eine alternative Variablen-Syntax erzwungen werden. Für Immediate Binding verwenden Sie '$!' anstatt nur '$', Lazy Binding erhalten Sie mittels '$_'. Um z.B. auf Testsuite-Ebene eine Variable zu definieren, deren Wert eine Datei im Verzeichnis dieser Suite ist, verwenden Sie '$!{qftest:suite.dir}/somefile'. Wenn Sie wie in obigem 'jdk' Beispiel Lazy Binding benötigen, verwenden Sie '$_(jdk)'. Mit Lazy Binding war es egal, in welcher Reihenfolge Variablen oder Parameter in einem Knoten oder Datentreiber definiert waren, da während des Bindens keine Expansion stattfand. Bei Immediate Binding werden Variablen von oben nach unten, bzw. bei Datentreibern von links nach rechts expandiert. Das bedeutet, dass die Definition von x=1 und y=$(x) funktioniert und y den Wert 1 erhält, wenn x zuerst definiert wird. Kommt hingegen die Definition von y zuerst, führt dies zu einem Fehler oder dem oben beschriebenen Rückfall auf Lazy Binding.","hash":"usec_immediatebindings","h1":"Immediate und Lazy Binding"},"248":{"id":248,"content":"Pro Handbuch","hash":"","h0":"Problemanalyse und Debugging | QF‑Test Handbuch"},"249":{"id":249,"content":"Pro Handbuch","hash":"home-link","h0":"Problemanalyse und Debugging | QF‑Test Handbuch"},"250":{"id":250,"content":"Problemanalyse und Debugging Da der eigentliche Zweck der Testautomatisierung darin besteht, Probleme im SUT aufzudecken, ist davon auszugehen dass Tests hin und wieder fehlschlagen. Nachdem ein Testlauf beendet ist, erscheint in der Statuszeile des Hauptfensters von QF‑Test eine Meldung mit dem Ergebnis. Im Idealfall lautet diese \"Keine Fehler\". Sind Probleme aufgetreten, wird die Zahl der Warnungen, Fehler und Exceptions angezeigt und gegebenenfalls zusätzlich ein Dialogfenster geöffnet. In diesem Fall ist es Ihre Aufgabe herauszufinden, was schiefgelaufen ist. Manchmal ist die Ursache eines Problems offensichtlich, in den meisten Fällen jedoch nicht. Am wichtigsten ist es in so einem Fall zu klären, ob der Test auf Grund eines Fehlers im SUT fehlgeschlagen ist, oder ob sich das SUT korrekt verhalten hat aber die Testlogik einen Fehler aufweist. Das Dilemma besteht darin, dass ein mögliches Problem im SUT nicht übersehen werden darf und so früh wie möglich gemeldet werden sollte. Andererseits verschwendet ein unberechtigter Fehlerreport Zeit und zieht eventuell den Unmut der Entwicklungsabteilung nach sich. Daher muss jedes Problem genau analysiert werden und jeder vermutete Bug im SUT sollte idealerweise reproduzierbar sein bevor er gemeldet wird. Bei dieser wichtigen Aufgabe bietet QF‑Test in zweierlei Hinsicht Unterstützung. Für jeden Testlauf wird ein detailliertes Protokoll erstellt, welches alle relevanten Informationen für eine Post-mortem Analyse enthält, inklusive Bildschirmfotos von dem Zeitpunkt, an dem ein Fehler aufgetreten ist. Der integrierte Test Debugger unterstützt Sie dagegen bei der Analyse des Kontroll- und Informationsflusses zur Laufzeit eines Tests. Das Video 'Fehleranalyse' zeigt ein kurzes Beispiel zur Vorgehensweise bei der Fehleranalyse.","hash":"usec_debugging","h0":"Problemanalyse und Debugging"},"251":{"id":251,"content":"Das Protokoll Beim Abspielen eines Tests erstellt QF‑Test ein Protokoll, in dem jede einzelne Aktion notiert wird. Die Protokolle der zuletzt ausgeführten Tests sind über das »Wiedergabe« Menü zugänglich. Das aktuelle Protokoll kann auch mittels Strg⁠+⁠L oder dem entsprechenden Button in der Toolbar geöffnet werden. \"Protokoll-Optionen\" gibt eine Übersicht über Optionen, die die Erstellung von Protokollen beeinflussen. Die Struktur dieses Protokolls ist der einer Testsuite sehr ähnlich, mit einem Unterschied: Knoten werden bei ihrer Ausführung in das Protokoll aufgenommen. Wird ein Knoten mehrfach ausgeführt, was z.B. bei Vorbereitung und Aufräumen Knoten häufig der Fall ist, taucht er auch mehrfach im Protokoll auf. Folgende Abbildung zeigt eine typische Situation:","hash":"usec_runlog","h1":"Das Protokoll"},"252":{"id":252,"content":"Testsuite Protokoll Abbildung 7.1: Ein einfacher Test und sein Protokoll Das Protokoll ist das entscheidende Hilfsmittel, wenn es herauszufinden gilt, was bei einem Testlauf fehlgeschlagen ist, wo es passiert ist und - im besten Fall - auch warum es passiert ist. Daher liegt das Gewicht bei einem Protokoll bei der Vollständigkeit der Information. Darunter leidet natürlich die Lesbarkeit und die Übersicht. Beides ist Aufgabe von Reports, deren Erstellung in \"Reports und Testdokumentation\" beschrieben wird. Neben den Knoten, die aus der Testsuite übernommen wurden, enthält ein Protokoll insbesondere Fehlerinformationen, optionale Anmerkungen, verschiedene Arten von Meldungen sowie Informationen über Variablenexpansion und das Laufzeitverhalten. Da die gesammelten Informationen über einen längeren Testlauf gewaltige Mengen an Arbeitsspeicher verbrauchen können, verfügt QF‑Test über mehrere Möglichkeiten, damit umzugehen. Die beste davon, gleichzeitig die Standardeinstellung, sind geteilte Protokolle. Diese werden in \"Geteilte Protokolle\" näher erläutert. Die dabei entstehenden *.qzp Dateien im ZIP Format reduzieren nicht nur den Platz auf der Festplatte. Teil der Protokolle können bereits bei der Ausführung ausgelagert und der dafür benötigte Arbeitsspeicher wieder freigegeben werden. Gleiches gilt bei der Verarbeitung von Protokollen, z.B. zur Erstellung von Reports. Die ältere Option Kompakte Protokolle erstellen sowie die alternativen Dateiformate *.qrz und *.qrl bieten zusätzliche Flexibilität, werden aber primär aus Kompatibilitätsgründen erhalten.","hash":"figure_7.1","h1":"Das Protokoll"},"253":{"id":253,"content":"Fehlerzustände Es gibt drei Arten von Fehlerzuständen, die sich in ihrer Schwere unterscheiden: Warnungen Warnungen weisen auf Probleme hin, die normalerweise nicht ernst sind, aber in Zukunft zu schwereren Problemen führen könnten, so dass es sich lohnen kann, einen Blick darauf zu werfen. So gibt QF‑Test z.B. Warnungen aus, wenn eine Komponente bei der Wiedererkennung nur knapp und mit signifikanten Abweichungen gefunden werden konnte. Fehler Ein Fehler ist als ernstzunehmendes Problem anzusehen, dessen Ursache geklärt werden muss. Er weist darauf hin, dass das SUT gewisse Anforderungen nicht erfüllt. Die häufigste Art von Fehlern sind Abweichungen in Check Text Knoten. Exceptions Exceptions sind die schwersten Fehler. Sie werden in Situationen geworfen, in denen QF‑Test einen Testlauf nicht sinnvoll fortsetzen kann. Die meisten Exceptions deuten auf einen Fehler in der Testlogik hin. Eine Exception kann aber genauso gut durch einen Fehler im SUT ausgelöst werden. So wird z.B. eine ComponentNotFoundException geworfen, wenn im SUT keine passende Komponente für einen Event gefunden wurde. Eine Liste aller möglichen Exceptions finden Sie in \"Exceptions\". Jeder Knoten eines Protokolls hat einen von vier Fehlerzuständen: Normal, Warnung, Fehler oder Exception. Dieser Zustand wird durch einen Rahmen um das Icon des Knotens dargestellt, dessen Farbe Orange für Warnung, rot für Fehler und fett rot für Exception ist.","hash":"sec_fehlerzustande","h2":"Fehlerzustände"},"254":{"id":254,"content":"Abbildung 7.2: Fehlerzustände im Protokoll Der Ausschnitt aus einem Protokoll in obiger Abbildung illustriert, wie Fehlerzustände von unten nach oben propagieren. Der Exception Zustand hat mehr Gewicht als der Fehler Zustand, der wiederum die Warnung überdeckt. Die schwerste Art von Fehler, die bis ganz nach oben im Baum propagiert, bestimmt das Endergebnis des Testlaufs und damit auch den Rückgabewert von QF‑Test, wenn es im Batchmodus gestartet wurde (vgl. \"Rückgabewerte von QF‑Test\"). Wenn nötig kann die Propagation von Fehlern auch (auf Sequenz Ebene) begrenzt werden, z.B. für einen bereits bekannten Fehler, der keinen Einfluss auf das Gesamtresultat haben soll. Diese Einschränkung geschieht für alle Arten von Sequenz Knoten mit Hilfe des Attributs Maximaler Fehler. Exceptions können mit Hilfe der Try und Catch Knoten abgefangen werden. Das Attribut Maximaler Fehler des Catch Knotens legt dabei fest, welche Art von Fehlerzustand an Stelle der Exception treten soll.","hash":"figure_7.2","h4":"Abbildung 7.2: Fehlerzustände im Protokoll"},"255":{"id":255,"content":"Navigation im Protokoll Die grundlegenden Bearbeitungsmöglichkeiten im Protokoll sind analog zur Testsuite, mit dem Unterschied, dass die Attribute der Knoten, die aus der Testsuite übernommen wurden, nicht geändert und dass keine Knoten entfernt oder eingefügt werden können. Knoten können aber mit einer Bemerkung versehen werden, z.B. um den Grund für einen Fehler zu dokumentieren. Die erste Frage beim Blick auf ein Protokoll ist üblicherweise: \"Was ist passiert?\" Der Button, bzw. die Funktion »Bearbeiten«-»Nächsten Fehler finden«, kurz Strg⁠+⁠N, bewegt die Selektion an die nächste Stelle, an der ein Problem tatsächlich aufgetreten ist. Analog sucht bzw. »Bearbeiten«-»Vorherigen Fehler finden« (Strg⁠+⁠P) rückwärts. Die Option Unterdrückte Fehler überspringen legt fest ob nach Fehlern gesucht werden soll, die nicht bis nach oben propagiert wurden. Der Menüeintrag »Bearbeiten«-»Unterdrückte Fehler überspringen« ist eine Abkürzung zum schnellen Umschalten der letzteren Option. Die nächste Frage könnte lauten: \"Wo ist das passiert?\" Obwohl ein Protokoll einer Testsuite in vieler Hinsicht ähnlich ist, ist der Zusammenhang nicht immer offensichtlich, vor allem, wenn Aufrufe tief verschachtelt sind. Die Funktion »Bearbeiten«-»Knoten in Testsuite finden« (Strg⁠+⁠T) bringt Sie exakt zu dem Knoten in der Testsuite, der dem selektierten Knoten im Protokoll entspricht. Voraussetzung hierfür ist, dass die Testsuite auffindbar ist und nicht in einer Form geändert wurde, die das verhindert. Wenn das Protokoll aus einer Datei geladen wurde, befindet sich die Testsuite eventuell nicht an der selben Stelle wie bei der Ausführung des Tests. Kann die Suite nicht lokalisiert werden, öffnet sich ein Dialog, in dem Sie selbst eine Datei für die Testsuite auswählen können. Wenn Sie dabei die falsche Testsuite angeben oder wenn automatisch eine falsche Version der Testsuite gefunden wurde, kann es sein, dass Sie bei einem völlig anderen Knoten landen. In diesem Fall können Sie mittels »Bearbeiten«-»Zugehörige Testsuite lokalisieren« explizit eine andere Testsuite auswählen. Diese Zuordnung können Sie über die Protokolloptionen auch voreinstellen (siehe Verweise zwischen Verzeichnissen mit Testsuiten).","hash":"usec_lognavigation","h2":"Navigation im Protokoll"},"256":{"id":256,"content":"Laufzeitverhalten QF‑Test protokolliert für jede Ausführung eines Knotens die Startzeit und zwei Formen der Laufzeit: 'Echtzeit' ist die tatsächlich zwischen Betreten und Verlassen des Knotens vergangene Zeit. Sie beinhaltet explizite Verzögerungen durch das Attribut 'Verzögerung vorher/nachher', Unterbrechungen durch den Benutzer beim Debuggen von Tests oder anderen Overhead, wie die Aufnahme von Bildschirmabbildern. Die tatsächlich für Tests aufgewendete Zeit, die im Attribut 'Dauer' aufsummiert wird, ist daher ein besserer Indikator für die Performance des SUT. Für ein besseres Verständnis des Laufzeitverhaltens eines Tests kann die Anzeige der relativen Dauer über den Toolbar-Button , das Menü »Ansicht«-»Anzeige für relative Dauer einblenden« oder die Option Relative Dauer anzeigen aktiviert werden. Für jeden Knoten werden farbige Balken dargestellt, deren Länge sich nach dem prozentualen Anteil der Zeit richtet, die für diesen Knoten relativ zur Zeit seines Parent-Knotens aufgewendet wurde. Damit lassen sich Performance-Engpässe leicht auffinden, indem man jeweils die Knoten mit den längsten Balken betritt:","hash":"usec_runtimebehavior","h2":"Laufzeitverhalten"},"257":{"id":257,"content":"Abbildung 7.3: Anzeige der relativen Dauer im Protokoll Die Option Anzeigeform für relative Dauer, deren Werte auch direkt über das Menü »Ansicht«-»Anzeigeform für relative Dauer« zugänglich sind, legt fest, ob sich die Anzeige auf die Dauer, die Echtzeit oder beides bezieht. Letzteres ist besonders effektiv, bedarf aber einer gewissen Eingewöhnung.","hash":"figure_7.3","h4":"Abbildung 7.3: Anzeige der relativen Dauer im Protokoll"},"258":{"id":258,"content":"Rückgabewerte anzeigen Ist die Option Rückgabewerte von Prozeduren anzeigen gesetzt (im Protokoll auch direkt über das »Ansicht« Menü erreichbar), werden Rückgabewerte von Prozedur Knoten im Baum neben dem entsprechenden Prozeduraufruf Knoten angezeigt.","hash":"usec_procret","h2":"Rückgabewerte anzeigen"},"259":{"id":259,"content":"Werte von fehlgeschlagenen Checks als gültig akzeptieren Ein wichtiges Feature von QF‑Test ist die Fähigkeit, sehr einfach den aktuellen Wert eines fehlgeschlagenen Check Knotens als gültigen Wert zu übernehmen. Wenn QF‑Test einen gescheiterten Check in das Protokoll schreibt, speichert es dort auch den kompletten Status der Zielkomponente des Check Knotens im SUT mit. Dies ist sehr viel hilfreicher als eine einfache Fehlermeldung, die zum Beispiel nur mitteilt, dass eine Tabellenspalte 10 statt der erwarteten 9 Einträge enthält, aber nicht was diese Werte sind. Wenn Sie bei der Analyse eines fehlgeschlagenen Checks feststellen, dass der Wert im SUT korrekt, der in der Testsuite gespeicherte Wert dagegen falsch war, können Sie einfach Strg⁠+⁠U drücken oder den Eintrag »Check-Knoten mit erhaltenen Daten aktualisieren« im Kontextmenü auswählen, um den Wert aus dem Protokoll in den zugehörigen Check Knoten in der Testsuite zu übernehmen. Warnung: QF‑Test berücksichtigt hierbei im Moment keine regulären Ausdrücke in Check Text oder Check Elemente Knoten, diese werden einfach überschrieben.","hash":"usec_acceptcheck","h2":"Werte von fehlgeschlagenen Checks als gültig akzeptieren"},"260":{"id":260,"content":"Geteilte Protokolle Protokolle für lang laufende Tests können sehr groß werden und enorm viel Speicher verbrauchen, insbesondere wenn viele Screenshots enthalten sind. Kompakte Protokolle können helfen, aber nicht genug um Tests über mehrere Tage zu ermöglichen, ohne das Protokoll komplett auszuschalten. Der beste Weg, dieses Problem zu umgehen, sind geteilte Protokolle. Bei geteilten Protokollen entfernt QF‑Test, immer wenn ein gewisser Teil des Tests abgeschlossen ist, das zugehörige Protokolle, speichert es als separate Datei und ersetzt es durch einen einzelnen Knoten, der einen Verweis auf das abgeteilte Protokoll enthält. Die abgeteilten Protokolle sind eigenständig und können unabhängig vom Hauptprotokoll betrachtet und archiviert werden. Normalerweise werden sie aber indirekt über das Hauptprotokoll angesprochen. Beim Navigieren durch das Hauptprotokoll, oder beim Erstellen von Reports, lädt QF‑Test die benötigten abgeteilten Protokolle automatisch nach und entfernt sie wieder aus dem Speicher, wenn sie nicht mehr benötigt werden. Dadurch können auch extrem große Protokolle betrachtet werden, ohne sonderlich viel Speicher zu verbrauchen. Operationen wie Suche oder Reportgenerierung, die das gesamte Protokoll traversieren müssen, dauern natürlich etwas länger. Das Springen von Fehler zu Fehler geht aber nach wie vor schnell und das Laden des Hauptprotokolls wird drastisch verkürzt. Es gibt zwei Wege, geteilte Protokolle zu speichern: Alles zusammen in einer einzelnen ZIP-Datei mit der Endung .qzp oder mit den abgeteilten Protokollen in einem eigenen Verzeichnis. Letzteres wird nach dem Hauptprotokoll benannt, wobei die Endung .qrl bzw. .qrz entfernt und stattdessen _logs angehängt wird. Innerhalb einer .qzp ZIP-Datei wird die Struktur identisch aufgebaut, so dass es möglich ist, diese manuell ein- oder auszupacken, ohne die internen Verweise im Protokoll zu zerstören. Diese Kompatibilität ist der Grund dafür, dass in der Standardeinstellung die abgeteilten Protokolle innerhalb einer ZIP-Datei komprimiert mit der Endung .qrz abgelegt werden. Dies ist zwar etwas weniger effizient als unkomprimierte .qrl Dateien, ermöglicht es dafür aber, die ZIP-Datei auszupacken, ohne dass dabei die Gesamtgröße explodiert. Um geteilte Protokolle zu nutzen können Sie explizit die Punkte definieren, an denen das Protokoll aufgeteilt wird. Dies geschieht über das Attribut Name für separates Protokoll eines Datentreiber, Testfall, Testfallsatz, Testaufruf oder Testschritt Knotens. Bei Verwendung in einem Datentreiber werden die Protokolle für jede Iteration abgeteilt, andernfalls das Protokoll des jeweiligen Knotens, der das Attribut definiert. Alternativ werden Protokolle automatisch ab einer gewissen Größe abgeteilt. Diese Funktionalität ist über die Option Minimale Größe für automatisches Teilen (kB) konfigurierbar. Bei der Verwendung von geteilten Protokollen empfiehlt es sich, die Option Kompakte Protokolle erstellen auszuschalten, so dass alle Details im Protokoll erhalten bleiben. Dies braucht zwar etwas mehr Plattenplatz, ist aber sehr hilfreich bei der Fehlersuche. Geteilte Protokolle sind außerdem sehr praktisch, um den Fortschritt eines Tests im Batchmodus zu verfolgen. In diesem Zusammenhang ist es besonders hilfreich, dass für die Dateinamen der abgeteilten Protokolle die gleichen Platzhalter wie für die Angabe des Protokollnamens auf der Kommandozeile verwendet werden können. Insbesondere kann so der Fehlerstatus des abgeteilten Protokolls Teil seines Dateinamens sein. Detaillierte Informationen finden Sie in der Dokumentation des Attributs Name für separates Protokoll.","hash":"usec_splitlogs","h2":"Geteilte Protokolle"},"261":{"id":261,"content":"Protokoll-Optionen Die Erstellung und der Inhalt von Protokollen werden durch diverse Optionen gesteuert. Unter anderem kann eingestellt werden, ob kompakte oder detaillierte Protokolle geschrieben, ob der ganze Bildschirm und/oder die Applikationsfenster protokolliert oder ob Protokolle ganz unterdrückt werden. Alle Optionen sind detailliert in \"Protokoll\" beschrieben.","hash":"usec_logoptions","h2":"Protokoll-Optionen"},"262":{"id":262,"content":"Eine Testsuite aus dem Protokoll erstellen Falls unterschiedliche Beteiligte in der Testentwicklung involviert sind, mag es in manchen Fällen von Nutzen sein, dass Sie aus einem Protokoll eine lauffähige Testsuite erstellen, um Testläufe schnell nachstellen zu können. Sie können aus einem Protokoll eine Testsuite erstellen, wenn Sie im Protokoll auf einen beliebigen Knoten mit der rechten Maustaste klicken und »Testsuite aus Protokoll erstellen« aus dem Kontextmenü auswählen. Nun wird eine neue Datei erstellt, welche unter Extrasequenzen alle ausgeführten Schritte sowie die Fenster und Komponenten beinhaltet. Es werden nur die ausgeführten und verwendeten Knoten in die neue Testsuite übernommen. Variablen werden sofort expandiert und nur der entsprechende Wert wird in der neu erstellten Testsuite abgelegt. Gliederungsknoten wie Prozeduren oder Kontrollstrukturen werden nicht erstellt. Damit die Generierung funktioniert, müssen vor der Ausführung des Tests allerdings folgende Optionen (unter Protokoll -> Inhalt) gesetzt sein: Kompakte Protokolle erstellen muss ausgeschaltet sein. Variablenexpansion protokollieren muss eingeschaltet sein. Parentknoten von Komponenten protokollieren muss eingeschaltet sein. Falls Sie Zugriff auf alle vorhandenen Testsuiten haben, so können Sie die Informationen aus diesen Suiten nutzen und im Kontextmenü den Punkt »Testsuite mit vorhandener Struktur erstellen« auswählen. Der Unterschied zum obigen Verfahren ist, dass die Informationen über die Komponenten aus den entsprechenden Testsuiten anstatt aus dem Protokoll geholt werden. Deshalb ist es für diesen Modus auch nicht notwendig die Option Parentknoten von Komponenten protokollieren eingeschaltet zu haben.","hash":"usec_logcreatetestsuite","h2":"Eine Testsuite aus dem Protokoll erstellen"},"263":{"id":263,"content":"Protokolle zusammenführen Während der Testentwicklung könnten Sie in die Situation kommen, dass Sie einen Testreport erzeugt haben, der den Abschluss eines Testzyklus darstellen soll. Allerdings kann es immer wieder dazu kommen, dass einzelne Testfälle aufgrund subtiler Probleme nachgetestet werden müssen und Sie die Resultate der Nachtests eigentlich im Report anzeigen wollen. Für ein solches Szenario können Sie mehrere Protokolle zusammenführen und die ursprünglichen fehlerhaften Testläufe durch die Resultate des Nachtests ersetzen wollen. Dies erfolgt mittels Aufruf von der Kommandozeile. Ein typischer Kommandozeilenaufruf hierfür sieht wie folgt aus: qftest -batch -mergelogs -mergelogs.mode=replace -mergelogs.masterlog full_log.qzp -mergelogs.resultlog newresult_log.qzp rerun.qzp Beispiel 7.1: Beispielaufruf um Protokolle zusammenzuführen Der obige Aufruf liest die Resultate des Nachtlaufes aus dem Protokoll rerun.qzp, sucht nach dem Testfall im eigentlichen Protokoll full_log.qzp und speichert das angepasste Ergebnis im Protokoll newresult_log.qzp. Sie können hier auch den Parameter mergelogs.mode auf den Wert merge setzen. Dieser Modus ersetzt die bestehenden Testfälle nicht, sondern fügt die neuen Testfälle in das Hauptprotokoll ein. Ein zweiter Anwendungsfall besteht darin, dass Sie Protokolle aus mehreren Testläufen in ein Protokoll zusammenführen wollen, um auch nur einen Testreport am Ende erzeugt zu bekommen. Dies kann auch mittels Kommandozeilenaufruf bewerkstelligt werden und sieht wie folgt aus: qftest -batch -mergelogs -mergelogs.mode=append -mergelogs.resultlog newresult_log.qzp run1.qzp run2.qzp Beispiel 7.2: Beispielaufruf um Protokolle in eines zusammenzuführen Dieser Aufruf liest die Protokolle run1.qzp und run2.qzp und führt diese im neuen Protokoll newresult_log.qzp zusammen. In diesem Modus ist der Parameter mergelogs.masterlog optional. Wenn der Parameter gesetzt wird, wird das entsprechende Protokoll als Wurzel für das Ergebnisprotokoll benutzt.","hash":"usec_mergerunlogs","h2":"Protokolle zusammenführen"},"264":{"id":264,"content":"Der Debugger Wie bei jeder komplexen Entwicklung wird es ab einem gewissen Punkt nötig sein, Probleme in einer Testsuite zu debuggen, die nicht mehr einfach durch Analysieren der Elemente und der Struktur einer Testsuite zu lösen sind. Zu diesem Zweck verfügt QF‑Test über einen intuitiven Debugger. Sollten Sie bereits mit dem Debuggen von Programmen in Java oder anderen Programmiersprachen vertraut sein, werden Sie sich mit seiner Funktionsweise und Bedienung schnell zurechtfinden.","hash":"usec_debugger","h1":"Der Debugger"},"265":{"id":265,"content":"Aktivieren des Debuggers Der QF‑Test Debugger kann direkt aufgerufen werden, indem ein oder mehrere Knoten selektiert und der \"Einzelschritt ausführen\" oder der \"Gesamten Knoten ausführen\" Button gedrückt werden. Die zugehörigen Tastaturkürzel und Menüeinträge sind F7 und F8 bzw. »Debugger«-»Einzelschritt ausführen« und »Debugger«-»Gesamten Knoten ausführen« Diese Operationen werden in \"Debugger Kommandos\" näher erläutert. Wenn Sie einen Test normal über den \"Wiedergabe\" Button starten (siehe \"Abspielen von Tests\"), wird der Debugger nur aktiv, wenn eine der folgenden Bedingungen eintritt: Ein benutzerdefinierter Breakpoint wird angetroffen. Näheres zu Breakpoints finden Sie in \"Breakpoints setzen und löschen\". Der Testlauf wird manuell durch Drücken des \"Pause\" Buttons, von F9 oder über den »Wiedergabe«-»Pause« Menüeintrag unterbrochen. Eine Exception wird geworfen oder ein Fehler oder eine Warnung tritt auf und die entsprechende Option zum automatischen Unterbrechen ist gesetzt (vgl. Option Automatisch unterbrechen). Wenn der Debugger die Ausführung des Tests anhält, wird der Knoten, der als nächster ausgeführt wird, mit einem farbigen Rahmen um das Icon markiert. Die Farbe des Rahmens signalisiert den Grund der Unterbrechung. Nach manuellem Eingreifen, einem Breakpoint oder bei schrittweiser Ausführung ist der Rahmen schwarz. Orange, rot und fett rot signalisieren einen Stopp nach einer Warnung, einem Fehler oder einer Exception, entsprechend der Fehlermarkierung im Protokoll. Wird der Debugger aufgrund einer Warnung, eines Fehlers oder einer Exception betreten, wird die Ausführung auf den Beginn des fehlerhaften Knotens zurückgesetzt, so dass Sie die Möglichkeit haben, die Ursache zu beseitigen und den Knoten erneut auszuführen. Wenn das nicht gewollt oder nicht möglich ist, können Sie den Knoten einfach überspringen (vgl. \"Debugger Kommandos\"). In der Standardansicht (Workbench-Ansicht) kann der Debugger direkt vom normalen Testsuitefenster aus bedient werden. Informationen zum Öffnen des Debugger-Fensters in der Einzelfensteransicht finden Sie in Das separate Debugger-Fenster.","hash":"sec_aktivieren_des_debuggers","h2":"Aktivieren des Debuggers"},"266":{"id":266,"content":"Anzeige der aktuellen Variablenwerte Im Debug-Modus zeigt der untere Teil des Testsuite-Fensters eine Liste der Variablen mit ihren Werten für den aktuellen Ausführungsstand. Die Liste ist in einen Primärstapel (oberer Teil) und in einen Sekundärstapel darunter aufgeteilt. Variablen mit dem gleichen Namen können an beliebig viele der Knoten gebunden sein. Der tatsächlich von QF‑Test verwendete Wert ergibt sich durch die Reihenfolge der Knoten von oben nach unten. Das heißt, wenn Variablen mit dem gleichen Namen an mehrere Knoten gebunden wurde, wird der Wert derjenigen verwendet, deren Knoten sich am weitesten oben in der Liste befindet. Ein Klick auf einen der Knoten übernimmt die Variablendefinitionen eines Knotens in den rechten Teil des Fensters, wo sie bearbeitet, neue Variablen hinzugefügt oder bestehende Variablen gelöscht werden können. Diese Änderungen wirken sich sofort auf den aktuellen Testlauf aus, sind aber temporärer Natur, das heißt sie werden nicht in die Variablendefinitionen des zugehörigen Knotens übernommen. Der Variablenwert ist nach der Bearbeitung immer eine Zeichenkette. Mit einem Doppelklick auf den Knoten in der Variablenlist können Sie schnell zu dem Knoten in seiner Testsuite navigieren und dort den Wert permanent setzen. Die Werte der Variablen sind im Normalfall Zeichenketten. Falls dies nicht zutrifft, wird der Typ des Variablenwerts in runden Klammern vor dem tatsächlich Wert dargestellt. Falls Sie solche Werte in der Variablenliste bearbeiten, werden sie automatisch in Zeichenketten umgewandelt - erkennbar daran, dass der Typ nicht mehr angezeigt wird. Für den primären Stapel werden alle Knoten dargestellt, selbst wenn sie keine Variablen binden, für den sekundären Stapel nur solche, an die Variablen gebunden wurden. Über die Einstellung »Ansicht«-»Terminal«-»Baum dem Terminal vorziehen« können Sie steuern, ob die Variablendefinitionen über die ganze Fensterbreite gehen oder nur den rechten Teil unter der Detailanzeige einnehmen.","hash":"usec_debugger_variable_stack","h2":"Anzeige der aktuellen Variablenwerte"},"267":{"id":267,"content":"Debugger Kommandos Die meisten Debugger Kommandos entsprechen denen anderer Debugger. Einige Kommandos gehen dabei über die übliche Funktionalität hinaus. Das schrittweise Debuggen einer Testsuite wird durch folgende drei Operationen ermöglicht: Der \"Einzelschritt ausführen\" Button (F7, »Debugger«-»Einzelschritt ausführen«) führt den aktuellen Knoten aus und setzt die Ausführungsmarke auf den nächsten auszuführenden Knoten, egal wo sich dieser in der Baumstruktur befindet. Diese Funktion ist z.B. hilfreich, um eine Prozedur oder eine Sequenz zu debuggen. Der \"Gesamten Knoten ausführen\" Button (F8, »Debugger«-»Gesamten Knoten ausführen«) führt den aktuellen Knoten und alle seine Kindknoten aus und setzt die Ausführungsmarke anschließend auf den nächsten Knoten der selben Ebene. Hiermit können Sie eine Prozedur oder eine Sequenz als ganzes ausführen, ohne sich einzeln durch ihre Kindknoten zu arbeiten. Der \"Bis Knotenende ausführen\" Button (Strg⁠+⁠F7, »Debugger«-»Bis Knotenende ausführen«) führt den aktuellen Knoten und alle folgenden Knoten auf der selben Ebene aus (inklusive ihrer Kindknoten) und setzt dann die Ausführungsmarke auf den nächsten Knoten der nächsthöheren Ebene. Diese Operation erlaubt es z.B., beim Debuggen einer Prozedur oder einer Sequenz diese ohne weitere Unterbrechung bis zum Ende auszuführen. Die folgenden Funktionen erweitern den QF‑Test Debugger um die Möglichkeit, Knoten einfach zu überspringen, ohne sie auszuführen. Der \"Knoten überspringen\" Button (Shift⁠+⁠F9, »Debugger«-»Knoten überspringen«) springt ohne Ausführung über den aktuellen Knoten und verschiebt die Markierung auf den nächsten Knoten der selben Ebene. Der \"Aus Knoten herausspringen\" Button (Strg⁠+⁠F9, »Debugger«-»Aus Knoten herausspringen«) beendet sofort die Ausführung der aktuellen Prozedur oder Sequenz und springt zum nächsten Knoten der nächsthöheren Ebene. Noch mächtiger ist die Möglichkeit, den Test mit einem beliebigen anderen Knoten fortzusetzen, sogar in einer anderen Testsuite. Dabei werden so viele Informationen wie möglich im aktuellen Ausführungskontext erhalten, inklusive der gebundenen Variablen. Je näher der neue Zielknoten dem aktuellen Knoten ist, desto mehr Informationen können erhalten werden. Sie können den Test durch Drücken von Strg⁠+⁠, oder über den Menüeintrag »Wiedergabe«-»Ausführung hier fortsetzen« bzw. den entsprechenden Eintrag im Kontextmenü beim selektierten Knoten fortsetzen. Dabei wird nur der aktuelle Knoten gewechselt, die Ausführung läuft nicht automatisch wieder an, sondern kann durch Einzelschritte oder andere Aktionen gezielt fortgeführt werden. Folgende weitere Kommandos stehen zur Verfügung: Der \"Exception erneut werfen\" Button (»Debugger«-»Exception erneut werfen«) ist nur dann aktiv, wenn der Debugger aufgrund einer Exception aufgerufen wurde. Damit können Sie die Exception weiterreichen und so von der Testsuite behandeln lassen, als wenn der Debugger gar nicht erst eingegriffen hätte. Der \"Aktuellen Knoten finden\" Button (»Debugger«-»Aktuellen Knoten finden«) setzt die Selektion im Baum direkt auf den als nächstes auszuführenden Knoten. Dies ist eine nützliche Abkürzung, um nach einigem Herumwandern in der Testsuite zurück zur aktuellen Ausführung zu gelangen.","hash":"usec_dbgcommands","h2":"Debugger Kommandos"},"268":{"id":268,"content":"Breakpoints setzen und löschen Das Setzen eines Breakpoints für einen Knoten veranlasst den Debugger, einen Testlauf vor dem Betreten dieses Knotens anzuhalten. Breakpoints werden im Baum durch ein \"(B)\" vor dem Namen des Knotens gekennzeichnet. Breakpoints können mittels Strg⁠+⁠F8 oder dem Menüeintrag »Debugger«-»Breakpoint an/aus« individuell gesetzt oder gelöscht werden. Wenn Sie mit dem Debuggen fertig sind, können Sie eventuell übrig gebliebene Breakpoints mittels »Debugger«-»Alle Breakpoints löschen« entfernen. Dieses Kommando entfernt alle Breakpoints aus allen geöffneten Testsuiten. Breakpoints sind kurzlebig und werden daher nicht mit der Testsuite abgespeichert.","hash":"usec_dbgbreak","h2":"Breakpoints setzen und löschen"},"269":{"id":269,"content":"Das separate Debugger-Fenster Wenn Sie mit der Einzelfensteransicht arbeiten (Workbench-Ansicht aktivieren ist nicht gesetzt), muss der Debugger in einem eigenen Debugger-Fenster bedient werden. Dieses kann mittels »Debugger«-»Debugger-Fenster öffnen« nach Anhalten des Testlaufs geöffnet werden. Das Debugger-Fenster kann auch durch Setzen der Option Debugger-Fenster immer öffnen immer automatisch geöffnet werden, wenn der Debugger die Ausführung eines Tests unterbricht. Diese Option ist auch direkt über das Menü »Debugger«-»Optionen« zugänglich. Wenn Sie das Debugger-Fenster explizit öffnen oder schließen, wird diese Entscheidung für den Rest des Testlaufs respektiert und die Option so lange außer Kraft gesetzt. Das Debugger-Fenster ist den normalen Testsuitefenstern sehr ähnlich. Sie können Knoten selektieren und deren Attribute in der Detailansicht bearbeiten. Es können jedoch keine Knoten entfernt oder hinzugefügt werden und es stehen keine Dateioperationen und kein Rekorder oder andere komplexe Funktionen zur Verfügung. An diese gelangen Sie sehr einfach, wenn Sie mittels Strg⁠+⁠T aus dem Debugger-Fenster direkt zum selben Knoten im Fenster seiner Testsuite springen. Sie finden diese Funktion auch als »Knoten in Testsuite finden« im »Bearbeiten« Menü oder dem Kontextmenü.","hash":"usec_debuggerwindow","h2":"Das separate Debugger-Fenster"},"270":{"id":270,"content":"Pro Handbuch","hash":"","h0":"Aufbau und Organisation einer Testsuite | QF‑Test Handbuch"},"271":{"id":271,"content":"Pro Handbuch","hash":"home-link","h0":"Aufbau und Organisation einer Testsuite | QF‑Test Handbuch"},"272":{"id":272,"content":"Aufbau und Organisation einer Testsuite Zum Schreiben von aussagekräftigen und zuverlässigen Tests gehört mehr als nur das Aufnehmen und Wiedergeben von Sequenzen. Sie können eine Testsuite zwar innerhalb kurzer Zeit mit diversen Sequenzen anfüllen, werden aber über kurz oder lang den Überblick verlieren, wenn Sie nicht darauf achten, den Tests eine verständliche Struktur zu geben. Bevor Sie mit der Aufnahme von Sequenzen beginnen, die Sie anschließend mittels der nachfolgend beschriebenen Elemente zu Testfällen und Testsätzen zusammenstellen, ist es wichtig, dass Sie eine gute Vorstellung davon haben, was Sie eigentlich testen wollen. Sie die richtigen Dinge testen. Ihre Tests zuverlässig und wiederholbar sind. Die Tests einfach gewartet werden können. Die Ergebnisse Ihrer Tests aussagekräftig sind. Zur Strukturierung der Tests stellt QF‑Test diverse Elemente zur Verfügung. Dies sind zum einen die in \"Komponenten\" besprochenen Komponenten und zum anderen die in diesem Kapitel vorgestellten Testsätze, Testfälle, Testschritte und Sequenzen sowie Events, Checks etc.","hash":"usec_organization","h0":"Aufbau und Organisation einer Testsuite"},"273":{"id":273,"content":"Struktur der Testsuite","hash":"usec_testsuite_structure","h1":"Struktur der Testsuite"},"274":{"id":274,"content":"Abbildung 8.1: Struktur einer Testsuite QF‑Test bietet Strukturelemente auf unterschiedlichen Ebenen. Auf oberster Ebene gibt es die Testsuite, in der die Tests sowie Komponenten abgespeichert werden. Jede Testsuite wird in einer eigenen Datei abgespeichert. Zur erleichterten Handhabung einer größeren Anzahl von Testsuite Dateien können diese in Projekte zusammengefasst werden. Die Testsuite hat eine feste Struktur, beginnend mit dem Testbereich, der beliebig viele Testfallsatz Knoten enthalten kann, in die wiederum beliebig viele Testfall Knoten oder auch weitere Testfallsätze eingefügt werden können. Anschließend gibt es einen Bereich für Prozeduren. Als Strukturelement stehen hier Package Knoten zur Verfügung, die beliebig viele Prozedur oder weitere Package Knoten enthalten können. Der folgende Bereich Extrasequenzen bietet die Möglichkeit, im Rahmen der Testentwicklung beliebige Knoten abzuspeichern und auszutesten. Der letzte Knoten Fenster und Komponenten ist reserviert für die in den Tests benötigten Komponenten. Testfälle selbst können wiederum mit Hilfe von Testschritt und Sequenz Knoten gegliedert werden. Ein weiteres wichtiges Strukturelement sind Vorbereitung und Aufräumen Knoten. Diese dienen der Erstellung von Vor- und Nachbedingungen und können ihrerseits in Abhängigkeit Knoten zusammengefasst werden. Abhängigkeit Knoten bieten darüber hinaus auch Strukturen für die Behandlung von Fehlern und unvorhergesehenen Ereignissen. Die eigentliche Testausführung geschieht über Events wie zum Beispiel Mausklicks, Checks, Abfragen, Knoten zur Ablaufsteuerung und solche, die Prozesse steuern sowie weitere, in Verschiedenes beschriebene Knoten. Die Verknüpfung der Tests mit den Testdaten erfolgt über Datentreiber.","hash":"figure_8.1","h4":"Abbildung 8.1: Struktur einer Testsuite"},"275":{"id":275,"content":"Testfallsatz und Testfall Knoten","hash":"usec_testcase","h1":"Testfallsatz und Testfall Knoten"},"276":{"id":276,"content":"Verwaltung von Tests mit Hilfe von Testfallsatz und Testfall Knoten Mit den Knoten Testfallsatz und Testfall bietet QF‑Test eine einfache, pragmatische Form der Testfallverwaltung direkt innerhalb von QF‑Test. Sie sind die wichtigsten Bausteine zur Strukturierung einer Testsuite. Sie bieten die Möglichkeit mittels Abhängigkeit Knoten die Testfälle so zu erstellen, dass sie völlig unabhängig voneinander sind. Notwendige Aufräumarbeiten werden bei entsprechend aufgebauten Abhängigkeiten ebenso automatisch erledigt wie die Vorbereitungen für den aktuellen Test sowie die Fehlerbehandlung. Auch hinsichtlich der Ergebnisdokumentation kommt den Testfall Knoten eine zentrale Rolle zu. In den Reports ist der Testfall das Strukturelement, auf dem die Fehlerstatistik und auch die Fehlerdokumentation basiert.","hash":"usec_testcase_management","h2":"Verwaltung von Tests mit Hilfe von Testfallsatz und Testfall Knoten"},"277":{"id":277,"content":"Konzepte Ein Testfall Knoten entspricht konzeptuell einem einzelnen elementaren Testfall und ist damit das entscheidende Bindeglied zwischen Testplanung, Testdurchführung und Testauswertung. Mit Hilfe von Abhängigkeit Knoten können Testfälle so voneinander isoliert werden, dass sie in beliebiger Reihenfolge ausgeführt werden können und auf unvorhergesehenes Verhalten reagiert werden kann. Damit ist es möglich, Teile von funktionalen Tests als Build-Test auszuführen oder etwa einen erneuten Testlauf durchzuführen, bei dem nur die fehlgeschlagenen Testfälle wiederholt werden. Testfallsätze sind im Prinzip einfach Sammlungen von zusammengehörigen Testfällen, die ähnliche Vor- und Nachbedingungen haben. Testfallsätze können auch verschachtelt werden. Die Struktur der Testfallsatz und Testfall Knoten ist damit ähnlich der Struktur der Prozeduren und Packages Knoten. Der Testsuite Knoten kann als spezielle Form eines Testfallsatzes angesehen werden. Testsuite, Testfallsatz und Testfall Knoten können von jedem anderen Ort aus mit Hilfe eines Testaufruf Knotens aufgerufen werden. Auf diesem Weg können sehr einfach Tests erstellt und verwaltet werden, die nur eine Untermenge von bestehenden Tests ausführen. Mit Blick auf den Report sollten Testaufruf Knoten nicht innerhalb eines Testfall Knotens ausgeführt werden, weil damit Testfälle verschachtelt würden und vom Report nicht mehr richtig aufgelöst werden könnten. In diesem Fall wird eine Warnung ausgegeben.","hash":"usec_testcase_concepts","h2":"Konzepte"},"278":{"id":278,"content":"Variablen und besondere Attribute","hash":"usec_testcase_vars","h2":"Variablen und besondere Attribute"},"279":{"id":279,"content":"Defaultwert Da Testfallsatz und Testfall Knoten durch Testaufruf Knoten aufgerufen werden können, verfügen sie analog zum Prozedur Knoten über einen Satz von Standardwerten für die Parameter. Diese werden auf dem Sekundärstapel gebunden und können über einen Testaufruf oder den Kommandozeilenparameter -variable <Name>=<Wert> überschrieben werden.","hash":"sec_defaultwert","h2":"Defaultwert"},"280":{"id":280,"content":"Variablendefinitionen Für einen Testfall kann man zudem Variablen definieren, die auf dem Primärstapel gebunden werden und nicht von außen mittels Testaufruf oder Kommandozeile überschrieben werden können. Primär- und Sekundärstapel sind in \"Ermittlung des Wertes einer Variablen\" näher beschrieben.","hash":"sec_variablendefinitionen","h2":"Variablendefinitionen"},"281":{"id":281,"content":"Charakteristische Variablen In der Liste der Charakteristischen Variablen können die Namen der Variablen angegeben werden, deren Werte zum Beispiel bei datengetriebenem Testen für einen Durchlauf des jeweiligen Testfallsatz oder Testfall Knotens charakteristisch sind. Die Werte dieser Variablen werden in Protokoll und Report angezeigt und helfen somit bei der Analyse von Problemen.","hash":"sec_charakteristische_variablen","h2":"Charakteristische Variablen"},"282":{"id":282,"content":"Bedingung Ein weiteres nützliches Attribut ist die Bedingung, vergleichbar mit der Bedingung eines If Knotens. Falls die Bedingung nicht leer ist, wird der Knoten nur ausgeführt, falls der Wert des Ausdrucks wahr ist. Andernfalls wird der Test übersprungen.","hash":"sec_bedingung","h2":"Bedingung"},"283":{"id":283,"content":"Fehlschlagen erwartet wenn... Manchmal wird das Fehlschlagen eines Testfalls für eine bestimmte Zeitdauer erwartet, z. B. wenn dieser erstellt wird, bevor ein Feature oder Bug-Fix im SUT verfügbar ist. Das Attribut Fehlschlagen erwartet wenn... erlaubt es, solche Testfälle zu markieren, so dass diese getrennt gezählt werden und nicht in die prozentuale Fehlerstatistik eingehen.","hash":"sec_fehlschlagen_erwartet_wenn","h2":"Fehlschlagen erwartet wenn..."},"284":{"id":284,"content":"Sequenz und Testschritt Knoten Primäre Bausteine einer Testsuite sind die Sequenz und Testschritt Knoten, die ihre Unterknoten einen nach dem anderen ausführen. Sie dienen der Strukturierung der Unterknoten eines Testfall. Der Unterschied zwischen Sequenz und Testschritt Knoten besteht darin, dass Testschritt Knoten im Report protokolliert werden, Sequenz Knoten hingegen nicht.","hash":"usec_teststep","h1":"Sequenz und Testschritt Knoten"},"285":{"id":285,"content":"Vorbereitung und Aufräumen Knoten Neben den eigentlichen Testschritten enthält jeder Testfall auch Vor- bzw. Nachbedingungen. Die Vorbedingungen werden in Vorbereitung Knoten implementiert, Nachbedingungen in Aufräumen Knoten. In einfachen Fällen werden diese als Unterknoten eines Testfall oder Testfallsatz Knotens eingefügt. QF‑Test bietet allerdings noch eine mächtigere Variante für das Behandeln von Vor- und Nachbedingungen nämlich Abhängigkeit Knoten. Diese ermöglichen nicht nur die Wiederverwendung, sondern bieten auch Möglichkeiten an, um auf unterschiedliche Verhalten während des Testlaufes zu reagieren. Testfall Knoten mit durchdachten, passenden Vorbereitung und Aufräumen Knoten haben folgende wichtige Eigenschaften: Der Testfall kann unabhängig davon, ob vorhergehende Testfälle erfolgreich waren - oder eben nicht - ausgeführt werden. Testsuite bzw. der Testfallsatz können an beliebiger Position um weitere Testfall Knoten ergänzt werden, ohne andere Testfälle zu beeinflussen. Sie können einen Testfall erweitern oder ihn einfach ausprobieren, ohne vorhergehende Testfälle ausführen zu müssen, um das SUT in den passenden Zustand zu bringen. Sie können jede beliebige Teilmenge der Testfall Knoten ausführen, wenn Sie nicht den gesamten Testfallsatz benötigen. Im einfachsten Fall wird der gleiche Ausgangszustand für alle Testfälle eines Testfallsatzes benötigt. Dies kann mittels der folgenden Struktur realisiert werden:","hash":"usec_setup_cleanup","h1":"Vorbereitung und Aufräumen Knoten"},"286":{"id":286,"content":"Abbildung 8.2: Teststruktur mit einfacher Vorbereitung und Aufräumen Hier wird zu Beginn jedes Testfalls die Vorbereitung und nach Ende des Testfalls das Aufräumen ausgeführt. Im Protokoll ist die Ausführungsreihenfolge genau zu erkennen:","hash":"fig_simple_setup_cleanup_suite","h4":"Abbildung 8.2: Teststruktur mit einfacher Vorbereitung und Aufräumen"},"287":{"id":287,"content":"Abbildung 8.3: Ausführungsreihenfolge bei einfacher Vorbereitung und Aufräumen Beim Testfallsatz Knoten werden Vorbereitung und Aufräumen Knoten vor und nach jedem im Testfallsatz enthalten Knoten (Testfall und Testfallsatz) ausgeführt. Bei einem Testfall Knoten werden hingegen Vorbereitung und Aufräumen nur einmal ganz zu Beginn und Ende ausgeführt. Falls die Vorbereitung im obigen Beispiel den Start der Anwendung und die Aufräumen Knoten das Beenden dieser beinhaltet, würde vor jedem Testfall die Anwendung gestartet und danach wieder gestoppt. Diese Vorgehensweise ist wenig effizient. Daher bietet QF‑Test eine umfassendere Struktur, den Abhängigkeit Knoten, zur Herstellung der Vorbedingungen und dem effizienten Umgang mit Aufräumarbeiten.","hash":"fig_simple_setup_cleanup_log","h4":"Abbildung 8.3: Ausführungsreihenfolge bei einfacher Vorbereitung und Aufräumen"},"288":{"id":288,"content":"Prozeduren und Packages In mancher Hinsicht ist das Schreiben von Tests dem Programmieren nicht unähnlich. Nachdem die ersten Schritte gemeistert sind, tendieren Tests ebenso wie Programmcode dazu, unkontrolliert auszuufern. Das funktioniert so lange ganz gut, bis irgendein grundlegender Baustein, auf den man sich verlassen hat, geändert werden muss. Ohne saubere Struktur brechen Programme ebenso wie Tests an diesem Punkt in sich zusammen, da der Aufwand für die Anpassung an die neue Situation höher ist als gleich von vorne anzufangen. Ein Schlüsselpunkt, um dieses Problem zu verhindern, ist die Vermeidung von Redundanz. Wenn Sie sich zu sehr auf die Aufnahmefunktion allein verlassen, besteht die Gefahr, genau diese Redundanz zu erzeugen. Ein Beispiel: Sie nehmen verschiedene Sequenzen auf, die mit den Komponenten eines Dialogs interagieren. Um diese Sequenzen möglichst unabhängig voneinander zu halten, beginnen Sie jede Sequenz damit, dass Sie den Dialog öffnen. Analog beenden Sie die Sequenzen mit dem Schließen des Dialogs. Das ist eigentlich eine gute Idee, erzeugt aber Redundanz, da die Events zum Öffnen und Schließen des Dialogs in jeder einzelnen Sequenz vorkommen. Stellen Sie sich vor, was passiert, wenn sich das SUT auf eine Weise ändert, die dazu führt dass dieser Teil nicht mehr funktioniert, z.B. weil erst ein kleines Bestätigungsfenster geschlossen werden muss, bevor der Dialog geschlossen werden kann. Jetzt müssen Sie durch die gesamte Testsuite gehen, alle Stellen finden, an denen der Dialog geschlossen wird und jede einzelne Stelle an die neuen Gegebenheiten anpassen. Der blanke Horror... Um noch einmal auf die Analogie zurückzukommen: Die entsprechende Art der Programmierung wird Spaghetti Programmierung genannt und führt zu der gleichen Art von Wartungsproblemen. Diese können vermieden werden, wenn identische Teile an einer Stelle zusammengefasst werden, wo sie bei Bedarf aufgerufen werden. Eine Anpassung an neue Gegebenheiten erfordert dann nur noch Modifikationen an dieser einen Stelle.","hash":"usec_procedures","h1":"Prozeduren und Packages"},"289":{"id":289,"content":"Abbildung 8.4: Packages und Prozeduren QF‑Test verfügt über einen Satz von Knotentypen, der diese Art der Modularisierung ermöglicht. Dabei handelt es sich um die Knoten Prozedur, Prozeduraufruf und Package. Eine Prozedur ist einer Sequenz sehr ähnlich, abgesehen davon, dass der Name der Prozedur zur Referenzierung durch einen Prozeduraufruf Knoten dient. Ein Prozeduraufruf wird ausgeführt, indem die Kontrolle an die entsprechende Prozedur übergeben wird. Mit dem letzten Kindknoten der Prozedur ist dann auch der Prozeduraufruf beendet. Packages sind dazu da, Prozeduren noch mehr Struktur zu geben, indem zusammengehörende Prozeduren in einem Package zusammengefasst werden können. Eine Hierarchie von Packages und Prozeduren ist unter dem Knoten Prozeduren angesiedelt. Eine Prozedur, die immer exakt die selben Schritte ausführt, egal wie und woher sie aufgerufen wird, ist nur von sehr begrenztem Nutzen. Um obiges Beispiel fortzuführen, könnte eine Prozedur beispielsweise den Dialog öffnen und seine Felder mit einigen Werten vorbelegen. Diese Werte sollten dann natürlich nicht hart in der Prozedur verdrahtet sein, sondern wir wollen sie beim Prozeduraufruf individuell festlegen. Zu diesem Zweck können Parameter für eine Prozedur definiert werden. Im Prozeduraufruf werden dann Werte für diese Parameter festgelegt. Diese sind nur für genau diese Ausführung der Prozedur gültig. Eine ausführliche Beschreibung zur Definition von Parametern und allgemein Variablen in QF‑Test, finden Sie in \"Variablen\". Zum besseren Verständnis ihres Zusammenspiels sollten Sie auch einen Blick auf die detaillierte Dokumentation der Prozedur und Prozeduraufruf Knoten werfen. Eine Testsuite-Bibliothek mit allgemein nützlichen Prozeduren wird von QF‑Test unter dem Namen qfs.qft zur Verfügung gestellt. Dieser Bibliothek ist ein ganzes Kapitel des Tutorials gewidmet. \"Der Aufruf einer Prozedur in einer anderen Testsuite\" erklärt, wie Sie die Bibliothek direkt in Ihre Testsuiten einbinden.","hash":"figure_8.4","h4":"Abbildung 8.4: Packages und Prozeduren"},"290":{"id":290,"content":"Lokale Prozeduren und Packages Wenn Sie in mehreren Testsuiten arbeiten, dann könnten Sie in die Situation kommen, dass Sie manche wiederverwendbaren Sequenzen bzw. Testschritte nur von einer bestimmten Testsuite aus ansprechen möchten. Wenn Sie solche lokale Prozeduren erstellen wollen, dann müssen Sie als erstes Zeichen des Prozedurnamens ein '_' definieren. Das '_' markiert die Prozedur als lokal in der jeweiligen Testsuite. Aufrufe von lokalen Prozeduren können nur innerhalb der Testsuite eingefügt werden, in der diese Prozedur definiert ist. Sie können dasselbe Konzept auch für lokale Packages nutzen.","hash":"usec_localprocedures","h2":"Lokale Prozeduren und Packages"},"291":{"id":291,"content":"Relative Prozeduren Wenn Sie Prozeduren in anderen Prozeduren aufrufen, könnte es manchmal von Vorteil sein, nicht den vollen Namen der Prozedur definieren zu müssen. So genannte 'relative' Prozeduraufrufe können nur in Packages eingefügt werden, welche das Attribut Grenze für relative Aufrufe (siehe auch Grenze für relative Aufrufe) gesetzt haben. Der Aufbau von relativen Aufrufen sieht wie folgt aus:","hash":"usec_relativeprocedures","h2":"Relative Prozeduren"},"292":{"id":292,"content":"Ebene Aufruf Prozeduren auf derselben Ebene .Name der Prozedur Prozeduren eine Ebene höher ..Name der Prozedur Prozeduren eine Ebene tiefer .Name des Package.Name der Prozedur Tabelle 8.1: Relative Prozeduraufrufe Wie Sie sehen können, wird für jede Ebene einfach ein Punkt hinzugefügt. Eine Prozedur zwei Ebenen höher, wird also mittels drei Punkten referenziert (Die aktuelle Ebene zählt auch mit).","hash":"table_8.1","h2":"Relative Prozeduren"},"293":{"id":293,"content":"Einfügen von Prozeduraufruf Knoten Sie sollten Tests in einzelnen Testschritten organisieren, wobei idealerweise jeder Testschritt einem QF‑Test Prozedur Knoten entspricht. QF‑Test bietet unterschiedliche Methoden um Prozeduraufruf Knoten anzulegen: Mittels Auswahl im Menü »Einfügen«-»Prozeduren«-»Prozeduraufruf« Mittels Rechtsklick und Auswahl von »Knoten einfügen«-»Prozeduren«-»Prozeduraufruf« Wenn Sie einen Prozedur Knoten an eine Stelle, wo ein Prozeduraufruf eingefügt werden soll, kopieren, wird dieser eingefügt. Mittels Drag&Drop Operation, d.h. Ziehen eines Prozedur Knotens an die gewünschte Stelle. Mittels Tastaturkürzel Strg⁠+⁠A Mittels der Umwandlung einer Sequenz oder eines Testschritt in eine Prozedur, wie in \"Konvertieren von Sequenzen und Testschritte in Prozeduren\" beschrieben. Tastaturkürzel Strg⁠+⁠Shift⁠+⁠P Diese Methoden funktionieren auch für Bezug auf Abhängigkeit Knoten bis auf die letzten beiden.","hash":"usec_procedures_InsertProcCalls","h2":"Einfügen von Prozeduraufruf Knoten"},"294":{"id":294,"content":"Parametrisieren von Knoten Sie können Parameter von Prozeduren, Abhängigkeiten oder Testfälle automatisch mittels des Menüs »Operationen«-»Knoten parametrisieren« erstellen. Der Parametrisierungsdialog ermöglicht es Ihnen noch weitere Details über das Erstellen der Parameter zu definieren, z.B. ob nur Parameter für Texteingaben oder Checkknoten zu erstellen sind.","hash":"usec_procedures_Param","h2":"Parametrisieren von Knoten"},"295":{"id":295,"content":"Konvertieren von Sequenzen und Testschritte in Prozeduren Diese Konvertierung kann sehr hilfreich sein um sofort während der Entwicklung Prozeduren zu erstellen. Unter Extrasequenzen können Sie Sequenzen in Prozeduren konvertieren und in den Prozeduren Bereich verschieben. Wenn Sie eine Sequenz oder Testschritt unter einem Testfall konvertieren, dann erstellt QF‑Test automatisch eine Prozedur und fügt an Stelle der Sequenz oder des Testschritt den entsprechenden Prozeduraufruf ein. Die Konvertierung kann mittels dem Menü »Operationen«-»Knoten konvertieren in«-»Prozedur« oder über das Tastaturkürzel Shift⁠+⁠Strg⁠+⁠P angestoßen werden.","hash":"usec_procedure_transform","h2":"Konvertieren von Sequenzen und Testschritte in Prozeduren"},"296":{"id":296,"content":"Abhängigkeit Knoten Video: Abhängigkeiten","hash":"usec_dependencies","h1":"Abhängigkeit Knoten"},"297":{"id":297,"content":"Funktionsweise Abhängigkeiten stellen eine mächtige und optimierte Variante für die Herstellung von Vor- und Nachbedingungen dar. Sie sind unverzichtbar zur Ausführung von Tests im QF‑Test Daemon-Modus. Ihre prinzipielle Funktionsweise ist wie folgt: Erstellung einer Liste der für den Testfall benötigen Abhängigkeiten. Vergleich der aktuellen Abhängigkeitenliste mit der des vorangehenden Testfalls. Ausführung der Aufräumen Knoten derjenigen Abhängigkeiten, die in der Abhängigkeitenliste des aktuellen Testfalls nicht mehr vorkommen oder deren Charakteristische Variablen sich verändert haben sowie derjenigen Abhängigkeiten, die auf diesen basieren. Ausführung aller Vorbereitung Knoten der aktuellen Abhängigkeitenliste. Testfälle als auch andere Abhängigkeiten können sich mittels Bezug auf Abhängigkeit Knoten auf Abhängigkeit Knoten, die im Prozeduren Bereich abgelegt wurden, beziehen. Somit können Vorbereitung und Aufräumen Knoten, die sich in einem Abhängigkeiten Knoten befinden von mehreren Testfällen genutzt werden - im Gegensatz zu denjenigen, die direkt in einem Testfall oder Testfallsatz Knoten liegen. Für das Verständnis der Arbeitsweise von Abhängigkeiten ist es hilfreich, sich das Vorgehen eines Testers bei manuellen Tests anzusehen: Zunächst führt er alle notwendigen Vorbereitungen und dann den ersten Testfall aus. Wenn bei der Ausführung des Testfalls Fehler auftreten, wird er gegebenenfalls Fehlerbehandlungsroutinen ausführen. Als nächstes prüft er, welche Vorbedingungen für den nächsten Test gelten und wird erst dann eventuelle Aufräumarbeiten durchführen. Dabei wird er nur das aufräumen, was für nächsten Testfall nicht mehr benötigt wird. Als nächstes geht er alle Vorbedingungen durch und prüft, ob die notwendigen Voraussetzungen noch bestehen oder ob zum Beispiel auf Grund von Fehlern im vorhergehenden Testfall wiederhergestellt werden müssen. Falls das SUT in einen stark fehlerhaften Zustand versetzt wurde, führt er weitere Aufräumarbeiten aus bevor er die Vorbedingungen für den nächsten Testfall herstellen kann. Genau diese Vorgehensweise können Sie über QF‑Test Abhängigkeiten abbilden. Mit den Abhängigkeiten werden die Nachteile der klassischen Vorbereitung und Aufräumen Knoten, dass zum einen die Vorbereitung Knoten nur über die Verschachtelungen von Testfallsätzen geschachtelt werden können und zum anderen in jedem Fall der Aufräumen Knoten ausgeführt wird, behoben. Beides ist nicht sonderlich effizient. Abhängigkeit Knoten geben nicht nur eine Antwort auf diese beiden Punkte sondern bieten zudem Strukturelemente für die Behandlung von Fehlern und unvorhergesehenen Ereignissen. Abhängigkeiten werden in vielen mitgelieferten Beispieltestsuiten verwendet, zum Beispiel: In doc/tutorial die Testsuite namens dependencies.qft. Die Abhängigkeiten in dieser Testsuite werden ausführlich im Tutorial unter \"Weiterführende Features von QF‑Test\" erläutert. Im Verzeichnis demo/carconfigSwing die Testsuite carconfigSwing_de.qft, die ein realistisches Beispiel enthält. Die SWT Demo Suite namens swt_addressbook.qft, die für SWT-Anwender ein Beispiel bietet. In demo/eclipse die Testsuite namens eclipse.qft, in der Sie eine verschachtelte Abhängigkeit finden. In doc/tutorial verwendet das Datentreiber-Demo datadriver.qft Abhängigkeiten. Wenn Sie im Debugger in Einzelschritten durch diese Testsuiten gehen und sich die zugehörigen Variablenbindungen und Protokolle ansehen, sollten Sie ein gutes Gefühl für diese Technik bekommen. Bitte beachten Sie, dass Sie veränderte Testsuiten am besten in einem projektspezifischen Ordner speichern.","hash":"sec_funktionsweise","h2":"Funktionsweise"},"298":{"id":298,"content":"Verwendung von Abhängigkeiten Abhängigkeiten können an zwei Stellen definiert werden: Allgemeine Abhängigkeiten, die oft wiederverwendet werden und als Grundlage für weitere Abhängigkeiten dienen, können genau wie ein Prozedur Knoten implementiert und unterhalb des Prozeduren Knotens platziert werden, zum Beispiel in einem Package Knoten namens \"Abhängigkeiten\". Der qualifizierte Name wird genau wie der einer Prozedur gebildet. Abhängigkeiten können analog zu einem Prozeduraufruf durch einen Bezug auf Abhängigkeit Knoten referenziert werden. Alternativ können Abhängigkeiten Knoten am Beginn eines Testsuite, Testfallsatz oder Testfall Knotens implementiert werden. Zusätzlich zu ihrer eigenen Abhängigkeit können Testfälle und Testfallsätze die Abhängigkeit von ihrem Parentknoten erben. Eine Abhängigkeit sollte sich jeweils nur um eine Vorbedingung kümmern. Hat diese ihrerseits Vorbedingungen, sollten diese zu Grunde liegenden Schritte von anderen Abhängigkeiten übernommen werden. Dies kann implizit durch Erben der Abhängigkeit von einem Parentknoten oder explizit durch einen Bezug auf Abhängigkeit Knoten geschehen. Die eigentliche Implementierung der Vor- und Nachbedingungen geschieht in Vorbereitung und Aufräumen Knoten innerhalb der Abhängigkeit. Enthält ein Testfallsatz oder Testfall Knoten sowohl Abhängigkeit Knoten als auch Vorbereitung und Aufräumen Knoten, wird die Abhängigkeit zuerst aufgelöst. Vorbereitung und Aufräumen Knoten haben keinen Einfluss auf den Stapel von Abhängigkeiten.","hash":"sec_verwendung_von_abhangigkeiten","h2":"Verwendung von Abhängigkeiten"},"299":{"id":299,"content":"Abhängigkeiten - Ausführung und Stapel von Abhängigkeiten Die Ausführung einer Abhängigkeit gliedert sich in drei Phasen: Erstellung einer Liste benötigter Abhängigkeiten und Abgleich mit der Liste früher ausgeführter Abhängigkeit Knoten Ausführung von Aufräumen Knoten, falls notwendig Ausführung der Vorbereitung Knoten aller benötigen Abhängigkeiten Die im vorliegenden Kapitel verwendeten Beispiele beziehen sich alle auf Testfälle, die eine Kombination der folgenden Vorbedingungen und Nachbereitungen erfordern: Beispiel Abhängigkeit A: Anwendung gestartet Vorbereitung: Anwendung bei Bedarf starten Aufräumen: Anwendung stoppen Abhängigkeit B: Anwender angemeldet Vorbereitung: Anwender bei Bedarf anmelden Aufräumen: Anwender abmelden Abhängigkeit C: Anwendungsmodul 1 geladen Vorbereitung: Anwendungsmodul 1 bei Bedarf laden Aufräumen: Anwendungsmodul beenden Abhängigkeit D: Anwendungsmodul 2 geladen Vorbereitung: Anwendungsmodul 2 bei Bedarf laden Aufräumen: Anwendungsmodul 2 beenden Abhängigkeit E: Dialog in Modul 2 geöffnet Vorbereitung: Dialog in Modul 2 bei Bedarf öffnen Aufräumen: Dialog schließen Abhängigkeit C hängt von B ab, B wiederum von A. Abhängigkeit E hängt von D ab, D von B und damit auch von A. Vor der Ausführung eines Testfall Knotens prüft QF‑Test, ob dieser einen Abhängigkeit Knoten besitzt oder erbt. In diesem Fall prüft QF‑Test, ob der Abhängigkeit Knoten seinerseits weitere Abhängigkeiten einbezieht. Auf Basis dieser Analyse erstellt QF‑Test zunächst eine Liste der auszuführenden Abhängigkeiten. Dies entspricht Schritt 1 des nachfolgenden Beispiels. Als nächstes prüft QF‑Test, ob bereits für vorhergehende Testfälle Abhängigkeiten ausgeführt wurden. Falls ja, vergleicht QF‑Test die Liste der ausgeführten Abhängigkeiten mit den aktuell benötigten. Für nicht mehr benötigte Abhängigkeiten werden nun die Aufräumen Knoten ausgeführt. Danach durchläuft QF‑Test alle Vorbereitung Knoten, wobei mit den grundlegenden Abhängigkeiten begonnen wird. Der Name des ausgeführten Abhängigkeiten Knotens wird jeweils vermerkt. Diese Liste wird Abhängigkeitenstapel genannt. Beispiel: Testfall 1 Test von Anwendungsmodul 1. Es handelt sich um den ersten ausgeführten Testfall Knoten. Schritt: Die Analyse der Abhängigkeiten ergibt eine Liste mit den Abhängigkeiten A-B-C (Anwendung gestartet, Anwender angemeldet, Modul 1 geladen). Schritt Abgleich der Abhängigkeitenliste mit dem Abhängigkeitenstapel: In diesem Beispiel ist der Abhängigkeitenstapel leer, da noch kein Testfall ausgeführt wurde. Schritt Ausführung der Vorbereitung Knoten, beginnend mit A (Anwendung starten), dann B (Anwender anmelden, Anwendername: Standard), und C (Modul 1 laden). Auf dem Abhängigkeitenstapel wird die Ausführung der Abhängigkeiten A-B-C vermerkt. Schritt Ausführung des Testfall Knotens. Diese Schritte lassen sich im Protokoll genau nachverfolgen:","hash":"usec_dependency_stack","h2":"Abhängigkeiten - Ausführung und Stapel von Abhängigkeiten"},"300":{"id":300,"content":"Abbildung 8.5: Stapel von Abhängigkeiten A-B-C Nach Ausführung des Testfall Knotens verbleibt die Anwendung zunächst in dem Zustand, in den der Testfall sie versetzt hat. Erst nach der Analyse der Abhängigkeiten des nächsten Testfall Knotens werden bei Bedarf Abhängigkeiten abgebaut - in umgekehrter Ausführungsreihenfolge der Vorbereitung Knoten. Anschließend werden die Vorbereitung Knoten aller benötigen Abhängigkeiten durchlaufen. Dieser Punkt ist sehr wichtig. Es werden also nicht einfach die restlichen Vorbereitung Knoten ausgeführt, sondern die aller einbezogenen Abhängigkeit Knoten. Der Grund hierfür ist, dass es, wie bereits erwähnt, in der Natur des Testens liegt, dass es zu Fehlerzuständen kommen kann. Daher wird vor Ausführung eines Vorbereitung Knotens geprüft, ob auch die jeweils zugrunde liegenden Voraussetzungen erfüllt sind. Die Vorbereitung Knoten sollten daher so aufgebaut sein, dass zunächst geprüft wird, ob die Voraussetzung bereits gegeben ist und nur bei Bedarf der gesamte Vorbereitung Knoten durchlaufen wird.","hash":"fig_dependency_abc","h4":"Abbildung 8.5: Stapel von Abhängigkeiten A-B-C"},"301":{"id":301,"content":"Abbildung 8.6: Typischer Vorbereitung Knoten Außerdem sollten Vorbereitung Knoten und Aufräumen Knoten immer in der Lage sein, Programmzustände, die auf Grund von Fehlern nicht dem Sollzustand entsprechen, zu bereinigen, so dass der nachfolgende Testfall nicht von vorangehenden Fehlern beeinträchtigt wird. Auch sollte ein Aufräumen Knoten nicht zu einem Fehler führen, wenn der angestrebte Zustand bereits besteht. Wenn das SUT zum Beispiel beendet werden soll, darf es zu keinem Fehler kommen, wenn es, aus welchem Grund auch immer, schon vor Ausführung des Aufräumen Knotens nicht mehr läuft. Beispiel: Testfall 2 Test eines Dialogs in Anwendungsmodul 2 Schritt: Die Analyse der einbezogenen Abhängigkeiten ergibt die Abhängigkeitenliste A-B-D-E (Anwendung gestartet, Anwender angemeldet, Modul 2 geladen, Dialog geöffnet). Schritt: Abgleich der Abhängigkeitenliste mit dem Abhängigkeitenstapel: Abhängigkeit C ist keine Voraussetzung für Testfall 2. Daher wird der Aufräumen Knoten der Abhängigkeit C ausgeführt (Beenden von Modul 1). Schritt: Ausführung der Vorbereitung Knoten, beginnend mit A (Es wird erkannt, dass die Anwendung bereits läuft und der Rest des Vorbereitung Knotens übersprungen.), dann B (Es wird erkannt, dass der Anwender bereits angemeldet ist und der Rest des Vorbereitung Knotens übersprungen.), dann D (Es wird erkannt, dass Modul 2 noch nicht geladen ist - der Vorbereitung Knoten wird komplett ausgeführt.), dann E (analog zu D). Schritt: Ausführung des Testfall Knotens 2. Auch der Aufräumen-Schritt erscheint im Protokoll:","hash":"fig_dependency_setup","h4":"Abbildung 8.6: Typischer Vorbereitung Knoten"},"302":{"id":302,"content":"Abbildung 8.7: Stapel von Abhängigkeiten A-B-D-E","hash":"fig_dependency_2","h4":"Abbildung 8.7: Stapel von Abhängigkeiten A-B-D-E"},"303":{"id":303,"content":"Charakteristische Variablen Eine Abhängigkeit kann ihrerseits von den Werten gewisser Variablen abhängen. Diese Variablen werden als Charakteristische Variablen einer Abhängigkeit bezeichnet. Beim Abgleich der benötigten Abhängigkeit Knoten mit den bereits ausgeführten auf dem Abhängigkeitenstapel werden die Charakteristischen Variablen mit herangezogen. Zwei Abhängigkeit Knoten gelten nur dann als gleich, wenn auch die Werte aller Charakteristischen Variablen zwischen der vorherigen und der aktuellen Ausführung übereinstimmen. Somit ist es auch möglich, dass eine Abhängigkeit sich, direkt oder indirekt, mehrfach auf die selbe Abhängigkeit bezieht, aber mit unterschiedlichen Werten für die Charakteristischen Variablen. In diesem Fall taucht die bezogene Abhängigkeit mehrfach in der Liste der benötigten Abhängigkeiten und nach deren Ausführung auf dem Abhängigkeitenstapel auf, jeweils mit dem entsprechenden Wert der Charakteristischen Variablen. Wird die Abhängigkeit abgebaut und ihr Aufräumen Knoten ausgeführt, erhalten die Charakteristischen Variablen innerhalb des Aufräumen Knotens die gespeicherten Werte, also die, die sie zum Zeitpunkt der Ausführung des Vorbereitung Knotens hatten. Dadurch wird sicher gestellt, dass die Ausführung eines Testfall Knotens mit anderen Variablenwerten die Aufräumen Knoten beim Abbau des Abhängigkeitenstapels nicht aus der Bahn werfen kann. Denken Sie zum Beispiel an die häufig für den Namen des SUT Clients verwendete Variable \"client\". Wird zunächst ein Satz von Tests für ein SUT ausgeführt und benötigt der nächste Testfall ein ganz anderes SUT, wird eventuell die Variable \"client\" umdefiniert. Der Aufräumen Knoten zum Beenden des alten SUT muss aber den alten Wert für \"client\" erhalten, sonst könnte er den alten SUT Client gar nicht beenden. Darum kümmert sich QF‑Test automatisch, sofern sich \"client\" unter den Charakteristischen Variablen der Abhängigkeit befindet. Beispiel: Testfall 3: Der gleiche Dialog soll für den Administrator getestet werden. Schritt: Die Analyse der einbezogenen Abhängigkeiten ergibt die gleiche Abhängigkeitenliste A-B-D-E (Anwendung gestartet, Anwender angemeldet, Modul 2 geladen, Dialog geöffnet) wie für Testfall 2, wobei die Charakteristische Variablen in Abhängigkeit B den Wert 'Administrator' hat. Schritt: Abgleich der Abhängigkeitenliste mit dem Abhängigkeitenstapel: Die benötigte Abhängigkeit B unterscheidet sich auf Grund der Charakteristischen Variablen 'anwendername' mit dem Wert 'Administrator' von der auf dem Abhängigkeitenstapel gespeicherten mit dem Wert 'Standard'. Dies bedeutet, dass der Abhängigkeitenstapel bis einschließlich Abhängigkeit B (Anwender abmelden) abgebaut wird, beginnend mit Aufräumen für Abhängigkeit E (Dialog schließen), dann Aufräumen für Abhängigkeit D (Modul 2 beenden), dann Aufräumen für Abhängigkeit B (Anwender abmelden). Die Variable 'anwendername' erhält hierbei den über die Charakteristische Variablen gespeicherten Wert 'Standard'.) Schritt: Ausführung der Vorbereitung Knoten, beginnend mit A (Es wird erkannt, dass die Anwendung bereits läuft und der Rest der Vorbereitung übersprungen.), dann B (Administrator anmelden), dann D (Modul 2 laden), dann E (Dialog öffnen) Schritt: Ausführung des Testfall Knotens 3 Im Protokoll sieht man die den Wert der Charakteristischen Variablen hinter der jeweiligen Abhängigkeit:","hash":"usec_dependency_special_variables","h2":"Charakteristische Variablen"},"304":{"id":304,"content":"Abbildung 8.8: Charakteristische Variablen Weitere typische Beispiele für Charakteristischen Variablen sind die JDK-Version, wenn das SUT mit verschiedenen JDK-Versionen getestet werden soll, oder der Browsername im Falle einer Web-Anwendung. Diese würden in unserem Beispiel als Charakteristische Variablen für Abhängigkeit A (Anwendung gestartet) definiert.","hash":"fig_dependency_3","h4":"Abbildung 8.8: Charakteristische Variablen"},"305":{"id":305,"content":"Aufräumen erzwingen In manchen Anwendungsfällen kann es nötig sein, dass der Aufräumen Knoten einer Abhängigkeit nach jedem Testfall ausgeführt wird. In diesem Fall kann das Attribut Aufräumen erzwingen gesetzt werden. Falls bei einem der Abhängigkeit Knoten auf dem Stapel das Attribut Aufräumen erzwingen gesetzt ist, werden von diesem und eventuell nachgeordneten Abhängigkeit Knoten die Aufräumen Knoten ausgeführt. Beispiel: In diesem Beispiel verlangt die Testlogik, dass das Anwendungsmodul 2 nach Testausführung immer beendet werden muss. Somit wird im Abhängigkeit Knoten D das Attribut Aufräumen erzwingen gesetzt. Nun würden in Schritt 2 unserer Beispiele immer die Aufräumen Knoten der Abhängigkeit E (Dialog schließen) und der Abhängigkeit D (Modul 2 beenden) ausgeführt.","hash":"sec_aufraumen_erzwingen","h2":"Aufräumen erzwingen"},"306":{"id":306,"content":"Abhängigkeiten abbauen QF‑Test räumt Abhängigkeiten je nach Bedarf der Testfälle auf. Sie können den Stapel der Abhängigkeiten auf zwei Arten explizit leeren: Über den Menüeintrag »Wiedergabe«-»Abhängigkeiten auflösen« wird der Stapel \"sauber\" abgebaut indem alle Aufräumen Knoten in umgekehrter Reihenfolge der Abhängigkeitsvorbereitungen ausgeführt werden. Mittels »Wiedergabe«-»Abhängigkeiten zurücksetzen« wird der Stapel dagegen einfach gelöscht, ohne dass irgendein Knoten ausgeführt wird. Bei einem Testfall, der selbst keine Abhängigkeiten nutzt, bleibt der Stapel der Abhängigkeiten unberührt, d.h. es werden keine Aufräumen Knoten ausgeführt. Erst beim nächsten Testfall mit Abhängigkeiten wird der Abhängigkeitenstapel wieder berücksichtigt.","hash":"sec_abhangigkeiten_abbauen","h2":"Abhängigkeiten abbauen"},"307":{"id":307,"content":"Eskalation von Fehlern Eine weitere hervorragende Eigenschaft von Abhängigkeiten ist die Möglichkeit, Fehler ohne weiteren Aufwand zu eskalieren. Betrachten wir wieder das Beispiel aus dem vorhergehenden Abschnitt nachdem der erste Abhängigkeitenstapel A-B-C (Anwendung gestartet, Anwender angemeldet, Modul 1 geladen) aufgebaut und alle zugehörigen Vorbereitung Knoten ausgeführt wurden. Was passiert, wenn bei der Ausführung des eigentlichen Testfall Knotens das SUT auf einen wirklich schweren Fehler stößt wie z.B. ein Deadlock und nicht mehr auf Benutzereingaben reagiert? Schlägt beim Abbau des Stapels von Abhängigkeiten die Ausführung eines Aufräumen Knotens fehl, baut QF‑Test die nächstzugrunde liegende Abhängigkeit ab, bei erneuten Problemen eine weitere und so fort. Analog dazu führt beim Aufbau des Stapels ein Fehler in einem Vorbereitung Knoten dazu, dass zunächst eine weitere Abhängigkeit abgebaut wird und dann noch einmal die Vorbereitung Knoten ausgeführt werden. Beispiel: Im obigen Beispiel Testfall 1 geht das SUT zum Beispiel in ein Deadlock und reagiert nicht mehr auf Eingaben. Zunächst wird eine Exception geworfen, die Ausführung von Testfall 1 abgebrochen und mit Testfall 2 fortgefahren. Schritt: Analyse der benötigten Abhängigkeiten und Erstellen der Abhängigkeitenliste A-B-D-E (Anwendung gestartet, Anwender angemeldet, Modul 2 geladen, Dialog geöffnet) Schritt: Der Abgleich der benötigten Abhängigkeiten mit dem von Testfall 1 aufgebauten Abhängigkeitenstapel A-B-C (Anwendung gestartet, Anwender angemeldet, Modul 1 geladen) bewirkt, dass der Aufräumen Knoten der Abhängigkeit C (Modul 1 beenden) ausgeführt wird. Dabei kommt es erneut zur Exception. Nun führt QF‑Test den Aufräumen Knoten der zu Grunde liegenden Abhängigkeit B (Anwender abmelden) aus. Dies scheitert erneut, so dass wiederum die zu Grunde liegende Abhängigkeit A aufgeräumt wird. Diese schließt erfolgreich die Anwendung. Schritt: Ausführung der Vorbereitung Knoten, beginnend mit A (Anwendung starten), dann B (Anwender anmelden), dann D (Modul 1 laden) und schließlich E (Dialog öffnen). Schritt: Testfall 2 kann trotz des Deadlocks in Testfall 1 ausgeführt werden. Dies lässt sich wieder genau im Protokoll nachverfolgen:","hash":"usec_error_escalation","h2":"Eskalation von Fehlern"},"308":{"id":308,"content":"Abbildung 8.9: Fehlereskalation in Abhängigkeiten Damit die Fehlereskalation zuverlässig funktioniert, ist es sehr wichtig, Aufräumen Knoten so zu implementieren, dass entweder der gewünschte Zustand erreicht oder eine Exception geworfen wird. Letzteres führt nur zum Erfolg, wenn in einer der grundlegenderen Abhängigkeiten ein umfassender Aufräumen Knoten vorhanden ist, der das SUT in einen definierten Zustand bringen oder beenden kann. Dabei ist es wichtig, dass zum Beispiel der Aufräumen Knoten, der das SUT beenden soll, nicht nur versucht, das SUT etwa über das Datei->Beenden Menü sauber herunterzufahren, sondern auch abprüft, ob die Aktion erfolgt reich war und gegebenenfalls drastischere Maßnahmen durchführt wie zum Beispiel den Prozess des SUT \"abzuschießen\". Ein solcher Aufräumen Knoten sollte also einen Try/Catch Block verwenden und zusätzlich in einem Finally Knoten sicherstellen, dass das SUT auf jeden Fall beendet ist.","hash":"fig_dependency_exception","h4":"Abbildung 8.9: Fehlereskalation in Abhängigkeiten"},"309":{"id":309,"content":"Abbildung 8.10: Typischer Aufräumen Knoten Bei sauber implementierter Fehlerbehandlung werden sich Testfälle selbst bei schweren Fehlern kaum gegenseitig beeinflussen. Dies schützt vor dem Verlust aller Testergebnisse eines lang dauernden nächtlichen Testlaufs nur aufgrund eines einzelnen Fehlers zu einem frühen Zeitpunkt.","hash":"fig_dependency_cleanup","h4":"Abbildung 8.10: Typischer Aufräumen Knoten"},"310":{"id":310,"content":"Fehlerbehandlung und Reaktion auf unerwartetes Verhalten Neben der automatischen Eskalation von Fehlern unterstützt ein Abhängigkeit Knoten auch die explizite Behandlung von Fehlern oder Exceptions, die bei der Ausführung eines Testfall Knotens auftreten. Hierzu können Catch Knoten am Ende des Abhängigkeit Knotens eingefügt werden. Diese fangen im Testfall auftretende Exceptions und können gezielt darauf reagieren. So könnte zum Beispiel eine DeadlockTimeoutException mit umgehender Terminierung des SUT Prozesses quittiert werden. Eine derart gefangene Exception wird in Protokoll und Report weiterhin als Exception aufgeführt. Des Weiteren kann ein Fehlerbehandlung Knoten in der Abhängigkeit zwischen dem Aufräumen Knoten und dem ersten Catch Knoten eingefügt werden. Dieser wird ausgeführt, wenn der Testfall mit dem Ergebnis \"Fehler\" beendet wird. Im Fall einer Exception wird der Fehlerbehandlung Knoten nicht ausgeführt, da das in der Regel eher noch mehr Probleme verursachen würde und sogar mit der Behandlung von Exceptions kollidieren könnte. Um im Fall von Fehlern und Exceptions die selben Konsequenzen zu ziehen, können Sie dafür eine Prozedur implementieren und diese aus Fehlerbehandlung und Catch Knoten heraus aufrufen. Fehlerbehandlung Knoten sind nützlich, um Informationen zu ermitteln und zu speichern, die QF‑Test nicht bereits automatisch zur Verfügung stellt. So könnten Sie beispielsweise eine Kopie von temporären Dateien oder Protokollen erstellen, die von Ihrem SUT angelegt werden und eventuell Aufschlüsse über die Fehlerursache liefern könnten. Es wird jeweils nur der oberste Fehlerbehandlung Knoten auf dem Stapel von Abhängigkeiten ausgeführt. Wenn also bei einem Stapel der Form A,B,C,D] sowohl A als auch C einen Fehlerbehandlung Knoten enthalten, wird nur der Knoten von C ausgeführt. Andernfalls wäre es schwierig, in der spezialisierten Abhängigkeit C die Fehlerbehandlung der allgemeineren Abhängigkeit A zu modifizieren. Um die Fehlerbehandlung von A in C wiederzuverwenden, implementieren Sie diese in einer Prozedur.","hash":"usec_dependency_error_handling","h2":"Fehlerbehandlung und Reaktion auf unerwartetes Verhalten"},"311":{"id":311,"content":"Namensräume für Abhängigkeiten Dieser Absatz ist für Sie nur interessant, wenn Sie mehrere Applikationen haben, die Sie gleichzeitig testen wollen und wenn der Abhängigkeit Knoten eines Testfalls keine Auswirkung auf den bestehenden Abhängigkeitenstapel haben soll. Ein typischer Anwendungsfall ist der Test ganzer Prozessketten, die mehrere Applikationen umfassen. Als Beispiel soll hier folgende Situation dienen: Der Außendienst erfasst die Angebotsdaten über eine Web-Applikation und schickt diese an ein Datenbanksystem in der Zentrale, wo die Angebote vervollständigt, gedruckt und versandt werden. Eine Kopie der versandten Aufträge wird in einem separaten Dokumentenmanagementsystem (DMS) abgespeichert.","hash":"usec_dependency_namespaces","h2":"Namensräume für Abhängigkeiten"},"312":{"id":312,"content":"Abbildung 8.11: Beispiel Testfallsatz für Namensräume In obigem Beispiel erfassen zwei unterschiedliche Mitarbeiter (AnwenderA und AnwenderB) die Daten für das Angebot, zwei weitere (AnwenderC und AnwenderD) erstellen die Angebote und die Archivierung wird im Dokumentenmanagementsystem geprüft. Damit sich die Anhängigkeiten nicht gegenseitig beeinflussen, wird im Bezug auf Abhängigkeit Knoten jeweils ein passender Name im Feld Namensraum für Abhängigkeiten eingetragen. Wenn man den Testfallsatz ausführt, sieht man im Protokoll, dass für den ersten Testfall ein Abhängigkeitenstapel im Namensraum \"Datenerfassung\" angelegt wird:","hash":"fig_dependency_namespaces_testcase","h4":"Abbildung 8.11: Beispiel Testfallsatz für Namensräume"},"313":{"id":313,"content":"Abbildung 8.12: Abhängigkeitenbehandlung für Testfall Datenerfassung durch Anwender A Für den zweiten Testfall wird ein Abhängigkeitenstapel im Namensraum \"Datenbanksystem\" angelegt. Der Abhängigkeitenstapel im Namensraum \"Datenerfassung\" wird nicht betrachtet. Es wird also das Datenbanksystem gestartet. Die Anwendung zur Datenerfassung bleibt unverändert.","hash":"fig_dependency_namespaces_log1","h4":"Abbildung 8.12: Abhängigkeitenbehandlung für Testfall Datenerfassung durch Anwender A"},"314":{"id":314,"content":"Abbildung 8.13: Abhängigkeitenbehandlung für Testfall Angebotserstellung durch Anwender C Für den dritten Testfall wird ein Abhängigkeitenstapel im Namensraum \"Dokumentenverwaltung\" angelegt. Die Abhängigkeitenstapel in den Namensräumen \"Datenerfassung\" und \"Datenbanksystem\" werden nicht betrachtet. Es wird also das Dokumentenmanagementsystem gestartet. Die beiden anderen Anwendungen bleiben unverändert.","hash":"fig_dependency_namespaces_log2","h4":"Abbildung 8.13: Abhängigkeitenbehandlung für Testfall Angebotserstellung durch Anwender C"},"315":{"id":315,"content":"Abbildung 8.14: Abhängigkeitenbehandlung für Testfall Angebot 1 im Archiv prüfen Im vierten Testfall werden die benötigten Abhängigkeiten mit dem vorhandenen Stapel im Namensraum \"Datenerfassung\" aus dem ersten Testfall abgeglichen. Die Abhängigkeitenstapel in den beiden anderen Namensräumen werden nicht betrachtet. Es wird also Anwender A abgemeldet und Anwender B an der Datenerfassung neu angemeldet. Die beiden anderen Anwendungen bleiben unverändert.","hash":"fig_dependency_namespaces_log3","h4":"Abbildung 8.14: Abhängigkeitenbehandlung für Testfall Angebot 1 im Archiv prüfen"},"316":{"id":316,"content":"Abbildung 8.15: Abhängigkeitenbehandlung für Testfall Datenerfassung durch Anwender B Im fünften Testfall werden die benötigten Abhängigkeiten mit dem vorhandenen Stapel im Namensraum \"Datenbanksystem\" aus dem zweiten Testfall abgeglichen. Die Abhängigkeitenstapel in den beiden anderen Namensräumen werden nicht betrachtet. Es wird also Anwender C abgemeldet und Anwender D im Datenbanksystem neu angemeldet. Die beiden anderen Anwendungen bleiben wiederum unverändert.","hash":"fig_dependency_namespaces_log4","h4":"Abbildung 8.15: Abhängigkeitenbehandlung für Testfall Datenerfassung durch Anwender B"},"317":{"id":317,"content":"Abbildung 8.16: Abhängigkeitenbehandlung für Testfall Angebotserstellung durch Anwender D Im letzten Testfall wird die benötigte Abhängigkeit mit dem vorhandenen Stapel im Namensraum \"Dokumentenverwaltung\" aus dem dritten Testfall abgeglichen. Die Abhängigkeitenstapel in den beiden anderen Namensräumen werden nicht betrachtet. Es ergibt sich kein Handlungsbedarf bezüglich Aufräumarbeiten. Die beiden anderen Anwendungen bleiben wiederum unverändert.","hash":"fig_dependency_namespaces_log5","h4":"Abbildung 8.16: Abhängigkeitenbehandlung für Testfall Angebotserstellung durch Anwender D"},"318":{"id":318,"content":"Abbildung 8.17: Abhängigkeitenbehandlung für Testfall Angebot 2 im Archiv prüfen","hash":"fig_dependency_namespaces_log6","h4":"Abbildung 8.17: Abhängigkeitenbehandlung für Testfall Angebot 2 im Archiv prüfen"},"319":{"id":319,"content":"Dokumentieren von Testsuiten Wie jede programmierähnliche Tätigkeit benötigt Testautomatisierung eine gute Dokumentation um langfristig erfolgreich sein zu können. Andernfalls besteht die Gefahr, den Überblick zu verlieren und Dinge unnötigerweise mehrfach zu implementieren oder Tests zu übersehen, die automatisiert werden sollten. Eine gute Dokumentation ist von unschätzbarem Wert, wenn Sie sich auf der Suche nach der Ursache für einen fehlgeschlagenen Test durch ein Protokoll arbeiten. Außerdem trägt sie wesentlich zur Lesbarkeit von Reports bei. Eine gute Möglichkeit, die Tests lesbar zu gestalten und gleichzeitig zu dokumentieren sind die Sequenz und Testschritt Knoten, mit deren Hilfe Sie die aufgenommenen Knoten zusammenfassen und beschriften können. Es steht auch ein Kommentar Knoten zur Verfügung um Erläuterungen einzufügen. Wenn Sie eine Dokumentation erstellen wollen, die auch außerhalb von QF‑Test verfügbar sein soll, so können Sie basierend auf den Bemerkung Attributen von Testfallsatz, Testfall, Package und Prozedur Knoten einen Satz von umfassenden HTML Dokumenten erstellen, welche die benötigten Informationen schnell auffindbar machen. Die verschiedenen Arten von Dokumenten und die Mittel zu ihrer Erstellung werden ausführlich in \"Reports und Testdokumentation\" beschrieben.","hash":"usec_documentation","h1":"Dokumentieren von Testsuiten"},"320":{"id":320,"content":"Pro Handbuch","hash":"","h0":"Projekte | QF‑Test Handbuch"},"321":{"id":321,"content":"Pro Handbuch","hash":"home-link","h0":"Projekte | QF‑Test Handbuch"},"322":{"id":322,"content":"Projekte Projekte schaffen einen besseren Überblick, vereinfachen die Navigation zwischen Testsuiten und bieten einen erweiterten Rahmen für Suchen und Ersetzen. Außerdem kümmert sich QF‑Test automatisch um die durch Include-Beziehungen oder absolute Referenzen entstehenden Abhängigkeiten zwischen Testsuiten im gleichen Projekt (vgl. \"Der Aufruf einer Prozedur in einer anderen Testsuite\"). Viele weitere Funktionen sind bereits implementiert oder in Entwicklung. Technisch gesehen ist ein Projekt in QF‑Test eine Sammlung von Testsuiten mit einem gemeinsamen Wurzelverzeichnis. Es gibt eine 1:1 Beziehung zwischen dem Projekt und seinem Verzeichnis und der Name des Verzeichnisses wird automatisch zum Namen des Projekts. Ein neues Projekt erstellen Sie über das Menü »Datei«-»Neues Projekt...«. Wählen Sie anschließend das Verzeichnis aus. QF‑Test erstellt darin eine Datei namens qftest.qpj, die das Verzeichnis als Projekt kennzeichnet. Daneben können in der Datei auch Optionen und projektspezifische Bibliothekspfade definiert werden wie in \"Die Datei qftest.qpj\" beschrieben.","hash":"usec_projects","h0":"Projekte"},"323":{"id":323,"content":"Unterprojekte Ein Unterprojekt ist ein Unterverzeichnis eines Projekts, welches selbst ein Projekt ist. Testsuiten innerhalb eines Unterprojekts gehören auch zu allen Projekten darüber. Das Projekt einer Testsuite ist das innerste Projekt, zu dem die Suite gehört. Die Automatische Auflösung von Abhängigkeiten umfasst immer das gesamte äußerste Projekt einer Testsuite inklusive aller Unterprojekte.","hash":"usec_projects_subproject","h1":"Unterprojekte"},"324":{"id":324,"content":"Abbildung 9.1: Die Projektansicht","hash":"figure_9.1","h4":"Abbildung 9.1: Die Projektansicht"},"325":{"id":325,"content":"Projektansicht Die Projektansicht mit ein oder mehreren Projekten wird über das Menü »Ansicht«-»Projekte anzeigen« ein oder ausgeschaltet. Der Projektbaum zeigt die Verzeichnishierarchie eines Projekts mit den Testsuiten, beginnend vom Wurzelverzeichnis. Die Hierarchie kann mit Hilfe des Filters oben am Baum eingeschränkt werden, der sich auf die Namen von Testsuiten bezieht. Ein Doppelklick auf eine Testsuite öffnet diese, ebenso wie ein Druck auf die Eingabe Taste. Es können auch mehrere Dateien auf einmal selektiert, oder alle Dateien unterhalb eines Verzeichnisses geladen werden. Die Hierarchie wird regelmäßig komplett aktualisiert, den Zeitabstand hierfür definiert die Option Zeitabstand für automatisches Auffrischen von Projekten (s). Sie können ein Verzeichnis inklusive seiner gesamten Hierarchie jederzeit manuell über das Kontextmenü oder durch Drücken von F5 aktualisieren. Um das Verzeichnis komplett neu einzulesen ohne sich auf die Änderungszeiten der Verzeichnisse zu verlassen, was bei großen Projekten deutlich länger dauern kann, drücken Sie stattdessen Umschalt⁠+⁠F5. Mit der F6 Taste wechseln Sie den Fokus zwischen Testsuite und Projektansicht hin und her. Um schnell von der aktuellen Testsuite zu deren Knoten im Projektbaum zu gelangen, drücken Sie Umschalt⁠+⁠F6. Falls nötig werden Projektansicht und Projektbaum für diese Aktion automatisch geöffnet.","hash":"usec_projects_view","h1":"Projektansicht"},"326":{"id":326,"content":"Die Datei qftest.qpj Die Datei qftest.qpj kennzeichnet das Wurzelverzeichnis eines Projekts. Alle Testsuiten unterhalb dieses Verzeichnisses gehören automatisch zum Projekt, mit Ausnahme derer, die entweder über die projektspezifischen Einträge in der \"Rubrik [exclude]\" oder durch die globale Option Auszuschließende Projektdateien und -verzeichnisse ausgeschlossen werden. Unter \"Einstellungen für Projekte\" finden Sie weitere Informationen über Optionen für Projekte. Im Normalfall ist diese Datei leer. Es können jedoch Eintragungen in verschiedenen Rubriken gemacht werden, die jeweils mit einem Eintrag der Form [Rubrikname] eingeleitet werden. Leerzeilen oder Zeilen beginnende mit \"#\" werden ignoriert. Der Inhalt der Datei qftest.qpj muss im UTF-8-Zeichensatz kodiert sein.","hash":"usec_projects_file","h1":"Die Datei qftest.qpj"},"327":{"id":327,"content":"Rubrik [config] Diese Rubrik beinhaltet Einstellungen für das Projekt mit Einträgen in der Form Name=Wert. Mögliche Einstellungen sind: readgitignore Legt fest, ob Dateien oder Verzeichnisse ausgeschlossen werden sollen, die in einer .gitignore Datei definiert sind (für die Spezifikation des Formats ziehen Sie bitte eine Dokumentation der Versionsverwaltung git heran). Mögliche Werte sind \"true\", \"false\" oder ein Dateiname, der anstelle der .gitignore Datei im Projektverzeichnis gelesen werden soll. Der Standardwert ist \"false\". Die Nutzung einer .gitignore Datei wird empfohlen, wenn ein QF‑Test Projekt mit einem großen Projekt so kombiniert wird, dass viele Dateien darin enthalten sind, die für QF‑Test keine Rolle spielen.","hash":"usec_projects_gitignore","h1":"Rubrik [config]"},"328":{"id":328,"content":"Rubrik [librarypath] In dieser Rubrik können Bibliothekspfade angegeben werden, die nur für das Projekt gelten. Jede Zeile enthält einen Pfad - entweder relativ zum Wurzelverzeichnis des Projekts oder absolut. Für variable Angaben kann ${env:...} oder ${system:...} verwendet werden. Die entsprechenden Werte müssen dann bei der Ausführung des Tests gesetzt sein, zum Beispiel bei ${env:myLibpath} die Umgebungsvariable myLibpath, bei ${system:myLibpath} die Java System-Property myLibpath, siehe auch das Beispiel in \"Beispiel\". Die Bibliothekspfade werden der Reihe nach durchsucht, wenn relative Dateinamen nicht relativ zur aufrufenden Suite aufgelöst werden können. Falls verschachtelte Projekte existieren, werden zuerst die Bibliothekspfade durchsucht, die für das innerste Projekt angegeben sind, dann die des jeweils nächstäußeren Projekts. Falls dies auch keinen Treffer ergibt, werden die Dateien in den globalen Bibliothekspfaden angegeben sind, vgl. Der Aufruf einer Prozedur in einer anderen Testsuite.","hash":"usec_projects_librarypath","h1":"Rubrik [librarypath]"},"329":{"id":329,"content":"Rubrik [exclude] Hier können explizit Dateien und Verzeichnisse angegeben werden, die vom Projekt ausgeschlossen werden sollen. Jede Zeile enthält einen Pfad - entweder relativ zum Wurzelverzeichnis des Projekts oder absolut.","hash":"usec_projects_exclude","h1":"Rubrik [exclude]"},"330":{"id":330,"content":"Rubrik [include] Hier können explizit einzelne Dateien oder Unterverzeichnisse wieder eingeschlossen werden, die in einem Verzeichnis liegen, das über die [excludes]-Rubrik ausgeschlossen wurde. Jede Zeile enthält einen Pfad - entweder relativ zum Wurzelverzeichnis des Projekts oder absolut.","hash":"usec_projects_include","h1":"Rubrik [include]"},"331":{"id":331,"content":"Beispiel [config] gitignore = ../.gitignore # .gitignore-Datei aus dem übergeordneten Verzeichnis berücksichtigen [librarypath] ../myLibFolderOutsideTheProject # Pfad relativ zum Wurzelverzeichnis des Projekts C:/testing/myLibraries # Absoluter Pfad ${env:myLibpath} # Die Umgebungsvariable 'myLibpath' enthält den Wert ${system:myLibpath} # Die Sytem-Property 'myLibpath' enthält den Wert [exclude] scratch # Verzeichnis ausschließen [include] scratch/wichtig.qft # Mit einer Ausnahme Beispiel 9.1: Beispiele für eine Projekt-Konfiguration Verwenden Sie grundsätzlich - auch unter Windows - das '/'-Zeichen als Verzeichnistrenner. QF‑Test verwendet dann zur Laufzeit das korrekte Trennzeichen für das jeweilige System. Dadurch bleiben die Testsuiten auf verschiedenen Systemen lauffähig.","hash":"usec_projects_sample","h1":"Beispiel"},"332":{"id":332,"content":"Pro Handbuch","hash":"","h0":"Standardbibliothek | QF‑Test Handbuch"},"333":{"id":333,"content":"Pro Handbuch","hash":"home-link","h0":"Standardbibliothek | QF‑Test Handbuch"},"334":{"id":334,"content":"Standardbibliothek Die Standardbibliothek qfs.qft, eine Testsuite mit vielen hilfreichen Prozeduren für unterschiedliche Aufgaben, ist Teil der QF‑Test Distribution.","hash":"usec_stdlib","h0":"Standardbibliothek"},"335":{"id":335,"content":"Abbildung 10.1: Standardbibliothek qfs.qft Unter anderem gibt es Prozeduren zum generischen Ansteuern und Prüfen von Komponenten (AWT, Swing, JavaFX, SWT, Web), für den Zugriff auf Dateisysteme und Datenbanken, das Schreiben von Text oder Bildschirmabbildern in Protokoll und Report sowie Aufräummechanismen. Die vollständige Beschreibung aller Packages und Prozeduren, inklusive Parameter und Rückgabewerte, finden Sie in der HTML Dokumentation, die auch über das »Hilfe« Menü in QF‑Test erreichbar ist. Zusätzlich ist die jeweils neueste Version online verfügbar. qfs.qft wird standardmäßig in jeder neu erzeugten Testsuite inkludiert. Da das Verzeichnis der Suite immer im Bibliothekspfad enthalten ist, reicht qfs.qft ohne weitere Pfadangabe in den Inkludierte Dateien des Testsuite Knotens aus. Alle Prozeduren, die sich auf ein SUT beziehen, nutzen die generische Variable $(client) als impliziten Parameter. Stellen Sie sicher, dass diese Variable korrekt gesetzt wird, entweder global, lokal oder als expliziter Parameter im Prozeduraufruf.","hash":"fig_qfsqft","h4":"Abbildung 10.1: Standardbibliothek qfs.qft"},"336":{"id":336,"content":"Pro Handbuch","hash":"","h0":"Skripting | QF‑Test Handbuch"},"337":{"id":337,"content":"Pro Handbuch","hash":"home-link","h0":"Skripting | QF‑Test Handbuch"},"338":{"id":338,"content":"Skripting Das Video 'Skripting in QF‑Test' (Grundlagen) behandelt die Grundlagen des Skriptens. Das Video 'Skripting in QF‑Test' (Fortgeschritten) zeigt weitere Möglichkeiten des Skriptens. Es ist einer der großen Vorteile von QF‑Test, dass komplexe Tests erstellt werden können, ohne eine einzige Zeile Code zu schreiben. Allerdings gibt es Dinge, die sich mit einer GUI alleine nicht bewerkstelligen lassen. Für ein Programm, das Daten in eine Datenbank schreibt, könnte es z.B. sinnvoll sein, zu überprüfen, ob die Daten korrekt geschrieben wurden. Oder man könnte Testdaten aus einer Datenbank oder einer Datei lesen und mit diesen einen Test ausführen. All das und mehr wird mithilfe der mächtigen Skriptsprachen Jython, Groovy und JavaScript ermöglicht. Jython ist von Anfang an dabei, Groovy seit QF‑Test Version 3. Ab Version 4.2 kann man auch JavaScript als Skriptsprache verwenden. Es ist eine Frage des Geschmacks, welcher dieser Sprachen man den Vorzug gibt. Wer jedoch bereits mit Java vertraut ist, wird sich wahrscheinlich eher mit Groovy denn mit Jython anfreunden. Web-Entwickler werden vermutlich JavaScript verwenden. In diesem Kapitel werden zunächst die Grundlagen der Skriptintegration und die in allen Skriptsprachen zur Verfügung stehenden Module beschrieben. Auf die Besonderheiten der Sprachen Groovy-Skripting, Jython-Skripting und JavaScript-Skripting wird in den jeweiligen Abschnitten eingegangen. Die Skriptsprache eines Knotens wird mit dem Attribut Skriptsprache eines Server-Skript- oder SUT-Skript-Knotens festgelegt. Somit können alle drei Sprachen innerhalb einer Testsuite parallel verwendet werden. Welche Sprache als Standard verwendet werden soll, kann über die Optionen Voreingestellte Sprache für Skript-Knoten und Voreingestellte Sprache für Bedingungen eingestellt werden.","hash":"usec_scripting","h0":"Skripting"},"339":{"id":339,"content":"Allgemeines Beim Skripting ist die Herangehensweise von QF‑Test genau umgekehrt zu der anderer GUI Testprogramme. Anstatt den gesamten Test durch ein Skript zu steuern, bettet QF‑Test kleine Skripte in die Testsuite ein. Dies geschieht mithilfe der Knoten Server-Skript und SUT-Skript. Beiden Knoten gemeinsam ist das Attribut Skript für den eigentlichen Programmcode.","hash":"sec_generalscripting","h1":"Allgemeines"},"340":{"id":340,"content":"Abbildung 11.1: Detailansicht eines Server-Skript-Knotens mit Hilfefenster für rc-Methoden Der in QF‑Test integrierte Skripteditor verfügt über ein paar nützliche Eigenschaften, die das Eingeben des Codes erleichtern. Reservierte Schlüsselwörter, eingebaute Funktionen, Standard-Objekttypen, Literale und Kommentare werden farblich hervorgehoben. Innerhalb von Blöcken werden Codezeilen automatisch eingerückt und am Blockende wieder ausgerückt. Mit Hilfe von TAB können auch mehrere markierte Zeilen von Hand ein- oder ausgerückt (Shift⁠+⁠TAB) werden. Das vielleicht - zumindest für den QF‑Test Neuling - wichtigste Feature des integrierten Editors ist jedoch die Eingabehilfe für viele eingebaute Methoden. Gibt man beispielsweise rc. ein (und ggf. zusätzlich einen oder mehrere Anfangsbuchstaben eines Methodennamens) und drückt dann Ctrl⁠+⁠Leertaste, so erscheint ein Popup-Fenster mit den passenden Runcontext Methoden und ihrer Beschreibung (vgl. \"Fortgeschrittenes Skripting (Jython, Groovy und JavaScript)\"). Nach Auswahl einer Methode und anschließender Bestätigung mit Eingabe wird die gewählte Methode in den Skriptcode eingefügt. Drückt man Ctrl⁠+⁠Leertaste nach einem Leerzeichen, wird eine Liste aller Objekte angezeigt, für die Hilfe zur Verfügung steht. Server-Skripte sind für Dinge wie das Berechnen von Variablenwerten oder das Einlesen und Parsen von Testdaten nützlich. SUT-Skripte öffnen dagegen den unbeschränkten Zugang zu den Komponenten des SUT und zu allen anderen Java-Schnittstellen, die das SUT bietet. Ein SUT-Skript könnte z.B. zum Auslesen oder Überprüfen von Werten im SUT verwendet werden, auf die QF‑Test keinen Zugriff hat. Im SUT-Skript-Knoten muss das Attribut Client auf den Namen des SUT Clients gesetzt sein, in dem es ausgeführt werden soll. Server-Skripte werden in jeder Skriptsprache jeweils in einem Interpreter ausgeführt, der in QF‑Test selbst integriert ist, während SUT-Skripte in jeweils einem im SUT integrierten Interpreter laufen. Diese Interpreter sind voneinander unabhängig und haben keine gemeinsamen Zustände. QF‑Test nutzt die RMI Verbindung zum SUT für eine nahtlose Integration der SUT-Skripte in die Testausführung. Über die Menüeinträge »Extras«-»Jython-Konsole«, »Extras«-»Groovy-Konsole« etc. können Sie ein Fenster mit einer interaktiven Kommandozeile für die in QF‑Test eingebetteten Interpreter öffnen. Darin können Sie mit der jeweiligen Skriptsprache experimentieren, um ein Gefühl für die Sprache zu entwickeln, aber auch komplexe Dinge ausprobieren wie z.B. das Herstellen der Verbindung zu einer Datenbank. Mittels Strg⁠+⁠Hoch und Strg⁠+⁠Runter können Sie frühere Eingaben wieder verwenden. Außerdem können Sie beliebige Zeilen in der Konsole bearbeiten oder eine Region markieren und mittels Return an den Interpreter schicken. Dabei filtert QF‑Test die vom Interpreter stammenden '>>>' und '...' Markierungen heraus. Entsprechende Konsolen gibt es auch für SUT-Clients. Diese Konsolen sind über das »Clients«-Menü zugänglich. Wenn Sie in einer SUT-Skripting-Konsole arbeiten, müssen Sie eines beachten: Die Kommandos werden vom Interpreter nicht im Event Dispatch Thread ausgeführt, im Gegensatz zu Kommandos, die in einem SUT-Skripten-Knoten ausgeführt werden. Das sagt Ihnen möglicherweise nichts und meistens stellt es auch kein Problem dar, aber wenn Sie auf Swing- oder SWT-Komponenten zugreifen oder deren Methoden aufrufen, besteht die Gefahr, dass die gesamte Applikation einfriert. Um das zu verhindern stellt QF‑Test die globale Funktion runAWT (bzw. runSWT, runFX, runWeb, runWin, runAndroid und runIOS) zur Verfügung, mit deren Hilfe Sie beliebigen Code im Dispatch Thread ausführen können. Um zum Beispiel die Anzahl der sichtbaren Knoten einer JTree Komponente namens tree zu ermitteln, verwenden Sie runAWT(\"tree.getRowCount()\") (bzw. runAWT { tree.getRowCount() } in Groovy) um ganz sicherzugehen.","hash":"figure_11.1","h4":"Abbildung 11.1: Detailansicht eines Server-Skript-Knotens mit Hilfefenster für rc-Methoden"},"341":{"id":341,"content":"Skriptausdrücke Manchmal ist es hilfreich, in Knotenattributen kleinere Berechnungen oder Textmanipulationen direkt auszuführen. In QF‑Test ist dies an allen Stellen möglich, an denen auch QF‑Test Variablen durch ihre Werte ersetzt werden. Hierzu steht eine besondere Syntax zur Verfügung, über die einzeilige Skriptausdrücke ausgewerten werden können: $[Jython-Ausdruck] wertet den angegebenen Ausdruck im Jython-Interpreter aus. Alternativ kann ${jython:Jython-Ausdruck} verwendet werden. Es sind alle Ausdrücke zulässig, deren Syntax für die Jython Methode eval gültig ist. Um einen Groovy-Ausdruck zu verarbeiten, verwenden Sie ${groovy:Groovy-Ausdruck}, Für einen JavaScript-Ausdruck ${javascript:JavaScript-Ausdruck}. Die Auswertung der Skriptausdrücke erfolgt nach den gleichen Regeln wie für die Skriptknoten, siehe Jython-Skripting, Groovy-Skripting beziehungsweise JavaScript-Skripting. Auch der Zugriff auf QF‑Test Variablen in ${Skriptsprache:Ausdruck} beziehungsweise $[...]-Ausdrücken folgt denselben Regeln wie in den Skripten für die entsprechende Sprache. Vor der Ausführung des Codes werden QF‑Test Variablen im Ausdruck ausgewertet, d.h. die standard QF‑Test Syntax $(...) und ${...:...} kann für numerische und Boolesche Werte verwendet werden. Auf Zeichenketten sollte mittels rc.getStr zugegriffen werden (vgl. \"Variablen\"). Beispiel: In einem Schleife-Knoten ist der Ausdruck $[$(IndexLetzteZeile) + 1] in Anzahl Wiederholungen hilfreich, wenn zuvor die Variable IndexLetzteZeile über den Knoten Index auslesen mit dem Index &-1 für die letzte Zeile (zum Beispiel #List:&-1) gesetzt wurde. Skriptausdrücke können auch gekapselte Objekte zurückgeben. Beispiel: Die Variable myList erhält den Wert $[ [\"Affe\", \"Biber\", \"Chincilla\"] ]. In einem Schleife-Knoten kann man nun $[len(rc.vars.myList)] in Anzahl Wiederholungen angeben. In den Bedingungsfeldern von If, Testfall und Testfallsatz ist diese spezielle Syntax nicht erforderlich. Hier können Skriptausdrücke direkt eingegeben werden.","hash":"sec_script_expressions","h1":"Skriptausdrücke"},"342":{"id":342,"content":"Der Runcontext rc Zur Ausführung von Server-Skripten und SUT-Skripten stellt QF‑Test eine spezielle Umgebung zur Verfügung, zu der u.a. das Runcontext Objekt gehört, das den aktuellen Zustand der Ausführung eines Tests repräsentiert. Auf dieses Objekt kann über die Variable \"rc\", welche in allen Sprachen verfügbar ist, zugegriffen werden. Es bietet Schnittstellen (vollständig dokumentiert in \"Das rc-Modul: Die API des Runcontexts\") für den Zugriff auf QF‑Test Variablen, zum Aufruf von QF‑Test Prozeduren und um Meldungen in das Protokoll zu schreiben. Ein SUT-Skript kann mit seiner Hilfe außerdem auf die echten Java-Komponenten des GUI im SUT zugreifen. Für Fälle, in denen kein Runcontext verfügbar ist, z.B. Resolver, TestRunListener, Code der in einem Hintergrund-Thread ausgeführt wird etc. bietet QF‑Test ein Modul namens qf mit hilfreichen generischen Methoden zum Logging und für andere Zwecke an. Detaillierte Informationen hierzu finden Sie in \"Das qf-Modul\".","hash":"sec_runcontext","h1":"Der Runcontext rc"},"343":{"id":343,"content":"Meldungen ausgeben Ein Einsatzgebiet des Runcontexts ist die Ausgabe beliebiger Meldungen im Protokoll, das QF‑Test für jeden Testlauf erstellt. Diese Meldungen können auch als Warnungen oder Fehler markiert werden. rc.logMessage(\"This is a plain message\") rc.logWarning(\"This is a warning\") rc.logError(\"This is an error\") Beispiel 11.1: Meldungen aus Skripten ausgeben Wird mit kompakten Protokollen gearbeitet (vgl. die Option Kompakte Protokolle erstellen), werden Knoten, die aller Wahrscheinlichkeit nach nicht für eine Fehleranalyse benötigt werden, eventuell aus dem Protokoll entfernt, um Speicher zu sparen. Dies betrifft nicht die Fehlermeldung (rc.logError). Hier wird immer die Meldung selbst und etwa 100 vorhergehende Knoten im Protokoll aufgehoben. Bei einer Warnung rc.logWarning wird auf jeden Fall die Warnung behalten, jedoch keine vorhergehenden Knoten. Normale Meldungen (rc.logMessage) werden gegebenenfalls entfernt. Wenn Sie eine normale Meldung zwingend im Protokoll behalten wollen, können Sie dies über den optionalen zweiten Parameter (dontcompactify) erreichen: rc.logMessage(\"This message will not be removed\", dontcompactify=true) rc.logMessage(\"This message will not be removed\", 1) Beispiel 11.2: Meldungen, die nicht aus kompakten Protokollen entfernt werden","hash":"sec_meldungen_ausgeben","h2":"Meldungen ausgeben"},"344":{"id":344,"content":"Checks durchführen Die Ausgabe einer Meldung ist meist an eine Bedingung geknüpft. Außerdem ist es oft wünschenswert, im XML- oder HTML-Report ein Ergebnis analog zu einem Check-Knoten zu erhalten. Hierzu dienen die Methoden rc.check und rc.checkEqual: x = 0 rc.check(x == 0, \"Value of x is 0\") userlang = rc.getStr(\"system\", \"user.language\") rc.checkEqual(userlang, \"en\", \"English locale required\", rc.EXCEPTION) Beispiel 11.3: Checks durchführen Das optionale letzte Argument legt die Fehlerstufe fest. Hierbei können rc.EXCEPTION, rc.ERROR, rc.OK bzw. rc.WARNING verwendet werden.","hash":"sec_checks_durchfuhren","h2":"Checks durchführen"},"345":{"id":345,"content":"Variablen In QF‑Test gibt es verschiedene Arten von Variablen. Es wird zunächst unterschieden zwischen QF‑Test Variablen, siehe \"Variablen\", und Variablen der Skriptsprachen. Die Variablen der Skriptsprachen wiederum werden unterteilt in Server- und SUT-seitige Variablen des jeweiligen Interpreters. Die folgende Grafik verdeutlicht die Sichtbarkeit der jeweiligen Variablenarten:","hash":"usec_scriptvars","h2":"Variablen"},"346":{"id":346,"content":"Abbildung 11.2: Übersicht über die verschiedenen Variablen in QF‑Test Um in den Skripten mit diesen unterschiedlichen Variablen zu arbeiten und dieses auszutauschen, stellt der Runcontext spezielle Methoden zur Verfügung. Diese Methoden werden in den nachfolgenden Abschnitten erläutert.","hash":"figure_11.2","h4":"Abbildung 11.2: Übersicht über die verschiedenen Variablen in QF‑Test"},"347":{"id":347,"content":"Zugriff auf Variablen Auf Variablen von QF‑Test in einem Skript zuzugreifen ist nicht weiter schwierig. Auf Textvariablen können Sie zum Beispiel mittels der Runcontext-Methode getStr, auf boolsche Werte mittels getBool, auf ganze Zahlen mit getInt, auf numerische Werte mit getNum und auf Datenobjekte mit getObj zugreifen (siehe \"Das rc-Modul: Die API des Runcontexts\" für eine vollständige API-Beschreibung). # access a simple variable text = rc.getStr(\"someText\") # access a property or resource version = rc.getStr(\"qftest\", \"version\") Beispiel 11.4: Zugriff auf Textvariablen mittels rc.getStr","hash":"sub_accessing_variables","h2":"Zugriff auf Variablen"},"348":{"id":348,"content":"Variablen setzen Um die Ergebnisse eines Skripts für die weitere Ausführung eines Tests bekannt zu machen, können Werte in globalen oder lokalen QF‑Test Variablen abgelegt werden. Der Effekt entspricht der Ausführung eines Variable setzen-Knotens. Die entsprechenden Methoden im Runcontext sind rc.setGlobal und rc.setLocal. # Test if the file /tmp/somefile exists from java.io import File rc.setGlobal(\"fileExists\", File(\"/tmp/somefile\").exists()) Beispiel 11.5: Verwendung von rc.setGlobal Nach Ausführung des obigen Skripts wird $(fileExists) in einem Knoten von QF‑Test zu True expandieren, wenn die Datei /tmp/somefile existiert und zu 'false', wenn sie nicht existiert. Um eine Variable zu löschen, setzen Sie deren Wert auf None in Jython bzw. null in Groovy und JavaScript. Mittels rc.clearGlobals() aus einem Server-Skript können alle globalen Variablen gelöscht werden.","hash":"sec_variablen_setzen","h2":"Variablen setzen"},"349":{"id":349,"content":"Globale Skript-Variablen Manchmal ist es hilfreich, eine Skript-Variable in verschiedenen Skriptknoten zur Verfügung zu haben. Falls der Wert der Variablen kein simpler String oder Integer ist, genügt es eventuell nicht, diese mit setGlobal als globale QF‑Test Variable zu definieren, da der Wert beim Zugriff von/einem SUT-Skripte serialisiert werden muss. In solchen Fällen können Sie die Variable zum Beispiel in Jython als global deklarieren, um auf sie aus verschiedenen Knoten oder Prüfausdrücken derselben Skriptsprache zuzugreifen, wie es das folgende Beispiel zeigt. global globalVar globalVar = 10000 Beispiel 11.6: Globale Jython-Variable globalVar steht nun in allen folgenden Jython-Skriptknoten zur Verfügung (in allen Jython-Server-Skripte oder in allen Jython-SUT-Skripte desselben Clients). Um den Wert von globalVar in einem anderen Jython-Skriptknoten zu verändern, ist erneut eine Deklaration mit dem Schlüsselwort global notwendig. Andernfalls wird eine neue lokale Variable mit gleichem Namen erzeugt. Um eine globale Jython Variable zu entfernen, kann die del Anweisung verwendet werden: global globalVar del globalVar Beispiel 11.7: Löschen einer globalen Jython Variable In Groovy und JavaScript werden globale Variablen noch einfacher erzeugt als in Jython. Die Regel lautet, dass undeklarierte Variablen im Binding des Skripts erwartet werden. Sind sie dort nicht zu finden, werden sie automatisch hinzugefügt. myGlobal = 'global' Beispiel 11.8: Definieren von globalen Variablen in Groovy bzw. JavaScript assert myGlobal == 'global' def globals = binding.variables assert globals['myGlobal'] == 'global' globals.remove('myGlobal') assert globals.find { it == 'myGlobal' } == null Beispiel 11.9: Verwenden und entfernen einer globalen Groovy Variablen","hash":"usec_global_variables","h2":"Globale Skript-Variablen"},"350":{"id":350,"content":"Austausch von Variablen zwischen verschiedenen Prozessen Es kommt vor, dass Variablen, die in einem Prozess definiert wurden, später in einem anderen Prozess benötigt werden. So könnte zum Beispiel eine Liste von Werten, die mit Hilfe eines SUT-Skripts aus einer Tabelle gelesen werden, in einem Server-Skript weiterverwendet werden, um darüber zu iterieren. Die einfachste Möglichkeit ist nun, die Liste mit Hilfe von rc.setGlobal oder rc.setLocal in einer QF‑Test Variable zu speichern und später den Inhalt mit rc.getObj abzufragen. Dies funktioniert, sofern der gespeicherte Inhalt serialisierbar ist, die Objekte im anderen Prozess wieder hergestellt werden können, und keine Ausnahme definiert wurde (siehe Von der Serialisierung ausgenommene Objekt-Klassen). Andernfalls liefert rc.getObj automatisch den String-Wert des Objektes zurück - vergleichbar mit rc.getStr. Als Alternative stellt der Runcontext einen symmetrischen Satz von Methoden zum Zugriff auf und zur Modifikation von Skript-Variablen in einem anderen Prozess bereit. Für SUT-Skripte sind dies die Methoden toServer und fromServer. Die entsprechenden Methoden für Server-Skripte heißen toSUT und fromSUT. Dabei müssen die Skript-Knoten jeweils die gleiche Skriptsprache verwenden. Das folgende Jython Beispiel zeigt, wie ein SUT-Skript direkt eine globale Variable im Jython-Interpreter von QF‑Test setzen kann: cellValues = [] table = rc.getStr(\"idOfTable\") for i in range(table.getRowCount()): cellValues.append(table.getValueAt(i, 0)) rc.toServer(tableCells=cellValues) Beispiel 11.10: Setzen einer Server-Variable aus einem SUT-Skript heraus Nach Ausführung des obigen Skripts enthält die globale Variable namens \"tableCells\" in QF‑Test's Jython-Interpreter das Array der Werte aus der Tabelle. Die Tabellenwerte im obigen Beispiel sind nicht notwendigerweise Strings. Sie könnten Zahlen sein, Datumswerte, was auch immer. Leider ist der pickle Mechanismus von Jython nicht mächtig genug, um Instanzen von Java-Klassen zu transportieren (nicht einmal von serialisierbaren), sodass dieser Austauschmechanismus auf primitive Typen wie Strings und Zahlen sowie auf Jython Objekte und Strukturen wie Arrays und Dictionaries beschränkt ist.","hash":"usec_exchanging_vars","h2":"Austausch von Variablen zwischen verschiedenen Prozessen"},"351":{"id":351,"content":"Zugriff auf die GUI-Komponenten des SUT Für SUT-Skripte bietet der Runcontext eine äußerst nützliche Methode. Durch den Aufruf von rc.getComponent(\"componentId\") werden die Informationen aus dem Komponente-Knoten mit der QF‑Test ID \"componentId\" aus der Testsuite geholt und an den Mechanismus zur Wiedererkennung von Komponenten gereicht. Dieser arbeitet genau wie bei der Simulation eines Events, das heißt, er wirft auch die entsprechenden Exceptions, falls die Komponente nicht gefunden werden kann. Im Erfolgsfall wird die Komponente an das Skript zurückgegeben und zwar nicht in Form von abstrakten Daten, sondern das konkrete Objekt. Alle Methoden, die die Java-API der Klasse dieser Komponente zur Verfügung stellt, können ausgeführt werden, um Informationen auszulesen oder um Effekte zu erzielen, die durch das GUI nicht möglich sind. Um eine Liste der Methoden einer Komponente anzuzeigen, siehe \"Komponenten untersuchen\". # get the custom password field field = rc.getComponent(\"tfPassword\") # read its crypted value passwd = field.getCryptedText() rc.setGlobal(\"passwd\", passwd) # get the table component table = rc.getComponent(\"tabAddresses\") # get the number of rows rows = table.getRowCount() rc.setGlobal(\"tableRows\", rows) Beispiel 11.11: Zugriff auf Komponenten mit rc.getComponent Sie können auf diesem Weg auch auf Unterelemente zugreifen. Wenn der Parameter componentId ein Element referenziert, liefert getComponent ein Paar zurück, bestehend aus der Komponente und dem Index des Elements. Der Index kann dazu verwendet werden, den eigentlichen Wert zu ermitteln. Das folgende Beispiel zeigt, wie Sie den Wert einer Tabellenzelle auslesen. Beachten Sie dabei auch die praktische Methode mit der Jython das Auspacken von Sequenzen bei Zuweisungen unterstützt. # first get the table and index table, (row,column) = rc.getComponent(\"tableAddresses@Name@Greg\") # then get the value of the table cell cell = table.getValueAt(row, column) Beispiel 11.12: Zugriff auf Unterelemente mit rc.getComponent","hash":"usec_accessing_components","h2":"Zugriff auf die GUI-Komponenten des SUT"},"352":{"id":352,"content":"Aufruf von Prozeduren Der Runcontext kann auch dazu verwendet werden, Prozeduren in QF‑Test auszuführen. rc.callProcedure(\"text.clearField\", {\"component\" : \"nameField\", \"message\" : \"nameField cleared\"}) Beispiel 11.13: Einfacher Prozeduraufruf in Jython In obigem Beispiel wird die Prozedur namens \"clearField\" im Package namens \"text\" aufgerufen. Die Parameter für den Aufruf sind \"component\" mit dem Wert \"nameField\" und \"message\" mit dem Wert \"nameField cleared\". Dasselbe Beispiel mit der veränderten Groovy Syntax: rc.callProcedure(\"text.clearField\", [\"component\" : \"nameField\", \"message\" : \"nameField cleared\"]) Beispiel 11.14: Einfacher Prozeduraufruf in Groovy Und in JavaScript: rc.callProcedure(\"text.clearField\", {\"component\" : \"nameField\", \"message\" : \"nameField cleared\"}) Beispiel 11.15: Einfacher Prozeduraufruf in JavaScript Der Rückgabewert einer Prozedur, der mittels eines Return-Knotens festgelegt werden kann, ist gleichzeitig der Rückgabewert des rc.callProcedure Aufrufs. In einem SUT-Skript-Knoten sollte rc.callProcedure nur mit großer Vorsicht verwendet werden. Rufen Sie nur Prozeduren mit kurzer Laufzeit auf, die keine allzu komplexen Operationen im SUT auslösen. Andernfalls könnte eine DeadlockTimeoutException verursacht werden. Wenn Daten für datengetriebene Tests zwingend im SUT ermittelt werden müssen, speichern Sie diese mittels rc.setLocal in einer Variable bzw. transferieren Sie diese mittels rc.toServer zu QF‑Test's Interpreter und treiben Sie die Tests dann aus einem Server-Skript-Knoten, für den es keine derartigen Einschränkungen gibt.","hash":"sec_aufruf_von_prozeduren","h2":"Aufruf von Prozeduren"},"353":{"id":353,"content":"Setzen von Optionen Viele der in \"Einstellungen\" beschriebenen Optionen können auch zur Laufzeit via rc.setOption gesetzt werden. Konstanten für die Namen dieser Optionen sind in der Klasse Options definiert, welche in den Skriptsprachen automatisch verfügbar ist. Ein reelles Beispiel, bei dem es sinnvoll ist, eine Option temporär zu setzen, ist die Wiedergabe eines Events auf eine deaktivierte Komponente. Für diesen Sonderfall muss die Überprüfung durch QF‑Test auf den enabled/disabled Zustand verhindert werden. Zum Setzen mit umgehenden Zurücksetzen gibt es die Variante pushOption / popOption, bei der vorhergehende setOption Aufrufe nicht verloren gehen: rc.pushOption(Options.OPT_PLAY_THROW_DISABLED_EXCEPTION, false) Beispiel 11.16: pushOption Nach Abspielen des speziellen Events kann der vorhergehende Wert der Option wiederhergestellt werden, wie in folgendem Beispiel gezeigt: rc.popOption(Options.OPT_PLAY_THROW_DISABLED_EXCEPTION) Beispiel 11.17: popOption Möchte man ganz sicher gehen, dass der Wert korrekt zurückgesetzt wird, sollten die beiden Skript-Knoten in einer Try / Finally Kombination verbaut werden. Andernfalls würde z.B. eine ComponentNotFoundException beim Abspielen des Events das Zurücksetzen verhindern. Achten Sie darauf, dass Sie QF‑Test Optionen immer in einem Server-Skript-Knoten und SUT-Optionen in einem SUT-Skript-Knoten setzen, andernfalls hat die Aktion keinen Effekt. Einige Optionen - speziell für SmartIDs - haben Effekte sowohl auf QF‑Test, als auch auf SUT Seite. Diese müssen in einem Server-Skript-Knoten geändert werden. QF‑Test leitet diese Änderung automatisch an die SUT-Clients weiter. Die Dokumentation der Optionen in \"Einstellungen\" führt für jede Option die betroffene Seite - Server und/oder SUT - auf.","hash":"usec_scripting_options","h2":"Setzen von Optionen"},"354":{"id":354,"content":"Komponenten bei Bedarf explizit setzen Es können Fälle auftreten, in denen Sie eine bestimmte Komponente nicht über einen Komponente-Knoten definieren können, sondern auf Skript-Ebene suchen müssen, um mit dieser arbeiten zu können, sei es, um aus Performance-Gründen dieselbe Komponente mehrfach zu nutzen oder für Spezialfälle in denen die normale Erkennung zu kompliziert oder ineffektiv ist. Für solche Fälle können Sie die Methode rc.overrideElement verwenden, um die gefundene Komponente einer QF‑Test ID oder SmartID zuzuordnen. Anschließend können Sie mit den gewohnten QF‑Test Knoten mit dieser ID arbeiten. Das folgende Beispiel wäre zwar heute mit SmartID sehr einfach zu lösen, ist aber immer noch illustrativ. Für komplexere Fälle bleibt overrideElement weiterhin relevant. Stellen Sie sich vor, wir möchten immer mit dem ersten Textfeld eines Panels arbeiten. Jedoch könnte das einfache Aufzeichnen der Textfelder nicht möglich sein, da sich der Inhalt zu stark ändert. Nun können wir ein Skript implementieren, welches das erste Textfeld sucht. Dann können wir dieses gefundene Textfeld einer Komponente PriorityAwtSwingComponent aus der Standardbibliothek qfs.qft zuordnen. Nachdem wir das Skript ausgeführt haben, können mit der Angabe der QF‑Test ID PriorityAwtSwingComponent alle gewohnten QF‑Test Knoten benutzen um mit dem gefundenen Textfeld zu arbeiten.","hash":"usec_scripting_override","h2":"Komponenten bei Bedarf explizit setzen"},"355":{"id":355,"content":"panel = rc.getComponent(\"myPanel\") for component in panel.getComponents(): if qf.isInstance(component, \"javax.swing.JTextField\"): rc.overrideElement(\"PriorityAwtSwingComponent\", component) break Beispiel 11.18: Jython rc.overrideElement Dieses Konzept ist sehr nützlich, wenn Sie einen Algorithmus kennen, um ihre Zielkomponenten für bestimmte Testschritte zu suchen. Sie können solche (veraltete, s.u.) Priority-Komponenten für alle unterstützten Engines in der Standardbibliothek qfs.qft finden. Ein Beispiel finden Sie auch in Ihrer QF‑Test Installation in der mitgelieferten Testsuite carconfigSwing_advanced_de.qft im Verzeichnis demo/carconfigSwing. Vor der Einführung von SmartIDs musste die QF‑Test ID eines Komponente-Knotens als id Parameter angegeben werden. Bei Verwendung einer SmartID entfällt diese Anforderung. Sie können eine SmartID beliebig wählen, sie muss nur mit # beginnen. Diese Funktion basiert auf einem einfachen String-Vergleich, eventuell gesetzte Scopes gehen auf dieser Ebene nicht ein! Ebenso neu in QF‑Test 7.0 ist die Möglichkeit, überladene Elemente via rc.getOverrideElement auszulesen. Im folgenden Beispiel werden beide Möglichkeiten kombiniert.","hash":"ex_overrideElement","h2":"Komponenten bei Bedarf explizit setzen"},"356":{"id":356,"content":"if not rc.getOverrideElement(\"#FirstTextField\"): panel = rc.getComponent(\"myPanel\") for component in panel.getComponents(): if qf.isInstance(component, \"javax.swing.JTextField\"): rc.overrideElement(\"#FirstTextField\", component) break Beispiel 11.19: Nutzung von rc.overrideElement mit SmartID und Bedingung","hash":"ex_overrideElement_SmartID","h2":"Komponenten bei Bedarf explizit setzen"},"357":{"id":357,"content":"Jython-Skripting Jython basiert auf Python 2 und nicht Python 3. Wenn also in diesem Handbuch nur von \"Python\" ohne genauere Angabe die Rede ist, ist immer Python 2 gemeint. Python ist eine vielseitige, objektorientierte Skriptsprache, die von Guido van Rossum entworfen und in C implementiert wurde. Hilfreiche Informationen zu Python gibt es unter http://www.python.org. Python ist eine standardisierte Sprache und seit vielen Jahren etabliert. Umfassende Dokumentation dazu ist frei verfügbar, daher beschränkt sich dieses Handbuch darauf, die Integration von Jython in QF‑Test zu erklären. Die Sprache selbst ist sehr natürlich und intuitiv. Ihre größte Stärke ist die Verständlichkeit und Lesbarkeit von Python-Skripten. Daher sollten Sie keine Probleme haben, die folgenden Beispiele zu verstehen. Jython (früher JPython genannt) ist eine Implementierung von Version 2 der Programmiersprache Python in Java. Jython hat dieselbe Syntax wie Python und verfügt über beinahe identische Features. Die Objektsysteme von Java und Jython haben vieles gemeinsam und Jython kann nahtlos in Anwendungen wie QF‑Test integriert werden. Das macht es zu einem äußerst nützlichen Werkzeug für Java-Skripting. Jython hat seine eigene Homepage unter http://www.jython.org. Dort gibt es unter anderem auch ein ausführliches Tutorial zum Einstieg. QF‑Test verwendet die Jython Version 2.7, die einen Großteil der Standard Python 2 Bibliothek unterstützt. Die Skriptsprache Jython wird in QF‑Test nicht nur in Server-Skript und SUT-Skript Knoten verwendet, sondern auch in $[...]-Ausdrücken und standardmäßig zur Auswertung von Bedingungen wie im Attribut Bedingung von If-Knoten.","hash":"usec_jythonbasics","h1":"Jython-Skripting"},"358":{"id":358,"content":"Jython-Variablen In Jython-Skripten werden QF‑Test Variablenreferenzen der Form $(var) oder ${Gruppe:Name} vor Ausführung des Skripts expandiert. Dies kann zu unerwünschten Effekten führen, insbesondere wenn die Werte dieser Variablen Zeilenumbrüche oder Rückstriche (\\) enthalten. Es sollten stattdessen die Methoden rc.getStr() und rc.getObj() etc. (vgl. \"Zugriff auf Variablen\") oder rc.vars und rc.groups (vgl. \"Referenzierung von Variablen in Skripten und Skriptausdrücken\") verwendet werden, die erst während der Ausführung des Skripts ohne Risiko evaluiert werden.","hash":"usec_jython_vars","h2":"Jython-Variablen"},"359":{"id":359,"content":"Jython-Module Module für Jython in QF‑Test sind nichts anderes als gewöhnliche Python-Module. Sie können Module in QF‑Test importieren und deren Methoden aufrufen, was die Entwicklung komplexer Skripte stark vereinfacht und außerdem die Wartbarkeit Ihrer Tests erhöht, da Module testsuiteübergreifend verfügbar sind. Module, die Sie für mehrere Testsuiten zur Verfügung stellen wollen, sollten Sie im jython Verzeichnis unter QF‑Tests Wurzelverzeichnis ablegen. Module, die speziell für eine Testsuite geschrieben sind, können auch direkt im selben Verzeichnis wie die Testsuite liegen. Das versionsspezifische Verzeichnis qftest-10.0.2-pro/jython/Lib ist für mitgelieferte Module reserviert. Jython-Module haben die Endung .py. Das folgende Beispiel zeigt ein Jython-Modul, das eine Prozedur zur Verfügung stellt, die eine Liste von Zahlen sortiert: def insertionSort(alist): for index in range(1,len(alist)): currentvalue = alist[index] position = index while position>0 and alist[position-1]>currentvalue: alist[position]=alist[position-1] position = position-1 alist[position]=currentvalue Beispiel 11.20: Das Jython-Modul pysort.py Das folgende Jython-Skript ruft die im Modul definierte Prozedur auf. import pysort alist = [54,26,93,17,77,31,44,55,20] pysort.insertionSort(alist) print(alist) Beispiel 11.21: Jython-Skript mit Verwendung eines Moduls","hash":"sec_jython_module","h2":"Jython-Module"},"360":{"id":360,"content":"Post-mortem Fehleranalyse von Jython-Skripten In Python gibt es einen einfachen zeilenorientierten Debugger namens pdb. Zu seinen nützlichen Features gehört die Möglichkeit zu analysieren, warum ein Skript mit einer Exception fehlgeschlagen ist. In Python können Sie hierzu einfach nach einer Exception das pdb Modul importieren und pdb.pm() ausführen. Damit gelangen Sie in eine Debugger-Umgebung in der Sie die Werte der Variablen zum Zeitpunkt des Fehlers betrachten und auch den Call-Stack hinauf navigieren können um dort weitere Variablen zu analysieren. Das Ganze ist vergleichbar mit der Analyse eines Core-Dump einer C-Anwendung. Obwohl Jython den pdb Debugger grundsätzlich unterstützt, funktioniert er aus verschiedenen Gründen in QF‑Test nicht besonders gut, aber immerhin ist die post-mortem Analyse von Skripts über die Jython-Konsolen möglich. Nach einem fehlgeschlagenen Server-Skript-Knoten öffnen Sie QF‑Test's Jython-Konsole, für ein gescheitertes SUT-Skript die Jython-Konsole des entsprechenden SUT, und geben dort einfach debug() ein. Dies sollte denselben Effekt wie das oben beschriebene pdb.pm() haben. Weitere Informationen zum Python-Debugger entnehmen Sie bitte der Python-Dokumentation. Eine Schritt-für-Schritt-Anleitung, wie Jython-Scripte in QF‑Test mit externen Werkzeugen debugged werden können, finden Sie in unserem Blogartikel Wie kann man Jython Scripts in QF‑Test debuggen? .","hash":"usec_jythondebug","h2":"Post-mortem Fehleranalyse von Jython-Skripten"},"361":{"id":361,"content":"Boolean-Typ Jython hat einen echten Boolean-Typ mit den Werten True und False. In älteren Versionen dienten die Integer-Werte 0 und 1 als Boolean-Werte. Dies kann zu Problemen führen, wenn das Ergebnis eines Aufrufs wie file.exists() einer QF‑Test Variable zugewiesen wird, z.B. \"fileExists\", und später in einem Bedingung-Attribut in der Form $(fileExists) == 1 ausgewertet wird. Derartige Bedingungen sollten grundsätzlich in der einfachen Form $(fileExists) bzw. rc.getBool(\"fileExists\") geschrieben werden, die mit allen Jython-Versionen funktioniert.","hash":"sec_boolean_typ","h2":"Boolean-Typ"},"362":{"id":362,"content":"Jython Strings und Zeichenkodierung Zusammenfassung und Hinweise Zeichen in Jython Literalen wie \"abc\" waren auf 8 Bit limitiert, was zu Problemen bei Verwendung von internationalen Zeichen führte. QF‑Test Version 5.3 ermöglicht die Verwendung von internationalen Zeichen in Jython Skripten und Bedingung Attributen basierend auf der Option Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java). Falls Sie QF‑Test erst seit Version 5.3. oder höher verwenden, ist diese Option standardmäßig aktiv. Ein kleiner Teil von bestehenden Skripten muss beim Umschalten auf Unicode Literale angepasst werden. Daher bleibt die Option zunächst deaktiviert, falls QF‑Test eine bestehende ältere Systemkonfiguration antrifft. Es wird wärmstens empfohlen, diese Option zu aktivieren. Der Abschnitt \"Problembehandlung\" weiter unten erklärt, was im Fall von dadurch auftretenden Problemen zu tun ist. Wenn Jython Unicode Literale aktiviert sind, sollte für maximale Flexibilität die Option Standard-Zeichenkodierung für Jython auf \"utf-8\" gesetzt werden. Unabhängig von den eingestellten Option sollte vor allen Dingen die Expansion von QF‑Test Variablen in Literalen verhindert werden. Ausdrücke der Form \"$(somevar)\" können zu Syntaxfehlern oder unerwarteten Ergebnissen führen, wenn der Wert der Variable Zeilenumbrüche oder Rückstriche ('\\') enthält. Verwenden Sie stattdessen rc.getStr(\"somevar\"). Hintergründe und Werdegang von Jython in QF‑Test Alle Java-Strings sind Sequenzen von 16-Bit Zeichen. Jython kennt hingegen zwei Arten von Strings: 8-Bit Byte-Strings (type <str>) und 16-Bit Unicode-Strings (type <unicode>). Der überwiegende Anteil von Strings in QF‑Test Jython Skripten sind entweder Konstante Zeichenketten wie \"abc\", genannt Literale, oder Java-Strings, die nach Jython konvertiert werden, wie das Ergebnis von rc.getStr(\"varname\"). Die Konvertierung aus Java führt immer zu 16-Bit Unicode-Strings. Für Literale hängt das Ergebnis von der Option Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java) ab. Wenn Unicode und Byte-Strings verglichen oder zusammengefügt werden, muss Jython eine Form in die andere konvertieren. Die Konvertierung von Unicode zu Byte-Strings heißt Enkodierung, die umgekehrte Richtung Dekodierung. Es gibt viele verschiedene Wege, 16-Bit Strings in 8-Bit Sequenzen zu kodieren und die Regeln dafür heißen Zeichenkodierung. Typische Beispiele hiefür sind \"utf-8\" oder \"latin-1\". Die Option Standard-Zeichenkodierung für Jython legt fest, welche Kodierung Jython verwenden soll, wenn keine explizite angegeben ist. Aus Kompatibilitätsgründen war vor QF‑Test 5.3 der Standardwert \"latin-1\". Inzwischen ist er \"utf-8\", weil diese Kodierung flexibler ist und alle internationalen Zeichensätze unterstützt. Jython in QF‑Test basiert auf Python Version 2. In früheren Python Versionen bestanden Strings stets aus 8-Bit Zeichen. Später kamen Unicode-Strings mit 16-Bit Zeichen hinzu. In Python 2 sind Literale wie \"abc\" 8-Bit Byte-Strings, das Voransetzen von 'u', also u\"abc\" macht daraus Unicode-Strings. In Python 3 sind Literale bereits Unicode-Strings und können durch Voransetzen von 'b', also b\"abc\" zu Byte-Strings gemacht werden. In Jython 2.2 wurden Java-Strings in 8-Bit Python-Strings konvertiert, basierend auf der Standard-Zeichenkodierung der Java-VM, in der westlichen Hemisphäre üblicherweise ISO-8859-1 (auch als latin-1 bekannt). Seit Jython 2.5 werden Java Strings grundsätzlich als Unicode Jython Strings interpretiert. Zusammen mit 8-Bit String-Literalen führt dies zu viel implizierter Konvertierung zwischen Byte-Strings und Unicode-Strings, z.B. wenn ein - nun als Unicode interpretierter - Java-String und ein Literal verknüpft werden, wie in rc.getStr(\"path\") + \"/file\". Vor QF‑Test Version 5.3 hatten Jython Skripte durch die Art, wie der Code von QF‑Test an den Jython Compiler übergeben wurde, weitere Probleme mit Zeichen außerhalb des 8-Bit Bereichs. Im Zuge der Behebung dieser Probleme stellte es sich heraus, dass der beste Weg zur Behebung der Problem mit Jython String-Literalen die Adaption eines bereits in Python 2 vorhanden Features ist, nämlich from future import unicode_literals, um Jython Literale in QF‑Test generell als Unicode-Strings zu behandeln. Dadurch sind String-Literale nun in allen Skriptsprachen von QF‑Test einheitlich und voll kompatibel mit Java-Strings, so dass die Interaktion zwischen Jython und allem anderen in QF‑Test viel natürlicher wird. Die neue Option Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java) bestimmt, ob String-Literale in Jython als Unicode-Strings behandelt werden. Aus Kompatibilitätsgründen bleibt es bei 8-Bit Byte-Strings, falls QF‑Test beim Start auf eine ältere bestehende Systemkonfiguration trifft, andernfalls sind Unicode Literale nun der Standard. Die empfohlenen Einstellungen für die Jython Optionen sind aktiviert für Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java) und \"utf-8\" für Standard-Zeichenkodierung für Jython.","hash":"usec_jythonstrings","h2":"Jython Strings und Zeichenkodierung"},"363":{"id":363,"content":"Behandlung von Problemen mit Jython und Zeichenkodierungen Wie in den vorherigen Abschnitten beschrieben, verfügt Jython über zwei Arten von Strings, <type 'str'> für 8-Bit Byte-Strings und <type 'unicode'> für 16-Bit Unicode-Strings. Literale kann ein 'b' vorangestellt werden (b\"abc\") um Byte-Strings zu erhalten und ein 'u' (u\"abc\") für Unicode-Strings. Nicht näher gekennzeichnete Literale (\"abc\") sind Unicode, falls die Option Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java) aktiviert ist, andernfalls Byte-Strings. Java-Strings aus einem Java-Funktionsaufruf wie rc.getStr(\"somevar\") sind immer Unicode-Strings. Die folgenden Hinweise sollten Ihnen dabei helfen, Probleme mit Jython und Zeichenkodierungen zu minimieren: Schalten Sie die Option Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java) ein und setzen Sie die Option Standard-Zeichenkodierung für Jython auf \"utf-8\". String-Literale mit $()-Expansion wie \"$(varname)\" waren immer schon problematisch und sollten durch rc.getStr(\"varname\") oder rc.vars.varname ersetzt werden. Strings mit Windows-Dateinamen brauchen wegen der enthaltenen Rückstriche ('\\') spezielle Behandlung. In 8-Bit-Strings werden Rückstriche beibehalten, wenn sie keine Sonderfunktion wie '\\t' für Tab oder '\\n' für einen Zeilenumbruch haben. In 16-Bit-Strings gibt es wesentlich mehr sogenannte Escape-Sequenzen mit besonderer Bedeutung, die zu Syntaxfehlern oder unerwarteten Ergebnissen führen können. Probleme können durch Verwendung von rc.getStr(\"filename\") oder rc.vars.filename (siehe oben) und Voranstellen von 'r' (für \"raw string\") bei Angabe von Literalen, z.B. qftestDir = r\"C:\\Program Files\\QFS\\QF‑Test\", vermieden werden. Verwenden Sie grundsätzlich qf.println anstelle von print ..., da letzteres durch einen 8-Bit-Stream mit der Standardkodierung von Java (und im Falle eines SUT-Skript-Knotens zusätzlich mit der des Betriebssystems) durchgeschleift wird und dadurch internationale Zeichen leicht verloren gehen. Die Konvertierung von Objekten in Strings wurde in Jython traditionell via str(some_object) vorgenommen. Da str der Typ von Byte-Strings ist, erzeugt dies immer einen Byte-String und erzwingt damit Enkodierung. Wenn Sie nicht ausdrücklich einen Byte-String benötigen, sollten Sie stattdessen unicode(some_object) verwenden. Das Jython-Modul types beinhaltet die Konstanten types.StringType und types.UnicodeType sowie die Liste types.StringTypes mit beiden Typen. Letztere ist sehr hilfreich, um zu prüfen, ob ein Objekt von irgendeinem String-Typ ist, egal ob 8-Bit oder 16-Bit. Statt if type(some_object) == types.StringType sollte lieber if type(some_object) in types.StringTypes verwendet werden. In den wenigen Fällen, in denen Sie wirklich ein 8-Bit Byte-String Literal benötigen, setzen Sie ein 'b' voran, z.B. array.array(b'i', [1, 2, 3]) Und natürlich ist unser Support immer für Sie da.","hash":"usec_jythonstrings_troubleshooting","h2":"Jython Strings und Zeichenkodierung"},"364":{"id":364,"content":"Den Namen einer Java-Klasse ermitteln Diese einfache Operation ist in Jython überraschend schwierig. Bei einem gegebenen Java Objekt würde man den Namen der Klasse einfach mittels obj.getClass().getName() bestimmen. Für manche Objekte funktioniert das auch in Jython, für andere scheitert es mit einer kryptischen Fehlermeldung, was recht frustrierend sein kann. Es geht immer dann schief, wenn die Klasse selbst auch eine getName Methode implementiert. Dies ist für AWT Component der Fall, so dass es für alle AWT/Swing Komponenten schwierig ist, den Namen ihrer Klasse zu ermitteln. Die einzige Lösung, die zuverlässig funktioniert ist: from java.lang import Class Class.getName(obj.getClass()) Da der Code nicht gerade intuitiv ist, haben wir ein neues Modul namens qf mit praktischen Methoden initiiert. Es ist automatisch verfügbar, so dass Sie nun einfach folgendes schreiben können: qf.getClassName(obj).","hash":"sec_den_namen_einer_java_klasse_ermitteln","h2":"Den Namen einer Java-Klasse ermitteln"},"365":{"id":365,"content":"Ein komplexes Beispiel Wir schließen diesen Abschnitt mit einem komplexen Beispiel ab, das Features von Jython und QF‑Test kombiniert, um einen datengetriebenen Test durchzuführen. Wir gehen für dieses Beispiel von einer einfachen Tabelle mit den drei Spalten \"Name\", \"Age\" und \"Address\" aus, die mit Werten gefüllt werden soll, die aus einer Datei gelesen werden. Die Datei soll dabei im \"Comma-Separated-Values\" Format vorliegen, mit '|' als Trennzeichen, eine Zeile pro Tabellenzeile, z.B.: John Smith|45|Some street, some town Julia Black|35|Another street, same town Das Beispiel testet die Funktionalität des SUT neue Tabellenzeilen zu erstellen. Dabei kommt eine QF‑Test Prozedur zum Einsatz, die 3 Parameter erwartet - \"name\", \"age\" und \"address\" - und mit diesen eine neue Tabellenzelle anlegt und füllt. Im Jython-SUT-Skript wird die Datei mit den Werten eingelesen und geparst. In einer Schleife wird über die Datensätze iteriert und für jede zu erstellende Tabellenzeile die Prozedur aufgerufen. Der Name für die Datei wird in der QF‑Test Variable namens \"filename\" übergeben. Wenn das Füllen der Tabelle abgeschlossen ist, wird der Endzustand der Tabelle mit den eingelesenen Werten verglichen, um sicher zu gehen, dass alles geklappt hat.","hash":"sec_ein_komplexes_beispiel","h2":"Ein komplexes Beispiel"},"366":{"id":366,"content":"import string data = [] # read the data from the file fd = open(rc.getStr(\"filename\"), \"r\") line = fd.readline() while line: # remove whitespace line = string.strip(line) # split the line into separate fields # and add them to the data array if len(line) > 0: data.append(string.split(line, \"|\")) line = fd.readline() # now iterate over the rows for row in data: # call a qftest procedure to create # one new table row rc.callProcedure(\"table.createRow\", {\"name\": row[0], \"age\": row[1], \"address\": row[2]}) # verify that the table-rows have been filled correctly table = rc.getComponent(\"tabAddresses\") # check the number of rows if table.getRowCount() != len(data): rc.logError(\"Row count mismatch\") else: # check each row for i in range(len(data)): if str(table.getValueAt(i, 0)) != data[i][0]: rc.logError(\"Name mismatch in row \" + str(i)) if str(table.getValueAt(i, 1)) != data[i][1]: rc.logError(\"Age mismatch in row \" + str(i)) if str(table.getValueAt(i, 2)) != data[i][2]: rc.logError(\"Address mismatch in row \" + str(i)) Beispiel 11.22: Ein datengetriebener Test Natürlich dient obiges Beispiel nur zur Anschauung. Es ist viel zu komplex, um halbwegs komfortabel in QF‑Test editiert werden zu können. Außerdem sind zu viele Dinge fest verdrahtet, so dass es mit der Wiederverwendbarkeit nicht weit her ist. Für eine echte Anwendung würde man den Code zum Einlesen und Parsen der Datei parametrisieren und in ein Modul auslagern, ebenso den Code zur Verifikation der Tabelle. Dies geschieht im folgenden Jython-Skript mit den Methoden loadTable zum Lesen der Daten aus der Datei und verifyTable zum Überprüfen der Tabelle. Es wird in einem Modul namens csvtable.py abgespeichert. Ein Beispiel dafür finden Sie in qftest-10.0.2-pro/doc/tutorial/csvtable.py. Zur Erläuterung genügt folgende vereinfachte Version: import string def loadTable(file, separator=\"|\"): data = [] fd = open(file, \"r\") line = fd.readline() while line: line = string.strip(line) if len(line) > 0: data.append(string.split(line,separator)) line = fd.readline() return data def verifyTable(rc, table, data): ret = 1 # check the number of rows if table.getRowCount() != len(data): if rc: rc.logError(\"Row count mismatch\") return 0 # check each row for i in range(len(data)): row = data[i] # check the number of columns if table.getModel().getColumnCount() != len(row): if rc: rc.logError(\"Column count mismatch \" + \"in row \" + str(i)) ret = 0 else: # check each cell for j in range(len(row)): val = table.getModel().getValueAt(i, j) if str(val) != row[j]: if rc: rc.logError(\"Mismatch in row \" + str(i) + \" column \" + str(j)) ret = 0 return ret Beispiel 11.23: Schreiben eines Moduls Der obige Code sollte Ihnen bekannt vorkommen. Er ist eine verbesserte Version von Teilen von \"Ein datengetriebener Test\". Ist dieses Modul installiert, vereinfacht sich der Code, der in QF‑Test geschrieben werden muss, wie folgt: import csvtable # load the data data = csvtable.loadTable(rc.getStr(\"filename\")) # now iterate over the rows for row in data: # call a qftest procedure to create # one new table row rc.callProcedure(\"table.createRow\", {\"name\": row[0], \"age\": row[1], \"address\": row[2]}) # verify that the table-rows have been filled correctly table = rc.getComponent(\"tabAddresses\") csvtable.verifyTable(rc, table, data) Beispiel 11.24: Aufruf von Methoden in einem Modul","hash":"ex_data_driven","h2":"Ein komplexes Beispiel"},"367":{"id":367,"content":"Groovy-Skripting Groovy ist eine weitere etablierte Skriptsprache für die Java-Platform. Sie wurde von James Strachan and Bob McWhirter im Jahre 2003 entwickelt. Im Grunde ist alles was man für Groovy braucht, eine Java-Laufzeitumgebung (JRE) und die Datei groovy-all.jar. Diese Bibliothek enthält sowohl einen Compiler, um Java .class Dateien zu erstellen, wie auch die entsprechende Laufzeitumgebung, um diese Klassen in der Java Virtual Machine (JVM) auszuführen. Man kann sagen, Groovy ist Java mit einer zusätzlichen .jar Datei. Im Gegensatz zu Java ist Groovy allerdings eine dynamische Sprache, was bedeutet, dass das Verhalten von Objekten erst zur Laufzeit ermittelt wird. Außerdem können Klassen auch direkt aus dem Skriptcode geladen werden, ohne erst Class-Dateien erzeugen zu müssen. Schließlich lässt sich Groovy auch leicht in Java-Anwendungen wie QF‑Test einbetten. Die Groovy Syntax ist ähnlich der von Java, vielleicht ausdrucksstärker und leichter zu lesen. Wenn man von Java kommt, kann man sich dem Groovy Stil nach und nach annähern. Wir können hier natürlich nicht die Sprache Groovy in allen Details besprechen, dazu sei auf die Groovy Homepage http://groovy-lang.org/ oder das exzellente Buch \"Groovy in Aktion\" von Dierk Koenig u.a. verwiesen. Vielleicht können aber die folgenden Hinweise einem Java-Programmierer beim Einstieg in Groovy helfen. Das Semikolon ist optional, solange eine Zeile nur ein Statement enthält. Klammern sind manchmal optional, zum Beispiel bedeutet println 'hello qfs' dasselbe wie println('hello qfs'). Anstelle von for (int i = 0; i < len; i++) { ... } verwende man for (i in 0..<len) { ... }. Die folgenden Importe werden bei Groovy standardmäßig vorgenommen: java.lang.*, java.util.*, java.io.*, java.net.*, groovy.lang.*, groovy.util.*, java.math.BigInteger, java.math.BigDecimal. Alles ist ein Objekt, sogar Integer oder Boolean Werte wie '1' oder 'true'. Anstelle von Getter- und Setter-Methoden wie obj.getXxx() kann man einfach obj.xxx verwenden. Der Operator == prüft auf Gleichheit statt auf Identität, so dass Sie if (somevar == \"somestring\") statt if (somevar.equals(\"somestring\")) verwenden können. Um auf Identität zu prüfen, gibt es die Methode is(). Variablen haben einen dynamischen Typ, wenn sie mit dem Schlüsselwort def deklariert werden. def x = 1 zum Beispiel erlaubt es, der Variablen x später auch einen String zuzuweisen. Arrays werden etwas anders als in Java definiert, z. B. int[] a = [1, 2, 3] oder def a = [1, 2, 3] as int[]. Mit def a = [1, 2, 3] wird in Groovy eine Liste definiert. Groovy erweitert die Java-Bibliothek indem für viele Klassen zusätzliche Methoden definiert werden. So kann in einem Groovy-Skript etwa die Methode isInteger() auf ein String Objekt angewendet werden. Diese Erweiterungen werden als GDK bezeichnet (analog zu JDK in Java). Eine Liste der GDK-Methoden für ein Objekt obj liefert der Ausdruck obj.class.metaClass.metaMethods.name oder - übersichtlicher - das folgende Beispiel: import groovy.inspect.Inspector def s = 'abc' def inspector = new Inspector(s) def mm = inspector.getMetaMethods().toList().sort() { it[Inspector.MEMBER_NAME_IDX] } for (m in mm) { println(m[Inspector.MEMBER_TYPE_IDX] + ' ' + m[Inspector.MEMBER_NAME_IDX] + '(' + m[Inspector.MEMBER_PARAMS_IDX] + ')') } Beispiel 11.25: GDK-Methoden für ein String Objekt Innere Klassen werden nicht unterstützt. In den meisten Fällen können stattdessen Closures verwendet werden. Eine Closure ist ein Object, das einen Code-Schnipsel repräsentiert. Sie kann Parameter haben und auch ein Wert zurückliefern. Genau wie ein Block wird eine Closure in geschweiften Klammern definiert. Blöcke gibt es nur im Zusammenhang mit class, interface, statischer oder Objekt-Initialisierung, Methodenrümpfen, if, else, synchronized, for, while, switch, try, catch und finally. Jedes andere Vorkommen von {...} ist eine Closure. Als Beispiel schauen wir uns die GDK-Methode eachFileMatch der Klasse File an. Sie hat zwei Parameter: einen Filter (z. B. ein Pattern Objekt) und eine Closure. Diese Closure hat selbst auch einen Parameter: ein File Object, das die gerade gefundene Datei repräsentiert. def dir = rc.getStr('qftest', 'suite.dir') def pattern = ~/.*\\.qft/ def files = [] new File(dir).eachFileMatch(pattern) { file -> files.add(file.name) } files.each { // Auf ein einzelnes Closure-Argument kann mit \"it\" zugegriffen werden. rc.logMessage(it) } Beispiel 11.26: Closures Mit Listen (List) und Dictionaries (Map) lässt es sich in Groovy viel leichter arbeiten als in Java. def myList = [1, 2, 3] assert myList.size() == 3 assert myList[0] == 1 myList.add(4) def myMap = [a:1, b:2, c:3] assert myMap['a'] == 1 myMap.each { this.println it.value } Beispiel 11.27: Listen und Dictionaries","hash":"usec_groovy","h1":"Groovy-Skripting"},"368":{"id":368,"content":"Groovy Packages Genau wie Java-Klassen werden Groovy-Skriptdateien (.groovy) in Packages organisiert. Diejenigen, welche suiteübergreifend Anwendung finden, stellt man am besten in den groovy-Ordner unterhalb des QF‑Test Wurzelverzeichnisses. Dateien bzw. Packages, die speziell für eine Testsuite entwickelt worden sind, können auch im Verzeichnis der Testsuite abgelegt werden. Das versionsspezifische Verzeichnis qftest-10.0.2-pro/groovy ist für Groovy-Dateien reserviert, die von Quality First Software GmbH bereitgestellt werden. package my class MyModule { public static int add(int a, int b) { return a + b } } Beispiel 11.28: MyModule.groovy Die Datei MyModule.groovy könnte etwa im Unterverzeichnis my unterhalb des Testsuite-Verzeichnisses abgespeichert werden. Die Methode add aus MyModule kann dann folgendermaßen aufgerufen werden: import my.MyModule as MyLib assert MyLib.add(2, 3) == 5 Beispiel 11.29: Using MyModule Dieses Beispiel demonstriert gleichzeitig noch ein weiteres Groovy Feature: Type Aliasing. Indem import und as zusammen verwendet werden, kann man eine Klasse über einen Namen eigener Wahl referenzieren.","hash":"sec_groovy_packages","h2":"Groovy Packages"},"369":{"id":369,"content":"JavaScript-Skripting JavaScript hat sich vor allem im Bereich der Webentwicklung durchgesetzt und ist dort eine sehr beliebte Programmiersprache. QF‑Test unterstützt ECMAScript, das entwickelt wurde um einen Standard für JavaScript bereitzustellen. Um JavaScript verwenden zu können muss QF‑Test mindestens mit Java 8 ausgeführt werden. Dabei muss der ECMAScript 6 Standard in den JavaScript-Skripten verwendet werden. QF‑Test führt automatisch eine interne Übersetzung auf den ECMAScript 5 Standard durch. Im Fehlerfall wird der übersetzte Code im Protokoll im Skript-Knoten aufgeführt, falls dieser vom Original-Code abweicht. Einige Besonderheiten von JavaScript gegenüber anderen Skriptsprachen. Es gibt zwei verschiedene null-Werte: undefined und null. Eine Variable ist undefined, wenn sie keinen Wert besitzt. null ist ein beabsichtigter Null-Wert der zugewiesen werden muss. Der Operator == prüft auf Gleichheit statt auf Identität, so dass if (3 == \"3\") \"true\" ergibt. Um auf Identität, dass heißt Gleichheit von Typ und Wert beider Operanten, zu prüfen, gibt es den === Operator. Variablen haben einen dynamischen Typ, wenn sie mit dem Schlüsselwort let deklariert werden. let x = 1 zum Beispiel erlaubt es, der Variablen x später auch einen String zuzuweisen. Konstanten werden mit const definiert.","hash":"usec_javascript","h1":"JavaScript-Skripting"},"370":{"id":370,"content":"JavaScript-Module Auch in JavaScript können häufig benötigte Funktionen in Module ausgelagert werden. Diese müssen analog zu Jython bzw. Groovy in das javascript-Verzeichnis im QF‑Test Wurzelverzeichnis gelegt werden. Im folgenden Beispiel werden die Funktionen des Moduls moremath.js ausgelagert. Zunächst der Aufbau des Moduls: var fibonacci = function(n) { return n < 1 ? 0 : n <= 2 ? 1 : fibonacci(n - 1) + fibonacci(n - 2); } function sumDigits(number) { var str = number.toString(); var sum = 0; for (var i = 0; i < str.length; i++) { sum += parseInt(str.charAt(i), 10); } return sum; } // Module exports (Node.js style) exports.fibonacci = fibonacci; exports.sumDigits = sumDigits; Beispiel 11.30: Das Modul moremath.js In dem Modul moremath.js sind zwei Funktionen definiert: fibonacci und sumDigits. fibonacci berechnet den Wert der Fibonacci-Zahl an der Stelle n und sumDigits bildet die Quersumme. Jede Funktion muss exportiert werden, damit sie für den Import zur Verfügung steht. Dies geschieht mit der an Node.js angelehnten Funktion exports. Im Skript-Knoten kann nun der folgende Code verwendet werden um auf die Funktionen des Moduls moremath.js zuzugreifen: moremath = require('moremath'); console.log(moremath.fibonacci(13)); console.log(moremath.sumDigits(123)); Beispiel 11.31: Verwendung des moremath.js-Moduls Module die von QF‑Test bereitgestellt werden, können über die import-Funktion importiert werden. import {Autowin} from 'autowin'; Autowin.doClickHard(10, 10, true); Beispiel 11.32: Verwendung des autowin-Moduls Java-Klassen können ebenfalls über das import Statement importiert werden. import {File} from 'java.io'; Beispiel 11.33: Import von Java-Klassen Es ist auch möglich, mit der require-Funktion npm-Module zu importieren. Diese werden im nächsten Abschnitt beschrieben.","hash":"sec_javascript_module","h2":"JavaScript-Module"},"371":{"id":371,"content":"npm-Module npm ist ein Paketmanager für JavaScript der über 350.000 Pakete zur Verfügung stellt. Unter der Webseite https://www.npmjs.com/ können die vorhandenen Pakete durchsucht werden. Es ist möglich, in einem QF‑Test Skript, installierte npm-Module zu verwenden. Diese müssen im javascript-Verzeichnis des QF‑Test Wurzelverzeichnisses installiert werden. Mit dem Kommando npm install underscore wird das npm-Modul underscore über die Konsole des Betriebssystems installiert. Dieses kann nun in den Skript-Knoten verwendet werden. Es gibt npm-Module, die nicht mit Nashorn kompatibel sind. Da beispielsweise einige Funktionen verwendet werden, die nicht vom ECMAScript Standard spezifiziert werden _ = require('underscore'); func = function(num){ return num % 2 == 0; } let evens = _.filter([1, 2, 3, 4, 5, 6], func); console.log(evens); Beispiel 11.34: Verwendung des underscore-Moduls","hash":"sec_npm_module","h2":"npm-Module"},"372":{"id":372,"content":"Ausgaben Neben console.log() wurde für Ausgaben ins Terminal in QF‑Test eine zusätzliche print-Methode definiert. print([1,2,3,4]); Beispiel 11.35: Ausgabe eines Arrays","hash":"sec_ausgaben","h2":"Ausgaben"},"373":{"id":373,"content":"Ausführung Die JavaScript-Skripte werden auf Server- bzw. SUT-Seite nicht im Browser ausgeführt, sondern in der Nashorn-Engine. Dies ermöglicht die Ausführung von ECMAScript in der JVM.","hash":"sec_ausfuhrung","h2":"Ausführung"},"374":{"id":374,"content":"Pro Handbuch","hash":"","h0":"Unit-Tests | QF‑Test Handbuch"},"375":{"id":375,"content":"Pro Handbuch","hash":"home-link","h0":"Unit-Tests | QF‑Test Handbuch"},"376":{"id":376,"content":"Unit-Tests Unit-Tests oder Komponententests dienen der Überprüfung von funktionalen Einheiten. Sie sollen gezielt die Funktionalität der Komponenten testen, isoliert von anderen Komponenten. Aus diesem Grund besitzen sie eine deutlich geringere Komplexität im Vergleich zu Integrations- bzw. Systemtests, welche erheblich mehr Entwicklungsaufwand erfordern. Mit dem Unit-Test Knoten können Unit-Tests mit Hilfe des JUnit-Frameworks als Teil eines QF‑Test Testlaufs ausgeführt werden. Sowohl der Report als auch das Protokoll zeigen deren Ergebnisse an. Die Einbindung von QF‑Test Testsuiten in bestehende JUnit-Tests wird in \"JUnit 5 Jupiter\" beschrieben. Der Unit-Test Knoten kann Tests aus zwei unterschiedlichen Quellen starten. Hierbei werden die Parameter des Knotens dynamisch an den Anwendungsfall angepasst. Es können Java-Klassen angegeben werden, die JUnit-Testfälle enthalten, oder Unit-Test-Skripte mit QF‑Test geschrieben werden. Dieses Kapitel erläutert die unterschiedlichen Möglichkeiten. Für die Ausführung der JUnit-Tests wird das JUnit 5 Framework verwendet. Dieses ermöglicht es einerseits JUnit 5 Tests mit Hilfe der JUnit Jupiter Engine auszuführen. Andererseits kann die JUnit Vintage Engine sowohl JUnit 4 als auch JUnit 3 Tests ausführen. Mit JUnit 5 ist es möglich parametrisierte Tests zu schreiben, Tests innerhalb von Klassen einzubetten und den Reportnamen des Tests zu ändern.","hash":"usec_unittests","h0":"Unit-Tests"},"377":{"id":377,"content":"Java-Klassen als Quelle für Unit-Tests Es ist möglich Unit-Tests aus geladenen Jar-Ordnern und Class-Dateien auszuführen. Es können aber auch Tests ausgeführt werden, die bereits mit dem Start des SUTs geladen wurden. QF‑Test führt dabei die angegebenen Test-Klassen als Testschritte aus. Das folgende Beispiel soll den Aufbau eines Unit-Tests mit Java-Klassen verdeutlichen.","hash":"sec_java_klassen_als_quelle_fur_unit_tests","h1":"Java-Klassen als Quelle für Unit-Tests"},"378":{"id":378,"content":"Abbildung 12.1: Unit-Test-Knoten mit Java-Klassen package de.qfs.test; import org.junit.Assert; import org.junit.Test; public class StringTest { @Test public void testubstring() { String s = new String(\"Langer Text\"); s = s.substring(7, 11); assert(\"Text\".equals(s)); } @Test public void testReplace() { String s = new String(\"Beispiel\"); s = s.replace('e', 'i'); Assert.assertEquals(\"Biispiil\", s); } } Beispiel 12.1: Code der Java-Unit-Test-Klasse Die Klasse de.qfs.test.StringTest muss sich im unittests.jar befinden. Der Pfad zu dieser Jar-Datei wird unter Classpath angegeben. Dieser Pfad wird relativ zum Verzeichnis der aktuellen Suite ermittelt. In diesem Beispiel liegt die jar-Datei direkt im Verzeichnis der Testsuite. JUnit-Test-Klassen sind Java-Klassen, deren Methoden die @Test-Annotation besitzen. Der Unit-Test Knoten führt alle Klassen aus, die unter Test-Klassen angegeben sind. Deshalb kann ein Unit-Test Knoten auch mehrere Test-Klassen ausführen.","hash":"figure_12.1","h4":"Abbildung 12.1: Unit-Test-Knoten mit Java-Klassen"},"379":{"id":379,"content":"Grundlagen der Test-Skripte Die zweite Möglichkeit, die Unit-Test Knoten bieten, ist den Unit-Test direkt im Knoten zu kodieren. Hierfür können die in QF‑Test vorhanden Skriptsprachen genutzt werden. Groovy ist dazu am besten geeignet, denn es ermöglicht die Verwendung von Java-Annotationen. Das Framework hierfür ist JUnit.","hash":"usec_unittestscriptbasics","h1":"Grundlagen der Test-Skripte"},"380":{"id":380,"content":"Groovy Unit-Tests @BeforeClass static void onbefore(){ println(\"Vorbereitung\") } @Test(expected=IndexOutOfBoundsException.class) void indexOutOfBoundsAccess() { def numbers = [1,2,3,4] numbers.get(4) } @Test void noFailure() { assert true } Beispiel 12.2: Unit-Test-Skript mit Groovy In Groovy werden die für JUnit 4 erforderlichen Klassen automatisch importiert. Und wie in Java werden alle Tests mit der @Test-Annotation ausgeführt. Der expected Parameter der @Test-Annotation erlaubt es, erwartete Exceptions zu ignorieren. Die Methode, welche mit der @BeforeClass-Annotation gekennzeichnet ist, wird einmal vor der Ausführung der Test-Methoden ausgeführt.","hash":"sec_groovy_unit_tests","h2":"Groovy Unit-Tests"},"381":{"id":381,"content":"Jython Unit-Tests def setUp(self): print \"Vorbereitung\" def testMathCeil(self): import math self.assertEqual(2, math.ceil(1.01)) self.assertEqual(1, math.ceil(0.5)) self.assertEqual(0, math.ceil(-0.5)) self.assertEqual(-1, math.ceil(-1.1)) def testMultiplication(self): self.assertAlmostEqual(0.3, 0.1 * 3) Beispiel 12.3: Unit-Test Skript mit Jython Da in Jython keine Java-Annotationen verwendet werden können, werden die Skripte als JUnit-3-Tests ausgeführt. Alle Funktionen, die mit dem Schlüsselwort test beginnen, werden als Checks ausgeführt. Die Methoden müssen den Parameter self besitzen, da diese von einer Klasse umschlossen werden. Die setUp-Methode wird vor Beginn der Tests ausgeführt.","hash":"usec_unittestscriptjython","h2":"Jython Unit-Tests"},"382":{"id":382,"content":"JavaScript Unit-Test setUp(){ print(\"Vorbereitung\"); } tearDown() { print(\"Nachbereitung\"); } testUpperCase(){ let s = \"text\"; assertEquals(\"TEXT\", s.toUpperCase()); } testOk() { assertTrue(true); } Beispiel 12.4: Unit-Test Skript mit JavaScript Da auch JavaScript keine Java-Annotationen unterstützt, können nur JUnit-3 Tests (vgl. \"Jython Unit-Tests\") ausgeführt werden. Wie in Jython werden alle Funktionen, die mit dem Schlüsselwort test beginnen, als Checks ausgeführt.","hash":"sec_javascript_unit_test","h2":"JavaScript Unit-Test"},"383":{"id":383,"content":"Injections Es ist möglich, den Unit-Test Knoten für sogenannte 'LiveTests' zu nutzen. QF‑Test führt die Unit-Tests hierbei in einem laufenden SUT aus. Um in den JUnit-Test-Klassen Objekte wie Komponenten, QF‑Test Variablen oder WebDriver-Objekte verwenden zu können, müssen diese in den Code 'injiziert' werden.","hash":"sec_injections","h1":"Injections"},"384":{"id":384,"content":"Komponenten in den Unit-Tests verwenden import static org.junit.Assert.*; import javax.swing.JComponent; import org.junit.Test; public class ComponentTest { /** The component to test in this unit test */ static JComponent component; /** Expected value */ static String accessibleName; @Test public void accessibleNameIsCorrect() { /** component and accessible name are injected at run-time */ final String currentName = component.getAccessibleContext().getAccessibleName(); assertEquals(accessibleName,currentName); } } Beispiel 12.5: Java-Unit-Test-Klasse","hash":"sec_komponenten_in_den_unit_tests_verwenden","h2":"Komponenten in den Unit-Tests verwenden"},"385":{"id":385,"content":"Abbildung 12.2: Beispiel eines Unit-Test Knotens mit Injections In diesem Beispiel werden gleich zwei Objekte in die Unit-Tests übertragen. Eine Komponente und eine QF‑Test Variable. Der Parameter 'Feld' der Injection entspricht hier dem Namen des Felds static JComponent component; der Java-Klasse. Das Java-Feld muss hierfür static sein.","hash":"figure_12.2","h4":"Abbildung 12.2: Beispiel eines Unit-Test Knotens mit Injections"},"386":{"id":386,"content":"WebDriver-Injections import static org.junit.Assert.*; import org.junit.Test; import org.openqa.selenium.WebDriver; public class WebdriverTest { /** The driver of the window currently opened by QF‑Test. */ static WebDriver driver; @Test public void urlIsCorrectedLoaded() { // driver is injected at run-time final String currentUrl = driver.getCurrentUrl(); assertEquals(\"http://www.example.com\", currentUrl); } } Beispiel 12.6: Java-Unit-Test mit WebDriver-Injections","hash":"usec_unitinjecttcomponents","h2":"WebDriver-Injections"},"387":{"id":387,"content":"Abbildung 12.3: Beispiel eines 'Unit-Test'-Knotens mit WebDriver-Injections Dieses Beispiel zeigt wie ein WebDriver-Objekt in die Java-Klasse übertragen wird. QF‑Test ermittelt den Wert der WebDriver-Injection anhand des angegebenen Clients, falls kein expliziter Wert gesetzt ist.","hash":"figure_12.3","h4":"Abbildung 12.3: Beispiel eines 'Unit-Test'-Knotens mit WebDriver-Injections"},"388":{"id":388,"content":"Unit-Tests im Report Der große Vorteil des Unit-Test Knotens ist, dass dieser im HTML-Report erscheint. Die Unit-Tests werden als Testfälle interpretiert. Damit diese korrekt im Report erscheinen, muss ein Testfall ausgeführt werden, in welchem der Unit-Test-Knoten enthalten ist.","hash":"usec_unitreport","h1":"Unit-Tests im Report"},"389":{"id":389,"content":"Abbildung 12.4: Unit-Test Report","hash":"figure_12.4","h4":"Abbildung 12.4: Unit-Test Report"},"390":{"id":390,"content":"Pro Handbuch","hash":"","h0":"Java-Desktopanwendungen testen | QF‑Test Handbuch"},"391":{"id":391,"content":"Pro Handbuch","hash":"home-link","h0":"Java-Desktopanwendungen testen | QF‑Test Handbuch"},"392":{"id":392,"content":"Java-Desktopanwendungen testen Der Ursprung von QF‑Test liegt im Testen von Java-basierten Desktop-Anwendungen und seit dem Start 1999 konnten wir die Unterstützung in zahlreichen Projekten perfektionieren für die bekannten Java GUI-Toolkits, als da wären: Java Swing - das GUI Toolkit von Sun/Oracle SWT (Standard Widget Toolkit) - das Tookit hinter Eclipse, entwickelt von IBM JavaFX - der gedachte Nachfolger von Java Swing von Oracle Es gibt für diese Toolkits auch Erweiterungen/Bibliotheken, die spezielle Komponenten oder Framework-Funktionalitäten bereitstellen: Rich Client Platform (RCP) Eclipse Plug-Ins Netbeans Platform JFace GUI toolkit (auf SWT basierende Bibliothek) JIDE Common Layer Komponenten ULC (UltraLightClient) und RIA (Rich Internet Application) Java WebStart ... Desktop-Anwendungen, die auf den genannten Technologien basieren, können mit QF‑Test in einfacher und effizienter Weise getestet werden. Es entstehen robuste und verlässliche Testfälle mit geringem Wartungsaufwand, die einen hohen Wert für die Software-Qualitätssicherung darstellen. Alle allgemeinen Techniken, die in diesem Handbuch beschrieben sind, können auf das Testen von Java Desktop-Programmen angewendet werden. Es gibt auch hybride Systeme, wie Java Desktop-Anwendungen mit einer eingebetteten Browser-Komponente oder solche, die in einem Browser als angezeigt/gerendert werden. Auch diese Art von Systemen werden von QF‑Test perfekt unterstützt. Weitere Details findet man in den Kapiteln Webseiten testen und Webswing und JPro: Java-Anwendungen im Browser testen. Es gibt kurze Einführungsvideos zu Java Swing Testen und JavaFX Testen auf unserem QF‑Test YouTube Kanal.","hash":"usec_jdesktop","h0":"Java-Desktopanwendungen testen"},"393":{"id":393,"content":"Pro Handbuch","hash":"","h0":"Webseiten testen | QF‑Test Handbuch"},"394":{"id":394,"content":"Pro Handbuch","hash":"home-link","h0":"Webseiten testen | QF‑Test Handbuch"},"395":{"id":395,"content":"Webseiten testen QF‑Test erlaubt das intuitive Testen von Webseiten im Browser aus Sicht des Benutzers. Wie auch bei den anderen unterstützten GUI-Technologien können Aktionen und Checks direkt aufgenommen, nachbearbeitet, strukturiert und wiedergegeben werden. Zum Einstieg gibt es auch ein kurzes Überblicksvideo zu Web-Testen auf unserem QF‑Test YouTube Kanal.","hash":"usec_webtesting","h0":"Webseiten testen"},"396":{"id":396,"content":"Unterstützte Browser QF‑Test unterstützt die Automatisierung von Tests die folgenden Browser: Google Chrome (auch im Headless-Modus, siehe \"Web-Testen im Headless-Modus\") Mozilla Firefox (auch im Headless-Modus, siehe \"Web-Testen im Headless-Modus\") Microsoft Edge (auch im Headless-Modus, siehe \"Web-Testen im Headless-Modus\") Safari Opera JxBrowser eingebettet in Swing, JavaFX oder SWT WebView eingebettet in JavaFX Internet Explorer oder Webkit eingebettet in SWT Details zu den unterstützten Browser Versionen finden Sie in \"Unterstützte Technologien - zu testende Systeme\".","hash":"usec_web_browsers","h1":"Unterstützte Browser"},"397":{"id":397,"content":"Allgemeine Vorgehensweise Eine Schritt-für-Schritt Anleitung zum Einstieg das Web-Testen mit QF‑Test finden Sie im entsprechende zweiten Teil des Tutorials. Es gibt Teile des Tutorials auch als Videos. Nur zur Erzeugung einer passenden Web-Startsequenz empfehlen wir das Video Der Schnellstart Assistent Web auf unserem QF‑Test YouTube Kanal. Die Vorgehensweise für die Testerstellung und -ausführung bei Web-Anwendungen unterscheidet sich nicht wesentlich von der anderer GUI-Technologien, wie dies allgemein ab \"Bedienung von QF‑Test\" dieses Handbuchs beschrieben wird. Jedoch sollte ein besonderer Augenmerk auf die Komponentenerkennung gelegt werden, die stark abhängig von der konkreten Implementierung der Web-Anwendung ist. Um herauszufinden, wie gut die direkte Wiedererkennung funktioniert, empfiehlt es sich zu Beginn testweise Aktionen auf unterschiedliche Komponenten und Masken der Web-Anwendung aufzunehmen und das korrekte Abspielen zu überprüfen. Weitere Hinweise zur Komponentenerkennung und Möglichkeiten der Optimierung finden Sie in \"Erkennung von Web-Komponenten und Toolkits\".","hash":"usec_web_general","h1":"Allgemeine Vorgehensweise"},"398":{"id":398,"content":"Die Verbindung zum Browser Im ersten Schritt muss der gewünschte Browser von QF‑Test gestartet und eine Verbindung hergestellt werden. Sobald die per URL angegebene Web-Anwendung geladen ist, kann mit der Aufnahme und Testerstellung begonnen werden. QF‑Test verwendet unterschiedliche Methoden, so genannte Driver, um Zugriff auf den Browser zu erlangen und eine Verbindung herzustellen: den QF-Driver, den CDP-Driver und den WebDriver. Je nach Browser stehen unterschiedliche Verbindungsmodi zur Verfügung. QF‑Test versucht, automatisch den besten Modus zu wählen. Sie können die Kontrolle darüber mit Hilfe des Attributs Verbindungsmodus für den Browser im Web-Engine starten Knoten übernehmen. Details hierzu finden Sie in \"Browser Verbindungsmodus\". Beim QF-Driver wird der auf dem Rechner des Anwenders installierte Browser in ein so genanntes Wrapper-Fenster eingebunden. Man spricht bei diesem Ansatz auch von Embedding. QF‑Test bindet in dieses Fenster den lokal installierten Web-Browser nativ ein und erlangt somit Zugriff auf die Automatisierungs-Interfaces des jeweiligen Browsers. Über diese kann QF‑Test dann die benötigten Events vom Browser abgreifen aber auch umgekehrt Events in den Browser einspeisen. Die Einbettung des Browsers in ein separates Fenster funktioniert für neuere Browser leider nicht mehr zufriedenstellend oder gar nicht, weshalb alternative Mechanismen zur Verfügung stehen. Der CDP-Driver Mechanismus greift zur Kommunikation auf die in Chromium (und davon abgeleiteten Browsern) eingebaute Debugging-Schnittstelle zurück. Dazu verwendet QF‑Test das Chrome DevTools Protokoll. Da dies die gleiche Schnittstelle ist, welche auch von den Entwicklungstools im Browser verwendet wird, ist eine enge und effiziente Testausführung möglich. Leider steht das Protokoll noch nicht für alle von QF‑Test unterstützen Browser zur Verfügung. Der WebDriver Mechanismus verwendet als Bindeglied zwischen dem Browser und QF‑Test den Selenium WebDriver, der sich zu einem W3C-Standard für die Steuerung von Web-Browsern entwickelt hat (http://www.w3.org/TR/webdriver/). Der WebDriver Modus ist systembedingt leider in Bezug auf Performance und Funktionsumfang im Vergleich zum QF-Driver etwas eingeschränkt (siehe \"Bekannte Einschränkungen des WebDriver Modus\"). Wenn möglich sollte die Testerstellung mittels QF-Driver oder CDP-Driver, also z.B. mit dem Chrome Browser durchgeführt werden. Die reine Ausführung kann dann auch mittels WebDriver erfolgen - leider nicht ganz so performant. Um die Aufnahmefunktionalitäten von QF‑Test auch im WebDriver Modus verwenden zu können, muss QF‑Test die Inhalte des Browser-Fensters kontinuierlich analysieren und auf Änderungen überwachen. Dies kann in einigen Browsern eine Warnung hervorrufen, die sich auf Mixed-Mode-Darstellung bzw. die Verwendung eines unbekannten Zertifikats bezieht. Sollte diese Warnung bzw. Fehlermeldung nur während des Tests Ihrer Website mit QF‑Test auftreten, so kann sie ignoriert werden.","hash":"usec_webtesting_connection_mode","h1":"Die Verbindung zum Browser"},"399":{"id":399,"content":"Erkennung von Web-Komponenten und Toolkits Bei Web-Applikationen haben Entwickler viele Freiheitsgrade, wie sie graphische Objekte in HTML entwickeln. Dies resultiert in einer Vielzahl von Implementierungen für funktionale GUI-Komponenten wie Buttons, Textfelder, Tabellen etc. Hier ein paar Beispiele für die Umsetzung eines Okay Buttons: <button id=\"ok1\">OK</button> <div class=\"toolkit-btn\">OK</div> <span class=\"btn\" name=\"ok2\">OK</span> <div role=\"button\">OK</div> Zunächst nimmt QF‑Test die GUI-Elemente mit den HTML-Tags als Klassen sowie die Basiswiedererkennungsmerkmale auf. Im ersten Beispiel würde somit eine QF‑Test Komponente mit der Klasse BUTTON, dem Namen ok1 und den für die Anzeige gültigen Struktur- und Geometrieinformationen angelegt. Beim Abspielen der Tests sollte die Komponente somit zuverlässig erkannt werden. Darüber hinaus prüft QF‑Test, ob es sich bei den HTML-Angaben um Quasi-Standards handelt, die einer generischen QF‑Test Klasse zugeordnet werden können. Dies wäre in diesem Beispiel der Fall und es würde Button zugewiesen. Der Vorteil der generischen Klassen ist, dass klassenabhängig zusätzliche Wiedererkennungsmerkmale aufgenommen werden. So wird einem Button zum Beispiel die Beschriftung als Merkmal Attribut zugewiesen. Des weiteren stehen bei der Aufnahme von Checks zusätzliche klassenspezifische Checks zur Verfügung. Bei Tabellen wird zum Beispiel die Aufnahme eines Checks für eine ganze Zeile oder Spalte angeboten. Weitere Vorteile sind in der Einleitung zu Generische Klassen beschrieben. Detaillierte Informationen zu den klassenspezifischen Erweiterungen finden Sie in Generische Klassen. Auf dem Markt existieren eine Vielzahl von Komponentenbibliotheken, wie Angular Material oder Vaadin, die die Erstellung von Webseiten massiv erleichtern. Jede dieser Bibliotheken hat ihre eigenen Implementierungen für GUI-Objekte. Im zweiten Beispiel verwendet das Toolkit immer die css-Klasse toolkit-btn für Buttons. Für eine Reihe von Toolkits ist in QF‑Test die Zuordnung der GUI-Elemente zu Komponenten einer bestimmten generischen Klassen bereits hinterlegt. In diesen Fällen können Sie mit der gewohnt stabilen Komponentenerkennung von QF‑Test arbeiten. Weitere Informationen zu den unterstützten Web-Toolkits finden Sie in Besondere Unterstützung für verschiedene Web-Komponentenbibliotheken. Im Normalfall erkennt QF‑Test selbständig, ob und mit welchem Toolkit die Web-Anwendung erstellt wurde. Alternativ können Sie manuell aus den verfügbaren Web-Toolkits auswählen. Das dritte und vierte Beispiel entsprechen keinerlei Standards. Die Wiedererkennung im dritten Beispiel würde über das name Attribut vermutlich ausreichend stabil sein. Im vierten Beispiel bietet das GUI-Objekt von sich aus aber gar keine guten Merkmale für die Wiedererkennung. In beiden Fällen kann jedoch das kennzeichnende HTML-Attribut der generischen Klasse Button zugewiesen werden. Details hierzu finden Sie in Verbesserte Komponentenerkennung mittels CustomWebResolver. Es ist sinnvoll vor dem Erstellen der Tests zu prüfen, zu welcher dieser Kategorien die GUI-Objekte der zu testenden Applikation gehören. Falls die Standarderkennung nicht ausreichend ist, sollte durch Zuordnung von GUI-Objekten zu generischen QF‑Test Klassen eine Optimierung erfolgen. Siehe \"Verbesserte Komponentenerkennung mittels CustomWebResolver\". Allgemeine Informationen Komponenten in QF‑Test finden Sie in \"Komponenten\". Der Umgang mit mehreren Browser-Fenstern wird in FAQ 25 genauer erläutert.","hash":"usec_web_components","h1":"Erkennung von Web-Komponenten und Toolkits"},"400":{"id":400,"content":"Cross-Browser Tests Browser-übergreifende Tests sind einfach realisierbar. Sie erstellen Testfälle für einen Browser und können diese dann auf anderen Browsern abspielen. Im Wesentlichen muss nur in einem Datentreiber die Variable $(browser), die den Browser definiert, passend gesetzt werden. Falls Sie es probieren wollen, fügen Sie einfach in der mitgelieferten Demo-Testsuite für Web im Testfallsatz \"CarConfiguratorWeb Demo\" einen Datentreiber wie folgt ein: (Um die Demo-Testsuite zu öffnen, wählen Sie den Menüpunkt »Hilfe«-»Beispiel-Testsuiten erkunden...« und klicken den \"öffnen\"-Link hinter \"Web CarConfig Suite\".)","hash":"usec_web_cross_browser","h1":"Cross-Browser Tests"},"401":{"id":401,"content":"Abbildung 14.1: Cross-Browser Tests Dann werden die vier Testfallsätze, die gemeinsam mit dem Datentreiber im Testfallsatz \"CarConfiguratorWeb Demo\" liegen, für jeden Browser-Typ einmal durchlaufen.","hash":"figure_14.1","h4":"Abbildung 14.1: Cross-Browser Tests"},"402":{"id":402,"content":"Testen von mobilen Webseiten Beim Testen von Webseiten ist häufig das Benutzererleben auf mobilen Geräten wie Smartphones oder Tablets relevant, da die Webseite aufgrund einer unterschiedlichen Browser-Kennung (\"User Agent\") und spezifischen Display-Größen anders dargestellt wird als im Desktop-Browser (\"Responsive Design\"). QF‑Test unterstützt solche Szenarien über die Emulation mobiler Browser. Dabei wird ein Desktop-Browser in einem Modus gestartet, in welchem die Fenstergrößen und die Browserkennung den Browser eines Mobilgerätes emuliert. Insbesondere Google Chrome ist in der Lage, spezifische Charakteristika der mobilen Variante, wie ein angepasstes Pixel-Verhältnis bzw. eine automatische Skalierung nicht-responsiver Webseiten nachzubilden. Um mit so einem Szenario zu beginnen, können Sie im Schnellstart-Assistenten die Kategorie \"Eine Web-Anwendung in einem emulierten mobilen Browser\" nutzen und dann das gewünschte Mobilgerät auswählen (siehe \"Schnellstart Ihrer Anwendung\"). Ein Demo finden Sie in der Testsuite \"carconfigWeb_advanced_de.qft\". Dort die Testsuite \"Emulation von mobilen Geräten\". Dies können einfach öffnen über das Menü »Hilfe«-»Beispiel-Testsuiten erkunden...« und dann Auswahl des letzten Beispiels \"CarConfig Web Testprojekt\".","hash":"sec_webtesting_mobile_emulation","h1":"Testen von mobilen Webseiten"},"403":{"id":403,"content":"Web-Testen im Headless-Modus Mit Hilfe der CDP-Driver und WebDriver Ansätze ist es auch möglich, Chrome, Firefox und Microsoft Edge im sogenannten Headless-Modus anzusteuern. Dabei wird der Browser im Hintergrund gestartet, ohne ein sichtbares Fenster auf dem Bildschirm anzuzeigen. Alle Interaktionen mit der Webseite erfolgen im \"unsichtbaren\" Fenster. Anwendungsfälle für Headless-Browser können Web-Lasttests sein (\"Web-Lasttests ohne sichtbare Browser-Fenster\") oder Tests, die parallel zur Testentwicklung auf dem gleichen Rechner im Hintergrund laufen sollen. Um einen bestehenden Web-Test im Headless-Modus auszuführen, muss lediglich der Typ des Browsers im Knoten Web-Engine starten von chrome auf headless-chrome bzw. von firefox auf headless-firefox oder von edge auf headless-edgegeändert werden.","hash":"usec_webtesting_headless","h1":"Web-Testen im Headless-Modus"},"404":{"id":404,"content":"Einbindung vorhandener Selenium Web-Tests QF‑Test erlaubt bei Verwendung des WebDriver Modus die Kombination mit bereits bestehenden Selenium Skripten. Ein Weg ist die direkte Nutzung der WebDriver Java-APIs in SUT-Skript Knoten (vgl. \"WebDriverConnection SUT API\"). Eine andere Möglichkeit ist Einbettung von Selenium Skripten als Unit-Tests, wie in \"Unit-Tests\" beschrieben. Als schönen Nebeneffekt erhält man ein integriertes Reporting, bei dem auch die ausgeführten Unit-Tests enthalten sind. Ein Demo finden Sie in der Testsuite \"carconfigWeb_advanced_de.qft\" - dort die Testsuite \"Integration von Selenium Tests\". (Einfach zu öffnen über das Menü »Hilfe«-»Beispiel-Testsuiten erkunden...« und dann Auswahl des letzten Beispiels \"CarConfig Web Testprojekt\".)","hash":"usec_webtesting_selenium","h1":"Einbindung vorhandener Selenium Web-Tests"},"405":{"id":405,"content":"Auswahl der Browser Installation Bei der Verwendung des CDP-Driver oder WebDriver Modus kann man im Web-Engine starten auch für andere Browser als Firefox explizit das Verzeichnis der Browser-Installation setzen. Ist kein Verzeichnis angegeben, so wird versucht, einen Standard-Browser des entsprechenden Typs zu starten.","hash":"usec_webtesting_browser_dir","h1":"Auswahl der Browser Installation"},"406":{"id":406,"content":"Pro Handbuch","hash":"","h0":"Native Windows-Anwendungen testen | QF‑Test Handbuch"},"407":{"id":407,"content":"Pro Handbuch","hash":"home-link","h0":"Native Windows-Anwendungen testen | QF‑Test Handbuch"},"408":{"id":408,"content":"Native Windows-Anwendungen testen","hash":"usec_wintesting","h0":"Native Windows-Anwendungen testen"},"409":{"id":409,"content":"Einstieg Video über das Testen von Native Windows Desktop Applicationen: 'QF‑Test Version 5.0 - Windows Anwendungen testen'. Dieses Kapitel behandelt das automatisierte Testen von Windows-Desktop-Anwendungen, insbesondere klassische Win32-Anwendungen, .NET-Anwendungen, welche auf den Frameworks Windows Presentation Foundation (WPF) oder Windows Forms basieren und Universal Windows Platform (UWP) Anwendungen, welche XAML-Steuerelemente verwenden. Die genannten Anwendungstypen unterstützen die Microsoft UI Automation oder die Microsoft Active Accessibility (MSAA) Schnittstellen. Weiterführende Informationen zu diesen, unter dem Namen Windows Automation API zusammengefassten Schnittstellen, wurden im \"Technischer Hintergrund\" zusammengetragen. Für die Testausführung benötigt QF‑Test eine Verbindung zu dem Prozess der zu testenden Anwendung. Zur Erstellung einer Vorbereitung, welche eine solche Verbindung herstellt, bietet sich der Erzeugung der Startsequenz - Schnellstart-Assistent an, welcher über das Menü »Extras« aufgerufen werden kann. Wählen Sie 'Eine native Windows-Anwendung' als Anwendungstyp. Weiterführende Informationen zur Benutzung des Schnellstart-Assistenten können Sie \"Start/Anbindung einer Applikation\" und \"Erzeugung der Startsequenz - Schnellstart-Assistent\" entnehmen. Um sich mit einer bereits laufenden Anwendung zu verbinden, können Sie den Windows-Anwendung verbinden Knoten verwenden. Hierbei reicht es den Titel des (Haupt-)Fensters anzugeben. Hierbei können Sie auch reguläre Ausdrücke verwenden. Falls dies der Fall ist, müssen Sie zusätzlich die CheckBox Als Regexp aktivieren. Für den Windows Editor (Notepad) wäre dies zum Beispiel .*- Editor. Hierbei sollte allerdings darauf geachtet werden, dass der angegebene reguläre Ausdruck nicht zufällig mit dem Titel eines anderes Fenster übereinstimmt. Wenn die Anwendung durch QF‑Test gestartet werden soll, verwenden Sie bitte den Windows-Anwendung starten Knoten und geben Sie die ausführbare Datei (.exe) Ihrer Anwendung inklusive Pfad an, vgl. Start/Anbindung einer Applikation. Wenn sich QF‑Test zu der Anwendung (als GUI-Engine win) verbunden hat, können Tests aufgenommen und abgespielt werden wie in \"Aufnahme und Wiedergabe\" beschrieben. Auf Grund der Eigenschaften der Microsoft UI Automation sind allerdings die in \"Aufnahme\" aufgeführten Aufnahmeregeln zu beachten. Die Installation von QF‑Test liefert folgende Beispiel-Testsuiten mit: qftest-10.0.2-pro/demo/carconfigForms/winDemoForms_de.qft qftest-10.0.2-pro/demo/carconfigWpf/winDemoWPF_de.qft qftest-10.0.2-pro/demo/windows/Win10Calculator_de.qft Bitte beachten Sie auch die (aktuellen) Einschränkungen, \"(Aktuelle) Einschränkungen\", von denen zu erwarten ist, dass die meisten in zukünftigen QF‑Test Releases behoben oder verbessert werden.","hash":"usec_wintesting_start","h1":"Einstieg"},"410":{"id":410,"content":"Technischer Hintergrund Ein verbreitetes Framework für Windows basierte Applikationen ist die Windows Automation API, bestehend aus der Microsoft Active Accessibility und dessen Nachfolger, der Microsoft UI Automation. Dies ist das Kernstück der win Engine, wodurch QF‑Test in der Lage ist, fast alle Arten von Windows Applikationen zu steuern. Eine Windows-Anwendung muss sogenannte Provider zur Verfügung stellen, um die Regeln der UI Automation einzuhalten. Dies geschieht bei der Verwendung eines Frameworks wie WPF automatisch, bei Win32 Applikationen über Proxy Provider. Wie gut eine Applikation getestet werden kann, hängt somit von der Qualität der jeweiligen Provider ab, d.h. dem Framework, welches für die Entwicklung verwendet wurde. Da die UI Automation zusammen mit dem WPF Framework eingeführt wurde, sollten Anwendungen, die damit entwickelt wurden, gut testbar sein. Bei Entwicklungsplattformen ohne Integration der UI-Automation sieht die Sache anders aus, wie zum Beispiel bei Java Swing. Aber dafür für Java-Anwendungen stellt QF‑Test auch einen ziemlich guten anderen Verbindungsmodus bereit ... Wenn ein Programm über UI Automation getestet werden soll, so stehen sogenannte Automation Elements zur Verfügung, die die eigentlichen UI Elemente der zu testenden Anwendung darstellen. Obwohl jedes Automation Element einen Control Type hat (Button, MenuItem etc.), wird seine tatsächliche Funktionalität - zum Beispiel das Setzen eines Wertes in einem Textfeld - über Control Patterns bestimmt, die über den jeweiligen Provider implementiert sind. Zur Bedienung des UI Automation Frameworks startet QF‑Test ein spezielles Java Programm, das als UI Automation Client Applikation dient. Dieses Programm kann alle UI Automation Elemente eines bestimmten Prozesses ansprechen und diese entsprechend der QF‑Test Regeln bedienen (zum Beispiel zum Erstellen eines Abbildes eines Elements als Komponente).","hash":"usec_wintesting_general","h1":"Technischer Hintergrund"},"411":{"id":411,"content":"Start/Anbindung einer Applikation Um eine native Windows-Anwendung zu testen ist es nicht zwingend notwendig, diese Anwendung über QF‑Test zu starten. Man kann QF‑Test auch mit einem bereits laufenden Prozess verbinden. Dadurch ist es auch möglich, Bereiche des Betriebssystems zu steuern, zum Beispiel die Windows Taskbar. Die Anbindung an einen bereits laufenden Prozess erfolgt entweder über den Fenstertitel (wahlweise mit regulärem Ausdruck), die Prozess-Id oder den Klassennamen des Fensters, der über die UI Automation bereitgestellt wird. Die Anbindung ist für ein Window im Sinne eines UI Automation Control Types möglich, aber auch für ein Pane oder Menu Element. Unabhängig von der gewählten Verbindungsmethode, ermittelt QF‑Test die jeweilige Prozess-Id und wird genau diesen Prozess als System Under Test (SUT) behandeln. Der Windows-Anwendung verbinden Knoten stellt die Verbindung her. Dabei muss für die Verbindung zu einer bereits laufenden Anwendung im Attribut Fenstertitel einer der folgenden Werte eingetragen werden (wie bereits oben erwähnt): ein regulärer Ausdruck für den Fenstertitel -pid <Prozess-Id> -class <class name> Beispiele: .*- Editor: zur Anbindung an einen laufenden Windows Notepad Prozess, -class Shell_TrayWnd: Anbindung der Windows Taskbar verbinden. Für die Ermittlung des Fenstertitels, der Prozess-Id oder des Class Name des laufenden Programms steht die Prozedur qfs.autowin.logUIAToplevels in der Standardbibliothek qfs.qft zur Verfügung. Man kann die zu testende Anwendung aber auch direkt über den Windows-Anwendung starten Knoten starten. In diesem Fall geben Sie den Dateinamen der ausführbaren Datei, inklusive Pfad, im Attribut Windows-Anwendung an. Sie können auch das Attribut Windows-Anwendung zusammen mit dem Fenstertitel Attribut angeben. Dies ist nützlich, wenn die Anwendung gestartet werden soll, falls sie nicht bereits läuft. QF‑Test prüft dann zuerst, ob es sich an einen laufenden Prozess, der dem Fenstertitel Attribut entspricht, anbinden kann. Falls nicht, wird das angegebene Programm gestartet und über seine Prozess-Id verbunden. Es kann vorkommen, dass dieser Prozess einen weiteren Prozess startet, der das eigentliche Programm darstellt, wobei ersterer selbst aber keine (grafische) Benutzeroberfläche hat oder sich sogar beendet. In diesem Fall wird ein weiterer Versuch durchgeführt um eine Verbindung zu dem zweiten Prozess zu erlangen. Wenn Sie in QF‑Test einen win Client beenden (entweder mittels des Programm beenden Knotens oder über das »Clients« Menü), wird der entsprechende UI Automation Client Prozess mitsamt seiner Unterprozesse gestoppt. Das heißt, dass die zu testende Anwendung nur dann beendet wird, wenn sie aus QF‑Test heraus gestartet wurde, nicht aber, wenn sie bereits vor der Verbindung mit QF‑Test gelaufen ist. Wenn sie die zu testende Anwendung beenden, wird in jedem Fall auch der UI Automation Client beendet. Um sich mit einem heraufgestuften Prozess verbinden zu können, muss QF‑Test als Administrator gestartet werden.","hash":"usec_wintesting_launch","h1":"Start/Anbindung einer Applikation"},"412":{"id":412,"content":"Aufnahme Nach erfolgreicher Verbindung von QF‑Test mit der zu testenden Anwendung können Sie mit der Aufnahme von Aktionen (\"Aufnahme von Testsequenzen\"), Checks (\"Aufnehmen von Checks\") und Komponenten (\"Komponenten aufnehmen\") beginnen. Da die Kommunikation zwischen dem QF‑Test UI Automation Client und der zu testenden Anwendung über Windows (konkret, den UI Automation Core) läuft, ist der Zugriff auf die Komponenten nicht ganz so schnell wie Sie dies vielleicht von der QF‑Test Java-Automatisierung kennen. Außerdem werden Events im Gegensatz zu Java- oder Web-Tests (QF-Driver) asynchron verarbeitet. Das bedeutet, dass Sie nicht davon ausgehen können, dass der Dispatch Thread der Applikation geblockt wird während QF‑Test ein Ereignis bearbeitet. Dies macht Aufnahmen schwieriger, wenn die Zielkomponente in Folge der aufzunehmenden Aktion verschwindet bevor QF‑Test die Komponentenidentifizierung abgeschlossen hat. Zum Beispiel bei der Aufnahme eines Combobox-Eintrags, der die Liste nach dem Klick sofort schließt, oder eines Buttons, der das Fenster, in dem er liegt, beendet. Daher ist es sinnvoll, wenn Sie folgende Vorgehensweise beachten: Aktivieren Sie den Aufnahmemodus und bewegen Sie die Maus zu dem Element, für das Sie eine Aktion aufnehmen wollen. Da QF‑Test etwas Zeit benötigt um das Element unter dem Mauszeiger zu identifizieren, wird ein rotes Panel angezeigt bis der Vorgang abgeschlossen ist. In dem kleinen 'QF‑Test Element Information' Fenster sehen Sie dann, welche Komponente erkannt wurde. Führen Sie nun die aufzunehmende Aktion aus. Wenn Sie einen Mausklick aufnehmen, der einen Dialog oder ein Fenster schließt (auch Popup-Listen), halten Sie die Maustaste ein wenig länger gedrückt, so dass QF‑Test die Möglichkeit hat, die nötigen Informationen auszulesen bevor das Fenster verschwindet, was häufig fast zeitgleich mit dem Loslassen der Maustaste geschieht. Bei der Aufnahme von Checks oder Komponenten erscheint ein Rahmen um das Element sobald der Mauszeiger darüber fährt. Bitte warten Sie mit der Aufnahme bis der Rahmen wieder verschwunden ist. Wenn Sie bei der Aufnahme einer Aktion Probleme haben, weil diese zum Beispiel das entsprechende Fenster schließt (Klick auf OK oder Abbrechen Button), kann es hilfreich sein, einen Check auf die entsprechende Komponente aufzunehmen und diesen dann in die gewünschte Aktion zu konvertieren. Manchmal kann das Drücken der Maustaste auch dazu führen, dass ein Element neu generiert wird (zum Beispiel bei der Zubehörtabelle im CarConfiguratorNet WPF Demo). Auch hier kann die Check-Aufnahme helfen. Im Check-Aufnahmemodus legt QF‑Test ein (fast) unsichtbares Fenster über die zu testende Anwendung um so zu verhindern, dass Mausklicks eine Aktion in der Anwendung bewirken.","hash":"usec_wintesting_record","h1":"Aufnahme"},"413":{"id":413,"content":"Komponenten Ein UI Automation Element wird von QF‑Test als Fenster beziehungsweise Komponente innerhalb des Fenster und Komponenten Knotens aufgenommen. Ein manuelles Einfügen von Knoten ist natürlich auch möglich. Die (generische) QF‑Test Klasse entspricht häufig dem Type des UI Automation Elements, zum Beispiel bei Button. Um den Type vom Klassennamen unterscheiden zu können, setzt QF‑Test das Präfix Uia. vor den Type. Analog wird der Kurzname des UI Automation Frameworks als Präfix für die UI Automation Class des Elements verwendet. Zum Beispiel würde QF‑Test bei einer Tabelle einer WPF-Anwendung in Weitere Merkmale des Komponente Knotens einen Eintrag mit classname: WPF.DataGrid anlegen. QF‑Test bildet die Hierarchie der UI Automation Elemente unter Umständen nicht eins zu eins im Komponentenbaum ab. Dies geschieht häufig bei Dialogen (wie zum Beispiel dem Schriftart-Dialog von Notepad), die üblicherweise in der Komponentenhierarchie der UI Automation unter dem Hauptfenster aufgeführt werden. Aus der Sicht von Win32, genauso wie das auch QF‑Test Anwender erwarten würden, sind diese Dialoge top-level Windows und damit in Fenster und Komponenten parallel zum Hauptfenster angeordnet. Andererseits kann ein Kontextmenü, das ganz oben in der UI Automation Hierarchie angesiedelt ist, in QF‑Test innerhalb eines Fensters zu finden sein.","hash":"usec_wintesting_comps","h1":"Komponenten"},"414":{"id":414,"content":"Wiedergabe und Patterns Die win Engine unterstützt neben den bereits aus anderen Engines bekannten Mausklicks auch verschiedene Spezialaktionen die nicht auf Mausklicks basieren. Zum Beispiel kann die Aktion einer Schaltfläche mittels +Auswahl: invoke [myButtonID] ausgelöst werden. Die Wirkung sollte die gleiche sein wie bei +Mausklick [myButtonID] Bei einem Auswahl wird die Maus nicht verwendet. Stattdessen löst der UI Automation Prozess die Ausführung einer Invoke() Methode des Providers im SUT aus. Der Auswahl Knoten unterstützt die folgenden Aktionen im Attribut Detail: invoke, expand, collapse, select, toggle und scroll. In der nachfolgenden Tabelle werden sie detailiert beschrieben:","hash":"usec_wintesting_play","h1":"Wiedergabe und Patterns"},"415":{"id":415,"content":"Detail Beschreibung Pattern invoke Meist gleichwertig mit einem Mausklick. InvokePattern expand, collapse Dies sollte eine Combobox, ein MenuItem oder ein TreeItem aus- beziehungsweise einklappen. ExpandCollapsePattern select[:0|-1|1] Wählt einen Listeneintrag aus. Wenn als Detail -1 bzw. 1 angegeben wird, so wird eine Mehrfachauswahl erweitert oder verringert. SelectionItemPattern toggle[:on|off] Ändert den Zustand einer CheckBox. TogglePattern scroll:horiz%,vert% Erlaubt Werte zwischen 0 und 100, die die Scroll-Position in Prozent angeben. -1, wenn die Position (Horizontal oder vertikal) nicht verändert werden soll. ScrollPattern Tabelle 15.1: Unterstützte Details für Auswahl Welche Aktionen tatsächlich auf einem Control abgespielt werden können, hängt davon ab, welche Pattern das entsprechende UI Automation Elements implementiert. Die verfügbaren Patterns werden unter Weitere Merkmale einer Komponente abgespeichert oder können in einem SUT-Skript mit dem Befehl print rc.getComponent(id).getPatterns() ermittelt werden. Die genaue Bedeutung eines Patterns kann sich von Anwendung zu Anwendung unterscheiden. Wenn sowohl das SelectionItem-Pattern als auch das Invoke-Pattern unterstützt werden, sollte invoke bevorzugt werden, da +Select [list@item] eventuell nur das Element markiert, nicht jedoch die entsprechende Aktion auslöst. (Ein Beispiel hierfür ist die Schriftartenauswahl bei Notepad.) Die formale Unterstützung eines Patterns bedeutet leider noch lange nicht, dass der Aufruf des entsprechenden Auswahl-Events irgendeine Wirkung zeigt. Dies ist zum Beispiel in der Rechner-Applikation von Windows der Fall, wenn man zu einem (nicht sichtbaren) Eintrag der Modus-Auswahlliste blättern möchte (ScrollItem pattern). Um dieses Problem zu umgehen, kann in diesem Fall ein select abgespielt werden, unabhängig davon, ob der Eintrag gerade sichtbar ist. Weil das \"weiche\" Abspielen von Aktionen häufig im provider nicht implementiert ist funktionieren diese Spezialaktionen nur bedingt. Bei Tastaturevents kann ein Text nur dann direkt über einen Texteingabe Knoten gesetzt werden, wenn das Value pattern unterstützt wird. Ansonsten muss der Text über einzelne Tastaturevents eingegeben werden.","hash":"table_15.1","h1":"Wiedergabe und Patterns"},"416":{"id":416,"content":"Skripting Intern stellt die win Engine ein UI Automation Element mit der Klasse WinControl dar. Um auf ein Element in einem Groovy SUT-Skript Knoten zuzugreifen, führen Sie folgendes Skript mit der passenden QF‑Test ID der Komponente aus: def winc = rc.getComponent(\"myComponentID\") println winc Beispiel 15.1: Zugriff auf ein WinControl in einem Groovy-SUT-Skript Die Methoden der Klasse WinControl sind in \"Die WinControl Klasse\" detailliert beschrieben: getUiaType(), getUiaClassName(), getFramework(), getUiaName(), getUiaId(), getUiaDescription(), getUiaHelp(), getHwnd(), getLocation(), getSize(), getLocationOnScreen(), getPatterns(), hasPattern() um die UI Automation Eigenschaften eines Elements zu erhalten getChildren(), getParent(), getChildrenOfType(), getAncestorOfType(), getElementsByClassName() für die Elementhierarchie getUiaControl() um ein AutomationBase zu erhalten, welches dann mit der uiauto-Skriptbibliothek verwendet werden kann (\"Steuern und Testen von nativen Windows-Anwendungen - ohne Verwendung der QF‑Test win Engine\").","hash":"usec_wintesting_script","h1":"Skripting"},"417":{"id":417,"content":"Optionen Das Verhalten der win Engine kann über die QF‑Test Optionen beeinflusst werden. Darüber hinaus können noch Properties gesetzt werden, die den nativen Teil des UI Automation Clients beeinflussen. Diese Optionen und Properties können in einem SUT-Skript Knoten gesetzt werden via: rc.setOption(<name>, <value>) bzw. rc.engine.preferences().setPref(<name>, <value>) Um die gesetzte Option zurückzusetzen genügt: rc.unsetOption(<name>)","hash":"usec_wintesting_options","h1":"Optionen"},"418":{"id":418,"content":"Windows Skalierung Auf Grund stetig wachsender Bildschirmauflösungen in den letzten Jahren gibt es in Windows die Möglichkeit die Skalierungseinstellungen anzupassen. Windows-Anwendungen sowie ihre Komponenten und die darin dargestellte Schrift werden an diesen Skalierungsfaktor angepasst. UWP, WPF und Windows-Forms-Anwendungen skalieren normalerweise automatisch aber Win32-Anwendungen und deren Steuerelemente im Besonderen behalten teilweise ihre Größe oder skalieren auf andere Weise. QF‑Test arbeitet standardmäßig mit physischen Bildschirmkoordinaten. Angenommen die Skalierung ist auf 125% gesetzt und eine Schaltfläche würde bei 100% Skalierung an der Position (24,40) mit einer Größe von (100,20) existieren, so wäre diese bei dieser Skalierung an Position (30,50) und hätte eine Größe von (125,25). Daraus ergeben sich folgende Konsequenzen: unterschiedliche Geometrie wenn die Komponente erneut aufgenommen wird Unterschiede bei der Geometrie, wenn QF‑Test versucht eine Komponente zu identifizieren, die mit 100% Skalierung aufgenommen wurde. Ein (harter) Mausklick auf einen bestimmten Bereich innerhalb eines Elementes kann fehlschlagen, weil der skalierte Bereich weiter von der oberen-rechten Ecke des Elementes entfernt ist. Damit QF‑Test mit logischen anstelle von physischen Koordinaten arbeitet, kann Options.OPT_WIN_USE_SCALING auf true gesetzt werden. QF‑Test verwendet dann den Skalierungsfaktor des primären Monitors um die Geometrie für Komponenten und die Koordinaten für Maus-Events anzupassen. Bei dieser Anpassung kann es je nach eingestelltem Skalierungsfaktor zu Rundungsfehlern kommen, wenn die Koordinaten neu berechnet werden, da diese als Integerwerte gespeichert sind. Das kann dazu führen, dass Koordinaten um 1 Pixel abweichen.","hash":"sec_windows_skalierung","h2":"Windows Skalierung"},"419":{"id":419,"content":"Sichtbarkeit Es kann vorkommen, dass ein Ereignis auf eine Komponente ausgelöst werden soll, die gerade nicht sichtbar ist (da sie gerade außerhalb des sichtbaren Bereiches gescrollt ist). Um auf diese Komponente ein invoke Event abzuspielen, muss vorher die Prüfung auf Sichtbarkeit deaktiviert werden, die normalerweise ein Bestandteil der Objekterkennung ist. Das kann durch das Setzen von Options.OPT_WIN_TEST_VISIBILITY auf false erreicht werden. Nach der Wiedergabe des jeweiligen Events sollte die Sichtbarkeitsprüfung wieder aktiviert werden.","hash":"sec_sichtbarkeit","h2":"Sichtbarkeit"},"420":{"id":420,"content":"Verbinden zu einem Fenster einer bestimmten Klasse Wenn eine Anwendung via -class <class name> verbunden wird, ignoriert QF‑Test standardmäßig alle Haupt-Fenster der Anwendung, die nicht dieser Klasse entsprechen. Auf diesem Weg kann man QF‑Test zum Beispiel lediglich mit der Windows Taskbar verbinden und den Desktop und die darauf liegenden Icons komplett ignorieren, obwohl sie im gleichen Prozess laufen. Um dennoch alle Haupt-Fenster (toplevels) eines Prozesses zugreifbar zu machen, kann die Präferenz \"windriver.restrict.tops.to.class\" auf \"false\" gesetzt werden.","hash":"sec_verbinden_zu_einem_fenster_einer_bestimmten_klasse","h2":"Verbinden zu einem Fenster einer bestimmten Klasse"},"421":{"id":421,"content":"Begrenzung der Anzahl von Kind-Elementen Große Hierarchien von UI Automation Elementen können Aufnahme und Wiedergabe deutlich verlangsamen. Um dem entgegenzuwirken, begrenzt QF‑Test die Anzahl der Kind-Elemente, wenn diese vom Client abgerufen werden. Der vorgegebene Wert beträgt 100 und kann über Options.OPT_WIN_MAX_CHILDREN angepasst werden.","hash":"sec_begrenzung_der_anzahl_von_kind_elementen","h2":"Begrenzung der Anzahl von Kind-Elementen"},"422":{"id":422,"content":"(Aktuelle) Einschränkungen Die aktuelle Implementierung des Windows-Testens enthält noch eine Reihe von Einschränkungen. Wir werden versuchen, die Funktionalität laufend zu verbessern, doch mag die eine oder andere Einschränkung noch eine Weile bestehen. Da die Unterstützung der UI Automation vom Framework abhängt, mit dem die Anwendung entwickelt wurde, ist die Aufnahme in QF‑Test eventuell nicht konsistent. Zum Beispiel kann beim Öffnen eines Dialogs ein Warten auf Komponente aufgezeichnet werden oder auch nicht. Das Testen von Anwendungen, die aus mehreren Prozessen bestehen, ist komplex und erfordert mehrere win Clients. Weitere Einschränkungen und noch nicht implementierte Funktionalitäten (Stand Januar 2020) sind unter anderem: Die unterstützten Check-Arten sind so gut wie vollständig. Es fehlen aber noch einige speziellere Checks. Dies sollen in einer zukünftigen QF‑Test Version vervollständigt werden. Elemente einer Titelleiste einer Windows App können nicht (einfach) angesprochen werden, weil diese in einem anderen Prozess liegen. Dies könnte in einer zukünftigen QF‑Test Version behoben werden. Die Event-Weiterleitung vom Textelement einer Schaltfläche auf das Schaltflächenelement selbst erfolgt bei der Aufnahme eines Mausklicks, kann aber an anderer Stelle fehlen. Dies sollte in einer zukünftigen QF‑Test Version behoben sein.","hash":"usec_wintesting_limits","h1":"(Aktuelle) Einschränkungen"},"423":{"id":423,"content":"Links Die Windows Automation API ist beschrieben unter: https://docs.microsoft.com/en-US/windows/desktop/WinAuto/windows-automation-api-portal. Weitere Informationen zu Mark Humphreys ui-automation Java-Bibliothek finden Sie unter https://github.com/mmarquee.","hash":"usec_wintesting_links","h1":"Links"},"424":{"id":424,"content":"Pro Handbuch","hash":"","h0":"Android-Anwendungen testen | QF‑Test Handbuch"},"425":{"id":425,"content":"Pro Handbuch","hash":"home-link","h0":"Android-Anwendungen testen | QF‑Test Handbuch"},"426":{"id":426,"content":"Android-Anwendungen testen Dieses Kapitel behandelt die Testautomatisierung von nativen Android-Anwendungen. Zum Einstieg gibt es auch ein kurzes Überblicksvideo zu Android Testen auf unserem QF‑Test YouTube Kanal. Im Juni 2022 fand ein Spezial-Webinar zum Thema Android Testen mit QF‑Test statt, das nach etwas Theorie das detaillierte Arbeiten mit dem Emulator und einem echten Gerät zeigt. Hier geht es zum Videomitschnitt des Spezial-Webinars auf unserem QF‑Test YouTube Kanal. Sollten Sie mobile Web-Anwendungen testen wollen, schauen Sie sich bitte die Möglichkeiten der mobilen Browser-Emulation des Chrome Desktop-Browsers an, welche im \"Testen von mobilen Webseiten\" beschrieben werden. Obwohl es möglich ist, einen Webbrowser auf Android-Geräten (vorausgesetzt er unterstützt die Accessibility Schnittstelle) zu nutzen, bietet die mobiles Browser-Emulation bessere Automatisierungsmöglichkeiten und weniger Aufwand für mobiles Web-Testen.","hash":"usec_androidtesting","h1":"Android-Anwendungen testen"},"427":{"id":427,"content":"Pro Handbuch","hash":"","h0":"Voraussetzungen und bekannte Einschränkungen | QF‑Test Handbuch"},"428":{"id":428,"content":"Pro Handbuch","hash":"home-link","h0":"Voraussetzungen und bekannte Einschränkungen | QF‑Test Handbuch"},"429":{"id":429,"content":"Voraussetzungen und bekannte Einschränkungen","hash":"sec_android_restrict_precond","h0":"Voraussetzungen und bekannte Einschränkungen"},"430":{"id":430,"content":"Voraussetzungen Für Android Tests mit QF‑Test müssen folgende Voraussetzungen für den Testrechner erfüllt sein: Soll ein Android-Emulator genutzt werden, ist ein ausreichend performanter Rechner erforderlich (keine alte Mühle - :-). Zusätzlich kann es sinnvoll sein die Hardware-Beschleunigung (typischerweise im Bios) zu aktivieren, falls der Emulator trotzdem zu langsam ist. Weitere Details findet man unter https://developer.android.com/studio/run/emulator-acceleration. Die Android SDK Command-Line Tools müssen auf dem Rechner verfügbar sein, besser noch, eine Installation des Android Studios, wie in \"Installation des Android Studios, Emulators und virtueller Geräte\" beschrieben. Entweder: Ein echtes Android Mobilgerät, das (typischerweise per Kabel) mit dem Rechner verbunden ist, wobei USB Debugging auf dem Mobilgerät aktiviert sein muss (siehe \"Verbinden mit einem echten Android-Gerät\"). Oder: Ein Android-Emulator ist installiert, welches am einfachsten über das Android Studio geschieht, auf dem ein passendes Android Virtual Device (AVD) läuft (siehe \"Android Studio AVD Konfiguration\"). Auf dem echten oder virtuellen Android-Gerät muss die Android-API 24 oder größer sein. Dies entspricht der Android Version 7 Nougat oder neuer (siehe Andriod Versionsliste auf Wikipedia).","hash":"sec_android_precond","h1":"Voraussetzungen"},"431":{"id":431,"content":"Bekannte Einschränkungen Es gibt folgende Einschränkungen in der dieser Version: Nur ein Android Client kann derzeit gleichzeitig verbunden und gesteuert werden. Es ist geplant, dies auf mehrere Clients zu erweitern, wie es auch für die anderen GUI Technologien unterstützt wird.","hash":"sec_android_restrict","h1":"Bekannte Einschränkungen"},"432":{"id":432,"content":"Pro Handbuch","hash":"","h0":"Emulator oder echtes Gerät | QF‑Test Handbuch"},"433":{"id":433,"content":"Pro Handbuch","hash":"home-link","h0":"Emulator oder echtes Gerät | QF‑Test Handbuch"},"434":{"id":434,"content":"Emulator oder echtes Gerät Wenn man mit Android Testing startet, stellt sich die Frage, wie man beginnen möchte: mit einem virtuellen oder echten Android-Gerät. Es kann ein echtes Android-Gerät zum automatisierten Testen mit QF‑Test verwendet werden. Dieses muss die Entwickleroption für USB Debugging aktiviert haben und per USB Kabel mit dem Rechner verbunden sein, auf dem QF‑Test läuft. Mit Hilfe einer passenden Startsequenz verbindet sich QF‑Test mit diesem Gerät und kann dieses dann kontrollieren. Es können Aktionen und Tests aufgezeichnet und abgespielt werden. Ein virtuelles Android-Gerät (AVD) ist die Nachbildung eines echten Gerätes. Es läuft mittels einer Emulator-Software, die auf dem Computer die Hardware und das Verhalten des echten Gerätes emuliert, also nachbildet. Ein Android-Emulator ist also eine Software, um Android-Anwendungen auf einem Computer ausführen und testen zu können. Der Emulator kann hierbei verschiedene virtuelle Android-Geräte laden, die auf unterschiedlichen Android Versionen basieren oder auch Geräte spezifischer Hersteller abbilden. Bei der Nutzung eines Emulators startet QF‑Test diesen im Regelfall am Anfang des Tests, dann lädt und verbindet sich mit dem vom Nutzer definierten virtuellen Android Gerät. Als letztes wird die zu testende Android-Anwendung geöffnet. Dann können Aktionen und Tests aufgezeichnet und ausgeführt werden. Der Vorteil des Emulators ist, dass man keine Abhängigkeit zu einem externen Gerät hat und flexibel mit unterschiedlichen virtuellen Geräten testen kann. Man hat aber etwas mehr Initialaufwand und ggf. auch mehr Last auf seinem Rechner. Ein echtes Gerät erlaubt einen schnelleren Einstieg, erfordert aber die Aktivierung des USB Debuggings und ist weniger flexibel.","hash":"sec_android_emulator_or_device","h0":"Emulator oder echtes Gerät"},"435":{"id":435,"content":"Pro Handbuch","hash":"","h0":"Installation des Android Studios, Emulators und virtueller Geräte | QF‑Test Handbuch"},"436":{"id":436,"content":"Pro Handbuch","hash":"home-link","h0":"Installation des Android Studios, Emulators und virtueller Geräte | QF‑Test Handbuch"},"437":{"id":437,"content":"Installation des Android Studios, Emulators und virtueller Geräte Der einfachste Weg zur Installation der erforderlichen Android SDK Command-Line tools und des Emulators sowie zur Konfiguration eines virtuellen Geräts ist das Android Studio. Es besteht auch die Möglichkeit, nur das Android SDK oder sogar nur die SDK Command line tools zu installieren. Dabei gibt es aber einige Fallstricke, weshalb wir uns entschlossen haben, hier den Weg über das Android Studio zu beschreiben. Falls Sie nicht bereits das Android Studio installiert haben, sind die folgenden Schritte notwendig:","hash":"sec_android_studio","h0":"Installation des Android Studios, Emulators und virtueller Geräte"},"438":{"id":438,"content":"Android Studio installation Laden Sie das Android Studio von https://developer.android.com/studio herunter. Die Installation benötigt ca. 2.7 GB Plattenplatz. Führen Sie die Installation mit Standardeinstellungen durch, wodurch es im Anschluss auch gestartet wird. In dem Setup Assistenten können Sie die vorgeschlagenen Einstellungen übernehmen. Bei der Installation könnte nach einer Änderung der Kommandozeileneinstellungen gefragt werden, die Sie annehmen können. Schließen Sie die Installation ab.","hash":"android_studio_install","h1":"Android Studio installation"},"439":{"id":439,"content":"Android Studio AVD Konfiguration Da wir das Android Studio nur zur Konfiguration eines virtuellen Geräts verwenden wollen, wählen Sie bitte »Virtual Device Manager« aus dem Menü »More Actions« (manchmal dargestellt durch drei vertikale Punkte ganz oben rechts). Ansonsten finden Sie den Device Manager auch im Tools Menü.","hash":"android_studio_avd_conf","h1":"Android Studio AVD Konfiguration"},"440":{"id":440,"content":"Da wir das Android Studio nur zur Konfiguration eines virtuellen Geräts verwenden wollen, wählen Sie bitte »Virtual Device Manager« aus dem Menü »More Actions« (manchmal dargestellt durch drei vertikale Punkte ganz oben rechts). Ansonsten finden Sie den Device Manager auch im Tools Menü. Abbildung 16.1: Android Studio Startfenster Wählen Sie »Create device...«.","hash":"fig_android_studio_start","h1":"Android Studio AVD Konfiguration"},"441":{"id":441,"content":"Wählen Sie »Create device...«. Abbildung 16.2: Android Studio Dialog zur Erzeugung eines virtuellen Gerätes Wählen Sie ein passendes virtuelles Gerät. Wir empfehlen eher solche mit kleineren Bildschirmgrößen, da dies sowohl Speicherplatz spart als auch die vollständige Anzeige des virtuellen Geräts auf Ihrem Bildschirm ermöglicht.","hash":"fig_android_studio_avd","h1":"Android Studio AVD Konfiguration"},"442":{"id":442,"content":"Wählen Sie ein passendes virtuelles Gerät. Wir empfehlen eher solche mit kleineren Bildschirmgrößen, da dies sowohl Speicherplatz spart als auch die vollständige Anzeige des virtuellen Geräts auf Ihrem Bildschirm ermöglicht. Abbildung 16.3: Android Studio Dialog zur Auswahl der Gerätedefinition Laden Sie nun das System Image für die gewünschte Android Version herunter. Klicken Sie den entsprechenden \"Download\" Link um den \"Component Installer\" zu starten und danach auf \"Finish\".","hash":"fig_android_studio_avd_hw","h1":"Android Studio AVD Konfiguration"},"443":{"id":443,"content":"Laden Sie nun das System Image für die gewünschte Android Version herunter. Klicken Sie den entsprechenden \"Download\" Link um den \"Component Installer\" zu starten und danach auf \"Finish\". Abbildung 16.4: Android Studio Dialog für Download und Auswahl des System Images Um die Installation abzuschließen drücken Sie \"Finish\" auf dem letzten Konfigurationsdialog.","hash":"fig_android_studio_system_image","h1":"Android Studio AVD Konfiguration"},"444":{"id":444,"content":"Um die Installation abzuschließen drücken Sie \"Finish\" auf dem letzten Konfigurationsdialog. Abbildung 16.5: Android Studio Dialog zum Abschluss der AVD Konfiguration Nun steht das erste virtuelle Gerät (AVD) für QF‑Test bereit.","hash":"fig_android_studio_avd_finish","h1":"Android Studio AVD Konfiguration"},"445":{"id":445,"content":"Nun steht das erste virtuelle Gerät (AVD) für QF‑Test bereit. Abbildung 16.6: Android Studio Dialog zeigt verfügbare AVDs","hash":"fig_android_studio_avd_available","h1":"Android Studio AVD Konfiguration"},"446":{"id":446,"content":"Pro Handbuch","hash":"","h0":"Verbinden mit einem echten Android-Gerät | QF‑Test Handbuch"},"447":{"id":447,"content":"Pro Handbuch","hash":"home-link","h0":"Verbinden mit einem echten Android-Gerät | QF‑Test Handbuch"},"448":{"id":448,"content":"Verbinden mit einem echten Android-Gerät Für Tests auf einem echten Android-Gerät muss dieses über ein USB-Kabel mit dem Rechner, auf dem QF‑Test läuft, verbunden sein. Außerdem muss USB Debugging aktiviert werden. Zusätzlich wird ein Android SDK auf Ihrer Maschine benötigt. Obwohl es ausreichend sein kann, nur die SDK Kommandozeilewerkzeuge zu installieren, empfehlen wir das volle Android Studio zu nutzen, wie in \"Installation des Android Studios, Emulators und virtueller Geräte\" beschrieben. USB Debugging aktivieren Aktivieren Sie USB Debugging für Ihre Android-Gerät. Im Regelfall sind dafür folgende Schritte notwendig: Öffnen Sie auf dem Gerät \"Einstellung\" -> \"Über 'Gerät'\". Tippen Sie sieben Mal auf die Build-Nummer, um \"Einstellungen\" -> \"Entwickleroptionen\" verfügbar zu machen. Dort aktivieren Sie dann die Option \"USB Debugging\" Die Referenzdokumentation zum Aktivieren der Entwickleroptionen finden Sie unter https://developer.android.com/studio/debug/dev-options. Geräte und PC mittels USB Kabel verbinden Wenn Sie Ihr Android-Gerät mit dem Rechner verbunden haben und eine Abfrage erscheint, ob USB Debugging für diesen Rechner erlaubt / dauerhaft erlaubt werden soll, so bestätigen Sie dies bitte.","hash":"sec_android_real_device","h0":"Verbinden mit einem echten Android-Gerät"},"449":{"id":449,"content":"Pro Handbuch","hash":"","h0":"Eine QF‑Test Startsequenz für Android Tests erzeugen | QF‑Test Handbuch"},"450":{"id":450,"content":"Pro Handbuch","hash":"home-link","h0":"Eine QF‑Test Startsequenz für Android Tests erzeugen | QF‑Test Handbuch"},"451":{"id":451,"content":"Eine QF‑Test Startsequenz für Android Tests erzeugen Wie immer, öffnen Sie den Schnellstart-Assistenten über das »Extras« Menü oder über den Knopf in der Werkzeugleiste. Wählen Sie \"Eine Android-Anwendung\".","hash":"sec_android_test_setup","h0":"Eine QF‑Test Startsequenz für Android Tests erzeugen"},"452":{"id":452,"content":"Wählen Sie \"Eine Android-Anwendung\". Abbildung 16.7: Auswahl des Anwendungstyps im Schnellstart-Assistenten","hash":"fig_android_quickstart_type","h0":"Eine QF‑Test Startsequenz für Android Tests erzeugen"},"453":{"id":453,"content":"Nutzung eines Android-Emulators Wählen Sie die erste Auswahl \"Einen Emulator starten und mit virtuellem Gerät verbinden\".","hash":"sec_android_test_setup_emulator","h1":"Nutzung eines Android-Emulators"},"454":{"id":454,"content":"Wählen Sie die erste Auswahl \"Einen Emulator starten und mit virtuellem Gerät verbinden\". Abbildung 16.8: Auswahl des Emulators als genutztes Testgerät im Schnellstart-Assistenten Wählen Sie das virtuelle Gerät aus der Auswahlliste oben. Drücken Sie \"Aktualisieren\", falls kein virtuelles Gerät angezeigt werden sollte. Falls dann immer noch keines sichtbar ist, starten Sie ggf. QF‑Test neu, um neu hinzugekommene Geräte einzulesen. Klicken Sie dann \"Weiter\".","hash":"fig_android_quickstart_emulator","h1":"Nutzung eines Android-Emulators"},"455":{"id":455,"content":"Wählen Sie das virtuelle Gerät aus der Auswahlliste oben. Drücken Sie \"Aktualisieren\", falls kein virtuelles Gerät angezeigt werden sollte. Falls dann immer noch keines sichtbar ist, starten Sie ggf. QF‑Test neu, um neu hinzugekommene Geräte einzulesen. Klicken Sie dann \"Weiter\". Abbildung 16.9: Auswahl des AVDs im Schnellstart-Assistenten Als nächsten Schritt können Sie die Android .apk Datei der zu testenden App angeben. Falls Sie eine App testen wollen, die bereits auf dem Android-Gerät installiert ist, so überspringen Sie diesen Schritt.","hash":"fig_android_quickstart_avd","h1":"Nutzung eines Android-Emulators"},"456":{"id":456,"content":"Als nächsten Schritt können Sie die Android .apk Datei der zu testenden App angeben. Falls Sie eine App testen wollen, die bereits auf dem Android-Gerät installiert ist, so überspringen Sie diesen Schritt. Abbildung 16.10: Auswahl der .apk Datei im Schnellstart-Assistenten Im nächsten Schritt können Sie einen Client-Namen angeben. Klicken Sie dann \"Weiter\" und zum Schluss \"Fertig\".","hash":"fig_android_quickstart_apk","h1":"Nutzung eines Android-Emulators"},"457":{"id":457,"content":"Im nächsten Schritt können Sie einen Client-Namen angeben. Klicken Sie dann \"Weiter\" und zum Schluss \"Fertig\". Abbildung 16.11: Auswahl des Client-Namens im Schnellstart-Assistenten Nun wird in der aktuellen Testsuite im Knoten \"Extrasequenzen\" eine Vorbereitungssequenz erzeugt. Sie sollte selbsterklärend sein.","hash":"fig_android_quickstart_client","h1":"Nutzung eines Android-Emulators"},"458":{"id":458,"content":"Nun wird in der aktuellen Testsuite im Knoten \"Extrasequenzen\" eine Vorbereitungssequenz erzeugt. Sie sollte selbsterklärend sein. Abbildung 16.12: Vom Schnellstart-Assistenten erzeugte Startsequenz für den Android-Emulator Wenn Sie die Vorbereitungssequenz ausführen, sollte das Emulatorfenster erscheinen und nach kurzer Zeit auch die App, falls Sie eine .apk Datei angegeben haben. Der Aufnahmeknopf sollte aktiviert sein, was anzeigt, dass die Verbindung erfolgreich aufgebaut wurde.","hash":"fig_android_quickstart_setup_sequence","h1":"Nutzung eines Android-Emulators"},"459":{"id":459,"content":"Wenn Sie die Vorbereitungssequenz ausführen, sollte das Emulatorfenster erscheinen und nach kurzer Zeit auch die App, falls Sie eine .apk Datei angegeben haben. Der Aufnahmeknopf sollte aktiviert sein, was anzeigt, dass die Verbindung erfolgreich aufgebaut wurde. Abbildung 16.13: Fenster des Android-Emulators","hash":"fig_android_emulator","h1":"Nutzung eines Android-Emulators"},"460":{"id":460,"content":"Nutzung eines echten Android-Gerätes Wählen Sie die zweite Option \"Mit echtem Android-Gerät oder laufendem virtuellen Android-Gerät verbinden\".","hash":"sec_android_test_setup_real_device","h1":"Nutzung eines echten Android-Gerätes"},"461":{"id":461,"content":"Wählen Sie die zweite Option \"Mit echtem Android-Gerät oder laufendem virtuellen Android-Gerät verbinden\". Abbildung 16.14: Auswahl eines echten Gerätes als Typ im Schnellstart-Assistenten Wählen Sie aus der Auswahllist den angegebenen Eintrag, die die ID des verbundenen Geräts darstellt. Klicken Sie \"Aktualisieren\" falls kein Gerät sichtbar ist. Falls immer noch kein Gerät angezeigt wird, starten Sie QF‑Test neu, damit neu angeschlossenen Geräte erkannt werden. Klicken Sie nun \"Weiter\".","hash":"fig_android_quickstart_real_type","h1":"Nutzung eines echten Android-Gerätes"},"462":{"id":462,"content":"Wählen Sie aus der Auswahllist den angegebenen Eintrag, die die ID des verbundenen Geräts darstellt. Klicken Sie \"Aktualisieren\" falls kein Gerät sichtbar ist. Falls immer noch kein Gerät angezeigt wird, starten Sie QF‑Test neu, damit neu angeschlossenen Geräte erkannt werden. Klicken Sie nun \"Weiter\". Abbildung 16.15: Auswahl des Gerätes im Schnellstart-Assistenten Als nächsten Schritt können Sie die Android .apk Datei der zu testenden App angeben. Falls Sie eine App testen wollen, die bereits auf dem Android-Gerät installiert ist, so überspringen Sie diesen Schritt.","hash":"fig_android_quickstart_real_device","h1":"Nutzung eines echten Android-Gerätes"},"463":{"id":463,"content":"Als nächsten Schritt können Sie die Android .apk Datei der zu testenden App angeben. Falls Sie eine App testen wollen, die bereits auf dem Android-Gerät installiert ist, so überspringen Sie diesen Schritt. Abbildung 16.16: Auswahl der App im Schnellstart-Assistenten Im nächsten Schritt können Sie einen Client-Namen angeben. Klicken Sie dann \"Weiter\" und zum Schluss \"Fertig\".","hash":"fig_android_quickstart_real_apk","h1":"Nutzung eines echten Android-Gerätes"},"464":{"id":464,"content":"Im nächsten Schritt können Sie einen Client-Namen angeben. Klicken Sie dann \"Weiter\" und zum Schluss \"Fertig\". Abbildung 16.17: Festlegung des Client-Names im Schnellstart-Assistenten Nun wird in der aktuellen Testsuite im Knoten \"Extrasequenzen\" eine Vorbereitungssequenz erzeugt. Sie sollte selbsterklärend sein und enthält den Hinweis, dass in dieser Frühtesterphase die qfsandroid.qft Testsuite für die Ausführung der Vorbereitungssequenz benötigt wird und automatisch inkludiert wurde.","hash":"fig_android_quickstart_real_client","h1":"Nutzung eines echten Android-Gerätes"},"465":{"id":465,"content":"Nun wird in der aktuellen Testsuite im Knoten \"Extrasequenzen\" eine Vorbereitungssequenz erzeugt. Sie sollte selbsterklärend sein und enthält den Hinweis, dass in dieser Frühtesterphase die qfsandroid.qft Testsuite für die Ausführung der Vorbereitungssequenz benötigt wird und automatisch inkludiert wurde. Abbildung 16.18: Vom Schnellstart-Assistenten erzeugte Startsequenz für das echte Android-Gerät Wenn Sie die Vorbereitungssequenz ausführen, sollte der Aufnahmeknopf aktiviert werden, was anzeigt, dass die Verbindung erfolgreich zustande gekommen ist. Falls Sie eine .apk Datei angegeben haben, sollte die App nun auf dem Android-Gerät sichtbar werden.","hash":"fig_android_quickstart_real_setup_sequence","h1":"Nutzung eines echten Android-Gerätes"},"466":{"id":466,"content":"Pro Handbuch","hash":"","h0":"Aktionen und Checks auf der Android-App aufnehmen | QF‑Test Handbuch"},"467":{"id":467,"content":"Pro Handbuch","hash":"home-link","h0":"Aktionen und Checks auf der Android-App aufnehmen | QF‑Test Handbuch"},"468":{"id":468,"content":"Aktionen und Checks auf der Android-App aufnehmen Bitte drücken Sie den Aufnahmeknopf, um zu sehen, wie sich QF‑Test bei Android Aufnahmen verhält. Es erscheint ein spezielles Aufnahmefenster, das den Bildschirm des echten Geräts beziehungsweise des Emulators wiedergibt. Dieses Fenster ist notwendig, da es aktuell nicht möglich ist, Aktionen direkt auf dem Gerät oder Emulator aufzuzeichnen. Dies geschieht über das Aufzeichnungsfenster. Mit den Zoom Knöpfen können Sie die Anzeige auf die gewünschte Größe bringen. Bitte beachten Sie, dass das Aufnahmefenster nur ein Abbild der Gerätebildschirms zeigt. Dieses muss gegebenenfalls manuell über den Aktualisierungsknopf aufgefrischt werden oder kann auch automatisch durch Aktivieren von erfolgen.","hash":"sec_android_recording","h0":"Aktionen und Checks auf der Android-App aufnehmen"},"469":{"id":469,"content":"Mit den Zoom Knöpfen können Sie die Anzeige auf die gewünschte Größe bringen. Bitte beachten Sie, dass das Aufnahmefenster nur ein Abbild der Gerätebildschirms zeigt. Dieses muss gegebenenfalls manuell über den Aktualisierungsknopf aufgefrischt werden oder kann auch automatisch durch Aktivieren von erfolgen. Abbildung 16.19: QF‑Test Android-Aufnahmefenster Nun können Sie Aktionen und Checks aufnehmen und auch wieder abspielen. Anfangs mag es sich etwas ungewohnt anfühlen, mit dem Aufnahmefenster zu arbeiten, aber Sie werden sich bald daran gewöhnen. Abgesehen von diesen Android Spezifika sollte QF‑Test genauso funktionieren wie bei den anderen GUI Technologien, abgesehen von in \"Bekannte Einschränkungen\" beschriebenen bekannten Einschränkungen. Zusatzfunktionen: Das Aufnahmefenster bietet auch ein paar Annehmlichkeiten. In der Fußzeile links werden die Mauskoordinaten angezeigt, was sehr praktisch ist, wenn man mit absoluten Mausklicks arbeiten muss. Rechts wird die Klasse der letzten hervorgehobenen Komponente angezeigt. Über den Fadenkreuz-Knopf in der Werkzeugleiste können Sie ein Inspektor-Fenster öffnen, siehe \"UI-Inspektor\", das die Komponentenhierarchie aller sichtbaren Komponenten inklusive Größe und Koordinaten anzeigt. Dies dient hauptsächlich der Nachverfolgung von Problemen bei der Komponentenaufnahme oder Wiedererkennung, kann aber auch sonst hin und wieder nützlich sein.","hash":"fig_android_recording_window","h0":"Aktionen und Checks auf der Android-App aufnehmen"},"470":{"id":470,"content":"Pro Handbuch","hash":"","h0":"Android Hilfsprozeduren | QF‑Test Handbuch"},"471":{"id":471,"content":"Pro Handbuch","hash":"home-link","h0":"Android Hilfsprozeduren | QF‑Test Handbuch"},"472":{"id":472,"content":"Android Hilfsprozeduren Es gibt eine ganze Reihe an verfügbaren Hilfsprozeduren für Android in der Standardbibliothek. Sie befinden sich in dem entsprechend benannten Package \"android\". Einige sind analog zu den anderen GUI Technologien, es gibt aber einige sehr spezifische für mobiles Testen, z.B. um Wischaktionen oder Gesten durchzuführen, zum Blättern auf dem Bildschirm und um bestimmte Einstellungen für Komponenten vorzunehmen.","hash":"sec_android_stdlib","h0":"Android Hilfsprozeduren"},"473":{"id":473,"content":"Abbildung 16.20: Android Hilfsprozeduren","hash":"fig_android_stdlib","h4":"Abbildung 16.20: Android Hilfsprozeduren"},"474":{"id":474,"content":"Pro Handbuch","hash":"","h0":"iOS-Anwendungen testen | QF‑Test Handbuch"},"475":{"id":475,"content":"Pro Handbuch","hash":"home-link","h0":"iOS-Anwendungen testen | QF‑Test Handbuch"},"476":{"id":476,"content":"iOS-Anwendungen testen Dieses Kapitel behandelt die Testautomatisierung von nativen iOS-Anwendungen. Zum Einstieg gibt es auch ein kurzes Überblicksvideo zum iOS-Testing auf unserem QF‑Test YouTube-Kanal. Im September 2024 fand ein Spezialwebinar zum Thema iOS-Testen mit QF‑Test statt, das nach etwas Theorie das detaillierte Arbeiten mit dem Simulator und einem echten Gerät zeigt. Hier geht es zum Videomitschnitt des Spezialwebinars auf unserem QF‑Test YouTube-Kanal. Sollten Sie mobile Web-Anwendungen testen wollen, schauen Sie sich bitte die Möglichkeiten der mobilen Browser-Emulation des Chrome Desktop-Browsers an, welche im \"Testen von mobilen Webseiten\" beschrieben werden. Obwohl es möglich ist, einen Webbrowser auf iOS-Geräten (vorausgesetzt er unterstützt die Accessibility Schnittstelle) zu nutzen, bietet die mobile Browser-Emulation bessere Automatisierungsmöglichkeiten und weniger Aufwand für mobiles Web-Testen.","hash":"usec_iostesting","h1":"iOS-Anwendungen testen"},"477":{"id":477,"content":"Pro Handbuch","hash":"","h0":"Voraussetzungen und bekannte Einschränkungen | QF‑Test Handbuch"},"478":{"id":478,"content":"Pro Handbuch","hash":"home-link","h0":"Voraussetzungen und bekannte Einschränkungen | QF‑Test Handbuch"},"479":{"id":479,"content":"Voraussetzungen und bekannte Einschränkungen","hash":"sec_ios_restrict_precond","h0":"Voraussetzungen und bekannte Einschränkungen"},"480":{"id":480,"content":"Voraussetzungen Für iOS-Tests mit QF‑Test müssen folgende Voraussetzungen für den Testrechner erfüllt sein: iOS-Anwendungen können nur auf einem macOS-System getestet werden. Auf diesem muss QF‑Test installiert sein und der Testlauf dort gestartet werden (interaktiv, im Batch-Modus oder über Daemon-Aufrufe). Zum Ausführen der Tests auf dem iOS Simulator oder einem iOS-Gerät muss die Entwicklungsumgebung Xcode mindestens in Version 13 vollständig installiert sein. Um Probleme beim Update zu vermeiden ist es empfohlen, die automatischen Updates in den App Store-Einstellungen zu deaktivieren und Xcode manuell zu aktualisieren, wenn kein Test gestartet ist. In Xcode muss die iOS-Entwicklungs-Plattform aktiviert und die passenden iOS-Simulatoren/Runtimes installiert werden. Dies ist im Dialog \"Settings\" bzw. \"Preferences\" im Tab \"Platforms\" bzw. \"Components\" möglich. Nach einem Update von Xcode muss dieser Prozess wiederholt werden. Der korrekte Entwicklungs-Pfad /Applications/Xcode.app/Contents/Developer muss über das Terminal ausgewählt werden: sudo xcode-select -s /Applications/Xcode.app/Contents/Developer. Zur Steuerung des iOS Gerätes bzw. des iOS Simulators wird die iOS Development Bridge benötigt. Hinweise zu deren Installation finden Sie unter https://fbidb.io/docs/installation. Im Menü \"Extras\" des QF‑Test Hauptfensters finden Sie den Eintrag \"iOS-Testumgebung prüfen/einrichten ...\", mit welchem Sie die Voraussetzungen auf Ihrem System überprüfen können sowie Hilfestellung für die Installation der benötigten Hilfsprogramme erhalten. Wenn die Hilfsprogramme zum ersten Mal aufgerufen werden, dann kann es vorkommen, dass diese mehr als 30 Sekunden zur Initialisierung benötigen. In diesem Fall wird aufgrund von Timeouts die Version nicht korrekt ausgelesen. Sie können in diesem Fall die Überprüfung nach einer kurzen Wartezeit erneut starten.","hash":"sec_ios_precond","h1":"Voraussetzungen"},"481":{"id":481,"content":"Bekannte Einschränkungen Aktionen, die direkt auf einem angeschlossenen Gerät oder im Simulator ausgeführt werden, können nicht aufgezeichnet werden. Diese müssen auf einem dedizierten Aufnahmefenster, siehe Aufnamen und Checks bei iOS ausgeführt werden, analog zu Android. Ab iOS-Version 13 wird bei der Verwendung von SecureField-Komponenten (für die Eingabe von Passwörtern und anderen sensiblen Informationen) die Software-Tastatur im Aufnahmefenster nicht mehr angezeigt, und die Textkomponente selbst wird als leer dargestellt, auch wenn sie eine Eingabe enthält. Eingaben können aber grundsätzlich auch über Tastatureingaben aufgenommen werden, ohne dass man dafür die entsprechenden Tasten auf der Software-Tastatur anklicken muss. Die Komponenteninformationen für die Software-Tastatur sind jedoch verfügbar und können in den Tests für das Abspielen von Mausevents auf die Tastatur-Komponenten verwendet werden. Hierfür kann man die Komponentenaufnahme (siehe Komponenten aufnehmen) für das gesamte Fenster verwenden um die Tastatur-Komponenten aufzunehmen oder man kann direkt mit SmartID arbeiten. Einen passenden SmartID-Vorschlag erhält man mithilfe des UI-Inspektor.","hash":"sec_ios_restrict","h1":"Bekannte Einschränkungen"},"482":{"id":482,"content":"Pro Handbuch","hash":"","h0":"Xcode, Simulatoren und IDB installieren | QF‑Test Handbuch"},"483":{"id":483,"content":"Pro Handbuch","hash":"home-link","h0":"Xcode, Simulatoren und IDB installieren | QF‑Test Handbuch"},"484":{"id":484,"content":"Xcode, Simulatoren und IDB installieren Für iOS-Tests muss die Entwicklungsumgebung Xcode vollständig installiert sein ebenso wie die iOS Development Bridge (idb). Im Menü \"Extras\" des QF‑Test Hauptfensters finden Sie den Befehl \"iOS-Testumgebung prüfen/einrichten ...\". Damit können Sie das aktuelle System überprüfen. Außerdem erhalten Sie Empfehlungen für die Installation der benötigten Tools. Wenn ein Tool das erste Mal gestartet wird, kann es vorkommen, dass die Initialisierung mehr als 30 Sekunden dauert. In diesem Fall wird die Wartezeit überschritten und es wird eine falsche Versionsnummer angegeben. Starten Sie in diesem Fall die Prozedur zum Prüfen/Einrichten erneut.","hash":"sec_ios_install","h0":"Xcode, Simulatoren und IDB installieren"},"485":{"id":485,"content":"Xcode installieren Installieren Sie Xcode Version 13 oder höher vom App Store.","hash":"ios_xcode_install","h1":"Xcode installieren"},"486":{"id":486,"content":"Installieren Sie Xcode Version 13 oder höher vom App Store. Abbildung 17.1: Xcode im macOS App Store Wenn Xcode aktualisiert wird, während ein Test läuft, kann die Installation beschädigt werden. Daher wird empfohlen, die automatische Aktualisierung von Applikationen im App Store oder den Systemeinstellungen zu deaktivieren und Xcode manuell zu aktualisieren, wenn kein Test läuft.","hash":"fig_ios_xcode_appstore","h1":"Xcode installieren"},"487":{"id":487,"content":"Abbildung 17.2: Empfohlene App Store Einstellungen Stellen Sie den korrekten Entwicklungs-Pfad /Applications/Xcode.app/Contents/Developer via Terminal ein: sudo xcode-select -s /Applications/Xcode.app/Contents/Developer Beispiel 17.1: Einstellung des Xcode Entwicklungs-Pfad im Terminal Öffnen Sie nach der Installation Xcode und stoßen Sie die Installation weiterer benötiger Software gemäß Aufforderung an. Dies muss mindestens eine iOS-Plattform umfassen. Wenn Sie diesen Dialog beim ersten Start übergehen, können Sie Installation über den Dialog »XCode«-»Settings…« im Bereich »Platforms« erneut anstoßen. Über das Menü, das mit Rechtsklick geöffnet wird, ist es auch möglich, installierte Frameworks wieder zu entfernen.","hash":"fig_ios_appstore_settings","h4":"Abbildung 17.2: Empfohlene App Store Einstellungen"},"488":{"id":488,"content":"Abbildung 17.3: Plattform Verwaltung in Xcode Starten Sie den iOS-Simulator einmal über den Menüeintrag »XCode«-»Open Developer Tool«-»Simulator« um so sicherzugehen, dass die richtigen Simulator-Einstellungen erstellt wurden. Hier ist es auch möglich, weitere Geräte festzulegen.","hash":"fig_ios_xcode_settings","h4":"Abbildung 17.3: Plattform Verwaltung in Xcode"},"489":{"id":489,"content":"Abbildung 17.4: Das iOS Simulator Menü","hash":"fig_ios_simulator_menu","h4":"Abbildung 17.4: Das iOS Simulator Menü"},"490":{"id":490,"content":"iOS Development Bridge (idb) installieren Um mit dem iOS-Gerät zu interagieren, verwendet QF‑Test die iOS Development Bridge (idb). Sie besteht aus dem idb companion, der direkt mit dem (simulierten) Gerät kommuniziert, und dem Python-basierten idb Client. Beide müssen auf dem System vorhanden sein, um iOS-Tests ausführen zu können. Weitere Informationen über die idb finden Sie in der idb Dokumentation. Die Installation des idb companion kann über das Kommandozeilenprogramm Homebrew durchgeführt werden (siehe https://brew.sh). Zur Installation des idb companion, führen Sie auf Kommadozeile Folgendes aus: brew tap facebook/fb brew install idb-companion Beispiel 17.2: idb companion Installation über die Kommandozeile Der idb client benötigt eine Installation von Python 3.6 oder höher auf dem System. Dies kann ebenfalls über Homebrew auf Kommadozeile erfolgen. Anschließend wird der idb client mittels pip Tool von Python installiert: brew install python3 pip3 install --upgrade pip pip3 install fb-idb Beispiel 17.3: idb client Installation über die Kommandozeile","hash":"ios_idb_install","h1":"iOS Development Bridge (idb) installieren"},"491":{"id":491,"content":"Pro Handbuch","hash":"","h0":"Auf einem echten iOS-Gerät testen | QF‑Test Handbuch"},"492":{"id":492,"content":"Pro Handbuch","hash":"home-link","h0":"Auf einem echten iOS-Gerät testen | QF‑Test Handbuch"},"493":{"id":493,"content":"Auf einem echten iOS-Gerät testen Apps auf dem iOS Simulator zu testen geht schnell und einfach, aber manchmal ist es notwendig, einen Test auf einem echten iOS-Gerät, das an das Testsystem angeschlossen ist, laufen zu lassen. Um iOS-Tests auf einem echten iOS-Gerät ausführen zu können, müssen einige Voraussetzungen erfüllt sein: Das System muss wie in \"Xcode, Simulatoren und IDB installieren\" beschrieben vorbereitet werden, einschließlich einer vollständigen Installation von Xcode. Auf dem Gerät muss unter »Xcode«-»Einstellungen«-»Datenschutz & Sicherheit« der Entwicklermodus aktiviert werden. Das Gerät muss an den Rechner angeschlossen sein, wobei auf dem Gerät bestätigt werden muss, dass man dem Rechner \"vertraut\". Das Gerät muss während des Testens entsperrt sein. Ein Entwickler-Account muss in »Xcode«-»Settings…«-»Accounts« unter Verwendung seiner Apple ID hinzugefügt werden. Die zum ausgewählten Entwickler-Account gehörige Team ID muss über die Option Code Signing Team ID / Organisationseinheit bereitgestellt werden. Manchmal schlägt der erste Test fehl, weil das Profil auf dem Gerät nicht als vertrauenswürdig eingestellt ist. Um das zu ändern, öffnen Sie die Einstellungen und navigieren Sie auf dem Gerät zu »Allgemein«-»VPN und Geräteverwaltung« oder »Profile« und bestätigen Sie dort die Vertrauenswürdigkeit.","hash":"sec_ios_real_device","h0":"Auf einem echten iOS-Gerät testen"},"494":{"id":494,"content":"Das System muss wie in \"Xcode, Simulatoren und IDB installieren\" beschrieben vorbereitet werden, einschließlich einer vollständigen Installation von Xcode. Auf dem Gerät muss unter »Xcode«-»Einstellungen«-»Datenschutz & Sicherheit« der Entwicklermodus aktiviert werden. Das Gerät muss an den Rechner angeschlossen sein, wobei auf dem Gerät bestätigt werden muss, dass man dem Rechner \"vertraut\". Das Gerät muss während des Testens entsperrt sein. Ein Entwickler-Account muss in »Xcode«-»Settings…«-»Accounts« unter Verwendung seiner Apple ID hinzugefügt werden. Die zum ausgewählten Entwickler-Account gehörige Team ID muss über die Option Code Signing Team ID / Organisationseinheit bereitgestellt werden. Manchmal schlägt der erste Test fehl, weil das Profil auf dem Gerät nicht als vertrauenswürdig eingestellt ist. Um das zu ändern, öffnen Sie die Einstellungen und navigieren Sie auf dem Gerät zu »Allgemein«-»VPN und Geräteverwaltung« oder »Profile« und bestätigen Sie dort die Vertrauenswürdigkeit. Abbildung 17.5: Navigation zum Abschnitt für Vertrauenswürdigkeit im iOS-Profil Applikationen, die auf dem Gerät während eines Tests installiert werden, müssen für \"Any iOS device\" (nicht zu verwechseln mit \"Any iOS Simulator\") gebaut und korrekt signiert werden. Des Weiteren muss ein Provisioning Profile, das die Ausführung erlaubt, auf dem Gerät installiert sein (siehe Apple Dokumentation).","hash":"fig_ios_trust_profile","h0":"Auf einem echten iOS-Gerät testen"},"495":{"id":495,"content":"Pro Handbuch","hash":"","h0":"QF‑Test Vorbereitung Sequenz für iOS Tests | QF‑Test Handbuch"},"496":{"id":496,"content":"Pro Handbuch","hash":"home-link","h0":"QF‑Test Vorbereitung Sequenz für iOS Tests | QF‑Test Handbuch"},"497":{"id":497,"content":"QF‑Test Vorbereitung Sequenz für iOS Tests Öffnen Sie den Schnellstart-Assistenten über das Menü »Extras« oder den Toolbar Button . Wählen Sie \"Eine iOS-Application\".","hash":"sec_ios_test_setup","h0":"QF‑Test Vorbereitung Sequenz für iOS Tests"},"498":{"id":498,"content":"Wählen Sie \"Eine iOS-Application\". Abbildung 17.6: Dialog des Schnellstart-Assistenten zur Auswahl des Anwendungstyps Wählen Sie das echte oder simulierte Gerät aus der Auswahlliste. Falls keine Geräte angezeigt werden, drücken Sie \"Aktualisieren\". Wenn immer noch nichts angezeigt wird, öffnen Sie Xcode und wählen Sie »Window«-»Devices and Simulators« um dort sicherzugehen, dass die Einstellungen stimmen. Es ist ausreichend, den ersten Teil des Gerätenamens anzugeben, um Tests flexibler zu halten. Drücken Sie \"Weiter\" um zum nächsten Schritt weiterzugehen.","hash":"fig_ios_quickstart_type","h0":"QF‑Test Vorbereitung Sequenz für iOS Tests"},"499":{"id":499,"content":"Wählen Sie das echte oder simulierte Gerät aus der Auswahlliste. Falls keine Geräte angezeigt werden, drücken Sie \"Aktualisieren\". Wenn immer noch nichts angezeigt wird, öffnen Sie Xcode und wählen Sie »Window«-»Devices and Simulators« um dort sicherzugehen, dass die Einstellungen stimmen. Es ist ausreichend, den ersten Teil des Gerätenamens anzugeben, um Tests flexibler zu halten. Drücken Sie \"Weiter\" um zum nächsten Schritt weiterzugehen. Abbildung 17.7: Dialog des Schnellstart-Assistenten zur Auswahl des Testgeräts Als nächsten Schritt können Sie das zu testende iOS-Bundle oder die zu testende .ipa-Datei angeben. Sie können auch direkt eine .zip-Datei, die das App-Bundle enthält, referenzieren. Falls Sie eine App testen wollen, die bereits installiert ist, lassen Sie das Feld leer.","hash":"fig_ios_quickstart_device","h0":"QF‑Test Vorbereitung Sequenz für iOS Tests"},"500":{"id":500,"content":"Als nächsten Schritt können Sie das zu testende iOS-Bundle oder die zu testende .ipa-Datei angeben. Sie können auch direkt eine .zip-Datei, die das App-Bundle enthält, referenzieren. Falls Sie eine App testen wollen, die bereits installiert ist, lassen Sie das Feld leer. Abbildung 17.8: Dialog des Schnellstart-Assistenten zur Auswahl der App Im nächsten Schritt können Sie den vorgeschlagenen Client-Namen übernehmen oder überschreiben. Drücken Sie \"Weiter\" beziehungsweise \"Fertig\" um den Schnellstart-Assistenten abzuschließen.","hash":"fig_ios_quickstart_app","h0":"QF‑Test Vorbereitung Sequenz für iOS Tests"},"501":{"id":501,"content":"Im nächsten Schritt können Sie den vorgeschlagenen Client-Namen übernehmen oder überschreiben. Drücken Sie \"Weiter\" beziehungsweise \"Fertig\" um den Schnellstart-Assistenten abzuschließen. Abbildung 17.9: Dialog des Schnellstart-Assistenten für den Client-Namen Als Ergebnis wird die Sequenz Vorbereitung im \"Extras\" Knoten der Testsuite erzeugt. Diese Vorbereitung-Sequenz beinhaltet einen Aufruf der Prozedur qfs.ios.setup.checkEnvironment aus der Standardbibliothek, die prüft, ob das Testsystem ordnungsgemäß eingerichtet ist.","hash":"fig_ios_quickstart_client","h0":"QF‑Test Vorbereitung Sequenz für iOS Tests"},"502":{"id":502,"content":"Als Ergebnis wird die Sequenz Vorbereitung im \"Extras\" Knoten der Testsuite erzeugt. Diese Vorbereitung-Sequenz beinhaltet einen Aufruf der Prozedur qfs.ios.setup.checkEnvironment aus der Standardbibliothek, die prüft, ob das Testsystem ordnungsgemäß eingerichtet ist. Abbildung 17.10: Vom Schnellstart-Assistenten erstellte iOS-Vorbereitungssequenz","hash":"fig_ios_quickstart_setup_sequence","h0":"QF‑Test Vorbereitung Sequenz für iOS Tests"},"503":{"id":503,"content":"Pro Handbuch","hash":"","h0":"Aufnamen und Checks bei iOS | QF‑Test Handbuch"},"504":{"id":504,"content":"Pro Handbuch","hash":"home-link","h0":"Aufnamen und Checks bei iOS | QF‑Test Handbuch"},"505":{"id":505,"content":"Aufnamen und Checks bei iOS Um eine Aufnahme zu starten, drücken Sie in QF‑Test die Schaltfläche . Es wird ein eigenes Aufnahmefenster geöffnet, welches die Oberfläche entweder des Simulators oder des echten Geräts anzeigt. Dieses spezielle Fenster ist notwendig, da es aktuell nicht möglich ist, Aktionen direkt im Simulator oder im echten Gerät aufzuzeichnen. Die Oberfläche des (simulierten) Geräts wird laufend in das Aufnahmefenster gespiegelt. Über Buttons können Sie die Größe des angezeigten Bereichs verändern.","hash":"sec_ios_recording","h0":"Aufnamen und Checks bei iOS"},"506":{"id":506,"content":"Die Oberfläche des (simulierten) Geräts wird laufend in das Aufnahmefenster gespiegelt. Über Buttons können Sie die Größe des angezeigten Bereichs verändern. Abbildung 17.11: QF‑Test iOS Aufnahmefenster Jetzt können Sie Aktionen oder Checks aufnehmen und abspielen. In der Toolbar des Aufnahmefensters gibt es die Schaltfläche um den UI Inspektor zu öffnen, der alle sichtbaren Komponenten mit Größe und Koordinaten anzeigt, siehe UI-Inspektor.","hash":"fig_ios_recording_window","h0":"Aufnamen und Checks bei iOS"},"507":{"id":507,"content":"Pro Handbuch","hash":"","h0":"iOS Hilfsprozeduren | QF‑Test Handbuch"},"508":{"id":508,"content":"Pro Handbuch","hash":"home-link","h0":"iOS Hilfsprozeduren | QF‑Test Handbuch"},"509":{"id":509,"content":"iOS Hilfsprozeduren Es gibt eine ganze Reihe an verfügbaren Hilfsprozeduren für iOS in der Standardbibliothek. Sie befinden sich im dementsprechend benannten Package \"ios\". Einige sind analog zu den anderen GUI Technologien, es gibt aber einige sehr spezifische für mobiles Testen, z.B. um Wischaktionen oder Gesten durchzuführen, zum Blättern auf dem Bildschirm und um bestimmte Einstellungen für Komponenten vorzunehmen.","hash":"sec_ios_stdlib","h0":"iOS Hilfsprozeduren"},"510":{"id":510,"content":"Abbildung 17.12: iOS Hilfsprozeduren","hash":"fig_ios_stdlib","h4":"Abbildung 17.12: iOS Hilfsprozeduren"},"511":{"id":511,"content":"Pro Handbuch","hash":"","h0":"PDF-Dokumente testen | QF‑Test Handbuch"},"512":{"id":512,"content":"Pro Handbuch","hash":"home-link","h0":"PDF-Dokumente testen | QF‑Test Handbuch"},"513":{"id":513,"content":"PDF-Dokumente testen QF‑Test bietet ab Version 4.2 die Möglichkeit, PDF-Dokumente analog zu GUIs zu testen. D.h. QF‑Test analysiert die Struktur des PDF-Dokuments und erkennt einzelne Komponenten, deren Eigenschaften getestet werden können. QF‑Test kann mittels Aufnahme und Wiedergabe direkt Events sowie diverse Checks aufnehmen und wiedergeben. Video: 'PDF-Dokumente testen mit QF‑Test'","hash":"sec_pdf","h0":"PDF-Dokumente testen"},"514":{"id":514,"content":"PDF-Client Das zu testende PDF-Dokument wird von QF‑Test in einen Viewer geladen, der von QF‑Test als Client-Prozess gestartet wird.","hash":"sec_pdf_client","h1":"PDF-Client"},"515":{"id":515,"content":"PDF-Client starten Mit Hilfe des Schnellstart-Assistenten lässt sich die passende Setup-Sequenz erstellen, wobei als Typ der Anwendung \"PDF-Dokument\" zu wählen ist (vgl. \"Schnellstart Ihrer Anwendung\"). Dies ermöglicht den einfachen Start des Viewers. Als konkreter Startknoten wird hierbei der PDF-Client starten Knoten verwendet.","hash":"sec_pdf_client_start","h2":"PDF-Client starten"},"516":{"id":516,"content":"Das Fenster des PDF-Client Im Fenster des PDF-Client befindet sich links eine Navigationsspalte mit einer Übersucht der Seiten des PDF-Dokuments. Im rechten Fensterbereich wird die aktuell selektierte Seite angezeigt. Der folgende Screenshot zeigt den PDF-Client mit einem geöffneten Demo PDF-Dokument.","hash":"sec_pdf_client_window","h2":"Das Fenster des PDF-Client"},"517":{"id":517,"content":"Abbildung 18.1: PDF-Client Hauptfenster mit geöffnetem PDF-Dokument","hash":"figure_18.1","h4":"Abbildung 18.1: PDF-Client Hauptfenster mit geöffnetem PDF-Dokument"},"518":{"id":518,"content":"PDF Events Um während der Testausführung z.B. ein anderes Dokument zu öffnen oder die Seite des geöffneten PDFs zu ändern, können Auswahl Knoten verwendet werden. Diese Aktionen lassen sich direkt im Aufnahme-Modus aufzeichnen. Im Auswahl Knoten muss als Komponente das \"Window\" des PDFs angegeben werden.","hash":"sec_pdf_events","h1":"PDF Events"},"519":{"id":519,"content":"PDF-Dokument öffnen Es ist möglich, während der Ausführungszeit ein anderes PDF-Dokument zu öffnen. Dazu muss im Detail-Attribut des Auswahl Knotens das open: Event angegeben werden. Hierbei kann nun der Pfad zum PDF-Dokument angegeben werden. Relative Pfade werden relativ zum aktuellen Verzeichnis der Testsuite aufgelöst. open:C:\\Users\\qfs\\meinPDFDokument.pdf Beispiel 18.1: Laden eines PDF-Dokuments Wenn das Dokument nicht gefunden oder geladen werden kann wird eine TestException geworfen.","hash":"usec_pdf_events_open_doc","h2":"PDF-Dokument öffnen"},"520":{"id":520,"content":"Seite wechseln Um auf eine bestimmte Seite zu wechseln, kann im Detail-Attribut des Auswahl Knotens das goto: Event angegeben werden. Hier kann analog zu dem Seitennummer-Attribut, die Seite als Zahl für die Seitennummer bzw. in Anführungszeichen für den Seitentitel angegeben werden. goto:3 bzw. goto:\"Einleitung\" Beispiel 18.2: Öffnen einer bestimmten Seite Sollte die gewünschte Seite nicht zur Verfügung stehen, so wird eine PageNotFoundException geworfen.","hash":"usec_pdf_events_switch_page","h2":"Seite wechseln"},"521":{"id":521,"content":"Checks für PDF-Komponenten Für PDF-Komponenten (vgl. \"PDF Komponententypen\") stehen folgende Checks zur Verfügung, die auch direkt mittels dem Check-Aufnahme-Modus aufgezeichnet werden können:","hash":"sec_pdf_checks","h1":"Checks für PDF-Komponenten"},"522":{"id":522,"content":"Check Text Der Check Text Knoten ist in Check Text beschrieben. Für PDF-Text-Komponenten gibt es bei Text-Komponente zwei Check-Typen: \"default\" und \"Text positioniert\". Zeilenumbrüche sind im PDF-Dokument nicht enthalten, Leerzeichen nicht zwingend. Die Abstände ergeben sich aus den Koordinaten der einzelnen Buchstaben. Der Check-Typ \"default\" prüft den Text wie er im PDF-Dokument abgespeichert ist - ohne Zeilenumbrüche und eventuell ohne Leerzeichen, wenn keine enthalten sind. QF‑Test errechnet aus den Koordinaten der einzelnen Buchstaben wo die Zeilenumbrüche angezeigt werden und wo Abstände, die auf Leerzeichen schließen lassen, vorhanden sind. Der Check-Typ \"Text positioniert\" greift auf diesen aufbereiteten Text zu.","hash":"sec_pdf_text_check","h2":"Check Text"},"523":{"id":523,"content":"Abbildung 18.2: Check Text 'default' Aufnahme","hash":"figure_18.2","h4":"Abbildung 18.2: Check Text 'default' Aufnahme"},"524":{"id":524,"content":"Abbildung 18.3: Check Text 'Text positioniert' Aufnahme Zusätzlich kann der gesamte Text der Seite auf der Main Stage mit den Check-Typen \"Text (gesamte Seite)\", \"Text positioniert (gesamte Seite)\", \"Text als Elemente (gesamte Seite)\" sowie \"Text positioniert als Elemente (gesamte Seite)\" geprüft werden. Dabei werden alle Text-Komponenten der Seite sortiert nach Y/X-Position aufgenommen. Die Check-Typen unterscheiden sich dabei, ob der Text positioniert/aufbereitet wird (siehe oben) oder nicht und ob die einzelnen Text-Komponenten als Check Elemente oder als gemeinsamer Check Text aufgenommen werden.","hash":"figure_18.3","h4":"Abbildung 18.3: Check Text 'Text positioniert' Aufnahme"},"525":{"id":525,"content":"Abbildung 18.4: Check Elemente 'Text als Elemente (gesamte Seite)' Aufnahme","hash":"figure_18.4","h4":"Abbildung 18.4: Check Elemente 'Text als Elemente (gesamte Seite)' Aufnahme"},"526":{"id":526,"content":"Abbildung 18.5: Check Elemente 'Text positioniert als Elemente (gesamte Seite)' Aufnahme","hash":"figure_18.5","h4":"Abbildung 18.5: Check Elemente 'Text positioniert als Elemente (gesamte Seite)' Aufnahme"},"527":{"id":527,"content":"Abbildung 18.6: Check Text 'Text (gesamte Seite)' Aufnahme","hash":"figure_18.6","h4":"Abbildung 18.6: Check Text 'Text (gesamte Seite)' Aufnahme"},"528":{"id":528,"content":"Abbildung 18.7: Check Text 'Text positioniert (gesamte Seite)' Aufnahme","hash":"figure_18.7","h4":"Abbildung 18.7: Check Text 'Text positioniert (gesamte Seite)' Aufnahme"},"529":{"id":529,"content":"Check Abbild Der Check Abbild Knoten ist in Check Abbild beschrieben. Für alle Komponenten Typen gibt es den Check-Typ \"default\". Der Check-Typ \"default\" prüft das Objekt, wie es auf der PDF-Seite angezeigt wird, ggf. skaliert und mit überdeckenden Objekten oder Objektteilen. Das aufgenommene Bild entspricht also der tatsächlichen Darstellung.","hash":"sec_pdf_image_check","h2":"Check Abbild"},"530":{"id":530,"content":"Abbildung 18.8: Check Abbild 'default' Aufnahme eines Text Objekts","hash":"figure_18.8","h4":"Abbildung 18.8: Check Abbild 'default' Aufnahme eines Text Objekts"},"531":{"id":531,"content":"Abbildung 18.9: Check Abbild 'default' Aufnahme eines Image Objekts In PDF-Dokumenten können auch echte Bilder eingebettet werden. Dieses Image kann für die Anzeige auf der PDF-Seite skaliert werden. Für echte Bilder werden noch weitere Check-Typen angeboten: Der Check-Typ \"unskaliert\" prüft das in der Datei originale eingebettete unskalierte Bild.","hash":"figure_18.9","h4":"Abbildung 18.9: Check Abbild 'default' Aufnahme eines Image Objekts"},"532":{"id":532,"content":"Abbildung 18.10: Check Abbild 'unskaliert' Aufnahme eines Image Objekts Der Check-Typ \"skaliert\" prüft das auf der PDF-Seite angezeigte, ggf. skalierte Bild ohne überdeckende Objekte. Somit können auch teilverdeckte Abschnitte dieser Bilder geprüft werden.","hash":"figure_18.10","h4":"Abbildung 18.10: Check Abbild 'unskaliert' Aufnahme eines Image Objekts"},"533":{"id":533,"content":"Abbildung 18.11: Check Abbild 'skaliert' Aufnahme eines Image Objekts","hash":"figure_18.11","h4":"Abbildung 18.11: Check Abbild 'skaliert' Aufnahme eines Image Objekts"},"534":{"id":534,"content":"'Check Font' Der Check Text Knoten mit dem Check-Typ \"text_font\" erlaubt das Überprüfen des Fonts. Innerhalb einer PDF-Text-Komponente können verschiedene Fonts verwendet werden. 'Check Font' gibt für eine Text-Komponente den Font zurück, der mehrheitlich verwendet wird.","hash":"sec_pdf_font_check","h2":"'Check Font'"},"535":{"id":535,"content":"'Check Font-Größe' Der Check Text Knoten mit dem Check-Typ \"text_fontsize\" erlaubt das Überprüfen der Fontgröße. Innerhalb einer PDF-Text-Komponente können verschiedene Fontgrößen verwendet werden. 'Check Font-Größe' gibt für ein Textobjekt die Fontgröße zurück, der mehrheitlich verwendet wird.","hash":"sec_pdf_fontsize_check","h2":"'Check Font-Größe'"},"536":{"id":536,"content":"PDF Komponententypen QF‑Test erkennt folgende Objekttypen:","hash":"sec_pdf_comp_types","h1":"PDF Komponententypen"},"537":{"id":537,"content":"PDF Objekttyp QF‑Test Komponententyp Bemerkung Text Text oder Label Ansammlung von Buchstaben, denen Font und Fontsize zugeordnet sind. Image Graphics Ansammlung von Pixeln. Kann auch Buchstabenform haben. Shader und Vektoren Graphics Ansammlung von Vektoren, die entweder geometrische Figuren oder auch Buchstabenformen darstellen. Main stage MainPanel Die zugrunde liegende Seite, auf der alle Objekte dargestellt werden. Tabelle 18.1: Unterstützte PDF-Objekte QF‑Test kann die erkannten PDF-Objekte farbig umranden, wenn diese Funktion im Menü View -> Show components oder das Tastenkürzel STRG-T aktiviert wird. Bei der Aufnahme und Wiedergabe muss diese Funktion deaktiviert sein, da die Rahmen ansonsten bei Abbild-Vergleichen mit aufgenommen werden. Für die einzelnen Objekttypen gilt folgender Farbcode:","hash":"table_18.1","h1":"PDF Komponententypen"},"538":{"id":538,"content":"Farbe PDF Objekttyp Rot Text Blau Image Grün Shader und Vektoren Türkis Main stage Tabelle 18.2: Farbcode der PDF-Objekte","hash":"table_18.2","h1":"PDF Komponententypen"},"539":{"id":539,"content":"PDF Komponentenerkennung QF‑Test stellt die PDF-Objekte als Swing-Komponenten dar, auf die über die Swing-API z.B. aus SUT-Skripten heraus zugegriffen werden kann (vgl. \"Skripting\") Die Basisinformationen für die Identifizierung der PDF-Objekte auf der Seite sind, wie bei allen QF‑Test Komponenten, ihre Klasse, Geometrie und Strukturinformationen (Index). Für Textkomponenten stehen außerdem über Weitere Merkmale der mehrheitlich zugeordnete Font und die mehrheitlich verwendete Fontgröße zur Verfügung. Für Image-Objekte wird in Weitere Merkmale der Image hash und für Shader-Objekte der Shader-Typ mit aufgenommen. Des weiteren versucht QF‑Test bei einem Textobjekt anhand seiner Merkmale zu erkennen, ob es sich um eine Überschrift oder Beschriftung handelt. In diesem Fall erhält das Textobjekt die QF‑Test Klasse \"Label\". Über den QF‑Test Standardalgorithmus für qfs:label*-Varianten in Weitere Merkmale kann dieses Label anderen QF‑Test Komponenten zugeordnet werden. Da der Standardalgorithmus zur Erkennung von Überschriften und Beschriftungen mit Annahmen und Wahrscheinlichkeiten arbeiten muss, kann es auch zu Fehltreffern (false positive) oder Nichterkennung kommen. In diesem Fall können Resolver (\"Das resolvers-Modul\") zur Verbesserung der Erkennung eingesetzt werden. Auch die Zuordnung der Label-Komponente zu anderen Komponenten kann über Resolver gesteuert werden.","hash":"sec_pdf_comp_recognition","h1":"PDF Komponentenerkennung"},"540":{"id":540,"content":"Pro Handbuch","hash":"","h0":"Barrierefreiheit testen | QF‑Test Handbuch"},"541":{"id":541,"content":"Pro Handbuch","hash":"home-link","h0":"Barrierefreiheit testen | QF‑Test Handbuch"},"542":{"id":542,"content":"Barrierefreiheit testen Video: Barrierefreiheit von Webanwendungen testen mit QF‑Test QF‑Test unterstützt für Web-Anwendungen das Testen von Barrierefreiheit auf Basis der WCAG Richtlinien (https://www.wcag.com oder auch www.barrierefreiheit-dienstekonsolidierung.bund.de). Die Mehrheit dieser Richtlinien kann automatisch überprüft werden. Hierfür bietet QF‑Test eigene Tests sowie die Einbettung der umfassenden Accessibility-Bibliothek axe-core an. Hierbei bietet QF‑Test folgende Annehmlichkeiten: Übersichtliche HTML-Report sowie detaillierte QF‑Test Protokolle Protokollierung fehlerhafter Elemente mit umfangreichen Informationen und Vorschlägen zur Fehlerbehebung Erstellung von Bildschirmabbildern mit Hervorhebung fehlerhafter Elemente zur einfachen Identifizierung Vor Version 10 war der Zugriff auf die bereitgestellten Barrierefreiheitstests nur per Aufruf von Prozeduren aus der Standardbibliothek, wie etwa der Prozedur checkAxeRules verfügbar. Inzwischen können diese Tests über den Prüfung der Barrierefreiheit-Knoten mit einer YAML-Syntax definiert werden. Zudem lassen sich dort Einstellungen zur Protokollierung der Ergebnisse vornehmen. Der Ausdruck a11y, der in den Namen der Prozeduren verwendet wird, ist eine gemeinhin benutzte Abkürzung für den Begriff Barrierefreiheit (engl. \"Accessibility\", \"A\" + 11 Buchstaben + \"y\").","hash":"usec_accessibility","h1":"Barrierefreiheit testen"},"543":{"id":543,"content":"Pro Handbuch","hash":"","h0":"Einstieg | QF‑Test Handbuch"},"544":{"id":544,"content":"Pro Handbuch","hash":"home-link","h0":"Einstieg | QF‑Test Handbuch"},"545":{"id":545,"content":"Einstieg Für die Erstellung erster Tests zur Zugänglichkeit der eigenen Webseite empfiehlt sich der Erzeugung der Startsequenz - Schnellstart-Assistent. Über \"Eine Web-Anwendung inklusive Prüfung der Barrierefreiheit\" kann ein erster Barrierefreiheitstest in wenigen Schritten erzeugt werden. Zuerst wird die URL der zu testenden Webseite definiert. Der Schnellstartassistent erstellt einen Test, der die Zugänglichkeit einer bestimmten Seite prüft. Über Funktionen, wie etwa Datentreiber lassen sich die Tests einfach über mehrere unterschiedliche Seiten ausführen. Im Schritt \"Barrierefreiheit - Modulauswahl\" können die auszuführenden Tests eingestellt werden. Eine genauere Beschreibung der Barrierefreiheitsüberprüfungen und ihrer Einstellungsmöglichkeiten finden Sie in den jeweiligen Unterkapiteln in den folgenden Abschnitten. Unter dem Abschnitt \"Optional\" finden sich Konfigurationsmöglichkeiten bezüglich des verwendeten Browsers, Web-Frameworks und weitere Optionen, die im Kapitel Webseiten testen ausführlich beschrieben sind. Mit einem Klick auf \"Fertig\" werden die eingegebenen Daten bestätigt und der Accessibility-Test erstellt.","hash":"sec_a11y_intro","h0":"Einstieg"},"546":{"id":546,"content":"Abbildung 19.1: Ergebnis Quickstart Wizard Der erzeugte Testfallsatz besteht aus zwei Komponenten: Die Vorbereitung startet (wenn nötig) den vorher angegebenen Browser, navigiert zur definierten Webseite und kümmert sich um eine grundlegende Komponentenerkennung. Der Umgang mit Webkomponenten wird im Kapitel CustomWebResolver installieren-Knoten – Syntax beschrieben und kann an die eigenen Bedürfnisse angepasst werden. Der erzeugte Testfall beinhaltet einen Prüfung der Barrierefreiheit-Knoten, der bei Ausführung die angegebenen Barrierefreiheitstests durchführt - entsprechend der Konfiguration durch den Schnellstart-Assistenten. Genaue Informationen zu den einstellbaren Parametern finden sich im Kapitel Konfiguration des \"Prüfung der Barrierefreiheit\"-Knotens. Die unterschiedlichen Barrierefreiheitstests sind in den folgenden Abschnitten beschrieben.","hash":"figure_19.1","h4":"Abbildung 19.1: Ergebnis Quickstart Wizard"},"547":{"id":547,"content":"Pro Handbuch","hash":"","h0":"Überblick über alle Barrierefreiheitstests | QF‑Test Handbuch"},"548":{"id":548,"content":"Pro Handbuch","hash":"home-link","h0":"Überblick über alle Barrierefreiheitstests | QF‑Test Handbuch"},"549":{"id":549,"content":"Überblick über alle Barrierefreiheitstests Im folgenden werden alle in QF‑Test enthaltenen Barrierefreiheitstests kurz vorgestellt. Eine detaillierte Übersicht über die einzelnen Checks sowie deren einstellbare Parameter findet sich im Kapitel Konfiguration des \"Prüfung der Barrierefreiheit\"-Knotens.","hash":"sec_a11y_all_tests","h0":"Überblick über alle Barrierefreiheitstests"},"550":{"id":550,"content":"Axe-Checks mit QF‑Test Fehler beim Überprüfen einer Website mit axe finden sich im Protokoll unter folgendem Fehlercode: QF‑Test Fehlercode: ERR_AXE-CORE_CHECKS Die Bibliothek axe-core stellt Methoden bereit, um Webseiten auf Konformität mit Barrierefreiheitsstandards, wie etwa den bereits erwähnten WCAG-Richtlinien, zu testen. Aus QF‑Test heraus kann die gesamte Funktionalität von axe-core genutzt werden - ohne zusätzlichen Programmieraufwand. QF‑Test erweitert axe um die Funktion, Elemente in geschlossenen Shadow-Roots auf Barrierefreiheit zu überprüfen. Dies ist allerdings nur bei Verwendung des CDP-Driver Verbindungsmodus möglich. Bei Benutzung der axe-Bibliothek werden von axe bereitgestellte Barrierefreiheitstests (axe-Regeln) ausgeführt. Eine Liste aller möglichen Barrierefreiheitstests, sowie einen Verweis auf die dadurch überprüften Richtlinien finden sie hier: https://dequeuniversity.com/rules/axe/html/. Bei der Ausführung des Schnellstart-Assistenten können die auszuführenden Regeln oder Regelgruppen definiert werden. Eine genauere Beschreibung dazu findet sich im Kapitel Rules to Check – axe. Bei der Verwendung des Schnellstart-Assistenten werden mehrere Beispiele aufgeführt. Der eingestellte Standardwert ist \"WCAG 2.x Level A und AA\" - eine Überprüfung aller WCAG-Richtlinien ab Version 2.0 des Levels A oder AA.","hash":"sec_axe","h1":"Axe-Checks mit QF‑Test"},"551":{"id":551,"content":"Farbkontrast-Check für einfache Grafikobjekte Fehler beim Überprüfen von Grafikelementen einer Website finden sich im Protokoll unter folgendem Fehlercode: QF‑Test Fehlercode: ERR_COLOR_CONTRAST_SIMPLE_GRAPHICS Die WCAG schreibt für Bilder von großem Text, Komponenten der Benutzeroberfläche und informationstragende Grafiken einen Mindestfarbkontrast von 3:1 vor. (§§1.4.3, 1.4.11 WCAG 2.2) Der Farbkontrast-Check prüft den Farbkontrast einfacher Grafikelemente (wie etwa Icons) gegen die automatisch ermittelte Hintergrundfarbe, wobei versucht wird eventuelle Umrandungen (Borders) des Elementes auszuschließen. Der Farbkontrast-Check überprüft alle Elemente der im Schnellstart-Assistenten (oder direkt im \"genericClasses\"-Parameter der YAML-Notation des Prüfung der Barrierefreiheit-Knotens) angegebenen Generische Klassen. Die generische Klasse eines Elementes kann einfach durch das Untersuchen des Elementes mit dem \"UI-Inspektor\" herausgefunden werden. Eine Anpassung der Komponentenerkennung bei Web-Tests oder die Erzeugung eigener generischer Klassen ist über den Der CustomWebResolver installieren Knoten möglich.","hash":"sec_color_contrast","h1":"Farbkontrast-Check für einfache Grafikobjekte"},"552":{"id":552,"content":"Überprüfung der Sichtbarkeit des Fokus Fehler beim Überprüfen von Grafikelementen einer Website finden sich im Protokoll unter folgendem Fehlercode: QF‑Test Fehlercode: ERR_FOCUS_VISIBLE Die WCAG fordert, dass Elemente einer per Tastatur bedienbaren grafischen Benutzeroberfläche einen sichtbaren Fokus haben müssen. (§2.4.7 WCAG 2.2) Mit dem \"Sichtbarkeit des Fokus\"-Check wird über alle fokussierbaren Elemente einer Webseite per Tabulator iteriert und dabei jeweils die Sichtbarkeit des Fokus überprüft.","hash":"sec_focus_visible","h1":"Überprüfung der Sichtbarkeit des Fokus"},"553":{"id":553,"content":"Überprüfung des Sprachattributes Fehler beim Überprüfen des lang Attributes einer Website finden sich im Protokoll unter folgendem Fehlercode: QF‑Test Fehlercode: ERR_LANGUAGE_LANG_VALUE Für Nutzer von assistiven Technologien ist es wichtig, Informationen auf Webseiten in der korrekten Sprache zu erhalten. Damit die Sprache erkannt werden kann, muss das lang Attribut im HTML korrekt gesetzt sein (§§3.1.1, 3.1.2 WCAG 2.2) Mit dem \"Überprüfung des Sprachattributes\"-Check werden alle <HTML>-Tags und Elemente mit gesetztem lang-Attribut gegen einen benutzerdefinierten Sprachwert (wie etwa \"de\" oder \"en\") auf Gleichheit überprüft. Zudem wird sichergestellt, dass das Attribut in <HTML>-Tags gesetzt wird. Hierbei überprüft QF‑Test auch Elemente aus eingebetteten HTML-Dokumenten (<iframe>, \"inline frame\").","hash":"sec_lang_value","h1":"Überprüfung des Sprachattributes"},"554":{"id":554,"content":"Die \"impact\"-Bewertung der Barrierefreiheitstests Die Entwickler von axe-core vergaben jeder einzelnen Regel einen \"impact\". Dieser Wert wird von QF‑Test in den Fehlermeldungen zu den Regeln aufgelistet und quantifiziert die Auswirkung eines Problems auf einen Benutzer mit einer Behinderung. Zudem wurde für die impact-Bewertung auch für QF‑Test eigene Accessibility-Tests vergeben. In aufsteigender Reihenfolge gelistet (nach Schwere der Auswirkung) gibt es folgende Kategorien: Minor: niedrige Priorität Ein lästiger oder ärgerlicher Fehler. Moderate: mittlere Priorität Bereitet Schwierigkeiten für eingeschränkte Nutzer, hindert diese jedoch im Allgemeinen nicht am Zugriff auf grundlegende Funktionalitäten. Serious: hohe Priorität Führt zu schwerwiegenden Barrieren für Menschen mit Behinderung und hindert diese ganz oder teilweise am Zugang zu grundlegenden Funktionen oder Inhalten. Critical: oberste Priorität Das Problem blockiert Menschen mit Behinderung absolut bei der Nutzung der grundlegenden Funktionalitäten der Seite und dem Zugriff auf die Inhalte. Die \"impact\"-Bewertung erlaubt eine Priorisierung bei der Behebung der Probleme. Für ein Einhalten der WCAG-Richtlinien sind allerdings alle Fehler zu beheben - auch die Fehler von niedriger Priorität!","hash":"sec_axe_impact","h1":"Die \"impact\"-Bewertung der Barrierefreiheitstests"},"555":{"id":555,"content":"Pro Handbuch","hash":"","h0":"A11y-Protokolle und -Reports | QF‑Test Handbuch"},"556":{"id":556,"content":"Pro Handbuch","hash":"home-link","h0":"A11y-Protokolle und -Reports | QF‑Test Handbuch"},"557":{"id":557,"content":"A11y-Protokolle und -Reports Für das Arbeiten mit dem Protokoll und die Generierung eines Reports (Reports und Testdokumentation) gibt es bei Barrierefreiheitstests eigene Tipps, Tricks und Besonderheiten.","hash":"sec_a11y_runlog_report","h0":"A11y-Protokolle und -Reports"},"558":{"id":558,"content":"Arbeiten mit dem Protokoll Nach jedem Barrierefreiheitstest wird ein Protokoll angelegt, dass zur Fehleranalyse verwendet werden kann.","hash":"subsec_a11y_run_log","h1":"Arbeiten mit dem Protokoll"},"559":{"id":559,"content":"Abbildung 19.2: Ausschnitt aus dem Protokoll eines axe-Barrierefreiheitstests In der folgenden Abbildung ist die komplette Meldung des ausgewählten Fehlers zu sehen:","hash":"figure_19.2","h4":"Abbildung 19.2: Ausschnitt aus dem Protokoll eines axe-Barrierefreiheitstests"},"560":{"id":560,"content":"Abbildung 19.3: Fehlermeldung zum obig ausgewählten Fehler In Fehlermeldungen werden Elemente gelistet, die bestimmte Accessibility-Kriterien nicht erfüllen. Der zugehörige Fehler und Zusatzinformationen, wie etwa Lösungsvorschläge, werden in der Fehlermeldung beschrieben. Für Elemente, die aufgrund unterschiedlicher Probleme, wie etwa die Verdeckung durch ein anderes Element, nicht auf eine bestimmte Regel überprüft werden konnten, werden Warnungen protokolliert. Je nachdem, auf welchen Wert Erfolgreiche Checks anzeigen gesetzt wurde, werden auch erfolgreich durchgeführte Checks als Information im Protokoll aufgeführt. QF‑Test protokolliert neben Abbildern auch verschiedene Identifikatoren der Elemente, wie etwa den XPath oder bei Bedarf (SmartID des Elements in der Nachricht protokollieren) die SmartID. Die SmartID kann verwendet werden, um das Element innerhalb von QF‑Test anzusprechen. Der XPath kann verwendet werden, um das Element im Browser mittels Entwicklertools zu finden. Zudem erzeugt QF‑Test einen Screenshot der getesteten Seite, auf dem fehlerhafte und übersprungene Elemente hervorgehoben werden.","hash":"figure_19.3","h4":"Abbildung 19.3: Fehlermeldung zum obig ausgewählten Fehler"},"561":{"id":561,"content":"Abbildung 19.4: Bildschirmabbild: Überblick über fehlerhafte Elemente Fehlerhafte Elemente werden rot, übersprungene Elemente gelb umrandet. Um möglichst akkurate Abbilder und Hervorhebungen der Elemente zu erhalten, sollte die Bildschirm- und Browserskalierung auf 100% gesetzt sein.","hash":"figure_19.4","h4":"Abbildung 19.4: Bildschirmabbild: Überblick über fehlerhafte Elemente"},"562":{"id":562,"content":"Hinweise zur Reportgenerierung Bei der Erstellung des Reports ist es sinnvoll, die zu den Fehlern erzeugten Abbilder der Elemente in den Report aufzunehmen. Hierfür muss im interaktiven Modus \"Miniaturbilder einbetten\" ausgewählt werden. Als Skalierung für die Miniaturbilder bietet sich ein fester Wert, wie etwa 300×200 Pixel, an.","hash":"subsec_a11y_report","h1":"Hinweise zur Reportgenerierung"},"563":{"id":563,"content":"Abbildung 19.5: Beispiel zu Einstellungen bei der Reportgenerierung Die Kommandozeilenargumente für den batch-Modus lauten -report-thumbnails und -report-scale-thumbnails <Prozent>.","hash":"figure_19.5","h4":"Abbildung 19.5: Beispiel zu Einstellungen bei der Reportgenerierung"},"564":{"id":564,"content":"Pro Handbuch","hash":"","h0":"Webswing und JPro: Java-Anwendungen im Browser testen | QF‑Test Handbuch"},"565":{"id":565,"content":"Pro Handbuch","hash":"home-link","h0":"Webswing und JPro: Java-Anwendungen im Browser testen | QF‑Test Handbuch"},"566":{"id":566,"content":"Webswing und JPro: Java-Anwendungen im Browser testen Webswing und JPro sind zwei hochinteressante Lösungen, die Swing und JavaFX Desktop-Anwendungen in den Browser bringen. Die zu Grunde liegenden Technologien, Konzepte und Ziele unterscheiden sich deutlich, doch die Herausforderung für QF‑Test ist bei beiden die gleiche: Es gilt zwei SUT-Clients gemeinsam in einer koordinierten Weise anzusteuern. Die Migration von bestehenden Anwendungen ist hier eines der häufigsten Szenarios, so dass die Wiederverwendbarkeit von bestehenden QF‑Test Testsuiten für die Java Desktop-Anwendungen äußerst wichtig ist. Dies ist einer der Gründe dafür, warum Testen alleine über den Browser nicht ausreichend ist. Der andere Grund ist, dass QF‑Test im Browser nur einen CANVAS mit bunten Pixeln sieht (Webswing), bzw. eine Hierarchie von zueinander sehr ähnlichen DIV Knoten. Auch wenn letzteres für Tests zumindest halbwegs brauchbar ist und für spezielle Themen wie Lasttests noch interessant werden kann, ist es im Vergleich zum tief reichenden Durchgriff, den QF‑Test bei Java-Anwendungen hat, doch sehr eingeschränkt. Hier betritt \"JiB\" die Bühne - QF‑Test's Lösung für \"Java im Browser\". Für JiB werden neben Swing und/oder JavaFX Engine-Lizenzen auch QF‑Test Lizenzen für die Web-Engine benötigt. Zum Einstieg gibt es auch ein kurzes Überblicksvideo zum Webswing-Testing auf unserem QF‑Test YouTube-Kanal. Im November 2020 fand ein Spezialwebinar zum Thema Webswing-Testen mit QF‑Test statt. Hier geht es zum Videomitschnitt des Spezialwebinars auf unserem QF‑Test YouTube-Kanal. QF‑Test kommt mit einer Demo-Testsuite für Webswing, die zum besseren Verständnis des folgenden Abschnitts beiträgt. Sie finden diese über den Menüeintrag »Hilfe«-»Beispiel-Testsuiten erkunden...«, Eintrag \"Webswing SwingSet Suite\".","hash":"usec_jib","h0":"Webswing und JPro: Java-Anwendungen im Browser testen"},"567":{"id":567,"content":"Technische Konzepte von JiB für Webswing und JPro Beim JiB Ansatz betrachtet QF‑Test die Swing oder JavaFX-Anwendung als das primäre SUT. Fast die gesamte Interaktion wird über die jeweilige Swing oder JavaFX SUT Engine gesteuert. QF‑Test öffnet zusätzlich ein Browserfenster und nutzt seine Web-Engine, um dieses Frontend anzusteuern, durch das die Anwendung dargestellt wird und über das der Anwender mit ihr interagiert. Es gibt zwei Formen der Interaktion von QF‑Test mit der Anwendung: Java-Modus QF‑Test kann die Event-Steuerung komplett innerhalb der Swing oder JavaFX-Anwendung halten. In diesem Modus dient der Browser nur zum Start der Anwendung, als Referenz für den Anwender und für Sonderfälle, bei denen der Workflow der Anwendung in eine Web-Schnittstelle verlagert wurde, vor allem der Up- und Download von Dateien. Dieser Modus ist sehr ähnlich zum normalen Test einer Swing oder JavaFX-Anwendung. Die Wiedergabe von Events passiert identisch dazu. Die Bilder für Abbild-Checks werden von Swing bzw. JavaFX per Off-Screen-Rendering in einen Speicherbereich gezeichnet, ebenfalls identisch zur Desktop-Version. Web-Modus Was der obige Fall nicht abdeckt, ist die Verifikation, dass die Webswing bzw. JPro Integration tatsächlich wie erwartet Ende-zu-Ende funktioniert, also dass der Anwender die Benutzerschnittstelle wirklich wie gewünscht zu sehen bekommt und mit der Anwendung mittels Maus und Tastatur über den Browser interagieren kann. Auch wenn man diskutieren kann, bis zu welchem Grad man zu Grunde liegenden Technologien einfach vertrauen oder diese selbst mit testen sollte, ist die Möglichkeit, echte Ende-zu-Ende Tests über den Browser durchzuführen für dieses Szenario ein sehr wichtiger Aspekt. QF‑Test kann die Wiedergabe der Events über einige Optionen zum Browser umleiten. Tests werden dabei immer noch über die Java-Anwendung ausgeführt, die Komponentenerkennung funktioniert unverändert und QF‑Test kümmert sich um die Synchronisation und führt alle vorbereitenden Schritte aus, wie das sichtbar Scrollen von Elementen oder das implizite öffnen von Baumknoten. Im letzten Schritt führt die Swing bzw. JavaFX Engine den Event nicht selbst aus, sondern nutzt eine spezielle Verbindung, um die Event-Information an die QF‑Test Web-Engine im Browser weiterzuleiten und dann darauf zu warten, dass der Event dort ausgeführt und über Webswing bzw. JPro zurück an die Java-Anwendung gelangt. Der letzte Baustein für Ende-zu-Ende Tests ist die Verifikation der Darstellung im Browser, wie sie der Anwender zu sehen bekommt. Anstelle des Off-Screen-Renderings kann QF‑Test die Bilderstellung an die Web-Engine delegieren, die ein Bildschirmabbild der entsprechenden Region im Browserfenster aufnimmt. Diese Bilder können in Details von den Java Off-Screen-Varianten abweichen, speziell bei der Textdarstellung und beim Antialiasing. Dies kann mit Hilfe der Algorithmen für Abbild-Checks in QF‑Test kompensiert werden. Näheres hierzu finden Sie in \"Details des Algorithmus zum Bildvergleich\". Tests im Java-Modus sind sehr robust und effizienter. Wir empfehlen, diesen für die Migration bestehender Tests und für den Großteil der funktionalen Tests zu nutzen. Diese sollten durch verschiedene Tests im Web-Modus ergänzt werden, um Ende-zu-Ende-Zuverlässigkeit zu gewährleisten. Als Daumenregel sollten wiederholte Tests für dieselbe Schnittstelle mit verschiedenen Werten und dem Fokus auf Funktionalität primär im Java-Modus durchgeführt werden. Tests für unterschiedliche Komponenten mit dem Fokus auf Interaktion sollten den Web-Modus nutzen. Prozeduren zum Umschalten der verschiedenen Optionen werden im Package qfs.jib in der Standardbibliothek qfs.qft bereitgestellt.","hash":"usec_jib_technical","h1":"Technische Konzepte von JiB für Webswing und JPro"},"568":{"id":568,"content":"Pro Handbuch","hash":"","h0":"Electron-Anwendungen testen | QF‑Test Handbuch"},"569":{"id":569,"content":"Pro Handbuch","hash":"home-link","h0":"Electron-Anwendungen testen | QF‑Test Handbuch"},"570":{"id":570,"content":"Electron-Anwendungen testen Electron ist ein Framework zur Ausführung von Cross-Plattform Desktop-Anwendungen mit Hilfe des Webbrowsers Chromium und des Node.js-Frameworks. Diese Anwendungen können mittels HTML, CSS und JavaScript entwickelt werden und auf native Funktionen des Betriebssystems wie Menüs, Dateien oder die Taskleiste zugreifen. Seit QF‑Test Version 4.5 können Anwendungen, die mit dem Electron Framework entwickelt wurden, getestet werden. Sämtliche Features, die QF‑Test für das Web bietet, können auch hier verwendet werden.","hash":"usec_electron","h0":"Electron-Anwendungen testen"},"571":{"id":571,"content":"Electron Client starten Die Verbindung zur Electron-Anwendung kann wie bei einer Web-Anwendung über den empfohlenen CDP-Driver-Verbindungsmodus (siehe \"CDP-Driver Verbindungsmodus\") oder den WebDriver-Verbindungsmodus (siehe \"WebDriver Verbindungsmodus\") erfolgen. Mit Hilfe des Schnellstart-Assistenten (vgl. \"Schnellstart Ihrer Anwendung\") lässt sich die passende Vorbereitung Sequenz erstellen. Dies ermöglicht den einfachen Start der Anwendung. Die Electron spezifischen Angaben im Schnellstart-Assistenten werden weiter unten in diesem Kapitel erläutert. Die verbleibenden optionalen Einstellungen sind im Schnellstart-Assistenten selbst beschrieben. Das Video zeigt die ' Anbindung der Electron-Anwendung via Schnellstart-Assistenten'.","hash":"sec_electron_setup","h1":"Electron Client starten"},"572":{"id":572,"content":"Electron Einstellungen im Schnellstart-Assistenten Wählen Sie in der Rubrik \"Typ der Anwendung\" des Schnellstart-Assistenten den Punkt Eine Electron-Anwendung. Geben Sie in der Rubrik \"Electron-Anwendung\" Ihre Anwendung inklusive Pfad an, wobei Sie das Dateiauswahlmenü nutzen können, das über den Button rechts des Eingabefelds aktiviert werden kann. Wenn Sie beim Start der Anwendung eigene Kommandozeilenargumente benötigen, so können Sie diese hier ebenfalls angeben. Electron basiert auf Node.js, welches in der JavaScript-Laufzeitumgebung \"V8\" ausgeführt wird. Ab Electron 6 und QF‑Test 5.4.0 wird zum Steuern der Anwendung bevorzugt der CDP-Driver-Verbindungsmodus verwendet. Für ältere Anwendungen muss auf den WebDriver-Verbindungsmodus in Kombination mit dem ChromeDriver zurückgegriffen werden. Dabei wird in den meisten Fällen der passende ChromeDriver automatisch ermittelt und heruntergeladen. Dieser wird dann im Unterverzeichnis chromedriver des QF‑Test Installationsverzeichnisses gespeichert.","hash":"sec_electron_quickstart","h2":"Electron Einstellungen im Schnellstart-Assistenten"},"573":{"id":573,"content":"Electron spezifische Funktionalität in QF‑Test Neben den Features, die QF‑Test für das Web bietet, steht für Electron die nachfolgend beschriebene Funktionalität zur Verfügung.","hash":"sec_electron_specials","h1":"Electron spezifische Funktionalität in QF‑Test"},"574":{"id":574,"content":"Native Menüs Zur Ansteuerung der nativen Menüs der Electron-Anwendung verwenden Sie bitte einen Auswahl Knoten, bei dem Sie im Attribut QF‑Test ID der Komponente die QF‑Test ID des Knotens Webseite des SUT angeben. Im Attribut Detail tragen Sie den Menüpunkt mit der folgenden Syntax ein: clickmenu:@/<Menüpfad>, wobei statt <Menüpfad> das Menü mit dem oder den Untermenüpunkten, getrennt durch /, einzutragen ist. Wenn Sie zum Beispiel im Menü Datei den Unterpunkt Speichern unter aktivieren wollen, lautet der Eintrag clickmenu:@/Datei/Speichern unter.","hash":"sec_electron_native_menus","h2":"Native Menüs"},"575":{"id":575,"content":"Native Dialoge QF‑Test unterstützt die Aufnahme, Prüfung und Ansteuerung von Dialogen, welche mit dem dialog-Modul von Electron aufgerufen werden. Aus technischen Gründen können sich dabei die angezeigten Dialoge optisch von den üblichen Dialogen unterscheiden. Bei der Aufnahme wird ein Komponentenknoten mit der Klasse Dialog erstellt, auf dem mit Hilfe eines Check Text-Knotens der Text des Dialogfensters geprüft werden kann. Zum Interagieren mit dem Dialogfenster wird ein Auswahl Knoten verwendet, wobei die Details vom Typ des Dialogs abhängen: Message Box: Der Wert im Attribut Detail entspricht der Nummer des ausgewählten Buttons, z.B. 2. Enthält die Message Box zusätzlich eine CheckBox, so kann deren Wert mit : getrennt angefügt werden, also z.B. 2:true. Error Box: Bei einer Error Box ist nur ein Knopf vorhanden, der Rückgabewert muss daher 0 lauten. Open File Dialog: Im Attribut Detail muss der Dateiname der auszuwählenden Datei angegeben werden. Ist die Auswahl mehrerer Dateien erlaubt, so kann alternativ als Attribut-Wert ein Json-Array mit Dateinamen angegeben werden, also z.B. [\"datei.txt\",\"C:\\\\TEMP\\\\andere.txt\"]. Möchte man den Dialog abbrechen, gibt man als Attribut-Wert <CANCEL> an. Save File Dialog: Die Attribut-Werte für Save File Dialog entsprechen denen des Open File Dialogs. Eine Mehrfachauswahl wird von Electron beim Save File Dialog nicht unterstützt.","hash":"sec_electron_native_dialogs","h2":"Native Dialoge"},"576":{"id":576,"content":"Erweiterte Javascript-API Bei Electron sind separate Render-Prozesse für die Darstellung des Inhalts der Anwendungs-Fenster verantwortlich. Zusätzlich existiert ein Haupt-Prozess, der auf der Node.js-Engine aufsetzt und die Haupt-Anwendungslogik enthält. Für die Ausführung von eigenem Skript-Code in diesem Prozess bietet QF‑Test mit den Methoden mainCallJS und mainEvalJS eine mächtige Erweiterung der DocumentNode-API (siehe \"Die Klasse DocumentNode\") an.","hash":"sec_extended_api","h2":"Erweiterte Javascript-API"},"577":{"id":577,"content":"Object mainCallJS(String code) Führt den JavaScript-Code im Hauptprozess der Electron-Anwendung in einer Funktion aus. Parameter codeDer auszuführende Code. RückgabewertWas immer der Code mit return explizit zurückliefert, konvertiert in einen passenden Objekttyp. Allgemeine Javascript-Objekte werden in Json-Objekte konvertiert. Die spezielle Variable _qf_window wird dabei durch das BrowserWindow-Objekt ersetzt, welches zur aktuellen DocumentNode gehört.","hash":"api_object_maincalljs_string_code_in_sec_extended_api","h2":"Erweiterte Javascript-API"},"578":{"id":578,"content":"Object mainEvalJS(String script) Evaluiert JavaScript Code im Hauptprozess der Electron-Anwendung. Parameter scriptDas auszuführende Skript. RückgabewertWas immer das Skript zurückliefert, konvertiert in einen passenden Objekttyp. Allgemeine Javascript-Objekte werden in Json-Objekte konvertiert. Die spezielle Variable _qf_window wird dabei durch das BrowserWindow-Objekt ersetzt, welches zur aktuellen DocumentNode gehört. Im Beispiel werden für das aktuell angezeigte Electron-Fenster die \"Chrome Developer Tools\" eingeblendet. rc.getComponent(\"genericDocument\").mainCallJS(\"_qf_window.webContents.openDevTools()\") Beispiel 21.1: SUT-Skript zum Anzeigen der Dev Tools in einem Electron-Fenster","hash":"api_object_mainevaljs_string_script_in_sec_extended_api","h2":"Erweiterte Javascript-API"},"579":{"id":579,"content":"Technische Anmerkungen zum Testen von Electron-Anwendungen im WebDriver-Verbindungsmodus Damit QF‑Test auf die Electron-APIs zugreifen kann, zum Beispiel um Interaktionen mit nativen Menüs aufzunehmen oder abzuspielen, muss QF‑Test bei der Nutzung des WebDriver-Verbindungsmodus die Electron-API über den Render-Prozess der getesteten Anwendung aufgerufen werden. Dazu sollte die nodeIntegration Property des BrowserWindow nicht auf false gesetzt werden. Zusätzlich muss contextIsolation deaktiviert bleiben und enableRemoteModule den Wert true behalten.","hash":"sec_electron_technical","h1":"Technische Anmerkungen zum Testen von Electron-Anwendungen im WebDriver-Verbindungsmodus"},"580":{"id":580,"content":"mainWindow = new BrowserWindow({ webPreferences: { nodeIntegration: true, enableRemoteModule: true, contextIsolation: false, ... }, ... }) Beispiel 21.2: Einfaches Beispiel für eine Electron-Anwendung, die gut getestet werden kann Wenn Sie vermeiden wollen, dass die vollständige Node-Integration im Render-Prozess zugänglich ist, können Sie die API-Integration mit Hilfe eines preload-Skripts verfügbar machen:","hash":"ex_electron_technical_basic","h1":"Technische Anmerkungen zum Testen von Electron-Anwendungen im WebDriver-Verbindungsmodus"},"581":{"id":581,"content":"mainWindow = new BrowserWindow({ webPreferences: { nodeIntegration: false, ... preload: `${__dirname}/preload.js` // absolute pathname required }, ... }) Beispiel 21.3: Die Einstellungen für den eingeschränkten Node Zugriff","hash":"ex_electron_preload","h1":"Technische Anmerkungen zum Testen von Electron-Anwendungen im WebDriver-Verbindungsmodus"},"582":{"id":582,"content":"// Expose require API in test mode: if (process.env.NODE_ENV === 'test') { window.electronRequire = require; } Beispiel 21.4: Die zugehörige Datei preload.js Da QF‑Test die NODE_ENV-Umgebungsvariable immer mit dem Wert test belegt, können Sie hierdurch dynamisch die Zugriffssicherheit während des Tests auf die benötigten Werte herabsetzen:","hash":"ex_electron_preload_js","h1":"Technische Anmerkungen zum Testen von Electron-Anwendungen im WebDriver-Verbindungsmodus"},"583":{"id":583,"content":"const inTestMode = (process.env.NODE_ENV === 'test'); mainWindow = new BrowserWindow({ webPreferences: { nodeIntegration: inTestMode, enableRemoteModule: inTestMode, contextIsolation: ! inTestMode, ... }, ... }) Beispiel 21.5: Dynamisches Beispiel für eine Electron-Anwendung, die gut getestet werden kann Ab Electron 14 ist das remote Modul nicht mehr Teil des Electron-Frameworks, sondern muss explizit in die Anwendung eingebunden werden. Dazu muss beim Erstellen der Anwendung das Modul @electron/remote in der package.json referenziert und in der main.js initialisiert werden:","hash":"ex_electron_technical_dynamic","h1":"Technische Anmerkungen zum Testen von Electron-Anwendungen im WebDriver-Verbindungsmodus"},"584":{"id":584,"content":"// im \"Main\"-Prozess: require('@electron/remote/main').initialize() Beispiel 21.6: Die Initialisierung des @electron/remote Moduls QF‑Test verwendet dann für die Zugriffe auf Haupt-Prozess automatisch dieses neue Modul. Weitere Infos finden sich in der Modul-Dokumentation unter https://github.com/electron/remote/. Bei der Nutzung des CDP-Driver-Verbindungsmodus ist keine Anpassung der Electron-Anwendung für den Test notwendig.","hash":"ex_electron_initremote","h1":"Technische Anmerkungen zum Testen von Electron-Anwendungen im WebDriver-Verbindungsmodus"},"585":{"id":585,"content":"Pro Handbuch","hash":"","h0":"WebAPI – Webdienste testen | QF‑Test Handbuch"},"586":{"id":586,"content":"Pro Handbuch","hash":"home-link","h0":"WebAPI – Webdienste testen | QF‑Test Handbuch"},"587":{"id":587,"content":"WebAPI – Webdienste testen WebAPI-Tests zeichnen sich dadurch aus, dass WebAPI-Anfragen generiert und deren Antwort und Verhalten überprüft werden. End-to-End-Testszenarien mit zahlreichen Schritten und Abhängigkeiten sind der Bereich, bei dem QF‑Test glänzt. Das bedeutet, dass Sie im Gegensatz zu anderen Testwerkzeugen, mit denen Sie nur eine HTTP-Anfrage senden und die Antwort verifizieren können, mit QF‑Test komplexe Tests implementieren können, bei denen der WebAPI-Test nur ein Teil davon ist. Das heißt, Sie können WebAPI-Tests in End-to-End-GUI-Tests und andere Arten der Automatisierung integrieren. Vor Version 10.0 bot QF‑Test nur Funktionen zum Testen einfacher HTTP-Abläufe. In Version 10.0 wurden neue Knoten für die Behandlung komplexerer Szenarien eingeführt, insbesondere die Knoten Web-Request, Pre-Request-Handler und Post-Request-Handler ebenso wie Request-Anmeldedaten und Request-Einstellungen. Sie ersetzen die bestehenden Knoten und erweitern die Funktionalität, die für WebAPI-Tests bereitgestellt wird, beträchtlich: Direkte Unterstützung für Download, Upload, Fehlerbehandlung, Wiederholung und SSL. Bisher war hierfür zusätzliches Skripting erforderlich. Die Migration von Postman-Collections zu QF‑Test Testsuiten \"Postman-Migration\". Die Implementierung basiert auf dem Paket \"java.net.http\" aus dem Standard-JDK. Die API wird durch QF‑Test mit einer einfach zu bedienenden grafischen Oberfläche versehen, wobei für Experten auch die Möglichkeit besteht, die Objekte in Skripten direkt anzusprechen. Das WebAPI-Feature benötigt eine Lizenz für QF‑Test Web oder für QF‑Test Pro.","hash":"usec_web_services","h0":"WebAPI – Webdienste testen"},"588":{"id":588,"content":"Struktur der WebAPI-Tests Die äußere Struktur der WebAPI-Tests unterscheidet sich nicht von der Struktur von Oberflächentests: Testfälle werden zu Testfallsätzen zusammengefügt, die ihrerseits auf Testsuiten aufgeteilt werden können, die wiederum in einem Projekt liegen können. Prozeduren und Abhängigkeiten sind auch bei WebAPI-Test ausgesprochen hilfreich.","hash":"sec_webapi_pre_post","h1":"Struktur der WebAPI-Tests"},"589":{"id":589,"content":"Die äußere Struktur der WebAPI-Tests unterscheidet sich nicht von der Struktur von Oberflächentests: Testfälle werden zu Testfallsätzen zusammengefügt, die ihrerseits auf Testsuiten aufgeteilt werden können, die wiederum in einem Projekt liegen können. Prozeduren und Abhängigkeiten sind auch bei WebAPI-Test ausgesprochen hilfreich. Abbildung 22.1: Pre- und Post-Request Struktur Im Web-Request-Knoten kann ein Aufruf der WebAPI in einer grafischen Oberfläche konfiguriert werden. Die Pre-Request-Handler und Post-Request-Handler-Knoten implementieren eine Reihe von Methoden (Handler) für die Bearbeitung der WebAPI-Daten vor dem Versand des Requests und für die Verifizierung der Response-Daten - oder um Werte aus der erhaltenen Antwort auszulesen. Request-Anmeldedaten and Request-Einstellungen Knoten können in einen Pre-Request-Handler eingefügt werden. Sie bieten eine grafische Oberfläche für die Konfiguration der Anmeldedaten und Web-Client-Einstellungen. Weitergehende Zugriffe auf die API können über Server-Skript-Knoten implementiert werden. Die Pre- und Post-Request-Sequenzen, die sich innerhalb eines Web-Request-Knotens befinden, gelten nur für diesen. Wenn sie auf höherer Ebene platziert werden, wirkt sich dies auf alle darunterliegenden Web-Request-Knoten aus. Für die Gültigkeit gilt in beiden Fällen: lokal geht über global beziehungsweise innen geht über außen. Das Protokoll enthält alles, was für die Analyse der Request-Ergebnisse benötigt wird. Außer den Web-Request, Pre-Request-Handler und Post-Request-Handler-Knoten finden Sie spezielle Protokolleinträge für die Daten des tatsächlich verschickten Web-Requests sowie der erhaltenen Antwort, jeweils mit Header und Body.","hash":"figure_22.1","h1":"Struktur der WebAPI-Tests"},"590":{"id":590,"content":"Das Protokoll enthält alles, was für die Analyse der Request-Ergebnisse benötigt wird. Außer den Web-Request, Pre-Request-Handler und Post-Request-Handler-Knoten finden Sie spezielle Protokolleinträge für die Daten des tatsächlich verschickten Web-Requests sowie der erhaltenen Antwort, jeweils mit Header und Body. Abbildung 22.2: Pre- und Post-Request Ablauf Im Server-Skript Knoten können Sie die \"WebAPI Skripting-API\" verwenden, die für alle Skriptsprachen verfügbar ist. Wir empfehlen jedoch Groovy, da es angenehmer beim Zugriff auf JSON-Werte ist und besser mit QF‑Test interagiert als die etwas limitierte JavaScript-Engine \"Nashorn\", welche QF‑Test nutzt. Beispiele finden Sie in der Demo-Testsuite webapi_testing.qft, die über das Menü »Datei«-»Lesezeichen«-»Beispiel-Testsuiten«-»WebAPI Suite« oder über »Hilfe«-»Beispiel-Testsuiten erkunden...« geöffnet werden kann.","hash":"figure_22.2","h1":"Struktur der WebAPI-Tests"},"591":{"id":591,"content":"Request-Anmeldedaten Mit Hilfe des Request-Anmeldedaten-Knotens können Sie die Zugangsdaten für einen einzelnen oder mehrere Web-Request-Knoten konfigurieren und setzen. Derzeit unterstützt (HTTP authentication schemes): No authentication Bearer Basic Auth API Key Bitte kontaktieren Sie support@qfs.de, falls Ihr benötigtes Authentifizierungsschema hier nicht aufgeführt ist.","hash":"sec_webapi_auth","h1":"Request-Anmeldedaten"},"592":{"id":592,"content":"Alle SSL-Zertifikate akzeptieren QF‑Test akzeptiert alle SSL-Zertifikate. Sie können die Überprüfung von SSL-Zertifikaten aktivieren, indem Sie die Option OPT_WEBREQUEST_TRUST_ALL_SSL auf false setzen. rc.setOption(Options.OPT_WEBREQUEST_TRUST_ALL_SSL, false) Beispiel 22.1: SSL-Zertfikatsprüfung aktivieren Falls Sie Probleme bei der Verbindung zur zu testenden WebAPI haben, versuchen Sie, QF‑Test folgendermaßen zu starten: qftest -J-Djdk.internal.httpclient.disableHostnameVerification=true Beispiel 22.2: Hostname-Verifikation abschalten Ein im JDK vorhandener Fehler kann es erforderlich machen, QF‑Test mit dieser JVM-Property zu starten.","hash":"sec_sec_webapi_ssl","h2":"Alle SSL-Zertifikate akzeptieren"},"593":{"id":593,"content":"Request-Einstellungen Der Request-Einstellungen Knoten unterstützt aktuell: Die Redirection policy Eine Standardwartezeit Zusätzliche Einstellungen können über ein Server-Skript innerhalb des Post-Request-Handler-Knotens festgelegt werden.","hash":"sec_webapi_settings","h1":"Request-Einstellungen"},"594":{"id":594,"content":"Cookies Cookies können über die Server-Skript-Option OPT_WEBREQUEST_COOKIES aktiviert oder deaktiviert werden. Standardmäßig sind Cookies aktiviert. rc.setOption(Options.OPT_WEBREQUEST_COOKIES, false) Beispiel 22.3: Deaktivieren von Cookies","hash":"sec_sec_webapi_cookies","h2":"Cookies"},"595":{"id":595,"content":"Proxy Proxy-Einstellungen können über die Server-Skript-Option OPT_WEBREQUEST_PROXY festgelegt oder überschrieben werden. Standardmäßig ist die Option nicht gesetzt. rc.setOption(OPT_WEBREQUEST_PROXY, \"my.company.proxy:8081\") Beispiel 22.4: Festlegen eines Proxy-Hosts und Proxy-Ports","hash":"sec_sec_webapi_proxy","h2":"Proxy"},"596":{"id":596,"content":"End-to-End-Szenarien – Geschäftsanwendungslogik Angenommen, Sie möchten einen Testfall erstellen, der ein End-to-End-Szenario wie zum Beispiel einen Geschäftsprozess oder eine umfangreiche Transaktion abbilden soll. In diesem Fall sollten Vorbereitung, Aufräumen und Fehlerbehandlung für die Testfälle über die Abhängigkeiten in QF‑Test implementiert werden. Informationen zum datengetriebenen Testen finden Sie im Kapitel Datentreiber im Handbuch. Für die Konfiguration, Ausführung und Validierung von WebAPI-Anfragen stehen die Pre-Request-Handler und Post-Request-Handler-Sequenzen zur Verfügung.","hash":"sec_webapi_end_to_end","h1":"End-to-End-Szenarien – Geschäftsanwendungslogik"},"597":{"id":597,"content":"Generierung von Single-Request-API-Aufrufen In diesem Fall fungiert QF‑Test als Generator für WebAPI-Requests. Es ist also keine komplexe Testfalllogik erforderlich. Auch hier kann die Abhängigkeit auf oberster Ebene genutzt werden, um allgemeine Vorbereitungen, Aufräumaktionen und Fehlerbehandlung einzurichten. Durch die Verwendung von Pre-Request-Handler- und Post-Request-Handler-Sequenzen auf oberer Ebene können allgemeine Einstellungen und Validierungen eingerichtet werden.","hash":"sec_webapi_atomic","h1":"Generierung von Single-Request-API-Aufrufen"},"598":{"id":598,"content":"HTML-Report Standardmäßig werden im HTML-Report von QF‑Test nur fehlgeschlagene Validierungen gemeldet. Sie können die Protokollierung erfolgreicher Checks über die Option \"Checks auflisten\" im Dialog \"Report erstellen\" oder über das Kommandozeilenargument \"-report-checks (nur Batchmodus)\" erzwingen. Weitere Informationen zur automatisierten Reporterstellung finden Sie unter \"Testausführung im Batchmodus\".","hash":"sec_webapi_reporting","h1":"HTML-Report"},"599":{"id":599,"content":"Postman-Migration Über das Menü »Extras«-»Postman-Collections konvertieren…« wird ein Ordner oder eine einzelne Postman-Sammlung in eine QF‑Test Testsuite konvertiert. Die JavaScript-Skripte von Postman werden als Platzhalter in Groovy-Skripten platziert, Sie müssen sie neu schreiben, wenn Sie diese weiterhin benötigen. Einige zusätzliche Einstellungen, Authentifizierungen oder Metadaten könnten ignoriert werden. Klicken Sie auf \"Convert\", um den Dateiauswahldialog zu öffnen. Der Konvertierungsvorgang beginnt unmittelbar nach dem Schließen des Dateiauswahldialogs.","hash":"sec_webapi_migration_postman","h1":"Postman-Migration"},"600":{"id":600,"content":"HTTP-Standards und Webdienste Alle Webdienste und Websites verwenden das Hypertext Transfer Protocol. Es ist eine textbasierte Kommunikation, die aus Anfragen und Antworten besteht. Hier sind die nützlichsten und überraschend kurzen Internetstandards aufgelistet: Hypertext Transfer Protocol -- HTTP/1.1 HTTP Authentication, 2 Basic Authentication Scheme Die HTTP-Anfrage besteht aus Headern, URL und optional Payload (Body). Die folgenden Grafiken veranschaulichen die Struktur einer HTTP-GET-Anfrage und ihrer Antwort. Die Grafiken stammen aus den Entwicklertools des Chrome-Browsers. Bitte beachten Sie, dass die Entwicklertools eines Browsers nicht das beste Mittel zur Analyse von HTTP-Anfragen sind, da Browser Informationen hinzufügen oder zusätzliche Aktionen ausführen, wie z. B. die erneute Anmeldung nach Ablauf einer Sitzung. Verwenden Sie stattdessen einen speziellen WebAPI-Inspektor. Weitere Informationen finden Sie unter Web-API-Inspektor.","hash":"sec_sec_web_services_standard","h1":"HTTP-Standards und Webdienste"},"601":{"id":601,"content":"Bitte beachten Sie, dass die Entwicklertools eines Browsers nicht das beste Mittel zur Analyse von HTTP-Anfragen sind, da Browser Informationen hinzufügen oder zusätzliche Aktionen ausführen, wie z. B. die erneute Anmeldung nach Ablauf einer Sitzung. Verwenden Sie stattdessen einen speziellen WebAPI-Inspektor. Weitere Informationen finden Sie unter Web-API-Inspektor. Abbildung 22.3: Browser HTTP GET Die Antwort vom Server enthält Antwortcode, Header und optional Nutzlast.","hash":"figure_22.3","h1":"HTTP-Standards und Webdienste"},"602":{"id":602,"content":"Die Antwort vom Server enthält Antwortcode, Header und optional Nutzlast. Abbildung 22.4: Browser HTTP GET Response","hash":"figure_22.4","h1":"HTTP-Standards und Webdienste"},"603":{"id":603,"content":"Web-API-Inspektor Um die Netzwerkkommunikation zu verfolgen, wird ein Proxy benötigt. Installieren oder verwenden Sie die portable Version von mitmproxy. Die Demo-Suite demo/mitmproxy.qft aus der QF‑Test Installation enthält eine Abhängigkeit, die Sie für Ihren Test verwenden können. Sie können auch ein beliebiges Proxy-Programm starten und anschließend über die Option Options.OPT_WEBREQUEST_PROXY einen Proxy für den WebAPI-Test einrichten.","hash":"sec_webapi_inspector","h2":"Web-API-Inspektor"},"604":{"id":604,"content":"Die Knoten Server-HTTP-Request und Browser-HTTP-Request (Legacy) Die Knoten Server-HTTP-Request und Browser-HTTP-Request werden aus Gründen der Abwärtskompatibilität weiterhin unterstützt. Für neue Tests empfehlen wir jedoch die Verwendung von Web-Request. Der Knoten Server-HTTP-Request kann zum Senden beliebiger HTTP-Pakete an einen Host verwendet werden. Er unterstützt die HTTP-Anforderungsmethoden GET, POST, HEAD, PUT, DELETE, TRACE und CONNECT. Bei Server-HTTP-Request müssen Sie selbst dafür sorgen, die HTTP-Anforderung zu erstellen und die Antworten und/oder Ergebnisse zu überprüfen bzw. zu validieren. Geben Sie alle erforderlichen Daten an den entsprechenden Stellen ein, z. B. Header, Nutzdaten usw. Die Antwortverarbeitung sollte bei Bedarf mithilfe der Variablen, die in der Serverantwort eingetragen werden, erstellt werden. Beispiele finden Sie in der Beispiel-Testsuite demo/webservices mit dem Namen webservice_testing.qft. Die Beispiele wurden mithilfe eines für Entwicklungszwecke verwendeten HTTP-Proxys erstellt. Ein solcher Proxy ist mitmproxy.","hash":"sec_sec_web_services_rest","h1":"Die Knoten Server-HTTP-Request und Browser-HTTP-Request (Legacy)"},"605":{"id":605,"content":"Pro Handbuch","hash":"","h0":"Datengetriebenes Testen | QF‑Test Handbuch"},"606":{"id":606,"content":"Pro Handbuch","hash":"home-link","h0":"Datengetriebenes Testen | QF‑Test Handbuch"},"607":{"id":607,"content":"Datengetriebenes Testen Datengetriebenes Testen ist ein sehr wichtiger Aspekt der Testautomatisierung. Das Ziel besteht, kurz gesagt, darin, einen Testfall mehrfach mit dem selben Ablauf, aber unterschiedlichen Eingabe- und Vergleichswerten durchzuführen. QF‑Test bietet verschiedene Möglichkeiten, um Daten für datengetriebene Tests abzulegen oder aus externen Quellen zu laden. Die bequemste Variante basiert auf einem Datentreiber Knoten, der die Umgebung zur Iteration über die Datensätze bereitstellt, sowie ein oder mehrere Daten Knoten, welche die Variablen Werte für die Testdurchläufe liefern. Dabei gibt es in QF‑Test keinen Daten Knoten als solches. Er dient als Oberbegriff für spezielle Ausprägungen wie eine Datentabelle oder eine CSV-Datei. Das Ganze lässt sich am besten anhand von Beispielen erläutern. Eine Demo-Testsuite mit einfachen und komplexeren Beispielen finden Sie unter dem Namen datadriver.qft im Verzeichnis doc/tutorial unterhalb des Wurzelverzeichnisses von QF‑Test. Bitte beachten Sie, dass Sie veränderte Testsuiten am besten in einem projektspezifischen Ordner speichern.","hash":"usec_datadriver","h0":"Datengetriebenes Testen"},"608":{"id":608,"content":"Beispiele für Datentreiber","hash":"sec_beispiele_fur_datentreiber","h1":"Beispiele für Datentreiber"},"609":{"id":609,"content":"Abbildung 23.1: Ein einfacher datengetriebener Test Obige Abbildung zeigt einen Testfallsatz mit einem Datentreiber Knoten, der einen einzelnen Daten Knoten in Form einer Datentabelle enthält. Der Inhalt des Datentabelle Knotens ist wie folgt:","hash":"figure_23.1","h4":"Abbildung 23.1: Ein einfacher datengetriebener Test"},"610":{"id":610,"content":"Abbildung 23.2: Beispiel einer Datentabelle Wird der Testfallsatz ausgeführt, iteriert er über die Zeilen der Datentabelle. Für jeden der drei Iterationsschritte werden die Werte der entsprechenden Zeile der Tabelle an die Variablen mit dem Namen der jeweiligen Spalte gebunden. Im Beispiel ergibt das für den ersten Durchlauf die Bindungen \"Model=Rolo\", \"Variant=None\" und \"Price=19000\". Im zweiten Durchlauf ist dann \"Model=I5\", im dritten \"Model=Minigolf\". Bei jedem Durchgang werden alle Testfall Childknoten des Testfallsatz Knotens ausgeführt. Die folgende Abbildung zeigt ein Protokoll für obigen Testfallsatz:","hash":"figure_23.2","h4":"Abbildung 23.2: Beispiel einer Datentabelle"},"611":{"id":611,"content":"Abbildung 23.3: Protokoll eines datengetriebenen Tests Im nächsten Beispiel sehen wir, dass datengetriebene Tests nicht auf eine einfache Schleife beschränkt sind:","hash":"figure_23.3","h4":"Abbildung 23.3: Protokoll eines datengetriebenen Tests"},"612":{"id":612,"content":"Abbildung 23.4: Datengetriebene Tests mit verschachtelten Schleifen Der Datentreiber enthält nun eine zweite Datentabelle mit folgendem Inhalt:","hash":"figure_23.4","h4":"Abbildung 23.4: Datengetriebene Tests mit verschachtelten Schleifen"},"613":{"id":613,"content":"Abbildung 23.5: Zweites Beispiel einer Datentabelle Der Testfallsatz wird nun insgesamt sechs Iterationen durchlaufen, da für jede der drei Iterationen der äußeren Schleife namens \"cars\" beide Iterationen der inneren Schleife namens \"accessories\" durchlaufen werden. Im folgenden Protokoll ist dies gut zu erkennen:","hash":"figure_23.5","h4":"Abbildung 23.5: Zweites Beispiel einer Datentabelle"},"614":{"id":614,"content":"Abbildung 23.6: Protokoll eines datengetriebenen Tests mit verschachtelten Schleifen Die äußerst hilfreichen dynamisch generierten Namen der Schleifendurchgänge erhalten Sie, indem Sie das Attribut Name für Schleifendurchgang im Protokoll des Datentreiber Knotens auf den Wert \"car Model: $(Model)\" im ersten bzw. \"car Model: $(Model), accessory Name: $(Accessory)\" im zweiten Beispiel setzen. Wie Sie sehen, wird dieser Wert für jede Iteration individuell expandiert, so dass Sie auf die Variablen zugreifen können, die für die Iteration gebunden werden.","hash":"figure_23.6","h4":"Abbildung 23.6: Protokoll eines datengetriebenen Tests mit verschachtelten Schleifen"},"615":{"id":615,"content":"Anwendung von Datentreibern Wie im vorangehenden Beispiel erklärt, muss ein Datentreiber Knoten in einen Testfallsatz Knoten eingefügt werden, und zwar zwischen die optionalen Abhängigkeit und Vorbereitung Knoten. Wird der Testfallsatz ausgeführt, führt er zunächst einen eventuell vorhandenen Datentreiber Knoten aus. Der Inhalt des Datentreiber Knotens ist nicht auf Datentabelle und CSV-Datei beschränkt. Wie ein normaler Sequenz Knoten kann der Datentreiber jede Art von ausführbaren Knoten enthalten, um damit eventuelle Vorbereitungen durchzuführen, die zur Bereitstellung der Daten notwendig sind. Hierdurch ist es auch möglich, die Daten Knoten mehrfach zu nutzen, indem diese einfach in eine Prozedur gestellt werden, welche aus den Datentreiber Knoten heraus aufgerufen wird. Im Prinzip entspricht ein Daten Knoten einer Schleife, bei der in jedem Durchgang verschiedene Werte an Variablen gebunden werden. Ein Daten Knoten muss mit einem Namen im Datentreiber Kontext eines Testfallsatzes registriert werden. Dadurch kann die Schleife durch einen Break Knoten mit dem gleichen Namen abgebrochen werden. Nachdem der Datentreiber ausgeführt wurde, iteriert der Testfallsatz über die dabei registrierten Daten Schleifen. Bei verschachtelten Schleifen wird der zuerst registrierte Daten Knoten als äußerste Schleife ausgeführt. Seine Variablen werden zuerst gebunden und haben damit geringere Bindungskraft als die Variablen der inneren Schleife(n).","hash":"sec_anwendung_von_datentreibern","h1":"Anwendung von Datentreibern"},"616":{"id":616,"content":"Weitere Beispiele für Datentreiber In der mitgelieferten Testsuite doc/tutorial/datadriver.qft finden Sie Beispiele für die Verwendung von CSV- und Excel-Dateien.","hash":"sec_weitere_beispiele_fur_datentreiber","h1":"Weitere Beispiele für Datentreiber"},"617":{"id":617,"content":"Fortgeschrittene Anwendung Neben dem Datentabelle Knoten gibt es verschiedene weitere Möglichkeiten, Daten in einem Datentreiber zu binden. Die Knoten Excel-Datei, CSV-Datei, Datenbank und Datenschleife werden alle ausführlich in \"Datentreiber\" erläutert. Außerdem können Daten durch Aufruf der Prozeduren qfs.databinder.bindList oder qfs.databinder.bindSets in der Standardbibliothek qfs.qft gebunden werden. Als Parameter werden Listen oder Sätze von Werten in Form von Texten übergeben, die aufgeteilt werden, um über die Werte zu iterieren. Informationen zur Standardbibliothek finden Sie im Kapitel \"Die Standardbibliothek\" des Tutorials. Und schließlich können Daten aus Jython (und analog aus Groovy bzw. JavaScript) auch direkt mit Hilfe des databinder Moduls gebunden werden, welches folgende Methoden bietet:","hash":"user_datadriver_advanced","h1":"Fortgeschrittene Anwendung"},"618":{"id":618,"content":"void bindDict(Object rc, String loopname, Map dict, String counter=None, String intervals=None) Erzeugt und registriert ein databinder Objekt, das Daten aus einem Dictionary bindet. Die Schlüssel definieren die Namen der Variablen und die Werte sind Sequenzen, deren Inhalt an die jeweilige Variable gebunden wird. Parameter rcDer aktuelle Runcontext. loopname Der Name unter dem die Daten gebunden werden, entsprechend dem Attribut Name eines Daten Knotens. dictDas zu bindende Dictionary. counter Ein optionaler Variablenname für den Iterationszähler. intervals Optionale Bereiche von Indizes, getrennt durch Komma, z.B. \"0,2-3\".","hash":"api_void_binddict_object_rc_string_loopname_map_dict_string_counter_none_string_intervals_none_in_user_datadriver_advanced","h1":"Fortgeschrittene Anwendung"},"619":{"id":619,"content":"void bindList(Object rc, String loopname, String varname, Object values, String separator=None, String counter=None, String intervals=None) Erzeugt und registriert ein databinder Objekt, das eine Liste von Werten an eine Variable bindet. Parameter rcDer aktuelle Runcontext. loopname Der Name unter dem die Daten gebunden werden, entsprechend dem Attribut Name eines Daten Knotens. varnameDer Name der zu bindenden Variable. values Die zu bindenden Werte. Entweder eine Sequenz oder ein Text, der aufgeteilt wird. separator Optionales Trennzeichen für die Aufteilung der Werte, falls sie als Text übergeben werden. Standard ist Leerraum. counter Ein optionaler Variablenname für den Iterationszähler. intervals Optionale Bereiche von Indizes, getrennt durch Komma, z.B. \"0,2-3\".","hash":"api_void_bindlist_object_rc_string_loopname_string_varname_object_values_string_separator_none_string_counter_none_string_intervals_none_in_user_datadriver_advanced","h1":"Fortgeschrittene Anwendung"},"620":{"id":620,"content":"void bindSets(Object rc, String loopname, Object varnames, Object values, String separator=None, String counter=None, String intervals=None) Erzeugt und registriert ein databinder Objekt, das Sätze von Werten an einen Satz von Variablen bindet. Parameter rcDer aktuelle Runcontext. loopname Der Name unter dem die Daten gebunden werden, entsprechend dem Attribut Name eines Daten Knotens. varnames Die Namen der zu bindenden Variablen. Entweder eine Sequenz, oder ein Text, der aufgeteilt wird. values Die Sätze von zu bindenden Werten. Entweder eine Sequenz von Sequenzen, wobei jede innere Sequenz einem Satz von Daten entspricht, oder ein Text der aufgeteilt wird. separator Optionales Trennzeichen für die Aufteilung der Variablen und der Sätze von Werten, falls diese als Text übergeben werden. Standard ist Leerraum. Sätze von Werten werden jeweils durch Zeilenumbrüche getrennt. counter Ein optionaler Variablenname für den Iterationszähler. intervals Optionale Bereiche von Indizes, getrennt durch Komma, z.B. \"0,2-3\". Einige Beispiele: import databinder # Three iterations with the values \"spam\", \"bacon\" and \"eggs\" # bound to the variable named \"ingredient\" databinder.bindList(rc, \"meal\", \"ingredient\", [\"spam\", \"bacon\", \"eggs\"]) # Same with string values databinder.bindList(rc, \"meal\", \"ingredient\", \"spam bacon eggs\") # Same with string values and special separator databinder.bindList(rc, \"meal\", \"ingredient\", \"spam|bacon|eggs\", \"|\") # Two iterations, the first with item=\"apple\" and number=\"5\", # the second with item=\"orange\" and number=\"3\" databinder.bindSets(rc, \"fruit\", [\"item\", \"number\"], [[\"apple\",5], [\"orange\",3]]) # Same with string values, note the linebreak databinder.bindSets(rc, \"fruit\", \"item number\", \"\"\"apple 5 orange 3\"\"\") # Same as before with the data stored in a dict databinder.bindDict(rc, \"fruit\", {\"item\": [\"apple\", \"orange\"], \"number\": [5,3]}) Beispiel 23.1: Beispiele für die Verwendung des databinder Moduls","hash":"api_void_bindsets_object_rc_string_loopname_object_varnames_object_values_string_separator_none_string_counter_none_string_intervals_none_in_user_datadriver_advanced","h1":"Fortgeschrittene Anwendung"},"621":{"id":621,"content":"Pro Handbuch","hash":"","h0":"Reports und Testdokumentation | QF‑Test Handbuch"},"622":{"id":622,"content":"Pro Handbuch","hash":"home-link","h0":"Reports und Testdokumentation | QF‑Test Handbuch"},"623":{"id":623,"content":"Reports und Testdokumentation Neben Testsuiten und Protokollen erstellt QF‑Test noch eine Reihe weiterer Dokumente. Das wichtigste davon ist der Report, der eine Gesamtübersicht über die Ergebnisse eines oder mehrerer Testläufe liefert, sowie eine Aufstellung der daran beteiligten Testsuiten und deren Einzelergebnissen. Der Report ist leicht zu lesen und ohne tiefere Kenntnis von QF‑Test zu verstehen. Er ergänzt damit das Protokoll, welches vor allem der Fehleranalyse dient und ein gutes Verständnis von QF‑Test erfordert. Die folgende Abbildung zeigt ein Beispiel einer Zusammenfassung eines Reports:","hash":"usec_report","h0":"Reports und Testdokumentation"},"624":{"id":624,"content":"Abbildung 24.1: Beispiel Report Die anderen Dokumente sind eher statischer Natur. Sie beschreiben keine Testergebnisse, sondern den Inhalt von Testsuiten. Ein testdoc Dokument gibt einen Überblick über die Struktur der Testfallsatz und Testfall Knoten einer oder mehrerer Testsuiten. Es dient Test-Architekten und QS Projektleitern zur Dokumentation des aktuellen Standes der Testentwicklung. Ein pkgdoc Dokument ist ähnlich aufgebaut, beschreibt stattdessen aber die Struktur der Package, Prozedur und Abhängigkeit Knoten, vergleichbar zu JavaDoc, welches zur Dokumentation von Java-Bibliotheken genutzt wird. Zielgruppe hierfür sind die Mitarbeiter, welche die Tests implementieren und hierzu Informationen zu bereits vorhandenen Prozeduren und deren Parameter benötigen.","hash":"figure_24.1","h4":"Abbildung 24.1: Beispiel Report"},"625":{"id":625,"content":"Reports Bevor wir näher auf das Erstellen von Reports eingehen können, müssen zunächst einige grundlegende Konzepte erläutert und Begriffe definiert werden.","hash":"usec_reports","h1":"Reports"},"626":{"id":626,"content":"Reportkonzepte Ein Report ist das Ergebnis einer oder mehrerer Testläufe. Ein Testlauf umfasst die Ausführung einer oder mehrerer Testsuiten, normalerweise gemeinsam in einem Batch-Lauf. Ein Testlauf wird durch seine Run-ID identifiziert. Es ist möglich einen Testlauf in mehreren Schritten durchzuführen indem den Protokollen die selbe Run-ID zugewiesen wird. Ein Report kann einen Reportnamen haben. Für einen Report, der einen einzelnen Testlauf repräsentiert, stimmt dieser normalerweise mit der Run-ID des Testlaufs überein. Für Reports, die mehrere Testläufe zusammenfassen, kann ein eigener Name festgelegt werden. Reports können in verschiedenen Varianten erstellt werden: XML, HTML und JUnit. Die meisten Anwender werden wohl die HTML-Variante nutzen, welche in einem Browser dargestellt, ausgedruckt und archiviert werden kann. Die XML-Variante kann als Basis zur weiteren Verarbeitung der Testergebnisse dienen, z.B. um diese in einer Datenbank zu sammeln oder um speziell angepasste HTML-Reports zu generieren. Wir empfehlen immer HTML und XML-Reports gemeinsam zu erstellen, sofern Sie keinen guten Grund für ein anderes Vorgehen haben. JUnit-Reports basieren auf dem JUnit-XML-Format, wie es Apache Ant mit Hilfe der JUnitReport-Task erzeugt. Dieses Format ist nicht so schön und detailliert wie bei den beiden anderen von QF‑Test angebotenen Varianten, jedoch wird es direkt von vielen Continuous Integration Tools verstanden und kann hilfreich für eine schnelle Integration mit solchen sein. Ein Report besteht aus einem Dokument mit der Zusammenfassung sowie je einem Dokument pro Protokoll. Diese werden zusammen mit ergänzenden Dateien wie Icons, Stylesheets und Bildschirmabbildern in einem gemeinsamen Verzeichnis abgelegt. Auf Dateiebene repräsentiert dieses Verzeichnis den Report. Die Anordnung der Dateien innerhalb des Report Verzeichnisses kann wie weiter unten beschrieben über die Kommandozeile beeinflusst werden. Es gibt im Wesentlichen zwei Varianten die Dateien anzuordnen: Analog zur Dateistruktur der ursprünglichen Testsuiten oder entsprechend der Struktur der Protokolldateien.","hash":"sec_reportkonzepte","h2":"Reportkonzepte"},"627":{"id":627,"content":"Inhalt von Reports Vor dem Gesamtergebnis enthält ein Testbericht, wie oben gezeigt, eine Zusammenfassung von wichtigen Systeminformationen und eine Legende mit der Bedeutung der verwendeten Zählersymbole (siehe auch Abspielen von Tests). Der Unterschied zwischen \"In Tests verbrachte Zeit\" und \"Real verstrichene Zeit\" sind explizite Verzögerungen in Knoten mittels 'Verzögerung vorher/nachher' oder Unterbrechungen durch den Benutzer. Die Inhalte von Reports basieren auf den ausgeführten Testsuiten. Die Grobstruktur entspricht deren Testfallsatz und Testfall Knoten. Die Bemerkung Attribute des Wurzelknotens, sowie der Testfallsatz und Testfall Knoten unterstützen die selben Doctags wie die in \"Testdoc-Dokumentation für Testfallsätze und Testfälle\" beschriebenen testdoc Dokumente. Zusätzlich kann über das Doctag '@title' in der Bemerkung des Wurzelknotens ein Titel für das Report-Dokument festgelegt werden, das für die jeweilige Testsuite erstellt wird. Falls -report-teststeps im Batchmodus oder die entsprechende Option im interaktiven Dialog verwendet wird (Standard ist true), können Testfälle mit Hilfe von Testschritt Knoten weiter heruntergebrochen werden. Neben dem expliziten Verpacken in Testschritt Knoten können beliebige Knoten auch durch Angabe des Doctags '@teststep', optional gefolgt von einem Namen, in der Bemerkung des jeweiligen Knotens als Testschritt ausgezeichnet werden. Für Testschritt Knoten werden außerdem die Doctags '@author', '@version' und '@since' unterstützt. Namen, Kommentare und Werte von Doctags können Variablen enthalten, die zum Zeitpunkt der Ausführung expandiert werden, so dass der expandierte Wert im Report angezeigt wird. Dies ist speziell für Testschritte in Prozeduren sehr hilfreich. Ist das Aufführen von Testschritten im Report aktiv, werden auch Vorbereitung, Aufräumen und Abhängigkeit Knoten aufgeführt und Checks, Bildschirmabbilder und Meldungen, darunter Warnungen, Fehler und Exceptions, passend in die verschachtelten Schritte einsortiert. Wenn die Testsuiten ordentlich implementiert sind kann der resultierende Report als einfach lesbare Zusammenfassung dessen dienen, was während der Ausführung eines Tests vor sich ging. Ob Warnungen und Checks im Report aufgeführt werden, hängt von den Kommandozeilenargumenten -report-warnings und -report-checks bzw. deren interaktiven Pendants ab. Warnungen zur Wiedererkennung von Komponenten werden nie aufgeführt, da sie zu technisch sind und leicht den Report überfluten könnten. Für Checks muss zwischen solchen unterschieden werden, die eine echte Verifikation repräsentieren und solchen, die nur zur Steuerung des Tests dienen. Ein klassisches Beispiel für letztere ist die Überprüfung, ob eine Checkbox bereits selektiert ist, bevor auf diese geklickt wird. Normalerweise führt QF‑Test nur solche Check Knoten im Report auf, deren Ergebnisbehandlung dem Standard entspricht, d.h. Fehlerstufe der Meldung ist 'Fehler', es wird keine Exception geworfen und keine Ergebnisvariable gebunden. Alle anderen werden als Helfer für die Teststeuerung interpretiert und erscheinen nicht im Report. Für Fälle, in denen dieses Vorgehen nicht passt, kann ein Check Knoten explizit durch Angabe des Doctags '@report' in den Report aufgenommen, oder durch Angabe von '@noreport' davon ausgeschlossen werden. Natürlich werden fehlgeschlagene Checks als Warnung, Fehler oder Exception interpretiert (abhängig von ihrem Attribut Fehlerstufe der Meldung) und können nicht vom Report ausgeschlossen werden, wenn Meldungen mit der entsprechenden Fehlerstufe dort angezeigt werden. Zusätzliche Meldungen, Checks und Bildschirmabbilder können mit Hilfe von Skripten in den Report eingefügt werden. Hierzu dienen die Methoden rc.logMessage, rc.check mit Varianten und rc.logImage, die einen optionalen report Parameter haben. Details finden Sie in der API Dokumentation zum Runcontext in \"Das rc-Modul: Die API des Runcontexts\".","hash":"usec_reports_content","h2":"Inhalt von Reports"},"628":{"id":628,"content":"Reports erstellen Es gibt drei verschiedene Wege Reports zu erstellen: Interaktiv aus einem Protokoll über den Menüeintrag »Datei«-»Report erstellen...«. Im Batchmodus als Ergebnis eines Testlaufs. Im Batchmodus durch Transformation zuvor erstellter Protokolle. Die interaktive Variante ist einfach und bedarf keiner weiteren besonderen Erklärungen. Wählen Sie das Zielverzeichnis für den Report und entscheiden Sie sich für die XML und/oder HTML-Variante. Für die Reporterstellung im Batchmodus gibt es einige Kommandozeilen Optionen, welche in \"Kommandozeilenargumente\" erklärt werden. Sehen wir uns nun zunächst die Variante zur Erstellung eines Reports als Ergebnis eines Testlaufs an: Die Kommandozeilen Syntax für einen normalen Testlauf im Batchmodus ist qftest -batch <Testsuite> [<Testsuite>...] Um einen kombinierten XML- und HTML-Report zu erstellen, verwenden Sie -report <Verzeichnis>. Für das Erzeugen der XML- oder HTML-Varianten alleine oder um diese zu trennen, dienen die Argumente -report-xml <Verzeichnis> und/oder -report-html <Verzeichnis>. Für JUnit-Reports funktioniert -report-junit <Verzeichnis> entsprechend. Die Run-ID eines Testlaufs wird mittels -runid [<ID>] angegeben, der Reportname mittels -report-name <Name>. Ist -report-name <Name> nicht angegeben entspricht der Reportname der Run-ID. Um die Dateien im Report Verzeichnis entsprechend den Testsuiten anzuordnen, verwenden Sie -sourcedir <Verzeichnis>. Eine Struktur auf Basis der Protokolle können Sie mittels -runlogdir <Verzeichnis> erreichen. Ein typisches Beispiel einer Kommandozeile für einen Batch-Lauf, die Gebrauch von den in \"Platzhalter im Dateinamen für Protokoll und Report\" beschriebenen Platzhaltern macht, sieht etwa wie folgt aus: qftest -batch -runid +M+d -runlog logs/+i -report report_+i -sourcedir . suite1.qft subdir/suite2.qft Beispiel 24.1: Erstellen eines Reports als Ergebnis eines Testlaufs Das Erstellen eines Reports als separaten Schritt aus bereits vorhandenen Protokollen ist in vieler Hinsicht ähnlich. Anstelle der Testsuiten müssen die zu transformierenden Protokolle angegeben werden. Die Optionen -runid [<ID>] und -sourcedir <Verzeichnis> haben keinen Effekt. Das folgende Beispiel zeigt, wie Sie einen Report zur Zusammenfassung der Testergebnisse einer Woche erstellen können. Es wird davon ausgegangen, dass die Protokolle unterhalb des logdir Verzeichnisses liegen, gegebenenfalls in Unterverzeichnissen: qftest -batch -genreport -report report_+M+d -report.name week_of_+y+M+d logdir Beispiel 24.2: Erstellen eines Reports für eine Wochen-Zusammenfassung","hash":"sec_reports_erstellen","h2":"Reports erstellen"},"629":{"id":629,"content":"Individualisierung von Reports Die XML und HTML-Reports werden über eine XSL-Transformation des QF‑Test Protokolls erzeugt. Durch die Anpassung der XSLT Stylesheets können Inhalt und Struktur der erzeugten Dokument angepasst werden. Weitere Informationen hierzu finden sie in unserem Blog-Artikel \"Wie erstellt man kundenspezifische HTML-/XML-/JUnit-Reports?\": https://www.qftest.com/blog/article/2019/02/28/wie-erstellt-man-kundenspezifische-htmlxmljunit-reports.html Alternativ kann die Darstellung des HTML-Reports durch gängige Web-Techniken via JavaScript beeinflusst werden. Eine Datei namens user.js wird in das Report-Verzeichnis kopiert und in alle Seiten des HTML-Reports eingebunden. Um die Darstellung anzupassen überschreiben Sie diese Datei mir Ihrer eigenen Version nach Generierung des Reports. Ein Beispiel hierzu finden Sie im Kommentar der user.js Datei.","hash":"usec_customizingreports","h2":"Individualisierung von Reports"},"630":{"id":630,"content":"Testdoc-Dokumentation für Testfallsätze und Testfälle Die Dokumente vom Typ testdoc liefern eine Übersicht über und Detailinformationen zu den Testfallsatz und Testfall Knoten einer oder mehrerer Testsuiten. Wenn Testschritte in Testfälle enthalten sind, werden diese Schritte auch aufgeführt. Testaufruf Knoten werden normalerweise bei der Testdoc-Generierung ignoriert. Mit -testdoc-followcalls=true werden die referenzierten Ziele, also Testfall, Testfallsatz oder ganze Testsuiten, so eingebunden, als wären diese Teil der Ausgangssuite. Diese Dokumentation ist ein wichtiges Werkzeug für QS Projektleiter um den aktuellen Stand der Testentwicklung im Blick zu behalten. Wie die Reports sind testdoc Dokumente als Verzeichnis aufgebaut, mit einer Zusammenfassung und je einem detaillierten Dokument pro Testsuite. Ein testdoc Dokument für eine einzelne Testsuite kann interaktiv über den Eintrag »Testdoc-Dokumentation erstellen...« im »Datei« Menü generiert werden. Das ist hilfreich um während der Testentwicklung schnell überprüfen zu können, ob alle Tests ordentlich dokumentiert sind. Für den Gebrauch als Referenz sind dagegen komplette Sätze von Dokumenten über mehrere Testsuiten aus einem gesamten Projekt vorzuziehen. Diese können durch Aufruf von QF‑Test im Batchmodus mit Hilfe des Kommandozeilenarguments -gendoc erstellt werden. In seiner einfachsten Form sieht ein Aufruf zum Erstellen einer testdoc Dokumentation für eine gesamte Verzeichnishierarchie so aus: qftest -batch -gendoc -testdoc test_documentation directory/with/test suites Beispiel 24.3: Erstellen von testdoc Dokumentation Detaillierte Informationen zu den verfügbaren Kommandozeilenargumenten finden Sie in \"Kommandozeilenargumente und Rückgabewerte\". Für optimale Ergebnisse können Sie in den Bemerkung Attributen von Testfallsatz und Testfälle Knoten HTML-Auszeichnungen verwenden und Doctags einsetzen. Ein Doctag ist ein mit '@' beginnendes Schlüsselwort, manchmal gefolgt von einem Namen und immer von einer Beschreibung. Dies ist ein bewährtes Konzept von JavaDoc, dem Format zur Dokumentation von Java-Programmen (siehe http://www.oracle.com/technetwork/java/javase/documentation/index-137868.html#tag). Die Doctags müssen nach der eigentlichen Beschreibung stehen, da Beschreibung, welche nach den Doctags steht, ignoriert wird. Weiterhin dürfen keine Doctags innerhalb der Beschreibung vorkommen. Die folgenden Doctags werden für Testfallsatz und Testfall Knoten unterstützt: @deprecated Gibt an, dass ein Testfallsatz oder Testfälle nicht länger verwendet werden soll. Die Beschreibung sollte erklären, seit wann und warum das der Fall ist und vor allem angeben, was stattdessen verwendet werden soll. @condition Informelle Beschreibung der Bedingung unter welcher der Knoten ausgeführt oder übersprungen wird. @param Ein Prozedurparameter. Es folgen der Name des Parameters und seine Beschreibung. @charvar Eine charakteristische Variable. Es folgen der Name der Variable und ihre Beschreibung. @author Autor des Testfallsatzes oder Testfalls. @version Version des Testfallsatzes oder Testfalls. @since Seit welcher Version dieser Testfallsatz oder Testfall verfügbar ist. Neben den oben beschriebenen Doctags kann über das Doctag '@title' ein Titel für das testdoc Dokument festgelegt werden, das für die jeweilige Testsuite erstellt wird.","hash":"usec_testdoc","h1":"Testdoc-Dokumentation für Testfallsätze und Testfälle"},"631":{"id":631,"content":"Pkgdoc-Dokumentation für Packages, Prozeduren und Abhängigkeiten Die Konzepte von pkgdoc Dokumenten und die Methoden für deren Erstellung sind praktisch identisch zur testdoc-Dokumentation. Im Unterschied zu dieser beschreibt pkgdoc die Package, Prozedur und Abhängigkeit Knoten einer Testsuite. Es dient Test-Entwicklern als Übersicht über die Prozeduren, die zur Implementierung von Tests zur Verfügung stehen. Die Standardbibliothek qfs.qft ist ein schönes Beispiel, wie ein pkgdoc Dokument aussehen kann. Ein pkgdoc Dokument kann ebenfalls interaktiv über »Datei«-»HMTL/XML Pkgdoc erstellen...« oder im Batchmodus generiert werden. Auch hier finden Sie nähere Informationen zu den verfügbaren Kommandozeilenargumenten in \"Kommandozeilenargumente und Rückgabewerte\". Wie das folgende Beispiel zeigt, können testdoc und pkgdoc auch gemeinsam in einem einzigen Batch-Lauf erstellt werden: qftest -batch -gendoc -testdoc tests -pkgdoc procedures directory/with/test suites Beispiel 24.4: Erstellen von testdoc und pkgdoc Dokumentation in einem Durchgang Natürlich unterstützt pkgdoc ebenso HTML-Auszeichnungen und Doctags. Die folgenden Doctags stehen für Packages, Prozeduren und Abhängigkeiten zur Verfügung: @deprecated Gibt an, dass ein Package, eine Prozedur oder eine Abhängigkeit nicht länger verwendet werden soll. Die Beschreibung sollte erklären, seit wann und warum das der Fall ist und vor allem angeben, was stattdessen verwendet werden soll. @param (nur Prozedur und Abhängigkeit) Ein Parameter für eine Prozedur oder Abhängigkeit. Es folgen der Name des Parameters und seine Beschreibung. @charvar (nur Abhängigkeit) Eine charakteristische Variable. Es folgen der Name der Variable und ihre Beschreibung. @return (nur Prozedur) Der Rückgabewert der Prozedur. @result (nur Prozedur und Abhängigkeit) Hier könnten Seiteneffekte wie das Setzen von globalen Variablen dokumentiert werden. @throws (nur Prozedur) Erwartete Exception. Es folgen der Name der Exception und die Beschreibung, in welchem Fall diese geworfen wird. @catches (nur Abhängigkeit) Eine Exception, die von der Abhängigkeit gefangen wird. Es folgen der Name der Exception und die Beschreibung Ihrer Behandlung. @author Autor des Packages der Prozedur oder der Abhängigkeit. @version Version des Packages der Prozedur oder der Abhängigkeit. @since Seit welcher Version dieses Package diese Prozedur oder diese Abhängigkeit verfügbar ist. Neben den oben beschriebenen Doctags kann über das Doctag '@title' ein Titel für das pkgdoc Dokument festgelegt werden, das für die jeweilige Testsuite erstellt wird.","hash":"usec_pkgdoc","h1":"Pkgdoc-Dokumentation für Packages, Prozeduren und Abhängigkeiten"},"632":{"id":632,"content":"Pro Handbuch","hash":"","h0":"Testausführung | QF‑Test Handbuch"},"633":{"id":633,"content":"Pro Handbuch","hash":"home-link","h0":"Testausführung | QF‑Test Handbuch"},"634":{"id":634,"content":"Testausführung Die Ausführung von Tests ist unter verschiedenen Blickwinkeln zu betrachten: Zum einen werden Tests während der Entwicklung aus der laufenden QF‑Test Anwendung heraus ausgeführt, um die Funktionstüchtigkeit der Tests zu überprüfen. Diese Situation wurde bereits in \"Abspielen von Tests\" behandelt; sie reduziert sich im Wesentlichen auf den Aufruf von »Wiedergabe«-»Start« im QF‑Test Hauptmenü. Auf der anderen Seite sollen die entwickelten Tests regelmäßig ausgeführt werden, um die Stabilität der getesteten Software sicherzustellen - etwa bei nächtlichen Regressionstests. Anstatt die auszuführende Testsuite mit QF‑Test zu öffnen und über die Benutzeroberfläche auszuführen, ist es hier viel praktischer, den Testlauf von der Kommandozeile im sogenannten Batchmodus zu starten. Diese Art der Testausführung bildet den ersten Abschnitt dieses Kapitels (Testausführung im Batchmodus). In manchen Situationen, etwa wenn der Testlauf auf einem entfernten Rechner ausgeführt werden soll, kommt eine weitere Variante ins Spiel: der Daemonmodus. Hier dient eine laufende QF‑Test Instanz sozusagen als Ausführungsorgan für Tests. Mit diesem Thema wird sich der zweite Abschnitt befassen (Testausführung im Daemonmodus). Hinweise zur Integration von QF‑Test mit Build Tools wie ant, maven oder Jenkins finden Sie in \"Integration mit Entwickler-Tools\".","hash":"usec_testexecution","h1":"Testausführung"},"635":{"id":635,"content":"Pro Handbuch","hash":"","h0":"Testausführung im Batchmodus | QF‑Test Handbuch"},"636":{"id":636,"content":"Pro Handbuch","hash":"home-link","h0":"Testausführung im Batchmodus | QF‑Test Handbuch"},"637":{"id":637,"content":"Testausführung im Batchmodus Grundlage für die Ausführung von Tests über die Kommandozeile bildet eine Vielzahl von Argumenten, mit denen QF‑Test im Batchmodus gestartet werden kann. Anschließend werden exemplarisch einige davon behandelt; eine Übersicht über alle Optionen findet man in \"Kommandozeilenargumente und Rückgabewerte\". Die nachfolgenden Beispiele sind für Windows geschrieben, lassen sich aber leicht auf Linux übertragen. Neben den Pfadangaben unterscheidet sich die Syntax nur noch in Bezug auf die Platzhalter (\"Platzhalter im Dateinamen für Protokoll und Report\"): Unter Linux kann neben der Form +X auch %X verwendet werden. Unter Windows gibt es außerdem neben der GUI-Anwendung qftest.exe auch eine Konsolen-Variante qftestc.exe. Diese wartet, bis die Ausführung von QF‑Test beendet ist und gibt u. a. auch print-Ausgaben von einem Server-Skript aus.","hash":"usec_execbatch","h0":"Testausführung im Batchmodus"},"638":{"id":638,"content":"Verwenden der Kommandozeile Der einfachste Aufruf von QF‑Test, um einen Test auszuführen, sieht so aus: qftest -batch -run c:\\mysuites\\suiteA.qft Beispiel 25.1: Testausführung von der Kommandozeile Das Argument -batch sorgt dafür, dass QF‑Test ohne graphische Benutzeroberfläche gestartet wird. Das zweite Argument, -run, sagt QF‑Test, dass ein Test ausgeführt werden soll. Den Abschluss der Kommandozeile bildet die auszuführende Testsuite. Das Argument -run ist optional, d. h. die Testausführung ist als Standard für den Batchmodus definiert. Führt man die obige Anweisung aus, werden alle Testfall und Testfallsatz Knoten nacheinander ausgeführt, die in der Testsuite suiteA.qft auf der obersten Ebene (d. h. direkt unterhalb des Testsuite Knotens) definiert sind. Nach Beendigung des Testlaufs findet man im aktuellen Verzeichnis, unter dem gleichen Namen wie die Testsuite, eine Protokolldatei, der man das Testergebnis entnehmen kann. Durch Angabe von -nolog kann die Erstellung der Protokolldatei auch unterdrückt werden. Das macht aber wahrscheinlich nur dann Sinn, wenn man seinen Test um eigene Protokollausgaben bereichert hat, die etwas in eine Datei geschrieben werden. Ansonsten lieferte nur noch der Rückgabewert von QF‑Test einen Hinweis auf den Ausgang des Testlaufs: 0 bedeutet, dass der Test erfolgreich absolviert wurde, ein positiver Wert hingegen ist die Folge von Warnungen, Fehlern oder gar Exceptions (siehe \"Rückgabewerte von QF‑Test\"). In der Regel möchte man also wohl ein Protokoll des Testlaufs erstellen und dieses an einer bestimmten Stelle im Dateisystem ablegen. Das geht über den Parameter -runlog: qftest -batch -compact -runlog c:\\mylogs\\+b c:\\mysuites\\suiteA.qft Beispiel 25.2: Testausführung mit Protokolldatei Nun wird eine Protokolldatei suiteA.qrz im angegebenen Verzeichnis c:\\mylogs erstellt. Der Platzhalter +b sorgt dafür, dass sie den Namen von der Testsuite übernimmt. Durch die Angabe von -compact wird erreicht, dass nur die wichtigsten Knoten in die Protokolldatei übernommen werden, also nur solche, die für den Report und gegebenenfalls die Fehleranalyse benötigt werden. Bei sehr umfangreichen Tests kann dieser Parameter helfen, den Anspruch an Arbeitsspeicher in Grenzen zu halten, wobei die neuere Möglichkeit, Protokolldateien zu splitten, sogar noch mächtiger ist. Nähere Informationen dazu finden Sie in \"Das Protokoll\". Ob die Datei hier tatsächlich als komprimiertes Protokoll (das ist vom obigen \"compact\" zu unterscheiden) mit der Endung .qrz erstellt wird, hängt von den Einstellungen ab. Um ein bestimmtes Format zu erzwingen, kann die Endung explizit angegeben werden, also z. B. -runlog c:\\mylogs\\+b.qrl, wenn unkomprimiertes XML gewünscht wird. Manchmal möchte man vielleicht nicht die komplette Testsuite, sondern nur bestimmte Testfälle ausführen. Über den Parameter -test lässt sich ein ganz bestimmter Knoten zur Ausführung festlegen: qftest -batch -runlog c:\\mylogs\\+b -test \"Mein Test\" c:\\mysuites\\suiteA.qft Beispiel 25.3: Ausführung eines bestimmten Knotens Die Angabe \"Mein Test\" bezieht sich dabei auf das Attribut QF‑Test ID des auszuführenden Knotens; bei Testfall oder Testfallsatz Knoten kann auch deren qualifizierter Name angegeben werden. Sollen mehrere Knoten ausgeführt werden, kann das Argument -test <ID> auch mehrfach angegeben werden. Neben der QF‑Test ID eines Knotens versteht -test auch die Angabe eines numerischen Index. So würde etwa -test 0 den ersten Knoten unterhalb von Testsuite ausführen. Das Protokoll liefert eine eher technische Sicht auf den Ablauf eines Tests; es ist vor allem nützlich, um während eines Testlaufs aufgetretene Fehler zu analysieren (vgl. \"Das Protokoll\"). Eine übersichtliche Darstellung über die ausgeführten Testfälle und eventuell aufgetretene Fehler bietet hingegen der Report. Er wird aus der Protokolldatei erstellt und liegt anschließend im XML- und/oder HTML-Format vor. Der Report kann also auch nachträglich aus einer (oder mehreren) Protokolldateien erstellt werden (vgl. \"Reports und Testdokumentation\"). Um gleich bei der Testausführung dafür zu sorgen, verwendet man -report: qftest -batch -runlog c:\\mylogs\\+b -report c:\\mylogs\\rep_+b_+y+M+d+h+m c:\\mysuites\\suiteA.qft Beispiel 25.4: Testausführung mit Reportgenerierung Hier werden die XML- und HTML-Reportdateien in einem Verzeichnis erstellt, dessen Name sowohl die Testsuite wie auch Datum und Uhrzeit enthält, etwa: c:\\mylogs\\rep_suiteA_0806042152. Ersetzt man das Argument -report durch -report.xml bzw. -report.html, so wird nur der XML- bzw. nur der HTML-Report erstellt. Testfälle sind oft parametrisiert, das heißt, sie verwenden Variablen, deren Werte den Testablauf bestimmen. Ist beispielsweise im Testsuite Knoten eine Variable myvar definiert, kann deren Vorgabewert zur Testausführung überschrieben werden: qftest -batch -variable myvar=\"Value from command line\" -runlog c:\\mylogs\\+b c:\\mysuites\\suiteA.qft Beispiel 25.5: Testausführung mit Variablen Sollen mehrere Variablen gesetzt werden, kann -variable <name>=<wert> auch mehrfach angegeben werden.","hash":"sec_verwenden_der_kommandozeile","h1":"Verwenden der Kommandozeile"},"639":{"id":639,"content":"Windows Befehlsskript Die Möglichkeit, Tests über die Kommandozeile ausführen zu können, bildet die Grundlage zur einfachen Integration von QF‑Test in bestehende Testmanagement-Systeme (siehe Anbindung an Testmanagementtools). Wer hingegen kein Testmanagement-System betreibt, mag es vielleicht praktisch finden, das Kommando zur Testausführung in ein Skript einzubetten. Ein einfaches Windows Befehlsskript (qfbatch.bat) könnte zum Beispiel wie folgt aussehen: @echo off setlocal if \"%1\" == \"\" ( echo Usage: qfbatch Testsuite goto end ) else ( set suite=%~f1 ) set logdir=c:\\mylogs pushd c:\\programs\\qftest\\qftest-10.0.2-pro\\bin @echo on .\\qftest -batch -compact -runlog %logdir%\\+b %suite% @echo off if %errorlevel% equ 0 ( echo Test terminated successfully goto end ) if %errorlevel% equ 1 ( echo Test terminated with warnings goto end ) if %errorlevel% equ 2 ( echo Test terminated with errors goto end ) if %errorlevel% equ 3 ( echo Test terminated with exceptions goto end ) if %errorlevel% leq -1 ( echo Error %errorlevel% goto end ) :end popd Beispiel 25.6: Befehlsskript qfbatch.bat zur Ausführung einer Testsuite Nun braucht man nur noch das Skript auszuführen, mit dem Dateinamen der auszuführenden Testsuite als Parameter. Der Rest geht von alleine: Die Testsuite wird ausgeführt, die Protokolldatei im Verzeichnis logdir abgelegt und abschließend gibt das Skript in Abhängigkeit vom QF‑Test Rückgabewert eine Statusmeldung aus.","hash":"sec_windows_befehlsskript","h1":"Windows Befehlsskript"},"640":{"id":640,"content":"Groovy Seit Version 3 ist die Sprache Groovy Bestandteil von QF‑Test (siehe \"Skripting\"). Hauptsächlich gedacht ist sie zum Schreiben von Server- und SUT-Skripten, aber Groovy kann ebenso wie Jython auch außerhalb von QF‑Test verwendet werden. Diese Sprache ist sicher gut geeignet, um sich selbst ein kleines Management-System zur Testautomatisierung zu erstellen. Mit Groovy lässt sich übrigens auch der Einsatz von Ant vereinfachen, denn statt mit klobigen XML-Dateien, über die sich zudem etwa Bedingungen nur schwer umsetzen lassen, kann man dank AntBuilder mit übersichtlichem Groovy-Code arbeiten. Das folgende Beispiel kommt allerdings ohne Ant aus: def suite = '' if (args.size() == 0) { println 'Usage: groovy QfExec Testsuite' return } else { suite = args[0] } def qftestdir = 'c:\\\\programs\\\\qfs\\\\qftest\\\\qftest-10.0.2-pro' def qftest = qftestdir + '\\\\bin\\\\qftest.exe' def command = [qftest, \"-batch\", \"-compact\", \"-runlog\", \"c:\\\\mylogs\\\\+b\", suite] def printStream = { stream -> while (true) { try { stream.eachLine { println it } } catch (IOException) { break } } } println \"Running command: $command\" def proc = command.execute() new Thread().start() { printStream(proc.in) } new Thread().start() { printStream(proc.err) } proc.waitFor() switch (proc.exitValue()) { case '0': println 'Test terminated successfully'; break case '1': println 'Test terminated with warnings'; break case '2': println 'Test terminated with errors'; break case '3': println 'Test terminated with exceptions'; break default: println \"Error ${proc.exitValue()}\" } Beispiel 25.7: Groovy-Skript QfExec.groovy zur Ausführung einer Testsuite Sollte Groovy unabhängig von QF‑Test auf Ihrem Rechner installiert sein, kann die Beispiel-Testsuite einfach mit groovy QfExec c:\\mysuites\\suiteA.qft ausgeführt werden. Andernfalls kann auch die Groovy jar-Datei aus der QF‑Test Installation verwendet werden. Am besten nutzt man in diesem Fall zur Ausführung von Groovy wieder ein Befehlsskript: @echo off setlocal if \"%1\" == \"\" ( echo Usage: qfexec Testsuite goto end ) set qftestdir=c:\\programs\\qftest\\qftest-10.0.2-pro set scriptfile=QfExec.groovy java -cp %qftestdir%/lib/groovy-all.jar groovy.ui.GroovyMain %scriptfile% %* :end Beispiel 25.8: Befehlsskript qfexec.bat zur Ausführung von Groovy (hier QfExec.groovy) Die Testsuite kann nun mit qfexec c:\\mysuites\\suiteA.qft ausgeführt werden.","hash":"sec_groovy","h1":"Groovy"},"641":{"id":641,"content":"Pro Handbuch","hash":"","h0":"Testausführung im Daemonmodus | QF‑Test Handbuch"},"642":{"id":642,"content":"Pro Handbuch","hash":"home-link","h0":"Testausführung im Daemonmodus | QF‑Test Handbuch"},"643":{"id":643,"content":"Testausführung im Daemonmodus Im Daemon-Modus gestartet lauscht QF‑Test auf RMI Verbindungen und stellt darüber ein Interface für die verteilte Ausführung von Tests zur Verfügung. Dies kann für die Testdurchführung in einem verteilten Lasttest Szenario (vgl. \"Durchführung von Lasttests mit QF‑Test\") ebenso hilfreich sein wie für die Integration mit vorhandenen Testmanagement- oder Testdurchführungs-Werkzeugen (vgl. \"Anbindung an Testmanagementtools\"). GUI Tests benötigen eine aktive Benutzersession um korrekt ausgeführt werden zu können. Sie finden im Kapitel Aufsetzen von Testsystemen nützliche Tipps und Tricks für die Einrichtung Ihrer Testsysteme. Der technische Hintergrund ist in FAQ 14 beschrieben.","hash":"usec_execdaemon","h0":"Testausführung im Daemonmodus"},"644":{"id":644,"content":"Starten des Daemons !!! Warnung !!! Jeder, der Zugriff auf den QF‑Test Daemon hat, kann auf dessen Rechner Programme mit den Rechten des Benutzerkontos starten, unter dem der Daemon läuft. Daher sollte Zugriff nur berechtigten Nutzern gewährt werden. Wenn Sie den Daemon nicht in einer sicheren Umgebung betreiben, in der jeder Nutzer als berechtigt gilt, oder wenn Sie eine eigene Bibliothek zum Zugriff auf den Daemon entwickeln, sollten Sie unbedingt \"Absicherung des QF‑Test Daemon\" lesen. Darin ist beschrieben, wie Sie die Kommunikation mit dem Daemon mittels SSL absichern können. Um mit dem Daemon arbeiten zu können, muss er zunächst auf irgendeinem Rechner im Netzwerk gestartet werden (das kann natürlich auch localhost sein): qftest -batch -daemon -daemonport 12345 Beispiel 25.9: Starten des QF‑Test Daemon Wichtiger Hinweise zur Kompatibilität: Beginnend mit QF‑Test Version 3.5 wird für die Kommunikation mit dem Daemon standardmäßig SSL verwendet. Um mit einer QF‑Test Version älter als 3.5 interagieren zu können, muss der Daemon mit leerem Kommandozeilenargument -keystore <Keystore-Datei> in folgender Form gestartet werden: qftest -batch -keystore= -daemon -daemonport 12345 Beispiel 25.10: Starten des QF‑Test Daemon ohne SSL Lässt man das Argument -daemonport weg, lauscht der Daemon auf Port 3543. Ob der Daemon erfolgreich gestartet wurde, kann man z. B. mit dem Programm netstat prüfen: netstat -a -p tcp -n | findstr \"12345\" netstat -a --tcp --numeric-ports | grep 12345 Will man den Daemon auf einem entfernten Rechner starten, bieten sich zum Beispiel ssh oder VNC an. Ob und wie das ggf. in Ihrem Netzwerk funktioniert, weiß der Netzwerkadministrator. Um die folgenden Beispiele nachzuvollziehen, reicht aber auch ein lokaler Daemon.","hash":"sec_starten_des_daemons","h1":"Starten des Daemons"},"645":{"id":645,"content":"Steuern des Daemons über die QF‑Test Kommandozeile Die einfachste Möglichkeit, den lauschenden Daemon anzusprechen bietet die Kommandozeile, indem man QF‑Test im sogenannten calldaemon Modus startet. Das folgende Beispiel prüft, ob der Daemon an der angegebenen Host-/Portkombination erreichbar ist: qftestc -batch -calldaemon -daemonhost localhost -daemonport 12345 -ping Beispiel 25.11: Pingen eines QF‑Test Daemon Anders als das obige netstat-Kommando funktioniert -ping auch über Rechnergrenzen hinweg (auf dem lokalen Rechner kann man das Argument -daemonhost einfach weglassen). Auf ähnliche Weise wie man eine Testsuite im Batchmodus ausführt, kann man nun einen Daemon dazu bringen, einen bestimmten Testfall auszuführen und ein Protokoll des Testlaufs zu schreiben: qftest -batch -calldaemon -daemonhost somehost -daemonport 12345 -runlog c:\\mylogs\\+b -suitedir c:\\mysuites suiteA.qft#\"Mein Testfall\" Beispiel 25.12: Ausführung eines Testfalls mit dem QF‑Test Daemon Anders als im Batchmodus wird beim Verwendung eines Daemons ein Testfall oder ein Testfallsatz (andere Knotentypen sind nicht erlaubt) stets über seinen qualifizierten Namen angesprochen, z.B. \"Mein Testfallsatz.Mein Testfall\" (zur Erinnerung: Beim Batchmodus wird -test <ID> verwendet). Will man die komplette Testsuite suiteA.qft ausführen, so lässt man die Angabe des Testfalls einfach weg oder schreibt suiteA.qft#.. Wird der Daemon auf einem entfernen Rechner gestartet, gibt man diesen bei der Ausführung von calldaemon über den Parameter -daemonhost explizit an (Vorgabe ist -daemonhost localhost). Man beachte, dass sich dabei der Parameter -suitedir auf den entfernten Rechner bezieht (auf dem der Daemon läuft), während -runlog eine lokale Datei bezeichnet. Gerade dann, wenn man die Testausführung nicht so leicht beobachten kann, bietet es sich an, zusätzlich das Argument -verbose anzugeben, um so Statusinformationen auf der Konsole angezeigt zu bekommen (auf Windows muss dazu qftestc verwendet werden). Ein Daemon, lokal oder entfernt, lässt sich über das calldaemon Kommando -terminate wieder beenden: qftest -batch -calldaemon -daemonport 12345 -daemonhost localhost -terminate Beispiel 25.13: Beenden eines QF‑Test Daemon Eine vollständige Übersicht über die calldaemon-Parameter finden Sie im Kapitel Kommandozeilenargumente und Rückgabewerte.","hash":"usec_calldaemon","h1":"Steuern des Daemons über die QF‑Test Kommandozeile"},"646":{"id":646,"content":"Steuern des Daemons über die Daemon API Das Ansprechen des Daemons über die QF‑Test Kommandozeile ist auf der einen Seite ganz praktisch, auf der anderen jedoch bietet sie nur eingeschränkte Möglichkeiten. Um die daemonischen Fähigkeiten voll auszureizen, muss man sich der Daemon-API bedienen. Wir werden diese hier beispielhaft vorstellen, die vollständige Schnittstelle ist in \"Daemon-Modus\" beschrieben. Für erste Experimente mit der Daemon-API bietet sich ein Server-Skript Knoten an: from de.qfs.apps.qftest.daemon import DaemonRunContext from de.qfs.apps.qftest.daemon import DaemonLocator host = \"localhost\" port = 12345 # Leading r means raw string to allow normal backslashes in the path string. testcase = r\"c:\\mysuites\\suiteA.qft#Mein Testfall\" timeout = 60 * 1000 def calldaemon(host, port, testcase, timeout=0): daemon = DaemonLocator.instance().locateDaemon(host, port) trd = daemon.createTestRunDaemon() context = trd.createContext() context.runTest(testcase) if not context.waitForRunState(DaemonRunContext.STATE_FINISHED, timeout): # Run did not finish, terminate it context.stopRun() if not context.waitForRunState(DaemonRunContext.STATE_FINISHED, 5000): # Context is deadlocked raise UserException(\"No reply from daemon RunContext.\") rc.logError(\"Daemon call did not terminate and had to be stopped.\") result = context.getResult() log = context.getRunLog() rc.addDaemonLog(log) context.release() return result result = calldaemon(host, port, testcase, timeout) rc.logMessage(\"Result from daemon: %d\" %result) Beispiel 25.14: Daemon-API im Server-Skript Das Skript zeigt den grundlegenden Mechanismus der Daemon-Ansteuerung: Zunächst muss mit locateDaemon ein laufender Daemon gefunden werden. Über den Aufruf von createTestRunDaemon wird eine Umgebung für Testläufe bereitgestellt. Zur eigentlichen Testausführung benötigt man ein Context-Objekt (createContext). Hierzu wird eine (Runtime-)Lizenz benötigt. Über den Context lässt sich der Testlauf starten (runTest) und dessen Zustand abfragen. waitForRunState wartet während der (in Millisekunden) angegebenen Zeitspanne, bis ein bestimmter Zustand eingetreten ist; hier wird eine Minute lang darauf gewartet, dass der Testlauf abschließt. Schließlich, nach Ende des Testlaufs, liefert der Context über die Methode getResult einen Rückgabewert, der Auskunft über das Ergebnis des Testlaufs gibt (vgl. Rückgabewerte von QF‑Test). Darüber hinaus kann man über den Context auch das Protokoll des Testlaufs abholen und mittels der rc-Methode addDaemonLog in das lokale Protokoll einfügen. Das Beispielskript verzichtet aus Gründen der Übersichtlichkeit auf jegliche Fehlerbehandlung. Gerade beim Arbeiten mit einem Daemon sollte man aber jeden Aufruf auf eventuelle Fehler überprüfen. Ein Nachteil ist mit der Daemon-Steuerung aus einem Server-Skript verbunden: Es wird eine zusätzliche QF‑Test Lizenz benötigt, um den Skript-Knoten interaktiv oder im Batchmodus auszuführen. Das gilt allerdings nicht, wenn man den oben beschriebenen calldaemon Modus verwendet oder sich außerhalb von QF‑Test mit dem Daemon verbindet (siehe unten). Die Verwendung der Daemon-API ist nicht auf Server-Skripte beschränkt. Außerhalb von QF‑Test kann der Daemon über ein Java-Programm oder, einfacher noch, ein Groovy-Skript angesprochen werden. Das folgende Groovy-Beispiel arbeitet mit mehreren Daemon-Instanzen und kann daher auch als Ausgangspunkt für Lasttests dienen. Nehmen wir an, dass auf verschiedenen Rechnern jeweils ein QF‑Test Daemon gestartet wurde. Jeder der Daemonen soll einen bestimmten Testfall ausführen und für jeden der Testläufe soll ein Protokoll abgelegt werden (daemon1.qrl, ..., daemonN.qrl). Die Testsuite mit dem auszuführenden Testfall sei allen Daemon-Instanzen über ein Netzlaufwerk (hier z:) zugänglich. import de.qfs.apps.qftest.daemon.DaemonLocator import de.qfs.apps.qftest.daemon.DaemonRunContext def testcase = \"z:\\\\mysuites\\\\suiteA.qft#Mein Testfall\" def logfile = \"c:\\\\mylogs\\\\daemon\" def timeout = 120 * 1000 def keystore = \"z:\\\\mysuites\\\\mydaemon.keystore\" def password = \"strengGeheim\" def locator = DaemonLocator.instance() locator.setKeystore(keystore) locator.setKeystorePassword(password) def daemons = locator.locateDaemons(10000) def contexts = [] // Start tests for (daemon in daemons) { def trd = daemon.createTestRunDaemon() trd.setGlobal('machines', daemons.size().toString()) def context = trd.createContext() contexts << context context.runTest(testcase) } // Wait for tests to terminate for (i in 0..<contexts.size()) { def context = contexts[i] context.waitForRunState(DaemonRunContext.STATE_FINISHED, timeout) byte[] runlog = context.getRunLog() def fos = new FileOutputStream(\"$logfile${i + 1}.qrl\") fos.write(runlog) fos.close() context.release() } Beispiel 25.15: Groovy-Daemon-Skript CallDaemon.groovy Zur Ausführung des Groovy-Skripts werden die QF‑Test Bibliotheken qftest.jar, qfshared.jar und qflib.jar benötigt und außerdem die Groovy-Bibliothek, die auch Bestandteil der QF‑Test Installation ist. Das folgende Befehlsskript zeigt, wie das geht: @echo off setlocal set qftestdir=c:\\programs\\qftest\\qftest-10.0.2-pro set qflibdir=%qftestdir%\\qflib set classpath=%qftestdir%\\lib\\groovy-all.jar set classpath=%classpath%;%qflibdir%\\qftest.jar;%qflibdir%\\qfshared.jar;%qflibdir%\\qflib.jar java -cp %classpath% groovy.ui.GroovyMain CallDaemon Beispiel 25.16: Befehlsskript calldaemon.bat zur Ausführung von Calldaemon.groovy Der DaemonLocator kann beim externen Zugriff den Keystore zur Sicherung der Kommunikation nur automatisch ermitteln, wenn die Datei qftest.jar (wie in diesem Befehlsskript) direkt aus dem QF‑Test Verzeichnis geladen wird. Alternativ kann der Keystore wie im Groovy-Skript gezeigt mit setKeystore und setKeystorePassword direkt gesetzt werden, oder indirekt über die System-Properties javax.net.ssl.keyStore und javax.net.ssl.keyStorePassword. Damit aus dem Daemon-Beispiel ein Lasttest wird (vgl. \"Durchführung von Lasttests mit QF‑Test\"), müssen die Testläufe an mindestens einer Stelle innerhalb von \"Mein Testfall\" synchronisiert werden (z. B. nach dem Starten des SUT). Dazu dient die rc-Methode syncThreads: def machines = rc.getNum('machines') rc.syncThreads('startup', 60000, -1, machines) Beispiel 25.17: Groovy Server-Skript Knoten zur Synchronisation der Testläufe Die Variable machines bezeichnet die Anzahl der Rechner. Sie wird zum Beispiel im Testsuite Knoten mit einem Vorgabewert von 1 definiert. Bei der Ausführung der Testläufe wird sie mit dem aktuellen Wert überschrieben.","hash":"sec_steuern_des_daemons_uber_die_daemon_api","h1":"Steuern des Daemons über die Daemon API"},"647":{"id":647,"content":"Pro Handbuch","hash":"","h0":"Erneute Ausführung von Knoten (Rerun) | QF‑Test Handbuch"},"648":{"id":648,"content":"Pro Handbuch","hash":"home-link","h0":"Erneute Ausführung von Knoten (Rerun) | QF‑Test Handbuch"},"649":{"id":649,"content":"Erneute Ausführung von Knoten (Rerun)","hash":"usec_rerun","h0":"Erneute Ausführung von Knoten (Rerun)"},"650":{"id":650,"content":"Erneute Ausführung aus dem Protokoll Nach einem automatischen Testlauf ist das Protokoll bzw. der erstellte Report dieser Ausführung ein guter Einstiegspunkt um sich ein Bild von den Testergebnissen zu machen. Sind Fehler aufgetreten, stellt sich für Sie als Anwender oft die Herausforderung die fehlgeschlagenen Testfälle nochmals auszuführen, um das Fehlverhalten zu analysieren oder nach einer erfolgten Fehlerbehebung diesen Testfall nochmals offiziell nachzutesten. Eventuelle Nachtestergebnisse könnten bei Bedarf auch im Report angezeigt werden und zwar wahlweise zusätzlich oder an Stelle des fehlerhaften Ergebnisses des vorherigen Laufs. In manchen Fällen kann es auch einfach vom Interesse sein, einige Testfälle nochmals gezielt mit dem Variablenstand vom vorigen Lauf anzustoßen und die vorherigen Protokolle unangetastet zu lassen. Genau hierfür bietet QF‑Test nun die Möglichkeit, direkt aus dem Protokoll heraus Testfälle nochmals auszuführen. Dies erreichen Sie, indem Sie den Protokoll-Knoten oder die gewünschten Testfallsatz Knoten selektieren und die Menüaktion »Testfälle nochmal ausführen« im Menü »Bearbeiten« oder über das Kontextmenü auswählen. Alternativ können sie die Testfälle aus der Fehlerliste über den Kontextmenüeintrag »Testfälle der selektierten Knoten nochmal ausführen« auswählen. Im daraufhin erscheinenden Dialog können Sie die nochmal auszuführenden Testfälle auswählen sowie in der Auswahlbox Protokollmodus bestimmen, ob die Ergebnisse dieser Wiederholung in das originale Protokoll des Laufes eingepflegt werden sollen oder nicht. Es werden folgende Auswahlmöglichkeiten geboten:","hash":"usec_rerun_from_log","h1":"Erneute Ausführung aus dem Protokoll"},"651":{"id":651,"content":"Auswahlmöglichkeit Bedeutung Testfälle ersetzen Im Protokoll werden die Ergebnisse des vorherigen Testlaufes durch die neuen Ergebnisse ersetzt. Die vorherigen Ergebnisse fallen also aus dem Protokoll heraus. Das vorherige Protokoll wird als Sicherungskopie gespeichert und behalten. Protokolle zusammenführen Die neuen Ergebnisse werden in die bestehende Struktur eingefügt. Protokoll anhängen Die neuen Ergebnisse werden zusätzlich an das Originalprotokoll gehängt. Die Testfallsatzstruktur wird nicht berücksichtigt. Protokolle getrennt lassen Die neue Ausführung bekommt ihr eigenes Protokoll. Das Originalprotokoll bleibt unangetastet. Tabelle 25.1: Auswahlmöglichkeiten für die Protokollierung einer Wiederausführung","hash":"table_25.1","h1":"Erneute Ausführung aus dem Protokoll"},"652":{"id":652,"content":"Abbildung 25.1: Dialog zur Wiederausführung von Testfällen Diese wiederholte Ausführung verwendet für jeden Testfall dessen Variablenstände aus dem vorherigen Protokoll. Da dort nur die String-Werte der Variablen gespeichert werden, stehen die Werte der Variablen bei der wiederholten Ausführung aus dem Protokoll auch nur als Zeichenketten zur Verfügung. Die Variable ${qftest:isInRerunFromLog} erhält für eine solche Wiederholung den Wert true, womit im Test zwischen normalem Lauf und Wiederholung unterschieden werden kann. Die Zusammenführung der Protokolle basiert zur Zeit auf den Namen der Testfälle und Testfallsätze. Daher müssen deren Namen eindeutig sein. Im Falle von datengetriebenen Testen sollten Sie darauf achten, dass Sie diese Eindeutigkeit der Namen über die Attribute Name für separates Protokoll bzw. Charakteristische Variablen herstellen.","hash":"figure_25.1","h4":"Abbildung 25.1: Dialog zur Wiederausführung von Testfällen"},"653":{"id":653,"content":"Fehlerhafte Knoten sofort wiederholen Während der Testautomatisierung kann es vorkommen, dass Testschritte sich volatil verhalten und manchmal das richtige Ergebnis liefern aber in anderen Fällen scheitern. Meist sind solche Fälle abhängig vom Timing und können in QF‑Test mit Warten auf Komponente Knoten oder Checks auf Zustände, mit Skripten, Verzögerungen oder Kontrollstrukturen stabilisiert werden. Alternativ oder zusätzlich ermöglicht QF‑Test es Ihnen, solche Knoten im Fehlerfall automatisch nochmals auszuführen. Für die Art der automatischen Ausführung im Fehlerfall können Sie bei jedem ausführbaren Knoten in der Testsuite einen Doctag im Attribut Bemerkung verwenden. Dieser Doctag kann im Wesentlichen wie folgt aussehen: @rerun attempts=3;errorlevel>=ERROR;newerrorlevel=WARNING; handler=handlers.errorhandler Beispiel 25.18: Beispiel für eine Rerun Definition Das obige Beispiel bedeutet, dass ein Knoten im Falle eines Fehlers oder einer Exception maximal dreimal wiederholt wird bis kein Fehler und keine Exception mehr auftreten. Die Versuche, die mit Fehler oder Exception endeten, werden im Protokoll als Warnung markiert und nicht mehr als Fehler. Nach jedem Versuch, der mit Fehler oder Exception endet, wird die Prozedur handlers.errorhandler aufgerufen. Besteht nach dem dritten Versuch immer noch ein Fehler oder eine Exception, so wird dieser letzte Zustand protokolliert. Falls Sie den aktuellen Versuch des Reruns herausfinden möchten, können Sie die Variable reruncounter aus der qftest Variablengruppe verwenden, siehe \"Spezielle Gruppen\". Für das @rerun Doctag können verschiedene Parameter wie attempts oder errorlevel mit folgender Bedeutung verwendet werden: attempts Die maximale Anzahl der Wiederholungen. errorlevel (optional) Gibt an, auf welche Arten von Fehlverhalten reagiert werden soll. Hier können Sie entweder die Fehlerstufen EXCEPTION, ERROR oder WARNING angeben, entweder exakt (mit =) oder mit > oder >=. Mit errorlevel=ERROR wird der Knoten nur bei Fehlern neu ausgeführt wird, bei errorlevel>=ERROR bei Fehlern und Exceptions. Falls Sie nichts angeben wird der Wert errorlevel>=ERROR als Standard herangezogen. newerrorlevel (optional) Legt die Fehlerstufe für die Protokollierung des initialen Laufs und eventueller weiterer fehlgeschlagener Versuche fest. Zulässige Werte sind wiederum EXCEPTION, ERROR oder WARNING sowie zusätzlich NOLOG und KEEP. Die Stufe NOLOG bedeutet, dass die fehlerhaften Versuche aus dem Protokoll gelöscht werden, so dass nur der letzte Versuch im Protokoll auftaucht. Der Wert NOLOG sollte mit großer Vorsicht eingesetzt werden. Der Wert KEEP gibt an, dass die originalen Fehlerstufen im Protokoll behalten werden. Falls Sie nichts angeben wird der Wert WARNING als Standard herangezogen. handler (optional) Definiert den Namen einer Prozedur, welche aufgerufen werden soll, falls das Fehlverhalten auftritt. Diese Prozedur wird nach jedem fehlgeschlagenen Durchlauf ausgeführt. reusevariables (optional, default=true) Hier geben Sie an, ob der Variablenstand vom Beginn des ersten Durchlaufs wiederverwendet werden soll. Steht der Parameter auf false wird der aktuelle Variablenstand genutzt. logmessages (optional, default=true) Ist dieser Parameter auf true gesetzt, wird am Anfang eines jeden Versuchs sowie nach erfolgreicher bzw. fehlerhafter Ausführung eine Nachricht in das Protokoll geschrieben. Zusätzlich wird bei jedem Versuch eine Anmerkung im Protokoll für diesen Knoten gesetzt. logmessagesintoreport (optional, default=true) Ist dieser Parameter und der Parameter logmessages auf true gesetzt, werden die Meldungen auch in den Report geschrieben. keepfirst (optional, default=false) Falls dieser Wert auf true gesetzt wird, wird das erste gefangene Fehlerverhalten mit dem Originalzustand protokolliert. Im Falle von weiteren Fehlern wird der Parameter newerrorlevel herangezogen. exceptiontype (optional) Falls Sie einen speziellen Exceptiontype fangen wollen, können Sie diesen Typ hiermit angeben, z.B. CheckFailedException oder nur ClientNotConnected für eine ClientNotConnectedException. Dieser Parameter sollte nur verwendet werden, wenn Sie Exception als Wert für errorlevel gesetzt haben. Details zu Exceptions finden Sie beim Catch Knoten. exceptionmessage (optional) Falls Sie eine bestimmte Exception mit bestimmter Nachricht abfangen wollen, können Sie diese Nachricht hier angeben. Dieser Parameter sollte nur verwendet werden, wenn Sie Exception als Wert für errorlevel gesetzt haben. Details zu Exceptions finden Sie beim Catch Knoten. exceptionregex (optional) Wenn dieser Wert true ist, dann stellt der Parameter exceptionmessage einen regulären Ausdruck dar. Dieser Parameter sollte nur verwendet werden, wenn Sie Exception als Wert für errorlevel gesetzt haben und einen Wert für exceptionmessage angegeben haben. Details zu Exceptions finden Sie beim Catch Knoten. exceptionlocalized (optional) Wenn dieser Wert true ist, dann steht der Parameter exceptionmessage für die lokalisierte Fehlermeldung der Exception. Dieser Parameter sollte nur verwendet werden, wenn Sie Exception als Wert für errorlevel gesetzt haben und einen Wert für exceptionmessage angegeben haben. Details zu Exceptions finden Sie beim Catch Knoten.","hash":"usec_rerun_node","h1":"Fehlerhafte Knoten sofort wiederholen"},"654":{"id":654,"content":"Pro Handbuch","hash":"","h0":"Verteilte Entwicklung von Tests | QF‑Test Handbuch"},"655":{"id":655,"content":"Pro Handbuch","hash":"home-link","h0":"Verteilte Entwicklung von Tests | QF‑Test Handbuch"},"656":{"id":656,"content":"Verteilte Entwicklung von Tests Die vorhergehenden Kapitel waren alle auf das Erstellen und Bearbeiten einzelner Testsuiten ausgerichtet. Für das Testen von umfangreichen Applikationen ist dies eventuell nicht ausreichend. Es gibt mindestens zwei Szenarios, für die das Aufteilen von Tests in mehrere Testsuiten von entscheidender Bedeutung ist: Mehrere Entwickler arbeiten simultan an der Erstellung von Tests. Um Redundanz zu vermeiden, sollten separat erstellte Testsuiten nach Möglichkeit gemeinsame Prozeduren und Komponenten verwenden. Eine Testsuite kann zu einem bestimmten Zeitpunkt aber immer nur von einer Person bearbeitet werden. Tests werden schlicht und einfach zu groß und unhandlich. Bei ausgedehnten Testläufen reicht eventuell der verfügbare Speicher für Protokolle nicht aus. Eine Testsuite mit einer Vielzahl von Tests kann sehr unübersichtlich werden. Außerdem kann es wünschenswert sein, dass gewisse Tests sowohl als Teil des gesamten Tests, als auch für sich alleine ausgeführt werden können. QF‑Test bietet einige nützliche Hilfsmittel für die verteilte Entwicklung mit deren Hilfe Sie Tests auf mehrere Testsuiten verteilen können. Mehrere Entwickler können damit an einzelnen Teilen von Tests arbeiten und später ihre Entwicklungen koordinieren um die Komponenten ihrer Testsuiten zusammenzuführen und Bibliotheken von gemeinsam genutzten Prozeduren zu erstellen. Dieses Kapitel erläutert zunächst die verschiedenen Mechanismen zur verteilten Entwicklung und deren Zusammenspiel. Der abschließende Abschnitt enthält eine knappe und präzise Schritt-für-Schritt Anleitung, um große Testprojekte mit QF‑Test umzusetzen.","hash":"usec_distributeddevelopment","h0":"Verteilte Entwicklung von Tests"},"657":{"id":657,"content":"Der Aufruf einer Prozedur in einer anderen Testsuite Es ist möglich, Prozeduren und Komponenten außerhalb der aktuellen Testsuite zu referenzieren. Diese Referenzen können explizit oder implizit über Includedateien angegeben werden. Explizite Referenzen verwenden die gleiche Syntax, die auch in URLs zum Einsatz kommt, um eine bestimmte Stelle auf einer Webseite anzuspringen: Der Name der Datei wird, durch ein '#'-Zeichen getrennt, dem Name der Prozedur Attribut eines Prozeduraufruf Knotens oder dem Attribut QF‑Test ID der Komponente eines von einer Komponente abhängigen Knotens vorangestellt. Aus PackagePfad.Prozedur wird somit Suite#PackagePfad.Prozedur Implizite Referenzen bedienen sich des Inkludierte Dateien Attributs des Testsuite Knotens. Kann ein Knoten in der aktuellen Suite nicht ermittelt werden, sucht QF‑Test nach einer passenden Prozedur oder Komponente in allen direkt oder indirekt eingebundenen Testsuiten (eine Testsuite wird als indirekt eingebunden bezeichnet, wenn Sie als Includedatei in einer direkt von der aktuellen Suite eingebundenen Datei aufgeführt ist). Eine Testsuite, die einen Knoten in einer anderen Testsuite referenziert, wird von dieser Testsuite abhängig. Bei einer Änderung des Namens der Prozedur oder der QF‑Test ID der Komponente muss die verweisende Testsuite angepasst werden, ansonsten ist der Bezug falsch und die Testsuite funktioniert nicht mehr richtig. QF‑Test führt solche Anpassungen automatisch durch, sofern es von der Beziehung weiß. Idealerweise sollten beide Testsuiten dem selben Projekt angehören, denn QF‑Test verwaltet automatisch alle Include-Beziehungen und alle expliziten Referenzen innerhalb eines Projekts. Andernfalls muss die aufrufende Suite im Attribut Abhängige Dateien (umgekehrte Includes) des Testsuite Knotens der referenzierten Testsuite aufgeführt sein. Zwar sind implizite Referenzen im Normalfall flexibler und praktischer, es kann damit aber auch schwierig sein, den Überblick zu behalten, wo sich eine referenzierte Prozedur oder Komponente eigentlich befindet. Feststellen kann man dies durch die über das Kontextmenü erreichbaren Funktionen \"Prozedur finden\" (Strg⁠+⁠P) und \"Komponente finden\" (Strg⁠+⁠W). Zusätzlich bietet QF‑Test die Menüeinträge »Operationen«-»Referenzen explizit machen« und »Operationen«-»Referenzen implizit machen«, mit deren Hilfe Sie schnell zwischen den beiden Darstellungen umschalten können, ohne die tatsächlich referenzierten Knoten zu verändern. Im expliziten wie im impliziten Fall kann die referenzierte Testsuite entweder ein relativer oder ein absoluter Dateiname sein. Relative Dateinamen werden zunächst relativ zur aufrufenden Suite aufgelöst. Schlägt dies fehl, werden die Dateien der Bibliothekspfade, die in der Datei qftest.qpj angegeben sind, der Reihe nach durchsucht, siehe \"Die Datei qftest.qpj\". Bei verschachtelten Projekten werden zuerst die Biblothekspfade für das innerste Projekt durchsucht, dann die des jeweils nächstäußeren Projekts. Falls dies auch keinen Treffer ergibt, werden die Dateien in den Bibliothekspfaden durchsucht, die in den Optionen angegeben sind, vgl. \"Verzeichnisse mit Testsuite-Bibliotheken\". Verwenden Sie grundsätzlich - auch unter Windows - das '/'-Zeichen als Verzeichnistrenner. QF‑Test verwendet dann zur Laufzeit das korrekte Trennzeichen für das jeweilige System. Dadurch bleiben die Testsuiten auf verschiedenen Systemen lauffähig. Ihre Package und Prozedur Namen sollten die Zeichen '\\' und '#' nicht enthalten. Wenn doch, müssen diese im Prozeduraufruf geschützt werden. Näheres zu diesem Thema finden Sie in \"Schützen von Sonderzeichen (quoting)\". Wenn Sie die Prozedur für einen Prozeduraufruf oder die Komponente für einen Event in dem Auswahldialog festlegen, bietet QF‑Test alle derzeit geöffneten Testsuiten zur Auswahl an. Wenn Sie eine Prozedur oder eine Komponente aus einer anderen Testsuite selektieren, erzeugt QF‑Test automatisch die korrekte Referenz. Bei einem späteren Ablauf des Tests wird die referenzierte Testsuite gegebenenfalls automatisch nachgeladen, falls sie sich noch nicht im Speicher befindet. Während der Ausführung eines Tests verwaltet QF‑Test alle beteiligten Testsuiten in einem Stapel. Wird eine Prozedur in einer anderen Testsuite aufgerufen, kommt die neue Suite nach oben auf den Stapel. Ist die Prozedur abgearbeitet, wird die Testsuite wieder vom Stapel entfernt. Wann immer während der Ausführung der Prozedur ein Fenster oder eine Komponente über ihre QF‑Test ID angesprochen werden, durchsucht QF‑Test den Stapel der Testsuiten von oben nach unten, d.h. zuerst in der aufgerufenen Suite, dann in der aufrufenden, wobei Includedateien berücksichtigt werden. Dieser Prozess ist nicht unkompliziert und Sie sind gut beraten, Includes nicht zu tief zu verschachteln. Für den Fall dass Sie bei auftretenden Problemen ein tieferes Verständnis für dieses Thema benötigen, finden Sie in \"Auflösen von inkludierten Dateien\" eine ausführliche Erklärung.","hash":"usec_suitereference","h1":"Der Aufruf einer Prozedur in einer anderen Testsuite"},"658":{"id":658,"content":"Die Verwaltung von Komponenten Wie bereits in \"Komponenten\" mehrfach betont wurde, sind die Komponenten der zentrale Bestandteil einer Testsuite. Bei Änderungen am SUT sind diese am ehesten betroffen. Wenn die Änderungen ein solches Ausmaß annehmen, dass QF‑Test sich nicht mehr automatisch darauf einstellen kann, müssen die Komponenten von Hand angepasst werden. Aus diesem Grund sollten Sie bei den Komponenten noch mehr als bei jedem anderen Teil der Tests auf das Vermeiden von Redundanz achten. Wenn Sie Ihre Tests auf mehrere Testsuiten verteilen, sollten Sie daher versuchen, die Komponenten in einer zentralen Testsuite vorzuhalten und diese in den anderen Testsuiten als Includedatei einzubinden. Für sehr große Applikationen kann es sinnvoll sein, die Komponenten Hierarchie in Teile zu zerlegen, die jeweils einen zusammengehörenden Teil der Oberfläche des SUT repräsentieren. Diese zentrale Bibliothek von Komponenten zu verwalten ist nicht trivial. Die dabei auftretenden Probleme können wie folgt mit QF‑Test gelöst werden: Wenn mehrere Entwickler von Tests gleichzeitig neue Komponenten aufnehmen, können diese nicht sofort in die zentrale Suite integriert werden, da immer nur ein Anwender diese gleichzeitig bearbeiten kann. Stattdessen müssen Komponenten später in die zentrale Suite importiert werden, wenn die neuen Tests stabil laufen. Dies wird im folgenden Abschnitt erläutert. Wenn sich das SUT ändert, müssen eventuell Komponenten in der zentralen Suite angepasst werden. Werden dabei QF‑Test IDs von Komponenten geändert, werden dadurch Referenzen auf diese Komponenten aus anderen Testsuiten ungültig. Um das zu vermeiden, passt QF‑Test diese Referenzen automatisch an, vorausgesetzt, die Testsuiten, die von der zentralen Suite abhängen sind im Moment geladen, gehören zum selben Projekt oder sind im Attribut Abhängige Dateien (umgekehrte Includes) des Testsuite Knotens der zentralen Suite aufgeführt.","hash":"usec_manageComponents","h1":"Die Verwaltung von Komponenten"},"659":{"id":659,"content":"Verschmelzen von Testsuiten Testsuiten können durch Importieren einer Testsuite in eine andere miteinander verschmolzen werden. Sie erreichen diese Funktion über den Menüeintrag »Datei«-»Importieren...«. Sie können auswählen, welche Bereiche der Testsuite zusammengeführt werden sollen. Um die Konsistenz von Aufrufen sicherzustellen, sollten Sie auf eine korrekte Konstellation von Includes- und Umgekehrten Includes achten. Mehr zum Arbeiten mit mehreren Testsuiten finden Sie im \"Organisation von Testsuiten\".","hash":"usec_merging","h1":"Verschmelzen von Testsuiten"},"660":{"id":660,"content":"Importieren von Komponenten Beim Importieren von Komponenten werden die beiden Komponentenhierarchien miteinander verschmolzen. Hierfür werden alle Fenster und Komponenten der importierten Suite in die Hierarchie der Komponenten der importierenden Suite eingefügt. Komponenten, die bereits vorhanden sind, werden nicht kopiert. QF‑Test ID Konflikte, zum Beispiel wenn identische Komponenten in beiden Testsuiten verschiedene QF‑Test IDs oder verschiedene Komponenten die selben QF‑Test IDs haben, löst QF‑Test automatisch, indem es die QF‑Test ID der importierten Komponente verändert. Anschließend werden alle Fenster und Komponenten aus der importierten Suite entfernt. Knoten der importierten Suite, die sich auf diese Komponenten bezogen haben, werden automatisch angepasst. Idealerweise sollte die importierte Suite die importierende Suite als Includedatei einbinden, so dass dabei keine expliziten Referenzen entstehen.","hash":"sec_importieren_von_komponenten","h2":"Importieren von Komponenten"},"661":{"id":661,"content":"Importieren von Prozeduren und Testfällen Analog zum Importieren von Komponenten können auch Prozeduren, Packages, Abhängigkeiten und Testfälle sowie Testfallsätze importiert werden, indem Sie 'Prozeduren' oder 'Tests' im Dialog auswählen. Achten Sie allerdings hierbei wieder auf die Konsistenz Ihrer Testsuite, z.B. macht es kaum Sinn, Prozeduren ohne benutzte Komponenten zu importieren. Falls Sie nur eine bestimmte Prozedur oder einen Testfall importieren wollen, so können Sie den 'Einzelimport' Knopf auf den Importdialog auswählen und im erscheinenden Detaildialog den gewünschten Knoten auswählen.","hash":"sec_importieren_von_prozeduren_und_testfallen","h2":"Importieren von Prozeduren und Testfällen"},"662":{"id":662,"content":"Verteilte Entwicklung von Tests Es gibt keinen goldenen Weg, um die Entwicklung von Tests zu organisieren, aber eine Vorgehensweise, die sich bewährt hat, ist die folgende: Beginnen Sie mit einer zentralen Testsuite, welche die nötige Funktionalität zum Starten und Stoppen des SUT sowie einen grundlegenden Satz von Tests und Prozeduren umfasst. Diese Suite wird Ihre Mastersuite, die alle Komponenten enthalten wird. Stellen Sie sicher, dass Ihre Entwickler die Wichtigkeit von setName() verstanden haben und dass, wo erforderlich, eindeutige Namen nach einheitlichem Schema vergeben werden. Wenn setName() nicht verwendet werden kann, setzten Sie ComponentNameResolver ein, um dies zu erreichen (vgl. \"Das NameResolver Interface\"). Sie sollten in der Lage sein, neue Sequenzen ohne viel Aufwand aufzunehmen und ohne dass dabei kleine Änderungen am SUT die Hierarchie der Komponenten völlig durcheinanderbringen. Verlagern Sie möglichst viel Funktionalität in Prozeduren, insbesondere häufig genutzte Sequenzen und die Vorbereitungs- und Aufräumsequenzen für das SUT. Um neue Tests zu erstellen, starten Sie mit einer leeren Testsuite. Binden Sie die Mastersuite über das Attribut Inkludierte Dateien des Testsuite Knotens ein. Erstellen Sie Vorbereitung und Aufräumen Knoten zum Starten und Stoppen des SUT indem Sie die entsprechenden Prozeduren in der Mastersuite aufrufen. Erstellen Sie die erforderlichen Tests. Beim Aufnehmen von Sequenzen werden wenn möglich die Komponenten in der Mastersuite verwendet. Neue Komponenten werden der neuen Suite hinzugefügt, so dass die Mastersuite zu diesem Zeitpunkt nicht angefasst werden muss. Wo möglich, verwenden Sie die Prozeduren der Mastersuite für allgemeine Operationen. Wenn Ihre neuen Tests komplett sind und zufriedenstellend funktionieren, importieren Sie alle erforderlichen Knoten der neuen Testsuite in die Mastersuite. Vor allem sollten Sie die Komponenten importieren. Damit stellen Sie sicher, dass alle Komponente Knoten, die neu aufgenommen wurden, in die Mastersuite integriert werden. Die bestehenden Komponenten der Mastersuite werden dabei nicht verändert, so dass keine anderen von der Mastersuite abhängigen Testsuiten betroffen sind. Nach erfolgtem Komponenten-Import können Sie nun auch alle bzw. einzelne Prozeduren in die Mastersuite importieren. Es gibt jetzt mehrere Möglichkeiten, wie Sie die Sequenzen aus Events und Checks organisieren können, die die eigentlichen Tests bilden. In jedem Fall ist es eine gute Idee, alles in Prozeduren und Packages zu verpacken, die entsprechend Ihrem Testplan strukturiert sind. Danach sollten die Testfallsatz bzw. Testfall Knoten der obersten Ebene in der Mastersuite und der neuen Suite nur noch aus der gewünschten Struktur von Testfallsatz, Testfall, Testschritt und Sequenz Knoten bestehen, welche die Prozeduraufrufe der eigentlichen Testfälle enthalten. Ein solcher Aufbau hat mehrere Vorteile: Alle Tests sind klar strukturiert. Sie können sehr einfach Testläufe von unterschiedlicher Komplexität und Laufzeit zusammenstellen. Sie haben die Möglichkeit, Testfälle in separate Testsuiten auszulagern. Diese \"Test-Bibliotheken\" sollten die Mastersuite als Include Datei einbinden und selbst keine Komponenten enthalten. Damit können Sie die Tests so organisieren, dass Sie wahlweise über die Mastersuite alle Tests, oder nur die einzelnen Testsuiten alleine ausführen können. Die Tests können von verschiedenen Personen unabhängig voneinander gepflegt werden, sofern Änderungen an der Mastersuite miteinander abgestimmt werden. Wenn Sie Ihre neu erstellten Tests in der neuen Testsuite belassen wollen, anstatt sie in die Mastersuite zu übernehmen, sorgen Sie dafür, dass beide Testsuiten zum selben Projekt gehören oder tragen Sie die neue Suite im Abhängige Dateien Attribut des Testsuite Knotens der Mastersuite ein, um QF‑Test explizit auf diese neue Abhängigkeit hinzuweisen. Um einen bestehenden Test zu ändern oder zu erweitern, verfahren Sie nach dem selben Schema. Nehmen Sie zusätzliche Sequenzen nach Bedarf auf, importieren Sie die neuen Komponenten in die Mastersuite. Wenn sich Ihr SUT auf eine Weise ändert, die Anpassungen an den Komponenten erfordert, sollten Sie Ihre Tester koordinieren. Stellen Sie zunächst sicher, dass alle Testsuiten, die die Mastersuite direkt oder indirekt einbinden, zum selben Projekt wie die Mastersuite gehören oder im Attribut Abhängige Dateien des Testsuite Knotens der Mastersuite aufgeführt sind. Wenn bei den Anpassungen QF‑Test IDs von Komponenten geändert werden, muss QF‑Test die abhängigen Testsuiten entsprechend modifizieren. Daher sollten diese zu diesem Zeitpunkt nicht von Anderen bearbeitet werden. Das Dateiformat der Testsuiten von QF‑Test ist XML und damit normaler Text. Dieses Format eignet sich ausgezeichnet zur Verwaltung in Systemen zum Versionsmanagement. Änderungen an einigen QF‑Test ID der Komponente Attributen der abhängigen Testsuiten lassen sich normalerweise problemlos mit anderen Änderungen integrieren, so dass die Koordination der Entwickler bei Einsatz eines solchen Werkzeugs nicht zwingend erforderlich ist. Natürlich kann dieses Schema auch auf mehrere Mastersuites erweitert werden, um verschiedene Teile oder Aspekte einer Applikation zu testen. Dabei kann es sich auszahlen, wenn sich die Komponentenhierarchien dieser Testsuiten möglichst wenig überschneiden, denn dadurch reduziert sich der Pflegeaufwand, wenn sich die grafische Oberfläche des SUT signifikant verändert.","hash":"usec_distributedstepbystep","h1":"Verteilte Entwicklung von Tests"},"663":{"id":663,"content":"Statische Validierung von Testsuiten Im Laufe eines Projektes wird es immer wieder zu Veränderungen, Refactoring oder Löschungen von Knoten in Ihrer Testsuite-Struktur kommen. Sie werden sicher manchmal Prozeduren umbenennen oder diese löschen, falls diese nicht mehr benötigt werden.","hash":"usec_diststaticvalidation","h1":"Statische Validierung von Testsuiten"},"664":{"id":664,"content":"Ungültige Referenzen vermeiden In solchen Fällen ist es äußerst wichtig, dass Sie dabei alle Aufrufe der entsprechenden Prozedur anpassen, um Ihre Testsuiten weiterhin lauffähig zu halten. Für diesen Zweck passt QF‑Test beim Umbenennen oder Verschieben von Knoten alle Referenzen auf Wunsch automatisch an. Wenn Sie nun sicherstellen wollen, dass Ihre Teststruktur keine Verweise auf nicht existierende Prozeduren enthält, können Sie dies mit dem Kommando \"Referenzen analysieren\" bewerkstelligen. Diese statische Validierung wird Ihnen nach einer Analyse auch die Ergebnisse in einem Dialog zeigen, aus dem ersichtlich ist, welche Referenzen noch funktionieren und welche nicht mehr. Sie können diese Analyse starten, indem Sie nach einem Rechtsklick den Menüeintrag »Weitere Knotenoperationen«-»Referenzen analysieren...« oder den entsprechenden Eintrag aus dem Hauptmenü unter »Operationen« auswählen. Diese Validierung ist auch im Batchmodus möglich.","hash":"sec_ungultige_referenzen_vermeiden","h2":"Ungültige Referenzen vermeiden"},"665":{"id":665,"content":"Abbildung 26.1: Ergebnis einer Analyse QF‑Test bietet Ihnen außerdem die Möglichkeit, Ihre Testsuiten auf Duplikate zu überprüfen oder nach leeren Packages oder Prozeduren zu suchen. Es ist auch möglich, Knoten auf ungültige Zeichen in deren Namen zu überprüfen. Diese Art der statischen Validierung ist für Prozeduren, Abhängigkeiten, Testfälle, Testfallsätze und Komponenten und deren Referenzen verfügbar.","hash":"figure_26.1","h4":"Abbildung 26.1: Ergebnis einer Analyse"},"666":{"id":666,"content":"Ungenutzte Prozeduren finden Während der Testentwicklung kann es immer wieder vorkommen, dass Prozeduren, die in früheren Versionen der Tests verwendet wurden, in neueren Version nicht mehr benötigt werden. Wenn Sie solche Prozeduren nicht sofort löschen, kann Ihre Testsuite wachsen. In manchen Fällen könnten Sie hier nun das Gefühl bekommen, dass Sie die Übersicht über die Prozeduren verloren haben könnten. Es gibt nun die Möglichkeit ungenutzte Prozeduren und Abhängigkeit zu finden. Hierfür klicken Sie mit der rechten Maustaste auf Testsuite oder Prozeduren und wählen »Weitere Knotenoperationen«-»Ungenutzte aufrufbare Knoten finden...« aus. Diese Operation liefert nun einen Report über alle ungenutzten Prozeduren und Abhängigkeiten. Jetzt können Sie entscheiden, was Sie damit tun wollen. Manchmal ist es auch vom Vorteil solche ungenutzten Knoten einfach zu löschen, hierfür können Sie im Menü auch »Weitere Knotenoperationen«-»Ungenutzte aufrufbare Knoten entfernen« auswählen.","hash":"usec_find_unused_procedures","h2":"Ungenutzte Prozeduren finden"},"667":{"id":667,"content":"Pro Handbuch","hash":"","h0":"Automatisierte Erstellung von Basisprozeduren | QF‑Test Handbuch"},"668":{"id":668,"content":"Pro Handbuch","hash":"home-link","h0":"Automatisierte Erstellung von Basisprozeduren | QF‑Test Handbuch"},"669":{"id":669,"content":"Automatisierte Erstellung von Basisprozeduren","hash":"usec_procbuilder","h0":"Automatisierte Erstellung von Basisprozeduren"},"670":{"id":670,"content":"Einführung Am Beginn eines typischen QF‑Test Projektes werden die ersten Schritte aufgezeichnet und auch meistens erfolgreich ausgeführt. Nach den ersten Erfolgen und einigen solcher Aufnahmen bemerkt man, dass einfaches Aufnehmen oder ein Kopieren/Einfügen Ansatz einige Probleme bereiten, die Tests wartbar zu halten. Denken Sie nur an eine Änderungen im Haupt-Panel des Workflows. In diesem Fall muss beinahe jeder Test angepasst werden. Wegen solcher Probleme empfehlen wir, die Tests modularisiert zu entwickeln und Prozeduren und Variablen einzusetzen. Für eine genauere Beschreibung modularisierter Testentwicklung siehe \"Prozeduren und Packages\". In Projekten, die eine große Menge an Dialogen und grafischen Elementen beinhalten, ist es mitunter empfehlenswert, solche Prozeduren in komponentenspezifische Prozeduren, z.B. \"Klicke Button OK\", und in eigenständige Workflow Prozeduren, z.B. \"Ein Fahrzeug anlegen\", aufzuteilen. Dieser Ansatz ermöglicht es, dass neue Testfälle relativ schnell angelegt werden können, jedoch müssen vorher diese Basisprozeduren erstellt werden. QF‑Test liefert den Procedure Builder, der genau diese Basisprozeduren automatisiert erstellt. Wenn Sie diesen Procedure Builder verwenden, wird sich die Zeit für Aufnahme und Erstellung der Prozeduren für die grafischen Elemente drastisch verkürzen. Damit kann sich der Tester auf seine eigentliche Aufgabe, Testfälle zu erzeugen und zu planen bzw. Testdaten bereitzustellen, konzentrieren.","hash":"usec_pbIntro","h1":"Einführung"},"671":{"id":671,"content":"Die Verwendung vom Procedure Builder Um die Basisprozeduren automatisiert zu erzeugen, müssen Sie folgende Schritte ausführen: Starten Sie das SUT von QF‑Test aus. Gehen Sie im SUT zum Fenster oder der Komponente, für welche Sie die Basisprozeduren erzeugen wollen. Drücken Sie in QF‑Test den 'Prozeduren erstellen' Knopf, wählen Sie den entsprechenden Menüeintrag aus oder nutzen Sie den Hotkey für Prozedurenaufnahme. Führen Sie einen Rechtsklick auf die entsprechende Komponente im SUT durch. Wählen Sie den entsprechenden Aufnahmemodus aus. Stoppen Sie die Prozedurenaufnahme mittels Klick auf den 'Prozeduren erstellen' Knopf, mittels Auswahl des entsprechenden Menüeintrages in QF‑Test oder über den Hotkey für Prozedurenaufnahme. Nun sollten Sie die neu erstellten Packages unter den Prozeduren Knoten der aktuellen Testsuite, in der Sie die Aufzeichnung gestoppt haben, finden. Diese Packages beinhalten die erstellten Prozeduren für die Komponenten. Standardmäßig wird ein Package procbuilder erzeugt. Falls dieses schon existiert, wird ein Package procbuilder1 erzeugt und so weiter. Wenn Sie dieses Package öffnen, finden Sie weitere Packages für bestimmte Funktionen wie check, get, select, wait etc.. Diese beinhalten die Prozeduren für die Komponenten, welche Sie aufgenommen haben. Unter dem check Package finden Sie noch eine weitere Ebene für unterschiedliche Checkarten. Diese Struktur ist die Standardstruktur, welche Sie allerdings anders konfigurieren können. Eine Beschreibung hierfür finden Sie im nächsten Abschnitt.","hash":"usec_pbHowToUse","h1":"Die Verwendung vom Procedure Builder"},"672":{"id":672,"content":"Abbildung 27.1: Aufgezeichnete Prozeduren","hash":"figure_27.1","h4":"Abbildung 27.1: Aufgezeichnete Prozeduren"},"673":{"id":673,"content":"Konfiguration des Procedure Builder Die Erstellung der Prozeduren wird über eine Template Testsuite gesteuert, diese Testsuite finden Sie unter qftest-10.0.2-pro/include/procbuilderdef.qft. Diese Datei sollte in ein projektspezifisches Verzeichnis kopiert werden, falls Sie diese anpassen möchten. Den Speicherort dieser Datei können Sie dann in den QF‑Test Einstellungen unter Konfigurationsdatei für die Prozedurenaufnahme konfigurieren. Die Template Testsuite beinhaltet Prozedurvorlagen für die am meisten verwendeten GUI Elemente und deren Aktionen. Wenn Sie eine eigene Aktion definieren möchten, können Sie einfach eine entsprechende Prozedur einfügen. Die Testsuite selbst hat eine bestimmte Struktur. Diese Struktur ist im \"Die Procedure Builder Definitionsdatei\" beschrieben. Die Definition erlaubt es den Tester, Prozedurvorlagen für Komponenten einer bestimmten Klasse zu erstellen oder für Prozeduren, die sich auf alle Elemente eines Fenster bzw. Dialoges beziehen, eigene Prozeduren zu definieren. Sie finden auch einige Beispielkonfigurationen unter qftest-10.0.2-pro/demo/procbuilder.","hash":"usec_pbHowPbAdapt","h1":"Konfiguration des Procedure Builder"},"674":{"id":674,"content":"Die Procedure Builder Definitionsdatei Die automatisierte Erstellung der Basisprozeduren liefert je nach Komponenten unterschiedliche Prozeduren. Ein Textfeld benötigt eine Setzen-Methode für den Text, ein Button braucht eine Drück-Methode und ein Fenster benötigt eine Setzen-Methode, die die Setzen-Methoden aller enthaltenen Elemente aufruft etc..","hash":"usec_pbSkeletons","h2":"Die Procedure Builder Definitionsdatei"},"675":{"id":675,"content":"Abbildung 27.2: Die Procedure Builder Definitionsdatei Das oberste Package im Prozeduren Knoten ist der Name des neuerstellen Packages. Der Defaultname hierfür ist procbuilder. Falls das Package procbuilder bereits besteht, wird ein Package procbuilder1 erzeugt usw.. Die nächste Ebene ist die Klassenebene. Hier können Sie ein Package pro Klasse definieren. Das Package benötigt den kompletten Klassenname, wobei jedoch alle '.' durch '_' ersetzt werden, weil Punkte in Packagenamen nicht erlaubt sind. Der Procedure Builder erzeugt die Prozeduren auch für die abgeleiteten Klassen. Falls Ihre Klasse einen '_' beinhalten sollte, dann müssen Sie diesen mit '\\_' kennzeichnen. Die darauffolgenden Ebenen können frei definiert werden, weil diese die Packagestruktur der Prozeduren vorgeben. Am Ende müssen Sie jedoch eine Prozedur definieren, welche die entsprechenden Schritte beinhaltet. Sie können auch einige Variablen, z.B. <COMPID>, in der Definition verwenden. Variablen, z.B. die aktuelle QF‑Test ID der Komponente oder der Komponentenname, können für den Prozedurnamen verwendet werden. Des Weiteren können Sie auf die aktuellen Werte eines Textfeldes oder den aktuellen Status einer Checkbox zugreifen. Es ist sogar möglich, die gesamte Packagestruktur variabel zu gestalten. Für eine Übersicht über alle verwendbaren Variablen siehe \"Die Procedure Builder Definitionsdatei\".","hash":"figure_27.2","h4":"Abbildung 27.2: Die Procedure Builder Definitionsdatei"},"676":{"id":676,"content":"Pro Handbuch","hash":"","h0":"Anbindung an Testmanagementtools | QF‑Test Handbuch"},"677":{"id":677,"content":"Pro Handbuch","hash":"home-link","h0":"Anbindung an Testmanagementtools | QF‑Test Handbuch"},"678":{"id":678,"content":"Anbindung an Testmanagementtools QF‑Test bietet einige pragmatische Ansätze um Testfälle zu verwalten. Sie können eine Übersicht über alle Testfälle generieren oder auch Testfälle in QF‑Test dokumentieren. In größeren Projekten allerdings könnte es Bedarf für ein eigenes Testverwaltungssystem geben, um z.B. den Entwicklungsstatus der einzelnen Tests zu sehen oder die Tests bzw. Ergebnisse mit Anforderungen oder Testfallbeschreibungen zu verbinden. Neben der Testplanung und Testergebnisverwaltung könnte auch ein eigenes Testausführungssystem im Einsatz sein, welches z.B. die Auslastung der Testsysteme während verschiedener Testläufe überwacht. QF‑Test bietet nicht so viele Möglichkeiten wie dererlei spezialisierte Werkzeuge, jedoch verbessert es sich von Version zu Version. Die Integration von QF‑Test in ein solches Testverwaltungssystem ist mittels dem Batch-Modus oder den Daemon-Modus sehr einfach. Für mehr Informationen über Batch bzw. Daemon-Modus, siehe \"Testausführung\". Die folgenden Kapitel beschreiben einige Musterlösungen, welche wir für etablierte Testverwaltungssysteme liefern. Wenn Sie das Testverwaltungssystem, welches Sie im Einsatz haben, nicht finden können, kontaktieren Sie unser Support-Team um Hinweise und Tipps für eine mögliche Integration zu bekommen.","hash":"usec_testmanagement","h1":"Anbindung an Testmanagementtools"},"679":{"id":679,"content":"Pro Handbuch","hash":"","h0":"HP ALM - Quality Center | QF‑Test Handbuch"},"680":{"id":680,"content":"Pro Handbuch","hash":"home-link","h0":"HP ALM - Quality Center | QF‑Test Handbuch"},"681":{"id":681,"content":"HP ALM - Quality Center","hash":"usec_qc","h0":"HP ALM - Quality Center"},"682":{"id":682,"content":"Einführung Die aktuelle Integration von QF‑Test und HP ALM - Quality Center baut auf dem von Quality Center gelieferten VAPI-XP-TEST Typ auf.","hash":"usec_qcIntro","h1":"Einführung"},"683":{"id":683,"content":"Abbildung 28.1: Integration mit ALM - Quality Center Dieser Testtyp ist für den Aufruf von automatisierten Testskripten gedacht. Eine Vorlage für ein VAPI-XP-TEST Skript, welches QF‑Test an Quality Center anbindet, finden Sie in der Datei qcVapiXPTemplate.txt im QF‑Test Installationsverzeichnis, siehe qftest-10.0.2-pro/ext/qualitycenter. Diese Vorlage kann für alle QF‑Test Tests, welche in Quality Center aufgerufen werden, benutzt werden. Eine detaillierte Schritt-für-Schritt Anleitung dazu finden Sie in \"Schritt für Schritt Anleitung\". Die QF‑Test Vorlage für das VAPI-XP-TEST-Skript benutzt ein externes VBScript-Skript qcTemplate.vbs, welches die Ausführung der Tests übernimmt. Dieses Skript ist ebenfalls Bestandteil des Lieferumfangs von QF‑Test (siehe qftest-10.0.2-pro/ext/qualitycenter). Je nach Bedarf sollten Sie dieses Skript anpassen und in ein projektspezifisches Verzeichnis kopieren. Der VAPI-XP-TEST in Quality Center startet QF‑Test im Batchmodus lokal auf jedem einzelnen Testsystem. Dies bedeutet also, dass das externe Skript auf jedem Testsystem verfügbar bzw. erreichbar sein muss und entsprechend müssen auch die Testsuitedateien auf jedem Testsystem verfügbar sein, weshalb wir empfehlen, diese Dateien auf ein gemeinsames Netzlaufwerk zu legen bzw. in Ihr Versionsmanagementsystem aufnehmen. Nach Ausführung des Tests wird das QF‑Test Protokoll als Anhang zur Testinstanz hochgeladen und auch der Status des Tests entsprechend gesetzt. Sie können das externe Skript auch dahingehend ändern, dass anstatt des Batchmodus ein Daemonaufruf (siehe \"Daemon-Modus\") stattfindet. In diesem Fall baut QF‑Test die Verbindung zum Testsystem auf und nicht mehr Quality Center. Im Falle des normalen Batchaufrufes baut Quality Center die Netzwerkverbindung auf und ruft dann lokal QF‑Test auf. Wenn Sie den Daemonaufruf benutzen wollen, dann muss sich das externe Skript auf dem Rechner, auf dem Quality Center installiert ist befinden, jedoch müssen die Testsuitedateien weiterhin auf jedem einzelnen Testsystem erreichbar sein. Falls Sie eine andere unterstützte Skriptsprache als VBScript, z.B. JScript, in Ihrem Projekt einsetzen sollten, können Sie die QF‑Test Vorlagen natürlich in diese Skriptsprache portieren. In der folgenden Abbildung sehen Sie das VAPI-XP-TEST-Skript in Quality Center:","hash":"figure_28.1","h4":"Abbildung 28.1: Integration mit ALM - Quality Center"},"684":{"id":684,"content":"Abbildung 28.2: QF‑Test VAPI-XP-TEST Testfall in HP ALM - Quality Center","hash":"figure_28.2","h4":"Abbildung 28.2: QF‑Test VAPI-XP-TEST Testfall in HP ALM - Quality Center"},"685":{"id":685,"content":"Schritt für Schritt Anleitung Allgemeine Schritte die auf dem Testsystem auszuführen sind: Kopieren Sie das externe Skript qftest-10.0.2-pro/ext/qualitycenter/qcTemplate.vbs in ein projektspezifisches Verzeichnis und ändern Sie dessen Namen. Wir empfehlen Ihnen, auf jedem Testsystem denselben Pfad oder alternativ ein Netzlaufwerk zu verwenden. Innerhalb des externen Skripts können Standardoptionen definiert werden, z.B. ob der Batch- oder Daemon-Modus zu Ausführung verwendet werden soll und wie der Name der Protokolldatei lauten soll. Dies kann aber auch zu einem späteren Zeitpunkt geschehen, was beim initialen Einrichten der Anbindung empfehlenswert sein kann, um die Dinge erst mal überschaubarer zu halten. Schritte in ALM - Quality Center, um einen Beispieltest anzulegen: Starten Sie ALM/Quality Center und loggen Sie sich in Ihr Projekt ein. Im Bereich \"Testplan\" können Sie als ersten Schritt einen neuen Testfallsatz z.B. 'DemoTestSet' anlegen.","hash":"usec_qcStep","h1":"Schritt für Schritt Anleitung"},"686":{"id":686,"content":"Im Bereich \"Testplan\" können Sie als ersten Schritt einen neuen Testfallsatz z.B. 'DemoTestSet' anlegen. Abbildung 28.3: Im Testplan einen neuen Testfallsatz anlegen In diesem Testfallsatz erstellen Sie einen neuen Test vom Typ VAPI-XP.","hash":"figure_28.3","h1":"Schritt für Schritt Anleitung"},"687":{"id":687,"content":"In diesem Testfallsatz erstellen Sie einen neuen Test vom Typ VAPI-XP. Abbildung 28.4: Test vom Typ VAPI-XP-TEST anlegen Im HP VAPI-XP Wizard Fenster drücken Sie einfach ohne Änderungen auf Finish. (Das bedeutet Sie haben VBScript als Skriptsprache und COM/DCOM Server Test als Testtyp).","hash":"figure_28.4","h1":"Schritt für Schritt Anleitung"},"688":{"id":688,"content":"Im HP VAPI-XP Wizard Fenster drücken Sie einfach ohne Änderungen auf Finish. (Das bedeutet Sie haben VBScript als Skriptsprache und COM/DCOM Server Test als Testtyp). Abbildung 28.5: HP VAPI-XP Wizard Der erhaltene Test sieht wie folgt aussieht.","hash":"figure_28.5","h1":"Schritt für Schritt Anleitung"},"689":{"id":689,"content":"Der erhaltene Test sieht wie folgt aussieht. Abbildung 28.6: VAPI-XP-TEST Details Wechseln Sie zum Reiter \"Testskript\" und kopieren Sie den Inhalt der QF‑Test Vorlage qftest-10.0.2-pro/ext/qualitycenter/qcVapiXPTemplate.txt in den Textbereich des Skripteditors.","hash":"figure_28.6","h1":"Schritt für Schritt Anleitung"},"690":{"id":690,"content":"Wechseln Sie zum Reiter \"Testskript\" und kopieren Sie den Inhalt der QF‑Test Vorlage qftest-10.0.2-pro/ext/qualitycenter/qcVapiXPTemplate.txt in den Textbereich des Skripteditors. Abbildung 28.7: Template in Textbereich des Skripts kopieren Im Testskript führen Sie bitte folgende Anpassungen durch: Ändern Sie die pathToModule Variable auf den Pfad, in welchen Sie das externe Skript qcTemplate.vbs kopiert haben. Passen Sie die Variable testSuiteFile entsprechend der zur verwendenden Testsuite an. Wenn Sie einen einzelnen Testfall aus der Testsuitedatei ausführen wollen, passen Sie auch die Variable testCase entsprechend an. Bitte beachten Sie auch die Kommentare in den QF‑Test Vorlagen, in denen Sie Hinweise zu weiteren Einstellungsoptionen finden. Schritte in ALM - Quality Center zum Ausführen des Beispieltests: Wechseln Sie in den Bereich \"Testlabor\" von ALM/Quality Center. Vermutlich werden Sie auch hier einen Testfallsatz anlegen wollen.","hash":"figure_28.7","h1":"Schritt für Schritt Anleitung"},"691":{"id":691,"content":"Vermutlich werden Sie auch hier einen Testfallsatz anlegen wollen. Abbildung 28.8: Neuer Testfallsatz im Testlabor Fügen Sie dort den im vorigen Teil erstellten VAPI-XP-TEST durch passendes Auswählen zur Ausführung hinzu.","hash":"figure_28.8","h1":"Schritt für Schritt Anleitung"},"692":{"id":692,"content":"Fügen Sie dort den im vorigen Teil erstellten VAPI-XP-TEST durch passendes Auswählen zur Ausführung hinzu. Abbildung 28.9: Test zu Ausführung hinzufügen Nun können Sie den Test starten. Achten Sie darauf, dass Sie das Häkchen bei \"Alle Tests lokal ausführen\" setzen, außer Sie haben bereits ein verteiltes System eingerichtet.","hash":"figure_28.9","h1":"Schritt für Schritt Anleitung"},"693":{"id":693,"content":"Nun können Sie den Test starten. Achten Sie darauf, dass Sie das Häkchen bei \"Alle Tests lokal ausführen\" setzen, außer Sie haben bereits ein verteiltes System eingerichtet. Abbildung 28.10: Ausführung des Tests Quality Center sollte nun den Test ausführen - ggf. auf Ihrem Rechner, dann taucht das SUT auf, Aktionen werden durchgeführt und das SUT wird wieder beendet. Nach dem Beenden wird das Resultat für den Testlauf eingetragen: Passed oder Failed.","hash":"figure_28.10","h1":"Schritt für Schritt Anleitung"},"694":{"id":694,"content":"Quality Center sollte nun den Test ausführen - ggf. auf Ihrem Rechner, dann taucht das SUT auf, Aktionen werden durchgeführt und das SUT wird wieder beendet. Nach dem Beenden wird das Resultat für den Testlauf eingetragen: Passed oder Failed. Abbildung 28.11: Testresultat Nachdem der Test ausgeführt wurde, wird das Protokoll des Testlaufs als Anhang zur Testinstanz hochgeladen und der Status des Testfalles auf das entsprechende Resultat gesetzt. Zusätzlich zum Ergebnis wird auch das QF‑Test Protokoll in Quality Center hochgeladen und beim Testlauf abgelegt. Um das Protokoll anzusehen, führen Sie einen Doppelklick auf den Test im Ausführungsbereich aus, wechseln Sie dann auf \"Läufe\" und klicken nochmals doppelt auf die Büroklammer (Anhangssymbol) des entsprechenden Testlaufs.","hash":"figure_28.11","h1":"Schritt für Schritt Anleitung"},"695":{"id":695,"content":"Zusätzlich zum Ergebnis wird auch das QF‑Test Protokoll in Quality Center hochgeladen und beim Testlauf abgelegt. Um das Protokoll anzusehen, führen Sie einen Doppelklick auf den Test im Ausführungsbereich aus, wechseln Sie dann auf \"Läufe\" und klicken nochmals doppelt auf die Büroklammer (Anhangssymbol) des entsprechenden Testlaufs. Abbildung 28.12: Hochgeladenes Protokoll","hash":"figure_28.12","h1":"Schritt für Schritt Anleitung"},"696":{"id":696,"content":"Fehlersuche Als ersten müssen wir vorausschicken, dass wir selbst keine Quality Center Experten sind. Deshalb mag es weitere und bessere Wege zu Fehlersuche geben. Trotzdem wollen wir die Methoden, die wir selbst angewendet haben, hier beschreiben. Leider ist die Prozessausgabe während der Testausführung nur für wenige Sekunden sichtbar und erlaubt somit keine direkte Analyse. Deshalb muss man eine Alternative suchen. Der Texteditor des VAPI-XP-TEST-Testknotens im Bereich \"Testplan\" erlaubt das direkte Ausführen des Skripts. Die Ausgabe ist dann permanent im Bereich unter dem Skript sichtbar und enthält hoffentlich etwas hilfreiches.","hash":"usec_qcHelp","h1":"Fehlersuche"},"697":{"id":697,"content":"Abbildung 28.13: Skript Debuglauf Die direkte Ausführung eines Skripts muss jedoch mit Vorsicht betrachtet werden. Es handelt sich ja nicht um einen echten Testlauf. Deshalb kann auch das Protokoll nicht hochgeladen werden und es wird ein entsprechender Run-time error \"Objekt erforderlich\" ausgegeben. Davon sich also bitte nicht verwirren lassen! Für weiteres Debugging kann man zusätzliche Ausdrücke der der Form TDOutput.Print \"Some text\" in die Skripte und auch das externe Skript einbauen. Mit diesen kann man sehen, wie weit die Ausführung des Skripts funktioniert und wo ggf. ein Fehler auftritt. Der Skripteditor hat auch einen \"Syntax check\" Button, der hilfreich zur Prüfung nach jeder Änderung eingesetzt werden kann.","hash":"figure_28.13","h4":"Abbildung 28.13: Skript Debuglauf"},"698":{"id":698,"content":"Pro Handbuch","hash":"","h0":"Imbus TestBench | QF‑Test Handbuch"},"699":{"id":699,"content":"Pro Handbuch","hash":"home-link","h0":"Imbus TestBench | QF‑Test Handbuch"},"700":{"id":700,"content":"Imbus TestBench","hash":"usec_testbench","h0":"Imbus TestBench"},"701":{"id":701,"content":"Einführung Die aktuelle Integration von QF‑Test und der TestBench der Firma Imbus besteht aus zwei Teilen: Generieren von QF‑Test Vorlagen-Testsuiten aus den TestBench Interaktionen. Importieren der QF‑Test Resultate in die TestBench. Sie finden alle benötigten Testsuiten sowie Demoimplementierungen im Ordner qftest-10.0.2-pro/ext/testbench/Version_1.1_TestBench_2.3. Bitte achten Sie darauf, dass Sie alle Testsuiten vor dem eigentlichen Einsatz in einen projektspezifischen Ordner kopieren und diese dort modifizieren. Das folgende Kapitel gibt einen Überblick über das Konzept der Integration.","hash":"usec_itbIntro","h1":"Einführung"},"702":{"id":702,"content":"Generieren von QF‑Test Vorlage-Testsuiten aus den Interaktionen Nachdem Sie den Testfall in der TestBench geplant und die entsprechenden Interaktionen angelegt haben, können Sie mittels des QF‑Test Export Plug-ins eine QF‑Test Datei generieren. Imbus liefert die erforderlichen Informationen, wie Sie dieses Plugin einspielen müssen. In dieser QF‑Test Datei finden Sie alle Interaktionen als Prozeduren. Ihre Struktur wird durch Packages abgebildet. Nun können Sie mit der Aufnahme der einzelnen Interaktionen beginnen und die Prozeduren mit Leben füllen. Nach Fertigstellung der Aufnahme speichern Sie diese Testsuite in einem projektspezifischen Ordner ab. Diese Datei muss später bei der Ausführung in der Ausführungstestsuite inkludiert werden, um so die Interaktionen ausführen zu können. Wir empfehlen diese Datei entweder in das Versionsmanagementsystem mitaufzunehmen oder auf ein Netzlaufwerk zu legen.","hash":"usec_itbExport","h1":"Generieren von QF‑Test Vorlage-Testsuiten aus den Interaktionen"},"703":{"id":703,"content":"Importieren der Resultate Für die Ausführung der Tests benötigen Sie spezielle Testfälle und Prozeduren, welche Sie in den mitgelieferten Testsuiten finden können. Diese befinden sich im Ordner qftest-10.0.2-pro/ext/testbench/Version_1.1_TestBench_2.3/suite. Bitte achten Sie darauf, dass Sie alle Testsuiten vor dem eigentlichen Einsatz in einen projektspezifischen Ordner kopieren und diese dort modifizieren. Sie finden im Ordner qftest-10.0.2-pro/ext/testbench/Version_1.1_TestBench_2.3/suite/demo eine Beispielimplementierung für den CarConfigurator. Hier ist es wichtig, dass Sie eine Testsuite benötigen, die die Testsuite TestBench_Automation.qft inkludiert. Falls Sie Ihre Prozeduren über den iTEP Export erstellt haben (siehe auch \"Generieren von QF‑Test Vorlage-Testsuiten aus den Interaktionen\"), sollten sie auch diese Testsuite inkludieren. Nun sollten sie noch die Konfiguration der Ausgabedateien in den Dateien testaut.properties und user.properties vornehmen. Jetzt können Sie den Testfall Standalone test executor aus TestBench_Automation.qft aufrufen. Nach der Testausführung können Sie die gesamten Ergebnisse in die TestBench importieren. Verwenden Sie dazu das iTEP bzw. das iTORX Import Plug-in. Die einzelnen QF‑Test Protokolle werden zusätzlich an die Testinstanzen angehängt.","hash":"usec_itbExec","h1":"Importieren der Resultate"},"704":{"id":704,"content":"Pro Handbuch","hash":"","h0":"QMetry | QF‑Test Handbuch"},"705":{"id":705,"content":"Pro Handbuch","hash":"home-link","h0":"QMetry | QF‑Test Handbuch"},"706":{"id":706,"content":"QMetry","hash":"usec_qmetry","h0":"QMetry"},"707":{"id":707,"content":"Einführung Die aktuelle Integration zwischen QF‑Test und QMetry beinhaltet die Unterstützung der Planung von Testfällen bzw. Testschritten innerhalb von QMetry und anschließend die Weiterleitung der Ausführungsinformationen an QF‑Test. Nachdem QF‑Test die Tests ausgeführt hat, werden das Protokoll und der HTML-Report in den Testergebnisbereich von QMetry hochgeladen sowie der Status des Testfalles auf das entsprechende Ergebnis gesetzt. Für die Testausführung müssen Sie Ihr Testsystem wie folgt vorbereiten: Im 'Admin'-Bereich der QMetry-Testmanagement-Ansicht, müssen Sie einen Ausführungsagenten in den 'Agent'-Einstellungen einrichten. Laden Sie die entsprechenden Agentendateien sowie die Konfigurationsdateien auf Ihr Testsystem. Installieren Sie den QF‑Test QMetry Launcher auf Ihrem Testsystem. Installieren Sie eine Testplattform in den 'Platform'-Einstellungen, der ebenfalls im 'Admin'-Bereich zu finden ist. Setzen Sie in der Datei QMetryAgent.properties die benötigten Umgebungsvariablen für den QF‑Test Wrapper von QMetry. Setzen Sie in der Datei QMetryConfig.properties den korrekten und vollständigen Pfad zur QF‑Test Ausführungsdatei. Setzen Sie in der Datei QMetryConfig.properties ggf. erwünschte Ausführungsparameter, siehe auch nächsten Abschnitt. Starten Sie den QMetry Agenten. Unter Windows sollten Sie den Agenten nicht als Dienst / Service starten, damit das SUT nicht in der Service-Session läuft. Falls Sie den Agenten doch als Service starten möchte, dann müssen Sie die QF‑Test Tests mittels QF‑Test Daemon ausführen, welcher wiederum nicht als Dienst gestartet werden darf. Nachdem Sie den QMetry Agenten und Launcher konfiguriert haben, müssen Sie die Testausführung planen. Für die Testausführung von QF‑Test Testfällen gibt es mehrere Varianten in QMetry. Sämtliche Varianten sind im QMetry IntegrationGuide für QF‑Test beschrieben. Für die schnellste Variante gehen Sie wie folgt vor: In der Testmanagement Ansicht wechseln Sie in den 'Test Cases' Bereich und erstellen die Testfälle dort. Bei jedem Testfall müssen Sie im Attribut 'Test Script Name' den vollständigen Pfad zur benötigten QF‑Test Testsuite setzen. Der Name des Testfalles sollte genau dem vergebenen QF‑Test ID Attribut in QF‑Test entsprechen. Fügen Sie den Testfall zu einer ausführbaren Testsuite in der 'Test Suites' Ansicht hinzu. Nun können Sie die Testfälle ausführen: Öffnen Sie die 'Test Suites' Ansicht und selektieren die auszuführende Testsuite. Wählen Sie den 'Execute TestSuite' Reiter. Starten Sie direkt oder planen Sie die Ausführung eines Testlaufes mittels Klick in die 'Automation' Spalte. Wählen Sie dort auch den entsprechenden Agenten aus. Wenn der QMetry Agent das nächste Mal die Ausführungsinformationen vom QMetry Server abholt, wird die Ausführungsinformation des Testfalles an den QMetry Agenten gesandt. Nach Beendigung des Testlauf wird das QF‑Test Protokoll und der HTML-Report als Resultat im Reiter 'Execution History' der ausgeführten Testsuite in QMetry hochgeladen und der entsprechende Status des Testlaufes gesetzt. Die unten stehende Abbildung zeigt den 'Execution History' Reiter in der 'Test Suites' Ansicht inkl. QF‑Test Protokoll:","hash":"usec_qmetryIntro","h1":"Einführung"},"708":{"id":708,"content":"Die unten stehende Abbildung zeigt den 'Execution History' Reiter in der 'Test Suites' Ansicht inkl. QF‑Test Protokoll: Abbildung 28.14: QF‑Test Protokoll in QMetry Sie finden detaillierte Informationen sowie weitere Varianten für die QF‑Test Integration im Handbuch und IntegrationGuide Dokument von QMetry.","hash":"figure_28.14","h1":"Einführung"},"709":{"id":709,"content":"Demokonfiguration Beispiel Für eine einfache Integration empfehlen sich folgende Einstellungen in der Datei QMetryConfig.properties: Setzen Sie den Wert von generic.adapter.success.code auf 0,1. Setzen Sie qftest.additional.arguments auf -test ${QMTestCaseName} im Falle einer lokalen Ausführung. Im Falle einer Ausführung per QF‑Test Daemon, setzen Sie qftest.additional.arguments auf -test ${QMTestCaseName} -calldaemon -daemonhost <Ihr-Testrechner> -daemonport <Ihr-DaemonPort> . Wie bereits im vorigen Kapitel erwähnt, muss bei dieser Integrationsvariante der Name des Testfalles in QMetry den Wert des QF‑Test ID Attributes des Testfall Knotens in QF‑Test entsprechen. Weitere Varianten der Integration zwischen QMetry und QF‑Test finden Sie im Integrationguide Dokument von QMetry.","hash":"usec_qmetryDemoSettings","h1":"Demokonfiguration Beispiel"},"710":{"id":710,"content":"Pro Handbuch","hash":"","h0":"Klaros | QF‑Test Handbuch"},"711":{"id":711,"content":"Pro Handbuch","hash":"home-link","h0":"Klaros | QF‑Test Handbuch"},"712":{"id":712,"content":"Klaros","hash":"usec_klaros","h0":"Klaros"},"713":{"id":713,"content":"Einführung Klaros ist ein Testmanagementtool, das von der Firma verit Informationssysteme GmbH, Kaiserslautern, Deutschland entwickelt und vertrieben wird. Klaros ist in zwei Editionen erhältlich, einer freien Community-Edition und einer Enterprise-Edition mit einen erweiterten Funktionsumfang, individuellen Konfigurationsmöglichkeiten und umfassenden Support. Die aktuelle Integration von QF‑Test mit Klaros umfasst: Import von QF‑Test Ergebnissen in Klaros.","hash":"usec_klarosIntro","h1":"Einführung"},"714":{"id":714,"content":"Importieren von QF‑Test Ergebnissen in Klaros Nach dem Erzeugen eines XML-Reports, wie in \"Reports und Testdokumentation\" beschrieben, kann dieser in Klaros importiert werden. Ein Beispiel für eine QF‑Test Import-URL könnte wie folgt aussehen, wobei die Ergebnisdatei im HTTP-Request Body enthalten ist. http://localhost:18080/klaros-web/seam/resource/rest/importer?config=P00001&env=ENV00001&sut=SUT00001&type=qftest&time=01.03.2011_12:00&username=me&password=secret Beispiel 28.1: Importieren von Testergebnissen in Klaros Das curl-Kommandozeilenprogramm kann auf Linux und Windows/Cygwin den Import direkt anstoßen. curl -v -H \"Content-Type: text/xml\" -T \"my_qftest_report.xml\" \\ \"http://localhost:18080/klaros-web/seam/resource/rest/importer?config=P00001&env=ENV00001&sut=SUT00001&type=qftest&time=05.02.2013_12:00&user=me&password=secret\" Beispiel 28.2: Importieren von Testergebnissen in Klaros mit Hilfe des curl-Kommandos Weitere Informationen finden Sie im Klaros Online-Handbuch unter https://www.klaros-testmanagement.com/files/doc/html/User-Manual.Import-Export.html.","hash":"usec_klarosImport","h1":"Importieren von QF‑Test Ergebnissen in Klaros"},"715":{"id":715,"content":"Pro Handbuch","hash":"","h0":"TestLink | QF‑Test Handbuch"},"716":{"id":716,"content":"Pro Handbuch","hash":"home-link","h0":"TestLink | QF‑Test Handbuch"},"717":{"id":717,"content":"TestLink","hash":"usec_testlink","h0":"TestLink"},"718":{"id":718,"content":"Einführung Die aktuelle Integration von QF‑Test und dem Opensource Tool TestLink besteht aus zwei Teilen: Generieren von QF‑Test Vorlagen-Testsuiten aus den geplanten Testfällen in TestLink. Importieren der QF‑Test Resultate als TestLink Resultate. Seit TestLink 1.9.4 kann die TestLink API für die Integration verwendet werden. Diese Art der Integration benötigt einen gültigen Development-Schlüssel. Dieser kann in den Einstellungen von TestLink unter 'Meine Einstellungen' im Bereich 'API Schnittstelle' erzeugt werden. Hierfür klicken Sie einfach auf den Button 'Neuen Schlüssel erzeugen'. Für ältere TestLink Versionen bis 1.9.3 wird für die Integration direkt auf die Datenbank von TestLink zugegriffen. Diese Technik erfordert einen JDBC Datenbanktreiber, damit die mitgelieferten Skripte verwendet werden können. Die Datenbanktreiber finden Sie auf den Internetseiten der jeweiligen Datenbankhersteller und können diese dort auch herunterladen. Das Exportieren der geplanten Testfälle, mitsamt Testschritten, aus TestLink unterstützt den Testautomatisierer den Testfall wie geplant zu implementieren. Das Importieren der Testresultate nach TestLink erlaubt eine bessere Übersicht über die ausgeführten automatischen und manuellen Tests mit einem Werkzeug. Testresultate können Sie auch unabhängig vom Export von QF‑Test in TestLink importieren, hierfür sollten Sie allerdings beachten, dass im Namen der Testfälle in QF‑Test immer die ID des Testfalles von Testlink im Namen steht. Ein Testfall sollte nach folgendem Schema benannt werden: <TestLink-ID>: Name des Testfalles.","hash":"usec_testlinkIntro","h1":"Einführung"},"719":{"id":719,"content":"Generieren von QF‑Test Vorlagen-Testsuiten aus den Testfällen Um eine einheitliche Struktur von automatisierten Testfällen in QF‑Test und der Testplanung in TestLink sicher zu stellen, bietet QF‑Test die Möglichkeit, Testsuite Dateien mit derselben Struktur wie innerhalb eines Testprojektes von TestLink zu generieren. In dieser QF‑Test Datei finden Sie einen Testfall Knoten pro Testfall und einen Testfallsatz Knoten pro Testsuite aus TestLink. Falls Sie die Felder \"Auszuführende Schritte\" und \"Erwartetes Resultat\" eines Testfalles ausgefüllt haben, wird auch ein leerer Testschritt pro auszuführenden Schritt in den jeweiligen Testfällen angelegt. Das erwartete Resultat finden Sie im Bemerkung Attribut des Testschritt Knotens. Diese Vorlagen-Testsuite muss der Testautomatisierer nun mit entsprechenden Leben füllen, indem er die erstellten Testschritte mit den benötigten Prozeduraufrufen und Aufzeichnungen füllt. Falls Sie mit TestLink 1.9.4 oder einer neueren Version arbeiten, führen Sie bitte folgende Schritte durch: Stellen Sie sicher, dass Testautomatisierung in TestLink eingeschaltet ist. Dafür setzen Sie in der Konfigurationsdatei config.inc.php den Wert enable_test_automation auf ENABLED. Kopieren Sie das Verzeichnis qftest-10.0.2-pro/ext/testlink/api in einen projektspezifischen Ordner. Öffnen Sie dort das Startskript, welches Sie verwenden möchten, mit einem Texteditor, d.h. exportTests.bat für Windows bzw. exportTests.sh für Linux. Passen Sie dort die Pfade für die Variablen JAVA, QFTDIR und TESTLINKINTEGRATOR an. Öffnen Sie die Datei TestLinkUserSpecifics.py mit einem Texteditor. Passen Sie die Variablen serverurl und devkey entsprechend an. Falls Sie benutzerdefinierte Felder aus TestLink in den Export mit einbeziehen wollen, passen Sie auch die Variable custom_fields an. Rufen Sie nun das angepasste Exportskript, wie im Beispiel unten, auf. exportTests.bat --testproject projectname --targetsuite /path/to/testsuite.qft Beispiel 28.3: Beispielaufruf für das Exportieren von Testfällen ab 1.9.4 Falls Sie Testfälle für eine Version bis TestLink 1.9.3 exportieren möchten, führen Sie bitte folgende Schritte durch: Kopieren Sie das Verzeichnis qftest-10.0.2-pro/ext/testlink/export in einen projektspezifischen Ordner. Öffnen Sie dort das Startskript, welches Sie verwenden möchten, mit einem Texteditor, d.h. exportTestLinkToQFT.bat für Windows bzw. exportTestLinkToQFT.sh für Linux. Passen Sie dort die Pfade für die Variablen JAVA, QFTDIR und TESTLINKINTEGRATOR an. Öffnen Sie nun die Datei TestLinkDBIntegrator.py mit einem Texteditor. Passen Sie dort die Variablen dbdriver, conncetionstr, dbuser und dbpass entsprechend Ihrer Datenbank an. Falls Sie benutzerdefinierte Felder aus TestLink in den Export mit einbeziehen wollen, passen Sie auch die Variable custom_fields an. Rufen Sie nun das angepasste Exportskript, wie im Beispiel unten, auf. exportTestLinkToQFT.bat --testproject projectname --targetsuite /path/to/testsuite.qft Beispiel 28.4: Beispielaufruf für das Exportieren von Testfällen bis 1.9.3","hash":"usec_testlinkExport","h1":"Generieren von QF‑Test Vorlagen-Testsuiten aus den Testfällen"},"720":{"id":720,"content":"Ausführung der Testfälle Die Ausführung der Testfälle kann wie gewohnt stattfinden. Sie sollten allerdings einen XML-Report erstellen, wenn Sie die Resultate nach TestLink laden wollen. Wichtig ist hierfür der Parameter '-report.xml' bei der Testausführung. Beim Erstellen des Reports über das GUI sollte die Checkbox 'XML Report erstellen' angehakt sein. Falls Sie Ihre Testfälle nicht aus TestLink exportiert haben, sollten Sie die TestLink-ID in die Namen der QF‑Test Testfälle mitaufnehmen. Ein Testfall sollte nach folgendem Schema benannt werden: <TestLink-ID>: Name des Testfalles. qftest -batch -report.xml reportFolder testsuite.qft Beispiel 28.5: Beispielausführung um XML-Reports zu erzeugen","hash":"usec_testlinkExec","h1":"Ausführung der Testfälle"},"721":{"id":721,"content":"Importieren der QF‑Test Resultate nach TestLink Nach Erstellen der XML-Reportdatei können Sie diese Resultate nun nach TestLink hochladen. Standardmäßig wird für jede Ausführung ein neuer Build in TestLink angelegt. Die TestLink-Buildnummer wird aus der Run-ID des Reports gebildet. Diese können Sie bei Bedarf mit der Option '-runid' bei der Testausführung überschreiben. Allerdings können Sie den Buildnamen auch mit der Option '-build' beim Importieren der Resultate setzen. Falls Sie TestLink 1.9.4 oder neuer verwenden, führen Sie bitte folgende Schritte durch: Stellen Sie sicher, dass Testautomatisierung in TestLink eingeschaltet ist. Dafür setzen Sie in der Konfigurationsdatei config.inc.php den Wert enable_test_automation auf ENABLED. Kopieren Sie das Verzeichnis qftest-10.0.2-pro/ext/testlink/api in einen projektspezifischen Ordner. Öffnen Sie das Startskript, welches Sie verwenden möchten, mit einem Texteditor, d.h. importResults.bat für Windows bzw. importResults.sh für Linux. Passen Sie dort die Pfade für die Variablen JAVA, QFTDIR und TESTLINKINTEGRATOR an. Öffnen Sie die Datei TestLinkUserSpecifics.py mit einem Texteditor. Passen Sie die Variablen serverurl und devkey entsprechend an. (Falls Sie dies bereits für den Export gemacht haben, können Sie dieselben Werte verwenden.) Führen Sie das angepasste Importskript, wie im unten stehenden Beispiel, aus. importResults.bat --testproject projectname --resultfile qftestReport.xml --testplan testplanname --platform system1 Beispiel 28.6: Importieren der Resultate ab 1.9.4 Falls Sie einen Build gezielt überschreiben wollen, können Sie dies mit dem -build Parameter erreichen. importResults.bat --testproject projectname --resultfile qftestReport.xml --testplan testplanname --platform system1 --build myBuild Beispiel 28.7: Importieren der Resultate ab 1.9.4 mit eigenem Build Falls Sie mit TestLink 1.9.3 oder einer älteren Version arbeiten, führen Sie bitte folgende Schritte durch: Kopieren Sie das Verzeichnis qftest-10.0.2-pro/ext/testlink/import in einen projektspezifischen Ordner. Öffnen Sie das Startskript, welches Sie verwenden möchten, mit einem Texteditor, d.h. importToTestLink.bat für Windows bzw. importToTestLink.sh für Linux. Passen Sie dort die Pfade für die Variablen JAVA, QFTDIR und TESTLINKINTEGRATOR an. Öffnen Sie nun die Datei ReportParser.py mit einem Texteditor. Passen Sie dort die Variablen dbdriver, conncetionstr, dbuser und dbpass entsprechend Ihrer Datenbank an. Erstellen Sie bei der Ausführung der QF‑Test Tests einen XML-Report mit dem Parameter '-report.xml' und wahlweise auch mit einer eigenen Run-ID mit der Option '-runid'. Führen Sie das angepasste Importskript, wie im unten stehenden Beispiel, aus. importToTestLink.bat --testproject projectname --resultfile qftestReport.xml --testplan testplanname --tester tester Beispiel 28.8: Importieren der Resultate bis 1.9.3","hash":"usec_testlinkImport","h1":"Importieren der QF‑Test Resultate nach TestLink"},"722":{"id":722,"content":"Pro Handbuch","hash":"","h0":"Integration mit Entwickler-Tools | QF‑Test Handbuch"},"723":{"id":723,"content":"Pro Handbuch","hash":"home-link","h0":"Integration mit Entwickler-Tools | QF‑Test Handbuch"},"724":{"id":724,"content":"Integration mit Entwickler-Tools Automatisierte GUI-Tests sind nur ein Schritt im Erstellungsprozess eines Software-Entwicklungsprojektes. Die grundlegende Anforderung, den Ablauf aller erforderlichen Schritte (Kompilierung, Testen, Erzeugung von Dokumentation, Auslieferung) zu automatisieren, hat zu einer Vielzahl von Entwickler-Tools (z.B. Eclipse) und Build-Tools (z.B. make, ant, maven) und so genannten Continuous-Integration-Tools geführt (z.B. Jenkins, Cruise Control, Continuum). Generell sollte die Integration mit solchen Werkzeugen durch Verwendung der Kommandozeilen-Schnittstelle von QF‑Test, die in \"Testausführung\" und \"Kommandozeilenargumente und Rückgabewerte\" ausführlich dokumentiert ist, ohne Schwierigkeiten möglich sein. GUI Tests benötigen eine aktive Benutzersession um korrekt ausgeführt werden zu können. Sie finden im Kapitel Aufsetzen von Testsystemen nützliche Tipps und Tricks für die Einrichtung Ihrer Testsysteme. Der technische Hintergrund ist in FAQ 14 beschrieben. Die folgenden Abschnitte enthalten Beispiele für Integrationen mit einigen der oben genannten Tools.","hash":"usec_buildtools","h1":"Integration mit Entwickler-Tools"},"725":{"id":725,"content":"Pro Handbuch","hash":"","h0":"Eclipse | QF‑Test Handbuch"},"726":{"id":726,"content":"Pro Handbuch","hash":"home-link","h0":"Eclipse | QF‑Test Handbuch"},"727":{"id":727,"content":"Eclipse Eclipse (http://eclipse.org) ist eine Open Source Entwicklungsumgebung zur Erstellung von Java-Applikationen. QF‑Test bietet mit dem Eclipse Plugin die Möglichkeit, während der Entwicklung einer Java-Applikation diese aus Eclipse heraus zu starten und Tests darauf auszuführen. Dabei können beliebige QF‑Test Knoten gestartet werden: z.B. ganze Testfallsätze, einzelne Testfälle oder auch nur ein Mausklick. Video-Anleitung: 'Das QF‑Test Eclipse Plugin'","hash":"usec_eclipseplugin","h0":"Eclipse"},"728":{"id":728,"content":"Installation Für die Installation des Eclipse Plugins kopieren Sie bitte die Datei de.qfs.qftest_10.0.2-pro.jar aus dem Unterverzeichnis qftest-10.0.2-pro/misc/ des QF‑Test Installationsverzeichnisses in das Unterverzeichnis \"dropins\" des Eclipse Installationsverzeichnisses. Nach dem (Neu-)Start von Eclipse steht das Plugin zur Verfügung.","hash":"user_eclipseplugin_installation","h1":"Installation"},"729":{"id":729,"content":"Konfiguration Öffnen Sie den Konfigurationsdialog über den Eclipse Menüpunkt »Run«-»Run Configurations«. Geben Sie die gewünschten Werte im Reiter \"Main\" und bei Bedarf in den Reitern \"Settings\" und \"Initial Settings\" ein. (Bei den Reitern \"Environment\" und \"Common\" handelt es sich um Eclipse Standardreiter, die für die Konfiguration des QF‑Test Plugins nicht benötigt werden.) Anschließend übernehmen Sie die Konfiguration mit \"Apply\". Gestartet wird mittels \"Run\".","hash":"user_eclipseplugin_configuration","h1":"Konfiguration"},"730":{"id":730,"content":"Reiter \"Main\"","hash":"user_eclipseplugin_configuration_main","h1":"Reiter \"Main\""},"731":{"id":731,"content":"Abbildung 29.1: Eclipse Plugin Konfiguration - Reiter \"Main\" Im Feld \"QF‑Test executable\" geben Sie \"qftest.exe\" inklusive Pfad an. Z.B. C:\\Program Files (x86)\\qfs\\qftest\\qftest-4.1.0\\bin\\qftest.exe. Das Feld \"Run configuration to be used as SUT\" ist optional. Hier kann eine in Eclipse angelegte \"Run Configuration\" angegeben werden, über die die zu testende Applikation gestartet wird. Bei Start der Applikation wird eine Verbindung zu QF‑Test hergestellt, so dass Tests auf der Applikation abgespielt und auch Aufnahmen von Tests gemacht werden können. Dies ist hilfreich, wenn die unter \"Startup nodes\" konfigurierten QF‑Test Knoten keine Startsequenz enthalten um die Applikation zu starten. Bitte beachten Sie dabei, dass die Ausführung der eingetragenen Run Configuration, die als SUT genutzt werden soll, angestoßen wird und sofort im Anschluss daran die Ausführung der aufgelisteten \"Startup nodes\" beginnt. Das hat zur Folge, dass im Test als erstes darauf gewartet werden sollte, dass der Client gestartet ist. D.h. entweder sollte im ersten \"Startup node\" der erste ausgeführte Knoten ein Warten auf Client sein oder der erste \"Startup node\" sollte direkt einen Warten auf Client Knoten in QF‑Test ausführen. In der Tabelle \"Startup nodes\" werden alle QF‑Test Knoten eingetragen, die der Reihe nach ausgeführt werden soll. Ein Knoten werden anhand seiner QF‑Test ID identifiziert sowie der Testsuite, in der er sich befindet. Bitte beachten Sie, dass die QF‑Test ID ein eigenständiges Attribut des Knotens ist und nicht dessen Name. Dieses Attribut ist standardmäßig leer und muss eigens gesetzt werden.","hash":"fig_eclipseplugin_config_main","h4":"Abbildung 29.1: Eclipse Plugin Konfiguration - Reiter \"Main\""},"732":{"id":732,"content":"Reiter \"Settings\"","hash":"user_eclipseplugin_configuration_settings","h1":"Reiter \"Settings\""},"733":{"id":733,"content":"Abbildung 29.2: Eclipse Plugin Konfiguration - Reiter \"Settings\" Variablen in diesem Reiter werden vor jeder Ausführung der \"Run Configuration\" neu eingelesen. Im Feld \"Path to run log folder\" kann das Verzeichnis angegeben werden, in dem die Protokolle für Testläufe aus dieser Run Configuration abgelegt werden. Die Angabe ist optional. Falls kein Wert angegeben wird, greift der Wert, der in der QF‑Test Systemkonfiguration gesetzt wurde. In der Tabelle \"Variables\" können Variablen spezifiziert werden, die bei der Ausführung der Run Configuration auf Kommandozeilenebene an QF‑Test übergeben werden. Damit können Default-Variablenwerte überschrieben werden, nicht jedoch im Test gesetzte globale oder lokale Variablen.","hash":"fig_eclipseplugin_config_settings","h4":"Abbildung 29.2: Eclipse Plugin Konfiguration - Reiter \"Settings\""},"734":{"id":734,"content":"Reiter \"Initial Settings\"","hash":"user_eclipseplugin_configuration_initalsettings","h1":"Reiter \"Initial Settings\""},"735":{"id":735,"content":"Abbildung 29.3: Eclipse Plugin Konfiguration - Reiter \"Initial Settings\" Die Werte dieses Reiters sind optional und werden beim Start von QF‑Test ausgewertet. Eine Änderung der Werte erfordert einen Neustart von QF‑Test aus Eclipse heraus bevor sie greifen. Path to license file: Pfad der zu verwendenden Lizenzdatei. Path to qftest system config file: Pfad der zu verwendenden qftest.cfg Datei. Path to qftest user config file: Pfad der zu verwendenden benutzerspezifischen Konfigurationsdatei.","hash":"fig_eclipseplugin_config_initialsettings","h4":"Abbildung 29.3: Eclipse Plugin Konfiguration - Reiter \"Initial Settings\""},"736":{"id":736,"content":"Pro Handbuch","hash":"","h0":"Ant | QF‑Test Handbuch"},"737":{"id":737,"content":"Pro Handbuch","hash":"home-link","h0":"Ant | QF‑Test Handbuch"},"738":{"id":738,"content":"Ant Wer Apache Ant (http://ant.apache.org) als Buildsystem einsetzt, kann die Testausführung mit QF‑Test in die Builddatei integrieren: <project name=\"QF‑Test\" default=\"runtest\"> <property name=\"qftest\" location=\"c:\\Program Files\\qfs\\qftest\\qftest-10.0.2-pro\\bin\\qftest.exe\" /> <property name=\"logdir\" value=\"c:\\mylogs\" /> <target name=\"runtest\" description=\"Run a test in batchmode\"> <echo message=\"Running ${suite} ...\" /> <exec executable=\"${qftest}\" failonerror=\"false\" resultproperty=\"returncode\"> <arg value=\"-batch\" /> <arg value=\"-compact\" /> <arg value=\"-runlog\" /> <arg value=\"${logdir}\\+b\" /> <arg value=\"${suite}\" /> </exec> <condition property=\"result\" value=\"Test terminated successfully.\"> <equals arg1=\"${returncode}\" arg2=\"0\" /> </condition> <condition property=\"result\" value=\"Test terminated with warnings.\"> <equals arg1=\"${returncode}\" arg2=\"1\" /> </condition> <condition property=\"result\" value=\"Test terminated with errors.\"> <equals arg1=\"${returncode}\" arg2=\"2\" /> </condition> <condition property=\"result\" value=\"Test terminated with exceptions.\"> <equals arg1=\"${returncode}\" arg2=\"3\" /> </condition> <echo message=\"${result}\" /> </target> </project> Beispiel 29.1: Ant Builddatei build.xml zur Ausführung einer Testsuite Im obigen Beispiel wird davon ausgegangen, dass die auszuführende Testsuite beim Aufruf von ant als Property definiert wird: ant -Dsuite=\"...\\qftest-10.0.2-pro\\demo\\carconfigSwing\\carconfigSwing_en.qft\".","hash":"usec_ant","h0":"Ant"},"739":{"id":739,"content":"Pro Handbuch","hash":"","h0":"Maven | QF‑Test Handbuch"},"740":{"id":740,"content":"Pro Handbuch","hash":"home-link","h0":"Maven | QF‑Test Handbuch"},"741":{"id":741,"content":"Maven Wer Apache Maven (http://maven.apache.org) als Buildsystem einsetzt, kann die Testausführung mit QF‑Test in die Builddatei integrieren. Dies geschieht mittels Verwendung des antrun Plugins von Maven. Eine Beispiel pom.xml Datei, bei der die Tests in der test Phase des Builds ausgeführt werden, könnte wie folgt aussehen: <project xmlns=\"http://maven.apache.org/POM/4.0.0\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://maven.apache.org/POM/4.0.0 http://maven.apache.org/maven-v4_0_0.xsd\"> <modelVersion>4.0.0</modelVersion> <artifactId>testant</artifactId> <packaging>jar</packaging> <name>testant</name> <groupId>de.qfs</groupId> <version>1</version> <properties> <qf.exe>\"C:\\Program Files\\qfs\\qftest\\qftest-10.0.2-pro\\bin\\qftest.exe\"</qf.exe> <qf.reportfolder>qftest</qf.reportfolder> <qf.log>logFile.qrz</qf.log> <qf.suite>\"c:\\path\\to\\testsuite.qft\"</qf.suite> </properties> <build> <plugins> <plugin> <groupId>org.apache.maven.plugins</groupId> <artifactId>maven-antrun-plugin</artifactId> <executions> <execution> <phase>test</phase> <configuration> <tasks> <exec executable=\"${qf.exe}\"> <arg value=\"-batch\"/> <arg value=\"-report\"/> <arg value=\"${qf.reportfolder}\"/> <arg value=\"-runlog\"/> <arg value=\"${qf.log}\"/> <arg value=\"${qf.suite}\"/> </exec> </tasks> </configuration> <goals> <goal>run</goal> </goals> </execution> </executions> </plugin> </plugins> </build> </project> Beispiel 29.2: Maven Builddatei pom.xml zur Testausführung In Ihrem Projekt könnte es notwendig werden, die Tests nicht in der test Phase auszuführen. Hierfür sollten Sie das Plugin wie in der Mavendokumentation beschrieben konfigurieren.","hash":"usec_maven","h0":"Maven"},"742":{"id":742,"content":"Pro Handbuch","hash":"","h0":"Jenkins | QF‑Test Handbuch"},"743":{"id":743,"content":"Pro Handbuch","hash":"home-link","h0":"Jenkins | QF‑Test Handbuch"},"744":{"id":744,"content":"Jenkins Das Video 'QF‑Test Jenkins Plugin' zeigt die Einrichtung und Konfiguration des Plugins. Bei Jenkins (jenkins-ci.org) handelt es sich um ein Continuous-Integration-Build-Tool. Es ist dazu gedacht, die Ausführung des Build-Prozesses eines Software-Projektes zu steuern und zu überwachen sowie die Ergebnisse zu verwalten. Ein wichtiger Schritt in diesem Build-Prozess sind automatisierte Tests, u.a. auch GUI-Tests mit QF‑Test. Eine Verwendung von QF‑Test in Kombination mit Jenkins kann folgende Vorteile bringen: Falls bereits ein Continuous-Integration-Prozess mit Jenkins für die fortlaufende Erstellung der Software verwendet wird, kann das automatisierte Testen sehr einfach in den bestehenden Ablauf integriert werden. Einfache Verwaltung von zeitgesteuerten Starts der Tests sowie Benachrichtigung über das Ergebnis über Email oder RSS. Komfortable Übersicht und Kontrolle der ausgeführten Testläufe in einer webbasierten Oberfläche. Mit dem HTML Publisher Plugin können QF‑Test HTML-Reports direkt in die Oberfläche von Jenkins/Jenkins integriert werden. Resultate, wie Protokolle und Reports, die während des Testlaufs erstellt werden, können automatisch archiviert werden. Somit ist es nicht mehr nötig, eine eigene Verzeichnisstruktur zu pflegen.","hash":"usec_jenkins","h0":"Jenkins"},"745":{"id":745,"content":"Jenkins installieren und starten Für GUI Tests darf Jenkins nicht als Service eingerichtet sein sondern muss innerhalb einer echten Benutzer-Sitzung laufen. Unter Windows konfiguriert der Jenkins .msi Installer leider ohne Rückfrage direkt den Betrieb als Service, weshalb wir von diesem abraten. Bitte stellen Sie sicher, dass Jenkins als echter Benutzerprozess startet, wie es unten beschrieben wird. Die Installation von Jenkins beschränkt sich auf das Herunterladen des war Archivs von jenkins-ci.org/latest/jenkins.war und das Starten mittels java -jar jenkins.war. Sobald Jenkins erfolgreich läuft, kann mittels eines Browsers über die URL http://localhost:8080 auf die Weboberfläche zugegriffen werden, welche sich wie folgt darstellt:","hash":"jenkinsInstall","h1":"Jenkins installieren und starten"},"746":{"id":746,"content":"Abbildung 29.4: Jenkins nach dem Start.","hash":"figure_29.4","h4":"Abbildung 29.4: Jenkins nach dem Start."},"747":{"id":747,"content":"Voraussetzungen für GUI-Tests GUI-Tests benötigen einen ungesperrten, aktiven Desktop mit einer aktiven Benutzer-Session. So verhält sich das SUT genauso wie bei einem normalen Benutzer. Deshalb ist es nicht möglich, den Agenten als Windows-Service zu starten, sondern ein realer (Test-) Benutzer muss angemeldet sein (z.B. mittels Auto-Login) und Start des Agenten über Windows-Autostart. Bildschirmsperren müssen deaktiviert sein. Sie finden im Kapitel Aufsetzen von Testsystemen nützliche Tipps und Tricks für die Einrichtung des Jenkins-Prozesses. Jenkins erlaubt die Ausführung von Aufgaben auf verteilten Rechnern. Dies ist natürlich auch für GUI-Tests relevant. Aufgrund Ihrer Natur werden GUI-Tests typischerweise nicht direkt auf dem zentralen Buildserver ausgeführt. Zusätzlich sollen häufig Tests für verschiedene Umgebungen, Betriebssysteme und Versionen des SUTs durchgeführt werden. Auf einem dezentralen Rechner muss ein Jenkins Agent gestartet werden, um sich zum zentralen Jenkins Server zu verbinden und dann auf auszuführende Aufgaben zu warten. Wie in der Dokumentation von Jenkins beschrieben, gibt es verschiedene Möglichkeiten diesen Agenten zu starten, aber damit die GUI-Tests vollständig funktionieren können, müssen die Agenten via Java Web Start gestartet werden. Weitere technische Hintergrundinformation gibt FAQ 14.","hash":"jenkinsGuiTests","h1":"Voraussetzungen für GUI-Tests"},"748":{"id":748,"content":"Installation des QF‑Test Plugins Das QF‑Test Plugin ermöglicht die Ausführung von QF‑Test Suiten in Jenkins. Um das Plugin zu installieren, öffnen Sie das Jenkins Dashboard und gehen auf \"Jenkins verwalten\", gefolgt von \"Plugins verwalten\". Wählen Sie das QF‑Test Plugin im \"Verfügbar\" Tab aus und klicken Sie auf den Installieren-Button. Das QF‑Test Plugin wird auch das JUNIT und das HTML-Publisher Plugin herunterladen, falls diese noch nicht installiert sind. Schließlich muss Jenkins neugestartet werden um die Installation abzuschließen. Das QF‑Test Plugin erscheint nun in dem \"Installiert\" Tab, wie in Abbildung 20.2 gesehen werden kann. Jenkins benutzt automatisch die zuletzt installierte Version von QF‑Test. Falls eine andere Version genutzt werden soll, kann der Pfad in der QF‑Test Sektion in den Jenkins Einstellungen angegeben werden (Jenkins verwalten -> System konfigurieren).","hash":"usec_jenkinsInstallPlugin","h1":"Installation des QF‑Test Plugins"},"749":{"id":749,"content":"Abbildung 29.5: QF‑Test Plugin installiert. Sobald das QF‑Test Plugin erfolgreich installiert wurde kann man die Testausführung mit QF‑Test in den Jenkins-Buildprozess integrieren. Eine detaillierte Handreichung dazu findet sich in der Dokumentation des QF‑Test Plugins unter https://www.qftest.com/en/jenkins.","hash":"figure_29.5","h4":"Abbildung 29.5: QF‑Test Plugin installiert."},"750":{"id":750,"content":"Pro Handbuch","hash":"","h0":"JUnit 5 Jupiter | QF‑Test Handbuch"},"751":{"id":751,"content":"Pro Handbuch","hash":"home-link","h0":"JUnit 5 Jupiter | QF‑Test Handbuch"},"752":{"id":752,"content":"JUnit 5 Jupiter In \"Unit-Tests\" wurde beschrieben, wie sich JUnit-Tests komfortabel in eine QF‑Test Testsuite einbinden lassen und ein gemeinsames Protokoll die Ergebnisse aus den übrigen Testfällen mit denen der Unit-Tests kombiniert. Mit Hilfe der Java-Annotation @QFTest.Test ist es möglich, das umgekehrte Szenario zu realisieren - QF‑Test Testsuiten als Teil eines JUnit 5 Testfalls einzubinden und die Ergebnisse des QF‑Test Testlaufs mit den Ergebnissen der übrigen JUnit-Testfälle zu kombinieren. Dies vereinfacht die Einbindung von QF‑Test Testläufen sowohl in bestehende Maven- oder Gradle-Builds, als auch in Entwicklungsumgebungen wie Eclipse oder IntelliJ IDEA. Konkret muss dafür in der Test-Klasse, welche die Ausführung von einer oder mehrerer QF‑Test Testsuiten umfassen soll, eine Methode hinzugefügt werden, welche mit der Annotation de.qfs.apps.qftest.junit5.QFTest.Test markiert ist. Diese Methode muss ein Objekt des Typs de.qfs.apps.qftest.junit5.QFTest zurückgeben, welches durch Aufruf der statischen Methode QFTest.runSuite oder QFTest.runSuites erzeugt wird. Bei Bedarf kann dieses Objekt weiter konfiguriert werden, um zum Beispiel QF‑Test Optionen oder Variablen zu spezifizieren. Die Dokumentation der dafür bereitgestellten Methoden findet sich in der Datei doc/javadoc/qftest-junit5.zip innerhalb der QF‑Test Installation. import de.qfs.apps.qftest.junit5.QFTest; import java.io.File; public class QFTestDemoTest { @QFTest.Test QFTest demoTest() throws Exception { // Demo-Testsuite lokalisieren final File qftestVerdir = QFTest.getVersionDir(); final File demo = new File(qftestVerdir, \"demo/carconfigSwing/carconfigSwing_de.qft\"); return QFTest.runSuite(demo) .withVariable(\"buggyMode\",\"True\") .withArgument(\"-verbose\") .withReportOpen(); } } Beispiel 29.3: Beispiel einer JUnit 5-Testklasse, die einen QF‑Test Testlauf einbezieht. Zur Ausführung des Testes ist es notwendig die folgenden Bibliotheken aus der QF‑Test Installation im Classpath einzubinden: lib/truezip.jar qflib/qflib.jar qflib/qfshared.jar qflib/qftest.jar Wenn das Projekt mit Gradle gebaut wird, so kann man das de.qfs.qftest Gradle-Plugin anwenden, welches die Abhängigkeiten automatisch auflöst. Weitere Informationen dazu finden sich auf der Plugin Homepage. plugins { id 'java' id 'de.qfs.qftest' version '1.1.0' } repositories { mavenCentral() } test { useJUnitPlatform() } Beispiel 29.4: Ausschnitt aus einer gradle.build-Datei, welche im JUnit-Testlauf QF‑Test aufruft.","hash":"usec_junit5","h0":"JUnit 5 Jupiter"},"753":{"id":753,"content":"Pro Handbuch","hash":"","h0":"TeamCity CI | QF‑Test Handbuch"},"754":{"id":754,"content":"Pro Handbuch","hash":"home-link","h0":"TeamCity CI | QF‑Test Handbuch"},"755":{"id":755,"content":"TeamCity CI QF‑Test kann leicht in TeamCity CI integriert werden, sodass Tests automatisch von TeamCity CI ausgeführt werden und Testergebnisse, Protokolle und HTML-Reports direkt aus der TeamCity-Benutzeroberfläche heraus eingesehen werden können. Eine Schritt-für-Schritt-Anleitung hierzu finden Sie in unserem Blogartikel Integration von QF‑Test mit TeamCity in drei einfachen Schritten .","hash":"usec_teamcityci","h0":"TeamCity CI"},"756":{"id":756,"content":"Pro Handbuch","hash":"","h0":"Integration mit Robot Framework | QF‑Test Handbuch"},"757":{"id":757,"content":"Pro Handbuch","hash":"home-link","h0":"Integration mit Robot Framework | QF‑Test Handbuch"},"758":{"id":758,"content":"Integration mit Robot Framework","hash":"usec_robotframework","h0":"Integration mit Robot Framework"},"759":{"id":759,"content":"Einführung Robot Framework ist ein sehr beliebtes Framework zur Testautomatisierung und robotergesteuerten Prozessautomatisierung (Robotic Process Automation - RPA). Es basiert auf Python und kommt mit einer Vielzahl an gebrauchsfertigen Bibliotheken für diverse Testszenarien. Meist wird die Entscheidung zwischen entweder QF‑Test oder Robot Framework fallen, aber es gibt Situationen für welche die Integration absolut Sinn ergibt: Wenn Sie einerseits bereits existierende Infrastruktur für Robot Framework haben oder Tester in Ihrem Team über Spezialwissen zu Robot Framework verfügen und andererseits die besonderen Fähigkeiten von QF‑Test in der UI-Automatisierung benötigen.","hash":"usec_rf_intro","h1":"Einführung"},"760":{"id":760,"content":"Voraussetzungen und Installation Es muss eine aktuelle Version von Python 3 installiert sein. Falls noch nicht vorhanden, kann Robot Framework via pip install robotframework installiert werden. Es wird Robot Framework Version 4 oder höher benötigt. Die Integration benötigt eine Brücke zwischen Python und Java. JPype erfüllt diese Rolle ausgezeichnet. Es muss via pip install JPype1 installiert werden. QF‑Test enthält eine Robot Framework Bibliothek namens qftest, die Robot Framework bekannt gemacht werden muss. Sie befindet sich im Verzeichnis .../qftest-10.0.2-pro/ext/robotframework. Sie können entweder dieses Verzeichnis zu Ihrer PYTHONPATH Environment Variable hinzufügen, oder eine Datei namens qftest_robot.pth in den site-packages Ihrer Python 3 Installation anlegen - also .../python3/Lib/site-packages/qftest_robot.pth - die genau eine Zeile enthält: Den vollständigen Pfad zu diesem Verzeichnis.","hash":"usec_rf_installation","h1":"Voraussetzungen und Installation"},"761":{"id":761,"content":"Erste Schritte Robot Framework kommuniziert mit dem QF‑Test Daemon, daher müssen Sie zunächst QF‑Test, wie in \"Daemon-Modus\" beschrieben, mit aktiviertem Daemon-Modus starten. Zum Erstellen von Tests ist es ideal, den interaktiven Daemon-Modus zu nutzen, da Sie dann den QF‑Test Debugger aktiveren und dazu nutzen können, auf der Ebene von QF‑Test in Einzelschritten durch Ihre Keywords zu gehen, unabhängig von und in Ergänzung zu dem Debugger der IDE, mit der Sie Ihre Robot Framework-Skripte ausführen. Starten Sie also bitte QF‑Test von der Kommandozeile mit qftest -daemon -daemonport 5454 -keystore= Port 5454 ist nur ein Beispiel, Sie können diesen beliebig wählen, müssen ihn aber, wie unten beschrieben, in Ihrer robot Datei angeben. Wie beim Kommandozeilenargument -keystore <Keystore-Datei> beschrieben, dient -keystore= dazu, den Daemon ohne abgesicherte Kommunikation zu starten, was den Verbindungsaufbau beschleunigt und für den internen Gebrauch auf Ihrer Maschine akzeptabel sein sollte. Das dritte Argument der qftest Bibliothek muss in diesem Fall \"false\" sein und \"true\", wenn ein Keystore genutzt wird. Bevor Sie Ihre eigenen Robot Framework Tests mit QF‑Test erstellen, sollten Sie zunächst das mit QF‑Test bereitgestellte Demo-Skript ausführen, um sicherzustellen, dass Ihre Umgebung vollständig eingerichtet ist. Es befindet sich im Verzeichnis .../qftest-10.0.2-pro/demo/robotframework. Bitte wechseln Sie dorthin und führen Sie folgenden Befehl aus: robot carconfigSwing_de.robot Dieses Skript sollte die Swing Carconfig Demo-Anwendung starten und darin ein paar Klicks und Checks durchführen. Wenn Sie dieses mehrfach ausführen sehen Sie einen weiteren großen Vorteil dieser Integration: Durch die Nutzung des QF‑Test Daemon zum Start den Anwendung wird deren Lebensdauer unabhängig von der des Python Prozesses, der das Robot Framework-Skript ausführt. Es können also weitere Skripte ausgeführt werden und die bereits laufende Anwendung nutzen - dank des QF‑Test Konzepts von Abhängigkeiten (\"Abhängigkeiten\") trotzdem immer in einem definierten Zustand. SmartIDs (vgl. \"SmartID\") sind ideal zur Angabe der Zielkomponenten von Robot Framework Keywords geeignet. Leider leitet das führende '#'-Zeichen von SmartIDs in Robot Framework einen Kommentar ein, so dass dieses immer geschützt werden müsste, was die Lesbarkeit stark beeinträchtigt. Es gibt aber eine Option in QF‑Test, nach deren Aktivieren jede Referenz auf eine Bemerkung auch ohne führendes '#' implizit als SmartID behandelt wird, sofern kein Komponente Knoten mit dieser ID existiert. Da diese spezifisch für Robot Framework ist, kann Sie nur auf Skriptebene aktiviert werden, wie in der Prozedur \"use smartids without marker\" der robot.qft Demo-Testsuite gezeigt: rc.setOption(Options.OPT_SMARTID_WITHOUT_MARKER, true)","hash":"usec_rf_start","h1":"Erste Schritte"},"762":{"id":762,"content":"Nutzung der Bibliothek Wie Sie der Datei resource.txt im Robot Framework Demo-Verzeichnis entnehmen können, muss die qftest Bibliothek wie folgt initialisiert werden: Library qftest localhost 5454 false ${SUITE} Die Argumente sind optional. Die ersten drei legen Host und Port für den zu kontaktierenden QF‑Test Daemon fest und ob ein Keystore verwendet werden soll oder nicht. Das vierte hat den Standardwert robot.qft und bezeichnet die primäre Testsuite zur Ermittlung der Keywords, die Robot Framework nutzen kann.","hash":"usec_rf_library","h1":"Nutzung der Bibliothek"},"763":{"id":763,"content":"Erstellung eigener Keywords Die Keywords für Robot Framework werden ermittelt, indem die primäre Testsuite, die als Argument bei der Definition der Library angegeben wurde, zusammen mit allen direkt oder indirekt per include referenzierten Testsuiten durchgegangen wird. Hierbei wird das @keyword Doctag genutzt, um eine Prozedur oder eine ganze Package Hierarchie als Keyword festzulegen. Details hierzu finden Sie in \"Doctags für Robot Framework\".","hash":"usec_rf_keywords","h1":"Erstellung eigener Keywords"},"764":{"id":764,"content":"Pro Handbuch","hash":"","h0":"Schlüsselwortgetriebenes bzw. Keyword-Driven Testing mit QF‑Test | QF‑Test Handbuch"},"765":{"id":765,"content":"Pro Handbuch","hash":"home-link","h0":"Schlüsselwortgetriebenes bzw. Keyword-Driven Testing mit QF‑Test | QF‑Test Handbuch"},"766":{"id":766,"content":"Schlüsselwortgetriebenes bzw. Keyword-Driven Testing mit QF‑Test","hash":"usec_keyworddriven","h1":"Schlüsselwortgetriebenes bzw. Keyword-Driven Testing mit QF‑Test"},"767":{"id":767,"content":"Pro Handbuch","hash":"","h0":"Einführung | QF‑Test Handbuch"},"768":{"id":768,"content":"Pro Handbuch","hash":"home-link","h0":"Einführung | QF‑Test Handbuch"},"769":{"id":769,"content":"Einführung Das Konzept des schlüsselwortgetriebenen Testens, auch Keyword-Driven Testing genannt, erlaubt es Fachtestern ohne QF‑Test Kenntnisse Testfälle in einer Metasprache oder einem Testmanagementtool zu spezifizieren. Diese Testfälle werden nun von QF‑Test interpretiert und ausgeführt. Die reale Implementierung der Testschritte in QF‑Test erfolgt durch Personen, die QF‑Test programmieren können. Die verwendete Art der Beschreibung, also die Schlüsselwörter, kann frei zwischen Fachtestern und QF‑Test Experten vereinbart werden. Dabei reicht die Bandbreite bei der Festlegung der Schlüsselwörter von atomaren Aktionen (z.B. Mausklick auf Button) bis hin zu komplexen Vorgängen (z.B. Anlegen eines Vorgangs innerhalb der zu testenden Anwendung). Die Formulierung der Testschritte kann hierbei einerseits in streng definierten Tabelleneingaben (z.B. klickeButton=OK) oder andererseits sogar in Fließtext (z.B. Auf OK klicken, um Dialog zu schließen) erfolgen. Um Ihnen einen Eindruck von den unterschiedlichen Varianten zu geben, stellen wir jetzt die Varianten anhand eines Testfalles für den QF‑Test CarConfigurator dar. Der Testfall soll ein Fahrzeug in dieser Anwendung anlegen. Im Großen und Ganzen kann man von vier unterschiedlichen Arten sprechen: Variante 1: Fachliche Testschritte (siehe \"Fachliche Prozeduren\"). Eine Beispielimplementierung finden Sie unter qftest-10.0.2-pro/demo/keywords/simple_business.","hash":"used_keywords_intro","h0":"Einführung"},"770":{"id":770,"content":"Testschritt Anwendung starten, wenn notwendig Fahrzeugdialog öffnen, unter Einstellungen -> Fahrzeuge Daten wie Name und Preis eingeben Auf Neu klicken, um das Fahrzeug anzulegen Auf OK klicken, um den Dialog zu schließen Die Anlage des Fahrzeuges prüfen Tabelle 31.1: Testfall mit fachlichen Schlüsselwörtern Variante 2: Atomare Testschritte (siehe \"Atomare Prozeduren\"). Eine Beispielimplementierung finden Sie unter qftest-10.0.2-pro/demo/keywords/simple_atomic.","hash":"table_31.1","h0":"Einführung"},"771":{"id":771,"content":"Testschritt Anwendung starten, wenn notwendig Menüpunkt \"Einstellungen\" auswählen Menüpunkt \"Fahrzeuge...\" auswählen Textfeld 'Name' füllen Textfeld 'Preis' füllen Button 'Neu' klicken, um das Fahrzeug anzulegen Button 'OK' klicken, um den Dialog zu schließen Tabelle der Fahrzeuge prüfen, ob das neue Fahrzeug sich darin befindet Tabelle 31.2: Testfall mit atomaren Schlüsselwörtern Variante 3: Behavior-Driven Testing (BDT) (siehe \"Behavior-Driven Testing (BDT) mit technischer Beschreibung\"). Eine Beispielimplementierung finden Sie unter qftest-10.0.2-pro/demo/keywords/behaviordriven.","hash":"table_31.2","h0":"Einführung"},"772":{"id":772,"content":"Testschritt Gegeben Anwendung läuft Gegeben Dialog Fahrzeuge ist geöffnet Wenn Textfeld Name auf Wert <name> gesetzt Und Textfeld Preis mit Wert <preis> gefüllt Und Button Neu geklickt wurde Und Button OK geklickt wurde Dann ist Tabelle Fahrzeuge eine neue Zeile mit den Werte <name> und <formatierter-preis> erschienen Und Spalte Modell enthält den Wert <name> Und Spalte Preis enthält den Wert <formatierter-preis> Tabelle 31.3: Testfall mit Behavior-Driven Testing mit technischer Beschreibung Variante 4: Behavior-Driven Testing (BDT) aus fachlicher Sicht (siehe \"Behavior-Driven Testing (BDT) mit fachlicher Beschreibung\"). Eine Beispielimplementierung finden Sie unter qftest-10.0.2-pro/demo/keywords/behaviordriven_business.","hash":"table_31.3","h0":"Einführung"},"773":{"id":773,"content":"Testschritt Gegeben Anwendung ist bereit, um neue Fahrzeugdaten einzugeben Wenn ein Fahrzeug mit dem Namen <name> und <preis> angelegt wurde Dann erscheint das Fahrzeug mit den Werten <name> und <formatierter-preis> in der Fahrzeugübersicht Tabelle 31.4: Testfall mit Behavior-Driven Testing aus fachlicher Sicht In den folgenden Abschnitten werden nun diese unterschiedlichen Varianten für schlüsselwortgetriebenes Testen mit QF‑Test genauer beschrieben. In einem weiteren Abschnitt wird auch das Konzept des Behavior-Driven Testings (BDT) beschrieben, welches aus QF‑Test Sicht eine Sonderform des schlüsselwortgetriebenen Testens darstellt. Die Beispiele beziehen sich allesamt auf den QF‑Test CarConfigurator, welcher Teil der Auslieferung von QF‑Test ist. Sie finden sämtliche Beispiele auch im Verzeichnis qftest-10.0.2-pro/demo/keywords/. Für die Testplanung von sämtlichen Beispielen haben wir der Einfachheit halber Excel-Dateien mitgeliefert, welche die Testplanung der jeweiligen Testfälle beinhaltet. Natürlich kann in Ihrem Projekt diese Planung auch in Ihrem Testmanagementtool durchgeführt werden. Wir verwenden hier allerdings Excel-Dateien, weil diese Software fast überall verwendbar ist und QF‑Test diese einfach lesen kann. Im Abschnitt Keywords mit dynamischen Komponenten (siehe \"Keyword-Driven Testing mit dynamischen/generischen Komponenten\") wird auch beschrieben, wie Sie QF‑Test nur mehr als Ausführungsroboter für genau geplante Testschritte einrichten können, um QF‑Test nur mehr in Ausnahmefällen anfassen zu müssen. Bitte achten Sie darauf, dass Sie alle Testsuiten vor dem eigentlichen Einsatz in einen projektspezifischen Ordner kopieren und diese dort modifizieren.","hash":"table_31.4","h0":"Einführung"},"774":{"id":774,"content":"Pro Handbuch","hash":"","h0":"Einfaches Keyword-Driven Testing mit QF‑Test | QF‑Test Handbuch"},"775":{"id":775,"content":"Pro Handbuch","hash":"home-link","h0":"Einfaches Keyword-Driven Testing mit QF‑Test | QF‑Test Handbuch"},"776":{"id":776,"content":"Einfaches Keyword-Driven Testing mit QF‑Test Die einfachste Form von Keywords stellt die Verwendung bereits bestehender Prozeduren dar. Prozeduren können sowohl fachlicher Natur als auch atomarer Natur sein. Fachliche Prozeduren stellen einen fachlichen Ablauf dar, z.B. das Anlegen eines Fahrzeuges. Atomare Prozeduren stellen einen atomaren Schritt des Testlaufes dar, z.B. Klick auf Button OK.","hash":"usec_keywords_simple","h1":"Einfaches Keyword-Driven Testing mit QF‑Test"},"777":{"id":777,"content":"Pro Handbuch","hash":"","h0":"Fachliche Prozeduren | QF‑Test Handbuch"},"778":{"id":778,"content":"Pro Handbuch","hash":"home-link","h0":"Fachliche Prozeduren | QF‑Test Handbuch"},"779":{"id":779,"content":"Fachliche Prozeduren Wie eingangs bereits erwähnt stellen fachliche Prozeduren einen fachlichen Ablauf in Ihrer Anwendung dar. Das dazugehörige Beispiel finden Sie unter qftest-10.0.2-pro/demo/keywords/simple_business/ SimpleKeywords.qft. Der dazugehörige Testplan liegt unter qftest-10.0.2-pro/demo/keywords/simple_business/ simple_keywords.xlsx. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren. Als Beispiel können wir uns den Testfall \"Fahrzeug anlegen\" für den CarConfigurator näher anschauen. Dieser Testfall besteht aus folgenden Schritten: Anwendung starten, wenn notwendig Fahrzeugdialog öffnen, unter Einstellungen -> Fahrzeuge Daten wie Name und Preis eingeben Auf Neu klicken, um das Fahrzeug anzulegen Auf OK klicken, um den Dialog zu schließen Die Anlage des Fahrzeuges prüfen Wenden wir uns zuerst der Excel-Datei zu.","hash":"usec_keywords_simple_business","h0":"Fachliche Prozeduren"},"780":{"id":780,"content":"Abbildung 31.1: Excel-Datei fachliche Schlüsselwörter Nachdem QF‑Test Excel-Dateien zeilenweise lesen kann, haben wir uns für diesen Aufbau entschieden. Dieses Einlesen folgt dem Datentreiber Konzept (siehe \"Datentreiber\"). Ein anderer Aufbau der Excel-Datei würde auch funktionieren. Der Vorteil des vorliegenden Beispiels ist, dass es ohne Skripte bzw. If-Abfragen auskommt. In der ersten Zeile finden wir die Werte teststep, value1 und value2. Diese Zeile wird später von QF‑Test als Variablennamen interpretiert werden, die pro Zeile in der Excel unterschiedliche Werte annehmen werden. Nun soll QF‑Test also schrittweise durch diese Excel-Dateien gehen und die geplanten Testschritte durchführen. Um dieses Ziel zu erreichen, schauen wir uns nun die QF‑Test Datei SimpleKeywords.qft an. Diese Datei hat folgenden Aufbau:","hash":"fig_simplebusiness_excel","h4":"Abbildung 31.1: Excel-Datei fachliche Schlüsselwörter"},"781":{"id":781,"content":"Abbildung 31.2: Testsuite fachliche Schlüsselwörter","hash":"fig_simplebusiness","h4":"Abbildung 31.2: Testsuite fachliche Schlüsselwörter"},"782":{"id":782,"content":"Knoten Zweck Testfallsatz \"Scenario\" Bildet den äußeren Knoten für die Testausführung, kann theoretisch auch weggelassen werden. Bezug auf Abhängigkeit dependencies.sutStarted Das Starten und Stoppen der Anwendung sollten Sie auch bei diesem Ansatz einer QF‑Test Abhängigkeit überlassen, weil diese nicht nur eine intelligente Verwaltung hierfür bieten, sondern auch über Mittel verfügen, auf unerwartetes Verhalten zu reagieren, siehe \"Abhängigkeiten\". Testfall \"Create vehicle\" Dieser Testfall stellt die Implementierung des Testfalles dar. Testschritt \"Walk through test steps\" Dieser Knoten wird benötigt, um die Excel-Datei mittels Datentreiber Knotens einzulesen. Datentreiber \"steps from excel\" Dieser Knoten wird die zeilenweise Wiederholung für die Daten aus der Excel-Datei sicherstellen. Excel-Datei \"steps from excel\" Hier wird auf die Excel-Datei verwiesen. Testschritt \"Generic test step\" Dieser Testschritt wird während der Ausführung mit den Namen der Testschritte aus Excel gefüllt, um einen lesbaren Report zu erzeugen. Prozeduraufruf \"business.$(teststep)\" Hier wird der entsprechende Testschritt, welcher in der Excel-Datei definiert ist, aufgerufen. Die Variable teststep wird hierbei aufgrund des Datentreiber-Mechanismuses auf die Planungsdaten der Excel-Datei gesetzt. Tabelle 31.5: Aufbau von SimpleKeywords.qft Die dafür benötigten Prozeduren sind im Package business implementiert. Damit Parameter dieser Prozeduren, die natürlich unterschiedlich sein können, in der Excel-Datei zusammengefasst werden können, werden die Excel-Parameter value1 bzw. value2 auf der jeweiligen Prozedur in die prozedurspezifischen Parameter umgewandelt.","hash":"table_31.5","h4":"Abbildung 31.2: Testsuite fachliche Schlüsselwörter"},"783":{"id":783,"content":"Abbildung 31.3: Prozedur fillDialog Dieses Konzept erfordert also, dass die zu verwendenden Keywords bereits in QF‑Test hinterlegt sind. Die Excel-Datei muss ggf. um mehrere Spalten für die Testdaten erweitert werden, falls Prozeduren mehr als zwei Parameter benötigen. Pro Testfall muss es noch einen Testfall in QF‑Test geben. Dies können Sie allerdings auch flexibler gestalten. Eine Beschreibung hierzu finden Sie unter \"Szenariodateien\".","hash":"fig_simplebusiness_enter","h4":"Abbildung 31.3: Prozedur fillDialog"},"784":{"id":784,"content":"Pro Handbuch","hash":"","h0":"Atomare Prozeduren | QF‑Test Handbuch"},"785":{"id":785,"content":"Pro Handbuch","hash":"home-link","h0":"Atomare Prozeduren | QF‑Test Handbuch"},"786":{"id":786,"content":"Atomare Prozeduren Neben den vorher beschriebenen fachlichen Prozeduren, die kleinere Workflows darstellen, ist es auch möglich, jede einzelne Aktion zu beschreiben. Sie erhalten damit eine feingranularere Beschreibung der Testfälle. Das dazugehörige Beispiel finden Sie unter qftest-10.0.2-pro/demo/keywords/simple_atomic/ SimpleAtomicKeywords.qft. Der dazugehörige Testplan liegt unter qftest-10.0.2-pro/demo/keywords/simple_atomic/ simple_atomic_keywords.xlsx. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren. Als Beispiel schauen wir uns wieder den Testfall \"Fahrzeug anlegen\" für den CarConfigurator an. Dieser Testfall besteht nun aus folgenden Schritten: Anwendung starten, wenn notwendig Menüpunkt \"Einstellungen\" auswählen Menüpunkt \"Fahrzeuge...\" auswählen Textfeld Name füllen Textfeld Preis füllen Button Neu klicken, um das Fahrzeug anzulegen Button OK klicken, um den Dialog zu schließen Tabelle der Fahrzeuge prüfen, ob sich das neue Fahrzeug darin befindet Ähnlich wie bei den fachlichen Prozeduren wird eine entsprechende Excel-Datei erstellt und es müssen die entsprechenden QF‑Test Prozeduren hinterlegt werden. Die implementierten Prozeduren finden Sie im Package atomic in der Testsuite qftest-10.0.2-pro/demo/keywords/SimpleAtomicKeywords.qft. Falls Sie sich für diesen Ansatz entscheiden, können Sie diese atomaren Prozeduren auch automatisch generieren (siehe \"Automatisierte Erstellung von Basisprozeduren\"). Im nächsten Abschnitt werden wir sehen, wie wir diese Prozeduren dynamisch anwenden können, d.h. wir können danach Testfälle mit diesem atomaren Ansatz beschreiben, müssen allerdings nicht jede Aktion als Prozedur hinterlegen bzw. jede Komponente aufzeichnen, sondern nur einmal eine bestimmte Aktion, wie klickeButton oder setzeWert beschreiben. Danach können wir diese Aktion mehrfach anwenden.","hash":"usec_keywords_simple_atomic","h0":"Atomare Prozeduren"},"787":{"id":787,"content":"Pro Handbuch","hash":"","h0":"Keyword-Driven Testing mit dynamischen/generischen Komponenten | QF‑Test Handbuch"},"788":{"id":788,"content":"Pro Handbuch","hash":"home-link","h0":"Keyword-Driven Testing mit dynamischen/generischen Komponenten | QF‑Test Handbuch"},"789":{"id":789,"content":"Keyword-Driven Testing mit dynamischen/generischen Komponenten Im vorigen Abschnitt haben wir gesehen, wie schlüsselwortgetriebenene Tests anhand einer Testplanung unterschiedliche Prozeduren aufrufen können. Allerdings ist hierbei die Erkennung der grafischen Komponenten noch in den QF‑Test Prozeduren geblieben. Dieser Ansatz erfordert, dass jede Prozedur entsprechend vorab aufgezeichnet bzw. anderweitig erzeugt wird. Es gibt allerdings noch die Möglichkeit die Information für die Komponentenerkennung auch in die Testplanung mitaufzunehmen und entsprechend in QF‑Test zu interpretieren. Das dazugehörige Beispiel finden Sie unter qftest-10.0.2-pro/demo/keywords/generic/Keywords_With_Generics.qft. Der dazugehörige Testplan liegt unter qftest-10.0.2-pro/demo/keywords/generic/keywords-generic.xlsx. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren. Grundlage dieses Verfahrens ist die generische Komponentenerkennung von QF‑Test. Dieses Verfahren erlaubt es Ihnen Variablen in die aufgezeichneten Komponenten einzufügen, und sogar noch Komponenten aus der aufgezeichneten Hierarchie zu lösen., siehe \"Generische Komponenten\". Wenden wir uns wieder unserem Beispieltestfall zu. Der Testfall \"Fahrzeug anlegen\", wird nun wie folgt beschrieben: Anwendung starten, wenn notwendig Menüpunkt \"Einstellungen\" auswählen Menüpunkt \"Fahrzeuge...\" auswählen Textfeld Name füllen Textfeld Preis füllen Button Neu klicken, um das Fahrzeug anzulegen Button OK klicken, um den Dialog zu schließen Tabelle der Fahrzeuge prüfen, ob sich das neue Fahrzeug darin befindet Wie Sie sehen, wird der Testfall genau so beschrieben, wie bei den atomaren Prozeduren im vorigen Abschnitt. Die Excel-Datei hierzu sieht wie folgt aus:","hash":"usec_keywords_components","h0":"Keyword-Driven Testing mit dynamischen/generischen Komponenten"},"790":{"id":790,"content":"Abbildung 31.4: Excel-Datei generische Komponenten In dieser Excel-Datei sehen wir nun, dass die Werte für teststep auf Werte wie selectMenu oder dialog.clickButton gesetzt sind. Des Weiteren ist eine neue Spalte target hinzugekommen. Diese Variable werden wir in den nächsten Absätzen genauer erklären. Wie wir in den vorigen Abschnitten schon gelernt haben, sollten hierfür entsprechende Prozeduren in der Testsuite qftest-10.0.2-pro/demo/keywords/generic/Keywords_With_Generics.qft bestehen. Diese finden wir unter dem Package generic. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren.","hash":"fig_keywords_excel_generics","h4":"Abbildung 31.4: Excel-Datei generische Komponenten"},"791":{"id":791,"content":"Abbildung 31.5: Testsuite generische Komponenten Werfen wir kurz einen Blick auf die Prozedur selectMenu. Diese Prozedur besteht aus einem Mausklick auf die Komponente GenericMenuItem. Wenn wir nun zu der entsprechenden Komponente springen sehen wir, dass diese Komponente nur einen Wert für das Attribut Klasse besitzt, nämlich MenuItem, keinen Wert für Name und Merkmal, danach einen Wert für das Weitere Merkmal qfs:label mit dem Status Muss übereinstimmen und dem Wert $(target). Das Attribut Struktur ist leer und bei den Werten für Geometrie steht ein '-'. Details zum '-', siehe \"Generische Komponenten\". Diese Definition bedeutet nun, dass die Erkennung dieser Komponente vom Inhalt der Variable target abhängt. Diese Variable wird für das qfs:label verwendet. Das weitere Merkmal qfs:label steht für die Beschriftung der Komponente, z.B. bei MenuItems oder Buttons oder für eine Beschriftung in der Nähe, z.B. bei Textfeldern. Wenn wir uns nun noch einmal der Excel-Datei zuwenden, werden wir sehen, dass in der Spalte target genau diese beschreibenden Texte der jeweiligen Komponenten stehen. Bei den anderen Komponenten ist das Vorgehen ähnlich. Eine zweite Aufälligkeit ist das Package dialog unter dem Package generic. Grund hierfür ist, dass QF‑Test für die Erkennung der Komponenten nicht nur die eigentliche Komponente, sondern auch immer das Fenster oder den Dialog mit in Betracht zieht. Bei Fenstern und Dialogen gibt es zwei Kategorien. Normale Fenster, die die Eingabe auf weiteren Fenstern nicht blockieren und so genannten modale Fenster, die die Eingabe auf weiteren Fenstern blockieren. Es ist in der Regel einfacher diese zwei Fensterkategorien über unterschiedliche Keywords anzusprechen. Man könnte allerdings auch dies noch weiter verallgemeinern. Bei Web-Anwendungen muss diese Unterscheidung nicht getroffen zu werden, weil sich alle Komponenten unterhalb einer Webseite befinden. In diesem Abschnitt haben wir also gesehen, wie man die Komponentenerkennung mit Variablen versehen kann, um nur noch eine Prozedur pro Aktion und Zielkomponente anzulegen. Dies erlaubt es den gesamten Test in Excel zu definieren. Die notwendigen Prozeduren samt generischer Komponenten müssen noch am Anfang des Projektes angelegt werden. Natürlich kann dieser Ansatz mit aufgezeichneten Prozeduren ergänzt werden. Diese Prozeduren können wie im Abschnitt für fachliche Prozeduren (siehe \"Fachliche Prozeduren\") angesprochen werden.","hash":"fig_keywords_generics","h4":"Abbildung 31.5: Testsuite generische Komponenten"},"792":{"id":792,"content":"Pro Handbuch","hash":"","h0":"Behavior-Driven Testing (BDT) | QF‑Test Handbuch"},"793":{"id":793,"content":"Pro Handbuch","hash":"home-link","h0":"Behavior-Driven Testing (BDT) | QF‑Test Handbuch"},"794":{"id":794,"content":"Behavior-Driven Testing (BDT) Neben dem klassischen Keyword-Driven Testing existiert auch noch das Konzept des Behavior-Driven Testing oder kurz BDT. QF‑Test ist gut integrierbar mit den Ansätzen und Tools zum Behaviourdriven Testing wie Cucumber/Gherkin (konkrete Anleitung zur Einrichtung und individuellen Anpassung bitte bei Quality First Software GmbH erfragen). In diesem Konzept werden, im Grunde genommen, Testfälle in Fließtext beschrieben, wobei der Satzanfang einem bestimmten vorgegebenen Vokabular unterliegt. Hierdurch sind Testfälle ohne Vorkenntnisse lesbar und verständlich. Wie auch beim Keyword-Driven Testing kann ein Testfall eher aus technischer Sicht (siehe \"Behavior-Driven Testing (BDT) mit technischer Beschreibung\") oder aus fachlicher Sicht (siehe \"Behavior-Driven Testing (BDT) mit fachlicher Beschreibung\") beschrieben werden. In den folgenden Abschnitten finden Sie Beispiele für beide Varianten.","hash":"usec_keywords_bdt","h1":"Behavior-Driven Testing (BDT)"},"795":{"id":795,"content":"Pro Handbuch","hash":"","h0":"Behavior-Driven Testing (BDT) mit technischer Beschreibung | QF‑Test Handbuch"},"796":{"id":796,"content":"Pro Handbuch","hash":"home-link","h0":"Behavior-Driven Testing (BDT) mit technischer Beschreibung | QF‑Test Handbuch"},"797":{"id":797,"content":"Behavior-Driven Testing (BDT) mit technischer Beschreibung Eine technische Beschreibung eines Testfalles mit Behavior-Driven Testing (BDT) orientiert sich an den grundlegenden Aktionen, die ausgeführt werden müssen. Das dazugehörige Beispiel finden Sie unter qftest-10.0.2-pro/demo/keywords/behaviordriven/ BehaviorDrivenTesting.qft. Der dazugehörige Testplan liegt unter qftest-10.0.2-pro/demo/keywords/behaviordriven/createvehicle.xlsx. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren. Nach BDT mit technischer Sicht wird unser \"Fahrzeug anlegen\" Testfall nun wie folgt beschrieben: Gegeben Anwendung läuft Gegeben Dialog Fahrzeuge ist geöffnet Wenn Textfeld Name auf Wert <name> gesetzt Und Textfeld Preis mit Wert <preis> gefüllt Und Button Neu geklickt wurde Und Button OK geklickt wurde Dann ist Tabelle Fahrzeuge eine neue Zeile mit den Werte <name> und <formatierter-preis> erschienen Und Spalte Modell enthält den Wert <name> Und Spalte Preis enthält den Wert <formatierter-preis> Der BDT Ansatz beschreibt Vorbedingungen und Aktionen mit Hilfe der Schlüsselwörter Gegeben, Wenn, Und und Dann, die am Satzanfang stehen müssen. Eine nähere Erläuterung dieses Konzeptes finden Sie in entsprechender Testliteratur. Für QF‑Test bedeutet dies, dass wir wieder Prozeduren bauen müssen, die dieser Beschreibung entsprechen. Hier hat sich bewährt, dass die BDT-Keywords als separate Packages erstellt werden. In der mitgelieferten Testsuite finden Sie hierfür auch die Packages Given, When_And und Then.","hash":"user_keywords_tech_bdt","h0":"Behavior-Driven Testing (BDT) mit technischer Beschreibung"},"798":{"id":798,"content":"Abbildung 31.6: Testsuite Behavior-Driven Testing technisch In unserer Beispiel-Testsuite liegen nun die entsprechenden Prozeduren unter den jeweiligen Packages, also z.B. eine Prozedur vehicles dialog opened unter dem Package Given. Um Flüchtigkeitsfehler bei der Beschreibung zu vermeiden wird vor dem Prozeduraufruf $(teststep) ein Server-Skript read test steps and fix typos eingeführt, dass die gesamte Beschreibung in Kleinbuchstaben formatiert und mehrfache Leerzeichen durch eines ersetzt. Damit der selbe Testfall mit unterschiedlichen Testdaten abgespielt werden kann, wurde dieses Beispiel erweitert. Natürlich könnte man hier auch versuchen, den generischen Erkennungsansatz, wie im vorigen Abschnitt beschrieben (\"Keyword-Driven Testing mit dynamischen/generischen Komponenten\"), anzuwenden. Hierfür muss entweder die Beschreibung sehr genau sein oder das vorgelagerte Skript muss die Komponenten und deren Namen gut herausfinden können.","hash":"fig_keywords_bdt","h4":"Abbildung 31.6: Testsuite Behavior-Driven Testing technisch"},"799":{"id":799,"content":"Pro Handbuch","hash":"","h0":"Behavior-Driven Testing (BDT) mit fachlicher Beschreibung | QF‑Test Handbuch"},"800":{"id":800,"content":"Pro Handbuch","hash":"home-link","h0":"Behavior-Driven Testing (BDT) mit fachlicher Beschreibung | QF‑Test Handbuch"},"801":{"id":801,"content":"Behavior-Driven Testing (BDT) mit fachlicher Beschreibung Eine fachliche Beschreibung eines Testfalles mit Behavior-Driven Testing (BDT) orientiert sich an aus Benutzersicht notwendigen Aktionen eines Testfalles. Diese Aktionen umfassen daher mehrere Interaktionen wie Mausklicks oder Texteingaben. Das dazugehörige Beispiel finden Sie unter qftest-10.0.2-pro/demo/keywords/behaviordriven_business/ BehaviorDrivenTesting-Business.qft. Der dazugehörige Testplan liegt unter qftest-10.0.2-pro/demo/keywords/behaviordriven_business/ createvehicle-business.xlsx. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren. Nach BDT mit fachlicher Sicht wird unser \"Fahrzeug anlegen\" Testfall nun wie folgt beschrieben: Gegeben Anwendung ist bereit, um neue Fahrzeugdaten einzugeben Wenn ein Fahrzeug mit dem Namen <name> und <preis> angelegt wurde Dann erscheint das Fahrzeug mit den Werten <name> und <formatierter-preis> in der Fahrzeugübersicht Wie auch im technischen Ansatz werden die Schlüsselwörter Gegeben, Wenn, Und und Dann verwendet und daher finden Sie auch hier entsprechende Packages in der mitgelieferten Testsuite. Dort sind diese Packages in englischer Sprache also Given, When_And und Then.","hash":"user_keywords_business_bdt","h0":"Behavior-Driven Testing (BDT) mit fachlicher Beschreibung"},"802":{"id":802,"content":"Abbildung 31.7: Testsuite Behavior-Driven Testing fachlich Um Flüchtigkeitsfehler bei der Beschreibung zu vermeiden wird vor dem Prozeduraufruf $(teststep) ein Server-Skript read test steps and fix typos eingeführt, dass die gesamte Beschreibung in Kleinbuchstaben formatiert und mehrfache Leerzeichen durch eines ersetzt. Damit der selbe Testfall mit unterschiedlichen Testdaten abgespielt werden kann, wurde dieses Beispiel erweitert.","hash":"fig_keywords_bdt_business","h4":"Abbildung 31.7: Testsuite Behavior-Driven Testing fachlich"},"803":{"id":803,"content":"Pro Handbuch","hash":"","h0":"Szenariodateien | QF‑Test Handbuch"},"804":{"id":804,"content":"Pro Handbuch","hash":"home-link","h0":"Szenariodateien | QF‑Test Handbuch"},"805":{"id":805,"content":"Szenariodateien Neben der Testfallbeschreibung, ist es natürlich auch möglich das gesamte Testszenario in einer Excel-Datei oder in Ihrem Testmanagementtool zu beschreiben. In diesem Abschnitt wird der Einfachheit halber wieder eine Excel-Datei genutzt. Das dazugehörige Beispiel finden Sie unter qftest-10.0.2-pro/demo/keywords/generic_with_scenario/ Keywords_With_Generics.qft. Das dazugehörige Szenario liegt unter qftest-10.0.2-pro/demo/keywords/generic_with_scenario/ scenario.xlsx. Die verwendeten Testfälle werden hier in einer separaten Excel-Datei beschrieben, siehe qftest-10.0.2-pro/demo/keywords/generic_with_scenario/ keywords-generic-testcases.xlsx. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren. Das mitgelieferte Szenario besteht aus zwei Testfällen, die mit dem generischen Prozedurenansatz beschrieben sind (\"Keyword-Driven Testing mit dynamischen/generischen Komponenten\"). Natürlich können alle anderen Ansätze auch entsprechend konfiguriert werden. Schauen wir uns zuerst die Excel-Datei an.","hash":"usec_keywords_scenarios","h0":"Szenariodateien"},"806":{"id":806,"content":"Abbildung 31.8: Excel-Datei als Szenariodatei Im Tabellenblatt \"Scenario\" ist in der ersten Spalte der Wert \"testcase\" aufgeführt, welcher später wieder als Variable verwendet werden wird. Jede weitere Zeile steht für einen Testfall. Diese Testfälle entsprechen auch den Namen der Tabellenblätter in der Excel-Datei keywords-generic-testcases.xlsx. In diesen Tabellenblättern \"tc_createvehicle\" und \"tc_createvehicle_cheap\" finden wir auch die entsprechenden Testfallbeschreibungen. Die dazugehörige Testsuite hat nun folgenden Aufbau:","hash":"fig_keywords_excel_scenario","h4":"Abbildung 31.8: Excel-Datei als Szenariodatei"},"807":{"id":807,"content":"Abbildung 31.9: Testsuite Szenariodateien","hash":"fig_keywords_scenario","h4":"Abbildung 31.9: Testsuite Szenariodateien"},"808":{"id":808,"content":"Knoten Zweck Testfallsatz \"Generic samples with scenario\" Bildet den äußeren Knoten für die Testausführung, kann theoretisch auch weggelassen werden. Bezug auf Abhängigkeit dependencies.sutStarted Das Starten und Stoppen der Anwendung sollten Sie auch bei diesem Ansatz einer QF‑Test Abhängigkeit überlassen, weil diese nicht nur eine intelligente Verwaltung hierfür bieten, sondern auch über Mittel verfügen, auf unerwartetes Verhalten zu reagieren, siehe \"Abhängigkeiten\". Datenreiber \"scenario\" Dieser Knoten wird die auszuführenden Testfälle aus der Szenariodatei einlesen. Excel-Datei \"test cases\" Hier wird auf die Szenario-Excel-Datei verwiesen. Testfall \"Generic test case\" Dieser Testfall stellt die Implementierung des Testfalles dar. Testschritt \"Walk through test steps\" Dieser Knoten wird benötigt, um die Excel-Datei für die einzelnen Testschritte mittels Datentreiber Knotens einzulesen. Datenreiber \"steps from excel\" Dieser Knoten wird die Testschritte zeilenweise auslesen. Excel-Datei \"steps from excel\" Hier wird auf die Excel-Datei für die Testfälle verwiesen. Testschritt \"Generic test step\" Dieser Testschritt wird während der Ausführung mit den Namen der Testschritte aus Excel gefüllt, um einen lesbaren Report zu erzeugen. Prozeduraufruf \"generic.$(teststep)\" Hier wird der entsprechende Testschritt, welche in der Testfall-Excel-Datei definiert ist aufgerufen. Die Variable teststep wird hierbei aufgrund des Datentreiber-Mechanismuses auf die Planungsdaten der Excel-Datei gesetzt. Tabelle 31.6: Aufbau von Keywords_With_Generics.qft","hash":"table_31.6","h4":"Abbildung 31.9: Testsuite Szenariodateien"},"809":{"id":809,"content":"Pro Handbuch","hash":"","h0":"Eigene Testbeschreibungen | QF‑Test Handbuch"},"810":{"id":810,"content":"Pro Handbuch","hash":"home-link","h0":"Eigene Testbeschreibungen | QF‑Test Handbuch"},"811":{"id":811,"content":"Eigene Testbeschreibungen In den vorigen Abschnitten haben wir die Beispiele anhand einer Beschreibung aus Excel-Dateien gesehen. Wie bereits erwähnt, können natürlich sämtliche Dateitypen, z.B. XML oder CSV-Dateien aber auch Rückgabewerte von Webservices ausgewertet werden. Hierfür ist es notwendig Server-Skripte zu implementieren, die die benötigte Information wie Testschrittname, Komponentenname etc. herauslesen und in QF‑Test Variablen setzen. Dies können Sie mit der Skriptmethode rc.setLocal bzw. rc.setGlobal bewerkstelligen. Neben dem Setzen von Variablen, wird es auch notwendig sein, Testfälle bzw. Prozedurknoten aufzurufen. Hierfür stehen Ihnen die Skriptmethoden rc.callTest und rc.callProcedure zur Verfügung. Sie finden die vollständige API Beschreibung im \"Skripting\". Einige Beispiele finden Sie in den mitgelieferten Testsuiten des ManualTesters (qftest-10.0.2-pro/demo/manualtester) wie auch der imbus TestBench Integration (qftest-10.0.2-pro/ext/testbench).","hash":"usec_keywords_custom","h0":"Eigene Testbeschreibungen"},"812":{"id":812,"content":"Pro Handbuch","hash":"","h0":"Anpassung an Ihre Software | QF‑Test Handbuch"},"813":{"id":813,"content":"Pro Handbuch","hash":"home-link","h0":"Anpassung an Ihre Software | QF‑Test Handbuch"},"814":{"id":814,"content":"Anpassung an Ihre Software Die mitgelieferten Beispiele sind für den QF‑Test CarConfigurator erstellt worden. Sie können diese als Basis verwenden, um schlüsselwortgetriebenes Testen für Ihre Anwendung zu implementieren. Aufgrund der Vielfalt von technischen Möglichkeiten zur Erstellung von Anwendungen und unterschiedlichen Testvarianten, können diese Beispiele nur als Vorlage und nicht als vollständige Lösung dienen. Natürlich können Sie Ihre Situation und Wünsche auch unserem Supportteam mitteilen, um einen passenden Lösungsansatz zu finden. Das vollständige Beispiel finden Sie im Ordner qftest-10.0.2-pro/demo/keywords/ full_sample_for_carconfig. Dort werden neben den bekannten generischen Prozeduren auch einige erweiterte Tabellenprozeduren verwendet. Die Testfälle werden mittels Szenariodatei, wie im \"Szenariodateien\" beschrieben, eingebunden. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren.","hash":"usec_keywords_adapt","h0":"Anpassung an Ihre Software"},"815":{"id":815,"content":"Technologie Notwendige Anpassungen JavaFX Bei den Fensterkomponenten muss das GUI-Engine Attribut awt durch fx ersetzt werden. Ggf. muss die Erkennung der Fenster und Dialoge mit zusätzlichen Variablen versehen werden. Die Prozedur startStop.startSUT muss an Ihre Anwendung angepasst werden. Kopieren Sie hierzu die erstellten Schritte aus dem Schnellstart Assistenten. Ggf. müssen einige Resolverskripte erstellt werden, um vernünftige Erkennungsmerkmale zu bekommen. Java/Swing Ggf. muss die Erkennung der Fenster und Dialoge mit zusätzlichen Variablen versehen werden. Die Prozedur startStop.startSUT muss an Ihre Anwendung angepasst werden. Kopieren Sie hierzu die erstellten Schritte aus dem Schnellstart Assistenten. Ggf. müssen einige Resolverskripte erstellt werden, um vernünftige Erkennungsmerkmale zu bekommen. Java/SWT Bei den Fensterkomponenten muss das GUI-Engine Attribut awt durch swt ersetzt werden. Ggf. muss die Erkennung der Fenster und Dialoge mit zusätzlichen Variablen versehen werden. Die Prozedur startStop.startSUT muss an Ihre Anwendung angepasst werden. Kopieren Sie hierzu die erstellten Schritte aus dem Schnellstart Assistenten. Ggf. müssen einige Resolverskripte erstellt werden, um vernünftige Erkennungsmerkmale zu bekommen. Web Statt dem Fenster Komponenten benötigen Sie hier einen Knoten Webseite. Dialoge in Web-Anwendungen sind Teil des Webseite, hier müssen Sie also eine Komponente innerhalb der Webseite anlegen. Die Prozedur startStop.startSUT muss an Ihre Anwendung angepasst werden. Kopieren Sie hierzu die erstellten Schritte aus dem Schnellstart Assistenten. Ggf. müssen erst Klassen und Erkennungsmerkmale mittels CustomWebResolver korrekt konfiguriert werden. Tabelle 31.7: Notwendige Anpassungen an Ihr SUT","hash":"table_31.7","h0":"Anpassung an Ihre Software"},"816":{"id":816,"content":"Pro Handbuch","hash":"","h0":"Verwendung von QF‑Test in Docker Umgebungen | QF‑Test Handbuch"},"817":{"id":817,"content":"Pro Handbuch","hash":"home-link","h0":"Verwendung von QF‑Test in Docker Umgebungen | QF‑Test Handbuch"},"818":{"id":818,"content":"Verwendung von QF‑Test in Docker Umgebungen","hash":"usec_docker","h0":"Verwendung von QF‑Test in Docker Umgebungen"},"819":{"id":819,"content":"Was ist Docker? Docker ist eine freie Virtualisierungssoftware, mit der beliebige Anwendungen sehr einfach auf physischen Computern oder in der Cloud installiert und ausgeführt werden können. Entwickelt wurde Docker ursprünglich für das Betriebssystem Linux. Inzwischen gibt es Docker für weitere Plattformen, darunter Microsoft Windows und macOS. Auch auf Cloud-Diensten wie Amazon Web Services (AWS) und Microsoft Azure läuft die Virtualisierungssoftware. Im Unterschied zu virtuellen Maschinen sind Docker-Container wesentlich ressourcensparender, da bei ihnen die Installation eines Gast-Betriebssystems entfällt.","hash":"usec_docker_intro","h1":"Was ist Docker?"},"820":{"id":820,"content":"QF‑Test Docker Images Seit QF‑Test Version 6.0.3 gibt es offizielle Docker Images, welche es erlauben QF‑Test relativ einfach zu virtualisieren. Um verschiedene Anwendungsszenarien zu ermöglichen gibt es aktuell 4 verschiedene Docker-Images je QF‑Test Version auf Docker Hub. Die genauen Details und Anwendungsmöglichkeiten zu den einzelnen Images sind ebenfalls dort beschrieben. Es gibt jeweils ein Image mit und ohne vorinstallierten Web-Browser speziell für Web-Tests sowie eine Variante mit oder ohne zusätzlichen VNC Server, der die visuelle Kontrolle der Testausführung sowie evtl. notwendiges Debugging von Tests erlaubt. Die bereitgestellten Images dienen für Ihre eigenen Anwendungsszenarien nur als Basis und können durch Verwendung dieser als Basis-Image in einem Dockerfile noch entsprechend erweitert werden. Im Februar 2023 fand ein Spezial-Webinar zum Thema Docker statt, das nach etwas Theorie auch die detaillierten Schritte zur Nutzung der QF‑Test Images auf Docker Hub zeigt. Hier geht es zum Videomitschnitt des Spezial-Webinars auf unserem QF‑Test YouTube Kanal.","hash":"usec_docker_images","h1":"QF‑Test Docker Images"},"821":{"id":821,"content":"Pro Handbuch","hash":"","h0":"Durchführung von Lasttests mit QF‑Test | QF‑Test Handbuch"},"822":{"id":822,"content":"Pro Handbuch","hash":"home-link","h0":"Durchführung von Lasttests mit QF‑Test | QF‑Test Handbuch"},"823":{"id":823,"content":"Durchführung von Lasttests mit QF‑Test Video: Lasttests","hash":"usec_loadtest","h0":"Durchführung von Lasttests mit QF‑Test"},"824":{"id":824,"content":"Hintergrund und Vergleich mit anderen Techniken Neben funktionalen und Systemtests eignet sich QF‑Test auch zur Durchführung von Lasttests, Stresstests oder Performance-Tests. Diese Art von Tests eignet sich auch um die Stabilität Ihrer gesamten Server/Client Umgebung zu prüfen. Dabei wird die Performance einer Server-Anwendung getestet, indem eine Anzahl von GUI-Clients gleichzeitig ausgeführt wird. Zusätzlich kann mit QF‑Test die, vom Benutzer erfahrene, Zeit an der grafischen Oberfläche, die so genannte End-To-End Zeit, gemessen werden. Im weiteren Verlauf des Kapitels wird der Einfachheit halber nur noch der Begriff Lasttests verwendet. Es gibt verschiedene Möglichkeiten, Lasttests durchzuführen. Im Gegensatz zu QF‑Test arbeiten die meisten davon nicht mit echten GUI-Clients, sondern setzen direkt auf der Protokollschicht zwischen GUI-Client und Server auf, z.B. indem sie HTTP Anfragen absetzen oder mittels RMI oder anderer Middleware Methoden im Server aufrufen. Protokoll-basierte und GUI-basierte Lasttests haben jeweils verschiedene Vor- und Nachteile: Ressourcenverbrauch: Protokoll-basierte Tests benötigen nur geringe Ressourcen auf der Clientseite, so dass sie gut bis zum Überlastungspunkt des Servers skalieren, ohne dafür sehr viel Hardware zu benötigen. GUI-basierte Tests benötigen dagegen für jeden Client entsprechend Rechenzeit und Speicher und gerade bei Rich Clients mit Swing oder JavaFX ist das nicht wenig. Außerdem erzeugt jeder Client ein GUI und braucht daher eine aktive Benutzersession. Aufwand Testerstellung: Rich Clients haben meistens ein komplexes User Interface, das mit einer gewissen Komplexität der Client-/Server-API korreliert. Die Erstellung von protokoll-basierten Tests, die diese API weitgehend abdecken, kann daher sehr aufwändig sein. Dagegen stehen eventuell bereits GUI-basierte Tests zur Verfügung, die für die funktionalen Tests entwickelt wurden und die mit geringen Änderungen für die Lasttests wieder verwendet werden können. Selbst wenn das nicht der Fall ist, ist es wesentlich einfacher, mit QF‑Test komplette Use Cases zu automatisieren als auf Protokollebene. Messbare Zeiten: Mit GUI-basierten Tests können so genannte End-To-End Zeiten ermittelt werden, d.h. die Zeit von einer Aktion des Anwenders bis zur Anzeige des Ergebnisses an der Oberfläche. Protokoll-basierte Tests messen dagegen nur die Zeit für die Anfrage an den Server. Beides kann sinnvoll sein, je nach Situation. In einigen Fällen kann es durchaus sinnvoll sein, beide Welten zu kombinieren. Sie können z.B. auf einigen System GUI Tests starten, die die End-To-End Zeiten ermitteln und parallel dazu führen Sie protokoll-basierte Tests aus um Last zu erzeugen. Zusammenfassend lässt sich sagen, dass GUI-basierte Lasttests sehr nützlich und effizient sein können (insbesondere wenn sich funktionale Tests wiederverwenden lassen), vorausgesetzt, es steht ausreichend Hardware zur Verfügung. Abschließend finden Sie hier noch ein Architekturbild, welches alle involvierten Systeme eines GUI-basierten Lasttests zeigt:","hash":"sec_hintergrund_und_vergleich_mit_anderen_techniken","h1":"Hintergrund und Vergleich mit anderen Techniken"},"825":{"id":825,"content":"Abbildung 33.1: Lasttest Szenario","hash":"fig_loadtestingstructure","h4":"Abbildung 33.1: Lasttest Szenario"},"826":{"id":826,"content":"Lasttests mit QF‑Test Dieses Thema ist ein sehr anspruchsvolles. Daher liefert QF‑Test eine Demolösung mit, die Sie auch als Ausgangspunkt für Ihr Lasttestprojekt verwenden können. Diese Demolösung finden Sie im Verzeichnis qftest-10.0.2-pro/demo/loadtesting/. In diesem Verzeichnis sind folgende Dateien enthalten:","hash":"sec_lasttests_mit_qf_test","h1":"Lasttests mit QF‑Test"},"827":{"id":827,"content":"Datei Zweck Systems.xlsx In dieser Excel-Datei können Sie konfigurieren, auf welchen Testsystemen der Testlauf ausgeführt werden soll. Des weiteren können hier auch noch globale Variablen für den Testlauf mitgegeben werden. carconfig_Loadtesting.qft Diese Testsuite enthält die GUI Tests, die auf den Testsystemen ausgeführt werden sollen. daemonController_twoPhases.qft Diese Testsuite stellt die Controller-Suite für den Testlauf dar. Hiermit starten und koordinieren Sie den Testlauf auf unterschiedlichen Rechnern. checkForRunningDaemons.qft Diese Testsuite beinhaltet Testfälle zur Überprüfung laufender Daemon Prozesse auf den einzelnen Testsystemen. Tabelle 33.1: Inhalt des loadtesting Verzeichnisses Die oben aufgeführten Testsuiten und Dateien können in einem Lasttest Projekt eingesetzt werden, welches mehrere Testsysteme miteinbezieht. Bitte achten Sie darauf, dass Sie den Ordner in ein projektspezifisches Verzeichnis kopieren und diese dort modifizieren. Die folgende Abbildung zeigt eine exemplarische Aufteilung.","hash":"table_33.1","h1":"Lasttests mit QF‑Test"},"828":{"id":828,"content":"Abbildung 33.2: Übersicht Lasttest Umgebung Die mitgelieferte Beispieltestsuite für die Steuerung des Testlaufes sieht wie folgt aus:","hash":"fig_loadtestingoverview","h4":"Abbildung 33.2: Übersicht Lasttest Umgebung"},"829":{"id":829,"content":"Abbildung 33.3: Die Beispieltestsuite daemonController_twoPhases.qft Um nun mit QF‑Test diese Art von Tests durchzuführen, sollten Sie folgende Punkte beachten: Bereitstellung der Testsysteme Konzeption des Testlaufes Vorbereiten der Testsysteme für den Testlauf Testausführung Testauswertung In den folgenden Abschnitten finden Sie eine kurze Erläuterung und Denkanstöße für jeden dieser Punkte. Für Tipps zur Durchführung von parallelen Webseiten-Tests mit QF‑Test lesen Sie unseren Blogartikel Parallele Webseiten-Tests mit QF‑Test .","hash":"fig_loadtestingdaemoncontroller","h4":"Abbildung 33.3: Die Beispieltestsuite daemonController_twoPhases.qft"},"830":{"id":830,"content":"Bereitstellung der Testsysteme Mit QF‑Test führen Sie Lasttests über das GUI aus. GUI Tests erfordern allerdings eine aktive Benutzersession und sollten nicht parallel auf demselben Desktop laufen. Daher wird empfohlen, dass Sie ein virtuelles oder physisches System für jeden Client bereitstellen. Es ist zwar möglich mehrere GUI Tests parallel auf einem Desktop zu starten, allerdings kann dies zu sehr subtilen Problemen, z.B. Fokusproblemen, führen und wird nur in Ausnahmefällen empfohlen. Auf jedem System muss vorab QF‑Test installiert werden. Die benötigten Testsuiten, sowie die QF‑Test Konfiguration und eventuell benötigte Testdatendateien müssen ebenfalls vorhanden sein. Dies können Sie entweder per lokaler Kopien oder durch Einrichtung eines gemeinsames Netzlaufwerk bewerkstelligen. Jedes Testsystem benötigt des weiteren zumindest eine Runtime-Lizenz, um die Tests ausführen zu können. Diese Runtime-Lizenzen können auch für einen begrenzten Zeitraum gemietet werden.","hash":"usec_loadtestingsysprep","h2":"Bereitstellung der Testsysteme"},"831":{"id":831,"content":"Konzeption des Testlaufes Im einfachsten Fall laufen auf allen involvierten Testsystemen die selben Tests. Allerdings möchte man in vielen Lasttestprojekten nicht nur einen Satz von GUI Tests über mehrere Clients verteilen, sondern man versucht die Clients in mehrere Gruppen, meistens Rollen genannt, aufzuteilen. Diese Gruppen sollen die Benutzergruppen der Software widerspiegeln. Hier kann es z.B. eine Gruppe geben, die Tests eines normalen Benutzers simuliert und eine zweite Gruppe, die nur zu bestimmten Zeiten administrative Aufgaben erledigt. Neben der Einteilung in Rollen werden Testläufe für Lasttests auch oft in unterschiedliche Phasen eingeteilt. Eine Phase steht hierbei für einen bestimmen Schwerpunkt, z.B. Zugriff von 100 Benutzern. Eine Beispieleinteilung eines Projektes in vier Phasen könnte wie folgt aussehen. Die erste Phase ist die \"Start\" Phase, in der das SUT auf allen Testsystemen gestartet wird und initiale Aktionen, wie das Anmelden des Benutzers ausgeführt werden. In der zweiten Phase führen Sie nun Tests für 50 Clients aus, in der dritten Phase werden dieselben Tests für 100 Clients ausgeführt, in der vierten Phase wieder für 50 Clients. Diese Art der Skalierung kann auch als Ramp-Up Phasen (schrittweises Aufbauen von Last) und Ramp-Down Phasen (schrittweise Entlastung) bezeichnet werden. Eine derartige Aufteilung in Phasen mit schrittweiser Steigerung der Belastung der Software hat den Vorteil, dass Sie sich an die Belastbarkeit Ihrer Software heran tasten können und nicht sofort von 0 auf 100 einsteigen, sondern immer noch eine Aussage treffen können, dass z.B. in Phase 1 alles noch in Ordnung war und erst ab der zweiten Phase es Probleme gab. Diese Aufteilung in unterschiedliche Phasen kann auch bei Tests, die sich auf Rollen fokussieren, Sinn ergeben. In einigen Fällen kann ein gleichzeitiger Start von allen teilnehmenden Testsystemen zu einer Überlast der Umgebung führen und somit würde sich bereits anbieten, zumindest den Start der Anwendung auf jeden Fall in eine separate Phase auszulagern. Aus Übersichtlichkeitsgründen sollten Sie je Rolle eine Testsuite erstellen, die die entsprechenden Testfälle beinhaltet bzw. aufruft. Umsetzung in der Beispieltestsuite: In der mitgelieferten Controller-Suite daemonController_twoPhases.qft finden Sie ein Beispiel für die Aufteilung in zwei Phasen. Die erste Phase ist die Launch Phase Phase, also das Starten der Anwendung. Die zweite Phase Test Phase stellt die Testphase dar. Die erforderlichen Testsuiten können Sie im entsprechenden Run...Phase Test-Knoten der jeweiligen Phase konfigurieren. Das mitgelieferte Beispiel stellt also ein Szenario dar, welches sich auf unterschiedliche Rollen statt auf unterschiedliche Phasen konzentriert. Falls Sie eine dritte Phase einfügen möchten, können Sie den Test-Knoten, der Test Phase kopieren, einfügen und entsprechend umbenennen.","hash":"usec_loadtestingconcept","h2":"Konzeption des Testlaufes"},"832":{"id":832,"content":"Vorbereiten der Testsysteme für den Testlauf Bevor Sie nun einen Testlauf starten können, müssen Sie auf allen Testsystem den QF‑Test Daemon starten. Dieser Daemon benötigt einen freien Netzwerkport. Es empfiehlt sich aus Effizienzgründen, auf allen Rechnern den selben Port zu verwenden, z.B. 5555. Der Daemon kann nun wie folgt gestartet werden: qftest -batch -daemon -daemonport 5555 Beispiel 33.1: Starten des QF‑Test Daemon Bitte beachten Sie, dass der Daemon bereits in einer aktiven Benutzersession gestartet werden muss. Dies können Sie z.B. mittels Aufgabenplaner erreichen. Weitere Details zur Testausführung mittels Daemon finden Sie im \"Testausführung im Daemonmodus\". Sie finden im Kapitel Aufsetzen von Testsystemen nützliche Tipps und Tricks für die Einrichtung des Daemon Prozesses. Der technische Hintergrund ist in FAQ 14 beschrieben. Die Überprüfung, ob die Daemonen auf den Testrechnern laufen, können Sie entweder mit einzelnen Ping-Kommandos des Daemons oder mittels Ausführung der mitgelieferten Testsuite checkForRunningDaemons.qft durchführen. qftest -batch -calldaemon -ping -daemonhost localhost -daemonport 5555 Beispiel 33.2: Ping des QF‑Test Daemon auf localhost Bitte verwenden Sie auf Windows den Befehl qftestc.exe statt qftest.exe für die obigen Kommandos.","hash":"usec_loadtestingsysping","h2":"Vorbereiten der Testsysteme für den Testlauf"},"833":{"id":833,"content":"Testausführung Für die Testausführung gilt es nun zu beachten, dass Sie diverse Skripte oder Software benötigen, die die unterschiedlichen QF‑Test Daemone kontaktieren können, um den Testlauf zu koordinieren. Diese Steuerungsskripte können nun die QF‑Test Daemon API (siehe \"Daemon API\") ansprechen oder die Kommandozeile (siehe \"Kommandozeilenargumente und Rückgabewerte\") verwenden. Umsetzung in der Beispieltestsuite: Mit der mitgelieferten Beispieltestsuite daemonController_twoPhases.qft sind Sie in der Lage ein Lasttestszenario auszuführen und am Ende die Protokolle wieder einzusammeln. Allerdings müssen Sie vorher noch konfigurieren, welche Systeme beim Testlauf dabei sind. Diese Systeme können Sie in der Excel-Datei qftest-10.0.2-pro/demo/loadtesting/Systems.xlsx konfigurieren. Außerdem ist es hier auch möglich die entsprechende Rolle zu konfigurieren, wie im \"Konzeption des Testlaufes\" beschrieben. Sind die Systeme korrekt konfiguriert, können Sie nun den Testlauf starten, indem Sie die gesamte Testsuite ausführen. Zusätzlich zur reinen Ausführung können Sie mit QF‑Test noch weitere Anforderungen abdecken. Folgende Anforderungen werden auch in den mitgelieferten Beispieltestsuiten erläutert: Synchronisierung von mehreren Systemen, siehe \"Synchronisierung\". Messung von End-to-End Zeiten, siehe \"Messen von End-to-End Zeiten\".","hash":"usec_loadtestingTestExec","h2":"Testausführung"},"834":{"id":834,"content":"Testauswertung Die Auswertung von Lasttests kann auf Grund der schieren Masse an Daten eine Herausforderung darstellen. Sie können QF‑Test Protokolle mit QF‑Test oder als HTML-Report auswerten. Messungen auf Server- bzw. Infrastrukturseite können mit Spezialtools analysiert werden. Natürlich stehen Ihnen noch die Logdateien Ihrer Server zur Verfügung, welche auch mit speziellen Tools ausgewertet werden können. Es besteht auch die Möglichkeit während der Ausführung mit QF‑Test eigene Protokolle für Messungen anzufertigen, mehr hierzu finden Sie im \"Messen von End-to-End Zeiten\".","hash":"sec_testauswertung","h2":"Testauswertung"},"835":{"id":835,"content":"Spezielles zur Testausführung","hash":"usec_loadtestingexectipps","h1":"Spezielles zur Testausführung"},"836":{"id":836,"content":"Synchronisierung Um reproduzierbare Ergebnisse zu erhalten, kann es nötig sein, die Tests auf den verschiedenen Systemen zu koordinieren, entweder um alle Clients möglichst gleichzeitig den Server ansprechen zu lassen, oder um genau das zu verhindern. Des weiteren könnte es eine Rolle (siehe vorigen Abschnitt) erfordern, dass alle Systeme dieser Rolle auf einen bestimmten Zeitpunkt warten, um eine Aktion auszuführen. Mehrere parallele Testläufe können mit einem Server-Skript Knoten synchronisiert werden. In diesem Skript muss folgender Aufruf enthalten sein: rc.syncThreads(\"identifier\", timeout, remote=3) Der identifier ist ein Name für den Synchronisationspunkt, timeout ist die maximale Zeit in Millisekunden, nach der alle Systeme diesen Synchronisationspunkt erreicht haben müssen und remote gibt an wie viele Rechner aufeinander warten sollen und diesen Synchronisationspunkt auch erreichen müssen. Wird das Timeout überschritten, ohne dass die gewünschte Anzahl von Systemen den Synchronisationspunkt erreicht, wird eine TestException geworfen. Um stattdessen nur einen Fehler auszugeben und den Testlauf fortzusetzen, kann dem Parameter throw der Wert 0 mitgegeben werden (Standard ist 1) oder das Server-Skript in einem Try Knoten verpackt werden. rc.syncThreads(\"case1\", 120000, remote=3, throw=0) Eine Beispielsynchronisierung findet auch in der mitgelieferten Testsuite carconfig_Loadtesting.qft statt.","hash":"usec_loadtestingsync","h2":"Synchronisierung"},"837":{"id":837,"content":"Abbildung 33.4: Der Aufruf von rc.syncThreads in der Beispieltestsuite","hash":"fig_loadtestingsyncsample","h4":"Abbildung 33.4: Der Aufruf von rc.syncThreads in der Beispieltestsuite"},"838":{"id":838,"content":"Messen von End-to-End Zeiten Eine häufige Anforderung an GUI Tests ist das Messen von End-to-End Zeiten, sowie deren schnelle Auswertung. Hierfür schreibt QF‑Test diese Zeiten zwar bereits ins Protokoll, allerdings müsste man nun nachträglich diese Formate parsen. Damit Sie diese Zeiten einfacher erhalten, kann auch ein TestRunListener genutzt werden, der von Ihnen gekennzeichnete Messpunkte aus der Testsuite in ein separates Messprotokoll schreibt. Damit nun die richtigen Messungen stattfinden, sollten Sie die Messpunkte mit einem Schlüsselwort in der Bemerkung des Knotens markieren. Im mitgelieferten Beispiel ist dies @transaction. Falls Sie ein anderes Schlüsselwort verwenden wollen, können Sie hierzu den Code des TestRunListeners anpassen. Die Messungen werden im mitgelieferten Beispiel in eine einfache CSV-Datei geschrieben, damit diese später weiterverarbeitet werden können und der Testlauf nicht zu stark ausgebremst wird. Die Aufbereitung der Daten in einer Excel-Datei oder Datenbank sollte aus Performancegründen erst nach der eigentlichen Testausführung erfolgen. Details zum TestRunListener finden Sie im \"Listener für den aktuellen Testlauf\". Sie finden eine Beispielimplementierung in der mitgelieferten Demotestsuite carconfig_Loadtesting.qft. Die erzeugte CSV-Datei sieht wie folgt aus: open vehicles;118;20150921145057;OK close vehicles;84;20150921145057;OK Beispiel 33.3: CSV-Datei für Zeitmessungen In der erzeugten CSV-Datei steht der erste Wert für die Namen der Messpunkte, der zweite für die Dauer in Millisekunden, der dritte für den Ausführungszeitpunkt und der vierte, ob der Status überhaupt erfolgreich war.","hash":"usec_loadtestingmeasurement","h2":"Messen von End-to-End Zeiten"},"839":{"id":839,"content":"Troubleshooting Durch die Komplexität eines Lasttestprojekts kann es zu unterschiedlichen Problemfeldern kommen. Es werden die falschen Testfälle ausgeführt? Hierzu passen Sie Variable testsuite in den entsprechenden Testfällen an. Es kann auch ein Testfall direkt angesprochen werden, z.B. testsuite#testfallsatz.testfall. Der QF‑Test Daemon lässt sich nicht starten. Ist der Port den überhaupt frei? Überprüfen Sie dies mit den entsprechenden netstat-Kommando. Hier ein Beispiel für den Port 5555. netstat -a -p tcp -n | findstr \"5555\" netstat -a --tcp --numeric-ports | grep 5555 Testsysteme sind nicht ansprechbar, obwohl der QF‑Test Daemon läuft. Überprüfen Sie, ob der QF‑Test Daemon läuft und dieser von Ihrem Ausführungssystem aus erreichbar ist, siehe \"Bereitstellung der Testsysteme\". Falls der QF‑Test Daemon läuft, dann führen Sie bitte folgende Schritte durch: Lässt sich der Daemon lokal mit dem Pingkommando ansprechen, siehe \"Vorbereiten der Testsysteme für den Testlauf\"? Stellen Sie sicher, dass der Daemon bzw. der dazugehörige Javaprozess nicht von der Firewall blockiert wird. Evtl. gibt es Probleme mit der Auflösung Ihres Rechnernamen. Versuchen Sie bitte den Daemon zusätzlich mit dem Parameter -serverhost localhost bzw. -serverhost IP-Adresse bzw. -serverhost <Rechnername> zu starten. Falls Sie mit der IP-Adresse starten, sprechen Sie diesen Testrechner auch mit der IP-Adresse an, sonst mit dem Rechnernamen.","hash":"usec_loadtestingtroubleshooting","h1":"Troubleshooting"},"840":{"id":840,"content":"Web-Lasttests ohne sichtbare Browser-Fenster Für den Lasttest von Web-Anwendung ist es möglich, Browser im \"headless\" Modus zu betreiben. Dies hat den Vorteil, dass ein Headless Browser kein eigenes GUI und damit keine eigene Anwendersitzung benötigt. Der GUI-Test unterliegt aber im Vergleich zu \"normalen\" Browsertests einigen Einschränkungen: Harte und semi-harte Mausklicks sowie Drag-And-Drop Operationen werden über eine Browser-Schnittstelle simuliert und können daher ein abweichendes Verhalten haben als bei \"normalen\" Browsertests. Screenshots können erstellt werden, haben aber eventuell nicht hundertprozentig die gleiche Optik wie im normalen Browser, da kein GUI vorhanden ist, das \"abfotografiert\" werden kann. Außerdem muss es die Anwendung auch selbst erlauben, dass sie in einer Anwendersitzung auf mehreren Browser-Instanzen ausgeführt wird. Weitere Informationen zu Browsern ohne sichtbares Fenster finden Sie in \"Web-Testen im Headless-Modus\".","hash":"usec_loadtestingwebheadless","h1":"Web-Lasttests ohne sichtbare Browser-Fenster"},"841":{"id":841,"content":"Pro Handbuch","hash":"","h0":"Ausführung manueller Tests mit QF‑Test | QF‑Test Handbuch"},"842":{"id":842,"content":"Pro Handbuch","hash":"home-link","h0":"Ausführung manueller Tests mit QF‑Test | QF‑Test Handbuch"},"843":{"id":843,"content":"Ausführung manueller Tests mit QF‑Test","hash":"usec_manualtester","h0":"Ausführung manueller Tests mit QF‑Test"},"844":{"id":844,"content":"Einführung QF‑Test ist in erster Linie ein Werkzeug, das GUI Tests erstellt und automatisiert auszuführt. Jedoch ist es nicht immer möglich - oder wirtschaftlich - die Tests vollständig zu automatisieren, deshalb gibt es in neben dem automatisierten Testen auch manuelle Testfälle, die auszuführen sind. Eine der größten Herausforderungen in Testprojekten ist die gemeinsame Aufbereitung der automatisierten und manuellen Testergebnisse. Eine solche gemeinsame Aufbereitung ist sehr nützlich, um einen Gesamtüberblick über die Testausführung zu erhalten. QF‑Test bietet nun die Möglichkeit Ergebnisse von manuellen und auch von automatisierten Tests gemeinsam anzuzeigen. Die Schritte eines manuellen Tests müssen hierfür an einer bestimmten Stelle definiert werden. Der ManualTestRunner von QF‑Test liefert hierfür eine Excel-Datei. Diese Testsuite sowie eine beispielhafte Excel-Datei finden Sie im Verzeichnis demo/manualtester im QF‑Test Installationsverzeichnis. Der Testdesigner muss nun die einzelnen Schritte des Tests in der Excel-Datei definieren, inklusive des erwarteten Ergebnisses. Nach Ausführung des manuellen Tests von QF‑Test aus, liefert QF‑Test sowohl das Protokoll als auch HTML-Report und zusätzlich noch eine neue Excel-Datei, die die entsprechenden Ergebnisse beinhaltet. Für eine genauere Beschreibung siehe \"Schritt-für-Schritt Anleitung\". Der Dialog zur Testausführung, der ManualStepDialog, sieht wie folgt aus:","hash":"usec_mtIntro","h1":"Einführung"},"845":{"id":845,"content":"Abbildung 34.1: Beispiel für einen ManualStepDialog Der Titel des Dialoges beinhaltet den Namen des Testfalles. Die ersten zwei Textfelder enthalten die Beschreibung des manuellen Schrittes sowie das erwartete Ergebnis. Nach Ausführung des Testschrittes muss der Tester nun angeben, ob dieser erfolgreich war oder nicht. Falls der Testschritt nicht erfolgreich gewesen sein sollte, so muss der Tester ein erhaltenes Ergebnis dokumentieren. Sie können diesen Dialog auch für Ihre eigenen Ansätze verwenden, siehe \"Die ManualStepDialog API\".","hash":"figure_34.1","h4":"Abbildung 34.1: Beispiel für einen ManualStepDialog"},"846":{"id":846,"content":"Schritt-für-Schritt Anleitung Bitte führen Sie folgende Schritte auf dem System aus, wo Sie einen manuellen Test von QF‑Test aus starten: Kopieren Sie die Excel-Datei von qftest-10.0.2-pro/demo/manualtester/SampleTestDescription.xlsx in ein projektspezifisches Verzeichnis. Wie empfehlen auf jedem Testsystem den selben Pfad zu verwenden, vielleicht ein Netzlaufwerk. Kopieren Sie auch die Ausführungstestsuite von qftest-10.0.2-pro/demo/manualtester/ManualTestRunner.qft in ein projektspezifisches Verzeichnis. Womöglich sollten Sie diese auch umbenennen. Öffnen Sie die Excel-Datei und definieren Sie die Testschritte. Nachdem Sie die Änderungen der Excel-Datei abgespeichert haben, müssen Sie die Ausführungstestsuite öffnen und die globale Variable testFile anpassen, um die projektspezifische Excel-Datei einzulesen. Schalten Sie den QF‑Test Debugger aus. Dieser würde Sie nur während der Ausführung der Tests behindern. Selektieren Sie nun den Testsuite Knoten und starten Sie die Testsuite mittels des \"Wiedergabe starten\" Knopfes. QF‑Test wird nun die Daten aus der Excel-Datei einlesen und einen Dialog mit dem ersten Testschritt anzeigen. Geben Sie das erhaltene Ergebnis ein und fahren Sie mit der Ausführung der nächsten Schritte fort. Am Ende der Testausführung erzeugt QF‑Test eine neue Excel-Datei mit den erhaltenen Ergebnissen. Sie können von QF‑Test aus nun auch das QF‑Test Protokoll speichern oder den HTML-Report erzeugen. Bitte beachten Sie auch die Kommentare in der Ausführungstestsuite und in der Excel-Datei. Sie können dieses Konzept natürlich auch an Ihre eigenen Anforderungen anpassen und sogar nur bestimmte Tests starten.","hash":"usec_mtStepByStep","h1":"Schritt-für-Schritt Anleitung"},"847":{"id":847,"content":"Aufbau der Excel-Datei Die Excel-Datei hat eine bestimmte Struktur, um einen manuellen Testfall so flexibel wie möglich zu beschreiben. Hier folgt eine genauere Beschreibung der einzelnen Spalten:","hash":"usec_mtExcelFile","h1":"Aufbau der Excel-Datei"},"848":{"id":848,"content":"Spalte Beschreibung TestCase Ein eindeutiger Bezeichner für jeden Testfall. Wird kein Bezeichner definiert, so ist der Schritt Teil des vorherigen Testfalles. Type of Test Eine optionale Beschreibung des Types des Testfalles, z.B. funktionaler Test oder Benutzerfreundlichkeits-Test. Comment Ein individueller Kommentar zu jedem Testfall. Dieser Kommentar wird als Anmerkung im QF‑Test Protokoll angezeigt. Short Description Eine Kurzbeschreibung des Testfalles. Step Description Eine genauere Beschreibung des manuellen Testschrittes. Expected Result Eine Beschreibung des erwarteten Ergebnisses. Tabelle 34.1: Beschreibung der Excel-Datei für die Testdefinition Die Excel-Datei, welche dann die Ergebnisse der manuellen Testausführung beinhaltet, hat noch zwei zusätzliche Spalten:","hash":"table_34.1","h1":"Aufbau der Excel-Datei"},"849":{"id":849,"content":"Spalte Beschreibung Received Result Das Ergebnis, welches der Tester während der Testausführung erhalten hat. Dieses Ergebnis muss gesetzt sein, wenn der Testfall fehl schlägt. State Der Status des Testfalles: PASSED, FAILED, CANCELED bzw. SKIPPED. Tabelle 34.2: Beschreibung der Excel-Datei für die Testergebnisse","hash":"table_34.2","h1":"Aufbau der Excel-Datei"},"850":{"id":850,"content":"Die Ausführungstestsuite Die Ausführungstestsuite ManualTestRunner.qft beinhaltet ein paar globale Variablen, um die Ausführung zu steuern. Variablen, die hier nicht aufgeführt werden, werden von der Testsuite intern genutzt und sollten nicht verändert werden. Hier folgt eine Beschreibung dieser Variablen:","hash":"usec_mtMTestRunner","h1":"Die Ausführungstestsuite"},"851":{"id":851,"content":"Globale Variable Beschreibung testFile Der Pfad zur Excel-Datei mit den Testschritten. testSheet Der Tabellenblatt der Excel-Datei, welche die Testschritte beinhaltet. resultSheet Der Name des Tabellenblattes, in welches die Ergebnisse geschrieben werden sollen. tests Eine Liste von Tests, die ausgeführt werden sollen. Wenn Sie diese Variable leer lassen, werden alle Tests aus der Excel-Datei ausgeführt. Falls Sie z.B. nur Test 5 und 6 ausführen wollen, dann können Sie diese Variable auf 5,6 oder 5-6 setzen. Es ist sogar möglich, Bereiche zu definieren - wie z.B. 1,3-5,7 um die Tests 1, 3, 4, 5 and 7, zu starten. defaultState Der vorbelegte Status, wenn der Dialog erscheint. Er kann entweder auf PASSED oder FAILED gesetzt werden. Jeder andere Status wird auf FAILED konvertiert. testCaseColumn Die Überschrift der Spalte für die Testfallnummer. commentColumn Die Überschrift der Spalte für den Kommentar. shortDescColumn Die Überschrift der Spalte für Kurzbeschreibung des Testschrittes. stepDescColumn Die Überschrift der Spalte für die detaillierte Beschreibung des Testschrittes. expResultColumn Die Überschrift der Spalte für das erwartete Ergebnis. recResultColumn Die Überschrift der Spalte für das erhaltene Ergebnis. stateColumn Die Überschrift der Spalte für den Status des Testschrittes. Tabelle 34.3: Beschreibung der globalen Variablen in der ManualTestRunner Testsuite","hash":"table_34.3","h1":"Die Ausführungstestsuite"},"852":{"id":852,"content":"Die möglichen Zustände Ausgeführte Testschritte können auf folgende Zustände gesetzt werden:","hash":"usec_mtStates","h1":"Die möglichen Zustände"},"853":{"id":853,"content":"Resultat Beschreibung PASSED Der Testschritt war erfolgreich. FAILED Der Testschritt war nicht erfolgreich. CANCELED Der Testschritt wurde abgebrochen. SKIPPED Der Testschritt wurde übersprungen. Tabelle 34.4: Mögliche Zustände der manuellen Testausführung","hash":"table_34.4","h1":"Die möglichen Zustände"},"854":{"id":854,"content":"Pro Handbuch","hash":"","h0":"Best Practices | QF‑Test Handbuch"},"855":{"id":855,"content":"Pro Handbuch","hash":"home-link","h0":"Best Practices | QF‑Test Handbuch"},"856":{"id":856,"content":"Best Practices","hash":"sec_BestP","h1":"Best Practices"},"857":{"id":857,"content":"Pro Handbuch","hash":"","h0":"Einführung | QF‑Test Handbuch"},"858":{"id":858,"content":"Pro Handbuch","hash":"home-link","h0":"Einführung | QF‑Test Handbuch"},"859":{"id":859,"content":"Einführung Dieser Teil des Handbuches beschreibt Best Practices basierend auf Erfahrungen aus zahlreichen GUI Testprojekten und Kundenrückmeldungen. Die beschriebenen Konzepte können Sie darin unterstützen, die beste Strategie für den Einsatz von QF‑Test in Ihren Projekten zu finden. QF‑Test ist ein sehr generisches Werkzeug. Die hier enthaltenen Tipps und Anregungen können nur als Empfehlungen unsererseits verstanden werden. Wir hoffen dadurch Ihnen dabei zu helfen, effizient und erfolgreich mit QF‑Test zu arbeiten. Natürlich führen mehrere Wege nach Rom und deshalb müssen Sie Ihren eigenen Weg finden, welcher für Sie und Ihre Anforderungen am besten geeignet ist.","hash":"sec_bpIntro","h0":"Einführung"},"860":{"id":860,"content":"Pro Handbuch","hash":"","h0":"Wie beginnt man in einem Testprojekt? | QF‑Test Handbuch"},"861":{"id":861,"content":"Pro Handbuch","hash":"home-link","h0":"Wie beginnt man in einem Testprojekt? | QF‑Test Handbuch"},"862":{"id":862,"content":"Wie beginnt man in einem Testprojekt? Dieses Kapitel beschreibt die wichtigsten Aspekte, welche berücksichtigt werden sollten, bevor Sie QF‑Test großflächig in einem Testprojekt einsetzen. Es wirft Fragen auf und versucht allgemeine Antworten mit Referenzen auf detaillierte Beschreibungen zu geben. Ziel des Kapitels ist es Ihnen einige Hinweise zu geben, worauf Sie achten sollten, um Ihre GUI-Tests verlässlich, stabil, einfach wiederholbar und vor allem wartbar zu gestalten.","hash":"sec_bpHowToStart","h0":"Wie beginnt man in einem Testprojekt?"},"863":{"id":863,"content":"Infrastruktur und Testumgebung Bevor Sie beginnen automatisierte Tests zu erstellen und auszuführen, sollten Sie sich ein paar Gedanken über die zu verwendende Testumgebung machen. Damit Sie Tests verlässlich und wiederholbar abspielen können, müssen Sie bedenken, dass Sie hierfür das SUT in einen definierten Zustand bringen sollten, inklusive dem Backend, z.B. einen Server und/oder eine Datenbank. Wenn Sie sich dessen nicht bewusst sind, kann es unter Umständen ziemlich schwierig werden, Tests wiederholbar abzuspielen oder einfach nur die Testresultate zu analysieren. Außerdem kann die Wartung der Tests zu einem Albtraum werden. Bitte bedenken Sie zusätzlich noch folgende Themen: Wie sieht der Initialzustand des SUT aus? Welcher Benutzer wird verwendet um die Tests in der SUT abzuspielen? Die meisten Projekte arbeiten mit dedizierten Testbenutzern. Ein anderer Ansatz ist, dass jeder Tester mit seinen eigenen Testbenutzer arbeitet. Welche Spracheinstellung des SUT wird hauptsächlich verwendet? Ist es wirklich notwendig eine volle Sprachabdeckung über alle unterstützten Sprachen zu erreichen? Oder genügt es, die gesamten Testfälle auf einer speziellen Sprache auszuführen und nur ein paar ausgesuchte für die Lokalisierungstests zu verwenden? In den meisten Fällen deckt das Wiederholen der Testfälle in unterschiedlichen Sprachen dieselbe Funktionalität ab und Sie erlangen dadurch keine neuen Informationen über das SUT. Wenn Sie sich trotzdem entschließen mit mehreren Spracheinstellungen zu testen, könnte dies die Wiedererkennung der grafischen Komponenten beeinflussen, siehe \"Wie erreicht man eine robuste Komponentenerkennung?\". Wie sieht der Initialzustand der Datenbank aus? Können Sie mit einer separaten Testdatenbank arbeiten oder benutzen Sie eine Produktionsdatenbank? Testdatenbanken können geplante Testdaten beinhalten, wohingegen Produktionsdatenbanken wirkliche Daten aus der realen Umgebung beinhalten. Sind diese Daten vorhersagbar und verlässlich? Was passiert, wenn Ihre Daten durcheinander kommen oder gar zerstört werden? Sie sollten in jedem Fall keine automatisierten Tests auf der Produktionsumgebung ausführen. Können Sie Ihre Testumgebung nach einem Testlauf wieder auf den Ausgangszustand zurücksetzen, um den Testlauf zu wiederholen? Ist es möglich, Änderungen in der Datenbank zurückzunehmen oder benötigt jeder neue Testlauf neue Testdaten? Wie können Testdaten gelesen bzw. geschrieben werden? Können Sie hierfür Standard SQL-Skripte verwenden oder gibt es Bibliotheken von der Entwicklung? Einige Projekte setzen sogar die Datenbank vor jedem Testlauf komplett neu auf, weil sie weder Testdaten wiederverwenden noch die Datenbank korrekt säubern können. Wollen Sie QF‑Test mit anderen Werkzeugen, z.B. Build- oder Testverwaltungswerkzeuge, integrieren? Wie integriert man QF‑Test in eine Testverwaltung? Wenn Sie bereits geplante Testschritte wiederverwenden können, dann vermeiden Sie redundante Arbeit in der Testplanungsphase. Einige Standardintegrationen sind unter \"Anbindung an Testmanagementtools\" beschrieben. Sollen Tests von einem Buildtool gestartet werden? Nachdem Sie Tests erstellt haben, können Sie diese unbeaufsichtigt ausführen und diesen Testlauf von einem Buildtool, z.B. Ant oder CruiseControl, anstoßen. Für Details über Testausführung, siehe \"Testausführung\". Sollen Testresultate in ein Reporting- oder Testverwaltungssystem hochgeladen werden oder reicht es den erzeugten HTML-Report und die Protokolle auf einen zentralen HTTP-Server zu legen? Wer wird mit QF‑Test arbeiten? Arbeiten nur ein oder zwei Tester mit QF‑Test oder werden auch mehrere Entwickler und Fachtester in die Testentwicklung miteinbezogen? Im Abschnitt \"Rollen und Zuständigkeiten\" finden Sie einige Tipps für das Arbeiten im Team. Wie sind die Kenntnisse der Tester? Sie sollten mindestens eine dedizierte Person mit guten QF‑Test Kenntnissen im Team haben, welche auch in der Lage ist, Skripte zu implementieren und Softwareentwicklungsprinzipien versteht. Natürlich werden in Ihrem Projekt noch weitere Punkte auftauchen. Denken Sie einmal darüber nach.","hash":"sec_bpInfrastructure","h1":"Infrastruktur und Testumgebung"},"864":{"id":864,"content":"Speicherorte Sie sollten sich überlegen, wohin Sie bestimmte Dateien legen bzw. installieren wollen: Wo soll QF‑Test installiert werden? QF‑Test kann lokal auf jedem Rechner installiert werden. Dieses Vorgehen zwingt Sie allerdings wiederum, neue Versionen auf jedem Rechner einzeln zu installieren. Alternativ können Sie QF‑Test auf einem Netzlaufwerk installieren, wenn Ihr Netzwerk verlässlich funktionieren sollte. Details hierzu finden Sie unter \"Netzwerkinstallation\". Wo soll die Konfigurationsdatei qftest.cfg abgelegt werden? Diese Datei beinhaltet u.a. wie QF‑Test die grafischen Komponenten wiedererkennt oder was im Protokoll gespeichert werden soll. Diese Einstellungen müssen für jeden QF‑Test Benutzer dieselben sein, sonst können keine Tests im Team geteilt werden. Damit Sie dieselbe Datei verwenden, können Sie QF‑Test entweder zentral auf einem Netzlaufwerk installieren oder Sie geben den Pfad zur Konfigurationsdatei als Kommandozeilenparameter beim Start von QF‑Test mit. Wenn Sie mit einer Datei auf einem Netzlaufwerk arbeiten, dann stellen Sie sicher, dass diese Datei schreibgeschützt ist und nur bestimmte Benutzer diese ändern können. Details finden Sie unter \"Konfigurationsdateien\". Wo soll die Lizenzdatei license liegen? Sie sollten die Lizenzdatei an einer zentralen Stelle ablegen, damit Sie die Lizenz nur einmal aktualisieren müssen, wenn Sie ein Update erhalten. Hier können Sie ebenfalls entweder an eine zentrale Netzwerkinstallation von QF‑Test denken oder einen Kommandozeilenparameter beim Start von QF‑Test verwenden. Details finden Sie unter \"Lizenzdatei\". Wo sollen Testsuiten gespeichert werden? Der beste Speicherort für Testsuiten ist ein Versionsmanagementsystem, womit Sie Änderungen verfolgen und auf jede Version der Datei zugreifen können. Wenn dies nicht möglich sein sollte, dann sollten die Dateien auf einem zentralen Netzlaufwerk installiert werden. Wo sollen die Testdatendateien gespeichert werden? Testdatendateien gehören immer zu Testsuiten und sollten daher nahe an diesen abgelegt werden, d.h. im selben Versionsmanagementsystem oder Netzlaufwerk. Wo sollen die HTML-Reports und Protokolle abgelegt werden? Diese Dateien sollten an einer zentralen Stelle liegen, auf die jeder Tester zugreifen und die Testresultate auswerten kann. Die meisten Kunden legen diese auf einen zentralen HTTP Server oder einen Netzlaufwerk ab.","hash":"sec_bpLoc","h1":"Speicherorte"},"865":{"id":865,"content":"Netzwerkinstallation Wenn Sie planen QF‑Test auf einem Netzlaufwerk zu installieren, müssen Sie einige Dinge beachten. Der kritische Punkt ist die Konfigurationsdatei qftest.cfg. Es ist empfehlenswert (und notwendig), dass alle Tester dieselben Einstellungen verwenden, besonders für die Wiedererkennung. Dies erreichen Sie durch Sharen dieser Datei. Jedoch sollten Sie darauf achten, dass sie schreibgeschützt ist, damit ein Benutzer nicht unabsichtlich die Einstellungen verändert. Da QF‑Test vorgenommene Änderungen so nicht beim Beenden speichern kann. Jede gewollte Änderung sollte durchgeführt werden, in dem Sie die Datei explizit mit Schreibrechten versehen, dann QF‑Test beenden, und danach die Schreibrechte wieder entziehen. Eine andere Möglichkeit ist, dass jeder Benutzer, seine eigene Konfigurationsdatei benutzt, z.B. mittels dem Kommandozeilenparameter -systemcfg <Datei>, aber das ist nicht empfehlenswert. Die laufenden QF‑Test Instanzen teilen sich auch das Logverzeichnis (internes Logging, das kein Problem darstellt) und den Jython Package Cache, welcher gelegentlich Probleme verursacht. In diesem Fall kann QF‑Test den Jythoninterpreter nicht mehr initialisieren. Das passiert sehr selten und kann mit Säuberung (nicht kompletten Löschens) des Jython Cache Verzeichnisses behoben werden. Auf Windows sollte jeder Benutzer die Datei setup.exe ausführen, damit die aktuelle QF‑Test Version, die sich im installierten qftest-x.y.z. Verzeichnis befindet, mit den entsprechenden Windowseinstellungen in der Registry verknüpft wird. In sehr seltenen Fällen kann das Überschreiben von Jar-Dateien von QF‑Test beim Einspielen eines QF‑Test Patches, bereits laufende Instanzen auf Windows zum Absturz bringen.","hash":"sec_bpNetworkInstallation","h2":"Netzwerkinstallation"},"866":{"id":866,"content":"Wiedererkennung von Komponenten Der wichtigste Aspekt eines GUI Testtools ist eine stabile und verlässliche Wiedererkennung der grafischen Komponenten. In diesem Bereich ist QF‑Test sehr flexibel und bietet unterschiedliche Konfigurationsmöglichkeiten. In den meisten Fällen reicht die Standardkonfiguration der Komponentenerkennung aus, allerdings müssen Sie diese manchmal anpassen. Wenn Sie die Komponentenerkennungseinstellungen nach Erstellen mehrerer Testfälle ändern, laufen Sie Gefahr, dass diese Testfälle nicht mehr lauffähig sind. Deshalb sollten Sie so früh wie möglich versuchen eine angemessene Erkennungsstrategie für Ihr Testprojekt zu finden. Sie sollten sich diese Zeit in jedem Fall nehmen und diesen Bereich wirklich genau ansehen, bevor Sie viele Testfälle kreieren. Im schlimmsten Fall müssen Sie alle bereits erstellten Testfälle neu erstellen, nachdem Sie die Erkennungseinstellungen verändert haben. Am besten erstellen Sie einige Demotestfälle und versuchen herauszufinden, wie QF‑Test die Komponenten Ihres SUT erkennt. Der Wiedererkennungsmechanismus ist in den Kapiteln \"Komponenten\" und \"Unterelemente: Adressierung relativ zur übergeordneten Komponente\" beschrieben. Wenn Sie die Demotestfälle, im Idealfall mit einer anderen SUT Version, ausführen und auf Wiedererkennungsprobleme stoßen, versuchen Sie folgende Punkte zu klären: Gibt es genügend Synchronisationspunkte, wie Warten auf Komponente oder Check Knoten mit Wartezeiten, um die Testschritte nur dann auszuführen, wenn das SUT wirklich bereit dazu ist? Beispiel 1: Nach Öffnen eines Fenster können Sie Aktionen nur dann darin ausführen, wenn es wirklich schon vorhanden ist -> Verwenden Sie einen Warten auf Komponente Knoten. Beispiel 2: Nachdem Sie auf einen \"Suchen\" Knopf geklickt haben, können Sie erst dann fortfahren, wenn die Suche wirklich beendet ist -> Verwenden Sie einen Check Knoten mit Wartezeit. Ein weiterer Punkt neben Synchronisationspunkten ist die richtige Einstellung für die Komponentenerkennung. Sie sollten folgende Punkte vorab klären, um herauszufinden, welche Einstellung für Sie die geeignetste ist: Werden eindeutige und stabile Namen für die Komponenten von den Entwicklern vergeben? Siehe \"Fenster, Komponenten und Elemente\" für Details. Vielleicht reicht es aus, einen regulären Ausdruck im Merkmal Attribut der Komponente des Hauptfensters unter des Fenster und Komponenten Knotens zu setzen? Siehe \"Verwendung von regulären Ausdrücken oder Arbeiten mit dynamischen Fenstertiteln\" für Details. Wenn die Entwicklung keine benutzbaren oder sogar dynamische Namen vergeben haben, dann könnten Sie dies mit einem NameResolver lösen. Siehe \"Wie erreicht man eine robuste Komponentenerkennung?\". Müssen Sie vielleicht die QF‑Test Wiedererkennungsoptionen ändern? Diese sind im Kapitel \"Wie erreicht man eine robuste Komponentenerkennung?\" beschrieben. Ist es denkbar, generische Komponente einzusetzen? Siehe \"Generische Komponenten\". In einigen Fällen reicht es aus, einfach die Standardkonfiguration zu ändern. Angenommen die Entwicklung hat eindeutige und stabile Namen für die Zielkomponenten vergeben, d.h. für Buttons, Textfelder, Checkboxen etc., dann können Sie einfach die 'Gewichtung von Namen' Option von QF‑Test auf 'Name übertrifft alles' setzen. Diese Einstellung teilt QF‑Test mit, Änderungen in der Komponentenhierarchie zu ignorieren und nur mit der eigentlichen Zielkomponente und deren Fenster zu arbeiten. Sie müssen diese Option an zwei Stellen ändern. Einmal unter 'Aufnahme' -> 'Komponenten' -> 'Gewichtung von Namen' und einmal unter 'Wiedergabe' -> ' Wiedererkennung' -> 'Gewichtung von Namen'. Siehe \"Wie erreicht man eine robuste Komponentenerkennung?\" für mehr Informationen.","hash":"sec_bpComponentRec","h1":"Wiedererkennung von Komponenten"},"867":{"id":867,"content":"Pro Handbuch","hash":"","h0":"Organisation von Testsuiten | QF‑Test Handbuch"},"868":{"id":868,"content":"Pro Handbuch","hash":"home-link","h0":"Organisation von Testsuiten | QF‑Test Handbuch"},"869":{"id":869,"content":"Organisation von Testsuiten Eine der herausforderndsten Aufgaben eines Testprojektes ist, die Testsuiten über einen langen Zeitraum wartbar zu gestalten. Besonders dann, wenn sich das eine oder andere Fenster oder sogar der Bedienungsablauf signifikant ändert, sollte der Wartungsaufwand so minimal wie möglich sein. Sie sollten auch darüber nachdenken wie man den Erstellungsaufwand von Tests minimiert; insbesondere, wenn diese eine große Menge an ähnlichen oder sogar gleichen Schritten beinhalten. Ein typischer Anwendungsfall ist das Starten des SUT oder ein Login-Prozess oder ein sehr wichtiger Basisworkflow wie das Navigieren zu einem bestimmten Punkt des SUTs. Ein weiterer Aspekt ist, wie Testsuiten effizient organisiert werden, wenn unterschiedliche Leute im Projekt involviert sind. Auf jeden Fall sollten Sie Ihre Testsuiten in einem QF‑Test Projekt, wie unter \"Projekte\" beschrieben erstellen, um einen besseren Überblick über Ihre Testsuiten und Verzeichnisse zu bekommen. Die folgenden Abschnitte zeigen nun einige Best Practices auf, wie Sie Tests wartbar, erweiterbar und gut organisiert gestalten können.","hash":"sec_bpOrganize","h0":"Organisation von Testsuiten"},"870":{"id":870,"content":"Organisation von Tests In \"Testfallsatz und Testfall Knoten\" werden die Konzepte der Testfallsatz und Testfall Knoten beschrieben. Ein Testfall Knoten steht für einen dedizierten Testfall und seine Testdaten. Ein typischer Testfall kann von Use Cases, von Anforderungen oder von einer Defektbeschreibung in Ihrer Umgebung abgeleitet werden, z.B. 'Kalkulation des Preises von Fahrzeug xyz mit 10% Rabatt' in der CarConfigurator Applikation. Testfallsatz Knoten sind Sammlungen von Testfallsätze und Testfälle. Diese Knoten können Sie für die Strukturierung von Testfällen einsetzen, z.B. 'Tests für Preiskalkulation'. Testschritt Knoten repräsentieren individuelle Testschritte eines Testfall Knotens, wie 'Öffne das Fenster' oder 'Prüfe Berechnung'. Falls Sie eine externe Beschreibung des Testfalls oder andere relevante Informationen mit dem Testfall verknüpfen wollen, dann sollten Sie einen HTML-Link in das Bemerkung Attribut des Testfall Knotens aufnehmen. Sie werden diesen Link auch später im Report sehen. Des Weiteren ist es möglich, eine separate Testdokumentation mittels der Menüaktion »Datei«-»Testdoc erstellen« zu erzeugen. Weitere Details über die Dokumentation finden Sie unter \"Reports und Testdokumentation\". Der Report und die Testdokumentation können auch Testschritt Knoten, welche in Testfall Knoten benutzt werden, beinhalten. Wenn ein Testfall aus vielen Prozeduraufrufen oder Sequenzen besteht, dann sollten Sie die einzelnen Testschritte in Testschritt Knoten organisieren. Diese Testschritt Knoten haben den Vorteil, dass Sie jeden relevanten Testschritt in QF‑Test auf einen Blick sehen und diese auch im Report nach der Ausführung aufgeführt werden. Wenn Sie mehrere Knoten in einem Testschritt zusammenfassen wollen, dann können Sie diese Knoten in einen Testschritt packen. Hierzu selektieren Sie die betroffenen Knoten, führen einen Rechtsklick aus und wählen »Knoten einpacken«-»Testschritt« im Kontextmenü aus.","hash":"sec_bpOrganizingTests","h1":"Organisation von Tests"},"871":{"id":871,"content":"Modularisierung Eines der wichtigsten Konzepte einer effektiven Testautomatisierung ist die Modularisierung. Modularisierung in diesem Bereich steht für das Ablegen von wiederverwendbaren Sequenzen an einer bestimmten Stelle, damit diese von überall her aufgerufen werden können, wenn möglich. Dieses Konzept ermöglicht es Ihnen, eine Sequenz nur einmal zu erstellen, aber diese so oft wie benötigt zu benutzen ohne die Sequenz erneut aufzuzeichnen. Falls sich das SUT in einer dieser wiederverwendbaren Sequenzen ändern sollte, z.B. eine Änderung eines Basisworkflows, dann müssen Sie diese Änderung nur an einer Stelle, nämlich der wiederverwendbaren Sequenz, anpassen und nicht in mehreren Testfällen in unterschiedlichen Testsuiten. Modularisierung wird in QF‑Test mittels Prozedur Knoten realisiert. Prozeduren sind im \"Prozeduren und Packages\" beschrieben. Wenn Sie eine große Menge an Testfällen haben, sollte fast jeder Testschritt eine Prozedur sein und Sie könnten diese Prozeduren vorab erstellen, wenn möglich. Danach können Sie die Testfälle mit diesen Prozeduren füllen und das nur mittels Hinzufügen des jeweiligen Prozeduraufruf Knotens. In größeren Projekten kann es ebenfalls nützlich sein, Prozeduren in unterschiedlichen Schichten zu erstellen, z.B. komponentenspezifische Prozeduren wie 'Klick auf OK' und workflowspezifische Prozeduren wie 'Ein Fahrzeug anlegen'.","hash":"sec_bpModul","h1":"Modularisierung"},"872":{"id":872,"content":"Parametrisierung Das Konzept der Modularisierung ermöglicht es, Testschritte an einer zentralen Stelle zu pflegen. Aber was ist mit den Testdaten für verschiedene Tests? Wenn Sie eine Prozedur erstellt haben, welche mit unterschiedlichen Testdaten aufgerufen werden kann, z.B. ein typischer 'Login' Ablauf mit Benutzernamen und Passwort oder die 'Zubehör auswählen' Prozedur des CarConfigurators, dann können Sie Variablen in den QF‑Test Knoten verwenden. Diese Variablen sollten für einen Texteingabe Knoten, für die Auswahl von Elementen in einer Liste oder Tabelle oder Auswahl eines Baumknotens verwendet werden. Wenn eine Prozedur Variablen benötigt, dann sollten Sie diese in der Liste Variablendefinitionen definieren. Dies dient dazu, eine Liste aller benötigten Parameter bei jedem Einfügen eines Prozeduraufruf Knotens der Prozedur zu bekommen. Einige Kunden benutzen für diese Standardwerte sogar Dummywerte, damit man sofort merkt, dass ein Parameter nicht vom Test initialisiert wurde. Der nächste Schritt ist nun, die Variablen vom Prozeduraufruf entweder in die Variablendefinitionen Liste des Testfall Knotens oder in einen Datentreiber mit einer Datentabelle oder sonstigen externen Datenquelle zu verschieben. Variablen und Parameter sind im \"Prozeduren und Packages\" beschrieben. Parameter können auch automatisch erstellt werden, siehe \"Parametrisieren von Knoten\". Sie finden weitere Details über das Datentreiber Konzept für das Laden von Testdaten aus Datenquellen in \"Datengetriebenes Testen\".","hash":"sec_bpParam","h1":"Parametrisierung"},"873":{"id":873,"content":"Arbeiten in mehreren Testsuiten Bis jetzt haben Sie die Modularisierung und Parametrisierung Konzepte kennen gelernt, mit denen Sie redundante und damit nicht notwendige Arbeiten während der Testerstellung vermeiden können. Sie sollten gemerkt haben, dass sich mit diesen Konzepten natürlich auch der Wartungsaufwand der Testsuiten im Falle von Änderungen reduzieren lässt, da Sie Änderungen nur einmal statt öfters durchführen. Aber wie können wir die Arbeit für mehrere Testentwickler oder für ein sehr großes Projekt mit vielen GUI-Komponenten aufteilen? Die Antwort für eine effektive Arbeitsorganisation kommt wiederum aus der Softwareentwicklung. Wir sollten unterschiedliche 'Bibliotheken' für unterschiedliche Bereiche und unterschiedliche Zuständigkeiten erstellen. Verbinden von Testsuiten untereinander ermöglicht es Ihnen, eine Kapselung der Testsuiten durchzuführen. Eine typische Struktur in Projekten könnte in etwa so aussehen:","hash":"sec_bpWork","h1":"Arbeiten in mehreren Testsuiten"},"874":{"id":874,"content":"Abbildung 37.1: Struktur mit mehreren Testsuiten Ebene 0 beinhaltet Testschritte (d.h. Prozeduren), welche für fast alle Testfälle im Projekt von Interesse sind. Solche Testschritte sind beispielsweise 'SUT starten' oder 'Login ausführen'. Ebene 1 enthält Testschritte für bestimmte Bereiche des SUT. Für den CarConfigurator könnte man sich beispielsweise die Testsuite 'Fahrzeuge', welche Prozeduren wie 'Fahrzeug erstellen' oder 'Fahrzeug löschen' beinhaltet, und eine weitere Testsuite 'Zubehör', welche Prozeduren wie 'Zubehör anlegen' oder 'Zubehör löschen' beinhaltet, vorstellen. Ebene 2 ist die Testfallebene. Diese beinhaltet Testfälle und Testfallsätze für einen bestimmten Bereich des SUT, z.B. 'Tests für Anlage von Fahrzeugen' oder 'Tests für Löschen von Zubehör'. Es ist auch möglich sich Testsuiten, wie 'Integrationstests', welche Testschritte aus unterschiedlichen Bereichen der Ebene 1 und Ebene 0 aufrufen, auszudenken. Ebene 3 ist die so genannte Szenarioebene. Diese Testsuiten beinhalten normalerweise nur Testaufrufe aus Ebene 2 und stehen für unterschiedliche Szenarien, z.B. 'Nächtliches Testszenario', 'Fehlerverifikationsszenario' oder 'Schnelle Buildverifikation'. Die Struktur, die in diesem Dokument beschrieben wird, ist natürlich nur als Vorschlag und eine mögliche Lösung zu sehen, wie man Testsuiten organisiert. Das ist keine strenge Regel, die unbedingt befolgt werden muss. Sie könnten auch Ebene 1 in eine GUI-Komponenten-Ebene und eine Workflow-Ebene aufteilen oder Ebene 2 und Ebene 3 zusammenlegen. Welche Struktur Sie schlussendlich verfolgen, hängt auch von den Erfahrungen und Fähigkeiten Ihrer im Projekt involvierten Testentwickler ab. Der 'Include'-Bereich von Ebene-1-Testsuiten sieht wie folgt aus:","hash":"fig_advBpLibs","h4":"Abbildung 37.1: Struktur mit mehreren Testsuiten"},"875":{"id":875,"content":"Abbildung 37.2: 'Include'-Bereich von Ebene-1-Testsuiten Sie finden genauere Informationen über das Inkludieren von Testsuiten unter \"Der Aufruf einer Prozedur in einer anderen Testsuite\" und \"Auflösen von inkludierten Dateien\". Im \"Erweitern von Testsuiten\" finden Sie eine Schritt-für-Schritt Beschreibung, wie Sie bereits erstellte Testsuiten erweitern können. Im \"Ablage von Komponenten\" finden Sie Strategien für die Verwaltung von Komponenten.","hash":"fig_advBpIncludes","h4":"Abbildung 37.2: 'Include'-Bereich von Ebene-1-Testsuiten"},"876":{"id":876,"content":"Rollen und Zuständigkeiten Wenn Sie einen näheren Blick auf den vorigen \"Arbeiten in mehreren Testsuiten\" werfen, können Sie feststellen, dass man Testsuiten auch anhand von unterschiedlichen Fähigkeiten der Tester strukturieren kann.","hash":"sec_bpRoles","h1":"Rollen und Zuständigkeiten"},"877":{"id":877,"content":"Abbildung 37.3: Struktur von Testsuiten mit Rollen Ebene 0 und Ebene 1 erfordern gute Kenntnisse in QF‑Test, aber nicht unbedingt ein tiefes Wissen über das SUT. Andererseits erfordern Ebene 2 und Ebene 3 sehr gute Kenntnisse des SUT und der geplanten Testfälle, allerdings kein großes Wissen über QF‑Test, so lange diese nur Prozeduren von Ebene 0 und Ebene 1 verwenden. Tester, die in Ebene 0 und Ebene 1 arbeiten, sollten in der Lage sein, Skripte oder Kontrollstrukturen (wie das Try/Catch Konzept), welche die Erstellung einer mächtigen Testbibliothek ermöglichen, umzusetzen. Mindestens einer dieser Tester sollte auch über ein sehr gutes Wissen verfügen, wie die QF‑Test Komponentenerkennung funktioniert. Diese ist beschrieben in den Kapiteln \"Komponenten\", \"Unterelemente: Adressierung relativ zur übergeordneten Komponente\" und \"Wie erreicht man eine robuste Komponentenerkennung?\". Falls Sie alleine in einem Projekt arbeiten, sollten Sie zumindest Tests und Prozeduren voneinander trennen, um die Wartbarkeit zu erleichtern. Arbeiten in mehreren Testsuiten ist einfacher als alles in einer großen Testsuite zu halten.","hash":"fig_advBpLibsRoles","h4":"Abbildung 37.3: Struktur von Testsuiten mit Rollen"},"878":{"id":878,"content":"Komponenten in unterschiedlichen Ebenen verwalten Wenn Sie den Ansatz des vorigen Abschnittes (\"Arbeiten in mehreren Testsuiten\") befolgen, dann müssen Sie noch klären, wo die Komponenten abgelegt werden sollen. Hier gibt es zwei Möglichkeiten: Speichern Sie alle Komponenten in Ebene 0. Aufteilen der Komponenten analog zu den Prozeduren in unterschiedliche Bereiche. Es ist die einfachste Lösung, alle Komponenten in Ebene 0 zu speichern. Allerdings führt das zu sehr häufigen Änderungen von Ebene 0, nur weil sich einige Komponenten geändert haben. Sie müssen auch Zuständigkeiten definieren und eine saubere Struktur beibehalten. In großen Projekten können Sie sich überlegen, allgemeine Komponenten wie die Loginmaske und die Navigationselemente - also Komponenten, die für jeden wichtig sind - in Ebene 0 zu speichern. Komponenten, welche nur für einen bestimmten Bereich interessant sind, sind allerdings in der jeweiligen Testsuite der Ebene 1 zu speichern, z.B. ein Fahrzeugdialog für den CarConfigurator sollte nur in der Fahrzeuge.qft Testsuite gespeichert werden. Der Arbeitsablauf wie man Komponenten zwischen unterschiedlichen Testsuiten verschiebt ist im \"Ablage von Komponenten\" beschrieben. Eine Beschreibung, wie man bereits bestehende Testsuiten erweitert, finden Sie in \"Erweitern von Testsuiten\".","hash":"sec_bpTSHandlingComponents","h1":"Komponenten in unterschiedlichen Ebenen verwalten"},"879":{"id":879,"content":"Umgekehrte Includes Für Testsuiten die zu einem QF‑Test Projekt gehören, wie unter \"Projekte\" beschrieben, brauchen Sie sich nicht um Abhängige Dateien zu kümmern. QF‑Test übernimmt die Anpassungen der Testsuiten automatisch für Sie. Wenn Sie mit unterschiedlichen Testsuiten arbeiten, dann kommt es manchmal vor, dass Sie eine Prozedur oder einen Testfall umbenennen oder verschieben. Falls Sie das tun, werden die Referenzen zu dieser Prozedur oder zum Testfall in anderen Testsuiten nicht angepasst. Wenn Sie diese Änderungen auch zu anderen Testsuiten propagieren wollen, müssen Sie diese Testsuiten im Attribut Abhängige Dateien des Wurzelknotens der Bibliothek pflegen. Wenn Sie den Ansatz aus \"Arbeiten in mehreren Testsuiten\" folgen, sollten Sie sicherstellen, dass Ebene 0 'Umgekehrte Includes' auf alle Suiten von Ebene 1, Ebene 1 auf Ebene 2 und Ebene 2 auf Ebene 3 enthält. Ein Beispiel aus den Demotestsuiten finden Sie in \"'Include'-Bereich von Ebene-1-Testsuiten\".","hash":"sec_bpRevInclude","h1":"Umgekehrte Includes"},"880":{"id":880,"content":"Pro Handbuch","hash":"","h0":"Effiziente Arbeitstechniken | QF‑Test Handbuch"},"881":{"id":881,"content":"Pro Handbuch","hash":"home-link","h0":"Effiziente Arbeitstechniken | QF‑Test Handbuch"},"882":{"id":882,"content":"Effiziente Arbeitstechniken Dieses Kapitel beschreibt hilfreiche Arbeitstechniken, um unnötigen Mehraufwand beim Arbeiten mit QF‑Test zu vermeiden.","hash":"sec_bpEffectiveWork","h0":"Effiziente Arbeitstechniken"},"883":{"id":883,"content":"Arbeiten mit QF‑Test Projekten Im vorigen Kapitel wurde die Erstellung von mehreren Testsuiten beschrieben. Wie Sie sich sicher vorstellen können, werden sich während der Entwicklung einige Testsuiten ansammeln. Um hier einen besseren Überblick über die bestehenden Suiten zu bekommen, sollten Sie ein QF‑Test Projekt erstellen. QF‑Test Projekte ermöglichen Ihnen eine sehr gute Übersicht über die involvierten Testsuiten. Des Weiteren sind Projekte auch dafür zuständig, Änderungen an Testsuiten bei Bedarf an aufrufende Testsuiten automatisch weiterzugeben. Nähere Informationen hierzu finden Sie unter \"Projekte\".","hash":"sec_bpUseProjects","h1":"Arbeiten mit QF‑Test Projekten"},"884":{"id":884,"content":"Erstellung von Testsuiten Im vorigen Kapitel wurde die Erstellung von wartbaren Testsuiten mittels Prozeduren und Variablen in QF‑Test beschrieben. Normalerweise beginnen Anwender damit, sehr lange Sequenzen aufzuzeichnen und diese dann in kleinere Bereiche und später dann in Prozeduren aufzuteilen. Allerdings ist dieses Aufteilen manchmal ziemlich schwierig und zeitaufwendig, weil Sie die gesamte Sequenz durchgehen und entsprechende Grenzen finden müssen. Ein weiterer Nachteil ist, dass Sie nicht sofort erkennen, welche Schritte Sie bereits in bestehenden Testfällen oder Prozeduren erstellt haben. Stattdessen empfehlen wir, Tests und deren Schritte im Voraus zu planen. Diese Planung sollte auch die verwendeten und benötigten Prozeduren umfassen. Damit können Sie dann Prozedur für Prozedur einzeln aufzeichnen. Wir kamen zum Schluss, dass eine vorausschauende Aufzeichnung, besonders für größere Teams, sehr hilfreich ist. Ein typischer Workflow für die Testerstellung könnte in etwa so aussehen: Zuerst planen Sie die benötigten Prozeduren. Planen Sie auch die benötigte Packagestruktur. Zeichnen Sie jede Prozedur als separate Sequenz auf. Benennen Sie die aufgezeichnete Sequenz so um, wie die Prozedur heißen würde. Konvertieren Sie diese Sequenz nun in eine Prozedur, mittels der »Knoten konvertieren« Aktion aus dem Kontextmenü. Schieben Sie die Prozedur nun an die entsprechende Stelle unter Prozeduren. Ersetzen Sie Testdaten durch Variablen. Dies können Sie entweder manuell oder automatisch (siehe \"Parametrisieren von Knoten\" erledigen. Legen Sie die benötigten Variablen im Variablendefinitionen Attribut des Prozedur Knotens an. Eventuell können Sie auch Standardwerte vergeben. Beschreiben Sie die Prozedur im Bemerkung Attribut, siehe \"Dokumentieren von Testsuiten\". Ein alternativer Ansatz zur Erstellung von Prozeduren kann deren automatische Erstellung sein. Dieses Konzept ist im \"Automatisierte Erstellung von Basisprozeduren\" beschrieben.","hash":"sec_bpRecording","h1":"Erstellung von Testsuiten"},"885":{"id":885,"content":"Die Standardbibliothek qfs.qft QF‑Test liefert eine Standardbibliothek qfs.qft aus, die in jeder Testsuite inkludiert ist. Diese Suite enthält viele hilfreiche Prozeduren, um auf Komponenten, Datenbanken oder das Dateisystem zuzugreifen. Bitte werfen Sie immer einen Blick in diese Testsuite, bevor Sie etwas selber versuchen zu lösen, was eventuell schon einmal von uns gelöst wurde.","hash":"sec_bpStandardLibrary","h1":"Die Standardbibliothek qfs.qft"},"886":{"id":886,"content":"Ablage von Komponenten QF‑Test zeichnet jede neue Komponente in der Testsuite auf, in der die Aufzeichnung gestoppt wurde, deshalb könnte es passieren, dass Komponenten in einer falschen Testsuite abgelegt werden. Wenn Sie nun diese Komponenten in eine andere Testsuite verschieben wollen, sollten Sie dies immer mit der Menüaktion »Datei«-»Importieren« der Zieltestsuite ausführen. Stellen Sie sicher, dass beide Testsuiten zum selben Projekt gehören, oder dass Sie hierfür ein korrektes 'Inkludierte Dateien'/'Abhängige Dateien' Verhältnis zwischen den beiden Testsuiten erstellt haben. Der dazugehörige Arbeitsablauf ist detailliert im \"Die Verwaltung von Komponenten\" beschrieben. Um Ihre Komponentenstruktur sauber zu halten, können Sie zuerst die Testsuite in sich selbst importieren. Danach können Sie den Fenster und Komponenten Knoten selektieren und nach einem Rechtsklick die Menüaktion »Ungenutzte Komponenten markieren...« auswählen. Sie bekommen nun eine Liste aller Komponenten, die nicht im Projekt verwendet werden. Wenn Sie sich sicher sind, dass diese Komponenten gelöscht werden können, selektieren Sie im Kontextmenü des Fenster und Komponenten Knoten den Eintrag »Ungenutzte Komponenten entfernen«. Sobald eine Komponente Informationen im Kommentarfeld enthält wird diese als \"genutzt\" betrachtet, selbst wenn es keine direkten Referenzen auf die Komponenten gibt.","hash":"sec_bpWorkWithComponents","h1":"Ablage von Komponenten"},"887":{"id":887,"content":"Erweitern von Testsuiten Sie können bestehende Testsuiten auf unterschiedliche Arten erweitern: Sie zeichnen einfach die neuen Schritte in der Testsuite direkt auf. Sie arbeiten mit einer Erweiterungssuite wie im \"Verteilte Entwicklung von Tests\" beschrieben. Wenn Sie Erweiterungen direkt in einer Testsuite vornehmen, indem Sie in der entsprechenden Testsuite auf 'Aufnahme stoppen' klicken, dann müssen Sie darauf achten, dass die Komponenten eventuell in einer anderen Hierarchie aufgezeichnet werden könnten. Das kann passieren, wenn Sie die aufgezeichnete Komponentenhierarchie unter Fenster und Komponenten verändert haben. Des Weiteren kann das Verschieben von einzelnen Komponenten schwierig werden. Wenn Sie mit einer Erweiterungssuite arbeiten und darin neue Testschritte erstellt haben, können Sie die aufgezeichneten Komponenten und erstellten Prozeduren und Tests auf einmal in die eigentliche Testsuite importieren. Für die Erweiterung von Testsuiten auf Ebene 1 (wie beschrieben im \"Arbeiten in mehreren Testsuiten\") könnte daher wie folgt aussehen: Erstellen Sie eine neue Testsuite. Fügen Sie die zu erweiternde Testsuite zum Inkludierte Dateien Bereich der neuen Testsuite hinzu. Speichern Sie die neue Testsuite. Stellen Sie sicher, dass beide Testsuiten zum selben Projekt gehören oder fügen Sie die neue Testsuite zum Abhängige Dateien Bereich der zu erweiternden Testsuite hinzu. Zeichnen Sie neue Testschritte in der Entwicklungssuite auf. Erstellen Sie auch sofort die Prozeduren, sofern benötigt. Jetzt importieren Sie die Komponenten, Prozeduren und Testfälle in die Zieltestsuite wie im \"Ablage von Komponenten\" und \"Verschmelzen von Testsuiten\" beschrieben. Eine detailliertere Beschreibung, wie man mit mehreren Testsuiten arbeitet, finden Sie im \"Verteilte Entwicklung von Tests\".","hash":"sec_bpExtendingSuites","h1":"Erweitern von Testsuiten"},"888":{"id":888,"content":"Arbeiten mit dem Skripteditor Der Skripteditor von QF‑Test enthält einige nette Möglichkeiten, um Ihnen Tipparbeit zu ersparen. Wenn Sie Methoden des Runcontexts rc aufrufen wollen, dann tippen Sie einfach rc. und drücken danach Strg⁠+⁠Leertaste. Jetzt bekommen Sie eine Liste aller unterstützten Methoden. Diese automatische Vervollständigung funktioniert für folgende Variablen:","hash":"sec_bpScripting","h1":"Arbeiten mit dem Skripteditor"},"889":{"id":889,"content":"Variablen Methoden doc Methoden von DocumentNode. frame Methoden von FrameNode. iw Methoden von ImageWrapper. node Methoden von DOMNode. Options Die Namen und Werte der QF‑Test Optionen. qf Methoden des qf Modules. rc Methoden des Runcontexts. resolvers Methoden des Resolvers Moduls. Wenn Sie nur Strg⁠+⁠Leertaste klicken ohne etwas einzugeben Eine Liste aller Variablen, für die Vervollständigung möglich ist. Tabelle 38.1: Liste der Variablen mit Vervollständigung.","hash":"table_38.1","h1":"Arbeiten mit dem Skripteditor"},"890":{"id":890,"content":"Pro Handbuch","hash":"","h0":"Aufsetzen von Testsystemen | QF‑Test Handbuch"},"891":{"id":891,"content":"Pro Handbuch","hash":"home-link","h0":"Aufsetzen von Testsystemen | QF‑Test Handbuch"},"892":{"id":892,"content":"Aufsetzen von Testsystemen Dieses Kapitel gibt Ihnen Hinweise, wie Sie Ihre Testsysteme und Prozesse aufsetzen können, um die Grundlagen für eine stabile Testausführung legen zu können.","hash":"sec_bpTestsyssetup","h0":"Aufsetzen von Testsystemen"},"893":{"id":893,"content":"Einrichten von Prozessen und Services via Aufgabenplaner Um Tests oder andere Prozesse regelmäßig auszuführen, werden auf Windows oft Services eingesetzt. Diese Services haben aber den Nachteil, dass sie nicht unter einer verwendbaren Benutzersession laufen. Demnach sollten Prozesse, wie ein Buildserverprozess oder Skripte, die den QF‑Test Daemon starten, nicht als Service gestartet werden, weil es sonst zu Problemen bei der GUI Testausführung kommen kann. Technische Details hierzu finden Sie unter FAQ 14. Wir empfehlen in der Regel statt Services eine Aufgabe über den Aufgabenplaner zu definieren. Diese können Sie direkt über die grafische Oberfläche des Aufgabenplaners einrichten. Die folgende Vorgehensweise funktioniert bei Windows-Rechnern. Abhängig von der Version können sich die Dialoge leicht unterscheiden: Starten Sie dazu zuerst den Aufgabenplaner über die Systemsteuerung -> Verwaltung -> Aufgabenplanung. Klicken Sie auf \"Aufgabe erstellen\" rechts oben. Auf dem \"Allgemein\" Reiter geben Sie einen Namen an, z.B. \"QF‑Test\". Nun klicken Sie auf \"Benutzer oder Gruppen ändern\" und wählen den Benutzer aus, in dessen Session der Test ausgeführt werden soll. Wählen Sie hier unbedingt einen echten Benutzer und keinen Pseudo-User und nicht die Service-Session. Klicken Sie auf OK, um den Dialog zu schließen. Wählen Sie dann \"Nur ausführen, wenn der Benutzer angemeldet ist\". Wählen Sie _nicht_ \"Mit höchsten Privilegien ausführen\". Sie können nun noch die korrekte Windows-Version für die Aufgabe anwählen. Auf dem \"Trigger\" Reiter klicken Sie auf \"Neu...\" und definieren Sie den Trigger auf dem neuen Dialog. Schließen Sie danach den Dialog zur Zeitplanung. Auf dem \"Aktionen\" Tab klicken Sie nun \"Neu...\" und wählen Sie \"Programm starten\" und \"Durchsuchen\" Sie den Rechner nach dem .cmd oder .bat Script, welches entweder den Batch-Aufruf für QF‑Test enthält oder den Prozess Ihres Buildsystems startet. Mit OK schließen Sie wieder den Dialog. Auf dem \"Bedingungen\" Reiter und \"Einstellungen\" Tab können Sie nun noch die gewünschten Einstellungen vornehmen. Danach können Sie die Konfiguration abschließen. Wichtig ist nun, dass der User, in dessen Session dieser Prozess ausgeführt wird, zuvor eingeloggt wird. Entweder manuell oder automatisch (siehe \"Automatische Anmeldung auf Windowsrechnern\"). Empfehlenswert sind daher für GUI Tests immer virtuelle Maschinen. Hier muss nur auf dem Gastsystem der User eingeloggt sein, der Host kann gesperrt werden.","hash":"sec_bpTaskScheduler","h1":"Einrichten von Prozessen und Services via Aufgabenplaner"},"894":{"id":894,"content":"Fernzugriff auf Windowsrechner Beim Fernzugriff auf Windowsrechner unterliegt die Verwendung von RDP einigen Einschränkungen bzw. erfordert eine explizite Konfiguration des Systems, um uneingeschränkt verwendet werden zu können. Dies liegt daran, dass die bei den Windows Desktop Varianten implementierte Variante des Zugriffs über RDP immer nur einen aktiven Anwender erlaubt. Wenn Sie sich also per RDP mit einem Testrechner verbinden, wird dessen (virtueller) Bildschirm gesperrt, während Sie auf diesem Rechner arbeiten können. Schließen Sie Ihr RDP-Fenster, bleibt jedoch der Bildschirm des Testrechners gesperrt. Und auf einem gesperrten Bildschirm kann man unter üblichen Umständen keine Benutzeroberfläche bedienen, also auch nicht testen. Ab Windows 10 bzw. Windows Server 2016 können Sie unter gewissen Voraussetzungen RDP verwenden, wenn Sie folgende Änderung in der Registry vornehmen. Unter HKEY_CURRENT_USER\\Software\\Microsoft\\Terminal Server Client oder HKEY_LOCAL_MACHINE\\Software\\Microsoft\\Terminal Server Client fügen Sie bitte einen neuen DWORD namens RemoteDesktop_SuppressWhenMinimized ein. Dort setzen Sie den Wert 2. Das erlaubt dann das Minimieren des Fensters einer RDP-Verbindung, aber leider immer noch nicht das Schließen oder Trennen. Natürlich können Sie auch Alternativen zu RDP verwenden. Hier können Sie sich z.B. der Möglichkeiten bedienen, die Ihnen der Server für die virtuellen Maschinen zur Verfügung stellt. Beim einem VMware Server bietet sich also der vSphere Client an, bei VirtualBox kann man sich mit RDP mit VirtualBox (nicht mit dem Windows RDP des Clients) verbinden. Letzterer hat dann selbstverständlich nicht die oben genannten Effekte mit der Bildschirm-Sperrung.","hash":"sec_bpRemoteAccess","h1":"Fernzugriff auf Windowsrechner"},"895":{"id":895,"content":"Automatische Anmeldung auf Windowsrechnern Eine Möglichkeit sicherzustellen, dass ein Testrechner in den meisten Fällen eine aktive Session hat, ist, dass sich auf diesem Rechner bei jedem Start automatisch ein Testbenutzer anmeldet. Wie man ein Windowssystem entsprechend konfigurieren kann, ist in diesem Abschnitt beschrieben. Eine automatische Anmeldung an Windows ist immer ein Sicherheitsrisiko. Daher sollte selbstverständlich sichergestellt sein, dass die betroffenen Rechner außerhalb der Testumgebung nicht zugänglich sind. Diese Anleitung ist zwar grundsätzlich gültig, wird aber üblicherweise auf virtuelle Rechner angewendet werden, auf die dann von Fall zu Fall remote zugegriffen werden wird. Was bei diesem Remote-Zugriff zu beachten ist, finden Sie im \"Fernzugriff auf Windowsrechner\". Die folgende Vorgehensweise funktioniert bei Windows 7, Windows 8, Windows 8.1 und Windows 10, wobei sich die Dialoge nur leicht unterscheiden: Starten Sie eine Eingabeaufforderung mit Administrator-Rechten. Geben Sie control userpasswords2 ein. Es öffnet sich daraufhin der Dialog \"Benutzerkonten\". Bitte entfernen Sie hier das Häkchen bei \"Benutzer müssen Benutzernamen und Kennwort eingeben\", nachdem Sie den Benutzer markiert haben, der sich später automatisch anmelden soll. In dem nun erscheinenden Dialog \"Automatische Anmeldung\" tragen Sie bitte das Benutzer-Kennwort zwei Mal ein. Nach dem anschließenden Klick auf die \"OK\" Schaltfläche ist die automatische Anmeldung fertig eingerichtet. Es gibt auch noch andere Wege, dies zu erreichen. Zum Einen könnten Sie den entsprechenden Registry-Eintrag direkt ändern. Zum Anderen aber auch das Tool \"Autologon\" von Microsoft unter https://technet.microsoft.com/de-de/sysinternals/bb963905 herunter laden. Alle diese Varianten erreichen aber im Endeffekt exakt dasselbe (nämlich den entsprechenden Registry-Eintrag). Wir empfehlen jedoch die hier vorgestellte Variante, da kein Download nötig ist und Tippfehler beim Registry-Eintrag ausgeschlossen sind. Übrigens funktioniert die automatische Anmeldung nie bei Benutzern, die sich an einer Domäne anmelden. Aber das wäre bei Testrechnern ja auch ungeschickt, wird aber die meisten Administrator:innen sehr beruhigen.","hash":"sec_bpAutoLogonWin","h1":"Automatische Anmeldung auf Windowsrechnern"},"896":{"id":896,"content":"Testausführung unter Linux Auf Linux-Systemen können virtuelle Displays mittels Tools wie VNC-Server einfach eingerichtet werden. Ein guter Windowmanager hierfür ist, z.B. xfce.","hash":"sec_bpLinux","h1":"Testausführung unter Linux"},"897":{"id":897,"content":"Pro Handbuch","hash":"","h0":"Testausführung | QF‑Test Handbuch"},"898":{"id":898,"content":"Pro Handbuch","hash":"home-link","h0":"Testausführung | QF‑Test Handbuch"},"899":{"id":899,"content":"Testausführung Dieses Kapitel gibt Ihnen Hinweise, wie Sie Ihre Tests implementieren können um eine stabile und verlässliche Testausführung zu erreichen.","hash":"sec_bpTestExec","h0":"Testausführung"},"900":{"id":900,"content":"Abhängigkeiten Das 'Abhängigkeiten' Konzept von QF‑Test ermöglicht es, dass alle Vorbedingungen eines Testfalles vor der eigentlichen Ausführung des Testfalles sichergestellt werden. Es bietet auch Möglichkeiten, auf ein unerwartetes Verhalten zu reagieren, z.B. Schließen eines unerwarteten Fehlerdialogs. Dieses Konzept ist im \"Abhängigkeiten\" beschrieben. Im Tutorial können Sie einen Anwendungsfall im Kapitel 'Abhängigkeiten' finden. Sie sollten zumindest eine Abhängigkeit implementieren, die verantwortlich ist das SUT zu starten. Diese Abhängigkeit sollte eine Vorbereitung Sequenz, die das SUT startet, eine Aufräumen Sequenz für das normale Beenden des SUTs und darüber hinaus noch einen Catch Knoten, um auf unerwartetes Verhalten zu reagieren, beinhalten. Wenn Sie eine Aufräumen Sequenz implementieren, versuchen Sie zuerst das SUT normal zu beenden. Nur wenn das nicht klappt, sollten Sie versuchen das SUT mit einem Programm beenden Knoten abzuschießen. Für SWING und SWT Applikationen, verwenden Sie bitte die Prozeduren qfs.cleanup.swing.closeAllModalDialogs und qfs.cleanup.swt.closeAllModalDialogsAndShells aus der Standardbibliothek qfs.qft um unerwartete Fehlerdialoge zu schließen.","hash":"sec_bpDependencies","h1":"Abhängigkeiten"},"901":{"id":901,"content":"Wartezeiten und Verzögerungen Zur Optimierung der Ausführungszeit sollten Sie anstatt der Attribute 'Verzögerung vorher' und 'Verzögerung nachher' Synchronisationsknoten von QF‑Test verwenden. Die erste Art von Synchronisationsknoten sind die 'Warte'-Knoten wie Warten auf Komponente, Warten auf Client, Warten auf Laden des Dokuments und Warten auf Programmende. Hier können Sie das Attribut Wartezeit setzen, um auf eine Komponente, einen Prozess oder ein Dokument zu warten. Der Warten auf Komponente Knoten bietet sogar die Möglichkeit, auf das Verschwinden von Komponenten zu warten. Die zweite Art sind 'Check'-Knoten, bei denen Sie auch wieder das Attribut Wartezeit setzen können. Diese Knoten können verwendet werden, um einen Test erst fortsetzen, wenn eine GUI-Komponente einen bestimmten Status erreicht hat.","hash":"sec_bpTimeoutDelay","h1":"Wartezeiten und Verzögerungen"},"902":{"id":902,"content":"Was soll man tun, wenn das Protokoll einen Fehler enthält? Wenn der Testreport eine Fehlermeldung oder eine Exception enthält, dann sollten Sie folgende Schritte ausführen, um die Fehlerquelle schnell zu finden: Analysieren Sie das Protokoll, insbesondere die Bildschirmabbilder und Meldungen. Wenn Sie die Fehlerquelle nicht sofort sehen können, dann springen Sie zur fehlerhaften Stelle in der Testsuite mit der Tastenkombination Strg⁠+⁠T. Setzen Sie einen Breakpoint vor dem fehlerhaften Schritt. Versichern Sie sich, dass der Debugger von QF‑Test eingeschaltet ist. Starten Sie den fehlerhaften Test. Wenn QF‑Test den Breakpoint erreicht und die Ausführung stoppt, öffnen Sie das Debugger-Fenster und kontrollieren die aktuellen Variablenbelegungen, vielleicht beinhaltet diese ja falsche Werte. Vielleicht sehen Sie jetzt auch sofort den Fehler im SUT. Wenn Sie immer noch keine Fehlerursache erkennen können, dann führen Sie den fehlerhaften Schritt aus. Wenn Sie nun immer noch einen Fehler bekommen, dann müssen Sie eventuell einige Schritte vor dem eigentlichen Fehler debuggen. Verwenden Sie hierzu wenn möglich die Aktion 'Ausführung hier fortsetzen' aus dem Kontextmenü, um zu einem beliebigen Knoten in der Testsuite zu springen anstatt eines Neustarts des kompletten Tests. Seit QF‑Test Version 3.1 ist es möglich Knoten mittels Kontextmenü »Marke setzen« zu markieren oder ein Lesezeichen mittels der Kontextmenüaktion »Lesezeichen hinzufügen« zu setzen. Diese Features ermöglichen es Ihnen schnell die wichtigsten Knoten wiederzufinden. Wenn Sie Probleme mit der Komponentenerkennung haben, dann schauen Sie bitte in die Kapitel \"Lösung von Problemen bei der Wiedererkennung\" und \"Wie erreicht man eine robuste Komponentenerkennung?\".","hash":"sec_bpWhatonErrors","h1":"Was soll man tun, wenn das Protokoll einen Fehler enthält?"},"903":{"id":903,"content":"Pro Handbuch","hash":"","h0":"Referenzteil | QF‑Test Handbuch"},"904":{"id":904,"content":"Pro Handbuch","hash":"home-link","h0":"Referenzteil | QF‑Test Handbuch"},"905":{"id":905,"content":"Referenzteil","hash":"sec_reference","h1":"Referenzteil"},"906":{"id":906,"content":"Pro Handbuch","hash":"","h0":"Einstellungen | QF‑Test Handbuch"},"907":{"id":907,"content":"Pro Handbuch","hash":"home-link","h0":"Einstellungen | QF‑Test Handbuch"},"908":{"id":908,"content":"Einstellungen Es gibt diverse Möglichkeiten, das Verhalten von QF‑Test zu beeinflussen. Insbesondere für das Aufnehmen und Abspielen von Tests gibt es viele Einstellmöglichkeiten. QF‑Test unterscheidet zwischen User und System Optionen. Useroptionen sind Einstellungen, die das Verhalten der Oberfläche von QF‑Test beeinflussen. Sie haben im Gegensatz zu den Systemoptionen keinen Einfluss auf die Aufnahme und das Abspielen von Tests. Useroption werden für jeden Anwender getrennt gespeichert, während Systemoptionen in einer gemeinsamen Systemdatei abgelegt werden. Näheres hierzu finden Sie in \"Konfigurationsdateien\". Bei vielen Option kann deren Wert zur Laufzeit, wie in \"Das rc-Modul: Die API des Runcontexts\" beschrieben, per Skript mittels rc.setOption verändert werden. Abhängig davon, ob die jeweilige Option in QF‑Test selbst oder im SUT ausgewertet wird, ist bei der Beschreibung der Option ein \"Server-Skript Name\" oder ein \"SUT-Skript Name\" angegeben, welcher der Konstante aus der Options Klasse entspricht. Natürlich muss die Option in einem passenden Server-Skript oder SUT-Skript Knoten gesetzt werden. Falls der Wert der Option aus einer Liste ausgewählt werden kann, führt die Beschreibung auch die Konstanten für die möglichen Werte auf. Auch wenn die Anzahl der Optionen entmutigend erscheinen mag, lassen Sie sich davon nicht abhalten. Alle Optionen haben vernünftige Standardwerte, sodass QF‑Test in den meisten Fällen problemlos funktioniert. Wenn Sie dennoch feststellen, dass Sie etwas ändern müssen oder wenn Sie einfach den Bereich von QF‑Test's Fähigkeiten kennenlernen wollen, so ist dieses Kapitel etwas für Sie. Sie können die Optionen mit Hilfe des Dialogs, den Sie über »Bearbeiten«-»Optionen...« erreichen, ansehen und manipulieren. Die Einstellungen werden (mit kleinen Ausnahmen, s.u.) beim Beenden von QF‑Test gespeichert (siehe \"Konfigurationsdateien\").","hash":"sec_options","h0":"Einstellungen"},"909":{"id":909,"content":"Abbildung 41.1: Optionen Baumstruktur Um zu den gewünschten Optionen zu gelangen, selektieren Sie zunächst im Baum den entsprechenden Ast. Im rechten Teil können Sie dann die Optionen einstellen. Beim Wechsel von einer Gruppe zur anderen werden die Optionen zwar auf Gültigkeit überprüft, aber noch nicht übernommen. Dies geschieht erst bei Bestätigung mit dem OK Button.","hash":"figure_41.1","h4":"Abbildung 41.1: Optionen Baumstruktur"},"910":{"id":910,"content":"Pro Handbuch","hash":"","h0":"Allgemeine Optionen | QF‑Test Handbuch"},"911":{"id":911,"content":"Pro Handbuch","hash":"home-link","h0":"Allgemeine Optionen | QF‑Test Handbuch"},"912":{"id":912,"content":"Allgemeine Optionen Dieser Ast ist für allgemeine QF‑Test Einstellungen zuständig.","hash":"sec_opt_general","h0":"Allgemeine Optionen"},"913":{"id":913,"content":"Abbildung 41.2: Allgemeine Optionen","hash":"figure_41.2","h4":"Abbildung 41.2: Allgemeine Optionen"},"914":{"id":914,"content":"Fragen vor Schließen (User) Wurde eine Testsuite oder ein Protokoll modifiziert, wird vor dem Schließen eines Fensters oder dem Beenden von QF‑Test normalerweise gefragt, ob die Daten gespeichert werden sollen. Diese Abfrage kann durch Ausschalten dieser Optionen, getrennt für Testsuiten und Protokolle, verhindert werden, was gefährlich ist, da die Änderungen dann einfach verworfen werden.","hash":"opt_asksave","hp":"Allgemeine Optionen","h4":"Fragen vor Schließen (User)"},"915":{"id":915,"content":"Fragen vor Überschreiben (User) Wenn Sie eine Testsuite oder ein Protokoll abspeichern oder einen Report, Testdoc oder Pkgdoc-Dokumentation generieren oder ein Abbild eines Check Abbild abspeichern und die Zieldatei bzw. das Verzeichnis bereits existiert, wird normalerweise rückgefragt, ob Sie die Datei überschreiben wollen. Durch ausschalten der entsprechenden Optionen können Sie diese Frage für jeden Dateityp getrennt unterbinden.","hash":"opt_askoverwrite","hp":"Allgemeine Optionen","h4":"Fragen vor Überschreiben (User)"},"916":{"id":916,"content":"Letzte Sitzung beim Start wiederherstellen (User) Ist diese Option gesetzt und wird QF‑Test in der Workbench-Ansicht geöffnet, wird die letzte Sitzung wieder hergestellt indem die zuletzt geöffneten Testsuiten geladen werden und der zuletzt selektierte Knoten in der jeweiligen Suite selektiert wird. Sind ein oder mehrere Testsuiten auf der Kommandozeile angegeben, werden diese zusätzlich geladen und erhalten nach dem Start den initialen Fokus.","hash":"opt_restoresession","hp":"Allgemeine Optionen","h4":"Letzte Sitzung beim Start wiederherstellen (User)"},"917":{"id":917,"content":"Wie viele zuletzt besuchte Dateien im Menü (User) Im »Datei« Menü können Sie schnell auf die Testsuiten und Protokolle zugreifen, die Sie zuletzt bearbeitet haben. Diese Option legt die Zahl derartiger Menüeinträge fest.","hash":"opt_numrecentfiles","hp":"Allgemeine Optionen","h4":"Wie viele zuletzt besuchte Dateien im Menü (User)"},"918":{"id":918,"content":"Voreingestellte Sprache für Skript-Knoten (User) Diese Option kann die Werte \"Jython\", \"Groovy\" oder \"JavaScript\" annehmen und legt die Standardeinstellung für das Attribut Skriptsprache in neu erstellten Server-Skript oder SUT-Skript Knoten fest.","hash":"opt_defaultscriptlanguage","hp":"Allgemeine Optionen","h4":"Voreingestellte Sprache für Skript-Knoten (User)"},"919":{"id":919,"content":"Voreingestellte Sprache für Bedingungen (User) Diese Option kann die Werte \"Jython\", \"Groovy\" oder \"JavaScript\" annehmen und legt die Standardeinstellung für das Attribut Skriptsprache in neu erstellten If, Elseif, While, Testfallsatz oder Testschritt Knoten fest.","hash":"opt_defaultconditionlanguage","hp":"Allgemeine Optionen","h4":"Voreingestellte Sprache für Bedingungen (User)"},"920":{"id":920,"content":"Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java) (System) Server (automatisch weiter an SUT) Skript-Name: OPT_JYTHON_UNICODE_LITERALS Diese Option legt fest, wie Literale (wörtlich definierte String-Konstanten wie \"abc\") in Jython-Skripen in Server-Skript- und SUT-Skript-Knoten, dem Bedingung-Attribut in If und anderen Knoten sowie den interaktiven Jython-Konsolen für QF‑Test und das SUT behandelt werden. Ist die Option gesetzt, werden Jython-Literale als 16-Bit Unicode-Strings implementiert, genau wie in Java selbst. Andernfalls werden Literale zu den 8-Bit Byte-Strings von Python 2, die schlecht mit Java und somit QF‑Test zusammenspielen. Detaillierte Informationen und Beispiele finden Sie in \"Jython Strings und Zeichenkodierung\". Falls QF‑Test eine bereits bestehende ältere Systemkonfiguration vorfindet, ist diese Option standardmäßig ausgeschaltet, also auf 8-Bit Literale eingestellt. Für neue Installationen ist sie standardmäßig aktiviert.","hash":"opt_jythonunicodeliterals","hp":"Allgemeine Optionen","h4":"Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java) (System)"},"921":{"id":921,"content":"Standard-Zeichenkodierung für Jython (System) Server (automatisch weiter an SUT) Skript-Name: OPT_JYTHON_DEFAULT_ENCODING Diese Option legt die Standard-Zeichenkodierung zur Konvertierung zwischen Jython 16-Bit Unicode-Strings und 8-Bit Byte-Strings fest. Diese findet Anwendung bei expliziter Konvertierung wie str(...) und bei impliziter Konvertierung. Ist die vorhergehende Option Literale (wörtliche Zeichenketten) in Jython sind Unicode (16-Bit wie in Java) nicht gesetzt, findet für alle vorkommenden Jython Literale (wörtlich definierte String-Konstanten wie \"abc\") implizite Konvertierung statt. Detaillierte Informationen und Beispiele finden Sie in \"Jython Strings und Zeichenkodierung\". Ab QF‑Test 5.3 ist der Standardwert für diese Option \"utf-8\" (vorher war er \"latin-1\"). Bereits bestehende Systemeinstellungen sind von dieser Änderung nicht betroffen.","hash":"opt_defaultjythonencoding","hp":"Allgemeine Optionen","h4":"Standard-Zeichenkodierung für Jython (System)"},"922":{"id":922,"content":"Unter Windows und macOS nativen Dateiauswahldialog verwenden (User) Server Skript-Name: OPT_USE_NATIVE_FILECHOOSER Unter Windows und macOS ist der native Dateiauswahldialog der Swing Variante deutlich überlegen und wird daher von QF‑Test normalerweise verwendet. Deaktivieren Sie diese Option wenn Sie den Auswahldialog von Swing vorziehen.","hash":"opt_usenativefilechooser","hp":"Allgemeine Optionen","h4":"Unter Windows und macOS nativen Dateiauswahldialog verwenden (User)"},"923":{"id":923,"content":"Vollständigen Dateipfad und QF‑Test Version in der Titelzeile anzeigen (User) QF‑Test zeigt den kompletten Pfad der aktuellen Testsuite und die QF‑Test Version in der Titelzeile des Hauptfensters an, wenn diese Option aktiviert ist.","hash":"opt_showsuitefullpath","hp":"Allgemeine Optionen","h4":"Vollständigen Dateipfad und QF‑Test Version in der Titelzeile anzeigen (User)"},"924":{"id":924,"content":"Einstellungen für Projekte Es gibt verschiedene Optionen, welche die Darstellung und Handhabung von Projekten in QF‑Test beeinflussen.","hash":"sec_opt_projects","h1":"Einstellungen für Projekte"},"925":{"id":925,"content":"Abbildung 41.3: Einstellungen für Projekte","hash":"figure_41.3","h4":"Abbildung 41.3: Einstellungen für Projekte"},"926":{"id":926,"content":"Zeitabstand für automatisches Auffrischen von Projekten (s) (User) Projekte werden automatisch im hier definierten Zeitabstand komplett aktualisiert. Sie können ein Verzeichnis jederzeit manuell über das Kontextmenü oder durch drücken von F5 aktualisieren. Um die gesamte Hierarchie unterhalb eines Verzeichnisses aufzufrischen, drücken Sie Shift⁠+⁠F5.","hash":"opt_projectrefreshinterval","hp":"Einstellungen für Projekte","h4":"Zeitabstand für automatisches Auffrischen von Projekten (s) (User)"},"927":{"id":927,"content":"Anzahl Testsuiten, die ohne Warnung auf einmal geöffnet werden (User) Vom Projektbaum aus können Sie alle Testsuiten, die in einer Verzeichnishierarchie enthalten sind, in einem Rutsch öffnen. Falls Sie dabei versehentlich zu viele Suiten selektieren, zeigt QF‑Test zunächst die Anzahl in einer Warnung an, so dass Sie die Aktion noch abbrechen können. Diese Option legt die Schwelle für diese Warnung fest.","hash":"opt_projectmaxsuitestoopen","hp":"Einstellungen für Projekte","h4":"Anzahl Testsuiten, die ohne Warnung auf einmal geöffnet werden (User)"},"928":{"id":928,"content":"Auszuschließende Projektdateien und -verzeichnisse (System) Es gibt Verzeichnisse und Dateien, die nicht wirklich zu einem Projekt gehören, insbesondere die Unterverzeichnisse, die von verschiedenen Versionierungs-Systemen wie Git, Subversion oder CVS erstellt werden. Über diese Option können Sie Muster für Datei- und Verzeichnisnamen festlegen, die generell aus Projekten ausgeschlossen werden sollen. Die hier verwendeten Muster sind keine regulären Ausdrücke, sondern eine einfachere Form, die oft in Entwicklungswerkzeugen eingesetzt wird. Aus Kompatibilitätsgründen wird ausschließlich '/' als Trennzeichen verwendet, nicht der unter Windows gebräuchliche Rückstrich '\\'. Ein '*' steht für 0 oder mehr Zeichen exklusive '/', '**' für 0 oder mehr beliebige Zeichen inklusive '/'. Jedes Muster ist relativ zum Wurzelverzeichnis des Projekts. Einige Beispiele: **/.svn Alle Verzeichnisse namens .svn in beliebiger Tiefe. **/.* Alle Verzeichnisse beginnend mit einem '.' in beliebiger Tiefe. deprecated Ein Verzeichnis namens deprecated direkt unter dem Wurzelverzeichnis des Projekts.","hash":"opt_projectexcludes","hp":"Einstellungen für Projekte","h4":"Auszuschließende Projektdateien und -verzeichnisse (System)"},"929":{"id":929,"content":"Speichern von Testsuiten Die folgenden Optionen legen das Format für das Speichern von Testsuiten als XML fest. Das Format für das Speichern von Protokollen wird durch die Option Protokoll in aktuellem XML-Format mit UTF-8-Kodierung speichern bestimmt. Unabhängig vom gewählten XML-Format können Testsuiten und Protokolle auch mit QF‑Test Versionen älter als 7.0 geöffnet werden (wobei später eingeführte Knotentypen natürlich nicht erkannt werden). Beim Speichern mit einer alten QF‑Test Version wird immer auf das alte XML-Format zurückgewechselt.","hash":"sec_opt_testsuites","h1":"Speichern von Testsuiten"},"930":{"id":930,"content":"Abbildung 41.4: Speichern von Testsuiten","hash":"figure_41.4","h4":"Abbildung 41.4: Speichern von Testsuiten"},"931":{"id":931,"content":"XML-Format von bestehenden Testsuiten überschreiben (System) Eine Änderung des XML-Dateiformats führt beim nächsten Speichern einer Testsuite zu einer großen Zahl von rein syntaktischen Änderungen. Diese werden in Versionskontrollsystemen sichtbar und überlagern dabei eventuell die eigentlichen inhaltlichen Änderungen. Um dies zu vermeiden, wird das mit den nachfolgenden Optionen definierte XML-Format nur für neue Testsuiten angewandt. Bereits existierende Testsuiten behalten ihr Format bei, sofern diese Option nicht aktiviert wird. Das Ändern des XML-Formats sollte eine projektweite Entscheidung sein und idealerweise so in einem Rutsch durchgeführt werden, dass alle Dateien gemeinsam und ohne andere Änderungen in einem Commit in das Versionskontrollsystem eingecheckt werden. Die Konvertierung selbst kann sehr einfach mit QF‑Test im Batchmodus mit dem Kommandozeilenargument -convertxml durchgeführt werden. Die genaue Syntax hierfür finden Sie in \"Aufrufsyntax\".","hash":"opt_xmlsuiteoverwrite","hp":"Speichern von Testsuiten","h4":"XML-Format von bestehenden Testsuiten überschreiben (System)"},"932":{"id":932,"content":"Testsuiten UTF-8 kodiert speichern (System) Ist diese Option aktiv (der Standard), werden Testsuiten mit UTF-8-Kodierung gespeichert, andernfalls mit ISO-8859-1. QF‑Test Versionen vor 7.0 speichern immer mit ISO-8859-1 Kodierung.","hash":"opt_xmlsuiteutf8","hp":"Speichern von Testsuiten","h4":"Testsuiten UTF-8 kodiert speichern (System)"},"933":{"id":933,"content":"Anzahl der Leerzeichen für das Einrücken beim Speichern von Testsuiten (System) XML-Dateien mit Einrückung sind für Menschen einfacher zu lesen. Testsuiten werden aber primär von QF‑Test verarbeitet, ein typischer QF‑Test Anwender bekommt das XML nur im Fall von Merge-Konflikten zu Gesicht. Letztere werden durch eine Einrückung von 0, dem neuen Standardwert, reduziert, da ansonsten im XML alle Zeilen von ein- oder ausgepackten Knoten geändert werden. QF‑Test Versionen vor 7.0 verwenden immer eine Einrückung von 2 Zeichen.","hash":"opt_xmlsuiteindent","hp":"Speichern von Testsuiten","h4":"Anzahl der Leerzeichen für das Einrücken beim Speichern von Testsuiten (System)"},"934":{"id":934,"content":"Zeilenlänge beim Speichern von Testsuiten (System) Die einzigen Zeilen, die in XML-Dateien für Testsuiten problemlos umgebrochen werden können, sind die mit den Attributen der Knoten. Der aus Skripten oder Bemerkungen stammende Textinhalt würde durch zusätzliche Umbrüche beschädigt, daher stellt diese Option keine harte Beschränkung der Zeilenlänge dar. Leider gibt es keinen idealen Standardwert für diese Option. Der aktuelle Standard von 160 Zeichen ist ein Kompromiss zwischen den folgenden beiden Extremen: Ein negativer oder extrem großer Wert führt zu einer praktisch unbegrenzten Zeilenlänge, genug um immer alle Attribute eines XML-Knotens auf einer einzelnen Zeile zu halten. Dies ist kompakt und führt zu guten Ergebnissen beim Mergen, da die geänderten Attribute mit der - meist eindeutigen - ID des Knotens in derselben Zeile liegen. Der Wert 0 führt zu einem speziellen neuen Format, bei dem jedes Attribut und sogar das schließende > Zeichen in jeweils einer eigenen Zeile stehen. Dadurch können zeilenbasierte Kommandos wie git blame die letzte Änderung jedes einzelnen Attributs anzeigen. Bei langen Zeilen erhält man damit nur die letzte Änderung des gesamten Knotens. Auch lassen sich mit diesem Format die Änderungen in Diffs zwischen zwei Versionen einer XML-Datei einfacher interpretieren. Der Nachteil dieses Formats ist die leicht erhöhte Gefahr von falschen Ergebnissen beim Merge, da der Kontext einer Änderung - üblicherweise 3 Zeilen - eventuell das ID Attribut nicht enthält. QF‑Test Versionen vor 7.0 verwenden immer eine Zeilenlänge von 78 Zeichen.","hash":"opt_xmlsuitelinelength","hp":"Speichern von Testsuiten","h4":"Zeilenlänge beim Speichern von Testsuiten (System)"},"935":{"id":935,"content":"Darstellung Diese Einstellungen betreffen die Darstellung des Testsuite-Baums und seiner Knoten.","hash":"sec_opt_treeview","h1":"Darstellung"},"936":{"id":936,"content":"Abbildung 41.5: Darstellung","hash":"figure_41.5","h4":"Abbildung 41.5: Darstellung"},"937":{"id":937,"content":"UI-Theme (User) Diese Option legt das allgemeine Design der Benutzeroberfläche von QF‑Test fest. Ein schneller Zugriff auf diese Option ist über das Menü »Ansicht«-»UI-Theme« möglich.","hash":"opt_uithemename","hp":"Darstellung","h4":"UI-Theme (User)"},"938":{"id":938,"content":"UI-Modus - Hell oder dunkel (User) Diese Option legt fest, ob das aktuelle QF‑Test Theme im hellen oder im dunklen Modus angezeigt wird. Die Standardeinstellung ist das Übernehmen der Vorgaben vom Betriebssystem. Ein schneller Zugriff auf diese Option ist über das Menü »Ansicht«-»UI-Theme« möglich.","hash":"opt_uitheme","hp":"Darstellung","h4":"UI-Modus - Hell oder dunkel (User)"},"939":{"id":939,"content":"Linien zeichnen (User) Diese Option steuert, ob senkrechte Linien zwischen Baumknoten mit gleicher Einrückungstiefe angezeigt werden.","hash":"opt_treepaintlines","hp":"Darstellung","h4":"Linien zeichnen (User)"},"940":{"id":940,"content":"Syntax-Hervorhebungen für Baumknoten (User) Diese Option steuert die Aktivierung von Syntax-Hervorhebungen für Baumknoten in Testsuiten und Protokollen. Wenn sie aktiviert ist, werden spezifische Teile der Texte in den Baumknoten durch unterschiedliche Farben oder Stile hervorgehoben, z.B. Knotenname, Parameter, Client etc., was die Lesbarkeit deutlich verbessert.","hash":"opt_treenodesyntaxhigh","hp":"Darstellung","h4":"Syntax-Hervorhebungen für Baumknoten (User)"},"941":{"id":941,"content":"Typen bei Baumknoten mit Namen einblenden (User) Wird diese Option deaktiviert, werden in Baumknoten von Testsuiten und Protokollen Beschriftungen wie \"Testfall\" ausgeblendet, sofern der jeweilige Knoten mit einem Namen versehen und sein Icon eindeutig ist.","hash":"opt_treeshowprefix","hp":"Darstellung","h4":"Typen bei Baumknoten mit Namen einblenden (User)"},"942":{"id":942,"content":"Skriptsprache bei Skript-Knoten anzeigen (User) Diese Option steuert, ob die Skriptsprache eines Server-Skript oder SUT-Skript Knotens im Text des Testsuite-Baums angezeigt wird.","hash":"opt_treeshowscriptlanguage","hp":"Darstellung","h4":"Skriptsprache bei Skript-Knoten anzeigen (User)"},"943":{"id":943,"content":"Ergebnisvariablen im Baum anzeigen (User) Über diese Option wird gesteuert, ob im Baumknoten der Name der Variablen, in die das Ergebnis gespeichert wird, angezeigt wird.","hash":"opt_treeshowresultvariable","hp":"Darstellung","h4":"Ergebnisvariablen im Baum anzeigen (User)"},"944":{"id":944,"content":"Ergebniswerte im Baum anzeigen (User) Über diese Option wird gesteuert, ob im Protokoll im Baumknoten der Wert, der einer Ergebnisvariablen zugewiesen wurde, angezeigt wird. Die Option Maximale Länge für Werte im Baum steuert die maximale Länge des angezeigten Werts.","hash":"opt_treeshowresultvalues","hp":"Darstellung","h4":"Ergebniswerte im Baum anzeigen (User)"},"945":{"id":945,"content":"Name des Clients im Baum anzeigen (User) Mit dieser Option können Sie beeinflussen, ob der Name des Clients, auf den sich der Knoten bezieht, im Testsuite-Baum angezeigt wird. Sie können \"Immer\" oder \"Nie\" auswählen, oder dass der Wert des Client Attributs nur dann angezeigt wird, wenn es nicht der Standardwert $(client) ist.","hash":"opt_treeshowclient","hp":"Darstellung","h4":"Name des Clients im Baum anzeigen (User)"},"946":{"id":946,"content":"Klasse oder Typ von Komponenten anzeigen (User) Die Option legt fest, ob im Baum für einen Komponente-Knoten nur die primäre Klasse angezeigt wird, der spezifische Typ oder beides. Konkret wäre das z.B. nur 'Panel', nur 'TitledPanel' oder kombiniert 'Panel:TitledPanel'.","hash":"opt_treeshowclassortype","hp":"Darstellung","h4":"Klasse oder Typ von Komponenten anzeigen (User)"},"947":{"id":947,"content":"Maximale Länge für Werte im Baum (User) Die Option ist nur relevant, wenn Ergebniswerte im Baum anzeigen aktiviert wurde. In diesem Fall steuert sie die maximale Länge des im Baumknoten angezeigten Ergebniswerts.","hash":"opt_treemaxvaluelength","hp":"Darstellung","h4":"Maximale Länge für Werte im Baum (User)"},"948":{"id":948,"content":"Maximale Länge für IDs von Komponenten im Baum (User) Die Option steuert die maximale Länge der im Baumknoten angezeigten QF‑Test ID der Komponente.","hash":"opt_treemaxcomponentidlength","hp":"Darstellung","h4":"Maximale Länge für IDs von Komponenten im Baum (User)"},"949":{"id":949,"content":"Schriftgröße (pt) (User) Mit dieser Option wird die Schriftgröße definiert (gemessen in Punkten), die für die Darstellung der UI-Elemente in QF‑Test verwendet wird. Eine geänderte Einstellung wird erst nach dem Neustart von QF‑Test wirksam.","hash":"opt_minfontsize","hp":"Darstellung","h4":"Schriftgröße (pt) (User)"},"950":{"id":950,"content":"Zeichen für Tabulator und Zeilenumbruch durch Symbole visualisieren (User) Wenn diese Option gesetzt ist, werden spezielle Symbole für Tabulatoren und Zeilenumbrüche in Tabellenzeilen und in relevanten Textbereichen angezeigt.","hash":"opt_editshowwhitespaces","hp":"Darstellung","h4":"Zeichen für Tabulator und Zeilenumbruch durch Symbole visualisieren (User)"},"951":{"id":951,"content":"Editieren Diese Einstellungen betreffen das Editieren von Knoten im Baum und in der Detailansicht.","hash":"sec_opt_editing","h1":"Editieren"},"952":{"id":952,"content":"Abbildung 41.6: Editieren","hash":"figure_41.6","h4":"Abbildung 41.6: Editieren"},"953":{"id":953,"content":"Warnen wenn eine nicht speicherbare Testsuite modifiziert wird (User) Falls das Speichern von Testsuiten nicht erlaubt ist, z.B. wenn Sie ohne Lizenz arbeiten, gibt QF‑Test nach der ersten Änderung an einer Suite die Warnung aus, dass Sie Ihre Änderungen nicht speichern können. Durch Ausschalten dieser Option können Sie diese Warnung unterdrücken.","hash":"opt_warnonmodify","hp":"Editieren","h4":"Warnen wenn eine nicht speicherbare Testsuite modifiziert wird (User)"},"954":{"id":954,"content":"Vor dem Verwerfen von Änderungen in den Details nachfragen (User) Wenn Sie angefangen haben, Änderungen an einem bestehenden oder neu einzufügenden Knoten vorzunehmen und diese durch Drücken von Escape oder einen Klick auf den \"Abbrechen\" Button verwerfen, fragt QF‑Test nach, ob Sie die Bearbeitung wirklich abbrechen wollen. Die Rückfrage können Sie durch Deaktivieren dieser Option unterdrücken. Dabei sollten Sie sich allerdings bewusst sein, dass - insbesondere bei Skripten - im Fall eines Versehens viel Arbeit verloren gehen kann.","hash":"opt_askdiscard","hp":"Editieren","h4":"Vor dem Verwerfen von Änderungen in den Details nachfragen (User)"},"955":{"id":955,"content":"Vor dem impliziten Akzeptieren von Detailänderungen nachfragen (User) Wie in \"Bearbeiten einer Testsuite\" beschrieben, legt diese Option fest, wie streng QF‑Test die Gültigkeit von Attributen während der Bearbeitung überprüft. Wenn Sie Attribute ändern und vom aktuellen Knoten weg navigieren, ohne die Änderungen vorher zu übernehmen, kann QF‑Test die geänderten Werte entweder automatisch akzeptieren oder eine Bestätigung verlangen, indem ein modaler Dialog angezeigt wird, der die geänderten Attribute zeigt und so eine Entscheidung erzwingt, bevor fortgefahren werden kann. Die folgenden Einstellungen stehen zur Verfügung: Immer Werte nicht implizit übernehmen sondern immer bestätigen lassen. Nur wenn Werte ungültig oder suspekt sind Versuchen, Werte implizit zu akzeptieren, solange sie gültig und nicht verdächtig sind. Derzeit wird \"verdächtig\" definiert als führende oder nachgestellte Leerzeichen, die zu subtilen Problemen führen können, die nur schwer zu finden sind. Niemals Alle Werte akzeptieren, auch ungültige. Das ausdrückliche Verwerfen von Änderungen mit Hilfe des Abbrechen-Buttons oder durch drücken von Escape wird hiervon nicht beeinflusst.","hash":"opt_askaccept","hp":"Editieren","h4":"Vor dem impliziten Akzeptieren von Detailänderungen nachfragen (User)"},"956":{"id":956,"content":"\"OK\" und \"Abbrechen\" Buttons anzeigen (User) Die Verwendung der Buttons \"OK\" und \"Abbrechen\" ist optional und sie können über diese Option aus der Benutzeroberfläche entfernt werden. Die Tastenkombinationen Eingabe oder Strg⁠+⁠Eingabe können verwendet werden, um Änderungen zu übernehmen, Escape verwirft diese.","hash":"opt_showokcancel","hp":"Editieren","h4":"\"OK\" und \"Abbrechen\" Buttons anzeigen (User)"},"957":{"id":957,"content":"Ungültige Attribute währdend der Eingabe hervorheben (User) Ungültige Attributwerte werden mit einem rötlichen Hintergrund hervorgehoben. Diese Option legt fest, ob die Hervorhebung bei jedem Tastendruck kontinuierlich aktualisiert wird oder nur, wenn der Fokus das Feld verlässt.","hash":"opt_highlightwhileediting","hp":"Editieren","h4":"Ungültige Attribute währdend der Eingabe hervorheben (User)"},"958":{"id":958,"content":"Anzahl der zurücknehmbaren Änderungen pro Suite (User) Hiermit legen Sie fest, wieviele Bearbeitungsschritte Sie in einer Testsuite oder einem Protokoll rückgängig machen können.","hash":"opt_undolimit","hp":"Editieren","h4":"Anzahl der zurücknehmbaren Änderungen pro Suite (User)"},"959":{"id":959,"content":"Intelligentes Scrollen in Bäumen (User) Die Standardmethoden von Swing für die Interaktion mit Bäumen lassen einiges zu wünschen übrig. So führt zum Beispiel das Bewegen der Selektion zu unnötigem horizontalen Scrolling. Zusätzlich hat Swing die Tendenz, den selektierten Knoten so zu positionieren, dass nur wenig Kontext darum herum zu sehen ist. Da die Navigation in Bäumen für QF‑Test von zentraler Bedeutung ist, gibt es eine alternative Implementierung einiger dieser Methoden, die eine natürlichere Bedienung ermöglichen und sicherstellen, dass immer genug Kontextinformation um den selektierten Knoten herum zu sehen ist. Da derartige Dinge Geschmackssache sind, können Sie durch Deaktivieren dieser Option wieder zurück auf das Standardverhalten von Swing schalten.","hash":"opt_intelligentscroll","hp":"Editieren","h4":"Intelligentes Scrollen in Bäumen (User)"},"960":{"id":960,"content":"Vor dem Löschen auf Referenzen prüfen (User) Wenn diese Option gesetzt ist, dann wird beim Löschen eines Knoten geprüft, ob es Referenzen auf diesen Knoten gibt. Falls es Referenzen gibt, wird eine Liste der Referenzen geöffnet.","hash":"opt_checkreferences","hp":"Editieren","h4":"Vor dem Löschen auf Referenzen prüfen (User)"},"961":{"id":961,"content":"Nachfragen bei Änderung von QF‑Test IDs oder Standard benutzen (User) Wenn diese Option gesetzt ist, fragt QF‑Test bei Änderungen von QF‑Test IDs von Komponenten nach, ob Referenzen angepasst werden sollen. Ist diese Option nicht gesetzt, dann werden alle QF‑Test IDs von Komponenten angepasst, wenn diese eindeutig sind.","hash":"opt_askforcomponentidupdate","hp":"Editieren","h4":"Nachfragen bei Änderung von QF‑Test IDs oder Standard benutzen (User)"},"962":{"id":962,"content":"Nachfragen bei Änderung von aufrufbaren Knoten oder Standard benutzen (User) Wenn diese Option gesetzt ist, fragt QF‑Test bei Änderungen von aufrufbare Knoten (d.h. Prozeduren, Packages, Testfällen und Abhängigkeiten) nach, ob Referenzen angepasst werden sollen. Ist diese Option nicht gesetzt, dann werden alle Referenzen angepasst, wenn diese eindeutig sind.","hash":"opt_askforcallableidupdate","hp":"Editieren","h4":"Nachfragen bei Änderung von aufrufbaren Knoten oder Standard benutzen (User)"},"963":{"id":963,"content":"Prüfen, ob Konfigurationsdateien schreibbar sind (User) Wenn diese Option gesetzt ist, prüft QF‑Test beim Öffnen des Optionendialoges, ob die Konfigurationsdateien Schreibrechte besitzen. Falls dies nicht der Fall ist, wird ein Hinweisdialog angezeigt.","hash":"opt_askifoptionshavenopermissions","hp":"Editieren","h4":"Prüfen, ob Konfigurationsdateien schreibbar sind (User)"},"964":{"id":964,"content":"Knoten beim Erstellen automatisch öffnen (User) Wenn diese Option gesetzt ist werden Knoten bei der Erstellung automatisch geöffnet.","hash":"opt_autoopennodesoncreation","hp":"Editieren","h4":"Knoten beim Erstellen automatisch öffnen (User)"},"965":{"id":965,"content":"Workbench-Ansicht aktivieren (User) Wenn diese Option gesetzt ist, werden alle geöffneten Testsuiten in einem gemeinsamen Fenster - der Workbench - angezeigt. Die Nutzung ohne Workbench, also mit jeder Testsuiten in einem eigenen Fenster, wurde mit QF‑Test Version 8.0 abgekündigt.","hash":"opt_workbenchview","hp":"Editieren","h4":"Workbench-Ansicht aktivieren (User)"},"966":{"id":966,"content":"Lesezeichen Hier können Sie Ihre Lesezeichen bearbeiten, eine Liste von Dateien und Knoten, auf die schnell über das Menü »Datei«-»Lesezeichen« zugegriffen werden kann. Sie können statt einer Datei auch ein Verzeichnis angeben. Bei Auswahl des entsprechenden Lesezeichens wird dann der Dateiauswahldialog direkt für dieses Verzeichnis geöffnet. Die QF‑Test ID für den Knoten wird in diesem Fall ignoriert.","hash":"sec_opt_bookmarks","h1":"Lesezeichen"},"967":{"id":967,"content":"Abbildung 41.7: Lesezeichen Sie können neue Lesezeichen zwar auch manuell erstellen, einfacher geht es aber über den Menüeintrag »Datei«-»Lesezeichen«-»Aktuelle Datei hinzuzufügen«, um ein Lesezeichen für eine Testsuite oder ein Protokoll zu erstellen, oder durch Auswahl des Eintrags »Zu Lesezeichen hinzuzufügen« im Kontextmenü eines Knotens in einer Testsuite, um ein Lesezeichen für diesen speziellen Knoten zu erstellen.","hash":"figure_41.7","h4":"Abbildung 41.7: Lesezeichen"},"968":{"id":968,"content":"Externe Programme Die folgenden Optionen legen fest, welche externe Programme QF‑Test für verschiedene Zwecke aufruft.","hash":"sec_opt_external","h1":"Externe Programme"},"969":{"id":969,"content":"Abbildung 41.8: Optionen für Externe Programme","hash":"figure_41.8","h4":"Abbildung 41.8: Optionen für Externe Programme"},"970":{"id":970,"content":"Kommando für externen Editor (User) Skripte können durch Drücken von Alt⁠+⁠Eingabe oder Klicken des Buttons oberhalb des Textfeldes in einem externen Editor bearbeitet werden. Dazu wird der Inhalt des Textfeldes in einer temporären Datei gespeichert und der externe Editor wird aufgerufen, um diese Datei zu bearbeiten. Es wird empfohlen, dem Skript vorher einen Namen zu geben (siehe Warnen wenn der externe Editor ohne Dateinamen gestartet wird), andernfalls wird eine zufällig gewählte Zahl als Dateiname verwendet, was die Arbeit mit mehreren gleichzeitig in einem externen Editor geöffneten Skripten erschwert. Änderungen am Skriptcode über den externen Editor werden automatisch von QF‑Test übernommen. Je nach gewählten Einstellungen wird eine Warnung angezeigt, sobald das passiert (Warnen wenn die Testsuite durch einen externen Editor verändert wird). Sollte der Skriptcode parallel zum externen Editor auch in QF‑Test bearbeitet werden: Diese Änderungen werden ebenfalls in der temporären Datei gespeichert. Texteditoren wie jEdit sind ihrerseits in der Lage, diese zu bemerken und laden die Datei automatisch neu. Diese Option legt das Kommando zum Aufruf des externen Editors fest. Es gibt hierzu zwei Varianten: Die einfache Angabe einer ausführbaren Datei oder einen komplexen Befehl einschließlich Optionen. Letztere zeichnet sich dadurch aus, dass der Name der externen Datei durch den Platzhalter $(file) angegeben werden muss. Zusätzlich kann dabei über $(line) auch die aktuelle Zeile angegeben werden. Die Syntax $(file)/$(line) wird ausschließlich verwendet, um nicht wieder eine neue Konvention für variable Attribute einzuführen. Es findet keine standard QF‑Test Variablenexpansion für $(...) Ausdrücke statt. Einfache Kommandos müssen nicht durch Anführungsstriche geschützt werden, z.B.: emacsclient notepad C:\\Program Files\\Crimson Editor\\cedt.exe Komplexe Kommandos benötigen eventuell Anführungsstriche, insbesondere unter Windows. Um die Anführungsstriche für das $(file) Argument kümmert sich QF‑Test selbst: \"C:\\Program Files\\eclipse-3.6\\eclipse.exe\" --launcher.openFile $(file) javaw.exe -jar C:\\Programme\\jEdit4.2\\jedit.jar -reuseview $(file) \"C:\\Program Files\\Crimson Editor\\cedt.exe\" $(file) xterm -e vi +$(line) $(file) Ist diese Option leer, wird der Wert der Umgebungsvariablen EDITOR verwendet, sofern diese beim Start von QF‑Test definiert ist.","hash":"opt_externaleditor","hp":"Externe Programme","h4":"Kommando für externen Editor (User)"},"971":{"id":971,"content":"Verzeichnis zur Übergabe temporärer Dateien an externen Editor (User) Über diese Option kann das Verzeichnis festgelegt werden, in das QF‑Test temporäre Dateien zur Bearbeitung im externen Editor (siehe Kommando für externen Editor) bereitstellt. Fall leer, werden die Dateien im benutzerspezifischen Konfigurationsverzeichnis gespeichert.","hash":"opt_externaleditorfolder","hp":"Externe Programme","h4":"Verzeichnis zur Übergabe temporärer Dateien an externen Editor (User)"},"972":{"id":972,"content":"Warnen wenn die Testsuite durch einen externen Editor verändert wird (User) Bei Änderung eines Skripts durch einen externen Editor wird eine Warnung angezeigt (siehe Kommando für externen Editor).","hash":"opt_warnonexternaledit","hp":"Externe Programme","h4":"Warnen wenn die Testsuite durch einen externen Editor verändert wird (User)"},"973":{"id":973,"content":"Warnen wenn der externe Editor ohne Dateinamen gestartet wird (User) Es wird gewarnt, wenn ein namenloses Skript im externen Editor geöffnet werden soll (siehe Kommando für externen Editor).","hash":"opt_warnonexternaleditnofilename","hp":"Externe Programme","h4":"Warnen wenn der externe Editor ohne Dateinamen gestartet wird (User)"},"974":{"id":974,"content":"Kommando für externes Grafikprogramm (User) Das Abbild eines Check Abbild Knotens kann in einem externen Grafikprogramm bearbeitet werden. Dazu wird die Grafik im PNG Format in einer temporären Datei gespeichert und das externe Grafikprogramm wird aufgerufen, um diese Datei zu bearbeiten. Nach dem Speichern der Datei und Beenden des Programms, lädt QF‑Test die Daten aus der Datei zurück in das Abbild. Diese Option legt das Kommando zum Aufruf des externen Grafikprogramms fest. Es gibt hierzu zwei Varianten: Die einfache Angabe einer ausführbaren Datei oder einen komplexen Befehl einschließlich Optionen. Letztere zeichnet sich dadurch aus, dass der Name der externen Datei durch den Platzhalter $(file) angegeben werden muss. Die Syntax $(file)/$(file) wird ausschließlich verwendet, um nicht wieder eine neue Konvention für variable Attribute einzuführen. Es findet keine standard QF‑Test Variablenexpansion für $(...) Ausdrücke statt. Einfache Kommandos müssen nicht durch Anführungsstriche geschützt werden, z.B.: gimp mspaint C:\\Windows\\System32\\mspaint.exe Komplexe Kommandos benötigen eventuell Anführungsstriche, insbesondere unter Windows. Um die Anführungsstriche für das $(file) Argument kümmert sich QF‑Test selbst: gimp --no-splash $(file) \"C:\\Windows\\System32\\mspaint.exe\" $(file)","hash":"opt_externalimager","hp":"Externe Programme","h4":"Kommando für externes Grafikprogramm (User)"},"975":{"id":975,"content":"HTML Browser (User) Diese Option legt den HTML Browser fest, der für das Öffnen von HTML-Dateien (z.B. Reports oder die die kontextsensitive Hilfe) verwendet wird. Sie können ein komplexes Kommando angeben, mit '$url' als Platzhalter für die anzuzeigende URL, z.B. netscape -remote openURL($url) oder ein einfaches Kommando wie firefox dem dann die URL als letztes Argument übergeben wird. Ist der Eintrag leer, so wird der System-Browser verwendet.","hash":"opt_browser","hp":"Externe Programme","h4":"HTML Browser (User)"},"976":{"id":976,"content":"Sicherungskopien Beim Speichern einer Testsuite oder eines Protokolls ist es möglich, automatisch Sicherungskopien von bereits vorhandenen Dateien zu erstellen. Mit Hilfe der folgenden Optionen legen Sie fest, unter welchen Bedingungen Sicherungskopien angelegt werden und wie deren Name gebildet wird.","hash":"sec_opt_backup","h1":"Sicherungskopien"},"977":{"id":977,"content":"Abbildung 41.9: Optionen für Sicherungskopien","hash":"figure_41.9","h4":"Abbildung 41.9: Optionen für Sicherungskopien"},"978":{"id":978,"content":"Sicherungskopien für Testsuiten erstellen (User) Nur wenn diese Option aktiviert ist, werden Sicherungskopien von Testsuiten erstellt. Bedenken Sie bitte, wieviel Arbeit in einer guten Testsuite steckt und wie leicht die Daten zerstört werden könnten, wenn Sie keine Kopie haben. Deaktivieren Sie diese Option daher nur, wenn Sie anderweitig für eine Sicherung gesorgt haben, z.B. durch den Einsatz eines Versionskontrollsystems.","hash":"opt_backupsuite","hp":"Sicherungskopien","h4":"Sicherungskopien für Testsuiten erstellen (User)"},"979":{"id":979,"content":"Sicherungskopien für Protokolle erstellen (User) Ein Protokoll ist im Allgemeinen weit weniger \"wertvoll\" als eine Testsuite, daher können Sie hiermit separat festlegen, ob Sie auch beim Speichern von Protokollen Sicherungskopien erstellen wollen.","hash":"opt_backuplog","hp":"Sicherungskopien","h4":"Sicherungskopien für Protokolle erstellen (User)"},"980":{"id":980,"content":"Wie oft Sicherungskopien erzeugen (User) Es gibt zwei Varianten für die Häufigkeit, mit der Sicherungen ihrer Dateien angelegt werden: Eine Sicherungskopie pro Sitzung bedeutet, dass nur beim ersten Speichern einer Testsuite, der Stand der letzten Sitzung gesichert wird. Bei jedem weiteren Speichern wird die neue Version überschrieben, die Kopie des alten Standes bleibt erhalten. Erst wenn Sie eine neue Testsuite laden, wird beim nächsten Speichern wieder kopiert. Diese Einstellung ist sinnvoll, wenn Sie nur eine Sicherungskopie pro Testsuite vorhalten. Wenn Sie dagegen mehrere Sicherungen für eine Testsuite erstellen, empfiehlt es sich, bei jedem Speichern eine Kopie anzulegen.","hash":"opt_backupsingle","hp":"Sicherungskopien","h4":"Wie oft Sicherungskopien erzeugen (User)"},"981":{"id":981,"content":"Name der Sicherungskopie (User) Wie vieles andere unterscheiden sich auch die Konventionen für die Namensgebung von Sicherungskopien in Linux und Windows Umgebungen. Unter Windows wird vorrangig die Endung .bak an den Dateinamen angehängt, während es unter Linux verschiedene Varianten gibt. Sehr häufig ist jedoch das Anhängen einer Tilde '~' anzutreffen.","hash":"opt_backupname","hp":"Sicherungskopien","h4":"Name der Sicherungskopie (User)"},"982":{"id":982,"content":"Anzahl der Sicherungskopien (User) Mit dieser Option legen Sie fest, wie viele Sicherungskopien Sie für jede Datei vorhalten wollen. Wenn Sie nur eine Datei wählen, wird deren Name wahlweise durch Anhängen von .bak oder einer Tilde '~' gebildet. Jedes mal, wenn eine weitere Sicherungskopie erstellt wird, wird die alte Sicherungskopie überschrieben. Wenn Sie dagegen mehrere Sicherungskopien wählen, erhält der Name zusätzlich eine Nummer nach folgendem Schema: bak1, bak2... für die Windows Konvention und ~1~, ~2~... andernfalls. Die aktuellste Sicherungskopie hat immer die Nummer 1. Beim Erstellen der nächsten Kopie, wird diese zur 2 und die neue Kopie erhält die 1. Ist die Maximalzahl erreicht, werden jeweils die ältesten Sicherungskopien gelöscht.","hash":"opt_backupnum","hp":"Sicherungskopien","h4":"Anzahl der Sicherungskopien (User)"},"983":{"id":983,"content":"Zeitabstand für automatische Speicherung (s) (User) Legt den Zeitabstand fest, nach dem eine modifizierte Testsuite automatisch gesichert wird. Ein Wert von 0 schaltet die automatische Sicherung aus, andere Werte unter ca. 20 Sekunden sind nicht sinnvoll. Protokolle werden grundsätzlich nicht automatisch gesichert. Autosave-Dateien werden im selben Verzeichnis wie die Testsuite abgelegt, oder - im Fall von neuen Testsuiten, die noch nie gespeichert wurden - im benutzerspezifischen Konfigurationsverzeichnis.","hash":"opt_autosaveinterval","hp":"Sicherungskopien","h4":"Zeitabstand für automatische Speicherung (s) (User)"},"984":{"id":984,"content":"Bibliothek","hash":"sec_opt_libpath","h1":"Bibliothek"},"985":{"id":985,"content":"Abbildung 41.10: Bibliotheksoptionen","hash":"figure_41.10","h4":"Abbildung 41.10: Bibliotheksoptionen"},"986":{"id":986,"content":"Verzeichnisse mit Testsuite-Bibliotheken (System) Hierbei handelt es sich um eine Liste von Verzeichnissen, die durchsucht werden, wenn eine Referenz auf eine Testsuite als relative Datei angegeben wird und nicht relativ zur aktuellen Suite aufgelöst werden kann. Das gilt für das Name der Prozedur Attribut eines Prozeduraufruf Knotens oder die Referenz der QF‑Test ID einer Komponente ebenso, wie für Testsuiten, die über das Attribut Inkludierte Dateien des Testsuite Knotens eingebunden werden. Siehe auch Der Aufruf einer Prozedur in einer anderen Testsuite. Die Bibliothekspfade in dieser Option gelten global für alle Testsuiten. Alternativ kann die Verzeichnisangabe relativ zu einem Projekt erfolgen. Dafür muss der Pfad in der Datei qftest.qpj des betreffenden Projekts eingetragen werden. Weitere Informationen hierzu finden Sie in \"Die Datei qftest.qpj\". In der Verzeichnisangabe können Umgebungsvariablen oder System-Properties referenziert werden. Die Syntax dafür lautet ${env:...} beziehungsweise ${system:...}. Sie können das Verzeichnis sogar während der Laufzeit ändern, indem Sie den in der Umgebungsvariablen oder System-Property hinterlegten Wert per Skript auf den neuen Wert setzen. Verwenden Sie hierzu rc.setProperty, das in \"Das rc-Modul: Die API des Runcontexts\" beschrieben ist. Die obige Syntax entspricht zwar dem QF‑Test Standard für Gruppen-Variablen oder Properties. Dies ist aber ein Sonderfall bei dem nur die Gruppen env bzw. system verwendet werden können. Das zur aktuellen Version von QF‑Test gehörende include Verzeichnis wird immer automatisch (und unsichtbar) an das Ende des Bibliothekspfads gestellt. Dadurch ist sichergestellt, dass die Bibliothek qfs.qft eingebunden werden kann, ohne ihren exakten Ort zu kennen, und dass ihre Version der von QF‑Test entspricht. Ist das Kommandozeilenargument -libpath <Pfad> angeben, hat es Vorrang vor dieser Option. Im interaktiven Modus wird der Wert des Kommandozeilenarguments hier angezeigt. Er wird aber nicht in der Systemkonfiguration gespeichert, es sei denn, der Wert wird manuell verändert.","hash":"opt_libpath","hp":"Bibliothek","h4":"Verzeichnisse mit Testsuite-Bibliotheken (System)"},"987":{"id":987,"content":"Inkludierte Testsuiten in einer neuen Testsuite (System) Diese Option legt fest, welche Testsuiten bei einer neuen Testsuite in der Liste Inkludierte Dateien eingetragen werden. Wenn nur der Testsuitename ohne Pfad angegeben wird, muss die Testsuite im gleichen Verzeichnis der inkludierenden Testsuite liegen oder in einem der Verzeichnisse mit Testsuite-Bibliotheken. Wenn keine Testsuite angegeben ist, wird in einer neuen Testsuite nur die Standard-Bibliothek qfs.qft eingebunden.","hash":"opt_includedfilesdefault","hp":"Bibliothek","h4":"Inkludierte Testsuiten in einer neuen Testsuite (System)"},"988":{"id":988,"content":"Lizenz","hash":"sec_opt_license","h1":"Lizenz"},"989":{"id":989,"content":"Abbildung 41.11: Lizenz Optionen Normalerweise beinhalten QF‑Test Lizenzen eine homogene Mischung von GUI-Engines. Ein Bündel von QF‑Test/swing Lizenzen unterstützt z.B. nur die AWT/Swing Engine, QF‑Test/suite Lizenzen beinhalten sowohl AWT/Swing als auch SWT für alle Instanzen. Für derartige Lizenzen spielen diese Lizenz-Einstellungen keine Rolle. Ein kleines Problem entsteht im Fall von gemischten Engine-Lizenzen, bei denen eine GUI Engine nur von einem Teil der Lizenzen unterstützt wird. Ein Beispiel für eine solche Lizenz ist ein Lizenzbündel, das früher für qftestJUI angeschafft wurde, mit QF‑Test 2.0 auf QF‑Test/suite aktualisiert und später um weitere QF‑Test/swing Lizenzen ergänzt wurde, sagen wir zwei Lizenzen für QF‑Test/suite und zwei für QF‑Test/swing. Eine solche Lizenz erlaubt den Start von vier QF‑Test Instanzen, von denen aber nur zwei SWT unterstützen. Der Versuch mehr als zwei Instanzen mit Nutzung der SWT Engine zu starten führt zu einem Lizenzkonflikt. Wenn QF‑Test eine solche gemischte Lizenz zum ersten mal erkennt, fragt es Sie, welche GUI Engines Sie benötigen. Die dort getroffene Entscheidung kann hier jederzeit korrigiert werden. Außerdem können Sie QF‑Test mit dem Kommandozeilenargument -engine <Engine> starten um für diese Ausführung die GUI-Engines explizit festzulegen.","hash":"figure_41.11","h4":"Abbildung 41.11: Lizenz Optionen"},"990":{"id":990,"content":"Updates Um die neusten Features und Fehlerbehebungen zu erhalten sucht QF‑Test automatisch nach Updates. Die folgenden Optionen legen fest, ob QF‑Test nach Updates suchen soll und wann über Updates informiert werden soll. Zusätzlich kann mit Hilfe des Kommandozeilenparameters \"-noupdatecheck\" die Suche nach Updates deaktiviert werden.","hash":"sec_opt_update","h1":"Updates"},"991":{"id":991,"content":"Abbildung 41.12: Optionen für Updates","hash":"figure_41.12","h4":"Abbildung 41.12: Optionen für Updates"},"992":{"id":992,"content":"Automatisch nach Updates suchen (User) Beim Start von QF‑Test wird automatisch nach Updates gesucht. Wenn Sie dies nicht möchten, deaktivieren Sie diese Option.","hash":"opt_checkforupdate","hp":"Updates","h4":"Automatisch nach Updates suchen (User)"},"993":{"id":993,"content":"Nach Update fragen (User) Wenn eine neue Version verfügbar ist, zeigt QF‑Test einen Hinweis mit Verweisen auf die Release Notes und die Download-Seite an. Diese Option kann die Hinweise auf bestimmte Arten von Updates begrenzen: Minor Updates enthalten vorwiegend Fehlerbehebungen und kleine Verbesserungen. Medium Upgrades erscheinen, um neue Features einzuführen. Major Upgrades beinhalten große neue Features und können das Verhalten von QF‑Test ändern.","hash":"opt_askforupdate","hp":"Updates","h4":"Nach Update fragen (User)"},"994":{"id":994,"content":"Pro Handbuch","hash":"","h0":"Aufnahme | QF‑Test Handbuch"},"995":{"id":995,"content":"Pro Handbuch","hash":"home-link","h0":"Aufnahme | QF‑Test Handbuch"},"996":{"id":996,"content":"Aufnahme Über die Aufnahme-Optionen lässt sich festlegen, welche Events von QF‑Test aufgezeichnet werden. Außerdem sind etliche Sonderbehandlungen von Events oder ganzen Sequenzen möglich.","hash":"sec_opt_record","h0":"Aufnahme"},"997":{"id":997,"content":"Abbildung 41.13: Aufnahmeoptionen","hash":"figure_41.13","h4":"Abbildung 41.13: Aufnahmeoptionen"},"998":{"id":998,"content":"Initiale Schnellstarthilfe für Aufnahmeknopf zeigen (User) Steuert die Anzeige eines initialen Fragezeichens auf dem Aufnahmeknopf, um neuen Benutzern direkt den Weg zum Schnellstart-Assistenten zu weisen.","hash":"opt_recordshowhelpbutton","hp":"Aufnahme","h4":"Initiale Schnellstarthilfe für Aufnahmeknopf zeigen (User)"},"999":{"id":999,"content":"Hotkey für Aufnahme (User) SUT Skript-Name: OPT_RECORD_HOTKEY Der Aufnahmemodus kann mittels einer Taste direkt im SUT gestartet und gestoppt werden. Mit dieser Option legen Sie die Taste für diese Funktion fest in dem Sie in das Feld klicken und die gewünschte Tastenkombination drücken. Die Standardtaste ist F11.","hash":"opt_hotkeyrecord","hp":"Aufnahme","h4":"Hotkey für Aufnahme (User)"},"1000":{"id":1000,"content":"Variablen in aufgenommenen Client-Namen erhalten (System) Ein sehr nützliches Feature für fortgeschrittene Anwender: Wenn Ihr SUT aus mehreren Clients besteht oder Sie einfach nur wiederverwendbare Tests erstellen wollen, ist es sehr sinnvoll, den Clientnamen in den verschiedenen Events, Checks etc. nicht fest einzugeben, sondern über eine Variable festzulegen (z.B. $(client)). Damit müssten Sie aber jedes mal, wenn Sie eine Aufnahme gemacht haben, den Namen des Clients in allen neuen Events durch die variable Angabe ersetzen, was zwar Dank »Bearbeiten«-»Suchen und ersetzen« in einem Rutsch geht, aber immer noch lästig ist. Wenn Sie diese Option aktivieren und beim Java-SUT-Client starten ebenfalls die variable Syntax verwenden, wird diese bei den Aufnahmen automatisch an Stelle des expandierten Namens eingesetzt.","hash":"opt_usetrueclientname","hp":"Aufnahme","h4":"Variablen in aufgenommenen Client-Namen erhalten (System)"},"1001":{"id":1001,"content":"Aufnahme bei aktueller Selektion einfügen (User) Ein sehr nützliches Feature: Je nachdem woran Sie gerade arbeiten, kann es sinnvoll sein, eine Aufnahme direkt an der Einfügemarkierung einzufügen - oder auch nicht. Ist diese Option gesetzt, werden alle neuen Events direkt eingefügt, andernfalls wird eine neue Sequenz mit der Aufzeichnung in den Extrasequenzen angelegt.","hash":"opt_insertatselection","hp":"Aufnahme","h4":"Aufnahme bei aktueller Selektion einfügen (User)"},"1002":{"id":1002,"content":"Hotkey für Checks (User) SUT Skript-Name: OPT_RECORD_CHECK_HOTKEY Wenn sich QF‑Test im Aufnahmemodus befindet, können Sie im SUT mittels einer Taste zwischen der normalen Aufzeichnung und der Aufzeichnung von Checks hin und her schalten. Mit dieser Option legen Sie die Taste für diese Funktion fest in dem Sie in das Feld klicken und die gewünschte Tastenkombination drücken. Die Standardtaste ist F12.","hash":"opt_hotkeycheck","hp":"Aufnahme","h4":"Hotkey für Checks (User)"},"1003":{"id":1003,"content":"Komponenten beim Checken hervorheben (User) SUT Skript-Name: OPT_RECORD_CHECK_HIGHLIGHT Wenn Sie einen Check aufzeichnen, kann QF‑Test eine kleine Hilfestellung geben, indem es die Komponente hervorhebt, über der sich der Mauszeiger gerade befindet. Dies geschieht durch Vertauschen von Vorder- und Hintergrundfarbe der Komponente, was vereinzelt zu unerwünschten visuellen Effekten führen kann. Daher können Sie diese Funktionalität hiermit abschalten.","hash":"opt_highlightduringcheck","hp":"Aufnahme","h4":"Komponenten beim Checken hervorheben (User)"},"1004":{"id":1004,"content":"Hinweis anzeigen, wenn keine Events aufgenommen wurden (User) Server Skript-Name: OPT_SHOW_EMPTY_RECORDING_MESSAGE Wenn eine Aufnahme gestartet und wieder beendet, ohne zwischendurch mit dem SUT zu interagieren, wird ein Hinweisdialog angezeigt, dass keine Events aufgenommen wurden. Durch Deaktivieren dieser Option kann dieser Dialog unterdrückt werden.","hash":"opt_showemptyrecordingmessage","hp":"Aufnahme","h4":"Hinweis anzeigen, wenn keine Events aufgenommen wurden (User)"},"1005":{"id":1005,"content":"Folgende Events aufnehmen Über diese Schalter lassen sich gezielt Events ein- oder ausschalten. Im Prinzip gilt hier: Finger weg, die Defaultwerte sind OK. In besonderen Fällen kann es aber doch sinnvoll sein, mit den Schaltern zu experimentieren.","hash":"sec_opt_recordevents","h1":"Folgende Events aufnehmen"},"1006":{"id":1006,"content":"Abbildung 41.14: Optionen für die Aufnahme von Events","hash":"figure_41.14","h4":"Abbildung 41.14: Optionen für die Aufnahme von Events"},"1007":{"id":1007,"content":"Abstrakte 'Mausklick'-Events (System) Ist diese Option aktiviert, wird eine Abfolge von MOUSE_MOVED, MOUSE_PRESSED, MOUSE_RELEASED und MOUSE_CLICKED Events als 'Mausklick' Pseudoevent aufgenommen (vgl. \"Mausevent\").","hash":"opt_recordmousemprc","hp":"Folgende Events aufnehmen","h4":"Abstrakte 'Mausklick'-Events (System)"},"1008":{"id":1008,"content":"Vereinfachte Aufnahme von 'Mausklick'-Events (System) Werden 'Mausklick'-Events aufgenommen, sollte diese Option ebenfalls aktiviert sein. Außer für Drag&Drop und einige spezielle MOUSE_MOVED Events basiert die Aufnahme dann primär auf der Umwandlung von MOUSE_PRESSED Events in Mausklicks. Dies liefert in den meisten Fällen die besten Ergebnisse, selbst wenn QF‑Test vom SUT zu wenige oder zu viele Events empfängt. Ist diese Option deaktiviert, kommt der Algorithmus von QF‑Test 4.0 und älter zum Einsatz. Dieser ist einen Versuch wert, wenn eine aufgenommene Sequenz einmal nicht direkt wiedergegeben werden kann.","hash":"opt_recordmousemprcsimple","hp":"Folgende Events aufnehmen","h4":"Vereinfachte Aufnahme von 'Mausklick'-Events (System)"},"1009":{"id":1009,"content":"Abstrakte 'Tastendruck'-Events (System) Hiermit können Sie eine Abfolge von KEY_PRESSED, KEY_TYPED und KEY_RELEASED Events (bzw. nur KEY_PRESSED und KEY_RELEASED für Funktions- und Sondertasten) automatisch als 'Tastendruck' Pseudoevent aufnehmen (vgl. \"Tastaturevent\").","hash":"opt_recordkeyptr","hp":"Folgende Events aufnehmen","h4":"Abstrakte 'Tastendruck'-Events (System)"},"1010":{"id":1010,"content":"Mausevents ohne Koordinaten aufnehmen wo möglich (System) SUT Skript-Name: OPT_RECORD_REPOSITION_MOUSE_EVENTS Für viele Arten von Komponenten und Unterelementen kommt es nicht darauf an, wo genau ein Mausevent registriert wird. Allerdings können große Werte für die X und Y Koordinaten von Mausevents zu Problemen führen, wenn die Zielkomponente ein wenig kleiner wird, z.B. weil sich der Font geändert hat oder ein Fenster verkleinert wurde. Zu große Koordinaten sind auch eine häufige Fehlerursache, wenn eine aufgenommene Sequenz in eine Prozedur mit variabler Zielkomponente konvertiert wird. Ist diese Option aktiviert, ignoriert QF‑Test die Koordinaten von Mausevents bei der Aufnahme, wenn es für die Zielkomponente keinen Unterschied macht, also z.B. für alle Arten von Buttons, Menüs, Zellen von Tabellen, Listeneinträgen und Baumknoten. Bei letzteren unterscheidet QF‑Test zwischen Klicks auf den Knoten selbst und Klicks auf den Schalter zum Ein- und Ausklappen. Bei der Wiedergabe von Mausevents ohne Koordinaten steuert QF‑Test die Mitte der Zielkomponente bzw. des Unterelements an, wobei für Unterelemente die X-Koordinate auf 5 begrenzt ist, da die Maße von Unterelementen nicht immer zuverlässig ermittelt werden können.","hash":"opt_repositionmouseevents","hp":"Folgende Events aufnehmen","h4":"Mausevents ohne Koordinaten aufnehmen wo möglich (System)"},"1011":{"id":1011,"content":"Öffnen eines Fensters in Warten auf Komponente konvertieren (System) Wenn während einer Aufnahme im SUT ein neues Fenster geöffnet wird, ist es oft sinnvoll, beim Abspielen der Sequenz an dieser Stelle erst zu warten, bis das Fenster erschienen ist, bevor Events an Komponenten des Fensters geschickt werden. Ist diese Option eingeschaltet, wird ein WINDOW_OPENED Event automatisch in einen Warten auf Komponente Knoten konvertiert. Diese Option hat seit der Einführung des impliziten Wartens stark an Bedeutung verloren. Für Web-Clients wird bei Aktivierung dieser Option ein Warten auf Laden des Dokuments Knoten jeweils dann eingefügt, wenn das Laden eines Dokuments abgeschlossen ist. Dies ist für die zuverlässige Synchronisation beim Navigieren zu einer anderen Seite sehr wichtig.","hash":"opt_convertwindowopenwait","hp":"Folgende Events aufnehmen","h4":"Öffnen eines Fensters in Warten auf Komponente konvertieren (System)"},"1012":{"id":1012,"content":"Eventsequenzen packen Machen Sie einmal ein Experiment und nehmen Sie eine kleine Sequenz auf, nachdem Sie die folgenden Optionen ausgeschaltet haben. Sie werden überrascht sein, wie viele Events generiert werden, nur um ein paar kleine Aktionen durchzuführen. Damit diese Flut beherrschbar bleibt gibt es in QF‑Test verschiedene Möglichkeiten, Events zu filtern oder Eventsequenzen zusammenzupacken.","hash":"sec_opt_packevents","h1":"Eventsequenzen packen"},"1013":{"id":1013,"content":"Abbildung 41.15: Optionen für das Packen von Events","hash":"figure_41.15","h4":"Abbildung 41.15: Optionen für das Packen von Events"},"1014":{"id":1014,"content":"MOUSE_MOVED Events (System) SUT Skript-Name: OPT_RECORD_PACK_MOUSE_MOVED Gerade MOUSE_MOVED Events werden in besonders großer Zahl generiert, wenn Sie Aktionen mit der Maus durchführen. Im Normalfall ist von einer ununterbrochenen Folge von diesen Events nur der letzte interessant (eine Ausnahme wäre z.B. das Freihand-Zeichnen in einem Grafikprogramm). Ist diese Option eingeschaltet, werden die überflüssigen MOUSE_MOVED Events herausgefiltert. Da auch die Events MOUSE_PRESSED, MOUSE_RELEASED und MOUSE_CLICKED Koordinaten enthalten, könnte man annehmen, dass MOUSE_MOVED Events gänzlich überflüssig sind. Dies ist nicht der Fall. Manche Java Komponenten reagieren auf einen Mausklick nur, wenn vorher die Maus tatsächlich dorthin bewegt wurde.","hash":"opt_packmousemoved","hp":"Eventsequenzen packen","h4":"MOUSE_MOVED Events (System)"},"1015":{"id":1015,"content":"MOUSE_DRAGGED Events (System) SUT Skript-Name: OPT_RECORD_PACK_MOUSE_DRAGGED Bei den MOUSE_DRAGGED Events verhält es sich ähnlich wie bei den MOUSE_MOVED Events: Nur der letzte in einer aufeinanderfolgenden Sequenz ist normalerweise von Bedeutung. Die Filterung ist daher analog zu den MOUSE_MOVED Events.","hash":"opt_packmousedragged","hp":"Eventsequenzen packen","h4":"MOUSE_DRAGGED Events (System)"},"1016":{"id":1016,"content":"Wartezeit beim Ziehen (System) SUT Skript-Name: OPT_RECORD_MOUSE_DRAGGED_HOVER Es gibt Situationen, in denen nicht alle MOUSE_DRAGGED Events gefiltert werden dürfen. Ein typisches Beispiel ist das Öffnen eines Untermenüs. Das folgende Beispiel stimmt so nicht mehr, da QF‑Test seit Version 1.05.2 keine MOUSE_MOVED oder MOUSE_DRAGGED Events mehr \"wegoptimiert\", die für das Öffnen eines Untermenüs benötigt werden. Es gibt aber vielleicht ähnlich geartete Situationen geben, bei denen die Aufnahme von Zwischenstationen beim Ziehen der Maus sinnvoll sein kann.","hash":"opt_draghover","hp":"Eventsequenzen packen","h4":"Wartezeit beim Ziehen (System)"},"1017":{"id":1017,"content":"SUT Skript-Name: OPT_RECORD_MOUSE_DRAGGED_HOVER Es gibt Situationen, in denen nicht alle MOUSE_DRAGGED Events gefiltert werden dürfen. Ein typisches Beispiel ist das Öffnen eines Untermenüs. Das folgende Beispiel stimmt so nicht mehr, da QF‑Test seit Version 1.05.2 keine MOUSE_MOVED oder MOUSE_DRAGGED Events mehr \"wegoptimiert\", die für das Öffnen eines Untermenüs benötigt werden. Es gibt aber vielleicht ähnlich geartete Situationen geben, bei denen die Aufnahme von Zwischenstationen beim Ziehen der Maus sinnvoll sein kann. Abbildung 41.16: Ziehen in ein Untermenü Wie das obige Bild illustriert, könnten Sie in QF‑Test einen neuen Testaufruf Knoten in eine Suite einfügen, indem Sie zunächst auf das »Eingabe« Menü klicken, dann bei gedrückter Maustaste den Zeiger auf »Test- und Sequenz-Knoten« bewegen, so dass das Untermenü ausklappt und letztlich den Zeiger auf »Testaufruf« bewegen und dort loslassen. Sofern die obige Option zum Packen von MOUSE_DRAGGED Events gesetzt ist, würde QF‑Test das gesamte Ziehen zu einem einzigen MOUSE_DRAGGED Event zusammenfassen, nämlich dem letzten auf den »Testaufruf« Eintrag im Untermenü. Das Abspielen dieser Sequenz würde scheitern, weil das Ziehen auf den »Test- und Sequenz-Knoten« Eintrag des Menüs übersprungen wird, so dass das Untermenü nicht ausklappt. Um dem vorzubeugen, können Sie beim Aufzeichnen der Sequenz eine Weile mit dem Mauszeiger auf dem »Test- und Sequenz-Knoten« Eintrag des Menüs verharren. Daran erkennt QF‑Test dass es einen zusätzlichen MOUSE_DRAGGED Event aufnehmen soll. Wie lange diese Ruhepause sein muss, legen Sie mit dieser Option fest.","hash":"figure_41.16","hp":"Eventsequenzen packen","h4":"Wartezeit beim Ziehen (System)"},"1018":{"id":1018,"content":"Maximaler Abstand beim Ziehen für 'Mausklick'-Event (System) Es kommt vor, dass der Mauszeiger unabsichtlich zwischen dem Drücken und Loslassen einer Maustaste bewegt wird. Je nach JDK Version und der Größe der Bewegung kann das als MOUSE_DRAGGED Event registriert werden. Für kleine Bewegungen kann QF‑Test diesen ignorieren um trotzdem einen 'Mausklick' Event zu erstellen. Diese Option legt fest, welche Distanz QF‑Test noch als einen Klick interpretiert. Ein MOUSE_DRAGGED Event, der darüber hinaus geht, wird unverändert übernommen.","hash":"opt_maxdragmprc","hp":"Eventsequenzen packen","h4":"Maximaler Abstand beim Ziehen für 'Mausklick'-Event (System)"},"1019":{"id":1019,"content":"Tastaturevents zu Texteingabe Knoten zusammenfassen (System) Auch für die simple Eingabe eines kurzen Textes werden massenhaft Events generiert. Würde man nur mit den normalen KEY_PRESSED, KEY_TYPED und KEY_RELEASED Events arbeiten, wäre dies nicht nur unübersichtlich, es wäre auch unmöglich, variablen Text zu erzeugen. Ist diese Option gesetzt, werden Folgen von Tastaturevents in eine Texteingabe umgewandelt, sofern die Komponente ein Textfeld ist (genauer: von der Klasse java.awt.TextField oder javax.swing.text.JTextField). Dabei werden nur normale Tasten (auch in Kombination mit der Shift Taste) berücksichtigt. Sondertasten und Kombinationen mit Strg oder Alt werden nicht gepackt. Beim Abspielen einer gepackten Textsequenz werden nur KEY_TYPED Events generiert, die KEY_PRESSED und KEY_RELEASED Events dagegen unterdrückt.","hash":"opt_packtextinput","hp":"Eventsequenzen packen","h4":"Tastaturevents zu Texteingabe Knoten zusammenfassen (System)"},"1020":{"id":1020,"content":"Automatisch Attribut 'Zielkomponente zunächst leeren' von Texteingabe Knoten setzen (System) Diese Option bestimmt den Wert des Attributs Zielkomponente zunächst leeren eines neu aufgenommenen Texteingabe Knotens. Ist die Option nicht gesetzt, wird auch das Attribut nicht gesetzt, andernfalls wird das Attribut genau dann aktiviert, wenn das Textfeld vor Beginn der Eingabe leer war.","hash":"opt_textinputclear","hp":"Eventsequenzen packen","h4":"Automatisch Attribut 'Zielkomponente zunächst leeren' von Texteingabe Knoten setzen (System)"},"1021":{"id":1021,"content":"Attribut 'Einzelne Events' von Texteingabe Knoten setzen (System) Hiermit wird der Wert des Attributs Einzelne Events wiedergeben in neu aufgenommenen Texteingabe Knoten festgelegt. Ist die Option gesetzt, wird das Attribut ebenfalls gesetzt, und umgekehrt. Der sichere Weg ist, diese Option eingeschaltet zu lassen. Bei einem typischen SUT, das keine eigenen KeyListener für Textfelder verwendet, sollte es keine Probleme geben, wenn das Attribut deaktiviert wird, um die Wiedergabe von Texteingabe Knoten zu beschleunigen.","hash":"opt_textinputsingle","hp":"Eventsequenzen packen","h4":"Attribut 'Einzelne Events' von Texteingabe Knoten setzen (System)"},"1022":{"id":1022,"content":"Komponenten Allgemeine Informationen zur den Einstellungen zur Aufnahme von Klassen: QF‑Test kann Klassen von Komponenten auf unterschiedliche Arten aufzeichnen. Hierzu gliedert QF‑Test Komponentenklassen in unterschiedliche Kategorien. Diese Kategorien sind die konkrete Klasse, die technologiespezifische Basisklasse, die generische Klasse sowie der spezielle Typ der generischen Klasse. Jede Kategorie wird unter Weitere Merkmale aufgezeichnet. Die Option Generische Klassen für Komponenten aufzeichnen ist die Standardeinstellung und bewirkt, dass generische Klassen aufgezeichnet werden. Mit dieser Einstellung können Ihre Tests auch für unterschiedliche Technologien mit minimalen Anpassungen lauffähig gemacht werden. Wenn Sie eine Java-Anwendung haben, die nur auf einer Technologie aufbaut und lieber die \"echten\" Java-Klassen sehen möchten, können Sie auch ohne generische Klassen arbeiten. Hierfür sollten Sie aber die Option Nur Systemklassen aufnehmen einschalten. Diese Option bewirkt, dass jeweils die Basisklasse der jeweiligen Java-Technologie aufgezeichnet wird und nicht die konkrete abgeleitete Klasse. Falls Sie diese Option ausschalten, zeichnet QF‑Test die konkrete Klasse des Objektes auf, welches zwar eine sehr gezielte Wiedererkennung auf Klassenebene bringt, allerdings bei Änderungen durch Refactoring der Klassen zu Anpassungsaufwand führt. Falls die konkreten Klassen obfuskiert sind, sollte diese Option auf keinen Fall aktiviert werden.","hash":"sec_opt_recordcomponents","h1":"Komponenten"},"1023":{"id":1023,"content":"Abbildung 41.17: Option für die Aufnahme von Komponenten","hash":"figure_41.17","h4":"Abbildung 41.17: Option für die Aufnahme von Komponenten"},"1024":{"id":1024,"content":"Hotkey für Komponenten (User) SUT Skript-Name: OPT_RECORD_COMPONENT_HOTKEY Hiermit legen Sie eine Taste bzw. Tastenkombination fest, mit der Sie das SUT in einen speziellen Modus ähnlich dem Aufzeichnungsmodus für Checks schalten können. Um den Wert zu ändern klicken Sie auf den aktuellen Eintrag (hierbei handelt um ein interaktives Feld) und drücken nun die gewünschte Taste bzw. Tastenkombination. Um das Feld zu verlassen, drücken Sie entweder die Tab-Taste oder setzen Sie den Fokus mit der Maus auf ein anderes Feld. Die Standard-Tastenkombination ist Shift⁠+⁠F11 für Window/Linux bzw. ⇧⁠+⁠F11 für Mac. In diesem Modus wird eine Komponente, die Sie mit der Maus anklicken, an QF‑Test übermittelt. Dort wird falls noch nicht vorhanden, wie nach einer Aufnahme ein entsprechender Knoten unterhalb des Fenster und Komponenten Knotens eingefügt. Außerdem steht die QF‑Test ID der Komponente im Clipboard zur Übernahme mit Strg⁠+⁠V bereit.","hash":"opt_hotkeycomponent","hp":"Komponenten","h4":"Hotkey für Komponenten (User)"},"1025":{"id":1025,"content":"SUT Skript-Name: OPT_RECORD_COMPONENT_HOTKEY Hiermit legen Sie eine Taste bzw. Tastenkombination fest, mit der Sie das SUT in einen speziellen Modus ähnlich dem Aufzeichnungsmodus für Checks schalten können. Um den Wert zu ändern klicken Sie auf den aktuellen Eintrag (hierbei handelt um ein interaktives Feld) und drücken nun die gewünschte Taste bzw. Tastenkombination. Um das Feld zu verlassen, drücken Sie entweder die Tab-Taste oder setzen Sie den Fokus mit der Maus auf ein anderes Feld. Die Standard-Tastenkombination ist Shift⁠+⁠F11 für Window/Linux bzw. ⇧⁠+⁠F11 für Mac. In diesem Modus wird eine Komponente, die Sie mit der Maus anklicken, an QF‑Test übermittelt. Dort wird falls noch nicht vorhanden, wie nach einer Aufnahme ein entsprechender Knoten unterhalb des Fenster und Komponenten Knotens eingefügt. Außerdem steht die QF‑Test ID der Komponente im Clipboard zur Übernahme mit Strg⁠+⁠V bereit. Abbildung 41.18: Popupmenü zum Aufnehmen von Komponenten Sie können auch eine ganze Hierarchie von Komponenten in einem Schritt aufzeichnen. Klicken Sie hierzu, nachdem Sie in diesen speziellen Modus geschaltet haben, mit der rechten Maustaste auf eine beliebige Komponente. Sie erhalten dann ein Popupmenü, in dem Sie vier Möglichkeiten zur Auswahl haben: Nur Komponente Diese Auswahl entspricht dem Klick mit der linken Maustaste. Es wird nur die gewählte Komponente aufgezeichnet. Komponente mit Kindern Es werden die ausgewählte Komponente und alle darin enthaltenen Komponenten aufgezeichnet. Ganzes Fenster Dient zur Aufnahme aller Komponenten im gesamten Fenster. Namen vorschlagen Dies ist eine besondere Funktion zur Unterstützung der Zusammenarbeit zwischen Testern und Entwicklern bei der Vergabe von Namen für Komponenten mittels setName. Sie zeichnet alle Komponenten im gesamten Fenster auf und legt diese in einer eigenen Testsuite ab. Alle Komponenten ohne eigenen Namen, für die ein Name zur Verbesserung der Testsicherheit sinnvoll erscheint, werden markiert. Hierzu erhalten diese einen Namen im Format \"SUGGESTED NAME (n): Vorschlag\". Die fortlaufende Zahl in Klammern dient nur zur Vermeidung von Duplikaten. Den Vorgeschlagenen Namen setzt QF‑Test aus der Klasse der Komponente und sonstigen verfügbaren Informationen zusammen. Er sollte nur als Anregung verstanden werden. Methoden anzeigen Hierbei handelt es sich um eine weitere Sonderfunktion, die ein Fenster mit den Attributen und Methoden der Klasse der selektierten Komponente öffnet. Weitere Informationen hierzu finden Sie in \"Komponenten untersuchen\". Wenn Sie eine einzelne Komponente abfragen wollen, drücken Sie im SUT einfach die hier eingestellte Taste. Nachdem Sie eine Komponente angeklickt haben und diese übermittelt wurde, schaltet das SUT von selbst in den vorherigen Modus zurück. Möchten Sie dauerhaft in diesen Modus bleiben verwenden Sie die Tastenkombination aus \"Komponenten untersuchen\". Zum Beenden drücken Sie einfach noch einmal den \"Hotkey\". Wenn Sie mehrere Testsuiten geöffnet haben, müssen Sie mit Hilfe des Menüeintrags »Aufnahme«-»Komponenten empfangen« festlegen, an welche Suite die auf diese Weise aufgenommenen Komponenten übermittelt werden sollen.","hash":"figure_41.18","hp":"Komponenten","h4":"Hotkey für Komponenten (User)"},"1026":{"id":1026,"content":"Hotkey für mehrere Komponenten aufnehmen (User) SUT Skript-Name: OPT_RECORD_COMPONENT_CONTINUE_HOTKEY Hiermit legen Sie eine Taste bzw. Tastenkombination fest, mit der Sie das SUT in den Komponentenaufnahme-Modus schalten können. Um den Wert zu ändern klicken Sie auf den aktuellen Eintrag (hierbei handelt um ein interaktives Feld) und drücken nun die gewünschte Taste bzw. Tastenkombination. Um das Feld zu verlassen, drücken Sie entweder die Tab-Taste oder setzen Sie den Fokus mit der Maus auf ein anderes Feld. Die Standard-Tastenkombination ist STRG⁠+⁠F11 für Window/Linux bzw. ⌃⁠+⁠F11 für Mac. Der Unterschied zu Hotkey für Komponenten ist, dass Sie dauerhaft in diesen Modus bleiben um mehrere Komponenten aufzunehmen zu können. Zum Beenden drücken Sie einfach noch einmal den \"Hotkey\".","hash":"opt_hotkeycomponentcontinue","hp":"Komponenten","h4":"Hotkey für mehrere Komponenten aufnehmen (User)"},"1027":{"id":1027,"content":"Generische Klassen für Komponenten aufzeichnen (System) SUT Skript-Name: OPT_RECORD_COMPONENT_GENERIC_CLASS Wenn möglich weist QF‑Test Komponenten \"Generische Klassen\" wie \"Button\", \"Table\" oder \"Tree\" zusätzlich zu den Java, DOM oder Framework-spezifischen Klassennamen wie \"javax.swing.JButton\", \"javafx.scene.control.Button\", \"INPUT\" oder \"X-BUTTON\" zu. Diese generischen Klassennamen sind verständlicher und robuster, verbessern die Kompatibilität zwischen verschiedenen Arten von Oberflächen und unterstützen die Entwicklung von generischen Prozeduren. Generische Klassennamen können für die Wiedererkennung von Komponenten und zur Registrierung von Resolvern verwendet werden. Ist diese Option gesetzt, zeichnet QF‑Test den generischen Klassennamen auf, sofern vorhanden. Weitere Informationen finden Sie in im einleitenden Teil dieses Abschnitts.","hash":"opt_recordgenericclass","hp":"Komponenten","h4":"Generische Klassen für Komponenten aufzeichnen (System)"},"1028":{"id":1028,"content":"Nur Systemklassen aufnehmen (System) SUT Skript-Name: OPT_RECORD_COMPONENT_SYSTEM_CLASS_ONLY Ist diese Option gesetzt, nimmt QF‑Test nur Standardklassen für Komponenten auf. Für kundenspezifische Klassen wird die Klassenhierarchie nach oben abgearbeitet, bis eine Standardklasse erreicht ist. Aktivieren Sie diese Option, wenn sich die Namen der GUI-Klassen Ihres Programms hin und wieder ändern. Weitere Informationen finden Sie im einleitenden Teil dieses Abschnitts. Sie müssen diese Option auf jeden Fall aktivieren, wenn Sie die jar Archive Ihrer Applikation durch Obfuscation schützen wollen, oder wenn die GUI Klassen mit einem eigenen ClassLoader geladen werden. Diese Option ist für Web-Clients ohne Bedeutung.","hash":"opt_dontrecordcustom","hp":"Komponenten","h4":"Nur Systemklassen aufnehmen (System)"},"1029":{"id":1029,"content":"Alle Klassen bei der Aufnahme von Komponenten akzeptieren (System) SUT Skript-Name: OPT_RECORD_TOLERANT_CLASS_MATCH Für die Kompatibilität mit älteren QF‑Test Versionen, die keine generischen Klassen kannten, zieht QF‑Test bei der Aufnahme zum Vergleich mit bestehenden Komponenten mehrere Klassen einer Komponente heran, die konkrete, die generische und die Systemklasse. Dies ist sehr hilfreich, wenn Sie Ihre alten Komponenten so weit möglich erhalten wollen. Wenn Sie stattdessen lieber generell neue Komponenten basierend auf generischen Klassen aufnehmen möchten, schalten Sie diese Option aus. Für Komponenten, die zum ersten mal aufgenommen werden, richtet sich die Klasse immer nach den beiden vorhergehenden Optionen Generische Klassen für Komponenten aufzeichnen und Nur Systemklassen aufnehmen.","hash":"opt_tolerantclassmatch","hp":"Komponenten","h4":"Alle Klassen bei der Aufnahme von Komponenten akzeptieren (System)"},"1030":{"id":1030,"content":"Wiedererkennung von Komponenten bei der Aufnahme validieren (System) SUT Skript-Name: OPT_VALIDATE_RECORDED_COMPONENTS Falls Komponenten im SUT nicht-eindeutige Namen zugewiesen wurden, kann QF‑Test diese Komponenten mit Hilfe des Weiteren Merkmals qfs:matchindex unterscheiden, welches den Index innerhalb der Komponenten mit gleichem Namen angibt. Ist diese Option gesetzt, prüft QF‑Test den Namen der Komponente bereits bei der Aufnahme auf Eindeutigkeit und versucht qfs:matchindex korrekt zu setzen. Sie sollten diese Option nur dann deaktivieren, wenn Sie sicher sind, dass Namen von Komponenten weitestgehend eindeutig sind und die Validierung die Performance bei der Aufnahme spürbar beeinträchtigt.","hash":"opt_validaterecordedcomponents","hp":"Komponenten","h4":"Wiedererkennung von Komponenten bei der Aufnahme validieren (System)"},"1031":{"id":1031,"content":"HTML Elemente in reinen Text konvertieren (System) SUT Skript-Name: OPT_RECORD_COMPONENT_CONVERT_HTML Swing unterstützt HTML-Auszeichnungen für verschiedene Arten von Labels, Buttons und Unterelementen von komplexen Komponenten. Bei der Identifizierung und Validierung von Komponenten sind die HTML-Tags oft im Weg. Ist diese Option gesetzt, konvertiert QF‑Test HTML in normalen Text, indem es alle HTML-Tags entfernt, so dass nur der reine Textinhalt erhalten bleibt.","hash":"opt_converthtml","hp":"Komponenten","h4":"HTML Elemente in reinen Text konvertieren (System)"},"1032":{"id":1032,"content":"Gewichtung von Namen (Aufnahme) (System) Server (automatisch weiter an SUT) Skript-Name: OPT_RECORD_COMPONENT_NAME_OVERRIDE Mögliche Werte: VAL_NAME_OVERRIDE_EVERYTHING, VAL_NAME_OVERRIDE_HIERARCHY, VAL_NAME_OVERRIDE_PLAIN Es gibt zwei Varianten dieser Option, die sehr eng miteinander verknüpft sind. Diese Variante ist während der Aufnahme aktiv, die andere bei der Wiedergabe. Natürlich sollten beide Optionen immer den selben Wert haben - mit einer Ausnahme: Wenn Sie von einer Einstellung zu einer anderen wechseln wollen, müssen eventuell Komponenten in QF‑Test aktualisiert werden. Bei diesem Prozess ist es notwendig, zunächst die Einstellung für die Wiedergabe auf dem alten Wert zu lassen und nur die Aufnahme Option umzustellen. Denken Sie aber unbedingt daran, nach Abschluss der Aktualisierung auch die Wiedergabe Option umzustellen. Diese Option legt fest, welches Gewicht dem Namen bei der Aufnahme von Komponenten beigemessen wird. Folgende Einstellungen sind möglich: Name übertrifft alles Dies ist die wirksamste und flexibelste Möglichkeit, Komponenten zu erkennen. Sie setzt allerdings voraus, dass die Namen der Komponenten zumindest pro Fenster eindeutig sind. Wenn diese Eindeutigkeit gegeben ist, verwenden Sie diese Einstellung. Verwenden Sie diesen Wert nicht bei Webseiten mit Frames. Für diese ist \"Hierarchie von Namen\" besser geeignet. Hierarchie von Namen Diese Einstellung sollten Sie verwenden, wenn Namen zwar nicht in jedem Fenster eindeutig vergeben sind, aber Komponenten mit gleichen Namen zumindest in unterschiedlichen Komponenten mit verschiedenen Namen enthalten sind, so dass sich eine Eindeutige Namenshierarchie ergibt. Damit ist die Wiedererkennung immer noch sehr tolerant gegenüber Veränderungen. Erst wenn Sie eine benannte Komponente in eine andere benannte Komponente verschieben, muss die Testsuite an diese Veränderung angepasst werden. Normales Attribut Falls es Komponenten mit identischen Namen im SUT gibt, die zudem in der gleichen Parent Komponente liegen, bleibt nur noch diese Einstellung. Der Name spielt damit immer noch eine wichtige Rolle, aber kaum mehr als das Merkmal Attribut.","hash":"opt_nameoverriderec","hp":"Komponenten","h4":"Gewichtung von Namen (Aufnahme) (System)"},"1033":{"id":1033,"content":"Automatische Namen für Komponenten in Eclipse/RCP-Anwendungen (System) SUT Skript-Name: OPT_RECORD_COMPONENT_AUTOMATIC_RCP_NAMES Eclipse und Anwendungen, die auf der Rich Client Platform (RCP) basieren, verfügen über ein komplexes GUI mit Unterstützung für wechselnde Perspektiven. Bei einem solchen Wechsel werden die Komponenten neu arrangiert, was die Wiedererkennung für QF‑Test schwierig macht, wenn nicht wenigstens für die wichtigsten Komponenten Namen gesetzt werden. Zusätzlich kompliziert wird es dadurch, dass die Struktur der Komponenten nicht der optischen Darstellung entspricht. Die Komponenten sind stattdessen relativ flach in der Workbench angeordnet. Positiv ist dagegen, dass RCP basierte Anwendungen über eine einheitliche innere Struktur basierend auf Views und Editors verfügen, von denen viele einen Namen besitzen. Falls diese Option aktiviert ist, versucht QF‑Test automatisch die GUI-Komponenten mit Ihren RCP Gegenstücken zu assoziieren und auf dieser Basis Namen für die Komponenten zu ermitteln. Dies kann die Wiedererkennung der Komponenten drastisch verbessern. Falls einige dieser automatisch ermittelten Namen allerdings nicht dauerhaft stabil sein sollten, können diese auch ein Hindernis darstellen. In diesem Fall kann für die Betroffenen Komponenten ein Name gesetzt werden, entweder mittels setData wie in \"Komponenten\" beschrieben, oder mit Hilfe eines NameResolvers wie in \"Das NameResolver Interface\" beschrieben. Beide Methoden haben Vorrang vor automatisch generierten Namen.","hash":"opt_rcpnames","hp":"Komponenten","h4":"Automatische Namen für Komponenten in Eclipse/RCP-Anwendungen (System)"},"1034":{"id":1034,"content":"Komponentenhierarchie (System) Server Skript-Name: OPT_RECORD_COMPONENT_HIERARCHY Mögliche Werte: VAL_RECORD_HIERARCHY_INTELLIGENT, VAL_RECORD_HIERARCHY_FULL, VAL_RECORD_HIERARCHY_FLAT QF‑Test bietet verschiedene Sichtweisen auf die Komponenten des SUT. In der flachen Sicht sind alle Komponenten eines Fensters gleichwertig unter diesem angeordnet. Für ein einfaches Fenster mag diese Sicht genügen, für komplexere Fenster geht nicht nur die Übersicht verloren, sondern auch wertvolle Strukturinformation für die Wiedererkennung. Das Gegenteil zur flachen Sicht ist die volle Hierarchie. Hier werden alle Komponenten des SUT 1:1 übernommen und in einer entsprechenden Baumstruktur angeordnet. Diese Darstellung kann wertvolle Informationen für Entwickler liefern, hat aber den Nachteil, dass das Einfügen einer weiteren Zwischenkomponente im SUT die Strukturinformationen ungültig macht und die Wiedererkennung aller Childkomponenten dieser neuen Komponente verhindert. Die Auswahl \"Intelligent\" liefert einen Kompromiss aus den beiden Extremwerten. Hiermit werden nur die \"interessanten\" Komponenten aus der Hierarchie des SUT übernommen. Komponenten wie JPanel, die ausschließlich der Strukturierung dienen, werden nicht aufgezeichnet. Die Verschachtelungstiefe des Baums wird dadurch deutlich reduziert. Im Moment ist die Entscheidungslogik, welche Komponenten als \"interessant\" anzusehen sind, hart verdrahtet. In späteren Versionen wird sie konfigurierbar sein.","hash":"opt_nesting","hp":"Komponenten","h4":"Komponentenhierarchie (System)"},"1035":{"id":1035,"content":"QF‑Test ID des Fensterknotens vor QF‑Test ID der Komponente setzen (System) Server Skript-Name: OPT_RECORD_COMPONENT_PREPEND_WINDOW_ID Ist diese Option aktiviert stellt QF‑Test bei der Aufnahme einer Komponente deren QF‑Test ID die QF‑Test ID des zugehörigen Fenster Knotens voran. Dies ist sinnvoll zur Unterscheidung von Komponenten mit gleichem Namen in verschiedenen Fenstern.","hash":"opt_addwindowid","hp":"Komponenten","h4":"QF‑Test ID des Fensterknotens vor QF‑Test ID der Komponente setzen (System)"},"1036":{"id":1036,"content":"QF‑Test ID des Parentknotens vor QF‑Test ID der Komponente setzen (System) Server Skript-Name: OPT_RECORD_COMPONENT_PREPEND_PARENT_ID Mögliche Werte: VAL_RECORD_COMPONENT_PREPEND_PARENT_ALWAYS, VAL_RECORD_COMPONENT_PREPEND_PARENT_NAMED, VAL_RECORD_COMPONENT_PREPEND_PARENT_FEATURE, VAL_RECORD_COMPONENT_PREPEND_PARENT_NEVER Wenn bei einer Aufnahme eine neue Komponente angelegt wird, vergibt QF‑Test automatisch eine QF‑Test ID. Dieser ID kann wahlweise die QF‑Test ID eines direkten oder indirekten Parentknotens der Komponente - durch einen Punkt getrennt - vorangestellt werden. Dies ist vor allem nützlich, um häufig auftretende Komponenten, die keinen eigenen Namen haben, unterscheidbar zu machen. Beispiel: Angenommen es gibt zwei JScrollPanes, von denen eine \"TreeScrollPane\" und die andere \"DetailScrollPane\" heißt. Ohne diese Funktion würden die beiden vertikalen Scrollbars die QF‑Test IDs \"scrollbarVertical\" und \"scrollbarVertical2\" erhalten. Mit dieser Funktion erhalten sie dagegen die QF‑Test IDs \"TreeScrollPane.scrollbarVertical\" und \"DetailScrollPane.scrollbarVertical\". Damit können Sie bei Events sofort erkennen, worauf sich diese beziehen. Es gibt vier mögliche Einstellungen: \"Niemals\" schaltet diese Funktionalität aus. \"Nächster Vorgänger mit Name\" ist eine sinnvolle Einstellung, wenn Ihre Entwickler allen wichtigen Komponenten mit der Java-Methode setName einen Namen gegeben haben. Eine Komponente, die selbst keinen Namen hat, bekommt den Namen des ersten seiner direkten und indirekten Parentknoten vorangestellt, der einen eigenen Namen hat. Wenn Sie nicht - oder nur eingeschränkt - mit setName arbeiten, ist die Einstellung \"Nächster Vorgänger mit Name oder Merkmal\" besser geeignet. Neben dem Namen eines Parentknotens kann auch dessen Merkmal ausschlaggebend sein. \"Immer\" ist nur dann sinnvoll, wenn Sie die Option Komponentenhierarchie auf den Wert \"Flach\" eingestellt haben. Hierbei wird jeder QF‑Test ID die QF‑Test ID des direkten Parentknotens vorangestellt, was bei tiefer Verschachtelung von Komponenten zu unbrauchbar langen QF‑Test IDs führt.","hash":"opt_addparentid","hp":"Komponenten","h4":"QF‑Test ID des Parentknotens vor QF‑Test ID der Komponente setzen (System)"},"1037":{"id":1037,"content":"Unterelemente Bei komplexen Komponenten wie Tabellen oder Bäumen können Events wahlweise so aufgenommen werden, dass sie sich auf Unterelemente der Komponenten beziehen und ihre Koordinaten relativ zu diesen Unterelementen sind.","hash":"sec_opt_relativeevents","h1":"Unterelemente"},"1038":{"id":1038,"content":"Abbildung 41.19: Option für die Aufnahme von Unterelementen","hash":"figure_41.19","h4":"Abbildung 41.19: Option für die Aufnahme von Unterelementen"},"1039":{"id":1039,"content":"Events auf Unterelemente beziehen (System) SUT Skript-Name: OPT_RECORD_SUBITEM Die oben beschriebene Funktionalität wird mit diesem Schalter aktiviert. Ist diese Option ausgeschaltet, beziehen sich neu aufgenommene Events immer auf die Komponente, nicht auf ein Unterelement.","hash":"opt_subitemmouseevents","hp":"Unterelemente","h4":"Events auf Unterelemente beziehen (System)"},"1040":{"id":1040,"content":"Mehrstufige Unterelemente (System) Server (automatisch weiter an SUT) Skript-Name: OPT_RECORD_SUBITEM_MULTILEVEL Über diese Option können Sie mehrstufige Unterelemente komplett ausschalten (auch für die Wiedergabe), was Sie aber nur tun sollten, wenn Sie Probleme mit alten Testsuiten haben, die ungeschützte Sonderzeichen wie '@' oder '%' im textuellen Index von Unterelementen enthalten. Allerdings wäre es in diesem Fall vorzuziehen, die Testsuiten zu aktualisieren und die Unterelemente korrekt zu schützen, ggf. über die spezielle Variablensyntax ${quoteitem:...} (vgl. \"Spezielle Gruppen\").","hash":"opt_multilevelsubitems","hp":"Unterelemente","h4":"Mehrstufige Unterelemente (System)"},"1041":{"id":1041,"content":"Format für Unterelemente (System) SUT Skript-Name: OPT_RECORD_SUBITEM_FORMAT Mögliche Werte: VAL_RECORD_SUBITEM_FORMAT_INTELLIGENT, VAL_RECORD_SUBITEM_FORMAT_TEXT, VAL_RECORD_SUBITEM_FORMAT_NUMBER Wenn Events sich auf Unterelemente einer Komponente beziehen, können Sie mit diesem Schalter festlegen, ob der Text der Elemente oder deren Position aufgenommen wird. Der Index für das Element wird in der entsprechenden Form als Text bzw. als Zahl angelegt. Mittels des Schalters \"Intelligent\" können Sie die Entscheidung QF‑Test übertragen. Der Index wird dann als Text erstellt, sofern der Name des Elements innerhalb der komplexen Komponente eindeutig ist. Andernfalls wird der Index als Zahl angelegt.","hash":"opt_subitemformat","hp":"Unterelemente","h4":"Format für Unterelemente (System)"},"1042":{"id":1042,"content":"Art der Unterelemente (System) Server Skript-Name: OPT_RECORD_SUBITEM_TYPE Mögliche Werte: VAL_RECORD_SUBITEM_TYPE_INTELLIGENT, VAL_RECORD_SUBITEM_TYPE_NODE, VAL_RECORD_SUBITEM_TYPE_SYNTAX Hiermit entscheiden Sie, ob bei der Aufnahme eines Events für ein Unterelement ein Element Knoten für dieses Unterelement in der Testsuite angelegt wird, oder ob das Element direkt im Attribut QF‑Test ID der Komponente des Mausevent Knotens angegeben wird (vgl. \"Unterelemente: Adressierung relativ zur übergeordneten Komponente\"). Wenn Sie mit dem Schalter \"Intelligent\" QF‑Test die Wahl überlassen, wird nur dann ein Knoten angelegt, wenn der Index als Text angegeben ist und das Unterelement im SUT nicht editierbar ist.","hash":"opt_subitemtype","hp":"Unterelemente","h4":"Art der Unterelemente (System)"},"1043":{"id":1043,"content":"Knoten im Baum als Pfad darstellen (System) SUT Skript-Name: OPT_RECORD_SUBITEM_TREE_PATH Es ist nicht ungewöhnlich, dass in einer Baumstruktur Knoten mit gleichen Namen aber verschiedenen Vaterknoten vorkommen, z.B. in einem Linux Dateisystem die Verzeichnisse /tmp und /usr/tmp. Durch Ausnutzen der hierarchischen Struktur und Verwendung von Pfadnamen in den Elementen kann QF‑Test diese Knoten unterscheiden. Dabei kommt das Zeichen '/' als Trennzeichen zum Einsatz. Ist diese Option nicht aktiviert, werden Bäume wie flache Listen betrachtet.","hash":"opt_subitempath","hp":"Unterelemente","h4":"Knoten im Baum als Pfad darstellen (System)"},"1044":{"id":1044,"content":"Aufnahmefenster Über die folgenden Einstellungen lässt sich Aussehen und Funktionsweise des Aufnahmefensters anpassen.","hash":"sec_opt_android_recordingwindow","h1":"Aufnahmefenster"},"1045":{"id":1045,"content":"Abbildung 41.20: Optionen für das Aufnahmefenster","hash":"figure_41.20","h4":"Abbildung 41.20: Optionen für das Aufnahmefenster"},"1046":{"id":1046,"content":"Automatische Skalierung (System) Server Skript-Name: OPT_RECORDING_DISPLAY_AUTO_SCALING Wenn diese Option gesetzt ist, wird das Vorschaubild im Aufnahmefenster automatisch anhand der Fenstergröße skaliert.","hash":"opt_android_recordingwindowautoscalingstate","hp":"Aufnahmefenster","h4":"Automatische Skalierung (System)"},"1047":{"id":1047,"content":"Bildschirmrand anzeigen (System) Server Skript-Name: OPT_SHOW_BORDER Zeichnet einen Rahmen um den Rand des virtuellen Bildschirms im Aufnahmefenster. Dadurch kann der Rand des Gerätes besser erkennbar werden, falls dessen Inhalt eine ähnliche Farbe hat wie das Aufnahmefenster.","hash":"opt_android_recordingwindowshowborder","hp":"Aufnahmefenster","h4":"Bildschirmrand anzeigen (System)"},"1048":{"id":1048,"content":"Vertikale Taskleiste anzeigen (System) Server Skript-Name: OPT_VERTICAL_TOOLBAR_STATE Blendet eine zusätzliche Leiste am Rand des Aufnahmefensters ein, die Aktionen zur Bedienung typischer Navigationselemente eines Gerätes enthält. Im Aufnahmemodus werden diese als Events aufgezeichnet.","hash":"opt_android_recordingwindowverticaltoolbar","hp":"Aufnahmefenster","h4":"Vertikale Taskleiste anzeigen (System)"},"1049":{"id":1049,"content":"Komponentenhervorhebung nach Klick (System) Server Skript-Name: OPT_CLICK_HIGHLIGHT Ist diese Option aktiviert, so wird nach einem Klick im Aufnahmefenster die darunterliegende Komponente für kurze Zeit durch einen Rahmen hervorgehoben. Dies kann hilfreich sein um schnell zu prüfen, ob ein Klick korrekt interpretiert wurde.","hash":"opt_android_recordingwindowclickhighlight","hp":"Aufnahmefenster","h4":"Komponentenhervorhebung nach Klick (System)"},"1050":{"id":1050,"content":"Dauer der Komponentenhervorhebung (ms) (System) Server Skript-Name: OPT_HIGHLIGHT_DURATION Hiermit steuern Sie, wie lange der Rahmen um eine ausgewählte Komponente angezeigt werden soll.","hash":"opt_android_recordingwindowhighlightduration","hp":"Aufnahmefenster","h4":"Dauer der Komponentenhervorhebung (ms) (System)"},"1051":{"id":1051,"content":"Intervall für automatische Aktualisierung (ms) (System) Server Skript-Name: OPT_RECORDING_AUTO_REFRESH_INTERVALL Hiermit steuern Sie, wie oft QF‑Test versuchen soll, den Inhalt des Aufnahmefensters zu aktualisieren. Bitte beachten Sie, dass die maximale Geschwindigkeit der Aktualisierung vom verwendeten Gerät oder Emulator/Simulator abhängt. Ein geringerer Intervall-Wert hat dann keinen Effekt. Ein zu geringer Wert kann die Systemleistung negativ beeinträchtigen.","hash":"opt_android_recordingwindowrefreshintervall","hp":"Aufnahmefenster","h4":"Intervall für automatische Aktualisierung (ms) (System)"},"1052":{"id":1052,"content":"Anzahl der Aktualisierungen nach einem Klick (System) Server Skript-Name: OPT_REFRESH_STEPS Hiermit legen Sie fest, wie oft das Aufnahmefenster nach einem Klick aktualisiert wird. Diese Option ist nur relevant, wenn die automatische Aktualisierung deaktiviert ist. Je nach der in Android konfigurierbaren Animationsgeschwindigkeit kann es vorkommen, dass das Vorschaufenster während einer laufenden Animation aktualisiert wird. In solchen Fällen kann diese Option hilfreich sein.","hash":"opt_android_recordingwindowrefreshsteps","hp":"Aufnahmefenster","h4":"Anzahl der Aktualisierungen nach einem Klick (System)"},"1053":{"id":1053,"content":"Wartezeit zwischen den Aktualisierungen nach einem Klick (ms) (System) Server Skript-Name: OPT_INTERVAL_TIME_AFTER_CLICK Hiermit legen Sie fest, wie viel Zeit zwischen den Aktualisierungen nach einem Klick vergehen soll. Diese Option ist nur relevant, wenn die automatische Aktualisierung deaktiviert ist. Bitte beachten Sie, dass die maximale Geschwindigkeit der Aktualisierung vom verwendeten Gerät oder Emulator/Simulator abhängt. Ein geringerer Intervall-Wert hat dann keinen Effekt.","hash":"opt_android_recordingwindowintervalafterclick","hp":"Aufnahmefenster","h4":"Wartezeit zwischen den Aktualisierungen nach einem Klick (ms) (System)"},"1054":{"id":1054,"content":"Swipe-Aufnahme (User) Hiermit legen Sie fest, wie Swipe-Aufnahme aufgezeichnet werden. Neben dem koordinatenbasierten Ansatz stehen ein einfacher Richtungsswipe-Modus (up, down, left, right) und ein intelligenter Modus zur Verfügung.","hash":"opt_recordingwindowswiperecording","hp":"Aufnahmefenster","h4":"Swipe-Aufnahme (User)"},"1055":{"id":1055,"content":"Auf der obersten Komponente wischen (System) Server Skript-Name: OPT_SWIPE_ON_TOPLEVEL_COMPONENT Ist diese Option aktiviert, so werden Wischgesten immer auf der obersten Komponente aufgenommen. Durch unterschiedliche Bildschirmgrößen und -Auflösungen von Geräten kann es vorkommen, dass einzelne Komponenten nicht immer innerhalb des sichtbaren Bereiches liegen. Dadurch können Wischgesten, bei denen die darunterliegende Komponente unwichtig ist, unzuverlässig werden. Besonders die Aufnahme von Navigationsgesten kann durch diese Option verbessert werden.","hash":"opt_android_recordingwindowswipeontoplevel","hp":"Aufnahmefenster","h4":"Auf der obersten Komponente wischen (System)"},"1056":{"id":1056,"content":"Zeit der Wischgeste aufnehmen (System) Server Skript-Name: OPT_MOBILE_RECORD_SWIPE_TIME Ist diese Option aktiviert, so wird die Zeit der Wischgesten aufgenommen. Um einen Fling-Effekt zu vermeiden oder zu erzielen kann man die Wischzeit mit aufzuzeichnen. Der Fling-Effekt ist das automatische, schnelle Weiterscrollen von Inhalten nach einer schnellen Wischbewegung auf dem Touchscreen.","hash":"opt_android_recordingwindowrecordswipetime","hp":"Aufnahmefenster","h4":"Zeit der Wischgeste aufnehmen (System)"},"1057":{"id":1057,"content":"Prozeduren Die folgenden Optionen haben Einfluss auf den Procedure Builder, der in \"Automatisierte Erstellung von Basisprozeduren\" detailliert beschrieben wird.","hash":"sec_opt_procbuilder","h1":"Prozeduren"},"1058":{"id":1058,"content":"Abbildung 41.21: Procedure Builder Optionen","hash":"figure_41.21","h4":"Abbildung 41.21: Procedure Builder Optionen"},"1059":{"id":1059,"content":"Hotkey für Prozedurenaufnahme (User) SUT Skript-Name: OPT_RECORD_PROCEDURE_HOTKEY Diese Option legt eine Taste bzw. Tastenkombination fest, mit der die Aufnahme von Prozeduren direkt vom SUT aus eingeschaltet werden kann. Um den Wert zu ändern klicken Sie auf den aktuellen Eintrag (hierbei handelt um ein interaktives Feld) und drücken nun die gewünschte Taste bzw. Tastenkombination. Um das Feld zu verlassen, drücken Sie entweder die Tab-Taste oder setzen Sie den Fokus mit der Maus auf ein anderes Feld. Die Standard-Tastenkombination ist Shift⁠+⁠F12 für Window/Linux bzw. ⇧⁠+⁠F12 für Mac.","hash":"opt_hotkeyprocedure","hp":"Prozeduren","h4":"Hotkey für Prozedurenaufnahme (User)"},"1060":{"id":1060,"content":"Hotkey für Prozedurenaufnahme (User) SUT Skript-Name: OPT_RECORD_PROCEDURE_CONTINUE_HOTKEY Diese Option legt eine Taste bzw. Tastenkombination fest, mit der die Aufnahme von Prozeduren direkt vom SUT aus eingeschaltet werden kann. Um den Wert zu ändern klicken Sie auf den aktuellen Eintrag (hierbei handelt um ein interaktives Feld) und drücken nun die gewünschte Taste bzw. Tastenkombination. Um das Feld zu verlassen, drücken Sie entweder die Tab-Taste oder setzen Sie den Fokus mit der Maus auf ein anderes Feld. Die Standard-Tastenkombination ist Strg⁠+⁠F12 für Window/Linux bzw. ⌃⁠+⁠F12 für Mac. Der Unterschied zu Hotkey für Prozedurenaufnahme ist, dass Sie dauerhaft in diesen Modus bleiben um mehrere Prozeduren aufzunehmen zu können. Zum Beenden drücken Sie einfach noch einmal den \"Hotkey\".","hash":"opt_hotkeyprocedurecontinue","hp":"Prozeduren","h4":"Hotkey für Prozedurenaufnahme (User)"},"1061":{"id":1061,"content":"Konfigurationsdatei für die Prozedurenaufnahme (System) Hier können Sie eine eigene Konfigurationsdatei für den Procedure Builder festlegen. Ist ein relativer Pfad angegeben, sucht QF‑Test im Verzeichnis, aus dem QF‑Test gestartet wurde, und im standard Include-Verzeichnis nach dieser Datei.","hash":"opt_pbconffile","hp":"Prozeduren","h4":"Konfigurationsdatei für die Prozedurenaufnahme (System)"},"1062":{"id":1062,"content":"Pro Handbuch","hash":"","h0":"Wiedergabe | QF‑Test Handbuch"},"1063":{"id":1063,"content":"Pro Handbuch","hash":"home-link","h0":"Wiedergabe | QF‑Test Handbuch"},"1064":{"id":1064,"content":"Wiedergabe Die folgenden Einstellungen beeinflussen das Verhalten von QF‑Test beim Abspielen eines Tests.","hash":"sec_opt_play","h0":"Wiedergabe"},"1065":{"id":1065,"content":"Abbildung 41.22: Wiedergabeoptionen","hash":"figure_41.22","h4":"Abbildung 41.22: Wiedergabeoptionen"},"1066":{"id":1066,"content":"Hotkey für Wiedergabe unterbrechen (\"Keine Panik\"-Taste) (User) Server (automatisch weiter an SUT) Skript-Name: OPT_PLAY_DONT_PANIC_HOTKEY Wenn ein Test mit voller Geschwindigkeit läuft, kann es ziemlich schwierig sein, den Fokus in eines von QF‑Tests Fenstern zu bekommen um den Test anzuhalten und etwas anderes zu erledigen, ohne dass einem ständig irgendwelche Fenster um die Ohren fliegen. Noch schwieriger wird das ganze im Batchmodus oder bei gesetzten Mauszeiger tatsächlich bewegen oder Fenster des SUT automatisch nach vorne bringen Optionen. Mit Hilfe dieser Option definieren Sie eine Tastenkombination (Standard ist Alt⁠+⁠F12), die sofort alle Tests pausiert, wenn sie in einem beliebigen Fenster gedrückt wird, egal ob im SUT oder in QF‑Test (es sei denn Sie haben mehrere Instanzen von QF‑Test gleichzeitig am laufen). Nochmaliges drücken der selben Tastenkombination setzt alle Tests fort, sofern Sie nicht manuell einen davon gestoppt oder fortgesetzt haben. In diesem Fall wird der Effekt automatisch auf \"Pausieren\" zurückgesetzt. Um den Hotkey festzulegen, klicken Sie in das Feld und drücken Sie die gewünschte Taste oder Tastenkombination.","hash":"opt_panickey","hp":"Wiedergabe","h4":"Hotkey für Wiedergabe unterbrechen (\"Keine Panik\"-Taste) (User)"},"1067":{"id":1067,"content":"Größe des Aufnahmestapels (System) Server Skript-Name: OPT_PLAY_CALLSTACK_SIZE Auf dem Callstack wird für jeden Prozeduraufruf ein Eintrag mit den Parametern abgelegt, der nach dem Ende der Prozedur wieder entfernt wird. Die Größe des Callstacks gibt somit an, wie tief Prozeduraufrufe geschachtelt sein können. Sie ist beschränkt, um eine endlose Rekursion zu erkennen und zu verhindern. Eine Überschreitung des Wertes führt zu einer StackOverflowException. Der Defaultwert von 200 sollte ausreichen, kann aber für sehr komplexe Tests vergrößert werden.","hash":"opt_callstacksize","hp":"Wiedergabe","h4":"Größe des Aufnahmestapels (System)"},"1068":{"id":1068,"content":"Warnung bei verschachtelten Testfällen ausgeben (System) Server Skript-Name: OPT_PLAY_WARN_NESTED_TEST_CASE Die Ausführung von Testfall Knoten sollte nicht verschachtelt werden, da solche Testfälle nicht korrekt im Report dargestellt werden können. Falls diese Option aktiviert ist, wird eine Warnung protokolliert, wenn ein Testfall innerhalb eines anderen Testfalls ausgeführt wird.","hash":"opt_warnnestedtestcase","hp":"Wiedergabe","h4":"Warnung bei verschachtelten Testfällen ausgeben (System)"},"1069":{"id":1069,"content":"Aktive Schritte markieren (User) Hier legen Sie fest, ob während der Wiedergabe die gerade aktiven Schritte im Baum mit einem kleinen Pfeil markiert werden sollen.","hash":"opt_markrunningsteps","hp":"Wiedergabe","h4":"Aktive Schritte markieren (User)"},"1070":{"id":1070,"content":"Aktive Schritte in der Statuszeile anzeigen (User) Der gerade ausgeführte Schritt kann auch in der Statuszeile angezeigt werden. Dieses Feature kann mit dieser Option aktiviert werden.","hash":"opt_printrunningsteps","hp":"Wiedergabe","h4":"Aktive Schritte in der Statuszeile anzeigen (User)"},"1071":{"id":1071,"content":"Fenster der Testsuite nach der Wiedergabe nach vorne bringen (User) Diese Option ist vor allem im Zusammenhang mit der Option Fenster des SUT automatisch nach vorne bringen interessant. Sie sorgt dafür, dass das Fenster der Testsuite nach der Wiedergabe einer Sequenz wieder nach vorne gebracht wird. Siehe auch Option Beim Nach-vorne-Bringen Fenster in den Vordergrund zwingen.","hash":"opt_raiseafter","hp":"Wiedergabe","h4":"Fenster der Testsuite nach der Wiedergabe nach vorne bringen (User)"},"1072":{"id":1072,"content":"Fenster der Testsuite während der Wiedergabe minimieren (User) Ist diese Option gesetzt, minimiert QF‑Test das Fenster einer Testsuite während ihre Tests ausgeführt werden. Das Fenster erscheint automatisch sobald der Test beendet oder unterbrochen wird. Diese Funktion ist insbesondere für Windows 2000/XP Systeme hilfreich. Dort ist es Programmen nicht erlaubt, ihre Fenster nach vorne zu bringen, so dass QF‑Test die Fenster des SUT nicht hinreichend beeinflussen kann.","hash":"opt_minimize","hp":"Wiedergabe","h4":"Fenster der Testsuite während der Wiedergabe minimieren (User)"},"1073":{"id":1073,"content":"Benachrichtigen nach (User) Nachdem die Wiedergabe beendet ist, wird in jedem Fall eine Meldung in der Statuszeile angezeigt, die über die Zahl der aufgetretenen Warnungen, Fehler und Exceptions Auskunft gibt. Zusätzlich kann nach Fehlern, Warnung oder generell am Ende jedes Testlaufs ein Nachrichtendialog angezeigt werden. Diese Option legt fest, welche Fehlerstufe die Anzeige dieser Nachricht auslöst.","hash":"opt_showmessageafter","hp":"Wiedergabe","h4":"Benachrichtigen nach (User)"},"1074":{"id":1074,"content":"Nach Fehler immer die Quelle anzeigen (User) Ist diese Option gesetzt, wird nach einer Exception bei der Ausführung der Schritt, der zum Fehler geführt hat, angezeigt und selektiert. Dies ist einerseits praktisch, kann andererseits aber störend sein, wenn man gerade etwas editiert. Der zuletzt aufgetretene Fehler kann zudem mittels »Wiedergabe«-»Letzte Fehlerursache anzeigen...« lokalisiert werden.","hash":"opt_selectonerror","hp":"Wiedergabe","h4":"Nach Fehler immer die Quelle anzeigen (User)"},"1075":{"id":1075,"content":"Salt für Verschlüsselung von Kennwörtern (System) QF‑Test kann Variablenwerte verschlüsseln und mit Hilfe der speziellen Variablen-Gruppe decrypt im Testablauf verfügbar machen (siehe \"Spezielle Gruppen\"). Außerdem können Kennwörter im Attribut Text eines Texteingabe Knotens für ein Passwort-Feld und im Attribut Detail eines Auswahl Knotens für einen Login-Dialog eines Web SUT verschlüsselt abgelegt werden. Bei der Ver- und Entschlüsselung solcher Kennwörter kombiniert QF‑Test seinen eigenen Schlüssel mit dem hier angegebenen Wert, dem sogenannten Salt. Ohne diesen wäre jeder ohne großen Aufwand in der Lage, Ihre verschlüsselten Kennwörter zu entschlüsseln und im Klartext zu sehen. Lassen Sie sich von dieser Option nicht zu sehr in Sicherheit wiegen. Jeder der Zugriff auf diesen Salt hat und jeder, der Ihre Tests ausführen kann, ist ebenfalls in der Lage, sich die Klartext-Version Ihrer Kennwörter zu verschaffen. Dennoch ist die Verschlüsselung sinnvoll, um zu verhindern, dass in Testsuiten und Protokollen gespeicherte Kennwörter ganz offensichtlich unverschlüsselt herumliegen. Verschlüsselte Kennwörter bieten einen vernünftigen Schutz vor Personen, die keinen Zugriff auf diesen Salt haben. Um eine verschlüsselte Variable innerhalb eines Skripts abzurufen, ohne diese zu entschlüsseln, verwenden Sie die Runcontext-Methode rc.getWrapped(), siehe Das rc-Modul: Die API des Runcontexts.","hash":"opt_passwordsalt","hp":"Wiedergabe","h4":"Salt für Verschlüsselung von Kennwörtern (System)"},"1076":{"id":1076,"content":"Behandlung von ausgeschalteten Komponenten (System) Server Skript-Name: OPT_PLAY_ERROR_STATE_DISABLED_COMPONENT Mögliche Werte: VAL_PLAY_DISABLED_COMPONENT_WARNING, VAL_PLAY_DISABLED_COMPONENT_ERROR, VAL_PLAY_DISABLED_COMPONENT_EXCEPTION Falls Sie eine Aktion wiedergeben und die dazugehörige Zielkomponente in der Testsuite ausgeschaltet ist, können Sie hier das gewünschte Verhalten festlegen. Sie können Eine Warnung in das Protokoll schreiben Eine Fehlermeldung in das Protokoll schreiben Eine DisabledComponentStepException werfen","hash":"opt_errorstatedisabledcomponent","hp":"Wiedergabe","h4":"Behandlung von ausgeschalteten Komponenten (System)"},"1077":{"id":1077,"content":"Behandlung von abgelaufener maximaler Ausführungszeit (System) Server Skript-Name: OPT_PLAY_ERROR_STATE_EXECUTION_TIMEOUT Mögliche Werte: VAL_PLAY_EXECUTION_TIMEOUT_WARNING, VAL_PLAY_EXECUTION_TIMEOUT_ERROR, VAL_PLAY_EXECUTION_TIMEOUT_EXCEPTION, VAL_PLAY_EXECUTION_TIMEOUT_WARNING_IMMEDIATE, VAL_PLAY_EXECUTION_TIMEOUT_ERROR_IMMEDIATE, VAL_PLAY_EXECUTION_TIMEOUT_EXCEPTION_IMMEDIATE Falls Sie eine Sequenz mit maximaler Ausführungszeit wiedergeben und diese Ausführungszeit abgelaufen ist, können Sie hier das gewünschte Verhalten festlegen. Sie können Eine Warnung in das Protokoll schreiben, welche den Testfall mit möglichen Aufräumaktionen fortsetzt. Eine Fehlermeldung in das Protokoll schreiben, welche den Testfall mit möglichen Aufräumaktionen fortsetzt. Eine ExecutionTimeoutExpiredException werfen, welche den Testfall mit möglichen Aufräumaktionen fortsetzt. Eine Warnung in das Protokoll schreiben und den Knoten sofort beenden, ohne Aufräumaktionen. Eine Fehlermeldung in das Protokoll schreiben und den Knoten sofort beenden, ohne Aufräumaktionen. Eine ExecutionTimeoutExpiredException werfen und den Knoten sofort beenden, ohne Aufräumaktionen. Die obige Definition von möglichen Aufräumaktionen bedeutet, dass Aufräumen- wie auch Catchknoten ausgeführt werden. Keine Aufräumaktionen bedeutet, dass diese Aufräum- und Catchknoten nicht ausgeführt werden.","hash":"opt_errorstateexecutiontimeout","hp":"Wiedergabe","h4":"Behandlung von abgelaufener maximaler Ausführungszeit (System)"},"1078":{"id":1078,"content":"Client Optionen Verschiedene Parameter für Prozesse und SUT-Clients können über die folgenden Optionen eingestellt werden:","hash":"sec_opt_clients","h1":"Client Optionen"},"1079":{"id":1079,"content":"Abbildung 41.23: Client Optionen","hash":"figure_41.23","h4":"Abbildung 41.23: Client Optionen"},"1080":{"id":1080,"content":"Leere Argument-Zeilen beim Start des Clients ignorieren (System) Server Skript-Name: OPT_PLAY_CLIENT_START_IGNORE_EMPTY_ARGUMENT Wenn die Option gesetzt ist (Standardeinstellung), werden leere Zeilen bei Programm-Parametern und Klassen-Argumenten in 'Starter'-Knoten wie zum Beispiel Java-SUT-Client starten, SUT-Client starten, Programm starten, Web-Engine starten, Windows-Anwendung starten oder Android-Emulator starten ignoriert. Dies ist insbesondere hilfreich, wenn Variablen für Parameter verwendet werden, da eine leere Variable dann analog dazu ist, den Parameter aus der Liste zu nehmen. Wird die Option ausgeschaltet, wird stattdessen ein leeres Kommandozeilenargument (also '') an das startende Programm übergeben.","hash":"opt_clientstartignoreemptyargument","hp":"Client Optionen","h4":"Leere Argument-Zeilen beim Start des Clients ignorieren (System)"},"1081":{"id":1081,"content":"Vor dem Beenden nach Stoppen der Clients fragen (User) Sind beim Beenden von QF‑Test noch Clients aktiv, werden diese nach einer Rückfrage beendet. Ist diese Option ausgeschaltet, werden die Clients ohne Rückfrage beendet.","hash":"opt_askstopclients","hp":"Client Optionen","h4":"Vor dem Beenden nach Stoppen der Clients fragen (User)"},"1082":{"id":1082,"content":"Beim Beenden eines Prozesses seinen gesamten Prozess-Baum beenden (System) Server Skript-Name: OPT_PLAY_KILL_PROCESS_TREE Der Prozess eines SUT oder eines Hilfsprogramms, das während eines Tests gestartet wurde, kann mittels eines Programm beenden Knotens oder manuell über das »Client« Menü beendet werden. Im Fall eines SUT versucht QF‑Test zunächst, mit diesem zu kommunizieren und einen sauberen Aufruf von System.exit auszulösen. Nicht-Java-Programme müssen hart terminiert werden. Falls das Programm weitere Kind-Prozesse gestartet hat, können diese dabei je nach Umständen automatisch beendet werden oder nicht. Es ist normalerweise nicht wünschenswert, solche Kind-Prozesse zu erhalten, da diese Konflikte mit weiteren Tests verursachen oder Dateien blockieren können, die gelöscht oder überschrieben werden sollen. Sofern diese Option nicht deaktiviert wird, versucht QF‑Test den gesamten Prozess-Baum für ein aus QF‑Test gestartetes Programm zu ermitteln und sicherzustellen, dass beim Beenden dieser Prozess und alles seine Kind-Prozesse explizit terminiert werden.","hash":"opt_killprocesstree","hp":"Client Optionen","h4":"Beim Beenden eines Prozesses seinen gesamten Prozess-Baum beenden (System)"},"1083":{"id":1083,"content":"Wie viele beendete Clients im Menü (User) Server Skript-Name: OPT_PLAY_MAX_CLIENTS Hiermit legen Sie die Anzahl der bereits beendeten Clients fest, deren Terminal noch über das »Clients« Menü zugänglich ist.","hash":"opt_numclients","hp":"Client Optionen","h4":"Wie viele beendete Clients im Menü (User)"},"1084":{"id":1084,"content":"Maximalgröße des Terminals für einen Client (kB) (User) Server (automatisch weiter an SUT) Skript-Name: OPT_PLAY_TERMINAL_SIZE Die maximale Menge an Text (in Kilobyte), die ein individuelles Client-Terminal aufnimmt. Ist diese Schwelle überschritten, wird alter Text entfernt wenn neuer Text hinzukommt. Der Wert 0 steht für unbegrenzten Text. Diese Option legt auch die Menge an Ausgaben fest, die über die speziellen Variablen ${qftest:client.output.<name>}, ${qftest:client.stdout.<name>} und ${qftest:client.stderr.<name>} verfügbar sind.","hash":"opt_clientoutputsize","hp":"Client Optionen","h4":"Maximalgröße des Terminals für einen Client (kB) (User)"},"1085":{"id":1085,"content":"Selektierte Komponente im SUT hervorheben (User) Server Skript-Name: OPT_PLAY_HIGHLIGHT_COMPONENTS Ist diese Option gesetzt, hebt QF‑Test die zugehörige Komponente im SUT optisch hervor, wenn ein Komponente Knoten oder ein Knoten, der eine Komponente referenziert, selektiert wird.","hash":"opt_flashcomponent","hp":"Client Optionen","h4":"Selektierte Komponente im SUT hervorheben (User)"},"1086":{"id":1086,"content":"Behandlung von Exceptions im SUT (System) SUT Skript-Name: OPT_PLAY_SUT_EXCEPTION_LEVEL Mögliche Werte: VAL_PLAY_EXCEPTION_LEVEL_WARNING, VAL_PLAY_EXCEPTION_LEVEL_ERROR, VAL_PLAY_EXCEPTION_LEVEL_EXCEPTION Exceptions, die während der Abarbeitung eines Events im SUT auftreten, deuten sehr wahrscheinlich auf einen Fehler im SUT hin. Mit dieser Option legen Sie fest, welche Konsequenzen dieser Fall hat. Sie können Eine Warnung in das Protokoll schreiben Eine Fehlermeldung in das Protokoll schreiben Eine UnexpectedClientException werfen","hash":"opt_clientexceptionlevel","hp":"Client Optionen","h4":"Behandlung von Exceptions im SUT (System)"},"1087":{"id":1087,"content":"IDs für SUT-Clients in Unterprozessen wiederverwenden (System) Server Skript-Name: OPT_PLAY_REUSE_SUT_IDS Dies ist eine komplexe Option die Sie hoffentlich nie benötigen werden. Wenn ein SUT Client einen Unterprozess startet, der sich seinerseits mit QF‑Test verbindet, erhält der neue SUT-Client einen speziellen Namen. Dieser wird aus dem Client-Namen des ursprünglichen SUT gebildet, gefolgt von ':' und einer numerischen ID. Die erste solche ID ist immer 2, mit aufsteigenden Zahlen für weitere Unterprozesse. Wird ein Unterprozess beendet und ein neuer gestartet, kann QF‑Test entweder die ID des beendeten Prozesses wiederverwenden, oder die IDs weiter hochzählen und eine neue ID vergeben. In den meisten Fällen ist es besser die IDs für Unterprozesse wiederzuverwenden. Ein typischer Fall ist, dass ein Unterprozess gestartet, beendet und wieder gestartet wird. Wenn Sie diese Option aktivieren können Sie in einem solchen Fall den Unterprozess immer mit dem gleichen Namen adressieren. In einer komplexeren Situation können eventuell diverse Unterprozesse relativ willkürlich gestartet und beendet werden, je nach Ablauf eines Tests. In diesem Fall ist die Vergabe einer immer neuen ID deterministischer. In jedem Fall wird der Zähler wieder zurückgesetzt, wenn der ursprüngliche SUT Client neu gestartet wird.","hash":"opt_reusesubclientids","hp":"Client Optionen","h4":"IDs für SUT-Clients in Unterprozessen wiederverwenden (System)"},"1088":{"id":1088,"content":"Automatisch Garbage-Collection im SUT durchführen (System) SUT Skript-Name: OPT_PLAY_SUT_GARBAGE_COLLECTION Normalerweise führt QF‑Test im SUT automatisch eine volle Garbage-Collection durch, nachdem einige hundert SUT-Skript Knoten ausgeführt wurden. Dies ist notwendig, da der standard Mechanismus zur Garbage-Collection in Java zu einem OutOfMemoryError im sogenannten PermGen Space führen kann, obwohl dort problemlos Speicher durch eine Garbage-Collection wiedergewonnen werden könnte. Wenn Sie versuchen, das Speicherverhalten Ihrer Anwendung genauer zu analysieren, kann diese explizite Garbage-Collection die Ergebnisse beeinflussen. Für diesen Fall können Sie mit Hilfe dieser Option die Garbage-Collection durch QF‑Test unterbinden.","hash":"opt_garbagecollectsut","hp":"Client Optionen","h4":"Automatisch Garbage-Collection im SUT durchführen (System)"},"1089":{"id":1089,"content":"Terminal Optionen Verschiedene Parameter für das gemeinsame Terminal können über die folgenden Optionen eingestellt werden.","hash":"sec_opt_terminal","h1":"Terminal Optionen"},"1090":{"id":1090,"content":"Abbildung 41.24: Terminal options","hash":"figure_41.24","h4":"Abbildung 41.24: Terminal options"},"1091":{"id":1091,"content":"Maximalgröße des gemeinsamen Terminals (kB) (User) Server Skript-Name: OPT_PLAY_SHARED_TERMINAL_SIZE Die maximale Menge an Text (in Kilobyte), die das gemeinsame Terminal aufnimmt. Ist diese Schwelle überschritten, wird alter Text entfernt wenn neuer Text hinzukommt. Der Wert 0 steht für unbegrenzten Text.","hash":"opt_terminalsize","hp":"Terminal Optionen","h4":"Maximalgröße des gemeinsamen Terminals (kB) (User)"},"1092":{"id":1092,"content":"Regulärer Ausdruck, um die Anzeige bestimmter Texte zu unterdrücken (User) Durch Angabe eines regulären Ausdrucks in dieser Option können bestimmte Texte in der Terminalausgabe unterdrückt werden. Standardwert ist leer. Siehe auch Reguläre Ausdrücke - Regexps.","hash":"opt_terminalregexpsuppress","hp":"Terminal Optionen","h4":"Regulärer Ausdruck, um die Anzeige bestimmter Texte zu unterdrücken (User)"},"1093":{"id":1093,"content":"Terminal mit RichText-Formatierungen nutzen (User) Aktiviert das RichText Terminal, das eine monospaced Font und die farbige Hervorhebung von selbstdefinierten regulären Ausdrücken erlaubt. Deaktivieren Sie diese Option, wenn sie zum einfachen Terminal zurückwechseln möchten, wie es vor QF‑Test Version 4 war. QF‑Test muss neu gestartet werden, um eine Änderung dieser Option sichtbar zu machen.","hash":"opt_terminalrichtext","hp":"Terminal Optionen","h4":"Terminal mit RichText-Formatierungen nutzen (User)"},"1094":{"id":1094,"content":"Festbreitenschriftart verwenden (User) Wenn aktiviert, wird für das gemeinsame Terminal eine Festbreitenschriftart verwendet. Diese Option hat nur einen Effekt, wenn Terminal mit RichText-Formatierungen nutzen aktiv ist.","hash":"opt_terminalmonospaced","hp":"Terminal Optionen","h4":"Festbreitenschriftart verwenden (User)"},"1095":{"id":1095,"content":"Reguläre Ausdrücke farbig hervorheben (User) Mit dieser Option kann die farbige Hervorhebung von selbstdefinierten regulären Ausdrücken ein- und ausgeschaltet werden. Diese Option hat nur einen Effekt, wenn Terminal mit RichText-Formatierungen nutzen und Reguläre Ausdrücke farbig hervorheben aktiv sind.","hash":"opt_terminalregexpcoloring","hp":"Terminal Optionen","h4":"Reguläre Ausdrücke farbig hervorheben (User)"},"1096":{"id":1096,"content":"Regulärer Ausdruck für rote Hervorhebung (User) In dieser Option kann ein regulärer Ausdruck für Ausgaben definiert werden, die rot hervorgehoben werden sollen. Diese Option hat nur einen Effekt, wenn Terminal mit RichText-Formatierungen nutzen und Reguläre Ausdrücke farbig hervorheben aktiv sind. Standardwert ist: (?md).+Exception\\b.*\\n(?%gt;\\n?^(?%gt;\\sat|Caused by:)\\s.+\\n)+|.*(?i)exception(?%gt;s)?\\b.* Dadurch werden auch typische Java-Stack-Traces bei Exceptions rot hervorgehoben. Siehe auch Reguläre Ausdrücke - Regexps.","hash":"opt_terminalregexpcolor0","hp":"Terminal Optionen","h4":"Regulärer Ausdruck für rote Hervorhebung (User)"},"1097":{"id":1097,"content":"Regulärer Ausdruck für orange Hervorhebung (User) In dieser Option kann ein regulärer Ausdruck für Ausgaben definiert werden, die orange hervorgehoben werden sollen. Diese Option hat nur einen Effekt, wenn Terminal mit RichText-Formatierungen nutzen und Reguläre Ausdrücke farbig hervorheben aktiv sind. Standardwert ist: (?md)^[1-2] \\(\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d\\) .*|.*(?i)(?%gt;error(?%gt;s)?|fehler)\\b.* Dadurch werden auch Fehler-Protokollmeldungen hervorgehoben. Siehe auch Reguläre Ausdrücke - Regexps.","hash":"opt_terminalregexpcolor1","hp":"Terminal Optionen","h4":"Regulärer Ausdruck für orange Hervorhebung (User)"},"1098":{"id":1098,"content":"Regulärer Ausdruck für gelbe Hervorhebung (User) In dieser Option kann ein regulärer Ausdruck für Ausgaben definiert werden, die gelb hervorgehoben werden sollen. Diese Option hat nur einen Effekt, wenn Terminal mit RichText-Formatierungen nutzen und Reguläre Ausdrücke farbig hervorheben aktiv sind. Standardwert ist: (?md)^[3-4] \\(\\d\\d:\\d\\d:\\d\\d\\.\\d\\d\\d\\) .*|.*(?i)(?%gt;warning(?%gt;s)?|warnung(?%gt;en)?)\\b.* Dadurch werden auch Warnungs-Protokollmeldungen hervorgehoben. Siehe auch Reguläre Ausdrücke - Regexps.","hash":"opt_terminalregexpcolor2","hp":"Terminal Optionen","h4":"Regulärer Ausdruck für gelbe Hervorhebung (User)"},"1099":{"id":1099,"content":"Regulärer Ausdruck für blaue Hervorhebung (User) In dieser Option kann ein regulärer Ausdruck für Ausgaben definiert werden, die blau hervorgehoben werden sollen. Diese Option hat nur einen Effekt, wenn Terminal mit RichText-Formatierungen nutzen und Reguläre Ausdrücke farbig hervorheben aktiv sind. Standardwert ist leer. Siehe auch Reguläre Ausdrücke - Regexps.","hash":"opt_terminalregexpcolor3","hp":"Terminal Optionen","h4":"Regulärer Ausdruck für blaue Hervorhebung (User)"},"1100":{"id":1100,"content":"Regulärer Ausdruck für grüne Hervorhebung (User) In dieser Option kann ein regulärer Ausdruck für Ausgaben definiert werden, die grün hervorgehoben werden sollen. Diese Option hat nur einen Effekt, wenn Terminal mit RichText-Formatierungen nutzen und Reguläre Ausdrücke farbig hervorheben aktiv sind. Standardwert ist leer. Siehe auch Reguläre Ausdrücke - Regexps.","hash":"opt_terminalregexpcolor4","hp":"Terminal Optionen","h4":"Regulärer Ausdruck für grüne Hervorhebung (User)"},"1101":{"id":1101,"content":"Events Diese Optionen beeinflussen einige Details bei der Wiedergabe von Events.","hash":"sec_opt_replayevents","h1":"Events"},"1102":{"id":1102,"content":"Abbildung 41.25: Optionen zur Eventbehandlung","hash":"figure_41.25","h4":"Abbildung 41.25: Optionen zur Eventbehandlung"},"1103":{"id":1103,"content":"Fenster des SUT automatisch nach vorne bringen (System) SUT Skript-Name: OPT_PLAY_RAISE_SUT_WINDOWS Ist diese Option gesetzt, werden Fenster des SUT, für die ein Mouse- oder KeyEvent simuliert wird, bei der Aktivierung nach vorne gebracht. Das vereinfacht den Wechsel zwischen QF‑Test und dem SUT, um den Ablauf einer Sequenz zu beobachten. Siehe auch Optionen Fenster der Testsuite nach der Wiedergabe nach vorne bringen und Beim Nach-vorne-Bringen Fenster in den Vordergrund zwingen.","hash":"opt_automaticraise","hp":"Events","h4":"Fenster des SUT automatisch nach vorne bringen (System)"},"1104":{"id":1104,"content":"Beim Nach-vorne-Bringen Fenster in den Vordergrund zwingen (System) SUT Skript-Name: OPT_PLAY_RAISE_SUT_WINDOWS_FORCED Diese Option wird nur für Windows Systeme unterstützt. Windows erlaubt einer Anwendung nur dann, ein eigenes Fenster nach vorne zu bringen, wenn diese Anwendung bereits den Fokus besitzt. Dies kann es für QF‑Test schwierig machen, Fenster des SUT in den Vordergrund zu bringen oder automatisch zwischen dem SUT und QF‑Test zu wechseln. Ist diese Option aktiv, setzt QF‑Test vorübergehend die Eigenschaft \"Immer im Vordergrund\", um ein Fenster nach vorne zu zwingen. Siehe auch Optionen Fenster der Testsuite nach der Wiedergabe nach vorne bringen und Fenster des SUT automatisch nach vorne bringen.","hash":"opt_forcedraise","hp":"Events","h4":"Beim Nach-vorne-Bringen Fenster in den Vordergrund zwingen (System)"},"1105":{"id":1105,"content":"Auf modale Dialoge prüfen (System) SUT Skript-Name: OPT_PLAY_CHECK_MODAL Modale Dialoge sind solche Dialoge, die alle anderen Fenster blockieren. Sie werden unter anderem für Fehlermeldungen verwendet. Da QF‑Test die Events quasi durch die Hintertür an den Client schickt, werden diese durch einen modalen Dialog nicht blockiert und können weitere Aktionen im Hauptfenster auslösen, was die Situation nach einem Fehler nur noch verschlimmern kann. Daher wird - sofern diese Option gesetzt ist - vor der Ausführung jedes Events überprüft, ob das Zielfenster durch einen modalen Dialog blockiert ist und in diesem Fall eine ModalDialogException ausgelöst. Auch diese Option sollte immer eingeschaltet bleiben und wird evtl. ganz entfernt werden.","hash":"opt_checkmodaldialog","hp":"Events","h4":"Auf modale Dialoge prüfen (System)"},"1106":{"id":1106,"content":"Mauszeiger tatsächlich bewegen (System) SUT Skript-Name: OPT_PLAY_MOVE_MOUSE_CURSOR Ist diese Option gesetzt, wird der Mauszeiger bei der Simulation von Mausevents tatsächlich über den Bildschirm bewegt. Diese Funktion benötigt einen funktionsfähigen AWT Robot. Obwohl diese Option hauptsächlich dem visuellen Feedback dient, kann sie einen positiven Einfluss auf die Zuverlässigkeit von Tests haben, da sie die Nebeneffekte von Systemevents reduziert die den Test beeinträchtigen könnten. Allerdings sollte diese Option für solche Tests ausgeschaltet sein, bei denen es auf präzise Mausbewegungen ankommt, z.B. für ein Zeichenwerkzeug.","hash":"opt_hardmousemoves","hp":"Events","h4":"Mauszeiger tatsächlich bewegen (System)"},"1107":{"id":1107,"content":"System-Events während der Wiedergabe zurückstellen (ms) (System) SUT Skript-Name: OPT_PLAY_DELAY_HARD_EVENTS Greift nur bei Swing- und SWT-Anwendungen. Während der Wiedergabe filtert oder verzögert QF‑Test verschiedene Events, die nicht von QF‑Test ausgelöst wurden, sondern vom System kommen, z.B. weil der Anwender die Maus bewegt. Insbesondere Popupfenster für Menüs oder Comboboxen sind sehr empfindlich gegenüber solchen Störeinflüssen. Diese Funktionalität erhöht daher die Stabilität von Tests. Mit dieser Option lässt sich die maximale Verzögerung für solche Events einstellen. Für den unwahrscheinlichen Fall dass diese Filterung unerwünschte Nebeneffekte hat, kann sie mit dem Wert 0 ausgeschaltet werden.","hash":"opt_blockhardevents","hp":"Events","h4":"System-Events während der Wiedergabe zurückstellen (ms) (System)"},"1108":{"id":1108,"content":"Automatisch scrollen um Unterelemente anzuzeigen (System) SUT Skript-Name: OPT_PLAY_SCROLL_ITEM Ist diese Option gesetzt, werden die Unterelemente von komplexen Komponenten, die sich in einer Scrollpane befinden, automatisch in den sichtbaren Bereich gescrollt, wenn QF‑Test darauf zugreift. In diesem Fall können Sie die meisten aufgenommene Events auf Scrollbars oder Scrollbuttons entfernen, da sie für eine korrekte Wiedergabe nicht mehr benötigt werden.","hash":"opt_autoscroll","hp":"Events","h4":"Automatisch scrollen um Unterelemente anzuzeigen (System)"},"1109":{"id":1109,"content":"Knoten im Baum bei Bedarf ausklappen (System) SUT Skript-Name: OPT_PLAY_EXPAND_TREE Wenn die Knoten eines Baums als hierarchische Unterelemente angesprochen werden, können Knoten als Ziel angegeben werden, die im Moment nicht sichtbar sind, weil ein übergeordneter Knoten nicht expandiert ist. Ist diese Option gesetzt, werden in diesem Fall alle übergeordneten Knoten automatisch expandiert. Andernfalls führt diese Situation zu einer ComponentNotFoundException.","hash":"opt_treeexpand","hp":"Events","h4":"Knoten im Baum bei Bedarf ausklappen (System)"},"1110":{"id":1110,"content":"DisabledComponentExceptions werfen (System) SUT Skript-Name: OPT_PLAY_THROW_DISABLED_EXCEPTION Wenn QF‑Test Events für eine Komponente abspielt, die im Moment deaktiviert ist, werden diese Events einfach ignoriert. Diese Situation deutet praktisch immer auf einen Fehler hin, der durch werfen einer DisabledComponentException signalisiert wird. Ältere Testsuiten sind eventuell nicht auf diese Exception vorbereitet. Diese Testsuiten sollten angepasst werden. Als schneller Workaround können DisabledComponentExceptions aber auch durch deaktivieren dieser Option unterdrückt werden.","hash":"opt_throwdisabled","hp":"Events","h4":"DisabledComponentExceptions werfen (System)"},"1111":{"id":1111,"content":"Erlaubte Abweichung beim Check von Abbildern (System) SUT Skript-Name: OPT_PLAY_IMAGE_TOLERANCE Dies Option war zunächst nur für SWT/Gtk gedacht, hat sich aber als universell anwendbar und nützlich erwiesen. Die Darstellung von Grafik ist in Java-Anwendungen und Web-Browsern nicht immer ganz deterministisch. Selbst innerhalb desselben Laufs einer Anwendung auf einem Display mit begrenzter Farbtiefe können die RGB Werte einer Icon Abbildung geringfügig variieren und bei der Ausführung von Tests auf verschiedenen Rechnern sind stärkere Abweichungen möglich. Grafiktreiber, JDK Version und Einstellungen des Betriebssystems spielen auch eine Rolle. Dies mach strikte Checks von Abbildungen unter Umständen fast unbrauchbar. Um das Problem zu umgehen legt diese Option eine Toleranzschwelle für klassische Checks von Abbildungen fest, bis zu der Abweichungen in den einzelnen Farbanteilen rot, grün und blau eines Pixels erlaubt sind. Mit einem Wert von 0 lassen sich somit exakte Checks erzwingen, allerdings ist hierfür der \"identity\" Algorithmus besser geeignet (vgl. Details des Algorithmus zum Bildvergleich). Der Standardwert von 5 ist ein guter Kompromiss, bei dem Checks mit Abweichungen, die normalerweise nicht visuell wahrnehmbar sind, erfolgreich sein können.","hash":"opt_imagefuzz","hp":"Events","h4":"Erlaubte Abweichung beim Check von Abbildern (System)"},"1112":{"id":1112,"content":"Standardalgorithmus für Bildvergleiche (System) Server Skript-Name: OPT_PLAY_IMAGE_CHECK_DEFAULT_ALGORITHM Mithilfe des Algorithmus zum Bildvergleich Attributes eines Check Abbild kann man festlegen, welcher Algorithmus für den Bildvergleich verwendet werden soll. Auch rc.checkImageAdvanced kennt ein Algorithmus-Argument. Sollte dieses Attribut bzw. im Falle von rc.checkImageAdvanced dieses Argument leer gelassen werden, so wird der über diese Option verwendete Algorithmus verwendet.","hash":"opt_imagecheckdefaultalgo","hp":"Events","h4":"Standardalgorithmus für Bildvergleiche (System)"},"1113":{"id":1113,"content":"Behandlung von Events auf dem falschen Thread (System) SUT Skript-Name: OPT_PLAY_WRONG_THREAD_ERROR_LEVEL Mögliche Werte: VAL_PLAY_THREAD_LEVEL_WARNING, VAL_PLAY_THREAD_LEVEL_ERROR, VAL_PLAY_THREAD_LEVEL_EXCEPTION Ein häufiger Fehler in Swing basierten Java-Anwendungen ist der Zugriff auf GUI Komponenten von einem falschen Thread. Da Swing nicht thread-safe ist, dürfen solche Aufrufe nur vom AWT Event Dispatch Thread kommen. Andernfalls können Race-Conditions oder Deadlocks die Folge sein. Erstere können zu subtilen und schwer auffindbaren Fehlern führen, bei letzteren friert die Anwendung komplett ein und ist nicht mehr verwendbar. Hintergrund-Informationen zu diesem Thema finden Sie unter http://download.oracle.com/javase/tutorial/uiswing/concurrency/index.html, speziell die Abschnitte zu \"Initial Threads\" und \"The Event Dispatch Thread\". Wenn QF‑Test einen Event auf einem anderen als dem AWT Event Dispatch Thread erhält, gibt es eine Fehlermeldung zusammen mit einem aktuellen Stacktrace aus, der bei der Beseitigung des Fehlers hilfreich sein kann. Diese Gruppe von Optionen legt die Fehlerstufe der Meldung fest, ob strikte Tests durchgeführt werden und wie viele Meldungen maximal ausgegeben werden. Die möglichen Werte für die Option \"Fehlerstufe\" sind \"Fehler\" und \"Warnung\". Wir raten dringend dazu, die Standardeinstellung \"Fehler\" beizubehalten und derartige Probleme in der Anwendung umgehend zu beseitigen, da sie ein hohes Risiko darstellen.","hash":"opt_threaderror","hp":"Events","h4":"Behandlung von Events auf dem falschen Thread (System)"},"1114":{"id":1114,"content":"Strikte Prüfung (System) SUT Skript-Name: OPT_PLAY_WRONG_THREAD_STRICT Falls die Option \"Strikte Prüfung\" aktiviert ist, werden für sämtliche Events von einem falschen Thread Meldungen ausgegeben. Andernfalls werden \"weniger wichtige\" Events ignoriert. Die Unterscheidung ist willkürlich und beruht auf der Tatsache, dass es diverse Java-Literatur gibt (inklusive früherer Java-Dokumentation von Sun), in der es als korrekt dargestellt wird, Swing Komponenten auf einem beliebigen Thread zu initialisieren, solange diese nicht angezeigt werden. Viele Java-Programme sind so implementiert und das Risiko ist in diesem Fall in der Tat gering. Für derartigen Code verhindert das Abschalten von \"Strikte Prüfung\", dass deswegen massenhaft Fehler gemeldet werden und ggf. ernstere Probleme dadurch nicht mehr wahrgenommen werden. Wenn Sie dagegen alle Thread-Verstöße beseitigen wollen, was wir grundsätzlich empfehlen, sollten Sie \"Strikte Prüfung\" aktivieren.","hash":"opt_threadstrict","hp":"Events","h4":"Strikte Prüfung (System)"},"1115":{"id":1115,"content":"Maximale Anzahl von Fehlermeldungen pro SUT-Client (System) SUT Skript-Name: OPT_PLAY_WRONG_THREAD_MAX_ERRORS Wenn Ihre Anwendung Code enthält, der die Thread-Vorgaben verletzt, kann es sein dass daraus eine sehr große Menge von Fehlermeldungen resultiert, was zu einem starken Einbruch der Performance führen kann. Andererseits bringen diese Fehlermeldungen nach der ersten Handvoll keine neue Information mehr. Mittels der Option \"Maximale Anzahl von Fehlermeldungen pro SUT-Client\" kann die Zahl der Fehlermeldungen begrenzt werden.","hash":"opt_threadmaxerrors","hp":"Events","h4":"Maximale Anzahl von Fehlermeldungen pro SUT-Client (System)"},"1116":{"id":1116,"content":"Wiedererkennung Mit diesen Optionen können Sie die Wiedererkennung von Komponenten zur Laufzeit eines Tests beeinflussen. Die vorgegebenen Werte sollten im Normalfall gute Ergebnisse liefern, aber wenn Komponenten nicht erkannt werden, können andere Einstellungen vielleicht helfen. Die Bedeutung der einzelnen Werte ist \"Gewichtung der Wiedererkennungsmerkmale bei aufgenommenen Komponenten\" erläutert.","hash":"sec_opt_recognition","h1":"Wiedererkennung"},"1117":{"id":1117,"content":"Abbildung 41.26: Optionen zur Wiedererkennung Der Name einer Komponente spielt eine besondere Rolle. Die folgende Optionen beeinflusst das Gewicht, das QF‑Test den Namen beimisst:","hash":"figure_41.26","h4":"Abbildung 41.26: Optionen zur Wiedererkennung"},"1118":{"id":1118,"content":"Gewichtung von Namen (Wiedergabe) (System) SUT Skript-Name: OPT_PLAY_RECOGNITION_NAME_OVERRIDE Mögliche Werte: VAL_NAME_OVERRIDE_EVERYTHING, VAL_NAME_OVERRIDE_HIERARCHY, VAL_NAME_OVERRIDE_PLAIN Es gibt zwei Varianten dieser Option, die sehr eng miteinander verknüpft sind. Diese Variante ist während der Wiedergabe aktiv, die andere bei der Aufnahme. Natürlich sollten beide Optionen immer den selben Wert haben - mit einer Ausnahme: Wenn Sie von einer Einstellung zu einer anderen wechseln wollen, müssen eventuell Komponenten in QF‑Test aktualisiert werden. Bei diesem Prozess ist es notwendig, zunächst die Einstellung für die Wiedergabe auf dem alten Wert zu lassen und nur die Aufnahme Option umzustellen. Denken Sie aber unbedingt daran, nach Abschluss der Aktualisierung auch die Wiedergabe Option umzustellen. Diese Option legt fest, welches Gewicht dem Namen bei der Wiedererkennung von Komponenten beigemessen wird. Folgende Einstellungen sind möglich: Name übertrifft alles Dies ist die wirksamste und flexibelste Möglichkeit, Komponenten zu erkennen. Sie setzt allerdings voraus, dass die Namen der Komponenten zumindest pro Fenster eindeutig sind. Wenn diese Eindeutigkeit gegeben ist, verwenden Sie diese Einstellung. Verwenden Sie diesen Wert nicht bei Webseiten mit Frames. Für diese ist \"Hierarchie von Namen\" besser geeignet. Hierarchie von Namen Diese Einstellung sollten Sie verwenden, wenn Namen zwar nicht in jedem Fenster eindeutig vergeben sind, aber Komponenten mit gleichen Namen zumindest in unterschiedlichen Komponenten mit verschiedenen Namen enthalten sind, so dass sich eine Eindeutige Namenshierarchie ergibt. Damit ist die Wiedererkennung immer noch sehr tolerant gegenüber Veränderungen. Erst wenn Sie eine benannte Komponente in eine andere benannte Komponente verschieben, muss die Testsuite an diese Veränderung angepasst werden. Normales Attribut Falls es Komponenten mit identischen Namen im SUT gibt, die zudem in der gleichen Parent Komponente liegen, bleibt nur noch diese Einstellung. Der Name spielt damit immer noch eine wichtige Rolle, aber kaum mehr als das Merkmal Attribut. Der Algorithmus zur Wiedererkennung von Komponenten ist sehr tolerant und darauf ausgerichtet, nach Möglichkeit einen Treffer zu finden. Falls die beste Übereinstimmung nicht ganz vollständig ist, gibt QF‑Test Information über die verbliebenen Abweichungen aus, wahlweise als Warnung oder einfache Meldung, abhängig von folgenden Optionen:","hash":"opt_nameoverride","hp":"Wiedererkennung","h4":"Gewichtung von Namen (Wiedergabe) (System)"},"1119":{"id":1119,"content":"Meldung ausgeben bei fehlendem Namen (System) SUT Skript-Name: OPT_PLAY_WARN_MISSING_NAME Ist diese Option gesetzt, wird eine Meldung im Protokoll ausgegeben, wenn beim Ablauf eines Tests eine Komponente angesprochen wird, die noch keinen Namen hat, aber einen brauchen könnte. Soweit möglich wird dabei ein sinnvoller Name vorgeschlagen.","hash":"opt_warnformissingname","hp":"Wiedererkennung","h4":"Meldung ausgeben bei fehlendem Namen (System)"},"1120":{"id":1120,"content":"Meldung ausgeben bei mehrdeutigem Namen (System) SUT Skript-Name: OPT_PLAY_WARN_AMBIGUOUS_NAME Ist die Option Gewichtung von Namen (Wiedergabe) auf \"Name übertrifft alles\" oder \"Hierarchie von Namen\" gesetzt, wird eine Meldung im Protokoll ausgegeben wenn QF‑Test auf mehr als eine mögliche Zielkomponente mit dem selben Namen trifft. Diese Meldung kann mit Hilfe dieser Option unterdrückt werden.","hash":"opt_warnforduplicatename","hp":"Wiedererkennung","h4":"Meldung ausgeben bei mehrdeutigem Namen (System)"},"1121":{"id":1121,"content":"Meldung ausgeben bei Abweichung beim Merkmal (System) SUT Skript-Name: OPT_PLAY_WARN_FEATURE_MISMATCH Wird eine Komponente im SUT als die bestgeeignete für einen Event oder Check ausgewählt obwohl in einer oder mehrerer Ebenen der Hierarchie das aufgenommene Merkmal nicht mit der Komponente übereinstimmt, sprechen wir von einer \"Abweichung beim Merkmal\". Ist diese Option aktiviert, wird in einem solchen Fall eine Meldung ausgegeben, die Sie darauf hinweist, dass es eine gute Idee sein könnte, die betroffenen Komponenten zu aktualisieren.","hash":"opt_warnforfeaturemismatch","hp":"Wiedererkennung","h4":"Meldung ausgeben bei Abweichung beim Merkmal (System)"},"1122":{"id":1122,"content":"Meldung ausgeben bei Abweichung bei weiterem Merkmal (System) SUT Skript-Name: OPT_PLAY_WARN_EXTRA_FEATURE_MISMATCH Eine \"Abweichung bei weiterem Merkmal\" ist analog zur oben beschriebenen Abweichung beim Merkmal, nur dass sie sich auf die weiteren Merkmale mit Status \"Sollte übereinstimmen\" bezieht. Ist diese Option aktiviert, wird im Fall einer Abweichung eine Meldung ausgegeben, die Sie darauf hinweist, dass es eine gute Idee sein könnte, die betroffenen Komponenten zu aktualisieren.","hash":"opt_warnforextrafeaturemismatch","hp":"Wiedererkennung","h4":"Meldung ausgeben bei Abweichung bei weiterem Merkmal (System)"},"1123":{"id":1123,"content":"Meldung ausgeben bei Abweichung bei der Struktur (System) SUT Skript-Name: OPT_PLAY_WARN_STRUCTURE_MISMATCH Eine \"Abweichung bei der Struktur\" ist analog zur oben beschriebenen Abweichung beim Merkmal, nur dass es hier statt dem Merkmal die Struktur-Attribute Index und Insgesamt sind, die nicht übereinstimmen. Ist diese Option aktiviert, wird in einem solchen Fall eine Meldung ausgegeben, die Sie darauf hinweist, dass es eine gute Idee sein könnte, die betroffenen Komponenten zu aktualisieren.","hash":"opt_warnforstructuremismatch","hp":"Wiedererkennung","h4":"Meldung ausgeben bei Abweichung bei der Struktur (System)"},"1124":{"id":1124,"content":"Meldung ausgeben bei zusätzlichem Vorgänger mit Namen (System) SUT Skript-Name: OPT_PLAY_WARN_NAMED_ANCESTOR Eine direkte oder indirekte Parent-Komponente der ausgewählten Zielkomponente im SUT, die nicht in der Hierarchie in QF‑Test auftaucht obwohl sie einen Namen hat, stellt eine Abweichung vergleichbar der bei Merkmal oder Struktur dar, sofern die Option Gewichtung von Namen (Wiedergabe) auf den Wert \"Hierarchie von Namen\" gesetzt ist. Ist diese Option aktiviert, wird in einem solchen Fall eine Meldung ausgegeben, die Sie darauf hinweist, dass es eine gute Idee sein könnte, die betroffenen Komponenten zu aktualisieren.","hash":"opt_warnforintermediatenamedancestor","hp":"Wiedererkennung","h4":"Meldung ausgeben bei zusätzlichem Vorgänger mit Namen (System)"},"1125":{"id":1125,"content":"Warnung anstelle von Meldung ausgeben (System) SUT Skript-Name: OPT_PLAY_COMPONENT_WARNINGS Ist diese Option aktiviert, werden Abweichungen bei der Wiedererkennung als Warnungen statt einfacher Meldungen ausgegeben. Es kann hilfreich sein, diese Option vorübergehend einzuschalten, um die Sichtbarkeit solcher Abweichung zu erhöhen, z.B. um die Informationen für die Komponenten zu aktualisieren, oder ungewollt erkannten Komponenten auf die Spur zu kommen. Im normalen Testbetrieb erzeugt dies zu viel Rauschen und führt dazu, dass wichtigere Warnungen übersehen werden. Erklärungen zu den übrigen Optionen für die Wiedererkennung finden Sie in \"Gewichtung der Wiedererkennungsmerkmale bei aufgenommenen Komponenten\". Die zugehörigen SUT-Skript Namen dieser Optionen lauten: OPT_PLAY_RECOGNITION_BONUS_NAME OPT_PLAY_RECOGNITION_PENALTY_NAME OPT_PLAY_RECOGNITION_BONUS_FEATURE OPT_PLAY_RECOGNITION_PENALTY_FEATURE OPT_PLAY_RECOGNITION_BONUS_EXTRAFEATURE OPT_PLAY_RECOGNITION_PENALTY_EXTRAFEATURE OPT_PLAY_RECOGNITION_BONUS_STRUCTURE OPT_PLAY_RECOGNITION_PENALTY_STRUCTURE OPT_PLAY_RECOGNITION_PENALTY_MODAL OPT_PLAY_RECOGNITION_MINIMUM_PROBABILITY","hash":"opt_componentwarnings","hp":"Wiedererkennung","h4":"Warnung anstelle von Meldung ausgeben (System)"},"1126":{"id":1126,"content":"Verzögerungen Hier können Sie Standardwerte für allgemeine Verzögerungen festlegen.","hash":"sec_opt_delays","h1":"Verzögerungen"},"1127":{"id":1127,"content":"Abbildung 41.27: Verzögerungsoptionen","hash":"figure_41.27","h4":"Abbildung 41.27: Verzögerungsoptionen"},"1128":{"id":1128,"content":"Standardverzögerung (System) Server Skript-Name: OPT_PLAY_DELAY_BEFORE, OPT_PLAY_DELAY_AFTER Diese Werte legen die Verzögerung vor und nach der Ausführung jedes Schrittes fest, der keine eigene Verzögerung gesetzt hat. Für Demonstrationszwecke oder zum Debuggen von Tests kann es sinnvoll sein, eine gewisse Verzögerung einzustellen. Im Normalbetrieb sollten Tests problemlos ohne Standardverzögerung laufen.","hash":"opt_defaultdelay","hp":"Verzögerungen","h4":"Standardverzögerung (System)"},"1129":{"id":1129,"content":"Drag&Drop und Interpolation von Mausbewegungen Die Simulation von Drag&Drop ist knifflig und nur möglich, indem \"harte\" Mausevents generiert werden, die den Mauszeiger tatsächlich bewegen. Unter Windows kann es dabei unter anderem zu Konflikten mit verschiedenen Maustreibern kommen. Informationen zu Drag&Drop finden Sie auch unter \"Drag&Drop\". Um Drag&Drop so zuverlässig wie möglich zu machen, sind die Bewegungen des Mauszeigers vielfältig konfigurierbar. Wegen der großen Unterschiede in den Anforderungen für Drag&Drop und harte Mausevents einerseits und Mausbewegungen, die nur zur Visualisierung dienen, andererseits, gibt es zwei komplette Sätze von Optionen für Mausbewegungen. Die Werte für Demo-Mausbewegungen werden ignoriert, wenn die zugehörige Option Mauszeiger tatsächlich bewegen nicht gesetzt ist. Im Normalfall sollten die Bewegungen für Drag&Drop und harte Events langsamer sein und mehr Interpolationsschritte verwenden, als Demo-Mausbewegungen. Letztere könnten ansonsten Tests deutlich verlangsamen. Alle der folgenden Optionen haben Einfluss auf die Geschwindigkeit des Mauszeigers und Sie werden eventuell ein wenig experimentieren müssen, um den gewünschten Effekt zu erzielen.","hash":"sec_opt_robot","h1":"Drag&Drop und Interpolation von Mausbewegungen"},"1130":{"id":1130,"content":"Verzögerung (ms) (System) SUT Skript-Name: OPT_PLAY_DND_DELAY, OPT_PLAY_MOVEMOUSE_DELAY Nach jeder einzelnen Mausbewegung wartet QF‑Test bis die angegebene Anzahl Millisekunden verstrichen ist. Dieser Wert sollte zwischen 2 und 20 liegen, falls Interpolation eingeschaltet ist, andernfalls zwischen 20 und 200. Mit Interpolation ist 10 ein guter Wert für Drag&Drop , 5 für Demo-Mausbewegungen.","hash":"opt_robotdelay","hp":"Drag&Drop und Interpolation von Mausbewegungen","h4":"Verzögerung (ms) (System)"},"1131":{"id":1131,"content":"Schrittgröße (System) SUT Skript-Name: OPT_PLAY_DND_STEP, OPT_PLAY_MOVEMOUSE_STEP Gibt die Größe der Schritte bei der Interpolation der Mausbewegungen an. Ein Wert von 0 schaltet die Interpolation aus. Gute Werte liegen zwischen 1 und 3 für Drag&Drop und zwischen 2 und 10 für Demo-Mausbewegungen.","hash":"opt_robotstep","hp":"Drag&Drop und Interpolation von Mausbewegungen","h4":"Schrittgröße (System)"},"1132":{"id":1132,"content":"Beschleunigung (System) SUT Skript-Name: OPT_PLAY_DND_ACCELERATION, OPT_PLAY_MOVEMOUSE_ACCELERATION Um sinnlose Verzögerungen zu vermeiden, können längere Mausbewegungen beschleunigt werden. Ein Wert von 0 schaltet die Beschleunigung aus. Sinnvolle Werte liegen zwischen 1 für sehr geringe und 10 oder mehr für starke Beschleunigung. Gut geeignet sind Werte zwischen 3 und 5 für Drag&Drop und zwischen 6 und 20 für Demo-Mausbewegungen.","hash":"opt_robotacceleration","hp":"Drag&Drop und Interpolation von Mausbewegungen","h4":"Beschleunigung (System)"},"1133":{"id":1133,"content":"Schwelle (System) SUT Skript-Name: OPT_PLAY_DND_THRESHOLD, OPT_PLAY_MOVEMOUSE_THRESHOLD Um sicherzustellen, dass kleine Bewegungen, sowie Beginn und Ende einer Bewegung präzise ausgeführt werden, wird die Beschleunigung für Mausbewegungen ausgeschaltet, die weniger Schritte als diese Schwelle benötigen. Gute Werte liegen zwischen 4 und 8 für Drag&Drop und zwischen 0 und 6 für Demo-Mausbewegungen.","hash":"opt_robotthreshold","hp":"Drag&Drop und Interpolation von Mausbewegungen","h4":"Schwelle (System)"},"1134":{"id":1134,"content":"Automatische Timeouts Diese automatischen Timeouts reduzieren den Aufwand beim Erstellen einer Testsuite gewaltig. Sie legen fest, wie lange im SUT auf ein Ereignis wie das Erscheinen einer benötigten Komponente gewartet wird, bevor ein Fehler auftritt. Sie sollten die folgenden Werte nicht zu klein wählen, damit ein \"kleiner Schluckauf\" des Testrechners nicht einen ansonsten einwandfreien Test abbricht. QF‑Test wartet außerdem nicht bei jedem Schritt, bis die maximale Zeit verstrichen ist, sondern arbeitet sofort weiter, sobald die Voraussetzungen erfüllt sind.","hash":"sec_opt_autodelay","h1":"Automatische Timeouts"},"1135":{"id":1135,"content":"Abbildung 41.28: Timeout Optionen","hash":"figure_41.28","h4":"Abbildung 41.28: Timeout Optionen"},"1136":{"id":1136,"content":"Erkennen von Deadlocks (s) (System) Server Skript-Name: OPT_PLAY_TIMEOUT_DEADLOCK Wenn das SUT für den angegebenen Zeitraum nicht reagiert wird eine DeadlockTimeoutException geworfen. Ein Wert von 0 unterdrückt die Erkennung von Deadlocks.","hash":"opt_deadlocktimeout","hp":"Automatische Timeouts","h4":"Erkennen von Deadlocks (s) (System)"},"1137":{"id":1137,"content":"Warten auf nicht vorhandene Komponente (ms) (System) SUT Skript-Name: OPT_PLAY_TIMEOUT_COMPONENT Die maximale Zeit, die QF‑Test darauf wartet, dass die Zielkomponente eines Events oder eines Checks im SUT verfügbar ist. Direkt nach Herstellung der Verbindung mit dem SUT wird diese Option vorübergehend auf mindestens 30000 gesetzt, um dem SUT Zeit zur Initialisierung zu geben.","hash":"opt_waitforcomponent","hp":"Automatische Timeouts","h4":"Warten auf nicht vorhandene Komponente (ms) (System)"},"1138":{"id":1138,"content":"Warten auf GUI-Engine (ms) (System) SUT Skript-Name: OPT_PLAY_TIMEOUT_ENGINE Diese Option ist hilfreich für SUTs mit mehreren Engines, z.B. Eclipse mit eingebetteten Swing Komponenten. Ein Warten auf Client Knoten ist fertig, sobald sich die erste Engine mit QF‑Test verbindet, sofern nicht sein GUI-Engine Attribut das Warten auf eine bestimmte Engine vorschreibt. Um einen darauf folgenden Warten auf Komponente Knoten für eine Komponente der falschen Engine vor dem sofortigen Scheitern zu bewahren, wartet QF‑Test zunächst die hier angegebene Zeitspanne ab, um der zweiten GUI-Engine eine Chance zu geben, sich ebenfalls mit QF‑Test zu verbinden.","hash":"opt_waitforengine","hp":"Automatische Timeouts","h4":"Warten auf GUI-Engine (ms) (System)"},"1139":{"id":1139,"content":"Warten auf nicht vorhandenes Element (ms) (System) SUT Skript-Name: OPT_PLAY_TIMEOUT_ITEM Bezieht sich ein Event auf ein Unterelement einer Komponente, wartet QF‑Test wie oben beschrieben zunächst darauf, dass die Komponente im SUT verfügbar ist. Anschließend gibt es dem SUT für den hier festgelegten Zeitraum die Chance, das gewünschte Unterelement bereitzustellen.","hash":"opt_waitforsubitem","hp":"Automatische Timeouts","h4":"Warten auf nicht vorhandenes Element (ms) (System)"},"1140":{"id":1140,"content":"Standard-Wartezeit für Checks (ms) (System) Server Skript-Name: OPT_PLAY_CHECK_TIMEOUT Diese Option legt einen Standardwert für das Wartezeit Attribute von Check Knoten fest, bei denen dieses Attribute nicht explizit gesetzt ist und die einen \"echten\" Check im Report darstellen und nicht zur Testablaufsteuerung dienen, d.h. die weder eine Exception werfen noch eine Ergebnisvariable setzen oder einen @report Doctag haben. Falls Ihre Tests viele Check Knoten ohne explizites Wartezeit enthalten, bei denen davon ausgegangen wird, dass sie fehlschlagen - was für die obigen \"echten\" Checks unwahrscheinlich ist - können Sie gegebenenfalls die Tests beschleunigen, indem Sie diese Option auf 0 setzen. Allerdings wäre es in diesem Fall vorzuziehen, stattdessen die Wartezeit Attribute der betroffenen Knoten auf 0 zu setzen und diese Option unverändert zu lassen, da sie die Stabilität der Ausführung von Checks generell verbessert.","hash":"opt_defaultchecktimeout","hp":"Automatische Timeouts","h4":"Standard-Wartezeit für Checks (ms) (System)"},"1141":{"id":1141,"content":"Warten bei modalem Dialog (ms) (System) SUT Skript-Name: OPT_PLAY_TIMEOUT_MODAL Wird ein Event an eine Komponente geschickt, deren Fenster von einem modalen Dialog blockiert ist, wird eine ModalDialogException geworfen. Allerdings werden modale Dialoge oft nur temporär angezeigt, um den Anwender über einen etwas länger dauernden Vorgang zu informieren. Ist diese Option auf einen Wert größer 0 gesetzt, wartet QF‑Test zunächst die angegebene Zeit, bevor die Exception geworfen wird. Verschwindet der Dialog vorher, wird der Testlauf normal fortgesetzt. Dadurch wird die Behandlung von temporären modalen Dialogen stark vereinfacht. Ist die Option Öffnen eines Fensters in Warten auf Komponente konvertieren aktiviert, kann bei der Aufnahme einer Sequenz während der ein temporärer modaler Dialog angezeigt wird, ein Warten auf Komponente Knoten angelegt werden. Wird der Dialog nur kurz angezeigt, sollte dieser Knoten entfernt werden, um Timing Probleme zu vermeiden. Falls das SUT häufig temporäre modale Dialoge einsetzt, ist es sinnvoll, die Option Öffnen eines Fensters in Warten auf Komponente konvertieren zu deaktivieren.","hash":"opt_waitformodal","hp":"Automatische Timeouts","h4":"Warten bei modalem Dialog (ms) (System)"},"1142":{"id":1142,"content":"Warten bei 'busy' GlassPane (ms) (System) SUT Skript-Name: OPT_PLAY_TIMEOUT_GLASSPANE Alternativ zu temporären modalen Dialogen wird in manchen Fällen eine sogenannte GlassPane in Verbindung mit einem Mauszeiger in Sanduhrform eingesetzt um anzuzeigen, dass die Anwendung beschäftigt, also 'busy' ist. Eine GlassPane ist eine unsichtbare Komponente, die ein ganzes Fenster überdeckt und alle Events für dieses Fenster abfängt. Dadurch wird die normale Eventverarbeitung verhindert, was einen Testlauf völlig aus der Bahn werfen kann. Diese Situation behandelt QF‑Test automatisch, indem es auf das Verschwinden dieser 'busy' GlassPane wartet bevor es einen Event, Check etc. ausführt. Ist die GlassPane nach Verstreichen des in dieser Option angegebenen Timeouts immer noch aktiv, wird eine BusyPaneException geworfen. Ist diese Option auf 0 gesetzt, wird nicht auf eine 'busy' GlassPane geprüft, sondern der Event auf jeden Fall ausgeliefert. Eine BusyPaneException wird in diesem Fall nie geworfen. Ein Sonderfall ist der Warten auf Komponente Knoten. Wird auf eine Komponente gewartet (nicht auf deren Abwesenheit), die von einer 'busy' GlassPane verdeckt wird, so wird das Attribut Wartezeit des Knotens gleichzeitig als Wartezeit für die 'busy' GlassPane herangezogen. Auf diesem Weg können Fälle behandelt werden, in denen die Anwendung erwartungsgemäß lange beschäftigt ist, ohne dafür diese Option generell hochzusetzen.","hash":"opt_waitforbusy","hp":"Automatische Timeouts","h4":"Warten bei 'busy' GlassPane (ms) (System)"},"1143":{"id":1143,"content":"Warten auf Button/Menü-Aktivierung (ms) (System) SUT Skript-Name: OPT_PLAY_TIMEOUT_ENABLED Ein Mausklick, der an ein Menü oder einen Button geschickt wird, wird einfach ignoriert, wenn das Menü oder der Button noch nicht aktiviert sind. Der weitere Ablauf des Tests kommt damit ziemlich sicher durcheinander. Mit diesem Wert legen Sie fest, wie lange zunächst gewartet werden darf, ob die Zielkomponente vielleicht doch noch aktiviert wird, bevor eine DisabledComponentException geworfen wird. Diese Exception kann durch Deaktivieren der Option DisabledComponentExceptions werfen unterdrückt werden.","hash":"opt_waitforactivation","hp":"Automatische Timeouts","h4":"Warten auf Button/Menü-Aktivierung (ms) (System)"},"1144":{"id":1144,"content":"Warten auf Fokus (ms) (System) SUT Skript-Name: OPT_PLAY_TIMEOUT_FOCUS Ist dieser Wert gesetzt, wartet QF‑Test vor dem Abspielen von Tastaturevents darauf, dass die Zielkomponente den Fokus besitzt. Diese Option kann einen Test signifikant ausbremsen, wenn die Komponente den Fokus nicht bekommt, daher sollten Sie sie nicht höher als 100 setzen. Ein guter Wert ist 20.","hash":"opt_waitforfocus","hp":"Automatische Timeouts","h4":"Warten auf Fokus (ms) (System)"},"1145":{"id":1145,"content":"Zeitabstand für Suche nach Komponenten (ms) (System) SUT Skript-Name: OPT_PLAY_POLL_COMPONENT Wenn QF‑Test im SUT auf das Erscheinen von Komponenten wartet, kann es sich nicht alleine auf den Event Mechanismus verlassen, sondern muss in regelmäßigen Abständen die Suche wiederholen. Der Zeitabstand für diese Suche wird mit Hilfe dieser Option festgelegt.","hash":"opt_componentpollinterval","hp":"Automatische Timeouts","h4":"Zeitabstand für Suche nach Komponenten (ms) (System)"},"1146":{"id":1146,"content":"Zeitabstand für Suche nach Unterelementen (ms) (System) SUT Skript-Name: OPT_PLAY_POLL_ITEM Um im SUT auf ein nicht vorhandenes Unterelement einer komplexen Komponente zu warten, kann QF‑Test sich nicht auf den Eventmechanismus verlassen, sondern muss immer wieder die Komponente nach dem Unterelement absuchen. Diese Option bestimmt, in welchen Zeitabständen diese Suche ausgeführt wird.","hash":"opt_subitempollinterval","hp":"Automatische Timeouts","h4":"Zeitabstand für Suche nach Unterelementen (ms) (System)"},"1147":{"id":1147,"content":"Zeitabstand für Checkwiederholung (ms) (System) SUT Skript-Name: OPT_PLAY_POLL_CHECK Schlägt ein Check fehl, für den eine Wartezeit vorgesehen ist, überprüft QF‑Test immer wieder den Zustand der Komponente, bis dieser den Vorgaben entspricht oder die Wartezeit verstrichen ist. Hiermit legen Sie die Zeitabstände fest, in denen diese Überprüfung durchgeführt wird.","hash":"opt_checkpollinterval","hp":"Automatische Timeouts","h4":"Zeitabstand für Checkwiederholung (ms) (System)"},"1148":{"id":1148,"content":"Rückwärtskompatibilität Diese Optionen stellen älteres Verhalten von QF‑Test wieder her, welches im Laufe des Entwicklungszykluses so stark verändert wurde, dass die Rückwärtskompatibilität nicht mehr garantiert werden konnte.","hash":"sec_opt_replaybw","h1":"Rückwärtskompatibilität"},"1149":{"id":1149,"content":"Abbildung 41.29: Optionen für Wiedergabe Rückwärtskompatibilität","hash":"figure_41.29","h4":"Abbildung 41.29: Optionen für Wiedergabe Rückwärtskompatibilität"},"1150":{"id":1150,"content":"Ausdrücke in variablen Boolean-Attributen nicht evaluieren (vor 4.2) (System) Server Skript-Name: OPT_PLAY_DONT_EVALUATE_BOOLEAN_OPTIONS In variablen Attributen, die einen boolean Wert beinhalten, z.B. das Als \"harten\" Event wiedergeben Attribut von Mausevent Knoten oder das Modal Attribut von Fenster Knoten, wird ein angegebener Ausdruck seit 4.2.0 von Jython ausgewertet.","hash":"opt_evaluatevariablebooleanoptions","hp":"Rückwärtskompatibilität","h4":"Ausdrücke in variablen Boolean-Attributen nicht evaluieren (vor 4.2) (System)"},"1151":{"id":1151,"content":"Alte Methode zur Generierung von Abbildern (vor 2) (System) SUT Skript-Name: OPT_RECORD_CHECK_IMAGE_OLD_STYLE Früher wurde bei der Aufnahme von Check Abbild Knoten für durchsichtige Komponenten immer ein schwarzer Hintergrund aufgenommen. Dadurch stimmte eventuell die Darstellung nicht mit dem Bild überein, das der Anwender zu sehen bekommt. Dieser Fehler wurde korrigiert, so dass normalerweise nun der Hintergrund korrekt gezeichnet wird. Mit dieser Option kann wieder auf die alte, fehlerhafte Methode umgeschaltet werden, falls bereits eine große Zahl von Checks von durchsichtigen Komponenten mit der alten Methode erstellt wurden.","hash":"opt_brokengrabimage","hp":"Rückwärtskompatibilität","h4":"Alte Methode zur Generierung von Abbildern (vor 2) (System)"},"1152":{"id":1152,"content":"Pro Handbuch","hash":"","h0":"SmartID und qfs:label | QF‑Test Handbuch"},"1153":{"id":1153,"content":"Pro Handbuch","hash":"home-link","h0":"SmartID und qfs:label | QF‑Test Handbuch"},"1154":{"id":1154,"content":"SmartID und qfs:label Die folgenden Einstellungen legen Details der Aufnahme und Wiedergabe von SmartIDs und qfs:label* Varianten fest. Ausführliche Informationen hierzu finden Sie in \"SmartID\" und \"qfs:label*-Varianten\".","hash":"sec_opt_smartid","h0":"SmartID und qfs:label"},"1155":{"id":1155,"content":"Abbildung 41.30: SmartID und qfs:label-Optionen","hash":"figure_41.30","h4":"Abbildung 41.30: SmartID und qfs:label-Optionen"},"1156":{"id":1156,"content":"Aufnahme von SmartIDs (System) Server (automatisch weiter an SUT) Skript-Name: OPT_RECORD_SMARTID Ist diese Option aktiv, werden bei der Aufnahme - so weit möglich - SmartIDs statt Komponenten aufgezeichnet.","hash":"opt_recordsmartid","hp":"SmartID und qfs:label","h4":"Aufnahme von SmartIDs (System)"},"1157":{"id":1157,"content":"Für SmartID immer die Klasse aufnehmen (System) Server (automatisch weiter an SUT) Skript-Name: OPT_RECORD_SMARTID_CLASS Für SmartIDs ist das Voranstellen der Klasse der Zielkomponente optional. Mit dieser Option wird festgelegt, ob die Klasse beim Aufzeichnen von SmartIDs immer vorangestellt wird oder nur, wenn es für die Eindeutigkeit notwendig ist. Die Option ist standardmäßig aktiv, da die Klasse in der SmartID - neben der Lesbarkeit und Klarheit - die Performanz bei der Wiedergabe deutlich verbessert.","hash":"opt_recordsmartidclass","hp":"SmartID und qfs:label","h4":"Für SmartID immer die Klasse aufnehmen (System)"},"1158":{"id":1158,"content":"Für SmartID immer den Kennzeichner aufnehmen (System) Server (automatisch weiter an SUT) Skript-Name: OPT_RECORD_SMARTID_QUALIFIER Diese Option legt fest, ob für SmartIDs der Kennzeichner aufgenommen wird. In folgenden Situationen hat die Option keine Wirkung, so dass der Kennzeichner immer aufgenommen wird: Wenn es sich bei der SmartID um eine qfs:label*-Variante handelt und die Option Aufnahme von qfs:label*-Varianten auf \"Alle Varianten aufnehmen\" oder \"Nur spezifisches Label aufnehmen\" gesetzt ist. Wenn es sich bei der SmartID um ein weiteres Merkmal handelt, das nicht zu den qfs:label*-Varianten gehört und über die Option Priorität bei Aufnahme von SmartIDs mit Kennzeichner aufgenommen wird. Wenn die Option Priorität bei Aufnahme von SmartIDs mit Kennzeichner von ihrem Standardwert abweicht und die aufgenommene SmartID nicht auf dem Namen der Komponente basiert.","hash":"opt_recordsmartidqualifier","hp":"SmartID und qfs:label","h4":"Für SmartID immer den Kennzeichner aufnehmen (System)"},"1159":{"id":1159,"content":"Priorität bei Aufnahme von SmartIDs mit Kennzeichner (System) Server (automatisch weiter an SUT) Skript-Name: OPT_RECORD_SMARTID_PRIORITIES Diese komma-getrennte Liste der Kennzeichner gibt an, in welcher Reihenfolge die Wiedererkennungskriterien analysiert werden sollen. Für den Standardwert \"name,qlabel,feature\" wird bei der Aufnahme zunächst auf einen Namen geprüft. Ist dieser vorhanden, wird er für die SmartID verwendet. Andernfalls folgt als nächstes der Test auf eine qfs:label*-Variante und schließlich auf ein Merkmal. Die Namen der verfügbaren Kennzeichner finden Sie in SmartID. Bei der Wiedergabe mit einer SmartID wird zunächst nur nach dem Namen gesucht, dann nach qfs:label* und Merkmal, die als gleichwertig gelten und implizit kombiniert werden.","hash":"opt_smartidpriorities","hp":"SmartID und qfs:label","h4":"Priorität bei Aufnahme von SmartIDs mit Kennzeichner (System)"},"1160":{"id":1160,"content":"Maximallänge für den aufgenommenen Wert von SmartIDs (System) Server (automatisch weiter an SUT) Skript-Name: OPT_SMARTID_MAX_VALUE_LENGTH In einzelnen Fällen kann das Merkmal oder zugeordnete Label einer Komponente sehr lang sein. Dies ist kein Problem als solches und wird oft gar nicht bemerkt, wenn der Wert in einem Komponente Knoten gespeichert ist. Bei einer SmartID kann es allerdings sehr unhandlich sein. Der Einfachheit halber werden daher Werte, die länger sind, als in dieser Option angegeben, automatisch in einen regulären Ausdruck der passenden Länge umgewandelt.","hash":"opt_smartidmaxvaluelength","hp":"SmartID und qfs:label","h4":"Maximallänge für den aufgenommenen Wert von SmartIDs (System)"},"1161":{"id":1161,"content":"Für Komponenten innerhalb von Unterelementen SmartID statt QPath verwenden (System) Server (automatisch weiter an SUT) Skript-Name: OPT_RECORD_SMARTID_INSTEAD_OF_QPATH Eine Komponente innerhalb eines Unterelements, z.B. eine CheckBox in einer Tabellenzelle, muss durch eine spezielle Syntax für Pseudo-Elemente repräsentiert werden. Ab QF‑Test Version 7 löst dafür SmartID das veraltete QPath-Modell ab. Nach Deaktivieren dieser Option wird QPath verwendet, sofern die generelle Aufnahme von SmartIDs ebenfalls deaktiviert ist.","hash":"opt_smartidinsteadofqpath","hp":"SmartID und qfs:label","h4":"Für Komponenten innerhalb von Unterelementen SmartID statt QPath verwenden (System)"},"1162":{"id":1162,"content":"Aufnahme von qfs:label*-Varianten (System) SUT Skript-Name: OPT_RECORD_QFSLABEL_MODE Mögliche Werte: VAL_RECORD_QFSLABEL_MODE_ALL, VAL_RECORD_QFSLABEL_MODE_SPECIFIC, VAL_RECORD_QFSLABEL_MODE_BEST, VAL_RECORD_QFSLABEL_MODE_LEGACY Die Option gibt an, welche qfs:label*-Varianten als Weitere Merkmale aufgezeichnet werden: Der Wert \"Alle Varianten aufnehmen\" bewirkt, dass alle für die Komponente gefundenen qfs:label*-Varianten in den Weiteren Merkmalen abgespeichert werden. Die Beste Beschriftung erhält den Status \"Sollte übereinstimmen\", die anderen den Status \"Ignorieren\". Bei einer SmartID wird der spezifische Kennzeichner, siehe Tabelle qfs:label*-Varianten, aufgezeichnet. Mit dem Wert \"Nur spezifisches Label aufnehmen\" wird nur die als Beste Beschriftung bewertete qfs:label*-Variante in den Weiteren Merkmalen abgespeichert. Bei einer SmartID wird der spezifische Kennzeichner, siehe Tabelle qfs:label*-Varianten, aufgezeichnet. Der Wert \"Nur qfs:labelBest aufnehmen\" bewirkt, dass nur die als Beste Beschriftung bewertete qfs:label*-Variante aufgenommen und in den Weiteren Merkmalen unter dem Namen qfs:labelBest abgespeichert wird. Bei der Aufzeichnung einer SmartID mit dieser Einstellung, wird je nach dem wie die Option Für SmartID immer den Kennzeichner aufnehmen gesetzt ist, entweder kein Kennzeichner oder der für die Beschriftung spezifische Kennzeichner aufgezeichnet. Beim Wert \"Alter qfs:label-Modus\" wird die beste Beschriftung über den vor QF‑Test 7.0 verwendeten Algorithmus ermittelt und qfs:label in den Weiteren Merkmalen abgespeichert. Bei einer SmartID wird qlabel als Kennzeichner aufgezeichnet, jedoch nicht standardmäßig. ().","hash":"opt_recordqfslabelmode","hp":"SmartID und qfs:label","h4":"Aufnahme von qfs:label*-Varianten (System)"},"1163":{"id":1163,"content":"Pro Handbuch","hash":"","h0":"Android | QF‑Test Handbuch"},"1164":{"id":1164,"content":"Pro Handbuch","hash":"home-link","h0":"Android | QF‑Test Handbuch"},"1165":{"id":1165,"content":"Android Die folgenden Einstellungen haben Einfluss auf Tests von Android-Anwendungen.","hash":"sec_opt_android","h0":"Android"},"1166":{"id":1166,"content":"Abbildung 41.31: Android-Optionen","hash":"figure_41.31","h4":"Abbildung 41.31: Android-Optionen"},"1167":{"id":1167,"content":"Android-SDK-Pfad (System) Server Skript-Name: OPT_ANDROID_SDK_PATH Geben Sie hier den Installationspfad Ihres Android-SDK an. Der Name dieses Verzeichnisses lautet üblicherweise sdk und enthält unter anderem ein Unterverzeichnis tools oder cmdline-tools. Diese Einstellung muss nur gesetzt werden, falls QF‑Test den Pfad nicht automatisch ermitteln kann.","hash":"opt_androidsdkpath","hp":"Android","h4":"Android-SDK-Pfad (System)"},"1168":{"id":1168,"content":"Weitere Android-Informationen ins Protokoll loggen (System) Server Skript-Name: OPT_ANDROID_DEBUG Wenn diese Option aktiviert ist werden weitere Informationen in das Protokoll geloggt.","hash":"opt_androiddebug","hp":"Android","h4":"Weitere Android-Informationen ins Protokoll loggen (System)"},"1169":{"id":1169,"content":"Output des Emulators ins QF‑Test Terminal weiterleiten (System) Server Skript-Name: OPT_ANDROID_FORWARD_EMULATOR_OUTPUT Wenn diese Option aktiviert ist und ein Emulator über den Android-Emulator starten Knoten gestartet wurde, dann werden die stdout/stderr Ausgaben des gestarteten Emulators an das QF‑Test Terminal weitergegeben.","hash":"opt_androidforwardemulatoroutput","hp":"Android","h4":"Output des Emulators ins QF‑Test Terminal weiterleiten (System)"},"1170":{"id":1170,"content":"Pro Handbuch","hash":"","h0":"iOS | QF‑Test Handbuch"},"1171":{"id":1171,"content":"Pro Handbuch","hash":"home-link","h0":"iOS | QF‑Test Handbuch"},"1172":{"id":1172,"content":"iOS Diese Optionen stehen für das Testen von iOS Anwendungen zur Verfügung:","hash":"sec_opt_ios","h0":"iOS"},"1173":{"id":1173,"content":"Abbildung 41.32: Options for iOS Tests","hash":"figure_41.32","h4":"Abbildung 41.32: Options for iOS Tests"},"1174":{"id":1174,"content":"Ausgaben des iOS-Device-Agents anzeigen (User) SUT Skript-Name: OPT_IOS_PRINT_AGENT_OUTPUT Mögliche Werte: VAL_IOS_PRINT_AGENT_OUTPUT_NONE, VAL_IOS_PRINT_AGENT_OUTPUT_INSTRUMENT, VAL_IOS_PRINT_AGENT_OUTPUT_EXEC, VAL_IOS_PRINT_AGENT_OUTPUT_ALL Während des Starts und der Ausführung von iOS Tests wird über Xcode der benötigte Geräteagent gebaut und ausgeführt. Bei normaler Ausführung wird die detaillierte Prozessausgabe nicht in das Terminal geschrieben. Wenn man aber Fehler sucht, kann die Prozessausgabe im Terminal hilfreich sein. Sie kann für die Instrumentierung des Geräts, die Ausführung oder beides aktiviert werden.","hash":"opt_iosprintagentoutput","hp":"iOS","h4":"Ausgaben des iOS-Device-Agents anzeigen (User)"},"1175":{"id":1175,"content":"Simulator bei geöffnetem Aufnahmefenster ausblenden (User) SUT Skript-Name: OPT_IOS_AUTO_HIDE_SIMULATOR Mögliche Werte: VAL_IOS_AUTO_HIDE_SIMULATOR_ALWAYS, VAL_IOS_AUTO_HIDE_SIMULATOR_NEVER, VAL_IOS_AUTO_HIDE_SIMULATOR_ONOPEN Die Interaktion mit der Anwendung bei der Testaufnahme und beim Untersuchen von Komponenten erfolgt über ein dediziertes Fenster, analog zu Android - siehe Aufnamen und Checks bei iOS. Wenn die zu testende Anwendung auf einem Simulator ausgeführt wird, kann es verwirrend sein, wenn die Benutzeroberfläche doppelt angezeigt wird - im Simulator und im Aufnahmefenster. Um diese Verwirrung zu vermeiden, kann QF‑Test den Simulator automatisch ausblenden, wenn das Aufnahmefenster geöffnet wird. Wenn dann explizit zum Simulator gewechselt wird, erscheint dessen Fenster wieder. Man kann jedoch mit der Option \"Immer\" einstellen, dass beim Auswählen des Simulators dieser immer wieder ausgeblendet und stattdessen das Aufnahmefenster aktiviert wird - solange dieses vorhanden ist.","hash":"opt_iosautohidesimulator","hp":"iOS","h4":"Simulator bei geöffnetem Aufnahmefenster ausblenden (User)"},"1176":{"id":1176,"content":"Simulator nach dem Test beenden (User) SUT Skript-Name: OPT_IOS_AUTO_CLOSE_SIMULATOR Mögliche Werte: VAL_IOS_AUTO_CLOSE_SIMULATOR_YES, VAL_IOS_AUTO_CLOSE_SIMULATOR_NO, VAL_IOS_AUTO_CLOSE_SIMULATOR_AUTO Für die Steuerung des iOS-Geräts oder des Simulators verwendet QF‑Test einen Controller. Bei Bedarf wird der iOS Simulator von QF‑Test gemeinsam mit dem Controller gestartet. Standardmäßig wird der Simulator ebenfalls beendet, wenn der Controller gestoppt wird. Bei der Testentwicklung kann es hilfreich sein, den Simulator laufen zu lassen, auch wenn der QF‑Test Controller gestoppt wurde. Hier kann festgelegt werden, dass der Simulator nicht gemeinsam mit den Controller beendet werden soll, beziehungsweise nur, wenn er vom Controller gestartet wurde.","hash":"opt_iosautoclosesimulator","hp":"iOS","h4":"Simulator nach dem Test beenden (User)"},"1177":{"id":1177,"content":"Simulator bei Unterbrechung der Verbindung neu starten (System) SUT Skript-Name: OPT_IOS_RESTART_SIMULATOR Wenn die Verbindung zu einem echten iOS-Gerät bei einem Testlauf unterbrochen wird, führt QF‑Test automatisch einen Neustart des Geräteagenten aus, um die Verbindung wiederherzustellen. Wenn das iOS-Zielgerät simuliert ist, geht QF‑Test standardmäßig davon aus, dass der Simulator absichtlich geschloss