import de.qfs.apps.qftest.extensions.qftest.AbstractTestRunListener
import de.qfs.apps.qftest.extensions.qftest.TestRunEvent

class Tracer extends AbstractTestRunListener {

    def b // external binding scope, required for rc access

    void runStarted(TestRunEvent event) {
        b.out.println "Run started"
    }

    void runStopped(TestRunEvent event) {
        b.out.println "Run stopped"
    }

    void nodeEntered(TestRunEvent event) {
        def name = event.getNode().getName()
        def nodeType = event.getNode().getType()
        if (nodeType == "TestCase") {
            if (name) {
                def parts = name.split(":")
                b.rc.setGlobal("tcid", parts[0])
            }
        }
    }

    void nodeExited(TestRunEvent event) {
        // nothing
    }

    void problemOccurred(TestRunEvent event) {
        if (event.getState() > 1) {
            this.error = "KO"
        }
    }
}

try {
    rc.removeTestRunListener(tcidlistener)
} catch(e) {}

tcidlistener = new Tracer(b:binding)
rc.addTestRunListener(tcidlistener)
