from de.qfs.apps.qftest.extensions import ResolverRegistry
from de.qfs.apps.qftest.extensions.checks import CheckerRegistry, Checker, DefaultCheckType, CheckDataType
from de.qfs.apps.qftest.shared.data.check import StringCheckData
from de.qfs.lib.util import Pair
import jarray
import re

# Modifications required at (!)

class CustomChecker(Checker):
    # Description of the checkType
    def getCheckType(self):
        return DefaultCheckType(
            "CurrencyText_checked",  # (!) An internal name of the new checker
            CheckDataType.STRING,    # (!) Type: STRING, STRING_LIST, SELECTABLE_STRING_LIST, BOOLEAN, GEOMETRY, IMAGE
            "Text without Currency"  # (!) The Label in the popup menu
        )

    # Supported checkTypes
    def getSupportedCheckTypes(self, com, item):
        return jarray.array([self.getCheckType()], DefaultCheckType)

    # Get the current check data in the target element or sub-item.
    #
    # @return  The check data or null if the check is not supported.
    #
    def getCheckData(self, com, item, checkType):
        if checkType.getIdentifier() != self.getCheckType().getIdentifier(): return None # Not our job...

        # (!) Implement the check data logic
        rawValue = str(com.getText())
        checkData = re.sub("[^0-9.,]", "", rawValue)

        return StringCheckData(checkType.getIdentifier(), checkData) # (!) or StringItemsCheckData, SelectableItemsCheckData, BooleanCheckData, GeometryCheckData, ImageCheckData

    # Get the current check data in the target element or sub-item and the item that the check
    # data corresponds to. For example, when recording a column check after right-clicking on a
    # table cell, the input subItem will be the cell while the return item should be the column.
    #
    # @return  A pair of the check data and target item or null if the check is not supported.
    #
    def getCheckDataAndItem(self, com, item, checkType):
        data = self.getCheckData(com, item, checkType)
        if data is None: return None
        return Pair(data, item) # (!) Probably adapt item

    # Unregister previous instance of this check/element combination
    def unregister(self, element):
        global customCheckers

        checkIdentifier = self.getCheckType().getIdentifier()

        if not globals().get("customCheckers"): return
        thisCustomCheckers = customCheckers.get(checkIdentifier)
        if not thisCustomCheckers: return
        customChecker = thisCustomCheckers.get(element)
        if not customChecker: return

        del customCheckers[checkIdentifier][element]
        CheckerRegistry.instance().unregisterChecker(element, customChecker)
        return self

    def register(self, element):
        global customCheckers

        self.unregister(element)

        checkIdentifier = self.getCheckType().getIdentifier()

        # init container for unregistration
        if not globals().get("customCheckers"):
            customCheckers = {}
        if not customCheckers.get(checkIdentifier):
            customCheckers[checkIdentifier] = {}

        customCheckers[checkIdentifier][element] = self
        CheckerRegistry.instance().registerChecker(element, self)
        return self

CustomChecker().register("TextField") # (!) Adapt to component type for which to register the check

