import {ImageWrapper} from 'imagewrapper';

const iw = new ImageWrapper(rc)

const suiteDir = rc.lookup("qftest", "suite.dir")

//Create Screenshots
const screenshot = iw.grabScreenshot()
const discount = iw.grabImage(rc.getComponent("CalculatedPrice"))

//Write images to protocol or 
rc.logImage(screenshot)
iw.savePng(suiteDir + "/image.png", screenshot)
rc.logImage(discount)
iw.savePng(suiteDir + "/discount.png", discount)

//Compare images
const pngImg = iw.loadPng(suiteDir + "/discount.png")
rc.checkImage(pngImg, discount, "Discount from file")
rc.checkImageAdvanced(pngImg, discount, "Discount from file", "algorithm=similarity")