sidx_dump={"version":"0.9.5","fields":["content","h-1","h0","h1","h2","h3","hash"],"ref":"id","documentStore":{"docs":{"0":{"id":0,"content":"Pro Tutorial","hash":"","h0":"Vorwort | QF‑Test Tutorial"},"1":{"id":1,"content":"Pro Tutorial","hash":"home-link","h0":"Vorwort | QF‑Test Tutorial"},"2":{"id":2,"content":"Vorwort","hash":"sec_Introduction","h0":"Vorwort"},"3":{"id":3,"content":"QF‑Test QF‑Test ist ein professionelles Werkzeug zur Automatisierung von Tests für Java-, Web- und nativen Windows-Anwendungen mit einer grafischen Benutzeroberfläche (GUI). QF‑Test testet das System als Ganzes über das GUI. Integrationstests, die das Zusammenspiel von Einzelsystemen überprüfen, können ebenfalls mittels QF‑Test implementiert werden. Das Haupteinsatzgebiet sind automatisierte Regressionstests. Aufgrund seiner Eigenschaften kann QF‑Test auch zu anderen Zwecken genutzt werden, z.B. um Lasttests durchzuführen oder um Massendaten über eine grafische Oberfläche einzugeben. QF‑Test richtet sich gleichermaßen an Fachtester und Entwickler. Es verfügt über eine einfach zu bedienende Oberfläche, mit der Tests einfach über die Testaufnahmefunktion erstellt werden können. Andererseits können Tests auch ähnlich wie Programme aufgebaut und strukturiert werden. Bei Testfunktionalitäten, die nicht über Standardelemente abgebildet werden können, ist fast immer die Implementierung über Skripte möglich. QF‑Test erstellt während der Testausführung ein spezielles Protokoll, das sehr viele Informationen hinsichtlich einer möglichen Fehleranalyse enthält. Zusätzlich können konfigurierbare HTML-Reports (auch XML oder JUnit Format) erstellt werden, die das Testergebnis übersichtlich und mit Grafiken darstellen. QF‑Test ist plattformunabhängig auf Windows, Linux und macOS einsetzbar. Java-seitig können Swing, JavaFX und SWT getestet werden. Bei den Web-Browsern werden die gängigen Typen unterstützt, teils auch als headless Version. Ab QF‑Test Version 5 können auch native Windows-Anwendungen getestet werden. Eine genaue Auflistung der unterstützten Betriebssystem-, Java- und Browser-Versionen finden Sie im Kapitel Systemvoraussetzungen des Handbuchs. Das Video 'Überblick' bietet eine allgemeine Übersicht über QF‑Test. Im Video 'Technische Einführung' erhalten Sie einen Einblick in die Funktionalität von QF‑Test.","hash":"sec_qf_test","h1":"QF‑Test"},"4":{"id":4,"content":"Tutorial Dieses Tutorial soll als praktische Einführung in QF‑Test dienen. Der Basisteil stellt die Grundfunktionen von QF‑Test vor und leiten Sie durch die notwendigen Schritte, um eine eigene Testsuite zu erstellen. Darüber hinaus lernen Sie Ihre Testergebnisse zu analysieren, mit Hilfe des Debuggers sich schrittweise durch Ihre Tests zu bewegen und einen Überblicksreport zu erstellen. Weitere Themen sind das Konzept der Modularisierung mit Hilfe von Prozeduren und die Komponentenerkennung, die für GUI Tests von zentraler Bedeutung ist. Die Vorgehensweise zur Erstellung von Tests ist für alle Technologien die gleiche - sei es für Java-, Web- oder native Windows-Anwendungen. Bei Web-Anwendungen muss gegebenenfalls vor Beginn der Testerstellung ein Blick auf die Komponentenerkennung geworfen werden. Bei nativen Windows-Anwendungen benötigt man bei der Aufnahme und dem Abspielen der Tests etwas mehr Geduld. Nun, warum dann drei unterschiedliche Basisteile? Da die Demoapplikationen natürlich für jede Technologie etwas anders aussehen, unterschiedliche Vorbereitungssequenzen erzeugt werden und auch die aufgenommenen Komponenten voneinander abweichen, bezieht sich jeder Basisteil auf die entsprechende Demoapplikation. Somit entsprechen die Beispiele im Tutorial genau dem, was Sie in den Übungen selbst sehen. Bitte wählen Sie \"Java-GUIs testen mit QF‑Test\" für Java-, \"Web GUIs testen mit QF‑Test\" für Web- und \"Native Windows GUIs testen mit QF‑Test\" für native Windows-Anwendungen. Im weiterführenden \"Weiterführende Features von QF‑Test\" stellen wir weitere Funktionalitäten von QF‑Test vor: datengetriebenes Testen, das Herstellen der Testvorbedingungen und die automatische Generierung von Basisprozeduren. Diese Techniken sind ebenfalls für alle Applikationstechnologien gleich - und da Sie sich nun bereits besser in QF‑Test zurechtfinden, zeigen wir die Beispiele nur für eine Technologie. Dieses Tutorial ist auch als HTML Online-Version verfügbar unter https://www.qftest.com/doc/tutorial/de/contents.html. Als Alternative zum Selbststudium bietet QFS Schulungen für QF‑Test an. Details dazu finden Sie unter https://www.qftest.com/de/qftest/training.html im Internet. Das Tutorial folgt folgenden Konventionen: »Menü«-»Untermenü« stellt ein Menü oder einen Menüeintrag dar. Modifier⁠+⁠Taste steht für einen Tastendruck. Mögliche Modifier sind Shift/⇧ (Hochstellen), Strg/⌃, Alt/⌥, ⌘ oder eine Kombination daraus. Der Schrifttyp Courier wird für Datei- und Verzeichnisnamen, Programmein- und -ausgaben verwendet. Um die Vorzüge von Querverweisen wenigstens ansatzweise zu Papier zu bringen, werden Verweise in der PDF-Version unterstrichen und geben die Seitenzahl des Ziels klein und in Klammern an.","hash":"sec_tutorial","h1":"Tutorial"},"5":{"id":5,"content":"Feedback Dieses Tutorial wurde für QF‑Test 4.2 von Grund auf überarbeitet. Wir hoffen, dass Sie es in dieser Form hilfreich finden und freuen uns auf Ihr Feedback - positiv wie negativ. Alle Ihre Kommentare, Fehlerreports, Wünsche etc. senden Sie bitte an support@qftest.com.","hash":"sec_feedback","h1":"Feedback"},"6":{"id":6,"content":"Pro Tutorial","hash":"","h0":"Java-GUIs testen mit QF‑Test | QF‑Test Tutorial"},"7":{"id":7,"content":"Pro Tutorial","hash":"home-link","h0":"Java-GUIs testen mit QF‑Test | QF‑Test Tutorial"},"8":{"id":8,"content":"Java-GUIs testen mit QF‑Test Dieser erste Teil des Tutorials soll Ihnen die Basiseigenschaften und -arbeitsabläufe von QF‑Test an Hand einer Java-Anwendung erläutern. Wenn Sie Web- oder native Windows-Anwendungen testen wollen, empfehlen wir \"Web GUIs testen mit QF‑Test\" beziehungsweise \"Native Windows GUIs testen mit QF‑Test\". Alle Basisteile vermitteln die gleichen Schulungsinhalte, nutzen für die Beispiele jedoch eine jeweils passende Testanwendung. Im \"Weiterführende Features von QF‑Test\" werden weiterführende Funktionalitäten von QF‑Test erklärt, die für Tests sowohl von Java-, Web- und nativen Windows-Anwendungen genutzt werden können.","hash":"sec_java","h1":"Java-GUIs testen mit QF‑Test"},"9":{"id":9,"content":"Pro Tutorial","hash":"","h0":"Bearbeiten einer Beispiel-Testsuite (Java) | QF‑Test Tutorial"},"10":{"id":10,"content":"Pro Tutorial","hash":"home-link","h0":"Bearbeiten einer Beispiel-Testsuite (Java) | QF‑Test Tutorial"},"11":{"id":11,"content":"Bearbeiten einer Beispiel-Testsuite (Java) Dieses Kapitel ist auch als Video verfügbar unter 'Bearbeiten einer Beispiel-Testsuite'. In diesem ersten Kapitel werden wir uns die Struktur einer einfachen Testsuite anschauen, die wesentlichen Bestandteile erklären, sie ausführen und das Ergebnis auswerten.","hash":"sec_demojava","h1":"Bearbeiten einer Beispiel-Testsuite (Java)"},"12":{"id":12,"content":"Pro Tutorial","hash":"","h0":"Laden der Testsuite | QF‑Test Tutorial"},"13":{"id":13,"content":"Pro Tutorial","hash":"home-link","h0":"Laden der Testsuite | QF‑Test Tutorial"},"14":{"id":14,"content":"Laden der Testsuite Beim ersten Start von QF‑Test und/oder der zu testenden Anwendung über QF‑Test kann eine Sicherheitswarnung der Firewall auftreten mit der Frage, ob das Netzwerkprotokoll für Java geblockt werden soll oder nicht. Da QF‑Test die Java-Netzwerkprotokolle für die Kommunikation mit dem SUT (System under Test) nutzt, darf diese nicht geblockt werden, um das automatisierte Testen zu ermöglichen. Nach dem Starten von QF‑Test laden Sie bitte unser erstes Beispiel: Drücken Sie den Knopf , um den Dateiauswahl-Dialog zu öffnen. Wechseln Sie in das Unterverzeichnis qftest-10.0.2-pro/doc/tutorial Ihrer QF‑Test Installation. Dort wählen Sie bitte die Datei ErsteJavaTests.qft aus und öffnen diese. QF‑Test präsentiert Ihnen die Testsuite wie im folgenden Bild dargestellt:","hash":"tut_loadsuitejava","h0":"Laden der Testsuite"},"15":{"id":15,"content":"Abbildung 1.1: Das Fenster der Testsuite ErsteJavaTests.qft Der linke Bereich des Hauptfensters enthält die Testsuite, die in einer Baumstruktur dargestellt wird. Rechts befindet sich die Detailansicht des Knotens, der im Baum gerade markiert ist. (Falls die Detailansicht bei Ihnen nicht zu sehen sein sollte, aktivieren Sie diese bitte über das Menü »Ansicht«-»Details anzeigen«.) Im Bereich unten rechts befindet sich das Terminal, welches die Ausgaben von QF‑Test und dem zu testenden Client protokolliert. Mit Hilfe des Baumes können Sie durch die Testsuite navigieren und einzelne Knoten auswählen, für die dann jeweils die Details im rechten Fensterbereich eingeblendet werden. Doppelklicken Sie bitte den Knoten Testfallsatz: Einfache Tests um ihn zu expandieren und die darin liegenden Knoten sehen zu können. Der Testfallsatz enthält primär zwei Testfälle, umgeben von einem \"Vorbereitung\"/\"Aufräumen\" Knotenpaar, das im Wesentlichen die Testanwendung startet bzw. beendet.","hash":"fig_firstTestSuiteJava","h4":"Abbildung 1.1: Das Fenster der Testsuite ErsteJavaTests.qft"},"16":{"id":16,"content":"Abbildung 1.2: Der Inhalt des Testfallsatz Knotens In den folgenden Abschnitten werden wir Funktion und Zweck der einzelnen Knoten erklären.","hash":"fig_firstTestSetJava","h4":"Abbildung 1.2: Der Inhalt des Testfallsatz Knotens"},"17":{"id":17,"content":"Pro Tutorial","hash":"","h0":"Starten der Anwendung | QF‑Test Tutorial"},"18":{"id":18,"content":"Pro Tutorial","hash":"home-link","h0":"Starten der Anwendung | QF‑Test Tutorial"},"19":{"id":19,"content":"Starten der Anwendung Zuerst wollen wir die Vorbereitung genauer unter die Lupe nehmen: Expandieren Sie den Knoten Vorbereitung: Demo starten, wie im folgenden Bild gezeigt.","hash":"tut_startsutjava","h0":"Starten der Anwendung"},"20":{"id":20,"content":"Abbildung 1.3: Der Knoten \"Vorbereitung\" Es werden zwei Kindknoten sichtbar: Variable setzen - der Variablen 'client', wird der Verbindungsname für das zu startende SUT zugewiesen, der für jeden Zugriff auf die Applikation benötigt wird. Sequenz: Starte Client wenn nötig und abhängig von OS - startet das zu testende System (SUT) abhängig vom genutzten Betriebssystem, wenn es nicht schon läuft. Lassen Sie uns noch einen kurzen Blick in die Sequenz: \"Starte Client wenn nötig abhängig von OS\" werfen:","hash":"fig_firstSetupJava","h4":"Abbildung 1.3: Der Knoten \"Vorbereitung\""},"21":{"id":21,"content":"Abbildung 1.4: Die Sequenz zum Starten des Client Mit QF‑Test können Applikationen unter Microsoft Windows, macOS ebenso wie auf Linux Systemen getestet werden. Die hier beschriebene Testsuite kann auf allen drei System abgespielt werden. Die einzige Stelle, an der ein Unterschied zwischen den einzelnen Systemen gemacht werden muss, ist beim Start der Demoanwendung. Mit Hilfe einer If - Else Struktur wird für Windows eine .bat-Datei und ansonsten eine .sh Datei aufgerufen (für macOS und Linux). Der SUT-Client Starten Knoten führt die Anwendung aus und stellt die Verbindung zwischen dem Client und QF‑Test her. Um unabhängig vom absoluten Verzeichnispfad der Applikation zu sein, verwenden wir einen relativen Pfad, ausgehend vom QF‑Test Installationsverzeichnis, dass über die Variable ${qftest:dir.version} angegeben wird (siehe Handbuchkapitel Variablen). Im Kapitel \"If - else\" wird die Startsequenz ausführlich behandelt. Hier soll nur kurz erwähnt werden, dass ein Starten der Anwendung nur erfolgt, wenn sie nicht bereits läuft. Wir wollen nun die Anwendung wirklich starten: Markieren Sie dazu bitte den Knoten Vorbereitung: Demo starten, doch belassen Sie ihn aufgeklappt. Klicken Sie den Knopf Wiedergabe. Dies führt den aktuellen ausgewählten Knoten aus. Während der Ausführung wird der gerade aktive Knoten durch \"->\" markiert. Nach Abschluss der Startsequenz sollte die Demoapplikation \"CarConfigurator\" am Bildschirm erscheinen. Da QF‑Test nach Ende der Wiedergabe den Fokus zurückerhält, kann die Demoapplikation dadurch auch wieder verdeckt worden sein.","hash":"fig_firstStartJava","h4":"Abbildung 1.4: Die Sequenz zum Starten des Client"},"22":{"id":22,"content":"Abbildung 1.5: Das CarConfigurator Demo","hash":"fig_jCarConfigDemo","h4":"Abbildung 1.5: Das CarConfigurator Demo"},"23":{"id":23,"content":"Pro Tutorial","hash":"","h0":"Ein erster Testfall | QF‑Test Tutorial"},"24":{"id":24,"content":"Pro Tutorial","hash":"home-link","h0":"Ein erster Testfall | QF‑Test Tutorial"},"25":{"id":25,"content":"Ein erster Testfall Als nächstes wollen wir einen Blick auf den ersten Testfall werfen. Er besteht aus vier Testschritten:","hash":"tut_firsttestjava","h0":"Ein erster Testfall"},"26":{"id":26,"content":"Abbildung 1.6: Der \"Erste\" Testfallknoten Zurücksetzen - stellt den Anfangszustand der Anwendung über das Menü Datei->Zurücksetzen wieder her und selektiert den Tab Fahrzeuge. Modell I5 wählen - Wählt das letzte Modell I5 in der Fahrzeugetabelle aus. Sondermodell Jazz wählen - Wechselt zum Tab Sondermodelle und wählt dort Jazz. Endpreis prüfen - Überprüft, dass der berechnete Wert dem Feldes Endpreis unten rechts einem vorgegebenen Wert entspricht. Testschritte sind oft hilfreich, um einen Testfalls zu strukturieren und dadurch lesbar und verständlicher zu gestalten. Dies erleichtert später eine eventuelle Fehlersuche oder Anpassungen des Testfalls. Bitte expandieren Sie die vier Testschritt Knoten.","hash":"fig_firstTestCaseJava","h4":"Abbildung 1.6: Der \"Erste\" Testfallknoten"},"27":{"id":27,"content":"Abbildung 1.7: Die Details des ersten Testfalls Sie sehen diverse Mausklicks sowie einen Check. Zur besseren Lesbarkeit des Testfalls wurden sie mittels Testschrittknoten strukturiert. Neben der Aktionsart (Mausklick, Check) wird angezeigt, auf welche Anwendungskomponente sich die Aktion bezieht, also wohin z.B. der Mausklick geht. Diese Knoten können direkt über die Aufnahmefunktion von QF‑Test erzeugt werden. Näheres hierzu erfahren Sie im nächsten Kapitel Erstellen einer eigenen Testsuite (Java). Wir wollen uns nun die Ausführung des ersten Testfalls anschauen. Markieren Sie dazu den Testfall: Erster Knoten. Drücken Sie anschließend den Wiedergabeknopf . Die Testschritte werden nun der Reihe nach abgespielt, wobei dies typischerweise ziemlich rasch passiert. Das aktuelle Testergebnis wird während und nach dem Testlauf in der Statuszeile am unteren rechten Rand des QF‑Test Hauptfensters angezeigt und sollte \"Beendet: Keine Fehler\" lauten. Daneben zeigt QF‑Test verschiedene Zähler an. Der erste Zähler bezieht sich auf die Anzahl der ausgeführten Testfälle, der zweite auf die Zahl der ausgeführten Testfälle ohne Fehler. In unserem Fall wurde ein Testfall fehlerfrei ausgeführt, was einer Erfolgsquote von 100% entspricht.","hash":"fig_firstTestCaseDetailsJava","h4":"Abbildung 1.7: Die Details des ersten Testfalls"},"28":{"id":28,"content":"Abbildung 1.8: Die Ergebnisanzeige in der Statusleiste Wenn Sie den Mauszeiger auf dem Symbol eines Testfallzählers ruhen lassen, wird Ihnen eine entsprechende Beschreibung angezeigt. Eine Auflistung aller Testfallzähler finden Sie im Kapitel Aufnahme und Wiedergabe des Handbuchs.","hash":"fig_resultOneTestCaseNoError","h4":"Abbildung 1.8: Die Ergebnisanzeige in der Statusleiste"},"29":{"id":29,"content":"Pro Tutorial","hash":"","h0":"Ein zweiter Testfall - mit Fehler | QF‑Test Tutorial"},"30":{"id":30,"content":"Pro Tutorial","hash":"home-link","h0":"Ein zweiter Testfall - mit Fehler | QF‑Test Tutorial"},"31":{"id":31,"content":"Ein zweiter Testfall - mit Fehler Der zweite Testfall wird uns zeigen, was passiert, wenn ein Fehler bei der Testausführung auftritt. Bitte expandieren Sie den Knoten Testfall: Zweiter (mit Fehler).","hash":"tut_secondtestjava","h0":"Ein zweiter Testfall - mit Fehler"},"32":{"id":32,"content":"Abbildung 1.9: Der \"Zweite\" Testfallknoten Bis auf den dritten Testschritt sieht es bekannt aus. Was tut der Unbekannte? Testschritt: 10% Rabatt gewähren - Schreibt den Wert 10 in das Rabattfeld Die Texteingabe ist eine weitere Basisaktion. Eingabe-Knoten kann man ebenfalls direkt über die Aufnahmefunktion generieren lassen. Den Wert 10 sieht man im Feld \"Text\" rechts und auch direkt im Text des Baumknotens. Expandieren Sie den Knoten Testschritt: 10% Rabatt gewähren.","hash":"fig_secondTestCaseJava","h4":"Abbildung 1.9: Der \"Zweite\" Testfallknoten"},"33":{"id":33,"content":"Abbildung 1.10: Die Details des zweiten Testfalls Wir wollen uns die Ausführung des zweiten Testfalls anschauen. Markieren Sie dazu den Testfall: Zweiter (mit Fehler) Knoten. Drücken Sie anschließend den Wiedergabeknopf . Diesmal erscheint ein Dialog mit der Information, dass ein Fehler aufgetreten ist.","hash":"fig_secondTestCaseDetailsJava","h4":"Abbildung 1.10: Die Details des zweiten Testfalls"},"34":{"id":34,"content":"Abbildung 1.11: Fehler im zweiten Testfall Was ist passiert? Fast immer wenn so ein Fall auftritt, ist es sinnvoll das Protokoll zu Rate zu ziehen. Alternativ könnte man den Testfall zur Fehlersuche nochmal im Debug-Modus ausführen. Diese Vorgehensweise wird in Kapitel Benutzen des Debuggers (Java) erläutert.","hash":"fig_textTestError","h4":"Abbildung 1.11: Fehler im zweiten Testfall"},"35":{"id":35,"content":"Pro Tutorial","hash":"","h0":"Das Protokoll zur Fehlerdiagnose | QF‑Test Tutorial"},"36":{"id":36,"content":"Pro Tutorial","hash":"home-link","h0":"Das Protokoll zur Fehlerdiagnose | QF‑Test Tutorial"},"37":{"id":37,"content":"Das Protokoll zur Fehlerdiagnose QF‑Test protokolliert detaillierte Informationen für jede Testausführung. Öffnen Sie nun bitte das letzte Protokoll über eine der folgenden Möglichkeiten: den Protokoll anzeigen Knopf im Fehlerdialog oder falls Sie den Dialog bereits geschlossen haben den Button in der Werkzeugleiste oder über die Tastenkombination Strg⁠+⁠L. Die Protokolle der letzten Testläufe können auch über die unteren Einträge im Menü 'Wiedergabe' aufgerufen werden. Das Protokoll öffnet sich in einem separaten Fenster und zeigt die protokollierten Aktionen des zweiten Testfalls, den Sie soeben ausgeführt haben:","hash":"tut_firstrunlogjava","h0":"Das Protokoll zur Fehlerdiagnose"},"38":{"id":38,"content":"Abbildung 1.12: Protokoll des zweiten Testfalls Das Protokoll ist in seinem Aufbau ähnlich zu dem der Testsuite. Der Baum links enthält wieder die bekannten Knoten, jedoch dieses Mal in der zeitlichen Abfolge des Testlaufs. Wenn man einen Knoten anwählt, sieht man rechts die Details inklusive Zeitstempel und Ausführungsdauer. Im Baum links werden Ihnen rote Rahmen um einige Knoten auffallen. Diese zeigen an, dass sich darunter Fehler befinden. Wenn man den rot umrandeten Knoten Ebene für Ebene folgt, erreicht man irgendwann den Fehler. Schneller und bequemer geht es über den Button Nächsten Fehler finden in der Werkzeugleiste oder auch die Tastenkombination [Strg-N]. Alle rot markierten Knoten werden expandiert und der Knoten mit dem eigentlichen Fehler wird selektiert:","hash":"fig_firstErrorRunlogJava","h4":"Abbildung 1.12: Protokoll des zweiten Testfalls"},"39":{"id":39,"content":"Abbildung 1.13: Fehlerdiagnose für den zweiten Testfall Die Fehlermeldung auf der rechten Seite gibt an, dass der erhaltene Wert des Endpreis Feldes nicht dem erwarteten entspricht. Dieser Fehler wurde natürlich mit Absicht eingebaut, um zu zeigen, wie man bei der Analyse vorgehen kann. Hilfreich bei der Fehleranalyse ist üblicherweise auch der übernächste Protokollknoten Bildschirmabbild. Seine Detailansicht enthält ein vollständiges Abbild des Bildschirms zum Zeitpunkt des Fehlers. Dies ist sehr nützlich, um den Zustand des SUTs zu sehen und daraus eventuell die Fehlerursache ableiten zu können. Die folgende Grafik zeigt den Knoten:","hash":"fig_firstErrorRunlogDetailsJava","h4":"Abbildung 1.13: Fehlerdiagnose für den zweiten Testfall"},"40":{"id":40,"content":"Abbildung 1.14: Knoten mit Bildschirmabbild der Fehlersituation Neben dem Abbild aller Bildschirme speichert QF‑Test auch Bilder der einzelnen Fenster des SUT zum Fehlerzeitpunkt. Dies erlaubt Ihnen deren Inhalt zu analysieren, auch wenn diese eigentlich durch andere Fenster oder Dialoge verdeckt sind.","hash":"fig_firstErrorRunlogScreenshotJava","h4":"Abbildung 1.14: Knoten mit Bildschirmabbild der Fehlersituation"},"41":{"id":41,"content":"Pro Tutorial","hash":"","h0":"Wo finde ich Hilfe? | QF‑Test Tutorial"},"42":{"id":42,"content":"Pro Tutorial","hash":"home-link","h0":"Wo finde ich Hilfe? | QF‑Test Tutorial"},"43":{"id":43,"content":"Wo finde ich Hilfe? In diesem Abschnitt machen wir eine kleine Pause, um einige allgemeine Hinweise zu geben. Es gibt verschiedene Möglichkeiten, um Hilfe oder Antworten zu finden: Die umfassendste Suche kann man über »Hilfe«-»Online Suche...« anstoßen. Dies bringt Sie auf die Suchfunktionalität unserer Homepage und erlaubt Ihnen die Abfrage aller verfügbarer Dokumentation (Handbuch, Tutorial, Standardbibliothek, Blog und unsere Videos). Die angezeigten Suchergebnisse können passend gefiltert werden. Wenn Sie offline arbeiten und nach einem Thema suchen wollen, können Sie die Offline-Versionen von Handbuch und Tutorial nutzen, die über das »Hilfe« Menü verfügbar sind. QF‑Test bietet eine kontextsensitive Hilfe für alle Baumknoten und deren Detailattribute an. Um diese zu nutzen, klicken Sie einfach mit der rechten Maustaste auf den gewünschten Knoten oder das Attribut in der Detailansicht. Im Kontextmenü wählen Sie dann den Eintrag »Was ist das?«. Dieser bringt Sie direkt zur passenden Referenzbeschreibung ins Handbuch. Neben der Hilfestellung in der Dokumentation haben Sie auch die Möglichkeit unser Support-Team zu kontaktieren. Während Ihrer Evaluationsphase und anschließend als Kunde mit einem gültigen Pflegevertrag können Sie Ihre Fragen direkt an unsere Support-Expert:innen richten über das Support-Formular im QF‑Test Hilfe-Menü »Support-Team kontaktieren« oder direkt über unsere Webseite.","hash":"tut_firsthelpjava","h0":"Wo finde ich Hilfe?"},"44":{"id":44,"content":"Pro Tutorial","hash":"","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"45":{"id":45,"content":"Pro Tutorial","hash":"home-link","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"46":{"id":46,"content":"Beenden der Anwendung Wir haben noch nicht die Aufräumsequenz angeschaut und wollen dies nun tun: Expandieren Sie den Aufräumen: Demo beenden Knoten.","hash":"tut_firstcleanupjava","h0":"Beenden der Anwendung"},"47":{"id":47,"content":"Abbildung 1.15: Die Aufräumsequenz Unsere Aufräumsequenz stoppt \"hart\" den Client-Prozess und wartet anschließend, bis sich dieser vollständig beendet hat. Dies ist eine sehr einfache Variante aber für den Moment ausreichend. Führen Sie die Aufräumsequenz aus und lassen damit den CarConfigurator verschwinden.","hash":"fig_firstCleanupJava","h4":"Abbildung 1.15: Die Aufräumsequenz"},"48":{"id":48,"content":"Pro Tutorial","hash":"","h0":"Ein vollständiger Testlauf | QF‑Test Tutorial"},"49":{"id":49,"content":"Pro Tutorial","hash":"home-link","h0":"Ein vollständiger Testlauf | QF‑Test Tutorial"},"50":{"id":50,"content":"Ein vollständiger Testlauf Nachdem wir uns Schritt für Schritt durch den Testfallsatz gearbeitet haben, wollen wir nun alles in einem Rutsch ausführen. Schließen Sie bitte das \"CarConfigurator\" Demo, falls es noch läuft. Markieren Sie den Testfallsatz \"Einfache Tests\". Führen Sie ihn aus mittels . Der Testlauf endet mit dem bekannten Fehler. Wenn Sie nun bitte mittels das Protokoll öffnen, sehen Sie, wie QF‑Test den Test abgearbeitet hat.","hash":"tut_firstfullrunjava","h0":"Ein vollständiger Testlauf"},"51":{"id":51,"content":"Abbildung 1.16: Das Protokoll des gesamten Testfallsatzes Man sieht, dass die Vorbereitungs- und Aufräumenknoten vor bzw. nach jedem Testfall ausgeführt werden. Dies ist eine Eigenschaft, die diese im Zusammenspiel mit einem Testfallsatzknoten entwickeln. Dadurch wird für jeden Testfall immer ein sauberer Ausgangszustand hergestellt. Das SUT nach jedem Testfall zu beenden ist nicht die eleganteste Art, einen sauberen Ausgangszustand zu erreichen. Elegantere Wege zur Herstellung einer definierten Testausgangssituation und Durchführung der notwendigen Aufräumarbeiten werden in Kapitel (\"Abhängigkeiten: Automatisches Sicherstellen der korrekten Vorbedingungen jedes Testfalles\") dieses Tutorials erklärt.","hash":"fig_firstRunlogFullJava","h4":"Abbildung 1.16: Das Protokoll des gesamten Testfallsatzes"},"52":{"id":52,"content":"Pro Tutorial","hash":"","h0":"Reportgenerierung | QF‑Test Tutorial"},"53":{"id":53,"content":"Pro Tutorial","hash":"home-link","h0":"Reportgenerierung | QF‑Test Tutorial"},"54":{"id":54,"content":"Reportgenerierung Im Qualitätssicherungsprozess ist es wichtig, Testergebnisse zu dokumentieren und auch zu archivieren. QF‑Test bietet die Möglichkeit, aus Protokollen Testreports zu generieren. Wir wollen dies für das gerade aufgezeichnete Protokoll beispielhaft durchführen. Öffnen Sie bitte das Protokoll und wählen im Menü »Datei«-»Report erstellen...«.","hash":"tut_firstreportjava","h0":"Reportgenerierung"},"55":{"id":55,"content":"Abbildung 1.17: Auswahldialog für die Reportgenerierung Im ersten Feld können Sie den Dateinamen des Reports festlegen. QF‑Test bietet drei Arten von Reports - HTML, XML und JUnit Format. Das XML Format können Sie verwenden, wenn Sie die Reports zum Beispiel mit Hilfe eigener XSLT Stylesheets selbst gestalten wollen. JUnit-Reports erweisen sich als hilfreich, wenn es darum geht, Resultate in Build- oder Testmanagement-Tools zu importieren. Wir wollen uns nun einen einfachen HTML-Report zu unserem letzten Testlauf erzeugen lassen. Lassen Sie bitte die vorgegebenen Optionen unverändert. Bestätigen Sie den Reportdialog mit OK. Anschließend sollte sich Ihr Browser automatisch mit einem Ergebnis äquivalent zum folgenden Bild öffnen:","hash":"fig_ReportDialog","h4":"Abbildung 1.17: Auswahldialog für die Reportgenerierung"},"56":{"id":56,"content":"Abbildung 1.18: Ein HTML Report Der Testbericht beginnt mit einer Zusammenfassung mit allgemeinen Systeminformationen im linken Bereich, einer Legende der verwendeten Symbole rechts, einem Überblicks-Tortendiagramm in der Mitte und dem Gesamtergebnis darunter. In unserem Fall bei einem fehlerhaften von zwei ausgeführten Testfällen eine Erfolgsquote von 50%. Auf die Zusammenfassung folgen drei Übersichten: Testsuiten, die in diesem Testlauf ausgeführt wurden. Testsuiten, in denen Fehler aufgetreten sind. Fehler, mit Ihrem genauen Ort und Fehlermeldung Die Reporterstellung in QF‑Test ist ein praktisches Hilfsmittel, um einen Überblick über einen Testlauf zu gewinnen und ein Dokument zu Präsentations- und Archivierungszwecken zu erstellen.","hash":"fig_ReportHtml","h4":"Abbildung 1.18: Ein HTML Report"},"57":{"id":57,"content":"Pro Tutorial","hash":"","h0":"Erstellen einer eigenen Testsuite (Java) | QF‑Test Tutorial"},"58":{"id":58,"content":"Pro Tutorial","hash":"home-link","h0":"Erstellen einer eigenen Testsuite (Java) | QF‑Test Tutorial"},"59":{"id":59,"content":"Erstellen einer eigenen Testsuite (Java) Dieses Kapitel ist auch als Video verfügbar unter 'Erstellen einer eigenen Testsuite'. In diesem zweiten Kapitel des Java-Tutorials werden wir selbst Sequenzen zum Starten und Beenden des SUT erstellen. Zusätzlich wollen wir Aktionen und Checks aufnehmen und damit einen einfachen Testfall aufbauen.","hash":"sec_testsuite","h1":"Erstellen einer eigenen Testsuite (Java)"},"60":{"id":60,"content":"Pro Tutorial","hash":"","h0":"Starten der Anwendung | QF‑Test Tutorial"},"61":{"id":61,"content":"Pro Tutorial","hash":"home-link","h0":"Starten der Anwendung | QF‑Test Tutorial"},"62":{"id":62,"content":"Starten der Anwendung Zu Beginn muss die zu testende Anwendung aus QF‑Test heraus gestartet werden. Es gibt einen Schnellstart-Assistenten, der uns hilft, eine passende Startsequenz zu erzeugen. Öffnen Sie bitte eine neue, leere Testsuite mittels »Datei«-»Neue Testsuite...«. Öffnen Sie den Schnellstart-Assistenten über das Menü »Extras«-»Schnellstart-Assistent...«. Im ersten Schritt werden Sie dazu aufgefordert, die Art der zu testenden Applikation auszuwählen. Behalten Sie bitte die erste Option Eine Java-Anwendung. Drücken Sie Weiter.","hash":"tut_quickStartJava","h0":"Starten der Anwendung"},"63":{"id":63,"content":"Abbildung 2.1: Auswählen der SUT Art Im zweiten Schritt kann der Typ des Anwendungsprogramms ausgewählt werden. Wieder belassen wir die erste Option \"Ein Startskript bzw. Programm (gestartet mittels .exe, .cmd, .bat, .app, ...)\". Drücken Sie Weiter.","hash":"fig_WizardTypeJava","h4":"Abbildung 2.1: Auswählen der SUT Art"},"64":{"id":64,"content":"Abbildung 2.2: Wahl des SUT Programmtyps Nun werden Sie nach dem Programm oder Startskript gefragt. Nutzen Sie hierzu den Programm auswählen Knopf auf der rechten Seite. Wechseln Sie in das Verzeichnis .../qftest-10.0.2-pro/demo/carconfigSwing/ in Ihrer QF‑Test Installation. Wählen Sie dort die Datei CarConfig.cmd (bzw. CarConfig.sh, wenn Sie unter macOS/Linux arbeiten). Im Bild sieht man eine weitere Möglichkeit: Die Verwendung der Variablen ${qftest:dir.version} am Beginn, die automatisch zum versionsspezifischen Installationsverzeichnis von QF‑Test expandiert. Details zu speziellen QF‑Test Variablen finden Sie im Handbuch Kapitel Variablen. Drücken Sie den Fertig Knopf, da wir die weiteren optionalen Schritte für unser einfaches Demo nicht benötigen.","hash":"fig_WizardTypeExec","h4":"Abbildung 2.2: Wahl des SUT Programmtyps"},"65":{"id":65,"content":"Abbildung 2.3: Auswahl der Programm Datei Wir gelangen direkt zur Zusammenfassung, die beschreibt, wie es nach dem Beenden des Schnellstart-Assistenten weiter geht. Drücken Sie den Fertig Knopf, um den Assistenten zu beenden.","hash":"fig_WizardExecFile","h4":"Abbildung 2.3: Auswahl der Programm Datei"},"66":{"id":66,"content":"Abbildung 2.4: Zusammenfassung Die generierte Startsequenz erscheint in den \"Extrasequenzen\" der Testsuite und enthält drei Schritte: Variable setzen - definiert die globale Client Variable, die durchweg in der Testsuite benutzt wird. Warten auf Client - prüft, ob der Client bereits läuft. SUT starten, wenn notwendig - falls der Client noch nicht läuft, wird er mit Hilfe eines \"SUT-Client starten\" Knotens als zu testendes System (SUT) gestartet und gewartet bis dies erfolgt ist. Die Information, ob der Client bereits läuft wird im ersten \"Warten auf Client\" Knoten einer Variable \"isSUTRunning\" gespeichert und in der folgenden \"If\" Bedingung ausgewertet. Sie können dies in den entsprechenden Knotendetails sehen. Diese Art der bedingten Ausführung wird später noch im Detail erklärt.","hash":"fig_WizardFinal","h4":"Abbildung 2.4: Zusammenfassung"},"67":{"id":67,"content":"Abbildung 2.5: Generierte Startsequenz Probieren wir sie aus: Stellen Sie bitte sicher, dass der Knoten Vorbereitung: Starte CarConfig ausgewählt ist. Drücken Sie oder betätigen Sie einfach die Eingabe Taste. Im folgenden Bild ist das Fenster des SUT-Client dargestellt, das nun erscheinen sollte. Da nach dem Abspielen der Fokus zurück zu QF‑Test wandert, kann es sein dass das Fenster der Testsuite die Demoanwendung dann verdeckt.","hash":"fig_WizardResult","h4":"Abbildung 2.5: Generierte Startsequenz"},"68":{"id":68,"content":"Abbildung 2.6: Das Fenster des \"CarConfigurator\" Am Ende dieses Abschnitts wollen wir unsere Testsuite speichern. Drücken Sie den Knopf in der Werkzeugleiste oder nutzen Sie die »Datei«-»Speichern« Menüaktion bzw. das Tastenkürzel Strg⁠+⁠S. Im Datei-Explorer navigieren Sie in ein passendes Verzeichnis, in dem Sie Schreibrechte besitzen, z.B. Dokumente in Ihrem Benutzerverzeichnis. Geben Sie einen Namen ein z.B. MeineErstenTests.qft. Beenden Sie die Speicheraktion über den Speichern-Knopf.","hash":"fig_jCarConfigWin","h4":"Abbildung 2.6: Das Fenster des \"CarConfigurator\""},"69":{"id":69,"content":"Pro Tutorial","hash":"","h0":"Aufnehmen von Aktionen | QF‑Test Tutorial"},"70":{"id":70,"content":"Pro Tutorial","hash":"home-link","h0":"Aufnehmen von Aktionen | QF‑Test Tutorial"},"71":{"id":71,"content":"Aufnehmen von Aktionen Wir werden nun erste Aktionen in unserem Demo aufnehmen:","hash":"tut_recActionsJava","h0":"Aufnehmen von Aktionen"},"72":{"id":72,"content":"Abbildung 2.7: Aktionen im CarConfigurator Demo aufnehmen Drücken Sie dazu den Aufnahmeknopf Wechseln Sie zum CarConfigurator Fenster. Von jetzt ab wird jede Maus- oder Tastaturaktion aufgenommen. Wählen Sie mit der Maus das Modell I5 ganz unten in der Tabelle aus. Wechseln Sie zum Tab Sondermodelle. Wählen Sie dort das Sondermodell Jazz über das Dropdown-Menü. Zum Schluss klicken Sie wieder auf den ersten Tab Fahrzeuge. Beenden Sie die Aufnahme, indem Sie zurück zum QF‑Test Fenster wechseln und dort den Knopf für \"Aufnahme beenden\" drücken. Sie finden die aufgenommene Sequenz unter dem \"Extrasequenzen\" Knoten, wie im folgenden Bild dargestellt.","hash":"fig_JCarConfigWinRec","h4":"Abbildung 2.7: Aktionen im CarConfigurator Demo aufnehmen"},"73":{"id":73,"content":"Abbildung 2.8: Der Baum nach Aufnahme der Sequenz Als Sequenzname wird standardmäßig Datum und Zeit der Erstellung verwendet. Dieser kann anschließend in den Details rechts beliebig angepasst werden. Ändern Sie den Sequenznamen bitte ab zu \"Modell I5 Jazz wählen\" Öffnen Sie die Sequenz um die enthaltenen Knoten zu sehen. Es sollten die erwarteten Mausklicks sein. Sie sollten sogar in der Lage sein, die angesprochenen Komponenten zuordnen zu können.","hash":"fig_FirstRecordedSequence","h4":"Abbildung 2.8: Der Baum nach Aufnahme der Sequenz"},"74":{"id":74,"content":"Abbildung 2.9: Die umbenannte Sequenz Wir wollen nun die aufgenommene Sequenz abspielen. Markieren die Sequenz Modell I5 Jazz wählen. Drücken Sie Wiedergabe. Sie sollten die exakt gleichen Aktionen sehen, die Sie zuvor aufgenommen haben. Den aufgenommenen Ablauf sollten Sie auch wiederholt ohne Fehler abspielen können. Rechts unten im Fenster der Testsuite sollte \"Beendet: Keine Fehler\" zu sehen sein.","hash":"fig_FirstRecordedSequenceRenamed","h4":"Abbildung 2.9: Die umbenannte Sequenz"},"75":{"id":75,"content":"Pro Tutorial","hash":"","h0":"Aufnahme von Checks | QF‑Test Tutorial"},"76":{"id":76,"content":"Pro Tutorial","hash":"home-link","h0":"Aufnahme von Checks | QF‑Test Tutorial"},"77":{"id":77,"content":"Aufnahme von Checks Um das Verhalten des Clients zu überprüfen, verwenden wir Check-Knoten, mit denen man Zustand und Eigenschaften von Elementen abfragen kann. Auch Checks können aufgezeichnet werden. Zum Aufnehmen eines Checks drücken Sie den \"Check aufnehmen\" Knopf. Wechseln Sie zum Fenster des SUT. Es erscheint ein Rahmen um die Komponente, über der sich der Mauszeiger befindet. Klicken Sie mit der rechten Maustaste auf das Wertfeld des Endpreises. Das erscheinende Kontextmenü erlaubt Ihnen die Auswahl eines Checks. Die Liste der verfügbaren Checks hängt vom Typ der Komponente ab. Wählen Sie den ersten Eintrag \"Text\", um den textuellen Wert des Feldes zu überprüfen. Beenden Sie die Aufnahme durch Drücken des Stoppknopfs . Wieder taucht die neue Aufnahme unter den \"Extrasequenzen\" auf. Benennen Sie den Sequenzknoten um auf den Namen \"Endpreis prüfen\". Öffnen Sie anschließend den Sequenzknoten, um den Checkknoten zu sehen.","hash":"tut_recChecksJava","h0":"Aufnahme von Checks"},"78":{"id":78,"content":"Abbildung 2.10: Die aufgenommene Check-Sequenz In den Details des \"Check Text\" Knotens sieht man ebenfalls den erwarteten Wert des Endpreis Feldes. Auch diese Sequenz können Sie wieder selbst ausführen, um die Wiedergabe zu testen. Im nächsten Schritt wollen wir aus den beiden Sequenzen einen richtigen Testfall aufbauen.","hash":"fig_textchecktree","h4":"Abbildung 2.10: Die aufgenommene Check-Sequenz"},"79":{"id":79,"content":"Pro Tutorial","hash":"","h0":"Erstellen einer Testsuite | QF‑Test Tutorial"},"80":{"id":80,"content":"Pro Tutorial","hash":"home-link","h0":"Erstellen einer Testsuite | QF‑Test Tutorial"},"81":{"id":81,"content":"Erstellen einer Testsuite Die Basisstruktur unterhalb des Wurzelknotens einer Testsuite ist durch folgende Knoten festgelegt: Eine beliebige Anzahl von \"Testfallsatz\" und \"Testfall\" Knoten, um funktionale Tests zu spezifizieren und zu strukturieren. \"Prozeduren\" - hier können wiederverwertbare Sequenzen in Prozeduren organisiert werden \"Extrasequenzen\" - unsere Spielwiese für Aufnahmen etc. \"Fenster und Komponenten\" - das eigentliche Herz der Testsuite. Hier sind alle aufgenommenen Fenster und Komponenten des SUT mit ihren Eigenschaften enthalten Funktionale Testfälle werden durch \"Testfall\" Knoten repräsentiert und mittels \"Testfallsatz\" Knoten gruppiert bzw. strukturiert. \"Vorbereitung\" und \"Aufräumen\" Knoten können Aktionen enthalten, um einen wohldefinierten Zustand vor und nach einem Testfall sicherzustellen. Wir beginnen mit dem Umbenennen des \"Testfallsatz\" Knotens von \"unbenannt\" in \"Demo Tests\". Falls ein Dialog bzgl. der Aktualisierung von Verweisen erscheint, können wir diesen einfach mit \"Ja\" beantworten. Der nächste Schritt ist, den vom Schnellstart-Assistenten erzeugten Knoten \"Vorbereitung\" in den \"Testfallsatz\" zu verschieben und zwar an die erste Position vor den enthaltenen Testfall. Das Verschieben kann mit Hilfe der Maus (Drag&Drop), des Kontextmenüs (rechte Maustaste Ausschneiden/Einfügen) oder der Tastenkombination Strg⁠+⁠X und Strg⁠+⁠V durchgeführt werden.","hash":"tut_buildtestjava","h0":"Erstellen einer Testsuite"},"82":{"id":82,"content":"Abbildung 2.11: Beginn der Strukturierung Als Nächstes gilt es, aus den beiden vorher aufgezeichneten Sequenzen einen Testfall zu machen. Benennen Sie dazu den Testfall Knoten von \"unbenannt\" in \"Erster\" um. Öffnen Sie den Testfall Knoten durch einen Klick auf das '>' Symbol. Verschieben Sie die beiden Sequenzen aus den \"Extrasequenzen\" in den Testfall. Wenn Sie den Testfall Knoten nicht öffnen, versucht QF‑Test die Sequenzknoten hinter dem Testfall Knoten auf der gleichen Ebene einzufügen. Dies ist jedoch für Sequenzknoten nicht zulässig. QF‑Test nimmt immer Sequenzen auf. Diese haben die gleiche Funktion wie Testschritte. Testschritte werden jedoch im Bericht aufgeführt. Man kann sie ineinander umwandeln, was wir Ihnen in den nächsten Schritten informationshalber zeigen wollen. Öffnen Sie das Kontextmenü für den ersten der beiden Sequenzknoten mit der rechten Maustaste. Wählen Sie »Knoten konvertieren in...«-»Testschritt« Führen Sie dasselbe für den zweiten Sequenzknoten durch.","hash":"fig_beginbuildatest","h4":"Abbildung 2.11: Beginn der Strukturierung"},"83":{"id":83,"content":"Abbildung 2.12: Der Baum nach der Neustrukturierung Damit haben wir die wichtigsten Schritte zur Strukturierung unserer Testsuite abgeschlossen.","hash":"fig_buildatest","h4":"Abbildung 2.12: Der Baum nach der Neustrukturierung"},"84":{"id":84,"content":"Pro Tutorial","hash":"","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"85":{"id":85,"content":"Pro Tutorial","hash":"home-link","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"86":{"id":86,"content":"Beenden der Anwendung Was uns als Basiselement noch fehlt, ist eine Aufräumsequenz, die das SUT sauber beendet. Es gibt verschiedene Wege eine Anwendung zu beenden, z.B. über den \"Fenster schließen\" Knopf rechts oben, durch Drücken von Alt-F4 oder das Menü »Datei«-»Beenden«. Alle diese Varianten lassen sich direkt aufzeichnen. Wir werden die letzte Möglichkeit nutzen, so dass Sie die folgenden Schritte durchführen können: Aufnahme starten . Menüaktion »Datei«-»Beenden« durchführen. Das Fenster der Demoanwendung verschwindet. Aufnahme beenden . Benennen Sie die aufgenommene Sequenz in \"Demo beenden\" um. Öffnen Sie das Kontextmenü für den Sequenzknoten und wählen Sie den Menüpunkt »Knoten konvertieren in...«-»Aufräumen« . Zuletzt verschieben Sie den Aufräumenknoten nach oben, so dass er der letzte Knoten im Testfallsatz ist. Der Aufräumknoten kann nur per Drag and Drop in den Testfallsatz verschoben werden, wenn dessen letzter Kindknoten eingeklappt ist. Um einen Knoten während einer Drag and Drop Operation ein- oder auszuklappen, verweilen Sie einen Moment mit dem Mauszeiger über dem Dreieck neben dem Knoten. Sie sollten folgendes Resultat erhalten:","hash":"tut_cleanup","h0":"Beenden der Anwendung"},"87":{"id":87,"content":"Abbildung 2.13: Die einfache Aufräumsequenz Damit haben wir die wichtigsten Schritte zur Strukturierung unserer Testsuite abgeschlossen.","hash":"fig_StopSequence","h4":"Abbildung 2.13: Die einfache Aufräumsequenz"},"88":{"id":88,"content":"Pro Tutorial","hash":"","h0":"Gesamte Suite ausführen | QF‑Test Tutorial"},"89":{"id":89,"content":"Pro Tutorial","hash":"home-link","h0":"Gesamte Suite ausführen | QF‑Test Tutorial"},"90":{"id":90,"content":"Gesamte Suite ausführen Als Abschluss wollen wir unsere neue Suite ausführen: Beenden Sie dazu nun bitte den SUT Client, falls er läuft. Markieren Sie den \"Testsuite\" Wurzelknoten. Führen Sie diesen durch Drücken von \"Wiedergabe\" oder der Eingabe Taste aus. Das SUT sollte erscheinen, der Testfall aufgeführt und das SUT wieder beendet werden. Wie wir wissen, wird das Ergebnis des Testlaufs im Protokoll festgehalten: Um dieses anzuschauen, können wir den Button \"Protokoll anzeigen\" in der Werkzeugleiste oder alternative die Tastenkombination Strg⁠+⁠L nutzen.","hash":"tut_runOwnSuite","h0":"Gesamte Suite ausführen"},"91":{"id":91,"content":"Abbildung 2.14: Der Protokollbaum der eigenen Testsuite Wir hatten bereits im ersten Kapitel gesehen, wie das Protokoll für die Fehleranalyse genutzt werden kann. Wir möchten damit dieses Kapitel beenden und einen Schritt weiter in Richtung Fehlerdiagnose gehen. Hierbei stellt der Debugger ein wichtiges Werkzeug innerhalb QF‑Test dar. Seine Handhabung und Möglichkeiten werden im nächsten Kapitel beschrieben.","hash":"fig_firstrunlog","h4":"Abbildung 2.14: Der Protokollbaum der eigenen Testsuite"},"92":{"id":92,"content":"Pro Tutorial","hash":"","h0":"Eine Prozedur erstellen (Java) | QF‑Test Tutorial"},"93":{"id":93,"content":"Pro Tutorial","hash":"home-link","h0":"Eine Prozedur erstellen (Java) | QF‑Test Tutorial"},"94":{"id":94,"content":"Eine Prozedur erstellen (Java) Dieses Kapitel ist auch als Video verfügbar unter 'Eine Prozedur erstellen'. In den beiden vorherigen Kapiteln haben Sie gelernt wie man eine Applikation über QF‑Test startet, so dass Maus- und Tastatureingaben aufgenommen werden können, auch wie man Checks aufnimmt und wie man das Ergebnis zu einem Testfall zusammenfasst. Diese Herangehensweise ist ausreichend, solange die Tests einfach und nicht allzu viele sind. Sobald jedoch die Zahl der Tests zunimmt, ist es wichtig, sogenannte \"Prozeduren\" einzusetzen. Prozeduren sind ein Mittel um Sequenzen wiederverwendbar zu machen und damit Doppelvorkommen zu vermeiden. Dies ist wichtig, um eine einfache und effiziente Wartbarkeit von Tests über die Zeit zu erreichen. Prozeduren können in Packages gruppiert werden. Prozeduren und Packages sind die Basis für die Modularisierung der Tests.","hash":"sec_FirstProzedur","h1":"Eine Prozedur erstellen (Java)"},"95":{"id":95,"content":"Pro Tutorial","hash":"","h0":"Wiederverwendbare Abschnitte identifizieren | QF‑Test Tutorial"},"96":{"id":96,"content":"Pro Tutorial","hash":"home-link","h0":"Wiederverwendbare Abschnitte identifizieren | QF‑Test Tutorial"},"97":{"id":97,"content":"Wiederverwendbare Abschnitte identifizieren In diesem Abschnitt werden wir die Testsuite ErsteJavaTests.qft, die Sie bereits aus Kapitel 1 kennen, weiterentwickeln. Kopieren Sie ErsteJavaTests.qft aus dem Unterverzeichnis qftest-10.0.2-pro/doc/tutorial der QF‑Test Installation in ein Arbeitsverzeichnis und öffnen Sie ErsteJavaTests.qft. Wenn Sie die Änderung, die wir an der Demo-Testsuite vornehmen werden, sichern wollen, so speichern Sie diese in einem Arbeitsverzeichnis wie am Ende von \"Starten der Anwendung\" beschrieben. Bitte sehen Sie sich den Testschritt \"Zurücksetzen\" in den beiden Testfällen an. Die beiden Testschritte sind identisch.","hash":"tut_procreuse","h0":"Wiederverwendbare Abschnitte identifizieren"},"98":{"id":98,"content":"Abbildung 3.1: Zwei identische Testschritte Gemäß obiger Überlegungen wäre es also sinnvoll, den Testschritt in eine Prozedur umzuwandeln.","hash":"IdenticalTeststeps","h4":"Abbildung 3.1: Zwei identische Testschritte"},"99":{"id":99,"content":"Pro Tutorial","hash":"","h0":"Manuelle Erstellung von Prozeduren | QF‑Test Tutorial"},"100":{"id":100,"content":"Pro Tutorial","hash":"home-link","h0":"Manuelle Erstellung von Prozeduren | QF‑Test Tutorial"},"101":{"id":101,"content":"Manuelle Erstellung von Prozeduren Es gibt mehrere Methoden Prozeduren zu erstellen und Prozeduraufrufe einzufügen. Wir fangen mit der manuellen an, bei der ein (leerer) Prozedurknoten eingefügt wird, in den dann die entsprechenden Aktionen verschoben werden. Danach erstellen wir den zugehörigen Prozeduraufruf. Es ist gut, wenn man diese grundlegenden Schritte kennt. Es gibt jedoch eine zweite, elegantere Methode Prozeduren zu erstellen, die wir im Anschluss zeigen werden. Also los, fügen wir eine Prozedur von Hand ein: Wir beginnen mit dem Anlegen des Prozedurknotens, dem wir einen geeigneten Namen geben. Öffnen Sie den Prozeduren Knoten und achten Sie darauf, dass er auch selektiert (blau markiert) ist. Wählen Sie »Einfügen«-»Prozedurknoten«-»Prozedur«. Tragen Sie als Name \"zurücksetzen\" ein. Die anderen Felder brauchen nicht befüllt zu werden. Öffnen Sie die neu erstellte \"zurücksetzen\" Prozedur.","hash":"tut_procmanual","h0":"Manuelle Erstellung von Prozeduren"},"102":{"id":102,"content":"Abbildung 3.2: Prozedurknoten erstellen Im zweiten Schritt befüllen wir die Prozedur mit den entsprechenden wiederverwendbaren Aktionen. Selektieren Sie die drei \"Mausklick\" Knoten im Testschritt. Um mehr als einen Knoten zu selektieren, klicken Sie den ersten der Knoten an, dann drücken Sie die Shift Taste und klicken den letzten der zu selektierenden Knoten während Sie die Shift Taste gedrückt halten. Verschieben Sie diese nach unten in die Prozedur, z.B. mit der Maus (Drag and drop) oder über Ausschneiden/Einfügen im Menü »Bearbeiten« oder über das Kontextmenü.","hash":"ProcedureNodeInFirstTestcase","h4":"Abbildung 3.2: Prozedurknoten erstellen"},"103":{"id":103,"content":"Abbildung 3.3: Prozedur mit Inhalt befüllen Im dritten Schritt fügen wir einen Prozeduraufruf an Stelle der drei verschobenen Mausklicks ein. Selektieren Sie den Testschritt \"Zurücksetzen\", der geöffnet sein sollte. Wählen Sie den Menüpunkt »Einfügen«-»Prozedurknoten«-»Prozeduraufruf« oder verwenden Sie das Tastaturkürzel Strg⁠+⁠A.","hash":"procedureContentInFirstTestcase","h4":"Abbildung 3.3: Prozedur mit Inhalt befüllen"},"104":{"id":104,"content":"Abbildung 3.4: Prozeduraufruf einfügen Drücken Sie den Prozedur-Auswahlknopf links neben der Beschriftung \"Name der Prozedur\". Wählen Sie \"zurücksetzen\" aus der Prozedurliste. Weitere Eingaben sind nicht nötig. Drücken Sie OK um die Erstellung des Prozeduraufrufs abzuschließen.","hash":"AddProcedureCall","h4":"Abbildung 3.4: Prozeduraufruf einfügen"},"105":{"id":105,"content":"Abbildung 3.5: Prozedur auswählen Um wirklich einen Mehrwert durch die Prozedur zu erlangen, müssen wir nun den Inhalt des Testschritts im zweiten Testfall ebenfalls durch einen Aufruf der Prozedur \"zurücksetzen\" ersetzen. Sie können dies wie oben beschrieben tun oder Sie führen folgende alternative Schritte zur Erstellung des Prozeduraufrufs aus: Öffnen Sie den Testschritt 'Zurücksetzen' des zweiten Testfalls. Löschen Sie die drei Mausklick Knoten daraus. Selektieren Sie den Prozedurknoten \"zurücksetzen\". Ziehen Sie den Prozedurknoten \"zurücksetzen\" mit der Maus in den Testschrittknoten. Kopieren/einfügen kann ebenfalls verwendet werden. Dadurch wird der Prozedurknoten nicht verschoben, sondern ein entsprechender Prozeduraufruf erzeugt. Die Testsuite sollte anschließend wie folgt aussehen:","hash":"SelectProcedure","h4":"Abbildung 3.5: Prozedur auswählen"},"106":{"id":106,"content":"Abbildung 3.6: Testsuite mit Prozedur Wenn Sie nun die Testfälle ausführen, sollten diese funktionieren wie zuvor. Im Protokoll sind jetzt auch die Prozeduraufrufe und deren Ausführung zu sehen.","hash":"fig_testsuite_with_Procedure","h4":"Abbildung 3.6: Testsuite mit Prozedur"},"107":{"id":107,"content":"Pro Tutorial","hash":"","h0":"Knoten in Prozedur konvertieren | QF‑Test Tutorial"},"108":{"id":108,"content":"Pro Tutorial","hash":"home-link","h0":"Knoten in Prozedur konvertieren | QF‑Test Tutorial"},"109":{"id":109,"content":"Knoten in Prozedur konvertieren Wie bereits am Anfang des letzten Abschnitts erwähnt, bietet QF‑Test eine Alternative um Prozeduren wesentlich schneller zu erstellen. Markieren Sie den Testschritt oder Sequenz-Knoten, der die wiederverwendbaren Schritte enthält, die zur Prozedur umgewandelt werden sollen. Wählen Sie den Menüpunkt »Operationen«-»Knoten konvertieren in«-»Prozedur« aus oder verwenden Sie das Tastaturkürzel Strg⁠+⁠Umschalt⁠+⁠P. Wie Sie sehen, ist der Testschritt bzw. der Sequenzknoten verschwunden. Anstelle dessen befindet sich ein Prozeduraufruf. Außerdem wurde eine Prozedur mit dem Namen des ehemaligen Testschritts bzw. der Sequenz im Abschnitt \"Prozeduren\" erstellt. Sie enthält genau die gleichen Kindknoten wie zuvor der Testschritt bzw. die Sequenz. Bei der Aufnahme einer Sequenz in QF‑Test hat sich das Vorgehen bewährt, der Sequenz sofort einen Namen zu geben und sie anschließend in eine Prozedur zu konvertieren. Auch wenn man nur eine Vermutung hat, dass sich die aufgenommenen Schritte irgendwo wiederholen könnten.","hash":"tut_proctransform","h0":"Knoten in Prozedur konvertieren"},"110":{"id":110,"content":"Pro Tutorial","hash":"","h0":"Komponenten (Java) | QF‑Test Tutorial"},"111":{"id":111,"content":"Pro Tutorial","hash":"home-link","h0":"Komponenten (Java) | QF‑Test Tutorial"},"112":{"id":112,"content":"Komponenten (Java) Dieses Kapitel ist auch als Video verfügbar unter 'Komponenten'. Werfen wir nun einen Blick auf den letzten verbleibenden Bereich des Testsuite Fensters, den Fenster und Komponenten Knoten. Zuvor möchten wir Ihnen jedoch zeigen, wie Unterelemente von Komponenten wie Tabellen, Bäumen und Listen adressiert werden.","hash":"sec_ComplexComponents","h1":"Komponenten (Java)"},"113":{"id":113,"content":"Pro Tutorial","hash":"","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen | QF‑Test Tutorial"},"114":{"id":114,"content":"Pro Tutorial","hash":"home-link","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen | QF‑Test Tutorial"},"115":{"id":115,"content":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen Unterelemente von Tabellen, Bäumen und Listen werden über Indizes angesprochen. Die wichtigsten beiden Indextypen sind der numerische und der Textindex. Zur Demonstration nehmen wir als nächstes einen Mausklick auf eine Tabellenzelle auf und sehen uns die aufgenommene QF‑Test ID der Komponente näher an. Starten Sie das CarConfig Demo, falls dieses nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf eine Tabellenzelle, z.B. das erste Modell. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Den aufgenommenen Mausklick finden Sie im Bereich Extrasequenzen.","hash":"sec_addressing_complex_components","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen"},"116":{"id":116,"content":"Abbildung 4.1: Adressierung einer Tabellenzelle Die aufgenommene QF‑Test ID der Komponente ist VehicleTable@Modell&0. Sie setzt sich aus den folgenden Teilen zusammen: VehicleTable ist die QF‑Test ID der Komponente der Tabelle selbst. @ und & trennen die einzelnen Teile voneinander. Gleichzeitig definieren sie den Typ des darauf folgenden Index: auf @ folgt ein Textindex, auf & ein numerischer Index. Modell ist der Textindex für die Spalte mit der Überschrift 'Modell'. 0 ist der numerische Index für die erste Tabellenzeile. Numerische Indizes beginnen immer mit 0. Sie können beide Indextypen für Zeilen und Spalten verwenden. Dabei ist nur wichtig, dass das Trennzeichen und der Typ des folgenden Index zusammenpassen. Ändern Sie die QF‑Test ID der Komponente so, dass das dritte Preisfeld adressiert wird. Verwenden Sie dafür numerische Indizes. Die Lösung hierfür lautet VehicleTable&1&2. Um das Modell 'I5' über Textindizes anzusprechen, tragen Sie VehicleTable@Modell@I5 ein. Das gleiche Feld kann man numerisch mittels VehicleTable&0&4 ansprechen oder mit gemischten Indizes mittels VehicleTable&0@I5 oder VehicleTable@Modell&4. Der dritte Indextyp von QF‑Test ist ein Index mit regulärem Ausdruck. Reguläre Ausdrücke werden verwendet, um Zeichenketten durch einen Ausdruck zu ersetzen, der verschiedene Zeichenketten adressieren kann. Sozusagen eine \"Sternchensuche\", wobei reguläre Ausdrücke wesentlich mächtiger sind und eine eigene Syntax besitzen. Eine genauere Beschreibung regulärer Ausdrücke finden Sie im Handbuch. Beispiel: Das Modell 'I5' könnte man also auch über VehicleTable@Modell%I.* ansprechen. Listen werden analog zu Tabellen adressiert, nur dass sie nur einen einzigen Index benötigen. Bäume haben ebenfalls nur einen einzigen Index. Dieser ist der Pfad durch den Baum zu dem adressierten Baumknoten. Der Pfad setzt sich aus den einzelnen Knoten zusammen, die durch Schrägstriche (\"/\") voneinander getrennt werden. Starten Sie das CarConfig Demo, falls dieses nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Öffnen Sie das Baum-Beispiel: Wählen Sie im CarConfig Demo den Menüpunkt »Einstellungen«-»Sondermodelle...«, selektieren Sie ein Modell und drücken die Schaltfläche \"Details\". Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf einen Baumknoten, z.B. \"Beschreibung\". Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Für den Baumknoten \"Beschreibung\" wird die folgende QF‑Test ID der Komponente aufgenommen: DetailsTree@/Information/Beschreibung. Die einzelnen Bestandteile davon sind: DetailsTree ist die QF‑Test ID der Komponente des Baums selbst. @ trennt die QF‑Test ID der Komponente des Baums vom Index. Die Syntax ist hierbei analog zu der der Tabellenindizes, d.h. @ steht für einen Textindex, & für einen numerischen Index und % für einen Index mit regulärem Ausdruck. /Information/Beschreibung ist der Textindex für den Baumpfad zum Knoten \"Beschreibung\". Wenn Sie den Knoten über einen numerischen Index adressieren wollen, verwenden Sie DetailsTree&/0/1.","hash":"fig_components_tableindex","h4":"Abbildung 4.1: Adressierung einer Tabellenzelle"},"117":{"id":117,"content":"Pro Tutorial","hash":"","h0":"Der Bereich Fenster und Komponenten | QF‑Test Tutorial"},"118":{"id":118,"content":"Pro Tutorial","hash":"home-link","h0":"Der Bereich Fenster und Komponenten | QF‑Test Tutorial"},"119":{"id":119,"content":"Der Bereich Fenster und Komponenten Zum Thema \"Komponenten\" gibt es mehrere Videos: Das Video 'Komponentenerkennung' erläutert zunächst die Wiedererkennungskriterien für Komponenten, danach (ab Minute 13:07) werden generische Komponenten erläutert, zuerst solche mit regulären Ausdrücken, danach solche mit Variablen für die Wiedererkennungsmerkmale. Es gibt zwei Videos, die die Behandlung einer ComponentNotFoundException ausführlich erklären: Ein einfacher Fall wird im Video 'ComponentNotFoundException - einfacher Fall' erläutert. Einen komplexeren Fall gibt es in 'ComponentNotFoundException - komplexer Fall'. Video-Mitschnitt des Spezialwebinars 'Komponentenerkennung'. QF‑Test speichert die Informationen, wie es die im GUI des SUT angezeigten Komponenten wiederfindet, im Bereich Fenster und Komponenten ab. Dabei analysiert QF‑Test bei der Aufnahme die erhaltenen GUI-Element-Informationen und speichert diejenigen, mit denen der Anwender interagiert hat, in den Details der Komponente Knoten ab. Swing, JavaFX und SWT verfügen über klare Konzepte, wie eine bestimme Komponente vom Entwickler technisch zu implementieren ist. Daher ist es bei Anwendungen, die mit diesen Sprachen entwickelt wurden, selten nötig, sich näher mit den Komponentenknoten zu befassen. In den meisten Fällen wird QF‑Test die Komponente, auf die eine Aktion im GUI abgespielt werden soll, wiederfinden. Nur wenn sich die Oberfläche der Applikation jenseits des Wiedererkennungsalgorithmus von QF‑Test verändert hat, müssen Sie sich mit den Komponente Knoten befassen. In diesem Fall finden Sie im Handbuch, Kapitel Lösung von Problemen bei der Wiedererkennung detaillierte Anweisungen. Dort gibt es auch Links auf Videos mit entsprechenden Beispielen. In diesem Abschnitt wollen wir Ihnen eine Vorstellung davon vermitteln, welche Informationen in Komponente Knoten abgespeichert werden und wie diese von QF‑Test für die Wiedererkennung verwendet werden. Sehen Sie sich die Details einer \"TextField\" Komponente an. Starten Sie das CarConfig Demo, falls dies nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Öffnen Sie die Prozedur \"Endpreis prüfen\". Öffnen Sie das Kontextmenü des 'Check Text'-Knotens. Springen Sie zum Knoten der \"TextField\" Komponente über den Menüpunkt »Komponente finden« im Popup-Menü oder über das Tastaturkürzel Strg⁠+⁠W.","hash":"sec_componentsteps","h0":"Der Bereich Fenster und Komponenten"},"120":{"id":120,"content":"Abbildung 4.2: Komponente finden Dadurch gelangen Sie direkt zum Knoten \"TextField CalculatedPrice\" im Bereich Fenster und Komponenten.","hash":"fig_components_locate","h4":"Abbildung 4.2: Komponente finden"},"121":{"id":121,"content":"Abbildung 4.3: Komponentenbaum Für den Komponente Knoten mit der QF‑Test ID CalculatedPrice sehen die Details wiefolgt aus:","hash":"fig_components_tree","h4":"Abbildung 4.3: Komponentenbaum"},"122":{"id":122,"content":"Abbildung 4.4: Details eines Komponente Knoten Wie werden die Attribute des Komponente Knotens zur Wiedererkennung der GUI-Elemente eingesetzt? Das erste Attribut ist QF‑Test ID, das in den Testfällen und Prozeduren zur Ansprache der Komponente verwendet wird. Alle anderen Attribute beziehen sich auf Eigenschaften des GUI-Elements. Das folgende Attribut ist die Klasse. In unserem Fall TextField. Für die Komponentenerkennung ist die Klasse ein eindeutiges Merkmal. Die angezeigte Klasse ist eine von QF‑Test verallgemeinerte Klasse, basierend auf der Java-Klasse oder der Java-Systemklasse. Durch diese generische Klasse werden die Tests unabhängig von der konkreten Implementierung und können leicht portiert werden, z.B. von Swing auf den Nachfolger JavaFX. Die speziellen Werte werden in der Tabelle \"Weitere Merkmale\" mit den Namen qfs:class und qfs:systemclass abgespeichert. Sie spielen standardmäßig für die Erkennung keine Rolle, können aber für Sonderfälle genutzt werden. Weitere Beispiele für Klassen sind \"Panel\", \"Dialog\" und \"Button\". Dass Attribut \"Name\" enthält den Namen oder die Id, die dem GUI-Element seitens des Programmierers gegeben wurde. Falls ein Name vorhanden ist, ist dies für QF‑Test zusammen mit der Klasse zur Komponentenerkennung ausreichend. Die übrigen Attribute bleiben dann unberücksichtigt. Wenn weder ein Name noch eine Id durch den Entwickler gesetzt wurde und das Attribut \"Name\" daher keinen Wert enthält, verwendet QF‑Test andere Kriterien wie z.B. einen bestimmten Text, der zur Komponente gehört, Index und Geometrie. Ein zur Komponente gehörendes Merkmal wäre bei einer Schaltfläche zum Beispiel der darauf angezeigte Text. QF‑Test speichert Texte, die direkt zur Komponente gehören, im Attribut \"Merkmal\" ab. Texte in der Nähe einer Komponente, die QF‑Test als mögliche Beschriftung identifiziert, werden ebenfalls im Merkmal-Attribut abgespeichert, wobei sie den Präfix Label: erhalten. Zusätzlich werden diese Texte in der Tabelle \"Weitere Merkmale\" unter dem Namen qfs:label gespeichert. Die Struktur Informationen beziehen sich auf alle GUI-Elemente der jeweiligen Klasse. Die Gesamtzahl der GUI-Elemente der Klasse wird im Attribut \"Insgesamt\", der Index der Komponente selbst im Attribut \"Index\" abgespeichert. Am Schluss befinden sich die Werte für die Geometrie. Diese erhalten im Wiedererkennungsalgorithmus die geringste Gewichtung. In seltenen Fällen kann es jedoch vorkommen, dass sie die einzigen Kennzeichen sind, die zur Identifizierung des GUI-Elements zur Verfügung stehen. Wenn Sie an weiteren Details zum genauen Ablauf bei der Wiedererkennung interessiert sind, können Sie diese im Kapitel Komponentenerkennung der technischen Referenz im Handbuch nachlesen. Um ein Gefühl für die Komponentenerkennung zu erhalten, können Sie ein bisschen mit den Attributwerten herumspielen, bis QF‑Test das GUI-Element nicht mehr findet oder sogar eine falsche Komponente auswählt. Sie werden feststellen, dass die Änderungen beträchtlich sein müssen, bevor QF‑Test ein falsches GUI-Element identifiziert. Das heißt, dass die Komponentenerkennung von QF‑Test sehr robust ist und sich bei neuen Versionen einer Anwendung ein erheblicher Anteil der Attribute eines GUI-Elements verändern kann, bevor die Komponentenerkennung fehlschlägt - selbst wenn das GUI-Element keinen Namen oder keine Id hat. Beim Klick auf einen Komponente Knoten markiert QF‑Test das erkannte GUI-Element mit einem dunkelblauen Rand. Löschen Sie den Wert CalculatedPrice aus dem Name-Attribut, da QF‑Test sonst die nachfolgenden Attribute nicht berücksichtigt. Ändern Sie das Merkmal-Attribut von Label: Endpreis auf Label: xxx. Klicken Sie auf den \"TextField\" Knoten um zu sehen, ob QF‑Test immer noch das Endpreis-Feld markiert. Setzen Sie das Merkmal-Attribut zurück auf Label: Endpreis, entweder über den entsprechenden Button in der Werkzeugleiste oder über das Tastaturkürzel Ctrl⁠+⁠Z. Ändern Sie den Wert von qfs:label in der Weitere-Merkmale-Tabelle von Endpreis auf Rabatt. Klicken Sie auf den 'TextField'-Knoten um zu sehen, ob QF‑Test immer noch das Endpreis-Feld markiert. Setzen Sie den Wert von qfs:label in der Weitere-Merkmale-Tabelle zurück auf Endpreis. Setzen Sie alle Struktur- und Geometrie-Attribute auf andere Werte und überprüfen Sie, ob QF‑Test immer noch das Endpreisfeld im GUI markiert. Ändern Sie das Merkmal-Attribut von Label: Endpreis auf Label: Rabatt. Nun markiert QF‑Test das Rabattfeld. Diese Übung ist nur eine kleine Spielerei mit der Komponentenerkennung. Konkrete Informationen, wie Sie bei Problemen mit der Komponentenerkennung umgehen, finden Sie in den oben genannten und weiteren Kapiteln im Handbuch.","hash":"fig_components_details","h4":"Abbildung 4.4: Details eines Komponente Knoten"},"123":{"id":123,"content":"Pro Tutorial","hash":"","h0":"SmartIDs - direkte Komponentenadressierung | QF‑Test Tutorial"},"124":{"id":124,"content":"Pro Tutorial","hash":"home-link","h0":"SmartIDs - direkte Komponentenadressierung | QF‑Test Tutorial"},"125":{"id":125,"content":"SmartIDs - direkte Komponentenadressierung Seit QF‑Test 7.0 bieten SmartIDs offiziell die Möglichkeit, Komponenten ohne Aufnahme eines Komponente Knoten zu referenzieren. Für gewisse Anwendungen kann dies die Verwaltung und Pflege der Komponenteninformationen stark vereinfachen. Auch auf die Editier- und Lesbarkeit der Tests können SmartIDs positiven Einfluss haben. Nicht zuletzt bietet dies die Möglichkeit, Tests auch ohne Aufnahmefunktion zu erstellen, zum Beispiel, wenn eine Komponente oder die gesamte Anwendung noch gar nicht vorhanden ist, man den Test aber bereits implementieren möchte (\"Test first\" Ansatz). Als Wiedererkennungskriterien stehen die Komponentenklasse, deren Name oder Beschriftung und der Index zur Verfügung. Die Werte sind die gleichen wie beim aufgenommenen Komponente Knoten. Zudem können auch Komponentenhierarchien abgebildet werden. Eine SmartID wird an Stelle der QF‑Test ID der Komponente verwendet. Ihr Kennzeichen ist die Raute # als erstes Zeichen. Anschließend kann der Name oder die Beschriftung der Komponente geschrieben werden, zum Beispiel: #btnOK, mit \"btnOK\" als Namen der Komponente oder #Vorname, mit \"Vorname\" als Beschriftung der Komponente. Der Nachteil dieser einfachen Form der SmartID kann die Performanz bei der Wiedergabe sein, da QF‑Test alle Komponenten nach diesen Kriterien durchsuchen muss. Aus diesem Grund ist es sinnvoll, die Klasse der Komponente mit anzugeben. Obige SmartIDs könnten dann so aussehen: #Button:btnOK #TextField:Vorname Aktuell ist die Aufnahme von SmartIDs nicht als Standard aktiviert, kann aber direkt über das Menü eingeschaltet werden. Nehmen Sie nun SmartIDs auf, indem Sie im Menü Aufnahme die Einstellung Aufnahme von SmartIDs anhaken. Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf ein Textfeld, z.B. das Eingabefeld für den Rabatt, Klicken Sie auf eine Tabellenzelle, z.B. das erste Modell. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Die aufgenommenen Mausklicks finden Sie im Bereich Extrasequenzen. Die SmartID für das Eingabefeld lautet #TextField:name=DiscountValue, da der Name bevorzugt für die SmartID verwendet wird, wenn Name und Beschriftung vorhanden sind. Der zweite Mausklick zeigt die Aufnahme der Tabelle als SmartID und daran anschließend einen Textindex für die Spalte, eingeleitet mit @ und einen numerischen Index für die Zeile, eingeleitet mit &, wie Sie dies im vorletzten Abschnitt kennengelernt haben: #Table:name=VehicleTable@Modell&0. Wenn Sie nicht weiter aktiv mit SmartIDs arbeiten möchten, können Sie diese in der Aufnahme-Option wieder deaktivieren. Sie können aber auch gerne weiter mit SmartIDs arbeiten. Dabei werden Sie bei Aufnahmen auch weitere Ausdrücke in SmartIDs finden. Einige wollen wir hier zeigen und die Hintergründe dazu erläutern. Zum Beispiel werden Sie bei einer Beschriftung, die mit einem Doppelpunkt endet, vor diesem Doppelpunkt einen Rückstrich sehen: #TextField:Vorname\\: Der Hintergrund ist, dass ein Doppelpunkt den davor stehenden Text als Komponentenklasse kennzeichnet. Daher müssen Doppelpunkte im Namen oder der Beschriftung mit einem Rückstrich geschützt werden. Dies gilt auch für die Sonderzeichen, die Indizes einleiten, also @, & und %. Vor Beschriftungen werden Sie einen Kennzeichner, hier left= sehen: #TextField:left=Vorname Hintergrund: Eine SmartID mit Angabe von Klasse und Namen der Komponente erreicht eine gleich gute Performanz bei der Wiedergabe wie die Verwendung von Komponente Knoten. Bei Beschriftungen sieht dies jedoch anders aus. Hier gibt es unterschiedlichste Möglichkeiten, was die beste Beschriftung für eine Komponente darstellt. QF‑Test sucht unter den für eine Komponente in Frage kommenden Beschriftungen auf Basis der Komponentenklasse, Lage und Abstand der Beschriftungen die Beste aus. Für die Performanz bei der Wiedergabe ist es daher hilfreich, wenn direkt angegeben wird, nach welcher Beschriftung gesucht werden soll. left= gibt hierbei an, dass die Beschriftung links der Komponente zu finden ist. Weitere Lagebezeichnungen in einer SmartID sind right=, top=, topleft= und bottom=. Wenn die Beschriftung der Text der Komponente ist, lautet der Kennzeichner text=, für den Tooltip tooltip=. Wenn Komponenten mit dem gleichen Namen oder der gleichen Beschriftung mehrmals auf einer Anzeige vorhanden sind, können Sie auf SmartIDs stoßen, bei denen zwei über das Verbindungszeichen @ zu einer vereinigt werden: #TitledPanel:Kundenadresse@#TextField:left=Vorname #TitledPanel:title=Rechnungsadresse@#TextField:left=Vorname Im Beispiel gibt es die Beschriftung \"Vorname\" sowohl in der Kachel \"Kundenadresse\" als auch in der Kachel \"Rechnungsadresse\". Über die geschachtelte SmartID kann die Eindeutigkeit hergestellt werden. Das zweite Beispiel ist etwas performanter wegen title= bei der SmartID bei der Kachel. Dafür ist die Lesbarkeit beim ersten etwas besser. Es hängt von der Anwendung ab, wie sehr auf Performanz geachtet werden muss. Bei Web-Anwendungen mit sehr vielen geladenen GUI-Elementen ist dies typischerweise relevant. Bei Java-Anwendungen kann man häufig der Lesbarkeit den Vorrang geben. Bei langen Beschriftungen kann ein regulärer Ausdruck zur Verkürzung verwendet werden: #%Dialog:Information.*@#Button:OK Das Prozentzeichen direkt nach der Raute gibt an, dass entweder der Name oder die Beschriftung als regulärer Ausdruck zu interpretieren ist. Im Beispiel wird der Titel verkürzt. Außerdem gilt die SmartID für jeden OK-Button, der in einem Dialog liegt, dessen Titel mit \"Information\" beginnt. Eine genauere Beschreibung regulärer Ausdrücke finden Sie im Handbuch - reguläre Ausdrücke. Weitere Informationen zu Komponenten und SmartIDs finden Sie im Handbuch - Komponenten.","hash":"sec_components_smartid","h0":"SmartIDs - direkte Komponentenadressierung"},"126":{"id":126,"content":"Pro Tutorial","hash":"","h0":"Benutzen des Debuggers (Java) | QF‑Test Tutorial"},"127":{"id":127,"content":"Pro Tutorial","hash":"home-link","h0":"Benutzen des Debuggers (Java) | QF‑Test Tutorial"},"128":{"id":128,"content":"Benutzen des Debuggers (Java) Dieses Kapitel ist auch als Video verfügbar unter 'Benutzen des Debuggers'. In diesem Kapitel lernen Sie, wie der in QF‑Test integrierte intuitive Debugger benutzt wird. Diejenigen unter Ihnen, die bereits Erfahrungen mit anderen IDEs, wie z.B. Eclipse haben, werden hier Ähnlichkeiten in Funktion und Nutzen des Debuggers feststellen. Wir werden uns mit den folgenden Debugger-Funktionen beschäftigen: Setzen eines Breakpoints mittels Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B). Testausführung pausieren mittels Pausetaste oder der Tastenkombination Alt⁠+⁠F12. Schrittweise Ausführung mittels \"Einzelschritt ausführen\" , \"Gesamten Knoten ausführen\" und \"Bis Knotenende ausführen\" . Knoten überspringen mittels \"Knoten überspringen\" und \"Aus Knoten herausspringen\" . Debug-Modus bei Fehler oder Exception aktivieren. Fehlerbehebung aus dem Protokoll heraus. Den aktuellen Fehler im Protokoll direkt anspringen über Strg⁠+⁠J. (Ins Protokoll springen in \"Fehlerbehebung aus dem Protokoll heraus\"). Anstatt über die Schaltflächen können die Befehle auch über die Menüzeile oder Tastaturkürzel abgesetzt werden. Die Kürzel stehen neben den Optionen in den QF‑Test Menüs, sofern vorhanden. Eine vollständige Übersicht der von QF‑Test verwendeten Tastaturkürzel finden Sie im Anhang Tastaturkürzel im Handbuch. Dort findet sich auch ein kleiner Helfer für die Funktionstastenbelegung von QF‑Test zum Befestigen an der Tastatur. Es gibt noch einige weitere Debugger-Funktionen wie \"Aktuellen Knoten finden\" (Aktuellen Knoten finden in \"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle\"), \"Ausführung hier fortsetzen\" über das Popup-Menü des entsprechenden Knotens (\"Ausführung hier fortsetzen\"), die \"Exception erneut werfen\" , die Tabelle der Variablendefinitionen (\"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle\"), auf die wir in späteren Kapiteln eingehen werden.","hash":"sec_Debugger","h1":"Benutzen des Debuggers (Java)"},"129":{"id":129,"content":"Pro Tutorial","hash":"","h0":"Setzen eines Breakpoints | QF‑Test Tutorial"},"130":{"id":130,"content":"Pro Tutorial","hash":"home-link","h0":"Setzen eines Breakpoints | QF‑Test Tutorial"},"131":{"id":131,"content":"Setzen eines Breakpoints Zunächst einmal soll der Debugger aktiviert werden. Dies kann auf mehrere Arten erfolgen, zum Beispiel durch das Setzen eines Haltepunktes (Breakpoint) vor Start des Testlaufs. Der Zweck eines Haltepunktes ist es, den Testlauf an einer Stelle, die man näher untersuchen möchte, zu unterbrechen. Sobald QF‑Test auf den Breakpoint trifft, wird die Testausführung pausiert und der Debugger-Modus aktiviert. Der Pauseknopf ist nun gedrückt. Selektieren Sie einen Knoten und drücken Sie Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B). Der Haltepunkt wird durch das Symbol kenntlich gemacht.","hash":"tut_breakpoints","h0":"Setzen eines Breakpoints"},"132":{"id":132,"content":"Abbildung 5.1: Breakpoint setzen Selektieren Sie den Testsuite Knoten und starten Sie den Testlauf über die Taste Enter.","hash":"fig_DebugSetBreakpoint","h4":"Abbildung 5.1: Breakpoint setzen"},"133":{"id":133,"content":"Abbildung 5.2: Testlauf starten Löschen Sie den Breakpoint wieder, indem Sie nochmals Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B) drücken.","hash":"fig_DebugStartTestRun","h4":"Abbildung 5.2: Testlauf starten"},"134":{"id":134,"content":"Abbildung 5.3: Breakpoint löschen Man kann einen Breakpoint nicht nur über das Tastaturkürzel Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B) sondern auch über den Menüpunkt »Debugger«-»Breakpoint an/aus« oder alternativ durch Rechtsklick auf den Knoten und Auswahl von »Breakpoint an/aus« im Popup-Menü setzen bzw. löschen. Für die weiteren Debugger-Funktionen werden wir hauptsächlich die jeweiligen Schaltflächen nennen, aber auch hier stehen die anderen Varianten zur Verfügung. Wieder sehen Sie den kleinen Pfeil, der diesmal anzeigt, welcher Knoten als nächster ausgeführt wird. Dieser Knoten wird aktueller Knoten genannt. Bei der Aktivierung des Debug-Modus navigiert QF‑Test zum aktuellen Knoten, falls dieser nicht bereits sichtbar ist, und selektiert diesen, d.h. die Zeile wird blau hinterlegt. Das Kommando »Debugger«-»Alle Breakpoints löschen« ist ebenfalls nützlich, wenn alle Haltepunkte in allen geöffneten Testsuiten gelöscht werden sollen. Es gibt keine Beschränkung für die Anzahl an Breakpoints, die Sie in Ihrer Testsuite setzen können. Haltepunkte werden beim Schließen der Testsuite nicht mit abgespeichert.","hash":"fig_DebugRemoveBreakpoint","h4":"Abbildung 5.3: Breakpoint löschen"},"135":{"id":135,"content":"Pro Tutorial","hash":"","h0":"Schrittweise Ausführung | QF‑Test Tutorial"},"136":{"id":136,"content":"Pro Tutorial","hash":"home-link","h0":"Schrittweise Ausführung | QF‑Test Tutorial"},"137":{"id":137,"content":"Schrittweise Ausführung Nun wollen wir die Testfälle schrittweise ausführen. Bitte experimentieren Sie ein wenig mit \"Einzelschritt ausführen\" , \"Gesamten Knoten ausführen\" und \"Bis Knotenende ausführen\" . Wie Sie sicher festgestellt haben werden, öffnet \"Einzelschritt ausführen\" einen Knoten mit Kindern und macht den ersten Kindknoten zum aktiven Knoten. Dies ist wie immer an der Pfeilmarkierung des Knotens erkennbar. Wenn Sie an dem Punkt weitergemacht haben, an dem die Ausführung der Testsuite im letzten Abschnitt pausiert war, d.h. vom Knoten \"Testfall: Erster\" aus, so würde nun der Testfall geöffnet werden:","hash":"tut_debug_steps","h0":"Schrittweise Ausführung"},"138":{"id":138,"content":"Abbildung 5.4: Einzelschritt ausführen Im Falle eines Blattknotens, d.h. eines Knotens, der keine Kinder hat, ist die Wirkung die gleiche wie die der folgenden Funktion. Mittels der Schaltfläche \"Gesamten Knoten ausführen\" wird ein Knoten inklusive aller Kindknoten ausgeführt. Der als nächstes auszuführende Knoten auf der gleichen Ebene wird dann der aktive und erhält den Pfeil.","hash":"fig_StepInExample","h4":"Abbildung 5.4: Einzelschritt ausführen"},"139":{"id":139,"content":"Abbildung 5.5: Gesamten Knoten ausführen \"Bis Knotenende ausführen\" führt die verbleibenden Geschwisterknoten aus und stoppt beim nächsten auszuführenden Knoten der übergeordneten Hierarchieebene.","hash":"fig_StepOverExample","h4":"Abbildung 5.5: Gesamten Knoten ausführen"},"140":{"id":140,"content":"Abbildung 5.6: Bis Knotenende ausführen Im Beispiel ist dies der Aufräumen Knoten. Wie bereits im ersten Kapitel Ein vollständiger Testlauf erläutert, haben Vorbereitung und Aufräumen Knoten die besondere Eigenschaft, dass sie vor und nach jedem Testfall ausgeführt werden, um so einen definierten Anfangszustand für jeden Testfall herzustellen. Dieses Verhalten tritt nur auf, wenn Sie die komplette Testsuite oder den Testfallsatz gestartet hatten und sich im Debug-Modus befinden. Wenn keine Testausführung aktiv war und Sie nur den Testfall selektiert hatten, so bewirkt die Funktion \"Gesamten Knoten ausführen\", dass der Testfall ausgeführt wird und dann der nächste Testfall selektiert wird. Führen Sie die Aufräumen und Vorbereitung Knoten aus, indem Sie mit Hilfe der Schaltfläche die gesamten Knoten ausführen und dann über den zweiten Testfall öffnen. Dies ist eine Vorbereitung für das nächste Kapitel, in dem es um das Überspringen von Knoten geht. Bitte beachten Sie bei der interaktiven Testerstellung bei Menüs und Comboboxen, dass diese häufig zuklappen, wenn die Applikation den Fokus verliert, was beim Wechsel in den Debug-Modus der Fall ist. In diesem Fall empfiehlt es sich, den Knoten, der ein Menü oder eine Combobox öffnet, und den Knoten, der die Auswahlaktion durchführt, gemeinsam auszuführen, also nicht zwischendurch in den Debug-Modus zu gehen. Dies kann man zum Beispiel dadurch erreichen, dass man nach dem Knoten, der die Auswahlaktion durchführt, einen Haltepunkt setzt und bei Erreichen des Knotens, der das Menü oder die Combobox öffnet, die Testausführung durch Lösen der Pausetaste freigibt.","hash":"fig_StepOutExample","h4":"Abbildung 5.6: Bis Knotenende ausführen"},"141":{"id":141,"content":"Pro Tutorial","hash":"","h0":"Knoten überspringen | QF‑Test Tutorial"},"142":{"id":142,"content":"Pro Tutorial","hash":"home-link","h0":"Knoten überspringen | QF‑Test Tutorial"},"143":{"id":143,"content":"Knoten überspringen Die \"Überspringen\" Funktionen erweitern die Fähigkeiten des Debuggers von QF‑Test in einer Weise, die über den Funktionsumfang von Standardprogrammierumgebungen hinausgeht. Wie der Name andeutet, erlauben die \"Überspringen\" Operationen einen oder mehrere Knoten während des Testlaufs auszulassen, d.h. weiter zu springen ohne diese auszuführen. Dies kann aus verschiedensten Gründen sinnvoll sein. Sei es um schnell an eine gewisse Position in Ihrem Testablauf zu gelangen oder um einen aktuell zu einem Fehler führenden Knoten zu überspringen. Am Schluss des letzten Abschnitts haben wir den ersten Testschritt im zweiten Testfall zum aktiven Knoten gemacht. Dies ist er Ausgangspunkt für unsere nächste Aktion:","hash":"tut_skip_steps","h0":"Knoten überspringen"},"144":{"id":144,"content":"Abbildung 5.7: Testausführung am ersten Knoten des zweiten Testfalls pausiert Drücken Sie nun die Schaltfläche \"Knoten überspringen\" . QF‑Test springt einfach über den aktiven Knoten ohne ihn oder seine Kindknoten auszuführen. Anschließend pausiert QF‑Test beim nächsten auszuführenden Knoten auf der gleichen Ebene.","hash":"fig_DebugSkipOverInitialState","h4":"Abbildung 5.7: Testausführung am ersten Knoten des zweiten Testfalls pausiert"},"145":{"id":145,"content":"Abbildung 5.8: \"Knoten überspringen\" Und zuletzt die Schaltfläche \"Aus Knoten herausspringen\" . Sie sehen sofort, dass QF‑Test aus dem Knoten, in dem Sie sich befinden, herausspringt ohne weitere Kindknoten auszuführen.","hash":"fig_DebugSkipOver","h4":"Abbildung 5.8: \"Knoten überspringen\""},"146":{"id":146,"content":"Abbildung 5.9: \"Aus Knoten herausspringen\" Noch eine Bemerkung zu \"Knoten überspringen\" und \"Aus Knoten herausspringen\": Benutzen Sie diese mit Vorsicht! Aus einer Sequenz herauszuspringen, bevor diese zu Ende gelaufen ist, kann dazu führen, dass Ihr SUT in einem Status belassen wird, auf dem andere Sequenzen oder Tests in der Suite nicht aufsetzen können.","hash":"fig_DebugSkipOut","h4":"Abbildung 5.9: \"Aus Knoten herausspringen\""},"147":{"id":147,"content":"Pro Tutorial","hash":"","h0":"Debug-Modus bei Fehler oder Exception aktivieren | QF‑Test Tutorial"},"148":{"id":148,"content":"Pro Tutorial","hash":"home-link","h0":"Debug-Modus bei Fehler oder Exception aktivieren | QF‑Test Tutorial"},"149":{"id":149,"content":"Debug-Modus bei Fehler oder Exception aktivieren Beim Debuggen eines Tests ist es oft hilfreich, wenn die Testausführung genau dann stoppt und in den Debug-Modus gewechselt wird, wenn ein Fehler, eine Exception oder manchmal auch nur eine Warnung auftritt. Mittels dieser Technik werden wir in diesem Abschnitt und dem nächsten den zweiten Testfall debuggen. Bitte öffnen Sie das Debugger-Menü und ändern Sie die Standardeinstellungen wie folgt: Klicken Sie auf den Menüpunkt »Debugger«-»Debugger aktivieren« um ihn zu aktivieren. Klicken Sie auf den Untermenüpunkt »Debugger«-»Optionen«-»Unterbrechen bei Fehler« um auch diese Funktion zu aktivieren. Wenn Sie nun das Debugger-Menü und das Optionen-Untermenü wieder öffnen sollte es wie folgt aussehen:","hash":"tut_debug_start","h0":"Debug-Modus bei Fehler oder Exception aktivieren"},"150":{"id":150,"content":"Abbildung 5.10: Debugger-Optionen: Test bei Fehler anhalten Wir müssen die Debugger-Optionen ändern, da sonst der Test einfach durchlaufen würde, analog zu den vorherigen Beispielen aus Kapitel eins und zwei. Selektieren Sie den Testsuite Knoten und starten Sie anschließend den Test mittels \"Wiedergabe starten\" . QF‑Test hält bei dem fehlerhaften Knoten an und wechselt in den Debug-Modus:","hash":"fig_debugger_stops_at_error","h4":"Abbildung 5.10: Debugger-Optionen: Test bei Fehler anhalten"},"151":{"id":151,"content":"Abbildung 5.11: QF‑Test pausiert bei Fehler Der Knoten, der den Fehler verursacht hat, wird durch ein rotes Quadrat markiert. Außerdem erscheint ein Fehlerdialog, der uns Näheres zur Fehlerursache mitteilt. Über diesen wechseln wir in das Protokoll, das wie so oft der Schlüssel zur Fehlerbehebung ist.","hash":"fig_debugger_stopped_by_error","h4":"Abbildung 5.11: QF‑Test pausiert bei Fehler"},"152":{"id":152,"content":"Abbildung 5.12: Fehlermeldung Klicken Sie auf die Schaltfläche In Protokoll springen der Fehlermeldung.","hash":"debug_error_dialog","h4":"Abbildung 5.12: Fehlermeldung"},"153":{"id":153,"content":"Pro Tutorial","hash":"","h0":"Fehlerbehebung aus dem Protokoll heraus | QF‑Test Tutorial"},"154":{"id":154,"content":"Pro Tutorial","hash":"home-link","h0":"Fehlerbehebung aus dem Protokoll heraus | QF‑Test Tutorial"},"155":{"id":155,"content":"Fehlerbehebung aus dem Protokoll heraus Über die Schaltfläche In Protokoll springen (siehe Fehlermeldung in Abbildung \"Fehlermeldung\") wird das Protokoll direkt bei dem entsprechenden Knoten geöffnet. Neben der eigentlichen Fehlermeldung wurden etliche weitere Informationen zur Testumgebung zum Zeitpunkt des Fehlers protokolliert. Neben Bildschirmabbildern zum Fehlerzeitpunkt enthält das Protokoll unter dem Knoten, der den Fehler verursachte, eine Liste der gebundenen Variablen (Stacktrace). Auf die Nützlichkeit des Stacktrace werden wir zu einem späteren Zeitpunkt eingehen (Die Variablendefinitionen-Tabelle). Beim vorliegenden Fehler wird der falsche Wert im Check Text Knoten der Testsuite erwartet. Zur Fehlerbehebung muss dieser durch den tatsächlich angezeigten ersetzt werden. Dies geht bei einem Check mit festem Wert, um den es sich hier handelt, am einfachsten, indem Sie auf den rot umrandeten Fehler-Knoten \"Fehlgeschlagen: Check Text: default ...\" rechtsklicken und im Kontextmenü »Check-Knoten mit erhaltenen Daten aktualisieren« auswählen.","hash":"tut_ResolveRunTimeErrors","h0":"Fehlerbehebung aus dem Protokoll heraus"},"156":{"id":156,"content":"Abbildung 5.13: Check-Knoten mit erhaltenen Daten aktualisieren QF‑Test navigiert zum betroffenen Check Text Knoten in der Testsuite und aktualisiert den Wert des Attributs Text anhand der aus dem SUT ausgelesenen Daten.","hash":"fig_DebugUpdateCheckNode","h4":"Abbildung 5.13: Check-Knoten mit erhaltenen Daten aktualisieren"},"157":{"id":157,"content":"Abbildung 5.14: Korrigierter Check-Knoten Der Knoten enthält nun zwar den korrekten Wert, ist aber immer noch rot umrandet, da er noch nicht wieder ausgeführt wurde. Dies wollen wir nun tun. führen Sie den Test also fort, indem Sie auf den Pauseknopf drücken und so die Pause lösen. QF‑Test führt den Rest der Testsuite aus. In unserem Fall sind das der Check Text und der Aufräumen Knoten. Anschließend informiert Sie QF‑Test, dass ein Fehler aufgetreten ist. Diesen haben wir allerdings bereits während des Testlaufs behoben.","hash":"fig_DebugCorrectedCheckNode","h4":"Abbildung 5.14: Korrigierter Check-Knoten"},"158":{"id":158,"content":"Ins Protokoll springen: Falls Sie das Protokoll an der Stelle, an der sich die Testausführung gerade befindet, öffnen wollen, brauchen Sie aus dem Debug-Modus heraus nur den Menüpunkt »Debugger«-»In Protokoll springen« anzuklicken oder das Tastaturkürzel Strg⁠+⁠J zu drücken. Wenn Sie einfach nur das Protokoll öffnen wollen, ohne an die aktuelle Stelle zu springen, steht Ihnen Strg⁠+⁠L zur Verfügung, was auch nach Ende des Testlaufs weiterhin funktioniert.","hash":"tut_JumpToRunLog tut_JumpToRunLog","h4":"Abbildung 5.14: Korrigierter Check-Knoten"},"159":{"id":159,"content":"Pro Tutorial","hash":"","h0":"Testausführung pausieren | QF‑Test Tutorial"},"160":{"id":160,"content":"Pro Tutorial","hash":"home-link","h0":"Testausführung pausieren | QF‑Test Tutorial"},"161":{"id":161,"content":"Testausführung pausieren Wenn ein Test gerade ausgeführt wird und Sie den Debug-Modus aktivieren wollen, so können Sie entweder schnell einen Breakpoint auf einen noch nicht ausgeführten Knoten setzen oder Sie drücken einfach die Schaltfläche \"Pause\" um den Debug-Modus sofort zu aktivieren. Um die Ausführung fortzusetzen lösen Sie den Pauseknopf , völlig unabhängig von der Art und Weise wie der Debug-Modus aktiviert wurde. Wir wollen die vorhandenen Testfälle im Verlauf dieses Tutorials weiter verwenden. Allerdings wurde der Fehler in dem zweiten Testfall jetzt behoben. Insofern macht es Sinn \"(mit Fehler)\" aus dem Namen des zweiten Testfalls zu löschen, genauso wie \"(verursacht Fehler)\" aus dem Namen des Testschritts. Es gibt manchmal Situationen, in denen das SUT ständig den Fokus für sich beansprucht. Dann kann es schwierig sein, das QF‑Test Fenster lange genug im Vordergrund zu halten, um die Pausetaste drücken zu können. In einem solchen Fall steht Ihnen die \"Keine Panik\"-Taste Alt⁠+⁠F12 zur Verfügung. Sie unterbricht alle laufenden Tests sofort. Zur Weiterführung des Tests können Sie diese Tastenkombination erneut drücken.","hash":"tut_pause_execution","h0":"Testausführung pausieren"},"162":{"id":162,"content":"Pro Tutorial","hash":"","h0":"Variablen und Prozedurparameter (Java) | QF‑Test Tutorial"},"163":{"id":163,"content":"Pro Tutorial","hash":"home-link","h0":"Variablen und Prozedurparameter (Java) | QF‑Test Tutorial"},"164":{"id":164,"content":"Variablen und Prozedurparameter (Java) In diesem Kapitel lernen Sie, wie man eine Prozedur einsetzt um die gleichen Schritte auf unterschiedlichen Daten auszuführen. Außerdem sehen Sie, wie man Variablen einsetzt. Ebenso wird die Fehleranalyse in Bezug auf Variablen behandelt. Dieses Kapitel ist auch als Video verfügbar unter 'Variablen und Prozedurparameter'.","hash":"sec_variablestack","h1":"Variablen und Prozedurparameter (Java)"},"165":{"id":165,"content":"Pro Tutorial","hash":"","h0":"Prozedur mit Variable | QF‑Test Tutorial"},"166":{"id":166,"content":"Pro Tutorial","hash":"home-link","h0":"Prozedur mit Variable | QF‑Test Tutorial"},"167":{"id":167,"content":"Prozedur mit Variable Sehen Sie sich den letzten Testschritt \"Endpreis prüfen\" in unseren beiden Testfällen an.","hash":"sec_ProcedureWithVariable","h0":"Prozedur mit Variable"},"168":{"id":168,"content":"Abbildung 6.1: Zwei fast gleiche Testschritte Es wird der gleiche Schritt ausgeführt, jedoch mit unterschiedlichen Daten. Auch wenn es sich nur um einen Schritt handelt, macht es Sinn eine Prozedur daraus zu machen. Vielleicht kommen wir später auf die Idee, die hartkodierten Werte 30.049,00 € und 26.100,00 € in ein anderes Format zu bringen, so dass der Check auf das Feld \"Endpreis\" auch für andere Währungen funktioniert. Diesen Algorithmus zweimal zu implementieren wäre auf jeden Fall nicht sinnvoll. Selektieren Sie den \"Check text\" Knoten im ersten Testfall. Wählen Sie den Menüpunkt »Operationen«-»Knoten einpacken in«-»Sequenz« aus oder verwenden Sie das Tastaturkürzel Strg⁠+⁠Umschalt⁠+⁠S um ihn in eine Sequenz einzupacken. Nennen Sie die Sequenz 'prüfeEndpreis'. Dieser Name entspricht der Java-Konvention die Wörter zusammenzuschreiben. Andererseits erlaubt QF‑Test auch Leerzeichen in Prozedurnamen, so dass Sie der Java-Konvention nicht zu folgen brauchen. Drücken Sie Strg⁠+⁠Umschalt⁠+⁠P um auf kürzestem Weg den Sequenzknoten in eine Prozedur zu konvertieren (wie aus dem letzten Kapitel bekannt). Wie Sie sehen, wurde die Sequenz durch einen Prozeduraufruf von \"prüfeEndpreis\" ersetzt. Klicken Sie doppelt auf den Prozeduraufruf, um zur Prozedur im Prozeduren Knoten zu springen. Öffnen Sie den neu erstellten Prozedurknoten um den Inhalt zu sehen.","hash":"fig_params1","h4":"Abbildung 6.1: Zwei fast gleiche Testschritte"},"169":{"id":169,"content":"Abbildung 6.2: Prozedur mit hartkodiertem Wert Wie erwartet befindet sich der \"Check text\" Knoten in der Prozedur. Er ist jedoch nur für einen einzigen Preis gültig, nämlich 30.049,00 €. Da wir die gleiche Prozedur auch für den zweiten Testfall verwenden möchten, müssen wir den Preis durch eine Variable ersetzen. Der Wert dieser Variable sollte dann beim Prozeduraufruf mit übergeben werden. Im nächsten Beispiel werden wir einen Parameter mit Standardwert im Prozedurknoten einfügen. Standardwerte werden häufig verwendet, wenn der entsprechende Parameter bei den meisten Prozeduraufrufen den Standardwert erhalten würde. Dann braucht man den Standardwert nicht jedes Mal zu spezifizieren, sondern kann auf den im Prozedurknoten definierten Wert zurückgreifen. Obwohl das auf den Preis als Parameter nicht zutrifft, können wir ihn gerade deshalb verwenden um zu zeigen, wie ein Standardwert funktioniert und wie man ihn bei Bedarf mit einem anderen Wert überschreiben kann. Als erstes fügen wir also eine Variable mit Standardwert ein: Selektieren Sie die Prozedur 'prüfeEndpreis' Drücken Sie den \"Zeile einfügen\" Knopf über der Tabelle \"Standardwerte für Parameter\". Tragen Sie preis als Namen des Parameter ein. Tragen Sie 30.049,00 € als Wert ein.","hash":"fig_procedure_hardcoded","h4":"Abbildung 6.2: Prozedur mit hartkodiertem Wert"},"170":{"id":170,"content":"Abbildung 6.3: Die Details eines Prozedurknotens Im nächsten Schritt ersetzen wir den Wert des Text Attributs des Check Text Knotens durch eine Referenz auf die Variable.","hash":"fig_parameter_default_values_table","h4":"Abbildung 6.3: Die Details eines Prozedurknotens"},"171":{"id":171,"content":"Variablensyntax: Wenn Sie mit Variablen arbeiten, ist es wichtig, sich bewusst zu sein, dass Sie an bestimmten Stellen QF‑Test mitteilen wie, eine Variable heißt und an anderen, dass QF‑Test auf den Wert einer Variablen zugreifen soll. In obigem Beispiel wird QF‑Test in der Namensspalte für die Standardwerte der Variablenname mitgeteilt. In diesem Fall brauchten Sie nur preis einzutragen. Im Text Attribute des Check Text Knotens soll der Wert der Variablen verwendet werden. Bei QF‑Test geschieht dies dadurch, dass Sie den Variablenname in $() setzen, hier $(preis). Falls Sie den Variablennamen nicht in $() setzen, würde QF‑Test den Preis mit der Zeichenfolge preis vergleichen. Selektieren Sie den Check Text Knoten in der Prozedur \"prüfeEndpreis\". Tragen Sie $(preis) im Text Attribut der Check Text Knotendetails ein.","hash":"tut_VariableSyntax","h4":"Abbildung 6.3: Die Details eines Prozedurknotens"},"172":{"id":172,"content":"Abbildung 6.4: 'Check text'-Knoten Führen Sie den ersten Testfall aus. Der Testfall sollte fehlerfrei durchlaufen.","hash":"fig_ProcedureAddVariable","h4":"Abbildung 6.4: 'Check text'-Knoten"},"173":{"id":173,"content":"Pro Tutorial","hash":"","h0":"Die Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"174":{"id":174,"content":"Pro Tutorial","hash":"home-link","h0":"Die Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"175":{"id":175,"content":"Die Variablendefinitionen-Tabelle Im nächsten Schritt fügen wir einen Prozeduraufruf im zweiten Testfall ein. Ersetzen Sie den Check Text Knoten des zweiten Testfalls durch einen Prozeduraufruf von \"prüfeEndPreis\". Sie können einfach den Prozeduraufruf aus dem ersten Testfall kopieren oder den Prozeduraufruf wie oben beschrieben einfügen.","hash":"tut_variable_stack","h0":"Die Variablendefinitionen-Tabelle"},"176":{"id":176,"content":"Abbildung 6.5: Prozeduraufruf von \"prüfeEndPreis\" in der zweiten Prozedur Wenn im Prozeduraufruf bereits der Preis mit Standardwert eingetragen ist, rührt das daher, dass der Prozeduraufruf mit Hilfe der Prozedur selbst erzeugt wurde. Entweder durch Kopieren der Prozedur oder durch eine Drag-and-Drop Aktion unter Verwendung des Prozedurknoten oder über direktes Einfügen der Prozedur wie weiter oben erläutert. Aktuell geht es jedoch um den Standardwert. Daher bitten wir Sie, den evtl. vorhandenen Preis-Parameter zu löschen, wenn Sie dem Tutorial Schritt für Schritt folgen wollen. Dazu klicken Sie das rote X über der Variablendefinitionen-Tabelle. Überprüfen Sie, ob der Debugger so eingestellt ist, dass er bei Fehlern unterbricht (siehe Debugger-Optionen: Test bei Fehler anhalten). Selektieren Sie den Knoten \"Testfall: Zweiter\". Führen Sie ihn aus, entweder über den Knopf oder durch Drücken der Eingabe Taste. Eine Fehlermeldung zeigt an, dass ein anderer als der angezeigte Preis erwartet wurde. Was lief schief? Lassen Sie uns nach dem Fehler forschen. Üblicherweise würden wir ins Protokoll schauen, aber es gibt noch eine andere wichtige Informationsquelle. Klicken Sie OK, um die Fehlermeldung zu schließen. Im Debugging-Modus sehen Sie rechts unten im QF‑Test Fenster eine Knotenliste mit Variablen, die von diesen gebunden sind. Eventuell müssen Sie die Variablendefinitionen-Tabelle vergrößern, um alle Einträge sehen zu können.","hash":"fig_AddProcedureCallToSecondTestcase","h4":"Abbildung 6.5: Prozeduraufruf von \"prüfeEndPreis\" in der zweiten Prozedur"},"177":{"id":177,"content":"Abbildung 6.6: Variablendefinitionen Die Variablendefinitionen-Tabelle ist beim Debuggen sehr hilfreich, da sie die aktuellen Werte der Variablen anzeigt. Sie unterstützt beim Arbeiten mit Prozeduren als auch beim Verständnis, wie QF‑Test den richtigen Variablenwert ermittelt. QF‑Test geht die Variablendefinitionen-Tabelle immer von oben nach unten durch. Sie sehen, dass in den ersten Zeilen keine Variablen gebunden sind. Auf der Ebene \"Globale Variablen\" ist eine Variable gebunden und auf dem Sekundärstapel für \"Prozedur: prüfeEndpreis\" eine weitere. Die globale Variable wird für die Verbindung zur SUT Applikation verwendet und wurde vor dem Anwendungsstart gesetzt. (vgl. Starten der Anwendung). Die andere Variable interessiert uns im Moment mehr - sie hat jedoch den falschen Wert. Dieser Wert auf dem Sekundärstapel ist der Standardwert, da er dann verwendet wird, wenn nirgendwo sonst einer Variablen mit dem gleichen Namen ein Wert zugewiesen wurde. Um es richtig zu machen, müssen wir den korrekten Wert beim Prozeduraufruf an die Prozedur übergeben. Wieder gibt es mehrere Arten, dies zu tun. Ein Weg wäre, eine neue Zeile in der Variablendefinitionen-Tabelle in den Details des Prozeduraufrufs einzufügen, ähnlich wie beim Prozedurknoten im vorigen Abschnitt. Wenn es jedoch bereits mehrere Prozeduraufrufe gibt, ist folgendes einfacher: Beenden Sie die laufende Testausführung mittels . Führen Sie einen Rechtsklick auf den Prozedurknoten aus und wählen »Weitere Knotenoperationen«-»Parameter von Referenzen anpassen« im Popup-Menü.","hash":"fig_VariableBindingsTable1","h4":"Abbildung 6.6: Variablendefinitionen"},"178":{"id":178,"content":"Führen Sie einen Rechtsklick auf den Prozedurknoten aus und wählen »Weitere Knotenoperationen«-»Parameter von Referenzen anpassen« im Popup-Menü. Abbildung 6.7: Popup-Menü für \"Parameter von Referenzen anpassen\" Prüfen Sie im folgenden Dialog, dass ein Häkchen bei »Fehlende Parameter beim Aufrufer hinzufügen« gesetzt ist, und bestätigen Sie mit OK. Im Prozeduraufruf erzeugt QF‑Test für jeden Standardwert eine Zeile in der Variablen Definitionen Tabelle. In unserem Fall wurde eine Zeile für den Parameter mit dem Namen preis und dem Wert 30.049,00 € hinzugefügt. Auch damit wird es im zweiten Testfall noch nicht funktionieren, auch wenn der Wert direkt übergeben wird, weil es sich immer noch um den Standardwert handelt, der hier nicht korrekt ist. Bitte verändern Sie den Wert noch nicht, damit wir Ihnen mittels des entstehenden Fehlers eine weitere Möglichkeit des Debuggens zeigen können. Schließen Sie den Dialog \"Angepasste Knoten\", den QF‑Test anzeigt, um Sie über die vervollständigten Knoten zu informieren.","hash":"fig_CompleteParameters","h4":"Abbildung 6.6: Variablendefinitionen"},"179":{"id":179,"content":"Pro Tutorial","hash":"","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"180":{"id":180,"content":"Pro Tutorial","hash":"home-link","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"181":{"id":181,"content":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle Als nächstes wollen wir die Variablendefinitionen-Tabelle unter die Lupe nehmen und herausfinden, wie man sie für Debugging-Zwecke einsetzen kann. Daher belassen Sie bitte den fehlerhaften Wert, der im vorigen Abschnitt im Prozeduraufruf eingefügt wurde. Dazu soll die Ausführung des Testfalls beim Prozeduraufruf unterbrochen werden um dann mittels Einzelschritten in die Prozedur zu gehen. Dabei werden wir uns ansehen, was in der Variablendefinitionen-Tabelle passiert. Anschließend wollen wir direkt aus der Variablendefinitionen-Tabelle zum fehlerhaften Prozeduraufruf springen und dort den Parameterwert korrigieren. Setzen Sie einen Breakpoint bei \"Prozeduraufruf: prüfeEndpreis\" im zweiten Testfall. Führen Sie den zweiten Testfall aus. Wenn QF‑Test am Breakpoint anhält, führen Sie zwei Einzelschritte in die Prozedur mittels aus und beobachten dabei die Variablendefinitionen-Tabelle.","hash":"tut_variable_stack_debugging","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle"},"182":{"id":182,"content":"Abbildung 6.8: Variablendefinitionen-Tabelle zeigt den falschen Wert Wenn Sie mit Einzelschritten in die Prozedur gehen, wird beim ersten eine Zeile für \"Prozeduraufruf: prüfeEndpreis\" oben in der Tabelle erzeugt und beim zweiten die Zeile \"Prozedur: prüfeEndpreis\". Jetzt gibt es die Variable preis auf zwei verschiedenen Ebenen in der Variablen Definitionen Tabelle: in der Zeile für \"Prozeduraufruf: prüfeEndpreis\" und in der Zeile \"Prozedur: prüfeEndpreis\" auf dem Sekundärstapel, wobei keiner der beiden Variablenwerte der richtige ist. In QF‑Test können Sie interaktiv die Werte von Variablen in der Variablendefinitionen-Tabelle verändern, wenn Sie sich im Debugging-Modus befinden. Sie können sogar neue Variablen hinzufügen oder vorhandene löschen. Damit können Sie arbeiten, solange sich die Variablen auf dem Variablenstapel befinden, in unserem Fall solange wie die Prozedur ausgeführt wird. Änderungen des aktuellen Variablenwertes in der Variablendefinitionen-Tabelle bewirken keine Anpassung des im Prozeduraufrufknoten eingetragenen Parameterwerts. Der Wert muss explizit im Prozeduraufruf geändert werden. Die schnellste Methode um zum Prozeduraufruf zu gelangen ist ein Doppelklick auf die Prozeduraufrufzeile (zweite Zeile) in der Variablendefinitionen-Tabelle. Diese Methode ist besonders hilfreich, wenn Sie umfangreiche Testsuiten debuggen und der Knoten, zu dem Sie springen wollen, nicht im Testsuite-Fenster angezeigt wird. Statt eines Doppelklicks können Sie auch einen Rechtsklick auf die Zeile ausführen und den Menüpunkt »Zu Knoten in Testsuite springen« wählen. Führen Sie einen Doppelklick auf die zweite Zeile mit dem Prozeduraufruf in der Variablendefinitionen-Tabelle aus. Setzen Sie den Parameterwert auf den richtigen Wert, d.h. 26.100,00 €. Umgekehrt wird auch der aktuelle Wert in der Variablendefinitionen-Tabelle dadurch nicht verändert. Um dies zu erreichen müssen wir den Prozeduraufruf erneut ausführen. Allerdings ist die Testausführung über diesen Punkt bereits hinaus. Daher wollen wir hier eine weitere nützliche Funktion des Debuggers zeigen, mit der man den QF‑Test anweisen kann, den nächsten auszuführenden Knoten zu verändern. Dazu selektieren Sie den entsprechenden Knoten und wählen den Menüpunkt »Ausführung hier fortsetzen« oder verwenden das Tastaturkürzel Strg⁠+⁠,. Also, um den neu gesetzten Wert auszuprobieren: Führen Sie einen Rechtsklick auf den Knoten \"Prozeduraufruf: prüfeEndpreis\" in der zweiten Prozedur aus. Wählen Sie \"Ausführung hier fortsetzen\" im Popup-Menü.","hash":"fig_VariableStack3","h4":"Abbildung 6.8: Variablendefinitionen-Tabelle zeigt den falschen Wert"},"183":{"id":183,"content":"Abbildung 6.9: Ausführung hier fortsetzen In der Variablendefinitionen-Tabelle sind die zwei obersten Zeilen verschwunden. Der Grund ist, dass Sie die Prozedur verlassen haben (wenn auch \"rückwärts\") und dass dadurch der Prozeduraufruf mit den daran gebundenen Variablen vom Aufrufstack genommen wurde. Lösen Sie den Pauseknopf . Nun sollte kein Fehler mehr auftauchen. Da die Variablendefinitionen-Tabelle äußerst hilfreich ist, wenn Sie nach fehlerhaften Variablenwerten fahnden, wird eine Kopie davon auch unter dem Knoten \"Stacktrace\" im Protokoll abgespeichert, in dem die Variablenwerte genau zum Zeitpunkt des Fehlers zu sehen sind.","hash":"fig_ProcedureContinueExecFromHere","h4":"Abbildung 6.9: Ausführung hier fortsetzen"},"184":{"id":184,"content":"Aktuellen Knoten finden: Manchmal entfernt man sich beim Debuggen ziemlich weit vom aktuellen Knoten und möchte anschließend wieder zu diesem Knoten zurückfinden. Das geht am einfachsten indem man in der Toolbar \"Aktuellen Knoten finden\" drückt oder den Menüpunkt »Debugger«-»Aktuellen Knoten finden« wählt.","hash":"locate_current_node locate_current_node","h4":"Abbildung 6.9: Ausführung hier fortsetzen"},"185":{"id":185,"content":"Pro Tutorial","hash":"","h0":"Variablen setzen | QF‑Test Tutorial"},"186":{"id":186,"content":"Pro Tutorial","hash":"home-link","h0":"Variablen setzen | QF‑Test Tutorial"},"187":{"id":187,"content":"Variablen setzen Zusätzlich zu den oben beschriebenen Wegen können die Variablen auch wie folgt gesetzt werden: Mittels Variable setzen Knoten, als Rückgabewert einer Prozedur, als Ergebnis eines QF‑Test Knotens wie Text auslesen, Geometrie auslesen, Index auslesen und Check, in der 'Variablendefinitionen' Tabelle von Testsuite, Testfall, Testschritt, Sequenz und weiteren Knoten wie dem If oder Schleife Knoten, über Kommandozeilenparameter. Informationen dazu, an welcher Stelle eine Variable am besten definiert wird, finden Sie im nächsten Abschnitt. Ein Variable setzen Knoten kann über den Menüpunkt »Einfügen«-»Diverse Knoten«-»Variable setzen« eingefügt werden. In den Knotendetails können Sie angeben, ob es sich um eine lokale (Häkchen bei \"Lokale Variable\" setzen) oder eine globale Variable handeln soll. Die folgende Abbildung zeigt die Details eines Variable setzen Knotens, den Sie als ersten Knoten im Vorbereitung Knoten finden. Es wird eine Variable mit dem Namen client definiert. Dass es sich um eine globale Variable handelt, erkennen Sie daran, dass das Attribut 'Lokale Variable' nicht gesetzt ist.","hash":"tut_setting_variables","h0":"Variablen setzen"},"188":{"id":188,"content":"Abbildung 6.10: Details des Variable setzen Knoten Wenn eine Variable mit dem Rückgabewert einer Prozedur gesetzt werden soll, geben Sie den Variablennamen im Attribut \"Variable für Rückgabewert\" des Prozeduraufrufs an. In der Prozedur selbst müssen Sie als letzten auszuführenden Knoten einen Return Knoten einfügen, der den betreffenden Wert zurückgibt. Die Prozedur in der folgenden Abbildung liest den Rabattwert aus dem SUT und gibt den Wert an den aufrufenden Testfall zurück. Dort heißt die empfangende Variable Rabatt und ist als lokale Variable deklariert. Dieses Beispiel ist nicht in der Übungstestsuite enthalten.","hash":"fig_DetailsSetVariable","h4":"Abbildung 6.10: Details des Variable setzen Knoten"},"189":{"id":189,"content":"Abbildung 6.11: Prozedur mit Rückgabewert Der Text auslesen Knoten in der obigen Abbildung ist einer der QF‑Test Knoten, die direkt den Wert einer Variablen setzen. Dabei wird der Variablenname in dem entsprechend benannten Attribut eingetragen. Sie haben wiederum die Wahl, ob es eine lokale oder globale Variable werden soll. Es gibt eine Reihe von Knoten, die eine Variablendefinitionen-Tabelle besitzen. Dort können Sie lokale Variablen setzen. Falls sich der betreffende Knoten in einer Prozedur befindet, wird die Variable als lokale Variable an die Prozedur gebunden, ansonsten als lokale Variable an den Testfall. Variablen, die mittels dieser Tabelle an den Testsuite Knoten gebunden sind, können von allen Knoten der Testsuite referenziert werden. Alle Knoten, an die Variablen gebunden werden können, werden im Debugger-Modus im Variablen Definitionen Fenster rechts unten angezeigt, wenn sie gerade ausgeführt werden. Variablen können auch über die Kommandozeile spezifiziert werden. Hierzu verwenden Sie den Kommandozeilenparameter -variable. Beispiel: qftest -batch -variable \"browser\"=\"ie\" test.qft. Weitere Informationen hierzu finden Sie im Handbuch, Kapitel 'Kommandozeilenargumente'.","hash":"fig_DetailsCallProcedure","h4":"Abbildung 6.11: Prozedur mit Rückgabewert"},"190":{"id":190,"content":"Pro Tutorial","hash":"","h0":"Ebenen für Variablendefinitionen | QF‑Test Tutorial"},"191":{"id":191,"content":"Pro Tutorial","hash":"home-link","h0":"Ebenen für Variablendefinitionen | QF‑Test Tutorial"},"192":{"id":192,"content":"Ebenen für Variablendefinitionen Dieser Abschnitt gibt Antworten auf die Frage, auf welcher Ebene eine Variable definiert werden sollte. Wenn Sie diese Frage momentan nicht interessiert, können Sie direkt zum nächsten Kapitel springen. Variablen können auf unterschiedlichen Ebenen gebunden werden: Im Testsuite Knoten, in Testfällen und Prozeduren als Standard- oder als lokale Variablen, als Parameter in einem Prozeduraufruf, als globale Variable und als Kommandozeilenparameter. Die Ebene, auf welcher eine Variable am sinnvollsten definiert wird, hängt vom Verwendungszweck der Variablen ab: Prozedurparameter Übergeben Sie einen Wert als Parameter an eine Prozedur, wenn die gleiche Prozedur mehr als einmal und mit unterschiedlichen Werten ausgeführt werden soll. Prozedurparameter werden in der Variable Definitionen Tabelle eines Prozeduraufruf Knoten angegeben. Lokale Variablen in einer Prozedur Lokale Variablen werden innerhalb der Prozedur definiert und sind nur dort gültig. Wenn die Prozedur beendet wird, werden sie gelöscht. Verwenden Sie eine lokale Variable, wenn diese nicht außerhalb der Prozedur benötigt wird. Sie sind das Mittel der Wahl für Zwischenergebnisse. Lokale Variablen in einem Testfall In einem Testfall können lokale Variable entweder während der Durchführung des Testfall angelegt werden oder über die entsprechende Tabelle in den Details des Testfall Knotens. Wenn Sie in einem Testfall mehrfach den gleichen Wert verwenden, ist es sinnvoll, diesen einmalig einer Variablen zuzuweisen und dann die Variable zu verwenden. Dies erhöht die Wartbarkeit. Auch für Zwischenergebnisse sollte man lokale Variablen verwenden. Globale Variablen Wenn globale Variablen einmal erstellt wurden, existieren sie, bis sie entweder explizit gelöscht werden oder bis QF‑Test beendet wird. Auch Stopps und die erneute Ausführung von Tests \"überleben\" sie. Verwenden Sie sie für Werte, die in mehreren Testfällen genutzt werden. Ein Beispiel ist die Variable client, die im Vorbereitung Knoten beim Start der Applikation angelegt wird. Um sie wieder loszuwerden, wählen Sie den Menüpunkt »Wiedergabe«-»Globale Variablen löschen«. Auch beim Beenden von QF‑Test werden sie gelöscht. Kommandozeilenparameter Variablen, die über Kommandozeile gesetzt werden, sind im Batch-Modus sinnvoll, wenn Sie mehrere Batch-Läufe mit unterschiedlichen Werten durchführen wollen. Kommandozeilenparameter gelten während der gesamten Laufzeit des Batch-Laufs. Ein typisches Beispiel ist die variablengesteuerte Ausführung auf verschiedenen Browsern. Variablen können über den Kommandozeilen-Parameter -variable spezifiziert (vgl. Kapitel 'Kommandozeilenargumente' im Handbuch). Testsuite-Variablen Testsuite-Variablen können von allen Testfällen verwendet werden. Ihr Verwendungszweck entspricht dem von globalen Variablen, nur dass sie im Batch-Modus durch Variablen in der Kommandozeile überschrieben werden können. Standardwerte (Sekundärstapel) Sie können Standardwerte für die Variablen von Prozeduren, Testfällen und Testfallsätzen definieren. Diese kommen zum Zug, wenn keine Variable mit dem gleichen Namen auf einer höheren Ebene definiert wurde.","hash":"tut_variable_levels","h0":"Ebenen für Variablendefinitionen"},"193":{"id":193,"content":"Pro Tutorial","hash":"","h0":"Die Standardbibliothek (Java) | QF‑Test Tutorial"},"194":{"id":194,"content":"Pro Tutorial","hash":"home-link","h0":"Die Standardbibliothek (Java) | QF‑Test Tutorial"},"195":{"id":195,"content":"Die Standardbibliothek (Java) Dieses Kapitel ist auch als Video verfügbar unter 'Die Standardbibliothek'. QF‑Test stellt eine gewisse Anzahl an Knotentypen bereit, die für die Testerstellung genutzt werden können. Wenn Sie Funktionalität benötigen, die darüber hinausgeht, können Sie diese mittels Skript-Knoten implementieren. Um Ihnen die Arbeit zu erleichtern, wurden viele Funktionen, die häufig benötigt werden, bereits in Prozeduren implementiert und werden in einer Standard-Prozeduren-Bibliothek mit QF‑Test ausgeliefert. Wenn Sie also eine Aufgabenstellung haben, die nicht über die bereitgestellten Knoten gelöst werden kann, sollten Sie zunächst einmal in der Standardbibliothek forschen, ob Sie dort eine passende oder ähnliche Lösung finden. Wenn Sie eine ähnliche Lösung finden, kopieren Sie einfach die vorhandene Standardprozedur und passen sie Sie gemäß Ihrer Bedürfnisse an. Informationen zum Arbeiten mit Skripten erhalten Sie im Handbuch, Kapitel 12 \"Skripting\". Die Bibliothek ist in der Datei qfs.qft enthalten und ist Teil der QF‑Test Distribution. Da sie mit jeder QF‑Test Version weiterentwickelt wird, ist es nicht ratsam, Änderungen in der ausgelieferten Standardbibliothek vorzunehmen, sondern bei Bedarf eine Prozedur in eine eigene Testsuite zu kopieren und dort anzupassen. Um die Bibliothek qfs.qft verwenden zu können, muss sie im \"Testsuite\" Wurzelknoten Ihrer Suite in den \"Inkludierte Dateien\" eingebunden werden. Bei neuen Testsuiten ist dies automatisch der Fall. Wählen Sie den 'Testsuite'-Wurzelknoten Ihrer Testsuite aus. Überprüfen Sie in den Details des 'Testsuite'-Wurzelknoten, dass qfs.qft im Attribut \"Inkludierte Dateien\" aufgeführt ist. Fügen Sie qfs.qft zu dieser Liste dazu, falls es noch nicht enthalten ist. Eine Pfadangabe ist nicht notwendig, da das include Verzeichnis von QF‑Test automatisch im Bibliothekspfad (siehe auch Referenzteil des Handbuchs) enthalten ist. Im Folgenden beschreiben wir eine Auswahl der am häufigsten benötigten Standardprozeduren. Eine vollständige HTML-Dokumentation der Standardbibliothek finden Sie unter dem Menüpunkt »Hilfe«-»Standardbibliothek qfs.qft...«.","hash":"sec_StandardLibrary","h1":"Die Standardbibliothek (Java)"},"196":{"id":196,"content":"Pro Tutorial","hash":"","h0":"Erforschen der Standardbibliothek | QF‑Test Tutorial"},"197":{"id":197,"content":"Pro Tutorial","hash":"home-link","h0":"Erforschen der Standardbibliothek | QF‑Test Tutorial"},"198":{"id":198,"content":"Erforschen der Standardbibliothek Zusätzlich zum Einfügen von Prozeduraufrufen aus der Standardbibliothek ist es hilfreich, einen Blick darauf zu werfen, wie Funktionen implementiert und organisiert sind. Öffnen Sie die Bibliothek selbst, also die Suite qfs.qft, die sich im Verzeichnis qftest-10.0.2-pro/include Ihrer QF‑Test Installation befindet.","hash":"sec_StandardLibraryOverview","h0":"Erforschen der Standardbibliothek"},"199":{"id":199,"content":"Abbildung 7.1: Die Standardbibliothek Sie sehen ein Haupt-Package qfs, das die spezifischen Packages umschließt. Das qfs Package hilft dabei, die Prozeduren leicht als solche der Standardbibliothek zu identifizieren. In fast allen Prozeduren unserer Bibliothek werden Sie die Verwendung der Variable $(client) bemerken. Dies ist ein Standardmechanismus, um Testsuiten unabhängig von einem spezifischen SUT zu gestalten. Für die Benutzung der Standardbibliothek wird vorausgesetzt, dass ein gültiger Wert für $(client) gesetzt wird, bevor eine ihrer Prozeduren verwendet werden kann.","hash":"fig_SuiteQfsQft","h4":"Abbildung 7.1: Die Standardbibliothek"},"200":{"id":200,"content":"Pro Tutorial","hash":"","h0":"Ausgewählte Packages und Prozeduren | QF‑Test Tutorial"},"201":{"id":201,"content":"Pro Tutorial","hash":"home-link","h0":"Ausgewählte Packages und Prozeduren | QF‑Test Tutorial"},"202":{"id":202,"content":"Ausgewählte Packages und Prozeduren Wir werfen nun einen genaueren Blick auf ein paar ausgewählte Packages und Prozeduren der Standardbibliothek. Wir werden mit Packages beginnen, die den Zugriff auf Komponenten abhängig von der verwendeten GUI Technologie ermöglichen, also JavaFX, Swing, Eclipse/SWT und Web Komponenten.","hash":"sec_StandardLibraryPackages","h0":"Ausgewählte Packages und Prozeduren"},"203":{"id":203,"content":"Das Checkbox Package Wir beginnen nun mit der genaueren Betrachtung der Packages qfs.fx.checkbox qfs.swing.checkbox, qfs.swt.checkbox oder qfs.web.checkbox. Hier sind einige Prozeduren aus diesen Packages: select Selektiert ein Kontrollkästchen. Wenn sich das Kontrollkästchen bereits im ausgewählten Zustand befindet, wird keine Aktion ausgeführt. deselect Deselektiert ein Kontrollkästchen. Wenn sich das Kontrollkästchen bereits im nicht-ausgewählten Zustand befindet, wird keine Aktion ausgeführt. set Setzt ein Kontrollkästchen auf den angegebenen Zustand (true oder false). Für jede dieser Prozeduren wird die QF‑Test ID der Kontrollkästchenkomponente als variables Argument übergeben. Die Bibliothek kümmert sich um die Überprüfung, dass der Zustand des Kontrollkästchens wie erwartet gesetzt wurde. Die anderen Prozeduren in diesem Package folgen demselben Muster.","hash":"sec_checkbox_package","h1":"Das Checkbox Package"},"204":{"id":204,"content":"Das Combobox bzw. Combo Package Die Packages qfs.fx.combobox, qfs.swing.combobox, qfs.swt.combo und qfs.web.select enthalten Prozeduren, um Werte in einer Combobox zu selektieren. Die wichtigsten Prozeduren sind: setValue Selektiert einen Wert in der Liste der Combobox. getItemCount Liefert die Anzahl der Einträge zurück.","hash":"sec_das_combobox_bzw_combo_package","h1":"Das Combobox bzw. Combo Package"},"205":{"id":205,"content":"Das General Package Die Packages qfs.fx.general, qfs.swing.general, qfs.swt.general und qfs.web.general enthalten allgemeine Prozeduren für GUI-Elemente. Die wichtigsten Prozeduren sind: setLocation Setzt die Position der Komponente mittels angegebenen Koordinaten. setSize Setzt die Größe der Komponente.","hash":"sec_general_package","h1":"Das General Package"},"206":{"id":206,"content":"Das List Package Die Packages qfs.fx.list, qfs.swing.list, qfs.swt.list und qfs.web.list enthalten allgemeine Prozeduren für Listen. Die wichtigsten Prozeduren sind: getItemCount Zählt die Einträge einer Liste.","hash":"sec_das_list_package","h1":"Das List Package"},"207":{"id":207,"content":"Das Menu Package Die Packages qfs.fx.menu, qfs.swing.menu und qfs.swt.menu erlauben es Ihnen, in einfacher Weise Einträge und auch Kontrollkästchen in Menüs oder Untermenüs auszuwählen bzw. zu setzen. Die wichtigsten Prozeduren sind: selectItem Wählt einen Eintrag in einem Menü aus. selectSubItem Wählt einen Eintrag in einem Untermenü aus. An alle diese Prozeduren muss die QF‑Test ID der Menükomponente wie auch des Eintrags bzw. Kontrollkästchens übergeben werden. Die Benutzung variiert leicht, abhängig von der jeweiligen Art der Prozedur.","hash":"sec_das_menu_package","h1":"Das Menu Package"},"208":{"id":208,"content":"Das Table Package Die Packages qfs.fx.table, qfs.swing.table, qfs.swt.table und qfs.web.table enthalten Hilfsprozeduren für Tabellen. getRowCount Liefert die aktuelle Zeilenanzahl einer Tabelle zurück. Diese Prozedur verwendet technologiespezifische Methoden um an die Anzahl zu kommen. getColumnCount Liefert die aktuelle Spaltenanzahl einer Tabelle zurück. Diese Prozedur verwendet technologiespezifische Methoden um an die Anzahl zu kommen. selectCell Selektiert eine angegebene Tabellenzelle.","hash":"sec_table_package","h1":"Das Table Package"},"209":{"id":209,"content":"Das Tree Package Die Bibliothek stellt in den Packages qfs.fx.tree, qfs.swing.tree, qfs.swt.tree und qfs.web.tree einige einfache Prozeduren zur Manipulation von Bäumen zur Verfügung. Das sind: collapseNode Klappt einen Baumknoten ein. Ist der Knoten bereits eingeklappt, wird keine Aktion ausgeführt. Diese Prozedur besitzt drei einzelne Parameter für Baum und Knoten expandNode Klappt einen Baumknoten aus. Ist der Knoten bereits expandiert, wird keine weitere Aktion ausgeführt. Diese Prozedur besitzt drei einzelne Parameter für Baum und Knoten. selectNode Selektiert einen angegebenen Baumknoten. Jede der Prozeduren benötigt die QF‑Test ID des Baumknotens als Argument.","hash":"sec_das_tree_package","h1":"Das Tree Package"},"210":{"id":210,"content":"Das Cleanup Package Die Packages qfs.fx.cleanup, qfs.swing.cleanup und qfs.swt.cleanup bieten eine gute Unterstützung für das Aufräumen der SUT Umgebung, wenn unerwartet eine Exception auftritt. Stellen Sie sich zum Beispiel vor, dass eine Exception geworfen wird, während auf ein Menü des SUTs zugegriffen wird. Die Exception bewirkt, dass der Ausführungspfad innerhalb Ihrer Testsuite zu einem Exception Handler umgeleitet wird - oder zu einem \"impliziten\" Exception Handler. Das bedeutet, dass der normale Ausführungspfad, der das geöffnete Menü in der Regel wieder ordnungsgemäß geschlossen hätte, unterbrochen wurde. Ohne eine entsprechende Aktion kann dieses Menü geöffnet bleiben und somit andere Ereignisse an das SUT blockieren. Hier sehen Sie die wichtigsten Prozeduren innerhalb des Packages: closeAllModalDialogs bewirkt, dass modale Dialoge des SUTs geschlossen werden. Nur für Swing und FX verfügbar! closeAllDialogsAndModalShells bewirkt, dass alle Dialoge und modalen Shells geschlossen werden. Nur für Eclipse/SWT verfügbar! closeAllMenus Schließt alle offenen Menüs des SUT. Das Konzept zur Behandlung von impliziten Exceptions ist von großer Bedeutung, denn eine Exception in einem einzigen Testfall soll nicht zum Beenden des gesamten Testlaufs führen. Lediglich der aktuelle Testfall soll abgebrochen werden, dann sollte es mit dem nächsten Testfall weitergehen. Aus diesem Grund wird eine Exception innerhalb eines Testfalls auf dieser Ebene gefangen und nicht nach oben propagiert. Dies verhindert den Abbruch des gesamten Testlaufs. Der Fehlerstatus wird jedoch stets korrekt im Protokoll und Report festgehalten. Benutzt der Testfall eine Abhängigkeit, wird die Exception an den Catch Knoten derselben übergeben, falls ein solcher vorhanden ist. Diese Art der Behandlung von Exceptions (und Fehlern) wird im Kapitel Abhängigkeiten des Handbuchs erklärt.","hash":"sec_cleanup_package","h1":"Das Cleanup Package"},"211":{"id":211,"content":"Das Run-log Package Das Package qfs.run-log enthält Prozeduren, um Meldungen in das Protokoll zu schreiben. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: logError Schreibt eine Fehlermeldung ins Protokoll. logWarning Schreibt eine Warnung ins Protokoll. logMessage Schreibt eine Meldung ins Protokoll.","hash":"sec_run_log_package","h1":"Das Run-log Package"},"212":{"id":212,"content":"Das Run-log.Screenshots Package Das qfs.run-log.screenshots Package enthält Prozeduren, die Bildschirmabbilder ins Protokoll schreiben und einige Hilfsprozeduren. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: getMonitorCount Liefert die Anzahl der an den Computer angeschlossenen Monitore. logScreenshot Schreibt ein Bildschirmabbild des aktuellen Monitors ins Protokoll. logImageOfComponent Schreibt ein Bildschirmabbild einer Komponente ins Protokoll. logScreenshotOfMonitor Schreibt ein Bildschirmabbild eines angegebenen Monitors ins Protokoll.","hash":"sec_run_log_screenshots_package","h1":"Das Run-log.Screenshots Package"},"213":{"id":213,"content":"Das Shellutils Package Das qfs.shellutils Package beinhaltet Prozeduren für die wichtigsten Shell-Kommandos. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: copy Kopiert eine angegebene Datei oder ein Verzeichnis an eine neue Stelle. deleteFile Löscht eine angegebene Datei. exists Prüft, ob eine angegebene Datei oder ein Verzeichnis existiert. getBasename Gibt den Dateinamen einer Datei zurück. getParentDirectory Gibt die Verzeichnisstruktur einer Datei zurück. mkdir Erzeugt ein Verzeichnis. Noch nicht existierende Verzeichnisse werden angelegt. move Verschiebt eine angegebene Datei oder ein Verzeichnis. touch Erzeugt eine Datei. removeDirectory Löscht ein angegebenes Verzeichnis.","hash":"sec_shellutils_package","h1":"Das Shellutils Package"},"214":{"id":214,"content":"Das Utils Package Das Package qfs.utils enthält nützliche Prozeduren für häufig auftretende Anforderungen der Testentwicklung. Hier sehen Sie einige Prozeduren des Packages: getDate Gibt einen String zurück, der ein Datum enthält. Standardmäßig wird das aktuelle Datum zurückgegeben. (Andere Daten sind konfigurierbar.) getTime Gibt einen String zurück, der eine Zeit enthält. Standardmäßig wird die aktuelle Zeit zurückgegeben. (Andere Zeiten sind konfigurierbar.) logMemory Schreibt den aktuellen Speicherverbrauch ins Protokoll. printVariable Gibt den Inhalt einer spezifizierten Variable auf der Konsole aus. printMessage Gibt den Inhalt einer angegebenen Nachricht auf der Konsole aus. writeMessageIntoFile Schreibt einen angegebenen String in eine angegebene Datei.","hash":"sec_utils_package","h1":"Das Utils Package"},"215":{"id":215,"content":"Das Database Package Das Package qfs.database enthält nützliche Prozeduren, um mit Datenbanken zu interagieren. Bitte beachten Sie, dass die jar-Datei mit dem Datenbanktreiber vor dem Start von QF‑Test ins qftest Pluginverzeichnis kopiert werden muss. Für weitere Informationen über den Aufbau einer Datenbankverbindung kontaktieren Sie bitte einen Entwickler oder werfen Sie einen Blick auf www.connectionstrings.com. Die wichtigsten Prozeduren sind: executeSelectStatement Führt einen angegebenen SQL-Select-Befehl aus. Das Ergebnis wird zum einen in die globale Variable \"resultRows\" des Jython Variablenstacks geschrieben und ist somit in jedem Jython Skript verfügbar. Zum anderen wird das Ergebnis auch in eine Gruppenvariable mit dem Standardnamen \"resultGroup\" geschrieben und ist somit direkt von QF‑Test Knoten aus ansprechbar. executeStatement Führt einen angegebenen SQL Befehl aus. Hier kann jedes beliebige SQL Kommando ausgeführt werden.","hash":"sec_database_package","h1":"Das Database Package"},"216":{"id":216,"content":"Das Check Package Das qfs.check Package enthält Prozeduren, die Checks ausführen. Die wichtigsten Prozeduren sind: checkEnabledStatus Überprüft, ob eine Komponente en- bzw. disabled ist. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt. checkSelectedStatus Überprüft, ob eine Komponente selektiert bzw. nicht selektiert ist. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt. checkText Überprüft den Text einer Komponente. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt.","hash":"sec_check_package","h1":"Das Check Package"},"217":{"id":217,"content":"Das Databinder Package Das Package qfs.databinder enthält Prozeduren zur Ausführung innerhalb eines Datentreiber Knotens, um Daten für datengetriebenes Testen zu binden. Die wichtigsten Prozeduren sind: bindList Bindet eine Liste von Werten an eine Variable. Die Werte sind durch Leerzeichen oder das als Parameter übergebene Trennzeichen getrennt. bindSets Bindet Sätze von Werten an einen Satz von Variablen. Die Sätze von Werten sind durch Zeilenumbrüche getrennt, die Werte innerhalb eines Satzes durch Leerzeichen oder das als Parameter übergebene Trennzeichen.","hash":"sec_databinder_package","h1":"Das Databinder Package"},"218":{"id":218,"content":"Pro Tutorial","hash":"","h0":"Ablaufsteuerung (Java) | QF‑Test Tutorial"},"219":{"id":219,"content":"Pro Tutorial","hash":"home-link","h0":"Ablaufsteuerung (Java) | QF‑Test Tutorial"},"220":{"id":220,"content":"Ablaufsteuerung (Java) Dieses Kapitel ist auch als Video verfügbar unter 'Ablaufsteuerung'. Die zwei wichtigsten Kontrollstrukturen von QF‑Test sind Schleifen und die bedingte Ausführung von Knoten. Schleifen können über zwei verschieden Knoten implementiert werden: While und Schleife Knoten. If, Elseif und Else Knoten stehen für die bedingte Ausführung von Knoten zur Verfügung.","hash":"sec_controlstructures","h1":"Ablaufsteuerung (Java)"},"221":{"id":221,"content":"Pro Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"222":{"id":222,"content":"Pro Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"223":{"id":223,"content":"If - else If und Else Knoten kennen Sie bereits aus der Vorbereitung Sequenz im Kapitel Starten der Anwendung. Sehen wir uns diese nun etwas genauer an.","hash":"sec_if","h0":"If - else"},"224":{"id":224,"content":"Abbildung 8.1: Setup Sequenz mit If/Elseif Knoten Über einen If Knoten können Sie steuern, ob bestimmte Knoten ausgeführt werden oder nicht. In unserem Fall geht es um den Start des SUT. Zunächst müssen wir herausfinden, ob die Applikation bereits läuft. Dies geschieht über den Warten auf Client Knoten, der als Ergebnis entweder true (wahr) oder false (falsch) in die Variable isSUTRunning schreibt.","hash":"fig_ControlsSetupSequence","h4":"Abbildung 8.1: Setup Sequenz mit If/Elseif Knoten"},"225":{"id":225,"content":"Abbildung 8.2: Warten auf Client setzt die Variable \"isSUTRunning\" mit dem Ergebnis Der If Knoten wertet die Ergebnisvariable isSUTRunning im 'Bedingung' Attribut aus. Da auf den Wert der Variablen zugegriffen werden soll, wird die Syntax $() verwendet (vgl. Variablensyntax in Kapitel \"Prozedur mit Variable\").","hash":"fig_ControlsWaitForClient","h4":"Abbildung 8.2: Warten auf Client setzt die Variable \"isSUTRunning\" mit dem Ergebnis"},"226":{"id":226,"content":"Abbildung 8.3: Der If Knoten wertet die Variable aus Je nachdem, ob die Applikation bereits läuft, führt QF‑Test die im If Knoten enthaltenen Knoten aus oder nicht. Beenden Sie das CarConfig Demo, falls es läuft. Führen Sie den Vorbereitung Knoten mit Einzelschritten aus. Führen Sie den Vorbereitung Knoten nochmals mit Einzelschritten aus während das CarConfig Demo läuft. In der Variablendefinition-Tabelle können Sie den Wert der Variablen isSUTRunning prüfen. Beim ersten Mal ist der Wert false und damit die Bedingung not $(isSUTRunning) wahr, d.h. die Knoten für den SUT-Start werden ausgeführt. Beim zweiten Mal ist der Wert true und damit die Bedingung false. Die Knoten im If Knoten werden übersprungen. Im ersten If Knoten befindet sich ein weiterer, der prüft, um welches Betriebssystem es sich handelt. Bei Windows werden die Knoten, die direkt unter dem If Knoten liegen, ausgeführt. Alternativ, d.h. wenn das Betriebssystem nicht Windows ist, werden die Kindknoten im Else Knoten ausgeführt. Bei der Prüfung des Betriebssystems wird direkt auf eine QF‑Test Variable zugegriffen. QF‑Test speichert die Betriebssysteminformation in einer Gruppenvariable ab, wobei die Gruppe qftest und die Variablen linux, macos oder windows heißen. Die Syntax für den Zugriff auf Gruppenvariablen ist ${group:varname}, z.B. ${qftest:windows}.","hash":"fig_ControlsIf","h4":"Abbildung 8.3: Der If Knoten wertet die Variable aus"},"227":{"id":227,"content":"Pro Tutorial","hash":"","h0":"Schleifen | QF‑Test Tutorial"},"228":{"id":228,"content":"Pro Tutorial","hash":"home-link","h0":"Schleifen | QF‑Test Tutorial"},"229":{"id":229,"content":"Schleifen QF‑Test stellt zwei Knotentypen für die Implementierung von Schleifen zur Verfügung: Schleife Knoten führen ihre Kindknoten so oft aus, wie angegeben ist. Man kann die Schleife jedoch über einen Break Knoten jederzeit verlassen. While Knoten führen ihre Kindknoten so oft aus, bis die angegebene Bedingung nicht mehr gegeben ist. Derartige Schleifen können ebenfalls über einen Break Knoten jederzeit verlassen werden. Schleife Knoten enden auf jeden Fall nach der angegeben Anzahl von Wiederholungen. Bei While Knoten muss man jedoch selbst dafür sorgen, dass die Ausführung irgendwann endet, indem die Bedingung falsch wird. Ansonsten kommt es zur Endlosschleife. Im interaktiven Modus können Sie in so einem Fall einfach die Pausetaste drücken. Im Batch-Modus, d.h. wenn Sie QF‑Test mit dem Kommandozeilenparameter -batch starten um die angegebene Testsuite ohne die QF‑Test Benutzeroberfläche auszuführen, müssen Sie dann jedoch den QF‑Test Prozess \"abschießen\". In der folgenden Übung wollen wir einen Testfall implementieren, der prüft, ob eine bestimmte Zeile in der Tabelle des CarConfig Demos angezeigt wird. Die im Testfall durchgeführten Aktionen sind: Anzahl Tabellenzeilen bestimmen. Über alle Zeilen iterieren und prüfen, ob die Zeile passt. Wenn die Zeile gefunden wurde, die Schleife abbrechen. Falls die Zeile nicht gefunden wurde, einen Fehler ins Protokoll schreiben. Bitte beginnen Sie mit der Aufnahme eines Checks auf die zu suchende Zeile: Aktivieren Sie den Check-Aufnahmemodus über \"Checks aufnehmen\" . Führen Sie einen Rechtsklick auf eine Tabellenzeile im CarConfig Demo aus und wählen Sie den Menüpunkt »Zeile« aus dem Popup-Menü. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Ändern Sie den Namen der aufgenommenen Sequenz z.B. in Zeile prüfen. Wandeln Sie die Sequenz in einen Testfall um: Rechtsklick auf den Sequenz Knoten und Auswahl des Untermenüpunkts »Knoten konvertieren in«-»Testfall« im Popup-Menü.","hash":"sec_loops","h0":"Schleifen"},"230":{"id":230,"content":"Abbildung 8.4: Knoten konvertieren In QF‑Test können Sie sehr effizient Knoten hinzufügen, indem Sie einen Knoten in einen anderen einpacken: Öffnen Sie den Testfall Knoten und packen Sie den aufgenommenen Check Knoten in eine Schleife indem Sie rechts auf den Knoten klicken und in dem sich öffnenden Popupmenü den Punkt »Knoten einpacken in«-»Schleife« auswählen.","hash":"fig_ControlsTransformNodeInto","h4":"Abbildung 8.4: Knoten konvertieren"},"231":{"id":231,"content":"Abbildung 8.5: Knoten einpacken QF‑Test ermittelt dynamisch, in welche Knoten ein Knoten eingepackt werden kann und bietet nur diese zur Auswahl an. Entsprechend kann es passieren, dass Sie \"Schleife\" im Untermenü nicht finden. Sie sollten dann prüfen, ob Sie den Rechtsklick auf den richtigen Knoten ausgeführt haben. Dasselbe gilt für die Operationen \"Knoten konvertieren in\" und \"Knoten einfügen\". Als nächstes setzen wir den Wert für das Attribut 'Anzahl Wiederholungen' des Schleife Knoten. Dazu müssen wir bestimmen, wie viele Zeilen die Tabelle hat. Es gibt keinen Knoten, der diese Operation direkt ausführen kann. Allerdings gibt es eine derartige Prozedur in der im letzten Kapitel besprochenen Standardbibliothek. Diese befindet sich im Package qfs.swing.table und heißt getRowCount. Selektieren Sie den Testfall Knoten und drücken Strg⁠+⁠A. Klicken Sie die Schaltfläche \"Prozedur auswählen\" links neben der Überschrift 'Name der Prozedur'. Wählen Sie den Reiter 'qfs.qft' im 'Prozedur auswählen' Dialog. Navigieren Sie zu 'getRowCount' im Package 'qfs.swing.table' Drücken Sie 'OK' um die Prozedur auszuwählen. Das Hinzufügen einer Prozedur über Strg⁠+⁠A wurde bereits in Manuelle Erstellung von Prozeduren behandelt. Dort finden Sie auch Screenshots zur Aktion. Fügen Sie eine Variable mit dem Namen Zeilen im Attribut 'Variable für Rückgabewert' ein. Ändern Sie den Standardwert für id in der Variablendefinitionen-Tabelle auf die QF‑Test Komponenten ID der Tabelle VehicleTable. Wählen Sie den 'Schleife'-Knoten. Im Attribut 'Anzahl Wiederholungen' des Schleife Knotens tragen Sie eine Referenz auf die Variable $(Zeilen) ein. Tragen Sie den Namen der Zählervariable, z.B. i, im entsprechenden Attribut des Schleife Knotens ein.","hash":"fig_ControlsPackNodeInto","h4":"Abbildung 8.5: Knoten einpacken"},"232":{"id":232,"content":"Abbildung 8.6: Details eines Schleife Knotens In den Details des Check Knotens tragen wir nun in der QF‑Test ID der Komponente statt des aufgenommenen Zeilenindex eine Referenz auf die Zählervariable ein und setzen eine Ergebnisvariable. Außerdem fügen wir einen If Knoten unter dem Check Knoten hinzu, der das Ergebnis auswertet und die Schleife über einen Break Knoten verlässt, wenn die entsprechende Zeile gefunden wurde. Öffnen Sie den Schleife Knoten. Selektieren Sie den Check Knoten. Ändern Sie den aufgenommenen Zeilenindex der QF‑Test ID der Komponente in Zählervariable $(i). Die QF‑Test ID der Komponente sollte nun VehicleTable@Modell&$(i) lauten. Tragen Sie den Variablennamen ZeileGefunden in das Attribut 'Variable für Ergebnis' ein. Führen Sie einen Rechtsklick auf den Check Knoten aus und wählen Sie aus dem Popup-Menü den Unterpunkt »Knoten einfügen«-»Ablaufsteuerung«-»Break« aus. Packen Sie den Break Knoten in einen If Knoten mittels des Tastaturkürzels Strg⁠+⁠Umschalt⁠+⁠I (Sie können natürlich auch über das Menü gehen). In den Details des 'If'-Knotens tragen Sie $(ZeileGefunden) im Attribut 'Bedingung' ein. Die Variable ZeileGefunden wird vom Check Knoten entweder auf den Wert 'true' oder auf den Wert 'false' gesetzt, so dass wir im Attribut 'Bedingung' des If Knoten nur die Referenz auf die Variable $(ZeileGefunden) einzutragen brauchen. In den nächsten Schritten wollen wir einen Else Knoten als letzten Knoten im Schleife Knoten einfügen. Er wird nur ausgeführt, wenn die Schleife so oft wie angegeben ausgeführt wurde, was in unserem Fall bedeutet, dass die Variable ZeileGefunden nie wahr wurde, weil die Zeile nicht gefunden wurde. Schließen Sie den If Knoten, falls dies nicht bereits der Fall ist. Dies ist wichtig, da sonst der Else Knoten zum If Knoten und nicht zum Schleife Knoten gehören würde. Führen Sie einen Rechtsklick auf den If Knoten aus und wählen Sie auf dem Popup-Menü den Unterpunkt »Knoten einfügen«-»Ablaufsteuerung«-»Else«. Öffnen Sie den Else Knoten. Fügen Sie aus der Standardbibliothek die Prozedur logError aus dem Package qfs.run-log wie oben beschrieben ein. In der 'Variablendefinitionen' Tabelle tragen Sie Zeile nicht gefunden als Wert der Zeile message ein. Tragen Sie true als Wert der Zeile withScreenshots ein. Wenn Sie die Tests im Batch-Modus ausführen, sind Screenshots eine gute Unterstützung bei der Fehleranalyse. Da aber eine große Zahl Screenshots sehr große Protokolldateien erzeugen würden, ist der Standardwert für withScreenshots false. Nun bleibt nur noch, den Testfall mit Vorbereitung und Aufräumen Knoten zu vervollständigen und ihn in den oberen Teil der Testsuite zu verschieben. Kopieren Sie die Vorbereitung und Aufräumen Knoten aus 'Testset: Einfache Tests' in den neuen Testfall als ersten und letzten Knoten. Verschieben Sie den Testfall aus dem Bereich Extrasequenzen in den oberen Bereich der Testsuite hinter den Knoten 'Testset: Einfache Tests'. Damit würde der neue Testfall wie folgt aussehen:","hash":"fig_ControlsLoopDetails","h4":"Abbildung 8.6: Details eines Schleife Knotens"},"233":{"id":233,"content":"Abbildung 8.7: Der neue Testfall Führen Sie den neuen Testfall aus. Er sollte ohne Fehler laufen. Ändern Sie nun in den Details des Check Elemente Knotens den Namen des Fahrzeugs zum Beispiel auf Falscher Wert.","hash":"fig_ControlsTestcase","h4":"Abbildung 8.7: Der neue Testfall"},"234":{"id":234,"content":"Abbildung 8.8: Details eines Check Elemente Knoten Führen Sie den Testfall nochmals aus. Nun sollte der Test den Else Knoten der Schleife ausführen und eine Fehlermeldung anzeigen.","hash":"fig_ControlsCheckDetails","h4":"Abbildung 8.8: Details eines Check Elemente Knoten"},"235":{"id":235,"content":"Pro Tutorial","hash":"","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Mobile) | QF‑Test Tutorial"},"236":{"id":236,"content":"Pro Tutorial","hash":"home-link","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Mobile) | QF‑Test Tutorial"},"237":{"id":237,"content":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Mobile) Dieses Kapitel ist auch als Video verfügbar unter 'Nun ist es Zeit, Ihre eigene Anwendung zu starten'. Nachdem wir so viel Zeit mit all den Beispielanwendungen verbracht haben, sind Sie nun wirklich bereit, Ihre eigene Applikation zu starten (falls Sie dies nicht schon zwischendurch getan haben). Der Schnellstart-Assistent, welcher über das Menü »Extras«-»Schnellstart-Assistent...« erreichbar ist, hilft Ihnen bei dieser Aufgabe. Folgen Sie einfach den Schritten innerhalb des Assistenten, um eine passende Startsequenz zu erzeugen. Bitte schauen Sie auch ins Handbuch Kapitel 3 \"Schnellstart\". Es ist an der Zeit, das Gelernte in die Tat umzusetzen - kurze Sequenzen von Events und Checks aufzunehmen, Prozeduren zu erzeugen etc., um eine eigene Testbibliothek aufzubauen. Damit endet der Basisteil in diesem Tutorial.","hash":"sec_ownappmobile","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Mobile)"},"238":{"id":238,"content":"Pro Tutorial","hash":"","h0":"Web GUIs testen mit QF‑Test | QF‑Test Tutorial"},"239":{"id":239,"content":"Pro Tutorial","hash":"home-link","h0":"Web GUIs testen mit QF‑Test | QF‑Test Tutorial"},"240":{"id":240,"content":"Web GUIs testen mit QF‑Test Dieser zweite Teil des Tutorials soll Ihnen die Basiseigenschaften und -arbeitsabläufe von QF‑Test erläutern. Er fokussiert sich auf das Testen von Web-Anwendungen und deren Besonderheiten. Wenn Sie Java- oder native Windows-Anwendungen testen wollen, empfehlen wir \"Java-GUIs testen mit QF‑Test\" beziehungsweise \"Native Windows GUIs testen mit QF‑Test\". Alle Basisteile vermitteln die gleichen Schulungsinhalte, nutzen für die Beispiele jedoch eine jeweils passende Testanwendung. Wenn Sie sich bereits durch den Teil I gearbeitet haben und zusätzlich zu Java auch Web-Anwendungen testen wollen, ist es i.d.R. nicht notwendig, dass Sie all die gleichen Szenarien noch einmal durchgehen. Jedoch sollte zumindest einen Blick in die Abschnitte Erzeugen der Startsequenz, Web-Komponentenerkennung und Der Bereich Fenster und Komponenten werfen, die spezifische Inhalte für Web haben. Im \"Weiterführende Features von QF‑Test\" werden weiterführende Funktionalitäten von QF‑Test erklärt, die für Tests sowohl von Java-, Web- und nativen Windows-Anwendungen genutzt werden können.","hash":"sec_web","h1":"Web GUIs testen mit QF‑Test"},"241":{"id":241,"content":"Pro Tutorial","hash":"","h0":"Bearbeiten einer Beispiel-Testsuite (Web) | QF‑Test Tutorial"},"242":{"id":242,"content":"Pro Tutorial","hash":"home-link","h0":"Bearbeiten einer Beispiel-Testsuite (Web) | QF‑Test Tutorial"},"243":{"id":243,"content":"Bearbeiten einer Beispiel-Testsuite (Web) Dieses Kapitel ist auch als Video verfügbar unter 'Bearbeiten einer Beispiel-Testsuite'. In diesem ersten Kapitel werden wir uns die Struktur einer einfachen Testsuite anschauen, die wesentlichen Bestandteile erklären, sie ausführen und das Ergebnis auswerten.","hash":"sec_webdemo","h1":"Bearbeiten einer Beispiel-Testsuite (Web)"},"244":{"id":244,"content":"Pro Tutorial","hash":"","h0":"Laden der Testsuite | QF‑Test Tutorial"},"245":{"id":245,"content":"Pro Tutorial","hash":"home-link","h0":"Laden der Testsuite | QF‑Test Tutorial"},"246":{"id":246,"content":"Laden der Testsuite Beim ersten Start von QF‑Test und/oder der zu testenden Anwendung über QF‑Test kann eine Sicherheitswarnung der Firewall auftreten mit der Frage, ob das Netzwerkprotokoll für Java geblockt werden soll oder nicht. Da QF‑Test die Java-Netzwerkprotokolle für die Kommunikation mit dem SUT (System under Test) nutzt, darf diese nicht geblockt werden, um das automatisierte Testen zu ermöglichen. Nach dem Starten von QF‑Test laden Sie bitte unser erstes Beispiel: Drücken Sie den Knopf , um den Dateiauswahl-Dialog zu öffnen. Wechseln Sie in das Unterverzeichnis qftest-10.0.2-pro/doc/tutorial Ihrer QF‑Test Installation. Dort wählen Sie bitte die Datei ErsteWebTests.qft aus und öffnen diese. QF‑Test präsentiert Ihnen die Testsuite wie im folgenden Bild dargestellt:","hash":"tut_loadsuiteweb","h0":"Laden der Testsuite"},"247":{"id":247,"content":"Abbildung 10.1: Die erste Testsuite Der linke Bereich des Hauptfensters enthält die Testsuite, die in einer Baumstruktur dargestellt wird. Rechts befindet sich die Detailansicht des Knotens, der im Baum gerade markiert ist. (Falls die Detailansicht bei Ihnen nicht zu sehen sein sollte, aktivieren Sie diese bitte über das Menü »Ansicht«-»Details anzeigen«.) Im Bereich unten rechts befindet sich das Terminal, welches die Ausgaben von QF‑Test und dem zu testenden Client protokolliert. Mit Hilfe des Baumes können Sie durch die Testsuite navigieren und einzelne Knoten auswählen, für die dann jeweils die Details im rechten Fensterbereich eingeblendet werden. Doppelklicken Sie bitte den Knoten Testfallsatz: Einfache Tests um ihn zu expandieren und die darin liegenden Knoten sehen zu können. Der Testfallsatz enthält primär zwei Testfälle, umgeben von einem \"Vorbereitung\"/\"Aufräumen\" Knotenpaar, das im Wesentlichen die Testanwendung startet bzw. beendet.","hash":"fig_firstTestSuiteWeb","h4":"Abbildung 10.1: Die erste Testsuite"},"248":{"id":248,"content":"Abbildung 10.2: Der Inhalt des Testfallsatz Knotens In den folgenden Abschnitten werden wir Funktion und Zweck der einzelnen Knoten erklären.","hash":"fig_firstTestSetWeb","h4":"Abbildung 10.2: Der Inhalt des Testfallsatz Knotens"},"249":{"id":249,"content":"Pro Tutorial","hash":"","h0":"Starten des Browsers | QF‑Test Tutorial"},"250":{"id":250,"content":"Pro Tutorial","hash":"home-link","h0":"Starten des Browsers | QF‑Test Tutorial"},"251":{"id":251,"content":"Starten des Browsers Zuerst wollen wir die Vorbereitung genauer unter die Lupe nehmen: Expandieren Sie den Knoten Vorbereitung: Demoseite öffnen, wie im folgenden Bild gezeigt.","hash":"tut_startsutweb","h0":"Starten des Browsers"},"252":{"id":252,"content":"Abbildung 10.3: Der Knoten \"Vorbereitung\" Es werden zwei Kindknoten sichtbar: Globale Variablen setzen abhängig von OS - definiert die globale Client Variable, die durchweg in der Testsuite benutzt wird, sowie den zu nutzenden Browser, abhängig vom Betriebssystem (Chrome für Windows und macOS, Firefox für Linux). Browser starten wenn nötig - startet den entsprechenden Browser, wenn er nicht bereits läuft und lädt die Demoseite. Lassen Sie uns noch einen kurzen Blick in die Sequenz: Browser starten wenn nötig werfen:","hash":"fig_firstSetupWeb","h4":"Abbildung 10.3: Der Knoten \"Vorbereitung\""},"253":{"id":253,"content":"Abbildung 10.4: Die Sequenz zum Starten des Browsers Zu Beginn steht ein Warten auf Client Knoten, der prüft, ob der Client bereits läuft. Nur wenn dies nicht der Fall ist, wird er gestartet. Der Start des Browsers verläuft in vier Schritten: Web-Engine starten - ist ein vorbereitendes Starten des Browser-Prozesses zur Konfiguration. Einstellungen für Browser setzen - setzt die notwendigen Browser-Einstellungen (z.B. Cache, Cookies, Proxy, ...) Browserfenster öffnen - öffnet das Browser-Fenster und wartet auf das Laden der Webseite. CustomWebResolver registrieren - erlaubt die Konfiguration der Komponentenerkennung, so dass QF‑Test die Funktionalität der Komponenten (Textfeld, Button, Datentabelle etc.) erkennt. Warum dies vorteilhaft ist sowie Informationen zur Konfiguration finden Sie im Abschnitt Web-Komponentenerkennung. Diese vier Schritte werden automatisch generiert, wenn man den Schnellstart-Assistenten nutzt, der im nächsten Tutorialkapitel erklärt wird (\"Erstellen einer eigenen Testsuite (Web)\"). Wir wollen nun die Anwendung wirklich starten: Markieren Sie dazu bitte den Knoten Vorbereitung: Demoseite öffnen, doch belassen Sie ihn aufgeklappt. Klicken Sie den Knopf Wiedergabe. Dies führt den aktuellen ausgewählten Knoten aus. Während der Ausführung wird der gerade aktive Knoten durch \"->\" markiert. Nach Abschluss der Startsequenz sollte der Browser mit der \"CarConfigurator\" Demoseite am Bildschirm erscheinen. Da QF‑Test nach Ende der Wiedergabe den Fokus zurückerhält, kann der Browser dadurch auch wieder verdeckt worden sein.","hash":"fig_firstStartWeb","h4":"Abbildung 10.4: Die Sequenz zum Starten des Browsers"},"254":{"id":254,"content":"Abbildung 10.5: Das CarConfigurator Webdemo","hash":"fig_webDemoPage","h4":"Abbildung 10.5: Das CarConfigurator Webdemo"},"255":{"id":255,"content":"Pro Tutorial","hash":"","h0":"Ein erster Testfall | QF‑Test Tutorial"},"256":{"id":256,"content":"Pro Tutorial","hash":"home-link","h0":"Ein erster Testfall | QF‑Test Tutorial"},"257":{"id":257,"content":"Ein erster Testfall Als nächstes wollen wir einen Blick auf den ersten Testfall werfen. Er besteht aus vier Testschritten:","hash":"tut_firsttestweb","h0":"Ein erster Testfall"},"258":{"id":258,"content":"Abbildung 10.6: Der \"Erste\" Testfallknoten Zurücksetzen - stellt den Anfangszustand der Anwendung über das Menü Datei->Zurücksetzen wieder her und selektiert den Tab Fahrzeuge. Modell I5 wählen - Wählt das letzte Modell I5 in der Fahrzeugetabelle aus. Sondermodell Jazz wählen - Wechselt zum Tab Sondermodelle und wählt dort Jazz. Endpreis prüfen - Überprüft, dass der berechnete Wert dem Feldes Endpreis unten rechts einem vorgegebenen Wert entspricht. Testschritte sind oft hilfreich, um einen Testfalls zu strukturieren und dadurch lesbar und verständlicher zu gestalten. Dies erleichtert später eine eventuelle Fehlersuche oder Anpassungen des Testfalls. Bitte expandieren Sie die vier Testschritt Knoten.","hash":"fig_firstTestCaseWeb","h4":"Abbildung 10.6: Der \"Erste\" Testfallknoten"},"259":{"id":259,"content":"Abbildung 10.7: Die Details des ersten Testfalls Sie sehen diverse Mausklicks sowie einen Check. Zur besseren Lesbarkeit des Testfalls wurden sie mittels Testschrittknoten strukturiert. Neben der Aktionsart (Mausklick, Check) wird angezeigt, auf welche Anwendungskomponente sich die Aktion bezieht, also wohin z.B. der Mausklick geht. Diese Knoten können direkt über die Aufnahmefunktion von QF‑Test erzeugt werden. Näheres hierzu erfahren Sie im nächsten Erstellen einer eigenen Testsuite (Web). Wir wollen uns nun die Ausführung des ersten Testfalls anschauen. Markieren Sie dazu den Testfall: Erster Knoten. Drücken Sie anschließend den Wiedergabeknopf . Die Testschritte werden nun der Reihe nach abgespielt, wobei dies typischerweise ziemlich rasch passiert. Das aktuelle Testergebnis wird während und nach dem Testlauf in der Statuszeile am unteren rechten Rand des QF‑Test Hauptfensters angezeigt und sollte \"Beendet: Keine Fehler\" lauten. Daneben zeigt QF‑Test verschiedene Zähler an. Der erste Zähler bezieht sich auf die Anzahl der ausgeführten Testfälle, der zweite auf die Zahl der ausgeführten Testfälle ohne Fehler. In unserem Fall wurde ein Testfall fehlerfrei ausgeführt, was einer Erfolgsquote von 100% entspricht.","hash":"fig_firstTestCaseDetailsWeb","h4":"Abbildung 10.7: Die Details des ersten Testfalls"},"260":{"id":260,"content":"Abbildung 10.8: Die Ergebnisanzeige in der Statusleiste Wenn Sie den Mauszeiger auf dem Symbol eines Testfallzählers ruhen lassen, wird Ihnen eine entsprechende Beschreibung angezeigt. Eine Auflistung aller Testfallzähler finden Sie im Kapitel Aufnahme und Wiedergabe des Handbuchs.","hash":"fig_resultOneTestCaseNoErrorWeb","h4":"Abbildung 10.8: Die Ergebnisanzeige in der Statusleiste"},"261":{"id":261,"content":"Pro Tutorial","hash":"","h0":"Ein zweiter Testfall - mit Fehler | QF‑Test Tutorial"},"262":{"id":262,"content":"Pro Tutorial","hash":"home-link","h0":"Ein zweiter Testfall - mit Fehler | QF‑Test Tutorial"},"263":{"id":263,"content":"Ein zweiter Testfall - mit Fehler Der zweite Testfall wird uns zeigen, was passiert, wenn ein Fehler bei der Testausführung auftritt. Bitte expandieren Sie den Knoten Testfall: Zweiter (mit Fehler).","hash":"tut_secondtestweb","h0":"Ein zweiter Testfall - mit Fehler"},"264":{"id":264,"content":"Abbildung 10.9: Der \"Zweite\" Testfallknoten Bis auf den dritten Testschritt sieht es bekannt aus. Was tut der Unbekannte? Testschritt: 10% Rabatt gewähren - Schreibt den Wert 10 in das Rabattfeld Die Texteingabe ist eine weitere Basisaktion. Eingabe-Knoten kann man ebenfalls direkt über die Aufnahmefunktion generieren lassen. Den Wert 10 sieht man im Feld \"Text\" rechts und auch direkt im Text des Baumknotens. Expandieren Sie den Knoten Testschritt: 10% Rabatt gewähren.","hash":"fig_secondTestCaseWeb","h4":"Abbildung 10.9: Der \"Zweite\" Testfallknoten"},"265":{"id":265,"content":"Abbildung 10.10: Die Details des zweiten Testfalls Wir wollen uns die Ausführung des zweiten Testfalls anschauen. Markieren Sie dazu den Testfall: Zweiter (mit Fehler) Knoten. Drücken Sie anschließend den Wiedergabeknopf . Diesmal erscheint ein Dialog mit der Information, dass ein Fehler aufgetreten ist.","hash":"fig_secondTestCaseDetailsWeb","h4":"Abbildung 10.10: Die Details des zweiten Testfalls"},"266":{"id":266,"content":"Abbildung 10.11: Fehler im zweiten Testfall Was ist passiert? Fast immer wenn so ein Fall auftritt, ist es sinnvoll das Protokoll zu Rate zu ziehen. Alternativ könnte man den Testfall zur Fehlersuche nochmal im Debug-Modus ausführen. Diese Vorgehensweise wird in Kapitel Benutzen des Debuggers (Web) erläutert.","hash":"fig_textTestErrorWeb","h4":"Abbildung 10.11: Fehler im zweiten Testfall"},"267":{"id":267,"content":"Pro Tutorial","hash":"","h0":"Das Protokoll zur Fehlerdiagnose | QF‑Test Tutorial"},"268":{"id":268,"content":"Pro Tutorial","hash":"home-link","h0":"Das Protokoll zur Fehlerdiagnose | QF‑Test Tutorial"},"269":{"id":269,"content":"Das Protokoll zur Fehlerdiagnose QF‑Test protokolliert detaillierte Informationen für jede Testausführung. Öffnen Sie nun bitte das letzte Protokoll über eine der folgenden Möglichkeiten: den Protokoll anzeigen Knopf im Fehlerdialog oder falls Sie den Dialog bereits geschlossen haben den Button in der Werkzeugleiste oder über die Tastenkombination Strg⁠+⁠L. Die Protokolle der letzten Testläufe können auch über die unteren Einträge im Menü 'Wiedergabe' aufgerufen werden. Das Protokoll öffnet sich in einem separaten Fenster und zeigt die protokollierten Aktionen des zweiten Testfalls, den Sie soeben ausgeführt haben:","hash":"tut_firstRunlogWeb","h0":"Das Protokoll zur Fehlerdiagnose"},"270":{"id":270,"content":"Abbildung 10.12: Protokoll des zweiten Testfalls Das Protokoll ist in seinem Aufbau ähnlich zu dem der Testsuite. Der Baum links enthält wieder die bekannten Knoten, jedoch dieses Mal in der zeitlichen Abfolge des Testlaufs. Wenn man einen Knoten anwählt, sieht man rechts die Details inklusive Zeitstempel und Ausführungsdauer. Im Baum links werden Ihnen rote Rahmen um einige Knoten auffallen. Diese zeigen an, dass sich darunter Fehler befinden. Wenn man den rot umrandeten Knoten Ebene für Ebene folgt, erreicht man irgendwann den Fehler. Schneller und bequemer geht es über den Button Nächsten Fehler finden in der Werkzeugleiste oder auch die Tastenkombination [Strg-N]. Alle rot markierten Knoten werden expandiert und der Knoten mit dem eigentlichen Fehler wird selektiert:","hash":"fig_firstErrorRunlogWeb","h4":"Abbildung 10.12: Protokoll des zweiten Testfalls"},"271":{"id":271,"content":"Abbildung 10.13: Fehlerdiagnose für den zweiten Testfall Die Fehlermeldung auf der rechten Seite gibt an, dass der erhaltene Wert des Endpreis Feldes nicht dem erwarteten entspricht. Dieser Fehler wurde natürlich mit Absicht eingebaut, um zu zeigen, wie man bei der Analyse vorgehen kann. Hilfreich bei der Fehleranalyse ist üblicherweise auch der übernächste Protokollknoten Bildschirmabbild. Seine Detailansicht enthält ein vollständiges Abbild des Bildschirms zum Zeitpunkt des Fehlers. Dies ist sehr nützlich, um den Zustand des SUTs zu sehen und daraus eventuell die Fehlerursache ableiten zu können. Die folgende Grafik zeigt den Knoten:","hash":"fig_firstErrorRunlogDetailsWeb","h4":"Abbildung 10.13: Fehlerdiagnose für den zweiten Testfall"},"272":{"id":272,"content":"Abbildung 10.14: Knoten mit Bildschirmabbild der Fehlersituation Neben dem Abbild aller Bildschirme speichert QF‑Test auch Bilder der einzelnen Fenster des SUT zum Fehlerzeitpunkt. Dies erlaubt Ihnen deren Inhalt zu analysieren, auch wenn diese eigentlich durch andere Fenster oder Dialoge verdeckt sind.","hash":"fig_firstErrorRunlogScreenshotWeb","h4":"Abbildung 10.14: Knoten mit Bildschirmabbild der Fehlersituation"},"273":{"id":273,"content":"Pro Tutorial","hash":"","h0":"Wo finde ich Hilfe? | QF‑Test Tutorial"},"274":{"id":274,"content":"Pro Tutorial","hash":"home-link","h0":"Wo finde ich Hilfe? | QF‑Test Tutorial"},"275":{"id":275,"content":"Wo finde ich Hilfe? In diesem Abschnitt machen wir eine kleine Pause, um einige allgemeine Hinweise zu geben. Es gibt verschiedene Möglichkeiten, um Hilfe oder Antworten zu finden: Die umfassendste Suche kann man über »Hilfe«-»Online Suche...« anstoßen. Dies bringt Sie auf die Suchfunktionalität unserer Homepage und erlaubt Ihnen die Abfrage aller verfügbarer Dokumentation (Handbuch, Tutorial, Standardbibliothek, Blog und unsere Videos). Die angezeigten Suchergebnisse können passend gefiltert werden. Wenn Sie offline arbeiten und nach einem Thema suchen wollen, können Sie die Offline-Versionen von Handbuch und Tutorial nutzen, die über das »Hilfe« Menü verfügbar sind. QF‑Test bietet eine kontextsensitive Hilfe für alle Baumknoten und deren Detailattribute an. Um diese zu nutzen, klicken Sie einfach mit der rechten Maustaste auf den gewünschten Knoten oder das Attribut in der Detailansicht. Im Kontextmenü wählen Sie dann den Eintrag »Was ist das?«. Dieser bringt Sie direkt zur passenden Referenzbeschreibung ins Handbuch. Neben der Hilfestellung in der Dokumentation haben Sie auch die Möglichkeit unser Support-Team zu kontaktieren. Während Ihrer Evaluationsphase und anschließend als Kunde mit einem gültigen Pflegevertrag können Sie Ihre Fragen direkt an unsere Supportexperten richten über das Support-Formular im QF‑Test Hilfe-Menü »Support-Team kontaktieren« oder direkt über unsere Webseite.","hash":"tut_firsthelpweb","h0":"Wo finde ich Hilfe?"},"276":{"id":276,"content":"Pro Tutorial","hash":"","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"277":{"id":277,"content":"Pro Tutorial","hash":"home-link","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"278":{"id":278,"content":"Beenden der Anwendung Wir haben noch nicht die Aufräumsequenz angeschaut und wollen dies nun tun: Expandieren Sie den Aufräumen: Demo beenden Knoten.","hash":"tut_firstcleanupweb","h0":"Beenden der Anwendung"},"279":{"id":279,"content":"Abbildung 10.15: Die Aufräumsequenz Unsere Aufräumsequenz stoppt \"hart\" den Client-Prozess und wartet anschließend, bis sich dieser vollständig beendet hat. Dies ist eine sehr einfache Variante aber für den Moment ausreichend. Führen Sie die Aufräumsequenz aus und lassen Sie damit den Browser mit dem CarConfigurator Demo verschwinden.","hash":"fig_firstCleanupWeb","h4":"Abbildung 10.15: Die Aufräumsequenz"},"280":{"id":280,"content":"Pro Tutorial","hash":"","h0":"Ein vollständiger Testlauf | QF‑Test Tutorial"},"281":{"id":281,"content":"Pro Tutorial","hash":"home-link","h0":"Ein vollständiger Testlauf | QF‑Test Tutorial"},"282":{"id":282,"content":"Ein vollständiger Testlauf Nachdem wir uns Schritt für Schritt durch den Testfallsatz gearbeitet haben, wollen wir nun alles in einem Rutsch ausführen. Schließen Sie bitte das \"CarConfigurator\" Demo, falls es noch läuft. Markieren Sie den Testfallsatz \"Einfache Tests\". Führen Sie ihn aus mittels . Der Testlauf endet mit dem bekannten Fehler. Wenn Sie nun bitte mittels das Protokoll öffnen, sehen Sie, wie QF‑Test den Test abgearbeitet hat.","hash":"tut_firstFullRunWeb","h0":"Ein vollständiger Testlauf"},"283":{"id":283,"content":"Abbildung 10.16: Das Protokoll des gesamten Testfallsatzes Man sieht, dass die Vorbereitungs- und Aufräumenknoten vor bzw. nach jedem Testfall ausgeführt werden. Dies ist eine Eigenschaft, die diese im Zusammenspiel mit einem Testfallsatzknoten entwickeln. Dadurch wird für jeden Testfall immer ein sauberer Ausgangszustand hergestellt. Das SUT nach jedem Testfall zu beenden ist nicht die eleganteste Art, einen sauberen Ausgangszustand zu erreichen. Elegantere Wege zur Herstellung einer definierten Testausgangssituation und Durchführung der notwendigen Aufräumarbeiten werden in Kapitel (\"Abhängigkeiten: Automatisches Sicherstellen der korrekten Vorbedingungen jedes Testfalles\") dieses Tutorials erklärt.","hash":"fig_webRunlogFull","h4":"Abbildung 10.16: Das Protokoll des gesamten Testfallsatzes"},"284":{"id":284,"content":"Pro Tutorial","hash":"","h0":"Reportgenerierung | QF‑Test Tutorial"},"285":{"id":285,"content":"Pro Tutorial","hash":"home-link","h0":"Reportgenerierung | QF‑Test Tutorial"},"286":{"id":286,"content":"Reportgenerierung Im Qualitätssicherungsprozess ist es wichtig, Testergebnisse zu dokumentieren und auch zu archivieren. QF‑Test bietet die Möglichkeit, aus Protokollen Testreports zu generieren. Wir wollen dies für das gerade aufgezeichnete Protokoll beispielhaft durchführen. Öffnen Sie bitte das Protokoll und wählen im Menü »Datei«-»Report erstellen...«.","hash":"tut_firstreportweb","h0":"Reportgenerierung"},"287":{"id":287,"content":"Abbildung 10.17: Auswahldialog für die Reportgenerierung Im ersten Feld können Sie den Dateinamen des Reports festlegen. QF‑Test bietet drei Arten von Reports - HTML, XML und JUnit Format. Das XML-Format können Sie verwenden, wenn Sie die Reports zum Beispiel mit Hilfe eigener XSLT-Stylesheets selbst gestalten wollen. JUnit-Reports erweisen sich als hilfreich, wenn es darum geht, Resultate in Build- oder Testmanagement-Tools zu importieren. Wir wollen uns nun einen einfachen HTML Report zu unserem letzten Testlauf erzeugen lassen. Lassen Sie bitte die vorgegebenen Optionen unverändert. Bestätigen Sie den Reportdialog mit OK. Anschließend sollte sich Ihr Browser automatisch mit einem Ergebnis äquivalent zum folgenden Bild öffnen:","hash":"fig_WebReportDialog","h4":"Abbildung 10.17: Auswahldialog für die Reportgenerierung"},"288":{"id":288,"content":"Abbildung 10.18: Ein HTML Report Der Testbericht beginnt mit einer Zusammenfassung mit allgemeinen Systeminformationen im linken Bereich, einer Legende der verwendeten Symbole rechts, einem Überblicks-Tortendiagramm in der Mitte und dem Gesamtergebnis darunter. In unserem Fall bei einem fehlerhaften von zwei ausgeführten Testfällen eine Erfolgsquote von 50%. Auf die Zusammenfassung folgen drei Übersichten: Testsuiten, die in diesem Testlauf ausgeführt wurden. Testsuiten, in denen Fehler aufgetreten sind. Fehler, mit Ihrem genauen Ort und Fehlermeldung Die Reporterstellung in QF‑Test ist ein praktisches Hilfsmittel, um einen Überblick über einen Testlauf zu gewinnen und ein Dokument zu Präsentations- und Archivierungszwecken zu erstellen.","hash":"fig_webReportHtml","h4":"Abbildung 10.18: Ein HTML Report"},"289":{"id":289,"content":"Pro Tutorial","hash":"","h0":"Erstellen einer eigenen Testsuite (Web) | QF‑Test Tutorial"},"290":{"id":290,"content":"Pro Tutorial","hash":"home-link","h0":"Erstellen einer eigenen Testsuite (Web) | QF‑Test Tutorial"},"291":{"id":291,"content":"Erstellen einer eigenen Testsuite (Web) Dieses Kapitel ist auch als Video verfügbar unter 'Erstellen einer eigenen Testsuite'. In diesem zweiten Kapitel des Web Tutorials werden wir selbst Sequenzen zum Starten und Beenden eines Browsers als SUT erstellen. Zusätzlich wollen wir Aktionen und Checks aufnehmen und damit einen einfachen Testfall aufbauen.","hash":"sec_webtestsuite","h1":"Erstellen einer eigenen Testsuite (Web)"},"292":{"id":292,"content":"Pro Tutorial","hash":"","h0":"Erzeugen der Startsequenz | QF‑Test Tutorial"},"293":{"id":293,"content":"Pro Tutorial","hash":"home-link","h0":"Erzeugen der Startsequenz | QF‑Test Tutorial"},"294":{"id":294,"content":"Erzeugen der Startsequenz Zu Beginn muss die zu testende Anwendung aus QF‑Test heraus gestartet werden. Es gibt einen Schnellstart-Assistenten, der uns hilft, eine passende Startsequenz zu erzeugen. Öffnen Sie bitte eine neue, leere Testsuite mittels »Datei«-»Neue Testsuite...«. Öffnen Sie den Schnellstart-Assistenten über das Menü »Extras«-»Schnellstart-Assistent...«. Im ersten Schritt werden Sie dazu aufgefordert, die Art der zu testenden Applikation auszuwählen. Wählen Sie bitte die zweite Option Eine Web-Anwendung in einem Browser. Drücken Sie Weiter.","hash":"tut_quickstartweb","h0":"Erzeugen der Startsequenz"},"295":{"id":295,"content":"Abbildung 11.1: Auswählen der SUT Art Im zweiten Schritt wird nach der URL der zu testenden Webseite gefragt. Typischerweise gibt man hier eine http(s) basierte URL an. Wir werden jedoch die lokal abgespeicherte CarConfigWeb Demoseite benutzen. Nutzen Sie hierzu den Webseite auswählen Knopf auf der rechten Seite. Wechseln Sie in das Verzeichnis .../qftest-10.0.2-pro/demo/carconfigWeb/html in Ihrer QF‑Test Installation. Wählen Sie dort die Datei CarConfig.htm Schließen die Dateiauswahl ab. Im Bild sieht man eine weitere Möglichkeit: Die Verwendung der Variablen ${qftest:dir.version} am Beginn, die automatisch zum versionsspezifischen Installationsverzeichnis von QF‑Test expandiert. Details zu speziellen QF‑Test Variablen findet Sie im Handbuch Kapitel Variables.","hash":"fig_WizardTypeWeb","h4":"Abbildung 11.1: Auswählen der SUT Art"},"296":{"id":296,"content":"Abbildung 11.2: Auswahl der Programm Datei Drücken Sie den Fertig Knopf, da wir die weiteren optionalen Schritte für unser einfaches Demo nicht benötigen. Für den verwendeten Browser bedeutet das, dass der Standardwert gewählt wird (Chrome für Windows und macOS, Firefox für Linux). Sollte dies bei Ihnen aus irgendwelchen Gründen nicht passen, nutzen Sie den optionalen nächsten Schritt im Assistenten um einen anderen Browser anzugeben. Wir gelangen direkt zur Zusammenfassung, die beschreibt, wie es nach dem Beenden des Schnellstart-Assistenten weiter geht. Drücken Sie den Fertig Knopf, um den Assistenten zu beenden.","hash":"fig_WizardWebUrl","h4":"Abbildung 11.2: Auswahl der Programm Datei"},"297":{"id":297,"content":"Abbildung 11.3: Zusammenfassung Die generierte Startsequenz erscheint in den \"Extrasequenzen\" der Testsuite und ist äquivalent zu der, die wir bereits aus dem letzten Kapitel kennen (\"Starten des Browsers\").","hash":"fig_WizardFinalWeb","h4":"Abbildung 11.3: Zusammenfassung"},"298":{"id":298,"content":"Abbildung 11.4: Generierte Startsequenz Probieren wir sie aus: Stellen Sie bitte sicher, dass der Knoten Vorbereitung: Starte CarConfig_de ausgewählt ist. Drücken Sie oder betätigen Sie einfach die Eingabe Taste. Nach kurzer Zeit sollte ein Browser-Fenster erscheinen. Zuerst wird eine Seite gezeigt, die dann zum CarConfig Demo weiterleitet.","hash":"fig_WizardResultWebOwn","h4":"Abbildung 11.4: Generierte Startsequenz"},"299":{"id":299,"content":"Abbildung 11.5: Das \"CarConfigurator Web\" Demo im Browser Am Ende dieses Abschnitts wollen wir unsere Testsuite speichern. Drücken Sie den Knopf in der Werkzeugleiste oder nutzen Sie die »Datei«-»Speichern« Menüaktion bzw. das Tastenkürzel Strg⁠+⁠S. Im Datei-Explorer navigieren Sie in ein passendes Verzeichnis, in dem Sie Schreibrechte besitzen, z.B. Dokumente in Ihrem Benutzerverzeichnis. Geben Sie einen Namen ein z.B. MeineErstenTests.qft. Beenden Sie die Speicheraktion über den Speichern-Knopf.","hash":"fig_webDemoPage2","h4":"Abbildung 11.5: Das \"CarConfigurator Web\" Demo im Browser"},"300":{"id":300,"content":"Pro Tutorial","hash":"","h0":"Aufnehmen von Aktionen | QF‑Test Tutorial"},"301":{"id":301,"content":"Pro Tutorial","hash":"home-link","h0":"Aufnehmen von Aktionen | QF‑Test Tutorial"},"302":{"id":302,"content":"Aufnehmen von Aktionen Wir werden nun erste Aktionen in unserem Demo aufnehmen:","hash":"tut_recactionsweb","h0":"Aufnehmen von Aktionen"},"303":{"id":303,"content":"Abbildung 11.6: Aktionen im \"CarConfigurator Web\" Demo aufnehmen Drücken Sie dazu den Aufnahmeknopf Wechseln Sie zum \"CarConfigurator Web\" Fenster. Von jetzt ab wird jede Maus- oder Tastaturaktion aufgenommen. Wählen Sie mit der Maus das Modell I5 ganz unten in der Tabelle aus. Wechseln Sie zum Tab Sondermodelle. Wählen Sie dort das Sondermodell Jazz über das Dropdown-Menü. Zum Schluss klicken Sie wieder auf den ersten Tab Fahrzeuge. Beenden Sie die Aufnahme, indem Sie zurück zum QF‑Test Fenster wechseln und dort den Knopf für \"Aufnahme beenden\" drücken. Sie finden die aufgenommene Sequenz unter dem \"Extrasequenzen\" Knoten, wie im folgenden Bild dargestellt.","hash":"fig_webDemoPageRec","h4":"Abbildung 11.6: Aktionen im \"CarConfigurator Web\" Demo aufnehmen"},"304":{"id":304,"content":"Abbildung 11.7: Der Baum nach Aufnahme der Sequenz Als Sequenzname wird standardmäßig Datum und Zeit der Erstellung verwendet. Dieser kann anschließend in den Details rechts beliebig angepasst werden. Ändern Sie den Sequenznamen bitte ab zu \"Modell I5 Jazz wählen\" Öffnen Sie die Sequenz um die enthaltenen Knoten zu sehen. Es sollten die erwarteten Mausklicks sein. Sie sollten sogar in der Lage sein, die angesprochenen Komponenten zuordnen zu können.","hash":"fig_FirstRecordedSequenceWeb","h4":"Abbildung 11.7: Der Baum nach Aufnahme der Sequenz"},"305":{"id":305,"content":"Abbildung 11.8: Die umbenannte Sequenz Wir wollen nun die aufgenommene Sequenz abspielen. Markieren die Sequenz Modell I5 Jazz wählen. Drücken Sie Wiedergabe. Sie sollten die exakt gleichen Aktionen sehen, die Sie zuvor aufgenommen haben. Den aufgenommenen Ablauf sollten Sie auch wiederholt ohne Fehler abspielen können. Rechts unten im Fenster der Testsuite sollte \"Beendet: Keine Fehler\" zu sehen sein. In der Aufnahme hat QF‑Test die funktionalen Einheiten wie Datentabelle, Tab-Reiter und Dropdown-Menü erkannt. Die Ansprache der Unterelemente erfolgt über Index, Details siehe Adressierung von Unterelementen von Tabellen, Bäumen und Listen. Voraussetzung hierfür ist eine passende Konfiguration der Komponentenerkennung. Weitere Informationen siehe Web-Komponentenerkennung.","hash":"fig_FirstRecordedSequenceRenamedWeb","h4":"Abbildung 11.8: Die umbenannte Sequenz"},"306":{"id":306,"content":"Pro Tutorial","hash":"","h0":"Aufnahme von Checks | QF‑Test Tutorial"},"307":{"id":307,"content":"Pro Tutorial","hash":"home-link","h0":"Aufnahme von Checks | QF‑Test Tutorial"},"308":{"id":308,"content":"Aufnahme von Checks Um das Verhalten des Clients zu überprüfen, verwenden wir Check-Knoten, mit denen man Zustand und Eigenschaften von Elementen abfragen kann. Auch Checks können aufgezeichnet werden. Zum Aufnehmen eines Checks drücken Sie den \"Check aufnehmen\" Knopf. Wechseln Sie zum Fenster des SUT. Es erscheint ein Rahmen um die Komponente, über der sich der Mauszeiger befindet. Klicken Sie mit der rechten Maustaste auf das Wertfeld des Endpreises. Das erscheinende Kontextmenü erlaubt Ihnen die Auswahl eines Checks. Die Liste der verfügbaren Checks hängt vom Typ der Komponente ab. Wählen Sie den ersten Eintrag \"Text\", um den textuellen Wert des Feldes zu überprüfen. Beenden Sie die Aufnahme durch Drücken des Stoppknopfs . Wieder taucht die neue Aufnahme unter den \"Extrasequenzen\" auf. Benennen Sie den Sequenzknoten um auf den Namen \"Endpreis prüfen\". Öffnen Sie anschließend den Sequenzknoten, um den Checkknoten zu sehen.","hash":"tut_recchecksweb","h0":"Aufnahme von Checks"},"309":{"id":309,"content":"Abbildung 11.9: Die aufgenommene Check-Sequenz In den Details des \"Check Text\" Knotens sieht man ebenfalls den erwarteten Wert des Endpreis Feldes. Auch diese Sequenz können Sie wieder selbst ausführen, um die Wiedergabe zu testen. Im nächsten Schritt wollen wir aus den beiden Sequenzen einen richtigen Testfall aufbauen.","hash":"fig_TextCheckTreeWeb","h4":"Abbildung 11.9: Die aufgenommene Check-Sequenz"},"310":{"id":310,"content":"Pro Tutorial","hash":"","h0":"Erstellen einer Testsuite | QF‑Test Tutorial"},"311":{"id":311,"content":"Pro Tutorial","hash":"home-link","h0":"Erstellen einer Testsuite | QF‑Test Tutorial"},"312":{"id":312,"content":"Erstellen einer Testsuite Die Basisstruktur unterhalb des Wurzelknotens einer Testsuite ist durch folgende Knoten festgelegt: Eine beliebige Anzahl von \"Testfallsatz\" und \"Testfall\" Knoten, um funktionale Tests zu spezifizieren und zu strukturieren. \"Prozeduren\" - hier können wiederverwertbare Sequenzen in Prozeduren organisiert werden \"Extrasequenzen\" - unsere Spielwiese für Aufnahmen etc. \"Fenster und Komponenten\" - das eigentliche Herz der Testsuite. Hier sind alle aufgenommenen Fenster und Komponenten des SUT mit ihren Eigenschaften enthalten Funktionale Testfälle werden durch \"Testfall\" Knoten repräsentiert und mittels \"Testfallsatz\" Knoten gruppiert bzw. strukturiert. \"Vorbereitung\" und \"Aufräumen\" Knoten können Aktionen enthalten, um einen wohldefinierten Zustand vor und nach einem Testfall sicherzustellen. Wir beginnen mit dem Umbenennen des \"Testfallsatz\" Knotens von \"unbenannt\" in \"Demo Tests\". Falls ein Dialog bzgl. der Aktualisierung von Verweisen erscheint, können wir diesen einfach mit \"Ja\" beantworten. Der nächste Schritt ist, den vom Schnellstart-Assistenten erzeugten Knoten \"Vorbereitung\" in den \"Testfallsatz\" zu verschieben und zwar an die erste Position vor den enthaltenen Testfall. Das Verschieben kann mit Hilfe der Maus (Drag&Drop), des Kontextmenüs (rechte Maustaste Ausschneiden/Einfügen) oder der Tastenkombination Strg⁠+⁠X und Strg⁠+⁠V durchgeführt werden.","hash":"tut_buildtestweb","h0":"Erstellen einer Testsuite"},"313":{"id":313,"content":"Abbildung 11.10: Beginn der Strukturierung Als Nächstes gilt es, aus den beiden vorher aufgezeichneten Sequenzen einen Testfall zu machen. Benennen Sie dazu den Testfall Knoten von \"unbenannt\" in \"Erster\" um. Öffnen Sie den Testfall Knoten durch einen Klick auf das '>' Symbol. Verschieben Sie die beiden Sequenzen aus den \"Extrasequenzen\" in den Testfall. Wenn Sie den Testfall Knoten nicht öffnen, versucht QF‑Test die Sequenzknoten hinter dem Testfall Knoten auf der gleichen Ebene einzufügen. Dies ist jedoch für Sequenzknoten nicht zulässig. QF‑Test nimmt immer Sequenzen auf. Diese haben die gleiche Funktion wie Testschritte. Testschritte werden jedoch im Bericht aufgeführt. Man kann sie ineinander umwandeln, was wir Ihnen in den nächsten Schritten informationshalber zeigen wollen. Öffnen Sie das Kontextmenü für den ersten der beiden Sequenzknoten mit der rechten Maustaste. Wählen Sie »Knoten konvertieren in...«-»Testschritt« Führen Sie dasselbe für den zweiten Sequenzknoten durch.","hash":"fig_beginbuildatest_web","h4":"Abbildung 11.10: Beginn der Strukturierung"},"314":{"id":314,"content":"Abbildung 11.11: Der Baum nach der Neustrukturierung Damit haben wir die wichtigsten Schritte zur Strukturierung unserer Testsuite abgeschlossen.","hash":"fig_buildatest_web","h4":"Abbildung 11.11: Der Baum nach der Neustrukturierung"},"315":{"id":315,"content":"Pro Tutorial","hash":"","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"316":{"id":316,"content":"Pro Tutorial","hash":"home-link","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"317":{"id":317,"content":"Beenden der Anwendung Was uns als Basiselement noch fehlt, ist eine Aufräumsequenz, die das SUT sauber beendet. Es gibt verschiedene Wege eine Anwendung zu beenden, z.B. über den \"Fenster schließen\" Knopf rechts oben, durch Drücken von Alt-F4 oder das Menü »Datei«-»Beenden«. Alle diese Varianten lassen sich direkt aufzeichnen. Wir werden die erste Möglichkeit nutzen: Aufnahme starten . Drücken Sie den Fenster-schließen Knopf des Browsers. Das Fenster der Demoanwendung verschwindet. Aufnahme beenden . Benennen Sie die aufgenommene Sequenz in \"Demo beenden\" um. Öffnen Sie das Kontextmenü für den Sequenzknoten und wählen Sie den Menüpunkt »Knoten konvertieren in...«-»Aufräumen« . Zuletzt verschieben Sie den Aufräumenknoten nach oben, so dass er der letzte Knoten im Testfallsatz ist. Der Aufräumknoten kann nur per Drag and Drop in den Testfallsatz verschoben werden, wenn dessen letzter Kindknoten eingeklappt ist. Um einen Knoten während einer Drag and Drop Operation ein- oder auszuklappen, verweilen Sie einen Moment mit dem Mauszeiger über dem Dreieck neben dem Knoten. Sie sollten folgendes Resultat erhalten:","hash":"tut_cleanupweb","h0":"Beenden der Anwendung"},"318":{"id":318,"content":"Abbildung 11.12: Die einfache Aufräumsequenz Damit haben wir die wichtigsten Schritte zur Strukturierung unserer Testsuite abgeschlossen.","hash":"fig_StopSequenceWeb","h4":"Abbildung 11.12: Die einfache Aufräumsequenz"},"319":{"id":319,"content":"Pro Tutorial","hash":"","h0":"Gesamte Suite ausführen | QF‑Test Tutorial"},"320":{"id":320,"content":"Pro Tutorial","hash":"home-link","h0":"Gesamte Suite ausführen | QF‑Test Tutorial"},"321":{"id":321,"content":"Gesamte Suite ausführen Als Abschluss wollen wir unsere neue Suite ausführen: Beenden Sie dazu nun bitte den SUT Client, falls er läuft. Markieren Sie den \"Testsuite\" Wurzelknoten. Führen Sie diesen durch Drücken von \"Wiedergabe\" oder der Eingabe Taste aus. Das SUT sollte erscheinen, der Testfall aufgeführt und das SUT wieder beendet werden. Wie wir wissen, wird das Ergebnis des Testlaufs im Protokoll festgehalten: Um dieses anzuschauen, können wir den Button \"Protokoll anzeigen\" in der Werkzeugleiste oder alternative die Tastenkombination Strg⁠+⁠L nutzen.","hash":"tut_runownsuiteweb","h0":"Gesamte Suite ausführen"},"322":{"id":322,"content":"Abbildung 11.13: Der Protokollbaum der eigenen Testsuite Wir hatten bereits im ersten Kapitel gesehen, wie das Protokoll für die Fehleranalyse genutzt werden kann.","hash":"fig_FirstRunLogWeb","h4":"Abbildung 11.13: Der Protokollbaum der eigenen Testsuite"},"323":{"id":323,"content":"Pro Tutorial","hash":"","h0":"Eine Prozedur erstellen (Web) | QF‑Test Tutorial"},"324":{"id":324,"content":"Pro Tutorial","hash":"home-link","h0":"Eine Prozedur erstellen (Web) | QF‑Test Tutorial"},"325":{"id":325,"content":"Eine Prozedur erstellen (Web) Dieses Kapitel ist auch als Video verfügbar unter 'Eine Prozedur erstellen'. In den beiden vorherigen Kapiteln haben Sie gelernt wie man eine Applikation über QF‑Test startet, so dass Maus- und Tastatureingaben aufgenommen werden können, auch wie man Checks aufnimmt und wie man das Ergebnis zu einem Testfall zusammenfasst. Diese Herangehensweise ist ausreichend, solange die Tests einfach und nicht allzu viele sind. Sobald jedoch die Zahl der Tests zunimmt, ist es wichtig, sogenannte \"Prozeduren\" einzusetzen. Prozeduren sind ein Mittel um Sequenzen wiederverwendbar zu machen und damit Doppelvorkommen zu vermeiden. Dies ist wichtig, um eine einfache und effiziente Wartbarkeit von Tests über die Zeit zu erreichen. Prozeduren können in Packages gruppiert werden. Prozeduren und Packages sind die Basis für die Modularisierung der Tests.","hash":"sec_FirstProzedurWeb","h1":"Eine Prozedur erstellen (Web)"},"326":{"id":326,"content":"Pro Tutorial","hash":"","h0":"Wiederverwendbare Abschnitte identifizieren | QF‑Test Tutorial"},"327":{"id":327,"content":"Pro Tutorial","hash":"home-link","h0":"Wiederverwendbare Abschnitte identifizieren | QF‑Test Tutorial"},"328":{"id":328,"content":"Wiederverwendbare Abschnitte identifizieren In diesem Abschnitt werden wir die Testsuite ErsteWebTests.qft, die Sie bereits aus Kapitel 1 kennen, weiterentwickeln. Kopieren Sie ErsteWebTests.qft aus dem Unterverzeichnis qftest-10.0.2-pro/doc/tutorial der QF‑Test Installation in ein Arbeitsverzeichnis und öffnen Sie ErsteWebTests.qft. Wenn Sie die Änderung, die wir an der Demo-Testsuite vornehmen werden, sichern wollen, so speichern Sie diese in einem Arbeitsverzeichnis wie am Ende von \"Erzeugen der Startsequenz\" beschrieben. Bitte sehen Sie sich den Testschritt \"Zurücksetzen\" in den beiden Testfällen an. Die beiden Testschritte sind identisch.","hash":"tut_procreuseweb","h0":"Wiederverwendbare Abschnitte identifizieren"},"329":{"id":329,"content":"Abbildung 12.1: Zwei identische Testschritte Gemäß obiger Überlegungen wäre es also sinnvoll, den Testschritt in eine Prozedur umzuwandeln.","hash":"IdenticalTeststepsWeb","h4":"Abbildung 12.1: Zwei identische Testschritte"},"330":{"id":330,"content":"Pro Tutorial","hash":"","h0":"Manuelle Erstellung von Prozeduren | QF‑Test Tutorial"},"331":{"id":331,"content":"Pro Tutorial","hash":"home-link","h0":"Manuelle Erstellung von Prozeduren | QF‑Test Tutorial"},"332":{"id":332,"content":"Manuelle Erstellung von Prozeduren Es gibt mehrere Methoden Prozeduren zu erstellen und Prozeduraufrufe einzufügen. Wir fangen mit der manuellen an, bei der ein (leerer) Prozedurknoten eingefügt wird, in den dann die entsprechenden Aktionen verschoben werden. Danach erstellen wir den zugehörigen Prozeduraufruf. Es ist gut, wenn man diese grundlegenden Schritte kennt. Es gibt jedoch eine zweite, elegantere Methode Prozeduren zu erstellen, die wir im Anschluss zeigen werden. Also los, fügen wir eine Prozedur von Hand ein: Wir beginnen mit dem Anlegen des Prozedurknotens, dem wir einen geeigneten Namen geben. Öffnen Sie den Prozeduren Knoten und achten Sie darauf, dass er auch selektiert (blau markiert) ist. Wählen Sie »Einfügen«-»Prozedurknoten«-»Prozedur«. Tragen Sie als Name \"zurücksetzen\" ein. Die anderen Felder brauchen nicht befüllt zu werden. Öffnen Sie die neu erstellte \"zurücksetzen\" Prozedur.","hash":"tut_procmanualweb","h0":"Manuelle Erstellung von Prozeduren"},"333":{"id":333,"content":"Abbildung 12.2: Prozedurknoten erstellen Im zweiten Schritt befüllen wir die Prozedur mit den entsprechenden wiederverwendbaren Aktionen. Selektieren Sie die drei \"Mausklick\" Knoten im Testschritt. Um mehr als einen Knoten zu selektieren, klicken Sie den ersten der Knoten an, dann drücken Sie die Shift Taste und klicken den letzten der zu selektierenden Knoten während Sie die Shift Taste gedrückt halten. Verschieben Sie diese nach unten in die Prozedur, z.B. mit der Maus (Drag and drop) oder über Ausschneiden/Einfügen im Menü »Bearbeiten« oder über das Kontextmenü.","hash":"ProcedureNodeInFirstTestcaseWeb","h4":"Abbildung 12.2: Prozedurknoten erstellen"},"334":{"id":334,"content":"Abbildung 12.3: Prozedur mit Inhalt befüllen Im dritten Schritt fügen wir einen Prozeduraufruf an Stelle der drei verschobenen Mausklicks ein. Selektieren Sie den Testschritt \"Zurücksetzen\", der geöffnet sein sollte. Wählen Sie den Menüpunkt »Einfügen«-»Prozedurknoten«-»Prozeduraufruf« oder verwenden Sie das Tastaturkürzel Strg⁠+⁠A.","hash":"procedureContentInFirstTestcaseWeb","h4":"Abbildung 12.3: Prozedur mit Inhalt befüllen"},"335":{"id":335,"content":"Abbildung 12.4: Prozeduraufruf einfügen Drücken Sie den Prozedur-Auswahlknopf links neben der Beschriftung \"Name der Prozedur\". Wählen Sie \"zurücksetzen\" aus der Prozedurliste. Weitere Eingaben sind nicht nötig. Drücken Sie OK um die Erstellung des Prozeduraufrufs abzuschließen.","hash":"AddProcedureCallWeb","h4":"Abbildung 12.4: Prozeduraufruf einfügen"},"336":{"id":336,"content":"Abbildung 12.5: Prozedur auswählen Um wirklich einen Mehrwert durch die Prozedur zu erlangen, müssen wir nun den Inhalt des Testschritts im zweiten Testfall ebenfalls durch einen Aufruf der Prozedur \"zurücksetzen\" ersetzen. Sie können dies wie oben beschrieben tun oder Sie führen folgende alternative Schritte zur Erstellung des Prozeduraufrufs aus: Öffnen Sie den Testschritt 'Zurücksetzen' des zweiten Testfalls. Löschen Sie die drei Mausklick Knoten daraus. Selektieren Sie den Prozedurknoten \"zurücksetzen\". Ziehen Sie den Prozedurknoten \"zurücksetzen\" mit der Maus in den Testschrittknoten. Kopieren/einfügen kann ebenfalls verwendet werden. Dadurch wird der Prozedurknoten nicht verschoben, sondern ein entsprechender Prozeduraufruf erzeugt. Die Testsuite sollte anschließend wie folgt aussehen:","hash":"SelectProcedureWeb","h4":"Abbildung 12.5: Prozedur auswählen"},"337":{"id":337,"content":"Abbildung 12.6: Testsuite mit Prozedur Wenn Sie nun die Testfälle ausführen, sollten diese funktionieren wie zuvor. Im Protokoll sind jetzt auch die Prozeduraufrufe und deren Ausführung zu sehen.","hash":"fig_testsuite_with_Procedure_web","h4":"Abbildung 12.6: Testsuite mit Prozedur"},"338":{"id":338,"content":"Pro Tutorial","hash":"","h0":"Knoten in Prozedur konvertieren | QF‑Test Tutorial"},"339":{"id":339,"content":"Pro Tutorial","hash":"home-link","h0":"Knoten in Prozedur konvertieren | QF‑Test Tutorial"},"340":{"id":340,"content":"Knoten in Prozedur konvertieren Wie bereits am Anfang des letzten Abschnitts erwähnt, bietet QF‑Test eine Alternative um Prozeduren wesentlich schneller zu erstellen. Markieren Sie den Testschritt oder Sequenz-Knoten, der die wiederverwendbaren Schritte enthält, die zur Prozedur umgewandelt werden sollen. Wählen Sie den Menüpunkt »Operationen«-»Knoten konvertieren in«-»Prozedur« aus oder verwenden Sie das Tastaturkürzel Strg⁠+⁠Umschalt⁠+⁠P. Wie Sie sehen, ist der Testschritt bzw. der Sequenzknoten verschwunden. Anstelle dessen befindet sich ein Prozeduraufruf. Außerdem wurde eine Prozedur mit dem Namen des ehemaligen Testschritts bzw. der Sequenz im Abschnitt \"Prozeduren\" erstellt. Sie enthält genau die gleichen Kindknoten wie zuvor der Testschritt bzw. die Sequenz. Bei der Aufnahme einer Sequenz in QF‑Test hat sich das Vorgehen bewährt, der Sequenz sofort einen Namen zu geben und sie anschließend in eine Prozedur zu konvertieren. Auch wenn man nur eine Vermutung hat, dass sich die aufgenommenen Schritte irgendwo wiederholen könnten.","hash":"tut_proctransformweb","h0":"Knoten in Prozedur konvertieren"},"341":{"id":341,"content":"Pro Tutorial","hash":"","h0":"Komponenten (Web) | QF‑Test Tutorial"},"342":{"id":342,"content":"Pro Tutorial","hash":"home-link","h0":"Komponenten (Web) | QF‑Test Tutorial"},"343":{"id":343,"content":"Komponenten (Web) Dieses Kapitel ist auch als Video verfügbar unter 'Komponenten'. Werfen wir nun einen Blick auf den letzten verbleibenden Bereich des Testsuite Fensters, den Fenster und Komponenten Knoten. Zuvor möchten wir Ihnen jedoch zeigen, wie Unterelemente von Komponenten wie Tabellen, Bäumen und Listen adressiert werden.","hash":"sec_ComplexComponentsWeb","h1":"Komponenten (Web)"},"344":{"id":344,"content":"Pro Tutorial","hash":"","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen | QF‑Test Tutorial"},"345":{"id":345,"content":"Pro Tutorial","hash":"home-link","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen | QF‑Test Tutorial"},"346":{"id":346,"content":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen Unterelemente von Tabellen, Bäumen und Listen werden über Indizes angesprochen. Die wichtigsten beiden Indextypen sind der numerische und der Textindex. Zur Demonstration nehmen wir als nächstes einen Mausklick auf eine Tabellenzelle auf und sehen uns die aufgenommene QF‑Test ID der Komponente näher an. Starten Sie das CarConfig Demo, falls dieses nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf eine Tabellenzelle, z.B. das erste Modell. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Den aufgenommenen Mausklick finden Sie im Bereich Extrasequenzen.","hash":"sec_addressing_complex_components_web","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen"},"347":{"id":347,"content":"Abbildung 13.1: Adressierung einer Tabellenzelle Die aufgenommene QF‑Test ID der Komponente ist VehicleTable@Modell&0. Sie setzt sich aus den folgenden Teilen zusammen: VehicleTable ist die QF‑Test ID der Komponente der Tabelle selbst. @ und & trennen die einzelnen Teile voneinander. Gleichzeitig definieren sie den Typ des darauf folgenden Index: auf @ folgt ein Textindex, auf & ein numerischer Index. Modell ist der Textindex für die Spalte mit der Überschrift 'Modell'. 0 ist der numerische Index für die erste Tabellenzeile. Numerische Indizes beginnen immer mit 0. Sie können beide Indextypen für Zeilen und Spalten verwenden. Dabei ist nur wichtig, dass das Trennzeichen und der Typ des folgenden Index zusammenpassen. Ändern Sie die QF‑Test ID der Komponente so, dass das dritte Preisfeld adressiert wird. Verwenden Sie dafür numerische Indizes. Die Lösung hierfür lautet VehicleTable&1&2. Um das Modell 'I5' über Textindizes anzusprechen, tragen Sie VehicleTable@Modell@I5 ein. Das gleiche Feld kann man numerisch mittels VehicleTable&0&4 ansprechen oder mit gemischten Indizes mittels VehicleTable&0@I5 oder VehicleTable@Modell&4. Der dritte Indextyp von QF‑Test ist ein Index mit regulärem Ausdruck. Reguläre Ausdrücke werden verwendet, um Zeichenketten durch einen Ausdruck zu ersetzen, der verschiedene Zeichenketten adressieren kann. Sozusagen eine \"Sternchensuche\", wobei reguläre Ausdrücke wesentlich mächtiger sind und eine eigene Syntax besitzen. Eine genauere Beschreibung regulärer Ausdrücke finden Sie im Handbuch. Beispiel: Das Modell 'I5' könnte man also auch über VehicleTable@Modell%I.* ansprechen. Listen werden analog zu Tabellen adressiert, nur dass sie nur einen einzigen Index benötigen. Bäume haben ebenfalls nur einen einzigen Index. Dieser ist der Pfad durch den Baum zu dem adressierten Baumknoten. Der Pfad setzt sich aus den einzelnen Knoten zusammen, die durch Schrägstriche (\"/\") voneinander getrennt werden. Starten Sie das CarConfig Demo, falls dieses nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Öffnen Sie das Baum-Beispiel: Wählen Sie im CarConfig Demo den Menüpunkt »Einstellungen«-»Sondermodelle...«, selektieren Sie ein Modell und drücken die Schaltfläche 'Details'. Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf einen Baumknoten, z.B. 'Beschreibung'. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Für den Baumknoten \"Beschreibung\" wird die folgende QF‑Test ID der Komponente aufgenommen: DetailsTree@/Information/Beschreibung. Die einzelnen Bestandteile davon sind: DetailsTree ist die QF‑Test ID der Komponente des Baums selbst. @ trennt die QF‑Test ID der Komponente des Baums vom Index. Die Syntax ist hierbei analog zu der der Tabellenindizes, d.h. @ steht für einen Textindex, & für einen numerischen Index und % für einen Index mit regulärem Ausdruck. /Information/Beschreibung ist der Textindex für den Baumpfad zum Knoten 'Beschreibung'. Wenn Sie den Knoten über einen numerischen Index adressieren wollen, verwenden Sie DetailsTree&/0/1.","hash":"fig_components_tableindex_web","h4":"Abbildung 13.1: Adressierung einer Tabellenzelle"},"348":{"id":348,"content":"Pro Tutorial","hash":"","h0":"Web-Komponentenerkennung | QF‑Test Tutorial"},"349":{"id":349,"content":"Pro Tutorial","hash":"home-link","h0":"Web-Komponentenerkennung | QF‑Test Tutorial"},"350":{"id":350,"content":"Web-Komponentenerkennung Die Adressierung von Unterelementen komplexer Komponenten wie Listen, Tabellen und Bäumen, via Index, wie im letzten Abschnitt beschrieben, ist nur möglich, weil im Rahmen der erzeugten Vorbereitung eine Konfiguration der Komponentenerkennung erfolgt. Damit wird QF‑Test mitgeteilt, wie bestimmte Funktionalitäten wie Textfelder, Buttons, Checkboxen, Datentabellen, Bäume etc. im HTML-Code der Applikation implementiert sind. Wenn die Funktionalität einer Komponente bekannt ist, hat dies bei der Aufnahme folgende Vorteile: Unterelemente werden, wie bereits bekannt, über Index angesprochen und nicht als Einzelkomponente aufgenommen. Bei Mausklicks wird die Stelle, an die später der Klick abgespielt werden soll, hinterlegt. So zum Beispiel Buttons am besten mittig, Textfelder hingegen genau an der gleichen Stelle wie bei der Aufnahme, damit Text bei Bedarf passend eingefügt wird. Für die Aufnahme von Checks passt QF‑Test das Popup-Menü entsprechend an. So können zum Beispiel für Tabellen Checks für ganze Spalten oder Zeilen aufgenommen werden. Bei Textfeldern hingegen wird ein zusätzlicher Check bezüglich Editierbarkeit angeboten. Auch bei der Speicherung von Merkmalen für die Komponentenerkennung berücksichtigt QF‑Test die Funktionalität. Beim Button ist zum Beispiel die Beschriftung des Buttons selbst ein wichtiges Wiedererkennungsmerkmal. Bei Textfeldern hingegen ist es wenig sinnvoll, den jeweiligen Text abzuspeichern. Hier sucht QF‑Test nach einer passenden Beschriftung und speichert diese ab. Außerdem wirken sich die Informationen, die auf Grund der bekannten Funktionalität zusätzlich abgespeichert wurden, positiv auf die Stabilität der Tests aus. Die Konfiguration der Komponentenerkennung ist notwendig, da Web-Anwendungen einen begrenzten Satz von Basiskomponenten haben, die in sehr flexibler Weise genutzt werden können, um komplexe Komponenten und Designs aufzubauen. Ein Beispiel sind HTML Tabellen, die sowohl für das Seitenlayout genutzt werden als auch für die Darstellung logischer Tabellen wie der Fahrzeugtabelle. Ohne zusätzliche Informationen kann QF‑Test nicht wissen, wo genau die Layout-Tabelle endet und die logische Tabelle beginnt. Die Tabellenzelle würde nicht als solche erkannt und als eigene Komponente, z.B. VehicleTable.td, aufgezeichnet. Das \"td\" kommt vom HTML Table Data Element \"TD\", das im vorliegenden HTML-Code die Tabellenzelle darstellt. In der Vorbereitung in der Demosuite ErsteWebTests.qft aus dem ersten Kapitel oder auch in der über den Schnellstart-Assistenten im zweiten Kapitel erstellte, erfolgt die Konfiguration direkt nach dem Browser-Start. Das folgende Bild zeigt den Knoten für die Registrierung der Resolver in der Testsuite ErsteWebTests.qft.","hash":"tut_custemwebresolver","h0":"Web-Komponentenerkennung"},"351":{"id":351,"content":"Abbildung 13.2: Web Resolver Registrierung in der ErsteWebTests.qft Über den Knoten erhält QF‑Test z.B. die Information, welches HTML-Element eine Datentabelle enthält und welche HTML-Elemente darin dann die Zeilen und Datenzellen darstellen. Diese Konfiguration wurde speziell für den \"CarConfigurator Web\" erstellt. An dieser Stelle ist es nur wichtig, dass Sie wissen, dass es verschiedene Möglichkeiten gibt, die Komponentenerkennung durch Resolver zu verbessern. QF‑Test analysiert automatisch die Struktur von Web-Anwendungen, erkennt die meistverwendeten Web GUI Toolkits (wie Angular Material, ExtJS, GWT, SmartGWT, Vaadin,...) und installiert passende vordefinierte Resolver. Offensichtlich sind aber nicht alle Web-Anwendungen ausschließlich mit solch einem Toolkit entwickelt und nicht für alle Toolkits gibt es vordefinierte Resolver in QF‑Test. Sie können durchaus auch auf selbstentwickelte Komponenten stoßen. Wenn Sie also mit dem Testen Ihrer eignen Web-Anwendung beginnen und auf Schwierigkeiten stoßen, dass Komponenten beim Abspielen von Aktionen nicht verlässlich wieder erkannt werden, dann kann es Zeit sein, über einen Resolver nachzudenken. Sollten Sie für die Resolvererstellung Hilfe benötigen, kontaktieren Sie bitte unser Support-Team für Unterstützung. Es gibt ein Kapitel in der Technischen Referenz des Handbuchs, das tiefergehende Informationen zu CustomWebResolvern enthält und auch wie man bei der Implementierung eines solchen vorgeht, wenn Sie dies probieren möchten.","hash":"figure_13.2","h4":"Abbildung 13.2: Web Resolver Registrierung in der ErsteWebTests.qft"},"352":{"id":352,"content":"Pro Tutorial","hash":"","h0":"Der Bereich Fenster und Komponenten | QF‑Test Tutorial"},"353":{"id":353,"content":"Pro Tutorial","hash":"home-link","h0":"Der Bereich Fenster und Komponenten | QF‑Test Tutorial"},"354":{"id":354,"content":"Der Bereich Fenster und Komponenten Zum Thema \"Komponenten\" gibt es mehrere Videos: Das Video 'Komponentenerkennung' erläutert zunächst die Wiedererkennungskriterien für Komponenten, danach (ab Minute 13:07) werden generische Komponenten erläutert, zuerst solche mit regulären Ausdrücken, danach solche mit Variablen für die Wiedererkennungsmerkmale. Es gibt zwei Videos, die die Behandlung einer ComponentNotFoundException ausführlich erklären: Ein einfacher Fall wird im Video 'ComponentNotFoundException - einfacher Fall' erläutert. Einen komplexeren Fall gibt es in 'ComponentNotFoundException - komplexer Fall'. Das Video 'Die Explosion der Komplexität in der Web Testautomatisierung eindämmen' zeigt eindrucksvoll den Umgang von QF‑Test mit tief geschachtelten DOM-Strukturen. Video-Mitschnitt des Spezialwebinars 'Komponentenerkennung'. QF‑Test speichert die Informationen, wie es die im GUI des SUT angezeigten Komponenten wiederfindet, im Bereich Fenster und Komponenten ab. Dabei analysiert QF‑Test bei der Aufnahme die erhaltenen GUI-Element-Informationen und speichert diejenigen, mit denen der Anwender interagiert hat, in den Details der Komponente Knoten ab. In diesem Abschnitt wollen wir Ihnen eine Vorstellung davon vermitteln, welche Informationen in Komponente Knoten abgespeichert werden und wie diese von QF‑Test für die Wiedererkennung verwendet werden. Es gibt zwei Fälle bei denen Sie sich mit Komponenten befassen müssen und wo ein Grundverständnis für die Komponentenerkennung hilfreich ist. Der erste Fall betrifft Änderungen im GUI zwischen dem Zeitpunkt der Aufnahme und demjenigen, wenn Sie einen Test abspielen wollen, wie dies z.B. bei einer neuen Version der Anwendung passieren kann. QF‑Test verfügt zwar über eine Reihe von Algorithmen zur Komponentenerkennung, so dass diese im allgemeinen stabil ist. Wenn sich aber zu viele Merkmale des GUI-Elements verändert haben, müssen Sie die Änderungen in der Testsuite nachziehen und entweder die Details des vorhandenen Komponente Knoten anpassen oder das GUI-Element neu aufnehmen. Detaillierte Informationen zur Vorgehensweise finden Sie im Handbuch, Kapitel Lösung von Problemen bei der Wiedererkennung. Dort gibt es auch Links auf Videos mit entsprechenden Beispielen. Im zweiten Fall geht es um die Verbesserung der Komponentenerkennung. Wie Sie bereits aus Kapitel Web-Komponentenerkennung wissen, werden bei Web-Anwendungen die funktionalen Komponenten wie Checkbox oder Tabelle, sogar Eingabefelder, in mannigfaltiger Art und Weise aus den verfügbaren HTML Basiskomponenten erstellt. So kommt es immer wieder vor, dass QF‑Test bei einem GUI-Element nicht erkennen kann, welche Funktionalität es aus Anwendersicht erfüllen soll. Für solche Fälle stehen sogenannte \"Resolver\" zur Verfügung. Wie diese eingesetzt werden, ist im technischen Teil des Handbuchs im Kapitel 'CustomWebResolver' erläutert. Wir wollen uns nun anhand einer 'TextField' Komponente die von QF‑Test analysierten und abgespeicherten Merkmale ansehen. Starten Sie das CarConfig Demo, falls dies nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Öffnen Sie die Prozedur 'Endpreis prüfen'. Öffnen Sie das Kontextmenü des 'Check Text'-Knotens. Springen Sie zum Knoten der Komponente über den Menüpunkt »Komponente finden« im Popup-Menü oder über das Tastaturkürzel Strg⁠+⁠W.","hash":"sec_componentsteps_web","h0":"Der Bereich Fenster und Komponenten"},"355":{"id":355,"content":"Abbildung 13.3: Komponente finden Dadurch gelangen Sie direkt zum Knoten 'TextField CalculatedPrice' im Bereich Fenster und Komponenten.","hash":"fig_components_locate_web","h4":"Abbildung 13.3: Komponente finden"},"356":{"id":356,"content":"Abbildung 13.4: Komponentenbaum Dieser Komponentenbaum hat nur wenige Ebenen. Dies ist eine Wirkung der in \"Web-Komponentenerkennung\" beschriebenen verbesserten Web-Komponentenerkennung. Wenn Sie sich den Komponentenbaum in der in \"Erstellen einer eigenen Testsuite (Web)\" erstellten eigenen Testsuite ansehen, werden Sie feststellen, dass dort eine große Anzahl an DIV-Ebenen aufgenommen wird. Diese sind auf der HTML-Seite definiert. Für die Komponentenerkennung sind sie jedoch nicht relevant bzw. sogar störend. Daher wird ihre Aufnahme mittels des CustomWebResolvers in der Demo-Testsuite unterdrückt. Für den Komponente Knoten mit der QF‑Test ID CalculatedPrice sehen die Details wie folgt aus:","hash":"fig_components_tree_web","h4":"Abbildung 13.4: Komponentenbaum"},"357":{"id":357,"content":"Abbildung 13.5: Details eines Komponente Knoten Wie werden die Attribute des Komponente Knotens zur Wiedererkennung der GUI-Elemente eingesetzt? Das erste Attribut ist QF‑Test ID, das in den Testfällen und Prozeduren zur Ansprache der Komponente verwendet wird. Alle anderen Attribute beziehen sich auf Eigenschaften des GUI-Elements. Das folgende Attribut ist die Klasse. In unserem Fall TextField. Für die Komponentenerkennung ist die Klasse ein eindeutiges Merkmal. Die angezeigte Klasse ist eine von QF‑Test verallgemeinerte Klasse. Durch diese generische Klasse werden die Tests unabhängig von der konkreten Implementierung und können leicht portiert werden. Die speziellen Werte werden in der Tabelle \"Weitere Merkmale\" abgespeichert. Sie spielen standardmäßig für die Erkennung keine Rolle, können aber für Sonderfälle genutzt werden. Weitere Beispiele für generische Klassen sind \"Panel\", \"Dialog\" und \"Button\". Dass Attribut \"Name\" enthält den Namen oder die Id, die dem GUI-Element seitens des Programmierers gegeben wurde. Falls ein Name vorhanden ist, ist dies für QF‑Test zusammen mit der Klasse zur Komponentenerkennung ausreichend. Die übrigen Attribute bleiben dann unberücksichtigt. Wenn weder ein Name noch eine Id durch den Entwickler gesetzt wurde und das Attribut \"Name\" daher keinen Wert enthält, verwendet QF‑Test andere Kriterien für die Erkennung wie z.B. einen bestimmten Text, der zur Komponente gehört, Index und Geometrie. Ein zur Komponente gehörendes Merkmal wäre bei einer Schaltfläche zum Beispiel der darauf angezeigte Text. QF‑Test speichert Texte, die direkt zur Komponente gehören im Attribut \"Merkmal\" ab. Wenn das Web-Element keinen Text enthält, jedoch eine Id vorhanden ist, so wird diese im Attribut \"Merkmal\" abgespeichert. Wenn keines von beiden vorhanden ist, dann ein Text in der Nähe der Komponente, den QF‑Test als mögliche Beschriftung identifiziert, ebenfalls im Merkmal-Attribut abgespeichert werden. Auf jeden Fall wird dieser Text in der Tabelle \"Weitere Merkmale\" unter dem Namen qfs:label gespeichert. Die Struktur Informationen beziehen sich auf alle GUI-Elemente der jeweiligen Klasse. Die Gesamtzahl der GUI-Elemente der Klasse wird im Attribut \"Insgesamt\", der Index der Komponente selbst im Attribut \"Index\" abgespeichert. Am Schluss befinden sich die Werte für die Geometrie. Diese erhalten im Wiedererkennungsalgorithmus die geringste Gewichtung. In seltenen Fällen kann es jedoch vorkommen, dass sie die einzigen Kennzeichen sind, die zur Identifizierung des GUI-Elements zur Verfügung stehen. Wenn Sie an weiteren Details zum genauen Ablauf bei der Wiedererkennung interessiert sind, können Sie diese im Kapitel Komponentenerkennung der technischen Referenz im Handbuch nachlesen. Um ein Gefühl für die Komponentenerkennung zu erhalten, können Sie ein bisschen mit den Attributwerten herumspielen, bis QF‑Test das GUI-Element nicht mehr findet oder sogar eine falsche Komponente auswählt. Sie werden feststellen, dass die Änderungen beträchtlich sein müssen, bevor QF‑Test ein falsches GUI-Element identifiziert. Das heißt, dass die Komponentenerkennung von QF‑Test sehr robust ist und sich bei neuen Versionen einer Anwendung ein erheblicher Anteil der Attribute eines GUI-Elements verändern kann, bevor die Komponentenerkennung fehlschlägt - selbst wenn das GUI-Element keinen Namen oder keine Id hat. Beim Klick auf einen Komponente Knoten markiert QF‑Test das erkannte GUI-Element mit einem dunkelblauen Rand. Löschen Sie den Wert CalculatedPrice aus dem Name-Attribut, da QF‑Test sonst die nachfolgenden Attribute nicht berücksichtigt. Bitte ändern Sie in der Tabelle Extra features den Status des weiteren Merkmals mit dem Namen id von Sollte übereinstimmen auf Ignorieren . Ändern Sie das Merkmal-Attribut von CalculatedPrice auf xxx. Klicken Sie auf den \"TextField\" Knoten um zu sehen, ob QF‑Test immer noch das Endpreis-Feld markiert. Setzen Sie das Merkmal-Attribut zurück auf CalculatedPrice, entweder über den entsprechenden Button in der Werkzeugleiste oder über das Tastaturkürzel Ctrl⁠+⁠Z. Ändern Sie den Wert von qfs:label in der Weitere-Merkmale-Tabelle von Endpreis auf Rabatt. Klicken Sie auf den \"TextField\" Knoten um zu sehen, ob QF‑Test immer noch das Endpreis-Feld markiert. Setzen Sie den Wert von qfs:label in der Weitere-Merkmale-Tabelle zurück auf Endpreis. Setzen Sie alle Struktur- und Geometrie-Attribute auf andere Werte und überprüfen Sie, ob QF‑Test immer noch das Endpreisfeld im GUI markiert. Löschen Sie das Merkmal-Attribut and Ändern Sie den Wert von qfs:label in der Weitere-Merkmale-Tabelle von Endpreis auf Rabatt. Nun markiert QF‑Test das Rabattfeld. Diese Übung ist nur eine kleine Spielerei mit der Komponentenerkennung. Konkrete Informationen, wie Sie bei Problemen mit der Komponentenerkennung umgehen, finden Sie in den oben genannten und weiteren Kapiteln im Handbuch.","hash":"fig_components_details_web","h4":"Abbildung 13.5: Details eines Komponente Knoten"},"358":{"id":358,"content":"Pro Tutorial","hash":"","h0":"SmartIDs - direkte Komponentenadressierung | QF‑Test Tutorial"},"359":{"id":359,"content":"Pro Tutorial","hash":"home-link","h0":"SmartIDs - direkte Komponentenadressierung | QF‑Test Tutorial"},"360":{"id":360,"content":"SmartIDs - direkte Komponentenadressierung Seit QF‑Test 7.0 bieten SmartIDs offiziell die Möglichkeit, Komponenten ohne Aufnahme eines Komponente Knoten zu referenzieren. Für gewisse Anwendungen kann dies die Verwaltung und Pflege der Komponenteninformationen stark vereinfachen. Auch auf die Editier- und Lesbarkeit der Tests können SmartIDs positiven Einfluss haben. Nicht zuletzt bietet dies die Möglichkeit, Tests auch ohne Aufnahmefunktion zu erstellen, zum Beispiel, wenn eine Komponente oder die gesamte Anwendung noch gar nicht vorhanden ist, man den Test aber bereits implementieren möchte (\"Test first\" Ansatz). Als Wiedererkennungskriterien stehen die Komponentenklasse, deren Name oder Beschriftung und der Index zur Verfügung. Die Werte sind die gleichen wie beim aufgenommenen Komponente Knoten. Zudem können auch Komponentenhierarchien abgebildet werden. Eine SmartID wird an Stelle der QF‑Test ID der Komponente verwendet. Ihr Kennzeichen ist die Raute # als erstes Zeichen. Anschließend kann der Name oder die Beschriftung der Komponente geschrieben werden, zum Beispiel: #btnOK, mit \"btnOK\" als Namen der Komponente oder #Vorname, mit \"Vorname\" als Beschriftung der Komponente. Der Nachteil dieser einfachen Form der SmartID kann die Performanz bei der Wiedergabe sein, da QF‑Test alle Komponenten nach diesen Kriterien durchsuchen muss. Aus diesem Grund ist es sinnvoll, die Klasse der Komponente mit anzugeben. Obige SmartIDs könnten dann so aussehen: #Button:btnOK #TextField:Vorname Aktuell ist die Aufnahme von SmartIDs nicht als Standard aktiviert, kann aber direkt über das Menü eingeschaltet werden. Nehmen Sie nun SmartIDs auf, indem Sie im Menü Aufnahme die Einstellung Aufnahme von SmartIDs anhaken. Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf ein Textfeld, z.B. das Eingabefeld für den Rabatt, Klicken Sie auf eine Tabellenzelle, z.B. das erste Modell. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Die aufgenommenen Mausklicks finden Sie im Bereich Extrasequenzen. Die SmartID für das Eingabefeld lautet #TextField:name=DiscountValue, da der Name bevorzugt für die SmartID verwendet wird, wenn Name und Beschriftung vorhanden sind. Der zweite Mausklick zeigt die Aufnahme der Tabelle als SmartID und daran anschließend einen Textindex für die Spalte, eingeleitet mit @ und einen numerischen Index für die Zeile, eingeleitet mit &, wie Sie dies im vorletzten Abschnitt kennengelernt haben: #Table:name=VehicleTable@Modell&0. Wenn Sie nicht weiter aktiv mit SmartIDs arbeiten möchten, können Sie diese in der Aufnahme-Option wieder deaktivieren. Sie können aber auch gerne weiter mit SmartIDs arbeiten. Dabei werden Sie bei Aufnahmen auch weitere Ausdrücke in SmartIDs finden. Einige wollen wir hier zeigen und die Hintergründe dazu erläutern. Zum Beispiel werden Sie bei einer Beschriftung, die mit einem Doppelpunkt endet, vor diesem Doppelpunkt einen Rückstrich sehen: #TextField:Vorname\\: Der Hintergrund ist, dass ein Doppelpunkt den davor stehenden Text als Komponentenklasse kennzeichnet. Daher müssen Doppelpunkte im Namen oder der Beschriftung mit einem Rückstrich geschützt werden. Dies gilt auch für die Sonderzeichen, die Indizes einleiten, also @, & und %. Vor Beschriftungen werden Sie einen Kennzeichner, hier left= sehen: #TextField:left=Vorname Hintergrund: Eine SmartID mit Angabe von Klasse und Namen der Komponente erreicht eine gleich gute Performanz bei der Wiedergabe wie die Verwendung von Komponente Knoten. Bei Beschriftungen sieht dies jedoch anders aus. Hier gibt es unterschiedlichste Möglichkeiten, was die beste Beschriftung für eine Komponente darstellt. QF‑Test sucht unter den für eine Komponente in Frage kommenden Beschriftungen auf Basis der Komponentenklasse, Lage und Abstand der Beschriftungen die Beste aus. Für die Performanz bei der Wiedergabe ist es daher hilfreich, wenn direkt angegeben wird, nach welcher Beschriftung gesucht werden soll. left= gibt hierbei an, dass die Beschriftung links der Komponente zu finden ist. Weitere Lagebezeichnungen in einer SmartID sind right=, top=, topleft= und bottom=. Wenn die Beschriftung der Text der Komponente ist, lautet der Kennzeichner text=, für den Tooltip tooltip=. Wenn Komponenten mit dem gleichen Namen oder der gleichen Beschriftung mehrmals auf einer Anzeige vorhanden sind, können Sie auf SmartIDs stoßen, bei denen zwei über das Verbindungszeichen @ zu einer vereinigt werden: #TitledPanel:Kundenadresse@#TextField:left=Vorname #TitledPanel:title=Rechnungsadresse@#TextField:left=Vorname Im Beispiel gibt es die Beschriftung \"Vorname\" sowohl in der Kachel \"Kundenadresse\" als auch in der Kachel \"Rechnungsadresse\". Über die geschachtelte SmartID kann die Eindeutigkeit hergestellt werden. Das zweite Beispiel ist etwas performanter wegen title= bei der SmartID bei der Kachel. Dafür ist die Lesbarkeit beim ersten etwas besser. Es hängt von der Anwendung ab, wie sehr auf Performanz geachtet werden muss. Bei Web-Anwendungen mit sehr vielen geladenen GUI-Elementen ist dies typischerweise relevant. Bei Java-Anwendungen kann man häufig der Lesbarkeit den Vorrang geben. Bei langen Beschriftungen kann ein regulärer Ausdruck zur Verkürzung verwendet werden: #%Dialog:Information.*@#Button:OK Das Prozentzeichen direkt nach der Raute gibt an, dass entweder der Name oder die Beschriftung als regulärer Ausdruck zu interpretieren ist. Im Beispiel wird der Titel verkürzt. Außerdem gilt die SmartID für jeden OK-Button, der in einem Dialog liegt, dessen Titel mit \"Information\" beginnt. Eine genauere Beschreibung regulärer Ausdrücke finden Sie im Handbuch - reguläre Ausdrücke. Weitere Informationen zu Komponenten und SmartIDs finden Sie im Handbuch - Komponenten.","hash":"sec_components_smartid_web","h0":"SmartIDs - direkte Komponentenadressierung"},"361":{"id":361,"content":"Pro Tutorial","hash":"","h0":"Benutzen des Debuggers (Web) | QF‑Test Tutorial"},"362":{"id":362,"content":"Pro Tutorial","hash":"home-link","h0":"Benutzen des Debuggers (Web) | QF‑Test Tutorial"},"363":{"id":363,"content":"Benutzen des Debuggers (Web) Dieses Kapitel ist auch als Video verfügbar unter 'Benutzen des Debuggers'. In diesem Kapitel lernen Sie, wie der in QF‑Test integrierte intuitive Debugger benutzt wird. Diejenigen unter Ihnen, die bereits Erfahrungen mit anderen IDEs, wie z.B. Eclipse haben, werden hier Ähnlichkeiten in Funktion und Nutzen des Debuggers feststellen. Wir werden uns mit den folgenden Debugger-Funktionen beschäftigen: Setzen eines Breakpoints mittels Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B). Testausführung pausieren mittels Pausetaste oder der Tastenkombination Alt⁠+⁠F12. Schrittweise Ausführung mittels \"Einzelschritt ausführen\" , \"Gesamten Knoten ausführen\" und \"Bis Knotenende ausführen\" . Knoten überspringen mittels \"Knoten überspringen\" und \"Aus Knoten herausspringen\" . Debug-Modus bei Fehler oder Exception aktivieren. Fehlerbehebung aus dem Protokoll heraus. Den aktuellen Fehler im Protokoll direkt anspringen über Strg⁠+⁠J. (Ins Protokoll springen in Kapitel \"Fehlerbehebung aus dem Protokoll heraus\"). Anstatt über die Schaltflächen können die Befehle auch über die Menüzeile oder Tastaturkürzel abgesetzt werden. Die Kürzel stehen neben den Optionen in den QF‑Test Menüs, sofern vorhanden. Eine vollständige Übersicht der von QF‑Test verwendeten Tastaturkürzel finden Sie im Anhang Tastaturkürzel im Handbuch. Dort findet sich auch ein kleiner Helfer für die Funktionstastenbelegung von QF‑Test zum Befestigen an der Tastatur. Es gibt noch einige weitere Debugger-Funktionen wie \"Aktuellen Knoten finden\" (Aktuellen Knoten finden in \"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle\"), \"Ausführung hier fortsetzen\" über das Popup-Menü des entsprechenden Knotens (\"Ausführung hier fortsetzen\"), die \"Exception erneut werfen\" , die Tabelle der Variablendefinitionen (\"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle\"), auf die wir in späteren Kapiteln eingehen werden.","hash":"sec_DebuggerWeb","h1":"Benutzen des Debuggers (Web)"},"364":{"id":364,"content":"Pro Tutorial","hash":"","h0":"Setzen eines Breakpoints | QF‑Test Tutorial"},"365":{"id":365,"content":"Pro Tutorial","hash":"home-link","h0":"Setzen eines Breakpoints | QF‑Test Tutorial"},"366":{"id":366,"content":"Setzen eines Breakpoints Zunächst einmal soll der Debugger aktiviert werden. Dies kann auf mehrere Arten erfolgen, zum Beispiel durch das Setzen eines Haltepunktes (Breakpoint) vor Start des Testlaufs. Der Zweck eines Haltepunktes ist es, den Testlauf an einer Stelle, die man näher untersuchen möchte, zu unterbrechen. Sobald QF‑Test auf den Breakpoint trifft, wird die Testausführung pausiert und der Debugger-Modus aktiviert. Der Pauseknopf ist nun gedrückt. Selektieren Sie einen Knoten und drücken Sie Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B). Der Haltepunkt wird durch das Symbol kenntlich gemacht.","hash":"tut_breakpointsweb","h0":"Setzen eines Breakpoints"},"367":{"id":367,"content":"Abbildung 14.1: Breakpoint setzen Selektieren Sie den Testsuite Knoten und starten Sie den Testlauf über die Taste Enter.","hash":"fig_DebugSetBreakpointWeb","h4":"Abbildung 14.1: Breakpoint setzen"},"368":{"id":368,"content":"Abbildung 14.2: Testlauf starten Löschen Sie den Breakpoint wieder, indem Sie nochmals Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B) drücken.","hash":"fig_DebugStartTestRunWeb","h4":"Abbildung 14.2: Testlauf starten"},"369":{"id":369,"content":"Abbildung 14.3: Breakpoint löschen Man kann einen Breakpoint nicht nur über das Tastaturkürzel Strg⁠+⁠F8 sondern auch über den Menüpunkt »Debugger«-»Breakpoint an/aus« oder alternativ durch Rechtsklick auf den Knoten und Auswahl von »Breakpoint an/aus« im Popup-Menü setzen bzw. löschen. Für die weiteren Debugger-Funktionen werden wir hauptsächlich die jeweiligen Schaltflächen nennen, aber auch hier stehen die anderen Varianten zur Verfügung. Wieder sehen Sie den kleinen Pfeil, der diesmal anzeigt, welcher Knoten als nächster ausgeführt wird. Dieser Knoten wird aktueller Knoten genannt. Bei der Aktivierung des Debug-Modus navigiert QF‑Test zum aktuellen Knoten, falls dieser nicht bereits sichtbar ist, und selektiert diesen, d.h. die Zeile wird blau hinterlegt. Das Kommando »Debugger«-»Alle Breakpoints löschen« ist ebenfalls nützlich, wenn alle Haltepunkte in allen geöffneten Testsuiten gelöscht werden sollen. Es gibt keine Beschränkung für die Anzahl an Breakpoints, die Sie in Ihrer Testsuite setzen können. Haltepunkte werden beim Schließen der Testsuite nicht mit abgespeichert.","hash":"fig_DebugRemoveBreakpointWeb","h4":"Abbildung 14.3: Breakpoint löschen"},"370":{"id":370,"content":"Pro Tutorial","hash":"","h0":"Schrittweise Ausführung | QF‑Test Tutorial"},"371":{"id":371,"content":"Pro Tutorial","hash":"home-link","h0":"Schrittweise Ausführung | QF‑Test Tutorial"},"372":{"id":372,"content":"Schrittweise Ausführung Nun wollen wir die Testfälle schrittweise ausführen. Bitte experimentieren Sie ein wenig mit \"Einzelschritt ausführen\" , \"Gesamten Knoten ausführen\" und \"Bis Knotenende ausführen\" . Wie Sie sicher festgestellt haben werden, öffnet \"Einzelschritt ausführen\" einen Knoten mit Kindern und macht den ersten Kindknoten zum aktiven Knoten. Dies ist wie immer an der Pfeilmarkierung des Knotens erkennbar. Wenn Sie an dem Punkt weitergemacht haben, an dem die Ausführung der Testsuite im letzten Abschnitt pausiert war, d.h. vom Knoten \"Testfall: Erster\" aus, so würde nun der Testfall geöffnet werden:","hash":"tut_debug_steps_web","h0":"Schrittweise Ausführung"},"373":{"id":373,"content":"Abbildung 14.4: Einzelschritt ausführen Im Falle eines Blattknotens, d.h. eines Knotens, der keine Kinder hat, ist die Wirkung die gleiche wie die der folgenden Funktion. Mittels der Schaltfläche \"Gesamten Knoten ausführen\" wird ein Knoten inklusive aller Kindknoten ausgeführt. Der als nächstes auszuführende Knoten auf der gleichen Ebene wird dann der aktive und erhält den Pfeil.","hash":"fig_StepInExampleWeb","h4":"Abbildung 14.4: Einzelschritt ausführen"},"374":{"id":374,"content":"Abbildung 14.5: Gesamten Knoten ausführen \"Bis Knotenende ausführen\" führt die verbleibenden Geschwisterknoten aus und stoppt beim nächsten auszuführenden Knoten der übergeordneten Hierarchieebene.","hash":"fig_StepOverExampleWeb","h4":"Abbildung 14.5: Gesamten Knoten ausführen"},"375":{"id":375,"content":"Abbildung 14.6: Bis Knotenende ausführen Im Beispiel ist dies der Aufräumen Knoten. Wie bereits im ersten Kapitel Ein vollständiger Testlauf erläutert, haben Vorbereitung und Aufräumen Knoten die besondere Eigenschaft, dass sie vor und nach jedem Testfall ausgeführt werden, um so einen definierten Anfangszustand für jeden Testfall herzustellen. Dieses Verhalten tritt nur auf, wenn Sie die komplette Testsuite oder den Testfallsatz gestartet hatten und sich im Debug-Modus befinden. Wenn keine Testausführung aktiv war und Sie nur den Testfall selektiert hatten, so bewirkt die Funktion \"Gesamten Knoten ausführen\", dass der Testfall ausgeführt wird und dann der nächste Testfall selektiert wird. Führen Sie die Aufräumen und Vorbereitung Knoten aus, indem Sie mit Hilfe der Schaltfläche die gesamten Knoten ausführen und dann über den zweiten Testfall öffnen. Dies ist eine Vorbereitung für das nächste Kapitel, in dem es um das Überspringen von Knoten geht. Bitte beachten Sie bei der interaktiven Testerstellung bei Menüs und Comboboxen, dass diese häufig zuklappen, wenn die Applikation den Fokus verliert, was beim Wechsel in den Debug-Modus der Fall ist. In diesem Fall empfiehlt es sich, den Knoten, der ein Menü oder eine Combobox öffnet, und den Knoten, der die Auswahlaktion durchführt, gemeinsam auszuführen, also nicht zwischendurch in den Debug-Modus zu gehen. Dies kann man zum Beispiel dadurch erreichen, dass man nach dem Knoten, der die Auswahlaktion durchführt, einen Haltepunkt setzt und bei Erreichen des Knotens, der das Menü oder die Combobox öffnet, die Testausführung durch Lösen der Pausetaste freigibt.","hash":"fig_StepOutExampleWeb","h4":"Abbildung 14.6: Bis Knotenende ausführen"},"376":{"id":376,"content":"Pro Tutorial","hash":"","h0":"Knoten überspringen | QF‑Test Tutorial"},"377":{"id":377,"content":"Pro Tutorial","hash":"home-link","h0":"Knoten überspringen | QF‑Test Tutorial"},"378":{"id":378,"content":"Knoten überspringen Die \"Überspringen\" Funktionen erweitern die Fähigkeiten des Debuggers von QF‑Test in einer Weise, die über den Funktionsumfang von Standardprogrammierumgebungen hinausgeht. Wie der Name andeutet, erlauben die \"Überspringen\" Operationen einen oder mehrere Knoten während des Testlaufs auszulassen, d.h. weiter zu springen ohne diese auszuführen. Dies kann aus verschiedensten Gründen sinnvoll sein. Sei es um schnell an eine gewisse Position in Ihrem Testablauf zu gelangen oder um einen aktuell zu einem Fehler führenden Knoten zu überspringen. Am Schluss des letzten Abschnitts haben wir den ersten Testschritt im zweiten Testfall zum aktiven Knoten gemacht. Dies ist er Ausgangspunkt für unsere nächste Aktion:","hash":"tut_skip_steps_web","h0":"Knoten überspringen"},"379":{"id":379,"content":"Abbildung 14.7: Testausführung am ersten Knoten des zweiten Testfalls pausiert Drücken Sie nun die Schaltfläche \"Knoten überspringen\" . QF‑Test springt einfach über den aktiven Knoten ohne ihn oder seine Kindknoten auszuführen. Anschließend pausiert QF‑Test beim nächsten auszuführenden Knoten auf der gleichen Ebene.","hash":"fig_DebugSkipOverInitialStateWeb","h4":"Abbildung 14.7: Testausführung am ersten Knoten des zweiten Testfalls pausiert"},"380":{"id":380,"content":"Abbildung 14.8: \"Knoten überspringen\" Und zuletzt die Schaltfläche \"Aus Knoten herausspringen\" . Sie sehen sofort, dass QF‑Test aus dem Knoten, in dem Sie sich befinden, herausspringt ohne weitere Kindknoten auszuführen.","hash":"fig_DebugSkipOverWeb","h4":"Abbildung 14.8: \"Knoten überspringen\""},"381":{"id":381,"content":"Abbildung 14.9: \"Aus Knoten herausspringen\" Noch eine Bemerkung zu \"Knoten überspringen\" und \"Aus Knoten herausspringen\": Benutzen Sie diese mit Vorsicht! Aus einer Sequenz herauszuspringen, bevor diese zu Ende gelaufen ist, kann dazu führen, dass Ihr SUT in einem Status belassen wird, mit dem andere Sequenzen oder Tests in der Suite nicht aufsetzen können.","hash":"fig_DebugSkipOutWeb","h4":"Abbildung 14.9: \"Aus Knoten herausspringen\""},"382":{"id":382,"content":"Pro Tutorial","hash":"","h0":"Debug-Modus bei Fehler oder Exception aktivieren | QF‑Test Tutorial"},"383":{"id":383,"content":"Pro Tutorial","hash":"home-link","h0":"Debug-Modus bei Fehler oder Exception aktivieren | QF‑Test Tutorial"},"384":{"id":384,"content":"Debug-Modus bei Fehler oder Exception aktivieren Beim Debuggen eines Tests ist es oft hilfreich, wenn die Testausführung genau dann stoppt und in den Debug-Modus gewechselt wird, wenn ein Fehler, eine Exception oder manchmal auch nur eine Warnung auftritt. Mittels dieser Technik werden wir in diesem Abschnitt und dem nächsten den zweiten Testfall debuggen. Bitte öffnen Sie das Debugger-Menü und ändern Sie die Standardeinstellungen wie folgt: Klicken Sie auf den Menüpunkt »Debugger«-»Debugger aktivieren« um ihn zu aktivieren. Klicken Sie auf den Untermenüpunkt »Debugger«-»Optionen«-»Unterbrechen bei Fehler« um auch diese Funktion zu aktivieren. Wenn Sie nun das Debugger-Menü und das Optionen-Untermenü wieder öffnen sollte es wie folgt aussehen:","hash":"tut_debug_start_web","h0":"Debug-Modus bei Fehler oder Exception aktivieren"},"385":{"id":385,"content":"Abbildung 14.10: Debugger-Optionen: Test bei Fehler anhalten Wir müssen die Debugger-Optionen ändern, da sonst der Test einfach durchlaufen würde, analog zu den vorherigen Beispielen aus Kapitel eins und zwei. Selektieren Sie den Testsuite Knoten und starten Sie anschließend den Test mittels \"Wiedergabe starten\" . QF‑Test hält bei dem fehlerhaften Knoten an und wechselt in den Debug-Modus:","hash":"fig_debugger_stops_at_error_web","h4":"Abbildung 14.10: Debugger-Optionen: Test bei Fehler anhalten"},"386":{"id":386,"content":"Abbildung 14.11: QF‑Test pausiert bei Fehler Der Knoten, der den Fehler verursacht hat, wird durch ein rotes Quadrat markiert. Außerdem erscheint ein Fehlerdialog, der uns Näheres zur Fehlerursache mitteilt. Über diesen wechseln wir in das Protokoll, das wie so oft der Schlüssel zur Fehlerbehebung ist.","hash":"fig_debugger_stopped_by_error_web","h4":"Abbildung 14.11: QF‑Test pausiert bei Fehler"},"387":{"id":387,"content":"Abbildung 14.12: Fehlermeldung Klicken Sie auf die Schaltfläche In Protokoll springen der Fehlermeldung.","hash":"debug_error_dialog_web","h4":"Abbildung 14.12: Fehlermeldung"},"388":{"id":388,"content":"Pro Tutorial","hash":"","h0":"Fehlerbehebung aus dem Protokoll heraus | QF‑Test Tutorial"},"389":{"id":389,"content":"Pro Tutorial","hash":"home-link","h0":"Fehlerbehebung aus dem Protokoll heraus | QF‑Test Tutorial"},"390":{"id":390,"content":"Fehlerbehebung aus dem Protokoll heraus Über die Schaltfläche In Protokoll springen (siehe Fehlermeldung in Abbildung \"Fehlermeldung\") wird das Protokoll direkt bei dem entsprechenden Knoten geöffnet. Neben der eigentlichen Fehlermeldung wurden etliche weitere Informationen zur Testumgebung zum Zeitpunkt des Fehlers protokolliert. Neben Bildschirmabbildern zum Fehlerzeitpunkt enthält das Protokoll unter dem Knoten, der den Fehler verursachte, eine Liste der gebundenen Variablen (Stacktrace). Auf die Nützlichkeit des Stacktrace werden wir zu einem späteren Zeitpunkt eingehen (Die Variablendefinitionen-Tabelle). Beim vorliegenden Fehler wird der falsche Wert im Check Text Knoten der Testsuite erwartet. Zur Fehlerbehebung muss dieser durch den tatsächlich angezeigten ersetzt werden. Dies geht bei einem Check mit festem Wert, um den es sich hier handelt, am einfachsten, indem Sie auf den rot umrandeten Fehler-Knoten \"Fehlgeschlagen: Check Text: default ...\" rechtsklicken und im Kontextmenü »Check-Knoten mit erhaltenen Daten aktualisieren« auswählen.","hash":"tut_ResolveRunTimeErrorsWeb","h0":"Fehlerbehebung aus dem Protokoll heraus"},"391":{"id":391,"content":"Abbildung 14.13: Check-Knoten mit erhaltenen Daten aktualisieren QF‑Test navigiert zum betroffenen Check Text Knoten in der Testsuite und aktualisiert den Wert des Attributs Text anhand der aus dem SUT ausgelesenen Daten.","hash":"fig_DebugUpdateCheckNodeWeb","h4":"Abbildung 14.13: Check-Knoten mit erhaltenen Daten aktualisieren"},"392":{"id":392,"content":"Abbildung 14.14: Korrigierter Check-Knoten Der Knoten enthält nun zwar den korrekten Wert, ist aber immer noch rot umrandet, da er noch nicht wieder ausgeführt wurde. Dies wollen wir nun tun. führen Sie den Test also fort, indem Sie auf den Pauseknopf drücken und so die Pause lösen. QF‑Test führt den Rest der Testsuite aus. In unserem Fall sind das der Check Text und der Aufräumen Knoten. Anschließend informiert Sie QF‑Test, dass ein Fehler aufgetreten ist. Diesen haben wir allerdings bereits während des Testlaufs behoben.","hash":"fig_DebugCorrectedCheckNodeWeb","h4":"Abbildung 14.14: Korrigierter Check-Knoten"},"393":{"id":393,"content":"Ins Protokoll springen: Falls Sie das Protokoll an der Stelle, an der sich die Testausführung gerade befindet, öffnen wollen, brauchen Sie aus dem Debugging Modus heraus nur den Menüpunkt »Debugger«-»Jump to Run log« anzuklicken oder das Tastaturkürzel Strg⁠+⁠J zu drücken. Wenn Sie einfach nur das Protokoll öffnen wollen, ohne an die aktuelle Stelle zu springen, steht Ihnen Strg⁠+⁠L zur Verfügung, was auch nach Ende des Testlaufs weiterhin funktioniert.","hash":"tut_JumpToRunLogWeb tut_JumpToRunLogWeb","h4":"Abbildung 14.14: Korrigierter Check-Knoten"},"394":{"id":394,"content":"Pro Tutorial","hash":"","h0":"Testausführung pausieren | QF‑Test Tutorial"},"395":{"id":395,"content":"Pro Tutorial","hash":"home-link","h0":"Testausführung pausieren | QF‑Test Tutorial"},"396":{"id":396,"content":"Testausführung pausieren Wenn ein Test gerade ausgeführt wird und Sie den Debug-Modus aktivieren wollen, so können Sie entweder schnell einen Breakpoint auf einen noch nicht ausgeführten Knoten setzen oder Sie drücken einfach die Schaltfläche \"Pause\" um den Debug-Modus sofort zu aktivieren. Um die Ausführung fortzusetzen lösen Sie den Pauseknopf , völlig unabhängig von der Art und Weise wie der Debug-Modus aktiviert wurde. Wir wollen die vorhandenen Testfälle im Verlauf dieses Tutorials weiter verwenden. Allerdings wurde der Fehler in dem zweiten Testfall jetzt behoben. Insofern macht es Sinn \"(mit Fehler)\" aus dem Namen des zweiten Testfalls zu löschen, genauso wie \"(verursacht Fehler)\" aus dem Namen des Testschritts. Es gibt manchmal Situationen, in denen das SUT ständig den Fokus für sich beansprucht. Dann kann es schwierig sein, das QF‑Test Fenster lange genug im Vordergrund zu halten, um die Pausetaste drücken zu können. In einem solchen Fall steht Ihnen die \"Keine Panik\"-Taste Alt⁠+⁠F12 zur Verfügung. Sie unterbricht alle laufenden Tests sofort. Zur Weiterführung des Tests können Sie diese Tastenkombination erneut drücken.","hash":"tut_pause_execution_web","h0":"Testausführung pausieren"},"397":{"id":397,"content":"Pro Tutorial","hash":"","h0":"Variablen und Prozedurparameter (Web) | QF‑Test Tutorial"},"398":{"id":398,"content":"Pro Tutorial","hash":"home-link","h0":"Variablen und Prozedurparameter (Web) | QF‑Test Tutorial"},"399":{"id":399,"content":"Variablen und Prozedurparameter (Web) In diesem Kapitel lernen Sie, wie man eine Prozedur einsetzt um die gleichen Schritte auf unterschiedlichen Daten auszuführen. Außerdem sehen Sie, wie man Variablen einsetzt. Ebenso wird die Fehleranalyse in Bezug auf Variablen behandelt. Dieses Kapitel ist auch als Video verfügbar unter 'Variablen und Prozedurparameter'. Im Video wird eine Java-Applikation für die Erläuterungen verwendet. Bei Webapplikationen gibt es hinsichtlich der Variablenverwendung keine Unterschiede.","hash":"sec_variablestackweb","h1":"Variablen und Prozedurparameter (Web)"},"400":{"id":400,"content":"Pro Tutorial","hash":"","h0":"Prozedur mit Variable | QF‑Test Tutorial"},"401":{"id":401,"content":"Pro Tutorial","hash":"home-link","h0":"Prozedur mit Variable | QF‑Test Tutorial"},"402":{"id":402,"content":"Prozedur mit Variable Sehen Sie sich den letzten Testschritt \"Endpreis prüfen\" in unseren beiden Testfällen an.","hash":"sec_ProcedureWithVariableWeb","h0":"Prozedur mit Variable"},"403":{"id":403,"content":"Abbildung 15.1: Zwei fast gleiche Testschritte Es wird der gleiche Schritt ausgeführt, jedoch mit unterschiedlichen Daten. Auch wenn es sich nur um einen Schritt handelt, macht es Sinn eine Prozedur daraus zu machen. Vielleicht kommen wir später auf die Idee, die hartkodierten Werte 30.049,00 € und 26.100,00 € in ein anderes Format zu bringen, so dass der Check auf das Feld \"Endpreis\" auch für andere Währungen funktioniert. Diesen Algorithmus zweimal zu implementieren wäre auf jeden Fall nicht sinnvoll. Selektieren Sie den \"Check text\" Knoten im ersten Testfall. Wählen Sie den Menüpunkt »Operationen«-»Knoten einpacken in«-»Sequenz« aus oder verwenden Sie das Tastaturkürzel Strg⁠+⁠Umschalt⁠+⁠S um ihn in eine Sequenz einzupacken. Nennen Sie die Sequenz 'prüfeEndpreis'. Dieser Name entspricht der Java-Konvention die Wörter zusammenzuschreiben. Andererseits erlaubt QF‑Test auch Leerzeichen in Prozedurnamen, so dass Sie der Java-Konvention nicht zu folgen brauchen. Drücken Sie Strg⁠+⁠Umschalt⁠+⁠P um auf kürzestem Weg den Sequenzknoten in eine Prozedur zu konvertieren (wie aus dem letzten Kapitel bekannt). Wie Sie sehen, wurde die Sequenz durch einen Prozeduraufruf von \"prüfeEndpreis\" ersetzt. Klicken Sie doppelt auf den Prozeduraufruf, um zur Prozedur im Prozeduren Knoten zu springen. Öffnen Sie den neu erstellten Prozedurknoten um den Inhalt zu sehen.","hash":"fig_params1Web","h4":"Abbildung 15.1: Zwei fast gleiche Testschritte"},"404":{"id":404,"content":"Abbildung 15.2: Prozedur mit hartkodiertem Wert Wie erwartet befindet sich der \"Check text\" Knoten in der Prozedur. Er ist jedoch nur für einen einzigen Preis gültig, nämlich 30.049,00 €. Da wir die gleiche Prozedur auch für den zweiten Testfall verwenden möchten, müssen wir den Preis durch eine Variable ersetzen. Der Wert dieser Variable sollte dann beim Prozeduraufruf mit übergeben werden. Im nächsten Beispiel werden wir einen Parameter mit Standardwert im Prozedurknoten einfügen. Standardwerte werden häufig verwendet, wenn der entsprechende Parameter bei den meisten Prozeduraufrufen den Standardwert erhalten würde. Dann braucht man den Standardwert nicht jedes Mal zu spezifizieren, sondern kann auf den im Prozedurknoten definierten Wert zurückgreifen. Obwohl das auf den Preis als Parameter nicht zutrifft, können wir ihn gerade deshalb verwenden um zu zeigen, wie ein Standardwert funktioniert und wie man ihn bei Bedarf mit einem anderen Wert überschreiben kann. Als erstes fügen wir also eine Variable mit Standardwert ein: Selektieren Sie die Prozedur 'prüfeEndpreis' Drücken Sie den \"Zeile einfügen\" Knopf über der Tabelle \"Standardwerte für Parameter\". Tragen Sie preis als Namen des Parameter ein. Tragen Sie 30.049,00 € als Wert ein.","hash":"fig_procedure_hardcoded_web","h4":"Abbildung 15.2: Prozedur mit hartkodiertem Wert"},"405":{"id":405,"content":"Abbildung 15.3: Die Details eines Prozedurknotens Im nächsten Schritt ersetzen wir den Wert des Text Attributs des Check Text Knotens durch eine Referenz auf die Variable.","hash":"fig_parameter_default_values_table_web","h4":"Abbildung 15.3: Die Details eines Prozedurknotens"},"406":{"id":406,"content":"Variablensyntax: Wenn Sie mit Variablen arbeiten, ist es wichtig, sich bewusst zu sein, dass Sie an bestimmten Stellen QF‑Test mitteilen wie, eine Variable heißt und an anderen, dass QF‑Test auf den Wert einer Variablen zugreifen soll. In obigem Beispiel wird QF‑Test in der Namensspalte für die Standardwerte der Variablenname mitgeteilt. In diesem Fall brauchten Sie nur preis einzutragen. Im Text Attribute des Check Text Knotens soll der Wert der Variablen verwendet werden. Bei QF‑Test geschieht dies dadurch, dass Sie den Variablenname in $() setzen, hier $(preis). Falls Sie den Variablennamen nicht in $() setzen, würde QF‑Test den Preis mit der Zeichenfolge preis vergleichen. Selektieren Sie den Check Text Knoten in der Prozedur \"prüfeEndpreis\". Tragen Sie $(preis) im Text Attribut der Check Text Knotendetails ein.","hash":"tut_VariableSyntaxWeb","h4":"Abbildung 15.3: Die Details eines Prozedurknotens"},"407":{"id":407,"content":"Abbildung 15.4: 'Check text'-Knoten Führen Sie den ersten Testfall aus. Der Testfall sollte fehlerfrei durchlaufen.","hash":"fig_ProcedureAddVariableWeb","h4":"Abbildung 15.4: 'Check text'-Knoten"},"408":{"id":408,"content":"Pro Tutorial","hash":"","h0":"Die Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"409":{"id":409,"content":"Pro Tutorial","hash":"home-link","h0":"Die Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"410":{"id":410,"content":"Die Variablendefinitionen-Tabelle Im nächsten Schritt fügen wir einen Prozeduraufruf im zweiten Testfall ein. Ersetzen Sie den Check Text Knoten des zweiten Testfalls durch einen Prozeduraufruf von \"prüfeEndPreis\". Sie können einfach den Prozeduraufruf aus dem ersten Testfall kopieren oder den Prozeduraufruf wie oben beschrieben einfügen.","hash":"tut_variable_stack_web","h0":"Die Variablendefinitionen-Tabelle"},"411":{"id":411,"content":"Abbildung 15.5: Prozeduraufruf von \"prüfeEndPreis\" in der zweiten Prozedur Wenn im Prozeduraufruf bereits der Preis mit Standardwert eingetragen ist, rührt das daher, dass der Prozeduraufruf mit Hilfe der Prozedur selbst erzeugt wurde. Entweder durch Kopieren der Prozedur oder durch eine Drag-and-Drop Aktion unter Verwendung des Prozedurknoten oder über direktes Einfügen der Prozedur wie weiter oben erläutert. Aktuell geht es jedoch um den Standardwert. Daher bitten wir Sie, den evtl. vorhandenen Preis-Parameter zu löschen, wenn Sie dem Tutorial Schritt für Schritt folgen wollen. Dazu klicken Sie das rote X über der Variablendefinitionen-Tabelle. Überprüfen Sie, ob der Debugger so eingestellt ist, dass er bei Fehlern unterbricht (siehe Debugger-Optionen: Test bei Fehler anhalten). Selektieren Sie den Knoten \"Testfall: Zweiter\". Führen Sie ihn aus, entweder über den Knopf oder durch Drücken der Eingabe Taste. Eine Fehlermeldung zeigt an, dass ein anderer als der angezeigte Preis erwartet wurde. Was lief schief? Lassen Sie uns nach dem Fehler forschen. Üblicherweise würden wir ins Protokoll schauen, aber es gibt noch eine andere wichtige Informationsquelle. Klicken Sie OK, um die Fehlermeldung zu schließen. Im Debugging-Modus sehen Sie rechts unten im QF‑Test Fenster eine Knotenliste mit Variablen, die von diesen gebunden sind. Eventuell müssen Sie die Variablendefinitionen-Tabelle vergrößern, um alle Einträge sehen zu können.","hash":"fig_AddProcedureCallToSecondTestcaseWeb","h4":"Abbildung 15.5: Prozeduraufruf von \"prüfeEndPreis\" in der zweiten Prozedur"},"412":{"id":412,"content":"Abbildung 15.6: Variablendefinitionen Die Variablendefinitionen-Tabelle ist beim Debuggen sehr hilfreich, da sie die aktuellen Werte der Variablen anzeigt. Sie unterstützt beim Arbeiten mit Prozeduren als auch beim Verständnis, wie QF‑Test den richtigen Variablenwert ermittelt. QF‑Test geht die Variablendefinitionen-Tabelle immer von oben nach unten durch. Sie sehen, dass in den ersten Zeilen keine Variablen gebunden sind. Auf der Ebene \"Globale Variablen\" ist eine Variable gebunden und auf dem Sekundärstapel für \"Prozedur: prüfeEndpreis\" eine weitere. Die globale Variable wird für die Verbindung zur SUT Applikation verwendet und wurde vor dem Anwendungsstart gesetzt. (vgl. Starten des Browsers). Die andere Variable interessiert uns im Moment mehr - sie hat jedoch den falschen Wert. Dieser Wert auf dem Sekundärstapel ist der Standardwert, da er dann verwendet wird, wenn nirgendwo sonst einer Variablen mit dem gleichen Namen ein Wert zugewiesen wurde. Um es richtig zu machen, müssen wir den korrekten Wert beim Prozeduraufruf an die Prozedur übergeben. Wieder gibt es mehrere Arten, dies zu tun. Ein Weg wäre, eine neue Zeile in der Variablendefinitionen-Tabelle in den Details des Prozeduraufrufs einzufügen, ähnlich wie beim Prozedurknoten im vorigen Abschnitt. Wenn es jedoch bereits mehrere Prozeduraufrufe gibt, ist folgendes einfacher: Beenden Sie die laufende Testausführung mittels . Führen Sie einen Rechtsklick auf den Prozedurknoten aus und wählen »Weitere Knotenoperationen«-»Parameter von Referenzen anpassen« im Popup-Menü.","hash":"fig_VariableBindingsTable1Web","h4":"Abbildung 15.6: Variablendefinitionen"},"413":{"id":413,"content":"Führen Sie einen Rechtsklick auf den Prozedurknoten aus und wählen »Weitere Knotenoperationen«-»Parameter von Referenzen anpassen« im Popup-Menü. Abbildung 15.7: Popup-Menü für \"Parameter von Referenzen anpassen\" Prüfen Sie im folgenden Dialog, dass ein Häkchen bei »Fehlende Parameter beim Aufrufer hinzufügen« gesetzt ist, und bestätigen Sie mit OK. Im Prozeduraufruf erzeugt QF‑Test für jeden Standardwert eine Zeile in der Variablen Definitionen Tabelle. In unserem Fall wurde eine Zeile für den Parameter mit dem Namen preis und dem Wert 30.049,00 € hinzugefügt. Auch damit wird es im zweiten Testfall noch nicht funktionieren, auch wenn der Wert direkt übergeben wird, weil es sich immer noch um den Standardwert handelt, der hier nicht korrekt ist. Bitte verändern Sie den Wert noch nicht, damit wir Ihnen mittels des entstehenden Fehlers eine weitere Möglichkeit des Debuggens zeigen können. Schließen Sie den Dialog \"Angepasste Knoten\", den QF‑Test anzeigt, um Sie über die vervollständigten Knoten zu informieren.","hash":"fig_CompleteParameters_web","h4":"Abbildung 15.6: Variablendefinitionen"},"414":{"id":414,"content":"Pro Tutorial","hash":"","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"415":{"id":415,"content":"Pro Tutorial","hash":"home-link","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"416":{"id":416,"content":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle Als nächstes wollen wir die Variablendefinitionen-Tabelle unter die Lupe nehmen und herausfinden, wie man sie für Debugging-Zwecke einsetzen kann. Daher belassen Sie bitte den fehlerhaften Wert, der im vorigen Abschnitt im Prozeduraufruf eingefügt wurde. Dazu soll die Ausführung des Testfalls beim Prozeduraufruf unterbrochen werden um dann mittels Einzelschritten in die Prozedur zu gehen. Dabei werden wir uns ansehen, was in der Variablendefinitionen-Tabelle passiert. Anschließend wollen wir direkt aus der Variablendefinitionen-Tabelle zum fehlerhaften Prozeduraufruf springen und dort den Parameterwert korrigieren. Setzen Sie einen Breakpoint bei \"Prozeduraufruf: prüfeEndpreis\" im zweiten Testfall. Führen Sie den zweiten Testfall aus. Wenn QF‑Test am Breakpoint anhält, führen Sie zwei Einzelschritte in die Prozedur mittels aus und beobachten dabei die Variablendefinitionen-Tabelle.","hash":"tut_variable_stack_debugging_web","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle"},"417":{"id":417,"content":"Abbildung 15.8: Variablendefinitionen-Tabelle zeigt den falschen Wert Wenn Sie mit Einzelschritten in die Prozedur gehen, wird beim ersten eine Zeile für \"Prozeduraufruf: prüfeEndpreis\" oben in der Tabelle erzeugt und beim zweiten die Zeile \"Prozedur: prüfeEndpreis\". Jetzt gibt es die Variable preis auf zwei verschiedenen Ebenen in der Variablen Definitionen Tabelle: in der Zeile für \"Prozeduraufruf: prüfeEndpreis\" und in der Zeile \"Prozedur: prüfeEndpreis\" auf dem Sekundärstapel, wobei keiner der beiden Variablenwerte der richtige ist. In QF‑Test können Sie interaktiv die Werte von Variablen in der Variablendefinitionen-Tabelle verändern, wenn Sie sich im Debugging-Modus befinden. Sie können sogar neue Variablen hinzufügen oder vorhandene löschen. Damit können Sie arbeiten, solange sich die Variablen auf dem Variablenstapel befinden, in unserem Fall solange wie die Prozedur ausgeführt wird. Änderungen des aktuellen Variablenwertes in der Variablendefinitionen-Tabelle bewirken keine Anpassung des im Prozeduraufrufknoten eingetragenen Parameterwerts. Der Wert muss explizit im Prozeduraufruf geändert werden. Die schnellste Methode um zum Prozeduraufruf zu gelangen ist ein Doppelklick auf die Prozeduraufrufzeile (zweite Zeile) in der Variablendefinitionen-Tabelle. Diese Methode ist besonders hilfreich, wenn Sie umfangreiche Testsuiten debuggen und der Knoten, zu dem Sie springen wollen, nicht im Testsuite-Fenster angezeigt wird. Statt eines Doppelklicks können Sie auch einen Rechtsklick auf die Zeile ausführen und den Menüpunkt »Zu Knoten in Testsuite springen« wählen. Führen Sie einen Doppelklick auf die zweite Zeile mit dem Prozeduraufruf in der Variablendefinitionen-Tabelle aus. Setzen Sie den Parameterwert auf den richtigen Wert, d.h. 26.100,00 €. Umgekehrt wird auch der aktuelle Wert in der Variablendefinitionen-Tabelle dadurch nicht verändert. Um dies zu erreichen müssen wir den Prozeduraufruf erneut ausführen. Allerdings ist die Testausführung über diesen Punkt bereits hinaus. Daher wollen wir hier eine weitere nützliche Funktion des Debuggers zeigen, mit der man den QF‑Test anweisen kann, den nächsten auszuführenden Knoten zu verändern. Dazu selektieren Sie den entsprechenden Knoten und wählen den Menüpunkt »Ausführung hier fortsetzen« oder verwenden das Tastaturkürzel Strg⁠+⁠,. Also, um den neu gesetzten Wert auszuprobieren: Führen Sie einen Rechtsklick auf den Knoten \"Prozeduraufruf: prüfeEndpreis\" in der zweiten Prozedur aus. Wählen Sie \"Ausführung hier fortsetzen\" im Popup-Menü.","hash":"fig_VariableStack3Web","h4":"Abbildung 15.8: Variablendefinitionen-Tabelle zeigt den falschen Wert"},"418":{"id":418,"content":"Abbildung 15.9: Ausführung hier fortsetzen In der Variablendefinitionen-Tabelle sind die zwei obersten Zeilen verschwunden. Der Grund ist, dass Sie die Prozedur verlassen haben (wenn auch \"rückwärts\") und dass dadurch der Prozeduraufruf mit den daran gebundenen Variablen vom Aufrufstack genommen wurde. Lösen Sie den Pauseknopf . Nun sollte kein Fehler mehr auftauchen. Da die Variablendefinitionen-Tabelle äußerst hilfreich ist, wenn Sie nach fehlerhaften Variablenwerten fahnden, wird eine Kopie davon auch unter dem Knoten \"Stacktrace\" im Protokoll abgespeichert, in dem die Variablenwerte genau zum Zeitpunkt des Fehlers zu sehen sind.","hash":"fig_ProcedureContinueExecFromHereWeb","h4":"Abbildung 15.9: Ausführung hier fortsetzen"},"419":{"id":419,"content":"Aktuellen Knoten finden: Manchmal entfernt man sich beim Debuggen ziemlich weit vom aktuellen Knoten und möchte anschließend wieder zu diesem Knoten zurückfinden. Das geht am einfachsten indem man in der Toolbar \"Aktuellen Knoten finden\" drückt oder den Menüpunkt »Debugger«-»Aktuellen Knoten finden« wählt.","hash":"locate_current_node_web locate_current_node_web","h4":"Abbildung 15.9: Ausführung hier fortsetzen"},"420":{"id":420,"content":"Pro Tutorial","hash":"","h0":"Variablen setzen | QF‑Test Tutorial"},"421":{"id":421,"content":"Pro Tutorial","hash":"home-link","h0":"Variablen setzen | QF‑Test Tutorial"},"422":{"id":422,"content":"Variablen setzen Zusätzlich zu den oben beschriebenen Wegen können die Variablen auch wie folgt gesetzt werden: Mittels Variable setzen Knoten, als Rückgabewert einer Prozedur, als Ergebnis eines QF‑Test Knotens wie Text auslesen, Geometrie auslesen, Index auslesen und Check, in der 'Variablendefinitionen' Tabelle von Testsuite, Testfall, Testschritt, Sequenz und weiteren Knoten wie dem If oder Schleife Knoten, über Kommandozeilenparameter. Informationen dazu, an welcher Stelle eine Variable am besten definiert wird, finden Sie im nächsten Abschnitt. Ein Variable setzen Knoten kann über den Menüpunkt »Einfügen«-»Diverse Knoten«-»Variable setzen« eingefügt werden. In den Knotendetails können Sie angeben, ob es sich um eine lokale (Häkchen bei \"Lokale Variable\" setzen) oder eine globale Variable handeln soll. Die folgende Abbildung zeigt die Details eines Variable setzen Knotens, den Sie als ersten Knoten im Vorbereitung Knoten finden. Es wird eine Variable mit dem Namen client definiert. Dass es sich um eine globale Variable handelt, erkennen Sie daran, dass das Attribut 'Lokale Variable' nicht gesetzt ist.","hash":"tut_setting_variables_web","h0":"Variablen setzen"},"423":{"id":423,"content":"Abbildung 15.10: Details des Variable setzen Knoten Wenn eine Variable mit dem Rückgabewert einer Prozedur gesetzt werden soll, geben Sie den Variablennamen im Attribut \"Variable für Rückgabewert\" des Prozeduraufrufs an. In der Prozedur selbst müssen Sie als letzten auszuführenden Knoten einen Return Knoten einfügen, der den betreffenden Wert zurückgibt. Die Prozedur in der folgenden Abbildung liest den Rabattwert aus dem SUT und gibt den Wert an den aufrufenden Testfall zurück. Dort heißt die empfangende Variable Rabatt und ist als lokale Variable deklariert. Dieses Beispiel ist nicht in der Übungstestsuite enthalten.","hash":"fig_DetailsSetVariableWeb","h4":"Abbildung 15.10: Details des Variable setzen Knoten"},"424":{"id":424,"content":"Abbildung 15.11: Prozedur mit Rückgabewert Der Text auslesen Knoten in der obigen Abbildung ist einer der QF‑Test Knoten, die direkt den Wert einer Variablen setzen. Dabei wird der Variablenname in dem entsprechend benannten Attribut eingetragen. Sie haben wiederum die Wahl, ob es eine lokale oder globale Variable werden soll. Es gibt eine Reihe von Knoten, die eine Variablendefinitionen-Tabelle besitzen. Dort können Sie lokale Variablen setzen. Falls sich der betreffende Knoten in einer Prozedur befindet, wird die Variable als lokale Variable an die Prozedur gebunden, ansonsten als lokale Variable an den Testfall. Variablen, die mittels dieser Tabelle an den Testsuite Knoten gebunden sind, können von allen Knoten der Testsuite referenziert werden. Alle Knoten, an die Variablen gebunden werden können, werden im Debugger-Modus im Variablen Definitionen Fenster rechts unten angezeigt, wenn sie gerade ausgeführt werden. Variablen können auch über die Kommandozeile spezifiziert werden. Hierzu verwenden Sie den Kommandozeilenparameter -variable. Beispiel: qftest -batch -variable \"browser\"=\"ie\" test.qft. Weitere Informationen hierzu finden Sie im Handbuch, Kapitel 'Kommandozeilenargumente'.","hash":"fig_DetailsCallProcedureWeb","h4":"Abbildung 15.11: Prozedur mit Rückgabewert"},"425":{"id":425,"content":"Pro Tutorial","hash":"","h0":"Ebenen für Variablendefinitionen | QF‑Test Tutorial"},"426":{"id":426,"content":"Pro Tutorial","hash":"home-link","h0":"Ebenen für Variablendefinitionen | QF‑Test Tutorial"},"427":{"id":427,"content":"Ebenen für Variablendefinitionen Dieser Abschnitt gibt Antworten auf die Frage, auf welcher Ebene eine Variable definiert werden sollte. Wenn Sie diese Frage momentan nicht interessiert, können Sie direkt zum nächsten Kapitel springen. Variablen können auf unterschiedlichen Ebenen gebunden werden: Im Testsuite Knoten, in Testfällen und Prozeduren als Standard- oder als lokale Variablen, als Parameter in einem Prozeduraufruf, als globale Variable und als Kommandozeilenparameter. Die Ebene, auf welcher eine Variable am sinnvollsten definiert wird, hängt vom Verwendungszweck der Variablen ab: Prozedurparameter Übergeben Sie einen Wert als Parameter an eine Prozedur, wenn die gleiche Prozedur mehr als einmal und mit unterschiedlichen Werten ausgeführt werden soll. Prozedurparameter werden in der Variable Definitionen Tabelle eines Prozeduraufruf Knoten angegeben. Lokale Variablen in einer Prozedur Lokale Variablen werden innerhalb der Prozedur definiert und sind nur dort gültig. Wenn die Prozedur beendet wird, werden sie gelöscht. Verwenden Sie eine lokale Variable, wenn diese nicht außerhalb der Prozedur benötigt wird. Sie sind das Mittel der Wahl für Zwischenergebnisse. Lokale Variablen in einem Testfall In einem Testfall können lokale Variable entweder während der Durchführung des Testfall angelegt werden oder über die entsprechende Tabelle in den Details des Testfall Knotens. Wenn Sie in einem Testfall mehrfach den gleichen Wert verwenden, ist es sinnvoll, diesen einmalig einer Variablen zuzuweisen und dann die Variable zu verwenden. Dies erhöht die Wartbarkeit. Auch für Zwischenergebnisse sollte man lokale Variablen verwenden. Globale Variablen Wenn globale Variablen einmal erstellt wurden, existieren sie, bis sie entweder explizit gelöscht werden oder bis QF‑Test beendet wird. Auch Stopps und die erneute Ausführung von Tests \"überleben\" sie. Verwenden Sie sie für Werte, die in mehreren Testfällen genutzt werden. Ein Beispiel ist die Variable client, die im Vorbereitung Knoten beim Start der Applikation angelegt wird. Um sie wieder loszuwerden, wählen Sie den Menüpunkt »Wiedergabe«-»Globale Variablen löschen«. Auch beim Beenden von QF‑Test werden sie gelöscht. Kommandozeilenparameter Variablen, die über Kommandozeile gesetzt werden, sind im Batch-Modus sinnvoll, wenn Sie mehrere Batch-Läufe mit unterschiedlichen Werten durchführen wollen. Kommandozeilenparameter gelten während der gesamten Laufzeit des Batch-Laufs. Ein typisches Beispiel ist die variablengesteuerte Ausführung auf verschiedenen Browsern. Variablen können über den Kommandozeilen-Parameter -variable spezifiziert (vgl. Kapitel 'Kommandozeilenargumente' im Handbuch). Testsuite-Variablen Testsuite-Variablen können von allen Testfällen verwendet werden. Ihr Verwendungszweck entspricht dem von globalen Variablen, nur dass sie im Batch-Modus durch Variablen in der Kommandozeile überschrieben werden können. Standardwerte (Sekundärstapel) Sie können Standardwerte für die Variablen von Prozeduren, Testfällen und Testfallsätzen definieren. Diese kommen zum Zug, wenn keine Variable mit dem gleichen Namen auf einer höheren Ebene definiert wurde.","hash":"tut_variable_levels_web","h0":"Ebenen für Variablendefinitionen"},"428":{"id":428,"content":"Pro Tutorial","hash":"","h0":"Die Standardbibliothek (Web) | QF‑Test Tutorial"},"429":{"id":429,"content":"Pro Tutorial","hash":"home-link","h0":"Die Standardbibliothek (Web) | QF‑Test Tutorial"},"430":{"id":430,"content":"Die Standardbibliothek (Web) Dieses Kapitel ist auch als Video verfügbar unter 'Die Standardbibliothek'. QF‑Test stellt eine gewisse Anzahl an Knotentypen bereit, die für die Testerstellung genutzt werden können. Wenn Sie Funktionalität benötigen, die darüber hinausgeht, können Sie diese mittels Skript-Knoten implementieren. Um Ihnen die Arbeit zu erleichtern, wurden viele Funktionen, die häufig benötigt werden, bereits in Prozeduren implementiert und werden in einer Standard-Prozeduren-Bibliothek mit QF‑Test ausgeliefert. Wenn Sie also eine Aufgabenstellung haben, die nicht über die bereitgestellten Knoten gelöst werden kann, sollten Sie zunächst einmal in der Standardbibliothek forschen, ob Sie dort eine passende oder ähnliche Lösung finden. Wenn Sie eine ähnliche Lösung finden, kopieren Sie einfach die vorhandene Standardprozedur und passen sie Sie gemäß Ihrer Bedürfnisse an. Informationen zum Arbeiten mit Skripten erhalten Sie im Handbuch, Kapitel 12 \"Skripting\". Die Bibliothek ist in der Datei qfs.qft enthalten und ist Teil der QF‑Test Distribution. Da sie mit jeder QF‑Test Version weiterentwickelt wird, ist es nicht ratsam, Änderungen in der ausgelieferten Standardbibliothek vorzunehmen, sondern bei Bedarf eine Prozedur in eine eigene Testsuite zu kopieren und dort anzupassen. Um die Bibliothek qfs.qft verwenden zu können, muss sie im \"Testsuite\" Wurzelknoten Ihrer Suite in den \"inkludierten Dateien\" eingebunden werden. Bei neuen Testsuiten ist dies automatisch der Fall. Wählen Sie den 'Testsuite'-Wurzelknoten Ihrer Testsuite aus. Überprüfen Sie in den Details des 'Testsuite'-Wurzelknoten, dass qfs.qft im Attribut \"Inkludierte Dateien\" aufgeführt ist. Fügen Sie qfs.qft zu dieser Liste dazu, falls es noch nicht enthalten ist. Eine Pfadangabe ist nicht notwendig, da das include Verzeichnis von QF‑Test automatisch im Bibliothekspfad (siehe auch Referenzteil des Handbuchs) enthalten ist. Im Folgenden beschreiben wir eine Auswahl der am häufigsten benötigten Standardprozeduren. Eine vollständige HTML-Dokumentation der Standardbibliothek finden Sie unter dem Menüpunkt »Hilfe«-»Standardbibliothek qfs.qft...«.","hash":"sec_StandardLibraryWeb","h1":"Die Standardbibliothek (Web)"},"431":{"id":431,"content":"Pro Tutorial","hash":"","h0":"Erforschen der Standardbibliothek | QF‑Test Tutorial"},"432":{"id":432,"content":"Pro Tutorial","hash":"home-link","h0":"Erforschen der Standardbibliothek | QF‑Test Tutorial"},"433":{"id":433,"content":"Erforschen der Standardbibliothek Zusätzlich zum Einfügen von Prozeduraufrufen aus der Standardbibliothek ist es hilfreich, einen Blick darauf zu werfen, wie Funktionen implementiert und organisiert sind. Öffnen Sie die Bibliothek selbst, also die Suite qfs.qft, die sich im Verzeichnis qftest-10.0.2-pro/include Ihrer QF‑Test Installation befindet.","hash":"sec_StandardLibraryOverviewWeb","h0":"Erforschen der Standardbibliothek"},"434":{"id":434,"content":"Abbildung 16.1: Die Standardbibliothek Sie sehen ein Haupt-Package qfs, das die spezifischen Packages umschließt. Das qfs Package hilft dabei, die Prozeduren leicht als solche der Standardbibliothek zu identifizieren. In fast allen Prozeduren unserer Bibliothek werden Sie die Verwendung der Variable $(client) bemerken. Dies ist ein Standardmechanismus, um Testsuiten unabhängig von einem spezifischen SUT zu gestalten. Für die Benutzung der Standardbibliothek wird vorausgesetzt, dass ein gültiger Wert für $(client) gesetzt wird, bevor eine ihrer Prozeduren verwendet werden kann.","hash":"fig_SuiteQfsQftWeb","h4":"Abbildung 16.1: Die Standardbibliothek"},"435":{"id":435,"content":"Pro Tutorial","hash":"","h0":"Ausgewählte Packages und Prozeduren | QF‑Test Tutorial"},"436":{"id":436,"content":"Pro Tutorial","hash":"home-link","h0":"Ausgewählte Packages und Prozeduren | QF‑Test Tutorial"},"437":{"id":437,"content":"Ausgewählte Packages und Prozeduren Wir werfen nun einen genaueren Blick auf ein paar ausgewählte Packages und Prozeduren der Standardbibliothek. Wir werden mit Packages beginnen, die den Zugriff auf Komponenten abhängig von der verwendeten GUI Technologie, hier Web, ermöglichen.","hash":"sec_StandardLibraryPackagesWeb","h0":"Ausgewählte Packages und Prozeduren"},"438":{"id":438,"content":"Das Checkbox Package Wir beginnen nun mit der genaueren Betrachtung des Packages qfs.web.checkbox. Hier sind einige Prozeduren aus diesen Packages: select Selektiert ein Kontrollkästchen. Wenn sich das Kontrollkästchen bereits im ausgewählten Zustand befindet, wird keine Aktion ausgeführt. deselect Deselektiert ein Kontrollkästchen. Wenn sich das Kontrollkästchen bereits im nicht-ausgewählten Zustand befindet, wird keine Aktion ausgeführt. set Setzt ein Kontrollkästchen auf den angegebenen Zustand (true oder false). Für jede dieser Prozeduren wird die QF‑Test ID der Kontrollkästchenkomponente als variables Argument übergeben. Die Bibliothek kümmert sich um die Überprüfung, dass der Zustand des Kontrollkästchens wie erwartet gesetzt wurde. Die anderen Prozeduren in diesem Package folgen demselben Muster.","hash":"sec_web_checkbox_package","h1":"Das Checkbox Package"},"439":{"id":439,"content":"Das Select Package Das Package qfs.web.select enthält Prozeduren, um Werte in einer Combobox oder eines anderen Select-Elements zu selektieren. Die wichtigsten Prozeduren sind: setValue Selektiert einen Wert in der Liste der Combobox. getItemCount Liefert die Anzahl der Einträge zurück.","hash":"sec_das_select_package","h1":"Das Select Package"},"440":{"id":440,"content":"Das General Package Das Package qfs.web.general enthält allgemeine Prozeduren für GUI-Elemente. Die wichtigsten Prozeduren sind: setLocation Setzt die Position der Komponente mittels angegebenen Koordinaten. setSize Setzt die Größe der Komponente.","hash":"sec_web_general_package","h1":"Das General Package"},"441":{"id":441,"content":"Das Table Package Das Package qfs.web.table enthält Hilfsprozeduren für Tabellen. getRowCount Liefert die aktuelle Zeilenanzahl einer Tabelle zurück. Diese Prozedur verwendet technologiespezifische Methoden um an die Anzahl zu kommen. getColumnCount Liefert die aktuelle Spaltenanzahl einer Tabelle zurück. Diese Prozedur verwendet technologiespezifische Methoden um an die Anzahl zu kommen. selectCell Selektiert eine angegebene Tabellenzelle.","hash":"sec_web_table_package","h1":"Das Table Package"},"442":{"id":442,"content":"Das Cleanup Package Die Packages qfs.fx.cleanup, qfs.swing.cleanup und qfs.swt.cleanup bieten eine gute Unterstützung für das Aufräumen der SUT Umgebung, wenn unerwartet eine Exception auftritt. Stellen Sie sich zum Beispiel vor, dass eine Exception geworfen wird, während auf ein Menü des SUTs zugegriffen wird. Die Exception bewirkt, dass der Ausführungspfad innerhalb Ihrer Testsuite zu einem Exception Handler umgeleitet wird - oder zu einem \"impliziten\" Exception Handler. Das bedeutet, dass der normale Ausführungspfad, der das geöffnete Menü in der Regel wieder ordnungsgemäß geschlossen hätte, unterbrochen wurde. Ohne eine entsprechende Aktion kann dieses Menü geöffnet bleiben und somit andere Ereignisse an das SUT blockieren. Hier sehen Sie die wichtigsten Prozeduren innerhalb des Packages: closeAllModalDialogs bewirkt, dass modale Dialoge des SUTs geschlossen werden. Nur für Swing und FX verfügbar! closeAllDialogsAndModalShells bewirkt, dass alle Dialoge und modalen Shells geschlossen werden. Nur für Eclipse/SWT verfügbar! closeAllMenus Schließt alle offenen Menüs des SUT. Das Konzept zur Behandlung von impliziten Exceptions ist von großer Bedeutung, denn eine Exception in einem einzigen Testfall soll nicht zum Beenden des gesamten Testlaufs führen. Lediglich der aktuelle Testfall soll abgebrochen werden, dann sollte es mit dem nächsten Testfall weitergehen. Aus diesem Grund wird eine Exception innerhalb eines Testfalls auf dieser Ebene gefangen und nicht nach oben propagiert. Dies verhindert den Abbruch des gesamten Testlaufs. Der Fehlerstatus wird jedoch stets korrekt im Protokoll und Report festgehalten. Benutzt der Testfall eine Abhängigkeit, wird die Exception an den Catch Knoten derselben übergeben, falls ein solcher vorhanden ist. Diese Art der Behandlung von Exceptions (und Fehlern) wird im Kapitel Abhängigkeiten des Handbuchs erklärt.","hash":"sec_web_cleanup_package","h1":"Das Cleanup Package"},"443":{"id":443,"content":"Das Run-log Package Das Package qfs.run-log enthält Prozeduren, um Meldungen in das Protokoll zu schreiben. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: logError Schreibt eine Fehlermeldung ins Protokoll. logWarning Schreibt eine Warnung ins Protokoll. logMessage Schreibt eine Meldung ins Protokoll.","hash":"sec_web_run_log_package","h1":"Das Run-log Package"},"444":{"id":444,"content":"Das Run-log.Screenshots Package Das qfs.run-log.screenshots Package enthält Prozeduren, die Bildschirmabbilder ins Protokoll schreiben und einige Hilfsprozeduren. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: getMonitorCount Liefert die Anzahl der an den Computer angeschlossenen Monitore. logScreenshot Schreibt ein Bildschirmabbild des aktuellen Monitors ins Protokoll. logImageOfComponent Schreibt ein Bildschirmabbild einer Komponente ins Protokoll. logScreenshotOfMonitor Schreibt ein Bildschirmabbild eines angegebenen Monitors ins Protokoll.","hash":"sec_web_run_log_screenshots_package","h1":"Das Run-log.Screenshots Package"},"445":{"id":445,"content":"Das Shellutils Package Das qfs.shellutils Package beinhaltet Prozeduren für die wichtigsten Shell-Kommandos. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: copy Kopiert eine angegebene Datei oder ein Verzeichnis an eine neue Stelle. deleteFile Löscht eine angegebene Datei. exists Prüft, ob eine angegebene Datei oder ein Verzeichnis existiert. getBasename Gibt den Dateinamen einer Datei zurück. getParentDirectory Gibt die Verzeichnisstruktur einer Datei zurück. mkdir Erzeugt ein Verzeichnis. Noch nicht existierende Verzeichnisse werden angelegt. move Verschiebt eine angegebene Datei oder ein Verzeichnis. touch Erzeugt eine Datei. removeDirectory Löscht ein angegebenes Verzeichnis.","hash":"sec_web_shellutils_package","h1":"Das Shellutils Package"},"446":{"id":446,"content":"Das Utils Package Das Package qfs.utils enthält nützliche Prozeduren für häufig auftretende Anforderungen der Testentwicklung. Hier sehen Sie einige Prozeduren des Packages: getDate Gibt einen String zurück, der ein Datum enthält. Standardmäßig wird das aktuelle Datum zurückgegeben. (Andere Daten sind konfigurierbar.) getTime Gibt einen String zurück, der eine Zeit enthält. Standardmäßig wird die aktuelle Zeit zurückgegeben. (Andere Zeiten sind konfigurierbar.) logMemory Schreibt den aktuellen Speicherverbrauch ins Protokoll. printVariable Gibt den Inhalt einer spezifizierten Variable auf der Konsole aus. printMessage Gibt den Inhalt einer angegebenen Nachricht auf der Konsole aus. writeMessageIntoFile Schreibt einen angegebenen String in eine angegebene Datei.","hash":"sec_web_utils_package","h1":"Das Utils Package"},"447":{"id":447,"content":"Das Database Package Das Package qfs.database enthält nützliche Prozeduren, um mit Datenbanken zu interagieren. Bitte beachten Sie, dass die jar-Datei mit dem Datenbanktreiber vor dem Start von QF‑Test ins qftest Pluginverzeichnis kopiert werden muss. Für weitere Informationen über den Aufbau einer Datenbankverbindung kontaktieren Sie bitte einen Entwickler oder werfen Sie einen Blick auf www.connectionstrings.com. Die wichtigsten Prozeduren sind: executeSelectStatement Führt einen angegebenen SQL-Select-Befehl aus. Das Ergebnis wird zum einen in die globale Variable \"resultRows\" des Jython Variablenstacks geschrieben und ist somit in jedem Jython Skript verfügbar. Zum anderen wird das Ergebnis auch in eine Gruppenvariable mit dem Standardnamen \"resultGroup\" geschrieben und ist somit direkt von QF‑Test Knoten aus ansprechbar. executeStatement Führt einen angegebenen SQL Befehl aus. Hier kann jedes beliebige SQL Kommando ausgeführt werden.","hash":"sec_web_database_package","h1":"Das Database Package"},"448":{"id":448,"content":"Das Check Package Das qfs.check Package enthält Prozeduren, die Checks ausführen. Die wichtigsten Prozeduren sind: checkEnabledStatus Überprüft, ob eine Komponente en- bzw. disabled ist. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt. checkSelectedStatus Überprüft, ob eine Komponente selektiert bzw. nicht selektiert ist. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt. checkText Überprüft den Text einer Komponente. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt.","hash":"sec_web_check_package","h1":"Das Check Package"},"449":{"id":449,"content":"Das Databinder Package Das Package qfs.databinder enthält Prozeduren zur Ausführung innerhalb eines Datentreiber Knotens, um Daten für datengetriebenes Testen zu binden. Die wichtigsten Prozeduren sind: bindList Bindet eine Liste von Werten an eine Variable. Die Werte sind durch Leerzeichen oder das als Parameter übergebene Trennzeichen getrennt. bindSets Bindet Sätze von Werten an einen Satz von Variablen. Die Sätze von Werten sind durch Zeilenumbrüche getrennt, die Werte innerhalb eines Satzes durch Leerzeichen oder das als Parameter übergebene Trennzeichen.","hash":"sec_web_databinder_package","h1":"Das Databinder Package"},"450":{"id":450,"content":"Pro Tutorial","hash":"","h0":"Ablaufsteuerung (Web) | QF‑Test Tutorial"},"451":{"id":451,"content":"Pro Tutorial","hash":"home-link","h0":"Ablaufsteuerung (Web) | QF‑Test Tutorial"},"452":{"id":452,"content":"Ablaufsteuerung (Web) Dieses Kapitel ist auch als Video verfügbar unter 'Ablaufsteuerung'. Die zwei wichtigsten Kontrollstrukturen von QF‑Test sind Schleifen und die bedingte Ausführung von Knoten. Schleifen können über zwei verschieden Knoten implementiert werden: While und Schleife Knoten. If, Elseif und Else Knoten stehen für die bedingte Ausführung von Knoten zur Verfügung.","hash":"sec_controlstructuresweb","h1":"Ablaufsteuerung (Web)"},"453":{"id":453,"content":"Pro Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"454":{"id":454,"content":"Pro Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"455":{"id":455,"content":"If - else If Knoten kennen Sie bereits aus der Vorbereitung Sequenz im Kapitel Starten des Browsers. Sehen wir uns diesen nun etwas genauer an.","hash":"sec_ifweb","h0":"If - else"},"456":{"id":456,"content":"Abbildung 17.1: Setup Sequenz mit If/Elseif Knoten Über einen If Knoten können Sie steuern, ob bestimmte Knoten ausgeführt werden oder nicht. In unserem Fall geht es um den Start des SUT. Zunächst müssen wir herausfinden, ob die Applikation bereits läuft. Dies geschieht über den Warten auf Client Knoten, der als Ergebnis entweder true (wahr) oder false (falsch) in die Variable isSUTRunning schreibt.","hash":"fig_ControlsSetupSequenceWeb","h4":"Abbildung 17.1: Setup Sequenz mit If/Elseif Knoten"},"457":{"id":457,"content":"Abbildung 17.2: Warten auf Client setzt die Variable \"isSUTRunning\" mit dem Ergebnis Der If Knoten wertet die Ergebnisvariable isSUTRunning im 'Bedingung' Attribut aus. Da auf den Wert der Variablen zugegriffen werden soll, wird die Syntax $() verwendet (vgl. Hinweis zu Variablensyntax in Kapitel \"Prozedur mit Variable\").","hash":"fig_ControlsWaitForClientWeb","h4":"Abbildung 17.2: Warten auf Client setzt die Variable \"isSUTRunning\" mit dem Ergebnis"},"458":{"id":458,"content":"Abbildung 17.3: Der If Knoten wertet die Variable aus Je nachdem, ob die Applikation bereits läuft, führt QF‑Test die im If Knoten enthaltenen Knoten aus oder nicht. Beenden Sie das CarConfig Demo, falls es läuft. Führen Sie den Vorbereitung Knoten mit Einzelschritten aus. Führen Sie den Vorbereitung Knoten nochmals mit Einzelschritten aus während das CarConfig Demo läuft. In der Variablendefinition-Tabelle können Sie den Wert der Variablen isSUTRunning prüfen. Beim ersten Mal ist der Wert false und damit die Bedingung not $(isSUTRunning) wahr, d.h. die Knoten für den SUT-Start werden ausgeführt. Beim zweiten Mal ist der Wert true und damit die Bedingung false. Die Knoten im If Knoten werden übersprungen. Im ersten Knoten der Vorbereitung werden If Knoten verwendet, um abhängig vom Betriebssystem den zu verwendenden Web-Browser in einer globalen Variable zu hinterlegen. Der besseren Lesbarkeit halber werden hier nur If Knoten verwendet. Es wäre ebenso möglich mit Elseif und Else Knoten zu arbeiten. In einem Elseif Knoten wird eine weitere Bedingung formuliert, die dann geprüft wird, wenn die Bedingung im If Knoten nicht zutrifft. Die Kindknoten des Else Knoten werden nur dann ausgeführt, wenn weder die Bedingung des If noch die der Elseif Knoten zutreffen. Bei der Prüfung des Betriebssystems wird direkt auf eine QF‑Test Variable zugegriffen. QF‑Test speichert die Betriebssysteminformation in einer Gruppenvariable ab, wobei die Gruppe qftest und die Variablen linux, macos oder windows heißen. Die Syntax für den Zugriff auf Gruppenvariablen ist ${group:varname}, z.B. ${qftest:windows}.","hash":"fig_ControlsIfWeb","h4":"Abbildung 17.3: Der If Knoten wertet die Variable aus"},"459":{"id":459,"content":"Pro Tutorial","hash":"","h0":"Schleifen | QF‑Test Tutorial"},"460":{"id":460,"content":"Pro Tutorial","hash":"home-link","h0":"Schleifen | QF‑Test Tutorial"},"461":{"id":461,"content":"Schleifen QF‑Test stellt zwei Knotentypen für die Implementierung von Schleifen zur Verfügung: Schleife Knoten führen ihre Kindknoten so oft aus, wie angegeben ist. Man kann die Schleife jedoch über einen Break Knoten jederzeit verlassen. While Knoten führen ihre Kindknoten so oft aus, bis die angegebene Bedingung nicht mehr gegeben ist. Derartige Schleifen können ebenfalls über einen Break Knoten jederzeit verlassen werden. Schleife Knoten enden auf jeden Fall nach der angegeben Anzahl von Wiederholungen. Bei While Knoten muss man jedoch selbst dafür sorgen, dass die Ausführung irgendwann endet, indem die Bedingung falsch wird. Ansonsten kommt es zur Endlosschleife. Im interaktiven Modus können Sie in so einem Fall einfach die Pausetaste drücken. Im Batch-Modus, d.h. wenn Sie QF‑Test mit dem Kommandozeilenparameter -batch starten um die angegebene Testsuite ohne die QF‑Test Benutzeroberfläche auszuführen, müssen Sie dann jedoch den QF‑Test Prozess \"abschießen\". In der folgenden Übung wollen wir einen Testfall implementieren, der prüft, ob eine bestimmte Zeile in der Tabelle des CarConfig Demos angezeigt wird. Die im Testfall durchgeführten Aktionen sind: Anzahl Tabellenzeilen bestimmen. Über alle Zeilen iterieren und prüfen, ob die Zeile passt. Wenn die Zeile gefunden wurde, die Schleife abbrechen. Falls die Zeile nicht gefunden wurde, einen Fehler ins Protokoll schreiben. Bitte beginnen Sie mit der Aufnahme eines Checks auf die zu suchende Zeile: Aktivieren Sie den Check-Aufnahmemodus über \"Checks aufnehmen\" . Führen Sie einen Rechtsklick auf eine Tabellenzeile im CarConfig Demo aus und wählen Sie den Menüpunkt »Zeile« aus dem Popup-Menü. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Ändern Sie den Namen der aufgenommenen Sequenz z.B. in Zeile prüfen. Wandeln Sie die Sequenz in einen Testfall um: Rechtsklick auf den Sequenz Knoten und Auswahl des Untermenüpunkts »Knoten konvertieren in«-»Testfall« im Popup-Menü.","hash":"sec_loopsweb","h0":"Schleifen"},"462":{"id":462,"content":"Abbildung 17.4: Knoten konvertieren In QF‑Test können Sie sehr effizient Knoten hinzufügen, indem Sie einen Knoten in einen anderen einpacken: Öffnen Sie den Testfall Knoten und packen Sie den aufgenommenen Check Knoten in eine Schleife indem Sie rechts auf den Knoten klicken und in dem sich öffnenden Popupmenü den Punkt »Knoten einpacken in«-»Schleife« auswählen.","hash":"fig_ControlsTransformNodeIntoWeb","h4":"Abbildung 17.4: Knoten konvertieren"},"463":{"id":463,"content":"Abbildung 17.5: Knoten einpacken QF‑Test ermittelt dynamisch, in welche Knoten ein Knoten eingepackt werden kann und bietet nur diese zur Auswahl an. Entsprechend kann es passieren, dass Sie \"Schleife\" im Untermenü nicht finden. Sie sollten dann prüfen, ob Sie den Rechtsklick auf den richtigen Knoten ausgeführt haben. Dasselbe gilt für die Operationen \"Knoten konvertieren in\" und \"Knoten einfügen\". Als nächstes setzen wir den Wert für das Attribut 'Anzahl Wiederholungen' des Schleife Knoten. Dazu müssen wir bestimmen, wie viele Zeilen die Tabelle hat. Es gibt keinen Knoten, der diese Operation direkt ausführen kann. Allerdings gibt es eine derartige Prozedur in der im letzten Kapitel besprochenen Standardbibliothek. Diese befindet sich im Package qfs.web.table und heißt getRowCount. Selektieren Sie den Testfall Knoten und drücken Strg⁠+⁠A. Klicken Sie die Schaltfläche \"Prozedur auswählen\" links neben der Überschrift 'Name der Prozedur'. Wählen Sie den Reiter 'qfs.qft' im 'Prozedur auswählen' Dialog. Navigieren Sie zu 'getRowCount' im Package 'qfs.web.table' Drücken Sie 'OK' um die Prozedur auszuwählen. Das Hinzufügen einer Prozedur über Strg⁠+⁠A wurde in Manuelle Erstellung von Prozeduren beschrieben. Dort finden Sie auch Screenshots zur Aktion. Fügen Sie eine Variable mit dem Namen Zeilen im Attribut 'Variable für Rückgabewert' ein. Ändern Sie den Standardwert für id in der Variablendefinitionen-Tabelle auf die QF‑Test Komponenten ID der Tabelle VehicleTable. Wählen Sie den 'Schleife'-Knoten. Im Attribut 'Anzahl Wiederholungen' des Schleife Knotens tragen Sie eine Referenz auf die Variable $(Zeilen) ein. Tragen Sie den Namen der Zählervariable, z.B. i, im entsprechenden Attribut des Schleife Knotens ein.","hash":"fig_ControlsPackNodeIntoWeb","h4":"Abbildung 17.5: Knoten einpacken"},"464":{"id":464,"content":"Abbildung 17.6: Details eines Schleife Knotens In den Details des Check Knotens tragen wir nun in der QF‑Test ID der Komponente statt des aufgenommenen Zeilenindex eine Referenz auf die Zählervariable ein und setzen eine Ergebnisvariable. Außerdem fügen wir einen If Knoten unter dem Check Knoten hinzu, der das Ergebnis auswertet und die Schleife über einen Break Knoten verlässt, wenn die entsprechende Zeile gefunden wurde. Öffnen Sie den Schleife Knoten. Selektieren Sie den Check Knoten. Ändern Sie den aufgenommenen Zeilenindex der QF‑Test ID der Komponente in Zählervariable $(i). Die QF‑Test ID der Komponente sollte nun VehicleTable@Modell&$(i) lauten. Tragen Sie den Variablennamen ZeileGefunden in das Attribut 'Variable für Ergebnis' ein. Führen Sie einen Rechtsklick auf den Check Knoten aus und wählen Sie aus dem Popup-Menü den Unterpunkt »Knoten einfügen«-»Ablaufsteuerung«-»Break« aus. Packen Sie den Break Knoten in einen If Knoten mittels des Tastaturkürzels Strg⁠+⁠Umschalt⁠+⁠I (Sie können natürlich auch über das Menü gehen). In den Details des 'If'-Knotens tragen Sie $(ZeileGefunden) im Attribut 'Bedingung' ein. Die Variable ZeileGefunden wird vom Check Knoten entweder auf den Wert 'true' oder auf den Wert 'false' gesetzt, so dass wir im Attribut 'Bedingung' des If Knoten nur die Referenz auf die Variable $(ZeileGefunden) einzutragen brauchen. In den nächsten Schritten wollen wir einen Else Knoten als letzten Knoten im Schleife Knoten einfügen. Er wird nur ausgeführt, wenn die Schleife so oft wie angegeben ausgeführt wurde, was in unserem Fall bedeutet, dass die Variable ZeileGefunden nie wahr wurde, weil die Zeile nicht gefunden wurde. Schließen Sie den If Knoten, falls dies nicht bereits der Fall ist. Dies ist wichtig, da sonst der Else Knoten zum If Knoten und nicht zum Schleife Knoten gehören würde. Führen Sie einen Rechtsklick auf den If Knoten aus und wählen Sie auf dem Popup-Menü den Unterpunkt »Knoten einfügen«-»Ablaufsteuerung«-»Else«. Öffnen Sie den Else Knoten. Fügen Sie aus der Standardbibliothek die Prozedur logError aus dem Package qfs.run-log wie oben beschrieben ein. In der 'Variablendefinitionen' Tabelle tragen Sie Zeile nicht gefunden als Wert der Zeile message ein. Tragen Sie true als Wert der Zeile withScreenshots ein. Wenn Sie die Tests im Batch-Modus ausführen, sind Screenshots eine gute Unterstützung bei der Fehleranalyse. Da aber eine große Zahl Screenshots sehr große Protokolldateien erzeugen würden, ist der Standardwert für withScreenshots false. Nun bleibt nur noch, den Testfall mit Vorbereitung und Aufräumen Knoten zu vervollständigen und ihn in den oberen Teil der Testsuite zu verschieben. Kopieren Sie die Vorbereitung und Aufräumen Knoten aus 'Testset: Einfache Tests' in den neuen Testfall als ersten und letzten Knoten. Verschieben Sie den Testfall aus dem Bereich Extrasequenzen in den oberen Bereich der Testsuite hinter den Knoten 'Testset: Einfache Tests'. Damit würde der neue Testfall wie folgt aussehen:","hash":"fig_ControlsLoopDetailsWeb","h4":"Abbildung 17.6: Details eines Schleife Knotens"},"465":{"id":465,"content":"Abbildung 17.7: Der neue Testfall Führen Sie den neuen Testfall aus. Er sollte ohne Fehler laufen. Ändern Sie nun in den Details des Check Elemente Knotens den Namen des Fahrzeugs zum Beispiel auf Falscher Wert.","hash":"fig_ControlsTestcaseWeb","h4":"Abbildung 17.7: Der neue Testfall"},"466":{"id":466,"content":"Abbildung 17.8: Details eines Check Elemente Knoten Führen Sie den Testfall nochmals aus. Nun sollte der Test den Else Knoten der Schleife ausführen und eine Fehlermeldung anzeigen.","hash":"fig_ControlsCheckDetailsWeb","h4":"Abbildung 17.8: Details eines Check Elemente Knoten"},"467":{"id":467,"content":"Pro Tutorial","hash":"","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Web) | QF‑Test Tutorial"},"468":{"id":468,"content":"Pro Tutorial","hash":"home-link","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Web) | QF‑Test Tutorial"},"469":{"id":469,"content":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Web) Dieses Kapitel ist auch als Video verfügbar unter 'Nun ist es Zeit, Ihre eigene Anwendung zu starten'. Nachdem wir so viel Zeit mit all den Beispielanwendungen verbracht haben, sind Sie nun wirklich bereit, Ihre eigene Applikation zu starten (falls Sie dies nicht schon zwischendurch getan haben). Der Schnellstart-Assistent, welcher über das Menü »Extras«-»Schnellstart-Assistent...« erreichbar ist, hilft Ihnen bei dieser Aufgabe. Folgen Sie einfach den Schritten innerhalb des Assistenten, um eine passende Startsequenz zu erzeugen. Bitte schauen Sie auch ins Handbuch Kapitel 3 \"Schnellstart\". Es ist an der Zeit, das Gelernte in die Tat umzusetzen - kurze Sequenzen von Events und Checks aufzunehmen, Prozeduren zu erzeugen etc., um eine eigene Testbibliothek aufzubauen. Damit endet der Basisteil in diesem Tutorial.","hash":"sec_ownappweb","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Web)"},"470":{"id":470,"content":"Pro Tutorial","hash":"","h0":"Native Windows GUIs testen mit QF‑Test | QF‑Test Tutorial"},"471":{"id":471,"content":"Pro Tutorial","hash":"home-link","h0":"Native Windows GUIs testen mit QF‑Test | QF‑Test Tutorial"},"472":{"id":472,"content":"Native Windows GUIs testen mit QF‑Test Dieser Teil III des Tutorials soll Ihnen die Basiseigenschaften und -arbeitsabläufe von QF‑Test erläutern. Er fokussiert sich auf das Testen von nativen Windows-Anwendungen. Wenn Sie Java- oder Web-Anwendungen testen wollen, empfehlen wir \"Java-GUIs testen mit QF‑Test\" beziehungsweise \"Web GUIs testen mit QF‑Test\". Alle Basisteile vermitteln die gleichen Schulungsinhalte, nutzen für die Beispiele jedoch eine jeweils passende Testanwendung. Im \"Weiterführende Features von QF‑Test\" werden weiterführende Funktionalitäten von QF‑Test erklärt, die für Tests sowohl von Java-, Web- und nativen Windows-Anwendungen genutzt werden können.","hash":"sec_win","h1":"Native Windows GUIs testen mit QF‑Test"},"473":{"id":473,"content":"Pro Tutorial","hash":"","h0":"Bearbeiten einer Beispiel-Testsuite (Win) | QF‑Test Tutorial"},"474":{"id":474,"content":"Pro Tutorial","hash":"home-link","h0":"Bearbeiten einer Beispiel-Testsuite (Win) | QF‑Test Tutorial"},"475":{"id":475,"content":"Bearbeiten einer Beispiel-Testsuite (Win) Dieses Kapitel ist auch als Video verfügbar unter 'Bearbeiten einer Beispiel-Testsuite'. In diesem ersten Kapitel werden wir uns die Struktur einer einfachen Testsuite anschauen, die wesentlichen Bestandteile erklären, sie ausführen und das Ergebnis auswerten.","hash":"sec_demoWin","h1":"Bearbeiten einer Beispiel-Testsuite (Win)"},"476":{"id":476,"content":"Pro Tutorial","hash":"","h0":"Laden der Testsuite | QF‑Test Tutorial"},"477":{"id":477,"content":"Pro Tutorial","hash":"home-link","h0":"Laden der Testsuite | QF‑Test Tutorial"},"478":{"id":478,"content":"Laden der Testsuite Beim ersten Start von QF‑Test und/oder der zu testenden Anwendung über QF‑Test kann eine Sicherheitswarnung der Firewall auftreten mit der Frage, ob das Netzwerkprotokoll für Java geblockt werden soll oder nicht. Da QF‑Test die Java-Netzwerkprotokolle für die Kommunikation mit dem SUT (System under Test) nutzt, darf diese nicht geblockt werden, um das automatisierte Testen zu ermöglichen. Nach dem Starten von QF‑Test laden Sie bitte unser erstes Beispiel: Drücken Sie den Knopf , um den Dateiauswahl-Dialog zu öffnen. Wechseln Sie in das Unterverzeichnis qftest-10.0.2-pro/doc/tutorial Ihrer QF‑Test Installation. Dort wählen Sie bitte die Datei ErsteWinTests.qft aus und öffnen diese. QF‑Test präsentiert Ihnen die Testsuite wie im folgenden Bild dargestellt:","hash":"tut_loadSuiteWin","h0":"Laden der Testsuite"},"479":{"id":479,"content":"Abbildung 19.1: Das Fenster der Testsuite ErsteWinTests.qft Der linke Bereich des Hauptfensters enthält die Testsuite, die in einer Baumstruktur dargestellt wird. Rechts befindet sich die Detailansicht des Knotens, der im Baum gerade markiert ist. (Falls die Detailansicht bei Ihnen nicht zu sehen sein sollte, aktivieren Sie diese bitte über das Menü »Ansicht«-»Details anzeigen«.) Im Bereich unten rechts befindet sich das Terminal, welches die Ausgaben von QF‑Test und dem zu testenden Client protokolliert. Mit Hilfe des Baumes können Sie durch die Testsuite navigieren und einzelne Knoten auswählen, für die dann jeweils die Details im rechten Fensterbereich eingeblendet werden. Doppelklicken Sie bitte den Knoten Testfallsatz: Einfache Tests um ihn zu expandieren und die darin liegenden Knoten sehen zu können. Der Testfallsatz enthält primär zwei Testfälle, umgeben von einem \"Vorbereitung\"/\"Aufräumen\" Knotenpaar, das im Wesentlichen die Testanwendung startet bzw. beendet.","hash":"fig_firstTestSuiteWin","h4":"Abbildung 19.1: Das Fenster der Testsuite ErsteWinTests.qft"},"480":{"id":480,"content":"Abbildung 19.2: Der Inhalt des Testfallsatz Knotens In den folgenden Abschnitten werden wir Funktion und Zweck der einzelnen Knoten erklären.","hash":"fig_firstTestSetWin","h4":"Abbildung 19.2: Der Inhalt des Testfallsatz Knotens"},"481":{"id":481,"content":"Pro Tutorial","hash":"","h0":"Starten der Anwendung | QF‑Test Tutorial"},"482":{"id":482,"content":"Pro Tutorial","hash":"home-link","h0":"Starten der Anwendung | QF‑Test Tutorial"},"483":{"id":483,"content":"Starten der Anwendung Zuerst wollen wir die Vorbereitung genauer unter die Lupe nehmen: Expandieren Sie den Knoten Vorbereitung: Demo starten, wie im folgenden Bild gezeigt.","hash":"tut_startSutWin","h0":"Starten der Anwendung"},"484":{"id":484,"content":"Abbildung 19.3: Der Knoten \"Vorbereitung\" Es werden zwei Kindknoten sichtbar: Variable setzen - der Variablen 'client', wird der Verbindungsname für das zu startende SUT zugewiesen, der für jeden Zugriff auf die Applikation benötigt wird. Sequenz: Starte Client wenn nötig - startet das zu testende System (SUT), wenn es nicht schon läuft. Lassen Sie uns noch einen kurzen Blick in die Sequenz: Starte Client wenn nötig werfen:","hash":"fig_firstSetupWin","h4":"Abbildung 19.3: Der Knoten \"Vorbereitung\""},"485":{"id":485,"content":"Abbildung 19.4: Die Sequenz zum Starten des Client Zu Beginn steht ein Warten auf Client Knoten, der prüft, ob der Client bereits läuft. Nur wenn dies nicht der Fall ist, wird er gestartet. Der \"Windows Client starten\"-Knoten führt die Anwendung aus und stellt die Verbindung zwischen dem Client und QF‑Test her. Um unabhängig vom absoluten Verzeichnispfad der Applikation zu sein, verwenden wir einen relativen Pfad, ausgehend vom QF‑Test Installationsverzeichnis, dass über die Variable ${qftest:dir.version} angegeben wird (siehe Handbuchkapitel Variablen). Wir wollen nun die Anwendung wirklich starten: Markieren Sie dazu bitte den Knoten Vorbereitung: Demo starten, doch belassen Sie ihn aufgeklappt. Klicken Sie den Knopf Wiedergabe. Dies führt den aktuellen ausgewählten Knoten aus. Während der Ausführung wird der gerade aktive Knoten durch \"->\" markiert. Nach Abschluss der Startsequenz sollte die Demoapplikation \"CarConfiguratorNet Form\" am Bildschirm erscheinen. Da QF‑Test nach Ende der Wiedergabe den Fokus zurückerhält, kann die Demoapplikation dadurch auch wieder verdeckt worden sein.","hash":"fig_firstStartWin","h4":"Abbildung 19.4: Die Sequenz zum Starten des Client"},"486":{"id":486,"content":"Abbildung 19.5: Das Windows CarConfigurator Demo","hash":"fig_CarConfigWin","h4":"Abbildung 19.5: Das Windows CarConfigurator Demo"},"487":{"id":487,"content":"Pro Tutorial","hash":"","h0":"Ein erster Testfall | QF‑Test Tutorial"},"488":{"id":488,"content":"Pro Tutorial","hash":"home-link","h0":"Ein erster Testfall | QF‑Test Tutorial"},"489":{"id":489,"content":"Ein erster Testfall Als nächstes wollen wir einen Blick auf den ersten Testfall werfen. Er besteht aus vier Testschritten:","hash":"tut_firstTestWin","h0":"Ein erster Testfall"},"490":{"id":490,"content":"Abbildung 19.6: Der \"Erste\" Testfallknoten Zurücksetzen - stellt den Anfangszustand der Anwendung über das Menü Datei->Zurücksetzen wieder her und selektiert den Tab Fahrzeuge. Modell I5 wählen - Wählt das letzte Modell I5 in der Fahrzeugetabelle aus. Sondermodell Jazz wählen - Wechselt zum Tab Sondermodelle und wählt dort Jazz. Endpreis prüfen - Überprüft, dass der berechnete Wert dem Feldes Endpreis unten rechts einem vorgegebenen Wert entspricht. Testschritte sind oft hilfreich, um einen Testfalls zu strukturieren und dadurch lesbar und verständlicher zu gestalten. Dies erleichtert später eine eventuelle Fehlersuche oder Anpassungen des Testfalls. Bitte expandieren Sie die vier Testschritt Knoten.","hash":"fig_firstTestCaseWin","h4":"Abbildung 19.6: Der \"Erste\" Testfallknoten"},"491":{"id":491,"content":"Abbildung 19.7: Die Details des ersten Testfalls Sie sehen diverse Mausklicks sowie einen Check. Zur besseren Lesbarkeit des Testfalls wurden sie mittels Testschrittknoten strukturiert. Neben der Aktionsart (Mausklick, Check) wird angezeigt, auf welche Anwendungskomponente sich die Aktion bezieht, also wohin z.B. der Mausklick geht. Diese Knoten können direkt über die Aufnahmefunktion von QF‑Test erzeugt werden. Näheres hierzu erfahren Sie im nächsten Kapitel Erstellen einer eigenen Testsuite (Win). Wir wollen uns nun die Ausführung des ersten Testfalls anschauen. Markieren Sie dazu den Testfall: Erster Knoten. Drücken Sie anschließend den Wiedergabeknopf . Die Testschritte werden nun der Reihe nach abgespielt. Das aktuelle Testergebnis wird während und nach dem Testlauf in der Statuszeile am unteren rechten Rand des QF‑Test Hauptfensters angezeigt und sollte \"Beendet: Keine Fehler\" lauten. Daneben zeigt QF‑Test verschiedene Zähler an. Der erste Zähler bezieht sich auf die Anzahl der ausgeführten Testfälle, der zweite auf die Zahl der ausgeführten Testfälle ohne Fehler. In unserem Fall wurde ein Testfall fehlerfrei ausgeführt, was einer Erfolgsquote von 100% entspricht.","hash":"fig_firstTestCaseDetailsWin","h4":"Abbildung 19.7: Die Details des ersten Testfalls"},"492":{"id":492,"content":"Abbildung 19.8: Die Ergebnisanzeige in der Statusleiste Wenn Sie den Mauszeiger auf dem Symbol eines Testfallzählers ruhen lassen, wird Ihnen eine entsprechende Beschreibung angezeigt. Eine Auflistung aller Testfallzähler finden Sie im Kapitel Aufnahme und Wiedergabe des Handbuchs.","hash":"fig_resultOneTestCaseNoErrorWin","h4":"Abbildung 19.8: Die Ergebnisanzeige in der Statusleiste"},"493":{"id":493,"content":"Pro Tutorial","hash":"","h0":"Ein zweiter Testfall - mit Fehler | QF‑Test Tutorial"},"494":{"id":494,"content":"Pro Tutorial","hash":"home-link","h0":"Ein zweiter Testfall - mit Fehler | QF‑Test Tutorial"},"495":{"id":495,"content":"Ein zweiter Testfall - mit Fehler Der zweite Testfall wird uns zeigen, was passiert, wenn ein Fehler bei der Testausführung auftritt. Bitte expandieren Sie den Knoten Testfall: Zweiter (mit Fehler).","hash":"tut_secondTestWin","h0":"Ein zweiter Testfall - mit Fehler"},"496":{"id":496,"content":"Abbildung 19.9: Der \"Zweite\" Testfallknoten Bis auf den dritten Testschritt sieht es bekannt aus. Was tut der Unbekannte? Testschritt: 10% Rabatt gewähren - Schreibt den Wert 10 in das Rabattfeld Die Texteingabe ist eine weitere Basisaktion. Eingabe-Knoten kann man ebenfalls direkt über die Aufnahmefunktion generieren lassen. Den Wert 10 sieht man im Feld \"Text\" rechts und auch direkt im Text des Baumknotens. Expandieren Sie den Knoten Testschritt: 10% Rabatt gewähren.","hash":"fig_secondTestCaseWin","h4":"Abbildung 19.9: Der \"Zweite\" Testfallknoten"},"497":{"id":497,"content":"Abbildung 19.10: Die Details des zweiten Testfalls Wir wollen uns die Ausführung des zweiten Testfalls anschauen. Markieren Sie dazu den Testfall: Zweiter (mit Fehler) Knoten. Drücken Sie anschließend den Wiedergabeknopf . Diesmal erscheint ein Dialog mit der Information, dass ein Fehler aufgetreten ist.","hash":"fig_secondTestCaseDetailsWin","h4":"Abbildung 19.10: Die Details des zweiten Testfalls"},"498":{"id":498,"content":"Abbildung 19.11: Fehler im zweiten Testfall Was ist passiert? Fast immer wenn so ein Fall auftritt, ist es sinnvoll das Protokoll zu Rate zu ziehen. Alternativ könnte man den Testfall zur Fehlersuche nochmal im Debug-Modus ausführen. Diese Vorgehensweise wird in Kapitel Benutzen des Debuggers (Java) erläutert.","hash":"fig_textTestErrorWin","h4":"Abbildung 19.11: Fehler im zweiten Testfall"},"499":{"id":499,"content":"Pro Tutorial","hash":"","h0":"Das Protokoll zur Fehlerdiagnose | QF‑Test Tutorial"},"500":{"id":500,"content":"Pro Tutorial","hash":"home-link","h0":"Das Protokoll zur Fehlerdiagnose | QF‑Test Tutorial"},"501":{"id":501,"content":"Das Protokoll zur Fehlerdiagnose QF‑Test protokolliert detaillierte Informationen für jede Testausführung. Öffnen Sie nun bitte das letzte Protokoll über eine der folgenden Möglichkeiten: den Protokoll anzeigen Knopf im Fehlerdialog oder falls Sie den Dialog bereits geschlossen haben den Button in der Werkzeugleiste oder über die Tastenkombination Strg⁠+⁠L. Die Protokolle der letzten Testläufe können auch über die unteren Einträge im Menü 'Wiedergabe' aufgerufen werden. Das Protokoll öffnet sich in einem separaten Fenster und zeigt die protokollierten Aktionen des zweiten Testfalls, den Sie soeben ausgeführt haben:","hash":"tut_firstRunlogWin","h0":"Das Protokoll zur Fehlerdiagnose"},"502":{"id":502,"content":"Abbildung 19.12: Protokoll des zweiten Testfalls Das Protokoll ist in seinem Aufbau ähnlich zu dem der Testsuite. Der Baum links enthält wieder die bekannten Knoten, jedoch dieses Mal in der zeitlichen Abfolge des Testlaufs. Wenn man einen Knoten anwählt, sieht man rechts die Details inklusive Zeitstempel und Ausführungsdauer. Im Baum links werden Ihnen rote Rahmen um einige Knoten auffallen. Diese zeigen an, dass sich darunter Fehler befinden. Wenn man den rot umrandeten Knoten Ebene für Ebene folgt, erreicht man irgendwann den Fehler. Schneller und bequemer geht es über den Button Nächsten Fehler finden in der Werkzeugleiste oder auch die Tastenkombination [Strg-N]. Alle rot markierten Knoten werden expandiert und der Knoten mit dem eigentlichen Fehler wird selektiert:","hash":"fig_firstErrorRunlogWin","h4":"Abbildung 19.12: Protokoll des zweiten Testfalls"},"503":{"id":503,"content":"Abbildung 19.13: Fehlerdiagnose für den zweiten Testfall Die Fehlermeldung auf der rechten Seite gibt an, dass der erhaltene Wert des Endpreis Feldes nicht dem erwarteten entspricht. Dieser Fehler wurde natürlich mit Absicht eingebaut, um zu zeigen, wie man bei der Analyse vorgehen kann. Hilfreich bei der Fehleranalyse ist üblicherweise auch der übernächste Protokollknoten Bildschirmabbild. Seine Detailansicht enthält ein vollständiges Abbild des Bildschirms zum Zeitpunkt des Fehlers. Dies ist sehr nützlich, um den Zustand des SUTs zu sehen und daraus eventuell die Fehlerursache ableiten zu können. Die folgende Grafik zeigt den Knoten:","hash":"fig_firstErrorRunlogDetailsWin","h4":"Abbildung 19.13: Fehlerdiagnose für den zweiten Testfall"},"504":{"id":504,"content":"Abbildung 19.14: Knoten mit Bildschirmabbild der Fehlersituation Neben dem Abbild aller Bildschirme speichert QF‑Test auch Bilder der einzelnen Fenster des SUT zum Fehlerzeitpunkt. Dies erlaubt Ihnen deren Inhalt zu analysieren, auch wenn diese eigentlich durch andere Fenster oder Dialoge verdeckt sind.","hash":"fig_firstErrorRunlogScreenshotWin","h4":"Abbildung 19.14: Knoten mit Bildschirmabbild der Fehlersituation"},"505":{"id":505,"content":"Pro Tutorial","hash":"","h0":"Wo finde ich Hilfe? | QF‑Test Tutorial"},"506":{"id":506,"content":"Pro Tutorial","hash":"home-link","h0":"Wo finde ich Hilfe? | QF‑Test Tutorial"},"507":{"id":507,"content":"Wo finde ich Hilfe? In diesem Abschnitt machen wir eine kleine Pause, um einige allgemeine Hinweise zu geben. Es gibt verschiedene Möglichkeiten, um Hilfe oder Antworten zu finden: Die umfassendste Suche kann man über »Hilfe«-»Online Suche...« anstoßen. Dies bringt Sie auf die Suchfunktionalität unserer Homepage und erlaubt Ihnen die Abfrage aller verfügbarer Dokumentation (Handbuch, Tutorial, Standardbibliothek, Blog und unsere Videos). Die angezeigten Suchergebnisse können passend gefiltert werden. Wenn Sie offline arbeiten und nach einem Thema suchen wollen, können Sie die Offline-Versionen von Handbuch und Tutorial nutzen, die über das »Hilfe« Menü verfügbar sind. QF‑Test bietet eine kontextsensitive Hilfe für alle Baumknoten und deren Detailattribute an. Um diese zu nutzen, klicken Sie einfach mit der rechten Maustaste auf den gewünschten Knoten oder das Attribut in der Detailansicht. Im Kontextmenü wählen Sie dann den Eintrag »Was ist das?«. Dieser bringt Sie direkt zur passenden Referenzbeschreibung ins Handbuch. Neben der Hilfestellung in der Dokumentation haben Sie auch die Möglichkeit unser Support-Team zu kontaktieren. Während Ihrer Evaluationsphase und anschließend als Kunde mit einem gültigen Pflegevertrag können Sie Ihre Fragen direkt an unsere Supportexperten richten über das Support-Formular im QF‑Test Hilfe-Menü »Support-Team kontaktieren« oder über unsere Webseite.","hash":"tut_firstHelpWin","h0":"Wo finde ich Hilfe?"},"508":{"id":508,"content":"Pro Tutorial","hash":"","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"509":{"id":509,"content":"Pro Tutorial","hash":"home-link","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"510":{"id":510,"content":"Beenden der Anwendung Wir haben noch nicht die Aufräumsequenz angeschaut und wollen dies nun tun: Expandieren Sie den Aufräumen: Demo beenden Knoten.","hash":"tut_firstCleanupWin","h0":"Beenden der Anwendung"},"511":{"id":511,"content":"Abbildung 19.15: Die Aufräumsequenz Unsere Aufräumsequenz stoppt \"hart\" den Client-Prozess und wartet anschließend, bis sich dieser vollständig beendet hat. Dies ist eine sehr einfache Variante aber für den Moment ausreichend. Führen Sie die Aufräumsequenz aus und lassen damit den CarConfigurator verschwinden.","hash":"fig_firstCleanupWin","h4":"Abbildung 19.15: Die Aufräumsequenz"},"512":{"id":512,"content":"Pro Tutorial","hash":"","h0":"Ein vollständiger Testlauf | QF‑Test Tutorial"},"513":{"id":513,"content":"Pro Tutorial","hash":"home-link","h0":"Ein vollständiger Testlauf | QF‑Test Tutorial"},"514":{"id":514,"content":"Ein vollständiger Testlauf Nachdem wir uns Schritt für Schritt durch den Testfallsatz gearbeitet haben, wollen wir nun alles in einem Rutsch ausführen. Schließen Sie bitte das \"CarConfigurator Demo\", falls es noch läuft. Markieren Sie den Testfallsatz \"Einfache Tests\". Führen Sie ihn aus mittels . Der Testlauf endet mit dem bekannten Fehler. Wenn Sie nun bitte mittels das Protokoll öffnen, sehen Sie, wie QF‑Test den Test abgearbeitet hat.","hash":"tut_firstFullRunWin","h0":"Ein vollständiger Testlauf"},"515":{"id":515,"content":"Abbildung 19.16: Das Protokoll des gesamten Testfallsatzes Man sieht, dass die Vorbereitungs- und Aufräumenknoten vor bzw. nach jedem Testfall ausgeführt werden. Dies ist eine Eigenschaft, die diese im Zusammenspiel mit einem Testfallsatzknoten entwickeln. Dadurch wird für jeden Testfall immer ein sauberer Ausgangszustand hergestellt. Das SUT nach jedem Testfall zu beenden ist nicht die eleganteste Art, einen sauberen Ausgangszustand zu erreichen. Elegantere Wege zur Herstellung einer definierten Testausgangssituation und Durchführung der notwendigen Aufräumarbeiten werden in Kapitel (\"Abhängigkeiten: Automatisches Sicherstellen der korrekten Vorbedingungen jedes Testfalles\") dieses Tutorials erklärt.","hash":"fig_firstRunlogFullWin","h4":"Abbildung 19.16: Das Protokoll des gesamten Testfallsatzes"},"516":{"id":516,"content":"Pro Tutorial","hash":"","h0":"Reportgenerierung | QF‑Test Tutorial"},"517":{"id":517,"content":"Pro Tutorial","hash":"home-link","h0":"Reportgenerierung | QF‑Test Tutorial"},"518":{"id":518,"content":"Reportgenerierung Im Qualitätssicherungsprozess ist es wichtig, Testergebnisse zu dokumentieren und auch zu archivieren. QF‑Test bietet die Möglichkeit, aus Protokollen Testreports zu generieren. Wir wollen dies für das gerade aufgezeichnete Protokoll beispielhaft durchführen. Öffnen Sie bitte das Protokoll und wählen im Menü »Datei«-»Report erstellen...«.","hash":"tut_firstReportWin","h0":"Reportgenerierung"},"519":{"id":519,"content":"Abbildung 19.17: Auswahldialog für die Reportgenerierung Im ersten Feld können Sie den Dateinamen des Reports festlegen. QF‑Test bietet drei Arten von Reports - HTML, XML und JUnit Format. Das XML Format können Sie verwenden, wenn Sie die Reports zum Beispiel mit Hilfe eigener XSLT Stylesheets selbst gestalten wollen. JUnit-Reports erweisen sich als hilfreich, wenn es darum geht, Resultate in Build- oder Testmanagement-Tools zu importieren. Wir wollen uns nun einen einfachen HTML Report zu unserem letzten Testlauf erzeugen lassen. Lassen Sie bitte die vorgegebenen Optionen unverändert. Bestätigen Sie den Reportdialog mit OK. Anschließend sollte sich Ihr Browser automatisch mit einem Ergebnis äquivalent zum folgenden Bild öffnen:","hash":"fig_WinReportDialog","h4":"Abbildung 19.17: Auswahldialog für die Reportgenerierung"},"520":{"id":520,"content":"Abbildung 19.18: Ein HTML Report Der Testbericht beginnt mit einer Zusammenfassung mit allgemeinen Systeminformationen im linken Bereich, einer Legende der verwendeten Symbole rechts, einem Überblicks-Tortendiagramm in der Mitte und dem Gesamtergebnis darunter. In unserem Fall bei einem fehlerhaften von zwei ausgeführten Testfällen eine Erfolgsquote von 50%. Auf die Zusammenfassung folgen drei Übersichten: Testsuiten, die in diesem Testlauf ausgeführt wurden. Testsuiten, in denen Fehler aufgetreten sind. Fehler, mit Ihrem genauen Ort und Fehlermeldung Die Reporterstellung in QF‑Test ist ein praktisches Hilfsmittel, um einen Überblick über einen Testlauf zu gewinnen und ein Dokument zu Präsentations- und Archivierungszwecken zu erstellen.","hash":"fig_WinReportHtml","h4":"Abbildung 19.18: Ein HTML Report"},"521":{"id":521,"content":"Pro Tutorial","hash":"","h0":"Erstellen einer eigenen Testsuite (Win) | QF‑Test Tutorial"},"522":{"id":522,"content":"Pro Tutorial","hash":"home-link","h0":"Erstellen einer eigenen Testsuite (Win) | QF‑Test Tutorial"},"523":{"id":523,"content":"Erstellen einer eigenen Testsuite (Win) Dieses Kapitel ist auch als Video verfügbar unter 'Erstellen einer eigenen Testsuite'. In diesem zweiten Kapitel des Windows Tutorials werden wir selbst Sequenzen zum Starten und Beenden des SUT erstellen. Zusätzlich wollen wir Aktionen und Checks aufnehmen und damit einen einfachen Testfall aufbauen.","hash":"sec_wintestsuite","h1":"Erstellen einer eigenen Testsuite (Win)"},"524":{"id":524,"content":"Pro Tutorial","hash":"","h0":"Starten der Anwendung | QF‑Test Tutorial"},"525":{"id":525,"content":"Pro Tutorial","hash":"home-link","h0":"Starten der Anwendung | QF‑Test Tutorial"},"526":{"id":526,"content":"Starten der Anwendung Zu Beginn muss die zu testende Anwendung aus QF‑Test heraus gestartet werden. Es gibt einen Schnellstart-Assistenten, der uns hilft, eine passende Startsequenz zu erzeugen. Öffnen Sie bitte eine neue, leere Testsuite mittels »Datei«-»Neue Testsuite...«. Öffnen Sie den Schnellstart-Assistenten über das Menü »Extras«-»Schnellstart-Assistent...«. Im ersten Schritt werden Sie dazu aufgefordert, die Art der zu testenden Applikation auszuwählen. Wählen Sie bitte die vierte Option Eine native Windows-Anwendung. Drücken Sie Weiter.","hash":"tut_quickStartWin","h0":"Starten der Anwendung"},"527":{"id":527,"content":"Abbildung 20.1: Auswählen der SUT Art Nun werden Sie nach dem Windows Programm gefragt. Nutzen Sie hierzu den Programm auswählen Knopf auf der rechten Seite. Wechseln Sie in das Verzeichnis .../qftest-10.0.2-pro/demo/carconfigForms/ in Ihrer QF‑Test Installation. Wählen Sie dort die Datei CarConfigForms.exe. Das zweite Feld kann in unserem Fall leer bleiben. Jedoch soll erwähnt werden, dass es auch möglich ist QF‑Test mit einer bereits laufenden Windows-Anwendung zu verbinden. Dies geschieht durch Angabe des Fenstertitels im besagten zweiten Feld. Auch reguläre Ausdrücke für Fenstertitel sind hier möglich. Im Bild sieht man eine weitere Möglichkeit: Die Verwendung der Variablen ${qftest:dir.version} am Beginn, die automatisch zum versionsspezifischen Installationsverzeichnis von QF‑Test expandiert. Details zu speziellen QF‑Test Variablen finden Sie im Handbuch Kapitel Variablen. Drücken Sie den Fertig Knopf, da wir die weiteren optionalen Schritte für unser einfaches Demo nicht benötigen.","hash":"fig_WizardTypeWin","h4":"Abbildung 20.1: Auswählen der SUT Art"},"528":{"id":528,"content":"Abbildung 20.2: Auswahl der Programm Datei Wir gelangen direkt zur Zusammenfassung, die beschreibt, wie es nach dem Beenden des Schnellstart-Assistenten weiter geht. Drücken Sie den Fertig Knopf, um den Assistenten zu beenden.","hash":"fig_WizardExecFileWin","h4":"Abbildung 20.2: Auswahl der Programm Datei"},"529":{"id":529,"content":"Abbildung 20.3: Zusammenfassung Die generierte Startsequenz Starte CarConfigForms erscheint in den \"Extrasequenzen\" der Testsuite und enthält drei Schritte: Variable setzen - definiert die globale Client Variable, die durchweg in der Testsuite benutzt wird. Warten auf Client - prüft, ob der Client bereits läuft. SUT starten, wenn notwendig - falls der Client noch nicht läuft, wird er mit Hilfe eines Windows-Anwendung starten Knotens als zu testendes System (SUT) gestartet und gewartet bis dies erfolgt ist. Die Information, ob der Client bereits läuft wird im ersten Warten auf Client-Knoten einer Variable \"isSUTRunning\" gespeichert und in der folgenden \"If\"-Bedingung ausgewertet. Sie können dies in den entsprechenden Knotendetails sehen. Diese Art der bedingten Ausführung wird später noch im Detail erklärt.","hash":"fig_WizardFinalWin","h4":"Abbildung 20.3: Zusammenfassung"},"530":{"id":530,"content":"Abbildung 20.4: Generierte Startsequenz Probieren wir sie aus: Stellen Sie bitte sicher, dass der Knoten Vorbereitung: Starte CarConfigForms ausgewählt ist. Drücken Sie oder betätigen Sie einfach die Eingabe Taste. Im folgenden Bild ist das Fenster des SUT-Client dargestellt, das nun erscheinen sollte. Da nach dem Abspielen der Fokus zurück zu QF‑Test wandert, kann es sein dass das Fenster der Testsuite die Demoanwendung dann verdeckt.","hash":"fig_WizardResultWin","h4":"Abbildung 20.4: Generierte Startsequenz"},"531":{"id":531,"content":"Abbildung 20.5: Das Fenster des \"CarConfigurator\" Am Ende dieses Abschnitts wollen wir unsere Testsuite speichern. Drücken Sie den Knopf in der Werkzeugleiste oder nutzen Sie die »Datei«-»Speichern« Menüaktion bzw. das Tastenkürzel Strg⁠+⁠S. Im Datei-Explorer navigieren Sie in ein passendes Verzeichnis, in dem Sie Schreibrechte besitzen, z.B. Dokumente in Ihrem Benutzerverzeichnis. Geben Sie einen Namen ein z.B. MeineErstenTests.qft. Beenden Sie die Speicheraktion über den Speichern-Knopf.","hash":"fig_CarConfigWin1","h4":"Abbildung 20.5: Das Fenster des \"CarConfigurator\""},"532":{"id":532,"content":"Pro Tutorial","hash":"","h0":"Aufnehmen von Aktionen | QF‑Test Tutorial"},"533":{"id":533,"content":"Pro Tutorial","hash":"home-link","h0":"Aufnehmen von Aktionen | QF‑Test Tutorial"},"534":{"id":534,"content":"Aufnehmen von Aktionen Wir werden nun erste Aktionen in unserem Demo aufnehmen:","hash":"tut_recActionsWin","h0":"Aufnehmen von Aktionen"},"535":{"id":535,"content":"Abbildung 20.6: Aktionen im CarConfigurator Demo aufnehmen Drücken Sie dazu den Aufnahmeknopf Wechseln Sie zum SUT Anwendungsfenster. Von jetzt ab wird jede Maus- oder Tastaturaktion aufgenommen. Es gibt jedoch einen Indikator in Form eines roten Quadrats unter dem Mauszeiger. Erst wenn diese verschwindet, ist QF‑Test bereit für die Aufnahme der Aktion auf die Komponente. Wählen Sie mit der Maus das Modell I5 ganz unten in der Tabelle aus. Wechseln Sie zum Tab Sondermodelle. Wählen Sie dort das Sondermodell Jazz über das Dropdown-Menü. Zum Schluss klicken Sie wieder auf den ersten Tab Fahrzeuge. Beenden Sie die Aufnahme, indem Sie zurück zum QF‑Test Fenster wechseln und dort den Knopf für \"Aufnahme beenden\" drücken. Ein rotes Quadrat unter dem Mauszeiger zeigt durch sein Verschwinden an, dass nun Aktionen auf die Komponente aufgenommen werden können. Sie finden die aufgenommene Sequenz unter dem \"Extrasequenzen\" Knoten, wie im folgenden Bild dargestellt.","hash":"fig_CarConfigWinRec","h4":"Abbildung 20.6: Aktionen im CarConfigurator Demo aufnehmen"},"536":{"id":536,"content":"Abbildung 20.7: Der Baum nach Aufnahme der Sequenz Als Sequenzname wird standardmäßig Datum und Zeit der Erstellung verwendet. Dieser kann anschließend in den Details rechts beliebig angepasst werden. Ändern Sie den Sequenznamen bitte ab zu \"Modell I5 Jazz wählen\" Öffnen Sie die Sequenz um die enthaltenen Knoten zu sehen. Es sollten die erwarteten Mausklicks sein. Sie sollten sogar in der Lage sein, die angesprochenen Komponenten zuordnen zu können.","hash":"fig_FirstRecordedSequenceWin","h4":"Abbildung 20.7: Der Baum nach Aufnahme der Sequenz"},"537":{"id":537,"content":"Abbildung 20.8: Die umbenannte Sequenz Wir wollen nun die aufgenommene Sequenz abspielen. Markieren die Sequenz Modell I5 Jazz wählen. Drücken Sie Wiedergabe. Sie sollten die exakt gleichen Aktionen sehen, die Sie zuvor aufgenommen haben. Den aufgenommenen Ablauf sollten Sie auch wiederholt ohne Fehler abspielen können. Rechts unten im Fenster der Testsuite sollte \"Beendet: Keine Fehler\" zu sehen sein.","hash":"fig_FirstRecordedSequenceRenamedWin","h4":"Abbildung 20.8: Die umbenannte Sequenz"},"538":{"id":538,"content":"Pro Tutorial","hash":"","h0":"Aufnahme von Checks | QF‑Test Tutorial"},"539":{"id":539,"content":"Pro Tutorial","hash":"home-link","h0":"Aufnahme von Checks | QF‑Test Tutorial"},"540":{"id":540,"content":"Aufnahme von Checks Um das Verhalten des Clients zu überprüfen, verwenden wir Check-Knoten, mit denen man Zustand und Eigenschaften von Elementen abfragen kann. Auch Checks können aufgezeichnet werden. Zum Aufnehmen eines Checks drücken Sie den \"Check aufnehmen\" Knopf. Wechseln Sie zum Fenster des SUT. Es erscheint ein Rahmen um die Komponente, über der sich der Mauszeiger befindet. Bewegen Sie den Mauszeiger über das Wertfeld des Endpreises und warten Sie bis der Check-Rahmen erscheint. Klicken Sie nun mit der rechten Maustaste. Das erscheinende Kontextmenü erlaubt Ihnen die Auswahl eines Checks. Die Liste der verfügbaren Checks hängt vom Typ der Komponente ab. Wählen Sie den ersten Eintrag \"Text\", um den textuellen Wert des Feldes zu überprüfen. Beenden Sie die Aufnahme durch Drücken des Stoppknopfs . Warten Sie das Erscheinen des Check-Rahmens bevor Sie klicken, um den Check aufzunehmen. Anderen falls kann es vorkommen, dass der Check in ordentlich aufgezeichnet wird. Wieder taucht die neue Aufnahme unter den \"Extrasequenzen\" auf. Benennen Sie den Sequenzknoten um auf den Namen \"Endpreis prüfen\". Öffnen Sie anschließend den Sequenzknoten, um den Checkknoten zu sehen.","hash":"tut_recChecksWin","h0":"Aufnahme von Checks"},"541":{"id":541,"content":"Abbildung 20.9: Die aufgenommene Check-Sequenz In den Details des \"Check Text\" Knotens sieht man ebenfalls den erwarteten Wert des Endpreis Feldes. Auch diese Sequenz können Sie wieder selbst ausführen, um die Wiedergabe zu testen. Im nächsten Schritt wollen wir aus den beiden Sequenzen einen richtigen Testfall aufbauen.","hash":"fig_textchecktreeWin","h4":"Abbildung 20.9: Die aufgenommene Check-Sequenz"},"542":{"id":542,"content":"Pro Tutorial","hash":"","h0":"Erstellen einer Testsuite | QF‑Test Tutorial"},"543":{"id":543,"content":"Pro Tutorial","hash":"home-link","h0":"Erstellen einer Testsuite | QF‑Test Tutorial"},"544":{"id":544,"content":"Erstellen einer Testsuite Die Basisstruktur unterhalb des Wurzelknotens einer Testsuite ist durch folgende Knoten festgelegt: Eine beliebige Anzahl von \"Testfallsatz\" und \"Testfall\" Knoten, um funktionale Tests zu spezifizieren und zu strukturieren. \"Prozeduren\" - hier können wiederverwertbare Sequenzen in Prozeduren organisiert werden \"Extrasequenzen\" - unsere Spielwiese für Aufnahmen etc. \"Fenster und Komponenten\" - das eigentliche Herz der Testsuite. Hier sind alle aufgenommenen Fenster und Komponenten des SUT mit ihren Eigenschaften enthalten Funktionale Testfälle werden durch \"Testfall\" Knoten repräsentiert und mittels \"Testfallsatz\" Knoten gruppiert bzw. strukturiert. \"Vorbereitung\" und \"Aufräumen\" Knoten können Aktionen enthalten, um einen wohldefinierten Zustand vor und nach einem Testfall sicherzustellen. Wir beginnen mit dem Umbenennen des \"Testfallsatz\" Knotens von \"unbenannt\" in \"Demo Tests\". Falls ein Dialog bzgl. der Aktualisierung von Verweisen erscheint, können wir diesen einfach mit \"Ja\" beantworten. Der nächste Schritt ist, den vom Schnellstart-Assistenten erzeugten Knoten \"Vorbereitung\" in den \"Testfallsatz\" zu verschieben und zwar an die erste Position vor den enthaltenen Testfall. Das Verschieben kann mit Hilfe der Maus (Drag&Drop), des Kontextmenüs (rechte Maustaste Ausschneiden/Einfügen) oder der Tastenkombination Strg⁠+⁠X und Strg⁠+⁠V durchgeführt werden.","hash":"tut_buildtestwin","h0":"Erstellen einer Testsuite"},"545":{"id":545,"content":"Abbildung 20.10: Beginn der Strukturierung Als Nächstes gilt es, aus den beiden vorher aufgezeichneten Sequenzen einen Testfall zu machen. Benennen Sie dazu den Testfall Knoten von \"unbenannt\" in \"Erster\" um. Öffnen Sie den Testfall Knoten durch einen Klick auf das '>' Symbol. Verschieben Sie die beiden Sequenzen aus den \"Extrasequenzen\" in den Testfall. Wenn Sie den Testfall Knoten nicht öffnen, versucht QF‑Test die Sequenzknoten hinter dem Testfall Knoten auf der gleichen Ebene einzufügen. Dies ist jedoch für Sequenzknoten nicht zulässig. QF‑Test nimmt immer Sequenzen auf. Diese haben die gleiche Funktion wie Testschritte. Testschritte werden jedoch im Bericht aufgeführt. Man kann sie ineinander umwandeln, was wir Ihnen in den nächsten Schritten informationshalber zeigen wollen. Öffnen Sie das Kontextmenü für den ersten der beiden Sequenzknoten mit der rechten Maustaste. Wählen Sie »Knoten konvertieren in...«-»Testschritt« Führen Sie dasselbe für den zweiten Sequenzknoten durch.","hash":"fig_beginbuildatest_win","h4":"Abbildung 20.10: Beginn der Strukturierung"},"546":{"id":546,"content":"Abbildung 20.11: Der Baum nach der Neustrukturierung Damit haben wir die wichtigsten Schritte zur Strukturierung unserer Testsuite abgeschlossen.","hash":"fig_buildatest_win","h4":"Abbildung 20.11: Der Baum nach der Neustrukturierung"},"547":{"id":547,"content":"Pro Tutorial","hash":"","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"548":{"id":548,"content":"Pro Tutorial","hash":"home-link","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"549":{"id":549,"content":"Beenden der Anwendung Was uns als Basiselement noch fehlt, ist eine Aufräumsequenz, die das SUT sauber beendet. Es gibt verschiedene Wege eine Anwendung zu beenden, z.B. über den \"Fenster schließen\" Knopf rechts oben, durch Drücken von Alt-F4 oder das Menü »Datei«-»Beenden«. Alle diese Varianten lassen sich direkt aufzeichnen. Wir werden die letzte Möglichkeit nutzen, so dass Sie die folgenden Schritte durchführen können: Aufnahme starten . Menüaktion »Datei«-»Beenden« durchführen. Das Fenster der Demoanwendung verschwindet. Aufnahme beenden . Benennen Sie die aufgenommene Sequenz in \"Demo beenden\" um. Öffnen Sie das Kontextmenü für den Sequenzknoten und wählen Sie den Menüpunkt »Knoten konvertieren in...«-»Aufräumen« . Zuletzt verschieben Sie den Aufräumenknoten nach oben, so dass er der letzte Knoten im Testfallsatz ist. Der Aufräumknoten kann nur per Drag and Drop in den Testfallsatz verschoben werden, wenn dessen letzter Kindknoten eingeklappt ist. Um einen Knoten während einer Drag and Drop Operation ein- oder auszuklappen, verweilen Sie einen Moment mit dem Mauszeiger über dem Dreieck neben dem Knoten. Sie sollten folgendes Resultat erhalten:","hash":"tut_cleanupWin","h0":"Beenden der Anwendung"},"550":{"id":550,"content":"Abbildung 20.12: Die einfache Aufräumsequenz Damit haben wir die wichtigsten Schritte zur Strukturierung unserer Testsuite abgeschlossen.","hash":"fig_StopSequenceWin","h4":"Abbildung 20.12: Die einfache Aufräumsequenz"},"551":{"id":551,"content":"Pro Tutorial","hash":"","h0":"Gesamte Suite ausführen | QF‑Test Tutorial"},"552":{"id":552,"content":"Pro Tutorial","hash":"home-link","h0":"Gesamte Suite ausführen | QF‑Test Tutorial"},"553":{"id":553,"content":"Gesamte Suite ausführen Als Abschluss wollen wir unsere neue Suite ausführen: Beenden Sie dazu nun bitte den SUT Client, falls er läuft. Markieren Sie den \"Testsuite\" Wurzelknoten. Führen Sie diesen durch Drücken von \"Wiedergabe\" oder der Eingabe Taste aus. Das SUT sollte erscheinen, der Testfall aufgeführt und das SUT wieder beendet werden. Wie wir wissen, wird das Ergebnis des Testlaufs im Protokoll festgehalten: Um dieses anzuschauen, können wir den Button \"Protokoll anzeigen\" in der Werkzeugleiste oder alternative die Tastenkombination Strg⁠+⁠L nutzen.","hash":"tut_runOwnSuiteWin","h0":"Gesamte Suite ausführen"},"554":{"id":554,"content":"Abbildung 20.13: Der Protokollbaum der eigenen Testsuite Wir hatten bereits im ersten Kapitel gesehen, wie das Protokoll für die Fehleranalyse genutzt werden kann. Wir möchten damit dieses Kapitel beenden und einen Schritt weiter in Richtung Fehlerdiagnose gehen. Hierbei stellt der Debugger ein wichtiges Werkzeug innerhalb QF‑Test dar. Seine Handhabung und Möglichkeiten werden im nächsten Kapitel beschrieben.","hash":"fig_firstrunlogWin","h4":"Abbildung 20.13: Der Protokollbaum der eigenen Testsuite"},"555":{"id":555,"content":"Pro Tutorial","hash":"","h0":"Eine Prozedur erstellen (Win) | QF‑Test Tutorial"},"556":{"id":556,"content":"Pro Tutorial","hash":"home-link","h0":"Eine Prozedur erstellen (Win) | QF‑Test Tutorial"},"557":{"id":557,"content":"Eine Prozedur erstellen (Win) Dieses Kapitel ist auch als Video verfügbar unter 'Eine Prozedur erstellen'. In den beiden vorherigen Kapiteln haben Sie gelernt wie man eine Applikation über QF‑Test startet, so dass Maus- und Tastatureingaben aufgenommen werden können, auch wie man Checks aufnimmt und wie man das Ergebnis zu einem Testfall zusammenfasst. Diese Herangehensweise ist ausreichend, solange die Tests einfach und nicht allzu viele sind. Sobald jedoch die Zahl der Tests zunimmt, ist es wichtig, sogenannte \"Prozeduren\" einzusetzen. Prozeduren sind ein Mittel um Sequenzen wiederverwendbar zu machen und damit Doppelvorkommen zu vermeiden. Dies ist wichtig, um eine einfache und effiziente Wartbarkeit von Tests über die Zeit zu erreichen. Prozeduren können in Packages gruppiert werden. Prozeduren und Packages sind die Basis für die Modularisierung der Tests.","hash":"sec_FirstProzedurWin","h1":"Eine Prozedur erstellen (Win)"},"558":{"id":558,"content":"Pro Tutorial","hash":"","h0":"Wiederverwendbare Abschnitte identifizieren | QF‑Test Tutorial"},"559":{"id":559,"content":"Pro Tutorial","hash":"home-link","h0":"Wiederverwendbare Abschnitte identifizieren | QF‑Test Tutorial"},"560":{"id":560,"content":"Wiederverwendbare Abschnitte identifizieren In diesem Abschnitt werden wir die Testsuite ErsteWinTests.qft, die Sie bereits aus Kapitel 19 kennen, weiterentwickeln. Kopieren Sie ErsteWinTests.qft aus dem Unterverzeichnis qftest-10.0.2-pro/doc/tutorial der QF‑Test Installation in ein Arbeitsverzeichnis und öffnen Sie ErsteWinTests.qft. Wenn Sie die Änderung, die wir an der Demo-Testsuite vornehmen werden, sichern wollen, so speichern Sie diese in einem Arbeitsverzeichnis wie am Ende von \"Starten der Anwendung\" beschrieben. Bitte sehen Sie sich den Testschritt \"Zurücksetzen\" in den beiden Testfällen an. Die beiden Testschritte sind identisch.","hash":"tut_procreusewin","h0":"Wiederverwendbare Abschnitte identifizieren"},"561":{"id":561,"content":"Abbildung 21.1: Zwei identische Testschritte Gemäß obiger Überlegungen wäre es also sinnvoll, den Testschritt in eine Prozedur umzuwandeln.","hash":"IdenticalTeststepsWin","h4":"Abbildung 21.1: Zwei identische Testschritte"},"562":{"id":562,"content":"Pro Tutorial","hash":"","h0":"Manuelle Erstellung von Prozeduren | QF‑Test Tutorial"},"563":{"id":563,"content":"Pro Tutorial","hash":"home-link","h0":"Manuelle Erstellung von Prozeduren | QF‑Test Tutorial"},"564":{"id":564,"content":"Manuelle Erstellung von Prozeduren Es gibt mehrere Methoden Prozeduren zu erstellen und Prozeduraufrufe einzufügen. Wir fangen mit der manuellen an, bei der ein (leerer) Prozedurknoten eingefügt wird, in den dann die entsprechenden Aktionen verschoben werden. Danach erstellen wir den zugehörigen Prozeduraufruf. Es ist gut, wenn man diese grundlegenden Schritte kennt. Es gibt jedoch eine zweite, elegantere Methode Prozeduren zu erstellen, die wir im Anschluss zeigen werden. Also los, fügen wir eine Prozedur von Hand ein: Wir beginnen mit dem Anlegen des Prozedurknotens, dem wir einen geeigneten Namen geben. Öffnen Sie den Prozeduren Knoten und achten Sie darauf, dass er auch selektiert (blau markiert) ist. Wählen Sie »Einfügen«-»Prozedurknoten«-»Prozedur«. Tragen Sie als Name \"zurücksetzen\" ein. Die anderen Felder brauchen nicht befüllt zu werden. Öffnen Sie die neu erstellte \"zurücksetzen\" Prozedur.","hash":"tut_procmanualwin","h0":"Manuelle Erstellung von Prozeduren"},"565":{"id":565,"content":"Abbildung 21.2: Prozedurknoten erstellen Im zweiten Schritt befüllen wir die Prozedur mit den entsprechenden wiederverwendbaren Aktionen. Selektieren Sie die drei \"Mausklick\" Knoten im Testschritt. Um mehr als einen Knoten zu selektieren, klicken Sie den ersten der Knoten an, dann drücken Sie die Shift Taste und klicken den letzten der zu selektierenden Knoten während Sie die Shift Taste gedrückt halten. Verschieben Sie diese nach unten in die Prozedur, z.B. mit der Maus (Drag and drop) oder über Ausschneiden/Einfügen im Menü »Bearbeiten« oder über das Kontextmenü.","hash":"ProcedureNodeInFirstTestcaseWin","h4":"Abbildung 21.2: Prozedurknoten erstellen"},"566":{"id":566,"content":"Abbildung 21.3: Prozedur mit Inhalt befüllen Im dritten Schritt fügen wir einen Prozeduraufruf an Stelle der drei verschobenen Mausklicks ein. Selektieren Sie den Testschritt \"Zurücksetzen\", der geöffnet sein sollte. Wählen Sie den Menüpunkt »Einfügen«-»Prozedurknoten«-»Prozeduraufruf« oder verwenden Sie das Tastaturkürzel Strg⁠+⁠A.","hash":"procedureContentInFirstTestcaseWin","h4":"Abbildung 21.3: Prozedur mit Inhalt befüllen"},"567":{"id":567,"content":"Abbildung 21.4: Prozeduraufruf einfügen Drücken Sie den Prozedur-Auswahlknopf links neben der Beschriftung \"Name der Prozedur\". Wählen Sie \"zurücksetzen\" aus der Prozedurliste. Weitere Eingaben sind nicht nötig. Drücken Sie OK um die Erstellung des Prozeduraufrufs abzuschließen.","hash":"AddProcedureCallWin","h4":"Abbildung 21.4: Prozeduraufruf einfügen"},"568":{"id":568,"content":"Abbildung 21.5: Prozedur auswählen Um wirklich einen Mehrwert durch die Prozedur zu erlangen, müssen wir nun den Inhalt des Testschritts im zweiten Testfall ebenfalls durch einen Aufruf der Prozedur \"zurücksetzen\" ersetzen. Sie können dies wie oben beschrieben tun oder Sie führen folgende alternative Schritte zur Erstellung des Prozeduraufrufs aus: Öffnen Sie den Testschritt 'Zurücksetzen' des zweiten Testfalls. Löschen Sie die drei Mausklick Knoten daraus. Selektieren Sie den Prozedurknoten \"zurücksetzen\". Ziehen Sie den Prozedurknoten \"zurücksetzen\" mit der Maus in den Testschrittknoten. Kopieren/einfügen kann ebenfalls verwendet werden. Dadurch wird der Prozedurknoten nicht verschoben, sondern ein entsprechender Prozeduraufruf erzeugt. Die Testsuite sollte anschließend wie folgt aussehen:","hash":"SelectProcedureWin","h4":"Abbildung 21.5: Prozedur auswählen"},"569":{"id":569,"content":"Abbildung 21.6: Testsuite mit Prozedur Wenn Sie nun die Testfälle ausführen, sollten diese funktionieren wie zuvor. Im Protokoll sind jetzt auch die Prozeduraufrufe und deren Ausführung zu sehen.","hash":"fig_testsuite_with_Procedure_win","h4":"Abbildung 21.6: Testsuite mit Prozedur"},"570":{"id":570,"content":"Pro Tutorial","hash":"","h0":"Knoten in Prozedur konvertieren | QF‑Test Tutorial"},"571":{"id":571,"content":"Pro Tutorial","hash":"home-link","h0":"Knoten in Prozedur konvertieren | QF‑Test Tutorial"},"572":{"id":572,"content":"Knoten in Prozedur konvertieren Wie bereits am Anfang des letzten Abschnitts erwähnt, bietet QF‑Test eine Alternative um Prozeduren wesentlich schneller zu erstellen. Markieren Sie den Testschritt oder Sequenz-Knoten, der die wiederverwendbaren Schritte enthält, die zur Prozedur umgewandelt werden sollen. Wählen Sie den Menüpunkt »Operationen«-»Knoten konvertieren in«-»Prozedur« aus oder verwenden Sie das Tastaturkürzel Strg⁠+⁠Umschalt⁠+⁠P. Wie Sie sehen, ist der Testschritt bzw. der Sequenzknoten verschwunden. Anstelle dessen befindet sich ein Prozeduraufruf. Außerdem wurde eine Prozedur mit dem Namen des ehemaligen Testschritts bzw. der Sequenz im Abschnitt \"Prozeduren\" erstellt. Sie enthält genau die gleichen Kindknoten wie zuvor der Testschritt bzw. die Sequenz. Bei der Aufnahme einer Sequenz in QF‑Test hat sich das Vorgehen bewährt, der Sequenz sofort einen Namen zu geben und sie anschließend in eine Prozedur zu konvertieren. Auch wenn man nur eine Vermutung hat, dass sich die aufgenommenen Schritte irgendwo wiederholen könnten.","hash":"tut_proctransformwin","h0":"Knoten in Prozedur konvertieren"},"573":{"id":573,"content":"Pro Tutorial","hash":"","h0":"Komponenten (Win) | QF‑Test Tutorial"},"574":{"id":574,"content":"Pro Tutorial","hash":"home-link","h0":"Komponenten (Win) | QF‑Test Tutorial"},"575":{"id":575,"content":"Komponenten (Win) Dieses Kapitel ist auch als Video verfügbar unter 'Komponenten'. Werfen wir nun einen Blick auf den letzten verbleibenden Bereich des Testsuite Fensters, den Fenster und Komponenten Knoten. Zuvor möchten wir Ihnen jedoch zeigen, wie Unterelemente von Komponenten wie Tabellen, Bäumen und Listen adressiert werden.","hash":"sec_ComplexComponentsWin","h1":"Komponenten (Win)"},"576":{"id":576,"content":"Pro Tutorial","hash":"","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen | QF‑Test Tutorial"},"577":{"id":577,"content":"Pro Tutorial","hash":"home-link","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen | QF‑Test Tutorial"},"578":{"id":578,"content":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen Unterelemente von Tabellen, Bäumen und Listen werden über Indizes angesprochen. Die wichtigsten beiden Indextypen sind der numerische und der Textindex. Zur Demonstration nehmen wir als nächstes einen Mausklick auf eine Tabellenzelle auf und sehen uns die aufgenommene QF‑Test ID der Komponente näher an. Starten Sie das CarConfig Demo, falls dieses nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf eine Tabellenzelle, z.B. das erste Modell. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Den aufgenommenen Mausklick finden Sie im Bereich Extrasequenzen.","hash":"sec_addressing_complex_components_win","h0":"Adressierung von Unterelementen von Tabellen, Bäumen und Listen"},"579":{"id":579,"content":"Abbildung 22.1: Adressierung einer Tabellenzelle Die aufgenommene QF‑Test ID der Komponente ist VehicleTable@Modell&0. Sie setzt sich aus den folgenden Teilen zusammen: VehicleTable ist die QF‑Test ID der Komponente der Tabelle selbst. @ und & trennen die einzelnen Teile voneinander. Gleichzeitig definieren sie den Typ des darauf folgenden Index: auf @ folgt ein Textindex, auf & ein numerischer Index. Modell ist der Textindex für die Spalte mit der Überschrift 'Modell'. 0 ist der numerische Index für die erste Tabellenzeile. Numerische Indizes beginnen immer mit 0. Sie können beide Indextypen für Zeilen und Spalten verwenden. Dabei ist nur wichtig, dass das Trennzeichen und der Typ des zugehörigen Index zusammenpassen. Ändern Sie die QF‑Test ID der Komponente so, dass das dritte Preisfeld adressiert wird. Verwenden Sie dafür numerische Indizes. Die Lösung hierfür lautet VehicleTable&1&2. Um das Modell 'I5' über Textindizes anzusprechen, tragen Sie VehicleTable@Modell@I5 ein. Das gleiche Feld kann man numerisch mittels VehicleTable&0&4 ansprechen oder mit gemischten Indizes mittels VehicleTable&0@I5 oder VehicleTable@Modell&4. Der dritte Indextyp von QF‑Test ist ein Index mit regulärem Ausdruck. Reguläre Ausdrücke werden verwendet, um Zeichenketten durch einen Ausdruck zu ersetzen, der verschiedene Zeichenketten adressieren kann. Sozusagen eine \"Sternchensuche\", wobei reguläre Ausdrücke wesentlich mächtiger sind und eine eigene Syntax besitzen. Eine genauere Beschreibung regulärer Ausdrücke finden Sie im Handbuch. Beispiel: Das Modell 'I5' könnte man also auch über VehicleTable@Modell%I.* ansprechen. Listen werden analog zu Tabellen adressiert, nur dass sie nur einen einzigen Index benötigen. Bäume haben ebenfalls nur einen einzigen Index. Dieser ist der Pfad durch den Baum zu dem adressierten Baumknoten. Der Pfad setzt sich aus den einzelnen Knoten zusammen, die durch Schrägstriche (\"/\") voneinander getrennt werden. Starten Sie das CarConfig Demo, falls dieses nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Öffnen Sie das Baum-Beispiel: Wählen Sie im CarConfig Demo den Menüpunkt »Einstellungen«-»Sondermodelle...«, selektieren Sie ein Modell und drücken die Schaltfläche 'Details'. Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf einen Baumknoten, z.B. 'Beschreibung'. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Für den Baumknoten \"Beschreibung\" wird die folgende QF‑Test ID der Komponente aufgenommen: DetailsTree@/Information/Beschreibung. Die einzelnen Bestandteile davon sind: DetailsTree ist die QF‑Test ID der Komponente des Baums selbst. @ trennt die QF‑Test ID der Komponente des Baums vom Index. Die Syntax ist hierbei analog zu der der Tabellenindizes, d.h. @ steht für einen Textindex, & für einen numerischen Index und % für einen Index mit regulärem Ausdruck. /Information/Beschreibung ist der Textindex für den Baumpfad zum Knoten 'Beschreibung'. Wenn Sie den Knoten über einen numerischen Index adressieren wollen, verwenden Sie DetailsTree&/0/1.","hash":"fig_components_tableindex_win","h4":"Abbildung 22.1: Adressierung einer Tabellenzelle"},"580":{"id":580,"content":"Pro Tutorial","hash":"","h0":"Benutzen des Debuggers (Win) | QF‑Test Tutorial"},"581":{"id":581,"content":"Pro Tutorial","hash":"home-link","h0":"Benutzen des Debuggers (Win) | QF‑Test Tutorial"},"582":{"id":582,"content":"Benutzen des Debuggers (Win) Dieses Kapitel ist auch als Video verfügbar unter 'Benutzen des Debuggers'. In diesem Kapitel lernen Sie, wie der in QF‑Test integrierte intuitive Debugger benutzt wird. Diejenigen unter Ihnen, die bereits Erfahrungen mit anderen IDEs, wie z.B. Eclipse haben, werden hier Ähnlichkeiten in Funktion und Nutzen des Debuggers feststellen. Wir werden uns mit den folgenden Debugger-Funktionen beschäftigen: Setzen eines Breakpoints mittels Strg⁠+⁠F8. Testausführung pausieren mittels Pausetaste oder der Tastenkombination für das Unterbrechen der Wiedergabe (\"Keine Panik\"-Taste) Alt⁠+⁠F12. Schrittweise Ausführung mittels \"Einzelschritt ausführen\" , \"Gesamten Knoten ausführen\" und \"Bis Knotenende ausführen\" . Knoten überspringen mittels \"Knoten überspringen\" und \"Aus Knoten herausspringen\" . Debug-Modus bei Fehler oder Exception aktivieren. Fehlerbehebung aus dem Protokoll heraus. Den aktuellen Fehler im Protokoll direkt anspringen über Strg⁠+⁠J. (Ins Protokoll springen in Kapitel \"Fehlerbehebung aus dem Protokoll heraus\"). Anstatt über die Schaltflächen können die Befehle auch über die Menüzeile oder Tastaturkürzel abgesetzt werden. Die Kürzel stehen neben den Optionen in den QF‑Test Menüs, sofern vorhanden. Eine vollständige Übersicht der von QF‑Test verwendeten Tastaturkürzel finden Sie im Anhang Tastaturkürzel im Handbuch. Dort findet sich auch ein kleiner Helfer für die Funktionstastenbelegung von QF‑Test zum Befestigen an der Tastatur. Es gibt noch einige weitere Debugger-Funktionen wie \"Aktuellen Knoten finden\" (Aktuellen Knoten finden in \"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle\"), \"Ausführung hier fortsetzen\" über das Popup-Menü des entsprechenden Knotens (\"Ausführung hier fortsetzen\"), die \"Exception erneut werfen\" , die Tabelle der Variablendefinitionen (\"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle\"), auf die wir in späteren Kapiteln eingehen werden.","hash":"sec_DebuggerWin","h1":"Benutzen des Debuggers (Win)"},"583":{"id":583,"content":"Pro Tutorial","hash":"","h0":"Setzen eines Breakpoints | QF‑Test Tutorial"},"584":{"id":584,"content":"Pro Tutorial","hash":"home-link","h0":"Setzen eines Breakpoints | QF‑Test Tutorial"},"585":{"id":585,"content":"Setzen eines Breakpoints Zunächst einmal soll der Debugger aktiviert werden. Dies kann auf mehrere Arten erfolgen, zum Beispiel durch das Setzen eines Haltepunktes (Breakpoint) vor Start des Testlaufs. Der Zweck eines Haltepunktes ist es, den Testlauf an einer Stelle, die man näher untersuchen möchte, zu unterbrechen. Sobald QF‑Test auf den Breakpoint trifft, wird die Testausführung pausiert und der Debugger-Modus aktiviert. Der Pauseknopf ist nun gedrückt. Selektieren Sie einen Knoten und drücken Sie Strg⁠+⁠F8. Der Haltepunkt wird durch das Symbol kenntlich gemacht.","hash":"tut_breakpointswin","h0":"Setzen eines Breakpoints"},"586":{"id":586,"content":"Abbildung 23.1: Breakpoint setzen Selektieren Sie den Testsuite Knoten und starten Sie den Testlauf über die Taste Enter.","hash":"fig_DebugSetBreakpointWin","h4":"Abbildung 23.1: Breakpoint setzen"},"587":{"id":587,"content":"Abbildung 23.2: Testlauf starten Löschen Sie den Breakpoint wieder, indem Sie nochmals Strg⁠+⁠F8 drücken.","hash":"fig_DebugStartTestRunWin","h4":"Abbildung 23.2: Testlauf starten"},"588":{"id":588,"content":"Abbildung 23.3: Breakpoint löschen Man kann einen Breakpoint nicht nur über das Tastaturkürzel Strg⁠+⁠F8 sondern auch über den Menüpunkt »Debugger«-»Breakpoint an/aus« oder alternativ durch Rechtsklick auf den Knoten und Auswahl von »Breakpoint an/aus« im Popup-Menü setzen bzw. löschen. Für die weiteren Debugger-Funktionen werden wir hauptsächlich die jeweiligen Schaltflächen nennen, aber auch hier stehen die anderen Varianten zur Verfügung. Wieder sehen Sie den kleinen Pfeil, der diesmal anzeigt, welcher Knoten als nächster ausgeführt wird. Dieser Knoten wird aktueller Knoten genannt. Bei der Aktivierung des Debug-Modus navigiert QF‑Test zum aktuellen Knoten, falls dieser nicht bereits sichtbar ist, und selektiert diesen, d.h. die Zeile wird blau hinterlegt. Das Kommando »Debugger«-»Alle Breakpoints löschen« ist ebenfalls nützlich, wenn alle Haltepunkte in allen geöffneten Testsuiten gelöscht werden sollen. Es gibt keine Beschränkung für die Anzahl an Breakpoints, die Sie in Ihrer Testsuite setzen können. Haltepunkte werden beim Schließen der Testsuite nicht mit abgespeichert.","hash":"fig_DebugRemoveBreakpointWin","h4":"Abbildung 23.3: Breakpoint löschen"},"589":{"id":589,"content":"Pro Tutorial","hash":"","h0":"Schrittweise Ausführung | QF‑Test Tutorial"},"590":{"id":590,"content":"Pro Tutorial","hash":"home-link","h0":"Schrittweise Ausführung | QF‑Test Tutorial"},"591":{"id":591,"content":"Schrittweise Ausführung Nun wollen wir die Testfälle schrittweise ausführen. Bitte experimentieren Sie ein wenig mit \"Einzelschritt ausführen\" , \"Gesamten Knoten ausführen\" und \"Bis Knotenende ausführen\" . Wie Sie sicher festgestellt haben werden, öffnet \"Einzelschritt ausführen\" einen Knoten mit Kindern und macht den ersten Kindknoten zum aktiven Knoten. Dies ist wie immer an der Pfeilmarkierung des Knotens erkennbar. Wenn Sie an dem Punkt weitergemacht haben, an dem die Ausführung der Testsuite im letzten Abschnitt pausiert war, d.h. vom Knoten \"Testfall: Erster\" aus, so würde nun der Testfall geöffnet werden:","hash":"tut_debug_steps_win","h0":"Schrittweise Ausführung"},"592":{"id":592,"content":"Abbildung 23.4: Einzelschritt ausführen Im Falle eines Blattknotens, d.h. eines Knotens, der keine Kinder hat, ist die Wirkung die gleiche wie die der folgenden Funktion. Mittels der Schaltfläche \"Gesamten Knoten ausführen\" wird ein Knoten inklusive aller Kindknoten ausgeführt. Der als nächstes auszuführende Knoten auf der gleichen Ebene wird dann der aktive und erhält den Pfeil.","hash":"fig_StepInExampleWin","h4":"Abbildung 23.4: Einzelschritt ausführen"},"593":{"id":593,"content":"Abbildung 23.5: Gesamten Knoten ausführen \"Bis Knotenende ausführen\" führt die verbleibenden Geschwisterknoten aus und stoppt beim nächsten auszuführenden Knoten der übergeordneten Hierarchieebene.","hash":"fig_StepOverExampleWin","h4":"Abbildung 23.5: Gesamten Knoten ausführen"},"594":{"id":594,"content":"Abbildung 23.6: Bis Knotenende ausführen Im Beispiel ist dies der Aufräumen Knoten. Wie bereits im ersten Kapitel Ein vollständiger Testlauf erläutert, haben Vorbereitung und Aufräumen Knoten die besondere Eigenschaft, dass sie vor und nach jedem Testfall ausgeführt werden, um so einen definierten Anfangszustand für jeden Testfall herzustellen. Dieses Verhalten tritt nur auf, wenn Sie die komplette Testsuite oder den Testfallsatz gestartet hatten und sich im Debug-Modus befinden. Wenn keine Testausführung aktiv war und Sie nur den Testfall selektiert hatten, so bewirkt die Funktion \"Gesamten Knoten ausführen\", dass der Testfall ausgeführt wird und dann der nächste Testfall selektiert wird. Führen Sie die Aufräumen und Vorbereitung Knoten aus, indem Sie mit Hilfe der Schaltfläche die gesamten Knoten ausführen und dann über den zweiten Testfall öffnen. Dies ist eine Vorbereitung für das nächste Kapitel, in dem es um das Überspringen von Knoten geht. Bitte beachten Sie bei der interaktiven Testerstellung bei Menüs und Comboboxen, dass diese häufig zuklappen, wenn die Applikation den Fokus verliert, was beim Wechsel in den Debug-Modus der Fall ist. In diesem Fall empfiehlt es sich, den Knoten, der ein Menü oder eine Combobox öffnet, und den Knoten, der die Auswahlaktion durchführt, gemeinsam auszuführen, also nicht zwischendurch in den Debug-Modus zu gehen. Dies kann man zum Beispiel dadurch erreichen, dass man nach dem Knoten, der die Auswahlaktion durchführt, einen Haltepunkt setzt und bei Erreichen des Knotens, der das Menü oder die Combobox öffnet, die Testausführung durch Lösen der Pausetaste freigibt.","hash":"fig_StepOutExampleWin","h4":"Abbildung 23.6: Bis Knotenende ausführen"},"595":{"id":595,"content":"Pro Tutorial","hash":"","h0":"Knoten überspringen | QF‑Test Tutorial"},"596":{"id":596,"content":"Pro Tutorial","hash":"home-link","h0":"Knoten überspringen | QF‑Test Tutorial"},"597":{"id":597,"content":"Knoten überspringen Die \"Überspringen\" Funktionen erweitern die Fähigkeiten des Debuggers von QF‑Test in einer Weise, die über den Funktionsumfang von Standardprogrammierumgebungen hinausgeht. Wie der Name andeutet, erlauben die \"Überspringen\" Operationen einen oder mehrere Knoten während des Testlaufs auszulassen, d.h. weiter zu springen ohne diese auszuführen. Dies kann aus verschiedensten Gründen sinnvoll sein. Sei es um schnell an eine gewisse Position in Ihrem Testablauf zu gelangen oder um einen aktuell zu einem Fehler führenden Knoten zu überspringen. Am Schluss des letzten Abschnitts haben wir den ersten Testschritt im zweiten Testfall zum aktiven Knoten gemacht. Dies ist er Ausgangspunkt für unsere nächste Aktion:","hash":"tut_skip_steps_win","h0":"Knoten überspringen"},"598":{"id":598,"content":"Abbildung 23.7: Testausführung am ersten Knoten des zweiten Testfalls pausiert Drücken Sie nun die Schaltfläche \"Knoten überspringen\" . QF‑Test springt einfach über den aktiven Knoten ohne ihn oder seine Kindknoten auszuführen. Anschließend pausiert QF‑Test beim nächsten auszuführenden Knoten auf der gleichen Ebene.","hash":"fig_DebugSkipOverInitialStateWin","h4":"Abbildung 23.7: Testausführung am ersten Knoten des zweiten Testfalls pausiert"},"599":{"id":599,"content":"Abbildung 23.8: \"Knoten überspringen\" Und zuletzt die Schaltfläche \"Aus Knoten herausspringen\" . Sie sehen sofort, dass QF‑Test aus dem Knoten, in dem Sie sich befinden, herausspringt ohne weitere Kindknoten auszuführen.","hash":"fig_DebugSkipOverWin","h4":"Abbildung 23.8: \"Knoten überspringen\""},"600":{"id":600,"content":"Abbildung 23.9: \"Aus Knoten herausspringen\" Noch eine Bemerkung zu \"Knoten überspringen\" und \"Aus Knoten herausspringen\": Benutzen Sie diese mit Vorsicht! Aus einer Sequenz herauszuspringen, bevor diese zu Ende gelaufen ist, kann dazu führen, dass Ihr SUT in einem Status belassen wird, mit dem andere Sequenzen oder Tests in der Suite nicht aufsetzen können.","hash":"fig_DebugSkipOutWin","h4":"Abbildung 23.9: \"Aus Knoten herausspringen\""},"601":{"id":601,"content":"Pro Tutorial","hash":"","h0":"Debug-Modus bei Fehler oder Exception aktivieren | QF‑Test Tutorial"},"602":{"id":602,"content":"Pro Tutorial","hash":"home-link","h0":"Debug-Modus bei Fehler oder Exception aktivieren | QF‑Test Tutorial"},"603":{"id":603,"content":"Debug-Modus bei Fehler oder Exception aktivieren Beim Debuggen eines Tests ist es oft hilfreich, wenn die Testausführung genau dann stoppt und in den Debug-Modus gewechselt wird, wenn ein Fehler, eine Exception oder manchmal auch nur eine Warnung auftritt. Mittels dieser Technik werden wir in diesem Abschnitt und dem nächsten den zweiten Testfall debuggen. Bitte öffnen Sie das Debugger-Menü und ändern Sie die Standardeinstellungen wie folgt: Klicken Sie auf den Menüpunkt »Debugger«-»Debugger aktivieren« um ihn zu aktivieren. Klicken Sie auf den Untermenüpunkt »Debugger«-»Optionen«-»Unterbrechen bei Fehler« um auch diese Funktion zu aktivieren. Wenn Sie nun das Debugger-Menü und das Optionen-Untermenü wieder öffnen sollte es wie folgt aussehen:","hash":"tut_debug_start_win","h0":"Debug-Modus bei Fehler oder Exception aktivieren"},"604":{"id":604,"content":"Abbildung 23.10: Debugger-Optionen: Test bei Fehler anhalten Wir müssen die Debugger-Optionen ändern, da sonst der Test einfach durchlaufen würde, analog zu den vorherigen Beispielen aus Kapitel eins und zwei. Selektieren Sie den Testsuite Knoten und starten Sie anschließend den Test mittels \"Wiedergabe starten\" . QF‑Test hält bei dem fehlerhaften Knoten an und wechselt in den Debug-Modus:","hash":"fig_debugger_stops_at_error_win","h4":"Abbildung 23.10: Debugger-Optionen: Test bei Fehler anhalten"},"605":{"id":605,"content":"Abbildung 23.11: QF‑Test pausiert bei Fehler Der Knoten, der den Fehler verursacht hat, wird durch ein rotes Quadrat markiert. Außerdem erscheint ein Fehlerdialog, der uns Näheres zur Fehlerursache mitteilt. Über diesen wechseln wir in das Protokoll, das wie so oft der Schlüssel zur Fehlerbehebung ist.","hash":"fig_debugger_stopped_by_error_win","h4":"Abbildung 23.11: QF‑Test pausiert bei Fehler"},"606":{"id":606,"content":"Abbildung 23.12: Fehlermeldung Klicken Sie auf die Schaltfläche In Protokoll springen der Fehlermeldung.","hash":"debug_error_dialog_win","h4":"Abbildung 23.12: Fehlermeldung"},"607":{"id":607,"content":"Pro Tutorial","hash":"","h0":"Fehlerbehebung aus dem Protokoll heraus | QF‑Test Tutorial"},"608":{"id":608,"content":"Pro Tutorial","hash":"home-link","h0":"Fehlerbehebung aus dem Protokoll heraus | QF‑Test Tutorial"},"609":{"id":609,"content":"Fehlerbehebung aus dem Protokoll heraus Über die Schaltfläche In Protokoll springen (siehe Fehlermeldung in Abbildung \"Fehlermeldung\") wird das Protokoll direkt bei dem entsprechenden Knoten geöffnet. Neben der eigentlichen Fehlermeldung wurden etliche weitere Informationen zur Testumgebung zum Zeitpunkt des Fehlers protokolliert. Neben Bildschirmabbildern zum Fehlerzeitpunkt enthält das Protokoll unter dem Knoten, der den Fehler verursachte, eine Liste der gebundenen Variablen (Stacktrace). Auf die Nützlichkeit des Stacktrace werden wir zu einem späteren Zeitpunkt eingehen (Die Variablendefinitionen-Tabelle). Beim vorliegenden Fehler wird der falsche Wert im Check Text Knoten der Testsuite erwartet. Zur Fehlerbehebung muss dieser durch den tatsächlich angezeigten ersetzt werden. Dies geht bei einem Check mit festem Wert, um den es sich hier handelt, am einfachsten, indem Sie auf den rot umrandeten Fehler-Knoten \"Fehlgeschlagen: Check Text: default ...\" rechtsklicken und im Kontextmenü »Check-Knoten mit erhaltenen Daten aktualisieren« auswählen.","hash":"tut_ResolveRunTimeErrorsWin","h0":"Fehlerbehebung aus dem Protokoll heraus"},"610":{"id":610,"content":"Abbildung 23.13: Check-Knoten mit erhaltenen Daten aktualisieren QF‑Test navigiert zum betroffenen Check Text Knoten in der Testsuite und aktualisiert den Wert des Attributs Text anhand der aus dem SUT ausgelesenen Daten.","hash":"fig_DebugUpdateCheckNodeWin","h4":"Abbildung 23.13: Check-Knoten mit erhaltenen Daten aktualisieren"},"611":{"id":611,"content":"Abbildung 23.14: Korrigierter Check-Knoten Der Knoten enthält nun zwar den korrekten Wert, ist aber immer noch rot umrandet, da er noch nicht wieder ausgeführt wurde. Dies wollen wir nun tun. führen Sie den Test also fort, indem Sie auf den Pauseknopf drücken und so die Pause lösen. QF‑Test führt den Rest der Testsuite aus. In unserem Fall sind das der Check Text und der Aufräumen Knoten. Anschließend informiert Sie QF‑Test, dass ein Fehler aufgetreten ist. Diesen haben wir allerdings bereits während des Testlaufs behoben.","hash":"fig_DebugCorrectedCheckNodeWin","h4":"Abbildung 23.14: Korrigierter Check-Knoten"},"612":{"id":612,"content":"Ins Protokoll springen: Falls Sie das Protokoll an der Stelle, an der sich die Testausführung gerade befindet, öffnen wollen, brauchen Sie aus dem Debugging Modus heraus nur den Menüpunkt »Debugger«-»Jump to Run log« anzuklicken oder das Tastaturkürzel Strg⁠+⁠J zu drücken. Wenn Sie einfach nur das Protokoll öffnen wollen, ohne an die aktuelle Stelle zu springen, steht Ihnen Strg⁠+⁠L zur Verfügung, was auch nach Ende des Testlaufs weiterhin funktioniert.","hash":"tut_JumpToRunLogWin tut_JumpToRunLogWin","h4":"Abbildung 23.14: Korrigierter Check-Knoten"},"613":{"id":613,"content":"Pro Tutorial","hash":"","h0":"Testausführung pausieren | QF‑Test Tutorial"},"614":{"id":614,"content":"Pro Tutorial","hash":"home-link","h0":"Testausführung pausieren | QF‑Test Tutorial"},"615":{"id":615,"content":"Testausführung pausieren Wenn ein Test gerade ausgeführt wird und Sie den Debug-Modus aktivieren wollen, so können Sie entweder schnell einen Breakpoint auf einen noch nicht ausgeführten Knoten setzen oder Sie drücken einfach die Schaltfläche \"Pause\" um den Debug-Modus sofort zu aktivieren. Um die Ausführung fortzusetzen lösen Sie den Pauseknopf , völlig unabhängig von der Art und Weise wie der Debug-Modus aktiviert wurde. Wir wollen die vorhandenen Testfälle im Verlauf dieses Tutorials weiter verwenden. Allerdings wurde der Fehler in dem zweiten Testfall jetzt behoben. Insofern macht es Sinn \"(mit Fehler)\" aus dem Namen des zweiten Testfalls zu löschen, genauso wie \"(verursacht Fehler)\" aus dem Namen des Testschritts. Es gibt manchmal Situationen, in denen das SUT ständig den Fokus für sich beansprucht. Dann kann es schwierig sein, das QF‑Test Fenster lange genug im Vordergrund zu halten, um die Pausetaste drücken zu können. In einem solchen Fall steht Ihnen die \"Keine Panik\"-Taste Alt⁠+⁠F12 zur Verfügung. Sie unterbricht alle laufenden Tests sofort. Zur Weiterführung des Tests können Sie diese Tastenkombination erneut drücken.","hash":"tut_pause_execution_win","h0":"Testausführung pausieren"},"616":{"id":616,"content":"Pro Tutorial","hash":"","h0":"Variablen und Prozedurparameter (Win) | QF‑Test Tutorial"},"617":{"id":617,"content":"Pro Tutorial","hash":"home-link","h0":"Variablen und Prozedurparameter (Win) | QF‑Test Tutorial"},"618":{"id":618,"content":"Variablen und Prozedurparameter (Win) In diesem Kapitel lernen Sie, wie man eine Prozedur einsetzt um die gleichen Schritte auf unterschiedlichen Daten auszuführen. Außerdem sehen Sie, wie man Variablen einsetzt. Ebenso wird die Fehleranalyse in Bezug auf Variablen behandelt. Dieses Kapitel ist auch als Video verfügbar unter 'Variablen und Prozedurparameter'. Im Video wird eine Java-Applikation für die Erläuterungen verwendet. Bei nativen Windows-Applikationen gibt es hinsichtlich der Variablenverwendung keine Unterschiede.","hash":"sec_variablestackwin","h1":"Variablen und Prozedurparameter (Win)"},"619":{"id":619,"content":"Pro Tutorial","hash":"","h0":"Prozedur mit Variable | QF‑Test Tutorial"},"620":{"id":620,"content":"Pro Tutorial","hash":"home-link","h0":"Prozedur mit Variable | QF‑Test Tutorial"},"621":{"id":621,"content":"Prozedur mit Variable Sehen Sie sich den letzten Testschritt \"Endpreis prüfen\" in unseren beiden Testfällen an.","hash":"sec_ProcedureWithVariableWin","h0":"Prozedur mit Variable"},"622":{"id":622,"content":"Abbildung 24.1: Zwei fast gleiche Testschritte Es wird der gleiche Schritt ausgeführt, jedoch mit unterschiedlichen Daten. Auch wenn es sich nur um einen Schritt handelt, macht es Sinn eine Prozedur daraus zu machen. Vielleicht kommen wir später auf die Idee, die hartkodierten Werte 30.049,00 € und 26.100,00 € in ein anderes Format zu bringen, so dass der Check auf das Feld \"Endpreis\" auch für andere Währungen funktioniert. Diesen Algorithmus zweimal zu implementieren wäre auf jeden Fall nicht sinnvoll. Selektieren Sie den \"Check text\" Knoten im ersten Testfall. Wählen Sie den Menüpunkt »Operationen«-»Knoten einpacken in«-»Sequenz« aus oder verwenden Sie das Tastaturkürzel Strg⁠+⁠Umschalt⁠+⁠S um ihn in eine Sequenz einzupacken. Nennen Sie die Sequenz 'prüfeEndpreis'. Dieser Name entspricht der Java-Konvention die Wörter zusammenzuschreiben. Andererseits erlaubt QF‑Test auch Leerzeichen in Prozedurnamen, so dass Sie der Java-Konvention nicht zu folgen brauchen. Drücken Sie Strg⁠+⁠Umschalt⁠+⁠P um auf kürzestem Weg den Sequenzknoten in eine Prozedur zu konvertieren (wie aus dem letzten Kapitel bekannt). Wie Sie sehen, wurde die Sequenz durch einen Prozeduraufruf von \"prüfeEndpreis\" ersetzt. Klicken Sie doppelt auf den Prozeduraufruf, um zur Prozedur im Prozeduren Knoten zu springen. Öffnen Sie den neu erstellten Prozedurknoten um den Inhalt zu sehen.","hash":"fig_params1Win","h4":"Abbildung 24.1: Zwei fast gleiche Testschritte"},"623":{"id":623,"content":"Abbildung 24.2: Prozedur mit hartkodiertem Wert Wie erwartet befindet sich der \"Check text\" Knoten in der Prozedur. Er ist jedoch nur für einen einzigen Preis gültig, nämlich 30.049,00 €. Da wir die gleiche Prozedur auch für den zweiten Testfall verwenden möchten, müssen wir den Preis durch eine Variable ersetzen. Der Wert dieser Variable sollte dann beim Prozeduraufruf mit übergeben werden. Im nächsten Beispiel werden wir einen Parameter mit Standardwert im Prozedurknoten einfügen. Standardwerte werden häufig verwendet, wenn der entsprechende Parameter bei den meisten Prozeduraufrufen den Standardwert erhalten würde. Dann braucht man den Standardwert nicht jedes Mal zu spezifizieren, sondern kann auf den im Prozedurknoten definierten Wert zurückgreifen. Obwohl das auf den Preis als Parameter nicht zutrifft, können wir ihn gerade deshalb verwenden um zu zeigen, wie ein Standardwert funktioniert und wie man ihn bei Bedarf mit einem anderen Wert überschreiben kann. Als erstes fügen wir also eine Variable mit Standardwert ein: Selektieren Sie die Prozedur 'prüfeEndpreis' Drücken Sie den \"Zeile einfügen\" Knopf über der Tabelle \"Standardwerte für Parameter\". Tragen Sie preis als Namen des Parameter ein. Tragen Sie 30.049,00 € als Wert ein.","hash":"fig_procedure_hardcoded_win","h4":"Abbildung 24.2: Prozedur mit hartkodiertem Wert"},"624":{"id":624,"content":"Abbildung 24.3: Die Details eines Prozedurknotens Im nächsten Schritt ersetzen wir den Wert des Text Attributs des Check Text Knotens durch eine Referenz auf die Variable.","hash":"fig_parameter_default_values_table_win","h4":"Abbildung 24.3: Die Details eines Prozedurknotens"},"625":{"id":625,"content":"Variablensyntax: Wenn Sie mit Variablen arbeiten, ist es wichtig, sich bewusst zu sein, dass Sie an bestimmten Stellen QF‑Test mitteilen wie, eine Variable heißt und an anderen, dass QF‑Test auf den Wert einer Variablen zugreifen soll. In obigem Beispiel wird QF‑Test in der Namensspalte für die Standardwerte der Variablenname mitgeteilt. In diesem Fall brauchten Sie nur preis einzutragen. Im Text Attribute des Check Text Knotens soll der Wert der Variablen verwendet werden. Bei QF‑Test geschieht dies dadurch, dass Sie den Variablenname in $() setzen, hier $(preis). Falls Sie den Variablennamen nicht in $() setzen, würde QF‑Test den Preis mit der Zeichenfolge preis vergleichen. Selektieren Sie den Check Text Knoten in der Prozedur \"prüfeEndpreis\". Tragen Sie $(preis) im Text Attribut der Check Text Knotendetails ein.","hash":"tut_VariableSyntaxWin","h4":"Abbildung 24.3: Die Details eines Prozedurknotens"},"626":{"id":626,"content":"Abbildung 24.4: 'Check text'-Knoten Führen Sie den ersten Testfall aus. Der Testfall sollte fehlerfrei durchlaufen.","hash":"fig_ProcedureAddVariableWin","h4":"Abbildung 24.4: 'Check text'-Knoten"},"627":{"id":627,"content":"Pro Tutorial","hash":"","h0":"Die Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"628":{"id":628,"content":"Pro Tutorial","hash":"home-link","h0":"Die Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"629":{"id":629,"content":"Die Variablendefinitionen-Tabelle Im nächsten Schritt fügen wir einen Prozeduraufruf im zweiten Testfall ein. Ersetzen Sie den Check Text Knoten des zweiten Testfalls durch einen Prozeduraufruf von \"prüfeEndPreis\". Sie können einfach den Prozeduraufruf aus dem ersten Testfall kopieren oder den Prozeduraufruf wie oben beschrieben einfügen.","hash":"tut_variable_stack_win","h0":"Die Variablendefinitionen-Tabelle"},"630":{"id":630,"content":"Abbildung 24.5: Prozeduraufruf von \"prüfeEndPreis\" in der zweiten Prozedur Wenn im Prozeduraufruf bereits der Preis mit Standardwert eingetragen ist, rührt das daher, dass der Prozeduraufruf mit Hilfe der Prozedur selbst erzeugt wurde. Entweder durch Kopieren der Prozedur oder durch eine Drag-and-Drop Aktion unter Verwendung des Prozedurknoten oder über direktes Einfügen der Prozedur wie weiter oben erläutert. Aktuell geht es jedoch um den Standardwert. Daher bitten wir Sie, den evtl. vorhandenen Preis-Parameter zu löschen, wenn Sie dem Tutorial Schritt für Schritt folgen wollen. Dazu klicken Sie das rote X über der Variablendefinitionen-Tabelle. Überprüfen Sie, ob der Debugger so eingestellt ist, dass er bei Fehlern unterbricht (siehe Debugger-Optionen: Test bei Fehler anhalten). Selektieren Sie den Knoten \"Testfall: Zweiter\". Führen Sie ihn aus, entweder über den Knopf oder durch Drücken der Eingabe Taste. Eine Fehlermeldung zeigt an, dass ein anderer als der angezeigte Preis erwartet wurde. Was lief schief? Lassen Sie uns nach dem Fehler forschen. Üblicherweise würden wir ins Protokoll schauen, aber es gibt noch eine andere wichtige Informationsquelle. Klicken Sie OK, um die Fehlermeldung zu schließen. Im Debugging-Modus sehen Sie rechts unten im QF‑Test Fenster eine Knotenliste mit Variablen, die von diesen gebunden sind. Eventuell müssen Sie die Variablendefinitionen-Tabelle vergrößern, um alle Einträge sehen zu können.","hash":"fig_AddProcedureCallToSecondTestcaseWin","h4":"Abbildung 24.5: Prozeduraufruf von \"prüfeEndPreis\" in der zweiten Prozedur"},"631":{"id":631,"content":"Abbildung 24.6: Variablendefinitionen Die Variablendefinitionen-Tabelle ist beim Debuggen sehr hilfreich, da sie die aktuellen Werte der Variablen anzeigt. Sie unterstützt beim Arbeiten mit Prozeduren als auch beim Verständnis, wie QF‑Test den richtigen Variablenwert ermittelt. QF‑Test geht die Variablendefinitionen-Tabelle immer von oben nach unten durch. Sie sehen, dass in den ersten Zeilen keine Variablen gebunden sind. Auf der Ebene \"Globale Variablen\" ist eine Variable gebunden und auf dem Sekundärstapel für \"Prozedur: prüfeEndpreis\" eine weitere. Die globale Variable wird für die Verbindung zur SUT Applikation verwendet und wurde vor dem Anwendungsstart gesetzt. (vgl. Starten der Anwendung). Die andere Variable interessiert uns im Moment mehr - sie hat jedoch den falschen Wert. Dieser Wert auf dem Sekundärstapel ist der Standardwert, da er dann verwendet wird, wenn nirgendwo sonst einer Variablen mit dem gleichen Namen ein Wert zugewiesen wurde. Um es richtig zu machen, müssen wir den korrekten Wert beim Prozeduraufruf an die Prozedur übergeben. Wieder gibt es mehrere Arten, dies zu tun. Ein Weg wäre, eine neue Zeile in der Variablendefinitionen-Tabelle in den Details des Prozeduraufrufs einzufügen, ähnlich wie beim Prozedurknoten im vorigen Abschnitt. Wenn es jedoch bereits mehrere Prozeduraufrufe gibt, ist folgendes einfacher: Beenden Sie die laufende Testausführung mittels . Führen Sie einen Rechtsklick auf den Prozedurknoten aus und wählen »Weitere Knotenoperationen«-»Parameter von Referenzen anpassen« im Popup-Menü.","hash":"fig_VariableBindingsTable1Win","h4":"Abbildung 24.6: Variablendefinitionen"},"632":{"id":632,"content":"Führen Sie einen Rechtsklick auf den Prozedurknoten aus und wählen »Weitere Knotenoperationen«-»Parameter von Referenzen anpassen« im Popup-Menü. Abbildung 24.7: Popup-Menü für \"Parameter von Referenzen anpassen\" Prüfen Sie im folgenden Dialog, dass ein Häkchen bei »Fehlende Parameter beim Aufrufer hinzufügen« gesetzt ist, und bestätigen Sie mit OK. Im Prozeduraufruf erzeugt QF‑Test für jeden Standardwert eine Zeile in der Variablen Definitionen Tabelle. In unserem Fall wurde eine Zeile für den Parameter mit dem Namen preis und dem Wert 30.049,00 € hinzugefügt. Auch damit wird es im zweiten Testfall noch nicht funktionieren, auch wenn der Wert direkt übergeben wird, weil es sich immer noch um den Standardwert handelt, der hier nicht korrekt ist. Bitte verändern Sie den Wert noch nicht, damit wir Ihnen mittels des entstehenden Fehlers eine weitere Möglichkeit des Debuggens zeigen können. Schließen Sie den Dialog \"Angepasste Knoten\", den QF‑Test anzeigt, um Sie über die vervollständigten Knoten zu informieren.","hash":"fig_CompleteParameters_win","h4":"Abbildung 24.6: Variablendefinitionen"},"633":{"id":633,"content":"Pro Tutorial","hash":"","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"634":{"id":634,"content":"Pro Tutorial","hash":"home-link","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"635":{"id":635,"content":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle Als nächstes wollen wir die Variablendefinitionen-Tabelle unter die Lupe nehmen und herausfinden, wie man sie für Debugging-Zwecke einsetzen kann. Daher belassen Sie bitte den fehlerhaften Wert, der im vorigen Abschnitt im Prozeduraufruf eingefügt wurde. Dazu soll die Ausführung des Testfalls beim Prozeduraufruf unterbrochen werden um dann mittels Einzelschritten in die Prozedur zu gehen. Dabei werden wir uns ansehen, was in der Variablendefinitionen-Tabelle passiert. Anschließend wollen wir direkt aus der Variablendefinitionen-Tabelle zum fehlerhaften Prozeduraufruf springen und dort den Parameterwert korrigieren. Setzen Sie einen Breakpoint bei \"Prozeduraufruf: prüfeEndpreis\" im zweiten Testfall. Führen Sie den zweiten Testfall aus. Wenn QF‑Test am Breakpoint anhält, führen Sie zwei Einzelschritte in die Prozedur mittels aus und beobachten dabei die Variablendefinitionen-Tabelle.","hash":"tut_variable_stack_debugging_win","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle"},"636":{"id":636,"content":"Abbildung 24.8: Variablendefinitionen-Tabelle zeigt den falschen Wert Wenn Sie mit Einzelschritten in die Prozedur gehen, wird beim ersten eine Zeile für \"Prozeduraufruf: prüfeEndpreis\" oben in der Tabelle erzeugt und beim zweiten die Zeile \"Prozedur: prüfeEndpreis\". Jetzt gibt es die Variable preis auf zwei verschiedenen Ebenen in der Variablen Definitionen Tabelle: in der Zeile für \"Prozeduraufruf: prüfeEndpreis\" und in der Zeile \"Prozedur: prüfeEndpreis\" auf dem Sekundärstapel, wobei keiner der beiden Variablenwerte der richtige ist. In QF‑Test können Sie interaktiv die Werte von Variablen in der Variablendefinitionen-Tabelle verändern, wenn Sie sich im Debugging-Modus befinden. Sie können sogar neue Variablen hinzufügen oder vorhandene löschen. Damit können Sie arbeiten, solange sich die Variablen auf dem Variablenstapel befinden, in unserem Fall solange wie die Prozedur ausgeführt wird. Änderungen des aktuellen Variablenwertes in der Variablendefinitionen-Tabelle bewirken keine Anpassung des im Prozeduraufrufknoten eingetragenen Parameterwerts. Der Wert muss explizit im Prozeduraufruf geändert werden. Die schnellste Methode um zum Prozeduraufruf zu gelangen ist ein Doppelklick auf die Prozeduraufrufzeile (zweite Zeile) in der Variablendefinitionen-Tabelle. Diese Methode ist besonders hilfreich, wenn Sie umfangreiche Testsuiten debuggen und der Knoten, zu dem Sie springen wollen, nicht im Testsuite-Fenster angezeigt wird. Statt eines Doppelklicks können Sie auch einen Rechtsklick auf die Zeile ausführen und den Menüpunkt »Zu Knoten in Testsuite springen« wählen. Führen Sie einen Doppelklick auf die zweite Zeile mit dem Prozeduraufruf in der Variablendefinitionen-Tabelle aus. Setzen Sie den Parameterwert auf den richtigen Wert, d.h. 26.100,00 €. Umgekehrt wird auch der aktuelle Wert in der Variablendefinitionen-Tabelle dadurch nicht verändert. Um dies zu erreichen müssen wir den Prozeduraufruf erneut ausführen. Allerdings ist die Testausführung über diesen Punkt bereits hinaus. Daher wollen wir hier eine weitere nützliche Funktion des Debuggers zeigen, mit der man den QF‑Test anweisen kann, den nächsten auszuführenden Knoten zu verändern. Dazu selektieren Sie den entsprechenden Knoten und wählen den Menüpunkt »Ausführung hier fortsetzen« oder verwenden das Tastaturkürzel Strg⁠+⁠,. Also, um den neu gesetzten Wert auszuprobieren: Führen Sie einen Rechtsklick auf den Knoten \"Prozeduraufruf: prüfeEndpreis\" in der zweiten Prozedur aus. Wählen Sie \"Ausführung hier fortsetzen\" im Popup-Menü.","hash":"fig_VariableStack3Win","h4":"Abbildung 24.8: Variablendefinitionen-Tabelle zeigt den falschen Wert"},"637":{"id":637,"content":"Abbildung 24.9: Ausführung hier fortsetzen In der Variablendefinitionen-Tabelle sind die zwei obersten Zeilen verschwunden. Der Grund ist, dass Sie die Prozedur verlassen haben (wenn auch \"rückwärts\") und dass dadurch der Prozeduraufruf mit den daran gebundenen Variablen vom Aufrufstack genommen wurde. Lösen Sie den Pauseknopf . Nun sollte kein Fehler mehr auftauchen. Da die Variablendefinitionen-Tabelle äußerst hilfreich ist, wenn Sie nach fehlerhaften Variablenwerten fahnden, wird eine Kopie davon auch unter dem Knoten \"Stacktrace\" im Protokoll abgespeichert, in dem die Variablenwerte genau zum Zeitpunkt des Fehlers zu sehen sind.","hash":"fig_ProcedureContinueExecFromHereWin","h4":"Abbildung 24.9: Ausführung hier fortsetzen"},"638":{"id":638,"content":"Aktuellen Knoten finden: Manchmal entfernt man sich beim Debuggen ziemlich weit vom aktuellen Knoten und möchte anschließend wieder zu diesem Knoten zurückfinden. Das geht am einfachsten indem man in der Toolbar \"Aktuellen Knoten finden\" drückt oder den Menüpunkt »Debugger«-»Aktuellen Knoten finden« wählt.","hash":"locate_current_node_win locate_current_node_win","h4":"Abbildung 24.9: Ausführung hier fortsetzen"},"639":{"id":639,"content":"Pro Tutorial","hash":"","h0":"Variablen setzen | QF‑Test Tutorial"},"640":{"id":640,"content":"Pro Tutorial","hash":"home-link","h0":"Variablen setzen | QF‑Test Tutorial"},"641":{"id":641,"content":"Variablen setzen Zusätzlich zu den oben beschriebenen Wegen können die Variablen auch wie folgt gesetzt werden: Mittels Variable setzen Knoten, als Rückgabewert einer Prozedur, als Ergebnis eines QF‑Test Knotens wie Text auslesen, Geometrie auslesen, Index auslesen und Check, in der 'Variablendefinitionen' Tabelle von Testsuite, Testfall, Testschritt, Sequenz und weiteren Knoten wie dem If oder Schleife Knoten, über Kommandozeilenparameter. Informationen dazu, an welcher Stelle eine Variable am besten definiert wird, finden Sie im nächsten Abschnitt. Ein Variable setzen Knoten kann über den Menüpunkt »Einfügen«-»Diverse Knoten«-»Variable setzen« eingefügt werden. In den Knotendetails können Sie angeben, ob es sich um eine lokale (Häkchen bei \"Lokale Variable\" setzen) oder eine globale Variable handeln soll. Die folgende Abbildung zeigt die Details eines Variable setzen Knotens, den Sie als ersten Knoten im Vorbereitung Knoten finden. Es wird eine Variable mit dem Namen client definiert. Dass es sich um eine globale Variable handelt, erkennen Sie daran, dass das Attribut 'Lokale Variable' nicht gesetzt ist.","hash":"tut_setting_variables_win","h0":"Variablen setzen"},"642":{"id":642,"content":"Abbildung 24.10: Details des Variable setzen Knoten Wenn eine Variable mit dem Rückgabewert einer Prozedur gesetzt werden soll, geben Sie den Variablennamen im Attribut \"Variable für Rückgabewert\" des Prozeduraufrufs an. In der Prozedur selbst müssen Sie als letzten auszuführenden Knoten einen Return Knoten einfügen, der den betreffenden Wert zurückgibt. Die Prozedur in der folgenden Abbildung liest den Rabattwert aus dem SUT und gibt den Wert an den aufrufenden Testfall zurück. Dort heißt die empfangende Variable Rabatt und ist als lokale Variable deklariert. Dieses Beispiel ist nicht in der Übungstestsuite enthalten.","hash":"fig_DetailsSetVariableWin","h4":"Abbildung 24.10: Details des Variable setzen Knoten"},"643":{"id":643,"content":"Abbildung 24.11: Prozedur mit Rückgabewert Der Text auslesen Knoten in der obigen Abbildung ist einer der QF‑Test Knoten, die direkt den Wert einer Variablen setzen. Dabei wird der Variablenname in dem entsprechend benannten Attribut eingetragen. Sie haben wiederum die Wahl, ob es eine lokale oder globale Variable werden soll. Es gibt eine Reihe von Knoten, die eine Variablendefinitionen-Tabelle besitzen. Dort können Sie lokale Variablen setzen. Falls sich der betreffende Knoten in einer Prozedur befindet, wird die Variable als lokale Variable an die Prozedur gebunden, ansonsten als lokale Variable an den Testfall. Variablen, die mittels dieser Tabelle an den Testsuite Knoten gebunden sind, können von allen Knoten der Testsuite referenziert werden. Alle Knoten, an die Variablen gebunden werden können, werden im Debugger-Modus im Variablen Definitionen Fenster rechts unten angezeigt, wenn sie gerade ausgeführt werden. Variablen können auch über die Kommandozeile spezifiziert werden. Hierzu verwenden Sie den Kommandozeilenparameter -variable. Beispiel: qftest -batch -variable \"browser\"=\"ie\" test.qft. Weitere Informationen hierzu finden Sie im Handbuch, Kapitel 'Kommandozeilenargumente'.","hash":"fig_DetailsCallProcedureWin","h4":"Abbildung 24.11: Prozedur mit Rückgabewert"},"644":{"id":644,"content":"Pro Tutorial","hash":"","h0":"Ebenen für Variablendefinitionen | QF‑Test Tutorial"},"645":{"id":645,"content":"Pro Tutorial","hash":"home-link","h0":"Ebenen für Variablendefinitionen | QF‑Test Tutorial"},"646":{"id":646,"content":"Ebenen für Variablendefinitionen Dieser Abschnitt gibt Antworten auf die Frage, auf welcher Ebene eine Variable definiert werden sollte. Wenn Sie diese Frage momentan nicht interessiert, können Sie direkt zum nächsten Kapitel springen. Variablen können auf unterschiedlichen Ebenen gebunden werden: Im Testsuite Knoten, in Testfällen und Prozeduren als Standard- oder als lokale Variablen, als Parameter in einem Prozeduraufruf, als globale Variable und als Kommandozeilenparameter. Die Ebene, auf welcher eine Variable am sinnvollsten definiert wird, hängt vom Verwendungszweck der Variablen ab: Prozedurparameter Übergeben Sie einen Wert als Parameter an eine Prozedur, wenn die gleiche Prozedur mehr als einmal und mit unterschiedlichen Werten ausgeführt werden soll. Prozedurparameter werden in der Variable Definitionen Tabelle eines Prozeduraufruf Knoten angegeben. Lokale Variablen in einer Prozedur Lokale Variablen werden innerhalb der Prozedur definiert und sind nur dort gültig. Wenn die Prozedur beendet wird, werden sie gelöscht. Verwenden Sie eine lokale Variable, wenn diese nicht außerhalb der Prozedur benötigt wird. Sie sind das Mittel der Wahl für Zwischenergebnisse. Lokale Variablen in einem Testfall In einem Testfall können lokale Variable entweder während der Durchführung des Testfall angelegt werden oder über die entsprechende Tabelle in den Details des Testfall Knotens. Wenn Sie in einem Testfall mehrfach den gleichen Wert verwenden, ist es sinnvoll, diesen einmalig einer Variablen zuzuweisen und dann die Variable zu verwenden. Dies erhöht die Wartbarkeit. Auch für Zwischenergebnisse sollte man lokale Variablen verwenden. Globale Variablen Wenn globale Variablen einmal erstellt wurden, existieren sie, bis sie entweder explizit gelöscht werden oder bis QF‑Test beendet wird. Auch Stopps und die erneute Ausführung von Tests \"überleben\" sie. Verwenden Sie sie für Werte, die in mehreren Testfällen genutzt werden. Ein Beispiel ist die Variable client, die im Vorbereitung Knoten beim Start der Applikation angelegt wird. Um sie wieder loszuwerden, wählen Sie den Menüpunkt »Wiedergabe«-»Globale Variablen löschen«. Auch beim Beenden von QF‑Test werden sie gelöscht. Kommandozeilenparameter Variablen, die über Kommandozeile gesetzt werden, sind im Batch-Modus sinnvoll, wenn Sie mehrere Batch-Läufe mit unterschiedlichen Werten durchführen wollen. Kommandozeilenparameter gelten während der gesamten Laufzeit des Batch-Laufs. Ein typisches Beispiel ist die variablengesteuerte Ausführung auf verschiedenen Browsern. Variablen können über den Kommandozeilen-Parameter -variable spezifiziert (vgl. Kapitel 'Kommandozeilenargumente' im Handbuch). Testsuite-Variablen Testsuite-Variablen können von allen Testfällen verwendet werden. Ihr Verwendungszweck entspricht dem von globalen Variablen, nur dass sie im Batch-Modus durch Variablen in der Kommandozeile überschrieben werden können. Standardwerte (Sekundärstapel) Sie können Standardwerte für die Variablen von Prozeduren, Testfällen und Testfallsätzen definieren. Diese kommen zum Zug, wenn keine Variable mit dem gleichen Namen auf einer höheren Ebene definiert wurde.","hash":"tut_variable_levels_win","h0":"Ebenen für Variablendefinitionen"},"647":{"id":647,"content":"Pro Tutorial","hash":"","h0":"Die Standardbibliothek (Win) | QF‑Test Tutorial"},"648":{"id":648,"content":"Pro Tutorial","hash":"home-link","h0":"Die Standardbibliothek (Win) | QF‑Test Tutorial"},"649":{"id":649,"content":"Die Standardbibliothek (Win) Dieses Kapitel ist auch als Video verfügbar unter 'Die Standardbibliothek'. QF‑Test stellt eine gewisse Anzahl an Knotentypen bereit, die für die Testerstellung genutzt werden können. Wenn Sie Funktionalität benötigen, die darüber hinausgeht, können Sie diese mittels Skript-Knoten implementieren. Um Ihnen die Arbeit zu erleichtern, wurden viele Funktionen, die häufig benötigt werden, bereits in Prozeduren implementiert und werden in einer Standard-Prozeduren-Bibliothek mit QF‑Test ausgeliefert. Wenn Sie also eine Aufgabenstellung haben, die nicht über die bereitgestellten Knoten gelöst werden kann, sollten Sie zunächst einmal in der Standardbibliothek forschen, ob Sie dort eine passende oder ähnliche Lösung finden. Wenn Sie eine ähnliche Lösung finden, kopieren Sie einfach die vorhandene Standardprozedur und passen sie Sie gemäß Ihrer Bedürfnisse an. Informationen zum Arbeiten mit Skripten erhalten Sie im Handbuch, Kapitel 12 \"Skripting\". Die Bibliothek ist in der Datei qfs.qft enthalten und ist Teil der QF‑Test Distribution. Da sie mit jeder QF‑Test Version weiterentwickelt wird, ist es nicht ratsam, Änderungen in der ausgelieferten Standardbibliothek vorzunehmen, sondern bei Bedarf eine Prozedur in eine eigene Testsuite zu kopieren und dort anzupassen. Um die Bibliothek qfs.qft verwenden zu können, muss sie im \"Testsuite\" Wurzelknoten Ihrer Suite in den \"inkludierten Dateien\" eingebunden werden. Bei neuen Testsuiten ist dies automatisch der Fall. Wählen Sie den 'Testsuite'-Wurzelknoten Ihrer Testsuite aus. Überprüfen Sie in den Details des 'Testsuite'-Wurzelknoten, dass qfs.qft im Attribut \"Inkludierte Dateien\" aufgeführt ist. Fügen Sie qfs.qft zu dieser Liste dazu, falls es noch nicht enthalten ist. Eine Pfadangabe ist nicht notwendig, da das include Verzeichnis von QF‑Test automatisch im Bibliothekspfad (siehe auch Referenzteil des Handbuchs) enthalten ist. Im Folgenden beschreiben wir eine Auswahl der am häufigsten benötigten Standardprozeduren. Eine vollständige HTML-Dokumentation der Standardbibliothek finden Sie unter dem Menüpunkt »Hilfe«-»Standardbibliothek qfs.qft...«.","hash":"sec_StandardLibraryWin","h1":"Die Standardbibliothek (Win)"},"650":{"id":650,"content":"Pro Tutorial","hash":"","h0":"Erforschen der Standardbibliothek | QF‑Test Tutorial"},"651":{"id":651,"content":"Pro Tutorial","hash":"home-link","h0":"Erforschen der Standardbibliothek | QF‑Test Tutorial"},"652":{"id":652,"content":"Erforschen der Standardbibliothek Zusätzlich zum Einfügen von Prozeduraufrufen aus der Standardbibliothek ist es hilfreich, einen Blick darauf zu werfen, wie Funktionen implementiert und organisiert sind. Öffnen Sie die Bibliothek selbst, also die Suite qfs.qft, die sich im Verzeichnis qftest-10.0.2-pro/include Ihrer QF‑Test Installation befindet.","hash":"sec_StandardLibraryOverviewWin","h0":"Erforschen der Standardbibliothek"},"653":{"id":653,"content":"Abbildung 25.1: Die Standardbibliothek Sie sehen ein Haupt-Package qfs, das die spezifischen Packages umschließt. Das qfs Package hilft dabei, die Prozeduren leicht als solche der Standardbibliothek zu identifizieren. In fast allen Prozeduren unserer Bibliothek werden Sie die Verwendung der Variable $(client) bemerken. Dies ist ein Standardmechanismus, um Testsuiten unabhängig von einem spezifischen SUT zu gestalten. Für die Benutzung der Standardbibliothek wird vorausgesetzt, dass ein gültiger Wert für $(client) gesetzt wird, bevor eine ihrer Prozeduren verwendet werden kann.","hash":"fig_SuiteQfsQftWin","h4":"Abbildung 25.1: Die Standardbibliothek"},"654":{"id":654,"content":"Pro Tutorial","hash":"","h0":"Ausgewählte Packages und Prozeduren | QF‑Test Tutorial"},"655":{"id":655,"content":"Pro Tutorial","hash":"home-link","h0":"Ausgewählte Packages und Prozeduren | QF‑Test Tutorial"},"656":{"id":656,"content":"Ausgewählte Packages und Prozeduren Wir werfen nun einen genaueren Blick auf ein paar ausgewählte Packages und Prozeduren der Standardbibliothek.","hash":"sec_StandardLibraryPackagesWin","h0":"Ausgewählte Packages und Prozeduren"},"657":{"id":657,"content":"Das Run-log Package Das Package qfs.run-log enthält Prozeduren, um Meldungen in das Protokoll zu schreiben. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: logError Schreibt eine Fehlermeldung ins Protokoll. logWarning Schreibt eine Warnung ins Protokoll. logMessage Schreibt eine Meldung ins Protokoll.","hash":"sec_win_run_log_package","h1":"Das Run-log Package"},"658":{"id":658,"content":"Das Run-log.Screenshots Package Das qfs.run-log.screenshots Package enthält Prozeduren, die Bildschirmabbilder ins Protokoll schreiben und einige Hilfsprozeduren. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: getMonitorCount Liefert die Anzahl der an den Computer angeschlossenen Monitore. logScreenshot Schreibt ein Bildschirmabbild des aktuellen Monitors ins Protokoll. logImageOfComponent Schreibt ein Bildschirmabbild einer Komponente ins Protokoll. logScreenshotOfMonitor Schreibt ein Bildschirmabbild eines angegebenen Monitors ins Protokoll.","hash":"sec_win_run_log_screenshots_package","h1":"Das Run-log.Screenshots Package"},"659":{"id":659,"content":"Das Shellutils Package Das qfs.shellutils Package beinhaltet Prozeduren für die wichtigsten Shell-Kommandos. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: copy Kopiert eine angegebene Datei oder ein Verzeichnis an eine neue Stelle. deleteFile Löscht eine angegebene Datei. exists Prüft, ob eine angegebene Datei oder ein Verzeichnis existiert. getBasename Gibt den Dateinamen einer Datei zurück. getParentDirectory Gibt die Verzeichnisstruktur einer Datei zurück. mkdir Erzeugt ein Verzeichnis. Noch nicht existierende Verzeichnisse werden angelegt. move Verschiebt eine angegebene Datei oder ein Verzeichnis. touch Erzeugt eine Datei. removeDirectory Löscht ein angegebenes Verzeichnis.","hash":"sec_win_shellutils_package","h1":"Das Shellutils Package"},"660":{"id":660,"content":"Das Utils Package Das Package qfs.utils enthält nützliche Prozeduren für häufig auftretende Anforderungen der Testentwicklung. Hier sehen Sie einige Prozeduren des Packages: getDate Gibt einen String zurück, der ein Datum enthält. Standardmäßig wird das aktuelle Datum zurückgegeben. (Andere Daten sind konfigurierbar.) getTime Gibt einen String zurück, der eine Zeit enthält. Standardmäßig wird die aktuelle Zeit zurückgegeben. (Andere Zeiten sind konfigurierbar.) logMemory Schreibt den aktuellen Speicherverbrauch ins Protokoll. printVariable Gibt den Inhalt einer spezifizierten Variable auf der Konsole aus. printMessage Gibt den Inhalt einer angegebenen Nachricht auf der Konsole aus. writeMessageIntoFile Schreibt einen angegebenen String in eine angegebene Datei.","hash":"sec_win_utils_package","h1":"Das Utils Package"},"661":{"id":661,"content":"Das Database Package Das Package qfs.database enthält nützliche Prozeduren, um mit Datenbanken zu interagieren. Bitte beachten Sie, dass die jar-Datei mit dem Datenbanktreiber vor dem Start von QF‑Test ins qftest Pluginverzeichnis kopiert werden muss. Für weitere Informationen über den Aufbau einer Datenbankverbindung kontaktieren Sie bitte einen Entwickler oder werfen Sie einen Blick auf www.connectionstrings.com. Die wichtigsten Prozeduren sind: executeSelectStatement Führt einen angegebenen SQL-Select-Befehl aus. Das Ergebnis wird zum einen in die globale Variable \"resultRows\" des Jython Variablenstacks geschrieben und ist somit in jedem Jython Skript verfügbar. Zum anderen wird das Ergebnis auch in eine Gruppenvariable mit dem Standardnamen \"resultGroup\" geschrieben und ist somit direkt von QF‑Test Knoten aus ansprechbar. executeStatement Führt einen angegebenen SQL Befehl aus. Hier kann jedes beliebige SQL Kommando ausgeführt werden.","hash":"sec_win_database_package","h1":"Das Database Package"},"662":{"id":662,"content":"Das Check Package Das qfs.check Package enthält Prozeduren, die Checks ausführen. Die wichtigsten Prozeduren sind: checkEnabledStatus Überprüft, ob eine Komponente en- bzw. disabled ist. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt. checkSelectedStatus Überprüft, ob eine Komponente selektiert bzw. nicht selektiert ist. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt. checkText Überprüft den Text einer Komponente. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt.","hash":"sec_win_check_package","h1":"Das Check Package"},"663":{"id":663,"content":"Das Databinder Package Das Package qfs.databinder enthält Prozeduren zur Ausführung innerhalb eines Datentreiber Knotens, um Daten für datengetriebenes Testen zu binden. Die wichtigsten Prozeduren sind: bindList Bindet eine Liste von Werten an eine Variable. Die Werte sind durch Leerzeichen oder das als Parameter übergebene Trennzeichen getrennt. bindSets Bindet Sätze von Werten an einen Satz von Variablen. Die Sätze von Werten sind durch Zeilenumbrüche getrennt, die Werte innerhalb eines Satzes durch Leerzeichen oder das als Parameter übergebene Trennzeichen.","hash":"sec_win_databinder_package","h1":"Das Databinder Package"},"664":{"id":664,"content":"Pro Tutorial","hash":"","h0":"Ablaufsteuerung (Win) | QF‑Test Tutorial"},"665":{"id":665,"content":"Pro Tutorial","hash":"home-link","h0":"Ablaufsteuerung (Win) | QF‑Test Tutorial"},"666":{"id":666,"content":"Ablaufsteuerung (Win) Dieses Kapitel ist auch als Video verfügbar unter 'Ablaufsteuerung'. Die zwei wichtigsten Kontrollstrukturen von QF‑Test sind Schleifen und die bedingte Ausführung von Knoten. Schleifen können über zwei verschieden Knoten implementiert werden: While und Schleife Knoten. If, Elseif und Else Knoten stehen für die bedingte Ausführung von Knoten zur Verfügung.","hash":"sec_controlstructureswin","h1":"Ablaufsteuerung (Win)"},"667":{"id":667,"content":"Pro Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"668":{"id":668,"content":"Pro Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"669":{"id":669,"content":"If - else If Knoten kennen Sie bereits aus der Vorbereitung Sequenz im Kapitel Starten der Anwendung. Sehen wir uns diesen nun etwas genauer an.","hash":"sec_ifwin","h0":"If - else"},"670":{"id":670,"content":"Abbildung 26.1: Setup Sequenz mit If/Elseif Knoten Über einen If Knoten können Sie steuern, ob bestimmte Knoten ausgeführt werden oder nicht. In unserem Fall geht es um den Start des SUT. Zunächst müssen wir herausfinden, ob die Applikation bereits läuft. Dies geschieht über den Warten auf Client Knoten, der als Ergebnis entweder true (wahr) oder false (falsch) in die Variable isSUTRunning schreibt.","hash":"fig_ControlsSetupSequenceWin","h4":"Abbildung 26.1: Setup Sequenz mit If/Elseif Knoten"},"671":{"id":671,"content":"Abbildung 26.2: Warten auf Client setzt die Variable \"isSUTRunning\" mit dem Ergebnis Der If Knoten wertet die Ergebnisvariable isSUTRunning im 'Bedingung' Attribut aus. Da auf den Wert der Variablen zugegriffen werden soll, wird die Syntax $() verwendet (vgl. Hinweis zu Variablensyntax in Kapitel \"Prozedur mit Variable\").","hash":"fig_ControlsWaitForClientWin","h4":"Abbildung 26.2: Warten auf Client setzt die Variable \"isSUTRunning\" mit dem Ergebnis"},"672":{"id":672,"content":"Abbildung 26.3: Der If Knoten wertet die Variable aus Je nachdem, ob die Applikation bereits läuft, führt QF‑Test die im If Knoten enthaltenen Knoten aus oder nicht. Beenden Sie das CarConfig Demo, falls es läuft. Führen Sie den Vorbereitung Knoten mit Einzelschritten aus. Führen Sie den Vorbereitung Knoten nochmals mit Einzelschritten aus während das CarConfig Demo läuft. In der Variablendefinition-Tabelle können Sie den Wert der Variablen isSUTRunning prüfen. Beim ersten Mal ist der Wert false und damit die Bedingung not $(isSUTRunning) wahr, d.h. die Knoten für den SUT-Start werden ausgeführt. Beim zweiten Mal ist der Wert true und damit die Bedingung false. Die Knoten im If Knoten werden übersprungen. Im ersten Knoten der Vorbereitung werden If Knoten verwendet, um abhängig vom Betriebssystem den zu verwendenden Win-Browser in einer globalen Variable zu hinterlegen. Der besseren Lesbarkeit halber werden hier nur If Knoten verwendet. Es wäre ebenso möglich mit Elseif und Else Knoten zu arbeiten. In einem Elseif Knoten wird eine weitere Bedingung formuliert, die dann geprüft wird, wenn die Bedingung im If Knoten nicht zutrifft. Die Kindknoten des Else Knoten werden nur dann ausgeführt, wenn weder die Bedingung des If noch die der Elseif Knoten zutreffen. Bei der Prüfung des Betriebssystems wird direkt auf eine QF‑Test Variable zugegriffen. QF‑Test speichert die Betriebssysteminformation in einer Gruppenvariable ab, wobei die Gruppe qftest und die Variablen linux, macos oder windows heißen. Die Syntax für den Zugriff auf Gruppenvariablen ist ${group:varname}, z.B. ${qftest:windows}.","hash":"fig_ControlsIfWin","h4":"Abbildung 26.3: Der If Knoten wertet die Variable aus"},"673":{"id":673,"content":"Pro Tutorial","hash":"","h0":"Schleifen | QF‑Test Tutorial"},"674":{"id":674,"content":"Pro Tutorial","hash":"home-link","h0":"Schleifen | QF‑Test Tutorial"},"675":{"id":675,"content":"Schleifen QF‑Test stellt zwei Knotentypen für die Implementierung von Schleifen zur Verfügung: Schleife Knoten führen ihre Kindknoten so oft aus, wie angegeben ist. Man kann die Schleife jedoch über einen Break Knoten jederzeit verlassen. While Knoten führen ihre Kindknoten so oft aus, bis die angegebene Bedingung nicht mehr gegeben ist. Derartige Schleifen können ebenfalls über einen Break Knoten jederzeit verlassen werden. Schleife Knoten enden auf jeden Fall nach der angegeben Anzahl von Wiederholungen. Bei While Knoten muss man jedoch selbst dafür sorgen, dass die Ausführung irgendwann endet, indem die Bedingung falsch wird. Ansonsten kommt es zur Endlosschleife. Im interaktiven Modus können Sie in so einem Fall einfach die Pausetaste drücken. Im Batch-Modus, d.h. wenn Sie QF‑Test mit dem Kommandozeilenparameter -batch starten um die angegebene Testsuite ohne die QF‑Test Benutzeroberfläche auszuführen, müssen Sie dann jedoch den QF‑Test Prozess \"abschießen\". In der folgenden Übung wollen wir einen Testfall implementieren, der prüft, ob eine bestimmte Zeile in der Tabelle des CarConfig Demos angezeigt wird. Die im Testfall durchgeführten Aktionen sind: Anzahl Tabellenzeilen bestimmen. Über alle Zeilen iterieren und prüfen, ob die Zeile passt. Wenn die Zeile gefunden wurde, die Schleife abbrechen. Falls die Zeile nicht gefunden wurde, einen Fehler ins Protokoll schreiben. Bitte beginnen Sie mit der Aufnahme eines Checks auf die zu suchende Zeile: Aktivieren Sie den Check-Aufnahmemodus über \"Checks aufnehmen\" . Führen Sie einen Rechtsklick auf eine Tabellenzeile im CarConfig Demo aus und wählen Sie den Menüpunkt »Zeile« aus dem Popup-Menü. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Ändern Sie den Namen der aufgenommenen Sequenz z.B. in Zeile prüfen. Wandeln Sie die Sequenz in einen Testfall um: Rechtsklick auf den Sequenz Knoten und Auswahl des Untermenüpunkts »Knoten konvertieren in«-»Testfall« im Popup-Menü.","hash":"sec_loopswin","h0":"Schleifen"},"676":{"id":676,"content":"Abbildung 26.4: Knoten konvertieren In QF‑Test können Sie sehr effizient Knoten hinzufügen, indem Sie einen Knoten in einen anderen einpacken: Öffnen Sie den Testfall Knoten und packen Sie den aufgenommenen Check Knoten in eine Schleife indem Sie rechts auf den Knoten klicken und in dem sich öffnenden Popupmenü den Punkt »Knoten einpacken in«-»Schleife« auswählen.","hash":"fig_ControlsTransformNodeIntoWin","h4":"Abbildung 26.4: Knoten konvertieren"},"677":{"id":677,"content":"Abbildung 26.5: Knoten einpacken QF‑Test ermittelt dynamisch, in welche Knoten ein Knoten eingepackt werden kann und bietet nur diese zur Auswahl an. Entsprechend kann es passieren, dass Sie \"Schleife\" im Untermenü nicht finden. Sie sollten dann prüfen, ob Sie den Rechtsklick auf den richtigen Knoten ausgeführt haben. Dasselbe gilt für die Operationen \"Knoten konvertieren in\" und \"Knoten einfügen\". Als nächstes setzen wir den Wert für das Attribut 'Anzahl Wiederholungen' des Schleife Knoten. Dazu müssen wir bestimmen, wie viele Zeilen die Tabelle hat. Es gibt keinen Knoten, der diese Operation direkt ausführen kann. Allerdings gibt es eine derartige Prozedur in der im letzten Kapitel besprochenen Standardbibliothek. Diese befindet sich im Package qfs.win.table und heißt getRowCount. Selektieren Sie den Testfall Knoten und drücken Strg⁠+⁠A. Klicken Sie die Schaltfläche \"Prozedur auswählen\" links neben der Überschrift 'Name der Prozedur'. Wählen Sie den Reiter 'qfs.qft' im 'Prozedur auswählen' Dialog. Navigieren Sie zu 'getRowCount' im Package 'qfs.win.table' Drücken Sie 'OK' um die Prozedur auszuwählen. Das Hinzufügen einer Prozedur über Strg⁠+⁠A wurde in Manuelle Erstellung von Prozeduren beschrieben. Dort finden Sie auch Screenshots zur Aktion. Fügen Sie eine Variable mit dem Namen Zeilen im Attribut 'Variable für Rückgabewert' ein. Ändern Sie den Standardwert für id in der Variablendefinitionen-Tabelle auf die QF‑Test Komponenten-ID der Tabelle VehicleTable. Wählen Sie den 'Schleife'-Knoten. Im Attribut 'Anzahl Wiederholungen' des Schleife Knotens tragen Sie eine Referenz auf die Variable $(Zeilen) ein. Tragen Sie den Namen der Zählervariable, z.B. i, im entsprechenden Attribut des Schleife Knotens ein.","hash":"fig_ControlsPackNodeIntoWin","h4":"Abbildung 26.5: Knoten einpacken"},"678":{"id":678,"content":"Abbildung 26.6: Details eines Schleife Knotens In den Details des Check Knotens tragen wir nun in der QF‑Test ID der Komponente statt des aufgenommenen Zeilenindex eine Referenz auf die Zählervariable ein und setzen eine Ergebnisvariable. Außerdem fügen wir einen If Knoten unter dem Check Knoten hinzu, der das Ergebnis auswertet und die Schleife über einen Break Knoten verlässt, wenn die entsprechende Zeile gefunden wurde. Öffnen Sie den Schleife Knoten. Selektieren Sie den Check Knoten. Ändern Sie den aufgenommenen Zeilenindex der QF‑Test ID der Komponente in Zählervariable $(i). Die QF‑Test ID der Komponente sollte nun VehicleTable@Modell&$(i) lauten. Tragen Sie den Variablennamen ZeileGefunden in das Attribut 'Variable für Ergebnis' ein. Führen Sie einen Rechtsklick auf den Check Knoten aus und wählen Sie aus dem Popup-Menü den Unterpunkt »Knoten einfügen«-»Ablaufsteuerung«-»Break« aus. Packen Sie den Break Knoten in einen If Knoten mittels des Tastaturkürzels Strg⁠+⁠Umschalt⁠+⁠I (Sie können natürlich auch über das Menü gehen). In den Details des 'If'-Knotens tragen Sie $(ZeileGefunden) im Attribut 'Bedingung' ein. Die Variable ZeileGefunden wird vom Check Knoten entweder auf den Wert 'true' oder auf den Wert 'false' gesetzt, so dass wir im Attribut 'Bedingung' des If Knoten nur die Referenz auf die Variable $(ZeileGefunden) einzutragen brauchen. In den nächsten Schritten wollen wir einen Else Knoten als letzten Knoten im Schleife Knoten einfügen. Er wird nur ausgeführt, wenn die Schleife so oft wie angegeben ausgeführt wurde, was in unserem Fall bedeutet, dass die Variable ZeileGefunden nie wahr wurde, weil die Zeile nicht gefunden wurde. Schließen Sie den If Knoten, falls dies nicht bereits der Fall ist. Dies ist wichtig, da sonst der Else Knoten zum If Knoten und nicht zum Schleife Knoten gehören würde. Führen Sie einen Rechtsklick auf den If Knoten aus und wählen Sie auf dem Popup-Menü den Unterpunkt »Knoten einfügen«-»Ablaufsteuerung«-»Else«. Öffnen Sie den Else Knoten. Fügen Sie aus der Standardbibliothek die Prozedur logError aus dem Package qfs.run-log wie oben beschrieben ein. In der 'Variablendefinitionen' Tabelle tragen Sie Zeile nicht gefunden als Wert der Zeile message ein. Tragen Sie true als Wert der Zeile withScreenshots ein. Wenn Sie die Tests im Batch-Modus ausführen, sind Screenshots eine gute Unterstützung bei der Fehleranalyse. Da aber eine große Zahl Screenshots sehr große Protokolldateien erzeugen würden, ist der Standardwert für withScreenshots false. Nun bleibt nur noch, den Testfall mit Vorbereitung und Aufräumen Knoten zu vervollständigen und ihn in den oberen Teil der Testsuite zu verschieben. Kopieren Sie die Vorbereitung und Aufräumen Knoten aus 'Testset: Einfache Tests' in den neuen Testfall als ersten und letzten Knoten. Verschieben Sie den Testfall aus dem Bereich Extrasequenzen in den oberen Bereich der Testsuite hinter den Knoten 'Testset: Einfache Tests'. Damit würde der neue Testfall wie folgt aussehen:","hash":"fig_ControlsLoopDetailsWin","h4":"Abbildung 26.6: Details eines Schleife Knotens"},"679":{"id":679,"content":"Abbildung 26.7: Der neue Testfall Führen Sie den neuen Testfall aus. Er sollte ohne Fehler laufen. Ändern Sie nun in den Details des Check Elemente Knotens den Namen des Fahrzeugs zum Beispiel auf Falscher Wert.","hash":"fig_ControlsTestcaseWin","h4":"Abbildung 26.7: Der neue Testfall"},"680":{"id":680,"content":"Abbildung 26.8: Details eines Check Elemente Knoten Führen Sie den Testfall nochmals aus. Nun sollte der Test den Else Knoten der Schleife ausführen und eine Fehlermeldung anzeigen.","hash":"fig_ControlsCheckDetailsWin","h4":"Abbildung 26.8: Details eines Check Elemente Knoten"},"681":{"id":681,"content":"Pro Tutorial","hash":"","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Win) | QF‑Test Tutorial"},"682":{"id":682,"content":"Pro Tutorial","hash":"home-link","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Win) | QF‑Test Tutorial"},"683":{"id":683,"content":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Win) Dieses Kapitel ist auch als Video verfügbar unter 'Nun ist es Zeit, Ihre eigene Anwendung zu starten'. Nachdem wir so viel Zeit mit all den Beispielanwendungen verbracht haben, sind Sie nun wirklich bereit, Ihre eigene Applikation zu starten (falls Sie dies nicht schon zwischendurch getan haben). Der Schnellstart-Assistent, welcher über das Menü »Extras«-»Schnellstart-Assistent...« erreichbar ist, hilft Ihnen bei dieser Aufgabe. Folgen Sie einfach den Schritten innerhalb des Assistenten, um eine passende Startsequenz zu erzeugen. Bitte schauen Sie auch ins Handbuch Kapitel 3 \"Schnellstart\". Es ist an der Zeit, das Gelernte in die Tat umzusetzen - kurze Sequenzen von Events und Checks aufzunehmen, Prozeduren zu erzeugen etc., um eine eigene Testbibliothek aufzubauen. Damit endet der Basisteil in diesem Tutorial.","hash":"sec_ownappwin","h0":"Nun ist es Zeit, Ihre eigene Anwendung zu starten (Win)"},"684":{"id":684,"content":"Pro Tutorial","hash":"","h0":"Mobile-Anwendungen testen mit QF‑Test | QF‑Test Tutorial"},"685":{"id":685,"content":"Pro Tutorial","hash":"home-link","h0":"Mobile-Anwendungen testen mit QF‑Test | QF‑Test Tutorial"},"686":{"id":686,"content":"Mobile-Anwendungen testen mit QF‑Test Dieser Teil des Tutorials soll Ihnen die Basiseigenschaften und Arbeitsabläufe von QF‑Test zum Testen von Mobilen-Anwendungen erläutern. Die in diesem Tutorial dargestellten Inhalte beziehen sich auf eine Android-Anwendung. Die Grundlagen sind jedoch mit iOS identisch. Voraussetzung ist eine nach dem Handbuch beschriebene Testumgebung. Details zu der erforderlichen Testumgebung finden Sie in den Handbuchkapiteln Android- und iOS-Anwendungen. Bitte schauen Sie sich dieses unbedingt an! Im \"Weiterführende Features von QF‑Test\" werden weiterführende Funktionalitäten von QF‑Test erklärt, die für Tests aller unterstützten GUI-Technologien genutzt werden können.","hash":"sec_mobile","h1":"Mobile-Anwendungen testen mit QF‑Test"},"687":{"id":687,"content":"Pro Tutorial","hash":"","h0":"Bearbeiten einer Beispiel-Testsuite (Mobile) | QF‑Test Tutorial"},"688":{"id":688,"content":"Pro Tutorial","hash":"home-link","h0":"Bearbeiten einer Beispiel-Testsuite (Mobile) | QF‑Test Tutorial"},"689":{"id":689,"content":"Bearbeiten einer Beispiel-Testsuite (Mobile) In diesem ersten Kapitel werden wir uns die Struktur einer einfachen Testsuite anschauen, die wesentlichen Bestandteile erklären, sie ausführen und das Ergebnis auswerten.","hash":"sec_androiddemo","h1":"Bearbeiten einer Beispiel-Testsuite (Mobile)"},"690":{"id":690,"content":"Pro Tutorial","hash":"","h0":"Laden der Testsuite | QF‑Test Tutorial"},"691":{"id":691,"content":"Pro Tutorial","hash":"home-link","h0":"Laden der Testsuite | QF‑Test Tutorial"},"692":{"id":692,"content":"Laden der Testsuite Beim ersten Start von QF‑Test und/oder der zu testenden Anwendung über QF‑Test kann eine Sicherheitswarnung der Firewall auftreten mit der Frage, ob das Netzwerkprotokoll für Java geblockt werden soll oder nicht. Da QF‑Test die Java-Netzwerkprotokolle für die Kommunikation mit dem SUT (System under Test) nutzt, darf diese nicht geblockt werden, um das automatisierte Testen zu ermöglichen. Nach dem Starten von QF‑Test laden Sie bitte unser erstes Beispiel: Drücken Sie den Knopf, um den Dateiauswahl-Dialog zu öffnen. Wechseln Sie in das Unterverzeichnis qftest-10.0.2-pro/doc/tutorial Ihrer QF‑Test Installation. Dort wählen Sie bitte die Datei ErsteAndroidTests.qft aus und öffnen diese. Wollen sie das Tutorial für iOS verwenden verwenden Sie bitte die Datei ErsteIOSTests.qft QF‑Test präsentiert Ihnen die Testsuite wie im folgenden Bild dargestellt:","hash":"tut_loadsuiteandroid","h0":"Laden der Testsuite"},"693":{"id":693,"content":"Abbildung 28.1: Die erste Testsuite Der linke Bereich des Hauptfensters enthält die Testsuite, die in einer Baumstruktur dargestellt wird. Rechts befindet sich die Detailansicht des Knotens, der im Baum gerade markiert ist. (Falls die Detailansicht bei Ihnen nicht zu sehen sein sollte, aktivieren Sie diese bitte über das Menü »Ansicht«-»Details anzeigen« .) Im Bereich unten rechts befindet sich das Terminal, welches die Ausgaben von QF‑Test und dem zu testenden Client protokolliert. Mit Hilfe des Baumes können Sie durch die Testsuite navigieren und einzelne Knoten auswählen, für die dann jeweils die Details im rechten Fensterbereich eingeblendet werden. Doppelklicken Sie bitte den Knoten Testfallsatz: Einfache Tests um ihn zu expandieren und die darin liegenden Knoten sehen zu können. Der Testfallsatz enthält primär zwei Testfälle, umgeben von einem \"Vorbereitung\"/\"Aufräumen\" Knotenpaar, das im Wesentlichen die Testanwendung startet bzw. beendet.","hash":"fig_firstTestSuiteAndroid","h4":"Abbildung 28.1: Die erste Testsuite"},"694":{"id":694,"content":"Abbildung 28.2: Der Inhalt des Testfallsatz Knotens In den folgenden Abschnitten werden wir Funktion und Zweck der einzelnen Knoten erklären.","hash":"fig_firstTestSetAndroid","h4":"Abbildung 28.2: Der Inhalt des Testfallsatz Knotens"},"695":{"id":695,"content":"Pro Tutorial","hash":"","h0":"Gerät starten und verbinden | QF‑Test Tutorial"},"696":{"id":696,"content":"Pro Tutorial","hash":"home-link","h0":"Gerät starten und verbinden | QF‑Test Tutorial"},"697":{"id":697,"content":"Gerät starten und verbinden Die zu testende Android-Anwendung kann entweder direkt auf einem echten Android-Gerät laufen oder in einem Emulator, eine iOS-Anwendung auf einem echten iOS-Gerät oder einem Simulator. Der Begriff \"Gerät\" wird im Folgenden gleichermaßen für ein echtes Gerät einen Emulator oder Simulator verwendet. Zuerst wollen wir die Vorbereitung genauer unter die Lupe nehmen: Expandieren Sie den Knoten Vorbereitung: Gerät starten und verbinden, wie im folgenden Bild gezeigt.","hash":"tut_startsutandroid","h0":"Gerät starten und verbinden"},"698":{"id":698,"content":"Abbildung 28.3: Der Knoten \"Vorbereitung\" Es werden zwei Kindknoten sichtbar: Variable setzen - der Variablen 'client', wird der Verbindungsname für das zu startende SUT zugewiesen, der für jeden Zugriff auf die Applikation benötigt wird. Gerät starten und verbinden, – startet den entsprechenden Emulator (Android) bzw. Simulator (iOS) oder stellt eine Verbindung zum echten Gerät her, falls noch keine Verbindung besteht, und öffnet die Carconfigurator-App.","hash":"fig_firstSetupAndroid","h4":"Abbildung 28.3: Der Knoten \"Vorbereitung\""},"699":{"id":699,"content":"Abbildung 28.4: Die Sequenz zum Starten des mobilen Gerätes In Gerät starten und verbinden wird zuerst über einen Warten auf Client Knoten geprüft, ob der Client bereits läuft. Nur wenn dies nicht der Fall ist, wird er gestartet. Der Start des Gerätes verläuft in zwei Schritten: Zunächst wird über den Mit Android-Gerät verbinden Knoten versucht, QF‑Test direkt mit einem echten Endgerät oder einem laufenden Emulator zu verbinden. Falls dies scheitert, springt QF‑Test in den Catch Knoten, in dem der Android-Emulator starten Knoten den Emulator startet, falls erwünscht. Hinweis: Bei iOS wird der Knoten Mit iOS-Gerät verbinden für die Verbindung zu einem echten iOS-Gerät oder zu einem Simulator verwendet. Warten auf Mobile-Gerät - stellt die endgültige Verbindung zwischen QF‑Test und dem Android-Gerät her und wartet sowohl bei Android als auch bei iOS bis der Verbindungsaufbau abgeschlossen ist. Diese beiden Schritte werden automatisch erzeugt, wenn man den Schnellstart-Assistenten verwendet, der im nächsten Tutorial-Kapitel erklärt wird (\"Starten der Anwendung\"). Wir wollen nun die Anwendung wirklich starten: Wenn Sie ein echtes Gerät oder einen speziellen Emulator verwenden möchten, starten Sie diesen zuerst manuell. Aus Performance-Gründen wird empfohlen, den Emulator manuell zu starten, damit er nicht an den QF‑Test Client-Prozess gebunden ist und nicht jedes Mal neu gestartet werden muss. Alternativ können Sie den Emulator-Namen im Knoten Testsuite unter der Variablendefinition deviceName eintragen. Welche Geräte verfügbar sind, sehen Sie im Menü unter »Extras« »Bekannte Android-Geräte…«. Wird die Variable deviceName nicht ersätzt, sucht QF‑Test zunächst nach einem bereits laufenden Android-Gerät. Läuft kein Gerät, wird ein verfügbares gestartet. Markieren Sie dazu bitte den Knoten Vorbereitung: Gerät starten und Verbinden, doch belassen Sie ihn aufgeklappt. Klicken Sie den Knopf Wiedergabe. Dies führt den aktuellen ausgewählten Knoten aus. Während der Ausführung wird der gerade aktive Knoten durch \"->\" markiert. Nach Abschluss der Startsequenz sollte auf dem Android-Gerät die Demo-App \"CarConfigurator\" erscheinen.","hash":"fig_firstStartAndroid","h4":"Abbildung 28.4: Die Sequenz zum Starten des mobilen Gerätes"},"700":{"id":700,"content":"Abbildung 28.5: Das CarConfigurator AndroidDemo","hash":"fig_androidDemoPage","h4":"Abbildung 28.5: Das CarConfigurator AndroidDemo"},"701":{"id":701,"content":"Pro Tutorial","hash":"","h0":"Ein erster Testfall | QF‑Test Tutorial"},"702":{"id":702,"content":"Pro Tutorial","hash":"home-link","h0":"Ein erster Testfall | QF‑Test Tutorial"},"703":{"id":703,"content":"Ein erster Testfall Als nächstes wollen wir einen Blick auf den ersten Testfall werfen. Er besteht aus vier Testschritten:","hash":"tut_firsttestandroid","h0":"Ein erster Testfall"},"704":{"id":704,"content":"Abbildung 28.6: Der \"Erste\" Testfallknoten Zurücksetzen - stellt den Anfangszustand der Anwendung über das Menü »Datei« > Zurücksetzen wieder her und selektiert den Tab Fahrzeuge. Modell Rolo wählen - Wählt das erste Modell, \"Rolo\", der Fahrzeugliste aus. Sondermodell Jazz wählen - Wechselt zum Tab Sondermodelle und wählt dort \"Jazz\". Endpreis prüfen – Überprüft, ob der berechnete Wert des Feldes \"Endpreis\" einem vorgegebenen Wert entspricht. Testschritte sind oft hilfreich, um einen Testfall zu strukturieren und dadurch lesbar und verständlicher zu gestalten. Dies erleichtert später eine eventuelle Fehlersuche oder Anpassungen des Testfalls. Bitte expandieren Sie die vier Testschritt Knoten.","hash":"fig_firstTestCaseAndroid","h4":"Abbildung 28.6: Der \"Erste\" Testfallknoten"},"705":{"id":705,"content":"Abbildung 28.7: Die Details des ersten Testfalls Sie sehen diverse Mausklicks sowie einen Check. Zur besseren Lesbarkeit des Testfalls wurden sie mittels Testschrittknoten strukturiert. Neben der Aktionsart (Mausklick, Check) wird angezeigt, auf welche Anwendungskomponente sich die Aktion bezieht, also wohin z.B. der Mausklick geht. Diese Knoten können direkt über die Aufnahmefunktion von QF‑Test erzeugt werden. Näheres hierzu erfahren Sie im nächstenErstellen einer eigenen Testsuite (Mobile). Wir wollen uns nun die Ausführung des ersten Testfalls anschauen. Markieren Sie dazu den Testfall: Erster Knoten. Drücken Sie anschließend den Wiedergabeknopf . Die Testschritte werden nun der Reihe nach abgespielt. Das aktuelle Testergebnis wird während und nach dem Testlauf in der Statuszeile am unteren rechten Rand des QF‑Test Hauptfensters angezeigt und sollte \"Beendet: Keine Fehler\" lauten. Daneben zeigt QF‑Test verschiedene Zähler an. Der erste Zähler bezieht sich auf die Anzahl der ausgeführten Testfälle, der zweite auf die Zahl der ausgeführten Testfälle ohne Fehler. In unserem Fall wurde ein Testfall fehlerfrei ausgeführt, was einer Erfolgsquote von 100% entspricht.","hash":"fig_firstTestCaseDetailsAndroid","h4":"Abbildung 28.7: Die Details des ersten Testfalls"},"706":{"id":706,"content":"Abbildung 28.8: Die Ergebnisanzeige in der Statusleiste Wenn Sie den Mauszeiger auf dem Symbol eines Testfallzählers ruhen lassen, wird Ihnen eine entsprechende Beschreibung angezeigt. Eine Auflistung aller Testfallzähler finden Sie im Kapitel Aufnahme und Wiedergabe des Handbuchs.","hash":"fig_resultOneTestCaseNoErrorAndroid","h4":"Abbildung 28.8: Die Ergebnisanzeige in der Statusleiste"},"707":{"id":707,"content":"Pro Tutorial","hash":"","h0":"Ein zweiter Testfall - mit Fehler | QF‑Test Tutorial"},"708":{"id":708,"content":"Pro Tutorial","hash":"home-link","h0":"Ein zweiter Testfall - mit Fehler | QF‑Test Tutorial"},"709":{"id":709,"content":"Ein zweiter Testfall - mit Fehler Der zweite Testfall wird uns zeigen, was passiert, wenn ein Fehler bei der Testausführung auftritt. Bitte expandieren Sie den Knoten Testfall: Zweiter (mit Fehler).","hash":"tut_secondtestandroid","h0":"Ein zweiter Testfall - mit Fehler"},"710":{"id":710,"content":"Abbildung 28.9: Der \"Zweite\" Testfallknoten Bis auf den dritten Testschritt sieht es bekannt aus. Was tut der Unbekannte? Testschritt: 5% Rabatt gewähren - Drückt auf den 5% Rabatt-Button","hash":"fig_secondTestCaseAndroid","h4":"Abbildung 28.9: Der \"Zweite\" Testfallknoten"},"711":{"id":711,"content":"Abbildung 28.10: Die Details des zweiten Testfalls Wir wollen uns die Ausführung des zweiten Testfalls anschauen. Markieren Sie dazu den Testfall: Zweiter (mit Fehler) Knoten. Drücken Sie anschließend den Wiedergabeknopf . Diesmal erscheint ein Dialog mit der Information, dass ein Fehler aufgetreten ist.","hash":"fig_secondTestCaseDetailsAndroid","h4":"Abbildung 28.10: Die Details des zweiten Testfalls"},"712":{"id":712,"content":"Abbildung 28.11: Fehler im zweiten Testfall Was ist passiert? Fast immer wenn so ein Fall auftritt, ist es sinnvoll das Protokoll zu Rate zu ziehen. Alternativ könnte man den Testfall zur Fehlersuche nochmal im Debug-Modus ausführen. Diese Vorgehensweise wird in Kapitel Benutzen des Debuggers (Mobile) erläutert.","hash":"fig_textTestErrorAndroid","h4":"Abbildung 28.11: Fehler im zweiten Testfall"},"713":{"id":713,"content":"Pro Tutorial","hash":"","h0":"Das Protokoll zur Fehlerdiagnose | QF‑Test Tutorial"},"714":{"id":714,"content":"Pro Tutorial","hash":"home-link","h0":"Das Protokoll zur Fehlerdiagnose | QF‑Test Tutorial"},"715":{"id":715,"content":"Das Protokoll zur Fehlerdiagnose QF‑Test protokolliert detaillierte Informationen für jede Testausführung. Öffnen Sie nun bitte das letzte Protokoll über eine der folgenden Möglichkeiten: den Protokoll anzeigen Knopf im Fehlerdialog oder falls Sie den Dialog bereits geschlossen haben den Button in der Werkzeugleiste oder über die Tastenkombination Strg⁠+⁠L . Die Protokolle der letzten Testläufe können auch über die unteren Einträge im Menü 'Wiedergabe' aufgerufen werden. Das Protokoll öffnet sich in einem separaten Fenster und zeigt die protokollierten Aktionen des zweiten Testfalls, den Sie soeben ausgeführt haben:","hash":"tut_firstRunlogAndroid","h0":"Das Protokoll zur Fehlerdiagnose"},"716":{"id":716,"content":"Abbildung 28.12: Protokoll des zweiten Testfalls Das Protokoll ist in seinem Aufbau ähnlich zu dem der Testsuite. Der Baum links enthält wieder die bekannten Knoten, jedoch dieses Mal in der zeitlichen Abfolge des Testlaufs. Wenn man einen Knoten anwählt, sieht man rechts die Details inklusive Zeitstempel und Ausführungsdauer. Im Baum links werden Ihnen rote Rahmen um einige Knoten auffallen. Diese zeigen an, dass sich darunter Fehler befinden. Wenn man den rot umrandeten Knoten Ebene für Ebene folgt, erreicht man irgendwann den Fehler. Schneller und bequemer geht es über den Button Nächsten Fehler finden in der Werkzeugleiste oder auch die Tastenkombination [Strg-N]. Alle rot markierten Knoten werden expandiert und der Knoten mit dem eigentlichen Fehler wird selektiert:","hash":"fig_firstErrorRunlogAndroid","h4":"Abbildung 28.12: Protokoll des zweiten Testfalls"},"717":{"id":717,"content":"Abbildung 28.13: Fehlerdiagnose für den zweiten Testfall Die Fehlermeldung auf der rechten Seite gibt an, dass der erhaltene Wert des Endpreis Feldes nicht dem erwarteten entspricht. Dieser Fehler wurde natürlich mit Absicht eingebaut, um zu zeigen, wie man bei der Analyse vorgehen kann. Hilfreich bei der Fehleranalyse ist üblicherweise auch der übernächste Protokollknoten Bildschirmabbild. Seine Detailansicht enthält ein vollständiges Abbild des Bildschirms zum Zeitpunkt des Fehlers. Dies ist sehr nützlich, um den Zustand des SUTs zu sehen und daraus eventuell die Fehlerursache ableiten zu können. Die folgende Grafik zeigt den Knoten:","hash":"fig_firstErrorRunlogDetailsAndroid","h4":"Abbildung 28.13: Fehlerdiagnose für den zweiten Testfall"},"718":{"id":718,"content":"Abbildung 28.14: Knoten mit Bildschirmabbild der Fehlersituation Neben dem Abbild aller Bildschirme speichert QF‑Test auch Bilder der einzelnen Fenster des SUT zum Fehlerzeitpunkt. Dies erlaubt Ihnen deren Inhalt zu analysieren, auch wenn diese eigentlich durch andere Fenster oder Dialoge verdeckt sind. Die in einem längeren Testlauf im Protokoll gesammelten Informationen können große Mengen an Arbeitsspeicher verbrauchen. Deshalb ist QF‑Test so voreingestellt, dass es kompakte Protokolle erstellt, wobei nur die für Fehlerdiagnose und Reportgenerierung wichtigen Informationen erhalten bleiben. Diese Funktion ist mit der Option \"Kompakte Protokolle erstellen\" über »Bearbeiten«-»Optionen...«-»Protokoll«-»Inhalt« konfigurierbar. Der Typ eines Protokolls wird in seinem Wurzelknoten angezeigt. Auch die Anzahl der Bildschirmabbilder, die im Protokoll gespeichert werden, ist konfigurierbar.","hash":"fig_firstErrorRunlogScreenshotAndroid","h4":"Abbildung 28.14: Knoten mit Bildschirmabbild der Fehlersituation"},"719":{"id":719,"content":"Pro Tutorial","hash":"","h0":"Wo finde ich Hilfe? | QF‑Test Tutorial"},"720":{"id":720,"content":"Pro Tutorial","hash":"home-link","h0":"Wo finde ich Hilfe? | QF‑Test Tutorial"},"721":{"id":721,"content":"Wo finde ich Hilfe? In diesem Abschnitt machen wir eine kleine Pause, um einige allgemeine Hinweise zu geben. Es gibt verschiedene Möglichkeiten, um Hilfe oder Antworten zu finden: Die umfassendste Suche kann man über »Hilfe«-»Online Suche...« anstoßen. Dies bringt Sie auf die Suchfunktionalität unserer Homepage und erlaubt Ihnen die Abfrage aller verfügbarer Dokumentation (Handbuch, Tutorial, Standardbibliothek, Blog und unsere Videos). Die angezeigten Suchergebnisse können passend gefiltert werden. Wenn Sie offline arbeiten und nach einem Thema suchen wollen, können Sie die Offline-Versionen von Handbuch und Tutorial nutzen, die über das »Hilfe« Menü verfügbar sind. QF‑Test bietet eine kontextsensitive Hilfe für alle Baumknoten und deren Detailattribute an. Um diese zu nutzen, klicken Sie einfach mit der rechten Maustaste auf den gewünschten Knoten oder das Attribut in der Detailansicht. Im Kontextmenü wählen Sie dann den Eintrag »Was ist das?« . Dieser bringt Sie direkt zur passenden Referenzbeschreibung ins Handbuch. Neben der Hilfestellung in der Dokumentation haben Sie auch die Möglichkeit unser Support-Team zu kontaktieren. Während Ihrer Evaluationsphase und anschließend als Kunde mit einem gültigen Pflegevertrag können Sie Ihre Fragen direkt an unsere Supportexperten richten über das Support-Formular im QF‑Test Hilfe-Menü »Support-Team kontaktieren« oder direkt über unsere Webseite.","hash":"tut_firsthelpandroid","h0":"Wo finde ich Hilfe?"},"722":{"id":722,"content":"Pro Tutorial","hash":"","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"723":{"id":723,"content":"Pro Tutorial","hash":"home-link","h0":"Beenden der Anwendung | QF‑Test Tutorial"},"724":{"id":724,"content":"Beenden der Anwendung Wir haben noch nicht die Aufräumsequenz angeschaut und wollen dies nun tun: Expandieren Sie den Aufräumen: Demo beenden Knoten.","hash":"tut_firstcleanupandroid","h0":"Beenden der Anwendung"},"725":{"id":725,"content":"Abbildung 28.15: Die Aufräumsequenz Unsere Aufräumsequenz stoppt \"hart\" den Client-Prozess und wartet anschließend, bis sich dieser vollständig beendet hat. Dies ist eine sehr einfache Variante aber für den Moment ausreichend. Wurde der Emulator/Simulator von QF‑Test gestartet wird dieser auch Beendet, wenn der Client-Prozess beendet wurde.","hash":"fig_firstCleanupAndroid","h4":"Abbildung 28.15: Die Aufräumsequenz"},"726":{"id":726,"content":"Pro Tutorial","hash":"","h0":"Ein vollständiger Testlauf | QF‑Test Tutorial"},"727":{"id":727,"content":"Pro Tutorial","hash":"home-link","h0":"Ein vollständiger Testlauf | QF‑Test Tutorial"},"728":{"id":728,"content":"Ein vollständiger Testlauf Nachdem wir uns Schritt für Schritt durch den Testfallsatz gearbeitet haben, wollen wir nun alles in einem Rutsch ausführen. Markieren Sie den Testfallsatz \"Einfache Tests\". Führen Sie ihn aus mittels. Der Testlauf endet mit dem bekannten Fehler. Wenn Sie nun bitte mittels das Protokoll öffnen, sehen Sie, wie QF‑Test den Test abgearbeitet hat.","hash":"tut_firstFullRunAndroid","h0":"Ein vollständiger Testlauf"},"729":{"id":729,"content":"Abbildung 28.16: Das Protokoll des gesamten Testfallsatzes Man sieht, dass die Vorbereitungs- und Aufräumenknoten vor bzw. nach jedem Testfall ausgeführt werden. Dies ist eine Eigenschaft, die diese im Zusammenspiel mit einem Testfallsatzknoten entwickeln. Dadurch wird für jeden Testfall immer ein sauberer Ausgangszustand hergestellt. Das SUT nach jedem Testfall zu beenden ist nicht die eleganteste Art, einen sauberen Ausgangszustand zu erreichen. Elegantere Wege zur Herstellung einer definierten Testausgangssituation und Durchführung der notwendigen Aufräumarbeiten werden in Kapitel (\"Abhängigkeiten: Automatisches Sicherstellen der korrekten Vorbedingungen jedes Testfalles\") dieses Tutorials erklärt.","hash":"fig_androidRunlogFull","h4":"Abbildung 28.16: Das Protokoll des gesamten Testfallsatzes"},"730":{"id":730,"content":"Pro Tutorial","hash":"","h0":"Reportgenerierung | QF‑Test Tutorial"},"731":{"id":731,"content":"Pro Tutorial","hash":"home-link","h0":"Reportgenerierung | QF‑Test Tutorial"},"732":{"id":732,"content":"Reportgenerierung Im Qualitätssicherungsprozess ist es wichtig, Testergebnisse zu dokumentieren und auch zu archivieren. QF‑Test bietet die Möglichkeit, aus Protokollen Testreports zu generieren. Wir wollen dies für das gerade aufgezeichnete Protokoll beispielhaft durchführen. Öffnen Sie bitte das Protokoll und wählen im Menü »Datei«-»Report erstellen...« .","hash":"tut_firstreportandroid","h0":"Reportgenerierung"},"733":{"id":733,"content":"Abbildung 28.17: Auswahldialog für die Reportgenerierung Im ersten Feld können Sie den Dateinamen des Reports festlegen. QF‑Test bietet drei Arten von Reports - HTML, XML und JUnit Format. Das XML-Format können Sie verwenden, wenn Sie die Reports zum Beispiel mit Hilfe eigener XSLT-Stylesheets selbst gestalten wollen. JUnit-Reports erweisen sich als hilfreich, wenn es darum geht, Resultate in Build- oder Testmanagement-Tools zu importieren. Wir wollen uns nun einen einfachen HTML Report zu unserem letzten Testlauf erzeugen lassen. Lassen Sie bitte die vorgegebenen Optionen unverändert. Bestätigen Sie den Reportdialog mit OK. Anschließend sollte sich Ihr Browser automatisch mit einem Ergebnis äquivalent zum folgenden Bild öffnen:","hash":"fig_AndroidReportDialog","h4":"Abbildung 28.17: Auswahldialog für die Reportgenerierung"},"734":{"id":734,"content":"Abbildung 28.18: Ein HTML Report Der Testbericht beginnt mit einer Zusammenfassung mit allgemeinen Systeminformationen im linken Bereich, einer Legende der verwendeten Symbole rechts, einem Überblicks-Tortendiagramm in der Mitte und dem Gesamtergebnis darunter. In unserem Fall bei einem fehlerhaften von zwei ausgeführten Testfällen eine Erfolgsquote von 50%. Auf die Zusammenfassung folgen drei Übersichten: Testsuiten, die in diesem Testlauf ausgeführt wurden. Testsuiten, in denen Fehler aufgetreten sind. Fehler, mit Ihrem genauen Ort und Fehlermeldung Die Reporterstellung in QF‑Test ist ein praktisches Hilfsmittel, um einen Überblick über einen Testlauf zu gewinnen und ein Dokument zu Präsentations- und Archivierungszwecken zu erstellen.","hash":"fig_androidReportHtml","h4":"Abbildung 28.18: Ein HTML Report"},"735":{"id":735,"content":"Pro Tutorial","hash":"","h0":"Erstellen einer eigenen Testsuite (Mobile) | QF‑Test Tutorial"},"736":{"id":736,"content":"Pro Tutorial","hash":"home-link","h0":"Erstellen einer eigenen Testsuite (Mobile) | QF‑Test Tutorial"},"737":{"id":737,"content":"Erstellen einer eigenen Testsuite (Mobile) In diesem Kapitel des Mobile-Tutorials erstellen wir Sequenzen zum Starten und Beenden des SUT, nehmen Aktionen und Checks auf und bauen daraus einen einfachen Testfall.","hash":"sec_mobiletestsuite","h1":"Erstellen einer eigenen Testsuite (Mobile)"},"738":{"id":738,"content":"Pro Tutorial","hash":"","h0":"Starten der Anwendung | QF‑Test Tutorial"},"739":{"id":739,"content":"Pro Tutorial","hash":"home-link","h0":"Starten der Anwendung | QF‑Test Tutorial"},"740":{"id":740,"content":"Starten der Anwendung Zu Beginn muss die zu testende mobile Anwendung direkt aus QF‑Test heraus gestartet werden. Verwenden Sie dazu den Schnellstart-Assistenten. Öffnen Sie eine neue, leere Testsuite über »Datei«-»Neue Testsuite...« . Starten Sie den Schnellstart-Assistenten über das Menü »Extras«-»Schnellstart-Assistent...« .","hash":"tut_quickStartMobile","h0":"Starten der Anwendung"},"741":{"id":741,"content":"Abbildung 29.1: Auswählen der SUT-Art Im Ersten Schritt wählen Sie, ob es sich um eine Android-Anwendung oder eine iOS-Anwendung handelt. Wählen Sie Android-Anwendung oder iOS-Anwendung aus. Drücken Sie Weiter. Bei Auswahl von iOS-Anwendung folgen Sie den spezifischen Schritten zur Auswahl des Geräts und der zu testenden App. Die Carconfig-APP (CarConfig-iOS-Simulator.zip) finden Sie unter ../qftest-10.0.2-pro/demo/ios/ in Ihrer QF‑Test Installation. Bei Auswahl von Android-Anwendung erscheint eine zusätzliche Seite, auf der Sie entscheiden, ob ein Emulator gestartet werden soll oder ob ein echtes Gerät bzw. ein laufender Emulator verwendet werden soll. Wählen Sie zwischen Emulator starten oder Verbindung zu laufendem Emulator/echtem Gerät. Danach wählen Sie den gewünschten Gerätenamen aus der Liste der verfügbaren Geräten aus.","hash":"fig_WizardTypeAndroid","h4":"Abbildung 29.1: Auswählen der SUT-Art"},"742":{"id":742,"content":"Danach wählen Sie den gewünschten Gerätenamen aus der Liste der verfügbaren Geräten aus. Abbildung 29.2: Gerät und App für Android auswählen Beim Auswählen der Android-APK ist zu beachten, dass diese nicht standardmäßig mit QF‑Test ausgeliefert wird. Falls Sie die carconfigAndroid-Demo ausgeführt haben, sollte die App im Verzeichnis ${qftest:dir.user}/android heruntergeladen worden sein, sodass Sie direkt ${qftest:dir.user}/android/CarConfigurator.apk eintragen können. Alternativ können Sie die APK unter https://www.qftest.com/fileadmin/Webdata/pub/android/CarConfigurator.apk herunterladen.","hash":"fig_WizardChooseDeviceAndroid","h4":"Abbildung 29.1: Auswählen der SUT-Art"},"743":{"id":743,"content":"Abbildung 29.3: Gerät und App für Android auswählen Bitte Drücken Sie Fertig, um den Assistenten abzuschließen. Die generierte Startsequenz erscheint in den Extrasequenzen der Testsuite und enthält alle nötigen Schritte, um die App auf dem gewählten Gerät zu starten.","hash":"fig_WizardAndroidDemo","h4":"Abbildung 29.3: Gerät und App für Android auswählen"},"744":{"id":744,"content":"Abbildung 29.4: Generierte Startsequenz Probieren Sie die Startsequenz aus: Wählen Sie den Knoten Vorbereitung: Starte CarConfigurator aus. Drücken Sie oder betätigen Sie einfach die Eingabe Taste. Nun soll die ausgewählte App auf dem Gerät oder Emulator installiert und gestartet werden. Speichern Sie die Testsuite ( oder »Datei«-»Speichern« bzw.Strg⁠+⁠S). Geben Sie z.B. MeineErstenAndroidTests.qft als Namen ein.","hash":"fig_WizardFinalAndroid","h4":"Abbildung 29.4: Generierte Startsequenz"},"745":{"id":745,"content":"Pro Tutorial","hash":"","h0":"Aufnehmen von Aktionen | QF‑Test Tutorial"},"746":{"id":746,"content":"Pro Tutorial","hash":"home-link","h0":"Aufnehmen von Aktionen | QF‑Test Tutorial"},"747":{"id":747,"content":"Aufnehmen von Aktionen Für mobile Anwendungen steht ein spezielles Aufnahmefenster zur Verfügung, das den Bildschirm des echten Geräts oder Emulators wiedergibt. Dieses Fenster ist notwendig, da Aktionen nicht direkt auf dem Gerät oder Emulator aufgezeichnet werden können. Alle Interaktionen werden über dieses Aufzeichnungsfenster durchgeführt und aufgenommen.","hash":"tut_recActionsMobile","h0":"Aufnehmen von Aktionen"},"748":{"id":748,"content":"Abbildung 29.5: Das Aufzeichnungsfenster für Android-Anwendungen Drücken Sie den Aufnahmeknopf im Aufnahmefenster. Warten Sie, bis das Aufnahmefenster geöffnet wird. Klicken Sie im Aufnahmefenster auf das Textfeld für den Benutzernamen und geben Sie über die Tastatur \"tester\" ein. Anschließend klicken Sie im Aufnahmefenster auf das Textfeld für das Passwort und geben Sie über die Tastatur \"tester\" ein. Beenden Sie die Aufnahme über. Die aufgenommene Sequenz erscheint unter Extrasequenzen. Als Sequenzname wird standardmäßig Datum und Zeit der Erstellung verwendet. Dieser kann anschließend in den Details rechts beliebig angepasst werden. Benennen Sie die Sequenz um, z.B. in Login durchführen.","hash":"fig_MobileAppWinRec","h4":"Abbildung 29.5: Das Aufzeichnungsfenster für Android-Anwendungen"},"749":{"id":749,"content":"Die aufgenommene Sequenz erscheint unter Extrasequenzen. Als Sequenzname wird standardmäßig Datum und Zeit der Erstellung verwendet. Dieser kann anschließend in den Details rechts beliebig angepasst werden. Benennen Sie die Sequenz um, z.B. in Login durchführen. Abbildung 29.6: Die aufgenommenen Aktionen können wir am Ende unserer Vorbereitungssequenz einfügen. Um die Komplexität zunächst gering zu halten, fügen wir die Aktionen innerhalb eines Try-Knotens ein. Damit stellen wir sicher, dass kein Fehler ausgelöst wird, falls wir bereits eingeloggt sind.","hash":"fig_FirstRecordedLoginSequenceAndroid","h4":"Abbildung 29.5: Das Aufzeichnungsfenster für Android-Anwendungen"},"750":{"id":750,"content":"Die aufgenommenen Aktionen können wir am Ende unserer Vorbereitungssequenz einfügen. Um die Komplexität zunächst gering zu halten, fügen wir die Aktionen innerhalb eines Try-Knotens ein. Damit stellen wir sicher, dass kein Fehler ausgelöst wird, falls wir bereits eingeloggt sind. Abbildung 29.7: Nun möchten wir eine Reihe von Aktionen aufnehmen: Drücken Sie dazu den Aufnahmeknopf Wählen Sie mit der Maus das Modell Rolo in der Tabelle aus. Wechseln Sie zum Tab Sondermodelle. Wählen Sie dort das Sondermodell Jazz aus. Bestätigen Sie Ihre Auswahl mit OK. Zum Schluss klicken Sie wieder auf den ersten Tab Fahrzeuge. Beenden Sie die Aufnahme, indem Sie zurück zum QF‑Test Fenster wechseln und dort den Knopf für \"Aufnahme beenden\" drücken. Sie finden die aufgenommene Sequenz unter dem \"Extrasequenzen\" Knoten, wie im folgenden Bild dargestellt.","hash":"fig_FirstRecordedLoginSetupSequenceAndroid","h4":"Abbildung 29.5: Das Aufzeichnungsfenster für Android-Anwendungen"},"751":{"id":751,"content":"Abbildung 29.8: Der Baum nach Aufnahme der Sequenz Ändern Sie den Sequenznamen bitte ab zu \"Modell Rolo Jazz wählen\" Öffnen Sie die Sequenz um die enthaltenen Knoten zu sehen. Es sollten die erwarteten Mausklicks sein. Sie sollten sogar in der Lage sein, die angesprochenen Komponenten zuordnen zu können.","hash":"fig_FirstRecordedSequenceAndroid","h4":"Abbildung 29.8: Der Baum nach Aufnahme der Sequenz"},"752":{"id":752,"content":"Abbildung 29.9: Die umbenannte Sequenz Wir wollen nun die aufgenommene Sequenz abspielen. Markieren die Sequenz Modell Rolo Jazz wählen. Drücken Sie Wiedergabe. Sie sollten die exakt gleichen Aktionen sehen, die Sie zuvor aufgenommen haben. Den aufgenommenen Ablauf sollten Sie auch wiederholt ohne Fehler abspielen können. Rechts unten im Fenster der Testsuite sollte \"Beendet: Keine Fehler\" zu sehen sein.","hash":"fig_FirstRecordedSequenceRenamedAndroid","h4":"Abbildung 29.9: Die umbenannte Sequenz"},"753":{"id":753,"content":"Pro Tutorial","hash":"","h0":"Aufnahme von Checks | QF‑Test Tutorial"},"754":{"id":754,"content":"Pro Tutorial","hash":"home-link","h0":"Aufnahme von Checks | QF‑Test Tutorial"},"755":{"id":755,"content":"Aufnahme von Checks Auch Checks werden im Aufnahmefenster durchgeführt. Sie können so z.B. den Text eines Elements oder dessen Sichtbarkeit prüfen. Drücken Sie im Aufnahmefenster den Check aufnehmen-Knopf. Wählen Sie im Aufnahmefenster das Textfeld für die Gesamtkosten aus. Öffnen Sie das Kontextmenü (meist per Rechtsklick) und wählen Sie den Text aus Beenden Sie die Aufnahme mit. Benennen Sie die Sequenz z.B. in Preis prüfen um. Öffnen Sie den Knoten, um den Check zu sehen.","hash":"tut_recChecksMobile","h0":"Aufnahme von Checks"},"756":{"id":756,"content":"Pro Tutorial","hash":"","h0":"Erstellen einer Testsuite | QF‑Test Tutorial"},"757":{"id":757,"content":"Pro Tutorial","hash":"home-link","h0":"Erstellen einer Testsuite | QF‑Test Tutorial"},"758":{"id":758,"content":"Erstellen einer Testsuite Die Basisstruktur unterhalb des Wurzelknotens einer Testsuite ist durch folgende Knoten festgelegt: Eine beliebige Anzahl von \"Testfallsatz\" und \"Testfall\" Knoten, um funktionale Tests zu spezifizieren und zu strukturieren. \"Prozeduren\" - hier können wiederverwertbare Sequenzen in Prozeduren organisiert werden \"Extrasequenzen\" - unsere Spielwiese für Aufnahmen etc. \"Fenster und Komponenten\" - das eigentliche Herz der Testsuite. Hier sind alle aufgenommenen Fenster und Komponenten des SUT mit ihren Eigenschaften enthalten Funktionale Testfälle werden durch \"Testfall\" Knoten repräsentiert und mittels \"Testfallsatz\" Knoten gruppiert bzw. strukturiert. \"Vorbereitung\" und \"Aufräumen\" Knoten können Aktionen enthalten, um einen wohldefinierten Zustand vor und nach einem Testfall sicherzustellen. Wir beginnen mit dem Umbenennen des \"Testfallsatz\" Knotens von \"unbenannt\" in \"Demo Tests\". Falls ein Dialog bzgl. der Aktualisierung von Verweisen erscheint, können wir diesen einfach mit \"Ja\" beantworten. Der nächste Schritt ist, den vom Schnellstart-Assistenten erzeugten Knoten \"Vorbereitung\" in den \"Testfallsatz\" zu verschieben und zwar an die erste Position vor den enthaltenen Testfall. Das Verschieben kann mit Hilfe der Maus (Drag&Drop), des Kontextmenüs (rechte Maustaste Ausschneiden/Einfügen) oder der Tastenkombination Strg⁠+⁠X und Strg⁠+⁠V durchgeführt werden.","hash":"tut_buildtestandroid","h0":"Erstellen einer Testsuite"},"759":{"id":759,"content":"Abbildung 29.10: Beginn der Strukturierung Als Nächstes gilt es, aus den beiden vorher aufgezeichneten Sequenzen einen Testfall zu machen. Benennen Sie dazu den Testfall Knoten von \"unbenannt\" in \"Erster\" um. Öffnen Sie den Testfall Knoten durch einen Klick auf das '>' Symbol. Verschieben Sie die beiden Sequenzen aus den \"Extrasequenzen\" in den Testfall. Wenn Sie den Testfall Knoten nicht öffnen, versucht QF‑Test die Sequenzknoten hinter dem Testfall Knoten auf der gleichen Ebene einzufügen. Dies ist jedoch für Sequenzknoten nicht zulässig. QF‑Test nimmt immer Sequenzen auf. Diese haben die gleiche Funktion wie Testschritte. Testschritte werden jedoch im Bericht aufgeführt. Man kann sie ineinander umwandeln, was wir Ihnen in den nächsten Schritten informationshalber zeigen wollen. Öffnen Sie das Kontextmenü für den ersten der beiden Sequenzknoten mit der rechten Maustaste. Wählen Sie »Knoten konvertieren in...«-»Testschritt« Führen Sie dasselbe für den zweiten Sequenzknoten durch.","hash":"fig_beginbuildatest_mobile","h4":"Abbildung 29.10: Beginn der Strukturierung"},"760":{"id":760,"content":"Abbildung 29.11: Der Baum nach der Neustrukturierung Bei Android und iOS kann man das beenden des Emulators/Simulators nich aufgenommen werden. Stattdessen arbeitet man mit einen Programm Beenden-Knoten.","hash":"fig_buildatest_mobile","h4":"Abbildung 29.11: Der Baum nach der Neustrukturierung"},"761":{"id":761,"content":"Bei Android und iOS kann man das beenden des Emulators/Simulators nich aufgenommen werden. Stattdessen arbeitet man mit einen Programm Beenden-Knoten. Abbildung 29.12: Damit haben wir die wichtigsten Schritte zur Strukturierung unserer Testsuite abgeschlossen.","hash":"fig_FirstCleanupAndroid","h4":"Abbildung 29.11: Der Baum nach der Neustrukturierung"},"762":{"id":762,"content":"Pro Tutorial","hash":"","h0":"Eine Prozedur erstellen (Mobile) | QF‑Test Tutorial"},"763":{"id":763,"content":"Pro Tutorial","hash":"home-link","h0":"Eine Prozedur erstellen (Mobile) | QF‑Test Tutorial"},"764":{"id":764,"content":"Eine Prozedur erstellen (Mobile) In den beiden vorherigen Kapiteln haben Sie gelernt wie man eine Applikation über QF‑Test startet, so dass Maus- und Tastatureingaben aufgenommen werden können, auch wie man Checks aufnimmt und wie man das Ergebnis zu einem Testfall zusammenfasst. Diese Herangehensweise ist ausreichend, solange die Tests einfach und nicht allzu viele sind. Sobald jedoch die Zahl der Tests zunimmt, ist es wichtig, sogenannte \"Prozeduren\" einzusetzen. Prozeduren sind ein Mittel um Sequenzen wiederverwendbar zu machen und damit Doppelvorkommen zu vermeiden. Dies ist wichtig, um eine einfache und effiziente Wartbarkeit von Tests über die Zeit zu erreichen. Prozeduren können in Packages gruppiert werden. Prozeduren und Packages sind die Basis für die Modularisierung der Tests.","hash":"sec_FirstProzedurMobile","h1":"Eine Prozedur erstellen (Mobile)"},"765":{"id":765,"content":"Pro Tutorial","hash":"","h0":"Wiederverwendbare Abschnitte identifizieren | QF‑Test Tutorial"},"766":{"id":766,"content":"Pro Tutorial","hash":"home-link","h0":"Wiederverwendbare Abschnitte identifizieren | QF‑Test Tutorial"},"767":{"id":767,"content":"Wiederverwendbare Abschnitte identifizieren In diesem Abschnitt werden wir die Testsuite ErsteAndroidTests.qft, die Sie bereits aus Kapitel 19 kennen, weiterentwickeln. Kopieren Sie ErsteAndroidTests.qft aus dem Unterverzeichnis qftest-10.0.2-pro/doc/tutorial der QF‑Test Installation in ein Arbeitsverzeichnis und öffnen Sie ErsteAndroidTests.qft. Wenn Sie die Änderung, die wir an der Demo-Testsuite vornehmen werden, sichern wollen, so speichern Sie diese in einem Arbeitsverzeichnis wie am Ende von \"Starten der Anwendung\" beschrieben. Bitte sehen Sie sich den Testschritt \"Zurücksetzen\" in den beiden Testfällen an. Die beiden Testschritte sind identisch.","hash":"tut_procreusemobile","h0":"Wiederverwendbare Abschnitte identifizieren"},"768":{"id":768,"content":"Abbildung 30.1: Zwei identische Testschritte Gemäß obiger Überlegungen wäre es also sinnvoll, den Testschritt in eine Prozedur umzuwandeln.","hash":"IdenticalTeststepsAndroid","h4":"Abbildung 30.1: Zwei identische Testschritte"},"769":{"id":769,"content":"Pro Tutorial","hash":"","h0":"Manuelle Erstellung von Prozeduren | QF‑Test Tutorial"},"770":{"id":770,"content":"Pro Tutorial","hash":"home-link","h0":"Manuelle Erstellung von Prozeduren | QF‑Test Tutorial"},"771":{"id":771,"content":"Manuelle Erstellung von Prozeduren Es gibt mehrere Methoden Prozeduren zu erstellen und Prozeduraufrufe einzufügen. Wir fangen mit der manuellen an, bei der ein (leerer) Prozedurknoten eingefügt wird, in den dann die entsprechenden Aktionen verschoben werden. Danach erstellen wir den zugehörigen Prozeduraufruf. Es ist gut, wenn man diese grundlegenden Schritte kennt. Es gibt jedoch eine zweite, elegantere Methode Prozeduren zu erstellen, die wir im Anschluss zeigen werden. Also los, fügen wir eine Prozedur von Hand ein: Wir beginnen mit dem Anlegen des Prozedurknotens, dem wir einen geeigneten Namen geben. Öffnen Sie den Prozedur Knoten und achten Sie darauf, dass er auch selektiert (blau markiert) ist. Wählen Sie »Einfügen«-»Prozedurknoten«-»Prozedur«. Tragen Sie als Name \"zurücksetzen\" ein. Die anderen Felder brauchen nicht befüllt zu werden. Drücken Sie OK um die Erstellung der Prozedur abzuschließen. Öffnen Sie die neu erstellte \"zurücksetzen\" Prozedur.","hash":"tut_procmanualmobile","h0":"Manuelle Erstellung von Prozeduren"},"772":{"id":772,"content":"Abbildung 30.2: Prozedurknoten erstellen Im zweiten Schritt befüllen wir die Prozedur mit den entsprechenden wiederverwendbaren Aktionen. Selektieren Sie die drei \"Mausklick\" Knoten im Testschritt. Um mehr als einen Knoten zu selektieren, klicken Sie den ersten der Knoten an, dann drücken Sie die Shift Taste und klicken den letzten der zu selektierenden Knoten während Sie die Shift Taste gedrückt halten. Verschieben Sie diese nach unten in die Prozedur, z.B. mit der Maus (Drag and drop) oder über Ausschneiden/Einfügen im Menü »Bearbeiten« oder über das Kontextmenü.","hash":"ProcedureNodeInFirstTestcaseAndroid","h4":"Abbildung 30.2: Prozedurknoten erstellen"},"773":{"id":773,"content":"Abbildung 30.3: Prozedur mit Inhalt befüllen Im dritten Schritt fügen wir einen Prozeduraufruf an Stelle der drei verschobenen Mausklicks ein. Selektieren Sie den Testschritt \"Zurücksetzen\", der geöffnet sein sollte. Wählen Sie den Menüpunkt »Einfügen«-»Prozedurknoten«-»Prozeduraufruf« oder verwenden Sie das Tastaturkürzel Strg⁠+⁠A.","hash":"procedureContentInFirstTestcaseAndroid","h4":"Abbildung 30.3: Prozedur mit Inhalt befüllen"},"774":{"id":774,"content":"Abbildung 30.4: Prozeduraufruf einfügen Drücken Sie den Prozedur-Auswahlknopf in dem Dialog links neben der Beschriftung \"Name der Prozedur\". Wählen Sie \"zurücksetzen\" aus der Prozedurliste. Weitere Eingaben sind nicht nötig. Drücken Sie OK in beiden Dialogen um die Erstellung des Prozeduraufrufs abzuschließen.","hash":"AddProcedureCallAndroid","h4":"Abbildung 30.4: Prozeduraufruf einfügen"},"775":{"id":775,"content":"Abbildung 30.5: Prozedur auswählen Um wirklich einen Mehrwert durch die Prozedur zu erlangen, müssen wir nun den Inhalt des Testschritts im zweiten Testfall ebenfalls durch einen Aufruf der Prozedur \"zurücksetzen\" ersetzen. Sie können dies wie oben beschrieben tun oder Sie führen folgende alternative Schritte zur Erstellung des Prozeduraufrufs aus: Öffnen Sie den Testschritt 'Zurücksetzen' des zweiten Testfalls. Löschen Sie die drei Mausklick Knoten daraus. Selektieren Sie den Prozedurknoten \"zurücksetzen\". Ziehen Sie den Prozedurknoten \"zurücksetzen\" mit der Maus in den Testschrittknoten. Kopieren/einfügen kann ebenfalls verwendet werden. Dadurch wird der Prozedurknoten nicht verschoben, sondern ein entsprechender Prozeduraufruf erzeugt. Die Testsuite sollte anschließend wie folgt aussehen:","hash":"SelectProcedureAndroid","h4":"Abbildung 30.5: Prozedur auswählen"},"776":{"id":776,"content":"Abbildung 30.6: Testsuite mit Prozedur Wenn Sie nun die Testfälle ausführen, sollten diese funktionieren wie zuvor. Im Protokoll sind jetzt auch die Prozeduraufrufe und deren Ausführung zu sehen.","hash":"fig_testsuite_with_Procedure_android","h4":"Abbildung 30.6: Testsuite mit Prozedur"},"777":{"id":777,"content":"Pro Tutorial","hash":"","h0":"Knoten in Prozedur konvertieren | QF‑Test Tutorial"},"778":{"id":778,"content":"Pro Tutorial","hash":"home-link","h0":"Knoten in Prozedur konvertieren | QF‑Test Tutorial"},"779":{"id":779,"content":"Knoten in Prozedur konvertieren Wie bereits am Anfang des letzten Abschnitts erwähnt, bietet QF‑Test eine Alternative um Prozeduren wesentlich schneller zu erstellen. Markieren Sie den Testschritt oder Sequenz-Knoten, der die wiederverwendbaren Schritte enthält, die zur Prozedur umgewandelt werden sollen. Wählen Sie den Menüpunkt »Operationen«-»Knoten konvertieren in«-»Prozedur« aus oder verwenden Sie das Tastaturkürzel Strg⁠+⁠Umschalt⁠+⁠P. Wie Sie sehen, ist der Testschritt bzw. der Sequenzknoten verschwunden. Anstelle dessen befindet sich ein Prozeduraufruf. Außerdem wurde eine Prozedur mit dem Namen des ehemaligen Testschritts bzw. der Sequenz im Abschnitt \"Prozeduren\" erstellt. Sie enthält genau die gleichen Kindknoten wie zuvor der Testschritt bzw. die Sequenz. Bei der Aufnahme einer Sequenz in QF‑Test hat sich das Vorgehen bewährt, der Sequenz sofort einen Namen zu geben und sie anschließend in eine Prozedur zu konvertieren. Auch wenn man nur eine Vermutung hat, dass sich die aufgenommenen Schritte irgendwo wiederholen könnten.","hash":"tut_proctransformmobile","h0":"Knoten in Prozedur konvertieren"},"780":{"id":780,"content":"Pro Tutorial","hash":"","h0":"Komponenten (Mobile) | QF‑Test Tutorial"},"781":{"id":781,"content":"Pro Tutorial","hash":"home-link","h0":"Komponenten (Mobile) | QF‑Test Tutorial"},"782":{"id":782,"content":"Komponenten (Mobile) QF‑Test speichert die Informationen, wie es die im GUI des SUT angezeigten Komponenten wiederfindet, im Bereich Fenster und Komponenten ab. Dabei analysiert QF‑Test bei der Aufnahme die erhaltenen GUI-Element-Informationen und speichert diejenigen, mit denen der Anwender interagiert hat, in den Details der Komponente Knoten ab. Ausführliche Informationen zum Thema Komponenten finden Sie im Handbuchkapitel Komponenten In diesen Kapitel möchten wir Ihnen zeigen, wie Unterelemente von Komponenten wie Tabellen, Bäumen und Listen adressiert werden.","hash":"sec_ComplexComponentsMobile","h1":"Komponenten (Mobile)"},"783":{"id":783,"content":"Pro Tutorial","hash":"","h0":"Adressierung von Unterelementen von Tabellen und Listen | QF‑Test Tutorial"},"784":{"id":784,"content":"Pro Tutorial","hash":"home-link","h0":"Adressierung von Unterelementen von Tabellen und Listen | QF‑Test Tutorial"},"785":{"id":785,"content":"Adressierung von Unterelementen von Tabellen und Listen Unterelemente von Tabellen und Listen werden über Indizes angesprochen. Die beiden wichtigsten Indextypen sind der numerische Index und der Textindex. Zur Demonstration nehmen wir als Nächstes einen Mausklick auf einen Listeneintrag auf und sehen uns die aufgenommene QF‑Test-ID der Komponente genauer an. Starten Sie das CarConfig Demo, falls dieses nicht bereits läuft. Führen Sie dazu den Vorbereitung Knoten in der Testsuite aus. Aktivieren Sie den Aufnahmemodus über \"Aufnahme starten\" . Klicken Sie auf einen Listeintrag, z.B. das erste Modell. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Den aufgenommenen Mausklick finden Sie im Bereich Extrasequenzen.","hash":"sec_addressing_complex_components_mobile","h0":"Adressierung von Unterelementen von Tabellen und Listen"},"786":{"id":786,"content":"Abbildung 31.1: Adressierung eines Listeintrages Die aufgenommene QF‑Test ID der Komponente ist action_bar_root.list@Rolo. Sie setzt sich aus den folgenden Teilen zusammen: action_bar_root.list ist die QF‑Test ID der Komponente der Liste selbst. @ trennt den Index von der QF‑Test component ID. Gleichzeitig definiert es den Typ des darauf folgenden Index als Text. Rolo ist der Textindex für den Listeintrag mit dem Text 'Rolo'. Alternativ kann man & nutzen, um einen numerischen Index zu nutzen. &0 würde den ersten Listeneintrag angeben. Numerische Indizes beginnen immer mit 0. Tabellen werden analog zu Listen adressiert, allerdings besitzen sie einen zusätzlichen Index, um die Spalte zu adressieren. VehicleTable@Modell&0 adressiert in der Tabelle VehicleTable die Spalte mit dem Textindex Modell und die Zeile mithilfe des numerischen Index 0. Dies ist jedoch nur ein Beispiel und kann in der Android-Demo nicht ausprobiert werden, da es innerhalb der App keine Tabelle gibt.","hash":"fig_ComponentsListIndexMobile","h4":"Abbildung 31.1: Adressierung eines Listeintrages"},"787":{"id":787,"content":"Pro Tutorial","hash":"","h0":"SmartIDs - direkte Komponentenadressierung | QF‑Test Tutorial"},"788":{"id":788,"content":"Pro Tutorial","hash":"home-link","h0":"SmartIDs - direkte Komponentenadressierung | QF‑Test Tutorial"},"789":{"id":789,"content":"SmartIDs - direkte Komponentenadressierung Seit QF‑Test 7.0 bieten SmartIDs offiziell die Möglichkeit, Komponenten ohne Aufnahme eines Komponente Knoten zu referenzieren. Für gewisse Anwendungen kann dies die Verwaltung und Pflege der Komponenteninformationen stark vereinfachen. Auch auf die Editier- und Lesbarkeit der Tests können SmartIDs positiven Einfluss haben. Nicht zuletzt bietet dies die Möglichkeit, Tests auch ohne Aufnahmefunktion zu erstellen, zum Beispiel, wenn eine Komponente oder die gesamte Anwendung noch gar nicht vorhanden ist, man den Test aber bereits implementieren möchte (\"Test first\" Ansatz). Als Wiedererkennungskriterien stehen die Komponentenklasse, deren Name oder Beschriftung und der Index zur Verfügung. Die Werte sind die gleichen wie beim aufgenommenen Komponente Knoten. Zudem können auch Komponentenhierarchien abgebildet werden. Eine SmartID wird an Stelle der QF‑Test ID der Komponente verwendet. Ihr Kennzeichen ist die Raute # als erstes Zeichen. Anschließend kann der Name oder die Beschriftung der Komponente geschrieben werden, zum Beispiel: Details und Beispiele finden Sie im Handbuchkapitel SmartID","hash":"sec_components_smartid_android","h0":"SmartIDs - direkte Komponentenadressierung"},"790":{"id":790,"content":"Pro Tutorial","hash":"","h0":"Benutzen des Debuggers (Mobile) | QF‑Test Tutorial"},"791":{"id":791,"content":"Pro Tutorial","hash":"home-link","h0":"Benutzen des Debuggers (Mobile) | QF‑Test Tutorial"},"792":{"id":792,"content":"Benutzen des Debuggers (Mobile) Dieses Kapitel ist auch als Video verfügbar unter 'Benutzen des Debuggers'. In diesem Kapitel lernen Sie, wie der in QF‑Test integrierte intuitive Debugger benutzt wird. Diejenigen unter Ihnen, die bereits Erfahrungen mit anderen IDEs, wie z.B. Eclipse haben, werden hier Ähnlichkeiten in Funktion und Nutzen des Debuggers feststellen. Wir werden uns mit den folgenden Debugger-Funktionen beschäftigen: Setzen eines Breakpoints mittels Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B). Testausführung pausieren mittels Pausetaste oder der Tastenkombination für das Unterbrechen der Wiedergabe (\"Keine Panik\"-Taste) Alt⁠+⁠F12. Schrittweise Ausführung mittels \"Einzelschritt ausführen\" , \"Gesamten Knoten ausführen\" und \"Bis Knotenende ausführen\" . Knoten überspringen mittels \"Knoten überspringen\" und \"Aus Knoten herausspringen\" . Debug-Modus bei Fehler oder Exception aktivieren. Fehlerbehebung aus dem Protokoll heraus. Den aktuellen Fehler im Protokoll direkt anspringen über Strg⁠+⁠J. (Ins Protokoll springen in Kapitel \"Fehlerbehebung aus dem Protokoll heraus\"). Anstatt über die Schaltflächen können die Befehle auch über die Menüzeile oder Tastaturkürzel abgesetzt werden. Die Kürzel stehen neben den Optionen in den QF‑Test Menüs, sofern vorhanden. Eine vollständige Übersicht der von QF‑Test verwendeten Tastaturkürzel finden Sie im Anhang Tastaturkürzel im Handbuch. Dort findet sich auch ein kleiner Helfer für die Funktionstastenbelegung von QF‑Test zum Befestigen an der Tastatur. Es gibt noch einige weitere Debugger-Funktionen wie \"Aktuellen Knoten finden\" (Aktuellen Knoten finden in \"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle\"), \"Ausführung hier fortsetzen\" über das Popup-Menü des entsprechenden Knotens (\"Ausführung hier fortsetzen\"), die \"Exception erneut werfen\" , die Tabelle der Variablendefinitionen (\"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle\"), auf die wir in späteren Kapiteln eingehen werden.","hash":"sec_DebuggerAndroid","h1":"Benutzen des Debuggers (Mobile)"},"793":{"id":793,"content":"Pro Tutorial","hash":"","h0":"Setzen eines Breakpoints | QF‑Test Tutorial"},"794":{"id":794,"content":"Pro Tutorial","hash":"home-link","h0":"Setzen eines Breakpoints | QF‑Test Tutorial"},"795":{"id":795,"content":"Setzen eines Breakpoints Zunächst einmal soll der Debugger aktiviert werden. Dies kann auf mehrere Arten erfolgen, zum Beispiel durch das Setzen eines Haltepunktes (Breakpoint) vor Start des Testlaufs. Der Zweck eines Haltepunktes ist es, den Testlauf an einer Stelle, die man näher untersuchen möchte, zu unterbrechen. Sobald QF‑Test auf den Breakpoint trifft, wird die Testausführung pausiert und der Debugger-Modus aktiviert. Der Pauseknopf ist nun gedrückt. Selektieren Sie einen Knoten und drücken Sie Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B). Der Haltepunkt wird durch das Symbol kenntlich gemacht.","hash":"tut_breakpointsmobile","h0":"Setzen eines Breakpoints"},"796":{"id":796,"content":"Abbildung 32.1: Breakpoint setzen Selektieren Sie den Testsuite Knoten und starten Sie den Testlauf über die Taste Enter.","hash":"fig_DebugSetBreakpointAndroid","h4":"Abbildung 32.1: Breakpoint setzen"},"797":{"id":797,"content":"Abbildung 32.2: Testlauf starten Löschen Sie den Breakpoint wieder, indem Sie nochmals Strg⁠+⁠F8 (auf macOS: ⇧⁠+⁠⌘⁠+⁠B) drücken.","hash":"fig_DebugStartTestRunAndroid","h4":"Abbildung 32.2: Testlauf starten"},"798":{"id":798,"content":"Abbildung 32.3: Breakpoint löschen Man kann einen Breakpoint nicht nur über das Tastaturkürzel Strg⁠+⁠F8 sondern auch über den Menüpunkt »Debugger«-»Breakpoint an/aus« oder alternativ durch Rechtsklick auf den Knoten und Auswahl von »Breakpoint an/aus« im Popup-Menü setzen bzw. löschen. Für die weiteren Debugger-Funktionen werden wir hauptsächlich die jeweiligen Schaltflächen nennen, aber auch hier stehen die anderen Varianten zur Verfügung. Wieder sehen Sie den kleinen Pfeil, der diesmal anzeigt, welcher Knoten als nächster ausgeführt wird. Dieser Knoten wird aktueller Knoten genannt. Bei der Aktivierung des Debug-Modus navigiert QF‑Test zum aktuellen Knoten, falls dieser nicht bereits sichtbar ist, und selektiert diesen, d.h. die Zeile wird blau hinterlegt. Das Kommando »Debugger«-»Alle Breakpoints löschen« ist ebenfalls nützlich, wenn alle Haltepunkte in allen geöffneten Testsuiten gelöscht werden sollen. Es gibt keine Beschränkung für die Anzahl an Breakpoints, die Sie in Ihrer Testsuite setzen können. Haltepunkte werden beim Schließen der Testsuite nicht mit abgespeichert.","hash":"fig_DebugRemoveBreakpointAndroid","h4":"Abbildung 32.3: Breakpoint löschen"},"799":{"id":799,"content":"Pro Tutorial","hash":"","h0":"Schrittweise Ausführung | QF‑Test Tutorial"},"800":{"id":800,"content":"Pro Tutorial","hash":"home-link","h0":"Schrittweise Ausführung | QF‑Test Tutorial"},"801":{"id":801,"content":"Schrittweise Ausführung Nun wollen wir die Testfälle schrittweise ausführen. Bitte experimentieren Sie ein wenig mit \"Einzelschritt ausführen\" , \"Gesamten Knoten ausführen\" und \"Bis Knotenende ausführen\" . Wie Sie sicher festgestellt haben werden, öffnet \"Einzelschritt ausführen\" einen Knoten mit Kindern und macht den ersten Kindknoten zum aktiven Knoten. Dies ist wie immer an der Pfeilmarkierung des Knotens erkennbar. Wenn Sie an dem Punkt weitergemacht haben, an dem die Ausführung der Testsuite im letzten Abschnitt pausiert war, d.h. vom Knoten \"Testfall: Erster\" aus, so würde nun der Testfall geöffnet werden:","hash":"tut_debug_steps_mobile","h0":"Schrittweise Ausführung"},"802":{"id":802,"content":"Abbildung 32.4: Einzelschritt ausführen Im Falle eines Blattknotens, d.h. eines Knotens, der keine Kinder hat, ist die Wirkung die gleiche wie die der folgenden Funktion. Mittels der Schaltfläche \"Gesamten Knoten ausführen\" wird ein Knoten inklusive aller Kindknoten ausgeführt. Der als nächstes auszuführende Knoten auf der gleichen Ebene wird dann der aktive und erhält den Pfeil.","hash":"fig_StepInExampleAndroid","h4":"Abbildung 32.4: Einzelschritt ausführen"},"803":{"id":803,"content":"Abbildung 32.5: Gesamten Knoten ausführen \"Bis Knotenende ausführen\" führt die verbleibenden Geschwisterknoten aus und stoppt beim nächsten auszuführenden Knoten der übergeordneten Hierarchieebene.","hash":"fig_StepOverExampleAndroid","h4":"Abbildung 32.5: Gesamten Knoten ausführen"},"804":{"id":804,"content":"Abbildung 32.6: Bis Knotenende ausführen Im Beispiel ist dies der Aufräumen Knoten. Wie bereits im ersten Kapitel Ein vollständiger Testlauf erläutert, haben Vorbereitung und Aufräumen Knoten die besondere Eigenschaft, dass sie vor und nach jedem Testfall ausgeführt werden, um so einen definierten Anfangszustand für jeden Testfall herzustellen. Dieses Verhalten tritt nur auf, wenn Sie die komplette Testsuite oder den Testfallsatz gestartet hatten und sich im Debug-Modus befinden. Wenn keine Testausführung aktiv war und Sie nur den Testfall selektiert hatten, so bewirkt die Funktion \"Gesamten Knoten ausführen\", dass der Testfall ausgeführt wird und dann der nächste Testfall selektiert wird. Führen Sie die Aufräumen und Vorbereitung Knoten aus, indem Sie mit Hilfe der Schaltfläche die gesamten Knoten ausführen und dann über den zweiten Testfall öffnen. Dies ist eine Vorbereitung für das nächste Kapitel, in dem es um das Überspringen von Knoten geht. Bitte beachten Sie bei der interaktiven Testerstellung bei Menüs und Comboboxen, dass diese häufig zuklappen, wenn die Applikation den Fokus verliert, was beim Wechsel in den Debug-Modus der Fall ist. In diesem Fall empfiehlt es sich, den Knoten, der ein Menü oder eine Combobox öffnet, und den Knoten, der die Auswahlaktion durchführt, gemeinsam auszuführen, also nicht zwischendurch in den Debug-Modus zu gehen. Dies kann man zum Beispiel dadurch erreichen, dass man nach dem Knoten, der die Auswahlaktion durchführt, einen Haltepunkt setzt und bei Erreichen des Knotens, der das Menü oder die Combobox öffnet, die Testausführung durch Lösen der Pausetaste freigibt.","hash":"fig_StepOutExampleAndroid","h4":"Abbildung 32.6: Bis Knotenende ausführen"},"805":{"id":805,"content":"Pro Tutorial","hash":"","h0":"Knoten überspringen | QF‑Test Tutorial"},"806":{"id":806,"content":"Pro Tutorial","hash":"home-link","h0":"Knoten überspringen | QF‑Test Tutorial"},"807":{"id":807,"content":"Knoten überspringen Die \"Überspringen\" Funktionen erweitern die Fähigkeiten des Debuggers von QF‑Test in einer Weise, die über den Funktionsumfang von Standardprogrammierumgebungen hinausgeht. Wie der Name andeutet, erlauben die \"Überspringen\" Operationen einen oder mehrere Knoten während des Testlaufs auszulassen, d.h. weiter zu springen ohne diese auszuführen. Dies kann aus verschiedensten Gründen sinnvoll sein. Sei es um schnell an eine gewisse Position in Ihrem Testablauf zu gelangen oder um einen aktuell zu einem Fehler führenden Knoten zu überspringen. Am Schluss des letzten Abschnitts haben wir den ersten Testschritt im zweiten Testfall zum aktiven Knoten gemacht. Dies ist er Ausgangspunkt für unsere nächste Aktion:","hash":"tut_skip_steps_mobile","h0":"Knoten überspringen"},"808":{"id":808,"content":"Abbildung 32.7: Testausführung am ersten Knoten des zweiten Testfalls pausiert Drücken Sie nun die Schaltfläche \"Knoten überspringen\" . QF‑Test springt einfach über den aktiven Knoten ohne ihn oder seine Kindknoten auszuführen. Anschließend pausiert QF‑Test beim nächsten auszuführenden Knoten auf der gleichen Ebene.","hash":"fig_DebugSkipOverInitialStateAndroid","h4":"Abbildung 32.7: Testausführung am ersten Knoten des zweiten Testfalls pausiert"},"809":{"id":809,"content":"Abbildung 32.8: \"Knoten überspringen\" Und zuletzt die Schaltfläche \"Aus Knoten herausspringen\" . Sie sehen sofort, dass QF‑Test aus dem Knoten, in dem Sie sich befinden, herausspringt ohne weitere Kindknoten auszuführen.","hash":"fig_DebugSkipOverAndroid","h4":"Abbildung 32.8: \"Knoten überspringen\""},"810":{"id":810,"content":"Abbildung 32.9: \"Aus Knoten herausspringen\" Noch eine Bemerkung zu \"Knoten überspringen\" und \"Aus Knoten herausspringen\": Benutzen Sie diese mit Vorsicht! Aus einer Sequenz herauszuspringen, bevor diese zu Ende gelaufen ist, kann dazu führen, dass Ihr SUT in einem Status belassen wird, mit dem andere Sequenzen oder Tests in der Suite nicht aufsetzen können.","hash":"fig_DebugSkipOutAndroid","h4":"Abbildung 32.9: \"Aus Knoten herausspringen\""},"811":{"id":811,"content":"Pro Tutorial","hash":"","h0":"Debug-Modus bei Fehler oder Exception aktivieren | QF‑Test Tutorial"},"812":{"id":812,"content":"Pro Tutorial","hash":"home-link","h0":"Debug-Modus bei Fehler oder Exception aktivieren | QF‑Test Tutorial"},"813":{"id":813,"content":"Debug-Modus bei Fehler oder Exception aktivieren Beim Debuggen eines Tests ist es oft hilfreich, wenn die Testausführung genau dann stoppt und in den Debug-Modus gewechselt wird, wenn ein Fehler, eine Exception oder manchmal auch nur eine Warnung auftritt. Mittels dieser Technik werden wir in diesem Abschnitt und dem nächsten den zweiten Testfall debuggen. Bitte öffnen Sie das Debugger-Menü und ändern Sie die Standardeinstellungen wie folgt: Klicken Sie auf den Menüpunkt »Debugger«-»Debugger aktivieren« um ihn zu aktivieren. Klicken Sie auf den Untermenüpunkt »Debugger«-»Optionen«-»Unterbrechen bei Fehler« um auch diese Funktion zu aktivieren. Wenn Sie nun das Debugger-Menü und das Optionen-Untermenü wieder öffnen sollte es wie folgt aussehen:","hash":"tut_debug_start_mobile","h0":"Debug-Modus bei Fehler oder Exception aktivieren"},"814":{"id":814,"content":"Abbildung 32.10: Debugger-Optionen: Test bei Fehler anhalten Wir müssen die Debugger-Optionen ändern, da sonst der Test einfach durchlaufen würde, analog zu den vorherigen Beispielen aus Kapitel eins und zwei. Selektieren Sie den Testsuite Knoten und starten Sie anschließend den Test mittels \"Wiedergabe starten\" . QF‑Test hält bei dem fehlerhaften Knoten an und wechselt in den Debug-Modus:","hash":"fig_debugger_stops_at_error_mobile","h4":"Abbildung 32.10: Debugger-Optionen: Test bei Fehler anhalten"},"815":{"id":815,"content":"Abbildung 32.11: QF‑Test pausiert bei Fehler Der Knoten, der den Fehler verursacht hat, wird durch ein rotes Quadrat markiert. Außerdem erscheint ein Fehlerdialog, der uns Näheres zur Fehlerursache mitteilt. Über diesen wechseln wir in das Protokoll, das wie so oft der Schlüssel zur Fehlerbehebung ist.","hash":"fig_debugger_stopped_by_error_mobile","h4":"Abbildung 32.11: QF‑Test pausiert bei Fehler"},"816":{"id":816,"content":"Abbildung 32.12: Fehlermeldung Klicken Sie auf die Schaltfläche In Protokoll springen der Fehlermeldung.","hash":"debug_error_dialog_mobile","h4":"Abbildung 32.12: Fehlermeldung"},"817":{"id":817,"content":"Pro Tutorial","hash":"","h0":"Fehlerbehebung aus dem Protokoll heraus | QF‑Test Tutorial"},"818":{"id":818,"content":"Pro Tutorial","hash":"home-link","h0":"Fehlerbehebung aus dem Protokoll heraus | QF‑Test Tutorial"},"819":{"id":819,"content":"Fehlerbehebung aus dem Protokoll heraus Über die Schaltfläche In Protokoll springen (siehe Fehlermeldung in Abbildung \"Fehlermeldung\") wird das Protokoll direkt bei dem entsprechenden Knoten geöffnet. Neben der eigentlichen Fehlermeldung wurden etliche weitere Informationen zur Testumgebung zum Zeitpunkt des Fehlers protokolliert. Neben Bildschirmabbildern zum Fehlerzeitpunkt enthält das Protokoll unter dem Knoten, der den Fehler verursachte, eine Liste der gebundenen Variablen (Stacktrace). Auf die Nützlichkeit des Stacktrace werden wir zu einem späteren Zeitpunkt eingehen (Die Variablendefinitionen-Tabelle). Beim vorliegenden Fehler wird der falsche Wert im Check Text Knoten der Testsuite erwartet. Zur Fehlerbehebung muss dieser durch den tatsächlich angezeigten ersetzt werden. Dies geht bei einem Check mit festem Wert, um den es sich hier handelt, am einfachsten, indem Sie auf den rot umrandeten Fehler-Knoten \"Fehlgeschlagen: Check Text: default ...\" rechtsklicken und im Kontextmenü »Check-Knoten mit erhaltenen Daten aktualisieren« auswählen.","hash":"tut_ResolveRunTimeErrorsAndroid","h0":"Fehlerbehebung aus dem Protokoll heraus"},"820":{"id":820,"content":"Abbildung 32.13: Check-Knoten mit erhaltenen Daten aktualisieren QF‑Test navigiert zum betroffenen Check Text Knoten in der Testsuite und aktualisiert den Wert des Attributs Text anhand der aus dem SUT ausgelesenen Daten.","hash":"fig_DebugUpdateCheckNodeAndroid","h4":"Abbildung 32.13: Check-Knoten mit erhaltenen Daten aktualisieren"},"821":{"id":821,"content":"Abbildung 32.14: Korrigierter Check-Knoten Der Knoten enthält nun zwar den korrekten Wert, ist aber immer noch rot umrandet, da er noch nicht wieder ausgeführt wurde. Dies wollen wir nun tun. führen Sie den Test also fort, indem Sie auf den Pauseknopf drücken und so die Pause lösen. QF‑Test führt den Rest der Testsuite aus. In unserem Fall sind das der Check Text und der Aufräumen Knoten. Anschließend informiert Sie QF‑Test, dass ein Fehler aufgetreten ist. Diesen haben wir allerdings bereits während des Testlaufs behoben.","hash":"fig_DebugCorrectedCheckNodeAndroid","h4":"Abbildung 32.14: Korrigierter Check-Knoten"},"822":{"id":822,"content":"Ins Protokoll springen: Falls Sie das Protokoll an der Stelle, an der sich die Testausführung gerade befindet, öffnen wollen, brauchen Sie aus dem Debugging Modus heraus nur den Menüpunkt »Debugger«-»Jump to Run log« anzuklicken oder das Tastaturkürzel Strg⁠+⁠J zu drücken. Wenn Sie einfach nur das Protokoll öffnen wollen, ohne an die aktuelle Stelle zu springen, steht Ihnen Strg⁠+⁠L zur Verfügung, was auch nach Ende des Testlaufs weiterhin funktioniert.","hash":"tut_JumpToRunLogAndroid tut_JumpToRunLogAndroid","h4":"Abbildung 32.14: Korrigierter Check-Knoten"},"823":{"id":823,"content":"Pro Tutorial","hash":"","h0":"Testausführung pausieren | QF‑Test Tutorial"},"824":{"id":824,"content":"Pro Tutorial","hash":"home-link","h0":"Testausführung pausieren | QF‑Test Tutorial"},"825":{"id":825,"content":"Testausführung pausieren Wenn ein Test gerade ausgeführt wird und Sie den Debug-Modus aktivieren wollen, so können Sie entweder schnell einen Breakpoint auf einen noch nicht ausgeführten Knoten setzen oder Sie drücken einfach die Schaltfläche \"Pause\" um den Debug-Modus sofort zu aktivieren. Um die Ausführung fortzusetzen lösen Sie den Pauseknopf , völlig unabhängig von der Art und Weise wie der Debug-Modus aktiviert wurde. Wir wollen die vorhandenen Testfälle im Verlauf dieses Tutorials weiter verwenden. Allerdings wurde der Fehler in dem zweiten Testfall jetzt behoben. Insofern macht es Sinn \"(mit Fehler)\" aus dem Namen des zweiten Testfalls zu löschen, genauso wie \"(verursacht Fehler)\" aus dem Namen des Testschritts. Es gibt manchmal Situationen, in denen das SUT ständig den Fokus für sich beansprucht. Dann kann es schwierig sein, das QF‑Test Fenster lange genug im Vordergrund zu halten, um die Pausetaste drücken zu können. In einem solchen Fall steht Ihnen die \"Keine Panik\"-Taste Alt⁠+⁠F12 zur Verfügung. Sie unterbricht alle laufenden Tests sofort. Zur Weiterführung des Tests können Sie diese Tastenkombination erneut drücken.","hash":"tut_pause_execution_mobile","h0":"Testausführung pausieren"},"826":{"id":826,"content":"Pro Tutorial","hash":"","h0":"Variablen und Prozedurparameter (Mobile) | QF‑Test Tutorial"},"827":{"id":827,"content":"Pro Tutorial","hash":"home-link","h0":"Variablen und Prozedurparameter (Mobile) | QF‑Test Tutorial"},"828":{"id":828,"content":"Variablen und Prozedurparameter (Mobile) In diesem Kapitel lernen Sie, wie man eine Prozedur einsetzt um die gleichen Schritte auf unterschiedlichen Daten auszuführen. Außerdem sehen Sie, wie man Variablen einsetzt. Ebenso wird die Fehleranalyse in Bezug auf Variablen behandelt. Dieses Kapitel ist auch als Video verfügbar unter 'Variablen und Prozedurparameter'. Im Video wird eine Java-Applikation für die Erläuterungen verwendet. Bei Android-Applikationen gibt es hinsichtlich der Variablenverwendung keine Unterschiede.","hash":"sec_variablestackmobile","h1":"Variablen und Prozedurparameter (Mobile)"},"829":{"id":829,"content":"Pro Tutorial","hash":"","h0":"Prozedur mit Variable | QF‑Test Tutorial"},"830":{"id":830,"content":"Pro Tutorial","hash":"home-link","h0":"Prozedur mit Variable | QF‑Test Tutorial"},"831":{"id":831,"content":"Prozedur mit Variable Sehen Sie sich den letzten Testschritt \"Endpreis prüfen\" in unseren beiden Testfällen an.","hash":"sec_ProcedureWithVariableAndroid","h0":"Prozedur mit Variable"},"832":{"id":832,"content":"Abbildung 33.1: Zwei fast gleiche Testschritte Es wird der gleiche Schritt ausgeführt, jedoch mit unterschiedlichen Daten. Auch wenn es sich nur um einen Schritt handelt, macht es Sinn eine Prozedur daraus zu machen. Vielleicht kommen wir später auf die Idee, die hartkodierten Werte 13.349,00 € und 12.734,00 € in ein anderes Format zu bringen, so dass der Check auf das Feld \"Endpreis\" auch für andere Währungen funktioniert. Diesen Algorithmus zweimal zu implementieren wäre auf jeden Fall nicht sinnvoll. Selektieren Sie den \"Check text\" Knoten im ersten Testfall. Wählen Sie den Menüpunkt »Operationen«-»Knoten einpacken in«-»Sequenz« aus oder verwenden Sie das Tastaturkürzel Strg⁠+⁠Umschalt⁠+⁠S um ihn in eine Sequenz einzupacken. Nennen Sie die Sequenz 'prüfeEndpreis'. Dieser Name entspricht der Java-Konvention die Wörter zusammenzuschreiben. Andererseits erlaubt QF‑Test auch Leerzeichen in Prozedurnamen, so dass Sie der Java-Konvention nicht zu folgen brauchen. Drücken Sie Strg⁠+⁠Umschalt⁠+⁠P um auf kürzestem Weg den Sequenzknoten in eine Prozedur zu konvertieren (wie aus dem letzten Kapitel bekannt). Wie Sie sehen, wurde die Sequenz durch einen Prozeduraufruf von \"prüfeEndpreis\" ersetzt. Klicken Sie doppelt auf den Prozeduraufruf, um zur Prozedur im Prozeduren Knoten zu springen. Öffnen Sie den neu erstellten Prozedurknoten um den Inhalt zu sehen.","hash":"fig_params1Android","h4":"Abbildung 33.1: Zwei fast gleiche Testschritte"},"833":{"id":833,"content":"Abbildung 33.2: Prozedur mit hartkodiertem Wert Wie erwartet befindet sich der \"Check text\" Knoten in der Prozedur. Er ist jedoch nur für einen einzigen Preis gültig, nämlich 13.349,00 €. Da wir die gleiche Prozedur auch für den zweiten Testfall verwenden möchten, müssen wir den Preis durch eine Variable ersetzen. Der Wert dieser Variable sollte dann beim Prozeduraufruf mit übergeben werden. Im nächsten Beispiel werden wir einen Parameter mit Standardwert im Prozedurknoten einfügen. Standardwerte werden häufig verwendet, wenn der entsprechende Parameter bei den meisten Prozeduraufrufen den Standardwert erhalten würde. Dann braucht man den Standardwert nicht jedes Mal zu spezifizieren, sondern kann auf den im Prozedurknoten definierten Wert zurückgreifen. Obwohl das auf den Preis als Parameter nicht zutrifft, können wir ihn gerade deshalb verwenden um zu zeigen, wie ein Standardwert funktioniert und wie man ihn bei Bedarf mit einem anderen Wert überschreiben kann. Als erstes fügen wir also eine Variable mit Standardwert ein: Selektieren Sie die Prozedur 'prüfeEndpreis' Drücken Sie den \"Zeile einfügen\" Knopf über der Tabelle \"Standardwerte für Parameter\". Tragen Sie preis als Namen des Parameter ein. Tragen Sie 13.349,00 € als Wert ein. Drücken Sie OK.","hash":"fig_procedure_hardcoded_mobile","h4":"Abbildung 33.2: Prozedur mit hartkodiertem Wert"},"834":{"id":834,"content":"Abbildung 33.3: Die Details eines Prozedurknotens Im nächsten Schritt ersetzen wir den Wert des Text Attributs des Check Text Knotens durch eine Referenz auf die Variable.","hash":"fig_parameter_default_values_table_mobile","h4":"Abbildung 33.3: Die Details eines Prozedurknotens"},"835":{"id":835,"content":"Variablensyntax: Wenn Sie mit Variablen arbeiten, ist es wichtig, sich bewusst zu sein, dass Sie an bestimmten Stellen QF‑Test mitteilen wie, eine Variable heißt und an anderen, dass QF‑Test auf den Wert einer Variablen zugreifen soll. In obigem Beispiel wird QF‑Test in der Namensspalte für die Standardwerte der Variablenname mitgeteilt. In diesem Fall brauchten Sie nur preis einzutragen. Im Text Attribute des Check Text Knotens soll der Wert der Variablen verwendet werden. Bei QF‑Test geschieht dies dadurch, dass Sie den Variablenname in $() setzen, hier $(preis). Falls Sie den Variablennamen nicht in $() setzen, würde QF‑Test den Preis mit der Zeichenfolge preis vergleichen. Selektieren Sie den Check Text Knoten in der Prozedur \"prüfeEndpreis\". Tragen Sie $(preis) im Text Attribut der Check Text Knotendetails ein. Drücken Sie 'OK' in den Knotendetails.","hash":"tut_VariableSyntaxMobile","h4":"Abbildung 33.3: Die Details eines Prozedurknotens"},"836":{"id":836,"content":"Abbildung 33.4: 'Check text'-Knoten Führen Sie den ersten Testfall aus. Der Testfall sollte fehlerfrei durchlaufen.","hash":"fig_ProcedureAddVariableAndroid","h4":"Abbildung 33.4: 'Check text'-Knoten"},"837":{"id":837,"content":"Pro Tutorial","hash":"","h0":"Die Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"838":{"id":838,"content":"Pro Tutorial","hash":"home-link","h0":"Die Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"839":{"id":839,"content":"Die Variablendefinitionen-Tabelle Im nächsten Schritt fügen wir einen Prozeduraufruf im zweiten Testfall ein. Ersetzen Sie den Check Text Knoten des zweiten Testfalls durch einen Prozeduraufruf von \"prüfeEndPreis\". Sie können einfach den Prozeduraufruf aus dem ersten Testfall kopieren oder den Prozeduraufruf wie oben beschrieben einfügen.","hash":"tut_variable_stack_mobile","h0":"Die Variablendefinitionen-Tabelle"},"840":{"id":840,"content":"Abbildung 33.5: Prozeduraufruf von \"prüfeEndPreis\" in der zweiten Prozedur Wenn im Prozeduraufruf bereits der Preis mit Standardwert eingetragen ist, rührt das daher, dass der Prozeduraufruf mit Hilfe der Prozedur selbst erzeugt wurde. Entweder durch Kopieren der Prozedur oder durch eine Drag-and-Drop Aktion unter Verwendung des Prozedurknoten oder über direktes Einfügen der Prozedur wie weiter oben erläutert. Aktuell geht es jedoch um den Standardwert. Daher bitten wir Sie, den evtl. vorhandenen Preis-Parameter zu löschen, wenn Sie dem Tutorial Schritt für Schritt folgen wollen. Dazu klicken Sie das rote X über der Variablendefinitionen-Tabelle. Überprüfen Sie, ob der Debugger so eingestellt ist, dass er bei Fehlern unterbricht (siehe Debugger-Optionen: Test bei Fehler anhalten). Selektieren Sie den Knoten \"Testfall: Zweiter\". Führen Sie ihn aus, entweder über den Knopf oder durch Drücken der Eingabe Taste. Eine Fehlermeldung zeigt an, dass ein anderer als der angezeigte Preis erwartet wurde. Was lief schief? Lassen Sie uns nach dem Fehler forschen. Üblicherweise würden wir ins Protokoll schauen, aber es gibt noch eine andere wichtige Informationsquelle. Klicken Sie OK, um die Fehlermeldung zu schließen. Im Debugging-Modus sehen Sie rechts unten im QF‑Test Fenster eine Knotenliste mit Variablen, die von diesen gebunden sind. Eventuell müssen Sie die Variablendefinitionen-Tabelle vergrößern, um alle Einträge sehen zu können.","hash":"fig_AddProcedureCallToSecondTestcaseAndroid","h4":"Abbildung 33.5: Prozeduraufruf von \"prüfeEndPreis\" in der zweiten Prozedur"},"841":{"id":841,"content":"Abbildung 33.6: Variablendefinitionen Die Variablendefinitionen-Tabelle ist beim Debuggen sehr hilfreich, da sie die aktuellen Werte der Variablen anzeigt. Sie unterstützt beim Arbeiten mit Prozeduren als auch beim Verständnis, wie QF‑Test den richtigen Variablenwert ermittelt. QF‑Test geht die Variablendefinitionen-Tabelle immer von oben nach unten durch. Sie sehen, dass in den ersten Zeilen keine Variablen gebunden sind. Auf der Ebene \"Globale Variablen\" ist eine Variable gebunden und auf dem Sekundärstapel für \"Prozedur: prüfeEndpreis\" eine weitere. Die globale Variable wird für die Verbindung zur SUT Applikation verwendet und wurde vor dem Anwendungsstart gesetzt. (vgl. Gerät starten und verbinden). Die andere Variable interessiert uns im Moment mehr - sie hat jedoch den falschen Wert. Dieser Wert auf dem Sekundärstapel ist der Standardwert, da er dann verwendet wird, wenn nirgendwo sonst einer Variablen mit dem gleichen Namen ein Wert zugewiesen wurde. Um es richtig zu machen, müssen wir den korrekten Wert beim Prozeduraufruf an die Prozedur übergeben. Wieder gibt es mehrere Arten, dies zu tun. Ein Weg wäre, eine neue Zeile in der Variablendefinitionen-Tabelle in den Details des Prozeduraufrufs einzufügen, ähnlich wie beim Prozedurknoten im vorigen Abschnitt. Wenn es jedoch bereits mehrere Prozeduraufrufe gibt, ist folgendes einfacher: Beenden Sie die laufende Testausführung mittels . Führen Sie einen Rechtsklick auf den Prozedurknoten aus und wählen »Weitere Knotenoperationen«-»Parameter von Referenzen anpassen« im Popup-Menü.","hash":"fig_VariableBindingsTable1Android","h4":"Abbildung 33.6: Variablendefinitionen"},"842":{"id":842,"content":"Führen Sie einen Rechtsklick auf den Prozedurknoten aus und wählen »Weitere Knotenoperationen«-»Parameter von Referenzen anpassen« im Popup-Menü. Abbildung 33.7: Popup-Menü für \"Parameter von Referenzen anpassen\" Prüfen Sie im folgenden Dialog, dass ein Häkchen bei »Fehlende Parameter beim Aufrufer hinzufügen« gesetzt ist, und bestätigen Sie mit OK. Im Prozeduraufruf erzeugt QF‑Test für jeden Standardwert eine Zeile in der Variablen Definitionen Tabelle. In unserem Fall wurde eine Zeile für den Parameter mit dem Namen preis und dem Wert 13.349,00 € hinzugefügt. Auch damit wird es im zweiten Testfall noch nicht funktionieren, auch wenn der Wert direkt übergeben wird, weil es sich immer noch um den Standardwert handelt, der hier nicht korrekt ist. Bitte verändern Sie den Wert noch nicht, damit wir Ihnen mittels des entstehenden Fehlers eine weitere Möglichkeit des Debuggens zeigen können. Schließen Sie den Dialog \"Angepasste Knoten\", den QF‑Test anzeigt, um Sie über die vervollständigten Knoten zu informieren.","hash":"fig_CompleteParameters_mobile","h4":"Abbildung 33.6: Variablendefinitionen"},"843":{"id":843,"content":"Pro Tutorial","hash":"","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"844":{"id":844,"content":"Pro Tutorial","hash":"home-link","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle | QF‑Test Tutorial"},"845":{"id":845,"content":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle Als nächstes wollen wir die Variablendefinitionen-Tabelle unter die Lupe nehmen und herausfinden, wie man sie für Debugging-Zwecke einsetzen kann. Daher belassen Sie bitte den fehlerhaften Wert, der im vorigen Abschnitt im Prozeduraufruf eingefügt wurde. Dazu soll die Ausführung des Testfalls beim Prozeduraufruf unterbrochen werden um dann mittels Einzelschritten in die Prozedur zu gehen. Dabei werden wir uns ansehen, was in der Variablendefinitionen-Tabelle passiert. Anschließend wollen wir direkt aus der Variablendefinitionen-Tabelle zum fehlerhaften Prozeduraufruf springen und dort den Parameterwert korrigieren. Setzen Sie einen Breakpoint bei \"Prozeduraufruf: prüfeEndpreis\" im zweiten Testfall. Führen Sie den zweiten Testfall aus. Wenn QF‑Test am Breakpoint anhält, führen Sie zwei Einzelschritte in die Prozedur mittels aus und beobachten dabei die Variablendefinitionen-Tabelle.","hash":"tut_variable_stack_debugging_mobile","h0":"Fortgeschrittenes Debuggen mittels Variablendefinitionen-Tabelle"},"846":{"id":846,"content":"Abbildung 33.8: Variablendefinitionen-Tabelle zeigt den falschen Wert Wenn Sie mit Einzelschritten in die Prozedur gehen, wird beim ersten eine Zeile für \"Prozeduraufruf: prüfeEndpreis\" oben in der Tabelle erzeugt und beim zweiten die Zeile \"Prozedur: prüfeEndpreis\". Jetzt gibt es die Variable preis auf zwei verschiedenen Ebenen in der Variablen Definitionen Tabelle: in der Zeile für \"Prozeduraufruf: prüfeEndpreis\" und in der Zeile \"Prozedur: prüfeEndpreis\" auf dem Sekundärstapel, wobei keiner der beiden Variablenwerte der richtige ist. In QF‑Test können Sie interaktiv die Werte von Variablen in der Variablendefinitionen-Tabelle verändern, wenn Sie sich im Debugging-Modus befinden. Sie können sogar neue Variablen hinzufügen oder vorhandene löschen. Damit können Sie arbeiten, solange sich die Variablen auf dem Variablenstapel befinden, in unserem Fall solange wie die Prozedur ausgeführt wird. Änderungen des aktuellen Variablenwertes in der Variablendefinitionen-Tabelle bewirken keine Anpassung des im Prozeduraufrufknoten eingetragenen Parameterwerts. Der Wert muss explizit im Prozeduraufruf geändert werden. Die schnellste Methode um zum Prozeduraufruf zu gelangen ist ein Doppelklick auf die Prozeduraufrufzeile (zweite Zeile) in der Variablendefinitionen-Tabelle. Diese Methode ist besonders hilfreich, wenn Sie umfangreiche Testsuiten debuggen und der Knoten, zu dem Sie springen wollen, nicht im Testsuite-Fenster angezeigt wird. Statt eines Doppelklicks können Sie auch einen Rechtsklick auf die Zeile ausführen und den Menüpunkt »Zu Knoten in Testsuite springen« wählen. Führen Sie einen Doppelklick auf die zweite Zeile mit dem Prozeduraufruf in der Variablendefinitionen-Tabelle aus. Setzen Sie den Parameterwert auf den richtigen Wert, d.h. 12.734,00 €. Umgekehrt wird auch der aktuelle Wert in der Variablendefinitionen-Tabelle dadurch nicht verändert. Um dies zu erreichen müssen wir den Prozeduraufruf erneut ausführen. Allerdings ist die Testausführung über diesen Punkt bereits hinaus. Daher wollen wir hier eine weitere nützliche Funktion des Debuggers zeigen, mit der man den QF‑Test anweisen kann, den nächsten auszuführenden Knoten zu verändern. Dazu selektieren Sie den entsprechenden Knoten und wählen den Menüpunkt »Ausführung hier fortsetzen« oder verwenden das Tastaturkürzel Strg⁠+⁠,. Also, um den neu gesetzten Wert auszuprobieren: Führen Sie einen Rechtsklick auf den Knoten \"Prozeduraufruf: prüfeEndpreis\" in der zweiten Prozedur aus. Wählen Sie \"Ausführung hier fortsetzen\" im Popup-Menü.","hash":"fig_VariableStack3Android","h4":"Abbildung 33.8: Variablendefinitionen-Tabelle zeigt den falschen Wert"},"847":{"id":847,"content":"Abbildung 33.9: Ausführung hier fortsetzen In der Variablendefinitionen-Tabelle sind die zwei obersten Zeilen verschwunden. Der Grund ist, dass Sie die Prozedur verlassen haben (wenn auch \"rückwärts\") und dass dadurch der Prozeduraufruf mit den daran gebundenen Variablen vom Aufrufstack genommen wurde. Lösen Sie den Pauseknopf . Nun sollte kein Fehler mehr auftauchen. Da die Variablendefinitionen-Tabelle äußerst hilfreich ist, wenn Sie nach fehlerhaften Variablenwerten fahnden, wird eine Kopie davon auch unter dem Knoten \"Stacktrace\" im Protokoll abgespeichert, in dem die Variablenwerte genau zum Zeitpunkt des Fehlers zu sehen sind.","hash":"fig_ProcedureContinueExecFromHereAndroid","h4":"Abbildung 33.9: Ausführung hier fortsetzen"},"848":{"id":848,"content":"Aktuellen Knoten finden: Manchmal entfernt man sich beim Debuggen ziemlich weit vom aktuellen Knoten und möchte anschließend wieder zu diesem Knoten zurückfinden. Das geht am einfachsten indem man in der Toolbar \"Aktuellen Knoten finden\" drückt oder den Menüpunkt »Debugger«-»Aktuellen Knoten finden« wählt.","hash":"locate_current_node_mobile locate_current_node_mobile","h4":"Abbildung 33.9: Ausführung hier fortsetzen"},"849":{"id":849,"content":"Pro Tutorial","hash":"","h0":"Variablen setzen | QF‑Test Tutorial"},"850":{"id":850,"content":"Pro Tutorial","hash":"home-link","h0":"Variablen setzen | QF‑Test Tutorial"},"851":{"id":851,"content":"Variablen setzen Zusätzlich zu den oben beschriebenen Wegen können die Variablen auch wie folgt gesetzt werden: Mittels Variable setzen Knoten, als Rückgabewert einer Prozedur, als Ergebnis eines QF‑Test Knotens wie Text auslesen, Geometrie auslesen, Index auslesen und Check, in der 'Variablendefinitionen' Tabelle von Testsuite, Testfall, Testschritt, Sequenz und weiteren Knoten wie dem If oder Schleife Knoten, über Kommandozeilenparameter. Informationen dazu, an welcher Stelle eine Variable am besten definiert wird, finden Sie im nächsten Abschnitt. Ein Variable setzen Knoten kann über den Menüpunkt »Einfügen«-»Diverse Knoten«-»Variable setzen« eingefügt werden. In den Knotendetails können Sie angeben, ob es sich um eine lokale (Häkchen bei \"Lokale Variable\" setzen) oder eine globale Variable handeln soll. Die folgende Abbildung zeigt die Details eines Variable setzen Knotens, den Sie als ersten Knoten im Vorbereitung Knoten finden. Es wird eine Variable mit dem Namen client definiert. Dass es sich um eine globale Variable handelt, erkennen Sie daran, dass das Attribut 'Lokale Variable' nicht gesetzt ist.","hash":"tut_setting_variables_mobile","h0":"Variablen setzen"},"852":{"id":852,"content":"Abbildung 33.10: Details des Variable setzen Knoten Wenn eine Variable mit dem Rückgabewert einer Prozedur gesetzt werden soll, geben Sie den Variablennamen im Attribut \"Variable für Rückgabewert\" des Prozeduraufrufs an. In der Prozedur selbst müssen Sie als letzten auszuführenden Knoten einen Return Knoten einfügen, der den betreffenden Wert zurückgibt. Die Prozedur in der folgenden Abbildung liest den Rabattwert aus dem SUT und gibt den Wert an den aufrufenden Testfall zurück. Dort heißt die empfangende Variable Rabatt und ist als lokale Variable deklariert. Dieses Beispiel ist nicht in der Übungstestsuite enthalten.","hash":"fig_DetailsSetVariableAndroid","h4":"Abbildung 33.10: Details des Variable setzen Knoten"},"853":{"id":853,"content":"Abbildung 33.11: Prozedur mit Rückgabewert Der Text auslesen Knoten in der obigen Abbildung ist einer der QF‑Test Knoten, die direkt den Wert einer Variablen setzen. Dabei wird der Variablenname in dem entsprechend benannten Attribut eingetragen. Sie haben wiederum die Wahl, ob es eine lokale oder globale Variable werden soll. Es gibt eine Reihe von Knoten, die eine Variablendefinitionen-Tabelle besitzen. Dort können Sie lokale Variablen setzen. Falls sich der betreffende Knoten in einer Prozedur befindet, wird die Variable als lokale Variable an die Prozedur gebunden, ansonsten als lokale Variable an den Testfall. Variablen, die mittels dieser Tabelle an den Testsuite Knoten gebunden sind, können von allen Knoten der Testsuite referenziert werden. Alle Knoten, an die Variablen gebunden werden können, werden im Debugger-Modus im Variablen Definitionen Fenster rechts unten angezeigt, wenn sie gerade ausgeführt werden. Variablen können auch über die Kommandozeile spezifiziert werden. Hierzu verwenden Sie den Kommandozeilenparameter -variable. Beispiel: qftest -batch -variable \"browser\"=\"ie\" test.qft. Weitere Informationen hierzu finden Sie im Handbuch, Kapitel 'Kommandozeilenargumente'.","hash":"fig_DetailsCallProcedureAndroid","h4":"Abbildung 33.11: Prozedur mit Rückgabewert"},"854":{"id":854,"content":"Pro Tutorial","hash":"","h0":"Ebenen für Variablendefinitionen | QF‑Test Tutorial"},"855":{"id":855,"content":"Pro Tutorial","hash":"home-link","h0":"Ebenen für Variablendefinitionen | QF‑Test Tutorial"},"856":{"id":856,"content":"Ebenen für Variablendefinitionen Dieser Abschnitt gibt Antworten auf die Frage, auf welcher Ebene eine Variable definiert werden sollte. Wenn Sie diese Frage momentan nicht interessiert, können Sie direkt zum nächsten Kapitel springen. Variablen können auf unterschiedlichen Ebenen gebunden werden: Im Testsuite Knoten, in Testfällen und Prozeduren als Standard- oder als lokale Variablen, als Parameter in einem Prozeduraufruf, als globale Variable und als Kommandozeilenparameter. Die Ebene, auf welcher eine Variable am sinnvollsten definiert wird, hängt vom Verwendungszweck der Variablen ab: Prozedurparameter Übergeben Sie einen Wert als Parameter an eine Prozedur, wenn die gleiche Prozedur mehr als einmal und mit unterschiedlichen Werten ausgeführt werden soll. Prozedurparameter werden in der Variable Definitionen Tabelle eines Prozeduraufruf Knoten angegeben. Lokale Variablen in einer Prozedur Lokale Variablen werden innerhalb der Prozedur definiert und sind nur dort gültig. Wenn die Prozedur beendet wird, werden sie gelöscht. Verwenden Sie eine lokale Variable, wenn diese nicht außerhalb der Prozedur benötigt wird. Sie sind das Mittel der Wahl für Zwischenergebnisse. Lokale Variablen in einem Testfall In einem Testfall können lokale Variable entweder während der Durchführung des Testfall angelegt werden oder über die entsprechende Tabelle in den Details des Testfall Knotens. Wenn Sie in einem Testfall mehrfach den gleichen Wert verwenden, ist es sinnvoll, diesen einmalig einer Variablen zuzuweisen und dann die Variable zu verwenden. Dies erhöht die Wartbarkeit. Auch für Zwischenergebnisse sollte man lokale Variablen verwenden. Globale Variablen Wenn globale Variablen einmal erstellt wurden, existieren sie, bis sie entweder explizit gelöscht werden oder bis QF‑Test beendet wird. Auch Stopps und die erneute Ausführung von Tests \"überleben\" sie. Verwenden Sie sie für Werte, die in mehreren Testfällen genutzt werden. Ein Beispiel ist die Variable client, die im Vorbereitung Knoten beim Start der Applikation angelegt wird. Um sie wieder loszuwerden, wählen Sie den Menüpunkt »Wiedergabe«-»Globale Variablen löschen«. Auch beim Beenden von QF‑Test werden sie gelöscht. Kommandozeilenparameter Variablen, die über Kommandozeile gesetzt werden, sind im Batch-Modus sinnvoll, wenn Sie mehrere Batch-Läufe mit unterschiedlichen Werten durchführen wollen. Kommandozeilenparameter gelten während der gesamten Laufzeit des Batch-Laufs. Ein typisches Beispiel ist die variablengesteuerte Ausführung auf verschiedenen Browsern. Variablen können über den Kommandozeilen-Parameter -variable spezifiziert (vgl. Kapitel 'Kommandozeilenargumente' im Handbuch). Testsuite-Variablen Testsuite-Variablen können von allen Testfällen verwendet werden. Ihr Verwendungszweck entspricht dem von globalen Variablen, nur dass sie im Batch-Modus durch Variablen in der Kommandozeile überschrieben werden können. Standardwerte (Sekundärstapel) Sie können Standardwerte für die Variablen von Prozeduren, Testfällen und Testfallsätzen definieren. Diese kommen zum Zug, wenn keine Variable mit dem gleichen Namen auf einer höheren Ebene definiert wurde.","hash":"tut_variable_levels_mobile","h0":"Ebenen für Variablendefinitionen"},"857":{"id":857,"content":"Pro Tutorial","hash":"","h0":"Die Standardbibliothek (Mobile) | QF‑Test Tutorial"},"858":{"id":858,"content":"Pro Tutorial","hash":"home-link","h0":"Die Standardbibliothek (Mobile) | QF‑Test Tutorial"},"859":{"id":859,"content":"Die Standardbibliothek (Mobile) Dieses Kapitel ist auch als Video verfügbar unter 'Die Standardbibliothek'. QF‑Test stellt eine gewisse Anzahl an Knotentypen bereit, die für die Testerstellung genutzt werden können. Wenn Sie Funktionalität benötigen, die darüber hinausgeht, können Sie diese mittels Skript-Knoten implementieren. Um Ihnen die Arbeit zu erleichtern, wurden viele Funktionen, die häufig benötigt werden, bereits in Prozeduren implementiert und werden in einer Standard-Prozeduren-Bibliothek mit QF‑Test ausgeliefert. Wenn Sie also eine Aufgabenstellung haben, die nicht über die bereitgestellten Knoten gelöst werden kann, sollten Sie zunächst einmal in der Standardbibliothek forschen, ob Sie dort eine passende oder ähnliche Lösung finden. Wenn Sie eine ähnliche Lösung finden, kopieren Sie einfach die vorhandene Standardprozedur und passen sie Sie gemäß Ihrer Bedürfnisse an. Informationen zum Arbeiten mit Skripten erhalten Sie im Handbuch, Kapitel 12 \"Skripting\". Die Bibliothek ist in der Datei qfs.qft enthalten und ist Teil der QF‑Test Distribution. Da sie mit jeder QF‑Test Version weiterentwickelt wird, ist es nicht ratsam, Änderungen in der ausgelieferten Standardbibliothek vorzunehmen, sondern bei Bedarf eine Prozedur in eine eigene Testsuite zu kopieren und dort anzupassen. Um die Bibliothek qfs.qft verwenden zu können, muss sie im \"Testsuite\" Wurzelknoten Ihrer Suite in den \"inkludierten Dateien\" eingebunden werden. Bei neuen Testsuiten ist dies automatisch der Fall. Wählen Sie den 'Testsuite'-Wurzelknoten Ihrer Testsuite aus. Überprüfen Sie in den Details des 'Testsuite'-Wurzelknoten, dass qfs.qft im Attribut \"Inkludierte Dateien\" aufgeführt ist. Fügen Sie qfs.qft zu dieser Liste dazu, falls es noch nicht enthalten ist. Eine Pfadangabe ist nicht notwendig, da das include Verzeichnis von QF‑Test automatisch im Bibliothekspfad (siehe auch Referenzteil des Handbuchs) enthalten ist. Im Folgenden beschreiben wir eine Auswahl der am häufigsten benötigten Standardprozeduren. Eine vollständige HTML-Dokumentation der Standardbibliothek finden Sie unter dem Menüpunkt »Hilfe«-»Standardbibliothek qfs.qft...«.","hash":"sec_StandardLibraryMobile","h1":"Die Standardbibliothek (Mobile)"},"860":{"id":860,"content":"Pro Tutorial","hash":"","h0":"Erforschen der Standardbibliothek | QF‑Test Tutorial"},"861":{"id":861,"content":"Pro Tutorial","hash":"home-link","h0":"Erforschen der Standardbibliothek | QF‑Test Tutorial"},"862":{"id":862,"content":"Erforschen der Standardbibliothek Zusätzlich zum Einfügen von Prozeduraufrufen aus der Standardbibliothek ist es hilfreich, einen Blick darauf zu werfen, wie Funktionen implementiert und organisiert sind. Öffnen Sie die Bibliothek selbst, also die Suite qfs.qft, die sich im Verzeichnis qftest-10.0.2-pro/include Ihrer QF‑Test Installation befindet.","hash":"sec_StandardLibraryOverviewMobile","h0":"Erforschen der Standardbibliothek"},"863":{"id":863,"content":"Abbildung 34.1: Die Standardbibliothek Sie sehen ein Haupt-Package qfs, das die spezifischen Packages umschließt. Das qfs Package hilft dabei, die Prozeduren leicht als solche der Standardbibliothek zu identifizieren. In fast allen Prozeduren unserer Bibliothek werden Sie die Verwendung der Variable $(client) bemerken. Dies ist ein Standardmechanismus, um Testsuiten unabhängig von einem spezifischen SUT zu gestalten. Für die Benutzung der Standardbibliothek wird vorausgesetzt, dass ein gültiger Wert für $(client) gesetzt wird, bevor eine ihrer Prozeduren verwendet werden kann.","hash":"fig_SuiteQfsQftMobile","h4":"Abbildung 34.1: Die Standardbibliothek"},"864":{"id":864,"content":"Pro Tutorial","hash":"","h0":"Ausgewählte Packages und Prozeduren | QF‑Test Tutorial"},"865":{"id":865,"content":"Pro Tutorial","hash":"home-link","h0":"Ausgewählte Packages und Prozeduren | QF‑Test Tutorial"},"866":{"id":866,"content":"Ausgewählte Packages und Prozeduren Wir werfen nun einen genaueren Blick auf ein paar ausgewählte Packages und Prozeduren der Standardbibliothek.","hash":"sec_StandardLibraryPackagesMobile","h0":"Ausgewählte Packages und Prozeduren"},"867":{"id":867,"content":"Das Android-Package Das Package qfs.run-android enthält Prozeduren, um verschiedenste ADB-Befehle auszuführen oder mit dem Gerät zu interagieren. Nachfolgend finden Sie einen Auszug aus der Liste der verfügbaren Prozeduren innerhalb des Packages: appControl-resetCurrentApp Setzt alle Daten und Berechtigungen der App zurück, die aktuell den Fokus hat, und startet sie neu. dataTransfer-pull Überträgt eine Datei oder einen Ordner vom Android-Gerät auf das lokale System. dataTransfer-push Überträgt eine Datei oder einen Ordner vom lokalen System auf das Android-Gerät. runAdbCommand Führt einen beliebigen ADB-Befehl aus. device-appSwitch Aktiviert die App-Wechsel-Schaltfläche auf dem Gerät. device-back Aktiviert die Zurück-Schaltfläche auf dem Gerät. device-home Aktiviert die Home-Schaltfläche auf dem Gerät. device-closeKeyboard Schließt eine möglicherweise geöffnete Bildschirmtastatur. device-setRotation Ändert die Bildschirmausrichtung des Geräts.","hash":"sec_das_android_package","h1":"Das Android-Package"},"868":{"id":868,"content":"Das Run-log Package Das Package qfs.run-log enthält Prozeduren, um Meldungen in das Protokoll zu schreiben. Hier sehen Sie die Liste von verfügbaren Prozeduren innerhalb des Packages: logError Schreibt eine Fehlermeldung ins Protokoll. logWarning Schreibt eine Warnung ins Protokoll. logMessage Schreibt eine Meldung ins Protokoll.","hash":"sec_das_run_log_package","h1":"Das Run-log Package"},"869":{"id":869,"content":"Das Utils Package Das Package qfs.utils enthält nützliche Prozeduren für häufig auftretende Anforderungen der Testentwicklung. Hier sehen Sie einige Prozeduren des Packages: getDate Gibt einen String zurück, der ein Datum enthält. Standardmäßig wird das aktuelle Datum zurückgegeben. (Andere Daten sind konfigurierbar.) getTime Gibt einen String zurück, der eine Zeit enthält. Standardmäßig wird die aktuelle Zeit zurückgegeben. (Andere Zeiten sind konfigurierbar.) logMemory Schreibt den aktuellen Speicherverbrauch ins Protokoll. printVariable Gibt den Inhalt einer spezifizierten Variable auf der Konsole aus. printMessage Gibt den Inhalt einer angegebenen Nachricht auf der Konsole aus. writeMessageIntoFile Schreibt einen angegebenen String in eine angegebene Datei.","hash":"sec_das_utils_package","h1":"Das Utils Package"},"870":{"id":870,"content":"Das Check Package Das qfs.check Package enthält Prozeduren, die Checks ausführen. Die wichtigsten Prozeduren sind: checkEnabledStatus Überprüft, ob eine Komponente en- bzw. disabled ist. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt. checkSelectedStatus Überprüft, ob eine Komponente selektiert bzw. nicht selektiert ist. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt. checkText Überprüft den Text einer Komponente. Im Fehlerfall wird von der Prozedur ein entsprechender Fehler ins Protokoll geloggt.","hash":"sec_das_check_package","h1":"Das Check Package"},"871":{"id":871,"content":"Das Databinder Package Das Package qfs.databinder enthält Prozeduren zur Ausführung innerhalb eines Datentreiber Knotens, um Daten für datengetriebenes Testen zu binden. Die wichtigsten Prozeduren sind: bindList Bindet eine Liste von Werten an eine Variable. Die Werte sind durch Leerzeichen oder das als Parameter übergebene Trennzeichen getrennt. bindSets Bindet Sätze von Werten an einen Satz von Variablen. Die Sätze von Werten sind durch Zeilenumbrüche getrennt, die Werte innerhalb eines Satzes durch Leerzeichen oder das als Parameter übergebene Trennzeichen.","hash":"sec_das_databinder_package","h1":"Das Databinder Package"},"872":{"id":872,"content":"Pro Tutorial","hash":"","h0":"Ablaufsteuerung (Mobile) | QF‑Test Tutorial"},"873":{"id":873,"content":"Pro Tutorial","hash":"home-link","h0":"Ablaufsteuerung (Mobile) | QF‑Test Tutorial"},"874":{"id":874,"content":"Ablaufsteuerung (Mobile) Dieses Kapitel ist auch als Video verfügbar unter 'Ablaufsteuerung'. Die zwei wichtigsten Kontrollstrukturen von QF‑Test sind Schleifen und die bedingte Ausführung von Knoten. Schleifen können über zwei verschieden Knoten implementiert werden: While und Schleife Knoten. If, Elseif und Else Knoten stehen für die bedingte Ausführung von Knoten zur Verfügung.","hash":"sec_controlstructuresmobile","h1":"Ablaufsteuerung (Mobile)"},"875":{"id":875,"content":"Pro Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"876":{"id":876,"content":"Pro Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"877":{"id":877,"content":"If - else If Knoten kennen Sie bereits aus der Vorbereitung Sequenz im Kapitel Gerät starten und verbinden. Sehen wir uns diesen nun etwas genauer an.","hash":"sec_ifmobile","h0":"If - else"},"878":{"id":878,"content":"Abbildung 35.1: Setup Sequenz mit If/Elseif Knoten Über einen If-Knoten können Sie steuern, ob bestimmte Knoten ausgeführt werden oder nicht. In unserem Fall geht es um das Anmelden in der Carconfig-App. Zunächst müssen wir herausfinden, ob wir bereits angemeldet sind. Dies geschieht über den Warten auf Komponente-Knoten, der als Ergebnis entweder true (wahr) oder false (falsch) in die Variable notLoggedIn schreibt.","hash":"fig_ControlsSetupSequenceMobile","h4":"Abbildung 35.1: Setup Sequenz mit If/Elseif Knoten"},"879":{"id":879,"content":"Abbildung 35.2: Warten auf Komponente setzt die Variable \"notLoggedIn\" mit dem Ergebnis Der If Knoten wertet die Ergebnisvariable notLoggedIn im 'Bedingung' Attribut aus. Da auf den Wert der Variablen zugegriffen werden soll, wird die Syntax $() verwendet (vgl. Hinweis zu Variablensyntax in Kapitel \"Prozedur mit Variable\").","hash":"fig_ControlsWaitForComponentMobile","h4":"Abbildung 35.2: Warten auf Komponente setzt die Variable \"notLoggedIn\" mit dem Ergebnis"},"880":{"id":880,"content":"Abbildung 35.3: Der If Knoten wertet die Variable aus Je nachdem, ob man bereits angemeldet ist, führt QF‑Test die im If Knoten enthaltenen Knoten aus oder nicht. In der Variablendefinition-Tabelle können Sie den Wert der Variablen notLoggedIn prüfen. Beim ausführen des Ersten Testfalls ist der Wert true und damit die Bedingung $(notLoggedIn) wahr, d.h. die Knoten zum Anmelden werden ausgeführt. Beim zweiten Testfalls ist der Wert fals und damit die Bedingung false. Die Knoten im If Knoten werden übersprungen. In einem Elseif Knoten wird eine weitere Bedingung formuliert, die dann geprüft wird, wenn die Bedingung im If Knoten nicht zutrifft. Die Kindknoten des Else Knoten werden nur dann ausgeführt, wenn weder die Bedingung des If noch die der Elseif Knoten zutreffen.","hash":"fig_ControlsIfMobile","h4":"Abbildung 35.3: Der If Knoten wertet die Variable aus"},"881":{"id":881,"content":"Pro Tutorial","hash":"","h0":"Schleifen | QF‑Test Tutorial"},"882":{"id":882,"content":"Pro Tutorial","hash":"home-link","h0":"Schleifen | QF‑Test Tutorial"},"883":{"id":883,"content":"Schleifen QF‑Test stellt zwei Knotentypen für die Implementierung von Schleifen zur Verfügung: Schleife Knoten führen ihre Kindknoten so oft aus, wie angegeben ist. Man kann die Schleife jedoch über einen Break Knoten jederzeit verlassen. While Knoten führen ihre Kindknoten so oft aus, bis die angegebene Bedingung nicht mehr gegeben ist. Derartige Schleifen können ebenfalls über einen Break Knoten jederzeit verlassen werden. Schleife Knoten enden auf jeden Fall nach der angegeben Anzahl von Wiederholungen. Bei While Knoten muss man jedoch selbst dafür sorgen, dass die Ausführung irgendwann endet, indem die Bedingung falsch wird. Ansonsten kommt es zur Endlosschleife. Im interaktiven Modus können Sie in so einem Fall einfach die Pausetaste drücken. Im Batch-Modus, d.h. wenn Sie QF‑Test mit dem Kommandozeilenparameter -batch starten um die angegebene Testsuite ohne die QF‑Test Benutzeroberfläche auszuführen, müssen Sie dann jedoch den QF‑Test Prozess \"abschießen\". In der folgenden Übung wollen wir einen Testfall implementieren, der prüft, ob eine bestimmter Eintrag in der Liste des CarConfig Demos angezeigt wird. Die im Testfall durchgeführten Aktionen sind: Anzahl Listeinträge bestimmen. Über alle Einträge iterieren und prüfen, ob der Eintrag passt. Wenn der Eintrag gefunden wurde, die Schleife abbrechen. Falls der Eintrag nicht gefunden wurde, einen Fehler ins Protokoll schreiben. Bitte beginnen Sie mit der Aufnahme eines Checks auf die zu suchende Eintrag: Aktivieren Sie den Check-Aufnahmemodus über \"Checks aufnehmen\" . Führen Sie einen Rechtsklick auf eine Fahrzeugnamen im CarConfig Demo aus und wählen Sie den Menüpunkt »Text« aus dem Popup-Menü. Beenden Sie die Aufnahme über \"Aufnahme beenden\" . Ändern Sie den Namen der aufgenommenen Sequenz z.B. in Text prüfen . Wandeln Sie die Sequenz in einen Testfall um: Rechtsklick auf den Sequenz Knoten und Auswahl des Untermenüpunkts »Knoten konvertieren in«-»Testfall« im Popup-Menü. In QF‑Test können Sie sehr effizient Knoten hinzufügen, indem Sie einen Knoten in einen anderen einpacken: Öffnen Sie den Testfall Knoten und packen Sie den aufgenommenen Check Knoten in eine Schleife indem Sie rechts auf den Knoten klicken und in dem sich öffnenden Popupmenü den Punkt »Knoten einpacken in«-»Schleife« auswählen. QF‑Test ermittelt dynamisch, in welche Knoten ein Knoten eingepackt werden kann und bietet nur diese zur Auswahl an. Entsprechend kann es passieren, dass Sie \"Schleife\" im Untermenü nicht finden. Sie sollten dann prüfen, ob Sie den Rechtsklick auf den richtigen Knoten ausgeführt haben. Dasselbe gilt für die Operationen \"Knoten konvertieren in\" und \"Knoten einfügen\". Als nächstes setzen wir den Wert für das Attribut 'Anzahl Wiederholungen' des Schleife Knoten. Dazu müssen wir bestimmen, wie viele Einträge die Liste hat. Es gibt keinen Knoten, der diese Operation direkt ausführen kann. Allerdings gibt es eine derartige Prozedur in der im letzten Kapitel besprochenen Standardbibliothek. Diese befindet sich im Package qfs.android.list und heißt getItemCount. Selektieren Sie den Testfall Knoten und drücken Strg⁠+⁠A. Klicken Sie die Schaltfläche \"Prozedur auswählen\" links neben der Überschrift 'Name der Prozedur'. Wählen Sie den Reiter 'qfs.qft' im 'Prozedur auswählen' Dialog. Navigieren Sie zu 'getItemCount' im Package 'qfs.android.list' Drücken Sie 'OK' um die Prozedur auszuwählen. Drücken Sie 'OK' um den 'Prozeduraufruf' Dialog zu schließen. Das Hinzufügen einer Prozedur über Strg⁠+⁠A wurde in Manuelle Erstellung von Prozeduren beschrieben. Dort finden Sie auch Screenshots zur Aktion. Fügen Sie eine Variable mit dem Namen itemCount im Attribut 'Variable für Rückgabewert' ein. Ändern Sie den Standardwert für id in der Variablendefinitionen-Tabelle auf die QF‑Test Komponenten-ID der Liste action_bar_root.list . Klicken Sie OK. Wählen Sie den 'Schleife'-Knoten. Im Attribut 'Anzahl Wiederholungen' des Schleife Knotens tragen Sie eine Referenz auf die Variable $(itemCount) ein. Tragen Sie den Namen der Zählervariable, z.B. i, im entsprechenden Attribut des Schleife Knotens ein. Klicken Sie OK. In den Details des Check Knotens tragen wir nun in der QF‑Test ID der Komponente statt des aufgenommenen Listenindex eine Referenz auf die Zählervariable ein und setzen eine Ergebnisvariable. Außerdem fügen wir einen If Knoten unter dem Check Knoten hinzu, der das Ergebnis auswertet und die Schleife über einen Break Knoten verlässt, wenn die entsprechende Zeile gefunden wurde. Öffnen Sie den Schleife Knoten. Selektieren Sie den Check Knoten. Ändern Sie den aufgenommenen Index der QF‑Test ID der Komponente in Zählervariable $(i). Die QF‑Test ID der Komponente sollte nun action_bar_root.list&$(i)@#Label: lauten. Tragen Sie den Variablennamen ItemGefunden in das Attribut 'Variable für Ergebnis' ein und klicken OK. Führen Sie einen Rechtsklick auf den Check Knoten aus und wählen Sie aus dem Popup-Menü den Unterpunkt »Knoten einfügen«-»Ablaufsteuerung«-»Break« aus. Drücken Sie 'OK' im 'Break' Dialog. Packen Sie den Break Knoten in einen If Knoten mittels des Tastaturkürzels Strg⁠+⁠Umschalt⁠+⁠I (Sie können natürlich auch über das Menü gehen). In den Details des 'If'-Knotens tragen Sie $(ItemGefunden) im Attribut 'Bedingung' ein und klicken OK. Die Variable ItemGefunden wird vom Check Knoten entweder auf den Wert 'true' oder auf den Wert 'false' gesetzt, so dass wir im Attribut 'Bedingung' des If Knoten nur die Referenz auf die Variable $(ItemGefunden) einzutragen brauchen. In den nächsten Schritten wollen wir einen Else Knoten als letzten Knoten im Schleife Knoten einfügen. Er wird nur ausgeführt, wenn die Schleife so oft wie angegeben ausgeführt wurde, was in unserem Fall bedeutet, dass die Variable ItemGefunden nie wahr wurde, weil die Zeile nicht gefunden wurde. Schließen Sie den If Knoten, falls dies nicht bereits der Fall ist. Dies ist wichtig, da sonst der Else Knoten zum If Knoten und nicht zum Schleife Knoten gehören würde. Führen Sie einen Rechtsklick auf den If Knoten aus und wählen Sie auf dem Popup-Menü den Unterpunkt »Knoten einfügen«-»Ablaufsteuerung«-»Else« . Klicken Sie im 'Else' Dialog 'OK'. Öffnen Sie den Else Knoten. Fügen Sie aus der Standardbibliothek die Prozedur logError aus dem Package qfs.run-log wie oben beschrieben ein. In der 'Variablendefinitionen' Tabelle tragen Sie Item nicht gefunden als Wert der Zeile message ein. Tragen Sie true als Wert der Zeile withScreenshots ein. Drücken Sie OK. Wenn Sie die Tests im Batch-Modus ausführen, sind Screenshots eine gute Unterstützung bei der Fehleranalyse. Da aber eine große Zahl Screenshots sehr große Protokolldateien erzeugen würden, ist der Standardwert für withScreenshots false. Nun bleibt nur noch, den Testfall mit Vorbereitung und Aufräumen Knoten zu vervollständigen und ihn in den oberen Teil der Testsuite zu verschieben. Kopieren Sie die Vorbereitung und Aufräumen Knoten aus 'Testset: Einfache Tests' in den neuen Testfall als ersten und letzten Knoten. Verschieben Sie den Testfall aus dem Bereich Extrasequenzen in den oberen Bereich der Testsuite hinter den Knoten 'Testset: Einfache Tests'. Damit würde der neue Testfall wie folgt aussehen:","hash":"sec_loopsmobile","h0":"Schleifen"},"884":{"id":884,"content":"Abbildung 35.4: Der neue Testfall Führen Sie den neuen Testfall aus. Er sollte ohne Fehler laufen. Ändern Sie nun in den Details des Check Elemente Knotens den Namen des Fahrzeugs zum Beispiel auf Falscher Wert.","hash":"fig_ControlsTestcaseMobile","h4":"Abbildung 35.4: Der neue Testfall"},"885":{"id":885,"content":"Abbildung 35.5: Details eines Check Elemente Knoten Führen Sie den Testfall nochmals aus. Nun sollte der Test den Else Knoten der Schleife ausführen und eine Fehlermeldung anzeigen.","hash":"fig_ControlsCheckDetailsMobile","h4":"Abbildung 35.5: Details eines Check Elemente Knoten"},"886":{"id":886,"content":"Pro Tutorial","hash":"","h0":"Weiterführende Features von QF‑Test | QF‑Test Tutorial"},"887":{"id":887,"content":"Pro Tutorial","hash":"home-link","h0":"Weiterführende Features von QF‑Test | QF‑Test Tutorial"},"888":{"id":888,"content":"Weiterführende Features von QF‑Test Dieser Abschnitt des Tutorials beschreibt Features von QF‑Test, welche für fortgeschrittene Benutzer interessant sind. Die folgenden Kapitel verwenden die Java-Variante der CarConfigurator Demoanwendung, die Sie bereits aus dem Basisteil des Tutorials kennen. Der CarConfigurator ist in Java/Swing implementiert, die Konzepte allerdings sind für jede unterstützte Technologie anwendbar. Für jedes Kapitel gibt es auch spezielle Testsuiten, damit Sie die Themen jedes Kapitels einzeln nachverfolgen können. Diese Dateien finden Sie unter qftest-10.0.2-pro/doc/tutorial/advanced-demos/de.","hash":"sec_advanced","h1":"Weiterführende Features von QF‑Test"},"889":{"id":889,"content":"Pro Tutorial","hash":"","h0":"Datengetriebenes Testen: Einen Test case mit unterschiedlichen\n    Testdatensätzen starten | QF‑Test Tutorial"},"890":{"id":890,"content":"Pro Tutorial","hash":"home-link","h0":"Datengetriebenes Testen: Einen Test case mit unterschiedlichen\n    Testdatensätzen starten | QF‑Test Tutorial"},"891":{"id":891,"content":"Datengetriebenes Testen: Einen Test case mit unterschiedlichen Testdatensätzen starten Dieses Kapitel erklärt, wie man datengetriebenes Testen mit QF‑Test verwirklichen kann. Sie finden unter qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/datadrivenTesting.qft die hier gezeigten Testfälle. In der zweiten mitgelieferten Testsuite qftest-10.0.2-pro/doc/tutorial/datadriver.qft finden Sie weitere Beispiele, wie das Auslesen einer Excel-Datei oder einer Schleife um Testfälle. Bitte achten Sie darauf, dass Sie alle Testsuiten vorher in einen projektspezifischen Ordner kopieren und diese dort modifizieren.","hash":"sec_DataDriven","h0":"Datengetriebenes Testen: Einen Test case mit unterschiedlichen Testdatensätzen starten"},"892":{"id":892,"content":"Situation Die Anwender des CarConfigurators können unterschiedliche Rabattstufen gewähren. Der Testdesigner hat drei Rabattstufen definiert, die getestet werden sollen. Diese Rabattstufen sind 0%, 10% und 15%. Der Ablauf, um einen Rabatt zu gewähren, ist für jede dieser drei Rabattstufen derselbe. Daher können wir denselben Testfall benutzen, um diese zu testen. Der einzige Unterschied ist der eingegebene Rabattsatz und der zu prüfende Preis. Wir sollten denselben Testfall für jede Rabattstufe benutzen, um Seiteneffekte zu vermeiden, die bei unterschiedlichen Implementierungen der Testfälle auftreten können. Darüber hinaus sparen wir uns auch den Implementierungsaufwand zum Erstellen mehrerer Testfälle. Der logische Testfall, d.h. die Schritte des Testfalles, sehen folgendermaßen aus: Starten des SUTs. Ein Modell auswählen. Den Rabatt eingeben. Prüfen, ob der Rabatt für die Preiskalkulation herangezogen wurde. Das SUT stoppen. Die folgenden Abschnitte zeigen nun die Implementierung dieses Szenarios.","hash":"sec_dataDriven","h1":"Situation"},"893":{"id":893,"content":"Die traditionelle Methode für datengetriebenes Testen In QF‑Test steht ein Testfall für einen Testablauf zusammen mit einem speziellen Testdatensatz. Wenn man zwei Testdatensätze testen möchte, so muss man zwei Testfälle erstellen. Diese Testfälle können auch in einem Testfallsatz zusammengefasst werden. Bei der konventionellen Lösung implementiert man also einen Testfall pro Rabattstufe. Das sieht dann so aus:","hash":"sec_dataDrivenTrad","h1":"Die traditionelle Methode für datengetriebenes Testen"},"894":{"id":894,"content":"Abbildung 37.1: Konventionelle Methode für datengetriebenes Testen Wir sehen für jede der drei Rabattstufen genau einen Testfall Knoten. Diese drei Knoten sind in einem Testfallsatz zusammengefasst. Der Testfallsatz Knoten beinhaltet auch die Vorbereitung und die Aufräumen Knoten, welche das SUT vor jedem Testfall starten und nach jedem Testfall stoppen. Dies geschieht, um sicherzustellen, dass die Vorbedingungen jedes einzelnen Testfalles dieselben sind. Wenn Sie die SUT nicht nach jedem Testfall neu starten wollen, dann können Sie die drei Testfälle in einem weiteren Testfallsatz zusammenfassen, wie Sie hier sehen können:","hash":"fig_dataDrivenTrad1","h4":"Abbildung 37.1: Konventionelle Methode für datengetriebenes Testen"},"895":{"id":895,"content":"Abbildung 37.2: Konventionelle Methode mit einem verschachtelten Testfallsatz Das Kapitel Abhängigkeiten: Automatisches Sicherstellen der korrekten Vorbedingungen jedes Testfalles zeigt Ihnen eine elegantere und effizientere Art, Vor- und Nachbedingungen von Testfällen zu organisieren. Wie Sie sich sicher vorstellen können, wird es mit dieser Methode ziemlich mühsam sein, die Testdaten zu verwalten. Insbesondere, wenn Sie eine neue Rabattstufe anlegen oder eine Stufe wegfällt. Ein weiterer Nachteil dieses Ansatzes ist, dass die Testdaten in QF‑Test gehalten werden. Das nächste Kapitel Datentreiberkonzept zeigt Ihnen nun, wie Testsuiten organisiert werden können, in denen nur ein Testfall implementiert wird und die Testdaten unabhängig vom Testfall abgelegt werden.","hash":"fig_dataDrivenTrad2","h4":"Abbildung 37.2: Konventionelle Methode mit einem verschachtelten Testfallsatz"},"896":{"id":896,"content":"Datentreiberkonzept Wenn man nun einen Testfall starten möchte, der mehrere Testdatensätze verwendet, muss man zuerst die Testdatensätze in einer Datenquelle definieren. Diese Datenquelle muss innerhalb eines Datentreiber Knotens definiert werden. QF‑Test bietet Standardverknüpfungen für Datenbanktabellen, CSV-Dateien, Excel-Dateien und für innerhalb von QF‑Test definierte Datentabellen an. Die QF‑Test Datentabelle speichert die Testdaten in der Testsuite selbst. Wir werden diese Datenquelle für unser folgendes Beispiel nutzen. Jede andere Datenquellenart, z.B. XML Dateien, kann mit einem selbstimplementierten Skript angebunden werden. Fügen Sie zuerst einen neuen Testfallsatz in die Testsuite ein. Sie können den Namen frei wählen. Ein Datentreiber Knoten kann in einen Testfallsatz mittels Rechtsklick und Auswahl von »Knoten einfügen«-»Datentreiber«-»Datentreiber« eingefügt werden. Sie müssen nur noch einen Namen für diesen Knoten definieren. Die eigentliche Testdatenquelle kann als Kindknoten des Datentreiber Knotens eingefügt werden. In unserem Fall werden wir eine 'Datentabelle' mittels Rechtsklick und Auswahl von »Knoten einfügen«-»Datentreiber«-»Datentabelle« einfügen. Sie erhalten nun einen Datentreiber Knoten mit den folgenden Details:","hash":"sec_dataDriver20","h1":"Datentreiberkonzept"},"897":{"id":897,"content":"Abbildung 37.3: Dialog für eine Datentabelle Zuerst müssen wir einen Namen für diese Datenquelle spezifizieren. Wir sollten auch eine 'Zählervariable' definieren. Die Zählervariable beinhaltet den Index des aktuell verwendeten Datensatzes während der Testausführung. Der nächste Schritt ist die Definition der Testdaten. Dafür klicken Sie auf den Knopf 'Spalte einfügen'. Das ist der erste Knopf im 'Daten'-Bereich. Dann müssen Sie einen Namen für diese Spalten definieren. Setzen Sie den Namen auf 'rabatt'. Danach drücken Sie auf 'OK' und die Spalte sollte eingefügt worden sein. Diese Spalteüberschrift wird später der Variablenname in den Tests sein. Nun klicken Sie auf den 'Zeile einfügen' Knopf, um eine neue Zeile einzufügen. Jede Zeile wird für einen eigenen Testdatensatz stehen, d.h., dass wir jetzt drei Zeilen einfügen müssen. Die erste Zeile soll '0', die zweite '10' und die dritte '15' beinhalten. Die Tabelle sollte nun so aussehen:","hash":"fig_dataDriver20Dt1","h4":"Abbildung 37.3: Dialog für eine Datentabelle"},"898":{"id":898,"content":"Abbildung 37.4: Die gefüllte Datentabelle Nun kommen wir zur eigentlichen Implementierung des Testfalles. Dafür müssen wir nur einen Testfall zum Testfallsatz hinzufügen. Wenn sie einen Testfall zu einem Testfallsatz hinzufügen wollen, dann müssen Sie auf den geschlossenen Datentreiber klicken, um den Testfall einzufügen. Der Testfall wird die Prozeduraufrufe für die benötigten Testschritte beinhalten. Sie können auch die Vorbereitung und die Aufräumen Knoten aus dem vorigen Testfallsatz in den neuen Testfallsatz kopieren. Der gesamte Testfallsatz sollte nun so ausschauen:","hash":"fig_dataDriver20Dt2","h4":"Abbildung 37.4: Die gefüllte Datentabelle"},"899":{"id":899,"content":"Abbildung 37.5: Testfallsatz mit Datentreiber Jetzt müssen wir noch die Variable 'rabatt', welche in der Datentabelle definiert wurde, verwenden. Wir sollten diese Variable als Parameter für den 'setzeRabatt' Prozeduraufruf hinzufügen. Wenn wir das gemacht haben, sollte unser Test so aussehen:","hash":"fig_dataDriver20TestSet","h4":"Abbildung 37.5: Testfallsatz mit Datentreiber"},"900":{"id":900,"content":"Abbildung 37.6: Der $(rabatt) Parameter Nun sind wir bereit den Testfallsatz zu starten. Nach der Ausführung der Tests sollten wir mindestens zwei Fehler bekommen. Diese Fehler kommen daher, dass das 'Endpreis' Textfeld natürlich unterschiedliche Werte enthält wir aber immer denselben Wert prüfen. In unserem Fall sollte also der erwartete Wert für das 'Endpreis' Textfeld als zweite Spalte in die 'Datentabelle' eingefügt werden.","hash":"fig_dataDriver20ParamTree","h4":"Abbildung 37.6: Der $(rabatt) Parameter"},"901":{"id":901,"content":"Abbildung 37.7: Vollständige Datentabelle Ein weiterer Nachteil ist, dass wir im HTML Report und im Protokoll immer denselben Testfallnamen sehen. Um dies zu vermeiden, sollten wir die Eigenschaft 'Name für Protokoll und Report' des Testfall Knotens editieren. In dieser Eigenschaft sollten wir zumindest eine datensatz-spezifische Variable verwenden, z.B. 'rabatt' in unserem Fall. Lassen Sie uns dieses Attribut also auf 'Rabattstufe: $(rabatt)' setzen.","hash":"fig_dataDriver20Full","h4":"Abbildung 37.7: Vollständige Datentabelle"},"902":{"id":902,"content":"Abbildung 37.8: Name für Protokoll und Report Eigenschaft Wenn wir den Test nun ausführen, sollten wir keine Fehler mehr erhalten und im Protokoll sowie im HTML Report sollte jeder Testfall einen eigenen Namen haben. Das erzeugte Protokoll sollte folgendermaßen aussehen:","hash":"fig_dataDriver20NRR","h4":"Abbildung 37.8: Name für Protokoll und Report Eigenschaft"},"903":{"id":903,"content":"Abbildung 37.9: Protokoll mit unterschiedlichen Namen für Testfälle Wenn Sie nur einen Testfall mit einem Datensatz ausführen möchten, ohne den gesamten Testfallsatz auszuführen, dann sollten Sie Defaultwerte als globale Variablen des Testsuite Knoten definieren. Wenn der Name der Variable im Datentreiber der selbe ist, wie der des Prozedurparameters, dann können Sie die Variablendefinition beim Prozeduraufruf weglassen. Das kann gemacht werden, weil die Variablen des Datentreiber Knotens auch auf den Variablenstack von QF‑Test gelegt werden und so jeder Schritt innerhalb des Testfall Knotens auf diese Variablen zugreifen kann. Sie können eine solche Implementierung im Testfallsatz 'Datengetriebener Test mit optimierten Prozeduraufrufen' in der Demotestsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/datadrivenTesting.qft sehen. In der Demotestsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/datadrivenTesting.qft finden Sie auch einen Testfallsatz, der eine CSV-Datei als Datenquelle nutzt.","hash":"fig_dataDriver20HTML","h4":"Abbildung 37.9: Protokoll mit unterschiedlichen Namen für Testfälle"},"904":{"id":904,"content":"Zusammenfassung Das Datentreiber Konzept von QF‑Test ermöglicht es dem Benutzer, logische Testfälle zu erstellen und die Testdaten von der eigentlichen Testimplementierung separiert zu halten. Es ist auch möglich, verschachtelte Datentreiber Knoten in Testfälle zu verwenden. Dies kann realisiert werden, indem man einen Testschritt Knoten zu einem Testfall hinzufügt. Der Testschritt Knoten kann dann den Datentreiber beinhalten. Eine detaillierte Beschreibung von datengetriebenem Testen finden Sie im Handbuch im Kapitel Datengetriebenes Testen. In der zweiten mitgelieferten Testsuite qftest-10.0.2-pro/doc/tutorial/datadriver.qft finden Sie weitere Beispiele, wie das Auslesen einer Excel-Datei oder einer Schleife um Testfälle.","hash":"dataDrivenSummary","h1":"Zusammenfassung"},"905":{"id":905,"content":"Pro Tutorial","hash":"","h0":"Abhängigkeiten: Automatisches Sicherstellen der korrekten\n    Vorbedingungen jedes Testfalles | QF‑Test Tutorial"},"906":{"id":906,"content":"Pro Tutorial","hash":"home-link","h0":"Abhängigkeiten: Automatisches Sicherstellen der korrekten\n    Vorbedingungen jedes Testfalles | QF‑Test Tutorial"},"907":{"id":907,"content":"Abhängigkeiten: Automatisches Sicherstellen der korrekten Vorbedingungen jedes Testfalles Video: Abhängigkeiten Dieses Kapitel erklärt das Abhängigkeiten Konzept von QF‑Test. Dieses Konzept ist für die Erstellung robuster Testfälle sowie für das Recovery Management sehr wichtig. Abhängigkeiten wurden eingeführt, um sicherzustellen, dass jeder Testfall mit erfüllten Vorbedingungen laufen kann. Die Beispiele aus diesem Kapitel finden Sie in der Testsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/dependencies.qft. Des weiteren gibt es noch eine zweite Testsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/dependencies_work.qft, die Sie für die Erstellung der Beispiele verwenden können. Bitte achten Sie darauf, dass Sie alle Testsuiten vorher in einen projektspezifischen Ordner kopieren und diese dort modifizieren.","hash":"sec_AdvDeps","h0":"Abhängigkeiten: Automatisches Sicherstellen der korrekten Vorbedingungen jedes Testfalles"},"908":{"id":908,"content":"Einführung Bitte kopieren Sie die Testsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/dependencies_work.qft in ein projektspezifisches Verzeichnis und öffnen diese. Werfen Sie einen Blick auf den ersten Testfallsatz 'Rabattstufen Tests'. Dieser enthält drei Testfall Knoten und eine Vorbereitung, sowie einmal Aufräumen, um das SUT vor jedem Testfall zu starten bzw. zu stoppen. Das ist ein typisches Beispiel, wie Testsuiten in Projekten aussehen können.","hash":"sec_depsGeneral","h1":"Einführung"},"909":{"id":909,"content":"Abbildung 38.1: Erster Testfallsatz von dependencies_work.qft Angenommen, wir wollen nur einen speziellen Testfall starten, weil genau dieser einen Defekt verifiziert oder dieser beim letzten Lauf fehlerhaft war. Dafür müssten wir entweder den gesamten Testfallsatz ausführen oder dafür sorgen, dass alle Vorbedingungen erfüllt sind, d.h. die einzelnen Vorbereitung Knoten müssten manuell ausgeführt werden. Diese Situation passiert sehr häufig, ist allerdings nicht einfach aufzulösen mit den jetzt bekannten Mitteln. Für solche Fälle liefert QF‑Test das Abhängigkeiten Konzept. Es erleichtert die Verwaltung von Vorbedingungen und erlaubt es einen Testfall einzeln zu starten. In diesem Fall wird QF‑Test die Kontrolle über die Sicherstellung der Vorbedingungen übernehmen, also z.B. das SUT starten oder ein Fahrzeugmodell selektieren. Eine Abhängigkeit kann einen Vorbereitung, einen Aufräumen, einen Fehlerbehandlung und einen Catch Knoten beinhalten. Die Vorbereitung einer Abhängigkeit wird vor jedem Testfall ausgeführt, damit immer sichergestellt ist, dass die Vorbedingungen des jeweiligen Testfalles erfüllt sind. Das Sicherstellen der Vorbedingungen ist ein sehr wichtiger Aspekt für eine robuste und stabile Testausführung. Sie können sich eine Situation vorstellen, in der ein Testfall das SUT beendet und daher der darauffolgende Testfall das SUT wieder starten muss. Genau für diese Situationen liefert das Abhängigkeit Konzept eine stabile und attraktive Lösung. Der zweite Aspekt des Abhängigkeiten Konzeptes ist die Optimierung der Testausführung. Mit den bisherigen Mitteln mussten wir das SUT vor jedem Testfall starten und nach jedem Testfall stoppen. Dies ist für kleinere Applikationen wie den CarConfigurator auch kein Problem, aber stellen Sie sich das für eine große Applikation, wie eine Eclipse/RCP Anwendung oder ein ERP System, vor. Hier könnte dieses Vorgehen ziemlich ineffizient werden. Genau deshalb wird bei Abhängigkeiten die Aufräumen nur bei Bedarf ausgeführt. Ein weiterer Vorteil von Abhängigkeiten sind globale Fehlerbehandlung und Catch Knoten für die Implementierung von Recovery Management Schritten. Dieses Feature ist besonders dann wichtig, wenn Sie viele Testfälle hintereinander ausführen und ein fehlerhafter die Ausführung der darauffolgenden behindern kann, z.B. durch das Erscheinen eines modalen Fehlerdialoges wie 'OutOfMemoryException'. Zusammengefasst sind Abhängigkeiten: eine Stelle, um Vorbedingungen eines Testfall zu definieren. sehr nützlich, um Testfälle unabhängiger voneinander zu gestalten. ein besserer Ansatz, um Vorbereitung und Aufräumen Schritte zu implementieren. eine Stelle, um Recoveryschritte im Fehlerfall bzw. beim Auftreten von Exceptions zu definieren. eine Optimierungsmöglichkeit für die Testausführung. wiederverwendbar, da sie im Prozeduren Bereich abgelegt werden können. Die folgenden Abschnitte zeigen, wie man Abhängigkeiten anlegt und benutzt.","hash":"fig_depWorkTestSuite","h4":"Abbildung 38.1: Erster Testfallsatz von dependencies_work.qft"},"910":{"id":910,"content":"Sicherstellen von Vorbedingungen Bitte kopieren Sie die Testsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/dependencies_work.qft in ein projektspezifisches Verzeichnis und öffnen diese, falls Sie das nicht ohnehin schon getan haben sollten. Diese Datei enthält einen Testfallsatz 'Rabatt-Tests' mit drei Testfälle und der herkömmlichen Implementierung von Vorbereitung und Aufräumen Knoten. Wir werden nun in diesen Testfallsatz eine Abhängigkeit einbauen.","hash":"sec_firstDep","h1":"Sicherstellen von Vorbedingungen"},"911":{"id":911,"content":"Abbildung 38.2: Erster Testfallsatz von dependencies_work.qft Zuerst müssen wir einen Abhängigkeit Knoten einfügen. Dies macht man mittels Rechtsklick auf den Testfallsatz und Auswahl von »Knoten einfügen«-»Abhängigkeiten«-»Abhängigkeit«. Geben Sie der Abhängigkeit einen Namen, z.B. \"SUT gestartet\". Der nächste Schritt ist das Verschieben der Vorbereitung und Aufräumen Sequenzen in diese Abhängigkeit. Hierfür müssen Sie den Abhängigkeit Knoten öffnen und die entsprechenden Knoten hineinschieben. Das können Sie entweder via Drag and Drop oder Rechtsklick »Ausschneiden« und »Einfügen« oder mittels Ctrl⁠+⁠X und Ctrl⁠+⁠V. Die Testsuite sollte nun so aussehen:","hash":"fig_depFirstDepWorkTestSuite","h4":"Abbildung 38.2: Erster Testfallsatz von dependencies_work.qft"},"912":{"id":912,"content":"Abbildung 38.3: Beispiel Testsuite mit der ersten Abhängigkeit Jetzt wollen wir die Abhängigkeit testen. Stoppen Sie bitte vorher alle laufenden SUTs. Dann selektieren Sie einen Testfall, z.B. 'Rabattstufe 10' und starten diesen. Sie sollten nun sehen, dass der Testfall ausgeführt wurde und das SUT am Ende des Testlaufes nicht gestoppt wurde. Bitte öffnen Sie das Protokoll um nachzusehen, was genau passiert ist.","hash":"fig_firstDependencySample","h4":"Abbildung 38.3: Beispiel Testsuite mit der ersten Abhängigkeit"},"913":{"id":913,"content":"Abbildung 38.4: Das Protokoll der Ausführung Wenn Sie im Protokoll den Testfall öffnen, dann sehen Sie einen 'Abhängigkeiten auflösen'-Knoten. Wenn Sie diesen öffnen, werden Sie zwei weitere Knoten sehen. Der letzte der beiden Knoten zeigt Ihnen, dass die Vorbereitung Sequenz ausgeführt wurde. Der erste Knoten wird im nächsten Beispiel erklärt. Bis jetzt haben wir gesehen, dass die Vorbereitung Sequenz automatisch vor dem Testfall ausgeführt wird. Jedoch wurde Aufräumen noch nicht ausgeführt. Wenn Sie jetzt einen weiteren Testfall starten, z.B. 'Rabattstufe 15', wird dieser auf der bereits gestarteten Anwendung ausgeführt. Die Vorbereitung einer Abhängigkeit wird auf jeden Fall vor jedem Testfall ausgeführt. Dies geschieht um die Vorbedingungen jedes einzelnen Testfall's sicherzustellen. Das Aufräumen einer Abhängigkeit wird nur bei Bedarf ausgeführt, d.h. nur dann, wenn die Schritte der Vorbereitung nicht mehr benötigt werden. In unserem Fall wurde das Aufräumen nicht ausgeführt, weil beide Testfälle dieselbe Abhängigkeit haben. Die Testausführung liefert allerdings keine Fehler, weil die Prozedur startStop.starteApplikation bereits prüft, ob das SUT überhaupt gestartet werden soll.","hash":"fig_firstDepSampleRunLog","h4":"Abbildung 38.4: Das Protokoll der Ausführung"},"914":{"id":914,"content":"Abbildung 38.5: Prozedur startStop.starteApplikation Der nächste Schritt ist, den gesamten Testfallsatz mittels Klick auf 'Wiedergabe starten' auszuführen. Alle drei Testfälle sollten erfolgreich durchgelaufen sein und das SUT sollte auch nicht zwischen den Ausführungen gestoppt worden sein. Wir haben also auch die Testausführung optimiert. Die Aufräumen wurde nicht ausgeführt, da alle drei Testfälle auf dieselbe Abhängigkeit verweisen. Somit sieht unsere Testumgebung auch mehr nach einer realen Umgebung aus, da die wenigsten Benutzer das SUT nach jeder Aktion neu starten werden. Das nächste Ziel ist, unsere Abhängigkeit für andere Testfallsätze unseres Projektes verfügbar zu machen. Hierfür müssen wir die Abhängigkeit in den Prozeduren Bereich verschieben. Danach müssen wir auf den Testfallsatz klicken und eine Bezug auf Abhängigkeit einfügen. Dies macht man mittels Rechtsklick und Auswahl von »Knoten einfügen«-»Abhängigkeiten«-»Bezug auf Abhängigkeit«. Der erscheinende Dialog sieht dann dem Prozeduraufruf Dialog ziemlich ähnlich. Wählen Sie die gerade verschobene Abhängigkeit aus. Die Testsuite sollte nun wie folgt aussehen:","hash":"fig_firstDepSampleStart","h4":"Abbildung 38.5: Prozedur startStop.starteApplikation"},"915":{"id":915,"content":"Abbildung 38.6: Die Testsuite mit Bezug auf Abhängigkeit Wir empfehlen alle Abhängigkeiten in ein separates Package 'abhängigkeiten' zu schieben. Wenn Sie nun den Testfallsatz ausführen, wird bei der ersten Ausführung nach Verschieben der Abhängigkeit das SUT gestoppt und das SUT wiederum gestartet. Das passiert, weil die Abhängigkeit in den Prozeduren Bereich verschoben wurde und es deshalb eine andere Abhängigkeit ist als vorher. Werfen Sie nun einen Blick auf den zweiten Testfallsatz der Demotestsuite 'Rabatt-Tests mit Stoppen des SUT'. Der zweite Testfall 'Rabattstufe 10' stoppt das SUT, jedoch benötigt der dritte Testfall 'Rabattstufe 15' auch ein laufendes SUT. Wie wir in diesem Abschnitt gelernt haben, wird das Abhängigkeiten Konzept dafür Sorge tragen, dass das SUT vor dem dritten Testfall ausgeführt wird. Dieses Beispiel sollte noch einmal die Vorteile von Abhängigkeiten verdeutlichen.","hash":"fig_firstDepSampleDepRef","h4":"Abbildung 38.6: Die Testsuite mit Bezug auf Abhängigkeit"},"916":{"id":916,"content":"Abbildung 38.7: Sicherstellen der Vorbedingungen für Testfall 'Rabattstufe 15'","hash":"fig_firstDepEnsuringPreReqs","h4":"Abbildung 38.7: Sicherstellen der Vorbedingungen für Testfall 'Rabattstufe 15'"},"917":{"id":917,"content":"Verschachtelte Abhängigkeiten Verwalten von Vorbedingungen kann ein durchaus komplexeres Thema werden, als dass wir nur Sicherstellen, ob das SUT gestartet wurde oder nicht. In vielen Projekten gibt es verschiedene Gruppen von Testfällen mit unterschiedlichen Vorbedingungen. Nehmen wir an, dass wir ein großes ERP System mit mehreren Perspektiven, wie 'Anbieter' und 'Artikel' testen möchten. Jeder Testfall für die 'Anbieter' Perspektive bezieht sich darauf, dass die 'Anbieter' Perspektive auch geöffnet ist. Genauso verhält es sich bei allen Tests für die 'Artikel' Perspektive. Das Öffnen der jeweiligen Perspektive hängt wiederum vom eingeloggten Benutzer ab, und das Einloggen basiert auf einem gestarteten SUT. Sie sehen also, es gibt so etwas wie einen Baum von Vorbedingungen. QF‑Test ermöglicht es dem Benutzer, solch verschachtelte Abhängigkeit Knoten zu erstellen. Hierfür muss man Bezug auf Abhängigkeit Knoten zu einer Abhängigkeit hinzufügen. Wir werden nun ein kleines Beispiel mit zwei verschachtelten Abhängigkeiten für den CarConfigurator bauen. Im CarConfigurator können Sie den 'Fahrzeuge' Dialog mittels der Menüaktion 'Einstellungen' -> 'Fahrzeuge' öffnen. Wir wollten jetzt Tests für diesen Dialog erstellen. Später werden wir auch Tests für den 'Zubehör' Dialog erstellen, welcher auch über das Menü mittels 'Einstellungen' -> 'Zubehör' geöffnet werden kann. Zuerst definieren wir die Tests, welche wir erstellen wollen. Testfall 1: Anlegen des Modells 'test1' mit Preis '100'. Starten des SUT, falls notwendig. Fahrzeugdialog öffnen. Name 'test1' und Preis '100' setzen. 'Neu' klicken. Den Dialog mittels 'OK' schließen. Den Fahrzeugdialog nochmal öffnen. Das angelegte Modell 'test1' selektieren. Den Dialog mit 'Abbrechen' schließen. Das SUT stoppen, falls notwendig. Testfall 2: Anlegen des Modells 'test2' mit Preis '99999'. Start des SUT, falls notwendig. Fahrzeugdialog öffnen. Name 'test2' und Preis '99999' setzen. 'Neu' klicken. Den Dialog mittels 'OK' schließen. Den Fahrzeugdialog nochmal öffnen. Das angelegte Modell 'test2' selektieren. Den Dialog mit 'Abbrechen' schließen. Das SUT stoppen, falls notwendig. Testfall 3: Anlegen des Zubehöres 'testzubehör' mit Preis '12'. Start des SUT, falls notwendig. Zubehördialog öffnen. Name 'testzubehör' und Preis '12' setzen. 'Neu' klicken. Den Dialog mittels 'OK' schließen. Den Zubehördialog nochmal öffnen. Das angelegte Zubehörteil 'testzubehör' selektieren. Den Dialog mit 'Abbrechen' schließen. Das SUT stoppen, falls notwendig. Wenn wir uns nun die Testschritte der oben definierten Testfälle genauer anschauen, sehen wir, dass jeder Testfall ein laufendes SUT benötigt. Daher sollten wir eine Abhängigkeit 'SUT gestartet' implementieren. Das Stoppen des SUT ist ein optionaler Schritt, der innerhalb des Aufräumen Knotens dieser Abhängigkeit implementiert werden kann. Diese Abhängigkeit haben wir schon im vorigen Beispiel erstellt und können diese also wiederverwenden. Der nächste Punkt ist, dass sowohl Testfall 1 wie auch Testfall 2 einen geöffneten Fahrzeugdialog benötigen. Da wir weitere Tests in diesem Bereich planen, sollten wir eine Abhängigkeit 'Fahrzeugdialog geöffnet' erstellen. Diese sollte in der Vorbereitung das Öffnen des Dialoges und in der Aufräumen das Schließen mittels 'Abbrechen' beinhalten. Wir können diesen Dialog nur dann öffnen, wenn das SUT bereits läuft, deshalb ist diese Abhängigkeit auch von der Abhängigkeit 'SUT gestartet' abhängig. Die Implementierung der 'Fahrzeugdialog geöffnet' Abhängigkeit sieht wie folgt aus:","hash":"sec_depCombine","h1":"Verschachtelte Abhängigkeiten"},"918":{"id":918,"content":"Abbildung 38.8: 'Fahrzeugdialog geöffnet' Abhängigkeit In der Vorbereitung müssen wir prüfen, ob der Dialog bereits geöffnet wurde. Es könnte nämlich sein, dass ein voriger Testfall den Dialog bereits geöffnet und nicht mehr geschlossen hat. Das Attribut 'Wartezeit' des Warten auf Komponente Knotens steht hier auf '0', weil wir erwarten, dass der Dialog offen sein soll, wenn nicht, dann muss dieser ohnehin geöffnet werden. Wir sollten auch eine Abhängigkeit 'Zubehördialog geöffnet' erstellen, welche ähnlich zur 'Fahrzeugdialog geöffnet' Abhängigkeit, den Zubehördialog öffnet. Nach Erstellen der Abhängigkeiten müssen wir nun die entsprechenden Testschritte aufzeichnen und die Testfälle erstellen. Die Testschritte wurden schon erstellt und können als Prozeduren in der entsprechenden Dialog Packages Struktur gefunden werden. Die Testfälle sollten in einem Testfallsatz namens 'Verschachtelte Abhängigkeiten' zusammengefasst erstellt werden. Dieser Testfallsatz sollte zwei weitere Testfallsatz beinhalten. Das erste ist 'Tests für den Fahrzeugdialog', das zweite 'Tests für den Zubehördialog'. Der Testfallsatz 'Tests für den Fahrzeugdialog' beinhaltet die Implementierungen der Testfälle 1 und 2, sowie eine Bezug auf Abhängigkeit auf die 'Fahrzeugdialog geöffnet' Abhängigkeit. Der zweite Testfallsatz 'Tests für den Zubehördialog' beinhaltet die Implementierung des Testfalles 3 und eine Bezug auf Abhängigkeit auf die Abhängigkeit 'Zubehördialog geöffnet'.","hash":"fig_depVehicleDialog","h4":"Abbildung 38.8: 'Fahrzeugdialog geöffnet' Abhängigkeit"},"919":{"id":919,"content":"Abbildung 38.9: Implementierung der Testfälle Wenn Sie nun den obersten Testfallsatz starten, werden Sie sehen, dass QF‑Test das SUT zuerst stoppt, das kommt von der Abhängigkeit des vorherigen Beispieles. Danach wird das SUT gestartet und es werden die Schritte von Testfall 1 und Testfall 2 ausgeführt und schlussendlich die Schritte von Testfall 3. Wenn Sie im Protokoll einen genaueren Blick auf den Anfang von Testfall 3 werfen, dann werden Sie sehen, dass auch die Aufräumen der 'Fahrzeugdialog geöffnet' Abhängigkeit ausgeführt wurde. Dies passierte, weil die Abhängigkeit 'Fahrzeugdialog geöffnet' nicht mehr benötigt wurde. Testfall 3 hat allerdings die 'Zubehördialog geöffnet' Abhängigkeit benötigt und hat deshalb deren Vorbereitung durchlaufen. Da diese beiden Abhängigkeiten auf der 'SUT gestartet' Abhängigkeit aufbauen, wurde deren Aufräumen Sequenz nicht ausgeführt.","hash":"fig_depVehiclesAccessoriesTest","h4":"Abbildung 38.9: Implementierung der Testfälle"},"920":{"id":920,"content":"Abbildung 38.10: Protokoll von verschachtelten Abhängigkeiten Das Verschachteln von Abhängigkeiten und die Möglichkeit, eine Aufräumen Sequenz nur bei Bedarf aufzurufen, ermöglichen Ihnen relativ viele vor- und nachbereitende Schritte in eine Abhängigkeit zu packen. Ein anderer Anwendungsfall für den CarConfigurator könnte eine Abhängigkeit 'Fahrzeug angelegt' sein, welche sicherstellt, dass das verwendete Fahrzeug vorher angelegt wird.","hash":"fig_depRunLogDepCombine","h4":"Abbildung 38.10: Protokoll von verschachtelten Abhängigkeiten"},"921":{"id":921,"content":"Fehler- und Exceptionbehandlung","hash":"sec_depErrorAndCatch","h1":"Fehler- und Exceptionbehandlung"},"922":{"id":922,"content":"Fehlerbehandlung Bitte kopieren Sie die Testsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/dependencies_work.qft in ein projektspezifisches Verzeichnis und öffnen diese, falls Sie das nicht ohnehin schon getan haben sollten. Dort finden Sie einen Testfallsatz 'Tests mit Fehlerbehandlung'. Der zweite Testfall ist fehlerhaft.","hash":"sec_depErrorHandler","h2":"Fehlerbehandlung"},"923":{"id":923,"content":"Abbildung 38.11: Testsuite für Fehlerbehandlung Angenommen wir wollen bestimmte Aktionen auslösen, die nach einem fehlerhaften Testfall ausgeführt werden sollen. In unserem Fall könnten wir im Fehlerfall einfach das SUT stoppen. Dies könnte notwendig sein, um zu garantieren, dass die folgenden Testfälle auf einer sauberen Umgebung aufsetzen können. Wir wissen bis jetzt, dass die Vorbereitung Sequenz vor jedem Testfall ausgeführt wird und die Aufräumen nur bei Bedarf ausgeführt wird. Aber wie können wir jetzt diese spezielle Fehlerbehandlung implementieren? Die Lösung ist der so genannte Fehlerbehandlung Knoten für eine Abhängigkeit. Wenn Sie auf die geschlossene Aufräumen Sequenz klicken, können Sie mit Rechtsklick »Knoten einfügen«-»Abhängigkeiten«-»Fehlerbehandlung«. Im Fehlerbehandlung Knoten können Sie die Schritte für das Stoppen des SUT aufrufen. Die Abhängigkeit SUT gestartet sollte nun wie folgt aussehen:","hash":"fig_depErrorTestSuite","h4":"Abbildung 38.11: Testsuite für Fehlerbehandlung"},"924":{"id":924,"content":"Abbildung 38.12: Abhängigkeit mit Fehlerbehandlung Führen Sie nun den gesamten Testfallsatz 'Tests mit Fehlerbehandlung' aus und öffnen Sie das Protokoll nachdem die Ausführung abgeschlossen ist. Im Protokoll können Sie sehen, dass der Fehlerbehandlung Knoten nach dem zweiten Testfall ausgeführt wurde.","hash":"fig_depErrorHandlerSample","h4":"Abbildung 38.12: Abhängigkeit mit Fehlerbehandlung"},"925":{"id":925,"content":"Abbildung 38.13: Protokoll einer Abhängigkeit mit Fehlerbehandlung","hash":"fig_depErrorHandlerSample2","h4":"Abbildung 38.13: Protokoll einer Abhängigkeit mit Fehlerbehandlung"},"926":{"id":926,"content":"Exception Behandlung Im vorigen Abschnitt haben wir gelernt, dass man mit Fehlerbehandlung Knoten Schritte definieren kann, welche bei fehlerhaften Testfälle ausgeführt werden. Neben Fehlern können allerdings auch Exceptions beim Testlauf auftreten. Eine Exception ist ein unerwartetes Verhalten während der Testausführung, z.B. ein Dialog erscheint und blockiert die Ausführung oder eine Komponente konnte nicht gefunden werden. Wie soll man mit solchen Exceptions umgehen? In der Demotestsuite dependencies_work.qft finden Sie ein Beispiel Testfallsatz namens 'Tests mit Exception'. Natürlich können Sie entsprechende Testschritte mit einem Try-Catch umrunden und eine dedizierte Exceptionbehandlung in jedem Testfall implementieren. Im Beispiel Testfallsatz wurde dies so implementiert. Dieser Ansatz kann jedoch zu viel Redundanz führen und die Testfälle werden noch unleserlicher.","hash":"sec_depCatch","h2":"Exception Behandlung"},"927":{"id":927,"content":"Abbildung 38.14: Try-Catch Knoten in Testfälle Unser Ziel ist es nun, die Redundanz in den Testfällen zu reduzieren und die einheitliche Exceptionbehandlung an eine zentrale Stelle zu verschieben. Diese zentrale Stelle wird unsere Abhängigkeit sein. Der erste Schritt hierfür ist das Einfügen des Catch Knotens in eine Abhängigkeit. Hierzu müssen Sie auf dem geschlossenen Fehlerbehandlung Knoten einen Rechtsklick ausführen und »Knoten einfügen«-»Ablaufsteuerung«-»Catch« einfügen. Danach können wir die Schritte aus einem der Catch Knoten in den neuen Knoten verschieben und in den Testfälle die Prozeduraufrufe aus dem Try Block herausziehen und den Try Block dann löschen. Die Testsuite sieht nun so aus:","hash":"fig_depCatchTryEachTest","h4":"Abbildung 38.14: Try-Catch Knoten in Testfälle"},"928":{"id":928,"content":"Abbildung 38.15: Testsuite mit Catch Nun können Sie den Testfallsatz 'Tests mit Exception' starten. Der zweite Testfall wirft eine IndexNotFoundException, weil das ausgewählte Modell nicht existiert. Diese Exception sollte nun vom globalen Catch Knoten der Abhängigkeit behandelt werden. Wenn Sie den Debugger aktiviert haben, wird QF‑Test den Testlauf an der Stelle unterbrechen, wo die Exception auftritt. In unserem Fall können Sie dann die Exception mit dem Knopf 'Exception erneut werfen' weiterwerfen oder den Debugger mittels dem Menüeintrag »Debugger«-»Debugger aktivieren« deaktivieren. Öffnen Sie nach der Ausführung das Protokoll um nachzusehen, was passiert ist.","hash":"fig_depCatchTestSuite","h4":"Abbildung 38.15: Testsuite mit Catch"},"929":{"id":929,"content":"Abbildung 38.16: Protokoll der Ausführung Abhängigkeit mit Catch In einem normalen Projekt sollten Sie mindestens einen solchen global Catch Knoten für 'TestException' erstellen. Dieser Knoten sollte dann auch entweder die Prozedur qfs.swing.cleanup.closeAllModalDialogs oder die Prozedur qfs.swt.cleanup.closeAllModalDialogsAndModalShells aufrufen. Diese Prozeduren schließen jeglichen modalen Dialog, d.h. jedes Fenster, das die Ausführung der Tests blockieren könnte.","hash":"fig_depRunLogCatchDep","h4":"Abbildung 38.16: Protokoll der Ausführung Abhängigkeit mit Catch"},"930":{"id":930,"content":"Zusammenfassung Sie haben nun gesehen, dass man ein robustes Recovery Management für Testfälle mittels Fehlerbehandlung und noch mehr mittels Catch Knoten für eine Abhängigkeit implementieren kann. In den meisten Projekten ist ein globaler Catch Knoten sehr wichtig, besonders im Falle von ComponentNotFoundExceptions und ModalDialogExceptions.","hash":"sec_depErrorCatchSum","h2":"Zusammenfassung"},"931":{"id":931,"content":"Mehr zu Abhängigkeiten Im oberen Bereich haben wir gesehen, dass man verschiedene Abhängigkeiten verschachteln kann und dass die Aufräumen Sequenz einer Abhängigkeit nur dann ausgeführt wird, wenn die entsprechende Abhängigkeit nicht mehr benötigt wird. Wir können eine Abhängigkeit auch so konfigurieren, dass die Aufräumen jedes mal ausgeführt wird. Das kann mittels Setzens der Option 'Aufräumen erzwingen' der Abhängigkeit bewerkstelligt werden. Es gibt noch viel mehr Interessantes über Abhängigkeiten zu entdecken, z.B. kann man die Ausführung der Aufräumen auch mittels Variablen steuern. Diese Variable heißt charakteristische Variable. Diese und mehr Details finden Sie im Handbuch im Kapitel Abhängigkeiten. Dieser Ansatz könnte verwendet werden, um eine Abhängigkeit 'Login' zu erstellen, deren Aufräumen, d.h. das Ausloggen, nur dann ausgeführt wird, wenn sich der Inhalt der Variable Benutzer ändert. Eine detaillierte Beschreibung von Abhängigkeiten finden Sie im Handbuch im Kapitel Abhängigkeiten.","hash":"sec_depMoreDep","h1":"Mehr zu Abhängigkeiten"},"932":{"id":932,"content":"Pro Tutorial","hash":"","h0":"Automatische Erstellung von Basisprozeduren | QF‑Test Tutorial"},"933":{"id":933,"content":"Pro Tutorial","hash":"home-link","h0":"Automatische Erstellung von Basisprozeduren | QF‑Test Tutorial"},"934":{"id":934,"content":"Automatische Erstellung von Basisprozeduren Dieses Kapitel beschreibt, wie man mit QF‑Test Prozeduren für die GUI Elemente automatisch erzeugen kann. Der Vorteil dieser Technik ist, dass man nicht mehr jeden Schritt des Tests einzeln aufzeichnen muss. Darüber hinaus wird auch eine standardisierte Package und Prozeduren Struktur bereitgestellt. Sie finden die fertiggestellten Beispiele in der Datei qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/automated_procedures.qft . Es gibt auch noch eine zweite Testsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/automated_procedures_work.qft für Ihre eigenen Implementierungen. Bitte achten Sie darauf, dass Sie alle Testsuiten vorher in einen projektspezifischen Ordner kopieren und diese dort modifizieren.","hash":"sec_AdvProcbuilder","h0":"Automatische Erstellung von Basisprozeduren"},"935":{"id":935,"content":"Einführung Wenn wir für alle Features des CarConfigurator Tests erstellen wollen, so müssen wir auch Aktionen für jedes involvierte GUI Element aufzeichnen. Der CarConfigurator ist eine kleine Applikation mit vielleicht fünf Dialogen und ca. dreißig GUI Elementen. Das Erstellen der wichtigsten Testfälle für diese Applikation wird ein bis zwei Tage dauern. Aber stellen Sie sich ein großes Projekt vor, wie ein ERP System mit über fünfzig Dialogen und hunderten von GUI Elementen. Hier wird das Erstellen der Testfälle erheblich länger dauern und ebenso könnte die Wartung der Tests schwieriger werden. Als ersten organisatorische Schritt empfehlen wir, jeden Testschritt als Prozedur zu erstellen und diese dann von den entsprechenden Testfälle aufzurufen. Wenn Sie Ihre Tests in unterschiedlichen Testsuiten organisieren, dann könnten Sie diese in zwei Schichten aufteilen. Die erste Schicht enthält nur GUI-Komponenten bezogene Prozeduren und die zweite Schicht beinhaltet nur Testfälle, welche die Prozeduren der ersten Schicht aufrufen. Der Ansatz jeden Testschritt als Prozedur zu implementieren bringt uns in die Lage, unsere Arbeit in zwei Bereich aufzuteilen: Erstellung und Wartung von Prozeduren, welche die Testschritte repräsentieren Erstellung und Wartung von Testfällen QF‑Test liefert nun ein Feature, das diese Basisprozeduren für GUI Elemente automatisch erstellt. Wenn Sie dieses Feature benutzen, reduziert sich der Erstellungsaufwand für Testsuiten und Testfälle drastisch und es unterstützt Sie in der Erstellung wartbarer Testsuiten. Sie finden in der Demotestsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/automated_procedures.qft einige Testfälle, die mit diesem Feature erstellt worden sind.","hash":"sec_apbGeneral","h1":"Einführung"},"936":{"id":936,"content":"Abbildung 39.1: Bildschirmabbild der Testsuite Die folgenden Abschnitte beschreiben nun, wie man diese Prozeduren erstellt und die Testfälle organisiert.","hash":"fig_advPbTestSuite","h4":"Abbildung 39.1: Bildschirmabbild der Testsuite"},"937":{"id":937,"content":"Automatische Erstellung von Prozeduren Bitte kopieren Sie die Demotestsuite qftest-10.0.2-pro/doc/tutorial/advanced-demos/de/automated_procedures_work.qft in ein projektspezifisches Verzeichnis und öffnen diese dort. Diese Datei enthält einen Testfallsatz, der sich auf die Abhängigkeit 'Start SUT' bezieht.","hash":"sec_abpCreation","h1":"Automatische Erstellung von Prozeduren"},"938":{"id":938,"content":"Abbildung 39.2: Die Testsuite automated_procedures_work.qft Zuerst müssen wir das SUT starten. Hierfür selektieren Sie die Abhängigkeit und drücken auf 'Wiedergabe starten'. Sobald das SUT läuft, können wir die Testschritte aufzeichnen. Normalerweise würden wir jetzt auf 'Aufnahme starten' klicken, die entsprechenden Schritte aufzeichnen und dann die Aufnahme mit 'Aufnahme beenden' stoppen. Danach würden wir die Aufnahme reorganisieren, d.h. Prozeduren erstellen und diese parametrisieren. Genau diese Schritte können jetzt automatisiert erfolgen. Wir werden jetzt zuerst die Basisprozeduren für das Hauptfenster erstellen. Bevor wir loslegen, müssen wir allerdings die Konfiguration von QF‑Test anpassen. Öffnen Sie die Optionen mittels »Bearbeiten«-»Optionen«. Dann wechseln Sie nach 'Aufnahme' -> 'Prozeduren'. Dort ändern Sie den Wert von 'Konfigurationsdatei für die Prozedurenaufnahme' auf den Pfad unserer Demokonfigurationsdatei nämlich qftest-10.0.2-pro/demo/procbuilder/carconfig-procbuilderdef.qft. Danach klicken Sie auf 'OK'. Details über diese Datei erfahren Sie im nächsten Abschnitt. Nachdem Sie die Konfiguration geändert haben, fahren Sie mit folgenden Schritten fort: Drücken Sie den 'Prozeduren erstellen' Knopf Klicken Sie mit der rechten Maustaste auf das SUT Wählen Sie 'Ganzes Fenster' aus Drücken Sie den 'Prozeduren erstellen' Knopf nochmals. Jetzt erstellt QF‑Test die Basisprozeduren für das Hauptfenster. Sie sollten nun unter Prozeduren ein Package namens procbuilder sehen. Dieses Package enthält weitere Packages und Prozeduren, die Aktionen für die einzelnen GUI Elemente und den gesamten Dialog beinhalten. Die aktuelle Konfiguration erstellt das Package JCarConfigurator als Container für alle Prozeduren innerhalb des Hauptfensters.","hash":"fig_autoProcSuite","h4":"Abbildung 39.2: Die Testsuite automated_procedures_work.qft"},"939":{"id":939,"content":"Abbildung 39.3: Die aufgezeichneten Prozeduren Beachten Sie, dass die involvierten Komponenten auch unter Fenster und Komponenten aufgezeichnet worden sind. Der nächste Schritt ist das Prüfen, ob die erstellten Prozeduren für uns nützlich oder einige überflüssig sind. Werfen wir nun einen genaueren Blick auf die erstellten Packages:","hash":"fig_autoProcFirstRecord","h4":"Abbildung 39.3: Die aufgezeichneten Prozeduren"},"940":{"id":940,"content":"Package Inhalt JCarConfigurator Dieses Package beinhaltet alle Prozeduren für Aktionen auf Komponenten des JCarConfigurator Fensters. Dieses Package wurde aufgrund der aktuellen Konfiguration erstellt, welches die Hierarchie der Komponenten beachtet. Tabelle 39.1: Das Package JCarConfigurator enthält folgende Packages:","hash":"table_39.1","h4":"Abbildung 39.3: Die aufgezeichneten Prozeduren"},"941":{"id":941,"content":"Package Inhalt MenuBar Dieses Package enthält alle Prozeduren für Aktionen auf Menüeinträge des SUT. In unserem Fall finden wir hier nur Prozeduren für das Klicken auf die einzelnen Menüeinträge. VehicleTablePanel Dieses Package enthält alle Prozeduren für Aktionen auf Komponenten auf den 'VehicleTablePanel' Panel des SUT. In unserem Fall finden wir hier nur Prozeduren für das Objekt 'VehicleTable', weil es die einzige Komponente auf diesem Panel ist. check Dieses Package enthält Prozeduren um Komponenten zu prüfen. check-window Dieses Package enthält Prozeduren um die alle Komponenten eines Fenster zu prüfen. Dies ist eine Containerprozedur. get Dieses Package beinhaltet Prozeduren um Werte von Elementen auszulesen und zurückzuliefern, z.B. das Auslesen eines Textes. select Dieses Package beinhaltet Prozeduren um Elemente auszuwählen. In unserem Fall gibt es eine Prozedur um einen Tab des TabbedPanes auszuwählen. set Dieses Package beinhaltet Prozeduren um Komponenten zu setzen. In unserem Fall sind das Setzmethoden für die Textfelder. set-window Dieses Package beinhaltet Prozeduren um alle Komponenten des Fensters mittels einen Prozeduraufrufes zu setzen. In unserem Fall ruft die erstellte Prozedur alle 'set' Prozeduren des JCarConfigurator Fensters auf. Diese Containerprozedur ist auch eine typische Workflowprozedur. wait Dieses Package beinhaltet alle Prozeduren, um auf diverse Komponenten zu warten. Tabelle 39.2: In unserem Fall sind alle Prozeduren nützlich. Wir können also das gesamte JCarConfigurator Package aus dem procbuilder Package direkt unter Prozeduren verschieben. Bitte vergessen Sie nicht beim 'Referenzen aktualisieren' Dialog auf 'Ja' zu klicken. Jetzt können die Prozeduren von Testfällen genutzt werden. Schlussendlich sieht unsere Testsuite so aus:","hash":"table_39.2","h4":"Abbildung 39.3: Die aufgezeichneten Prozeduren"},"942":{"id":942,"content":"Abbildung 39.4: Die Testsuite mit den Prozeduren Wiederholen Sie nun diese Aufnahme für das 'Sondermodelle' und das 'Zubehör' Panel. Sie müssen dann nur noch die neuen Prozeduren und Packages in das 'JCarConfigurator' Package verschieben. In unserem Fall sind das nur die Packages 'SpecialsPanel' und 'AccessoryTablePanel'. Die vollständige Testsuite sieht nun so aus:","hash":"fig_autoProcTestSuite1","h4":"Abbildung 39.4: Die Testsuite mit den Prozeduren"},"943":{"id":943,"content":"Abbildung 39.5: Die Prozeduren für alle Panels Nun können wir wirklich die Testfälle mit den automatisch generierten Prozeduren erstellen. Sie können natürlich vorher noch Prozeduren für alle Dialoge, z.B. den 'Fahrzeug' Dialog erzeugen. Diesen Dialog erreichen Sie im SUT mittels 'Optionen' -> 'Fahrzeuge'. Ebenso gilt dies für den 'Sondermodelle' und 'Zubehör' Dialog. Sie müssen nicht immer das gesamte Fenster aufzeichnen. Sie können auch durch Auswahl von 'Nur Komponente' Prozeduren für eine bestimmte Komponente generieren oder mittels 'Komponente mit Kindern' Prozeduren für ein gesamtes Panel erzeugen.","hash":"fig_autoProcTestSuite2","h4":"Abbildung 39.5: Die Prozeduren für alle Panels"},"944":{"id":944,"content":"Konfiguration der automatischen Erstellung","hash":"sec_apbConf","h1":"Konfiguration der automatischen Erstellung"},"945":{"id":945,"content":"Einführung Im vorigen Beispiel haben wir die Datei qftest-10.0.2-pro/demo/procbuilder/carconfig-procbuilderdef.qft als Konfigurationsdatei für die automatische Generierung benutzt. In diesem Abschnitt wollen wir uns die Konfigurationsmöglichkeiten von QF‑Test genauer ansehen. Öffnen Sie hierzu diese Datei.","hash":"sec_apbConfIntro","h2":"Einführung"},"946":{"id":946,"content":"Abbildung 39.6: Die aktuelle Konfiguration Das Package procbuilder ist das Wurzelpackage für alle erstellten Packages. Wenn Sie einen anderen Namen für dieses Package verwenden wollen, können Sie dieses einfach umbenennen. Wenn Sie dieses Package öffnen, dann sehen Sie die 'Klassen' Ebene. Diese Ebene beschreibt die Klassen der GUI-Komponente, welche für die Erstellung berücksichtigt werden sollen. Die nächste Ebene beinhaltet dann die Informationen über die zu erstellende Packagestruktur und deren Prozeduren. Sie können eine detaillierte Beschreibung im Handbuch im Kapitel Die Procedure Builder Definitionsdatei finden.","hash":"fig_apbConfiguration","h4":"Abbildung 39.6: Die aktuelle Konfiguration"},"947":{"id":947,"content":"Erstes Beispiel In unserem ersten Beispiel wollen wir eine neue Konfigurationsdatei erstellen, welche wir selbst Schritt für Schritt aufbauen. Bitte führen Sie folgende Schritte durch: Öffnen Sie eine neue Testsuite und speichern diese. Geben Sie der Testsuite einen Namen, wie 'mySettings.qft'. Erstellen Sie ein neues Package mit dem Namen 'myProcedures'. Bis jetzt sieht die neue Testsuite folgendermaßen aus:","hash":"sec_apbFirstExample","h2":"Erstes Beispiel"},"948":{"id":948,"content":"Abbildung 39.7: Die eigene Konfigurationsdatei Jetzt sind wir bereit die Prozedurenvorlagen für spezielle Klassen zu erstellen. Wir sollten zuerst Prozeduren für Textfelder des Hauptfensters erstellen. In unserem Projekt könnte es interessant sein, den Inhalt der Textfelder zu prüfen, daher brauchen wir Prozeduren hierfür. Um diese Prozeduren zu erstellen, müssen wir ein Package unter 'myProcedures' anlegen. Dieses Package sollte den Namen 'javax_swing_JTextField' haben. 'javax.swing.JTextField' ist die Klasse aller Textfelder, allerdings ist ein '.' nicht in Packagenamen erlaubt, deshalb ersetzen wir diesen mit '_'. Dieses Package wird QF‑Test nun instruieren, Prozeduren für eine Komponente zu erstellen, sobald diese von der entsprechenden Klasse ist. Das ist sehr wichtig, damit wir unsere Prozedurvorlagen auf Klassenebene definieren können. Nun erstellen wir eine Vorlage für die eigentliche Prüfprozedur der Komponenten. Die Prozedurvorlage sollte allerdings noch Teil eines weiteren Packages sein. Der Name des Packages sollte die Gruppe der Prozeduren bezeichnen, z.B. 'checkers'. Nach Erstellung des 'checkers' Package, sollten Sie eine Prozedur 'checkText' zu diesem Package hinzufügen. Die Prozedur sollte einen Knoten 'Check Text' beinhalten, welcher zum Prüfen von Texten geeignet ist. Bitte fügen Sie diesen 'Check Text'-Knoten mittels Rechtsklick und Auswahl von 'Knoten einfügen' -> 'Check-Knoten' -> 'Check Text' ein. Setzen Sie das Attribut 'client' auf $(client), das Attribut QF‑Test component ID auf 'dummy' und das Attribut 'text' auf $(text). Nach dem Bestätigen dieser Eingaben werden wir selbstverständlich eine Warnung erhalten, in der wir darauf hingewiesen werden, dass eine Komponente namens 'dummy' nicht existiert. Diese Warnung dürfen wir an dieser Stelle ignorieren. Die Testsuite sieht nun wie folgt aus:","hash":"fig_apbOwnConf1","h4":"Abbildung 39.7: Die eigene Konfigurationsdatei"},"949":{"id":949,"content":"Abbildung 39.8: Die checkText Prozedur Die Prozedur sollte einen Parameter 'text' mit einem leeren Standardwert beinhalten.","hash":"fig_apbOwnConfProc","h4":"Abbildung 39.8: Die checkText Prozedur"},"950":{"id":950,"content":"Abbildung 39.9: Die checkText Prozedur mit Parametern Die erste Prozedurvorlage ist nun fast vollständig, jetzt müssen wir uns allerdings noch über einen Aspekt Gedanken machen. Jede Komponente hat ihre eigene und eindeutige QF‑Test ID, also wäre es praktisch, wenn diese QF‑Test ID bereits bei der Erstellung berücksichtigt wird, anstatt diese manuell nachzupflegen. Außerdem wollen wir, dass die Prozeduren komponentenbezogene Namen aufweisen statt einfach nur 'checkText'. Der Platzhalter <COMPID> steht in QF‑Test für die QF‑Test ID der aktuellen Komponente. Also müssen wir den Prozedurnamen in checkText_<COMPID> ändern. Wir sollten auch den Platzhalter <COMPID> direkt in das Attribut QF‑Test component ID des 'Check Text'-Knotens einfügen. Schlußendlich sieht unsere Prozedurvorlage wie folgt aus:","hash":"fig_apbOwnConfParams","h4":"Abbildung 39.9: Die checkText Prozedur mit Parametern"},"951":{"id":951,"content":"Abbildung 39.10: Der <COMPID> Platzhalter Jetzt können wir unsere eigene Konfigurationsdatei verwenden. Hierfür müssen wir QF‑Test noch mitteilen, dass diese Datei verwendet werden soll. Öffnen Sie die Optionen mittels »Bearbeiten«-»Optionen« und wechseln Sie in den 'Aufnahme' -> 'Prozeduren' Bereich. Dort setzen Sie den Pfad Ihrer eigenen Datei im Attribut 'Konfigurationsdatei für die Prozedurenaufnahme'. Danach bestätigen Sie die Änderung mit 'OK'. Danach starten Sie den CarConfigurator. Wenn dieser vollständig gestartet wurde, fahren Sie mit folgenden Schritten fort: Drücken Sie den 'Prozeduren erstellen' Knopf Führen Sie Rechtsklick auf dem SUT aus Selektieren Sie 'Ganzes Fenster' Drücken Sie den 'Prozeduren erstellen' Knopf. Gratulation! Sie haben eigene Testschritte mit QF‑Test erstellt.","hash":"fig_apbOwnConfPlaceholderCompId","h4":"Abbildung 39.10: Der <COMPID> Platzhalter"},"952":{"id":952,"content":"Abbildung 39.11: Die selbst erstellten Testschritte","hash":"fig_apbOwnConfFirstCreation","h4":"Abbildung 39.11: Die selbst erstellten Testschritte"},"953":{"id":953,"content":"Den aktuellen Text verwenden Die 'checkText' Prozeduren haben den Parameter 'text' für den zu prüfenden Text. Bis jetzt müssen wir den zu prüfenden Text immer beim Aufruf der Procedure angeben. Stellen wir uns nun ein Szenario vor, in dem wir die Standardwerte der Textfelder nach dem Start prüfen wollen. In diesem Fall müssten wir jedem einzelnen Prozeduraufruf der vier 'checkText' Prozeduraufrufe den entsprechenden Parameterwert mitgeben. QF‑Test bietet einen Platzhalter, um den aktuellen Text während der Prozedurerstellung einzubinden. Hierfür müssen wir in der Konfigurationsdatei den Standardwert des Parameters 'text' auf <CURRENTVALUE> setzen. Danach sollten Sie sich versichern, dass das Package myProcedures nicht mehr unter Prozeduren existiert, damit wir die Prozeduren neu aufzeichnen können. Falls dieses Package doch existieren sollte, wird ein neues Package myProcedures1 erstellt um die Eindeutigkeit der erstellten Packages zu gewährleisten. Erstellen Sie nun die Prozeduren wie im vorigen Beispiel. Die geänderte Konfigurationsdatei:","hash":"sec_apbCurrentText","h2":"Den aktuellen Text verwenden"},"954":{"id":954,"content":"Abbildung 39.12: Die Konfigurationsdatei mit dem aktuellen Text Die neu erstellten Prozeduren:","hash":"fig_apbExampleCurrentText","h4":"Abbildung 39.12: Die Konfigurationsdatei mit dem aktuellen Text"},"955":{"id":955,"content":"Abbildung 39.13: Die generierten Prozeduren mit dem aktuellen Text","hash":"fig_apbExampleCurrentText2","h4":"Abbildung 39.13: Die generierten Prozeduren mit dem aktuellen Text"},"956":{"id":956,"content":"Generieren von Container Prozeduren Im vorigen Beispiel haben wir 'checkText' Prozeduren für die einzelnen Textfelder erstellt. Sie sollten nun selbstständig in der Lage sein 'set' Prozeduren, zum Setzen des Textes zu erstellen. Bis jetzt haben wir allerdings nur mit einzelnen Komponenten gearbeitet. In einigen Testszenarien kann es durchaus von Interesse sein, dass man mit einem Prozeduraufruf alle Textfelder eines Dialoges oder eines speziellen Panels prüft. Ein weiteres Szenario wäre das Setzen aller sichtbaren Textfelder. Solche Prozeduren arbeiten mit Container-Komponenten, deshalb heißen diese Prozeduren Container Prozeduren In unserem Fall wollen wir nun eine Prozedur erstellen, die alle vier 'checkText' Prozeduren des CarConfigurator aufruft. Aber wie erstellen wir diese? Zuerst müssten wir ein weiteres Klassenpackage in 'mySettings.qft' einfügen. Der Name des Packages sollte 'javax_swing_JFrame' sein. Das Hauptfenster des CarConfigurator ist eine Instanz von javax.swing.JFrame, deshalb sollten wir dieses Klassenpackage erstellen. Darin sollte wir ein Typpackage namens 'checkers-window' erstellen. Das Typpackage sollte wiederum eine Prozedur checkTextOfElements_<COMPID> beinhalten, welche die einzelnen Checks aufruft. Wir benutzen hier den Platzhalter <COMPID>, damit wir erkennen können zu welchem Dialog die erzeugte Prozedur gehört. Der nächste Schritt ist das Spezifizieren des Prozedureninhaltes. Schauen wir mal, wie man das macht. Wir haben vier Textfelder, welche alle mittels der Prozedur checkText_<COMPID> geprüft werden können. QF‑Test ermöglicht es uns nun, alle vier Prozeduraufrufe mit nur einem zu konfigurieren. Daher fügen Sie bitte einen Prozeduraufruf Knoten in diese Prozedur ein. Sie müssen dann die Prozedur javax_swing_JTextField.checkers.checkText_<CCOMPID> aufrufen. Die Konfigurationsdatei nach dieser Änderung:","hash":"sec_abpContainer","h2":"Generieren von Container Prozeduren"},"957":{"id":957,"content":"Abbildung 39.14: Die Vorlage für die Containerprozedur Als letzten Schritt muss man QF‑Test so konfigurieren, dass auch wirklich eine Containerprozedur und keine normale Komponentenprozedur erstellt wird. Hierfür muss man den Wert @FORCHILDREN im Attribut 'Bemerkung' der Prozedur checkTextOfElements_<COMPID> eintragen.","hash":"fig_apbContainerExample","h4":"Abbildung 39.14: Die Vorlage für die Containerprozedur"},"958":{"id":958,"content":"Abbildung 39.15: Die Verwendung von @FORCHILDREN Jetzt können Sie die Prozeduren, wie im vorigen Beispiel aufzeichnen. Vergessen Sie bitte nicht das 'myProcedures' Package vorher aus Prozeduren zu löschen. Jetzt sollten unter Prozeduren folgende Prozeduren erstellt werden:","hash":"fig_apbForChildrenTag","h4":"Abbildung 39.15: Die Verwendung von @FORCHILDREN"},"959":{"id":959,"content":"Abbildung 39.16: Die generierten Containerprozeduren QF‑Test ersetzt den 'Klassen' Teil des Prozeduraufrufes durch den Namen des Konfigurationspackages. In unserem Fall ist dies 'myProcedures'.","hash":"fig_apbCreatedContainer","h4":"Abbildung 39.16: Die generierten Containerprozeduren"},"960":{"id":960,"content":"Der aktuelle Wert der Kindkomponente Wir können uns eine ähnliche Situation wie in Den aktuellen Text verwenden beschrieben, auch für die Containerprozeduren vorstellen. Im obigen Beispiel haben wir <CURRENTVALUE> hierfür benutzt. Jetzt müssen wir den Parameter 'text' bei den einzelnen Prozeduraufrufen in der Containerprozedur 'checkTextElements' setzen. Dafür fügen wir diesen Parameter zum Prozeduraufruf in unserer Konfigurationsdatei 'mySettings.qft' hinzu. Der Wert sollte auf <CCURRENTVALUE> gesetzt werden.","hash":"sec_apbCurrentChildValue","h2":"Der aktuelle Wert der Kindkomponente"},"961":{"id":961,"content":"Abbildung 39.17: Konfiguration mit <CCURRENTVALUE> Wenn wir jetzt die Prozeduren nochmals erstellen, werden Sie sehen, dass die aktuellen Werte zu den Prozeduraufrufen hinzugefügt worden sind. Vergessen Sie bitte wieder nicht, vorher das 'myProcedures' Package aus Prozeduren zu löschen.","hash":"fig_apbContainerCurrentText","h4":"Abbildung 39.17: Konfiguration mit <CCURRENTVALUE>"},"962":{"id":962,"content":"Abbildung 39.18: Testsuite mit <CCURRENTVALUE> Wenn Sie sich die generierte Prozedur 'checkTextElements' genauer anschauen, so werden Sie bei jedem Prozeduraufruf den gesetzten Text sehen. Vielleicht wäre es von Vorteil wenn dieser 'text' Parameter auch als Standardwert der Containerprozedur zur Verfügung stünde. Um dies zu erreichen, müssten Sie einen weiteren Parameter zur Prozedurvorlage hinzufügen. Der Name des Parameters ist <CCOMPID> und der Wert <CCURRENTVALUE>. Danach müssen Sie den Wert des 'text' Parameters beim Prozeduraufruf in $(<CCOMPID>) ändern. Die Konfiguration sollte also wie folgt aussehen:","hash":"fig_apbContainerCurrentTextTestSuite","h4":"Abbildung 39.18: Testsuite mit <CCURRENTVALUE>"},"963":{"id":963,"content":"Abbildung 39.19: Parameter für Containerprozeduren Wenn Sie nun wiederum die Prozeduren erstellen, dann werden Sie sehen, dass die 'checkTextElements' Prozedur vier Parameter bekommen hat und die aktuellen Werte der Textfelder jeweils als Standardwerte eingetragen worden sind. Darüber hinaus hat jeder einzelne Prozeduraufruf für den Parameter 'text' eine Variable als Wert, die wie die QF‑Test ID der Komponente heißt, welche auch gleichzeitig der Name des Parameters ist.","hash":"fig_apbContainerParams","h4":"Abbildung 39.19: Parameter für Containerprozeduren"},"964":{"id":964,"content":"Abbildung 39.20: Parameter für die Containerprozedur in der Testsuite","hash":"fig_apbContainerParamsTestSuite","h4":"Abbildung 39.20: Parameter für die Containerprozedur in der Testsuite"},"965":{"id":965,"content":"Weitere Konfigurationsmöglichkeiten Wie Sie in den vorigen Abschnitten gesehen haben gibt es eine Menge Konfigurationsmöglichkeiten für die automatische Prozedurenerstellung. Es gibt jedoch noch weitere Möglichkeiten. Um mehr darüber zu erfahren schauen Sie bitte ins Handbuch ins Kapitel Die Procedure Builder Definitionsdatei.","hash":"sec_apbMore","h2":"Weitere Konfigurationsmöglichkeiten"}},"docInfo":{"0":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"1":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"2":{"content":1,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"3":{"content":144,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"4":{"content":198,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"5":{"content":23,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"6":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"7":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"8":{"content":55,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"9":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"10":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"11":{"content":22,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"12":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"13":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"14":{"content":60,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"15":{"content":74,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"16":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"17":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"18":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"19":{"content":15,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"20":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"21":{"content":121,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"22":{"content":4,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"23":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"24":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"25":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"26":{"content":64,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"27":{"content":100,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"28":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"29":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"30":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"31":{"content":16,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"32":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"33":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"34":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"35":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"36":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"37":{"content":44,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"38":{"content":66,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"39":{"content":49,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"40":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"41":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"42":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"43":{"content":103,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"44":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"45":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"46":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"47":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"48":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"49":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"50":{"content":33,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"51":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"52":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"53":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"54":{"content":25,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"55":{"content":63,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"56":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"57":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"58":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"59":{"content":26,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"60":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"61":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"62":{"content":45,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"63":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"64":{"content":59,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"65":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"66":{"content":67,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"67":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"68":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"69":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"70":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"71":{"content":7,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"72":{"content":53,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"73":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"74":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"75":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"76":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"77":{"content":72,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"78":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"79":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"80":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"81":{"content":100,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"82":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"83":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"84":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"85":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"86":{"content":94,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"87":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"88":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"89":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"90":{"content":42,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"91":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"92":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"93":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"94":{"content":61,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"95":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"96":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"97":{"content":42,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"98":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"99":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"100":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"101":{"content":69,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"102":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"103":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"104":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"105":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"106":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"107":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"108":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"109":{"content":80,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"110":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"111":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"112":{"content":26,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"113":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"114":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"115":{"content":55,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"116":{"content":234,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"117":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"118":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"119":{"content":178,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"120":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"121":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"122":{"content":371,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"123":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"124":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"125":{"content":402,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"126":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"127":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"128":{"content":144,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"129":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"130":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"131":{"content":43,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"132":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"133":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"134":{"content":83,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"135":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"136":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"137":{"content":44,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"138":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"139":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"140":{"content":117,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"141":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"142":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"143":{"content":52,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"144":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"145":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"146":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"147":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"148":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"149":{"content":56,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"150":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"151":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"152":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"153":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"154":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"155":{"content":81,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"156":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"157":{"content":42,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"158":{"content":34,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"159":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"160":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"161":{"content":90,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"162":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"163":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"164":{"content":26,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"165":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"166":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"167":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"168":{"content":104,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"169":{"content":89,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"170":{"content":15,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"171":{"content":64,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"172":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"173":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"174":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"175":{"content":25,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"176":{"content":114,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"177":{"content":121,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"178":{"content":78,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"179":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"180":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"181":{"content":68,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"182":{"content":182,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"183":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"184":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"185":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"186":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"187":{"content":92,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"188":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"189":{"content":91,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"190":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"191":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"192":{"content":220,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"193":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"194":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"195":{"content":146,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"196":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"197":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"198":{"content":24,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"199":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"200":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"201":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"202":{"content":25,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"203":{"content":59,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"204":{"content":26,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"205":{"content":25,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"206":{"content":17,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"207":{"content":41,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"208":{"content":38,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"209":{"content":55,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"210":{"content":141,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"211":{"content":29,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"212":{"content":41,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"213":{"content":60,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"214":{"content":61,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"215":{"content":68,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"216":{"content":44,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"217":{"content":44,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"218":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"219":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"220":{"content":31,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"221":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"222":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"223":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"224":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"225":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"226":{"content":113,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"227":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"228":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"229":{"content":159,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"230":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"231":{"content":139,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"232":{"content":243,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"233":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"234":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"235":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"236":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"237":{"content":67,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"238":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"239":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"240":{"content":89,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"241":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"242":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"243":{"content":22,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"244":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"245":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"246":{"content":60,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"247":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"248":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"249":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"250":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"251":{"content":15,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"252":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"253":{"content":124,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"254":{"content":4,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"255":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"256":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"257":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"258":{"content":64,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"259":{"content":99,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"260":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"261":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"262":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"263":{"content":16,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"264":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"265":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"266":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"267":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"268":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"269":{"content":44,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"270":{"content":66,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"271":{"content":49,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"272":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"273":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"274":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"275":{"content":102,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"276":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"277":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"278":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"279":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"280":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"281":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"282":{"content":33,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"283":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"284":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"285":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"286":{"content":25,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"287":{"content":63,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"288":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"289":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"290":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"291":{"content":27,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"292":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"293":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"294":{"content":46,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"295":{"content":63,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"296":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"297":{"content":15,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"298":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"299":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"300":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"301":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"302":{"content":7,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"303":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"304":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"305":{"content":66,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"306":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"307":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"308":{"content":72,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"309":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"310":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"311":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"312":{"content":100,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"313":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"314":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"315":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"316":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"317":{"content":91,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"318":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"319":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"320":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"321":{"content":42,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"322":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"323":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"324":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"325":{"content":61,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"326":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"327":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"328":{"content":42,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"329":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"330":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"331":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"332":{"content":69,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"333":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"334":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"335":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"336":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"337":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"338":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"339":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"340":{"content":80,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"341":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"342":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"343":{"content":26,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"344":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"345":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"346":{"content":55,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"347":{"content":234,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"348":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"349":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"350":{"content":205,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"351":{"content":114,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"352":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"353":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"354":{"content":255,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"355":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"356":{"content":53,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"357":{"content":383,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"358":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"359":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"360":{"content":402,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"361":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"362":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"363":{"content":145,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"364":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"365":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"366":{"content":43,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"367":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"368":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"369":{"content":81,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"370":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"371":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"372":{"content":44,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"373":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"374":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"375":{"content":117,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"376":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"377":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"378":{"content":52,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"379":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"380":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"381":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"382":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"383":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"384":{"content":56,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"385":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"386":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"387":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"388":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"389":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"390":{"content":81,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"391":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"392":{"content":42,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"393":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"394":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"395":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"396":{"content":90,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"397":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"398":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"399":{"content":36,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"400":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"401":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"402":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"403":{"content":104,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"404":{"content":89,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"405":{"content":15,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"406":{"content":64,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"407":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"408":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"409":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"410":{"content":25,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"411":{"content":114,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"412":{"content":121,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"413":{"content":78,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"414":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"415":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"416":{"content":68,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"417":{"content":182,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"418":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"419":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"420":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"421":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"422":{"content":92,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"423":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"424":{"content":91,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"425":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"426":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"427":{"content":220,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"428":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"429":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"430":{"content":146,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"431":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"432":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"433":{"content":24,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"434":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"435":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"436":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"437":{"content":21,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"438":{"content":56,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"439":{"content":23,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"440":{"content":22,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"441":{"content":35,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"442":{"content":141,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"443":{"content":29,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"444":{"content":41,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"445":{"content":60,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"446":{"content":61,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"447":{"content":68,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"448":{"content":44,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"449":{"content":44,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"450":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"451":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"452":{"content":31,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"453":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"454":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"455":{"content":13,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"456":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"457":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"458":{"content":137,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"459":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"460":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"461":{"content":159,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"462":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"463":{"content":138,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"464":{"content":243,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"465":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"466":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"467":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"468":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"469":{"content":67,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"470":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"471":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"472":{"content":56,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"473":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"474":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"475":{"content":22,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"476":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"477":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"478":{"content":60,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"479":{"content":74,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"480":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"481":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"482":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"483":{"content":15,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"484":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"485":{"content":83,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"486":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"487":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"488":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"489":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"490":{"content":64,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"491":{"content":95,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"492":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"493":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"494":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"495":{"content":16,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"496":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"497":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"498":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"499":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"500":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"501":{"content":44,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"502":{"content":66,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"503":{"content":49,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"504":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"505":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"506":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"507":{"content":101,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"508":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"509":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"510":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"511":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"512":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"513":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"514":{"content":33,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"515":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"516":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"517":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"518":{"content":25,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"519":{"content":63,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"520":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"521":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"522":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"523":{"content":26,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"524":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"525":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"526":{"content":46,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"527":{"content":81,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"528":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"529":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"530":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"531":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"532":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"533":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"534":{"content":7,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"535":{"content":76,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"536":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"537":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"538":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"539":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"540":{"content":92,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"541":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"542":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"543":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"544":{"content":100,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"545":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"546":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"547":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"548":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"549":{"content":94,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"550":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"551":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"552":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"553":{"content":42,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"554":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"555":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"556":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"557":{"content":61,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"558":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"559":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"560":{"content":42,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"561":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"562":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"563":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"564":{"content":69,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"565":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"566":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"567":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"568":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"569":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"570":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"571":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"572":{"content":80,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"573":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"574":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"575":{"content":26,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"576":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"577":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"578":{"content":55,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"579":{"content":234,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"580":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"581":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"582":{"content":147,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"583":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"584":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"585":{"content":41,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"586":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"587":{"content":9,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"588":{"content":81,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"589":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"590":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"591":{"content":44,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"592":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"593":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"594":{"content":117,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"595":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"596":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"597":{"content":52,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"598":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"599":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"600":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"601":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"602":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"603":{"content":56,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"604":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"605":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"606":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"607":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"608":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"609":{"content":81,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"610":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"611":{"content":42,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"612":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"613":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"614":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"615":{"content":90,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"616":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"617":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"618":{"content":38,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"619":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"620":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"621":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"622":{"content":104,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"623":{"content":89,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"624":{"content":15,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"625":{"content":64,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"626":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"627":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"628":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"629":{"content":25,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"630":{"content":114,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"631":{"content":121,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"632":{"content":78,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"633":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"634":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"635":{"content":68,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"636":{"content":182,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"637":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"638":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"639":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"640":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"641":{"content":92,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"642":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"643":{"content":91,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"644":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"645":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"646":{"content":220,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"647":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"648":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"649":{"content":146,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"650":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"651":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"652":{"content":24,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"653":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"654":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"655":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"656":{"content":11,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"657":{"content":29,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"658":{"content":41,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"659":{"content":60,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"660":{"content":61,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"661":{"content":68,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"662":{"content":44,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"663":{"content":44,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"664":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"665":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"666":{"content":31,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"667":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"668":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"669":{"content":13,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"670":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"671":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"672":{"content":137,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"673":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"674":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"675":{"content":159,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"676":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"677":{"content":138,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"678":{"content":243,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"679":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"680":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"681":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"682":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"683":{"content":67,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"684":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"685":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"686":{"content":50,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"687":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"688":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"689":{"content":16,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"690":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"691":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"692":{"content":67,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"693":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"694":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"695":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"696":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"697":{"content":42,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"698":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"699":{"content":176,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"700":{"content":4,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"701":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"702":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"703":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"704":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"705":{"content":93,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"706":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"707":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"708":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"709":{"content":16,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"710":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"711":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"712":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"713":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"714":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"715":{"content":44,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"716":{"content":66,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"717":{"content":49,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"718":{"content":65,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"719":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"720":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"721":{"content":102,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"722":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"723":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"724":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"725":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"726":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"727":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"728":{"content":27,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"729":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"730":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"731":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"732":{"content":25,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"733":{"content":63,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"734":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"735":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"736":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"737":{"content":19,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"738":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"739":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"740":{"content":27,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"741":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"742":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"743":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"744":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"745":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"746":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"747":{"content":24,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"748":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"749":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"750":{"content":68,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"751":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"752":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"753":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"754":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"755":{"content":37,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"756":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"757":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"758":{"content":100,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"759":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"760":{"content":15,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"761":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"762":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"763":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"764":{"content":56,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"765":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"766":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"767":{"content":42,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"768":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"769":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"770":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"771":{"content":74,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"772":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"773":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"774":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"775":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"776":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"777":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"778":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"779":{"content":80,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"780":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"781":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"782":{"content":47,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"783":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"784":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"785":{"content":54,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"786":{"content":80,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"787":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"788":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"789":{"content":85,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"790":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"791":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"792":{"content":149,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"793":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"794":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"795":{"content":43,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"796":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"797":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"798":{"content":81,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"799":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"800":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"801":{"content":44,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"802":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"803":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"804":{"content":117,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"805":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"806":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"807":{"content":52,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"808":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"809":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"810":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"811":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"812":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"813":{"content":56,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"814":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"815":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"816":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"817":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"818":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"819":{"content":81,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"820":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"821":{"content":42,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"822":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"823":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"824":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"825":{"content":90,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"826":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"827":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"828":{"content":37,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"829":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"830":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"831":{"content":10,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"832":{"content":104,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"833":{"content":91,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"834":{"content":15,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"835":{"content":67,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"836":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"837":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"838":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"839":{"content":25,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"840":{"content":114,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"841":{"content":122,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"842":{"content":78,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"843":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"844":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"845":{"content":68,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"846":{"content":182,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"847":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"848":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"849":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"850":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"851":{"content":92,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"852":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"853":{"content":91,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"854":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"855":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"856":{"content":220,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"857":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"858":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"859":{"content":146,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"860":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"861":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"862":{"content":24,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"863":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"864":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"865":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"866":{"content":11,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"867":{"content":85,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"868":{"content":29,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"869":{"content":61,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"870":{"content":44,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"871":{"content":44,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"872":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"873":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"874":{"content":31,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"875":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"876":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"877":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"878":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"879":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"880":{"content":66,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"881":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"882":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"883":{"content":578,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"884":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"885":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"886":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"887":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"888":{"content":44,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"889":{"content":2,"h-1":0,"h0":9,"h1":0,"h2":0,"h3":0,"hash":0},"890":{"content":2,"h-1":0,"h0":9,"h1":0,"h2":0,"h3":0,"hash":2},"891":{"content":44,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":1},"892":{"content":73,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"893":{"content":28,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"894":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"895":{"content":53,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"896":{"content":89,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"897":{"content":76,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"898":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"899":{"content":20,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"900":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"901":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"902":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"903":{"content":65,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"904":{"content":52,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"905":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"906":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"907":{"content":59,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"908":{"content":34,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"909":{"content":206,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"910":{"content":32,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"911":{"content":53,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"912":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"913":{"content":89,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"914":{"content":88,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"915":{"content":70,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"916":{"content":7,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"917":{"content":300,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"918":{"content":109,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"919":{"content":74,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"920":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"921":{"content":2,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"922":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"923":{"content":64,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"924":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"925":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"926":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"927":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"928":{"content":49,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"929":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"930":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"931":{"content":73,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"932":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"933":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"934":{"content":53,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"935":{"content":128,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"936":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"937":{"content":20,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"938":{"content":134,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"939":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"940":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"941":{"content":141,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"942":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"943":{"content":47,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"944":{"content":3,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"945":{"content":20,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"946":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"947":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"948":{"content":135,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"949":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"950":{"content":66,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"951":{"content":64,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"952":{"content":4,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"953":{"content":77,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"954":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"955":{"content":6,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"956":{"content":126,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"957":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"958":{"content":20,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"959":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"960":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"961":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"962":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"963":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"964":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"965":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1}},"length":966,"save":true},"index":{"content":{"root":{"0":{"docs":{"116":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"579":{"tf":1.4142135623730951},"786":{"tf":1.7320508075688772},"892":{"tf":1},"897":{"tf":1},"918":{"tf":1}},"df":7},"1":{"0":{"0":{"docs":{"27":{"tf":1},"259":{"tf":1},"491":{"tf":1},"705":{"tf":1},"917":{"tf":1.4142135623730951}},"df":5},"docs":{"32":{"tf":2},"264":{"tf":2},"496":{"tf":2},"892":{"tf":1},"897":{"tf":1},"912":{"tf":1},"915":{"tf":1}},"df":7,".":{"0":{"docs":{},"df":0,".":{"2":{"docs":{"14":{"tf":1},"64":{"tf":1},"97":{"tf":1},"198":{"tf":1},"246":{"tf":1},"295":{"tf":1},"328":{"tf":1},"433":{"tf":1},"478":{"tf":1},"527":{"tf":1},"560":{"tf":1},"652":{"tf":1},"692":{"tf":1},"741":{"tf":1},"767":{"tf":1},"862":{"tf":1},"888":{"tf":1},"891":{"tf":1.4142135623730951},"903":{"tf":1.4142135623730951},"904":{"tf":1},"907":{"tf":1.4142135623730951},"908":{"tf":1},"910":{"tf":1},"922":{"tf":1},"934":{"tf":1.4142135623730951},"935":{"tf":1},"937":{"tf":1},"938":{"tf":1},"945":{"tf":1}},"df":29},"docs":{},"df":0}},"1":{"0":{"docs":{"265":{"tf":1}},"df":1},"1":{"docs":{"266":{"tf":1}},"df":1},"2":{"docs":{"270":{"tf":1}},"df":1},"3":{"docs":{"271":{"tf":1}},"df":1},"4":{"docs":{"272":{"tf":1}},"df":1},"5":{"docs":{"279":{"tf":1}},"df":1},"6":{"docs":{"283":{"tf":1}},"df":1},"7":{"docs":{"287":{"tf":1}},"df":1},"8":{"docs":{"288":{"tf":1}},"df":1},"docs":{"247":{"tf":1}},"df":1},"2":{"docs":{"248":{"tf":1}},"df":1},"3":{"docs":{"252":{"tf":1}},"df":1},"4":{"docs":{"253":{"tf":1}},"df":1},"5":{"docs":{"254":{"tf":1}},"df":1},"6":{"docs":{"258":{"tf":1}},"df":1},"7":{"docs":{"259":{"tf":1}},"df":1},"8":{"docs":{"260":{"tf":1}},"df":1},"9":{"docs":{"264":{"tf":1}},"df":1},"docs":{},"df":0}},"1":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"313":{"tf":1}},"df":1},"1":{"docs":{"314":{"tf":1}},"df":1},"2":{"docs":{"318":{"tf":1}},"df":1},"3":{"docs":{"322":{"tf":1}},"df":1},"docs":{"295":{"tf":1}},"df":1},"2":{"docs":{"296":{"tf":1}},"df":1},"3":{"docs":{"297":{"tf":1}},"df":1},"4":{"docs":{"298":{"tf":1}},"df":1},"5":{"docs":{"299":{"tf":1}},"df":1},"6":{"docs":{"303":{"tf":1}},"df":1},"7":{"docs":{"304":{"tf":1}},"df":1},"8":{"docs":{"305":{"tf":1}},"df":1},"9":{"docs":{"309":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1},"917":{"tf":1.4142135623730951}},"df":5,".":{"1":{"docs":{"329":{"tf":1}},"df":1},"2":{"docs":{"333":{"tf":1}},"df":1},"3":{"docs":{"334":{"tf":1}},"df":1},"4":{"docs":{"335":{"tf":1}},"df":1},"5":{"docs":{"336":{"tf":1}},"df":1},"6":{"docs":{"337":{"tf":1}},"df":1},"7":{"3":{"4":{"docs":{},"df":0,",":{"0":{"0":{"docs":{"832":{"tf":1},"846":{"tf":1}},"df":2},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0}},"3":{"docs":{},"df":0,":":{"0":{"7":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2},"docs":{},"df":0},"docs":{},"df":0},".":{"1":{"docs":{"347":{"tf":1}},"df":1},"2":{"docs":{"351":{"tf":1}},"df":1},"3":{"4":{"9":{"docs":{},"df":0,",":{"0":{"0":{"docs":{"832":{"tf":1},"833":{"tf":1.4142135623730951},"842":{"tf":1}},"df":3},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{"355":{"tf":1}},"df":1},"4":{"docs":{"356":{"tf":1}},"df":1},"5":{"docs":{"357":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"385":{"tf":1}},"df":1},"1":{"docs":{"386":{"tf":1}},"df":1},"2":{"docs":{"387":{"tf":1}},"df":1},"3":{"docs":{"391":{"tf":1}},"df":1},"4":{"docs":{"392":{"tf":1}},"df":1},"docs":{"367":{"tf":1}},"df":1},"2":{"docs":{"368":{"tf":1}},"df":1},"3":{"docs":{"369":{"tf":1}},"df":1},"4":{"docs":{"373":{"tf":1}},"df":1},"5":{"docs":{"374":{"tf":1}},"df":1},"6":{"docs":{"375":{"tf":1}},"df":1},"7":{"docs":{"379":{"tf":1}},"df":1},"8":{"docs":{"380":{"tf":1}},"df":1},"9":{"docs":{"381":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"docs":{"892":{"tf":1},"897":{"tf":1},"913":{"tf":1},"915":{"tf":1},"916":{"tf":1}},"df":5,".":{"1":{"0":{"docs":{"423":{"tf":1}},"df":1},"1":{"docs":{"424":{"tf":1}},"df":1},"docs":{"403":{"tf":1}},"df":1},"2":{"docs":{"404":{"tf":1}},"df":1},"3":{"docs":{"405":{"tf":1}},"df":1},"4":{"docs":{"407":{"tf":1}},"df":1},"5":{"docs":{"411":{"tf":1}},"df":1},"6":{"docs":{"412":{"tf":1}},"df":1},"7":{"docs":{"413":{"tf":1}},"df":1},"8":{"docs":{"417":{"tf":1}},"df":1},"9":{"docs":{"418":{"tf":1}},"df":1},"docs":{},"df":0}},"6":{"docs":{},"df":0,".":{"1":{"docs":{"434":{"tf":1}},"df":1},"docs":{},"df":0}},"7":{"docs":{},"df":0,".":{"1":{"docs":{"456":{"tf":1}},"df":1},"2":{"docs":{"457":{"tf":1}},"df":1},"3":{"docs":{"458":{"tf":1}},"df":1},"4":{"docs":{"462":{"tf":1}},"df":1},"5":{"docs":{"463":{"tf":1}},"df":1},"6":{"docs":{"464":{"tf":1}},"df":1},"7":{"docs":{"465":{"tf":1}},"df":1},"8":{"docs":{"466":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"docs":{"560":{"tf":1},"767":{"tf":1}},"df":2,".":{"1":{"0":{"docs":{"497":{"tf":1}},"df":1},"1":{"docs":{"498":{"tf":1}},"df":1},"2":{"docs":{"502":{"tf":1}},"df":1},"3":{"docs":{"503":{"tf":1}},"df":1},"4":{"docs":{"504":{"tf":1}},"df":1},"5":{"docs":{"511":{"tf":1}},"df":1},"6":{"docs":{"515":{"tf":1}},"df":1},"7":{"docs":{"519":{"tf":1}},"df":1},"8":{"docs":{"520":{"tf":1}},"df":1},"docs":{"479":{"tf":1}},"df":1},"2":{"docs":{"480":{"tf":1}},"df":1},"3":{"docs":{"484":{"tf":1}},"df":1},"4":{"docs":{"485":{"tf":1}},"df":1},"5":{"docs":{"486":{"tf":1}},"df":1},"6":{"docs":{"490":{"tf":1}},"df":1},"7":{"docs":{"491":{"tf":1}},"df":1},"8":{"docs":{"492":{"tf":1}},"df":1},"9":{"docs":{"496":{"tf":1}},"df":1},"docs":{},"df":0}},"docs":{"97":{"tf":1},"328":{"tf":1},"917":{"tf":1.4142135623730951},"918":{"tf":1},"919":{"tf":1}},"df":5,".":{"1":{"0":{"docs":{"33":{"tf":1}},"df":1},"1":{"docs":{"34":{"tf":1}},"df":1},"2":{"docs":{"38":{"tf":1}},"df":1},"3":{"docs":{"39":{"tf":1}},"df":1},"4":{"docs":{"40":{"tf":1}},"df":1},"5":{"docs":{"47":{"tf":1}},"df":1},"6":{"docs":{"51":{"tf":1}},"df":1},"7":{"docs":{"55":{"tf":1}},"df":1},"8":{"docs":{"56":{"tf":1}},"df":1},"docs":{"15":{"tf":1}},"df":1},"2":{"docs":{"16":{"tf":1}},"df":1},"3":{"docs":{"20":{"tf":1}},"df":1},"4":{"docs":{"21":{"tf":1}},"df":1},"5":{"docs":{"22":{"tf":1}},"df":1},"6":{"docs":{"26":{"tf":1}},"df":1},"7":{"docs":{"27":{"tf":1}},"df":1},"8":{"docs":{"28":{"tf":1}},"df":1},"9":{"docs":{"32":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"0":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"545":{"tf":1}},"df":1},"1":{"docs":{"546":{"tf":1}},"df":1},"2":{"docs":{"550":{"tf":1}},"df":1},"3":{"docs":{"554":{"tf":1}},"df":1},"docs":{"527":{"tf":1}},"df":1},"2":{"docs":{"528":{"tf":1}},"df":1},"3":{"docs":{"529":{"tf":1}},"df":1},"4":{"docs":{"530":{"tf":1}},"df":1},"5":{"docs":{"531":{"tf":1}},"df":1},"6":{"docs":{"535":{"tf":1}},"df":1},"7":{"docs":{"536":{"tf":1}},"df":1},"8":{"docs":{"537":{"tf":1}},"df":1},"9":{"docs":{"541":{"tf":1}},"df":1},"docs":{},"df":0}},"1":{"docs":{},"df":0,".":{"1":{"docs":{"561":{"tf":1}},"df":1},"2":{"docs":{"565":{"tf":1}},"df":1},"3":{"docs":{"566":{"tf":1}},"df":1},"4":{"docs":{"567":{"tf":1}},"df":1},"5":{"docs":{"568":{"tf":1}},"df":1},"6":{"docs":{"569":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"docs":{},"df":0,".":{"1":{"docs":{"579":{"tf":1}},"df":1},"docs":{},"df":0}},"3":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"604":{"tf":1}},"df":1},"1":{"docs":{"605":{"tf":1}},"df":1},"2":{"docs":{"606":{"tf":1}},"df":1},"3":{"docs":{"610":{"tf":1}},"df":1},"4":{"docs":{"611":{"tf":1}},"df":1},"docs":{"586":{"tf":1}},"df":1},"2":{"docs":{"587":{"tf":1}},"df":1},"3":{"docs":{"588":{"tf":1}},"df":1},"4":{"docs":{"592":{"tf":1}},"df":1},"5":{"docs":{"593":{"tf":1}},"df":1},"6":{"docs":{"594":{"tf":1}},"df":1},"7":{"docs":{"598":{"tf":1}},"df":1},"8":{"docs":{"599":{"tf":1}},"df":1},"9":{"docs":{"600":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"642":{"tf":1}},"df":1},"1":{"docs":{"643":{"tf":1}},"df":1},"docs":{"622":{"tf":1}},"df":1},"2":{"docs":{"623":{"tf":1}},"df":1},"3":{"docs":{"624":{"tf":1}},"df":1},"4":{"docs":{"626":{"tf":1}},"df":1},"5":{"docs":{"630":{"tf":1}},"df":1},"6":{"docs":{"631":{"tf":1}},"df":1},"7":{"docs":{"632":{"tf":1}},"df":1},"8":{"docs":{"636":{"tf":1}},"df":1},"9":{"docs":{"637":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"docs":{},"df":0,".":{"1":{"docs":{"653":{"tf":1}},"df":1},"docs":{},"df":0}},"6":{"docs":{},"df":0,".":{"1":{"0":{"0":{"docs":{},"df":0,",":{"0":{"0":{"docs":{"168":{"tf":1},"182":{"tf":1},"403":{"tf":1},"417":{"tf":1},"622":{"tf":1},"636":{"tf":1}},"df":6},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{"670":{"tf":1}},"df":1},"2":{"docs":{"671":{"tf":1}},"df":1},"3":{"docs":{"672":{"tf":1}},"df":1},"4":{"docs":{"676":{"tf":1}},"df":1},"5":{"docs":{"677":{"tf":1}},"df":1},"6":{"docs":{"678":{"tf":1}},"df":1},"7":{"docs":{"679":{"tf":1}},"df":1},"8":{"docs":{"680":{"tf":1}},"df":1},"docs":{},"df":0}},"8":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"711":{"tf":1}},"df":1},"1":{"docs":{"712":{"tf":1}},"df":1},"2":{"docs":{"716":{"tf":1}},"df":1},"3":{"docs":{"717":{"tf":1}},"df":1},"4":{"docs":{"718":{"tf":1}},"df":1},"5":{"docs":{"725":{"tf":1}},"df":1},"6":{"docs":{"729":{"tf":1}},"df":1},"7":{"docs":{"733":{"tf":1}},"df":1},"8":{"docs":{"734":{"tf":1}},"df":1},"docs":{"693":{"tf":1}},"df":1},"2":{"docs":{"694":{"tf":1}},"df":1},"3":{"docs":{"698":{"tf":1}},"df":1},"4":{"docs":{"699":{"tf":1}},"df":1},"5":{"docs":{"700":{"tf":1}},"df":1},"6":{"docs":{"704":{"tf":1}},"df":1},"7":{"docs":{"705":{"tf":1}},"df":1},"8":{"docs":{"706":{"tf":1}},"df":1},"9":{"docs":{"710":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"759":{"tf":1}},"df":1},"1":{"docs":{"760":{"tf":1}},"df":1},"2":{"docs":{"761":{"tf":1}},"df":1},"docs":{"741":{"tf":1}},"df":1},"2":{"docs":{"742":{"tf":1}},"df":1},"3":{"docs":{"743":{"tf":1}},"df":1},"4":{"docs":{"744":{"tf":1}},"df":1},"5":{"docs":{"748":{"tf":1}},"df":1},"6":{"docs":{"749":{"tf":1}},"df":1},"7":{"docs":{"750":{"tf":1}},"df":1},"8":{"docs":{"751":{"tf":1}},"df":1},"9":{"docs":{"752":{"tf":1}},"df":1},"docs":{},"df":0}},"docs":{"917":{"tf":1.4142135623730951},"918":{"tf":1},"919":{"tf":1}},"df":3,".":{"1":{"0":{"docs":{"78":{"tf":1}},"df":1},"1":{"docs":{"82":{"tf":1}},"df":1},"2":{"docs":{"83":{"tf":1}},"df":1},"3":{"docs":{"87":{"tf":1}},"df":1},"4":{"docs":{"91":{"tf":1}},"df":1},"docs":{"63":{"tf":1}},"df":1},"2":{"docs":{"64":{"tf":1}},"df":1},"3":{"docs":{"65":{"tf":1}},"df":1},"4":{"docs":{"66":{"tf":1}},"df":1},"5":{"docs":{"67":{"tf":1}},"df":1},"6":{"docs":{"68":{"tf":1}},"df":1},"7":{"docs":{"72":{"tf":1}},"df":1},"8":{"docs":{"73":{"tf":1}},"df":1},"9":{"docs":{"74":{"tf":1}},"df":1},"docs":{},"df":0}},"3":{"0":{"docs":{},"df":0,".":{"0":{"4":{"9":{"docs":{},"df":0,",":{"0":{"0":{"docs":{"168":{"tf":1},"169":{"tf":1.4142135623730951},"178":{"tf":1},"403":{"tf":1},"404":{"tf":1.4142135623730951},"413":{"tf":1},"622":{"tf":1},"623":{"tf":1.4142135623730951},"632":{"tf":1}},"df":9},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{},"df":0},"1":{"docs":{"768":{"tf":1}},"df":1},"2":{"docs":{"772":{"tf":1}},"df":1},"3":{"docs":{"773":{"tf":1}},"df":1},"4":{"docs":{"774":{"tf":1}},"df":1},"5":{"docs":{"775":{"tf":1}},"df":1},"6":{"docs":{"776":{"tf":1}},"df":1},"docs":{},"df":0}},"1":{"docs":{},"df":0,".":{"1":{"docs":{"786":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"814":{"tf":1}},"df":1},"1":{"docs":{"815":{"tf":1}},"df":1},"2":{"docs":{"816":{"tf":1}},"df":1},"3":{"docs":{"820":{"tf":1}},"df":1},"4":{"docs":{"821":{"tf":1}},"df":1},"docs":{"796":{"tf":1}},"df":1},"2":{"docs":{"797":{"tf":1}},"df":1},"3":{"docs":{"798":{"tf":1}},"df":1},"4":{"docs":{"802":{"tf":1}},"df":1},"5":{"docs":{"803":{"tf":1}},"df":1},"6":{"docs":{"804":{"tf":1}},"df":1},"7":{"docs":{"808":{"tf":1}},"df":1},"8":{"docs":{"809":{"tf":1}},"df":1},"9":{"docs":{"810":{"tf":1}},"df":1},"docs":{},"df":0}},"3":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"852":{"tf":1}},"df":1},"1":{"docs":{"853":{"tf":1}},"df":1},"docs":{"832":{"tf":1}},"df":1},"2":{"docs":{"833":{"tf":1}},"df":1},"3":{"docs":{"834":{"tf":1}},"df":1},"4":{"docs":{"836":{"tf":1}},"df":1},"5":{"docs":{"840":{"tf":1}},"df":1},"6":{"docs":{"841":{"tf":1}},"df":1},"7":{"docs":{"842":{"tf":1}},"df":1},"8":{"docs":{"846":{"tf":1}},"df":1},"9":{"docs":{"847":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"docs":{"863":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"docs":{},"df":0,".":{"1":{"docs":{"878":{"tf":1}},"df":1},"2":{"docs":{"879":{"tf":1}},"df":1},"3":{"docs":{"880":{"tf":1}},"df":1},"4":{"docs":{"884":{"tf":1}},"df":1},"5":{"docs":{"885":{"tf":1}},"df":1},"docs":{},"df":0}},"7":{"docs":{},"df":0,".":{"1":{"docs":{"894":{"tf":1}},"df":1},"2":{"docs":{"895":{"tf":1}},"df":1},"3":{"docs":{"897":{"tf":1}},"df":1},"4":{"docs":{"898":{"tf":1}},"df":1},"5":{"docs":{"899":{"tf":1}},"df":1},"6":{"docs":{"900":{"tf":1}},"df":1},"7":{"docs":{"901":{"tf":1}},"df":1},"8":{"docs":{"902":{"tf":1}},"df":1},"9":{"docs":{"903":{"tf":1}},"df":1},"docs":{},"df":0}},"8":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"920":{"tf":1}},"df":1},"1":{"docs":{"923":{"tf":1}},"df":1},"2":{"docs":{"924":{"tf":1}},"df":1},"3":{"docs":{"925":{"tf":1}},"df":1},"4":{"docs":{"927":{"tf":1}},"df":1},"5":{"docs":{"928":{"tf":1}},"df":1},"6":{"docs":{"929":{"tf":1}},"df":1},"docs":{"909":{"tf":1}},"df":1},"2":{"docs":{"911":{"tf":1}},"df":1},"3":{"docs":{"912":{"tf":1}},"df":1},"4":{"docs":{"913":{"tf":1}},"df":1},"5":{"docs":{"914":{"tf":1}},"df":1},"6":{"docs":{"915":{"tf":1}},"df":1},"7":{"docs":{"916":{"tf":1}},"df":1},"8":{"docs":{"918":{"tf":1}},"df":1},"9":{"docs":{"919":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"951":{"tf":1}},"df":1},"1":{"docs":{"952":{"tf":1}},"df":1},"2":{"docs":{"954":{"tf":1}},"df":1},"3":{"docs":{"955":{"tf":1}},"df":1},"4":{"docs":{"957":{"tf":1}},"df":1},"5":{"docs":{"958":{"tf":1}},"df":1},"6":{"docs":{"959":{"tf":1}},"df":1},"7":{"docs":{"961":{"tf":1}},"df":1},"8":{"docs":{"962":{"tf":1}},"df":1},"9":{"docs":{"963":{"tf":1}},"df":1},"docs":{"936":{"tf":1},"940":{"tf":1}},"df":2},"2":{"0":{"docs":{"964":{"tf":1}},"df":1},"docs":{"938":{"tf":1},"941":{"tf":1}},"df":2},"3":{"docs":{"939":{"tf":1}},"df":1},"4":{"docs":{"942":{"tf":1}},"df":1},"5":{"docs":{"943":{"tf":1}},"df":1},"6":{"docs":{"946":{"tf":1}},"df":1},"7":{"docs":{"948":{"tf":1}},"df":1},"8":{"docs":{"949":{"tf":1}},"df":1},"9":{"docs":{"950":{"tf":1}},"df":1},"docs":{},"df":0}},"docs":{"237":{"tf":1},"469":{"tf":1},"683":{"tf":1},"917":{"tf":1},"918":{"tf":1},"919":{"tf":1.7320508075688772}},"df":6,".":{"1":{"docs":{"98":{"tf":1}},"df":1},"2":{"docs":{"102":{"tf":1}},"df":1},"3":{"docs":{"103":{"tf":1}},"df":1},"4":{"docs":{"104":{"tf":1}},"df":1},"5":{"docs":{"105":{"tf":1}},"df":1},"6":{"docs":{"106":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"docs":{"116":{"tf":1}},"df":1},"2":{"docs":{"5":{"tf":1},"120":{"tf":1}},"df":2},"3":{"docs":{"121":{"tf":1}},"df":1},"4":{"docs":{"122":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"0":{"docs":{"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":4},"docs":{"3":{"tf":1},"710":{"tf":1.4142135623730951}},"df":2,".":{"1":{"0":{"docs":{"150":{"tf":1}},"df":1},"1":{"docs":{"151":{"tf":1}},"df":1},"2":{"docs":{"152":{"tf":1}},"df":1},"3":{"docs":{"156":{"tf":1}},"df":1},"4":{"docs":{"157":{"tf":1}},"df":1},"docs":{"132":{"tf":1}},"df":1},"2":{"docs":{"133":{"tf":1}},"df":1},"3":{"docs":{"134":{"tf":1}},"df":1},"4":{"docs":{"138":{"tf":1}},"df":1},"5":{"docs":{"139":{"tf":1}},"df":1},"6":{"docs":{"140":{"tf":1}},"df":1},"7":{"docs":{"144":{"tf":1}},"df":1},"8":{"docs":{"145":{"tf":1}},"df":1},"9":{"docs":{"146":{"tf":1}},"df":1},"docs":{},"df":0}},"6":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"188":{"tf":1}},"df":1},"1":{"docs":{"189":{"tf":1}},"df":1},"docs":{"168":{"tf":1}},"df":1},"2":{"docs":{"169":{"tf":1}},"df":1},"3":{"docs":{"170":{"tf":1}},"df":1},"4":{"docs":{"172":{"tf":1}},"df":1},"5":{"docs":{"176":{"tf":1}},"df":1},"6":{"docs":{"177":{"tf":1}},"df":1},"7":{"docs":{"178":{"tf":1}},"df":1},"8":{"docs":{"182":{"tf":1}},"df":1},"9":{"docs":{"183":{"tf":1}},"df":1},"docs":{},"df":0}},"7":{"docs":{},"df":0,".":{"0":{"docs":{"125":{"tf":1},"360":{"tf":1},"789":{"tf":1}},"df":3},"1":{"docs":{"199":{"tf":1}},"df":1},"docs":{},"df":0}},"8":{"docs":{},"df":0,".":{"1":{"docs":{"224":{"tf":1}},"df":1},"2":{"docs":{"225":{"tf":1}},"df":1},"3":{"docs":{"226":{"tf":1}},"df":1},"4":{"docs":{"230":{"tf":1}},"df":1},"5":{"docs":{"231":{"tf":1}},"df":1},"6":{"docs":{"232":{"tf":1}},"df":1},"7":{"docs":{"233":{"tf":1}},"df":1},"8":{"docs":{"234":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"9":{"9":{"9":{"9":{"docs":{"917":{"tf":1.4142135623730951}},"df":1},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{"0":{"tf":1},"1":{"tf":1},"6":{"tf":1},"7":{"tf":1},"9":{"tf":1},"10":{"tf":1},"12":{"tf":1},"13":{"tf":1},"17":{"tf":1},"18":{"tf":1},"23":{"tf":1},"24":{"tf":1},"29":{"tf":1},"30":{"tf":1},"35":{"tf":1},"36":{"tf":1},"41":{"tf":1},"42":{"tf":1},"44":{"tf":1},"45":{"tf":1},"48":{"tf":1},"49":{"tf":1},"52":{"tf":1},"53":{"tf":1},"57":{"tf":1},"58":{"tf":1},"60":{"tf":1},"61":{"tf":1},"69":{"tf":1},"70":{"tf":1},"75":{"tf":1},"76":{"tf":1},"79":{"tf":1},"80":{"tf":1},"84":{"tf":1},"85":{"tf":1},"88":{"tf":1},"89":{"tf":1},"92":{"tf":1},"93":{"tf":1},"95":{"tf":1},"96":{"tf":1},"99":{"tf":1},"100":{"tf":1},"107":{"tf":1},"108":{"tf":1},"110":{"tf":1},"111":{"tf":1},"113":{"tf":1},"114":{"tf":1},"117":{"tf":1},"118":{"tf":1},"123":{"tf":1},"124":{"tf":1},"126":{"tf":1},"127":{"tf":1},"129":{"tf":1},"130":{"tf":1},"135":{"tf":1},"136":{"tf":1},"141":{"tf":1},"142":{"tf":1},"147":{"tf":1},"148":{"tf":1},"153":{"tf":1},"154":{"tf":1},"159":{"tf":1},"160":{"tf":1},"162":{"tf":1},"163":{"tf":1},"165":{"tf":1},"166":{"tf":1},"173":{"tf":1},"174":{"tf":1},"179":{"tf":1},"180":{"tf":1},"185":{"tf":1},"186":{"tf":1},"190":{"tf":1},"191":{"tf":1},"193":{"tf":1},"194":{"tf":1},"196":{"tf":1},"197":{"tf":1},"200":{"tf":1},"201":{"tf":1},"218":{"tf":1},"219":{"tf":1},"221":{"tf":1},"222":{"tf":1},"227":{"tf":1},"228":{"tf":1},"235":{"tf":1},"236":{"tf":1},"238":{"tf":1},"239":{"tf":1},"241":{"tf":1},"242":{"tf":1},"244":{"tf":1},"245":{"tf":1},"249":{"tf":1},"250":{"tf":1},"255":{"tf":1},"256":{"tf":1},"261":{"tf":1},"262":{"tf":1},"267":{"tf":1},"268":{"tf":1},"273":{"tf":1},"274":{"tf":1},"276":{"tf":1},"277":{"tf":1},"280":{"tf":1},"281":{"tf":1},"284":{"tf":1},"285":{"tf":1},"289":{"tf":1},"290":{"tf":1},"292":{"tf":1},"293":{"tf":1},"300":{"tf":1},"301":{"tf":1},"306":{"tf":1},"307":{"tf":1},"310":{"tf":1},"311":{"tf":1},"315":{"tf":1},"316":{"tf":1},"319":{"tf":1},"320":{"tf":1},"323":{"tf":1},"324":{"tf":1},"326":{"tf":1},"327":{"tf":1},"330":{"tf":1},"331":{"tf":1},"338":{"tf":1},"339":{"tf":1},"341":{"tf":1},"342":{"tf":1},"344":{"tf":1},"345":{"tf":1},"348":{"tf":1},"349":{"tf":1},"352":{"tf":1},"353":{"tf":1},"358":{"tf":1},"359":{"tf":1},"361":{"tf":1},"362":{"tf":1},"364":{"tf":1},"365":{"tf":1},"370":{"tf":1},"371":{"tf":1},"376":{"tf":1},"377":{"tf":1},"382":{"tf":1},"383":{"tf":1},"388":{"tf":1},"389":{"tf":1},"394":{"tf":1},"395":{"tf":1},"397":{"tf":1},"398":{"tf":1},"400":{"tf":1},"401":{"tf":1},"408":{"tf":1},"409":{"tf":1},"414":{"tf":1},"415":{"tf":1},"420":{"tf":1},"421":{"tf":1},"425":{"tf":1},"426":{"tf":1},"428":{"tf":1},"429":{"tf":1},"431":{"tf":1},"432":{"tf":1},"435":{"tf":1},"436":{"tf":1},"450":{"tf":1},"451":{"tf":1},"453":{"tf":1},"454":{"tf":1},"459":{"tf":1},"460":{"tf":1},"467":{"tf":1},"468":{"tf":1},"470":{"tf":1},"471":{"tf":1},"473":{"tf":1},"474":{"tf":1},"476":{"tf":1},"477":{"tf":1},"481":{"tf":1},"482":{"tf":1},"487":{"tf":1},"488":{"tf":1},"493":{"tf":1},"494":{"tf":1},"499":{"tf":1},"500":{"tf":1},"505":{"tf":1},"506":{"tf":1},"508":{"tf":1},"509":{"tf":1},"512":{"tf":1},"513":{"tf":1},"516":{"tf":1},"517":{"tf":1},"521":{"tf":1},"522":{"tf":1},"524":{"tf":1},"525":{"tf":1},"532":{"tf":1},"533":{"tf":1},"538":{"tf":1},"539":{"tf":1},"542":{"tf":1},"543":{"tf":1},"547":{"tf":1},"548":{"tf":1},"551":{"tf":1},"552":{"tf":1},"555":{"tf":1},"556":{"tf":1},"558":{"tf":1},"559":{"tf":1},"562":{"tf":1},"563":{"tf":1},"570":{"tf":1},"571":{"tf":1},"573":{"tf":1},"574":{"tf":1},"576":{"tf":1},"577":{"tf":1},"580":{"tf":1},"581":{"tf":1},"583":{"tf":1},"584":{"tf":1},"589":{"tf":1},"590":{"tf":1},"595":{"tf":1},"596":{"tf":1},"601":{"tf":1},"602":{"tf":1},"607":{"tf":1},"608":{"tf":1},"613":{"tf":1},"614":{"tf":1},"616":{"tf":1},"617":{"tf":1},"619":{"tf":1},"620":{"tf":1},"627":{"tf":1},"628":{"tf":1},"633":{"tf":1},"634":{"tf":1},"639":{"tf":1},"640":{"tf":1},"644":{"tf":1},"645":{"tf":1},"647":{"tf":1},"648":{"tf":1},"650":{"tf":1},"651":{"tf":1},"654":{"tf":1},"655":{"tf":1},"664":{"tf":1},"665":{"tf":1},"667":{"tf":1},"668":{"tf":1},"673":{"tf":1},"674":{"tf":1},"681":{"tf":1},"682":{"tf":1},"684":{"tf":1},"685":{"tf":1},"687":{"tf":1},"688":{"tf":1},"690":{"tf":1},"691":{"tf":1},"695":{"tf":1},"696":{"tf":1},"701":{"tf":1},"702":{"tf":1},"707":{"tf":1},"708":{"tf":1},"713":{"tf":1},"714":{"tf":1},"719":{"tf":1},"720":{"tf":1},"722":{"tf":1},"723":{"tf":1},"726":{"tf":1},"727":{"tf":1},"730":{"tf":1},"731":{"tf":1},"735":{"tf":1},"736":{"tf":1},"738":{"tf":1},"739":{"tf":1},"745":{"tf":1},"746":{"tf":1},"753":{"tf":1},"754":{"tf":1},"756":{"tf":1},"757":{"tf":1},"762":{"tf":1},"763":{"tf":1},"765":{"tf":1},"766":{"tf":1},"769":{"tf":1},"770":{"tf":1},"777":{"tf":1},"778":{"tf":1},"780":{"tf":1},"781":{"tf":1},"783":{"tf":1},"784":{"tf":1},"787":{"tf":1},"788":{"tf":1},"790":{"tf":1},"791":{"tf":1},"793":{"tf":1},"794":{"tf":1},"799":{"tf":1},"800":{"tf":1},"805":{"tf":1},"806":{"tf":1},"811":{"tf":1},"812":{"tf":1},"817":{"tf":1},"818":{"tf":1},"823":{"tf":1},"824":{"tf":1},"826":{"tf":1},"827":{"tf":1},"829":{"tf":1},"830":{"tf":1},"837":{"tf":1},"838":{"tf":1},"843":{"tf":1},"844":{"tf":1},"849":{"tf":1},"850":{"tf":1},"854":{"tf":1},"855":{"tf":1},"857":{"tf":1},"858":{"tf":1},"860":{"tf":1},"861":{"tf":1},"864":{"tf":1},"865":{"tf":1},"872":{"tf":1},"873":{"tf":1},"875":{"tf":1},"876":{"tf":1},"881":{"tf":1},"882":{"tf":1},"886":{"tf":1},"887":{"tf":1},"889":{"tf":1},"890":{"tf":1},"893":{"tf":1},"905":{"tf":1},"906":{"tf":1},"932":{"tf":1},"933":{"tf":1}},"df":369,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1}},"df":1}}}}}}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1},"63":{"tf":1},"64":{"tf":1.4142135623730951},"65":{"tf":1},"296":{"tf":1},"527":{"tf":1.4142135623730951},"528":{"tf":1},"760":{"tf":1},"761":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1}},"df":1}}},"t":{"docs":{},"df":0,"y":{"docs":{},"df":0,"p":{"docs":{"64":{"tf":1}},"df":1}}},"i":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}}}},"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"k":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"34":{"tf":1},"37":{"tf":2.23606797749979},"38":{"tf":1.4142135623730951},"50":{"tf":1},"51":{"tf":1},"54":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":1},"106":{"tf":1},"128":{"tf":2},"151":{"tf":1},"152":{"tf":1},"155":{"tf":2},"158":{"tf":2},"176":{"tf":1},"183":{"tf":1},"210":{"tf":1},"211":{"tf":2},"212":{"tf":2},"214":{"tf":1},"216":{"tf":1.7320508075688772},"229":{"tf":1},"266":{"tf":1},"269":{"tf":2.23606797749979},"270":{"tf":1.4142135623730951},"282":{"tf":1},"283":{"tf":1},"286":{"tf":1.4142135623730951},"321":{"tf":1.4142135623730951},"322":{"tf":1},"337":{"tf":1},"363":{"tf":2},"386":{"tf":1},"387":{"tf":1},"390":{"tf":2},"393":{"tf":1.7320508075688772},"411":{"tf":1},"418":{"tf":1},"442":{"tf":1},"443":{"tf":2},"444":{"tf":2},"446":{"tf":1},"448":{"tf":1.7320508075688772},"461":{"tf":1},"498":{"tf":1},"501":{"tf":2.23606797749979},"502":{"tf":1.4142135623730951},"514":{"tf":1},"515":{"tf":1},"518":{"tf":1.4142135623730951},"553":{"tf":1.4142135623730951},"554":{"tf":1},"569":{"tf":1},"582":{"tf":2},"605":{"tf":1},"606":{"tf":1},"609":{"tf":2},"612":{"tf":1.7320508075688772},"630":{"tf":1},"637":{"tf":1},"657":{"tf":2},"658":{"tf":2},"660":{"tf":1},"662":{"tf":1.7320508075688772},"675":{"tf":1},"712":{"tf":1},"715":{"tf":2.23606797749979},"716":{"tf":1.4142135623730951},"718":{"tf":2.449489742783178},"728":{"tf":1},"729":{"tf":1},"732":{"tf":1.4142135623730951},"776":{"tf":1},"792":{"tf":2},"815":{"tf":1},"816":{"tf":1},"819":{"tf":2},"822":{"tf":1.7320508075688772},"840":{"tf":1},"847":{"tf":1},"868":{"tf":2},"869":{"tf":1},"870":{"tf":1.7320508075688772},"883":{"tf":1},"901":{"tf":1.4142135623730951},"902":{"tf":1.7320508075688772},"903":{"tf":1},"912":{"tf":1},"913":{"tf":1.4142135623730951},"919":{"tf":1},"920":{"tf":1},"924":{"tf":1.4142135623730951},"925":{"tf":1},"928":{"tf":1},"929":{"tf":1}},"df":96,"l":{"docs":{"54":{"tf":1},"286":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":4,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1},"37":{"tf":1.4142135623730951},"155":{"tf":1},"247":{"tf":1},"269":{"tf":1.4142135623730951},"390":{"tf":1},"479":{"tf":1},"501":{"tf":1.4142135623730951},"609":{"tf":1},"693":{"tf":1},"715":{"tf":1.4142135623730951},"819":{"tf":1}},"df":12}}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"39":{"tf":1},"271":{"tf":1},"503":{"tf":1},"717":{"tf":1}},"df":4}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{"91":{"tf":1},"322":{"tf":1},"554":{"tf":1}},"df":3}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{"232":{"tf":1},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":4}}}}}}}}}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"81":{"tf":1.4142135623730951},"94":{"tf":2.449489742783178},"98":{"tf":1},"101":{"tf":2.6457513110645907},"102":{"tf":1.4142135623730951},"103":{"tf":1},"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"106":{"tf":1},"109":{"tf":2.6457513110645907},"119":{"tf":1},"122":{"tf":1},"164":{"tf":1},"167":{"tf":1},"168":{"tf":2},"169":{"tf":2},"171":{"tf":1},"176":{"tf":2},"177":{"tf":1.7320508075688772},"181":{"tf":1.4142135623730951},"182":{"tf":2.23606797749979},"183":{"tf":1},"187":{"tf":1},"188":{"tf":1.7320508075688772},"189":{"tf":1.7320508075688772},"192":{"tf":2.8284271247461903},"195":{"tf":1.7320508075688772},"199":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"204":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"207":{"tf":1.7320508075688772},"208":{"tf":1.4142135623730951},"209":{"tf":2},"210":{"tf":1},"211":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"215":{"tf":1.4142135623730951},"216":{"tf":2.23606797749979},"217":{"tf":1.4142135623730951},"225":{"tf":1},"231":{"tf":2.6457513110645907},"232":{"tf":1},"237":{"tf":1},"312":{"tf":1.4142135623730951},"325":{"tf":2.449489742783178},"329":{"tf":1},"332":{"tf":2.6457513110645907},"333":{"tf":1.4142135623730951},"334":{"tf":1},"335":{"tf":1.4142135623730951},"336":{"tf":1.7320508075688772},"337":{"tf":1},"340":{"tf":2.6457513110645907},"354":{"tf":1},"357":{"tf":1},"399":{"tf":1},"402":{"tf":1},"403":{"tf":2},"404":{"tf":2},"406":{"tf":1},"411":{"tf":2},"412":{"tf":1.7320508075688772},"416":{"tf":1.4142135623730951},"417":{"tf":2.23606797749979},"418":{"tf":1},"422":{"tf":1},"423":{"tf":1.7320508075688772},"424":{"tf":1.7320508075688772},"427":{"tf":2.8284271247461903},"430":{"tf":1.7320508075688772},"434":{"tf":1.7320508075688772},"437":{"tf":1.4142135623730951},"438":{"tf":1.7320508075688772},"439":{"tf":1.4142135623730951},"440":{"tf":1.4142135623730951},"441":{"tf":1.4142135623730951},"442":{"tf":1},"443":{"tf":1.4142135623730951},"444":{"tf":1.4142135623730951},"445":{"tf":1.4142135623730951},"446":{"tf":1.4142135623730951},"447":{"tf":1.4142135623730951},"448":{"tf":2.23606797749979},"449":{"tf":1.4142135623730951},"457":{"tf":1},"463":{"tf":2.6457513110645907},"464":{"tf":1},"469":{"tf":1},"544":{"tf":1.4142135623730951},"557":{"tf":2.449489742783178},"561":{"tf":1},"564":{"tf":2.6457513110645907},"565":{"tf":1.4142135623730951},"566":{"tf":1},"567":{"tf":1.4142135623730951},"568":{"tf":1.7320508075688772},"569":{"tf":1},"572":{"tf":2.6457513110645907},"618":{"tf":1},"621":{"tf":1},"622":{"tf":2},"623":{"tf":2},"625":{"tf":1},"630":{"tf":2},"631":{"tf":1.7320508075688772},"635":{"tf":1.4142135623730951},"636":{"tf":2.23606797749979},"637":{"tf":1},"641":{"tf":1},"642":{"tf":1.7320508075688772},"643":{"tf":1.7320508075688772},"646":{"tf":2.8284271247461903},"649":{"tf":1.7320508075688772},"653":{"tf":1.7320508075688772},"656":{"tf":1.4142135623730951},"657":{"tf":1.4142135623730951},"658":{"tf":1.4142135623730951},"659":{"tf":1.4142135623730951},"660":{"tf":1.4142135623730951},"661":{"tf":1.4142135623730951},"662":{"tf":2.23606797749979},"663":{"tf":1.4142135623730951},"671":{"tf":1},"677":{"tf":2.6457513110645907},"678":{"tf":1},"683":{"tf":1},"758":{"tf":1.4142135623730951},"764":{"tf":2.23606797749979},"768":{"tf":1},"771":{"tf":2.8284271247461903},"772":{"tf":1.4142135623730951},"773":{"tf":1},"774":{"tf":1.4142135623730951},"775":{"tf":1.7320508075688772},"776":{"tf":1},"779":{"tf":2.6457513110645907},"828":{"tf":1},"831":{"tf":1},"832":{"tf":2},"833":{"tf":2},"835":{"tf":1},"840":{"tf":2},"841":{"tf":1.7320508075688772},"845":{"tf":1.4142135623730951},"846":{"tf":2.23606797749979},"847":{"tf":1},"851":{"tf":1},"852":{"tf":1.7320508075688772},"853":{"tf":1.7320508075688772},"856":{"tf":2.8284271247461903},"859":{"tf":1.7320508075688772},"863":{"tf":1.7320508075688772},"866":{"tf":1.4142135623730951},"867":{"tf":1.4142135623730951},"868":{"tf":1.4142135623730951},"869":{"tf":1.4142135623730951},"870":{"tf":2.23606797749979},"871":{"tf":1.4142135623730951},"879":{"tf":1},"883":{"tf":2.8284271247461903},"909":{"tf":1},"913":{"tf":1},"914":{"tf":1.4142135623730951},"915":{"tf":1},"918":{"tf":1},"929":{"tf":1.7320508075688772},"934":{"tf":1.4142135623730951},"935":{"tf":2.23606797749979},"936":{"tf":1},"937":{"tf":1},"938":{"tf":2.6457513110645907},"939":{"tf":1.4142135623730951},"940":{"tf":1},"941":{"tf":4.123105625617661},"942":{"tf":1.4142135623730951},"943":{"tf":2.23606797749979},"946":{"tf":1},"948":{"tf":2.6457513110645907},"949":{"tf":1.4142135623730951},"950":{"tf":1.4142135623730951},"951":{"tf":1.7320508075688772},"953":{"tf":2},"954":{"tf":1},"955":{"tf":1},"956":{"tf":3.605551275463989},"957":{"tf":1},"958":{"tf":2},"961":{"tf":1.4142135623730951},"962":{"tf":1},"963":{"tf":1.4142135623730951}},"df":196,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{"101":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"106":{"tf":1},"109":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"175":{"tf":2},"176":{"tf":1.7320508075688772},"177":{"tf":1.7320508075688772},"178":{"tf":1},"181":{"tf":2},"182":{"tf":2.6457513110645907},"183":{"tf":1},"188":{"tf":1},"192":{"tf":1.4142135623730951},"198":{"tf":1},"332":{"tf":1.4142135623730951},"334":{"tf":1.4142135623730951},"335":{"tf":1.4142135623730951},"336":{"tf":1.4142135623730951},"337":{"tf":1},"340":{"tf":1},"403":{"tf":1.4142135623730951},"404":{"tf":1.4142135623730951},"410":{"tf":2},"411":{"tf":1.7320508075688772},"412":{"tf":1.7320508075688772},"413":{"tf":1},"416":{"tf":2},"417":{"tf":2.6457513110645907},"418":{"tf":1},"423":{"tf":1},"427":{"tf":1.4142135623730951},"433":{"tf":1},"564":{"tf":1.4142135623730951},"566":{"tf":1.4142135623730951},"567":{"tf":1.4142135623730951},"568":{"tf":1.4142135623730951},"569":{"tf":1},"572":{"tf":1},"622":{"tf":1.4142135623730951},"623":{"tf":1.4142135623730951},"629":{"tf":2},"630":{"tf":1.7320508075688772},"631":{"tf":1.7320508075688772},"632":{"tf":1},"635":{"tf":2},"636":{"tf":2.6457513110645907},"637":{"tf":1},"642":{"tf":1},"646":{"tf":1.4142135623730951},"652":{"tf":1},"771":{"tf":1.4142135623730951},"773":{"tf":1.4142135623730951},"774":{"tf":1.4142135623730951},"775":{"tf":1.4142135623730951},"776":{"tf":1},"779":{"tf":1},"832":{"tf":1.4142135623730951},"833":{"tf":1.4142135623730951},"839":{"tf":2},"840":{"tf":1.7320508075688772},"841":{"tf":1.7320508075688772},"842":{"tf":1},"845":{"tf":2},"846":{"tf":2.6457513110645907},"847":{"tf":1},"852":{"tf":1},"856":{"tf":1.4142135623730951},"862":{"tf":1},"883":{"tf":1},"898":{"tf":1},"899":{"tf":1},"903":{"tf":1.4142135623730951},"914":{"tf":1},"927":{"tf":1},"941":{"tf":1},"953":{"tf":1.4142135623730951},"956":{"tf":1.7320508075688772},"959":{"tf":1},"960":{"tf":1.4142135623730951},"961":{"tf":1},"962":{"tf":1.4142135623730951},"963":{"tf":1}},"df":86,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"182":{"tf":1},"417":{"tf":1},"636":{"tf":1},"846":{"tf":1}},"df":4}}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"182":{"tf":1},"417":{"tf":1},"636":{"tf":1},"846":{"tf":1}},"df":4}}}}}}}}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"101":{"tf":1.7320508075688772},"102":{"tf":1},"103":{"tf":1},"105":{"tf":1.7320508075688772},"168":{"tf":1},"169":{"tf":1.4142135623730951},"170":{"tf":1},"176":{"tf":1},"177":{"tf":1.4142135623730951},"178":{"tf":1},"332":{"tf":1.7320508075688772},"333":{"tf":1},"334":{"tf":1},"336":{"tf":1.7320508075688772},"403":{"tf":1},"404":{"tf":1.4142135623730951},"405":{"tf":1},"411":{"tf":1},"412":{"tf":1.4142135623730951},"413":{"tf":1},"564":{"tf":1.7320508075688772},"565":{"tf":1},"566":{"tf":1},"568":{"tf":1.7320508075688772},"622":{"tf":1},"623":{"tf":1.4142135623730951},"624":{"tf":1},"630":{"tf":1},"631":{"tf":1.4142135623730951},"632":{"tf":1},"771":{"tf":1.7320508075688772},"772":{"tf":1},"773":{"tf":1},"775":{"tf":1.7320508075688772},"832":{"tf":1},"833":{"tf":1.4142135623730951},"834":{"tf":1},"840":{"tf":1},"841":{"tf":1.4142135623730951},"842":{"tf":1}},"df":40}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"104":{"tf":1},"335":{"tf":1},"567":{"tf":1},"774":{"tf":1}},"df":4}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"164":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"399":{"tf":1.4142135623730951},"427":{"tf":1.4142135623730951},"618":{"tf":1.4142135623730951},"646":{"tf":1.4142135623730951},"828":{"tf":1.4142135623730951},"856":{"tf":1.4142135623730951},"903":{"tf":1}},"df":9}}}}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"168":{"tf":1},"403":{"tf":1},"622":{"tf":1},"832":{"tf":1},"950":{"tf":1}},"df":5}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{"938":{"tf":1},"951":{"tf":1}},"df":2}}}}}}},"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"948":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"956":{"tf":1}},"df":1}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"965":{"tf":1}},"df":1}}}}}}}},"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"953":{"tf":1}},"df":1}}}}}}},"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"948":{"tf":1.4142135623730951},"950":{"tf":1.4142135623730951},"962":{"tf":1}},"df":3}}}}}}}}},"s":{"docs":{},"df":0,"s":{"docs":{"47":{"tf":1},"229":{"tf":1},"253":{"tf":1},"279":{"tf":1},"461":{"tf":1},"511":{"tf":1},"675":{"tf":1},"699":{"tf":1},"725":{"tf":1.4142135623730951},"883":{"tf":1}},"df":10}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}},"/":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"14":{"tf":1},"97":{"tf":1},"246":{"tf":1},"328":{"tf":1},"478":{"tf":1},"560":{"tf":1},"692":{"tf":1},"767":{"tf":1}},"df":8,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"/":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"888":{"tf":1},"891":{"tf":1},"903":{"tf":1.4142135623730951},"907":{"tf":1.4142135623730951},"908":{"tf":1},"910":{"tf":1},"922":{"tf":1},"934":{"tf":1.4142135623730951},"935":{"tf":1},"937":{"tf":1}},"df":10}}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"891":{"tf":1},"904":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{"64":{"tf":1}},"df":1}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"/":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"295":{"tf":1}},"df":1}}}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"527":{"tf":1}},"df":1}}}}}}}}}}}}},"i":{"docs":{},"df":0,"o":{"docs":{"741":{"tf":1}},"df":1}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{"938":{"tf":1},"945":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{"198":{"tf":1},"433":{"tf":1},"652":{"tf":1},"862":{"tf":1}},"df":4}}}}}}},"b":{"docs":{},"df":0,"i":{"docs":{"67":{"tf":1},"298":{"tf":1},"351":{"tf":1},"530":{"tf":1},"744":{"tf":1}},"df":5},"l":{"docs":{"909":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"m":{"docs":{"119":{"tf":1},"122":{"tf":1},"354":{"tf":1},"357":{"tf":1}},"df":4}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2}}}}}}},"x":{"docs":{},"df":0,"i":{"docs":{"253":{"tf":1}},"df":1}},"j":{"docs":{},"df":0,"e":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"908":{"tf":1},"914":{"tf":1},"917":{"tf":1},"929":{"tf":1},"930":{"tf":1},"935":{"tf":1},"948":{"tf":1}},"df":7,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{"891":{"tf":1},"907":{"tf":1},"908":{"tf":1},"910":{"tf":1},"922":{"tf":1},"934":{"tf":1},"937":{"tf":1}},"df":7}}}}}}}}}},"c":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"938":{"tf":1},"941":{"tf":1},"946":{"tf":1}},"df":3,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"938":{"tf":1},"945":{"tf":1}},"df":2}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"946":{"tf":1},"953":{"tf":1},"965":{"tf":1}},"df":3}}}}}},"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"4":{"tf":1},"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1},"950":{"tf":1}},"df":6}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"246":{"tf":1},"478":{"tf":1},"692":{"tf":1}},"df":4}}}},"a":{"docs":{},"df":0,"t":{"docs":{"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":4}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"x":{"docs":{"122":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1},"247":{"tf":1},"479":{"tf":1},"693":{"tf":1}},"df":4}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}}}}}}}},"u":{"docs":{},"df":0,"f":{"docs":{"26":{"tf":1},"77":{"tf":1},"119":{"tf":1},"167":{"tf":1},"178":{"tf":1},"226":{"tf":1},"229":{"tf":1.4142135623730951},"231":{"tf":1},"258":{"tf":1},"308":{"tf":1},"354":{"tf":1},"402":{"tf":1},"413":{"tf":1},"458":{"tf":1},"461":{"tf":1.4142135623730951},"463":{"tf":1},"490":{"tf":1},"540":{"tf":1},"621":{"tf":1},"632":{"tf":1},"672":{"tf":1},"675":{"tf":1.4142135623730951},"677":{"tf":1},"704":{"tf":1},"755":{"tf":1.4142135623730951},"831":{"tf":1},"842":{"tf":1},"880":{"tf":1},"883":{"tf":1.7320508075688772},"892":{"tf":1},"900":{"tf":1},"918":{"tf":1},"939":{"tf":1},"941":{"tf":1.4142135623730951},"948":{"tf":1.4142135623730951},"953":{"tf":1}},"df":36,"t":{"docs":{"66":{"tf":1},"213":{"tf":1},"226":{"tf":1},"229":{"tf":1},"253":{"tf":1},"445":{"tf":1},"461":{"tf":1},"485":{"tf":1},"529":{"tf":1},"659":{"tf":1},"675":{"tf":1},"883":{"tf":1},"913":{"tf":1},"956":{"tf":1}},"df":14},"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{"168":{"tf":1.4142135623730951},"169":{"tf":1},"171":{"tf":1},"175":{"tf":1},"176":{"tf":1},"177":{"tf":1},"181":{"tf":1},"182":{"tf":2.23606797749979},"403":{"tf":1.4142135623730951},"404":{"tf":1},"406":{"tf":1},"410":{"tf":1},"411":{"tf":1},"412":{"tf":1},"416":{"tf":1},"417":{"tf":2.23606797749979},"622":{"tf":1.4142135623730951},"623":{"tf":1},"625":{"tf":1},"629":{"tf":1},"630":{"tf":1},"631":{"tf":1},"635":{"tf":1},"636":{"tf":2.23606797749979},"832":{"tf":1.4142135623730951},"833":{"tf":1},"835":{"tf":1},"839":{"tf":1},"840":{"tf":1},"841":{"tf":1},"845":{"tf":1},"846":{"tf":2.23606797749979}},"df":32}}}}}}},"n":{"docs":{},"df":0,"d":{"docs":{"892":{"tf":1},"953":{"tf":1.4142135623730951}},"df":2}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1}},"df":3}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"948":{"tf":1}},"df":1}}}}}}}}}},"e":{"docs":{},"df":0,"i":{"docs":{"169":{"tf":2},"171":{"tf":2.23606797749979},"176":{"tf":1.7320508075688772},"178":{"tf":1},"182":{"tf":1},"404":{"tf":2},"406":{"tf":2.23606797749979},"411":{"tf":1.7320508075688772},"413":{"tf":1},"417":{"tf":1},"623":{"tf":2},"625":{"tf":2.23606797749979},"630":{"tf":1.7320508075688772},"632":{"tf":1},"636":{"tf":1},"755":{"tf":1},"833":{"tf":2},"835":{"tf":2.23606797749979},"840":{"tf":1.7320508075688772},"842":{"tf":1},"846":{"tf":1},"892":{"tf":1},"917":{"tf":2.449489742783178}},"df":23,"s":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3}}}},"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"k":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"892":{"tf":1}},"df":1}}}}}}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"3":{"tf":1}},"df":1}}}}}}}}}}}}},"z":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"950":{"tf":1.4142135623730951},"951":{"tf":1},"953":{"tf":1},"956":{"tf":1}},"df":4}}}}}},"n":{"docs":{"917":{"tf":1}},"df":1}},"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{"215":{"tf":1},"447":{"tf":1},"661":{"tf":1}},"df":3}}}}}}}}}}}}}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1}},"df":1}},"s":{"docs":{},"df":0,"s":{"docs":{"195":{"tf":1},"296":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":5,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"8":{"tf":1},"43":{"tf":1.4142135623730951},"62":{"tf":1},"68":{"tf":1},"195":{"tf":1},"237":{"tf":1},"240":{"tf":1},"275":{"tf":1.4142135623730951},"294":{"tf":1},"299":{"tf":1},"305":{"tf":1},"350":{"tf":1.4142135623730951},"351":{"tf":1},"430":{"tf":1},"469":{"tf":1},"472":{"tf":1},"507":{"tf":1.4142135623730951},"526":{"tf":1},"531":{"tf":1},"649":{"tf":1},"683":{"tf":1},"721":{"tf":1.4142135623730951},"859":{"tf":1}},"df":23}}},"i":{"docs":{"231":{"tf":1},"354":{"tf":1},"463":{"tf":1},"677":{"tf":1},"883":{"tf":1}},"df":5,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1},"31":{"tf":1},"34":{"tf":1},"181":{"tf":1},"259":{"tf":1},"263":{"tf":1},"266":{"tf":1},"416":{"tf":1},"495":{"tf":1},"498":{"tf":1},"635":{"tf":1},"709":{"tf":1},"712":{"tf":1},"845":{"tf":1},"909":{"tf":1},"912":{"tf":1},"915":{"tf":1},"919":{"tf":1},"928":{"tf":1}},"df":19}}}},"t":{"docs":{"229":{"tf":1},"350":{"tf":1},"461":{"tf":1},"675":{"tf":1},"883":{"tf":1}},"df":5},"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"748":{"tf":1}},"df":1}}}}}},"u":{"docs":{},"df":0,"s":{"docs":{"43":{"tf":1},"157":{"tf":1},"161":{"tf":1},"275":{"tf":1},"392":{"tf":1},"396":{"tf":1},"507":{"tf":1},"611":{"tf":1},"615":{"tf":1},"721":{"tf":1},"821":{"tf":1},"825":{"tf":1}},"df":12,"i":{"docs":{"128":{"tf":1},"161":{"tf":1},"363":{"tf":1},"396":{"tf":1},"582":{"tf":1},"615":{"tf":1},"792":{"tf":1},"825":{"tf":1}},"df":8,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"131":{"tf":1},"137":{"tf":1},"144":{"tf":1.4142135623730951},"151":{"tf":1},"366":{"tf":1},"372":{"tf":1},"379":{"tf":1.4142135623730951},"386":{"tf":1},"585":{"tf":1},"591":{"tf":1},"598":{"tf":1.4142135623730951},"605":{"tf":1},"795":{"tf":1},"801":{"tf":1},"808":{"tf":1.4142135623730951},"815":{"tf":1}},"df":16}}}},"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"128":{"tf":1},"140":{"tf":1},"161":{"tf":1},"229":{"tf":1},"363":{"tf":1},"375":{"tf":1},"396":{"tf":1},"461":{"tf":1},"582":{"tf":1},"594":{"tf":1},"615":{"tf":1},"675":{"tf":1},"792":{"tf":1},"804":{"tf":1},"825":{"tf":1},"883":{"tf":1}},"df":16}}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"f":{"docs":{"131":{"tf":1},"157":{"tf":1},"161":{"tf":1},"183":{"tf":1},"366":{"tf":1},"392":{"tf":1},"396":{"tf":1},"418":{"tf":1},"585":{"tf":1},"611":{"tf":1},"615":{"tf":1},"637":{"tf":1},"795":{"tf":1},"821":{"tf":1},"825":{"tf":1},"847":{"tf":1}},"df":16}}}}}}}},"c":{"docs":{},"df":0,"k":{"docs":{"230":{"tf":1},"232":{"tf":1},"462":{"tf":1},"464":{"tf":1},"676":{"tf":1},"678":{"tf":1},"883":{"tf":1.4142135623730951},"920":{"tf":1}},"df":8,"a":{"docs":{},"df":0,"g":{"docs":{"94":{"tf":1.4142135623730951},"199":{"tf":1.7320508075688772},"202":{"tf":1.7320508075688772},"203":{"tf":2},"204":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"207":{"tf":1.4142135623730951},"208":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"210":{"tf":1.7320508075688772},"211":{"tf":1.7320508075688772},"212":{"tf":1.7320508075688772},"213":{"tf":1.7320508075688772},"214":{"tf":1.7320508075688772},"215":{"tf":1.4142135623730951},"216":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"231":{"tf":1.4142135623730951},"232":{"tf":1},"325":{"tf":1.4142135623730951},"434":{"tf":1.7320508075688772},"437":{"tf":1.7320508075688772},"438":{"tf":2},"439":{"tf":1.4142135623730951},"440":{"tf":1.4142135623730951},"441":{"tf":1.4142135623730951},"442":{"tf":1.7320508075688772},"443":{"tf":1.7320508075688772},"444":{"tf":1.7320508075688772},"445":{"tf":1.7320508075688772},"446":{"tf":1.7320508075688772},"447":{"tf":1.4142135623730951},"448":{"tf":1.4142135623730951},"449":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"464":{"tf":1},"557":{"tf":1.4142135623730951},"653":{"tf":1.7320508075688772},"656":{"tf":1.4142135623730951},"657":{"tf":1.7320508075688772},"658":{"tf":1.7320508075688772},"659":{"tf":1.7320508075688772},"660":{"tf":1.7320508075688772},"661":{"tf":1.4142135623730951},"662":{"tf":1.4142135623730951},"663":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"678":{"tf":1},"764":{"tf":1.4142135623730951},"863":{"tf":1.7320508075688772},"866":{"tf":1.4142135623730951},"867":{"tf":1.7320508075688772},"868":{"tf":1.7320508075688772},"869":{"tf":1.7320508075688772},"870":{"tf":1.4142135623730951},"871":{"tf":1.4142135623730951},"883":{"tf":1.7320508075688772},"915":{"tf":1},"918":{"tf":1},"934":{"tf":1},"938":{"tf":2},"939":{"tf":1},"940":{"tf":2.23606797749979},"941":{"tf":3.4641016151377544},"942":{"tf":1.7320508075688772},"946":{"tf":2},"947":{"tf":1},"948":{"tf":2.6457513110645907},"953":{"tf":2},"956":{"tf":1},"958":{"tf":1},"961":{"tf":1}},"df":73,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"946":{"tf":1}},"df":1}}}}}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"948":{"tf":1}},"df":1}}}}}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1},"357":{"tf":1},"941":{"tf":1.4142135623730951},"942":{"tf":1},"943":{"tf":1.4142135623730951},"956":{"tf":1}},"df":6}},"i":{"docs":{},"df":0,"k":{"docs":{"161":{"tf":1},"396":{"tf":1},"582":{"tf":1},"615":{"tf":1},"792":{"tf":1},"825":{"tf":1}},"df":6}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"169":{"tf":2.23606797749979},"176":{"tf":1},"177":{"tf":1},"178":{"tf":2},"192":{"tf":1.7320508075688772},"209":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"404":{"tf":2.23606797749979},"411":{"tf":1},"412":{"tf":1},"413":{"tf":2},"427":{"tf":1.7320508075688772},"449":{"tf":1.4142135623730951},"623":{"tf":2.23606797749979},"630":{"tf":1},"631":{"tf":1},"632":{"tf":2},"646":{"tf":1.7320508075688772},"663":{"tf":1.4142135623730951},"833":{"tf":2.23606797749979},"840":{"tf":1},"841":{"tf":1},"842":{"tf":2},"856":{"tf":1.7320508075688772},"871":{"tf":1.4142135623730951},"899":{"tf":1},"900":{"tf":1},"949":{"tf":1},"950":{"tf":1},"953":{"tf":1.4142135623730951},"960":{"tf":1.4142135623730951},"962":{"tf":2},"963":{"tf":2},"964":{"tf":1}},"df":34,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"181":{"tf":1},"182":{"tf":1.4142135623730951},"416":{"tf":1},"417":{"tf":1.4142135623730951},"635":{"tf":1},"636":{"tf":1.4142135623730951},"845":{"tf":1},"846":{"tf":1.4142135623730951},"953":{"tf":1}},"df":9}}}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{"938":{"tf":1}},"df":1}}}}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{"202":{"tf":1},"437":{"tf":1},"656":{"tf":1},"866":{"tf":1}},"df":4}}},"d":{"docs":{},"df":0,"f":{"docs":{"4":{"tf":1}},"df":1}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1},"143":{"tf":1},"205":{"tf":1},"312":{"tf":1},"378":{"tf":1},"440":{"tf":1},"544":{"tf":1},"597":{"tf":1},"758":{"tf":1},"807":{"tf":1}},"df":10,"i":{"docs":{},"df":0,"v":{"docs":{"5":{"tf":1},"125":{"tf":1},"350":{"tf":1},"360":{"tf":1},"789":{"tf":1}},"df":5}}}}},"p":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"119":{"tf":1},"128":{"tf":1},"134":{"tf":1},"177":{"tf":1},"178":{"tf":1.4142135623730951},"182":{"tf":1},"229":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"350":{"tf":1},"354":{"tf":1},"363":{"tf":1},"369":{"tf":1},"412":{"tf":1},"413":{"tf":1.4142135623730951},"417":{"tf":1},"461":{"tf":1.4142135623730951},"464":{"tf":1.4142135623730951},"582":{"tf":1},"588":{"tf":1},"631":{"tf":1},"632":{"tf":1.4142135623730951},"636":{"tf":1},"675":{"tf":1.4142135623730951},"678":{"tf":1.4142135623730951},"792":{"tf":1},"798":{"tf":1},"841":{"tf":1},"842":{"tf":1.4142135623730951},"846":{"tf":1},"883":{"tf":2}},"df":30,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"230":{"tf":1},"462":{"tf":1},"676":{"tf":1},"883":{"tf":1}},"df":4}}}}}}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}}}}},"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1},"116":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"485":{"tf":1},"579":{"tf":1.4142135623730951},"938":{"tf":1},"951":{"tf":1}},"df":7,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":4}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{"125":{"tf":1},"360":{"tf":1},"789":{"tf":1}},"df":3,"e":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"43":{"tf":1},"275":{"tf":1},"507":{"tf":1},"721":{"tf":1}},"df":4}}}}}}}}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"134":{"tf":1},"138":{"tf":1},"369":{"tf":1},"373":{"tf":1},"588":{"tf":1},"592":{"tf":1},"798":{"tf":1},"802":{"tf":1}},"df":8,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"137":{"tf":1},"372":{"tf":1},"591":{"tf":1},"801":{"tf":1}},"df":4}}}}}}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{"86":{"tf":1},"317":{"tf":1},"549":{"tf":1},"755":{"tf":1}},"df":4,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"699":{"tf":1}},"df":1,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{"125":{"tf":2},"360":{"tf":2}},"df":2},"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"917":{"tf":2}},"df":1,"i":{"docs":{},"df":0,"v":{"docs":{"917":{"tf":1}},"df":1}}}}}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"137":{"tf":1},"182":{"tf":1},"230":{"tf":1},"372":{"tf":1},"417":{"tf":1},"462":{"tf":1},"591":{"tf":1},"636":{"tf":1},"676":{"tf":1},"801":{"tf":1},"846":{"tf":1},"883":{"tf":1},"917":{"tf":1}},"df":13}}},"l":{"docs":{},"df":0,"l":{"docs":{"867":{"tf":1}},"df":1}},"s":{"docs":{},"df":0,"h":{"docs":{"867":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"264":{"tf":1},"496":{"tf":1},"710":{"tf":1}},"df":4,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"0":{"tf":1},"1":{"tf":1},"4":{"tf":2.23606797749979},"5":{"tf":1},"6":{"tf":1},"7":{"tf":1},"8":{"tf":1},"9":{"tf":1},"10":{"tf":1},"12":{"tf":1},"13":{"tf":1},"17":{"tf":1},"18":{"tf":1},"23":{"tf":1},"24":{"tf":1},"29":{"tf":1},"30":{"tf":1},"35":{"tf":1},"36":{"tf":1},"41":{"tf":1},"42":{"tf":1},"43":{"tf":1.4142135623730951},"44":{"tf":1},"45":{"tf":1},"48":{"tf":1},"49":{"tf":1},"51":{"tf":1},"52":{"tf":1},"53":{"tf":1},"57":{"tf":1},"58":{"tf":1},"59":{"tf":1},"60":{"tf":1},"61":{"tf":1},"69":{"tf":1},"70":{"tf":1},"75":{"tf":1},"76":{"tf":1},"79":{"tf":1},"80":{"tf":1},"84":{"tf":1},"85":{"tf":1},"88":{"tf":1},"89":{"tf":1},"92":{"tf":1},"93":{"tf":1},"95":{"tf":1},"96":{"tf":1},"99":{"tf":1},"100":{"tf":1},"107":{"tf":1},"108":{"tf":1},"110":{"tf":1},"111":{"tf":1},"113":{"tf":1},"114":{"tf":1},"117":{"tf":1},"118":{"tf":1},"123":{"tf":1},"124":{"tf":1},"126":{"tf":1},"127":{"tf":1},"129":{"tf":1},"130":{"tf":1},"135":{"tf":1},"136":{"tf":1},"141":{"tf":1},"142":{"tf":1},"147":{"tf":1},"148":{"tf":1},"153":{"tf":1},"154":{"tf":1},"159":{"tf":1},"160":{"tf":1},"161":{"tf":1},"162":{"tf":1},"163":{"tf":1},"165":{"tf":1},"166":{"tf":1},"173":{"tf":1},"174":{"tf":1},"176":{"tf":1},"179":{"tf":1},"180":{"tf":1},"185":{"tf":1},"186":{"tf":1},"190":{"tf":1},"191":{"tf":1},"193":{"tf":1},"194":{"tf":1},"196":{"tf":1},"197":{"tf":1},"200":{"tf":1},"201":{"tf":1},"218":{"tf":1},"219":{"tf":1},"221":{"tf":1},"222":{"tf":1},"227":{"tf":1},"228":{"tf":1},"235":{"tf":1},"236":{"tf":1},"237":{"tf":1},"238":{"tf":1},"239":{"tf":1},"240":{"tf":1},"241":{"tf":1},"242":{"tf":1},"244":{"tf":1},"245":{"tf":1},"249":{"tf":1},"250":{"tf":1},"255":{"tf":1},"256":{"tf":1},"261":{"tf":1},"262":{"tf":1},"267":{"tf":1},"268":{"tf":1},"273":{"tf":1},"274":{"tf":1},"275":{"tf":1.4142135623730951},"276":{"tf":1},"277":{"tf":1},"280":{"tf":1},"281":{"tf":1},"283":{"tf":1},"284":{"tf":1},"285":{"tf":1},"289":{"tf":1},"290":{"tf":1},"291":{"tf":1},"292":{"tf":1},"293":{"tf":1},"300":{"tf":1},"301":{"tf":1},"306":{"tf":1},"307":{"tf":1},"310":{"tf":1},"311":{"tf":1},"315":{"tf":1},"316":{"tf":1},"319":{"tf":1},"320":{"tf":1},"323":{"tf":1},"324":{"tf":1},"326":{"tf":1},"327":{"tf":1},"330":{"tf":1},"331":{"tf":1},"338":{"tf":1},"339":{"tf":1},"341":{"tf":1},"342":{"tf":1},"344":{"tf":1},"345":{"tf":1},"348":{"tf":1},"349":{"tf":1},"352":{"tf":1},"353":{"tf":1},"358":{"tf":1},"359":{"tf":1},"361":{"tf":1},"362":{"tf":1},"364":{"tf":1},"365":{"tf":1},"370":{"tf":1},"371":{"tf":1},"376":{"tf":1},"377":{"tf":1},"382":{"tf":1},"383":{"tf":1},"388":{"tf":1},"389":{"tf":1},"394":{"tf":1},"395":{"tf":1},"396":{"tf":1},"397":{"tf":1},"398":{"tf":1},"400":{"tf":1},"401":{"tf":1},"408":{"tf":1},"409":{"tf":1},"411":{"tf":1},"414":{"tf":1},"415":{"tf":1},"420":{"tf":1},"421":{"tf":1},"425":{"tf":1},"426":{"tf":1},"428":{"tf":1},"429":{"tf":1},"431":{"tf":1},"432":{"tf":1},"435":{"tf":1},"436":{"tf":1},"450":{"tf":1},"451":{"tf":1},"453":{"tf":1},"454":{"tf":1},"459":{"tf":1},"460":{"tf":1},"467":{"tf":1},"468":{"tf":1},"469":{"tf":1},"470":{"tf":1},"471":{"tf":1},"472":{"tf":1},"473":{"tf":1},"474":{"tf":1},"476":{"tf":1},"477":{"tf":1},"481":{"tf":1},"482":{"tf":1},"487":{"tf":1},"488":{"tf":1},"493":{"tf":1},"494":{"tf":1},"499":{"tf":1},"500":{"tf":1},"505":{"tf":1},"506":{"tf":1},"507":{"tf":1.4142135623730951},"508":{"tf":1},"509":{"tf":1},"512":{"tf":1},"513":{"tf":1},"515":{"tf":1},"516":{"tf":1},"517":{"tf":1},"521":{"tf":1},"522":{"tf":1},"523":{"tf":1},"524":{"tf":1},"525":{"tf":1},"532":{"tf":1},"533":{"tf":1},"538":{"tf":1},"539":{"tf":1},"542":{"tf":1},"543":{"tf":1},"547":{"tf":1},"548":{"tf":1},"551":{"tf":1},"552":{"tf":1},"555":{"tf":1},"556":{"tf":1},"558":{"tf":1},"559":{"tf":1},"562":{"tf":1},"563":{"tf":1},"570":{"tf":1},"571":{"tf":1},"573":{"tf":1},"574":{"tf":1},"576":{"tf":1},"577":{"tf":1},"580":{"tf":1},"581":{"tf":1},"583":{"tf":1},"584":{"tf":1},"589":{"tf":1},"590":{"tf":1},"595":{"tf":1},"596":{"tf":1},"601":{"tf":1},"602":{"tf":1},"607":{"tf":1},"608":{"tf":1},"613":{"tf":1},"614":{"tf":1},"615":{"tf":1},"616":{"tf":1},"617":{"tf":1},"619":{"tf":1},"620":{"tf":1},"627":{"tf":1},"628":{"tf":1},"630":{"tf":1},"633":{"tf":1},"634":{"tf":1},"639":{"tf":1},"640":{"tf":1},"644":{"tf":1},"645":{"tf":1},"647":{"tf":1},"648":{"tf":1},"650":{"tf":1},"651":{"tf":1},"654":{"tf":1},"655":{"tf":1},"664":{"tf":1},"665":{"tf":1},"667":{"tf":1},"668":{"tf":1},"673":{"tf":1},"674":{"tf":1},"681":{"tf":1},"682":{"tf":1},"683":{"tf":1},"684":{"tf":1},"685":{"tf":1},"686":{"tf":1.4142135623730951},"687":{"tf":1},"688":{"tf":1},"690":{"tf":1},"691":{"tf":1},"692":{"tf":1},"695":{"tf":1},"696":{"tf":1},"699":{"tf":1},"701":{"tf":1},"702":{"tf":1},"707":{"tf":1},"708":{"tf":1},"713":{"tf":1},"714":{"tf":1},"719":{"tf":1},"720":{"tf":1},"721":{"tf":1.4142135623730951},"722":{"tf":1},"723":{"tf":1},"726":{"tf":1},"727":{"tf":1},"729":{"tf":1},"730":{"tf":1},"731":{"tf":1},"735":{"tf":1},"736":{"tf":1},"737":{"tf":1},"738":{"tf":1},"739":{"tf":1},"745":{"tf":1},"746":{"tf":1},"753":{"tf":1},"754":{"tf":1},"756":{"tf":1},"757":{"tf":1},"762":{"tf":1},"763":{"tf":1},"765":{"tf":1},"766":{"tf":1},"769":{"tf":1},"770":{"tf":1},"777":{"tf":1},"778":{"tf":1},"780":{"tf":1},"781":{"tf":1},"783":{"tf":1},"784":{"tf":1},"787":{"tf":1},"788":{"tf":1},"790":{"tf":1},"791":{"tf":1},"793":{"tf":1},"794":{"tf":1},"799":{"tf":1},"800":{"tf":1},"805":{"tf":1},"806":{"tf":1},"811":{"tf":1},"812":{"tf":1},"817":{"tf":1},"818":{"tf":1},"823":{"tf":1},"824":{"tf":1},"825":{"tf":1},"826":{"tf":1},"827":{"tf":1},"829":{"tf":1},"830":{"tf":1},"837":{"tf":1},"838":{"tf":1},"840":{"tf":1},"843":{"tf":1},"844":{"tf":1},"849":{"tf":1},"850":{"tf":1},"854":{"tf":1},"855":{"tf":1},"857":{"tf":1},"858":{"tf":1},"860":{"tf":1},"861":{"tf":1},"864":{"tf":1},"865":{"tf":1},"872":{"tf":1},"873":{"tf":1},"875":{"tf":1},"876":{"tf":1},"881":{"tf":1},"882":{"tf":1},"886":{"tf":1},"887":{"tf":1},"888":{"tf":1.4142135623730951},"889":{"tf":1},"890":{"tf":1},"905":{"tf":1},"906":{"tf":1},"932":{"tf":1},"933":{"tf":1}},"df":400,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"253":{"tf":1}},"df":1}}}}}}}}}}}}},"n":{"docs":{"46":{"tf":1},"105":{"tf":1},"157":{"tf":1},"177":{"tf":1},"278":{"tf":1},"336":{"tf":1},"392":{"tf":1},"412":{"tf":1},"510":{"tf":1},"568":{"tf":1},"611":{"tf":1},"631":{"tf":1},"724":{"tf":1},"775":{"tf":1},"821":{"tf":1},"841":{"tf":1}},"df":16}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"1":{"docs":{"917":{"tf":1.7320508075688772}},"df":1},"2":{"docs":{"917":{"tf":1.7320508075688772}},"df":1},"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":2.8284271247461903},"8":{"tf":2.23606797749979},"14":{"tf":1.4142135623730951},"15":{"tf":1},"50":{"tf":1.4142135623730951},"78":{"tf":1},"81":{"tf":1.4142135623730951},"94":{"tf":2},"122":{"tf":1},"125":{"tf":2},"146":{"tf":1},"149":{"tf":1},"150":{"tf":1.7320508075688772},"157":{"tf":1},"161":{"tf":1.7320508075688772},"176":{"tf":1},"192":{"tf":1},"217":{"tf":1},"232":{"tf":1.7320508075688772},"234":{"tf":1},"240":{"tf":2.6457513110645907},"246":{"tf":1.4142135623730951},"247":{"tf":1},"282":{"tf":1.4142135623730951},"309":{"tf":1},"312":{"tf":1.4142135623730951},"325":{"tf":2},"350":{"tf":1},"351":{"tf":1},"354":{"tf":1},"357":{"tf":1},"360":{"tf":2},"381":{"tf":1},"384":{"tf":1},"385":{"tf":1.7320508075688772},"392":{"tf":1},"396":{"tf":1.7320508075688772},"411":{"tf":1},"427":{"tf":1},"449":{"tf":1},"464":{"tf":1.7320508075688772},"466":{"tf":1},"472":{"tf":2.449489742783178},"478":{"tf":1.4142135623730951},"479":{"tf":1},"514":{"tf":1.4142135623730951},"541":{"tf":1},"544":{"tf":1.4142135623730951},"557":{"tf":2},"600":{"tf":1},"603":{"tf":1},"604":{"tf":1.7320508075688772},"611":{"tf":1},"615":{"tf":1.7320508075688772},"630":{"tf":1},"646":{"tf":1},"663":{"tf":1},"678":{"tf":1.7320508075688772},"680":{"tf":1},"686":{"tf":1.7320508075688772},"692":{"tf":1.4142135623730951},"693":{"tf":1},"728":{"tf":1.4142135623730951},"748":{"tf":1.4142135623730951},"758":{"tf":1.4142135623730951},"764":{"tf":2},"789":{"tf":2},"810":{"tf":1},"813":{"tf":1},"814":{"tf":1.7320508075688772},"821":{"tf":1},"825":{"tf":1.7320508075688772},"840":{"tf":1},"856":{"tf":1},"871":{"tf":1},"883":{"tf":1.7320508075688772},"885":{"tf":1},"891":{"tf":1.7320508075688772},"892":{"tf":1},"893":{"tf":1.4142135623730951},"894":{"tf":1},"897":{"tf":1},"899":{"tf":1},"900":{"tf":1},"902":{"tf":1},"903":{"tf":1},"904":{"tf":1.4142135623730951},"908":{"tf":1},"910":{"tf":1},"912":{"tf":1},"915":{"tf":1},"917":{"tf":2.449489742783178},"918":{"tf":2},"922":{"tf":1},"924":{"tf":1},"926":{"tf":1},"928":{"tf":1},"929":{"tf":1},"934":{"tf":1},"935":{"tf":1.7320508075688772}},"df":101,"e":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1},"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{"3":{"tf":1},"27":{"tf":1},"259":{"tf":1},"491":{"tf":1},"705":{"tf":1}},"df":5,"s":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1},"54":{"tf":1},"286":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":5}}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1},"140":{"tf":1},"195":{"tf":1},"375":{"tf":1},"430":{"tf":1},"594":{"tf":1},"649":{"tf":1},"804":{"tf":1},"859":{"tf":1}},"df":9}}}}}},"n":{"docs":{},"df":0,"d":{"docs":{"14":{"tf":1},"15":{"tf":1},"20":{"tf":1},"62":{"tf":1.4142135623730951},"66":{"tf":1},"246":{"tf":1},"247":{"tf":1},"294":{"tf":1.4142135623730951},"295":{"tf":1},"478":{"tf":1},"479":{"tf":1},"484":{"tf":1},"526":{"tf":1.4142135623730951},"529":{"tf":1},"692":{"tf":1},"693":{"tf":1},"697":{"tf":1},"740":{"tf":1},"741":{"tf":1}},"df":19},"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"l":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}}}}}},"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"929":{"tf":1}},"df":1}}}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1}}}}}}}}}}},"s":{"docs":{},"df":0,"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"31":{"tf":1},"37":{"tf":1},"128":{"tf":1},"131":{"tf":1},"140":{"tf":1.4142135623730951},"144":{"tf":1},"149":{"tf":1},"158":{"tf":1},"161":{"tf":1},"177":{"tf":1},"182":{"tf":1},"263":{"tf":1},"269":{"tf":1},"363":{"tf":1},"366":{"tf":1},"375":{"tf":1.4142135623730951},"379":{"tf":1},"384":{"tf":1},"393":{"tf":1},"396":{"tf":1},"412":{"tf":1},"417":{"tf":1},"495":{"tf":1},"501":{"tf":1},"582":{"tf":1},"585":{"tf":1},"594":{"tf":1.4142135623730951},"598":{"tf":1},"603":{"tf":1},"612":{"tf":1},"615":{"tf":1},"631":{"tf":1},"636":{"tf":1},"709":{"tf":1},"715":{"tf":1},"792":{"tf":1},"795":{"tf":1},"804":{"tf":1.4142135623730951},"808":{"tf":1},"813":{"tf":1},"822":{"tf":1},"825":{"tf":1},"841":{"tf":1},"846":{"tf":1},"897":{"tf":1},"909":{"tf":1.7320508075688772},"913":{"tf":1},"914":{"tf":1},"926":{"tf":1}},"df":50}}}},"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{"51":{"tf":1},"283":{"tf":1},"515":{"tf":1},"729":{"tf":1}},"df":4}}}}}}}}}},"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"354":{"tf":1}},"df":1}}}}}}}}}}},"n":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"8":{"tf":1},"15":{"tf":1},"240":{"tf":1},"247":{"tf":1},"472":{"tf":1},"479":{"tf":1},"693":{"tf":1}},"df":7}}}}},"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{"143":{"tf":1},"378":{"tf":1},"597":{"tf":1},"807":{"tf":1},"893":{"tf":1}},"df":5}}}}}},"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1}}}}}}}}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{"25":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":2.23606797749979},"31":{"tf":1.7320508075688772},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"37":{"tf":1},"38":{"tf":1},"39":{"tf":1},"51":{"tf":2},"59":{"tf":1},"78":{"tf":1},"81":{"tf":2},"82":{"tf":2.449489742783178},"90":{"tf":1},"94":{"tf":1},"105":{"tf":1.4142135623730951},"137":{"tf":1.4142135623730951},"140":{"tf":2.449489742783178},"143":{"tf":1},"144":{"tf":1},"149":{"tf":1},"161":{"tf":1.4142135623730951},"168":{"tf":1},"169":{"tf":1},"172":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"176":{"tf":1},"178":{"tf":1},"181":{"tf":1.7320508075688772},"187":{"tf":1},"188":{"tf":1},"189":{"tf":1},"192":{"tf":2.23606797749979},"210":{"tf":2.23606797749979},"229":{"tf":2},"230":{"tf":1},"231":{"tf":1},"232":{"tf":2},"233":{"tf":1.4142135623730951},"234":{"tf":1},"257":{"tf":1.4142135623730951},"258":{"tf":1.4142135623730951},"259":{"tf":2.23606797749979},"263":{"tf":1.7320508075688772},"265":{"tf":1.7320508075688772},"266":{"tf":1.4142135623730951},"269":{"tf":1},"270":{"tf":1},"271":{"tf":1},"283":{"tf":2},"291":{"tf":1},"309":{"tf":1},"312":{"tf":2},"313":{"tf":2.449489742783178},"321":{"tf":1},"325":{"tf":1},"336":{"tf":1.4142135623730951},"372":{"tf":1.4142135623730951},"375":{"tf":2.449489742783178},"378":{"tf":1},"379":{"tf":1},"384":{"tf":1},"396":{"tf":1.4142135623730951},"403":{"tf":1},"404":{"tf":1},"407":{"tf":1.4142135623730951},"410":{"tf":1.7320508075688772},"411":{"tf":1},"413":{"tf":1},"416":{"tf":1.7320508075688772},"422":{"tf":1},"423":{"tf":1},"424":{"tf":1},"427":{"tf":2.23606797749979},"442":{"tf":2.23606797749979},"461":{"tf":2},"462":{"tf":1},"463":{"tf":1},"464":{"tf":2},"465":{"tf":1.4142135623730951},"466":{"tf":1},"489":{"tf":1.4142135623730951},"490":{"tf":1.4142135623730951},"491":{"tf":2.23606797749979},"495":{"tf":1.7320508075688772},"497":{"tf":1.7320508075688772},"498":{"tf":1.4142135623730951},"501":{"tf":1},"502":{"tf":1},"503":{"tf":1},"515":{"tf":2},"523":{"tf":1},"541":{"tf":1},"544":{"tf":2},"545":{"tf":2.449489742783178},"553":{"tf":1},"557":{"tf":1},"568":{"tf":1.4142135623730951},"591":{"tf":1.4142135623730951},"594":{"tf":2.449489742783178},"597":{"tf":1},"598":{"tf":1},"603":{"tf":1},"615":{"tf":1.4142135623730951},"622":{"tf":1},"623":{"tf":1},"626":{"tf":1.4142135623730951},"629":{"tf":1.7320508075688772},"630":{"tf":1},"632":{"tf":1},"635":{"tf":1.7320508075688772},"641":{"tf":1},"642":{"tf":1},"643":{"tf":1},"646":{"tf":2.23606797749979},"675":{"tf":2},"676":{"tf":1},"677":{"tf":1},"678":{"tf":2},"679":{"tf":1.4142135623730951},"680":{"tf":1},"703":{"tf":1.4142135623730951},"704":{"tf":1.4142135623730951},"705":{"tf":2.23606797749979},"709":{"tf":1.7320508075688772},"711":{"tf":1.7320508075688772},"712":{"tf":1.4142135623730951},"715":{"tf":1},"716":{"tf":1},"717":{"tf":1},"729":{"tf":2},"737":{"tf":1},"758":{"tf":2},"759":{"tf":2.449489742783178},"764":{"tf":1},"775":{"tf":1.4142135623730951},"801":{"tf":1.4142135623730951},"804":{"tf":2.449489742783178},"807":{"tf":1},"808":{"tf":1},"813":{"tf":1},"825":{"tf":1.4142135623730951},"832":{"tf":1},"833":{"tf":1},"836":{"tf":1.4142135623730951},"839":{"tf":1.7320508075688772},"840":{"tf":1},"842":{"tf":1},"845":{"tf":1.7320508075688772},"851":{"tf":1},"852":{"tf":1},"853":{"tf":1},"856":{"tf":2.23606797749979},"880":{"tf":1.4142135623730951},"883":{"tf":3.1622776601683795},"884":{"tf":1.4142135623730951},"885":{"tf":1},"892":{"tf":2},"893":{"tf":1.4142135623730951},"894":{"tf":2.23606797749979},"895":{"tf":1.7320508075688772},"896":{"tf":1},"898":{"tf":2.23606797749979},"901":{"tf":1},"902":{"tf":1},"903":{"tf":1.4142135623730951},"904":{"tf":1},"907":{"tf":1.4142135623730951},"908":{"tf":1.4142135623730951},"909":{"tf":3},"912":{"tf":1.4142135623730951},"913":{"tf":2},"915":{"tf":1.7320508075688772},"916":{"tf":1},"917":{"tf":2.6457513110645907},"918":{"tf":1.4142135623730951},"919":{"tf":2.23606797749979},"922":{"tf":1},"923":{"tf":1.4142135623730951},"924":{"tf":1},"926":{"tf":1},"928":{"tf":1}},"df":183,"l":{"docs":{"15":{"tf":1},"27":{"tf":1.4142135623730951},"56":{"tf":1},"81":{"tf":1},"97":{"tf":1},"106":{"tf":1},"122":{"tf":1},"137":{"tf":1},"161":{"tf":1},"167":{"tf":1},"192":{"tf":2},"247":{"tf":1},"259":{"tf":1.4142135623730951},"288":{"tf":1},"312":{"tf":1},"328":{"tf":1},"337":{"tf":1},"357":{"tf":1},"372":{"tf":1},"396":{"tf":1},"402":{"tf":1},"427":{"tf":2},"479":{"tf":1},"491":{"tf":1.4142135623730951},"520":{"tf":1},"544":{"tf":1},"560":{"tf":1},"569":{"tf":1},"591":{"tf":1},"615":{"tf":1},"621":{"tf":1},"646":{"tf":2},"693":{"tf":1},"705":{"tf":1.4142135623730951},"734":{"tf":1},"758":{"tf":1},"767":{"tf":1},"776":{"tf":1},"801":{"tf":1},"825":{"tf":1},"831":{"tf":1},"856":{"tf":2},"891":{"tf":1.4142135623730951},"892":{"tf":1.4142135623730951},"893":{"tf":1.4142135623730951},"894":{"tf":1},"895":{"tf":1},"903":{"tf":1},"904":{"tf":1.7320508075688772},"907":{"tf":1},"909":{"tf":1.4142135623730951},"910":{"tf":1},"913":{"tf":1},"914":{"tf":1.4142135623730951},"917":{"tf":1.4142135623730951},"918":{"tf":1.7320508075688772},"919":{"tf":1},"923":{"tf":1},"926":{"tf":1.4142135623730951},"927":{"tf":1.7320508075688772},"930":{"tf":1},"935":{"tf":2.6457513110645907},"936":{"tf":1},"941":{"tf":1},"943":{"tf":1}},"df":65,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"15":{"tf":1.4142135623730951},"16":{"tf":1},"50":{"tf":1.4142135623730951},"51":{"tf":1},"81":{"tf":2},"86":{"tf":1.4142135623730951},"140":{"tf":1},"192":{"tf":1},"247":{"tf":1.4142135623730951},"248":{"tf":1},"282":{"tf":1.4142135623730951},"283":{"tf":1},"312":{"tf":2},"317":{"tf":1.4142135623730951},"375":{"tf":1},"427":{"tf":1},"479":{"tf":1.4142135623730951},"480":{"tf":1},"514":{"tf":1.4142135623730951},"515":{"tf":1},"544":{"tf":2},"549":{"tf":1.4142135623730951},"594":{"tf":1},"646":{"tf":1},"693":{"tf":1.4142135623730951},"694":{"tf":1},"728":{"tf":1.4142135623730951},"729":{"tf":1},"758":{"tf":2},"804":{"tf":1},"856":{"tf":1},"893":{"tf":1},"894":{"tf":1.7320508075688772},"895":{"tf":1},"896":{"tf":1.4142135623730951},"898":{"tf":2.23606797749979},"899":{"tf":1},"900":{"tf":1},"903":{"tf":1.7320508075688772},"908":{"tf":1},"909":{"tf":1.4142135623730951},"910":{"tf":1.4142135623730951},"911":{"tf":1.4142135623730951},"914":{"tf":1.7320508075688772},"915":{"tf":1.4142135623730951},"918":{"tf":2.23606797749979},"919":{"tf":1},"922":{"tf":1},"924":{"tf":1},"926":{"tf":1.4142135623730951},"928":{"tf":1},"937":{"tf":1}},"df":52,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1},"283":{"tf":1},"515":{"tf":1},"729":{"tf":1}},"df":4}}}}}}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1},"32":{"tf":1},"258":{"tf":1},"264":{"tf":1},"490":{"tf":1},"496":{"tf":1},"704":{"tf":1},"710":{"tf":1}},"df":8}}}},"z":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"28":{"tf":1.4142135623730951},"260":{"tf":1.4142135623730951},"492":{"tf":1.4142135623730951},"706":{"tf":1.4142135623730951}},"df":4}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"901":{"tf":1}},"df":1}}},"'":{"docs":{"913":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"11":{"tf":1.7320508075688772},"14":{"tf":1.4142135623730951},"15":{"tf":1.7320508075688772},"21":{"tf":1},"27":{"tf":1},"38":{"tf":1},"56":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1},"68":{"tf":1},"74":{"tf":1},"81":{"tf":1.7320508075688772},"83":{"tf":1},"87":{"tf":1},"90":{"tf":1},"91":{"tf":1},"97":{"tf":1.4142135623730951},"105":{"tf":1},"106":{"tf":1},"112":{"tf":1},"115":{"tf":1},"116":{"tf":1},"119":{"tf":1},"132":{"tf":1},"134":{"tf":1.7320508075688772},"137":{"tf":1},"140":{"tf":1},"150":{"tf":1},"155":{"tf":1},"156":{"tf":1},"157":{"tf":1},"182":{"tf":1.7320508075688772},"187":{"tf":1},"189":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"195":{"tf":2.449489742783178},"199":{"tf":1},"210":{"tf":1},"229":{"tf":1},"232":{"tf":1.4142135623730951},"243":{"tf":1.7320508075688772},"246":{"tf":1.4142135623730951},"247":{"tf":1.7320508075688772},"252":{"tf":1},"253":{"tf":1},"259":{"tf":1},"270":{"tf":1},"288":{"tf":1.4142135623730951},"291":{"tf":1.4142135623730951},"294":{"tf":1.4142135623730951},"297":{"tf":1},"299":{"tf":1},"305":{"tf":1},"312":{"tf":1.7320508075688772},"314":{"tf":1},"318":{"tf":1},"321":{"tf":1},"322":{"tf":1},"328":{"tf":1.4142135623730951},"336":{"tf":1},"337":{"tf":1},"343":{"tf":1},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1},"354":{"tf":1.4142135623730951},"356":{"tf":1.7320508075688772},"367":{"tf":1},"369":{"tf":1.7320508075688772},"372":{"tf":1},"375":{"tf":1},"385":{"tf":1},"390":{"tf":1},"391":{"tf":1},"392":{"tf":1},"417":{"tf":1.7320508075688772},"422":{"tf":1},"424":{"tf":1.4142135623730951},"427":{"tf":1.7320508075688772},"430":{"tf":2.449489742783178},"434":{"tf":1},"442":{"tf":1},"461":{"tf":1},"464":{"tf":1.4142135623730951},"475":{"tf":1.7320508075688772},"478":{"tf":1.4142135623730951},"479":{"tf":1.7320508075688772},"491":{"tf":1},"502":{"tf":1},"520":{"tf":1.4142135623730951},"523":{"tf":1.4142135623730951},"526":{"tf":1.4142135623730951},"529":{"tf":1.4142135623730951},"530":{"tf":1},"531":{"tf":1},"537":{"tf":1},"544":{"tf":1.7320508075688772},"546":{"tf":1},"550":{"tf":1},"553":{"tf":1},"554":{"tf":1},"560":{"tf":1.4142135623730951},"568":{"tf":1},"569":{"tf":1},"575":{"tf":1},"578":{"tf":1},"579":{"tf":1},"586":{"tf":1},"588":{"tf":1.7320508075688772},"591":{"tf":1},"594":{"tf":1},"604":{"tf":1},"609":{"tf":1},"610":{"tf":1},"611":{"tf":1},"636":{"tf":1.7320508075688772},"641":{"tf":1},"643":{"tf":1.4142135623730951},"646":{"tf":1.7320508075688772},"649":{"tf":2.449489742783178},"653":{"tf":1},"675":{"tf":1},"678":{"tf":1.4142135623730951},"689":{"tf":1.4142135623730951},"692":{"tf":1.4142135623730951},"693":{"tf":1.7320508075688772},"699":{"tf":1},"705":{"tf":1},"716":{"tf":1},"734":{"tf":1.4142135623730951},"737":{"tf":1},"740":{"tf":1.4142135623730951},"743":{"tf":1},"744":{"tf":1},"752":{"tf":1},"758":{"tf":1.7320508075688772},"761":{"tf":1},"767":{"tf":1.4142135623730951},"775":{"tf":1},"776":{"tf":1},"785":{"tf":1},"796":{"tf":1},"798":{"tf":1.7320508075688772},"801":{"tf":1},"804":{"tf":1},"814":{"tf":1},"819":{"tf":1},"820":{"tf":1},"821":{"tf":1},"846":{"tf":1.7320508075688772},"851":{"tf":1},"853":{"tf":1.4142135623730951},"856":{"tf":1.7320508075688772},"859":{"tf":2.449489742783178},"863":{"tf":1},"883":{"tf":1.7320508075688772},"888":{"tf":1},"891":{"tf":1.4142135623730951},"895":{"tf":1},"896":{"tf":1.4142135623730951},"903":{"tf":1},"904":{"tf":1},"907":{"tf":1.7320508075688772},"908":{"tf":1.4142135623730951},"910":{"tf":1},"911":{"tf":1},"912":{"tf":1},"914":{"tf":1},"915":{"tf":1},"922":{"tf":1},"923":{"tf":1},"927":{"tf":1},"928":{"tf":1},"934":{"tf":1.4142135623730951},"935":{"tf":1.7320508075688772},"936":{"tf":1},"938":{"tf":1},"941":{"tf":1},"942":{"tf":1.4142135623730951},"947":{"tf":1.7320508075688772},"948":{"tf":1},"962":{"tf":1},"964":{"tf":1}},"df":186}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{"25":{"tf":1},"26":{"tf":1.4142135623730951},"27":{"tf":1},"32":{"tf":1.7320508075688772},"82":{"tf":1.7320508075688772},"97":{"tf":1.4142135623730951},"98":{"tf":1.4142135623730951},"102":{"tf":1},"103":{"tf":1},"105":{"tf":1.4142135623730951},"109":{"tf":2},"143":{"tf":1},"161":{"tf":1},"167":{"tf":1},"168":{"tf":1},"187":{"tf":1},"257":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":1},"264":{"tf":1.7320508075688772},"313":{"tf":1.7320508075688772},"328":{"tf":1.4142135623730951},"329":{"tf":1.4142135623730951},"333":{"tf":1},"334":{"tf":1},"336":{"tf":1.4142135623730951},"340":{"tf":2},"378":{"tf":1},"396":{"tf":1},"402":{"tf":1},"403":{"tf":1},"422":{"tf":1},"489":{"tf":1},"490":{"tf":1.4142135623730951},"491":{"tf":1},"496":{"tf":1.7320508075688772},"545":{"tf":1.7320508075688772},"560":{"tf":1.4142135623730951},"561":{"tf":1.4142135623730951},"565":{"tf":1},"566":{"tf":1},"568":{"tf":1.4142135623730951},"572":{"tf":2},"597":{"tf":1},"615":{"tf":1},"621":{"tf":1},"622":{"tf":1},"641":{"tf":1},"703":{"tf":1},"704":{"tf":1.4142135623730951},"705":{"tf":1},"710":{"tf":1.4142135623730951},"759":{"tf":1.7320508075688772},"767":{"tf":1.4142135623730951},"768":{"tf":1.4142135623730951},"772":{"tf":1},"773":{"tf":1},"775":{"tf":1.4142135623730951},"779":{"tf":2},"807":{"tf":1},"825":{"tf":1},"831":{"tf":1},"832":{"tf":1},"851":{"tf":1},"898":{"tf":1},"904":{"tf":1.4142135623730951},"917":{"tf":1},"918":{"tf":1.4142135623730951},"926":{"tf":1},"935":{"tf":1.7320508075688772},"938":{"tf":1},"951":{"tf":1},"952":{"tf":1}},"df":73,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1},"105":{"tf":1},"259":{"tf":1},"336":{"tf":1},"491":{"tf":1},"568":{"tf":1},"705":{"tf":1},"775":{"tf":1}},"df":8}}}}}}}}}},"e":{"docs":{},"df":0,"t":{"docs":{"232":{"tf":1.4142135623730951},"464":{"tf":1.4142135623730951},"678":{"tf":1.4142135623730951},"883":{"tf":1.4142135623730951}},"df":4}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"956":{"tf":1}},"df":1}}}}}}},"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{"27":{"tf":1},"37":{"tf":1},"38":{"tf":1},"50":{"tf":1.4142135623730951},"55":{"tf":1},"56":{"tf":1.4142135623730951},"90":{"tf":1},"131":{"tf":1.4142135623730951},"132":{"tf":1},"133":{"tf":1},"140":{"tf":1},"143":{"tf":1},"157":{"tf":1},"158":{"tf":1},"210":{"tf":1.4142135623730951},"259":{"tf":1},"269":{"tf":1},"270":{"tf":1},"282":{"tf":1.4142135623730951},"287":{"tf":1},"288":{"tf":1.4142135623730951},"321":{"tf":1},"366":{"tf":1.4142135623730951},"367":{"tf":1},"368":{"tf":1},"375":{"tf":1},"378":{"tf":1},"392":{"tf":1},"393":{"tf":1},"442":{"tf":1.4142135623730951},"491":{"tf":1},"501":{"tf":1},"502":{"tf":1},"514":{"tf":1.4142135623730951},"519":{"tf":1},"520":{"tf":1.4142135623730951},"553":{"tf":1},"585":{"tf":1.4142135623730951},"586":{"tf":1},"587":{"tf":1},"594":{"tf":1},"597":{"tf":1},"611":{"tf":1},"612":{"tf":1},"705":{"tf":1},"715":{"tf":1},"716":{"tf":1},"718":{"tf":1},"728":{"tf":1.4142135623730951},"733":{"tf":1},"734":{"tf":1.4142135623730951},"795":{"tf":1.4142135623730951},"796":{"tf":1},"797":{"tf":1},"804":{"tf":1},"807":{"tf":1},"821":{"tf":1},"822":{"tf":1},"912":{"tf":1},"926":{"tf":1},"928":{"tf":1}},"df":61}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"54":{"tf":1},"286":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":4}}}}}},"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"55":{"tf":1},"287":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":4}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":4}}}}}},"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"k":{"docs":{"237":{"tf":1},"469":{"tf":1},"683":{"tf":1}},"df":3}}}}}}}}}},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"155":{"tf":1},"390":{"tf":1},"609":{"tf":1},"686":{"tf":1.4142135623730951},"819":{"tf":1},"914":{"tf":1}},"df":6}}}}},".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"189":{"tf":1},"424":{"tf":1},"643":{"tf":1},"853":{"tf":1}},"df":4}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"895":{"tf":1.7320508075688772},"896":{"tf":1},"897":{"tf":1},"904":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"891":{"tf":1},"893":{"tf":1.4142135623730951},"896":{"tf":1.4142135623730951},"897":{"tf":1}},"df":4}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"896":{"tf":1}},"df":1}}}}}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"n":{"docs":{"892":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"904":{"tf":1}},"df":1}}}}}}}}}}}},"z":{"docs":{},"df":0,"u":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"917":{"tf":1.7320508075688772}},"df":1}}}}}}}}},"i":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"8":{"tf":1},"116":{"tf":1.4142135623730951},"195":{"tf":1},"232":{"tf":1},"240":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"354":{"tf":1},"430":{"tf":1},"464":{"tf":1},"472":{"tf":1},"579":{"tf":1.4142135623730951},"649":{"tf":1},"678":{"tf":1},"686":{"tf":1},"786":{"tf":1},"859":{"tf":1},"883":{"tf":1},"948":{"tf":1},"959":{"tf":1}},"df":20}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"3":{"tf":1},"119":{"tf":1},"122":{"tf":1},"351":{"tf":1},"354":{"tf":1},"357":{"tf":1}},"df":6}}},"k":{"docs":{"4":{"tf":1},"149":{"tf":1},"384":{"tf":1},"603":{"tf":1},"813":{"tf":1},"934":{"tf":1}},"df":6}},"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1.7320508075688772},"202":{"tf":1},"437":{"tf":1},"686":{"tf":1},"888":{"tf":1}},"df":5,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{"208":{"tf":1.4142135623730951},"441":{"tf":1.4142135623730951}},"df":2}}}}}}}}}}}}}}},"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"15":{"tf":1},"247":{"tf":1},"479":{"tf":1},"693":{"tf":1}},"df":4}}}},"x":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1.4142135623730951},"77":{"tf":1},"78":{"tf":1},"119":{"tf":1},"122":{"tf":2.23606797749979},"125":{"tf":1.7320508075688772},"155":{"tf":1.4142135623730951},"156":{"tf":1.4142135623730951},"157":{"tf":1},"168":{"tf":1},"169":{"tf":1},"170":{"tf":1.4142135623730951},"171":{"tf":2.23606797749979},"172":{"tf":1},"175":{"tf":1},"187":{"tf":1},"189":{"tf":1},"216":{"tf":1},"264":{"tf":1.4142135623730951},"308":{"tf":1},"309":{"tf":1},"350":{"tf":1.4142135623730951},"354":{"tf":1},"357":{"tf":2.449489742783178},"360":{"tf":1.7320508075688772},"390":{"tf":1.4142135623730951},"391":{"tf":1.4142135623730951},"392":{"tf":1},"403":{"tf":1},"404":{"tf":1},"405":{"tf":1.4142135623730951},"406":{"tf":2.23606797749979},"407":{"tf":1},"410":{"tf":1},"422":{"tf":1},"424":{"tf":1},"448":{"tf":1},"496":{"tf":1.4142135623730951},"540":{"tf":1},"541":{"tf":1},"609":{"tf":1.4142135623730951},"610":{"tf":1.4142135623730951},"611":{"tf":1},"622":{"tf":1},"623":{"tf":1},"624":{"tf":1.4142135623730951},"625":{"tf":2.23606797749979},"626":{"tf":1},"629":{"tf":1},"641":{"tf":1},"643":{"tf":1},"662":{"tf":1},"755":{"tf":1.4142135623730951},"786":{"tf":1.4142135623730951},"819":{"tf":1.4142135623730951},"820":{"tf":1.4142135623730951},"821":{"tf":1},"832":{"tf":1},"833":{"tf":1},"834":{"tf":1.4142135623730951},"835":{"tf":2.23606797749979},"836":{"tf":1},"839":{"tf":1},"851":{"tf":1},"853":{"tf":1},"870":{"tf":1},"883":{"tf":1.4142135623730951},"941":{"tf":1},"948":{"tf":2.449489742783178},"949":{"tf":1},"950":{"tf":1},"953":{"tf":2.449489742783178},"954":{"tf":1},"955":{"tf":1},"956":{"tf":1},"960":{"tf":1.4142135623730951},"962":{"tf":1.7320508075688772},"963":{"tf":1}},"df":78,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{"32":{"tf":1},"264":{"tf":1},"496":{"tf":1}},"df":3}}}}}},"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"77":{"tf":1},"308":{"tf":1},"540":{"tf":1}},"df":3}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3,"e":{"docs":{},"df":0,"x":{"docs":{"115":{"tf":1},"116":{"tf":2},"125":{"tf":1},"346":{"tf":1},"347":{"tf":2},"360":{"tf":1},"578":{"tf":1},"579":{"tf":2},"785":{"tf":1},"786":{"tf":1.4142135623730951}},"df":10}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"119":{"tf":1.4142135623730951},"120":{"tf":1},"122":{"tf":1.7320508075688772},"354":{"tf":1},"355":{"tf":1},"357":{"tf":1.7320508075688772}},"df":6,":":{"docs":{},"df":0,"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951}},"df":2}}}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"=":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}}}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"=":{"docs":{},"df":0,"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"125":{"tf":1},"253":{"tf":1},"350":{"tf":2},"360":{"tf":1},"748":{"tf":1.4142135623730951},"755":{"tf":1},"900":{"tf":1.4142135623730951},"941":{"tf":1},"948":{"tf":1.7320508075688772},"953":{"tf":1},"956":{"tf":2},"963":{"tf":1}},"df":12}}}}}},"a":{"docs":{},"df":0,"m":{"docs":{"43":{"tf":1.4142135623730951},"275":{"tf":1.4142135623730951},"351":{"tf":1},"507":{"tf":1.4142135623730951},"721":{"tf":1.4142135623730951}},"df":5}}},"y":{"docs":{},"df":0,"p":{"docs":{"3":{"tf":1},"63":{"tf":1},"77":{"tf":1},"116":{"tf":1.4142135623730951},"308":{"tf":1},"347":{"tf":1.4142135623730951},"540":{"tf":1},"579":{"tf":1.4142135623730951},"718":{"tf":1},"786":{"tf":1}},"df":10,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"192":{"tf":1},"427":{"tf":1},"646":{"tf":1},"856":{"tf":1},"908":{"tf":1},"941":{"tf":1}},"df":6,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"27":{"tf":1},"125":{"tf":1},"259":{"tf":1},"295":{"tf":1},"360":{"tf":1}},"df":5}}}}}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"956":{"tf":1.4142135623730951}},"df":1}}}}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1},"888":{"tf":1}},"df":2,"a":{"docs":{"43":{"tf":1},"119":{"tf":1},"275":{"tf":1},"354":{"tf":1},"507":{"tf":1},"721":{"tf":1},"782":{"tf":1},"917":{"tf":1}},"df":8}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"67":{"tf":1},"90":{"tf":1},"102":{"tf":1.4142135623730951},"132":{"tf":1},"161":{"tf":1},"176":{"tf":1},"298":{"tf":1},"321":{"tf":1},"333":{"tf":1.4142135623730951},"367":{"tf":1},"396":{"tf":1},"411":{"tf":1},"530":{"tf":1},"553":{"tf":1},"565":{"tf":1.4142135623730951},"582":{"tf":1},"586":{"tf":1},"615":{"tf":1},"630":{"tf":1},"744":{"tf":1},"772":{"tf":1.4142135623730951},"792":{"tf":1},"796":{"tf":1},"825":{"tf":1},"840":{"tf":1}},"df":25,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"4":{"tf":1}},"df":1}}}}},"k":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"37":{"tf":1},"38":{"tf":1},"81":{"tf":1},"90":{"tf":1},"128":{"tf":1},"161":{"tf":1},"269":{"tf":1},"270":{"tf":1},"312":{"tf":1},"321":{"tf":1},"363":{"tf":1},"396":{"tf":1},"501":{"tf":1},"502":{"tf":1},"544":{"tf":1},"553":{"tf":1},"582":{"tf":1},"615":{"tf":1},"715":{"tf":1},"716":{"tf":1},"758":{"tf":1},"792":{"tf":1},"825":{"tf":1}},"df":23}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"68":{"tf":1},"299":{"tf":1},"531":{"tf":1}},"df":3}}}}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"128":{"tf":1},"363":{"tf":1},"582":{"tf":1},"748":{"tf":1.4142135623730951},"792":{"tf":1}},"df":5,"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"72":{"tf":1},"303":{"tf":1},"535":{"tf":1}},"df":3}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{"94":{"tf":1},"325":{"tf":1},"557":{"tf":1},"764":{"tf":1}},"df":4}}}}}},"k":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"103":{"tf":1},"109":{"tf":1},"119":{"tf":1},"122":{"tf":1},"128":{"tf":1.7320508075688772},"134":{"tf":1},"158":{"tf":1},"168":{"tf":1},"182":{"tf":1},"232":{"tf":1},"334":{"tf":1},"340":{"tf":1},"354":{"tf":1},"357":{"tf":1},"363":{"tf":1.7320508075688772},"369":{"tf":1},"393":{"tf":1},"403":{"tf":1},"417":{"tf":1},"464":{"tf":1},"566":{"tf":1},"572":{"tf":1},"582":{"tf":1.7320508075688772},"588":{"tf":1},"612":{"tf":1},"622":{"tf":1},"636":{"tf":1},"678":{"tf":1},"773":{"tf":1},"779":{"tf":1},"792":{"tf":1.7320508075688772},"798":{"tf":1},"822":{"tf":1},"832":{"tf":1},"846":{"tf":1},"883":{"tf":1}},"df":36}}}}}}}}}}}},"b":{"docs":{"26":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"258":{"tf":1.4142135623730951},"303":{"tf":1.4142135623730951},"305":{"tf":1},"490":{"tf":1.4142135623730951},"535":{"tf":1.4142135623730951},"704":{"tf":1.4142135623730951},"750":{"tf":1.4142135623730951},"941":{"tf":1}},"df":10,"e":{"docs":{},"df":0,"l":{"docs":{"72":{"tf":1},"116":{"tf":1},"122":{"tf":2},"125":{"tf":1},"128":{"tf":1.7320508075688772},"155":{"tf":1},"169":{"tf":1},"175":{"tf":1},"176":{"tf":1.4142135623730951},"177":{"tf":1.7320508075688772},"178":{"tf":1},"181":{"tf":2.23606797749979},"182":{"tf":2.8284271247461903},"183":{"tf":1.4142135623730951},"187":{"tf":1},"189":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"208":{"tf":1.4142135623730951},"226":{"tf":1},"229":{"tf":1},"231":{"tf":1.7320508075688772},"232":{"tf":1},"303":{"tf":1},"347":{"tf":1},"350":{"tf":1.4142135623730951},"354":{"tf":1},"357":{"tf":2.449489742783178},"360":{"tf":1},"363":{"tf":1.7320508075688772},"390":{"tf":1},"404":{"tf":1},"410":{"tf":1},"411":{"tf":1.4142135623730951},"412":{"tf":1.7320508075688772},"413":{"tf":1},"416":{"tf":2.23606797749979},"417":{"tf":2.8284271247461903},"418":{"tf":1.4142135623730951},"422":{"tf":1},"424":{"tf":1.4142135623730951},"427":{"tf":1.4142135623730951},"441":{"tf":1.4142135623730951},"458":{"tf":1},"461":{"tf":1},"463":{"tf":1.7320508075688772},"464":{"tf":1},"535":{"tf":1},"579":{"tf":1},"582":{"tf":1.7320508075688772},"609":{"tf":1},"623":{"tf":1},"629":{"tf":1},"630":{"tf":1.4142135623730951},"631":{"tf":1.7320508075688772},"632":{"tf":1},"635":{"tf":2.23606797749979},"636":{"tf":2.8284271247461903},"637":{"tf":1.4142135623730951},"641":{"tf":1},"643":{"tf":1.4142135623730951},"646":{"tf":1.4142135623730951},"672":{"tf":1},"675":{"tf":1},"677":{"tf":1.7320508075688772},"678":{"tf":1},"750":{"tf":1},"786":{"tf":1.4142135623730951},"792":{"tf":1.7320508075688772},"819":{"tf":1},"833":{"tf":1},"839":{"tf":1},"840":{"tf":1.4142135623730951},"841":{"tf":1.7320508075688772},"842":{"tf":1},"845":{"tf":2.23606797749979},"846":{"tf":2.8284271247461903},"847":{"tf":1.4142135623730951},"851":{"tf":1},"853":{"tf":1.4142135623730951},"856":{"tf":1.4142135623730951},"880":{"tf":1},"883":{"tf":1.4142135623730951},"897":{"tf":1},"940":{"tf":1},"941":{"tf":1}},"df":85,"l":{"docs":{"112":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":1},"208":{"tf":1},"305":{"tf":1},"343":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":1},"350":{"tf":2},"441":{"tf":1},"575":{"tf":1},"578":{"tf":1.4142135623730951},"579":{"tf":1},"782":{"tf":1},"785":{"tf":1.4142135623730951},"786":{"tf":1}},"df":16,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"115":{"tf":1.4142135623730951},"116":{"tf":1},"125":{"tf":1},"208":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":1},"350":{"tf":1.4142135623730951},"360":{"tf":1},"441":{"tf":1},"578":{"tf":1.4142135623730951},"579":{"tf":1}},"df":11},"i":{"docs":{},"df":0,"l":{"docs":{"116":{"tf":1},"229":{"tf":1.4142135623730951},"347":{"tf":1},"461":{"tf":1.4142135623730951},"579":{"tf":1},"675":{"tf":1.4142135623730951}},"df":6}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3}}}}}}}},"l":{"docs":{"208":{"tf":1},"350":{"tf":1},"441":{"tf":1}},"df":3,"e":{"docs":{},"df":0,":":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"=":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"@":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"&":{"0":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2},"docs":{},"df":0}}}}}}}}}}}}}}}}}}}}}}}}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"941":{"tf":1}},"df":1}}}}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"77":{"tf":1},"308":{"tf":1},"540":{"tf":1}},"df":3}}}},"t":{"docs":{"237":{"tf":1},"469":{"tf":1},"683":{"tf":1}},"df":3,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"155":{"tf":1},"390":{"tf":1},"609":{"tf":1},"819":{"tf":1}},"df":4}}}}},"g":{"docs":{"935":{"tf":1}},"df":1}},"o":{"docs":{"393":{"tf":1},"612":{"tf":1},"822":{"tf":1}},"df":3,"o":{"docs":{},"df":0,"l":{"docs":{"55":{"tf":1},"287":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":4,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951}},"df":2}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"184":{"tf":1},"419":{"tf":1},"638":{"tf":1},"848":{"tf":1}},"df":4}}},"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"351":{"tf":1.7320508075688772}},"df":1}}}}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":4}}}}}}}}}}}},"p":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"213":{"tf":1},"445":{"tf":1},"659":{"tf":1}},"df":3}}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"101":{"tf":1},"116":{"tf":1},"169":{"tf":1.4142135623730951},"171":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":2.23606797749979},"332":{"tf":1},"347":{"tf":1},"404":{"tf":1.4142135623730951},"406":{"tf":1},"463":{"tf":1.4142135623730951},"464":{"tf":2.23606797749979},"564":{"tf":1},"579":{"tf":1},"623":{"tf":1.4142135623730951},"625":{"tf":1},"677":{"tf":1.4142135623730951},"678":{"tf":2.23606797749979},"771":{"tf":1},"833":{"tf":1.4142135623730951},"835":{"tf":1},"883":{"tf":2.6457513110645907},"915":{"tf":1}},"df":23},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"893":{"tf":1}},"df":1}}}}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"116":{"tf":1},"217":{"tf":1.4142135623730951},"347":{"tf":1},"449":{"tf":1.4142135623730951},"579":{"tf":1},"663":{"tf":1.4142135623730951},"871":{"tf":1.4142135623730951}},"df":7}}}}},"t":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1},"786":{"tf":1}},"df":4}}},"e":{"docs":{"209":{"tf":1}},"df":1}},"i":{"docs":{"749":{"tf":1},"750":{"tf":1},"926":{"tf":1},"927":{"tf":1.7320508075688772}},"df":4,"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"131":{"tf":1},"366":{"tf":1},"585":{"tf":1},"795":{"tf":1}},"df":4}}},"t":{"docs":{},"df":0,"t":{"docs":{"140":{"tf":1},"375":{"tf":1},"594":{"tf":1},"804":{"tf":1}},"df":4}}},"u":{"docs":{},"df":0,"e":{"docs":{"203":{"tf":1},"224":{"tf":1},"226":{"tf":1},"232":{"tf":1.4142135623730951},"438":{"tf":1},"456":{"tf":1},"458":{"tf":1},"464":{"tf":1.4142135623730951},"670":{"tf":1},"672":{"tf":1},"678":{"tf":1.4142135623730951},"878":{"tf":1},"880":{"tf":1},"883":{"tf":1.4142135623730951}},"df":14}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,":":{"docs":{},"df":0,"k":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"@":{"docs":{},"df":0,"#":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,":":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"=":{"docs":{},"df":0,"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"=":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"@":{"docs":{},"df":0,"#":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,":":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"=":{"docs":{},"df":0,"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"l":{"docs":{"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951}},"df":2}}},"e":{"docs":{},"df":0,"f":{"docs":{"354":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{"351":{"tf":1}},"df":1}}}}}}}},"d":{"docs":{"350":{"tf":1.4142135623730951}},"df":1}},"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"2":{"tf":1}},"df":1}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{"39":{"tf":1},"109":{"tf":1},"271":{"tf":1},"340":{"tf":1},"503":{"tf":1},"572":{"tf":1},"717":{"tf":1},"779":{"tf":1},"909":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1},"34":{"tf":1},"266":{"tf":1},"354":{"tf":1},"498":{"tf":1},"712":{"tf":1}},"df":6}}}}}}},"t":{"docs":{"351":{"tf":1}},"df":1}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"26":{"tf":1},"55":{"tf":1},"258":{"tf":1},"287":{"tf":1},"490":{"tf":1},"519":{"tf":1},"704":{"tf":1},"733":{"tf":1}},"df":8}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"19":{"tf":1.4142135623730951},"20":{"tf":1},"21":{"tf":1},"51":{"tf":1},"67":{"tf":1},"81":{"tf":1.4142135623730951},"115":{"tf":1},"116":{"tf":1},"119":{"tf":1},"140":{"tf":1.7320508075688772},"187":{"tf":1},"192":{"tf":1},"223":{"tf":1},"226":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"251":{"tf":1.4142135623730951},"252":{"tf":1},"253":{"tf":1.4142135623730951},"283":{"tf":1},"298":{"tf":1},"312":{"tf":1.4142135623730951},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1.4142135623730951},"354":{"tf":1},"375":{"tf":1.7320508075688772},"422":{"tf":1},"427":{"tf":1},"455":{"tf":1},"458":{"tf":1.7320508075688772},"464":{"tf":1.4142135623730951},"483":{"tf":1.4142135623730951},"484":{"tf":1},"485":{"tf":1},"515":{"tf":1},"530":{"tf":1},"544":{"tf":1.4142135623730951},"578":{"tf":1},"579":{"tf":1},"594":{"tf":1.7320508075688772},"641":{"tf":1},"646":{"tf":1},"669":{"tf":1},"672":{"tf":1.7320508075688772},"678":{"tf":1.4142135623730951},"697":{"tf":1.4142135623730951},"698":{"tf":1},"699":{"tf":1},"729":{"tf":1},"744":{"tf":1},"758":{"tf":1.4142135623730951},"785":{"tf":1},"804":{"tf":1.7320508075688772},"851":{"tf":1},"856":{"tf":1},"877":{"tf":1},"883":{"tf":1.4142135623730951},"894":{"tf":1},"898":{"tf":1},"908":{"tf":1},"909":{"tf":2},"910":{"tf":1},"911":{"tf":1},"913":{"tf":2},"917":{"tf":1},"918":{"tf":1},"919":{"tf":1},"923":{"tf":1}},"df":68,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{"4":{"tf":1},"749":{"tf":1},"750":{"tf":1}},"df":3}}}}}}}},"\"":{"docs":{},"df":0,"/":{"docs":{},"df":0,"\"":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{"15":{"tf":1},"247":{"tf":1},"479":{"tf":1},"693":{"tf":1}},"df":4}}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"51":{"tf":1},"283":{"tf":1},"515":{"tf":1},"729":{"tf":1},"894":{"tf":1},"895":{"tf":1},"907":{"tf":1.4142135623730951},"909":{"tf":2.449489742783178},"910":{"tf":1},"913":{"tf":1},"916":{"tf":1},"917":{"tf":1.7320508075688772}},"df":12}}}}}},"z":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{"4":{"tf":1}},"df":1},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":4}}}}}},"h":{"docs":{"82":{"tf":1},"313":{"tf":1},"545":{"tf":1},"759":{"tf":1},"891":{"tf":1},"907":{"tf":1},"912":{"tf":1},"915":{"tf":1},"920":{"tf":1},"934":{"tf":1},"943":{"tf":1},"958":{"tf":1},"961":{"tf":1}},"df":13,"e":{"docs":{},"df":0,"r":{"docs":{"94":{"tf":1},"150":{"tf":1},"325":{"tf":1},"385":{"tf":1},"557":{"tf":1},"604":{"tf":1},"764":{"tf":1},"814":{"tf":1},"919":{"tf":1}},"df":9}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"122":{"tf":1},"125":{"tf":1.7320508075688772},"128":{"tf":1},"161":{"tf":1},"176":{"tf":1},"182":{"tf":1},"195":{"tf":1},"210":{"tf":1},"354":{"tf":1},"357":{"tf":1.7320508075688772},"360":{"tf":1.7320508075688772},"363":{"tf":1},"396":{"tf":1},"411":{"tf":1},"417":{"tf":1},"430":{"tf":1},"442":{"tf":1},"582":{"tf":1},"615":{"tf":1},"630":{"tf":1},"636":{"tf":1},"649":{"tf":1},"789":{"tf":1},"792":{"tf":1},"825":{"tf":1},"840":{"tf":1},"846":{"tf":1},"859":{"tf":1}},"df":28}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{"97":{"tf":1},"328":{"tf":1},"560":{"tf":1},"767":{"tf":1}},"df":4}}},"a":{"docs":{},"df":0,"m":{"docs":{"125":{"tf":1.7320508075688772},"360":{"tf":1.7320508075688772}},"df":2}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"119":{"tf":1},"354":{"tf":1},"895":{"tf":1},"909":{"tf":1},"960":{"tf":1}},"df":5}}}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"146":{"tf":1},"381":{"tf":1},"600":{"tf":1},"810":{"tf":1}},"df":4}}}}},"k":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"122":{"tf":1},"357":{"tf":1},"540":{"tf":1}},"df":3}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{"155":{"tf":1},"350":{"tf":1},"390":{"tf":1},"609":{"tf":1},"819":{"tf":1}},"df":5}}},"a":{"docs":{},"df":0,"g":{"docs":{"948":{"tf":1},"957":{"tf":1}},"df":2}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"161":{"tf":1},"396":{"tf":1},"615":{"tf":1},"825":{"tf":1}},"df":4}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"351":{"tf":1.4142135623730951}},"df":1}}}}}}}}},"i":{"docs":{},"df":0,"g":{"docs":{"177":{"tf":1},"181":{"tf":1},"412":{"tf":1},"416":{"tf":1},"631":{"tf":1},"635":{"tf":1},"841":{"tf":1},"845":{"tf":1},"898":{"tf":1},"917":{"tf":1},"918":{"tf":1},"926":{"tf":1},"945":{"tf":1},"953":{"tf":1},"956":{"tf":1},"958":{"tf":1},"965":{"tf":1}},"df":17}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{},"df":0,"t":{"docs":{"199":{"tf":1},"434":{"tf":1},"653":{"tf":1},"863":{"tf":1}},"df":4}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"305":{"tf":1},"686":{"tf":1}},"df":2}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"350":{"tf":1},"909":{"tf":1},"915":{"tf":1},"934":{"tf":1},"962":{"tf":1}},"df":5,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"253":{"tf":1}},"df":1}}}}}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"718":{"tf":1}},"df":1}}}}}}}}}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"4":{"tf":1},"116":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"579":{"tf":1.4142135623730951},"909":{"tf":1}},"df":5}}}}}}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"39":{"tf":1},"47":{"tf":1},"50":{"tf":1},"128":{"tf":1},"140":{"tf":1},"195":{"tf":1},"271":{"tf":1},"279":{"tf":1},"282":{"tf":1},"363":{"tf":1},"375":{"tf":1},"430":{"tf":1},"503":{"tf":1},"511":{"tf":1},"514":{"tf":1},"582":{"tf":1},"594":{"tf":1},"649":{"tf":1},"717":{"tf":1},"725":{"tf":1},"728":{"tf":1},"792":{"tf":1},"804":{"tf":1},"859":{"tf":1},"901":{"tf":1},"942":{"tf":1},"950":{"tf":1},"951":{"tf":1}},"df":28}}}}},"i":{"docs":{},"df":0,"g":{"docs":{"161":{"tf":1},"396":{"tf":1},"615":{"tf":1},"825":{"tf":1}},"df":4}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{"119":{"tf":1},"122":{"tf":1},"125":{"tf":1},"134":{"tf":1},"158":{"tf":1},"161":{"tf":1},"209":{"tf":1},"220":{"tf":1},"229":{"tf":1},"354":{"tf":1},"357":{"tf":1},"360":{"tf":1},"369":{"tf":1},"393":{"tf":1},"396":{"tf":1},"452":{"tf":1},"461":{"tf":1},"588":{"tf":1},"612":{"tf":1},"615":{"tf":1},"666":{"tf":1},"675":{"tf":1},"747":{"tf":1},"789":{"tf":1},"798":{"tf":1},"822":{"tf":1},"825":{"tf":1},"874":{"tf":1},"883":{"tf":1},"962":{"tf":1}},"df":30,"t":{"docs":{"3":{"tf":1},"354":{"tf":1}},"df":2},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"11":{"tf":1},"43":{"tf":1.4142135623730951},"59":{"tf":1},"77":{"tf":1},"94":{"tf":1},"112":{"tf":1},"128":{"tf":1},"164":{"tf":1},"195":{"tf":1},"210":{"tf":1.4142135623730951},"211":{"tf":1},"212":{"tf":1},"213":{"tf":1},"215":{"tf":1},"220":{"tf":1},"237":{"tf":1},"243":{"tf":1},"275":{"tf":1.4142135623730951},"291":{"tf":1},"308":{"tf":1},"325":{"tf":1},"343":{"tf":1},"354":{"tf":1},"363":{"tf":1},"399":{"tf":1},"430":{"tf":1},"442":{"tf":1.4142135623730951},"443":{"tf":1},"444":{"tf":1},"445":{"tf":1},"447":{"tf":1},"452":{"tf":1},"469":{"tf":1},"475":{"tf":1},"507":{"tf":1.4142135623730951},"523":{"tf":1},"540":{"tf":1},"557":{"tf":1},"575":{"tf":1},"582":{"tf":1},"618":{"tf":1},"649":{"tf":1},"657":{"tf":1},"658":{"tf":1},"659":{"tf":1},"661":{"tf":1},"666":{"tf":1},"683":{"tf":1},"699":{"tf":1.4142135623730951},"721":{"tf":1.4142135623730951},"741":{"tf":1},"742":{"tf":1},"792":{"tf":1},"828":{"tf":1},"859":{"tf":1},"867":{"tf":1},"868":{"tf":1},"874":{"tf":1},"914":{"tf":1}},"df":60}}}}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":1.4142135623730951},"43":{"tf":1},"122":{"tf":1},"195":{"tf":1},"275":{"tf":1},"354":{"tf":1},"357":{"tf":1},"430":{"tf":1},"507":{"tf":1},"649":{"tf":1},"721":{"tf":1},"859":{"tf":1}},"df":13,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{"64":{"tf":1},"295":{"tf":1},"527":{"tf":1}},"df":3}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{"953":{"tf":1}},"df":1}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"26":{"tf":1},"258":{"tf":1},"490":{"tf":1},"704":{"tf":1}},"df":4,"n":{"docs":{},"df":0,"i":{"docs":{"177":{"tf":1},"412":{"tf":1},"631":{"tf":1},"841":{"tf":1}},"df":4}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{"27":{"tf":1},"43":{"tf":1},"86":{"tf":1},"116":{"tf":1},"182":{"tf":1},"192":{"tf":1},"220":{"tf":1},"259":{"tf":1},"275":{"tf":1},"317":{"tf":1},"347":{"tf":1},"351":{"tf":1},"417":{"tf":1},"427":{"tf":1},"452":{"tf":1},"491":{"tf":1},"507":{"tf":1},"549":{"tf":1},"579":{"tf":1},"636":{"tf":1},"646":{"tf":1},"666":{"tf":1},"705":{"tf":1},"721":{"tf":1},"846":{"tf":1},"856":{"tf":1},"874":{"tf":1},"917":{"tf":1},"931":{"tf":1}},"df":29,"e":{"docs":{},"df":0,"n":{"docs":{"143":{"tf":1},"378":{"tf":1},"597":{"tf":1},"807":{"tf":1},"867":{"tf":1}},"df":5}}},"b":{"docs":{"81":{"tf":1.4142135623730951},"82":{"tf":1},"86":{"tf":1},"102":{"tf":1},"232":{"tf":1.4142135623730951},"312":{"tf":1.4142135623730951},"313":{"tf":1},"317":{"tf":1},"333":{"tf":1},"464":{"tf":1.4142135623730951},"544":{"tf":1.4142135623730951},"545":{"tf":1},"549":{"tf":1},"565":{"tf":1},"678":{"tf":1.4142135623730951},"758":{"tf":1.4142135623730951},"759":{"tf":1},"772":{"tf":1},"883":{"tf":1.4142135623730951},"911":{"tf":1},"914":{"tf":1},"915":{"tf":1},"927":{"tf":1.4142135623730951},"941":{"tf":1},"942":{"tf":1}},"df":25,"t":{"docs":{"213":{"tf":1},"445":{"tf":1},"659":{"tf":1}},"df":3}}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"47":{"tf":1},"279":{"tf":1},"511":{"tf":1},"535":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"t":{"docs":{"86":{"tf":1},"317":{"tf":1},"535":{"tf":1},"549":{"tf":1}},"df":4}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"109":{"tf":1},"183":{"tf":1},"340":{"tf":1},"418":{"tf":1},"572":{"tf":1},"637":{"tf":1},"779":{"tf":1},"847":{"tf":1}},"df":8}}}},"o":{"docs":{},"df":0,"b":{"docs":{"86":{"tf":1},"101":{"tf":1},"103":{"tf":1},"105":{"tf":1},"317":{"tf":1},"332":{"tf":1},"334":{"tf":1},"336":{"tf":1},"549":{"tf":1},"564":{"tf":1},"566":{"tf":1},"568":{"tf":1},"771":{"tf":1},"773":{"tf":1},"775":{"tf":1},"914":{"tf":1},"915":{"tf":1}},"df":17}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"895":{"tf":1},"904":{"tf":1},"917":{"tf":1.7320508075688772},"918":{"tf":1},"920":{"tf":1}},"df":5},"n":{"docs":{"920":{"tf":1},"931":{"tf":1}},"df":2}}}}}}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"82":{"tf":1},"313":{"tf":1},"545":{"tf":1},"699":{"tf":1},"759":{"tf":1}},"df":5}}}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{"64":{"tf":1},"68":{"tf":1},"195":{"tf":1},"198":{"tf":1},"213":{"tf":2.23606797749979},"295":{"tf":1},"299":{"tf":1},"430":{"tf":1},"433":{"tf":1},"445":{"tf":2.23606797749979},"527":{"tf":1},"531":{"tf":1},"649":{"tf":1},"652":{"tf":1},"659":{"tf":2.23606797749979},"742":{"tf":1},"859":{"tf":1},"862":{"tf":1},"908":{"tf":1},"910":{"tf":1},"922":{"tf":1},"937":{"tf":1}},"df":22,"s":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1},"485":{"tf":1}},"df":2}}}},"s":{"docs":{"213":{"tf":1},"445":{"tf":1},"659":{"tf":1}},"df":3,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"213":{"tf":1},"445":{"tf":1},"659":{"tf":1}},"df":3}}}}}}}}}}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1},"55":{"tf":1},"64":{"tf":1},"77":{"tf":1},"103":{"tf":1},"109":{"tf":1},"116":{"tf":1.7320508075688772},"125":{"tf":1},"161":{"tf":1},"168":{"tf":1},"169":{"tf":1.4142135623730951},"176":{"tf":1},"182":{"tf":1},"189":{"tf":1},"192":{"tf":2.23606797749979},"195":{"tf":1},"199":{"tf":1},"287":{"tf":1},"295":{"tf":1},"308":{"tf":1},"334":{"tf":1},"340":{"tf":1},"347":{"tf":1.7320508075688772},"360":{"tf":1},"396":{"tf":1},"403":{"tf":1},"404":{"tf":1.4142135623730951},"411":{"tf":1},"417":{"tf":1},"424":{"tf":1},"427":{"tf":2.23606797749979},"430":{"tf":1},"434":{"tf":1},"458":{"tf":1},"485":{"tf":1},"519":{"tf":1},"527":{"tf":1},"540":{"tf":1},"566":{"tf":1},"572":{"tf":1},"579":{"tf":1.7320508075688772},"615":{"tf":1},"622":{"tf":1},"623":{"tf":1.4142135623730951},"630":{"tf":1},"636":{"tf":1},"643":{"tf":1},"646":{"tf":2.23606797749979},"649":{"tf":1},"653":{"tf":1},"672":{"tf":1},"692":{"tf":1.4142135623730951},"699":{"tf":1},"733":{"tf":1},"740":{"tf":1},"773":{"tf":1},"779":{"tf":1},"825":{"tf":1},"832":{"tf":1},"833":{"tf":1.4142135623730951},"840":{"tf":1},"846":{"tf":1},"853":{"tf":1},"856":{"tf":2.23606797749979},"859":{"tf":1},"863":{"tf":1},"888":{"tf":1},"899":{"tf":1},"901":{"tf":1},"904":{"tf":1},"907":{"tf":1},"946":{"tf":1},"951":{"tf":1},"953":{"tf":1},"958":{"tf":1},"960":{"tf":1}},"df":76,"e":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"56":{"tf":1},"73":{"tf":1},"105":{"tf":1},"116":{"tf":1},"119":{"tf":1},"122":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"128":{"tf":1},"169":{"tf":1},"171":{"tf":1},"177":{"tf":1.4142135623730951},"192":{"tf":1},"199":{"tf":1},"202":{"tf":1},"208":{"tf":1.4142135623730951},"225":{"tf":1},"288":{"tf":1},"296":{"tf":1},"304":{"tf":1},"336":{"tf":1},"347":{"tf":1},"354":{"tf":1},"357":{"tf":1.4142135623730951},"360":{"tf":1.7320508075688772},"363":{"tf":1},"399":{"tf":1},"404":{"tf":1},"406":{"tf":1},"412":{"tf":1.4142135623730951},"427":{"tf":1},"434":{"tf":1},"437":{"tf":1},"441":{"tf":1.4142135623730951},"457":{"tf":1},"458":{"tf":1.4142135623730951},"520":{"tf":1},"536":{"tf":1},"568":{"tf":1},"579":{"tf":1},"582":{"tf":1},"618":{"tf":1},"623":{"tf":1},"625":{"tf":1},"631":{"tf":1.4142135623730951},"646":{"tf":1},"653":{"tf":1},"671":{"tf":1},"672":{"tf":1.4142135623730951},"697":{"tf":1},"699":{"tf":1.4142135623730951},"734":{"tf":1},"741":{"tf":1},"748":{"tf":1},"749":{"tf":1},"775":{"tf":1},"789":{"tf":1},"792":{"tf":1},"828":{"tf":1},"833":{"tf":1},"835":{"tf":1},"841":{"tf":1.4142135623730951},"856":{"tf":1},"863":{"tf":1},"879":{"tf":1},"896":{"tf":1},"897":{"tf":1},"920":{"tf":1},"931":{"tf":1},"951":{"tf":1}},"df":70}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"z":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"192":{"tf":1.4142135623730951},"427":{"tf":1.4142135623730951},"646":{"tf":1.4142135623730951},"856":{"tf":1.4142135623730951}},"df":4}}}}}}}}}}},"i":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1},"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1},"914":{"tf":1}},"df":6},"l":{"docs":{"86":{"tf":1},"317":{"tf":1},"549":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1},"789":{"tf":1},"895":{"tf":1},"909":{"tf":1},"917":{"tf":1}},"df":6}}},"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"891":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"n":{"docs":{"8":{"tf":1},"119":{"tf":1},"240":{"tf":1},"354":{"tf":1},"472":{"tf":1}},"df":5}}}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"94":{"tf":1},"325":{"tf":1},"557":{"tf":1},"764":{"tf":1},"892":{"tf":1},"901":{"tf":1}},"df":6}}},"u":{"docs":{},"df":0,"t":{"docs":{"109":{"tf":1},"340":{"tf":1},"572":{"tf":1},"779":{"tf":1}},"df":4}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1},"177":{"tf":1},"412":{"tf":1},"485":{"tf":1},"527":{"tf":1},"631":{"tf":1},"697":{"tf":1.4142135623730951},"698":{"tf":1.7320508075688772},"699":{"tf":2.6457513110645907},"741":{"tf":1},"841":{"tf":1.4142135623730951},"877":{"tf":1}},"df":12,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"20":{"tf":1},"484":{"tf":1},"698":{"tf":1}},"df":3}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{"699":{"tf":1}},"df":1}}}}}}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{"112":{"tf":1},"139":{"tf":1},"343":{"tf":1},"374":{"tf":1},"575":{"tf":1},"593":{"tf":1},"803":{"tf":1}},"df":7}}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"237":{"tf":1},"469":{"tf":1},"683":{"tf":1}},"df":3}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"718":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"351":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{"354":{"tf":1}},"df":1,"t":{"docs":{"356":{"tf":1}},"df":1}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"40":{"tf":1},"67":{"tf":1},"253":{"tf":1},"272":{"tf":1},"485":{"tf":1},"504":{"tf":1},"530":{"tf":1},"718":{"tf":1}},"df":9}}},"u":{"docs":{},"df":0,"t":{"docs":{"915":{"tf":1}},"df":1}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"77":{"tf":1},"140":{"tf":1},"308":{"tf":1},"375":{"tf":1},"540":{"tf":1},"594":{"tf":1},"804":{"tf":1},"917":{"tf":1},"926":{"tf":1}},"df":9}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"122":{"tf":1},"178":{"tf":1},"182":{"tf":1.4142135623730951},"357":{"tf":1},"413":{"tf":1},"417":{"tf":1.4142135623730951},"632":{"tf":1},"636":{"tf":1.4142135623730951},"842":{"tf":1},"846":{"tf":1.4142135623730951}},"df":10,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"119":{"tf":1},"182":{"tf":1},"354":{"tf":1},"417":{"tf":1},"636":{"tf":1},"846":{"tf":1}},"df":6}}}}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}}}}}}}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"125":{"tf":1},"360":{"tf":1},"789":{"tf":1}},"df":3}}}},"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}},"k":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"z":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"140":{"tf":1},"375":{"tf":1},"594":{"tf":1},"804":{"tf":1}},"df":4}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{"161":{"tf":1},"396":{"tf":1},"615":{"tf":1},"825":{"tf":1}},"df":4,"t":{"docs":{"253":{"tf":1},"699":{"tf":1}},"df":2}}},"s":{"docs":{},"df":0,"s":{"docs":{"183":{"tf":1},"229":{"tf":1.4142135623730951},"351":{"tf":1},"418":{"tf":1},"461":{"tf":1.4142135623730951},"637":{"tf":1},"675":{"tf":1.4142135623730951},"847":{"tf":1},"883":{"tf":1.4142135623730951}},"df":9,"t":{"docs":{"232":{"tf":1},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":4}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"151":{"tf":1},"155":{"tf":1},"161":{"tf":1},"386":{"tf":1},"390":{"tf":1},"396":{"tf":1},"605":{"tf":1},"609":{"tf":1},"615":{"tf":1},"815":{"tf":1},"819":{"tf":1},"825":{"tf":1}},"df":12}}}}}}},"g":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"171":{"tf":1},"406":{"tf":1},"625":{"tf":1},"835":{"tf":1}},"df":4}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"176":{"tf":1},"411":{"tf":1},"630":{"tf":1},"840":{"tf":1}},"df":4}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"941":{"tf":1},"958":{"tf":1},"961":{"tf":1}},"df":3}}}},"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"232":{"tf":1},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":4,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"178":{"tf":1},"413":{"tf":1},"632":{"tf":1},"842":{"tf":1}},"df":4}}}}}}}}}}}},"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"909":{"tf":1}},"df":1}}}}}}}}},"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"116":{"tf":1},"231":{"tf":1},"347":{"tf":1},"463":{"tf":1},"579":{"tf":1},"677":{"tf":1},"786":{"tf":1},"941":{"tf":1}},"df":8,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"@":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"&":{"0":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1},"786":{"tf":1}},"df":4},"4":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3},"docs":{},"df":0,"$":{"docs":{},"df":0,"(":{"docs":{},"df":0,"i":{"docs":{"232":{"tf":1},"464":{"tf":1},"678":{"tf":1}},"df":3}}}},"@":{"docs":{},"df":0,"i":{"5":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3},"docs":{},"df":0}},"%":{"docs":{},"df":0,"i":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3}}}}}}}}},"&":{"0":{"docs":{},"df":0,"&":{"4":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3},"docs":{},"df":0},"@":{"docs":{},"df":0,"i":{"5":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3},"docs":{},"df":0}}},"1":{"docs":{},"df":0,"&":{"2":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3},"docs":{},"df":0}},"docs":{},"df":0},".":{"docs":{},"df":0,"t":{"docs":{},"df":0,"d":{"docs":{"350":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"941":{"tf":1.4142135623730951}},"df":1}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"94":{"tf":1},"125":{"tf":1},"195":{"tf":1},"231":{"tf":1},"325":{"tf":1},"354":{"tf":1},"360":{"tf":1},"430":{"tf":1},"463":{"tf":1},"557":{"tf":1},"649":{"tf":1},"677":{"tf":1},"764":{"tf":1},"859":{"tf":1},"883":{"tf":1},"909":{"tf":1},"917":{"tf":1},"920":{"tf":1}},"df":19,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"168":{"tf":1},"403":{"tf":1},"622":{"tf":1},"832":{"tf":1},"935":{"tf":1},"962":{"tf":1}},"df":6}}}}}}},"r":{"docs":{"25":{"tf":1},"26":{"tf":1},"253":{"tf":1.4142135623730951},"257":{"tf":1},"258":{"tf":1},"489":{"tf":1},"490":{"tf":1},"703":{"tf":1},"704":{"tf":1},"953":{"tf":1},"956":{"tf":1.7320508075688772},"963":{"tf":1}},"df":12,"t":{"docs":{"526":{"tf":1}},"df":1}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"o":{"docs":{"3":{"tf":1.4142135623730951},"11":{"tf":1},"43":{"tf":1},"59":{"tf":1},"94":{"tf":1},"112":{"tf":1},"119":{"tf":2.449489742783178},"128":{"tf":1},"164":{"tf":1},"195":{"tf":1},"220":{"tf":1},"237":{"tf":1},"243":{"tf":1},"275":{"tf":1},"291":{"tf":1},"325":{"tf":1},"343":{"tf":1},"354":{"tf":2.6457513110645907},"363":{"tf":1},"399":{"tf":1.4142135623730951},"430":{"tf":1},"452":{"tf":1},"469":{"tf":1},"475":{"tf":1},"507":{"tf":1},"523":{"tf":1},"557":{"tf":1},"575":{"tf":1},"582":{"tf":1},"618":{"tf":1.4142135623730951},"649":{"tf":1},"666":{"tf":1},"683":{"tf":1},"721":{"tf":1},"792":{"tf":1},"828":{"tf":1.4142135623730951},"859":{"tf":1},"874":{"tf":1},"907":{"tf":1}},"df":39}}},"a":{"docs":{"350":{"tf":1},"911":{"tf":1}},"df":2}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"64":{"tf":1.7320508075688772},"66":{"tf":1.7320508075688772},"119":{"tf":1},"155":{"tf":1},"164":{"tf":2},"167":{"tf":1},"169":{"tf":1.7320508075688772},"170":{"tf":1},"171":{"tf":2},"176":{"tf":1},"177":{"tf":2.6457513110645907},"178":{"tf":1},"182":{"tf":2.23606797749979},"183":{"tf":1},"187":{"tf":3.4641016151377544},"188":{"tf":2.23606797749979},"189":{"tf":3.4641016151377544},"192":{"tf":5.291502622129181},"199":{"tf":1},"203":{"tf":1},"214":{"tf":1},"215":{"tf":1},"217":{"tf":1.4142135623730951},"224":{"tf":1},"225":{"tf":1.7320508075688772},"226":{"tf":2},"231":{"tf":1.7320508075688772},"232":{"tf":2},"252":{"tf":1.4142135623730951},"295":{"tf":1.7320508075688772},"354":{"tf":1},"390":{"tf":1},"399":{"tf":2},"402":{"tf":1},"404":{"tf":1.7320508075688772},"405":{"tf":1},"406":{"tf":2},"411":{"tf":1},"412":{"tf":2.6457513110645907},"413":{"tf":1},"417":{"tf":2.23606797749979},"418":{"tf":1},"422":{"tf":3.4641016151377544},"423":{"tf":2.23606797749979},"424":{"tf":3.4641016151377544},"427":{"tf":5.291502622129181},"434":{"tf":1},"438":{"tf":1},"446":{"tf":1},"447":{"tf":1},"449":{"tf":1.4142135623730951},"456":{"tf":1},"457":{"tf":1.7320508075688772},"458":{"tf":2.23606797749979},"463":{"tf":1.7320508075688772},"464":{"tf":2},"484":{"tf":1.4142135623730951},"485":{"tf":1.4142135623730951},"527":{"tf":1.7320508075688772},"529":{"tf":1.7320508075688772},"609":{"tf":1},"618":{"tf":2},"621":{"tf":1},"623":{"tf":1.7320508075688772},"624":{"tf":1},"625":{"tf":2},"630":{"tf":1},"631":{"tf":2.6457513110645907},"632":{"tf":1},"636":{"tf":2.23606797749979},"637":{"tf":1},"641":{"tf":3.4641016151377544},"642":{"tf":2.23606797749979},"643":{"tf":3.4641016151377544},"646":{"tf":5.291502622129181},"653":{"tf":1},"660":{"tf":1},"661":{"tf":1},"663":{"tf":1.4142135623730951},"670":{"tf":1},"671":{"tf":1.7320508075688772},"672":{"tf":2.23606797749979},"677":{"tf":1.7320508075688772},"678":{"tf":2},"698":{"tf":1.4142135623730951},"699":{"tf":1},"819":{"tf":1},"828":{"tf":2},"831":{"tf":1},"833":{"tf":1.7320508075688772},"834":{"tf":1},"835":{"tf":2},"840":{"tf":1},"841":{"tf":2.6457513110645907},"842":{"tf":1},"846":{"tf":2.23606797749979},"847":{"tf":1},"851":{"tf":3.4641016151377544},"852":{"tf":2.23606797749979},"853":{"tf":3.4641016151377544},"856":{"tf":5.291502622129181},"863":{"tf":1},"869":{"tf":1},"871":{"tf":1.4142135623730951},"878":{"tf":1},"879":{"tf":1.7320508075688772},"880":{"tf":1.4142135623730951},"883":{"tf":2.6457513110645907},"899":{"tf":1.4142135623730951},"901":{"tf":1},"903":{"tf":2},"931":{"tf":2},"963":{"tf":1}},"df":115,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1},"699":{"tf":1},"880":{"tf":1},"903":{"tf":1}},"df":6,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"128":{"tf":1.7320508075688772},"155":{"tf":1},"175":{"tf":1},"176":{"tf":1.4142135623730951},"177":{"tf":2},"181":{"tf":2.23606797749979},"182":{"tf":2.449489742783178},"183":{"tf":1.4142135623730951},"187":{"tf":1},"189":{"tf":1},"192":{"tf":1},"231":{"tf":1},"232":{"tf":1},"363":{"tf":1.7320508075688772},"390":{"tf":1},"410":{"tf":1},"411":{"tf":1.4142135623730951},"412":{"tf":2},"416":{"tf":2.23606797749979},"417":{"tf":2.449489742783178},"418":{"tf":1.4142135623730951},"422":{"tf":1},"424":{"tf":1},"427":{"tf":1},"463":{"tf":1},"464":{"tf":1},"582":{"tf":1.7320508075688772},"609":{"tf":1},"629":{"tf":1},"630":{"tf":1.4142135623730951},"631":{"tf":2},"635":{"tf":2.23606797749979},"636":{"tf":2.449489742783178},"637":{"tf":1.4142135623730951},"641":{"tf":1},"643":{"tf":1},"646":{"tf":1},"677":{"tf":1},"678":{"tf":1},"792":{"tf":1.7320508075688772},"819":{"tf":1},"839":{"tf":1},"840":{"tf":1.4142135623730951},"841":{"tf":2},"845":{"tf":2.23606797749979},"846":{"tf":2.449489742783178},"847":{"tf":1.4142135623730951},"851":{"tf":1},"853":{"tf":1},"856":{"tf":1},"883":{"tf":1.4142135623730951}},"df":51}}}}}}}}}},"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"x":{"docs":{"171":{"tf":1},"225":{"tf":1},"406":{"tf":1},"457":{"tf":1},"625":{"tf":1},"671":{"tf":1},"835":{"tf":1},"879":{"tf":1}},"df":8}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"182":{"tf":1},"417":{"tf":1},"636":{"tf":1},"846":{"tf":1}},"df":4}}},"c":{"docs":{},"df":0,"k":{"docs":{"215":{"tf":1},"447":{"tf":1},"661":{"tf":1},"903":{"tf":1}},"df":4}}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"171":{"tf":1.7320508075688772},"188":{"tf":1},"189":{"tf":1},"232":{"tf":1},"406":{"tf":1.7320508075688772},"423":{"tf":1},"424":{"tf":1},"464":{"tf":1},"625":{"tf":1.7320508075688772},"642":{"tf":1},"643":{"tf":1},"678":{"tf":1},"835":{"tf":1.7320508075688772},"852":{"tf":1},"853":{"tf":1},"883":{"tf":1},"897":{"tf":1}},"df":17}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"177":{"tf":1},"182":{"tf":1.4142135623730951},"183":{"tf":1.4142135623730951},"412":{"tf":1},"417":{"tf":1.4142135623730951},"418":{"tf":1.4142135623730951},"631":{"tf":1},"636":{"tf":1.4142135623730951},"637":{"tf":1.4142135623730951},"841":{"tf":1},"846":{"tf":1.4142135623730951},"847":{"tf":1.4142135623730951}},"df":12}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"192":{"tf":1},"427":{"tf":1},"646":{"tf":1},"856":{"tf":1}},"df":4}}}}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"399":{"tf":1},"618":{"tf":1},"828":{"tf":1}},"df":3}}}}}}}}}}},"n":{"docs":{},"df":0,"t":{"docs":{"47":{"tf":1},"86":{"tf":1},"134":{"tf":1},"279":{"tf":1},"317":{"tf":1},"369":{"tf":1},"511":{"tf":1},"549":{"tf":1},"588":{"tf":1},"725":{"tf":1},"798":{"tf":1},"888":{"tf":1}},"df":12}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"207":{"tf":1}},"df":1}}}}}},"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"351":{"tf":1}},"df":1}}}}},"g":{"docs":{},"df":0,"l":{"docs":{"177":{"tf":1},"192":{"tf":1},"225":{"tf":1},"412":{"tf":1},"427":{"tf":1},"457":{"tf":1},"631":{"tf":1},"646":{"tf":1},"671":{"tf":1},"841":{"tf":1},"856":{"tf":1},"879":{"tf":1}},"df":12}}},"q":{"docs":{},"df":0,"f":{"docs":{"4":{"tf":1},"199":{"tf":1.4142135623730951},"434":{"tf":1.4142135623730951},"653":{"tf":1.4142135623730951},"863":{"tf":1.4142135623730951}},"df":5,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":3.3166247903554},"4":{"tf":3},"5":{"tf":1},"8":{"tf":2.449489742783178},"14":{"tf":2.449489742783178},"15":{"tf":1},"21":{"tf":2},"27":{"tf":1.7320508075688772},"37":{"tf":1},"40":{"tf":1},"43":{"tf":1.4142135623730951},"50":{"tf":1},"54":{"tf":1},"55":{"tf":1},"56":{"tf":1},"62":{"tf":1},"64":{"tf":1.7320508075688772},"67":{"tf":1},"72":{"tf":1},"82":{"tf":1.4142135623730951},"91":{"tf":1},"94":{"tf":1},"97":{"tf":1},"109":{"tf":1.4142135623730951},"115":{"tf":1},"116":{"tf":2.6457513110645907},"119":{"tf":2.23606797749979},"121":{"tf":1},"122":{"tf":3.872983346207417},"125":{"tf":2},"128":{"tf":2},"131":{"tf":1},"134":{"tf":1},"143":{"tf":1},"144":{"tf":1.4142135623730951},"145":{"tf":1},"150":{"tf":1},"151":{"tf":1},"156":{"tf":1},"157":{"tf":1.4142135623730951},"161":{"tf":1},"168":{"tf":1},"171":{"tf":2.23606797749979},"176":{"tf":1},"177":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"181":{"tf":1},"182":{"tf":1.4142135623730951},"187":{"tf":1},"189":{"tf":1},"192":{"tf":1.4142135623730951},"195":{"tf":2.23606797749979},"198":{"tf":1},"203":{"tf":1},"207":{"tf":1},"209":{"tf":1},"215":{"tf":1.4142135623730951},"220":{"tf":1},"226":{"tf":1.7320508075688772},"229":{"tf":2},"230":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"240":{"tf":2.449489742783178},"246":{"tf":2.449489742783178},"247":{"tf":1},"253":{"tf":1.4142135623730951},"259":{"tf":1.7320508075688772},"269":{"tf":1},"272":{"tf":1},"275":{"tf":1.4142135623730951},"282":{"tf":1},"286":{"tf":1},"287":{"tf":1},"288":{"tf":1},"294":{"tf":1},"295":{"tf":1.7320508075688772},"303":{"tf":1},"305":{"tf":1},"313":{"tf":1.4142135623730951},"325":{"tf":1},"328":{"tf":1},"340":{"tf":1.4142135623730951},"346":{"tf":1},"347":{"tf":2.6457513110645907},"350":{"tf":2.23606797749979},"351":{"tf":1.7320508075688772},"354":{"tf":2.6457513110645907},"356":{"tf":1},"357":{"tf":3.872983346207417},"360":{"tf":2},"363":{"tf":2},"366":{"tf":1},"369":{"tf":1},"378":{"tf":1},"379":{"tf":1.4142135623730951},"380":{"tf":1},"385":{"tf":1},"386":{"tf":1},"391":{"tf":1},"392":{"tf":1.4142135623730951},"396":{"tf":1},"403":{"tf":1},"406":{"tf":2.23606797749979},"411":{"tf":1},"412":{"tf":1.4142135623730951},"413":{"tf":1.4142135623730951},"416":{"tf":1},"417":{"tf":1.4142135623730951},"422":{"tf":1},"424":{"tf":1},"427":{"tf":1.4142135623730951},"430":{"tf":2.23606797749979},"433":{"tf":1},"438":{"tf":1},"447":{"tf":1.4142135623730951},"452":{"tf":1},"458":{"tf":1.7320508075688772},"461":{"tf":2},"462":{"tf":1},"463":{"tf":1.4142135623730951},"464":{"tf":1.7320508075688772},"472":{"tf":2.449489742783178},"478":{"tf":2.449489742783178},"479":{"tf":1},"485":{"tf":1.7320508075688772},"491":{"tf":1.7320508075688772},"501":{"tf":1},"504":{"tf":1},"507":{"tf":1.4142135623730951},"514":{"tf":1},"518":{"tf":1},"519":{"tf":1},"520":{"tf":1},"526":{"tf":1},"527":{"tf":2},"530":{"tf":1},"535":{"tf":1.4142135623730951},"545":{"tf":1.4142135623730951},"554":{"tf":1},"557":{"tf":1},"560":{"tf":1},"572":{"tf":1.4142135623730951},"578":{"tf":1},"579":{"tf":2.6457513110645907},"582":{"tf":2},"585":{"tf":1},"588":{"tf":1},"597":{"tf":1},"598":{"tf":1.4142135623730951},"599":{"tf":1},"604":{"tf":1},"605":{"tf":1},"610":{"tf":1},"611":{"tf":1.4142135623730951},"615":{"tf":1},"622":{"tf":1},"625":{"tf":2.23606797749979},"630":{"tf":1},"631":{"tf":1.4142135623730951},"632":{"tf":1.4142135623730951},"635":{"tf":1},"636":{"tf":1.4142135623730951},"641":{"tf":1},"643":{"tf":1},"646":{"tf":1.4142135623730951},"649":{"tf":2.23606797749979},"652":{"tf":1},"661":{"tf":1.4142135623730951},"666":{"tf":1},"672":{"tf":1.7320508075688772},"675":{"tf":2},"676":{"tf":1},"677":{"tf":1.4142135623730951},"678":{"tf":1.7320508075688772},"686":{"tf":2},"692":{"tf":2.449489742783178},"693":{"tf":1},"699":{"tf":2.23606797749979},"705":{"tf":1.7320508075688772},"715":{"tf":1},"718":{"tf":1.4142135623730951},"721":{"tf":1.4142135623730951},"725":{"tf":1},"728":{"tf":1},"732":{"tf":1},"733":{"tf":1},"734":{"tf":1},"740":{"tf":1},"741":{"tf":1},"742":{"tf":1},"750":{"tf":1},"759":{"tf":1.4142135623730951},"764":{"tf":1},"767":{"tf":1},"779":{"tf":1.4142135623730951},"782":{"tf":1.4142135623730951},"785":{"tf":1},"786":{"tf":1.7320508075688772},"789":{"tf":1.4142135623730951},"792":{"tf":2},"795":{"tf":1},"798":{"tf":1},"807":{"tf":1},"808":{"tf":1.4142135623730951},"809":{"tf":1},"814":{"tf":1},"815":{"tf":1},"820":{"tf":1},"821":{"tf":1.4142135623730951},"825":{"tf":1},"832":{"tf":1},"835":{"tf":2.23606797749979},"840":{"tf":1},"841":{"tf":1.4142135623730951},"842":{"tf":1.4142135623730951},"845":{"tf":1},"846":{"tf":1.4142135623730951},"851":{"tf":1},"853":{"tf":1},"856":{"tf":1.4142135623730951},"859":{"tf":2.23606797749979},"862":{"tf":1},"874":{"tf":1},"880":{"tf":1},"883":{"tf":3.1622776601683795},"888":{"tf":1.4142135623730951},"891":{"tf":1},"893":{"tf":1},"895":{"tf":1},"896":{"tf":1.7320508075688772},"903":{"tf":1},"904":{"tf":1},"907":{"tf":1},"909":{"tf":1.4142135623730951},"917":{"tf":1},"919":{"tf":1},"928":{"tf":1},"934":{"tf":1},"935":{"tf":1},"938":{"tf":1.4142135623730951},"945":{"tf":1},"948":{"tf":1.4142135623730951},"950":{"tf":2.23606797749979},"951":{"tf":1.4142135623730951},"953":{"tf":1},"956":{"tf":1},"957":{"tf":1},"959":{"tf":1},"963":{"tf":1}},"df":250}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"64":{"tf":1},"97":{"tf":1},"189":{"tf":1},"198":{"tf":1},"215":{"tf":1},"226":{"tf":1},"246":{"tf":1},"295":{"tf":1},"328":{"tf":1},"424":{"tf":1},"433":{"tf":1},"447":{"tf":1},"458":{"tf":1},"478":{"tf":1},"527":{"tf":1},"560":{"tf":1},"643":{"tf":1},"652":{"tf":1},"661":{"tf":1},"672":{"tf":1},"692":{"tf":1},"741":{"tf":1},"767":{"tf":1},"853":{"tf":1},"862":{"tf":1},"888":{"tf":1},"891":{"tf":1.4142135623730951},"903":{"tf":1.4142135623730951},"904":{"tf":1},"907":{"tf":1.4142135623730951},"908":{"tf":1},"910":{"tf":1},"922":{"tf":1},"934":{"tf":1.4142135623730951},"935":{"tf":1},"937":{"tf":1},"938":{"tf":1},"945":{"tf":1}},"df":39,":":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"v":{"docs":{"21":{"tf":1},"64":{"tf":1},"295":{"tf":1},"485":{"tf":1},"527":{"tf":1}},"df":5},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"}":{"docs":{},"df":0,"/":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"742":{"tf":1}},"df":1,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"k":{"docs":{"742":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1}},"df":3}}}}}}}}}}},"s":{"docs":{},"df":0,":":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"122":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"122":{"tf":1}},"df":1}}}}}}}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1.7320508075688772},"357":{"tf":2}},"df":2}}}}}},".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"195":{"tf":2.23606797749979},"198":{"tf":1},"231":{"tf":1},"430":{"tf":2.23606797749979},"433":{"tf":1},"463":{"tf":1},"649":{"tf":2.23606797749979},"652":{"tf":1},"677":{"tf":1},"859":{"tf":2.23606797749979},"862":{"tf":1},"883":{"tf":1}},"df":12}}},"f":{"docs":{},"df":0,"x":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":1}},"df":1}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"204":{"tf":1}},"df":1}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2}}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"205":{"tf":1}},"df":1}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"206":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"207":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{"209":{"tf":1}},"df":1}}}}}}},"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":1}},"df":1}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"204":{"tf":1}},"df":1}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"929":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}},"g":{"docs":{"205":{"tf":1}},"df":1},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"206":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"207":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1},"231":{"tf":1.4142135623730951}},"df":2}}},"r":{"docs":{"209":{"tf":1}},"df":1}}}}}},"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":1}},"df":1}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{"204":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"929":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"205":{"tf":1}},"df":1}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"206":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"207":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{"209":{"tf":1}},"df":1}}}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"213":{"tf":1},"445":{"tf":1},"659":{"tf":1}},"df":3}}}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":1},"438":{"tf":1}},"df":2}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1},"439":{"tf":1}},"df":2}}}}}},"g":{"docs":{"205":{"tf":1},"440":{"tf":1}},"df":2},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"206":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1},"441":{"tf":1},"463":{"tf":1.4142135623730951}},"df":3}}},"r":{"docs":{"209":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,".":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"677":{"tf":1.4142135623730951}},"df":1}}}}}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{"211":{"tf":1},"212":{"tf":1},"232":{"tf":1},"443":{"tf":1},"444":{"tf":1},"464":{"tf":1},"657":{"tf":1},"658":{"tf":1},"678":{"tf":1},"867":{"tf":1},"868":{"tf":1},"883":{"tf":1}},"df":12}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{"215":{"tf":1},"447":{"tf":1},"661":{"tf":1}},"df":3}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"217":{"tf":1},"449":{"tf":1},"663":{"tf":1},"871":{"tf":1}},"df":4}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"216":{"tf":1},"448":{"tf":1},"662":{"tf":1},"870":{"tf":1}},"df":4}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,".":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"883":{"tf":1.4142135623730951}},"df":1}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"54":{"tf":1},"286":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":4}}}}}}}}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"151":{"tf":1},"386":{"tf":1},"535":{"tf":1.4142135623730951},"605":{"tf":1},"815":{"tf":1}},"df":5}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{"3":{"tf":1},"91":{"tf":1},"554":{"tf":1}},"df":3,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"37":{"tf":1},"38":{"tf":1},"68":{"tf":1},"90":{"tf":1},"122":{"tf":1},"269":{"tf":1},"270":{"tf":1},"299":{"tf":1},"321":{"tf":1},"357":{"tf":1},"501":{"tf":1},"502":{"tf":1},"531":{"tf":1},"553":{"tf":1},"715":{"tf":1},"716":{"tf":1}},"df":16}}}}}}}}}},"f":{"docs":{"20":{"tf":1},"25":{"tf":1},"112":{"tf":1},"128":{"tf":1},"198":{"tf":1},"202":{"tf":1},"215":{"tf":1},"240":{"tf":1},"252":{"tf":1},"257":{"tf":1},"343":{"tf":1},"363":{"tf":1},"433":{"tf":1},"437":{"tf":1},"447":{"tf":1},"484":{"tf":1},"489":{"tf":1},"575":{"tf":1},"582":{"tf":1},"652":{"tf":1},"656":{"tf":1},"661":{"tf":1},"703":{"tf":1},"792":{"tf":1},"862":{"tf":1},"866":{"tf":1},"908":{"tf":1},"915":{"tf":1},"919":{"tf":1},"928":{"tf":1},"939":{"tf":1}},"df":31},"t":{"docs":{"26":{"tf":1.4142135623730951},"32":{"tf":1.4142135623730951},"39":{"tf":1},"77":{"tf":1},"78":{"tf":1},"122":{"tf":2.6457513110645907},"125":{"tf":1},"155":{"tf":1.4142135623730951},"156":{"tf":1},"157":{"tf":1},"168":{"tf":1},"169":{"tf":2.23606797749979},"170":{"tf":1},"171":{"tf":1.4142135623730951},"177":{"tf":2.23606797749979},"178":{"tf":1.7320508075688772},"181":{"tf":1},"182":{"tf":2.449489742783178},"188":{"tf":1.4142135623730951},"189":{"tf":1},"192":{"tf":2.23606797749979},"199":{"tf":1},"204":{"tf":1.4142135623730951},"217":{"tf":2.23606797749979},"225":{"tf":1},"226":{"tf":1.7320508075688772},"231":{"tf":1},"232":{"tf":2},"233":{"tf":1},"258":{"tf":1.4142135623730951},"264":{"tf":1.4142135623730951},"271":{"tf":1},"308":{"tf":1},"309":{"tf":1},"357":{"tf":2.8284271247461903},"360":{"tf":1},"390":{"tf":1.4142135623730951},"391":{"tf":1},"392":{"tf":1},"403":{"tf":1},"404":{"tf":2.23606797749979},"405":{"tf":1},"406":{"tf":1.4142135623730951},"412":{"tf":2.23606797749979},"413":{"tf":1.7320508075688772},"416":{"tf":1},"417":{"tf":2.449489742783178},"423":{"tf":1.4142135623730951},"424":{"tf":1},"427":{"tf":2.23606797749979},"434":{"tf":1},"439":{"tf":1.4142135623730951},"449":{"tf":2.23606797749979},"457":{"tf":1},"458":{"tf":1.7320508075688772},"463":{"tf":1},"464":{"tf":2},"465":{"tf":1},"490":{"tf":1.4142135623730951},"496":{"tf":1.4142135623730951},"503":{"tf":1},"540":{"tf":1},"541":{"tf":1},"609":{"tf":1.4142135623730951},"610":{"tf":1},"611":{"tf":1},"622":{"tf":1},"623":{"tf":2.23606797749979},"624":{"tf":1},"625":{"tf":1.4142135623730951},"631":{"tf":2.23606797749979},"632":{"tf":1.7320508075688772},"635":{"tf":1},"636":{"tf":2.449489742783178},"642":{"tf":1.4142135623730951},"643":{"tf":1},"646":{"tf":2.23606797749979},"653":{"tf":1},"663":{"tf":2.23606797749979},"671":{"tf":1},"672":{"tf":1.7320508075688772},"677":{"tf":1},"678":{"tf":2},"679":{"tf":1},"704":{"tf":1.4142135623730951},"717":{"tf":1},"789":{"tf":1},"819":{"tf":1.4142135623730951},"820":{"tf":1},"821":{"tf":1},"832":{"tf":1},"833":{"tf":2.23606797749979},"834":{"tf":1},"835":{"tf":1.4142135623730951},"841":{"tf":2.23606797749979},"842":{"tf":1.7320508075688772},"845":{"tf":1},"846":{"tf":2.449489742783178},"852":{"tf":1.4142135623730951},"853":{"tf":1},"856":{"tf":2.23606797749979},"863":{"tf":1},"871":{"tf":2.23606797749979},"879":{"tf":1},"880":{"tf":1.7320508075688772},"883":{"tf":2.23606797749979},"884":{"tf":1},"900":{"tf":1.7320508075688772},"938":{"tf":1},"941":{"tf":1},"957":{"tf":1},"960":{"tf":1.4142135623730951},"961":{"tf":1},"962":{"tf":1.4142135623730951},"963":{"tf":1.4142135623730951}},"df":115,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"77":{"tf":1},"308":{"tf":1},"540":{"tf":1}},"df":3}}}},"e":{"docs":{},"df":0,"t":{"docs":{"225":{"tf":1},"226":{"tf":1},"457":{"tf":1},"458":{"tf":1},"671":{"tf":1},"672":{"tf":1},"879":{"tf":1},"880":{"tf":1}},"df":8}}}},"b":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2},"8":{"tf":1.7320508075688772},"125":{"tf":1},"202":{"tf":1},"240":{"tf":2.449489742783178},"243":{"tf":1},"253":{"tf":1.7320508075688772},"259":{"tf":1},"266":{"tf":1},"291":{"tf":1.4142135623730951},"294":{"tf":1},"299":{"tf":1},"303":{"tf":1.4142135623730951},"305":{"tf":1},"325":{"tf":1},"343":{"tf":1},"350":{"tf":1.4142135623730951},"351":{"tf":2.449489742783178},"354":{"tf":1.7320508075688772},"356":{"tf":1.7320508075688772},"357":{"tf":1},"360":{"tf":1},"363":{"tf":1},"399":{"tf":1},"430":{"tf":1},"437":{"tf":1},"452":{"tf":1},"458":{"tf":1},"469":{"tf":1},"472":{"tf":1.7320508075688772}},"df":31,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"253":{"tf":1},"275":{"tf":1},"295":{"tf":1.4142135623730951},"507":{"tf":1},"721":{"tf":1}},"df":6}}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{"254":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"399":{"tf":1}},"df":1}}}}}}}}}}}},"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1.4142135623730951},"32":{"tf":1},"64":{"tf":1.4142135623730951},"104":{"tf":1},"122":{"tf":2.6457513110645907},"125":{"tf":1.7320508075688772},"128":{"tf":1},"134":{"tf":1},"145":{"tf":1},"155":{"tf":1},"177":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"182":{"tf":1},"184":{"tf":1},"187":{"tf":1},"189":{"tf":1},"209":{"tf":1},"215":{"tf":1},"226":{"tf":1},"264":{"tf":1},"295":{"tf":1},"296":{"tf":1},"305":{"tf":1},"335":{"tf":1},"357":{"tf":3},"360":{"tf":1.7320508075688772},"363":{"tf":1},"369":{"tf":1},"380":{"tf":1},"390":{"tf":1},"412":{"tf":1.4142135623730951},"413":{"tf":1.4142135623730951},"417":{"tf":1},"419":{"tf":1},"422":{"tf":1},"424":{"tf":1},"447":{"tf":1},"458":{"tf":1},"496":{"tf":1},"527":{"tf":1.4142135623730951},"567":{"tf":1},"582":{"tf":1},"588":{"tf":1},"599":{"tf":1},"609":{"tf":1},"631":{"tf":1.4142135623730951},"632":{"tf":1.4142135623730951},"636":{"tf":1},"638":{"tf":1},"641":{"tf":1},"643":{"tf":1},"661":{"tf":1},"672":{"tf":1},"774":{"tf":1},"792":{"tf":1},"798":{"tf":1},"809":{"tf":1},"819":{"tf":1},"841":{"tf":1.4142135623730951},"842":{"tf":1.4142135623730951},"846":{"tf":1},"848":{"tf":1},"851":{"tf":1},"853":{"tf":1},"880":{"tf":1},"891":{"tf":1},"894":{"tf":1},"895":{"tf":1},"901":{"tf":1},"904":{"tf":1},"907":{"tf":1},"909":{"tf":1},"913":{"tf":1.4142135623730951},"917":{"tf":1},"918":{"tf":1},"938":{"tf":1},"948":{"tf":1},"956":{"tf":1.4142135623730951},"962":{"tf":1},"965":{"tf":1.4142135623730951}},"df":80,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"161":{"tf":1},"240":{"tf":1.4142135623730951},"396":{"tf":1},"472":{"tf":1.4142135623730951},"615":{"tf":1},"686":{"tf":1.4142135623730951},"825":{"tf":1},"888":{"tf":1}},"df":10}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"n":{"docs":{"97":{"tf":1},"328":{"tf":1},"560":{"tf":1},"767":{"tf":1}},"df":4},"t":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":4}}}}}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"137":{"tf":1},"372":{"tf":1},"591":{"tf":1},"801":{"tf":1}},"df":4}}}}},"h":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2}}},"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"158":{"tf":1},"393":{"tf":1},"612":{"tf":1},"822":{"tf":1}},"df":4}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"298":{"tf":1}},"df":1}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{"928":{"tf":1}},"df":1}}}}}}},"s":{"docs":{"143":{"tf":1},"161":{"tf":1},"207":{"tf":1},"350":{"tf":1},"354":{"tf":1},"378":{"tf":1},"396":{"tf":1},"597":{"tf":1},"615":{"tf":1},"807":{"tf":1},"825":{"tf":1}},"df":11}},"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"4":{"tf":1},"137":{"tf":1},"350":{"tf":1},"356":{"tf":1},"372":{"tf":1},"591":{"tf":1},"801":{"tf":1},"914":{"tf":1}},"df":8}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"11":{"tf":1},"15":{"tf":1},"109":{"tf":1},"116":{"tf":1},"243":{"tf":1},"247":{"tf":1},"340":{"tf":1},"347":{"tf":1},"475":{"tf":1},"479":{"tf":1},"572":{"tf":1},"579":{"tf":1},"689":{"tf":1},"693":{"tf":1},"779":{"tf":1}},"df":15}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"140":{"tf":1},"375":{"tf":1},"594":{"tf":1},"804":{"tf":1},"867":{"tf":1}},"df":5,"n":{"docs":{"14":{"tf":1},"64":{"tf":1},"72":{"tf":1.7320508075688772},"77":{"tf":1},"151":{"tf":1},"246":{"tf":1},"295":{"tf":1},"303":{"tf":1.7320508075688772},"308":{"tf":1},"386":{"tf":1},"478":{"tf":1},"527":{"tf":1},"535":{"tf":1.7320508075688772},"540":{"tf":1},"605":{"tf":1},"692":{"tf":1},"750":{"tf":1.4142135623730951},"815":{"tf":1},"938":{"tf":1},"951":{"tf":1}},"df":20},"t":{"docs":{"26":{"tf":1},"150":{"tf":1},"258":{"tf":1},"385":{"tf":1},"490":{"tf":1},"604":{"tf":1},"704":{"tf":1},"814":{"tf":1}},"df":8}}}}}},"g":{"docs":{"51":{"tf":1},"86":{"tf":1},"125":{"tf":1},"187":{"tf":1},"283":{"tf":1},"317":{"tf":1},"360":{"tf":1},"422":{"tf":1},"515":{"tf":1},"549":{"tf":1},"641":{"tf":1},"729":{"tf":1},"851":{"tf":1}},"df":13,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"895":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"903":{"tf":1}},"df":1}}}}},"d":{"docs":{"122":{"tf":1},"357":{"tf":1},"458":{"tf":1},"672":{"tf":1},"880":{"tf":1}},"df":5}},"i":{"docs":{},"df":0,"n":{"docs":{"475":{"tf":1},"491":{"tf":1},"523":{"tf":1},"557":{"tf":1},"575":{"tf":1},"582":{"tf":1},"618":{"tf":1},"649":{"tf":1},"666":{"tf":1},"672":{"tf":1},"683":{"tf":1}},"df":11,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":2},"8":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"240":{"tf":1.7320508075688772},"252":{"tf":1},"296":{"tf":1},"458":{"tf":1},"472":{"tf":1.7320508075688772},"485":{"tf":1},"486":{"tf":1},"523":{"tf":1},"526":{"tf":1},"527":{"tf":1.4142135623730951},"529":{"tf":1},"618":{"tf":1},"672":{"tf":1},"941":{"tf":1.4142135623730951},"956":{"tf":1}},"df":20}}}},"r":{"docs":{},"df":0,"k":{"docs":{"350":{"tf":1}},"df":1,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"21":{"tf":1},"105":{"tf":1},"237":{"tf":1},"253":{"tf":1},"336":{"tf":1},"469":{"tf":1},"485":{"tf":1},"568":{"tf":1},"683":{"tf":1},"699":{"tf":1},"775":{"tf":1},"943":{"tf":1},"957":{"tf":1}},"df":13}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"138":{"tf":1},"356":{"tf":1},"373":{"tf":1},"592":{"tf":1},"802":{"tf":1}},"df":5}}}},"f":{"docs":{},"df":0,"t":{"docs":{"928":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{"21":{"tf":1.4142135623730951},"28":{"tf":1},"37":{"tf":1},"74":{"tf":1},"78":{"tf":1},"90":{"tf":1},"125":{"tf":1.7320508075688772},"150":{"tf":1},"192":{"tf":1},"253":{"tf":1.4142135623730951},"260":{"tf":1},"269":{"tf":1},"305":{"tf":1},"309":{"tf":1},"321":{"tf":1},"360":{"tf":1.7320508075688772},"385":{"tf":1},"427":{"tf":1},"485":{"tf":1.4142135623730951},"492":{"tf":1},"501":{"tf":1},"537":{"tf":1},"541":{"tf":1},"553":{"tf":1},"582":{"tf":1},"604":{"tf":1},"646":{"tf":1},"699":{"tf":1},"706":{"tf":1},"715":{"tf":1},"752":{"tf":1},"792":{"tf":1},"814":{"tf":1},"856":{"tf":1},"914":{"tf":1},"938":{"tf":1}},"df":36,"e":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"f":{"docs":{"27":{"tf":1},"33":{"tf":1},"259":{"tf":1},"265":{"tf":1},"491":{"tf":1},"497":{"tf":1},"705":{"tf":1},"711":{"tf":1}},"df":8}}}}}}}},"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"t":{"docs":{"747":{"tf":1}},"df":1}}}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"109":{"tf":1},"229":{"tf":1},"231":{"tf":1.4142135623730951},"340":{"tf":1},"461":{"tf":1},"463":{"tf":1.4142135623730951},"572":{"tf":1},"675":{"tf":1},"677":{"tf":1.4142135623730951},"779":{"tf":1},"883":{"tf":1.7320508075688772},"942":{"tf":1}},"df":12,"t":{"docs":{"74":{"tf":1},"305":{"tf":1},"537":{"tf":1},"752":{"tf":1}},"df":4}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{"917":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4}}}}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"94":{"tf":1},"97":{"tf":1},"102":{"tf":1},"109":{"tf":1},"325":{"tf":1},"328":{"tf":1},"333":{"tf":1},"340":{"tf":1},"557":{"tf":1},"560":{"tf":1},"565":{"tf":1},"572":{"tf":1},"764":{"tf":1},"767":{"tf":1},"772":{"tf":1},"779":{"tf":1},"909":{"tf":1}},"df":17}}}}}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{"119":{"tf":1.4142135623730951},"122":{"tf":1.4142135623730951},"354":{"tf":1.4142135623730951},"357":{"tf":1.4142135623730951}},"df":4,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"k":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"119":{"tf":1},"125":{"tf":1},"354":{"tf":1},"360":{"tf":1},"789":{"tf":1}},"df":5}}}}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"m":{"docs":{"350":{"tf":1}},"df":1,"a":{"docs":{},"df":0,"l":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2}}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"g":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{},"df":0,"u":{"docs":{"119":{"tf":1},"122":{"tf":1},"357":{"tf":1}},"df":3}}}}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"119":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"t":{"docs":{"119":{"tf":1},"354":{"tf":1},"782":{"tf":1}},"df":3}}}}}},"u":{"docs":{},"df":0,"m":{"docs":{"189":{"tf":1},"424":{"tf":1},"643":{"tf":1},"853":{"tf":1},"915":{"tf":1},"917":{"tf":1},"956":{"tf":1},"963":{"tf":1}},"df":8}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"121":{"tf":1}},"df":1}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"54":{"tf":1},"83":{"tf":1},"87":{"tf":1},"91":{"tf":1},"94":{"tf":1.4142135623730951},"115":{"tf":1},"116":{"tf":1},"171":{"tf":1},"176":{"tf":1},"204":{"tf":1},"205":{"tf":1},"206":{"tf":1},"207":{"tf":1},"210":{"tf":1},"213":{"tf":1},"215":{"tf":1},"216":{"tf":1},"217":{"tf":1},"220":{"tf":1},"232":{"tf":1},"286":{"tf":1},"314":{"tf":1},"318":{"tf":1},"325":{"tf":1.4142135623730951},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1},"351":{"tf":1},"406":{"tf":1},"411":{"tf":1},"439":{"tf":1},"440":{"tf":1},"442":{"tf":1},"445":{"tf":1},"447":{"tf":1},"448":{"tf":1},"449":{"tf":1},"452":{"tf":1},"464":{"tf":1},"518":{"tf":1},"546":{"tf":1},"550":{"tf":1},"554":{"tf":1},"557":{"tf":1.4142135623730951},"578":{"tf":1},"579":{"tf":1},"625":{"tf":1},"630":{"tf":1},"659":{"tf":1},"661":{"tf":1},"662":{"tf":1},"663":{"tf":1},"666":{"tf":1},"678":{"tf":1},"718":{"tf":1},"732":{"tf":1},"761":{"tf":1},"764":{"tf":1.4142135623730951},"785":{"tf":1},"835":{"tf":1},"840":{"tf":1},"870":{"tf":1},"871":{"tf":1},"874":{"tf":1},"883":{"tf":1},"907":{"tf":1},"909":{"tf":1.4142135623730951},"930":{"tf":1},"935":{"tf":1},"948":{"tf":1}},"df":70}}}}},"s":{"docs":{},"df":0,"s":{"docs":{"90":{"tf":1},"321":{"tf":1},"350":{"tf":1},"351":{"tf":1},"354":{"tf":1},"553":{"tf":1},"923":{"tf":1}},"df":7}},"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"232":{"tf":1.4142135623730951},"464":{"tf":1.4142135623730951},"678":{"tf":1.4142135623730951},"883":{"tf":1.4142135623730951}},"df":4}}}}}}}}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{"98":{"tf":1},"122":{"tf":1},"168":{"tf":1},"177":{"tf":1},"329":{"tf":1},"357":{"tf":1},"403":{"tf":1},"412":{"tf":1},"458":{"tf":1},"561":{"tf":1},"622":{"tf":1},"631":{"tf":1},"672":{"tf":1},"768":{"tf":1},"832":{"tf":1},"841":{"tf":1},"950":{"tf":1},"956":{"tf":1},"962":{"tf":1}},"df":19,"u":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1},"253":{"tf":1}},"df":2}},"t":{"docs":{"66":{"tf":1.4142135623730951},"224":{"tf":1},"225":{"tf":1},"253":{"tf":1},"456":{"tf":1},"457":{"tf":1},"485":{"tf":1},"529":{"tf":1.4142135623730951},"540":{"tf":1.4142135623730951},"670":{"tf":1},"671":{"tf":1},"699":{"tf":1.4142135623730951},"748":{"tf":1},"878":{"tf":1},"879":{"tf":1},"918":{"tf":1},"941":{"tf":1}},"df":17,"e":{"docs":{},"df":0,"t":{"docs":{"47":{"tf":1},"253":{"tf":1},"279":{"tf":1},"511":{"tf":1},"699":{"tf":1},"725":{"tf":1}},"df":6},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"918":{"tf":1}},"df":1}}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"94":{"tf":1},"192":{"tf":1},"325":{"tf":1},"427":{"tf":1},"557":{"tf":1},"646":{"tf":1},"764":{"tf":1},"856":{"tf":1},"935":{"tf":1}},"df":9}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"935":{"tf":1.7320508075688772}},"df":1}}}},"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"149":{"tf":1},"211":{"tf":1},"384":{"tf":1},"443":{"tf":1},"603":{"tf":1},"657":{"tf":1},"813":{"tf":1},"868":{"tf":1},"948":{"tf":1.4142135623730951}},"df":9}}}}},"h":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1},"14":{"tf":1},"26":{"tf":1.4142135623730951},"43":{"tf":1},"54":{"tf":1},"64":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"73":{"tf":1},"74":{"tf":1},"77":{"tf":1},"82":{"tf":1},"86":{"tf":1},"101":{"tf":1},"103":{"tf":1},"104":{"tf":1},"109":{"tf":1},"116":{"tf":1},"168":{"tf":1},"177":{"tf":1},"178":{"tf":1},"182":{"tf":1.7320508075688772},"189":{"tf":1},"192":{"tf":1.4142135623730951},"195":{"tf":1},"229":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"246":{"tf":1},"258":{"tf":1.4142135623730951},"275":{"tf":1},"286":{"tf":1},"294":{"tf":1},"295":{"tf":1},"303":{"tf":1.4142135623730951},"304":{"tf":1},"305":{"tf":1},"308":{"tf":1},"313":{"tf":1},"317":{"tf":1},"332":{"tf":1},"334":{"tf":1},"335":{"tf":1},"340":{"tf":1},"347":{"tf":1},"403":{"tf":1},"412":{"tf":1},"413":{"tf":1},"417":{"tf":1.7320508075688772},"424":{"tf":1},"427":{"tf":1.4142135623730951},"430":{"tf":1},"461":{"tf":1},"463":{"tf":1.4142135623730951},"464":{"tf":1.4142135623730951},"478":{"tf":1},"490":{"tf":1.4142135623730951},"507":{"tf":1},"518":{"tf":1},"526":{"tf":1},"527":{"tf":1},"535":{"tf":1.4142135623730951},"536":{"tf":1},"537":{"tf":1},"540":{"tf":1},"545":{"tf":1},"549":{"tf":1},"564":{"tf":1},"566":{"tf":1},"567":{"tf":1},"572":{"tf":1},"579":{"tf":1},"622":{"tf":1},"631":{"tf":1},"632":{"tf":1},"636":{"tf":1.7320508075688772},"643":{"tf":1},"646":{"tf":1.4142135623730951},"649":{"tf":1},"675":{"tf":1},"677":{"tf":1.4142135623730951},"678":{"tf":1.4142135623730951},"692":{"tf":1},"704":{"tf":1.4142135623730951},"721":{"tf":1},"732":{"tf":1},"741":{"tf":2},"742":{"tf":1},"744":{"tf":1},"750":{"tf":1.4142135623730951},"751":{"tf":1},"752":{"tf":1},"755":{"tf":1.4142135623730951},"759":{"tf":1},"771":{"tf":1},"773":{"tf":1},"774":{"tf":1},"779":{"tf":1},"832":{"tf":1},"841":{"tf":1},"842":{"tf":1},"846":{"tf":1.7320508075688772},"853":{"tf":1},"856":{"tf":1.4142135623730951},"859":{"tf":1},"883":{"tf":2.23606797749979},"896":{"tf":1},"914":{"tf":1},"938":{"tf":1}},"df":108,"t":{"docs":{"26":{"tf":1.4142135623730951},"184":{"tf":1},"207":{"tf":1.4142135623730951},"258":{"tf":1.4142135623730951},"419":{"tf":1},"490":{"tf":1.4142135623730951},"638":{"tf":1},"704":{"tf":1.4142135623730951},"848":{"tf":1}},"df":9}},"r":{"docs":{"224":{"tf":1},"226":{"tf":1},"232":{"tf":1},"456":{"tf":1},"458":{"tf":1},"464":{"tf":1},"670":{"tf":1},"672":{"tf":1},"678":{"tf":1},"878":{"tf":1},"880":{"tf":1},"883":{"tf":1}},"df":12,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"168":{"tf":1},"403":{"tf":1},"622":{"tf":1},"832":{"tf":1}},"df":4}}}}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"67":{"tf":1},"530":{"tf":1}},"df":2}},"l":{"docs":{},"df":0,"n":{"docs":{"229":{"tf":1},"461":{"tf":1},"675":{"tf":1},"883":{"tf":1}},"df":4}}}}},"i":{"docs":{},"df":0,"t":{"docs":{"941":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"5":{"tf":1},"27":{"tf":1.4142135623730951},"39":{"tf":1},"56":{"tf":1},"109":{"tf":1},"119":{"tf":1},"122":{"tf":1.4142135623730951},"155":{"tf":1},"157":{"tf":1},"161":{"tf":1.4142135623730951},"168":{"tf":1},"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"178":{"tf":1},"181":{"tf":1},"183":{"tf":1},"192":{"tf":1.4142135623730951},"195":{"tf":1},"203":{"tf":1},"210":{"tf":1},"229":{"tf":1.4142135623730951},"231":{"tf":1},"232":{"tf":2},"259":{"tf":1.4142135623730951},"271":{"tf":1},"288":{"tf":1},"340":{"tf":1},"350":{"tf":1},"351":{"tf":1},"357":{"tf":1.4142135623730951},"390":{"tf":1},"392":{"tf":1},"396":{"tf":1.4142135623730951},"403":{"tf":1},"411":{"tf":1.4142135623730951},"412":{"tf":1.4142135623730951},"413":{"tf":1},"416":{"tf":1},"418":{"tf":1},"427":{"tf":1.4142135623730951},"430":{"tf":1},"438":{"tf":1},"442":{"tf":1},"461":{"tf":1.4142135623730951},"463":{"tf":1},"464":{"tf":2},"491":{"tf":1.4142135623730951},"503":{"tf":1},"520":{"tf":1},"572":{"tf":1},"609":{"tf":1},"611":{"tf":1},"615":{"tf":1.4142135623730951},"622":{"tf":1},"630":{"tf":1.4142135623730951},"631":{"tf":1.4142135623730951},"632":{"tf":1},"635":{"tf":1},"637":{"tf":1},"646":{"tf":1.4142135623730951},"649":{"tf":1},"675":{"tf":1.4142135623730951},"677":{"tf":1},"678":{"tf":2},"705":{"tf":1.4142135623730951},"717":{"tf":1},"725":{"tf":1.4142135623730951},"734":{"tf":1},"779":{"tf":1},"819":{"tf":1},"821":{"tf":1},"825":{"tf":1.4142135623730951},"832":{"tf":1},"840":{"tf":1.4142135623730951},"841":{"tf":1.4142135623730951},"842":{"tf":1},"845":{"tf":1},"847":{"tf":1},"856":{"tf":1.4142135623730951},"859":{"tf":1},"883":{"tf":2.6457513110645907},"892":{"tf":1},"899":{"tf":1},"907":{"tf":1},"912":{"tf":1.4142135623730951},"913":{"tf":1.7320508075688772},"914":{"tf":1},"915":{"tf":1},"917":{"tf":1},"918":{"tf":1.4142135623730951},"919":{"tf":1.7320508075688772},"924":{"tf":1},"926":{"tf":1},"940":{"tf":1},"951":{"tf":1}},"df":95},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1},"90":{"tf":1},"195":{"tf":1.7320508075688772},"312":{"tf":1},"321":{"tf":1},"430":{"tf":1.7320508075688772},"544":{"tf":1},"553":{"tf":1},"649":{"tf":1.7320508075688772},"718":{"tf":1},"758":{"tf":1},"859":{"tf":1.7320508075688772}},"df":12}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"946":{"tf":1}},"df":1}}}}}}}}}},"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"5":{"tf":1}},"df":1}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1},"253":{"tf":1},"485":{"tf":1},"742":{"tf":1},"897":{"tf":1},"914":{"tf":1},"935":{"tf":1},"939":{"tf":1},"961":{"tf":1},"963":{"tf":1}},"df":10},"t":{"docs":{"168":{"tf":1},"403":{"tf":1},"622":{"tf":1},"832":{"tf":1}},"df":4},"k":{"docs":{},"df":0,"f":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"941":{"tf":1}},"df":1}}}}}}}}}}}}}},"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"27":{"tf":1},"259":{"tf":1},"491":{"tf":1},"705":{"tf":1}},"df":4}},"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4}}}}}}}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{"27":{"tf":1},"116":{"tf":1},"122":{"tf":1},"182":{"tf":1},"226":{"tf":1},"259":{"tf":1},"347":{"tf":1},"417":{"tf":1},"458":{"tf":1},"579":{"tf":1},"636":{"tf":1},"672":{"tf":1},"718":{"tf":1},"846":{"tf":1}},"df":14}}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"917":{"tf":1}},"df":1}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}}}}}}}}}}}}}}}}},"w":{"docs":{},"df":0,"w":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"215":{"tf":1},"447":{"tf":1},"661":{"tf":1}},"df":3}}}}}}}}}}}}}}}}}}}}}}}},"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"220":{"tf":1},"229":{"tf":1.4142135623730951},"452":{"tf":1},"461":{"tf":1.4142135623730951},"666":{"tf":1},"675":{"tf":1.4142135623730951},"874":{"tf":1},"883":{"tf":1.4142135623730951}},"df":8}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"51":{"tf":1},"55":{"tf":1},"64":{"tf":1},"195":{"tf":1.4142135623730951},"253":{"tf":1},"283":{"tf":1},"287":{"tf":1},"295":{"tf":1},"351":{"tf":1},"430":{"tf":1.4142135623730951},"515":{"tf":1},"519":{"tf":1},"527":{"tf":1},"649":{"tf":1.4142135623730951},"699":{"tf":1},"729":{"tf":1},"733":{"tf":1},"859":{"tf":1.4142135623730951},"895":{"tf":1},"907":{"tf":1},"913":{"tf":1},"934":{"tf":1.4142135623730951},"935":{"tf":1},"937":{"tf":1},"943":{"tf":1},"944":{"tf":1},"945":{"tf":1},"965":{"tf":1}},"df":29,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1}},"df":1,"t":{"docs":{"3":{"tf":1},"14":{"tf":1},"246":{"tf":1},"478":{"tf":1},"692":{"tf":1},"938":{"tf":1}},"df":6}}}}}},"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"938":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"940":{"tf":1}},"df":2}}}},"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1}}}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1},"72":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"78":{"tf":1},"81":{"tf":1},"86":{"tf":1},"94":{"tf":1},"109":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"229":{"tf":1},"230":{"tf":1},"232":{"tf":1.4142135623730951},"303":{"tf":1.4142135623730951},"305":{"tf":1.7320508075688772},"309":{"tf":1},"312":{"tf":1},"317":{"tf":1},"325":{"tf":1},"340":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"350":{"tf":1.4142135623730951},"356":{"tf":1},"360":{"tf":1.4142135623730951},"461":{"tf":1},"462":{"tf":1},"464":{"tf":1.4142135623730951},"535":{"tf":1.7320508075688772},"537":{"tf":1.7320508075688772},"541":{"tf":1},"544":{"tf":1},"549":{"tf":1},"557":{"tf":1},"572":{"tf":1},"578":{"tf":1.4142135623730951},"579":{"tf":1.4142135623730951},"675":{"tf":1},"676":{"tf":1},"678":{"tf":1.4142135623730951},"747":{"tf":1},"748":{"tf":1},"749":{"tf":1.4142135623730951},"750":{"tf":1.4142135623730951},"752":{"tf":1.7320508075688772},"758":{"tf":1},"760":{"tf":1},"761":{"tf":1},"764":{"tf":1},"779":{"tf":1},"785":{"tf":1.4142135623730951},"786":{"tf":1},"789":{"tf":1},"883":{"tf":2}},"df":55}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{"21":{"tf":1},"37":{"tf":1},"269":{"tf":1},"501":{"tf":1},"715":{"tf":1}},"df":5}}},"k":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"253":{"tf":1},"485":{"tf":1},"699":{"tf":1}},"df":4}}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"33":{"tf":1},"56":{"tf":1},"157":{"tf":1},"265":{"tf":1},"288":{"tf":1},"392":{"tf":1},"497":{"tf":1},"520":{"tf":1},"611":{"tf":1},"711":{"tf":1},"734":{"tf":1},"821":{"tf":1}},"df":12}}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"54":{"tf":1},"77":{"tf":1},"82":{"tf":1},"286":{"tf":1},"308":{"tf":1},"313":{"tf":1},"350":{"tf":1},"518":{"tf":1},"540":{"tf":1.4142135623730951},"545":{"tf":1},"732":{"tf":1},"747":{"tf":1},"759":{"tf":1},"939":{"tf":1.4142135623730951}},"df":14}}}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"62":{"tf":1},"294":{"tf":1},"526":{"tf":1}},"df":3}}}}}},"u":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"82":{"tf":1},"90":{"tf":1},"195":{"tf":1},"313":{"tf":1},"321":{"tf":1},"430":{"tf":1},"545":{"tf":1},"553":{"tf":1},"649":{"tf":1},"759":{"tf":1},"859":{"tf":1}},"df":11}}}}}},"a":{"docs":{},"df":0,"b":{"docs":{"237":{"tf":1},"469":{"tf":1},"683":{"tf":1}},"df":3,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":4}}}}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"28":{"tf":1},"260":{"tf":1},"492":{"tf":1},"706":{"tf":1}},"df":5}}},"o":{"docs":{},"df":0,"s":{"docs":{"913":{"tf":1}},"df":1}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1},"28":{"tf":1},"72":{"tf":1.4142135623730951},"73":{"tf":1},"77":{"tf":1.7320508075688772},"81":{"tf":1},"86":{"tf":1.4142135623730951},"109":{"tf":1},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"119":{"tf":1},"125":{"tf":3.1622776601683795},"229":{"tf":1.7320508075688772},"260":{"tf":1},"303":{"tf":1.4142135623730951},"304":{"tf":1},"305":{"tf":1},"308":{"tf":1.7320508075688772},"312":{"tf":1},"317":{"tf":1.4142135623730951},"340":{"tf":1},"346":{"tf":1.7320508075688772},"347":{"tf":1.7320508075688772},"350":{"tf":1.7320508075688772},"354":{"tf":1.4142135623730951},"356":{"tf":1},"360":{"tf":3.1622776601683795},"461":{"tf":1.7320508075688772},"492":{"tf":1},"535":{"tf":1.7320508075688772},"536":{"tf":1},"540":{"tf":1.7320508075688772},"544":{"tf":1},"549":{"tf":1.4142135623730951},"572":{"tf":1},"578":{"tf":1.7320508075688772},"579":{"tf":1.7320508075688772},"675":{"tf":1.7320508075688772},"706":{"tf":1},"748":{"tf":1},"750":{"tf":1.4142135623730951},"751":{"tf":1},"755":{"tf":1.4142135623730951},"758":{"tf":1},"779":{"tf":1},"782":{"tf":1},"785":{"tf":1.7320508075688772},"789":{"tf":1},"883":{"tf":1.7320508075688772},"938":{"tf":2.23606797749979},"942":{"tf":1},"951":{"tf":1}},"df":52,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1},"32":{"tf":1},"125":{"tf":1},"259":{"tf":1},"264":{"tf":1},"360":{"tf":1},"491":{"tf":1},"496":{"tf":1},"705":{"tf":1},"789":{"tf":1}},"df":10}}}},"e":{"docs":{},"df":0,"n":{"docs":{"747":{"tf":1},"748":{"tf":2},"755":{"tf":1.7320508075688772}},"df":3}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"f":{"docs":{"72":{"tf":1},"303":{"tf":1},"535":{"tf":1},"748":{"tf":1},"750":{"tf":1}},"df":5}}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{"115":{"tf":1},"116":{"tf":1},"125":{"tf":1},"229":{"tf":1},"346":{"tf":1},"347":{"tf":1},"360":{"tf":1},"461":{"tf":1},"578":{"tf":1},"579":{"tf":1},"675":{"tf":1},"785":{"tf":1},"883":{"tf":1}},"df":13}}}}}}}},"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{"59":{"tf":1},"71":{"tf":1.4142135623730951},"72":{"tf":1},"77":{"tf":1.4142135623730951},"229":{"tf":1},"291":{"tf":1},"302":{"tf":1.4142135623730951},"303":{"tf":1},"308":{"tf":1.4142135623730951},"354":{"tf":1},"461":{"tf":1},"523":{"tf":1},"534":{"tf":1.4142135623730951},"535":{"tf":1},"540":{"tf":1.4142135623730951},"675":{"tf":1},"747":{"tf":1},"750":{"tf":1},"755":{"tf":1},"883":{"tf":1}},"df":20}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"t":{"docs":{"94":{"tf":1},"325":{"tf":1},"557":{"tf":1},"764":{"tf":1}},"df":4}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"214":{"tf":1},"246":{"tf":1},"446":{"tf":1},"478":{"tf":1},"660":{"tf":1},"692":{"tf":1},"869":{"tf":1},"892":{"tf":1},"909":{"tf":1},"926":{"tf":1}},"df":11}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{"31":{"tf":1},"34":{"tf":1},"149":{"tf":1},"210":{"tf":1},"263":{"tf":1},"266":{"tf":1},"384":{"tf":1},"442":{"tf":1},"495":{"tf":1},"498":{"tf":1},"603":{"tf":1},"709":{"tf":1},"712":{"tf":1},"813":{"tf":1},"928":{"tf":1}},"df":15}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"183":{"tf":1},"418":{"tf":1},"637":{"tf":1},"847":{"tf":1}},"df":4}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"935":{"tf":1}},"df":1}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{"38":{"tf":1},"59":{"tf":1},"78":{"tf":1},"215":{"tf":1},"270":{"tf":1},"291":{"tf":1},"309":{"tf":1},"447":{"tf":1},"502":{"tf":1},"523":{"tf":1},"541":{"tf":1},"661":{"tf":1},"716":{"tf":1},"919":{"tf":1},"947":{"tf":1}},"df":15}}},"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"38":{"tf":1},"270":{"tf":1},"502":{"tf":1},"716":{"tf":1}},"df":4}}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{"46":{"tf":1},"81":{"tf":1},"86":{"tf":1},"140":{"tf":1.7320508075688772},"157":{"tf":1},"210":{"tf":1},"232":{"tf":1.4142135623730951},"278":{"tf":1},"312":{"tf":1},"317":{"tf":1},"375":{"tf":1.7320508075688772},"392":{"tf":1},"442":{"tf":1},"464":{"tf":1.4142135623730951},"510":{"tf":1},"544":{"tf":1},"549":{"tf":1},"594":{"tf":1.7320508075688772},"611":{"tf":1},"678":{"tf":1.4142135623730951},"724":{"tf":1},"758":{"tf":1},"804":{"tf":1.7320508075688772},"821":{"tf":1},"883":{"tf":1.4142135623730951},"894":{"tf":1},"898":{"tf":1},"908":{"tf":1},"909":{"tf":1.7320508075688772},"910":{"tf":1},"911":{"tf":1},"913":{"tf":1.7320508075688772},"914":{"tf":1},"917":{"tf":1.4142135623730951},"919":{"tf":1.4142135623730951},"920":{"tf":1},"923":{"tf":1.4142135623730951},"931":{"tf":2.23606797749979}},"df":38,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{"46":{"tf":1},"47":{"tf":1.7320508075688772},"86":{"tf":1},"87":{"tf":1},"278":{"tf":1},"279":{"tf":1.7320508075688772},"317":{"tf":1},"318":{"tf":1},"510":{"tf":1},"511":{"tf":1.7320508075688772},"549":{"tf":1},"550":{"tf":1},"724":{"tf":1},"725":{"tf":1.4142135623730951}},"df":14}}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1},"86":{"tf":1},"283":{"tf":1},"317":{"tf":1},"515":{"tf":1},"549":{"tf":1},"729":{"tf":1}},"df":7}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1},"283":{"tf":1},"515":{"tf":1},"729":{"tf":1}},"df":4}}}}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"86":{"tf":1},"317":{"tf":1},"549":{"tf":1}},"df":3}}}}}}},"u":{"docs":{},"df":0,"f":{"docs":{"105":{"tf":1},"178":{"tf":1},"188":{"tf":1},"336":{"tf":1},"413":{"tf":1},"423":{"tf":1},"568":{"tf":1},"632":{"tf":1},"642":{"tf":1},"775":{"tf":1},"842":{"tf":1},"852":{"tf":1},"923":{"tf":1},"929":{"tf":1},"935":{"tf":1},"953":{"tf":1},"956":{"tf":1}},"df":17,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"183":{"tf":1},"418":{"tf":1},"637":{"tf":1},"847":{"tf":1}},"df":4}}}}},"t":{"docs":{"956":{"tf":1.4142135623730951}},"df":1}}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{"86":{"tf":1},"317":{"tf":1},"549":{"tf":1},"918":{"tf":1},"934":{"tf":1},"935":{"tf":1},"938":{"tf":1.4142135623730951},"943":{"tf":1},"953":{"tf":1},"958":{"tf":1}},"df":10,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"747":{"tf":1},"748":{"tf":1}},"df":2}}}}}}}}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{"237":{"tf":1},"469":{"tf":1},"540":{"tf":1},"683":{"tf":1}},"df":4}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{"237":{"tf":1},"350":{"tf":1},"469":{"tf":1},"683":{"tf":1}},"df":4}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"909":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{"920":{"tf":1},"935":{"tf":1}},"df":2}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"935":{"tf":1}},"df":1}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"146":{"tf":1},"381":{"tf":1},"600":{"tf":1},"810":{"tf":1},"923":{"tf":1}},"df":5}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"950":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{"4":{"tf":1},"105":{"tf":1},"125":{"tf":1},"149":{"tf":1},"232":{"tf":1},"336":{"tf":1},"360":{"tf":1},"384":{"tf":1},"464":{"tf":1},"568":{"tf":1},"603":{"tf":1},"678":{"tf":1},"775":{"tf":1},"813":{"tf":1},"883":{"tf":1},"897":{"tf":1},"899":{"tf":1},"902":{"tf":1},"908":{"tf":1},"911":{"tf":1},"914":{"tf":1},"923":{"tf":1},"962":{"tf":1}},"df":23},"r":{"docs":{},"df":0,"d":{"docs":{"109":{"tf":1},"125":{"tf":1},"151":{"tf":1},"164":{"tf":1},"232":{"tf":1},"340":{"tf":1},"350":{"tf":1},"360":{"tf":1},"386":{"tf":1},"399":{"tf":1},"464":{"tf":1},"572":{"tf":1},"605":{"tf":1},"618":{"tf":1},"678":{"tf":1},"779":{"tf":1},"815":{"tf":1},"828":{"tf":1},"883":{"tf":1},"950":{"tf":1}},"df":20},"s":{"docs":{},"df":0,"t":{"docs":{"183":{"tf":1},"418":{"tf":1},"637":{"tf":1},"847":{"tf":1}},"df":4}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"b":{"docs":{"192":{"tf":1},"427":{"tf":1},"646":{"tf":1},"856":{"tf":1}},"df":4}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"911":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"/":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{"81":{"tf":1},"102":{"tf":1},"312":{"tf":1},"333":{"tf":1},"544":{"tf":1},"565":{"tf":1},"758":{"tf":1},"772":{"tf":1}},"df":8}}}}}}}}}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"351":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"u":{"docs":{"898":{"tf":1}},"df":1}}}}},"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{"4":{"tf":1},"15":{"tf":1},"247":{"tf":1},"479":{"tf":1},"693":{"tf":1}},"df":5},"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"z":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"51":{"tf":1.4142135623730951},"283":{"tf":1.4142135623730951},"515":{"tf":1.4142135623730951},"729":{"tf":1.4142135623730951}},"df":4}}}}}}},"p":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"143":{"tf":1},"378":{"tf":1},"597":{"tf":1},"807":{"tf":1}},"df":4}}}}}}}}},"e":{"docs":{},"df":0,"h":{"docs":{"21":{"tf":1},"485":{"tf":1}},"df":2},"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"63":{"tf":1},"67":{"tf":1},"202":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"253":{"tf":1},"298":{"tf":1},"437":{"tf":1.4142135623730951},"438":{"tf":1.4142135623730951},"485":{"tf":1},"530":{"tf":1},"656":{"tf":1.4142135623730951},"699":{"tf":1},"744":{"tf":1},"866":{"tf":1.4142135623730951},"928":{"tf":1}},"df":16}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"66":{"tf":1},"529":{"tf":1}},"df":2}}}}}},"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1.7320508075688772},"37":{"tf":1},"51":{"tf":1},"56":{"tf":1.4142135623730951},"134":{"tf":1},"138":{"tf":1},"140":{"tf":1.4142135623730951},"157":{"tf":1},"161":{"tf":1.4142135623730951},"168":{"tf":1},"182":{"tf":1},"189":{"tf":1},"192":{"tf":1},"203":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"215":{"tf":1},"224":{"tf":1},"226":{"tf":1.7320508075688772},"231":{"tf":1},"232":{"tf":1.4142135623730951},"259":{"tf":1.7320508075688772},"269":{"tf":1},"283":{"tf":1},"288":{"tf":1.4142135623730951},"369":{"tf":1},"373":{"tf":1},"375":{"tf":1.4142135623730951},"392":{"tf":1},"396":{"tf":1.4142135623730951},"403":{"tf":1},"417":{"tf":1},"424":{"tf":1},"427":{"tf":1},"438":{"tf":1.4142135623730951},"447":{"tf":1},"456":{"tf":1},"458":{"tf":1.4142135623730951},"463":{"tf":1},"464":{"tf":1.4142135623730951},"491":{"tf":1.7320508075688772},"501":{"tf":1},"515":{"tf":1},"520":{"tf":1.4142135623730951},"588":{"tf":1},"592":{"tf":1},"594":{"tf":1.4142135623730951},"611":{"tf":1},"615":{"tf":1.4142135623730951},"622":{"tf":1},"636":{"tf":1},"643":{"tf":1},"646":{"tf":1},"661":{"tf":1},"670":{"tf":1},"672":{"tf":1.4142135623730951},"677":{"tf":1},"678":{"tf":1.4142135623730951},"705":{"tf":1.7320508075688772},"715":{"tf":1},"729":{"tf":1},"734":{"tf":1.4142135623730951},"742":{"tf":1},"798":{"tf":1},"802":{"tf":1},"804":{"tf":1.4142135623730951},"821":{"tf":1},"825":{"tf":1.4142135623730951},"832":{"tf":1},"846":{"tf":1},"853":{"tf":1},"856":{"tf":1},"878":{"tf":1},"880":{"tf":1.4142135623730951},"883":{"tf":1.7320508075688772},"909":{"tf":1.7320508075688772},"912":{"tf":1},"913":{"tf":2.6457513110645907},"914":{"tf":1},"915":{"tf":1},"919":{"tf":1.7320508075688772},"923":{"tf":1.7320508075688772},"924":{"tf":1},"926":{"tf":1},"931":{"tf":1.7320508075688772}},"df":84}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{"156":{"tf":1},"391":{"tf":1},"610":{"tf":1},"820":{"tf":1}},"df":4}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"195":{"tf":1.4142135623730951},"430":{"tf":1.4142135623730951},"649":{"tf":1.4142135623730951},"742":{"tf":1},"859":{"tf":1.4142135623730951}},"df":5}}}}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"749":{"tf":1},"750":{"tf":1}},"df":2}}}}}},"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{"11":{"tf":1},"21":{"tf":1.4142135623730951},"27":{"tf":1},"33":{"tf":1},"34":{"tf":1},"50":{"tf":1},"66":{"tf":1},"78":{"tf":1},"90":{"tf":1.4142135623730951},"106":{"tf":1.4142135623730951},"119":{"tf":1},"128":{"tf":2.449489742783178},"137":{"tf":2.6457513110645907},"138":{"tf":1.4142135623730951},"139":{"tf":1.4142135623730951},"140":{"tf":1.7320508075688772},"161":{"tf":1},"181":{"tf":1},"182":{"tf":2},"183":{"tf":1},"192":{"tf":1.4142135623730951},"216":{"tf":1},"217":{"tf":1},"220":{"tf":1.4142135623730951},"229":{"tf":1},"231":{"tf":1},"232":{"tf":1},"234":{"tf":1},"243":{"tf":1},"253":{"tf":1},"259":{"tf":1},"265":{"tf":1},"266":{"tf":1},"282":{"tf":1},"309":{"tf":1},"321":{"tf":1.4142135623730951},"337":{"tf":1.4142135623730951},"354":{"tf":1},"363":{"tf":2.449489742783178},"372":{"tf":2.6457513110645907},"373":{"tf":1.4142135623730951},"374":{"tf":1.4142135623730951},"375":{"tf":1.7320508075688772},"396":{"tf":1},"416":{"tf":1},"417":{"tf":2},"418":{"tf":1},"427":{"tf":1.4142135623730951},"448":{"tf":1},"449":{"tf":1},"452":{"tf":1.4142135623730951},"461":{"tf":1},"463":{"tf":1},"464":{"tf":1},"466":{"tf":1},"475":{"tf":1},"485":{"tf":1},"491":{"tf":1},"497":{"tf":1},"498":{"tf":1},"514":{"tf":1},"529":{"tf":1},"541":{"tf":1},"553":{"tf":1.4142135623730951},"569":{"tf":1.4142135623730951},"582":{"tf":2.449489742783178},"591":{"tf":2.6457513110645907},"592":{"tf":1.4142135623730951},"593":{"tf":1.4142135623730951},"594":{"tf":1.7320508075688772},"615":{"tf":1},"635":{"tf":1},"636":{"tf":2},"637":{"tf":1},"646":{"tf":1.4142135623730951},"662":{"tf":1},"663":{"tf":1},"666":{"tf":1.4142135623730951},"675":{"tf":1},"677":{"tf":1},"678":{"tf":1},"680":{"tf":1},"689":{"tf":1},"699":{"tf":1},"705":{"tf":1},"711":{"tf":1},"712":{"tf":1},"728":{"tf":1},"776":{"tf":1.4142135623730951},"782":{"tf":1},"792":{"tf":2.449489742783178},"801":{"tf":2.6457513110645907},"802":{"tf":1.4142135623730951},"803":{"tf":1.4142135623730951},"804":{"tf":1.7320508075688772},"825":{"tf":1},"845":{"tf":1},"846":{"tf":2},"847":{"tf":1},"856":{"tf":1.4142135623730951},"870":{"tf":1},"871":{"tf":1},"874":{"tf":1.4142135623730951},"880":{"tf":1},"883":{"tf":1.7320508075688772},"885":{"tf":1},"900":{"tf":1},"902":{"tf":1},"903":{"tf":1},"909":{"tf":1.7320508075688772},"913":{"tf":1},"914":{"tf":1},"915":{"tf":1.4142135623730951},"924":{"tf":1},"926":{"tf":1},"927":{"tf":1},"928":{"tf":1},"929":{"tf":1.4142135623730951},"931":{"tf":1}},"df":119,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{"38":{"tf":1},"270":{"tf":1},"502":{"tf":1},"716":{"tf":1}},"df":4}}},"p":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"210":{"tf":1.4142135623730951},"442":{"tf":1.4142135623730951}},"df":2}}}}}}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"11":{"tf":1},"243":{"tf":1},"475":{"tf":1},"689":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"t":{"docs":{"232":{"tf":1},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":4}}}}},"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"15":{"tf":1},"63":{"tf":1},"64":{"tf":1},"65":{"tf":1},"77":{"tf":1},"105":{"tf":1},"134":{"tf":1},"155":{"tf":1},"195":{"tf":1},"229":{"tf":1},"230":{"tf":1},"231":{"tf":1.7320508075688772},"247":{"tf":1},"295":{"tf":1.4142135623730951},"296":{"tf":1},"308":{"tf":1},"336":{"tf":1},"369":{"tf":1},"390":{"tf":1},"430":{"tf":1},"461":{"tf":1},"462":{"tf":1},"463":{"tf":1.7320508075688772},"479":{"tf":1},"527":{"tf":1.4142135623730951},"528":{"tf":1},"540":{"tf":1},"568":{"tf":1},"588":{"tf":1},"609":{"tf":1},"649":{"tf":1},"675":{"tf":1},"676":{"tf":1},"677":{"tf":1.7320508075688772},"693":{"tf":1},"741":{"tf":2},"742":{"tf":1.4142135623730951},"743":{"tf":1},"750":{"tf":1},"775":{"tf":1},"798":{"tf":1},"819":{"tf":1},"859":{"tf":1},"883":{"tf":2.23606797749979},"892":{"tf":1},"896":{"tf":1.4142135623730951},"911":{"tf":1},"914":{"tf":1},"943":{"tf":1},"948":{"tf":1}},"df":50,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"55":{"tf":1},"287":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":4}}}}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"f":{"docs":{"104":{"tf":1},"335":{"tf":1},"567":{"tf":1},"774":{"tf":1}},"df":4}}}}},"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2},"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"140":{"tf":1.4142135623730951},"375":{"tf":1.4142135623730951},"594":{"tf":1.4142135623730951},"804":{"tf":1.4142135623730951}},"df":4}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"47":{"tf":1},"94":{"tf":1},"122":{"tf":1},"279":{"tf":1},"325":{"tf":1},"357":{"tf":1},"511":{"tf":1},"557":{"tf":1},"725":{"tf":1},"764":{"tf":1}},"df":10}}}}},"z":{"docs":{},"df":0,"u":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"62":{"tf":1},"207":{"tf":1},"231":{"tf":1},"294":{"tf":1},"463":{"tf":1},"526":{"tf":1},"677":{"tf":1},"883":{"tf":1},"941":{"tf":1.4142135623730951}},"df":9}}}},"k":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{"86":{"tf":1},"317":{"tf":1},"549":{"tf":1}},"df":3}}}}},"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{"138":{"tf":1},"139":{"tf":1},"140":{"tf":1},"143":{"tf":1},"144":{"tf":1.4142135623730951},"145":{"tf":1},"164":{"tf":1},"182":{"tf":1},"188":{"tf":1},"229":{"tf":1},"373":{"tf":1},"374":{"tf":1},"375":{"tf":1},"378":{"tf":1},"379":{"tf":1.4142135623730951},"380":{"tf":1},"399":{"tf":1},"417":{"tf":1},"423":{"tf":1},"461":{"tf":1},"592":{"tf":1},"593":{"tf":1},"594":{"tf":1},"597":{"tf":1},"598":{"tf":1.4142135623730951},"599":{"tf":1},"618":{"tf":1},"636":{"tf":1},"642":{"tf":1},"675":{"tf":1},"802":{"tf":1},"803":{"tf":1},"804":{"tf":1},"807":{"tf":1},"808":{"tf":1.4142135623730951},"809":{"tf":1},"828":{"tf":1},"846":{"tf":1},"852":{"tf":1},"867":{"tf":1},"883":{"tf":1},"903":{"tf":1},"914":{"tf":1}},"df":43}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"143":{"tf":1},"378":{"tf":1},"597":{"tf":1},"807":{"tf":1}},"df":4}}},"e":{"docs":{},"df":0,"s":{"docs":{"941":{"tf":1}},"df":1}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{"182":{"tf":1},"417":{"tf":1},"636":{"tf":1},"846":{"tf":1}},"df":4}}}}},"g":{"docs":{"867":{"tf":1}},"df":1}}},"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"116":{"tf":2.449489742783178},"119":{"tf":1},"125":{"tf":2.23606797749979},"347":{"tf":2.449489742783178},"354":{"tf":1},"360":{"tf":2.23606797749979},"527":{"tf":1},"579":{"tf":2.449489742783178}},"df":8}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{"187":{"tf":1.7320508075688772},"189":{"tf":1},"422":{"tf":1.7320508075688772},"424":{"tf":1},"641":{"tf":1.7320508075688772},"643":{"tf":1},"851":{"tf":1.7320508075688772},"853":{"tf":1},"891":{"tf":1},"904":{"tf":1},"941":{"tf":1}},"df":11}},"o":{"docs":{},"df":0,"s":{"docs":{"923":{"tf":1}},"df":1},"g":{"docs":{},"df":0,"g":{"docs":{"931":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"786":{"tf":1}},"df":1}}}}}}}}}},"n":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2},"8":{"tf":1.7320508075688772},"14":{"tf":1},"19":{"tf":1},"21":{"tf":1.7320508075688772},"26":{"tf":1},"46":{"tf":1},"62":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"97":{"tf":1},"119":{"tf":1.4142135623730951},"122":{"tf":1},"125":{"tf":2.23606797749979},"177":{"tf":1},"223":{"tf":1},"237":{"tf":1.4142135623730951},"240":{"tf":2},"246":{"tf":1},"253":{"tf":1},"258":{"tf":1},"278":{"tf":1},"294":{"tf":1.4142135623730951},"317":{"tf":1.4142135623730951},"350":{"tf":1},"351":{"tf":1.7320508075688772},"354":{"tf":1.7320508075688772},"357":{"tf":1},"360":{"tf":2.23606797749979},"469":{"tf":1.4142135623730951},"472":{"tf":1.7320508075688772},"478":{"tf":1},"483":{"tf":1},"485":{"tf":1.4142135623730951},"490":{"tf":1},"510":{"tf":1},"526":{"tf":1.7320508075688772},"527":{"tf":1},"529":{"tf":1},"549":{"tf":1.4142135623730951},"560":{"tf":1},"631":{"tf":1},"669":{"tf":1},"683":{"tf":1.4142135623730951},"686":{"tf":2},"692":{"tf":1},"697":{"tf":1.4142135623730951},"699":{"tf":1.4142135623730951},"704":{"tf":1},"724":{"tf":1},"740":{"tf":1.4142135623730951},"741":{"tf":2.449489742783178},"747":{"tf":1},"748":{"tf":1},"767":{"tf":1},"782":{"tf":1},"789":{"tf":1.4142135623730951},"892":{"tf":1},"909":{"tf":1},"913":{"tf":1}},"df":60,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"k":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1},"259":{"tf":1},"491":{"tf":1},"705":{"tf":1}},"df":4}}}}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"63":{"tf":1}},"df":1}}}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"177":{"tf":1},"412":{"tf":1},"631":{"tf":1},"841":{"tf":1}},"df":4}}}}},"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"535":{"tf":1}},"df":1}},"a":{"docs":{},"df":0,"l":{"docs":{"920":{"tf":1}},"df":1}}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"354":{"tf":1}},"df":1}}}}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"888":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"s":{"docs":{"119":{"tf":1},"182":{"tf":1},"417":{"tf":1},"636":{"tf":1},"846":{"tf":1}},"df":5}}},"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"38":{"tf":1},"270":{"tf":1},"502":{"tf":1},"716":{"tf":1}},"df":4}}}}},"d":{"docs":{"73":{"tf":1},"86":{"tf":1.4142135623730951},"102":{"tf":1},"116":{"tf":1},"122":{"tf":1.7320508075688772},"149":{"tf":1},"150":{"tf":1},"176":{"tf":1},"229":{"tf":1},"231":{"tf":1},"232":{"tf":1},"233":{"tf":1},"304":{"tf":1},"317":{"tf":1.4142135623730951},"333":{"tf":1},"347":{"tf":1},"357":{"tf":2.23606797749979},"384":{"tf":1},"385":{"tf":1},"411":{"tf":1},"461":{"tf":1},"463":{"tf":1},"464":{"tf":1},"465":{"tf":1},"536":{"tf":1},"549":{"tf":1.4142135623730951},"565":{"tf":1},"579":{"tf":1},"603":{"tf":1},"604":{"tf":1},"630":{"tf":1},"675":{"tf":1},"677":{"tf":1},"678":{"tf":1},"679":{"tf":1},"751":{"tf":1},"772":{"tf":1},"813":{"tf":1},"814":{"tf":1},"840":{"tf":1},"883":{"tf":1.7320508075688772},"884":{"tf":1},"911":{"tf":1},"938":{"tf":1},"950":{"tf":1},"962":{"tf":1}},"df":46,"e":{"docs":{},"df":0,"r":{"docs":{"97":{"tf":1},"122":{"tf":1},"182":{"tf":1},"195":{"tf":1},"328":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1},"417":{"tf":1},"430":{"tf":1},"560":{"tf":1},"636":{"tf":1},"649":{"tf":1},"767":{"tf":1},"846":{"tf":1},"859":{"tf":1},"951":{"tf":1},"956":{"tf":1}},"df":17,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"168":{"tf":1},"403":{"tf":1},"622":{"tf":1},"832":{"tf":1}},"df":5}}}}}},"t":{"docs":{"867":{"tf":1},"931":{"tf":1}},"df":2}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"143":{"tf":1},"378":{"tf":1},"597":{"tf":1},"807":{"tf":1}},"df":4}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"686":{"tf":1.4142135623730951},"697":{"tf":1.4142135623730951},"698":{"tf":1},"699":{"tf":2.6457513110645907},"741":{"tf":1.7320508075688772},"742":{"tf":1.4142135623730951},"743":{"tf":1},"748":{"tf":1},"760":{"tf":1},"761":{"tf":1},"786":{"tf":1},"828":{"tf":1},"867":{"tf":2}},"df":13,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{"700":{"tf":1}},"df":1}}}}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{"39":{"tf":1},"271":{"tf":1},"503":{"tf":1},"717":{"tf":1}},"df":4,"i":{"docs":{"4":{"tf":1},"40":{"tf":1},"272":{"tf":1},"504":{"tf":1},"718":{"tf":1}},"df":5,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"119":{"tf":1},"351":{"tf":1},"354":{"tf":1.4142135623730951},"782":{"tf":1}},"df":4}}}}}},"o":{"docs":{},"df":0,"g":{"docs":{"116":{"tf":1.4142135623730951},"150":{"tf":1},"347":{"tf":1.4142135623730951},"385":{"tf":1},"579":{"tf":1.4142135623730951},"604":{"tf":1},"786":{"tf":1},"814":{"tf":1}},"df":8}}}},"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"125":{"tf":1},"360":{"tf":1},"789":{"tf":1},"895":{"tf":1},"909":{"tf":1},"926":{"tf":1},"931":{"tf":1},"935":{"tf":1}},"df":8,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1}},"df":1}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{"11":{"tf":1},"27":{"tf":1},"33":{"tf":1},"243":{"tf":1},"259":{"tf":1},"265":{"tf":1},"475":{"tf":1},"491":{"tf":1},"497":{"tf":1},"689":{"tf":1},"705":{"tf":1},"711":{"tf":1},"917":{"tf":1},"962":{"tf":1}},"df":14}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"27":{"tf":1},"33":{"tf":1},"43":{"tf":1},"47":{"tf":1},"55":{"tf":1},"73":{"tf":1},"77":{"tf":1},"105":{"tf":1},"109":{"tf":1},"125":{"tf":1.4142135623730951},"144":{"tf":1},"150":{"tf":1},"157":{"tf":1},"181":{"tf":1},"184":{"tf":1},"259":{"tf":1},"265":{"tf":1},"275":{"tf":1},"279":{"tf":1},"287":{"tf":1},"304":{"tf":1},"308":{"tf":1},"336":{"tf":1},"340":{"tf":1},"360":{"tf":1.4142135623730951},"379":{"tf":1},"385":{"tf":1},"392":{"tf":1},"416":{"tf":1},"419":{"tf":1},"491":{"tf":1},"497":{"tf":1},"507":{"tf":1},"511":{"tf":1},"519":{"tf":1},"536":{"tf":1},"540":{"tf":1},"568":{"tf":1},"572":{"tf":1},"598":{"tf":1},"604":{"tf":1},"611":{"tf":1},"635":{"tf":1},"638":{"tf":1},"705":{"tf":1},"711":{"tf":1},"721":{"tf":1},"725":{"tf":1},"733":{"tf":1},"748":{"tf":1.4142135623730951},"749":{"tf":1},"775":{"tf":1},"779":{"tf":1},"789":{"tf":1},"808":{"tf":1},"814":{"tf":1},"821":{"tf":1},"845":{"tf":1},"848":{"tf":1}},"df":59}}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"101":{"tf":1},"332":{"tf":1},"564":{"tf":1},"771":{"tf":1}},"df":4}}}}}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1},"247":{"tf":1},"479":{"tf":1},"693":{"tf":1}},"df":4}}}},"o":{"docs":{},"df":0,"n":{"docs":{"21":{"tf":1},"189":{"tf":1},"229":{"tf":1},"424":{"tf":1},"461":{"tf":1},"643":{"tf":1},"675":{"tf":1},"853":{"tf":1},"883":{"tf":1}},"df":9}},"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"43":{"tf":1},"275":{"tf":1},"507":{"tf":1},"721":{"tf":1}},"df":4}}},"e":{"docs":{},"df":0,"l":{"docs":{"109":{"tf":1},"340":{"tf":1},"572":{"tf":1},"779":{"tf":1}},"df":4}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{"128":{"tf":1},"363":{"tf":1},"582":{"tf":1},"792":{"tf":1},"950":{"tf":1}},"df":5}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"116":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"579":{"tf":1.4142135623730951}},"df":3,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"215":{"tf":1},"447":{"tf":1},"661":{"tf":1}},"df":3}}}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"122":{"tf":1},"305":{"tf":1},"357":{"tf":1}},"df":3}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"128":{"tf":1},"363":{"tf":1},"582":{"tf":1},"792":{"tf":1}},"df":4}}}}},"e":{"docs":{},"df":0,"h":{"docs":{"181":{"tf":1},"354":{"tf":1},"356":{"tf":1},"416":{"tf":1},"635":{"tf":1},"845":{"tf":1},"945":{"tf":1}},"df":7}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"15":{"tf":1},"37":{"tf":1},"90":{"tf":1},"125":{"tf":1},"234":{"tf":1},"247":{"tf":1},"269":{"tf":1},"321":{"tf":1},"360":{"tf":1},"466":{"tf":1},"479":{"tf":1},"501":{"tf":1},"553":{"tf":1},"680":{"tf":1},"693":{"tf":1},"715":{"tf":1},"885":{"tf":1}},"df":17,"t":{"docs":{"134":{"tf":1},"177":{"tf":1},"178":{"tf":1},"369":{"tf":1},"412":{"tf":1},"413":{"tf":1},"588":{"tf":1},"631":{"tf":1},"632":{"tf":1},"798":{"tf":1},"841":{"tf":1},"842":{"tf":1}},"df":12}}}},"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"27":{"tf":1},"81":{"tf":1},"134":{"tf":1},"195":{"tf":1},"204":{"tf":1},"208":{"tf":1.4142135623730951},"212":{"tf":1},"229":{"tf":1.4142135623730951},"231":{"tf":1.4142135623730951},"259":{"tf":1},"312":{"tf":1},"356":{"tf":1},"369":{"tf":1},"430":{"tf":1},"439":{"tf":1},"441":{"tf":1.4142135623730951},"444":{"tf":1},"461":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"491":{"tf":1},"544":{"tf":1},"588":{"tf":1},"649":{"tf":1},"658":{"tf":1},"675":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"705":{"tf":1},"718":{"tf":1},"758":{"tf":1},"798":{"tf":1},"859":{"tf":1},"883":{"tf":2}},"df":32}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{"90":{"tf":1},"321":{"tf":1},"553":{"tf":1}},"df":3}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"125":{"tf":1},"296":{"tf":1},"360":{"tf":1}},"df":3}}},"k":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"158":{"tf":1},"393":{"tf":1},"612":{"tf":1},"822":{"tf":1}},"df":4}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":4}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"21":{"tf":1},"125":{"tf":1},"192":{"tf":1},"203":{"tf":1},"205":{"tf":1},"208":{"tf":1},"209":{"tf":1},"212":{"tf":1},"213":{"tf":2.23606797749979},"214":{"tf":1.7320508075688772},"215":{"tf":1.4142135623730951},"229":{"tf":2},"232":{"tf":1},"360":{"tf":1},"427":{"tf":1},"438":{"tf":1},"440":{"tf":1},"441":{"tf":1},"444":{"tf":1},"445":{"tf":2.23606797749979},"446":{"tf":1.7320508075688772},"447":{"tf":1.4142135623730951},"461":{"tf":2},"464":{"tf":1},"485":{"tf":1},"646":{"tf":1},"658":{"tf":1},"659":{"tf":2.23606797749979},"660":{"tf":1.7320508075688772},"661":{"tf":1.4142135623730951},"675":{"tf":2},"678":{"tf":1},"856":{"tf":1},"869":{"tf":1.7320508075688772},"883":{"tf":2.23606797749979}},"df":35}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1.4142135623730951},"28":{"tf":1},"43":{"tf":1},"119":{"tf":1},"122":{"tf":1.4142135623730951},"155":{"tf":1},"176":{"tf":1},"182":{"tf":1},"189":{"tf":1},"229":{"tf":1},"259":{"tf":1.4142135623730951},"260":{"tf":1},"275":{"tf":1},"354":{"tf":1},"357":{"tf":1.4142135623730951},"390":{"tf":1},"411":{"tf":1},"417":{"tf":1},"424":{"tf":1},"461":{"tf":1},"491":{"tf":1.4142135623730951},"492":{"tf":1},"507":{"tf":1},"609":{"tf":1},"630":{"tf":1},"636":{"tf":1},"643":{"tf":1},"675":{"tf":1},"705":{"tf":1.4142135623730951},"706":{"tf":1},"718":{"tf":1},"721":{"tf":1},"782":{"tf":1},"819":{"tf":1},"840":{"tf":1},"846":{"tf":1},"853":{"tf":1},"883":{"tf":1}},"df":38}}}}},"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"46":{"tf":1},"278":{"tf":1},"510":{"tf":1},"724":{"tf":1}},"df":4}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"212":{"tf":1},"444":{"tf":1},"658":{"tf":1}},"df":3}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"73":{"tf":1},"115":{"tf":1},"304":{"tf":1},"346":{"tf":1},"350":{"tf":1},"536":{"tf":1},"578":{"tf":1},"751":{"tf":1},"785":{"tf":1}},"df":9}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"73":{"tf":1},"178":{"tf":1},"304":{"tf":1},"413":{"tf":1},"536":{"tf":1},"632":{"tf":1},"748":{"tf":1},"749":{"tf":1},"842":{"tf":1}},"df":9}}}}},"b":{"docs":{"187":{"tf":1},"422":{"tf":1},"641":{"tf":1},"786":{"tf":1},"851":{"tf":1},"953":{"tf":1}},"df":6,"o":{"docs":{},"df":0,"t":{"docs":{"350":{"tf":1}},"df":1}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"896":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"192":{"tf":1.4142135623730951},"213":{"tf":1},"427":{"tf":1.4142135623730951},"445":{"tf":1},"646":{"tf":1.4142135623730951},"659":{"tf":1},"856":{"tf":1.4142135623730951},"917":{"tf":1.7320508075688772},"920":{"tf":1.4142135623730951}},"df":9}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"878":{"tf":1},"880":{"tf":1}},"df":2}}}}}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"909":{"tf":1},"923":{"tf":1}},"df":2}}}}},"a":{"docs":{},"df":0,"b":{"docs":{"125":{"tf":1},"360":{"tf":1},"527":{"tf":1}},"df":3}},"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"351":{"tf":1}},"df":1}}}}},"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"109":{"tf":1},"340":{"tf":1},"572":{"tf":1},"779":{"tf":1},"919":{"tf":1}},"df":5,"s":{"docs":{},"df":0,"z":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"26":{"tf":1},"140":{"tf":1},"258":{"tf":1},"375":{"tf":1},"490":{"tf":1},"594":{"tf":1},"704":{"tf":1},"804":{"tf":1}},"df":8}}}}}}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"26":{"tf":1},"177":{"tf":1},"178":{"tf":1.4142135623730951},"182":{"tf":1},"258":{"tf":1},"354":{"tf":1},"412":{"tf":1},"413":{"tf":1.4142135623730951},"417":{"tf":1},"490":{"tf":1},"631":{"tf":1},"632":{"tf":1.4142135623730951},"636":{"tf":1},"704":{"tf":1},"841":{"tf":1},"842":{"tf":1.4142135623730951},"846":{"tf":1},"938":{"tf":1}},"df":18}}}},"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"192":{"tf":1},"275":{"tf":1},"427":{"tf":1},"507":{"tf":1},"646":{"tf":1},"721":{"tf":1},"856":{"tf":1}},"df":8}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{"101":{"tf":1},"332":{"tf":1},"564":{"tf":1},"771":{"tf":1},"895":{"tf":1},"917":{"tf":1.7320508075688772},"948":{"tf":1}},"df":7,"t":{"docs":{"909":{"tf":1}},"df":1}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2},"n":{"docs":{},"df":0,"g":{"docs":{"128":{"tf":1},"363":{"tf":1},"582":{"tf":1},"792":{"tf":1}},"df":4},"d":{"docs":{"156":{"tf":1},"354":{"tf":1},"391":{"tf":1},"610":{"tf":1},"820":{"tf":1}},"df":5}},"l":{"docs":{},"df":0,"t":{"docs":{"150":{"tf":1},"176":{"tf":1},"181":{"tf":1},"385":{"tf":1},"411":{"tf":1},"416":{"tf":1},"604":{"tf":1},"630":{"tf":1},"635":{"tf":1},"814":{"tf":1},"840":{"tf":1},"845":{"tf":1}},"df":12}}}},"/":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{"134":{"tf":1.4142135623730951},"369":{"tf":1.4142135623730951},"588":{"tf":1.4142135623730951},"798":{"tf":1.4142135623730951}},"df":4}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"878":{"tf":1},"880":{"tf":1}},"df":2}}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"917":{"tf":1.7320508075688772}},"df":1}}}}},"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"3":{"tf":1},"38":{"tf":1},"128":{"tf":1},"177":{"tf":1},"195":{"tf":1.4142135623730951},"270":{"tf":1},"363":{"tf":1},"412":{"tf":1},"430":{"tf":1.4142135623730951},"502":{"tf":1},"582":{"tf":1},"631":{"tf":1},"649":{"tf":1.4142135623730951},"716":{"tf":1},"792":{"tf":1},"841":{"tf":1},"859":{"tf":1.4142135623730951},"914":{"tf":1},"918":{"tf":1},"960":{"tf":1}},"df":20}}}}}},"b":{"docs":{"3":{"tf":1},"72":{"tf":1},"73":{"tf":1},"77":{"tf":1},"119":{"tf":1.7320508075688772},"122":{"tf":1},"125":{"tf":1},"192":{"tf":1},"226":{"tf":1},"295":{"tf":1},"303":{"tf":1},"304":{"tf":1},"308":{"tf":1},"350":{"tf":1},"354":{"tf":1.7320508075688772},"357":{"tf":1},"360":{"tf":1},"427":{"tf":1},"458":{"tf":1},"535":{"tf":1},"536":{"tf":1},"540":{"tf":1},"646":{"tf":1},"672":{"tf":1},"751":{"tf":1},"782":{"tf":1.4142135623730951},"856":{"tf":1},"917":{"tf":1}},"df":28,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"125":{"tf":1},"360":{"tf":1},"789":{"tf":1}},"df":4}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2}}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"27":{"tf":1},"119":{"tf":1},"259":{"tf":1},"350":{"tf":1},"491":{"tf":1},"705":{"tf":1}},"df":7}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"119":{"tf":1},"122":{"tf":1.7320508075688772},"134":{"tf":1},"183":{"tf":1},"295":{"tf":1},"350":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":2},"369":{"tf":1},"418":{"tf":1},"588":{"tf":1},"637":{"tf":1},"798":{"tf":1},"847":{"tf":1}},"df":14}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"83":{"tf":1},"87":{"tf":1},"314":{"tf":1},"318":{"tf":1},"546":{"tf":1},"550":{"tf":1},"699":{"tf":1},"761":{"tf":1},"924":{"tf":1}},"df":9}}}}}},"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{},"df":0,"t":{"docs":{"128":{"tf":1},"363":{"tf":1},"582":{"tf":1},"792":{"tf":1}},"df":4}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"50":{"tf":1},"282":{"tf":1},"514":{"tf":1},"728":{"tf":1}},"df":4}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"895":{"tf":1},"909":{"tf":1}},"df":2}}}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1},"67":{"tf":1},"74":{"tf":1.4142135623730951},"305":{"tf":1.4142135623730951},"351":{"tf":1},"354":{"tf":1},"530":{"tf":1},"537":{"tf":1.4142135623730951},"752":{"tf":1.4142135623730951}},"df":9}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{"16":{"tf":1},"43":{"tf":1},"68":{"tf":1},"97":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"119":{"tf":1},"125":{"tf":1},"137":{"tf":1},"143":{"tf":1},"149":{"tf":1},"177":{"tf":1},"181":{"tf":1},"187":{"tf":1},"192":{"tf":1},"240":{"tf":1},"248":{"tf":1},"253":{"tf":1},"275":{"tf":1},"299":{"tf":1},"328":{"tf":1.4142135623730951},"340":{"tf":1.4142135623730951},"350":{"tf":1},"354":{"tf":1},"360":{"tf":1},"372":{"tf":1},"378":{"tf":1},"384":{"tf":1},"412":{"tf":1},"416":{"tf":1},"422":{"tf":1},"427":{"tf":1},"480":{"tf":1},"507":{"tf":1},"531":{"tf":1},"560":{"tf":1.4142135623730951},"572":{"tf":1.4142135623730951},"591":{"tf":1},"597":{"tf":1},"603":{"tf":1},"631":{"tf":1},"635":{"tf":1},"641":{"tf":1},"646":{"tf":1},"694":{"tf":1},"721":{"tf":1},"767":{"tf":1.4142135623730951},"779":{"tf":1.4142135623730951},"801":{"tf":1},"807":{"tf":1},"813":{"tf":1},"841":{"tf":1},"845":{"tf":1},"851":{"tf":1},"856":{"tf":1},"888":{"tf":1},"892":{"tf":1},"909":{"tf":1},"915":{"tf":1},"926":{"tf":1},"936":{"tf":1},"938":{"tf":1},"945":{"tf":1},"965":{"tf":1}},"df":63}}}},"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"21":{"tf":1},"90":{"tf":1},"253":{"tf":1},"321":{"tf":1},"485":{"tf":1},"553":{"tf":1},"699":{"tf":1}},"df":7}}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"229":{"tf":1},"461":{"tf":1},"675":{"tf":1},"883":{"tf":1}},"df":4}}}}}},"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"485":{"tf":1}},"df":2}}}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"39":{"tf":1},"271":{"tf":1},"503":{"tf":1},"717":{"tf":1}},"df":4}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"4":{"tf":1}},"df":1}}}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"15":{"tf":1},"16":{"tf":1},"20":{"tf":1},"21":{"tf":1},"22":{"tf":1},"26":{"tf":1},"27":{"tf":1},"28":{"tf":1},"32":{"tf":1},"33":{"tf":1},"34":{"tf":1},"38":{"tf":1},"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"47":{"tf":1},"51":{"tf":1},"55":{"tf":1},"56":{"tf":1},"63":{"tf":1},"64":{"tf":1},"65":{"tf":1},"66":{"tf":1},"67":{"tf":1},"68":{"tf":1},"72":{"tf":1},"73":{"tf":1},"74":{"tf":1},"78":{"tf":1},"82":{"tf":1},"83":{"tf":1},"87":{"tf":1},"91":{"tf":1},"98":{"tf":1},"102":{"tf":1},"103":{"tf":1},"104":{"tf":1},"105":{"tf":1},"106":{"tf":1},"116":{"tf":1},"120":{"tf":1},"121":{"tf":1},"122":{"tf":1},"132":{"tf":1},"133":{"tf":1},"134":{"tf":1},"138":{"tf":1},"139":{"tf":1},"140":{"tf":1},"144":{"tf":1},"145":{"tf":1},"146":{"tf":1},"150":{"tf":1},"151":{"tf":1},"152":{"tf":1},"155":{"tf":1},"156":{"tf":1},"157":{"tf":1},"168":{"tf":1},"169":{"tf":1},"170":{"tf":1},"172":{"tf":1},"176":{"tf":1},"177":{"tf":1},"178":{"tf":1},"182":{"tf":1},"183":{"tf":1},"187":{"tf":1},"188":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"199":{"tf":1},"224":{"tf":1},"225":{"tf":1},"226":{"tf":1},"230":{"tf":1},"231":{"tf":1},"232":{"tf":1},"233":{"tf":1},"234":{"tf":1},"247":{"tf":1},"248":{"tf":1},"252":{"tf":1},"253":{"tf":1},"254":{"tf":1},"258":{"tf":1},"259":{"tf":1},"260":{"tf":1},"264":{"tf":1},"265":{"tf":1},"266":{"tf":1},"270":{"tf":1},"271":{"tf":1.4142135623730951},"272":{"tf":1.4142135623730951},"279":{"tf":1},"283":{"tf":1},"287":{"tf":1},"288":{"tf":1},"295":{"tf":1},"296":{"tf":1},"297":{"tf":1},"298":{"tf":1},"299":{"tf":1},"303":{"tf":1},"304":{"tf":1},"305":{"tf":1},"309":{"tf":1},"313":{"tf":1},"314":{"tf":1},"318":{"tf":1},"322":{"tf":1},"329":{"tf":1},"333":{"tf":1},"334":{"tf":1},"335":{"tf":1},"336":{"tf":1},"337":{"tf":1},"347":{"tf":1},"351":{"tf":1},"355":{"tf":1},"356":{"tf":1},"357":{"tf":1},"367":{"tf":1},"368":{"tf":1},"369":{"tf":1},"373":{"tf":1},"374":{"tf":1},"375":{"tf":1},"379":{"tf":1},"380":{"tf":1},"381":{"tf":1},"385":{"tf":1},"386":{"tf":1},"387":{"tf":1},"390":{"tf":1},"391":{"tf":1},"392":{"tf":1},"403":{"tf":1},"404":{"tf":1},"405":{"tf":1},"407":{"tf":1},"411":{"tf":1},"412":{"tf":1},"413":{"tf":1},"417":{"tf":1},"418":{"tf":1},"422":{"tf":1},"423":{"tf":1.4142135623730951},"424":{"tf":1.4142135623730951},"434":{"tf":1},"456":{"tf":1},"457":{"tf":1},"458":{"tf":1},"462":{"tf":1},"463":{"tf":1},"464":{"tf":1},"465":{"tf":1},"466":{"tf":1},"479":{"tf":1},"480":{"tf":1},"484":{"tf":1},"485":{"tf":1},"486":{"tf":1},"490":{"tf":1},"491":{"tf":1},"492":{"tf":1},"496":{"tf":1},"497":{"tf":1},"498":{"tf":1},"502":{"tf":1},"503":{"tf":1.4142135623730951},"504":{"tf":1.4142135623730951},"511":{"tf":1},"515":{"tf":1},"519":{"tf":1},"520":{"tf":1},"527":{"tf":1},"528":{"tf":1},"529":{"tf":1},"530":{"tf":1},"531":{"tf":1},"535":{"tf":1},"536":{"tf":1},"537":{"tf":1},"541":{"tf":1},"545":{"tf":1},"546":{"tf":1},"550":{"tf":1},"554":{"tf":1},"561":{"tf":1},"565":{"tf":1},"566":{"tf":1},"567":{"tf":1},"568":{"tf":1},"569":{"tf":1},"579":{"tf":1},"586":{"tf":1},"587":{"tf":1},"588":{"tf":1},"592":{"tf":1},"593":{"tf":1},"594":{"tf":1},"598":{"tf":1},"599":{"tf":1},"600":{"tf":1},"604":{"tf":1},"605":{"tf":1},"606":{"tf":1},"609":{"tf":1},"610":{"tf":1},"611":{"tf":1},"622":{"tf":1},"623":{"tf":1},"624":{"tf":1},"626":{"tf":1},"630":{"tf":1},"631":{"tf":1},"632":{"tf":1},"636":{"tf":1},"637":{"tf":1},"641":{"tf":1},"642":{"tf":1.4142135623730951},"643":{"tf":1.4142135623730951},"653":{"tf":1},"670":{"tf":1},"671":{"tf":1},"672":{"tf":1},"676":{"tf":1},"677":{"tf":1},"678":{"tf":1},"679":{"tf":1},"680":{"tf":1},"693":{"tf":1},"694":{"tf":1},"698":{"tf":1},"699":{"tf":1},"700":{"tf":1},"704":{"tf":1},"705":{"tf":1},"706":{"tf":1},"710":{"tf":1},"711":{"tf":1},"712":{"tf":1},"716":{"tf":1},"717":{"tf":1.4142135623730951},"718":{"tf":1.4142135623730951},"725":{"tf":1},"729":{"tf":1},"733":{"tf":1},"734":{"tf":1},"741":{"tf":1},"742":{"tf":1},"743":{"tf":1},"744":{"tf":1},"748":{"tf":1},"749":{"tf":1},"750":{"tf":1},"751":{"tf":1},"752":{"tf":1},"759":{"tf":1},"760":{"tf":1},"761":{"tf":1},"768":{"tf":1},"772":{"tf":1},"773":{"tf":1},"774":{"tf":1},"775":{"tf":1},"776":{"tf":1},"786":{"tf":1},"796":{"tf":1},"797":{"tf":1},"798":{"tf":1},"802":{"tf":1},"803":{"tf":1},"804":{"tf":1},"808":{"tf":1},"809":{"tf":1},"810":{"tf":1},"814":{"tf":1},"815":{"tf":1},"816":{"tf":1},"819":{"tf":1},"820":{"tf":1},"821":{"tf":1},"832":{"tf":1},"833":{"tf":1},"834":{"tf":1},"836":{"tf":1},"840":{"tf":1},"841":{"tf":1},"842":{"tf":1},"846":{"tf":1},"847":{"tf":1},"851":{"tf":1},"852":{"tf":1.4142135623730951},"853":{"tf":1.4142135623730951},"863":{"tf":1},"878":{"tf":1},"879":{"tf":1},"880":{"tf":1},"884":{"tf":1},"885":{"tf":1},"894":{"tf":1},"895":{"tf":1},"897":{"tf":1},"898":{"tf":1},"899":{"tf":1},"900":{"tf":1},"901":{"tf":1},"902":{"tf":1},"903":{"tf":1},"909":{"tf":1},"911":{"tf":1},"912":{"tf":1},"913":{"tf":1},"914":{"tf":1},"915":{"tf":1},"916":{"tf":1},"918":{"tf":1},"919":{"tf":1},"920":{"tf":1},"923":{"tf":1},"924":{"tf":1},"925":{"tf":1},"927":{"tf":1},"928":{"tf":1},"929":{"tf":1},"936":{"tf":1},"938":{"tf":1},"939":{"tf":1},"942":{"tf":1},"943":{"tf":1},"946":{"tf":1},"948":{"tf":1},"949":{"tf":1},"950":{"tf":1},"951":{"tf":1},"952":{"tf":1},"954":{"tf":1},"955":{"tf":1},"957":{"tf":1},"958":{"tf":1},"959":{"tf":1},"961":{"tf":1},"962":{"tf":1},"963":{"tf":1},"964":{"tf":1}},"df":345}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"229":{"tf":1},"461":{"tf":1},"675":{"tf":1},"883":{"tf":1},"917":{"tf":2}},"df":5}}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"20":{"tf":1.7320508075688772},"51":{"tf":1},"202":{"tf":1},"207":{"tf":1},"210":{"tf":1.4142135623730951},"252":{"tf":1.4142135623730951},"283":{"tf":1},"437":{"tf":1},"442":{"tf":1.4142135623730951},"458":{"tf":1},"515":{"tf":1},"672":{"tf":1},"729":{"tf":1},"895":{"tf":1},"907":{"tf":2},"909":{"tf":3},"910":{"tf":1},"911":{"tf":2.449489742783178},"912":{"tf":1.4142135623730951},"913":{"tf":2},"914":{"tf":2.6457513110645907},"915":{"tf":2.8284271247461903},"917":{"tf":3.605551275463989},"918":{"tf":3},"919":{"tf":2.449489742783178},"920":{"tf":2},"923":{"tf":1.7320508075688772},"924":{"tf":1},"925":{"tf":1},"927":{"tf":1.4142135623730951},"928":{"tf":1},"929":{"tf":1},"930":{"tf":1},"931":{"tf":3.3166247903554},"937":{"tf":1},"938":{"tf":1}},"df":36}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"g":{"docs":{"38":{"tf":1},"270":{"tf":1},"502":{"tf":1},"716":{"tf":1}},"df":4}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"43":{"tf":1},"77":{"tf":1},"275":{"tf":1},"308":{"tf":1},"507":{"tf":1},"540":{"tf":1},"721":{"tf":1}},"df":7}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"39":{"tf":1},"271":{"tf":1},"503":{"tf":1},"717":{"tf":1}},"df":4}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{"74":{"tf":1},"122":{"tf":1},"305":{"tf":1},"357":{"tf":1},"537":{"tf":1},"752":{"tf":1},"892":{"tf":1}},"df":7,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"220":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"452":{"tf":1.4142135623730951},"464":{"tf":1.4142135623730951},"666":{"tf":1.4142135623730951},"678":{"tf":1.4142135623730951},"874":{"tf":1.4142135623730951},"883":{"tf":1.4142135623730951},"927":{"tf":1}},"df":9}}}}}}}}}},"z":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"104":{"tf":1},"335":{"tf":1},"567":{"tf":1},"743":{"tf":1},"771":{"tf":1},"774":{"tf":1}},"df":6}}}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"350":{"tf":1}},"df":1}}}}}}}}},"l":{"docs":{},"df":0,"l":{"docs":{"237":{"tf":1},"240":{"tf":1},"469":{"tf":1},"683":{"tf":1}},"df":4,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"43":{"tf":1},"56":{"tf":1},"205":{"tf":1},"206":{"tf":1},"275":{"tf":1},"288":{"tf":1},"354":{"tf":1},"440":{"tf":1},"507":{"tf":1},"520":{"tf":1},"721":{"tf":1},"734":{"tf":1}},"df":13}}}}}},"z":{"docs":{},"df":0,"u":{"docs":{"94":{"tf":1},"325":{"tf":1},"557":{"tf":1},"764":{"tf":1}},"df":4}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"157":{"tf":1},"161":{"tf":1},"182":{"tf":1},"231":{"tf":1},"392":{"tf":1},"396":{"tf":1},"417":{"tf":1},"463":{"tf":1},"611":{"tf":1},"615":{"tf":1},"636":{"tf":1},"677":{"tf":1},"786":{"tf":1},"821":{"tf":1},"825":{"tf":1},"846":{"tf":1},"883":{"tf":1},"888":{"tf":1},"909":{"tf":1},"913":{"tf":1},"919":{"tf":1},"926":{"tf":1},"938":{"tf":1},"948":{"tf":1.4142135623730951},"950":{"tf":1},"956":{"tf":1}},"df":26}}}},"t":{"docs":{"4":{"tf":1.4142135623730951},"86":{"tf":1},"90":{"tf":1},"105":{"tf":1},"109":{"tf":1},"317":{"tf":1},"321":{"tf":1},"336":{"tf":1},"340":{"tf":1},"549":{"tf":1},"553":{"tf":1},"568":{"tf":1},"572":{"tf":1},"775":{"tf":1},"779":{"tf":1}},"df":15,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"34":{"tf":1},"134":{"tf":1},"226":{"tf":1},"266":{"tf":1},"369":{"tf":1},"498":{"tf":1},"588":{"tf":1},"699":{"tf":1},"712":{"tf":1},"742":{"tf":1},"786":{"tf":1},"798":{"tf":1}},"df":12}}}}}}},"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"f":{"1":{"2":{"docs":{"128":{"tf":1},"161":{"tf":1},"363":{"tf":1},"396":{"tf":1},"582":{"tf":1},"615":{"tf":1},"792":{"tf":1},"825":{"tf":1}},"df":8},"docs":{},"df":0},"docs":{},"df":0}}}}},"g":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{"354":{"tf":1}},"df":1,"u":{"docs":{"168":{"tf":1},"403":{"tf":1},"622":{"tf":1},"832":{"tf":1}},"df":4}}}}}}}}},"p":{"docs":{},"df":0,"p":{"docs":{"63":{"tf":1},"698":{"tf":1},"699":{"tf":1},"741":{"tf":1.4142135623730951},"742":{"tf":1.4142135623730951},"743":{"tf":1.4142135623730951},"744":{"tf":1},"786":{"tf":1},"867":{"tf":1.4142135623730951},"878":{"tf":1}},"df":10,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"k":{"docs":{"20":{"tf":1},"21":{"tf":1},"62":{"tf":1},"94":{"tf":1},"119":{"tf":1},"140":{"tf":1},"177":{"tf":1},"192":{"tf":1},"224":{"tf":1},"226":{"tf":1},"237":{"tf":1},"294":{"tf":1},"325":{"tf":1},"350":{"tf":1},"375":{"tf":1},"399":{"tf":1},"412":{"tf":1},"427":{"tf":1},"456":{"tf":1},"458":{"tf":1},"469":{"tf":1},"484":{"tf":1},"485":{"tf":1},"526":{"tf":1},"557":{"tf":1},"594":{"tf":1},"618":{"tf":1},"631":{"tf":1},"646":{"tf":1},"670":{"tf":1},"672":{"tf":1},"683":{"tf":1},"698":{"tf":1},"764":{"tf":1},"804":{"tf":1},"828":{"tf":1},"841":{"tf":1},"856":{"tf":1},"909":{"tf":1},"935":{"tf":1.4142135623730951}},"df":40,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"21":{"tf":1},"618":{"tf":1},"828":{"tf":1},"909":{"tf":1}},"df":4,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"867":{"tf":1}},"df":1}}}}}}},"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"867":{"tf":1}},"df":1}}}}}}},"k":{"docs":{"742":{"tf":1.4142135623730951}},"df":1}},"r":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"64":{"tf":1},"125":{"tf":1.4142135623730951},"171":{"tf":1},"177":{"tf":1},"182":{"tf":1},"195":{"tf":1.4142135623730951},"275":{"tf":1},"360":{"tf":1.4142135623730951},"406":{"tf":1},"412":{"tf":1},"417":{"tf":1},"430":{"tf":1.4142135623730951},"458":{"tf":1},"507":{"tf":1},"625":{"tf":1},"631":{"tf":1},"636":{"tf":1},"649":{"tf":1.4142135623730951},"672":{"tf":1},"721":{"tf":1},"835":{"tf":1},"841":{"tf":1},"846":{"tf":1},"859":{"tf":1.4142135623730951},"935":{"tf":1},"956":{"tf":1}},"df":27,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{"8":{"tf":1},"240":{"tf":1},"472":{"tf":1},"686":{"tf":1}},"df":4}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{"97":{"tf":1.4142135623730951},"328":{"tf":1.4142135623730951},"560":{"tf":1.4142135623730951},"767":{"tf":1.4142135623730951}},"df":4}}}}}}}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"718":{"tf":1}},"df":1}}}}}}},"e":{"docs":{},"df":0,"t":{"docs":{"760":{"tf":1},"761":{"tf":1}},"df":2}}}}}},"t":{"docs":{"51":{"tf":1},"55":{"tf":1},"62":{"tf":1},"63":{"tf":1},"66":{"tf":1},"131":{"tf":1},"161":{"tf":1},"177":{"tf":1},"207":{"tf":1},"210":{"tf":1},"283":{"tf":1},"287":{"tf":1},"294":{"tf":1},"295":{"tf":1},"354":{"tf":1},"366":{"tf":1},"396":{"tf":1},"412":{"tf":1},"442":{"tf":1},"515":{"tf":1},"519":{"tf":1},"526":{"tf":1},"527":{"tf":1},"529":{"tf":1},"585":{"tf":1},"615":{"tf":1},"631":{"tf":1},"729":{"tf":1},"733":{"tf":1},"741":{"tf":1},"795":{"tf":1},"825":{"tf":1},"841":{"tf":1},"895":{"tf":1}},"df":34,"i":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"917":{"tf":1.4142135623730951}},"df":1}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"i":{"docs":{"54":{"tf":1},"286":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"z":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":4}}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"203":{"tf":1},"209":{"tf":1},"438":{"tf":1}},"df":3}}}}}}},"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"21":{"tf":1},"125":{"tf":1},"137":{"tf":1},"138":{"tf":1},"140":{"tf":1},"143":{"tf":1},"144":{"tf":1},"253":{"tf":1},"360":{"tf":1},"372":{"tf":1},"373":{"tf":1},"375":{"tf":1},"378":{"tf":1},"379":{"tf":1},"485":{"tf":1},"591":{"tf":1},"592":{"tf":1},"594":{"tf":1},"597":{"tf":1},"598":{"tf":1},"699":{"tf":1},"801":{"tf":1},"802":{"tf":1},"804":{"tf":1},"807":{"tf":1},"808":{"tf":1}},"df":26,"i":{"docs":{"15":{"tf":1},"115":{"tf":1},"116":{"tf":1},"125":{"tf":1},"128":{"tf":1},"149":{"tf":2},"161":{"tf":1.4142135623730951},"229":{"tf":1},"247":{"tf":1},"346":{"tf":1},"347":{"tf":1},"360":{"tf":1},"363":{"tf":1},"384":{"tf":2},"396":{"tf":1.4142135623730951},"461":{"tf":1},"479":{"tf":1},"578":{"tf":1},"579":{"tf":1},"582":{"tf":1},"603":{"tf":2},"615":{"tf":1.4142135623730951},"675":{"tf":1},"693":{"tf":1},"785":{"tf":1},"792":{"tf":1},"813":{"tf":2},"825":{"tf":1.4142135623730951},"883":{"tf":1},"928":{"tf":1}},"df":30,"e":{"docs":{},"df":0,"r":{"docs":{"134":{"tf":1},"369":{"tf":1},"588":{"tf":1},"798":{"tf":1}},"df":4,"t":{"docs":{"125":{"tf":1},"131":{"tf":1.4142135623730951},"161":{"tf":1},"360":{"tf":1},"366":{"tf":1.4142135623730951},"396":{"tf":1},"585":{"tf":1.4142135623730951},"615":{"tf":1},"795":{"tf":1.4142135623730951},"825":{"tf":1},"867":{"tf":1.7320508075688772},"928":{"tf":1}},"df":12}}}}},"o":{"docs":{},"df":0,"n":{"docs":{"27":{"tf":1},"37":{"tf":1},"59":{"tf":1},"71":{"tf":1.4142135623730951},"72":{"tf":1},"74":{"tf":1},"81":{"tf":1},"101":{"tf":1},"102":{"tf":1},"119":{"tf":1},"143":{"tf":1},"176":{"tf":1},"203":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"210":{"tf":1},"229":{"tf":1},"231":{"tf":1},"259":{"tf":1},"269":{"tf":1},"291":{"tf":1},"302":{"tf":1.4142135623730951},"303":{"tf":1},"305":{"tf":1},"312":{"tf":1},"332":{"tf":1},"333":{"tf":1},"351":{"tf":1},"378":{"tf":1},"411":{"tf":1},"438":{"tf":1.4142135623730951},"442":{"tf":1},"461":{"tf":1},"463":{"tf":1},"491":{"tf":1},"501":{"tf":1},"523":{"tf":1},"534":{"tf":1.4142135623730951},"535":{"tf":1.7320508075688772},"537":{"tf":1},"544":{"tf":1},"564":{"tf":1},"565":{"tf":1},"597":{"tf":1},"630":{"tf":1},"675":{"tf":1},"677":{"tf":1},"705":{"tf":1},"715":{"tf":1},"737":{"tf":1},"747":{"tf":1.4142135623730951},"749":{"tf":1.4142135623730951},"750":{"tf":1.7320508075688772},"752":{"tf":1},"758":{"tf":1},"771":{"tf":1},"772":{"tf":1},"807":{"tf":1},"840":{"tf":1},"883":{"tf":1.4142135623730951},"914":{"tf":1},"923":{"tf":1},"935":{"tf":1},"938":{"tf":1},"940":{"tf":1},"941":{"tf":1.4142135623730951}},"df":65,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1},"259":{"tf":1},"491":{"tf":1},"705":{"tf":1}},"df":4}}}}}}},"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"27":{"tf":1},"125":{"tf":1},"134":{"tf":1},"143":{"tf":1},"158":{"tf":1},"176":{"tf":1},"182":{"tf":1},"208":{"tf":1.4142135623730951},"210":{"tf":1},"214":{"tf":1.4142135623730951},"259":{"tf":1},"360":{"tf":1},"369":{"tf":1},"378":{"tf":1},"393":{"tf":1},"411":{"tf":1},"417":{"tf":1},"441":{"tf":1.4142135623730951},"442":{"tf":1},"446":{"tf":1.4142135623730951},"491":{"tf":1},"588":{"tf":1},"597":{"tf":1},"612":{"tf":1},"630":{"tf":1},"636":{"tf":1},"660":{"tf":1.4142135623730951},"705":{"tf":1},"798":{"tf":1},"807":{"tf":1},"822":{"tf":1},"840":{"tf":1},"846":{"tf":1},"867":{"tf":1},"869":{"tf":1.4142135623730951},"897":{"tf":1},"938":{"tf":1},"946":{"tf":1},"960":{"tf":1}},"df":39,"l":{"docs":{"21":{"tf":1},"128":{"tf":1.7320508075688772},"134":{"tf":1},"177":{"tf":1},"182":{"tf":1},"184":{"tf":2},"212":{"tf":1},"214":{"tf":1},"253":{"tf":1},"363":{"tf":1.7320508075688772},"369":{"tf":1},"412":{"tf":1},"417":{"tf":1},"419":{"tf":2},"444":{"tf":1},"446":{"tf":1},"485":{"tf":1},"582":{"tf":1.7320508075688772},"588":{"tf":1},"631":{"tf":1},"636":{"tf":1},"638":{"tf":2},"658":{"tf":1},"660":{"tf":1},"699":{"tf":1},"792":{"tf":1.7320508075688772},"798":{"tf":1},"841":{"tf":1},"846":{"tf":1},"848":{"tf":2},"869":{"tf":1},"940":{"tf":1},"950":{"tf":1},"953":{"tf":1.4142135623730951},"954":{"tf":1},"955":{"tf":1},"960":{"tf":1},"961":{"tf":1},"963":{"tf":1}},"df":39}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{"155":{"tf":1},"156":{"tf":1},"390":{"tf":1},"391":{"tf":1},"609":{"tf":1},"610":{"tf":1},"819":{"tf":1},"820":{"tf":1},"941":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"r":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4,"t":{"docs":{"156":{"tf":1},"391":{"tf":1},"610":{"tf":1},"820":{"tf":1}},"df":4}}}}}}}}}}},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"122":{"tf":4.242640687119285},"156":{"tf":1},"170":{"tf":1},"171":{"tf":1.4142135623730951},"187":{"tf":1},"188":{"tf":1},"189":{"tf":1},"195":{"tf":1},"225":{"tf":1},"231":{"tf":2},"232":{"tf":1.7320508075688772},"275":{"tf":1},"357":{"tf":4.358898943540674},"391":{"tf":1},"405":{"tf":1},"406":{"tf":1.4142135623730951},"422":{"tf":1},"423":{"tf":1},"424":{"tf":1},"430":{"tf":1},"457":{"tf":1},"463":{"tf":2},"464":{"tf":1.7320508075688772},"507":{"tf":1},"610":{"tf":1},"624":{"tf":1},"625":{"tf":1.4142135623730951},"641":{"tf":1},"642":{"tf":1},"643":{"tf":1},"649":{"tf":1},"671":{"tf":1},"677":{"tf":2},"678":{"tf":1.7320508075688772},"721":{"tf":1},"820":{"tf":1},"834":{"tf":1},"835":{"tf":1.4142135623730951},"851":{"tf":1},"852":{"tf":1},"853":{"tf":1},"859":{"tf":1},"879":{"tf":1},"883":{"tf":2.6457513110645907},"901":{"tf":1},"918":{"tf":1},"948":{"tf":1.7320508075688772},"950":{"tf":1},"951":{"tf":1},"957":{"tf":1}},"df":51,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}}}}}},"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"909":{"tf":1}},"df":1}}}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"55":{"tf":1},"287":{"tf":1},"297":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":5}}}}}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"62":{"tf":1},"237":{"tf":1.4142135623730951},"294":{"tf":1},"469":{"tf":1.4142135623730951},"526":{"tf":1},"683":{"tf":1.4142135623730951},"740":{"tf":1}},"df":7,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"62":{"tf":1.4142135623730951},"65":{"tf":1.4142135623730951},"81":{"tf":1},"237":{"tf":1},"253":{"tf":1},"294":{"tf":1.4142135623730951},"296":{"tf":1.7320508075688772},"312":{"tf":1},"350":{"tf":1},"469":{"tf":1},"526":{"tf":1.4142135623730951},"528":{"tf":1.4142135623730951},"544":{"tf":1},"683":{"tf":1},"699":{"tf":1},"740":{"tf":1.4142135623730951},"743":{"tf":1},"758":{"tf":1}},"df":18}}}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"909":{"tf":1.4142135623730951},"950":{"tf":1}},"df":2}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"101":{"tf":1},"332":{"tf":1},"564":{"tf":1},"771":{"tf":1},"891":{"tf":1},"907":{"tf":1},"934":{"tf":1}},"df":7}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"_":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"786":{"tf":1},"883":{"tf":1}},"df":2,"@":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{"786":{"tf":1}},"df":1}}}}},"&":{"docs":{},"df":0,"$":{"docs":{},"df":0,"(":{"docs":{},"df":0,"i":{"docs":{},"df":0,")":{"docs":{},"df":0,"@":{"docs":{},"df":0,"#":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"883":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"y":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"942":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{"116":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"579":{"tf":1.4142135623730951},"786":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"r":{"docs":{"115":{"tf":1},"116":{"tf":1},"305":{"tf":1},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1},"578":{"tf":1},"579":{"tf":1},"785":{"tf":1},"786":{"tf":1}},"df":10,"t":{"docs":{"112":{"tf":1},"116":{"tf":1.7320508075688772},"343":{"tf":1},"347":{"tf":1.7320508075688772},"575":{"tf":1},"579":{"tf":1.7320508075688772},"782":{"tf":1},"786":{"tf":1.4142135623730951}},"df":8}}}}}}}},"b":{"docs":{"867":{"tf":1.4142135623730951}},"df":1}}},"j":{"docs":{},"df":0,"a":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1},"941":{"tf":1}},"df":5,"v":{"docs":{},"df":0,"a":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":1.7320508075688772},"8":{"tf":1.7320508075688772},"11":{"tf":1},"14":{"tf":1.4142135623730951},"27":{"tf":1},"34":{"tf":1},"59":{"tf":1.4142135623730951},"62":{"tf":1},"94":{"tf":1},"112":{"tf":1},"122":{"tf":1.4142135623730951},"125":{"tf":1},"128":{"tf":1},"164":{"tf":1},"168":{"tf":1.4142135623730951},"195":{"tf":1},"220":{"tf":1},"240":{"tf":2},"246":{"tf":1.4142135623730951},"360":{"tf":1},"399":{"tf":1},"403":{"tf":1.4142135623730951},"472":{"tf":1.7320508075688772},"478":{"tf":1.4142135623730951},"498":{"tf":1},"618":{"tf":1},"622":{"tf":1.4142135623730951},"692":{"tf":1.4142135623730951},"828":{"tf":1},"832":{"tf":1.4142135623730951},"888":{"tf":1}},"df":32,"f":{"docs":{},"df":0,"x":{"docs":{"3":{"tf":1},"119":{"tf":1},"122":{"tf":1},"202":{"tf":1}},"df":4}},"/":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{"888":{"tf":1}},"df":1}}},"x":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"j":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"948":{"tf":1}},"df":1,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"<":{"docs":{},"df":0,"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"956":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"956":{"tf":1}},"df":1}}}}}}}}}}}},".":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"j":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"948":{"tf":1}},"df":1}}}}}}}}},"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"956":{"tf":1}},"df":1}}}}}}}}}}}}}}},"z":{"docs":{},"df":0,"z":{"docs":{"26":{"tf":1.4142135623730951},"72":{"tf":1},"73":{"tf":1},"74":{"tf":1},"258":{"tf":1.4142135623730951},"303":{"tf":1},"304":{"tf":1},"305":{"tf":1},"490":{"tf":1.4142135623730951},"535":{"tf":1},"536":{"tf":1},"537":{"tf":1},"704":{"tf":1.4142135623730951},"750":{"tf":1},"751":{"tf":1},"752":{"tf":1}},"df":16}},"r":{"docs":{"215":{"tf":1},"447":{"tf":1},"661":{"tf":1}},"df":3}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"55":{"tf":1.4142135623730951},"287":{"tf":1.4142135623730951},"519":{"tf":1.4142135623730951},"733":{"tf":1.4142135623730951}},"df":5}}},"m":{"docs":{},"df":0,"p":{"docs":{"393":{"tf":1},"612":{"tf":1},"822":{"tf":1}},"df":3}}},"e":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1},"880":{"tf":1}},"df":4,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"8":{"tf":1},"38":{"tf":1},"82":{"tf":1.4142135623730951},"94":{"tf":1},"101":{"tf":1},"112":{"tf":1},"122":{"tf":1},"125":{"tf":1},"168":{"tf":1},"169":{"tf":1},"176":{"tf":1},"177":{"tf":1.4142135623730951},"210":{"tf":1},"229":{"tf":1.7320508075688772},"240":{"tf":1.4142135623730951},"270":{"tf":1},"295":{"tf":1},"313":{"tf":1.4142135623730951},"325":{"tf":1},"332":{"tf":1},"343":{"tf":1},"356":{"tf":1},"357":{"tf":1.4142135623730951},"360":{"tf":1},"403":{"tf":1},"404":{"tf":1},"411":{"tf":1},"412":{"tf":1.4142135623730951},"442":{"tf":1},"461":{"tf":1.7320508075688772},"472":{"tf":1},"502":{"tf":1},"527":{"tf":1},"535":{"tf":1},"545":{"tf":1.4142135623730951},"557":{"tf":1},"564":{"tf":1},"575":{"tf":1},"622":{"tf":1},"623":{"tf":1},"630":{"tf":1},"631":{"tf":1.4142135623730951},"675":{"tf":1.7320508075688772},"686":{"tf":1},"716":{"tf":1},"759":{"tf":1.4142135623730951},"764":{"tf":1},"771":{"tf":1},"786":{"tf":1},"832":{"tf":1},"833":{"tf":1},"840":{"tf":1},"841":{"tf":1.4142135623730951},"883":{"tf":1.7320508075688772},"913":{"tf":1},"915":{"tf":1},"926":{"tf":1},"965":{"tf":1}},"df":58}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"229":{"tf":1.4142135623730951},"461":{"tf":1.4142135623730951},"675":{"tf":1.4142135623730951},"883":{"tf":1.4142135623730951}},"df":4}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"8":{"tf":1},"15":{"tf":1},"122":{"tf":1},"134":{"tf":1},"207":{"tf":1},"240":{"tf":1},"247":{"tf":1},"350":{"tf":1},"357":{"tf":1},"369":{"tf":1},"472":{"tf":1},"479":{"tf":1},"588":{"tf":1},"693":{"tf":1},"798":{"tf":1},"909":{"tf":1},"917":{"tf":1},"963":{"tf":1}},"df":18}}}},"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"119":{"tf":1}},"df":1}}}}},"g":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"929":{"tf":1}},"df":1}}}}}},"y":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"215":{"tf":1.4142135623730951},"447":{"tf":1.4142135623730951},"661":{"tf":1.4142135623730951}},"df":3}}}}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"938":{"tf":1},"940":{"tf":1.7320508075688772},"941":{"tf":1.4142135623730951},"942":{"tf":1}},"df":4}}}}}}}}}}}},"n":{"docs":{"38":{"tf":1},"270":{"tf":1},"502":{"tf":1},"716":{"tf":1}},"df":4,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2},"8":{"tf":1.7320508075688772},"240":{"tf":1.7320508075688772},"472":{"tf":1.7320508075688772},"526":{"tf":1},"618":{"tf":1}},"df":7}},"u":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"39":{"tf":1},"232":{"tf":1},"271":{"tf":1},"464":{"tf":1},"503":{"tf":1},"678":{"tf":1},"717":{"tf":1},"883":{"tf":1},"900":{"tf":1},"926":{"tf":1},"943":{"tf":1}},"df":12}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{"15":{"tf":1},"68":{"tf":1},"231":{"tf":1},"247":{"tf":1},"299":{"tf":1},"463":{"tf":1},"479":{"tf":1},"531":{"tf":1},"677":{"tf":1},"693":{"tf":1},"883":{"tf":1}},"df":11,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"134":{"tf":1},"156":{"tf":1},"369":{"tf":1},"391":{"tf":1},"588":{"tf":1},"610":{"tf":1},"798":{"tf":1},"820":{"tf":1}},"df":8}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{"25":{"tf":1},"27":{"tf":1},"38":{"tf":1},"78":{"tf":1},"81":{"tf":1},"82":{"tf":1.4142135623730951},"91":{"tf":1},"115":{"tf":1},"134":{"tf":1},"138":{"tf":1},"139":{"tf":1},"140":{"tf":1.4142135623730951},"143":{"tf":1},"144":{"tf":1},"149":{"tf":1},"169":{"tf":1},"170":{"tf":1},"175":{"tf":1},"181":{"tf":1},"182":{"tf":1},"187":{"tf":1},"192":{"tf":1},"210":{"tf":1},"231":{"tf":1},"232":{"tf":1},"253":{"tf":1},"257":{"tf":1},"259":{"tf":1},"270":{"tf":1},"296":{"tf":1},"309":{"tf":1},"312":{"tf":1},"313":{"tf":1.4142135623730951},"346":{"tf":1},"369":{"tf":1},"373":{"tf":1},"374":{"tf":1},"375":{"tf":1.4142135623730951},"378":{"tf":1},"379":{"tf":1},"384":{"tf":1},"404":{"tf":1},"405":{"tf":1},"410":{"tf":1},"416":{"tf":1},"417":{"tf":1},"422":{"tf":1},"427":{"tf":1},"442":{"tf":1},"463":{"tf":1},"464":{"tf":1},"489":{"tf":1},"491":{"tf":1},"502":{"tf":1},"541":{"tf":1},"544":{"tf":1},"545":{"tf":1.4142135623730951},"554":{"tf":1},"578":{"tf":1},"588":{"tf":1},"592":{"tf":1},"593":{"tf":1},"594":{"tf":1.4142135623730951},"597":{"tf":1},"598":{"tf":1},"603":{"tf":1},"623":{"tf":1},"624":{"tf":1},"629":{"tf":1},"635":{"tf":1},"636":{"tf":1},"641":{"tf":1},"646":{"tf":1},"677":{"tf":1},"678":{"tf":1},"699":{"tf":1},"703":{"tf":1},"716":{"tf":1},"758":{"tf":1},"759":{"tf":1.4142135623730951},"785":{"tf":1},"798":{"tf":1},"802":{"tf":1},"803":{"tf":1},"804":{"tf":1.4142135623730951},"807":{"tf":1},"808":{"tf":1},"813":{"tf":1},"833":{"tf":1},"834":{"tf":1},"839":{"tf":1},"845":{"tf":1},"846":{"tf":1},"851":{"tf":1},"856":{"tf":1},"883":{"tf":1.4142135623730951},"895":{"tf":1},"897":{"tf":1},"911":{"tf":1},"913":{"tf":1},"914":{"tf":1.4142135623730951},"917":{"tf":1},"938":{"tf":1},"939":{"tf":1},"946":{"tf":1},"956":{"tf":1}},"df":106,"d":{"docs":{"50":{"tf":1},"226":{"tf":1},"237":{"tf":1},"282":{"tf":1},"458":{"tf":1},"469":{"tf":1},"514":{"tf":1},"672":{"tf":1},"683":{"tf":1},"728":{"tf":1},"880":{"tf":1},"924":{"tf":1},"938":{"tf":1}},"df":13},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"g":{"docs":{"122":{"tf":1.4142135623730951},"357":{"tf":1},"867":{"tf":1}},"df":3}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"125":{"tf":1},"360":{"tf":1},"895":{"tf":1},"901":{"tf":1}},"df":4}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}}}},"z":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{"351":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{"912":{"tf":1},"928":{"tf":1}},"df":2}}},"p":{"docs":{},"df":0,"f":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{"950":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{"354":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"705":{"tf":1}},"df":1}}}}}}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"g":{"docs":{"888":{"tf":1}},"df":1}}}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"895":{"tf":1}},"df":1}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"920":{"tf":1}},"df":1}}}}}}}},"h":{"docs":{"27":{"tf":1},"115":{"tf":1},"119":{"tf":1},"122":{"tf":1},"131":{"tf":1},"151":{"tf":1},"259":{"tf":1},"346":{"tf":1},"357":{"tf":1},"366":{"tf":1},"386":{"tf":1},"491":{"tf":1},"578":{"tf":1},"585":{"tf":1},"605":{"tf":1},"705":{"tf":1},"795":{"tf":1},"815":{"tf":1}},"df":18},"m":{"docs":{"68":{"tf":1},"77":{"tf":1},"101":{"tf":1.4142135623730951},"104":{"tf":1},"109":{"tf":1.4142135623730951},"122":{"tf":3},"125":{"tf":3},"143":{"tf":1},"161":{"tf":1.4142135623730951},"168":{"tf":1},"169":{"tf":1},"177":{"tf":1},"178":{"tf":1},"187":{"tf":1},"192":{"tf":1},"229":{"tf":1},"231":{"tf":1.7320508075688772},"233":{"tf":1},"299":{"tf":1},"308":{"tf":1},"332":{"tf":1.4142135623730951},"335":{"tf":1},"340":{"tf":1.4142135623730951},"357":{"tf":3},"360":{"tf":3},"378":{"tf":1},"396":{"tf":1.4142135623730951},"403":{"tf":1},"404":{"tf":1},"412":{"tf":1},"413":{"tf":1},"422":{"tf":1},"427":{"tf":1},"461":{"tf":1},"463":{"tf":1.7320508075688772},"465":{"tf":1},"531":{"tf":1},"540":{"tf":1},"564":{"tf":1.4142135623730951},"567":{"tf":1},"572":{"tf":1.4142135623730951},"597":{"tf":1},"615":{"tf":1.4142135623730951},"622":{"tf":1},"623":{"tf":1},"631":{"tf":1},"632":{"tf":1},"641":{"tf":1},"646":{"tf":1},"675":{"tf":1},"677":{"tf":1.7320508075688772},"679":{"tf":1},"699":{"tf":1},"744":{"tf":1},"771":{"tf":1.4142135623730951},"774":{"tf":1},"779":{"tf":1.4142135623730951},"789":{"tf":1.4142135623730951},"807":{"tf":1},"825":{"tf":1.4142135623730951},"832":{"tf":1},"833":{"tf":1},"841":{"tf":1},"842":{"tf":1},"851":{"tf":1},"856":{"tf":1},"883":{"tf":2},"884":{"tf":1},"896":{"tf":1.4142135623730951},"897":{"tf":1.7320508075688772},"901":{"tf":1},"902":{"tf":1.4142135623730951},"903":{"tf":1.4142135623730951},"911":{"tf":1},"917":{"tf":1.7320508075688772},"918":{"tf":1},"926":{"tf":1},"938":{"tf":1},"946":{"tf":1},"947":{"tf":1.4142135623730951},"948":{"tf":1.7320508075688772},"950":{"tf":1},"956":{"tf":1.4142135623730951},"959":{"tf":1},"962":{"tf":1},"963":{"tf":1}},"df":86,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"169":{"tf":1},"404":{"tf":1},"623":{"tf":1},"833":{"tf":1},"918":{"tf":1},"938":{"tf":1}},"df":6}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"171":{"tf":1},"406":{"tf":1},"625":{"tf":1},"835":{"tf":1}},"df":4}}}}}}}}}},"o":{"docs":{},"df":0,"t":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1}},"df":3,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"4":{"tf":1},"51":{"tf":1},"66":{"tf":1},"195":{"tf":1},"240":{"tf":1},"253":{"tf":1},"283":{"tf":1},"350":{"tf":1},"430":{"tf":1},"515":{"tf":1},"529":{"tf":1},"649":{"tf":1},"729":{"tf":1},"747":{"tf":1},"859":{"tf":1},"917":{"tf":2.449489742783178},"923":{"tf":1}},"df":17}}}},"i":{"docs":{},"df":0,"g":{"docs":{"20":{"tf":1.4142135623730951},"104":{"tf":1},"119":{"tf":1},"252":{"tf":1.4142135623730951},"335":{"tf":1},"484":{"tf":1.4142135623730951},"567":{"tf":1},"743":{"tf":1},"774":{"tf":1}},"df":9}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"878":{"tf":1},"879":{"tf":1.4142135623730951},"880":{"tf":1.4142135623730951}},"df":3}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"34":{"tf":1},"133":{"tf":1},"226":{"tf":1},"234":{"tf":1},"266":{"tf":1},"368":{"tf":1},"458":{"tf":1},"466":{"tf":1},"498":{"tf":1},"587":{"tf":1},"672":{"tf":1},"680":{"tf":1},"712":{"tf":1},"797":{"tf":1},"885":{"tf":1},"917":{"tf":1.7320508075688772},"938":{"tf":1},"961":{"tf":1}},"df":18}}}}},"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"210":{"tf":1},"442":{"tf":1},"929":{"tf":1},"957":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"938":{"tf":1}},"df":1}}}}}}}}}}},"e":{"docs":{},"df":0,"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"5":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"z":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"k":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"478":{"tf":1.4142135623730951},"692":{"tf":1.4142135623730951}},"df":4}}}}}}}}}}}}}},"h":{"docs":{},"df":0,"m":{"docs":{"19":{"tf":1},"115":{"tf":1},"125":{"tf":1},"181":{"tf":1},"251":{"tf":1},"346":{"tf":1},"360":{"tf":1},"416":{"tf":1},"483":{"tf":1},"578":{"tf":1},"635":{"tf":1},"697":{"tf":1},"737":{"tf":1},"785":{"tf":1},"845":{"tf":1},"917":{"tf":1}},"df":16}},"b":{"docs":{"27":{"tf":1},"40":{"tf":1},"43":{"tf":1},"86":{"tf":1},"104":{"tf":1},"128":{"tf":1},"155":{"tf":1.4142135623730951},"231":{"tf":1},"259":{"tf":1},"272":{"tf":1},"275":{"tf":1},"317":{"tf":1},"335":{"tf":1},"363":{"tf":1},"390":{"tf":1.4142135623730951},"463":{"tf":1},"491":{"tf":1},"504":{"tf":1},"507":{"tf":1},"549":{"tf":1},"567":{"tf":1},"582":{"tf":1},"609":{"tf":1.4142135623730951},"677":{"tf":1},"705":{"tf":1},"718":{"tf":1},"721":{"tf":1},"774":{"tf":1},"792":{"tf":1},"819":{"tf":1.4142135623730951},"883":{"tf":1},"926":{"tf":1}},"df":32},"u":{"docs":{"62":{"tf":1.4142135623730951},"77":{"tf":1},"90":{"tf":1},"101":{"tf":1},"122":{"tf":1},"168":{"tf":1},"177":{"tf":1},"182":{"tf":1.4142135623730951},"195":{"tf":1},"213":{"tf":1},"232":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"294":{"tf":1.4142135623730951},"308":{"tf":1},"321":{"tf":1},"332":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1},"403":{"tf":1},"412":{"tf":1},"417":{"tf":1.4142135623730951},"430":{"tf":1},"445":{"tf":1},"464":{"tf":1.4142135623730951},"465":{"tf":1.4142135623730951},"526":{"tf":1.4142135623730951},"540":{"tf":1},"553":{"tf":1},"564":{"tf":1},"622":{"tf":1},"631":{"tf":1},"636":{"tf":1.4142135623730951},"649":{"tf":1},"659":{"tf":1},"678":{"tf":1.4142135623730951},"679":{"tf":1.4142135623730951},"699":{"tf":1},"740":{"tf":1.4142135623730951},"771":{"tf":1},"832":{"tf":1},"841":{"tf":1},"846":{"tf":1.4142135623730951},"859":{"tf":1},"867":{"tf":1},"883":{"tf":1.4142135623730951},"884":{"tf":1.4142135623730951},"894":{"tf":1},"895":{"tf":1},"896":{"tf":1},"897":{"tf":1},"898":{"tf":1},"914":{"tf":1},"917":{"tf":1.7320508075688772},"927":{"tf":1},"942":{"tf":1},"947":{"tf":2},"953":{"tf":1.4142135623730951},"954":{"tf":1}},"df":58,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"83":{"tf":1},"314":{"tf":1},"546":{"tf":1},"760":{"tf":1}},"df":4}}}}}}}}}}}},"n":{"docs":{},"df":0,"n":{"docs":{"134":{"tf":1},"168":{"tf":1},"369":{"tf":1},"403":{"tf":1},"588":{"tf":1},"622":{"tf":1},"798":{"tf":1},"832":{"tf":1}},"df":8}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"8":{"tf":1},"43":{"tf":1.4142135623730951},"64":{"tf":1},"68":{"tf":1},"86":{"tf":1},"90":{"tf":1},"128":{"tf":1},"240":{"tf":1},"275":{"tf":1.4142135623730951},"295":{"tf":1},"296":{"tf":1},"299":{"tf":1},"317":{"tf":1},"321":{"tf":1},"363":{"tf":1},"472":{"tf":1},"507":{"tf":1.4142135623730951},"527":{"tf":1},"531":{"tf":1},"549":{"tf":1},"553":{"tf":1},"582":{"tf":1},"721":{"tf":1.4142135623730951},"786":{"tf":1.4142135623730951},"792":{"tf":1},"896":{"tf":1}},"df":26,"t":{"docs":{"14":{"tf":1},"246":{"tf":1},"253":{"tf":1},"478":{"tf":1},"692":{"tf":1},"903":{"tf":1}},"df":6},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"39":{"tf":1},"134":{"tf":1},"155":{"tf":1},"182":{"tf":1},"214":{"tf":1},"215":{"tf":1},"271":{"tf":1},"369":{"tf":1},"390":{"tf":1},"417":{"tf":1},"446":{"tf":1},"447":{"tf":1},"503":{"tf":1},"588":{"tf":1},"609":{"tf":1},"636":{"tf":1},"660":{"tf":1},"661":{"tf":1},"717":{"tf":1},"798":{"tf":1},"819":{"tf":1},"846":{"tf":1},"869":{"tf":1},"909":{"tf":1},"939":{"tf":1},"941":{"tf":1}},"df":26}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"252":{"tf":1}},"df":1}}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"115":{"tf":1},"116":{"tf":2.6457513110645907},"125":{"tf":1},"346":{"tf":1},"347":{"tf":2.6457513110645907},"360":{"tf":1},"578":{"tf":1},"579":{"tf":2.6457513110645907},"785":{"tf":1},"786":{"tf":1.7320508075688772}},"df":10}}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"t":{"docs":{"82":{"tf":1},"313":{"tf":1},"545":{"tf":1},"759":{"tf":1}},"df":4}}},"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{"177":{"tf":1},"412":{"tf":1},"631":{"tf":1},"841":{"tf":1}},"df":4}}}}}}},"e":{"docs":{"232":{"tf":1},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":4},"c":{"docs":{},"df":0,"h":{"docs":{"760":{"tf":1},"761":{"tf":1}},"df":2}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"3":{"tf":1.4142135623730951}},"df":1}}},"k":{"docs":{"3":{"tf":1},"39":{"tf":1},"271":{"tf":1},"503":{"tf":1},"717":{"tf":1}},"df":5}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"951":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"5":{"tf":1},"125":{"tf":1},"143":{"tf":1},"183":{"tf":1},"210":{"tf":1},"296":{"tf":1},"350":{"tf":1},"360":{"tf":1},"378":{"tf":1},"418":{"tf":1},"442":{"tf":1},"597":{"tf":1},"637":{"tf":1},"699":{"tf":1},"807":{"tf":1},"847":{"tf":1}},"df":16,"f":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1}},"df":1}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{"101":{"tf":1},"332":{"tf":1},"564":{"tf":1},"771":{"tf":1}},"df":4}},"a":{"docs":{},"df":0,"g":{"docs":{"686":{"tf":1}},"df":1}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{"354":{"tf":1}},"df":1}}}}}}}}}}}},"p":{"docs":{},"df":0,"p":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1},"917":{"tf":1},"948":{"tf":1}},"df":5,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1},"94":{"tf":1},"312":{"tf":1},"325":{"tf":1},"544":{"tf":1},"557":{"tf":1},"758":{"tf":1},"764":{"tf":1}},"df":8}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"215":{"tf":1},"226":{"tf":1},"447":{"tf":1},"458":{"tf":1},"661":{"tf":1},"672":{"tf":1}},"df":6,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1}},"df":3}}}}}}}}}}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"205":{"tf":1},"210":{"tf":1},"232":{"tf":1.4142135623730951},"356":{"tf":1},"440":{"tf":1},"442":{"tf":1},"464":{"tf":1.4142135623730951},"678":{"tf":1.4142135623730951},"718":{"tf":1},"883":{"tf":1.4142135623730951},"909":{"tf":1},"917":{"tf":1},"935":{"tf":1}},"df":13}},"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,":":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1}},"df":3}}}}}}}}}}},"u":{"docs":{},"df":0,"i":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2},"8":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"122":{"tf":3.4641016151377544},"125":{"tf":1},"202":{"tf":1},"205":{"tf":1},"240":{"tf":1.7320508075688772},"351":{"tf":1},"354":{"tf":2.449489742783178},"357":{"tf":3.4641016151377544},"360":{"tf":1},"437":{"tf":1},"440":{"tf":1},"472":{"tf":1.7320508075688772},"686":{"tf":1},"782":{"tf":1.4142135623730951},"934":{"tf":1},"935":{"tf":2.23606797749979},"938":{"tf":1},"946":{"tf":1}},"df":22},"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"43":{"tf":1},"169":{"tf":1},"192":{"tf":1},"199":{"tf":1},"275":{"tf":1},"404":{"tf":1},"427":{"tf":1},"434":{"tf":1},"507":{"tf":1},"623":{"tf":1},"646":{"tf":1},"653":{"tf":1},"721":{"tf":1},"833":{"tf":1},"856":{"tf":1},"863":{"tf":1}},"df":16}}}},"t":{"docs":{"101":{"tf":1},"125":{"tf":1},"210":{"tf":1},"232":{"tf":1},"332":{"tf":1},"360":{"tf":1},"442":{"tf":1},"464":{"tf":1},"564":{"tf":1},"678":{"tf":1},"771":{"tf":1},"883":{"tf":1}},"df":12}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{"3":{"tf":1},"72":{"tf":1},"303":{"tf":1},"350":{"tf":1},"535":{"tf":1},"938":{"tf":1},"951":{"tf":1}},"df":7},"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"3":{"tf":1}},"df":1}}}},"r":{"docs":{"125":{"tf":1},"360":{"tf":1},"789":{"tf":1}},"df":3,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"923":{"tf":1}},"df":1}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{"205":{"tf":1},"440":{"tf":1}},"df":2,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"8":{"tf":1},"20":{"tf":1},"91":{"tf":1},"122":{"tf":1},"192":{"tf":1},"195":{"tf":1},"240":{"tf":1},"322":{"tf":1},"350":{"tf":1.4142135623730951},"357":{"tf":1},"427":{"tf":1},"430":{"tf":1},"472":{"tf":1},"554":{"tf":1},"646":{"tf":1},"649":{"tf":1},"686":{"tf":1},"856":{"tf":1},"859":{"tf":1},"941":{"tf":1}},"df":21}}},"g":{"docs":{"161":{"tf":1},"396":{"tf":1},"615":{"tf":1},"825":{"tf":1}},"df":4}},"a":{"docs":{},"df":0,"u":{"docs":{"3":{"tf":1},"4":{"tf":1},"19":{"tf":1},"56":{"tf":1},"109":{"tf":1},"116":{"tf":1},"122":{"tf":1},"125":{"tf":1},"149":{"tf":1},"183":{"tf":1},"202":{"tf":1},"203":{"tf":1},"223":{"tf":1},"251":{"tf":1},"288":{"tf":1},"340":{"tf":1},"347":{"tf":1},"350":{"tf":1.4142135623730951},"357":{"tf":1},"360":{"tf":1},"384":{"tf":1},"418":{"tf":1},"437":{"tf":1},"438":{"tf":1},"455":{"tf":1},"483":{"tf":1},"520":{"tf":1},"572":{"tf":1},"579":{"tf":1},"603":{"tf":1},"637":{"tf":1},"656":{"tf":1},"669":{"tf":1},"697":{"tf":1},"734":{"tf":1},"779":{"tf":1},"785":{"tf":1},"813":{"tf":1},"847":{"tf":1},"866":{"tf":1},"877":{"tf":1},"894":{"tf":1},"909":{"tf":1.7320508075688772},"912":{"tf":1},"917":{"tf":1},"919":{"tf":1},"938":{"tf":1},"939":{"tf":1},"945":{"tf":1},"962":{"tf":1}},"df":50,"s":{"docs":{},"df":0,"o":{"docs":{"161":{"tf":1},"396":{"tf":1},"615":{"tf":1},"825":{"tf":1},"917":{"tf":1}},"df":5}}},"n":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"134":{"tf":1},"357":{"tf":1},"369":{"tf":1},"588":{"tf":1},"798":{"tf":1},"923":{"tf":1}},"df":7}}}},"e":{"docs":{},"df":0,"r":{"docs":{"119":{"tf":1},"122":{"tf":1},"354":{"tf":1},"357":{"tf":1.4142135623730951}},"df":4,"i":{"docs":{"32":{"tf":1},"54":{"tf":1},"264":{"tf":1},"286":{"tf":1},"496":{"tf":1},"518":{"tf":1},"732":{"tf":1},"943":{"tf":1},"956":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"945":{"tf":1}},"df":2,"t":{"docs":{"66":{"tf":1},"67":{"tf":1},"253":{"tf":1},"297":{"tf":1},"298":{"tf":1},"529":{"tf":1},"530":{"tf":1},"743":{"tf":1},"744":{"tf":1},"943":{"tf":1},"955":{"tf":1},"959":{"tf":1},"962":{"tf":1}},"df":13}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"183":{"tf":1},"418":{"tf":1},"637":{"tf":1},"847":{"tf":1}},"df":4}}}},"t":{"docs":{"941":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1.4142135623730951},"21":{"tf":1},"892":{"tf":1}},"df":3}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"116":{"tf":1},"217":{"tf":1.4142135623730951},"347":{"tf":1},"449":{"tf":1.4142135623730951},"579":{"tf":1},"663":{"tf":1.4142135623730951},"871":{"tf":1.4142135623730951}},"df":7}}}},"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"208":{"tf":1},"231":{"tf":1.4142135623730951},"441":{"tf":1},"463":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951}},"df":5}}}}}}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1},"206":{"tf":1},"439":{"tf":1},"883":{"tf":1.4142135623730951}},"df":4}}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"208":{"tf":1},"441":{"tf":1}},"df":2}}}}}}}}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"212":{"tf":1},"444":{"tf":1},"658":{"tf":1}},"df":3}}}}}}}}}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"213":{"tf":1},"445":{"tf":1},"659":{"tf":1}},"df":3}}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"213":{"tf":1},"445":{"tf":1},"659":{"tf":1}},"df":3}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}},"a":{"docs":{},"df":0,"n":{"docs":{"237":{"tf":1},"469":{"tf":1},"683":{"tf":1},"910":{"tf":1},"922":{"tf":1}},"df":5}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"122":{"tf":1},"229":{"tf":1},"357":{"tf":1},"461":{"tf":1},"675":{"tf":1},"883":{"tf":1}},"df":6,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}},"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{"4":{"tf":1},"210":{"tf":1},"442":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{"32":{"tf":1.4142135623730951},"264":{"tf":1.4142135623730951},"496":{"tf":1.4142135623730951},"710":{"tf":1},"892":{"tf":1.4142135623730951}},"df":5,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"953":{"tf":1}},"df":1}}}}}},"l":{"docs":{},"df":0,"t":{"docs":{"296":{"tf":1},"743":{"tf":1}},"df":2}}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"66":{"tf":1},"529":{"tf":1}},"df":2}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"275":{"tf":1},"507":{"tf":1},"721":{"tf":1},"741":{"tf":1},"742":{"tf":1}},"df":6}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":4}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}},"s":{"docs":{},"df":0,"s":{"docs":{"125":{"tf":1},"143":{"tf":1},"195":{"tf":1},"360":{"tf":1},"378":{"tf":1},"430":{"tf":1},"597":{"tf":1},"649":{"tf":1},"789":{"tf":1},"807":{"tf":1},"859":{"tf":1}},"df":11}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"149":{"tf":1},"384":{"tf":1},"603":{"tf":1},"813":{"tf":1}},"df":4}}}}}}}},"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"4":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"102":{"tf":1},"131":{"tf":1},"333":{"tf":1},"366":{"tf":1},"565":{"tf":1},"585":{"tf":1},"772":{"tf":1},"795":{"tf":1}},"df":8}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{"950":{"tf":1}},"df":1}}}},"b":{"docs":{"4":{"tf":1},"43":{"tf":1},"68":{"tf":1},"101":{"tf":1},"109":{"tf":1},"125":{"tf":1},"188":{"tf":1},"275":{"tf":1},"299":{"tf":1},"332":{"tf":1},"340":{"tf":1},"360":{"tf":1},"423":{"tf":1},"507":{"tf":1},"531":{"tf":1},"564":{"tf":1},"572":{"tf":1},"642":{"tf":1},"721":{"tf":1},"744":{"tf":1},"748":{"tf":1.4142135623730951},"771":{"tf":1},"779":{"tf":1},"852":{"tf":1},"911":{"tf":1},"947":{"tf":1}},"df":26,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"478":{"tf":1.4142135623730951},"692":{"tf":1.4142135623730951}},"df":4}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"155":{"tf":1},"176":{"tf":1},"177":{"tf":1.4142135623730951},"183":{"tf":1},"189":{"tf":1.7320508075688772},"192":{"tf":1},"390":{"tf":1},"411":{"tf":1},"412":{"tf":1.4142135623730951},"418":{"tf":1},"424":{"tf":1.7320508075688772},"427":{"tf":1},"609":{"tf":1},"630":{"tf":1},"631":{"tf":1.4142135623730951},"637":{"tf":1},"643":{"tf":1.7320508075688772},"646":{"tf":1},"699":{"tf":1},"819":{"tf":1},"840":{"tf":1},"841":{"tf":1.4142135623730951},"847":{"tf":1},"853":{"tf":1.7320508075688772},"856":{"tf":1}},"df":25}}}},"r":{"docs":{"749":{"tf":1},"750":{"tf":1}},"df":2,"a":{"docs":{},"df":0,"d":{"docs":{"15":{"tf":1},"21":{"tf":1},"54":{"tf":1},"158":{"tf":1},"161":{"tf":1},"169":{"tf":1},"189":{"tf":1},"247":{"tf":1},"253":{"tf":1},"286":{"tf":1},"393":{"tf":1},"396":{"tf":1},"404":{"tf":1},"424":{"tf":1},"479":{"tf":1},"485":{"tf":1},"518":{"tf":1},"612":{"tf":1},"615":{"tf":1},"623":{"tf":1},"643":{"tf":1},"693":{"tf":1},"699":{"tf":1},"732":{"tf":1},"822":{"tf":1},"825":{"tf":1},"833":{"tf":1},"853":{"tf":1},"914":{"tf":1}},"df":29},"t":{"docs":{"697":{"tf":2.449489742783178},"698":{"tf":1.4142135623730951},"699":{"tf":3.872983346207417},"741":{"tf":2},"742":{"tf":1.4142135623730951},"743":{"tf":1.4142135623730951},"744":{"tf":1},"747":{"tf":1.4142135623730951},"841":{"tf":1},"867":{"tf":2.6457513110645907},"877":{"tf":1}},"df":11,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"741":{"tf":1},"742":{"tf":1}},"df":2}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}},"n":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"19":{"tf":1},"251":{"tf":1},"298":{"tf":1},"483":{"tf":1},"697":{"tf":1},"891":{"tf":1}},"df":6}}}}},"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"131":{"tf":1},"143":{"tf":1},"366":{"tf":1},"378":{"tf":1},"585":{"tf":1},"597":{"tf":1},"795":{"tf":1},"807":{"tf":1},"899":{"tf":1},"903":{"tf":1}},"df":11}}},"s":{"docs":{},"df":0,"s":{"docs":{"98":{"tf":1},"195":{"tf":1},"329":{"tf":1},"430":{"tf":1},"561":{"tf":1},"649":{"tf":1},"768":{"tf":1},"859":{"tf":1}},"df":8}}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3}}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"140":{"tf":1},"375":{"tf":1},"594":{"tf":1},"804":{"tf":1}},"df":4}}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1},"55":{"tf":1},"199":{"tf":1},"258":{"tf":1},"287":{"tf":1},"434":{"tf":1},"490":{"tf":1},"519":{"tf":1},"653":{"tf":1},"704":{"tf":1},"733":{"tf":1},"863":{"tf":1},"909":{"tf":1}},"df":13}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"62":{"tf":1},"63":{"tf":1},"66":{"tf":1},"140":{"tf":1},"253":{"tf":1},"294":{"tf":1},"375":{"tf":1},"485":{"tf":1},"526":{"tf":1},"529":{"tf":1},"594":{"tf":1},"699":{"tf":1.7320508075688772},"725":{"tf":1},"740":{"tf":1},"741":{"tf":1},"744":{"tf":1},"804":{"tf":1},"911":{"tf":1},"913":{"tf":1.4142135623730951},"915":{"tf":1},"917":{"tf":2},"919":{"tf":1.4142135623730951},"923":{"tf":1},"951":{"tf":1}},"df":24}}}}},"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"912":{"tf":1},"914":{"tf":1},"915":{"tf":1}},"df":3}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"37":{"tf":1},"210":{"tf":1.7320508075688772},"269":{"tf":1},"442":{"tf":1.7320508075688772},"501":{"tf":1},"715":{"tf":1},"898":{"tf":1},"918":{"tf":1},"923":{"tf":1},"927":{"tf":1}},"df":10}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"125":{"tf":1},"215":{"tf":1.4142135623730951},"360":{"tf":1},"447":{"tf":1.4142135623730951},"661":{"tf":1.4142135623730951},"789":{"tf":1}},"df":6}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"354":{"tf":1},"360":{"tf":1}},"df":3}}}}}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"139":{"tf":1},"374":{"tf":1},"593":{"tf":1},"803":{"tf":1}},"df":4}}}}}}}}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"171":{"tf":1},"224":{"tf":1},"406":{"tf":1},"456":{"tf":1},"527":{"tf":1},"625":{"tf":1},"670":{"tf":1},"835":{"tf":1},"878":{"tf":1},"894":{"tf":1},"913":{"tf":1}},"df":11}}}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1},"90":{"tf":1},"125":{"tf":1},"128":{"tf":1},"137":{"tf":1},"138":{"tf":1},"139":{"tf":1},"140":{"tf":1.4142135623730951},"192":{"tf":1},"210":{"tf":1.4142135623730951},"283":{"tf":1},"321":{"tf":1},"360":{"tf":1},"363":{"tf":1},"372":{"tf":1},"373":{"tf":1},"374":{"tf":1},"375":{"tf":1.4142135623730951},"427":{"tf":1},"442":{"tf":1.4142135623730951},"515":{"tf":1},"553":{"tf":1},"582":{"tf":1},"591":{"tf":1},"592":{"tf":1},"593":{"tf":1},"594":{"tf":1.4142135623730951},"646":{"tf":1},"729":{"tf":1},"789":{"tf":1},"792":{"tf":1},"801":{"tf":1},"802":{"tf":1},"803":{"tf":1},"804":{"tf":1.4142135623730951},"856":{"tf":1},"898":{"tf":1},"903":{"tf":1},"909":{"tf":1},"914":{"tf":1},"924":{"tf":1},"938":{"tf":1},"941":{"tf":1},"943":{"tf":1.4142135623730951}},"df":44,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":4}}}}}}},"z":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}},"k":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"755":{"tf":1}},"df":1}}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"718":{"tf":1}},"df":1}}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"66":{"tf":1},"122":{"tf":1},"357":{"tf":1},"529":{"tf":1},"718":{"tf":1}},"df":5}}}}}}}},"e":{"docs":{},"df":0,"h":{"docs":{"91":{"tf":1},"322":{"tf":1},"554":{"tf":1},"913":{"tf":1},"930":{"tf":1},"931":{"tf":1},"965":{"tf":1}},"df":7},"t":{"docs":{},"df":0,"z":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"177":{"tf":1},"178":{"tf":1},"182":{"tf":1},"187":{"tf":1.4142135623730951},"188":{"tf":1},"192":{"tf":1},"199":{"tf":1},"203":{"tf":1},"232":{"tf":1},"357":{"tf":1},"412":{"tf":1},"413":{"tf":1},"417":{"tf":1},"422":{"tf":1.4142135623730951},"423":{"tf":1},"427":{"tf":1},"434":{"tf":1},"438":{"tf":1},"464":{"tf":1},"631":{"tf":1},"632":{"tf":1},"636":{"tf":1},"641":{"tf":1.4142135623730951},"642":{"tf":1},"646":{"tf":1},"653":{"tf":1},"678":{"tf":1},"841":{"tf":1},"842":{"tf":1},"846":{"tf":1},"851":{"tf":1.4142135623730951},"852":{"tf":1},"856":{"tf":1},"863":{"tf":1},"883":{"tf":1},"960":{"tf":1},"962":{"tf":1}},"df":38}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}},"h":{"docs":{"91":{"tf":1},"140":{"tf":1},"181":{"tf":1},"182":{"tf":1},"232":{"tf":1},"375":{"tf":1},"416":{"tf":1},"417":{"tf":1},"464":{"tf":1},"554":{"tf":1},"594":{"tf":1},"635":{"tf":1},"636":{"tf":1},"678":{"tf":1},"804":{"tf":1},"845":{"tf":1},"846":{"tf":1},"883":{"tf":1}},"df":18,"t":{"docs":{"27":{"tf":1},"38":{"tf":1},"55":{"tf":1},"65":{"tf":1},"140":{"tf":1},"155":{"tf":1},"176":{"tf":1},"177":{"tf":1},"184":{"tf":1},"224":{"tf":1},"259":{"tf":1},"270":{"tf":1},"287":{"tf":1},"296":{"tf":1},"354":{"tf":1},"375":{"tf":1},"390":{"tf":1},"411":{"tf":1},"412":{"tf":1},"419":{"tf":1},"456":{"tf":1},"491":{"tf":1},"502":{"tf":1},"519":{"tf":1},"528":{"tf":1},"594":{"tf":1},"609":{"tf":1},"630":{"tf":1},"631":{"tf":1},"638":{"tf":1},"670":{"tf":1},"705":{"tf":1},"716":{"tf":1},"733":{"tf":1},"804":{"tf":1},"819":{"tf":1},"840":{"tf":1},"841":{"tf":1},"848":{"tf":1},"878":{"tf":1}},"df":40},"o":{"docs":{},"df":0,"r":{"docs":{"122":{"tf":1.4142135623730951},"232":{"tf":1},"357":{"tf":1.4142135623730951},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":6,"t":{"docs":{"122":{"tf":1},"357":{"tf":1},"956":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"895":{"tf":1}},"df":1}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"275":{"tf":1},"507":{"tf":1},"721":{"tf":1}},"df":4}}}}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"64":{"tf":1},"295":{"tf":1},"527":{"tf":1}},"df":3}}}},"u":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}},"n":{"docs":{},"df":0,"d":{"docs":{"229":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"461":{"tf":1.4142135623730951},"464":{"tf":1.7320508075688772},"675":{"tf":1.4142135623730951},"678":{"tf":1.7320508075688772},"883":{"tf":2.23606797749979},"918":{"tf":1},"926":{"tf":1}},"df":9}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"898":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"50":{"tf":1},"240":{"tf":1},"282":{"tf":1},"514":{"tf":1},"728":{"tf":1},"956":{"tf":1}},"df":6}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"182":{"tf":1},"417":{"tf":1},"636":{"tf":1},"846":{"tf":1},"938":{"tf":1},"953":{"tf":1}},"df":6}}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"65":{"tf":1},"120":{"tf":1},"143":{"tf":1},"182":{"tf":1},"296":{"tf":1},"355":{"tf":1},"378":{"tf":1},"417":{"tf":1},"528":{"tf":1},"597":{"tf":1},"636":{"tf":1},"807":{"tf":1},"846":{"tf":1}},"df":13}},"d":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2},"u":{"docs":{},"df":0,"f":{"docs":{"146":{"tf":1},"381":{"tf":1},"600":{"tf":1},"810":{"tf":1}},"df":4}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"94":{"tf":1},"237":{"tf":1},"325":{"tf":1},"469":{"tf":1},"557":{"tf":1},"683":{"tf":1},"764":{"tf":1},"915":{"tf":1},"926":{"tf":1}},"df":9}}},"g":{"docs":{},"df":0,"t":{"docs":{"903":{"tf":1}},"df":1}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"134":{"tf":1},"192":{"tf":1.7320508075688772},"369":{"tf":1},"427":{"tf":1.7320508075688772},"588":{"tf":1},"646":{"tf":1.7320508075688772},"798":{"tf":1},"856":{"tf":1.7320508075688772}},"df":8}}},"t":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":4}},"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"216":{"tf":1.7320508075688772},"448":{"tf":1.7320508075688772},"662":{"tf":1.7320508075688772},"870":{"tf":1.7320508075688772}},"df":4}}}},"t":{"docs":{"192":{"tf":1},"427":{"tf":1},"646":{"tf":1},"856":{"tf":1}},"df":4}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"101":{"tf":1},"332":{"tf":1},"564":{"tf":1},"771":{"tf":1},"948":{"tf":1}},"df":5}}}}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"103":{"tf":1},"134":{"tf":1},"137":{"tf":1},"155":{"tf":1},"210":{"tf":1.4142135623730951},"334":{"tf":1},"369":{"tf":1},"372":{"tf":1},"390":{"tf":1},"442":{"tf":1.4142135623730951},"566":{"tf":1},"588":{"tf":1},"591":{"tf":1},"609":{"tf":1},"748":{"tf":1},"773":{"tf":1},"798":{"tf":1},"801":{"tf":1},"819":{"tf":1},"867":{"tf":1},"917":{"tf":2.23606797749979},"918":{"tf":2.8284271247461903},"919":{"tf":1.7320508075688772}},"df":23}}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"122":{"tf":1.7320508075688772},"187":{"tf":1},"357":{"tf":1.7320508075688772},"422":{"tf":1},"641":{"tf":1},"851":{"tf":1}},"df":6}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"458":{"tf":1},"672":{"tf":1},"699":{"tf":1},"880":{"tf":1},"956":{"tf":1}},"df":5}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1},"74":{"tf":1},"82":{"tf":1.4142135623730951},"109":{"tf":1},"116":{"tf":1},"125":{"tf":2},"138":{"tf":1.4142135623730951},"144":{"tf":1},"164":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1},"177":{"tf":1},"192":{"tf":1.7320508075688772},"240":{"tf":1.4142135623730951},"305":{"tf":1},"313":{"tf":1.4142135623730951},"340":{"tf":1},"347":{"tf":1},"350":{"tf":1},"360":{"tf":2},"373":{"tf":1.4142135623730951},"379":{"tf":1},"399":{"tf":1},"403":{"tf":1.4142135623730951},"404":{"tf":1},"412":{"tf":1},"427":{"tf":1.7320508075688772},"472":{"tf":1},"537":{"tf":1},"545":{"tf":1.4142135623730951},"572":{"tf":1},"579":{"tf":1},"592":{"tf":1.4142135623730951},"598":{"tf":1},"618":{"tf":1},"622":{"tf":1.4142135623730951},"623":{"tf":1},"631":{"tf":1},"646":{"tf":1.7320508075688772},"752":{"tf":1},"759":{"tf":1.4142135623730951},"779":{"tf":1},"789":{"tf":1},"802":{"tf":1.4142135623730951},"808":{"tf":1},"828":{"tf":1},"832":{"tf":1.4142135623730951},"833":{"tf":1},"841":{"tf":1},"856":{"tf":1.7320508075688772}},"df":51,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":1},"697":{"tf":1}},"df":2}}}}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1},"786":{"tf":1},"963":{"tf":1}},"df":5}}}}}}}},"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"66":{"tf":1},"177":{"tf":1.4142135623730951},"187":{"tf":1.4142135623730951},"189":{"tf":1},"192":{"tf":2.23606797749979},"215":{"tf":1},"252":{"tf":1.4142135623730951},"412":{"tf":1.4142135623730951},"422":{"tf":1.4142135623730951},"424":{"tf":1},"427":{"tf":2.23606797749979},"447":{"tf":1},"458":{"tf":1},"529":{"tf":1},"631":{"tf":1.4142135623730951},"641":{"tf":1.4142135623730951},"643":{"tf":1},"646":{"tf":2.23606797749979},"661":{"tf":1},"672":{"tf":1},"841":{"tf":1.4142135623730951},"851":{"tf":1.4142135623730951},"853":{"tf":1},"856":{"tf":2.23606797749979},"903":{"tf":1},"909":{"tf":1},"928":{"tf":1},"929":{"tf":1},"930":{"tf":1}},"df":29}}}}},"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"t":{"docs":{"39":{"tf":1},"43":{"tf":1},"62":{"tf":1},"86":{"tf":1},"101":{"tf":1.4142135623730951},"119":{"tf":2},"125":{"tf":2},"128":{"tf":1},"134":{"tf":1},"161":{"tf":1},"176":{"tf":1},"177":{"tf":1.4142135623730951},"182":{"tf":1},"188":{"tf":1},"189":{"tf":1},"192":{"tf":1},"213":{"tf":1.4142135623730951},"214":{"tf":2},"231":{"tf":1.4142135623730951},"271":{"tf":1},"275":{"tf":1},"294":{"tf":1},"295":{"tf":1},"317":{"tf":1},"332":{"tf":1.4142135623730951},"351":{"tf":1.7320508075688772},"354":{"tf":2.23606797749979},"360":{"tf":2},"363":{"tf":1},"369":{"tf":1},"396":{"tf":1},"399":{"tf":1},"411":{"tf":1},"412":{"tf":1.4142135623730951},"417":{"tf":1},"423":{"tf":1},"424":{"tf":1},"427":{"tf":1},"445":{"tf":1.4142135623730951},"446":{"tf":2},"463":{"tf":1.4142135623730951},"503":{"tf":1},"507":{"tf":1},"526":{"tf":1},"535":{"tf":1},"549":{"tf":1},"564":{"tf":1.4142135623730951},"582":{"tf":1},"588":{"tf":1},"615":{"tf":1},"618":{"tf":1},"630":{"tf":1},"631":{"tf":1.4142135623730951},"636":{"tf":1},"642":{"tf":1},"643":{"tf":1},"646":{"tf":1},"659":{"tf":1.4142135623730951},"660":{"tf":2},"677":{"tf":1.4142135623730951},"717":{"tf":1},"721":{"tf":1},"771":{"tf":1.4142135623730951},"786":{"tf":1},"792":{"tf":1},"798":{"tf":1},"825":{"tf":1},"828":{"tf":1},"840":{"tf":1},"841":{"tf":1.4142135623730951},"846":{"tf":1},"852":{"tf":1},"853":{"tf":1},"856":{"tf":1},"869":{"tf":2},"883":{"tf":1.4142135623730951},"888":{"tf":1},"907":{"tf":1},"917":{"tf":1.4142135623730951},"931":{"tf":1},"934":{"tf":1},"941":{"tf":1},"965":{"tf":1.4142135623730951}},"df":83}},"l":{"docs":{},"df":0,"t":{"docs":{"82":{"tf":1},"125":{"tf":1.4142135623730951},"231":{"tf":1},"313":{"tf":1},"360":{"tf":1.4142135623730951},"463":{"tf":1},"545":{"tf":1},"677":{"tf":1},"759":{"tf":1},"883":{"tf":1},"943":{"tf":1}},"df":11}}},"w":{"docs":{},"df":0,"t":{"docs":{"351":{"tf":1}},"df":1}}},"b":{"docs":{"128":{"tf":1},"131":{"tf":1},"133":{"tf":1},"134":{"tf":1},"363":{"tf":1},"366":{"tf":1},"368":{"tf":1},"792":{"tf":1},"795":{"tf":1},"797":{"tf":1}},"df":10,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"34":{"tf":1},"128":{"tf":1.4142135623730951},"146":{"tf":1},"199":{"tf":1},"207":{"tf":1},"266":{"tf":1},"295":{"tf":1},"363":{"tf":1.4142135623730951},"381":{"tf":1},"434":{"tf":1},"498":{"tf":1},"582":{"tf":1.4142135623730951},"600":{"tf":1},"653":{"tf":1},"712":{"tf":1},"792":{"tf":1.4142135623730951},"810":{"tf":1},"863":{"tf":1},"888":{"tf":1},"892":{"tf":1.4142135623730951},"904":{"tf":1},"914":{"tf":1},"917":{"tf":1.4142135623730951},"931":{"tf":1},"935":{"tf":1},"956":{"tf":1}},"df":26,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"3":{"tf":1},"229":{"tf":1},"461":{"tf":1},"675":{"tf":1},"883":{"tf":1}},"df":5}}}}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{"68":{"tf":1},"299":{"tf":1},"531":{"tf":1}},"df":3}}}}}}}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"748":{"tf":1}},"df":1}}}}},"t":{"docs":{"66":{"tf":1},"128":{"tf":1},"210":{"tf":1},"252":{"tf":1},"363":{"tf":1},"442":{"tf":1},"529":{"tf":1},"582":{"tf":1},"792":{"tf":1},"909":{"tf":1},"945":{"tf":1},"960":{"tf":1}},"df":12}}}},"o":{"docs":{},"df":0,"t":{"docs":{"64":{"tf":1},"116":{"tf":1},"195":{"tf":1},"296":{"tf":1},"347":{"tf":1},"351":{"tf":1},"430":{"tf":1},"527":{"tf":1},"579":{"tf":1},"649":{"tf":1},"859":{"tf":1},"917":{"tf":1}},"df":12,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"20":{"tf":1},"192":{"tf":1},"195":{"tf":1.4142135623730951},"209":{"tf":1},"427":{"tf":1},"430":{"tf":1.4142135623730951},"484":{"tf":1},"646":{"tf":1},"649":{"tf":1.4142135623730951},"698":{"tf":1},"856":{"tf":1},"859":{"tf":1.4142135623730951},"898":{"tf":1},"913":{"tf":1},"915":{"tf":1},"917":{"tf":1},"919":{"tf":1.4142135623730951},"931":{"tf":1}},"df":19}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{"77":{"tf":1},"82":{"tf":1},"86":{"tf":1},"308":{"tf":1},"313":{"tf":1},"317":{"tf":1},"540":{"tf":1},"545":{"tf":1},"549":{"tf":1},"748":{"tf":1},"749":{"tf":1},"755":{"tf":1},"759":{"tf":1}},"df":13}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"189":{"tf":1},"424":{"tf":1},"643":{"tf":1},"853":{"tf":1}},"df":4}}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"g":{"docs":{"66":{"tf":1},"225":{"tf":1},"226":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"457":{"tf":1},"458":{"tf":2.23606797749979},"461":{"tf":1.4142135623730951},"464":{"tf":1.4142135623730951},"529":{"tf":1},"671":{"tf":1},"672":{"tf":2.23606797749979},"675":{"tf":1.4142135623730951},"678":{"tf":1.4142135623730951},"879":{"tf":1},"880":{"tf":2.23606797749979},"883":{"tf":2}},"df":17,"t":{"docs":{"66":{"tf":1},"220":{"tf":1.4142135623730951},"452":{"tf":1.4142135623730951},"529":{"tf":1},"666":{"tf":1.4142135623730951},"874":{"tf":1.4142135623730951}},"df":6}}}},"e":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"210":{"tf":1},"442":{"tf":1}},"df":3,"e":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1},"232":{"tf":1},"296":{"tf":1},"442":{"tf":1},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":7}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{"169":{"tf":1},"195":{"tf":1},"350":{"tf":1},"404":{"tf":1},"430":{"tf":1},"623":{"tf":1},"649":{"tf":1},"833":{"tf":1},"859":{"tf":1},"909":{"tf":1},"913":{"tf":1},"920":{"tf":1},"923":{"tf":1}},"df":13}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":4}}}}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"20":{"tf":1},"226":{"tf":1.7320508075688772},"252":{"tf":1},"458":{"tf":1.4142135623730951},"672":{"tf":1.4142135623730951}},"df":6,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"226":{"tf":1},"458":{"tf":1},"672":{"tf":1}},"df":3}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"354":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"203":{"tf":1},"357":{"tf":1},"438":{"tf":1}},"df":4}}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{"156":{"tf":1},"391":{"tf":1},"610":{"tf":1},"820":{"tf":1}},"df":4}}},"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{"188":{"tf":1},"189":{"tf":1},"423":{"tf":1},"424":{"tf":1},"642":{"tf":1},"643":{"tf":1},"852":{"tf":1},"853":{"tf":1}},"df":8}}}},"a":{"docs":{},"df":0,"t":{"docs":{"67":{"tf":1},"298":{"tf":1},"530":{"tf":1},"744":{"tf":1}},"df":4}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"g":{"docs":{"4":{"tf":1},"540":{"tf":1}},"df":2},"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"931":{"tf":1}},"df":1}}}}}}}}}}},"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"109":{"tf":1},"340":{"tf":1},"572":{"tf":1},"779":{"tf":1}},"df":4}}}},"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"182":{"tf":1},"417":{"tf":1},"636":{"tf":1},"846":{"tf":1}},"df":4,"t":{"docs":{"140":{"tf":1},"210":{"tf":1.7320508075688772},"375":{"tf":1},"442":{"tf":1.7320508075688772},"594":{"tf":1},"804":{"tf":1}},"df":6}}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"171":{"tf":1},"406":{"tf":1},"625":{"tf":1},"835":{"tf":1}},"df":4}}}}},"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1},"62":{"tf":1},"64":{"tf":1},"81":{"tf":1},"82":{"tf":1},"101":{"tf":1},"116":{"tf":1},"202":{"tf":1},"203":{"tf":1},"229":{"tf":1},"253":{"tf":1},"294":{"tf":1},"295":{"tf":1},"312":{"tf":1},"313":{"tf":1},"332":{"tf":1},"347":{"tf":1},"351":{"tf":1},"437":{"tf":1},"438":{"tf":1},"461":{"tf":1},"485":{"tf":1},"526":{"tf":1},"527":{"tf":1},"544":{"tf":1},"545":{"tf":1},"564":{"tf":1},"579":{"tf":1},"675":{"tf":1},"740":{"tf":1},"758":{"tf":1},"759":{"tf":1},"771":{"tf":1},"786":{"tf":1},"883":{"tf":1}},"df":35,"t":{"docs":{"56":{"tf":1},"125":{"tf":1},"288":{"tf":1},"350":{"tf":1},"360":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":7}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{},"df":0,"t":{"docs":{"350":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{"697":{"tf":1}},"df":1}}}}},"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{"122":{"tf":1.4142135623730951},"357":{"tf":1.4142135623730951},"686":{"tf":1}},"df":3,"t":{"docs":{"4":{"tf":1},"27":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"491":{"tf":1.4142135623730951},"705":{"tf":1.4142135623730951},"917":{"tf":1},"937":{"tf":1}},"df":7},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"8":{"tf":1},"240":{"tf":1},"472":{"tf":1}},"df":3}}}}}}}}}}},"u":{"docs":{},"df":0,"g":{"docs":{"164":{"tf":1},"350":{"tf":1},"399":{"tf":1},"618":{"tf":1},"828":{"tf":1},"914":{"tf":1.4142135623730951},"915":{"tf":1},"917":{"tf":1},"918":{"tf":1.4142135623730951}},"df":9}},"o":{"docs":{},"df":0,"g":{"docs":{"935":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{"948":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1},"11":{"tf":1.4142135623730951},"14":{"tf":1},"55":{"tf":1},"116":{"tf":1.4142135623730951},"119":{"tf":1},"122":{"tf":1.4142135623730951},"125":{"tf":2.449489742783178},"131":{"tf":1},"140":{"tf":1.4142135623730951},"150":{"tf":1},"169":{"tf":1},"171":{"tf":1},"188":{"tf":1},"189":{"tf":1},"192":{"tf":1.4142135623730951},"210":{"tf":1},"233":{"tf":1},"240":{"tf":1},"243":{"tf":1.4142135623730951},"246":{"tf":1},"287":{"tf":1},"347":{"tf":1.4142135623730951},"350":{"tf":2},"354":{"tf":1},"357":{"tf":1.4142135623730951},"360":{"tf":2.449489742783178},"366":{"tf":1},"375":{"tf":1.4142135623730951},"385":{"tf":1},"404":{"tf":1},"406":{"tf":1},"423":{"tf":1},"424":{"tf":1},"427":{"tf":1.4142135623730951},"442":{"tf":1},"465":{"tf":1},"472":{"tf":1},"475":{"tf":1.4142135623730951},"478":{"tf":1},"519":{"tf":1},"579":{"tf":1.4142135623730951},"585":{"tf":1},"594":{"tf":1.4142135623730951},"604":{"tf":1},"623":{"tf":1},"625":{"tf":1},"642":{"tf":1},"643":{"tf":1},"646":{"tf":1.4142135623730951},"679":{"tf":1},"689":{"tf":1},"692":{"tf":1},"733":{"tf":1},"786":{"tf":1},"789":{"tf":1.7320508075688772},"795":{"tf":1},"804":{"tf":1.4142135623730951},"814":{"tf":1},"833":{"tf":1},"835":{"tf":1},"852":{"tf":1},"853":{"tf":1},"856":{"tf":1.4142135623730951},"884":{"tf":1},"891":{"tf":1},"896":{"tf":1},"904":{"tf":1},"907":{"tf":1.4142135623730951},"908":{"tf":1},"912":{"tf":1},"913":{"tf":1},"915":{"tf":1},"917":{"tf":1.4142135623730951},"919":{"tf":1},"926":{"tf":1.4142135623730951},"934":{"tf":1},"945":{"tf":1},"947":{"tf":1.4142135623730951},"953":{"tf":1},"956":{"tf":1},"958":{"tf":1},"960":{"tf":1}},"df":84,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"54":{"tf":1},"286":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":4}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"237":{"tf":1},"469":{"tf":1},"683":{"tf":1}},"df":3}}}}}}}}}}},"m":{"docs":{"14":{"tf":1},"21":{"tf":1},"122":{"tf":1},"125":{"tf":1.4142135623730951},"134":{"tf":1},"139":{"tf":1},"140":{"tf":1},"144":{"tf":1},"149":{"tf":1},"155":{"tf":1},"169":{"tf":1},"177":{"tf":2.23606797749979},"178":{"tf":1},"181":{"tf":1},"182":{"tf":1.4142135623730951},"184":{"tf":1},"192":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"246":{"tf":1},"350":{"tf":1},"351":{"tf":1},"357":{"tf":1},"360":{"tf":1.4142135623730951},"369":{"tf":1},"374":{"tf":1},"375":{"tf":1},"379":{"tf":1},"384":{"tf":1},"390":{"tf":1},"404":{"tf":1},"412":{"tf":2.23606797749979},"413":{"tf":1},"416":{"tf":1},"417":{"tf":1.4142135623730951},"419":{"tf":1},"427":{"tf":1.4142135623730951},"458":{"tf":1.4142135623730951},"478":{"tf":1},"588":{"tf":1},"593":{"tf":1},"594":{"tf":1},"598":{"tf":1},"603":{"tf":1},"609":{"tf":1},"623":{"tf":1},"631":{"tf":2.23606797749979},"632":{"tf":1},"635":{"tf":1},"636":{"tf":1.4142135623730951},"638":{"tf":1},"646":{"tf":1.4142135623730951},"672":{"tf":1.4142135623730951},"692":{"tf":1},"742":{"tf":1},"789":{"tf":1},"798":{"tf":1},"803":{"tf":1},"804":{"tf":1},"808":{"tf":1},"813":{"tf":1},"819":{"tf":1},"833":{"tf":1},"841":{"tf":2.23606797749979},"842":{"tf":1},"845":{"tf":1},"846":{"tf":1.4142135623730951},"848":{"tf":1},"856":{"tf":1.4142135623730951},"880":{"tf":1.4142135623730951},"903":{"tf":1},"909":{"tf":1.4142135623730951},"926":{"tf":1},"941":{"tf":1},"953":{"tf":1},"962":{"tf":1}},"df":75},"d":{"docs":{"78":{"tf":1},"82":{"tf":1.7320508075688772},"94":{"tf":1},"97":{"tf":1.4142135623730951},"115":{"tf":1},"116":{"tf":1},"167":{"tf":1},"182":{"tf":1},"309":{"tf":1},"313":{"tf":1.7320508075688772},"325":{"tf":1},"328":{"tf":1.4142135623730951},"346":{"tf":1},"347":{"tf":1},"357":{"tf":1},"402":{"tf":1},"417":{"tf":1},"541":{"tf":1},"545":{"tf":1.7320508075688772},"557":{"tf":1},"560":{"tf":1.4142135623730951},"578":{"tf":1},"579":{"tf":1},"621":{"tf":1},"636":{"tf":1},"699":{"tf":1},"759":{"tf":1.7320508075688772},"764":{"tf":1},"767":{"tf":1.4142135623730951},"774":{"tf":1},"785":{"tf":1},"831":{"tf":1},"846":{"tf":1},"913":{"tf":1.4142135623730951},"919":{"tf":1}},"df":35},"n":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"897":{"tf":1},"898":{"tf":1},"904":{"tf":1},"909":{"tf":1},"917":{"tf":1},"918":{"tf":1},"938":{"tf":1},"948":{"tf":1},"949":{"tf":1},"956":{"tf":1}},"df":10,"e":{"docs":{},"df":0,"t":{"docs":{"213":{"tf":1},"445":{"tf":1},"659":{"tf":1},"894":{"tf":1},"897":{"tf":1},"918":{"tf":1.4142135623730951},"935":{"tf":1},"940":{"tf":1},"941":{"tf":2.23606797749979},"946":{"tf":1}},"df":10}}}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"21":{"tf":1},"37":{"tf":1},"66":{"tf":1.4142135623730951},"91":{"tf":1},"97":{"tf":1},"109":{"tf":1},"115":{"tf":1},"116":{"tf":1},"119":{"tf":1},"125":{"tf":1},"128":{"tf":1},"134":{"tf":1},"140":{"tf":1},"157":{"tf":1},"176":{"tf":1},"177":{"tf":1},"182":{"tf":1},"195":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"223":{"tf":1},"224":{"tf":1},"226":{"tf":1},"231":{"tf":1},"232":{"tf":1},"237":{"tf":1},"240":{"tf":1},"252":{"tf":1},"253":{"tf":1},"269":{"tf":1},"297":{"tf":1},"322":{"tf":1},"328":{"tf":1},"340":{"tf":1},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1},"354":{"tf":1.4142135623730951},"360":{"tf":1},"363":{"tf":1},"369":{"tf":1},"375":{"tf":1},"392":{"tf":1},"411":{"tf":1},"412":{"tf":1},"417":{"tf":1},"430":{"tf":1.4142135623730951},"438":{"tf":1.4142135623730951},"455":{"tf":1},"456":{"tf":1},"458":{"tf":1},"464":{"tf":1},"469":{"tf":1},"485":{"tf":1},"501":{"tf":1},"527":{"tf":1},"529":{"tf":1.4142135623730951},"535":{"tf":1},"554":{"tf":1},"560":{"tf":1},"572":{"tf":1},"578":{"tf":1},"579":{"tf":1},"582":{"tf":1},"588":{"tf":1},"594":{"tf":1},"611":{"tf":1},"630":{"tf":1},"631":{"tf":1},"636":{"tf":1},"649":{"tf":1.4142135623730951},"669":{"tf":1},"670":{"tf":1},"672":{"tf":1},"678":{"tf":1},"683":{"tf":1},"699":{"tf":1.4142135623730951},"715":{"tf":1},"749":{"tf":1},"750":{"tf":1},"767":{"tf":1},"779":{"tf":1},"785":{"tf":1},"789":{"tf":1},"792":{"tf":1},"798":{"tf":1},"804":{"tf":1},"821":{"tf":1},"840":{"tf":1},"841":{"tf":1},"846":{"tf":1},"859":{"tf":1.4142135623730951},"877":{"tf":1},"878":{"tf":1},"880":{"tf":1},"883":{"tf":1},"888":{"tf":1},"900":{"tf":1},"913":{"tf":1.4142135623730951},"917":{"tf":1},"918":{"tf":1.4142135623730951},"948":{"tf":1},"950":{"tf":1}},"df":104,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1},"934":{"tf":1}},"df":5}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{"15":{"tf":1.4142135623730951},"56":{"tf":1},"112":{"tf":1},"115":{"tf":1},"119":{"tf":1.4142135623730951},"120":{"tf":1},"125":{"tf":1},"232":{"tf":1.4142135623730951},"240":{"tf":1},"247":{"tf":1.4142135623730951},"288":{"tf":1},"343":{"tf":1},"346":{"tf":1},"354":{"tf":1.4142135623730951},"355":{"tf":1},"360":{"tf":1},"464":{"tf":1.4142135623730951},"479":{"tf":1.4142135623730951},"520":{"tf":1},"575":{"tf":1},"578":{"tf":1},"678":{"tf":1.4142135623730951},"693":{"tf":1.4142135623730951},"734":{"tf":1},"782":{"tf":1},"785":{"tf":1},"883":{"tf":1.4142135623730951},"897":{"tf":1},"909":{"tf":1},"914":{"tf":1},"915":{"tf":1},"917":{"tf":1},"931":{"tf":1},"935":{"tf":1},"951":{"tf":1}},"df":35}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1},"258":{"tf":1},"490":{"tf":1},"704":{"tf":1}},"df":4}}},"t":{"docs":{"867":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"82":{"tf":1},"313":{"tf":1},"545":{"tf":1},"759":{"tf":1}},"df":4}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"350":{"tf":1},"357":{"tf":1},"946":{"tf":1},"950":{"tf":1}},"df":5}}}}}}}}}}}},"s":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1},"27":{"tf":1},"125":{"tf":1},"259":{"tf":1},"360":{"tf":1},"458":{"tf":1},"491":{"tf":1},"672":{"tf":1},"705":{"tf":1},"909":{"tf":1}},"df":10},"t":{"docs":{"125":{"tf":1.4142135623730951},"187":{"tf":1},"350":{"tf":1},"360":{"tf":1.4142135623730951},"422":{"tf":1},"641":{"tf":1},"851":{"tf":1}},"df":7,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"11":{"tf":1},"116":{"tf":1},"243":{"tf":1},"347":{"tf":1},"475":{"tf":1},"579":{"tf":1},"689":{"tf":1}},"df":7}}}}}},"t":{"docs":{"55":{"tf":1},"178":{"tf":1},"287":{"tf":1},"413":{"tf":1},"519":{"tf":1},"632":{"tf":1},"733":{"tf":1},"750":{"tf":1},"842":{"tf":1},"948":{"tf":1},"951":{"tf":1}},"df":11}},"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"25":{"tf":1},"257":{"tf":1},"489":{"tf":1},"698":{"tf":1},"703":{"tf":1}},"df":5}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"119":{"tf":1},"229":{"tf":1},"231":{"tf":1},"461":{"tf":1},"463":{"tf":1},"675":{"tf":1},"677":{"tf":1},"883":{"tf":1.4142135623730951}},"df":8,"t":{"docs":{"122":{"tf":1},"171":{"tf":1},"224":{"tf":1},"229":{"tf":1},"350":{"tf":1},"357":{"tf":1},"406":{"tf":1},"456":{"tf":1},"461":{"tf":1},"625":{"tf":1},"670":{"tf":1},"675":{"tf":1},"835":{"tf":1},"878":{"tf":1},"883":{"tf":1},"923":{"tf":1},"943":{"tf":1}},"df":17}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"21":{"tf":1},"91":{"tf":1},"97":{"tf":1},"105":{"tf":1},"175":{"tf":1},"187":{"tf":1},"232":{"tf":1},"328":{"tf":1},"336":{"tf":1},"350":{"tf":1},"356":{"tf":1},"410":{"tf":1},"422":{"tf":1},"463":{"tf":1},"464":{"tf":1},"554":{"tf":1},"560":{"tf":1},"568":{"tf":1},"629":{"tf":1},"641":{"tf":1},"677":{"tf":1},"678":{"tf":1},"686":{"tf":1},"767":{"tf":1},"775":{"tf":1},"839":{"tf":1},"851":{"tf":1},"883":{"tf":1.4142135623730951},"960":{"tf":1}},"df":29}},"f":{"docs":{},"df":0,"t":{"docs":{"104":{"tf":1},"122":{"tf":1},"125":{"tf":4.242640687119285},"335":{"tf":1},"350":{"tf":1.4142135623730951},"357":{"tf":1},"360":{"tf":4.242640687119285},"567":{"tf":1},"774":{"tf":1},"789":{"tf":1.4142135623730951}},"df":10}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{"28":{"tf":1},"116":{"tf":2},"125":{"tf":1},"195":{"tf":1},"260":{"tf":1},"347":{"tf":2},"360":{"tf":1},"430":{"tf":1},"492":{"tf":1},"579":{"tf":2},"649":{"tf":1},"706":{"tf":1},"859":{"tf":1},"904":{"tf":1},"931":{"tf":1},"936":{"tf":1},"946":{"tf":1}},"df":17,"t":{"docs":{"65":{"tf":1},"296":{"tf":1},"528":{"tf":1},"888":{"tf":1},"934":{"tf":1},"946":{"tf":1}},"df":6}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"k":{"docs":{"134":{"tf":1},"369":{"tf":1},"588":{"tf":1},"798":{"tf":1}},"df":4}}}},"a":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"128":{"tf":1},"363":{"tf":1},"582":{"tf":1},"792":{"tf":1}},"df":4}}}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"68":{"tf":1},"116":{"tf":1},"189":{"tf":1},"299":{"tf":1},"347":{"tf":1},"424":{"tf":1},"531":{"tf":1},"579":{"tf":1},"643":{"tf":1},"786":{"tf":1},"853":{"tf":1}},"df":11,"t":{"docs":{"209":{"tf":1.4142135623730951}},"df":1}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"140":{"tf":1},"182":{"tf":1},"240":{"tf":1},"375":{"tf":1},"417":{"tf":1},"594":{"tf":1},"636":{"tf":1},"804":{"tf":1},"846":{"tf":1},"909":{"tf":1},"930":{"tf":1}},"df":11}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"231":{"tf":1},"463":{"tf":1},"677":{"tf":1},"883":{"tf":1}},"df":4}}}}},"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"527":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"11":{"tf":1.4142135623730951},"102":{"tf":1},"243":{"tf":1.4142135623730951},"333":{"tf":1},"475":{"tf":1.4142135623730951},"565":{"tf":1},"689":{"tf":1},"718":{"tf":1},"772":{"tf":1},"938":{"tf":1},"951":{"tf":1}},"df":11}}}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4}}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"161":{"tf":1},"396":{"tf":1},"615":{"tf":1},"825":{"tf":1}},"df":4}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"140":{"tf":1},"215":{"tf":1},"375":{"tf":1},"447":{"tf":1},"594":{"tf":1},"661":{"tf":1},"742":{"tf":1},"804":{"tf":1},"939":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"t":{"docs":{"940":{"tf":1}},"df":1}}}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"38":{"tf":1},"122":{"tf":1},"140":{"tf":1},"145":{"tf":1},"182":{"tf":1.4142135623730951},"270":{"tf":1},"357":{"tf":1},"375":{"tf":1},"380":{"tf":1},"417":{"tf":1.4142135623730951},"502":{"tf":1},"594":{"tf":1},"599":{"tf":1},"636":{"tf":1.4142135623730951},"716":{"tf":1},"804":{"tf":1},"809":{"tf":1},"846":{"tf":1.4142135623730951}},"df":18,"e":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1.4142135623730951},"77":{"tf":1},"109":{"tf":1},"158":{"tf":1},"169":{"tf":1},"189":{"tf":1},"198":{"tf":1},"203":{"tf":1.4142135623730951},"226":{"tf":1},"231":{"tf":1},"247":{"tf":1.4142135623730951},"308":{"tf":1},"340":{"tf":1},"393":{"tf":1},"404":{"tf":1},"424":{"tf":1},"433":{"tf":1},"438":{"tf":1.4142135623730951},"463":{"tf":1},"479":{"tf":1.4142135623730951},"540":{"tf":1},"572":{"tf":1},"612":{"tf":1},"623":{"tf":1},"643":{"tf":1},"652":{"tf":1},"677":{"tf":1},"693":{"tf":1.4142135623730951},"779":{"tf":1},"822":{"tf":1},"833":{"tf":1},"853":{"tf":1},"862":{"tf":1},"883":{"tf":1}},"df":34}}}}},"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"102":{"tf":1},"103":{"tf":1},"333":{"tf":1},"334":{"tf":1},"565":{"tf":1},"566":{"tf":1},"772":{"tf":1},"773":{"tf":1}},"df":8,"t":{"docs":{"101":{"tf":1},"332":{"tf":1},"564":{"tf":1},"771":{"tf":1}},"df":4}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"119":{"tf":1.4142135623730951},"354":{"tf":1}},"df":2}}},"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"128":{"tf":1},"215":{"tf":1.4142135623730951},"363":{"tf":1},"447":{"tf":1.4142135623730951},"582":{"tf":1},"661":{"tf":1.4142135623730951},"792":{"tf":1},"867":{"tf":1.4142135623730951}},"df":8}},"s":{"docs":{},"df":0,"t":{"docs":{"128":{"tf":1},"363":{"tf":1},"582":{"tf":1},"792":{"tf":1}},"df":4}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"46":{"tf":1.4142135623730951},"51":{"tf":1},"59":{"tf":1},"65":{"tf":1.4142135623730951},"68":{"tf":1},"72":{"tf":1.4142135623730951},"77":{"tf":1},"86":{"tf":2.449489742783178},"90":{"tf":1},"91":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"177":{"tf":1},"192":{"tf":1},"210":{"tf":1},"226":{"tf":1},"229":{"tf":1.4142135623730951},"278":{"tf":1.4142135623730951},"283":{"tf":1},"291":{"tf":1},"296":{"tf":1.4142135623730951},"299":{"tf":1},"303":{"tf":1.4142135623730951},"308":{"tf":1},"317":{"tf":2.23606797749979},"321":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951},"412":{"tf":1},"427":{"tf":1},"442":{"tf":1},"458":{"tf":1},"461":{"tf":1.4142135623730951},"510":{"tf":1.4142135623730951},"515":{"tf":1},"523":{"tf":1},"528":{"tf":1.4142135623730951},"531":{"tf":1},"535":{"tf":1.4142135623730951},"540":{"tf":1},"549":{"tf":2.449489742783178},"553":{"tf":1},"554":{"tf":1},"578":{"tf":1.4142135623730951},"579":{"tf":1.4142135623730951},"631":{"tf":1},"646":{"tf":1},"672":{"tf":1},"675":{"tf":1.4142135623730951},"724":{"tf":1.4142135623730951},"729":{"tf":1},"737":{"tf":1},"748":{"tf":1},"750":{"tf":1.4142135623730951},"755":{"tf":1},"760":{"tf":1.4142135623730951},"761":{"tf":1.4142135623730951},"785":{"tf":1.4142135623730951},"841":{"tf":1},"856":{"tf":1},"883":{"tf":1.4142135623730951},"938":{"tf":1}},"df":64,"e":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1},"27":{"tf":1},"47":{"tf":1},"74":{"tf":1},"86":{"tf":1},"90":{"tf":1},"192":{"tf":1.4142135623730951},"247":{"tf":1},"259":{"tf":1},"279":{"tf":1},"305":{"tf":1},"317":{"tf":1},"321":{"tf":1},"427":{"tf":1.4142135623730951},"479":{"tf":1},"491":{"tf":1},"511":{"tf":1},"537":{"tf":1},"549":{"tf":1},"553":{"tf":1},"646":{"tf":1.4142135623730951},"693":{"tf":1},"705":{"tf":1},"725":{"tf":1.7320508075688772},"752":{"tf":1},"856":{"tf":1.4142135623730951},"909":{"tf":1}},"df":27}}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"164":{"tf":1},"231":{"tf":1},"399":{"tf":1},"618":{"tf":1},"828":{"tf":1},"928":{"tf":1}},"df":7}}},"l":{"docs":{"119":{"tf":1},"210":{"tf":1.4142135623730951},"354":{"tf":1},"442":{"tf":1.4142135623730951},"926":{"tf":1}},"df":5}}},"l":{"docs":{},"df":0,"t":{"docs":{"62":{"tf":1}},"df":1}}},"o":{"docs":{},"df":0,"b":{"docs":{"157":{"tf":1},"161":{"tf":1},"392":{"tf":1},"396":{"tf":1},"611":{"tf":1},"615":{"tf":1},"821":{"tf":1},"825":{"tf":1}},"df":8}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"909":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"21":{"tf":1},"63":{"tf":1},"146":{"tf":1},"181":{"tf":1},"253":{"tf":1},"381":{"tf":1},"416":{"tf":1},"485":{"tf":1},"600":{"tf":1},"635":{"tf":1},"699":{"tf":1},"810":{"tf":1},"845":{"tf":1}},"df":13}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"73":{"tf":1},"81":{"tf":1},"215":{"tf":1},"304":{"tf":1},"312":{"tf":1},"447":{"tf":1},"536":{"tf":1},"544":{"tf":1},"661":{"tf":1},"748":{"tf":1},"749":{"tf":1},"758":{"tf":1},"867":{"tf":1}},"df":13}}}},"k":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"38":{"tf":1},"50":{"tf":1},"168":{"tf":1},"264":{"tf":1},"270":{"tf":1},"282":{"tf":1},"350":{"tf":1.7320508075688772},"403":{"tf":1},"496":{"tf":1},"502":{"tf":1},"514":{"tf":1},"622":{"tf":1},"699":{"tf":1},"710":{"tf":1},"716":{"tf":1},"728":{"tf":1},"832":{"tf":1},"909":{"tf":1}},"df":19}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{"900":{"tf":1},"963":{"tf":1}},"df":2}}}},"q":{"docs":{},"df":0,"u":{"docs":{"38":{"tf":1},"270":{"tf":1},"502":{"tf":1},"716":{"tf":1}},"df":4}},"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"122":{"tf":1.4142135623730951},"146":{"tf":1},"199":{"tf":1},"357":{"tf":1.4142135623730951},"381":{"tf":1},"434":{"tf":1},"540":{"tf":1},"600":{"tf":1},"653":{"tf":1},"810":{"tf":1},"863":{"tf":1},"938":{"tf":1}},"df":12,"z":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"146":{"tf":1},"199":{"tf":1},"381":{"tf":1},"434":{"tf":1},"600":{"tf":1},"653":{"tf":1},"810":{"tf":1},"863":{"tf":1},"957":{"tf":1}},"df":9}}}},"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"181":{"tf":1},"416":{"tf":1},"635":{"tf":1},"845":{"tf":1}},"df":4}}}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":1.4142135623730951},"55":{"tf":1},"192":{"tf":1},"251":{"tf":1},"252":{"tf":2},"253":{"tf":2.8284271247461903},"279":{"tf":1},"287":{"tf":1},"291":{"tf":1},"294":{"tf":1},"296":{"tf":1.4142135623730951},"297":{"tf":1},"298":{"tf":1},"299":{"tf":1},"317":{"tf":1},"350":{"tf":1},"412":{"tf":1},"427":{"tf":1},"455":{"tf":1},"458":{"tf":1},"519":{"tf":1},"646":{"tf":1},"672":{"tf":1},"733":{"tf":1},"856":{"tf":1}},"df":25,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"\"":{"docs":{},"df":0,"=":{"docs":{},"df":0,"\"":{"docs":{},"df":0,"i":{"docs":{"189":{"tf":1},"424":{"tf":1},"643":{"tf":1},"853":{"tf":1}},"df":4}}}},"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"253":{"tf":1}},"df":1}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"4":{"tf":1},"168":{"tf":1},"403":{"tf":1},"622":{"tf":1},"832":{"tf":1}},"df":5,"t":{"docs":{"43":{"tf":1.4142135623730951},"275":{"tf":1.4142135623730951},"507":{"tf":1.4142135623730951},"721":{"tf":1.4142135623730951},"935":{"tf":1}},"df":5}}}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"101":{"tf":1},"158":{"tf":1},"168":{"tf":1},"232":{"tf":1},"332":{"tf":1},"393":{"tf":1},"403":{"tf":1},"464":{"tf":1},"564":{"tf":1},"612":{"tf":1},"622":{"tf":1},"678":{"tf":1},"771":{"tf":1},"822":{"tf":1},"832":{"tf":1},"883":{"tf":1},"948":{"tf":1}},"df":17,"t":{"docs":{"169":{"tf":1},"171":{"tf":1},"404":{"tf":1},"406":{"tf":1},"623":{"tf":1},"625":{"tf":1},"833":{"tf":1},"835":{"tf":1}},"df":8}}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"k":{"docs":{"229":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"461":{"tf":1.4142135623730951},"464":{"tf":1.7320508075688772},"675":{"tf":1.4142135623730951},"678":{"tf":1.7320508075688772},"883":{"tf":2.449489742783178}},"df":7,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"128":{"tf":1},"131":{"tf":1.7320508075688772},"132":{"tf":1},"133":{"tf":1},"134":{"tf":2.449489742783178},"161":{"tf":1},"181":{"tf":1.4142135623730951},"363":{"tf":1},"366":{"tf":1.7320508075688772},"367":{"tf":1},"368":{"tf":1},"369":{"tf":2.449489742783178},"396":{"tf":1},"416":{"tf":1.4142135623730951},"582":{"tf":1},"585":{"tf":1.7320508075688772},"586":{"tf":1},"587":{"tf":1},"588":{"tf":2.449489742783178},"615":{"tf":1},"635":{"tf":1.4142135623730951},"792":{"tf":1},"795":{"tf":1.7320508075688772},"796":{"tf":1},"797":{"tf":1},"798":{"tf":2.449489742783178},"825":{"tf":1},"845":{"tf":1.4142135623730951}},"df":28}}}}}}}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"210":{"tf":1},"360":{"tf":1},"442":{"tf":1},"789":{"tf":1}},"df":5,"e":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"4":{"tf":1},"43":{"tf":1},"54":{"tf":1},"55":{"tf":1},"109":{"tf":1},"125":{"tf":1},"231":{"tf":1},"275":{"tf":1},"286":{"tf":1},"287":{"tf":1},"340":{"tf":1},"360":{"tf":1},"463":{"tf":1},"507":{"tf":1},"518":{"tf":1},"519":{"tf":1},"572":{"tf":1},"677":{"tf":1},"721":{"tf":1},"732":{"tf":1},"733":{"tf":1},"779":{"tf":1},"789":{"tf":1},"883":{"tf":1},"896":{"tf":1},"953":{"tf":1}},"df":27}}}},"t":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"5":{"tf":1},"14":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"21":{"tf":1},"26":{"tf":1},"31":{"tf":1},"37":{"tf":1},"50":{"tf":1.4142135623730951},"54":{"tf":1},"55":{"tf":1},"62":{"tf":1.4142135623730951},"67":{"tf":1},"73":{"tf":1},"90":{"tf":1},"97":{"tf":1},"137":{"tf":1},"140":{"tf":1},"149":{"tf":1},"176":{"tf":1},"178":{"tf":1},"181":{"tf":1},"215":{"tf":1.4142135623730951},"229":{"tf":1},"237":{"tf":1},"246":{"tf":1.4142135623730951},"247":{"tf":1.4142135623730951},"253":{"tf":1},"258":{"tf":1},"263":{"tf":1},"269":{"tf":1},"282":{"tf":1.4142135623730951},"286":{"tf":1},"287":{"tf":1},"294":{"tf":1.4142135623730951},"298":{"tf":1},"304":{"tf":1},"321":{"tf":1},"328":{"tf":1},"351":{"tf":1},"357":{"tf":1},"372":{"tf":1},"375":{"tf":1},"384":{"tf":1},"411":{"tf":1},"413":{"tf":1},"416":{"tf":1},"447":{"tf":1.4142135623730951},"461":{"tf":1},"469":{"tf":1},"478":{"tf":1.4142135623730951},"479":{"tf":1.4142135623730951},"485":{"tf":1},"490":{"tf":1},"495":{"tf":1},"501":{"tf":1},"514":{"tf":1.4142135623730951},"518":{"tf":1},"519":{"tf":1},"526":{"tf":1.4142135623730951},"530":{"tf":1},"536":{"tf":1},"553":{"tf":1},"560":{"tf":1},"591":{"tf":1},"594":{"tf":1},"603":{"tf":1},"630":{"tf":1},"632":{"tf":1},"635":{"tf":1},"661":{"tf":1.4142135623730951},"675":{"tf":1},"683":{"tf":1},"686":{"tf":1},"692":{"tf":1.7320508075688772},"693":{"tf":1.4142135623730951},"699":{"tf":1},"704":{"tf":1},"709":{"tf":1},"715":{"tf":1},"728":{"tf":1},"732":{"tf":1},"733":{"tf":1},"743":{"tf":1},"751":{"tf":1},"767":{"tf":1},"801":{"tf":1},"804":{"tf":1},"813":{"tf":1},"840":{"tf":1},"842":{"tf":1},"845":{"tf":1},"883":{"tf":1},"891":{"tf":1},"907":{"tf":1},"908":{"tf":1},"910":{"tf":1},"912":{"tf":1.4142135623730951},"922":{"tf":1},"934":{"tf":1},"937":{"tf":1},"941":{"tf":1},"947":{"tf":1},"948":{"tf":1},"956":{"tf":1},"958":{"tf":1},"961":{"tf":1},"965":{"tf":1}},"df":108}},"l":{"docs":{},"df":0,"d":{"docs":{"14":{"tf":1},"19":{"tf":1},"40":{"tf":1},"55":{"tf":1},"64":{"tf":1},"67":{"tf":1},"72":{"tf":1},"246":{"tf":1},"251":{"tf":1},"272":{"tf":1},"287":{"tf":1},"295":{"tf":1},"303":{"tf":1},"350":{"tf":1},"478":{"tf":1},"483":{"tf":1},"504":{"tf":1},"519":{"tf":1},"527":{"tf":1},"530":{"tf":1},"535":{"tf":1},"692":{"tf":1},"697":{"tf":1},"718":{"tf":1},"733":{"tf":1},"750":{"tf":1}},"df":26,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"21":{"tf":1},"39":{"tf":1},"40":{"tf":1},"253":{"tf":1},"271":{"tf":1},"272":{"tf":1},"485":{"tf":1},"503":{"tf":1},"504":{"tf":1},"717":{"tf":1},"718":{"tf":1},"747":{"tf":1}},"df":12,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"39":{"tf":1},"40":{"tf":1},"155":{"tf":1},"212":{"tf":2},"271":{"tf":1},"272":{"tf":1},"390":{"tf":1},"444":{"tf":2},"503":{"tf":1},"504":{"tf":1},"609":{"tf":1},"658":{"tf":2},"717":{"tf":1},"718":{"tf":1.4142135623730951},"819":{"tf":1},"936":{"tf":1}},"df":16}}}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"867":{"tf":1}},"df":1}}}}}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"867":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"909":{"tf":1}},"df":1}}}},"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"k":{"docs":{"195":{"tf":1.7320508075688772},"198":{"tf":1},"199":{"tf":1},"203":{"tf":1},"209":{"tf":1},"430":{"tf":1.7320508075688772},"433":{"tf":1},"434":{"tf":1},"438":{"tf":1},"649":{"tf":1.7320508075688772},"652":{"tf":1},"653":{"tf":1},"859":{"tf":1.7320508075688772},"862":{"tf":1},"863":{"tf":1}},"df":15,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"195":{"tf":1},"430":{"tf":1},"649":{"tf":1},"859":{"tf":1}},"df":4}}}}}}}}}}}}},"n":{"docs":{},"df":0,"d":{"docs":{"217":{"tf":1},"449":{"tf":1},"663":{"tf":1},"871":{"tf":1}},"df":4,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"217":{"tf":1},"449":{"tf":1},"663":{"tf":1},"871":{"tf":1}},"df":4}}}},"e":{"docs":{},"df":0,"t":{"docs":{"217":{"tf":1.4142135623730951},"449":{"tf":1.4142135623730951},"663":{"tf":1.4142135623730951},"871":{"tf":1.4142135623730951}},"df":4}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"217":{"tf":1},"449":{"tf":1},"663":{"tf":1},"871":{"tf":1}},"df":4}}}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{"94":{"tf":1},"125":{"tf":1},"325":{"tf":1},"360":{"tf":1},"557":{"tf":1},"764":{"tf":1}},"df":6,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1.7320508075688772},"8":{"tf":1},"237":{"tf":1},"240":{"tf":1},"469":{"tf":1},"472":{"tf":1},"683":{"tf":1},"888":{"tf":1}},"df":8}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"934":{"tf":1},"935":{"tf":1},"938":{"tf":1.4142135623730951}},"df":4}}}}}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"8":{"tf":1},"240":{"tf":1},"472":{"tf":1},"686":{"tf":1}},"df":4}}}}}}}}}},"l":{"docs":{"86":{"tf":1},"317":{"tf":1},"549":{"tf":1}},"df":3}},"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"264":{"tf":1},"496":{"tf":1}},"df":3}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4}}}}}}}},"k":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"350":{"tf":1},"354":{"tf":1}},"df":2}}}}}}}}}},"e":{"docs":{},"df":0,"r":{"docs":{"122":{"tf":1}},"df":1,"t":{"docs":{"295":{"tf":1},"917":{"tf":1}},"df":2}}}}},"u":{"docs":{"737":{"tf":1},"917":{"tf":1}},"df":2,"m":{"docs":{"15":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"73":{"tf":1},"83":{"tf":1},"112":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":2.23606797749979},"209":{"tf":1.7320508075688772},"247":{"tf":1.4142135623730951},"270":{"tf":1.4142135623730951},"304":{"tf":1},"305":{"tf":1},"314":{"tf":1},"343":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":2.23606797749979},"350":{"tf":1.4142135623730951},"479":{"tf":1.4142135623730951},"502":{"tf":1.4142135623730951},"536":{"tf":1},"546":{"tf":1},"575":{"tf":1},"578":{"tf":1.4142135623730951},"579":{"tf":2.23606797749979},"693":{"tf":1.4142135623730951},"716":{"tf":1.4142135623730951},"751":{"tf":1},"760":{"tf":1},"782":{"tf":1},"917":{"tf":1}},"df":30,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1},"247":{"tf":1},"479":{"tf":1},"693":{"tf":1}},"df":4}}}}}}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"43":{"tf":1},"116":{"tf":1.7320508075688772},"209":{"tf":2},"264":{"tf":1},"275":{"tf":1},"347":{"tf":1.7320508075688772},"496":{"tf":1},"507":{"tf":1},"579":{"tf":1.7320508075688772},"721":{"tf":1}},"df":11}}}},"p":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3}}}}}},"t":{"docs":{"21":{"tf":1},"63":{"tf":1}},"df":2,"c":{"docs":{},"df":0,"h":{"docs":{"189":{"tf":1},"192":{"tf":2},"229":{"tf":1.4142135623730951},"232":{"tf":1},"424":{"tf":1},"427":{"tf":2},"461":{"tf":1.4142135623730951},"464":{"tf":1},"643":{"tf":1},"646":{"tf":2},"675":{"tf":1.4142135623730951},"678":{"tf":1},"853":{"tf":1},"856":{"tf":2},"883":{"tf":1.7320508075688772}},"df":15}}},"c":{"docs":{},"df":0,"k":{"docs":{"867":{"tf":1}},"df":1}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"4":{"tf":1},"20":{"tf":1},"25":{"tf":1},"112":{"tf":1},"198":{"tf":1},"202":{"tf":1},"215":{"tf":1},"240":{"tf":1},"252":{"tf":1},"257":{"tf":1},"343":{"tf":1},"433":{"tf":1},"437":{"tf":1},"447":{"tf":1},"484":{"tf":1},"489":{"tf":1},"575":{"tf":1},"652":{"tf":1},"656":{"tf":1},"661":{"tf":1},"703":{"tf":1},"862":{"tf":1},"866":{"tf":1},"908":{"tf":1},"915":{"tf":1},"919":{"tf":1},"939":{"tf":1}},"df":27}}},"o":{"docs":{},"df":0,"g":{"docs":{"43":{"tf":1},"275":{"tf":1},"507":{"tf":1},"721":{"tf":1}},"df":4},"c":{"docs":{},"df":0,"k":{"docs":{"927":{"tf":1.4142135623730951}},"df":1,"i":{"docs":{"210":{"tf":1},"442":{"tf":1},"929":{"tf":1}},"df":3,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"926":{"tf":1}},"df":1}}}}}}},"a":{"docs":{},"df":0,"u":{"docs":{"101":{"tf":1},"134":{"tf":1},"332":{"tf":1},"369":{"tf":1},"564":{"tf":1},"588":{"tf":1},"771":{"tf":1},"798":{"tf":1}},"df":8},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"138":{"tf":1},"373":{"tf":1},"592":{"tf":1},"802":{"tf":1}},"df":4}}}}}}},"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{"122":{"tf":1},"210":{"tf":1},"357":{"tf":1},"442":{"tf":1},"527":{"tf":1},"718":{"tf":1}},"df":6,"t":{"docs":{"232":{"tf":1},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":4}}}}},"z":{"docs":{},"df":0,"w":{"docs":{"15":{"tf":1},"51":{"tf":1},"63":{"tf":1},"64":{"tf":1},"68":{"tf":1},"81":{"tf":1},"109":{"tf":1.7320508075688772},"134":{"tf":1},"204":{"tf":1},"207":{"tf":1.4142135623730951},"216":{"tf":1.4142135623730951},"247":{"tf":1},"283":{"tf":1},"299":{"tf":1},"312":{"tf":1},"340":{"tf":1.7320508075688772},"356":{"tf":1},"369":{"tf":1},"448":{"tf":1.4142135623730951},"479":{"tf":1},"515":{"tf":1},"531":{"tf":1},"544":{"tf":1},"572":{"tf":1.7320508075688772},"588":{"tf":1},"662":{"tf":1.4142135623730951},"693":{"tf":1},"698":{"tf":1},"729":{"tf":1},"741":{"tf":1},"758":{"tf":1},"779":{"tf":1.7320508075688772},"798":{"tf":1},"870":{"tf":1.4142135623730951},"908":{"tf":1},"909":{"tf":1}},"df":36,".":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{"744":{"tf":1}},"df":1}}}}}}}}},"g":{"docs":{},"df":0,"l":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"37":{"tf":1},"38":{"tf":1},"90":{"tf":1},"122":{"tf":1.4142135623730951},"125":{"tf":1},"253":{"tf":1},"269":{"tf":1},"270":{"tf":1},"321":{"tf":1},"350":{"tf":2},"357":{"tf":1.4142135623730951},"360":{"tf":1},"501":{"tf":1},"502":{"tf":1},"553":{"tf":1},"710":{"tf":1},"715":{"tf":1},"716":{"tf":1}},"df":18,":":{"docs":{},"df":0,"b":{"docs":{},"df":0,"t":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"k":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"55":{"tf":1},"287":{"tf":1},"519":{"tf":1},"733":{"tf":1},"946":{"tf":1},"965":{"tf":1}},"df":6}}}},"t":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"k":{"docs":{"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951}},"df":2}}}},"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}},"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"14":{"tf":1},"20":{"tf":1},"21":{"tf":1},"66":{"tf":1},"246":{"tf":1},"478":{"tf":1},"484":{"tf":1},"529":{"tf":1},"692":{"tf":1},"867":{"tf":1.4142135623730951},"909":{"tf":1},"917":{"tf":1},"935":{"tf":1}},"df":14,"e":{"docs":{},"df":0,"m":{"docs":{"21":{"tf":1.4142135623730951}},"df":1,"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"z":{"docs":{"3":{"tf":1}},"df":1}}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"56":{"tf":1},"288":{"tf":1},"520":{"tf":1},"734":{"tf":1}},"df":4}}}}}}}}}}},"k":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"122":{"tf":1}},"df":1}}}}}}}}},"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"28":{"tf":1},"56":{"tf":1},"82":{"tf":1},"131":{"tf":1},"260":{"tf":1},"288":{"tf":1},"313":{"tf":1},"366":{"tf":1},"492":{"tf":1},"520":{"tf":1},"545":{"tf":1},"585":{"tf":1},"706":{"tf":1},"734":{"tf":1},"759":{"tf":1},"795":{"tf":1}},"df":16}}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"x":{"docs":{"116":{"tf":1.4142135623730951},"225":{"tf":1},"226":{"tf":1},"347":{"tf":1.4142135623730951},"457":{"tf":1},"458":{"tf":1},"579":{"tf":1.4142135623730951},"671":{"tf":1},"672":{"tf":1},"879":{"tf":1}},"df":10}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"11":{"tf":1},"21":{"tf":1},"122":{"tf":1.4142135623730951},"243":{"tf":1},"351":{"tf":1},"354":{"tf":1},"357":{"tf":1.4142135623730951},"475":{"tf":1},"689":{"tf":1},"918":{"tf":1},"934":{"tf":1}},"df":11,"i":{"docs":{"26":{"tf":1},"81":{"tf":1},"258":{"tf":1},"312":{"tf":1},"490":{"tf":1},"544":{"tf":1},"704":{"tf":1},"758":{"tf":1}},"df":8,"e":{"docs":{},"df":0,"r":{"docs":{"82":{"tf":1},"83":{"tf":1},"87":{"tf":1},"313":{"tf":1},"314":{"tf":1},"318":{"tf":1},"545":{"tf":1},"546":{"tf":1},"550":{"tf":1},"759":{"tf":1},"761":{"tf":1}},"df":11,"t":{"docs":{"3":{"tf":1},"27":{"tf":1},"81":{"tf":1},"259":{"tf":1},"312":{"tf":1},"491":{"tf":1},"544":{"tf":1},"705":{"tf":1},"758":{"tf":1}},"df":9}}}}}}}}},"g":{"docs":{"4":{"tf":1},"38":{"tf":1},"182":{"tf":1},"270":{"tf":1},"417":{"tf":1},"502":{"tf":1},"636":{"tf":1},"716":{"tf":1},"846":{"tf":1}},"df":9,"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{"68":{"tf":1},"299":{"tf":1},"531":{"tf":1}},"df":3,"l":{"docs":{"37":{"tf":1},"90":{"tf":1},"158":{"tf":1},"269":{"tf":1},"321":{"tf":1},"393":{"tf":1},"501":{"tf":1},"553":{"tf":1},"612":{"tf":1},"715":{"tf":1},"822":{"tf":1}},"df":11},"x":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4},"v":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4},"a":{"docs":{"103":{"tf":1},"231":{"tf":1.4142135623730951},"334":{"tf":1},"463":{"tf":1.4142135623730951},"566":{"tf":1},"677":{"tf":1.4142135623730951},"773":{"tf":1},"883":{"tf":1.4142135623730951}},"df":8},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{"168":{"tf":1},"403":{"tf":1},"622":{"tf":1},"832":{"tf":1}},"df":4,"p":{"docs":{"109":{"tf":1},"168":{"tf":1},"340":{"tf":1},"403":{"tf":1},"572":{"tf":1},"622":{"tf":1},"779":{"tf":1},"832":{"tf":1}},"df":8},"i":{"docs":{"232":{"tf":1},"464":{"tf":1},"678":{"tf":1},"883":{"tf":1}},"df":4}}}}}}}}}}}},"w":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2},"f":{"8":{"docs":{"128":{"tf":1},"131":{"tf":1},"133":{"tf":1},"134":{"tf":1},"363":{"tf":1},"366":{"tf":1},"368":{"tf":1},"369":{"tf":1},"582":{"tf":1},"585":{"tf":1},"587":{"tf":1},"588":{"tf":1},"792":{"tf":1},"795":{"tf":1},"797":{"tf":1},"798":{"tf":1}},"df":16},"docs":{},"df":0},"j":{"docs":{"128":{"tf":1},"158":{"tf":1},"363":{"tf":1},"393":{"tf":1},"582":{"tf":1},"612":{"tf":1},"792":{"tf":1},"822":{"tf":1}},"df":8}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"214":{"tf":1.7320508075688772},"446":{"tf":1.7320508075688772},"660":{"tf":1.7320508075688772},"869":{"tf":1.7320508075688772}},"df":4}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"125":{"tf":1},"192":{"tf":1},"195":{"tf":1},"360":{"tf":1},"427":{"tf":1},"430":{"tf":1},"646":{"tf":1},"649":{"tf":1},"856":{"tf":1},"859":{"tf":1}},"df":10,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"149":{"tf":1},"384":{"tf":1},"603":{"tf":1},"813":{"tf":1}},"df":4}}}}}}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"k":{"docs":{"43":{"tf":1},"195":{"tf":2.449489742783178},"198":{"tf":1.4142135623730951},"199":{"tf":1.7320508075688772},"202":{"tf":1},"231":{"tf":1},"232":{"tf":1},"275":{"tf":1},"430":{"tf":2.449489742783178},"433":{"tf":1.4142135623730951},"434":{"tf":1.7320508075688772},"437":{"tf":1},"463":{"tf":1},"464":{"tf":1},"507":{"tf":1},"649":{"tf":2.449489742783178},"652":{"tf":1.4142135623730951},"653":{"tf":1.7320508075688772},"656":{"tf":1},"677":{"tf":1},"678":{"tf":1},"721":{"tf":1},"859":{"tf":2.449489742783178},"862":{"tf":1.4142135623730951},"863":{"tf":1.7320508075688772},"866":{"tf":1},"883":{"tf":1.4142135623730951}},"df":27}}}}}}}}}},"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"73":{"tf":1},"122":{"tf":1},"214":{"tf":1.4142135623730951},"304":{"tf":1},"357":{"tf":1},"446":{"tf":1.4142135623730951},"536":{"tf":1},"660":{"tf":1.4142135623730951},"742":{"tf":1},"748":{"tf":1},"749":{"tf":1},"869":{"tf":1.4142135623730951}},"df":12}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"m":{"docs":{},"df":0,"u":{"docs":{"199":{"tf":1},"434":{"tf":1},"653":{"tf":1},"863":{"tf":1}},"df":4}}}}}}}}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"143":{"tf":1},"378":{"tf":1},"597":{"tf":1},"807":{"tf":1}},"df":4}}}}}}}}}}}}},"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"195":{"tf":1.4142135623730951},"430":{"tf":1.4142135623730951},"649":{"tf":1.4142135623730951},"859":{"tf":1.4142135623730951}},"df":4}}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"169":{"tf":2.6457513110645907},"171":{"tf":1},"176":{"tf":1.4142135623730951},"177":{"tf":1},"178":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"231":{"tf":1},"232":{"tf":1},"296":{"tf":1},"404":{"tf":2.6457513110645907},"406":{"tf":1},"411":{"tf":1.4142135623730951},"412":{"tf":1},"413":{"tf":1.4142135623730951},"427":{"tf":1.4142135623730951},"463":{"tf":1},"464":{"tf":1},"623":{"tf":2.6457513110645907},"625":{"tf":1},"630":{"tf":1.4142135623730951},"631":{"tf":1},"632":{"tf":1.4142135623730951},"646":{"tf":1.4142135623730951},"677":{"tf":1},"678":{"tf":1},"833":{"tf":2.6457513110645907},"835":{"tf":1},"840":{"tf":1.4142135623730951},"841":{"tf":1},"842":{"tf":1.4142135623730951},"856":{"tf":1.4142135623730951},"883":{"tf":1.4142135623730951},"949":{"tf":1},"953":{"tf":1.4142135623730951},"962":{"tf":1},"963":{"tf":1}},"df":36}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"215":{"tf":1},"447":{"tf":1},"661":{"tf":1}},"df":3}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"f":{"docs":{"896":{"tf":1}},"df":1}}}}}}}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"934":{"tf":1}},"df":1}}}}}}}}},"i":{"docs":{},"df":0,"g":{"docs":{"161":{"tf":1},"396":{"tf":1},"615":{"tf":1},"825":{"tf":1}},"df":4}}}},"r":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":2.449489742783178},"59":{"tf":1},"62":{"tf":1},"66":{"tf":1.4142135623730951},"67":{"tf":1},"86":{"tf":1},"97":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"119":{"tf":1},"125":{"tf":1},"131":{"tf":1},"132":{"tf":1},"133":{"tf":1},"150":{"tf":1.4142135623730951},"177":{"tf":1},"192":{"tf":1},"215":{"tf":1},"223":{"tf":1},"224":{"tf":1},"226":{"tf":1},"229":{"tf":1},"237":{"tf":1.7320508075688772},"246":{"tf":1.4142135623730951},"251":{"tf":1},"252":{"tf":1.4142135623730951},"253":{"tf":2.23606797749979},"291":{"tf":1},"297":{"tf":1},"298":{"tf":1},"317":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"350":{"tf":1},"354":{"tf":1},"360":{"tf":1},"366":{"tf":1},"367":{"tf":1},"368":{"tf":1},"385":{"tf":1.4142135623730951},"412":{"tf":1},"427":{"tf":1},"447":{"tf":1},"455":{"tf":1},"456":{"tf":1},"458":{"tf":1},"461":{"tf":1},"469":{"tf":1.7320508075688772},"478":{"tf":1.4142135623730951},"483":{"tf":1.4142135623730951},"484":{"tf":1.4142135623730951},"485":{"tf":2},"523":{"tf":1},"526":{"tf":1},"529":{"tf":1.7320508075688772},"530":{"tf":1},"549":{"tf":1},"560":{"tf":1},"578":{"tf":1.4142135623730951},"579":{"tf":1.4142135623730951},"585":{"tf":1},"586":{"tf":1},"587":{"tf":1},"604":{"tf":1.4142135623730951},"631":{"tf":1},"646":{"tf":1},"661":{"tf":1},"669":{"tf":1},"670":{"tf":1},"672":{"tf":1},"675":{"tf":1},"683":{"tf":1.7320508075688772},"692":{"tf":1.4142135623730951},"697":{"tf":1.4142135623730951},"698":{"tf":1},"699":{"tf":3},"737":{"tf":1},"740":{"tf":1.4142135623730951},"741":{"tf":1},"743":{"tf":1},"744":{"tf":1},"767":{"tf":1},"785":{"tf":1.4142135623730951},"795":{"tf":1},"796":{"tf":1},"797":{"tf":1},"814":{"tf":1.4142135623730951},"841":{"tf":1},"856":{"tf":1},"877":{"tf":1},"883":{"tf":1},"891":{"tf":1},"892":{"tf":1},"894":{"tf":1.4142135623730951},"896":{"tf":1},"900":{"tf":1},"908":{"tf":1},"909":{"tf":2.23606797749979},"912":{"tf":1},"913":{"tf":1},"914":{"tf":1.4142135623730951},"917":{"tf":1.7320508075688772},"919":{"tf":1},"928":{"tf":1},"937":{"tf":1},"938":{"tf":1.7320508075688772},"951":{"tf":1},"953":{"tf":1}},"df":111,"e":{"docs":{},"df":0,"t":{"docs":{"15":{"tf":1},"20":{"tf":1},"94":{"tf":1},"247":{"tf":1},"252":{"tf":1},"325":{"tf":1},"479":{"tf":1},"484":{"tf":1},"557":{"tf":1},"693":{"tf":1},"698":{"tf":1},"699":{"tf":1},"764":{"tf":1},"867":{"tf":1}},"df":14},"n":{"docs":{},"df":0,"d":{"docs":{"20":{"tf":1},"484":{"tf":1},"698":{"tf":1}},"df":3}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{"21":{"tf":1.4142135623730951},"62":{"tf":1},"66":{"tf":1},"67":{"tf":1},"237":{"tf":1},"240":{"tf":1},"253":{"tf":1},"294":{"tf":1.4142135623730951},"297":{"tf":1},"298":{"tf":1},"328":{"tf":1},"469":{"tf":1},"485":{"tf":1},"526":{"tf":1},"529":{"tf":1},"530":{"tf":1},"683":{"tf":1},"699":{"tf":1},"743":{"tf":1},"744":{"tf":1.4142135623730951}},"df":20}}}}}},"k":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"63":{"tf":1},"64":{"tf":1}},"df":2}}}}},"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,".":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"913":{"tf":1},"914":{"tf":1}},"df":2}}}}}}}}}}}}}}}},"k":{"docs":{"125":{"tf":1},"360":{"tf":1},"789":{"tf":1}},"df":3}},"t":{"docs":{},"df":0,"u":{"docs":{"146":{"tf":1},"357":{"tf":1},"381":{"tf":1},"600":{"tf":1},"810":{"tf":1}},"df":5,"s":{"docs":{},"df":0,"z":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"27":{"tf":1},"259":{"tf":1},"491":{"tf":1},"705":{"tf":1}},"df":4}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"28":{"tf":1},"260":{"tf":1},"492":{"tf":1},"706":{"tf":1}},"df":4}}}}}}},"t":{"docs":{"182":{"tf":1},"232":{"tf":1},"417":{"tf":1},"464":{"tf":1},"636":{"tf":1},"678":{"tf":1},"846":{"tf":1},"883":{"tf":1},"950":{"tf":1}},"df":9,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"760":{"tf":1},"761":{"tf":1}},"df":2}}}}}},"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"155":{"tf":1.4142135623730951},"183":{"tf":1},"390":{"tf":1.4142135623730951},"418":{"tf":1},"609":{"tf":1.4142135623730951},"637":{"tf":1},"819":{"tf":1.4142135623730951},"847":{"tf":1}},"df":8}}}}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"354":{"tf":1},"909":{"tf":1.4142135623730951}},"df":2,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"350":{"tf":1}},"df":1}}}}}}}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1},"21":{"tf":1},"67":{"tf":1},"103":{"tf":1},"125":{"tf":1},"131":{"tf":1},"158":{"tf":1.4142135623730951},"171":{"tf":1},"187":{"tf":1},"210":{"tf":1},"213":{"tf":1},"298":{"tf":1},"334":{"tf":1},"350":{"tf":1.4142135623730951},"351":{"tf":1},"360":{"tf":1},"366":{"tf":1},"393":{"tf":1.4142135623730951},"406":{"tf":1},"422":{"tf":1},"442":{"tf":1},"445":{"tf":1},"530":{"tf":1},"566":{"tf":1},"585":{"tf":1},"612":{"tf":1.4142135623730951},"625":{"tf":1},"641":{"tf":1},"659":{"tf":1},"749":{"tf":1},"750":{"tf":1},"773":{"tf":1},"789":{"tf":1},"795":{"tf":1},"822":{"tf":1.4142135623730951},"835":{"tf":1},"851":{"tf":1},"909":{"tf":1.7320508075688772},"927":{"tf":1.4142135623730951},"928":{"tf":1},"935":{"tf":1},"948":{"tf":1},"953":{"tf":1}},"df":43,"t":{"docs":{"4":{"tf":1.4142135623730951},"21":{"tf":1},"26":{"tf":1},"91":{"tf":1},"195":{"tf":1},"209":{"tf":1},"229":{"tf":1},"258":{"tf":1},"430":{"tf":1},"461":{"tf":1},"485":{"tf":1},"490":{"tf":1},"554":{"tf":1},"649":{"tf":1},"675":{"tf":1},"698":{"tf":1},"699":{"tf":1},"704":{"tf":1},"859":{"tf":1},"883":{"tf":1}},"df":20}}},"h":{"docs":{"122":{"tf":1},"125":{"tf":1},"128":{"tf":1},"134":{"tf":1},"220":{"tf":1},"354":{"tf":1},"357":{"tf":1},"360":{"tf":1},"363":{"tf":1},"369":{"tf":1},"452":{"tf":1},"582":{"tf":1},"588":{"tf":1},"666":{"tf":1},"789":{"tf":1},"792":{"tf":1},"798":{"tf":1},"874":{"tf":1},"897":{"tf":1}},"df":19,"t":{"docs":{"4":{"tf":1},"116":{"tf":1},"158":{"tf":1},"161":{"tf":1},"253":{"tf":1},"347":{"tf":1},"393":{"tf":1},"396":{"tf":1},"485":{"tf":1},"579":{"tf":1},"612":{"tf":1},"615":{"tf":1},"747":{"tf":1},"822":{"tf":1},"825":{"tf":1},"893":{"tf":1},"918":{"tf":1},"950":{"tf":1}},"df":18},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}},"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"116":{"tf":1},"347":{"tf":1},"579":{"tf":1}},"df":3}}}}}}}}}},"t":{"docs":{"210":{"tf":1},"442":{"tf":1}},"df":2},"u":{"docs":{"224":{"tf":1},"456":{"tf":1},"670":{"tf":1},"878":{"tf":1},"931":{"tf":1}},"df":5}},"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{"192":{"tf":1},"427":{"tf":1},"646":{"tf":1},"856":{"tf":1},"892":{"tf":1},"894":{"tf":1},"908":{"tf":1},"909":{"tf":1},"912":{"tf":1},"915":{"tf":1},"917":{"tf":2},"923":{"tf":1.4142135623730951},"938":{"tf":1}},"df":13,"t":{"docs":{"47":{"tf":1},"139":{"tf":1},"149":{"tf":1},"279":{"tf":1},"374":{"tf":1},"384":{"tf":1},"511":{"tf":1},"593":{"tf":1},"603":{"tf":1},"725":{"tf":1},"803":{"tf":1},"813":{"tf":1},"915":{"tf":1},"919":{"tf":1}},"df":14},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,"f":{"docs":{"77":{"tf":1},"308":{"tf":1},"540":{"tf":1}},"df":3}}}}}}},"s":{"docs":{},"df":0,"s":{"docs":{"125":{"tf":1},"351":{"tf":1.4142135623730951},"360":{"tf":1}},"df":3}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"356":{"tf":1}},"df":1}}}}},"y":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"55":{"tf":1},"287":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":4}}}}}}}},"u":{"docs":{},"df":0,"f":{"docs":{"895":{"tf":1}},"df":1},"n":{"docs":{},"df":0,"d":{"docs":{"962":{"tf":1}},"df":1}}}},"k":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"195":{"tf":1.7320508075688772},"215":{"tf":1},"430":{"tf":1.7320508075688772},"447":{"tf":1},"649":{"tf":1.7320508075688772},"661":{"tf":1},"859":{"tf":1.7320508075688772},"896":{"tf":1}},"df":9}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"351":{"tf":1},"747":{"tf":1},"888":{"tf":1},"923":{"tf":1},"948":{"tf":1}},"df":6,"l":{"docs":{"64":{"tf":1},"122":{"tf":1},"295":{"tf":1},"357":{"tf":1},"527":{"tf":1},"699":{"tf":1},"893":{"tf":1},"909":{"tf":1},"956":{"tf":1}},"df":9}}},"f":{"docs":{"199":{"tf":1.4142135623730951},"240":{"tf":1},"434":{"tf":1.4142135623730951},"653":{"tf":1.4142135623730951},"741":{"tf":1},"863":{"tf":1.4142135623730951},"901":{"tf":1}},"df":7,"i":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{"81":{"tf":1},"169":{"tf":1},"312":{"tf":1},"404":{"tf":1},"544":{"tf":1},"623":{"tf":1},"758":{"tf":1},"833":{"tf":1},"897":{"tf":1},"956":{"tf":1}},"df":10,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"189":{"tf":1},"192":{"tf":1},"214":{"tf":1},"424":{"tf":1},"427":{"tf":1},"446":{"tf":1},"643":{"tf":1},"646":{"tf":1},"660":{"tf":1},"853":{"tf":1},"856":{"tf":1},"869":{"tf":1}},"df":12}}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2}}}}}}}}}}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"68":{"tf":1.7320508075688772},"97":{"tf":1},"299":{"tf":1.7320508075688772},"328":{"tf":1},"531":{"tf":1.7320508075688772},"560":{"tf":1},"744":{"tf":1.4142135623730951},"767":{"tf":1},"947":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"r":{"docs":{"350":{"tf":1}},"df":1,"t":{"docs":{"40":{"tf":1},"119":{"tf":1.4142135623730951},"122":{"tf":1},"226":{"tf":1},"272":{"tf":1},"350":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1},"458":{"tf":1},"504":{"tf":1},"672":{"tf":1},"718":{"tf":1},"782":{"tf":1.4142135623730951},"896":{"tf":1}},"df":14},"a":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"68":{"tf":1},"299":{"tf":1},"531":{"tf":1}},"df":3}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"214":{"tf":1},"446":{"tf":1},"660":{"tf":1},"869":{"tf":1}},"df":4}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"942":{"tf":1}},"df":1}}}}}}}}}}},"a":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1},"66":{"tf":1},"128":{"tf":1},"155":{"tf":1},"168":{"tf":1},"258":{"tf":1},"350":{"tf":1},"363":{"tf":1},"390":{"tf":1},"403":{"tf":1},"490":{"tf":1},"529":{"tf":1},"582":{"tf":1},"609":{"tf":1},"622":{"tf":1},"704":{"tf":1},"792":{"tf":1},"819":{"tf":1},"832":{"tf":1},"897":{"tf":1},"917":{"tf":1}},"df":21},"l":{"docs":{},"df":0,"t":{"docs":{"116":{"tf":1.4142135623730951},"125":{"tf":1},"347":{"tf":1.4142135623730951},"350":{"tf":1},"360":{"tf":1},"579":{"tf":1.4142135623730951},"786":{"tf":1.4142135623730951},"897":{"tf":1.7320508075688772},"900":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1},"441":{"tf":1}},"df":2}}}}}}},"u":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"897":{"tf":1}},"df":1}}}}}}}}}}}}}},"r":{"docs":{"892":{"tf":1}},"df":1}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2,"w":{"docs":{},"df":0,"i":{"docs":{"81":{"tf":1},"312":{"tf":1},"544":{"tf":1},"758":{"tf":1}},"df":4}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}}}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"119":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"119":{"tf":1},"128":{"tf":1},"143":{"tf":1},"152":{"tf":1},"155":{"tf":1},"158":{"tf":1.7320508075688772},"168":{"tf":1},"181":{"tf":1},"182":{"tf":1.4142135623730951},"192":{"tf":1},"354":{"tf":1},"363":{"tf":1},"378":{"tf":1},"387":{"tf":1},"390":{"tf":1},"393":{"tf":1.4142135623730951},"403":{"tf":1},"416":{"tf":1},"417":{"tf":1.4142135623730951},"427":{"tf":1},"582":{"tf":1},"597":{"tf":1},"606":{"tf":1},"609":{"tf":1},"612":{"tf":1.4142135623730951},"622":{"tf":1},"635":{"tf":1},"636":{"tf":1.4142135623730951},"646":{"tf":1},"792":{"tf":1},"807":{"tf":1},"816":{"tf":1},"819":{"tf":1},"822":{"tf":1.4142135623730951},"832":{"tf":1},"845":{"tf":1},"846":{"tf":1.4142135623730951},"856":{"tf":1}},"df":38,"t":{"docs":{"144":{"tf":1},"379":{"tf":1},"598":{"tf":1},"699":{"tf":1},"808":{"tf":1}},"df":5}}}}}},"e":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1},"143":{"tf":1},"378":{"tf":1},"597":{"tf":1},"807":{"tf":1}},"df":5,"t":{"docs":{"39":{"tf":1},"64":{"tf":1},"122":{"tf":1},"125":{"tf":1},"271":{"tf":1},"295":{"tf":1},"298":{"tf":1},"356":{"tf":1},"357":{"tf":1},"360":{"tf":1},"503":{"tf":1},"527":{"tf":1},"717":{"tf":1},"741":{"tf":1},"789":{"tf":1}},"df":15,"i":{"docs":{},"df":0,"g":{"docs":{"3":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{},"df":0,"a":{"docs":{},"df":0,"h":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"y":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"350":{"tf":1}},"df":1}}}}}},"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{"892":{"tf":1}},"df":1}}}}}}}}}},"h":{"docs":{"4":{"tf":1},"15":{"tf":1.4142135623730951},"27":{"tf":1},"39":{"tf":1},"50":{"tf":1},"66":{"tf":1},"73":{"tf":1},"74":{"tf":1.4142135623730951},"77":{"tf":1},"97":{"tf":1},"106":{"tf":1},"109":{"tf":1},"115":{"tf":1},"119":{"tf":1},"121":{"tf":1},"122":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"134":{"tf":1},"145":{"tf":1},"164":{"tf":1},"167":{"tf":1},"168":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"177":{"tf":1},"183":{"tf":1},"199":{"tf":1},"210":{"tf":1},"211":{"tf":1},"212":{"tf":1},"213":{"tf":1},"214":{"tf":1},"223":{"tf":1},"247":{"tf":1.4142135623730951},"259":{"tf":1},"271":{"tf":1},"282":{"tf":1},"304":{"tf":1},"305":{"tf":1.4142135623730951},"308":{"tf":1},"328":{"tf":1},"337":{"tf":1},"340":{"tf":1},"346":{"tf":1},"356":{"tf":1},"357":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951},"369":{"tf":1},"380":{"tf":1},"399":{"tf":1},"402":{"tf":1},"403":{"tf":1.4142135623730951},"411":{"tf":1.4142135623730951},"412":{"tf":1},"418":{"tf":1},"434":{"tf":1},"442":{"tf":1},"443":{"tf":1},"444":{"tf":1},"445":{"tf":1},"446":{"tf":1},"455":{"tf":1},"479":{"tf":1.4142135623730951},"491":{"tf":1},"503":{"tf":1},"514":{"tf":1},"529":{"tf":1},"536":{"tf":1},"537":{"tf":1.4142135623730951},"540":{"tf":1},"560":{"tf":1},"569":{"tf":1},"572":{"tf":1},"578":{"tf":1},"588":{"tf":1},"599":{"tf":1},"618":{"tf":1},"621":{"tf":1},"622":{"tf":1.4142135623730951},"630":{"tf":1.4142135623730951},"631":{"tf":1},"637":{"tf":1},"653":{"tf":1},"657":{"tf":1},"658":{"tf":1},"659":{"tf":1},"660":{"tf":1},"669":{"tf":1},"693":{"tf":1.4142135623730951},"699":{"tf":1},"705":{"tf":1},"717":{"tf":1},"728":{"tf":1},"751":{"tf":1},"752":{"tf":1.4142135623730951},"755":{"tf":1},"767":{"tf":1},"776":{"tf":1},"779":{"tf":1},"785":{"tf":1},"798":{"tf":1},"809":{"tf":1},"828":{"tf":1},"831":{"tf":1},"832":{"tf":1.4142135623730951},"840":{"tf":1.4142135623730951},"841":{"tf":1},"847":{"tf":1},"863":{"tf":1},"868":{"tf":1},"869":{"tf":1},"877":{"tf":1},"892":{"tf":1},"894":{"tf":1.4142135623730951},"901":{"tf":1},"903":{"tf":1},"912":{"tf":1},"913":{"tf":1.4142135623730951},"917":{"tf":1.4142135623730951},"919":{"tf":1.4142135623730951},"924":{"tf":1},"938":{"tf":1},"946":{"tf":1},"961":{"tf":1},"962":{"tf":1},"963":{"tf":1}},"df":125},"l":{"docs":{},"df":0,"b":{"docs":{"903":{"tf":1}},"df":1,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"956":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{"351":{"tf":1}},"df":1}}}}}}}}}},"i":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"896":{"tf":1}},"df":1}}}}}}}}}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"948":{"tf":1}},"df":1}}}}}}}}}}},"e":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"102":{"tf":1.4142135623730951},"103":{"tf":1},"105":{"tf":1},"116":{"tf":1},"131":{"tf":1},"132":{"tf":1},"150":{"tf":1},"168":{"tf":1},"169":{"tf":1},"171":{"tf":1},"176":{"tf":1},"182":{"tf":1},"204":{"tf":1},"231":{"tf":1},"232":{"tf":1},"333":{"tf":1.4142135623730951},"334":{"tf":1},"336":{"tf":1},"347":{"tf":1},"366":{"tf":1},"367":{"tf":1},"385":{"tf":1},"403":{"tf":1},"404":{"tf":1},"406":{"tf":1},"411":{"tf":1},"417":{"tf":1},"439":{"tf":1},"463":{"tf":1},"464":{"tf":1},"565":{"tf":1.4142135623730951},"566":{"tf":1},"568":{"tf":1},"579":{"tf":1},"585":{"tf":1},"586":{"tf":1},"604":{"tf":1},"622":{"tf":1},"623":{"tf":1},"625":{"tf":1},"630":{"tf":1},"636":{"tf":1},"677":{"tf":1},"678":{"tf":1},"772":{"tf":1.4142135623730951},"773":{"tf":1},"775":{"tf":1},"795":{"tf":1},"796":{"tf":1},"814":{"tf":1},"832":{"tf":1},"833":{"tf":1},"835":{"tf":1},"840":{"tf":1},"846":{"tf":1},"883":{"tf":1.4142135623730951},"909":{"tf":1},"912":{"tf":1},"917":{"tf":1.7320508075688772},"938":{"tf":1},"951":{"tf":1}},"df":61,"e":{"docs":{},"df":0,"r":{"docs":{"102":{"tf":1},"333":{"tf":1},"565":{"tf":1},"772":{"tf":1}},"df":4,"t":{"docs":{"26":{"tf":1},"38":{"tf":1},"101":{"tf":1},"134":{"tf":1},"140":{"tf":1.4142135623730951},"203":{"tf":1},"204":{"tf":1},"208":{"tf":1},"209":{"tf":1},"216":{"tf":1.4142135623730951},"258":{"tf":1},"270":{"tf":1},"332":{"tf":1},"369":{"tf":1},"375":{"tf":1.4142135623730951},"438":{"tf":1},"439":{"tf":1},"441":{"tf":1},"448":{"tf":1.4142135623730951},"490":{"tf":1},"502":{"tf":1},"564":{"tf":1},"588":{"tf":1},"594":{"tf":1.4142135623730951},"662":{"tf":1.4142135623730951},"704":{"tf":1},"716":{"tf":1},"771":{"tf":1},"798":{"tf":1},"804":{"tf":1.4142135623730951},"870":{"tf":1.4142135623730951}},"df":31}}}}}},"c":{"docs":{},"df":0,"t":{"docs":{"203":{"tf":1},"215":{"tf":1},"438":{"tf":1},"439":{"tf":1.4142135623730951},"447":{"tf":1},"661":{"tf":1},"941":{"tf":1}},"df":7,"i":{"docs":{},"df":0,"t":{"docs":{"207":{"tf":1}},"df":1}},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"207":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1},"441":{"tf":1}},"df":2}}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{"209":{"tf":1}},"df":1}}}}}},"t":{"docs":{"119":{"tf":1},"122":{"tf":1},"357":{"tf":1}},"df":3}},"n":{"docs":{},"df":0,"d":{"docs":{"5":{"tf":1}},"df":1}},"t":{"docs":{"203":{"tf":1},"438":{"tf":1},"941":{"tf":1.7320508075688772},"956":{"tf":1}},"df":4,"z":{"docs":{"20":{"tf":1},"66":{"tf":1},"122":{"tf":1.7320508075688772},"128":{"tf":1},"131":{"tf":1.4142135623730951},"132":{"tf":1},"134":{"tf":1.4142135623730951},"161":{"tf":1},"171":{"tf":1.4142135623730951},"181":{"tf":1},"182":{"tf":1},"187":{"tf":2.449489742783178},"188":{"tf":1},"189":{"tf":1.4142135623730951},"207":{"tf":1},"231":{"tf":1},"232":{"tf":1},"252":{"tf":1},"253":{"tf":1},"357":{"tf":1.7320508075688772},"363":{"tf":1},"366":{"tf":1.4142135623730951},"367":{"tf":1},"369":{"tf":1.4142135623730951},"396":{"tf":1},"406":{"tf":1.4142135623730951},"416":{"tf":1},"417":{"tf":1},"422":{"tf":2.449489742783178},"423":{"tf":1},"424":{"tf":1.4142135623730951},"463":{"tf":1},"464":{"tf":1},"484":{"tf":1},"529":{"tf":1},"582":{"tf":1},"585":{"tf":1.4142135623730951},"586":{"tf":1},"588":{"tf":1.4142135623730951},"615":{"tf":1},"625":{"tf":1.4142135623730951},"635":{"tf":1},"636":{"tf":1},"641":{"tf":2.449489742783178},"642":{"tf":1},"643":{"tf":1.4142135623730951},"677":{"tf":1},"678":{"tf":1},"698":{"tf":1},"792":{"tf":1},"795":{"tf":1.4142135623730951},"796":{"tf":1},"798":{"tf":1.4142135623730951},"825":{"tf":1},"835":{"tf":1.4142135623730951},"845":{"tf":1},"846":{"tf":1},"851":{"tf":2.449489742783178},"852":{"tf":1},"853":{"tf":1.4142135623730951},"883":{"tf":1.4142135623730951},"897":{"tf":1},"901":{"tf":1},"917":{"tf":1.7320508075688772},"931":{"tf":1},"941":{"tf":1.4142135623730951},"948":{"tf":1},"951":{"tf":1},"953":{"tf":1},"956":{"tf":1.4142135623730951},"960":{"tf":1}},"df":71,"t":{"docs":{"116":{"tf":1.4142135623730951},"140":{"tf":1},"203":{"tf":1},"205":{"tf":1.4142135623730951},"225":{"tf":1},"253":{"tf":1},"347":{"tf":1.4142135623730951},"375":{"tf":1},"438":{"tf":1},"440":{"tf":1.4142135623730951},"457":{"tf":1},"579":{"tf":1.4142135623730951},"594":{"tf":1},"671":{"tf":1},"786":{"tf":1},"804":{"tf":1},"867":{"tf":1},"879":{"tf":1}},"df":18},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{"899":{"tf":1}},"df":1}}}}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{"941":{"tf":1}},"df":1}}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"204":{"tf":1},"439":{"tf":1}},"df":2}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{"205":{"tf":1},"440":{"tf":1}},"df":2}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"z":{"docs":{"205":{"tf":1},"440":{"tf":1}},"df":2}}},"u":{"docs":{},"df":0,"p":{"docs":{"224":{"tf":1},"456":{"tf":1},"670":{"tf":1},"878":{"tf":1}},"df":4}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"867":{"tf":1}},"df":1}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"z":{"docs":{"20":{"tf":1.4142135623730951},"21":{"tf":1},"59":{"tf":1},"72":{"tf":1},"73":{"tf":1.4142135623730951},"74":{"tf":1.7320508075688772},"78":{"tf":1.7320508075688772},"81":{"tf":1},"82":{"tf":1.7320508075688772},"86":{"tf":1},"94":{"tf":1},"109":{"tf":2.23606797749979},"146":{"tf":1.4142135623730951},"168":{"tf":2},"187":{"tf":1},"223":{"tf":1},"224":{"tf":1},"229":{"tf":1.7320508075688772},"237":{"tf":1},"252":{"tf":1},"253":{"tf":1},"291":{"tf":1},"303":{"tf":1},"304":{"tf":1.4142135623730951},"305":{"tf":1.7320508075688772},"309":{"tf":1.7320508075688772},"312":{"tf":1},"313":{"tf":1.7320508075688772},"317":{"tf":1},"325":{"tf":1},"340":{"tf":2.23606797749979},"381":{"tf":1.4142135623730951},"403":{"tf":2},"422":{"tf":1},"455":{"tf":1},"456":{"tf":1},"461":{"tf":1.7320508075688772},"469":{"tf":1},"484":{"tf":1.41