sidx_dump={"version":"0.9.5","fields":["content","h-1","h0","h1","h2","h3","hash"],"ref":"id","documentStore":{"docs":{"0":{"id":0,"content":"Pro Tutorial","hash":"","h0":"Preface | QF‑Test Tutorial"},"1":{"id":1,"content":"Pro Tutorial","hash":"home-link","h0":"Preface | QF‑Test Tutorial"},"2":{"id":2,"content":"Preface","hash":"sec_Introduction","h0":"Preface"},"3":{"id":3,"content":"QF‑Test QF‑Test is a professional tool for automated testing of Java, Web and native Windows applications with a graphical user interface (UI). QF‑Test tests the system as a whole through the UI. It can also be used for integration tests checking the overall workflow and the interaction of single systems. The main use cases for QF‑Test are automated regression tests. You can use it as well for load testing and input of mass data via the graphical user interface. QF‑Test is designed for the use of testers and developers alike. It has an intuitive UI. Tests can easily be build with the recording function. On the other hand tests can be set up and structured like any other software. If you need to test some functionality for which QF‑Test provides no standard test elements you can almost always implement it via a script. During test execution QF‑Test writes a run log intended for post-mortem error analysis. Additionally you can create configurable HTML reports (also XML or JUnit format) presenting the test results in an overview and with graphics. QF‑Test can be run platform independently on Windows, Linux and macOS. It supports the Java technologies Swing, JavaFX and SWT and the most common web browsers, some even headless. From QF‑Test version 5 on you can also test native Windows applications. For a detailed list of the supported platforms, Java and browser technologies please refer to the System requirements section of the user manual. The video 'Overview' gives a general overview of QF‑Test. You will find a more technical overview in the video 'Technical insights'.","hash":"sec_qf_test","h1":"QF‑Test"},"4":{"id":4,"content":"Tutorial This tutorial is meant as a hands-on introduction to QF‑Test. In the base part we will show the main functions of QF‑Test and guide you through the necessary steps to set up your own test suite. You will learn how to analyze your test results, step through your test by use of the debugger and generate an overview report. Further topics are the concept of modularization by help of procedures and component recognition, which is of central meaning in UI Testing. With \"Advanced features of QF‑Test\" some more advanced QF‑Test features come on stage, like data-driven testing, ensuring of test case prerequisites and automatic generation of basic procedures. Those apply for Java, web and native Windows testing. The way you write tests for Java, Web or native Windows applications is the same for all three technologies. Only with Web applications you might have to have a look at component recognition before you start with the tests, and with native Windows applications you need to be a bit more patient when recording or replaying the tests. Now you might wonder why we provided three different base parts. This is because the demo applications we use look slightly different for each technology. You also get different setup sequences and different components. So, in order as not to confuse you with a demo not matching the exact description of the tutorial we decided to provide three base parts, \"Java UI testing with QF‑Test\" for Java, \"Web UI testing with QF‑Test\" for Web and \"Native Windows UI testing with QF‑Test\" for native Windows applications. This tutorial is also available as HTML online version at www.qftest.com/doc/tutorial/en/tutorial.html. As an alternative to private study, QFS offers training courses for QF‑Test. Details can be found at www.qftest.com/en/support/training-consulting/training.html. The following notations are used throughout the tutorial: »Menu«-»Submenu« represents a menu or menu item. Modifier⁠+⁠Key stands for a keystroke, where the modifier is one (or a combination) of Shift/⇧, Control/⌃, Alt/⌥, or ⌘. Monospaced font is used for names of directories and files, user input and program output.","hash":"sec_tutorial","h1":"Tutorial"},"5":{"id":5,"content":"Feedback This tutorial has been rewritten from scratch for QF‑Test 4.2. We hope you'll like it and look forward to your feedback - be it positive or negative. Please send all comments, bug reports, wishes etc. to support@qftest.com.","hash":"sec_feedback","h1":"Feedback"},"6":{"id":6,"content":"Pro Tutorial","hash":"","h0":"Java UI testing with QF‑Test | QF‑Test Tutorial"},"7":{"id":7,"content":"Pro Tutorial","hash":"home-link","h0":"Java UI testing with QF‑Test | QF‑Test Tutorial"},"8":{"id":8,"content":"Java UI testing with QF‑Test This first part of the tutorial is meant to help you learn the basic features and workflows of QF‑Test. It focuses on the test of Java applications and its specifics. For testing Web applications please go to \"Web UI testing with QF‑Test\" or \"Native Windows UI testing with QF‑Test\" for native Windows programs, as those parts use the same scenarios but with different systems under test. In \"Advanced features of QF‑Test\" more advanced QF‑Test features are explained, applicable for all supported UI technologies.","hash":"sec_java","h1":"Java UI testing with QF‑Test"},"9":{"id":9,"content":"Pro Tutorial","hash":"","h0":"Working with a Sample Test suite (Java) | QF‑Test Tutorial"},"10":{"id":10,"content":"Pro Tutorial","hash":"home-link","h0":"Working with a Sample Test suite (Java) | QF‑Test Tutorial"},"11":{"id":11,"content":"Working with a Sample Test suite (Java) In this first chapter, we will have a look at a simple test suite, explain its major elements, execute it and evaluate the result. This chapter is also available as a video tutorial at \"Working with a Sample Test suite\".","hash":"sec_demojava","h1":"Working with a Sample Test suite (Java)"},"12":{"id":12,"content":"Pro Tutorial","hash":"","h0":"Loading the Test suite | QF‑Test Tutorial"},"13":{"id":13,"content":"Pro Tutorial","hash":"home-link","h0":"Loading the Test suite | QF‑Test Tutorial"},"14":{"id":14,"content":"Loading the Test suite On first startup of QF‑Test and/or the System Under Test (SUT) via QF‑Test you might get a security warning from the firewall asking whether to block the Java network communication or not. As QF‑Test communicates with the SUT by means of network protocols, this must not be blocked by the local firewall in order to allow automated testing. After starting up QF‑Test, you can immediately bring up our first example test suite. Press the toolbar button to bring up the file open dialog Navigate to the subdirectory qftest-10.0.2-pro/doc/tutorial of your QF‑Test installation There select the file FirstJavaTests.qft QF‑Test will then load the indicated test suite which should look as follows:","hash":"tut_loadsuitejava","h0":"Loading the Test suite"},"15":{"id":15,"content":"Figure 1.1: The Test suite FirstJavaTests.qft The left part of the main window contains the test suite, organized in a tree structure. The right side shows the details of a selected tree node. At bottom right you'll see the terminal displaying messages sent by QF‑Test and the application you are testing. In the tree structure of the main window you can navigate and select individual nodes of the test suite. Double click the node Test set: Simple Tests to expand it. You'll find the test set contains two test case nodes enclosed by a \"Setup\"/\"Cleanup\" pair.","hash":"fig_firstTestSuiteJava","h4":"Figure 1.1: The Test suite FirstJavaTests.qft"},"16":{"id":16,"content":"Figure 1.2: The \"Test set: Simple Tests\" Node In the following sections we'll describe the purpose and function of the individual nodes.","hash":"fig_firstTestSetJava","h4":"Figure 1.2: The \"Test set: Simple Tests\" Node"},"17":{"id":17,"content":"Pro Tutorial","hash":"","h0":"Starting the Application | QF‑Test Tutorial"},"18":{"id":18,"content":"Pro Tutorial","hash":"home-link","h0":"Starting the Application | QF‑Test Tutorial"},"19":{"id":19,"content":"Starting the Application Our first step is to examine the \"Setup\" node: Expand the Setup: Start Demo node now.","hash":"tut_startsutjava","h0":"Starting the Application"},"20":{"id":20,"content":"Figure 1.3: The Setup Node In the \"Setup\" node you'll see two child nodes: Set variable - set the variable 'client' to the connection name for the SUT, which will be needed for every action replayed to the application. Sequence: Start client if necessary dependent on OS - starts the System Under Test (SUT) for the respective operating system in case it is not already running. Let's also have a brief look inside the Sequence: Start client if necessary and dependent on OS:","hash":"fig_firstSetupJava","h4":"Figure 1.3: The Setup Node"},"21":{"id":21,"content":"Figure 1.4: The Sequence to start the SUT QF‑Test allows you to test applications on Microsoft Windows, macOS as well as on Linux systems. The test suite described in the tutorial can be replayed on any of them. The only node where we need to differentiate between the operating systems is the startup of the application. This is done by means of an If - Else structure running a .bat file on Windows, respectively a .sh file otherwise (on macOS or Linux). The Start SUT client node starts the application (SUT) and sets up a link between qftest and the SUT. In order to be independent of the actual installation we use a relative path, starting from the QF‑Test version directory, contained in the QF‑Test variable ${qftest:dir.version} (see manual chapter Variables). Please also note that the application is only started in case the client has not yet been connected. At this point, we're ready to actually start the SUT: Click on the Setup: Start Demo\" so it is selected and still expanded (the child nodes stay visible). Click the Start test run toolbar button. This button causes the selected node to be executed. During execution QF‑Test marks the active step by use of an arrow pointer ->. When the setup sequence is completed, our demo application \"CarConfigurator\" is going to appear on the screen. As QF‑Test gets back the focus after the replay action, thus being raised to the foreground, the demo application might be hiding behind it.","hash":"fig_firstStartJava","h4":"Figure 1.4: The Sequence to start the SUT"},"22":{"id":22,"content":"Figure 1.5: The CarConfigurator Demo","hash":"fig_jCarConfigDemo","h4":"Figure 1.5: The CarConfigurator Demo"},"23":{"id":23,"content":"Pro Tutorial","hash":"","h0":"First Test case | QF‑Test Tutorial"},"24":{"id":24,"content":"Pro Tutorial","hash":"home-link","h0":"First Test case | QF‑Test Tutorial"},"25":{"id":25,"content":"First Test case Let's check out now what test case \"First\" contains. There are four test steps inside:","hash":"tut_firsttestjava","h0":"First Test case"},"26":{"id":26,"content":"Figure 1.6: The \"First\" Test case Reset - performs a reset by use of the File->Reset menu action. Select Model I5 - chooses the last model I5 within the vehicles table. Select Special Model Jazz - switches to the Specials tab and choose the Jazz option. Check Final Price - checks that the calculated final price field located at bottom right equals a given value. Test steps are used to group the nodes and to document what is being done. This will prove very useful when it comes to error analysis or test adaptations. Expand the four test step nodes.","hash":"fig_firstTestCaseJava","h4":"Figure 1.6: The \"First\" Test case"},"27":{"id":27,"content":"Figure 1.7: Details of the first Test case You can see Mouse clicks and Checks, which have been grouped in test step nodes for better readability of the test case. The action nodes display the action type (Mouse click, Check, ...) and the component targeted, i.e. where the action goes to. When writing a test you can use the QF‑Test recording function to create them. Recording will be explained in the next chapter Creating your own test suite (Java) . Please select the test case \"First\" node Click the replay button . The test steps will then be replayed in the SUT, which will happen very quickly. The test result is indicated during and after the test run in the status line at the bottom of the QF‑Test main window and should read now 'Finished: No errors'. Next to it there are counters for the numbers and results of the test cases executed. In our case it was just one, error-free, which means a success rate of 100%.","hash":"fig_firstTestCaseDetailsJava","h4":"Figure 1.7: Details of the first Test case"},"28":{"id":28,"content":"Figure 1.8: The result view in the status line Each counter icon has a descriptive tool tip. A list of all counters can be found in the chapter 'Capture and replay' of the manual.","hash":"fig_resultOneTestCaseNoError","h4":"Figure 1.8: The result view in the status line"},"29":{"id":29,"content":"Pro Tutorial","hash":"","h0":"Second Test case - with Error | QF‑Test Tutorial"},"30":{"id":30,"content":"Pro Tutorial","hash":"home-link","h0":"Second Test case - with Error | QF‑Test Tutorial"},"31":{"id":31,"content":"Second Test case - with Error The second test case will show us what happens when an error occurs during test execution. Expand the test case \"Second (with Error)\".","hash":"tut_secondtestjava","h0":"Second Test case - with Error"},"32":{"id":32,"content":"Figure 1.9: The Second Test case Apart from the third test step it is identical to the first test case. So what does this one do? Test step: Grant 10% discount - Writes the value 10 into the discount field. The 'Input' node is another basic action node and can be created directly via the QF‑Test recording function. Expand the Test step: Grant 10% Discount.","hash":"fig_secondTestCaseJava","h4":"Figure 1.9: The Second Test case"},"33":{"id":33,"content":"Figure 1.10: Details of the second Test case Let's execute the second test case: Select the node Test case: \"Second (with Error)\". Click the replay button . This time a dialog shows up telling us that an error occurred.","hash":"fig_SecondTestCaseDetailsJava","h4":"Figure 1.10: Details of the second Test case"},"34":{"id":34,"content":"Figure 1.11: Error in the second test case What happened? To find out we'll open the QF‑Test run log for error analysis. An alternative approach for error analysis would be to execute the test case again using the debugger. This will be explained in chapter Using the Debugger (Java).","hash":"fig_texttesterror","h4":"Figure 1.11: Error in the second test case"},"35":{"id":35,"content":"Pro Tutorial","hash":"","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"36":{"id":36,"content":"Pro Tutorial","hash":"home-link","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"37":{"id":37,"content":"The Run log for Error Diagnosis QF‑Test logs detailed information for every test execution. Please open the latest run log by one of the following options: either by pressing the Show run log button of the error dialog or in case you have already closed the dialog by pressing toolbar button or by pressing Ctrl⁠+⁠L. The most recent run logs are also listed at the bottom of the Run menu of the main window. The run log comes up in a separate window displaying the logged actions of the test case you've just executed:","hash":"tut_firstrunlogjava","h0":"The Run log for Error Diagnosis"},"38":{"id":38,"content":"Figure 1.12: Runlog for the second test case The run log reflects the tree structure of the test suite view you are already familiar with. When you click on one of the nodes on the left side, the properties of the event including time stamp and duration will be displayed on the right. In the tree left you will notice nodes surrounded by a red border. These are indicators showing where a problem occurred in a child node. If you keep expanding the red nodes, you'll eventually come to the actual error node. Please use an easier way to find the error source by pressing the Find next error toolbar button or the [Ctrl-N] key shortcut. All nodes with red highlighting have been expanded and the actual error node has been selected:","hash":"fig_firstErrorRunlogJava","h4":"Figure 1.12: Runlog for the second test case"},"39":{"id":39,"content":"Figure 1.13: Error in the second test case The error message on the right says that the expected value of the final price field differs from the actual one. Of course this error is there by intention as the second test case is supposed to show us how to analyze an error. Another helper for error analysis is the Screenshot of the SUT taken at the time when the error occurred (four nodes down from the red node). Being able to see the state of the SUT at that moment often proves useful for determining the cause of the error. The following image shows a screenshot node:","hash":"fig_firstErrorRunlogDetailsJava","h4":"Figure 1.13: Error in the second test case"},"40":{"id":40,"content":"Figure 1.14: Screenshot node showing the error situation In addition to screenshots of all monitors, QF‑Test also saved images of the client windows at the time of the error. This allows you to analyze the contents even if they are covered by other dialogs or windows.","hash":"fig_firstErrorRunlogScreenshotJava","h4":"Figure 1.14: Screenshot node showing the error situation"},"41":{"id":41,"content":"Pro Tutorial","hash":"","h0":"Getting Help | QF‑Test Tutorial"},"42":{"id":42,"content":"Pro Tutorial","hash":"home-link","h0":"Getting Help | QF‑Test Tutorial"},"43":{"id":43,"content":"Getting Help We take a short break in this section to give you a few tips that might prove helpful as you continue with the tutorial. There are different places where you can look for help or information: The most comprehensive search can be achieved via »Help«-»Online search...«. This navigates you to the search functionality on our homepage and allows querying throughout all available documentation (manual, tutorial, standard library, blog and our videos). Search results can be filtered as needed. In case you work offline and want to search for a certain topic, the offline versions of the manual or tutorial available via the »Help« menu can be used. QF‑Test also offers a context sensitive help for tree node types and their details. To use it, simply press the right mouse button on an arbitrary tree node or attribute in the details pane. From the context menu select »What's this?«. This will directly bring you to the reference explanation of this item in the manual. Beside getting help from the documentation you also have the option to contact our support team. During your evaluation phase or after that as customer with a valid maintenance contract you may issue your questions directly to our support experts by using the support form from the QF‑Test help menu »Contact the support team« or visiting our web site.","hash":"tut_firsthelpjava","h0":"Getting Help"},"44":{"id":44,"content":"Pro Tutorial","hash":"","h0":"Stopping the Application | QF‑Test Tutorial"},"45":{"id":45,"content":"Pro Tutorial","hash":"home-link","h0":"Stopping the Application | QF‑Test Tutorial"},"46":{"id":46,"content":"Stopping the Application We haven't inspected the cleanup sequence, so let's have a look at it now: Expand the Cleanup: Stop Demo node.","hash":"tut_firstcleanupjava","h0":"Stopping the Application"},"47":{"id":47,"content":"Figure 1.15: The Cleanup Sequence The Cleanup sequence stops the client process in a hard way and waits until it fully terminates. This is a very simple approach and shall suffice for the moment. Execute the cleanup to see the CarConfigurator vanish.","hash":"fig_firstCleanupJava","h4":"Figure 1.15: The Cleanup Sequence"},"48":{"id":48,"content":"Pro Tutorial","hash":"","h0":"A full Test Run | QF‑Test Tutorial"},"49":{"id":49,"content":"Pro Tutorial","hash":"home-link","h0":"A full Test Run | QF‑Test Tutorial"},"50":{"id":50,"content":"A full Test Run After we have seen how the single elements of the test set work, let us have a look at the functionality provided by the test set node. First, close the \"CarConfigurator\" in case it is still running. Then select the \"Test set: Simple Tests\" node. Execute it with the replay button . The result dialog will come up after test execution, informing us about the error caused by the second test case. Open the run log again by to take a closer look:","hash":"tut_firstFullRunJava","h0":"A full Test Run"},"51":{"id":51,"content":"Figure 1.16: Runlog for the Completed Test set This shows the special behavior of Setup / Cleanup nodes in a test set: They are executed before and after each test case to help achieving a proper starting state for each test case. Stopping the SUT after each test case is not the smartest way to ensure a clean state. There are more elegant ways for setup and cleanup that will be explained with the advanced features in this tutorial (\"Dependencies: Automatically ensuring correct prerequisites for each Test case\").","hash":"fig_firstRunlogFullJava","h4":"Figure 1.16: Runlog for the Completed Test set"},"52":{"id":52,"content":"Pro Tutorial","hash":"","h0":"Report Generation | QF‑Test Tutorial"},"53":{"id":53,"content":"Pro Tutorial","hash":"home-link","h0":"Report Generation | QF‑Test Tutorial"},"54":{"id":54,"content":"Report Generation In the world of quality assurance documenting test results is important. To this end, QF‑Test offers an automated report generation feature. Since you've just done a complete test run, we're at a good point to show you this feature. Make sure the run log of the test run is open. In the run log window select »File«-»Create report...« to bring up the dialog for the report parameters.","hash":"tut_firstreportjava","h0":"Report Generation"},"55":{"id":55,"content":"Figure 1.17: Report Generation Properties In the first field, you can specify the filename of the report. Following this, you can decide what type of report you want. QF‑Test offers three kinds of reports, HTML, XML and JUnit format. An XML report is useful if you want to process the data further, e.g. if you have written your own XSLT stylesheets to shape the report. JUnit reports prove useful when you need to import results into build or test management tools. Let's generate an HTML report from the results of the last test run. So just leave the report options unchanged. Start generation by pressing the OK button. The report will then be generated and presented to you in a browser window:","hash":"fig_ReportDialog","h4":"Figure 1.17: Report Generation Properties"},"56":{"id":56,"content":"Figure 1.18: An HTML Report The report begins with a summary containing informational data from your system on the top left side, a legend describing the meaning of icons used in the report on the top right side, an overview pie chart in the middle and the overall test result below. In our case, the result we see are the error-free first test case and the second with the well-known error, leading to a success rate of 50%. Following the summary there are three overview sections: Test suites that have been executed within the test run. Test suites in which errors occurred. Errors including their exact position and detailed message. The report generator is very useful for creating an overview document for presentation and archiving purposes.","hash":"fig_ReportHtml","h4":"Figure 1.18: An HTML Report"},"57":{"id":57,"content":"Pro Tutorial","hash":"","h0":"Creating your own test suite (Java)\n     | QF‑Test Tutorial"},"58":{"id":58,"content":"Pro Tutorial","hash":"home-link","h0":"Creating your own test suite (Java)\n     | QF‑Test Tutorial"},"59":{"id":59,"content":"Creating your own test suite (Java) In the second chapter of the Java tutorial we will create our own sequences for starting and stopping an SUT from QF‑Test. Furthermore we are going to record actions and checks and use those to build up a simple test case. This chapter is also available as a video tutorial at \"Creating your own test suite\".","hash":"sec_testsuite","h1":"Creating your own test suite (Java)"},"60":{"id":60,"content":"Pro Tutorial","hash":"","h0":"Starting the Application | QF‑Test Tutorial"},"61":{"id":61,"content":"Pro Tutorial","hash":"home-link","h0":"Starting the Application | QF‑Test Tutorial"},"62":{"id":62,"content":"Starting the Application To begin, you need to launch the application from QF‑Test. The Quickstart Wizard helps to generate the respective setup sequence. Please open a new test suite via the menu item »File« »New test suite...«. Open the Quickstart Wizard via the menu »Extras«-»Quickstart Wizard...« . In the first step you can choose the type of application to be tested. Please keep the first option A Java application. Press Next.","hash":"tut_quickstartjava","h0":"Starting the Application"},"63":{"id":63,"content":"Figure 2.1: Type of Application In step two you can choose the type of application executable to be tested. Please keep the first option \"A stand-alone executable (launched via .exe, .cmd, .bat, .app,...)\" Continue with Next.","hash":"fig_WizardTypeJava","h4":"Figure 2.1: Type of Application"},"64":{"id":64,"content":"Figure 2.2: Type of Executable The next step specifies the executable file. For this please use the select executable button on the right. Navigate to the subdirectory qftest-10.0.2-pro/demo/carconfigSwing/ of the QF‑Test installation. Select the CarConfig.cmd file (or CarConfig.sh on macOS/Linux). In the figure below we used the QF‑Test variable ${qftest:dir.version} to address the version specific directory of the QF‑Test installation, which you have already come across in the previous chapter. (Details on special QF‑Test variables can be found in the manual chapter Variables). Please press the Finish button, as we do not need to go to the further optional steps for our simple demo.","hash":"fig_WizardTypeExec","h4":"Figure 2.2: Type of Executable"},"65":{"id":65,"content":"Figure 2.3: Executable file selection. We directly reach the final summary that explains what will happen after closing the wizard and how to continue. Please press Finish in order to end the wizard.","hash":"fig_WizardExecFile","h4":"Figure 2.3: Executable file selection."},"66":{"id":66,"content":"Figure 2.4: Final Information The generated setup sequence Launch CarConfig appears in the \"Extras\" section of your test suite and contains three parts: Set variable - defines the global client variable used throughout the test suite. Wait for client to connect - checks whether the client is already running. Launch SUT if not running - starts the System Under Test as client if it is not already running by us of a \"Start SUT client\" and wait for its start. The information whether the client is already running is stored into a variable \"isSUTRunning\" in the first \"Wait for client to connect\" node and evaluated by the subsequent \"If\" condition. You can find this in the respective node details. This kind of conditional execution will be explained later in detail.","hash":"fig_WizardFinal","h4":"Figure 2.4: Final Information"},"67":{"id":67,"content":"Figure 2.5: Generated Setup Sequence Now we want to see some action: Please ensure the Setup: Launch CarConfig node is selected. Then click or simply hit \"Enter\" Return. You should see the CarConfigurator application appear on your screen soon. As the focus changes back to QF‑Test after the execution, the Demo might be covered by the test suite window.","hash":"fig_WizardResult","h4":"Figure 2.5: Generated Setup Sequence"},"68":{"id":68,"content":"Figure 2.6: The CarConfigurator Demo Window At the end of this section let's save our test suite. Press the toolbar button or use the »File«-»Save« menu option with its short-cut Ctrl⁠+⁠S. In the file explorer navigate to an appropriate directory where you have write access e.g. Documents in your user home directory. Provide a name e.g. MyFirstTests.qft. Finish the saving action by pressing on Save.","hash":"fig_JCarConfigWin","h4":"Figure 2.6: The CarConfigurator Demo Window"},"69":{"id":69,"content":"Pro Tutorial","hash":"","h0":"Recording Actions | QF‑Test Tutorial"},"70":{"id":70,"content":"Pro Tutorial","hash":"home-link","h0":"Recording Actions | QF‑Test Tutorial"},"71":{"id":71,"content":"Recording Actions You're now ready to record some actions for our demo:","hash":"tut_recactionsjava","h0":"Recording Actions"},"72":{"id":72,"content":"Figure 2.7: Recording actions on the CarConfigurator Demo Please press the Record button. Switch to the SUT application window. From now on every mouse and keyboard action performed within the SUT window will be recorded. Click to the table cell I5 in the last row. Change to the Specials tab of the tabbed pane. Choose the special Jazz from the combo box. Finally switch back to the Vehicles tab in the tabbed pane. Stop the recording by use of the button. You'll find the recorded sequence placed in the \"Extras\" section:","hash":"fig_JCarConfigWinRec","h4":"Figure 2.7: Recording actions on the CarConfigurator Demo"},"73":{"id":73,"content":"Figure 2.8: The Recorded Sequence The recorded sequence has a default name with date and time of the recording. You can change this name as you see fit by simply clicking on the node and changing its properties in the details view on the right. Please rename the recorded sequence to \"Select Model I5 Jazz\". Then open the sequence node to see its content. There should be the expected mouse clicks. You should even be able to interpret where they go to.","hash":"fig_FirstRecordedSequence","h4":"Figure 2.8: The Recorded Sequence"},"74":{"id":74,"content":"Figure 2.9: The Renamed Sequence Now, let us replay the recorded sequence. Select the Select Model I5 Jazz sequence node. Press the play button . You should now see exactly the same sequence of mouse events executed in the SUT as you recorded before. The sequence is supposed to replay (even multiple times) without errors. You should see \"Finished: No error\" in the bottom right corner of your test suite window.","hash":"fig_FirstRecordedSequenceRenamed","h4":"Figure 2.9: The Renamed Sequence"},"75":{"id":75,"content":"Pro Tutorial","hash":"","h0":"Recording Checks | QF‑Test Tutorial"},"76":{"id":76,"content":"Pro Tutorial","hash":"home-link","h0":"Recording Checks | QF‑Test Tutorial"},"77":{"id":77,"content":"Recording Checks To verify the client's behavior we use check nodes, which query certain states and properties of elements within the SUT. Also checks can be recorded. Click the \"Record a check\" button. Switch to the SUT window. When moving the mouse over the components you will notice a blue border indicating the current selection. Right-click the value field of \"Final price\". In the popup menu you are offered a choice of standard checks for a text field component. Select the first option \"Text\" for a check on the textual value of the field. Stop the recording by using the Stop button. Again, the newly recorded sequence appears in the \"Extras\" section. Please rename the sequence to \"Check final price\" Expand it to see the check node.","hash":"tut_recchecksjava","h0":"Recording Checks"},"78":{"id":78,"content":"Figure 2.10: The recorded check node Feel free to run this sequence, too, verifying it is working properly. As the next step, we want to create a test case from the two sequences.","hash":"fig_textchecktree","h4":"Figure 2.10: The recorded check node"},"79":{"id":79,"content":"Pro Tutorial","hash":"","h0":"Setting up a test suite | QF‑Test Tutorial"},"80":{"id":80,"content":"Pro Tutorial","hash":"home-link","h0":"Setting up a test suite | QF‑Test Tutorial"},"81":{"id":81,"content":"Setting up a test suite The top-level nodes of the test suite define its basic structure: Right after the \"Test-suite\" node an arbitrary number of \"Test set\" and \"Test case\" nodes may be added specifying the functional tests. \"Procedures\" contains reusable sequences (procedures) that can be organized into packages. \"Extras\" is the scratch pad for recording and experimentation. \"Windows and components\" contains the all-important elements of the test suite: registered elements of the SUT , e.g. windows, menus and buttons. The details of each element in the \"Windows and components\" section contains the properties of the recorded UI element required by QF‑Test to find the component when replaying a test. Functional test cases are represented by \"Test case\" nodes and can be grouped and structured with the help of \"Test set\" nodes. \"Setup\" and \"Cleanup\" nodes are intended for test steps ensuring a well-defined state before and after a test case. Let's start by renaming the top-level test set node from \"unnamed\" to \"Demo Tests\". If a dialog pops up asking us whether to update references we can simply confirm with \"Yes\". The second step is to move the \"Setup\" node generated by the Quickstart Wizard from the \"Extras\" node into the \"Test set\" node - right before the \"Test case\" node. Moving the \"Setup\" node can be done via mouse (Drag&Drop), context-menu (right mouse-button copy/paste) or by Ctrl⁠+⁠X and Ctrl⁠+⁠V keyboard commands.","hash":"tut_buildtestjava","h0":"Setting up a test suite"},"82":{"id":82,"content":"Figure 2.11: Start organizing the test suite The next step is to make a test case of the two sequences previously recorded. Please rename the test case node from \"unnamed\" to \"First\". Open the test case node by clicking the '>' symbol. Move the two sequences from \"Extras\" into the test case. You need to open the test case node because otherwise QF‑Test would try to place the sequence nodes after the test case node on the same level, which is not a valid option. QF‑Test always records sequence nodes. They have the same functionality as test step nodes, only they do not show up in the report. So, just to show you, we will transform the two sequence nodes into test step nodes. Please open the context menu for the first of the two sequence nodes by a right-click. Choose »Transform node into...«-»Test step« Repeat this for the second sequence node. Your test suite should now look like this:","hash":"fig_beginbuildatest","h4":"Figure 2.11: Start organizing the test suite"},"83":{"id":83,"content":"Figure 2.12: The Organization of your test suite","hash":"fig_buildatest","h4":"Figure 2.12: The Organization of your test suite"},"84":{"id":84,"content":"Pro Tutorial","hash":"","h0":"Stopping the Demo | QF‑Test Tutorial"},"85":{"id":85,"content":"Pro Tutorial","hash":"home-link","h0":"Stopping the Demo | QF‑Test Tutorial"},"86":{"id":86,"content":"Stopping the Demo The only thing missing now is a cleanup sequence closing down the SUT. There are usually various ways to terminate an SUT, e.g. clicking the close button of the application window, pressing ALT-F4 or via the menu action »File«-»Exit«. All these options can be directly recorded and then used in the cleanup sequence. Let's use the last one. So please perform the following steps. Start recoding . Record the menu SUT menu action »File«-»Exit«. You see the demo window close. Stop recording . Rename the recorded sequence to \"Stop demo\". Open the context menu for the recorded sequence and select »Convert into...«-»Cleanup«. Finally move the cleanup node up to be the last node in the test set. The cleanup node can only be dragged and dropped to the test set if the test set's last child node is collapsed. To expand or collapse a node during a drag and drop operation, hold your cursor over the triangle next to the node. You should end up with the following:","hash":"tut_cleanupjava","h0":"Stopping the Demo"},"87":{"id":87,"content":"Figure 2.13: The simple cleanup sequence By this we have finished with the basic steps of structuring our suite.","hash":"fig_StopSequence","h4":"Figure 2.13: The simple cleanup sequence"},"88":{"id":88,"content":"Pro Tutorial","hash":"","h0":"Running the whole test suite | QF‑Test Tutorial"},"89":{"id":89,"content":"Pro Tutorial","hash":"home-link","h0":"Running the whole test suite | QF‑Test Tutorial"},"90":{"id":90,"content":"Running the whole test suite Finally let's execute our newly created suite: Terminate the SUT client in case it is running. Select the root node of the test suite. Run it by pressing \"Replay\" or typing Return. The SUT is expected to appear, the test case will be executed and finally the SUT will be terminated. We know the test run details can be looked up in the run log. It can be opened by clicking the toolbar button or via the »Run«-»1. ...« menu option with its short-cut Ctrl⁠+⁠L","hash":"tut_runownsuitejava","h0":"Running the whole test suite"},"91":{"id":91,"content":"Figure 2.14: The Run log of the test suite In the first tutorial chapter we've already learned how to use the run log for error analysis.","hash":"fig_firstrunlog","h4":"Figure 2.14: The Run log of the test suite"},"92":{"id":92,"content":"Pro Tutorial","hash":"","h0":"Writing a Procedure (Java) | QF‑Test Tutorial"},"93":{"id":93,"content":"Pro Tutorial","hash":"home-link","h0":"Writing a Procedure (Java) | QF‑Test Tutorial"},"94":{"id":94,"content":"Writing a Procedure (Java) This chapter is also available as a video tutorial at \"Writing a Procedure\". In the two previous chapters you learned how to start an application from QF‑Test thus being able to record mouse and keyboard actions, add checks and organize the result in a test case. This approach is fine and sufficient as long as your tests are simple and you have just a few of them. But as soon as the number of tests increases it is important to make use of so-called 'procedures'. Procedures make sequences reusable and therefore avoid duplicated identical parts. This is important for easy and on the long run efficient maintenance of your tests. Procedures can be organized into packages . Procedures and packages are the basis for modularizing your tests.","hash":"sec_FirstProcedure","h1":"Writing a Procedure (Java)"},"95":{"id":95,"content":"Pro Tutorial","hash":"","h0":"Identifying reusable parts | QF‑Test Tutorial"},"96":{"id":96,"content":"Pro Tutorial","hash":"home-link","h0":"Identifying reusable parts | QF‑Test Tutorial"},"97":{"id":97,"content":"Identifying reusable parts In this chapter we will work with the test suite FirstJavaTests.qft you already know from chapter one. Copy FirstJavaTests.qft from the subdirectory qftest-10.0.2-pro/doc/tutorial of the QF‑Test installation to a working directory and open FirstJavaTests.qft. If you want to keep the changes you will be making to the demo test suite save it in a working directory as described at the end of \"Starting the Application\". Please have a look at the test step \"Reset\" in the two test cases. They are exactly the same.","hash":"tut_procreuse","h0":"Identifying reusable parts"},"98":{"id":98,"content":"Figure 3.1: Two identical test steps Following above concepts it would be a good idea to turn them into a procedure.","hash":"IdenticalTeststeps","h4":"Figure 3.1: Two identical test steps"},"99":{"id":99,"content":"Pro Tutorial","hash":"","h0":"Manual creation of procedures | QF‑Test Tutorial"},"100":{"id":100,"content":"Pro Tutorial","hash":"home-link","h0":"Manual creation of procedures | QF‑Test Tutorial"},"101":{"id":101,"content":"Manual creation of procedures There is more than one way to create procedures and insert procedure calls. We will start with the manual one by inserting an (empty) procedure node and moving the respective actions into it. Then we will create the respective procedure call. It is good to know those basic steps but there is a second more elegant way of creating procedures, which we will explain afterwards. Okay, let's do it by hand. We will start with creating a procedure node and naming it appropriately. Open the Procedures node and keep it selected. Chose »Insert«-»Procedure nodes«-»Procedure«. Name it 'reset'. The other fields can be left empty. Open the newly created 'reset' procedure node.","hash":"tut_procmanual","h0":"Manual creation of procedures"},"102":{"id":102,"content":"Figure 3.2: Create a procedure node The second step is to fill the procedure with the respective reusable actions. Select the three 'Mouse click' nodes in the test step. To select more than one node at once you can select the first one, then press the Shift key and, while keeping it pressed, click the last node you want to select. Move them down into the procedure e.g. by mouse (drag&drop) or cut/paste from the »Edit« or context menu.","hash":"ProcedureNodeInFirstTestcase","h4":"Figure 3.2: Create a procedure node"},"103":{"id":103,"content":"Figure 3.3: Fill in the procedure content The third step is to add a procedure call to the place of the three 'Mouse clicks' you moved. Select the test step 'Reset', which is still open. Select »Insert«-»Procedure nodes«-»Procedure call« or use the Ctrl⁠+⁠A shortcut.","hash":"ProcedureContentInFirstTestcase","h4":"Figure 3.3: Fill in the procedure content"},"104":{"id":104,"content":"Figure 3.4: Insert a procedure call Press the procedure selection button left of the label 'Procedure name'. Select 'reset' from your test suites procedures. Other fields can be left as they are. Press the OK button to finalize the creation of the procedure call.","hash":"AddProcedureCall","h4":"Figure 3.4: Insert a procedure call"},"105":{"id":105,"content":"Figure 3.5: Select a procedure In order get a real benefit from the procedure, of course, we also need to replace the content of reset test step in the second test case by the 'reset' procedure call, too. You can do it the same way as before or use the following alternative steps to create a procedure call: Open the 'Reset' test step of the second test case. Remove the three 'Mouse click' action nodes therein. Select the 'reset' procedure node. Move it via drag&drop into the 'Reset' test step (copy/paste action can be used alternatively). This does not actually move it but create a respective procedure call. The test suite should look like this:","hash":"SelectProcedure","h4":"Figure 3.5: Select a procedure"},"106":{"id":106,"content":"Figure 3.6: Test-suite with procedure When now executing the test cases the reset will work exactly like it did before. Hence, in the run log you will see the same executed node as before, only preceded by the procedure call.","hash":"fig_testsuite_with_procedure","h4":"Figure 3.6: Test-suite with procedure"},"107":{"id":107,"content":"Pro Tutorial","hash":"","h0":"Transforming nodes into procedures | QF‑Test Tutorial"},"108":{"id":108,"content":"Pro Tutorial","hash":"home-link","h0":"Transforming nodes into procedures | QF‑Test Tutorial"},"109":{"id":109,"content":"Transforming nodes into procedures As already mentioned at the beginning of the last section, QF‑Test offers an alternative, much faster way to create a procedure: Select the test step or sequence node that contains the reusable steps to be transformed into a procedure. Select menu item »Operations«-»Transform node into«-»Procedure« or use the Ctrl⁠+⁠Shift⁠+⁠P shortcut. You will find that the test step, respectively sequence node disappeared and there is a procedure call in its place. Moreover, a procedure was created in the Procedures section containing the child nodes of the former test step / sequence node and named the same. It is good practice with QF‑Test to record a sequence, give it a name and immediately turn it into a procedure via Ctrl⁠+⁠Shift⁠+⁠P if you suspect it to be of use somewhere else, too.","hash":"tut_proctransform","h0":"Transforming nodes into procedures"},"110":{"id":110,"content":"Pro Tutorial","hash":"","h0":"Components (Java) | QF‑Test Tutorial"},"111":{"id":111,"content":"Pro Tutorial","hash":"home-link","h0":"Components (Java) | QF‑Test Tutorial"},"112":{"id":112,"content":"Components (Java) Let us have a look at the last main section in the test suite window, the Windows and components node. When talking about components we also want to show you how to address subitems of components like tables, trees and lists. This chapter is also available as a video tutorial at \"Components\".","hash":"sec_ComplexComponents","h1":"Components (Java)"},"113":{"id":113,"content":"Pro Tutorial","hash":"","h0":"Addressing subitems of tables, lists and trees | QF‑Test Tutorial"},"114":{"id":114,"content":"Pro Tutorial","hash":"home-link","h0":"Addressing subitems of tables, lists and trees | QF‑Test Tutorial"},"115":{"id":115,"content":"Addressing subitems of tables, lists and trees Subcomponents of tables, lists and trees can be addressed by indices. There are two main types: textual and numeric indices. Let's record a mouse click to a table cell and analyze the recorded QF‑Test component ID. Start the CarConfig application, in case it has not been started already, by executing the Setup node of the test suite. Activate the recording mode by pressing the toolbar button . Click a table cell, e.g. the first model. Stop the recording by pressing . You will see the recorded mouse click in the Extras section.","hash":"sec_addressing_complex_components","h0":"Addressing subitems of tables, lists and trees"},"116":{"id":116,"content":"Figure 4.1: Addressing a table cell The QF‑Test component ID recorded is VehicleTable@Model&0. The single parts are: VehicleTable is the QF‑Test component ID of the table component itself. @ and & separate the single parts from each other and at the same time indicate the type of index that follows: @ for a textual index and & for a numeric index. Model is the textual index for the table column with the title 'Model'. 0 is the numeric index for the first table row. Numeric indices always start at 0. You can use any index type for column or row. It is just important that the separator and the index type match. Change the QF‑Test component ID so that the third price value in the table will be clicked, using numeric indices only. The solution is to type VehicleTable&1&2 in the QF‑Test component ID attribute of the Mouse event node. In order to address the model 'I5' using textual indices only, you would have to enter VehicleTable@Model@I5. Using numeric indices you would write VehicleTable&0&4 and for mixed indices VehicleTable&0@I5 or VehicleTable@Model&4. The third type of index QF‑Test supports is a textual index containing a regular expression. Regular expressions can be used to replace a string by an expression that can match for more than only one string. For a detailed explanation of regular expressions please refer to the manual. So you could also address the cell for the model 'I5' using VehicleTable@Model%I.*. Lists are addressed the same way as tables are, just with one index only. A tree has only one index. This is the path down the tree to the node to be specified. The path consists of the respective nodes of the tree, separated by slashes ('/'). Let's record a mouse click to a tree: Start the CarConfig application, in case it has not been started already, by executing the Setup node of the test suite. Navigate to the tree: In the CarConfig application select the menu item »Options«-»Specials...«, select a model and press 'Details' Activate recording mode by pressing the toolbar button . Click a tree node, e.g. 'Description'. Stop the recording by pressing . For the tree node 'Description' the recorded QF‑Test component ID would be DetailsTree@/Information/Description. The single parts are: DetailsTree is the QF‑Test component ID of the tree component itself. @ separates the QF‑Test component ID of the tree from the index and at the same time indicates the type of index that follows: @ for a textual index. /Information/Description is the textual index for the tree path to 'Description'. If you wanted to address the node using a numeric index you would have to use DetailsTree&/0/1.","hash":"fig_components_tableindex","h4":"Figure 4.1: Addressing a table cell"},"117":{"id":117,"content":"Pro Tutorial","hash":"","h0":"Windows and components Section | QF‑Test Tutorial"},"118":{"id":118,"content":"Pro Tutorial","hash":"home-link","h0":"Windows and components Section | QF‑Test Tutorial"},"119":{"id":119,"content":"Windows and components Section The topic 'components' is covered by several videos: The video 'Component recognition' first explains the criteria for component recognition, then (starting at min 13:07) the use of generic components using regular expressions, followed by generic components using variables in component recognition attributes. There are two videos available explaining in detail how to deal with a ComponentNotFoundException: The video 'ComponentNotFoundException - simple case' shows a simple case. A more complex case is discussed in the video 'ComponentNotFoundException - complex case'. Live recording of the special webinar 'Component recognition'. QF‑Test stores the information about how to find a component in the UI of the SUT in the Windows and components section. It analyses the component information when recording actions to the SUT and saves the information for the components the user interacted with in the details of the Component nodes. Since Java Swing, JavaFX and SWT have a clear concept of how a certain component has to be technically implemented, you rarely have to bother about the information QF‑Test stores for a certain component. In most cases QF‑Test will recognize the component it has to replay some event to. Only when the UI of your application changed significantly in a way QF‑Test cannot compensate, you will have to think about Component nodes. For a detailed instruction about what to do then, please refer to the manual chapter Troubleshooting component recognition problems. There are also links to videos showing respective samples. This section is meant to give you an idea about which kind of information is stored in the Component nodes and how QF‑Test uses it to recognize a component in the UI. Let's have a look at the details of a 'TextField' component node. Start the CarConfig application, in case it has not been started already, by executing the Setup node of the test suite. Open the procedure 'Check final price'. Navigate to the text field Component node by right-clicking the text check node and selecting »Locate component« or using the Ctrl⁠+⁠W shortcut.","hash":"sec_componentsteps","h0":"Windows and components Section"},"120":{"id":120,"content":"Figure 4.2: Locating a component This is going to take you directly to the 'TextField CalculatedPrice' node in the Windows and components section.","hash":"fig_components_locate","h4":"Figure 4.2: Locating a component"},"121":{"id":121,"content":"Figure 4.3: Component tree Let's have a look at the properties of this component node used to identify the UI element.","hash":"fig_components_tree","h4":"Figure 4.3: Component tree"},"122":{"id":122,"content":"Figure 4.4: Details of the Component node The topmost attribute is QF‑Test ID, which provides the 'handle' to the component to be used in the test cases and procedures. All other attributes refer to the component in the UI. The next attribute is Class name. In our case it is 'TextField'. For component recognition it is essential to know the class of a component. In fact this class is a generalized value of the Java class or Java system class. This is helpful to achieve recognition independently of the specific implementation and allows an easy porting of tests e.g. from Java Swing to its successor JavaFX. However, QF‑Test saves the specific and the system class in the Extra features table as Extra features named qfs:class and qfs:systemclass. By default, they are not used for component recognition. Other examples for classes would be 'Panel', 'Dialog' or 'Button'. The Name attribute is the name or id given to the UI component by the programmer. If there is a Name then this, together with the class, is all QF‑Test needs to identify a component in the UI. If the programmer did not set a name or id for the UI component and the Name attribute therefore remained empty QF‑Test needs other criteria like a certain text associated with the component, index information and geometry. A feature associated with a button for example would be the text shown on the button. QF‑Test saves a text directly belonging to the UI component in the Feature attribute. Texts in the vicinity of a component that could be the label of the component are saved in the Feature attribute with the prefix Label: and in the Extra features table with the Extra features Name qfs:label. The Structure information refers to all UI components of the respective class. The total number of UI components of that class is saved in the Class count attribute, the index of the component itself in the Class index attribute. Last there is the Geometry information. It is the one having the lowest weight within the recognition algorithm. It can be of value if no other helpful information is available for a component. In case you are interested in further details of the component recognition you will find such in the Component recognition chapter of the technical reference of the manual. If you want to get a feeling for the component recognition you could play around with the attribute values and see what you need to change to make QF‑Test not recognize it anymore or even recognize a wrong component in the UI. You will find that you need to change quite a few attributes before QF‑Test recognizes a different component. This means that component recognition with QF‑Test is very robust. With regression tests a significant part of the UI component criteria need to change before QF‑Test will not recognize the component anymore even if the component has no name or id. When you click the Component node QF‑Test will highlight the recognized component in the UI by outlining it with a dark blue border. Delete CalculatedPrice from the Name attribute. Because as long as there is an entry in the Name attribute QF‑Test will not consider the attributes below. Change the Feature attribute from Label: Final price to Label: xxx. Click the 'TextField' node and check QF‑Test still highlights the Final Price field in the UI. Change the Feature attribute back to Label: Final price, either via the respective toolbar button or by typing Ctrl⁠+⁠Z. Change the qfs:label value in the Extra features table from Final price to Discount. Click the 'TextField' node and check QF‑Test still highlights the Final Price field in the UI. Change the qfs:label value in the Extra features table back to Final price. Change all Structure and Geometry attributes to a different value and check that QF‑Test still highlights the Final Price field in the UI. Change the Feature attribute from Label: Final price to Label: Discount. Check that now QF‑Test highlights the Discount field. This is just to give you a bit of a feeling for component recognition. In the above mentioned chapters (and some more) of the manual you will find detailed information about what to do when you have trouble with component recognition.","hash":"fig_components_details","h4":"Figure 4.4: Details of the Component node"},"123":{"id":123,"content":"Pro Tutorial","hash":"","h0":"SmartIDs - Addressing components directly | QF‑Test Tutorial"},"124":{"id":124,"content":"Pro Tutorial","hash":"home-link","h0":"SmartIDs - Addressing components directly | QF‑Test Tutorial"},"125":{"id":125,"content":"SmartIDs - Addressing components directly Since version 7.0 QF‑Test officially supports SmartIDs allowing you to reference a component without having to record a Component node. For some applications SmartIDs may reduce the time required for management and maintenance of the component information considerably. SmartIDs may also have a positive effect on readablity and maintainability of the tests themselves. It also allows you to write tests without use of the recording functionality, for example when a component or even the whole application does not yet exist, and you want to go ahead with tests (\"test first\" approach). SmartIDs then allow you to specify the future recognition critiera directly. The recognition criteria available are the component class, the name or a label and the index. The values are the same as in the recorded Component node. Nested SmartIDs even reflect the component hierarchy. The SmartID is used in place of the QF‑Test ID of the component. SmartIDs start with the hash symbol # as the first character, in the simplest form followed by the name or the label of the component, for example: #btnOK, \"btnOK\" being the name of the component or #First name, \"First name\" being the label of the component. The disadvantage of this simple form of the SmartID is performance at replay, as QF‑Test has to search all components for the given criteria. For this reason it is better to specify the class of the component, too. Above SmartIDs would then be: #Button:btnOK #TextField:First name Currently, the recording of SmartIDs is not activated by default. You can activate it directly via the menu. Now, please record some SmartIDs by opening the menu Record and selecting Record SmartID. Activate recording mode via the button \"Start recording\" . Click to a text field, for example the one for the discount percentage, then click to a table cell, for example the first model. Stop the recording via \"Stop recording\" . You will find the recorded mouse clicks in the Extras section. The SmartID for the input field is #TextField:name=DiscountValue, because QF‑Test preferably uses the name for the SmartID value when there are a name and a label for the component. The second mouse click shows the SmartID for the table component, followed by @ and the text index of the column and & with the numeric index of the row, just like you saw it in the one but last section: #Table:name=VehicleTable@Modell&0. When you do not want to record SmartIDs any more you can deactivate it via the \"Record\" menu. Of course, you can continue working with SmartIDs. When recording more SmartIDs you will come across more expressions used in SmartIDs. We now want to show you some of them and give you an explanation why they are used. For labels ending with a colon you will find a back slash in front of the colon: #TextField:First name\\: The explanation is the colon defines the end of the name of the class. Therefore, colons in the component name or the label have to be escaped by a back slash. Other characters like @, & and % have to be escaped as well because they are used as separators before indices. Labels will be prefixed by a qualifier, here left=: #TextField:left=First name Explanation: a SmartID consisting of class and name of the component reaches the same performance at replay as does component recognition via a recorded Component node. Labels, however, are a different case. There are various options for what might be the best label for a component. QF‑Test searches all the available labels of a component for the best one. For performance it is good when you specify the type of label expected. left= indicates the label to the left of the component. Other SmartID qualifiers indicating the position of the label are right=, top=, topleft= or bottom=. When the text of the component serves as label the qualifier is text=, for the tooltip tooltip=. When you get several components with the same name or label on a display you might see a compound SmartID consisting of to single SmartIDs concatinated by @: #TitledPanel:Customer address@#TextField:left=First name #TitledPanel:title=Invoice address@#TextField:left=First name The example shows the SmartIDs for the label \"First name\", both on the panel \"Customer address\" and on the panel \"Invoice address\". The second sample is a bit more performant than the first one because of the qualifier title= in the SmartID for the panel. With the first one readablity is a bit better. It depends on the application whether you have to pay attention to performance. With web applications with many UI elements it is usually an issue. However, with Java applications you can opt for readablity in most cases. Long labels can be shortened by the use of regular expressions: #%Dialog:Information.*@#Button:OK The percent sign directly after the hash sympol indicates the name or the label to be a regular expression. In above sample the regular expression shortens the title. It may also be used to identify an \"OK\" button in any dialog with the title starting by \"Information\". For more details about regular expressions please see the manual - regular expressions. You will find more information about components and SmartIDs in manual - components.","hash":"sec_components_smartid","h0":"SmartIDs - Addressing components directly"},"126":{"id":126,"content":"Pro Tutorial","hash":"","h0":"Using the Debugger (Java) | QF‑Test Tutorial"},"127":{"id":127,"content":"Pro Tutorial","hash":"home-link","h0":"Using the Debugger (Java) | QF‑Test Tutorial"},"128":{"id":128,"content":"Using the Debugger (Java) In this chapter we will learn how to run a test suite with QF‑Test's built-in and intuitive debugger. If you are familiar with debugging from other IDEs like Eclipse, you will find this debugger similar in function and usefulness. This chapter is also available as a video tutorial at \"Using the Debugger\". By the end of this chapter you will be familiar with the following debugger functionality: Setting a Breakpoint e.g. via Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B). Pausing a test run at any time and resuming operation using the debugger button or the pause test run hotkey Alt⁠+⁠F12. Stepping Through a Test or Sequence using the debugger buttons 'Single step' , 'Step over' and 'Step out' . Skipping Execution of Nodes using the debugger buttons 'Skip over' and 'Skip out' . Error or Exception triggering Debugging Mode. Resolving Errors directly from the Run log. Jump directly to the current error in the run log via Ctrl⁠+⁠J. (Jump to run log in chapter \"Resolving Errors directly from the Run log\"). Instead of the debugger buttons you can also enter the commands via the QF‑Test menu and most by keyboard shortcuts as well. You'll find the shortcut listed beside the menu option, if available. For a complete list, refer to the Keyboard shortcuts section of the user manual. You can also find a little helper there for attaching to your keyboard which shows the function key assignment of QF‑Test. There are some more functions related to the debugger that we will come to in later chapters: Locating the current node using the debugger button (Locate the current node in chapter \"Advanced debugging of variable bindings\"). \"Continue execution from here\" via the popup menu of the respective node (\"Continue Execution from here\"). Rethrowing exceptions using the toolbar button . The variable bindings table (\"Advanced debugging of variable bindings\").","hash":"sec_Debugger","h1":"Using the Debugger (Java)"},"129":{"id":129,"content":"Pro Tutorial","hash":"","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"130":{"id":130,"content":"Pro Tutorial","hash":"home-link","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"131":{"id":131,"content":"Setting a Breakpoint First of all we need to activate debugging mode. There are several ways to do so. One of them is to set a breakpoint at the node where we want to have a closer look. When the test is being executed and QF‑Test comes to the break point it will then pause and switch into debugging mode. The pause button will then be activated. Select a node and press Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B). The breakpoint is indicated by a .","hash":"tut_breakpoints","h0":"Setting a Breakpoint"},"132":{"id":132,"content":"Figure 5.1: Set break point Select the Test suite node and press Enter to start the test run.","hash":"fig_DebugSetBreakpoint","h4":"Figure 5.1: Set break point"},"133":{"id":133,"content":"Figure 5.2: Start test run Remove the breakpoint by pressing Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B) again.","hash":"fig_DebugStartTestRun","h4":"Figure 5.2: Start test run"},"134":{"id":134,"content":"Figure 5.3: Remove break point Instead of using the keyboard shortcut Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B) you may also set or unset a breakpoint by clicking the node and selecting the »Debugger«-»Breakpoint on/off« menu item, or alternatively right-clicking the node and selecting the »Breakpoint on/off« context menu item. Again, you can see the little arrow, which now marks the next node to be executed, called the current node. When entering debugging mode QF‑Test also navigates to the current node, in case it had not been visible, and selects it, highlighting it blue. The menu option »Debugger«-»Clear all breakpoints« is useful to remove all breakpoints set in your test suite. There is no limit to the number of breakpoints you can set in your test suite, but note that breakpoints are not saved with the test suite.","hash":"fig_DebugRemoveBreakpoint","h4":"Figure 5.3: Remove break point"},"135":{"id":135,"content":"Pro Tutorial","hash":"","h0":"Stepping Through a Test or Sequence | QF‑Test Tutorial"},"136":{"id":136,"content":"Pro Tutorial","hash":"home-link","h0":"Stepping Through a Test or Sequence | QF‑Test Tutorial"},"137":{"id":137,"content":"Stepping Through a Test or Sequence Now let's step through the test case we set up in the previous section. Please try out the debugger buttons Single step , Step over and Step out . You will find that Single step opens a node containing child nodes and makes the first child node the active node. Continuing from where we left the test suite at the end of the last section, i.e. in debugging mode, with 'Test case: First' being the current node, the test suite would now look like this:","hash":"tut_debug_steps","h0":"Stepping Through a Test or Sequence"},"138":{"id":138,"content":"Figure 5.4: Stepping into a node In the case of leaf nodes (nodes without child nodes), the effect of is the same as the following button's. Step over runs the current node including all children. Execution pauses at the next node of the same level to be executed, which then becomes the active one.","hash":"fig_StepInExample","h4":"Figure 5.4: Stepping into a node"},"139":{"id":139,"content":"Figure 5.5: Stepping over a node Step out runs the remaining nodes at the same level including their child nodes. Execution pauses when a node that is higher in the hierarchical structure is found, which then becomes the active one.","hash":"fig_StepOverExample","h4":"Figure 5.5: Stepping over a node"},"140":{"id":140,"content":"Figure 5.6: Stepping out of a node In the given example the node higher in the hierarchical structure where execution stops is the Cleanup node. As explained in the first chapter A full Test Run this shows the special behavior of Setup / Cleanup nodes in a test set: They are executed before and after each test case to help achieving a proper starting state for each test case. You will only find this behavior when you started the whole test suite or test set and are in debugging mode. If you just selected the test case and did a step-over action then QF‑Test will execute the test case and then select the next test case node. Run the Cleanup and Setup nodes by stepping over them, using the debugger button Step over and then Step in the second test case via to get ready for the next section where you will learn about the skip functionality. Please be aware that menus or comboboxes tend to close when the application looses the focus, as will happen when activating the debugging mode. In such a case you should not stop test execution between the node opening the menu or combobox and the node performing the selection. One way to do achieve this is to set a break point after the node performing the selection and to activate normal test execution by releasing the pause button when you reach the node opening the menu or combobox.","hash":"fig_StepOutExample","h4":"Figure 5.6: Stepping out of a node"},"141":{"id":141,"content":"Pro Tutorial","hash":"","h0":"Skipping Execution of Nodes | QF‑Test Tutorial"},"142":{"id":142,"content":"Pro Tutorial","hash":"home-link","h0":"Skipping Execution of Nodes | QF‑Test Tutorial"},"143":{"id":143,"content":"Skipping Execution of Nodes The \"skip\" functions expand the QF‑Test debugger's capabilities in a powerful way which is not typically possible for a debugger in a standard programming environment. In short, they allow you to jump over one or more nodes without having to execute them. This may be helpful for various reasons, e.g. to quickly navigate to a certain position in your test run or to skip a node which currently leads to an error. With the end of the last section, the test suite should have reached the following state:","hash":"tut_skip_steps","h0":"Skipping Execution of Nodes"},"144":{"id":144,"content":"Figure 5.7: Pause execution at first node of the second test case Now press the Skip over button. QF‑Test simply jumps over the active node without executing any child nodes. The active node now is the next node to be executed on the same level.","hash":"fig_DebugSkipOverInitialState","h4":"Figure 5.7: Pause execution at first node of the second test case"},"145":{"id":145,"content":"Figure 5.8: Skip over a node At last, press the Skip out button. You see that QF‑Test skips all nodes on the same (or lower) level and directly jumps to the next node one level up in hierarchy.","hash":"fig_DebugSkipOver","h4":"Figure 5.8: Skip over a node"},"146":{"id":146,"content":"Figure 5.9: Skip out of a node Use \"Skip over\" and \"Skip out\" cautiously as skipping out of a sequence before it is completed can leave the SUT in an unknown state that other sequences or tests in your test suite cannot react to.","hash":"fig_DebugSkipOut","h4":"Figure 5.9: Skip out of a node"},"147":{"id":147,"content":"Pro Tutorial","hash":"","h0":"Error or Exception triggering Debugging Mode | QF‑Test Tutorial"},"148":{"id":148,"content":"Pro Tutorial","hash":"home-link","h0":"Error or Exception triggering Debugging Mode | QF‑Test Tutorial"},"149":{"id":149,"content":"Error or Exception triggering Debugging Mode When debugging a test you may want run it until it encounters an error, an exception or sometimes even a warning and then have it pause in debugging mode. In this section you will see how this can be done while debugging the second test case. Please open the debugger menu and change the default options as follows: Activate the »Debugger«-»Enable debugger« menu item. Also activate the »Debugger«-»Options«-»Break on error« menu item. Afterwards, when you open the debugger menu and options submenu it should look like this:","hash":"tut_debug_start","h0":"Error or Exception triggering Debugging Mode"},"150":{"id":150,"content":"Figure 5.10: Set debugger options to pause on error We changed the debugger options because with default settings QF‑Test will not pause on exceptions or errors, as you saw earlier on. Select the \"Test-suite\" node and start test execution via \"Start test run\" . QF‑Test will pause at the faulty node and enter debugging mode:","hash":"fig_debugger_stops_at_error","h4":"Figure 5.10: Set debugger options to pause on error"},"151":{"id":151,"content":"Figure 5.11: Test run paused by error The node which halted test execution will be indicated by an arrow and its symbol will be surrounded by a red square. Also, an error dialog will inform you about the failed check. As always the run log is the key to resolving errors, so let's open it and find out how to resolve the error in the next section.","hash":"fig_debugger_stopped_by_error","h4":"Figure 5.11: Test run paused by error"},"152":{"id":152,"content":"Figure 5.12: Error Dialog Click the Jump to run log button in the error dialog.","hash":"fig_debug_error_dialog","h4":"Figure 5.12: Error Dialog"},"153":{"id":153,"content":"Pro Tutorial","hash":"","h0":"Resolving Errors directly from the Run log | QF‑Test Tutorial"},"154":{"id":154,"content":"Pro Tutorial","hash":"home-link","h0":"Resolving Errors directly from the Run log | QF‑Test Tutorial"},"155":{"id":155,"content":"Resolving Errors directly from the Run log The Jump to run log button from the dialog in \"Error Dialog\" will not only open the run log but takes us directly to the node that holds the error details. Apart from the actual error message you will find screenshots and a copy of the variable bindings table (stack trace), which we will introduce later on (The Variable Bindings table). The error details tell you that the expected value does not match with the one shown in the application. As the one in the application is correct we want to update the expected value with the one from the application. This can easily be achieved as follows: Right-click the red-bordered node \"Failed: Check text: default ...\" indicating the actual error Select »Update check node with current data« from the context menu.","hash":"tut_ResolveRunTimeError","h0":"Resolving Errors directly from the Run log"},"156":{"id":156,"content":"Figure 5.13: Update check node with current data This locates the corresponding Check text node in the test suite and updates the expected value of the Text attribute with the value got as indicated by the run log.","hash":"fig_DebugUpdateCheckNode","h4":"Figure 5.13: Update check node with current data"},"157":{"id":157,"content":"Figure 5.14: Corrected check node The previously faulty node still is highlighted with a red border since we have not run it again. Now continue execution by releasing the pause button . QF‑Test runs the rest of the test suite, i.e. the Check text and Cleanup nodes, and informs you at the end of the run that there was one error, which you have already fixed. Since the error has been fixed and we will continue using the test cases as examples you could rename the second test case and delete '(with error)' in its name as well as '(causing Error)' in the name of the test step.","hash":"fig_DebugCorrectedCheckNode","h4":"Figure 5.14: Corrected check node"},"158":{"id":158,"content":"Jump into run log: You do not have to wait for an error dialog to open the run log at the current point of execution (or close by). Whenever you are in debugging mode, select the »Debugger«-»Jump to Run log« menu option, or use the Ctrl⁠+⁠J shortcut. If you just want to open the run log without jumping to the current point of execution you can use Ctrl⁠+⁠L. This will work after the test run finished, too.","hash":"tut_JumpToRunLog tut_JumpToRunLog","h4":"Figure 5.14: Corrected check node"},"159":{"id":159,"content":"Pro Tutorial","hash":"","h0":"Pause Execution | QF‑Test Tutorial"},"160":{"id":160,"content":"Pro Tutorial","hash":"home-link","h0":"Pause Execution | QF‑Test Tutorial"},"161":{"id":161,"content":"Pause Execution When a test is being executed and you want to enter debugging mode you can quickly set a breakpoint at some node not yet executed. Or you can just hit the toolbar button \"Pause\" and QF‑Test will directly enter debugging mode. In order to resume execution just release the pause button . This is completely independent of the way you entered debugging mode. Depending on how focus demanding the SUT is, it may be difficult to focus QF‑Test long enough to hit the pause button. But you can still rely on the \"Don't Panic\" shortcut Alt⁠+⁠F12. It will pause all running tests immediately. To continue, press the same combination again.","hash":"tut_pause_execution","h0":"Pause Execution"},"162":{"id":162,"content":"Pro Tutorial","hash":"","h0":"Variables and Procedure Parameters (Java) | QF‑Test Tutorial"},"163":{"id":163,"content":"Pro Tutorial","hash":"home-link","h0":"Variables and Procedure Parameters (Java) | QF‑Test Tutorial"},"164":{"id":164,"content":"Variables and Procedure Parameters (Java) In this chapter you are going to learn how to use a procedure to perform the same action on various input data. You will also learn about variables - how to use and how to debug them. This chapter is also available as a video tutorial at \"Variables and Procedure Parameters\".","hash":"sec_variablestack","h1":"Variables and Procedure Parameters (Java)"},"165":{"id":165,"content":"Pro Tutorial","hash":"","h0":"Procedure using a variable | QF‑Test Tutorial"},"166":{"id":166,"content":"Pro Tutorial","hash":"home-link","h0":"Procedure using a variable | QF‑Test Tutorial"},"167":{"id":167,"content":"Procedure using a variable Have a look at the last test step 'Check final price' of our two test cases.","hash":"sec_ProcedureWithVariable","h0":"Procedure using a variable"},"168":{"id":168,"content":"Figure 6.1: Two almost identical test steps They perform the same action, however, with different data. Even though it is only one node, it makes sense to pack it into a procedure. We may want to adapt the hard coded values $$30,049.00 and $$26,100.00 to a different format so that the check will also work when the format of the price field changes to a different currency. And we do not want to implement the same algorithm twice. (If you wonder about the two dollar signs: This is what QF‑Test records for a dollar sign. For replay it does not matter whether you use one or two dollar signs.) Select the 'Check text' node in the first test case. Use »Operations«-»Pack nodes«-»Sequence« or use the Ctrl⁠+⁠Shift⁠+⁠S shortcut to pack it into a sequence. Name the sequence checkFinalPrice. The procedure name follows the Java convention to run the words together and start the single words with capital letters. On the other hand QF‑Test allows the use of spaces in procedure names, so you are free to name it as you like. Press Ctrl⁠+⁠Shift⁠+⁠P for the quickest way to transform the 'Sequence' node into a procedure, as you learned at the end of the last chapter. You see the sequence is replaced by a call to the 'checkFinalPrice' procedure. Double click the procedure call node to jump to the procedure definition. Open the procedure node to see its content.","hash":"fig_params1","h4":"Figure 6.1: Two almost identical test steps"},"169":{"id":169,"content":"Figure 6.2: Procedure with hard coded value As expected, the check is now located in this procedure. However, it is valid for one price only, i.e. $30,049.00. Since we want to use the same procedure for the second test case as well we need to make the price a variable and pass its value as a parameter from the test case to the procedure. In the next example we will start by defining a parameter for the procedure. Additionally, we will set a default value for the parameter. Default values are most useful when the parameter usually has that value and you do not want to specify it every time you call the procedure. Even though this does not hold true for the price it is a good example to demonstrate to you how a default parameter works and how to overwrite it with another value. Let's define the parameter and add a default value: Select the procedure 'checkFinalPrice' Press the \"Add new row\" button belonging to the table 'Parameter default values'. Enter price as name for the parameter. Enter $30,049.00 in the value field.","hash":"fig_procedure_hardcoded","h4":"Figure 6.2: Procedure with hard coded value"},"170":{"id":170,"content":"Figure 6.3: The Details of the 'Procedure' node The next step is to replace the value of the Text attribute of the Check text node by a reference to the variable.","hash":"fig_parameter_default_values_table","h4":"Figure 6.3: The Details of the 'Procedure' node"},"171":{"id":171,"content":"Variable syntax: When working with variables you need to bear in mind that in some places you need to tell QF‑Test the name of the variable and in others you want to refer to the value of the variable. In the Name column of the Parameter default values table of the Procedure node QF‑Test expects the name of a variable. It is price, which is why you typed the word price. In the Text attribute of the Check text node details QF‑Test expects a character string for comparison with the text of the UI element. As we want to use a value stored in a variable, we have to tell QF‑Test not to use the entered string as plain text, but to interpret it as a reference to the value stored in a variable. In QF‑Test this is done by enclosing the variable name in $(). In our case the variable reference is $(price). If you did not put the variable name into $(), QF‑Test would compare the price (a number) shown in the UI element to the string price, which is obviously nonsense. Select the Check text node in the procedure 'checkFinalPrice'. Type $(price) in the Text attribute of the Check text node details.","hash":"tut_VariableSyntax","h4":"Figure 6.3: The Details of the 'Procedure' node"},"172":{"id":172,"content":"Figure 6.4: 'Check text' node Run the first test case. It should execute without an error.","hash":"fig_ProcedureAddVariable","h4":"Figure 6.4: 'Check text' node"},"173":{"id":173,"content":"Pro Tutorial","hash":"","h0":"The Variable Bindings table | QF‑Test Tutorial"},"174":{"id":174,"content":"Pro Tutorial","hash":"home-link","h0":"The Variable Bindings table | QF‑Test Tutorial"},"175":{"id":175,"content":"The Variable Bindings table The next step is to make use of the procedure call in the second test case as well. Replace the Check text node of the second test case by a procedure call to checkFinalPrice. You can simply copy the respective node from the first test case or add the procedure call as learned in the previous chapter.","hash":"tut_variable_stack","h0":"The Variable Bindings table"},"176":{"id":176,"content":"Figure 6.5: Second procedure calls 'checkFinalPrice' If you added the procedure call by a copy or drag and drop operation from the procedure itself you will find the price in the Variable definitions table of the procedure call. This is what we are eventually aiming at. However, at this stage we want to explain the default value. So, if you want to follow the tutorial exactly, please delete the default value by pressing the red X above the table. Verify QF‑Test is configured to pause at errors as shown in Set debugger options to pause on error. Select the 'Test case: Second' node. Execute it by pressing or Enter. An error message shows up indicating different values for the price expected and the price got. What went wrong? Let's go hunting. Typically we use the run log for this but there is another view worth to know of. So click OK to close the error message. In debugging mode you will find an additional bottom right section of the QF‑Test window showing a list of nodes with variables bound to those nodes. You might want to resize the variable bindings table in case is too small to see all its content.","hash":"fig_AddProcedureCallToSecondTestcase","h4":"Figure 6.5: Second procedure calls 'checkFinalPrice'"},"177":{"id":177,"content":"Figure 6.6: Variable bindings The variable bindings table is very useful for debugging. It comes in quite handy, too, when working with procedures and trying to understand the way QF‑Test figures out which variable value to use. It shows the current values of the variables. QF‑Test always checks the variable bindings table from top to bottom. You can see that the first rows of the table have no bindings at all. Then there is a binding at the level 'Globals' and another one in the fallback stack for the procedure 'checkFinalPrice'. The global variable is used for the client connection, which has been set when starting the application (cf Starting the Application). The other variable is more interesting to us - only it has the wrong value. The default value is intended to be used for the parameter if no value has been defined elsewhere. This is why we added the parameter to the 'Parameter default values' table of the procedure node. To do things correctly we need to pass the proper value when calling the procedure. Again, there are several ways to do it. One is to add a new row to the variable definitions table of the 'Call procedure' nodes similarly to the way you did at the 'Procedure' node in the last section. If the procedure is called multiple times within the test suite, there is a better way: Stop the current test execution clicking the toolbar button . Right-click the 'Procedure' node and select »Additional node operations«-»Update parameters of references« from the popup menu.","hash":"fig_VariableBindingsTable1","h4":"Figure 6.6: Variable bindings"},"178":{"id":178,"content":"Right-click the 'Procedure' node and select »Additional node operations«-»Update parameters of references« from the popup menu. Figure 6.7: Popup menu for 'Additional node operations' In the following dialog, please check the tick mark for »Add missing parameters to callers« is set and click OK. In the 'Call procedure' nodes QF‑Test adds a row each for every default parameter to the variable definition table of the procedure call . It also copies the default value of each default parameter. In our case it is the parameter price with the value $30,049.00. You might notice that the numerical value of the price variable is still wrong in the second case, regardless of whether it is defined implicitly as a default value or explicitly via a parameter. For now we want to keep that error to show you additional means of debugging. Close the 'Updated nodes' dialog QF‑Test opened to inform you about the updated nodes.","hash":"fig_CompleteParameters","h4":"Figure 6.6: Variable bindings"},"179":{"id":179,"content":"Pro Tutorial","hash":"","h0":"Advanced debugging of variable bindings | QF‑Test Tutorial"},"180":{"id":180,"content":"Pro Tutorial","hash":"home-link","h0":"Advanced debugging of variable bindings | QF‑Test Tutorial"},"181":{"id":181,"content":"Advanced debugging of variable bindings Next, we want to explore the variable bindings table and see how it can be used for debugging purposes. For this reason do not correct the faulty value of the procedure call we added in the last section, but let us find out more about debugging. In the next steps we want to have QF‑Test pause the test execution at the procedure call. Then we will step into the procedure and, while doing so, have a look at the variable bindings table. Finally, we will navigate directly from the variable bindings table to the faulty procedure call and correct the parameter value. Add a breakpoint to the 'Call procedure: checkFinalPrice' node of the second test case. Run the second test case again. When QF‑Test stops at the breakpoint step into the procedure via and watch the table of the variable bindings as you do so.","hash":"tut_variable_stack_debugging","h0":"Advanced debugging of variable bindings"},"182":{"id":182,"content":"Figure 6.8: Variable bindings stack showing incorrect value As you step into the procedure, first the row 'Call procedure: checkFinalPrice' and with the next step the row 'Procedure: checkFinalPrice' appear at the top of the table. Now the variable price shows on two different levels of the variable bindings table: In the 'Call procedure: checkFinalPrice' row and the 'Procedure: checkFinalPrice' row on the fallback stack. Since we did not adapt the value of the parameter passed to the procedure, neither of the two values bound to the price variable is correct. QF‑Test lets you change the values of the variables interactively in the variable bindings table when you are in debugging mode. You can even add new variables or delete them. However, changes to variable values in the variable bindings table are not persistent. They only last as long as the variable is on the stack (variable bindings table). In our case, if we changed the price value, as long as the procedure is being executed. The parameter value in the procedure call will not be altered by changing the current value of the variable in the variable bindings table. To do so you have to navigate to the Procedure call node and change it there. To get there quickly, you just double-click the procedure call in the variable binding table (second row). This feature is particularly useful when debugging more complex tests where the node you want to jump to is not directly visible in the test suite window. You can invoke it via right-clicking the row and selecting »Jump to node in test suite« from the pop-up menu, too. Double-click the second row with the procedure call in the variable bindings table. Set the value of the parameter to the correct value, i.e. $26,100.00. When checking the variable bindings table you will notice that the current value has not changed. This is hardly surprising as we have not yet executed the procedure call again. Only, test execution is already past the procedure call. Fortunately, QF‑Test has another very useful debugging feature to set back (or forward) test execution to some node: »Continue execution from here«, which can be invoked either via the pop-up menu of the node you want to make the current node or by pressing Ctrl⁠+⁠, after selecting the node. In order to try out the newly set value: Right-click the 'Call procedure: checkFinalPrice' node of the second procedure. Select 'Continue execution from here' in the popup menu.","hash":"fig_VariableStack3","h4":"Figure 6.8: Variable bindings stack showing incorrect value"},"183":{"id":183,"content":"Figure 6.9: Continue Execution from here When checking the variable bindings table you will find that the top two rows have disappeared. This is because now we exited the procedure (even though 'backwards') and therefore the procedure call and all its variable bindings was taken off the call stack. Release the pause button . The test run should finish without error. As the variable bindings table is very useful when looking for incorrect variable values you will also find a copy of it in the run log whenever an error or exception is logged. It is written to the subnode 'Stack trace' of the node causing the error, showing the variable values at the time the error occurred.","hash":"fig_ProcedureContinueExecFromHere","h4":"Figure 6.9: Continue Execution from here"},"184":{"id":184,"content":"Locate the current Node: Sometimes during debugging you will navigate far away from the current node where execution stopped and eventually want to get back to it again. The easiest way to do so is by pressing the \"Locate Current Node\" button or select the »Debugger«-»Locate Current Node« menu option to cause the debugger to \"select\" the current node.","hash":"locate_current_node","h4":"Figure 6.9: Continue Execution from here"},"185":{"id":185,"content":"Pro Tutorial","hash":"","h0":"Setting Variables | QF‑Test Tutorial"},"186":{"id":186,"content":"Pro Tutorial","hash":"home-link","h0":"Setting Variables | QF‑Test Tutorial"},"187":{"id":187,"content":"Setting Variables In addition to the methods you have already seen, variables can also be set as follows: Via the Set variable node, as the return value of a procedure, as the result value of QF‑Test nodes like the Fetch text node, the Fetch geometry node, the Fetch index node and the Check node, in the 'Variable definitions' table of the 'Test-suite' node, the 'Test case' node, the 'Test step' node, the 'Sequence' node and others like the 'If' node or 'Loop' node, via command line parameters. For information about the best place where to define a variable please refer to the next section. You can insert a Set variable node via the menu item »Insert«-»Miscellaneous«-»Set variable«. In its details you can specifiy whether the value should be bound as a local or a global variable. The following figure shows the details of a Set variable node. (You can find it as the first node of the Setup node.) It defines a variable named client. It is a global variable as the Local variable attribute has not been checked.","hash":"tut_setting_variables","h0":"Setting Variables"},"188":{"id":188,"content":"Figure 6.10: Details of the Set variable node When you want to set a variable as the result of a procedure call you need to specify the variable name in the 'Variable for return value' attribute of the procedure call. Within the procedure itself you have to add a Return node with the value to be returned as the last node to be executed. The next figure shows a theoretical example of a procedure which returns a value. The procedure fetches the discount value displayed in the SUT and returns it to the calling test case. There, the receiving variable is named Discount and declared as a local variable.","hash":"fig_DetailsSetVariable","h4":"Figure 6.10: Details of the Set variable node"},"189":{"id":189,"content":"Figure 6.11: Procedure returning a value The Fetch text node of above example is one of the QF‑Test nodes directly setting a variable value. You need to specify the variable name in the attribute called accordingly. Again, you have the choice whether to make it local or global. Quite a number of nodes have a 'Variable definitions' table where you may define variables local to a procedure or a test case. If the respective node is part of a procedure the variable will be local to the procedure. Otherwise it will be local to the respective test case. Variables bound to the test suite node can be accessed from all nodes within the test suite. In debugging mode, all nodes you can bind a variable to will show up on the variable bindings table when entered. You can enter variables in the command line via the parameter -variable. For details please refer to the manual, chapter 'Command line arguments and exit codes'.","hash":"fig_DetailsCallProcedure","h4":"Figure 6.11: Procedure returning a value"},"190":{"id":190,"content":"Pro Tutorial","hash":"","h0":"Variable binding levels | QF‑Test Tutorial"},"191":{"id":191,"content":"Pro Tutorial","hash":"home-link","h0":"Variable binding levels | QF‑Test Tutorial"},"192":{"id":192,"content":"Variable binding levels This section may be difficult to understand when you are a programming beginner. Then it may be better to come back to it when you started writing procedures for your own tests. In QF‑Test there are many places where you can set a variable: The test suite node, in test cases and procedures as default or local variables, as a parameter in a procedure call, as a global variable and as a command line parameter. Now the question is: Which is the correct place for defining a variable? And the answer is: It depends on the use case. Each level of the variable bindings has its own use case: Procedure parameters When you call the same procedure several times in a test case and with different values each time you should set the values via a parameter at a procedure call. This is done by adding a row to the variable definitions table of a Procedure call node specifying the respective variable name and value. Local variables in a procedure They are created in the procedure and are deleted when the execution of the procedure finishes. Use a local variable when you do not need it outside of the current procedure. In procedures they are predestined for intermediate results. Local variables in a test case Variables local to a test case are either created during execution of a test case or defined in the respective table in the details of the test case node. They will be deleted from the variable bindings table once the test case finishes. Use them for values you want to refer to in several nodes of a test case and you do not need outside of it. Global variables Global variables are created at some point of the test execution and exist until they are explicitly deleted or QF‑Test is stopped. They survive stops and restarts of test execution. Use them for values that need to be accessible by all test cases. A typical example is the variable client created in the 'Setup' node when starting the application. To get rid of them you need to either exit QF‑Test or select the menu item »Run«-»Clear global variables«. Command line parameters In batch mode you may want to run test with various parameters. They are valid throughout the batch run. A typical example would be the browser to be used. Test-suite variables test suite variables can be referred to by all test cases. Their usage is the same as that of global variables. Only that they can be overridden at batch execution by command line parameters, whereas global variables cannot. Default values (Fallback stack) You can define default values for variables of procedures, test cases and test sets. In case you do not define a variable of the same name on a higher level QF‑Test will use the default value set.","hash":"tut_variable_levels","h0":"Variable binding levels"},"193":{"id":193,"content":"Pro Tutorial","hash":"","h0":"The Standard Library (Java) | QF‑Test Tutorial"},"194":{"id":194,"content":"Pro Tutorial","hash":"home-link","h0":"The Standard Library (Java) | QF‑Test Tutorial"},"195":{"id":195,"content":"The Standard Library (Java) This chapter is also available as a video tutorial at \"The Standard Library\". QF‑Test provides a certain number of node types. If you need additional functionality you can implement it in a script node. To make life easier for you QF‑Test comes with a set of procedures implementing the most commonly needed additional functions. You will find them in the standard procedures library. When you cannot solve a problem using the provided node types it is a good idea to have a look in the standard library whether there is a solution to your problem. If you find a similar solution you can copy the procedure and adapt it to your needs. For information about scripting please refer to the manual, chapter 12 'Scripting'. The file qfs.qft holds the standard procedures library. As it is constantly being enhanced and distributed with every new version of QF‑Test you should not make any changes to procedures in that file, but copy the procedure to your own test suite if required and then adapt it. To make use of qfs.qft it needs to be included in your test suite's root node. With a newly created test suite the file qfs.qft is added automatically to the list of included files. Select the 'Test-suite' root node of your test suite. Verify the qfs.qft is available within the table for \"Include files\". Add qfs.qft to this list, if it's not already there. Path information is not necessary for qfs.qft as the include directory of QF‑Test is contained in the library path (see also Reference part of the manual). Add a procedure call to an arbitrary procedure from the qfs.qft standard library. In the procedure chooser don't miss to switch to the respective tab. In addition to the description provided in this tutorial you can find the full HTML documentation of the standard library available via »Help«-»Standard Library qfs.qft...«","hash":"sec_StandardLibrary","h1":"The Standard Library (Java)"},"196":{"id":196,"content":"Pro Tutorial","hash":"","h0":"Inspecting the Standard Library | QF‑Test Tutorial"},"197":{"id":197,"content":"Pro Tutorial","hash":"home-link","h0":"Inspecting the Standard Library | QF‑Test Tutorial"},"198":{"id":198,"content":"Inspecting the Standard Library In addition to inserting procedure calls from the Standard Library, it also can be helpful to sometimes have a look how certain things have been implemented. Locate and load the test suite file qfs.qft, which is located in the qftest-10.0.2-pro/include directory of your QF‑Test installation.","hash":"sec_StandardLibraryOverview","h0":"Inspecting the Standard Library"},"199":{"id":199,"content":"Figure 7.1: The Standard Library You can see there is one main package qfs that contains further specific packages. The qfs package helps to easily identify the packages belonging to the standard library. The specific packages cover very different areas of utility procedures described in more detail further below. Within nearly all of the procedures of this library, you'll notice that the variable $(client) is referenced. This is the standard mechanism for creating independence from a specific SUT. Here, the library assumes that the test suite which uses the library will set a value for $(client) prior to using any procedures.","hash":"fig_SuiteQfsQft","h4":"Figure 7.1: The Standard Library"},"200":{"id":200,"content":"Pro Tutorial","hash":"","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"201":{"id":201,"content":"Pro Tutorial","hash":"home-link","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"202":{"id":202,"content":"Selected Packages and Procedures We will now have a closer look at a number of selected packages and procedures from the standard library. We will start with packages for accessing components dependent on the UI technology they are implemented with, say JavaFX, Java Swing, Eclipse/SWT and Web components.","hash":"sec_StandardLibraryPackages","h0":"Selected Packages and Procedures"},"203":{"id":203,"content":"The Checkbox Packages We begin by looking at the qfs.fx.checkbox qfs.swing.checkbox, qfs.swt.checkbox or qfs.web.checkbox package. Some important procedures within this package are: select Selects (checks) a checkbox. If the checkbox is already selected, then no action is taken. deselect Deselects (un-checks) a checkbox. If the checkbox is already deselected, then no action is taken. set Sets a checkbox to a given state (true or false). For each of these procedures, you pass the QF‑Test ID of a checkbox component as a variable argument. The library handles verification of whether or not the checkbox state was properly set as expected. Usage of the other procedures in this package follows the general model seen here.","hash":"sec_checkbox_package","h1":"The Checkbox Packages"},"204":{"id":204,"content":"The Combobox/Combo Packages The packages qfs.fx.combobox, qfs.swing.combobox, qfs.swt.combo or qfs.web.select contain procedures to select a value in a combobox. Some procedures within this package are: setValue Select a value in the list of the combobox. getItemCount Return the number of entries in the select box.","hash":"sec_combobox_package","h1":"The Combobox/Combo Packages"},"205":{"id":205,"content":"The General Packages The packages qfs.fx.general, qfs.swing.general, qfs.swt.general or qfs.web.general contain useful procedures to work with components. Some procedures within this package are: setLocation Set the location of a given component. setSize Set the size of a given component.","hash":"sec_general_package","h1":"The General Packages"},"206":{"id":206,"content":"The List Packages The packages qfs.fx.list, qfs.swing.list, qfs.swt.list or qfs.web.list contain useful procedures to work with lists. Some procedures within this package are: getItemCount Return the number of items of the list.","hash":"sec_list_package","h1":"The List Packages"},"207":{"id":207,"content":"The Menu Packages The qfs.fx.menu, qfs.swing.menu, qfs.swt.menu or qfs.web.menu packages allow you to easily select items and checkbox items from menus or sub-menus. The procedures visible after expanding the package node are: selectItem Selects an item from a menu. selectSubItem Selects an item from a sub-menu. For each of these procedures, you must pass the QF‑Test ID of the menus as well as the item and/or sub-item to select or check; the usage varies slightly depending on the nature of the procedure.","hash":"sec_menu_package","h1":"The Menu Packages"},"208":{"id":208,"content":"The Table Packages The packages qfs.fx.table, qfs.swing.table, qfs.swt.table and qfs.web.table provide utility procedures for tables, like: getRowCount Return the number of rows of a table. It uses technology specific methods to gather the row number. getColumnCount Return the number of columns of a table. It uses technology specific methods to gather the column number. selectCell Select a given table-cell.","hash":"sec_table_package","h1":"The Table Packages"},"209":{"id":209,"content":"The Tree Packages We've provided some simple access procedures for manipulating trees within the packages qfs.fx.tree, qfs.swing.tree, qfs.swt.tree and qfs.web.tree. These include: collapseNode Collapse a node of a tree using separate parameters. expandNode Expand a node of a tree using separate parameters. selectNode Select a given tree node. For any of these procedures, you simply pass the QF‑Test ID of the node you wish to manipulate.","hash":"sec_tree_package","h1":"The Tree Packages"},"210":{"id":210,"content":"The Cleanup Packages The packages qfs.fx.cleanup, qfs.swing.cleanup and qfs.swt.cleanup are useful for generic cleanup of the SUT environment after an unexpected exception occurs. Imagine, for example, that an exception is thrown while attempting to manipulate a menu in the SUT. The exception will cause the execution path within your test suite to be re-directed to an exception handler of a Catch node or of a dependency, or an \"implicit\" exception handler. This means that the normal flow of execution, which would have properly closed the open menu, has now been interrupted. Without proper action, that menu could be left open and thus block other events directed to the SUT. Some important procedures within this package are: closeAllModalDialogs Ensure that modal dialog windows of the SUT are closed. only available for Swing and FX! closeAllDialogsAndModalShells Ensure that dialog and modal shells of the SUT are closed. only available for Eclipse/SWT! closeAllMenus Close all menus of the SUT unconditionally. The concept of implicit exception handling is an important one as an exception in a single test case is not meant to stop the whole test run. Just the current test case needs to be aborted and then continue with the next test case. Therefore, an exception raised during the course of a Test case will be caught at that level and not propagated to prevent aborting the whole test run. The error state is duly noted in run log and report however. If the Test case uses a Dependency the exception is passed to the Catch node of the same, if available. This kind of exception (and error) handling is described in the Dependency chapter of the manual.","hash":"sec_cleanup_package","h1":"The Cleanup Packages"},"211":{"id":211,"content":"The Run log Package The qfs.run-log package contains procedures, which writes specified messages into the run log. This package has been introduced to give testers without scripting-knowledge the opportunity to write messages into the run log. Here is the list of the most important procedures within this package: logError Write a given error message into the run log. logWarning Write a given warning message into the run log. logMessage Write a given message into the run log.","hash":"sec_run_log_package","h1":"The Run log Package"},"212":{"id":212,"content":"The Run log.Screenshots Package The qfs.run-log.screenshots package contains procedures, which write images into the run log and some helper methods. Some important procedures within this package are: getMonitorCount Return the total number of monitors. logScreenshot Write a screenshot of the whole screen into the run log. logImageOfComponent Write an image of a given component into the run log. logScreenshotOfMonitor Write a screenshot of a given monitor into the run log.","hash":"sec_run_log_screenshots_package","h1":"The Run log.Screenshots Package"},"213":{"id":213,"content":"The Shellutils Package The qfs.shellutils package contains procedures to support most common shell-commands. Some important procedures within this package are: copy Copy a given file or directory to a specified target. deleteFile Delete a given file. exists Check for existence of a given file or directory. getBasename Return only the file name of a full file name. getParentdirectory Return only the directory name of the full file name. mkdir Create a given directory. It also creates non-existing directories in path. move Move a file of directory. touch Create a specified file. removeDirectory Remove a specified directory.","hash":"sec_shellutils_package","h1":"The Shellutils Package"},"214":{"id":214,"content":"The Utils Package The qfs.utils package contains procedures, which covers common helper-functionality during test-development. Some important procedures within this package are: getDate Return a string containing the date. Default is the current date. (Other dates can be configured.) getTime Return a string containing the time. Default is the current time. (Other timestamps can be configured.) logMemory Log current memory use. printVariable Print the content of a given variable to the console. printMessage Print a given message to the console. writeMessageIntoFile Write a given string into a given file.","hash":"sec_utils_package","h1":"The Utils Package"},"215":{"id":215,"content":"The Database Package The qfs.database package contains procedures to execute SQL commands on a database. Please note that the database driver must be in the class path, i.e. the respective jar file in the qftest plugin directory, before launching QF‑Test. To get more information about the connection-mechanism to your database, please ask your developers or see www.connectionstrings.com. Some important procedures within this package are: executeSelectStatement Execute a given SQL-Select-Statement. It stores the result in a global variable \"resultRows\" on the Jython variable stack and thus accessible from Jython scripts. Additionally, it stores the result in a group variable with the default name 'resultGroup', which can be accessed directy by QF‑Test nodes. executeStatement Execute a given SQL-command. Here any SQL command can be specified.","hash":"sec_database_package","h1":"The Database Package"},"216":{"id":216,"content":"The Check Package The qfs.check package contains procedures to do checks. Some important procedures within this package are: checkEnabledStatus Check, whether a component is enabled or disabled. It writes an error into the run log, if failing. checkSelectedStatus Check, whether a component is selected or not. It writes an error into the run log, if failing. checkText Check the text of a component. It writes an error into the run log, if failing.","hash":"sec_check_package","h1":"The Check Package"},"217":{"id":217,"content":"The Databinder Package The qfs.databinder package contains procedures for execution within a \"Data driver\" node which bind data for iteration. Some important procedures within this package are: bindList Create and register a databinder that binds a list of values to a variable. Variables are separated by whitespace or by a given separator character. bindSets Create and register a databinder that binds a list of value-sets to a set of variables. Value-sets are separated by line breaks. Variables within a value-set are separated by whitespace or by a given separator character.","hash":"sec_databinder_package","h1":"The Databinder Package"},"218":{"id":218,"content":"Pro Tutorial","hash":"","h0":"Control structures (Java) | QF‑Test Tutorial"},"219":{"id":219,"content":"Pro Tutorial","hash":"home-link","h0":"Control structures (Java) | QF‑Test Tutorial"},"220":{"id":220,"content":"Control structures (Java) The two most important control structures of QF‑Test are loops and the conditional execution of nodes. Loops can be implemented by two different kinds of nodes: While and Loop nodes. If, Elseif and Else nodes are available to implement conditional execution. This chapter is also available as a video tutorial at \"Control Structures\".","hash":"sec_controlstructures","h1":"Control structures (Java)"},"221":{"id":221,"content":"Pro Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"222":{"id":222,"content":"Pro Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"223":{"id":223,"content":"If - else You already came across If and Else nodes in the Setup sequence in the chapter Starting the Application. Let's have a closer look at the details of the nodes.","hash":"sec_if","h0":"If - else"},"224":{"id":224,"content":"Figure 8.1: Setup Sequence with if-else structures By means of an If node you can control whether certain nodes will be executed or not. In our case whether to start the SUT application. First, we need to find out if the client is already running. This is the job of the Wait for client to connect node, which writes the result of its inquiry, either true or false, into a variable named isSUTRunning.","hash":"fig_ControlsSetupSequence","h4":"Figure 8.1: Setup Sequence with if-else structures"},"225":{"id":225,"content":"Figure 8.2: Wait for client to connect writes the result into the variable \"isSUTRunning\" The If node has a Condition attribute where you'll find an expression evaluating the result variable isSUTRunning. As we want to refer to its value we need to use the syntax $() (see also note on variable syntax in chapter \"Procedure using a variable\").","hash":"fig_ControlsWaitForClient","h4":"Figure 8.2: Wait for client to connect writes the result into the variable \"isSUTRunning\""},"226":{"id":226,"content":"Figure 8.3: If node evaluates the variable Depending on whether the client is already running or not QF‑Test will execute the nodes nested in the If node. Stop the client in case it is running. Single-step through the Setup node. Leave the client running and single-step through the Setup node a second time. If you like you can check the value of the variable isSUTRunning in the variable bindings table. The first time it will have the value false so that the condition not $(isSUTRunning) will become true and the SUT will be started. The second time it will be true and the if-condition will fail. The nodes nested in the If node will be skipped. Within the first If node there is a second one checking the type of operation system - either Windows or else a different one (Linux or Mac). This is where the Else node comes in, which will be entered if the condition test of the If node fails (in our case: the operation system is not Windows). For checking the operating system you can directly resort to a QF‑Test variable: QF‑Test stores the information about the operation system in a group variable where the group is called 'qftest' and the variables 'linux', 'macos' or 'windows', respectively. The syntax for accessing group variables is ${group:varname}, e.g. ${qftest:windows}.","hash":"fig_ControlsIf","h4":"Figure 8.3: If node evaluates the variable"},"227":{"id":227,"content":"Pro Tutorial","hash":"","h0":"Loops | QF‑Test Tutorial"},"228":{"id":228,"content":"Pro Tutorial","hash":"home-link","h0":"Loops | QF‑Test Tutorial"},"229":{"id":229,"content":"Loops QF‑Test provides two different kinds of nodes loops: Loop nodes execute their child nodes for a certain number of times. However, you can leave the loop any time using a Break node. While nodes execute their child nodes until a certain condition becomes false. Again, you can leave it any time using a Break node. Loop nodes will always stop after the given number of times. In the case of While nodes, however, you need to make sure that the condition will become false at some point. Otherwise you would have an infinite loop. In interactive mode you can always stop execution by hitting the pause button . In batch mode you would have to kill the QF‑Test process. (You start QF‑Test in batch mode using the command line parameter -batch. Then QF‑Test does not start its UI and just executes the given test suite.) In the following exercise we want to implement a test case checking whether a certain row is displayed in the table of the CarConfig application. The actions of the test case will be: Determine the number of rows the table has. Loop over all rows and check if it is the row we are looking for. Break the loop when a match was found. Write an error to the run log if the row was not found. Please start with recording a check on the row of interest: Activate the check recording mode by clicking the toolbar button Right-click a row in the CarConfig application and select the menu item »Row« from the popup menu. Stop the recording by pressing . Change the name of the recorded sequence to e.g. 'Check row' Turn the recorded sequence into a test case by right-clicking it and selecting the submenu item »Transform node into«-»Test case« from the popup menu.","hash":"sec_loops","h0":"Loops"},"230":{"id":230,"content":"Figure 8.4: Transform a node into another one In general, QF‑Test lets you add nodes very efficiently by packing one node into another one: Open the test case node and pack the recorded Check node into a loop by right-clicking it and selecting the submenu item »Pack nodes«-»Loop« from the popup menu.","hash":"fig_ControlsTransformNodeInto","h4":"Figure 8.4: Transform a node into another one"},"231":{"id":231,"content":"Figure 8.5: Pack a node into another one QF‑Test evaluates dynamically which nodes may be packed into one another and only presents the appropriate ones. So, in case you do not find the 'Loop' submenu item make sure you have right-clicked the correct node. The same holds true for the 'Transform node into' and 'Insert node' methods. In the next series of actions we want to set the value for the Number of iterations attribute of the Loop node. In order to do so we need to find out how many rows the table has. There is no simple node that you could use. However, in the last chapter we learned that the standard library provides a lot of extended functionality. So let's insert the procedure getRowCount from the package qfs.swing.table in the standard library. Select the Test case node and press Ctrl⁠+⁠A Press the 'Select procedure' button left to 'Procedure name'. Click the tab 'qfs.qft' in the 'Select procedure' dialog. Navigate to 'getRowCount' in the package 'qfs.swing.table' Click 'OK' to select it. Adding a procedure via Ctrl⁠+⁠A was described in Manual creation of procedures. If you would like to check with the screenshots please have a look there. Enter the variable name rows in the Variable for return value attribute. Change the default value for the id in the variable definitions table to the QF‑Test component ID of the table, i.e. VehicleTable. Select the Loop node. Enter a reference to the variable $(rows) in the Number of iterations attribute of the Loop node. Enter the name of an iteration counter, e.g. i in the respective attribute of the Loop node.","hash":"fig_ControlsPackNodeInto","h4":"Figure 8.5: Pack a node into another one"},"232":{"id":232,"content":"Figure 8.6: Details of a Loop node In the next series of actions we will change the recorded row index to the iteration counter and add a variable for the result to the details of the Check node. Then we will add an If node after the Check node evaluating the result, with a Break node within to quit the loop when the row was found. Open the Loop node. Select the Check node. Change the recorded row index of the QF‑Test component ID to the iteration counter $(i). The QF‑Test component ID should now read VehicleTable@Model&$(i) Enter the variable name checkSucceeded in the 'Variable for result' attribute. Right-click the Check node and the submenu item »Insert node «-»Control structures«-»Break« from the popup menu. Pack the Break node into an If node by pressing Ctrl⁠+⁠Shift⁠+⁠I (Of course you can also pack it via the menu). Type $(checkSucceeded) in the 'Condition' attribute of the 'If' node. The variable checkSucceeded will be set to either true or false by the Check node so that the reference to the variable $(checkSucceeded) is all we need to enter in the 'Condition' attribute of the If node. In the next series of actions let's add an Else node as the last node in the Loop node. It will only be entered if all repetitions of the loop were executed, which in our case means that the row was not found and the check never became true. Collapse the If node if it is open. This is important because otherwise the Else node would belong to the If node and not to the Loop node. Right-click the If node and select the submenu item »Insert node «-»Control structures«-»Else«. Open the Else node. From the standard library insert the procedure logError contained in the package qfs.run-log as described above. Type Row not found in the value field of message in the Variable definitions table. Change the value of withScreenshots in the Variable definitions table from false to true. When you run tests in batch mode screenshots are a great help for analyzing errors. On the other hand a great number of screenshots lead to a big log-file. This is why the default value for withScreenshots is false. Last, let's complete the test case with Setup and Cleanup nodes and move it into the top part of the test suite. Copy the Setup and Cleanup nodes of 'Test set: Simple Tests' into the new test case as the first and last node. Move the test case from the Extras section into the top section of the test suite after the 'Test set: Simple Tests' node. This is what the new test case would look like:","hash":"fig_ControlsLoopDetails","h4":"Figure 8.6: Details of a Loop node"},"233":{"id":233,"content":"Figure 8.7: The new test case Execute the new test case. It should run without error. Then modify a value in the details of the Check items node, e.g. change the name of the car to Wrong value.","hash":"fig_ControlsTestcase","h4":"Figure 8.7: The new test case"},"234":{"id":234,"content":"Figure 8.8: Details of the Check items node Execute the new test case again. This time the Else node should be entered and you should get an error message.","hash":"fig_ControlsCheckDetails","h4":"Figure 8.8: Details of the Check items node"},"235":{"id":235,"content":"Pro Tutorial","hash":"","h0":"Now it is time to start your own application (Mobile) | QF‑Test Tutorial"},"236":{"id":236,"content":"Pro Tutorial","hash":"home-link","h0":"Now it is time to start your own application (Mobile) | QF‑Test Tutorial"},"237":{"id":237,"content":"Now it is time to start your own application (Mobile) After having spent a lot of time with all those example programs, you are now ready to start on your own application (if you really haven't already done so). This chapter is also available as a video tutorial at \"It's time to start your own Application\". The Quickstart Wizard available via the menu »Extras«-»Quickstart Wizard...« helps you to achieve this. Simply follow the wizard steps to generate the setup sequence. Please refer also to chapter 3 \"Quickstart\" in the user manual. Then go ahead with what you have learned in this tutorial - record small sequences of events and checks, turn them into procedures which go into your test library, then set up the test cases using procedure calls. Finally, we reached the end of the basic tutorial part.","hash":"sec_ownappmobile","h0":"Now it is time to start your own application (Mobile)"},"238":{"id":238,"content":"Pro Tutorial","hash":"","h0":"Web UI testing with QF‑Test | QF‑Test Tutorial"},"239":{"id":239,"content":"Pro Tutorial","hash":"home-link","h0":"Web UI testing with QF‑Test | QF‑Test Tutorial"},"240":{"id":240,"content":"Web UI testing with QF‑Test This part II of the tutorial is meant to help you learn the basic features and workflows of QF‑Test. It focuses on the test of web applications and its specifics. For testing Java applications please go to \"Java UI testing with QF‑Test\" or \"Native Windows UI testing with QF‑Test\" for native Windows programs, as those parts use the same scenarios but with different systems under test. In case you already have worked through one of the other parts but web testing is relevant for you as well, you might not want to work again through the all same scenarios. Hence you should have at least a look at the sections Creating the Setup Sequence, Web Component Recognition and Windows and components Section that contain web specific parts. In \"Advanced features of QF‑Test\" more advanced QF‑Test features are explained, applicable for all supported UI technologies.","hash":"sec_web","h1":"Web UI testing with QF‑Test"},"241":{"id":241,"content":"Pro Tutorial","hash":"","h0":"Working with a Sample Test suite (Web) | QF‑Test Tutorial"},"242":{"id":242,"content":"Pro Tutorial","hash":"home-link","h0":"Working with a Sample Test suite (Web) | QF‑Test Tutorial"},"243":{"id":243,"content":"Working with a Sample Test suite (Web) In this first chapter, we will have a look at a simple test suite, explain its major elements, execute it and evaluate the result. This chapter is also available as a video tutorial at \"Working with a Sample Test suite\".","hash":"sec_webdemo","h1":"Working with a Sample Test suite (Web)"},"244":{"id":244,"content":"Pro Tutorial","hash":"","h0":"Loading the Test suite | QF‑Test Tutorial"},"245":{"id":245,"content":"Pro Tutorial","hash":"home-link","h0":"Loading the Test suite | QF‑Test Tutorial"},"246":{"id":246,"content":"Loading the Test suite On first startup of QF‑Test and/or the System Under Test (SUT) via QF‑Test you might get a security warning from the firewall asking whether to block the Java network communication or not. As QF‑Test communicates with the SUT by means of network protocols, this must not be blocked by the local firewall in order to allow automated testing. After starting up QF‑Test, you can immediately bring up our first example test suite. Press the toolbar button to bring up the file open dialog Navigate to the subdirectory qftest-10.0.2-pro/doc/tutorial of your QF‑Test installation There select the file FirstWebTests.qft QF‑Test will then load the indicated test suite which should look as follows:","hash":"tut_loadsuiteweb","h0":"Loading the Test suite"},"247":{"id":247,"content":"Figure 10.1: The Test suite FirstWebTests.qft The left part of the main window contains the test suite, organized in a tree structure. The right side shows the details of a selected tree node. At bottom right you'll see the terminal displaying messages sent by QF‑Test and the application you are testing. In the tree structure of the main window you can navigate and select individual nodes of the test suite. Double click the node Test set: Simple Tests to expand it. You'll find the test set contains two test case nodes enclosed by a \"Setup\"/\"Cleanup\" pair.","hash":"fig_firstTestSuiteWeb","h4":"Figure 10.1: The Test suite FirstWebTests.qft"},"248":{"id":248,"content":"Figure 10.2: The \"Test set: Simple Tests\" Node In the following sections we'll describe the purpose and function of the individual nodes.","hash":"fig_firstTestSetWeb","h4":"Figure 10.2: The \"Test set: Simple Tests\" Node"},"249":{"id":249,"content":"Pro Tutorial","hash":"","h0":"Starting the Browser | QF‑Test Tutorial"},"250":{"id":250,"content":"Pro Tutorial","hash":"home-link","h0":"Starting the Browser | QF‑Test Tutorial"},"251":{"id":251,"content":"Starting the Browser Our first step is to examine the \"Setup\" node: Expand the Setup: Open Demo Page node now.","hash":"tut_startsutweb","h0":"Starting the Browser"},"252":{"id":252,"content":"Figure 10.3: The Setup Node In the \"Setup\" node you'll see two child Sequence nodes: Set global variables dependent on OS - defines the global client variable used throughout the test suite and variables for the browser to be used dependent on the operating system (Chrome on Windows and macOS, Firefox on Linux). Start browser if necessary - starts the respective browser if it is already not running and loads the demo web page. Let's also have a brief look inside the Sequence: Start browser if necessary:","hash":"fig_firstSetupWeb","h4":"Figure 10.3: The Setup Node"},"253":{"id":253,"content":"Figure 10.4: The Sequence to start the Browser First you see a \"Wait for client\" node to double-check whether the client is already running. Only if it is not, it will be started. The browser start itself happens in four steps: Start web engine - starts the browser process to allow configuration. Perform browser settings - configure the browser (e.g. cache, cookies, proxy settings, ...). Open browser window - open the browser window and wait for the web page to be loaded. Install CustomWebResolver - configure component mapping, so QF‑Test will recognize the functionality of components (text field, button, data table etc). Section Web Component Recognition explains the reasons why this is advisable, along with information on the configuration. These four steps are automatically generated when you use the Quickstart Wizard, that will be explained in the next tutorial \"Creating your own test suite (Web)\". At this point, we're ready to actually start the Browser: Click on the Setup: Open Demo Page\" so it is selected but still expanded (the child nodes stay visible). Click the Start test run toolbar button. This button causes the selected node to be executed. During execution QF‑Test marks the active step by use of an arrow pointer \"->\". When the setup sequence is completed, the browser with the \"CarConfigurator\" demo page is going appear on the screen.","hash":"fig_firstStartWeb","h4":"Figure 10.4: The Sequence to start the Browser"},"254":{"id":254,"content":"Figure 10.5: The CarConfigurator web demo page","hash":"fig_webDemoPage","h4":"Figure 10.5: The CarConfigurator web demo page"},"255":{"id":255,"content":"Pro Tutorial","hash":"","h0":"First Test case | QF‑Test Tutorial"},"256":{"id":256,"content":"Pro Tutorial","hash":"home-link","h0":"First Test case | QF‑Test Tutorial"},"257":{"id":257,"content":"First Test case Let's check out now what test case \"First\" contains. There are four test steps inside:","hash":"tut_firsttestweb","h0":"First Test case"},"258":{"id":258,"content":"Figure 10.6: The \"First\" Test case Reset - performs a reset by use of the File->Reset menu action. Select Model I5 - chooses the last model I5 within the vehicles table. Select Special Model Jazz - switches to the Specials tab and choose the Jazz option. Check Final Price - checks that the calculated final price field located at bottom right equals a given value. Test steps are used to group the nodes and to document what is being done. This will prove very useful when it comes to error analysis or test adaptations. Expand the four test step nodes.","hash":"fig_firstTestCaseWeb","h4":"Figure 10.6: The \"First\" Test case"},"259":{"id":259,"content":"Figure 10.7: Details of the first Test case You can see Mouse clicks and Checks, which have been grouped in test step nodes for better readability of the test case. The action nodes display the action type (Mouse click, Check, ...) and the component targeted, i.e. where the action goes to. When writing a test you can use the QF‑Test recording function to create them. Recording will be explained in the next \"Creating your own test suite (Web)\". Please select the test case \"First\" node Click the replay button . The test steps will then be replayed in the SUT, which will happen very quickly. The test result is indicated during and after the test run in the status line at the bottom of the QF‑Test main window and should read now 'Finished: No errors'. Next to it there are counters for the numbers and results of the test cases executed. In our case it was just one, error-free, which means a success rate of 100%.","hash":"fig_firstTestCaseDetailsWeb","h4":"Figure 10.7: Details of the first Test case"},"260":{"id":260,"content":"Figure 10.8: The result view in the status line Each counter icon has a descriptive tool tip. A list of all counters can be found in the chapter 'Capture and replay' of the manual.","hash":"fig_resultOneTestCaseNoErrorWeb","h4":"Figure 10.8: The result view in the status line"},"261":{"id":261,"content":"Pro Tutorial","hash":"","h0":"Second Test case - with Error | QF‑Test Tutorial"},"262":{"id":262,"content":"Pro Tutorial","hash":"home-link","h0":"Second Test case - with Error | QF‑Test Tutorial"},"263":{"id":263,"content":"Second Test case - with Error The second test case will show us what happens when an error occurs during test execution. Expand the test case \"Second (with Error)\".","hash":"tut_secondtestweb","h0":"Second Test case - with Error"},"264":{"id":264,"content":"Figure 10.9: The Second Test case Apart from the third test step it is identical to the first test case. So what does this one do? Test step: Grant 10% discount - Writes the value 10 into the discount field. The 'Input' node is another basic action node and can be created directly via the QF‑Test recording function. Expand the Test step: Grant 10% Discount.","hash":"fig_secondTestCaseWeb","h4":"Figure 10.9: The Second Test case"},"265":{"id":265,"content":"Figure 10.10: Details of the second Test case Let's execute the second test case: Select the node Test case: \"Second (with Error)\". Click the replay button . This time a dialog shows up telling us that an error occurred.","hash":"fig_SecondTestCaseDetailsWeb","h4":"Figure 10.10: Details of the second Test case"},"266":{"id":266,"content":"Figure 10.11: Error in the second test case What happened? To find out we'll open the QF‑Test run log for error analysis. An alternative approach for error analysis would be to execute the test case again using the debugger. This will be explained in chapter Using the Debugger (Web).","hash":"fig_textTestErrorWeb","h4":"Figure 10.11: Error in the second test case"},"267":{"id":267,"content":"Pro Tutorial","hash":"","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"268":{"id":268,"content":"Pro Tutorial","hash":"home-link","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"269":{"id":269,"content":"The Run log for Error Diagnosis QF‑Test logs detailed information for every test execution. Please open the latest run log by one of the following options: either by pressing the Show run log button of the error dialog or in case you have already closed the dialog by pressing toolbar button or by pressing Ctrl⁠+⁠L. The most recent run logs are also listed at the bottom of the Run menu of the main window. The run log comes up in a separate window displaying the logged actions of the test case you've just executed:","hash":"tut_firstrunlogweb","h0":"The Run log for Error Diagnosis"},"270":{"id":270,"content":"Figure 10.12: Run log for the second test case The run log reflects the tree structure of the test suite view you are already familiar with. When you click on one of the nodes on the left side, the properties of the event including time stamp and duration will be displayed on the right. In the tree left you will notice nodes surrounded by a red border. These are indicators showing where a problem occurred in a child node. If you keep expanding the red nodes, you'll eventually come to the actual error node. Please use an easier way to find the error source by pressing the Find next error toolbar button or the [Ctrl-N] key shortcut. All nodes with red highlighting have been expanded and the actual error node has been selected:","hash":"fig_firstErrorRunlogWeb","h4":"Figure 10.12: Run log for the second test case"},"271":{"id":271,"content":"Figure 10.13: Error in the second test case The error message on the right says that the expected value of the final price field differs from the actual one. Of course this error is there by intention as the second test case is supposed to show us how to analyze an error. Another helper for error analysis is the Screenshot of the SUT taken at the time when the error occurred (four nodes down from the red node). Being able to see the state of the SUT at that moment often proves useful for determining the cause of the error. The following image shows a screenshot node:","hash":"fig_firstErrorRunlogDetailsWeb","h4":"Figure 10.13: Error in the second test case"},"272":{"id":272,"content":"Figure 10.14: Screenshot node showing the error situation In addition to screenshots of all monitors, QF‑Test also saved images of the client windows at the time of the error. This allows you to analyze the contents even if they are covered by other dialogs or windows.","hash":"fig_firstErrorRunlogScreenshotWeb","h4":"Figure 10.14: Screenshot node showing the error situation"},"273":{"id":273,"content":"Pro Tutorial","hash":"","h0":"Getting Help | QF‑Test Tutorial"},"274":{"id":274,"content":"Pro Tutorial","hash":"home-link","h0":"Getting Help | QF‑Test Tutorial"},"275":{"id":275,"content":"Getting Help We take a short break in this section to give you a few tips that might prove helpful as you continue with the tutorial. There are different places where you can look for help or information: The most comprehensive search can be achieved via »Help«-»Online search...«. This navigates you to the search functionality on our homepage and allows querying throughout all available documentation (manual, tutorial, standard library, blog and our videos). Search results can be filtered as needed. In case you work offline and want to search for a certain topic, the offline versions of the manual or tutorial available via the »Help« menu can be used. QF‑Test also offers a context sensitive help for tree node types and their details. To use it, simply press the right mouse button on an arbitrary tree node or attribute in the details pane. From the context menu select »What's this?«. This will directly bring you to the reference explanation of this item in the manual. Beside getting help from the documentation you also have the option to contact our support team. During your evaluation phase or after that as customer with a valid maintenance contract you may issue your questions directly to our support experts using the QF‑Test help menu entry »Contact the support team« or our website.","hash":"tut_firsthelpweb","h0":"Getting Help"},"276":{"id":276,"content":"Pro Tutorial","hash":"","h0":"Stopping the Application | QF‑Test Tutorial"},"277":{"id":277,"content":"Pro Tutorial","hash":"home-link","h0":"Stopping the Application | QF‑Test Tutorial"},"278":{"id":278,"content":"Stopping the Application We haven't inspected the cleanup sequence, so let's have a look at it now: Expand the Cleanup: Stop Demo node.","hash":"tut_firstcleanupweb","h0":"Stopping the Application"},"279":{"id":279,"content":"Figure 10.15: The Cleanup Sequence The Cleanup sequence stops the client process in a hard way and waits until it fully terminates. This is a very simple approach and shall suffice for the moment. Execute the cleanup to see the Browser with the CarConfigurator demo vanish.","hash":"fig_firstCleanupWeb","h4":"Figure 10.15: The Cleanup Sequence"},"280":{"id":280,"content":"Pro Tutorial","hash":"","h0":"A full Test Run | QF‑Test Tutorial"},"281":{"id":281,"content":"Pro Tutorial","hash":"home-link","h0":"A full Test Run | QF‑Test Tutorial"},"282":{"id":282,"content":"A full Test Run After we have seen how the single elements of the test set work, let us have a look at the functionality provided by the test set node. First, close the browser window with the CarConfigurator demo in case it is still running. Then select the \"Test set: Simple Tests\" node. Execute it with the replay button . The result dialog will come up after test execution, informing us about the error caused by the second test case. Open the run log again by to take a closer look:","hash":"tut_firstFullRunWeb","h0":"A full Test Run"},"283":{"id":283,"content":"Figure 10.16: Run log for the Completed Test set This shows the special behavior of Setup / Cleanup nodes in a test set: They are executed before and after each test case to help achieving a proper starting state for each test case. Stopping the SUT after each test case is not the smartest way to ensure a clean state. There are more elegant ways for setup and cleanup that will be explained with the advanced features in this tutorial (\"Dependencies: Automatically ensuring correct prerequisites for each Test case\").","hash":"fig_webRunlogFull","h4":"Figure 10.16: Run log for the Completed Test set"},"284":{"id":284,"content":"Pro Tutorial","hash":"","h0":"Report Generation | QF‑Test Tutorial"},"285":{"id":285,"content":"Pro Tutorial","hash":"home-link","h0":"Report Generation | QF‑Test Tutorial"},"286":{"id":286,"content":"Report Generation In the world of quality assurance documenting test results is important. To this end, QF‑Test offers an automated report-generation feature. Since you've just done a complete test run, we're at a good point to show you this feature. Make sure the run log of the test run is open. In the run log window select »File«-»Create report...« to bring up the dialog for the report parameters.","hash":"tut_firstreportweb","h0":"Report Generation"},"287":{"id":287,"content":"Figure 10.17: Report Generation Properties In the first field, you can specify the file name of the report. Following this, you can decide what type of report you want. QF‑Test offers three kinds of reports, HTML, XML and JUnit format. An XML report is useful if you want to process the data further, e.g. if you have written your own XSLT stylesheets to shape the report. JUnit reports prove useful when you need to import results into build or test management tools. Let's generate an HTML report from the results of the last test run. So just leave the report options unchanged. Start generation by pressing the OK button. The report will then be generated and presented to you in a browser window:","hash":"fig_webReportDialog","h4":"Figure 10.17: Report Generation Properties"},"288":{"id":288,"content":"Figure 10.18: An HTML Report The report begins with a summary containing informational data from your system on the top left side, a legend describing the meaning of icons used in the report on the top right side, an overview pie chart in the middle and the overall test result below. In our case, the result we see are the error-free first test case and the second with the well-known error, leading to a success rate of 50%. Following the summary there are three overview sections: Test suites that have been executed within the test run. Test suites in which errors occurred. Errors including their exact position and detailed message. The report generator is very useful for creating an overview document for presentation and archiving purposes.","hash":"fig_webReportHtml","h4":"Figure 10.18: An HTML Report"},"289":{"id":289,"content":"Pro Tutorial","hash":"","h0":"Creating your own test suite (Web)\n     | QF‑Test Tutorial"},"290":{"id":290,"content":"Pro Tutorial","hash":"home-link","h0":"Creating your own test suite (Web)\n     | QF‑Test Tutorial"},"291":{"id":291,"content":"Creating your own test suite (Web) In the second chapter of the Web tutorial we will create our own sequences for starting and stopping an SUT from QF‑Test. Furthermore we are going to record actions and checks and use those to build up a simple test case. This chapter is also available as a video tutorial at \"Creating your own test suite\".","hash":"sec_webtestsuite","h1":"Creating your own test suite (Web)"},"292":{"id":292,"content":"Pro Tutorial","hash":"","h0":"Creating the Setup Sequence | QF‑Test Tutorial"},"293":{"id":293,"content":"Pro Tutorial","hash":"home-link","h0":"Creating the Setup Sequence | QF‑Test Tutorial"},"294":{"id":294,"content":"Creating the Setup Sequence To begin, you need to launch the application from QF‑Test. The Quickstart Wizard helps to generate the respective setup sequence. Please open a new test suite via the menu item »File« »New test suite...«. Open the Quickstart Wizard via the menu »Extras«-»Quickstart Wizard...« . In the first step you can choose the type of application to be tested. Please select the second option A web application in a browser. Press Next.","hash":"tut_quickstartweb","h0":"Creating the Setup Sequence"},"295":{"id":295,"content":"Figure 11.1: Type of Application In step two you are asked for the URL of the web page to be tested. Typically an HTTP-based URL is given here, but we will use the local CarConfig webdemo. Press the toolbar button to bring up the file open dialog Navigate to the directory .../qftest-10.0.2-pro/demo/carconfigWeb/html from your QF‑Test installation There, select the file CarConfig.htm. Conclude the file selection. In the figure below we used the QF‑Test variable ${qftest:dir.version} to address the version specific directory of the QF‑Test installation, which you have already come across in the previous chapter. (Details on special QF‑Test variables can be found in the manual chapter Variables).","hash":"fig_WizardTypeWeb","h4":"Figure 11.1: Type of Application"},"296":{"id":296,"content":"Figure 11.2: Specification of the URL. Press the Finish button, as we do not need to go to the further optional steps for our simple demo. Concerning the browser to be used for testing this means the wizard default will be selected (Chrome on Windows and macOS, Firefox on Linux). Just in case this is not possible for any reason, please checkout the optional next wizard steps to select a different browser. We directly reach the final summary that explains what will happen after closing the wizard and how to continue. Please press Finish in order to end the wizard.","hash":"fig_WizardWebUrl","h4":"Figure 11.2: Specification of the URL."},"297":{"id":297,"content":"Figure 11.3: Final Information The generated setup sequence Launch CarConfig_en appears in the \"Extras\" section of your test suite and looks equivalent to the one we already know for the last chapter (\"Starting the Browser\").","hash":"fig_WizardFinalWeb","h4":"Figure 11.3: Final Information"},"298":{"id":298,"content":"Figure 11.4: Generated Setup Sequence Now we want to see some action: Please ensure the Setup: Launch CarConfig_en node is selected. Then click or simply hit \"Enter\" Return. You should see the browser appear on your screen soon. First it shows a page that redirects you to the CarConfig demo. As the focus changes back to QF‑Test after the execution, the browser might get covered by the test suite window.","hash":"fig_WizardResultWebOwn","h4":"Figure 11.4: Generated Setup Sequence"},"299":{"id":299,"content":"Figure 11.5: The \"CarConfigurator Web\" demo page in the browser At the end of this section let's save our test suite. Press the toolbar button or use the »File«-»Save« menu option with its short-cut Ctrl⁠+⁠S. In the file explorer navigate to an appropriate directory where you have write access e.g. Documents in your user home directory. Provide a name e.g. MyFirstTests.qft. Finish the saving action by pressing on Save.","hash":"fig_webDemoPage2","h4":"Figure 11.5: The \"CarConfigurator Web\" demo page in the browser"},"300":{"id":300,"content":"Pro Tutorial","hash":"","h0":"Recording Actions | QF‑Test Tutorial"},"301":{"id":301,"content":"Pro Tutorial","hash":"home-link","h0":"Recording Actions | QF‑Test Tutorial"},"302":{"id":302,"content":"Recording Actions You're now ready to record some actions for our demo:","hash":"tut_recactionsweb","h0":"Recording Actions"},"303":{"id":303,"content":"Figure 11.6: Recording actions on the \"CarConfigurator Web\" demo Please press the Record button. Switch to the \"CarConfigurator Web\" window. From now on every mouse and keyboard action performed within the SUT window will be recorded. Click to the table cell I5 in the last row. Change to the Specials tab of the tabbed pane. Choose the special Jazz from the combo box. Finally switch back to the Vehicles tab in the tabbed pane. Stop the recording by use of the button. You'll find the recorded sequence placed in the \"Extras\" section:","hash":"fig_webDemoPageRec","h4":"Figure 11.6: Recording actions on the \"CarConfigurator Web\" demo"},"304":{"id":304,"content":"Figure 11.7: The Recorded Sequence The recorded sequence has a default name with date and time of the recording. You can change this name as you see fit by simply clicking on the node and changing its properties in the details view on the right. Please rename the recorded sequence to \"Select Model I5 Jazz\". Then open the sequence node to see its content. There should be the expected mouse clicks. You should even be able to interpret where they go to.","hash":"fig_FirstRecordedSequenceWeb","h4":"Figure 11.7: The Recorded Sequence"},"305":{"id":305,"content":"Figure 11.8: The Renamed Sequence Now, let us replay the recorded sequence. Select the Select Model I5 Jazz sequence node. Press the play button . You should now see exactly the same sequence of mouse events executed in the SUT as you recorded before. The sequence is supposed to replay (even multiple times) without errors. You should see \"Finished: No error\" in the bottom right corner of your test suite window. While recording, QF‑Test recognized the functional entities like the data table, the tab and the combo box, and subsequently addresses the subitems by index. For details see Addressing subitems of tables, lists and trees. This was possible due to the correct configuration of the component mapping. For further information see Web Component Recognition.","hash":"fig_FirstRecordedSequenceRenamedWeb","h4":"Figure 11.8: The Renamed Sequence"},"306":{"id":306,"content":"Pro Tutorial","hash":"","h0":"Recording Checks | QF‑Test Tutorial"},"307":{"id":307,"content":"Pro Tutorial","hash":"home-link","h0":"Recording Checks | QF‑Test Tutorial"},"308":{"id":308,"content":"Recording Checks To verify the client's behavior we use check nodes, which query certain states and properties of elements within the SUT. Also checks can be recorded. Click the \"Record a check\" button. Switch to the SUT window. When moving the mouse over the components you will notice a blue border indicating the current selection. Right-click the value field of \"Final price\". In the popup menu you are offered a choice of standard checks for a text field component. Select the first option \"Text\" for a check on the textual value of the field. Stop the recording by using the Stop button. Again, the newly recorded sequence appears in the \"Extras\" section. Please rename the sequence to \"Check final price\" Expand it to see the check node.","hash":"tut_recchecksweb","h0":"Recording Checks"},"309":{"id":309,"content":"Figure 11.9: The recorded check node Feel free to run this sequence, too, verifying it is working properly. As the next step, we want to create a test case from the two sequences.","hash":"fig_TextCheckTreeWeb","h4":"Figure 11.9: The recorded check node"},"310":{"id":310,"content":"Pro Tutorial","hash":"","h0":"Setting up a test suite | QF‑Test Tutorial"},"311":{"id":311,"content":"Pro Tutorial","hash":"home-link","h0":"Setting up a test suite | QF‑Test Tutorial"},"312":{"id":312,"content":"Setting up a test suite The top-level nodes of the test suite define its basic structure: Right after the \"Test-suite\" node an arbitrary number of \"Test set\" and \"Test case\" nodes may be added specifying the functional tests. \"Procedures\" contains reusable sequences (procedures) that can be organized into packages. \"Extras\" is the scratch pad for recording and experimentation. \"Windows and components\" contains the all-important elements of the test suite: registered elements of the SUT , e.g. windows, menus and buttons. The details of each element in the \"Windows and components\" section contains the properties of the recorded UI element required by QF‑Test to find the component when replaying a test. Functional test cases are represented by \"Test case\" nodes and can be grouped and structured with the help of \"Test set\" nodes. \"Setup\" and \"Cleanup\" nodes are intended for test steps ensuring a well-defined state before and after a test case. Let's start by renaming the top-level test set node from \"unnamed\" to \"Demo Tests\". If a dialog pops up asking us whether to update references we can simply confirm with \"Yes\". The second step is to move the \"Setup\" node generated by the Quickstart Wizard from the \"Extras\" node into the \"Test set\" node - right before the \"Test case\" node. Moving the \"Setup\" node can be done via mouse (Drag&Drop), context-menu (right mouse-button copy/paste) or by Ctrl⁠+⁠X and Ctrl⁠+⁠V keyboard commands.","hash":"tut_buildtestweb","h0":"Setting up a test suite"},"313":{"id":313,"content":"Figure 11.10: Start organizing the test suite The next step is to make a test case of the two sequences previously recorded. Please rename the test case node from \"unnamed\" to \"First\". Open the test case node by clicking the '>' symbol. Move the two sequences from \"Extras\" into the test case. You need to open the test case node because otherwise QF‑Test would try to place the sequence nodes after the test case node on the same level, which is not a valid option. QF‑Test always records sequence nodes. They have the same functionality as test step nodes, only they do not show up in the report. So, just to show you, we will transform the two sequence nodes into test step nodes. Please open the context menu for the first of the two sequence nodes by a right-click. Choose »Transform node into...«-»Test step« Repeat this for the second sequence node. Your test suite should now look like this:","hash":"fig_beginbuildatest_web","h4":"Figure 11.10: Start organizing the test suite"},"314":{"id":314,"content":"Figure 11.11: The Organization of your test suite Now you've completed the most important steps of structuring a test suite.","hash":"fig_buildatest_web","h4":"Figure 11.11: The Organization of your test suite"},"315":{"id":315,"content":"Pro Tutorial","hash":"","h0":"Stopping the Demo | QF‑Test Tutorial"},"316":{"id":316,"content":"Pro Tutorial","hash":"home-link","h0":"Stopping the Demo | QF‑Test Tutorial"},"317":{"id":317,"content":"Stopping the Demo The only thing missing now is a cleanup sequence closing down the SUT. There are usually various ways to terminate an SUT, e.g. clicking the close button of the application window, pressing ALT-F4 or via the menu action »File«-»Exit«. All these options can be directly recorded and then used in the cleanup sequence. Let's use the first one. Start recoding . Click the window closing button of the browser. You see the demo window close. Stop recording . Rename the recorded sequence to \"Stop demo\". Open the context menu for the recorded sequence and select »Convert into...«-»Cleanup«. Finally move the cleanup node up to be the last node in the test set. The cleanup node can only be dragged and dropped to the test set if the test set's last child node is collapsed. To expand or collapse a node during a drag and drop operation, hold your cursor over the triangle next to the node. You should end up with the following:","hash":"tut_cleanupweb","h0":"Stopping the Demo"},"318":{"id":318,"content":"Figure 11.12: The simple cleanup sequence By this we have finished with the basic steps of structuring our suite.","hash":"fig_StopSequenceWeb","h4":"Figure 11.12: The simple cleanup sequence"},"319":{"id":319,"content":"Pro Tutorial","hash":"","h0":"Running the whole test suite | QF‑Test Tutorial"},"320":{"id":320,"content":"Pro Tutorial","hash":"home-link","h0":"Running the whole test suite | QF‑Test Tutorial"},"321":{"id":321,"content":"Running the whole test suite Finally let's execute our newly created suite: Terminate the SUT client in case it is running. Select the root node of the test suite. Run it by pressing \"Replay\" or typing Return. The SUT is expected to appear, the test case will be executed and finally the SUT will be terminated. We know the test run details can be looked up in the run log. It can be opened by clicking the toolbar button or via the »Run«-»1. ...« menu option with its short-cut Ctrl⁠+⁠L","hash":"tut_runownsuiteweb","h0":"Running the whole test suite"},"322":{"id":322,"content":"Figure 11.13: The Run log of the test suite In the first tutorial chapter we've already learned how to use the run log for error analysis.","hash":"fig_FirstRunLogWeb","h4":"Figure 11.13: The Run log of the test suite"},"323":{"id":323,"content":"Pro Tutorial","hash":"","h0":"Writing a Procedure (Web) | QF‑Test Tutorial"},"324":{"id":324,"content":"Pro Tutorial","hash":"home-link","h0":"Writing a Procedure (Web) | QF‑Test Tutorial"},"325":{"id":325,"content":"Writing a Procedure (Web) This chapter is also available as a video tutorial at \"Writing a Procedure\". In the two previous chapters you learned how to start an application from QF‑Test thus being able to record mouse and keyboard actions, add checks and organize the result in a test case. This approach is fine and sufficient as long as your tests are simple and you have just a few of them. But as soon as the number of tests increases it is important to make use of so-called 'procedures'. Procedures make sequences reusable and therefore avoid duplicated identical parts. This is important for easy and on the long run efficient maintenance of your tests. Procedures can be organized into packages . Procedures and packages are the basis for modularizing your tests.","hash":"sec_FirstProcedureWeb","h1":"Writing a Procedure (Web)"},"326":{"id":326,"content":"Pro Tutorial","hash":"","h0":"Identifying reusable parts | QF‑Test Tutorial"},"327":{"id":327,"content":"Pro Tutorial","hash":"home-link","h0":"Identifying reusable parts | QF‑Test Tutorial"},"328":{"id":328,"content":"Identifying reusable parts In this chapter we will work with the test suite FirstJavaTests.qft you already know from chapter one. Copy FirstWebTests.qft from the subdirectory qftest-10.0.2-pro/doc/tutorial of the QF‑Test installation to a working directory and open FirstWebTests.qft. If you want to keep the changes you will be making to the demo test suite save it in a working directory as described at the end of \"Creating the Setup Sequence\". Please have a look at the test step \"Reset\" in the two test cases. They are exactly the same.","hash":"tut_procreuseweb","h0":"Identifying reusable parts"},"329":{"id":329,"content":"Figure 12.1: Two identical test steps Following above concepts it would be a good idea to turn them into a procedure.","hash":"IdenticalTeststepsWeb","h4":"Figure 12.1: Two identical test steps"},"330":{"id":330,"content":"Pro Tutorial","hash":"","h0":"Manual creation of procedures | QF‑Test Tutorial"},"331":{"id":331,"content":"Pro Tutorial","hash":"home-link","h0":"Manual creation of procedures | QF‑Test Tutorial"},"332":{"id":332,"content":"Manual creation of procedures There is more than one way to create procedures and insert procedure calls. We will start with the manual one by inserting an (empty) procedure node and moving the respective actions into it. Then we will create the respective procedure call. It is good to know those basic steps but there is a second more elegant way of creating procedures, which we will explain afterwards. Okay, let's do it by hand. We will start with creating a procedure node and naming it appropriately. Open the Procedures node and keep it selected. Chose »Insert«-»Procedure nodes«-»Procedure«. Name it 'reset'. The other fields can be left empty. Open the newly created 'reset' procedure node.","hash":"tut_procmanualweb","h0":"Manual creation of procedures"},"333":{"id":333,"content":"Figure 12.2: Create a procedure node The second step is to fill the procedure with the respective reusable actions. Select the three 'Mouse click' nodes in the test step. To select more than one node at once you can select the first one, then press the Shift key and, while keeping it pressed, click the last node you want to select. Move them down into the procedure e.g. by mouse (drag&drop) or cut/paste from the »Edit« or context menu.","hash":"ProcedureNodeInFirstTestcaseWeb","h4":"Figure 12.2: Create a procedure node"},"334":{"id":334,"content":"Figure 12.3: Fill in the procedure content The third step is to add a procedure call to the place of the three 'Mouse clicks' you moved. Select the test step 'Reset', which is still open. Select »Insert«-»Procedure nodes«-»Procedure call« or use the Ctrl⁠+⁠A shortcut.","hash":"ProcedureContentInFirstTestcaseWeb","h4":"Figure 12.3: Fill in the procedure content"},"335":{"id":335,"content":"Figure 12.4: Insert a procedure call Press the procedure selection button left of the label 'Procedure name'. Select 'reset' from your test suites procedures. Other fields can be left as they are. Press the OK button to finalize the creation of the procedure call.","hash":"AddProcedureCallWeb","h4":"Figure 12.4: Insert a procedure call"},"336":{"id":336,"content":"Figure 12.5: Select a procedure In order get a real benefit from the procedure, of course, we also need to replace the content of reset test step in the second test case by the 'reset' procedure call, too. You can do it the same way as before or use the following alternative steps to create a procedure call: Open the 'Reset' test step of the second test case. Remove the three 'Mouse click' action nodes therein. Select the 'reset' procedure node. Move it via drag&drop into the 'Reset' test step (copy/paste action can be used alternatively). This does not actually move it but create a respective procedure call. The test suite should look like this:","hash":"SelectProcedureWeb","h4":"Figure 12.5: Select a procedure"},"337":{"id":337,"content":"Figure 12.6: Test-suite with procedure When now executing the test cases the reset in meant to still work like before. Hence, in the run log you will see the same executed node as before, only preceded by the procedure call.","hash":"fig_testsuite_with_procedure_web","h4":"Figure 12.6: Test-suite with procedure"},"338":{"id":338,"content":"Pro Tutorial","hash":"","h0":"Transforming nodes into procedures | QF‑Test Tutorial"},"339":{"id":339,"content":"Pro Tutorial","hash":"home-link","h0":"Transforming nodes into procedures | QF‑Test Tutorial"},"340":{"id":340,"content":"Transforming nodes into procedures As already mentioned at the beginning of the last section, QF‑Test offers an alternative, much faster way to create a procedure: Select the test step or sequence node that contains the reusable steps to be transformed into a procedure. Select menu item »Operations«-»Transform node into«-»Procedure« or use the Ctrl⁠+⁠Shift⁠+⁠P shortcut. You will find that the test step, respectively sequence node disappeared and there is a procedure call in its place. Moreover, a procedure was created in the Procedures section containing the child nodes of the former test step / sequence node and named the same. It is good practice with QF‑Test to record a sequence, give it a name and immediately turn it into a procedure via Ctrl⁠+⁠Shift⁠+⁠P if you suspect it to be of use somewhere else, too.","hash":"tut_proctransformweb","h0":"Transforming nodes into procedures"},"341":{"id":341,"content":"Pro Tutorial","hash":"","h0":"Components (Web) | QF‑Test Tutorial"},"342":{"id":342,"content":"Pro Tutorial","hash":"home-link","h0":"Components (Web) | QF‑Test Tutorial"},"343":{"id":343,"content":"Components (Web) Let us have a look at the last main section in the test suite window, the Windows and components node. When talking about components we also want to show you how to address subitems of components like tables, trees and lists. This chapter is also available as a video tutorial at \"Components\".","hash":"sec_ComplexComponentsWeb","h1":"Components (Web)"},"344":{"id":344,"content":"Pro Tutorial","hash":"","h0":"Addressing subitems of tables, lists and trees | QF‑Test Tutorial"},"345":{"id":345,"content":"Pro Tutorial","hash":"home-link","h0":"Addressing subitems of tables, lists and trees | QF‑Test Tutorial"},"346":{"id":346,"content":"Addressing subitems of tables, lists and trees Subcomponents of tables, lists and trees can be addressed by indices. There are two main types: textual and numeric indices. Let's record a mouse click to a table cell and analyze the recorded QF‑Test component ID. Start the CarConfig application, in case it has not been started already, by executing the Setup node of the test suite. Activate the recording mode by pressing the toolbar button . Click a table cell, e.g. the first model. Stop the recording by pressing . You will see the recorded mouse click in the Extras section.","hash":"sec_addressing_complex_components_web","h0":"Addressing subitems of tables, lists and trees"},"347":{"id":347,"content":"Figure 13.1: Addressing a table cell The QF‑Test component ID recorded is VehicleTable@Model&0. The single parts are: VehicleTable is the QF‑Test component ID of the table component itself. @ and & separate the single parts from each other and at the same time indicate the type of index that follows: @ for a textual index and & for a numeric index. Model is the textual index for the table column with the title 'Model'. 0 is the numeric index for the first table row. Numeric indices always start at 0. You can use any index type for column or row. It is just important that the separator and the index type match. Change the QF‑Test component ID so that the third price value in the table will be clicked, using numeric indices only. The solution is to type VehicleTable&1&2 in the QF‑Test component ID attribute of the Mouse event node. In order to address the model 'I5' using textual indices only, you would have to enter VehicleTable@Model@I5. Using numeric indices you would write VehicleTable&0&4 and for mixed indices VehicleTable&0@I5 or VehicleTable@Model&4. The third type of index QF‑Test supports is a textual index containing a regular expression. Regular expressions can be used to replace a string by an expression that can match for more than only one string. For a detailed explanation of regular expressions please refer to the manual. So you could also address the cell for the model 'I5' using VehicleTable@Model%I.*. Lists are addressed the same way as tables are, just with one index only. A tree has only one index. This is the path down the tree to the node to be specified. The path consists of the respective nodes of the tree, separated by slashes ('/'). Let's record a mouse click to a tree: Start the CarConfig application, in case it has not been started already, by executing the Setup node of the test suite. Navigate to the tree: In the CarConfig application select the menu item »Options«-»Specials...«, select a model and press 'Details' Activate recording mode by pressing the toolbar button . Click a tree node, e.g. 'Description'. Stop the recording by pressing . For the tree node 'Description' the recorded QF‑Test component ID would be DetailsTree@/Information/Description. The single parts are: DetailsTree is the QF‑Test component ID of the tree component itself. @ separates the QF‑Test component ID of the tree from the index and at the same time indicates the type of index that follows: @ for a textual index. /Information/Description is the textual index for the tree path to 'Description'. If you wanted to address the node using a numeric index you would have to use DetailsTree&/0/1.","hash":"fig_components_tableindex_web","h4":"Figure 13.1: Addressing a table cell"},"348":{"id":348,"content":"Pro Tutorial","hash":"","h0":"Web Component Recognition | QF‑Test Tutorial"},"349":{"id":349,"content":"Pro Tutorial","hash":"home-link","h0":"Web Component Recognition | QF‑Test Tutorial"},"350":{"id":350,"content":"Web Component Recognition Addressing subitems of complex components like lists, tables or trees via index, as described in the previous section, is only possible because of a suitable component mapping in the Setup. That way, QF‑Test knows in what way certain functionalities like text fields, buttons, checkboxes, data tables, trees etc. have been implemented in the HTML code of the application. Knowing the functionality of a component at recording time has the following advantages: Subitems will be addressed via index, as you already know. They will not be recorded as a separate component. With mouse clicks, the position where to replay the click to later on, will be optimized: the best position for a click to a button is its center, whereas with text fields it is important to click at the same position as during recording, since maybe you want to insert text at exactly that place. For check recording QF‑Test provides a context sensitive popup menu offering various checks, depending on the functionality of the component: for data tables you will be offered checks for the whole row or column, for example. For text fields, on the other hand, you will find a check whether it is editable. QF‑Test will save additional criteria for component recognition when it knows the funcionality of the component: with a button, for example, its text would be a relevant information for recognition. With text fields, however, the text contained would be quite useless in that respect. So QF‑Test will look for a suitable label component and save that text. Last but not least, the additional information QF‑Test is able to gather, knowing the functionality of the component, will contribute towards the stability of the tests. Configuration of the component recognition is required because Web applications have a limited set of basic components, which can be combined in flexible ways in order to implement complex components and designs. HTML tables, for example, are used, both, for just controlling the page layout and for displaying logical tables, like the VehicleTable. Without additional information, QF‑Test cannot know where exactly the layout table ends and the logical table starts. This is why, without mapping, QF‑Test would record something like VehicleTable.td for a table cell. The \"td\" coming from the HTML table data element \"TD\" and indicating a table cell, but nothing more. QF‑Test would not able to assign a logical table row or column. In the Setup of the demo suite FirstWebTests.qft of the first chapter or the one created via the quickstart wizard in the second chapter the component mapping is done right after the start of the browser. The following figure shows the resolver registration node in the FirstWebTests.qft.","hash":"tut_custemwebresolver","h0":"Web Component Recognition"},"351":{"id":351,"content":"Figure 13.2: Web resolvers as installed in the FirstWebTests.qft The node inform QF‑Test which HTML element contains the data table und which HTML elements would be the data row and the data cell, among other mappings. The configuration was done specifically for the \"CarConfigurator Web\". At this stage it is just important for you to know about the option to improve component recognition by the use of resolvers. QF‑Test automatically analyses the structure of web applications, detects the most common web UI toolkits (like Angular Material, ExtJS, GWT, SmartGWT, Vaadin,...) and installs the respective predefined resolvers. Obviously, not all web applications have been developed using a toolkit, some use extended toolkits and not all existent toolkits have predefined resolvers with QF‑Test. Hence you may come across custom component implementations. So when you start testing your own web application and encounter issues with components not being accessed as reliably as expected, there might be the time to at least think about a resolver to improve the recognition behavior. You may also get in touch with our support team for assistance. There is also a chapter in the technical reference part of the manual with more in-depth information about CustomWebResolvers and how to start an implementation on your own if you wish to do so.","hash":"figure_13.2","h4":"Figure 13.2: Web resolvers as installed in the FirstWebTests.qft"},"352":{"id":352,"content":"Pro Tutorial","hash":"","h0":"Windows and components Section | QF‑Test Tutorial"},"353":{"id":353,"content":"Pro Tutorial","hash":"home-link","h0":"Windows and components Section | QF‑Test Tutorial"},"354":{"id":354,"content":"Windows and components Section The topic 'components' is covered by several videos: The video 'Component recognition' first explains the criteria for component recognition, then (starting at min 13:07) the use of generic components using regular expressions, followed by generic components using variables in component recognition attributes. There are two videos available explaining in detail how to deal with a ComponentNotFoundException: The video 'ComponentNotFoundException - simple case' shows a simple case. A more complex case is discussed in the video 'ComponentNotFoundException - complex case'. The video 'Dealing with the explosion of complexity in web test automation' gives you a good idea of how QF‑Test handles a deeply nested DOM structure. Live recording of the special webinar 'Component recognition'. QF‑Test stores the information about how to find a component in the UI of the SUT in the Windows and components section. It analyzes the component information during the recording of actions to the SUT and saves the information for the components the user interacted with in the details of the Component nodes. This section is meant to give you an idea about which kind of information is stored in the Component nodes and how QF‑Test uses it to recognize a component in the UI. There are two cases where you will want to have a look at components and where it will be useful to have a basic idea of the concepts of component recognition. The first one is when the UI of your application changed significantly between when you first recorded the component to when you want to replay the test, e.g. because of a new release of the application. QF‑Test uses several algorithms to evaluate whether a certain UI element currently displayed matches the criteria of the UI element that was once recorded. However, when too many of the criteria no longer fit then you will have to have a look at the components. For a detailed instruction about what to do then, please refer to the manual chapter Troubleshooting component recognition problems. There are also links to videos showing respective samples. The second one is when you want to improve component recognition. As you already know from the chapter Web Component Recognition a certain functional component like a checkbox or table, even an input field, can be implemented in quite a number of different ways from the basic HTML components available. Even though QF‑Test provides component recognition for a number of component libraries there may always be some components that are not recognized for what they really are. For details about how to implement additional component recognition please have a look at the chapter 'CustomWebResolver' in the technical reference part of the manual. Let's have a look at a 'TextField' component node and see which criteria were recorded and saved in the details of the Component node. Start the CarConfig application, in case it has not been started already, by executing the Setup node of the test suite. Open the procedure 'Check final price'. Navigate to the text field Component node by right-clicking the text check node and selecting »Locate component« or using the Ctrl⁠+⁠W shortcut.","hash":"sec_componentsteps_web","h0":"Windows and components Section"},"355":{"id":355,"content":"Figure 13.3: Locating a component This is going to take you directly to the 'TextField CalculatedPrice' node in the Windows and components section.","hash":"fig_components_locate_web","h4":"Figure 13.3: Locating a component"},"356":{"id":356,"content":"Figure 13.4: Component tree Above component tree has only a few levels. This is because of the custom web resolver registered after the start of the application as explained in Web Component Recognition. When you have a look at the component tree recorded for the test suite you set up in \"Creating your own test suite (Web)\" you will notice that there are a lot more DIV levels. These have been defined on the HTML page. They are not relevant for component recognition and make the tree rather big and confusing. Therefore, in the demo test suite, we suppress their recording with the CustomWebResolver. Let's have a look at the properties of this component node used to identify the UI element.","hash":"fig_components_tree_web","h4":"Figure 13.4: Component tree"},"357":{"id":357,"content":"Figure 13.5: Details of the Component node The topmost attribute is QF‑Test ID, which provides the 'handle' to the component to be used in the test cases and procedures. All other attributes refer to the component in the UI. The next attribute is Class name. In our case it is 'TextField'. For component recognition it is essential to know the class of a component. In fact this class is a generalized value of the class used by the developer. This is helpful to achieve component recognition independent of the specific implementation and allows easy porting of tests. However, QF‑Test saves the specific values in the Extra features table. By default, they are not used for component recognition. Other examples for generic classes would be 'Panel', 'Dialog' or 'Button'. The Name attribute is the name or id given to the UI component by the programmer. If there is a Name then this, together with the class, is all QF‑Test needs to identify a component in the UI. If the programmer did not set a name or id for the UI component and the Name attribute therefore remained empty QF‑Test needs other criteria like a certain text associated with the component, index information and geometry. A feature associated with a button for example would be the text shown on the button. QF‑Test saves a text directly belonging to the UI component in the Feature attribute. If the web UI element has not text but an id QF‑Test saves the id in the Feature attribute. If none of the two exists and there is a text in the vicinity of the component that could be the label then this will be saved in the Feature. In any case the label will be saved in the Extra features table with the Extra features Name qfs:label. The Structure information refers to all UI components of the respective class. The total number of UI components of that class is saved in the Class count attribute, the index of the component itself in the Class index attribute. Last there is the Geometry information. It is the one having the lowest weight within the recognition algorithm. It can be of value if no other helpful information is available for a component. In case you are interested in further details of the component recognition you will find such in the Component recognition chapter of the technical reference of the manual. If you want to get a feeling for the component recognition you could play around with the attribute values and see what you need to change to make QF‑Test not recognize it anymore or even recognize a wrong component in the UI. You will find that you need to change quite a few attributes before QF‑Test recognizes a different component. This means that component recognition with QF‑Test is very robust. With regression tests a significant part of the UI component criteria need to change before QF‑Test will not recognize the component anymore even if the component has no name or id. When you click the Component node QF‑Test will highlight the recognized component in the UI by outlining it with a dark blue border. Delete the CalculatedPrice from the Name attribute. Because as long as there is an entry in the Name attribute QF‑Test will not consider the attributes below. In the Extra features table, set the state of the extra feature with the name id from Should match to Ignore . Change the Feature attribute from CalculatedPrice to xxx. Click the TextField node and check QF‑Test still highlights the Final Price field in the UI. Change the Feature attribute back to CalculatedPrice, either via the respective toolbar button or by typing Ctrl⁠+⁠Z. Change the qfs:label value in the Extra features table from Final Price to Accessories Price. Click the 'TextField' node and check QF‑Test still highlights the Final Price field in the UI. Change the qfs:label value in the Extra features table back to Final price. Change all Structure and Geometry attributes to a different value and check that QF‑Test still highlights the Final Price field in the UI. Delete the Feature attribute and change the qfs:label value in the Extra features table from Final Price to Accessories Price. Check that now QF‑Test highlights the Accessories Price field. This is just to give you a bit of a feeling for component recognition. In the above mentioned chapters (and some more) of the manual you will find detailed information about what to do when you have trouble with component recognition.","hash":"fig_components_details_web","h4":"Figure 13.5: Details of the Component node"},"358":{"id":358,"content":"Pro Tutorial","hash":"","h0":"SmartIDs - Addressing components directly | QF‑Test Tutorial"},"359":{"id":359,"content":"Pro Tutorial","hash":"home-link","h0":"SmartIDs - Addressing components directly | QF‑Test Tutorial"},"360":{"id":360,"content":"SmartIDs - Addressing components directly Since version 7.0 QF‑Test officially supports SmartIDs allowing you to reference a component without having to record a Component node. For some applications SmartIDs may reduce the time required for management and maintenance of the component information considerably. SmartIDs may also have a positive effect on readablity and maintainability of the tests themselves. It also allows you to write tests without use of the recording functionality, for example when a component or even the whole application does not yet exist, and you want to go ahead with tests (\"test first\" approach). SmartIDs then allow you to specify the future recognition critiera directly. The recognition criteria available are the component class, the name or a label and the index. The values are the same as in the recorded Component node. Nested SmartIDs even reflect the component hierarchy. The SmartID is used in place of the QF‑Test ID of the component. SmartIDs start with the hash symbol # as the first character, in the simplest form followed by the name or the label of the component, for example: #btnOK, \"btnOK\" being the name of the component or #First name, \"First name\" being the label of the component. The disadvantage of this simple form of the SmartID is performance at replay, as QF‑Test has to search all components for the given criteria. For this reason it is better to specify the class of the component, too. Above SmartIDs would then be: #Button:btnOK #TextField:First name Currently, the recording of SmartIDs is not activated by default. You can activate it directly via the menu. Now, please record some SmartIDs by opening the menu Record and selecting Record SmartID. Activate recording mode via the button \"Start recording\" . Click to a text field, for example the one for the discount percentage, then click to a table cell, for example the first model. Stop the recording via \"Stop recording\" . You will find the recorded mouse clicks in the Extras section. The SmartID for the input field is #TextField:name=DiscountValue, because QF‑Test preferably uses the name for the SmartID value when there are a name and a label for the component. The second mouse click shows the SmartID for the table component, followed by @ and the text index of the column and & with the numeric index of the row, just like you saw it in the one but last section: #Table:name=VehicleTable@Modell&0. When you do not want to record SmartIDs any more you can deactivate it via the \"Record\" menu. Of course, you can continue working with SmartIDs. When recording more SmartIDs you will come across more expressions used in SmartIDs. We now want to show you some of them and give you an explanation why they are used. For labels ending with a colon you will find a back slash in front of the colon: #TextField:First name\\: The explanation is the colon defines the end of the name of the class. Therefore, colons in the component name or the label have to be escaped by a back slash. Other characters like @, & and % have to be escaped as well because they are used as separators before indices. Labels will be prefixed by a qualifier, here left=: #TextField:left=First name Explanation: a SmartID consisting of class and name of the component reaches the same performance at replay as does component recognition via a recorded Component node. Labels, however, are a different case. There are various options for what might be the best label for a component. QF‑Test searches all the available labels of a component for the best one. For performance it is good when you specify the type of label expected. left= indicates the label to the left of the component. Other SmartID qualifiers indicating the position of the label are right=, top=, topleft= or bottom=. When the text of the component serves as label the qualifier is text=, for the tooltip tooltip=. When you get several components with the same name or label on a display you might see a compound SmartID consisting of to single SmartIDs concatinated by @: #TitledPanel:Customer address@#TextField:left=First name #TitledPanel:title=Invoice address@#TextField:left=First name The example shows the SmartIDs for the label \"First name\", both on the panel \"Customer address\" and on the panel \"Invoice address\". The second sample is a bit more performant than the first one because of the qualifier title= in the SmartID for the panel. With the first one readablity is a bit better. It depends on the application whether you have to pay attention to performance. With web applications with many UI elements it is usually an issue. However, with Java applications you can opt for readablity in most cases. Long labels can be shortened by the use of regular expressions: #%Dialog:Information.*@#Button:OK The percent sign directly after the hash sympol indicates the name or the label to be a regular expression. In above sample the regular expression shortens the title. It may also be used to identify an \"OK\" button in any dialog with the title starting by \"Information\". For more details about regular expressions please see the manual - regular expressions. You will find more information about components and SmartIDs in manual - components.","hash":"sec_components_smartid_web","h0":"SmartIDs - Addressing components directly"},"361":{"id":361,"content":"Pro Tutorial","hash":"","h0":"Using the Debugger (Web) | QF‑Test Tutorial"},"362":{"id":362,"content":"Pro Tutorial","hash":"home-link","h0":"Using the Debugger (Web) | QF‑Test Tutorial"},"363":{"id":363,"content":"Using the Debugger (Web) In this chapter we will learn how to run a test suite with QF‑Test's built-in and intuitive debugger. If you are familiar with debugging from other IDEs like Eclipse, you will find this debugger similar in function and usefulness. This chapter is also available as a video tutorial at \"Using the Debugger\". By the end of this chapter you will be familiar with the following debugger functionality: Setting a Breakpoint e.g. via Ctrl⁠+⁠F8. Pausing a test run at any time and resuming operation using the debugger button or the \"Don't Panic\" key Alt⁠+⁠F12. Stepping Through a Test or Sequence using the debugger buttons 'Single step' , 'Step over' and 'Step out' . Skipping Execution of Nodes using the debugger buttons 'Skip over' and 'Skip out' . Error or Exception triggering Debugging Mode. Resolving Errors directly from the Run log. Jump directly to the current error in the run log via Ctrl⁠+⁠J. (Jump to run log in chapter \"Resolving Errors directly from the Run log\"). Instead of the debugger buttons you can also enter the commands via the QF‑Test menu and most by keyboard shortcuts as well. You'll find the the shortcut listed beside the menu option, if available. For a complete list, refer to the Keyboard shortcuts section of the user manual. You can also find a little helper there for attaching to your keyboard which shows the function key assignment of QF‑Test. There are some more functions related to the debugger that we will come to in later chapters: Locating the current node using the debugger button (Locate the current node in chapter \"Advanced debugging of variable bindings\"). \"Continue execution from here\" via the popup menu of the respective node (\"Continue Execution from here\"). Rethrowing exceptions using the toolbar button . The variable bindings table (\"Advanced debugging of variable bindings\").","hash":"sec_DebuggerWeb","h1":"Using the Debugger (Web)"},"364":{"id":364,"content":"Pro Tutorial","hash":"","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"365":{"id":365,"content":"Pro Tutorial","hash":"home-link","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"366":{"id":366,"content":"Setting a Breakpoint First of all we need to activate debugging mode. There are several ways to do so. One of them is to set a breakpoint at the node where we want to have a closer look. When the test is being executed and QF‑Test comes to the break point it will then pause and switch into debugging mode. The pause button will then be activated. Select a node and press Ctrl⁠+⁠F8. The breakpoint is indicated by a .","hash":"tut_breakpointsweb","h0":"Setting a Breakpoint"},"367":{"id":367,"content":"Figure 14.1: Set break point Select the Test suite node and press Enter to start the test run.","hash":"fig_DebugSetBreakpointWeb","h4":"Figure 14.1: Set break point"},"368":{"id":368,"content":"Figure 14.2: Start test run Remove the breakpoint by pressing Ctrl⁠+⁠F8 again.","hash":"fig_DebugStartTestRunWeb","h4":"Figure 14.2: Start test run"},"369":{"id":369,"content":"Figure 14.3: Remove break point Instead of using the keyboard shortcut Ctrl⁠+⁠F8 you may also set or unset a breakpoint by clicking the node and selecting the »Debugger«-»Breakpoint on/off« menu item, or alternatively right-clicking the node and selecting the »Breakpoint on/off« context menu item. Again, you can see the little arrow, which now marks the next node to be executed, called the current node. When entering debugging mode QF‑Test also navigates to the current node, in case it had not been visible, and selects it, highlighting it blue. The menu option »Debugger«-»Clear all breakpoints« is useful to remove all breakpoints set in your test suite. There is no limit to the number of breakpoints you can set in your test suite, but note that breakpoints are not saved with the test suite.","hash":"fig_DebugRemoveBreakpointWeb","h4":"Figure 14.3: Remove break point"},"370":{"id":370,"content":"Pro Tutorial","hash":"","h0":"Stepping Through a Test or Sequence | QF‑Test Tutorial"},"371":{"id":371,"content":"Pro Tutorial","hash":"home-link","h0":"Stepping Through a Test or Sequence | QF‑Test Tutorial"},"372":{"id":372,"content":"Stepping Through a Test or Sequence Now let's step through the test case we set up in the previous section. Please try out the debugger buttons Single step , Step over and Step out . You will find that Single step opens a node containing child nodes and makes the first child node the active node. Continuing from where we left the test suite at the end of the last section, i.e. in debugging mode, with 'Test case: First' being the current node, the test suite would now look like this:","hash":"tut_debug_steps_web","h0":"Stepping Through a Test or Sequence"},"373":{"id":373,"content":"Figure 14.4: Stepping into a node In the case of leaf nodes (nodes without child nodes), the effect of is the same as the following button's. Step over runs the current node including all children. Execution pauses at the next node of the same level to be executed, which then becomes the active one.","hash":"fig_StepInExampleWeb","h4":"Figure 14.4: Stepping into a node"},"374":{"id":374,"content":"Figure 14.5: Stepping over a node Step out runs the remaining nodes at the same level including their child nodes. Execution pauses when a node that is higher in the hierarchical structure is found, which then becomes the active one.","hash":"fig_StepOverExampleWeb","h4":"Figure 14.5: Stepping over a node"},"375":{"id":375,"content":"Figure 14.6: Stepping out of a node In the given example the node higher in the hierarchical structure where execution stops is the Cleanup node. As explained in the chapter A full Test Run this shows the special behavior of Setup / Cleanup nodes in a test set: They are executed before and after each test case to help achieving a proper starting state for each test case. You will only find this behavior when you started the whole test suite or test set and are in debugging mode. If you just selected the test case and did a step-over action then QF‑Test will execute the test case and then select the next test case node. Run the Cleanup and Setup nodes by stepping over them, using the debugger button Step over and then Step in the second test case via to get ready for the next section where you will learn about the skip functionality. Please be aware that menus or comboboxes tend to close when the application looses the focus, as will happen when activating the debugging mode. In such a case you should not stop test execution between the node opening the menu or combobox and the node performing the selection. One way to do achieve this is to set a break point after the node performing the selection and to activate normal test execution by releasing the pause button when you reach the node opening the menu or combobox.","hash":"fig_StepOutExampleWeb","h4":"Figure 14.6: Stepping out of a node"},"376":{"id":376,"content":"Pro Tutorial","hash":"","h0":"Skipping Execution of Nodes | QF‑Test Tutorial"},"377":{"id":377,"content":"Pro Tutorial","hash":"home-link","h0":"Skipping Execution of Nodes | QF‑Test Tutorial"},"378":{"id":378,"content":"Skipping Execution of Nodes The \"skip\" functions expand the QF‑Test debugger's capabilities in a powerful way which is not typically possible for a debugger in a standard programming environment. In short, they allow you to jump over one or more nodes without having to execute them. This may be helpful for various reasons, e.g. to quickly navigate to a certain position in your test run or to skip a node which currently leads to an error. With the end of the last section, the test suite should have reached the following state:","hash":"tut_skip_steps_web","h0":"Skipping Execution of Nodes"},"379":{"id":379,"content":"Figure 14.7: Pause execution at first node of the second test case Now press the Skip over button. QF‑Test simply jumps over the active node without executing any child nodes. The active node now is the next node to be executed on the same level.","hash":"fig_DebugSkipOverInitialStateWeb","h4":"Figure 14.7: Pause execution at first node of the second test case"},"380":{"id":380,"content":"Figure 14.8: Skip over a node At last, press the Skip out button. You see that QF‑Test skips all nodes on the same (or lower) level and directly jumps to the next node one level up in hierarchy.","hash":"fig_DebugSkipOverWeb","h4":"Figure 14.8: Skip over a node"},"381":{"id":381,"content":"Figure 14.9: Skip out of a node Use \"Skip over\" and \"Skip out\" cautiously as skipping out of a sequence before it is completed can leave the SUT in an unknown state that other sequences or tests in your test suite cannot react to.","hash":"fig_DebugSkipOutWeb","h4":"Figure 14.9: Skip out of a node"},"382":{"id":382,"content":"Pro Tutorial","hash":"","h0":"Error or Exception triggering Debugging Mode | QF‑Test Tutorial"},"383":{"id":383,"content":"Pro Tutorial","hash":"home-link","h0":"Error or Exception triggering Debugging Mode | QF‑Test Tutorial"},"384":{"id":384,"content":"Error or Exception triggering Debugging Mode When debugging a test you may want run it until it encounters an error, an exception or sometimes even a warning and then have it pause in debugging mode. In this section you will see how this can be done while debugging the second test case. Please open the debugger menu and change the default options as follows: Activate the »Debugger«-»Enable debugger« menu item. Also activate the »Debugger«-»Options«-»Break on error« menu item. Afterwards, when you open the debugger menu and options submenu it should look like this:","hash":"tut_debug_start_web","h0":"Error or Exception triggering Debugging Mode"},"385":{"id":385,"content":"Figure 14.10: Set debugger options to pause on error We changed the debugger options because with default settings QF‑Test will not pause on exceptions or errors, as you saw earlier on. Select the \"Test-suite\" node and start test execution via \"Start test run\" . QF‑Test will pause at the faulty node and enter debugging mode:","hash":"fig_debugger_stops_at_error_web","h4":"Figure 14.10: Set debugger options to pause on error"},"386":{"id":386,"content":"Figure 14.11: Test run stopped by error The node which halted test execution will be indicated by an arrow and its symbol will be surrounded by a red square. Also, an error dialog will inform you about the failed check. As always the run log is the key to resolving errors, so let's open it and find out how to resolve the error in the next section.","hash":"fig_debugger_stopped_by_error_web","h4":"Figure 14.11: Test run stopped by error"},"387":{"id":387,"content":"Figure 14.12: Error Dialog Click the Jump to run log button in the error dialog.","hash":"fig_debug_error_dialog_web","h4":"Figure 14.12: Error Dialog"},"388":{"id":388,"content":"Pro Tutorial","hash":"","h0":"Resolving Errors directly from the Run log | QF‑Test Tutorial"},"389":{"id":389,"content":"Pro Tutorial","hash":"home-link","h0":"Resolving Errors directly from the Run log | QF‑Test Tutorial"},"390":{"id":390,"content":"Resolving Errors directly from the Run log The Jump to run log button from the dialog in \"Error Dialog\" will not only open the run log but takes us directly to the node that holds the error details. Apart from the actual error message you will find screenshots and a copy of the variable bindings table (stack trace), which we will introduce later on (The Variable Bindings table). The error details tell you that the expected value does not match with the one shown in the application. As the one in the application is correct we want to update the expected value with the one from the application. This can easily be achieved as follows: Right-click the red-bordered node \"Failed: Check text: default ...\" indicating the actual error Select »Update check node with current data« from the context menu.","hash":"tut_ResolveRunTimeErrorWeb","h0":"Resolving Errors directly from the Run log"},"391":{"id":391,"content":"Figure 14.13: Update check node with current data This locates the corresponding Check text node in the test suite and updates the expected value of the Text attribute with the value got as indicated by the run log.","hash":"fig_DebugUpdateCheckNodeWeb","h4":"Figure 14.13: Update check node with current data"},"392":{"id":392,"content":"Figure 14.14: Corrected check node The previously faulty node still is highlighted with a red border since we have not run it again. Now continue execution by releasing the pause button . QF‑Test runs the rest of the test suite, i.e. the Check text and Cleanup nodes, and informs you at the end of the run that there was one error, which you have already fixed. Since the error has been fixed and we will continue using the test cases as examples you could rename the second test case and delete '(with error)' in its name as well as '(causing Error)' in the name of the test step.","hash":"fig_DebugCorrectedCheckNodeWeb","h4":"Figure 14.14: Corrected check node"},"393":{"id":393,"content":"Jump into run log: You do not have to wait for an error dialog to open the run log at the current point of execution (or close by). Whenever you are in debugging mode, select the »Debugger«-»Jump to Run log« menu option, or use the Ctrl⁠+⁠J shortcut. If you just want to open the run log without jumping to the current point of execution you can use Ctrl⁠+⁠L. This will work after the test run finished, too.","hash":"tut_JumpToRunLogWeb tut_JumpToRunLogWeb","h4":"Figure 14.14: Corrected check node"},"394":{"id":394,"content":"Pro Tutorial","hash":"","h0":"Pause Execution | QF‑Test Tutorial"},"395":{"id":395,"content":"Pro Tutorial","hash":"home-link","h0":"Pause Execution | QF‑Test Tutorial"},"396":{"id":396,"content":"Pause Execution When a test is being executed and you want to enter debugging mode you can quickly set a breakpoint at some node not yet executed. Or you can just hit the toolbar button \"Pause\" and QF‑Test will directly enter debugging mode. In order to resume execution just release the pause button . This is completely independent of the way you entered debugging mode. Depending on how focus demanding the SUT is, it may be difficult to focus QF‑Test long enough to hit the pause button. But you can still rely on the \"Don't Panic\" shortcut Alt⁠+⁠F12. It will pause all running tests immediately. To continue, press the same combination again.","hash":"tut_pause_execution_web","h0":"Pause Execution"},"397":{"id":397,"content":"Pro Tutorial","hash":"","h0":"Variables and Procedure Parameters (Web) | QF‑Test Tutorial"},"398":{"id":398,"content":"Pro Tutorial","hash":"home-link","h0":"Variables and Procedure Parameters (Web) | QF‑Test Tutorial"},"399":{"id":399,"content":"Variables and Procedure Parameters (Web) In this chapter you are going to learn how to use a procedure to perform the same action on various input data. You will also learn about variables - how to use and how to debug them. This chapter is also available as a video tutorial at \"Variables and Procedure Parameters\". The video uses a Java application for demonstration. Variables are used in the same way with web applications.","hash":"sec_variablestackweb","h1":"Variables and Procedure Parameters (Web)"},"400":{"id":400,"content":"Pro Tutorial","hash":"","h0":"Procedure using a variable | QF‑Test Tutorial"},"401":{"id":401,"content":"Pro Tutorial","hash":"home-link","h0":"Procedure using a variable | QF‑Test Tutorial"},"402":{"id":402,"content":"Procedure using a variable Have a look at the last test step 'Check final price' of our two test cases.","hash":"sec_ProcedureWithVariableWeb","h0":"Procedure using a variable"},"403":{"id":403,"content":"Figure 15.1: Two almost identical test steps They perform the same action, however, with different data. Even though it is only one node, it makes sense to pack it into a procedure. We may want to adapt the hard coded values 30,049.00 € and 26,100.00 € to a different format so that the check will also work when the format of the price field changes to a different currency. And we do not want to implement the same algorithm twice. Select the 'Check text' node in the first test case. Use »Operations«-»Pack nodes«-»Sequence« or use the Ctrl⁠+⁠Shift⁠+⁠S shortcut to pack it into a sequence. Name the sequence checkFinalPrice. The procedure name follows the Java convention to run the words together and start the single words with capital letters. On the other hand QF‑Test allows the use of spaces in procedure names, so you are free to name it as you like. Press Ctrl⁠+⁠Shift⁠+⁠P for the quickest way to transform the 'Sequence' node into a procedure, as you learned at the end of the last chapter. You see the sequence is replaced by a call to the 'checkFinalPrice' procedure. Double click the procedure call node to jump to the procedure definition. Open the procedure node to see its content.","hash":"fig_params1Web","h4":"Figure 15.1: Two almost identical test steps"},"404":{"id":404,"content":"Figure 15.2: Procedure with hard coded value As expected, the check is now located in this procedure. However, it is valid for one price only, i.e. 30,049.00 €. Since we want to use the same procedure for the second test case as well we need to make the price a variable and pass its value as a parameter from the test case to the procedure. In the next example we will start by defining a parameter for the procedure. Additionally, we will set a default value for the parameter. Default values are most useful when the parameter usually has that value and you do not want to specify it every time you call the procedure. Even though this does not hold true for the price it is a good example to demonstrate to you how a default parameter works and how to overwrite it with another value. Let's define the parameter and add a default value: Select the procedure 'checkFinalPrice' Press the \"Add new row\" button belonging to the table 'Parameter default values'. Enter price as name for the parameter. Enter 30,049.00 € in the value field.","hash":"fig_procedure_hardcoded_web","h4":"Figure 15.2: Procedure with hard coded value"},"405":{"id":405,"content":"Figure 15.3: The Details of the 'Procedure' node The next step is to replace the value of the Text attribute of the Check text node by a reference to the variable.","hash":"fig_parameter_default_values_table_web","h4":"Figure 15.3: The Details of the 'Procedure' node"},"406":{"id":406,"content":"Variable syntax: When working with variables you need to bear in mind that in some places you need to tell QF‑Test the name of the variable and in others you want to refer to the value of the variable. In the Name column of the Parameter default values table of the Procedure node QF‑Test expects the name of a variable. It is price, which is why you typed the word price. In the Text attribute of the Check text node details QF‑Test expects a character string for comparison with the text of the UI element. As we want to use a value stored in a variable, we have to tell QF‑Test not to use the entered string as plain text, but to interpret it as a reference to the value stored in a variable. In QF‑Test this is done by enclosing the variable name in $(). In our case the variable reference is $(price). If you did not put the variable name into $(), QF‑Test would compare the price (a number) shown in the UI element to the string price, which is obviously nonsense. Select the Check text node in the procedure 'checkFinalPrice'. Type $(price) in the Text attribute of the Check text node details.","hash":"tut_VariableSyntaxWeb","h4":"Figure 15.3: The Details of the 'Procedure' node"},"407":{"id":407,"content":"Figure 15.4: 'Check text' node Run the first test case. It should execute without an error.","hash":"fig_ProcedureAddVariableWeb","h4":"Figure 15.4: 'Check text' node"},"408":{"id":408,"content":"Pro Tutorial","hash":"","h0":"The Variable Bindings table | QF‑Test Tutorial"},"409":{"id":409,"content":"Pro Tutorial","hash":"home-link","h0":"The Variable Bindings table | QF‑Test Tutorial"},"410":{"id":410,"content":"The Variable Bindings table The next step is to make use of the procedure call in the second test case as well. Replace the Check text node of the second test case by a procedure call to checkFinalPrice. You can simply copy the respective node from the first test case or add the procedure call as learned in the previous chapter.","hash":"tut_variable_stack_web","h0":"The Variable Bindings table"},"411":{"id":411,"content":"Figure 15.5: Second procedure calls 'checkFinalPrice' If you added the procedure call by a copy or drag and drop operation from the procedure itself you will find the price in the Variable definitions table of the procedure call. This is what we are eventually aiming at. However, at this stage we want to explain the default value. So, if you want to follow the tutorial exactly, please delete the default value by pressing the red X above the table. Verify QF‑Test is configured to pause at errors as shown in Set debugger options to pause on error. Select the 'Test case: Second' node. Execute it by pressing or Enter. An error message shows up indicating different values for the price expected and the price got. What went wrong? Let's go hunting. Typically we use the run log for this but there is another view worth to know of. So click OK to close the error message. In debugging mode you will find an additional bottom right section of the QF‑Test window showing a list of nodes with variables bound to those nodes. You might want to resize the variable bindings table in case it is too small to see all its content.","hash":"fig_AddProcedureCallToSecondTestcaseWeb","h4":"Figure 15.5: Second procedure calls 'checkFinalPrice'"},"412":{"id":412,"content":"Figure 15.6: Variable bindings The variable bindings table is very useful for debugging. It comes in quite handy, too, when working with procedures and trying to understand the way QF‑Test figures out which variable value to use. It shows the current values of the variables. QF‑Test always checks the variable bindings table from top to bottom. You can see that the first rows of the table have no bindings at all. Then there is a binding at the level 'Globals' and another one in the fallback stack for the procedure 'checkFinalPrice'. The global variable is used for the client connection, which has been set when starting the application (cf Starting the Browser). The other variable is more interesting to us - only it has the wrong value. The default value is intended to be used for the parameter if no value has been defined elsewhere. This is why we added the parameter to the 'Parameter default values' table of the procedure node. To do things correctly we need to pass the proper value when calling the procedure. Again, there are several ways to do it. One is to add a new row to the variable definitions table of the 'Call procedure' nodes similarly to the way you did at the 'Procedure' node in the last section. If the procedure is called multiple times within the test suite, there is a better way: Stop the current test execution clicking the toolbar button . Right-click the 'Procedure' node and select »Additional node operations«-»Update parameters of references« from the popup menu.","hash":"fig_VariableBindingsTable1Web","h4":"Figure 15.6: Variable bindings"},"413":{"id":413,"content":"Right-click the 'Procedure' node and select »Additional node operations«-»Update parameters of references« from the popup menu. Figure 15.7: Popup menu for 'Additional node operations' In the following dialog, please check the tick mark for »Add missing parameters to callers« is set and click OK. In the 'Call procedure' nodes QF‑Test adds a row each for every default parameter to the variable definition table of the procedure call . It also copies the default value of each default parameter. In our case it is the parameter price with the value 30,049.00 €. You might notice that the numerical value of the price variable is still wrong in the second case, regardless of whether it is defined implicitly as a default value or explicitly via a parameter. For now we want to keep that error to show you additional means of debugging. Close the 'Updated nodes' dialog QF‑Test opened to inform you about the updated nodes.","hash":"fig_CompleteParametersWeb","h4":"Figure 15.6: Variable bindings"},"414":{"id":414,"content":"Pro Tutorial","hash":"","h0":"Advanced debugging of variable bindings | QF‑Test Tutorial"},"415":{"id":415,"content":"Pro Tutorial","hash":"home-link","h0":"Advanced debugging of variable bindings | QF‑Test Tutorial"},"416":{"id":416,"content":"Advanced debugging of variable bindings Next, we want to explore the variable bindings table and see how it can be used for debugging purposes. For this reason do not correct the faulty value of the procedure call we added in the last section, but let us find out more about debugging. In the next steps we want to have QF‑Test pause the test execution at the procedure call. Then we will step into the procedure and, while doing so, have a look at the variable bindings table. Finally, we will navigate directly from the variable bindings table to the faulty procedure call and correct the parameter value. Add a breakpoint to the 'Call procedure: checkFinalPrice' node of the second test case. Run the second test case again. When QF‑Test stops at the breakpoint step into the procedure via and watch the table of the variable bindings as you do so.","hash":"tut_variable_stack_debugging_web","h0":"Advanced debugging of variable bindings"},"417":{"id":417,"content":"Figure 15.8: Variable bindings stack showing incorrect value As you step into the procedure, first the row 'Call procedure: checkFinalPrice' and with the next step the row 'Procedure: checkFinalPrice' appear at the top of the table. Now the variable price shows on two different levels of the variable bindings table: In the 'Call procedure: checkFinalPrice' row and the 'Procedure: checkFinalPrice' row on the fallback stack. Since we did not adapt the value of the parameter passed to the procedure, neither of the two values bound to the price variable is correct. QF‑Test lets you change the values of the variables interactively in the variable bindings table when you are in debugging mode. You can even add new variables or delete them. However, changes to variable values in the variable bindings table are not persistent. They only last as long as the variable is on the stack (variable bindings table). In our case, if we changed the price value, as long as the procedure is being executed. The parameter value in the procedure call will not be altered by changing the current value of the variable in the variable bindings table. To do so you have to navigate to the Procedure call node and change it there. To get there quickly, you just double-click the procedure call in the variable binding table (second row). This feature is particularly useful when debugging more complex tests where the node you want to jump to is not directly visible in the test suite window. You can invoke it via right-clicking the row and selecting »Jump to node in test suite« from the pop-up menu, too. Double-click the second row with the procedure call in the variable bindings table. Set the value of the parameter to the correct value, i.e. 26,100.00 €. When checking the variable bindings table you will notice that the current value has not changed. This is hardly surprising as we have not yet executed the procedure call again. Only, test execution is already past the procedure call. Fortunately, QF‑Test has another very useful debugging feature to set back (or forward) test execution to some node: »Continue execution from here«, which can be invoked either via the pop-up menu of the node you want to make the current node or by pressing Ctrl⁠+⁠, after selecting the node. In order to try out the newly set value: Right-click the 'Call procedure: checkFinalPrice' node of the second procedure. Select 'Continue execution from here' in the popup menu.","hash":"fig_VariableStack3Web","h4":"Figure 15.8: Variable bindings stack showing incorrect value"},"418":{"id":418,"content":"Figure 15.9: Continue Execution from here When checking the variable bindings table you will find that the top two rows have disappeared. This is because now we exited the procedure (even though 'backwards') and therefore the procedure call and all its variable bindings was taken off the call stack. Release the pause button . The test run should finish without error. As the variable bindings table is very useful when looking for incorrect variable values you will also find a copy of it in the run log whenever an error or exception is logged. It is written to the subnode 'Stack trace' of the node causing the error, showing the variable values at the time the error occurred.","hash":"fig_ProcedureContinueExecFromHereWeb","h4":"Figure 15.9: Continue Execution from here"},"419":{"id":419,"content":"Locate the current Node: Sometimes during debugging you will navigate far away from the current node where execution stopped and eventually want to get back to it again. The easiest way to do so is by pressing the \"Locate Current Node\" button or select the »Debugger«-»Locate Current Node« menu option to cause the debugger to \"select\" the current node.","hash":"locate_current_node_web","h4":"Figure 15.9: Continue Execution from here"},"420":{"id":420,"content":"Pro Tutorial","hash":"","h0":"Setting Variables | QF‑Test Tutorial"},"421":{"id":421,"content":"Pro Tutorial","hash":"home-link","h0":"Setting Variables | QF‑Test Tutorial"},"422":{"id":422,"content":"Setting Variables In addition to the methods you have already seen, variables can also be set as follows: Via the Set variable node, as the return value of a procedure, as the result value of QF‑Test nodes like the Fetch text node, the Fetch geometry node, the Fetch index node and the Check node, in the 'Variable definitions' table of the 'Test-suite' node, the 'Test case' node, the 'Test step' node, the 'Sequence' node and others like the 'If' node or 'Loop' node, via command line parameters. For information about the best place where to define a variable please refer to the next section. You can insert a Set variable node via the menu item »Insert«-»Miscellaneous«-»Set variable«. In its details you can specifiy whether the value should be bound as a local or a global variable. The following figure shows the details of a Set variable node. (You can find it as the first node of the Setup node.) It defines a variable named client. It is a global variable as the Local variable attribute has not been checked.","hash":"tut_setting_variables_web","h0":"Setting Variables"},"423":{"id":423,"content":"Figure 15.10: Details of the Set variable node When you want to set a variable as the result of a procedure call you need to specify the variable name in the 'Variable for return value' attribute of the procedure call. Within the procedure itself you have to add a Return node with the value to be returned as the last node to be executed. The next figure shows a theoretical example of a procedure which returns a value. The procedure fetches the discount value displayed in the SUT and returns it to the calling test case. There, the receiving variable is named Discount and declared as a local variable.","hash":"fig_DetailsSetVariableWeb","h4":"Figure 15.10: Details of the Set variable node"},"424":{"id":424,"content":"Figure 15.11: Procedure returning a value The Fetch text node of above example is one of the QF‑Test nodes directly setting a variable value. You need to specify the variable name in the attribute called accordingly. Again, you have the choice whether to make it local or global. Quite a number of nodes have a 'Variable definitions' table where you may define variables local to a procedure or a test case. If the respective node is part of a procedure the variable will be local to the procedure. Otherwise it will be local to the respective test case. Variables bound to the test suite node can be accessed from all nodes within the test suite. In debugging mode, all nodes you can bind a variable to will show up on the variable bindings table when entered. You can enter variables in the command line via the parameter -variable. For details please refer to the manual, chapter 'Command line arguments and exit codes'.","hash":"fig_DetailsCallProcedureWeb","h4":"Figure 15.11: Procedure returning a value"},"425":{"id":425,"content":"Pro Tutorial","hash":"","h0":"Variable binding levels | QF‑Test Tutorial"},"426":{"id":426,"content":"Pro Tutorial","hash":"home-link","h0":"Variable binding levels | QF‑Test Tutorial"},"427":{"id":427,"content":"Variable binding levels This section may be difficult to understand when you are a programming beginner. Then it may be better to come back to it when you started writing procedures for your own tests. In QF‑Test there are many places where you can set a variable: The test suite node, in test cases and procedures as default or local variables, as a parameter in a procedure call, as a global variable and as a command line parameter. Now the question is: Which is the correct place for defining a variable? And the answer is: It depends on the use case. Each level of the variable bindings has its own use case: Procedure parameters When you call the same procedure several times in a test case and with different values each time you should set the values via a parameter at a procedure call. This is done by adding a row to the variable definitions table of a Procedure call node specifying the respective variable name and value. Local variables in a procedure They are created in the procedure and are deleted when the execution of the procedure finishes. Use a local variable when you do not need it outside of the current procedure. In procedures they are predestined for intermediate results. Local variables in a test case Variables local to a test case are either created during execution of a test case or defined in the respective table in the details of the test case node. They will be deleted from the variable bindings table once the test case finishes. Use them for values you want to refer to in several nodes of a test case and you do not need outside of it. Global variables Global variables are created at some point of the test execution and exist until they are explicitly deleted or QF‑Test is stopped. They survive stops and restarts of test execution. Use them for values that need to be accessible by all test cases. A typical example is the variable client created in the 'Setup' node when starting the application. To get rid of them you need to either exit QF‑Test or select the menu item »Run«-»Clear global variables«. Command line parameters In batch mode you may want to run test with various parameters. They are valid throughout the batch run. A typical example would be the browser to be used. Test-suite variables test suite variables can be referred to by all test cases. Their usage is the same as that of global variables. Only that they can be overridden at batch execution by command line parameters, whereas global variables cannot. Default values (Fallback stack) You can define default values for variables of procedures, test cases and test sets. In case you do not define a variable of the same name on a higher level QF‑Test will use the default value set.","hash":"tut_variable_levels_web","h0":"Variable binding levels"},"428":{"id":428,"content":"Pro Tutorial","hash":"","h0":"The Standard Library (Web) | QF‑Test Tutorial"},"429":{"id":429,"content":"Pro Tutorial","hash":"home-link","h0":"The Standard Library (Web) | QF‑Test Tutorial"},"430":{"id":430,"content":"The Standard Library (Web) This chapter is also available as a video tutorial at \"The Standard Library\". QF‑Test provides a certain number of node types. If you need additional functionality you can implement it in a script node. To make life easier for you QF‑Test comes with a set of procedures implementing the most commonly needed additional functions. You will find them in the standard procedures library. When you cannot solve a problem using the provided node types it is a good idea to have a look in the standard library whether there is a solution to your problem. If you find a similar solution you can copy the procedure and adapt it to your needs. For information about scripting please refer the the manual, chapter 12 'Scripting'. The file qfs.qft holds the standard procedures library. As it is constantly being enhanced and distributed with every new version of QF‑Test you should not make any changes to procedures in that file, but copy the procedure to your own test suite if required and then adapt it. To make use of qfs.qft it needs to be included in your test suite's root node. With a newly created test suite the file qfs.qft is added automatically to the list of included files. Select the 'Test-suite' root node of your test suite. Verify the qfs.qft is available within the table for \"Include files\". Add qfs.qft to this list, if it's not already there. Path information is not necessary for qfs.qft as the include directory of QF‑Test is contained in the library path (see also Reference part of the manual). Add a procedure call to an arbitrary procedure from the qfs.qft standard library. In the procedure chooser don't miss to switch to the respective tab. In addition to the description provided in this tutorial you can find the full HTML documentation of the standard library available via »Help«-»Standard Library qfs.qft...«","hash":"sec_StandardLibraryWeb","h1":"The Standard Library (Web)"},"431":{"id":431,"content":"Pro Tutorial","hash":"","h0":"Inspecting the Standard Library | QF‑Test Tutorial"},"432":{"id":432,"content":"Pro Tutorial","hash":"home-link","h0":"Inspecting the Standard Library | QF‑Test Tutorial"},"433":{"id":433,"content":"Inspecting the Standard Library In addition to inserting procedure calls from the Standard Library, it also can be helpful to sometimes have a look how certain things have been implemented. Locate and load the test suite file qfs.qft, which is located in the qftest-10.0.2-pro/include directory of your QF‑Test installation.","hash":"sec_StandardLibraryOverviewWeb","h0":"Inspecting the Standard Library"},"434":{"id":434,"content":"Figure 16.1: The Standard Library You can see there is one main package qfs that contains further specific packages. The qfs package helps to easily identify the packages belonging to the standard library. The specific packages cover very different areas of utility procedures described in more detail further below. Within nearly all of the procedures of this library, you'll notice that the variable $(client) is referenced. This is the standard mechanism for creating independence from a specific SUT. Here, the library assumes that the test suite which uses the library will set a value for $(client) prior to using any procedures.","hash":"fig_SuiteQfsQftWeb","h4":"Figure 16.1: The Standard Library"},"435":{"id":435,"content":"Pro Tutorial","hash":"","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"436":{"id":436,"content":"Pro Tutorial","hash":"home-link","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"437":{"id":437,"content":"Selected Packages and Procedures We will now have a closer look at a number of selected packages and procedures from the standard library. We will start with packages for accessing components dependent on the UI technology they are implemented for, here Web.","hash":"sec_StandardLibraryPackagesWeb","h0":"Selected Packages and Procedures"},"438":{"id":438,"content":"The Checkbox Package We begin by looking at the qfs.web.checkbox package. Some important procedures within this package are: select Selects (checks) a checkbox. If the checkbox is already selected, then no action is taken. deselect Deselects (un-checks) a checkbox. If the checkbox is already deselected, then no action is taken. set Sets a checkbox to a given state (true or false). For each of these procedures, you pass the QF‑Test ID of a checkbox component as a variable argument. The library handles verification of whether or not the checkbox state was properly set as expected. Usage of the other procedures in this package follows the general model seen here.","hash":"sec_web_checkbox_package","h1":"The Checkbox Package"},"439":{"id":439,"content":"The Select Package The package qfs.web.select contains procedures to select a value in a combobox. Some procedures within this package are: setValue Select a value in the list of the combobox. getItemCount Return the number of entries in the select box.","hash":"sec_web_combobox_package","h1":"The Select Package"},"440":{"id":440,"content":"The General Package The package qfs.web.general contains useful procedures to work with components. Some procedures within this package are: setLocation Set the location of a given component. setSize Set the size of a given component.","hash":"sec_web_general_package","h1":"The General Package"},"441":{"id":441,"content":"The Table Package The package qfs.web.table provides utility procedures for tables, like: getRowCount Return the number of rows of a table. It uses technology specific methods to gather the row number. getColumnCount Return the number of columns of a table. It uses technology specific methods to gather the column number. selectCell Select a given table-cell.","hash":"sec_web_table_package","h1":"The Table Package"},"442":{"id":442,"content":"The Run log Package The qfs.run-log package contains procedures, which writes specified messages into the run log. This package has been introduced to give testers without scripting-knowledge the opportunity to write messages into the run log. Here is the list of the most important procedures within this package: logError Write a given error message into the run log. logWarning Write a given warning message into the run log. logMessage Write a given message into the run log.","hash":"sec_web_run_log_package","h1":"The Run log Package"},"443":{"id":443,"content":"The Run log.Screenshots Package The qfs.run-log.screenshots package contains procedures, which write images into the run log and some helper methods. Some important procedures within this package are: getMonitorCount Return the total number of monitors. logScreenshot Write a screenshot of the whole screen into the run log. logImageOfComponent Write an image of a given component into the run log. logScreenshotOfMonitor Write a screenshot of a given monitor into the run log.","hash":"sec_web_run_log_screenshots_package","h1":"The Run log.Screenshots Package"},"444":{"id":444,"content":"The Shellutils Package The qfs.shellutils package contains procedures to support most common shell-commands. Some important procedures within this package are: copy Copy a given file or directory to a specified target. deleteFile Delete a given file. exists Check for existence of a given file or directory. getBasename Return only the file name of a full file name. getParentdirectory Return only the directory name of the full file name. mkdir Create a given directory. It also creates non-existing directories in path. move Move a file of directory. touch Create a specified file. removeDirectory Remove a specified directory.","hash":"sec_web_shellutils_package","h1":"The Shellutils Package"},"445":{"id":445,"content":"The Utils Package The qfs.utils package contains procedures, which covers common helper-functionality during test-development. Some important procedures within this package are: getDate Return a string containing the date. Default is the current date. (Other dates can be configured.) getTime Return a string containing the time. Default is the current time. (Other timestamps can be configured.) logMemory Log current memory use. printVariable Print the content of a given variable to the console. printMessage Print a given message to the console. writeMessageIntoFile Write a given string into a given file.","hash":"sec_web_utils_package","h1":"The Utils Package"},"446":{"id":446,"content":"The Database Package The qfs.database package contains procedures to execute SQL commands on a database. Please note that the database driver must be in the class path, i.e. the respective jar file in the qftest plugin directory, before launching QF‑Test. To get more information about the connection-mechanism to your database, please ask your developers or see www.connectionstrings.com. Some important procedures within this package are: executeSelectStatement Execute a given SQL-Select-Statement. It stores the result in a global variable \"resultRows\" on the Jython variable stack and thus accessible from Jython scripts. Additionally, it stores the result in a group variable with the default name 'resultGroup', which can be accessed directy by QF‑Test nodes. executeStatement Execute a given SQL-command. Here any SQL command can be specified.","hash":"sec_web_database_package","h1":"The Database Package"},"447":{"id":447,"content":"The Check Package The qfs.check package contains procedures to do checks. Some important procedures within this package are: checkEnabledStatus Check, whether a component is enabled or disabled. It writes an error into the run log, if failing. checkSelectedStatus Check, whether a component is selected or not. It writes an error into the run log, if failing. checkText Check the text of a component. It writes an error into the run log, if failing.","hash":"sec_web_check_package","h1":"The Check Package"},"448":{"id":448,"content":"The Databinder Package The qfs.databinder package contains procedures for execution within a \"Data driver\" node which bind data for iteration. Some important procedures within this package are: bindList Create and register a databinder that binds a list of values to a variable. Variables are separated by whitespace or by a given separator character. bindSets Create and register a databinder that binds a list of value-sets to a set of variables. Value-sets are separated by line breaks. Variables within a value-set are separated by whitespace or by a given separator character.","hash":"sec_web_databinder_package","h1":"The Databinder Package"},"449":{"id":449,"content":"Pro Tutorial","hash":"","h0":"Control structures (Web) | QF‑Test Tutorial"},"450":{"id":450,"content":"Pro Tutorial","hash":"home-link","h0":"Control structures (Web) | QF‑Test Tutorial"},"451":{"id":451,"content":"Control structures (Web) The two most important control structures of QF‑Test are loops and the conditional execution of nodes. Loops can be implemented by two different kinds of nodes: While and Loop nodes. If, Elseif and Else nodes are available to implement conditional execution. This chapter is also available as a video tutorial at \"Control Structures\".","hash":"sec_controlstructuresweb","h1":"Control structures (Web)"},"452":{"id":452,"content":"Pro Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"453":{"id":453,"content":"Pro Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"454":{"id":454,"content":"If - else You already came across If nodes in the Setup sequence in the chapter Starting the Browser. Let's have a closer look at the details of the node.","hash":"sec_ifweb","h0":"If - else"},"455":{"id":455,"content":"Figure 17.1: Setup Sequence with if-else structures By means of an If node you can control whether certain nodes will be executed or not. In our case whether to start the SUT application. First, we need to find out if the client is already running. This is the job of the Wait for client to connect node, which writes the result of its inquiry, either true or false, into a variable named isSUTRunning.","hash":"fig_ControlsSetupSequenceWeb","h4":"Figure 17.1: Setup Sequence with if-else structures"},"456":{"id":456,"content":"Figure 17.2: Wait for client to connect writes the result into the variable \"isSUTRunning\" The If node has a Condition attribute where you'll find an expression evaluating the result variable isSUTRunning. As we want to refer to its value we need to use the syntax $() (see also note on variable syntax in chapter \"Procedure using a variable\").","hash":"fig_ControlsWaitForClientWeb","h4":"Figure 17.2: Wait for client to connect writes the result into the variable \"isSUTRunning\""},"457":{"id":457,"content":"Figure 17.3: If node evaluates the variable Depending on whether the client is already running or not QF‑Test will execute the nodes nested in the If node. Stop the client in case it is running. Single-step through the Setup node. Leave the client running and single-step through the Setup node a second time. If you like you can check the value of the variable isSUTRunning in the variable bindings table. The first time it will have the value false so that the condition not $(isSUTRunning) will become true and the SUT will be started. The second time it will be true and the if-condition will fail. The nodes nested in the If node will be skipped. Within the first node of the setup sequence you will find more If nodes. They are used to set global variables determining which web browser to use, depending on the operating system. For better readability only If nodes have been used. You may just as well use Elseif and Else to implement that functionality. The child nodes of an Elseif node would be executed if the If condition were false and the Elseif condition were true. The child nodes of an an Else node would be executed if the If condition and all Elseif conditions were false. For checking the operating system you can directly resort to a QF‑Test variable: QF‑Test stores the information about the operation system in a group variable where the group is called 'qftest' and the variables 'linux', 'macos' or 'windows', respectively. The syntax for accessing group variables is ${group:varname}, e.g. ${qftest:windows}.","hash":"fig_ControlsIfWeb","h4":"Figure 17.3: If node evaluates the variable"},"458":{"id":458,"content":"Pro Tutorial","hash":"","h0":"Loops | QF‑Test Tutorial"},"459":{"id":459,"content":"Pro Tutorial","hash":"home-link","h0":"Loops | QF‑Test Tutorial"},"460":{"id":460,"content":"Loops QF‑Test provides two different kinds of nodes loops: Loop nodes execute their child nodes for a certain number of times. However, you can leave the loop any time using a Break node. While nodes execute their child nodes until a certain condition becomes false. Again, you can leave it any time using a Break node. Loop nodes will always stop after the given number of times. In the case of While nodes, however, you need to make sure that the condition will become false at some point. Otherwise you would have an infinite loop. In interactive mode you can always stop execution by hitting the pause button . In batch mode you would have to kill the QF‑Test process. (You start QF‑Test in batch mode using the command line parameter -batch. Then QF‑Test does not start its UI and just executes the given test suite.) In the following exercise we want to implement a test case checking whether a certain row is displayed in the table of the CarConfig application. The actions of the test case will be: Determine the number of rows the table has. Loop over all rows and check if it is the row we are looking for. Break the loop when a match was found. Write an error to the run log if the row was not found. Please start with recording a check on the row of interest: Activate the check recording mode by clicking the toolbar button Right-click a row in the CarConfig application and select the menu item »Row« from the popup menu. Stop the recording by pressing . Change the name of the recorded sequence to e.g. 'Check row' Turn the recorded sequence into a test case by right-clicking it and selecting the submenu item »Transform node into«-»Test case« from the popup menu.","hash":"sec_loopsweb","h0":"Loops"},"461":{"id":461,"content":"Figure 17.4: Transform a node into another one In general, QF‑Test lets you add nodes very efficiently by packing one node into another one: Open the test case node and pack the recorded Check node into a loop by right-clicking it and selecting the submenu item »Pack nodes«-»Loop« from the popup menu.","hash":"fig_ControlsTransformNodeIntoWeb","h4":"Figure 17.4: Transform a node into another one"},"462":{"id":462,"content":"Figure 17.5: Pack a node into another one QF‑Test evaluates dynamically which nodes may be packed into one another and only presents the appropriate ones. So, in case you do not find the 'Loop' submenu item make sure you have right-clicked the correct node. The same holds true for the 'Transform node into' and 'Insert node' methods. In the next series of actions we want to set the value for the Number of iterations attribute of the Loop node. In order to do so we need to find out how many rows the table has. There is no simple node that you could use. However, in the last chapter we learned that the standard library provides a lot of extended functionality. So let's insert the procedure getRowCount from the package qfs.web.table in the standard library. Select the Test case node and press Ctrl⁠+⁠A Press the 'Select procedure' button left to 'Procedure name'. Click the tab 'qfs.qft' in the 'Select procedure' dialog. Navigate to 'getRowCount' in the package 'qfs.web.table' Click 'OK' to select it. Adding a procedure via Ctrl⁠+⁠A was described in Manual creation of procedures. If you would like to check with the screenshots please have a look there. Enter the variable name rows in the Variable for return value attribute. Change the default value for the id in the variable definitions table to the QF‑Test component ID of the table, i.e. VehicleTable. Select the Loop node. Enter a reference to the variable $(rows) in the Number of iterations attribute of the Loop node. Enter the name of an iteration counter, e.g. i in the respective attribute of the Loop node.","hash":"fig_ControlsPackNodeIntoWeb","h4":"Figure 17.5: Pack a node into another one"},"463":{"id":463,"content":"Figure 17.6: Details of a Loop node In the next series of actions we will change the recorded row index to the iteration counter and add a variable for the result to the details of the Check node. Then we will add an If node after the Check node evaluating the result, with a Break node within to quit the loop when the row was found. Open the Loop node. Select the Check node. Change the recorded row index of the QF‑Test component ID to the iteration counter $(i). The QF‑Test component ID should now read VehicleTable@Model&$(i) Enter the variable name checkSucceeded in the 'Variable for result' attribute. Right-click the Check node and the submenu item »Insert node «-»Control structures«-»Break« from the popup menu. Pack the Break node into an If node by pressing Ctrl⁠+⁠Shift⁠+⁠I (Of course you can also pack it via the menu). Type $(checkSucceeded) in the 'Condition' attribute of the 'If' node. The variable checkSucceeded will be set to either true or false by the Check node so that the reference to the variable $(checkSucceeded) is all we need to enter in the 'Condition' attribute of the If node. In the next series of actions let's add an Else node as the last node in the Loop node. It will only be entered if all repetitions of the loop were executed, which in our case means that the row was not found and the check never became true. Collapse the If node if it is open. This is important because otherwise the Else node would belong to the If node and not to the Loop node. Right-click the If node and select the submenu item »Insert node «-»Control structures«-»Else«. Open the Else node. From the standard library insert the procedure logError contained in the package qfs.run-log as described above. Type Row not found in the value field of message in the Variable definitions table. Change the value of withScreenshots in the Variable definitions table from false to true. When you run tests in batch mode screenshots are a great help for analyzing errors. On the other hand a great number of screenshots lead to a big log-file. This is why the default value for withScreenshots is false. Last, let's complete the test case with Setup and Cleanup nodes and move it into the top part of the test suite. Copy the Setup and Cleanup nodes of 'Test set: Simple Tests' into the new test case as the first and last node. Move the test case from the Extras section into the top section of the test suite after the 'Test set: Simple Tests' node. This is what the new test case would look like:","hash":"fig_ControlsLoopDetailsWeb","h4":"Figure 17.6: Details of a Loop node"},"464":{"id":464,"content":"Figure 17.7: The new test case Execute the new test case. It should run without error. Then modify a value in the details of the Check items node, e.g. change the name of the car to Wrong value.","hash":"fig_ControlsTestcaseWeb","h4":"Figure 17.7: The new test case"},"465":{"id":465,"content":"Figure 17.8: Details of the Check items node Execute the new test case again. This time the Else node should be entered and you should get an error message.","hash":"fig_ControlsCheckDetailsWeb","h4":"Figure 17.8: Details of the Check items node"},"466":{"id":466,"content":"Pro Tutorial","hash":"","h0":"It's time to start your own Application (Web) | QF‑Test Tutorial"},"467":{"id":467,"content":"Pro Tutorial","hash":"home-link","h0":"It's time to start your own Application (Web) | QF‑Test Tutorial"},"468":{"id":468,"content":"It's time to start your own Application (Web) After having spent a lot of time with all those example programs, you are now ready to start on your own application (if you really haven't already done so). This chapter is also available as a video tutorial at \"It's time to start your own Application\". The Quickstart Wizard available via the menu »Extras«-»Quickstart Wizard...« helps you to achieve this. Simply follow the wizard steps to generate the setup sequence. Please refer also to chapter 3 \"Quickstart\" in the user manual. Then go ahead with what you have learned in this tutorial - record small sequences of events and checks, turn them into procedures which go into your test library, then set up the test cases using procedure calls. Finally, we reached the end of the basic tutorial part.","hash":"sec_ownappweb","h0":"It's time to start your own Application (Web)"},"469":{"id":469,"content":"Pro Tutorial","hash":"","h0":"Native Windows UI testing with QF‑Test | QF‑Test Tutorial"},"470":{"id":470,"content":"Pro Tutorial","hash":"home-link","h0":"Native Windows UI testing with QF‑Test | QF‑Test Tutorial"},"471":{"id":471,"content":"Native Windows UI testing with QF‑Test This part III of the tutorial is meant to help you learn the basic features and workflows of QF‑Test. It focuses on the test of native Windows applications and its specifics. For testing Java programs please go to \"Java UI testing with QF‑Test\" or \"Web UI testing with QF‑Test\" for Web applications, as those parts use the same scenarios but with different systems under test. In case you already have worked through part I or II but win testing is relevant for you as well, you might not want to work again through the all same scenarios. In \"Advanced features of QF‑Test\" more advanced QF‑Test features are explained, applicable for all supported UI technologies.","hash":"sec_win","h1":"Native Windows UI testing with QF‑Test"},"472":{"id":472,"content":"Pro Tutorial","hash":"","h0":"Working with a Sample Test suite (Win) | QF‑Test Tutorial"},"473":{"id":473,"content":"Pro Tutorial","hash":"home-link","h0":"Working with a Sample Test suite (Win) | QF‑Test Tutorial"},"474":{"id":474,"content":"Working with a Sample Test suite (Win) In this first chapter, we will have a look at a simple test suite, explain its major elements, execute it and evaluate the result. This chapter is also available as a video tutorial at \"Working with a Sample Test suite\".","hash":"sec_windemo","h1":"Working with a Sample Test suite (Win)"},"475":{"id":475,"content":"Pro Tutorial","hash":"","h0":"Loading the Test suite | QF‑Test Tutorial"},"476":{"id":476,"content":"Pro Tutorial","hash":"home-link","h0":"Loading the Test suite | QF‑Test Tutorial"},"477":{"id":477,"content":"Loading the Test suite On first startup of QF‑Test and/or the System Under Test (SUT) via QF‑Test you might get a security warning from the firewall asking whether to block the Java network communication or not. As QF‑Test communicates with the SUT by means of network protocols, this must not be blocked by the local firewall in order to allow automated testing. After starting up QF‑Test, you can immediately bring up our first example test suite. Press the toolbar button to bring up the file open dialog Navigate to the subdirectory qftest-10.0.2-pro/doc/tutorial of your QF‑Test installation There select the file FirstWinTests.qft QF‑Test will then load the indicated test suite which should look as follows:","hash":"tut_loadsuitewin","h0":"Loading the Test suite"},"478":{"id":478,"content":"Figure 19.1: The Test suite FirstWinTests.qft The left part of the main window contains the test suite, organized in a tree structure. The right side shows the details of a selected tree node. At bottom right you'll see the terminal displaying messages sent by QF‑Test and the application you are testing. In the tree structure of the main window you can navigate and select individual nodes of the test suite. Double click the node Test set: Simple Tests to expand it. You'll find the test set contains two test case nodes enclosed by a \"Setup\"/\"Cleanup\" pair.","hash":"fig_firstTestSuiteWin","h4":"Figure 19.1: The Test suite FirstWinTests.qft"},"479":{"id":479,"content":"Figure 19.2: The \"Test set: Simple Tests\" Node In the following sections we'll describe the purpose and function of the individual nodes.","hash":"fig_firstTestSetWin","h4":"Figure 19.2: The \"Test set: Simple Tests\" Node"},"480":{"id":480,"content":"Pro Tutorial","hash":"","h0":"Starting the Application | QF‑Test Tutorial"},"481":{"id":481,"content":"Pro Tutorial","hash":"home-link","h0":"Starting the Application | QF‑Test Tutorial"},"482":{"id":482,"content":"Starting the Application Our first step is to examine the \"Setup\" node: Expand the Setup: Start Demo node now.","hash":"tut_startsutwin","h0":"Starting the Application"},"483":{"id":483,"content":"Figure 19.3: The Setup Node In the \"Setup\" node you'll see two child Sequence nodes: Set variable - set the variable 'client' to the connection name for the SUT, which will be needed for every action replayed to the application. Sequence: Start client if necessary - starts the System Under Test (SUT) in case it is not already running. Let's also have a brief look inside the Sequence: Start client if necessary:","hash":"fig_firstSetupWin","h4":"Figure 19.3: The Setup Node"},"484":{"id":484,"content":"Figure 19.4: The Sequence to start the SUT First you see a \"Wait for client\" node to double-check whether the client is already running. Only if it is not, it will be started. The Start Windows client node starts the application (SUT) and sets up a link between qftest and the SUT. In order to be independent of the actual installation we use a relative path, starting from the QF‑Test version directory, contained in the QF‑Test variable ${qftest:dir.version} (see manual chapter Variables). At this point, we're ready to actually start the SUT: Click on the Setup: Start Demo\" so it is selected and still expanded (the child nodes stay visible). Click the Start test run toolbar button. This button causes the selected node to be executed. During execution QF‑Test marks the active step by use of an arrow pointer ->. When the setup sequence is completed, our demo application \"CarConfiguratorNet Form\" is going to appear on the screen. As QF‑Test gets back the focus after the replay action, thus being raised to the foreground, the demo application might be hiding behind it.","hash":"fig_firstStartWin","h4":"Figure 19.4: The Sequence to start the SUT"},"485":{"id":485,"content":"Figure 19.5: The Windows CarConfigurator Demo","hash":"fig_CarConfigWin","h4":"Figure 19.5: The Windows CarConfigurator Demo"},"486":{"id":486,"content":"Pro Tutorial","hash":"","h0":"First Test case | QF‑Test Tutorial"},"487":{"id":487,"content":"Pro Tutorial","hash":"home-link","h0":"First Test case | QF‑Test Tutorial"},"488":{"id":488,"content":"First Test case Let's check out now what test case \"First\" contains. There are four test steps inside:","hash":"tut_firsttestwin","h0":"First Test case"},"489":{"id":489,"content":"Figure 19.6: The \"First\" Test case Reset - performs a reset by use of the File->Reset menu action and a selection of the Vehicles tab. Select Model I5 - chooses the last model I5 within the vehicles table. Select Special Model Jazz - switches to the Specials tab and selects the Jazz option. Check Final Price - checks that the calculated final price field located at bottom right equals a given value. Test steps are used to group the nodes and to document what is being done. This will prove very useful when it comes to error analysis or test adaptations. Expand the four test step nodes.","hash":"fig_firstTestCaseWin","h4":"Figure 19.6: The \"First\" Test case"},"490":{"id":490,"content":"Figure 19.7: Details of the first Test case You can see Mouse clicks and Checks, which have been grouped in test step nodes for better readability of the test case. The action nodes display the action type (Mouse click, Check, ...) and the component targeted, i.e. where the action goes to. When writing a test you can use the QF‑Test recording function to create them. Recording will be explained in the next \"Creating your own test suite (Win)\". Please select the test case \"First\" node Click the replay button . The test steps will then be replayed in the SUT. The test result is indicated during and after the test run in the status line at the bottom of the QF‑Test main window and should read now 'Finished: No errors'. Next to it there are counters for the numbers and results of the test cases executed. In our case it was just one, error-free, which means a success rate of 100%.","hash":"fig_firstTestCaseDetailsWin","h4":"Figure 19.7: Details of the first Test case"},"491":{"id":491,"content":"Figure 19.8: The result view in the status line Each counter icon has a descriptive tool tip. A list of all counters can be found in the chapter 'Capture and replay' of the manual.","hash":"fig_resultOneTestCaseNoErrorWin","h4":"Figure 19.8: The result view in the status line"},"492":{"id":492,"content":"Pro Tutorial","hash":"","h0":"Second Test case - with Error | QF‑Test Tutorial"},"493":{"id":493,"content":"Pro Tutorial","hash":"home-link","h0":"Second Test case - with Error | QF‑Test Tutorial"},"494":{"id":494,"content":"Second Test case - with Error The second test case will show us what happens when an error occurs during test execution. Expand the test case \"Second (with Error)\".","hash":"tut_secondtestwin","h0":"Second Test case - with Error"},"495":{"id":495,"content":"Figure 19.9: The Second Test case Apart from the third test step it is identical to the first test case. So what does this one do? Test step: Grant 10% discount - Writes the value 10 into the discount field. The 'Input' node is another basic action node and can be created directly via the QF‑Test recording function. Expand the Test step: Grant 10% Discount.","hash":"fig_secondTestCaseWin","h4":"Figure 19.9: The Second Test case"},"496":{"id":496,"content":"Figure 19.10: Details of the second Test case Let's execute the second test case: Select the node Test case: \"Second (with Error)\". Click the replay button . This time a dialog shows up telling us that an error occurred.","hash":"fig_SecondTestCaseDetailsWin","h4":"Figure 19.10: Details of the second Test case"},"497":{"id":497,"content":"Figure 19.11: Error in the second test case What happened? To find out we'll open the QF‑Test run log for error analysis. An alternative approach for error analysis would be to execute the test case again using the debugger. This will be explained in chapter Using the Debugger (Win).","hash":"fig_textTestErrorWin","h4":"Figure 19.11: Error in the second test case"},"498":{"id":498,"content":"Pro Tutorial","hash":"","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"499":{"id":499,"content":"Pro Tutorial","hash":"home-link","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"500":{"id":500,"content":"The Run log for Error Diagnosis QF‑Test logs detailed information for every test execution. Please open the latest run log by one of the following options: either by pressing the Show run log button of the error dialog or in case you have already closed the dialog by pressing toolbar button or by pressing Ctrl⁠+⁠L. The most recent run logs are also listed at the bottom of the Run menu of the main window. The run log comes up in a separate window displaying the logged actions of the test case you've just executed:","hash":"tut_firstrunlogwin","h0":"The Run log for Error Diagnosis"},"501":{"id":501,"content":"Figure 19.12: Run Log for the second test case The run log reflects the tree structure of the test suite view you are already familiar with. When you click on one of the nodes on the left side, the properties of the event including time stamp and duration will be displayed on the right. In the tree left you will notice nodes surrounded by a red border. These are indicators showing where a problem occurred in a child node. If you keep expanding the red nodes, you'll eventually come to the actual error node. Please use an easier way to find the error source by pressing the Find next error toolbar button or the [Ctrl-N] key shortcut. All nodes with red highlighting have been expanded and the actual error node has been selected:","hash":"fig_firstErrorRunlogWin","h4":"Figure 19.12: Run Log for the second test case"},"502":{"id":502,"content":"Figure 19.13: Error in the second test case The error message on the right says that the expected value of the final price field differs from the actual one. Of course this error is there by intention as the second test case is supposed to show us how to analyze an error. Another helper for error analysis is the Screenshot of the SUT taken at the time when the error occurred (four nodes down from the red node). Being able to see the state of the SUT at that moment often proves useful for determining the cause of the error. The following image shows a screenshot node:","hash":"fig_firstErrorRunlogDetailsWin","h4":"Figure 19.13: Error in the second test case"},"503":{"id":503,"content":"Figure 19.14: Screenshot node showing the error situation In addition to screenshots of all monitors, QF‑Test also saved images of the client windows at the time of the error. This allows you to analyze the contents even if they are covered by other dialogs or windows.","hash":"fig_firstErrorRunlogScreenshotWin","h4":"Figure 19.14: Screenshot node showing the error situation"},"504":{"id":504,"content":"Pro Tutorial","hash":"","h0":"Getting Help | QF‑Test Tutorial"},"505":{"id":505,"content":"Pro Tutorial","hash":"home-link","h0":"Getting Help | QF‑Test Tutorial"},"506":{"id":506,"content":"Getting Help We take a short break in this section to give you a few tips that might prove helpful as you continue with the tutorial. There are different places where you can look for help or information: The most comprehensive search can be achieved via »Help«-»Online search...«. This navigates you to the search functionality on our homepage and allows querying throughout all available documentation (manual, tutorial, standard library, blog and our videos). Search results can be filtered as needed. In case you work offline and want to search for a certain topic, the offline versions of the manual or tutorial available via the »Help« menu can be used. QF‑Test also offers a context sensitive help for tree node types and their details. To use it, simply press the right mouse button on an arbitrary tree node or attribute in the details pane. From the context menu select »What's this?«. This will directly bring you to the reference explanation of this item in the manual. Beside getting help from the documentation you also have the option to contact our support team. During your evaluation phase or after that as customer with a valid maintenance contract you may issue your questions directly to our support experts using the QF‑Test help menu entry »Contact the support team« or via our website.","hash":"tut_firsthelpwin","h0":"Getting Help"},"507":{"id":507,"content":"Pro Tutorial","hash":"","h0":"Stopping the Application | QF‑Test Tutorial"},"508":{"id":508,"content":"Pro Tutorial","hash":"home-link","h0":"Stopping the Application | QF‑Test Tutorial"},"509":{"id":509,"content":"Stopping the Application We haven't inspected the cleanup sequence, so let's have a look at it now: Expand the Cleanup: Stop Demo node.","hash":"tut_firstcleanupwin","h0":"Stopping the Application"},"510":{"id":510,"content":"Figure 19.15: The Cleanup Sequence The Cleanup sequence stops the client process in a hard way and waits until it fully terminates. This is a very simple approach and shall suffice for the moment. Execute the cleanup to see the CarConfigurator demo vanish.","hash":"fig_firstCleanupWin","h4":"Figure 19.15: The Cleanup Sequence"},"511":{"id":511,"content":"Pro Tutorial","hash":"","h0":"A full Test Run | QF‑Test Tutorial"},"512":{"id":512,"content":"Pro Tutorial","hash":"home-link","h0":"A full Test Run | QF‑Test Tutorial"},"513":{"id":513,"content":"A full Test Run After we have seen how the single elements of the test set work, let us have a look at the functionality provided by the test set node. First, close the CarConfigurator application in case it is still running. Then select the \"Test set: Simple Tests\" node. Execute it with the replay button . The result dialog will come up after test execution, informing us about the error caused by the second test case. Open the run log again by to take a closer look:","hash":"tut_firstFullRunWin","h0":"A full Test Run"},"514":{"id":514,"content":"Figure 19.16: Run Log for the Completed Test set This shows the special behavior of Setup / Cleanup nodes in a test set: They are executed before and after each test case to help achieving a proper starting state for each test case. Stopping the SUT after each test case is not the smartest way to ensure a clean state. There are more elegant ways for setup and cleanup that will be explained with the advanced features in this tutorial (\"Dependencies: Automatically ensuring correct prerequisites for each Test case\").","hash":"fig_winRunlogFull","h4":"Figure 19.16: Run Log for the Completed Test set"},"515":{"id":515,"content":"Pro Tutorial","hash":"","h0":"Report Generation | QF‑Test Tutorial"},"516":{"id":516,"content":"Pro Tutorial","hash":"home-link","h0":"Report Generation | QF‑Test Tutorial"},"517":{"id":517,"content":"Report Generation In the world of quality assurance documenting test results is important. To this end, QF‑Test offers an automated report-generation feature. Since you've just done a complete test run, we're at a good point to show you this feature. Make sure the run log of the test run is open. In the run log window select »File«-»Create report...« to bring up the dialog for the report parameters.","hash":"tut_firstreportwin","h0":"Report Generation"},"518":{"id":518,"content":"Figure 19.17: Report Generation Properties In the first field, you can specify the file name of the report. Following this, you can decide what type of report you want. QF‑Test offers three kinds of reports, HTML, XML and JUnit format. An XML report is useful if you want to process the data further, e.g. if you have written your own XSLT stylesheets to shape the report. JUnit reports prove useful when you need to import results into build or test management tools. Let's generate an HTML report from the results of the last test run. So just leave the report options unchanged. Start generation by pressing the OK button. The report will then be generated and presented to you in a browser window:","hash":"fig_winReportDialog","h4":"Figure 19.17: Report Generation Properties"},"519":{"id":519,"content":"Figure 19.18: An HTML Report The report begins with a summary containing informational data from your system on the top left side, a legend describing the meaning of icons used in the report on the top right side, an overview pie chart in the middle and the overall test result below. In our case, the result we see are the error-free first test case and the second with the well-known error, leading to a success rate of 50%. Following the summary there are three overview sections: Test suites that have been executed within the test run. Test suites in which errors occurred. Errors including their exact position and detailed message. The report generator is very useful for creating an overview document for presentation and archiving purposes.","hash":"fig_winReportHtml","h4":"Figure 19.18: An HTML Report"},"520":{"id":520,"content":"Pro Tutorial","hash":"","h0":"Creating your own test suite (Win)\n     | QF‑Test Tutorial"},"521":{"id":521,"content":"Pro Tutorial","hash":"home-link","h0":"Creating your own test suite (Win)\n     | QF‑Test Tutorial"},"522":{"id":522,"content":"Creating your own test suite (Win) In the second chapter of the Win tutorial we will create our own sequences for starting and stopping an SUT from QF‑Test. Furthermore we are going to record actions and checks and use those to build up a simple test case. This chapter is also available as a video tutorial at \"Creating your own test suite\".","hash":"sec_wintestsuite","h1":"Creating your own test suite (Win)"},"523":{"id":523,"content":"Pro Tutorial","hash":"","h0":"Starting the Application | QF‑Test Tutorial"},"524":{"id":524,"content":"Pro Tutorial","hash":"home-link","h0":"Starting the Application | QF‑Test Tutorial"},"525":{"id":525,"content":"Starting the Application To begin, you need to launch the application from QF‑Test. The Quickstart Wizard helps to generate the respective setup sequence. Please open a new test suite via the menu item »File« »New test suite...«. Open the Quickstart Wizard via the menu »Extras«-»Quickstart Wizard...« . In the first step you can choose the type of application to be tested. Please select the fourth option A native windows application. Press Next.","hash":"tut_quickstartwin","h0":"Starting the Application"},"526":{"id":526,"content":"Figure 20.1: Type of Application The next step specifies the Windows application executable. For this please use the select button on the right. Navigate to the subdirectory qftest-10.0.2-pro/demo/carconfigForms/ of the QF‑Test installation. Select the CarConfigForms.exe. The second field can be left empty in our case hence it should be mentioned that it is also possible to connect QF‑Test to an already running Windows application by help of its window title. Such can be specified in the second field. Also regular expressions can be used for specifying those window titles. In the figure below we used the QF‑Test variable ${qftest:dir.version} to address the version specific directory of the QF‑Test installation, which you have already come across in the previous chapter. (Details on special QF‑Test variables can be found in the manual chapter Variables). Please press the Finish button, as we do not need to go to the further optional steps for our simple demo.","hash":"fig_WizardTypeWin","h4":"Figure 20.1: Type of Application"},"527":{"id":527,"content":"Figure 20.2: Windows executable file selection. We directly reach the final summary that explains what will happen after closing the wizard and how to continue. Please press Finish in order to end the wizard.","hash":"fig_WizardExecFileWin","h4":"Figure 20.2: Windows executable file selection."},"528":{"id":528,"content":"Figure 20.3: Final Information The generated setup sequence Launch CarConfigForms appears in the \"Extras\" section of your test suite and contains three parts: Set variable - defines the global client variable used throughout the test suite. Wait for client to connect - checks whether the client is already running. Launch SUT if not running - starts the System Under Test as client if it is not already running by us of a Start windows application, and wait for its start. The information whether the client is already running is stored into a variable \"isSUTRunning\" in the first Wait for client to connect node and evaluated by the subsequent \"If\" condition. You can find this in the respective node details. This kind of conditional execution will be explained later in detail.","hash":"fig_WizardFinalWin","h4":"Figure 20.3: Final Information"},"529":{"id":529,"content":"Figure 20.4: Generated Setup Sequence Now we want to see some action: Please ensure the Setup: Launch CarConfigForms node is selected. Then click or simply hit \"Enter\" Return. You should see the Windows CarConfigurator application appear on your screen soon. As the focus changes back to QF‑Test after the execution, the Demo might be covered by the test suite window.","hash":"fig_WizardResultWin","h4":"Figure 20.4: Generated Setup Sequence"},"530":{"id":530,"content":"Figure 20.5: The Windows CarConfigurator Demo At the end of this section let's save our test suite. Press the toolbar button or use the »File«-»Save« menu option with its short-cut Ctrl⁠+⁠S. In the file explorer navigate to an appropriate directory where you have write access e.g. Documents in your user home directory. Provide a name e.g. MyFirstTests.qft. Finish the saving action by pressing on Save.","hash":"fig_CarConfigWin2","h4":"Figure 20.5: The Windows CarConfigurator Demo"},"531":{"id":531,"content":"Pro Tutorial","hash":"","h0":"Recording Actions | QF‑Test Tutorial"},"532":{"id":532,"content":"Pro Tutorial","hash":"home-link","h0":"Recording Actions | QF‑Test Tutorial"},"533":{"id":533,"content":"Recording Actions You're now ready to record some actions for our demo:","hash":"tut_recactionswin","h0":"Recording Actions"},"534":{"id":534,"content":"Figure 20.6: Recording actions on the CarConfiguratorForms Demo Please press the Record button. Switch to the SUT application window. From now on every mouse and keyboard action performed within the SUT window will be recorded. There is an indication show as red square below the mouse cursor. Just after this has disappeared you may record your action on the component. Click to the table cell I5 in the last row. Change to the Specials tab of the tabbed pane. Choose the special Jazz from the combo box. Finally switch back to the Vehicles tab in the tabbed pane. Stop the recording by use of the button. A red square below the mouse cursor indicates by its disappearing QF‑Test is ready for recording actions on the component. You'll find the recorded sequence placed in the \"Extras\" section:","hash":"fig_CarConfigWinRec","h4":"Figure 20.6: Recording actions on the CarConfiguratorForms Demo"},"535":{"id":535,"content":"Figure 20.7: The Recorded Sequence The recorded sequence has a default name with date and time of the recording. You can change this name as you see fit by simply clicking on the node and changing its properties in the details view on the right. Please rename the recorded sequence to \"Select Model I5 Jazz\". Then open the sequence node to see its content. There should be the expected mouse clicks. You should even be able to interpret where they go to.","hash":"fig_FirstRecordedSequenceWin","h4":"Figure 20.7: The Recorded Sequence"},"536":{"id":536,"content":"Figure 20.8: The Renamed Sequence Now, let us replay the recorded sequence. Select the Select Model I5 Jazz sequence node. Press the play button . You should now see exactly the same sequence of mouse events executed in the SUT as you recorded before. The sequence is supposed to replay (even multiple times) without errors. You should see \"Finished: No error\" in the bottom right corner of your test suite window.","hash":"fig_FirstRecordedSequenceRenamedWin","h4":"Figure 20.8: The Renamed Sequence"},"537":{"id":537,"content":"Pro Tutorial","hash":"","h0":"Recording Checks | QF‑Test Tutorial"},"538":{"id":538,"content":"Pro Tutorial","hash":"home-link","h0":"Recording Checks | QF‑Test Tutorial"},"539":{"id":539,"content":"Recording Checks To verify the client's behavior we use check nodes, which query certain states and properties of elements within the SUT. Also checks can be recorded. Click the \"Record a check\" button. Switch to the SUT window. When moving the mouse over the components you will notice a blue border indicating the current selection. Move the mouse over the value field of \"Final price\" and wait for the check border to appear. Right-click now on the value field. In the popup menu you are offered a choice of standard checks for a text field component. Select the first option \"Text\" for a check on the textual value of the field. Stop the recording by using the Stop button. Ensure the check border is shown for a component before clicking to record a check. Otherwise the check may not be recored properly. Again, the newly recorded sequence appears in the \"Extras\" section. Please rename the sequence to \"Check final price\" Expand it to see the check node.","hash":"tut_reccheckswin","h0":"Recording Checks"},"540":{"id":540,"content":"Figure 20.9: The recorded check node Feel free to run this sequence, too, verifying it is working properly. As the next step, we want to create a test case from the two sequences.","hash":"fig_textchecktreeWin","h4":"Figure 20.9: The recorded check node"},"541":{"id":541,"content":"Pro Tutorial","hash":"","h0":"Setting up a test suite | QF‑Test Tutorial"},"542":{"id":542,"content":"Pro Tutorial","hash":"home-link","h0":"Setting up a test suite | QF‑Test Tutorial"},"543":{"id":543,"content":"Setting up a test suite The top-level nodes of the test suite define its basic structure: Right after the \"Test-suite\" node an arbitrary number of \"Test set\" and \"Test case\" nodes may be added specifying the functional tests. \"Procedures\" contains reusable sequences (procedures) that can be organized into packages. \"Extras\" is the scratch pad for recording and experimentation. \"Windows and components\" contains the all-important elements of the test suite: registered elements of the SUT , e.g. windows, menus and buttons. The details of each element in the \"Windows and components\" section contains the properties of the recorded UI element required by QF‑Test to find the component when replaying a test. Functional test cases are represented by \"Test case\" nodes and can be grouped and structured with the help of \"Test set\" nodes. \"Setup\" and \"Cleanup\" nodes are intended for test steps ensuring a well-defined state before and after a test case. Let's start by renaming the top-level test set node from \"unnamed\" to \"Demo Tests\". If a dialog pops up asking us whether to update references we can simply confirm with \"Yes\". The second step is to move the \"Setup\" node generated by the Quickstart Wizard from the \"Extras\" node into the \"Test set\" node - right before the \"Test case\" node. Moving the \"Setup\" node can be done via mouse (Drag&Drop), context-menu (right mouse-button copy/paste) or by Ctrl⁠+⁠X and Ctrl⁠+⁠V keyboard commands.","hash":"tut_buildtestwin","h0":"Setting up a test suite"},"544":{"id":544,"content":"Figure 20.10: Start organizing the test suite The next step is to make a test case of the two sequences previously recorded. Please rename the test case node from \"unnamed\" to \"First\". Open the test case node by clicking the '>' symbol. Move the two sequences from \"Extras\" into the test case. You need to open the test case node because otherwise QF‑Test would try to place the sequence nodes after the test case node on the same level, which is not a valid option. QF‑Test always records sequence nodes. They have the same functionality as test step nodes, only they do not show up in the report. So, just to show you, we will transform the two sequence nodes into test step nodes. Please open the context menu for the first of the two sequence nodes by a right-click. Choose »Transform node into...«-»Test step« Repeat this for the second sequence node. Your test suite should now look like this:","hash":"fig_beginbuildatest_win","h4":"Figure 20.10: Start organizing the test suite"},"545":{"id":545,"content":"Figure 20.11: The Organization of your test suite","hash":"fig_buildatest_win","h4":"Figure 20.11: The Organization of your test suite"},"546":{"id":546,"content":"Pro Tutorial","hash":"","h0":"Stopping the Demo | QF‑Test Tutorial"},"547":{"id":547,"content":"Pro Tutorial","hash":"home-link","h0":"Stopping the Demo | QF‑Test Tutorial"},"548":{"id":548,"content":"Stopping the Demo The only thing missing now is a cleanup sequence closing down the SUT. There are usually various ways to terminate an SUT, e.g. clicking the close button of the application window, pressing ALT-F4 or via the menu action »File«-»Exit«. All these options can be directly recorded and then used in the cleanup sequence. Let's use the last one. So please perform the following steps. Start recoding . Record the menu SUT menu action »File«-»Exit«. You see the demo window close. Stop recording . Rename the recorded sequence to \"Stop demo\". Open the context menu for the recorded sequence and select »Convert into...«-»Cleanup«. Finally move the cleanup node up to be the last node in the test set. The cleanup node can only be dragged and dropped to the test set if the test set's last child node is collapsed. To expand or collapse a node during a drag and drop operation, hold your cursor over the triangle next to the node. You should end up with the following:","hash":"tut_cleanupwin","h0":"Stopping the Demo"},"549":{"id":549,"content":"Figure 20.12: The simple cleanup sequence By this we have finished with the basic steps of structuring our suite.","hash":"fig_StopSequenceWin","h4":"Figure 20.12: The simple cleanup sequence"},"550":{"id":550,"content":"Pro Tutorial","hash":"","h0":"Running the whole test suite | QF‑Test Tutorial"},"551":{"id":551,"content":"Pro Tutorial","hash":"home-link","h0":"Running the whole test suite | QF‑Test Tutorial"},"552":{"id":552,"content":"Running the whole test suite Finally let's execute our newly created suite: Terminate the SUT client in case it is running. Select the root node of the test suite. Run it by pressing \"Replay\" or typing Return. The SUT is expected to appear, the test case will be executed and finally the SUT will be terminated. We know the test run details can be looked up in the run log. It can be opened by clicking the toolbar button or via the »Run«-»1. ...« menu option with its short-cut Ctrl⁠+⁠L","hash":"tut_runownsuitewin","h0":"Running the whole test suite"},"553":{"id":553,"content":"Figure 20.13: The Run log of the test suite In the first tutorial chapter we've already learned how to use the run log for error analysis.","hash":"fig_firstrunlogWin","h4":"Figure 20.13: The Run log of the test suite"},"554":{"id":554,"content":"Pro Tutorial","hash":"","h0":"Writing a Procedure (Win) | QF‑Test Tutorial"},"555":{"id":555,"content":"Pro Tutorial","hash":"home-link","h0":"Writing a Procedure (Win) | QF‑Test Tutorial"},"556":{"id":556,"content":"Writing a Procedure (Win) This chapter is also available as a video tutorial at \"Writing a Procedure\". In the two previous chapters you learned how to start an application from QF‑Test thus being able to record mouse and keyboard actions, add checks and organize the result in a test case. This approach is fine and sufficient as long as your tests are simple and you have just a few of them. But as soon as the number of tests increases it is important to make use of so-called 'procedures'. Procedures make sequences reusable and therefore avoid duplicated identical parts. This is important for easy and on the long run efficient maintenance of your tests. Procedures can be organized into packages . Procedures and packages are the basis for modularizing your tests.","hash":"sec_FirstProcedureWin","h1":"Writing a Procedure (Win)"},"557":{"id":557,"content":"Pro Tutorial","hash":"","h0":"Identifying reusable parts | QF‑Test Tutorial"},"558":{"id":558,"content":"Pro Tutorial","hash":"home-link","h0":"Identifying reusable parts | QF‑Test Tutorial"},"559":{"id":559,"content":"Identifying reusable parts In this chapter we will work with the test suite FirstWinTests.qft you already know from chapter 19. Copy FirstWinTests.qft from the subdirectory qftest-10.0.2-pro/doc/tutorial of the QF‑Test installation to a working directory and open FirstWinTests.qft. If you want to keep the changes you will be making to the demo test suite save it in a working directory as described at the end of \"Starting the Application\". Please have a look at the test step \"Reset\" in the two test cases. They are exactly the same.","hash":"tut_procreusewin","h0":"Identifying reusable parts"},"560":{"id":560,"content":"Figure 21.1: Two identical test steps Following above concepts it would be a good idea to turn them into a procedure.","hash":"IdenticalTeststepsWin","h4":"Figure 21.1: Two identical test steps"},"561":{"id":561,"content":"Pro Tutorial","hash":"","h0":"Manual creation of procedures | QF‑Test Tutorial"},"562":{"id":562,"content":"Pro Tutorial","hash":"home-link","h0":"Manual creation of procedures | QF‑Test Tutorial"},"563":{"id":563,"content":"Manual creation of procedures There is more than one way to create procedures and insert procedure calls. We will start with the manual one by inserting an (empty) procedure node and moving the respective actions into it. Then we will create the respective procedure call. It is good to know those basic steps but there is a second more elegant way of creating procedures, which we will explain afterwards. Okay, let's do it by hand. We will start with creating a procedure node and naming it appropriately. Open the Procedures node and keep it selected. Chose »Insert«-»Procedure nodes«-»Procedure«. Name it 'reset'. The other fields can be left empty. Open the newly created 'reset' procedure node.","hash":"tut_procmanualwin","h0":"Manual creation of procedures"},"564":{"id":564,"content":"Figure 21.2: Create a procedure node The second step is to fill the procedure with the respective reusable actions. Select the three 'Mouse click' nodes in the test step. To select more than one node at once you can select the first one, then press the Shift key and, while keeping it pressed, click the last node you want to select. Move them down into the procedure e.g. by mouse (drag&drop) or cut/paste from the »Edit« or context menu.","hash":"ProcedureNodeInFirstTestcaseWin","h4":"Figure 21.2: Create a procedure node"},"565":{"id":565,"content":"Figure 21.3: Fill in the procedure content The third step is to add a procedure call to the place of the three 'Mouse clicks' you moved. Select the test step 'Reset', which is still open. Select »Insert«-»Procedure nodes«-»Procedure call« or use the Ctrl⁠+⁠A shortcut.","hash":"ProcedureContentInFirstTestcaseWin","h4":"Figure 21.3: Fill in the procedure content"},"566":{"id":566,"content":"Figure 21.4: Insert a procedure call Press the procedure selection button left of the label 'Procedure name'. Select 'reset' from your test suites procedures. Other fields can be left as they are. Press the OK button to finalize the creation of the procedure call.","hash":"AddProcedureCallWin","h4":"Figure 21.4: Insert a procedure call"},"567":{"id":567,"content":"Figure 21.5: Select a procedure In order get a real benefit from the procedure, of course, we also need to replace the content of reset test step in the second test case by the 'reset' procedure call, too. You can do it the same way as before or use the following alternative steps to create a procedure call: Open the 'Reset' test step of the second test case. Remove the three 'Mouse click' action nodes therein. Select the 'reset' procedure node. Move it via drag&drop into the 'Reset' test step (copy/paste action can be used alternatively). This does not actually move it but create a respective procedure call. The test suite should look like this:","hash":"SelectProcedureWin","h4":"Figure 21.5: Select a procedure"},"568":{"id":568,"content":"Figure 21.6: Test-suite with procedure When now executing the test cases the reset in meant to still work like before. Hence, in the run log you will see the same executed node as before, only preceded by the procedure call.","hash":"fig_testsuite_with_procedure_win","h4":"Figure 21.6: Test-suite with procedure"},"569":{"id":569,"content":"Pro Tutorial","hash":"","h0":"Transforming nodes into procedures | QF‑Test Tutorial"},"570":{"id":570,"content":"Pro Tutorial","hash":"home-link","h0":"Transforming nodes into procedures | QF‑Test Tutorial"},"571":{"id":571,"content":"Transforming nodes into procedures As already mentioned at the beginning of the last section, QF‑Test offers an alternative, much faster way to create a procedure: Select the test step or sequence node that contains the reusable steps to be transformed into a procedure. Select menu item »Operations«-»Transform node into«-»Procedure« or use the Ctrl⁠+⁠Shift⁠+⁠P shortcut. You will find that the test step, respectively sequence node disappeared and there is a procedure call in its place. Moreover, a procedure was created in the Procedures section containing the child nodes of the former test step / sequence node and named the same. It is good practice with QF‑Test to record a sequence, give it a name and immediately turn it into a procedure via Ctrl⁠+⁠Shift⁠+⁠P if you suspect it to be of use somewhere else, too.","hash":"tut_proctransformwin","h0":"Transforming nodes into procedures"},"572":{"id":572,"content":"Pro Tutorial","hash":"","h0":"Components (Win) | QF‑Test Tutorial"},"573":{"id":573,"content":"Pro Tutorial","hash":"home-link","h0":"Components (Win) | QF‑Test Tutorial"},"574":{"id":574,"content":"Components (Win) Let us have a look at the last main section in the test suite window, the Windows and components node. When talking about components we also want to show you how to address subitems of components like tables, trees and lists. This chapter is also available as a video tutorial at \"Components\".","hash":"sec_ComplexComponentsWin","h1":"Components (Win)"},"575":{"id":575,"content":"Pro Tutorial","hash":"","h0":"Addressing subitems of tables, lists and trees | QF‑Test Tutorial"},"576":{"id":576,"content":"Pro Tutorial","hash":"home-link","h0":"Addressing subitems of tables, lists and trees | QF‑Test Tutorial"},"577":{"id":577,"content":"Addressing subitems of tables, lists and trees Subcomponents of tables, lists and trees can be addressed by indices. There are two main types: text and numeric indices. Let's record a mouse click to a table cell and analyze the recorded QF‑Test component ID. Start the CarConfig application, in case it has not been started already, by executing the Setup node of the test suite. Activate the recording mode by pressing the toolbar button . Click a table cell, e.g. the first model. Stop the recording by pressing . You will see the recorded mouse click in the Extras section.","hash":"sec_addressing_complex_components_win","h0":"Addressing subitems of tables, lists and trees"},"578":{"id":578,"content":"Figure 22.1: Addressing a table cell The QF‑Test component ID recorded is VehicleTable@Model&0. The single parts are: VehicleTable is the QF‑Test component ID of the table component itself. @ and & separate the single parts from each other and at the same time indicate the type of index that follows: @ for a text index and & for a numeric index. Model is the text index for the table column with the title 'Model'. 0 is the numeric index for the first table row. Numeric indices always start at 0. You can use any index type for column or row. It is just important that the separator and the index type match. Change the QF‑Test component ID so that the third price value in the table will be clicked, using numeric indices only. The solution is to type VehicleTable&1&2 in the QF‑Test component ID attribute of the Mouse event node. In order to address the model 'I5' using text indices only, you would have to enter VehicleTable@Model@I5. Using numeric indices you would write VehicleTable&0&4 and for mixed indices VehicleTable&0@I5 or VehicleTable@Model&4. The third type of index QF‑Test supports is a text index containing a regular expression. Regular expressions can be used to replace a string by an expression that can match more than only one string. For a detailed explanation of regular expressions please refer to the manual. So you could also address the cell for the model 'I5' using VehicleTable@Model%I.*. Lists are addressed the same way as tables are, just with one index only. A tree has only one index. This is the path down the tree to the node to be specified. The path consists of the respective nodes of the tree, separated by slashes ('/'). Let's record a mouse click to a tree: Start the CarConfig application, in case it has not been started already, by executing the Setup node of the test suite. Navigate to the tree: In the CarConfig application select the menu item »Options«-»Specials...«, select a model and press 'Details' Activate recording mode by pressing the toolbar button . Click a tree node, e.g. 'Description'. Stop the recording by pressing . For the tree node 'Description' the recorded QF‑Test component ID would be DetailsTree@/Information/Description. The single parts are: DetailsTree is the QF‑Test component ID of the tree component itself. @ separates the QF‑Test component ID of the tree from the index and at the same time indicates the type of index that follows: @ for a text index. /Information/Description is the text index for the tree path to 'Description'. If you wanted to address the node using a numeric index you would have to use DetailsTree&/0/1.","hash":"fig_components_tableindex_win","h4":"Figure 22.1: Addressing a table cell"},"579":{"id":579,"content":"Pro Tutorial","hash":"","h0":"Using the Debugger (Win) | QF‑Test Tutorial"},"580":{"id":580,"content":"Pro Tutorial","hash":"home-link","h0":"Using the Debugger (Win) | QF‑Test Tutorial"},"581":{"id":581,"content":"Using the Debugger (Win) In this chapter we will learn how to run a test suite with QF‑Test's built-in and intuitive debugger. If you are familiar with debugging from other IDEs like Eclipse, you will find this debugger similar in function and usefulness. This chapter is also available as a video tutorial at \"Using the Debugger\". By the end of this chapter you will be familiar with the following debugger functionality: Setting a Breakpoint e.g. via Ctrl⁠+⁠F8. Pausing a test run at any time and resuming operation using the debugger button or the hotkey Alt⁠+⁠F12. Stepping Through a Test or Sequence using the debugger buttons 'Single step' , 'Step over' and 'Step out' . Skipping Execution of Nodes using the debugger buttons 'Skip over' and 'Skip out' . Error or Exception triggering Debugging Mode. Resolving Errors directly from the Run log. Jump directly to the current error in the run log via Ctrl⁠+⁠J. (Jump to run log in chapter \"Resolving Errors directly from the Run log\"). Instead of the debugger buttons you can also enter the commands via the QF‑Test menu and most by keyboard shortcuts as well. You'll find the the shortcut listed beside the menu option, if available. For a complete list, refer to the Keyboard shortcuts section of the user manual. You can also find a little helper there for attaching to your keyboard which shows the function key assignment of QF‑Test. There are some more functions related to the debugger that we will come to in later chapters: Locating the current node using the debugger button (Locate the current node in chapter \"Advanced debugging of variable bindings\"). \"Continue execution from here\" via the popup menu of the respective node (\"Continue Execution from here\"). Rethrowing exceptions using the toolbar button . The variable bindings table (\"Advanced debugging of variable bindings\").","hash":"sec_DebuggerWin","h1":"Using the Debugger (Win)"},"582":{"id":582,"content":"Pro Tutorial","hash":"","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"583":{"id":583,"content":"Pro Tutorial","hash":"home-link","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"584":{"id":584,"content":"Setting a Breakpoint First of all we need to activate debugging mode. There are several ways to do so. One of them is to set a breakpoint at the node where we want to have a closer look. When the test is being executed and QF‑Test comes to the break point it will then pause and switch into debugging mode. The pause button will then be activated. Select a node and press Ctrl⁠+⁠F8. The breakpoint is indicated by a .","hash":"tut_breakpointswin","h0":"Setting a Breakpoint"},"585":{"id":585,"content":"Figure 23.1: Set break point Select the Test suite node and press Enter to start the test run.","hash":"fig_DebugSetBreakpointWin","h4":"Figure 23.1: Set break point"},"586":{"id":586,"content":"Figure 23.2: Start test run Remove the breakpoint by pressing Ctrl⁠+⁠F8 again.","hash":"fig_DebugStartTestRunWin","h4":"Figure 23.2: Start test run"},"587":{"id":587,"content":"Figure 23.3: Remove break point Instead of using the keyboard shortcut Ctrl⁠+⁠F8 you may also set or unset a breakpoint by clicking the node and selecting the »Debugger«-»Breakpoint on/off« menu item, or alternatively right-clicking the node and selecting the »Breakpoint on/off« context menu item. Again, you can see the little arrow, which now marks the next node to be executed, called the current node. When entering debugging mode QF‑Test also navigates to the current node, in case it had not been visible, and selects it, highlighting it blue. The menu option »Debugger«-»Clear all breakpoints« is useful to remove all breakpoints set in your test suite. There is no limit to the number of breakpoints you can set in your test suite, but note that breakpoints are not saved with the test suite.","hash":"fig_DebugRemoveBreakpointWin","h4":"Figure 23.3: Remove break point"},"588":{"id":588,"content":"Pro Tutorial","hash":"","h0":"Stepping Through a Test or Sequence | QF‑Test Tutorial"},"589":{"id":589,"content":"Pro Tutorial","hash":"home-link","h0":"Stepping Through a Test or Sequence | QF‑Test Tutorial"},"590":{"id":590,"content":"Stepping Through a Test or Sequence Now let's step through the test case we set up in the previous section. Please try out the debugger buttons Single step , Step over and Step out . You will find that Single step opens a node containing child nodes and makes the first child node the active node. Continuing from where we left the test suite at the end of the last section, i.e. in debugging mode, with 'Test case: First' being the current node, the test suite would now look like this:","hash":"tut_debug_steps_win","h0":"Stepping Through a Test or Sequence"},"591":{"id":591,"content":"Figure 23.4: Stepping into a node In the case of leaf nodes (nodes without child nodes), the effect of is the same as the following button's. Step over runs the current node including all children. Execution pauses at the next node of the same level to be executed, which then becomes the active one.","hash":"fig_StepInExampleWin","h4":"Figure 23.4: Stepping into a node"},"592":{"id":592,"content":"Figure 23.5: Stepping over a node Step out runs the remaining nodes at the same level including their child nodes. Execution pauses when a node that is higher in the hierarchical structure is found, which then becomes the active one.","hash":"fig_StepOverExampleWin","h4":"Figure 23.5: Stepping over a node"},"593":{"id":593,"content":"Figure 23.6: Stepping out of a node In the given example the node higher in the hierarchical structure where execution stops is the Cleanup node. As explained in the chapter A full Test Run this shows the special behavior of Setup / Cleanup nodes in a test set: They are executed before and after each test case to help achieving a proper starting state for each test case. You will only find this behavior when you started the whole test suite or test set and are in debugging mode. If you just selected the test case and did a step-over action then QF‑Test will execute the test case and then select the next test case node. Run the Cleanup and Setup nodes by stepping over them, using the debugger button Step over and then Step in the second test case via to get ready for the next section where you will learn about the skip functionality. Please be aware that menus or comboboxes tend to close when the application looses the focus, as will happen when activating the debugging mode. In such a case you should not stop test execution between the node opening the menu or combobox and the node performing the selection. One way to do achieve this is to set a break point after the node performing the selection and to activate normal test execution by releasing the pause button when you reach the node opening the menu or combobox.","hash":"fig_StepOutExampleWin","h4":"Figure 23.6: Stepping out of a node"},"594":{"id":594,"content":"Pro Tutorial","hash":"","h0":"Skipping Execution of Nodes | QF‑Test Tutorial"},"595":{"id":595,"content":"Pro Tutorial","hash":"home-link","h0":"Skipping Execution of Nodes | QF‑Test Tutorial"},"596":{"id":596,"content":"Skipping Execution of Nodes The \"skip\" functions expand the QF‑Test debugger's capabilities in a powerful way which is not typically possible for a debugger in a standard programming environment. In short, they allow you to jump over one or more nodes without having to execute them. This may be helpful for various reasons, e.g. to quickly navigate to a certain position in your test run or to skip a node which currently leads to an error. With the end of the last section, the test suite should have reached the following state:","hash":"tut_skip_steps_win","h0":"Skipping Execution of Nodes"},"597":{"id":597,"content":"Figure 23.7: Pause execution at first node of the second test case Now press the Skip over button. QF‑Test simply jumps over the active node without executing any child nodes. The active node now is the next node to be executed on the same level.","hash":"fig_DebugSkipOverInitialStateWin","h4":"Figure 23.7: Pause execution at first node of the second test case"},"598":{"id":598,"content":"Figure 23.8: Skip over a node At last, press the Skip out button. You see that QF‑Test skips all nodes on the same (or lower) level and directly jumps to the next node one level up in hierarchy.","hash":"fig_DebugSkipOverWin","h4":"Figure 23.8: Skip over a node"},"599":{"id":599,"content":"Figure 23.9: Skip out of a node Use \"Skip over\" and \"Skip out\" cautiously as skipping out of a sequence before it is completed can leave the SUT in an unknown state that other sequences or tests in your test suite cannot react to.","hash":"fig_DebugSkipOutWin","h4":"Figure 23.9: Skip out of a node"},"600":{"id":600,"content":"Pro Tutorial","hash":"","h0":"Error or Exception triggering Debugging Mode | QF‑Test Tutorial"},"601":{"id":601,"content":"Pro Tutorial","hash":"home-link","h0":"Error or Exception triggering Debugging Mode | QF‑Test Tutorial"},"602":{"id":602,"content":"Error or Exception triggering Debugging Mode When debugging a test you may want run it until it encounters an error, an exception or sometimes even a warning and then have it pause in debugging mode. In this section you will see how this can be done while debugging the second test case. Please open the debugger menu and change the default options as follows: Activate the »Debugger«-»Enable debugger« menu item. Also activate the »Debugger«-»Options«-»Break on error« menu item. Afterwards, when you open the debugger menu and options submenu it should look like this:","hash":"tut_debug_start_win","h0":"Error or Exception triggering Debugging Mode"},"603":{"id":603,"content":"Figure 23.10: Set debugger options to pause on error We changed the debugger options because with default settings QF‑Test will not pause on exceptions or errors, as you saw earlier on. Select the \"Test-suite\" node and start test execution via \"Start test run\" . QF‑Test will pause at the faulty node and enter debugging mode:","hash":"fig_debugger_stops_at_error_win","h4":"Figure 23.10: Set debugger options to pause on error"},"604":{"id":604,"content":"Figure 23.11: Test run stopped by error The node which halted test execution will be indicated by an arrow and its symbol will be surrounded by a red square. Also, an error dialog will inform you about the failed check. As always the run log is the key to resolving errors, so let's open it and find out how to resolve the error in the next section.","hash":"fig_debugger_stopped_by_error_win","h4":"Figure 23.11: Test run stopped by error"},"605":{"id":605,"content":"Figure 23.12: Error Dialog Click the Jump to run log button in the error dialog.","hash":"fig_debug_error_dialog_win","h4":"Figure 23.12: Error Dialog"},"606":{"id":606,"content":"Pro Tutorial","hash":"","h0":"Resolving Errors directly from the Run log | QF‑Test Tutorial"},"607":{"id":607,"content":"Pro Tutorial","hash":"home-link","h0":"Resolving Errors directly from the Run log | QF‑Test Tutorial"},"608":{"id":608,"content":"Resolving Errors directly from the Run log The Jump to run log button from the dialog in \"Error Dialog\" will not only open the run log but takes us directly to the node that holds the error details. Apart from the actual error message you will find screenshots and a copy of the variable bindings table (stack trace), which we will introduce later on (The Variable Bindings table). The error details tell you that the expected value does not match with the one shown in the application. As the one in the application is correct we want to update the expected value with the one from the application. This can easily be achieved as follows: Right-click the red-bordered node \"Failed: Check text: default ...\" indicating the actual error Select »Update check node with current data« from the context menu.","hash":"tut_ResolveRunTimeErrorWin","h0":"Resolving Errors directly from the Run log"},"609":{"id":609,"content":"Figure 23.13: Update check node with current data This locates the corresponding Check text node in the test suite and updates the expected value of the Text attribute with the value got as indicated by the run log.","hash":"fig_DebugUpdateCheckNodeWin","h4":"Figure 23.13: Update check node with current data"},"610":{"id":610,"content":"Figure 23.14: Corrected check node The previously faulty node still is highlighted with a red border since we have not run it again. Now continue execution by releasing the pause button . QF‑Test runs the rest of the test suite, i.e. the Check text and Cleanup nodes, and informs you at the end of the run that there was one error, which you have already fixed. Since the error has been fixed and we will continue using the test cases as examples you could rename the second test case and delete '(with error)' in its name as well as '(causing Error)' in the name of the test step.","hash":"fig_DebugCorrectedCheckNodeWin","h4":"Figure 23.14: Corrected check node"},"611":{"id":611,"content":"Jump into run log: You do not have to wait for an error dialog to open the run log at the current point of execution (or close by). Whenever you are in debugging mode, select the »Debugger«-»Jump to Run log« menu option, or use the Ctrl⁠+⁠J shortcut. If you just want to open the run log without jumping to the current point of execution you can use Ctrl⁠+⁠L. This will work after the test run finished, too.","hash":"tut_JumpToRunLogWin tut_JumpToRunLogWin","h4":"Figure 23.14: Corrected check node"},"612":{"id":612,"content":"Pro Tutorial","hash":"","h0":"Pause Execution | QF‑Test Tutorial"},"613":{"id":613,"content":"Pro Tutorial","hash":"home-link","h0":"Pause Execution | QF‑Test Tutorial"},"614":{"id":614,"content":"Pause Execution When a test is being executed and you want to enter debugging mode you can quickly set a breakpoint at some node not yet executed. Or you can just hit the toolbar button \"Pause\" and QF‑Test will directly enter debugging mode. In order to resume execution just release the pause button . This is completely independent of the way you entered debugging mode. Depending on how focus demanding the SUT is, it may be difficult to focus QF‑Test long enough to hit the pause button. But you can still rely on the \"Don't Panic\" shortcut Alt⁠+⁠F12. It will pause all running tests immediately. To continue, press the same combination again.","hash":"tut_pause_execution_win","h0":"Pause Execution"},"615":{"id":615,"content":"Pro Tutorial","hash":"","h0":"Variables and Procedure Parameters (Win) | QF‑Test Tutorial"},"616":{"id":616,"content":"Pro Tutorial","hash":"home-link","h0":"Variables and Procedure Parameters (Win) | QF‑Test Tutorial"},"617":{"id":617,"content":"Variables and Procedure Parameters (Win) In this chapter you are going to learn how to use a procedure to perform the same action on various input data. You will also learn about variables - how to use and how to debug them. This chapter is also available as a video tutorial at \"Variables and Procedure Parameters\". The video uses a Java application for demonstration. Variables are used in the same way with web applications.","hash":"sec_variablestackwin","h1":"Variables and Procedure Parameters (Win)"},"618":{"id":618,"content":"Pro Tutorial","hash":"","h0":"Procedure using a variable | QF‑Test Tutorial"},"619":{"id":619,"content":"Pro Tutorial","hash":"home-link","h0":"Procedure using a variable | QF‑Test Tutorial"},"620":{"id":620,"content":"Procedure using a variable Have a look at the last test step 'Check final price' of our two test cases.","hash":"sec_ProcedureWithVariableWin","h0":"Procedure using a variable"},"621":{"id":621,"content":"Figure 24.1: Two almost identical test steps They perform the same action, however, with different data. Even though it is only one node, it makes sense to pack it into a procedure. We may want to adapt the hard coded values 30,049.00 € and 26,100.00 € to a different format so that the check will also work when the format of the price field changes to a different currency. And we do not want to implement the same algorithm twice. (If you wonder about the the two dollar signs: This is what QF‑Test records for a dollar sign. For replay it does not matter whether you use one or two dollar signs.) Select the 'Check text' node in the first test case. Use »Operations«-»Pack nodes«-»Sequence« or use the Ctrl⁠+⁠Shift⁠+⁠S shortcut to pack it into a sequence. Name the sequence checkFinalPrice. The procedure name follows the Java convention to run the words together and start the single words with capital letters. On the other hand QF‑Test allows the use of spaces in procedure names, so you are free to name it as you like. Press Ctrl⁠+⁠Shift⁠+⁠P for the quickest way to transform the 'Sequence' node into a procedure, as you learned at the end of the last chapter. You see the sequence is replaced by a call to the 'checkFinalPrice' procedure. Double click the procedure call node to jump to the procedure definition. Open the procedure node to see its content.","hash":"fig_params1Win","h4":"Figure 24.1: Two almost identical test steps"},"622":{"id":622,"content":"Figure 24.2: Procedure with hard coded value As expected, the check is now located in this procedure. However, it is valid for one price only, i.e. $30,049.00. Since we want to use the same procedure for the second test case as well we need to make the price a variable and pass its value as a parameter from the test case to the procedure. In the next example we will start by defining a parameter for the procedure. Additionally, we will set a default value for the parameter. Default values are most useful when the parameter usually has that value and you do not want to specify it every time you call the procedure. Even though this does not hold true for the price it is a good example to demonstrate to you how a default parameter works and how to overwrite it with another value. Let's define the parameter and add a default value: Select the procedure 'checkFinalPrice' Press the \"Add new row\" button belonging to the table 'Parameter default values'. Enter price as name for the parameter. Enter $ 30,049.00 in the value field.","hash":"fig_procedure_hardcoded_win","h4":"Figure 24.2: Procedure with hard coded value"},"623":{"id":623,"content":"Figure 24.3: The Details of the 'Procedure' node The next step is to replace the value of the Text attribute of the Check text node by a reference to the variable.","hash":"fig_parameter_default_values_table_win","h4":"Figure 24.3: The Details of the 'Procedure' node"},"624":{"id":624,"content":"Variable syntax: When working with variables you need to bear in mind that in some places you need to tell QF‑Test the name of the variable and in others you want to refer to the value of the variable. In the Name column of the Parameter default values table of the Procedure node QF‑Test expects the name of a variable. It is price, which is why you typed the word price. In the Text attribute of the Check text node details QF‑Test expects a character string for comparison with the text of the UI element. As we want to use a value stored in a variable, we have to tell QF‑Test not to use the entered string as plain text, but to interpret it as a reference to the value stored in a variable. In QF‑Test this is done by enclosing the variable name in $(). In our case the variable reference is $(price). If you did not put the variable name into $(), QF‑Test would compare the price (a number) shown in the UI element to the string price, which is obviously nonsense. Select the Check text node in the procedure 'checkFinalPrice'. Type $(price) in the Text attribute of the Check text node details.","hash":"tut_VariableSyntaxWin","h4":"Figure 24.3: The Details of the 'Procedure' node"},"625":{"id":625,"content":"Figure 24.4: 'Check text' node Run the first test case. It should execute without an error.","hash":"fig_ProcedureAddVariableWin","h4":"Figure 24.4: 'Check text' node"},"626":{"id":626,"content":"Pro Tutorial","hash":"","h0":"The Variable Bindings table | QF‑Test Tutorial"},"627":{"id":627,"content":"Pro Tutorial","hash":"home-link","h0":"The Variable Bindings table | QF‑Test Tutorial"},"628":{"id":628,"content":"The Variable Bindings table The next step is to make use of the procedure call in the second test case as well. Replace the Check text node of the second test case by a procedure call to checkFinalPrice. You can simply copy the respective node from the first test case or add the procedure call as learned in the previous chapter.","hash":"tut_variable_stack_win","h0":"The Variable Bindings table"},"629":{"id":629,"content":"Figure 24.5: Second procedure calls 'checkFinalPrice' If you added the procedure call by a copy or drag and drop operation from the procedure itself you will find the price in the Variable definitions table of the procedure call. This is what we are eventually aiming at. However, at this stage we want to explain the default value. So, if you want to follow the tutorial exactly, please delete the default value by pressing the red X above the table. Verify QF‑Test is configured to pause at errors as shown in Set debugger options to pause on error. Select the 'Test case: Second' node. Execute it by pressing or Enter. An error message shows up indicating different values for the price expected and the price got. What went wrong? Let's go hunting. Typically we use the run log for this but there is another view worth to know of. So click OK to close the error message. In debugging mode you will find an additional bottom right section of the QF‑Test window showing a list of nodes with variables bound to those nodes. You might want to resize the variable bindings table in case it is too small to see all its content.","hash":"fig_AddProcedureCallToSecondTestcaseWin","h4":"Figure 24.5: Second procedure calls 'checkFinalPrice'"},"630":{"id":630,"content":"Figure 24.6: Variable bindings The variable bindings table is very useful for debugging. It comes in quite handy, too, when working with procedures and trying to understand the way QF‑Test figures out which variable value to use. It shows the current values of the variables. QF‑Test always checks the variable bindings table from top to bottom. You can see that the first rows of the table have no bindings at all. Then there is a binding at the level 'Globals' and another one in the fallback stack for the procedure 'checkFinalPrice'. The global variable is used for the client connection, which has been set when starting the application (cf Starting the Application). The other variable is more interesting to us - only it has the wrong value. The default value is intended to be used for the parameter if no value has been defined elsewhere. This is why we added the parameter to the 'Parameter default values' table of the procedure node. To do things correctly we need to pass the proper value when calling the procedure. Again, there are several ways to do it. One is to add a new row to the variable definitions table of the 'Call procedure' nodes similarly to the way you did at the 'Procedure' node in the last section. If the procedure is called multiple times within the test suite, there is a better way: Stop the current test execution clicking the toolbar button . Right-click the 'Procedure' node and select »Additional node operations«-»Update parameters of references« from the popup menu.","hash":"fig_VariableBindingsTable1Win","h4":"Figure 24.6: Variable bindings"},"631":{"id":631,"content":"Right-click the 'Procedure' node and select »Additional node operations«-»Update parameters of references« from the popup menu. Figure 24.7: Popup menu for 'Additional node operations' In the following dialog, please check the tick mark for »Add missing parameters to callers« is set and click OK. In the 'Call procedure' nodes QF‑Test adds a row each for every default parameter to the variable definition table of the procedure call . It also copies the default value of each default parameter. In our case it is the parameter price with the value $30,049.00. You might notice that the numerical value of the price variable is still wrong in the second case, regardless of whether it is defined implicitly as a default value or explicitly via a parameter. For now we want to keep that error to show you additional means of debugging. Close the 'Updated nodes' dialog QF‑Test opened to inform you about the updated nodes.","hash":"fig_CompleteParametersWin","h4":"Figure 24.6: Variable bindings"},"632":{"id":632,"content":"Pro Tutorial","hash":"","h0":"Advanced debugging of variable bindings | QF‑Test Tutorial"},"633":{"id":633,"content":"Pro Tutorial","hash":"home-link","h0":"Advanced debugging of variable bindings | QF‑Test Tutorial"},"634":{"id":634,"content":"Advanced debugging of variable bindings Next, we want to explore the variable bindings table and see how it can be used for debugging purposes. For this reason do not correct the faulty value of the procedure call we added in the last section, but let us find out more about debugging. In the next steps we want to have QF‑Test pause the test execution at the procedure call. Then we will step into the procedure and, while doing so, have a look at the variable bindings table. Finally, we will navigate directly from the variable bindings table to the faulty procedure call and correct the parameter value. Add a breakpoint to the 'Call procedure: checkFinalPrice' node of the second test case. Run the second test case again. When QF‑Test stops at the breakpoint step into the procedure via and watch the table of the variable bindings as you do so.","hash":"tut_variable_stack_debugging_win","h0":"Advanced debugging of variable bindings"},"635":{"id":635,"content":"Figure 24.8: Variable bindings stack showing incorrect value As you step into the procedure, first the row 'Call procedure: checkFinalPrice' and with the next step the row 'Procedure: checkFinalPrice' appear at the top of the table. Now the variable price shows on two different levels of the variable bindings table: In the 'Call procedure: checkFinalPrice' row and the 'Procedure: checkFinalPrice' row on the fallback stack. Since we did not adapt the value of the parameter passed to the procedure, neither of the two values bound to the price variable is correct. QF‑Test lets you change the values of the variables interactively in the variable bindings table when you are in debugging mode. You can even add new variables or delete them. However, changes to variable values in the variable bindings table are not persistent. They only last as long as the variable is on the stack (variable bindings table). In our case, if we changed the price value, as long as the procedure is being executed. The parameter value in the procedure call will not be altered by changing the current value of the variable in the variable bindings table. To do so you have to navigate to the Procedure call node and change it there. To get there quickly, you just double-click the procedure call in the variable binding table (second row). This feature is particularly useful when debugging more complex tests where the node you want to jump to is not directly visible in the test suite window. You can invoke it via right-clicking the row and selecting »Jump to node in test suite« from the pop-up menu, too. Double-click the second row with the procedure call in the variable bindings table. Set the value of the parameter to the correct value, i.e. $ 26,100.00. When checking the variable bindings table you will notice that the current value has not changed. This is hardly surprising as we have not yet executed the procedure call again. Only, test execution is already past the procedure call. Fortunately, QF‑Test has another very useful debugging feature to set back (or forward) test execution to some node: »Continue execution from here«, which can be invoked either via the pop-up menu of the node you want to make the current node or by pressing Ctrl⁠+⁠, after selecting the node. In order to try out the newly set value: Right-click the 'Call procedure: checkFinalPrice' node of the second procedure. Select 'Continue execution from here' in the popup menu.","hash":"fig_VariableStack3Win","h4":"Figure 24.8: Variable bindings stack showing incorrect value"},"636":{"id":636,"content":"Figure 24.9: Continue Execution from here When checking the variable bindings table you will find that the top two rows have disappeared. This is because now we exited the procedure (even though 'backwards') and therefore the procedure call and all its variable bindings was taken off the call stack. Release the pause button . The test run should finish without error. As the variable bindings table is very useful when looking for incorrect variable values you will also find a copy of it in the run log whenever an error or exception is logged. It is written to the subnode 'Stack trace' of the node causing the error, showing the variable values at the time the error occurred.","hash":"fig_ProcedureContinueExecFromHereWin","h4":"Figure 24.9: Continue Execution from here"},"637":{"id":637,"content":"Locate the current Node: Sometimes during debugging you will navigate far away from the current node where execution stopped and eventually want to get back to it again. The easiest way to do so is by pressing the \"Locate Current Node\" button or select the »Debugger«-»Locate Current Node« menu option to cause the debugger to \"select\" the current node.","hash":"locate_current_node_win","h4":"Figure 24.9: Continue Execution from here"},"638":{"id":638,"content":"Pro Tutorial","hash":"","h0":"Setting Variables | QF‑Test Tutorial"},"639":{"id":639,"content":"Pro Tutorial","hash":"home-link","h0":"Setting Variables | QF‑Test Tutorial"},"640":{"id":640,"content":"Setting Variables In addition to the methods you have already seen, variables can also be set as follows: Via the Set variable node, as the return value of a procedure, as the result value of QF‑Test nodes like the Fetch text node, the Fetch geometry node, the Fetch index node and the Check node, in the 'Variable definitions' table of the 'Test-suite' node, the 'Test case' node, the 'Test step' node, the 'Sequence' node and others like the 'If' node or 'Loop' node, via command line parameters. For information about the best place where to define a variable please refer to the next section. You can insert a Set variable node via the menu item »Insert«-»Miscellaneous«-»Set variable«. In its details you can specifiy whether the value should be bound as a local or a global variable. The following figure shows the details of a Set variable node. (You can find it as the first node of the Setup node.) It defines a variable named client. It is a global variable as the Local variable attribute has not been checked.","hash":"tut_setting_variables_win","h0":"Setting Variables"},"641":{"id":641,"content":"Figure 24.10: Details of the Set variable node When you want to set a variable as the result of a procedure call you need to specify the variable name in the 'Variable for return value' attribute of the procedure call. Within the procedure itself you have to add a Return node with the value to be returned as the last node to be executed. The next figure shows a theoretical example of a procedure which returns a value. The procedure fetches the discount value displayed in the SUT and returns it to the calling test case. There, the receiving variable is named Discount and declared as a local variable.","hash":"fig_DetailsSetVariableWin","h4":"Figure 24.10: Details of the Set variable node"},"642":{"id":642,"content":"Figure 24.11: Procedure returning a value The Fetch text node of above example is one of the QF‑Test nodes directly setting a variable value. You need to specify the variable name in the attribute called accordingly. Again, you have the choice whether to make it local or global. Quite a number of nodes have a 'Variable definitions' table where you may define variables local to a procedure or a test case. If the respective node is part of a procedure the variable will be local to the procedure. Otherwise it will be local to the respective test case. Variables bound to the test suite node can be accessed from all nodes within the test suite. In debugging mode, all nodes you can bind a variable to will show up on the variable bindings table when entered. You can enter variables in the command line via the parameter -variable. For details please refer to the manual, chapter 'Command line arguments and exit codes'.","hash":"fig_DetailsCallProcedureWin","h4":"Figure 24.11: Procedure returning a value"},"643":{"id":643,"content":"Pro Tutorial","hash":"","h0":"Variable binding levels | QF‑Test Tutorial"},"644":{"id":644,"content":"Pro Tutorial","hash":"home-link","h0":"Variable binding levels | QF‑Test Tutorial"},"645":{"id":645,"content":"Variable binding levels This section may be difficult to understand when you are a programming beginner. Then it may be better to come back to it when you started writing procedures for your own tests. In QF‑Test there are many places where you can set a variable: The test suite node, in test cases and procedures as default or local variables, as a parameter in a procedure call, as a global variable and as a command line parameter. Now the question is: Which is the correct place for defining a variable? And the answer is: It depends on the use case. Each level of the variable bindings has its own use case: Procedure parameters When you call the same procedure several times in a test case and with different values each time you should set the values via a parameter at a procedure call. This is done by adding a row to the variable definitions table of a Procedure call node specifying the respective variable name and value. Local variables in a procedure They are created in the procedure and are deleted when the execution of the procedure finishes. Use a local variable when you do not need it outside of the current procedure. In procedures they are predestined for intermediate results. Local variables in a test case Variables local to a test case are either created during execution of a test case or defined in the respective table in the details of the test case node. They will be deleted from the variable bindings table once the test case finishes. Use them for values you want to refer to in several nodes of a test case and you do not need outside of it. Global variables Global variables are created at some point of the test execution and exist until they are explicitly deleted or QF‑Test is stopped. They survive stops and restarts of test execution. Use them for values that need to be accessible by all test cases. A typical example is the variable client created in the 'Setup' node when starting the application. To get rid of them you need to either exit QF‑Test or select the menu item »Run«-»Clear global variables«. Command line parameters In batch mode you may want to run test with various parameters. They are valid throughout the batch run. A typical example would be the browser to be used. Test-suite variables test suite variables can be referred to by all test cases. Their usage is the same as that of global variables. Only that they can be overridden at batch execution by command line parameters, whereas global variables cannot. Default values (Fallback stack) You can define default values for variables of procedures, test cases and test sets. In case you do not define a variable of the same name on a higher level QF‑Test will use the default value set.","hash":"tut_variable_levels_win","h0":"Variable binding levels"},"646":{"id":646,"content":"Pro Tutorial","hash":"","h0":"The Standard Library (Win) | QF‑Test Tutorial"},"647":{"id":647,"content":"Pro Tutorial","hash":"home-link","h0":"The Standard Library (Win) | QF‑Test Tutorial"},"648":{"id":648,"content":"The Standard Library (Win) This chapter is also available as a video tutorial at \"The Standard Library\". QF‑Test provides a certain number of node types. If you need additional functionality you can implement it in a script node. To make life easier for you QF‑Test comes with a set of procedures implementing the most commonly needed additional functions. You will find them in the standard procedures library. When you cannot solve a problem using the provided node types it is a good idea to have a look in the standard library whether there is a solution to your problem. If you find a similar solution you can copy the procedure and adapt it to your needs. For information about scripting please refer the the manual, chapter 12 'Scripting'. The file qfs.qft holds the standard procedures library. As it is constantly being enhanced and distributed with every new version of QF‑Test you should not make any changes to procedures in that file, but copy the procedure to your own test suite if required and then adapt it. To make use of qfs.qft it needs to be included in your test suite's root node. With a newly created test suite the file qfs.qft is added automatically to the list of included files. Select the 'Test-suite' root node of your test suite. Verify the qfs.qft is available within the table for \"Include files\". Add qfs.qft to this list, if it's not already there. Path information is not necessary for qfs.qft as the include directory of QF‑Test is contained in the library path (see also Reference part of the manual). Add a procedure call to an arbitrary procedure from the qfs.qft standard library. In the procedure chooser don't miss to switch to the respective tab. In addition to the description provided in this tutorial you can find the full HTML documentation of the standard library available via »Help«-»Standard Library qfs.qft...«","hash":"sec_StandardLibraryWin","h1":"The Standard Library (Win)"},"649":{"id":649,"content":"Pro Tutorial","hash":"","h0":"Inspecting the Standard Library | QF‑Test Tutorial"},"650":{"id":650,"content":"Pro Tutorial","hash":"home-link","h0":"Inspecting the Standard Library | QF‑Test Tutorial"},"651":{"id":651,"content":"Inspecting the Standard Library In addition to inserting procedure calls from the Standard Library, it also can be helpful to sometimes have a look how certain things have been implemented. Locate and load the test suite file qfs.qft, which is located in the qftest-10.0.2-pro/include directory of your QF‑Test installation.","hash":"sec_StandardLibraryOverviewWin","h0":"Inspecting the Standard Library"},"652":{"id":652,"content":"Figure 25.1: The Standard Library You can see there is one main package qfs that contains further specific packages. The qfs package helps to easily identify the packages belonging to the standard library. The specific packages cover very different areas of utility procedures described in more detail further below. Within nearly all of the procedures of this library, you'll notice that the variable $(client) is referenced. This is the standard mechanism for creating independence from a specific SUT. Here, the library assumes that the test suite which uses the library will set a value for $(client) prior to using any procedures.","hash":"fig_SuiteQfsQftWin","h4":"Figure 25.1: The Standard Library"},"653":{"id":653,"content":"Pro Tutorial","hash":"","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"654":{"id":654,"content":"Pro Tutorial","hash":"home-link","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"655":{"id":655,"content":"Selected Packages and Procedures We will now have a closer look at a number of selected packages and procedures from the standard library.","hash":"sec_StandardLibraryPackagesWin","h0":"Selected Packages and Procedures"},"656":{"id":656,"content":"The Run log Package The qfs.run-log package contains procedures, which writes specified messages into the run log. This package has been introduced to give testers without scripting-knowledge the opportunity to write messages into the run log. Here is the list of the most important procedures within this package: logError Write a given error message into the run log. logWarning Write a given warning message into the run log. logMessage Write a given message into the run log.","hash":"sec_win_run_log_package","h1":"The Run log Package"},"657":{"id":657,"content":"The Run log.Screenshots Package The qfs.run-log.screenshots package contains procedures, which write images into the run log and some helper methods. Some important procedures within this package are: getMonitorCount Return the total number of monitors. logScreenshot Write a screenshot of the whole screen into the run log. logImageOfComponent Write an image of a given component into the run log. logScreenshotOfMonitor Write a screenshot of a given monitor into the run log.","hash":"sec_win_run_log_screenshots_package","h1":"The Run log.Screenshots Package"},"658":{"id":658,"content":"The Shellutils Package The qfs.shellutils package contains procedures to support most common shell-commands. Some important procedures within this package are: copy Copy a given file or directory to a specified target. deleteFile Delete a given file. exists Check for existence of a given file or directory. getBasename Return only the file name of a full file name. getParentdirectory Return only the directory name of the full file name. mkdir Create a given directory. It also creates non-existing directories in path. move Move a file of directory. touch Create a specified file. removeDirectory Remove a specified directory.","hash":"sec_win_shellutils_package","h1":"The Shellutils Package"},"659":{"id":659,"content":"The Utils Package The qfs.utils package contains procedures, which covers common helper-functionality during test-development. Some important procedures within this package are: getDate Return a string containing the date. Default is the current date. (Other dates can be configured.) getTime Return a string containing the time. Default is the current time. (Other timestamps can be configured.) logMemory Log current memory use. printVariable Print the content of a given variable to the console. printMessage Print a given message to the console. writeMessageIntoFile Write a given string into a given file.","hash":"sec_win_utils_package","h1":"The Utils Package"},"660":{"id":660,"content":"The Database Package The qfs.database package contains procedures to execute SQL commands on a database. Please note that the database driver must be in the class path, i.e. the respective jar file in the qftest plugin directory, before launching QF‑Test. To get more information about the connection-mechanism to your database, please ask your developers or see www.connectionstrings.com. Some important procedures within this package are: executeSelectStatement Execute a given SQL-Select-Statement. It stores the result in a global variable \"resultRows\" on the Jython variable stack and thus accessible from Jython scripts. Additionally, it stores the result in a group variable with the default name 'resultGroup', which can be accessed directy by QF‑Test nodes. executeStatement Execute a given SQL-command. Here any SQL command can be specified.","hash":"sec_win_database_package","h1":"The Database Package"},"661":{"id":661,"content":"The Check Package The qfs.check package contains procedures to do checks. Some important procedures within this package are: checkEnabledStatus Check, whether a component is enabled or disabled. It writes an error into the run log, if failing. checkSelectedStatus Check, whether a component is selected or not. It writes an error into the run log, if failing. checkText Check the text of a component. It writes an error into the run log, if failing.","hash":"sec_win_check_package","h1":"The Check Package"},"662":{"id":662,"content":"The Databinder Package The qfs.databinder package contains procedures for execution within a \"Data driver\" node which bind data for iteration. Some important procedures within this package are: bindList Create and register a databinder that binds a list of values to a variable. Variables are separated by whitespace or by a given separator character. bindSets Create and register a databinder that binds a list of value-sets to a set of variables. Value-sets are separated by line breaks. Variables within a value-set are separated by whitespace or by a given separator character.","hash":"sec_win_databinder_package","h1":"The Databinder Package"},"663":{"id":663,"content":"Pro Tutorial","hash":"","h0":"Control structures (Win) | QF‑Test Tutorial"},"664":{"id":664,"content":"Pro Tutorial","hash":"home-link","h0":"Control structures (Win) | QF‑Test Tutorial"},"665":{"id":665,"content":"Control structures (Win) The two most important control structures of QF‑Test are loops and the conditional execution of nodes. Loops can be implemented by two different kinds of nodes: While and Loop nodes. If, Elseif and Else nodes are available to implement conditional execution. This chapter is also available as a video tutorial at \"Control Structures\".","hash":"sec_controlstructureswin","h1":"Control structures (Win)"},"666":{"id":666,"content":"Pro Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"667":{"id":667,"content":"Pro Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"668":{"id":668,"content":"If - else You already came across If nodes in the Setup sequence in the chapter Starting the Application. Let's have a closer look at the details of the node.","hash":"sec_ifwin","h0":"If - else"},"669":{"id":669,"content":"Figure 26.1: Setup Sequence with if-else structures By means of an If node you can control whether certain nodes will be executed or not. In our case whether to start the SUT application. First, we need to find out if the client is already running. This is the job of the Wait for client to connect node, which writes the result of its inquiry, either true or false, into a variable named isSUTRunning.","hash":"fig_ControlsSetupSequenceWin","h4":"Figure 26.1: Setup Sequence with if-else structures"},"670":{"id":670,"content":"Figure 26.2: Wait for client to connect writes the result into the variable \"isSUTRunning\" The If node has a Condition attribute where you'll find an expression evaluating the result variable isSUTRunning. As we want to refer to its value we need to use the syntax $() (see also note on variable syntax in chapter \"Procedure using a variable\").","hash":"fig_ControlsWaitForClientWin","h4":"Figure 26.2: Wait for client to connect writes the result into the variable \"isSUTRunning\""},"671":{"id":671,"content":"Figure 26.3: If node evaluates the variable Depending on whether the client is already running or not QF‑Test will execute the nodes nested in the If node. Stop the client in case it is running. Single-step through the Setup node. Leave the client running and single-step through the Setup node a second time. If you like you can check the value of the variable isSUTRunning in the variable bindings table. The first time it will have the value false so that the condition not $(isSUTRunning) will become true and the SUT will be started. The second time it will be true and the if-condition will fail. The nodes nested in the If node will be skipped. Within the first node of the setup sequence you will find more If nodes. They are used to set global variables determining which win browser to use, depending on the operating system. For better readability only If nodes have been used. You may just as well use Elseif and Else to implement that functionality. The child nodes of an Elseif node would be executed if the If condition were false and the Elseif condition were true. The child nodes of an an Else node would be executed if the If condition and all Elseif conditions were false. For checking the operating system you can directly resort to a QF‑Test variable: QF‑Test stores the information about the operation system in a group variable where the group is called 'qftest' and the variables 'linux', 'macos' or 'windows', respectively. The syntax for accessing group variables is ${group:varname}, e.g. ${qftest:windows}.","hash":"fig_ControlsIfWin","h4":"Figure 26.3: If node evaluates the variable"},"672":{"id":672,"content":"Pro Tutorial","hash":"","h0":"Loops | QF‑Test Tutorial"},"673":{"id":673,"content":"Pro Tutorial","hash":"home-link","h0":"Loops | QF‑Test Tutorial"},"674":{"id":674,"content":"Loops QF‑Test provides two different kinds of nodes loops: Loop nodes execute their child nodes for a certain number of times. However, you can leave the loop any time using a Break node. While nodes execute their child nodes until a certain condition becomes false. Again, you can leave it any time using a Break node. Loop nodes will always stop after the given number of times. In the case of While nodes, however, you need to make sure that the condition will become false at some point. Otherwise you would have an infinite loop. In interactive mode you can always stop execution by hitting the pause button . In batch mode you would have to kill the QF‑Test process. (You start QF‑Test in batch mode using the command line parameter -batch. Then QF‑Test does not start its UI and just executes the given test suite.) In the following exercise we want to implement a test case checking whether a certain row is displayed in the table of the CarConfig application. The actions of the test case will be: Determine the number of rows the table has. Loop over all rows and check if it is the row we are looking for. Break the loop when a match was found. Write an error to the run log if the row was not found. Please start with recording a check on the row of interest: Activate the check recording mode by clicking the toolbar button Right-click a row in the CarConfig application and select the menu item »Row« from the popup menu. Stop the recording by pressing . Change the name of the recorded sequence to e.g. 'Check row' Turn the recorded sequence into a test case by right-clicking it and selecting the submenu item »Transform node into«-»Test case« from the popup menu.","hash":"sec_loopswin","h0":"Loops"},"675":{"id":675,"content":"Figure 26.4: Transform a node into another one In general, QF‑Test lets you add nodes very efficiently by packing one node into another one: Open the test case node and pack the recorded Check node into a loop by right-clicking it and selecting the submenu item »Pack nodes«-»Loop« from the popup menu.","hash":"fig_ControlsTransformNodeIntoWin","h4":"Figure 26.4: Transform a node into another one"},"676":{"id":676,"content":"Figure 26.5: Pack a node into another one QF‑Test evaluates dynamically which nodes may be packed into one another and only presents the appropriate ones. So, in case you do not find the 'Loop' submenu item make sure you have right-clicked the correct node. The same holds true for the 'Transform node into' and 'Insert node' methods. In the next series of actions we want to set the value for the Number of iterations attribute of the Loop node. In order to do so we need to find out how many rows the table has. There is no simple node that you could use. However, in the last chapter we learned that the standard library provides a lot of extended functionality. So let's insert the procedure getRowCount from the package qfs.win.table in the standard library. Select the Test case node and press Ctrl⁠+⁠A Press the 'Select procedure' button left to 'Procedure name'. Click the tab 'qfs.qft' in the 'Select procedure' dialog. Navigate to 'getRowCount' in the package 'qfs.win.table' Click 'OK' to select it. Adding a procedure via Ctrl⁠+⁠A was described in Manual creation of procedures. If you would like to check with the screenshots please have a look there. Enter the variable name rows in the Variable for return value attribute. Change the default value for the id in the variable definitions table to the QF‑Test component ID of the table, i.e. VehicleTable. Select the Loop node. Enter a reference to the variable $(rows) in the Number of iterations attribute of the Loop node. Enter the name of an iteration counter, e.g. i in the respective attribute of the Loop node.","hash":"fig_ControlsPackNodeIntoWin","h4":"Figure 26.5: Pack a node into another one"},"677":{"id":677,"content":"Figure 26.6: Details of a Loop node In the next series of actions we will change the recorded row index to the iteration counter and add a variable for the result to the details of the Check node. Then we will add an If node after the Check node evaluating the result, with a Break node within to quit the loop when the row was found. Open the Loop node. Select the Check node. Change the recorded row index of the QF‑Test component ID to the iteration counter $(i). The QF‑Test component ID should now read VehicleTable@Model&$(i) Enter the variable name checkSucceeded in the 'Variable for result' attribute. Right-click the Check node and the submenu item »Insert node «-»Control structures«-»Break« from the popup menu. Pack the Break node into an If node by pressing Ctrl⁠+⁠Shift⁠+⁠I (Of course you can also pack it via the menu). Type $(checkSucceeded) in the 'Condition' attribute of the 'If' node. The variable checkSucceeded will be set to either true or false by the Check node so that the reference to the variable $(checkSucceeded) is all we need to enter in the 'Condition' attribute of the If node. In the next series of actions let's add an Else node as the last node in the Loop node. It will only be entered if all repetitions of the loop were executed, which in our case means that the row was not found and the check never became true. Collapse the If node if it is open. This is important because otherwise the Else node would belong to the If node and not to the Loop node. Right-click the If node and select the submenu item »Insert node «-»Control structures«-»Else«. Open the Else node. From the standard library insert the procedure logError contained in the package qfs.run-log as described above. Type Row not found in the value field of message in the Variable definitions table. Change the value of withScreenshots in the Variable definitions table from false to true. When you run tests in batch mode screenshots are a great help for analyzing errors. On the other hand a great number of screenshots lead to a big log-file. This is why the default value for withScreenshots is false. Last, let's complete the test case with Setup and Cleanup nodes and move it into the top part of the test suite. Copy the Setup and Cleanup nodes of 'Test set: Simple Tests' into the new test case as the first and last node. Move the test case from the Extras section into the top section of the test suite after the 'Test set: Simple Tests' node. This is what the new test case would look like:","hash":"fig_ControlsLoopDetailsWin","h4":"Figure 26.6: Details of a Loop node"},"678":{"id":678,"content":"Figure 26.7: The new test case Execute the new test case. It should run without error. Then modify a value in the details of the Check items node, e.g. change the name of the car to Wrong value.","hash":"fig_ControlsTestcaseWin","h4":"Figure 26.7: The new test case"},"679":{"id":679,"content":"Figure 26.8: Details of the Check items node Execute the new test case again. This time the Else node should be entered and you should get an error message.","hash":"fig_ControlsCheckDetailsWin","h4":"Figure 26.8: Details of the Check items node"},"680":{"id":680,"content":"Pro Tutorial","hash":"","h0":"It's time to start your own Application (Win) | QF‑Test Tutorial"},"681":{"id":681,"content":"Pro Tutorial","hash":"home-link","h0":"It's time to start your own Application (Win) | QF‑Test Tutorial"},"682":{"id":682,"content":"It's time to start your own Application (Win) After having spent a lot of time with all those example programs, you are now ready to start on your own application (if you really haven't already done so). This chapter is also available as a video tutorial at \"It's time to start your own Application\". The Quickstart Wizard available via the menu »Extras«-»Quickstart Wizard...« helps you to achieve this. Simply follow the wizard steps to generate the setup sequence. Please refer also to chapter 3 \"Quickstart\" in the user manual. Then go ahead with what you have learned in this tutorial - record small sequences of events and checks, turn them into procedures which go into your test library, then set up the test cases using procedure calls. Finally, we reached the end of the basic tutorial part.","hash":"sec_ownappwin","h0":"It's time to start your own Application (Win)"},"683":{"id":683,"content":"Pro Tutorial","hash":"","h0":"Mobile Apps testing with QF‑Test | QF‑Test Tutorial"},"684":{"id":684,"content":"Pro Tutorial","hash":"home-link","h0":"Mobile Apps testing with QF‑Test | QF‑Test Tutorial"},"685":{"id":685,"content":"Mobile Apps testing with QF‑Test This part of the tutorial explains the basic features and workflows of QF‑Test for testing mobile applications. The contents presented in this tutorial refer to an Android application. The fundamentals, however, are identical for iOS. A test environment as described in the manual is required. Details about the required test environment can be found in the manual chapters Android and iOS applications. Please make sure to read them! In \"Advanced features of QF‑Test\" more advanced QF‑Test features are explained, applicable for all supported UI technologies.","hash":"sec_mobile","h1":"Mobile Apps testing with QF‑Test"},"686":{"id":686,"content":"Pro Tutorial","hash":"","h0":"Working with a Sample Test suite (Mobile) | QF‑Test Tutorial"},"687":{"id":687,"content":"Pro Tutorial","hash":"home-link","h0":"Working with a Sample Test suite (Mobile) | QF‑Test Tutorial"},"688":{"id":688,"content":"Working with a Sample Test suite (Mobile) In this first chapter, we will have a look at the structure of a simple test suite, explain its major elements, execute it and evaluate the result.","hash":"sec_androiddemo","h1":"Working with a Sample Test suite (Mobile)"},"689":{"id":689,"content":"Pro Tutorial","hash":"","h0":"Loading the Test suite | QF‑Test Tutorial"},"690":{"id":690,"content":"Pro Tutorial","hash":"home-link","h0":"Loading the Test suite | QF‑Test Tutorial"},"691":{"id":691,"content":"Loading the Test suite On first startup of QF‑Test and/or the System Under Test (SUT) via QF‑Test you might get a security warning from the firewall asking whether to block the Java network communication. As QF‑Test communicates with the SUT by means of the Java network protocols, this must not be blocked by the local firewall in order to allow automated testing. After starting up QF‑Test, you can immediately bring up our first example test suite: Press the toolbar button to bring up the file open dialog. Navigate to the subdirectory qftest-10.0.2-pro/doc/tutorial of your QF‑Test installation. There select the file FirstAndroidTests.qft and open it. If you want to use the tutorial for iOS, please select FirstIOSTests.qft. QF‑Test will then load the indicated test suite which should look as follows:","hash":"tut_loadsuiteandroid","h0":"Loading the Test suite"},"692":{"id":692,"content":"Figure 28.1: The first test suite The left part of the main window contains the test suite, organized in a tree structure. The right side shows the details of the currently selected tree node. At bottom right you'll see the terminal displaying messages sent by QF‑Test and the application you are testing. In the tree structure of the main window you can navigate and select individual nodes of the test suite. Double click the node Test set: Simple Tests to expand it and reveal its child nodes. The test set contains two test case nodes enclosed by a Setup/Cleanup pair, which mainly starts and stops the test application.","hash":"fig_firstTestSuiteAndroid","h4":"Figure 28.1: The first test suite"},"693":{"id":693,"content":"Figure 28.2: The contents of the \"Test set: Simple Tests\" node In the following sections we'll describe the purpose and function of the individual nodes.","hash":"fig_firstTestSetAndroid","h4":"Figure 28.2: The contents of the \"Test set: Simple Tests\" node"},"694":{"id":694,"content":"Pro Tutorial","hash":"","h0":"Starting and Connecting the Device | QF‑Test Tutorial"},"695":{"id":695,"content":"Pro Tutorial","hash":"home-link","h0":"Starting and Connecting the Device | QF‑Test Tutorial"},"696":{"id":696,"content":"Starting and Connecting the Device The Android application can either be tested on a real Android device or an emulator, an iOS application of a real iOS device or a simulator. Subsequently, the term \"device\" refers to any of the options. Our first step is to examine the Setup node more closely: Expand the Setup: Start device and connect node, as shown below.","hash":"tut_startsutandroid","h0":"Starting and Connecting the Device"},"697":{"id":697,"content":"Figure 28.3: The Setup node You will see two child nodes: Set variable – set the variable client to the connection name for the SUT, which will be needed for every action replayed to the application. Start device and connect – starts the corresponding Emulator (Android) or Simulator (iOS), or connects to a real device if a connection is not yet established, and opens the CarConfigurator app.","hash":"fig_firstSetupAndroid","h4":"Figure 28.3: The Setup node"},"698":{"id":698,"content":"Figure 28.4: The sequence to start the mobile device In Start device and connect, the first entry is a Wait for client node to check whether the client is already running. Only if not, it will be started. Starting the device is done in two steps: First, the Connect to Android device node tries to connect to to a real Android device or a running emulator. In case it fails QF‑Test jumps to the Catch node where the Start Android emulator node starts the emulator if the given device is an emulator. Note: For iOS, the node Connect to iOS device is used to connect to a real device as well as to a simulator. Wait for mobile device – finalizes the connection to the Android device and for both technologies waits for the connection to be up and running. These two steps are created automatically when using the Quickstart Wizard, which is explained in the next tutorial chapter (\"Starting the Application\"). Let's start the application: If you want to use a real device or a specific emulator, start it manually first. For performance reasons we recommend starting the emulator manually, so it is not linked to the QF‑Test client process and does not need to be restarted every time. Alternatively, you can set the emulator name via the Test suite node variable definition deviceName. You can see the devices available via the menu »Extras«»Known Android devices…«. If the variable deviceName is not set, QF‑Test first looks for an Android device already running. If none is running, an available one will be started. Select the node Setup: Start device and connect, keeping it expanded. Click the Start test run toolbar button. This executes the currently selected node. During execution QF‑Test marks the active step by use of an arrow pointer ->. After the setup sequence is completed, the demo app \"CarConfigurator\" should appear on the Android device.","hash":"fig_firstStartAndroid","h4":"Figure 28.4: The sequence to start the mobile device"},"699":{"id":699,"content":"Figure 28.5: The CarConfigurator Android demo","hash":"fig_androidDemoApp","h4":"Figure 28.5: The CarConfigurator Android demo"},"700":{"id":700,"content":"Pro Tutorial","hash":"","h0":"First test case | QF‑Test Tutorial"},"701":{"id":701,"content":"Pro Tutorial","hash":"home-link","h0":"First test case | QF‑Test Tutorial"},"702":{"id":702,"content":"First test case Next we will have a look at the first test case. It consists of four test steps:","hash":"tut_firsttestandroid","h0":"First test case"},"703":{"id":703,"content":"Figure 28.6: The \"First\" Test case node Reset – performs a reset via the »File« menu and selects the Vehicles tab. Select Model Rolo – selects the first vehicle model \"Rolo\" from the list. Select Special Model Jazz – switches to the Specials tab and selects \"Jazz\". Check Final Price – checks that the calculated value of the \"Final Price\" field equals a given value. Test steps are used to group nodes and to document what is being done. This proves very useful when it comes to error analysis or test adaptations later on. Expand the four test step nodes.","hash":"fig_firstTestCaseAndroid","h4":"Figure 28.6: The \"First\" Test case node"},"704":{"id":704,"content":"Figure 28.7: Details of the first test case You can see Mouse clicks and Checks, which have been grouped in test step nodes for better readability of the test case. The action nodes display the action type (Mouse click, Check, ...) and the component targeted, i.e. where the action goes to. When writing a test you can use the QF‑Test recording function to create them. Recording will be explained in the next Creating your own test suite (Mobile). Let's execute the first test case: Select the node Test case: First. Click the replay button . The test steps will then be replayed. The test result is indicated during and after the test run in the status bar at the bottom right of the QF‑Test main window and should read 'Finished: No errors'. Next to it, there are counters for the numbers and results of the test cases executed. In our case, it was just one, error-free, which means a success rate of 100%.","hash":"fig_firstTestCaseDetailsAndroid","h4":"Figure 28.7: Details of the first test case"},"705":{"id":705,"content":"Figure 28.8: The result view in the status bar Each counter icon has a descriptive tool tip. A list of all counters can be found in the chapter Capture and replay of the manual.","hash":"fig_resultOneTestCaseNoErrorAndroid","h4":"Figure 28.8: The result view in the status bar"},"706":{"id":706,"content":"Pro Tutorial","hash":"","h0":"Second Test case - with Error | QF‑Test Tutorial"},"707":{"id":707,"content":"Pro Tutorial","hash":"home-link","h0":"Second Test case - with Error | QF‑Test Tutorial"},"708":{"id":708,"content":"Second Test case - with Error The second test case will show us what will happen when an error occurs during test execution. Expand the node Test case: Second (with Error).","hash":"tut_secondtestandroid","h0":"Second Test case - with Error"},"709":{"id":709,"content":"Figure 28.9: The \"Second\" Test case node Except for the third test step it is identical to the first test case. So what does the unknown step do? Test step: Grant 5% discount – presses the 5% discount button.","hash":"fig_secondTestCaseAndroid","h4":"Figure 28.9: The \"Second\" Test case node"},"710":{"id":710,"content":"Figure 28.10: Details of the second test case Let's execute the second test case: Select the node Test case: Second (with Error). Click the replay button . This time a dialog shows up telling us that an error occurred.","hash":"fig_secondTestCaseDetailsAndroid","h4":"Figure 28.10: Details of the second test case"},"711":{"id":711,"content":"Figure 28.11: Error in the second test case What happened? To find out we'll open the QF‑Test run log for error analysis. An alternative approach for error analysis would be to execute the test case again using the debugger. This will be explained in chapter Using the Debugger (Mobile).","hash":"fig_textTestErrorAndroid","h4":"Figure 28.11: Error in the second test case"},"712":{"id":712,"content":"Pro Tutorial","hash":"","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"713":{"id":713,"content":"Pro Tutorial","hash":"home-link","h0":"The Run log for Error Diagnosis | QF‑Test Tutorial"},"714":{"id":714,"content":"The Run log for Error Diagnosis QF‑Test logs detailed information for every test execution. Please open the latest run log by one of the following options: either by pressing the Show run log button of the error dialog or in case you have already closed the dialog by pressing toolbar button or by pressing Ctrl⁠+⁠L. The most recent run logs are also listed at the bottom of the Run menu of the main window. The run log comes up in a separate window displaying the logged actions of the test case you've just executed:","hash":"tut_firstRunlogAndroid","h0":"The Run log for Error Diagnosis"},"715":{"id":715,"content":"Figure 28.12: Run log of the second test case The run log reflects the tree structure of the test suite view you are already familiar with. When you click on one of the nodes on the left side, the properties of the event including time stamp and duration will be displayed on the right. In the tree on the left you will notice nodes surrounded by a red border. These indicate that a problem occurred in a child node. If you keep expanding the red nodes, you'll eventually come to the actual error node. Please use an easier way to find the error source by pressing the Find next error toolbar button or the [Ctrl-N] key shortcut. All nodes with red highlighting have been expanded and the actual error node has been selected:","hash":"fig_firstErrorRunlogAndroid","h4":"Figure 28.12: Run log of the second test case"},"716":{"id":716,"content":"Figure 28.13: Error diagnosis for the second test case The error message on the right says that the expected value of the final price field differs from the actual one. Of course this error is there by intention as the second test case is supposed to show us how to analyze an error. Another helper for error analysis is the Screenshot node of the SUT taken at the time when the error occurred. Its details view contains a full screenshot of the screen at the time of the error, which is often useful for determining the cause of the error. The following image shows such a screenshot node:","hash":"fig_firstErrorRunlogDetailsAndroid","h4":"Figure 28.13: Error diagnosis for the second test case"},"717":{"id":717,"content":"Figure 28.14: Screenshot node showing the error situation In addition to screenshots of all monitors, QF‑Test also saves images of the client windows at the time of the error. This allows you to analyze their contents even if they are covered by other dialogs or windows. The information gathered in a long test run accumulates and can eat up enormous amounts of memory. This is the reason why QF‑Test is configured by default to create a compact run log, keeping only the relevant information for report generation and error diagnosis. This functionality can be configured via the option \"Create compact run log\" within »Edit«-»Options«-»Run logs«-»Content«. The root node of the run log tells you whether it is a compact or detailed run log. You can also configure the number of screenshots to be saved.","hash":"fig_firstErrorRunlogScreenshotAndroid","h4":"Figure 28.14: Screenshot node showing the error situation"},"718":{"id":718,"content":"Pro Tutorial","hash":"","h0":"Getting Help | QF‑Test Tutorial"},"719":{"id":719,"content":"Pro Tutorial","hash":"home-link","h0":"Getting Help | QF‑Test Tutorial"},"720":{"id":720,"content":"Getting Help We take a short break in this section to give you a few tips that might prove helpful as you continue with the tutorial. There are different places where you can look for help or information: The most comprehensive search can be achieved via »Help«-»Online search...«. This navigates you to the search functionality on our homepage and allows querying throughout all available documentation (manual, tutorial, standard library, blog and our videos). Search results can be filtered as needed. In case you work offline and want to search for a certain topic, the offline versions of the manual or tutorial available via the »Help« menu can be used. QF‑Test also offers a context sensitive help for tree node types and their details. To use it, simply press the right mouse button on an arbitrary tree node or attribute in the details pane. From the context menu select »What's this?«. This will directly bring you to the reference explanation of this item in the manual. Beside getting help from the documentation you also have the option to contact our support team. During your evaluation phase or after that as customer with a valid maintenance contract you may issue your questions directly to our support experts using the QF‑Test help menu entry »Contact the support team« or via our website.","hash":"tut_firsthelpandroid","h0":"Getting Help"},"721":{"id":721,"content":"Pro Tutorial","hash":"","h0":"Stopping the Application | QF‑Test Tutorial"},"722":{"id":722,"content":"Pro Tutorial","hash":"home-link","h0":"Stopping the Application | QF‑Test Tutorial"},"723":{"id":723,"content":"Stopping the Application We haven't inspected the cleanup sequence yet, so let's have a look at it now: Expand the Cleanup: Stop demo node.","hash":"tut_firstcleanupandroid","h0":"Stopping the Application"},"724":{"id":724,"content":"Figure 28.15: The Cleanup sequence The Cleanup sequence stops the client process in a hard way and waits until it fully terminates. This is a very simple approach and shall suffice for the moment. If the emulator/simulator was started by QF‑Test, it will also be stopped when the client process is terminated.","hash":"fig_firstCleanupAndroid","h4":"Figure 28.15: The Cleanup sequence"},"725":{"id":725,"content":"Pro Tutorial","hash":"","h0":"A full Test Run | QF‑Test Tutorial"},"726":{"id":726,"content":"Pro Tutorial","hash":"home-link","h0":"A full Test Run | QF‑Test Tutorial"},"727":{"id":727,"content":"A full Test Run After we have worked through the test set step by step, let's execute everything in one go. Select the Test set \"Simple Tests\". Execute it with the replay button . The test run ends with the well-known error. Now please open the run log via to see how QF‑Test executed the test.","hash":"tut_firstFullRunAndroid","h0":"A full Test Run"},"728":{"id":728,"content":"Figure 28.16: The run log of the complete test set You can see that the Setup and Cleanup nodes are executed before and after each test case. This is a special behavior of Setup/Cleanup nodes within a test set and helps achieving a proper starting state for each test case. Stopping the SUT after each test case is not the smartest way to ensure a clean state. More elegant ways to establish a defined test starting situation and to perform cleanup will be explained in the advanced features chapter of this tutorial (\"Dependencies: Automatically ensuring correct prerequisites for each Test case\").","hash":"fig_androidRunlogFull","h4":"Figure 28.16: The run log of the complete test set"},"729":{"id":729,"content":"Pro Tutorial","hash":"","h0":"Report Generation | QF‑Test Tutorial"},"730":{"id":730,"content":"Pro Tutorial","hash":"home-link","h0":"Report Generation | QF‑Test Tutorial"},"731":{"id":731,"content":"Report Generation In the world of quality assurance documenting test results is important. To this end, QF‑Test offers an automated report-generation feature. Since you've just done a test run, we're at a good point to show you this feature. Please open the run log and select »File«-»Create report...«.","hash":"tut_firstreportandroid","h0":"Report Generation"},"732":{"id":732,"content":"Figure 28.17: Report Generation properties In the first field, you can specify the file name of the report. Following this, you can decide what type of report you want. QF‑Test offers three kinds of reports, HTML, XML and JUnit format. An XML report is useful if you want to process the data further, e.g., if you have written your own XSLT stylesheets to shape the report. JUnit reports prove useful when you need to import results into build or test management tools. Let's generate an HTML report from the results of the last test run. Just leave the report options unchanged. Start generation by pressing the OK button. The report will then be generated and presented to you in a browser window:","hash":"fig_AndroidReportDialog","h4":"Figure 28.17: Report Generation properties"},"733":{"id":733,"content":"Figure 28.18: An HTML Report The report begins with a summary containing informational data from your system on the top left side, a legend describing the meaning of icons used in the report on the top right side, an overview pie chart in the middle and the overall test result below. In our case, one error-free test case and the second with the well-known error, leading to a success rate of 50%. Following the summary there are three overview sections: Test suites that have been executed within the test run. Test suites in which errors occurred. Errors including their exact position and detailed message. The report generator is very useful for creating an overview document for presentation and archiving purposes.","hash":"fig_androidReportHtml","h4":"Figure 28.18: An HTML Report"},"734":{"id":734,"content":"Pro Tutorial","hash":"","h0":"Creating your own test suite (Mobile) | QF‑Test Tutorial"},"735":{"id":735,"content":"Pro Tutorial","hash":"home-link","h0":"Creating your own test suite (Mobile) | QF‑Test Tutorial"},"736":{"id":736,"content":"Creating your own test suite (Mobile) In this chapter of the mobile tutorial we will create sequences to start and stop the SUT, record actions and checks, and build a simple test case from them.","hash":"sec_mobiletestsuite","h1":"Creating your own test suite (Mobile)"},"737":{"id":737,"content":"Pro Tutorial","hash":"","h0":"Starting the Application | QF‑Test Tutorial"},"738":{"id":738,"content":"Pro Tutorial","hash":"home-link","h0":"Starting the Application | QF‑Test Tutorial"},"739":{"id":739,"content":"Starting the Application To begin, the application under test should be started from within QF‑Test. The Quickstart Wizard helps generate a suitable start sequence. Please open a new, empty test suite via »File«-»New test suite...«. Open the Quickstart Wizard via the menu »Extras«-»Quickstart Wizard...« .","hash":"tut_quickStartMobile","h0":"Starting the Application"},"740":{"id":740,"content":"Figure 29.1: Selecting the SUT type In the first step choose whether it is an Android application or an iOS application. Select Android application or iOS application. Press Next. If you select iOS application, follow the specific steps to select the device and the app to test. You can find the Carconfig app (CarConfig-iOS-Simulator.zip) under ../qftest-10.0.2-pro/demo/ios/ in your QF‑Test installation. If you select an Android application, an additional page lets you decide whether an emulator should be started or whether a real device or a running emulator should be used. Choose between Start emulator or Connect to running emulator/real device. Then select the desired device name from the list of available devices.","hash":"fig_WizardTypeAndroid","h4":"Figure 29.1: Selecting the SUT type"},"741":{"id":741,"content":"Then select the desired device name from the list of available devices. Figure 29.2: Select device and app for Android When selecting the Android APK note that it is not shipped with QF‑Test by default. If you ran the carconfigAndroid demo, the app should have been downloaded to ${qftest:dir.user}/android, so you can directly enter ${qftest:dir.user}/android/CarConfigurator.apk. Alternatively you can download the APK from https://www.qftest.com/fileadmin/Webdata/pub/android/CarConfigurator.apk","hash":"fig_WizardChooseDeviceAndroid","h4":"Figure 29.1: Selecting the SUT type"},"742":{"id":742,"content":"Figure 29.3: Select device and app for Android Please press Finish to complete the wizard. The generated start sequence appears under the Extras section of the test suite and contains all steps necessary to start the app on the selected device.","hash":"fig_WizardAndroidDemo","h4":"Figure 29.3: Select device and app for Android"},"743":{"id":743,"content":"Figure 29.4: Generated start sequence Let's try it out: Make sure the node Setup: Start CarConfigurator is selected. Press or simply hit the Enter key. The selected app should now be installed and started on the device or emulator. Save the test suite ( or »File«-»Save« or Ctrl⁠+⁠S). Enter a name, e.g. FirstAndroidTests.qft.","hash":"fig_WizardFinalAndroid","h4":"Figure 29.4: Generated start sequence"},"744":{"id":744,"content":"Pro Tutorial","hash":"","h0":"Recording Actions | QF‑Test Tutorial"},"745":{"id":745,"content":"Pro Tutorial","hash":"home-link","h0":"Recording Actions | QF‑Test Tutorial"},"746":{"id":746,"content":"Recording Actions For mobile applications a special recording window is available mirroring the screen of the real device or emulator. This window is necessary because actions cannot be recorded directly on the device or emulator. All interactions are carried out via this recording window and recorded accordingly.","hash":"tut_recActionsMobile","h0":"Recording Actions"},"747":{"id":747,"content":"Figure 29.5: The recording window for Android applications Press the Record button in the recording window. Wait until the recording window opens. In the recording window, click the username text field and type \"tester\". Then click the password text field and type \"tester\". Stop recording via . The recorded sequence appears under the Extras section.","hash":"fig_MobileAppWinRec","h4":"Figure 29.5: The recording window for Android applications"},"748":{"id":748,"content":"The recorded sequence appears under the Extras section. Figure 29.6: By default, the sequence name contains the date and time of creation. This can be adjusted in the details on the right. Rename the sequence, e.g. to Perform login. We can insert the recorded actions at the end of our setup sequence. To keep complexity low for now, insert them inside a Try node. This ensures that no error is raised if we are already logged in.","hash":"fig_FirstRecordedLoginSequenceAndroid","h4":"Figure 29.5: The recording window for Android applications"},"749":{"id":749,"content":"We can insert the recorded actions at the end of our setup sequence. To keep complexity low for now, insert them inside a Try node. This ensures that no error is raised if we are already logged in. Figure 29.7: Next we want to record a series of actions: Press the Record button. With the mouse, select the model Rolo in the table. Switch to the Specials tab. Select the special model Jazz. Confirm your selection with OK. Finally click the first tab Vehicles again. Stop recording by switching back to the QF‑Test window and pressing the button there. Again, you will find the recorded sequence under the Extras section, as shown in the following image.","hash":"fig_FirstRecordedLoginSequenceRenamedAndroid","h4":"Figure 29.5: The recording window for Android applications"},"750":{"id":750,"content":"Figure 29.8: The tree after recording the sequence Change the sequence name to \"Select model Rolo Jazz\". Open the sequence to see its contained nodes. These should be the expected mouse clicks. You should even be able to identify the targeted components.","hash":"fig_FirstRecordedSequenceAndroid","h4":"Figure 29.8: The tree after recording the sequence"},"751":{"id":751,"content":"Figure 29.9: The renamed sequence We now want to replay the recorded sequence. Select the sequence Select model Rolo Jazz. Press Play. You should see exactly the same actions you recorded before. You should be able to replay the recorded flow repeatedly without errors. In the status line at the bottom right of the test suite window you should see \"Finished: No errors\".","hash":"fig_FirstRecordedSequenceRenamedAndroid","h4":"Figure 29.9: The renamed sequence"},"752":{"id":752,"content":"Pro Tutorial","hash":"","h0":"Recording Checks | QF‑Test Tutorial"},"753":{"id":753,"content":"Pro Tutorial","hash":"home-link","h0":"Recording Checks | QF‑Test Tutorial"},"754":{"id":754,"content":"Recording Checks Checks are also carried out in the recording window. In this way you can verify, for example, the text of an element or its visibility. In the recording window press the Record Check button. In the recording window select the text field for the total costs. Open the context menu (usually via right-click) and choose Text. Stop recording with . Rename the sequence, e.g. to Check price. Open the node to see the check.","hash":"tut_recChecksMobile","h0":"Recording Checks"},"755":{"id":755,"content":"Pro Tutorial","hash":"","h0":"Setting up a test suite | QF‑Test Tutorial"},"756":{"id":756,"content":"Pro Tutorial","hash":"home-link","h0":"Setting up a test suite | QF‑Test Tutorial"},"757":{"id":757,"content":"Setting up a test suite The base structure beneath the root node of a test suite is defined by the following nodes: An arbitrary number of Test set and Test case nodes to specify and structure functional tests. Procedures – reusable sequences organized into procedures. Extras – our playground for recordings, etc. Windows and components – the heart of the test suite. It contains all recorded windows and components of the SUT along with their properties. Functional test cases are represented by Test case nodes and grouped or structured via Test set nodes. Setup and Cleanup nodes can contain actions to ensure a well-defined state before and after a test case. We start by renaming the Test set node from \"unnamed\" to \"Demo Tests\". If a dialog appears about updating references, simply answer it with \"Yes\". Next, move the Setup node generated by the Quickstart Wizard into the Test set node, at the first position before the contained test case. You can move nodes via drag and drop, the context menu (right-click Cut/Paste) or the keyboard shortcuts Ctrl⁠+⁠X and Ctrl⁠+⁠V.","hash":"tut_buildtestandroid","h0":"Setting up a test suite"},"758":{"id":758,"content":"Figure 29.10: Beginning the structuring Next we want to turn the two previously recorded sequences into a test case. Rename the Test case node from \"unnamed\" to \"First\". Open the Test case node by clicking the \">\" symbol. Move the two sequences from the Extras section into the test case. If you do not open the Test case node, QF‑Test will try to insert the sequence nodes after the Test case node at the same level. However, this is not permitted for sequence nodes. QF‑Test always records sequences. These serve the same purpose as test steps. Test steps, however, are listed in the report. You can convert between them, which we will demonstrate for information in the following steps. Open the context menu for the first of the two sequence nodes with the right mouse button. Choose »Convert node to...«-»Test step«. Do the same for the second sequence node.","hash":"fig_beginbuildatest_mobile","h4":"Figure 29.10: Beginning the structuring"},"759":{"id":759,"content":"Figure 29.11: The tree after restructuring On Android and iOS the shutdown of the emulator/simulator cannot be recorded. Instead, use a Stop program node.","hash":"fig_buildatest_mobile","h4":"Figure 29.11: The tree after restructuring"},"760":{"id":760,"content":"On Android and iOS the shutdown of the emulator/simulator cannot be recorded. Instead, use a Stop program node. Figure 29.12: Simple cleanup sequence for Mobile With that we have completed the most important steps to structure our test suite.","hash":"fig_FirstCleanupAndroid","h4":"Figure 29.11: The tree after restructuring"},"761":{"id":761,"content":"Pro Tutorial","hash":"","h0":"Create a procedure (Mobile) | QF‑Test Tutorial"},"762":{"id":762,"content":"Pro Tutorial","hash":"home-link","h0":"Create a procedure (Mobile) | QF‑Test Tutorial"},"763":{"id":763,"content":"Create a procedure (Mobile) In the two previous chapters you learned how to start an application via QF‑Test so that mouse and keyboard input can be recorded, how to record checks and how to consolidate the result into a test case. This approach is sufficient as long as the tests are simple and not too many. However, as the number of tests grows, it becomes important to employ so-called \"procedures\". Procedures are a means to make sequences reusable and thus avoid duplication. This is essential to achieve simple and efficient maintainability of tests over time. Procedures can be grouped into packages . Procedures and packages are the basis for the modularization of tests.","hash":"sec_FirstProzedurMobile","h1":"Create a procedure (Mobile)"},"764":{"id":764,"content":"Pro Tutorial","hash":"","h0":"Identify reusable parts | QF‑Test Tutorial"},"765":{"id":765,"content":"Pro Tutorial","hash":"home-link","h0":"Identify reusable parts | QF‑Test Tutorial"},"766":{"id":766,"content":"Identify reusable parts In this section we will further develop the test suite FirstAndroidTests.qft, which you already know from chapter 19. Copy FirstAndroidTests.qft from the subdirectory qftest-10.0.2-pro/doc/tutorial of the QF‑Test installation into a working directory and open FirstAndroidTests.qft. If you want to save the changes we will make to the demo test suite, then save it to a working directory as described at the end of \"Starting the Application\". Please take a look at the \"Reset\" test step in both test cases. The two test steps are identical.","hash":"tut_procreusemobile","h0":"Identify reusable parts"},"767":{"id":767,"content":"Figure 30.1: Two identical test steps According to the considerations above it makes sense to convert the test step into a procedure.","hash":"IdenticalTeststepsAndroid","h4":"Figure 30.1: Two identical test steps"},"768":{"id":768,"content":"Pro Tutorial","hash":"","h0":"Manual creation of procedures | QF‑Test Tutorial"},"769":{"id":769,"content":"Pro Tutorial","hash":"home-link","h0":"Manual creation of procedures | QF‑Test Tutorial"},"770":{"id":770,"content":"Manual creation of procedures There are several ways to create procedures and insert procedure calls. We start with the manual approach where an (empty) Procedure node is inserted, and then the corresponding actions are moved into it. Then we will create the corresponding procedure call. It is good to know these basic steps. However, there is a second, more elegant way to create procedures, which we will show afterwards. So let's insert a procedure by hand: We begin by creating the Procedure node and giving it a suitable name. Open the Procedure node and make sure it is selected (highlighted in blue). Choose »Insert«-»Procedure node«-»Procedure«. Enter \"reset\" as the name. The other fields do not need to be filled in. Press OK to complete creation of the procedure. Open the newly created \"reset\" procedure.","hash":"tut_procmanualmobile","h0":"Manual creation of procedures"},"771":{"id":771,"content":"Figure 30.2: Create procedure node In the second step we fill the procedure with the corresponding reusable actions. Select the three \"Mouse click\" nodes in the test step. To select more than one node, click the first node, then press the Shift key and click the last of the nodes to be selected while keeping the Shift key pressed. Move them down into the procedure, e.g. with the mouse (drag and drop) or via cut/paste in the »Edit« menu or via the context menu.","hash":"ProcedureNodeInFirstTestcaseAndroid","h4":"Figure 30.2: Create procedure node"},"772":{"id":772,"content":"Figure 30.3: Fill procedure with content In the third step we insert a procedure call in place of the three moved mouse clicks. Select the \"Reset\" test step, which should be open. Choose the menu »Insert«-»Procedure node«-»Procedure call« or use the keyboard shortcut Ctrl⁠+⁠A.","hash":"procedureContentInFirstTestcaseAndroid","h4":"Figure 30.3: Fill procedure with content"},"773":{"id":773,"content":"Figure 30.4: Insert procedure call Press the procedure selection button in the dialog to the left of the label \"Name of the procedure\". Select \"reset\" from the procedure list. No further input is necessary. Press OK in both dialogs to complete creation of the procedure call.","hash":"AddProcedureCallAndroid","h4":"Figure 30.4: Insert procedure call"},"774":{"id":774,"content":"Figure 30.5: Select procedure To really gain value from the procedure, we now need to replace the content of the test step in the second test case with a call to the \"reset\" procedure as well. You can do this as described above or perform the following alternative steps to create the procedure call: Open the 'Reset' test step of the second test case. Delete the three mouse click nodes from it. Select the \"reset\" procedure node. Drag the \"reset\" procedure node with the mouse into the test step node. Copy/paste can also be used. This does not move the Procedure node but creates a corresponding procedure call. The test suite should then look as follows:","hash":"SelectProcedureAndroid","h4":"Figure 30.5: Select procedure"},"775":{"id":775,"content":"Figure 30.6: Test suite with procedure If you now run the test cases, they should work as before. In the log you can now also see the procedure calls and their execution.","hash":"fig_testsuite_with_Procedure_android","h4":"Figure 30.6: Test suite with procedure"},"776":{"id":776,"content":"Pro Tutorial","hash":"","h0":"Convert node to procedure | QF‑Test Tutorial"},"777":{"id":777,"content":"Pro Tutorial","hash":"home-link","h0":"Convert node to procedure | QF‑Test Tutorial"},"778":{"id":778,"content":"Convert node to procedure As mentioned at the beginning of the last section, QF‑Test offers an alternative to create procedures much faster. Mark the Test step or Sequence node that contains the reusable steps that should be transformed into a procedure. Choose the menu »Operations«-»Convert node to«-»Procedure« or use the keyboard shortcut Ctrl⁠+⁠Shift⁠+⁠P. As you can see, the Test step or the Sequence node has disappeared. In its place there is a Procedure call node. In addition, a procedure with the name of the former test step or sequence has been created in the Procedures section. It contains exactly the same child nodes as the test step or sequence did before. When recording a sequence in QF‑Test it has proven useful to give the sequence a name immediately and then convert it into a procedure, even if you only suspect that the recorded steps might be repeated somewhere.","hash":"tut_proctransformmobile","h0":"Convert node to procedure"},"779":{"id":779,"content":"Pro Tutorial","hash":"","h0":"Components (Mobile) | QF‑Test Tutorial"},"780":{"id":780,"content":"Pro Tutorial","hash":"home-link","h0":"Components (Mobile) | QF‑Test Tutorial"},"781":{"id":781,"content":"Components (Mobile) QF‑Test stores the information needed to find components displayed in the GUI of the SUT in the Windows and components area. During recording QF‑Test analyzes the information obtained about GUI elements and stores those with which the user interacted in the details of Component nodes. Detailed information about components can be found in the manual chapter Components. In this chapter we will show how to address subitems of components like tables and lists.","hash":"sec_ComplexComponentsMobile","h1":"Components (Mobile)"},"782":{"id":782,"content":"Pro Tutorial","hash":"","h0":"Addressing subitems of tables and lists | QF‑Test Tutorial"},"783":{"id":783,"content":"Pro Tutorial","hash":"home-link","h0":"Addressing subitems of tables and lists | QF‑Test Tutorial"},"784":{"id":784,"content":"Addressing subitems of tables and lists Subitems of tables and lists are addressed via indices. The two most important index types are the numerical index and the text index. To demonstrate this, we will now record a mouse click on a list item and take a closer look at the recorded QF‑Test component ID. Start the CarConfig demo if it is not already running. Execute the Setup node in the test suite to do so. Activate recording mode via “Start recording” . Click a list item, e.g. the first model. Stop recording via “Stop recording” . You will find the recorded mouse click in the Extras section.","hash":"sec_addressing_complex_components_mobile","h0":"Addressing subitems of tables and lists"},"785":{"id":785,"content":"Figure 31.1: Addressing a list item The recorded QF‑Test component ID is action_bar_root.list@Rolo. It consists of the following parts: action_bar_root.list is the QF‑Test ID of the list component itself. @ separates the index from the QF‑Test component ID, defining the type of the index as a text index. Rolo is the text index for the list item with the text “Rolo”. Alternatively you can use & to specify a numerical index. Thus, &0 would specify the first list item. Numerical indices always start at 0. Tables are addressed analogously to lists, but they have an additional index to address the column. VehicleTable@Modell&0 addresses in table VehicleTable the column via the text index Modell and the row via the numerical index 0. This is just an example and cannot be tried out in the Android demo because there is no table in the app.","hash":"fig_ComponentsListIndexMobile","h4":"Figure 31.1: Addressing a list item"},"786":{"id":786,"content":"Pro Tutorial","hash":"","h0":"SmartIDs – direct component addressing | QF‑Test Tutorial"},"787":{"id":787,"content":"Pro Tutorial","hash":"home-link","h0":"SmartIDs – direct component addressing | QF‑Test Tutorial"},"788":{"id":788,"content":"SmartIDs – direct component addressing Since QF‑Test 7.0, SmartIDs officially offer the possibility to reference components without recording a Component node. For certain applications this can greatly simplify the management and maintenance of component information. SmartIDs can also have a positive impact on the editability and readability of tests. Last but not least, this enables creating tests even without the recording function, for example when a component or the entire application does not yet exist and you want to implement the test already (“Test first” approach). As recognition criteria, the component class, its name or label, and the index are available. The values are the same as for the recorded Component node. Component hierarchies can also be represented. A SmartID is used instead of the QF‑Test component ID. Its marker is the hash # as the first character. This is followed by the name or label of the component, for example: Details and examples can be found in the manual chapter SmartID.","hash":"sec_components_smartid_android","h0":"SmartIDs – direct component addressing"},"789":{"id":789,"content":"Pro Tutorial","hash":"","h0":"Using the Debugger (Mobile) | QF‑Test Tutorial"},"790":{"id":790,"content":"Pro Tutorial","hash":"home-link","h0":"Using the Debugger (Mobile) | QF‑Test Tutorial"},"791":{"id":791,"content":"Using the Debugger (Mobile) This chapter is also available as a video at 'Using the Debugger'. In this chapter you will learn how to use the intuitive debugger integrated into QF‑Test. Those of you already familiar with other IDEs like Eclipse will notice similarities in the functionality and usefulness of the debugger. We will cover the following debugger features: Setting a Breakpoint via Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B). Pausing test execution via the Pause button or the keyboard shortcut to interrupt test execution (\"Don’t Panic\" key) Alt⁠+⁠F12. Stepping through Execution via \"Step in\" , \"Step over\" and \"Step out\" . Skipping nodes via \"Skip over\" and \"Skip out\" . Activating debugger mode on error or exception. Resolving problems from the run log. Jump directly to the current error in the run log via Ctrl⁠+⁠J. (Jump to run log in chapter \"Resolving problems from the run log\"). Instead of using the buttons you can also trigger commands via the menu bar or keyboard shortcuts. Shortcuts are listed in the QF‑Test menus where applicable. A complete overview of keyboard shortcuts used by QF‑Test can be found in the appendix Keyboard shortcuts of the manual. There you will also find a small helper for the function key layout of QF‑Test to attach to your keyboard. There are additional debugger features such as \"Locate current node\" (Locate current node in \"Advanced Debugging Using the \"Variable bindings\" Table\"), \"Continue execution from here\" via the popup menu of the respective node (\"Continue execution from here\"), \"Rethrow exception\" , the table of variable definitions (\"Advanced Debugging Using the \"Variable bindings\" Table\"), which we will discuss in later chapters.","hash":"sec_DebuggerAndroid","h1":"Using the Debugger (Mobile)"},"792":{"id":792,"content":"Pro Tutorial","hash":"","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"793":{"id":793,"content":"Pro Tutorial","hash":"home-link","h0":"Setting a Breakpoint | QF‑Test Tutorial"},"794":{"id":794,"content":"Setting a Breakpoint First we want to activate the debugger. This can be done in several ways, for example by setting a breakpoint before starting the test run. The purpose of a breakpoint is to interrupt the test run at a position you want to examine more closely. As soon as QF‑Test hits the breakpoint, test execution is paused and the debugger mode is activated. The Pause button is now pressed. Select a node and press Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B). The breakpoint is indicated by the icon .","hash":"tut_breakpointsmobile","h0":"Setting a Breakpoint"},"795":{"id":795,"content":"Figure 32.1: Setting a breakpoint Select the Test suite node and start the test run via the key Enter.","hash":"fig_DebugSetBreakpointAndroid","h4":"Figure 32.1: Setting a breakpoint"},"796":{"id":796,"content":"Figure 32.2: Starting the test run Remove the breakpoint by pressing Ctrl⁠+⁠F8 (on macOS: ⇧⁠+⁠⌘⁠+⁠B) again.","hash":"fig_DebugStartTestRunAndroid","h4":"Figure 32.2: Starting the test run"},"797":{"id":797,"content":"Figure 32.3: Removing a breakpoint You can set or remove a breakpoint not only via the shortcut Ctrl⁠+⁠F8, but also via the menu »Debugger«-»Breakpoint on/off« or alternatively by right-clicking the node and selecting »Breakpoint on/off« in the popup menu. For the other debugger functions we will mainly refer to the respective buttons, but the other options are available as well. Again you will see the small arrow, this time indicating which node will be executed next. This node is called the current node. When the debugger mode is activated, QF‑Test navigates to the current node if it is not already visible and selects it, i.e. the row is highlighted in blue. The command »Debugger«-»Remove all breakpoints« is also useful if you want to remove all breakpoints in all open test suites. There is no limit to the number of breakpoints you can set in your test suite. Breakpoints are not saved when the test suite is closed.","hash":"fig_DebugRemoveBreakpointAndroid","h4":"Figure 32.3: Removing a breakpoint"},"798":{"id":798,"content":"Pro Tutorial","hash":"","h0":"Stepping through Execution | QF‑Test Tutorial"},"799":{"id":799,"content":"Pro Tutorial","hash":"home-link","h0":"Stepping through Execution | QF‑Test Tutorial"},"800":{"id":800,"content":"Stepping through Execution Now we want to execute the test cases step by step. Please experiment a bit with \"Step in\" , \"Step over\" and \"Step out\" . As you will have noticed, \"Step in\" opens a node with children and makes the first child node the active node. This is, as always, indicated by the arrow marker on the node. If you continue from the point where execution of the test suite was paused in the last section, i.e. from the node \"Test case: First\", the test case would now be opened:","hash":"tut_debug_steps_mobile","h0":"Stepping through Execution"},"801":{"id":801,"content":"Figure 32.4: Step in In the case of a leaf node, i.e. a node that has no children, the effect is the same as the following function. With the button \"Step over\" a node including all its child nodes is executed. The next node to be executed at the same level then becomes the active one and gets the arrow.","hash":"fig_StepInExampleAndroid","h4":"Figure 32.4: Step in"},"802":{"id":802,"content":"Figure 32.5: Step over \"Step out\" executes the remaining sibling nodes and stops at the next node to be executed on the parent hierarchy level.","hash":"fig_StepOverExampleAndroid","h4":"Figure 32.5: Step over"},"803":{"id":803,"content":"Figure 32.6: Step out In the example this is the Cleanup node. As already explained in the first chapter A full Test Run, Setup and Cleanup nodes have the special property of being executed before and after each test case to establish a defined starting state for every test case. This behavior only occurs if you started the complete test suite or the test set and are in debugger mode. If no test execution was active and you had only selected the test case, the \"Step over\" function causes the test case to be executed and then the next test case to be selected. Execute the Cleanup and Setup nodes by using to execute the entire nodes and then to open the second test case. This is preparation for the next chapter about skipping nodes. Please note during interactive test creation with menus and comboboxes that these often collapse when the application loses focus, which is the case when switching to debugger mode. In such cases it is advisable to execute the node that opens a menu or combobox together with the node that performs the selection, i.e. do not switch to debugger mode in between. For example, you can achieve this by setting a breakpoint after the node that performs the selection and, when reaching the node that opens the menu or combobox, resume test execution by releasing the Pause button .","hash":"fig_StepOutExampleAndroid","h4":"Figure 32.6: Step out"},"804":{"id":804,"content":"Pro Tutorial","hash":"","h0":"Skipping nodes | QF‑Test Tutorial"},"805":{"id":805,"content":"Pro Tutorial","hash":"home-link","h0":"Skipping nodes | QF‑Test Tutorial"},"806":{"id":806,"content":"Skipping nodes The \"Skip\" functions extend the capabilities of QF‑Test’s debugger in a way that goes beyond the functionality of standard programming environments. As the name suggests, the \"Skip\" operations allow skipping one or more nodes during the test run, i.e. jumping ahead without executing them. This can be useful for various reasons, e.g. to quickly reach a certain position in your test flow or to skip a node currently causing an error. At the end of the last section we made the first test step in the second test case the active node. This is the starting point for our next action:","hash":"tut_skip_steps_mobile","h0":"Skipping nodes"},"807":{"id":807,"content":"Figure 32.7: Execution paused at the first node of the second test case Now press the \"Skip over\" button . QF‑Test simply skips the active node without executing it or its child nodes. It then pauses at the next node to be executed on the same level.","hash":"fig_DebugSkipOverInitialStateAndroid","h4":"Figure 32.7: Execution paused at the first node of the second test case"},"808":{"id":808,"content":"Figure 32.8: \"Skip over\" And finally the \"Skip out\" button . You immediately see that QF‑Test skips out of the current node without executing further child nodes.","hash":"fig_DebugSkipOverAndroid","h4":"Figure 32.8: \"Skip over\""},"809":{"id":809,"content":"Figure 32.9: \"Skip out\" One remark about \"Skip over\" and \"Skip out\": Use these with care! Skipping out of a sequence before it has finished can leave your SUT in a state that other sequences or tests in the suite cannot build upon.","hash":"fig_DebugSkipOutAndroid","h4":"Figure 32.9: \"Skip out\""},"810":{"id":810,"content":"Pro Tutorial","hash":"","h0":"Activating debugger mode on error or exception | QF‑Test Tutorial"},"811":{"id":811,"content":"Pro Tutorial","hash":"home-link","h0":"Activating debugger mode on error or exception | QF‑Test Tutorial"},"812":{"id":812,"content":"Activating debugger mode on error or exception When debugging a test it is often helpful if test execution stops and switches to debugger mode exactly when an error, an exception or sometimes even just a warning occurs. Using this technique we will debug the second test case in this section and the next. Please open the Debugger menu and change the default settings as follows: Click the menu item »Debugger«-»Debugger enabled« to enable it. Click the submenu item »Debugger«-»Options«-»Break on error« to enable this function as well. If you now open the Debugger menu and the Options submenu again, it should look like this:","hash":"tut_debug_start_mobile","h0":"Activating debugger mode on error or exception"},"813":{"id":813,"content":"Figure 32.10: Debugger options: stop test on error We have to change the debugger options because otherwise the test would just run through, analogous to the previous examples from chapters one and two. Select the Test suite node and then start the test via \"Start test run\" . QF‑Test stops at the erroneous node and switches to debugger mode:","hash":"fig_debugger_stops_at_error_mobile","h4":"Figure 32.10: Debugger options: stop test on error"},"814":{"id":814,"content":"Figure 32.11: QF‑Test pauses on error The node that caused the error is marked by a red square. In addition, an error dialog appears that provides details about the cause of the error. From there we switch to the run log which, as so often, is the key to fixing the problem.","hash":"fig_debugger_stopped_by_error_mobile","h4":"Figure 32.11: QF‑Test pauses on error"},"815":{"id":815,"content":"Figure 32.12: Error message Click the Jump to run log button in the error message.","hash":"debug_error_dialog_mobile","h4":"Figure 32.12: Error message"},"816":{"id":816,"content":"Pro Tutorial","hash":"","h0":"Resolving problems from the run log | QF‑Test Tutorial"},"817":{"id":817,"content":"Pro Tutorial","hash":"home-link","h0":"Resolving problems from the run log | QF‑Test Tutorial"},"818":{"id":818,"content":"Resolving problems from the run log Via the Jump to run log button (see error message in figure \"Error message\") the run log opens directly at the corresponding node. In addition to the actual error message, various other information about the test environment at the time of the error has been logged. Besides screenshots taken at the time of the error, the run log under the node that caused the error contains a list of bound variables (stacktrace). We will return to the usefulness of the stacktrace later (The \"Variable Bindings\" Table). In the present case the wrong value is expected in the Check text node of the test suite. To fix the error this must be replaced by the value actually shown. For a Check with a fixed value, which is the case here, the easiest way is to right-click the error node with the red border \"Failed: Check text: default …\" and select »Update Check node with received data« in the context menu.","hash":"tut_ResolveRunTimeErrorsAndroid","h0":"Resolving problems from the run log"},"819":{"id":819,"content":"Figure 32.13: Update Check node with received data QF‑Test navigates to the affected Check text node in the test suite and updates the value of the attribute Text based on the data read from the SUT.","hash":"fig_DebugUpdateCheckNodeAndroid","h4":"Figure 32.13: Update Check node with received data"},"820":{"id":820,"content":"Figure 32.14: Corrected Check node The node now contains the correct value, but it is still marked with a red border because it has not been executed again yet. We will do that now. Continue the test by pressing the Pause button to release the pause. QF‑Test executes the rest of the test suite. In our case these are the Check text and the Cleanup nodes. Subsequently QF‑Test informs you that an error occurred. However, we already fixed this during the test run.","hash":"fig_DebugCorrectedCheckNodeAndroid","h4":"Figure 32.14: Corrected Check node"},"821":{"id":821,"content":"Jump to run log: If you want to open the run log exactly at the position where test execution is currently paused, simply click the menu item »Debugger«-»Jump to Run log« or press the shortcut Ctrl⁠+⁠J from debugger mode. If you just want to open the run log without jumping to the current position, use Ctrl⁠+⁠L, which also works after the test run has finished.","hash":"tut_JumpToRunLogAndroid tut_JumpToRunLogAndroid","h4":"Figure 32.14: Corrected Check node"},"822":{"id":822,"content":"Pro Tutorial","hash":"","h0":"Pausing test execution | QF‑Test Tutorial"},"823":{"id":823,"content":"Pro Tutorial","hash":"home-link","h0":"Pausing test execution | QF‑Test Tutorial"},"824":{"id":824,"content":"Pausing test execution If a test is currently running and you want to switch to debugger mode, you can either quickly set a breakpoint on a node that has not yet been executed, or simply press the \"Pause\" button to activate debugger mode immediately. To continue execution, release the Pause button , regardless of how debugger mode was activated. We want to continue using the existing test cases throughout this tutorial. However, the error in the second test case has now been fixed. Therefore it makes sense to remove \"(with error)\" from the name of the second test case, as well as \"(causes error)\" from the name of the test step. There are situations where the SUT constantly grabs the focus. In such cases it can be difficult to keep the QF‑Test window in the foreground long enough to press the Pause button. In this case you can use the \"Don’t Panic\" key Alt⁠+⁠F12. It immediately interrupts all running tests. To continue the test you can press this key combination again.","hash":"tut_pause_execution_mobile","h0":"Pausing test execution"},"825":{"id":825,"content":"Pro Tutorial","hash":"","h0":"Variables and Procedure Parameters (Mobile) | QF‑Test Tutorial"},"826":{"id":826,"content":"Pro Tutorial","hash":"home-link","h0":"Variables and Procedure Parameters (Mobile) | QF‑Test Tutorial"},"827":{"id":827,"content":"Variables and Procedure Parameters (Mobile) In this chapter you will learn how to use a procedure to execute the same steps with different data. You will also see how to use variables. Error analysis with respect to variables is covered as well. This chapter is also available as a video at 'Variables and Procedure Parameters'. In the video, a Java application is used for the explanations. For Android applications there are no differences regarding the use of variables.","hash":"sec_variablestackmobile","h1":"Variables and Procedure Parameters (Mobile)"},"828":{"id":828,"content":"Pro Tutorial","hash":"","h0":"Procedure with a Variable | QF‑Test Tutorial"},"829":{"id":829,"content":"Pro Tutorial","hash":"home-link","h0":"Procedure with a Variable | QF‑Test Tutorial"},"830":{"id":830,"content":"Procedure with a Variable Take a look at the last test step \"Check final price\" in our two test cases.","hash":"sec_ProcedureWithVariableAndroid","h0":"Procedure with a Variable"},"831":{"id":831,"content":"Figure 33.1: Two almost identical test steps The same step is executed, but with different data. Even if it is just a single step, it makes sense to turn it into a procedure. We might later decide to convert the hard-coded values 13.349,00 € and 12.734,00 € to another format so that the check on the \"Final price\" field works for other currencies as well. Implementing such logic twice would definitely not be sensible. Select the Check text node in the first test case. Choose the menu »Operations«-»Wrap node into«-»Sequence« or use the keyboard shortcut Ctrl⁠+⁠Shift⁠+⁠S to wrap it into a sequence. Name the sequence 'checkFinalPrice'. This name follows the Java convention of concatenating words. On the other hand, QF‑Test also allows spaces in procedure names, so you do not have to follow the Java convention. Press Ctrl⁠+⁠Shift⁠+⁠P to quickly convert the sequence node into a procedure (as known from the previous chapter). As you can see, the sequence is replaced by a procedure call to \"checkFinalPrice\". Double-click the procedure call to jump to the procedure in the Procedures node. Open the newly created procedure node to see its contents.","hash":"fig_params1Android","h4":"Figure 33.1: Two almost identical test steps"},"832":{"id":832,"content":"Figure 33.2: Procedure with hard-coded value As expected, the Check text node is inside the procedure. However, it is only valid for a single price, namely 13.349,00 €. Since we also want to use the same procedure for the second test case, we need to replace the price with a variable. The value of this variable should then be passed when calling the procedure. In the next example we will add a parameter with a default value in the procedure node. Default values are often used when the corresponding parameter would receive that value in most procedure calls. Then you don't need to specify the default value every time and can rely on the value defined in the procedure node. Although this does not apply to the price parameter, we can use it here to show how a default value works and how it can be overridden with another value when needed. First, let’s add a variable with a default value: Select the procedure 'checkFinalPrice'. Press the \"Insert row\" button above the \"Default values for parameters\" table. Enter price as the name of the parameter. Enter 13.349,00 € as the value. Press OK.","hash":"fig_procedure_hardcoded_mobile","h4":"Figure 33.2: Procedure with hard-coded value"},"833":{"id":833,"content":"Figure 33.3: Details of a procedure node In the next step, we replace the value of the Text attribute of the Check text node with a reference to the variable.","hash":"fig_parameter_default_values_table_mobile","h4":"Figure 33.3: Details of a procedure node"},"834":{"id":834,"content":"Variable syntax: When working with variables it is important to understand that in some places you tell QF‑Test what the name of a variable is and in others you tell QF‑Test to access the value of a variable. In the example above, QF‑Test is informed of the variable name in the name column of the default values table. In that case you only needed to enter price. In the Text attribute of the Check text node, the value of the variable should be used. In QF‑Test this is done by putting the variable name in $(), here $(preis). If you do not wrap the variable name in $(), QF‑Test would compare the price with the literal string price. Select the Check text node in the procedure \"checkFinalPrice\". Enter $(preis) in the Text attribute of the Check text node details. Press 'OK' in the node details.","hash":"tut_VariableSyntaxMobile","h4":"Figure 33.3: Details of a procedure node"},"835":{"id":835,"content":"Figure 33.4: 'Check text' node Execute the first test case. The test case should run without errors.","hash":"fig_ProcedureAddVariableAndroid","h4":"Figure 33.4: 'Check text' node"},"836":{"id":836,"content":"Pro Tutorial","hash":"","h0":"The \"Variable Bindings\" Table | QF‑Test Tutorial"},"837":{"id":837,"content":"Pro Tutorial","hash":"home-link","h0":"The \"Variable Bindings\" Table | QF‑Test Tutorial"},"838":{"id":838,"content":"The \"Variable Bindings\" Table In the next step we add a procedure call in the second test case. Replace the Check text node of the second test case with a procedure call to \"checkFinalPrice\". You can simply copy the procedure call from the first test case or insert it as described above.","hash":"tut_variable_stack_mobile","h0":"The \"Variable Bindings\" Table"},"839":{"id":839,"content":"Figure 33.5: Procedure call to \"checkFinalPrice\" in the second procedure If the procedure call already shows the price with its default value, this is because the procedure call was generated using the procedure itself, either by copying the procedure, via drag-and-drop using the procedure node, or by direct insertion of the procedure as explained further above. For the current topic we focus on the default value. Therefore, please delete any existing price parameter if you are following the tutorial step by step. To do so, click the red X above the \"Variable bindings\" table. Make sure the debugger is configured to break on errors (see Debugger options: stop test on error). Select the node \"Test case: Second\". Execute it either via the button or by pressing the Enter key. An error message indicates that a different price than the one displayed was expected. What went wrong? Let’s investigate the error. Usually we would look into the run log, but there is another important source of information. Click OK to close the error message. In debugging mode you can see a list of nodes with variables bound by them at the bottom right of the QF‑Test window. You may need to enlarge the \"Variable bindings\" table to see all entries.","hash":"fig_AddProcedureCallToSecondTestcaseAndroid","h4":"Figure 33.5: Procedure call to \"checkFinalPrice\" in the second procedure"},"840":{"id":840,"content":"Figure 33.6: Variable definitions The \"Variable bindings\" table is very helpful during debugging because it shows the current values of variables. It supports working with procedures and helps understand how QF‑Test determines the correct variable value. QF‑Test processes the \"Variable bindings\" table from top to bottom. You see that in the first lines no variables are bound. At the \"Global variables\" level one variable is bound, and on the secondary stack for \"Procedure: checkFinalPrice\" another one. The global variable is used for the connection to the SUT application and was set before application startup (cf. Starting and Connecting the Device). The other variable is of more interest right now — but it has the wrong value. This value on the secondary stack is the default value, which is used when no variable with the same name is assigned a value elsewhere. To fix this, we need to pass the correct value to the procedure in the procedure call. Again, there are several ways to do this. One way would be to add a new row in the \"Variable bindings\" table in the details of the procedure call, similar to how we did it in the procedure node in the previous section. If there are already multiple procedure calls, the following is simpler: Stop the running test execution via . Right-click the Procedure node and choose »More node operations«-»Adjust parameters of references« in the popup menu.","hash":"fig_VariableBindingsTable1Android","h4":"Figure 33.6: Variable definitions"},"841":{"id":841,"content":"Right-click the Procedure node and choose »More node operations«-»Adjust parameters of references« in the popup menu. Figure 33.7: Popup menu for \"Adjust parameters of references\" In the following dialog, ensure the checkbox »Add missing parameters at caller« is set, and confirm with OK. In the procedure call, QF‑Test creates a row in the \"Variable bindings\" table for each default value. In our case, a row has been added for the parameter named price with the value 13.349,00 €. Even so, it will still not work in the second test case, even though the value is passed directly, because it is still the default value which is not correct here. Please do not change the value yet, so we can use the resulting error to demonstrate another debugging method. Close the \"Adjusted nodes\" dialog that QF‑Test shows to inform you about completed nodes.","hash":"fig_CompleteParameters_mobile","h4":"Figure 33.6: Variable definitions"},"842":{"id":842,"content":"Pro Tutorial","hash":"","h0":"Advanced Debugging Using the \"Variable bindings\" Table | QF‑Test Tutorial"},"843":{"id":843,"content":"Pro Tutorial","hash":"home-link","h0":"Advanced Debugging Using the \"Variable bindings\" Table | QF‑Test Tutorial"},"844":{"id":844,"content":"Advanced Debugging Using the \"Variable bindings\" Table Next, we want to examine the\"Variable bindings\" table and find out how to use it for debugging. Therefore, please keep the incorrect value that was inserted in the procedure call in the previous section. We will interrupt the execution of the test case at the procedure call and then step into the procedure. While doing so, we will watch what happens in the \"Variable bindings\" table. Afterwards we will jump directly from the \"Variable bindings\" table to the faulty procedure call and correct the parameter value there. Set a breakpoint at \"Procedure call: checkFinalPrice\" in the second test case. Execute the second test case. When QF‑Test stops at the breakpoint, perform two step-ins into the procedure using and watch the \"Variable bindings\" table.","hash":"tut_variable_stack_debugging_mobile","h0":"Advanced Debugging Using the \"Variable bindings\" Table"},"845":{"id":845,"content":"Figure 33.8: Variable Definitions table shows the wrong value When you step into the procedure, the first step creates a row for \"Procedure call: checkFinalPrice\" at the top of the table, and the second step creates the row \"Procedure: checkFinalPrice\". Now the variable price appears at two different levels in the \"Variable bindings\" table: in the row for \"Procedure call: checkFinalPrice\" and in the row \"Procedure: checkFinalPrice\" on the secondary stack, neither of which has the correct value. In QF‑Test you can interactively change the values of variables in the \"Variable bindings\" table while in debugging mode. You can even add new variables or delete existing ones. You can work with them as long as they are on the variable stack, in our case as long as the procedure is being executed. Changing the current variable value in the \"Variable bindings\" table does not adjust the parameter value entered in the procedure call node. The value must be changed explicitly in the procedure call. The fastest way to get to the procedure call is to double-click the procedure call row (the second row) in the Variable Definitions table. This method is especially helpful when you are debugging large test suites and the node you want to jump to is not visible in the test suite window. Instead of a double-click you can also right-click the row and choose the menu item »Jump to node in test suite«. Double-click the second row with the procedure call in the \"Variable bindings\" table. Set the parameter to the correct value, i.e. 12.734,00 €. Conversely, the current value in the \"Variable bindings\" table is not changed by this. To achieve that, we need to execute the procedure call again. However, the test execution has already moved past this point. Here we want to demonstrate another useful function of the debugger that lets you instruct QF‑Test to change the next node to be executed. Select the corresponding node and choose the menu »Continue execution from here« or use the keyboard shortcut Ctrl⁠+⁠,. So, to try out the newly set value: Right-click the node \"Procedure call: checkFinalPrice\" in the second procedure. Select \"Continue execution from here\" in the popup menu.","hash":"fig_VariableStack3Android","h4":"Figure 33.8: Variable Definitions table shows the wrong value"},"846":{"id":846,"content":"Figure 33.9: Continue execution from here The two top rows in the \"Variable bindings\" table have disappeared. The reason is that you have left the procedure (albeit \"backwards\") and the procedure call with the variables bound to it has been taken off the call stack. Release the pause button . No error should appear now. Because the \"Variable bindings\" table is extremely helpful when hunting for incorrect variable values, a copy of it is also stored under the \"Stacktrace\" node in the run log, showing the variable values exactly at the time of the error.","hash":"fig_ProcedureContinueExecFromHereAndroid","h4":"Figure 33.9: Continue execution from here"},"847":{"id":847,"content":"Locate current node: Sometimes you drift quite far from the current node while debugging and then want to return to it. The easiest way is to press \"Locate current node\" in the toolbar or choose the menu »Debugger«-»Locate current node«.","hash":"locate_current_node_mobile locate_current_node_mobile","h4":"Figure 33.9: Continue execution from here"},"848":{"id":848,"content":"Pro Tutorial","hash":"","h0":"Setting Variables | QF‑Test Tutorial"},"849":{"id":849,"content":"Pro Tutorial","hash":"home-link","h0":"Setting Variables | QF‑Test Tutorial"},"850":{"id":850,"content":"Setting Variables In addition to the methods described above, variables can also be set as follows: Via a Set variable node, as a Procedure node's Return value, as the result of a QF‑Test node like Fetch text, Fetch geometry, Fetch index and Check, in the 'Variable bindings' table of Test suite, Test case, Test step, Sequence and other nodes like If or Loop, via command line parameters. Information about where a variable is best defined can be found in the next section. A Set variable node can be inserted via the menu »Insert«-»Misc nodes«-»Set variable«. In the node details you can specify whether it should be a local variable (tick the Local variable check box) or a global variable. The following figure shows the details of a Set variable node that you can find as the first node in the Setup node. A variable named client is defined. You can tell that it is a global variable because the Local variable check box is not set.","hash":"tut_setting_variables_mobile","h0":"Setting Variables"},"851":{"id":851,"content":"Figure 33.10: Details of the Set variable node If a variable should be set with the return value of a procedure, specify the variable name in the \"Variable for return value\" attribute of the procedure call. In the procedure itself you must insert a Return node as the last node to be executed to return the relevant value. The procedure in the following figure reads the discount value from the SUT and returns it to the calling test case. There, the receiving variable is named Rabatt and is declared as a local variable. This example is not included in the exercise test suite.","hash":"figtailsSetVariableAndroid","h4":"Figure 33.10: Details of the Set variable node"},"852":{"id":852,"content":"Figure 33.11: Procedure with return value The Fetch text node in the figure above is one of the QF‑Test nodes that directly set the value of a variable. The variable name is entered in the accordingly named attribute. Again, you can choose whether it should be a local or a global variable. There are a number of nodes that have a Variable definitions table. There, you can set local variables. If the respective node is inside a procedure, the variable is bound as a local variable to the procedure, otherwise as a local variable to the test case. Variables that are bound to the test suite node via this table can be referenced by all nodes in the test suite. All nodes to which variables can be bound are displayed in the \"Variable bindings\" panel at the bottom right in debugger mode, when they are currently being executed. Variables can also be specified via the command line. Use the command line parameter -variable, e.g. qftest -batch -variable \"browser\"=\"ie\" test.qft. For further information see the manual, chapter 'Command line arguments'.","hash":"fig_DetailsCallProcedureAndroid","h4":"Figure 33.11: Procedure with return value"},"853":{"id":853,"content":"Pro Tutorial","hash":"","h0":"Levels for Variable Definitions | QF‑Test Tutorial"},"854":{"id":854,"content":"Pro Tutorial","hash":"home-link","h0":"Levels for Variable Definitions | QF‑Test Tutorial"},"855":{"id":855,"content":"Levels for Variable Definitions This section answers the question of at which level a variable should be defined. If you are currently not interested, you can skip directly to the next chapter. Variables can be bound at different levels: In the test suite node, in test cases and procedures as default or local variables, as parameters in a procedure call, as global variables, and as command line parameters. The level at which a variable is best defined depends on the purpose of the variable: Procedure parameters Pass a value as a parameter to a procedure if the same procedure is to be executed more than once with different values. Procedure parameters are specified in the Variable definitions table of a Procedure call node. Local variables in a procedure Local variables are defined within the procedure and are valid only there. When the procedure finishes, they are deleted. Use a local variable if it is not needed outside the procedure. They are the tool of choice for intermediate results. Local variables in a test case In a test case, local variables can either be created during the execution of the test case or via the corresponding table in the details of the Test case node. If you use the same value multiple times within a test case, it makes sense to assign it to a variable once and then use the variable. This improves maintainability. Local variables should also be used for intermediate results. Global variables When global variables have been created, they exist until they are explicitly deleted or until QF‑Test is closed. They even survive stops and re-execution of tests. Use them for values that are needed in multiple test cases. An example is the variable client which is created in the Setup node when starting the application. To get rid of them, choose the menu »Playback«-»Clear global variables«. They are also cleared when QF‑Test terminates. Command line parameters Variables set via the command line are useful in batch mode when you want to perform multiple batch runs with different values. Command line parameters apply for the entire duration of the batch run. A typical example is variable-driven execution across different browsers. Variables can be specified via the command line parameter -variable (cf. chapter 'Command line arguments' in the manual). Test suite variables Test suite variables can be used by all test cases. Their purpose corresponds to that of global variables, except that in batch mode they can be overridden by variables on the command line. Default values (secondary stack) You can define default values for the variables of procedures, test cases and test case sets. These apply if no variable with the same name has been defined at a higher level.","hash":"tut_variable_levels_mobile","h0":"Levels for Variable Definitions"},"856":{"id":856,"content":"Pro Tutorial","hash":"","h0":"The Standard Library (Mobile) | QF‑Test Tutorial"},"857":{"id":857,"content":"Pro Tutorial","hash":"home-link","h0":"The Standard Library (Mobile) | QF‑Test Tutorial"},"858":{"id":858,"content":"The Standard Library (Mobile) This chapter is also available as a video at 'The Standard Library'. QF‑Test provides a certain number of node types that can be used for creating tests. If you need functionality that goes beyond that, you can implement it via script nodes. To make your work easier, many frequently required functions have already been implemented as procedures and are shipped with QF‑Test in a standard procedure library. So if you have a task that cannot be solved using the provided nodes, you should first explore the standard library to see whether you find a suitable or similar solution there. If you find a similar solution, simply copy the existing standard procedure and adapt it to your needs. For information about working with scripts, please see the manual, chapter 12 \"Scripting\". The library is contained in the file qfs.qft and is part of the QF‑Test distribution. Since it is further developed with every QF‑Test version, it is not advisable to modify the shipped standard library. Instead, copy a procedure to your own test suite and adjust it there if needed. In order to use the qfs.qft library, it must be included in the \"Test suite\" root node of your suite under \"Included files\". For new test suites this is done automatically. Select the 'Test suite' root node of your test suite. In the details of the 'Test suite' root node, check that qfs.qft is listed in the \"Included files\" attribute. Add qfs.qft to this list if it is not included yet. No path specification is necessary because the include directory of QF‑Test is automatically part of the library path (see also the reference section of the manual). In the following we describe a selection of the most commonly needed standard procedures. A complete HTML documentation of the standard library can be found via the menu item »Help«-»Standard library qfs.qft...«.","hash":"sec_StandardLibraryMobile","h1":"The Standard Library (Mobile)"},"859":{"id":859,"content":"Pro Tutorial","hash":"","h0":"Exploring the Standard Library | QF‑Test Tutorial"},"860":{"id":860,"content":"Pro Tutorial","hash":"home-link","h0":"Exploring the Standard Library | QF‑Test Tutorial"},"861":{"id":861,"content":"Exploring the Standard Library In addition to inserting procedure calls from the standard library, it is helpful to take a look at how functions are implemented and organized. Open the library itself, i.e. the suite qfs.qft, which is located in the directory qftest-10.0.2-pro/include of your QF‑Test installation.","hash":"sec_StandardLibraryOverviewMobile","h0":"Exploring the Standard Library"},"862":{"id":862,"content":"Figure 34.1: The Standard Library You will see a main package qfs that encloses the specific packages. The qfs package helps to easily identify procedures as belonging to the standard library. In almost all procedures of our library you will notice the use of the variable $(client). This is a standard mechanism to keep test suites independent of a specific SUT. For using the standard library it is required that a valid value for $(client) is set before any of its procedures can be used.","hash":"fig_SuiteQfsQftMobile","h4":"Figure 34.1: The Standard Library"},"863":{"id":863,"content":"Pro Tutorial","hash":"","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"864":{"id":864,"content":"Pro Tutorial","hash":"home-link","h0":"Selected Packages and Procedures | QF‑Test Tutorial"},"865":{"id":865,"content":"Selected Packages and Procedures We now take a closer look at a few selected packages and procedures of the standard library.","hash":"sec_StandardLibraryPackagesMobile","h0":"Selected Packages and Procedures"},"866":{"id":866,"content":"The Android Package The package qfs.run-android contains procedures to execute various ADB commands or to interact with the device. Below is a selection of the available procedures within the package: appControl-resetCurrentApp Resets all data and permissions of the currently focused app and restarts it. dataTransfer-pull Transfers a file or folder from the Android device to the local system. dataTransfer-push Transfers a file or folder from the local system to the Android device. runAdbCommand Executes any ADB command. device-appSwitch Activates the app switch button on the device. device-back Activates the back button on the device. device-home Activates the home button on the device. device-closeKeyboard Closes a potentially open on-screen keyboard. device-setRotation Changes the device's screen orientation.","hash":"sec_the_android_package","h1":"The Android Package"},"867":{"id":867,"content":"The Utils Package The qfs.utils package contains useful procedures for frequently occurring requirements of test development. Here are some procedures of the package: getDate Returns a string that contains a date. By default, the current date is returned. (Other dates are configurable.) getTime Returns a string that contains a time. By default, the current time is returned. (Other times are configurable.) logMemory Writes the current memory usage to the log. printVariable Prints the content of a specified variable to the console. printMessage Prints the content of a specified message to the console. writeMessageIntoFile Writes a specified string into a specified file.","hash":"sec_the_utils_package","h1":"The Utils Package"},"868":{"id":868,"content":"The Check Package The qfs.check package contains procedures that perform checks. The most important procedures are: checkEnabledStatus Checks whether a component is enabled or disabled. In case of an error, the procedure writes a corresponding error to the log. checkSelectedStatus Checks whether a component is selected or not selected. In case of an error, the procedure writes a corresponding error to the log. checkText Checks the text of a component. In case of an error, the procedure writes a corresponding error to the log.","hash":"sec_the_check_package","h1":"The Check Package"},"869":{"id":869,"content":"The Databinder Package The qfs.databinder package contains procedures for execution within a Data driver node to bind data for data-driven testing. The most important procedures are: bindList Binds a list of values to a variable. The values are separated by whitespace or by the delimiter passed as a parameter. bindSets Binds sets of values to a set of variables. The sets of values are separated by line breaks, the values within a set by whitespace or by the delimiter passed as a parameter.","hash":"sec_the_databinder_package","h1":"The Databinder Package"},"870":{"id":870,"content":"Pro Tutorial","hash":"","h0":"Control structures (Mobile) | QF‑Test Tutorial"},"871":{"id":871,"content":"Pro Tutorial","hash":"home-link","h0":"Control structures (Mobile) | QF‑Test Tutorial"},"872":{"id":872,"content":"Control structures (Mobile) The two most important control structures of QF‑Test are loops and the conditional execution of nodes. Loops can be implemented by two different kinds of nodes: While and Loop nodes. If, Elseif and Else nodes are available to implement conditional execution. This chapter is also available as a video tutorial at \"Control Structures\".","hash":"sec_controlstructuresmobile","h1":"Control structures (Mobile)"},"873":{"id":873,"content":"Pro Tutorial","hash":"","h0":"If - else | QF‑Test Tutorial"},"874":{"id":874,"content":"Pro Tutorial","hash":"home-link","h0":"If - else | QF‑Test Tutorial"},"875":{"id":875,"content":"If - else You already came across If nodes in the Setup sequence in the chapter Starting and Connecting the Device. Let's have a closer look at the details of the node.","hash":"sec_ifmobile","h0":"If - else"},"876":{"id":876,"content":"Figure 35.1: Setup Sequence with if-else structures By means of an If node you can control whether certain nodes will be executed or not. In our case, this concerns logging in to the Carconfig app. First, we need to determine whether we are already logged in. This is done via the Wait for component to appear node, which writes either true or false to the notLoggedIn variable.","hash":"fig_ControlsSetupSequenceMobile","h4":"Figure 35.1: Setup Sequence with if-else structures"},"877":{"id":877,"content":"Figure 35.2: Wait for component to appear writes the result into the variable \"notLoggedIn\" The If node has a Condition attribute where you'll find an expression evaluating the result variable notLoggedIn. As we want to refer to its value we need to use the syntax $() (see also note on variable syntax in chapter \"Procedure with a Variable\").","hash":"fig_ControlsWaitForComponentMobile","h4":"Figure 35.2: Wait for component to appear writes the result into the variable \"notLoggedIn\""},"878":{"id":878,"content":"Figure 35.3: If node evaluates the variable Depending on whether you are already logged in, QF‑Test will either execute the nodes contained in the If node or not. In the variable definition table, you can check the value of the notLoggedIn variable. When the first Test case's is executed, the value is true, and thus the condition $(notLoggedIn) is true, which means the login nodes are executed. During the second Test case's, the value is false, and therefore the condition is false. The nodes in the If node are skipped. In an Elseif node, an additional condition is specified, which is evaluated if the condition in the If node is not met. The child nodes of the Else node are only executed if neither the condition of the If node nor that of the Elseif node applies.","hash":"fig_ControlsIfMobile","h4":"Figure 35.3: If node evaluates the variable"},"879":{"id":879,"content":"Pro Tutorial","hash":"","h0":"Loops | QF‑Test Tutorial"},"880":{"id":880,"content":"Pro Tutorial","hash":"home-link","h0":"Loops | QF‑Test Tutorial"},"881":{"id":881,"content":"Loops QF‑Test provides two different kinds of nodes loops: Loop nodes execute their child nodes for a certain number of times. However, you can leave the loop any time using a Break node. While nodes execute their child nodes until a certain condition becomes false. Again, you can leave it any time using a Break node. Loop nodes will always stop after the given number of times. In the case of While nodes, however, you need to make sure that the condition will become false at some point. Otherwise you would have an infinite loop. In interactive mode you can always stop execution by hitting the pause button . In batch mode you would have to kill the QF‑Test process. (You start QF‑Test in batch mode using the command line parameter -batch. Then QF‑Test does not start its UI and just executes the given test suite.) In the following exercise, we will implement a test case that checks whether a specific entry is displayed in the CarConfig demo's list. The actions of the test case will be: Determine the number of list entries. Loop over all entries and check whether each entry matches. Break the loop when a match was found. If the entry was not found, write an error to the log. Please start with recording a check on the entry of interest: Activate the check recording mode by clicking the toolbar button Right-click on a vehicle name in the CarConfig demo and select the »Text« option from the context menu. Stop the recording by pressing . Change the name of the recorded sequence to e.g. 'Check text' Turn the recorded sequence into a test case by right-clicking it and selecting the submenu item »Transform node into«-»Test case« from the popup menu. In general, QF‑Test lets you add nodes very efficiently by packing one node into another one: Open the test case node and pack the recorded Check node into a loop by right-clicking it and selecting the submenu item »Pack nodes«-»Loop« from the popup menu. QF‑Test evaluates dynamically which nodes may be packed into one another and only presents the appropriate ones. So, in case you do not find the 'Loop' submenu item make sure you have right-clicked the correct node. The same holds true for the 'Transform node into' and 'Insert node' methods. In the next series of actions we want to set the value for the Number of iterations attribute of the Loop node. In order to do so we need to find out how many entries the list has. There is no simple node that you could use. However, in the last chapter we learned that the standard library provides a lot of extended functionality. So let's insert the procedure getItemCount from the package qfs.android.list in the standard library. Select the Test case node and press Ctrl⁠+⁠A Press the 'Select procedure' button left to 'Procedure name'. Click the tab 'qfs.qft' in the 'Select procedure' dialog. Navigate to 'getItemCount' in the package 'qfs.android.list' Click 'OK' to select it. Click 'OK' in the 'Procedure call' dialog. Adding a procedure via Ctrl⁠+⁠A was described in Manual creation of procedures. If you would like to check with the screenshots please have a look there. Enter the variable name itemCount in the Variable for return value attribute. Change the default value for the id in the variable definitions table to the QF‑Test component ID of the list, i.e. action_bar_root.list. Click the OK button. Select the Loop node. Enter a reference to the variable $(itemCount) in the Number of iterations attribute of the Loop node. Enter the name of an iteration counter, e.g. i in the respective attribute of the Loop node. Click the OK button. In the next series of actions we will change the recorded item index to the iteration counter and add a variable for the result to the details of the Check node. Then we will add an If node after the Check node evaluating the result, with a Break node within to quit the loop when the row was found. Open the Loop node. Select the Check node. Change the recorded item index of the QF‑Test component ID to the iteration counter $(i). The QF‑Test component ID should now read action_bar_root.list&$(i)@#Label Enter the variable name checkSucceeded in the 'Variable for result' attribute and click the OK button. Right-click the Check node and the submenu item »Insert node «-»Control structures«-»Break« from the popup menu. Click 'OK' in the 'Break' dialog. Pack the Break node into an If node by pressing Ctrl⁠+⁠Shift⁠+⁠I (Of course you can also pack it via the menu). Type $(checkSucceeded) in the 'Condition' attribute of the 'If' node and click the OK button. The variable checkSucceeded will be set to either true or false by the Check node so that the reference to the variable $(checkSucceeded) is all we need to enter in the 'Condition' attribute of the If node. In the next series of actions let's add an Else node as the last node in the Loop node. It will only be entered if all repetitions of the loop were executed, which in our case means that the entry was not found and the check never became true. Collapse the If node if it is open. This is important because otherwise the Else node would belong to the If node and not to the Loop node. Right-click the If node and select the submenu item »Insert node «-»Control structures«-»Else«. Click 'OK' in the 'Else' dialog. Open the Else node. From the standard library insert the procedure logError contained in the package qfs.run-log as described above. Type Entry not found in the value field of message in the Variable definitions table. Change the value of withScreenshots in the Variable definitions table from false to true. Click 'OK' in the 'Break' dialog. When you run tests in batch mode screenshots are a great help for analyzing errors. On the other hand a great number of screenshots lead to a big log-file. This is why the default value for withScreenshots is false. Last, let's complete the test case with Setup and Cleanup nodes and move it into the top part of the test suite. Copy the Setup and Cleanup nodes of 'Test set: Simple Tests' into the new test case as the first and last node. Move the test case from the Extras section into the top section of the test suite after the 'Test set: Simple Tests' node. This is what the new test case would look like:","hash":"sec_loopsmobile","h0":"Loops"},"882":{"id":882,"content":"Figure 35.4: The new test case Execute the new test case. It should run without error. Then modify a value in the details of the Check items node, e.g. change the name of the car to Wrong value.","hash":"fig_ControlsTestcaseMobile","h4":"Figure 35.4: The new test case"},"883":{"id":883,"content":"Figure 35.5: Details of the Check items node Execute the new test case again. This time the Else node should be entered and you should get an error message.","hash":"fig_ControlsCheckDetailsMobile","h4":"Figure 35.5: Details of the Check items node"},"884":{"id":884,"content":"Pro Tutorial","hash":"","h0":"Advanced features of QF‑Test | QF‑Test Tutorial"},"885":{"id":885,"content":"Pro Tutorial","hash":"home-link","h0":"Advanced features of QF‑Test | QF‑Test Tutorial"},"886":{"id":886,"content":"Advanced features of QF‑Test This part of the tutorial covers advanced QF‑Test features. The following chapters use the Java variant of the CarConfigurator, that you already know from the basic tutorial part. It is a Java/Swing application, but the concepts of the topics is the same for each technology. We also provide dedicated test suite files for each chapter, so that you get the chance to take a look at the single topics separately. These files are located in qftest-10.0.2-pro/doc/tutorial/advanced-demos/en.","hash":"sec_advanced","h1":"Advanced features of QF‑Test"},"887":{"id":887,"content":"Pro Tutorial","hash":"","h0":"Data-driven Testing: Running one Test case with different test\n    data | QF‑Test Tutorial"},"888":{"id":888,"content":"Pro Tutorial","hash":"home-link","h0":"Data-driven Testing: Running one Test case with different test\n    data | QF‑Test Tutorial"},"889":{"id":889,"content":"Data-driven Testing: Running one Test case with different test data This chapter explains how data-driven testing can be achieved using QF‑Test. You can find the implementation of the following examples in the demo test suite qftest-10.0.2-pro/doc/tutorial/advanced-demos/en/datadrivenTesting.qft. The second provided test suite qftest-10.0.2-pro/doc/tutorial/datadriver.qft contains further samples like reading an Excel file or creating an iteration over test cases. Please take care to copy all test suites to a project-related folder first and modify them there.","hash":"sec_DataDriven","h0":"Data-driven Testing: Running one Test case with different test data"},"890":{"id":890,"content":"Situation The users of the CarConfigurator can grant several discount levels to their customers. Thus the test designers have figured out three discount levels which have to be tested. Those discount levels are 0%, 10% and 15%. As the workflow of granting discounts is the same for each discount level, we can use the same test case for testing them. The only difference between the test cases is the input of the actual discount level and the price to check. A major advantage of using the same test case is that this avoids side effects caused by several implementations of a Test case, which could have different bugs. Additionally we can reduce the implementation effort. The logical test case, i.e. the steps of the test, for granting a discount will look like this: Start the SUT. Select a vehicle. Specify the discount. Check whether the discount has been used for price calculation. Stop the SUT. The following paragraphs demonstrate how to implement such a scenario.","hash":"sec_dataDriven","h1":"Situation"},"891":{"id":891,"content":"Traditional way of implementing data-driven testing The QF‑Test definition of a Test case node says that a Test case is a workflow together with a specific set of test data. If you have two sets of test data, you have to use two different Test case nodes. Those nodes can be organized within a Test set node. So the conventional way to solve the issue is to implement one Test case per discount level, like depicted below:","hash":"sec_dataDrivenTrad","h1":"Traditional way of implementing data-driven testing"},"892":{"id":892,"content":"Figure 37.1: Traditional way of data-driven testing Those three nodes are grouped within a Test set node. The Test set node also contains the Setup and the Cleanup sequences, which will launch the SUT before each Test case and will stop the SUT after it. This is to ensure that each test case has the same pre-conditions. If you do not want to re-start the SUT between the single test runs, you could add a new Test set to the Test set 'Discount levels' and move the three Test case nodes into that Test set like this:","hash":"fig_dataDrivenTrad1","h4":"Figure 37.1: Traditional way of data-driven testing"},"893":{"id":893,"content":"Figure 37.2: Traditional way with a nested Test set The chapter Dependencies: Automatically ensuring correct prerequisites for each Test case will show up a more elegant and more efficient way of organizing pre-requisites of test cases. As you can imagine this approach could be very exhausting with regards to maintaining test data, especially if we have to add or remove discount levels. Another disadvantage is that we keep the test data within QF‑Test. The next section Data driver concept demonstrates how to organize the test suite to implement the Test case only once and to keep the test data separated from the test case.","hash":"fig_dataDrivenTrad2","h4":"Figure 37.2: Traditional way with a nested Test set"},"894":{"id":894,"content":"Data driver concept If we want to run one test case using different test data sets, we have to define the test data in a data source first. The data source has to be part of a Data driver node. QF‑Test offers built-in data source nodes for database tables, CSV files, Excel files and QF‑Test data tables. A QF‑Test data table will store the data in the test suite itself. This is what we will use for the following example. You can use any other type of data sources, e.g. XML files, too, by implementing your own script for reading the data. Insert a Test set to the test suite first. You can choose whatever name you want. A Data driver node can be inserted into a Test set via right mouse click and then selecting »Insert node«-»Data drivers«-»Data driver«. You have just to specify a name for this node. The actual data source will then be inserted as child node to that Data driver node. For our example we insert a 'Data table' via a right mouse click at the opened Data driver node and select »Insert node«-»Data drivers«-»Data table«. A Data driver node with the following details will be inserted:","hash":"sec_dataDriver20","h1":"Data driver concept"},"895":{"id":895,"content":"Figure 37.3: Data table dialog First we have to specify a name for this data source. We should also define a name for the 'Iteration counter' variable. The iteration counter contains the index of the currently executed test data in the test run The next step is to define the test data. Therefore click on the 'Insert column' button, which is the first button of the 'Data bindings' section. Then you have to define a name for the column, let us set it to 'discount'. After pressing 'OK' you will see that the column has been inserted in the 'Data bindings' area. This column heading will stand for the variable name in the tests later. Now you can use the 'Insert row' button to insert a new row. Each row will stand for one test data set, i.e. you have to insert three rows by now, where the first row contains '0', the second '10' and the third '15'. The table should look like this:","hash":"fig_dataDriver20Dt1","h4":"Figure 37.3: Data table dialog"},"896":{"id":896,"content":"Figure 37.4: The filled data table The next part is the implementation of the test case. Therefore we just insert one Test case node to the Test set. If you want to insert a Test case to a Test set which already contains a Data driver node, you have to select the closed Data driver node to insert it. The Test case will contain the procedure calls for the required test steps. The Setup and Cleanup nodes of the previous example can also be copied to the Test set. The whole Test set will look like this now:","hash":"fig_dataDriver20Dt2","h4":"Figure 37.4: The filled data table"},"897":{"id":897,"content":"Figure 37.5: Test set with Data driver The following step is to make use of the variable 'discount' which has been defined at the 'Data table' node before. We will add that variable as parameter to the 'setDiscount' procedure call. Once we have done this, we have following result:","hash":"fig_dataDriver20TestSet","h4":"Figure 37.5: Test set with Data driver"},"898":{"id":898,"content":"Figure 37.6: Using the $(discount) parameter Now we are ready to launch the Test set. After running the tests we should get at least two errors. Those errors come from the different values of the 'Final price' text-field, but our test always verifies the same value. In our case we should also put the expected values for the 'Final price' fields to our test data via adding a second column to the 'Data table' node.","hash":"fig_dataDriver20ParamTree","h4":"Figure 37.6: Using the $(discount) parameter"},"899":{"id":899,"content":"Figure 37.7: Full data table Another drawback is, that we see the same test case name in the HTML overview report and in the run logs for each test run. To avoid this we can edit the 'Name for reports and run logs' attribute of the Test case node. In that attribute we have to make use of at least one of the test case specific data, i.e. in our case 'discount'. So let us set that attribute to 'Discount $(discount)'.","hash":"fig_dataDriver20Full","h4":"Figure 37.7: Full data table"},"900":{"id":900,"content":"Figure 37.8: Name for run log and report attribute If we rerun the tests now, we should get no error anymore and the run log as well as the HTML report contain three different test case names. Here you can see the created run log file:","hash":"fig_dataDriver20NRR","h4":"Figure 37.8: Name for run log and report attribute"},"901":{"id":901,"content":"Figure 37.9: Run log with different names per Test case If you want to run one Test case only without the whole Test set and its Data driver, it is recommended to set default values for the variables as global ones at Test suite. If the name of the variable in the Data driver is the same like the name of the procedure, you can also skip the variable definition of the Procedure call. This can be done because the variable of the Data driver will be put at QF‑Test's variable stack and so any step within the Test case can access that variable. You can see this behavior in the demo test suite qftest-10.0.2-pro/doc/tutorial/advanced-demos/en/datadrivenTesting.qft in the Test set \"data-driven tests with optimized procedure calls\". In the demo test suite qftest-10.0.2-pro/doc/tutorial/advanced-demos/en/datadrivenTesting.qft you can also find an additional Test set using a CSV file as data source.","hash":"fig_dataDriver20HTML","h4":"Figure 37.9: Run log with different names per Test case"},"902":{"id":902,"content":"Summary The Data driver concept of QF‑Test allows the user to create logical test cases and to keep the test data separated from the test flow itself. It is even possible to use nested Data driver nodes in a Test case. This can be achieved by creating a Test step in a Test case. This Test step can contain the nested Data driver. You can find a more detailed explanation about data-driven testing within QF‑Test in the manual in the chapter Data-driven testing. The second provided test suite qftest-10.0.2-pro/doc/tutorial/datadriver.qft contains further samples like reading an Excel file or creating an iteration over test cases.","hash":"dataDrivenSummary","h1":"Summary"},"903":{"id":903,"content":"Pro Tutorial","hash":"","h0":"Dependencies: Automatically ensuring correct prerequisites for\n    each Test case | QF‑Test Tutorial"},"904":{"id":904,"content":"Pro Tutorial","hash":"home-link","h0":"Dependencies: Automatically ensuring correct prerequisites for\n    each Test case | QF‑Test Tutorial"},"905":{"id":905,"content":"Dependencies: Automatically ensuring correct prerequisites for each Test case Video: Dependencies This chapter explains the dependency concept of QF‑Test. That concept is important for creating robust test cases and for defining recovery activities, if a single test case crashes during the test run. It has been introduced to guarantee that any test case's prerequisites are fulfilled before running it. You can find the following examples in the file qftest-10.0.2-pro/doc/tutorial/ advanced-demos/en/dependencies.qft. There is also a second test suite qftest-10.0.2-pro/doc/tutorial/ advanced-demos/en/dependencies_work.qft to perform your own implementations. Please take care to copy all test suites to a project-related folder first and modify them there.","hash":"sec_AdvDeps","h0":"Dependencies: Automatically ensuring correct prerequisites for each Test case"},"906":{"id":906,"content":"General Please copy the test suite qftest-10.0.2-pro/doc/tutorial/ advanced-demos/en/dependencies_work.qft to a project-related folder first and open it there. Take a look at the first Test set 'Discount Tests'. It contains three different Test case nodes and the respective Setup and Cleanup to launch and stop the SUT before each Test case. That is a typical test suite you might have created yourself.","hash":"sec_depsGeneral","h1":"General"},"907":{"id":907,"content":"Figure 38.1: First Test set of dependencies_work.qft Let us assume you just want to launch one specific Test case, because that one failed or it verifies a specific defect. If you want to do so, you have either to run the whole Test set, because you have to ensure that the prerequisites are fulfilled, or you run the Setup manually and run the according Test case then. As this is a situation which is very common but not easily solvable with the concepts we know already, QF‑Test introduces the Dependencies concept. It is responsible for managing prerequisites of Test cases and allows you to run one Test case directly. In that case QF‑Test will take care of the prerequisites of the Test case, e.g. launching the SUT, selecting a vehicle and so on. A Dependency can contain a Setup, a Cleanup, an Error handler and a Catch node. The Setup of a Dependency will be executed before each Test case. This is because the correct pre-conditions of a Test case are a very important aspect of a robust test run. You could imagine a situation where one Test case closes the SUT because of a mistake. Then the next test case has to launch the SUT again. Exactly for this situation, the Dependency concept provides a very stable and fancy solution. The second aspect of Dependencies is that they optimize the execution of tests. With the current means we have to start the SUT before each Test case and stop the SUT after each. That is no problem for a small application like the CarConfigurator, but for huge applications, like Eclipse/RCP application or any ERP system, this might become insufficient. That is why Dependencies call the Cleanup steps only if required. Another advantage of the Dependencies concept are global Error handler and Catch for recovery management. This feature becomes quite important, if you run lots of test cases in a series and one is failing and preventing the other test cases from continuing execution because of modal error dialogs, e.g. 'OutOfMemoryException'. In a nutshell Dependencies are a place to define the prerequisites of a Test case. very helpful to make test cases more independent from other ones. a better approach of implementing Setup and Cleanup steps. allows you to implement recovery steps in case of errors or exceptions. optimizing test execution. re-usable as they can be defined in the Procedures area. The following sections demonstrate how to use Dependencies.","hash":"fig_depWorkTestSuite","h4":"Figure 38.1: First Test set of dependencies_work.qft"},"908":{"id":908,"content":"Ensuring prerequisites Please copy the test suite qftest-10.0.2-pro/doc/tutorial/ advanced-demos/en/dependencies_work.qft to a project-related folder first and open it there if you haven't done that so far. This file contains a Test set 'Discount Tests' with three Test cases and the conventional implementation using the Setup and Cleanup. We will change this Test set to make use of a Dependency now.","hash":"sec_firstDep","h1":"Ensuring prerequisites"},"909":{"id":909,"content":"Figure 38.2: First Test set of dependencies_work.qft First we have to insert a Dependency node. This can be achieved by a right click at the Test set and then selecting »Insert node«-»Dependencies«-»Dependency«. Specify a name for that Dependency, e.g. \"SUT started\". The next step is to move the Setup and Cleanup nodes into that Dependency. Therefore open the Dependency node and move the mentioned nodes into it. You can do this via drag and drop or via right mouse click »Cut« and »Paste« or Ctrl⁠+⁠X and Ctrl⁠+⁠V. The test suite should now look like this:","hash":"fig_depFirstDepWorkTestSuite","h4":"Figure 38.2: First Test set of dependencies_work.qft"},"910":{"id":910,"content":"Figure 38.3: Sample test suite with the first Dependency Let us test the Dependency now: Please stop all running clients before that, then select one Test case, e.g. 'Discount 10', and run it. You should see that the Test case 'Discount 10' has been executed and the SUT has not been stopped at the end of the test run. Please open the run log to make a deeper analysis of what happened.","hash":"fig_firstDependencySample","h4":"Figure 38.3: Sample test suite with the first Dependency"},"911":{"id":911,"content":"Figure 38.4: The run log of the execution If you open the Test case in the run log, you can see a 'Resolve dependency' node. Open it and there you find two nodes. The last one shows that the Setup has been executed. The other one will be explained in following chapters. So far we have determined that the Setup node will be automatically executed before a Test case, if the Dependency is defined at the Test set level, but the Cleanup has not been executed so far. If you start another Test case now, e.g. 'Discount 15', the already started SUT is used. The Setup node of a Dependency will be executed before each Test case in any case. That is to ensure that the prerequisites are fulfilled for each single Test case. The Cleanup node of a Dependency will only be executed on demand, i.e. if the steps of the Setup of that Dependency are not required anymore. In our case the Cleanup steps did not get executed, because both test cases have the same Dependency. The test execution passed because the Procedure startStop.startApplication already checks whether it's necessary to launch the application or not.","hash":"fig_firstDepSampleRunLog","h4":"Figure 38.4: The run log of the execution"},"912":{"id":912,"content":"Figure 38.5: Procedure startStop.startApplication The next step is to launch the complete Test set by clicking it and pressing 'Run test'. All three tests should pass and the SUT should not be stopped in between. We have achieved an optimized test execution. The Cleanup will not run because all three test cases refer to the same Dependency. We save a lot of time in executing the test cases and we are closer to testing a real life behavior as users usually do not restart the SUT all the time. The next goal is to make that Dependency available for other Test sets in our project. For this you need to move the Dependency node into the Procedures area. Then click at the Test set and insert a Dependency reference node via »Insert node«-»Dependencies«-»Dependency reference«. The dialog looks similar to the Procedure call dialog and you can select the Dependency on the same way. The test suite should now look like this:","hash":"fig_firstDepSampleStart","h4":"Figure 38.5: Procedure startStop.startApplication"},"913":{"id":913,"content":"Figure 38.6: The test suite with a Dependency reference We recommend to add all Dependencies to a separate Package called 'dependencies'. If you run the Test set the first time after moving the Dependency, QF‑Test stops the SUT before the first Test case and re-starts the SUT, because the Dependency from the Test set is different from the Dependency defined in the Procedures node. But this will be explained more detailed in following chapters. Please take a closer look at the second Test set 'Discount Tests with SUT stop' of the demo test suite. The second Test case 'Dicount 10' stops the SUT. But the third Test case also relies on a running SUT. As we know the Dependencies concept already, we should see that the SUT will be started for the third Test case again. That is exactly the advantage of the Dependencies concept.","hash":"fig_firstDepSampleDepRef","h4":"Figure 38.6: The test suite with a Dependency reference"},"914":{"id":914,"content":"Figure 38.7: Ensuring prerequisites for Test case 'Discount 15'","hash":"fig_firstDepEnsuringPreReqs","h4":"Figure 38.7: Ensuring prerequisites for Test case 'Discount 15'"},"915":{"id":915,"content":"Combining dependencies Managing prerequisites can be a more complex matter than just verifying whether the SUT is up and running. In many projects several groups of test cases with different prerequisites like others exist. Let us assume you want to test a big ERP system with more views, like a 'vendor' view and an 'article' view. Then all tests for the 'vendor' view will rely on an opened 'vendor' view and all tests for the 'article' view rely on an opened 'article' view. The opening of the specific view again relies on a logged-in user and the login depends on a started SUT. So you can see something like a tree of prerequisites. QF‑Test allows the user to build such a structure of Dependency nodes via adding Dependency reference nodes to a Dependency. We will build up a small example with just two dependencies for the CarConfigurator now. In the CarConfigurator you can open a 'vehicles' dialog via the menu 'Options' -> 'Vehicles'. We want to create certain tests for that dialog now. Later we want to create some tests on the 'accessory' dialog which can also be opened via the menu via 'Options' -> 'Accessories'. First let us define the tests which we want to create. Test Case 1: Create vehicle 'test1' with price '100'. Start SUT if necessary. Open vehicles dialog via the menu. Specify 'test1' as name and '100' for the price. Press 'New'. Close vehicles dialog via pressing 'Ok'. Open vehicles dialog via the menu. Select the newly created vehicle 'test1'. Close the vehicles dialog via pressing 'Cancel'. Stop SUT if necessary. Test Case 2: Create vehicle 'test2' with price '99999'. Start SUT if necessary. Open vehicles dialog via the menu. Specify 'test2' as name and '99999' for the price. Press 'New'. Close vehicles dialog via pressing 'Ok'. Open vehicles dialog via the menu. Select the newly created vehicle 'test2'. Close the vehicles dialog via pressing 'Cancel'. Stop SUT if necessary. Test Case 3: Create accessory 'testaccessory' with price '12'. Start SUT if necessary. Open accessories dialog via the menu. Specify 'testaccessory' as name and '12' for the price. Press 'New'. Press 'Ok'. Open accessories dialog via the menu. Select the newly created accessory 'testaccessory'. Close the accessories dialog via pressing 'Cancel'. Stop SUT if necessary. Let us take a closer look at the test steps of the tests above. We see that each test case requires a running application, so we should implement the 'Start SUT' step as prerequisite. This has to be done in the Setup of a Dependency. The 'Stop SUT' step is an optional step which can be part of the Cleanup of the Dependency. This 'SUT started' Dependency has been implemented by us in the previous examples already, so we could re-use it. The next issue is that test case 1 and test case 2 require an opened vehicle dialog. Because we plan more tests in that area, we can create a new Dependency 'vehicles dialog opened', which will contain the opening of the dialog as Setup and the closing of the dialog via 'Cancel' as Cleanup. We are able to open this dialog only if the SUT is up and running already, so this Dependency is dependent on the 'SUT started' Dependency. The implementation of that 'open vehicle dialog' Dependency looks like this:","hash":"sec_depCombine","h1":"Combining dependencies"},"916":{"id":916,"content":"Figure 38.8: 'vehicles dialog opened' Dependency In the Setup we have to check whether the dialog is already opened, because a previous test case could have forgotten to close the dialog. The 'Timeout' attribute of the Wait for component to appear node is set to '0' because the dialog is expected to be here. If the dialog is already opened, it is fine and we can continue, otherwise we have to open the dialog. We have to create a Dependency 'accessories dialog opened' as well. This Dependency is similar to the 'vehicles dialog opened' Dependency, but it deals with the accessory dialog instead of the vehicles dialog. After creating those dependencies we have to record the according test steps and create the test cases. The test steps have already been implemented by us and you can find them in the according Package structure in the test suite qftest-10.0.2-pro/doc/tutorial/ advanced-demos/en/dependencies.qft. The test cases should be organized in one Test set called 'Combined Dependencies Tests'. This Test set should contain two more Test sets. The first one is 'Tests for vehicles' and the second one is 'Tests for accessories'. The Test set 'Tests for vehicles' has to contain the implementation of test case 1 and test case 2 and a Dependency reference to the 'vehicles dialog opened' Dependency. The second Test set 'Tests for accessories' has to contain test case 3 and a Dependency reference to the Dependency 'accessories dialog opened'.","hash":"fig_depVehicleDialog","h4":"Figure 38.8: 'vehicles dialog opened' Dependency"},"917":{"id":917,"content":"Figure 38.9: Implementation of specified test cases If you run that Test set now, you will see that QF‑Test stops the SUT first, because that comes from a dependency of the previous examples. Then QF‑Test starts the SUT, performs the steps of test case 1 and then the steps of test case 2. Then it will perform the steps of test case 3. If you take a closer look at the beginning of test case 3 in the run log, you will see that the Cleanup of the 'vehicles dialog opened' Dependency has been executed. That happened because the 'vehicles dialog opened' Dependency was not required anymore. The following test case test case 3 required the 'accessories dialog opened' Dependency. However, both Dependencies require the 'SUT started' Dependency, that is why that Cleanup of the 'SUT started' Dependency has not been executed.","hash":"fig_depVehiclesAccessoriesTest","h4":"Figure 38.9: Implementation of specified test cases"},"918":{"id":918,"content":"Figure 38.10: Run log of nested Dependencies The ability to combine dependencies or to call the Cleanup of dependencies on demand can enable you to put a lot of preparing and cleaning steps into a Dependency. Another use case for the CarConfigurator could be to create a 'Vehicle created' Dependency, which creates a vehicle, which is required for the test and removes it afterwards. That would be an approach to ensure that the test data has been established correctly.","hash":"fig_depRunLogDepCombine","h4":"Figure 38.10: Run log of nested Dependencies"},"919":{"id":919,"content":"Error and exception handling","hash":"sec_depErrorAndCatch","h1":"Error and exception handling"},"920":{"id":920,"content":"Error handling Please copy the test suite qftest-10.0.2-pro/doc/tutorial/ advanced-demos/en/dependencies_work.qft to a project-related folder first and open it there if you haven't done that so far. You can find a Test set 'Tests with error'. The second Test case of that Test set fails.","hash":"sec_depErrorHandler","h2":"Error handling"},"921":{"id":921,"content":"Figure 38.11: Test-suite of Error handler Let us assume that we want to trigger a specific behavior after a test case, but only if it failed. In our case we could stop the SUT to guarantee that the following test case can rely on a clean environment again. We know that the Setup node is executed before each Test case and the Cleanup node will only run on demand. So how could we run specific steps only in case of an error? The solution is the so called Error handler node for a Dependency. You have to click at the closed Cleanup node of that Dependency and insert the Error handler node via right mouse click and selecting »Insert node«-»Dependencies«-»Error handler«. In the Error handler you can define the steps for stopping the SUT again. The Dependency SUT started should look like this now:","hash":"fig_depErrorTestSuite","h4":"Figure 38.11: Test-suite of Error handler"},"922":{"id":922,"content":"Figure 38.12: Dependency with Error handler Please run the whole Test set 'Tests with error' and switch into the run log after the test run has finished. In the run log you can see that the Error handler was executed after the second Test case only.","hash":"fig_depErrorHandlerSample","h4":"Figure 38.12: Dependency with Error handler"},"923":{"id":923,"content":"Figure 38.13: Run log for Dependency with Error handler","hash":"fig_depErrorHandlerSample2","h4":"Figure 38.13: Run log for Dependency with Error handler"},"924":{"id":924,"content":"Exception handling In the previous section we have learned that Error handler nodes contain steps which are executed if the Test case fails. Besides errors also exceptions can occur during a test run. An exception is an unexpected behavior during the test run, e.g. an error dialog appears suddenly or a component could not be found anymore. How should we handle such exceptions? You can find an example Test set 'Tests with exception' in the test suite dependencies_work.qft. Of course you could surround the test steps in each Test case by try-catch and implement a dedicated exception handling in each single Test case, like implemented in the demo Test set. But this approach could lead to a lot of redundancy and makes the Test cases a little bit more unreadable.","hash":"sec_depCatch","h2":"Exception handling"},"925":{"id":925,"content":"Figure 38.14: Try-catch nodes in each Test case Our goal is to reduce the redundancy and to move the exception handling - which is always the same - to one global location. This location will be our Dependency. The first step is adding the Catch node to the Dependency via clicking at the closed Error handler node and selecting »Insert node«-»Control structures«-»Catch« in the menu. Then we can copy the procedure-calls for stopping the SUT into that Catch. Now the try-catch nodes in the single test cases become unnecessary. Please move the procedure-calls out of the Try and remove the empty try-catch structure. Your test suite should look like this now:","hash":"fig_depCatchTryEachTest","h4":"Figure 38.14: Try-catch nodes in each Test case"},"926":{"id":926,"content":"Figure 38.15: Test-suite with Catch Now you can start the Test set 'Test with exception'. The second Test case throws an IndexNotFoundException, because the selected vehicle does not exist. It is intended to handle that exception in the Catch of the Dependency. If the debugger is activated, QF‑Test interrupts the test run at the place where the exception arises. In this case you might have to re-throw the exception via the 'Rethrow exception' button. An alternative is to deactivate the debugger via »Debugger«-»Enable debugger«. After the test run you can open the run log and verify what happened.","hash":"fig_depCatchTestSuite","h4":"Figure 38.15: Test-suite with Catch"},"927":{"id":927,"content":"Figure 38.16: Run log of a Dependency with Catch In a normal project you should at least try to catch a 'TestException' and the Catch should contain a procedure call of either qfs.swing.cleanup.closeAllModalDialogs, qfs.fx.cleanup.closeAllModalDialogs or qfs.swt.cleanup.closeAllModalDialogsAndModalShells. Those procedures close all modal dialogs, e.g. dialog windows, which are blocking the execution.","hash":"fig_depRunLogCatchDep","h4":"Figure 38.16: Run log of a Dependency with Catch"},"928":{"id":928,"content":"Summary You have seen that you can implement a very strong recovery system for your test cases using the Error handler and, even more important, the Catch of Dependencies. In most projects the global Catch node becomes very important, especially if ComponentNotFoundExceptions and ModalDialogExceptions appear.","hash":"sec_depErrorCatchSum","h2":"Summary"},"929":{"id":929,"content":"More about dependencies In the previous sections we have learned that we can combine several dependencies and that the Cleanup of a Dependency is only executed, if the stack of combined dependencies changes. We could also instruct a Dependency to call its Cleanup every time after a Test case. This can be achieved by checking the attribute 'Forced cleanup' of the Dependency. There are even more interesting features about dependencies, e.g. you can use a variable instructing QF‑Test to run the Cleanup. This variable is called 'Characteristic variable'. You will find more details about that feature in the manual at chapter Dependencies. This approach could be used to create one 'user login' Dependency which will only run through its Cleanup, i.e. perform the logout, if another user is required by the next Test case. A detailed description of dependencies can be found in the manual at chapter Dependencies.","hash":"sec_depMoreDep","h1":"More about dependencies"},"930":{"id":930,"content":"Pro Tutorial","hash":"","h0":"Automated creation of basic procedures | QF‑Test Tutorial"},"931":{"id":931,"content":"Pro Tutorial","hash":"home-link","h0":"Automated creation of basic procedures | QF‑Test Tutorial"},"932":{"id":932,"content":"Automated creation of basic procedures This chapter describes how procedures for each UI component can be created automatically by QF‑Test. The advantage of this approach is that you do not need to record each step of your tests manually. Furthermore you will also get a standardized structure of Packages and Procedures for testing all dialogs of your SUT. You can find the following examples in the file qftest-10.0.2-pro/doc/tutorial/advanced-demos/en/automated_procedures.qft . There is also a second test suite qftest-10.0.2-pro/doc/tutorial/advanced-demos/en/automated_procedures_work.qft to perform your own implementations. Please take care to copy all test suites to a project-related folder first and modify them there.","hash":"sec_AdvProcbuilder","h0":"Automated creation of basic procedures"},"933":{"id":933,"content":"General If we want to create tests for all features of the CarConfigurator, we have to record steps on each element that will be touched by a test. The CarConfigurator is a small application with five dialogs and perhaps approximately thirty graphical elements. So creating all important test cases for this application can be achieved within one or two days. But imagine a big project like an ERP system with about fifty dialogs and hundreds of elements. Creating test cases for such a huge system will definitely take longer and also the maintenance of recorded tests could become quite difficult. As first organizational step we recommend to record each test step as a Procedure and call it from the Test cases requiring it. If you organize your tests in different test suites, you could split those test suites into two levels. The first level contains only UI component related procedures and the second level contains only test cases calling procedures of level one. The approach of implementing each test step as procedure brings us to a situation where we could split the work into two parts: Creating and maintaining the procedures representing the test steps Creating and maintaining the test cases QF‑Test brings a feature which creates that basic procedures for each UI component automatically. The usage of this feature should drastically minimize the time for creating test suites and test cases and supports you in making easier maintainable test suites. You can find a demo suite containing some test cases created by this qftest-10.0.2-pro/doc/tutorial/advanced-demos/en/automated_procedures.qft .","hash":"sec_apbGeneral","h1":"General"},"934":{"id":934,"content":"Figure 39.1: Screenshot of test suite The following sections demonstrate how to create those procedures and organize your test cases.","hash":"fig_advPbTestSuite","h4":"Figure 39.1: Screenshot of test suite"},"935":{"id":935,"content":"Automated creation of procedures Please copy the demo test suite qftest-10.0.2-pro/doc/tutorial/advanced-demos/en/automated_procedures_work.qft to a project-related folder and open it there. This test suite contains a Test set referring to a 'Start SUT' Dependency.","hash":"sec_abpCreation","h1":"Automated creation of procedures"},"936":{"id":936,"content":"Figure 39.2: The test suite automated_procedures_work.qft First we have to launch the SUT via selecting the Dependency reference and pressing 'Start test run'. Once the SUT is up and running we are ready to record the test steps. Normally we would press the 'Start recording' button, then record the according test steps and then press 'Stop recording'. After that we would re-organize the recorded steps, i.e. generating procedures and parametrizing them. Exactly those steps can be performed automatically now. Let us generate the basic procedures for the main window first. Before we can start, please modify the settings of QF‑Test. Open the QF‑Test options via »Edit«-»Options«. Then switch to 'Record' -> 'Procedures'. Please change the value for the 'Configuration file for recorded procedures' to the full path of the demo configuration test suite at qftest-10.0.2-pro/demo/procbuilder/carconfig-procbuilderdef.qft. Then close the 'Options' via pressing 'OK'. You will see more details about that file in the following chapters. After altering the settings proceed with following steps: Press the 'Record procedures' button. Perform a right mouse-click in the SUT. Select 'Whole window'. Press the 'Record procedures' button again. Now QF‑Test creates the basic procedures of the main window. You should see a new Package called procbuilder under Procedures of your test suite. This package contains several packages and procedures for actions on the whole dialog and its single UI components. The current configuration created a Package JCarConfigurator under the procbuilder Package. This Package is indicated to be the container for all actions performed on the main window.","hash":"fig_autoProcSuite","h4":"Figure 39.2: The test suite automated_procedures_work.qft"},"937":{"id":937,"content":"Figure 39.3: The recorded procedures Please note that the involved components have also been recorded in Windows and components. The next step is to check which procedures are useful for us and which are obsolete. Let us take a closer look at the created Packages:","hash":"fig_autoProcFirstRecord","h4":"Figure 39.3: The recorded procedures"},"938":{"id":938,"content":"Package Content JCarConfigurator This package contains all procedures for actions on components of the CarConfigurator window. It has been created because the configuration file uses the component hierarchy for creating the package structure. Table 39.1: The Package JCarConfigurator contains several packages which are:","hash":"table_39.1","h4":"Figure 39.3: The recorded procedures"},"939":{"id":939,"content":"Package Content MenuBar This package contains procedures for clicking at the items of the menu. VehicleTablePanel This package contains all procedures for actions on components on the 'VehicleTable' panel of the SUT. In our case there are only procedures for the 'VehicleTable' object, because that is the only component on that panel. check This package contains procedures for checking components. check-window This package contains procedures which can be called to check the components of one frame using one call. Those procedures are container procedures. get This package contains procedures for getting the current values of components, e.g. reading the text of a text-field. select This package contains procedures for selecting items of elements - in our case only one procedure to select a tab in the TabbedPane. set This package contains procedures for setting several components of the current window - in our case several setters for the text fields of the frame. set-window This package contains procedures setting several component of certain frames or dialogs - in our case one procedure calling all procedure for the package 'set' of the JCarConfigurator frame. Those container procedures are typical workflow procedures. wait This package contains all procedure waiting for several components. Table 39.2: In our case all procedures might be useful. So we can move the whole 'JCarConfigurator' Package from the procbuilder Package directly under the Procedures node. Press 'Yes' on the occurring 'Update Reference' dialog. Now the procedures can be used by test cases or other procedures. Finally our test suite should look like this:","hash":"table_39.2","h4":"Figure 39.3: The recorded procedures"},"940":{"id":940,"content":"Figure 39.4: The test suite containing the procedures Repeat that recording now for the 'Specials' and the 'Accessories' panel and just move the respective procedures or packages for the important components to the 'JCarConfigurator' package. In our case these are only the packages 'SpecialsPanel' and 'AccessoryTablePanel'. The full test suite should then look like this:","hash":"fig_autoProcTestSuite1","h4":"Figure 39.4: The test suite containing the procedures"},"941":{"id":941,"content":"Figure 39.5: The procedures for all panels We are ready for creating test cases using the automatically recorded test steps. You could of course also repeat that recording for all other dialogs, e.g. the 'Vehicles' dialog which can be reached via the menu 'Options' -> 'Vehicles' as well as for the 'Accessories' and 'Specials' dialogs. You do not need to record the whole window all the time. You could also select 'Component only' to record one dedicated component or 'Component with children' to record procedures for a certain panel.","hash":"fig_autoProcTestSuite2","h4":"Figure 39.5: The procedures for all panels"},"942":{"id":942,"content":"Configuration of the automated creation","hash":"sec_apbConf","h1":"Configuration of the automated creation"},"943":{"id":943,"content":"Introduction In the previous example we used the file qftest-10.0.2-pro/demo/procbuilder/carconfig-procbuilderdef.qft as configuration file for the automated creation. In this section we want to take a closer look at the configuration capabilities of QF‑Test. So please open that file.","hash":"sec_apbConfIntro","h2":"Introduction"},"944":{"id":944,"content":"Figure 39.6: The current configuration The package procbuilder is the root-package for all created packages. If you want to use another name for the automatically created procedures, feel free to rename the package. If you open that package, you can see the 'class' level. This level describes the classes of the UI components which should be taken into account for creating the packages. The next levels contains information about the created package structure and procedures. You can find a detailed description of those capabilities in the manual in chapter The Procbuilder definition file.","hash":"fig_apbConfiguration","h4":"Figure 39.6: The current configuration"},"945":{"id":945,"content":"First example In our first example we want to create a new settings file which we will build up step by step. Please perform following actions at the beginning: Open a new test suite file and save it. Specify a name like 'mySettings.qft' or something similar. Create a new Package with the name 'myProcedures'. The new test suite should look like this:","hash":"sec_apbFirstExample","h2":"First example"},"946":{"id":946,"content":"Figure 39.7: The own configuration file Now we are ready to configure procedure templates for specific classes. Let us create procedures for the text-fields on the main panel of the CarConfigurator first. It might be interesting for our project to check the content of those text-fields, so we need to create procedures for checking the text of each text-field. To create those procedures we have to insert a new package to the package 'myProcedures'. Please call that package 'javax_swing_JTextField'. 'javax.swing.JTextField' is the class of those text-fields, but we have to use '_' in the package's name, because '.' is not allowed in that attribute. This package will instruct QF‑Test to create the procedures in it, if it meets a component of the class 'javax.swing.JTextField' only. That is an important aspect, because we should realize that procedure templates can be created per classes of components. Consecutively we want to create a template for a procedure checking the text of a component. The template procedure has to be part of another package. The name of this package should indicate its purpose, e.g. 'checkers'. After creating the 'checkers' package you can add a procedure 'checkText' to it. The procedure should contain a 'Check Text' node which is meant to check the text of components. Please insert such a 'Check text' node via right mouse click at the expanded procedure and »Insert node«-»Check nodes«-»Check Text«. Specify $(client) as client, 'dummy' as QF‑Test component ID and $(text) as text. Of course, after confirming these entries, we will get a warning that a component named 'dummy' does not exist. In this case we are allowed to ignore this warning. The test suite will then look like this:","hash":"fig_apbOwnConf1","h4":"Figure 39.7: The own configuration file"},"947":{"id":947,"content":"Figure 39.8: The checkText procedure The procedure contains an empty default value for the parameter 'text'.","hash":"fig_apbOwnConfProc","h4":"Figure 39.8: The checkText procedure"},"948":{"id":948,"content":"Figure 39.9: The checkText procedure with parameters Now we have nearly completed our first procedure template, but we have to think about one more issue. Each component has its specific and unique QF‑Test ID, so it would be great to use that QF‑Test ID attribute immediately during creation, otherwise we have to do that manually afterwards. We also want the procedure to have a component-related name instead of 'checkText' only. The place holder <COMPID> points out to QF‑Test to replace it with the QF‑Test ID of the current component. So we have to change the procedure name to checkText_<COMPID> and we have to insert the <COMPID> place holder directly in the QF‑Test component ID attribute of the 'Check text' node. Finally the template procedure should look like this:","hash":"fig_apbOwnConfParams","h4":"Figure 39.9: The checkText procedure with parameters"},"949":{"id":949,"content":"Figure 39.10: Using the <COMPID> place holder We are ready to begin now. First we have to order QF‑Test to use that file. That is achieved via the options of QF‑Test. Open the options dialog via »Edit«-»Options« and change to 'Record' -> 'Procedures.' Specify the path of your 'mySettings.qft' for the 'Configuration file for recorded procedures' and press 'OK'. Then start the CarConfigurator again. Once it is up and running, please proceed with following steps: Press the 'Record procedures' button. Perform a right mouse-click in the SUT. Select 'Whole window'. Press the 'Record procedures' button again. Congratulations, you have instructed QF‑Test to record test steps for you.","hash":"fig_apbOwnConfPlaceholderCompId","h4":"Figure 39.10: Using the <COMPID> place holder"},"950":{"id":950,"content":"Figure 39.11: Your first automatically created procedures","hash":"fig_apbOwnConfFirstCreation","h4":"Figure 39.11: Your first automatically created procedures"},"951":{"id":951,"content":"Using the current text for checking The 'checkText' procedures have a parameter 'text' for the text to check. Up to now we have to specify that value each time we call that Procedure of the according text-field. Let us assume we have a scenario where we intend to check the default values of the CarConfigurator after its startup. In this case we would have to add the single procedure calls of all four 'checkText' procedures and specify the according values. However, QF‑Test offers a place holder to set the current value of a text-field automatically to the created procedures. Therefore we have to change the default-value of the 'text' parameter to <CURRENTVALUE> in our configuration test suite. After that you have to ensure that the myProcedures package doesn't exist under the Procedures node anymore, then re-create the packages like in the previous example. Otherwise QF‑Test will create a package myProcedures1 to ensure that each creation process has its own unique target package. The configuration file looks like this:","hash":"sec_apbCurrentText","h2":"Using the current text for checking"},"952":{"id":952,"content":"Figure 39.12: The configuration for the current text The newly created procedures displays like below:","hash":"fig_apbExampleCurrentText","h4":"Figure 39.12: The configuration for the current text"},"953":{"id":953,"content":"Figure 39.13: The created procedures with the current text","hash":"fig_apbExampleCurrentText2","h4":"Figure 39.13: The created procedures with the current text"},"954":{"id":954,"content":"Creating container procedures In the previous example we have created the 'checkText' procedure for checking single text-fields. Now you should be able to create a 'set' procedure for setting the text of a text-field or a 'press' procedure for pressing a button. Those procedures are created similarly. Keep in mind that all those procedures work with one single component. In some test scenarios it might be interesting to call one procedure for checking all components of a specific dialog or specific panel or to fill all visible text-fields. Because such procedures deal with components which act as containers, we call those procedures 'container'-procedures. In our case we could consider one procedure calling all single 'checkText' procedures of the CarConfigurator. But how to create such a procedure like that? First of all add a new 'class'-package to your 'mySettings.qft' file with the name 'javax_swing_JFrame'. The main window of the JCarConfigurator is an instance of javax.swing.JFrame, that is why we have to use that specific package name. The 'class'-package has to contain a 'type'-package which we call 'checkers-window' now. The 'type'-package has to contain a procedure checkTextOfElements_<COMPID>, intended to perform the actual checks. We use the <COMPID> placeholder again for the procedure name to determine which dialog is affected by the created procedures. The next step is to specify the procedure content. Let us see how we can configure this. We have four text-fields which can be checked by using the same procedure checkText_<COMPID>. QF‑Test allows to call all four procedures with just one configured Procedure call node. Therefore insert a Procedure call for the procedure javax_swing_JTextField.checkers.checkText_<CCOMPID>. The configuration file should look like below:","hash":"sec_abpContainer","h2":"Creating container procedures"},"955":{"id":955,"content":"Figure 39.14: The template for container procedures The last step is to make QF‑Test to create a 'container' procedure and not a normal 'component' procedure. This can be achieved by setting @FORCHILDREN in the comment attribute of the checkTextOfElements_<COMPID> procedure.","hash":"fig_apbContainerExample","h4":"Figure 39.14: The template for container procedures"},"956":{"id":956,"content":"Figure 39.15: Usage of @FORCHILDREN tag Now you can record the procedures like in the previous examples. Do not forget to remove the 'myProcedures' from Procedures before. You should then get something like this under Procedures:","hash":"fig_apbForChildrenTag","h4":"Figure 39.15: Usage of @FORCHILDREN tag"},"957":{"id":957,"content":"Figure 39.16: The created container procedures QF‑Test replaces the 'class' part of the procedure-calls by the top package of the configuration. In our case this is 'myProcedures'.","hash":"fig_apbCreatedContainer","h4":"Figure 39.16: The created container procedures"},"958":{"id":958,"content":"Using the current value of child components We could meet a similar situation like in the example Using the current text for checking, where we want to record the current values of each text-field during creation. In the example Using the current text for checking we used <CURRENTVALUE>. Now we have to specify the current text as parameter at the procedure-call in the 'container'-procedure 'checkTextElements'. Therefore we add the parameter 'text' to the procedure-call in your 'mySettings.qft' file and the value should be <CCURRENTVALUE>.","hash":"sec_apbCurrentChildValue","h2":"Using the current value of child components"},"959":{"id":959,"content":"Figure 39.17: Configuration of <CCURRENTVALUE> If you create the procedures again, you will see the current values at the procedure-calls. Please do not forget to remove the 'myProcedures' package from Procedures.","hash":"fig_apbContainerCurrentText","h4":"Figure 39.17: Configuration of <CCURRENTVALUE>"},"960":{"id":960,"content":"Figure 39.18: Test-suite using <CCURRENTVALUE> If you take a closer look at the created procedure 'checkTextElements_', you will see that each procedure-call gets the parameter text. Perhaps it might be convenient for test development to set the according 'text' parameters as default values for the 'container'-procedure. To achieve this you have to add one more parameter to the procedure call in the settings file. The name of the parameter has to be <CCOMPID> and the value will be <CCURRENTVALUE>. Then you have to change the value of the text parameter of that procedure-call to $(<CCOMPID>). The configuration should look like this now:","hash":"fig_apbContainerCurrentTextTestSuite","h4":"Figure 39.18: Test-suite using <CCURRENTVALUE>"},"961":{"id":961,"content":"Figure 39.19: Parameters for container procedures If you create the procedures again, you will see that the 'checkTextElements' procedure has four more parameters with the current value of the elements as default values. Additionally each single procedure call uses a variable - named after the component-id - as 'text' parameter.","hash":"fig_apbContainerParams","h4":"Figure 39.19: Parameters for container procedures"},"962":{"id":962,"content":"Figure 39.20: Parameters for container procedures in test suite","hash":"fig_apbContainerParamsTestSuite","h4":"Figure 39.20: Parameters for container procedures in test suite"},"963":{"id":963,"content":"More configuration capabilities As you have seen in the previous sections there is a lot of configuration capability for the automated creation of basic procedures. But there are even more options available. Please take a look at the manual chapter The Procbuilder definition file.","hash":"sec_apbMore","h2":"More configuration capabilities"}},"docInfo":{"0":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"1":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"2":{"content":1,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"3":{"content":171,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"4":{"content":219,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"5":{"content":26,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"6":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"7":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"8":{"content":63,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"9":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"10":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"11":{"content":26,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"12":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"13":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"14":{"content":74,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"15":{"content":65,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"16":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"17":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"18":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"19":{"content":13,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"20":{"content":57,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"21":{"content":150,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"22":{"content":4,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"23":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"24":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"25":{"content":15,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"26":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"27":{"content":101,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"28":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"29":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"30":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"31":{"content":19,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"32":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"33":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"34":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"35":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"36":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"37":{"content":62,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"38":{"content":84,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"39":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"40":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"41":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"42":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"43":{"content":139,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"44":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"45":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"46":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"47":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"48":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"49":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"50":{"content":51,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"51":{"content":60,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"52":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"53":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"54":{"content":49,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"55":{"content":77,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"56":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"57":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"58":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"59":{"content":39,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"60":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"61":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"62":{"content":50,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"63":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"64":{"content":68,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"65":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"66":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"67":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"68":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"69":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"70":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"71":{"content":9,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"72":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"73":{"content":44,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"74":{"content":49,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"75":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"76":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"77":{"content":83,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"78":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"79":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"80":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"81":{"content":160,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"82":{"content":101,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"83":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"84":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"85":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"86":{"content":115,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"87":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"88":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"89":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"90":{"content":58,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"91":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"92":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"93":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"94":{"content":73,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"95":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"96":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"97":{"content":54,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"98":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"99":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"100":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"101":{"content":68,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"102":{"content":52,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"103":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"104":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"105":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"106":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"107":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"108":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"109":{"content":82,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"110":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"111":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"112":{"content":29,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"113":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"114":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"115":{"content":63,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"116":{"content":269,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"117":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"118":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"119":{"content":205,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"120":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"121":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"122":{"content":438,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"123":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"124":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"125":{"content":502,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"126":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"127":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"128":{"content":205,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"129":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"130":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"131":{"content":39,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"132":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"133":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"134":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"135":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"136":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"137":{"content":63,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"138":{"content":34,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"139":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"140":{"content":151,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"141":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"142":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"143":{"content":58,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"144":{"content":33,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"145":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"146":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"147":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"148":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"149":{"content":59,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"150":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"151":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"152":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"153":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"154":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"155":{"content":87,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"156":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"157":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"158":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"159":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"160":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"161":{"content":65,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"162":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"163":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"164":{"content":27,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"165":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"166":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"167":{"content":13,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"168":{"content":138,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"169":{"content":109,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"170":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"171":{"content":117,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"172":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"173":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"174":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"175":{"content":40,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"176":{"content":126,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"177":{"content":153,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"178":{"content":103,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"179":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"180":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"181":{"content":86,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"182":{"content":256,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"183":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"184":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"185":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"186":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"187":{"content":111,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"188":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"189":{"content":102,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"190":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"191":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"192":{"content":285,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"193":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"194":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"195":{"content":193,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"196":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"197":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"198":{"content":31,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"199":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"200":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"201":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"202":{"content":28,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"203":{"content":72,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"204":{"content":30,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"205":{"content":26,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"206":{"content":21,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"207":{"content":56,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"208":{"content":41,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"209":{"content":46,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"210":{"content":167,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"211":{"content":52,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"212":{"content":44,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"213":{"content":70,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"214":{"content":59,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"215":{"content":87,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"216":{"content":46,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"217":{"content":60,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"218":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"219":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"220":{"content":35,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"221":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"222":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"223":{"content":19,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"224":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"225":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"226":{"content":137,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"227":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"228":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"229":{"content":191,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"230":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"231":{"content":172,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"232":{"content":278,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"233":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"234":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"235":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"236":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"237":{"content":86,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"238":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"239":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"240":{"content":98,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"241":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"242":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"243":{"content":26,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"244":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"245":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"246":{"content":74,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"247":{"content":65,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"248":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"249":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"250":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"251":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"252":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"253":{"content":144,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"254":{"content":6,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"255":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"256":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"257":{"content":15,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"258":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"259":{"content":100,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"260":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"261":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"262":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"263":{"content":19,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"264":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"265":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"266":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"267":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"268":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"269":{"content":62,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"270":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"271":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"272":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"273":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"274":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"275":{"content":135,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"276":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"277":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"278":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"279":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"280":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"281":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"282":{"content":54,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"283":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"284":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"285":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"286":{"content":49,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"287":{"content":78,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"288":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"289":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"290":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"291":{"content":39,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"292":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"293":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"294":{"content":53,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"295":{"content":72,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"296":{"content":60,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"297":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"298":{"content":44,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"299":{"content":49,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"300":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"301":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"302":{"content":9,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"303":{"content":63,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"304":{"content":44,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"305":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"306":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"307":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"308":{"content":83,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"309":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"310":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"311":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"312":{"content":160,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"313":{"content":101,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"314":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"315":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"316":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"317":{"content":109,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"318":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"319":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"320":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"321":{"content":58,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"322":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"323":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"324":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"325":{"content":73,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"326":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"327":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"328":{"content":55,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"329":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"330":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"331":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"332":{"content":68,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"333":{"content":52,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"334":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"335":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"336":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"337":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"338":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"339":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"340":{"content":82,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"341":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"342":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"343":{"content":29,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"344":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"345":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"346":{"content":63,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"347":{"content":269,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"348":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"349":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"350":{"content":276,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"351":{"content":122,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"352":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"353":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"354":{"content":305,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"355":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"356":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"357":{"content":459,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"358":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"359":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"360":{"content":502,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"361":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"362":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"363":{"content":202,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"364":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"365":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"366":{"content":37,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"367":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"368":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"369":{"content":84,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"370":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"371":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"372":{"content":63,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"373":{"content":34,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"374":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"375":{"content":150,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"376":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"377":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"378":{"content":58,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"379":{"content":33,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"380":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"381":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"382":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"383":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"384":{"content":59,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"385":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"386":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"387":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"388":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"389":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"390":{"content":87,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"391":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"392":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"393":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"394":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"395":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"396":{"content":65,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"397":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"398":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"399":{"content":40,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"400":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"401":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"402":{"content":13,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"403":{"content":118,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"404":{"content":109,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"405":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"406":{"content":117,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"407":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"408":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"409":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"410":{"content":40,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"411":{"content":126,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"412":{"content":153,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"413":{"content":103,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"414":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"415":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"416":{"content":86,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"417":{"content":256,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"418":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"419":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"420":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"421":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"422":{"content":111,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"423":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"424":{"content":102,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"425":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"426":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"427":{"content":285,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"428":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"429":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"430":{"content":193,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"431":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"432":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"433":{"content":31,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"434":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"435":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"436":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"437":{"content":25,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"438":{"content":68,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"439":{"content":26,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"440":{"content":22,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"441":{"content":38,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"442":{"content":52,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"443":{"content":44,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"444":{"content":70,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"445":{"content":59,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"446":{"content":87,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"447":{"content":46,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"448":{"content":60,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"449":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"450":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"451":{"content":35,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"452":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"453":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"454":{"content":18,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"455":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"456":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"457":{"content":159,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"458":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"459":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"460":{"content":191,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"461":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"462":{"content":172,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"463":{"content":278,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"464":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"465":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"466":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"467":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"468":{"content":86,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"469":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"470":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"471":{"content":83,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"472":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"473":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"474":{"content":26,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"475":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"476":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"477":{"content":74,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"478":{"content":65,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"479":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"480":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"481":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"482":{"content":13,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"483":{"content":50,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"484":{"content":115,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"485":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"486":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"487":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"488":{"content":15,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"489":{"content":72,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"490":{"content":97,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"491":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"492":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"493":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"494":{"content":19,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"495":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"496":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"497":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"498":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"499":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"500":{"content":62,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"501":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"502":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"503":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"504":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"505":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"506":{"content":136,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"507":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"508":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"509":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"510":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"511":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"512":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"513":{"content":52,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"514":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"515":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"516":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"517":{"content":49,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"518":{"content":78,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"519":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"520":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"521":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"522":{"content":39,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"523":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"524":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"525":{"content":51,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"526":{"content":95,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"527":{"content":22,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"528":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"529":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"530":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"531":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"532":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"533":{"content":9,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"534":{"content":87,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"535":{"content":44,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"536":{"content":49,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"537":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"538":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"539":{"content":108,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"540":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"541":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"542":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"543":{"content":160,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"544":{"content":101,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"545":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"546":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"547":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"548":{"content":115,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"549":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"550":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"551":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"552":{"content":58,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"553":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"554":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"555":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"556":{"content":73,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"557":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"558":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"559":{"content":54,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"560":{"content":13,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"561":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"562":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"563":{"content":68,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"564":{"content":52,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"565":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"566":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"567":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"568":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"569":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"570":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"571":{"content":82,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"572":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"573":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"574":{"content":29,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"575":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"576":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"577":{"content":63,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"578":{"content":268,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"579":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"580":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"581":{"content":200,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"582":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"583":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"584":{"content":37,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"585":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"586":{"content":10,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"587":{"content":84,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"588":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"589":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"590":{"content":63,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"591":{"content":34,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"592":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"593":{"content":150,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"594":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"595":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"596":{"content":58,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"597":{"content":33,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"598":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"599":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"600":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"601":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"602":{"content":59,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"603":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"604":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"605":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"606":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"607":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"608":{"content":87,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"609":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"610":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"611":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"612":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"613":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"614":{"content":65,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"615":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"616":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"617":{"content":40,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"618":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"619":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"620":{"content":13,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"621":{"content":138,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"622":{"content":109,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"623":{"content":16,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"624":{"content":117,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"625":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"626":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"627":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"628":{"content":40,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"629":{"content":126,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"630":{"content":153,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"631":{"content":103,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"632":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"633":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"634":{"content":86,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"635":{"content":256,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"636":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"637":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"638":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"639":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"640":{"content":111,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"641":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"642":{"content":102,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"643":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"644":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"645":{"content":285,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"646":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"647":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"648":{"content":193,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"649":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"650":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"651":{"content":31,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"652":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"653":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"654":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"655":{"content":13,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"656":{"content":52,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"657":{"content":44,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"658":{"content":70,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"659":{"content":59,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"660":{"content":87,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"661":{"content":46,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"662":{"content":60,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"663":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"664":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"665":{"content":35,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"666":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"667":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"668":{"content":18,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"669":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"670":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"671":{"content":159,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"672":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"673":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"674":{"content":191,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"675":{"content":39,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"676":{"content":172,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"677":{"content":278,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"678":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"679":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"680":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"681":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"682":{"content":86,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"683":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"684":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"685":{"content":62,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"686":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"687":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"688":{"content":19,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"689":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"690":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"691":{"content":84,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"692":{"content":72,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"693":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"694":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"695":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"696":{"content":39,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"697":{"content":42,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"698":{"content":203,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"699":{"content":5,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"700":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"701":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"702":{"content":12,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"703":{"content":69,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"704":{"content":99,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"705":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"706":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"707":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"708":{"content":20,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"709":{"content":26,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"710":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"711":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"712":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"713":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"714":{"content":62,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"715":{"content":83,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"716":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"717":{"content":85,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"718":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"719":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"720":{"content":136,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"721":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"722":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"723":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"724":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"725":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"726":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"727":{"content":39,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"728":{"content":67,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"729":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"730":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"731":{"content":35,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"732":{"content":78,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"733":{"content":83,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"734":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"735":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"736":{"content":22,"h-1":0,"h0":0,"h1":5,"h2":0,"h3":0,"hash":1},"737":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"738":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"739":{"content":36,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"740":{"content":83,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"741":{"content":37,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"742":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"743":{"content":41,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"744":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"745":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"746":{"content":32,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"747":{"content":42,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"748":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"749":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"750":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"751":{"content":40,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"752":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"753":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"754":{"content":53,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"755":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"756":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"757":{"content":122,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"758":{"content":96,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"759":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"760":{"content":23,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"761":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"762":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"763":{"content":61,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"764":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"765":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"766":{"content":57,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"767":{"content":15,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"768":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"769":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"770":{"content":78,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"771":{"content":57,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"772":{"content":34,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"773":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"774":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"775":{"content":19,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"776":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"777":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"778":{"content":93,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"779":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"780":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"781":{"content":48,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"782":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"783":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"784":{"content":68,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"785":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"786":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"787":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"788":{"content":96,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"789":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"790":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"791":{"content":184,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"792":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"793":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"794":{"content":51,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"795":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"796":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"797":{"content":94,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"798":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"799":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"800":{"content":57,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"801":{"content":35,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"802":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"803":{"content":139,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"804":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"805":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"806":{"content":70,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"807":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"808":{"content":20,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"809":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"810":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"811":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"812":{"content":67,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"813":{"content":38,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"814":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"815":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"816":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":0},"817":{"content":2,"h-1":0,"h0":7,"h1":0,"h2":0,"h3":0,"hash":2},"818":{"content":104,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":1},"819":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"820":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"821":{"content":45,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"822":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"823":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"824":{"content":105,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"825":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"826":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"827":{"content":43,"h-1":0,"h0":0,"h1":4,"h2":0,"h3":0,"hash":1},"828":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"829":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"830":{"content":14,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"831":{"content":116,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"832":{"content":110,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"833":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"834":{"content":87,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"835":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"836":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"837":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"838":{"content":35,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"839":{"content":132,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"840":{"content":145,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"841":{"content":95,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"842":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":0},"843":{"content":2,"h-1":0,"h0":8,"h1":0,"h2":0,"h3":0,"hash":2},"844":{"content":84,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":1},"845":{"content":238,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"846":{"content":57,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"847":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":2},"848":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"849":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"850":{"content":106,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"851":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"852":{"content":110,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"853":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"854":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"855":{"content":288,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"856":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"857":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"858":{"content":189,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"859":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"860":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"861":{"content":31,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"862":{"content":50,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"863":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"864":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"865":{"content":13,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":1},"866":{"content":89,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"867":{"content":62,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"868":{"content":52,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"869":{"content":51,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"870":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"871":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"872":{"content":35,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"873":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":0},"874":{"content":2,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":2},"875":{"content":19,"h-1":0,"h0":2,"h1":0,"h2":0,"h3":0,"hash":1},"876":{"content":43,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"877":{"content":36,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"878":{"content":80,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"879":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":0},"880":{"content":2,"h-1":0,"h0":3,"h1":0,"h2":0,"h3":0,"hash":2},"881":{"content":693,"h-1":0,"h0":1,"h1":0,"h2":0,"h3":0,"hash":1},"882":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"883":{"content":18,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"884":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":0},"885":{"content":2,"h-1":0,"h0":5,"h1":0,"h2":0,"h3":0,"hash":2},"886":{"content":51,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"887":{"content":2,"h-1":0,"h0":12,"h1":0,"h2":0,"h3":0,"hash":0},"888":{"content":2,"h-1":0,"h0":12,"h1":0,"h2":0,"h3":0,"hash":2},"889":{"content":61,"h-1":0,"h0":10,"h1":0,"h2":0,"h3":0,"hash":1},"890":{"content":99,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"891":{"content":50,"h-1":0,"h0":0,"h1":6,"h2":0,"h3":0,"hash":1},"892":{"content":62,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"893":{"content":71,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"894":{"content":138,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"895":{"content":100,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"896":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"897":{"content":28,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"898":{"content":48,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"899":{"content":52,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"900":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"901":{"content":96,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"902":{"content":77,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"903":{"content":2,"h-1":0,"h0":11,"h1":0,"h2":0,"h3":0,"hash":0},"904":{"content":2,"h-1":0,"h0":11,"h1":0,"h2":0,"h3":0,"hash":2},"905":{"content":78,"h-1":0,"h0":9,"h1":0,"h2":0,"h3":0,"hash":1},"906":{"content":43,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"907":{"content":245,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"908":{"content":41,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"909":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"910":{"content":46,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"911":{"content":118,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"912":{"content":97,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"913":{"content":92,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"914":{"content":9,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"915":{"content":370,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"916":{"content":150,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"917":{"content":87,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"918":{"content":44,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"919":{"content":3,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"920":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"921":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"922":{"content":29,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"923":{"content":8,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"924":{"content":86,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"925":{"content":74,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"926":{"content":58,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"927":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"928":{"content":31,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"929":{"content":82,"h-1":0,"h0":0,"h1":2,"h2":0,"h3":0,"hash":1},"930":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":0},"931":{"content":2,"h-1":0,"h0":6,"h1":0,"h2":0,"h3":0,"hash":2},"932":{"content":64,"h-1":0,"h0":4,"h1":0,"h2":0,"h3":0,"hash":1},"933":{"content":168,"h-1":0,"h0":0,"h1":1,"h2":0,"h3":0,"hash":1},"934":{"content":14,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"935":{"content":25,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"936":{"content":172,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"937":{"content":25,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"938":{"content":30,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"939":{"content":175,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"940":{"content":32,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"941":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"942":{"content":3,"h-1":0,"h0":0,"h1":3,"h2":0,"h3":0,"hash":1},"943":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":1,"h3":0,"hash":1},"944":{"content":61,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"945":{"content":40,"h-1":0,"h0":0,"h1":0,"h2":2,"h3":0,"hash":1},"946":{"content":165,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"947":{"content":12,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"948":{"content":72,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"949":{"content":73,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"950":{"content":6,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"951":{"content":100,"h-1":0,"h0":0,"h1":0,"h2":5,"h3":0,"hash":1},"952":{"content":11,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"953":{"content":6,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"954":{"content":179,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1},"955":{"content":24,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"956":{"content":21,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"957":{"content":17,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"958":{"content":55,"h-1":0,"h0":0,"h1":0,"h2":5,"h3":0,"hash":1},"959":{"content":20,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"960":{"content":60,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"961":{"content":34,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"962":{"content":9,"h-1":0,"h0":0,"h1":0,"h2":0,"h3":0,"hash":1},"963":{"content":27,"h-1":0,"h0":0,"h1":0,"h2":3,"h3":0,"hash":1}},"length":964,"save":true},"index":{"content":{"root":{"0":{"docs":{"116":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"578":{"tf":1.4142135623730951},"785":{"tf":1.7320508075688772},"890":{"tf":1},"895":{"tf":1},"916":{"tf":1}},"df":7},"1":{"0":{"0":{"docs":{"27":{"tf":1},"259":{"tf":1},"490":{"tf":1},"704":{"tf":1},"915":{"tf":1.4142135623730951}},"df":5},"docs":{"32":{"tf":1.7320508075688772},"264":{"tf":1.7320508075688772},"495":{"tf":1.7320508075688772},"890":{"tf":1},"895":{"tf":1},"910":{"tf":1.4142135623730951},"913":{"tf":1}},"df":7,".":{"0":{"docs":{},"df":0,".":{"2":{"docs":{"14":{"tf":1},"64":{"tf":1},"97":{"tf":1},"198":{"tf":1},"246":{"tf":1},"295":{"tf":1},"328":{"tf":1},"433":{"tf":1},"477":{"tf":1},"526":{"tf":1},"559":{"tf":1},"651":{"tf":1},"691":{"tf":1},"740":{"tf":1},"766":{"tf":1},"861":{"tf":1},"886":{"tf":1},"889":{"tf":1.4142135623730951},"901":{"tf":1.4142135623730951},"902":{"tf":1},"905":{"tf":1.4142135623730951},"906":{"tf":1},"908":{"tf":1},"916":{"tf":1},"920":{"tf":1},"932":{"tf":1.4142135623730951},"933":{"tf":1},"935":{"tf":1},"936":{"tf":1},"943":{"tf":1}},"df":30},"docs":{},"df":0}},"1":{"0":{"docs":{"265":{"tf":1}},"df":1},"1":{"docs":{"266":{"tf":1}},"df":1},"2":{"docs":{"270":{"tf":1}},"df":1},"3":{"docs":{"271":{"tf":1}},"df":1},"4":{"docs":{"272":{"tf":1}},"df":1},"5":{"docs":{"279":{"tf":1}},"df":1},"6":{"docs":{"283":{"tf":1}},"df":1},"7":{"docs":{"287":{"tf":1}},"df":1},"8":{"docs":{"288":{"tf":1}},"df":1},"docs":{"247":{"tf":1}},"df":1},"2":{"docs":{"248":{"tf":1}},"df":1},"3":{"docs":{"252":{"tf":1}},"df":1},"4":{"docs":{"253":{"tf":1}},"df":1},"5":{"docs":{"254":{"tf":1}},"df":1},"6":{"docs":{"258":{"tf":1}},"df":1},"7":{"docs":{"259":{"tf":1}},"df":1},"8":{"docs":{"260":{"tf":1}},"df":1},"9":{"docs":{"264":{"tf":1}},"df":1},"docs":{},"df":0}},"1":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"313":{"tf":1}},"df":1},"1":{"docs":{"314":{"tf":1}},"df":1},"2":{"docs":{"318":{"tf":1}},"df":1},"3":{"docs":{"322":{"tf":1}},"df":1},"docs":{"295":{"tf":1}},"df":1},"2":{"docs":{"296":{"tf":1}},"df":1},"3":{"docs":{"297":{"tf":1}},"df":1},"4":{"docs":{"298":{"tf":1}},"df":1},"5":{"docs":{"299":{"tf":1}},"df":1},"6":{"docs":{"303":{"tf":1}},"df":1},"7":{"docs":{"304":{"tf":1}},"df":1},"8":{"docs":{"305":{"tf":1}},"df":1},"9":{"docs":{"309":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"docs":{"195":{"tf":1},"430":{"tf":1},"648":{"tf":1},"858":{"tf":1},"915":{"tf":1.4142135623730951}},"df":5,".":{"1":{"docs":{"329":{"tf":1}},"df":1},"2":{"docs":{"333":{"tf":1}},"df":1},"3":{"docs":{"334":{"tf":1}},"df":1},"4":{"docs":{"335":{"tf":1}},"df":1},"5":{"docs":{"336":{"tf":1}},"df":1},"6":{"docs":{"337":{"tf":1}},"df":1},"7":{"3":{"4":{"docs":{},"df":0,",":{"0":{"0":{"docs":{"831":{"tf":1},"845":{"tf":1}},"df":2},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0}},"3":{"docs":{},"df":0,":":{"0":{"7":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2},"docs":{},"df":0},"docs":{},"df":0},".":{"1":{"docs":{"347":{"tf":1}},"df":1},"2":{"docs":{"351":{"tf":1}},"df":1},"3":{"4":{"9":{"docs":{},"df":0,",":{"0":{"0":{"docs":{"831":{"tf":1},"832":{"tf":1.4142135623730951},"841":{"tf":1}},"df":3},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{"355":{"tf":1}},"df":1},"4":{"docs":{"356":{"tf":1}},"df":1},"5":{"docs":{"357":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"385":{"tf":1}},"df":1},"1":{"docs":{"386":{"tf":1}},"df":1},"2":{"docs":{"387":{"tf":1}},"df":1},"3":{"docs":{"391":{"tf":1}},"df":1},"4":{"docs":{"392":{"tf":1}},"df":1},"docs":{"367":{"tf":1}},"df":1},"2":{"docs":{"368":{"tf":1}},"df":1},"3":{"docs":{"369":{"tf":1}},"df":1},"4":{"docs":{"373":{"tf":1}},"df":1},"5":{"docs":{"374":{"tf":1}},"df":1},"6":{"docs":{"375":{"tf":1}},"df":1},"7":{"docs":{"379":{"tf":1}},"df":1},"8":{"docs":{"380":{"tf":1}},"df":1},"9":{"docs":{"381":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"docs":{"890":{"tf":1},"895":{"tf":1},"911":{"tf":1},"914":{"tf":1}},"df":4,".":{"1":{"0":{"docs":{"423":{"tf":1}},"df":1},"1":{"docs":{"424":{"tf":1}},"df":1},"docs":{"403":{"tf":1}},"df":1},"2":{"docs":{"404":{"tf":1}},"df":1},"3":{"docs":{"405":{"tf":1}},"df":1},"4":{"docs":{"407":{"tf":1}},"df":1},"5":{"docs":{"411":{"tf":1}},"df":1},"6":{"docs":{"412":{"tf":1}},"df":1},"7":{"docs":{"413":{"tf":1}},"df":1},"8":{"docs":{"417":{"tf":1}},"df":1},"9":{"docs":{"418":{"tf":1}},"df":1},"docs":{},"df":0}},"6":{"docs":{},"df":0,".":{"1":{"docs":{"434":{"tf":1}},"df":1},"docs":{},"df":0}},"7":{"docs":{},"df":0,".":{"1":{"docs":{"455":{"tf":1}},"df":1},"2":{"docs":{"456":{"tf":1}},"df":1},"3":{"docs":{"457":{"tf":1}},"df":1},"4":{"docs":{"461":{"tf":1}},"df":1},"5":{"docs":{"462":{"tf":1}},"df":1},"6":{"docs":{"463":{"tf":1}},"df":1},"7":{"docs":{"464":{"tf":1}},"df":1},"8":{"docs":{"465":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"docs":{"559":{"tf":1},"766":{"tf":1}},"df":2,".":{"1":{"0":{"docs":{"496":{"tf":1}},"df":1},"1":{"docs":{"497":{"tf":1}},"df":1},"2":{"docs":{"501":{"tf":1}},"df":1},"3":{"docs":{"502":{"tf":1}},"df":1},"4":{"docs":{"503":{"tf":1}},"df":1},"5":{"docs":{"510":{"tf":1}},"df":1},"6":{"docs":{"514":{"tf":1}},"df":1},"7":{"docs":{"518":{"tf":1}},"df":1},"8":{"docs":{"519":{"tf":1}},"df":1},"docs":{"478":{"tf":1}},"df":1},"2":{"docs":{"479":{"tf":1}},"df":1},"3":{"docs":{"483":{"tf":1}},"df":1},"4":{"docs":{"484":{"tf":1}},"df":1},"5":{"docs":{"485":{"tf":1}},"df":1},"6":{"docs":{"489":{"tf":1}},"df":1},"7":{"docs":{"490":{"tf":1}},"df":1},"8":{"docs":{"491":{"tf":1}},"df":1},"9":{"docs":{"495":{"tf":1}},"df":1},"docs":{},"df":0}},"docs":{"90":{"tf":1},"321":{"tf":1},"552":{"tf":1},"915":{"tf":1.4142135623730951},"916":{"tf":1},"917":{"tf":1}},"df":6,".":{"1":{"0":{"docs":{"33":{"tf":1}},"df":1},"1":{"docs":{"34":{"tf":1}},"df":1},"2":{"docs":{"38":{"tf":1}},"df":1},"3":{"docs":{"39":{"tf":1}},"df":1},"4":{"docs":{"40":{"tf":1}},"df":1},"5":{"docs":{"47":{"tf":1}},"df":1},"6":{"docs":{"51":{"tf":1}},"df":1},"7":{"docs":{"55":{"tf":1}},"df":1},"8":{"docs":{"56":{"tf":1}},"df":1},"docs":{"15":{"tf":1}},"df":1},"2":{"docs":{"16":{"tf":1}},"df":1},"3":{"docs":{"20":{"tf":1}},"df":1},"4":{"docs":{"21":{"tf":1}},"df":1},"5":{"docs":{"22":{"tf":1}},"df":1},"6":{"docs":{"26":{"tf":1}},"df":1},"7":{"docs":{"27":{"tf":1}},"df":1},"8":{"docs":{"28":{"tf":1}},"df":1},"9":{"docs":{"32":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"0":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"544":{"tf":1}},"df":1},"1":{"docs":{"545":{"tf":1}},"df":1},"2":{"docs":{"549":{"tf":1}},"df":1},"3":{"docs":{"553":{"tf":1}},"df":1},"docs":{"526":{"tf":1}},"df":1},"2":{"docs":{"527":{"tf":1}},"df":1},"3":{"docs":{"528":{"tf":1}},"df":1},"4":{"docs":{"529":{"tf":1}},"df":1},"5":{"docs":{"530":{"tf":1}},"df":1},"6":{"docs":{"534":{"tf":1}},"df":1},"7":{"docs":{"535":{"tf":1}},"df":1},"8":{"docs":{"536":{"tf":1}},"df":1},"9":{"docs":{"540":{"tf":1}},"df":1},"docs":{},"df":0}},"1":{"docs":{},"df":0,".":{"1":{"docs":{"560":{"tf":1}},"df":1},"2":{"docs":{"564":{"tf":1}},"df":1},"3":{"docs":{"565":{"tf":1}},"df":1},"4":{"docs":{"566":{"tf":1}},"df":1},"5":{"docs":{"567":{"tf":1}},"df":1},"6":{"docs":{"568":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"docs":{},"df":0,".":{"1":{"docs":{"578":{"tf":1}},"df":1},"docs":{},"df":0}},"3":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"603":{"tf":1}},"df":1},"1":{"docs":{"604":{"tf":1}},"df":1},"2":{"docs":{"605":{"tf":1}},"df":1},"3":{"docs":{"609":{"tf":1}},"df":1},"4":{"docs":{"610":{"tf":1}},"df":1},"docs":{"585":{"tf":1}},"df":1},"2":{"docs":{"586":{"tf":1}},"df":1},"3":{"docs":{"587":{"tf":1}},"df":1},"4":{"docs":{"591":{"tf":1}},"df":1},"5":{"docs":{"592":{"tf":1}},"df":1},"6":{"docs":{"593":{"tf":1}},"df":1},"7":{"docs":{"597":{"tf":1}},"df":1},"8":{"docs":{"598":{"tf":1}},"df":1},"9":{"docs":{"599":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"641":{"tf":1}},"df":1},"1":{"docs":{"642":{"tf":1}},"df":1},"docs":{"621":{"tf":1}},"df":1},"2":{"docs":{"622":{"tf":1}},"df":1},"3":{"docs":{"623":{"tf":1}},"df":1},"4":{"docs":{"625":{"tf":1}},"df":1},"5":{"docs":{"629":{"tf":1}},"df":1},"6":{"docs":{"630":{"tf":1}},"df":1},"7":{"docs":{"631":{"tf":1}},"df":1},"8":{"docs":{"635":{"tf":1}},"df":1},"9":{"docs":{"636":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"docs":{},"df":0,".":{"1":{"docs":{"652":{"tf":1}},"df":1},"docs":{},"df":0}},"6":{"docs":{},"df":0,",":{"1":{"0":{"0":{"docs":{},"df":0,".":{"0":{"0":{"docs":{"168":{"tf":1},"182":{"tf":1},"403":{"tf":1},"417":{"tf":1},"621":{"tf":1},"635":{"tf":1}},"df":6},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0},".":{"1":{"docs":{"669":{"tf":1}},"df":1},"2":{"docs":{"670":{"tf":1}},"df":1},"3":{"docs":{"671":{"tf":1}},"df":1},"4":{"docs":{"675":{"tf":1}},"df":1},"5":{"docs":{"676":{"tf":1}},"df":1},"6":{"docs":{"677":{"tf":1}},"df":1},"7":{"docs":{"678":{"tf":1}},"df":1},"8":{"docs":{"679":{"tf":1}},"df":1},"docs":{},"df":0}},"8":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"710":{"tf":1}},"df":1},"1":{"docs":{"711":{"tf":1}},"df":1},"2":{"docs":{"715":{"tf":1}},"df":1},"3":{"docs":{"716":{"tf":1}},"df":1},"4":{"docs":{"717":{"tf":1}},"df":1},"5":{"docs":{"724":{"tf":1}},"df":1},"6":{"docs":{"728":{"tf":1}},"df":1},"7":{"docs":{"732":{"tf":1}},"df":1},"8":{"docs":{"733":{"tf":1}},"df":1},"docs":{"692":{"tf":1}},"df":1},"2":{"docs":{"693":{"tf":1}},"df":1},"3":{"docs":{"697":{"tf":1}},"df":1},"4":{"docs":{"698":{"tf":1}},"df":1},"5":{"docs":{"699":{"tf":1}},"df":1},"6":{"docs":{"703":{"tf":1}},"df":1},"7":{"docs":{"704":{"tf":1}},"df":1},"8":{"docs":{"705":{"tf":1}},"df":1},"9":{"docs":{"709":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"758":{"tf":1}},"df":1},"1":{"docs":{"759":{"tf":1}},"df":1},"2":{"docs":{"760":{"tf":1}},"df":1},"docs":{"740":{"tf":1}},"df":1},"2":{"docs":{"741":{"tf":1}},"df":1},"3":{"docs":{"742":{"tf":1}},"df":1},"4":{"docs":{"743":{"tf":1}},"df":1},"5":{"docs":{"747":{"tf":1}},"df":1},"6":{"docs":{"748":{"tf":1}},"df":1},"7":{"docs":{"749":{"tf":1}},"df":1},"8":{"docs":{"750":{"tf":1}},"df":1},"9":{"docs":{"751":{"tf":1}},"df":1},"docs":{},"df":0}},"docs":{"915":{"tf":1.4142135623730951},"916":{"tf":1},"917":{"tf":1}},"df":3,".":{"1":{"0":{"docs":{"78":{"tf":1}},"df":1},"1":{"docs":{"82":{"tf":1}},"df":1},"2":{"docs":{"83":{"tf":1}},"df":1},"3":{"docs":{"87":{"tf":1}},"df":1},"4":{"docs":{"91":{"tf":1}},"df":1},"docs":{"63":{"tf":1}},"df":1},"2":{"docs":{"64":{"tf":1}},"df":1},"3":{"docs":{"65":{"tf":1}},"df":1},"4":{"docs":{"66":{"tf":1}},"df":1},"5":{"docs":{"67":{"tf":1}},"df":1},"6":{"docs":{"68":{"tf":1}},"df":1},"7":{"docs":{"72":{"tf":1}},"df":1},"8":{"docs":{"73":{"tf":1}},"df":1},"9":{"docs":{"74":{"tf":1}},"df":1},"docs":{},"df":0}},"3":{"0":{"docs":{},"df":0,",":{"0":{"4":{"9":{"docs":{},"df":0,".":{"0":{"0":{"docs":{"168":{"tf":1},"169":{"tf":1.4142135623730951},"178":{"tf":1},"403":{"tf":1},"404":{"tf":1.4142135623730951},"413":{"tf":1},"621":{"tf":1},"622":{"tf":1.4142135623730951},"631":{"tf":1}},"df":9},"docs":{},"df":0},"docs":{},"df":0}},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0},".":{"1":{"docs":{"767":{"tf":1}},"df":1},"2":{"docs":{"771":{"tf":1}},"df":1},"3":{"docs":{"772":{"tf":1}},"df":1},"4":{"docs":{"773":{"tf":1}},"df":1},"5":{"docs":{"774":{"tf":1}},"df":1},"6":{"docs":{"775":{"tf":1}},"df":1},"docs":{},"df":0}},"1":{"docs":{},"df":0,".":{"1":{"docs":{"785":{"tf":1}},"df":1},"docs":{},"df":0}},"2":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"813":{"tf":1}},"df":1},"1":{"docs":{"814":{"tf":1}},"df":1},"2":{"docs":{"815":{"tf":1}},"df":1},"3":{"docs":{"819":{"tf":1}},"df":1},"4":{"docs":{"820":{"tf":1}},"df":1},"docs":{"795":{"tf":1}},"df":1},"2":{"docs":{"796":{"tf":1}},"df":1},"3":{"docs":{"797":{"tf":1}},"df":1},"4":{"docs":{"801":{"tf":1}},"df":1},"5":{"docs":{"802":{"tf":1}},"df":1},"6":{"docs":{"803":{"tf":1}},"df":1},"7":{"docs":{"807":{"tf":1}},"df":1},"8":{"docs":{"808":{"tf":1}},"df":1},"9":{"docs":{"809":{"tf":1}},"df":1},"docs":{},"df":0}},"3":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"851":{"tf":1}},"df":1},"1":{"docs":{"852":{"tf":1}},"df":1},"docs":{"831":{"tf":1}},"df":1},"2":{"docs":{"832":{"tf":1}},"df":1},"3":{"docs":{"833":{"tf":1}},"df":1},"4":{"docs":{"835":{"tf":1}},"df":1},"5":{"docs":{"839":{"tf":1}},"df":1},"6":{"docs":{"840":{"tf":1}},"df":1},"7":{"docs":{"841":{"tf":1}},"df":1},"8":{"docs":{"845":{"tf":1}},"df":1},"9":{"docs":{"846":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"docs":{"862":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"docs":{},"df":0,".":{"1":{"docs":{"876":{"tf":1}},"df":1},"2":{"docs":{"877":{"tf":1}},"df":1},"3":{"docs":{"878":{"tf":1}},"df":1},"4":{"docs":{"882":{"tf":1}},"df":1},"5":{"docs":{"883":{"tf":1}},"df":1},"docs":{},"df":0}},"7":{"docs":{},"df":0,".":{"1":{"docs":{"892":{"tf":1}},"df":1},"2":{"docs":{"893":{"tf":1}},"df":1},"3":{"docs":{"895":{"tf":1}},"df":1},"4":{"docs":{"896":{"tf":1}},"df":1},"5":{"docs":{"897":{"tf":1}},"df":1},"6":{"docs":{"898":{"tf":1}},"df":1},"7":{"docs":{"899":{"tf":1}},"df":1},"8":{"docs":{"900":{"tf":1}},"df":1},"9":{"docs":{"901":{"tf":1}},"df":1},"docs":{},"df":0}},"8":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"918":{"tf":1}},"df":1},"1":{"docs":{"921":{"tf":1}},"df":1},"2":{"docs":{"922":{"tf":1}},"df":1},"3":{"docs":{"923":{"tf":1}},"df":1},"4":{"docs":{"925":{"tf":1}},"df":1},"5":{"docs":{"926":{"tf":1}},"df":1},"6":{"docs":{"927":{"tf":1}},"df":1},"docs":{"907":{"tf":1}},"df":1},"2":{"docs":{"909":{"tf":1}},"df":1},"3":{"docs":{"910":{"tf":1}},"df":1},"4":{"docs":{"911":{"tf":1}},"df":1},"5":{"docs":{"912":{"tf":1}},"df":1},"6":{"docs":{"913":{"tf":1}},"df":1},"7":{"docs":{"914":{"tf":1}},"df":1},"8":{"docs":{"916":{"tf":1}},"df":1},"9":{"docs":{"917":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"949":{"tf":1}},"df":1},"1":{"docs":{"950":{"tf":1}},"df":1},"2":{"docs":{"952":{"tf":1}},"df":1},"3":{"docs":{"953":{"tf":1}},"df":1},"4":{"docs":{"955":{"tf":1}},"df":1},"5":{"docs":{"956":{"tf":1}},"df":1},"6":{"docs":{"957":{"tf":1}},"df":1},"7":{"docs":{"959":{"tf":1}},"df":1},"8":{"docs":{"960":{"tf":1}},"df":1},"9":{"docs":{"961":{"tf":1}},"df":1},"docs":{"934":{"tf":1},"938":{"tf":1}},"df":2},"2":{"0":{"docs":{"962":{"tf":1}},"df":1},"docs":{"936":{"tf":1},"939":{"tf":1}},"df":2},"3":{"docs":{"937":{"tf":1}},"df":1},"4":{"docs":{"940":{"tf":1}},"df":1},"5":{"docs":{"941":{"tf":1}},"df":1},"6":{"docs":{"944":{"tf":1}},"df":1},"7":{"docs":{"946":{"tf":1}},"df":1},"8":{"docs":{"947":{"tf":1}},"df":1},"9":{"docs":{"948":{"tf":1}},"df":1},"docs":{},"df":0}},"docs":{"237":{"tf":1},"468":{"tf":1},"682":{"tf":1},"915":{"tf":1},"916":{"tf":1},"917":{"tf":1.7320508075688772}},"df":6,".":{"1":{"docs":{"98":{"tf":1}},"df":1},"2":{"docs":{"102":{"tf":1}},"df":1},"3":{"docs":{"103":{"tf":1}},"df":1},"4":{"docs":{"104":{"tf":1}},"df":1},"5":{"docs":{"105":{"tf":1}},"df":1},"6":{"docs":{"106":{"tf":1}},"df":1},"docs":{},"df":0}},"4":{"docs":{},"df":0,".":{"1":{"docs":{"116":{"tf":1}},"df":1},"2":{"docs":{"5":{"tf":1},"120":{"tf":1}},"df":2},"3":{"docs":{"121":{"tf":1}},"df":1},"4":{"docs":{"122":{"tf":1}},"df":1},"docs":{},"df":0}},"5":{"0":{"docs":{"56":{"tf":1},"288":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":4},"docs":{"3":{"tf":1},"709":{"tf":1.4142135623730951}},"df":2,".":{"1":{"0":{"docs":{"150":{"tf":1}},"df":1},"1":{"docs":{"151":{"tf":1}},"df":1},"2":{"docs":{"152":{"tf":1}},"df":1},"3":{"docs":{"156":{"tf":1}},"df":1},"4":{"docs":{"157":{"tf":1}},"df":1},"docs":{"132":{"tf":1}},"df":1},"2":{"docs":{"133":{"tf":1}},"df":1},"3":{"docs":{"134":{"tf":1}},"df":1},"4":{"docs":{"138":{"tf":1}},"df":1},"5":{"docs":{"139":{"tf":1}},"df":1},"6":{"docs":{"140":{"tf":1}},"df":1},"7":{"docs":{"144":{"tf":1}},"df":1},"8":{"docs":{"145":{"tf":1}},"df":1},"9":{"docs":{"146":{"tf":1}},"df":1},"docs":{},"df":0}},"6":{"docs":{},"df":0,".":{"1":{"0":{"docs":{"188":{"tf":1}},"df":1},"1":{"docs":{"189":{"tf":1}},"df":1},"docs":{"168":{"tf":1}},"df":1},"2":{"docs":{"169":{"tf":1}},"df":1},"3":{"docs":{"170":{"tf":1}},"df":1},"4":{"docs":{"172":{"tf":1}},"df":1},"5":{"docs":{"176":{"tf":1}},"df":1},"6":{"docs":{"177":{"tf":1}},"df":1},"7":{"docs":{"178":{"tf":1}},"df":1},"8":{"docs":{"182":{"tf":1}},"df":1},"9":{"docs":{"183":{"tf":1}},"df":1},"docs":{},"df":0}},"7":{"docs":{},"df":0,".":{"0":{"docs":{"125":{"tf":1},"360":{"tf":1},"788":{"tf":1}},"df":3},"1":{"docs":{"199":{"tf":1}},"df":1},"docs":{},"df":0}},"8":{"docs":{},"df":0,".":{"1":{"docs":{"224":{"tf":1}},"df":1},"2":{"docs":{"225":{"tf":1}},"df":1},"3":{"docs":{"226":{"tf":1}},"df":1},"4":{"docs":{"230":{"tf":1}},"df":1},"5":{"docs":{"231":{"tf":1}},"df":1},"6":{"docs":{"232":{"tf":1}},"df":1},"7":{"docs":{"233":{"tf":1}},"df":1},"8":{"docs":{"234":{"tf":1}},"df":1},"docs":{},"df":0}},"9":{"9":{"9":{"9":{"9":{"docs":{"915":{"tf":1.4142135623730951}},"df":1},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0},"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{"0":{"tf":1},"1":{"tf":1},"6":{"tf":1},"7":{"tf":1},"9":{"tf":1},"10":{"tf":1},"12":{"tf":1},"13":{"tf":1},"17":{"tf":1},"18":{"tf":1},"23":{"tf":1},"24":{"tf":1},"29":{"tf":1},"30":{"tf":1},"35":{"tf":1},"36":{"tf":1},"41":{"tf":1},"42":{"tf":1},"44":{"tf":1},"45":{"tf":1},"48":{"tf":1},"49":{"tf":1},"52":{"tf":1},"53":{"tf":1},"57":{"tf":1},"58":{"tf":1},"60":{"tf":1},"61":{"tf":1},"69":{"tf":1},"70":{"tf":1},"75":{"tf":1},"76":{"tf":1},"79":{"tf":1},"80":{"tf":1},"84":{"tf":1},"85":{"tf":1},"88":{"tf":1},"89":{"tf":1},"92":{"tf":1},"93":{"tf":1},"95":{"tf":1},"96":{"tf":1},"99":{"tf":1},"100":{"tf":1},"107":{"tf":1},"108":{"tf":1},"110":{"tf":1},"111":{"tf":1},"113":{"tf":1},"114":{"tf":1},"117":{"tf":1},"118":{"tf":1},"123":{"tf":1},"124":{"tf":1},"126":{"tf":1},"127":{"tf":1},"129":{"tf":1},"130":{"tf":1},"135":{"tf":1},"136":{"tf":1},"141":{"tf":1},"142":{"tf":1},"147":{"tf":1},"148":{"tf":1},"153":{"tf":1},"154":{"tf":1},"159":{"tf":1},"160":{"tf":1},"162":{"tf":1},"163":{"tf":1},"165":{"tf":1},"166":{"tf":1},"173":{"tf":1},"174":{"tf":1},"179":{"tf":1},"180":{"tf":1},"185":{"tf":1},"186":{"tf":1},"190":{"tf":1},"191":{"tf":1},"193":{"tf":1},"194":{"tf":1},"196":{"tf":1},"197":{"tf":1},"200":{"tf":1},"201":{"tf":1},"218":{"tf":1},"219":{"tf":1},"221":{"tf":1},"222":{"tf":1},"227":{"tf":1},"228":{"tf":1},"235":{"tf":1},"236":{"tf":1},"238":{"tf":1},"239":{"tf":1},"241":{"tf":1},"242":{"tf":1},"244":{"tf":1},"245":{"tf":1},"249":{"tf":1},"250":{"tf":1},"255":{"tf":1},"256":{"tf":1},"261":{"tf":1},"262":{"tf":1},"267":{"tf":1},"268":{"tf":1},"273":{"tf":1},"274":{"tf":1},"276":{"tf":1},"277":{"tf":1},"280":{"tf":1},"281":{"tf":1},"284":{"tf":1},"285":{"tf":1},"289":{"tf":1},"290":{"tf":1},"292":{"tf":1},"293":{"tf":1},"300":{"tf":1},"301":{"tf":1},"306":{"tf":1},"307":{"tf":1},"310":{"tf":1},"311":{"tf":1},"315":{"tf":1},"316":{"tf":1},"319":{"tf":1},"320":{"tf":1},"323":{"tf":1},"324":{"tf":1},"326":{"tf":1},"327":{"tf":1},"330":{"tf":1},"331":{"tf":1},"338":{"tf":1},"339":{"tf":1},"341":{"tf":1},"342":{"tf":1},"344":{"tf":1},"345":{"tf":1},"348":{"tf":1},"349":{"tf":1},"352":{"tf":1},"353":{"tf":1},"358":{"tf":1},"359":{"tf":1},"361":{"tf":1},"362":{"tf":1},"364":{"tf":1},"365":{"tf":1},"370":{"tf":1},"371":{"tf":1},"376":{"tf":1},"377":{"tf":1},"382":{"tf":1},"383":{"tf":1},"388":{"tf":1},"389":{"tf":1},"394":{"tf":1},"395":{"tf":1},"397":{"tf":1},"398":{"tf":1},"400":{"tf":1},"401":{"tf":1},"408":{"tf":1},"409":{"tf":1},"414":{"tf":1},"415":{"tf":1},"420":{"tf":1},"421":{"tf":1},"425":{"tf":1},"426":{"tf":1},"428":{"tf":1},"429":{"tf":1},"431":{"tf":1},"432":{"tf":1},"435":{"tf":1},"436":{"tf":1},"449":{"tf":1},"450":{"tf":1},"452":{"tf":1},"453":{"tf":1},"458":{"tf":1},"459":{"tf":1},"466":{"tf":1},"467":{"tf":1},"469":{"tf":1},"470":{"tf":1},"472":{"tf":1},"473":{"tf":1},"475":{"tf":1},"476":{"tf":1},"480":{"tf":1},"481":{"tf":1},"486":{"tf":1},"487":{"tf":1},"492":{"tf":1},"493":{"tf":1},"498":{"tf":1},"499":{"tf":1},"504":{"tf":1},"505":{"tf":1},"507":{"tf":1},"508":{"tf":1},"511":{"tf":1},"512":{"tf":1},"515":{"tf":1},"516":{"tf":1},"520":{"tf":1},"521":{"tf":1},"523":{"tf":1},"524":{"tf":1},"531":{"tf":1},"532":{"tf":1},"537":{"tf":1},"538":{"tf":1},"541":{"tf":1},"542":{"tf":1},"546":{"tf":1},"547":{"tf":1},"550":{"tf":1},"551":{"tf":1},"554":{"tf":1},"555":{"tf":1},"557":{"tf":1},"558":{"tf":1},"561":{"tf":1},"562":{"tf":1},"569":{"tf":1},"570":{"tf":1},"572":{"tf":1},"573":{"tf":1},"575":{"tf":1},"576":{"tf":1},"579":{"tf":1},"580":{"tf":1},"582":{"tf":1},"583":{"tf":1},"588":{"tf":1},"589":{"tf":1},"594":{"tf":1},"595":{"tf":1},"600":{"tf":1},"601":{"tf":1},"606":{"tf":1},"607":{"tf":1},"612":{"tf":1},"613":{"tf":1},"615":{"tf":1},"616":{"tf":1},"618":{"tf":1},"619":{"tf":1},"626":{"tf":1},"627":{"tf":1},"632":{"tf":1},"633":{"tf":1},"638":{"tf":1},"639":{"tf":1},"643":{"tf":1},"644":{"tf":1},"646":{"tf":1},"647":{"tf":1},"649":{"tf":1},"650":{"tf":1},"653":{"tf":1},"654":{"tf":1},"663":{"tf":1},"664":{"tf":1},"666":{"tf":1},"667":{"tf":1},"672":{"tf":1},"673":{"tf":1},"680":{"tf":1},"681":{"tf":1},"683":{"tf":1},"684":{"tf":1},"686":{"tf":1},"687":{"tf":1},"689":{"tf":1},"690":{"tf":1},"694":{"tf":1},"695":{"tf":1},"700":{"tf":1},"701":{"tf":1},"706":{"tf":1},"707":{"tf":1},"712":{"tf":1},"713":{"tf":1},"718":{"tf":1},"719":{"tf":1},"721":{"tf":1},"722":{"tf":1},"725":{"tf":1},"726":{"tf":1},"729":{"tf":1},"730":{"tf":1},"734":{"tf":1},"735":{"tf":1},"737":{"tf":1},"738":{"tf":1},"744":{"tf":1},"745":{"tf":1},"752":{"tf":1},"753":{"tf":1},"755":{"tf":1},"756":{"tf":1},"761":{"tf":1},"762":{"tf":1},"764":{"tf":1},"765":{"tf":1},"768":{"tf":1},"769":{"tf":1},"776":{"tf":1},"777":{"tf":1},"779":{"tf":1},"780":{"tf":1},"782":{"tf":1},"783":{"tf":1},"786":{"tf":1},"787":{"tf":1},"789":{"tf":1},"790":{"tf":1},"792":{"tf":1},"793":{"tf":1},"798":{"tf":1},"799":{"tf":1},"804":{"tf":1},"805":{"tf":1},"810":{"tf":1},"811":{"tf":1},"816":{"tf":1},"817":{"tf":1},"822":{"tf":1},"823":{"tf":1},"825":{"tf":1},"826":{"tf":1},"828":{"tf":1},"829":{"tf":1},"836":{"tf":1},"837":{"tf":1},"842":{"tf":1},"843":{"tf":1},"848":{"tf":1},"849":{"tf":1},"853":{"tf":1},"854":{"tf":1},"856":{"tf":1},"857":{"tf":1},"859":{"tf":1},"860":{"tf":1},"863":{"tf":1},"864":{"tf":1},"870":{"tf":1},"871":{"tf":1},"873":{"tf":1},"874":{"tf":1},"879":{"tf":1},"880":{"tf":1},"884":{"tf":1},"885":{"tf":1},"887":{"tf":1},"888":{"tf":1},"903":{"tf":1},"904":{"tf":1},"930":{"tf":1},"931":{"tf":1}},"df":368,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1}},"df":1}}}}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"4":{"tf":1.4142135623730951},"50":{"tf":1},"68":{"tf":1},"122":{"tf":1},"195":{"tf":1.7320508075688772},"208":{"tf":1},"209":{"tf":1},"229":{"tf":1},"231":{"tf":1},"282":{"tf":1},"299":{"tf":1},"350":{"tf":1},"354":{"tf":1},"357":{"tf":1},"430":{"tf":1.7320508075688772},"441":{"tf":1},"460":{"tf":1},"462":{"tf":1},"513":{"tf":1},"530":{"tf":1},"648":{"tf":1.7320508075688772},"674":{"tf":1},"676":{"tf":1},"814":{"tf":1},"858":{"tf":1.4142135623730951},"881":{"tf":1.4142135623730951},"886":{"tf":1},"889":{"tf":1},"902":{"tf":1},"907":{"tf":1}},"df":31}},"e":{"docs":{"26":{"tf":1},"39":{"tf":1},"43":{"tf":1},"55":{"tf":1},"258":{"tf":1},"271":{"tf":1},"275":{"tf":1},"287":{"tf":1},"489":{"tf":1},"502":{"tf":1},"506":{"tf":1},"518":{"tf":1},"703":{"tf":1},"720":{"tf":1},"732":{"tf":1}},"df":15,"n":{"docs":{"778":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"e":{"docs":{"936":{"tf":1},"949":{"tf":1}},"df":2,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"94":{"tf":2.449489742783178},"98":{"tf":1},"101":{"tf":3.3166247903554},"102":{"tf":1.7320508075688772},"103":{"tf":2},"104":{"tf":2.23606797749979},"105":{"tf":2.449489742783178},"106":{"tf":1.4142135623730951},"109":{"tf":2.8284271247461903},"119":{"tf":1},"122":{"tf":1},"164":{"tf":1.7320508075688772},"167":{"tf":1},"168":{"tf":2.8284271247461903},"169":{"tf":2.6457513110645907},"170":{"tf":1},"171":{"tf":1.4142135623730951},"175":{"tf":1.7320508075688772},"176":{"tf":2},"177":{"tf":2.8284271247461903},"178":{"tf":1.7320508075688772},"181":{"tf":2.449489742783178},"182":{"tf":3.872983346207417},"183":{"tf":1.4142135623730951},"187":{"tf":1},"188":{"tf":2.23606797749979},"189":{"tf":2},"192":{"tf":3.605551275463989},"195":{"tf":3},"198":{"tf":1},"199":{"tf":1.7320508075688772},"202":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"204":{"tf":1.4142135623730951},"205":{"tf":1.4142135623730951},"206":{"tf":1.4142135623730951},"207":{"tf":1.7320508075688772},"208":{"tf":1},"209":{"tf":1.4142135623730951},"210":{"tf":1},"211":{"tf":1.4142135623730951},"212":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"215":{"tf":1.4142135623730951},"216":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"225":{"tf":1},"231":{"tf":2.449489742783178},"232":{"tf":1},"237":{"tf":1.4142135623730951},"312":{"tf":1.4142135623730951},"325":{"tf":2.449489742783178},"329":{"tf":1},"332":{"tf":3.3166247903554},"333":{"tf":1.7320508075688772},"334":{"tf":2},"335":{"tf":2.23606797749979},"336":{"tf":2.449489742783178},"337":{"tf":1.4142135623730951},"340":{"tf":2.8284271247461903},"354":{"tf":1},"357":{"tf":1},"399":{"tf":1.7320508075688772},"402":{"tf":1},"403":{"tf":2.8284271247461903},"404":{"tf":2.6457513110645907},"405":{"tf":1},"406":{"tf":1.4142135623730951},"410":{"tf":1.7320508075688772},"411":{"tf":2},"412":{"tf":2.8284271247461903},"413":{"tf":1.7320508075688772},"416":{"tf":2.449489742783178},"417":{"tf":3.872983346207417},"418":{"tf":1.4142135623730951},"422":{"tf":1},"423":{"tf":2.23606797749979},"424":{"tf":2},"427":{"tf":3.605551275463989},"430":{"tf":3},"433":{"tf":1},"434":{"tf":1.7320508075688772},"437":{"tf":1.4142135623730951},"438":{"tf":1.7320508075688772},"439":{"tf":1.4142135623730951},"440":{"tf":1.4142135623730951},"441":{"tf":1},"442":{"tf":1.4142135623730951},"443":{"tf":1.4142135623730951},"444":{"tf":1.4142135623730951},"445":{"tf":1.4142135623730951},"446":{"tf":1.4142135623730951},"447":{"tf":1.4142135623730951},"448":{"tf":1.4142135623730951},"456":{"tf":1},"462":{"tf":2.449489742783178},"463":{"tf":1},"468":{"tf":1.4142135623730951},"543":{"tf":1.4142135623730951},"556":{"tf":2.449489742783178},"560":{"tf":1},"563":{"tf":3.3166247903554},"564":{"tf":1.7320508075688772},"565":{"tf":2},"566":{"tf":2.23606797749979},"567":{"tf":2.449489742783178},"568":{"tf":1.4142135623730951},"571":{"tf":2.8284271247461903},"617":{"tf":1.7320508075688772},"620":{"tf":1},"621":{"tf":2.8284271247461903},"622":{"tf":2.6457513110645907},"623":{"tf":1},"624":{"tf":1.4142135623730951},"628":{"tf":1.7320508075688772},"629":{"tf":2},"630":{"tf":2.8284271247461903},"631":{"tf":1.7320508075688772},"634":{"tf":2.449489742783178},"635":{"tf":3.872983346207417},"636":{"tf":1.4142135623730951},"640":{"tf":1},"641":{"tf":2.23606797749979},"642":{"tf":2},"645":{"tf":3.605551275463989},"648":{"tf":3},"651":{"tf":1},"652":{"tf":1.7320508075688772},"655":{"tf":1.4142135623730951},"656":{"tf":1.4142135623730951},"657":{"tf":1.4142135623730951},"658":{"tf":1.4142135623730951},"659":{"tf":1.4142135623730951},"660":{"tf":1.4142135623730951},"661":{"tf":1.4142135623730951},"662":{"tf":1.4142135623730951},"670":{"tf":1},"676":{"tf":2.449489742783178},"677":{"tf":1},"682":{"tf":1.4142135623730951},"757":{"tf":1.4142135623730951},"763":{"tf":2.23606797749979},"767":{"tf":1},"770":{"tf":3.605551275463989},"771":{"tf":1.7320508075688772},"772":{"tf":2},"773":{"tf":2.23606797749979},"774":{"tf":2.8284271247461903},"775":{"tf":1.4142135623730951},"778":{"tf":2.8284271247461903},"827":{"tf":1.7320508075688772},"830":{"tf":1},"831":{"tf":2.8284271247461903},"832":{"tf":2.8284271247461903},"833":{"tf":1},"834":{"tf":1},"838":{"tf":1.7320508075688772},"839":{"tf":2.8284271247461903},"840":{"tf":2.8284271247461903},"841":{"tf":1.4142135623730951},"844":{"tf":2.449489742783178},"845":{"tf":3.7416573867739413},"846":{"tf":1.4142135623730951},"850":{"tf":1},"851":{"tf":2},"852":{"tf":1.7320508075688772},"855":{"tf":3.4641016151377544},"858":{"tf":2.23606797749979},"861":{"tf":1},"862":{"tf":1.7320508075688772},"865":{"tf":1.4142135623730951},"866":{"tf":1.4142135623730951},"867":{"tf":1.4142135623730951},"868":{"tf":2.23606797749979},"869":{"tf":1.4142135623730951},"877":{"tf":1},"881":{"tf":2.8284271247461903},"896":{"tf":1},"897":{"tf":1},"901":{"tf":1.7320508075688772},"907":{"tf":1},"911":{"tf":1},"912":{"tf":1.7320508075688772},"913":{"tf":1},"925":{"tf":1.4142135623730951},"927":{"tf":1.4142135623730951},"932":{"tf":1.7320508075688772},"933":{"tf":2.449489742783178},"934":{"tf":1},"935":{"tf":1},"936":{"tf":3},"937":{"tf":1.4142135623730951},"938":{"tf":1},"939":{"tf":4.58257569495584},"940":{"tf":1.4142135623730951},"941":{"tf":1.4142135623730951},"944":{"tf":1.4142135623730951},"946":{"tf":3.3166247903554},"947":{"tf":1.4142135623730951},"948":{"tf":2.23606797749979},"949":{"tf":2},"950":{"tf":1},"951":{"tf":2.449489742783178},"952":{"tf":1},"953":{"tf":1},"954":{"tf":4.69041575982343},"955":{"tf":2},"956":{"tf":1.7320508075688772},"957":{"tf":1.4142135623730951},"958":{"tf":1.7320508075688772},"959":{"tf":1.7320508075688772},"960":{"tf":2.23606797749979},"961":{"tf":2},"962":{"tf":1},"963":{"tf":1}},"df":218}}},"s":{"docs":{},"df":0,"s":{"docs":{"47":{"tf":1},"55":{"tf":1},"229":{"tf":1},"253":{"tf":1},"279":{"tf":1},"287":{"tf":1},"460":{"tf":1},"510":{"tf":1},"518":{"tf":1},"674":{"tf":1},"698":{"tf":1},"724":{"tf":1.4142135623730951},"732":{"tf":1},"840":{"tf":1},"881":{"tf":1},"951":{"tf":1}},"df":16}}},"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"936":{"tf":1.4142135623730951},"939":{"tf":1},"944":{"tf":1.4142135623730951},"963":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"936":{"tf":1},"943":{"tf":1}},"df":2}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1},"8":{"tf":1},"143":{"tf":1},"192":{"tf":1},"237":{"tf":1},"240":{"tf":1},"378":{"tf":1},"427":{"tf":1},"468":{"tf":1},"471":{"tf":1},"596":{"tf":1},"645":{"tf":1},"682":{"tf":1},"759":{"tf":1},"760":{"tf":1},"806":{"tf":1}},"df":16,"m":{"docs":{"122":{"tf":1.4142135623730951},"357":{"tf":1.4142135623730951}},"df":2}}}}},"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1},"246":{"tf":1},"477":{"tf":1},"691":{"tf":1}},"df":4}}}}},"/":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"14":{"tf":1},"97":{"tf":1},"246":{"tf":1},"328":{"tf":1},"477":{"tf":1},"559":{"tf":1},"691":{"tf":1},"766":{"tf":1},"905":{"tf":1.4142135623730951},"906":{"tf":1},"908":{"tf":1},"916":{"tf":1},"920":{"tf":1}},"df":13,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"/":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"886":{"tf":1},"889":{"tf":1},"901":{"tf":1.4142135623730951},"932":{"tf":1.4142135623730951},"933":{"tf":1},"935":{"tf":1}},"df":6}}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"889":{"tf":1},"902":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{"64":{"tf":1}},"df":1}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"/":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"295":{"tf":1}},"df":1}}}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"526":{"tf":1}},"df":1}}}}}}}}}}}}},"i":{"docs":{},"df":0,"o":{"docs":{"740":{"tf":1}},"df":1}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"936":{"tf":1},"943":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{"198":{"tf":1},"433":{"tf":1},"651":{"tf":1},"861":{"tf":1}},"df":4}}}}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"51":{"tf":1},"140":{"tf":1},"177":{"tf":1},"210":{"tf":1},"283":{"tf":1},"375":{"tf":1},"412":{"tf":1},"514":{"tf":1},"593":{"tf":1},"630":{"tf":1},"728":{"tf":1}},"df":11,"t":{"docs":{},"df":0,"i":{"docs":{"38":{"tf":1},"55":{"tf":1},"73":{"tf":1},"77":{"tf":1},"81":{"tf":1},"121":{"tf":1},"270":{"tf":1},"287":{"tf":1},"304":{"tf":1},"308":{"tf":1},"312":{"tf":1},"356":{"tf":1},"501":{"tf":1},"518":{"tf":1},"535":{"tf":1},"539":{"tf":1},"543":{"tf":1},"715":{"tf":1},"732":{"tf":1},"757":{"tf":1},"803":{"tf":1}},"df":21}},"l":{"docs":{},"df":0,"i":{"docs":{"78":{"tf":1},"203":{"tf":1},"210":{"tf":1},"309":{"tf":1},"438":{"tf":1},"539":{"tf":1},"540":{"tf":1}},"df":7}}}},"a":{"docs":{},"df":0,"g":{"docs":{"210":{"tf":1}},"df":1}}},"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"38":{"tf":1},"119":{"tf":1},"195":{"tf":1.4142135623730951},"270":{"tf":1},"354":{"tf":1},"430":{"tf":1.4142135623730951},"501":{"tf":1},"648":{"tf":1.4142135623730951},"715":{"tf":1},"791":{"tf":1.4142135623730951},"814":{"tf":1},"818":{"tf":1},"907":{"tf":1}},"df":13}}}},"x":{"docs":{},"df":0,"i":{"docs":{"253":{"tf":1}},"df":1}},"j":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"889":{"tf":1},"905":{"tf":1},"906":{"tf":1},"908":{"tf":1},"912":{"tf":1},"915":{"tf":1},"920":{"tf":1},"927":{"tf":1},"928":{"tf":1},"932":{"tf":1},"933":{"tf":1},"935":{"tf":1},"946":{"tf":1}},"df":13}}}}},"e":{"docs":{"892":{"tf":1},"893":{"tf":1},"907":{"tf":1}},"df":3,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"2":{"tf":1}},"df":1}},"i":{"docs":{},"df":0,"x":{"docs":{"122":{"tf":1},"125":{"tf":1},"360":{"tf":1}},"df":3}},"e":{"docs":{},"df":0,"r":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"55":{"tf":1},"56":{"tf":1},"231":{"tf":1},"287":{"tf":1},"288":{"tf":1},"462":{"tf":1},"518":{"tf":1},"519":{"tf":1},"676":{"tf":1},"685":{"tf":1},"732":{"tf":1},"733":{"tf":1},"818":{"tf":1},"881":{"tf":1}},"df":15}}},"s":{"docs":{"14":{"tf":1},"37":{"tf":1.7320508075688772},"38":{"tf":1},"43":{"tf":1},"55":{"tf":1},"62":{"tf":1},"64":{"tf":1},"65":{"tf":1},"68":{"tf":1.4142135623730951},"72":{"tf":1},"74":{"tf":1},"86":{"tf":1},"90":{"tf":1},"102":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"131":{"tf":1},"132":{"tf":1},"133":{"tf":1},"144":{"tf":1},"145":{"tf":1},"161":{"tf":1},"168":{"tf":1},"169":{"tf":1},"176":{"tf":1.4142135623730951},"182":{"tf":1},"184":{"tf":1},"229":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1},"246":{"tf":1},"269":{"tf":1.7320508075688772},"270":{"tf":1},"275":{"tf":1},"287":{"tf":1},"294":{"tf":1},"295":{"tf":1},"296":{"tf":1.4142135623730951},"299":{"tf":1.4142135623730951},"303":{"tf":1},"305":{"tf":1},"317":{"tf":1},"321":{"tf":1},"333":{"tf":1.4142135623730951},"335":{"tf":1.4142135623730951},"346":{"tf":1.4142135623730951},"347":{"tf":1.7320508075688772},"366":{"tf":1},"367":{"tf":1},"368":{"tf":1},"379":{"tf":1},"380":{"tf":1},"396":{"tf":1},"403":{"tf":1},"404":{"tf":1},"411":{"tf":1.4142135623730951},"417":{"tf":1},"419":{"tf":1},"460":{"tf":1},"462":{"tf":1.4142135623730951},"463":{"tf":1},"477":{"tf":1},"500":{"tf":1.7320508075688772},"501":{"tf":1},"506":{"tf":1},"518":{"tf":1},"525":{"tf":1},"526":{"tf":1},"527":{"tf":1},"530":{"tf":1.4142135623730951},"534":{"tf":1},"536":{"tf":1},"548":{"tf":1},"552":{"tf":1},"564":{"tf":1.4142135623730951},"566":{"tf":1.4142135623730951},"577":{"tf":1.4142135623730951},"578":{"tf":1.7320508075688772},"584":{"tf":1},"585":{"tf":1},"586":{"tf":1},"597":{"tf":1},"598":{"tf":1},"614":{"tf":1},"621":{"tf":1},"622":{"tf":1},"629":{"tf":1.4142135623730951},"635":{"tf":1},"637":{"tf":1},"674":{"tf":1},"676":{"tf":1.4142135623730951},"677":{"tf":1},"691":{"tf":1},"709":{"tf":1},"714":{"tf":1.7320508075688772},"715":{"tf":1},"720":{"tf":1},"732":{"tf":1},"740":{"tf":1},"742":{"tf":1},"743":{"tf":1},"747":{"tf":1},"749":{"tf":1.4142135623730951},"751":{"tf":1},"754":{"tf":1},"770":{"tf":1},"771":{"tf":1.4142135623730951},"773":{"tf":1.4142135623730951},"794":{"tf":1.4142135623730951},"796":{"tf":1},"807":{"tf":1},"820":{"tf":1},"821":{"tf":1},"824":{"tf":1.7320508075688772},"831":{"tf":1},"832":{"tf":1.4142135623730951},"834":{"tf":1},"839":{"tf":1},"847":{"tf":1},"881":{"tf":2},"895":{"tf":1},"912":{"tf":1},"915":{"tf":3},"936":{"tf":2.449489742783178},"939":{"tf":1},"949":{"tf":1.7320508075688772},"954":{"tf":1.4142135623730951}},"df":128}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"51":{"tf":1},"283":{"tf":1},"514":{"tf":1},"728":{"tf":1},"893":{"tf":1},"905":{"tf":1.4142135623730951},"907":{"tf":2},"908":{"tf":1},"911":{"tf":1},"914":{"tf":1},"915":{"tf":2}},"df":12}}}}}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{"64":{"tf":1},"94":{"tf":1},"137":{"tf":1},"175":{"tf":1},"295":{"tf":1},"325":{"tf":1},"350":{"tf":1},"372":{"tf":1},"410":{"tf":1},"526":{"tf":1},"556":{"tf":1},"590":{"tf":1},"628":{"tf":1},"763":{"tf":1},"813":{"tf":1},"831":{"tf":1},"840":{"tf":1},"844":{"tf":1},"896":{"tf":1},"915":{"tf":1},"916":{"tf":1},"917":{"tf":1},"924":{"tf":1},"929":{"tf":1},"943":{"tf":1},"951":{"tf":1},"954":{"tf":1},"956":{"tf":1},"963":{"tf":1}},"df":29,"s":{"docs":{"82":{"tf":1},"157":{"tf":1},"313":{"tf":1},"392":{"tf":1},"544":{"tf":1},"610":{"tf":1},"758":{"tf":1}},"df":7}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1},"907":{"tf":1}},"df":2}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{"106":{"tf":1},"337":{"tf":1},"568":{"tf":1}},"df":3}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"192":{"tf":1},"427":{"tf":1},"645":{"tf":1}},"df":3}}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"351":{"tf":1.4142135623730951}},"df":1}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"803":{"tf":1},"918":{"tf":1}},"df":2}}},"i":{"docs":{"834":{"tf":1.4142135623730951}},"df":1}},"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}}},"c":{"docs":{},"df":0,"e":{"docs":{"26":{"tf":1.4142135623730951},"39":{"tf":1},"77":{"tf":1.4142135623730951},"116":{"tf":1},"119":{"tf":1},"122":{"tf":2.8284271247461903},"167":{"tf":1},"168":{"tf":1},"169":{"tf":2},"171":{"tf":2.449489742783178},"176":{"tf":1.7320508075688772},"178":{"tf":1.4142135623730951},"182":{"tf":1.7320508075688772},"258":{"tf":1.4142135623730951},"271":{"tf":1},"308":{"tf":1.4142135623730951},"347":{"tf":1},"354":{"tf":1},"357":{"tf":3},"402":{"tf":1},"403":{"tf":1},"404":{"tf":2},"406":{"tf":2.449489742783178},"411":{"tf":1.7320508075688772},"413":{"tf":1.4142135623730951},"417":{"tf":1.7320508075688772},"489":{"tf":1.4142135623730951},"502":{"tf":1},"539":{"tf":1.4142135623730951},"578":{"tf":1},"620":{"tf":1},"621":{"tf":1},"622":{"tf":2},"624":{"tf":2.449489742783178},"629":{"tf":1.7320508075688772},"631":{"tf":1.4142135623730951},"635":{"tf":1.7320508075688772},"703":{"tf":1.4142135623730951},"716":{"tf":1},"754":{"tf":1},"830":{"tf":1},"831":{"tf":1},"832":{"tf":2},"834":{"tf":1.7320508075688772},"839":{"tf":1.7320508075688772},"841":{"tf":1},"845":{"tf":1},"890":{"tf":1.4142135623730951},"898":{"tf":1.4142135623730951},"915":{"tf":2.449489742783178}},"df":50}},"o":{"docs":{},"df":0,"r":{"docs":{"199":{"tf":1},"434":{"tf":1},"652":{"tf":1}},"df":3}},"n":{"docs":{},"df":0,"t":{"docs":{"214":{"tf":1.4142135623730951},"445":{"tf":1.4142135623730951},"659":{"tf":1.4142135623730951},"867":{"tf":1.4142135623730951}},"df":4,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"214":{"tf":1},"445":{"tf":1},"659":{"tf":1},"867":{"tf":1}},"df":4}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"214":{"tf":1},"445":{"tf":1},"659":{"tf":1},"867":{"tf":1}},"df":4}}}}}}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"109":{"tf":1},"340":{"tf":1},"571":{"tf":1}},"df":3}}}}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1},"i":{"docs":{},"df":0,"t":{"docs":{"5":{"tf":1},"56":{"tf":1},"125":{"tf":1.4142135623730951},"143":{"tf":1},"288":{"tf":1},"350":{"tf":1.7320508075688772},"360":{"tf":1.4142135623730951},"378":{"tf":1},"519":{"tf":1},"596":{"tf":1},"733":{"tf":1},"757":{"tf":1},"788":{"tf":1},"794":{"tf":1},"806":{"tf":1},"821":{"tf":1.4142135623730951}},"df":16}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"143":{"tf":1},"296":{"tf":1},"305":{"tf":1},"350":{"tf":1},"378":{"tf":1},"526":{"tf":1},"596":{"tf":1},"788":{"tf":1},"902":{"tf":1}},"df":9}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"54":{"tf":1},"131":{"tf":1},"132":{"tf":1},"134":{"tf":1},"140":{"tf":1},"158":{"tf":1.4142135623730951},"192":{"tf":1},"229":{"tf":1},"253":{"tf":1},"286":{"tf":1},"366":{"tf":1},"367":{"tf":1},"369":{"tf":1},"375":{"tf":1},"393":{"tf":1.4142135623730951},"427":{"tf":1},"460":{"tf":1},"484":{"tf":1},"517":{"tf":1},"584":{"tf":1},"585":{"tf":1},"587":{"tf":1},"593":{"tf":1},"611":{"tf":1.4142135623730951},"645":{"tf":1},"674":{"tf":1},"731":{"tf":1},"800":{"tf":1},"806":{"tf":1},"845":{"tf":1},"881":{"tf":1},"948":{"tf":1}},"df":33,"e":{"docs":{},"df":0,"r":{"docs":{"21":{"tf":1},"253":{"tf":1},"484":{"tf":1},"698":{"tf":1}},"df":4}}}}},"p":{"docs":{"81":{"tf":1},"182":{"tf":1.4142135623730951},"312":{"tf":1},"417":{"tf":1.4142135623730951},"543":{"tf":1},"635":{"tf":1.4142135623730951}},"df":6,"u":{"docs":{},"df":0,"p":{"docs":{"77":{"tf":1},"128":{"tf":1},"177":{"tf":1},"178":{"tf":1.4142135623730951},"182":{"tf":1},"229":{"tf":1.4142135623730951},"230":{"tf":1},"232":{"tf":1},"308":{"tf":1},"350":{"tf":1},"363":{"tf":1},"412":{"tf":1},"413":{"tf":1.4142135623730951},"417":{"tf":1},"460":{"tf":1.4142135623730951},"461":{"tf":1},"463":{"tf":1},"539":{"tf":1},"581":{"tf":1},"630":{"tf":1},"631":{"tf":1.4142135623730951},"635":{"tf":1},"674":{"tf":1.4142135623730951},"675":{"tf":1},"677":{"tf":1},"791":{"tf":1},"797":{"tf":1},"840":{"tf":1},"841":{"tf":1.4142135623730951},"845":{"tf":1},"881":{"tf":1.7320508075688772}},"df":31}}},"r":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"143":{"tf":1},"378":{"tf":1},"596":{"tf":1}},"df":3}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"866":{"tf":1}},"df":1}}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1.4142135623730951}},"df":1}}}}},"c":{"docs":{},"df":0,"e":{"docs":{"43":{"tf":1},"72":{"tf":1},"82":{"tf":1},"103":{"tf":1},"109":{"tf":1},"125":{"tf":1},"171":{"tf":1},"187":{"tf":1},"192":{"tf":1.4142135623730951},"275":{"tf":1},"303":{"tf":1},"313":{"tf":1},"334":{"tf":1},"340":{"tf":1},"350":{"tf":1},"360":{"tf":1},"406":{"tf":1},"422":{"tf":1},"427":{"tf":1.4142135623730951},"506":{"tf":1},"534":{"tf":1},"544":{"tf":1},"565":{"tf":1},"571":{"tf":1},"624":{"tf":1},"640":{"tf":1},"645":{"tf":1.4142135623730951},"720":{"tf":1},"772":{"tf":1},"778":{"tf":1},"834":{"tf":1},"907":{"tf":1},"926":{"tf":1},"948":{"tf":1.4142135623730951},"949":{"tf":1},"951":{"tf":1}},"df":36,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"954":{"tf":1}},"df":1}}}}}},"y":{"docs":{"74":{"tf":1},"122":{"tf":1},"305":{"tf":1},"357":{"tf":1},"536":{"tf":1},"751":{"tf":1}},"df":6,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"757":{"tf":1}},"df":1}}}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"855":{"tf":1}},"df":1}}}}},"i":{"docs":{},"df":0,"n":{"docs":{"171":{"tf":1},"406":{"tf":1},"624":{"tf":1}},"df":3}},"n":{"docs":{"915":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":1},"5":{"tf":1},"8":{"tf":1},"21":{"tf":1},"27":{"tf":1},"37":{"tf":1},"38":{"tf":1},"62":{"tf":1.4142135623730951},"63":{"tf":1},"64":{"tf":1.4142135623730951},"65":{"tf":1},"67":{"tf":1},"72":{"tf":1},"73":{"tf":1},"77":{"tf":1},"82":{"tf":1.4142135623730951},"86":{"tf":1},"97":{"tf":1},"116":{"tf":1},"119":{"tf":1},"125":{"tf":1.4142135623730951},"137":{"tf":1},"140":{"tf":1},"149":{"tf":1},"176":{"tf":1},"178":{"tf":1},"187":{"tf":1},"189":{"tf":1},"195":{"tf":1},"215":{"tf":1.4142135623730951},"229":{"tf":1},"231":{"tf":1},"237":{"tf":1},"240":{"tf":1},"259":{"tf":1},"269":{"tf":1},"270":{"tf":1},"294":{"tf":1.4142135623730951},"296":{"tf":1.4142135623730951},"298":{"tf":1},"303":{"tf":1},"304":{"tf":1},"308":{"tf":1},"313":{"tf":1.4142135623730951},"328":{"tf":1},"347":{"tf":1},"354":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951},"372":{"tf":1},"375":{"tf":1},"384":{"tf":1},"411":{"tf":1},"413":{"tf":1},"422":{"tf":1},"424":{"tf":1},"430":{"tf":1},"446":{"tf":1.4142135623730951},"460":{"tf":1},"462":{"tf":1},"468":{"tf":1},"471":{"tf":1},"490":{"tf":1},"500":{"tf":1},"501":{"tf":1},"525":{"tf":1.4142135623730951},"526":{"tf":1.4142135623730951},"527":{"tf":1},"529":{"tf":1},"534":{"tf":1},"535":{"tf":1},"539":{"tf":1},"544":{"tf":1.4142135623730951},"548":{"tf":1},"559":{"tf":1},"578":{"tf":1},"590":{"tf":1},"593":{"tf":1},"602":{"tf":1},"629":{"tf":1},"631":{"tf":1},"640":{"tf":1},"642":{"tf":1},"648":{"tf":1},"660":{"tf":1.4142135623730951},"674":{"tf":1},"676":{"tf":1},"682":{"tf":1},"685":{"tf":1},"691":{"tf":1},"714":{"tf":1},"715":{"tf":1},"727":{"tf":1},"731":{"tf":1},"739":{"tf":1},"742":{"tf":1},"766":{"tf":1},"800":{"tf":1},"803":{"tf":1},"812":{"tf":1},"839":{"tf":1},"841":{"tf":1},"844":{"tf":1},"858":{"tf":1},"881":{"tf":1.4142135623730951},"889":{"tf":1},"905":{"tf":1},"906":{"tf":1},"908":{"tf":1},"910":{"tf":1.4142135623730951},"913":{"tf":1},"920":{"tf":1},"922":{"tf":1},"925":{"tf":1},"932":{"tf":1},"935":{"tf":1},"936":{"tf":1.4142135623730951},"937":{"tf":1},"943":{"tf":1},"945":{"tf":1},"946":{"tf":1.4142135623730951},"949":{"tf":1},"959":{"tf":1},"963":{"tf":1}},"df":123}}},"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"215":{"tf":1},"446":{"tf":1},"660":{"tf":1}},"df":3}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1.7320508075688772},"8":{"tf":1.4142135623730951},"15":{"tf":1},"66":{"tf":1},"94":{"tf":1},"97":{"tf":1},"116":{"tf":1.7320508075688772},"122":{"tf":1},"189":{"tf":1},"195":{"tf":1},"232":{"tf":1},"237":{"tf":1},"240":{"tf":2},"247":{"tf":1},"325":{"tf":1},"328":{"tf":1},"347":{"tf":1.7320508075688772},"351":{"tf":1},"354":{"tf":1},"357":{"tf":1},"424":{"tf":1},"430":{"tf":1},"463":{"tf":1},"468":{"tf":1},"471":{"tf":1.7320508075688772},"478":{"tf":1},"528":{"tf":1},"556":{"tf":1},"559":{"tf":1},"578":{"tf":1.7320508075688772},"642":{"tf":1},"648":{"tf":1},"677":{"tf":1},"682":{"tf":1},"685":{"tf":1},"692":{"tf":1},"766":{"tf":1},"785":{"tf":1},"858":{"tf":1.4142135623730951},"881":{"tf":1},"886":{"tf":1.4142135623730951},"894":{"tf":1},"896":{"tf":1},"915":{"tf":1},"933":{"tf":1},"946":{"tf":1},"957":{"tf":1}},"df":47,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"182":{"tf":1},"417":{"tf":1},"635":{"tf":1}},"df":3}}}}}}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"54":{"tf":1},"164":{"tf":1.4142135623730951},"169":{"tf":2.8284271247461903},"171":{"tf":1},"177":{"tf":2},"178":{"tf":2.449489742783178},"181":{"tf":1},"182":{"tf":1.7320508075688772},"187":{"tf":1},"189":{"tf":1},"192":{"tf":2.6457513110645907},"209":{"tf":1.4142135623730951},"229":{"tf":1},"286":{"tf":1},"399":{"tf":1.4142135623730951},"404":{"tf":2.8284271247461903},"406":{"tf":1},"412":{"tf":2},"413":{"tf":2.449489742783178},"416":{"tf":1},"417":{"tf":1.7320508075688772},"422":{"tf":1},"424":{"tf":1},"427":{"tf":2.6457513110645907},"460":{"tf":1},"517":{"tf":1},"617":{"tf":1.4142135623730951},"622":{"tf":2.8284271247461903},"624":{"tf":1},"630":{"tf":2},"631":{"tf":2.449489742783178},"634":{"tf":1},"635":{"tf":1.7320508075688772},"640":{"tf":1},"642":{"tf":1},"645":{"tf":2.6457513110645907},"674":{"tf":1},"827":{"tf":1.4142135623730951},"832":{"tf":2.23606797749979},"839":{"tf":1},"840":{"tf":1},"841":{"tf":2},"844":{"tf":1},"845":{"tf":1.4142135623730951},"850":{"tf":1},"852":{"tf":1},"855":{"tf":2.8284271247461903},"869":{"tf":1.4142135623730951},"881":{"tf":1},"897":{"tf":1},"898":{"tf":1},"947":{"tf":1},"948":{"tf":1},"951":{"tf":1.4142135623730951},"958":{"tf":1.4142135623730951},"960":{"tf":2.23606797749979},"961":{"tf":1.7320508075688772},"962":{"tf":1}},"df":58,"r":{"docs":{"936":{"tf":1}},"df":1}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"h":{"docs":{"890":{"tf":1}},"df":1}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"802":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}}}},"h":{"docs":{"21":{"tf":1},"116":{"tf":1.7320508075688772},"195":{"tf":1.4142135623730951},"210":{"tf":1},"213":{"tf":1},"215":{"tf":1},"347":{"tf":1.7320508075688772},"430":{"tf":1.4142135623730951},"444":{"tf":1},"446":{"tf":1},"484":{"tf":1},"578":{"tf":1.7320508075688772},"648":{"tf":1.4142135623730951},"658":{"tf":1},"660":{"tf":1},"858":{"tf":1.4142135623730951},"936":{"tf":1},"949":{"tf":1}},"df":18}},"i":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1},"247":{"tf":1},"478":{"tf":1},"692":{"tf":1}},"df":4}},"n":{"docs":{},"df":0,"e":{"docs":{"43":{"tf":1},"72":{"tf":1.4142135623730951},"275":{"tf":1},"303":{"tf":1.4142135623730951},"506":{"tf":1},"534":{"tf":1.4142135623730951},"720":{"tf":1}},"df":7,"l":{"docs":{"122":{"tf":1},"125":{"tf":1.7320508075688772},"357":{"tf":1},"360":{"tf":1.7320508075688772},"852":{"tf":1},"939":{"tf":1.4142135623730951},"940":{"tf":1},"941":{"tf":1.4142135623730951},"946":{"tf":1},"954":{"tf":1}},"df":10}},"i":{"docs":{},"df":0,"c":{"docs":{"161":{"tf":1},"363":{"tf":1},"396":{"tf":1},"614":{"tf":1},"791":{"tf":1},"824":{"tf":1}},"df":6}}},"c":{"docs":{},"df":0,"k":{"docs":{"168":{"tf":1.7320508075688772},"230":{"tf":1.7320508075688772},"231":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"403":{"tf":1.7320508075688772},"461":{"tf":1.7320508075688772},"462":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"621":{"tf":1.7320508075688772},"675":{"tf":1.7320508075688772},"676":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"881":{"tf":2.449489742783178}},"df":13,"a":{"docs":{},"df":0,"g":{"docs":{"81":{"tf":1},"94":{"tf":1.4142135623730951},"199":{"tf":2.23606797749979},"202":{"tf":1.7320508075688772},"203":{"tf":2},"204":{"tf":1.7320508075688772},"205":{"tf":1.7320508075688772},"206":{"tf":1.7320508075688772},"207":{"tf":1.7320508075688772},"208":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"210":{"tf":1.7320508075688772},"211":{"tf":2},"212":{"tf":1.7320508075688772},"213":{"tf":1.7320508075688772},"214":{"tf":1.7320508075688772},"215":{"tf":1.7320508075688772},"216":{"tf":1.7320508075688772},"217":{"tf":1.7320508075688772},"231":{"tf":1.4142135623730951},"232":{"tf":1},"312":{"tf":1},"325":{"tf":1.4142135623730951},"434":{"tf":2.23606797749979},"437":{"tf":1.7320508075688772},"438":{"tf":2},"439":{"tf":1.7320508075688772},"440":{"tf":1.7320508075688772},"441":{"tf":1.4142135623730951},"442":{"tf":2},"443":{"tf":1.7320508075688772},"444":{"tf":1.7320508075688772},"445":{"tf":1.7320508075688772},"446":{"tf":1.7320508075688772},"447":{"tf":1.7320508075688772},"448":{"tf":1.7320508075688772},"462":{"tf":1.4142135623730951},"463":{"tf":1},"543":{"tf":1},"556":{"tf":1.4142135623730951},"652":{"tf":2.23606797749979},"655":{"tf":1.4142135623730951},"656":{"tf":2},"657":{"tf":1.7320508075688772},"658":{"tf":1.7320508075688772},"659":{"tf":1.7320508075688772},"660":{"tf":1.7320508075688772},"661":{"tf":1.7320508075688772},"662":{"tf":1.7320508075688772},"676":{"tf":1.4142135623730951},"677":{"tf":1},"763":{"tf":1.4142135623730951},"862":{"tf":1.7320508075688772},"865":{"tf":1.4142135623730951},"866":{"tf":1.7320508075688772},"867":{"tf":1.7320508075688772},"868":{"tf":1.4142135623730951},"869":{"tf":1.4142135623730951},"881":{"tf":1.7320508075688772},"913":{"tf":1},"916":{"tf":1},"932":{"tf":1},"936":{"tf":2.449489742783178},"937":{"tf":1},"938":{"tf":2.23606797749979},"939":{"tf":3.605551275463989},"940":{"tf":1.7320508075688772},"944":{"tf":2.6457513110645907},"945":{"tf":1},"946":{"tf":2.6457513110645907},"951":{"tf":2},"954":{"tf":2.23606797749979},"957":{"tf":1},"959":{"tf":1}},"df":74,"e":{"docs":{},"df":0,"'":{"docs":{"946":{"tf":1}},"df":1}}}}}},"d":{"docs":{"81":{"tf":1},"312":{"tf":1},"543":{"tf":1}},"df":3},"y":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2},"u":{"docs":{},"df":0,"s":{"docs":{"128":{"tf":1.4142135623730951},"131":{"tf":1.4142135623730951},"138":{"tf":1},"139":{"tf":1},"140":{"tf":1},"144":{"tf":1},"149":{"tf":1},"150":{"tf":1.7320508075688772},"151":{"tf":1},"157":{"tf":1},"161":{"tf":2.23606797749979},"176":{"tf":1.4142135623730951},"181":{"tf":1},"183":{"tf":1},"229":{"tf":1},"363":{"tf":1},"366":{"tf":1.4142135623730951},"373":{"tf":1},"374":{"tf":1},"375":{"tf":1},"379":{"tf":1},"384":{"tf":1},"385":{"tf":1.7320508075688772},"392":{"tf":1},"396":{"tf":2.23606797749979},"411":{"tf":1.4142135623730951},"416":{"tf":1},"418":{"tf":1},"460":{"tf":1},"581":{"tf":1},"584":{"tf":1.4142135623730951},"591":{"tf":1},"592":{"tf":1},"593":{"tf":1},"597":{"tf":1},"602":{"tf":1},"603":{"tf":1.7320508075688772},"610":{"tf":1},"614":{"tf":2.23606797749979},"629":{"tf":1.4142135623730951},"634":{"tf":1},"636":{"tf":1},"674":{"tf":1},"791":{"tf":1.4142135623730951},"794":{"tf":1.4142135623730951},"800":{"tf":1},"803":{"tf":1},"807":{"tf":1.4142135623730951},"814":{"tf":1},"820":{"tf":1.4142135623730951},"821":{"tf":1},"824":{"tf":2},"846":{"tf":1},"881":{"tf":1}},"df":54}},"s":{"docs":{},"df":0,"s":{"docs":{"169":{"tf":1},"177":{"tf":1},"182":{"tf":1},"203":{"tf":1},"207":{"tf":1},"209":{"tf":1},"210":{"tf":1},"404":{"tf":1},"412":{"tf":1},"417":{"tf":1},"438":{"tf":1},"622":{"tf":1},"630":{"tf":1},"635":{"tf":1},"832":{"tf":1},"840":{"tf":1},"841":{"tf":1},"855":{"tf":1},"869":{"tf":1.4142135623730951},"911":{"tf":1},"912":{"tf":1}},"df":21,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"747":{"tf":1}},"df":1}}}}},"t":{"docs":{"182":{"tf":1},"417":{"tf":1},"635":{"tf":1},"845":{"tf":1},"909":{"tf":1}},"df":5}},"g":{"docs":{},"df":0,"e":{"docs":{"251":{"tf":1},"252":{"tf":1},"253":{"tf":1.7320508075688772},"254":{"tf":1},"295":{"tf":1},"298":{"tf":1},"299":{"tf":1},"350":{"tf":1},"356":{"tf":1},"740":{"tf":1}},"df":10}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"16":{"tf":1},"56":{"tf":1},"181":{"tf":1},"248":{"tf":1},"288":{"tf":1},"416":{"tf":1},"479":{"tf":1},"519":{"tf":1},"634":{"tf":1},"693":{"tf":1},"733":{"tf":1},"758":{"tf":1},"794":{"tf":1},"855":{"tf":1.4142135623730951},"946":{"tf":1}},"df":15}}}},"t":{"docs":{"171":{"tf":1},"406":{"tf":1},"624":{"tf":1},"834":{"tf":1},"898":{"tf":1},"901":{"tf":1},"918":{"tf":1}},"df":7},"l":{"docs":{},"df":0,"l":{"docs":{"866":{"tf":1}},"df":1}},"s":{"docs":{},"df":0,"h":{"docs":{"866":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"r":{"docs":{"891":{"tf":1},"901":{"tf":1},"946":{"tf":1}},"df":3,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"26":{"tf":1},"72":{"tf":1},"86":{"tf":1},"125":{"tf":2.23606797749979},"140":{"tf":1.4142135623730951},"164":{"tf":1},"168":{"tf":1},"253":{"tf":1},"258":{"tf":1},"303":{"tf":1},"360":{"tf":2.23606797749979},"375":{"tf":1.4142135623730951},"399":{"tf":1},"403":{"tf":1},"489":{"tf":1},"534":{"tf":1},"548":{"tf":1},"593":{"tf":1.4142135623730951},"617":{"tf":1},"621":{"tf":1},"698":{"tf":1},"703":{"tf":1},"728":{"tf":1},"748":{"tf":1},"774":{"tf":1},"803":{"tf":1.4142135623730951},"844":{"tf":1},"855":{"tf":1},"868":{"tf":1},"905":{"tf":1},"917":{"tf":1.4142135623730951},"929":{"tf":1},"932":{"tf":1},"936":{"tf":1.7320508075688772},"945":{"tf":1},"949":{"tf":1},"954":{"tf":1}},"df":37}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2,"a":{"docs":{},"df":0,"g":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"182":{"tf":1},"417":{"tf":1},"635":{"tf":1}},"df":3}}}},"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"758":{"tf":1}},"df":1},"s":{"docs":{},"df":0,"s":{"docs":{"866":{"tf":1}},"df":1}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{"933":{"tf":1},"960":{"tf":1}},"df":2}}}}},"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"43":{"tf":1},"275":{"tf":1},"506":{"tf":1},"720":{"tf":1}},"df":4}}}},"i":{"docs":{},"df":0,"e":{"docs":{"56":{"tf":1},"288":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":4}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"0":{"tf":1},"1":{"tf":1},"4":{"tf":2.23606797749979},"5":{"tf":1},"6":{"tf":1},"7":{"tf":1},"8":{"tf":1},"9":{"tf":1},"10":{"tf":1},"11":{"tf":1},"12":{"tf":1},"13":{"tf":1},"17":{"tf":1},"18":{"tf":1},"21":{"tf":1},"23":{"tf":1},"24":{"tf":1},"29":{"tf":1},"30":{"tf":1},"35":{"tf":1},"36":{"tf":1},"41":{"tf":1},"42":{"tf":1},"43":{"tf":1.7320508075688772},"44":{"tf":1},"45":{"tf":1},"48":{"tf":1},"49":{"tf":1},"51":{"tf":1},"52":{"tf":1},"53":{"tf":1},"57":{"tf":1},"58":{"tf":1},"59":{"tf":1.4142135623730951},"60":{"tf":1},"61":{"tf":1},"69":{"tf":1},"70":{"tf":1},"75":{"tf":1},"76":{"tf":1},"79":{"tf":1},"80":{"tf":1},"84":{"tf":1},"85":{"tf":1},"88":{"tf":1},"89":{"tf":1},"91":{"tf":1},"92":{"tf":1},"93":{"tf":1},"94":{"tf":1},"95":{"tf":1},"96":{"tf":1},"99":{"tf":1},"100":{"tf":1},"107":{"tf":1},"108":{"tf":1},"110":{"tf":1},"111":{"tf":1},"112":{"tf":1},"113":{"tf":1},"114":{"tf":1},"117":{"tf":1},"118":{"tf":1},"123":{"tf":1},"124":{"tf":1},"126":{"tf":1},"127":{"tf":1},"128":{"tf":1},"129":{"tf":1},"130":{"tf":1},"135":{"tf":1},"136":{"tf":1},"141":{"tf":1},"142":{"tf":1},"147":{"tf":1},"148":{"tf":1},"153":{"tf":1},"154":{"tf":1},"159":{"tf":1},"160":{"tf":1},"162":{"tf":1},"163":{"tf":1},"164":{"tf":1},"165":{"tf":1},"166":{"tf":1},"173":{"tf":1},"174":{"tf":1},"176":{"tf":1},"179":{"tf":1},"180":{"tf":1},"185":{"tf":1},"186":{"tf":1},"190":{"tf":1},"191":{"tf":1},"193":{"tf":1},"194":{"tf":1},"195":{"tf":1.4142135623730951},"196":{"tf":1},"197":{"tf":1},"200":{"tf":1},"201":{"tf":1},"218":{"tf":1},"219":{"tf":1},"220":{"tf":1},"221":{"tf":1},"222":{"tf":1},"227":{"tf":1},"228":{"tf":1},"235":{"tf":1},"236":{"tf":1},"237":{"tf":1.7320508075688772},"238":{"tf":1},"239":{"tf":1},"240":{"tf":1},"241":{"tf":1},"242":{"tf":1},"243":{"tf":1},"244":{"tf":1},"245":{"tf":1},"249":{"tf":1},"250":{"tf":1},"253":{"tf":1},"255":{"tf":1},"256":{"tf":1},"261":{"tf":1},"262":{"tf":1},"267":{"tf":1},"268":{"tf":1},"273":{"tf":1},"274":{"tf":1},"275":{"tf":1.7320508075688772},"276":{"tf":1},"277":{"tf":1},"280":{"tf":1},"281":{"tf":1},"283":{"tf":1},"284":{"tf":1},"285":{"tf":1},"289":{"tf":1},"290":{"tf":1},"291":{"tf":1.4142135623730951},"292":{"tf":1},"293":{"tf":1},"300":{"tf":1},"301":{"tf":1},"306":{"tf":1},"307":{"tf":1},"310":{"tf":1},"311":{"tf":1},"315":{"tf":1},"316":{"tf":1},"319":{"tf":1},"320":{"tf":1},"322":{"tf":1},"323":{"tf":1},"324":{"tf":1},"325":{"tf":1},"326":{"tf":1},"327":{"tf":1},"330":{"tf":1},"331":{"tf":1},"338":{"tf":1},"339":{"tf":1},"341":{"tf":1},"342":{"tf":1},"343":{"tf":1},"344":{"tf":1},"345":{"tf":1},"348":{"tf":1},"349":{"tf":1},"352":{"tf":1},"353":{"tf":1},"358":{"tf":1},"359":{"tf":1},"361":{"tf":1},"362":{"tf":1},"363":{"tf":1},"364":{"tf":1},"365":{"tf":1},"370":{"tf":1},"371":{"tf":1},"376":{"tf":1},"377":{"tf":1},"382":{"tf":1},"383":{"tf":1},"388":{"tf":1},"389":{"tf":1},"394":{"tf":1},"395":{"tf":1},"397":{"tf":1},"398":{"tf":1},"399":{"tf":1},"400":{"tf":1},"401":{"tf":1},"408":{"tf":1},"409":{"tf":1},"411":{"tf":1},"414":{"tf":1},"415":{"tf":1},"420":{"tf":1},"421":{"tf":1},"425":{"tf":1},"426":{"tf":1},"428":{"tf":1},"429":{"tf":1},"430":{"tf":1.4142135623730951},"431":{"tf":1},"432":{"tf":1},"435":{"tf":1},"436":{"tf":1},"449":{"tf":1},"450":{"tf":1},"451":{"tf":1},"452":{"tf":1},"453":{"tf":1},"458":{"tf":1},"459":{"tf":1},"466":{"tf":1},"467":{"tf":1},"468":{"tf":1.7320508075688772},"469":{"tf":1},"470":{"tf":1},"471":{"tf":1},"472":{"tf":1},"473":{"tf":1},"474":{"tf":1},"475":{"tf":1},"476":{"tf":1},"480":{"tf":1},"481":{"tf":1},"486":{"tf":1},"487":{"tf":1},"492":{"tf":1},"493":{"tf":1},"498":{"tf":1},"499":{"tf":1},"504":{"tf":1},"505":{"tf":1},"506":{"tf":1.7320508075688772},"507":{"tf":1},"508":{"tf":1},"511":{"tf":1},"512":{"tf":1},"514":{"tf":1},"515":{"tf":1},"516":{"tf":1},"520":{"tf":1},"521":{"tf":1},"522":{"tf":1.4142135623730951},"523":{"tf":1},"524":{"tf":1},"531":{"tf":1},"532":{"tf":1},"537":{"tf":1},"538":{"tf":1},"541":{"tf":1},"542":{"tf":1},"546":{"tf":1},"547":{"tf":1},"550":{"tf":1},"551":{"tf":1},"553":{"tf":1},"554":{"tf":1},"555":{"tf":1},"556":{"tf":1},"557":{"tf":1},"558":{"tf":1},"561":{"tf":1},"562":{"tf":1},"569":{"tf":1},"570":{"tf":1},"572":{"tf":1},"573":{"tf":1},"574":{"tf":1},"575":{"tf":1},"576":{"tf":1},"579":{"tf":1},"580":{"tf":1},"581":{"tf":1},"582":{"tf":1},"583":{"tf":1},"588":{"tf":1},"589":{"tf":1},"594":{"tf":1},"595":{"tf":1},"600":{"tf":1},"601":{"tf":1},"606":{"tf":1},"607":{"tf":1},"612":{"tf":1},"613":{"tf":1},"615":{"tf":1},"616":{"tf":1},"617":{"tf":1},"618":{"tf":1},"619":{"tf":1},"626":{"tf":1},"627":{"tf":1},"629":{"tf":1},"632":{"tf":1},"633":{"tf":1},"638":{"tf":1},"639":{"tf":1},"643":{"tf":1},"644":{"tf":1},"646":{"tf":1},"647":{"tf":1},"648":{"tf":1.4142135623730951},"649":{"tf":1},"650":{"tf":1},"653":{"tf":1},"654":{"tf":1},"663":{"tf":1},"664":{"tf":1},"665":{"tf":1},"666":{"tf":1},"667":{"tf":1},"672":{"tf":1},"673":{"tf":1},"680":{"tf":1},"681":{"tf":1},"682":{"tf":1.7320508075688772},"683":{"tf":1},"684":{"tf":1},"685":{"tf":1.4142135623730951},"686":{"tf":1},"687":{"tf":1},"689":{"tf":1},"690":{"tf":1},"691":{"tf":1},"694":{"tf":1},"695":{"tf":1},"698":{"tf":1},"700":{"tf":1},"701":{"tf":1},"706":{"tf":1},"707":{"tf":1},"712":{"tf":1},"713":{"tf":1},"718":{"tf":1},"719":{"tf":1},"720":{"tf":1.7320508075688772},"721":{"tf":1},"722":{"tf":1},"725":{"tf":1},"726":{"tf":1},"728":{"tf":1},"729":{"tf":1},"730":{"tf":1},"734":{"tf":1},"735":{"tf":1},"736":{"tf":1},"737":{"tf":1},"738":{"tf":1},"744":{"tf":1},"745":{"tf":1},"752":{"tf":1},"753":{"tf":1},"755":{"tf":1},"756":{"tf":1},"761":{"tf":1},"762":{"tf":1},"764":{"tf":1},"765":{"tf":1},"768":{"tf":1},"769":{"tf":1},"776":{"tf":1},"777":{"tf":1},"779":{"tf":1},"780":{"tf":1},"782":{"tf":1},"783":{"tf":1},"786":{"tf":1},"787":{"tf":1},"789":{"tf":1},"790":{"tf":1},"792":{"tf":1},"793":{"tf":1},"798":{"tf":1},"799":{"tf":1},"804":{"tf":1},"805":{"tf":1},"810":{"tf":1},"811":{"tf":1},"816":{"tf":1},"817":{"tf":1},"822":{"tf":1},"823":{"tf":1},"824":{"tf":1},"825":{"tf":1},"826":{"tf":1},"828":{"tf":1},"829":{"tf":1},"836":{"tf":1},"837":{"tf":1},"839":{"tf":1},"842":{"tf":1},"843":{"tf":1},"848":{"tf":1},"849":{"tf":1},"853":{"tf":1},"854":{"tf":1},"856":{"tf":1},"857":{"tf":1},"859":{"tf":1},"860":{"tf":1},"863":{"tf":1},"864":{"tf":1},"870":{"tf":1},"871":{"tf":1},"872":{"tf":1},"873":{"tf":1},"874":{"tf":1},"879":{"tf":1},"880":{"tf":1},"884":{"tf":1},"885":{"tf":1},"886":{"tf":1.4142135623730951},"887":{"tf":1},"888":{"tf":1},"903":{"tf":1},"904":{"tf":1},"930":{"tf":1},"931":{"tf":1}},"df":424}}}},"r":{"docs":{},"df":0,"n":{"docs":{"98":{"tf":1},"109":{"tf":1},"229":{"tf":1},"237":{"tf":1},"329":{"tf":1},"340":{"tf":1},"460":{"tf":1},"468":{"tf":1},"560":{"tf":1},"571":{"tf":1},"674":{"tf":1},"682":{"tf":1},"758":{"tf":1},"831":{"tf":1},"881":{"tf":1}},"df":15}}},"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"28":{"tf":1},"55":{"tf":1},"260":{"tf":1},"287":{"tf":1},"491":{"tf":1},"518":{"tf":1},"705":{"tf":1},"732":{"tf":1},"855":{"tf":1}},"df":10,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1},"21":{"tf":1},"37":{"tf":1},"38":{"tf":1},"68":{"tf":1},"90":{"tf":1},"115":{"tf":1},"116":{"tf":1},"122":{"tf":1},"128":{"tf":1},"161":{"tf":1},"177":{"tf":1},"229":{"tf":1},"246":{"tf":1},"253":{"tf":1},"269":{"tf":1},"270":{"tf":1},"295":{"tf":1},"299":{"tf":1},"321":{"tf":1},"346":{"tf":1},"347":{"tf":1},"357":{"tf":1},"363":{"tf":1},"396":{"tf":1},"412":{"tf":1},"460":{"tf":1},"477":{"tf":1},"484":{"tf":1},"500":{"tf":1},"501":{"tf":1},"530":{"tf":1},"552":{"tf":1},"577":{"tf":1},"578":{"tf":1},"581":{"tf":1},"614":{"tf":1},"630":{"tf":1},"674":{"tf":1},"691":{"tf":1},"698":{"tf":1},"714":{"tf":1},"715":{"tf":1},"847":{"tf":1},"881":{"tf":1}},"df":45}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951}},"df":2}}},"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"351":{"tf":2}},"df":1}}}}},"p":{"docs":{"56":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"125":{"tf":1},"177":{"tf":1},"182":{"tf":1},"183":{"tf":1},"232":{"tf":1.4142135623730951},"288":{"tf":1.4142135623730951},"312":{"tf":1.4142135623730951},"360":{"tf":1},"412":{"tf":1},"417":{"tf":1},"418":{"tf":1},"463":{"tf":1.4142135623730951},"519":{"tf":1.4142135623730951},"543":{"tf":1.4142135623730951},"630":{"tf":1},"635":{"tf":1},"636":{"tf":1},"677":{"tf":1.4142135623730951},"733":{"tf":1.4142135623730951},"840":{"tf":1},"845":{"tf":1},"846":{"tf":1},"881":{"tf":1.4142135623730951},"957":{"tf":1}},"df":26,"i":{"docs":{},"df":0,"c":{"docs":{"4":{"tf":1},"43":{"tf":1},"119":{"tf":1},"275":{"tf":1},"354":{"tf":1},"506":{"tf":1},"720":{"tf":1},"839":{"tf":1},"886":{"tf":1.4142135623730951}},"df":9}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"122":{"tf":1},"168":{"tf":1},"357":{"tf":1},"403":{"tf":1},"621":{"tf":1},"803":{"tf":1},"891":{"tf":1}},"df":7}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1},"212":{"tf":1},"357":{"tf":1},"443":{"tf":1},"657":{"tf":1},"754":{"tf":1}},"df":6}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"213":{"tf":1},"351":{"tf":1},"444":{"tf":1},"658":{"tf":1},"933":{"tf":1}},"df":5}}},"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"350":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"1":{"docs":{"915":{"tf":1.7320508075688772}},"df":1},"2":{"docs":{"915":{"tf":1.7320508075688772}},"df":1},"docs":{"3":{"tf":3.4641016151377544},"4":{"tf":3.605551275463989},"8":{"tf":2.449489742783178},"11":{"tf":1.7320508075688772},"14":{"tf":2.23606797749979},"15":{"tf":2.8284271247461903},"16":{"tf":1.4142135623730951},"20":{"tf":1},"21":{"tf":1.7320508075688772},"25":{"tf":1.7320508075688772},"26":{"tf":2},"27":{"tf":3.1622776601683795},"31":{"tf":2},"32":{"tf":2.23606797749979},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1.4142135623730951},"50":{"tf":2.6457513110645907},"51":{"tf":2.449489742783178},"54":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":2.23606797749979},"59":{"tf":1.7320508075688772},"62":{"tf":1.7320508075688772},"63":{"tf":1},"66":{"tf":1.7320508075688772},"67":{"tf":1},"68":{"tf":1},"74":{"tf":1},"78":{"tf":1},"81":{"tf":4.123105625617661},"82":{"tf":3.3166247903554},"83":{"tf":1},"86":{"tf":1.7320508075688772},"90":{"tf":2},"91":{"tf":1},"94":{"tf":2.23606797749979},"97":{"tf":2},"98":{"tf":1},"102":{"tf":1},"103":{"tf":1},"104":{"tf":1},"105":{"tf":2.449489742783178},"106":{"tf":1.4142135623730951},"109":{"tf":1.7320508075688772},"112":{"tf":1},"115":{"tf":1},"116":{"tf":1},"119":{"tf":1},"122":{"tf":1.7320508075688772},"125":{"tf":2},"128":{"tf":2},"131":{"tf":1},"132":{"tf":1.4142135623730951},"133":{"tf":1},"134":{"tf":1.7320508075688772},"137":{"tf":2.23606797749979},"140":{"tf":3.4641016151377544},"143":{"tf":1.4142135623730951},"144":{"tf":1},"146":{"tf":1.4142135623730951},"149":{"tf":1.4142135623730951},"150":{"tf":1.7320508075688772},"151":{"tf":1.4142135623730951},"156":{"tf":1},"157":{"tf":2},"158":{"tf":1},"161":{"tf":1.4142135623730951},"167":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"172":{"tf":1},"175":{"tf":1.7320508075688772},"176":{"tf":1},"177":{"tf":1.4142135623730951},"181":{"tf":1.7320508075688772},"182":{"tf":2.23606797749979},"183":{"tf":1},"187":{"tf":1.7320508075688772},"188":{"tf":1},"189":{"tf":2},"192":{"tf":4.358898943540674},"195":{"tf":2.23606797749979},"198":{"tf":1},"199":{"tf":1},"210":{"tf":2.8284271247461903},"214":{"tf":1},"226":{"tf":1},"229":{"tf":2.23606797749979},"230":{"tf":1},"231":{"tf":1},"232":{"tf":3.3166247903554},"233":{"tf":1.4142135623730951},"234":{"tf":1},"237":{"tf":1.4142135623730951},"240":{"tf":2.6457513110645907},"243":{"tf":1.7320508075688772},"246":{"tf":2.23606797749979},"247":{"tf":2.8284271247461903},"248":{"tf":1.4142135623730951},"252":{"tf":1},"253":{"tf":1.4142135623730951},"257":{"tf":1.7320508075688772},"258":{"tf":2},"259":{"tf":3.1622776601683795},"263":{"tf":2},"264":{"tf":2.23606797749979},"265":{"tf":1.7320508075688772},"266":{"tf":1.4142135623730951},"269":{"tf":1.4142135623730951},"270":{"tf":1.4142135623730951},"271":{"tf":1.4142135623730951},"282":{"tf":2.6457513110645907},"283":{"tf":2.449489742783178},"286":{"tf":1.7320508075688772},"287":{"tf":1.4142135623730951},"288":{"tf":2.23606797749979},"291":{"tf":1.7320508075688772},"294":{"tf":1.7320508075688772},"295":{"tf":1},"296":{"tf":1},"297":{"tf":1},"298":{"tf":1},"299":{"tf":1},"305":{"tf":1},"309":{"tf":1},"312":{"tf":4.123105625617661},"313":{"tf":3.3166247903554},"314":{"tf":1.4142135623730951},"317":{"tf":1.7320508075688772},"321":{"tf":2},"322":{"tf":1},"325":{"tf":2.23606797749979},"328":{"tf":2},"329":{"tf":1},"333":{"tf":1},"334":{"tf":1},"335":{"tf":1},"336":{"tf":2.449489742783178},"337":{"tf":1.4142135623730951},"340":{"tf":1.7320508075688772},"343":{"tf":1},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1},"351":{"tf":1},"354":{"tf":1.7320508075688772},"356":{"tf":1.7320508075688772},"357":{"tf":1.7320508075688772},"360":{"tf":2},"363":{"tf":1.7320508075688772},"366":{"tf":1},"367":{"tf":1.4142135623730951},"368":{"tf":1},"369":{"tf":1.7320508075688772},"372":{"tf":2.23606797749979},"375":{"tf":3.4641016151377544},"378":{"tf":1.4142135623730951},"379":{"tf":1},"381":{"tf":1.4142135623730951},"384":{"tf":1.4142135623730951},"385":{"tf":1.7320508075688772},"386":{"tf":1.4142135623730951},"391":{"tf":1},"392":{"tf":2},"393":{"tf":1},"396":{"tf":1.4142135623730951},"402":{"tf":1.4142135623730951},"403":{"tf":1.4142135623730951},"404":{"tf":1.4142135623730951},"407":{"tf":1},"410":{"tf":1.7320508075688772},"411":{"tf":1},"412":{"tf":1.4142135623730951},"416":{"tf":1.7320508075688772},"417":{"tf":2.23606797749979},"418":{"tf":1},"422":{"tf":1.7320508075688772},"423":{"tf":1},"424":{"tf":2},"427":{"tf":4.358898943540674},"430":{"tf":2.23606797749979},"433":{"tf":1},"434":{"tf":1},"445":{"tf":1},"460":{"tf":2.23606797749979},"461":{"tf":1},"462":{"tf":1},"463":{"tf":3.3166247903554},"464":{"tf":1.4142135623730951},"465":{"tf":1},"468":{"tf":1.4142135623730951},"471":{"tf":2.6457513110645907},"474":{"tf":1.7320508075688772},"477":{"tf":2.23606797749979},"478":{"tf":2.8284271247461903},"479":{"tf":1.4142135623730951},"483":{"tf":1},"484":{"tf":1},"488":{"tf":1.7320508075688772},"489":{"tf":2},"490":{"tf":3.1622776601683795},"494":{"tf":2},"495":{"tf":2.23606797749979},"496":{"tf":1.7320508075688772},"497":{"tf":1.4142135623730951},"500":{"tf":1.4142135623730951},"501":{"tf":1.4142135623730951},"502":{"tf":1.4142135623730951},"513":{"tf":2.6457513110645907},"514":{"tf":2.449489742783178},"517":{"tf":1.7320508075688772},"518":{"tf":1.4142135623730951},"519":{"tf":2.23606797749979},"522":{"tf":1.7320508075688772},"525":{"tf":1.7320508075688772},"528":{"tf":1.7320508075688772},"529":{"tf":1},"530":{"tf":1},"536":{"tf":1},"540":{"tf":1},"543":{"tf":4.123105625617661},"544":{"tf":3.3166247903554},"545":{"tf":1},"548":{"tf":1.7320508075688772},"552":{"tf":2},"553":{"tf":1},"556":{"tf":2.23606797749979},"559":{"tf":2},"560":{"tf":1},"564":{"tf":1},"565":{"tf":1},"566":{"tf":1},"567":{"tf":2.449489742783178},"568":{"tf":1.4142135623730951},"571":{"tf":1.7320508075688772},"574":{"tf":1},"577":{"tf":1},"578":{"tf":1},"581":{"tf":1.7320508075688772},"584":{"tf":1},"585":{"tf":1.4142135623730951},"586":{"tf":1},"587":{"tf":1.7320508075688772},"590":{"tf":2.23606797749979},"593":{"tf":3.4641016151377544},"596":{"tf":1.4142135623730951},"597":{"tf":1},"599":{"tf":1.4142135623730951},"602":{"tf":1.4142135623730951},"603":{"tf":1.7320508075688772},"604":{"tf":1.4142135623730951},"609":{"tf":1},"610":{"tf":2},"611":{"tf":1},"614":{"tf":1.4142135623730951},"620":{"tf":1.4142135623730951},"621":{"tf":1.4142135623730951},"622":{"tf":1.4142135623730951},"625":{"tf":1},"628":{"tf":1.7320508075688772},"629":{"tf":1},"630":{"tf":1.4142135623730951},"634":{"tf":1.7320508075688772},"635":{"tf":2.23606797749979},"636":{"tf":1},"640":{"tf":1.7320508075688772},"641":{"tf":1},"642":{"tf":2},"645":{"tf":4.358898943540674},"648":{"tf":2.23606797749979},"651":{"tf":1},"652":{"tf":1},"659":{"tf":1},"674":{"tf":2.23606797749979},"675":{"tf":1},"676":{"tf":1},"677":{"tf":3.3166247903554},"678":{"tf":1.4142135623730951},"679":{"tf":1},"682":{"tf":1.4142135623730951},"685":{"tf":2},"688":{"tf":1.4142135623730951},"691":{"tf":2.23606797749979},"692":{"tf":3},"693":{"tf":1.4142135623730951},"696":{"tf":1},"698":{"tf":1.4142135623730951},"702":{"tf":1.7320508075688772},"703":{"tf":2},"704":{"tf":3.3166247903554},"708":{"tf":2},"709":{"tf":2},"710":{"tf":1.7320508075688772},"711":{"tf":1.4142135623730951},"714":{"tf":1.4142135623730951},"715":{"tf":1.4142135623730951},"716":{"tf":1.4142135623730951},"717":{"tf":1},"727":{"tf":2.449489742783178},"728":{"tf":2.6457513110645907},"731":{"tf":1.4142135623730951},"732":{"tf":1.4142135623730951},"733":{"tf":2.23606797749979},"736":{"tf":1.4142135623730951},"739":{"tf":1.7320508075688772},"740":{"tf":1},"742":{"tf":1},"743":{"tf":1},"751":{"tf":1},"757":{"tf":3.7416573867739413},"758":{"tf":3},"760":{"tf":1},"763":{"tf":2.23606797749979},"766":{"tf":2.23606797749979},"767":{"tf":1.4142135623730951},"771":{"tf":1},"772":{"tf":1},"774":{"tf":2.449489742783178},"775":{"tf":1.4142135623730951},"778":{"tf":2},"784":{"tf":1},"788":{"tf":2},"791":{"tf":1.4142135623730951},"794":{"tf":1.7320508075688772},"795":{"tf":1.4142135623730951},"796":{"tf":1},"797":{"tf":1.7320508075688772},"800":{"tf":2},"803":{"tf":3.4641016151377544},"806":{"tf":2},"807":{"tf":1},"809":{"tf":1},"812":{"tf":1.7320508075688772},"813":{"tf":2.23606797749979},"818":{"tf":1.4142135623730951},"819":{"tf":1},"820":{"tf":1.7320508075688772},"821":{"tf":1.4142135623730951},"824":{"tf":2.8284271247461903},"830":{"tf":1.4142135623730951},"831":{"tf":1.4142135623730951},"832":{"tf":1},"835":{"tf":1.4142135623730951},"838":{"tf":1.7320508075688772},"839":{"tf":1.4142135623730951},"840":{"tf":1},"841":{"tf":1},"844":{"tf":1.7320508075688772},"845":{"tf":2},"850":{"tf":1.7320508075688772},"851":{"tf":1.4142135623730951},"852":{"tf":1.7320508075688772},"855":{"tf":3.7416573867739413},"858":{"tf":2.6457513110645907},"862":{"tf":1},"867":{"tf":1},"869":{"tf":1},"878":{"tf":1.4142135623730951},"881":{"tf":4.242640687119285},"882":{"tf":1.4142135623730951},"883":{"tf":1},"886":{"tf":1},"889":{"tf":2.8284271247461903},"890":{"tf":3},"891":{"tf":2.8284271247461903},"892":{"tf":3.1622776601683795},"893":{"tf":3},"894":{"tf":2.6457513110645907},"895":{"tf":2.23606797749979},"896":{"tf":3},"897":{"tf":1},"898":{"tf":2},"899":{"tf":2},"900":{"tf":1.4142135623730951},"901":{"tf":3.1622776601683795},"902":{"tf":3.3166247903554},"905":{"tf":2.6457513110645907},"906":{"tf":2.449489742783178},"907":{"tf":4.358898943540674},"908":{"tf":2.23606797749979},"909":{"tf":1.7320508075688772},"910":{"tf":2.23606797749979},"911":{"tf":2.8284271247461903},"912":{"tf":3.1622776601683795},"913":{"tf":3.1622776601683795},"914":{"tf":1},"915":{"tf":4},"916":{"tf":4.358898943540674},"917":{"tf":2.8284271247461903},"918":{"tf":1.4142135623730951},"920":{"tf":2.23606797749979},"921":{"tf":2},"922":{"tf":2},"924":{"tf":3.3166247903554},"925":{"tf":1.7320508075688772},"926":{"tf":2.449489742783178},"928":{"tf":1},"929":{"tf":1.4142135623730951},"932":{"tf":2},"933":{"tf":4.242640687119285},"934":{"tf":1.4142135623730951},"935":{"tf":1.7320508075688772},"936":{"tf":2.449489742783178},"939":{"tf":1.4142135623730951},"940":{"tf":1.4142135623730951},"941":{"tf":1.4142135623730951},"945":{"tf":1.4142135623730951},"946":{"tf":1},"949":{"tf":1},"951":{"tf":1},"954":{"tf":1},"960":{"tf":1.4142135623730951},"962":{"tf":1}},"df":416,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"211":{"tf":1},"442":{"tf":1},"656":{"tf":1},"747":{"tf":1.4142135623730951}},"df":5},"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"927":{"tf":1}},"df":1}}}}}},".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"852":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"915":{"tf":1.7320508075688772}},"df":1}}}}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.4142135623730951},"8":{"tf":1},"202":{"tf":1},"208":{"tf":1.4142135623730951},"240":{"tf":1},"437":{"tf":1},"441":{"tf":1.4142135623730951},"471":{"tf":1},"685":{"tf":1},"698":{"tf":1},"886":{"tf":1}},"df":12}}}},"i":{"docs":{},"df":0,"c":{"docs":{"3":{"tf":1.4142135623730951},"119":{"tf":1},"122":{"tf":1},"351":{"tf":1},"354":{"tf":1},"357":{"tf":1}},"df":6},"q":{"docs":{},"df":0,"u":{"docs":{"812":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"m":{"docs":{"696":{"tf":1}},"df":1,"i":{"docs":{},"df":0,"n":{"docs":{"15":{"tf":1},"47":{"tf":1},"86":{"tf":1},"90":{"tf":1.4142135623730951},"247":{"tf":1},"279":{"tf":1},"317":{"tf":1},"321":{"tf":1.4142135623730951},"478":{"tf":1},"510":{"tf":1},"548":{"tf":1},"552":{"tf":1.4142135623730951},"692":{"tf":1},"724":{"tf":1.4142135623730951},"855":{"tf":1}},"df":15}}}},"l":{"docs":{},"df":0,"l":{"docs":{"33":{"tf":1},"155":{"tf":1},"171":{"tf":1.4142135623730951},"265":{"tf":1},"390":{"tf":1},"406":{"tf":1.4142135623730951},"496":{"tf":1},"608":{"tf":1},"624":{"tf":1.4142135623730951},"710":{"tf":1},"717":{"tf":1},"834":{"tf":1.4142135623730951},"850":{"tf":1}},"df":13}},"a":{"docs":{},"df":0,"m":{"docs":{"43":{"tf":1.4142135623730951},"275":{"tf":1.4142135623730951},"351":{"tf":1},"506":{"tf":1.4142135623730951},"720":{"tf":1.4142135623730951}},"df":5}},"x":{"docs":{},"df":0,"t":{"docs":{"77":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"122":{"tf":2},"125":{"tf":2},"155":{"tf":1},"156":{"tf":1.4142135623730951},"157":{"tf":1},"168":{"tf":1},"170":{"tf":1.4142135623730951},"171":{"tf":2.6457513110645907},"172":{"tf":1},"175":{"tf":1},"187":{"tf":1},"189":{"tf":1},"216":{"tf":1},"253":{"tf":1},"308":{"tf":1.4142135623730951},"350":{"tf":2.8284271247461903},"354":{"tf":1.4142135623730951},"357":{"tf":2.23606797749979},"360":{"tf":2},"390":{"tf":1},"391":{"tf":1.4142135623730951},"392":{"tf":1},"403":{"tf":1},"405":{"tf":1.4142135623730951},"406":{"tf":2.6457513110645907},"407":{"tf":1},"410":{"tf":1},"422":{"tf":1},"424":{"tf":1},"447":{"tf":1},"539":{"tf":1.4142135623730951},"577":{"tf":1},"578":{"tf":2.449489742783178},"608":{"tf":1},"609":{"tf":1.4142135623730951},"610":{"tf":1},"621":{"tf":1},"623":{"tf":1.4142135623730951},"624":{"tf":2.6457513110645907},"625":{"tf":1},"628":{"tf":1},"640":{"tf":1},"642":{"tf":1},"661":{"tf":1},"747":{"tf":1.4142135623730951},"754":{"tf":1.7320508075688772},"784":{"tf":1},"785":{"tf":2},"818":{"tf":1.4142135623730951},"819":{"tf":1.4142135623730951},"820":{"tf":1},"831":{"tf":1},"832":{"tf":1},"833":{"tf":1.4142135623730951},"834":{"tf":2.23606797749979},"835":{"tf":1},"838":{"tf":1},"850":{"tf":1},"852":{"tf":1},"868":{"tf":1},"881":{"tf":1.4142135623730951},"898":{"tf":1},"939":{"tf":1.7320508075688772},"946":{"tf":3.4641016151377544},"947":{"tf":1},"948":{"tf":1},"951":{"tf":2.449489742783178},"952":{"tf":1},"953":{"tf":1},"954":{"tf":2.23606797749979},"958":{"tf":2.23606797749979},"960":{"tf":1.7320508075688772},"961":{"tf":1}},"df":75,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"77":{"tf":1},"115":{"tf":1},"116":{"tf":2.449489742783178},"308":{"tf":1},"346":{"tf":1},"347":{"tf":2.449489742783178},"539":{"tf":1}},"df":7}}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"119":{"tf":1},"120":{"tf":1},"122":{"tf":1.7320508075688772},"354":{"tf":1},"355":{"tf":1},"357":{"tf":1.7320508075688772}},"df":6,":":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951}},"df":2}}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"=":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}}}}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"=":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}},"n":{"docs":{},"df":0,"d":{"docs":{"140":{"tf":1},"375":{"tf":1},"593":{"tf":1}},"df":3}},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"946":{"tf":2},"948":{"tf":1.4142135623730951},"955":{"tf":1}},"df":3}}}}}},"h":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"3":{"tf":1},"4":{"tf":1.4142135623730951},"128":{"tf":1},"137":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"363":{"tf":1},"372":{"tf":1.4142135623730951},"457":{"tf":1.4142135623730951},"471":{"tf":1.4142135623730951},"581":{"tf":1},"590":{"tf":1.4142135623730951},"671":{"tf":1.4142135623730951},"727":{"tf":1},"791":{"tf":1},"800":{"tf":1},"813":{"tf":1},"929":{"tf":1}},"df":18,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"43":{"tf":1},"66":{"tf":1},"192":{"tf":1},"252":{"tf":1},"275":{"tf":1},"427":{"tf":1},"506":{"tf":1},"528":{"tf":1},"645":{"tf":1},"720":{"tf":1},"824":{"tf":1}},"df":12}}}}}},"w":{"docs":{"926":{"tf":1.4142135623730951}},"df":1,"n":{"docs":{"210":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1.7320508075688772},"55":{"tf":1},"56":{"tf":1},"66":{"tf":1},"102":{"tf":1},"103":{"tf":1},"105":{"tf":1},"287":{"tf":1},"288":{"tf":1},"333":{"tf":1},"334":{"tf":1},"336":{"tf":1},"518":{"tf":1},"519":{"tf":1},"528":{"tf":1},"564":{"tf":1},"565":{"tf":1},"567":{"tf":1},"732":{"tf":1},"733":{"tf":1},"771":{"tf":1},"772":{"tf":1},"774":{"tf":1},"890":{"tf":1},"892":{"tf":1.4142135623730951},"895":{"tf":1},"900":{"tf":1},"906":{"tf":1},"908":{"tf":1},"912":{"tf":1.4142135623730951}},"df":30}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"8":{"tf":1},"59":{"tf":1},"101":{"tf":1},"176":{"tf":1},"237":{"tf":1},"240":{"tf":1},"291":{"tf":1},"332":{"tf":1},"411":{"tf":1},"468":{"tf":1},"471":{"tf":1},"522":{"tf":1},"526":{"tf":1},"563":{"tf":1},"629":{"tf":1},"682":{"tf":1},"781":{"tf":1},"791":{"tf":1},"890":{"tf":1},"891":{"tf":1},"892":{"tf":1},"898":{"tf":1},"916":{"tf":1},"927":{"tf":1},"933":{"tf":1},"934":{"tf":1},"936":{"tf":1},"939":{"tf":1.4142135623730951},"944":{"tf":1},"946":{"tf":1.7320508075688772},"954":{"tf":1.7320508075688772}},"df":32}},"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"168":{"tf":1},"169":{"tf":1},"183":{"tf":1},"354":{"tf":1},"403":{"tf":1},"404":{"tf":1},"418":{"tf":1},"621":{"tf":1},"622":{"tf":1},"636":{"tf":1},"841":{"tf":1}},"df":11}}}},"u":{"docs":{"21":{"tf":1},"94":{"tf":1},"210":{"tf":1},"215":{"tf":1},"325":{"tf":1},"446":{"tf":1},"484":{"tf":1},"556":{"tf":1},"660":{"tf":1},"763":{"tf":1},"785":{"tf":1},"878":{"tf":1},"890":{"tf":1}},"df":13},"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"32":{"tf":1},"103":{"tf":1},"116":{"tf":1.4142135623730951},"264":{"tf":1},"334":{"tf":1},"347":{"tf":1.4142135623730951},"495":{"tf":1},"565":{"tf":1},"578":{"tf":1.4142135623730951},"709":{"tf":1},"772":{"tf":1},"895":{"tf":1},"913":{"tf":1.4142135623730951}},"df":13},"t":{"docs":{},"df":0,"i":{"docs":{"933":{"tf":1}},"df":1}}},"n":{"docs":{},"df":0,"g":{"docs":{"86":{"tf":1},"177":{"tf":1},"198":{"tf":1},"317":{"tf":1},"412":{"tf":1},"433":{"tf":1},"548":{"tf":1},"630":{"tf":1},"651":{"tf":1}},"df":9},"k":{"docs":{"119":{"tf":1},"351":{"tf":1},"948":{"tf":1}},"df":3}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"94":{"tf":1},"122":{"tf":1},"125":{"tf":1},"183":{"tf":1},"210":{"tf":1},"325":{"tf":1},"356":{"tf":1},"357":{"tf":1},"360":{"tf":1},"418":{"tf":1},"556":{"tf":1},"636":{"tf":1},"824":{"tf":1},"839":{"tf":1},"844":{"tf":1},"878":{"tf":1},"895":{"tf":1},"896":{"tf":1},"909":{"tf":1},"951":{"tf":1},"954":{"tf":1},"958":{"tf":1}},"df":22}}},"i":{"docs":{},"df":0,"n":{"docs":{"105":{"tf":1},"336":{"tf":1},"567":{"tf":1}},"df":3}}}},"m":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"v":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"188":{"tf":1},"423":{"tf":1},"641":{"tf":1}},"df":3}}}},"\"":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"844":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"82":{"tf":1.4142135623730951},"109":{"tf":1.7320508075688772},"168":{"tf":1},"229":{"tf":1},"230":{"tf":1},"231":{"tf":1},"313":{"tf":1.4142135623730951},"340":{"tf":1.7320508075688772},"403":{"tf":1},"460":{"tf":1},"461":{"tf":1},"462":{"tf":1},"544":{"tf":1.4142135623730951},"571":{"tf":1.7320508075688772},"621":{"tf":1},"674":{"tf":1},"675":{"tf":1},"676":{"tf":1},"778":{"tf":1},"881":{"tf":1.4142135623730951}},"df":20}}},"e":{"docs":{},"df":0,"r":{"docs":{"866":{"tf":1.4142135623730951}},"df":1}}}}},"c":{"docs":{},"df":0,"e":{"docs":{"155":{"tf":1},"183":{"tf":1},"390":{"tf":1},"418":{"tf":1},"608":{"tf":1},"636":{"tf":1}},"df":6}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"891":{"tf":1},"892":{"tf":1},"893":{"tf":1}},"df":3}}}},"e":{"docs":{},"df":0,"e":{"docs":{"15":{"tf":1.7320508075688772},"38":{"tf":1.4142135623730951},"43":{"tf":1.4142135623730951},"112":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":3.1622776601683795},"121":{"tf":1},"209":{"tf":2.23606797749979},"247":{"tf":1.7320508075688772},"270":{"tf":1.4142135623730951},"275":{"tf":1.4142135623730951},"305":{"tf":1},"343":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":3.1622776601683795},"350":{"tf":1.4142135623730951},"356":{"tf":2},"478":{"tf":1.7320508075688772},"501":{"tf":1.4142135623730951},"506":{"tf":1.4142135623730951},"574":{"tf":1},"577":{"tf":1.4142135623730951},"578":{"tf":3.1622776601683795},"692":{"tf":1.7320508075688772},"715":{"tf":1.4142135623730951},"720":{"tf":1.4142135623730951},"750":{"tf":1},"759":{"tf":1},"915":{"tf":1}},"df":29}},"i":{"docs":{"82":{"tf":1},"137":{"tf":1},"177":{"tf":1},"182":{"tf":1},"313":{"tf":1},"372":{"tf":1},"412":{"tf":1},"417":{"tf":1},"544":{"tf":1},"590":{"tf":1},"630":{"tf":1},"635":{"tf":1},"698":{"tf":1},"743":{"tf":1},"748":{"tf":1},"749":{"tf":1},"758":{"tf":1},"785":{"tf":1},"845":{"tf":1},"924":{"tf":1},"925":{"tf":2},"927":{"tf":1}},"df":22,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"l":{"docs":{"86":{"tf":1},"317":{"tf":1},"548":{"tf":1}},"df":3}}}},"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"128":{"tf":1},"149":{"tf":1},"363":{"tf":1},"384":{"tf":1},"581":{"tf":1},"602":{"tf":1},"791":{"tf":1},"921":{"tf":1}},"df":8}}}}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2}}}}}}}}}},"u":{"docs":{},"df":0,"e":{"docs":{"169":{"tf":1},"203":{"tf":1},"224":{"tf":1},"226":{"tf":1.4142135623730951},"231":{"tf":1},"232":{"tf":1.7320508075688772},"404":{"tf":1},"438":{"tf":1},"455":{"tf":1},"457":{"tf":1.7320508075688772},"462":{"tf":1},"463":{"tf":1.7320508075688772},"622":{"tf":1},"669":{"tf":1},"671":{"tf":1.7320508075688772},"676":{"tf":1},"677":{"tf":1.7320508075688772},"876":{"tf":1},"878":{"tf":1.4142135623730951},"881":{"tf":2}},"df":20}}},"w":{"docs":{},"df":0,"o":{"docs":{"15":{"tf":1},"20":{"tf":1},"63":{"tf":1},"78":{"tf":1},"82":{"tf":2},"94":{"tf":1},"97":{"tf":1},"98":{"tf":1},"115":{"tf":1},"119":{"tf":1},"167":{"tf":1},"168":{"tf":1.7320508075688772},"182":{"tf":1.4142135623730951},"183":{"tf":1},"220":{"tf":1.4142135623730951},"229":{"tf":1},"247":{"tf":1},"252":{"tf":1},"295":{"tf":1},"309":{"tf":1},"313":{"tf":2},"325":{"tf":1},"328":{"tf":1},"329":{"tf":1},"346":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1},"402":{"tf":1},"403":{"tf":1},"417":{"tf":1.4142135623730951},"418":{"tf":1},"451":{"tf":1.4142135623730951},"460":{"tf":1},"478":{"tf":1},"483":{"tf":1},"540":{"tf":1},"544":{"tf":2},"556":{"tf":1},"559":{"tf":1},"560":{"tf":1},"577":{"tf":1},"620":{"tf":1},"621":{"tf":1.7320508075688772},"635":{"tf":1.4142135623730951},"636":{"tf":1},"665":{"tf":1.4142135623730951},"674":{"tf":1},"692":{"tf":1},"697":{"tf":1},"698":{"tf":1.4142135623730951},"758":{"tf":1.7320508075688772},"763":{"tf":1},"766":{"tf":1},"767":{"tf":1},"784":{"tf":1},"813":{"tf":1},"830":{"tf":1},"831":{"tf":1},"844":{"tf":1},"845":{"tf":1},"846":{"tf":1},"872":{"tf":1.4142135623730951},"881":{"tf":1},"891":{"tf":1.4142135623730951},"898":{"tf":1},"911":{"tf":1},"915":{"tf":1},"916":{"tf":1},"933":{"tf":1.7320508075688772}},"df":69},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{"168":{"tf":1},"403":{"tf":1},"621":{"tf":1},"831":{"tf":1}},"df":4}}}},"a":{"docs":{},"df":0,"b":{"docs":{"26":{"tf":1},"72":{"tf":2},"195":{"tf":1},"231":{"tf":1},"258":{"tf":1},"303":{"tf":2},"305":{"tf":1},"430":{"tf":1},"462":{"tf":1},"489":{"tf":1.4142135623730951},"534":{"tf":2},"648":{"tf":1},"676":{"tf":1},"703":{"tf":1.4142135623730951},"749":{"tf":1.4142135623730951},"881":{"tf":1},"939":{"tf":1}},"df":17,"l":{"docs":{"26":{"tf":1},"72":{"tf":1},"112":{"tf":1},"115":{"tf":2},"116":{"tf":2.449489742783178},"122":{"tf":2},"125":{"tf":1.4142135623730951},"128":{"tf":1},"155":{"tf":1.4142135623730951},"169":{"tf":1},"171":{"tf":1},"175":{"tf":1},"176":{"tf":1.7320508075688772},"177":{"tf":2.23606797749979},"178":{"tf":1},"181":{"tf":2},"182":{"tf":3},"183":{"tf":1.4142135623730951},"187":{"tf":1},"189":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"195":{"tf":1},"208":{"tf":2.23606797749979},"226":{"tf":1},"229":{"tf":1.4142135623730951},"231":{"tf":1.7320508075688772},"232":{"tf":1.4142135623730951},"253":{"tf":1},"258":{"tf":1},"303":{"tf":1},"305":{"tf":1.4142135623730951},"343":{"tf":1},"346":{"tf":2},"347":{"tf":2.449489742783178},"350":{"tf":3.3166247903554},"351":{"tf":1},"354":{"tf":1},"357":{"tf":2.449489742783178},"360":{"tf":1.4142135623730951},"363":{"tf":1},"390":{"tf":1.4142135623730951},"404":{"tf":1},"406":{"tf":1},"410":{"tf":1},"411":{"tf":1.7320508075688772},"412":{"tf":2.23606797749979},"413":{"tf":1},"416":{"tf":2},"417":{"tf":3},"418":{"tf":1.4142135623730951},"422":{"tf":1},"424":{"tf":1.4142135623730951},"427":{"tf":1.7320508075688772},"430":{"tf":1},"441":{"tf":2.23606797749979},"457":{"tf":1},"460":{"tf":1.4142135623730951},"462":{"tf":1.7320508075688772},"463":{"tf":1.4142135623730951},"489":{"tf":1},"534":{"tf":1},"574":{"tf":1},"577":{"tf":2},"578":{"tf":2.449489742783178},"581":{"tf":1},"608":{"tf":1.4142135623730951},"622":{"tf":1},"624":{"tf":1},"628":{"tf":1},"629":{"tf":1.7320508075688772},"630":{"tf":2.23606797749979},"631":{"tf":1},"634":{"tf":2},"635":{"tf":3},"636":{"tf":1.4142135623730951},"640":{"tf":1},"642":{"tf":1.4142135623730951},"645":{"tf":1.7320508075688772},"648":{"tf":1},"671":{"tf":1},"674":{"tf":1.4142135623730951},"676":{"tf":1.7320508075688772},"677":{"tf":1.4142135623730951},"749":{"tf":1},"781":{"tf":1},"784":{"tf":1.4142135623730951},"785":{"tf":1.7320508075688772},"791":{"tf":1.7320508075688772},"818":{"tf":1},"832":{"tf":1},"834":{"tf":1},"838":{"tf":1},"839":{"tf":1.4142135623730951},"840":{"tf":1.7320508075688772},"841":{"tf":1},"844":{"tf":2.23606797749979},"845":{"tf":2.8284271247461903},"846":{"tf":1.4142135623730951},"850":{"tf":1},"852":{"tf":1.4142135623730951},"855":{"tf":1.4142135623730951},"878":{"tf":1},"881":{"tf":1.7320508075688772},"894":{"tf":2.23606797749979},"895":{"tf":1.4142135623730951},"896":{"tf":1},"897":{"tf":1},"898":{"tf":1},"899":{"tf":1},"938":{"tf":1},"939":{"tf":1}},"df":111,"e":{"docs":{},"df":0,":":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"=":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"@":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"&":{"0":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2},"docs":{},"df":0}}}}}}}}}}}}}}}}}}}}}}}}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"939":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1},"213":{"tf":1},"259":{"tf":1},"444":{"tf":1},"490":{"tf":1},"658":{"tf":1},"704":{"tf":1},"750":{"tf":1},"951":{"tf":1}},"df":9}}}},"k":{"docs":{},"df":0,"e":{"docs":{"43":{"tf":1},"50":{"tf":1},"120":{"tf":1},"155":{"tf":1},"275":{"tf":1},"282":{"tf":1},"355":{"tf":1},"390":{"tf":1},"506":{"tf":1},"513":{"tf":1},"608":{"tf":1},"720":{"tf":1},"766":{"tf":1},"784":{"tf":1},"830":{"tf":1},"861":{"tf":1},"865":{"tf":1},"886":{"tf":1},"889":{"tf":1},"905":{"tf":1},"906":{"tf":1},"907":{"tf":1},"913":{"tf":1},"915":{"tf":1},"917":{"tf":1},"932":{"tf":1},"933":{"tf":1},"937":{"tf":1},"943":{"tf":1},"960":{"tf":1},"963":{"tf":1}},"df":31,"n":{"docs":{"39":{"tf":1},"183":{"tf":1},"203":{"tf":1.4142135623730951},"271":{"tf":1},"418":{"tf":1},"438":{"tf":1.4142135623730951},"502":{"tf":1},"636":{"tf":1},"716":{"tf":1},"818":{"tf":1},"846":{"tf":1},"944":{"tf":1}},"df":12}}},"l":{"docs":{},"df":0,"k":{"docs":{"112":{"tf":1},"343":{"tf":1},"574":{"tf":1}},"df":3}},"s":{"docs":{},"df":0,"k":{"docs":{"858":{"tf":1}},"df":1}},"g":{"docs":{"956":{"tf":1}},"df":1}},"y":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{"27":{"tf":1},"43":{"tf":1},"55":{"tf":1},"62":{"tf":1},"63":{"tf":1.4142135623730951},"64":{"tf":1},"90":{"tf":1},"115":{"tf":1},"116":{"tf":2.449489742783178},"122":{"tf":1},"125":{"tf":1},"171":{"tf":1.4142135623730951},"195":{"tf":1.4142135623730951},"226":{"tf":1},"232":{"tf":1.4142135623730951},"259":{"tf":1},"275":{"tf":1},"287":{"tf":1},"294":{"tf":1},"295":{"tf":1},"321":{"tf":1},"346":{"tf":1},"347":{"tf":2.449489742783178},"357":{"tf":1},"360":{"tf":1},"406":{"tf":1.4142135623730951},"430":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"490":{"tf":1},"506":{"tf":1},"518":{"tf":1},"525":{"tf":1},"526":{"tf":1},"552":{"tf":1},"577":{"tf":1},"578":{"tf":2.449489742783178},"624":{"tf":1.4142135623730951},"648":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"704":{"tf":1},"720":{"tf":1},"732":{"tf":1},"740":{"tf":1},"747":{"tf":1.4142135623730951},"784":{"tf":1},"785":{"tf":1},"858":{"tf":1},"881":{"tf":1.4142135623730951},"894":{"tf":1},"954":{"tf":1.4142135623730951}},"df":50},"i":{"docs":{},"df":0,"c":{"docs":{"143":{"tf":1},"176":{"tf":1},"192":{"tf":1.4142135623730951},"295":{"tf":1},"378":{"tf":1},"411":{"tf":1},"427":{"tf":1.4142135623730951},"596":{"tf":1},"629":{"tf":1},"645":{"tf":1.4142135623730951},"855":{"tf":1},"906":{"tf":1},"939":{"tf":1}},"df":13}}}},"i":{"docs":{},"df":0,"p":{"docs":{"28":{"tf":1},"43":{"tf":1},"260":{"tf":1},"275":{"tf":1},"491":{"tf":1},"506":{"tf":1},"705":{"tf":1},"720":{"tf":1}},"df":8},"m":{"docs":{},"df":0,"e":{"docs":{"33":{"tf":1},"38":{"tf":1},"39":{"tf":1},"40":{"tf":1},"73":{"tf":1},"74":{"tf":1},"116":{"tf":1.4142135623730951},"125":{"tf":1},"128":{"tf":1},"169":{"tf":1},"177":{"tf":1},"183":{"tf":1},"192":{"tf":1.4142135623730951},"214":{"tf":1.4142135623730951},"226":{"tf":1.7320508075688772},"229":{"tf":2},"234":{"tf":1},"237":{"tf":1.7320508075688772},"265":{"tf":1},"270":{"tf":1},"271":{"tf":1},"272":{"tf":1},"304":{"tf":1},"305":{"tf":1},"347":{"tf":1.4142135623730951},"350":{"tf":1},"351":{"tf":1},"360":{"tf":1},"363":{"tf":1},"404":{"tf":1},"412":{"tf":1},"418":{"tf":1},"427":{"tf":1.4142135623730951},"445":{"tf":1.4142135623730951},"457":{"tf":1.7320508075688772},"460":{"tf":2},"465":{"tf":1},"468":{"tf":1.7320508075688772},"496":{"tf":1},"501":{"tf":1},"502":{"tf":1},"503":{"tf":1},"535":{"tf":1},"536":{"tf":1},"578":{"tf":1.4142135623730951},"581":{"tf":1},"622":{"tf":1},"630":{"tf":1},"636":{"tf":1},"645":{"tf":1.4142135623730951},"659":{"tf":1.4142135623730951},"671":{"tf":1.7320508075688772},"674":{"tf":2},"679":{"tf":1},"682":{"tf":1.7320508075688772},"698":{"tf":1},"710":{"tf":1},"715":{"tf":1},"716":{"tf":1.4142135623730951},"717":{"tf":1},"748":{"tf":1},"763":{"tf":1},"797":{"tf":1},"818":{"tf":1.4142135623730951},"832":{"tf":1},"846":{"tf":1},"855":{"tf":1},"867":{"tf":1.7320508075688772},"881":{"tf":2},"883":{"tf":1},"912":{"tf":1.4142135623730951},"913":{"tf":1},"929":{"tf":1},"933":{"tf":1},"941":{"tf":1},"951":{"tf":1}},"df":76,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{"214":{"tf":1},"445":{"tf":1},"659":{"tf":1}},"df":3}}}}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"916":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"l":{"docs":{"116":{"tf":1},"125":{"tf":1.7320508075688772},"347":{"tf":1},"360":{"tf":1.7320508075688772},"526":{"tf":1.4142135623730951},"578":{"tf":1}},"df":6,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,":":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"=":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"k":{"docs":{"178":{"tf":1},"413":{"tf":1},"631":{"tf":1},"850":{"tf":1}},"df":4}}},"d":{"docs":{"350":{"tf":1.4142135623730951}},"df":1}},"q":{"docs":{},"df":0,"f":{"docs":{"4":{"tf":1},"199":{"tf":1.4142135623730951},"434":{"tf":1.4142135623730951},"652":{"tf":1.4142135623730951},"862":{"tf":1.4142135623730951}},"df":5,"‑":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":3.1622776601683795},"4":{"tf":2.8284271247461903},"5":{"tf":1},"8":{"tf":2.449489742783178},"14":{"tf":2.449489742783178},"15":{"tf":1},"21":{"tf":2.23606797749979},"27":{"tf":1.4142135623730951},"32":{"tf":1},"34":{"tf":1},"37":{"tf":1},"40":{"tf":1},"43":{"tf":1.4142135623730951},"54":{"tf":1},"55":{"tf":1},"59":{"tf":1},"62":{"tf":1},"64":{"tf":2},"67":{"tf":1},"81":{"tf":1},"82":{"tf":1.4142135623730951},"94":{"tf":1},"97":{"tf":1},"109":{"tf":1.4142135623730951},"115":{"tf":1},"116":{"tf":2.8284271247461903},"119":{"tf":2.23606797749979},"122":{"tf":3.872983346207417},"125":{"tf":2.23606797749979},"128":{"tf":1.4142135623730951},"131":{"tf":1},"134":{"tf":1},"140":{"tf":1},"143":{"tf":1},"144":{"tf":1},"145":{"tf":1},"150":{"tf":1.4142135623730951},"157":{"tf":1},"161":{"tf":1.4142135623730951},"168":{"tf":1.4142135623730951},"171":{"tf":2.449489742783178},"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"182":{"tf":1.4142135623730951},"187":{"tf":1},"189":{"tf":1},"192":{"tf":2},"195":{"tf":2},"198":{"tf":1},"203":{"tf":1},"207":{"tf":1},"209":{"tf":1},"215":{"tf":1.4142135623730951},"220":{"tf":1},"226":{"tf":1.7320508075688772},"229":{"tf":2},"230":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"240":{"tf":2.449489742783178},"246":{"tf":2.449489742783178},"247":{"tf":1},"253":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"264":{"tf":1},"266":{"tf":1},"269":{"tf":1},"272":{"tf":1},"275":{"tf":1.4142135623730951},"286":{"tf":1},"287":{"tf":1},"291":{"tf":1},"294":{"tf":1},"295":{"tf":2},"298":{"tf":1},"305":{"tf":1},"312":{"tf":1},"313":{"tf":1.4142135623730951},"325":{"tf":1},"328":{"tf":1},"340":{"tf":1.4142135623730951},"346":{"tf":1},"347":{"tf":2.8284271247461903},"350":{"tf":2.8284271247461903},"351":{"tf":1.7320508075688772},"354":{"tf":2.23606797749979},"357":{"tf":4},"360":{"tf":2.23606797749979},"363":{"tf":1.4142135623730951},"366":{"tf":1},"369":{"tf":1},"375":{"tf":1},"378":{"tf":1},"379":{"tf":1},"380":{"tf":1},"385":{"tf":1.4142135623730951},"392":{"tf":1},"396":{"tf":1.4142135623730951},"403":{"tf":1},"406":{"tf":2.449489742783178},"411":{"tf":1.4142135623730951},"412":{"tf":1.4142135623730951},"413":{"tf":1.4142135623730951},"416":{"tf":1.4142135623730951},"417":{"tf":1.4142135623730951},"422":{"tf":1},"424":{"tf":1},"427":{"tf":2},"430":{"tf":2},"433":{"tf":1},"438":{"tf":1},"446":{"tf":1.4142135623730951},"451":{"tf":1},"457":{"tf":1.7320508075688772},"460":{"tf":2},"461":{"tf":1},"462":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"471":{"tf":2.449489742783178},"477":{"tf":2.449489742783178},"478":{"tf":1},"484":{"tf":2},"490":{"tf":1.4142135623730951},"495":{"tf":1},"497":{"tf":1},"500":{"tf":1},"503":{"tf":1},"506":{"tf":1.4142135623730951},"517":{"tf":1},"518":{"tf":1},"522":{"tf":1},"525":{"tf":1},"526":{"tf":2.23606797749979},"529":{"tf":1},"534":{"tf":1},"543":{"tf":1},"544":{"tf":1.4142135623730951},"556":{"tf":1},"559":{"tf":1},"571":{"tf":1.4142135623730951},"577":{"tf":1},"578":{"tf":2.8284271247461903},"581":{"tf":1.4142135623730951},"584":{"tf":1},"587":{"tf":1},"593":{"tf":1},"596":{"tf":1},"597":{"tf":1},"598":{"tf":1},"603":{"tf":1.4142135623730951},"610":{"tf":1},"614":{"tf":1.4142135623730951},"621":{"tf":1.4142135623730951},"624":{"tf":2.449489742783178},"629":{"tf":1.4142135623730951},"630":{"tf":1.4142135623730951},"631":{"tf":1.4142135623730951},"634":{"tf":1.4142135623730951},"635":{"tf":1.4142135623730951},"640":{"tf":1},"642":{"tf":1},"645":{"tf":2},"648":{"tf":2},"651":{"tf":1},"660":{"tf":1.4142135623730951},"665":{"tf":1},"671":{"tf":1.7320508075688772},"674":{"tf":2},"675":{"tf":1},"676":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"685":{"tf":2},"691":{"tf":2.449489742783178},"692":{"tf":1},"698":{"tf":2},"704":{"tf":1.4142135623730951},"711":{"tf":1},"714":{"tf":1},"717":{"tf":1.4142135623730951},"720":{"tf":1.4142135623730951},"724":{"tf":1},"727":{"tf":1},"731":{"tf":1},"732":{"tf":1},"739":{"tf":1},"740":{"tf":1},"741":{"tf":1},"749":{"tf":1},"758":{"tf":1.4142135623730951},"763":{"tf":1},"766":{"tf":1},"778":{"tf":1.4142135623730951},"781":{"tf":1.4142135623730951},"784":{"tf":1},"785":{"tf":1.7320508075688772},"788":{"tf":1.4142135623730951},"791":{"tf":2},"794":{"tf":1},"797":{"tf":1},"807":{"tf":1},"808":{"tf":1},"813":{"tf":1},"814":{"tf":1},"819":{"tf":1},"820":{"tf":1.4142135623730951},"824":{"tf":1},"831":{"tf":1},"834":{"tf":2.23606797749979},"839":{"tf":1},"840":{"tf":1.4142135623730951},"841":{"tf":1.4142135623730951},"844":{"tf":1},"845":{"tf":1.4142135623730951},"850":{"tf":1},"852":{"tf":1},"855":{"tf":1.4142135623730951},"858":{"tf":2.23606797749979},"861":{"tf":1},"872":{"tf":1},"878":{"tf":1},"881":{"tf":3},"886":{"tf":1.4142135623730951},"889":{"tf":1},"891":{"tf":1},"893":{"tf":1},"894":{"tf":1.7320508075688772},"902":{"tf":1.4142135623730951},"905":{"tf":1},"907":{"tf":1.4142135623730951},"913":{"tf":1},"915":{"tf":1},"917":{"tf":1.4142135623730951},"926":{"tf":1},"929":{"tf":1},"932":{"tf":1},"933":{"tf":1},"936":{"tf":1.7320508075688772},"943":{"tf":1},"946":{"tf":1.4142135623730951},"948":{"tf":2.23606797749979},"949":{"tf":1.7320508075688772},"951":{"tf":1.4142135623730951},"954":{"tf":1},"955":{"tf":1},"957":{"tf":1}},"df":247,"'":{"docs":{"128":{"tf":1},"363":{"tf":1},"581":{"tf":1},"901":{"tf":1}},"df":4},"’":{"docs":{"806":{"tf":1}},"df":1}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"21":{"tf":1},"64":{"tf":1},"97":{"tf":1},"198":{"tf":1},"215":{"tf":1},"226":{"tf":1},"246":{"tf":1},"295":{"tf":1},"328":{"tf":1},"433":{"tf":1},"446":{"tf":1},"457":{"tf":1},"477":{"tf":1},"484":{"tf":1},"526":{"tf":1},"559":{"tf":1},"651":{"tf":1},"660":{"tf":1},"671":{"tf":1},"691":{"tf":1},"740":{"tf":1},"766":{"tf":1},"852":{"tf":1},"861":{"tf":1},"886":{"tf":1},"889":{"tf":1.4142135623730951},"901":{"tf":1.4142135623730951},"902":{"tf":1},"905":{"tf":1.4142135623730951},"906":{"tf":1},"908":{"tf":1},"916":{"tf":1},"920":{"tf":1},"932":{"tf":1.4142135623730951},"933":{"tf":1},"935":{"tf":1},"936":{"tf":1},"943":{"tf":1}},"df":39,":":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{"21":{"tf":1},"64":{"tf":1},"295":{"tf":1},"484":{"tf":1},"526":{"tf":1}},"df":5}}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"}":{"docs":{},"df":0,"/":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"741":{"tf":1}},"df":1,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"k":{"docs":{"741":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"226":{"tf":1},"457":{"tf":1},"671":{"tf":1}},"df":3}}}}}}}}}}},"s":{"docs":{},"df":0,":":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"122":{"tf":1}},"df":1}}}}},"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"122":{"tf":1}},"df":1}}}}}}}}}}},"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"122":{"tf":1.7320508075688772},"357":{"tf":2}},"df":2}}}}}},".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"195":{"tf":2.8284271247461903},"198":{"tf":1},"231":{"tf":1},"430":{"tf":2.8284271247461903},"433":{"tf":1},"462":{"tf":1},"648":{"tf":2.8284271247461903},"651":{"tf":1},"676":{"tf":1},"858":{"tf":2.23606797749979},"861":{"tf":1},"881":{"tf":1}},"df":12}}},"f":{"docs":{},"df":0,"x":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":1}},"df":1}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"204":{"tf":1}},"df":1}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"210":{"tf":1}},"df":1,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"927":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"205":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"206":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"207":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{"209":{"tf":1}},"df":1}}}}}}},"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":1}},"df":1}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"204":{"tf":1}},"df":1}}}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"210":{"tf":1}},"df":1,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"927":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"205":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"206":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"207":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1},"231":{"tf":1.4142135623730951}},"df":2}}},"r":{"docs":{},"df":0,"e":{"docs":{"209":{"tf":1}},"df":1}}}}}}},"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":1}},"df":1}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{"204":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"210":{"tf":1}},"df":1,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"927":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"205":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"206":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"207":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{"209":{"tf":1}},"df":1}}}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"213":{"tf":1},"444":{"tf":1},"658":{"tf":1}},"df":3}}}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":1},"438":{"tf":1}},"df":2}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1},"439":{"tf":1}},"df":2}}}}}},"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"205":{"tf":1},"440":{"tf":1}},"df":2}}}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"206":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"207":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1},"441":{"tf":1},"462":{"tf":1.4142135623730951}},"df":3}}},"r":{"docs":{},"df":0,"e":{"docs":{"209":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,".":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"676":{"tf":1.4142135623730951}},"df":1}}}}}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{"211":{"tf":1},"212":{"tf":1},"232":{"tf":1},"442":{"tf":1},"443":{"tf":1},"463":{"tf":1},"656":{"tf":1},"657":{"tf":1},"677":{"tf":1},"866":{"tf":1},"881":{"tf":1}},"df":11}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"214":{"tf":1},"445":{"tf":1},"659":{"tf":1},"867":{"tf":1}},"df":4}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{"215":{"tf":1},"446":{"tf":1},"660":{"tf":1}},"df":3}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"217":{"tf":1},"448":{"tf":1},"662":{"tf":1},"869":{"tf":1}},"df":4}}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"216":{"tf":1},"447":{"tf":1},"661":{"tf":1},"868":{"tf":1}},"df":4}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,".":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"881":{"tf":1.4142135623730951}},"df":1}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"27":{"tf":1},"143":{"tf":1},"161":{"tf":1},"182":{"tf":1},"259":{"tf":1},"378":{"tf":1},"396":{"tf":1},"417":{"tf":1},"596":{"tf":1},"614":{"tf":1},"635":{"tf":1},"806":{"tf":1},"824":{"tf":1},"831":{"tf":1}},"df":14}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"62":{"tf":1.7320508075688772},"81":{"tf":1},"237":{"tf":1.7320508075688772},"253":{"tf":1},"294":{"tf":1.7320508075688772},"312":{"tf":1},"350":{"tf":1},"468":{"tf":1.7320508075688772},"525":{"tf":1.7320508075688772},"543":{"tf":1},"682":{"tf":1.7320508075688772},"698":{"tf":1},"739":{"tf":1.7320508075688772},"757":{"tf":1}},"df":14}}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"168":{"tf":1},"403":{"tf":1},"621":{"tf":1}},"df":3}}}}},"t":{"docs":{"122":{"tf":1},"177":{"tf":1},"189":{"tf":1},"232":{"tf":1},"350":{"tf":1},"354":{"tf":1},"357":{"tf":1},"412":{"tf":1},"424":{"tf":1},"463":{"tf":1},"630":{"tf":1},"642":{"tf":1},"677":{"tf":1},"847":{"tf":1},"881":{"tf":1},"907":{"tf":1},"933":{"tf":1}},"df":17}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"43":{"tf":1},"77":{"tf":1},"275":{"tf":1},"308":{"tf":1},"506":{"tf":1},"539":{"tf":1},"720":{"tf":1}},"df":7}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"43":{"tf":1},"192":{"tf":1},"275":{"tf":1},"427":{"tf":1},"506":{"tf":1},"645":{"tf":1},"720":{"tf":1},"855":{"tf":1}},"df":8}}}}}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"54":{"tf":1},"286":{"tf":1},"517":{"tf":1},"731":{"tf":1}},"df":4}},"f":{"docs":{},"df":0,"i":{"docs":{"125":{"tf":2},"360":{"tf":2}},"df":2}}}}}}},"f":{"4":{"docs":{"86":{"tf":1},"317":{"tf":1},"548":{"tf":1}},"df":3},"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":2.8284271247461903},"4":{"tf":3.1622776601683795},"5":{"tf":1},"8":{"tf":1.7320508075688772},"20":{"tf":1.7320508075688772},"27":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1},"39":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"47":{"tf":1},"51":{"tf":2},"54":{"tf":1},"56":{"tf":1.4142135623730951},"59":{"tf":1},"64":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"71":{"tf":1},"77":{"tf":1.4142135623730951},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"86":{"tf":1},"91":{"tf":1},"94":{"tf":1.4142135623730951},"116":{"tf":3.4641016151377544},"119":{"tf":2},"122":{"tf":2.8284271247461903},"125":{"tf":4.795831523312719},"128":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"143":{"tf":1.4142135623730951},"158":{"tf":1},"168":{"tf":1.7320508075688772},"169":{"tf":2.449489742783178},"171":{"tf":1},"176":{"tf":1.4142135623730951},"177":{"tf":2},"178":{"tf":2},"181":{"tf":1.4142135623730951},"183":{"tf":1},"187":{"tf":1},"188":{"tf":1},"189":{"tf":1},"192":{"tf":2.449489742783178},"195":{"tf":2},"199":{"tf":1.4142135623730951},"202":{"tf":1},"203":{"tf":1},"207":{"tf":1},"208":{"tf":1},"209":{"tf":1.4142135623730951},"210":{"tf":2},"213":{"tf":1},"217":{"tf":1.4142135623730951},"224":{"tf":1},"225":{"tf":1},"226":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"231":{"tf":2},"232":{"tf":2},"240":{"tf":2},"252":{"tf":1},"253":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"266":{"tf":1.4142135623730951},"269":{"tf":1.4142135623730951},"270":{"tf":1},"271":{"tf":1.4142135623730951},"275":{"tf":1.7320508075688772},"279":{"tf":1},"283":{"tf":2},"286":{"tf":1},"288":{"tf":1.4142135623730951},"291":{"tf":1},"295":{"tf":1},"296":{"tf":1.7320508075688772},"297":{"tf":1},"302":{"tf":1},"305":{"tf":1.4142135623730951},"308":{"tf":1.4142135623730951},"312":{"tf":1.4142135623730951},"313":{"tf":1.4142135623730951},"317":{"tf":1},"322":{"tf":1},"325":{"tf":1.4142135623730951},"347":{"tf":3.4641016151377544},"350":{"tf":3.7416573867739413},"351":{"tf":1.7320508075688772},"354":{"tf":2.449489742783178},"356":{"tf":1.4142135623730951},"357":{"tf":2.8284271247461903},"360":{"tf":4.795831523312719},"363":{"tf":1.4142135623730951},"375":{"tf":1.4142135623730951},"378":{"tf":1.4142135623730951},"393":{"tf":1},"399":{"tf":1},"403":{"tf":1},"404":{"tf":2.449489742783178},"406":{"tf":1},"411":{"tf":1.4142135623730951},"412":{"tf":2},"413":{"tf":2},"416":{"tf":1.4142135623730951},"418":{"tf":1},"422":{"tf":1},"423":{"tf":1},"424":{"tf":1},"427":{"tf":2.449489742783178},"430":{"tf":2},"434":{"tf":1.4142135623730951},"437":{"tf":1.4142135623730951},"438":{"tf":1},"441":{"tf":1},"444":{"tf":1},"448":{"tf":1.4142135623730951},"455":{"tf":1},"456":{"tf":1},"457":{"tf":1.7320508075688772},"460":{"tf":1.4142135623730951},"462":{"tf":2},"463":{"tf":2},"471":{"tf":2},"483":{"tf":1.4142135623730951},"484":{"tf":1},"490":{"tf":1.4142135623730951},"497":{"tf":1.4142135623730951},"500":{"tf":1.4142135623730951},"501":{"tf":1},"502":{"tf":1.4142135623730951},"506":{"tf":1.7320508075688772},"510":{"tf":1},"514":{"tf":2},"517":{"tf":1},"519":{"tf":1.4142135623730951},"522":{"tf":1},"526":{"tf":1.7320508075688772},"528":{"tf":1.7320508075688772},"533":{"tf":1},"534":{"tf":1},"539":{"tf":2},"543":{"tf":1.4142135623730951},"544":{"tf":1.4142135623730951},"548":{"tf":1},"553":{"tf":1},"556":{"tf":1.4142135623730951},"578":{"tf":3.3166247903554},"581":{"tf":1.4142135623730951},"593":{"tf":1.4142135623730951},"596":{"tf":1.4142135623730951},"611":{"tf":1},"617":{"tf":1},"621":{"tf":1.7320508075688772},"622":{"tf":2.449489742783178},"624":{"tf":1},"629":{"tf":1.4142135623730951},"630":{"tf":2},"631":{"tf":2},"634":{"tf":1.4142135623730951},"636":{"tf":1},"640":{"tf":1},"641":{"tf":1},"642":{"tf":1},"645":{"tf":2.449489742783178},"648":{"tf":2},"652":{"tf":1.4142135623730951},"658":{"tf":1},"662":{"tf":1.4142135623730951},"669":{"tf":1},"670":{"tf":1},"671":{"tf":1.7320508075688772},"674":{"tf":1.4142135623730951},"676":{"tf":2},"677":{"tf":2},"685":{"tf":1.7320508075688772},"691":{"tf":1},"697":{"tf":1.4142135623730951},"698":{"tf":2.6457513110645907},"704":{"tf":1.4142135623730951},"709":{"tf":1},"711":{"tf":1.4142135623730951},"714":{"tf":1.4142135623730951},"716":{"tf":1.7320508075688772},"717":{"tf":1},"720":{"tf":1.7320508075688772},"724":{"tf":1},"728":{"tf":1.4142135623730951},"733":{"tf":1.4142135623730951},"741":{"tf":1},"742":{"tf":1},"746":{"tf":1},"747":{"tf":1},"748":{"tf":1},"749":{"tf":1},"754":{"tf":1.4142135623730951},"757":{"tf":1},"758":{"tf":2},"760":{"tf":1},"763":{"tf":1},"785":{"tf":1},"788":{"tf":2},"791":{"tf":1},"794":{"tf":1},"797":{"tf":1},"803":{"tf":1.7320508075688772},"806":{"tf":1.4142135623730951},"818":{"tf":1},"827":{"tf":1.4142135623730951},"831":{"tf":1},"832":{"tf":1.7320508075688772},"839":{"tf":1},"840":{"tf":1.4142135623730951},"841":{"tf":1.7320508075688772},"844":{"tf":1},"845":{"tf":1.4142135623730951},"846":{"tf":1},"851":{"tf":1},"852":{"tf":1},"855":{"tf":2.449489742783178},"858":{"tf":1.7320508075688772},"862":{"tf":1.4142135623730951},"867":{"tf":1},"869":{"tf":1.4142135623730951},"876":{"tf":1},"877":{"tf":1},"881":{"tf":3},"886":{"tf":1.4142135623730951},"890":{"tf":2},"893":{"tf":1},"894":{"tf":2.23606797749979},"895":{"tf":2.23606797749979},"896":{"tf":1},"898":{"tf":1},"899":{"tf":1.4142135623730951},"900":{"tf":1},"901":{"tf":1},"905":{"tf":1.7320508075688772},"907":{"tf":2.23606797749979},"909":{"tf":1},"911":{"tf":1},"912":{"tf":1.4142135623730951},"913":{"tf":1},"914":{"tf":1},"915":{"tf":2.6457513110645907},"916":{"tf":2.23606797749979},"918":{"tf":1.4142135623730951},"921":{"tf":1.4142135623730951},"923":{"tf":1},"925":{"tf":1},"928":{"tf":1},"932":{"tf":1.4142135623730951},"933":{"tf":2.23606797749979},"936":{"tf":2.23606797749979},"937":{"tf":1},"938":{"tf":1.4142135623730951},"939":{"tf":3.1622776601683795},"940":{"tf":1.4142135623730951},"941":{"tf":2.23606797749979},"943":{"tf":1},"944":{"tf":1.7320508075688772},"946":{"tf":2.23606797749979},"947":{"tf":1},"949":{"tf":1.7320508075688772},"951":{"tf":1.4142135623730951},"952":{"tf":1},"954":{"tf":2.449489742783178},"955":{"tf":1},"958":{"tf":1.4142135623730951},"960":{"tf":1.4142135623730951},"961":{"tf":1},"962":{"tf":1},"963":{"tf":1}},"df":273,"m":{"docs":{"43":{"tf":1},"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951},"484":{"tf":1}},"df":4,"a":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"55":{"tf":1},"168":{"tf":1.4142135623730951},"287":{"tf":1},"403":{"tf":1.4142135623730951},"518":{"tf":1},"621":{"tf":1.4142135623730951},"732":{"tf":1},"831":{"tf":1}},"df":9}},"e":{"docs":{},"df":0,"r":{"docs":{"109":{"tf":1},"340":{"tf":1},"571":{"tf":1},"778":{"tf":1}},"df":4}}},"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"5":{"tf":1},"182":{"tf":1},"417":{"tf":1},"635":{"tf":1}},"df":4}}}},"e":{"docs":{},"df":0,"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"21":{"tf":1},"484":{"tf":1},"824":{"tf":1}},"df":3}}}}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{"182":{"tf":1},"417":{"tf":1},"635":{"tf":1}},"df":3}}},"g":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"916":{"tf":1}},"df":1}}}}},"e":{"docs":{},"df":0,"t":{"docs":{"956":{"tf":1},"959":{"tf":1}},"df":2}}},"c":{"docs":{"929":{"tf":1}},"df":1,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"955":{"tf":1},"956":{"tf":1}},"df":2}}}}}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"4":{"tf":1},"28":{"tf":1},"64":{"tf":1},"139":{"tf":1},"229":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"260":{"tf":1},"295":{"tf":1},"374":{"tf":1},"460":{"tf":1.4142135623730951},"463":{"tf":1.7320508075688772},"491":{"tf":1},"526":{"tf":1},"592":{"tf":1},"674":{"tf":1.4142135623730951},"677":{"tf":1.7320508075688772},"685":{"tf":1},"705":{"tf":1},"781":{"tf":1},"788":{"tf":1},"791":{"tf":1},"850":{"tf":1},"858":{"tf":1},"881":{"tf":2.23606797749979},"924":{"tf":1},"929":{"tf":1}},"df":26}},"r":{"docs":{"25":{"tf":1},"26":{"tf":1},"39":{"tf":1},"253":{"tf":1.4142135623730951},"257":{"tf":1},"258":{"tf":1},"271":{"tf":1},"488":{"tf":1},"489":{"tf":1},"502":{"tf":1},"702":{"tf":1},"703":{"tf":1},"951":{"tf":1},"954":{"tf":1.4142135623730951},"961":{"tf":1}},"df":15,"t":{"docs":{},"df":0,"h":{"docs":{"525":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"4":{"tf":1},"14":{"tf":1},"16":{"tf":1},"37":{"tf":1},"39":{"tf":1},"55":{"tf":1},"56":{"tf":1},"86":{"tf":1.4142135623730951},"98":{"tf":1},"105":{"tf":1},"116":{"tf":1.4142135623730951},"119":{"tf":1},"125":{"tf":1.4142135623730951},"128":{"tf":1},"138":{"tf":1},"143":{"tf":1},"149":{"tf":1},"155":{"tf":1},"168":{"tf":1},"176":{"tf":1},"178":{"tf":1},"187":{"tf":1.4142135623730951},"203":{"tf":1},"229":{"tf":1},"237":{"tf":1},"246":{"tf":1},"248":{"tf":1},"269":{"tf":1},"271":{"tf":1},"287":{"tf":1},"288":{"tf":1},"317":{"tf":1},"329":{"tf":1},"336":{"tf":1},"347":{"tf":1.4142135623730951},"350":{"tf":1.4142135623730951},"354":{"tf":1},"360":{"tf":1.4142135623730951},"363":{"tf":1},"373":{"tf":1},"378":{"tf":1},"384":{"tf":1},"390":{"tf":1},"403":{"tf":1},"411":{"tf":1},"413":{"tf":1},"422":{"tf":1.4142135623730951},"438":{"tf":1},"460":{"tf":1},"468":{"tf":1},"477":{"tf":1},"479":{"tf":1},"500":{"tf":1},"502":{"tf":1},"518":{"tf":1},"519":{"tf":1},"548":{"tf":1.4142135623730951},"560":{"tf":1},"567":{"tf":1},"578":{"tf":1.4142135623730951},"581":{"tf":1},"591":{"tf":1},"596":{"tf":1},"602":{"tf":1},"608":{"tf":1},"621":{"tf":1},"629":{"tf":1},"631":{"tf":1},"640":{"tf":1.4142135623730951},"674":{"tf":1},"682":{"tf":1},"691":{"tf":1},"693":{"tf":1},"714":{"tf":1},"716":{"tf":1},"732":{"tf":1},"733":{"tf":1},"740":{"tf":1},"749":{"tf":1},"757":{"tf":1},"758":{"tf":1},"774":{"tf":1.4142135623730951},"785":{"tf":1},"788":{"tf":1},"791":{"tf":1},"801":{"tf":1},"812":{"tf":1},"831":{"tf":1.4142135623730951},"839":{"tf":1},"840":{"tf":1},"841":{"tf":1},"850":{"tf":1.4142135623730951},"851":{"tf":1},"858":{"tf":1},"881":{"tf":1},"886":{"tf":1},"889":{"tf":1},"890":{"tf":1},"894":{"tf":1.4142135623730951},"897":{"tf":1.4142135623730951},"905":{"tf":1},"907":{"tf":1},"911":{"tf":1},"913":{"tf":1},"917":{"tf":1},"921":{"tf":1},"932":{"tf":1},"934":{"tf":1},"936":{"tf":1.4142135623730951},"945":{"tf":1},"949":{"tf":1}},"df":111}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"866":{"tf":1.4142135623730951},"889":{"tf":1},"905":{"tf":1},"906":{"tf":1},"908":{"tf":1},"920":{"tf":1},"932":{"tf":1},"935":{"tf":1}},"df":8}}}},"n":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}},"c":{"docs":{},"df":0,"u":{"docs":{"21":{"tf":1},"67":{"tf":1},"140":{"tf":1},"161":{"tf":1.4142135623730951},"298":{"tf":1},"375":{"tf":1},"396":{"tf":1.4142135623730951},"484":{"tf":1},"529":{"tf":1},"593":{"tf":1},"614":{"tf":1.4142135623730951},"803":{"tf":1},"824":{"tf":1},"839":{"tf":1}},"df":14,"s":{"docs":{"8":{"tf":1},"240":{"tf":1},"471":{"tf":1},"866":{"tf":1}},"df":4}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1},"16":{"tf":1},"27":{"tf":1},"32":{"tf":1},"43":{"tf":1},"50":{"tf":1},"81":{"tf":1.4142135623730951},"82":{"tf":1},"125":{"tf":1},"128":{"tf":2},"140":{"tf":1},"143":{"tf":1},"195":{"tf":1.4142135623730951},"214":{"tf":1},"231":{"tf":1},"248":{"tf":1},"253":{"tf":1},"259":{"tf":1},"264":{"tf":1},"275":{"tf":1},"282":{"tf":1},"305":{"tf":1},"312":{"tf":1.4142135623730951},"313":{"tf":1},"350":{"tf":2},"354":{"tf":1},"360":{"tf":1},"363":{"tf":2},"375":{"tf":1},"378":{"tf":1},"430":{"tf":1.4142135623730951},"445":{"tf":1},"457":{"tf":1},"462":{"tf":1},"479":{"tf":1},"490":{"tf":1},"495":{"tf":1},"506":{"tf":1},"513":{"tf":1},"543":{"tf":1.4142135623730951},"544":{"tf":1},"581":{"tf":2},"593":{"tf":1},"596":{"tf":1},"648":{"tf":1.4142135623730951},"659":{"tf":1},"671":{"tf":1},"676":{"tf":1},"693":{"tf":1},"704":{"tf":1},"717":{"tf":1},"720":{"tf":1},"757":{"tf":1.4142135623730951},"788":{"tf":1},"791":{"tf":1.4142135623730951},"797":{"tf":1},"801":{"tf":1},"803":{"tf":1},"806":{"tf":1.4142135623730951},"812":{"tf":1},"845":{"tf":1},"858":{"tf":1.4142135623730951},"861":{"tf":1},"881":{"tf":1}},"df":65}}}},"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"350":{"tf":1}},"df":1}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"685":{"tf":1}},"df":1}}}}}}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"55":{"tf":1},"64":{"tf":1},"122":{"tf":1},"199":{"tf":1.4142135623730951},"287":{"tf":1},"296":{"tf":1},"305":{"tf":1},"357":{"tf":1},"434":{"tf":1.4142135623730951},"518":{"tf":1},"526":{"tf":1},"652":{"tf":1.4142135623730951},"732":{"tf":1},"766":{"tf":1},"773":{"tf":1},"808":{"tf":1},"839":{"tf":1},"852":{"tf":1},"858":{"tf":1},"889":{"tf":1},"902":{"tf":1}},"df":22,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"59":{"tf":1},"291":{"tf":1},"522":{"tf":1},"932":{"tf":1}},"df":4}}}}}}}},"l":{"docs":{},"df":0,"l":{"docs":{"50":{"tf":1},"140":{"tf":1},"195":{"tf":1},"213":{"tf":1.4142135623730951},"282":{"tf":1},"375":{"tf":1},"430":{"tf":1},"444":{"tf":1.4142135623730951},"513":{"tf":1},"593":{"tf":1},"648":{"tf":1},"658":{"tf":1.4142135623730951},"716":{"tf":1},"727":{"tf":1},"803":{"tf":1},"899":{"tf":1},"936":{"tf":1},"940":{"tf":1}},"df":18,"i":{"docs":{"47":{"tf":1},"279":{"tf":1},"510":{"tf":1},"724":{"tf":1}},"df":4}},"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"905":{"tf":1},"907":{"tf":1},"911":{"tf":1}},"df":3}}}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1},"5":{"tf":1},"14":{"tf":1},"21":{"tf":1},"32":{"tf":1},"39":{"tf":1.4142135623730951},"43":{"tf":1.7320508075688772},"55":{"tf":1},"56":{"tf":1},"59":{"tf":1},"62":{"tf":1},"72":{"tf":1.4142135623730951},"78":{"tf":1},"81":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"94":{"tf":1},"97":{"tf":1.4142135623730951},"102":{"tf":1},"104":{"tf":1},"105":{"tf":1},"116":{"tf":1.4142135623730951},"122":{"tf":2.23606797749979},"128":{"tf":2.23606797749979},"137":{"tf":1},"155":{"tf":2.23606797749979},"169":{"tf":1},"175":{"tf":1},"176":{"tf":1},"177":{"tf":1.4142135623730951},"178":{"tf":1},"181":{"tf":1},"182":{"tf":1.7320508075688772},"183":{"tf":1},"184":{"tf":1},"189":{"tf":1},"192":{"tf":1},"195":{"tf":1},"198":{"tf":1},"199":{"tf":1},"202":{"tf":1},"207":{"tf":1.7320508075688772},"215":{"tf":1},"229":{"tf":1.4142135623730951},"230":{"tf":1},"231":{"tf":1},"232":{"tf":2},"246":{"tf":1},"264":{"tf":1},"271":{"tf":1.4142135623730951},"275":{"tf":1.4142135623730951},"287":{"tf":1},"288":{"tf":1},"291":{"tf":1},"294":{"tf":1},"295":{"tf":1},"303":{"tf":1.4142135623730951},"309":{"tf":1},"312":{"tf":1.4142135623730951},"313":{"tf":1.4142135623730951},"325":{"tf":1},"328":{"tf":1.4142135623730951},"333":{"tf":1},"335":{"tf":1},"336":{"tf":1},"347":{"tf":1.4142135623730951},"350":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":2.23606797749979},"363":{"tf":2.23606797749979},"372":{"tf":1},"390":{"tf":2.23606797749979},"404":{"tf":1},"410":{"tf":1},"411":{"tf":1},"412":{"tf":1.4142135623730951},"413":{"tf":1},"416":{"tf":1},"417":{"tf":1.7320508075688772},"418":{"tf":1},"419":{"tf":1},"424":{"tf":1},"427":{"tf":1},"430":{"tf":1},"433":{"tf":1},"434":{"tf":1},"437":{"tf":1},"446":{"tf":1},"460":{"tf":1.4142135623730951},"461":{"tf":1},"462":{"tf":1},"463":{"tf":2},"477":{"tf":1},"484":{"tf":1},"495":{"tf":1},"502":{"tf":1.4142135623730951},"506":{"tf":1.4142135623730951},"518":{"tf":1},"519":{"tf":1},"522":{"tf":1},"525":{"tf":1},"534":{"tf":1.4142135623730951},"540":{"tf":1},"543":{"tf":1.4142135623730951},"544":{"tf":1.4142135623730951},"556":{"tf":1},"559":{"tf":1.4142135623730951},"564":{"tf":1},"566":{"tf":1},"567":{"tf":1},"578":{"tf":1.4142135623730951},"581":{"tf":2.23606797749979},"590":{"tf":1},"608":{"tf":2.23606797749979},"622":{"tf":1},"628":{"tf":1},"629":{"tf":1},"630":{"tf":1.4142135623730951},"631":{"tf":1},"634":{"tf":1},"635":{"tf":1.7320508075688772},"636":{"tf":1},"637":{"tf":1},"642":{"tf":1},"645":{"tf":1},"648":{"tf":1},"651":{"tf":1},"652":{"tf":1},"655":{"tf":1},"660":{"tf":1},"674":{"tf":1.4142135623730951},"675":{"tf":1},"676":{"tf":1},"677":{"tf":2},"691":{"tf":1},"703":{"tf":1},"716":{"tf":1},"720":{"tf":1.4142135623730951},"732":{"tf":1},"733":{"tf":1},"736":{"tf":1},"739":{"tf":1},"740":{"tf":1},"741":{"tf":1.4142135623730951},"757":{"tf":1},"758":{"tf":1.4142135623730951},"766":{"tf":1.4142135623730951},"773":{"tf":1},"774":{"tf":1.4142135623730951},"785":{"tf":1},"791":{"tf":2},"800":{"tf":1.4142135623730951},"813":{"tf":1},"814":{"tf":1},"818":{"tf":1},"819":{"tf":1},"821":{"tf":1},"824":{"tf":1.4142135623730951},"831":{"tf":1},"838":{"tf":1},"840":{"tf":1},"844":{"tf":1},"845":{"tf":1.4142135623730951},"846":{"tf":1},"847":{"tf":1},"851":{"tf":1},"861":{"tf":1},"866":{"tf":1.4142135623730951},"881":{"tf":2.8284271247461903},"886":{"tf":1},"893":{"tf":1},"898":{"tf":1},"902":{"tf":1},"907":{"tf":1.4142135623730951},"913":{"tf":1.4142135623730951},"917":{"tf":1},"933":{"tf":1},"939":{"tf":1},"956":{"tf":1},"959":{"tf":1}},"df":179},"n":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}},"e":{"docs":{},"df":0,"e":{"docs":{"27":{"tf":1},"56":{"tf":1},"78":{"tf":1},"168":{"tf":1},"259":{"tf":1},"288":{"tf":1},"309":{"tf":1},"403":{"tf":1},"490":{"tf":1},"519":{"tf":1},"540":{"tf":1},"621":{"tf":1},"704":{"tf":1},"733":{"tf":1},"944":{"tf":1}},"df":15},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"858":{"tf":1},"867":{"tf":1}},"df":2}}}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"939":{"tf":2}},"df":1}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"15":{"tf":1},"34":{"tf":1},"38":{"tf":1.4142135623730951},"66":{"tf":1},"72":{"tf":1},"81":{"tf":1},"109":{"tf":1},"119":{"tf":1},"122":{"tf":1.7320508075688772},"125":{"tf":1.7320508075688772},"128":{"tf":1.7320508075688772},"137":{"tf":1},"140":{"tf":1},"151":{"tf":1},"155":{"tf":1},"176":{"tf":1.4142135623730951},"181":{"tf":1},"183":{"tf":1.4142135623730951},"187":{"tf":1},"195":{"tf":1.7320508075688772},"224":{"tf":1},"225":{"tf":1},"231":{"tf":1.4142135623730951},"247":{"tf":1},"266":{"tf":1},"270":{"tf":1.4142135623730951},"303":{"tf":1},"312":{"tf":1},"340":{"tf":1},"350":{"tf":1},"354":{"tf":1},"357":{"tf":1.7320508075688772},"360":{"tf":1.7320508075688772},"363":{"tf":1.7320508075688772},"372":{"tf":1},"375":{"tf":1},"386":{"tf":1},"390":{"tf":1},"411":{"tf":1.4142135623730951},"416":{"tf":1},"418":{"tf":1.4142135623730951},"422":{"tf":1},"430":{"tf":1.7320508075688772},"455":{"tf":1},"456":{"tf":1},"457":{"tf":1},"462":{"tf":1.4142135623730951},"478":{"tf":1},"497":{"tf":1},"501":{"tf":1.4142135623730951},"528":{"tf":1},"534":{"tf":1},"543":{"tf":1},"571":{"tf":1},"581":{"tf":1.7320508075688772},"590":{"tf":1},"593":{"tf":1},"604":{"tf":1},"608":{"tf":1},"629":{"tf":1.4142135623730951},"634":{"tf":1},"636":{"tf":1.4142135623730951},"640":{"tf":1},"648":{"tf":1.7320508075688772},"669":{"tf":1},"670":{"tf":1},"671":{"tf":1},"676":{"tf":1.4142135623730951},"711":{"tf":1},"715":{"tf":1.4142135623730951},"740":{"tf":1},"749":{"tf":1},"781":{"tf":1},"784":{"tf":1},"791":{"tf":1},"844":{"tf":1},"850":{"tf":1},"858":{"tf":1.4142135623730951},"877":{"tf":1},"881":{"tf":1.4142135623730951},"889":{"tf":1},"901":{"tf":1},"902":{"tf":1},"905":{"tf":1},"911":{"tf":1},"916":{"tf":1},"920":{"tf":1},"924":{"tf":1},"929":{"tf":1},"932":{"tf":1},"933":{"tf":1},"944":{"tf":1}},"df":93},"a":{"docs":{},"df":0,"l":{"docs":{"26":{"tf":1.4142135623730951},"39":{"tf":1},"65":{"tf":1},"66":{"tf":1},"72":{"tf":1},"77":{"tf":1.4142135623730951},"86":{"tf":1},"90":{"tf":1.4142135623730951},"104":{"tf":1},"119":{"tf":1},"122":{"tf":2.8284271247461903},"167":{"tf":1},"181":{"tf":1},"237":{"tf":1},"258":{"tf":1.4142135623730951},"271":{"tf":1},"296":{"tf":1},"297":{"tf":1},"303":{"tf":1},"308":{"tf":1.4142135623730951},"317":{"tf":1},"321":{"tf":1.4142135623730951},"335":{"tf":1},"354":{"tf":1},"357":{"tf":2.449489742783178},"402":{"tf":1},"416":{"tf":1},"468":{"tf":1},"489":{"tf":1.4142135623730951},"502":{"tf":1},"527":{"tf":1},"528":{"tf":1},"534":{"tf":1},"539":{"tf":1.4142135623730951},"548":{"tf":1},"552":{"tf":1.4142135623730951},"566":{"tf":1},"620":{"tf":1},"634":{"tf":1},"682":{"tf":1},"698":{"tf":1},"703":{"tf":1.4142135623730951},"716":{"tf":1},"749":{"tf":1},"808":{"tf":1},"830":{"tf":1},"831":{"tf":1},"898":{"tf":1.4142135623730951},"939":{"tf":1},"948":{"tf":1}},"df":50}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{"27":{"tf":1},"64":{"tf":1},"65":{"tf":1},"68":{"tf":1},"74":{"tf":1},"87":{"tf":1},"158":{"tf":1},"183":{"tf":1},"192":{"tf":1.4142135623730951},"259":{"tf":1},"296":{"tf":1.4142135623730951},"299":{"tf":1},"305":{"tf":1},"318":{"tf":1},"393":{"tf":1},"418":{"tf":1},"427":{"tf":1.4142135623730951},"490":{"tf":1},"526":{"tf":1},"527":{"tf":1},"530":{"tf":1},"536":{"tf":1},"549":{"tf":1},"611":{"tf":1},"636":{"tf":1},"645":{"tf":1.4142135623730951},"704":{"tf":1},"742":{"tf":1},"751":{"tf":1},"809":{"tf":1},"821":{"tf":1},"855":{"tf":1},"922":{"tf":1}},"df":33}}},"e":{"docs":{"94":{"tf":1},"325":{"tf":1},"556":{"tf":1},"916":{"tf":1}},"df":4}},"l":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"14":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"26":{"tf":1},"54":{"tf":1},"62":{"tf":1},"64":{"tf":1.4142135623730951},"65":{"tf":1},"68":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"195":{"tf":2.23606797749979},"198":{"tf":1},"213":{"tf":2.8284271247461903},"214":{"tf":1},"215":{"tf":1},"232":{"tf":1},"246":{"tf":1.4142135623730951},"258":{"tf":1},"286":{"tf":1},"287":{"tf":1},"294":{"tf":1},"295":{"tf":1.7320508075688772},"299":{"tf":1.4142135623730951},"317":{"tf":1},"430":{"tf":2.23606797749979},"433":{"tf":1},"444":{"tf":2.8284271247461903},"445":{"tf":1},"446":{"tf":1},"463":{"tf":1},"477":{"tf":1.4142135623730951},"489":{"tf":1},"517":{"tf":1},"518":{"tf":1},"525":{"tf":1},"527":{"tf":1},"530":{"tf":1.4142135623730951},"548":{"tf":1.4142135623730951},"648":{"tf":2.23606797749979},"651":{"tf":1},"658":{"tf":2.8284271247461903},"659":{"tf":1},"660":{"tf":1},"677":{"tf":1},"691":{"tf":1.4142135623730951},"703":{"tf":1},"731":{"tf":1},"732":{"tf":1},"739":{"tf":1},"743":{"tf":1},"858":{"tf":1.7320508075688772},"866":{"tf":1.4142135623730951},"867":{"tf":1},"881":{"tf":1},"886":{"tf":1.4142135623730951},"889":{"tf":1},"894":{"tf":1.7320508075688772},"900":{"tf":1},"901":{"tf":1},"902":{"tf":1},"905":{"tf":1},"908":{"tf":1},"932":{"tf":1},"936":{"tf":1.4142135623730951},"938":{"tf":1},"943":{"tf":1.7320508075688772},"944":{"tf":1},"945":{"tf":1.4142135623730951},"946":{"tf":1},"949":{"tf":1.4142135623730951},"951":{"tf":1},"954":{"tf":1.4142135623730951},"958":{"tf":1},"960":{"tf":1},"963":{"tf":1}},"df":75,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"55":{"tf":1}},"df":1}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"43":{"tf":1},"275":{"tf":1},"506":{"tf":1},"720":{"tf":1}},"df":4}}},"l":{"docs":{"102":{"tf":1},"103":{"tf":1},"333":{"tf":1},"334":{"tf":1},"564":{"tf":1},"565":{"tf":1},"770":{"tf":1},"771":{"tf":1},"772":{"tf":1},"896":{"tf":1},"954":{"tf":1}},"df":11}},"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"8":{"tf":1},"11":{"tf":1},"14":{"tf":1.4142135623730951},"19":{"tf":1},"25":{"tf":1.4142135623730951},"26":{"tf":1},"27":{"tf":1.4142135623730951},"32":{"tf":1},"50":{"tf":1},"55":{"tf":1},"56":{"tf":1},"62":{"tf":1.4142135623730951},"63":{"tf":1},"66":{"tf":1},"77":{"tf":1},"82":{"tf":1.4142135623730951},"91":{"tf":1},"102":{"tf":1},"115":{"tf":1},"116":{"tf":1},"119":{"tf":1},"125":{"tf":2.8284271247461903},"131":{"tf":1},"137":{"tf":1.4142135623730951},"140":{"tf":1},"144":{"tf":1},"168":{"tf":1},"172":{"tf":1},"175":{"tf":1},"177":{"tf":1},"182":{"tf":1},"187":{"tf":1},"224":{"tf":1},"226":{"tf":1.4142135623730951},"232":{"tf":1},"243":{"tf":1},"246":{"tf":1.4142135623730951},"251":{"tf":1},"253":{"tf":1},"257":{"tf":1.4142135623730951},"258":{"tf":1},"259":{"tf":1.4142135623730951},"264":{"tf":1},"282":{"tf":1},"287":{"tf":1},"288":{"tf":1},"294":{"tf":1},"298":{"tf":1},"308":{"tf":1},"313":{"tf":1.4142135623730951},"317":{"tf":1},"322":{"tf":1},"333":{"tf":1},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1},"354":{"tf":1.7320508075688772},"360":{"tf":2.8284271247461903},"366":{"tf":1},"372":{"tf":1.4142135623730951},"379":{"tf":1},"403":{"tf":1},"407":{"tf":1},"410":{"tf":1},"412":{"tf":1},"417":{"tf":1},"422":{"tf":1},"455":{"tf":1},"457":{"tf":1.4142135623730951},"463":{"tf":1},"474":{"tf":1},"477":{"tf":1.4142135623730951},"482":{"tf":1},"484":{"tf":1},"488":{"tf":1.4142135623730951},"489":{"tf":1},"490":{"tf":1.4142135623730951},"495":{"tf":1},"513":{"tf":1},"518":{"tf":1},"519":{"tf":1},"525":{"tf":1},"528":{"tf":1},"539":{"tf":1},"544":{"tf":1.4142135623730951},"553":{"tf":1},"564":{"tf":1},"577":{"tf":1},"578":{"tf":1},"584":{"tf":1},"590":{"tf":1.4142135623730951},"597":{"tf":1},"621":{"tf":1},"625":{"tf":1},"628":{"tf":1},"630":{"tf":1},"635":{"tf":1},"640":{"tf":1},"669":{"tf":1},"671":{"tf":1.4142135623730951},"677":{"tf":1},"688":{"tf":1},"691":{"tf":1.4142135623730951},"692":{"tf":1},"696":{"tf":1},"698":{"tf":2},"702":{"tf":1.4142135623730951},"703":{"tf":1.4142135623730951},"704":{"tf":1.7320508075688772},"709":{"tf":1},"732":{"tf":1},"740":{"tf":1},"749":{"tf":1},"757":{"tf":1},"758":{"tf":1.4142135623730951},"771":{"tf":1},"784":{"tf":1},"785":{"tf":1},"788":{"tf":1.4142135623730951},"794":{"tf":1},"800":{"tf":1.4142135623730951},"803":{"tf":1},"806":{"tf":1},"807":{"tf":1},"831":{"tf":1},"832":{"tf":1},"835":{"tf":1},"838":{"tf":1},"840":{"tf":1},"845":{"tf":1},"850":{"tf":1},"858":{"tf":1},"876":{"tf":1},"878":{"tf":1},"881":{"tf":1},"889":{"tf":1},"894":{"tf":1.4142135623730951},"895":{"tf":1.7320508075688772},"905":{"tf":1},"906":{"tf":1.4142135623730951},"907":{"tf":1},"908":{"tf":1},"909":{"tf":1.4142135623730951},"910":{"tf":1},"913":{"tf":1.4142135623730951},"915":{"tf":1},"916":{"tf":1},"917":{"tf":1},"920":{"tf":1},"925":{"tf":1},"932":{"tf":1},"933":{"tf":1.4142135623730951},"936":{"tf":1.4142135623730951},"945":{"tf":1.4142135623730951},"946":{"tf":1},"948":{"tf":1},"949":{"tf":1},"950":{"tf":1},"954":{"tf":1}},"df":159,"j":{"docs":{},"df":0,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"15":{"tf":1},"97":{"tf":1.7320508075688772},"328":{"tf":1}},"df":4}}}}}}}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"246":{"tf":1},"247":{"tf":1},"328":{"tf":1.4142135623730951},"350":{"tf":1.4142135623730951},"351":{"tf":1}},"df":5}}}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"477":{"tf":1},"478":{"tf":1},"559":{"tf":1.7320508075688772}},"df":3}}}}}}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"691":{"tf":1},"743":{"tf":1},"766":{"tf":1.7320508075688772}},"df":3}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"691":{"tf":1}},"df":1}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"477":{"tf":1.4142135623730951},"691":{"tf":1.4142135623730951}},"df":4}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"252":{"tf":1},"296":{"tf":1}},"df":2}}}}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"15":{"tf":1},"16":{"tf":1},"20":{"tf":1},"21":{"tf":1},"22":{"tf":1},"26":{"tf":1},"27":{"tf":1},"28":{"tf":1},"32":{"tf":1},"33":{"tf":1},"34":{"tf":1},"38":{"tf":1},"39":{"tf":1},"40":{"tf":1},"47":{"tf":1},"51":{"tf":1},"55":{"tf":1},"56":{"tf":1},"63":{"tf":1},"64":{"tf":1.4142135623730951},"65":{"tf":1},"66":{"tf":1},"67":{"tf":1},"68":{"tf":1},"72":{"tf":1},"73":{"tf":1},"74":{"tf":1},"78":{"tf":1},"82":{"tf":1},"83":{"tf":1},"87":{"tf":1},"91":{"tf":1},"98":{"tf":1},"102":{"tf":1},"103":{"tf":1},"104":{"tf":1},"105":{"tf":1},"106":{"tf":1},"116":{"tf":1},"120":{"tf":1},"121":{"tf":1},"122":{"tf":1},"132":{"tf":1},"133":{"tf":1},"134":{"tf":1},"138":{"tf":1},"139":{"tf":1},"140":{"tf":1},"144":{"tf":1},"145":{"tf":1},"146":{"tf":1},"150":{"tf":1},"151":{"tf":1},"152":{"tf":1},"156":{"tf":1},"157":{"tf":1},"168":{"tf":1},"169":{"tf":1},"170":{"tf":1},"172":{"tf":1},"176":{"tf":1},"177":{"tf":1.4142135623730951},"178":{"tf":1},"182":{"tf":1},"183":{"tf":1},"187":{"tf":1},"188":{"tf":1.4142135623730951},"189":{"tf":1},"199":{"tf":1},"224":{"tf":1},"225":{"tf":1},"226":{"tf":1},"230":{"tf":1},"231":{"tf":1},"232":{"tf":1},"233":{"tf":1},"234":{"tf":1},"247":{"tf":1},"248":{"tf":1},"252":{"tf":1},"253":{"tf":1},"254":{"tf":1},"258":{"tf":1},"259":{"tf":1},"260":{"tf":1},"264":{"tf":1},"265":{"tf":1},"266":{"tf":1},"270":{"tf":1},"271":{"tf":1},"272":{"tf":1},"279":{"tf":1},"283":{"tf":1},"287":{"tf":1},"288":{"tf":1},"295":{"tf":1.4142135623730951},"296":{"tf":1},"297":{"tf":1},"298":{"tf":1},"299":{"tf":1},"303":{"tf":1},"304":{"tf":1},"305":{"tf":1},"309":{"tf":1},"313":{"tf":1},"314":{"tf":1},"318":{"tf":1},"322":{"tf":1},"329":{"tf":1},"333":{"tf":1},"334":{"tf":1},"335":{"tf":1},"336":{"tf":1},"337":{"tf":1},"347":{"tf":1},"350":{"tf":1},"351":{"tf":1},"355":{"tf":1},"356":{"tf":1},"357":{"tf":1},"367":{"tf":1},"368":{"tf":1},"369":{"tf":1},"373":{"tf":1},"374":{"tf":1},"375":{"tf":1},"379":{"tf":1},"380":{"tf":1},"381":{"tf":1},"385":{"tf":1},"386":{"tf":1},"387":{"tf":1},"391":{"tf":1},"392":{"tf":1},"403":{"tf":1},"404":{"tf":1},"405":{"tf":1},"407":{"tf":1},"411":{"tf":1},"412":{"tf":1.4142135623730951},"413":{"tf":1},"417":{"tf":1},"418":{"tf":1},"422":{"tf":1},"423":{"tf":1.4142135623730951},"424":{"tf":1},"434":{"tf":1},"455":{"tf":1},"456":{"tf":1},"457":{"tf":1},"461":{"tf":1},"462":{"tf":1},"463":{"tf":1},"464":{"tf":1},"465":{"tf":1},"478":{"tf":1},"479":{"tf":1},"483":{"tf":1},"484":{"tf":1},"485":{"tf":1},"489":{"tf":1},"490":{"tf":1},"491":{"tf":1},"495":{"tf":1},"496":{"tf":1},"497":{"tf":1},"501":{"tf":1},"502":{"tf":1},"503":{"tf":1},"510":{"tf":1},"514":{"tf":1},"518":{"tf":1},"519":{"tf":1},"526":{"tf":1.4142135623730951},"527":{"tf":1},"528":{"tf":1},"529":{"tf":1},"530":{"tf":1},"534":{"tf":1},"535":{"tf":1},"536":{"tf":1},"540":{"tf":1},"544":{"tf":1},"545":{"tf":1},"549":{"tf":1},"553":{"tf":1},"560":{"tf":1},"564":{"tf":1},"565":{"tf":1},"566":{"tf":1},"567":{"tf":1},"568":{"tf":1},"578":{"tf":1},"585":{"tf":1},"586":{"tf":1},"587":{"tf":1},"591":{"tf":1},"592":{"tf":1},"593":{"tf":1},"597":{"tf":1},"598":{"tf":1},"599":{"tf":1},"603":{"tf":1},"604":{"tf":1},"605":{"tf":1},"609":{"tf":1},"610":{"tf":1},"621":{"tf":1},"622":{"tf":1},"623":{"tf":1},"625":{"tf":1},"629":{"tf":1},"630":{"tf":1.4142135623730951},"631":{"tf":1},"635":{"tf":1},"636":{"tf":1},"640":{"tf":1},"641":{"tf":1.4142135623730951},"642":{"tf":1},"652":{"tf":1},"669":{"tf":1},"670":{"tf":1},"671":{"tf":1},"675":{"tf":1},"676":{"tf":1},"677":{"tf":1},"678":{"tf":1},"679":{"tf":1},"692":{"tf":1},"693":{"tf":1},"697":{"tf":1},"698":{"tf":1},"699":{"tf":1},"703":{"tf":1},"704":{"tf":1},"705":{"tf":1},"709":{"tf":1},"710":{"tf":1},"711":{"tf":1},"715":{"tf":1},"716":{"tf":1},"717":{"tf":1},"724":{"tf":1},"728":{"tf":1},"732":{"tf":1},"733":{"tf":1},"740":{"tf":1},"741":{"tf":1},"742":{"tf":1},"743":{"tf":1},"747":{"tf":1},"748":{"tf":1},"749":{"tf":1},"750":{"tf":1},"751":{"tf":1},"758":{"tf":1},"759":{"tf":1},"760":{"tf":1},"767":{"tf":1},"771":{"tf":1},"772":{"tf":1},"773":{"tf":1},"774":{"tf":1},"775":{"tf":1},"785":{"tf":1},"795":{"tf":1},"796":{"tf":1},"797":{"tf":1},"801":{"tf":1},"802":{"tf":1},"803":{"tf":1},"807":{"tf":1},"808":{"tf":1},"809":{"tf":1},"813":{"tf":1},"814":{"tf":1},"815":{"tf":1},"818":{"tf":1},"819":{"tf":1},"820":{"tf":1},"831":{"tf":1},"832":{"tf":1},"833":{"tf":1},"835":{"tf":1},"839":{"tf":1},"840":{"tf":1},"841":{"tf":1},"845":{"tf":1},"846":{"tf":1},"850":{"tf":1},"851":{"tf":1.4142135623730951},"852":{"tf":1.4142135623730951},"862":{"tf":1},"876":{"tf":1},"877":{"tf":1},"878":{"tf":1},"882":{"tf":1},"883":{"tf":1},"890":{"tf":1},"892":{"tf":1},"893":{"tf":1},"895":{"tf":1},"896":{"tf":1},"897":{"tf":1},"898":{"tf":1},"899":{"tf":1},"900":{"tf":1},"901":{"tf":1},"907":{"tf":1},"909":{"tf":1},"910":{"tf":1},"911":{"tf":1},"912":{"tf":1},"913":{"tf":1},"914":{"tf":1},"916":{"tf":1},"917":{"tf":1},"918":{"tf":1},"921":{"tf":1},"922":{"tf":1},"923":{"tf":1},"925":{"tf":1},"926":{"tf":1},"927":{"tf":1},"934":{"tf":1},"936":{"tf":1},"937":{"tf":1},"940":{"tf":1},"941":{"tf":1},"944":{"tf":1},"946":{"tf":1},"947":{"tf":1},"948":{"tf":1},"949":{"tf":1},"950":{"tf":1},"952":{"tf":1},"953":{"tf":1},"955":{"tf":1},"956":{"tf":1},"957":{"tf":1},"959":{"tf":1},"960":{"tf":1},"961":{"tf":1},"962":{"tf":1}},"df":344}}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"26":{"tf":1},"32":{"tf":1},"39":{"tf":1},"55":{"tf":1},"77":{"tf":1.7320508075688772},"101":{"tf":1},"104":{"tf":1},"119":{"tf":1},"122":{"tf":2},"125":{"tf":1.4142135623730951},"168":{"tf":1},"169":{"tf":1},"232":{"tf":1},"253":{"tf":1},"258":{"tf":1},"264":{"tf":1},"271":{"tf":1},"287":{"tf":1},"308":{"tf":1.7320508075688772},"332":{"tf":1},"335":{"tf":1},"350":{"tf":2},"354":{"tf":1.4142135623730951},"357":{"tf":2},"360":{"tf":1.4142135623730951},"403":{"tf":1},"404":{"tf":1},"463":{"tf":1},"489":{"tf":1},"495":{"tf":1},"502":{"tf":1},"518":{"tf":1},"526":{"tf":1.4142135623730951},"539":{"tf":2},"563":{"tf":1},"566":{"tf":1},"621":{"tf":1},"622":{"tf":1},"677":{"tf":1},"703":{"tf":1},"716":{"tf":1},"732":{"tf":1},"747":{"tf":1.4142135623730951},"754":{"tf":1},"770":{"tf":1},"831":{"tf":1},"881":{"tf":1},"898":{"tf":1.4142135623730951},"939":{"tf":1.4142135623730951},"946":{"tf":2},"951":{"tf":1.4142135623730951},"954":{"tf":2},"958":{"tf":1}},"df":53}}},"t":{"docs":{"73":{"tf":1},"304":{"tf":1},"354":{"tf":1},"535":{"tf":1}},"df":4},"x":{"docs":{"157":{"tf":1.4142135623730951},"392":{"tf":1.4142135623730951},"610":{"tf":1.4142135623730951},"814":{"tf":1},"818":{"tf":1.4142135623730951},"820":{"tf":1},"824":{"tf":1},"840":{"tf":1}},"df":8},"v":{"docs":{},"df":0,"e":{"docs":{"933":{"tf":1}},"df":1}},"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"933":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.7320508075688772},"51":{"tf":1},"54":{"tf":1.4142135623730951},"122":{"tf":3.4641016151377544},"182":{"tf":1.4142135623730951},"240":{"tf":1.7320508075688772},"283":{"tf":1},"286":{"tf":1.4142135623730951},"357":{"tf":3.872983346207417},"417":{"tf":1.4142135623730951},"471":{"tf":1.7320508075688772},"514":{"tf":1},"517":{"tf":1.4142135623730951},"635":{"tf":1.4142135623730951},"685":{"tf":1.7320508075688772},"728":{"tf":1},"731":{"tf":1.4142135623730951},"791":{"tf":1.4142135623730951},"886":{"tf":1.4142135623730951},"907":{"tf":1},"929":{"tf":1.4142135623730951},"933":{"tf":1.7320508075688772}},"df":23}}}},"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"5":{"tf":1.4142135623730951}},"df":1}}}}},"l":{"docs":{"78":{"tf":1},"122":{"tf":1.4142135623730951},"309":{"tf":1},"357":{"tf":1.4142135623730951},"540":{"tf":1},"944":{"tf":1}},"df":6}},"w":{"docs":{"43":{"tf":1},"94":{"tf":1},"122":{"tf":1},"275":{"tf":1},"325":{"tf":1},"356":{"tf":1},"357":{"tf":1},"506":{"tf":1},"556":{"tf":1},"720":{"tf":1},"865":{"tf":1}},"df":11},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"187":{"tf":1.7320508075688772},"188":{"tf":1},"189":{"tf":1},"422":{"tf":1.7320508075688772},"423":{"tf":1},"424":{"tf":1},"640":{"tf":1.7320508075688772},"641":{"tf":1},"642":{"tf":1},"850":{"tf":1.7320508075688772},"852":{"tf":1}},"df":11}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"38":{"tf":1},"128":{"tf":1.4142135623730951},"270":{"tf":1},"363":{"tf":1.4142135623730951},"501":{"tf":1},"581":{"tf":1.4142135623730951},"715":{"tf":1},"791":{"tf":1}},"df":8}}}}}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"109":{"tf":1},"340":{"tf":1},"571":{"tf":1},"778":{"tf":1}},"df":4},"s":{"docs":{},"df":0,"t":{"docs":{"845":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}},"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{"150":{"tf":1},"157":{"tf":1},"181":{"tf":1.4142135623730951},"385":{"tf":1},"392":{"tf":1},"416":{"tf":1.4142135623730951},"603":{"tf":1},"610":{"tf":1},"634":{"tf":1.4142135623730951},"844":{"tf":1}},"df":10}}}},"i":{"docs":{},"df":0,"l":{"docs":{"151":{"tf":1},"155":{"tf":1},"216":{"tf":1.7320508075688772},"226":{"tf":1.4142135623730951},"386":{"tf":1},"390":{"tf":1},"447":{"tf":1.7320508075688772},"457":{"tf":1},"604":{"tf":1},"608":{"tf":1},"661":{"tf":1.7320508075688772},"671":{"tf":1},"698":{"tf":1},"818":{"tf":1},"907":{"tf":1.4142135623730951},"920":{"tf":1},"921":{"tf":1},"924":{"tf":1}},"df":18}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"177":{"tf":1},"182":{"tf":1},"192":{"tf":1},"412":{"tf":1},"417":{"tf":1},"427":{"tf":1},"630":{"tf":1},"635":{"tf":1},"645":{"tf":1}},"df":9}}}}},"s":{"docs":{"203":{"tf":1},"224":{"tf":1},"226":{"tf":1},"229":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"438":{"tf":1},"455":{"tf":1},"457":{"tf":1.7320508075688772},"460":{"tf":1.4142135623730951},"463":{"tf":1.7320508075688772},"669":{"tf":1},"671":{"tf":1.7320508075688772},"674":{"tf":1.4142135623730951},"677":{"tf":1.7320508075688772},"876":{"tf":1},"878":{"tf":1.4142135623730951},"881":{"tf":2.23606797749979}},"df":17}},"r":{"docs":{"184":{"tf":1},"419":{"tf":1},"637":{"tf":1},"847":{"tf":1},"908":{"tf":1},"911":{"tf":1.4142135623730951},"920":{"tf":1}},"df":7},"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"907":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"210":{"tf":1},"751":{"tf":1},"806":{"tf":1},"902":{"tf":1}},"df":4}},"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"350":{"tf":1}},"df":1}}}}}},"x":{"docs":{"210":{"tf":1}},"df":1}},"a":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1.4142135623730951},"14":{"tf":1},"54":{"tf":1},"246":{"tf":1},"286":{"tf":1},"354":{"tf":1},"477":{"tf":1},"517":{"tf":1},"691":{"tf":1},"731":{"tf":1},"932":{"tf":1},"935":{"tf":1},"942":{"tf":1},"943":{"tf":1},"963":{"tf":1}},"df":15,"a":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"51":{"tf":1},"195":{"tf":1},"253":{"tf":1},"283":{"tf":1},"351":{"tf":1},"430":{"tf":1},"514":{"tf":1},"648":{"tf":1},"698":{"tf":1},"728":{"tf":1},"858":{"tf":1.4142135623730951},"893":{"tf":1},"905":{"tf":1},"911":{"tf":1},"932":{"tf":1},"933":{"tf":1},"936":{"tf":1},"941":{"tf":1},"944":{"tf":1},"950":{"tf":1},"951":{"tf":1}},"df":22,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"_":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"936":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}},"p":{"docs":{},"df":0,"p":{"docs":{"63":{"tf":1},"685":{"tf":1},"697":{"tf":1},"698":{"tf":1},"740":{"tf":1.4142135623730951},"741":{"tf":1.4142135623730951},"742":{"tf":1.4142135623730951},"743":{"tf":1},"785":{"tf":1},"866":{"tf":1.4142135623730951},"876":{"tf":1}},"df":11,"l":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1},"832":{"tf":1},"855":{"tf":1.4142135623730951},"878":{"tf":1}},"df":4,"c":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"8":{"tf":1.7320508075688772},"15":{"tf":1},"19":{"tf":1},"20":{"tf":1},"21":{"tf":2.449489742783178},"46":{"tf":1},"62":{"tf":2},"63":{"tf":1.4142135623730951},"67":{"tf":1},"72":{"tf":1},"86":{"tf":1},"94":{"tf":1},"97":{"tf":1},"115":{"tf":1},"116":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"125":{"tf":2.23606797749979},"140":{"tf":1},"155":{"tf":1.7320508075688772},"177":{"tf":1.4142135623730951},"192":{"tf":1},"223":{"tf":1},"224":{"tf":1},"229":{"tf":1.4142135623730951},"237":{"tf":1.7320508075688772},"240":{"tf":1.7320508075688772},"247":{"tf":1},"278":{"tf":1},"294":{"tf":1.7320508075688772},"295":{"tf":1},"317":{"tf":1},"325":{"tf":1},"346":{"tf":1},"347":{"tf":1.4142135623730951},"350":{"tf":1.4142135623730951},"351":{"tf":1.7320508075688772},"354":{"tf":1.7320508075688772},"356":{"tf":1},"360":{"tf":2.23606797749979},"375":{"tf":1},"390":{"tf":1.7320508075688772},"399":{"tf":1.4142135623730951},"412":{"tf":1},"427":{"tf":1},"455":{"tf":1},"460":{"tf":1.4142135623730951},"468":{"tf":1.7320508075688772},"471":{"tf":1.7320508075688772},"478":{"tf":1},"482":{"tf":1},"483":{"tf":1},"484":{"tf":1.7320508075688772},"509":{"tf":1},"513":{"tf":1},"525":{"tf":2},"526":{"tf":1.7320508075688772},"528":{"tf":1},"529":{"tf":1},"534":{"tf":1},"548":{"tf":1},"556":{"tf":1},"559":{"tf":1},"577":{"tf":1},"578":{"tf":1.4142135623730951},"593":{"tf":1},"608":{"tf":1.7320508075688772},"617":{"tf":1.4142135623730951},"630":{"tf":1.4142135623730951},"645":{"tf":1},"668":{"tf":1},"669":{"tf":1},"674":{"tf":1.4142135623730951},"682":{"tf":1.7320508075688772},"685":{"tf":2},"692":{"tf":1.4142135623730951},"696":{"tf":1.4142135623730951},"697":{"tf":1},"698":{"tf":1.4142135623730951},"723":{"tf":1},"739":{"tf":1.4142135623730951},"740":{"tf":2.449489742783178},"746":{"tf":1},"747":{"tf":1},"763":{"tf":1},"766":{"tf":1},"788":{"tf":1.4142135623730951},"791":{"tf":1},"803":{"tf":1},"827":{"tf":1.4142135623730951},"840":{"tf":1.4142135623730951},"855":{"tf":1},"886":{"tf":1},"907":{"tf":1.7320508075688772},"911":{"tf":1},"915":{"tf":1},"933":{"tf":1.4142135623730951}},"df":98}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"21":{"tf":1},"66":{"tf":1},"67":{"tf":1},"77":{"tf":1},"90":{"tf":1},"182":{"tf":1},"253":{"tf":1},"297":{"tf":1},"298":{"tf":1},"308":{"tf":1},"321":{"tf":1},"417":{"tf":1},"484":{"tf":1},"528":{"tf":1},"529":{"tf":1},"539":{"tf":1.4142135623730951},"552":{"tf":1},"635":{"tf":1},"698":{"tf":1},"742":{"tf":1},"747":{"tf":1},"748":{"tf":1},"757":{"tf":1},"814":{"tf":1},"845":{"tf":1},"846":{"tf":1},"876":{"tf":1},"877":{"tf":1},"916":{"tf":1},"924":{"tf":1},"928":{"tf":1}},"df":31}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"x":{"docs":{"791":{"tf":1}},"df":1}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"34":{"tf":1},"47":{"tf":1},"94":{"tf":1},"125":{"tf":1},"266":{"tf":1},"279":{"tf":1},"325":{"tf":1},"360":{"tf":1},"497":{"tf":1},"510":{"tf":1},"556":{"tf":1},"711":{"tf":1},"724":{"tf":1},"763":{"tf":1},"770":{"tf":1},"788":{"tf":1},"893":{"tf":1},"907":{"tf":1},"918":{"tf":1},"924":{"tf":1},"929":{"tf":1},"932":{"tf":1},"933":{"tf":1}},"df":23}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"68":{"tf":1},"101":{"tf":1},"231":{"tf":1},"299":{"tf":1},"332":{"tf":1},"462":{"tf":1},"530":{"tf":1},"563":{"tf":1},"676":{"tf":1},"881":{"tf":1}},"df":10}}},"x":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"933":{"tf":1}},"df":1}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"866":{"tf":1}},"df":1}}}}}}},"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"866":{"tf":1}},"df":1}}}}}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"155":{"tf":1},"264":{"tf":1},"390":{"tf":1},"495":{"tf":1},"608":{"tf":1}},"df":6}}},"k":{"docs":{"741":{"tf":1.4142135623730951}},"df":1}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"k":{"docs":{"3":{"tf":1}},"df":1}},"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"y":{"docs":{"3":{"tf":1},"82":{"tf":1},"116":{"tf":1},"151":{"tf":1},"177":{"tf":1},"229":{"tf":1.4142135623730951},"313":{"tf":1},"347":{"tf":1},"354":{"tf":1},"386":{"tf":1},"412":{"tf":1},"460":{"tf":1.4142135623730951},"544":{"tf":1},"578":{"tf":1},"604":{"tf":1},"630":{"tf":1},"674":{"tf":1.4142135623730951},"758":{"tf":1},"785":{"tf":1},"800":{"tf":1},"881":{"tf":1.4142135623730951},"898":{"tf":1},"925":{"tf":1}},"df":23}}},"l":{"docs":{"4":{"tf":1},"5":{"tf":1},"8":{"tf":1},"28":{"tf":1},"38":{"tf":1},"40":{"tf":1},"43":{"tf":1},"81":{"tf":1},"86":{"tf":1},"122":{"tf":2},"125":{"tf":1.4142135623730951},"131":{"tf":1},"134":{"tf":1.4142135623730951},"138":{"tf":1},"145":{"tf":1},"161":{"tf":1},"176":{"tf":1},"177":{"tf":1},"183":{"tf":1},"189":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"199":{"tf":1},"210":{"tf":1},"229":{"tf":1},"232":{"tf":1.4142135623730951},"237":{"tf":1},"240":{"tf":1.4142135623730951},"260":{"tf":1},"270":{"tf":1},"272":{"tf":1},"275":{"tf":1},"312":{"tf":1},"317":{"tf":1},"351":{"tf":1.4142135623730951},"357":{"tf":2},"360":{"tf":1.4142135623730951},"366":{"tf":1},"369":{"tf":1.4142135623730951},"373":{"tf":1},"380":{"tf":1},"396":{"tf":1},"411":{"tf":1},"412":{"tf":1},"418":{"tf":1},"424":{"tf":1.4142135623730951},"427":{"tf":1.4142135623730951},"434":{"tf":1},"457":{"tf":1},"460":{"tf":1},"463":{"tf":1.4142135623730951},"468":{"tf":1},"471":{"tf":1.4142135623730951},"491":{"tf":1},"501":{"tf":1},"503":{"tf":1},"506":{"tf":1},"543":{"tf":1},"548":{"tf":1},"584":{"tf":1},"587":{"tf":1.4142135623730951},"591":{"tf":1},"598":{"tf":1},"614":{"tf":1},"629":{"tf":1},"630":{"tf":1},"636":{"tf":1},"642":{"tf":1.4142135623730951},"645":{"tf":1.4142135623730951},"652":{"tf":1},"671":{"tf":1},"674":{"tf":1},"677":{"tf":1.4142135623730951},"682":{"tf":1},"685":{"tf":1},"705":{"tf":1},"715":{"tf":1},"717":{"tf":1},"720":{"tf":1},"742":{"tf":1},"746":{"tf":1},"757":{"tf":1},"797":{"tf":1.7320508075688772},"801":{"tf":1},"824":{"tf":1},"839":{"tf":1},"852":{"tf":1.4142135623730951},"855":{"tf":1},"862":{"tf":1},"866":{"tf":1},"881":{"tf":1.7320508075688772},"889":{"tf":1},"905":{"tf":1},"910":{"tf":1},"912":{"tf":1.7320508075688772},"913":{"tf":1},"915":{"tf":1.4142135623730951},"927":{"tf":1},"932":{"tf":1.4142135623730951},"933":{"tf":1.4142135623730951},"936":{"tf":1},"938":{"tf":1},"939":{"tf":2},"941":{"tf":1.7320508075688772},"944":{"tf":1},"951":{"tf":1},"954":{"tf":2.449489742783178}},"df":106,"o":{"docs":{},"df":0,"w":{"docs":{"14":{"tf":1},"21":{"tf":1},"40":{"tf":1},"43":{"tf":1},"122":{"tf":1},"125":{"tf":1.7320508075688772},"143":{"tf":1},"168":{"tf":1},"207":{"tf":1},"246":{"tf":1},"253":{"tf":1},"272":{"tf":1},"275":{"tf":1},"357":{"tf":1},"360":{"tf":1.7320508075688772},"378":{"tf":1},"403":{"tf":1},"477":{"tf":1},"503":{"tf":1},"506":{"tf":1},"596":{"tf":1},"621":{"tf":1},"691":{"tf":1},"717":{"tf":1},"720":{"tf":1},"806":{"tf":1},"831":{"tf":1},"902":{"tf":1},"907":{"tf":1.4142135623730951},"915":{"tf":1},"946":{"tf":1.4142135623730951},"954":{"tf":1}},"df":32}}},"t":{"docs":{"4":{"tf":1},"86":{"tf":1},"317":{"tf":1},"548":{"tf":1}},"df":4,"e":{"docs":{},"df":0,"r":{"docs":{"182":{"tf":1},"417":{"tf":1},"635":{"tf":1},"936":{"tf":1}},"df":4,"n":{"docs":{"4":{"tf":1},"34":{"tf":1},"105":{"tf":1.4142135623730951},"109":{"tf":1},"134":{"tf":1},"266":{"tf":1},"336":{"tf":1.4142135623730951},"340":{"tf":1},"369":{"tf":1},"497":{"tf":1},"567":{"tf":1.4142135623730951},"571":{"tf":1},"587":{"tf":1},"698":{"tf":1},"711":{"tf":1},"741":{"tf":1},"774":{"tf":1},"778":{"tf":1},"785":{"tf":1},"797":{"tf":1},"926":{"tf":1}},"df":21}}},"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"f":{"1":{"2":{"docs":{"128":{"tf":1},"161":{"tf":1},"363":{"tf":1},"396":{"tf":1},"581":{"tf":1},"614":{"tf":1},"791":{"tf":1},"824":{"tf":1}},"df":8},"docs":{},"df":0},"docs":{},"df":0}}}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{"832":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"20":{"tf":1},"37":{"tf":1},"38":{"tf":1},"64":{"tf":1},"66":{"tf":1.7320508075688772},"91":{"tf":1},"97":{"tf":1},"109":{"tf":1},"115":{"tf":1},"116":{"tf":1},"119":{"tf":1},"157":{"tf":1},"182":{"tf":1},"187":{"tf":1},"195":{"tf":1},"203":{"tf":1.4142135623730951},"223":{"tf":1},"224":{"tf":1},"226":{"tf":1},"237":{"tf":1},"240":{"tf":1},"252":{"tf":1},"253":{"tf":1},"269":{"tf":1},"270":{"tf":1},"295":{"tf":1},"297":{"tf":1},"322":{"tf":1},"328":{"tf":1},"340":{"tf":1},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1},"354":{"tf":1.4142135623730951},"392":{"tf":1},"417":{"tf":1},"422":{"tf":1},"430":{"tf":1},"438":{"tf":1.4142135623730951},"454":{"tf":1},"455":{"tf":1},"457":{"tf":1},"468":{"tf":1},"471":{"tf":1},"483":{"tf":1},"484":{"tf":1},"500":{"tf":1},"501":{"tf":1},"526":{"tf":1.4142135623730951},"528":{"tf":1.7320508075688772},"553":{"tf":1},"559":{"tf":1},"571":{"tf":1},"577":{"tf":1},"578":{"tf":1},"610":{"tf":1},"635":{"tf":1},"640":{"tf":1},"648":{"tf":1},"668":{"tf":1},"669":{"tf":1},"671":{"tf":1},"682":{"tf":1},"698":{"tf":1.4142135623730951},"714":{"tf":1},"715":{"tf":1},"748":{"tf":1},"749":{"tf":1},"766":{"tf":1},"784":{"tf":1},"788":{"tf":1},"791":{"tf":1},"797":{"tf":1},"803":{"tf":1},"820":{"tf":1},"839":{"tf":1},"840":{"tf":1},"845":{"tf":1},"858":{"tf":1},"875":{"tf":1},"876":{"tf":1},"878":{"tf":1},"886":{"tf":1},"896":{"tf":1},"907":{"tf":1},"911":{"tf":1.4142135623730951},"913":{"tf":1},"915":{"tf":1.4142135623730951},"916":{"tf":1.7320508075688772}},"df":89}}}}},"o":{"docs":{},"df":0,"n":{"docs":{"63":{"tf":1}},"df":1,"g":{"docs":{"253":{"tf":1},"757":{"tf":1}},"df":2}}},"g":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"m":{"docs":{"122":{"tf":1},"168":{"tf":1},"354":{"tf":1},"357":{"tf":1},"403":{"tf":1},"621":{"tf":1}},"df":6}}}}}}},"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"846":{"tf":1}},"df":1}}}}},"n":{"docs":{},"df":0,"i":{"docs":{"3":{"tf":1},"21":{"tf":1},"116":{"tf":1},"125":{"tf":1.4142135623730951},"128":{"tf":1},"144":{"tf":1},"195":{"tf":1},"199":{"tf":1},"209":{"tf":1},"215":{"tf":1},"229":{"tf":1.4142135623730951},"296":{"tf":1},"347":{"tf":1},"357":{"tf":1},"360":{"tf":1.4142135623730951},"363":{"tf":1},"379":{"tf":1},"430":{"tf":1},"434":{"tf":1},"446":{"tf":1},"460":{"tf":1.4142135623730951},"578":{"tf":1},"581":{"tf":1},"597":{"tf":1},"648":{"tf":1},"652":{"tf":1},"660":{"tf":1},"674":{"tf":1.4142135623730951},"696":{"tf":1},"839":{"tf":1},"862":{"tf":1},"866":{"tf":1},"881":{"tf":1.4142135623730951},"894":{"tf":1},"901":{"tf":1},"905":{"tf":1},"907":{"tf":1},"911":{"tf":1}},"df":38},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{"119":{"tf":1},"351":{"tf":1}},"df":2,"i":{"docs":{"3":{"tf":1},"26":{"tf":1},"34":{"tf":1.4142135623730951},"39":{"tf":1},"91":{"tf":1},"258":{"tf":1},"266":{"tf":1.4142135623730951},"271":{"tf":1},"322":{"tf":1},"489":{"tf":1},"497":{"tf":1.4142135623730951},"502":{"tf":1},"553":{"tf":1},"703":{"tf":1},"711":{"tf":1.4142135623730951},"716":{"tf":1},"827":{"tf":1},"910":{"tf":1}},"df":18}},"z":{"docs":{"4":{"tf":1},"39":{"tf":1},"40":{"tf":1},"115":{"tf":1},"232":{"tf":1},"271":{"tf":1},"272":{"tf":1},"346":{"tf":1},"354":{"tf":1},"463":{"tf":1},"502":{"tf":1},"503":{"tf":1},"577":{"tf":1},"677":{"tf":1},"716":{"tf":1},"717":{"tf":1},"781":{"tf":1},"881":{"tf":1}},"df":18}},"o":{"docs":{},"df":0,"g":{"docs":{"785":{"tf":1},"813":{"tf":1}},"df":2}}}},"d":{"docs":{},"df":0,"/":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1},"207":{"tf":1},"246":{"tf":1},"477":{"tf":1},"691":{"tf":1}},"df":5}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"685":{"tf":1.4142135623730951},"696":{"tf":1.4142135623730951},"697":{"tf":1},"698":{"tf":2.6457513110645907},"699":{"tf":1},"740":{"tf":1.7320508075688772},"741":{"tf":1.4142135623730951},"742":{"tf":1},"747":{"tf":1},"759":{"tf":1},"760":{"tf":1},"785":{"tf":1},"827":{"tf":1},"866":{"tf":2}},"df":14}}}}},"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{"32":{"tf":1},"39":{"tf":1},"169":{"tf":1},"176":{"tf":1},"177":{"tf":1},"182":{"tf":1},"230":{"tf":1.4142135623730951},"231":{"tf":1.4142135623730951},"264":{"tf":1},"271":{"tf":1},"404":{"tf":1},"411":{"tf":1},"412":{"tf":1},"417":{"tf":1},"461":{"tf":1.4142135623730951},"462":{"tf":1.4142135623730951},"495":{"tf":1},"502":{"tf":1},"622":{"tf":1},"629":{"tf":1},"630":{"tf":1},"635":{"tf":1},"675":{"tf":1.4142135623730951},"676":{"tf":1.4142135623730951},"716":{"tf":1},"831":{"tf":1},"832":{"tf":1},"839":{"tf":1},"840":{"tf":1},"841":{"tf":1},"845":{"tf":1},"881":{"tf":1.4142135623730951},"893":{"tf":1},"899":{"tf":1},"907":{"tf":1},"911":{"tf":1},"918":{"tf":1},"929":{"tf":1},"944":{"tf":1},"946":{"tf":1}},"df":40}}},"y":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"122":{"tf":1.4142135623730951},"357":{"tf":1.4142135623730951},"900":{"tf":1},"911":{"tf":1},"917":{"tf":1},"924":{"tf":1},"951":{"tf":1}},"df":7}}}},"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"192":{"tf":1},"427":{"tf":1},"645":{"tf":1},"757":{"tf":1},"855":{"tf":1}},"df":5}}}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"351":{"tf":1}},"df":1}}}}}},"d":{"docs":{"81":{"tf":1},"176":{"tf":1},"177":{"tf":1},"181":{"tf":1},"192":{"tf":1},"195":{"tf":1},"231":{"tf":1},"312":{"tf":1},"411":{"tf":1},"412":{"tf":1},"416":{"tf":1},"427":{"tf":1},"430":{"tf":1},"462":{"tf":1},"543":{"tf":1},"629":{"tf":1},"630":{"tf":1},"634":{"tf":1},"645":{"tf":1},"648":{"tf":1},"676":{"tf":1},"841":{"tf":1},"881":{"tf":1},"898":{"tf":1},"915":{"tf":1},"925":{"tf":1}},"df":26,"d":{"docs":{"94":{"tf":1},"103":{"tf":1},"169":{"tf":1.4142135623730951},"175":{"tf":1},"177":{"tf":1},"178":{"tf":1.4142135623730951},"181":{"tf":1},"182":{"tf":1},"188":{"tf":1},"195":{"tf":1.4142135623730951},"230":{"tf":1},"232":{"tf":1.7320508075688772},"325":{"tf":1},"334":{"tf":1},"404":{"tf":1.4142135623730951},"410":{"tf":1},"412":{"tf":1},"413":{"tf":1.4142135623730951},"416":{"tf":1},"417":{"tf":1},"423":{"tf":1},"430":{"tf":1.4142135623730951},"461":{"tf":1},"463":{"tf":1.7320508075688772},"556":{"tf":1},"565":{"tf":1},"622":{"tf":1.4142135623730951},"628":{"tf":1},"630":{"tf":1},"631":{"tf":1.4142135623730951},"634":{"tf":1},"635":{"tf":1},"641":{"tf":1},"648":{"tf":1.4142135623730951},"675":{"tf":1},"677":{"tf":1.7320508075688772},"832":{"tf":1.4142135623730951},"838":{"tf":1},"840":{"tf":1},"841":{"tf":1},"845":{"tf":1},"858":{"tf":1},"881":{"tf":2},"892":{"tf":1},"893":{"tf":1},"897":{"tf":1},"913":{"tf":1},"946":{"tf":1},"951":{"tf":1},"954":{"tf":1},"958":{"tf":1},"960":{"tf":1}},"df":52,"i":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1},"176":{"tf":1},"177":{"tf":1},"178":{"tf":1.7320508075688772},"187":{"tf":1},"195":{"tf":1.7320508075688772},"198":{"tf":1},"272":{"tf":1},"350":{"tf":1.7320508075688772},"354":{"tf":1},"411":{"tf":1},"412":{"tf":1},"413":{"tf":1.7320508075688772},"422":{"tf":1},"430":{"tf":1.7320508075688772},"433":{"tf":1},"503":{"tf":1},"629":{"tf":1},"630":{"tf":1},"631":{"tf":1.7320508075688772},"640":{"tf":1},"648":{"tf":1.7320508075688772},"651":{"tf":1},"717":{"tf":1},"740":{"tf":1},"778":{"tf":1},"785":{"tf":1},"791":{"tf":1},"814":{"tf":1},"818":{"tf":1},"850":{"tf":1},"861":{"tf":1},"878":{"tf":1},"901":{"tf":1}},"df":34,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"169":{"tf":1},"215":{"tf":1},"404":{"tf":1},"446":{"tf":1},"622":{"tf":1},"660":{"tf":1},"890":{"tf":1},"961":{"tf":1}},"df":9}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"64":{"tf":1},"112":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":2.23606797749979},"125":{"tf":1.7320508075688772},"295":{"tf":1},"305":{"tf":1.4142135623730951},"343":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":2.23606797749979},"350":{"tf":1.4142135623730951},"360":{"tf":1.7320508075688772},"526":{"tf":1},"574":{"tf":1},"577":{"tf":1.4142135623730951},"578":{"tf":2.23606797749979},"781":{"tf":1},"784":{"tf":1.4142135623730951},"785":{"tf":2},"788":{"tf":1}},"df":20,"@":{"docs":{},"df":0,"#":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,":":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"=":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951}},"df":2}}}}}}}}}}}}}}}}}}}}}}}}}}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"4":{"tf":1.4142135623730951},"8":{"tf":1.4142135623730951},"51":{"tf":1},"128":{"tf":1.4142135623730951},"181":{"tf":1},"240":{"tf":1.4142135623730951},"283":{"tf":1},"363":{"tf":1.4142135623730951},"416":{"tf":1},"471":{"tf":1.4142135623730951},"514":{"tf":1},"581":{"tf":1.4142135623730951},"634":{"tf":1},"685":{"tf":1.4142135623730951},"728":{"tf":1},"791":{"tf":1.4142135623730951},"844":{"tf":1},"886":{"tf":1.4142135623730951},"905":{"tf":1.4142135623730951},"906":{"tf":1},"908":{"tf":1},"916":{"tf":1},"920":{"tf":1}},"df":23},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{"350":{"tf":1},"890":{"tf":1},"907":{"tf":1},"913":{"tf":1},"932":{"tf":1}},"df":5}}}}},"i":{"docs":{},"df":0,"s":{"docs":{"253":{"tf":1},"803":{"tf":1},"858":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"26":{"tf":1},"168":{"tf":1},"182":{"tf":1},"195":{"tf":1.4142135623730951},"258":{"tf":1},"403":{"tf":1},"417":{"tf":1},"430":{"tf":1.4142135623730951},"489":{"tf":1},"621":{"tf":1},"635":{"tf":1},"648":{"tf":1.4142135623730951},"703":{"tf":1},"858":{"tf":1}},"df":14}}},"j":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"748":{"tf":1},"840":{"tf":1},"841":{"tf":1.7320508075688772},"845":{"tf":1},"858":{"tf":1}},"df":5}}}},"b":{"docs":{"866":{"tf":1.4142135623730951}},"df":1}},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1},"11":{"tf":1},"43":{"tf":1.4142135623730951},"59":{"tf":1},"94":{"tf":1},"112":{"tf":1},"119":{"tf":1},"122":{"tf":1},"125":{"tf":1.4142135623730951},"128":{"tf":1.4142135623730951},"164":{"tf":1},"195":{"tf":1.7320508075688772},"210":{"tf":1.7320508075688772},"220":{"tf":1.4142135623730951},"237":{"tf":1.4142135623730951},"243":{"tf":1},"275":{"tf":1.4142135623730951},"291":{"tf":1},"325":{"tf":1},"343":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1},"360":{"tf":1.4142135623730951},"363":{"tf":1.4142135623730951},"399":{"tf":1},"430":{"tf":1.7320508075688772},"451":{"tf":1.4142135623730951},"468":{"tf":1.4142135623730951},"474":{"tf":1},"506":{"tf":1.4142135623730951},"522":{"tf":1},"556":{"tf":1},"574":{"tf":1},"581":{"tf":1.4142135623730951},"617":{"tf":1},"648":{"tf":1.7320508075688772},"665":{"tf":1.4142135623730951},"682":{"tf":1.4142135623730951},"698":{"tf":1.4142135623730951},"720":{"tf":1.4142135623730951},"740":{"tf":1},"741":{"tf":1},"746":{"tf":1},"788":{"tf":1},"791":{"tf":1},"797":{"tf":1},"827":{"tf":1},"858":{"tf":1},"866":{"tf":1},"872":{"tf":1.4142135623730951},"912":{"tf":1},"963":{"tf":1}},"df":52}}},"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"94":{"tf":1},"325":{"tf":1},"556":{"tf":1},"763":{"tf":1},"890":{"tf":1},"899":{"tf":1}},"df":6}}}},"s":{"docs":{},"df":0,"k":{"docs":{"14":{"tf":1},"81":{"tf":1},"215":{"tf":1},"246":{"tf":1},"295":{"tf":1},"312":{"tf":1},"446":{"tf":1},"477":{"tf":1},"543":{"tf":1},"660":{"tf":1},"691":{"tf":1}},"df":11},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"54":{"tf":1},"286":{"tf":1},"517":{"tf":1},"731":{"tf":1}},"df":4},"m":{"docs":{"199":{"tf":1},"434":{"tf":1},"652":{"tf":1},"907":{"tf":1},"915":{"tf":1},"921":{"tf":1},"951":{"tf":1}},"df":7}},"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"122":{"tf":1.4142135623730951},"357":{"tf":1.4142135623730951}},"df":2}}},"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"n":{"docs":{"128":{"tf":1},"350":{"tf":1},"363":{"tf":1},"581":{"tf":1},"840":{"tf":1},"855":{"tf":1}},"df":6}},"s":{"docs":{},"df":0,"t":{"docs":{"351":{"tf":1}},"df":1}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"907":{"tf":1.4142135623730951},"946":{"tf":1}},"df":2}}}}},"c":{"docs":{},"df":0,"t":{"docs":{"954":{"tf":1}},"df":1,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"20":{"tf":1},"21":{"tf":1},"26":{"tf":1},"27":{"tf":1.7320508075688772},"32":{"tf":1},"37":{"tf":1},"59":{"tf":1},"67":{"tf":1},"68":{"tf":1},"71":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"94":{"tf":1},"101":{"tf":1},"102":{"tf":1},"105":{"tf":1.4142135623730951},"119":{"tf":1},"140":{"tf":1},"164":{"tf":1},"168":{"tf":1},"203":{"tf":1.4142135623730951},"210":{"tf":1},"229":{"tf":1},"231":{"tf":1},"232":{"tf":1.4142135623730951},"258":{"tf":1},"259":{"tf":1.7320508075688772},"264":{"tf":1},"269":{"tf":1},"291":{"tf":1},"298":{"tf":1},"299":{"tf":1},"302":{"tf":1.4142135623730951},"303":{"tf":1.4142135623730951},"317":{"tf":1},"325":{"tf":1},"332":{"tf":1},"333":{"tf":1},"336":{"tf":1.4142135623730951},"354":{"tf":1},"375":{"tf":1},"399":{"tf":1},"403":{"tf":1},"438":{"tf":1.4142135623730951},"460":{"tf":1},"462":{"tf":1},"463":{"tf":1.4142135623730951},"483":{"tf":1},"484":{"tf":1},"489":{"tf":1},"490":{"tf":1.7320508075688772},"495":{"tf":1},"500":{"tf":1},"522":{"tf":1},"529":{"tf":1},"530":{"tf":1},"533":{"tf":1.4142135623730951},"534":{"tf":2},"548":{"tf":1.4142135623730951},"556":{"tf":1},"563":{"tf":1},"564":{"tf":1},"567":{"tf":1.4142135623730951},"593":{"tf":1},"617":{"tf":1},"621":{"tf":1},"674":{"tf":1},"676":{"tf":1},"677":{"tf":1.4142135623730951},"697":{"tf":1},"704":{"tf":1.7320508075688772},"714":{"tf":1},"736":{"tf":1},"746":{"tf":1.4142135623730951},"748":{"tf":1},"749":{"tf":1.4142135623730951},"751":{"tf":1},"757":{"tf":1},"770":{"tf":1},"771":{"tf":1},"806":{"tf":1},"881":{"tf":2},"936":{"tf":1.4142135623730951},"938":{"tf":1},"939":{"tf":1},"945":{"tf":1}},"df":86,"_":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"_":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"785":{"tf":1},"881":{"tf":1}},"df":2,"@":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{"785":{"tf":1}},"df":1}}}}},"&":{"docs":{},"df":0,"$":{"docs":{},"df":0,"(":{"docs":{},"df":0,"i":{"docs":{},"df":0,")":{"docs":{},"df":0,"@":{"docs":{},"df":0,"#":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"881":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}},"v":{"docs":{"21":{"tf":1},"115":{"tf":1},"116":{"tf":1},"125":{"tf":1.7320508075688772},"131":{"tf":1.4142135623730951},"137":{"tf":1},"138":{"tf":1},"139":{"tf":1},"140":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"149":{"tf":1.4142135623730951},"229":{"tf":1},"253":{"tf":1},"346":{"tf":1},"347":{"tf":1},"360":{"tf":1.7320508075688772},"366":{"tf":1.4142135623730951},"372":{"tf":1},"373":{"tf":1},"374":{"tf":1},"375":{"tf":1.4142135623730951},"379":{"tf":1.4142135623730951},"384":{"tf":1.4142135623730951},"460":{"tf":1},"484":{"tf":1},"577":{"tf":1},"578":{"tf":1},"584":{"tf":1.4142135623730951},"590":{"tf":1},"591":{"tf":1},"592":{"tf":1},"593":{"tf":1.4142135623730951},"597":{"tf":1.4142135623730951},"602":{"tf":1.4142135623730951},"674":{"tf":1},"698":{"tf":1},"784":{"tf":1},"791":{"tf":1},"794":{"tf":1.4142135623730951},"797":{"tf":1},"800":{"tf":1},"801":{"tf":1},"803":{"tf":1},"806":{"tf":1},"807":{"tf":1},"812":{"tf":1},"824":{"tf":1.4142135623730951},"866":{"tf":1.7320508075688772},"881":{"tf":1},"905":{"tf":1},"926":{"tf":1}},"df":51}},"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1},"105":{"tf":1},"155":{"tf":1.4142135623730951},"253":{"tf":1},"270":{"tf":1.4142135623730951},"271":{"tf":1},"336":{"tf":1},"390":{"tf":1.4142135623730951},"484":{"tf":1.4142135623730951},"501":{"tf":1.4142135623730951},"502":{"tf":1},"567":{"tf":1},"608":{"tf":1.4142135623730951},"715":{"tf":1.4142135623730951},"716":{"tf":1},"818":{"tf":1.4142135623730951},"890":{"tf":1},"894":{"tf":1},"954":{"tf":1}},"df":21}}}},"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"v":{"docs":{"43":{"tf":1},"51":{"tf":1},"122":{"tf":1},"140":{"tf":1.4142135623730951},"155":{"tf":1},"237":{"tf":1},"275":{"tf":1},"283":{"tf":1},"357":{"tf":1},"375":{"tf":1.4142135623730951},"390":{"tf":1},"468":{"tf":1},"506":{"tf":1},"514":{"tf":1},"593":{"tf":1.4142135623730951},"608":{"tf":1},"682":{"tf":1},"720":{"tf":1},"728":{"tf":1},"763":{"tf":1},"803":{"tf":1},"845":{"tf":1},"889":{"tf":1},"902":{"tf":1},"909":{"tf":1},"912":{"tf":1},"929":{"tf":1},"933":{"tf":1},"949":{"tf":1},"955":{"tf":1},"960":{"tf":1}},"df":31}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"68":{"tf":1},"189":{"tf":1},"192":{"tf":1},"202":{"tf":1},"209":{"tf":1},"215":{"tf":1.4142135623730951},"226":{"tf":1},"299":{"tf":1},"351":{"tf":1},"424":{"tf":1},"427":{"tf":1},"437":{"tf":1},"446":{"tf":1.4142135623730951},"457":{"tf":1},"530":{"tf":1},"642":{"tf":1},"645":{"tf":1},"660":{"tf":1.4142135623730951},"671":{"tf":1},"834":{"tf":1},"901":{"tf":1}},"df":21,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"357":{"tf":1.7320508075688772},"915":{"tf":2.6457513110645907},"916":{"tf":2.23606797749979},"917":{"tf":1},"940":{"tf":1},"941":{"tf":1}},"df":6},"y":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"940":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"767":{"tf":1},"907":{"tf":1},"916":{"tf":1.4142135623730951},"936":{"tf":1},"951":{"tf":1.4142135623730951},"960":{"tf":1}},"df":6,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"189":{"tf":1},"424":{"tf":1},"642":{"tf":1},"746":{"tf":1},"852":{"tf":1}},"df":5}}}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"944":{"tf":1}},"df":1}}}},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"717":{"tf":1}},"df":1}}}}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"21":{"tf":1},"134":{"tf":1},"151":{"tf":1},"253":{"tf":1},"369":{"tf":1},"386":{"tf":1},"484":{"tf":1},"587":{"tf":1},"604":{"tf":1},"698":{"tf":1},"797":{"tf":1},"800":{"tf":1},"801":{"tf":1}},"df":13}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"43":{"tf":1},"81":{"tf":1},"195":{"tf":1},"275":{"tf":1},"312":{"tf":1},"430":{"tf":1},"506":{"tf":1},"543":{"tf":1},"648":{"tf":1},"720":{"tf":1},"757":{"tf":1}},"df":11}}}}}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"56":{"tf":1},"288":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":4}}}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}},"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"189":{"tf":1},"203":{"tf":1},"424":{"tf":1},"438":{"tf":1},"642":{"tf":1},"852":{"tf":1},"855":{"tf":1}},"df":7}}}}}},"e":{"docs":{},"df":0,"a":{"docs":{"199":{"tf":1},"434":{"tf":1},"652":{"tf":1},"781":{"tf":1},"895":{"tf":1},"907":{"tf":1},"912":{"tf":1},"915":{"tf":1}},"df":8}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{"915":{"tf":1.7320508075688772}},"df":1}}}},"i":{"docs":{},"df":0,"s":{"docs":{"926":{"tf":1}},"df":1}}},"g":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"34":{"tf":1},"50":{"tf":1},"77":{"tf":1},"133":{"tf":1},"134":{"tf":1},"157":{"tf":1},"161":{"tf":1},"177":{"tf":1},"181":{"tf":1},"182":{"tf":1},"184":{"tf":1},"189":{"tf":1},"229":{"tf":1},"234":{"tf":1},"240":{"tf":1},"266":{"tf":1},"282":{"tf":1},"308":{"tf":1},"368":{"tf":1},"369":{"tf":1},"392":{"tf":1},"396":{"tf":1},"412":{"tf":1},"416":{"tf":1},"417":{"tf":1},"419":{"tf":1},"424":{"tf":1},"460":{"tf":1},"465":{"tf":1},"471":{"tf":1},"497":{"tf":1},"513":{"tf":1},"539":{"tf":1},"586":{"tf":1},"587":{"tf":1},"610":{"tf":1},"614":{"tf":1},"630":{"tf":1},"634":{"tf":1},"635":{"tf":1},"637":{"tf":1},"642":{"tf":1},"674":{"tf":1},"679":{"tf":1},"711":{"tf":1},"749":{"tf":1.4142135623730951},"796":{"tf":1},"797":{"tf":1},"812":{"tf":1},"820":{"tf":1},"824":{"tf":1},"840":{"tf":1},"845":{"tf":1},"852":{"tf":1},"881":{"tf":1},"883":{"tf":1},"907":{"tf":1},"913":{"tf":1},"915":{"tf":1},"921":{"tf":1.4142135623730951},"936":{"tf":1},"949":{"tf":1.4142135623730951},"954":{"tf":1},"959":{"tf":1},"961":{"tf":1}},"df":65}}}},"t":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"116":{"tf":1},"119":{"tf":1},"122":{"tf":4.242640687119285},"156":{"tf":1},"170":{"tf":1},"171":{"tf":1.4142135623730951},"187":{"tf":1},"188":{"tf":1},"189":{"tf":1},"225":{"tf":1},"231":{"tf":2},"232":{"tf":1.7320508075688772},"275":{"tf":1},"347":{"tf":1},"354":{"tf":1},"357":{"tf":4.242640687119285},"391":{"tf":1},"405":{"tf":1},"406":{"tf":1.4142135623730951},"422":{"tf":1},"423":{"tf":1},"424":{"tf":1},"456":{"tf":1},"462":{"tf":2},"463":{"tf":1.7320508075688772},"506":{"tf":1},"578":{"tf":1},"609":{"tf":1},"623":{"tf":1},"624":{"tf":1.4142135623730951},"640":{"tf":1},"641":{"tf":1},"642":{"tf":1},"670":{"tf":1},"676":{"tf":2},"677":{"tf":1.7320508075688772},"720":{"tf":1},"819":{"tf":1},"833":{"tf":1},"834":{"tf":1.4142135623730951},"851":{"tf":1},"852":{"tf":1},"858":{"tf":1},"877":{"tf":1},"881":{"tf":2.6457513110645907},"899":{"tf":1.7320508075688772},"900":{"tf":1},"916":{"tf":1},"929":{"tf":1},"946":{"tf":1},"948":{"tf":1.4142135623730951},"955":{"tf":1}},"df":53}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"128":{"tf":1},"363":{"tf":1},"581":{"tf":1},"791":{"tf":1}},"df":4}}}}},"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{"98":{"tf":1},"122":{"tf":1},"125":{"tf":1.4142135623730951},"176":{"tf":1},"189":{"tf":1},"232":{"tf":1},"329":{"tf":1},"356":{"tf":1},"357":{"tf":1},"360":{"tf":1.4142135623730951},"411":{"tf":1},"424":{"tf":1},"463":{"tf":1},"560":{"tf":1},"629":{"tf":1},"642":{"tf":1},"677":{"tf":1},"767":{"tf":1},"774":{"tf":1},"832":{"tf":1},"834":{"tf":1},"838":{"tf":1},"839":{"tf":1.4142135623730951},"850":{"tf":1},"852":{"tf":1},"881":{"tf":1},"915":{"tf":1}},"df":27},"r":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1.4142135623730951}},"df":1}}},"i":{"docs":{},"df":0,"l":{"docs":{"918":{"tf":1}},"df":1}}},"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"101":{"tf":1},"149":{"tf":1},"332":{"tf":1},"384":{"tf":1},"563":{"tf":1},"602":{"tf":1},"770":{"tf":1},"844":{"tf":1},"918":{"tf":1},"948":{"tf":1}},"df":10}}}}}}},"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"819":{"tf":1},"954":{"tf":1}},"df":2}}}}},"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"125":{"tf":1},"237":{"tf":1},"360":{"tf":1},"468":{"tf":1},"682":{"tf":1},"806":{"tf":1}},"df":6}}}},"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"140":{"tf":1},"375":{"tf":1},"593":{"tf":1}},"df":3},"y":{"docs":{"184":{"tf":1},"419":{"tf":1},"637":{"tf":1}},"df":3}}},"i":{"docs":{},"df":0,"m":{"docs":{"176":{"tf":1},"411":{"tf":1},"629":{"tf":1}},"df":3}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"717":{"tf":1}},"df":1}}}}}},"j":{"docs":{},"df":0,"a":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":2},"8":{"tf":1.4142135623730951},"11":{"tf":1},"14":{"tf":1},"27":{"tf":1},"34":{"tf":1},"59":{"tf":1.4142135623730951},"62":{"tf":1},"94":{"tf":1},"112":{"tf":1},"119":{"tf":1},"122":{"tf":1.7320508075688772},"125":{"tf":1},"128":{"tf":1},"164":{"tf":1},"168":{"tf":1},"195":{"tf":1},"202":{"tf":1},"220":{"tf":1},"240":{"tf":1.4142135623730951},"246":{"tf":1},"360":{"tf":1},"399":{"tf":1},"403":{"tf":1},"471":{"tf":1.4142135623730951},"477":{"tf":1},"617":{"tf":1},"621":{"tf":1},"691":{"tf":1.4142135623730951},"827":{"tf":1},"831":{"tf":1.4142135623730951},"886":{"tf":1}},"df":33,"f":{"docs":{},"df":0,"x":{"docs":{"3":{"tf":1},"119":{"tf":1},"122":{"tf":1},"202":{"tf":1}},"df":4}},"/":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{"886":{"tf":1}},"df":1}}},"x":{"docs":{},"df":0,"_":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"_":{"docs":{},"df":0,"j":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"946":{"tf":1}},"df":1,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"_":{"docs":{},"df":0,"<":{"docs":{},"df":0,"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"954":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"954":{"tf":1}},"df":1}}}}}}}}}}}},".":{"docs":{},"df":0,"s":{"docs":{},"df":0,"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"j":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"946":{"tf":1.4142135623730951}},"df":1}}}}}}}}},"f":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"954":{"tf":1}},"df":1}}}}}}}}}}}}}}},"z":{"docs":{},"df":0,"z":{"docs":{"26":{"tf":1.4142135623730951},"72":{"tf":1},"73":{"tf":1},"74":{"tf":1},"258":{"tf":1.4142135623730951},"303":{"tf":1},"304":{"tf":1},"305":{"tf":1},"489":{"tf":1.4142135623730951},"534":{"tf":1},"535":{"tf":1},"536":{"tf":1},"703":{"tf":1.4142135623730951},"749":{"tf":1},"750":{"tf":1},"751":{"tf":1}},"df":16}},"r":{"docs":{"215":{"tf":1},"446":{"tf":1},"660":{"tf":1}},"df":3}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"55":{"tf":1.4142135623730951},"287":{"tf":1.4142135623730951},"518":{"tf":1.4142135623730951},"732":{"tf":1.4142135623730951}},"df":5}}},"m":{"docs":{},"df":0,"p":{"docs":{"128":{"tf":1.4142135623730951},"143":{"tf":1},"144":{"tf":1},"145":{"tf":1},"152":{"tf":1},"155":{"tf":1},"158":{"tf":1.7320508075688772},"168":{"tf":1},"182":{"tf":1.4142135623730951},"363":{"tf":1.4142135623730951},"378":{"tf":1},"379":{"tf":1},"380":{"tf":1},"387":{"tf":1},"390":{"tf":1},"393":{"tf":1.7320508075688772},"403":{"tf":1},"417":{"tf":1.4142135623730951},"581":{"tf":1.4142135623730951},"596":{"tf":1},"597":{"tf":1},"598":{"tf":1},"605":{"tf":1},"608":{"tf":1},"611":{"tf":1.7320508075688772},"621":{"tf":1},"635":{"tf":1.4142135623730951},"698":{"tf":1},"791":{"tf":1.4142135623730951},"806":{"tf":1},"815":{"tf":1},"818":{"tf":1},"821":{"tf":1.7320508075688772},"831":{"tf":1},"844":{"tf":1},"845":{"tf":1.4142135623730951}},"df":36}}},"y":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"215":{"tf":1.4142135623730951},"446":{"tf":1.4142135623730951},"660":{"tf":1.4142135623730951}},"df":3}}}}},"o":{"docs":{},"df":0,"b":{"docs":{"224":{"tf":1},"455":{"tf":1},"669":{"tf":1}},"df":3}},"c":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"936":{"tf":1},"938":{"tf":1.4142135623730951},"939":{"tf":1.4142135623730951},"940":{"tf":1},"954":{"tf":1}},"df":5}}}}}}}}}}}},"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951},"43":{"tf":1},"125":{"tf":1},"202":{"tf":1},"240":{"tf":2.23606797749979},"243":{"tf":1},"252":{"tf":1},"253":{"tf":2},"254":{"tf":1},"259":{"tf":1},"266":{"tf":1},"291":{"tf":1.4142135623730951},"294":{"tf":1},"295":{"tf":1},"299":{"tf":1},"303":{"tf":1.4142135623730951},"305":{"tf":1},"325":{"tf":1},"343":{"tf":1},"350":{"tf":1.4142135623730951},"351":{"tf":2.449489742783178},"354":{"tf":1.4142135623730951},"356":{"tf":1.7320508075688772},"357":{"tf":1},"360":{"tf":1},"363":{"tf":1},"399":{"tf":1.4142135623730951},"430":{"tf":1},"437":{"tf":1},"451":{"tf":1},"457":{"tf":1},"468":{"tf":1},"471":{"tf":1.4142135623730951},"617":{"tf":1}},"df":36,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2}}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"275":{"tf":1},"506":{"tf":1},"720":{"tf":1}},"df":3}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{"295":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"21":{"tf":1},"56":{"tf":1},"81":{"tf":1},"125":{"tf":1},"128":{"tf":1},"157":{"tf":1},"169":{"tf":1},"175":{"tf":1},"207":{"tf":1},"240":{"tf":1},"288":{"tf":1},"312":{"tf":1},"360":{"tf":1},"363":{"tf":1},"392":{"tf":1},"404":{"tf":1},"410":{"tf":1},"457":{"tf":1},"471":{"tf":1},"519":{"tf":1},"543":{"tf":1},"581":{"tf":1},"610":{"tf":1},"622":{"tf":1},"628":{"tf":1},"671":{"tf":1},"698":{"tf":1},"727":{"tf":1},"733":{"tf":1},"757":{"tf":1},"774":{"tf":1},"797":{"tf":1},"812":{"tf":1},"824":{"tf":1},"827":{"tf":1},"831":{"tf":1},"900":{"tf":1},"916":{"tf":1},"941":{"tf":1}},"df":40}},"'":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"16":{"tf":1},"34":{"tf":1},"248":{"tf":1},"266":{"tf":1},"479":{"tf":1},"497":{"tf":1},"693":{"tf":1},"711":{"tf":1}},"df":8}},"r":{"docs":{"21":{"tf":1},"54":{"tf":1},"253":{"tf":1},"286":{"tf":1},"484":{"tf":1},"517":{"tf":1},"731":{"tf":1}},"df":7},"v":{"docs":{"91":{"tf":1},"209":{"tf":1},"322":{"tf":1},"553":{"tf":1}},"df":4}},"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2}}}},"n":{"docs":{},"df":0,"t":{"docs":{"176":{"tf":1},"411":{"tf":1},"629":{"tf":1},"839":{"tf":1}},"df":4}}},"i":{"docs":{},"df":0,"n":{"docs":{"471":{"tf":1},"474":{"tf":1},"490":{"tf":1},"497":{"tf":1},"522":{"tf":1.4142135623730951},"556":{"tf":1},"574":{"tf":1},"581":{"tf":1},"617":{"tf":1},"648":{"tf":1},"665":{"tf":1},"671":{"tf":1},"682":{"tf":1}},"df":13,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951},"15":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"27":{"tf":1},"37":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"54":{"tf":1},"55":{"tf":1},"67":{"tf":1},"68":{"tf":1},"72":{"tf":1.4142135623730951},"74":{"tf":1},"77":{"tf":1},"81":{"tf":1.7320508075688772},"86":{"tf":1.4142135623730951},"112":{"tf":1.4142135623730951},"119":{"tf":1.4142135623730951},"120":{"tf":1},"176":{"tf":1},"182":{"tf":1},"210":{"tf":1},"226":{"tf":1.7320508075688772},"240":{"tf":1.7320508075688772},"247":{"tf":1.4142135623730951},"252":{"tf":1},"253":{"tf":1.4142135623730951},"259":{"tf":1},"269":{"tf":1.4142135623730951},"272":{"tf":1.4142135623730951},"282":{"tf":1},"286":{"tf":1},"287":{"tf":1},"296":{"tf":1},"298":{"tf":1},"303":{"tf":1.4142135623730951},"305":{"tf":1},"308":{"tf":1},"312":{"tf":1.7320508075688772},"317":{"tf":1.7320508075688772},"343":{"tf":1.4142135623730951},"354":{"tf":1.4142135623730951},"355":{"tf":1},"411":{"tf":1},"417":{"tf":1},"457":{"tf":1},"471":{"tf":1.4142135623730951},"478":{"tf":1.4142135623730951},"484":{"tf":1},"485":{"tf":1},"490":{"tf":1},"500":{"tf":1.4142135623730951},"503":{"tf":1.4142135623730951},"517":{"tf":1},"518":{"tf":1},"525":{"tf":1},"526":{"tf":2},"527":{"tf":1},"528":{"tf":1},"529":{"tf":1.4142135623730951},"530":{"tf":1},"534":{"tf":1.4142135623730951},"536":{"tf":1},"539":{"tf":1},"543":{"tf":1.7320508075688772},"548":{"tf":1.4142135623730951},"574":{"tf":1.4142135623730951},"629":{"tf":1},"635":{"tf":1},"671":{"tf":1},"692":{"tf":1.4142135623730951},"704":{"tf":1},"714":{"tf":1.4142135623730951},"717":{"tf":1.4142135623730951},"732":{"tf":1},"746":{"tf":1.7320508075688772},"747":{"tf":2},"749":{"tf":1},"751":{"tf":1},"754":{"tf":1.7320508075688772},"757":{"tf":1.4142135623730951},"781":{"tf":1},"824":{"tf":1},"839":{"tf":1},"845":{"tf":1},"927":{"tf":1},"936":{"tf":2},"937":{"tf":1},"938":{"tf":1},"939":{"tf":1.7320508075688772},"941":{"tf":1},"949":{"tf":1},"954":{"tf":1.4142135623730951}},"df":94}}}},"s":{"docs":{},"df":0,"h":{"docs":{"5":{"tf":1},"209":{"tf":1},"351":{"tf":1}},"df":3}},"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"26":{"tf":1},"56":{"tf":1},"72":{"tf":1},"77":{"tf":1},"122":{"tf":1},"177":{"tf":1},"188":{"tf":1},"189":{"tf":1},"195":{"tf":1},"199":{"tf":1},"203":{"tf":1},"204":{"tf":1},"205":{"tf":1},"206":{"tf":1},"209":{"tf":1},"210":{"tf":1.4142135623730951},"211":{"tf":1},"212":{"tf":1},"213":{"tf":1},"214":{"tf":1},"215":{"tf":1},"216":{"tf":1},"217":{"tf":1.7320508075688772},"226":{"tf":1},"232":{"tf":1},"258":{"tf":1},"288":{"tf":1},"303":{"tf":1},"308":{"tf":1},"357":{"tf":1},"412":{"tf":1},"423":{"tf":1},"424":{"tf":1},"430":{"tf":1},"434":{"tf":1},"438":{"tf":1},"439":{"tf":1},"440":{"tf":1},"442":{"tf":1},"443":{"tf":1},"444":{"tf":1},"445":{"tf":1},"446":{"tf":1},"447":{"tf":1},"448":{"tf":1.7320508075688772},"457":{"tf":1},"463":{"tf":1},"489":{"tf":1},"519":{"tf":1},"534":{"tf":1},"539":{"tf":1},"630":{"tf":1},"641":{"tf":1},"642":{"tf":1},"648":{"tf":1},"652":{"tf":1},"656":{"tf":1},"657":{"tf":1},"658":{"tf":1},"659":{"tf":1},"660":{"tf":1},"661":{"tf":1},"662":{"tf":1.7320508075688772},"671":{"tf":1},"677":{"tf":1},"717":{"tf":1},"728":{"tf":1},"733":{"tf":1},"739":{"tf":1},"855":{"tf":1.4142135623730951},"866":{"tf":1},"869":{"tf":1.4142135623730951},"881":{"tf":1},"891":{"tf":1},"892":{"tf":1},"893":{"tf":1},"901":{"tf":1},"902":{"tf":1},"933":{"tf":1}},"df":79}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"74":{"tf":1},"125":{"tf":1.4142135623730951},"138":{"tf":1},"143":{"tf":1},"144":{"tf":1},"158":{"tf":1},"172":{"tf":1},"183":{"tf":1},"210":{"tf":1},"211":{"tf":1},"233":{"tf":1},"305":{"tf":1},"350":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951},"373":{"tf":1},"378":{"tf":1},"379":{"tf":1},"393":{"tf":1},"407":{"tf":1},"418":{"tf":1},"442":{"tf":1},"464":{"tf":1},"536":{"tf":1},"591":{"tf":1},"596":{"tf":1},"597":{"tf":1},"611":{"tf":1},"625":{"tf":1},"636":{"tf":1},"656":{"tf":1},"678":{"tf":1},"751":{"tf":1},"788":{"tf":1.4142135623730951},"806":{"tf":1},"807":{"tf":1},"808":{"tf":1},"821":{"tf":1},"835":{"tf":1},"882":{"tf":1},"901":{"tf":1}},"df":40}}},"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"232":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"881":{"tf":1.4142135623730951}},"df":4}}}}}}}}}}}},"z":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"62":{"tf":1.7320508075688772},"65":{"tf":1.4142135623730951},"81":{"tf":1},"237":{"tf":1.7320508075688772},"253":{"tf":1},"294":{"tf":1.7320508075688772},"296":{"tf":2},"312":{"tf":1},"350":{"tf":1},"468":{"tf":1.7320508075688772},"525":{"tf":1.7320508075688772},"527":{"tf":1.4142135623730951},"543":{"tf":1},"682":{"tf":1.7320508075688772},"698":{"tf":1},"739":{"tf":1.7320508075688772},"742":{"tf":1},"757":{"tf":1}},"df":18}}}}},"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"90":{"tf":1},"125":{"tf":1},"140":{"tf":1},"210":{"tf":1.4142135623730951},"212":{"tf":1},"321":{"tf":1},"350":{"tf":1},"360":{"tf":1},"375":{"tf":1},"443":{"tf":1},"552":{"tf":1},"593":{"tf":1},"657":{"tf":1},"896":{"tf":1},"901":{"tf":1},"907":{"tf":1},"922":{"tf":1},"936":{"tf":1.4142135623730951},"939":{"tf":1},"941":{"tf":1},"949":{"tf":1}},"df":22}}},"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1},"66":{"tf":1.4142135623730951},"81":{"tf":1},"125":{"tf":1},"168":{"tf":1},"178":{"tf":1},"187":{"tf":1},"189":{"tf":1},"195":{"tf":1},"203":{"tf":1},"216":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"226":{"tf":1},"229":{"tf":1},"246":{"tf":1},"253":{"tf":1},"312":{"tf":1},"350":{"tf":1},"354":{"tf":1},"360":{"tf":1},"413":{"tf":1},"422":{"tf":1},"424":{"tf":1},"430":{"tf":1},"438":{"tf":1},"447":{"tf":1.4142135623730951},"455":{"tf":1.4142135623730951},"457":{"tf":1},"460":{"tf":1},"477":{"tf":1},"484":{"tf":1},"528":{"tf":1.4142135623730951},"543":{"tf":1},"621":{"tf":1},"631":{"tf":1},"640":{"tf":1},"642":{"tf":1},"648":{"tf":1},"661":{"tf":1.4142135623730951},"669":{"tf":1.4142135623730951},"671":{"tf":1},"674":{"tf":1},"691":{"tf":1},"698":{"tf":1},"717":{"tf":1},"740":{"tf":1.7320508075688772},"850":{"tf":1},"852":{"tf":1},"858":{"tf":1},"868":{"tf":1.4142135623730951},"876":{"tf":1.4142135623730951},"878":{"tf":1},"881":{"tf":1.4142135623730951},"890":{"tf":1},"911":{"tf":1},"915":{"tf":1},"916":{"tf":1}},"df":57}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"v":{"docs":{"158":{"tf":1},"183":{"tf":1},"393":{"tf":1},"418":{"tf":1},"611":{"tf":1},"636":{"tf":1}},"df":6}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{"192":{"tf":1},"350":{"tf":1},"427":{"tf":1},"645":{"tf":1}},"df":4}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"'":{"docs":{"43":{"tf":1},"275":{"tf":1},"506":{"tf":1},"720":{"tf":1}},"df":4},"e":{"docs":{},"df":0,"v":{"docs":{"894":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{"102":{"tf":1},"149":{"tf":1},"181":{"tf":1},"210":{"tf":1},"220":{"tf":1},"229":{"tf":1.4142135623730951},"305":{"tf":1},"333":{"tf":1},"384":{"tf":1},"416":{"tf":1},"451":{"tf":1},"460":{"tf":1.4142135623730951},"564":{"tf":1},"602":{"tf":1},"634":{"tf":1},"665":{"tf":1},"674":{"tf":1.4142135623730951},"771":{"tf":1},"844":{"tf":1},"845":{"tf":1},"847":{"tf":1},"872":{"tf":1},"881":{"tf":1.4142135623730951}},"df":23}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"217":{"tf":1.4142135623730951},"448":{"tf":1.4142135623730951},"662":{"tf":1.4142135623730951},"869":{"tf":1.4142135623730951}},"df":4}}}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"11":{"tf":1.4142135623730951},"43":{"tf":1},"50":{"tf":1},"78":{"tf":1},"97":{"tf":1.7320508075688772},"106":{"tf":1},"125":{"tf":1},"158":{"tf":1},"168":{"tf":1},"169":{"tf":1},"171":{"tf":1},"177":{"tf":1},"205":{"tf":1},"206":{"tf":1},"240":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"275":{"tf":1},"282":{"tf":1},"309":{"tf":1},"328":{"tf":1.7320508075688772},"337":{"tf":1},"360":{"tf":1},"393":{"tf":1},"403":{"tf":1},"404":{"tf":1},"406":{"tf":1},"412":{"tf":1},"440":{"tf":1},"471":{"tf":1.4142135623730951},"474":{"tf":1.4142135623730951},"506":{"tf":1},"513":{"tf":1},"540":{"tf":1},"559":{"tf":1.7320508075688772},"568":{"tf":1},"611":{"tf":1},"621":{"tf":1},"622":{"tf":1},"624":{"tf":1},"630":{"tf":1},"688":{"tf":1},"720":{"tf":1},"727":{"tf":1},"766":{"tf":1.4142135623730951},"775":{"tf":1},"821":{"tf":1},"831":{"tf":1},"832":{"tf":1},"834":{"tf":1},"840":{"tf":1},"841":{"tf":1},"845":{"tf":1},"858":{"tf":1.4142135623730951},"933":{"tf":1},"954":{"tf":1}},"df":55,"f":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{"3":{"tf":1},"8":{"tf":1},"240":{"tf":1},"471":{"tf":1},"685":{"tf":1},"890":{"tf":1},"891":{"tf":1},"939":{"tf":1}},"df":8}}}}},"l":{"docs":{},"df":0,"d":{"docs":{"54":{"tf":1},"286":{"tf":1},"517":{"tf":1},"731":{"tf":1}},"df":4}},"d":{"docs":{"168":{"tf":1.4142135623730951},"171":{"tf":1},"403":{"tf":1.4142135623730951},"406":{"tf":1},"621":{"tf":1.4142135623730951},"624":{"tf":1},"831":{"tf":1}},"df":7},"t":{"docs":{},"df":0,"h":{"docs":{"176":{"tf":1},"411":{"tf":1},"629":{"tf":1}},"df":3}}},"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"4":{"tf":1},"168":{"tf":1},"621":{"tf":1}},"df":3}}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"4":{"tf":1},"27":{"tf":1},"32":{"tf":1},"68":{"tf":1},"94":{"tf":1.4142135623730951},"116":{"tf":1},"125":{"tf":1},"192":{"tf":1},"211":{"tf":2.23606797749979},"212":{"tf":2},"214":{"tf":1},"216":{"tf":1.7320508075688772},"224":{"tf":1},"225":{"tf":1},"229":{"tf":1},"259":{"tf":1},"264":{"tf":1},"299":{"tf":1},"325":{"tf":1.4142135623730951},"347":{"tf":1},"360":{"tf":1},"427":{"tf":1},"442":{"tf":2.23606797749979},"443":{"tf":2},"445":{"tf":1},"447":{"tf":1.7320508075688772},"455":{"tf":1},"456":{"tf":1},"460":{"tf":1},"490":{"tf":1},"495":{"tf":1},"530":{"tf":1},"556":{"tf":1.4142135623730951},"578":{"tf":1},"645":{"tf":1},"656":{"tf":2.23606797749979},"657":{"tf":2},"659":{"tf":1},"661":{"tf":1.7320508075688772},"669":{"tf":1},"670":{"tf":1},"674":{"tf":1},"704":{"tf":1},"867":{"tf":1.4142135623730951},"868":{"tf":1.7320508075688772},"876":{"tf":1},"877":{"tf":1},"881":{"tf":1}},"df":49,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"214":{"tf":1},"445":{"tf":1},"659":{"tf":1},"867":{"tf":1}},"df":4}}}}}}}}}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"55":{"tf":1},"183":{"tf":1},"287":{"tf":1},"418":{"tf":1},"518":{"tf":1},"636":{"tf":1},"732":{"tf":1}},"df":7}}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"122":{"tf":1},"176":{"tf":1},"177":{"tf":1},"178":{"tf":1},"233":{"tf":1},"357":{"tf":1},"411":{"tf":1},"412":{"tf":1},"413":{"tf":1},"464":{"tf":1},"629":{"tf":1},"630":{"tf":1},"631":{"tf":1},"678":{"tf":1},"818":{"tf":1},"839":{"tf":1},"840":{"tf":1},"845":{"tf":1},"882":{"tf":1}},"df":19}}},"a":{"docs":{},"df":0,"p":{"docs":{"831":{"tf":1.4142135623730951},"834":{"tf":1}},"df":2}}},"a":{"docs":{},"df":0,"y":{"docs":{"4":{"tf":1},"38":{"tf":1},"47":{"tf":1},"51":{"tf":1.4142135623730951},"86":{"tf":1},"101":{"tf":1.4142135623730951},"105":{"tf":1},"109":{"tf":1},"116":{"tf":1},"119":{"tf":1},"131":{"tf":1},"140":{"tf":1},"143":{"tf":1},"161":{"tf":1},"168":{"tf":1},"177":{"tf":2},"184":{"tf":1},"270":{"tf":1},"279":{"tf":1},"283":{"tf":1.4142135623730951},"317":{"tf":1},"332":{"tf":1.4142135623730951},"336":{"tf":1},"340":{"tf":1},"347":{"tf":1},"350":{"tf":1.7320508075688772},"354":{"tf":1},"366":{"tf":1},"375":{"tf":1},"378":{"tf":1},"396":{"tf":1},"399":{"tf":1},"403":{"tf":1},"412":{"tf":2},"419":{"tf":1},"501":{"tf":1},"510":{"tf":1},"514":{"tf":1.4142135623730951},"548":{"tf":1},"563":{"tf":1.4142135623730951},"567":{"tf":1},"571":{"tf":1},"578":{"tf":1},"584":{"tf":1},"593":{"tf":1},"596":{"tf":1},"614":{"tf":1},"617":{"tf":1},"621":{"tf":1},"630":{"tf":2},"637":{"tf":1},"715":{"tf":1},"724":{"tf":1},"728":{"tf":1.4142135623730951},"754":{"tf":1},"770":{"tf":1.4142135623730951},"794":{"tf":1},"806":{"tf":1},"818":{"tf":1},"840":{"tf":1.4142135623730951},"845":{"tf":1},"847":{"tf":1},"891":{"tf":1.4142135623730951},"892":{"tf":1},"893":{"tf":1.4142135623730951},"912":{"tf":1}},"df":66},"r":{"docs":{},"df":0,"n":{"docs":{"14":{"tf":1},"149":{"tf":1},"211":{"tf":1},"246":{"tf":1},"384":{"tf":1},"442":{"tf":1},"477":{"tf":1},"602":{"tf":1},"656":{"tf":1},"691":{"tf":1},"812":{"tf":1},"946":{"tf":1.4142135623730951}},"df":12}},"n":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"55":{"tf":1.4142135623730951},"67":{"tf":1},"78":{"tf":1},"97":{"tf":1},"102":{"tf":1},"112":{"tf":1},"116":{"tf":1},"122":{"tf":1},"125":{"tf":1.7320508075688772},"131":{"tf":1},"149":{"tf":1},"155":{"tf":1},"158":{"tf":1},"161":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"176":{"tf":1.7320508075688772},"178":{"tf":1},"181":{"tf":1.4142135623730951},"182":{"tf":1.4142135623730951},"184":{"tf":1},"188":{"tf":1},"192":{"tf":1.4142135623730951},"225":{"tf":1},"229":{"tf":1},"231":{"tf":1},"240":{"tf":1},"275":{"tf":1},"287":{"tf":1.4142135623730951},"298":{"tf":1},"309":{"tf":1},"328":{"tf":1},"333":{"tf":1},"343":{"tf":1},"347":{"tf":1},"350":{"tf":1},"354":{"tf":1.7320508075688772},"357":{"tf":1},"360":{"tf":1.7320508075688772},"366":{"tf":1},"384":{"tf":1},"390":{"tf":1},"393":{"tf":1},"396":{"tf":1},"403":{"tf":1.4142135623730951},"404":{"tf":1.4142135623730951},"406":{"tf":1.4142135623730951},"411":{"tf":1.7320508075688772},"413":{"tf":1},"416":{"tf":1.4142135623730951},"417":{"tf":1.4142135623730951},"419":{"tf":1},"423":{"tf":1},"427":{"tf":1.4142135623730951},"456":{"tf":1},"460":{"tf":1},"462":{"tf":1},"471":{"tf":1},"506":{"tf":1},"518":{"tf":1.4142135623730951},"529":{"tf":1},"540":{"tf":1},"559":{"tf":1},"564":{"tf":1},"574":{"tf":1},"578":{"tf":1},"584":{"tf":1},"602":{"tf":1},"608":{"tf":1},"611":{"tf":1},"614":{"tf":1},"621":{"tf":1.4142135623730951},"622":{"tf":1.4142135623730951},"624":{"tf":1.4142135623730951},"629":{"tf":1.7320508075688772},"631":{"tf":1},"634":{"tf":1.4142135623730951},"635":{"tf":1.4142135623730951},"637":{"tf":1},"641":{"tf":1},"645":{"tf":1.4142135623730951},"670":{"tf":1},"674":{"tf":1},"676":{"tf":1},"691":{"tf":1},"698":{"tf":1},"720":{"tf":1},"732":{"tf":1.4142135623730951},"749":{"tf":1},"751":{"tf":1},"758":{"tf":1},"766":{"tf":1},"788":{"tf":1},"794":{"tf":1.4142135623730951},"797":{"tf":1},"800":{"tf":1},"821":{"tf":1.4142135623730951},"824":{"tf":1.4142135623730951},"832":{"tf":1},"844":{"tf":1},"845":{"tf":1.4142135623730951},"847":{"tf":1},"855":{"tf":1},"877":{"tf":1},"881":{"tf":1},"892":{"tf":1},"894":{"tf":1.4142135623730951},"896":{"tf":1},"901":{"tf":1},"907":{"tf":1.4142135623730951},"915":{"tf":2},"921":{"tf":1},"933":{"tf":1},"943":{"tf":1},"944":{"tf":1},"945":{"tf":1},"946":{"tf":1},"948":{"tf":1},"958":{"tf":1}},"df":121}},"i":{"docs":{},"df":0,"t":{"docs":{"47":{"tf":1},"66":{"tf":1.7320508075688772},"158":{"tf":1},"224":{"tf":1},"225":{"tf":1},"253":{"tf":1.4142135623730951},"279":{"tf":1},"393":{"tf":1},"455":{"tf":1},"456":{"tf":1},"484":{"tf":1},"510":{"tf":1},"528":{"tf":1.7320508075688772},"539":{"tf":1},"611":{"tf":1},"669":{"tf":1},"670":{"tf":1},"698":{"tf":1.7320508075688772},"724":{"tf":1},"747":{"tf":1},"876":{"tf":1},"877":{"tf":1},"916":{"tf":1},"939":{"tf":1.4142135623730951}},"df":24}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"181":{"tf":1},"416":{"tf":1},"634":{"tf":1},"844":{"tf":1.4142135623730951}},"df":4}}}},"w":{"docs":{},"df":0,"w":{"docs":{},"df":0,".":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"/":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"/":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,".":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"/":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"215":{"tf":1},"446":{"tf":1},"660":{"tf":1}},"df":3}}}}}}}}}}}}}}}}}}}}}}}}},"n":{"docs":{"38":{"tf":1},"270":{"tf":1},"501":{"tf":1},"715":{"tf":1}},"df":4,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":2.23606797749979},"8":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"471":{"tf":1.4142135623730951},"525":{"tf":1}},"df":6}},"u":{"docs":{},"df":0,"r":{"docs":{"207":{"tf":1}},"df":1}}},"m":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"20":{"tf":1},"68":{"tf":1},"73":{"tf":1.4142135623730951},"101":{"tf":1.4142135623730951},"104":{"tf":1},"109":{"tf":1.4142135623730951},"122":{"tf":3.3166247903554},"125":{"tf":4.242640687119285},"157":{"tf":1.4142135623730951},"168":{"tf":2},"169":{"tf":1},"171":{"tf":2.23606797749979},"187":{"tf":1},"188":{"tf":1.4142135623730951},"189":{"tf":1},"192":{"tf":1.4142135623730951},"213":{"tf":2},"215":{"tf":1},"224":{"tf":1},"229":{"tf":1},"231":{"tf":1.7320508075688772},"232":{"tf":1},"233":{"tf":1},"287":{"tf":1},"299":{"tf":1},"304":{"tf":1.4142135623730951},"332":{"tf":1.4142135623730951},"335":{"tf":1},"340":{"tf":1.4142135623730951},"357":{"tf":3.3166247903554},"360":{"tf":4.242640687119285},"392":{"tf":1.4142135623730951},"403":{"tf":2},"404":{"tf":1},"406":{"tf":2.23606797749979},"422":{"tf":1},"423":{"tf":1.4142135623730951},"424":{"tf":1},"427":{"tf":1.4142135623730951},"444":{"tf":2},"446":{"tf":1},"455":{"tf":1},"460":{"tf":1},"462":{"tf":1.7320508075688772},"463":{"tf":1},"464":{"tf":1},"483":{"tf":1},"518":{"tf":1},"530":{"tf":1},"535":{"tf":1.4142135623730951},"563":{"tf":1.4142135623730951},"566":{"tf":1},"571":{"tf":1.4142135623730951},"610":{"tf":1.4142135623730951},"621":{"tf":2},"622":{"tf":1},"624":{"tf":2.23606797749979},"640":{"tf":1},"641":{"tf":1.4142135623730951},"642":{"tf":1},"645":{"tf":1.4142135623730951},"658":{"tf":2},"660":{"tf":1},"669":{"tf":1},"674":{"tf":1},"676":{"tf":1.7320508075688772},"677":{"tf":1},"678":{"tf":1},"697":{"tf":1},"698":{"tf":1},"732":{"tf":1},"740":{"tf":1},"741":{"tf":1},"743":{"tf":1},"748":{"tf":1},"750":{"tf":1},"770":{"tf":1.4142135623730951},"773":{"tf":1},"778":{"tf":1.4142135623730951},"788":{"tf":1.4142135623730951},"806":{"tf":1},"824":{"tf":1.4142135623730951},"831":{"tf":1.7320508075688772},"832":{"tf":1.4142135623730951},"834":{"tf":2.23606797749979},"840":{"tf":1},"841":{"tf":1},"850":{"tf":1},"851":{"tf":1.4142135623730951},"852":{"tf":1.4142135623730951},"855":{"tf":1},"881":{"tf":2.449489742783178},"882":{"tf":1},"894":{"tf":1.4142135623730951},"895":{"tf":2},"899":{"tf":1.4142135623730951},"900":{"tf":1.4142135623730951},"901":{"tf":1.7320508075688772},"909":{"tf":1},"915":{"tf":1.7320508075688772},"944":{"tf":1},"945":{"tf":1.4142135623730951},"946":{"tf":1.7320508075688772},"948":{"tf":1.4142135623730951},"954":{"tf":1.7320508075688772},"960":{"tf":1},"961":{"tf":1}},"df":108}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"14":{"tf":1},"15":{"tf":1},"43":{"tf":1},"64":{"tf":1},"68":{"tf":1},"116":{"tf":1},"119":{"tf":1},"134":{"tf":1},"143":{"tf":1},"181":{"tf":1},"182":{"tf":1},"184":{"tf":1},"231":{"tf":1},"246":{"tf":1},"247":{"tf":1},"275":{"tf":1},"295":{"tf":1},"299":{"tf":1},"347":{"tf":1},"354":{"tf":1},"369":{"tf":1},"378":{"tf":1},"416":{"tf":1},"417":{"tf":1},"419":{"tf":1},"462":{"tf":1},"477":{"tf":1},"478":{"tf":1},"506":{"tf":1},"526":{"tf":1},"530":{"tf":1},"578":{"tf":1},"587":{"tf":1},"596":{"tf":1},"634":{"tf":1},"635":{"tf":1},"637":{"tf":1},"676":{"tf":1},"691":{"tf":1},"692":{"tf":1},"720":{"tf":1},"797":{"tf":1},"819":{"tf":1},"881":{"tf":1}},"df":44}}}},"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"4":{"tf":1},"20":{"tf":1},"21":{"tf":1},"43":{"tf":1},"55":{"tf":1},"62":{"tf":1},"64":{"tf":1},"82":{"tf":1},"105":{"tf":1},"122":{"tf":2.23606797749979},"131":{"tf":1},"169":{"tf":1},"171":{"tf":1.4142135623730951},"177":{"tf":1},"188":{"tf":1},"189":{"tf":1},"192":{"tf":2},"195":{"tf":2},"210":{"tf":1},"224":{"tf":1},"225":{"tf":1},"229":{"tf":1},"231":{"tf":1},"232":{"tf":1},"275":{"tf":1},"287":{"tf":1},"294":{"tf":1},"296":{"tf":1},"313":{"tf":1},"336":{"tf":1},"357":{"tf":2.23606797749979},"366":{"tf":1},"404":{"tf":1},"406":{"tf":1.4142135623730951},"412":{"tf":1},"423":{"tf":1},"424":{"tf":1},"427":{"tf":2},"430":{"tf":2},"455":{"tf":1},"456":{"tf":1},"460":{"tf":1},"462":{"tf":1},"463":{"tf":1},"483":{"tf":1},"506":{"tf":1},"518":{"tf":1},"525":{"tf":1},"526":{"tf":1},"544":{"tf":1},"567":{"tf":1},"584":{"tf":1},"622":{"tf":1},"624":{"tf":1.4142135623730951},"630":{"tf":1},"641":{"tf":1},"642":{"tf":1},"645":{"tf":2},"648":{"tf":2},"669":{"tf":1},"670":{"tf":1},"674":{"tf":1},"676":{"tf":1},"677":{"tf":1},"697":{"tf":1},"698":{"tf":1},"720":{"tf":1},"732":{"tf":1},"770":{"tf":1},"774":{"tf":1},"781":{"tf":1},"832":{"tf":1.7320508075688772},"834":{"tf":1},"839":{"tf":1},"840":{"tf":1},"845":{"tf":1},"855":{"tf":1.4142135623730951},"858":{"tf":2},"876":{"tf":1},"877":{"tf":1},"881":{"tf":1.7320508075688772},"912":{"tf":1},"932":{"tf":1},"941":{"tf":1},"946":{"tf":1}},"df":86}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1},"20":{"tf":1.4142135623730951},"195":{"tf":1},"252":{"tf":1.4142135623730951},"430":{"tf":1},"483":{"tf":1.4142135623730951},"648":{"tf":1},"742":{"tf":1},"746":{"tf":1},"773":{"tf":1},"858":{"tf":1},"911":{"tf":1},"915":{"tf":2.449489742783178}},"df":13}}}}}}},"g":{"docs":{"5":{"tf":1}},"df":1},"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"k":{"docs":{"14":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"477":{"tf":1.4142135623730951},"691":{"tf":1.4142135623730951}},"df":4}}}}},"x":{"docs":{},"df":0,"t":{"docs":{"27":{"tf":1.4142135623730951},"38":{"tf":1},"62":{"tf":1},"63":{"tf":1},"64":{"tf":1},"78":{"tf":1},"82":{"tf":1},"86":{"tf":1},"122":{"tf":1},"134":{"tf":1},"138":{"tf":1},"140":{"tf":1.4142135623730951},"144":{"tf":1},"145":{"tf":1},"151":{"tf":1},"169":{"tf":1},"170":{"tf":1},"175":{"tf":1},"181":{"tf":1.4142135623730951},"182":{"tf":1},"187":{"tf":1},"188":{"tf":1},"210":{"tf":1},"231":{"tf":1},"232":{"tf":1.4142135623730951},"253":{"tf":1},"259":{"tf":1.4142135623730951},"270":{"tf":1},"294":{"tf":1},"296":{"tf":1},"309":{"tf":1},"313":{"tf":1},"317":{"tf":1},"357":{"tf":1},"369":{"tf":1},"373":{"tf":1},"375":{"tf":1.4142135623730951},"379":{"tf":1},"380":{"tf":1},"386":{"tf":1},"404":{"tf":1},"405":{"tf":1},"410":{"tf":1},"416":{"tf":1.4142135623730951},"417":{"tf":1},"422":{"tf":1},"423":{"tf":1},"462":{"tf":1},"463":{"tf":1.4142135623730951},"490":{"tf":1.4142135623730951},"501":{"tf":1},"525":{"tf":1},"526":{"tf":1},"540":{"tf":1},"544":{"tf":1},"548":{"tf":1},"587":{"tf":1},"591":{"tf":1},"593":{"tf":1.4142135623730951},"597":{"tf":1},"598":{"tf":1},"604":{"tf":1},"622":{"tf":1},"623":{"tf":1},"628":{"tf":1},"634":{"tf":1.4142135623730951},"635":{"tf":1},"640":{"tf":1},"641":{"tf":1},"676":{"tf":1},"677":{"tf":1.4142135623730951},"698":{"tf":1},"702":{"tf":1},"704":{"tf":1.4142135623730951},"715":{"tf":1},"740":{"tf":1},"749":{"tf":1},"757":{"tf":1},"758":{"tf":1},"797":{"tf":1},"801":{"tf":1},"802":{"tf":1},"803":{"tf":1.4142135623730951},"806":{"tf":1},"807":{"tf":1},"812":{"tf":1},"832":{"tf":1},"833":{"tf":1},"838":{"tf":1},"844":{"tf":1},"845":{"tf":1},"850":{"tf":1},"855":{"tf":1},"881":{"tf":1.7320508075688772},"893":{"tf":1},"895":{"tf":1},"896":{"tf":1},"907":{"tf":1},"909":{"tf":1},"912":{"tf":1.4142135623730951},"915":{"tf":1},"929":{"tf":1},"937":{"tf":1},"944":{"tf":1},"954":{"tf":1}},"df":105}},"w":{"docs":{"62":{"tf":1.4142135623730951},"169":{"tf":1},"177":{"tf":1},"182":{"tf":1},"195":{"tf":1},"232":{"tf":1.4142135623730951},"233":{"tf":1.4142135623730951},"234":{"tf":1},"294":{"tf":1.4142135623730951},"354":{"tf":1},"404":{"tf":1},"412":{"tf":1},"417":{"tf":1},"430":{"tf":1},"463":{"tf":1.4142135623730951},"464":{"tf":1.4142135623730951},"465":{"tf":1},"525":{"tf":1.4142135623730951},"622":{"tf":1},"630":{"tf":1},"635":{"tf":1},"648":{"tf":1},"677":{"tf":1.4142135623730951},"678":{"tf":1.4142135623730951},"679":{"tf":1},"739":{"tf":1.4142135623730951},"840":{"tf":1},"845":{"tf":1},"858":{"tf":1},"881":{"tf":1.4142135623730951},"882":{"tf":1.4142135623730951},"883":{"tf":1},"892":{"tf":1},"895":{"tf":1},"915":{"tf":2},"936":{"tf":1},"945":{"tf":2},"946":{"tf":1},"954":{"tf":1}},"df":39,"l":{"docs":{},"df":0,"i":{"docs":{"77":{"tf":1},"90":{"tf":1},"101":{"tf":1},"182":{"tf":1},"195":{"tf":1},"308":{"tf":1},"321":{"tf":1},"332":{"tf":1},"417":{"tf":1},"430":{"tf":1},"539":{"tf":1},"552":{"tf":1},"563":{"tf":1},"635":{"tf":1},"648":{"tf":1},"770":{"tf":1},"831":{"tf":1},"845":{"tf":1},"915":{"tf":1.7320508075688772},"952":{"tf":1}},"df":20}}},"s":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"226":{"tf":1.4142135623730951},"354":{"tf":1},"360":{"tf":1},"457":{"tf":1.4142135623730951},"671":{"tf":1.4142135623730951},"893":{"tf":1},"902":{"tf":1.4142135623730951},"918":{"tf":1}},"df":9}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"199":{"tf":1},"434":{"tf":1},"652":{"tf":1},"948":{"tf":1}},"df":4}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"232":{"tf":1},"463":{"tf":1},"677":{"tf":1},"881":{"tf":1}},"df":4}}}},"o":{"docs":{},"df":0,"w":{"docs":{"4":{"tf":1},"19":{"tf":1},"25":{"tf":1},"27":{"tf":1},"46":{"tf":1},"67":{"tf":1},"71":{"tf":1},"72":{"tf":1},"74":{"tf":1.4142135623730951},"82":{"tf":1},"86":{"tf":1},"106":{"tf":1},"122":{"tf":1},"125":{"tf":1.4142135623730951},"134":{"tf":1},"137":{"tf":1.4142135623730951},"144":{"tf":1.4142135623730951},"157":{"tf":1},"169":{"tf":1},"178":{"tf":1},"182":{"tf":1},"183":{"tf":1},"192":{"tf":1},"202":{"tf":1},"210":{"tf":1},"232":{"tf":1},"237":{"tf":1.4142135623730951},"251":{"tf":1},"257":{"tf":1},"259":{"tf":1},"278":{"tf":1},"298":{"tf":1},"302":{"tf":1},"303":{"tf":1},"305":{"tf":1.4142135623730951},"313":{"tf":1},"314":{"tf":1},"317":{"tf":1},"337":{"tf":1},"357":{"tf":1},"360":{"tf":1.4142135623730951},"369":{"tf":1},"372":{"tf":1.4142135623730951},"379":{"tf":1.4142135623730951},"392":{"tf":1},"404":{"tf":1},"413":{"tf":1},"417":{"tf":1},"418":{"tf":1},"427":{"tf":1},"437":{"tf":1},"463":{"tf":1},"468":{"tf":1},"482":{"tf":1},"488":{"tf":1},"490":{"tf":1},"509":{"tf":1},"529":{"tf":1},"533":{"tf":1},"534":{"tf":1},"536":{"tf":1.4142135623730951},"539":{"tf":1},"544":{"tf":1},"548":{"tf":1},"568":{"tf":1},"587":{"tf":1},"590":{"tf":1.4142135623730951},"597":{"tf":1.4142135623730951},"610":{"tf":1},"622":{"tf":1},"631":{"tf":1},"635":{"tf":1},"636":{"tf":1},"645":{"tf":1},"655":{"tf":1},"677":{"tf":1},"682":{"tf":1},"723":{"tf":1},"727":{"tf":1},"743":{"tf":1},"748":{"tf":1},"749":{"tf":1},"751":{"tf":1},"774":{"tf":1},"775":{"tf":1.4142135623730951},"784":{"tf":1},"794":{"tf":1},"800":{"tf":1.4142135623730951},"807":{"tf":1},"812":{"tf":1},"820":{"tf":1.4142135623730951},"824":{"tf":1},"840":{"tf":1},"845":{"tf":1},"846":{"tf":1},"865":{"tf":1},"881":{"tf":1},"895":{"tf":1.4142135623730951},"896":{"tf":1},"898":{"tf":1},"900":{"tf":1},"908":{"tf":1},"909":{"tf":1},"910":{"tf":1},"911":{"tf":1},"912":{"tf":1},"915":{"tf":1.4142135623730951},"917":{"tf":1},"921":{"tf":1},"925":{"tf":1.4142135623730951},"926":{"tf":1},"936":{"tf":1.4142135623730951},"939":{"tf":1},"940":{"tf":1},"946":{"tf":1},"948":{"tf":1},"949":{"tf":1},"951":{"tf":1},"954":{"tf":1.4142135623730951},"956":{"tf":1},"958":{"tf":1},"960":{"tf":1}},"df":122},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1}},"df":1}},"e":{"docs":{"21":{"tf":1},"134":{"tf":1},"210":{"tf":1},"215":{"tf":1},"225":{"tf":1},"369":{"tf":1},"446":{"tf":1},"456":{"tf":1},"587":{"tf":1},"660":{"tf":1},"670":{"tf":1},"698":{"tf":1},"741":{"tf":1},"803":{"tf":1},"877":{"tf":1},"937":{"tf":1}},"df":16},"i":{"docs":{},"df":0,"c":{"docs":{"38":{"tf":1},"77":{"tf":1},"178":{"tf":1},"182":{"tf":1},"199":{"tf":1},"270":{"tf":1},"308":{"tf":1},"356":{"tf":1},"413":{"tf":1},"417":{"tf":1},"434":{"tf":1},"501":{"tf":1},"539":{"tf":1},"631":{"tf":1},"635":{"tf":1},"652":{"tf":1},"715":{"tf":1},"791":{"tf":1},"800":{"tf":1},"862":{"tf":1}},"df":20}},"h":{"docs":{"350":{"tf":1}},"df":1},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"876":{"tf":1},"877":{"tf":1.4142135623730951},"878":{"tf":1.4142135623730951}},"df":3}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{"15":{"tf":2},"16":{"tf":1.4142135623730951},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":2},"26":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1},"38":{"tf":2.6457513110645907},"39":{"tf":1.7320508075688772},"40":{"tf":1},"43":{"tf":1.4142135623730951},"46":{"tf":1},"50":{"tf":1.4142135623730951},"51":{"tf":1},"66":{"tf":1.4142135623730951},"67":{"tf":1},"73":{"tf":1.4142135623730951},"74":{"tf":1},"77":{"tf":1.4142135623730951},"78":{"tf":1},"81":{"tf":3.4641016151377544},"82":{"tf":3.4641016151377544},"86":{"tf":2.449489742783178},"90":{"tf":1},"101":{"tf":2.23606797749979},"102":{"tf":2},"103":{"tf":1},"105":{"tf":1.4142135623730951},"106":{"tf":1},"109":{"tf":2.449489742783178},"112":{"tf":1},"115":{"tf":1},"116":{"tf":2.6457513110645907},"119":{"tf":2.6457513110645907},"120":{"tf":1},"121":{"tf":1},"122":{"tf":2},"125":{"tf":1.7320508075688772},"128":{"tf":2},"131":{"tf":1.4142135623730951},"132":{"tf":1},"134":{"tf":2.23606797749979},"137":{"tf":2.23606797749979},"138":{"tf":2.449489742783178},"139":{"tf":2},"140":{"tf":3.1622776601683795},"143":{"tf":1.7320508075688772},"144":{"tf":2.23606797749979},"145":{"tf":1.7320508075688772},"146":{"tf":1},"150":{"tf":1.4142135623730951},"151":{"tf":1},"155":{"tf":1.7320508075688772},"156":{"tf":1.4142135623730951},"157":{"tf":1.7320508075688772},"161":{"tf":1},"168":{"tf":2.449489742783178},"170":{"tf":1.4142135623730951},"171":{"tf":2},"172":{"tf":1},"175":{"tf":1.4142135623730951},"176":{"tf":1.7320508075688772},"177":{"tf":2.23606797749979},"178":{"tf":2.449489742783178},"181":{"tf":1},"182":{"tf":2.8284271247461903},"183":{"tf":1},"184":{"tf":2.23606797749979},"187":{"tf":4},"188":{"tf":1.7320508075688772},"189":{"tf":2.6457513110645907},"192":{"tf":2.23606797749979},"195":{"tf":2.23606797749979},"207":{"tf":1},"209":{"tf":2},"210":{"tf":1.4142135623730951},"215":{"tf":1},"217":{"tf":1},"220":{"tf":2},"223":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1},"226":{"tf":3.1622776601683795},"229":{"tf":3.1622776601683795},"230":{"tf":2.449489742783178},"231":{"tf":3.3166247903554},"232":{"tf":5.291502622129181},"233":{"tf":1},"234":{"tf":1.4142135623730951},"247":{"tf":2},"248":{"tf":1.4142135623730951},"251":{"tf":1.4142135623730951},"252":{"tf":1.7320508075688772},"253":{"tf":1.7320508075688772},"258":{"tf":1.4142135623730951},"259":{"tf":1.7320508075688772},"264":{"tf":1.4142135623730951},"265":{"tf":1},"270":{"tf":2.6457513110645907},"271":{"tf":1.7320508075688772},"272":{"tf":1},"275":{"tf":1.4142135623730951},"278":{"tf":1},"282":{"tf":1.4142135623730951},"283":{"tf":1},"298":{"tf":1},"304":{"tf":1.4142135623730951},"305":{"tf":1},"308":{"tf":1.4142135623730951},"309":{"tf":1},"312":{"tf":3.4641016151377544},"313":{"tf":3.4641016151377544},"317":{"tf":2.449489742783178},"321":{"tf":1},"332":{"tf":2.23606797749979},"333":{"tf":2},"334":{"tf":1},"336":{"tf":1.4142135623730951},"337":{"tf":1},"340":{"tf":2.449489742783178},"343":{"tf":1},"346":{"tf":1},"347":{"tf":2.6457513110645907},"350":{"tf":1},"351":{"tf":1},"354":{"tf":2.6457513110645907},"355":{"tf":1},"356":{"tf":1},"357":{"tf":2},"360":{"tf":1.7320508075688772},"363":{"tf":2},"366":{"tf":1.4142135623730951},"367":{"tf":1},"369":{"tf":2.23606797749979},"372":{"tf":2.23606797749979},"373":{"tf":2.449489742783178},"374":{"tf":2},"375":{"tf":3.1622776601683795},"378":{"tf":1.7320508075688772},"379":{"tf":2.23606797749979},"380":{"tf":1.7320508075688772},"381":{"tf":1},"385":{"tf":1.4142135623730951},"386":{"tf":1},"390":{"tf":1.7320508075688772},"391":{"tf":1.4142135623730951},"392":{"tf":1.7320508075688772},"396":{"tf":1},"403":{"tf":2.449489742783178},"405":{"tf":1.4142135623730951},"406":{"tf":2},"407":{"tf":1},"410":{"tf":1.4142135623730951},"411":{"tf":1.7320508075688772},"412":{"tf":2.23606797749979},"413":{"tf":2.449489742783178},"416":{"tf":1},"417":{"tf":2.8284271247461903},"418":{"tf":1},"419":{"tf":2.23606797749979},"422":{"tf":4},"423":{"tf":1.7320508075688772},"424":{"tf":2.6457513110645907},"427":{"tf":2.23606797749979},"430":{"tf":2.23606797749979},"446":{"tf":1},"448":{"tf":1},"451":{"tf":2},"454":{"tf":1.4142135623730951},"455":{"tf":1.7320508075688772},"456":{"tf":1},"457":{"tf":3.7416573867739413},"460":{"tf":3.1622776601683795},"461":{"tf":2.449489742783178},"462":{"tf":3.3166247903554},"463":{"tf":5.291502622129181},"464":{"tf":1},"465":{"tf":1.4142135623730951},"478":{"tf":2},"479":{"tf":1.4142135623730951},"482":{"tf":1.4142135623730951},"483":{"tf":1.7320508075688772},"484":{"tf":2},"489":{"tf":1.4142135623730951},"490":{"tf":1.7320508075688772},"495":{"tf":1.4142135623730951},"496":{"tf":1},"501":{"tf":2.6457513110645907},"502":{"tf":1.7320508075688772},"503":{"tf":1},"506":{"tf":1.4142135623730951},"509":{"tf":1},"513":{"tf":1.4142135623730951},"514":{"tf":1},"528":{"tf":1.4142135623730951},"529":{"tf":1},"535":{"tf":1.4142135623730951},"536":{"tf":1},"539":{"tf":1.4142135623730951},"540":{"tf":1},"543":{"tf":3.4641016151377544},"544":{"tf":3.4641016151377544},"548":{"tf":2.449489742783178},"552":{"tf":1},"563":{"tf":2.23606797749979},"564":{"tf":2},"565":{"tf":1},"567":{"tf":1.4142135623730951},"568":{"tf":1},"571":{"tf":2.449489742783178},"574":{"tf":1},"577":{"tf":1},"578":{"tf":2.6457513110645907},"581":{"tf":2},"584":{"tf":1.4142135623730951},"585":{"tf":1},"587":{"tf":2.23606797749979},"590":{"tf":2.23606797749979},"591":{"tf":2.449489742783178},"592":{"tf":2},"593":{"tf":3.1622776601683795},"596":{"tf":1.7320508075688772},"597":{"tf":2.23606797749979},"598":{"tf":1.7320508075688772},"599":{"tf":1},"603":{"tf":1.4142135623730951},"604":{"tf":1},"608":{"tf":1.7320508075688772},"609":{"tf":1.4142135623730951},"610":{"tf":1.7320508075688772},"614":{"tf":1},"621":{"tf":2.449489742783178},"623":{"tf":1.4142135623730951},"624":{"tf":2},"625":{"tf":1},"628":{"tf":1.4142135623730951},"629":{"tf":1.7320508075688772},"630":{"tf":2.23606797749979},"631":{"tf":2.449489742783178},"634":{"tf":1},"635":{"tf":2.8284271247461903},"636":{"tf":1},"637":{"tf":2.23606797749979},"640":{"tf":4},"641":{"tf":1.7320508075688772},"642":{"tf":2.6457513110645907},"645":{"tf":2.23606797749979},"648":{"tf":2.23606797749979},"660":{"tf":1},"662":{"tf":1},"665":{"tf":2},"668":{"tf":1.4142135623730951},"669":{"tf":1.7320508075688772},"670":{"tf":1},"671":{"tf":3.7416573867739413},"674":{"tf":3.1622776601683795},"675":{"tf":2.449489742783178},"676":{"tf":3.3166247903554},"677":{"tf":5.291502622129181},"678":{"tf":1},"679":{"tf":1.4142135623730951},"692":{"tf":2.23606797749979},"693":{"tf":1.4142135623730951},"696":{"tf":1.4142135623730951},"697":{"tf":1.4142135623730951},"698":{"tf":2.8284271247461903},"703":{"tf":1.7320508075688772},"704":{"tf":1.7320508075688772},"708":{"tf":1},"709":{"tf":1},"710":{"tf":1},"715":{"tf":2.6457513110645907},"716":{"tf":1.4142135623730951},"717":{"tf":1.4142135623730951},"720":{"tf":1.4142135623730951},"723":{"tf":1},"728":{"tf":1.4142135623730951},"743":{"tf":1},"748":{"tf":1},"749":{"tf":1},"750":{"tf":1},"754":{"tf":1},"757":{"tf":3.1622776601683795},"758":{"tf":3},"759":{"tf":1},"760":{"tf":1},"770":{"tf":2},"771":{"tf":2.23606797749979},"772":{"tf":1},"774":{"tf":2.23606797749979},"778":{"tf":2.449489742783178},"781":{"tf":1},"784":{"tf":1},"788":{"tf":1.4142135623730951},"791":{"tf":2},"794":{"tf":1},"795":{"tf":1},"797":{"tf":2.23606797749979},"800":{"tf":2.23606797749979},"801":{"tf":2.23606797749979},"802":{"tf":1.4142135623730951},"803":{"tf":3},"806":{"tf":2},"807":{"tf":2},"808":{"tf":1.4142135623730951},"813":{"tf":1.4142135623730951},"814":{"tf":1},"818":{"tf":2.23606797749979},"819":{"tf":1.4142135623730951},"820":{"tf":1.7320508075688772},"824":{"tf":1},"831":{"tf":2.23606797749979},"832":{"tf":1.7320508075688772},"833":{"tf":1.4142135623730951},"834":{"tf":2},"835":{"tf":1},"838":{"tf":1},"839":{"tf":1.7320508075688772},"840":{"tf":1.7320508075688772},"841":{"tf":2},"845":{"tf":2.449489742783178},"846":{"tf":1},"847":{"tf":2},"850":{"tf":3},"851":{"tf":1.7320508075688772},"852":{"tf":2.6457513110645907},"855":{"tf":2},"858":{"tf":2.449489742783178},"869":{"tf":1},"872":{"tf":2},"875":{"tf":1.4142135623730951},"876":{"tf":1.7320508075688772},"877":{"tf":1},"878":{"tf":3.4641016151377544},"881":{"tf":7.211102550927978},"882":{"tf":1},"883":{"tf":1.4142135623730951},"891":{"tf":2},"892":{"tf":2},"894":{"tf":3.1622776601683795},"896":{"tf":2},"897":{"tf":1},"898":{"tf":1},"899":{"tf":1},"902":{"tf":1},"906":{"tf":1},"907":{"tf":1},"909":{"tf":2.23606797749979},"911":{"tf":2.23606797749979},"912":{"tf":1.7320508075688772},"913":{"tf":1},"915":{"tf":1.4142135623730951},"916":{"tf":1},"921":{"tf":2.449489742783178},"924":{"tf":1},"925":{"tf":2.23606797749979},"928":{"tf":1},"939":{"tf":1},"946":{"tf":2},"948":{"tf":1},"951":{"tf":1},"954":{"tf":1}},"df":364,"'":{"docs":{"850":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"140":{"tf":1},"210":{"tf":1},"375":{"tf":1},"593":{"tf":1},"927":{"tf":1},"936":{"tf":1},"955":{"tf":1}},"df":7}}}},"n":{"docs":{"213":{"tf":1},"444":{"tf":1},"658":{"tf":1}},"df":3,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"171":{"tf":1},"406":{"tf":1},"624":{"tf":1}},"df":3}}}},"e":{"docs":{"357":{"tf":1},"698":{"tf":1}},"df":2}}},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"27":{"tf":1},"81":{"tf":1},"94":{"tf":1},"122":{"tf":1},"134":{"tf":1},"171":{"tf":1},"189":{"tf":1},"195":{"tf":1},"202":{"tf":1},"204":{"tf":1},"206":{"tf":1},"208":{"tf":2},"212":{"tf":1},"229":{"tf":1.7320508075688772},"231":{"tf":1.4142135623730951},"232":{"tf":1},"259":{"tf":1},"312":{"tf":1},"325":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1},"369":{"tf":1},"406":{"tf":1},"424":{"tf":1},"430":{"tf":1},"437":{"tf":1},"439":{"tf":1},"441":{"tf":2},"443":{"tf":1},"460":{"tf":1.7320508075688772},"462":{"tf":1.4142135623730951},"463":{"tf":1},"490":{"tf":1},"543":{"tf":1},"556":{"tf":1},"587":{"tf":1},"624":{"tf":1},"642":{"tf":1},"648":{"tf":1},"655":{"tf":1},"657":{"tf":1},"674":{"tf":1.7320508075688772},"676":{"tf":1.4142135623730951},"677":{"tf":1},"704":{"tf":1},"717":{"tf":1},"757":{"tf":1},"763":{"tf":1},"797":{"tf":1},"852":{"tf":1},"858":{"tf":1},"881":{"tf":2.449489742783178}},"df":52}}},"e":{"docs":{},"df":0,"r":{"docs":{"115":{"tf":1},"116":{"tf":2.449489742783178},"125":{"tf":1},"178":{"tf":1},"346":{"tf":1},"347":{"tf":2.449489742783178},"360":{"tf":1},"413":{"tf":1},"577":{"tf":1},"578":{"tf":2.449489742783178},"631":{"tf":1},"784":{"tf":1},"785":{"tf":1.7320508075688772}},"df":13}}},"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"907":{"tf":1}},"df":1}}}}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"3":{"tf":1.7320508075688772},"933":{"tf":1}},"df":2}}}},"n":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1.4142135623730951},"264":{"tf":1.4142135623730951},"495":{"tf":1.4142135623730951},"709":{"tf":1},"890":{"tf":1.7320508075688772}},"df":5}},"b":{"docs":{"824":{"tf":1}},"df":1}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"26":{"tf":1},"27":{"tf":1},"81":{"tf":1},"215":{"tf":1},"226":{"tf":1.7320508075688772},"258":{"tf":1},"259":{"tf":1},"312":{"tf":1},"446":{"tf":1},"457":{"tf":1.7320508075688772},"489":{"tf":1},"490":{"tf":1},"543":{"tf":1},"660":{"tf":1},"671":{"tf":1.7320508075688772},"703":{"tf":1},"704":{"tf":1},"757":{"tf":1},"763":{"tf":1},"892":{"tf":1},"915":{"tf":1}},"df":21,":":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"226":{"tf":1},"457":{"tf":1},"671":{"tf":1}},"df":3}}}}}}}}},"w":{"docs":{"763":{"tf":1}},"df":1}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"232":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"881":{"tf":1.4142135623730951},"948":{"tf":1}},"df":5,"l":{"docs":{},"df":0,"i":{"docs":{"788":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"43":{"tf":1},"109":{"tf":1},"119":{"tf":1},"122":{"tf":1},"125":{"tf":1},"211":{"tf":1},"275":{"tf":1},"340":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1},"360":{"tf":1},"442":{"tf":1},"506":{"tf":1},"571":{"tf":1},"656":{"tf":1},"720":{"tf":1},"770":{"tf":1},"778":{"tf":1}},"df":19,"n":{"docs":{"26":{"tf":1},"122":{"tf":1},"125":{"tf":1},"140":{"tf":1},"203":{"tf":1},"205":{"tf":1.4142135623730951},"208":{"tf":1},"209":{"tf":1},"211":{"tf":1.7320508075688772},"212":{"tf":1.4142135623730951},"213":{"tf":2},"214":{"tf":2},"215":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"229":{"tf":1.4142135623730951},"258":{"tf":1},"295":{"tf":1},"357":{"tf":1},"360":{"tf":1},"375":{"tf":1},"438":{"tf":1},"440":{"tf":1.4142135623730951},"441":{"tf":1},"442":{"tf":1.7320508075688772},"443":{"tf":1.4142135623730951},"444":{"tf":2},"445":{"tf":2},"446":{"tf":1.4142135623730951},"448":{"tf":1.4142135623730951},"460":{"tf":1.4142135623730951},"489":{"tf":1},"593":{"tf":1},"656":{"tf":1.7320508075688772},"657":{"tf":1.4142135623730951},"658":{"tf":2},"659":{"tf":2},"660":{"tf":1.4142135623730951},"662":{"tf":1.4142135623730951},"674":{"tf":1.4142135623730951},"698":{"tf":1},"703":{"tf":1},"881":{"tf":1.4142135623730951}},"df":42}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"4":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":2},"56":{"tf":1},"62":{"tf":1},"66":{"tf":1},"67":{"tf":1},"81":{"tf":1},"119":{"tf":1.4142135623730951},"122":{"tf":1},"203":{"tf":1},"205":{"tf":1},"210":{"tf":1},"230":{"tf":1},"237":{"tf":1},"253":{"tf":1},"286":{"tf":1.4142135623730951},"287":{"tf":2},"288":{"tf":1},"294":{"tf":1},"297":{"tf":1},"298":{"tf":1},"312":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1.4142135623730951},"438":{"tf":1},"440":{"tf":1},"461":{"tf":1},"468":{"tf":1},"517":{"tf":1.4142135623730951},"518":{"tf":2},"519":{"tf":1},"525":{"tf":1},"528":{"tf":1},"529":{"tf":1},"543":{"tf":1},"675":{"tf":1},"682":{"tf":1},"717":{"tf":1},"731":{"tf":1.4142135623730951},"732":{"tf":2},"733":{"tf":1},"739":{"tf":1},"742":{"tf":1},"743":{"tf":1},"757":{"tf":1},"839":{"tf":1},"881":{"tf":1},"906":{"tf":1},"933":{"tf":1},"936":{"tf":1.4142135623730951}},"df":52}}},"t":{"docs":{"4":{"tf":1},"14":{"tf":1},"21":{"tf":1},"43":{"tf":1.4142135623730951},"105":{"tf":1},"122":{"tf":1},"125":{"tf":1},"140":{"tf":1},"182":{"tf":1},"184":{"tf":1},"192":{"tf":1},"215":{"tf":1},"234":{"tf":1},"246":{"tf":1},"275":{"tf":1.4142135623730951},"298":{"tf":1},"336":{"tf":1},"351":{"tf":1},"357":{"tf":1},"360":{"tf":1},"375":{"tf":1},"417":{"tf":1},"419":{"tf":1},"427":{"tf":1},"446":{"tf":1},"465":{"tf":1},"477":{"tf":1},"484":{"tf":1},"506":{"tf":1.4142135623730951},"567":{"tf":1},"593":{"tf":1},"635":{"tf":1},"637":{"tf":1},"645":{"tf":1},"660":{"tf":1},"679":{"tf":1},"691":{"tf":1},"720":{"tf":1.4142135623730951},"801":{"tf":1},"845":{"tf":1},"855":{"tf":1},"883":{"tf":1},"886":{"tf":1},"898":{"tf":1},"900":{"tf":1},"911":{"tf":1},"932":{"tf":1},"939":{"tf":1.4142135623730951},"946":{"tf":1},"956":{"tf":1},"960":{"tf":1}},"df":51,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"204":{"tf":1},"206":{"tf":1},"439":{"tf":1},"881":{"tf":1.4142135623730951}},"df":4}}}}}}}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"208":{"tf":1},"231":{"tf":1.4142135623730951},"441":{"tf":1},"462":{"tf":1.4142135623730951},"676":{"tf":1.4142135623730951}},"df":5}}}}}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"208":{"tf":1},"441":{"tf":1}},"df":2}}}}}}}}}}},"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"212":{"tf":1},"443":{"tf":1},"657":{"tf":1}},"df":3}}}}}}}}}}}},"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"213":{"tf":1},"444":{"tf":1},"658":{"tf":1}},"df":3}}}}}}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"213":{"tf":1},"444":{"tf":1},"658":{"tf":1}},"df":3}}}}}}}}}}}}}}},"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"214":{"tf":1},"445":{"tf":1},"659":{"tf":1},"867":{"tf":1}},"df":4}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"214":{"tf":1},"445":{"tf":1},"659":{"tf":1},"867":{"tf":1}},"df":4}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"122":{"tf":1.7320508075688772},"187":{"tf":1},"357":{"tf":1.7320508075688772},"422":{"tf":1},"640":{"tf":1},"850":{"tf":1}},"df":6}}}}}}},"u":{"docs":{},"df":0,"i":{"docs":{"781":{"tf":1.4142135623730951}},"df":1,"d":{"docs":{"4":{"tf":1}},"df":1}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{"905":{"tf":1},"921":{"tf":1}},"df":2}}}}}}},"o":{"docs":{"8":{"tf":1},"21":{"tf":1},"59":{"tf":1},"64":{"tf":1},"73":{"tf":1},"120":{"tf":1},"125":{"tf":1},"164":{"tf":1},"176":{"tf":1},"237":{"tf":1.4142135623730951},"240":{"tf":1},"253":{"tf":1},"291":{"tf":1},"296":{"tf":1},"304":{"tf":1},"355":{"tf":1},"360":{"tf":1},"399":{"tf":1},"411":{"tf":1},"468":{"tf":1.4142135623730951},"471":{"tf":1},"484":{"tf":1},"522":{"tf":1},"526":{"tf":1},"535":{"tf":1},"617":{"tf":1},"629":{"tf":1},"682":{"tf":1.4142135623730951},"727":{"tf":1}},"df":29,"e":{"docs":{"27":{"tf":1},"259":{"tf":1},"490":{"tf":1},"704":{"tf":1},"806":{"tf":1},"858":{"tf":1}},"df":6},"o":{"docs":{},"df":0,"d":{"docs":{"54":{"tf":1},"98":{"tf":1},"101":{"tf":1},"109":{"tf":1},"125":{"tf":1},"169":{"tf":1},"195":{"tf":1},"286":{"tf":1},"329":{"tf":1},"332":{"tf":1},"340":{"tf":1},"354":{"tf":1},"360":{"tf":1},"404":{"tf":1},"430":{"tf":1},"517":{"tf":1},"560":{"tf":1},"563":{"tf":1},"571":{"tf":1},"622":{"tf":1},"648":{"tf":1},"731":{"tf":1},"770":{"tf":1}},"df":23}},"a":{"docs":{},"df":0,"l":{"docs":{"912":{"tf":1},"925":{"tf":1}},"df":2}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"b":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"66":{"tf":1},"177":{"tf":1.4142135623730951},"187":{"tf":1.4142135623730951},"189":{"tf":1},"192":{"tf":2.449489742783178},"215":{"tf":1},"252":{"tf":1.4142135623730951},"412":{"tf":1.4142135623730951},"422":{"tf":1.4142135623730951},"424":{"tf":1},"427":{"tf":2.449489742783178},"446":{"tf":1},"457":{"tf":1},"528":{"tf":1},"630":{"tf":1.4142135623730951},"640":{"tf":1.4142135623730951},"642":{"tf":1},"645":{"tf":2.449489742783178},"660":{"tf":1},"671":{"tf":1},"840":{"tf":1.4142135623730951},"850":{"tf":1.4142135623730951},"852":{"tf":1},"855":{"tf":2.23606797749979},"901":{"tf":1},"907":{"tf":1},"925":{"tf":1},"928":{"tf":1}},"df":28}}}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"208":{"tf":1.4142135623730951},"350":{"tf":1},"441":{"tf":1.4142135623730951},"717":{"tf":1}},"df":4}}}},"i":{"docs":{},"df":0,"n":{"docs":{"774":{"tf":1}},"df":1}}},"w":{"docs":{},"df":0,"t":{"docs":{"351":{"tf":1}},"df":1}}},"u":{"docs":{},"df":0,"s":{"docs":{"3":{"tf":2},"4":{"tf":2},"8":{"tf":1},"21":{"tf":1.4142135623730951},"26":{"tf":1.7320508075688772},"27":{"tf":1},"34":{"tf":1.4142135623730951},"38":{"tf":1},"39":{"tf":1},"43":{"tf":1.7320508075688772},"55":{"tf":1.4142135623730951},"56":{"tf":1.4142135623730951},"59":{"tf":1},"64":{"tf":1.4142135623730951},"66":{"tf":1},"68":{"tf":1},"72":{"tf":1},"77":{"tf":1.4142135623730951},"86":{"tf":1.4142135623730951},"91":{"tf":1},"94":{"tf":1},"103":{"tf":1},"105":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"116":{"tf":2.8284271247461903},"119":{"tf":2.23606797749979},"121":{"tf":1},"122":{"tf":1.4142135623730951},"125":{"tf":2.8284271247461903},"128":{"tf":2.8284271247461903},"134":{"tf":1.4142135623730951},"140":{"tf":1},"146":{"tf":1},"157":{"tf":1},"158":{"tf":1.4142135623730951},"164":{"tf":1.4142135623730951},"167":{"tf":1},"168":{"tf":2},"169":{"tf":1.4142135623730951},"171":{"tf":1.4142135623730951},"175":{"tf":1},"176":{"tf":1},"177":{"tf":2},"181":{"tf":1},"182":{"tf":1.4142135623730951},"183":{"tf":1},"192":{"tf":2.6457513110645907},"195":{"tf":1.4142135623730951},"199":{"tf":1.4142135623730951},"205":{"tf":1},"206":{"tf":1},"208":{"tf":1.4142135623730951},"209":{"tf":1.4142135623730951},"210":{"tf":1.4142135623730951},"214":{"tf":1},"225":{"tf":1.4142135623730951},"229":{"tf":1.7320508075688772},"231":{"tf":1},"237":{"tf":1},"240":{"tf":1},"252":{"tf":1.4142135623730951},"253":{"tf":1.4142135623730951},"258":{"tf":1.7320508075688772},"259":{"tf":1},"266":{"tf":1.4142135623730951},"270":{"tf":1},"271":{"tf":1},"275":{"tf":1.7320508075688772},"287":{"tf":1.4142135623730951},"288":{"tf":1.4142135623730951},"291":{"tf":1},"295":{"tf":1.4142135623730951},"296":{"tf":1},"299":{"tf":1},"303":{"tf":1},"308":{"tf":1.4142135623730951},"317":{"tf":1.4142135623730951},"322":{"tf":1},"325":{"tf":1},"334":{"tf":1},"336":{"tf":1.4142135623730951},"340":{"tf":1.4142135623730951},"347":{"tf":2.8284271247461903},"350":{"tf":1},"351":{"tf":1.7320508075688772},"354":{"tf":2.6457513110645907},"356":{"tf":1},"357":{"tf":1.7320508075688772},"360":{"tf":2.8284271247461903},"363":{"tf":2.8284271247461903},"369":{"tf":1.4142135623730951},"375":{"tf":1},"381":{"tf":1},"392":{"tf":1},"393":{"tf":1.4142135623730951},"399":{"tf":2},"402":{"tf":1},"403":{"tf":1.7320508075688772},"404":{"tf":1.4142135623730951},"406":{"tf":1.4142135623730951},"410":{"tf":1},"411":{"tf":1},"412":{"tf":2},"416":{"tf":1},"417":{"tf":1.4142135623730951},"418":{"tf":1},"427":{"tf":2.6457513110645907},"430":{"tf":1.4142135623730951},"434":{"tf":1.4142135623730951},"440":{"tf":1},"441":{"tf":1.4142135623730951},"445":{"tf":1},"456":{"tf":1.4142135623730951},"457":{"tf":2},"460":{"tf":1.7320508075688772},"462":{"tf":1},"468":{"tf":1},"471":{"tf":1},"484":{"tf":1.4142135623730951},"489":{"tf":1.7320508075688772},"490":{"tf":1},"497":{"tf":1.4142135623730951},"501":{"tf":1},"502":{"tf":1},"506":{"tf":1.7320508075688772},"518":{"tf":1.4142135623730951},"519":{"tf":1.4142135623730951},"522":{"tf":1},"526":{"tf":1.7320508075688772},"528":{"tf":1},"530":{"tf":1},"534":{"tf":1},"539":{"tf":1.4142135623730951},"548":{"tf":1.4142135623730951},"553":{"tf":1},"556":{"tf":1},"565":{"tf":1},"567":{"tf":1.4142135623730951},"571":{"tf":1.4142135623730951},"578":{"tf":2.8284271247461903},"581":{"tf":2.8284271247461903},"587":{"tf":1.4142135623730951},"593":{"tf":1},"599":{"tf":1},"610":{"tf":1},"611":{"tf":1.4142135623730951},"617":{"tf":2},"620":{"tf":1},"621":{"tf":2},"622":{"tf":1.4142135623730951},"624":{"tf":1.4142135623730951},"628":{"tf":1},"629":{"tf":1},"630":{"tf":2},"634":{"tf":1},"635":{"tf":1.4142135623730951},"636":{"tf":1},"645":{"tf":2.6457513110645907},"648":{"tf":1.4142135623730951},"652":{"tf":1.4142135623730951},"659":{"tf":1},"670":{"tf":1.4142135623730951},"671":{"tf":2},"674":{"tf":1.7320508075688772},"676":{"tf":1},"682":{"tf":1},"691":{"tf":1},"698":{"tf":2},"703":{"tf":1.4142135623730951},"704":{"tf":1},"711":{"tf":1.4142135623730951},"715":{"tf":1},"716":{"tf":1},"720":{"tf":1.7320508075688772},"732":{"tf":1.4142135623730951},"733":{"tf":1.4142135623730951},"740":{"tf":1},"759":{"tf":1},"760":{"tf":1},"772":{"tf":1},"774":{"tf":1},"778":{"tf":1.4142135623730951},"785":{"tf":1},"788":{"tf":1},"791":{"tf":2.8284271247461903},"797":{"tf":1},"803":{"tf":1},"806":{"tf":1},"809":{"tf":1},"812":{"tf":1},"818":{"tf":1},"821":{"tf":1},"824":{"tf":1.4142135623730951},"827":{"tf":2},"831":{"tf":1},"832":{"tf":1.7320508075688772},"834":{"tf":1},"839":{"tf":1.4142135623730951},"840":{"tf":1.4142135623730951},"841":{"tf":1},"844":{"tf":1.7320508075688772},"845":{"tf":1.4142135623730951},"852":{"tf":1},"855":{"tf":2.6457513110645907},"858":{"tf":1.7320508075688772},"862":{"tf":1.7320508075688772},"867":{"tf":1},"877":{"tf":1},"881":{"tf":2},"886":{"tf":1},"889":{"tf":1},"890":{"tf":1.7320508075688772},"891":{"tf":1},"894":{"tf":1.7320508075688772},"895":{"tf":1},"897":{"tf":1},"898":{"tf":1},"899":{"tf":1},"901":{"tf":1},"902":{"tf":1},"907":{"tf":1},"908":{"tf":1.4142135623730951},"911":{"tf":1},"915":{"tf":1},"918":{"tf":1},"928":{"tf":1},"929":{"tf":1.4142135623730951},"937":{"tf":1},"938":{"tf":1},"939":{"tf":1.7320508075688772},"941":{"tf":1},"943":{"tf":1},"944":{"tf":1},"946":{"tf":1},"948":{"tf":1},"949":{"tf":1.4142135623730951},"951":{"tf":1},"954":{"tf":1.7320508075688772},"958":{"tf":2},"960":{"tf":1},"961":{"tf":1}},"df":241,"e":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":1},"68":{"tf":1},"119":{"tf":1},"128":{"tf":1},"237":{"tf":1},"299":{"tf":1},"354":{"tf":1},"363":{"tf":1},"468":{"tf":1},"530":{"tf":1},"581":{"tf":1},"682":{"tf":1},"781":{"tf":1},"890":{"tf":1},"902":{"tf":1},"912":{"tf":1},"915":{"tf":1.4142135623730951},"929":{"tf":1.4142135623730951}},"df":19,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"747":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"350":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"86":{"tf":1},"125":{"tf":1},"169":{"tf":1},"317":{"tf":1},"360":{"tf":1},"404":{"tf":1},"548":{"tf":1},"622":{"tf":1},"754":{"tf":1},"839":{"tf":1},"912":{"tf":1}},"df":11}}},"a":{"docs":{},"df":0,"g":{"docs":{"192":{"tf":1},"203":{"tf":1},"207":{"tf":1},"427":{"tf":1},"438":{"tf":1},"645":{"tf":1},"867":{"tf":1},"933":{"tf":1},"956":{"tf":1}},"df":9},"b":{"docs":{},"df":0,"l":{"docs":{"907":{"tf":1}},"df":1}}}},"i":{"docs":{"3":{"tf":1.7320508075688772},"4":{"tf":2},"8":{"tf":2},"81":{"tf":1},"119":{"tf":1.7320508075688772},"121":{"tf":1},"122":{"tf":3.605551275463989},"125":{"tf":1},"171":{"tf":1.4142135623730951},"202":{"tf":1},"229":{"tf":1},"240":{"tf":2},"312":{"tf":1},"351":{"tf":1},"354":{"tf":2.23606797749979},"356":{"tf":1},"357":{"tf":3.7416573867739413},"360":{"tf":1},"406":{"tf":1.4142135623730951},"437":{"tf":1},"460":{"tf":1},"471":{"tf":2},"543":{"tf":1},"624":{"tf":1.4142135623730951},"674":{"tf":1},"685":{"tf":1},"881":{"tf":1},"932":{"tf":1},"933":{"tf":1.4142135623730951},"936":{"tf":1},"944":{"tf":1}},"df":31},"p":{"docs":{"3":{"tf":1},"4":{"tf":1},"14":{"tf":1.7320508075688772},"21":{"tf":1},"33":{"tf":1},"37":{"tf":1},"50":{"tf":1},"54":{"tf":1},"59":{"tf":1},"81":{"tf":1.4142135623730951},"82":{"tf":1},"86":{"tf":1.4142135623730951},"90":{"tf":1},"137":{"tf":1},"145":{"tf":1},"176":{"tf":1},"182":{"tf":1.4142135623730951},"189":{"tf":1},"237":{"tf":1},"246":{"tf":1.7320508075688772},"265":{"tf":1},"269":{"tf":1},"282":{"tf":1},"286":{"tf":1},"291":{"tf":1},"295":{"tf":1},"312":{"tf":1.4142135623730951},"313":{"tf":1},"317":{"tf":1.4142135623730951},"321":{"tf":1},"356":{"tf":1},"372":{"tf":1},"380":{"tf":1},"411":{"tf":1},"417":{"tf":1.4142135623730951},"424":{"tf":1},"468":{"tf":1},"477":{"tf":1.7320508075688772},"484":{"tf":1},"496":{"tf":1},"500":{"tf":1},"513":{"tf":1},"517":{"tf":1},"522":{"tf":1},"543":{"tf":1.4142135623730951},"544":{"tf":1},"548":{"tf":1.4142135623730951},"552":{"tf":1},"590":{"tf":1},"598":{"tf":1},"629":{"tf":1},"635":{"tf":1.4142135623730951},"642":{"tf":1},"682":{"tf":1},"691":{"tf":1.7320508075688772},"698":{"tf":1},"710":{"tf":1},"714":{"tf":1},"717":{"tf":1},"757":{"tf":1},"893":{"tf":1},"915":{"tf":1.7320508075688772},"936":{"tf":1},"945":{"tf":1},"949":{"tf":1},"951":{"tf":1}},"df":66,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1},"155":{"tf":1.4142135623730951},"156":{"tf":1.4142135623730951},"177":{"tf":1},"178":{"tf":1.7320508075688772},"312":{"tf":1},"390":{"tf":1.4142135623730951},"391":{"tf":1.4142135623730951},"412":{"tf":1},"413":{"tf":1.7320508075688772},"543":{"tf":1},"608":{"tf":1.4142135623730951},"609":{"tf":1.4142135623730951},"630":{"tf":1},"631":{"tf":1.7320508075688772},"757":{"tf":1},"818":{"tf":1},"819":{"tf":1.4142135623730951},"939":{"tf":1}},"df":19}}},"o":{"docs":{},"df":0,"n":{"docs":{"809":{"tf":1}},"df":1}}},"n":{"docs":{"203":{"tf":1},"438":{"tf":1}},"df":2,"d":{"docs":{"351":{"tf":1}},"df":1,"e":{"docs":{},"df":0,"r":{"docs":{"8":{"tf":1},"14":{"tf":1},"20":{"tf":1},"66":{"tf":1},"240":{"tf":1},"246":{"tf":1},"471":{"tf":1},"477":{"tf":1},"483":{"tf":1},"528":{"tf":1},"691":{"tf":1},"739":{"tf":1},"740":{"tf":1},"742":{"tf":1},"747":{"tf":1},"748":{"tf":1},"749":{"tf":1},"818":{"tf":1},"846":{"tf":1},"858":{"tf":1},"936":{"tf":1.4142135623730951},"939":{"tf":1},"951":{"tf":1},"956":{"tf":1}},"df":24,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"177":{"tf":1},"192":{"tf":1},"412":{"tf":1},"427":{"tf":1},"630":{"tf":1},"645":{"tf":1},"834":{"tf":1},"840":{"tf":1}},"df":8}}}}}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"47":{"tf":1},"149":{"tf":1},"192":{"tf":1},"229":{"tf":1},"279":{"tf":1},"384":{"tf":1},"427":{"tf":1},"460":{"tf":1},"510":{"tf":1},"602":{"tf":1},"645":{"tf":1},"674":{"tf":1},"724":{"tf":1},"747":{"tf":1},"855":{"tf":1.4142135623730951},"881":{"tf":1}},"df":16}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"55":{"tf":1},"287":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":4}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"210":{"tf":1}},"df":1}}}}}}}}},"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"m":{"docs":{"81":{"tf":1},"82":{"tf":1},"312":{"tf":1},"313":{"tf":1},"543":{"tf":1},"544":{"tf":1},"757":{"tf":1},"758":{"tf":1}},"df":8}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"925":{"tf":1}},"df":1}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"134":{"tf":1},"369":{"tf":1},"587":{"tf":1}},"df":3}}},"k":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"146":{"tf":1},"381":{"tf":1},"599":{"tf":1},"709":{"tf":1}},"df":4}}}}},"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1},"924":{"tf":1}},"df":2}}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"924":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{"948":{"tf":1},"951":{"tf":1}},"df":2}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"199":{"tf":1},"208":{"tf":1},"214":{"tf":1},"434":{"tf":1},"441":{"tf":1},"445":{"tf":1},"652":{"tf":1},"659":{"tf":1},"867":{"tf":1}},"df":9}}},"r":{"docs":{},"df":0,"l":{"docs":{"295":{"tf":1.4142135623730951},"296":{"tf":1}},"df":2}}},"i":{"5":{"docs":{"26":{"tf":1.4142135623730951},"72":{"tf":1},"73":{"tf":1},"74":{"tf":1},"116":{"tf":1.4142135623730951},"258":{"tf":1.4142135623730951},"303":{"tf":1},"304":{"tf":1},"305":{"tf":1},"347":{"tf":1.4142135623730951},"489":{"tf":1.4142135623730951},"534":{"tf":1},"535":{"tf":1},"536":{"tf":1},"578":{"tf":1.4142135623730951}},"df":15},"docs":{},"df":0,"n":{"docs":{"3":{"tf":1.4142135623730951},"4":{"tf":1.7320508075688772},"8":{"tf":1},"11":{"tf":1},"14":{"tf":1},"15":{"tf":1.4142135623730951},"16":{"tf":1},"20":{"tf":1.4142135623730951},"21":{"tf":2},"27":{"tf":2.23606797749979},"28":{"tf":1.4142135623730951},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1.4142135623730951},"39":{"tf":1},"40":{"tf":1},"43":{"tf":2},"47":{"tf":1},"50":{"tf":1},"51":{"tf":1.4142135623730951},"54":{"tf":1.4142135623730951},"55":{"tf":1.4142135623730951},"56":{"tf":2},"59":{"tf":1},"62":{"tf":1},"63":{"tf":1},"64":{"tf":1.7320508075688772},"65":{"tf":1},"66":{"tf":2},"68":{"tf":1.4142135623730951},"72":{"tf":1.7320508075688772},"73":{"tf":1},"74":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"81":{"tf":1},"82":{"tf":1},"86":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"91":{"tf":1},"94":{"tf":1.4142135623730951},"97":{"tf":1.7320508075688772},"102":{"tf":1},"103":{"tf":1},"105":{"tf":1.4142135623730951},"106":{"tf":1},"109":{"tf":1.4142135623730951},"112":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":2.23606797749979},"119":{"tf":3.3166247903554},"120":{"tf":1},"122":{"tf":4.898979485566356},"125":{"tf":3.605551275463989},"128":{"tf":2.6457513110645907},"134":{"tf":1.7320508075688772},"137":{"tf":1.4142135623730951},"138":{"tf":1},"139":{"tf":1},"140":{"tf":2.6457513110645907},"143":{"tf":2},"145":{"tf":1},"146":{"tf":1.4142135623730951},"149":{"tf":1.4142135623730951},"151":{"tf":1},"152":{"tf":1},"155":{"tf":1.7320508075688772},"156":{"tf":1},"157":{"tf":1.4142135623730951},"158":{"tf":1},"161":{"tf":1},"164":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1.7320508075688772},"171":{"tf":3.605551275463989},"175":{"tf":1.4142135623730951},"176":{"tf":2},"177":{"tf":1.7320508075688772},"178":{"tf":2},"181":{"tf":1.4142135623730951},"182":{"tf":3.605551275463989},"183":{"tf":1},"187":{"tf":1.7320508075688772},"188":{"tf":1.4142135623730951},"189":{"tf":1.7320508075688772},"192":{"tf":3.7416573867739413},"195":{"tf":3},"198":{"tf":1.4142135623730951},"199":{"tf":1},"203":{"tf":1},"204":{"tf":1.7320508075688772},"210":{"tf":2},"213":{"tf":1},"215":{"tf":2},"223":{"tf":1.4142135623730951},"224":{"tf":1},"225":{"tf":1},"226":{"tf":2.6457513110645907},"229":{"tf":2.6457513110645907},"230":{"tf":1},"231":{"tf":3.4641016151377544},"232":{"tf":3.4641016151377544},"233":{"tf":1},"237":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"243":{"tf":1},"246":{"tf":1},"247":{"tf":1.4142135623730951},"248":{"tf":1},"252":{"tf":1},"253":{"tf":1.4142135623730951},"259":{"tf":2.23606797749979},"260":{"tf":1.4142135623730951},"266":{"tf":1.4142135623730951},"269":{"tf":1.4142135623730951},"270":{"tf":1.4142135623730951},"271":{"tf":1},"272":{"tf":1},"275":{"tf":2},"279":{"tf":1},"282":{"tf":1},"283":{"tf":1.4142135623730951},"286":{"tf":1.4142135623730951},"287":{"tf":1.4142135623730951},"288":{"tf":2},"291":{"tf":1},"294":{"tf":1.4142135623730951},"295":{"tf":2},"296":{"tf":1.4142135623730951},"297":{"tf":1},"299":{"tf":1.7320508075688772},"303":{"tf":1.7320508075688772},"304":{"tf":1},"305":{"tf":1.4142135623730951},"308":{"tf":1.4142135623730951},"312":{"tf":1},"313":{"tf":1},"317":{"tf":1.4142135623730951},"321":{"tf":1.4142135623730951},"322":{"tf":1},"325":{"tf":1.4142135623730951},"328":{"tf":1.7320508075688772},"333":{"tf":1},"334":{"tf":1},"336":{"tf":1.4142135623730951},"337":{"tf":1.4142135623730951},"340":{"tf":1.4142135623730951},"343":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":2.23606797749979},"350":{"tf":3.1622776601683795},"351":{"tf":2},"354":{"tf":3.605551275463989},"355":{"tf":1},"356":{"tf":1.7320508075688772},"357":{"tf":5.291502622129181},"360":{"tf":3.605551275463989},"363":{"tf":2.6457513110645907},"369":{"tf":1.7320508075688772},"372":{"tf":1.4142135623730951},"373":{"tf":1},"374":{"tf":1},"375":{"tf":2.6457513110645907},"378":{"tf":2},"380":{"tf":1},"381":{"tf":1.4142135623730951},"384":{"tf":1.4142135623730951},"386":{"tf":1},"387":{"tf":1},"390":{"tf":1.7320508075688772},"391":{"tf":1},"392":{"tf":1.4142135623730951},"393":{"tf":1},"396":{"tf":1},"399":{"tf":1.4142135623730951},"403":{"tf":1.4142135623730951},"404":{"tf":1.7320508075688772},"406":{"tf":3.605551275463989},"410":{"tf":1.4142135623730951},"411":{"tf":2},"412":{"tf":1.7320508075688772},"413":{"tf":2},"416":{"tf":1.4142135623730951},"417":{"tf":3.605551275463989},"418":{"tf":1},"422":{"tf":1.7320508075688772},"423":{"tf":1.4142135623730951},"424":{"tf":1.7320508075688772},"427":{"tf":3.7416573867739413},"430":{"tf":3},"433":{"tf":1.4142135623730951},"434":{"tf":1},"438":{"tf":1},"439":{"tf":1.7320508075688772},"444":{"tf":1},"446":{"tf":2},"454":{"tf":1.4142135623730951},"455":{"tf":1},"456":{"tf":1},"457":{"tf":2.23606797749979},"460":{"tf":2.6457513110645907},"461":{"tf":1},"462":{"tf":3.4641016151377544},"463":{"tf":3.4641016151377544},"464":{"tf":1},"468":{"tf":1.4142135623730951},"471":{"tf":1.4142135623730951},"474":{"tf":1},"477":{"tf":1},"478":{"tf":1.4142135623730951},"479":{"tf":1},"483":{"tf":1.4142135623730951},"484":{"tf":1.4142135623730951},"490":{"tf":2.23606797749979},"491":{"tf":1.4142135623730951},"497":{"tf":1.4142135623730951},"500":{"tf":1.4142135623730951},"501":{"tf":1.4142135623730951},"502":{"tf":1},"503":{"tf":1},"506":{"tf":2},"510":{"tf":1},"513":{"tf":1},"514":{"tf":1.4142135623730951},"517":{"tf":1.4142135623730951},"518":{"tf":1.4142135623730951},"519":{"tf":2},"522":{"tf":1},"525":{"tf":1},"526":{"tf":2.23606797749979},"527":{"tf":1},"528":{"tf":2},"530":{"tf":1.4142135623730951},"534":{"tf":1.7320508075688772},"535":{"tf":1},"536":{"tf":1.4142135623730951},"539":{"tf":1.4142135623730951},"543":{"tf":1},"544":{"tf":1},"548":{"tf":1.4142135623730951},"552":{"tf":1.4142135623730951},"553":{"tf":1},"556":{"tf":1.4142135623730951},"559":{"tf":1.7320508075688772},"564":{"tf":1},"565":{"tf":1},"567":{"tf":1.4142135623730951},"568":{"tf":1.4142135623730951},"571":{"tf":1.4142135623730951},"574":{"tf":1},"577":{"tf":1.4142135623730951},"578":{"tf":2.23606797749979},"581":{"tf":2.6457513110645907},"587":{"tf":1.7320508075688772},"590":{"tf":1.4142135623730951},"591":{"tf":1},"592":{"tf":1},"593":{"tf":2.6457513110645907},"596":{"tf":2},"598":{"tf":1},"599":{"tf":1.4142135623730951},"602":{"tf":1.4142135623730951},"604":{"tf":1},"605":{"tf":1},"608":{"tf":1.7320508075688772},"609":{"tf":1},"610":{"tf":1.4142135623730951},"611":{"tf":1},"614":{"tf":1},"617":{"tf":1.4142135623730951},"621":{"tf":1.4142135623730951},"622":{"tf":1.7320508075688772},"624":{"tf":3.605551275463989},"628":{"tf":1.4142135623730951},"629":{"tf":2},"630":{"tf":1.7320508075688772},"631":{"tf":2},"634":{"tf":1.4142135623730951},"635":{"tf":3.605551275463989},"636":{"tf":1},"640":{"tf":1.7320508075688772},"641":{"tf":1.4142135623730951},"642":{"tf":1.7320508075688772},"645":{"tf":3.7416573867739413},"648":{"tf":3},"651":{"tf":1.4142135623730951},"652":{"tf":1},"658":{"tf":1},"660":{"tf":2},"668":{"tf":1.4142135623730951},"669":{"tf":1},"670":{"tf":1},"671":{"tf":2.23606797749979},"674":{"tf":2.6457513110645907},"675":{"tf":1},"676":{"tf":3.4641016151377544},"677":{"tf":3.4641016151377544},"678":{"tf":1},"682":{"tf":1.4142135623730951},"685":{"tf":2},"688":{"tf":1},"691":{"tf":1},"692":{"tf":1.4142135623730951},"693":{"tf":1},"698":{"tf":2},"704":{"tf":2},"705":{"tf":1.4142135623730951},"711":{"tf":1.4142135623730951},"714":{"tf":1.4142135623730951},"715":{"tf":1.4142135623730951},"717":{"tf":1.4142135623730951},"720":{"tf":2},"724":{"tf":1},"727":{"tf":1},"728":{"tf":1},"731":{"tf":1},"732":{"tf":1.4142135623730951},"733":{"tf":2},"736":{"tf":1},"740":{"tf":1.4142135623730951},"747":{"tf":1.4142135623730951},"748":{"tf":1.4142135623730951},"749":{"tf":1.7320508075688772},"751":{"tf":1},"754":{"tf":2},"758":{"tf":1.4142135623730951},"763":{"tf":1},"766":{"tf":1.4142135623730951},"770":{"tf":1.4142135623730951},"771":{"tf":1.7320508075688772},"772":{"tf":1.4142135623730951},"773":{"tf":1.4142135623730951},"774":{"tf":1},"775":{"tf":1},"778":{"tf":2},"781":{"tf":2.23606797749979},"784":{"tf":1.4142135623730951},"785":{"tf":1.7320508075688772},"788":{"tf":1},"791":{"tf":3},"794":{"tf":1},"797":{"tf":2},"800":{"tf":1.7320508075688772},"801":{"tf":1.4142135623730951},"803":{"tf":2.23606797749979},"806":{"tf":1.7320508075688772},"809":{"tf":1.4142135623730951},"812":{"tf":1},"814":{"tf":1},"815":{"tf":1},"818":{"tf":2.23606797749979},"819":{"tf":1},"820":{"tf":1},"824":{"tf":2},"827":{"tf":1.4142135623730951},"830":{"tf":1},"831":{"tf":1.7320508075688772},"832":{"tf":2},"833":{"tf":1},"834":{"tf":3.4641016151377544},"838":{"tf":1.4142135623730951},"839":{"tf":1.4142135623730951},"840":{"tf":2.6457513110645907},"841":{"tf":2.449489742783178},"844":{"tf":2.23606797749979},"845":{"tf":4.123105625617661},"846":{"tf":1.4142135623730951},"847":{"tf":1},"850":{"tf":2.23606797749979},"851":{"tf":2},"852":{"tf":2.23606797749979},"855":{"tf":3.605551275463989},"858":{"tf":2.6457513110645907},"861":{"tf":1.4142135623730951},"862":{"tf":1},"868":{"tf":1.7320508075688772},"875":{"tf":1.4142135623730951},"876":{"tf":1.7320508075688772},"877":{"tf":1},"878":{"tf":2.449489742783178},"881":{"tf":6},"882":{"tf":1},"886":{"tf":1},"889":{"tf":1},"894":{"tf":1.7320508075688772},"895":{"tf":1.7320508075688772},"898":{"tf":1},"899":{"tf":2},"901":{"tf":2},"902":{"tf":2},"905":{"tf":1},"907":{"tf":2.23606797749979},"911":{"tf":2},"912":{"tf":1.7320508075688772},"913":{"tf":1.4142135623730951},"915":{"tf":2.449489742783178},"916":{"tf":2},"917":{"tf":1},"921":{"tf":1.7320508075688772},"922":{"tf":1},"924":{"tf":2.23606797749979},"925":{"tf":1.7320508075688772},"926":{"tf":1.4142135623730951},"927":{"tf":1},"928":{"tf":1},"929":{"tf":1.7320508075688772},"932":{"tf":1},"933":{"tf":1.4142135623730951},"936":{"tf":1.4142135623730951},"937":{"tf":1},"939":{"tf":2.449489742783178},"940":{"tf":1},"943":{"tf":1.4142135623730951},"944":{"tf":1.4142135623730951},"945":{"tf":1},"946":{"tf":2},"948":{"tf":1},"949":{"tf":1},"951":{"tf":1.7320508075688772},"954":{"tf":2},"955":{"tf":1},"956":{"tf":1},"957":{"tf":1},"958":{"tf":2},"960":{"tf":1},"962":{"tf":1},"963":{"tf":1}},"df":426,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"f":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"3":{"tf":1.4142135623730951}},"df":1}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"119":{"tf":1},"182":{"tf":1},"229":{"tf":1},"354":{"tf":1},"417":{"tf":1},"460":{"tf":1},"635":{"tf":1},"674":{"tf":1},"746":{"tf":1},"781":{"tf":1},"803":{"tf":1},"845":{"tf":1},"866":{"tf":1},"881":{"tf":1}},"df":15}}},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"73":{"tf":1},"171":{"tf":1},"304":{"tf":1},"406":{"tf":1},"535":{"tf":1},"624":{"tf":1}},"df":6}}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"177":{"tf":1},"229":{"tf":1},"357":{"tf":1},"412":{"tf":1},"460":{"tf":1},"630":{"tf":1},"674":{"tf":1},"840":{"tf":1},"855":{"tf":1},"881":{"tf":1},"929":{"tf":1},"946":{"tf":1},"954":{"tf":1}},"df":14}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"192":{"tf":1},"427":{"tf":1},"645":{"tf":1},"855":{"tf":1.4142135623730951}},"df":4}}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1},"791":{"tf":1},"794":{"tf":1},"824":{"tf":1},"844":{"tf":1},"926":{"tf":1}},"df":6}}}}},"g":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"791":{"tf":1}},"df":2}},"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"81":{"tf":1},"177":{"tf":1},"312":{"tf":1},"412":{"tf":1},"543":{"tf":1},"630":{"tf":1},"926":{"tf":1},"951":{"tf":1},"954":{"tf":1}},"df":10},"t":{"docs":{"39":{"tf":1},"271":{"tf":1},"502":{"tf":1},"716":{"tf":1}},"df":4}}},"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"128":{"tf":1},"363":{"tf":1},"581":{"tf":1},"791":{"tf":1}},"df":5}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{"155":{"tf":1},"211":{"tf":1},"390":{"tf":1},"442":{"tf":1},"608":{"tf":1},"656":{"tf":1},"905":{"tf":1},"907":{"tf":1}},"df":8,"t":{"docs":{"4":{"tf":1},"943":{"tf":1}},"df":2}}}}}}},"p":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"4":{"tf":1},"32":{"tf":1},"125":{"tf":1},"164":{"tf":1},"264":{"tf":1},"354":{"tf":1},"360":{"tf":1},"399":{"tf":1},"495":{"tf":1},"617":{"tf":1},"763":{"tf":1},"773":{"tf":1},"890":{"tf":1}},"df":14}}},"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"21":{"tf":1},"122":{"tf":1},"161":{"tf":1},"199":{"tf":1},"357":{"tf":1},"396":{"tf":1},"434":{"tf":1},"484":{"tf":1},"614":{"tf":1},"652":{"tf":1},"862":{"tf":1},"907":{"tf":1}},"df":13}}}},"x":{"docs":{"116":{"tf":4},"122":{"tf":1.7320508075688772},"125":{"tf":1.7320508075688772},"187":{"tf":1},"232":{"tf":1.4142135623730951},"305":{"tf":1},"347":{"tf":4},"350":{"tf":1.4142135623730951},"357":{"tf":1.7320508075688772},"360":{"tf":1.7320508075688772},"422":{"tf":1},"463":{"tf":1.4142135623730951},"578":{"tf":4},"640":{"tf":1},"677":{"tf":1.4142135623730951},"784":{"tf":1.7320508075688772},"785":{"tf":2.8284271247461903},"788":{"tf":1},"850":{"tf":1},"881":{"tf":1.4142135623730951},"895":{"tf":1}},"df":21,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"926":{"tf":1}},"df":1}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"c":{"docs":{"14":{"tf":1},"27":{"tf":1},"38":{"tf":1},"77":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":2.6457513110645907},"125":{"tf":2},"131":{"tf":1},"151":{"tf":1},"155":{"tf":1},"156":{"tf":1},"176":{"tf":1},"246":{"tf":1},"259":{"tf":1},"270":{"tf":1},"308":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":2.6457513110645907},"350":{"tf":1},"360":{"tf":2},"366":{"tf":1},"386":{"tf":1},"390":{"tf":1},"391":{"tf":1},"411":{"tf":1},"477":{"tf":1},"490":{"tf":1},"501":{"tf":1},"534":{"tf":1.4142135623730951},"539":{"tf":1},"577":{"tf":1.4142135623730951},"578":{"tf":2.6457513110645907},"584":{"tf":1},"604":{"tf":1},"608":{"tf":1},"609":{"tf":1},"629":{"tf":1},"691":{"tf":1},"704":{"tf":1},"715":{"tf":1},"784":{"tf":1},"785":{"tf":1},"794":{"tf":1},"797":{"tf":1},"800":{"tf":1},"839":{"tf":1},"936":{"tf":1},"946":{"tf":1}},"df":48},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"u":{"docs":{"15":{"tf":1},"16":{"tf":1},"247":{"tf":1},"248":{"tf":1},"478":{"tf":1},"479":{"tf":1},"692":{"tf":1},"693":{"tf":1}},"df":8}}}}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1}},"df":1}}},"d":{"docs":{"20":{"tf":1},"25":{"tf":1},"252":{"tf":1},"257":{"tf":1},"483":{"tf":1},"488":{"tf":1},"748":{"tf":1},"749":{"tf":1},"832":{"tf":1},"852":{"tf":1}},"df":10}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"14":{"tf":1},"21":{"tf":1},"64":{"tf":1.4142135623730951},"97":{"tf":1},"198":{"tf":1},"246":{"tf":1},"253":{"tf":1},"295":{"tf":1.4142135623730951},"328":{"tf":1},"351":{"tf":1.4142135623730951},"433":{"tf":1},"477":{"tf":1},"484":{"tf":1},"526":{"tf":1.4142135623730951},"559":{"tf":1},"651":{"tf":1},"691":{"tf":1},"740":{"tf":1},"743":{"tf":1},"766":{"tf":1},"861":{"tf":1}},"df":21},"n":{"docs":{},"df":0,"c":{"docs":{"954":{"tf":1}},"df":1}}},"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"119":{"tf":1},"354":{"tf":1},"845":{"tf":1},"929":{"tf":1.4142135623730951},"946":{"tf":1},"949":{"tf":1}},"df":6}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"d":{"docs":{"128":{"tf":1},"134":{"tf":1},"363":{"tf":1},"369":{"tf":1},"581":{"tf":1},"587":{"tf":1},"759":{"tf":1},"760":{"tf":1},"788":{"tf":1},"791":{"tf":1},"845":{"tf":1},"858":{"tf":1},"916":{"tf":1},"948":{"tf":1}},"df":14}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"46":{"tf":1},"198":{"tf":1},"278":{"tf":1},"433":{"tf":1},"509":{"tf":1},"651":{"tf":1},"723":{"tf":1}},"df":7}}}},"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"101":{"tf":1.7320508075688772},"103":{"tf":1},"104":{"tf":1},"187":{"tf":1.4142135623730951},"198":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1.7320508075688772},"332":{"tf":1.7320508075688772},"334":{"tf":1},"335":{"tf":1},"350":{"tf":1},"422":{"tf":1.4142135623730951},"433":{"tf":1},"462":{"tf":1.4142135623730951},"463":{"tf":1.7320508075688772},"563":{"tf":1.7320508075688772},"565":{"tf":1},"566":{"tf":1},"640":{"tf":1.4142135623730951},"651":{"tf":1},"676":{"tf":1.4142135623730951},"677":{"tf":1.7320508075688772},"748":{"tf":1.4142135623730951},"749":{"tf":1.4142135623730951},"758":{"tf":1},"770":{"tf":2},"772":{"tf":1.4142135623730951},"773":{"tf":1},"832":{"tf":1},"838":{"tf":1},"839":{"tf":1},"844":{"tf":1},"850":{"tf":1.4142135623730951},"851":{"tf":1},"861":{"tf":1},"881":{"tf":2.23606797749979},"894":{"tf":2.6457513110645907},"895":{"tf":2.23606797749979},"896":{"tf":1.7320508075688772},"909":{"tf":1.4142135623730951},"912":{"tf":1.4142135623730951},"921":{"tf":1.4142135623730951},"925":{"tf":1},"946":{"tf":1.7320508075688772},"948":{"tf":1},"954":{"tf":1}},"df":46}}},"u":{"docs":{},"df":0,"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{"907":{"tf":1}},"df":1}}}}}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"37":{"tf":1},"43":{"tf":1},"50":{"tf":1},"56":{"tf":1},"66":{"tf":1.4142135623730951},"119":{"tf":2.23606797749979},"122":{"tf":2.23606797749979},"125":{"tf":1.7320508075688772},"151":{"tf":1},"157":{"tf":1},"178":{"tf":1},"187":{"tf":1},"195":{"tf":1.4142135623730951},"215":{"tf":1},"226":{"tf":1},"253":{"tf":1},"269":{"tf":1},"275":{"tf":1},"282":{"tf":1},"288":{"tf":1},"297":{"tf":1},"305":{"tf":1},"350":{"tf":1.7320508075688772},"351":{"tf":1.4142135623730951},"354":{"tf":2},"357":{"tf":2.23606797749979},"360":{"tf":1.7320508075688772},"386":{"tf":1},"392":{"tf":1},"413":{"tf":1},"422":{"tf":1},"430":{"tf":1.4142135623730951},"446":{"tf":1},"457":{"tf":1},"500":{"tf":1},"506":{"tf":1},"513":{"tf":1},"519":{"tf":1},"528":{"tf":1.4142135623730951},"604":{"tf":1},"610":{"tf":1},"631":{"tf":1},"640":{"tf":1},"648":{"tf":1.4142135623730951},"660":{"tf":1},"671":{"tf":1},"714":{"tf":1},"717":{"tf":1.4142135623730951},"720":{"tf":1},"733":{"tf":1},"758":{"tf":1},"781":{"tf":1.7320508075688772},"788":{"tf":1},"818":{"tf":1},"820":{"tf":1},"834":{"tf":1},"839":{"tf":1},"841":{"tf":1},"850":{"tf":1},"852":{"tf":1},"858":{"tf":1},"944":{"tf":1}},"df":62,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"/":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"116":{"tf":1},"347":{"tf":1},"578":{"tf":1}},"df":3}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"229":{"tf":1},"460":{"tf":1},"674":{"tf":1},"881":{"tf":1}},"df":4}}}}},"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{"38":{"tf":1},"56":{"tf":1},"138":{"tf":1},"139":{"tf":1},"195":{"tf":2},"209":{"tf":1},"270":{"tf":1},"288":{"tf":1},"373":{"tf":1},"374":{"tf":1},"430":{"tf":2},"501":{"tf":1},"519":{"tf":1},"591":{"tf":1},"592":{"tf":1},"648":{"tf":2},"715":{"tf":1},"733":{"tf":1},"801":{"tf":1},"851":{"tf":1},"858":{"tf":2.23606797749979}},"df":21}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{"94":{"tf":1},"325":{"tf":1},"556":{"tf":1}},"df":3}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"182":{"tf":1},"183":{"tf":1},"417":{"tf":1},"418":{"tf":1},"635":{"tf":1},"636":{"tf":1},"844":{"tf":1},"846":{"tf":1}},"df":8}}}}}}},"v":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}},"k":{"docs":{"182":{"tf":1.4142135623730951},"417":{"tf":1.4142135623730951},"635":{"tf":1.4142135623730951}},"df":3},"l":{"docs":{},"df":0,"v":{"docs":{"937":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"839":{"tf":1}},"df":1}}}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"224":{"tf":1},"455":{"tf":1},"669":{"tf":1}},"df":3}}}}}},"f":{"docs":{"3":{"tf":1},"20":{"tf":1.4142135623730951},"21":{"tf":1},"38":{"tf":1},"40":{"tf":1},"55":{"tf":1.4142135623730951},"66":{"tf":1.7320508075688772},"81":{"tf":1},"86":{"tf":1},"97":{"tf":1},"109":{"tf":1},"116":{"tf":1},"122":{"tf":2.23606797749979},"128":{"tf":1.4142135623730951},"140":{"tf":1},"158":{"tf":1},"168":{"tf":1},"171":{"tf":1},"176":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"182":{"tf":1},"187":{"tf":1},"189":{"tf":1},"195":{"tf":2},"203":{"tf":1.4142135623730951},"210":{"tf":1.4142135623730951},"216":{"tf":1.7320508075688772},"220":{"tf":1},"223":{"tf":1.4142135623730951},"224":{"tf":1.7320508075688772},"225":{"tf":1},"226":{"tf":2.8284271247461903},"229":{"tf":1.4142135623730951},"231":{"tf":1},"232":{"tf":3},"237":{"tf":1},"252":{"tf":1.7320508075688772},"253":{"tf":1},"270":{"tf":1},"272":{"tf":1},"287":{"tf":1.4142135623730951},"312":{"tf":1},"317":{"tf":1},"328":{"tf":1},"340":{"tf":1},"347":{"tf":1},"351":{"tf":1},"357":{"tf":2.6457513110645907},"363":{"tf":1.4142135623730951},"375":{"tf":1},"393":{"tf":1},"406":{"tf":1},"411":{"tf":1.4142135623730951},"412":{"tf":1.4142135623730951},"417":{"tf":1},"422":{"tf":1},"424":{"tf":1},"430":{"tf":2},"438":{"tf":1.4142135623730951},"447":{"tf":1.7320508075688772},"451":{"tf":1},"454":{"tf":1.4142135623730951},"455":{"tf":1.7320508075688772},"456":{"tf":1},"457":{"tf":3.3166247903554},"460":{"tf":1.4142135623730951},"462":{"tf":1},"463":{"tf":3},"468":{"tf":1},"483":{"tf":1.4142135623730951},"484":{"tf":1},"501":{"tf":1},"503":{"tf":1},"518":{"tf":1.4142135623730951},"528":{"tf":1.7320508075688772},"543":{"tf":1},"548":{"tf":1},"559":{"tf":1},"571":{"tf":1},"578":{"tf":1},"581":{"tf":1.4142135623730951},"593":{"tf":1},"611":{"tf":1},"621":{"tf":1},"624":{"tf":1},"629":{"tf":1.4142135623730951},"630":{"tf":1.4142135623730951},"635":{"tf":1},"640":{"tf":1},"642":{"tf":1},"648":{"tf":2},"661":{"tf":1.7320508075688772},"665":{"tf":1},"668":{"tf":1.4142135623730951},"669":{"tf":1.7320508075688772},"670":{"tf":1},"671":{"tf":3.3166247903554},"674":{"tf":1.4142135623730951},"676":{"tf":1},"677":{"tf":3},"682":{"tf":1},"691":{"tf":1},"697":{"tf":1},"698":{"tf":2.23606797749979},"715":{"tf":1},"717":{"tf":1},"724":{"tf":1},"732":{"tf":1.4142135623730951},"740":{"tf":1.4142135623730951},"741":{"tf":1},"748":{"tf":1},"749":{"tf":1},"757":{"tf":1},"758":{"tf":1},"766":{"tf":1},"775":{"tf":1},"778":{"tf":1},"784":{"tf":1},"797":{"tf":1.4142135623730951},"800":{"tf":1},"803":{"tf":1.4142135623730951},"812":{"tf":1.4142135623730951},"821":{"tf":1.4142135623730951},"824":{"tf":1},"831":{"tf":1},"834":{"tf":1},"839":{"tf":1.4142135623730951},"840":{"tf":1},"850":{"tf":1},"851":{"tf":1},"852":{"tf":1},"855":{"tf":2.23606797749979},"858":{"tf":2.23606797749979},"872":{"tf":1},"875":{"tf":1.4142135623730951},"876":{"tf":1.4142135623730951},"877":{"tf":1},"878":{"tf":2.6457513110645907},"881":{"tf":3.3166247903554},"891":{"tf":1},"892":{"tf":1},"893":{"tf":1},"894":{"tf":1},"896":{"tf":1},"900":{"tf":1},"901":{"tf":1.4142135623730951},"905":{"tf":1},"907":{"tf":1.7320508075688772},"908":{"tf":1},"911":{"tf":2},"913":{"tf":1},"915":{"tf":2.6457513110645907},"916":{"tf":1},"917":{"tf":1.4142135623730951},"920":{"tf":1},"921":{"tf":1},"924":{"tf":1},"926":{"tf":1},"928":{"tf":1},"929":{"tf":1.4142135623730951},"933":{"tf":1.4142135623730951},"944":{"tf":1.4142135623730951},"946":{"tf":1},"959":{"tf":1},"960":{"tf":1},"961":{"tf":1}},"df":166},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"119":{"tf":1},"122":{"tf":1},"168":{"tf":1},"195":{"tf":1.4142135623730951},"198":{"tf":1},"202":{"tf":1},"220":{"tf":1.4142135623730951},"229":{"tf":1},"350":{"tf":1.4142135623730951},"351":{"tf":1.4142135623730951},"354":{"tf":1.4142135623730951},"357":{"tf":1},"403":{"tf":1},"430":{"tf":1.4142135623730951},"433":{"tf":1},"437":{"tf":1},"451":{"tf":1.4142135623730951},"457":{"tf":1},"460":{"tf":1},"621":{"tf":1},"648":{"tf":1.4142135623730951},"651":{"tf":1},"665":{"tf":1.4142135623730951},"671":{"tf":1},"674":{"tf":1},"788":{"tf":1},"831":{"tf":1},"858":{"tf":1.4142135623730951},"861":{"tf":1},"872":{"tf":1.4142135623730951},"881":{"tf":1},"889":{"tf":1},"890":{"tf":1.7320508075688772},"891":{"tf":1.4142135623730951},"893":{"tf":1},"894":{"tf":1},"896":{"tf":1},"905":{"tf":1},"907":{"tf":1.4142135623730951},"908":{"tf":1},"915":{"tf":1.7320508075688772},"916":{"tf":1.4142135623730951},"917":{"tf":1},"924":{"tf":1.4142135623730951},"928":{"tf":1},"932":{"tf":1},"933":{"tf":1}},"df":48}}}}},"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1.4142135623730951}},"df":1,"l":{"docs":{},"df":0,"i":{"docs":{"178":{"tf":1},"413":{"tf":1},"631":{"tf":1}},"df":3}}}}}}},"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"54":{"tf":1},"55":{"tf":1},"81":{"tf":1},"94":{"tf":1.4142135623730951},"116":{"tf":1},"203":{"tf":1},"210":{"tf":1.4142135623730951},"211":{"tf":1},"212":{"tf":1},"213":{"tf":1},"214":{"tf":1},"215":{"tf":1},"216":{"tf":1},"217":{"tf":1},"220":{"tf":1},"232":{"tf":1},"286":{"tf":1},"287":{"tf":1},"312":{"tf":1},"314":{"tf":1},"325":{"tf":1.4142135623730951},"347":{"tf":1},"350":{"tf":1},"351":{"tf":1},"438":{"tf":1},"442":{"tf":1},"443":{"tf":1},"444":{"tf":1},"445":{"tf":1},"446":{"tf":1},"447":{"tf":1},"448":{"tf":1},"451":{"tf":1},"463":{"tf":1},"517":{"tf":1},"518":{"tf":1},"543":{"tf":1},"556":{"tf":1.4142135623730951},"578":{"tf":1},"656":{"tf":1},"657":{"tf":1},"658":{"tf":1},"659":{"tf":1},"660":{"tf":1},"661":{"tf":1},"662":{"tf":1},"665":{"tf":1},"677":{"tf":1},"731":{"tf":1},"732":{"tf":1},"760":{"tf":1},"763":{"tf":1},"784":{"tf":1},"834":{"tf":1},"839":{"tf":1},"868":{"tf":1},"869":{"tf":1},"872":{"tf":1},"881":{"tf":1},"905":{"tf":1},"907":{"tf":1.4142135623730951},"928":{"tf":1.4142135623730951},"933":{"tf":1},"940":{"tf":1},"946":{"tf":1}},"df":65}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"v":{"docs":{"351":{"tf":1.4142135623730951},"354":{"tf":1},"855":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"788":{"tf":1}},"df":1}}}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"14":{"tf":1},"109":{"tf":1},"161":{"tf":1},"246":{"tf":1},"340":{"tf":1},"396":{"tf":1},"477":{"tf":1},"571":{"tf":1},"614":{"tf":1},"691":{"tf":1},"778":{"tf":1},"808":{"tf":1},"824":{"tf":1.4142135623730951},"948":{"tf":1}},"df":14}}}},"a":{"docs":{},"df":0,"g":{"docs":{"39":{"tf":1},"40":{"tf":1},"212":{"tf":1.4142135623730951},"271":{"tf":1},"272":{"tf":1},"443":{"tf":1.4142135623730951},"502":{"tf":1},"503":{"tf":1},"657":{"tf":1.4142135623730951},"716":{"tf":1},"717":{"tf":1},"749":{"tf":1}},"df":12,"i":{"docs":{},"df":0,"n":{"docs":{"210":{"tf":1},"893":{"tf":1},"907":{"tf":1},"933":{"tf":1}},"df":4}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"4":{"tf":1},"43":{"tf":1},"62":{"tf":1},"109":{"tf":1},"116":{"tf":1},"134":{"tf":1.4142135623730951},"149":{"tf":1.4142135623730951},"187":{"tf":1},"192":{"tf":1},"206":{"tf":1},"207":{"tf":2.449489742783178},"229":{"tf":1.4142135623730951},"230":{"tf":1},"231":{"tf":1},"232":{"tf":1.4142135623730951},"233":{"tf":1},"234":{"tf":1},"275":{"tf":1},"294":{"tf":1},"340":{"tf":1},"347":{"tf":1},"369":{"tf":1.4142135623730951},"384":{"tf":1.4142135623730951},"422":{"tf":1},"427":{"tf":1},"460":{"tf":1.4142135623730951},"461":{"tf":1},"462":{"tf":1},"463":{"tf":1.4142135623730951},"464":{"tf":1},"465":{"tf":1},"506":{"tf":1},"525":{"tf":1},"571":{"tf":1},"578":{"tf":1},"587":{"tf":1.4142135623730951},"602":{"tf":1.4142135623730951},"640":{"tf":1},"645":{"tf":1},"674":{"tf":1.4142135623730951},"675":{"tf":1},"676":{"tf":1},"677":{"tf":1.4142135623730951},"678":{"tf":1},"679":{"tf":1},"720":{"tf":1},"784":{"tf":1.4142135623730951},"785":{"tf":1.7320508075688772},"812":{"tf":1.4142135623730951},"821":{"tf":1},"845":{"tf":1},"858":{"tf":1},"881":{"tf":2.6457513110645907},"882":{"tf":1},"883":{"tf":1},"939":{"tf":1.4142135623730951}},"df":56,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"881":{"tf":1.4142135623730951}},"df":1}}}}}},"r":{"docs":{"217":{"tf":1},"231":{"tf":1.7320508075688772},"232":{"tf":1.4142135623730951},"448":{"tf":1},"462":{"tf":1.7320508075688772},"463":{"tf":1.4142135623730951},"662":{"tf":1},"676":{"tf":1.7320508075688772},"677":{"tf":1.4142135623730951},"881":{"tf":2.23606797749979},"889":{"tf":1},"895":{"tf":1.4142135623730951},"902":{"tf":1}},"df":13}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"f":{"docs":{"116":{"tf":1.4142135623730951},"122":{"tf":1},"176":{"tf":1},"188":{"tf":1},"253":{"tf":1},"347":{"tf":1.4142135623730951},"357":{"tf":1},"411":{"tf":1},"423":{"tf":1},"578":{"tf":1.4142135623730951},"629":{"tf":1},"641":{"tf":1},"785":{"tf":1},"839":{"tf":1},"851":{"tf":1},"861":{"tf":1},"894":{"tf":1},"902":{"tf":1}},"df":18}}}},"'":{"docs":{"195":{"tf":1},"237":{"tf":1},"430":{"tf":1},"468":{"tf":1.4142135623730951},"648":{"tf":1},"682":{"tf":1.4142135623730951},"911":{"tf":1}},"df":7}},".":{"docs":{"27":{"tf":1},"137":{"tf":1},"157":{"tf":1},"169":{"tf":1},"182":{"tf":1},"215":{"tf":1},"231":{"tf":1},"259":{"tf":1},"372":{"tf":1},"392":{"tf":1},"404":{"tf":1},"417":{"tf":1},"446":{"tf":1},"462":{"tf":1},"490":{"tf":1},"590":{"tf":1},"610":{"tf":1},"622":{"tf":1},"635":{"tf":1},"660":{"tf":1},"676":{"tf":1},"704":{"tf":1},"797":{"tf":1},"800":{"tf":1},"801":{"tf":1},"803":{"tf":1},"806":{"tf":1},"845":{"tf":1},"861":{"tf":1},"881":{"tf":1},"890":{"tf":1},"895":{"tf":1},"899":{"tf":1},"911":{"tf":1},"929":{"tf":1},"936":{"tf":1}},"df":36},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"28":{"tf":1},"56":{"tf":1},"260":{"tf":1},"288":{"tf":1},"491":{"tf":1},"519":{"tf":1},"705":{"tf":1},"733":{"tf":1},"794":{"tf":1}},"df":9}}},"d":{"docs":{"115":{"tf":1},"116":{"tf":2.6457513110645907},"122":{"tf":2},"125":{"tf":1},"128":{"tf":1},"203":{"tf":1},"207":{"tf":1},"209":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"346":{"tf":1},"347":{"tf":2.6457513110645907},"357":{"tf":2.6457513110645907},"360":{"tf":1},"363":{"tf":1},"438":{"tf":1},"462":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"577":{"tf":1},"578":{"tf":2.6457513110645907},"581":{"tf":1},"676":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"784":{"tf":1},"785":{"tf":1.7320508075688772},"788":{"tf":1},"791":{"tf":1},"881":{"tf":2},"946":{"tf":1},"948":{"tf":2},"961":{"tf":1}},"df":31,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"32":{"tf":1},"94":{"tf":1},"98":{"tf":1},"168":{"tf":1},"264":{"tf":1},"325":{"tf":1},"329":{"tf":1},"403":{"tf":1},"495":{"tf":1},"556":{"tf":1},"560":{"tf":1},"621":{"tf":1},"685":{"tf":1},"709":{"tf":1},"766":{"tf":1},"767":{"tf":1},"831":{"tf":1}},"df":17,"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{"97":{"tf":1},"121":{"tf":1},"122":{"tf":1},"125":{"tf":1},"199":{"tf":1},"328":{"tf":1},"356":{"tf":1},"357":{"tf":1},"360":{"tf":1},"434":{"tf":1},"559":{"tf":1},"652":{"tf":1},"750":{"tf":1},"766":{"tf":1},"862":{"tf":1}},"df":15}}}}},"a":{"docs":{"98":{"tf":1},"119":{"tf":1},"195":{"tf":1},"329":{"tf":1},"354":{"tf":1.7320508075688772},"430":{"tf":1},"560":{"tf":1},"648":{"tf":1}},"df":8}}},"s":{"docs":{},"df":0,"s":{"docs":{},"df":0,"u":{"docs":{"43":{"tf":1},"125":{"tf":1},"275":{"tf":1},"351":{"tf":1},"360":{"tf":1},"506":{"tf":1},"720":{"tf":1},"891":{"tf":1},"915":{"tf":1},"948":{"tf":1}},"df":10,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{"66":{"tf":1},"224":{"tf":1},"225":{"tf":1.4142135623730951},"226":{"tf":1.4142135623730951},"455":{"tf":1},"456":{"tf":1.4142135623730951},"457":{"tf":1.4142135623730951},"528":{"tf":1},"669":{"tf":1},"670":{"tf":1.4142135623730951},"671":{"tf":1.4142135623730951}},"df":11}}}}}}},"i":{"docs":{"240":{"tf":1},"471":{"tf":1}},"df":2,"i":{"docs":{"471":{"tf":1}},"df":1}},"g":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"357":{"tf":1},"946":{"tf":1}},"df":2}}}},"o":{"docs":{"685":{"tf":1.4142135623730951},"691":{"tf":1},"696":{"tf":1.4142135623730951},"697":{"tf":1},"698":{"tf":1.4142135623730951},"740":{"tf":2},"759":{"tf":1},"760":{"tf":1}},"df":8}},"s":{"docs":{},"df":0,"y":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"3":{"tf":1.7320508075688772},"8":{"tf":1},"14":{"tf":1},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"56":{"tf":1},"66":{"tf":1},"122":{"tf":1.4142135623730951},"226":{"tf":2},"240":{"tf":1},"246":{"tf":1},"252":{"tf":1},"288":{"tf":1},"457":{"tf":1.7320508075688772},"471":{"tf":1},"477":{"tf":1},"483":{"tf":1},"519":{"tf":1},"528":{"tf":1},"671":{"tf":1.7320508075688772},"691":{"tf":1},"733":{"tf":1},"866":{"tf":1.4142135623730951},"907":{"tf":1},"915":{"tf":1},"928":{"tf":1},"933":{"tf":1.4142135623730951}},"df":27}}}},"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"82":{"tf":1},"125":{"tf":1},"151":{"tf":1},"313":{"tf":1},"360":{"tf":1},"386":{"tf":1},"544":{"tf":1},"604":{"tf":1},"758":{"tf":1}},"df":9}}},"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}},"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"x":{"docs":{"171":{"tf":1},"225":{"tf":1.4142135623730951},"226":{"tf":1},"406":{"tf":1},"456":{"tf":1.4142135623730951},"457":{"tf":1},"624":{"tf":1},"670":{"tf":1.4142135623730951},"671":{"tf":1},"834":{"tf":1},"877":{"tf":1.4142135623730951}},"df":11}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"50":{"tf":1},"116":{"tf":1.7320508075688772},"125":{"tf":1},"128":{"tf":1},"137":{"tf":1.4142135623730951},"168":{"tf":1},"210":{"tf":1},"226":{"tf":1.4142135623730951},"282":{"tf":1},"347":{"tf":1.7320508075688772},"360":{"tf":1},"363":{"tf":1},"372":{"tf":1.4142135623730951},"403":{"tf":1},"457":{"tf":1.4142135623730951},"513":{"tf":1},"578":{"tf":1.7320508075688772},"581":{"tf":1},"590":{"tf":1.4142135623730951},"621":{"tf":1},"671":{"tf":1.4142135623730951},"831":{"tf":1},"832":{"tf":1},"886":{"tf":1},"892":{"tf":1},"905":{"tf":1},"911":{"tf":1},"924":{"tf":1},"925":{"tf":1},"936":{"tf":1},"951":{"tf":1},"954":{"tf":1.7320508075688772},"961":{"tf":1}},"df":34}},"c":{"docs":{"54":{"tf":1},"119":{"tf":1},"125":{"tf":1},"157":{"tf":1.4142135623730951},"169":{"tf":1},"182":{"tf":1},"286":{"tf":1},"350":{"tf":1},"360":{"tf":1},"392":{"tf":1.4142135623730951},"404":{"tf":1},"417":{"tf":1},"517":{"tf":1},"610":{"tf":1.4142135623730951},"622":{"tf":1},"635":{"tf":1},"731":{"tf":1},"788":{"tf":1},"832":{"tf":1},"858":{"tf":1}},"df":20}},"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"11":{"tf":1},"15":{"tf":1},"16":{"tf":1},"47":{"tf":1},"50":{"tf":1},"59":{"tf":1},"64":{"tf":1},"87":{"tf":1},"94":{"tf":1},"119":{"tf":1.4142135623730951},"125":{"tf":1},"209":{"tf":1},"231":{"tf":1},"232":{"tf":1.4142135623730951},"243":{"tf":1},"247":{"tf":1},"248":{"tf":1},"279":{"tf":1},"282":{"tf":1},"291":{"tf":1},"296":{"tf":1},"318":{"tf":1},"325":{"tf":1},"354":{"tf":1.4142135623730951},"360":{"tf":1},"462":{"tf":1},"463":{"tf":1.4142135623730951},"474":{"tf":1},"478":{"tf":1},"479":{"tf":1},"510":{"tf":1},"513":{"tf":1},"522":{"tf":1},"526":{"tf":1},"549":{"tf":1},"556":{"tf":1},"676":{"tf":1},"677":{"tf":1.4142135623730951},"688":{"tf":1},"692":{"tf":1},"693":{"tf":1},"724":{"tf":1},"727":{"tf":1},"736":{"tf":1},"760":{"tf":1},"763":{"tf":1.4142135623730951},"881":{"tf":1.7320508075688772}},"df":47,"i":{"docs":{"43":{"tf":1},"67":{"tf":1},"73":{"tf":1},"81":{"tf":1},"144":{"tf":1},"175":{"tf":1},"209":{"tf":1},"237":{"tf":1},"275":{"tf":1},"298":{"tf":1},"304":{"tf":1},"312":{"tf":1},"379":{"tf":1},"410":{"tf":1},"468":{"tf":1},"506":{"tf":1},"529":{"tf":1},"535":{"tf":1},"543":{"tf":1},"597":{"tf":1},"628":{"tf":1},"682":{"tf":1},"720":{"tf":1},"743":{"tf":1},"757":{"tf":1},"807":{"tf":1},"821":{"tf":1},"824":{"tf":1},"838":{"tf":1},"858":{"tf":1}},"df":30,"f":{"docs":{},"df":0,"i":{"docs":{"788":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}},"r":{"docs":{"840":{"tf":1}},"df":1}}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"128":{"tf":1},"195":{"tf":1},"363":{"tf":1},"430":{"tf":1},"581":{"tf":1},"648":{"tf":1},"791":{"tf":1},"840":{"tf":1},"858":{"tf":1.4142135623730951},"912":{"tf":1},"916":{"tf":1},"945":{"tf":1},"958":{"tf":1}},"df":13,"l":{"docs":{},"df":0,"i":{"docs":{"177":{"tf":1},"412":{"tf":1},"630":{"tf":1},"954":{"tf":1}},"df":4}}}}}},"u":{"docs":{},"df":0,"l":{"docs":{"696":{"tf":1},"697":{"tf":1},"698":{"tf":1}},"df":3,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,".":{"docs":{},"df":0,"z":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"740":{"tf":1}},"df":1}}}}}}}}}}},"d":{"docs":{},"df":0,"e":{"docs":{"15":{"tf":1},"38":{"tf":1},"56":{"tf":1.4142135623730951},"247":{"tf":1},"270":{"tf":1},"288":{"tf":1.4142135623730951},"478":{"tf":1},"501":{"tf":1},"519":{"tf":1.4142135623730951},"692":{"tf":1},"715":{"tf":1},"733":{"tf":1.4142135623730951},"890":{"tf":1}},"df":13}},"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1},"272":{"tf":1},"503":{"tf":1},"717":{"tf":1},"728":{"tf":1},"824":{"tf":1},"890":{"tf":1},"907":{"tf":1.7320508075688772},"933":{"tf":1},"958":{"tf":1}},"df":10}}},"e":{"docs":{"43":{"tf":1}},"df":1}},"g":{"docs":{},"df":0,"n":{"docs":{"125":{"tf":1},"168":{"tf":1.7320508075688772},"360":{"tf":1},"621":{"tf":1.7320508075688772}},"df":4,"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2}}}}}}}}}}},"z":{"docs":{},"df":0,"e":{"docs":{"205":{"tf":1},"440":{"tf":1}},"df":2}},"b":{"docs":{},"df":0,"l":{"docs":{"802":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"4":{"tf":1},"15":{"tf":1.4142135623730951},"16":{"tf":1},"20":{"tf":1.4142135623730951},"21":{"tf":1},"50":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"66":{"tf":1},"81":{"tf":2.23606797749979},"86":{"tf":1.4142135623730951},"122":{"tf":1},"128":{"tf":1},"131":{"tf":1.4142135623730951},"132":{"tf":1},"134":{"tf":1.7320508075688772},"137":{"tf":1},"140":{"tf":1.7320508075688772},"150":{"tf":1.4142135623730951},"161":{"tf":1},"169":{"tf":1},"176":{"tf":1},"177":{"tf":1},"178":{"tf":1},"182":{"tf":1.7320508075688772},"187":{"tf":2.449489742783178},"188":{"tf":1.4142135623730951},"189":{"tf":1},"192":{"tf":2},"195":{"tf":1},"199":{"tf":1},"203":{"tf":1.7320508075688772},"205":{"tf":1.4142135623730951},"217":{"tf":2},"231":{"tf":1},"232":{"tf":1.7320508075688772},"237":{"tf":1},"247":{"tf":1.4142135623730951},"248":{"tf":1},"252":{"tf":1},"253":{"tf":1.4142135623730951},"282":{"tf":1.7320508075688772},"283":{"tf":1.4142135623730951},"312":{"tf":2.23606797749979},"317":{"tf":1.4142135623730951},"350":{"tf":1},"356":{"tf":1},"357":{"tf":1.4142135623730951},"363":{"tf":1},"366":{"tf":1.4142135623730951},"367":{"tf":1},"369":{"tf":1.7320508075688772},"372":{"tf":1},"375":{"tf":1.7320508075688772},"385":{"tf":1.4142135623730951},"396":{"tf":1},"404":{"tf":1},"411":{"tf":1},"412":{"tf":1},"413":{"tf":1},"417":{"tf":1.7320508075688772},"422":{"tf":2.449489742783178},"423":{"tf":1.4142135623730951},"424":{"tf":1},"427":{"tf":2},"430":{"tf":1},"434":{"tf":1},"438":{"tf":1.7320508075688772},"440":{"tf":1.4142135623730951},"448":{"tf":2},"457":{"tf":1},"462":{"tf":1},"463":{"tf":1.7320508075688772},"468":{"tf":1},"478":{"tf":1.4142135623730951},"479":{"tf":1},"483":{"tf":1.4142135623730951},"484":{"tf":1},"513":{"tf":1.7320508075688772},"514":{"tf":1.4142135623730951},"528":{"tf":1},"543":{"tf":2.23606797749979},"548":{"tf":1.4142135623730951},"581":{"tf":1},"584":{"tf":1.4142135623730951},"585":{"tf":1},"587":{"tf":1.7320508075688772},"590":{"tf":1},"593":{"tf":1.7320508075688772},"603":{"tf":1.4142135623730951},"614":{"tf":1},"622":{"tf":1},"629":{"tf":1},"630":{"tf":1},"631":{"tf":1},"635":{"tf":1.7320508075688772},"640":{"tf":2.449489742783178},"641":{"tf":1.4142135623730951},"642":{"tf":1},"645":{"tf":2},"648":{"tf":1},"652":{"tf":1},"662":{"tf":2},"671":{"tf":1},"676":{"tf":1},"677":{"tf":1.7320508075688772},"682":{"tf":1},"692":{"tf":1.4142135623730951},"693":{"tf":1},"697":{"tf":1.4142135623730951},"698":{"tf":1.4142135623730951},"727":{"tf":1.4142135623730951},"728":{"tf":1.4142135623730951},"757":{"tf":2.23606797749979},"791":{"tf":1},"794":{"tf":1.4142135623730951},"795":{"tf":1},"797":{"tf":1.4142135623730951},"803":{"tf":1.4142135623730951},"812":{"tf":1},"824":{"tf":1},"840":{"tf":1},"841":{"tf":1},"844":{"tf":1},"845":{"tf":1.4142135623730951},"850":{"tf":2.6457513110645907},"851":{"tf":1.4142135623730951},"852":{"tf":1.4142135623730951},"855":{"tf":1.4142135623730951},"862":{"tf":1},"869":{"tf":2},"881":{"tf":2},"891":{"tf":1.7320508075688772},"892":{"tf":2.23606797749979},"893":{"tf":1},"894":{"tf":1.7320508075688772},"895":{"tf":1.4142135623730951},"896":{"tf":2},"897":{"tf":1},"898":{"tf":1},"899":{"tf":1},"901":{"tf":2},"906":{"tf":1},"907":{"tf":1.4142135623730951},"908":{"tf":1.4142135623730951},"909":{"tf":1.4142135623730951},"911":{"tf":1},"912":{"tf":1.7320508075688772},"913":{"tf":1.7320508075688772},"916":{"tf":2.449489742783178},"917":{"tf":1},"920":{"tf":1.4142135623730951},"922":{"tf":1},"924":{"tf":1.4142135623730951},"926":{"tf":1},"935":{"tf":1},"936":{"tf":1.4142135623730951},"939":{"tf":2.23606797749979},"945":{"tf":1},"951":{"tf":1},"954":{"tf":1.4142135623730951},"955":{"tf":1},"960":{"tf":1.4142135623730951}},"df":163,"u":{"docs":{},"df":0,"p":{"docs":{"4":{"tf":1},"19":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"51":{"tf":1.4142135623730951},"62":{"tf":1},"66":{"tf":1},"67":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"115":{"tf":1},"116":{"tf":1},"119":{"tf":1},"140":{"tf":1.4142135623730951},"187":{"tf":1},"192":{"tf":1},"223":{"tf":1},"224":{"tf":1},"226":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"237":{"tf":1},"240":{"tf":1},"251":{"tf":1.4142135623730951},"252":{"tf":1.4142135623730951},"253":{"tf":1.4142135623730951},"283":{"tf":1.4142135623730951},"294":{"tf":1.4142135623730951},"297":{"tf":1},"298":{"tf":1.4142135623730951},"312":{"tf":1.7320508075688772},"328":{"tf":1},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1.4142135623730951},"354":{"tf":1},"375":{"tf":1.4142135623730951},"422":{"tf":1},"427":{"tf":1},"454":{"tf":1},"455":{"tf":1},"457":{"tf":1.7320508075688772},"463":{"tf":1.4142135623730951},"468":{"tf":1},"482":{"tf":1.4142135623730951},"483":{"tf":1.4142135623730951},"484":{"tf":1.4142135623730951},"514":{"tf":1.4142135623730951},"525":{"tf":1},"528":{"tf":1},"529":{"tf":1.4142135623730951},"543":{"tf":1.7320508075688772},"577":{"tf":1},"578":{"tf":1},"593":{"tf":1.4142135623730951},"640":{"tf":1},"645":{"tf":1},"668":{"tf":1},"669":{"tf":1},"671":{"tf":1.7320508075688772},"677":{"tf":1.4142135623730951},"682":{"tf":1},"696":{"tf":1.4142135623730951},"697":{"tf":1},"698":{"tf":1.4142135623730951},"728":{"tf":1},"743":{"tf":1},"748":{"tf":1},"749":{"tf":1},"757":{"tf":1.4142135623730951},"784":{"tf":1},"803":{"tf":1.4142135623730951},"850":{"tf":1},"855":{"tf":1},"875":{"tf":1},"876":{"tf":1},"881":{"tf":1.4142135623730951},"892":{"tf":1},"896":{"tf":1},"906":{"tf":1},"907":{"tf":2},"908":{"tf":1},"909":{"tf":1},"911":{"tf":2},"915":{"tf":1.4142135623730951},"916":{"tf":1},"921":{"tf":1}},"df":85,"\"":{"docs":{},"df":0,"/":{"docs":{},"df":0,"\"":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"15":{"tf":1},"247":{"tf":1},"478":{"tf":1}},"df":3}}}}}}}}}},"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{},"df":0,"p":{"docs":{"692":{"tf":1},"728":{"tf":1}},"df":2}}}}}}}}}},"'":{"docs":{"86":{"tf":1},"317":{"tf":1},"548":{"tf":1}},"df":3},"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"204":{"tf":1},"439":{"tf":1}},"df":2}}}},"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"c":{"docs":{"205":{"tf":1},"440":{"tf":1}},"df":2}}},"s":{"docs":{},"df":0,"i":{"docs":{},"df":0,"z":{"docs":{"205":{"tf":1},"440":{"tf":1}},"df":2}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"866":{"tf":1}},"df":1}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"897":{"tf":1}},"df":1}}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"939":{"tf":1}},"df":1}}}},"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"16":{"tf":1},"43":{"tf":1},"56":{"tf":1},"66":{"tf":1},"68":{"tf":1},"72":{"tf":1},"77":{"tf":1},"81":{"tf":1},"109":{"tf":1.4142135623730951},"112":{"tf":1},"115":{"tf":1},"119":{"tf":1.7320508075688772},"120":{"tf":1},"125":{"tf":1.4142135623730951},"128":{"tf":1},"137":{"tf":1.4142135623730951},"140":{"tf":1},"143":{"tf":1},"149":{"tf":1},"151":{"tf":1},"176":{"tf":1},"177":{"tf":1},"181":{"tf":1},"187":{"tf":1},"192":{"tf":1},"232":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"248":{"tf":1},"253":{"tf":1},"275":{"tf":1},"288":{"tf":1},"297":{"tf":1},"299":{"tf":1},"303":{"tf":1},"308":{"tf":1},"312":{"tf":1},"340":{"tf":1.4142135623730951},"343":{"tf":1},"346":{"tf":1},"350":{"tf":1},"354":{"tf":1.7320508075688772},"355":{"tf":1},"360":{"tf":1.4142135623730951},"363":{"tf":1},"372":{"tf":1.4142135623730951},"375":{"tf":1},"378":{"tf":1},"384":{"tf":1},"386":{"tf":1},"411":{"tf":1},"412":{"tf":1},"416":{"tf":1},"422":{"tf":1},"427":{"tf":1},"463":{"tf":1.4142135623730951},"479":{"tf":1},"506":{"tf":1},"519":{"tf":1},"528":{"tf":1},"530":{"tf":1},"534":{"tf":1},"539":{"tf":1},"543":{"tf":1},"571":{"tf":1.4142135623730951},"574":{"tf":1},"577":{"tf":1},"581":{"tf":1},"590":{"tf":1.4142135623730951},"593":{"tf":1},"596":{"tf":1},"602":{"tf":1},"604":{"tf":1},"629":{"tf":1},"630":{"tf":1},"634":{"tf":1},"640":{"tf":1},"645":{"tf":1},"677":{"tf":1.4142135623730951},"693":{"tf":1},"720":{"tf":1},"733":{"tf":1},"742":{"tf":1},"747":{"tf":1},"748":{"tf":1},"749":{"tf":1},"758":{"tf":1},"766":{"tf":1},"778":{"tf":1.4142135623730951},"784":{"tf":1},"800":{"tf":1},"806":{"tf":1},"812":{"tf":1},"840":{"tf":1},"844":{"tf":1},"850":{"tf":1},"855":{"tf":1},"858":{"tf":1},"881":{"tf":1.4142135623730951},"893":{"tf":1},"895":{"tf":1},"907":{"tf":1},"924":{"tf":1},"929":{"tf":1},"934":{"tf":1},"943":{"tf":1},"963":{"tf":1}},"df":107}}}},"u":{"docs":{},"df":0,"r":{"docs":{"14":{"tf":1},"246":{"tf":1},"477":{"tf":1},"691":{"tf":1}},"df":4}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"31":{"tf":1.7320508075688772},"32":{"tf":1},"33":{"tf":1.7320508075688772},"34":{"tf":1},"38":{"tf":1},"39":{"tf":1.4142135623730951},"50":{"tf":1},"56":{"tf":1},"59":{"tf":1},"81":{"tf":1},"82":{"tf":1},"101":{"tf":1},"102":{"tf":1},"105":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"140":{"tf":1},"144":{"tf":1},"149":{"tf":1},"157":{"tf":1},"169":{"tf":1},"175":{"tf":1.4142135623730951},"176":{"tf":1.4142135623730951},"178":{"tf":1},"181":{"tf":1.4142135623730951},"182":{"tf":1.7320508075688772},"226":{"tf":1.7320508075688772},"263":{"tf":1.7320508075688772},"264":{"tf":1},"265":{"tf":1.7320508075688772},"266":{"tf":1},"270":{"tf":1},"271":{"tf":1.4142135623730951},"282":{"tf":1},"288":{"tf":1},"291":{"tf":1},"294":{"tf":1},"312":{"tf":1},"313":{"tf":1},"332":{"tf":1},"333":{"tf":1},"336":{"tf":1.4142135623730951},"350":{"tf":1},"354":{"tf":1},"360":{"tf":1.4142135623730951},"375":{"tf":1},"379":{"tf":1},"384":{"tf":1},"392":{"tf":1},"404":{"tf":1},"410":{"tf":1.4142135623730951},"411":{"tf":1.4142135623730951},"413":{"tf":1},"416":{"tf":1.4142135623730951},"417":{"tf":1.7320508075688772},"457":{"tf":1.4142135623730951},"494":{"tf":1.7320508075688772},"495":{"tf":1},"496":{"tf":1.7320508075688772},"497":{"tf":1},"501":{"tf":1},"502":{"tf":1.4142135623730951},"513":{"tf":1},"519":{"tf":1},"522":{"tf":1},"526":{"tf":1.4142135623730951},"543":{"tf":1},"544":{"tf":1},"563":{"tf":1},"564":{"tf":1},"567":{"tf":1.4142135623730951},"593":{"tf":1},"597":{"tf":1},"602":{"tf":1},"610":{"tf":1},"622":{"tf":1},"628":{"tf":1.4142135623730951},"629":{"tf":1.4142135623730951},"631":{"tf":1},"634":{"tf":1.4142135623730951},"635":{"tf":1.7320508075688772},"671":{"tf":1.4142135623730951},"708":{"tf":1.7320508075688772},"709":{"tf":1},"710":{"tf":1.7320508075688772},"711":{"tf":1},"715":{"tf":1},"716":{"tf":1.4142135623730951},"733":{"tf":1},"758":{"tf":1},"770":{"tf":1},"771":{"tf":1},"774":{"tf":1.4142135623730951},"803":{"tf":1},"806":{"tf":1},"807":{"tf":1},"812":{"tf":1},"824":{"tf":1.4142135623730951},"832":{"tf":1},"838":{"tf":1.4142135623730951},"839":{"tf":1.4142135623730951},"841":{"tf":1},"844":{"tf":1.4142135623730951},"845":{"tf":2},"878":{"tf":1},"889":{"tf":1},"895":{"tf":1},"898":{"tf":1},"902":{"tf":1},"905":{"tf":1},"907":{"tf":1},"913":{"tf":1.4142135623730951},"916":{"tf":1.4142135623730951},"920":{"tf":1},"922":{"tf":1},"926":{"tf":1},"932":{"tf":1},"933":{"tf":1}},"df":117,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"840":{"tf":1.4142135623730951},"845":{"tf":1},"855":{"tf":1}},"df":3}}}}}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"c":{"docs":{"4":{"tf":1},"20":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"46":{"tf":1},"47":{"tf":1.4142135623730951},"59":{"tf":1},"62":{"tf":1},"66":{"tf":1},"67":{"tf":1},"72":{"tf":1},"73":{"tf":2},"74":{"tf":2.23606797749979},"77":{"tf":1.4142135623730951},"78":{"tf":1.4142135623730951},"81":{"tf":1},"82":{"tf":2.6457513110645907},"86":{"tf":2},"87":{"tf":1},"94":{"tf":1},"109":{"tf":2},"128":{"tf":1},"137":{"tf":1},"146":{"tf":1.4142135623730951},"168":{"tf":2.23606797749979},"187":{"tf":1},"223":{"tf":1},"224":{"tf":1},"229":{"tf":1.4142135623730951},"237":{"tf":1.4142135623730951},"240":{"tf":1},"252":{"tf":1.4142135623730951},"253":{"tf":1.4142135623730951},"278":{"tf":1},"279":{"tf":1.4142135623730951},"291":{"tf":1},"294":{"tf":1.4142135623730951},"297":{"tf":1},"298":{"tf":1},"303":{"tf":1},"304":{"tf":2},"305":{"tf":2.23606797749979},"308":{"tf":1.4142135623730951},"309":{"tf":1.4142135623730951},"312":{"tf":1},"313":{"tf":2.6457513110645907},"317":{"tf":2},"318":{"tf":1},"325":{"tf":1},"328":{"tf":1},"340":{"tf":2},"363":{"tf":1},"372":{"tf":1},"381":{"tf":1.4142135623730951},"403":{"tf":2.23606797749979},"422":{"tf":1},"454":{"tf":1},"455":{"tf":1},"457":{"tf":1},"460":{"tf":1.4142135623730951},"468":{"tf":1.4142135623730951},"483":{"tf":1.7320508075688772},"484":{"tf":1.4142135623730951},"509":{"tf":1},"510":{"tf":1.4142135623730951},"522":{"tf":1},"525":{"tf":1},"528":{"tf":1},"529":{"tf":1},"534":{"tf":1},"535":{"tf":2},"536":{"tf":2.23606797749979},"539":{"tf":1.4142135623730951},"540":{"tf":1.4142135623730951},"543":{"tf":1},"544":{"tf":2.6457513110645907},"548":{"tf":2},"549":{"tf":1},"556":{"tf":1},"571":{"tf":2},"581":{"tf":1},"590":{"tf":1},"599":{"tf":1.4142135623730951},"621":{"tf":2.23606797749979},"640":{"tf":1},"668":{"tf":1},"669":{"tf":1},"671":{"tf":1},"674":{"tf":1.4142135623730951},"682":{"tf":1.4142135623730951},"698":{"tf":1.4142135623730951},"723":{"tf":1},"724":{"tf":1.4142135623730951},"736":{"tf":1},"739":{"tf":1},"742":{"tf":1},"743":{"tf":1},"747":{"tf":1},"748":{"tf":2},"749":{"tf":1.4142135623730951},"750":{"tf":1.7320508075688772},"751":{"tf":1.7320508075688772},"754":{"tf":1},"757":{"tf":1},"758":{"tf":2.6457513110645907},"760":{"tf":1},"763":{"tf":1},"778":{"tf":2.449489742783178},"809":{"tf":1.4142135623730951},"831":{"tf":2.23606797749979},"850":{"tf":1},"875":{"tf":1},"876":{"tf":1},"881":{"tf":1.4142135623730951},"892":{"tf":1}},"df":114}}}}},"n":{"docs":{},"df":0,"d":{"docs":{"5":{"tf":1}},"df":1},"t":{"docs":{"15":{"tf":1},"247":{"tf":1},"478":{"tf":1},"692":{"tf":1}},"df":4},"s":{"docs":{"168":{"tf":1},"403":{"tf":1},"621":{"tf":1},"767":{"tf":1},"824":{"tf":1},"831":{"tf":1},"855":{"tf":1}},"df":7,"i":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"275":{"tf":1},"350":{"tf":1},"506":{"tf":1},"720":{"tf":1}},"df":5},"b":{"docs":{},"df":0,"l":{"docs":{"831":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"14":{"tf":1},"15":{"tf":1.4142135623730951},"21":{"tf":1.4142135623730951},"26":{"tf":1.4142135623730951},"27":{"tf":1},"33":{"tf":1},"38":{"tf":1},"43":{"tf":1},"50":{"tf":1},"54":{"tf":1},"64":{"tf":1.4142135623730951},"65":{"tf":1},"67":{"tf":1},"73":{"tf":1},"74":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"86":{"tf":1},"90":{"tf":1},"101":{"tf":1},"102":{"tf":2},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"119":{"tf":1},"125":{"tf":1},"131":{"tf":1},"132":{"tf":1},"134":{"tf":1.7320508075688772},"140":{"tf":2},"150":{"tf":1},"155":{"tf":1},"158":{"tf":1},"168":{"tf":1},"169":{"tf":1},"171":{"tf":1},"176":{"tf":1},"177":{"tf":1},"178":{"tf":1},"182":{"tf":1.7320508075688772},"184":{"tf":1.4142135623730951},"192":{"tf":1},"195":{"tf":1},"202":{"tf":1.4142135623730951},"203":{"tf":1.7320508075688772},"204":{"tf":1.7320508075688772},"207":{"tf":2},"208":{"tf":1},"209":{"tf":1},"215":{"tf":1},"216":{"tf":1},"229":{"tf":1.4142135623730951},"230":{"tf":1},"231":{"tf":2.23606797749979},"232":{"tf":1.4142135623730951},"246":{"tf":1},"247":{"tf":1.4142135623730951},"253":{"tf":1.4142135623730951},"258":{"tf":1.4142135623730951},"259":{"tf":1},"265":{"tf":1},"270":{"tf":1},"275":{"tf":1},"282":{"tf":1},"286":{"tf":1},"294":{"tf":1},"295":{"tf":1.4142135623730951},"296":{"tf":1.4142135623730951},"298":{"tf":1},"304":{"tf":1},"305":{"tf":1.4142135623730951},"308":{"tf":1.4142135623730951},"317":{"tf":1},"321":{"tf":1},"332":{"tf":1},"333":{"tf":2},"334":{"tf":1.4142135623730951},"335":{"tf":1.4142135623730951},"336":{"tf":1.4142135623730951},"340":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"354":{"tf":1},"360":{"tf":1},"366":{"tf":1},"367":{"tf":1},"369":{"tf":1.7320508075688772},"375":{"tf":2},"385":{"tf":1},"390":{"tf":1},"393":{"tf":1},"403":{"tf":1},"404":{"tf":1},"406":{"tf":1},"411":{"tf":1},"412":{"tf":1},"413":{"tf":1},"417":{"tf":1.7320508075688772},"419":{"tf":1.4142135623730951},"427":{"tf":1},"430":{"tf":1},"437":{"tf":1.4142135623730951},"438":{"tf":1.7320508075688772},"439":{"tf":2},"441":{"tf":1},"446":{"tf":1},"447":{"tf":1},"460":{"tf":1.4142135623730951},"461":{"tf":1},"462":{"tf":2.23606797749979},"463":{"tf":1.4142135623730951},"477":{"tf":1},"478":{"tf":1.4142135623730951},"484":{"tf":1.4142135623730951},"489":{"tf":2},"490":{"tf":1},"496":{"tf":1},"501":{"tf":1},"506":{"tf":1},"513":{"tf":1},"517":{"tf":1},"525":{"tf":1},"526":{"tf":1.4142135623730951},"527":{"tf":1},"529":{"tf":1},"535":{"tf":1},"536":{"tf":1.4142135623730951},"539":{"tf":1.4142135623730951},"548":{"tf":1},"552":{"tf":1},"563":{"tf":1},"564":{"tf":2},"565":{"tf":1.4142135623730951},"566":{"tf":1.4142135623730951},"567":{"tf":1.4142135623730951},"571":{"tf":1.4142135623730951},"578":{"tf":1.4142135623730951},"584":{"tf":1},"585":{"tf":1},"587":{"tf":1.7320508075688772},"593":{"tf":2},"603":{"tf":1},"608":{"tf":1},"611":{"tf":1},"621":{"tf":1},"622":{"tf":1},"624":{"tf":1},"629":{"tf":1},"630":{"tf":1},"631":{"tf":1},"635":{"tf":1.7320508075688772},"637":{"tf":1.4142135623730951},"645":{"tf":1},"648":{"tf":1},"655":{"tf":1.4142135623730951},"660":{"tf":1},"661":{"tf":1},"674":{"tf":1.4142135623730951},"675":{"tf":1},"676":{"tf":2.23606797749979},"677":{"tf":1.4142135623730951},"691":{"tf":1.4142135623730951},"692":{"tf":1.4142135623730951},"698":{"tf":1.4142135623730951},"703":{"tf":2.23606797749979},"704":{"tf":1},"710":{"tf":1},"715":{"tf":1},"720":{"tf":1},"727":{"tf":1},"731":{"tf":1},"740":{"tf":2.449489742783178},"741":{"tf":1.7320508075688772},"742":{"tf":1.4142135623730951},"743":{"tf":1.4142135623730951},"749":{"tf":1.7320508075688772},"750":{"tf":1},"751":{"tf":1.4142135623730951},"754":{"tf":1},"770":{"tf":1},"771":{"tf":1.7320508075688772},"772":{"tf":1},"773":{"tf":1.4142135623730951},"774":{"tf":1.4142135623730951},"794":{"tf":1},"795":{"tf":1},"797":{"tf":1.4142135623730951},"803":{"tf":2},"813":{"tf":1},"818":{"tf":1},"831":{"tf":1},"832":{"tf":1},"834":{"tf":1},"839":{"tf":1},"845":{"tf":1.4142135623730951},"858":{"tf":1.4142135623730951},"865":{"tf":1.4142135623730951},"866":{"tf":1},"868":{"tf":1.4142135623730951},"881":{"tf":3.1622776601683795},"890":{"tf":1},"894":{"tf":1.4142135623730951},"896":{"tf":1},"907":{"tf":1},"909":{"tf":1},"910":{"tf":1},"912":{"tf":1},"915":{"tf":1.7320508075688772},"921":{"tf":1},"925":{"tf":1},"926":{"tf":1},"936":{"tf":1.4142135623730951},"939":{"tf":1.7320508075688772},"941":{"tf":1},"949":{"tf":1}},"df":215,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"207":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"207":{"tf":1}},"df":1}}}}}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"208":{"tf":1},"441":{"tf":1}},"df":2}}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{"209":{"tf":1}},"df":1}}}}}}},"e":{"docs":{"15":{"tf":1},"20":{"tf":1},"21":{"tf":1},"27":{"tf":1},"39":{"tf":1},"47":{"tf":1},"56":{"tf":1},"67":{"tf":1.4142135623730951},"73":{"tf":1.4142135623730951},"74":{"tf":1.4142135623730951},"77":{"tf":1},"86":{"tf":1},"106":{"tf":1},"115":{"tf":1},"122":{"tf":1},"125":{"tf":1.4142135623730951},"134":{"tf":1},"145":{"tf":1},"149":{"tf":1},"168":{"tf":1.4142135623730951},"176":{"tf":1},"177":{"tf":1},"181":{"tf":1},"195":{"tf":1},"199":{"tf":1},"215":{"tf":1},"225":{"tf":1},"247":{"tf":1},"252":{"tf":1},"253":{"tf":1},"259":{"tf":1},"271":{"tf":1},"279":{"tf":1},"288":{"tf":1},"298":{"tf":1.4142135623730951},"304":{"tf":1.4142135623730951},"305":{"tf":2},"308":{"tf":1},"317":{"tf":1},"337":{"tf":1},"346":{"tf":1},"354":{"tf":1},"357":{"tf":1},"360":{"tf":1.4142135623730951},"369":{"tf":1},"380":{"tf":1},"384":{"tf":1},"403":{"tf":1.4142135623730951},"411":{"tf":1},"412":{"tf":1},"416":{"tf":1},"430":{"tf":1},"434":{"tf":1},"446":{"tf":1},"456":{"tf":1},"478":{"tf":1},"483":{"tf":1},"484":{"tf":1.4142135623730951},"490":{"tf":1},"502":{"tf":1},"510":{"tf":1},"519":{"tf":1},"529":{"tf":1.4142135623730951},"535":{"tf":1.4142135623730951},"536":{"tf":1.4142135623730951},"539":{"tf":1},"548":{"tf":1},"568":{"tf":1},"577":{"tf":1},"587":{"tf":1},"598":{"tf":1},"602":{"tf":1},"621":{"tf":1.4142135623730951},"629":{"tf":1},"630":{"tf":1},"634":{"tf":1},"648":{"tf":1},"652":{"tf":1},"660":{"tf":1},"670":{"tf":1},"692":{"tf":1},"697":{"tf":1},"698":{"tf":1},"704":{"tf":1},"727":{"tf":1},"728":{"tf":1},"750":{"tf":1},"751":{"tf":1.4142135623730951},"754":{"tf":1},"775":{"tf":1},"778":{"tf":1},"797":{"tf":1},"808":{"tf":1},"818":{"tf":1},"827":{"tf":1},"831":{"tf":1.4142135623730951},"839":{"tf":1.7320508075688772},"840":{"tf":1},"852":{"tf":1},"858":{"tf":1.7320508075688772},"862":{"tf":1},"877":{"tf":1},"895":{"tf":1},"899":{"tf":1},"900":{"tf":1},"901":{"tf":1},"910":{"tf":1},"911":{"tf":1},"913":{"tf":1},"915":{"tf":1.4142135623730951},"917":{"tf":1.4142135623730951},"922":{"tf":1},"936":{"tf":1.4142135623730951},"944":{"tf":1},"954":{"tf":1},"959":{"tf":1},"960":{"tf":1},"961":{"tf":1}},"df":118,"n":{"docs":{"50":{"tf":1},"187":{"tf":1},"203":{"tf":1},"282":{"tf":1},"422":{"tf":1},"438":{"tf":1},"513":{"tf":1},"640":{"tf":1},"928":{"tf":1},"963":{"tf":1}},"df":10}},"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"37":{"tf":1},"116":{"tf":2},"125":{"tf":1},"209":{"tf":1.4142135623730951},"217":{"tf":2.23606797749979},"269":{"tf":1},"347":{"tf":2},"350":{"tf":1},"360":{"tf":1},"448":{"tf":2.23606797749979},"500":{"tf":1},"578":{"tf":2},"662":{"tf":2.23606797749979},"714":{"tf":1},"785":{"tf":1},"869":{"tf":1.4142135623730951},"886":{"tf":1},"893":{"tf":1},"902":{"tf":1},"913":{"tf":1}},"df":20}}},"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"43":{"tf":2.23606797749979},"125":{"tf":1.4142135623730951},"275":{"tf":2.23606797749979},"360":{"tf":1.4142135623730951},"506":{"tf":2.23606797749979},"720":{"tf":2.23606797749979}},"df":6}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"119":{"tf":1},"125":{"tf":1},"131":{"tf":1},"177":{"tf":1},"192":{"tf":1.4142135623730951},"354":{"tf":1.4142135623730951},"360":{"tf":1},"366":{"tf":1},"412":{"tf":1},"427":{"tf":1.4142135623730951},"584":{"tf":1},"630":{"tf":1},"645":{"tf":1.4142135623730951},"770":{"tf":1},"794":{"tf":1},"840":{"tf":1},"890":{"tf":1.4142135623730951},"915":{"tf":1},"929":{"tf":1},"936":{"tf":1},"938":{"tf":1},"939":{"tf":2}},"df":22}}},"r":{"docs":{},"df":0,"v":{"docs":{"125":{"tf":1},"360":{"tf":1},"758":{"tf":1}},"df":3},"i":{"docs":{"231":{"tf":1},"232":{"tf":1.4142135623730951},"462":{"tf":1},"463":{"tf":1.4142135623730951},"676":{"tf":1},"677":{"tf":1.4142135623730951},"749":{"tf":1},"881":{"tf":1.7320508075688772},"907":{"tf":1}},"df":9}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"15":{"tf":1.4142135623730951},"21":{"tf":1},"38":{"tf":1},"81":{"tf":1.4142135623730951},"87":{"tf":1},"122":{"tf":1.4142135623730951},"139":{"tf":1},"140":{"tf":1},"220":{"tf":1.7320508075688772},"224":{"tf":1},"232":{"tf":1.4142135623730951},"247":{"tf":1.4142135623730951},"270":{"tf":1},"312":{"tf":1.4142135623730951},"314":{"tf":1},"318":{"tf":1},"351":{"tf":1},"354":{"tf":1},"357":{"tf":1.4142135623730951},"374":{"tf":1},"375":{"tf":1},"451":{"tf":1.7320508075688772},"455":{"tf":1},"463":{"tf":1.4142135623730951},"478":{"tf":1.4142135623730951},"501":{"tf":1},"543":{"tf":1.4142135623730951},"549":{"tf":1},"592":{"tf":1},"593":{"tf":1},"665":{"tf":1.7320508075688772},"669":{"tf":1},"677":{"tf":1.4142135623730951},"688":{"tf":1},"692":{"tf":1.4142135623730951},"715":{"tf":1},"757":{"tf":1.7320508075688772},"758":{"tf":1},"760":{"tf":1},"872":{"tf":1.7320508075688772},"876":{"tf":1},"881":{"tf":1.4142135623730951},"915":{"tf":1},"916":{"tf":1},"925":{"tf":1.4142135623730951},"932":{"tf":1},"938":{"tf":1},"944":{"tf":1}},"df":49}}}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"116":{"tf":1.4142135623730951},"171":{"tf":1.7320508075688772},"214":{"tf":1.7320508075688772},"347":{"tf":1.4142135623730951},"406":{"tf":1.7320508075688772},"445":{"tf":1.7320508075688772},"578":{"tf":1.4142135623730951},"624":{"tf":1.7320508075688772},"659":{"tf":1.7320508075688772},"834":{"tf":1},"867":{"tf":1.7320508075688772}},"df":11}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"928":{"tf":1}},"df":1}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"4":{"tf":1},"63":{"tf":1},"895":{"tf":1.4142135623730951}},"df":3,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"3":{"tf":1},"43":{"tf":1},"77":{"tf":1},"143":{"tf":1},"195":{"tf":2.8284271247461903},"198":{"tf":1.4142135623730951},"199":{"tf":1.7320508075688772},"202":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":1},"275":{"tf":1},"308":{"tf":1},"378":{"tf":1},"430":{"tf":2.8284271247461903},"433":{"tf":1.4142135623730951},"434":{"tf":1.7320508075688772},"437":{"tf":1},"462":{"tf":1.4142135623730951},"463":{"tf":1},"506":{"tf":1},"539":{"tf":1},"596":{"tf":1},"648":{"tf":2.8284271247461903},"651":{"tf":1.4142135623730951},"652":{"tf":1.7320508075688772},"655":{"tf":1},"676":{"tf":1.4142135623730951},"677":{"tf":1},"720":{"tf":1},"806":{"tf":1},"858":{"tf":3},"861":{"tf":1.4142135623730951},"862":{"tf":2},"865":{"tf":1},"881":{"tf":1.7320508075688772},"932":{"tf":1}},"df":36}}}}},"g":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"176":{"tf":1},"351":{"tf":1},"411":{"tf":1},"629":{"tf":1}},"df":5}},"r":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"14":{"tf":1},"19":{"tf":1.4142135623730951},"20":{"tf":1.7320508075688772},"21":{"tf":2.8284271247461903},"51":{"tf":1},"55":{"tf":1},"59":{"tf":1},"62":{"tf":1},"66":{"tf":1.7320508075688772},"81":{"tf":1},"82":{"tf":1},"86":{"tf":1},"94":{"tf":1},"97":{"tf":1},"101":{"tf":1.4142135623730951},"115":{"tf":1.4142135623730951},"116":{"tf":1.7320508075688772},"119":{"tf":1.7320508075688772},"125":{"tf":1.7320508075688772},"132":{"tf":1},"133":{"tf":1},"140":{"tf":1.4142135623730951},"150":{"tf":1.4142135623730951},"168":{"tf":1},"169":{"tf":1},"177":{"tf":1.4142135623730951},"192":{"tf":1.4142135623730951},"202":{"tf":1},"223":{"tf":1},"224":{"tf":1},"226":{"tf":1},"229":{"tf":1.7320508075688772},"237":{"tf":1.7320508075688772},"246":{"tf":1},"251":{"tf":1},"252":{"tf":1.7320508075688772},"253":{"tf":2.6457513110645907},"283":{"tf":1},"287":{"tf":1},"291":{"tf":1},"297":{"tf":1},"312":{"tf":1},"313":{"tf":1},"317":{"tf":1},"325":{"tf":1},"332":{"tf":1.4142135623730951},"346":{"tf":1.4142135623730951},"347":{"tf":1.7320508075688772},"350":{"tf":1.4142135623730951},"351":{"tf":1.4142135623730951},"354":{"tf":1.7320508075688772},"356":{"tf":1},"360":{"tf":1.7320508075688772},"367":{"tf":1},"368":{"tf":1},"375":{"tf":1.4142135623730951},"385":{"tf":1.4142135623730951},"403":{"tf":1},"404":{"tf":1},"412":{"tf":1.4142135623730951},"427":{"tf":1.4142135623730951},"437":{"tf":1},"454":{"tf":1},"455":{"tf":1},"457":{"tf":1},"460":{"tf":1.7320508075688772},"468":{"tf":1.7320508075688772},"477":{"tf":1},"482":{"tf":1.4142135623730951},"483":{"tf":1.7320508075688772},"484":{"tf":2.8284271247461903},"514":{"tf":1},"518":{"tf":1},"522":{"tf":1},"525":{"tf":1},"528":{"tf":1.7320508075688772},"543":{"tf":1},"544":{"tf":1},"548":{"tf":1},"556":{"tf":1},"559":{"tf":1},"563":{"tf":1.4142135623730951},"577":{"tf":1.4142135623730951},"578":{"tf":1.7320508075688772},"585":{"tf":1},"586":{"tf":1},"593":{"tf":1.4142135623730951},"603":{"tf":1.4142135623730951},"621":{"tf":1},"622":{"tf":1},"630":{"tf":1.4142135623730951},"645":{"tf":1.4142135623730951},"668":{"tf":1},"669":{"tf":1},"671":{"tf":1},"674":{"tf":1.7320508075688772},"682":{"tf":1.7320508075688772},"691":{"tf":1},"692":{"tf":1},"696":{"tf":1.4142135623730951},"697":{"tf":1.4142135623730951},"698":{"tf":3.605551275463989},"724":{"tf":1},"728":{"tf":1.4142135623730951},"732":{"tf":1},"736":{"tf":1},"739":{"tf":1.7320508075688772},"740":{"tf":1.4142135623730951},"742":{"tf":1.4142135623730951},"743":{"tf":1.7320508075688772},"757":{"tf":1},"763":{"tf":1},"766":{"tf":1},"770":{"tf":1},"784":{"tf":1.4142135623730951},"785":{"tf":1},"794":{"tf":1},"795":{"tf":1},"796":{"tf":1},"803":{"tf":1.4142135623730951},"806":{"tf":1},"813":{"tf":1.4142135623730951},"840":{"tf":1},"855":{"tf":1},"875":{"tf":1},"881":{"tf":1.7320508075688772},"890":{"tf":1},"892":{"tf":1},"907":{"tf":1},"909":{"tf":1},"911":{"tf":1.4142135623730951},"913":{"tf":1.4142135623730951},"915":{"tf":2.6457513110645907},"917":{"tf":1.7320508075688772},"921":{"tf":1},"926":{"tf":1},"935":{"tf":1},"936":{"tf":1.7320508075688772},"949":{"tf":1}},"df":140,"u":{"docs":{},"df":0,"p":{"docs":{"14":{"tf":1},"21":{"tf":1},"246":{"tf":1},"477":{"tf":1},"691":{"tf":1},"840":{"tf":1},"951":{"tf":1}},"df":7}},"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"p":{"docs":{},"df":0,".":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"l":{"docs":{"911":{"tf":1},"912":{"tf":1}},"df":2}}}}}}}}}}}}}}}},"y":{"docs":{"21":{"tf":1},"253":{"tf":1},"484":{"tf":1}},"df":3},"t":{"docs":{},"df":0,"u":{"docs":{"27":{"tf":1},"28":{"tf":1},"259":{"tf":1},"260":{"tf":1},"490":{"tf":1},"491":{"tf":1},"704":{"tf":1},"705":{"tf":1},"751":{"tf":1}},"df":9},"e":{"docs":{"39":{"tf":1},"51":{"tf":1.4142135623730951},"77":{"tf":1},"81":{"tf":1},"140":{"tf":1},"143":{"tf":1},"146":{"tf":1},"203":{"tf":1.4142135623730951},"210":{"tf":1},"271":{"tf":1},"283":{"tf":1.4142135623730951},"308":{"tf":1},"312":{"tf":1},"357":{"tf":1},"375":{"tf":1},"378":{"tf":1},"381":{"tf":1},"438":{"tf":1.4142135623730951},"502":{"tf":1},"514":{"tf":1.4142135623730951},"539":{"tf":1},"543":{"tf":1},"593":{"tf":1},"596":{"tf":1},"599":{"tf":1},"728":{"tf":1.4142135623730951},"757":{"tf":1},"803":{"tf":1},"809":{"tf":1}},"df":29,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"215":{"tf":1},"446":{"tf":1},"660":{"tf":1}},"df":3}}}}}},"m":{"docs":{},"df":0,"p":{"docs":{"38":{"tf":1},"270":{"tf":1},"501":{"tf":1},"715":{"tf":1}},"df":4}},"c":{"docs":{},"df":0,"k":{"docs":{"155":{"tf":1},"177":{"tf":1},"182":{"tf":1.7320508075688772},"183":{"tf":1.4142135623730951},"192":{"tf":1},"215":{"tf":1},"390":{"tf":1},"412":{"tf":1},"417":{"tf":1.7320508075688772},"418":{"tf":1.4142135623730951},"427":{"tf":1},"446":{"tf":1},"608":{"tf":1},"630":{"tf":1},"635":{"tf":1.7320508075688772},"636":{"tf":1.4142135623730951},"645":{"tf":1},"660":{"tf":1},"840":{"tf":1.4142135623730951},"845":{"tf":1.4142135623730951},"846":{"tf":1},"855":{"tf":1},"901":{"tf":1},"929":{"tf":1}},"df":24,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"c":{"docs":{"818":{"tf":1.4142135623730951},"846":{"tf":1}},"df":2}}}}}},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"350":{"tf":1}},"df":1}},"l":{"docs":{"907":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"p":{"docs":{"4":{"tf":1.4142135623730951},"19":{"tf":1},"21":{"tf":1},"25":{"tf":1},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"32":{"tf":1.7320508075688772},"62":{"tf":1},"63":{"tf":1},"64":{"tf":1.4142135623730951},"78":{"tf":1},"81":{"tf":1.4142135623730951},"82":{"tf":2},"86":{"tf":1},"87":{"tf":1},"97":{"tf":1},"98":{"tf":1},"101":{"tf":1},"102":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"105":{"tf":2},"109":{"tf":2},"128":{"tf":2},"137":{"tf":2.449489742783178},"138":{"tf":1.4142135623730951},"139":{"tf":1.4142135623730951},"140":{"tf":2.23606797749979},"157":{"tf":1},"167":{"tf":1},"168":{"tf":1},"170":{"tf":1},"175":{"tf":1},"181":{"tf":1.7320508075688772},"182":{"tf":1.4142135623730951},"187":{"tf":1},"226":{"tf":1.4142135623730951},"237":{"tf":1},"251":{"tf":1},"253":{"tf":1.7320508075688772},"257":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"264":{"tf":1.7320508075688772},"294":{"tf":1},"295":{"tf":1},"296":{"tf":1.4142135623730951},"309":{"tf":1},"312":{"tf":1.4142135623730951},"313":{"tf":2},"314":{"tf":1},"318":{"tf":1},"328":{"tf":1},"329":{"tf":1},"332":{"tf":1},"333":{"tf":1.4142135623730951},"334":{"tf":1.4142135623730951},"336":{"tf":2},"340":{"tf":2},"363":{"tf":2},"372":{"tf":2.449489742783178},"373":{"tf":1.4142135623730951},"374":{"tf":1.4142135623730951},"375":{"tf":2.23606797749979},"392":{"tf":1},"402":{"tf":1},"403":{"tf":1},"405":{"tf":1},"410":{"tf":1},"416":{"tf":1.7320508075688772},"417":{"tf":1.4142135623730951},"422":{"tf":1},"457":{"tf":1.4142135623730951},"468":{"tf":1},"482":{"tf":1},"484":{"tf":1},"488":{"tf":1},"489":{"tf":1.4142135623730951},"490":{"tf":1.4142135623730951},"495":{"tf":1.7320508075688772},"525":{"tf":1},"526":{"tf":1.4142135623730951},"540":{"tf":1},"543":{"tf":1.4142135623730951},"544":{"tf":2},"548":{"tf":1},"549":{"tf":1},"559":{"tf":1},"560":{"tf":1},"563":{"tf":1},"564":{"tf":1.4142135623730951},"565":{"tf":1.4142135623730951},"567":{"tf":2},"571":{"tf":2},"581":{"tf":2},"590":{"tf":2.449489742783178},"591":{"tf":1.4142135623730951},"592":{"tf":1.4142135623730951},"593":{"tf":2.23606797749979},"610":{"tf":1},"620":{"tf":1},"621":{"tf":1},"623":{"tf":1},"628":{"tf":1},"634":{"tf":1.7320508075688772},"635":{"tf":1.4142135623730951},"640":{"tf":1},"671":{"tf":1.4142135623730951},"682":{"tf":1},"696":{"tf":1},"698":{"tf":1.7320508075688772},"702":{"tf":1},"703":{"tf":1.4142135623730951},"704":{"tf":1.4142135623730951},"709":{"tf":1.7320508075688772},"727":{"tf":1.4142135623730951},"740":{"tf":1.4142135623730951},"742":{"tf":1},"758":{"tf":2},"760":{"tf":1},"766":{"tf":1.4142135623730951},"767":{"tf":1.4142135623730951},"770":{"tf":1},"771":{"tf":1.4142135623730951},"772":{"tf":1.4142135623730951},"774":{"tf":2},"778":{"tf":2.449489742783178},"791":{"tf":2},"800":{"tf":2.6457513110645907},"801":{"tf":1.4142135623730951},"802":{"tf":1.4142135623730951},"803":{"tf":1.4142135623730951},"806":{"tf":1},"824":{"tf":1},"827":{"tf":1},"830":{"tf":1},"831":{"tf":1.7320508075688772},"833":{"tf":1},"838":{"tf":1},"839":{"tf":1.4142135623730951},"844":{"tf":1.4142135623730951},"845":{"tf":1.7320508075688772},"850":{"tf":1},"890":{"tf":1},"895":{"tf":1},"896":{"tf":1},"897":{"tf":1},"901":{"tf":1},"902":{"tf":1.4142135623730951},"907":{"tf":1.7320508075688772},"909":{"tf":1},"911":{"tf":1.4142135623730951},"912":{"tf":1},"915":{"tf":2},"916":{"tf":1.4142135623730951},"917":{"tf":1.7320508075688772},"918":{"tf":1},"921":{"tf":1.4142135623730951},"924":{"tf":1.4142135623730951},"925":{"tf":1},"932":{"tf":1},"933":{"tf":2.23606797749979},"936":{"tf":2.23606797749979},"937":{"tf":1},"941":{"tf":1},"945":{"tf":1.4142135623730951},"949":{"tf":1.4142135623730951},"954":{"tf":1},"955":{"tf":1}},"df":168}},"u":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"21":{"tf":1},"50":{"tf":1},"103":{"tf":1},"122":{"tf":1.7320508075688772},"157":{"tf":1},"161":{"tf":1},"178":{"tf":1},"253":{"tf":1},"282":{"tf":1},"334":{"tf":1},"337":{"tf":1},"357":{"tf":1.7320508075688772},"392":{"tf":1},"396":{"tf":1},"413":{"tf":1},"484":{"tf":1},"513":{"tf":1},"565":{"tf":1},"568":{"tf":1},"610":{"tf":1},"614":{"tf":1},"631":{"tf":1},"820":{"tf":1},"841":{"tf":1.4142135623730951}},"df":24}}},"o":{"docs":{},"df":0,"p":{"docs":{"46":{"tf":1.4142135623730951},"47":{"tf":1},"51":{"tf":1},"59":{"tf":1},"72":{"tf":1},"77":{"tf":1.4142135623730951},"86":{"tf":1.7320508075688772},"115":{"tf":1},"116":{"tf":1},"125":{"tf":1.4142135623730951},"140":{"tf":1.4142135623730951},"177":{"tf":1},"181":{"tf":1},"184":{"tf":1},"192":{"tf":1.4142135623730951},"210":{"tf":1},"226":{"tf":1},"229":{"tf":1.7320508075688772},"278":{"tf":1.4142135623730951},"279":{"tf":1},"283":{"tf":1},"291":{"tf":1},"303":{"tf":1},"308":{"tf":1.4142135623730951},"317":{"tf":1.7320508075688772},"346":{"tf":1},"347":{"tf":1},"360":{"tf":1.4142135623730951},"375":{"tf":1.4142135623730951},"386":{"tf":1},"412":{"tf":1},"416":{"tf":1},"419":{"tf":1},"427":{"tf":1.4142135623730951},"457":{"tf":1},"460":{"tf":1.7320508075688772},"509":{"tf":1.4142135623730951},"510":{"tf":1},"514":{"tf":1},"522":{"tf":1},"534":{"tf":1},"539":{"tf":1.4142135623730951},"548":{"tf":1.7320508075688772},"577":{"tf":1},"578":{"tf":1},"593":{"tf":1.4142135623730951},"604":{"tf":1},"630":{"tf":1},"634":{"tf":1},"637":{"tf":1},"645":{"tf":1.4142135623730951},"671":{"tf":1},"674":{"tf":1.7320508075688772},"692":{"tf":1},"723":{"tf":1.4142135623730951},"724":{"tf":1.4142135623730951},"728":{"tf":1},"736":{"tf":1},"747":{"tf":1},"749":{"tf":1},"754":{"tf":1},"759":{"tf":1},"760":{"tf":1},"784":{"tf":1.4142135623730951},"802":{"tf":1},"812":{"tf":1},"813":{"tf":1.4142135623730951},"839":{"tf":1},"840":{"tf":1},"844":{"tf":1},"855":{"tf":1},"881":{"tf":1.7320508075688772},"890":{"tf":1},"892":{"tf":1},"906":{"tf":1},"907":{"tf":1},"910":{"tf":1.4142135623730951},"912":{"tf":1},"913":{"tf":1.7320508075688772},"915":{"tf":2},"917":{"tf":1},"921":{"tf":1.4142135623730951},"925":{"tf":1},"936":{"tf":1}},"df":84},"r":{"docs":{},"df":0,"e":{"docs":{"66":{"tf":1},"119":{"tf":1.7320508075688772},"171":{"tf":1.4142135623730951},"215":{"tf":1.4142135623730951},"226":{"tf":1},"354":{"tf":1.4142135623730951},"406":{"tf":1.4142135623730951},"446":{"tf":1.4142135623730951},"457":{"tf":1},"528":{"tf":1},"624":{"tf":1.4142135623730951},"660":{"tf":1.4142135623730951},"671":{"tf":1},"781":{"tf":1.4142135623730951},"846":{"tf":1},"894":{"tf":1}},"df":16}}},"y":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"55":{"tf":1},"287":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":4}}}}}}}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"w":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1}},"df":1}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"c":{"docs":{"38":{"tf":1},"270":{"tf":1},"501":{"tf":1},"715":{"tf":1},"839":{"tf":1},"894":{"tf":2.23606797749979},"895":{"tf":1},"901":{"tf":1}},"df":8}}},"o":{"docs":{},"df":0,"n":{"docs":{"67":{"tf":1},"94":{"tf":1},"298":{"tf":1},"325":{"tf":1},"529":{"tf":1},"556":{"tf":1},"794":{"tf":1}},"df":7}},"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"109":{"tf":1},"340":{"tf":1},"571":{"tf":1},"778":{"tf":1}},"df":4}}}},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"m":{"docs":{"149":{"tf":1},"184":{"tf":1},"198":{"tf":1},"384":{"tf":1},"419":{"tf":1},"433":{"tf":1},"602":{"tf":1},"637":{"tf":1},"651":{"tf":1},"812":{"tf":1},"847":{"tf":1}},"df":11}},"h":{"docs":{"350":{"tf":1},"915":{"tf":1},"945":{"tf":1},"956":{"tf":1}},"df":4}}}},"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"116":{"tf":1},"195":{"tf":1.4142135623730951},"347":{"tf":1},"430":{"tf":1.4142135623730951},"578":{"tf":1},"648":{"tf":1.4142135623730951},"858":{"tf":1.4142135623730951},"907":{"tf":1},"921":{"tf":1}},"df":9}},"v":{"docs":{"195":{"tf":1},"430":{"tf":1},"648":{"tf":1},"858":{"tf":1},"891":{"tf":1}},"df":5,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"907":{"tf":1}},"df":1}}}}}},"c":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"195":{"tf":1.7320508075688772},"211":{"tf":1},"215":{"tf":1},"430":{"tf":1.7320508075688772},"442":{"tf":1},"446":{"tf":1},"648":{"tf":1.7320508075688772},"656":{"tf":1},"660":{"tf":1},"858":{"tf":1.7320508075688772},"894":{"tf":1}},"df":12}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"5":{"tf":1},"81":{"tf":1},"312":{"tf":1},"543":{"tf":1}},"df":4}}}},"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"21":{"tf":1},"67":{"tf":1},"212":{"tf":1},"253":{"tf":1},"298":{"tf":1},"443":{"tf":1},"484":{"tf":1},"529":{"tf":1},"657":{"tf":1},"716":{"tf":1},"746":{"tf":1},"866":{"tf":1.4142135623730951}},"df":12,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{"39":{"tf":1.4142135623730951},"40":{"tf":1.4142135623730951},"155":{"tf":1},"212":{"tf":1.4142135623730951},"231":{"tf":1},"232":{"tf":1.4142135623730951},"271":{"tf":1.4142135623730951},"272":{"tf":1.4142135623730951},"390":{"tf":1},"443":{"tf":1.4142135623730951},"462":{"tf":1},"463":{"tf":1.4142135623730951},"502":{"tf":1.4142135623730951},"503":{"tf":1.4142135623730951},"608":{"tf":1},"657":{"tf":1.4142135623730951},"676":{"tf":1},"677":{"tf":1.4142135623730951},"716":{"tf":1.7320508075688772},"717":{"tf":1.7320508075688772},"818":{"tf":1},"881":{"tf":1.7320508075688772},"934":{"tf":1}},"df":23}}}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{"8":{"tf":1},"240":{"tf":1.4142135623730951},"471":{"tf":1.4142135623730951},"890":{"tf":1},"951":{"tf":1},"954":{"tf":1}},"df":6}}}}}}},"u":{"docs":{},"df":0,"p":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1.4142135623730951},"8":{"tf":1},"43":{"tf":2},"116":{"tf":1},"125":{"tf":1},"213":{"tf":1},"240":{"tf":1},"275":{"tf":1.7320508075688772},"347":{"tf":1},"351":{"tf":1},"360":{"tf":1},"444":{"tf":1},"471":{"tf":1},"506":{"tf":1.7320508075688772},"578":{"tf":1},"658":{"tf":1},"685":{"tf":1},"720":{"tf":1.7320508075688772},"840":{"tf":1},"933":{"tf":1}},"df":20,"@":{"docs":{},"df":0,"q":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"5":{"tf":1}},"df":1}}}}}}}}}}}}},"s":{"docs":{"39":{"tf":1},"74":{"tf":1},"271":{"tf":1},"305":{"tf":1},"502":{"tf":1},"536":{"tf":1},"716":{"tf":1}},"df":7}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"356":{"tf":1}},"df":1}}}}}},"i":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"11":{"tf":1.7320508075688772},"14":{"tf":1.7320508075688772},"15":{"tf":1.7320508075688772},"21":{"tf":1},"27":{"tf":1},"38":{"tf":1},"56":{"tf":1.4142135623730951},"59":{"tf":1.4142135623730951},"62":{"tf":1.4142135623730951},"66":{"tf":1.4142135623730951},"67":{"tf":1},"68":{"tf":1},"74":{"tf":1},"81":{"tf":2},"82":{"tf":1.4142135623730951},"83":{"tf":1},"87":{"tf":1},"90":{"tf":1.7320508075688772},"91":{"tf":1},"97":{"tf":1.4142135623730951},"104":{"tf":1},"105":{"tf":1},"106":{"tf":1},"112":{"tf":1},"115":{"tf":1},"116":{"tf":1},"119":{"tf":1},"128":{"tf":1},"132":{"tf":1},"134":{"tf":1.7320508075688772},"137":{"tf":1.4142135623730951},"140":{"tf":1},"143":{"tf":1},"146":{"tf":1},"150":{"tf":1},"156":{"tf":1},"157":{"tf":1},"177":{"tf":1},"182":{"tf":1.4142135623730951},"187":{"tf":1},"189":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"195":{"tf":2},"198":{"tf":1},"199":{"tf":1},"210":{"tf":1},"229":{"tf":1},"232":{"tf":1.4142135623730951},"243":{"tf":1.7320508075688772},"246":{"tf":1.7320508075688772},"247":{"tf":1.7320508075688772},"252":{"tf":1},"253":{"tf":1},"259":{"tf":1},"270":{"tf":1},"288":{"tf":1.4142135623730951},"291":{"tf":1.4142135623730951},"294":{"tf":1.4142135623730951},"297":{"tf":1},"298":{"tf":1},"299":{"tf":1},"305":{"tf":1},"312":{"tf":2},"313":{"tf":1.4142135623730951},"314":{"tf":1.4142135623730951},"318":{"tf":1},"321":{"tf":1.7320508075688772},"322":{"tf":1},"328":{"tf":1.4142135623730951},"335":{"tf":1},"336":{"tf":1},"337":{"tf":1},"343":{"tf":1},"346":{"tf":1},"347":{"tf":1},"350":{"tf":1},"354":{"tf":1},"356":{"tf":1.7320508075688772},"363":{"tf":1},"367":{"tf":1},"369":{"tf":1.7320508075688772},"372":{"tf":1.4142135623730951},"375":{"tf":1},"378":{"tf":1},"381":{"tf":1},"385":{"tf":1},"391":{"tf":1},"392":{"tf":1},"412":{"tf":1},"417":{"tf":1.4142135623730951},"422":{"tf":1},"424":{"tf":1.4142135623730951},"427":{"tf":1.7320508075688772},"430":{"tf":2},"433":{"tf":1},"434":{"tf":1},"460":{"tf":1},"463":{"tf":1.4142135623730951},"474":{"tf":1.7320508075688772},"477":{"tf":1.7320508075688772},"478":{"tf":1.7320508075688772},"490":{"tf":1},"501":{"tf":1},"519":{"tf":1.4142135623730951},"522":{"tf":1.4142135623730951},"525":{"tf":1.4142135623730951},"528":{"tf":1.4142135623730951},"529":{"tf":1},"530":{"tf":1},"536":{"tf":1},"543":{"tf":2},"544":{"tf":1.4142135623730951},"545":{"tf":1},"549":{"tf":1},"552":{"tf":1.7320508075688772},"553":{"tf":1},"559":{"tf":1.4142135623730951},"566":{"tf":1},"567":{"tf":1},"568":{"tf":1},"574":{"tf":1},"577":{"tf":1},"578":{"tf":1},"581":{"tf":1},"585":{"tf":1},"587":{"tf":1.7320508075688772},"590":{"tf":1.4142135623730951},"593":{"tf":1},"596":{"tf":1},"599":{"tf":1},"603":{"tf":1},"609":{"tf":1},"610":{"tf":1},"630":{"tf":1},"635":{"tf":1.4142135623730951},"640":{"tf":1},"642":{"tf":1.4142135623730951},"645":{"tf":1.7320508075688772},"648":{"tf":2},"651":{"tf":1},"652":{"tf":1},"674":{"tf":1},"677":{"tf":1.4142135623730951},"688":{"tf":1.4142135623730951},"691":{"tf":1.7320508075688772},"692":{"tf":1.7320508075688772},"698":{"tf":1},"704":{"tf":1},"715":{"tf":1},"733":{"tf":1.4142135623730951},"736":{"tf":1},"739":{"tf":1.4142135623730951},"742":{"tf":1},"743":{"tf":1},"751":{"tf":1},"757":{"tf":1.7320508075688772},"760":{"tf":1},"766":{"tf":1.4142135623730951},"774":{"tf":1},"775":{"tf":1},"784":{"tf":1},"795":{"tf":1},"797":{"tf":1.7320508075688772},"800":{"tf":1},"803":{"tf":1},"809":{"tf":1},"813":{"tf":1},"818":{"tf":1},"819":{"tf":1},"820":{"tf":1},"845":{"tf":1.7320508075688772},"850":{"tf":1},"851":{"tf":1},"852":{"tf":1.4142135623730951},"855":{"tf":1.7320508075688772},"858":{"tf":2.6457513110645907},"861":{"tf":1},"862":{"tf":1},"881":{"tf":1.7320508075688772},"886":{"tf":1},"889":{"tf":1.7320508075688772},"893":{"tf":1},"894":{"tf":1.4142135623730951},"901":{"tf":1.7320508075688772},"902":{"tf":1},"905":{"tf":1.4142135623730951},"906":{"tf":1.4142135623730951},"908":{"tf":1},"909":{"tf":1},"910":{"tf":1},"912":{"tf":1},"913":{"tf":1.4142135623730951},"916":{"tf":1},"920":{"tf":1},"921":{"tf":1},"924":{"tf":1},"925":{"tf":1},"926":{"tf":1},"932":{"tf":1.4142135623730951},"933":{"tf":2.23606797749979},"934":{"tf":1},"935":{"tf":1.4142135623730951},"936":{"tf":1.7320508075688772},"939":{"tf":1},"940":{"tf":1.4142135623730951},"945":{"tf":1.4142135623730951},"946":{"tf":1},"951":{"tf":1},"960":{"tf":1},"962":{"tf":1}},"df":211,"e":{"docs":{},"df":0,"'":{"docs":{"195":{"tf":1},"430":{"tf":1},"648":{"tf":1}},"df":3}},"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"350":{"tf":1.4142135623730951},"739":{"tf":1},"770":{"tf":1},"858":{"tf":1}},"df":4}}}}},"b":{"docs":{"207":{"tf":1.7320508075688772}},"df":1,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"4":{"tf":1},"149":{"tf":1},"229":{"tf":1},"230":{"tf":1},"231":{"tf":1},"232":{"tf":1.4142135623730951},"384":{"tf":1},"460":{"tf":1},"461":{"tf":1},"462":{"tf":1},"463":{"tf":1.4142135623730951},"602":{"tf":1},"674":{"tf":1},"675":{"tf":1},"676":{"tf":1},"677":{"tf":1.4142135623730951},"812":{"tf":1.4142135623730951},"881":{"tf":2.23606797749979}},"df":18}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"14":{"tf":1},"64":{"tf":1},"97":{"tf":1},"246":{"tf":1},"328":{"tf":1},"477":{"tf":1},"526":{"tf":1},"559":{"tf":1},"691":{"tf":1},"766":{"tf":1}},"df":10}}}}}}}}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"q":{"docs":{},"df":0,"u":{"docs":{"66":{"tf":1},"305":{"tf":1},"528":{"tf":1},"696":{"tf":1},"820":{"tf":1}},"df":5}}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{"112":{"tf":1},"115":{"tf":1},"305":{"tf":1.4142135623730951},"343":{"tf":1},"346":{"tf":1},"350":{"tf":1.4142135623730951},"574":{"tf":1},"577":{"tf":1},"781":{"tf":1},"784":{"tf":1.4142135623730951}},"df":10}}}},"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"115":{"tf":1},"346":{"tf":1},"577":{"tf":1}},"df":3}}}}}},"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{"183":{"tf":1},"418":{"tf":1},"636":{"tf":1}},"df":3}}}},"t":{"docs":{"14":{"tf":1.4142135623730951},"20":{"tf":1.4142135623730951},"21":{"tf":2.23606797749979},"27":{"tf":1},"39":{"tf":1.4142135623730951},"51":{"tf":1},"59":{"tf":1},"66":{"tf":1.4142135623730951},"72":{"tf":1.4142135623730951},"74":{"tf":1},"77":{"tf":1.4142135623730951},"81":{"tf":1},"86":{"tf":1.7320508075688772},"90":{"tf":1.7320508075688772},"119":{"tf":1.4142135623730951},"146":{"tf":1},"161":{"tf":1},"188":{"tf":1},"199":{"tf":1},"210":{"tf":2.449489742783178},"224":{"tf":1},"226":{"tf":1},"246":{"tf":1.4142135623730951},"259":{"tf":1},"271":{"tf":1.4142135623730951},"283":{"tf":1},"291":{"tf":1},"303":{"tf":1},"305":{"tf":1},"308":{"tf":1.4142135623730951},"312":{"tf":1},"317":{"tf":1.4142135623730951},"321":{"tf":1.7320508075688772},"354":{"tf":1.4142135623730951},"381":{"tf":1},"396":{"tf":1},"423":{"tf":1},"434":{"tf":1},"455":{"tf":1},"457":{"tf":1},"477":{"tf":1.4142135623730951},"483":{"tf":1.4142135623730951},"484":{"tf":2},"490":{"tf":1},"502":{"tf":1.4142135623730951},"514":{"tf":1},"522":{"tf":1},"528":{"tf":1},"534":{"tf":1.4142135623730951},"536":{"tf":1},"539":{"tf":1.4142135623730951},"543":{"tf":1},"548":{"tf":1.7320508075688772},"552":{"tf":1.7320508075688772},"599":{"tf":1},"614":{"tf":1},"641":{"tf":1},"652":{"tf":1},"669":{"tf":1},"671":{"tf":1},"691":{"tf":1.4142135623730951},"697":{"tf":1},"716":{"tf":1},"728":{"tf":1},"736":{"tf":1},"740":{"tf":1},"757":{"tf":1},"781":{"tf":1},"809":{"tf":1},"819":{"tf":1},"824":{"tf":1},"840":{"tf":1},"851":{"tf":1},"862":{"tf":1},"890":{"tf":1.4142135623730951},"892":{"tf":1.7320508075688772},"906":{"tf":1},"907":{"tf":2.23606797749979},"909":{"tf":1},"910":{"tf":1},"911":{"tf":1},"912":{"tf":1.4142135623730951},"913":{"tf":2.449489742783178},"915":{"tf":3.605551275463989},"917":{"tf":2},"921":{"tf":1.7320508075688772},"925":{"tf":1},"932":{"tf":1},"935":{"tf":1},"936":{"tf":1.7320508075688772},"939":{"tf":1},"949":{"tf":1}},"df":92},"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"27":{"tf":1},"56":{"tf":1},"259":{"tf":1},"288":{"tf":1},"490":{"tf":1},"519":{"tf":1},"704":{"tf":1},"733":{"tf":1}},"df":8,"o":{"docs":{},"df":0,"r":{"docs":{"122":{"tf":1}},"df":1}}}}}},"h":{"docs":{"122":{"tf":1},"140":{"tf":1},"357":{"tf":1},"375":{"tf":1},"526":{"tf":1},"593":{"tf":1},"716":{"tf":1},"791":{"tf":1},"803":{"tf":1},"824":{"tf":1},"831":{"tf":1},"890":{"tf":1},"915":{"tf":1},"924":{"tf":1},"933":{"tf":1},"946":{"tf":1},"954":{"tf":1.4142135623730951}},"df":17}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"38":{"tf":1},"151":{"tf":1},"270":{"tf":1},"386":{"tf":1},"501":{"tf":1},"604":{"tf":1},"715":{"tf":1},"924":{"tf":1}},"df":8}}}}},"e":{"docs":{"54":{"tf":1},"229":{"tf":1},"231":{"tf":1},"286":{"tf":1},"460":{"tf":1},"462":{"tf":1},"517":{"tf":1},"674":{"tf":1},"676":{"tf":1},"685":{"tf":1},"743":{"tf":1},"770":{"tf":1},"839":{"tf":1},"881":{"tf":1.4142135623730951}},"df":14},"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{"182":{"tf":1},"417":{"tf":1},"635":{"tf":1}},"df":3}}}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"v":{"docs":{"192":{"tf":1},"427":{"tf":1},"645":{"tf":1},"855":{"tf":1}},"df":4}}}},"f":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"47":{"tf":1},"279":{"tf":1},"510":{"tf":1},"724":{"tf":1}},"df":4,"i":{"docs":{"94":{"tf":1},"325":{"tf":1},"556":{"tf":1},"763":{"tf":1}},"df":4}}}}},"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{"56":{"tf":1.4142135623730951},"65":{"tf":1},"288":{"tf":1.4142135623730951},"296":{"tf":1},"519":{"tf":1.4142135623730951},"527":{"tf":1},"733":{"tf":1.4142135623730951},"902":{"tf":1},"928":{"tf":1}},"df":9}}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"109":{"tf":1},"340":{"tf":1},"571":{"tf":1},"778":{"tf":1}},"df":4}}}}},"g":{"docs":{},"df":0,"g":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"806":{"tf":1}},"df":1}}}}},"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"924":{"tf":1}},"df":1}}}}}}},"w":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{"3":{"tf":1},"119":{"tf":1},"122":{"tf":1},"202":{"tf":1},"210":{"tf":1}},"df":5}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"26":{"tf":1},"72":{"tf":1.4142135623730951},"77":{"tf":1},"131":{"tf":1},"195":{"tf":1},"258":{"tf":1},"303":{"tf":1.4142135623730951},"308":{"tf":1},"366":{"tf":1},"430":{"tf":1},"489":{"tf":1},"534":{"tf":1.4142135623730951},"539":{"tf":1},"584":{"tf":1},"648":{"tf":1},"703":{"tf":1},"749":{"tf":1.4142135623730951},"803":{"tf":1.4142135623730951},"812":{"tf":1},"813":{"tf":1},"814":{"tf":1},"824":{"tf":1},"866":{"tf":1},"922":{"tf":1},"936":{"tf":1}},"df":25}}}},"t":{"docs":{"3":{"tf":1},"119":{"tf":1}},"df":2}},"h":{"docs":{"21":{"tf":1}},"df":1,"o":{"docs":{},"df":0,"w":{"docs":{"4":{"tf":1},"15":{"tf":1},"31":{"tf":1},"33":{"tf":1},"37":{"tf":1},"38":{"tf":1},"39":{"tf":1.4142135623730951},"40":{"tf":1},"51":{"tf":1},"54":{"tf":1},"82":{"tf":1.4142135623730951},"112":{"tf":1},"119":{"tf":1.4142135623730951},"125":{"tf":1.7320508075688772},"128":{"tf":1},"140":{"tf":1},"176":{"tf":1.4142135623730951},"177":{"tf":1},"178":{"tf":1},"182":{"tf":1.4142135623730951},"183":{"tf":1},"187":{"tf":1},"188":{"tf":1},"189":{"tf":1},"247":{"tf":1},"263":{"tf":1},"265":{"tf":1},"269":{"tf":1},"270":{"tf":1},"271":{"tf":1.4142135623730951},"272":{"tf":1},"283":{"tf":1},"286":{"tf":1},"298":{"tf":1},"313":{"tf":1.4142135623730951},"343":{"tf":1},"350":{"tf":1},"354":{"tf":1.4142135623730951},"360":{"tf":1.7320508075688772},"363":{"tf":1},"375":{"tf":1},"411":{"tf":1.4142135623730951},"412":{"tf":1},"413":{"tf":1},"417":{"tf":1.4142135623730951},"418":{"tf":1},"422":{"tf":1},"423":{"tf":1},"424":{"tf":1},"478":{"tf":1},"494":{"tf":1},"496":{"tf":1},"500":{"tf":1},"501":{"tf":1},"502":{"tf":1.4142135623730951},"503":{"tf":1},"514":{"tf":1},"517":{"tf":1},"534":{"tf":1},"544":{"tf":1.4142135623730951},"574":{"tf":1},"581":{"tf":1},"593":{"tf":1},"629":{"tf":1.4142135623730951},"630":{"tf":1},"631":{"tf":1},"635":{"tf":1.4142135623730951},"636":{"tf":1},"640":{"tf":1},"641":{"tf":1},"642":{"tf":1},"692":{"tf":1},"708":{"tf":1},"710":{"tf":1},"714":{"tf":1},"716":{"tf":1.4142135623730951},"717":{"tf":1},"731":{"tf":1},"770":{"tf":1},"781":{"tf":1},"832":{"tf":1},"839":{"tf":1},"840":{"tf":1},"841":{"tf":1},"845":{"tf":1},"846":{"tf":1},"850":{"tf":1},"893":{"tf":1},"911":{"tf":1}},"df":89,"n":{"docs":{"122":{"tf":1},"155":{"tf":1},"171":{"tf":1},"176":{"tf":1},"357":{"tf":1},"390":{"tf":1},"406":{"tf":1},"411":{"tf":1},"539":{"tf":1},"608":{"tf":1},"624":{"tf":1},"629":{"tf":1},"696":{"tf":1},"749":{"tf":1},"818":{"tf":1}},"df":15}},"r":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"68":{"tf":1},"90":{"tf":1},"143":{"tf":1},"275":{"tf":1},"299":{"tf":1},"321":{"tf":1},"378":{"tf":1},"506":{"tf":1},"530":{"tf":1},"552":{"tf":1},"596":{"tf":1},"720":{"tf":1}},"df":13,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"38":{"tf":1},"103":{"tf":1},"109":{"tf":1},"119":{"tf":1},"128":{"tf":1.7320508075688772},"134":{"tf":1},"158":{"tf":1},"161":{"tf":1},"168":{"tf":1},"270":{"tf":1},"334":{"tf":1},"340":{"tf":1},"354":{"tf":1},"363":{"tf":1.7320508075688772},"369":{"tf":1},"393":{"tf":1},"396":{"tf":1},"403":{"tf":1},"501":{"tf":1},"565":{"tf":1},"571":{"tf":1},"581":{"tf":1.7320508075688772},"587":{"tf":1},"611":{"tf":1},"614":{"tf":1},"621":{"tf":1},"715":{"tf":1},"757":{"tf":1},"772":{"tf":1},"778":{"tf":1},"791":{"tf":2.23606797749979},"797":{"tf":1},"821":{"tf":1},"831":{"tf":1},"845":{"tf":1}},"df":35}}},"e":{"docs":{},"df":0,"n":{"docs":{"125":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951}},"df":2}}}}},"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"102":{"tf":1},"333":{"tf":1},"564":{"tf":1},"771":{"tf":1.4142135623730951}},"df":5}},"p":{"docs":{"741":{"tf":1},"858":{"tf":1.4142135623730951}},"df":2}},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"47":{"tf":1},"279":{"tf":1},"510":{"tf":1},"724":{"tf":1}},"df":4}},"p":{"docs":{},"df":0,"e":{"docs":{"55":{"tf":1},"287":{"tf":1},"518":{"tf":1},"732":{"tf":1}},"df":4}}},"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{"210":{"tf":1},"213":{"tf":1},"444":{"tf":1},"658":{"tf":1}},"df":4,"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"l":{"docs":{"213":{"tf":1},"444":{"tf":1},"658":{"tf":1}},"df":3}}}}}}},"u":{"docs":{},"df":0,"t":{"docs":{},"df":0,"d":{"docs":{},"df":0,"o":{"docs":{},"df":0,"w":{"docs":{},"df":0,"n":{"docs":{"759":{"tf":1},"760":{"tf":1}},"df":2}}}}}}},"a":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"4":{"tf":1},"8":{"tf":1},"74":{"tf":1},"82":{"tf":1.4142135623730951},"97":{"tf":1},"105":{"tf":1},"106":{"tf":1},"109":{"tf":1},"116":{"tf":1.7320508075688772},"125":{"tf":1.7320508075688772},"138":{"tf":1.4142135623730951},"139":{"tf":1},"144":{"tf":1},"145":{"tf":1},"161":{"tf":1},"164":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1},"192":{"tf":1.7320508075688772},"210":{"tf":1},"231":{"tf":1},"240":{"tf":1.4142135623730951},"305":{"tf":1},"313":{"tf":1.4142135623730951},"328":{"tf":1},"336":{"tf":1},"337":{"tf":1},"340":{"tf":1},"347":{"tf":1.7320508075688772},"350":{"tf":1},"360":{"tf":1.7320508075688772},"373":{"tf":1.4142135623730951},"374":{"tf":1},"379":{"tf":1},"380":{"tf":1},"396":{"tf":1},"399":{"tf":1.4142135623730951},"403":{"tf":1.4142135623730951},"404":{"tf":1},"427":{"tf":1.7320508075688772},"462":{"tf":1},"471":{"tf":1.4142135623730951},"536":{"tf":1},"544":{"tf":1.4142135623730951},"559":{"tf":1},"567":{"tf":1},"568":{"tf":1},"571":{"tf":1},"578":{"tf":1.7320508075688772},"591":{"tf":1.4142135623730951},"592":{"tf":1},"597":{"tf":1},"598":{"tf":1},"614":{"tf":1},"617":{"tf":1.4142135623730951},"621":{"tf":1.4142135623730951},"622":{"tf":1},"645":{"tf":1.7320508075688772},"676":{"tf":1},"751":{"tf":1},"758":{"tf":1.7320508075688772},"778":{"tf":1},"788":{"tf":1},"801":{"tf":1.4142135623730951},"807":{"tf":1},"827":{"tf":1},"831":{"tf":1},"832":{"tf":1},"840":{"tf":1},"855":{"tf":1.7320508075688772},"881":{"tf":1},"886":{"tf":1},"890":{"tf":1.7320508075688772},"892":{"tf":1},"898":{"tf":1},"899":{"tf":1},"901":{"tf":1},"911":{"tf":1},"912":{"tf":1.4142135623730951},"925":{"tf":1},"954":{"tf":1}},"df":81},"p":{"docs":{},"df":0,"l":{"docs":{"11":{"tf":1.4142135623730951},"119":{"tf":1},"125":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"354":{"tf":1},"360":{"tf":1.4142135623730951},"474":{"tf":1.4142135623730951},"688":{"tf":1},"889":{"tf":1},"902":{"tf":1},"910":{"tf":1}},"df":11}}},"v":{"docs":{},"df":0,"e":{"docs":{"40":{"tf":1},"68":{"tf":2},"97":{"tf":1},"119":{"tf":1},"122":{"tf":2},"134":{"tf":1},"272":{"tf":1},"299":{"tf":2},"328":{"tf":1},"350":{"tf":1.4142135623730951},"354":{"tf":1.4142135623730951},"357":{"tf":2.449489742783178},"369":{"tf":1},"503":{"tf":1},"530":{"tf":2},"559":{"tf":1},"587":{"tf":1},"717":{"tf":1.4142135623730951},"743":{"tf":1.4142135623730951},"766":{"tf":1.4142135623730951},"797":{"tf":1},"912":{"tf":1},"945":{"tf":1}},"df":23}},"w":{"docs":{"125":{"tf":1},"150":{"tf":1},"360":{"tf":1},"385":{"tf":1},"603":{"tf":1}},"df":5}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"4":{"tf":1},"207":{"tf":1}},"df":2}}}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{"116":{"tf":1},"125":{"tf":1.4142135623730951},"347":{"tf":1},"360":{"tf":1.4142135623730951},"578":{"tf":1}},"df":5}}}},"p":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{"8":{"tf":1},"64":{"tf":1},"122":{"tf":1.4142135623730951},"199":{"tf":1.7320508075688772},"208":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"295":{"tf":1},"296":{"tf":1},"351":{"tf":1},"357":{"tf":1.4142135623730951},"434":{"tf":1.7320508075688772},"441":{"tf":1.4142135623730951},"471":{"tf":1},"526":{"tf":1},"652":{"tf":1.7320508075688772},"698":{"tf":1},"740":{"tf":1},"858":{"tf":1},"862":{"tf":1.4142135623730951},"881":{"tf":1},"891":{"tf":1},"899":{"tf":1},"907":{"tf":1.4142135623730951},"915":{"tf":1},"921":{"tf":1.4142135623730951},"946":{"tf":1},"948":{"tf":1},"954":{"tf":1.7320508075688772}},"df":28,"i":{"docs":{"55":{"tf":1},"64":{"tf":1},"81":{"tf":1},"116":{"tf":1},"125":{"tf":1.7320508075688772},"169":{"tf":1},"188":{"tf":1},"189":{"tf":1},"192":{"tf":1},"211":{"tf":1},"213":{"tf":1.7320508075688772},"215":{"tf":1},"287":{"tf":1},"312":{"tf":1},"347":{"tf":1},"360":{"tf":1.7320508075688772},"404":{"tf":1},"423":{"tf":1},"424":{"tf":1},"427":{"tf":1},"442":{"tf":1},"444":{"tf":1.7320508075688772},"446":{"tf":1},"518":{"tf":1},"526":{"tf":1.7320508075688772},"543":{"tf":1},"578":{"tf":1},"622":{"tf":1},"641":{"tf":1},"642":{"tf":1},"645":{"tf":1},"656":{"tf":1},"658":{"tf":1.7320508075688772},"660":{"tf":1},"732":{"tf":1},"757":{"tf":1},"785":{"tf":1.4142135623730951},"832":{"tf":1},"850":{"tf":1},"851":{"tf":1},"852":{"tf":1},"855":{"tf":1.4142135623730951},"867":{"tf":2},"878":{"tf":1},"890":{"tf":1},"894":{"tf":1},"895":{"tf":1},"909":{"tf":1},"915":{"tf":1.7320508075688772},"917":{"tf":1},"945":{"tf":1},"946":{"tf":1},"949":{"tf":1},"951":{"tf":1.4142135623730951},"954":{"tf":1},"958":{"tf":1}},"df":56,"y":{"docs":{"187":{"tf":1},"422":{"tf":1},"640":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"l":{"docs":{"26":{"tf":1.4142135623730951},"51":{"tf":1},"64":{"tf":1},"72":{"tf":1.4142135623730951},"116":{"tf":1},"119":{"tf":1},"140":{"tf":1},"258":{"tf":1.4142135623730951},"283":{"tf":1},"295":{"tf":1},"303":{"tf":1.4142135623730951},"347":{"tf":1},"354":{"tf":1},"375":{"tf":1},"489":{"tf":1.4142135623730951},"514":{"tf":1},"526":{"tf":1},"534":{"tf":1.4142135623730951},"578":{"tf":1},"593":{"tf":1},"703":{"tf":1.4142135623730951},"728":{"tf":1},"746":{"tf":1},"749":{"tf":1.4142135623730951},"803":{"tf":1},"940":{"tf":1},"941":{"tf":1}},"df":27,"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"940":{"tf":1}},"df":1}}}}}}}}}},"n":{"docs":{},"df":0,"t":{"docs":{"237":{"tf":1},"468":{"tf":1},"682":{"tf":1}},"df":3}}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{"168":{"tf":1},"403":{"tf":1},"621":{"tf":1},"831":{"tf":1}},"df":4}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"933":{"tf":1.4142135623730951}},"df":1}}}},"m":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1},"283":{"tf":1},"514":{"tf":1},"728":{"tf":1}},"df":4}}},"i":{"docs":{},"df":0,"d":{"docs":{"125":{"tf":5.196152422706632},"360":{"tf":5.196152422706632},"788":{"tf":2.23606797749979}},"df":3}},"g":{"docs":{},"df":0,"w":{"docs":{},"df":0,"t":{"docs":{"351":{"tf":1}},"df":1}}}}},"l":{"docs":{},"df":0,"l":{"docs":{"176":{"tf":1},"237":{"tf":1},"411":{"tf":1},"468":{"tf":1},"629":{"tf":1},"682":{"tf":1},"791":{"tf":1},"797":{"tf":1},"907":{"tf":1},"915":{"tf":1},"933":{"tf":1}},"df":11}}}},"k":{"docs":{},"df":0,"i":{"docs":{},"df":0,"p":{"docs":{"128":{"tf":1.7320508075688772},"140":{"tf":1},"143":{"tf":1.7320508075688772},"144":{"tf":1},"145":{"tf":1.7320508075688772},"146":{"tf":2},"226":{"tf":1},"363":{"tf":1.7320508075688772},"375":{"tf":1},"378":{"tf":1.7320508075688772},"379":{"tf":1},"380":{"tf":1.7320508075688772},"381":{"tf":2},"457":{"tf":1},"581":{"tf":1.7320508075688772},"593":{"tf":1},"596":{"tf":1.7320508075688772},"597":{"tf":1},"598":{"tf":1.7320508075688772},"599":{"tf":2},"671":{"tf":1},"791":{"tf":1.7320508075688772},"803":{"tf":1},"806":{"tf":2.23606797749979},"807":{"tf":1.4142135623730951},"808":{"tf":1.7320508075688772},"809":{"tf":2},"855":{"tf":1},"878":{"tf":1},"901":{"tf":1}},"df":30}}},"q":{"docs":{},"df":0,"u":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{"151":{"tf":1},"386":{"tf":1},"534":{"tf":1.4142135623730951},"604":{"tf":1},"814":{"tf":1}},"df":5}}},"l":{"docs":{"215":{"tf":2},"446":{"tf":2},"660":{"tf":2}},"df":3}}},"c":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"3":{"tf":1},"25":{"tf":1},"26":{"tf":1.4142135623730951},"27":{"tf":1.4142135623730951},"59":{"tf":1},"66":{"tf":1},"77":{"tf":2.8284271247461903},"78":{"tf":1},"94":{"tf":1},"119":{"tf":1.4142135623730951},"122":{"tf":2},"151":{"tf":1},"155":{"tf":1.4142135623730951},"156":{"tf":1.4142135623730951},"157":{"tf":1.4142135623730951},"167":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1},"170":{"tf":1},"171":{"tf":1.7320508075688772},"172":{"tf":1},"175":{"tf":1},"177":{"tf":1},"178":{"tf":1},"182":{"tf":1},"183":{"tf":1},"187":{"tf":1.4142135623730951},"203":{"tf":1.4142135623730951},"207":{"tf":1},"213":{"tf":1},"216":{"tf":2.23606797749979},"226":{"tf":1.7320508075688772},"229":{"tf":2.23606797749979},"230":{"tf":1},"231":{"tf":1},"232":{"tf":2.449489742783178},"233":{"tf":1},"234":{"tf":1},"237":{"tf":1},"253":{"tf":1},"257":{"tf":1},"258":{"tf":1.4142135623730951},"259":{"tf":1.4142135623730951},"291":{"tf":1},"308":{"tf":2.8284271247461903},"309":{"tf":1},"325":{"tf":1},"350":{"tf":2},"354":{"tf":1.4142135623730951},"357":{"tf":2},"386":{"tf":1},"390":{"tf":1.4142135623730951},"391":{"tf":1.4142135623730951},"392":{"tf":1.4142135623730951},"402":{"tf":1},"403":{"tf":1.4142135623730951},"404":{"tf":1},"405":{"tf":1},"406":{"tf":1.7320508075688772},"407":{"tf":1},"410":{"tf":1},"412":{"tf":1},"413":{"tf":1},"417":{"tf":1},"418":{"tf":1},"422":{"tf":1.4142135623730951},"438":{"tf":1.4142135623730951},"444":{"tf":1},"447":{"tf":2.23606797749979},"457":{"tf":1.4142135623730951},"460":{"tf":2.23606797749979},"461":{"tf":1},"462":{"tf":1},"463":{"tf":2.449489742783178},"464":{"tf":1},"465":{"tf":1},"468":{"tf":1},"484":{"tf":1},"488":{"tf":1},"489":{"tf":1.4142135623730951},"490":{"tf":1.4142135623730951},"522":{"tf":1},"528":{"tf":1},"539":{"tf":3.4641016151377544},"540":{"tf":1},"556":{"tf":1},"604":{"tf":1},"608":{"tf":1.4142135623730951},"609":{"tf":1.4142135623730951},"610":{"tf":1.4142135623730951},"620":{"tf":1},"621":{"tf":1.4142135623730951},"622":{"tf":1},"623":{"tf":1},"624":{"tf":1.7320508075688772},"625":{"tf":1},"628":{"tf":1},"630":{"tf":1},"631":{"tf":1},"635":{"tf":1},"636":{"tf":1},"640":{"tf":1.4142135623730951},"658":{"tf":1},"661":{"tf":2.23606797749979},"671":{"tf":1.4142135623730951},"674":{"tf":2.23606797749979},"675":{"tf":1},"676":{"tf":1},"677":{"tf":2.449489742783178},"678":{"tf":1},"679":{"tf":1},"682":{"tf":1},"698":{"tf":1},"703":{"tf":1.4142135623730951},"704":{"tf":1.4142135623730951},"736":{"tf":1},"754":{"tf":2.23606797749979},"763":{"tf":1},"818":{"tf":2},"819":{"tf":1.4142135623730951},"820":{"tf":1.4142135623730951},"830":{"tf":1},"831":{"tf":1.4142135623730951},"832":{"tf":1},"833":{"tf":1},"834":{"tf":1.7320508075688772},"835":{"tf":1},"838":{"tf":1},"850":{"tf":1.7320508075688772},"858":{"tf":1},"868":{"tf":2.23606797749979},"878":{"tf":1},"881":{"tf":3.605551275463989},"882":{"tf":1},"883":{"tf":1},"890":{"tf":1.4142135623730951},"911":{"tf":1},"916":{"tf":1},"929":{"tf":1},"937":{"tf":1},"939":{"tf":2},"946":{"tf":2.8284271247461903},"948":{"tf":1},"951":{"tf":1.7320508075688772},"954":{"tf":2},"958":{"tf":1.4142135623730951}},"df":146,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"168":{"tf":1.4142135623730951},"169":{"tf":1},"171":{"tf":1},"175":{"tf":1},"176":{"tf":1},"177":{"tf":1},"181":{"tf":1},"182":{"tf":2.23606797749979},"403":{"tf":1.4142135623730951},"404":{"tf":1},"406":{"tf":1},"410":{"tf":1},"411":{"tf":1},"412":{"tf":1},"416":{"tf":1},"417":{"tf":2.23606797749979},"621":{"tf":1.4142135623730951},"622":{"tf":1},"624":{"tf":1},"628":{"tf":1},"629":{"tf":1},"630":{"tf":1},"634":{"tf":1},"635":{"tf":2.23606797749979},"831":{"tf":1.4142135623730951},"832":{"tf":1},"834":{"tf":1},"838":{"tf":1},"839":{"tf":1},"840":{"tf":1},"844":{"tf":1},"845":{"tf":2.23606797749979}},"df":32}}}}}}}}},"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"203":{"tf":2.8284271247461903},"207":{"tf":1},"350":{"tf":1},"354":{"tf":1},"438":{"tf":2.8284271247461903},"841":{"tf":1}},"df":6}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{"216":{"tf":1},"447":{"tf":1},"661":{"tf":1},"868":{"tf":1}},"df":4}}}}}}}}}}},"r":{"docs":{"946":{"tf":1.4142135623730951},"954":{"tf":1}},"df":2}},"s":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{"216":{"tf":1},"447":{"tf":1},"661":{"tf":1},"868":{"tf":1}},"df":4}}}}}}}}}}}},"u":{"docs":{},"df":0,"c":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{"232":{"tf":2},"463":{"tf":2},"677":{"tf":2},"881":{"tf":2}},"df":4}}}}}}},"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"t":{"docs":{"216":{"tf":1},"447":{"tf":1},"661":{"tf":1},"868":{"tf":1},"946":{"tf":1},"947":{"tf":1},"948":{"tf":1.4142135623730951},"951":{"tf":1.4142135623730951},"954":{"tf":1.4142135623730951}},"df":9,"_":{"docs":{},"df":0,"<":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"948":{"tf":1},"954":{"tf":1}},"df":2}}}}}}}},"o":{"docs":{},"df":0,"f":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{},"df":0,"<":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"954":{"tf":1},"955":{"tf":1}},"df":2}}}}}}}}}}}}}}}}}},"e":{"docs":{},"df":0,"l":{"docs":{"958":{"tf":1},"961":{"tf":1}},"df":2,"e":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"s":{"docs":{},"df":0,"_":{"docs":{"960":{"tf":1}},"df":1}}}}}}}}}}}}},"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"296":{"tf":1}},"df":1}}}}}},"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"11":{"tf":1.4142135623730951},"21":{"tf":1},"27":{"tf":1},"28":{"tf":1},"34":{"tf":1},"59":{"tf":1.4142135623730951},"64":{"tf":1.4142135623730951},"91":{"tf":1},"94":{"tf":1.4142135623730951},"97":{"tf":1.4142135623730951},"112":{"tf":1},"119":{"tf":1},"122":{"tf":1.4142135623730951},"128":{"tf":2.449489742783178},"140":{"tf":1},"164":{"tf":1.4142135623730951},"168":{"tf":1},"175":{"tf":1},"189":{"tf":1},"195":{"tf":1.4142135623730951},"210":{"tf":1},"220":{"tf":1},"223":{"tf":1},"225":{"tf":1},"231":{"tf":1},"237":{"tf":1.4142135623730951},"243":{"tf":1.4142135623730951},"260":{"tf":1},"266":{"tf":1},"291":{"tf":1.4142135623730951},"295":{"tf":1.4142135623730951},"297":{"tf":1},"322":{"tf":1},"325":{"tf":1.4142135623730951},"328":{"tf":1.4142135623730951},"343":{"tf":1},"350":{"tf":1.4142135623730951},"351":{"tf":1},"354":{"tf":1.7320508075688772},"357":{"tf":1.4142135623730951},"363":{"tf":2.449489742783178},"375":{"tf":1},"399":{"tf":1.4142135623730951},"403":{"tf":1},"410":{"tf":1},"424":{"tf":1},"430":{"tf":1.4142135623730951},"451":{"tf":1},"454":{"tf":1},"456":{"tf":1},"462":{"tf":1},"468":{"tf":1.4142135623730951},"474":{"tf":1.4142135623730951},"484":{"tf":1},"491":{"tf":1},"497":{"tf":1},"522":{"tf":1.4142135623730951},"526":{"tf":1.4142135623730951},"553":{"tf":1},"556":{"tf":1.4142135623730951},"559":{"tf":1.4142135623730951},"574":{"tf":1},"581":{"tf":2.449489742783178},"593":{"tf":1},"617":{"tf":1.4142135623730951},"621":{"tf":1},"628":{"tf":1},"642":{"tf":1},"648":{"tf":1.4142135623730951},"665":{"tf":1},"668":{"tf":1},"670":{"tf":1},"676":{"tf":1},"682":{"tf":1.4142135623730951},"685":{"tf":1},"688":{"tf":1},"698":{"tf":1},"705":{"tf":1},"711":{"tf":1},"728":{"tf":1},"736":{"tf":1},"763":{"tf":1},"766":{"tf":1},"781":{"tf":1.4142135623730951},"788":{"tf":1},"791":{"tf":2},"803":{"tf":1.4142135623730951},"813":{"tf":1},"827":{"tf":1.4142135623730951},"831":{"tf":1},"852":{"tf":1},"855":{"tf":1.4142135623730951},"858":{"tf":1.4142135623730951},"872":{"tf":1},"875":{"tf":1},"877":{"tf":1},"881":{"tf":1},"886":{"tf":1.4142135623730951},"889":{"tf":1},"893":{"tf":1},"902":{"tf":1},"905":{"tf":1},"911":{"tf":1},"913":{"tf":1},"929":{"tf":1.4142135623730951},"932":{"tf":1},"936":{"tf":1},"944":{"tf":1},"963":{"tf":1}},"df":109}}}},"r":{"docs":{},"df":0,"t":{"docs":{"56":{"tf":1},"288":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":4},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"125":{"tf":1.4142135623730951},"171":{"tf":1},"217":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951},"406":{"tf":1},"448":{"tf":1.4142135623730951},"624":{"tf":1},"662":{"tf":1.4142135623730951},"788":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"929":{"tf":1}},"df":1}}}}}}}}},"n":{"docs":{},"df":0,"g":{"docs":{"67":{"tf":1},"72":{"tf":1},"73":{"tf":1.4142135623730951},"97":{"tf":1},"116":{"tf":1},"119":{"tf":1},"122":{"tf":3},"149":{"tf":1},"150":{"tf":1},"168":{"tf":1},"182":{"tf":2.449489742783178},"195":{"tf":1},"229":{"tf":1},"231":{"tf":1},"232":{"tf":1.7320508075688772},"233":{"tf":1},"298":{"tf":1},"303":{"tf":1},"304":{"tf":1.4142135623730951},"328":{"tf":1},"347":{"tf":1},"354":{"tf":1},"357":{"tf":3},"384":{"tf":1},"385":{"tf":1},"403":{"tf":1},"417":{"tf":2.449489742783178},"430":{"tf":1},"460":{"tf":1},"462":{"tf":1},"463":{"tf":1.7320508075688772},"464":{"tf":1},"529":{"tf":1},"534":{"tf":1},"535":{"tf":1.4142135623730951},"559":{"tf":1},"578":{"tf":1},"602":{"tf":1},"603":{"tf":1},"621":{"tf":1},"635":{"tf":2.449489742783178},"648":{"tf":1},"674":{"tf":1},"676":{"tf":1},"677":{"tf":1.7320508075688772},"678":{"tf":1},"750":{"tf":1},"766":{"tf":1},"812":{"tf":1},"813":{"tf":1},"841":{"tf":1},"845":{"tf":2.23606797749979},"866":{"tf":1},"881":{"tf":2.23606797749979},"882":{"tf":1},"908":{"tf":1},"929":{"tf":1},"936":{"tf":1},"948":{"tf":1},"949":{"tf":1},"951":{"tf":1},"960":{"tf":1}},"df":62},"c":{"docs":{"886":{"tf":1}},"df":1}}},"i":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{"20":{"tf":1},"21":{"tf":1},"38":{"tf":1},"86":{"tf":1},"109":{"tf":1},"137":{"tf":1.4142135623730951},"138":{"tf":1},"139":{"tf":1},"144":{"tf":1},"229":{"tf":1.4142135623730951},"252":{"tf":1},"253":{"tf":1},"270":{"tf":1},"317":{"tf":1},"340":{"tf":1},"372":{"tf":1.4142135623730951},"373":{"tf":1},"374":{"tf":1},"379":{"tf":1},"457":{"tf":1.4142135623730951},"460":{"tf":1.4142135623730951},"483":{"tf":1},"484":{"tf":1},"501":{"tf":1},"548":{"tf":1},"571":{"tf":1},"590":{"tf":1.4142135623730951},"591":{"tf":1},"592":{"tf":1},"597":{"tf":1},"671":{"tf":1.4142135623730951},"674":{"tf":1.4142135623730951},"692":{"tf":1},"697":{"tf":1},"715":{"tf":1},"778":{"tf":1},"800":{"tf":1},"801":{"tf":1},"807":{"tf":1},"808":{"tf":1},"878":{"tf":1},"881":{"tf":1.4142135623730951},"894":{"tf":1},"958":{"tf":1}},"df":44,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"138":{"tf":1},"373":{"tf":1},"591":{"tf":1},"800":{"tf":1},"801":{"tf":1},"941":{"tf":1}},"df":6}}}}}},"o":{"docs":{},"df":0,"o":{"docs":{},"df":0,"s":{"docs":{"26":{"tf":1.4142135623730951},"62":{"tf":1},"63":{"tf":1},"72":{"tf":1},"82":{"tf":1},"258":{"tf":1.4142135623730951},"294":{"tf":1},"303":{"tf":1},"313":{"tf":1},"489":{"tf":1},"525":{"tf":1},"534":{"tf":1},"544":{"tf":1},"740":{"tf":1.4142135623730951},"754":{"tf":1},"758":{"tf":1},"770":{"tf":1},"772":{"tf":1},"778":{"tf":1},"831":{"tf":1},"840":{"tf":1},"841":{"tf":1},"845":{"tf":1.4142135623730951},"847":{"tf":1},"852":{"tf":1},"855":{"tf":1},"894":{"tf":1}},"df":27,"e":{"docs":{},"df":0,"r":{"docs":{"195":{"tf":1},"430":{"tf":1},"648":{"tf":1}},"df":3}}}},"i":{"docs":{},"df":0,"c":{"docs":{"77":{"tf":1},"189":{"tf":1},"308":{"tf":1},"424":{"tf":1},"539":{"tf":1},"642":{"tf":1},"855":{"tf":1}},"df":7}},"s":{"docs":{},"df":0,"e":{"docs":{"101":{"tf":1},"332":{"tf":1},"563":{"tf":1}},"df":3}}},"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"e":{"docs":{"252":{"tf":1},"296":{"tf":1}},"df":2}}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"3":{"tf":1},"4":{"tf":1},"15":{"tf":1},"20":{"tf":1},"21":{"tf":1},"25":{"tf":1.4142135623730951},"26":{"tf":1},"27":{"tf":2.23606797749979},"31":{"tf":1.7320508075688772},"32":{"tf":1.4142135623730951},"33":{"tf":1.7320508075688772},"34":{"tf":1.4142135623730951},"37":{"tf":1.4142135623730951},"38":{"tf":1},"39":{"tf":1.4142135623730951},"43":{"tf":1},"50":{"tf":1.4142135623730951},"51":{"tf":2},"56":{"tf":1.4142135623730951},"59":{"tf":1},"78":{"tf":1},"81":{"tf":2.23606797749979},"82":{"tf":2.449489742783178},"90":{"tf":1.4142135623730951},"94":{"tf":1},"97":{"tf":1},"105":{"tf":1.4142135623730951},"106":{"tf":1},"115":{"tf":1},"116":{"tf":1},"119":{"tf":2.449489742783178},"122":{"tf":1.7320508075688772},"125":{"tf":1.4142135623730951},"134":{"tf":1},"137":{"tf":1.4142135623730951},"138":{"tf":1},"140":{"tf":2.6457513110645907},"144":{"tf":1},"149":{"tf":1},"157":{"tf":1.4142135623730951},"167":{"tf":1},"168":{"tf":1},"169":{"tf":1.4142135623730951},"171":{"tf":1},"172":{"tf":1},"175":{"tf":1.7320508075688772},"176":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"181":{"tf":1.4142135623730951},"182":{"tf":1},"187":{"tf":1},"188":{"tf":1},"189":{"tf":1.4142135623730951},"192":{"tf":3.7416573867739413},"210":{"tf":2.23606797749979},"224":{"tf":1},"226":{"tf":1.4142135623730951},"229":{"tf":2.23606797749979},"230":{"tf":1},"231":{"tf":1.4142135623730951},"232":{"tf":2.23606797749979},"233":{"tf":1.4142135623730951},"234":{"tf":1},"237":{"tf":1},"240":{"tf":1},"247":{"tf":1},"257":{"tf":1.4142135623730951},"258":{"tf":1},"259":{"tf":2.23606797749979},"263":{"tf":1.7320508075688772},"264":{"tf":1.4142135623730951},"265":{"tf":1.7320508075688772},"266":{"tf":1.4142135623730951},"269":{"tf":1.4142135623730951},"270":{"tf":1},"271":{"tf":1.4142135623730951},"275":{"tf":1},"282":{"tf":1.4142135623730951},"283":{"tf":2},"288":{"tf":1.4142135623730951},"291":{"tf":1},"296":{"tf":1},"309":{"tf":1},"312":{"tf":2.23606797749979},"313":{"tf":2.449489742783178},"321":{"tf":1.4142135623730951},"325":{"tf":1},"328":{"tf":1},"336":{"tf":1.4142135623730951},"337":{"tf":1},"346":{"tf":1},"347":{"tf":1},"354":{"tf":2.449489742783178},"357":{"tf":2},"360":{"tf":1.4142135623730951},"369":{"tf":1},"372":{"tf":1.4142135623730951},"373":{"tf":1},"375":{"tf":2.6457513110645907},"379":{"tf":1},"384":{"tf":1},"392":{"tf":1.4142135623730951},"402":{"tf":1},"403":{"tf":1},"404":{"tf":1.4142135623730951},"406":{"tf":1},"407":{"tf":1},"410":{"tf":1.7320508075688772},"411":{"tf":1.4142135623730951},"413":{"tf":1.4142135623730951},"416":{"tf":1.4142135623730951},"417":{"tf":1},"422":{"tf":1},"423":{"tf":1},"424":{"tf":1.4142135623730951},"427":{"tf":3.7416573867739413},"455":{"tf":1},"457":{"tf":1},"460":{"tf":2.23606797749979},"461":{"tf":1},"462":{"tf":1.4142135623730951},"463":{"tf":2.23606797749979},"464":{"tf":1.4142135623730951},"465":{"tf":1},"468":{"tf":1},"471":{"tf":1},"478":{"tf":1},"483":{"tf":1},"488":{"tf":1.4142135623730951},"489":{"tf":1},"490":{"tf":2.23606797749979},"494":{"tf":1.7320508075688772},"495":{"tf":1.4142135623730951},"496":{"tf":1.7320508075688772},"497":{"tf":1.4142135623730951},"500":{"tf":1.4142135623730951},"501":{"tf":1},"502":{"tf":1.4142135623730951},"506":{"tf":1},"513":{"tf":1.4142135623730951},"514":{"tf":2},"519":{"tf":1.4142135623730951},"522":{"tf":1},"526":{"tf":1},"540":{"tf":1},"543":{"tf":2.23606797749979},"544":{"tf":2.449489742783178},"552":{"tf":1.4142135623730951},"556":{"tf":1},"559":{"tf":1},"567":{"tf":1.4142135623730951},"568":{"tf":1},"577":{"tf":1},"578":{"tf":1},"587":{"tf":1},"590":{"tf":1.4142135623730951},"591":{"tf":1},"593":{"tf":2.6457513110645907},"597":{"tf":1},"602":{"tf":1},"610":{"tf":1.4142135623730951},"620":{"tf":1},"621":{"tf":1},"622":{"tf":1.4142135623730951},"624":{"tf":1},"625":{"tf":1},"628":{"tf":1.7320508075688772},"629":{"tf":1.4142135623730951},"631":{"tf":1.4142135623730951},"634":{"tf":1.4142135623730951},"635":{"tf":1},"640":{"tf":1},"641":{"tf":1},"642":{"tf":1.4142135623730951},"645":{"tf":3.7416573867739413},"669":{"tf":1},"671":{"tf":1},"674":{"tf":2.23606797749979},"675":{"tf":1},"676":{"tf":1.4142135623730951},"677":{"tf":2.23606797749979},"678":{"tf":1.4142135623730951},"679":{"tf":1},"682":{"tf":1},"692":{"tf":1},"698":{"tf":1},"702":{"tf":1.4142135623730951},"703":{"tf":1},"704":{"tf":2.449489742783178},"708":{"tf":1.7320508075688772},"709":{"tf":1.4142135623730951},"710":{"tf":1.7320508075688772},"711":{"tf":1.4142135623730951},"714":{"tf":1.4142135623730951},"715":{"tf":1},"716":{"tf":1.4142135623730951},"720":{"tf":1},"728":{"tf":2},"733":{"tf":1.4142135623730951},"736":{"tf":1},"757":{"tf":2.23606797749979},"758":{"tf":2.449489742783178},"763":{"tf":1},"766":{"tf":1},"774":{"tf":1.4142135623730951},"775":{"tf":1},"800":{"tf":1.7320508075688772},"801":{"tf":1},"803":{"tf":2.8284271247461903},"806":{"tf":1},"807":{"tf":1},"812":{"tf":1},"818":{"tf":1.4142135623730951},"820":{"tf":1},"824":{"tf":2.23606797749979},"830":{"tf":1},"831":{"tf":1},"832":{"tf":1},"834":{"tf":1},"835":{"tf":1.4142135623730951},"838":{"tf":1.7320508075688772},"839":{"tf":1},"841":{"tf":1.4142135623730951},"844":{"tf":1.7320508075688772},"845":{"tf":1},"850":{"tf":1},"851":{"tf":1},"852":{"tf":1},"855":{"tf":3.1622776601683795},"868":{"tf":1.7320508075688772},"876":{"tf":1},"881":{"tf":3.605551275463989},"882":{"tf":1.4142135623730951},"883":{"tf":1},"889":{"tf":1.4142135623730951},"890":{"tf":2.23606797749979},"891":{"tf":2},"892":{"tf":1.7320508075688772},"893":{"tf":2},"894":{"tf":1},"896":{"tf":2},"898":{"tf":1},"899":{"tf":2},"900":{"tf":1},"901":{"tf":1.7320508075688772},"902":{"tf":2},"905":{"tf":1.7320508075688772},"906":{"tf":1.4142135623730951},"907":{"tf":4},"908":{"tf":1},"910":{"tf":1.4142135623730951},"911":{"tf":2.8284271247461903},"912":{"tf":1.4142135623730951},"913":{"tf":2},"914":{"tf":1},"915":{"tf":2.6457513110645907},"916":{"tf":2.449489742783178},"917":{"tf":2.6457513110645907},"918":{"tf":1},"920":{"tf":1},"921":{"tf":2.23606797749979},"922":{"tf":1},"924":{"tf":2},"925":{"tf":1.4142135623730951},"926":{"tf":1.4142135623730951},"928":{"tf":1},"929":{"tf":1.4142135623730951},"933":{"tf":2.6457513110645907},"934":{"tf":1},"939":{"tf":2.449489742783178},"940":{"tf":1},"941":{"tf":1},"946":{"tf":1},"951":{"tf":1},"954":{"tf":1},"957":{"tf":1}},"df":276,"'":{"docs":{"878":{"tf":1.4142135623730951},"905":{"tf":1}},"df":2}}},"u":{"docs":{},"df":0,"s":{"docs":{"21":{"tf":1},"39":{"tf":1},"50":{"tf":1},"157":{"tf":1},"183":{"tf":1},"184":{"tf":1},"210":{"tf":1},"253":{"tf":1},"271":{"tf":1},"282":{"tf":1},"392":{"tf":1},"418":{"tf":1},"419":{"tf":1},"484":{"tf":1},"502":{"tf":1},"513":{"tf":1},"610":{"tf":1},"636":{"tf":1},"637":{"tf":1},"716":{"tf":1},"803":{"tf":1},"806":{"tf":1},"814":{"tf":1.4142135623730951},"818":{"tf":1},"824":{"tf":1},"890":{"tf":1}},"df":26},"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"s":{"docs":{"146":{"tf":1},"381":{"tf":1},"599":{"tf":1}},"df":3}}}}},"g":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{"210":{"tf":1}},"df":1}}}},"r":{"docs":{"233":{"tf":1},"464":{"tf":1},"678":{"tf":1},"882":{"tf":1}},"df":4,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{"66":{"tf":1},"67":{"tf":1},"115":{"tf":1},"116":{"tf":1.4142135623730951},"119":{"tf":1},"229":{"tf":1.4142135623730951},"295":{"tf":1},"298":{"tf":1},"346":{"tf":1},"347":{"tf":1.4142135623730951},"354":{"tf":1},"460":{"tf":1.4142135623730951},"577":{"tf":1},"578":{"tf":1.4142135623730951},"674":{"tf":1.4142135623730951},"740":{"tf":1.4142135623730951},"784":{"tf":1},"876":{"tf":1},"881":{"tf":1.4142135623730951}},"df":19,"u":{"docs":{},"df":0,"r":{"docs":{"21":{"tf":1},"22":{"tf":1},"47":{"tf":1},"50":{"tf":1},"67":{"tf":1},"68":{"tf":1},"72":{"tf":1},"253":{"tf":1},"254":{"tf":1},"279":{"tf":1},"282":{"tf":1},"299":{"tf":1},"303":{"tf":1.4142135623730951},"351":{"tf":1},"485":{"tf":1},"510":{"tf":1},"513":{"tf":1},"529":{"tf":1},"530":{"tf":1},"697":{"tf":1},"698":{"tf":1},"699":{"tf":1},"743":{"tf":1},"886":{"tf":1},"890":{"tf":1},"907":{"tf":1},"915":{"tf":1.4142135623730951},"918":{"tf":1},"933":{"tf":1.4142135623730951},"938":{"tf":1},"946":{"tf":1},"949":{"tf":1},"951":{"tf":1},"954":{"tf":1}},"df":34,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"484":{"tf":1}},"df":1}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"534":{"tf":1}},"df":1}}}}}}}}}},".":{"docs":{},"df":0,"c":{"docs":{},"df":0,"m":{"docs":{},"df":0,"d":{"docs":{"64":{"tf":1}},"df":1}}},"s":{"docs":{},"df":0,"h":{"docs":{"64":{"tf":1}},"df":1}},"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{"295":{"tf":1}},"df":1}}}},"_":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"297":{"tf":1},"298":{"tf":1}},"df":2}}},"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{},"df":0,"m":{"docs":{"528":{"tf":1},"529":{"tf":1}},"df":2,"s":{"docs":{},"df":0,".":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{"526":{"tf":1}},"df":1}}}}}}}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"741":{"tf":1}},"df":1}}}}}}}}}}}}},"r":{"docs":{},"df":0,"i":{"docs":{"746":{"tf":1},"754":{"tf":1}},"df":2}},"e":{"docs":{"809":{"tf":1},"889":{"tf":1},"905":{"tf":1},"907":{"tf":1},"932":{"tf":1}},"df":5}},"l":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"26":{"tf":1},"258":{"tf":1},"489":{"tf":1},"703":{"tf":1},"890":{"tf":1}},"df":5,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"d":{"docs":{},"df":0,"p":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{"120":{"tf":1},"122":{"tf":1},"355":{"tf":1},"357":{"tf":1.7320508075688772}},"df":4}}}}}}}}}}},"l":{"docs":{"94":{"tf":1},"101":{"tf":1.4142135623730951},"103":{"tf":1.4142135623730951},"104":{"tf":1.4142135623730951},"105":{"tf":1.7320508075688772},"106":{"tf":1},"109":{"tf":1},"134":{"tf":1},"168":{"tf":1.4142135623730951},"169":{"tf":1},"175":{"tf":1.7320508075688772},"176":{"tf":1.7320508075688772},"177":{"tf":1.7320508075688772},"178":{"tf":1.4142135623730951},"181":{"tf":2},"182":{"tf":3},"183":{"tf":1.4142135623730951},"188":{"tf":1.7320508075688772},"189":{"tf":1},"192":{"tf":2},"195":{"tf":1},"198":{"tf":1},"226":{"tf":1},"237":{"tf":1},"325":{"tf":1},"332":{"tf":1.4142135623730951},"334":{"tf":1.4142135623730951},"335":{"tf":1.4142135623730951},"336":{"tf":1.7320508075688772},"337":{"tf":1},"340":{"tf":1},"369":{"tf":1},"403":{"tf":1.4142135623730951},"404":{"tf":1},"410":{"tf":1.7320508075688772},"411":{"tf":1.7320508075688772},"412":{"tf":1.7320508075688772},"413":{"tf":1.4142135623730951},"416":{"tf":2},"417":{"tf":3},"418":{"tf":1.4142135623730951},"423":{"tf":1.7320508075688772},"424":{"tf":1},"427":{"tf":2},"430":{"tf":1},"433":{"tf":1},"457":{"tf":1},"468":{"tf":1},"556":{"tf":1},"563":{"tf":1.4142135623730951},"565":{"tf":1.4142135623730951},"566":{"tf":1.4142135623730951},"567":{"tf":1.7320508075688772},"568":{"tf":1},"571":{"tf":1},"587":{"tf":1},"621":{"tf":1.4142135623730951},"622":{"tf":1},"628":{"tf":1.7320508075688772},"629":{"tf":1.7320508075688772},"630":{"tf":1.7320508075688772},"631":{"tf":1.4142135623730951},"634":{"tf":2},"635":{"tf":3},"636":{"tf":1.4142135623730951},"641":{"tf":1.7320508075688772},"642":{"tf":1},"645":{"tf":2},"648":{"tf":1},"651":{"tf":1},"671":{"tf":1},"682":{"tf":1},"763":{"tf":1},"770":{"tf":1.4142135623730951},"772":{"tf":1.4142135623730951},"773":{"tf":1.4142135623730951},"774":{"tf":1.7320508075688772},"775":{"tf":1},"778":{"tf":1},"797":{"tf":1},"831":{"tf":1.4142135623730951},"832":{"tf":1.4142135623730951},"838":{"tf":1.7320508075688772},"839":{"tf":1.7320508075688772},"840":{"tf":1.7320508075688772},"841":{"tf":1},"844":{"tf":2},"845":{"tf":3},"846":{"tf":1.4142135623730951},"851":{"tf":1.4142135623730951},"855":{"tf":1.4142135623730951},"861":{"tf":1},"881":{"tf":1},"896":{"tf":1},"897":{"tf":1},"901":{"tf":1.4142135623730951},"907":{"tf":1},"912":{"tf":1},"913":{"tf":1},"916":{"tf":1},"918":{"tf":1},"921":{"tf":1},"925":{"tf":1.4142135623730951},"927":{"tf":1},"929":{"tf":1.4142135623730951},"933":{"tf":1.4142135623730951},"936":{"tf":1},"939":{"tf":1.7320508075688772},"946":{"tf":1},"951":{"tf":1.4142135623730951},"954":{"tf":2.6457513110645907},"957":{"tf":1},"958":{"tf":1.4142135623730951},"959":{"tf":1},"960":{"tf":1.7320508075688772},"961":{"tf":1}},"df":116,"e":{"docs":{},"df":0,"r":{"docs":{"178":{"tf":1},"413":{"tf":1},"631":{"tf":1},"841":{"tf":1}},"df":4}}}},"p":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"28":{"tf":1},"260":{"tf":1},"491":{"tf":1},"705":{"tf":1}},"df":4}}},"a":{"docs":{},"df":0,"b":{"docs":{},"df":0,"l":{"docs":{"143":{"tf":1},"378":{"tf":1},"596":{"tf":1},"806":{"tf":1},"943":{"tf":1},"944":{"tf":1},"963":{"tf":1.4142135623730951}},"df":7}}},"i":{"docs":{},"df":0,"t":{"docs":{"168":{"tf":1},"403":{"tf":1},"621":{"tf":1}},"df":3}}},"t":{"docs":{},"df":0,"c":{"docs":{},"df":0,"h":{"docs":{"210":{"tf":1.4142135623730951},"698":{"tf":1},"907":{"tf":1.4142135623730951},"924":{"tf":1},"925":{"tf":2.449489742783178},"926":{"tf":1.4142135623730951},"927":{"tf":1.7320508075688772},"928":{"tf":1.4142135623730951}},"df":8}}},"m":{"docs":{},"df":0,"e":{"docs":{"223":{"tf":1},"454":{"tf":1},"668":{"tf":1},"875":{"tf":1}},"df":4}},"c":{"docs":{},"df":0,"h":{"docs":{"253":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"915":{"tf":2}},"df":1}}}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{"3":{"tf":1},"27":{"tf":1.4142135623730951},"32":{"tf":1},"54":{"tf":1},"56":{"tf":1},"59":{"tf":1.7320508075688772},"78":{"tf":1},"90":{"tf":1},"101":{"tf":2.23606797749979},"102":{"tf":1},"105":{"tf":1.4142135623730951},"109":{"tf":1.4142135623730951},"192":{"tf":2},"195":{"tf":1},"199":{"tf":1},"213":{"tf":1.7320508075688772},"217":{"tf":1.4142135623730951},"240":{"tf":1},"253":{"tf":1},"259":{"tf":1.4142135623730951},"264":{"tf":1},"286":{"tf":1},"288":{"tf":1},"291":{"tf":1.7320508075688772},"294":{"tf":1},"309":{"tf":1},"321":{"tf":1},"328":{"tf":1},"332":{"tf":2.23606797749979},"333":{"tf":1},"336":{"tf":1.4142135623730951},"340":{"tf":1.4142135623730951},"350":{"tf":1},"356":{"tf":1},"427":{"tf":2},"430":{"tf":1},"434":{"tf":1},"444":{"tf":1.7320508075688772},"448":{"tf":1.4142135623730951},"490":{"tf":1.4142135623730951},"495":{"tf":1},"517":{"tf":1},"519":{"tf":1},"522":{"tf":1.7320508075688772},"540":{"tf":1},"552":{"tf":1},"563":{"tf":2.23606797749979},"564":{"tf":1},"567":{"tf":1.4142135623730951},"571":{"tf":1.4142135623730951},"645":{"tf":2},"648":{"tf":1},"652":{"tf":1},"658":{"tf":1.7320508075688772},"662":{"tf":1.4142135623730951},"698":{"tf":1},"704":{"tf":1.4142135623730951},"717":{"tf":1.4142135623730951},"731":{"tf":1},"733":{"tf":1},"736":{"tf":1.4142135623730951},"763":{"tf":1},"770":{"tf":2.23606797749979},"771":{"tf":1},"774":{"tf":1.4142135623730951},"778":{"tf":1.4142135623730951},"788":{"tf":1},"831":{"tf":1},"841":{"tf":1},"845":{"tf":1.4142135623730951},"855":{"tf":1.7320508075688772},"858":{"tf":1},"889":{"tf":1},"900":{"tf":1},"902":{"tf":1.7320508075688772},"905":{"tf":1},"906":{"tf":1},"915":{"tf":3.1622776601683795},"916":{"tf":1.7320508075688772},"918":{"tf":1.7320508075688772},"929":{"tf":1},"932":{"tf":1},"933":{"tf":2.8284271247461903},"934":{"tf":1},"936":{"tf":1.4142135623730951},"937":{"tf":1},"938":{"tf":1.4142135623730951},"941":{"tf":1},"944":{"tf":2},"945":{"tf":1.4142135623730951},"946":{"tf":2.6457513110645907},"950":{"tf":1},"951":{"tf":1.7320508075688772},"952":{"tf":1},"953":{"tf":1},"954":{"tf":2.449489742783178},"955":{"tf":1},"957":{"tf":1},"959":{"tf":1},"960":{"tf":1},"961":{"tf":1}},"df":101,"i":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"101":{"tf":1},"104":{"tf":1},"231":{"tf":1},"332":{"tf":1},"335":{"tf":1},"462":{"tf":1},"563":{"tf":1},"566":{"tf":1},"676":{"tf":1},"748":{"tf":1},"770":{"tf":1.4142135623730951},"773":{"tf":1},"803":{"tf":1},"881":{"tf":1},"932":{"tf":1},"935":{"tf":1},"942":{"tf":1},"943":{"tf":1},"948":{"tf":1},"951":{"tf":1},"958":{"tf":1},"963":{"tf":1}},"df":22}}}}}},"i":{"docs":{},"df":0,"t":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{"119":{"tf":1},"122":{"tf":1.4142135623730951},"125":{"tf":1.4142135623730951},"350":{"tf":1},"354":{"tf":2},"357":{"tf":1.4142135623730951},"360":{"tf":1.4142135623730951},"788":{"tf":1}},"df":8}}}},"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{"905":{"tf":1}},"df":1}}}},"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"f":{"docs":{},"df":0,"i":{"docs":{},"df":0,"g":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{"3":{"tf":1},"176":{"tf":1},"214":{"tf":1.4142135623730951},"253":{"tf":2},"305":{"tf":1},"350":{"tf":1},"351":{"tf":1},"411":{"tf":1},"445":{"tf":1.4142135623730951},"629":{"tf":1},"659":{"tf":1.4142135623730951},"717":{"tf":1.7320508075688772},"839":{"tf":1},"867":{"tf":1.4142135623730951},"936":{"tf":1.7320508075688772},"938":{"tf":1},"942":{"tf":1},"943":{"tf":1.4142135623730951},"944":{"tf":1},"946":{"tf":1.4142135623730951},"949":{"tf":1},"951":{"tf":1.4142135623730951},"952":{"tf":1},"954":{"tf":1.7320508075688772},"957":{"tf":1},"959":{"tf":1},"960":{"tf":1},"963":{"tf":1.4142135623730951}},"df":28}}},"r":{"docs":{},"df":0,"m":{"docs":{"81":{"tf":1},"312":{"tf":1},"543":{"tf":1},"749":{"tf":1},"841":{"tf":1},"946":{"tf":1}},"df":6}}},"u":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1},"356":{"tf":1}},"df":2}}},"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"4":{"tf":1},"98":{"tf":1},"119":{"tf":1},"210":{"tf":1},"329":{"tf":1},"354":{"tf":1},"560":{"tf":1},"886":{"tf":1},"893":{"tf":1},"894":{"tf":1},"902":{"tf":1},"905":{"tf":1.4142135623730951},"907":{"tf":2},"913":{"tf":1.4142135623730951}},"df":14}},"r":{"docs":{},"df":0,"n":{"docs":{"296":{"tf":1},"876":{"tf":1}},"df":2}}},"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}},"e":{"docs":{},"df":0,"n":{"docs":{"831":{"tf":1}},"df":1}}}},"l":{"docs":{},"df":0,"u":{"docs":{},"df":0,"d":{"docs":{"295":{"tf":1}},"df":1}}}},"s":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{},"df":0,"t":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,"/":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"g":{"docs":{},"df":0,".":{"docs":{},"df":0,"h":{"docs":{},"df":0,"t":{"docs":{},"df":0,"m":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}},"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"116":{"tf":1},"125":{"tf":1.4142135623730951},"347":{"tf":1},"360":{"tf":1.4142135623730951},"578":{"tf":1},"702":{"tf":1},"785":{"tf":1}},"df":7}},"d":{"docs":{"122":{"tf":1},"357":{"tf":1},"954":{"tf":1}},"df":3,"e":{"docs":{},"df":0,"r":{"docs":{"125":{"tf":1},"360":{"tf":1},"767":{"tf":1}},"df":3}}}},"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"l":{"docs":{},"df":0,"i":{"docs":{"195":{"tf":1},"430":{"tf":1},"648":{"tf":1},"824":{"tf":1}},"df":4}}}}}},"o":{"docs":{},"df":0,"l":{"docs":{"214":{"tf":1.4142135623730951},"445":{"tf":1.4142135623730951},"659":{"tf":1.4142135623730951},"867":{"tf":1.4142135623730951}},"df":4,"i":{"docs":{},"df":0,"d":{"docs":{"763":{"tf":1}},"df":1}}}},"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"946":{"tf":1}},"df":1}}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1},"220":{"tf":1.7320508075688772},"224":{"tf":1},"232":{"tf":1.4142135623730951},"350":{"tf":1},"451":{"tf":1.7320508075688772},"455":{"tf":1},"463":{"tf":1.4142135623730951},"665":{"tf":1.7320508075688772},"669":{"tf":1},"677":{"tf":1.4142135623730951},"872":{"tf":1.7320508075688772},"876":{"tf":1},"881":{"tf":1.4142135623730951},"925":{"tf":1}},"df":15}},"a":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1},"275":{"tf":1},"506":{"tf":1},"720":{"tf":1}},"df":4}}},"i":{"docs":{},"df":0,"b":{"docs":{},"df":0,"u":{"docs":{},"df":0,"t":{"docs":{"350":{"tf":1}},"df":1}}}}},"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"15":{"tf":1.4142135623730951},"21":{"tf":1},"25":{"tf":1},"56":{"tf":1},"66":{"tf":1},"81":{"tf":1.7320508075688772},"109":{"tf":1.4142135623730951},"116":{"tf":1},"137":{"tf":1},"195":{"tf":1},"199":{"tf":1},"204":{"tf":1},"205":{"tf":1},"206":{"tf":1},"211":{"tf":1},"212":{"tf":1},"213":{"tf":1},"214":{"tf":1.7320508075688772},"215":{"tf":1},"216":{"tf":1},"217":{"tf":1},"232":{"tf":1},"240":{"tf":1},"247":{"tf":1.4142135623730951},"257":{"tf":1},"288":{"tf":1},"312":{"tf":1.7320508075688772},"340":{"tf":1.4142135623730951},"347":{"tf":1},"350":{"tf":1},"351":{"tf":1},"372":{"tf":1},"430":{"tf":1},"434":{"tf":1},"439":{"tf":1},"440":{"tf":1},"442":{"tf":1},"443":{"tf":1},"444":{"tf":1},"445":{"tf":1.7320508075688772},"446":{"tf":1},"447":{"tf":1},"448":{"tf":1},"463":{"tf":1},"478":{"tf":1.4142135623730951},"484":{"tf":1},"488":{"tf":1},"519":{"tf":1},"528":{"tf":1},"543":{"tf":1.7320508075688772},"571":{"tf":1.4142135623730951},"578":{"tf":1},"590":{"tf":1},"648":{"tf":1},"652":{"tf":1},"656":{"tf":1},"657":{"tf":1},"658":{"tf":1},"659":{"tf":1.7320508075688772},"660":{"tf":1},"661":{"tf":1},"662":{"tf":1},"677":{"tf":1},"692":{"tf":1.4142135623730951},"716":{"tf":1},"733":{"tf":1},"742":{"tf":1},"748":{"tf":1},"750":{"tf":1},"757":{"tf":1.7320508075688772},"778":{"tf":1.4142135623730951},"818":{"tf":1},"820":{"tf":1},"858":{"tf":1},"866":{"tf":1},"867":{"tf":1.7320508075688772},"868":{"tf":1},"869":{"tf":1},"878":{"tf":1},"881":{"tf":1},"889":{"tf":1},"892":{"tf":1},"895":{"tf":1.4142135623730951},"896":{"tf":1.4142135623730951},"900":{"tf":1},"902":{"tf":1.4142135623730951},"906":{"tf":1},"907":{"tf":1},"908":{"tf":1},"915":{"tf":1},"916":{"tf":1.7320508075688772},"924":{"tf":1},"927":{"tf":1},"933":{"tf":1.7320508075688772},"935":{"tf":1},"936":{"tf":1.4142135623730951},"938":{"tf":1.4142135623730951},"939":{"tf":3.3166247903554},"940":{"tf":1},"944":{"tf":1},"946":{"tf":1},"947":{"tf":1},"954":{"tf":2.23606797749979},"955":{"tf":1.4142135623730951},"957":{"tf":1},"958":{"tf":1},"960":{"tf":1},"961":{"tf":1},"962":{"tf":1}},"df":109}},"c":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1.4142135623730951},"275":{"tf":1.4142135623730951},"506":{"tf":1.4142135623730951},"720":{"tf":1.4142135623730951}},"df":4}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"40":{"tf":1},"73":{"tf":1},"103":{"tf":1},"105":{"tf":1},"168":{"tf":1},"176":{"tf":1},"214":{"tf":1},"272":{"tf":1},"304":{"tf":1},"334":{"tf":1},"336":{"tf":1},"403":{"tf":1},"411":{"tf":1},"445":{"tf":1},"503":{"tf":1},"535":{"tf":1},"565":{"tf":1},"567":{"tf":1},"621":{"tf":1},"629":{"tf":1},"659":{"tf":1},"685":{"tf":1},"693":{"tf":1},"717":{"tf":1.4142135623730951},"772":{"tf":1},"774":{"tf":1},"831":{"tf":1},"867":{"tf":1.4142135623730951},"938":{"tf":1},"939":{"tf":1},"946":{"tf":1},"954":{"tf":1}},"df":32}},"x":{"docs":{},"df":0,"t":{"docs":{"43":{"tf":1.4142135623730951},"81":{"tf":1},"82":{"tf":1},"86":{"tf":1},"102":{"tf":1},"134":{"tf":1},"155":{"tf":1},"275":{"tf":1.4142135623730951},"312":{"tf":1},"313":{"tf":1},"317":{"tf":1},"333":{"tf":1},"350":{"tf":1},"369":{"tf":1},"390":{"tf":1},"506":{"tf":1.4142135623730951},"543":{"tf":1},"544":{"tf":1},"548":{"tf":1},"564":{"tf":1},"587":{"tf":1},"608":{"tf":1},"720":{"tf":1.4142135623730951},"754":{"tf":1},"757":{"tf":1},"758":{"tf":1},"771":{"tf":1},"818":{"tf":1},"881":{"tf":1}},"df":29}}},"i":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"43":{"tf":1},"63":{"tf":1},"65":{"tf":1},"125":{"tf":1},"128":{"tf":1.4142135623730951},"137":{"tf":1},"157":{"tf":1.4142135623730951},"161":{"tf":1},"182":{"tf":1.4142135623730951},"183":{"tf":1},"210":{"tf":1},"275":{"tf":1},"296":{"tf":1},"360":{"tf":1},"363":{"tf":1.4142135623730951},"372":{"tf":1},"392":{"tf":1.4142135623730951},"396":{"tf":1},"417":{"tf":1.4142135623730951},"418":{"tf":1},"506":{"tf":1},"527":{"tf":1},"581":{"tf":1.4142135623730951},"590":{"tf":1},"610":{"tf":1.4142135623730951},"614":{"tf":1},"635":{"tf":1.4142135623730951},"636":{"tf":1},"720":{"tf":1},"791":{"tf":1.4142135623730951},"800":{"tf":1},"820":{"tf":1},"824":{"tf":1.7320508075688772},"845":{"tf":1.4142135623730951},"846":{"tf":1},"907":{"tf":1},"916":{"tf":1}},"df":37}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"20":{"tf":1},"21":{"tf":1},"66":{"tf":1.4142135623730951},"177":{"tf":1},"215":{"tf":1},"224":{"tf":1},"225":{"tf":1},"412":{"tf":1},"446":{"tf":1},"455":{"tf":1},"456":{"tf":1},"483":{"tf":1},"526":{"tf":1},"528":{"tf":1.4142135623730951},"630":{"tf":1},"660":{"tf":1},"669":{"tf":1},"670":{"tf":1},"696":{"tf":1.4142135623730951},"697":{"tf":2},"698":{"tf":2.8284271247461903},"740":{"tf":1},"840":{"tf":1.4142135623730951},"875":{"tf":1}},"df":24}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"66":{"tf":1.4142135623730951},"220":{"tf":1.4142135623730951},"225":{"tf":1},"226":{"tf":1.7320508075688772},"229":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"451":{"tf":1.4142135623730951},"456":{"tf":1},"457":{"tf":2.449489742783178},"460":{"tf":1.4142135623730951},"463":{"tf":1.4142135623730951},"528":{"tf":1.4142135623730951},"665":{"tf":1.4142135623730951},"670":{"tf":1},"671":{"tf":2.449489742783178},"674":{"tf":1.4142135623730951},"677":{"tf":1.4142135623730951},"872":{"tf":1.4142135623730951},"877":{"tf":1},"878":{"tf":2.23606797749979},"881":{"tf":2},"892":{"tf":1},"907":{"tf":1}},"df":23}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{},"df":0,"t":{"docs":{"86":{"tf":1},"317":{"tf":1},"548":{"tf":1},"758":{"tf":1.4142135623730951},"767":{"tf":1},"778":{"tf":1.7320508075688772},"831":{"tf":1.4142135623730951}},"df":7},"s":{"docs":{"845":{"tf":1}},"df":1}},"n":{"docs":{},"df":0,"t":{"docs":{"168":{"tf":1},"403":{"tf":1},"621":{"tf":1},"831":{"tf":1.4142135623730951},"891":{"tf":1},"908":{"tf":1}},"df":6},"i":{"docs":{"960":{"tf":1}},"df":1}}}},"g":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"t":{"docs":{},"df":0,"u":{"docs":{},"df":0,"l":{"docs":{"949":{"tf":1}},"df":1}}}}}}},"m":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"3":{"tf":1},"213":{"tf":1},"214":{"tf":1},"351":{"tf":1},"444":{"tf":1},"445":{"tf":1},"658":{"tf":1},"659":{"tf":1},"907":{"tf":1}},"df":9,"l":{"docs":{},"df":0,"i":{"docs":{"195":{"tf":1},"430":{"tf":1},"648":{"tf":1},"858":{"tf":1}},"df":4}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"5":{"tf":1},"955":{"tf":1}},"df":2}}},"u":{"docs":{},"df":0,"n":{"docs":{"14":{"tf":1.4142135623730951},"246":{"tf":1.4142135623730951},"477":{"tf":1.4142135623730951},"691":{"tf":1.4142135623730951}},"df":4}},"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"81":{"tf":1},"128":{"tf":1},"187":{"tf":1},"189":{"tf":1.4142135623730951},"192":{"tf":1.7320508075688772},"213":{"tf":1},"215":{"tf":1.7320508075688772},"229":{"tf":1},"312":{"tf":1},"363":{"tf":1},"422":{"tf":1},"424":{"tf":1.4142135623730951},"427":{"tf":1.7320508075688772},"444":{"tf":1},"446":{"tf":1.7320508075688772},"460":{"tf":1},"543":{"tf":1},"581":{"tf":1},"640":{"tf":1},"642":{"tf":1.4142135623730951},"645":{"tf":1.7320508075688772},"658":{"tf":1},"660":{"tf":1.7320508075688772},"674":{"tf":1},"791":{"tf":1},"797":{"tf":1},"850":{"tf":1},"852":{"tf":1.7320508075688772},"855":{"tf":2.6457513110645907},"866":{"tf":1.4142135623730951},"881":{"tf":1}},"df":31}}}},"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1.7320508075688772},"27":{"tf":1},"77":{"tf":1.4142135623730951},"81":{"tf":1.7320508075688772},"112":{"tf":2.23606797749979},"115":{"tf":1},"116":{"tf":3},"119":{"tf":4.795831523312719},"120":{"tf":1.4142135623730951},"121":{"tf":1.4142135623730951},"122":{"tf":5.477225575051661},"125":{"tf":5.196152422706632},"202":{"tf":1.4142135623730951},"203":{"tf":1},"205":{"tf":1.7320508075688772},"212":{"tf":1},"216":{"tf":1.7320508075688772},"231":{"tf":1},"232":{"tf":1.4142135623730951},"240":{"tf":1.4142135623730951},"253":{"tf":1.7320508075688772},"259":{"tf":1},"305":{"tf":1.4142135623730951},"308":{"tf":1.4142135623730951},"312":{"tf":1.7320508075688772},"343":{"tf":2.23606797749979},"346":{"tf":1},"347":{"tf":3},"350":{"tf":3.7416573867739413},"351":{"tf":1.7320508075688772},"354":{"tf":5.656854249492381},"355":{"tf":1.4142135623730951},"356":{"tf":2.449489742783178},"357":{"tf":5.477225575051661},"360":{"tf":5.196152422706632},"437":{"tf":1},"438":{"tf":1},"440":{"tf":1.7320508075688772},"443":{"tf":1},"447":{"tf":1.7320508075688772},"462":{"tf":1},"463":{"tf":1.4142135623730951},"490":{"tf":1},"534":{"tf":1.4142135623730951},"539":{"tf":1.7320508075688772},"543":{"tf":1.7320508075688772},"574":{"tf":2.23606797749979},"577":{"tf":1},"578":{"tf":3},"657":{"tf":1},"661":{"tf":1.7320508075688772},"676":{"tf":1},"677":{"tf":1.4142135623730951},"704":{"tf":1},"750":{"tf":1},"757":{"tf":1.4142135623730951},"781":{"tf":2.6457513110645907},"784":{"tf":1},"785":{"tf":1.7320508075688772},"788":{"tf":3.1622776601683795},"868":{"tf":1.7320508075688772},"876":{"tf":1},"877":{"tf":1},"881":{"tf":1.7320508075688772},"916":{"tf":1},"924":{"tf":1},"932":{"tf":1},"933":{"tf":1.4142135623730951},"936":{"tf":1},"937":{"tf":1.4142135623730951},"938":{"tf":1.4142135623730951},"939":{"tf":2.8284271247461903},"940":{"tf":1},"941":{"tf":1.7320508075688772},"944":{"tf":1},"946":{"tf":2.449489742783178},"948":{"tf":2},"954":{"tf":1.7320508075688772},"955":{"tf":1},"958":{"tf":1},"961":{"tf":1}},"df":81,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"t":{"docs":{},"df":0,"f":{"docs":{},"df":0,"o":{"docs":{},"df":0,"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"x":{"docs":{},"df":0,"c":{"docs":{},"df":0,"e":{"docs":{},"df":0,"p":{"docs":{},"df":0,"t":{"docs":{"119":{"tf":1.7320508075688772},"354":{"tf":1.7320508075688772},"928":{"tf":1}},"df":3}}}}}}}}}}}}}}}}}},"u":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"125":{"tf":1},"360":{"tf":1}},"df":2}}}},"l":{"docs":{},"df":0,"e":{"docs":{},"df":0,"t":{"docs":{"21":{"tf":1},"51":{"tf":1},"54":{"tf":1},"128":{"tf":1},"146":{"tf":1},"161":{"tf":1},"232":{"tf":1},"253":{"tf":1},"283":{"tf":1},"286":{"tf":1},"314":{"tf":1},"363":{"tf":1},"381":{"tf":1},"396":{"tf":1},"463":{"tf":1},"484":{"tf":1},"514":{"tf":1},"517":{"tf":1},"581":{"tf":1},"599":{"tf":1},"614":{"tf":1},"677":{"tf":1},"698":{"tf":1},"728":{"tf":1},"742":{"tf":1},"760":{"tf":1},"770":{"tf":1},"773":{"tf":1},"791":{"tf":1},"803":{"tf":1},"841":{"tf":1},"858":{"tf":1},"881":{"tf":1},"912":{"tf":1},"948":{"tf":1}},"df":35},"x":{"docs":{"119":{"tf":1.4142135623730951},"182":{"tf":1},"350":{"tf":1.4142135623730951},"354":{"tf":1.7320508075688772},"417":{"tf":1},"635":{"tf":1},"748":{"tf":1},"749":{"tf":1},"915":{"tf":1}},"df":9}}},"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"43":{"tf":1},"275":{"tf":1},"506":{"tf":1},"720":{"tf":1}},"df":4}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"s":{"docs":{"119":{"tf":1}},"df":1}}},"a":{"docs":{},"df":0,"r":{"docs":{"171":{"tf":1},"406":{"tf":1},"624":{"tf":1},"834":{"tf":1}},"df":4,"i":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{"171":{"tf":1},"406":{"tf":1},"624":{"tf":1}},"df":3}}}}},"c":{"docs":{},"df":0,"t":{"docs":{"717":{"tf":1.7320508075688772}},"df":1}}},"i":{"docs":{},"df":0,"d":{"docs":{"948":{"tf":1.4142135623730951},"949":{"tf":1},"954":{"tf":1}},"df":3}}},"e":{"docs":{"4":{"tf":1},"26":{"tf":1},"37":{"tf":1},"38":{"tf":1},"50":{"tf":1},"64":{"tf":1},"125":{"tf":1},"128":{"tf":1},"131":{"tf":1},"177":{"tf":1},"192":{"tf":1},"195":{"tf":1},"226":{"tf":1},"258":{"tf":1},"269":{"tf":1},"270":{"tf":1},"282":{"tf":1},"295":{"tf":1},"350":{"tf":1},"351":{"tf":1},"360":{"tf":1},"363":{"tf":1},"366":{"tf":1},"412":{"tf":1},"427":{"tf":1},"430":{"tf":1},"489":{"tf":1},"500":{"tf":1},"501":{"tf":1},"513":{"tf":1},"526":{"tf":1},"581":{"tf":1},"584":{"tf":1},"630":{"tf":1},"645":{"tf":1},"648":{"tf":1},"703":{"tf":1},"714":{"tf":1},"715":{"tf":1},"898":{"tf":1},"917":{"tf":1}},"df":41},"b":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"4":{"tf":1},"161":{"tf":1},"350":{"tf":1},"396":{"tf":1},"614":{"tf":1},"824":{"tf":1},"915":{"tf":1},"916":{"tf":1},"918":{"tf":1},"929":{"tf":1.4142135623730951}},"df":10}},"o":{"docs":{"72":{"tf":1},"303":{"tf":1},"305":{"tf":1},"534":{"tf":1}},"df":4,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"x":{"docs":{"140":{"tf":1.7320508075688772},"204":{"tf":1.4142135623730951},"375":{"tf":1.7320508075688772},"439":{"tf":1.4142135623730951},"593":{"tf":1.7320508075688772},"803":{"tf":1.7320508075688772}},"df":6,"/":{"docs":{},"df":0,"c":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{"204":{"tf":1}},"df":1}}}}}}}}}}}},"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"s":{"docs":{"4":{"tf":1},"39":{"tf":1},"105":{"tf":1},"125":{"tf":1},"210":{"tf":1},"232":{"tf":1},"271":{"tf":1},"336":{"tf":1},"360":{"tf":1},"463":{"tf":1},"502":{"tf":1},"567":{"tf":1},"677":{"tf":1},"716":{"tf":1},"881":{"tf":1},"924":{"tf":1},"941":{"tf":1},"946":{"tf":1}},"df":18}},"n":{"docs":{},"df":0,"t":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2,"e":{"docs":{},"df":0,"r":{"docs":{"27":{"tf":1},"28":{"tf":1.4142135623730951},"231":{"tf":1},"232":{"tf":1.4142135623730951},"259":{"tf":1},"260":{"tf":1.4142135623730951},"462":{"tf":1},"463":{"tf":1.4142135623730951},"490":{"tf":1},"491":{"tf":1.4142135623730951},"676":{"tf":1},"677":{"tf":1.4142135623730951},"704":{"tf":1},"705":{"tf":1.4142135623730951},"881":{"tf":1.7320508075688772},"895":{"tf":1.4142135623730951}},"df":16}}}}},"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"40":{"tf":1},"67":{"tf":1},"119":{"tf":1},"199":{"tf":1},"214":{"tf":1},"272":{"tf":1},"298":{"tf":1},"354":{"tf":1},"434":{"tf":1},"445":{"tf":1},"503":{"tf":1},"529":{"tf":1},"652":{"tf":1},"659":{"tf":1},"717":{"tf":1},"791":{"tf":1},"827":{"tf":1},"886":{"tf":1}},"df":18}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"c":{"docs":{},"df":0,"t":{"docs":{"51":{"tf":1},"155":{"tf":1},"157":{"tf":1},"181":{"tf":1.4142135623730951},"182":{"tf":1.4142135623730951},"192":{"tf":1},"231":{"tf":1},"283":{"tf":1},"305":{"tf":1},"390":{"tf":1},"392":{"tf":1},"416":{"tf":1.4142135623730951},"417":{"tf":1.4142135623730951},"427":{"tf":1},"462":{"tf":1},"514":{"tf":1},"608":{"tf":1},"610":{"tf":1},"634":{"tf":1.4142135623730951},"635":{"tf":1.4142135623730951},"645":{"tf":1},"676":{"tf":1},"728":{"tf":1},"820":{"tf":1.4142135623730951},"840":{"tf":1.4142135623730951},"841":{"tf":1},"844":{"tf":1},"845":{"tf":1.4142135623730951},"881":{"tf":1},"893":{"tf":1},"905":{"tf":1},"907":{"tf":1}},"df":32,"l":{"docs":{},"df":0,"i":{"docs":{"177":{"tf":1},"412":{"tf":1},"630":{"tf":1},"918":{"tf":1}},"df":4}}}},"s":{"docs":{},"df":0,"p":{"docs":{},"df":0,"o":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{"156":{"tf":1},"391":{"tf":1},"609":{"tf":1},"697":{"tf":1},"770":{"tf":1.4142135623730951},"771":{"tf":1},"774":{"tf":1},"818":{"tf":1},"832":{"tf":1},"845":{"tf":1},"855":{"tf":1.4142135623730951},"868":{"tf":1.7320508075688772}},"df":12}}}}}}},"n":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"74":{"tf":1},"305":{"tf":1},"536":{"tf":1}},"df":3}}}},"p":{"docs":{},"df":0,"y":{"docs":{},"df":0,"/":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"81":{"tf":1},"105":{"tf":1},"312":{"tf":1},"336":{"tf":1},"543":{"tf":1},"567":{"tf":1},"774":{"tf":1}},"df":7}}}}}},"i":{"docs":{"97":{"tf":1},"155":{"tf":1},"175":{"tf":1},"176":{"tf":1},"178":{"tf":1},"183":{"tf":1},"195":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"232":{"tf":1},"328":{"tf":1},"390":{"tf":1},"410":{"tf":1},"411":{"tf":1},"413":{"tf":1},"418":{"tf":1},"430":{"tf":1.4142135623730951},"444":{"tf":1.4142135623730951},"463":{"tf":1},"559":{"tf":1},"608":{"tf":1},"628":{"tf":1},"629":{"tf":1},"631":{"tf":1},"636":{"tf":1},"648":{"tf":1.4142135623730951},"658":{"tf":1.4142135623730951},"677":{"tf":1},"766":{"tf":1},"838":{"tf":1},"839":{"tf":1},"846":{"tf":1},"858":{"tf":1.4142135623730951},"881":{"tf":1},"889":{"tf":1},"896":{"tf":1},"905":{"tf":1},"906":{"tf":1},"908":{"tf":1},"920":{"tf":1},"925":{"tf":1},"932":{"tf":1},"935":{"tf":1}},"df":42}},"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"a":{"docs":{},"df":0,"p":{"docs":{},"df":0,"s":{"docs":{"86":{"tf":1.4142135623730951},"209":{"tf":1},"232":{"tf":1},"317":{"tf":1.4142135623730951},"463":{"tf":1},"548":{"tf":1.4142135623730951},"677":{"tf":1},"803":{"tf":1},"881":{"tf":1}},"df":9,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{"209":{"tf":1}},"df":1}}}}}}}},"u":{"docs":{},"df":0,"m":{"docs":{},"df":0,"n":{"docs":{"116":{"tf":1.4142135623730951},"125":{"tf":1},"171":{"tf":1},"208":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"350":{"tf":1.4142135623730951},"360":{"tf":1},"406":{"tf":1},"441":{"tf":1.4142135623730951},"578":{"tf":1.4142135623730951},"624":{"tf":1},"785":{"tf":1.4142135623730951},"834":{"tf":1},"895":{"tf":2},"898":{"tf":1}},"df":15}}},"o":{"docs":{},"df":0,"n":{"docs":{"125":{"tf":2},"360":{"tf":2}},"df":2}}},"d":{"docs":{},"df":0,"e":{"docs":{"168":{"tf":1},"169":{"tf":1},"189":{"tf":1},"350":{"tf":1},"403":{"tf":1},"404":{"tf":1},"424":{"tf":1},"621":{"tf":1},"622":{"tf":1},"642":{"tf":1},"831":{"tf":1},"832":{"tf":1}},"df":12}},"o":{"docs":{},"df":0,"k":{"docs":{},"df":0,"i":{"docs":{"253":{"tf":1}},"df":1}}},"s":{"docs":{},"df":0,"t":{"docs":{"754":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{"4":{"tf":1}},"df":1}}},"e":{"docs":{},"df":0,"r":{"docs":{"350":{"tf":1}},"df":1}}}},"r":{"docs":{},"df":0,"t":{"docs":{},"df":0,"a":{"docs":{},"df":0,"i":{"docs":{},"df":0,"n":{"docs":{"43":{"tf":1},"77":{"tf":1},"119":{"tf":1.4142135623730951},"122":{"tf":1},"143":{"tf":1},"195":{"tf":1},"198":{"tf":1},"224":{"tf":1},"229":{"tf":1.7320508075688772},"275":{"tf":1},"308":{"tf":1},"350":{"tf":1},"354":{"tf":1.4142135623730951},"357":{"tf":1},"378":{"tf":1},"430":{"tf":1},"433":{"tf":1},"455":{"tf":1},"460":{"tf":1.7320508075688772},"506":{"tf":1},"539":{"tf":1},"596":{"tf":1},"648":{"tf":1},"651":{"tf":1},"669":{"tf":1},"674":{"tf":1.7320508075688772},"720":{"tf":1},"788":{"tf":1},"806":{"tf":1},"858":{"tf":1},"876":{"tf":1},"881":{"tf":1.4142135623730951},"915":{"tf":1},"939":{"tf":1},"941":{"tf":1}},"df":35}}}}},"l":{"docs":{},"df":0,"l":{"docs":{"72":{"tf":1},"115":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"125":{"tf":1},"208":{"tf":1},"303":{"tf":1},"346":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"350":{"tf":1.4142135623730951},"351":{"tf":1},"360":{"tf":1},"441":{"tf":1},"534":{"tf":1},"577":{"tf":1.4142135623730951},"578":{"tf":1.4142135623730951}},"df":15}}},"l":{"docs":{},"df":0,"i":{"docs":{},"df":0,"c":{"docs":{},"df":0,"k":{"docs":{"15":{"tf":1},"21":{"tf":1.4142135623730951},"27":{"tf":1.7320508075688772},"33":{"tf":1},"38":{"tf":1},"67":{"tf":1},"72":{"tf":1},"73":{"tf":1.4142135623730951},"77":{"tf":1.4142135623730951},"82":{"tf":1.4142135623730951},"86":{"tf":1},"90":{"tf":1},"102":{"tf":1.4142135623730951},"103":{"tf":1},"105":{"tf":1},"115":{"tf":1.7320508075688772},"116":{"tf":1.7320508075688772},"119":{"tf":1},"122":{"tf":1.7320508075688772},"125":{"tf":2},"134":{"tf":1.4142135623730951},"152":{"tf":1},"155":{"tf":1},"168":{"tf":1},"176":{"tf":1},"177":{"tf":1.4142135623730951},"178":{"tf":1.4142135623730951},"182":{"tf":2},"229":{"tf":1.7320508075688772},"230":{"tf":1},"231":{"tf":1.7320508075688772},"232":{"tf":1.4142135623730951},"247":{"tf":1},"253":{"tf":1.4142135623730951},"259":{"tf":1.7320508075688772},"265":{"tf":1},"270":{"tf":1},"298":{"tf":1},"303":{"tf":1},"304":{"tf":1.4142135623730951},"308":{"tf":1.4142135623730951},"313":{"tf":1.4142135623730951},"317":{"tf":1.4142135623730951},"321":{"tf":1},"333":{"tf":1.4142135623730951},"334":{"tf":1},"336":{"tf":1},"346":{"tf":1.7320508075688772},"347":{"tf":1.7320508075688772},"350":{"tf":2},"354":{"tf":1},"357":{"tf":1.7320508075688772},"360":{"tf":2},"369":{"tf":1.4142135623730951},"387":{"tf":1},"390":{"tf":1},"403":{"tf":1},"411":{"tf":1},"412":{"tf":1.4142135623730951},"413":{"tf":1.4142135623730951},"417":{"tf":2},"460":{"tf":1.7320508075688772},"461":{"tf":1},"462":{"tf":1.7320508075688772},"463":{"tf":1.4142135623730951},"478":{"tf":1},"484":{"tf":1.4142135623730951},"490":{"tf":1.7320508075688772},"496":{"tf":1},"501":{"tf":1},"529":{"tf":1},"534":{"tf":1},"535":{"tf":1.4142135623730951},"539":{"tf":1.7320508075688772},"544":{"tf":1.4142135623730951},"548":{"tf":1},"552":{"tf":1},"564":{"tf":1.4142135623730951},"565":{"tf":1},"567":{"tf":1},"577":{"tf":1.7320508075688772},"578":{"tf":1.7320508075688772},"587":{"tf":1.4142135623730951},"605":{"tf":1},"608":{"tf":1},"621":{"tf":1},"629":{"tf":1},"630":{"tf":1.4142135623730951},"631":{"tf":1.4142135623730951},"635":{"tf":2},"674":{"tf":1.7320508075688772},"675":{"tf":1},"676":{"tf":1.7320508075688772},"677":{"tf":1.4142135623730951},"692":{"tf":1},"698":{"tf":1},"704":{"tf":1.7320508075688772},"710":{"tf":1},"715":{"tf":1},"747":{"tf":1.4142135623730951},"749":{"tf":1},"750":{"tf":1},"754":{"tf":1},"757":{"tf":1},"758":{"tf":1},"771":{"tf":1.7320508075688772},"772":{"tf":1},"774":{"tf":1},"784":{"tf":1.7320508075688772},"797":{"tf":1},"812":{"tf":1.4142135623730951},"815":{"tf":1},"818":{"tf":1},"821":{"tf":1},"831":{"tf":1},"839":{"tf":1.4142135623730951},"840":{"tf":1},"841":{"tf":1},"845":{"tf":2.23606797749979},"881":{"tf":4.123105625617661},"894":{"tf":1.4142135623730951},"895":{"tf":1},"909":{"tf":1.4142135623730951},"912":{"tf":1.4142135623730951},"921":{"tf":1.4142135623730951},"925":{"tf":1},"936":{"tf":1},"939":{"tf":1},"946":{"tf":1},"949":{"tf":1}},"df":130}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"20":{"tf":1.7320508075688772},"21":{"tf":1.4142135623730951},"40":{"tf":1},"47":{"tf":1},"66":{"tf":2.6457513110645907},"90":{"tf":1},"177":{"tf":1},"187":{"tf":1},"192":{"tf":1},"199":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"225":{"tf":1},"226":{"tf":1.7320508075688772},"252":{"tf":1},"253":{"tf":1.4142135623730951},"272":{"tf":1},"279":{"tf":1},"321":{"tf":1},"412":{"tf":1},"422":{"tf":1},"427":{"tf":1},"434":{"tf":1.4142135623730951},"455":{"tf":1.4142135623730951},"456":{"tf":1},"457":{"tf":1.7320508075688772},"483":{"tf":1.7320508075688772},"484":{"tf":1.7320508075688772},"503":{"tf":1},"510":{"tf":1},"528":{"tf":2.449489742783178},"552":{"tf":1},"630":{"tf":1},"640":{"tf":1},"645":{"tf":1},"652":{"tf":1.4142135623730951},"669":{"tf":1.4142135623730951},"670":{"tf":1},"671":{"tf":1.7320508075688772},"697":{"tf":1},"698":{"tf":1.7320508075688772},"717":{"tf":1},"724":{"tf":1.4142135623730951},"850":{"tf":1},"855":{"tf":1},"862":{"tf":1.4142135623730951},"910":{"tf":1},"946":{"tf":1.4142135623730951}},"df":47,"'":{"docs":{"77":{"tf":1},"308":{"tf":1},"539":{"tf":1}},"df":3}}}}},"o":{"docs":{},"df":0,"s":{"docs":{},"df":0,"e":{"docs":{"37":{"tf":1},"50":{"tf":1},"65":{"tf":1},"86":{"tf":1.7320508075688772},"140":{"tf":1},"158":{"tf":1},"176":{"tf":1},"178":{"tf":1},"210":{"tf":2},"269":{"tf":1},"282":{"tf":1},"296":{"tf":1},"317":{"tf":2},"375":{"tf":1},"393":{"tf":1},"411":{"tf":1},"413":{"tf":1},"500":{"tf":1},"513":{"tf":1},"527":{"tf":1},"548":{"tf":1.7320508075688772},"593":{"tf":1},"611":{"tf":1},"629":{"tf":1},"631":{"tf":1},"696":{"tf":1},"714":{"tf":1},"794":{"tf":1},"797":{"tf":1},"839":{"tf":1},"841":{"tf":1},"855":{"tf":1},"866":{"tf":1},"896":{"tf":1},"907":{"tf":1},"915":{"tf":2.449489742783178},"916":{"tf":1},"921":{"tf":1},"925":{"tf":1},"927":{"tf":1},"936":{"tf":1}},"df":41,"r":{"docs":{"50":{"tf":1},"131":{"tf":1},"202":{"tf":1},"223":{"tf":1},"282":{"tf":1},"366":{"tf":1},"437":{"tf":1},"454":{"tf":1},"513":{"tf":1},"584":{"tf":1},"655":{"tf":1},"668":{"tf":1},"784":{"tf":1},"865":{"tf":1},"875":{"tf":1},"912":{"tf":1},"913":{"tf":1},"915":{"tf":1},"917":{"tf":1},"937":{"tf":1},"943":{"tf":1},"960":{"tf":1}},"df":22},"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"l":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{"210":{"tf":1}},"df":1}}}}}}}}}},"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"u":{"docs":{"210":{"tf":1}},"df":1}}}},"d":{"docs":{},"df":0,"i":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"o":{"docs":{},"df":0,"g":{"docs":{},"df":0,"s":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{},"df":0,"d":{"docs":{},"df":0,"m":{"docs":{},"df":0,"o":{"docs":{},"df":0,"d":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"e":{"docs":{},"df":0,"l":{"docs":{"210":{"tf":1}},"df":1}}}}}}}}}}}}}}}}}}}}}},"k":{"docs":{},"df":0,"e":{"docs":{},"df":0,"y":{"docs":{},"df":0,"b":{"docs":{},"df":0,"o":{"docs":{},"df":0,"a":{"docs":{},"df":0,"r":{"docs":{},"df":0,"d":{"docs":{"866":{"tf":1}},"df":1}}}}}}}}}}},"e":{"docs":{},"df":0,"a":{"docs":{},"df":0,"n":{"docs":{"51":{"tf":1},"283":{"tf":1},"514":{"tf":1},"728":{"tf":1},"918":{"tf":1},"921":{"tf":1}},"df":6,"u":{"docs":{},"df":0,"p":{"docs":{"46":{"tf":1.4142135623730951},"47":{"tf":1.7320508075688772},"51":{"tf":1.4142135623730951},"81":{"tf":1},"86":{"tf":2.23606797749979},"87":{"tf":1},"140":{"tf":1.7320508075688772},"157":{"tf":1},"210":{"tf":1.4142135623730951},"232":{"tf":1.4142135623730951},"278":{"tf":1.4142135623730951},"279":{"tf":1.7320508075688772},"283":{"tf":1.4142135623730951},"312":{"tf":1},"317":{"tf":2.23606797749979},"318":{"tf":1},"375":{"tf":1.7320508075688772},"392":{"tf":1},"463":{"tf":1.4142135623730951},"509":{"tf":1.4142135623730951},"510":{"tf":1.7320508075688772},"514":{"tf":1.4142135623730951},"543":{"tf":1},"548":{"tf":2.23606797749979},"549":{"tf":1},"593":{"tf":1.7320508075688772},"610":{"tf":1},"677":{"tf":1.4142135623730951},"723":{"tf":1.4142135623730951},"724":{"tf":1.4142135623730951},"728":{"tf":1.4142135623730951},"757":{"tf":1},"760":{"tf":1},"803":{"tf":1.7320508075688772},"820":{"tf":1},"881":{"tf":1.4142135623730951},"892":{"tf":1},"896":{"tf":1},"906":{"tf":1},"907":{"tf":1.7320508075688772},"908":{"tf":1},"909":{"tf":1},"911":{"tf":1.7320508075688772},"912":{"tf":1},"915":{"tf":1.4142135623730951},"917":{"tf":1.4142135623730951},"918":{"tf":1},"921":{"tf":1.4142135623730951},"929":{"tf":2.23606797749979}},"df":49}}},"r":{"docs":{"119":{"tf":1},"134":{"tf":1},"192":{"tf":1},"369":{"tf":1},"427":{"tf":1},"587":{"tf":1},"645":{"tf":1},"855":{"tf":1.4142135623730951}},"df":8}}},"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"s":{"docs":{"122":{"tf":3.4641016151377544},"125":{"tf":2},"215":{"tf":1},"357":{"tf":3.1622776601683795},"360":{"tf":2},"446":{"tf":1},"660":{"tf":1},"788":{"tf":1},"944":{"tf":1.4142135623730951},"946":{"tf":2},"954":{"tf":1.4142135623730951},"957":{"tf":1}},"df":12}}}},"t":{"docs":{},"df":0,"r":{"docs":{},"df":0,"l":{"docs":{"38":{"tf":1},"182":{"tf":1},"270":{"tf":1},"417":{"tf":1},"501":{"tf":1},"635":{"tf":1},"715":{"tf":1},"845":{"tf":1}},"df":8,"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{"68":{"tf":1},"299":{"tf":1},"530":{"tf":1},"743":{"tf":1}},"df":4,"l":{"docs":{"37":{"tf":1},"90":{"tf":1},"158":{"tf":1},"269":{"tf":1},"321":{"tf":1},"393":{"tf":1},"500":{"tf":1},"552":{"tf":1},"611":{"tf":1},"714":{"tf":1},"821":{"tf":1}},"df":11},"x":{"docs":{"81":{"tf":1},"312":{"tf":1},"543":{"tf":1},"757":{"tf":1},"909":{"tf":1}},"df":5},"v":{"docs":{"81":{"tf":1},"312":{"tf":1},"543":{"tf":1},"757":{"tf":1},"909":{"tf":1}},"df":5},"a":{"docs":{"103":{"tf":1},"231":{"tf":1.4142135623730951},"334":{"tf":1},"462":{"tf":1.4142135623730951},"565":{"tf":1},"676":{"tf":1.4142135623730951},"772":{"tf":1},"881":{"tf":1.4142135623730951}},"df":8},"s":{"docs":{},"df":0,"h":{"docs":{},"df":0,"i":{"docs":{},"df":0,"f":{"docs":{},"df":0,"t":{"docs":{},"df":0,"⁠":{"docs":{},"df":0,"+":{"docs":{},"df":0,"⁠":{"docs":{"168":{"tf":1},"403":{"tf":1},"621":{"tf":1},"831":{"tf":1}},"df":4,"p":{"docs":{"109":{"tf":1.4142135623730951},"168":{"tf":1},"340":{"tf":1.4142135623730951},"403":{"tf":1},"571":{"tf":1.4142135623730951},"621":{"tf":1},"778":{"tf":1},"831":{"tf":1}},"df":8},"i":{"docs":{"232":{"tf":1},"463":{"tf":1},"677":{"tf":1},"881":{"tf":1}},"df":4}}}}}}}}},"w":{"docs":{"119":{"tf":1},"354":{"tf":1}},"df":2},"z":{"docs":{"122":{"tf":1},"357":{"tf":1}},"df":2},"f":{"8":{"docs":{"128":{"tf":1},"131":{"tf":1},"133":{"tf":1},"134":{"tf":1},"363":{"tf":1},"366":{"tf":1},"368":{"tf":1},"369":{"tf":1},"581":{"tf":1},"584":{"tf":1},"586":{"tf":1},"587":{"tf":1},"791":{"tf":1},"794":{"tf":1},"796":{"tf":1},"797":{"tf":1}},"df":16},"docs":{},"df":0},"j":{"docs":{"128":{"tf":1},"158":{"tf":1},"363":{"tf":1},"393":{"tf":1},"581":{"tf":1},"611":{"tf":1},"791":{"tf":1},"821":{"tf":1}},"df":8}}}}}}},"u":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{},"df":0,"o":{"docs":{},"df":0,"m":{"docs":{"43":{"tf":1},"125":{"tf":1},"275":{"tf":1},"351":{"tf":1},"356":{"tf":1},"360":{"tf":1},"506":{"tf":1},"720":{"tf":1},"890":{"tf":1}},"df":9,"w":{"docs":{},"df":0,"e":{"docs":{},"df":0,"b":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"l":{"docs":{},"df":0,"v":{"docs":{"253":{"tf":1},"351":{"tf":1},"354":{"tf":1},"356":{"tf":1}},"df":4}}}}}}}}}}}}},"t":{"docs":{"68":{"tf":1},"90":{"tf":1},"299":{"tf":1},"321":{"tf":1},"530":{"tf":1},"552":{"tf":1},"909":{"tf":1}},"df":7,"/":{"docs":{},"df":0,"p":{"docs":{},"df":0,"a":{"docs":{},"df":0,"s":{"docs":{},"df":0,"t":{"docs":{"102":{"tf":1},"333":{"tf":1},"564":{"tf":1},"757":{"tf":1},"771":{"tf":1}},"df":5}}}}}},"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{"77":{"tf":1},"125":{"tf":1},"128":{"tf":1.7320508075688772},"134":{"tf":1.4142135623730951},"137":{"tf":1},"138":{"tf":1},"143":{"tf":1},"155":{"tf":1},"156":{"tf":1},"158":{"tf":1.4142135623730951},"177":{"tf":1.4142135623730951},"182":{"tf":1.7320508075688772},"184":{"tf":2.23606797749979},"192":{"tf":1},"210":{"tf":1},"214":{"tf":1.7320508075688772},"308":{"tf":1},"354":{"tf":1},"360":{"tf":1},"363":{"tf":1.7320508075688772},"369":{"tf":1.4142135623730951},"372":{"tf":1},"373":{"tf":1},"378":{"tf":1},"390":{"tf":1},"391":{"tf":1},"393":{"tf":1.4142135623730951},"412":{"tf":1.4142135623730951},"417":{"tf":1.7320508075688772},"419":{"tf":2.23606797749979},"427":{"tf":1},"445":{"tf":1.7320508075688772},"539":{"tf":1},"581":{"tf":1.7320508075688772},"587":{"tf":1.4142135623730951},"590":{"tf":1},"591":{"tf":1},"596":{"tf":1},"608":{"tf":1},"609":{"tf":1},"611":{"tf":1.4142135623730951},"630":{"tf":1.4142135623730951},"635":{"tf":1.7320508075688772},"637":{"tf":2.23606797749979},"645":{"tf":1},"659":{"tf":1.7320508075688772},"692":{"tf":1},"698":{"tf":1},"791":{"tf":1.7320508075688772},"797":{"tf":1.4142135623730951},"806":{"tf":1},"808":{"tf":1},"821":{"tf":1.4142135623730951},"824":{"tf":1},"839":{"tf":1},"840":{"tf":1},"845":{"tf":1.4142135623730951},"847":{"tf":2},"852":{"tf":1},"855":{"tf":1},"866":{"tf":1},"867":{"tf":1.7320508075688772},"895":{"tf":1},"907":{"tf":1},"936":{"tf":1},"939":{"tf":1.4142135623730951},"944":{"tf":1},"948":{"tf":1},"951":{"tf":1.4142135623730951},"952":{"tf":1},"953":{"tf":1},"958":{"tf":2.23606797749979},"959":{"tf":1},"961":{"tf":1}},"df":74,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"951":{"tf":1},"958":{"tf":1}},"df":2}}}}},"c":{"docs":{"168":{"tf":1},"403":{"tf":1},"621":{"tf":1},"831":{"tf":1}},"df":4}}}},"s":{"docs":{},"df":0,"o":{"docs":{},"df":0,"r":{"docs":{"86":{"tf":1},"317":{"tf":1},"534":{"tf":1.4142135623730951},"548":{"tf":1}},"df":4}}}}},"m":{"docs":{},"df":0,"d":{"docs":{"63":{"tf":1}},"df":1}},"f":{"docs":{"177":{"tf":1},"412":{"tf":1},"630":{"tf":1},"840":{"tf":1},"855":{"tf":1}},"df":5},"s":{"docs":{},"df":0,"v":{"docs":{"894":{"tf":1},"901":{"tf":1}},"df":2}},"c":{"docs":{},"df":0,"u":{"docs":{},"df":0,"r":{"docs":{},"df":0,"r":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{},"df":0,"t":{"docs":{},"df":0,"v":{"docs":{},"df":0,"a":{"docs":{},"df":0,"l":{"docs":{},"df":0,"u":{"docs":{"958":{"tf":1},"959":{"tf":1},"960":{"tf":1.4142135623730951}},"df":3}}}}}}}}}},"o":{"docs":{},"df":0,"m":{"docs":{},"df":0,"p":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{"960":{"tf":1.4142135623730951}},"df":1}}}}}}},"o":{"docs":{},"df":0,"v":{"docs":{},"df":0,"e":{"docs":{},"df":0,"r":{"docs":{"77":{"tf":1},"86":{"tf":1},"128":{"tf":1.4142135623730951},"137":{"tf":1},"138":{"tf":1},"139":{"tf":1},"140":{"tf":1.7320508075688772},"143":{"tf":1},"144":{"tf":1.4142135623730951},"145":{"tf":1},"146":{"tf":1},"229":{"tf":1},"308":{"tf":1},"317":{"tf":1},"363":{"tf":1.4142135623730951},"372":{"tf":1},"373":{"tf":1},"374":{"tf":1},"375":{"tf":1.7320508075688772},"378":{"tf":1},"379":{"tf":1.4142135623730951},"380":{"tf":1},"381":{"tf":1},"460":{"tf":1},"539":{"tf":1.4142135623730951},"548":{"tf":1},"581":{"tf":1.4142135623730951},"590":{"tf":1},"591":{"tf":1},"592":{"tf":1},"593":{"tf":1.7320508075688772},"596":{"tf":1},"597":{"tf":1.4142135623730951},"598":{"tf":1},"599":{"tf":1},"674":{"tf":1},"763":{"tf":1},"791":{"tf":1.4142135623730951},"800":{"tf":1},"801":{"tf":1},"802":{"tf":1},"803":{"tf":1},"807":{"tf":1},"808":{"tf":1},"809":{"tf":1},"881":{"tf":1},"889":{"tf":1},"902":{"tf":1}},"df":48,"a":{"docs":{},"df":0,"l":{"docs":{"3":{"tf":1},"56":{"tf":1},"288":{"tf":1},"519":{"tf":1},"733":{"tf":1}},"df":5}},"v":{"docs":{},"df":0,"i":{"docs":{},"df":0,"e":{"docs":{},"df":0,"w":{"docs":{"3":{"tf":2},"4":{"tf":1},"56":{"tf":1.7320508075688772},"288":{"tf":1.7320508075688772},"519":{"tf":1.7320508075688772},"733":{"tf":1.7320508075688772},"791":{"tf":1},"899":{"tf":1}},"df":8}}}},"w":{"docs":{},"df":0,"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"t":{"docs":{"169":{"tf":1},"404":{"tf":1},"622":{"tf":1}},"df":3}}}},"r":{"docs":{},"df":0,"i":{"docs":{},"df":0,"d":{"docs":{},"df":0,"d":{"docs":{},"df":0,"e":{"docs":{},"df":0,"n":{"docs":{"192":{"tf":1},"427":{"tf":1},"645":{"tf":1},"832":{"tf":1},"855":{"tf":1}},"df":5}}}}}}}}},"r":{"docs":{"3":{"tf":1},"4":{"tf":2.23606797749979},"5":{"tf":1},"8":{"tf":1},"14":{"tf":1},"21":{"tf":1},"26":{"tf":1},"37":{"tf":1.4142135623730951},"38":{"tf":1},"40":{"tf":1},"43":{"tf":2.23606797749979},"55":{"tf":1},"64":{"tf":1},"67":{"tf":1},"68":{"tf":1},"81":{"tf":1},"86":{"tf":1.4142135623730951},"90":{"tf":1.4142135623730951},"102":{"tf":1.4142135623730951},"103":{"tf":1},"105":{"tf":1},"109":{"tf":1.4142135623730951},"116":{"tf":1.4142135623730951},"119":{"tf":1},"122":{"tf":2.6457513110645907},"125":{"tf":2.8284271247461903},"128":{"tf":1.7320508075688772},"134":{"tf":1.4142135623730951},"137":{"tf":1},"140":{"tf":2},"143":{"tf":1.4142135623730951},"145":{"tf":1},"146":{"tf":1},"149":{"tf":1.4142135623730951},"150":{"tf":1},"158":{"tf":1.4142135623730951},"161":{"tf":1},"168":{"tf":1.4142135623730951},"175":{"tf":1},"176":{"tf":1.4142135623730951},"178":{"tf":1},"182":{"tf":1.7320508075688772},"183":{"tf":1},"184":{"tf":1},"187":{"tf":1.4142135623730951},"189":{"tf":1.4142135623730951},"192":{"tf":2},"203":{"tf":1.7320508075688772},"204":{"tf":1},"205":{"tf":1},"206":{"tf":1},"207":{"tf":1.7320508075688772},"210":{"tf":1.4142135623730951},"213":{"tf":1.4142135623730951},"215":{"tf":1},"216":{"tf":1.4142135623730951},"217":{"tf":1.4142135623730951},"224":{"tf":1.4142135623730951},"226":{"tf":2},"232":{"tf":1},"240":{"tf":1},"246":{"tf":1},"258":{"tf":1},"269":{"tf":1.4142135623730951},"270":{"tf":1},"272":{"tf":1},"275":{"tf":2.23606797749979},"287":{"tf":1},"298":{"tf":1},"299":{"tf":1},"312":{"tf":1},"317":{"tf":1.4142135623730951},"321":{"tf":1.4142135623730951},"333":{"tf":1.4142135623730951},"334":{"tf":1},"336":{"tf":1},"340":{"tf":1.4142135623730951},"347":{"tf":1.4142135623730951},"350":{"tf":2},"354":{"tf":1.4142135623730951},"357":{"tf":2.449489742783178},"360":{"tf":2.8284271247461903},"363":{"tf":1.7320508075688772},"369":{"tf":1.4142135623730951},"372":{"tf":1},"375":{"tf":2},"378":{"tf":1.4142135623730951},"380":{"tf":1},"381":{"tf":1},"384":{"tf":1.4142135623730951},"385":{"tf":1},"393":{"tf":1.4142135623730951},"396":{"tf":1},"403":{"tf":1},"410":{"tf":1},"411":{"tf":1.4142135623730951},"413":{"tf":1},"417":{"tf":1.7320508075688772},"418":{"tf":1},"419":{"tf":1},"422":{"tf":1.4142135623730951},"424":{"tf":1.4142135623730951},"427":{"tf":2},"438":{"tf":1.4142135623730951},"444":{"tf":1.4142135623730951},"446":{"tf":1},"447":{"tf":1.4142135623730951},"448":{"tf":1.4142135623730951},"455":{"tf":1.4142135623730951},"457":{"tf":1.4142135623730951},"463":{"tf":1},"471":{"tf":1.4142135623730951},"477":{"tf":1},"489":{"tf":1},"500":{"tf":1.4142135623730951},"501":{"tf":1},"503":{"tf":1},"506":{"tf":2.23606797749979},"518":{"tf":1},"529":{"tf":1},"530":{"tf":1},"543":{"tf":1},"548":{"tf":1.4142135623730951},"552":{"tf":1.4142135623730951},"564":{"tf":1.4142135623730951},"565":{"tf":1},"567":{"tf":1},"571":{"tf":1.4142135623730951},"578":{"tf":1.4142135623730951},"581":{"tf":1.7320508075688772},"587":{"tf":1.4142135623730951},"590":{"tf":1},"593":{"tf":2},"596":{"tf":1.4142135623730951},"598":{"tf":1},"599":{"tf":1},"602":{"tf":1.4142135623730951},"603":{"tf":1},"611":{"tf":1.4142135623730951},"614":{"tf":1},"621":{"tf":1.4142135623730951},"628":{"tf":1},"629":{"tf":1.4142135623730951},"631":{"tf":1},"635":{"tf":1.7320508075688772},"636":{"tf":1},"637":{"tf":1},"640":{"tf":1.4142135623730951},"642":{"tf":1.4142135623730951},"645":{"tf":2},"658":{"tf":1.41421