#!/bin/sh

#############################################################################
# Wrapper script for calling the TestLinkImporter Jython class of QF-Test   #
# Author: QFS, www.qfs.de                                                   #
# Since: 3.5.1                                                              #
#############################################################################

#Determine QF-Test's version directory
QFTDIR=/opt/qftest/qftest-10.0.2-pro
export QFTDIR

#folder containing the .py file
TESTLINKINTEGRATORDIR=$QFTDIR/ext/testlink/api
export TESTLINKINTEGRATORDIR

#java used for executing
JAVA=java

#the classpath including QF-Test's Jython Jar
CLASSPATH=$CLASSPATH:$QFTDIR/lib/jython.jar

#The TestlinkIntegrator class
TESTLINKINTEGRATOR=$TESTLINKINTEGRATORDIR/TestLinkImporter.py

#Jython directory
JYTHONDIR=$QFTDIR/jython

#Launch the Java command
eval exec "$JAVA" -classpath "$CLASSPATH" -Dpython.home="$JYTHONDIR" org.python.util.jython -S $TESTLINKINTEGRATOR $@
