package de.qfs
import java.util.List
class AI{
    //  redirected constants
    //  redirected methods
    private final de.qfs.apps.qftest.shared.script.modules.AI __wrappedInstance
    public AI(){
        __wrappedInstance = de.qfs.apps.qftest.shared.script.modules.AI.instance()
    }
    /**
     * Define a default AI configuration to use instead of the first one configured in Options > Artificial Intelligence
     * 
     * @param provider      Currently available provider types: <code>OpenAIGeneric</code>, <code>Anthropic</code>, <code>Gemini</code> and <code>Ollama</code>
     * @param baseUrl       The base API URL endpoint to the provider. Usually ends with <code>/v1</code> oder similar
     * @param apiKey        The API key to submit to the provider
     * @param modelName     The name of the model to use, like <code>gpt-4o</code> or <code>gemini-2.0-flash</code>
     * @param displayName   How QF-Test will identify the configuration in logs and error messages, defaults to <code>Default</code>
     */
    public void setDefaultConfig(String provider, String baseUrl, String apiKey, String modelName, String displayName=null){
        __wrappedInstance.setDefaultConfig(provider, baseUrl, apiKey, modelName, displayName)
    }
    /**
     * Define a default AI configuration to use instead of the first one configured in Options > Artificial Intelligence
     * 
     * @param provider      Currently available provider types: <code>OpenAIGeneric</code>, <code>Anthropic</code>, <code>Gemini</code> and <code>Ollama</code>
     * @param baseUrl       The base API URL endpoint to the provider. Usually ends with <code>/v1</code> oder similar
     * @param apiKey        The API key to submit to the provider
     * @param modelName     The name of the model to use, like <code>gpt-4o</code> or <code>gemini-2.0-flash</code>
     * @param displayName   How QF-Test will identify the configuration in logs and error messages, defaults to <code>Default</code>
     */
    public void setDefaultConfig(Map mappedParams, String provider, String baseUrl, String apiKey, String modelName){
        if(mappedParams == null){
            __wrappedInstance.setDefaultConfig(mappedParams, provider)
        }
        def displayName = null
        if(mappedParams.containsKey("displayName")){
            displayName = mappedParams.displayName
        }
        __wrappedInstance.setDefaultConfig(provider, baseUrl, apiKey, modelName, displayName)
    }
    /**
     * Reset the default AI configuration previously set via ai.setDefaultConfig
     * to use the first one defined in Options > Artificial Intelligence
     */
    public void resetDefaultConfig(){
        __wrappedInstance.resetDefaultConfig()
    }
    /** Returns a list of all available AI configuration names */
    public List<String> getConfigNames(){
        return __wrappedInstance.getConfigNames()
    }
    /**
     * Sends a message to a LLM model and returns the response
     * 
     * @param message       The message to send to the LLM
     * @param configName    The name of an AI configuration as set in Options > Artificial Intelligence. Defaults to the first one or to the one set via ai.setDefaultConfig
     * @param temperature   Optionally controls the randomness of the generated text
     * @param topP          Optionally controls how many of the most likely tokens should be considered
     * @param topK          Optionally controls which tokens should be considered
     * @param frequencyPenalty  Optionally prevents the LLM from reusing words
     * @param presencePenalty   Optionally prevents the LLM from repeating words
     * @param maxOutputTokens   Optional maximum number of tokens that can be generated in the response
     * @param stopSequences     Optionally prevents LLM from generating more text after that string appears
     * @param timeoutMs         How long to wait for a response from the LLM
     */
    public String ask(String message, String configName=null, Double temperature=null, Double topP=null, Integer topK=null, Double frequencyPenalty=null, Double presencePenalty=null, Integer maxOutputTokens=null, Object stopSequences=null, Integer timeoutMs=null){
        return __wrappedInstance.ask(message, configName, temperature, topP, topK, frequencyPenalty, presencePenalty, maxOutputTokens, stopSequences, timeoutMs)
    }
    /**
     * Sends a message to a LLM model and returns the response
     * 
     * @param message       The message to send to the LLM
     * @param configName    The name of an AI configuration as set in Options > Artificial Intelligence. Defaults to the first one or to the one set via ai.setDefaultConfig
     * @param temperature   Optionally controls the randomness of the generated text
     * @param topP          Optionally controls how many of the most likely tokens should be considered
     * @param topK          Optionally controls which tokens should be considered
     * @param frequencyPenalty  Optionally prevents the LLM from reusing words
     * @param presencePenalty   Optionally prevents the LLM from repeating words
     * @param maxOutputTokens   Optional maximum number of tokens that can be generated in the response
     * @param stopSequences     Optionally prevents LLM from generating more text after that string appears
     * @param timeoutMs         How long to wait for a response from the LLM
     */
    public String ask(Map mappedParams, String message){
        def configName = null
        if(mappedParams.containsKey("configName")){
            configName = mappedParams.configName
        }
        def temperature = null
        if(mappedParams.containsKey("temperature")){
            temperature = mappedParams.temperature
        }
        def topP = null
        if(mappedParams.containsKey("topP")){
            topP = mappedParams.topP
        }
        def topK = null
        if(mappedParams.containsKey("topK")){
            topK = mappedParams.topK
        }
        def frequencyPenalty = null
        if(mappedParams.containsKey("frequencyPenalty")){
            frequencyPenalty = mappedParams.frequencyPenalty
        }
        def presencePenalty = null
        if(mappedParams.containsKey("presencePenalty")){
            presencePenalty = mappedParams.presencePenalty
        }
        def maxOutputTokens = null
        if(mappedParams.containsKey("maxOutputTokens")){
            maxOutputTokens = mappedParams.maxOutputTokens
        }
        def stopSequences = null
        if(mappedParams.containsKey("stopSequences")){
            stopSequences = mappedParams.stopSequences
        }
        def timeoutMs = null
        if(mappedParams.containsKey("timeoutMs")){
            timeoutMs = mappedParams.timeoutMs
        }
        return __wrappedInstance.ask(message, configName, temperature, topP, topK, frequencyPenalty, presencePenalty, maxOutputTokens, stopSequences, timeoutMs)
    }
    /**
     * Adds a custom model to the list of defined AI configurations
     * 
     * @param name The AI configuration name under which the custom model can be referenced
     * @param responseFunction A function which receives the query -
     * its first parameter is the request itself, an optional second parameter holds the request parameters
     */
    public void addCustomModel(String name, Object responseFunction){
        __wrappedInstance.addCustomModel(name, responseFunction)
    }
    /**
     * Removes the custom model from the list of defined models
     * @param name The name under which the custom model was registered
     */
    public void removeCustomModel(String name){
        __wrappedInstance.removeCustomModel(name)
    }
}
